<?php
// This file was auto-generated from sdk-root/src/data/apigateway/2015-07-09/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Amazon API Gateway</fullname> <p>Amazon API Gateway helps developers deliver robust, secure, and scalable mobile and web application back ends. API Gateway allows developers to securely connect mobile and web applications to APIs that run on Lambda, Amazon EC2, or other publicly addressable web services that are hosted outside of AWS.</p>', 'operations' => [ 'CreateApiKey' => '<p>Create an ApiKey resource. </p>', 'CreateAuthorizer' => '<p>Adds a new Authorizer resource to an existing RestApi resource.</p>', 'CreateBasePathMapping' => '<p>Creates a new BasePathMapping resource.</p>', 'CreateDeployment' => '<p>Creates a Deployment resource, which makes a specified RestApi callable over the internet.</p>', 'CreateDocumentationPart' => '<p>Creates a documentation part.</p>', 'CreateDocumentationVersion' => '<p>Creates a documentation version</p>', 'CreateDomainName' => '<p>Creates a new domain name.</p>', 'CreateModel' => '<p>Adds a new Model resource to an existing RestApi resource.</p>', 'CreateRequestValidator' => '<p>Creates a RequestValidator of a given RestApi.</p>', 'CreateResource' => '<p>Creates a Resource resource.</p>', 'CreateRestApi' => '<p>Creates a new RestApi resource.</p>', 'CreateStage' => '<p>Creates a new Stage resource that references a pre-existing Deployment for the API. </p>', 'CreateUsagePlan' => '<p>Creates a usage plan with the throttle and quota limits, as well as the associated API stages, specified in the payload. </p>', 'CreateUsagePlanKey' => '<p>Creates a usage plan key for adding an existing API key to a usage plan.</p>', 'CreateVpcLink' => '<p>Creates a VPC link, under the caller\'s account in a selected region, in an asynchronous operation that typically takes 2-4 minutes to complete and become operational. The caller must have permissions to create and update VPC Endpoint services.</p>', 'DeleteApiKey' => '<p>Deletes the ApiKey resource.</p>', 'DeleteAuthorizer' => '<p>Deletes an existing Authorizer resource.</p>', 'DeleteBasePathMapping' => '<p>Deletes the BasePathMapping resource.</p>', 'DeleteClientCertificate' => '<p>Deletes the ClientCertificate resource.</p>', 'DeleteDeployment' => '<p>Deletes a Deployment resource. Deleting a deployment will only succeed if there are no Stage resources associated with it.</p>', 'DeleteDocumentationPart' => '<p>Deletes a documentation part</p>', 'DeleteDocumentationVersion' => '<p>Deletes a documentation version.</p>', 'DeleteDomainName' => '<p>Deletes the DomainName resource.</p>', 'DeleteGatewayResponse' => '<p>Clears any customization of a GatewayResponse of a specified response type on the given RestApi and resets it with the default settings.</p>', 'DeleteIntegration' => '<p>Represents a delete integration.</p>', 'DeleteIntegrationResponse' => '<p>Represents a delete integration response.</p>', 'DeleteMethod' => '<p>Deletes an existing Method resource.</p>', 'DeleteMethodResponse' => '<p>Deletes an existing MethodResponse resource.</p>', 'DeleteModel' => '<p>Deletes a model.</p>', 'DeleteRequestValidator' => '<p>Deletes a RequestValidator of a given RestApi.</p>', 'DeleteResource' => '<p>Deletes a Resource resource.</p>', 'DeleteRestApi' => '<p>Deletes the specified API.</p>', 'DeleteStage' => '<p>Deletes a Stage resource.</p>', 'DeleteUsagePlan' => '<p>Deletes a usage plan of a given plan Id.</p>', 'DeleteUsagePlanKey' => '<p>Deletes a usage plan key and remove the underlying API key from the associated usage plan.</p>', 'DeleteVpcLink' => '<p>Deletes an existing VpcLink of a specified identifier.</p>', 'FlushStageAuthorizersCache' => '<p>Flushes all authorizer cache entries on a stage.</p>', 'FlushStageCache' => '<p>Flushes a stage\'s cache.</p>', 'GenerateClientCertificate' => '<p>Generates a ClientCertificate resource.</p>', 'GetAccount' => '<p>Gets information about the current Account resource.</p>', 'GetApiKey' => '<p>Gets information about the current ApiKey resource.</p>', 'GetApiKeys' => '<p>Gets information about the current ApiKeys resource.</p>', 'GetAuthorizer' => '<p>Describe an existing Authorizer resource.</p>', 'GetAuthorizers' => '<p>Describe an existing Authorizers resource.</p>', 'GetBasePathMapping' => '<p>Describe a BasePathMapping resource.</p>', 'GetBasePathMappings' => '<p>Represents a collection of BasePathMapping resources.</p>', 'GetClientCertificate' => '<p>Gets information about the current ClientCertificate resource.</p>', 'GetClientCertificates' => '<p>Gets a collection of ClientCertificate resources.</p>', 'GetDeployment' => '<p>Gets information about a Deployment resource.</p>', 'GetDeployments' => '<p>Gets information about a Deployments collection.</p>', 'GetDocumentationPart' => '<p>Gets a documentation part.</p>', 'GetDocumentationParts' => '<p>Gets documentation parts.</p>', 'GetDocumentationVersion' => '<p>Gets a documentation version.</p>', 'GetDocumentationVersions' => '<p>Gets documentation versions.</p>', 'GetDomainName' => '<p>Represents a domain name that is contained in a simpler, more intuitive URL that can be called.</p>', 'GetDomainNames' => '<p>Represents a collection of DomainName resources.</p>', 'GetExport' => '<p>Exports a deployed version of a RestApi in a specified format.</p>', 'GetGatewayResponse' => '<p>Gets a GatewayResponse of a specified response type on the given RestApi.</p>', 'GetGatewayResponses' => '<p>Gets the GatewayResponses collection on the given RestApi. If an API developer has not added any definitions for gateway responses, the result will be the API Gateway-generated default GatewayResponses collection for the supported response types.</p>', 'GetIntegration' => '<p>Get the integration settings.</p>', 'GetIntegrationResponse' => '<p>Represents a get integration response.</p>', 'GetMethod' => '<p>Describe an existing Method resource.</p>', 'GetMethodResponse' => '<p>Describes a MethodResponse resource.</p>', 'GetModel' => '<p>Describes an existing model defined for a RestApi resource.</p>', 'GetModelTemplate' => '<p>Generates a sample mapping template that can be used to transform a payload into the structure of a model.</p>', 'GetModels' => '<p>Describes existing Models defined for a RestApi resource.</p>', 'GetRequestValidator' => '<p>Gets a RequestValidator of a given RestApi.</p>', 'GetRequestValidators' => '<p>Gets the RequestValidators collection of a given RestApi.</p>', 'GetResource' => '<p>Lists information about a resource.</p>', 'GetResources' => '<p>Lists information about a collection of Resource resources.</p>', 'GetRestApi' => '<p>Lists the RestApi resource in the collection.</p>', 'GetRestApis' => '<p>Lists the RestApis resources for your collection.</p>', 'GetSdk' => '<p>Generates a client SDK for a RestApi and Stage.</p>', 'GetSdkType' => '<p>Gets an SDK type.</p>', 'GetSdkTypes' => '<p>Gets SDK types</p>', 'GetStage' => '<p>Gets information about a Stage resource.</p>', 'GetStages' => '<p>Gets information about one or more Stage resources.</p>', 'GetTags' => '<p>Gets the Tags collection for a given resource.</p>', 'GetUsage' => '<p>Gets the usage data of a usage plan in a specified time interval.</p>', 'GetUsagePlan' => '<p>Gets a usage plan of a given plan identifier.</p>', 'GetUsagePlanKey' => '<p>Gets a usage plan key of a given key identifier.</p>', 'GetUsagePlanKeys' => '<p>Gets all the usage plan keys representing the API keys added to a specified usage plan.</p>', 'GetUsagePlans' => '<p>Gets all the usage plans of the caller\'s account.</p>', 'GetVpcLink' => '<p>Gets a specified VPC link under the caller\'s account in a region.</p>', 'GetVpcLinks' => '<p>Gets the VpcLinks collection under the caller\'s account in a selected region.</p>', 'ImportApiKeys' => '<p>Import API keys from an external source, such as a CSV-formatted file.</p>', 'ImportDocumentationParts' => '<p>Imports documentation parts</p>', 'ImportRestApi' => '<p>A feature of the API Gateway control service for creating a new API from an external API definition file.</p>', 'PutGatewayResponse' => '<p>Creates a customization of a GatewayResponse of a specified response type and status code on the given RestApi.</p>', 'PutIntegration' => '<p>Sets up a method\'s integration.</p>', 'PutIntegrationResponse' => '<p>Represents a put integration.</p>', 'PutMethod' => '<p>Add a method to an existing Resource resource.</p>', 'PutMethodResponse' => '<p>Adds a MethodResponse to an existing Method resource.</p>', 'PutRestApi' => '<p>A feature of the API Gateway control service for updating an existing API with an input of external API definitions. The update can take the form of merging the supplied definition into the existing API or overwriting the existing API.</p>', 'TagResource' => '<p>Adds or updates a tag on a given resource.</p>', 'TestInvokeAuthorizer' => '<p>Simulate the execution of an Authorizer in your RestApi with headers, parameters, and an incoming request body.</p>', 'TestInvokeMethod' => '<p>Simulate the invocation of a Method in your RestApi with headers, parameters, and an incoming request body.</p>', 'UntagResource' => '<p>Removes a tag from a given resource.</p>', 'UpdateAccount' => '<p>Changes information about the current Account resource.</p>', 'UpdateApiKey' => '<p>Changes information about an ApiKey resource.</p>', 'UpdateAuthorizer' => '<p>Updates an existing Authorizer resource.</p>', 'UpdateBasePathMapping' => '<p>Changes information about the BasePathMapping resource.</p>', 'UpdateClientCertificate' => '<p>Changes information about an ClientCertificate resource.</p>', 'UpdateDeployment' => '<p>Changes information about a Deployment resource.</p>', 'UpdateDocumentationPart' => '<p>Updates a documentation part.</p>', 'UpdateDocumentationVersion' => '<p>Updates a documentation version.</p>', 'UpdateDomainName' => '<p>Changes information about the DomainName resource.</p>', 'UpdateGatewayResponse' => '<p>Updates a GatewayResponse of a specified response type on the given RestApi.</p>', 'UpdateIntegration' => '<p>Represents an update integration.</p>', 'UpdateIntegrationResponse' => '<p>Represents an update integration response.</p>', 'UpdateMethod' => '<p>Updates an existing Method resource.</p>', 'UpdateMethodResponse' => '<p>Updates an existing MethodResponse resource.</p>', 'UpdateModel' => '<p>Changes information about a model. The maximum size of the model is 400 KB.</p>', 'UpdateRequestValidator' => '<p>Updates a RequestValidator of a given RestApi.</p>', 'UpdateResource' => '<p>Changes information about a Resource resource.</p>', 'UpdateRestApi' => '<p>Changes information about the specified API.</p>', 'UpdateStage' => '<p>Changes information about a Stage resource.</p>', 'UpdateUsage' => '<p>Grants a temporary extension to the remaining quota of a usage plan associated with a specified API key.</p>', 'UpdateUsagePlan' => '<p>Updates a usage plan of a given plan Id.</p>', 'UpdateVpcLink' => '<p>Updates an existing VpcLink of a specified identifier.</p>', ], 'shapes' => [ 'AccessLogSettings' => [ 'base' => '<p>Access log settings, including the access log format and access log destination ARN.</p>', 'refs' => [ 'Stage$accessLogSettings' => '<p>Settings for logging access in this stage.</p>', ], ], 'Account' => [ 'base' => '<p>Represents an AWS account that is associated with API Gateway.</p>', 'refs' => [], ], 'ApiKey' => [ 'base' => '<p>A resource that can be distributed to callers for executing Method resources that require an API key. API keys can be mapped to any Stage on any RestApi, which indicates that the callers with the API key can make requests to that stage.</p>', 'refs' => [ 'ListOfApiKey$member' => NULL, ], ], 'ApiKeyIds' => [ 'base' => '<p>The identifier of an ApiKey used in a UsagePlan.</p>', 'refs' => [], ], 'ApiKeySourceType' => [ 'base' => NULL, 'refs' => [ 'CreateRestApiRequest$apiKeySource' => '<p>The source of the API key for metering requests according to a usage plan. Valid values are: <code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request. <code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom authorizer.</p>', 'RestApi$apiKeySource' => '<p>The source of the API key for metering requests according to a usage plan. Valid values are: &gt;<code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request. <code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom authorizer.</p>', ], ], 'ApiKeys' => [ 'base' => '<p>Represents a collection of API keys as represented by an ApiKeys resource.</p>', 'refs' => [], ], 'ApiKeysFormat' => [ 'base' => NULL, 'refs' => [ 'ImportApiKeysRequest$format' => '<p>A query parameter to specify the input format to imported API keys. Currently, only the <code>csv</code> format is supported.</p>', ], ], 'ApiStage' => [ 'base' => '<p>API stage name of the associated API stage in a usage plan.</p>', 'refs' => [ 'ListOfApiStage$member' => NULL, ], ], 'Authorizer' => [ 'base' => '<p>Represents an authorization layer for methods. If enabled on a method, API Gateway will activate the authorizer when a client calls the method.</p>', 'refs' => [ 'ListOfAuthorizer$member' => NULL, ], ], 'AuthorizerType' => [ 'base' => '<p>The authorizer type. Valid values are <code>TOKEN</code> for a Lambda function using a single authorization token submitted in a custom header, <code>REQUEST</code> for a Lambda function using incoming request parameters, and <code>COGNITO_USER_POOLS</code> for using an Amazon Cognito user pool.</p>', 'refs' => [ 'Authorizer$type' => '<p>The authorizer type. Valid values are <code>TOKEN</code> for a Lambda function using a single authorization token submitted in a custom header, <code>REQUEST</code> for a Lambda function using incoming request parameters, and <code>COGNITO_USER_POOLS</code> for using an Amazon Cognito user pool.</p>', 'CreateAuthorizerRequest$type' => '<p>The authorizer type. Valid values are <code>TOKEN</code> for a Lambda function using a single authorization token submitted in a custom header, <code>REQUEST</code> for a Lambda function using incoming request parameters, and <code>COGNITO_USER_POOLS</code> for using an Amazon Cognito user pool.</p>', ], ], 'Authorizers' => [ 'base' => '<p>Represents a collection of Authorizer resources.</p>', 'refs' => [], ], 'BadRequestException' => [ 'base' => '<p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>', 'refs' => [], ], 'BasePathMapping' => [ 'base' => '<p>Represents the base path that callers of the API must provide as part of the URL after the domain name.</p>', 'refs' => [ 'ListOfBasePathMapping$member' => NULL, ], ], 'BasePathMappings' => [ 'base' => '<p>Represents a collection of BasePathMapping resources.</p>', 'refs' => [], ], 'Blob' => [ 'base' => NULL, 'refs' => [ 'ExportResponse$body' => '<p>The binary blob response to GetExport, which contains the export.</p>', 'ImportApiKeysRequest$body' => '<p>The payload of the POST request to import API keys. For the payload format, see API Key File Format.</p>', 'ImportDocumentationPartsRequest$body' => '<p>Raw byte array representing the to-be-imported documentation parts. To import from an OpenAPI file, this is a JSON object.</p>', 'ImportRestApiRequest$body' => '<p>The POST request body containing external API definitions. Currently, only OpenAPI definition JSON/YAML files are supported. The maximum size of the API definition file is 6MB.</p>', 'PutRestApiRequest$body' => '<p>The PUT request body containing external API definitions. Currently, only OpenAPI definition JSON/YAML files are supported. The maximum size of the API definition file is 6MB.</p>', 'SdkResponse$body' => '<p>The binary blob response to GetSdk, which contains the generated SDK.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'ApiKey$enabled' => '<p>Specifies whether the API Key can be used by callers.</p>', 'CanarySettings$useStageCache' => '<p>A Boolean flag to indicate whether the canary deployment uses the stage cache or not.</p>', 'CreateApiKeyRequest$enabled' => '<p>Specifies whether the ApiKey can be used by callers.</p>', 'CreateApiKeyRequest$generateDistinctId' => '<p>Specifies whether (<code>true</code>) or not (<code>false</code>) the key identifier is distinct from the created API key value. This parameter is deprecated and should not be used.</p>', 'CreateRequestValidatorRequest$validateRequestBody' => '<p>A Boolean flag to indicate whether to validate request body according to the configured model schema for the method (<code>true</code>) or not (<code>false</code>).</p>', 'CreateRequestValidatorRequest$validateRequestParameters' => '<p>A Boolean flag to indicate whether to validate request parameters, <code>true</code>, or not <code>false</code>.</p>', 'CreateRestApiRequest$disableExecuteApiEndpoint' => '<p>Specifies whether clients can invoke your API by using the default <code>execute-api</code> endpoint. By default, clients can invoke your API with the default <code>https://{api_id}.execute-api.{region}.amazonaws.com</code> endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint</p>', 'CreateStageRequest$cacheClusterEnabled' => '<p>Whether cache clustering is enabled for the stage.</p>', 'CreateStageRequest$tracingEnabled' => '<p>Specifies whether active tracing with X-ray is enabled for the Stage.</p>', 'DeploymentCanarySettings$useStageCache' => '<p>A Boolean flag to indicate whether the canary release deployment uses the stage cache or not.</p>', 'GatewayResponse$defaultResponse' => '<p>A Boolean flag to indicate whether this GatewayResponse is the default gateway response (<code>true</code>) or not (<code>false</code>). A default gateway response is one generated by API Gateway without any customization by an API developer. </p>', 'GetModelRequest$flatten' => '<p>A query parameter of a Boolean value to resolve (<code>true</code>) all external model references and returns a flattened model schema or not (<code>false</code>) The default is <code>false</code>.</p>', 'ImportApiKeysRequest$failOnWarnings' => '<p>A query parameter to indicate whether to rollback ApiKey importation (<code>true</code>) or not (<code>false</code>) when error is encountered.</p>', 'ImportDocumentationPartsRequest$failOnWarnings' => '<p>A query parameter to specify whether to rollback the documentation importation (<code>true</code>) or not (<code>false</code>) when a warning is encountered. The default value is <code>false</code>.</p>', 'ImportRestApiRequest$failOnWarnings' => '<p>A query parameter to indicate whether to rollback the API creation (<code>true</code>) or not (<code>false</code>) when a warning is encountered. The default value is <code>false</code>.</p>', 'MethodSetting$metricsEnabled' => '<p>Specifies whether Amazon CloudWatch metrics are enabled for this method.</p>', 'MethodSetting$dataTraceEnabled' => '<p>Specifies whether data trace logging is enabled for this method, which affects the log entries pushed to Amazon CloudWatch Logs. This can be useful to troubleshoot APIs, but can result in logging sensitive data. We recommend that you don\'t enable this option for production APIs.</p>', 'MethodSetting$cachingEnabled' => '<p>Specifies whether responses should be cached and returned for requests. A cache cluster must be enabled on the stage for responses to be cached.</p>', 'MethodSetting$cacheDataEncrypted' => '<p>Specifies whether the cached responses are encrypted.</p>', 'MethodSetting$requireAuthorizationForCacheControl' => '<p>Specifies whether authorization is required for a cache invalidation request.</p>', 'MethodSnapshot$apiKeyRequired' => '<p>Specifies whether the method requires a valid ApiKey.</p>', 'PutMethodRequest$apiKeyRequired' => '<p>Specifies whether the method required a valid ApiKey.</p>', 'PutRestApiRequest$failOnWarnings' => '<p>A query parameter to indicate whether to rollback the API update (<code>true</code>) or not (<code>false</code>) when a warning is encountered. The default value is <code>false</code>.</p>', 'RequestValidator$validateRequestBody' => '<p>A Boolean flag to indicate whether to validate a request body according to the configured Model schema.</p>', 'RequestValidator$validateRequestParameters' => '<p>A Boolean flag to indicate whether to validate request parameters (<code>true</code>) or not (<code>false</code>).</p>', 'RestApi$disableExecuteApiEndpoint' => '<p>Specifies whether clients can invoke your API by using the default <code>execute-api</code> endpoint. By default, clients can invoke your API with the default <code>https://{api_id}.execute-api.{region}.amazonaws.com</code> endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.</p>', 'SdkConfigurationProperty$required' => '<p>A boolean flag of an SdkType configuration property to indicate if the associated SDK configuration property is required (<code>true</code>) or not (<code>false</code>).</p>', 'Stage$cacheClusterEnabled' => '<p>Specifies whether a cache cluster is enabled for the stage. To activate a method-level cache, set <code>CachingEnabled</code> to <code>true</code> for a method. </p>', 'Stage$tracingEnabled' => '<p>Specifies whether active tracing with X-ray is enabled for the Stage.</p>', 'TlsConfig$insecureSkipVerification' => '<p>Specifies whether or not API Gateway skips verification that the certificate for an integration endpoint is issued by a supported certificate authority. This isn’t recommended, but it enables you to use certificates that are signed by private certificate authorities, or certificates that are self-signed. If enabled, API Gateway still performs basic certificate validation, which includes checking the certificate\'s expiration date, hostname, and presence of a root certificate authority. Supported only for <code>HTTP</code> and <code>HTTP_PROXY</code> integrations.</p> <important> <p>Enabling <code>insecureSkipVerification</code> isn\'t recommended, especially for integrations with public HTTPS endpoints. If you enable <code>insecureSkipVerification</code>, you increase the risk of man-in-the-middle attacks.</p> </important>', ], ], 'CacheClusterSize' => [ 'base' => '<p>Returns the size of the CacheCluster.</p>', 'refs' => [ 'CreateDeploymentRequest$cacheClusterSize' => '<p>The stage\'s cache capacity in GB. For more information about choosing a cache size, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-caching.html">Enabling API caching to enhance responsiveness</a>.</p>', 'CreateStageRequest$cacheClusterSize' => '<p>The stage\'s cache capacity in GB. For more information about choosing a cache size, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-caching.html">Enabling API caching to enhance responsiveness</a>.</p>', 'Stage$cacheClusterSize' => '<p>The stage\'s cache capacity in GB. For more information about choosing a cache size, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-caching.html">Enabling API caching to enhance responsiveness</a>.</p>', ], ], 'CacheClusterStatus' => [ 'base' => '<p>Returns the status of the CacheCluster.</p>', 'refs' => [ 'Stage$cacheClusterStatus' => '<p>The status of the cache cluster for the stage, if enabled.</p>', ], ], 'CanarySettings' => [ 'base' => '<p>Configuration settings of a canary deployment.</p>', 'refs' => [ 'CreateStageRequest$canarySettings' => '<p>The canary deployment settings of this stage.</p>', 'Stage$canarySettings' => '<p>Settings for the canary deployment in this stage.</p>', ], ], 'ClientCertificate' => [ 'base' => '<p>Represents a client certificate used to configure client-side SSL authentication while sending requests to the integration endpoint.</p>', 'refs' => [ 'ListOfClientCertificate$member' => NULL, ], ], 'ClientCertificates' => [ 'base' => '<p>Represents a collection of ClientCertificate resources.</p>', 'refs' => [], ], 'ConflictException' => [ 'base' => '<p>The request configuration has conflicts. For details, see the accompanying error message.</p>', 'refs' => [], ], 'ConnectionType' => [ 'base' => NULL, 'refs' => [ 'Integration$connectionType' => '<p>The type of the network connection to the integration endpoint. The valid value is <code>INTERNET</code> for connections through the public routable internet or <code>VPC_LINK</code> for private connections between API Gateway and a network load balancer in a VPC. The default value is <code>INTERNET</code>.</p>', 'PutIntegrationRequest$connectionType' => '<p>The type of the network connection to the integration endpoint. The valid value is <code>INTERNET</code> for connections through the public routable internet or <code>VPC_LINK</code> for private connections between API Gateway and a network load balancer in a VPC. The default value is <code>INTERNET</code>.</p>', ], ], 'ContentHandlingStrategy' => [ 'base' => NULL, 'refs' => [ 'Integration$contentHandling' => '<p>Specifies how to handle request payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p> <p>If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the <code>passthroughBehavior</code> is configured to support payload pass-through.</p>', 'IntegrationResponse$contentHandling' => '<p>Specifies how to handle response payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p> <p>If this property is not defined, the response payload will be passed through from the integration response to the method response without modification.</p>', 'PutIntegrationRequest$contentHandling' => '<p>Specifies how to handle request payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p> <p>If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the <code>passthroughBehavior</code> is configured to support payload pass-through.</p>', 'PutIntegrationResponseRequest$contentHandling' => '<p>Specifies how to handle response payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p> <p>If this property is not defined, the response payload will be passed through from the integration response to the method response without modification.</p>', ], ], 'CreateApiKeyRequest' => [ 'base' => '<p>Request to create an ApiKey resource.</p>', 'refs' => [], ], 'CreateAuthorizerRequest' => [ 'base' => '<p>Request to add a new Authorizer to an existing RestApi resource.</p>', 'refs' => [], ], 'CreateBasePathMappingRequest' => [ 'base' => '<p>Requests API Gateway to create a new BasePathMapping resource.</p>', 'refs' => [], ], 'CreateDeploymentRequest' => [ 'base' => '<p>Requests API Gateway to create a Deployment resource.</p>', 'refs' => [], ], 'CreateDocumentationPartRequest' => [ 'base' => '<p>Creates a new documentation part of a given API.</p>', 'refs' => [], ], 'CreateDocumentationVersionRequest' => [ 'base' => '<p>Creates a new documentation version of a given API.</p>', 'refs' => [], ], 'CreateDomainNameRequest' => [ 'base' => '<p>A request to create a new domain name.</p>', 'refs' => [], ], 'CreateModelRequest' => [ 'base' => '<p>Request to add a new Model to an existing RestApi resource.</p>', 'refs' => [], ], 'CreateRequestValidatorRequest' => [ 'base' => '<p>Creates a RequestValidator of a given RestApi.</p>', 'refs' => [], ], 'CreateResourceRequest' => [ 'base' => '<p>Requests API Gateway to create a Resource resource.</p>', 'refs' => [], ], 'CreateRestApiRequest' => [ 'base' => '<p>The POST Request to add a new RestApi resource to your collection.</p>', 'refs' => [], ], 'CreateStageRequest' => [ 'base' => '<p>Requests API Gateway to create a Stage resource.</p>', 'refs' => [], ], 'CreateUsagePlanKeyRequest' => [ 'base' => '<p>The POST request to create a usage plan key for adding an existing API key to a usage plan.</p>', 'refs' => [], ], 'CreateUsagePlanRequest' => [ 'base' => '<p>The POST request to create a usage plan with the name, description, throttle limits and quota limits, as well as the associated API stages, specified in the payload.</p>', 'refs' => [], ], 'CreateVpcLinkRequest' => [ 'base' => '<p>Creates a VPC link, under the caller\'s account in a selected region, in an asynchronous operation that typically takes 2-4 minutes to complete and become operational. The caller must have permissions to create and update VPC Endpoint services.</p>', 'refs' => [], ], 'DeleteApiKeyRequest' => [ 'base' => '<p>A request to delete the ApiKey resource.</p>', 'refs' => [], ], 'DeleteAuthorizerRequest' => [ 'base' => '<p>Request to delete an existing Authorizer resource.</p>', 'refs' => [], ], 'DeleteBasePathMappingRequest' => [ 'base' => '<p>A request to delete the BasePathMapping resource.</p>', 'refs' => [], ], 'DeleteClientCertificateRequest' => [ 'base' => '<p>A request to delete the ClientCertificate resource.</p>', 'refs' => [], ], 'DeleteDeploymentRequest' => [ 'base' => '<p>Requests API Gateway to delete a Deployment resource.</p>', 'refs' => [], ], 'DeleteDocumentationPartRequest' => [ 'base' => '<p>Deletes an existing documentation part of an API.</p>', 'refs' => [], ], 'DeleteDocumentationVersionRequest' => [ 'base' => '<p>Deletes an existing documentation version of an API.</p>', 'refs' => [], ], 'DeleteDomainNameRequest' => [ 'base' => '<p>A request to delete the DomainName resource.</p>', 'refs' => [], ], 'DeleteGatewayResponseRequest' => [ 'base' => '<p>Clears any customization of a GatewayResponse of a specified response type on the given RestApi and resets it with the default settings.</p>', 'refs' => [], ], 'DeleteIntegrationRequest' => [ 'base' => '<p>Represents a delete integration request.</p>', 'refs' => [], ], 'DeleteIntegrationResponseRequest' => [ 'base' => '<p>Represents a delete integration response request.</p>', 'refs' => [], ], 'DeleteMethodRequest' => [ 'base' => '<p>Request to delete an existing Method resource.</p>', 'refs' => [], ], 'DeleteMethodResponseRequest' => [ 'base' => '<p>A request to delete an existing MethodResponse resource.</p>', 'refs' => [], ], 'DeleteModelRequest' => [ 'base' => '<p>Request to delete an existing model in an existing RestApi resource.</p>', 'refs' => [], ], 'DeleteRequestValidatorRequest' => [ 'base' => '<p>Deletes a specified RequestValidator of a given RestApi.</p>', 'refs' => [], ], 'DeleteResourceRequest' => [ 'base' => '<p>Request to delete a Resource.</p>', 'refs' => [], ], 'DeleteRestApiRequest' => [ 'base' => '<p>Request to delete the specified API from your collection.</p>', 'refs' => [], ], 'DeleteStageRequest' => [ 'base' => '<p>Requests API Gateway to delete a Stage resource.</p>', 'refs' => [], ], 'DeleteUsagePlanKeyRequest' => [ 'base' => '<p>The DELETE request to delete a usage plan key and remove the underlying API key from the associated usage plan.</p>', 'refs' => [], ], 'DeleteUsagePlanRequest' => [ 'base' => '<p>The DELETE request to delete a usage plan of a given plan Id.</p>', 'refs' => [], ], 'DeleteVpcLinkRequest' => [ 'base' => '<p>Deletes an existing VpcLink of a specified identifier.</p>', 'refs' => [], ], 'Deployment' => [ 'base' => '<p>An immutable representation of a RestApi resource that can be called by users using Stages. A deployment must be associated with a Stage for it to be callable over the Internet.</p>', 'refs' => [ 'ListOfDeployment$member' => NULL, ], ], 'DeploymentCanarySettings' => [ 'base' => '<p>The input configuration for a canary deployment.</p>', 'refs' => [ 'CreateDeploymentRequest$canarySettings' => '<p>The input configuration for the canary deployment when the deployment is a canary release deployment. </p>', ], ], 'Deployments' => [ 'base' => '<p>Represents a collection resource that contains zero or more references to your existing deployments, and links that guide you on how to interact with your collection. The collection offers a paginated view of the contained deployments.</p>', 'refs' => [], ], 'DocumentationPart' => [ 'base' => '<p>A documentation part for a targeted API entity.</p>', 'refs' => [ 'ListOfDocumentationPart$member' => NULL, ], ], 'DocumentationPartIds' => [ 'base' => '<p>A collection of the imported DocumentationPart identifiers.</p>', 'refs' => [], ], 'DocumentationPartLocation' => [ 'base' => '<p>Specifies the target API entity to which the documentation applies.</p>', 'refs' => [ 'CreateDocumentationPartRequest$location' => '<p>The location of the targeted API entity of the to-be-created documentation part.</p>', 'DocumentationPart$location' => '<p>The location of the API entity to which the documentation applies. Valid fields depend on the targeted API entity type. All the valid location fields are not required. If not explicitly specified, a valid location field is treated as a wildcard and associated documentation content may be inherited by matching entities, unless overridden.</p>', ], ], 'DocumentationPartLocationStatusCode' => [ 'base' => NULL, 'refs' => [ 'DocumentationPartLocation$statusCode' => '<p>The HTTP status code of a response. It is a valid field for the API entity types of <code>RESPONSE</code>, <code>RESPONSE_HEADER</code>, and <code>RESPONSE_BODY</code>. The default value is <code>*</code> for any status code. When an applicable child entity inherits the content of an entity of the same type with more general specifications of the other <code>location</code> attributes, the child entity\'s <code>statusCode</code> attribute must match that of the parent entity exactly.</p>', ], ], 'DocumentationPartType' => [ 'base' => NULL, 'refs' => [ 'DocumentationPartLocation$type' => '<p>The type of API entity to which the documentation content applies. Valid values are <code>API</code>, <code>AUTHORIZER</code>, <code>MODEL</code>, <code>RESOURCE</code>, <code>METHOD</code>, <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>, <code>REQUEST_HEADER</code>, <code>REQUEST_BODY</code>, <code>RESPONSE</code>, <code>RESPONSE_HEADER</code>, and <code>RESPONSE_BODY</code>. Content inheritance does not apply to any entity of the <code>API</code>, <code>AUTHORIZER</code>, <code>METHOD</code>, <code>MODEL</code>, <code>REQUEST_BODY</code>, or <code>RESOURCE</code> type.</p>', 'GetDocumentationPartsRequest$type' => '<p>The type of API entities of the to-be-retrieved documentation parts. </p>', ], ], 'DocumentationParts' => [ 'base' => '<p>The collection of documentation parts of an API.</p>', 'refs' => [], ], 'DocumentationVersion' => [ 'base' => '<p>A snapshot of the documentation of an API.</p>', 'refs' => [ 'ListOfDocumentationVersion$member' => NULL, ], ], 'DocumentationVersions' => [ 'base' => '<p>The collection of documentation snapshots of an API. </p>', 'refs' => [], ], 'DomainName' => [ 'base' => '<p>Represents a custom domain name as a user-friendly host name of an API (RestApi).</p>', 'refs' => [ 'ListOfDomainName$member' => NULL, ], ], 'DomainNameStatus' => [ 'base' => NULL, 'refs' => [ 'DomainName$domainNameStatus' => '<p>The status of the DomainName migration. The valid values are <code>AVAILABLE</code> and <code>UPDATING</code>. If the status is <code>UPDATING</code>, the domain cannot be modified further until the existing operation is complete. If it is <code>AVAILABLE</code>, the domain can be updated.</p>', ], ], 'DomainNames' => [ 'base' => '<p>Represents a collection of DomainName resources.</p>', 'refs' => [], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'CanarySettings$percentTraffic' => '<p>The percent (0-100) of traffic diverted to a canary deployment.</p>', 'DeploymentCanarySettings$percentTraffic' => '<p>The percentage (0.0-100.0) of traffic routed to the canary deployment.</p>', 'MethodSetting$throttlingRateLimit' => '<p>Specifies the throttling rate limit.</p>', 'ThrottleSettings$rateLimit' => '<p>The API target request rate limit.</p>', ], ], 'EndpointConfiguration' => [ 'base' => '<p>The endpoint configuration to indicate the types of endpoints an API (RestApi) or its custom domain name (DomainName) has. </p>', 'refs' => [ 'CreateDomainNameRequest$endpointConfiguration' => '<p>The endpoint configuration of this DomainName showing the endpoint types of the domain name. </p>', 'CreateRestApiRequest$endpointConfiguration' => '<p>The endpoint configuration of this RestApi showing the endpoint types of the API. </p>', 'DomainName$endpointConfiguration' => '<p>The endpoint configuration of this DomainName showing the endpoint types of the domain name. </p>', 'RestApi$endpointConfiguration' => '<p>The endpoint configuration of this RestApi showing the endpoint types of the API. </p>', ], ], 'EndpointType' => [ 'base' => '<p>The endpoint type. The valid values are <code>EDGE</code> for edge-optimized API setup, most suitable for mobile applications; <code>REGIONAL</code> for regional API endpoint setup, most suitable for calling from AWS Region; and <code>PRIVATE</code> for private APIs.</p>', 'refs' => [ 'ListOfEndpointType$member' => NULL, ], ], 'ExportResponse' => [ 'base' => '<p>The binary blob response to GetExport, which contains the generated SDK.</p>', 'refs' => [], ], 'FlushStageAuthorizersCacheRequest' => [ 'base' => '<p>Request to flush authorizer cache entries on a specified stage.</p>', 'refs' => [], ], 'FlushStageCacheRequest' => [ 'base' => '<p>Requests API Gateway to flush a stage\'s cache.</p>', 'refs' => [], ], 'GatewayResponse' => [ 'base' => '<p>A gateway response of a given response type and status code, with optional response parameters and mapping templates.</p>', 'refs' => [ 'ListOfGatewayResponse$member' => NULL, ], ], 'GatewayResponseType' => [ 'base' => NULL, 'refs' => [ 'DeleteGatewayResponseRequest$responseType' => '<p>The response type of the associated GatewayResponse.</p>', 'GatewayResponse$responseType' => '<p>The response type of the associated GatewayResponse.</p>', 'GetGatewayResponseRequest$responseType' => '<p>The response type of the associated GatewayResponse.</p>', 'PutGatewayResponseRequest$responseType' => '<p>The response type of the associated GatewayResponse</p>', 'UpdateGatewayResponseRequest$responseType' => '<p>The response type of the associated GatewayResponse.</p>', ], ], 'GatewayResponses' => [ 'base' => '<p>The collection of the GatewayResponse instances of a RestApi as a <code>responseType</code>-to-GatewayResponse object map of key-value pairs. As such, pagination is not supported for querying this collection.</p>', 'refs' => [], ], 'GenerateClientCertificateRequest' => [ 'base' => '<p>A request to generate a ClientCertificate resource.</p>', 'refs' => [], ], 'GetAccountRequest' => [ 'base' => '<p>Requests API Gateway to get information about the current Account resource.</p>', 'refs' => [], ], 'GetApiKeyRequest' => [ 'base' => '<p>A request to get information about the current ApiKey resource.</p>', 'refs' => [], ], 'GetApiKeysRequest' => [ 'base' => '<p>A request to get information about the current ApiKeys resource.</p>', 'refs' => [], ], 'GetAuthorizerRequest' => [ 'base' => '<p>Request to describe an existing Authorizer resource.</p>', 'refs' => [], ], 'GetAuthorizersRequest' => [ 'base' => '<p>Request to describe an existing Authorizers resource.</p>', 'refs' => [], ], 'GetBasePathMappingRequest' => [ 'base' => '<p>Request to describe a BasePathMapping resource.</p>', 'refs' => [], ], 'GetBasePathMappingsRequest' => [ 'base' => '<p>A request to get information about a collection of BasePathMapping resources.</p>', 'refs' => [], ], 'GetClientCertificateRequest' => [ 'base' => '<p>A request to get information about the current ClientCertificate resource.</p>', 'refs' => [], ], 'GetClientCertificatesRequest' => [ 'base' => '<p>A request to get information about a collection of ClientCertificate resources.</p>', 'refs' => [], ], 'GetDeploymentRequest' => [ 'base' => '<p>Requests API Gateway to get information about a Deployment resource.</p>', 'refs' => [], ], 'GetDeploymentsRequest' => [ 'base' => '<p>Requests API Gateway to get information about a Deployments collection.</p>', 'refs' => [], ], 'GetDocumentationPartRequest' => [ 'base' => '<p>Gets a specified documentation part of a given API.</p>', 'refs' => [], ], 'GetDocumentationPartsRequest' => [ 'base' => '<p>Gets the documentation parts of an API. The result may be filtered by the type, name, or path of API entities (targets).</p>', 'refs' => [], ], 'GetDocumentationVersionRequest' => [ 'base' => '<p>Gets a documentation snapshot of an API.</p>', 'refs' => [], ], 'GetDocumentationVersionsRequest' => [ 'base' => '<p>Gets the documentation versions of an API.</p>', 'refs' => [], ], 'GetDomainNameRequest' => [ 'base' => '<p>Request to get the name of a DomainName resource.</p>', 'refs' => [], ], 'GetDomainNamesRequest' => [ 'base' => '<p>Request to describe a collection of DomainName resources.</p>', 'refs' => [], ], 'GetExportRequest' => [ 'base' => '<p>Request a new export of a RestApi for a particular Stage.</p>', 'refs' => [], ], 'GetGatewayResponseRequest' => [ 'base' => '<p>Gets a GatewayResponse of a specified response type on the given RestApi.</p>', 'refs' => [], ], 'GetGatewayResponsesRequest' => [ 'base' => '<p>Gets the GatewayResponses collection on the given RestApi. If an API developer has not added any definitions for gateway responses, the result will be the API Gateway-generated default GatewayResponses collection for the supported response types.</p>', 'refs' => [], ], 'GetIntegrationRequest' => [ 'base' => '<p>Represents a request to get the integration configuration.</p>', 'refs' => [], ], 'GetIntegrationResponseRequest' => [ 'base' => '<p>Represents a get integration response request.</p>', 'refs' => [], ], 'GetMethodRequest' => [ 'base' => '<p>Request to describe an existing Method resource.</p>', 'refs' => [], ], 'GetMethodResponseRequest' => [ 'base' => '<p>Request to describe a MethodResponse resource.</p>', 'refs' => [], ], 'GetModelRequest' => [ 'base' => '<p>Request to list information about a model in an existing RestApi resource.</p>', 'refs' => [], ], 'GetModelTemplateRequest' => [ 'base' => '<p>Request to generate a sample mapping template used to transform the payload.</p>', 'refs' => [], ], 'GetModelsRequest' => [ 'base' => '<p>Request to list existing Models defined for a RestApi resource.</p>', 'refs' => [], ], 'GetRequestValidatorRequest' => [ 'base' => '<p>Gets a RequestValidator of a given RestApi.</p>', 'refs' => [], ], 'GetRequestValidatorsRequest' => [ 'base' => '<p>Gets the RequestValidators collection of a given RestApi.</p>', 'refs' => [], ], 'GetResourceRequest' => [ 'base' => '<p>Request to list information about a resource.</p>', 'refs' => [], ], 'GetResourcesRequest' => [ 'base' => '<p>Request to list information about a collection of resources.</p>', 'refs' => [], ], 'GetRestApiRequest' => [ 'base' => '<p>The GET request to list an existing RestApi defined for your collection. </p>', 'refs' => [], ], 'GetRestApisRequest' => [ 'base' => '<p>The GET request to list existing RestApis defined for your collection.</p>', 'refs' => [], ], 'GetSdkRequest' => [ 'base' => '<p>Request a new generated client SDK for a RestApi and Stage.</p>', 'refs' => [], ], 'GetSdkTypeRequest' => [ 'base' => '<p>Get an SdkType instance.</p>', 'refs' => [], ], 'GetSdkTypesRequest' => [ 'base' => '<p>Get the SdkTypes collection.</p>', 'refs' => [], ], 'GetStageRequest' => [ 'base' => '<p>Requests API Gateway to get information about a Stage resource.</p>', 'refs' => [], ], 'GetStagesRequest' => [ 'base' => '<p>Requests API Gateway to get information about one or more Stage resources.</p>', 'refs' => [], ], 'GetTagsRequest' => [ 'base' => '<p>Gets the Tags collection for a given resource.</p>', 'refs' => [], ], 'GetUsagePlanKeyRequest' => [ 'base' => '<p>The GET request to get a usage plan key of a given key identifier.</p>', 'refs' => [], ], 'GetUsagePlanKeysRequest' => [ 'base' => '<p>The GET request to get all the usage plan keys representing the API keys added to a specified usage plan.</p>', 'refs' => [], ], 'GetUsagePlanRequest' => [ 'base' => '<p>The GET request to get a usage plan of a given plan identifier.</p>', 'refs' => [], ], 'GetUsagePlansRequest' => [ 'base' => '<p>The GET request to get all the usage plans of the caller\'s account.</p>', 'refs' => [], ], 'GetUsageRequest' => [ 'base' => '<p>The GET request to get the usage data of a usage plan in a specified time interval.</p>', 'refs' => [], ], 'GetVpcLinkRequest' => [ 'base' => '<p>Gets a specified VPC link under the caller\'s account in a region.</p>', 'refs' => [], ], 'GetVpcLinksRequest' => [ 'base' => '<p>Gets the VpcLinks collection under the caller\'s account in a selected region.</p>', 'refs' => [], ], 'ImportApiKeysRequest' => [ 'base' => '<p>The POST request to import API keys from an external source, such as a CSV-formatted file.</p>', 'refs' => [], ], 'ImportDocumentationPartsRequest' => [ 'base' => '<p>Import documentation parts from an external (e.g., OpenAPI) definition file. </p>', 'refs' => [], ], 'ImportRestApiRequest' => [ 'base' => '<p>A POST request to import an API to API Gateway using an input of an API definition file.</p>', 'refs' => [], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'Integration$timeoutInMillis' => '<p>Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds or 29 seconds.</p>', 'MethodSetting$throttlingBurstLimit' => '<p>Specifies the throttling burst limit.</p>', 'MethodSetting$cacheTtlInSeconds' => '<p>Specifies the time to live (TTL), in seconds, for cached responses. The higher the TTL, the longer the response will be cached.</p>', 'QuotaSettings$limit' => '<p>The target maximum number of requests that can be made in a given time period.</p>', 'QuotaSettings$offset' => '<p>The number of requests subtracted from the given limit in the initial time period.</p>', 'TestInvokeAuthorizerResponse$clientStatus' => '<p>The HTTP status code that the client would have received. Value is 0 if the authorizer succeeded.</p>', 'TestInvokeMethodResponse$status' => '<p>The HTTP status code.</p>', 'ThrottleSettings$burstLimit' => '<p>The API target request burst rate limit. This allows more requests through for a period of time than the target rate limit.</p>', ], ], 'Integration' => [ 'base' => '<p>Represents an <code>HTTP</code>, <code>HTTP_PROXY</code>, <code>AWS</code>, <code>AWS_PROXY</code>, or Mock integration.</p>', 'refs' => [ 'Method$methodIntegration' => '<p>Gets the method\'s integration responsible for passing the client-submitted request to the back end and performing necessary transformations to make the request compliant with the back end.</p>', ], ], 'IntegrationResponse' => [ 'base' => '<p>Represents an integration response. The status code must map to an existing MethodResponse, and parameters and templates can be used to transform the back-end response.</p>', 'refs' => [ 'MapOfIntegrationResponse$value' => NULL, ], ], 'IntegrationType' => [ 'base' => '<p>The integration type. The valid value is <code>HTTP</code> for integrating an API method with an HTTP backend; <code>AWS</code> with any Amazon Web Services service endpoints; <code>MOCK</code> for testing without actually invoking the backend; <code>HTTP_PROXY</code> for integrating with the HTTP proxy integration; <code>AWS_PROXY</code> for integrating with the Lambda proxy integration. </p>', 'refs' => [ 'Integration$type' => '<p>Specifies an API method integration type. The valid value is one of the following:</p> <p>For the HTTP and HTTP proxy integrations, each integration can specify a protocol (<code>http/https</code>), port and path. Standard 80 and 443 ports are supported as well as custom ports above 1024. An HTTP or HTTP proxy integration with a <code>connectionType</code> of <code>VPC_LINK</code> is referred to as a private integration and uses a VpcLink to connect API Gateway to a network load balancer of a VPC.</p>', 'PutIntegrationRequest$type' => '<p>Specifies a put integration input\'s type.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>The request exceeded the rate limit. Retry after the specified time period.</p>', 'refs' => [], ], 'ListOfARNs' => [ 'base' => NULL, 'refs' => [ 'Authorizer$providerARNs' => '<p>A list of the Amazon Cognito user pool ARNs for the <code>COGNITO_USER_POOLS</code> authorizer. Each element is of this format: <code>arn:aws:cognito-idp:{region}:{account_id}:userpool/{user_pool_id}</code>. For a <code>TOKEN</code> or <code>REQUEST</code> authorizer, this is not defined. </p>', 'CreateAuthorizerRequest$providerARNs' => '<p>A list of the Amazon Cognito user pool ARNs for the <code>COGNITO_USER_POOLS</code> authorizer. Each element is of this format: <code>arn:aws:cognito-idp:{region}:{account_id}:userpool/{user_pool_id}</code>. For a <code>TOKEN</code> or <code>REQUEST</code> authorizer, this is not defined. </p>', ], ], 'ListOfApiKey' => [ 'base' => NULL, 'refs' => [ 'ApiKeys$items' => '<p>The current page of elements from this collection.</p>', ], ], 'ListOfApiStage' => [ 'base' => NULL, 'refs' => [ 'CreateUsagePlanRequest$apiStages' => '<p>The associated API stages of the usage plan.</p>', 'UsagePlan$apiStages' => '<p>The associated API stages of a usage plan.</p>', ], ], 'ListOfAuthorizer' => [ 'base' => NULL, 'refs' => [ 'Authorizers$items' => '<p>The current page of elements from this collection.</p>', ], ], 'ListOfBasePathMapping' => [ 'base' => NULL, 'refs' => [ 'BasePathMappings$items' => '<p>The current page of elements from this collection.</p>', ], ], 'ListOfClientCertificate' => [ 'base' => NULL, 'refs' => [ 'ClientCertificates$items' => '<p>The current page of elements from this collection.</p>', ], ], 'ListOfDeployment' => [ 'base' => NULL, 'refs' => [ 'Deployments$items' => '<p>The current page of elements from this collection.</p>', ], ], 'ListOfDocumentationPart' => [ 'base' => NULL, 'refs' => [ 'DocumentationParts$items' => '<p>The current page of elements from this collection.</p>', ], ], 'ListOfDocumentationVersion' => [ 'base' => NULL, 'refs' => [ 'DocumentationVersions$items' => '<p>The current page of elements from this collection.</p>', ], ], 'ListOfDomainName' => [ 'base' => NULL, 'refs' => [ 'DomainNames$items' => '<p>The current page of elements from this collection.</p>', ], ], 'ListOfEndpointType' => [ 'base' => NULL, 'refs' => [ 'EndpointConfiguration$types' => '<p>A list of endpoint types of an API (RestApi) or its custom domain name (DomainName). For an edge-optimized API and its custom domain name, the endpoint type is <code>"EDGE"</code>. For a regional API and its custom domain name, the endpoint type is <code>REGIONAL</code>. For a private API, the endpoint type is <code>PRIVATE</code>.</p>', ], ], 'ListOfGatewayResponse' => [ 'base' => NULL, 'refs' => [ 'GatewayResponses$items' => '<p>Returns the entire collection, because of no pagination support.</p>', ], ], 'ListOfLong' => [ 'base' => NULL, 'refs' => [ 'ListOfUsage$member' => NULL, ], ], 'ListOfModel' => [ 'base' => NULL, 'refs' => [ 'Models$items' => '<p>The current page of elements from this collection.</p>', ], ], 'ListOfPatchOperation' => [ 'base' => '<p>A list of operations describing the updates to apply to the specified resource. The patches are applied in the order specified in the list.</p>', 'refs' => [ 'UpdateAccountRequest$patchOperations' => '<p>For more information about supported patch operations, see <a href="https://docs.aws.amazon.com/apigateway/latest/api/patch-operations.html">Patch Operations</a>.</p>', 'UpdateApiKeyRequest$patchOperations' => '<p>For more information about supported patch operations, see <a href="https://docs.aws.amazon.com/apigateway/latest/api/patch-operations.html">Patch Operations</a>.</p>', 'UpdateAuthorizerRequest$patchOperations' => '<p>For more information about supported patch operations, see <a href="https://docs.aws.amazon.com/apigateway/latest/api/patch-operations.html">Patch Operations</a>.</p>', 'UpdateBasePathMappingRequest$patchOperations' => '<p>For more information about supported patch operations, see <a href="https://docs.aws.amazon.com/apigateway/latest/api/patch-operations.html">Patch Operations</a>.</p>', 'UpdateClientCertificateRequest$patchOperations' => '<p>For more information about supported patch operations, see <a href="https://docs.aws.amazon.com/apigateway/latest/api/patch-operations.html">Patch Operations</a>.</p>', 'UpdateDeploymentRequest$patchOperations' => '<p>For more information about supported patch operations, see <a href="https://docs.aws.amazon.com/apigateway/latest/api/patch-operations.html">Patch Operations</a>.</p>', 'UpdateDocumentationPartRequest$patchOperations' => '<p>For more information about supported patch operations, see <a href="https://docs.aws.amazon.com/apigateway/latest/api/patch-operations.html">Patch Operations</a>.</p>', 'UpdateDocumentationVersionRequest$patchOperations' => '<p>For more information about supported patch operations, see <a href="https://docs.aws.amazon.com/apigateway/latest/api/patch-operations.html">Patch Operations</a>.</p>', 'UpdateDomainNameRequest$patchOperations' => '<p>For more information about supported patch operations, see <a href="https://docs.aws.amazon.com/apigateway/latest/api/patch-operations.html">Patch Operations</a>.</p>', 'UpdateGatewayResponseRequest$patchOperations' => '<p>For more information about supported patch operations, see <a href="https://docs.aws.amazon.com/apigateway/latest/api/patch-operations.html">Patch Operations</a>.</p>', 'UpdateIntegrationRequest$patchOperations' => '<p>For more information about supported patch operations, see <a href="https://docs.aws.amazon.com/apigateway/latest/api/patch-operations.html">Patch Operations</a>.</p>', 'UpdateIntegrationResponseRequest$patchOperations' => '<p>For more information about supported patch operations, see <a href="https://docs.aws.amazon.com/apigateway/latest/api/patch-operations.html">Patch Operations</a>.</p>', 'UpdateMethodRequest$patchOperations' => '<p>For more information about supported patch operations, see <a href="https://docs.aws.amazon.com/apigateway/latest/api/patch-operations.html">Patch Operations</a>.</p>', 'UpdateMethodResponseRequest$patchOperations' => '<p>For more information about supported patch operations, see <a href="https://docs.aws.amazon.com/apigateway/latest/api/patch-operations.html">Patch Operations</a>.</p>', 'UpdateModelRequest$patchOperations' => '<p>For more information about supported patch operations, see <a href="https://docs.aws.amazon.com/apigateway/latest/api/patch-operations.html">Patch Operations</a>.</p>', 'UpdateRequestValidatorRequest$patchOperations' => '<p>For more information about supported patch operations, see <a href="https://docs.aws.amazon.com/apigateway/latest/api/patch-operations.html">Patch Operations</a>.</p>', 'UpdateResourceRequest$patchOperations' => '<p>For more information about supported patch operations, see <a href="https://docs.aws.amazon.com/apigateway/latest/api/patch-operations.html">Patch Operations</a>.</p>', 'UpdateRestApiRequest$patchOperations' => '<p>For more information about supported patch operations, see <a href="https://docs.aws.amazon.com/apigateway/latest/api/patch-operations.html">Patch Operations</a>.</p>', 'UpdateStageRequest$patchOperations' => '<p>For more information about supported patch operations, see <a href="https://docs.aws.amazon.com/apigateway/latest/api/patch-operations.html">Patch Operations</a>.</p>', 'UpdateUsagePlanRequest$patchOperations' => '<p>For more information about supported patch operations, see <a href="https://docs.aws.amazon.com/apigateway/latest/api/patch-operations.html">Patch Operations</a>.</p>', 'UpdateUsageRequest$patchOperations' => '<p>For more information about supported patch operations, see <a href="https://docs.aws.amazon.com/apigateway/latest/api/patch-operations.html">Patch Operations</a>.</p>', 'UpdateVpcLinkRequest$patchOperations' => '<p>For more information about supported patch operations, see <a href="https://docs.aws.amazon.com/apigateway/latest/api/patch-operations.html">Patch Operations</a>.</p>', ], ], 'ListOfRequestValidator' => [ 'base' => NULL, 'refs' => [ 'RequestValidators$items' => '<p>The current page of elements from this collection.</p>', ], ], 'ListOfResource' => [ 'base' => NULL, 'refs' => [ 'Resources$items' => '<p>The current page of elements from this collection.</p>', ], ], 'ListOfRestApi' => [ 'base' => NULL, 'refs' => [ 'RestApis$items' => '<p>The current page of elements from this collection.</p>', ], ], 'ListOfSdkConfigurationProperty' => [ 'base' => NULL, 'refs' => [ 'SdkType$configurationProperties' => '<p>A list of configuration properties of an SdkType.</p>', ], ], 'ListOfSdkType' => [ 'base' => NULL, 'refs' => [ 'SdkTypes$items' => '<p>The current page of elements from this collection.</p>', ], ], 'ListOfStage' => [ 'base' => NULL, 'refs' => [ 'Stages$item' => '<p>The current page of elements from this collection.</p>', ], ], 'ListOfStageKeys' => [ 'base' => NULL, 'refs' => [ 'CreateApiKeyRequest$stageKeys' => '<p>DEPRECATED FOR USAGE PLANS - Specifies stages associated with the API key.</p>', ], ], 'ListOfString' => [ 'base' => NULL, 'refs' => [ 'Account$features' => '<p>A list of features supported for the account. When usage plans are enabled, the features list will include an entry of <code>"UsagePlans"</code>.</p>', 'ApiKey$stageKeys' => '<p>A list of Stage resources that are associated with the ApiKey resource.</p>', 'ApiKeyIds$ids' => '<p>A list of all the ApiKey identifiers.</p>', 'ApiKeyIds$warnings' => '<p>A list of warning messages.</p>', 'ApiKeys$warnings' => '<p>A list of warning messages logged during the import of API keys when the <code>failOnWarnings</code> option is set to true.</p>', 'CreateRestApiRequest$binaryMediaTypes' => '<p>The list of binary media types supported by the RestApi. By default, the RestApi supports only UTF-8-encoded text payloads.</p>', 'CreateVpcLinkRequest$targetArns' => '<p>The ARN of the network load balancer of the VPC targeted by the VPC link. The network load balancer must be owned by the same Amazon Web Services account of the API owner.</p>', 'DocumentationPartIds$ids' => '<p>A list of the returned documentation part identifiers.</p>', 'DocumentationPartIds$warnings' => '<p>A list of warning messages reported during import of documentation parts.</p>', 'EndpointConfiguration$vpcEndpointIds' => '<p>A list of VpcEndpointIds of an API (RestApi) against which to create Route53 ALIASes. It is only supported for <code>PRIVATE</code> endpoint type.</p>', 'GetDeploymentRequest$embed' => '<p>A query parameter to retrieve the specified embedded resources of the returned Deployment resource in the response. In a REST API call, this <code>embed</code> parameter value is a list of comma-separated strings, as in <code>GET /restapis/{restapi_id}/deployments/{deployment_id}?embed=var1,var2</code>. The SDK and other platform-dependent libraries might use a different format for the list. Currently, this request supports only retrieval of the embedded API summary this way. Hence, the parameter value must be a single-valued list containing only the <code>"apisummary"</code> string. For example, <code>GET /restapis/{restapi_id}/deployments/{deployment_id}?embed=apisummary</code>.</p>', 'GetResourceRequest$embed' => '<p>A query parameter to retrieve the specified resources embedded in the returned Resource representation in the response. This <code>embed</code> parameter value is a list of comma-separated strings. Currently, the request supports only retrieval of the embedded Method resources this way. The query parameter value must be a single-valued list and contain the <code>"methods"</code> string. For example, <code>GET /restapis/{restapi_id}/resources/{resource_id}?embed=methods</code>.</p>', 'GetResourcesRequest$embed' => '<p>A query parameter used to retrieve the specified resources embedded in the returned Resources resource in the response. This <code>embed</code> parameter value is a list of comma-separated strings. Currently, the request supports only retrieval of the embedded Method resources this way. The query parameter value must be a single-valued list and contain the <code>"methods"</code> string. For example, <code>GET /restapis/{restapi_id}/resources?embed=methods</code>.</p>', 'Integration$cacheKeyParameters' => '<p>A list of request parameters whose values API Gateway caches. To be valid values for <code>cacheKeyParameters</code>, these parameters must also be specified for Method <code>requestParameters</code>.</p>', 'MapOfStringToList$value' => NULL, 'Method$authorizationScopes' => '<p>A list of authorization scopes configured on the method. The scopes are used with a <code>COGNITO_USER_POOLS</code> authorizer to authorize the method invocation. The authorization works by matching the method scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any method scopes matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide an access token instead of an identity token for authorization purposes.</p>', 'MutualTlsAuthentication$truststoreWarnings' => '<p>A list of warnings that API Gateway returns while processing your truststore. Invalid certificates produce warnings. Mutual TLS is still enabled, but some clients might not be able to access your API. To resolve warnings, upload a new truststore to S3, and then update you domain name to use the new version.</p>', 'PutIntegrationRequest$cacheKeyParameters' => '<p>A list of request parameters whose values API Gateway caches. To be valid values for <code>cacheKeyParameters</code>, these parameters must also be specified for Method <code>requestParameters</code>.</p>', 'PutMethodRequest$authorizationScopes' => '<p>A list of authorization scopes configured on the method. The scopes are used with a <code>COGNITO_USER_POOLS</code> authorizer to authorize the method invocation. The authorization works by matching the method scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any method scopes matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide an access token instead of an identity token for authorization purposes.</p>', 'RestApi$warnings' => '<p>The warning messages reported when <code>failonwarnings</code> is turned on during API import.</p>', 'RestApi$binaryMediaTypes' => '<p>The list of binary media types supported by the RestApi. By default, the RestApi supports only UTF-8-encoded text payloads.</p>', 'UntagResourceRequest$tagKeys' => '<p>The Tag keys to delete.</p>', 'VpcLink$targetArns' => '<p>The ARN of the network load balancer of the VPC targeted by the VPC link. The network load balancer must be owned by the same Amazon Web Services account of the API owner.</p>', ], ], 'ListOfUsage' => [ 'base' => NULL, 'refs' => [ 'MapOfKeyUsages$value' => NULL, ], ], 'ListOfUsagePlan' => [ 'base' => NULL, 'refs' => [ 'UsagePlans$items' => '<p>The current page of elements from this collection.</p>', ], ], 'ListOfUsagePlanKey' => [ 'base' => NULL, 'refs' => [ 'UsagePlanKeys$items' => '<p>The current page of elements from this collection.</p>', ], ], 'ListOfVpcLink' => [ 'base' => NULL, 'refs' => [ 'VpcLinks$items' => '<p>The current page of elements from this collection.</p>', ], ], 'LocationStatusType' => [ 'base' => NULL, 'refs' => [ 'GetDocumentationPartsRequest$locationStatus' => '<p>The status of the API documentation parts to retrieve. Valid values are <code>DOCUMENTED</code> for retrieving DocumentationPart resources with content and <code>UNDOCUMENTED</code> for DocumentationPart resources without content.</p>', ], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'ListOfLong$member' => NULL, 'TestInvokeAuthorizerResponse$latency' => '<p>The execution latency, in ms, of the test authorizer request.</p>', 'TestInvokeMethodResponse$latency' => '<p>The execution latency, in ms, of the test invoke request.</p>', ], ], 'MapOfApiStageThrottleSettings' => [ 'base' => NULL, 'refs' => [ 'ApiStage$throttle' => '<p>Map containing method level throttling information for API stage in a usage plan.</p>', ], ], 'MapOfIntegrationResponse' => [ 'base' => NULL, 'refs' => [ 'Integration$integrationResponses' => '<p>Specifies the integration\'s responses.</p>', ], ], 'MapOfKeyUsages' => [ 'base' => NULL, 'refs' => [ 'Usage$items' => '<p>The usage data, as daily logs of used and remaining quotas, over the specified time interval indexed over the API keys in a usage plan. For example, <code>{..., "values" : { "{api_key}" : [ [0, 100], [10, 90], [100, 10]]}</code>, where <code>{api_key}</code> stands for an API key value and the daily log entry is of the format <code>[used quota, remaining quota]</code>.</p>', ], ], 'MapOfMethod' => [ 'base' => NULL, 'refs' => [ 'Resource$resourceMethods' => '<p>Gets an API resource\'s method of a given HTTP verb.</p>', ], ], 'MapOfMethodResponse' => [ 'base' => NULL, 'refs' => [ 'Method$methodResponses' => '<p>Gets a method response associated with a given HTTP status code. </p>', ], ], 'MapOfMethodSettings' => [ 'base' => NULL, 'refs' => [ 'Stage$methodSettings' => '<p>A map that defines the method settings for a Stage resource. Keys (designated as <code>/{method_setting_key</code> below) are method paths defined as <code>{resource_path}/{http_method}</code> for an individual method override, or <code>/\\*/\\*</code> for overriding all methods in the stage. </p>', ], ], 'MapOfMethodSnapshot' => [ 'base' => NULL, 'refs' => [ 'PathToMapOfMethodSnapshot$value' => NULL, ], ], 'MapOfStringToBoolean' => [ 'base' => NULL, 'refs' => [ 'Method$requestParameters' => '<p>A key-value map defining required or optional method request parameters that can be accepted by API Gateway. A key is a method request parameter name matching the pattern of <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> is a valid and unique parameter name. The value associated with the key is a Boolean flag indicating whether the parameter is required (<code>true</code>) or optional (<code>false</code>). The method request parameter names defined here are available in Integration to be mapped to integration request parameters or templates.</p>', 'MethodResponse$responseParameters' => '<p>A key-value map specifying required or optional response parameters that API Gateway can send back to the caller. A key defines a method response header and the value specifies whether the associated method response header is required or not. The expression of the key must match the pattern <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. API Gateway passes certain integration response data to the method response headers specified here according to the mapping you prescribe in the API\'s IntegrationResponse. The integration response data that can be mapped include an integration response header expressed in <code>integration.response.header.{name}</code>, a static value enclosed within a pair of single quotes (e.g., <code>\'application/json\'</code>), or a JSON expression from the back-end response payload in the form of <code>integration.response.body.{JSON-expression}</code>, where <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.)</p>', 'PutMethodRequest$requestParameters' => '<p>A key-value map defining required or optional method request parameters that can be accepted by API Gateway. A key defines a method request parameter name matching the pattern of <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> is a valid and unique parameter name. The value associated with the key is a Boolean flag indicating whether the parameter is required (<code>true</code>) or optional (<code>false</code>). The method request parameter names defined here are available in Integration to be mapped to integration request parameters or body-mapping templates.</p>', 'PutMethodResponseRequest$responseParameters' => '<p>A key-value map specifying required or optional response parameters that API Gateway can send back to the caller. A key defines a method response header name and the associated value is a Boolean flag indicating whether the method response parameter is required or not. The method response header names must match the pattern of <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. The response parameter names defined here are available in the integration response to be mapped from an integration response header expressed in <code>integration.response.header.{name}</code>, a static value enclosed within a pair of single quotes (e.g., <code>\'application/json\'</code>), or a JSON expression from the back-end response payload in the form of <code>integration.response.body.{JSON-expression}</code>, where <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.)</p>', ], ], 'MapOfStringToList' => [ 'base' => NULL, 'refs' => [ 'TestInvokeAuthorizerRequest$multiValueHeaders' => '<p>The headers as a map from string to list of values to simulate an incoming invocation request. This is where the incoming authorization token, or identity source, may be specified.</p>', 'TestInvokeAuthorizerResponse$authorization' => '<p>The authorization response.</p>', 'TestInvokeMethodRequest$multiValueHeaders' => '<p>The headers as a map from string to list of values to simulate an incoming invocation request.</p>', 'TestInvokeMethodResponse$multiValueHeaders' => '<p>The headers of the HTTP response as a map from string to list of values.</p>', ], ], 'MapOfStringToString' => [ 'base' => NULL, 'refs' => [ 'ApiKey$tags' => '<p>The collection of tags. Each tag element is associated with a given resource.</p>', 'CanarySettings$stageVariableOverrides' => '<p>Stage variables overridden for a canary release deployment, including new stage variables introduced in the canary. These stage variables are represented as a string-to-string map between stage variable names and their values.</p>', 'ClientCertificate$tags' => '<p>The collection of tags. Each tag element is associated with a given resource.</p>', 'CreateApiKeyRequest$tags' => '<p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>', 'CreateDeploymentRequest$variables' => '<p>A map that defines the stage variables for the Stage resource that is associated with the new deployment. Variable names can have alphanumeric and underscore characters, and the values must match <code>[A-Za-z0-9-._~:/?#&amp;=,]+</code>.</p>', 'CreateDomainNameRequest$tags' => '<p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>', 'CreateRestApiRequest$tags' => '<p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>', 'CreateStageRequest$variables' => '<p>A map that defines the stage variables for the new Stage resource. Variable names can have alphanumeric and underscore characters, and the values must match <code>[A-Za-z0-9-._~:/?#&amp;=,]+</code>.</p>', 'CreateStageRequest$tags' => '<p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>', 'CreateUsagePlanRequest$tags' => '<p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>', 'CreateVpcLinkRequest$tags' => '<p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>', 'DeploymentCanarySettings$stageVariableOverrides' => '<p>A stage variable overrides used for the canary release deployment. They can override existing stage variables or add new stage variables for the canary release deployment. These stage variables are represented as a string-to-string map between stage variable names and their values.</p>', 'DomainName$tags' => '<p>The collection of tags. Each tag element is associated with a given resource.</p>', 'GatewayResponse$responseParameters' => '<p>Response parameters (paths, query strings and headers) of the GatewayResponse as a string-to-string map of key-value pairs.</p>', 'GatewayResponse$responseTemplates' => '<p>Response templates of the GatewayResponse as a string-to-string map of key-value pairs.</p>', 'GenerateClientCertificateRequest$tags' => '<p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>', 'GetExportRequest$parameters' => '<p>A key-value map of query string parameters that specify properties of the export, depending on the requested <code>exportType</code>. For <code>exportType</code> <code>oas30</code> and <code>swagger</code>, any combination of the following parameters are supported: <code>extensions=\'integrations\'</code> or <code>extensions=\'apigateway\'</code> will export the API with x-amazon-apigateway-integration extensions. <code>extensions=\'authorizers\'</code> will export the API with x-amazon-apigateway-authorizer extensions. <code>postman</code> will export the API with Postman extensions, allowing for import to the Postman tool</p>', 'GetSdkRequest$parameters' => '<p>A string-to-string key-value map of query parameters <code>sdkType</code>-dependent properties of the SDK. For <code>sdkType</code> of <code>objectivec</code> or <code>swift</code>, a parameter named <code>classPrefix</code> is required. For <code>sdkType</code> of <code>android</code>, parameters named <code>groupId</code>, <code>artifactId</code>, <code>artifactVersion</code>, and <code>invokerPackage</code> are required. For <code>sdkType</code> of <code>java</code>, parameters named <code>serviceName</code> and <code>javaPackageName</code> are required. </p>', 'ImportRestApiRequest$parameters' => '<p>A key-value map of context-specific query string parameters specifying the behavior of different API importing operations. The following shows operation-specific parameters and their supported values.</p> <p> To exclude DocumentationParts from the import, set <code>parameters</code> as <code>ignore=documentation</code>.</p> <p> To configure the endpoint type, set <code>parameters</code> as <code>endpointConfigurationTypes=EDGE</code>, <code>endpointConfigurationTypes=REGIONAL</code>, or <code>endpointConfigurationTypes=PRIVATE</code>. The default endpoint type is <code>EDGE</code>.</p> <p> To handle imported <code>basepath</code>, set <code>parameters</code> as <code>basepath=ignore</code>, <code>basepath=prepend</code> or <code>basepath=split</code>.</p>', 'Integration$requestParameters' => '<p>A key-value map specifying request parameters that are passed from the method request to the back end. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the back end. The method request parameter value must match the pattern of <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> must be a valid and unique method request parameter name.</p>', 'Integration$requestTemplates' => '<p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value.</p>', 'IntegrationResponse$responseParameters' => '<p>A key-value map specifying response parameters that are passed to the method response from the back end. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. The mapped non-static value must match the pattern of <code>integration.response.header.{name}</code> or <code>integration.response.body.{JSON-expression}</code>, where <code>name</code> is a valid and unique response header name and <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.</p>', 'IntegrationResponse$responseTemplates' => '<p>Specifies the templates used to transform the integration response body. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.</p>', 'Method$requestModels' => '<p>A key-value map specifying data schemas, represented by Model resources, (as the mapped value) of the request payloads of given content types (as the mapping key).</p>', 'MethodResponse$responseModels' => '<p>Specifies the Model resources used for the response\'s content-type. Response models are represented as a key/value map, with a content-type as the key and a Model name as the value.</p>', 'PutGatewayResponseRequest$responseParameters' => '<p>Response parameters (paths, query strings and headers) of the GatewayResponse as a string-to-string map of key-value pairs.</p>', 'PutGatewayResponseRequest$responseTemplates' => '<p>Response templates of the GatewayResponse as a string-to-string map of key-value pairs.</p>', 'PutIntegrationRequest$requestParameters' => '<p>A key-value map specifying request parameters that are passed from the method request to the back end. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the back end. The method request parameter value must match the pattern of <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> must be a valid and unique method request parameter name.</p>', 'PutIntegrationRequest$requestTemplates' => '<p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value.</p>', 'PutIntegrationResponseRequest$responseParameters' => '<p>A key-value map specifying response parameters that are passed to the method response from the back end. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. The mapped non-static value must match the pattern of <code>integration.response.header.{name}</code> or <code>integration.response.body.{JSON-expression}</code>, where <code>name</code> must be a valid and unique response header name and <code>JSON-expression</code> a valid JSON expression without the <code>$</code> prefix.</p>', 'PutIntegrationResponseRequest$responseTemplates' => '<p>Specifies a put integration response\'s templates.</p>', 'PutMethodRequest$requestModels' => '<p>Specifies the Model resources used for the request\'s content type. Request models are represented as a key/value map, with a content type as the key and a Model name as the value.</p>', 'PutMethodResponseRequest$responseModels' => '<p>Specifies the Model resources used for the response\'s content type. Response models are represented as a key/value map, with a content type as the key and a Model name as the value.</p>', 'PutRestApiRequest$parameters' => '<p>Custom header parameters as part of the request. For example, to exclude DocumentationParts from an imported API, set <code>ignore=documentation</code> as a <code>parameters</code> value, as in the AWS CLI command of <code>aws apigateway import-rest-api --parameters ignore=documentation --body \'file:///path/to/imported-api-body.json\'</code>.</p>', 'RestApi$tags' => '<p>The collection of tags. Each tag element is associated with a given resource.</p>', 'Stage$variables' => '<p>A map that defines the stage variables for a Stage resource. Variable names can have alphanumeric and underscore characters, and the values must match <code>[A-Za-z0-9-._~:/?#&amp;=,]+</code>.</p>', 'Stage$tags' => '<p>The collection of tags. Each tag element is associated with a given resource.</p>', 'TagResourceRequest$tags' => '<p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>', 'Tags$tags' => '<p>The collection of tags. Each tag element is associated with a given resource.</p>', 'TestInvokeAuthorizerRequest$headers' => '<p>A key-value map of headers to simulate an incoming invocation request. This is where the incoming authorization token, or identity source, should be specified.</p>', 'TestInvokeAuthorizerRequest$stageVariables' => '<p>A key-value map of stage variables to simulate an invocation on a deployed Stage.</p>', 'TestInvokeAuthorizerRequest$additionalContext' => '<p>A key-value map of additional context variables.</p>', 'TestInvokeAuthorizerResponse$claims' => '<p>The open identity claims, with any supported custom attributes, returned from the Cognito Your User Pool configured for the API.</p>', 'TestInvokeMethodRequest$headers' => '<p>A key-value map of headers to simulate an incoming invocation request.</p>', 'TestInvokeMethodRequest$stageVariables' => '<p>A key-value map of stage variables to simulate an invocation on a deployed Stage.</p>', 'TestInvokeMethodResponse$headers' => '<p>The headers of the HTTP response.</p>', 'UsagePlan$tags' => '<p>The collection of tags. Each tag element is associated with a given resource.</p>', 'VpcLink$tags' => '<p>The collection of tags. Each tag element is associated with a given resource.</p>', ], ], 'Method' => [ 'base' => '<p> Represents a client-facing interface by which the client calls the API to access back-end resources. A Method resource is integrated with an Integration resource. Both consist of a request and one or more responses. The method request takes the client input that is passed to the back end through the integration request. A method response returns the output from the back end to the client through an integration response. A method request is embodied in a Method resource, whereas an integration request is embodied in an Integration resource. On the other hand, a method response is represented by a MethodResponse resource, whereas an integration response is represented by an IntegrationResponse resource. </p>', 'refs' => [ 'MapOfMethod$value' => NULL, ], ], 'MethodResponse' => [ 'base' => '<p>Represents a method response of a given HTTP status code returned to the client. The method response is passed from the back end through the associated integration response that can be transformed using a mapping template. </p>', 'refs' => [ 'MapOfMethodResponse$value' => NULL, ], ], 'MethodSetting' => [ 'base' => '<p>Specifies the method setting properties.</p>', 'refs' => [ 'MapOfMethodSettings$value' => NULL, ], ], 'MethodSnapshot' => [ 'base' => '<p>Represents a summary of a Method resource, given a particular date and time.</p>', 'refs' => [ 'MapOfMethodSnapshot$value' => NULL, ], ], 'Model' => [ 'base' => '<p>Represents the data structure of a method\'s request or response payload.</p>', 'refs' => [ 'ListOfModel$member' => NULL, ], ], 'Models' => [ 'base' => '<p>Represents a collection of Model resources.</p>', 'refs' => [], ], 'MutualTlsAuthentication' => [ 'base' => '<p>The mutual TLS authentication configuration for a custom domain name. If specified, API Gateway performs two-way authentication between the client and the server. Clients must present a trusted certificate to access your API.</p>', 'refs' => [ 'DomainName$mutualTlsAuthentication' => '<p>The mutual TLS authentication configuration for a custom domain name. If specified, API Gateway performs two-way authentication between the client and the server. Clients must present a trusted certificate to access your API.</p>', ], ], 'MutualTlsAuthenticationInput' => [ 'base' => '<p>The mutual TLS authentication configuration for a custom domain name. If specified, API Gateway performs two-way authentication between the client and the server. Clients must present a trusted certificate to access your API.</p>', 'refs' => [ 'CreateDomainNameRequest$mutualTlsAuthentication' => NULL, ], ], 'NotFoundException' => [ 'base' => '<p>The requested resource is not found. Make sure that the request URI is correct.</p>', 'refs' => [], ], 'NullableBoolean' => [ 'base' => NULL, 'refs' => [ 'CreateDeploymentRequest$cacheClusterEnabled' => '<p>Enables a cache cluster for the Stage resource specified in the input.</p>', 'CreateDeploymentRequest$tracingEnabled' => '<p>Specifies whether active tracing with X-ray is enabled for the Stage.</p>', 'GetApiKeyRequest$includeValue' => '<p>A boolean flag to specify whether (<code>true</code>) or not (<code>false</code>) the result contains the key value.</p>', 'GetApiKeysRequest$includeValues' => '<p>A boolean flag to specify whether (<code>true</code>) or not (<code>false</code>) the result contains key values.</p>', 'MapOfStringToBoolean$value' => NULL, 'Method$apiKeyRequired' => '<p>A boolean flag specifying whether a valid ApiKey is required to invoke this method.</p>', ], ], 'NullableInteger' => [ 'base' => NULL, 'refs' => [ 'Authorizer$authorizerResultTtlInSeconds' => '<p>The TTL in seconds of cached authorizer results. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway will cache authorizer responses. If this field is not set, the default value is 300. The maximum value is 3600, or 1 hour.</p>', 'CreateAuthorizerRequest$authorizerResultTtlInSeconds' => '<p>The TTL in seconds of cached authorizer results. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway will cache authorizer responses. If this field is not set, the default value is 300. The maximum value is 3600, or 1 hour.</p>', 'CreateRestApiRequest$minimumCompressionSize' => '<p>A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with a null value) on an API. When compression is enabled, compression or decompression is not applied on the payload if the payload size is smaller than this value. Setting it to zero allows compression for any payload size.</p>', 'GetApiKeysRequest$limit' => '<p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>', 'GetAuthorizersRequest$limit' => '<p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>', 'GetBasePathMappingsRequest$limit' => '<p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>', 'GetClientCertificatesRequest$limit' => '<p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>', 'GetDeploymentsRequest$limit' => '<p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>', 'GetDocumentationPartsRequest$limit' => '<p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>', 'GetDocumentationVersionsRequest$limit' => '<p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>', 'GetDomainNamesRequest$limit' => '<p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>', 'GetGatewayResponsesRequest$limit' => '<p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500. The GatewayResponses collection does not support pagination and the limit does not apply here.</p>', 'GetModelsRequest$limit' => '<p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>', 'GetRequestValidatorsRequest$limit' => '<p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>', 'GetResourcesRequest$limit' => '<p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>', 'GetRestApisRequest$limit' => '<p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>', 'GetSdkTypesRequest$limit' => '<p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>', 'GetTagsRequest$limit' => '<p>(Not currently supported) The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>', 'GetUsagePlanKeysRequest$limit' => '<p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>', 'GetUsagePlansRequest$limit' => '<p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>', 'GetUsageRequest$limit' => '<p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>', 'GetVpcLinksRequest$limit' => '<p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>', 'PutIntegrationRequest$timeoutInMillis' => '<p>Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds or 29 seconds.</p>', 'RestApi$minimumCompressionSize' => '<p>A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with a null value) on an API. When compression is enabled, compression or decompression is not applied on the payload if the payload size is smaller than this value. Setting it to zero allows compression for any payload size.</p>', ], ], 'Op' => [ 'base' => NULL, 'refs' => [ 'PatchOperation$op' => '<p>An update operation to be performed with this PATCH request. The valid value can be add, remove, replace or copy. Not all valid operations are supported for a given resource. Support of the operations depends on specific operational contexts. Attempts to apply an unsupported operation on a resource will return an error message..</p>', ], ], 'PatchOperation' => [ 'base' => '<p>For more information about supported patch operations, see <a href="https://docs.aws.amazon.com/apigateway/latest/api/patch-operations.html">Patch Operations</a>.</p>', 'refs' => [ 'ListOfPatchOperation$member' => NULL, ], ], 'PathToMapOfMethodSnapshot' => [ 'base' => NULL, 'refs' => [ 'Deployment$apiSummary' => '<p>A summary of the RestApi at the date and time that the deployment resource was created.</p>', ], ], 'ProviderARN' => [ 'base' => NULL, 'refs' => [ 'ListOfARNs$member' => NULL, ], ], 'PutGatewayResponseRequest' => [ 'base' => '<p>Creates a customization of a GatewayResponse of a specified response type and status code on the given RestApi.</p>', 'refs' => [], ], 'PutIntegrationRequest' => [ 'base' => '<p>Sets up a method\'s integration.</p>', 'refs' => [], ], 'PutIntegrationResponseRequest' => [ 'base' => '<p>Represents a put integration response request.</p>', 'refs' => [], ], 'PutMethodRequest' => [ 'base' => '<p>Request to add a method to an existing Resource resource.</p>', 'refs' => [], ], 'PutMethodResponseRequest' => [ 'base' => '<p>Request to add a MethodResponse to an existing Method resource.</p>', 'refs' => [], ], 'PutMode' => [ 'base' => NULL, 'refs' => [ 'ImportDocumentationPartsRequest$mode' => '<p>A query parameter to indicate whether to overwrite (<code>overwrite</code>) any existing DocumentationParts definition or to merge (<code>merge</code>) the new definition into the existing one. The default value is <code>merge</code>.</p>', 'PutRestApiRequest$mode' => '<p>The <code>mode</code> query parameter to specify the update mode. Valid values are "merge" and "overwrite". By default, the update mode is "merge".</p>', ], ], 'PutRestApiRequest' => [ 'base' => '<p>A PUT request to update an existing API, with external API definitions specified as the request body.</p>', 'refs' => [], ], 'QuotaPeriodType' => [ 'base' => NULL, 'refs' => [ 'QuotaSettings$period' => '<p>The time period in which the limit applies. Valid values are "DAY", "WEEK" or "MONTH".</p>', ], ], 'QuotaSettings' => [ 'base' => '<p>Quotas configured for a usage plan.</p>', 'refs' => [ 'CreateUsagePlanRequest$quota' => '<p>The quota of the usage plan.</p>', 'UsagePlan$quota' => '<p>The target maximum number of permitted requests per a given unit time interval.</p>', ], ], 'RequestValidator' => [ 'base' => '<p>A set of validation rules for incoming Method requests.</p>', 'refs' => [ 'ListOfRequestValidator$member' => NULL, ], ], 'RequestValidators' => [ 'base' => '<p>A collection of RequestValidator resources of a given RestApi.</p>', 'refs' => [], ], 'Resource' => [ 'base' => '<p>Represents an API resource.</p>', 'refs' => [ 'ListOfResource$member' => NULL, ], ], 'Resources' => [ 'base' => '<p>Represents a collection of Resource resources.</p>', 'refs' => [], ], 'RestApi' => [ 'base' => '<p>Represents a REST API.</p>', 'refs' => [ 'ListOfRestApi$member' => NULL, ], ], 'RestApis' => [ 'base' => '<p>Contains references to your APIs and links that guide you in how to interact with your collection. A collection offers a paginated view of your APIs.</p>', 'refs' => [], ], 'SdkConfigurationProperty' => [ 'base' => '<p>A configuration property of an SDK type.</p>', 'refs' => [ 'ListOfSdkConfigurationProperty$member' => NULL, ], ], 'SdkResponse' => [ 'base' => '<p>The binary blob response to GetSdk, which contains the generated SDK.</p>', 'refs' => [], ], 'SdkType' => [ 'base' => '<p>A type of SDK that API Gateway can generate.</p>', 'refs' => [ 'ListOfSdkType$member' => NULL, ], ], 'SdkTypes' => [ 'base' => '<p>The collection of SdkType instances.</p>', 'refs' => [], ], 'SecurityPolicy' => [ 'base' => NULL, 'refs' => [ 'CreateDomainNameRequest$securityPolicy' => '<p>The Transport Layer Security (TLS) version + cipher suite for this DomainName. The valid values are <code>TLS_1_0</code> and <code>TLS_1_2</code>.</p>', 'DomainName$securityPolicy' => '<p>The Transport Layer Security (TLS) version + cipher suite for this DomainName. The valid values are <code>TLS_1_0</code> and <code>TLS_1_2</code>.</p>', ], ], 'ServiceUnavailableException' => [ 'base' => '<p>The requested service is not available. For details see the accompanying error message. Retry after the specified time period.</p>', 'refs' => [], ], 'Stage' => [ 'base' => '<p>Represents a unique identifier for a version of a deployed RestApi that is callable by users.</p>', 'refs' => [ 'ListOfStage$member' => NULL, ], ], 'StageKey' => [ 'base' => '<p>A reference to a unique stage identified in the format <code>{restApiId}/{stage}</code>.</p>', 'refs' => [ 'ListOfStageKeys$member' => NULL, ], ], 'Stages' => [ 'base' => '<p>A list of Stage resources that are associated with the ApiKey resource.</p>', 'refs' => [], ], 'StatusCode' => [ 'base' => '<p>The status code.</p>', 'refs' => [ 'DeleteIntegrationResponseRequest$statusCode' => '<p>Specifies a delete integration response request\'s status code.</p>', 'DeleteMethodResponseRequest$statusCode' => '<p>The status code identifier for the MethodResponse resource.</p>', 'GatewayResponse$statusCode' => '<p>The HTTP status code for this GatewayResponse.</p>', 'GetIntegrationResponseRequest$statusCode' => '<p>Specifies a get integration response request\'s status code.</p>', 'GetMethodResponseRequest$statusCode' => '<p>The status code for the MethodResponse resource.</p>', 'IntegrationResponse$statusCode' => '<p>Specifies the status code that is used to map the integration response to an existing MethodResponse.</p>', 'MethodResponse$statusCode' => '<p>The method response\'s status code.</p>', 'PutGatewayResponseRequest$statusCode' => '<p>The HTTP status code of the GatewayResponse.</p>', 'PutIntegrationResponseRequest$statusCode' => '<p>Specifies the status code that is used to map the integration response to an existing MethodResponse.</p>', 'PutMethodResponseRequest$statusCode' => '<p>The method response\'s status code.</p>', 'UpdateIntegrationResponseRequest$statusCode' => '<p>Specifies an update integration response request\'s status code.</p>', 'UpdateMethodResponseRequest$statusCode' => '<p>The status code for the MethodResponse resource.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessLogSettings$format' => '<p>A single line format of the access logs of data, as specified by selected $context variables. The format must include at least <code>$context.requestId</code>.</p>', 'AccessLogSettings$destinationArn' => '<p>The Amazon Resource Name (ARN) of the CloudWatch Logs log group or Kinesis Data Firehose delivery stream to receive access logs. If you specify a Kinesis Data Firehose delivery stream, the stream name must begin with <code>amazon-apigateway-</code>.</p>', 'Account$cloudwatchRoleArn' => '<p>The ARN of an Amazon CloudWatch role for the current Account. </p>', 'Account$apiKeyVersion' => '<p>The version of the API keys used for the account.</p>', 'ApiKey$id' => '<p>The identifier of the API Key.</p>', 'ApiKey$value' => '<p>The value of the API Key.</p>', 'ApiKey$name' => '<p>The name of the API Key.</p>', 'ApiKey$customerId' => '<p>An Amazon Web Services Marketplace customer identifier, when integrating with the Amazon Web Services SaaS Marketplace.</p>', 'ApiKey$description' => '<p>The description of the API Key.</p>', 'ApiKeys$position' => NULL, 'ApiStage$apiId' => '<p>API Id of the associated API stage in a usage plan.</p>', 'ApiStage$stage' => '<p>API stage name of the associated API stage in a usage plan.</p>', 'Authorizer$id' => '<p>The identifier for the authorizer resource.</p>', 'Authorizer$name' => '<p>The name of the authorizer.</p>', 'Authorizer$authType' => '<p>Optional customer-defined field, used in OpenAPI imports and exports without functional impact.</p>', 'Authorizer$authorizerUri' => '<p>Specifies the authorizer\'s Uniform Resource Identifier (URI). For <code>TOKEN</code> or <code>REQUEST</code> authorizers, this must be a well-formed Lambda function URI, for example, <code>arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:{account_id}:function:{lambda_function_name}/invocations</code>. In general, the URI has this form <code>arn:aws:apigateway:{region}:lambda:path/{service_api}</code>, where <code>{region}</code> is the same as the region hosting the Lambda function, <code>path</code> indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial <code>/</code>. For Lambda functions, this is usually of the form <code>/2015-03-31/functions/[FunctionARN]/invocations</code>.</p>', 'Authorizer$authorizerCredentials' => '<p>Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role\'s Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, specify null.</p>', 'Authorizer$identitySource' => '<p>The identity source for which authorization is requested. For a <code>TOKEN</code> or <code>COGNITO_USER_POOLS</code> authorizer, this is required and specifies the request header mapping expression for the custom header holding the authorization token submitted by the client. For example, if the token header name is <code>Auth</code>, the header mapping expression is <code>method.request.header.Auth</code>. For the <code>REQUEST</code> authorizer, this is required when authorization caching is enabled. The value is a comma-separated string of one or more mapping expressions of the specified request parameters. For example, if an <code>Auth</code> header, a <code>Name</code> query string parameter are defined as identity sources, this value is <code>method.request.header.Auth</code>, <code>method.request.querystring.Name</code>. These parameters will be used to derive the authorization caching key and to perform runtime validation of the <code>REQUEST</code> authorizer by verifying all of the identity-related request parameters are present, not null and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function, otherwise, it returns a 401 Unauthorized response without calling the Lambda function. The valid value is a string of comma-separated mapping expressions of the specified request parameters. When the authorization caching is not enabled, this property is optional. </p>', 'Authorizer$identityValidationExpression' => '<p>A validation expression for the incoming identity token. For <code>TOKEN</code> authorizers, this value is a regular expression. For <code>COGNITO_USER_POOLS</code> authorizers, API Gateway will match the <code>aud</code> field of the incoming token from the client against the specified regular expression. It will invoke the authorizer\'s Lambda function when there is a match. Otherwise, it will return a 401 Unauthorized response without calling the Lambda function. The validation expression does not apply to the <code>REQUEST</code> authorizer.</p>', 'Authorizers$position' => NULL, 'BadRequestException$message' => NULL, 'BasePathMapping$basePath' => '<p>The base path name that callers of the API must provide as part of the URL after the domain name.</p>', 'BasePathMapping$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'BasePathMapping$stage' => '<p>The name of the associated stage.</p>', 'BasePathMappings$position' => NULL, 'CanarySettings$deploymentId' => '<p>The ID of the canary deployment.</p>', 'ClientCertificate$clientCertificateId' => '<p>The identifier of the client certificate.</p>', 'ClientCertificate$description' => '<p>The description of the client certificate.</p>', 'ClientCertificate$pemEncodedCertificate' => '<p>The PEM-encoded public key of the client certificate, which can be used to configure certificate authentication in the integration endpoint .</p>', 'ClientCertificates$position' => NULL, 'ConflictException$message' => NULL, 'CreateApiKeyRequest$name' => '<p>The name of the ApiKey.</p>', 'CreateApiKeyRequest$description' => '<p>The description of the ApiKey.</p>', 'CreateApiKeyRequest$value' => '<p>Specifies a value of the API key.</p>', 'CreateApiKeyRequest$customerId' => '<p>An Amazon Web Services Marketplace customer identifier, when integrating with the Amazon Web Services SaaS Marketplace.</p>', 'CreateAuthorizerRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'CreateAuthorizerRequest$name' => '<p>The name of the authorizer.</p>', 'CreateAuthorizerRequest$authType' => '<p>Optional customer-defined field, used in OpenAPI imports and exports without functional impact.</p>', 'CreateAuthorizerRequest$authorizerUri' => '<p>Specifies the authorizer\'s Uniform Resource Identifier (URI). For <code>TOKEN</code> or <code>REQUEST</code> authorizers, this must be a well-formed Lambda function URI, for example, <code>arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:{account_id}:function:{lambda_function_name}/invocations</code>. In general, the URI has this form <code>arn:aws:apigateway:{region}:lambda:path/{service_api}</code>, where <code>{region}</code> is the same as the region hosting the Lambda function, <code>path</code> indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial <code>/</code>. For Lambda functions, this is usually of the form <code>/2015-03-31/functions/[FunctionARN]/invocations</code>.</p>', 'CreateAuthorizerRequest$authorizerCredentials' => '<p>Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role\'s Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, specify null.</p>', 'CreateAuthorizerRequest$identitySource' => '<p>The identity source for which authorization is requested. For a <code>TOKEN</code> or <code>COGNITO_USER_POOLS</code> authorizer, this is required and specifies the request header mapping expression for the custom header holding the authorization token submitted by the client. For example, if the token header name is <code>Auth</code>, the header mapping expression is <code>method.request.header.Auth</code>. For the <code>REQUEST</code> authorizer, this is required when authorization caching is enabled. The value is a comma-separated string of one or more mapping expressions of the specified request parameters. For example, if an <code>Auth</code> header, a <code>Name</code> query string parameter are defined as identity sources, this value is <code>method.request.header.Auth, method.request.querystring.Name</code>. These parameters will be used to derive the authorization caching key and to perform runtime validation of the <code>REQUEST</code> authorizer by verifying all of the identity-related request parameters are present, not null and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function, otherwise, it returns a 401 Unauthorized response without calling the Lambda function. The valid value is a string of comma-separated mapping expressions of the specified request parameters. When the authorization caching is not enabled, this property is optional.</p>', 'CreateAuthorizerRequest$identityValidationExpression' => '<p>A validation expression for the incoming identity token. For <code>TOKEN</code> authorizers, this value is a regular expression. For <code>COGNITO_USER_POOLS</code> authorizers, API Gateway will match the <code>aud</code> field of the incoming token from the client against the specified regular expression. It will invoke the authorizer\'s Lambda function when there is a match. Otherwise, it will return a 401 Unauthorized response without calling the Lambda function. The validation expression does not apply to the <code>REQUEST</code> authorizer.</p>', 'CreateBasePathMappingRequest$domainName' => '<p>The domain name of the BasePathMapping resource to create.</p>', 'CreateBasePathMappingRequest$basePath' => '<p>The base path name that callers of the API must provide as part of the URL after the domain name. This value must be unique for all of the mappings across a single API. Specify \'(none)\' if you do not want callers to specify a base path name after the domain name.</p>', 'CreateBasePathMappingRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'CreateBasePathMappingRequest$stage' => '<p>The name of the API\'s stage that you want to use for this mapping. Specify \'(none)\' if you want callers to explicitly specify the stage name after any base path name.</p>', 'CreateDeploymentRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'CreateDeploymentRequest$stageName' => '<p>The name of the Stage resource for the Deployment resource to create.</p>', 'CreateDeploymentRequest$stageDescription' => '<p>The description of the Stage resource for the Deployment resource to create.</p>', 'CreateDeploymentRequest$description' => '<p>The description for the Deployment resource to create.</p>', 'CreateDocumentationPartRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'CreateDocumentationPartRequest$properties' => '<p>The new documentation content map of the targeted API entity. Enclosed key-value pairs are API-specific, but only OpenAPI-compliant key-value pairs can be exported and, hence, published.</p>', 'CreateDocumentationVersionRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'CreateDocumentationVersionRequest$documentationVersion' => '<p>The version identifier of the new snapshot.</p>', 'CreateDocumentationVersionRequest$stageName' => '<p>The stage name to be associated with the new documentation snapshot.</p>', 'CreateDocumentationVersionRequest$description' => '<p>A description about the new documentation snapshot.</p>', 'CreateDomainNameRequest$domainName' => '<p>The name of the DomainName resource.</p>', 'CreateDomainNameRequest$certificateName' => '<p>The user-friendly name of the certificate that will be used by edge-optimized endpoint for this domain name.</p>', 'CreateDomainNameRequest$certificateBody' => '<p>[Deprecated] The body of the server certificate that will be used by edge-optimized endpoint for this domain name provided by your certificate authority.</p>', 'CreateDomainNameRequest$certificatePrivateKey' => '<p>[Deprecated] Your edge-optimized endpoint\'s domain name certificate\'s private key.</p>', 'CreateDomainNameRequest$certificateChain' => '<p>[Deprecated] The intermediate certificates and optionally the root certificate, one after the other without any blank lines, used by an edge-optimized endpoint for this domain name. If you include the root certificate, your certificate chain must start with intermediate certificates and end with the root certificate. Use the intermediate certificates that were provided by your certificate authority. Do not include any intermediaries that are not in the chain of trust path.</p>', 'CreateDomainNameRequest$certificateArn' => '<p>The reference to an Amazon Web Services-managed certificate that will be used by edge-optimized endpoint for this domain name. Certificate Manager is the only supported source.</p>', 'CreateDomainNameRequest$regionalCertificateName' => '<p>The user-friendly name of the certificate that will be used by regional endpoint for this domain name.</p>', 'CreateDomainNameRequest$regionalCertificateArn' => '<p>The reference to an Amazon Web Services-managed certificate that will be used by regional endpoint for this domain name. Certificate Manager is the only supported source.</p>', 'CreateDomainNameRequest$ownershipVerificationCertificateArn' => '<p>The ARN of the public certificate issued by ACM to validate ownership of your custom domain. Only required when configuring mutual TLS and using an ACM imported or private CA certificate ARN as the regionalCertificateArn.</p>', 'CreateModelRequest$restApiId' => '<p>The RestApi identifier under which the Model will be created.</p>', 'CreateModelRequest$name' => '<p>The name of the model. Must be alphanumeric.</p>', 'CreateModelRequest$description' => '<p>The description of the model.</p>', 'CreateModelRequest$schema' => '<p>The schema for the model. For <code>application/json</code> models, this should be JSON schema draft 4 model. The maximum size of the model is 400 KB.</p>', 'CreateModelRequest$contentType' => '<p>The content-type for the model.</p>', 'CreateRequestValidatorRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'CreateRequestValidatorRequest$name' => '<p>The name of the to-be-created RequestValidator.</p>', 'CreateResourceRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'CreateResourceRequest$parentId' => '<p>The parent resource\'s identifier.</p>', 'CreateResourceRequest$pathPart' => '<p>The last path segment for this resource.</p>', 'CreateRestApiRequest$name' => '<p>The name of the RestApi.</p>', 'CreateRestApiRequest$description' => '<p>The description of the RestApi.</p>', 'CreateRestApiRequest$version' => '<p>A version identifier for the API.</p>', 'CreateRestApiRequest$cloneFrom' => '<p>The ID of the RestApi that you want to clone from.</p>', 'CreateRestApiRequest$policy' => '<p>A stringified JSON policy document that applies to this RestApi regardless of the caller and Method configuration.</p>', 'CreateStageRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'CreateStageRequest$stageName' => '<p>The name for the Stage resource. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>', 'CreateStageRequest$deploymentId' => '<p>The identifier of the Deployment resource for the Stage resource.</p>', 'CreateStageRequest$description' => '<p>The description of the Stage resource.</p>', 'CreateStageRequest$documentationVersion' => '<p>The version of the associated API documentation.</p>', 'CreateUsagePlanKeyRequest$usagePlanId' => '<p>The Id of the UsagePlan resource representing the usage plan containing the to-be-created UsagePlanKey resource representing a plan customer.</p>', 'CreateUsagePlanKeyRequest$keyId' => '<p>The identifier of a UsagePlanKey resource for a plan customer.</p>', 'CreateUsagePlanKeyRequest$keyType' => '<p>The type of a UsagePlanKey resource for a plan customer.</p>', 'CreateUsagePlanRequest$name' => '<p>The name of the usage plan.</p>', 'CreateUsagePlanRequest$description' => '<p>The description of the usage plan.</p>', 'CreateVpcLinkRequest$name' => '<p>The name used to label and identify the VPC link.</p>', 'CreateVpcLinkRequest$description' => '<p>The description of the VPC link.</p>', 'DeleteApiKeyRequest$apiKey' => '<p>The identifier of the ApiKey resource to be deleted.</p>', 'DeleteAuthorizerRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'DeleteAuthorizerRequest$authorizerId' => '<p>The identifier of the Authorizer resource.</p>', 'DeleteBasePathMappingRequest$domainName' => '<p>The domain name of the BasePathMapping resource to delete.</p>', 'DeleteBasePathMappingRequest$basePath' => '<p>The base path name of the BasePathMapping resource to delete.</p> <p>To specify an empty base path, set this parameter to <code>\'(none)\'</code>.</p>', 'DeleteClientCertificateRequest$clientCertificateId' => '<p>The identifier of the ClientCertificate resource to be deleted.</p>', 'DeleteDeploymentRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'DeleteDeploymentRequest$deploymentId' => '<p>The identifier of the Deployment resource to delete.</p>', 'DeleteDocumentationPartRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'DeleteDocumentationPartRequest$documentationPartId' => '<p>The identifier of the to-be-deleted documentation part.</p>', 'DeleteDocumentationVersionRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'DeleteDocumentationVersionRequest$documentationVersion' => '<p>The version identifier of a to-be-deleted documentation snapshot.</p>', 'DeleteDomainNameRequest$domainName' => '<p>The name of the DomainName resource to be deleted.</p>', 'DeleteGatewayResponseRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'DeleteIntegrationRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'DeleteIntegrationRequest$resourceId' => '<p>Specifies a delete integration request\'s resource identifier.</p>', 'DeleteIntegrationRequest$httpMethod' => '<p>Specifies a delete integration request\'s HTTP method.</p>', 'DeleteIntegrationResponseRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'DeleteIntegrationResponseRequest$resourceId' => '<p>Specifies a delete integration response request\'s resource identifier.</p>', 'DeleteIntegrationResponseRequest$httpMethod' => '<p>Specifies a delete integration response request\'s HTTP method.</p>', 'DeleteMethodRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'DeleteMethodRequest$resourceId' => '<p>The Resource identifier for the Method resource.</p>', 'DeleteMethodRequest$httpMethod' => '<p>The HTTP verb of the Method resource.</p>', 'DeleteMethodResponseRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'DeleteMethodResponseRequest$resourceId' => '<p>The Resource identifier for the MethodResponse resource.</p>', 'DeleteMethodResponseRequest$httpMethod' => '<p>The HTTP verb of the Method resource.</p>', 'DeleteModelRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'DeleteModelRequest$modelName' => '<p>The name of the model to delete.</p>', 'DeleteRequestValidatorRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'DeleteRequestValidatorRequest$requestValidatorId' => '<p>The identifier of the RequestValidator to be deleted.</p>', 'DeleteResourceRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'DeleteResourceRequest$resourceId' => '<p>The identifier of the Resource resource.</p>', 'DeleteRestApiRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'DeleteStageRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'DeleteStageRequest$stageName' => '<p>The name of the Stage resource to delete.</p>', 'DeleteUsagePlanKeyRequest$usagePlanId' => '<p>The Id of the UsagePlan resource representing the usage plan containing the to-be-deleted UsagePlanKey resource representing a plan customer.</p>', 'DeleteUsagePlanKeyRequest$keyId' => '<p>The Id of the UsagePlanKey resource to be deleted.</p>', 'DeleteUsagePlanRequest$usagePlanId' => '<p>The Id of the to-be-deleted usage plan.</p>', 'DeleteVpcLinkRequest$vpcLinkId' => '<p>The identifier of the VpcLink. It is used in an Integration to reference this VpcLink.</p>', 'Deployment$id' => '<p>The identifier for the deployment resource.</p>', 'Deployment$description' => '<p>The description for the deployment resource.</p>', 'Deployments$position' => NULL, 'DocumentationPart$id' => '<p>The DocumentationPart identifier, generated by API Gateway when the <code>DocumentationPart</code> is created.</p>', 'DocumentationPart$properties' => '<p>A content map of API-specific key-value pairs describing the targeted API entity. The map must be encoded as a JSON string, e.g., <code>"{ \\"description\\": \\"The API does ...\\" }"</code>. Only OpenAPI-compliant documentation-related fields from the properties map are exported and, hence, published as part of the API entity definitions, while the original documentation parts are exported in a OpenAPI extension of <code>x-amazon-apigateway-documentation</code>.</p>', 'DocumentationPartLocation$path' => '<p>The URL path of the target. It is a valid field for the API entity types of <code>RESOURCE</code>, <code>METHOD</code>, <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>, <code>REQUEST_HEADER</code>, <code>REQUEST_BODY</code>, <code>RESPONSE</code>, <code>RESPONSE_HEADER</code>, and <code>RESPONSE_BODY</code>. The default value is <code>/</code> for the root resource. When an applicable child entity inherits the content of another entity of the same type with more general specifications of the other <code>location</code> attributes, the child entity\'s <code>path</code> attribute must match that of the parent entity as a prefix.</p>', 'DocumentationPartLocation$method' => '<p>The HTTP verb of a method. It is a valid field for the API entity types of <code>METHOD</code>, <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>, <code>REQUEST_HEADER</code>, <code>REQUEST_BODY</code>, <code>RESPONSE</code>, <code>RESPONSE_HEADER</code>, and <code>RESPONSE_BODY</code>. The default value is <code>*</code> for any method. When an applicable child entity inherits the content of an entity of the same type with more general specifications of the other <code>location</code> attributes, the child entity\'s <code>method</code> attribute must match that of the parent entity exactly.</p>', 'DocumentationPartLocation$name' => '<p>The name of the targeted API entity. It is a valid and required field for the API entity types of <code>AUTHORIZER</code>, <code>MODEL</code>, <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>, <code>REQUEST_HEADER</code>, <code>REQUEST_BODY</code> and <code>RESPONSE_HEADER</code>. It is an invalid field for any other entity type.</p>', 'DocumentationParts$position' => NULL, 'DocumentationVersion$version' => '<p>The version identifier of the API documentation snapshot.</p>', 'DocumentationVersion$description' => '<p>The description of the API documentation snapshot.</p>', 'DocumentationVersions$position' => NULL, 'DomainName$domainName' => '<p>The custom domain name as an API host name, for example, <code>my-api.example.com</code>.</p>', 'DomainName$certificateName' => '<p>The name of the certificate that will be used by edge-optimized endpoint for this domain name.</p>', 'DomainName$certificateArn' => '<p>The reference to an Amazon Web Services-managed certificate that will be used by edge-optimized endpoint for this domain name. Certificate Manager is the only supported source.</p>', 'DomainName$regionalDomainName' => '<p>The domain name associated with the regional endpoint for this custom domain name. You set up this association by adding a DNS record that points the custom domain name to this regional domain name. The regional domain name is returned by API Gateway when you create a regional endpoint.</p>', 'DomainName$regionalHostedZoneId' => '<p>The region-specific Amazon Route 53 Hosted Zone ID of the regional endpoint. For more information, see Set up a Regional Custom Domain Name and AWS Regions and Endpoints for API Gateway. </p>', 'DomainName$regionalCertificateName' => '<p>The name of the certificate that will be used for validating the regional domain name.</p>', 'DomainName$regionalCertificateArn' => '<p>The reference to an Amazon Web Services-managed certificate that will be used for validating the regional domain name. Certificate Manager is the only supported source.</p>', 'DomainName$distributionDomainName' => '<p>The domain name of the Amazon CloudFront distribution associated with this custom domain name for an edge-optimized endpoint. You set up this association when adding a DNS record pointing the custom domain name to this distribution name. For more information about CloudFront distributions, see the Amazon CloudFront documentation.</p>', 'DomainName$distributionHostedZoneId' => '<p>The region-agnostic Amazon Route 53 Hosted Zone ID of the edge-optimized endpoint. The valid value is <code>Z2FDTNDATAQYW2</code> for all the regions. For more information, see Set up a Regional Custom Domain Name and AWS Regions and Endpoints for API Gateway. </p>', 'DomainName$domainNameStatusMessage' => '<p>An optional text message containing detailed information about status of the DomainName migration.</p>', 'DomainName$ownershipVerificationCertificateArn' => '<p>The ARN of the public certificate issued by ACM to validate ownership of your custom domain. Only required when configuring mutual TLS and using an ACM imported or private CA certificate ARN as the regionalCertificateArn.</p>', 'DomainNames$position' => NULL, 'ExportResponse$contentType' => '<p>The content-type header value in the HTTP response. This will correspond to a valid \'accept\' type in the request.</p>', 'ExportResponse$contentDisposition' => '<p>The content-disposition header value in the HTTP response.</p>', 'FlushStageAuthorizersCacheRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'FlushStageAuthorizersCacheRequest$stageName' => '<p>The name of the stage to flush.</p>', 'FlushStageCacheRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'FlushStageCacheRequest$stageName' => '<p>The name of the stage to flush its cache.</p>', 'GatewayResponses$position' => NULL, 'GenerateClientCertificateRequest$description' => '<p>The description of the ClientCertificate.</p>', 'GetApiKeyRequest$apiKey' => '<p>The identifier of the ApiKey resource.</p>', 'GetApiKeysRequest$position' => '<p>The current pagination position in the paged result set.</p>', 'GetApiKeysRequest$nameQuery' => '<p>The name of queried API keys.</p>', 'GetApiKeysRequest$customerId' => '<p>The identifier of a customer in Amazon Web Services Marketplace or an external system, such as a developer portal.</p>', 'GetAuthorizerRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'GetAuthorizerRequest$authorizerId' => '<p>The identifier of the Authorizer resource.</p>', 'GetAuthorizersRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'GetAuthorizersRequest$position' => '<p>The current pagination position in the paged result set.</p>', 'GetBasePathMappingRequest$domainName' => '<p>The domain name of the BasePathMapping resource to be described.</p>', 'GetBasePathMappingRequest$basePath' => '<p>The base path name that callers of the API must provide as part of the URL after the domain name. This value must be unique for all of the mappings across a single API. Specify \'(none)\' if you do not want callers to specify any base path name after the domain name.</p>', 'GetBasePathMappingsRequest$domainName' => '<p>The domain name of a BasePathMapping resource.</p>', 'GetBasePathMappingsRequest$position' => '<p>The current pagination position in the paged result set.</p>', 'GetClientCertificateRequest$clientCertificateId' => '<p>The identifier of the ClientCertificate resource to be described.</p>', 'GetClientCertificatesRequest$position' => '<p>The current pagination position in the paged result set.</p>', 'GetDeploymentRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'GetDeploymentRequest$deploymentId' => '<p>The identifier of the Deployment resource to get information about.</p>', 'GetDeploymentsRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'GetDeploymentsRequest$position' => '<p>The current pagination position in the paged result set.</p>', 'GetDocumentationPartRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'GetDocumentationPartRequest$documentationPartId' => '<p>The string identifier of the associated RestApi.</p>', 'GetDocumentationPartsRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'GetDocumentationPartsRequest$nameQuery' => '<p>The name of API entities of the to-be-retrieved documentation parts.</p>', 'GetDocumentationPartsRequest$path' => '<p>The path of API entities of the to-be-retrieved documentation parts.</p>', 'GetDocumentationPartsRequest$position' => '<p>The current pagination position in the paged result set.</p>', 'GetDocumentationVersionRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'GetDocumentationVersionRequest$documentationVersion' => '<p>The version identifier of the to-be-retrieved documentation snapshot.</p>', 'GetDocumentationVersionsRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'GetDocumentationVersionsRequest$position' => '<p>The current pagination position in the paged result set.</p>', 'GetDomainNameRequest$domainName' => '<p>The name of the DomainName resource.</p>', 'GetDomainNamesRequest$position' => '<p>The current pagination position in the paged result set.</p>', 'GetExportRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'GetExportRequest$stageName' => '<p>The name of the Stage that will be exported.</p>', 'GetExportRequest$exportType' => '<p>The type of export. Acceptable values are \'oas30\' for OpenAPI 3.0.x and \'swagger\' for Swagger/OpenAPI 2.0.</p>', 'GetExportRequest$accepts' => '<p>The content-type of the export, for example <code>application/json</code>. Currently <code>application/json</code> and <code>application/yaml</code> are supported for <code>exportType</code> of<code>oas30</code> and <code>swagger</code>. This should be specified in the <code>Accept</code> header for direct API requests.</p>', 'GetGatewayResponseRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'GetGatewayResponsesRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'GetGatewayResponsesRequest$position' => '<p>The current pagination position in the paged result set. The GatewayResponse collection does not support pagination and the position does not apply here.</p>', 'GetIntegrationRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'GetIntegrationRequest$resourceId' => '<p>Specifies a get integration request\'s resource identifier</p>', 'GetIntegrationRequest$httpMethod' => '<p>Specifies a get integration request\'s HTTP method.</p>', 'GetIntegrationResponseRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'GetIntegrationResponseRequest$resourceId' => '<p>Specifies a get integration response request\'s resource identifier.</p>', 'GetIntegrationResponseRequest$httpMethod' => '<p>Specifies a get integration response request\'s HTTP method.</p>', 'GetMethodRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'GetMethodRequest$resourceId' => '<p>The Resource identifier for the Method resource.</p>', 'GetMethodRequest$httpMethod' => '<p>Specifies the method request\'s HTTP method type.</p>', 'GetMethodResponseRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'GetMethodResponseRequest$resourceId' => '<p>The Resource identifier for the MethodResponse resource.</p>', 'GetMethodResponseRequest$httpMethod' => '<p>The HTTP verb of the Method resource.</p>', 'GetModelRequest$restApiId' => '<p>The RestApi identifier under which the Model exists.</p>', 'GetModelRequest$modelName' => '<p>The name of the model as an identifier.</p>', 'GetModelTemplateRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'GetModelTemplateRequest$modelName' => '<p>The name of the model for which to generate a template.</p>', 'GetModelsRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'GetModelsRequest$position' => '<p>The current pagination position in the paged result set.</p>', 'GetRequestValidatorRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'GetRequestValidatorRequest$requestValidatorId' => '<p>The identifier of the RequestValidator to be retrieved.</p>', 'GetRequestValidatorsRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'GetRequestValidatorsRequest$position' => '<p>The current pagination position in the paged result set.</p>', 'GetResourceRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'GetResourceRequest$resourceId' => '<p>The identifier for the Resource resource.</p>', 'GetResourcesRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'GetResourcesRequest$position' => '<p>The current pagination position in the paged result set.</p>', 'GetRestApiRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'GetRestApisRequest$position' => '<p>The current pagination position in the paged result set.</p>', 'GetSdkRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'GetSdkRequest$stageName' => '<p>The name of the Stage that the SDK will use.</p>', 'GetSdkRequest$sdkType' => '<p>The language for the generated SDK. Currently <code>java</code>, <code>javascript</code>, <code>android</code>, <code>objectivec</code> (for iOS), <code>swift</code> (for iOS), and <code>ruby</code> are supported.</p>', 'GetSdkTypeRequest$id' => '<p>The identifier of the queried SdkType instance.</p>', 'GetSdkTypesRequest$position' => '<p>The current pagination position in the paged result set.</p>', 'GetStageRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'GetStageRequest$stageName' => '<p>The name of the Stage resource to get information about.</p>', 'GetStagesRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'GetStagesRequest$deploymentId' => '<p>The stages\' deployment identifiers.</p>', 'GetTagsRequest$resourceArn' => '<p>The ARN of a resource that can be tagged.</p>', 'GetTagsRequest$position' => '<p>(Not currently supported) The current pagination position in the paged result set.</p>', 'GetUsagePlanKeyRequest$usagePlanId' => '<p>The Id of the UsagePlan resource representing the usage plan containing the to-be-retrieved UsagePlanKey resource representing a plan customer.</p>', 'GetUsagePlanKeyRequest$keyId' => '<p>The key Id of the to-be-retrieved UsagePlanKey resource representing a plan customer.</p>', 'GetUsagePlanKeysRequest$usagePlanId' => '<p>The Id of the UsagePlan resource representing the usage plan containing the to-be-retrieved UsagePlanKey resource representing a plan customer.</p>', 'GetUsagePlanKeysRequest$position' => '<p>The current pagination position in the paged result set.</p>', 'GetUsagePlanKeysRequest$nameQuery' => '<p>A query parameter specifying the name of the to-be-returned usage plan keys.</p>', 'GetUsagePlanRequest$usagePlanId' => '<p>The identifier of the UsagePlan resource to be retrieved.</p>', 'GetUsagePlansRequest$position' => '<p>The current pagination position in the paged result set.</p>', 'GetUsagePlansRequest$keyId' => '<p>The identifier of the API key associated with the usage plans.</p>', 'GetUsageRequest$usagePlanId' => '<p>The Id of the usage plan associated with the usage data.</p>', 'GetUsageRequest$keyId' => '<p>The Id of the API key associated with the resultant usage data.</p>', 'GetUsageRequest$startDate' => '<p>The starting date (e.g., 2016-01-01) of the usage data.</p>', 'GetUsageRequest$endDate' => '<p>The ending date (e.g., 2016-12-31) of the usage data.</p>', 'GetUsageRequest$position' => '<p>The current pagination position in the paged result set.</p>', 'GetVpcLinkRequest$vpcLinkId' => '<p>The identifier of the VpcLink. It is used in an Integration to reference this VpcLink.</p>', 'GetVpcLinksRequest$position' => '<p>The current pagination position in the paged result set.</p>', 'ImportDocumentationPartsRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'Integration$httpMethod' => '<p>Specifies the integration\'s HTTP method type. For the Type property, if you specify <code>MOCK</code>, this property is optional. For Lambda integrations, you must set the integration method to <code>POST</code>. For all other types, you must specify this property.</p>', 'Integration$uri' => '<p>Specifies Uniform Resource Identifier (URI) of the integration endpoint.</p> <p>For <code>HTTP</code> or <code>HTTP_PROXY</code> integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the RFC-3986 specification for standard integrations. If <code>connectionType</code> is <code>VPC_LINK</code> specify the Network Load Balancer DNS name. For <code>AWS</code> or <code>AWS_PROXY</code> integrations, the URI is of the form <code>arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api}</code>. Here, {Region} is the API Gateway region (e.g., us-east-1); {service} is the name of the integrated Amazon Web Services service (e.g., s3); and {subdomain} is a designated subdomain supported by certain Amazon Web Services service for fast host-name lookup. action can be used for an Amazon Web Services service action-based API, using an Action={name}&amp;{p1}={v1}&amp;p2={v2}... query string. The ensuing {service_api} refers to a supported action {name} plus any required input parameters. Alternatively, path can be used for an Amazon Web Services service path-based API. The ensuing service_api refers to the path to an Amazon Web Services service resource, including the region of the integrated Amazon Web Services service, if applicable. For example, for integration with the S3 API of GetObject, the uri can be either <code>arn:aws:apigateway:us-west-2:s3:action/GetObject&amp;Bucket={bucket}&amp;Key={key}</code> or <code>arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}</code> </p>', 'Integration$connectionId' => '<p>The ID of the VpcLink used for the integration when <code>connectionType=VPC_LINK</code> and undefined, otherwise.</p>', 'Integration$credentials' => '<p>Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role\'s Amazon Resource Name (ARN). To require that the caller\'s identity be passed through from the request, specify the string <code>arn:aws:iam::\\*:user/\\*</code>. To use resource-based permissions on supported Amazon Web Services services, specify null.</p>', 'Integration$passthroughBehavior' => '<p>Specifies how the method request body of an unmapped content type will be passed through the integration request to the back end without transformation. A content type is unmapped if no mapping template is defined in the integration or the content type does not match any of the mapped content types, as specified in <code>requestTemplates</code>. The valid value is one of the following: <code>WHEN_NO_MATCH</code>: passes the method request body through the integration request to the back end without transformation when the method request content type does not match any content type associated with the mapping templates defined in the integration request. <code>WHEN_NO_TEMPLATES</code>: passes the method request body through the integration request to the back end without transformation when no mapping template is defined in the integration request. If a template is defined when this option is selected, the method request of an unmapped content-type will be rejected with an HTTP 415 Unsupported Media Type response. <code>NEVER</code>: rejects the method request with an HTTP 415 Unsupported Media Type response when either the method request content type does not match any content type associated with the mapping templates defined in the integration request or no mapping template is defined in the integration request.</p>', 'Integration$cacheNamespace' => '<p>Specifies a group of related cached parameters. By default, API Gateway uses the resource ID as the <code>cacheNamespace</code>. You can specify the same <code>cacheNamespace</code> across resources to return the same cached data for requests to different resources.</p>', 'IntegrationResponse$selectionPattern' => '<p>Specifies the regular expression (regex) pattern used to choose an integration response based on the response from the back end. For example, if the success response returns nothing and the error response returns some string, you could use the <code>.+</code> regex to match error response. However, make sure that the error response does not contain any newline (<code>\\n</code>) character in such cases. If the back end is an Lambda function, the Lambda function error header is matched. For all other HTTP and Amazon Web Services back ends, the HTTP status code is matched.</p>', 'LimitExceededException$retryAfterSeconds' => NULL, 'LimitExceededException$message' => NULL, 'ListOfString$member' => NULL, 'MapOfApiStageThrottleSettings$key' => NULL, 'MapOfIntegrationResponse$key' => NULL, 'MapOfKeyUsages$key' => NULL, 'MapOfMethod$key' => NULL, 'MapOfMethodResponse$key' => NULL, 'MapOfMethodSettings$key' => NULL, 'MapOfMethodSnapshot$key' => NULL, 'MapOfStringToBoolean$key' => NULL, 'MapOfStringToList$key' => NULL, 'MapOfStringToString$key' => NULL, 'MapOfStringToString$value' => NULL, 'Method$httpMethod' => '<p>The method\'s HTTP verb.</p>', 'Method$authorizationType' => '<p>The method\'s authorization type. Valid values are <code>NONE</code> for open access, <code>AWS_IAM</code> for using AWS IAM permissions, <code>CUSTOM</code> for using a custom authorizer, or <code>COGNITO_USER_POOLS</code> for using a Cognito user pool.</p>', 'Method$authorizerId' => '<p>The identifier of an Authorizer to use on this method. The <code>authorizationType</code> must be <code>CUSTOM</code>.</p>', 'Method$requestValidatorId' => '<p>The identifier of a RequestValidator for request validation.</p>', 'Method$operationName' => '<p>A human-friendly operation identifier for the method. For example, you can assign the <code>operationName</code> of <code>ListPets</code> for the <code>GET /pets</code> method in the <code>PetStore</code> example.</p>', 'MethodSetting$loggingLevel' => '<p>Specifies the logging level for this method, which affects the log entries pushed to Amazon CloudWatch Logs. Valid values are <code>OFF</code>, <code>ERROR</code>, and <code>INFO</code>. Choose <code>ERROR</code> to write only error-level entries to CloudWatch Logs, or choose <code>INFO</code> to include all <code>ERROR</code> events as well as extra informational events.</p>', 'MethodSnapshot$authorizationType' => '<p>The method\'s authorization type. Valid values are <code>NONE</code> for open access, <code>AWS_IAM</code> for using AWS IAM permissions, <code>CUSTOM</code> for using a custom authorizer, or <code>COGNITO_USER_POOLS</code> for using a Cognito user pool.</p>', 'Model$id' => '<p>The identifier for the model resource.</p>', 'Model$name' => '<p>The name of the model. Must be an alphanumeric string.</p>', 'Model$description' => '<p>The description of the model.</p>', 'Model$schema' => '<p>The schema for the model. For <code>application/json</code> models, this should be JSON schema draft 4 model. Do not include "\\*/" characters in the description of any properties because such "\\*/" characters may be interpreted as the closing marker for comments in some languages, such as Java or JavaScript, causing the installation of your API\'s SDK generated by API Gateway to fail.</p>', 'Model$contentType' => '<p>The content-type for the model.</p>', 'Models$position' => NULL, 'MutualTlsAuthentication$truststoreUri' => '<p>An Amazon S3 URL that specifies the truststore for mutual TLS authentication, for example <code>s3://bucket-name/key-name</code>. The truststore can contain certificates from public or private certificate authorities. To update the truststore, upload a new version to S3, and then update your custom domain name to use the new version. To update the truststore, you must have permissions to access the S3 object.</p>', 'MutualTlsAuthentication$truststoreVersion' => '<p>The version of the S3 object that contains your truststore. To specify a version, you must have versioning enabled for the S3 bucket.</p>', 'MutualTlsAuthenticationInput$truststoreUri' => '<p>An Amazon S3 URL that specifies the truststore for mutual TLS authentication, for example <code>s3://bucket-name/key-name</code>. The truststore can contain certificates from public or private certificate authorities. To update the truststore, upload a new version to S3, and then update your custom domain name to use the new version. To update the truststore, you must have permissions to access the S3 object.</p>', 'MutualTlsAuthenticationInput$truststoreVersion' => '<p>The version of the S3 object that contains your truststore. To specify a version, you must have versioning enabled for the S3 bucket</p>', 'NotFoundException$message' => NULL, 'PatchOperation$path' => '<p>The op operation\'s target, as identified by a JSON Pointer value that references a location within the targeted resource. For example, if the target resource has an updateable property of {"name":"value"}, the path for this property is /name. If the name property value is a JSON object (e.g., {"name": {"child/name": "child-value"}}), the path for the child/name property will be /name/child~1name. Any slash ("/") character appearing in path names must be escaped with "~1", as shown in the example above. Each op operation can have only one path associated with it.</p>', 'PatchOperation$value' => '<p>The new target value of the update operation. It is applicable for the add or replace operation. When using AWS CLI to update a property of a JSON value, enclose the JSON object with a pair of single quotes in a Linux shell, e.g., \'{"a": ...}\'.</p>', 'PatchOperation$from' => '<p>The copy update operation\'s source as identified by a JSON-Pointer value referencing the location within the targeted resource to copy the value from. For example, to promote a canary deployment, you copy the canary deployment ID to the affiliated deployment ID by calling a PATCH request on a Stage resource with "op":"copy", "from":"/canarySettings/deploymentId" and "path":"/deploymentId".</p>', 'PathToMapOfMethodSnapshot$key' => NULL, 'PutGatewayResponseRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'PutIntegrationRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'PutIntegrationRequest$resourceId' => '<p>Specifies a put integration request\'s resource ID.</p>', 'PutIntegrationRequest$httpMethod' => '<p>Specifies the HTTP method for the integration.</p>', 'PutIntegrationRequest$integrationHttpMethod' => '<p>The HTTP method for the integration.</p>', 'PutIntegrationRequest$uri' => '<p>Specifies Uniform Resource Identifier (URI) of the integration endpoint. For HTTP or <code>HTTP_PROXY</code> integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the RFC-3986 specification, for either standard integration, where <code>connectionType</code> is not <code>VPC_LINK</code>, or private integration, where <code>connectionType</code> is <code>VPC_LINK</code>. For a private HTTP integration, the URI is not used for routing. For <code>AWS</code> or <code>AWS_PROXY</code> integrations, the URI is of the form <code>arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api</code>}. Here, {Region} is the API Gateway region (e.g., us-east-1); {service} is the name of the integrated Amazon Web Services service (e.g., s3); and {subdomain} is a designated subdomain supported by certain Amazon Web Services service for fast host-name lookup. action can be used for an Amazon Web Services service action-based API, using an Action={name}&amp;{p1}={v1}&amp;p2={v2}... query string. The ensuing {service_api} refers to a supported action {name} plus any required input parameters. Alternatively, path can be used for an Amazon Web Services service path-based API. The ensuing service_api refers to the path to an Amazon Web Services service resource, including the region of the integrated Amazon Web Services service, if applicable. For example, for integration with the S3 API of <code>GetObject</code>, the <code>uri</code> can be either <code>arn:aws:apigateway:us-west-2:s3:action/GetObject&amp;Bucket={bucket}&amp;Key={key}</code> or <code>arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}</code>.</p>', 'PutIntegrationRequest$connectionId' => '<p>The ID of the VpcLink used for the integration. Specify this value only if you specify <code>VPC_LINK</code> as the connection type.</p>', 'PutIntegrationRequest$credentials' => '<p>Specifies whether credentials are required for a put integration.</p>', 'PutIntegrationRequest$passthroughBehavior' => '<p>Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the <code>requestTemplates</code> property on the Integration resource. There are three valid values: <code>WHEN_NO_MATCH</code>, <code>WHEN_NO_TEMPLATES</code>, and <code>NEVER</code>. </p>', 'PutIntegrationRequest$cacheNamespace' => '<p>Specifies a group of related cached parameters. By default, API Gateway uses the resource ID as the <code>cacheNamespace</code>. You can specify the same <code>cacheNamespace</code> across resources to return the same cached data for requests to different resources.</p>', 'PutIntegrationResponseRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'PutIntegrationResponseRequest$resourceId' => '<p>Specifies a put integration response request\'s resource identifier.</p>', 'PutIntegrationResponseRequest$httpMethod' => '<p>Specifies a put integration response request\'s HTTP method.</p>', 'PutIntegrationResponseRequest$selectionPattern' => '<p>Specifies the selection pattern of a put integration response.</p>', 'PutMethodRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'PutMethodRequest$resourceId' => '<p>The Resource identifier for the new Method resource.</p>', 'PutMethodRequest$httpMethod' => '<p>Specifies the method request\'s HTTP method type.</p>', 'PutMethodRequest$authorizationType' => '<p>The method\'s authorization type. Valid values are <code>NONE</code> for open access, <code>AWS_IAM</code> for using AWS IAM permissions, <code>CUSTOM</code> for using a custom authorizer, or <code>COGNITO_USER_POOLS</code> for using a Cognito user pool.</p>', 'PutMethodRequest$authorizerId' => '<p>Specifies the identifier of an Authorizer to use on this Method, if the type is CUSTOM or COGNITO_USER_POOLS. The authorizer identifier is generated by API Gateway when you created the authorizer.</p>', 'PutMethodRequest$operationName' => '<p>A human-friendly operation identifier for the method. For example, you can assign the <code>operationName</code> of <code>ListPets</code> for the <code>GET /pets</code> method in the <code>PetStore</code> example.</p>', 'PutMethodRequest$requestValidatorId' => '<p>The identifier of a RequestValidator for validating the method request.</p>', 'PutMethodResponseRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'PutMethodResponseRequest$resourceId' => '<p>The Resource identifier for the Method resource.</p>', 'PutMethodResponseRequest$httpMethod' => '<p>The HTTP verb of the Method resource.</p>', 'PutRestApiRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'RequestValidator$id' => '<p>The identifier of this RequestValidator.</p>', 'RequestValidator$name' => '<p>The name of this RequestValidator</p>', 'RequestValidators$position' => NULL, 'Resource$id' => '<p>The resource\'s identifier.</p>', 'Resource$parentId' => '<p>The parent resource\'s identifier.</p>', 'Resource$pathPart' => '<p>The last path segment for this resource.</p>', 'Resource$path' => '<p>The full path for this resource.</p>', 'Resources$position' => NULL, 'RestApi$id' => '<p>The API\'s identifier. This identifier is unique across all of your APIs in API Gateway.</p>', 'RestApi$name' => '<p>The API\'s name.</p>', 'RestApi$description' => '<p>The API\'s description.</p>', 'RestApi$version' => '<p>A version identifier for the API.</p>', 'RestApi$policy' => '<p>A stringified JSON policy document that applies to this RestApi regardless of the caller and Method configuration.</p>', 'RestApi$rootResourceId' => '<p>The API\'s root resource ID.</p>', 'RestApis$position' => NULL, 'SdkConfigurationProperty$name' => '<p>The name of a an SdkType configuration property.</p>', 'SdkConfigurationProperty$friendlyName' => '<p>The user-friendly name of an SdkType configuration property.</p>', 'SdkConfigurationProperty$description' => '<p>The description of an SdkType configuration property.</p>', 'SdkConfigurationProperty$defaultValue' => '<p>The default value of an SdkType configuration property.</p>', 'SdkResponse$contentType' => '<p>The content-type header value in the HTTP response.</p>', 'SdkResponse$contentDisposition' => '<p>The content-disposition header value in the HTTP response.</p>', 'SdkType$id' => '<p>The identifier of an SdkType instance.</p>', 'SdkType$friendlyName' => '<p>The user-friendly name of an SdkType instance.</p>', 'SdkType$description' => '<p>The description of an SdkType.</p>', 'SdkTypes$position' => NULL, 'ServiceUnavailableException$retryAfterSeconds' => NULL, 'ServiceUnavailableException$message' => NULL, 'Stage$deploymentId' => '<p>The identifier of the Deployment that the stage points to.</p>', 'Stage$clientCertificateId' => '<p>The identifier of a client certificate for an API stage.</p>', 'Stage$stageName' => '<p>The name of the stage is the first path segment in the Uniform Resource Identifier (URI) of a call to API Gateway. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>', 'Stage$description' => '<p>The stage\'s description.</p>', 'Stage$documentationVersion' => '<p>The version of the associated API documentation.</p>', 'Stage$webAclArn' => '<p>The ARN of the WebAcl associated with the Stage.</p>', 'StageKey$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'StageKey$stageName' => '<p>The stage name associated with the stage key.</p>', 'TagResourceRequest$resourceArn' => '<p>The ARN of a resource that can be tagged.</p>', 'Template$value' => '<p>The Apache Velocity Template Language (VTL) template content used for the template resource.</p>', 'TestInvokeAuthorizerRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'TestInvokeAuthorizerRequest$authorizerId' => '<p>Specifies a test invoke authorizer request\'s Authorizer ID.</p>', 'TestInvokeAuthorizerRequest$pathWithQueryString' => '<p>The URI path, including query string, of the simulated invocation request. Use this to specify path parameters and query string parameters.</p>', 'TestInvokeAuthorizerRequest$body' => '<p>The simulated request body of an incoming invocation request.</p>', 'TestInvokeAuthorizerResponse$log' => '<p>The API Gateway execution log for the test authorizer request.</p>', 'TestInvokeAuthorizerResponse$principalId' => '<p>The principal identity returned by the Authorizer</p>', 'TestInvokeAuthorizerResponse$policy' => '<p>The JSON policy document returned by the Authorizer</p>', 'TestInvokeMethodRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'TestInvokeMethodRequest$resourceId' => '<p>Specifies a test invoke method request\'s resource ID.</p>', 'TestInvokeMethodRequest$httpMethod' => '<p>Specifies a test invoke method request\'s HTTP method.</p>', 'TestInvokeMethodRequest$pathWithQueryString' => '<p>The URI path, including query string, of the simulated invocation request. Use this to specify path parameters and query string parameters.</p>', 'TestInvokeMethodRequest$body' => '<p>The simulated request body of an incoming invocation request.</p>', 'TestInvokeMethodRequest$clientCertificateId' => '<p>A ClientCertificate identifier to use in the test invocation. API Gateway will use the certificate when making the HTTPS request to the defined back-end endpoint.</p>', 'TestInvokeMethodResponse$body' => '<p>The body of the HTTP response.</p>', 'TestInvokeMethodResponse$log' => '<p>The API Gateway execution log for the test invoke request.</p>', 'TooManyRequestsException$retryAfterSeconds' => NULL, 'TooManyRequestsException$message' => NULL, 'UnauthorizedException$message' => NULL, 'UntagResourceRequest$resourceArn' => '<p>The ARN of a resource that can be tagged.</p>', 'UpdateApiKeyRequest$apiKey' => '<p>The identifier of the ApiKey resource to be updated.</p>', 'UpdateAuthorizerRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'UpdateAuthorizerRequest$authorizerId' => '<p>The identifier of the Authorizer resource.</p>', 'UpdateBasePathMappingRequest$domainName' => '<p>The domain name of the BasePathMapping resource to change.</p>', 'UpdateBasePathMappingRequest$basePath' => '<p>The base path of the BasePathMapping resource to change.</p> <p>To specify an empty base path, set this parameter to <code>\'(none)\'</code>.</p>', 'UpdateClientCertificateRequest$clientCertificateId' => '<p>The identifier of the ClientCertificate resource to be updated.</p>', 'UpdateDeploymentRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'UpdateDeploymentRequest$deploymentId' => '<p>The replacement identifier for the Deployment resource to change information about.</p>', 'UpdateDocumentationPartRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'UpdateDocumentationPartRequest$documentationPartId' => '<p>The identifier of the to-be-updated documentation part.</p>', 'UpdateDocumentationVersionRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'UpdateDocumentationVersionRequest$documentationVersion' => '<p>The version identifier of the to-be-updated documentation version.</p>', 'UpdateDomainNameRequest$domainName' => '<p>The name of the DomainName resource to be changed.</p>', 'UpdateGatewayResponseRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'UpdateIntegrationRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'UpdateIntegrationRequest$resourceId' => '<p>Represents an update integration request\'s resource identifier.</p>', 'UpdateIntegrationRequest$httpMethod' => '<p>Represents an update integration request\'s HTTP method.</p>', 'UpdateIntegrationResponseRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'UpdateIntegrationResponseRequest$resourceId' => '<p>Specifies an update integration response request\'s resource identifier.</p>', 'UpdateIntegrationResponseRequest$httpMethod' => '<p>Specifies an update integration response request\'s HTTP method.</p>', 'UpdateMethodRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'UpdateMethodRequest$resourceId' => '<p>The Resource identifier for the Method resource.</p>', 'UpdateMethodRequest$httpMethod' => '<p>The HTTP verb of the Method resource.</p>', 'UpdateMethodResponseRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'UpdateMethodResponseRequest$resourceId' => '<p>The Resource identifier for the MethodResponse resource.</p>', 'UpdateMethodResponseRequest$httpMethod' => '<p>The HTTP verb of the Method resource.</p>', 'UpdateModelRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'UpdateModelRequest$modelName' => '<p>The name of the model to update.</p>', 'UpdateRequestValidatorRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'UpdateRequestValidatorRequest$requestValidatorId' => '<p>The identifier of RequestValidator to be updated.</p>', 'UpdateResourceRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'UpdateResourceRequest$resourceId' => '<p>The identifier of the Resource resource.</p>', 'UpdateRestApiRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'UpdateStageRequest$restApiId' => '<p>The string identifier of the associated RestApi.</p>', 'UpdateStageRequest$stageName' => '<p>The name of the Stage resource to change information about.</p>', 'UpdateUsagePlanRequest$usagePlanId' => '<p>The Id of the to-be-updated usage plan.</p>', 'UpdateUsageRequest$usagePlanId' => '<p>The Id of the usage plan associated with the usage data.</p>', 'UpdateUsageRequest$keyId' => '<p>The identifier of the API key associated with the usage plan in which a temporary extension is granted to the remaining quota.</p>', 'UpdateVpcLinkRequest$vpcLinkId' => '<p>The identifier of the VpcLink. It is used in an Integration to reference this VpcLink.</p>', 'Usage$usagePlanId' => '<p>The plan Id associated with this usage data.</p>', 'Usage$startDate' => '<p>The starting date of the usage data.</p>', 'Usage$endDate' => '<p>The ending date of the usage data.</p>', 'Usage$position' => NULL, 'UsagePlan$id' => '<p>The identifier of a UsagePlan resource.</p>', 'UsagePlan$name' => '<p>The name of a usage plan.</p>', 'UsagePlan$description' => '<p>The description of a usage plan.</p>', 'UsagePlan$productCode' => '<p>The Amazon Web Services Marketplace product identifier to associate with the usage plan as a SaaS product on the Amazon Web Services Marketplace.</p>', 'UsagePlanKey$id' => '<p>The Id of a usage plan key.</p>', 'UsagePlanKey$type' => '<p>The type of a usage plan key. Currently, the valid key type is <code>API_KEY</code>.</p>', 'UsagePlanKey$value' => '<p>The value of a usage plan key.</p>', 'UsagePlanKey$name' => '<p>The name of a usage plan key.</p>', 'UsagePlanKeys$position' => NULL, 'UsagePlans$position' => NULL, 'VpcLink$id' => '<p>The identifier of the VpcLink. It is used in an Integration to reference this VpcLink.</p>', 'VpcLink$name' => '<p>The name used to label and identify the VPC link.</p>', 'VpcLink$description' => '<p>The description of the VPC link.</p>', 'VpcLink$statusMessage' => '<p>A description about the VPC link status.</p>', 'VpcLinks$position' => NULL, ], ], 'TagResourceRequest' => [ 'base' => '<p>Adds or updates a tag on a given resource.</p>', 'refs' => [], ], 'Tags' => [ 'base' => '<p>The collection of tags. Each tag element is associated with a given resource.</p>', 'refs' => [], ], 'Template' => [ 'base' => '<p>Represents a mapping template used to transform a payload.</p>', 'refs' => [], ], 'TestInvokeAuthorizerRequest' => [ 'base' => '<p>Make a request to simulate the invocation of an Authorizer.</p>', 'refs' => [], ], 'TestInvokeAuthorizerResponse' => [ 'base' => '<p>Represents the response of the test invoke request for a custom Authorizer</p>', 'refs' => [], ], 'TestInvokeMethodRequest' => [ 'base' => '<p>Make a request to simulate the invocation of a Method.</p>', 'refs' => [], ], 'TestInvokeMethodResponse' => [ 'base' => '<p>Represents the response of the test invoke request in the HTTP method.</p>', 'refs' => [], ], 'ThrottleSettings' => [ 'base' => '<p> The API request rate limits.</p>', 'refs' => [ 'Account$throttleSettings' => '<p>Specifies the API request limits configured for the current Account.</p>', 'CreateUsagePlanRequest$throttle' => '<p>The throttling limits of the usage plan.</p>', 'MapOfApiStageThrottleSettings$value' => NULL, 'UsagePlan$throttle' => '<p>A map containing method level throttling information for API stage in a usage plan.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'ApiKey$createdDate' => '<p>The timestamp when the API Key was created.</p>', 'ApiKey$lastUpdatedDate' => '<p>The timestamp when the API Key was last updated.</p>', 'ClientCertificate$createdDate' => '<p>The timestamp when the client certificate was created.</p>', 'ClientCertificate$expirationDate' => '<p>The timestamp when the client certificate will expire.</p>', 'Deployment$createdDate' => '<p>The date and time that the deployment resource was created.</p>', 'DocumentationVersion$createdDate' => '<p>The date when the API documentation snapshot is created.</p>', 'DomainName$certificateUploadDate' => '<p>The timestamp when the certificate that was used by edge-optimized endpoint for this domain name was uploaded.</p>', 'RestApi$createdDate' => '<p>The timestamp when the API was created.</p>', 'Stage$createdDate' => '<p>The timestamp when the stage was created.</p>', 'Stage$lastUpdatedDate' => '<p>The timestamp when the stage last updated.</p>', ], ], 'TlsConfig' => [ 'base' => '<p>Specifies the TLS configuration for an integration.</p>', 'refs' => [ 'Integration$tlsConfig' => '<p>Specifies the TLS configuration for an integration.</p>', 'PutIntegrationRequest$tlsConfig' => NULL, ], ], 'TooManyRequestsException' => [ 'base' => '<p>The request has reached its throttling limit. Retry after the specified time period.</p>', 'refs' => [], ], 'UnauthorizedCacheControlHeaderStrategy' => [ 'base' => NULL, 'refs' => [ 'MethodSetting$unauthorizedCacheControlHeaderStrategy' => '<p>Specifies how to handle unauthorized requests for cache invalidation.</p>', ], ], 'UnauthorizedException' => [ 'base' => '<p>The request is denied because the caller has insufficient permissions.</p>', 'refs' => [], ], 'UntagResourceRequest' => [ 'base' => '<p>Removes a tag from a given resource.</p>', 'refs' => [], ], 'UpdateAccountRequest' => [ 'base' => '<p>Requests API Gateway to change information about the current Account resource.</p>', 'refs' => [], ], 'UpdateApiKeyRequest' => [ 'base' => '<p>A request to change information about an ApiKey resource.</p>', 'refs' => [], ], 'UpdateAuthorizerRequest' => [ 'base' => '<p>Request to update an existing Authorizer resource.</p>', 'refs' => [], ], 'UpdateBasePathMappingRequest' => [ 'base' => '<p>A request to change information about the BasePathMapping resource.</p>', 'refs' => [], ], 'UpdateClientCertificateRequest' => [ 'base' => '<p>A request to change information about an ClientCertificate resource.</p>', 'refs' => [], ], 'UpdateDeploymentRequest' => [ 'base' => '<p>Requests API Gateway to change information about a Deployment resource.</p>', 'refs' => [], ], 'UpdateDocumentationPartRequest' => [ 'base' => '<p>Updates an existing documentation part of a given API.</p>', 'refs' => [], ], 'UpdateDocumentationVersionRequest' => [ 'base' => '<p>Updates an existing documentation version of an API.</p>', 'refs' => [], ], 'UpdateDomainNameRequest' => [ 'base' => '<p>A request to change information about the DomainName resource.</p>', 'refs' => [], ], 'UpdateGatewayResponseRequest' => [ 'base' => '<p>Updates a GatewayResponse of a specified response type on the given RestApi.</p>', 'refs' => [], ], 'UpdateIntegrationRequest' => [ 'base' => '<p>Represents an update integration request.</p>', 'refs' => [], ], 'UpdateIntegrationResponseRequest' => [ 'base' => '<p>Represents an update integration response request.</p>', 'refs' => [], ], 'UpdateMethodRequest' => [ 'base' => '<p>Request to update an existing Method resource.</p>', 'refs' => [], ], 'UpdateMethodResponseRequest' => [ 'base' => '<p>A request to update an existing MethodResponse resource.</p>', 'refs' => [], ], 'UpdateModelRequest' => [ 'base' => '<p>Request to update an existing model in an existing RestApi resource.</p>', 'refs' => [], ], 'UpdateRequestValidatorRequest' => [ 'base' => '<p>Updates a RequestValidator of a given RestApi.</p>', 'refs' => [], ], 'UpdateResourceRequest' => [ 'base' => '<p>Request to change information about a Resource resource.</p>', 'refs' => [], ], 'UpdateRestApiRequest' => [ 'base' => '<p>Request to update an existing RestApi resource in your collection.</p>', 'refs' => [], ], 'UpdateStageRequest' => [ 'base' => '<p>Requests API Gateway to change information about a Stage resource.</p>', 'refs' => [], ], 'UpdateUsagePlanRequest' => [ 'base' => '<p>The PATCH request to update a usage plan of a given plan Id.</p>', 'refs' => [], ], 'UpdateUsageRequest' => [ 'base' => '<p>The PATCH request to grant a temporary extension to the remaining quota of a usage plan associated with a specified API key.</p>', 'refs' => [], ], 'UpdateVpcLinkRequest' => [ 'base' => '<p>Updates an existing VpcLink of a specified identifier.</p>', 'refs' => [], ], 'Usage' => [ 'base' => '<p>Represents the usage data of a usage plan.</p>', 'refs' => [], ], 'UsagePlan' => [ 'base' => '<p>Represents a usage plan used to specify who can assess associated API stages. Optionally, target request rate and quota limits can be set. In some cases clients can exceed the targets that you set. Don’t rely on usage plans to control costs. Consider using <a href="https://docs.aws.amazon.com/cost-management/latest/userguide/budgets-managing-costs.html">Amazon Web Services Budgets</a> to monitor costs and <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF</a> to manage API requests.</p>', 'refs' => [ 'ListOfUsagePlan$member' => NULL, ], ], 'UsagePlanKey' => [ 'base' => '<p>Represents a usage plan key to identify a plan customer.</p>', 'refs' => [ 'ListOfUsagePlanKey$member' => NULL, ], ], 'UsagePlanKeys' => [ 'base' => '<p>Represents the collection of usage plan keys added to usage plans for the associated API keys and, possibly, other types of keys.</p>', 'refs' => [], ], 'UsagePlans' => [ 'base' => '<p>Represents a collection of usage plans for an AWS account.</p>', 'refs' => [], ], 'VpcLink' => [ 'base' => '<p>An API Gateway VPC link for a RestApi to access resources in an Amazon Virtual Private Cloud (VPC).</p>', 'refs' => [ 'ListOfVpcLink$member' => NULL, ], ], 'VpcLinkStatus' => [ 'base' => NULL, 'refs' => [ 'VpcLink$status' => '<p>The status of the VPC link. The valid values are <code>AVAILABLE</code>, <code>PENDING</code>, <code>DELETING</code>, or <code>FAILED</code>. Deploying an API will wait if the status is <code>PENDING</code> and will fail if the status is <code>DELETING</code>. </p>', ], ], 'VpcLinks' => [ 'base' => '<p>The collection of VPC links under the caller\'s account in a region.</p>', 'refs' => [], ], ],];
