<?php
// This file was auto-generated from sdk-root/src/data/appconfig/2019-10-09/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>AppConfig feature flags and dynamic configurations help software builders quickly and securely adjust application behavior in production environments without full code deployments. AppConfig speeds up software release frequency, improves application resiliency, and helps you address emergent issues more quickly. With feature flags, you can gradually release new capabilities to users and measure the impact of those changes before fully deploying the new capabilities to all users. With operational flags and dynamic configurations, you can update block lists, allow lists, throttling limits, logging verbosity, and perform other operational tuning to quickly respond to issues in production environments.</p> <note> <p>AppConfig is a capability of Amazon Web Services Systems Manager.</p> </note> <p>Despite the fact that application configuration content can vary greatly from application to application, AppConfig supports the following use cases, which cover a broad spectrum of customer needs:</p> <ul> <li> <p> <b>Feature flags and toggles</b> - Safely release new capabilities to your customers in a controlled environment. Instantly roll back changes if you experience a problem.</p> </li> <li> <p> <b>Application tuning</b> - Carefully introduce application changes while testing the impact of those changes with users in production environments.</p> </li> <li> <p> <b>Allow list or block list</b> - Control access to premium features or instantly block specific users without deploying new code. </p> </li> <li> <p> <b>Centralized configuration storage</b> - Keep your configuration data organized and consistent across all of your workloads. You can use AppConfig to deploy configuration data stored in the AppConfig hosted configuration store, Secrets Manager, Systems Manager, Parameter Store, or Amazon S3.</p> </li> </ul> <p> <b>How AppConfig works</b> </p> <p>This section provides a high-level description of how AppConfig works and how you get started.</p> <dl> <dt>1. Identify configuration values in code you want to manage in the cloud</dt> <dd> <p>Before you start creating AppConfig artifacts, we recommend you identify configuration data in your code that you want to dynamically manage using AppConfig. Good examples include feature flags or toggles, allow and block lists, logging verbosity, service limits, and throttling rules, to name a few.</p> <p>If your configuration data already exists in the cloud, you can take advantage of AppConfig validation, deployment, and extension features to further streamline configuration data management.</p> </dd> <dt>2. Create an application namespace</dt> <dd> <p>To create a namespace, you create an AppConfig artifact called an application. An application is simply an organizational construct like a folder.</p> </dd> <dt>3. Create environments</dt> <dd> <p>For each AppConfig application, you define one or more environments. An environment is a logical grouping of targets, such as applications in a <code>Beta</code> or <code>Production</code> environment, Lambda functions, or containers. You can also define environments for application subcomponents, such as the <code>Web</code>, <code>Mobile</code>, and <code>Back-end</code>.</p> <p>You can configure Amazon CloudWatch alarms for each environment. The system monitors alarms during a configuration deployment. If an alarm is triggered, the system rolls back the configuration.</p> </dd> <dt>4. Create a configuration profile</dt> <dd> <p>A configuration profile includes, among other things, a URI that enables AppConfig to locate your configuration data in its stored location and a profile type. AppConfig supports two configuration profile types: feature flags and freeform configurations. Feature flag configuration profiles store their data in the AppConfig hosted configuration store and the URI is simply <code>hosted</code>. For freeform configuration profiles, you can store your data in the AppConfig hosted configuration store or any Amazon Web Services service that integrates with AppConfig, as described in <a href="http://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-free-form-configurations-creating.html">Creating a free form configuration profile</a> in the the <i>AppConfig User Guide</i>.</p> <p>A configuration profile can also include optional validators to ensure your configuration data is syntactically and semantically correct. AppConfig performs a check using the validators when you start a deployment. If any errors are detected, the deployment rolls back to the previous configuration data.</p> </dd> <dt>5. Deploy configuration data</dt> <dd> <p>When you create a new deployment, you specify the following:</p> <ul> <li> <p>An application ID</p> </li> <li> <p>A configuration profile ID</p> </li> <li> <p>A configuration version</p> </li> <li> <p>An environment ID where you want to deploy the configuration data</p> </li> <li> <p>A deployment strategy ID that defines how fast you want the changes to take effect</p> </li> </ul> <p>When you call the <a href="https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_StartDeployment.html">StartDeployment</a> API action, AppConfig performs the following tasks:</p> <ol> <li> <p>Retrieves the configuration data from the underlying data store by using the location URI in the configuration profile.</p> </li> <li> <p>Verifies the configuration data is syntactically and semantically correct by using the validators you specified when you created your configuration profile.</p> </li> <li> <p>Caches a copy of the data so it is ready to be retrieved by your application. This cached copy is called the <i>deployed data</i>.</p> </li> </ol> </dd> <dt>6. Retrieve the configuration</dt> <dd> <p>You can configure AppConfig Agent as a local host and have the agent poll AppConfig for configuration updates. The agent calls the <a href="https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_StartConfigurationSession.html">StartConfigurationSession</a> and <a href="https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_GetLatestConfiguration.html">GetLatestConfiguration</a> API actions and caches your configuration data locally. To retrieve the data, your application makes an HTTP call to the localhost server. AppConfig Agent supports several use cases, as described in <a href="http://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-retrieving-simplified-methods.html">Simplified retrieval methods</a> in the the <i>AppConfig User Guide</i>.</p> <p>If AppConfig Agent isn\'t supported for your use case, you can configure your application to poll AppConfig for configuration updates by directly calling the <a href="https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_StartConfigurationSession.html">StartConfigurationSession</a> and <a href="https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_GetLatestConfiguration.html">GetLatestConfiguration</a> API actions. </p> </dd> </dl> <p>This reference is intended to be used with the <a href="http://docs.aws.amazon.com/appconfig/latest/userguide/what-is-appconfig.html">AppConfig User Guide</a>.</p>', 'operations' => [ 'CreateApplication' => '<p>Creates an application. In AppConfig, an application is simply an organizational construct like a folder. This organizational construct has a relationship with some unit of executable code. For example, you could create an application called MyMobileApp to organize and manage configuration data for a mobile application installed by your users.</p>', 'CreateConfigurationProfile' => '<p>Creates a configuration profile, which is information that enables AppConfig to access the configuration source. Valid configuration sources include the following:</p> <ul> <li> <p>Configuration data in YAML, JSON, and other formats stored in the AppConfig hosted configuration store</p> </li> <li> <p>Configuration data stored as objects in an Amazon Simple Storage Service (Amazon S3) bucket</p> </li> <li> <p>Pipelines stored in CodePipeline</p> </li> <li> <p>Secrets stored in Secrets Manager</p> </li> <li> <p>Standard and secure string parameters stored in Amazon Web Services Systems Manager Parameter Store</p> </li> <li> <p>Configuration data in SSM documents stored in the Systems Manager document store</p> </li> </ul> <p>A configuration profile includes the following information:</p> <ul> <li> <p>The URI location of the configuration data.</p> </li> <li> <p>The Identity and Access Management (IAM) role that provides access to the configuration data.</p> </li> <li> <p>A validator for the configuration data. Available validators include either a JSON Schema or an Amazon Web Services Lambda function.</p> </li> </ul> <p>For more information, see <a href="http://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-creating-configuration-and-profile.html">Create a Configuration and a Configuration Profile</a> in the <i>AppConfig User Guide</i>.</p>', 'CreateDeploymentStrategy' => '<p>Creates a deployment strategy that defines important criteria for rolling out your configuration to the designated targets. A deployment strategy includes the overall duration required, a percentage of targets to receive the deployment during each interval, an algorithm that defines how percentage grows, and bake time.</p>', 'CreateEnvironment' => '<p>Creates an environment. For each application, you define one or more environments. An environment is a deployment group of AppConfig targets, such as applications in a <code>Beta</code> or <code>Production</code> environment. You can also define environments for application subcomponents such as the <code>Web</code>, <code>Mobile</code> and <code>Back-end</code> components for your application. You can configure Amazon CloudWatch alarms for each environment. The system monitors alarms during a configuration deployment. If an alarm is triggered, the system rolls back the configuration.</p>', 'CreateExtension' => '<p>Creates an AppConfig extension. An extension augments your ability to inject logic or behavior at different points during the AppConfig workflow of creating or deploying a configuration.</p> <p>You can create your own extensions or use the Amazon Web Services authored extensions provided by AppConfig. For an AppConfig extension that uses Lambda, you must create a Lambda function to perform any computation and processing defined in the extension. If you plan to create custom versions of the Amazon Web Services authored notification extensions, you only need to specify an Amazon Resource Name (ARN) in the <code>Uri</code> field for the new extension version.</p> <ul> <li> <p>For a custom EventBridge notification extension, enter the ARN of the EventBridge default events in the <code>Uri</code> field.</p> </li> <li> <p>For a custom Amazon SNS notification extension, enter the ARN of an Amazon SNS topic in the <code>Uri</code> field.</p> </li> <li> <p>For a custom Amazon SQS notification extension, enter the ARN of an Amazon SQS message queue in the <code>Uri</code> field. </p> </li> </ul> <p>For more information about extensions, see <a href="https://docs.aws.amazon.com/appconfig/latest/userguide/working-with-appconfig-extensions.html">Extending workflows</a> in the <i>AppConfig User Guide</i>.</p>', 'CreateExtensionAssociation' => '<p>When you create an extension or configure an Amazon Web Services authored extension, you associate the extension with an AppConfig application, environment, or configuration profile. For example, you can choose to run the <code>AppConfig deployment events to Amazon SNS</code> Amazon Web Services authored extension and receive notifications on an Amazon SNS topic anytime a configuration deployment is started for a specific application. Defining which extension to associate with an AppConfig resource is called an <i>extension association</i>. An extension association is a specified relationship between an extension and an AppConfig resource, such as an application or a configuration profile. For more information about extensions and associations, see <a href="https://docs.aws.amazon.com/appconfig/latest/userguide/working-with-appconfig-extensions.html">Extending workflows</a> in the <i>AppConfig User Guide</i>.</p>', 'CreateHostedConfigurationVersion' => '<p>Creates a new configuration in the AppConfig hosted configuration store.</p>', 'DeleteApplication' => '<p>Deletes an application. Deleting an application does not delete a configuration from a host.</p>', 'DeleteConfigurationProfile' => '<p>Deletes a configuration profile. Deleting a configuration profile does not delete a configuration from a host.</p>', 'DeleteDeploymentStrategy' => '<p>Deletes a deployment strategy. Deleting a deployment strategy does not delete a configuration from a host.</p>', 'DeleteEnvironment' => '<p>Deletes an environment. Deleting an environment does not delete a configuration from a host.</p>', 'DeleteExtension' => '<p>Deletes an AppConfig extension. You must delete all associations to an extension before you delete the extension.</p>', 'DeleteExtensionAssociation' => '<p>Deletes an extension association. This action doesn\'t delete extensions defined in the association.</p>', 'DeleteHostedConfigurationVersion' => '<p>Deletes a version of a configuration from the AppConfig hosted configuration store.</p>', 'GetApplication' => '<p>Retrieves information about an application.</p>', 'GetConfiguration' => '<p>(Deprecated) Retrieves the latest deployed configuration.</p> <important> <p>Note the following important information.</p> <ul> <li> <p>This API action is deprecated. Calls to receive configuration data should use the <a href="https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_StartConfigurationSession.html">StartConfigurationSession</a> and <a href="https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_GetLatestConfiguration.html">GetLatestConfiguration</a> APIs instead. </p> </li> <li> <p> <code>GetConfiguration</code> is a priced call. For more information, see <a href="https://aws.amazon.com/systems-manager/pricing/">Pricing</a>.</p> </li> </ul> </important>', 'GetConfigurationProfile' => '<p>Retrieves information about a configuration profile.</p>', 'GetDeployment' => '<p>Retrieves information about a configuration deployment.</p>', 'GetDeploymentStrategy' => '<p>Retrieves information about a deployment strategy. A deployment strategy defines important criteria for rolling out your configuration to the designated targets. A deployment strategy includes the overall duration required, a percentage of targets to receive the deployment during each interval, an algorithm that defines how percentage grows, and bake time.</p>', 'GetEnvironment' => '<p>Retrieves information about an environment. An environment is a deployment group of AppConfig applications, such as applications in a <code>Production</code> environment or in an <code>EU_Region</code> environment. Each configuration deployment targets an environment. You can enable one or more Amazon CloudWatch alarms for an environment. If an alarm is triggered during a deployment, AppConfig roles back the configuration.</p>', 'GetExtension' => '<p>Returns information about an AppConfig extension.</p>', 'GetExtensionAssociation' => '<p>Returns information about an AppConfig extension association. For more information about extensions and associations, see <a href="https://docs.aws.amazon.com/appconfig/latest/userguide/working-with-appconfig-extensions.html">Extending workflows</a> in the <i>AppConfig User Guide</i>.</p>', 'GetHostedConfigurationVersion' => '<p>Retrieves information about a specific configuration version.</p>', 'ListApplications' => '<p>Lists all applications in your Amazon Web Services account.</p>', 'ListConfigurationProfiles' => '<p>Lists the configuration profiles for an application.</p>', 'ListDeploymentStrategies' => '<p>Lists deployment strategies.</p>', 'ListDeployments' => '<p>Lists the deployments for an environment in descending deployment number order.</p>', 'ListEnvironments' => '<p>Lists the environments for an application.</p>', 'ListExtensionAssociations' => '<p>Lists all AppConfig extension associations in the account. For more information about extensions and associations, see <a href="https://docs.aws.amazon.com/appconfig/latest/userguide/working-with-appconfig-extensions.html">Extending workflows</a> in the <i>AppConfig User Guide</i>.</p>', 'ListExtensions' => '<p>Lists all custom and Amazon Web Services authored AppConfig extensions in the account. For more information about extensions, see <a href="https://docs.aws.amazon.com/appconfig/latest/userguide/working-with-appconfig-extensions.html">Extending workflows</a> in the <i>AppConfig User Guide</i>.</p>', 'ListHostedConfigurationVersions' => '<p>Lists configurations stored in the AppConfig hosted configuration store by version.</p>', 'ListTagsForResource' => '<p>Retrieves the list of key-value tags assigned to the resource.</p>', 'StartDeployment' => '<p>Starts a deployment.</p>', 'StopDeployment' => '<p>Stops a deployment. This API action works only on deployments that have a status of <code>DEPLOYING</code>. This action moves the deployment to a status of <code>ROLLED_BACK</code>.</p>', 'TagResource' => '<p>Assigns metadata to an AppConfig resource. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define. You can specify a maximum of 50 tags for a resource.</p>', 'UntagResource' => '<p>Deletes a tag key and value from an AppConfig resource.</p>', 'UpdateApplication' => '<p>Updates an application.</p>', 'UpdateConfigurationProfile' => '<p>Updates a configuration profile.</p>', 'UpdateDeploymentStrategy' => '<p>Updates a deployment strategy.</p>', 'UpdateEnvironment' => '<p>Updates an environment.</p>', 'UpdateExtension' => '<p>Updates an AppConfig extension. For more information about extensions, see <a href="https://docs.aws.amazon.com/appconfig/latest/userguide/working-with-appconfig-extensions.html">Extending workflows</a> in the <i>AppConfig User Guide</i>.</p>', 'UpdateExtensionAssociation' => '<p>Updates an association. For more information about extensions and associations, see <a href="https://docs.aws.amazon.com/appconfig/latest/userguide/working-with-appconfig-extensions.html">Extending workflows</a> in the <i>AppConfig User Guide</i>.</p>', 'ValidateConfiguration' => '<p>Uses the validators in a configuration profile to validate a configuration.</p>', ], 'shapes' => [ 'Action' => [ 'base' => '<p>An action defines the tasks that the extension performs during the AppConfig workflow. Each action includes an action point such as <code>ON_CREATE_HOSTED_CONFIGURATION</code>, <code>PRE_DEPLOYMENT</code>, or <code>ON_DEPLOYMENT</code>. Each action also includes a name, a URI to an Lambda function, and an Amazon Resource Name (ARN) for an Identity and Access Management assume role. You specify the name, URI, and ARN for each <i>action point</i> defined in the extension. You can specify the following actions for an extension:</p> <ul> <li> <p> <code>PRE_CREATE_HOSTED_CONFIGURATION_VERSION</code> </p> </li> <li> <p> <code>PRE_START_DEPLOYMENT</code> </p> </li> <li> <p> <code>ON_DEPLOYMENT_START</code> </p> </li> <li> <p> <code>ON_DEPLOYMENT_STEP</code> </p> </li> <li> <p> <code>ON_DEPLOYMENT_BAKING</code> </p> </li> <li> <p> <code>ON_DEPLOYMENT_COMPLETE</code> </p> </li> <li> <p> <code>ON_DEPLOYMENT_ROLLED_BACK</code> </p> </li> </ul>', 'refs' => [ 'ActionList$member' => NULL, ], ], 'ActionInvocation' => [ 'base' => '<p>An extension that was invoked as part of a deployment event.</p>', 'refs' => [ 'ActionInvocations$member' => NULL, ], ], 'ActionInvocations' => [ 'base' => NULL, 'refs' => [ 'DeploymentEvent$ActionInvocations' => '<p>The list of extensions that were invoked as part of the deployment.</p>', ], ], 'ActionList' => [ 'base' => NULL, 'refs' => [ 'ActionsMap$value' => NULL, ], ], 'ActionPoint' => [ 'base' => NULL, 'refs' => [ 'ActionsMap$key' => NULL, ], ], 'ActionsMap' => [ 'base' => NULL, 'refs' => [ 'CreateExtensionRequest$Actions' => '<p>The actions defined in the extension.</p>', 'Extension$Actions' => '<p>The actions defined in the extension.</p>', 'UpdateExtensionRequest$Actions' => '<p>The actions defined in the extension.</p>', ], ], 'Application' => [ 'base' => NULL, 'refs' => [ 'ApplicationList$member' => NULL, ], ], 'ApplicationList' => [ 'base' => NULL, 'refs' => [ 'Applications$Items' => '<p>The elements from this collection.</p>', ], ], 'Applications' => [ 'base' => NULL, 'refs' => [], ], 'AppliedExtension' => [ 'base' => '<p>An extension that was invoked during a deployment.</p>', 'refs' => [ 'AppliedExtensions$member' => NULL, ], ], 'AppliedExtensions' => [ 'base' => NULL, 'refs' => [ 'Deployment$AppliedExtensions' => '<p>A list of extensions that were processed as part of the deployment. The extensions that were previously associated to the configuration profile, environment, or the application when <code>StartDeployment</code> was called.</p>', ], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'Action$RoleArn' => '<p>An Amazon Resource Name (ARN) for an Identity and Access Management assume role.</p>', 'ActionInvocation$RoleArn' => '<p>An Amazon Resource Name (ARN) for an Identity and Access Management assume role.</p>', 'ConfigurationProfile$KmsKeyArn' => '<p>The Amazon Resource Name of the Key Management Service key to encrypt new configuration data versions in the AppConfig hosted configuration store. This attribute is only used for <code>hosted</code> configuration types. To encrypt data managed in other configuration stores, see the documentation for how to specify an KMS key for that particular service.</p>', 'Deployment$KmsKeyArn' => '<p>The Amazon Resource Name of the Key Management Service key used to encrypt configuration data. You can encrypt secrets stored in Secrets Manager, Amazon Simple Storage Service (Amazon S3) objects encrypted with SSE-KMS, or secure string parameters stored in Amazon Web Services Systems Manager Parameter Store. </p>', 'Extension$Arn' => '<p>The system-generated Amazon Resource Name (ARN) for the extension.</p>', 'ExtensionAssociation$ExtensionArn' => '<p>The ARN of the extension defined in the association.</p>', 'ExtensionAssociation$ResourceArn' => '<p>The ARNs of applications, configuration profiles, or environments defined in the association.</p>', 'ExtensionAssociation$Arn' => '<p>The system-generated Amazon Resource Name (ARN) for the extension.</p>', 'ExtensionAssociationSummary$ExtensionArn' => '<p>The system-generated Amazon Resource Name (ARN) for the extension.</p>', 'ExtensionAssociationSummary$ResourceArn' => '<p>The ARNs of applications, configuration profiles, or environments defined in the association.</p>', 'ExtensionSummary$Arn' => '<p>The system-generated Amazon Resource Name (ARN) for the extension.</p>', 'HostedConfigurationVersion$KmsKeyArn' => '<p>The Amazon Resource Name of the Key Management Service key that was used to encrypt this specific version of the configuration data in the AppConfig hosted configuration store.</p>', 'HostedConfigurationVersionSummary$KmsKeyArn' => '<p>The Amazon Resource Name of the Key Management Service key that was used to encrypt this specific version of the configuration data in the AppConfig hosted configuration store.</p>', 'ListExtensionAssociationsRequest$ResourceIdentifier' => '<p>The ARN of an application, configuration profile, or environment.</p>', 'ListTagsForResourceRequest$ResourceArn' => '<p>The resource ARN.</p>', 'TagResourceRequest$ResourceArn' => '<p>The ARN of the resource for which to retrieve tags.</p>', 'UntagResourceRequest$ResourceArn' => '<p>The ARN of the resource for which to remove tags.</p>', ], ], 'BadRequestDetails' => [ 'base' => '<p>Detailed information about the input that failed to satisfy the constraints specified by a call.</p>', 'refs' => [ 'BadRequestException$Details' => NULL, ], ], 'BadRequestException' => [ 'base' => '<p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>', 'refs' => [], ], 'BadRequestReason' => [ 'base' => NULL, 'refs' => [ 'BadRequestException$Reason' => NULL, ], ], 'Blob' => [ 'base' => NULL, 'refs' => [ 'Configuration$Content' => '<p>The content of the configuration or the configuration data.</p> <important> <p>The <code>Content</code> attribute only contains data if the system finds new or updated configuration data. If there is no new or updated data and <code>ClientConfigurationVersion</code> matches the version of the current configuration, AppConfig returns a <code>204 No Content</code> HTTP response code and the <code>Content</code> value will be empty.</p> </important>', 'CreateHostedConfigurationVersionRequest$Content' => '<p>The content of the configuration or the configuration data.</p>', 'HostedConfigurationVersion$Content' => '<p>The content of the configuration or the configuration data.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'Parameter$Required' => '<p>A parameter value must be specified in the extension association.</p>', 'Parameter$Dynamic' => '<p>Indicates whether this parameter\'s value can be supplied at the extension\'s action point instead of during extension association. Dynamic parameters can\'t be marked <code>Required</code>.</p>', ], ], 'BytesMeasure' => [ 'base' => NULL, 'refs' => [ 'PayloadTooLargeException$Measure' => NULL, ], ], 'Configuration' => [ 'base' => NULL, 'refs' => [], ], 'ConfigurationProfile' => [ 'base' => NULL, 'refs' => [], ], 'ConfigurationProfileSummary' => [ 'base' => '<p>A summary of a configuration profile.</p>', 'refs' => [ 'ConfigurationProfileSummaryList$member' => NULL, ], ], 'ConfigurationProfileSummaryList' => [ 'base' => NULL, 'refs' => [ 'ConfigurationProfiles$Items' => '<p>The elements from this collection.</p>', ], ], 'ConfigurationProfileType' => [ 'base' => NULL, 'refs' => [ 'ConfigurationProfile$Type' => '<p>The type of configurations contained in the profile. AppConfig supports <code>feature flags</code> and <code>freeform</code> configurations. We recommend you create feature flag configurations to enable or disable new features and freeform configurations to distribute configurations to an application. When calling this API, enter one of the following values for <code>Type</code>:</p> <p> <code>AWS.AppConfig.FeatureFlags</code> </p> <p> <code>AWS.Freeform</code> </p>', 'ConfigurationProfileSummary$Type' => '<p>The type of configurations contained in the profile. AppConfig supports <code>feature flags</code> and <code>freeform</code> configurations. We recommend you create feature flag configurations to enable or disable new features and freeform configurations to distribute configurations to an application. When calling this API, enter one of the following values for <code>Type</code>:</p> <p> <code>AWS.AppConfig.FeatureFlags</code> </p> <p> <code>AWS.Freeform</code> </p>', 'CreateConfigurationProfileRequest$Type' => '<p>The type of configurations contained in the profile. AppConfig supports <code>feature flags</code> and <code>freeform</code> configurations. We recommend you create feature flag configurations to enable or disable new features and freeform configurations to distribute configurations to an application. When calling this API, enter one of the following values for <code>Type</code>:</p> <p> <code>AWS.AppConfig.FeatureFlags</code> </p> <p> <code>AWS.Freeform</code> </p>', 'ListConfigurationProfilesRequest$Type' => '<p>A filter based on the type of configurations that the configuration profile contains. A configuration can be a feature flag or a freeform configuration.</p>', ], ], 'ConfigurationProfiles' => [ 'base' => NULL, 'refs' => [], ], 'ConflictException' => [ 'base' => '<p>The request could not be processed because of conflict in the current state of the resource.</p>', 'refs' => [], ], 'CreateApplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateConfigurationProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDeploymentStrategyRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateEnvironmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateExtensionAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateExtensionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateHostedConfigurationVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteApplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteConfigurationProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDeploymentStrategyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEnvironmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteExtensionAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteExtensionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteHostedConfigurationVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'Deployment' => [ 'base' => NULL, 'refs' => [], ], 'DeploymentEvent' => [ 'base' => '<p>An object that describes a deployment event.</p>', 'refs' => [ 'DeploymentEvents$member' => NULL, ], ], 'DeploymentEventType' => [ 'base' => NULL, 'refs' => [ 'DeploymentEvent$EventType' => '<p>The type of deployment event. Deployment event types include the start, stop, or completion of a deployment; a percentage update; the start or stop of a bake period; and the start or completion of a rollback.</p>', ], ], 'DeploymentEvents' => [ 'base' => NULL, 'refs' => [ 'Deployment$EventLog' => '<p>A list containing all events related to a deployment. The most recent events are displayed first.</p>', ], ], 'DeploymentList' => [ 'base' => NULL, 'refs' => [ 'Deployments$Items' => '<p>The elements from this collection.</p>', ], ], 'DeploymentState' => [ 'base' => NULL, 'refs' => [ 'Deployment$State' => '<p>The state of the deployment.</p>', 'DeploymentSummary$State' => '<p>The state of the deployment.</p>', ], ], 'DeploymentStrategies' => [ 'base' => NULL, 'refs' => [], ], 'DeploymentStrategy' => [ 'base' => NULL, 'refs' => [ 'DeploymentStrategyList$member' => NULL, ], ], 'DeploymentStrategyId' => [ 'base' => NULL, 'refs' => [ 'DeleteDeploymentStrategyRequest$DeploymentStrategyId' => '<p>The ID of the deployment strategy you want to delete.</p>', 'GetDeploymentStrategyRequest$DeploymentStrategyId' => '<p>The ID of the deployment strategy to get.</p>', 'StartDeploymentRequest$DeploymentStrategyId' => '<p>The deployment strategy ID.</p>', 'UpdateDeploymentStrategyRequest$DeploymentStrategyId' => '<p>The deployment strategy ID.</p>', ], ], 'DeploymentStrategyList' => [ 'base' => NULL, 'refs' => [ 'DeploymentStrategies$Items' => '<p>The elements from this collection.</p>', ], ], 'DeploymentSummary' => [ 'base' => '<p>Information about the deployment.</p>', 'refs' => [ 'DeploymentList$member' => NULL, ], ], 'Deployments' => [ 'base' => NULL, 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'Action$Description' => '<p>Information about the action.</p>', 'Application$Description' => '<p>The description of the application.</p>', 'ConfigurationProfile$Description' => '<p>The configuration profile description.</p>', 'CreateApplicationRequest$Description' => '<p>A description of the application.</p>', 'CreateConfigurationProfileRequest$Description' => '<p>A description of the configuration profile.</p>', 'CreateDeploymentStrategyRequest$Description' => '<p>A description of the deployment strategy.</p>', 'CreateEnvironmentRequest$Description' => '<p>A description of the environment.</p>', 'CreateExtensionRequest$Description' => '<p>Information about the extension.</p>', 'CreateHostedConfigurationVersionRequest$Description' => '<p>A description of the configuration.</p>', 'Deployment$Description' => '<p>The description of the deployment.</p>', 'DeploymentEvent$Description' => '<p>A description of the deployment event. Descriptions include, but are not limited to, the following:</p> <ul> <li> <p>The Amazon Web Services account or the Amazon CloudWatch alarm ARN that initiated a rollback.</p> </li> <li> <p>The percentage of hosts that received the deployment.</p> </li> <li> <p>A recommendation to attempt a new deployment (in the case of an internal error).</p> </li> </ul>', 'DeploymentStrategy$Description' => '<p>The description of the deployment strategy.</p>', 'Environment$Description' => '<p>The description of the environment.</p>', 'Extension$Description' => '<p>Information about the extension.</p>', 'ExtensionSummary$Description' => '<p>Information about the extension.</p>', 'HostedConfigurationVersion$Description' => '<p>A description of the configuration.</p>', 'HostedConfigurationVersionSummary$Description' => '<p>A description of the configuration.</p>', 'Parameter$Description' => '<p>Information about the parameter.</p>', 'StartDeploymentRequest$Description' => '<p>A description of the deployment.</p>', 'UpdateApplicationRequest$Description' => '<p>A description of the application.</p>', 'UpdateConfigurationProfileRequest$Description' => '<p>A description of the configuration profile.</p>', 'UpdateDeploymentStrategyRequest$Description' => '<p>A description of the deployment strategy.</p>', 'UpdateEnvironmentRequest$Description' => '<p>A description of the environment.</p>', 'UpdateExtensionRequest$Description' => '<p>Information about the extension.</p>', ], ], 'DynamicParameterKey' => [ 'base' => NULL, 'refs' => [ 'DynamicParameterMap$key' => NULL, ], ], 'DynamicParameterMap' => [ 'base' => NULL, 'refs' => [ 'StartDeploymentRequest$DynamicExtensionParameters' => '<p>A map of dynamic extension parameter names to values to pass to associated extensions with <code>PRE_START_DEPLOYMENT</code> actions.</p>', ], ], 'Environment' => [ 'base' => NULL, 'refs' => [ 'EnvironmentList$member' => NULL, ], ], 'EnvironmentList' => [ 'base' => NULL, 'refs' => [ 'Environments$Items' => '<p>The elements from this collection.</p>', ], ], 'EnvironmentState' => [ 'base' => NULL, 'refs' => [ 'Environment$State' => '<p>The state of the environment. An environment can be in one of the following states: <code>READY_FOR_DEPLOYMENT</code>, <code>DEPLOYING</code>, <code>ROLLING_BACK</code>, or <code>ROLLED_BACK</code> </p>', ], ], 'Environments' => [ 'base' => NULL, 'refs' => [], ], 'Extension' => [ 'base' => NULL, 'refs' => [], ], 'ExtensionAssociation' => [ 'base' => NULL, 'refs' => [], ], 'ExtensionAssociationSummaries' => [ 'base' => NULL, 'refs' => [ 'ExtensionAssociations$Items' => '<p>The list of extension associations. Each item represents an extension association to an application, environment, or configuration profile. </p>', ], ], 'ExtensionAssociationSummary' => [ 'base' => '<p>Information about an association between an extension and an AppConfig resource such as an application, environment, or configuration profile. Call <code>GetExtensionAssociation</code> to get more information about an association.</p>', 'refs' => [ 'ExtensionAssociationSummaries$member' => NULL, ], ], 'ExtensionAssociations' => [ 'base' => NULL, 'refs' => [], ], 'ExtensionOrParameterName' => [ 'base' => NULL, 'refs' => [ 'CreateExtensionRequest$Name' => '<p>A name for the extension. Each extension name in your account must be unique. Extension versions use the same name.</p>', 'ParameterMap$key' => NULL, 'ParameterValueMap$key' => NULL, ], ], 'ExtensionSummaries' => [ 'base' => NULL, 'refs' => [ 'Extensions$Items' => '<p>The list of available extensions. The list includes Amazon Web Services authored and user-created extensions.</p>', ], ], 'ExtensionSummary' => [ 'base' => '<p>Information about an extension. Call <code>GetExtension</code> to get more information about an extension.</p>', 'refs' => [ 'ExtensionSummaries$member' => NULL, ], ], 'Extensions' => [ 'base' => NULL, 'refs' => [], ], 'Float' => [ 'base' => NULL, 'refs' => [ 'PayloadTooLargeException$Limit' => NULL, 'PayloadTooLargeException$Size' => NULL, ], ], 'GetApplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetConfigurationProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDeploymentRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDeploymentStrategyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetEnvironmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetExtensionAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetExtensionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetHostedConfigurationVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GrowthFactor' => [ 'base' => NULL, 'refs' => [ 'CreateDeploymentStrategyRequest$GrowthFactor' => '<p>The percentage of targets to receive a deployed configuration during each interval.</p>', 'UpdateDeploymentStrategyRequest$GrowthFactor' => '<p>The percentage of targets to receive a deployed configuration during each interval.</p>', ], ], 'GrowthType' => [ 'base' => NULL, 'refs' => [ 'CreateDeploymentStrategyRequest$GrowthType' => '<p>The algorithm used to define how percentage grows over time. AppConfig supports the following growth types:</p> <p> <b>Linear</b>: For this type, AppConfig processes the deployment by dividing the total number of targets by the value specified for <code>Step percentage</code>. For example, a linear deployment that uses a <code>Step percentage</code> of 10 deploys the configuration to 10 percent of the hosts. After those deployments are complete, the system deploys the configuration to the next 10 percent. This continues until 100% of the targets have successfully received the configuration.</p> <p> <b>Exponential</b>: For this type, AppConfig processes the deployment exponentially using the following formula: <code>G*(2^N)</code>. In this formula, <code>G</code> is the growth factor specified by the user and <code>N</code> is the number of steps until the configuration is deployed to all targets. For example, if you specify a growth factor of 2, then the system rolls out the configuration as follows:</p> <p> <code>2*(2^0)</code> </p> <p> <code>2*(2^1)</code> </p> <p> <code>2*(2^2)</code> </p> <p>Expressed numerically, the deployment rolls out as follows: 2% of the targets, 4% of the targets, 8% of the targets, and continues until the configuration has been deployed to all targets.</p>', 'Deployment$GrowthType' => '<p>The algorithm used to define how percentage grew over time.</p>', 'DeploymentStrategy$GrowthType' => '<p>The algorithm used to define how percentage grew over time.</p>', 'DeploymentSummary$GrowthType' => '<p>The algorithm used to define how percentage grows over time.</p>', 'UpdateDeploymentStrategyRequest$GrowthType' => '<p>The algorithm used to define how percentage grows over time. AppConfig supports the following growth types:</p> <p> <b>Linear</b>: For this type, AppConfig processes the deployment by increments of the growth factor evenly distributed over the deployment time. For example, a linear deployment that uses a growth factor of 20 initially makes the configuration available to 20 percent of the targets. After 1/5th of the deployment time has passed, the system updates the percentage to 40 percent. This continues until 100% of the targets are set to receive the deployed configuration.</p> <p> <b>Exponential</b>: For this type, AppConfig processes the deployment exponentially using the following formula: <code>G*(2^N)</code>. In this formula, <code>G</code> is the growth factor specified by the user and <code>N</code> is the number of steps until the configuration is deployed to all targets. For example, if you specify a growth factor of 2, then the system rolls out the configuration as follows:</p> <p> <code>2*(2^0)</code> </p> <p> <code>2*(2^1)</code> </p> <p> <code>2*(2^2)</code> </p> <p>Expressed numerically, the deployment rolls out as follows: 2% of the targets, 4% of the targets, 8% of the targets, and continues until the configuration has been deployed to all targets.</p>', ], ], 'HostedConfigurationVersion' => [ 'base' => NULL, 'refs' => [], ], 'HostedConfigurationVersionSummary' => [ 'base' => '<p>Information about the configuration.</p>', 'refs' => [ 'HostedConfigurationVersionSummaryList$member' => NULL, ], ], 'HostedConfigurationVersionSummaryList' => [ 'base' => NULL, 'refs' => [ 'HostedConfigurationVersions$Items' => '<p>The elements from this collection.</p>', ], ], 'HostedConfigurationVersions' => [ 'base' => NULL, 'refs' => [], ], 'Id' => [ 'base' => NULL, 'refs' => [ 'ActionInvocation$InvocationId' => '<p>A system-generated ID for this invocation.</p>', 'Application$Id' => '<p>The application ID.</p>', 'AppliedExtension$ExtensionId' => '<p>The system-generated ID of the extension.</p>', 'AppliedExtension$ExtensionAssociationId' => '<p>The system-generated ID for the association.</p>', 'ConfigurationProfile$ApplicationId' => '<p>The application ID.</p>', 'ConfigurationProfile$Id' => '<p>The configuration profile ID.</p>', 'ConfigurationProfileSummary$ApplicationId' => '<p>The application ID.</p>', 'ConfigurationProfileSummary$Id' => '<p>The ID of the configuration profile.</p>', 'CreateConfigurationProfileRequest$ApplicationId' => '<p>The application ID.</p>', 'CreateEnvironmentRequest$ApplicationId' => '<p>The application ID.</p>', 'CreateHostedConfigurationVersionRequest$ApplicationId' => '<p>The application ID.</p>', 'CreateHostedConfigurationVersionRequest$ConfigurationProfileId' => '<p>The configuration profile ID.</p>', 'DeleteApplicationRequest$ApplicationId' => '<p>The ID of the application to delete.</p>', 'DeleteConfigurationProfileRequest$ApplicationId' => '<p>The application ID that includes the configuration profile you want to delete.</p>', 'DeleteConfigurationProfileRequest$ConfigurationProfileId' => '<p>The ID of the configuration profile you want to delete.</p>', 'DeleteEnvironmentRequest$ApplicationId' => '<p>The application ID that includes the environment that you want to delete.</p>', 'DeleteEnvironmentRequest$EnvironmentId' => '<p>The ID of the environment that you want to delete.</p>', 'DeleteExtensionAssociationRequest$ExtensionAssociationId' => '<p>The ID of the extension association to delete.</p>', 'DeleteHostedConfigurationVersionRequest$ApplicationId' => '<p>The application ID.</p>', 'DeleteHostedConfigurationVersionRequest$ConfigurationProfileId' => '<p>The configuration profile ID.</p>', 'Deployment$ApplicationId' => '<p>The ID of the application that was deployed.</p>', 'Deployment$EnvironmentId' => '<p>The ID of the environment that was deployed.</p>', 'Deployment$DeploymentStrategyId' => '<p>The ID of the deployment strategy that was deployed.</p>', 'Deployment$ConfigurationProfileId' => '<p>The ID of the configuration profile that was deployed.</p>', 'DeploymentStrategy$Id' => '<p>The deployment strategy ID.</p>', 'Environment$ApplicationId' => '<p>The application ID.</p>', 'Environment$Id' => '<p>The environment ID.</p>', 'Extension$Id' => '<p>The system-generated ID of the extension.</p>', 'ExtensionSummary$Id' => '<p>The system-generated ID of the extension.</p>', 'GetApplicationRequest$ApplicationId' => '<p>The ID of the application you want to get.</p>', 'GetConfigurationProfileRequest$ApplicationId' => '<p>The ID of the application that includes the configuration profile you want to get.</p>', 'GetConfigurationProfileRequest$ConfigurationProfileId' => '<p>The ID of the configuration profile that you want to get.</p>', 'GetDeploymentRequest$ApplicationId' => '<p>The ID of the application that includes the deployment you want to get. </p>', 'GetDeploymentRequest$EnvironmentId' => '<p>The ID of the environment that includes the deployment you want to get. </p>', 'GetEnvironmentRequest$ApplicationId' => '<p>The ID of the application that includes the environment you want to get.</p>', 'GetEnvironmentRequest$EnvironmentId' => '<p>The ID of the environment that you want to get.</p>', 'GetExtensionAssociationRequest$ExtensionAssociationId' => '<p>The extension association ID to get.</p>', 'GetHostedConfigurationVersionRequest$ApplicationId' => '<p>The application ID.</p>', 'GetHostedConfigurationVersionRequest$ConfigurationProfileId' => '<p>The configuration profile ID.</p>', 'HostedConfigurationVersion$ApplicationId' => '<p>The application ID.</p>', 'HostedConfigurationVersion$ConfigurationProfileId' => '<p>The configuration profile ID.</p>', 'HostedConfigurationVersionSummary$ApplicationId' => '<p>The application ID.</p>', 'HostedConfigurationVersionSummary$ConfigurationProfileId' => '<p>The configuration profile ID.</p>', 'ListConfigurationProfilesRequest$ApplicationId' => '<p>The application ID.</p>', 'ListDeploymentsRequest$ApplicationId' => '<p>The application ID.</p>', 'ListDeploymentsRequest$EnvironmentId' => '<p>The environment ID.</p>', 'ListEnvironmentsRequest$ApplicationId' => '<p>The application ID.</p>', 'ListHostedConfigurationVersionsRequest$ApplicationId' => '<p>The application ID.</p>', 'ListHostedConfigurationVersionsRequest$ConfigurationProfileId' => '<p>The configuration profile ID.</p>', 'StartDeploymentRequest$ApplicationId' => '<p>The application ID.</p>', 'StartDeploymentRequest$EnvironmentId' => '<p>The environment ID.</p>', 'StartDeploymentRequest$ConfigurationProfileId' => '<p>The configuration profile ID.</p>', 'StopDeploymentRequest$ApplicationId' => '<p>The application ID.</p>', 'StopDeploymentRequest$EnvironmentId' => '<p>The environment ID.</p>', 'UpdateApplicationRequest$ApplicationId' => '<p>The application ID.</p>', 'UpdateConfigurationProfileRequest$ApplicationId' => '<p>The application ID.</p>', 'UpdateConfigurationProfileRequest$ConfigurationProfileId' => '<p>The ID of the configuration profile.</p>', 'UpdateEnvironmentRequest$ApplicationId' => '<p>The application ID.</p>', 'UpdateEnvironmentRequest$EnvironmentId' => '<p>The environment ID.</p>', 'UpdateExtensionAssociationRequest$ExtensionAssociationId' => '<p>The system-generated ID for the association.</p>', 'ValidateConfigurationRequest$ApplicationId' => '<p>The application ID.</p>', 'ValidateConfigurationRequest$ConfigurationProfileId' => '<p>The configuration profile ID.</p>', ], ], 'Identifier' => [ 'base' => NULL, 'refs' => [ 'ActionInvocation$ExtensionIdentifier' => '<p>The name, the ID, or the Amazon Resource Name (ARN) of the extension.</p>', 'CreateExtensionAssociationRequest$ExtensionIdentifier' => '<p>The name, the ID, or the Amazon Resource Name (ARN) of the extension.</p>', 'CreateExtensionAssociationRequest$ResourceIdentifier' => '<p>The ARN of an application, configuration profile, or environment.</p>', 'DeleteExtensionRequest$ExtensionIdentifier' => '<p>The name, ID, or Amazon Resource Name (ARN) of the extension you want to delete.</p>', 'ExtensionAssociation$Id' => '<p>The system-generated ID for the association.</p>', 'ExtensionAssociationSummary$Id' => '<p>The extension association ID. This ID is used to call other <code>ExtensionAssociation</code> API actions such as <code>GetExtensionAssociation</code> or <code>DeleteExtensionAssociation</code>.</p>', 'GetExtensionRequest$ExtensionIdentifier' => '<p>The name, the ID, or the Amazon Resource Name (ARN) of the extension.</p>', 'ListExtensionAssociationsRequest$ExtensionIdentifier' => '<p>The name, the ID, or the Amazon Resource Name (ARN) of the extension.</p>', 'UpdateExtensionRequest$ExtensionIdentifier' => '<p>The name, the ID, or the Amazon Resource Name (ARN) of the extension.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'AppliedExtension$VersionNumber' => '<p>The extension version number.</p>', 'CreateExtensionAssociationRequest$ExtensionVersionNumber' => '<p>The version number of the extension. If not specified, AppConfig uses the maximum version of the extension.</p>', 'CreateExtensionRequest$LatestVersionNumber' => '<p>You can omit this field when you create an extension. When you create a new version, specify the most recent current version number. For example, you create version 3, enter 2 for this field.</p>', 'CreateHostedConfigurationVersionRequest$LatestVersionNumber' => '<p>An optional locking token used to prevent race conditions from overwriting configuration updates when creating a new version. To ensure your data is not overwritten when creating multiple hosted configuration versions in rapid succession, specify the version number of the latest hosted configuration version.</p>', 'DeleteExtensionRequest$VersionNumber' => '<p>A specific version of an extension to delete. If omitted, the highest version is deleted.</p>', 'DeleteHostedConfigurationVersionRequest$VersionNumber' => '<p>The versions number to delete.</p>', 'Deployment$DeploymentNumber' => '<p>The sequence number of the deployment.</p>', 'DeploymentSummary$DeploymentNumber' => '<p>The sequence number of the deployment.</p>', 'Extension$VersionNumber' => '<p>The extension version number.</p>', 'ExtensionAssociation$ExtensionVersionNumber' => '<p>The version number for the extension defined in the association.</p>', 'ExtensionSummary$VersionNumber' => '<p>The extension version number.</p>', 'GetDeploymentRequest$DeploymentNumber' => '<p>The sequence number of the deployment.</p>', 'GetExtensionRequest$VersionNumber' => '<p>The extension version number. If no version number was defined, AppConfig uses the highest version.</p>', 'GetHostedConfigurationVersionRequest$VersionNumber' => '<p>The version.</p>', 'HostedConfigurationVersion$VersionNumber' => '<p>The configuration version.</p>', 'HostedConfigurationVersionSummary$VersionNumber' => '<p>The configuration version.</p>', 'ListExtensionAssociationsRequest$ExtensionVersionNumber' => '<p>The version number for the extension defined in the association.</p>', 'StopDeploymentRequest$DeploymentNumber' => '<p>The sequence number of the deployment.</p>', 'UpdateExtensionRequest$VersionNumber' => '<p>The extension version number.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>There was an internal failure in the AppConfig service.</p>', 'refs' => [], ], 'InvalidConfigurationDetail' => [ 'base' => '<p>Detailed information about the bad request exception error when creating a hosted configuration version.</p>', 'refs' => [ 'InvalidConfigurationDetailList$member' => NULL, ], ], 'InvalidConfigurationDetailList' => [ 'base' => NULL, 'refs' => [ 'BadRequestDetails$InvalidConfiguration' => '<p>Detailed information about the bad request exception error when creating a hosted configuration version.</p>', ], ], 'Iso8601DateTime' => [ 'base' => NULL, 'refs' => [ 'Deployment$StartedAt' => '<p>The time the deployment started.</p>', 'Deployment$CompletedAt' => '<p>The time the deployment completed. </p>', 'DeploymentEvent$OccurredAt' => '<p>The date and time the event occurred.</p>', 'DeploymentSummary$StartedAt' => '<p>Time the deployment started.</p>', 'DeploymentSummary$CompletedAt' => '<p>Time the deployment completed.</p>', ], ], 'KmsKeyIdentifier' => [ 'base' => NULL, 'refs' => [ 'ConfigurationProfile$KmsKeyIdentifier' => '<p>The Key Management Service key identifier (key ID, key alias, or key ARN) provided when the resource was created or updated.</p>', 'CreateConfigurationProfileRequest$KmsKeyIdentifier' => '<p>The identifier for an Key Management Service key to encrypt new configuration data versions in the AppConfig hosted configuration store. This attribute is only used for <code>hosted</code> configuration types. The identifier can be an KMS key ID, alias, or the Amazon Resource Name (ARN) of the key ID or alias. To encrypt data managed in other configuration stores, see the documentation for how to specify an KMS key for that particular service.</p>', 'Deployment$KmsKeyIdentifier' => '<p>The Key Management Service key identifier (key ID, key alias, or key ARN) provided when the resource was created or updated.</p>', 'StartDeploymentRequest$KmsKeyIdentifier' => '<p>The KMS key identifier (key ID, key alias, or key ARN). AppConfig uses this ID to encrypt the configuration data using a customer managed key. </p>', ], ], 'KmsKeyIdentifierOrEmpty' => [ 'base' => NULL, 'refs' => [ 'UpdateConfigurationProfileRequest$KmsKeyIdentifier' => '<p>The identifier for a Key Management Service key to encrypt new configuration data versions in the AppConfig hosted configuration store. This attribute is only used for <code>hosted</code> configuration types. The identifier can be an KMS key ID, alias, or the Amazon Resource Name (ARN) of the key ID or alias. To encrypt data managed in other configuration stores, see the documentation for how to specify an KMS key for that particular service.</p>', ], ], 'ListApplicationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListConfigurationProfilesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDeploymentStrategiesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDeploymentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListEnvironmentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListExtensionAssociationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListExtensionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListHostedConfigurationVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'LongName' => [ 'base' => NULL, 'refs' => [ 'ConfigurationProfile$Name' => '<p>The name of the configuration profile.</p>', 'ConfigurationProfileSummary$Name' => '<p>The name of the configuration profile.</p>', 'CreateConfigurationProfileRequest$Name' => '<p>A name for the configuration profile.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListApplicationsRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'ListConfigurationProfilesRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'ListDeploymentStrategiesRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'ListDeploymentsRequest$MaxResults' => '<p>The maximum number of items that may be returned for this call. If there are items that have not yet been returned, the response will include a non-null <code>NextToken</code> that you can provide in a subsequent call to get the next set of results.</p>', 'ListEnvironmentsRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'ListExtensionAssociationsRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'ListExtensionsRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'ListHostedConfigurationVersionsRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', ], ], 'MinutesBetween0And24Hours' => [ 'base' => NULL, 'refs' => [ 'CreateDeploymentStrategyRequest$DeploymentDurationInMinutes' => '<p>Total amount of time for a deployment to last.</p>', 'CreateDeploymentStrategyRequest$FinalBakeTimeInMinutes' => '<p>Specifies the amount of time AppConfig monitors for Amazon CloudWatch alarms after the configuration has been deployed to 100% of its targets, before considering the deployment to be complete. If an alarm is triggered during this time, AppConfig rolls back the deployment. You must configure permissions for AppConfig to roll back based on CloudWatch alarms. For more information, see <a href="https://docs.aws.amazon.com/appconfig/latest/userguide/getting-started-with-appconfig-cloudwatch-alarms-permissions.html">Configuring permissions for rollback based on Amazon CloudWatch alarms</a> in the <i>AppConfig User Guide</i>.</p>', 'Deployment$DeploymentDurationInMinutes' => '<p>Total amount of time the deployment lasted.</p>', 'Deployment$FinalBakeTimeInMinutes' => '<p>The amount of time that AppConfig monitored for alarms before considering the deployment to be complete and no longer eligible for automatic rollback.</p>', 'DeploymentStrategy$DeploymentDurationInMinutes' => '<p>Total amount of time the deployment lasted.</p>', 'DeploymentStrategy$FinalBakeTimeInMinutes' => '<p>The amount of time that AppConfig monitored for alarms before considering the deployment to be complete and no longer eligible for automatic rollback.</p>', 'DeploymentSummary$DeploymentDurationInMinutes' => '<p>Total amount of time the deployment lasted.</p>', 'DeploymentSummary$FinalBakeTimeInMinutes' => '<p>The amount of time that AppConfig monitors for alarms before considering the deployment to be complete and no longer eligible for automatic rollback.</p>', 'UpdateDeploymentStrategyRequest$DeploymentDurationInMinutes' => '<p>Total amount of time for a deployment to last.</p>', 'UpdateDeploymentStrategyRequest$FinalBakeTimeInMinutes' => '<p>The amount of time that AppConfig monitors for alarms before considering the deployment to be complete and no longer eligible for automatic rollback.</p>', ], ], 'Monitor' => [ 'base' => '<p>Amazon CloudWatch alarms to monitor during the deployment process.</p>', 'refs' => [ 'MonitorList$member' => NULL, ], ], 'MonitorList' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentRequest$Monitors' => '<p>Amazon CloudWatch alarms to monitor during the deployment process.</p>', 'Environment$Monitors' => '<p>Amazon CloudWatch alarms monitored during the deployment.</p>', 'UpdateEnvironmentRequest$Monitors' => '<p>Amazon CloudWatch alarms to monitor during the deployment process.</p>', ], ], 'Name' => [ 'base' => NULL, 'refs' => [ 'Action$Name' => '<p>The action name.</p>', 'ActionInvocation$ActionName' => '<p>The name of the action.</p>', 'Application$Name' => '<p>The application name.</p>', 'CreateApplicationRequest$Name' => '<p>A name for the application.</p>', 'CreateDeploymentStrategyRequest$Name' => '<p>A name for the deployment strategy.</p>', 'CreateEnvironmentRequest$Name' => '<p>A name for the environment.</p>', 'Deployment$ConfigurationName' => '<p>The name of the configuration.</p>', 'DeploymentStrategy$Name' => '<p>The name of the deployment strategy.</p>', 'DeploymentSummary$ConfigurationName' => '<p>The name of the configuration.</p>', 'Environment$Name' => '<p>The name of the environment.</p>', 'Extension$Name' => '<p>The extension name.</p>', 'ExtensionSummary$Name' => '<p>The extension name.</p>', 'UpdateApplicationRequest$Name' => '<p>The name of the application.</p>', 'UpdateConfigurationProfileRequest$Name' => '<p>The name of the configuration profile.</p>', 'UpdateEnvironmentRequest$Name' => '<p>The name of the environment.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'Applications$NextToken' => '<p>The token for the next set of items to return. Use this token to get the next set of results.</p>', 'ConfigurationProfiles$NextToken' => '<p>The token for the next set of items to return. Use this token to get the next set of results.</p>', 'DeploymentStrategies$NextToken' => '<p>The token for the next set of items to return. Use this token to get the next set of results.</p>', 'Deployments$NextToken' => '<p>The token for the next set of items to return. Use this token to get the next set of results.</p>', 'Environments$NextToken' => '<p>The token for the next set of items to return. Use this token to get the next set of results.</p>', 'ExtensionAssociations$NextToken' => '<p>The token for the next set of items to return. Use this token to get the next set of results.</p>', 'Extensions$NextToken' => '<p>The token for the next set of items to return. Use this token to get the next set of results.</p>', 'HostedConfigurationVersions$NextToken' => '<p>The token for the next set of items to return. Use this token to get the next set of results.</p>', 'ListApplicationsRequest$NextToken' => '<p>A token to start the list. Next token is a pagination token generated by AppConfig to describe what page the previous List call ended on. For the first List request, the nextToken should not be set. On subsequent calls, the nextToken parameter should be set to the previous responses nextToken value. Use this token to get the next set of results. </p>', 'ListConfigurationProfilesRequest$NextToken' => '<p>A token to start the list. Use this token to get the next set of results.</p>', 'ListDeploymentStrategiesRequest$NextToken' => '<p>A token to start the list. Use this token to get the next set of results.</p>', 'ListDeploymentsRequest$NextToken' => '<p>The token returned by a prior call to this operation indicating the next set of results to be returned. If not specified, the operation will return the first set of results.</p>', 'ListEnvironmentsRequest$NextToken' => '<p>A token to start the list. Use this token to get the next set of results.</p>', 'ListExtensionAssociationsRequest$NextToken' => '<p>A token to start the list. Use this token to get the next set of results or pass null to get the first set of results. </p>', 'ListExtensionsRequest$NextToken' => '<p>A token to start the list. Use this token to get the next set of results. </p>', 'ListHostedConfigurationVersionsRequest$NextToken' => '<p>A token to start the list. Use this token to get the next set of results. </p>', ], ], 'Parameter' => [ 'base' => '<p>A value such as an Amazon Resource Name (ARN) or an Amazon Simple Notification Service topic entered in an extension when invoked. Parameter values are specified in an extension association. For more information about extensions, see <a href="https://docs.aws.amazon.com/appconfig/latest/userguide/working-with-appconfig-extensions.html">Extending workflows</a> in the <i>AppConfig User Guide</i>.</p>', 'refs' => [ 'ParameterMap$value' => NULL, ], ], 'ParameterMap' => [ 'base' => NULL, 'refs' => [ 'CreateExtensionRequest$Parameters' => '<p>The parameters accepted by the extension. You specify parameter values when you associate the extension to an AppConfig resource by using the <code>CreateExtensionAssociation</code> API action. For Lambda extension actions, these parameters are included in the Lambda request object.</p>', 'Extension$Parameters' => '<p>The parameters accepted by the extension. You specify parameter values when you associate the extension to an AppConfig resource by using the <code>CreateExtensionAssociation</code> API action. For Lambda extension actions, these parameters are included in the Lambda request object.</p>', 'UpdateExtensionRequest$Parameters' => '<p>One or more parameters for the actions called by the extension.</p>', ], ], 'ParameterValueMap' => [ 'base' => NULL, 'refs' => [ 'AppliedExtension$Parameters' => '<p>One or more parameters for the actions called by the extension.</p>', 'CreateExtensionAssociationRequest$Parameters' => '<p>The parameter names and values defined in the extensions. Extension parameters marked <code>Required</code> must be entered for this field.</p>', 'ExtensionAssociation$Parameters' => '<p>The parameter names and values defined in the association.</p>', 'UpdateExtensionAssociationRequest$Parameters' => '<p>The parameter names and values defined in the extension.</p>', ], ], 'PayloadTooLargeException' => [ 'base' => '<p>The configuration size is too large.</p>', 'refs' => [], ], 'Percentage' => [ 'base' => NULL, 'refs' => [ 'Deployment$GrowthFactor' => '<p>The percentage of targets to receive a deployed configuration during each interval.</p>', 'Deployment$PercentageComplete' => '<p>The percentage of targets for which the deployment is available.</p>', 'DeploymentStrategy$GrowthFactor' => '<p>The percentage of targets that received a deployed configuration during each interval.</p>', 'DeploymentSummary$GrowthFactor' => '<p>The percentage of targets to receive a deployed configuration during each interval.</p>', 'DeploymentSummary$PercentageComplete' => '<p>The percentage of targets for which the deployment is available.</p>', ], ], 'QueryName' => [ 'base' => NULL, 'refs' => [ 'ListExtensionsRequest$Name' => '<p>The extension name.</p>', 'ListHostedConfigurationVersionsRequest$VersionLabel' => '<p>An optional filter that can be used to specify the version label of an AppConfig hosted configuration version. This parameter supports filtering by prefix using a wildcard, for example "v2*". If you don\'t specify an asterisk at the end of the value, only an exact match is returned.</p>', ], ], 'ReplicateTo' => [ 'base' => NULL, 'refs' => [ 'CreateDeploymentStrategyRequest$ReplicateTo' => '<p>Save the deployment strategy to a Systems Manager (SSM) document.</p>', 'DeploymentStrategy$ReplicateTo' => '<p>Save the deployment strategy to a Systems Manager (SSM) document.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The requested resource could not be found.</p>', 'refs' => [], ], 'ResourceTags' => [ 'base' => NULL, 'refs' => [], ], 'RoleArn' => [ 'base' => NULL, 'refs' => [ 'ConfigurationProfile$RetrievalRoleArn' => '<p>The ARN of an IAM role with permission to access the configuration at the specified <code>LocationUri</code>.</p>', 'CreateConfigurationProfileRequest$RetrievalRoleArn' => '<p>The ARN of an IAM role with permission to access the configuration at the specified <code>LocationUri</code>.</p> <important> <p>A retrieval role ARN is not required for configurations stored in the AppConfig hosted configuration store. It is required for all other sources that store your configuration. </p> </important>', 'Monitor$AlarmRoleArn' => '<p>ARN of an Identity and Access Management (IAM) role for AppConfig to monitor <code>AlarmArn</code>.</p>', 'UpdateConfigurationProfileRequest$RetrievalRoleArn' => '<p>The ARN of an IAM role with permission to access the configuration at the specified <code>LocationUri</code>.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>The number of one more AppConfig resources exceeds the maximum allowed. Verify that your environment doesn\'t exceed the following service quotas:</p> <p>Applications: 100 max</p> <p>Deployment strategies: 20 max</p> <p>Configuration profiles: 100 max per application</p> <p>Environments: 20 max per application</p> <p>To resolve this issue, you can delete one or more resources and try again. Or, you can request a quota increase. For more information about quotas and to request an increase, see <a href="https://docs.aws.amazon.com/general/latest/gr/appconfig.html#limits_appconfig">Service quotas for AppConfig</a> in the Amazon Web Services General Reference.</p>', 'refs' => [], ], 'StartDeploymentRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopDeploymentRequest' => [ 'base' => NULL, 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'ActionInvocation$ErrorMessage' => '<p>The error message when an extension invocation fails.</p>', 'ActionInvocation$ErrorCode' => '<p>The error code when an extension invocation fails.</p>', 'BadRequestException$Message' => NULL, 'Configuration$ContentType' => '<p>A standard MIME type describing the format of the configuration content. For more information, see <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17">Content-Type</a>.</p>', 'ConflictException$Message' => NULL, 'InternalServerException$Message' => NULL, 'InvalidConfigurationDetail$Constraint' => '<p>The invalid or out-of-range validation constraint in your JSON schema that failed validation.</p>', 'InvalidConfigurationDetail$Location' => '<p>Location of the validation constraint in the configuration JSON schema that failed validation.</p>', 'InvalidConfigurationDetail$Reason' => '<p>The reason for an invalid configuration error.</p>', 'InvalidConfigurationDetail$Type' => '<p>The type of error for an invalid configuration.</p>', 'InvalidConfigurationDetail$Value' => '<p>Details about an error with Lambda when a synchronous extension experiences an error during an invocation.</p>', 'PayloadTooLargeException$Message' => NULL, 'ResourceNotFoundException$Message' => NULL, 'ResourceNotFoundException$ResourceName' => NULL, 'ServiceQuotaExceededException$Message' => NULL, ], ], 'StringWithLengthBetween0And32768' => [ 'base' => NULL, 'refs' => [ 'Validator$Content' => '<p>Either the JSON Schema content or the Amazon Resource Name (ARN) of an Lambda function.</p>', ], ], 'StringWithLengthBetween1And2048' => [ 'base' => NULL, 'refs' => [ 'DynamicParameterMap$value' => NULL, 'Monitor$AlarmArn' => '<p>Amazon Resource Name (ARN) of the Amazon CloudWatch alarm.</p>', 'ParameterValueMap$value' => NULL, ], ], 'StringWithLengthBetween1And255' => [ 'base' => NULL, 'refs' => [ 'CreateHostedConfigurationVersionRequest$ContentType' => '<p>A standard MIME type describing the format of the configuration content. For more information, see <a href="https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17">Content-Type</a>.</p>', 'HostedConfigurationVersion$ContentType' => '<p>A standard MIME type describing the format of the configuration content. For more information, see <a href="https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17">Content-Type</a>.</p>', 'HostedConfigurationVersionSummary$ContentType' => '<p>A standard MIME type describing the format of the configuration content. For more information, see <a href="https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17">Content-Type</a>.</p>', ], ], 'StringWithLengthBetween1And64' => [ 'base' => NULL, 'refs' => [ 'GetConfigurationRequest$Application' => '<p>The application to get. Specify either the application name or the application ID.</p>', 'GetConfigurationRequest$Environment' => '<p>The environment to get. Specify either the environment name or the environment ID.</p>', 'GetConfigurationRequest$Configuration' => '<p>The configuration to get. Specify either the configuration name or the configuration ID.</p>', 'GetConfigurationRequest$ClientId' => '<p>The clientId parameter in the following command is a unique, user-specified ID to identify the client for the configuration. This ID enables AppConfig to deploy the configuration in intervals, as defined in the deployment strategy. </p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'TagMap$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>The tag keys to delete.</p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'CreateApplicationRequest$Tags' => '<p>Metadata to assign to the application. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define.</p>', 'CreateConfigurationProfileRequest$Tags' => '<p>Metadata to assign to the configuration profile. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define.</p>', 'CreateDeploymentStrategyRequest$Tags' => '<p>Metadata to assign to the deployment strategy. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define.</p>', 'CreateEnvironmentRequest$Tags' => '<p>Metadata to assign to the environment. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define.</p>', 'CreateExtensionAssociationRequest$Tags' => '<p>Adds one or more tags for the specified extension association. Tags are metadata that help you categorize resources in different ways, for example, by purpose, owner, or environment. Each tag consists of a key and an optional value, both of which you define. </p>', 'CreateExtensionRequest$Tags' => '<p>Adds one or more tags for the specified extension. Tags are metadata that help you categorize resources in different ways, for example, by purpose, owner, or environment. Each tag consists of a key and an optional value, both of which you define. </p>', 'ResourceTags$Tags' => '<p>Metadata to assign to AppConfig resources. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define.</p>', 'StartDeploymentRequest$Tags' => '<p>Metadata to assign to the deployment. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define.</p>', 'TagResourceRequest$Tags' => '<p>The key-value string map. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagMap$value' => NULL, ], ], 'TriggeredBy' => [ 'base' => NULL, 'refs' => [ 'DeploymentEvent$TriggeredBy' => '<p>The entity that triggered the deployment event. Events can be triggered by a user, AppConfig, an Amazon CloudWatch alarm, or an internal error.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateApplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateConfigurationProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDeploymentStrategyRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEnvironmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateExtensionAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateExtensionRequest' => [ 'base' => NULL, 'refs' => [], ], 'Uri' => [ 'base' => NULL, 'refs' => [ 'Action$Uri' => '<p>The extension URI associated to the action point in the extension definition. The URI can be an Amazon Resource Name (ARN) for one of the following: an Lambda function, an Amazon Simple Queue Service queue, an Amazon Simple Notification Service topic, or the Amazon EventBridge default event bus.</p>', 'ActionInvocation$Uri' => '<p>The extension URI associated to the action point in the extension definition. The URI can be an Amazon Resource Name (ARN) for one of the following: an Lambda function, an Amazon Simple Queue Service queue, an Amazon Simple Notification Service topic, or the Amazon EventBridge default event bus.</p>', 'ConfigurationProfile$LocationUri' => '<p>The URI location of the configuration.</p>', 'ConfigurationProfileSummary$LocationUri' => '<p>The URI location of the configuration.</p>', 'CreateConfigurationProfileRequest$LocationUri' => '<p>A URI to locate the configuration. You can specify the following:</p> <ul> <li> <p>For the AppConfig hosted configuration store and for feature flags, specify <code>hosted</code>.</p> </li> <li> <p>For an Amazon Web Services Systems Manager Parameter Store parameter, specify either the parameter name in the format <code>ssm-parameter://&lt;parameter name&gt;</code> or the ARN.</p> </li> <li> <p>For an Amazon Web Services CodePipeline pipeline, specify the URI in the following format: <code>codepipeline</code>://&lt;pipeline name&gt;.</p> </li> <li> <p>For an Secrets Manager secret, specify the URI in the following format: <code>secretsmanager</code>://&lt;secret name&gt;.</p> </li> <li> <p>For an Amazon S3 object, specify the URI in the following format: <code>s3://&lt;bucket&gt;/&lt;objectKey&gt; </code>. Here is an example: <code>s3://my-bucket/my-app/us-east-1/my-config.json</code> </p> </li> <li> <p>For an SSM document, specify either the document name in the format <code>ssm-document://&lt;document name&gt;</code> or the Amazon Resource Name (ARN).</p> </li> </ul>', 'Deployment$ConfigurationLocationUri' => '<p>Information about the source location of the configuration.</p>', ], ], 'ValidateConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'Validator' => [ 'base' => '<p>A validator provides a syntactic or semantic check to ensure the configuration that you want to deploy functions as intended. To validate your application configuration data, you provide a schema or an Amazon Web Services Lambda function that runs against the configuration. The configuration deployment or update can only proceed when the configuration data is valid.</p>', 'refs' => [ 'ValidatorList$member' => NULL, ], ], 'ValidatorList' => [ 'base' => NULL, 'refs' => [ 'ConfigurationProfile$Validators' => '<p>A list of methods for validating the configuration.</p>', 'CreateConfigurationProfileRequest$Validators' => '<p>A list of methods for validating the configuration.</p>', 'UpdateConfigurationProfileRequest$Validators' => '<p>A list of methods for validating the configuration.</p>', ], ], 'ValidatorType' => [ 'base' => NULL, 'refs' => [ 'Validator$Type' => '<p>AppConfig supports validators of type <code>JSON_SCHEMA</code> and <code>LAMBDA</code> </p>', 'ValidatorTypeList$member' => NULL, ], ], 'ValidatorTypeList' => [ 'base' => NULL, 'refs' => [ 'ConfigurationProfileSummary$ValidatorTypes' => '<p>The types of validators in the configuration profile.</p>', ], ], 'Version' => [ 'base' => NULL, 'refs' => [ 'Configuration$ConfigurationVersion' => '<p>The configuration version.</p>', 'Deployment$ConfigurationVersion' => '<p>The configuration version that was deployed.</p>', 'DeploymentSummary$ConfigurationVersion' => '<p>The version of the configuration.</p>', 'GetConfigurationRequest$ClientConfigurationVersion' => '<p>The configuration version returned in the most recent <code>GetConfiguration</code> response.</p> <important> <p>AppConfig uses the value of the <code>ClientConfigurationVersion</code> parameter to identify the configuration version on your clients. If you don’t send <code>ClientConfigurationVersion</code> with each call to <code>GetConfiguration</code>, your clients receive the current configuration. You are charged each time your clients receive a configuration.</p> <p>To avoid excess charges, we recommend you use the <a href="https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/StartConfigurationSession.html">StartConfigurationSession</a> and <a href="https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/GetLatestConfiguration.html">GetLatestConfiguration</a> APIs, which track the client configuration version on your behalf. If you choose to continue using <code>GetConfiguration</code>, we recommend that you include the <code>ClientConfigurationVersion</code> value with every call to <code>GetConfiguration</code>. The value to use for <code>ClientConfigurationVersion</code> comes from the <code>ConfigurationVersion</code> attribute returned by <code>GetConfiguration</code> when there is new or updated data, and should be saved for subsequent calls to <code>GetConfiguration</code>.</p> </important> <p>For more information about working with configurations, see <a href="http://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-retrieving-the-configuration.html">Retrieving the Configuration</a> in the <i>AppConfig User Guide</i>.</p>', 'StartDeploymentRequest$ConfigurationVersion' => '<p>The configuration version to deploy. If deploying an AppConfig hosted configuration version, you can specify either the version number or version label. For all other configurations, you must specify the version number.</p>', 'ValidateConfigurationRequest$ConfigurationVersion' => '<p>The version of the configuration to validate.</p>', ], ], 'VersionLabel' => [ 'base' => NULL, 'refs' => [ 'CreateHostedConfigurationVersionRequest$VersionLabel' => '<p>An optional, user-defined label for the AppConfig hosted configuration version. This value must contain at least one non-numeric character. For example, "v2.2.0".</p>', 'Deployment$VersionLabel' => '<p>A user-defined label for an AppConfig hosted configuration version.</p>', 'DeploymentSummary$VersionLabel' => '<p>A user-defined label for an AppConfig hosted configuration version.</p>', 'HostedConfigurationVersion$VersionLabel' => '<p>A user-defined label for an AppConfig hosted configuration version.</p>', 'HostedConfigurationVersionSummary$VersionLabel' => '<p>A user-defined label for an AppConfig hosted configuration version.</p>', ], ], ],];
