<?php
// This file was auto-generated from sdk-root/src/data/appfabric/2023-05-19/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Amazon Web Services AppFabric quickly connects software as a service (SaaS) applications across your organization. This allows IT and security teams to easily manage and secure applications using a standard schema, and employees can complete everyday tasks faster using generative artificial intelligence (AI). You can use these APIs to complete AppFabric tasks, such as setting up audit log ingestions or viewing user access. For more information about AppFabric, including the required permissions to use the service, see the <a href="https://docs.aws.amazon.com/appfabric/latest/adminguide/">Amazon Web Services AppFabric Administration Guide</a>. For more information about using the Command Line Interface (CLI) to manage your AppFabric resources, see the <a href="https://docs.aws.amazon.com/cli/latest/reference/appfabric/index.html">AppFabric section of the CLI Reference</a>.</p>', 'operations' => [ 'BatchGetUserAccessTasks' => '<p>Gets user access details in a batch request.</p> <p>This action polls data from the tasks that are kicked off by the <code>StartUserAccessTasks</code> action.</p>', 'ConnectAppAuthorization' => '<p>Establishes a connection between Amazon Web Services AppFabric and an application, which allows AppFabric to call the APIs of the application.</p>', 'CreateAppAuthorization' => '<p>Creates an app authorization within an app bundle, which allows AppFabric to connect to an application.</p>', 'CreateAppBundle' => '<p>Creates an app bundle to collect data from an application using AppFabric.</p>', 'CreateIngestion' => '<p>Creates a data ingestion for an application.</p>', 'CreateIngestionDestination' => '<p>Creates an ingestion destination, which specifies how an application\'s ingested data is processed by Amazon Web Services AppFabric and where it\'s delivered.</p>', 'DeleteAppAuthorization' => '<p>Deletes an app authorization. You must delete the associated ingestion before you can delete an app authorization.</p>', 'DeleteAppBundle' => '<p>Deletes an app bundle. You must delete all associated app authorizations before you can delete an app bundle.</p>', 'DeleteIngestion' => '<p>Deletes an ingestion. You must stop (disable) the ingestion and you must delete all associated ingestion destinations before you can delete an app ingestion.</p>', 'DeleteIngestionDestination' => '<p>Deletes an ingestion destination.</p> <p>This deletes the association between an ingestion and it\'s destination. It doesn\'t delete previously ingested data or the storage destination, such as the Amazon S3 bucket where the data is delivered. If the ingestion destination is deleted while the associated ingestion is enabled, the ingestion will fail and is eventually disabled.</p>', 'GetAppAuthorization' => '<p>Returns information about an app authorization.</p>', 'GetAppBundle' => '<p>Returns information about an app bundle.</p>', 'GetIngestion' => '<p>Returns information about an ingestion.</p>', 'GetIngestionDestination' => '<p>Returns information about an ingestion destination.</p>', 'ListAppAuthorizations' => '<p>Returns a list of all app authorizations configured for an app bundle.</p>', 'ListAppBundles' => '<p>Returns a list of app bundles.</p>', 'ListIngestionDestinations' => '<p>Returns a list of all ingestion destinations configured for an ingestion.</p>', 'ListIngestions' => '<p>Returns a list of all ingestions configured for an app bundle.</p>', 'ListTagsForResource' => '<p>Returns a list of tags for a resource.</p>', 'StartIngestion' => '<p>Starts (enables) an ingestion, which collects data from an application.</p>', 'StartUserAccessTasks' => '<p>Starts the tasks to search user access status for a specific email address.</p> <p>The tasks are stopped when the user access status data is found. The tasks are terminated when the API calls to the application time out.</p>', 'StopIngestion' => '<p>Stops (disables) an ingestion.</p>', 'TagResource' => '<p>Assigns one or more tags (key-value pairs) to the specified resource.</p>', 'UntagResource' => '<p>Removes a tag or tags from a resource.</p>', 'UpdateAppAuthorization' => '<p>Updates an app authorization within an app bundle, which allows AppFabric to connect to an application.</p> <p>If the app authorization was in a <code>connected</code> state, updating the app authorization will set it back to a <code>PendingConnect</code> state.</p>', 'UpdateIngestionDestination' => '<p>Updates an ingestion destination, which specifies how an application\'s ingested data is processed by Amazon Web Services AppFabric and where it\'s delivered.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You are not authorized to perform this operation.</p>', 'refs' => [], ], 'ApiKeyCredential' => [ 'base' => '<p>Contains API key credential information.</p>', 'refs' => [ 'Credential$apiKeyCredential' => '<p>Contains API key credential information.</p>', ], ], 'AppAuthorization' => [ 'base' => '<p>Contains information about an app authorization.</p>', 'refs' => [ 'CreateAppAuthorizationResponse$appAuthorization' => '<p>Contains information about an app authorization.</p>', 'GetAppAuthorizationResponse$appAuthorization' => '<p>Contains information about an app authorization.</p>', 'UpdateAppAuthorizationResponse$appAuthorization' => '<p>Contains information about an app authorization.</p>', ], ], 'AppAuthorizationStatus' => [ 'base' => NULL, 'refs' => [ 'AppAuthorization$status' => '<p>The state of the app authorization.</p> <p>The following states are possible:</p> <ul> <li> <p> <code>PendingConnect</code>: The initial state of the app authorization. The app authorization is created but not yet connected.</p> </li> <li> <p> <code>Connected</code>: The app authorization is connected to the application, and is ready to be used.</p> </li> <li> <p> <code>ConnectionValidationFailed</code>: The app authorization received a validation exception when trying to connect to the application. If the app authorization is in this state, you should verify the configured credentials and try to connect the app authorization again.</p> </li> <li> <p> <code>TokenAutoRotationFailed</code>: AppFabric failed to refresh the access token. If the app authorization is in this state, you should try to reconnect the app authorization.</p> </li> </ul>', 'AppAuthorizationSummary$status' => '<p>The state of the app authorization.</p> <p>The following states are possible:</p> <ul> <li> <p> <code>PendingConnect</code>: The initial state of the app authorization. The app authorization is created but not yet connected.</p> </li> <li> <p> <code>Connected</code>: The app authorization is connected to the application, and is ready to be used.</p> </li> <li> <p> <code>ConnectionValidationFailed</code>: The app authorization received a validation exception when trying to connect to the application. If the app authorization is in this state, you should verify the configured credentials and try to connect the app authorization again.</p> </li> <li> <p> <code>TokenAutoRotationFailed</code>: AppFabric failed to refresh the access token. If the app authorization is in this state, you should try to reconnect the app authorization.</p> </li> </ul>', ], ], 'AppAuthorizationSummary' => [ 'base' => '<p>Contains a summary of an app authorization.</p>', 'refs' => [ 'AppAuthorizationSummaryList$member' => NULL, 'ConnectAppAuthorizationResponse$appAuthorizationSummary' => '<p>Contains a summary of the app authorization.</p>', ], ], 'AppAuthorizationSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListAppAuthorizationsResponse$appAuthorizationSummaryList' => '<p>Contains a list of app authorization summaries.</p>', ], ], 'AppBundle' => [ 'base' => '<p>Contains information about an app bundle.</p>', 'refs' => [ 'CreateAppBundleResponse$appBundle' => '<p>Contains information about an app bundle.</p>', 'GetAppBundleResponse$appBundle' => '<p>Contains information about an app bundle.</p>', ], ], 'AppBundleSummary' => [ 'base' => '<p>Contains a summary of an app bundle.</p>', 'refs' => [ 'AppBundleSummaryList$member' => NULL, ], ], 'AppBundleSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListAppBundlesResponse$appBundleSummaryList' => '<p>Contains a list of app bundle summaries.</p>', ], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'AppAuthorization$appAuthorizationArn' => '<p>The Amazon Resource Name (ARN) of the app authorization.</p>', 'AppAuthorization$appBundleArn' => '<p>The Amazon Resource Name (ARN) of the app bundle for the app authorization.</p>', 'AppAuthorizationSummary$appAuthorizationArn' => '<p>The Amazon Resource Name (ARN) of the app authorization.</p>', 'AppAuthorizationSummary$appBundleArn' => '<p>The Amazon Resource Name (ARN) of the app bundle for the app authorization.</p>', 'AppBundle$arn' => '<p>The Amazon Resource Name (ARN) of the app bundle.</p>', 'AppBundle$customerManagedKeyArn' => '<p>The Amazon Resource Name (ARN) of the Key Management Service (KMS) key used to encrypt the application data.</p>', 'AppBundleSummary$arn' => '<p>The Amazon Resource Name (ARN) of the app bundle.</p>', 'Ingestion$arn' => '<p>The Amazon Resource Name (ARN) of the ingestion.</p>', 'Ingestion$appBundleArn' => '<p>The Amazon Resource Name (ARN) of the app bundle for the ingestion.</p>', 'IngestionDestination$arn' => '<p>The Amazon Resource Name (ARN) of the ingestion destination.</p>', 'IngestionDestination$ingestionArn' => '<p>The Amazon Resource Name (ARN) of the ingestion.</p>', 'IngestionDestinationSummary$arn' => '<p>The Amazon Resource Name (ARN) of the ingestion destination.</p>', 'IngestionSummary$arn' => '<p>The Amazon Resource Name (ARN) of the ingestion.</p>', 'ListTagsForResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource for which you want to retrieve tags.</p>', 'TagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource that you want to tag.</p>', 'UntagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource that you want to untag.</p>', ], ], 'AuditLogDestinationConfiguration' => [ 'base' => '<p>Contains information about an audit log destination configuration.</p>', 'refs' => [ 'DestinationConfiguration$auditLog' => '<p>Contains information about an audit log destination configuration.</p>', ], ], 'AuditLogProcessingConfiguration' => [ 'base' => '<p>Contains information about an audit log processing configuration.</p>', 'refs' => [ 'ProcessingConfiguration$auditLog' => '<p>Contains information about an audit log processing configuration.</p>', ], ], 'AuthRequest' => [ 'base' => '<p>Contains authorization request information, which is required for Amazon Web Services AppFabric to get the OAuth2 access token for an application.</p>', 'refs' => [ 'ConnectAppAuthorizationRequest$authRequest' => '<p>Contains OAuth2 authorization information.</p> <p>This is required if the app authorization for the request is configured with an OAuth2 (<code>oauth2</code>) authorization type.</p>', ], ], 'AuthType' => [ 'base' => NULL, 'refs' => [ 'AppAuthorization$authType' => '<p>The authorization type.</p>', 'CreateAppAuthorizationRequest$authType' => '<p>The authorization type for the app authorization.</p>', ], ], 'BatchGetUserAccessTasksRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetUserAccessTasksResponse' => [ 'base' => NULL, 'refs' => [], ], 'ConflictException' => [ 'base' => '<p>The request has created a conflict. Check the request parameters and try again.</p>', 'refs' => [], ], 'ConnectAppAuthorizationRequest' => [ 'base' => NULL, 'refs' => [], ], 'ConnectAppAuthorizationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateAppAuthorizationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAppAuthorizationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateAppBundleRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAppBundleResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateIngestionDestinationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateIngestionDestinationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateIngestionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateIngestionResponse' => [ 'base' => NULL, 'refs' => [], ], 'Credential' => [ 'base' => '<p>Contains credential information for an application.</p>', 'refs' => [ 'CreateAppAuthorizationRequest$credential' => '<p>Contains credentials for the application, such as an API key or OAuth2 client ID and secret.</p> <p>Specify credentials that match the authorization type for your request. For example, if the authorization type for your request is OAuth2 (<code>oauth2</code>), then you should provide only the OAuth2 credentials.</p>', 'UpdateAppAuthorizationRequest$credential' => '<p>Contains credentials for the application, such as an API key or OAuth2 client ID and secret.</p> <p>Specify credentials that match the authorization type of the app authorization to update. For example, if the authorization type of the app authorization is OAuth2 (<code>oauth2</code>), then you should provide only the OAuth2 credentials.</p>', ], ], 'DateTime' => [ 'base' => NULL, 'refs' => [ 'AppAuthorization$createdAt' => '<p>The timestamp of when the app authorization was created.</p>', 'AppAuthorization$updatedAt' => '<p>The timestamp of when the app authorization was last updated.</p>', 'AppAuthorizationSummary$updatedAt' => '<p>Timestamp for when the app authorization was last updated.</p>', 'Ingestion$createdAt' => '<p>The timestamp of when the ingestion was created.</p>', 'Ingestion$updatedAt' => '<p>The timestamp of when the ingestion was last updated.</p>', 'IngestionDestination$createdAt' => '<p>The timestamp of when the ingestion destination was created.</p>', 'IngestionDestination$updatedAt' => '<p>The timestamp of when the ingestion destination was last updated.</p>', ], ], 'DeleteAppAuthorizationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAppAuthorizationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAppBundleRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAppBundleResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteIngestionDestinationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteIngestionDestinationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteIngestionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteIngestionResponse' => [ 'base' => NULL, 'refs' => [], ], 'Destination' => [ 'base' => '<p>Contains information about an audit log destination.</p>', 'refs' => [ 'AuditLogDestinationConfiguration$destination' => '<p>Contains information about an audit log destination.</p>', ], ], 'DestinationConfiguration' => [ 'base' => '<p>Contains information about the destination of ingested data.</p>', 'refs' => [ 'CreateIngestionDestinationRequest$destinationConfiguration' => '<p>Contains information about the destination of ingested data.</p>', 'IngestionDestination$destinationConfiguration' => '<p>Contains information about the destination of ingested data.</p>', 'UpdateIngestionDestinationRequest$destinationConfiguration' => '<p>Contains information about the destination of ingested data.</p>', ], ], 'Email' => [ 'base' => NULL, 'refs' => [ 'StartUserAccessTasksRequest$email' => '<p>The email address of the target user.</p>', 'UserAccessResultItem$email' => '<p>The email address of the target user.</p>', ], ], 'FirehoseStream' => [ 'base' => '<p>Contains information about an Amazon Kinesis Data Firehose delivery stream.</p>', 'refs' => [ 'Destination$firehoseStream' => '<p>Contains information about an Amazon Kinesis Data Firehose delivery stream.</p>', ], ], 'Format' => [ 'base' => NULL, 'refs' => [ 'AuditLogProcessingConfiguration$format' => '<p>The format in which the audit logs need to be formatted.</p>', ], ], 'GetAppAuthorizationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAppAuthorizationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetAppBundleRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAppBundleResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetIngestionDestinationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetIngestionDestinationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetIngestionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetIngestionResponse' => [ 'base' => NULL, 'refs' => [], ], 'Identifier' => [ 'base' => NULL, 'refs' => [ 'BatchGetUserAccessTasksRequest$appBundleIdentifier' => '<p>The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle to use for the request.</p>', 'ConnectAppAuthorizationRequest$appBundleIdentifier' => '<p>The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle that contains the app authorization to use for the request.</p>', 'ConnectAppAuthorizationRequest$appAuthorizationIdentifier' => '<p>The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app authorization to use for the request.</p>', 'CreateAppAuthorizationRequest$appBundleIdentifier' => '<p>The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle to use for the request.</p>', 'CreateAppBundleRequest$customerManagedKeyIdentifier' => '<p>The Amazon Resource Name (ARN) of the Key Management Service (KMS) key to use to encrypt the application data. If this is not specified, an Amazon Web Services owned key is used for encryption.</p>', 'CreateIngestionDestinationRequest$appBundleIdentifier' => '<p>The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle to use for the request.</p>', 'CreateIngestionDestinationRequest$ingestionIdentifier' => '<p>The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the ingestion to use for the request.</p>', 'CreateIngestionRequest$appBundleIdentifier' => '<p>The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle to use for the request.</p>', 'DeleteAppAuthorizationRequest$appBundleIdentifier' => '<p>The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle to use for the request.</p>', 'DeleteAppAuthorizationRequest$appAuthorizationIdentifier' => '<p>The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app authorization to use for the request.</p>', 'DeleteAppBundleRequest$appBundleIdentifier' => '<p>The ID or Amazon Resource Name (ARN) of the app bundle that needs to be deleted.</p>', 'DeleteIngestionDestinationRequest$appBundleIdentifier' => '<p>The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle to use for the request.</p>', 'DeleteIngestionDestinationRequest$ingestionIdentifier' => '<p>The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the ingestion to use for the request.</p>', 'DeleteIngestionDestinationRequest$ingestionDestinationIdentifier' => '<p>The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the ingestion destination to use for the request.</p>', 'DeleteIngestionRequest$appBundleIdentifier' => '<p>The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle to use for the request.</p>', 'DeleteIngestionRequest$ingestionIdentifier' => '<p>The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the ingestion to use for the request.</p>', 'GetAppAuthorizationRequest$appBundleIdentifier' => '<p>The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle to use for the request.</p>', 'GetAppAuthorizationRequest$appAuthorizationIdentifier' => '<p>The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app authorization to use for the request.</p>', 'GetAppBundleRequest$appBundleIdentifier' => '<p>The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle to use for the request.</p>', 'GetIngestionDestinationRequest$appBundleIdentifier' => '<p>The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle to use for the request.</p>', 'GetIngestionDestinationRequest$ingestionIdentifier' => '<p>The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the ingestion to use for the request.</p>', 'GetIngestionDestinationRequest$ingestionDestinationIdentifier' => '<p>The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the ingestion destination to use for the request.</p>', 'GetIngestionRequest$appBundleIdentifier' => '<p>The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle to use for the request.</p>', 'GetIngestionRequest$ingestionIdentifier' => '<p>The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the ingestion to use for the request.</p>', 'ListAppAuthorizationsRequest$appBundleIdentifier' => '<p>The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle to use for the request.</p>', 'ListIngestionDestinationsRequest$appBundleIdentifier' => '<p>The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle to use for the request.</p>', 'ListIngestionDestinationsRequest$ingestionIdentifier' => '<p>The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the ingestion to use for the request.</p>', 'ListIngestionsRequest$appBundleIdentifier' => '<p>The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle to use for the request.</p>', 'StartIngestionRequest$ingestionIdentifier' => '<p>The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the ingestion to use for the request.</p>', 'StartIngestionRequest$appBundleIdentifier' => '<p>The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle to use for the request.</p>', 'StartUserAccessTasksRequest$appBundleIdentifier' => '<p>The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle to use for the request.</p>', 'StopIngestionRequest$ingestionIdentifier' => '<p>The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the ingestion to use for the request.</p>', 'StopIngestionRequest$appBundleIdentifier' => '<p>The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle to use for the request.</p>', 'UpdateAppAuthorizationRequest$appBundleIdentifier' => '<p>The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle to use for the request.</p>', 'UpdateAppAuthorizationRequest$appAuthorizationIdentifier' => '<p>The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app authorization to use for the request.</p>', 'UpdateIngestionDestinationRequest$appBundleIdentifier' => '<p>The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle to use for the request.</p>', 'UpdateIngestionDestinationRequest$ingestionIdentifier' => '<p>The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the ingestion to use for the request.</p>', 'UpdateIngestionDestinationRequest$ingestionDestinationIdentifier' => '<p>The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the ingestion destination to use for the request.</p>', ], ], 'Ingestion' => [ 'base' => '<p>Contains information about an ingestion.</p>', 'refs' => [ 'CreateIngestionResponse$ingestion' => '<p>Contains information about an ingestion.</p>', 'GetIngestionResponse$ingestion' => '<p>Contains information about an ingestion.</p>', ], ], 'IngestionDestination' => [ 'base' => '<p>Contains information about an ingestion destination.</p>', 'refs' => [ 'CreateIngestionDestinationResponse$ingestionDestination' => '<p>Contains information about an ingestion destination.</p>', 'GetIngestionDestinationResponse$ingestionDestination' => '<p>Contains information about an ingestion destination.</p>', 'UpdateIngestionDestinationResponse$ingestionDestination' => '<p>Contains information about an ingestion destination.</p>', ], ], 'IngestionDestinationList' => [ 'base' => NULL, 'refs' => [ 'ListIngestionDestinationsResponse$ingestionDestinations' => '<p>Contains a list of ingestion destination summaries.</p>', ], ], 'IngestionDestinationStatus' => [ 'base' => NULL, 'refs' => [ 'IngestionDestination$status' => '<p>The state of the ingestion destination.</p> <p>The following states are possible:</p> <ul> <li> <p> <code>Active</code>: The ingestion destination is active and is ready to be used.</p> </li> <li> <p> <code>Failed</code>: The ingestion destination has failed. If the ingestion destination is in this state, you should verify the ingestion destination configuration and try again.</p> </li> </ul>', ], ], 'IngestionDestinationSummary' => [ 'base' => '<p>Contains a summary of an ingestion destination.</p>', 'refs' => [ 'IngestionDestinationList$member' => NULL, ], ], 'IngestionList' => [ 'base' => NULL, 'refs' => [ 'ListIngestionsResponse$ingestions' => '<p>Contains a list of ingestion summaries.</p>', ], ], 'IngestionState' => [ 'base' => NULL, 'refs' => [ 'Ingestion$state' => '<p>The status of the ingestion.</p>', 'IngestionSummary$state' => '<p>The status of the ingestion.</p>', ], ], 'IngestionSummary' => [ 'base' => '<p>Contains a summary of an ingestion.</p>', 'refs' => [ 'IngestionList$member' => NULL, ], ], 'IngestionType' => [ 'base' => NULL, 'refs' => [ 'CreateIngestionRequest$ingestionType' => '<p>The ingestion type.</p>', 'Ingestion$ingestionType' => '<p>The type of the ingestion.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'InternalServerException$retryAfterSeconds' => '<p>The period of time after which you should retry your request.</p>', 'ThrottlingException$retryAfterSeconds' => '<p>The period of time after which you should retry your request.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>The request processing has failed because of an unknown error, exception, or failure with an internal server.</p>', 'refs' => [], ], 'ListAppAuthorizationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAppAuthorizationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAppBundlesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAppBundlesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListIngestionDestinationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListIngestionDestinationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListIngestionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListIngestionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListAppAuthorizationsRequest$maxResults' => '<p>The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain further pages of results.</p> <p>This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum.</p>', 'ListAppBundlesRequest$maxResults' => '<p>The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain further pages of results.</p> <p>This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum.</p>', 'ListIngestionDestinationsRequest$maxResults' => '<p>The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain further pages of results.</p> <p>This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum.</p>', 'ListIngestionsRequest$maxResults' => '<p>The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain further pages of results.</p> <p>This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum.</p>', ], ], 'Oauth2Credential' => [ 'base' => '<p>Contains OAuth2 client credential information.</p>', 'refs' => [ 'Credential$oauth2Credential' => '<p>Contains OAuth2 client credential information.</p>', ], ], 'Persona' => [ 'base' => NULL, 'refs' => [ 'AppAuthorization$persona' => '<p>The user persona of the app authorization.</p> <p>This field should always be <code>admin</code>.</p>', ], ], 'ProcessingConfiguration' => [ 'base' => '<p>Contains information about how ingested data is processed.</p>', 'refs' => [ 'CreateIngestionDestinationRequest$processingConfiguration' => '<p>Contains information about how ingested data is processed.</p>', 'IngestionDestination$processingConfiguration' => '<p>Contains information about how ingested data is processed.</p>', ], ], 'RedirectUri' => [ 'base' => NULL, 'refs' => [ 'AuthRequest$redirectUri' => '<p>The redirect URL that is specified in the AuthURL and the application client.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The specified resource does not exist.</p>', 'refs' => [], ], 'ResultStatus' => [ 'base' => NULL, 'refs' => [ 'UserAccessResultItem$resultStatus' => '<p>The status of the user access result item.</p> <p>The following states are possible:</p> <ul> <li> <p> <code>IN_PROGRESS</code>: The user access task is in progress.</p> </li> <li> <p> <code>COMPLETED</code>: The user access task completed successfully.</p> </li> <li> <p> <code>FAILED</code>: The user access task failed.</p> </li> <li> <p> <code>EXPIRED</code>: The user access task expired.</p> </li> </ul>', ], ], 'S3Bucket' => [ 'base' => '<p>Contains information about an Amazon S3 bucket.</p>', 'refs' => [ 'Destination$s3Bucket' => '<p>Contains information about an Amazon S3 bucket.</p>', ], ], 'Schema' => [ 'base' => NULL, 'refs' => [ 'AuditLogProcessingConfiguration$schema' => '<p>The event schema in which the audit logs need to be formatted.</p>', ], ], 'SensitiveString2048' => [ 'base' => NULL, 'refs' => [ 'ApiKeyCredential$apiKey' => '<p>An API key for an application.</p>', 'AuthRequest$code' => '<p>The authorization code returned by the application after permission is granted in the application OAuth page (after clicking on the AuthURL).</p>', 'Oauth2Credential$clientSecret' => '<p>The client secret of the client application.</p>', 'UserAccessResultItem$userId' => '<p>The unique ID of user.</p>', 'UserAccessResultItem$userFullName' => '<p>The full name of the user.</p>', 'UserAccessResultItem$userFirstName' => '<p>The first name of the user.</p>', 'UserAccessResultItem$userLastName' => '<p>The last name of the user.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>The request exceeds a service quota.</p>', 'refs' => [], ], 'StartIngestionRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartIngestionResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartUserAccessTasksRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartUserAccessTasksResponse' => [ 'base' => NULL, 'refs' => [], ], 'StopIngestionRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopIngestionResponse' => [ 'base' => NULL, 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'AppAuthorization$authUrl' => '<p>The application URL for the OAuth flow.</p>', 'ConflictException$message' => NULL, 'ConflictException$resourceId' => '<p>The resource ID.</p>', 'ConflictException$resourceType' => '<p>The resource type.</p>', 'IngestionDestination$statusReason' => '<p>The reason for the current status of the ingestion destination.</p> <p>Only present when the <code>status</code> of ingestion destination is <code>Failed</code>.</p>', 'InternalServerException$message' => NULL, 'ListIngestionDestinationsRequest$nextToken' => '<p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken error</i>.</p>', 'ListIngestionDestinationsResponse$nextToken' => '<p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken error</i>.</p>', 'ListIngestionsRequest$nextToken' => '<p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken error</i>.</p>', 'ListIngestionsResponse$nextToken' => '<p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken error</i>.</p>', 'ResourceNotFoundException$message' => NULL, 'ResourceNotFoundException$resourceId' => '<p>The resource ID.</p>', 'ResourceNotFoundException$resourceType' => '<p>The resource type.</p>', 'ServiceQuotaExceededException$message' => NULL, 'ServiceQuotaExceededException$resourceId' => '<p>The resource ID.</p>', 'ServiceQuotaExceededException$resourceType' => '<p>The resource type.</p>', 'ServiceQuotaExceededException$serviceCode' => '<p>The code of the service.</p>', 'ServiceQuotaExceededException$quotaCode' => '<p>The code for the quota exceeded.</p>', 'TaskError$errorCode' => '<p>The code of the error.</p>', 'TaskError$errorMessage' => '<p>The message of the error.</p>', 'ThrottlingException$message' => NULL, 'ThrottlingException$serviceCode' => '<p>The code of the service.</p>', 'ThrottlingException$quotaCode' => '<p>The code for the quota exceeded.</p>', 'UserAccessResultItem$userStatus' => '<p>The status of the user returned by the application.</p>', 'ValidationException$message' => NULL, 'ValidationExceptionField$name' => '<p>The field name where the invalid entry was detected.</p>', 'ValidationExceptionField$message' => '<p>A message about the validation exception.</p>', ], ], 'String120' => [ 'base' => NULL, 'refs' => [ 'S3Bucket$prefix' => '<p>The object key to use.</p>', ], ], 'String2048' => [ 'base' => NULL, 'refs' => [ 'ListAppAuthorizationsRequest$nextToken' => '<p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken error</i>.</p>', 'ListAppAuthorizationsResponse$nextToken' => '<p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken error</i>.</p>', 'ListAppBundlesRequest$nextToken' => '<p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken error</i>.</p>', 'ListAppBundlesResponse$nextToken' => '<p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken error</i>.</p>', 'Oauth2Credential$clientId' => '<p>The client ID of the client application.</p>', 'Tenant$tenantDisplayName' => '<p>The display name of the tenant.</p>', 'UserAccessResultItem$tenantDisplayName' => '<p>The display name of the tenant.</p>', ], ], 'String255' => [ 'base' => NULL, 'refs' => [ 'AppAuthorization$app' => '<p>The name of the application.</p>', 'AppAuthorizationSummary$app' => '<p>The name of the application.</p>', 'CreateAppAuthorizationRequest$app' => '<p>The name of the application.</p> <p>Valid values are:</p> <ul> <li> <p> <code>SLACK</code> </p> </li> <li> <p> <code>ASANA</code> </p> </li> <li> <p> <code>JIRA</code> </p> </li> <li> <p> <code>M365</code> </p> </li> <li> <p> <code>M365AUDITLOGS</code> </p> </li> <li> <p> <code>ZOOM</code> </p> </li> <li> <p> <code>ZENDESK</code> </p> </li> <li> <p> <code>OKTA</code> </p> </li> <li> <p> <code>GOOGLE</code> </p> </li> <li> <p> <code>DROPBOX</code> </p> </li> <li> <p> <code>SMARTSHEET</code> </p> </li> <li> <p> <code>CISCO</code> </p> </li> </ul>', 'CreateIngestionRequest$app' => '<p>The name of the application.</p> <p>Valid values are:</p> <ul> <li> <p> <code>SLACK</code> </p> </li> <li> <p> <code>ASANA</code> </p> </li> <li> <p> <code>JIRA</code> </p> </li> <li> <p> <code>M365</code> </p> </li> <li> <p> <code>M365AUDITLOGS</code> </p> </li> <li> <p> <code>ZOOM</code> </p> </li> <li> <p> <code>ZENDESK</code> </p> </li> <li> <p> <code>OKTA</code> </p> </li> <li> <p> <code>GOOGLE</code> </p> </li> <li> <p> <code>DROPBOX</code> </p> </li> <li> <p> <code>SMARTSHEET</code> </p> </li> <li> <p> <code>CISCO</code> </p> </li> </ul>', 'Ingestion$app' => '<p>The name of the application.</p>', 'IngestionSummary$app' => '<p>The name of the application.</p>', 'UserAccessResultItem$app' => '<p>The name of the application.</p>', 'UserAccessTaskItem$app' => '<p>The name of the application.</p>', ], ], 'String63' => [ 'base' => NULL, 'refs' => [ 'S3Bucket$bucketName' => '<p>The name of the Amazon S3 bucket.</p>', ], ], 'String64' => [ 'base' => NULL, 'refs' => [ 'FirehoseStream$streamName' => '<p>The name of the Amazon Kinesis Data Firehose delivery stream.</p>', ], ], 'Tag' => [ 'base' => '<p>The key or keys of the key-value pairs for the tag or tags assigned to a resource.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$key' => '<p>Tag key.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>The keys of the key-value pairs for the tag or tags you want to remove from the specified resource.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateAppAuthorizationRequest$tags' => '<p>A map of the key-value pairs of the tag or tags to assign to the resource.</p>', 'CreateAppBundleRequest$tags' => '<p>A map of the key-value pairs of the tag or tags to assign to the resource.</p>', 'CreateIngestionDestinationRequest$tags' => '<p>A map of the key-value pairs of the tag or tags to assign to the resource.</p>', 'CreateIngestionRequest$tags' => '<p>A map of the key-value pairs of the tag or tags to assign to the resource.</p>', 'ListTagsForResourceResponse$tags' => '<p>A map of the key-value pairs for the tag or tags assigned to the specified resource.</p>', 'TagResourceRequest$tags' => '<p>A map of the key-value pairs of the tag or tags to assign to the resource.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$value' => '<p>Tag value.</p>', ], ], 'TaskError' => [ 'base' => '<p>Contains information about an error returned from a user access task.</p>', 'refs' => [ 'UserAccessResultItem$taskError' => '<p>Contains information about an error returned from a user access task.</p>', 'UserAccessTaskItem$error' => '<p>Error from the task, if any.</p>', ], ], 'TaskIdList' => [ 'base' => NULL, 'refs' => [ 'BatchGetUserAccessTasksRequest$taskIdList' => '<p>The tasks IDs to use for the request.</p>', ], ], 'Tenant' => [ 'base' => '<p>Contains information about an application tenant.</p>', 'refs' => [ 'AppAuthorization$tenant' => '<p>Contains information about an application tenant, such as the application display name and identifier.</p>', 'AppAuthorizationSummary$tenant' => '<p>Contains information about an application tenant, such as the application display name and identifier.</p>', 'CreateAppAuthorizationRequest$tenant' => '<p>Contains information about an application tenant, such as the application display name and identifier.</p>', 'UpdateAppAuthorizationRequest$tenant' => '<p>Contains information about an application tenant, such as the application display name and identifier.</p>', ], ], 'TenantIdentifier' => [ 'base' => NULL, 'refs' => [ 'CreateIngestionRequest$tenantId' => '<p>The ID of the application tenant.</p>', 'Ingestion$tenantId' => '<p>The ID of the application tenant.</p>', 'IngestionSummary$tenantId' => '<p>The ID of the application tenant.</p>', 'Tenant$tenantIdentifier' => '<p>The ID of the application tenant.</p>', 'UserAccessResultItem$tenantId' => '<p>The ID of the application tenant.</p>', 'UserAccessTaskItem$tenantId' => '<p>The ID of the application tenant.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The request rate exceeds the limit.</p>', 'refs' => [], ], 'UUID' => [ 'base' => NULL, 'refs' => [ 'CreateAppAuthorizationRequest$clientToken' => '<p>Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This lets you safely retry the request without accidentally performing the same operation a second time. Passing the same value to a later call to an operation requires that you also pass the same value for all other parameters. We recommend that you use a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value</a>.</p> <p>If you don\'t provide this value, then Amazon Web Services generates a random one for you.</p> <p>If you retry the operation with the same <code>ClientToken</code>, but with different parameters, the retry fails with an <code>IdempotentParameterMismatch</code> error.</p>', 'CreateAppBundleRequest$clientToken' => '<p>Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This lets you safely retry the request without accidentally performing the same operation a second time. Passing the same value to a later call to an operation requires that you also pass the same value for all other parameters. We recommend that you use a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value</a>.</p> <p>If you don\'t provide this value, then Amazon Web Services generates a random one for you.</p> <p>If you retry the operation with the same <code>ClientToken</code>, but with different parameters, the retry fails with an <code>IdempotentParameterMismatch</code> error.</p>', 'CreateIngestionDestinationRequest$clientToken' => '<p>Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This lets you safely retry the request without accidentally performing the same operation a second time. Passing the same value to a later call to an operation requires that you also pass the same value for all other parameters. We recommend that you use a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value</a>.</p> <p>If you don\'t provide this value, then Amazon Web Services generates a random one for you.</p> <p>If you retry the operation with the same <code>ClientToken</code>, but with different parameters, the retry fails with an <code>IdempotentParameterMismatch</code> error.</p>', 'CreateIngestionRequest$clientToken' => '<p>Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This lets you safely retry the request without accidentally performing the same operation a second time. Passing the same value to a later call to an operation requires that you also pass the same value for all other parameters. We recommend that you use a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value</a>.</p> <p>If you don\'t provide this value, then Amazon Web Services generates a random one for you.</p> <p>If you retry the operation with the same <code>ClientToken</code>, but with different parameters, the retry fails with an <code>IdempotentParameterMismatch</code> error.</p>', 'TaskIdList$member' => NULL, 'UserAccessResultItem$taskId' => '<p>The unique ID of the task.</p>', 'UserAccessTaskItem$taskId' => '<p>The unique ID of the task.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAppAuthorizationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAppAuthorizationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateIngestionDestinationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateIngestionDestinationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UserAccessResultItem' => [ 'base' => '<p>Contains information about a user\'s access to an application.</p>', 'refs' => [ 'UserAccessResultsList$member' => NULL, ], ], 'UserAccessResultsList' => [ 'base' => NULL, 'refs' => [ 'BatchGetUserAccessTasksResponse$userAccessResultsList' => '<p>Contains a list of user access results.</p>', ], ], 'UserAccessTaskItem' => [ 'base' => '<p>Contains information about a user access task.</p>', 'refs' => [ 'UserAccessTasksList$member' => NULL, ], ], 'UserAccessTasksList' => [ 'base' => NULL, 'refs' => [ 'StartUserAccessTasksResponse$userAccessTasksList' => '<p>Contains a list of user access task information.</p>', ], ], 'ValidationException' => [ 'base' => '<p>The request has invalid or missing parameters.</p>', 'refs' => [], ], 'ValidationExceptionField' => [ 'base' => '<p>The input failed to meet the constraints specified by the Amazon Web Services service in a specified field.</p>', 'refs' => [ 'ValidationExceptionFieldList$member' => NULL, ], ], 'ValidationExceptionFieldList' => [ 'base' => NULL, 'refs' => [ 'ValidationException$fieldList' => '<p>The field list.</p>', ], ], 'ValidationExceptionReason' => [ 'base' => NULL, 'refs' => [ 'ValidationException$reason' => '<p>The reason for the exception.</p>', ], ], ],];
