<?php
// This file was auto-generated from sdk-root/src/data/application-signals/2024-04-15/docs-2.json
return [ 'version' => '2.0', 'service' => '<important> <p>This is a Preview release of the Application Signals API Reference. Operations and parameters are subject to change before the general availability release.</p> </important> <p>Use CloudWatch Application Signals for comprehensive observability of your cloud-based applications. It enables real-time service health dashboards and helps you track long-term performance trends against your business goals. The application-centric view provides you with unified visibility across your applications, services, and dependencies, so you can proactively monitor and efficiently triage any issues that may arise, ensuring optimal customer experience.</p> <p>Application Signals provides the following benefits:</p> <ul> <li> <p>Automatically collect metrics and traces from your applications, and display key metrics such as call volume, availability, latency, faults, and errors. </p> </li> <li> <p>Create and monitor service level objectives (SLOs). </p> </li> <li> <p>See a map of your application topology that Application Signals automatically discovers, that gives you a visual representation of your applications, dependencies, and their connectivity.</p> </li> </ul>', 'operations' => [ 'BatchGetServiceLevelObjectiveBudgetReport' => '<p>Use this operation to retrieve one or more <i>service level objective (SLO) budget reports</i>.</p> <p>An <i>error budget</i> is the amount of time in unhealthy periods that your service can accumulate during an interval before your overall SLO budget health is breached and the SLO is considered to be unmet. For example, an SLO with a threshold of 99.95% and a monthly interval translates to an error budget of 21.9 minutes of downtime in a 30-day month.</p> <p>Budget reports include a health indicator, the attainment value, and remaining budget.</p> <p>For more information about SLO error budgets, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-ServiceLevelObjectives.html#CloudWatch-ServiceLevelObjectives-concepts"> SLO concepts</a>.</p>', 'CreateServiceLevelObjective' => '<p>Creates a service level objective (SLO), which can help you ensure that your critical business operations are meeting customer expectations. Use SLOs to set and track specific target levels for the reliability and availability of your applications and services. SLOs use service level indicators (SLIs) to calculate whether the application is performing at the level that you want.</p> <p>Create an SLO to set a target for a service or operation’s availability or latency. CloudWatch measures this target frequently you can find whether it has been breached. </p> <p>When you create an SLO, you set an <i>attainment goal</i> for it. An <i>attainment goal</i> is the ratio of good periods that meet the threshold requirements to the total periods within the interval. For example, an attainment goal of 99.9% means that within your interval, you are targeting 99.9% of the periods to be in healthy state.</p> <p>After you have created an SLO, you can retrieve error budget reports for it. An <i>error budget</i> is the number of periods or amount of time that your service can accumulate during an interval before your overall SLO budget health is breached and the SLO is considered to be unmet. for example, an SLO with a threshold that 99.95% of requests must be completed under 2000ms every month translates to an error budget of 21.9 minutes of downtime per month.</p> <p>When you call this operation, Application Signals creates the <i>AWSServiceRoleForCloudWatchApplicationSignals</i> service-linked role, if it doesn\'t already exist in your account. This service- linked role has the following permissions:</p> <ul> <li> <p> <code>xray:GetServiceGraph</code> </p> </li> <li> <p> <code>logs:StartQuery</code> </p> </li> <li> <p> <code>logs:GetQueryResults</code> </p> </li> <li> <p> <code>cloudwatch:GetMetricData</code> </p> </li> <li> <p> <code>cloudwatch:ListMetrics</code> </p> </li> <li> <p> <code>tag:GetResources</code> </p> </li> <li> <p> <code>autoscaling:DescribeAutoScalingGroups</code> </p> </li> </ul> <p>You can easily set SLO targets for your applications that are discovered by Application Signals, using critical metrics such as latency and availability. You can also set SLOs against any CloudWatch metric or math expression that produces a time series.</p> <p>For more information about SLOs, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-ServiceLevelObjectives.html"> Service level objectives (SLOs)</a>. </p>', 'DeleteServiceLevelObjective' => '<p>Deletes the specified service level objective.</p>', 'GetService' => '<p>Returns information about a service discovered by Application Signals.</p>', 'GetServiceLevelObjective' => '<p>Returns information about one SLO created in the account. </p>', 'ListServiceDependencies' => '<p>Returns a list of service dependencies of the service that you specify. A dependency is an infrastructure component that an operation of this service connects with. Dependencies can include Amazon Web Services services, Amazon Web Services resources, and third-party services. </p>', 'ListServiceDependents' => '<p>Returns the list of dependents that invoked the specified service during the provided time range. Dependents include other services, CloudWatch Synthetics canaries, and clients that are instrumented with CloudWatch RUM app monitors.</p>', 'ListServiceLevelObjectives' => '<p>Returns a list of SLOs created in this account.</p>', 'ListServiceOperations' => '<p>Returns a list of the <i>operations</i> of this service that have been discovered by Application Signals. Only the operations that were invoked during the specified time range are returned.</p>', 'ListServices' => '<p>Returns a list of services that have been discovered by Application Signals. A service represents a minimum logical and transactional unit that completes a business function. Services are discovered through Application Signals instrumentation.</p>', 'ListTagsForResource' => '<p>Displays the tags associated with a CloudWatch resource. Tags can be assigned to service level objectives.</p>', 'StartDiscovery' => '<p>Enables this Amazon Web Services account to be able to use CloudWatch Application Signals by creating the <i>AWSServiceRoleForCloudWatchApplicationSignals</i> service-linked role. This service- linked role has the following permissions:</p> <ul> <li> <p> <code>xray:GetServiceGraph</code> </p> </li> <li> <p> <code>logs:StartQuery</code> </p> </li> <li> <p> <code>logs:GetQueryResults</code> </p> </li> <li> <p> <code>cloudwatch:GetMetricData</code> </p> </li> <li> <p> <code>cloudwatch:ListMetrics</code> </p> </li> <li> <p> <code>tag:GetResources</code> </p> </li> <li> <p> <code>autoscaling:DescribeAutoScalingGroups</code> </p> </li> </ul> <p>After completing this step, you still need to instrument your Java and Python applications to send data to Application Signals. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Application-Signals-Enable.html"> Enabling Application Signals</a>.</p>', 'TagResource' => '<p>Assigns one or more tags (key-value pairs) to the specified CloudWatch resource, such as a service level objective.</p> <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.</p> <p>Tags don\'t have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.</p> <p>You can use the <code>TagResource</code> action with an alarm that already has tags. If you specify a new tag key for the alarm, this tag is appended to the list of tags associated with the alarm. If you specify a tag key that is already associated with the alarm, the new tag value that you specify replaces the previous value for that tag.</p> <p>You can associate as many as 50 tags with a CloudWatch resource.</p>', 'UntagResource' => '<p>Removes one or more tags from the specified resource.</p>', 'UpdateServiceLevelObjective' => '<p>Updates an existing service level objective (SLO). If you omit parameters, the previous values of those parameters are retained. </p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You don\'t have sufficient permissions to perform this action.</p>', 'refs' => [], ], 'AccountId' => [ 'base' => NULL, 'refs' => [ 'MetricDataQuery$AccountId' => '<p>The ID of the account where this metric is located. If you are performing this operatiion in a monitoring account, use this to specify which source account to retrieve this metric from.</p>', ], ], 'AmazonResourceName' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the CloudWatch resource that you want to view tags for.</p> <p>The ARN format of an Application Signals SLO is <code>arn:aws:cloudwatch:<i>Region</i>:<i>account-id</i>:slo:<i>slo-name</i> </code> </p> <p>For more information about ARN format, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazoncloudwatch.html#amazoncloudwatch-resources-for-iam-policies"> Resource Types Defined by Amazon CloudWatch</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'TagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the CloudWatch resource that you want to set tags for.</p> <p>The ARN format of an Application Signals SLO is <code>arn:aws:cloudwatch:<i>Region</i>:<i>account-id</i>:slo:<i>slo-name</i> </code> </p> <p>For more information about ARN format, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazoncloudwatch.html#amazoncloudwatch-resources-for-iam-policies"> Resource Types Defined by Amazon CloudWatch</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'UntagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the CloudWatch resource that you want to delete tags from.</p> <p>The ARN format of an Application Signals SLO is <code>arn:aws:cloudwatch:<i>Region</i>:<i>account-id</i>:slo:<i>slo-name</i> </code> </p> <p>For more information about ARN format, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazoncloudwatch.html#amazoncloudwatch-resources-for-iam-policies"> Resource Types Defined by Amazon CloudWatch</a> in the <i>Amazon Web Services General Reference</i>.</p>', ], ], 'Attainment' => [ 'base' => NULL, 'refs' => [ 'ServiceLevelObjectiveBudgetReport$Attainment' => '<p>A number between 0 and 100 that represents the percentage of time periods that the service has attained the SLO\'s attainment goal, as of the time of the request.</p>', ], ], 'AttainmentGoal' => [ 'base' => NULL, 'refs' => [ 'Goal$AttainmentGoal' => '<p>The threshold that determines if the goal is being met. An <i>attainment goal</i> is the ratio of good periods that meet the threshold requirements to the total periods within the interval. For example, an attainment goal of 99.9% means that within your interval, you are targeting 99.9% of the periods to be in healthy state.</p> <p>If you omit this parameter, 99 is used to represent 99% as the attainment goal.</p>', ], ], 'AttributeMap' => [ 'base' => NULL, 'refs' => [ 'AttributeMaps$member' => NULL, ], ], 'AttributeMaps' => [ 'base' => NULL, 'refs' => [ 'Service$AttributeMaps' => '<p>This structure contains one or more string-to-string maps that help identify this service. It can include <i>platform attributes</i>, <i>application attributes</i>, and <i>telemetry attributes</i>.</p> <p>Platform attributes contain information the service\'s platform.</p> <ul> <li> <p> <code>PlatformType</code> defines the hosted-in platform.</p> </li> <li> <p> <code>EKS.Cluster</code> is the name of the Amazon EKS cluster.</p> </li> <li> <p> <code>K8s.Cluster</code> is the name of the self-hosted Kubernetes cluster.</p> </li> <li> <p> <code>K8s.Namespace</code> is the name of the Kubernetes namespace in either Amazon EKS or Kubernetes clusters.</p> </li> <li> <p> <code>K8s.Workload</code> is the name of the Kubernetes workload in either Amazon EKS or Kubernetes clusters.</p> </li> <li> <p> <code>K8s.Node</code> is the name of the Kubernetes node in either Amazon EKS or Kubernetes clusters.</p> </li> <li> <p> <code>K8s.Pod</code> is the name of the Kubernetes pod in either Amazon EKS or Kubernetes clusters.</p> </li> <li> <p> <code>EC2.AutoScalingGroup</code> is the name of the Amazon EC2 Auto Scaling group.</p> </li> <li> <p> <code>EC2.InstanceId</code> is the ID of the Amazon EC2 instance.</p> </li> <li> <p> <code>Host</code> is the name of the host, for all platform types.</p> </li> </ul> <p>Applciation attributes contain information about the application.</p> <ul> <li> <p> <code>AWS.Application</code> is the application\'s name in Amazon Web Services Service Catalog AppRegistry.</p> </li> <li> <p> <code>AWS.Application.ARN</code> is the application\'s ARN in Amazon Web Services Service Catalog AppRegistry.</p> </li> </ul> <p>Telemetry attributes contain telemetry information.</p> <ul> <li> <p> <code>Telemetry.SDK</code> is the fingerprint of the OpenTelemetry SDK version for instrumented services.</p> </li> <li> <p> <code>Telemetry.Agent</code> is the fingerprint of the agent used to collect and send telemetry data.</p> </li> <li> <p> <code>Telemetry.Source</code> Specifies the point of application where the telemetry was collected or specifies what was used for the source of telemetry data.</p> </li> </ul>', 'ServiceSummary$AttributeMaps' => '<p>This structure contains one or more string-to-string maps that help identify this service. It can include <i>platform attributes</i>, <i>application attributes</i>, and <i>telemetry attributes</i>.</p> <p>Platform attributes contain information the service\'s platform.</p> <ul> <li> <p> <code>PlatformType</code> defines the hosted-in platform.</p> </li> <li> <p> <code>EKS.Cluster</code> is the name of the Amazon EKS cluster.</p> </li> <li> <p> <code>K8s.Cluster</code> is the name of the self-hosted Kubernetes cluster.</p> </li> <li> <p> <code>K8s.Namespace</code> is the name of the Kubernetes namespace in either Amazon EKS or Kubernetes clusters.</p> </li> <li> <p> <code>K8s.Workload</code> is the name of the Kubernetes workload in either Amazon EKS or Kubernetes clusters.</p> </li> <li> <p> <code>K8s.Node</code> is the name of the Kubernetes node in either Amazon EKS or Kubernetes clusters.</p> </li> <li> <p> <code>K8s.Pod</code> is the name of the Kubernetes pod in either Amazon EKS or Kubernetes clusters.</p> </li> <li> <p> <code>EC2.AutoScalingGroup</code> is the name of the Amazon EC2 Auto Scaling group.</p> </li> <li> <p> <code>EC2.InstanceId</code> is the ID of the Amazon EC2 instance.</p> </li> <li> <p> <code>Host</code> is the name of the host, for all platform types.</p> </li> </ul> <p>Applciation attributes contain information about the application.</p> <ul> <li> <p> <code>AWS.Application</code> is the application\'s name in Amazon Web Services Service Catalog AppRegistry.</p> </li> <li> <p> <code>AWS.Application.ARN</code> is the application\'s ARN in Amazon Web Services Service Catalog AppRegistry.</p> </li> </ul> <p>Telemetry attributes contain telemetry information.</p> <ul> <li> <p> <code>Telemetry.SDK</code> is the fingerprint of the OpenTelemetry SDK version for instrumented services.</p> </li> <li> <p> <code>Telemetry.Agent</code> is the fingerprint of the agent used to collect and send telemetry data.</p> </li> <li> <p> <code>Telemetry.Source</code> Specifies the point of application where the telemetry was collected or specifies what was used for the source of telemetry data.</p> </li> </ul>', ], ], 'Attributes' => [ 'base' => NULL, 'refs' => [ 'GetServiceInput$KeyAttributes' => '<p>Use this field to specify which service you want to retrieve information for. You must specify at least the <code>Type</code>, <code>Name</code>, and <code>Environment</code> attributes.</p> <p>This is a string-to-string map. It can include the following fields.</p> <ul> <li> <p> <code>Type</code> designates the type of object this is.</p> </li> <li> <p> <code>ResourceType</code> specifies the type of the resource. This field is used only when the value of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.</p> </li> <li> <p> <code>Name</code> specifies the name of the object. This is used only if the value of the <code>Type</code> field is <code>Service</code>, <code>RemoteService</code>, or <code>AWS::Service</code>.</p> </li> <li> <p> <code>Identifier</code> identifies the resource objects of this resource. This is used only if the value of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.</p> </li> <li> <p> <code>Environment</code> specifies the location where this object is hosted, or what it belongs to.</p> </li> </ul>', 'ListServiceDependenciesInput$KeyAttributes' => '<p>Use this field to specify which service you want to retrieve information for. You must specify at least the <code>Type</code>, <code>Name</code>, and <code>Environment</code> attributes.</p> <p>This is a string-to-string map. It can include the following fields.</p> <ul> <li> <p> <code>Type</code> designates the type of object this is.</p> </li> <li> <p> <code>ResourceType</code> specifies the type of the resource. This field is used only when the value of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.</p> </li> <li> <p> <code>Name</code> specifies the name of the object. This is used only if the value of the <code>Type</code> field is <code>Service</code>, <code>RemoteService</code>, or <code>AWS::Service</code>.</p> </li> <li> <p> <code>Identifier</code> identifies the resource objects of this resource. This is used only if the value of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.</p> </li> <li> <p> <code>Environment</code> specifies the location where this object is hosted, or what it belongs to.</p> </li> </ul>', 'ListServiceDependentsInput$KeyAttributes' => '<p>Use this field to specify which service you want to retrieve information for. You must specify at least the <code>Type</code>, <code>Name</code>, and <code>Environment</code> attributes.</p> <p>This is a string-to-string map. It can include the following fields.</p> <ul> <li> <p> <code>Type</code> designates the type of object this is.</p> </li> <li> <p> <code>ResourceType</code> specifies the type of the resource. This field is used only when the value of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.</p> </li> <li> <p> <code>Name</code> specifies the name of the object. This is used only if the value of the <code>Type</code> field is <code>Service</code>, <code>RemoteService</code>, or <code>AWS::Service</code>.</p> </li> <li> <p> <code>Identifier</code> identifies the resource objects of this resource. This is used only if the value of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.</p> </li> <li> <p> <code>Environment</code> specifies the location where this object is hosted, or what it belongs to.</p> </li> </ul>', 'ListServiceLevelObjectivesInput$KeyAttributes' => '<p>You can use this optional field to specify which services you want to retrieve SLO information for.</p> <p>This is a string-to-string map. It can include the following fields.</p> <ul> <li> <p> <code>Type</code> designates the type of object this is.</p> </li> <li> <p> <code>ResourceType</code> specifies the type of the resource. This field is used only when the value of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.</p> </li> <li> <p> <code>Name</code> specifies the name of the object. This is used only if the value of the <code>Type</code> field is <code>Service</code>, <code>RemoteService</code>, or <code>AWS::Service</code>.</p> </li> <li> <p> <code>Identifier</code> identifies the resource objects of this resource. This is used only if the value of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.</p> </li> <li> <p> <code>Environment</code> specifies the location where this object is hosted, or what it belongs to.</p> </li> </ul>', 'ListServiceOperationsInput$KeyAttributes' => '<p>Use this field to specify which service you want to retrieve information for. You must specify at least the <code>Type</code>, <code>Name</code>, and <code>Environment</code> attributes.</p> <p>This is a string-to-string map. It can include the following fields.</p> <ul> <li> <p> <code>Type</code> designates the type of object this is.</p> </li> <li> <p> <code>ResourceType</code> specifies the type of the resource. This field is used only when the value of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.</p> </li> <li> <p> <code>Name</code> specifies the name of the object. This is used only if the value of the <code>Type</code> field is <code>Service</code>, <code>RemoteService</code>, or <code>AWS::Service</code>.</p> </li> <li> <p> <code>Identifier</code> identifies the resource objects of this resource. This is used only if the value of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.</p> </li> <li> <p> <code>Environment</code> specifies the location where this object is hosted, or what it belongs to.</p> </li> </ul>', 'Service$KeyAttributes' => '<p>This is a string-to-string map. It can include the following fields.</p> <ul> <li> <p> <code>Type</code> designates the type of object this is.</p> </li> <li> <p> <code>ResourceType</code> specifies the type of the resource. This field is used only when the value of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.</p> </li> <li> <p> <code>Name</code> specifies the name of the object. This is used only if the value of the <code>Type</code> field is <code>Service</code>, <code>RemoteService</code>, or <code>AWS::Service</code>.</p> </li> <li> <p> <code>Identifier</code> identifies the resource objects of this resource. This is used only if the value of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.</p> </li> <li> <p> <code>Environment</code> specifies the location where this object is hosted, or what it belongs to.</p> </li> </ul>', 'ServiceDependency$DependencyKeyAttributes' => '<p>This is a string-to-string map. It can include the following fields.</p> <ul> <li> <p> <code>Type</code> designates the type of object this is.</p> </li> <li> <p> <code>ResourceType</code> specifies the type of the resource. This field is used only when the value of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.</p> </li> <li> <p> <code>Name</code> specifies the name of the object. This is used only if the value of the <code>Type</code> field is <code>Service</code>, <code>RemoteService</code>, or <code>AWS::Service</code>.</p> </li> <li> <p> <code>Identifier</code> identifies the resource objects of this resource. This is used only if the value of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.</p> </li> <li> <p> <code>Environment</code> specifies the location where this object is hosted, or what it belongs to.</p> </li> </ul>', 'ServiceDependent$DependentKeyAttributes' => '<p>This is a string-to-string map. It can include the following fields.</p> <ul> <li> <p> <code>Type</code> designates the type of object this is.</p> </li> <li> <p> <code>ResourceType</code> specifies the type of the resource. This field is used only when the value of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.</p> </li> <li> <p> <code>Name</code> specifies the name of the object. This is used only if the value of the <code>Type</code> field is <code>Service</code>, <code>RemoteService</code>, or <code>AWS::Service</code>.</p> </li> <li> <p> <code>Identifier</code> identifies the resource objects of this resource. This is used only if the value of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.</p> </li> <li> <p> <code>Environment</code> specifies the location where this object is hosted, or what it belongs to.</p> </li> </ul>', 'ServiceLevelIndicatorMetric$KeyAttributes' => '<p>This is a string-to-string map that contains information about the type of object that this SLO is related to. It can include the following fields.</p> <ul> <li> <p> <code>Type</code> designates the type of object that this SLO is related to.</p> </li> <li> <p> <code>ResourceType</code> specifies the type of the resource. This field is used only when the value of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.</p> </li> <li> <p> <code>Name</code> specifies the name of the object. This is used only if the value of the <code>Type</code> field is <code>Service</code>, <code>RemoteService</code>, or <code>AWS::Service</code>.</p> </li> <li> <p> <code>Identifier</code> identifies the resource objects of this resource. This is used only if the value of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.</p> </li> <li> <p> <code>Environment</code> specifies the location where this object is hosted, or what it belongs to.</p> </li> </ul>', 'ServiceLevelIndicatorMetricConfig$KeyAttributes' => '<p>If this SLO is related to a metric collected by Application Signals, you must use this field to specify which service the SLO metric is related to. To do so, you must specify at least the <code>Type</code>, <code>Name</code>, and <code>Environment</code> attributes.</p> <p>This is a string-to-string map. It can include the following fields.</p> <ul> <li> <p> <code>Type</code> designates the type of object this is.</p> </li> <li> <p> <code>ResourceType</code> specifies the type of the resource. This field is used only when the value of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.</p> </li> <li> <p> <code>Name</code> specifies the name of the object. This is used only if the value of the <code>Type</code> field is <code>Service</code>, <code>RemoteService</code>, or <code>AWS::Service</code>.</p> </li> <li> <p> <code>Identifier</code> identifies the resource objects of this resource. This is used only if the value of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.</p> </li> <li> <p> <code>Environment</code> specifies the location where this object is hosted, or what it belongs to.</p> </li> </ul>', 'ServiceLevelObjectiveSummary$KeyAttributes' => '<p>This is a string-to-string map. It can include the following fields.</p> <ul> <li> <p> <code>Type</code> designates the type of object this service level objective is for.</p> </li> <li> <p> <code>ResourceType</code> specifies the type of the resource. This field is used only when the value of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.</p> </li> <li> <p> <code>Name</code> specifies the name of the object. This is used only if the value of the <code>Type</code> field is <code>Service</code>, <code>RemoteService</code>, or <code>AWS::Service</code>.</p> </li> <li> <p> <code>Identifier</code> identifies the resource objects of this resource. This is used only if the value of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.</p> </li> <li> <p> <code>Environment</code> specifies the location where this object is hosted, or what it belongs to.</p> </li> </ul>', 'ServiceSummary$KeyAttributes' => '<p>This is a string-to-string map that help identify the objects discovered by Application Signals. It can include the following fields.</p> <ul> <li> <p> <code>Type</code> designates the type of object this is.</p> </li> <li> <p> <code>ResourceType</code> specifies the type of the resource. This field is used only when the value of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.</p> </li> <li> <p> <code>Name</code> specifies the name of the object. This is used only if the value of the <code>Type</code> field is <code>Service</code>, <code>RemoteService</code>, or <code>AWS::Service</code>.</p> </li> <li> <p> <code>Identifier</code> identifies the resource objects of this resource. This is used only if the value of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.</p> </li> <li> <p> <code>Environment</code> specifies the location where this object is hosted, or what it belongs to.</p> </li> </ul>', ], ], 'BatchGetServiceLevelObjectiveBudgetReportInput' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetServiceLevelObjectiveBudgetReportOutput' => [ 'base' => NULL, 'refs' => [], ], 'BudgetSecondsRemaining' => [ 'base' => NULL, 'refs' => [ 'ServiceLevelObjectiveBudgetReport$BudgetSecondsRemaining' => '<p>The budget amount remaining before the SLO status becomes <code>BREACHING</code>, at the time specified in the <code>Timestemp</code> parameter of the request. If this value is negative, then the SLO is already in <code>BREACHING</code> status.</p>', ], ], 'CalendarInterval' => [ 'base' => '<p>If the interval for this service level objective is a calendar interval, this structure contains the interval specifications.</p>', 'refs' => [ 'Interval$CalendarInterval' => '<p>If the interval is a calendar interval, this structure contains the interval specifications.</p>', ], ], 'CalendarIntervalDuration' => [ 'base' => NULL, 'refs' => [ 'CalendarInterval$Duration' => '<p>Specifies the duration of each calendar interval. For example, if <code>Duration</code> is <code>1</code> and <code>DurationUnit</code> is <code>MONTH</code>, each interval is one month, aligned with the calendar.</p>', ], ], 'ConflictException' => [ 'base' => '<p>This operation attempted to create a resource that already exists.</p>', 'refs' => [], ], 'CreateServiceLevelObjectiveInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateServiceLevelObjectiveOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteServiceLevelObjectiveInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteServiceLevelObjectiveOutput' => [ 'base' => NULL, 'refs' => [], ], 'Dimension' => [ 'base' => '<p>A dimension is a name/value pair that is part of the identity of a metric. Because dimensions are part of the unique identifier for a metric, whenever you add a unique name/value pair to one of your metrics, you are creating a new variation of that metric. For example, many Amazon EC2 metrics publish <code>InstanceId</code> as a dimension name, and the actual instance ID as the value for that dimension.</p> <p>You can assign up to 30 dimensions to a metric.</p>', 'refs' => [ 'Dimensions$member' => NULL, ], ], 'DimensionName' => [ 'base' => NULL, 'refs' => [ 'Dimension$Name' => '<p>The name of the dimension. Dimension names must contain only ASCII characters, must include at least one non-whitespace character, and cannot start with a colon (<code>:</code>). ASCII control characters are not supported as part of dimension names.</p>', ], ], 'DimensionValue' => [ 'base' => NULL, 'refs' => [ 'Dimension$Value' => '<p>The value of the dimension. Dimension values must contain only ASCII characters and must include at least one non-whitespace character. ASCII control characters are not supported as part of dimension values.</p>', ], ], 'Dimensions' => [ 'base' => NULL, 'refs' => [ 'Metric$Dimensions' => '<p>An array of one or more dimensions to use to define the metric that you want to use. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Dimension">Dimensions</a>.</p>', 'MetricReference$Dimensions' => '<p>An array of one or more dimensions that further define the metric. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Dimension">CloudWatchDimensions</a>.</p>', ], ], 'DurationUnit' => [ 'base' => NULL, 'refs' => [ 'CalendarInterval$DurationUnit' => '<p>Specifies the calendar interval unit.</p>', 'RollingInterval$DurationUnit' => '<p>Specifies the rolling interval unit.</p>', ], ], 'FaultDescription' => [ 'base' => NULL, 'refs' => [ 'ResourceNotFoundException$Message' => NULL, ], ], 'GetServiceInput' => [ 'base' => NULL, 'refs' => [], ], 'GetServiceLevelObjectiveInput' => [ 'base' => NULL, 'refs' => [], ], 'GetServiceLevelObjectiveOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetServiceOutput' => [ 'base' => NULL, 'refs' => [], ], 'Goal' => [ 'base' => '<p>This structure contains the attributes that determine the goal of an SLO. This includes the time period for evaluation and the attainment threshold.</p>', 'refs' => [ 'CreateServiceLevelObjectiveInput$Goal' => '<p>A structure that contains the attributes that determine the goal of the SLO. This includes the time period for evaluation and the attainment threshold.</p>', 'ServiceLevelObjective$Goal' => NULL, 'ServiceLevelObjectiveBudgetReport$Goal' => NULL, 'UpdateServiceLevelObjectiveInput$Goal' => '<p>A structure that contains the attributes that determine the goal of the SLO. This includes the time period for evaluation and the attainment threshold.</p>', ], ], 'Interval' => [ 'base' => '<p>The time period used to evaluate the SLO. It can be either a calendar interval or rolling interval.</p>', 'refs' => [ 'Goal$Interval' => '<p>The time period used to evaluate the SLO. It can be either a calendar interval or rolling interval.</p> <p>If you omit this parameter, a rolling interval of 7 days is used.</p>', ], ], 'KeyAttributeName' => [ 'base' => NULL, 'refs' => [ 'Attributes$key' => NULL, ], ], 'KeyAttributeValue' => [ 'base' => NULL, 'refs' => [ 'Attributes$value' => NULL, ], ], 'ListServiceDependenciesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListServiceDependenciesMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListServiceDependenciesInput$MaxResults' => '<p>The maximum number of results to return in one operation. If you omit this parameter, the default of 50 is used.</p>', ], ], 'ListServiceDependenciesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListServiceDependentsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListServiceDependentsMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListServiceDependentsInput$MaxResults' => '<p>The maximum number of results to return in one operation. If you omit this parameter, the default of 50 is used.</p>', ], ], 'ListServiceDependentsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListServiceLevelObjectivesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListServiceLevelObjectivesMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListServiceLevelObjectivesInput$MaxResults' => '<p>The maximum number of results to return in one operation. If you omit this parameter, the default of 50 is used.</p>', ], ], 'ListServiceLevelObjectivesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListServiceOperationMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListServiceOperationsInput$MaxResults' => '<p>The maximum number of results to return in one operation. If you omit this parameter, the default of 50 is used.</p>', ], ], 'ListServiceOperationsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListServiceOperationsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListServicesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListServicesMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListServicesInput$MaxResults' => '<p> The maximum number of results to return in one operation. If you omit this parameter, the default of 50 is used. </p>', ], ], 'ListServicesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'Metric' => [ 'base' => '<p>This structure defines the metric used for a service level indicator, including the metric name, namespace, and dimensions</p>', 'refs' => [ 'MetricStat$Metric' => '<p>The metric to use as the service level indicator, including the metric name, namespace, and dimensions.</p>', ], ], 'MetricDataQueries' => [ 'base' => NULL, 'refs' => [ 'ServiceLevelIndicatorMetric$MetricDataQueries' => '<p>If this SLO monitors a CloudWatch metric or the result of a CloudWatch metric math expression, this structure includes the information about that metric or expression. </p>', 'ServiceLevelIndicatorMetricConfig$MetricDataQueries' => '<p>If this SLO monitors a CloudWatch metric or the result of a CloudWatch metric math expression, use this structure to specify that metric or expression. </p>', ], ], 'MetricDataQuery' => [ 'base' => '<p>Use this structure to define a metric or metric math expression that you want to use as for a service level objective. </p> <p>Each <code>MetricDataQuery</code> in the <code>MetricDataQueries</code> array specifies either a metric to retrieve, or a metric math expression to be performed on retrieved metrics. A single <code>MetricDataQueries</code> array can include as many as 20 <code>MetricDataQuery</code> structures in the array. The 20 structures can include as many as 10 structures that contain a <code>MetricStat</code> parameter to retrieve a metric, and as many as 10 structures that contain the <code>Expression</code> parameter to perform a math expression. Of those <code>Expression</code> structures, exactly one must have true as the value for <code>ReturnData</code>. The result of this expression used for the SLO.</p> <p>For more information about metric math expressions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html">CloudWatchUse metric math</a>.</p> <p>Within each <code>MetricDataQuery</code> object, you must specify either <code>Expression</code> or <code>MetricStat</code> but not both.</p>', 'refs' => [ 'MetricDataQueries$member' => NULL, ], ], 'MetricExpression' => [ 'base' => NULL, 'refs' => [ 'MetricDataQuery$Expression' => '<p>This field can contain a metric math expression to be performed on the other metrics that you are retrieving within this <code>MetricDataQueries</code> structure. </p> <p>A math expression can use the <code>Id</code> of the other metrics or queries to refer to those metrics, and can also use the <code>Id</code> of other expressions to use the result of those expressions. For more information about metric math expressions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax">Metric Math Syntax and Functions</a> in the <i>Amazon CloudWatch User Guide</i>.</p> <p>Within each <code>MetricDataQuery</code> object, you must specify either <code>Expression</code> or <code>MetricStat</code> but not both.</p>', ], ], 'MetricId' => [ 'base' => NULL, 'refs' => [ 'MetricDataQuery$Id' => '<p>A short name used to tie this object to the results in the response. This <code>Id</code> must be unique within a <code>MetricDataQueries</code> array. If you are performing math expressions on this set of data, this name represents that data and can serve as a variable in the metric math expression. The valid characters are letters, numbers, and underscore. The first character must be a lowercase letter.</p>', ], ], 'MetricLabel' => [ 'base' => NULL, 'refs' => [ 'MetricDataQuery$Label' => '<p>A human-readable label for this metric or expression. This is especially useful if this is an expression, so that you know what the value represents. If the metric or expression is shown in a CloudWatch dashboard widget, the label is shown. If <code>Label</code> is omitted, CloudWatch generates a default.</p> <p>You can put dynamic expressions into a label, so that it is more descriptive. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/graph-dynamic-labels.html">Using Dynamic Labels</a>.</p>', ], ], 'MetricName' => [ 'base' => NULL, 'refs' => [ 'Metric$MetricName' => '<p>The name of the metric to use.</p>', 'MetricReference$MetricName' => '<p>The name of the metric.</p>', ], ], 'MetricReference' => [ 'base' => '<p>This structure contains information about one CloudWatch metric associated with this entity discovered by Application Signals.</p>', 'refs' => [ 'MetricReferences$member' => NULL, ], ], 'MetricReferences' => [ 'base' => NULL, 'refs' => [ 'Service$MetricReferences' => '<p>An array of structures that each contain information about one metric associated with this service.</p>', 'ServiceDependency$MetricReferences' => '<p>An array of structures that each contain information about one metric associated with this service dependency that was discovered by Application Signals.</p>', 'ServiceDependent$MetricReferences' => '<p>An array of structures that each contain information about one metric associated with this service dependent that was discovered by Application Signals.</p>', 'ServiceOperation$MetricReferences' => '<p>An array of structures that each contain information about one metric associated with this service operation that was discovered by Application Signals.</p>', 'ServiceSummary$MetricReferences' => '<p>An array of structures that each contain information about one metric associated with this service.</p>', ], ], 'MetricStat' => [ 'base' => '<p>This structure defines the metric to be used as the service level indicator, along with the statistics, period, and unit.</p>', 'refs' => [ 'MetricDataQuery$MetricStat' => '<p>A metric to be used directly for the SLO, or to be used in the math expression that will be used for the SLO.</p> <p>Within one <code>MetricDataQuery</code> object, you must specify either <code>Expression</code> or <code>MetricStat</code> but not both.</p>', ], ], 'MetricType' => [ 'base' => NULL, 'refs' => [ 'MetricReference$MetricType' => '<p>Used to display the appropriate statistics in the CloudWatch console.</p>', ], ], 'Namespace' => [ 'base' => NULL, 'refs' => [ 'Metric$Namespace' => '<p>The namespace of the metric. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Namespace">Namespaces</a>.</p>', 'MetricReference$Namespace' => '<p>The namespace of the metric. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Namespace">CloudWatchNamespaces</a>.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListServiceDependenciesInput$NextToken' => '<p>Include this value, if it was returned by the previous operation, to get the next set of service dependencies.</p>', 'ListServiceDependenciesOutput$NextToken' => '<p>Include this value in your next use of this API to get next set of service dependencies.</p>', 'ListServiceDependentsInput$NextToken' => '<p>Include this value, if it was returned by the previous operation, to get the next set of service dependents.</p>', 'ListServiceDependentsOutput$NextToken' => '<p>Include this value in your next use of this API to get next set of service dependents.</p>', 'ListServiceLevelObjectivesInput$NextToken' => '<p>Include this value, if it was returned by the previous operation, to get the next set of service level objectives.</p>', 'ListServiceLevelObjectivesOutput$NextToken' => '<p>Include this value in your next use of this API to get next set of service level objectives.</p>', 'ListServiceOperationsInput$NextToken' => '<p>Include this value, if it was returned by the previous operation, to get the next set of service operations.</p>', 'ListServiceOperationsOutput$NextToken' => '<p>Include this value in your next use of this API to get next set of service operations.</p>', 'ListServicesInput$NextToken' => '<p>Include this value, if it was returned by the previous operation, to get the next set of services.</p>', 'ListServicesOutput$NextToken' => '<p>Include this value in your next use of this API to get next set of services.</p>', ], ], 'OperationName' => [ 'base' => NULL, 'refs' => [ 'ListServiceLevelObjectivesInput$OperationName' => '<p>The name of the operation that this SLO is associated with.</p>', 'ServiceDependency$OperationName' => '<p>The name of the operation in this service that calls the dependency.</p>', 'ServiceDependency$DependencyOperationName' => '<p>The name of the called operation in the dependency.</p>', 'ServiceDependent$OperationName' => '<p>If the invoked entity is an operation on an entity, the name of that dependent operation is displayed here.</p>', 'ServiceDependent$DependentOperationName' => '<p>If the dependent invoker was a service that invoked it from an operation, the name of that dependent operation is displayed here.</p>', 'ServiceLevelIndicatorMetric$OperationName' => '<p>If the SLO monitors a specific operation of the service, this field displays that operation name.</p>', 'ServiceLevelIndicatorMetricConfig$OperationName' => '<p>If the SLO is to monitor a specific operation of the service, use this field to specify the name of that operation.</p>', 'ServiceLevelObjectiveSummary$OperationName' => '<p>If this service level objective is specific to a single operation, this field displays the name of that operation.</p>', 'ServiceOperation$Name' => '<p>The name of the operation, discovered by Application Signals.</p>', ], ], 'Period' => [ 'base' => NULL, 'refs' => [ 'MetricDataQuery$Period' => '<p>The granularity, in seconds, of the returned data points for this metric. For metrics with regular resolution, a period can be as short as one minute (60 seconds) and must be a multiple of 60. For high-resolution metrics that are collected at intervals of less than one minute, the period can be 1, 5, 10, 30, 60, or any multiple of 60. High-resolution metrics are those metrics stored by a <code>PutMetricData</code> call that includes a <code>StorageResolution</code> of 1 second.</p> <p>If the <code>StartTime</code> parameter specifies a time stamp that is greater than 3 hours ago, you must specify the period as follows or no data points in that time range is returned:</p> <ul> <li> <p>Start time between 3 hours and 15 days ago - Use a multiple of 60 seconds (1 minute).</p> </li> <li> <p>Start time between 15 and 63 days ago - Use a multiple of 300 seconds (5 minutes).</p> </li> <li> <p>Start time greater than 63 days ago - Use a multiple of 3600 seconds (1 hour).</p> </li> </ul>', 'MetricStat$Period' => '<p>The granularity, in seconds, to be used for the metric. For metrics with regular resolution, a period can be as short as one minute (60 seconds) and must be a multiple of 60. For high-resolution metrics that are collected at intervals of less than one minute, the period can be 1, 5, 10, 30, 60, or any multiple of 60. High-resolution metrics are those metrics stored by a <code>PutMetricData</code> call that includes a <code>StorageResolution</code> of 1 second.</p>', ], ], 'ResourceId' => [ 'base' => NULL, 'refs' => [ 'ResourceNotFoundException$ResourceId' => '<p>Cannot find the resource id.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>Resource not found.</p>', 'refs' => [], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'ResourceNotFoundException$ResourceType' => '<p>The resource type is not valid.</p>', ], ], 'ReturnData' => [ 'base' => NULL, 'refs' => [ 'MetricDataQuery$ReturnData' => '<p>Use this only if you are using a metric math expression for the SLO. Specify <code>true</code> for <code>ReturnData</code> for only the one expression result to use as the alarm. For all other metrics and expressions in the same <code>CreateServiceLevelObjective</code> operation, specify <code>ReturnData</code> as <code>false</code>.</p>', ], ], 'RollingInterval' => [ 'base' => '<p>If the interval for this SLO is a rolling interval, this structure contains the interval specifications.</p>', 'refs' => [ 'Interval$RollingInterval' => '<p>If the interval is a rolling interval, this structure contains the interval specifications.</p>', ], ], 'RollingIntervalDuration' => [ 'base' => NULL, 'refs' => [ 'RollingInterval$Duration' => '<p>Specifies the duration of each rolling interval. For example, if <code>Duration</code> is <code>7</code> and <code>DurationUnit</code> is <code>DAY</code>, each rolling interval is seven days.</p>', ], ], 'SLIPeriodSeconds' => [ 'base' => NULL, 'refs' => [ 'ServiceLevelIndicatorMetricConfig$PeriodSeconds' => '<p>The number of seconds to use as the period for SLO evaluation. Your application\'s performance is compared to the SLI during each period. For each period, the application is determined to have either achieved or not achieved the necessary performance.</p>', ], ], 'Service' => [ 'base' => '<p>This structure contains information about one of your services that was discovered by Application Signals. </p>', 'refs' => [ 'GetServiceOutput$Service' => '<p>A structure containing information about the service.</p>', ], ], 'ServiceDependencies' => [ 'base' => NULL, 'refs' => [ 'ListServiceDependenciesOutput$ServiceDependencies' => '<p>An array, where each object in the array contains information about one of the dependencies of this service.</p>', ], ], 'ServiceDependency' => [ 'base' => '<p>This structure contains information about one dependency of this service.</p>', 'refs' => [ 'ServiceDependencies$member' => NULL, ], ], 'ServiceDependent' => [ 'base' => '<p>This structure contains information about a service dependent that was discovered by Application Signals. A dependent is an entity that invoked the specified service during the provided time range. Dependents include other services, CloudWatch Synthetics canaries, and clients that are instrumented with CloudWatch RUM app monitors.</p>', 'refs' => [ 'ServiceDependents$member' => NULL, ], ], 'ServiceDependents' => [ 'base' => NULL, 'refs' => [ 'ListServiceDependentsOutput$ServiceDependents' => '<p>An array, where each object in the array contains information about one of the dependents of this service.</p>', ], ], 'ServiceErrorMessage' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => NULL, ], ], 'ServiceLevelIndicator' => [ 'base' => '<p>This structure contains information about the performance metric that an SLO monitors.</p>', 'refs' => [ 'ServiceLevelObjective$Sli' => '<p>A structure containing information about the performance metric that this SLO monitors.</p>', 'ServiceLevelObjectiveBudgetReport$Sli' => '<p>A structure that contains information about the performance metric that this SLO monitors.</p>', ], ], 'ServiceLevelIndicatorComparisonOperator' => [ 'base' => NULL, 'refs' => [ 'ServiceLevelIndicator$ComparisonOperator' => '<p>The arithmetic operation used when comparing the specified metric to the threshold.</p>', 'ServiceLevelIndicatorConfig$ComparisonOperator' => '<p>The arithmetic operation to use when comparing the specified metric to the threshold.</p>', ], ], 'ServiceLevelIndicatorConfig' => [ 'base' => '<p>This structure specifies the information about the service and the performance metric that an SLO is to monitor.</p>', 'refs' => [ 'CreateServiceLevelObjectiveInput$SliConfig' => '<p>A structure that contains information about what service and what performance metric that this SLO will monitor.</p>', 'UpdateServiceLevelObjectiveInput$SliConfig' => '<p>A structure that contains information about what performance metric this SLO will monitor.</p>', ], ], 'ServiceLevelIndicatorMetric' => [ 'base' => '<p>This structure contains the information about the metric that is used for the SLO.</p>', 'refs' => [ 'ServiceLevelIndicator$SliMetric' => '<p>A structure that contains information about the metric that the SLO monitors. </p>', ], ], 'ServiceLevelIndicatorMetricConfig' => [ 'base' => '<p>Use this structure to specify the information for the metric that the SLO will monitor.</p>', 'refs' => [ 'ServiceLevelIndicatorConfig$SliMetricConfig' => '<p>Use this structure to specify the metric to be used for the SLO.</p>', ], ], 'ServiceLevelIndicatorMetricThreshold' => [ 'base' => NULL, 'refs' => [ 'ServiceLevelIndicator$MetricThreshold' => '<p>The value that the SLI metric is compared to.</p>', 'ServiceLevelIndicatorConfig$MetricThreshold' => '<p>The value that the SLI metric is compared to.</p>', ], ], 'ServiceLevelIndicatorMetricType' => [ 'base' => NULL, 'refs' => [ 'ServiceLevelIndicatorMetric$MetricType' => '<p>If the SLO monitors either the <code>LATENCY</code> or <code>AVAILABILITY</code> metric that Application Signals collects, this field displays which of those metrics is used.</p>', 'ServiceLevelIndicatorMetricConfig$MetricType' => '<p>If the SLO is to monitor either the <code>LATENCY</code> or <code>AVAILABILITY</code> metric that Application Signals collects, use this field to specify which of those metrics is used.</p>', ], ], 'ServiceLevelIndicatorStatistic' => [ 'base' => NULL, 'refs' => [ 'ServiceLevelIndicatorMetricConfig$Statistic' => '<p>The statistic to use for comparison to the threshold. It can be any CloudWatch statistic or extended statistic. For more information about statistics, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html">CloudWatch statistics definitions</a>.</p>', ], ], 'ServiceLevelObjective' => [ 'base' => '<p>A structure containing information about one service level objective (SLO) that has been created in Application Signals. Creating SLOs can help you ensure your services are performing to the level that you expect. SLOs help you set and track a specific target level for the reliability and availability of your applications and services. Each SLO uses a service level indicator (SLI), which is a key performance metric, to calculate how much underperformance can be tolerated before the goal that you set for the SLO is not achieved.</p>', 'refs' => [ 'CreateServiceLevelObjectiveOutput$Slo' => '<p>A structure that contains information about the SLO that you just created.</p>', 'GetServiceLevelObjectiveOutput$Slo' => '<p>A structure containing the information about the SLO.</p>', 'UpdateServiceLevelObjectiveOutput$Slo' => '<p>A structure that contains information about the SLO that you just updated.</p>', ], ], 'ServiceLevelObjectiveArn' => [ 'base' => NULL, 'refs' => [ 'ServiceLevelObjective$Arn' => '<p>The ARN of this SLO.</p>', 'ServiceLevelObjectiveBudgetReport$Arn' => '<p>The ARN of the SLO that this report is for.</p>', 'ServiceLevelObjectiveBudgetReportError$Arn' => '<p>The ARN of the SLO that this error is related to.</p>', 'ServiceLevelObjectiveSummary$Arn' => '<p>The ARN of this service level objective.</p>', ], ], 'ServiceLevelObjectiveBudgetReport' => [ 'base' => '<p>A structure containing an SLO budget report that you have requested.</p>', 'refs' => [ 'ServiceLevelObjectiveBudgetReports$member' => NULL, ], ], 'ServiceLevelObjectiveBudgetReportError' => [ 'base' => '<p>A structure containing information about one error that occurred during a <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_BatchGetServiceLevelObjectiveBudgetReport.html">BatchGetServiceLevelObjectiveBudgetReport</a> operation.</p>', 'refs' => [ 'ServiceLevelObjectiveBudgetReportErrors$member' => NULL, ], ], 'ServiceLevelObjectiveBudgetReportErrorCode' => [ 'base' => NULL, 'refs' => [ 'ServiceLevelObjectiveBudgetReportError$ErrorCode' => '<p>The error code for this error.</p>', ], ], 'ServiceLevelObjectiveBudgetReportErrorMessage' => [ 'base' => NULL, 'refs' => [ 'ServiceLevelObjectiveBudgetReportError$ErrorMessage' => '<p>The message for this error.</p>', ], ], 'ServiceLevelObjectiveBudgetReportErrors' => [ 'base' => NULL, 'refs' => [ 'BatchGetServiceLevelObjectiveBudgetReportOutput$Errors' => '<p>An array of structures, where each structure includes an error indicating that one of the requests in the array was not valid.</p>', ], ], 'ServiceLevelObjectiveBudgetReports' => [ 'base' => NULL, 'refs' => [ 'BatchGetServiceLevelObjectiveBudgetReportOutput$Reports' => '<p>An array of structures, where each structure is one budget report.</p>', ], ], 'ServiceLevelObjectiveBudgetStatus' => [ 'base' => NULL, 'refs' => [ 'ServiceLevelObjectiveBudgetReport$BudgetStatus' => '<p>The status of this SLO, as it relates to the error budget for the entire time interval.</p> <ul> <li> <p> <code>OK</code> means that the SLO had remaining budget above the warning threshold, as of the time that you specified in <code>TimeStamp</code>.</p> </li> <li> <p> <code>WARNING</code> means that the SLO\'s remaining budget was below the warning threshold, as of the time that you specified in <code>TimeStamp</code>.</p> </li> <li> <p> <code>BREACHED</code> means that the SLO\'s budget was exhausted, as of the time that you specified in <code>TimeStamp</code>.</p> </li> <li> <p> <code>INSUFFICIENT_DATA</code> means that the specifed start and end times were before the SLO was created, or that attainment data is missing.</p> </li> </ul>', ], ], 'ServiceLevelObjectiveDescription' => [ 'base' => NULL, 'refs' => [ 'CreateServiceLevelObjectiveInput$Description' => '<p>An optional description for this SLO.</p>', 'ServiceLevelObjective$Description' => '<p>The description that you created for this SLO.</p>', 'UpdateServiceLevelObjectiveInput$Description' => '<p>An optional description for the SLO.</p>', ], ], 'ServiceLevelObjectiveId' => [ 'base' => NULL, 'refs' => [ 'DeleteServiceLevelObjectiveInput$Id' => '<p>The ARN or name of the service level objective to delete.</p>', 'GetServiceLevelObjectiveInput$Id' => '<p>The ARN or name of the SLO that you want to retrieve information about. You can find the ARNs of SLOs by using the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_ListServiceLevelObjectives.html">ListServiceLevelObjectives</a> operation.</p>', 'UpdateServiceLevelObjectiveInput$Id' => '<p>The Amazon Resource Name (ARN) or name of the service level objective that you want to update.</p>', ], ], 'ServiceLevelObjectiveIds' => [ 'base' => NULL, 'refs' => [ 'BatchGetServiceLevelObjectiveBudgetReportInput$SloIds' => '<p>An array containing the IDs of the service level objectives that you want to include in the report.</p>', ], ], 'ServiceLevelObjectiveName' => [ 'base' => NULL, 'refs' => [ 'CreateServiceLevelObjectiveInput$Name' => '<p>A name for this SLO.</p>', 'ServiceLevelObjective$Name' => '<p>The name of this SLO.</p>', 'ServiceLevelObjectiveBudgetReport$Name' => '<p>The name of the SLO that this report is for.</p>', 'ServiceLevelObjectiveBudgetReportError$Name' => '<p>The name of the SLO that this error is related to.</p>', 'ServiceLevelObjectiveSummary$Name' => '<p>The name of the service level objective.</p>', ], ], 'ServiceLevelObjectiveSummaries' => [ 'base' => NULL, 'refs' => [ 'ListServiceLevelObjectivesOutput$SloSummaries' => '<p>An array of structures, where each structure contains information about one SLO.</p>', ], ], 'ServiceLevelObjectiveSummary' => [ 'base' => '<p>A structure that contains information about one service level objective (SLO) created in Application Signals.</p>', 'refs' => [ 'ServiceLevelObjectiveSummaries$member' => NULL, ], ], 'ServiceOperation' => [ 'base' => '<p>This structure contains information about an operation discovered by Application Signals. An operation is a specific function performed by a service that was discovered by Application Signals, and is often an API that is called by an upstream dependent. </p>', 'refs' => [ 'ServiceOperations$member' => NULL, ], ], 'ServiceOperations' => [ 'base' => NULL, 'refs' => [ 'ListServiceOperationsOutput$ServiceOperations' => '<p>An array of structures that each contain information about one operation of this service.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>This request exceeds a service quota.</p>', 'refs' => [], ], 'ServiceSummaries' => [ 'base' => NULL, 'refs' => [ 'ListServicesOutput$ServiceSummaries' => '<p>An array of structures, where each structure contains some information about a service. To get complete information about a service, use <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetService.html">GetService</a>.</p>', ], ], 'ServiceSummary' => [ 'base' => '<p>This structure contains information about one of your services that was discoverd by Application Signals</p>', 'refs' => [ 'ServiceSummaries$member' => NULL, ], ], 'StandardUnit' => [ 'base' => NULL, 'refs' => [ 'MetricStat$Unit' => '<p>If you omit <code>Unit</code> then all data that was collected with any unit is returned, along with the corresponding units that were specified when the data was reported to CloudWatch. If you specify a unit, the operation returns only data that was collected with that unit specified. If you specify a unit that does not match the data collected, the results of the operation are null. CloudWatch does not perform unit conversions.</p>', ], ], 'StartDiscoveryInput' => [ 'base' => NULL, 'refs' => [], ], 'StartDiscoveryOutput' => [ 'base' => NULL, 'refs' => [], ], 'Stat' => [ 'base' => NULL, 'refs' => [ 'MetricStat$Stat' => '<p>The statistic to use for comparison to the threshold. It can be any CloudWatch statistic or extended statistic. For more information about statistics, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html">CloudWatch statistics definitions</a>.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AttributeMap$key' => NULL, 'AttributeMap$value' => NULL, 'ConflictException$Message' => NULL, 'ServiceLevelObjectiveIds$member' => NULL, 'ServiceQuotaExceededException$Message' => NULL, 'ThrottlingException$Message' => NULL, ], ], 'Tag' => [ 'base' => '<p>A key-value pair associated with a resource. Tags can help you organize and categorize your resources.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>A string that you can use to assign a value. The combination of tag keys and values can help you organize and categorize your resources.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>The list of tag keys to remove from the resource.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateServiceLevelObjectiveInput$Tags' => '<p>A list of key-value pairs to associate with the SLO. You can associate as many as 50 tags with an SLO. To be able to associate tags with the SLO when you create the SLO, you must have the <code>cloudwatch:TagResource</code> permission.</p> <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.</p>', 'ListTagsForResourceResponse$Tags' => '<p>The list of tag keys and values associated with the resource you specified.</p>', 'TagResourceRequest$Tags' => '<p>The list of key-value pairs to associate with the alarm.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The value for the specified tag key.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The request was throttled because of quota limits.</p>', 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'BatchGetServiceLevelObjectiveBudgetReportInput$Timestamp' => '<p>The date and time that you want the report to be for. It is expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.</p>', 'BatchGetServiceLevelObjectiveBudgetReportOutput$Timestamp' => '<p>The date and time that the report is for. It is expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.</p>', 'CalendarInterval$StartTime' => '<p>The date and time when you want the first interval to start. Be sure to choose a time that configures the intervals the way that you want. For example, if you want weekly intervals starting on Mondays at 6 a.m., be sure to specify a start time that is a Monday at 6 a.m.</p> <p>When used in a raw HTTP Query API, it is formatted as be epoch time in seconds. For example: <code>1698778057</code> </p> <p>As soon as one calendar interval ends, another automatically begins.</p>', 'GetServiceInput$StartTime' => '<p>The start of the time period to retrieve information about. When used in a raw HTTP Query API, it is formatted as be epoch time in seconds. For example: <code>1698778057</code> </p>', 'GetServiceInput$EndTime' => '<p>The end of the time period to retrieve information about. When used in a raw HTTP Query API, it is formatted as be epoch time in seconds. For example: <code>1698778057</code> </p>', 'GetServiceOutput$StartTime' => '<p>The start time of the data included in the response. In a raw HTTP Query API, it is formatted as be epoch time in seconds. For example: <code>1698778057</code>.</p>', 'GetServiceOutput$EndTime' => '<p>The end time of the data included in the response. In a raw HTTP Query API, it is formatted as be epoch time in seconds. For example: <code>1698778057</code>.</p>', 'ListServiceDependenciesInput$StartTime' => '<p>The start of the time period to retrieve information about. When used in a raw HTTP Query API, it is formatted as be epoch time in seconds. For example: <code>1698778057</code> </p>', 'ListServiceDependenciesInput$EndTime' => '<p>The end of the time period to retrieve information about. When used in a raw HTTP Query API, it is formatted as be epoch time in seconds. For example: <code>1698778057</code> </p>', 'ListServiceDependenciesOutput$StartTime' => '<p>The start of the time period that the returned information applies to. When used in a raw HTTP Query API, it is formatted as be epoch time in seconds. For example: <code>1698778057</code> </p>', 'ListServiceDependenciesOutput$EndTime' => '<p>The end of the time period that the returned information applies to. When used in a raw HTTP Query API, it is formatted as be epoch time in seconds. For example: <code>1698778057</code> </p>', 'ListServiceDependentsInput$StartTime' => '<p>The start of the time period to retrieve information about. When used in a raw HTTP Query API, it is formatted as be epoch time in seconds. For example: <code>1698778057</code> </p>', 'ListServiceDependentsInput$EndTime' => '<p>The end of the time period to retrieve information about. When used in a raw HTTP Query API, it is formatted as be epoch time in seconds. For example: <code>1698778057</code> </p>', 'ListServiceDependentsOutput$StartTime' => '<p>The start of the time period that the returned information applies to. When used in a raw HTTP Query API, it is formatted as be epoch time in seconds. For example: <code>1698778057</code> </p>', 'ListServiceDependentsOutput$EndTime' => '<p>The end of the time period that the returned information applies to. When used in a raw HTTP Query API, it is formatted as be epoch time in seconds. For example: <code>1698778057</code> </p>', 'ListServiceOperationsInput$StartTime' => '<p>The start of the time period to retrieve information about. When used in a raw HTTP Query API, it is formatted as be epoch time in seconds. For example: <code>1698778057</code> </p>', 'ListServiceOperationsInput$EndTime' => '<p>The end of the time period to retrieve information about. When used in a raw HTTP Query API, it is formatted as be epoch time in seconds. For example: <code>1698778057</code> </p>', 'ListServiceOperationsOutput$StartTime' => '<p>The start of the time period that the returned information applies to. When used in a raw HTTP Query API, it is formatted as be epoch time in seconds. For example: <code>1698778057</code> </p>', 'ListServiceOperationsOutput$EndTime' => '<p>The end of the time period that the returned information applies to. When used in a raw HTTP Query API, it is formatted as be epoch time in seconds. For example: <code>1698778057</code> </p>', 'ListServicesInput$StartTime' => '<p>The start of the time period to retrieve information about. When used in a raw HTTP Query API, it is formatted as be epoch time in seconds. For example: <code>1698778057</code> </p>', 'ListServicesInput$EndTime' => '<p>The end of the time period to retrieve information about. When used in a raw HTTP Query API, it is formatted as be epoch time in seconds. For example: <code>1698778057</code> </p>', 'ListServicesOutput$StartTime' => '<p>The start of the time period that the returned information applies to. When used in a raw HTTP Query API, it is formatted as be epoch time in seconds. For example: <code>1698778057</code> </p>', 'ListServicesOutput$EndTime' => '<p>The end of the time period that the returned information applies to. When used in a raw HTTP Query API, it is formatted as be epoch time in seconds. For example: <code>1698778057</code> </p>', 'ServiceLevelObjective$CreatedTime' => '<p>The date and time that this SLO was created. When used in a raw HTTP Query API, it is formatted as <code>yyyy-MM-dd\'T\'HH:mm:ss</code>. For example, <code>2019-07-01T23:59:59</code>.</p>', 'ServiceLevelObjective$LastUpdatedTime' => '<p>The time that this SLO was most recently updated. When used in a raw HTTP Query API, it is formatted as <code>yyyy-MM-dd\'T\'HH:mm:ss</code>. For example, <code>2019-07-01T23:59:59</code>.</p>', 'ServiceLevelObjectiveSummary$CreatedTime' => '<p>The date and time that this service level objective was created. It is expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.</p>', ], ], 'TotalBudgetSeconds' => [ 'base' => NULL, 'refs' => [ 'ServiceLevelObjectiveBudgetReport$TotalBudgetSeconds' => '<p>The total number of seconds in the error budget for the interval.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateServiceLevelObjectiveInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateServiceLevelObjectiveOutput' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>The resource is not valid.</p>', 'refs' => [], ], 'ValidationExceptionMessage' => [ 'base' => NULL, 'refs' => [ 'ValidationException$message' => NULL, ], ], 'WarningThreshold' => [ 'base' => NULL, 'refs' => [ 'Goal$WarningThreshold' => '<p>The percentage of remaining budget over total budget that you want to get warnings for. If you omit this parameter, the default of 50.0 is used. </p>', ], ], ],];
