<?php
// This file was auto-generated from sdk-root/src/data/chime-sdk-voice/2022-08-03/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>The Amazon Chime SDK telephony APIs in this section enable developers to create PSTN calling solutions that use Amazon Chime SDK Voice Connectors, and Amazon Chime SDK SIP media applications. Developers can also order and manage phone numbers, create and manage Voice Connectors and SIP media applications, and run voice analytics.</p>', 'operations' => [ 'AssociatePhoneNumbersWithVoiceConnector' => '<p>Associates phone numbers with the specified Amazon Chime SDK Voice Connector.</p>', 'AssociatePhoneNumbersWithVoiceConnectorGroup' => '<p>Associates phone numbers with the specified Amazon Chime SDK Voice Connector group.</p>', 'BatchDeletePhoneNumber' => '<p> Moves phone numbers into the <b>Deletion queue</b>. Phone numbers must be disassociated from any users or Amazon Chime SDK Voice Connectors before they can be deleted. </p> <p> Phone numbers remain in the <b>Deletion queue</b> for 7 days before they are deleted permanently. </p>', 'BatchUpdatePhoneNumber' => '<p>Updates phone number product types, calling names, or phone number names. You can update one attribute at a time for each <code>UpdatePhoneNumberRequestItem</code>. For example, you can update the product type, the calling name, or phone name. </p> <note> <p>You cannot have a duplicate <code>phoneNumberId</code> in a request.</p> </note>', 'CreatePhoneNumberOrder' => '<p>Creates an order for phone numbers to be provisioned. For numbers outside the U.S., you must use the Amazon Chime SDK SIP media application dial-in product type.</p>', 'CreateProxySession' => '<p>Creates a proxy session for the specified Amazon Chime SDK Voice Connector for the specified participant phone numbers.</p>', 'CreateSipMediaApplication' => '<p>Creates a SIP media application. For more information about SIP media applications, see <a href="https://docs.aws.amazon.com/chime-sdk/latest/ag/manage-sip-applications.html">Managing SIP media applications and rules</a> in the <i>Amazon Chime SDK Administrator Guide</i>.</p>', 'CreateSipMediaApplicationCall' => '<p>Creates an outbound call to a phone number from the phone number specified in the request, and it invokes the endpoint of the specified <code>sipMediaApplicationId</code>.</p>', 'CreateSipRule' => '<p>Creates a SIP rule, which can be used to run a SIP media application as a target for a specific trigger type. For more information about SIP rules, see <a href="https://docs.aws.amazon.com/chime-sdk/latest/ag/manage-sip-applications.html">Managing SIP media applications and rules</a> in the <i>Amazon Chime SDK Administrator Guide</i>.</p>', 'CreateVoiceConnector' => '<p>Creates an Amazon Chime SDK Voice Connector. For more information about Voice Connectors, see <a href="https://docs.aws.amazon.com/chime-sdk/latest/ag/voice-connector-groups.html">Managing Amazon Chime SDK Voice Connector groups</a> in the <i>Amazon Chime SDK Administrator Guide</i>.</p>', 'CreateVoiceConnectorGroup' => '<p>Creates an Amazon Chime SDK Voice Connector group under the administrator\'s AWS account. You can associate Amazon Chime SDK Voice Connectors with the Voice Connector group by including <code>VoiceConnectorItems</code> in the request. </p> <p>You can include Voice Connectors from different AWS Regions in your group. This creates a fault tolerant mechanism for fallback in case of availability events.</p>', 'CreateVoiceProfile' => '<p>Creates a voice profile, which consists of an enrolled user and their latest voice print.</p> <important> <p>Before creating any voice profiles, you must provide all notices and obtain all consents from the speaker as required under applicable privacy and biometrics laws, and as required under the <a href="https://aws.amazon.com/service-terms/">AWS service terms</a> for the Amazon Chime SDK.</p> </important> <p>For more information about voice profiles and voice analytics, see <a href="https://docs.aws.amazon.com/chime-sdk/latest/dg/pstn-voice-analytics.html">Using Amazon Chime SDK Voice Analytics</a> in the <i>Amazon Chime SDK Developer Guide</i>.</p>', 'CreateVoiceProfileDomain' => '<p>Creates a voice profile domain, a collection of voice profiles, their voice prints, and encrypted enrollment audio.</p> <important> <p>Before creating any voice profiles, you must provide all notices and obtain all consents from the speaker as required under applicable privacy and biometrics laws, and as required under the <a href="https://aws.amazon.com/service-terms/">AWS service terms</a> for the Amazon Chime SDK.</p> </important> <p>For more information about voice profile domains, see <a href="https://docs.aws.amazon.com/chime-sdk/latest/dg/pstn-voice-analytics.html">Using Amazon Chime SDK Voice Analytics</a> in the <i>Amazon Chime SDK Developer Guide</i>.</p>', 'DeletePhoneNumber' => '<p>Moves the specified phone number into the <b>Deletion queue</b>. A phone number must be disassociated from any users or Amazon Chime SDK Voice Connectors before it can be deleted.</p> <p>Deleted phone numbers remain in the <b>Deletion queue</b> queue for 7 days before they are deleted permanently.</p>', 'DeleteProxySession' => '<p>Deletes the specified proxy session from the specified Amazon Chime SDK Voice Connector.</p>', 'DeleteSipMediaApplication' => '<p>Deletes a SIP media application.</p>', 'DeleteSipRule' => '<p>Deletes a SIP rule.</p>', 'DeleteVoiceConnector' => '<p>Deletes an Amazon Chime SDK Voice Connector. Any phone numbers associated with the Amazon Chime SDK Voice Connector must be disassociated from it before it can be deleted.</p>', 'DeleteVoiceConnectorEmergencyCallingConfiguration' => '<p>Deletes the emergency calling details from the specified Amazon Chime SDK Voice Connector.</p>', 'DeleteVoiceConnectorGroup' => '<p>Deletes an Amazon Chime SDK Voice Connector group. Any <code>VoiceConnectorItems</code> and phone numbers associated with the group must be removed before it can be deleted.</p>', 'DeleteVoiceConnectorOrigination' => '<p>Deletes the origination settings for the specified Amazon Chime SDK Voice Connector. </p> <note> <p>If emergency calling is configured for the Voice Connector, it must be deleted prior to deleting the origination settings.</p> </note>', 'DeleteVoiceConnectorProxy' => '<p>Deletes the proxy configuration from the specified Amazon Chime SDK Voice Connector.</p>', 'DeleteVoiceConnectorStreamingConfiguration' => '<p>Deletes a Voice Connector\'s streaming configuration.</p>', 'DeleteVoiceConnectorTermination' => '<p>Deletes the termination settings for the specified Amazon Chime SDK Voice Connector.</p> <note> <p>If emergency calling is configured for the Voice Connector, it must be deleted prior to deleting the termination settings.</p> </note>', 'DeleteVoiceConnectorTerminationCredentials' => '<p>Deletes the specified SIP credentials used by your equipment to authenticate during call termination.</p>', 'DeleteVoiceProfile' => '<p>Deletes a voice profile, including its voice print and enrollment data. WARNING: This action is not reversible.</p>', 'DeleteVoiceProfileDomain' => '<p>Deletes all voice profiles in the domain. WARNING: This action is not reversible.</p>', 'DisassociatePhoneNumbersFromVoiceConnector' => '<p>Disassociates the specified phone numbers from the specified Amazon Chime SDK Voice Connector.</p>', 'DisassociatePhoneNumbersFromVoiceConnectorGroup' => '<p>Disassociates the specified phone numbers from the specified Amazon Chime SDK Voice Connector group.</p>', 'GetGlobalSettings' => '<p>Retrieves the global settings for the Amazon Chime SDK Voice Connectors in an AWS account.</p>', 'GetPhoneNumber' => '<p>Retrieves details for the specified phone number ID, such as associations, capabilities, and product type.</p>', 'GetPhoneNumberOrder' => '<p>Retrieves details for the specified phone number order, such as the order creation timestamp, phone numbers in E.164 format, product type, and order status.</p>', 'GetPhoneNumberSettings' => '<p>Retrieves the phone number settings for the administrator\'s AWS account, such as the default outbound calling name.</p>', 'GetProxySession' => '<p>Retrieves the specified proxy session details for the specified Amazon Chime SDK Voice Connector.</p>', 'GetSipMediaApplication' => '<p>Retrieves the information for a SIP media application, including name, AWS Region, and endpoints.</p>', 'GetSipMediaApplicationAlexaSkillConfiguration' => '<p>Gets the Alexa Skill configuration for the SIP media application.</p> <important> <p>Due to changes made by the Amazon Alexa service, this API is no longer available for use. For more information, refer to the <a href="https://developer.amazon.com/en-US/alexa/alexasmartproperties">Alexa Smart Properties</a> page.</p> </important>', 'GetSipMediaApplicationLoggingConfiguration' => '<p>Retrieves the logging configuration for the specified SIP media application.</p>', 'GetSipRule' => '<p>Retrieves the details of a SIP rule, such as the rule ID, name, triggers, and target endpoints.</p>', 'GetSpeakerSearchTask' => '<p>Retrieves the details of the specified speaker search task.</p>', 'GetVoiceConnector' => '<p>Retrieves details for the specified Amazon Chime SDK Voice Connector, such as timestamps,name, outbound host, and encryption requirements.</p>', 'GetVoiceConnectorEmergencyCallingConfiguration' => '<p>Retrieves the emergency calling configuration details for the specified Voice Connector.</p>', 'GetVoiceConnectorGroup' => '<p>Retrieves details for the specified Amazon Chime SDK Voice Connector group, such as timestamps,name, and associated <code>VoiceConnectorItems</code>.</p>', 'GetVoiceConnectorLoggingConfiguration' => '<p>Retrieves the logging configuration settings for the specified Voice Connector. Shows whether SIP message logs are enabled for sending to Amazon CloudWatch Logs.</p>', 'GetVoiceConnectorOrigination' => '<p>Retrieves the origination settings for the specified Voice Connector.</p>', 'GetVoiceConnectorProxy' => '<p>Retrieves the proxy configuration details for the specified Amazon Chime SDK Voice Connector.</p>', 'GetVoiceConnectorStreamingConfiguration' => '<p>Retrieves the streaming configuration details for the specified Amazon Chime SDK Voice Connector. Shows whether media streaming is enabled for sending to Amazon Kinesis. It also shows the retention period, in hours, for the Amazon Kinesis data.</p>', 'GetVoiceConnectorTermination' => '<p>Retrieves the termination setting details for the specified Voice Connector.</p>', 'GetVoiceConnectorTerminationHealth' => '<p>Retrieves information about the last time a <code>SIP OPTIONS</code> ping was received from your SIP infrastructure for the specified Amazon Chime SDK Voice Connector.</p>', 'GetVoiceProfile' => '<p>Retrieves the details of the specified voice profile.</p>', 'GetVoiceProfileDomain' => '<p>Retrieves the details of the specified voice profile domain.</p>', 'GetVoiceToneAnalysisTask' => '<p>Retrieves the details of a voice tone analysis task.</p>', 'ListAvailableVoiceConnectorRegions' => '<p>Lists the available AWS Regions in which you can create an Amazon Chime SDK Voice Connector.</p>', 'ListPhoneNumberOrders' => '<p>Lists the phone numbers for an administrator\'s Amazon Chime SDK account.</p>', 'ListPhoneNumbers' => '<p>Lists the phone numbers for the specified Amazon Chime SDK account, Amazon Chime SDK user, Amazon Chime SDK Voice Connector, or Amazon Chime SDK Voice Connector group.</p>', 'ListProxySessions' => '<p>Lists the proxy sessions for the specified Amazon Chime SDK Voice Connector.</p>', 'ListSipMediaApplications' => '<p>Lists the SIP media applications under the administrator\'s AWS account.</p>', 'ListSipRules' => '<p>Lists the SIP rules under the administrator\'s AWS account.</p>', 'ListSupportedPhoneNumberCountries' => '<p>Lists the countries that you can order phone numbers from.</p>', 'ListTagsForResource' => '<p>Returns a list of the tags in a given resource.</p>', 'ListVoiceConnectorGroups' => '<p>Lists the Amazon Chime SDK Voice Connector groups in the administrator\'s AWS account.</p>', 'ListVoiceConnectorTerminationCredentials' => '<p>Lists the SIP credentials for the specified Amazon Chime SDK Voice Connector.</p>', 'ListVoiceConnectors' => '<p>Lists the Amazon Chime SDK Voice Connectors in the administrators AWS account.</p>', 'ListVoiceProfileDomains' => '<p>Lists the specified voice profile domains in the administrator\'s AWS account. </p>', 'ListVoiceProfiles' => '<p>Lists the voice profiles in a voice profile domain.</p>', 'PutSipMediaApplicationAlexaSkillConfiguration' => '<p>Updates the Alexa Skill configuration for the SIP media application.</p> <important> <p>Due to changes made by the Amazon Alexa service, this API is no longer available for use. For more information, refer to the <a href="https://developer.amazon.com/en-US/alexa/alexasmartproperties">Alexa Smart Properties</a> page.</p> </important>', 'PutSipMediaApplicationLoggingConfiguration' => '<p>Updates the logging configuration for the specified SIP media application.</p>', 'PutVoiceConnectorEmergencyCallingConfiguration' => '<p>Updates a Voice Connector\'s emergency calling configuration.</p>', 'PutVoiceConnectorLoggingConfiguration' => '<p>Updates a Voice Connector\'s logging configuration.</p>', 'PutVoiceConnectorOrigination' => '<p>Updates a Voice Connector\'s origination settings.</p>', 'PutVoiceConnectorProxy' => '<p>Puts the specified proxy configuration to the specified Amazon Chime SDK Voice Connector.</p>', 'PutVoiceConnectorStreamingConfiguration' => '<p>Updates a Voice Connector\'s streaming configuration settings.</p>', 'PutVoiceConnectorTermination' => '<p>Updates a Voice Connector\'s termination settings.</p>', 'PutVoiceConnectorTerminationCredentials' => '<p>Updates a Voice Connector\'s termination credentials.</p>', 'RestorePhoneNumber' => '<p>Restores a deleted phone number.</p>', 'SearchAvailablePhoneNumbers' => '<p>Searches the provisioned phone numbers in an organization.</p>', 'StartSpeakerSearchTask' => '<p>Starts a speaker search task.</p> <important> <p>Before starting any speaker search tasks, you must provide all notices and obtain all consents from the speaker as required under applicable privacy and biometrics laws, and as required under the <a href="https://aws.amazon.com/service-terms/">AWS service terms</a> for the Amazon Chime SDK.</p> </important>', 'StartVoiceToneAnalysisTask' => '<p>Starts a voice tone analysis task. For more information about voice tone analysis, see <a href="https://docs.aws.amazon.com/chime-sdk/latest/dg/pstn-voice-analytics.html">Using Amazon Chime SDK voice analytics</a> in the <i>Amazon Chime SDK Developer Guide</i>.</p> <important> <p>Before starting any voice tone analysis tasks, you must provide all notices and obtain all consents from the speaker as required under applicable privacy and biometrics laws, and as required under the <a href="https://aws.amazon.com/service-terms/">AWS service terms</a> for the Amazon Chime SDK.</p> </important>', 'StopSpeakerSearchTask' => '<p>Stops a speaker search task.</p>', 'StopVoiceToneAnalysisTask' => '<p>Stops a voice tone analysis task.</p>', 'TagResource' => '<p>Adds a tag to the specified resource.</p>', 'UntagResource' => '<p>Removes tags from a resource.</p>', 'UpdateGlobalSettings' => '<p>Updates global settings for the Amazon Chime SDK Voice Connectors in an AWS account.</p>', 'UpdatePhoneNumber' => '<p>Updates phone number details, such as product type, calling name, or phone number name for the specified phone number ID. You can update one phone number detail at a time. For example, you can update either the product type, calling name, or phone number name in one action.</p> <p>For numbers outside the U.S., you must use the Amazon Chime SDK SIP Media Application Dial-In product type.</p> <p>Updates to outbound calling names can take 72 hours to complete. Pending updates to outbound calling names must be complete before you can request another update.</p>', 'UpdatePhoneNumberSettings' => '<p>Updates the phone number settings for the administrator\'s AWS account, such as the default outbound calling name. You can update the default outbound calling name once every seven days. Outbound calling names can take up to 72 hours to update.</p>', 'UpdateProxySession' => '<p>Updates the specified proxy session details, such as voice or SMS capabilities.</p>', 'UpdateSipMediaApplication' => '<p>Updates the details of the specified SIP media application.</p>', 'UpdateSipMediaApplicationCall' => '<p>Invokes the AWS Lambda function associated with the SIP media application and transaction ID in an update request. The Lambda function can then return a new set of actions.</p>', 'UpdateSipRule' => '<p>Updates the details of the specified SIP rule.</p>', 'UpdateVoiceConnector' => '<p>Updates the details for the specified Amazon Chime SDK Voice Connector.</p>', 'UpdateVoiceConnectorGroup' => '<p>Updates the settings for the specified Amazon Chime SDK Voice Connector group.</p>', 'UpdateVoiceProfile' => '<p>Updates the specified voice profile’s voice print and refreshes its expiration timestamp.</p> <important> <p>As a condition of using this feature, you acknowledge that the collection, use, storage, and retention of your caller’s biometric identifiers and biometric information (“biometric data”) in the form of a digital voiceprint requires the caller’s informed consent via a written release. Such consent is required under various state laws, including biometrics laws in Illinois, Texas, Washington and other state privacy laws.</p> <p>You must provide a written release to each caller through a process that clearly reflects each caller’s informed consent before using Amazon Chime SDK Voice Insights service, as required under the terms of your agreement with AWS governing your use of the service.</p> </important>', 'UpdateVoiceProfileDomain' => '<p>Updates the settings for the specified voice profile domain.</p>', 'ValidateE911Address' => '<p>Validates an address to be used for 911 calls made with Amazon Chime SDK Voice Connectors. You can use validated addresses in a Presence Information Data Format Location Object file that you include in SIP requests. That helps ensure that addresses are routed to the appropriate Public Safety Answering Point.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You don\'t have the permissions needed to run this action.</p>', 'refs' => [], ], 'Address' => [ 'base' => '<p>A validated address.</p>', 'refs' => [ 'ValidateE911AddressResponse$Address' => '<p>The validated address.</p>', ], ], 'AlexaSkillId' => [ 'base' => NULL, 'refs' => [ 'AlexaSkillIdList$member' => NULL, ], ], 'AlexaSkillIdList' => [ 'base' => NULL, 'refs' => [ 'SipMediaApplicationAlexaSkillConfiguration$AlexaSkillIds' => '<p>The ID of the Alexa Skill configuration.</p>', ], ], 'AlexaSkillStatus' => [ 'base' => NULL, 'refs' => [ 'SipMediaApplicationAlexaSkillConfiguration$AlexaSkillStatus' => '<p>The status of the Alexa Skill configuration.</p>', ], ], 'Alpha2CountryCode' => [ 'base' => NULL, 'refs' => [ 'DNISEmergencyCallingConfiguration$CallingCountry' => '<p>The country from which emergency calls are allowed, in ISO 3166-1 alpha-2 format.</p>', 'PhoneNumber$Country' => '<p>The phone number\'s country. Format: ISO 3166-1 alpha-2.</p>', 'PhoneNumberCountry$CountryCode' => '<p>The phone number country code. Format: ISO 3166-1 alpha-2.</p>', 'SearchAvailablePhoneNumbersRequest$Country' => '<p>Confines a search to just the phone numbers associated with the specified country.</p>', ], ], 'AreaCode' => [ 'base' => NULL, 'refs' => [ 'GeoMatchParams$AreaCode' => '<p>The area code.</p>', ], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$ResourceARN' => '<p>The resource ARN.</p>', 'MediaInsightsConfiguration$ConfigurationArn' => '<p>The configuration\'s ARN.</p>', 'ServerSideEncryptionConfiguration$KmsKeyArn' => '<p>The ARN of the KMS key used to encrypt the enrollment data in a voice profile domain. Asymmetric customer managed keys are not supported.</p>', 'TagResourceRequest$ResourceARN' => '<p>The ARN of the resource being tagged. </p>', 'UntagResourceRequest$ResourceARN' => '<p>The ARN of the resource having its tags removed.</p>', 'VoiceProfile$VoiceProfileArn' => '<p>The ARN of the voice profile.</p>', 'VoiceProfileDomain$VoiceProfileDomainArn' => '<p>The voice profile domain\'s Amazon Resource Number (ARN).</p>', 'VoiceProfileDomainSummary$VoiceProfileDomainArn' => '<p>The ARN of a voice profile in a voice profile domain summary.</p>', 'VoiceProfileSummary$VoiceProfileArn' => '<p>The ARN of the voice profile in a voice profile summary.</p>', ], ], 'AssociatePhoneNumbersWithVoiceConnectorGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociatePhoneNumbersWithVoiceConnectorGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociatePhoneNumbersWithVoiceConnectorRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociatePhoneNumbersWithVoiceConnectorResponse' => [ 'base' => NULL, 'refs' => [], ], 'BadRequestException' => [ 'base' => '<p>The input parameters don\'t match the service\'s restrictions.</p>', 'refs' => [], ], 'BatchDeletePhoneNumberRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchDeletePhoneNumberResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchUpdatePhoneNumberRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchUpdatePhoneNumberResponse' => [ 'base' => NULL, 'refs' => [], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'CallDetails$IsCaller' => '<p>Identifies a person as the caller or the callee.</p>', 'CreateVoiceConnectorRequest$RequireEncryption' => '<p>Enables or disables encryption for the Voice Connector.</p>', 'GetVoiceToneAnalysisTaskRequest$IsCaller' => '<p>Specifies whether the voice being analyzed is the caller (originator) or the callee (responder).</p>', 'LoggingConfiguration$EnableSIPLogs' => '<p>Boolean that enables sending SIP message logs to Amazon CloudWatch.</p>', 'LoggingConfiguration$EnableMediaMetricLogs' => '<p>Enables or disables media metrics logging.</p>', 'MediaInsightsConfiguration$Disabled' => '<p>Denotes the configration as enabled or disabled.</p>', 'Origination$Disabled' => '<p>When origination settings are disabled, inbound calls are not enabled for your Amazon Chime SDK Voice Connector. This parameter is not required, but you must specify this parameter or <code>Routes</code>.</p>', 'Proxy$Disabled' => '<p>When true, stops proxy sessions from being created on the specified Amazon Chime SDK Voice Connector.</p>', 'PutVoiceConnectorProxyRequest$Disabled' => '<p>When true, stops proxy sessions from being created on the specified Amazon Chime SDK Voice Connector.</p>', 'SipMediaApplicationLoggingConfiguration$EnableSipMediaApplicationMessageLogs' => '<p>Enables message logging for the specified SIP media application.</p>', 'SipRule$Disabled' => '<p>Indicates whether the SIP rule is enabled or disabled. You must disable a rule before you can delete it.</p>', 'StreamingConfiguration$Disabled' => '<p>When true, streaming to Kinesis is off.</p>', 'Termination$Disabled' => '<p>When termination is disabled, outbound calls cannot be made.</p>', 'UpdateVoiceConnectorRequest$RequireEncryption' => '<p>When enabled, requires encryption for the Voice Connector.</p>', 'VoiceConnector$RequireEncryption' => '<p>Enables or disables encryption for the Voice Connector.</p>', ], ], 'CallDetails' => [ 'base' => '<p>The details of an Amazon Chime SDK Voice Connector call.</p>', 'refs' => [ 'SpeakerSearchTask$CallDetails' => '<p>The call details of a speaker search task.</p>', 'VoiceToneAnalysisTask$CallDetails' => '<p>The call details of a voice tone analysis task.</p>', ], ], 'CallLegType' => [ 'base' => NULL, 'refs' => [ 'StartSpeakerSearchTaskRequest$CallLeg' => '<p>Specifies which call leg to stream for speaker search.</p>', ], ], 'CallingName' => [ 'base' => NULL, 'refs' => [ 'GetPhoneNumberSettingsResponse$CallingName' => '<p>The default outbound calling name for the account.</p>', 'PhoneNumber$CallingName' => '<p>The outbound calling name associated with the phone number.</p>', 'UpdatePhoneNumberRequest$CallingName' => '<p>The outbound calling name associated with the phone number.</p>', 'UpdatePhoneNumberRequestItem$CallingName' => '<p>The outbound calling name to update.</p>', 'UpdatePhoneNumberSettingsRequest$CallingName' => '<p>The default outbound calling name for the account.</p>', ], ], 'CallingNameStatus' => [ 'base' => NULL, 'refs' => [ 'PhoneNumber$CallingNameStatus' => '<p>The outbound calling name status.</p>', ], ], 'CallingRegion' => [ 'base' => NULL, 'refs' => [ 'CallingRegionList$member' => NULL, ], ], 'CallingRegionList' => [ 'base' => NULL, 'refs' => [ 'Termination$CallingRegions' => '<p>The countries to which calls are allowed, in ISO 3166-1 alpha-2 format. Required.</p>', ], ], 'CandidateAddress' => [ 'base' => '<p>A suggested address.</p>', 'refs' => [ 'CandidateAddressList$member' => NULL, ], ], 'CandidateAddressList' => [ 'base' => NULL, 'refs' => [ 'ValidateE911AddressResponse$CandidateAddressList' => '<p>The list of address suggestions..</p>', ], ], 'Capability' => [ 'base' => NULL, 'refs' => [ 'CapabilityList$member' => NULL, ], ], 'CapabilityList' => [ 'base' => NULL, 'refs' => [ 'CreateProxySessionRequest$Capabilities' => '<p>The proxy session\'s capabilities.</p>', 'ProxySession$Capabilities' => '<p>The proxy session capabilities.</p>', 'UpdateProxySessionRequest$Capabilities' => '<p>The proxy session capabilities.</p>', ], ], 'ClientRequestId' => [ 'base' => NULL, 'refs' => [ 'CreateVoiceProfileDomainRequest$ClientRequestToken' => '<p>The unique identifier for the client request. Use a different token for different domain creation requests.</p>', 'StartSpeakerSearchTaskRequest$ClientRequestToken' => '<p>The unique identifier for the client request. Use a different token for different speaker search tasks.</p>', 'StartVoiceToneAnalysisTaskRequest$ClientRequestToken' => '<p>The unique identifier for the client request. Use a different token for different voice tone analysis tasks.</p>', ], ], 'ConfidenceScore' => [ 'base' => NULL, 'refs' => [ 'SpeakerSearchResult$ConfidenceScore' => '<p>The confidence score in the speaker search analysis.</p>', ], ], 'ConflictException' => [ 'base' => '<p>Multiple instances of the same request were made simultaneously.</p>', 'refs' => [], ], 'Country' => [ 'base' => NULL, 'refs' => [ 'CountryList$member' => NULL, 'GeoMatchParams$Country' => '<p>The country.</p>', ], ], 'CountryList' => [ 'base' => NULL, 'refs' => [ 'PutVoiceConnectorProxyRequest$PhoneNumberPoolCountries' => '<p>The countries for proxy phone numbers to be selected from.</p>', ], ], 'CpsLimit' => [ 'base' => NULL, 'refs' => [ 'Termination$CpsLimit' => '<p>The limit on calls per second. Max value based on account service quota. Default value of 1.</p>', ], ], 'CreatePhoneNumberOrderRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreatePhoneNumberOrderResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateProxySessionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateProxySessionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateSipMediaApplicationCallRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSipMediaApplicationCallResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateSipMediaApplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSipMediaApplicationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateSipRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSipRuleResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateVoiceConnectorGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateVoiceConnectorGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateVoiceConnectorRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateVoiceConnectorResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateVoiceProfileDomainRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateVoiceProfileDomainResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateVoiceProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateVoiceProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'Credential' => [ 'base' => '<p>The SIP credentials used to authenticate requests to an Amazon Chime SDK Voice Connector.</p>', 'refs' => [ 'CredentialList$member' => NULL, ], ], 'CredentialList' => [ 'base' => NULL, 'refs' => [ 'PutVoiceConnectorTerminationCredentialsRequest$Credentials' => '<p>The termination credentials being updated.</p>', ], ], 'DNISEmergencyCallingConfiguration' => [ 'base' => '<p>The Dialed Number Identification Service (DNIS) emergency calling configuration details associated with an Amazon Chime SDK Voice Connector\'s emergency calling configuration.</p>', 'refs' => [ 'DNISEmergencyCallingConfigurationList$member' => NULL, ], ], 'DNISEmergencyCallingConfigurationList' => [ 'base' => NULL, 'refs' => [ 'EmergencyCallingConfiguration$DNIS' => '<p>The Dialed Number Identification Service (DNIS) emergency calling configuration details.</p>', ], ], 'DataRetentionInHours' => [ 'base' => NULL, 'refs' => [ 'StreamingConfiguration$DataRetentionInHours' => '<p>The amount of time, in hours, to the Kinesis data.</p>', ], ], 'DeletePhoneNumberRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteProxySessionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSipMediaApplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSipRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVoiceConnectorEmergencyCallingConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVoiceConnectorGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVoiceConnectorOriginationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVoiceConnectorProxyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVoiceConnectorRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVoiceConnectorStreamingConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVoiceConnectorTerminationCredentialsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVoiceConnectorTerminationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVoiceProfileDomainRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVoiceProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociatePhoneNumbersFromVoiceConnectorGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociatePhoneNumbersFromVoiceConnectorGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociatePhoneNumbersFromVoiceConnectorRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociatePhoneNumbersFromVoiceConnectorResponse' => [ 'base' => NULL, 'refs' => [], ], 'E164PhoneNumber' => [ 'base' => NULL, 'refs' => [ 'CreateSipMediaApplicationCallRequest$FromPhoneNumber' => '<p>The phone number that a user calls from. This is a phone number in your Amazon Chime SDK phone number inventory.</p>', 'CreateSipMediaApplicationCallRequest$ToPhoneNumber' => '<p>The phone number that the service should call.</p>', 'DNISEmergencyCallingConfiguration$EmergencyPhoneNumber' => '<p>The DNIS phone number that you route emergency calls to, in E.164 format.</p>', 'DNISEmergencyCallingConfiguration$TestPhoneNumber' => '<p>The DNIS phone number for routing test emergency calls to, in E.164 format.</p>', 'E164PhoneNumberList$member' => NULL, 'OrderedPhoneNumber$E164PhoneNumber' => '<p>The phone number, in E.164 format.</p>', 'Participant$PhoneNumber' => '<p>The participant\'s phone number.</p>', 'Participant$ProxyPhoneNumber' => '<p>The participant\'s proxy phone number.</p>', 'ParticipantPhoneNumberList$member' => NULL, 'PhoneNumber$E164PhoneNumber' => '<p>The phone number, in E.164 format.</p>', 'Proxy$FallBackPhoneNumber' => '<p>The phone number to route calls to after a proxy session expires.</p>', 'PutVoiceConnectorProxyRequest$FallBackPhoneNumber' => '<p>The phone number to route calls to after a proxy session expires.</p>', 'Termination$DefaultPhoneNumber' => '<p>The default outbound calling number.</p>', ], ], 'E164PhoneNumberList' => [ 'base' => NULL, 'refs' => [ 'AssociatePhoneNumbersWithVoiceConnectorGroupRequest$E164PhoneNumbers' => '<p>List of phone numbers, in E.164 format.</p>', 'AssociatePhoneNumbersWithVoiceConnectorRequest$E164PhoneNumbers' => '<p>List of phone numbers, in E.164 format.</p>', 'CreatePhoneNumberOrderRequest$E164PhoneNumbers' => '<p>List of phone numbers, in E.164 format.</p>', 'DisassociatePhoneNumbersFromVoiceConnectorGroupRequest$E164PhoneNumbers' => '<p>The list of phone numbers, in E.164 format.</p>', 'DisassociatePhoneNumbersFromVoiceConnectorRequest$E164PhoneNumbers' => '<p>List of phone numbers, in E.164 format.</p>', 'SearchAvailablePhoneNumbersResponse$E164PhoneNumbers' => '<p>Confines a search to just the phone numbers in the E.164 format.</p>', ], ], 'EmergencyCallingConfiguration' => [ 'base' => '<p>The emergency calling configuration details associated with an Amazon Chime SDK Voice Connector.</p>', 'refs' => [ 'GetVoiceConnectorEmergencyCallingConfigurationResponse$EmergencyCallingConfiguration' => '<p>The details of the emergency calling configuration.</p>', 'PutVoiceConnectorEmergencyCallingConfigurationRequest$EmergencyCallingConfiguration' => '<p>The configuration being updated.</p>', 'PutVoiceConnectorEmergencyCallingConfigurationResponse$EmergencyCallingConfiguration' => '<p>The updated configuration.</p>', ], ], 'ErrorCode' => [ 'base' => NULL, 'refs' => [ 'PhoneNumberError$ErrorCode' => '<p>The error code.</p>', ], ], 'ForbiddenException' => [ 'base' => '<p>The client is permanently forbidden from making the request.</p>', 'refs' => [], ], 'FunctionArn' => [ 'base' => NULL, 'refs' => [ 'SipMediaApplicationEndpoint$LambdaArn' => '<p>Valid Amazon Resource Name (ARN) of the Lambda function, version, or alias. The function must be created in the same AWS Region as the SIP media application.</p>', ], ], 'GeoMatchLevel' => [ 'base' => NULL, 'refs' => [ 'CreateProxySessionRequest$GeoMatchLevel' => '<p>The preference for matching the country or area code of the proxy phone number with that of the first participant.</p>', 'ProxySession$GeoMatchLevel' => '<p>The preference for matching the country or area code of the proxy phone number with that of the first participant.</p>', ], ], 'GeoMatchParams' => [ 'base' => '<p>The country and area code for a proxy phone number in a proxy phone session.</p>', 'refs' => [ 'CreateProxySessionRequest$GeoMatchParams' => '<p>The country and area code for the proxy phone number.</p>', 'ProxySession$GeoMatchParams' => '<p>The country and area code for the proxy phone number.</p>', ], ], 'GetGlobalSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetPhoneNumberOrderRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetPhoneNumberOrderResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetPhoneNumberRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetPhoneNumberResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetPhoneNumberSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetProxySessionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetProxySessionResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetSipMediaApplicationAlexaSkillConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSipMediaApplicationAlexaSkillConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetSipMediaApplicationLoggingConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSipMediaApplicationLoggingConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetSipMediaApplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSipMediaApplicationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetSipRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSipRuleResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetSpeakerSearchTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSpeakerSearchTaskResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetVoiceConnectorEmergencyCallingConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetVoiceConnectorEmergencyCallingConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetVoiceConnectorGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetVoiceConnectorGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetVoiceConnectorLoggingConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetVoiceConnectorLoggingConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetVoiceConnectorOriginationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetVoiceConnectorOriginationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetVoiceConnectorProxyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetVoiceConnectorProxyResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetVoiceConnectorRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetVoiceConnectorResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetVoiceConnectorStreamingConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetVoiceConnectorStreamingConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetVoiceConnectorTerminationHealthRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetVoiceConnectorTerminationHealthResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetVoiceConnectorTerminationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetVoiceConnectorTerminationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetVoiceProfileDomainRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetVoiceProfileDomainResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetVoiceProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetVoiceProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetVoiceToneAnalysisTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetVoiceToneAnalysisTaskResponse' => [ 'base' => NULL, 'refs' => [], ], 'GoneException' => [ 'base' => '<p>Access to the target resource is no longer available at the origin server. This condition is likely to be permanent.</p>', 'refs' => [], ], 'GuidString' => [ 'base' => NULL, 'refs' => [ 'GetPhoneNumberOrderRequest$PhoneNumberOrderId' => '<p>The ID of the phone number order .</p>', 'PhoneNumber$OrderId' => '<p>The phone number\'s order ID.</p>', 'PhoneNumberOrder$PhoneNumberOrderId' => '<p>The ID of the phone order.</p>', 'SipMediaApplicationCall$TransactionId' => '<p>The call\'s transaction ID.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'Proxy$DefaultSessionExpiryMinutes' => '<p>The default number of minutes allowed for proxy sessions.</p>', 'PutVoiceConnectorProxyRequest$DefaultSessionExpiryMinutes' => '<p>The default number of minutes allowed for proxy session.</p>', ], ], 'Iso8601Timestamp' => [ 'base' => NULL, 'refs' => [ 'GetPhoneNumberSettingsResponse$CallingNameUpdatedTimestamp' => '<p>The updated outbound calling name timestamp, in ISO 8601 format.</p>', 'PhoneNumber$CreatedTimestamp' => '<p>The phone number creation timestamp, in ISO 8601 format.</p>', 'PhoneNumber$UpdatedTimestamp' => '<p>The updated phone number timestamp, in ISO 8601 format.</p>', 'PhoneNumber$DeletionTimestamp' => '<p>The deleted phone number timestamp, in ISO 8601 format.</p>', 'PhoneNumberAssociation$AssociatedTimestamp' => '<p>The timestamp of the phone number association, in ISO 8601 format.</p>', 'PhoneNumberOrder$CreatedTimestamp' => '<p>The phone number order creation time stamp, in ISO 8601 format.</p>', 'PhoneNumberOrder$UpdatedTimestamp' => '<p>The updated phone number order time stamp, in ISO 8601 format.</p>', 'ProxySession$CreatedTimestamp' => '<p>The created time stamp, in ISO 8601 format.</p>', 'ProxySession$UpdatedTimestamp' => '<p>The updated time stamp, in ISO 8601 format.</p>', 'ProxySession$EndedTimestamp' => '<p>The ended time stamp, in ISO 8601 format.</p>', 'SipMediaApplication$CreatedTimestamp' => '<p>The SIP media application creation timestamp, in ISO 8601 format.</p>', 'SipMediaApplication$UpdatedTimestamp' => '<p>The time at which the SIP media application was updated.</p>', 'SipRule$CreatedTimestamp' => '<p>The time at which the SIP rule was created, in ISO 8601 format.</p>', 'SipRule$UpdatedTimestamp' => '<p>The time at which the SIP rule was updated, in ISO 8601 format.</p>', 'SpeakerSearchTask$CreatedTimestamp' => '<p>The time at which a speaker search task was created.</p>', 'SpeakerSearchTask$UpdatedTimestamp' => '<p>The time at which a speaker search task was updated.</p>', 'SpeakerSearchTask$StartedTimestamp' => '<p>The time at which the speaker search task began.</p>', 'TerminationHealth$Timestamp' => '<p>The timestamp, in ISO 8601 format.</p>', 'VoiceConnector$CreatedTimestamp' => '<p>The Voice Connector\'s creation timestamp, in ISO 8601 format.</p>', 'VoiceConnector$UpdatedTimestamp' => '<p>The Voice Connector\'s updated timestamp, in ISO 8601 format.</p>', 'VoiceConnectorGroup$CreatedTimestamp' => '<p>The Voice Connector group\'s creation time stamp, in ISO 8601 format.</p>', 'VoiceConnectorGroup$UpdatedTimestamp' => '<p>The Voice Connector group\'s creation time stamp, in ISO 8601 format.</p>', 'VoiceProfile$CreatedTimestamp' => '<p>The time at which the voice profile was created and enrolled.</p>', 'VoiceProfile$UpdatedTimestamp' => '<p>The time at which the voice profile was last updated.</p>', 'VoiceProfile$ExpirationTimestamp' => '<p>The time at which a voice profile expires unless you re-enroll the caller via the <code>UpdateVoiceProfile</code> API.</p>', 'VoiceProfileDomain$CreatedTimestamp' => '<p>The time at which the voice profile domain was created.</p>', 'VoiceProfileDomain$UpdatedTimestamp' => '<p>The time at which the voice profile was last updated.</p>', 'VoiceProfileDomainSummary$CreatedTimestamp' => '<p>The time at which the voice profile domain summary was created.</p>', 'VoiceProfileDomainSummary$UpdatedTimestamp' => '<p>The time at which the voice profile domain summary was last updated.</p>', 'VoiceProfileSummary$CreatedTimestamp' => '<p>The time at which a voice profile summary was created.</p>', 'VoiceProfileSummary$UpdatedTimestamp' => '<p>The time at which a voice profile summary was last updated.</p>', 'VoiceProfileSummary$ExpirationTimestamp' => '<p>Extends the life of the voice profile. You can use <code>UpdateVoiceProfile</code> to refresh an existing voice profile\'s voice print and extend the life of the summary.</p>', 'VoiceToneAnalysisTask$CreatedTimestamp' => '<p>The time at which a voice tone analysis task was created.</p>', 'VoiceToneAnalysisTask$UpdatedTimestamp' => '<p>The time at which a voice tone analysis task was updated.</p>', 'VoiceToneAnalysisTask$StartedTimestamp' => '<p>The time at which a voice tone analysis task started.</p>', ], ], 'LanguageCode' => [ 'base' => NULL, 'refs' => [ 'StartVoiceToneAnalysisTaskRequest$LanguageCode' => '<p>The language code.</p>', ], ], 'ListAvailableVoiceConnectorRegionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPhoneNumberOrdersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPhoneNumberOrdersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPhoneNumbersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPhoneNumbersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListProxySessionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListProxySessionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSipMediaApplicationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSipMediaApplicationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSipRulesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSipRulesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSupportedPhoneNumberCountriesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSupportedPhoneNumberCountriesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListVoiceConnectorGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListVoiceConnectorGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListVoiceConnectorTerminationCredentialsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListVoiceConnectorTerminationCredentialsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListVoiceConnectorsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListVoiceConnectorsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListVoiceProfileDomainsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListVoiceProfileDomainsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListVoiceProfilesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListVoiceProfilesResponse' => [ 'base' => NULL, 'refs' => [], ], 'LoggingConfiguration' => [ 'base' => '<p>The logging configuration associated with an Amazon Chime SDK Voice Connector. Specifies whether SIP message logs can be sent to Amazon CloudWatch Logs.</p>', 'refs' => [ 'GetVoiceConnectorLoggingConfigurationResponse$LoggingConfiguration' => '<p>The logging configuration details .</p>', 'PutVoiceConnectorLoggingConfigurationRequest$LoggingConfiguration' => '<p>The logging configuration being updated.</p>', 'PutVoiceConnectorLoggingConfigurationResponse$LoggingConfiguration' => '<p>The updated logging configuration.</p>', ], ], 'MediaInsightsConfiguration' => [ 'base' => '<p>The configuration for a call analytics task.</p>', 'refs' => [ 'StreamingConfiguration$MediaInsightsConfiguration' => '<p>The call analytics configuration.</p>', ], ], 'NextTokenString' => [ 'base' => NULL, 'refs' => [ 'ListProxySessionsRequest$NextToken' => '<p>The token used to retrieve the next page of results.</p>', 'ListProxySessionsResponse$NextToken' => '<p>The token used to retrieve the next page of results.</p>', 'ListSipMediaApplicationsRequest$NextToken' => '<p>The token used to return the next page of results.</p>', 'ListSipMediaApplicationsResponse$NextToken' => '<p>The token used to return the next page of results.</p>', 'ListSipRulesRequest$NextToken' => '<p>The token used to return the next page of results.</p>', 'ListSipRulesResponse$NextToken' => '<p>The token used to return the next page of results.</p>', ], ], 'NonEmptyString' => [ 'base' => NULL, 'refs' => [ 'AssociatePhoneNumbersWithVoiceConnectorGroupRequest$VoiceConnectorGroupId' => '<p>The Amazon Chime SDK Voice Connector group ID.</p>', 'AssociatePhoneNumbersWithVoiceConnectorRequest$VoiceConnectorId' => '<p>The Voice Connector ID.</p>', 'CreateSipMediaApplicationCallRequest$SipMediaApplicationId' => '<p>The ID of the SIP media application.</p>', 'CreateSipRuleRequest$TriggerValue' => '<p>If <code>TriggerType</code> is <code>RequestUriHostname</code>, the value can be the outbound host name of a Voice Connector. If <code>TriggerType</code> is <code>ToPhoneNumber</code>, the value can be a customer-owned phone number in the E164 format. The <code>SipMediaApplication</code> specified in the <code>SipRule</code> is triggered if the request URI in an incoming SIP request matches the <code>RequestUriHostname</code>, or if the <code>To</code> header in the incoming SIP request matches the <code>ToPhoneNumber</code> value.</p>', 'DeleteSipMediaApplicationRequest$SipMediaApplicationId' => '<p>The SIP media application ID.</p>', 'DeleteSipRuleRequest$SipRuleId' => '<p>The SIP rule ID.</p>', 'DeleteVoiceConnectorEmergencyCallingConfigurationRequest$VoiceConnectorId' => '<p>The Voice Connector ID.</p>', 'DeleteVoiceConnectorGroupRequest$VoiceConnectorGroupId' => '<p>The Voice Connector Group ID.</p>', 'DeleteVoiceConnectorOriginationRequest$VoiceConnectorId' => '<p>The Voice Connector ID.</p>', 'DeleteVoiceConnectorRequest$VoiceConnectorId' => '<p>The Voice Connector ID.</p>', 'DeleteVoiceConnectorStreamingConfigurationRequest$VoiceConnectorId' => '<p>The Voice Connector ID.</p>', 'DeleteVoiceConnectorTerminationCredentialsRequest$VoiceConnectorId' => '<p>The Voice Connector ID.</p>', 'DeleteVoiceConnectorTerminationRequest$VoiceConnectorId' => '<p>The Voice Connector ID.</p>', 'DisassociatePhoneNumbersFromVoiceConnectorGroupRequest$VoiceConnectorGroupId' => '<p>The Voice Connector group ID.</p>', 'DisassociatePhoneNumbersFromVoiceConnectorRequest$VoiceConnectorId' => '<p>The Voice Connector ID.</p>', 'GetSipMediaApplicationAlexaSkillConfigurationRequest$SipMediaApplicationId' => '<p>The SIP media application ID.</p>', 'GetSipMediaApplicationLoggingConfigurationRequest$SipMediaApplicationId' => '<p>The SIP media application ID.</p>', 'GetSipMediaApplicationRequest$SipMediaApplicationId' => '<p>The SIP media application ID .</p>', 'GetSipRuleRequest$SipRuleId' => '<p>The SIP rule ID.</p>', 'GetVoiceConnectorEmergencyCallingConfigurationRequest$VoiceConnectorId' => '<p>The Voice Connector ID.</p>', 'GetVoiceConnectorGroupRequest$VoiceConnectorGroupId' => '<p>The Voice Connector group ID.</p>', 'GetVoiceConnectorLoggingConfigurationRequest$VoiceConnectorId' => '<p>The Voice Connector ID.</p>', 'GetVoiceConnectorOriginationRequest$VoiceConnectorId' => '<p>The Voice Connector ID.</p>', 'GetVoiceConnectorRequest$VoiceConnectorId' => '<p>The Voice Connector ID.</p>', 'GetVoiceConnectorStreamingConfigurationRequest$VoiceConnectorId' => '<p>The Voice Connector ID.</p>', 'GetVoiceConnectorTerminationHealthRequest$VoiceConnectorId' => '<p>The Voice Connector ID.</p>', 'GetVoiceConnectorTerminationRequest$VoiceConnectorId' => '<p>The Voice Connector ID.</p>', 'ListSipRulesRequest$SipMediaApplicationId' => '<p>The SIP media application ID.</p>', 'ListVoiceConnectorTerminationCredentialsRequest$VoiceConnectorId' => '<p>The Voice Connector ID.</p>', 'PutSipMediaApplicationAlexaSkillConfigurationRequest$SipMediaApplicationId' => '<p>The SIP media application ID.</p>', 'PutSipMediaApplicationLoggingConfigurationRequest$SipMediaApplicationId' => '<p>The SIP media application ID.</p>', 'PutVoiceConnectorEmergencyCallingConfigurationRequest$VoiceConnectorId' => '<p>The Voice Connector ID.</p>', 'PutVoiceConnectorLoggingConfigurationRequest$VoiceConnectorId' => '<p>The Voice Connector ID.</p>', 'PutVoiceConnectorOriginationRequest$VoiceConnectorId' => '<p>The Voice Connector ID.</p>', 'PutVoiceConnectorStreamingConfigurationRequest$VoiceConnectorId' => '<p>The Voice Connector ID.</p>', 'PutVoiceConnectorTerminationCredentialsRequest$VoiceConnectorId' => '<p>The Voice Connector ID.</p>', 'PutVoiceConnectorTerminationRequest$VoiceConnectorId' => '<p>The Voice Connector ID.</p>', 'SipMediaApplication$SipMediaApplicationId' => '<p>A SIP media application\'s ID.</p>', 'SipMediaApplication$SipMediaApplicationArn' => '<p>The ARN of the SIP media application.</p>', 'SipRule$SipRuleId' => '<p>A SIP rule\'s ID.</p>', 'SipRule$TriggerValue' => '<p>The value set for a SIP rule\'s trigger type. Either a phone number or a URI hostname.</p>', 'SipRuleTargetApplication$SipMediaApplicationId' => '<p>The ID of a rule\'s target SIP media application.</p>', 'SpeakerSearchTask$SpeakerSearchTaskStatus' => '<p>The status of the speaker search task, <code>IN_QUEUE</code>, <code>IN_PROGRESS</code>, <code>PARTIAL_SUCCESS</code>, <code>SUCCEEDED</code>, <code>FAILED</code>, or <code>STOPPED</code>.</p>', 'UpdateSipMediaApplicationCallRequest$SipMediaApplicationId' => '<p>The ID of the SIP media application handling the call.</p>', 'UpdateSipMediaApplicationCallRequest$TransactionId' => '<p>The ID of the call transaction.</p>', 'UpdateSipMediaApplicationRequest$SipMediaApplicationId' => '<p>The SIP media application ID.</p>', 'UpdateSipRuleRequest$SipRuleId' => '<p>The SIP rule ID.</p>', 'UpdateVoiceConnectorGroupRequest$VoiceConnectorGroupId' => '<p>The Voice Connector ID.</p>', 'UpdateVoiceConnectorRequest$VoiceConnectorId' => '<p>The Voice Connector ID.</p>', 'ValidateE911AddressRequest$AwsAccountId' => '<p>The AWS account ID.</p>', 'VoiceConnector$VoiceConnectorId' => '<p>The Voice Connector\'s ID.</p>', 'VoiceConnector$VoiceConnectorArn' => '<p>The ARN of the Voice Connector.</p>', 'VoiceConnectorGroup$VoiceConnectorGroupId' => '<p>The ID of a Voice Connector group.</p>', 'VoiceConnectorGroup$VoiceConnectorGroupArn' => '<p>The ARN of the Voice Connector group.</p>', 'VoiceConnectorItem$VoiceConnectorId' => '<p>The Voice Connector ID.</p>', 'VoiceToneAnalysisTask$VoiceToneAnalysisTaskStatus' => '<p>The status of a voice tone analysis task, <code>IN_QUEUE</code>, <code>IN_PROGRESS</code>, <code>PARTIAL_SUCCESS</code>, <code>SUCCEEDED</code>, <code>FAILED</code>, or <code>STOPPED</code>.</p>', ], ], 'NonEmptyString128' => [ 'base' => NULL, 'refs' => [ 'CallDetails$VoiceConnectorId' => '<p>The Voice Connector ID.</p>', 'CreateProxySessionRequest$VoiceConnectorId' => '<p>The Voice Connector ID.</p>', 'DeleteProxySessionRequest$VoiceConnectorId' => '<p>The Voice Connector ID.</p>', 'DeleteProxySessionRequest$ProxySessionId' => '<p>The proxy session ID.</p>', 'DeleteVoiceConnectorProxyRequest$VoiceConnectorId' => '<p>The Voice Connector ID.</p>', 'GetProxySessionRequest$VoiceConnectorId' => '<p>The Voice Connector ID.</p>', 'GetProxySessionRequest$ProxySessionId' => '<p>The proxy session ID.</p>', 'GetSpeakerSearchTaskRequest$VoiceConnectorId' => '<p>The Voice Connector ID.</p>', 'GetVoiceConnectorProxyRequest$VoiceConnectorId' => '<p>The Voice Connector ID.</p>', 'GetVoiceToneAnalysisTaskRequest$VoiceConnectorId' => '<p>The Voice Connector ID.</p>', 'ListProxySessionsRequest$VoiceConnectorId' => '<p>The Voice Connector ID.</p>', 'ProxySession$VoiceConnectorId' => '<p>The Voice Connector ID.</p>', 'ProxySession$ProxySessionId' => '<p>The proxy session ID.</p>', 'PutVoiceConnectorProxyRequest$VoiceConnectorId' => '<p>The Voice Connector ID.</p>', 'StartSpeakerSearchTaskRequest$VoiceConnectorId' => '<p>The Voice Connector ID.</p>', 'StartVoiceToneAnalysisTaskRequest$VoiceConnectorId' => '<p>The Voice Connector ID.</p>', 'StopSpeakerSearchTaskRequest$VoiceConnectorId' => '<p>The Voice Connector ID.</p>', 'StopVoiceToneAnalysisTaskRequest$VoiceConnectorId' => '<p>The Voice Connector ID.</p>', 'UpdateProxySessionRequest$VoiceConnectorId' => '<p>The Voice Connector ID.</p>', 'UpdateProxySessionRequest$ProxySessionId' => '<p>The proxy session ID.</p>', ], ], 'NonEmptyString256' => [ 'base' => NULL, 'refs' => [ 'CallDetails$TransactionId' => '<p>The transaction ID of a Voice Connector call.</p>', 'CreateVoiceProfileRequest$SpeakerSearchTaskId' => '<p>The ID of the speaker search task.</p>', 'DeleteVoiceProfileDomainRequest$VoiceProfileDomainId' => '<p>The voice profile domain ID.</p>', 'DeleteVoiceProfileRequest$VoiceProfileId' => '<p>The voice profile ID.</p>', 'GetSpeakerSearchTaskRequest$SpeakerSearchTaskId' => '<p>The ID of the speaker search task.</p>', 'GetVoiceProfileDomainRequest$VoiceProfileDomainId' => '<p>The voice profile domain ID.</p>', 'GetVoiceProfileRequest$VoiceProfileId' => '<p>The voice profile ID.</p>', 'GetVoiceToneAnalysisTaskRequest$VoiceToneAnalysisTaskId' => '<p>The ID of the voice tone anlysis task.</p>', 'ListVoiceProfilesRequest$VoiceProfileDomainId' => '<p>The ID of the voice profile domain.</p>', 'SpeakerSearchDetails$VoiceprintGenerationStatus' => '<p>The status of a voice print generation operation, <code>VoiceprintGenerationSuccess</code> or <code>VoiceprintGenerationFailure</code>..</p>', 'SpeakerSearchResult$VoiceProfileId' => '<p>The voice profile ID.</p>', 'SpeakerSearchTask$SpeakerSearchTaskId' => '<p>The speaker search task ID.</p>', 'StartSpeakerSearchTaskRequest$TransactionId' => '<p>The transaction ID of the call being analyzed.</p>', 'StartSpeakerSearchTaskRequest$VoiceProfileDomainId' => '<p>The ID of the voice profile domain that will store the voice profile.</p>', 'StartVoiceToneAnalysisTaskRequest$TransactionId' => '<p>The transaction ID.</p>', 'StopSpeakerSearchTaskRequest$SpeakerSearchTaskId' => '<p>The speaker search task ID.</p>', 'StopVoiceToneAnalysisTaskRequest$VoiceToneAnalysisTaskId' => '<p>The ID of the voice tone analysis task.</p>', 'UpdateVoiceProfileDomainRequest$VoiceProfileDomainId' => '<p>The domain ID.</p>', 'UpdateVoiceProfileRequest$VoiceProfileId' => '<p>The profile ID.</p>', 'UpdateVoiceProfileRequest$SpeakerSearchTaskId' => '<p>The ID of the speaker search task.</p>', 'VoiceProfile$VoiceProfileId' => '<p>The ID of the voice profile.</p>', 'VoiceProfile$VoiceProfileDomainId' => '<p>The ID of the domain that contains the voice profile.</p>', 'VoiceProfileDomain$VoiceProfileDomainId' => '<p>The ID of the voice profile domain.</p>', 'VoiceProfileDomainSummary$VoiceProfileDomainId' => '<p>The ID of the voice profile domain summary.</p>', 'VoiceProfileSummary$VoiceProfileId' => '<p>The ID of the voice profile in a voice profile summary.</p>', 'VoiceProfileSummary$VoiceProfileDomainId' => '<p>The ID of the voice profile domain in a voice profile summary.</p>', 'VoiceToneAnalysisTask$VoiceToneAnalysisTaskId' => '<p>The ID of the voice tone analysis task.</p>', ], ], 'NonEmptyStringList' => [ 'base' => NULL, 'refs' => [ 'BatchDeletePhoneNumberRequest$PhoneNumberIds' => '<p>List of phone number IDs.</p>', ], ], 'NotFoundException' => [ 'base' => '<p>The requested resource couldn\'t be found.</p>', 'refs' => [], ], 'NotificationTarget' => [ 'base' => NULL, 'refs' => [ 'StreamingNotificationTarget$NotificationTarget' => '<p>The streaming notification target.</p>', ], ], 'NullableBoolean' => [ 'base' => NULL, 'refs' => [ 'AssociatePhoneNumbersWithVoiceConnectorGroupRequest$ForceAssociate' => '<p>If true, associates the provided phone numbers with the provided Amazon Chime SDK Voice Connector Group and removes any previously existing associations. If false, does not associate any phone numbers that have previously existing associations.</p>', 'AssociatePhoneNumbersWithVoiceConnectorRequest$ForceAssociate' => '<p>If true, associates the provided phone numbers with the provided Amazon Chime SDK Voice Connector and removes any previously existing associations. If false, does not associate any phone numbers that have previously existing associations.</p>', 'CreateSipRuleRequest$Disabled' => '<p>Disables or enables a SIP rule. You must disable SIP rules before you can delete them.</p>', 'PhoneNumberCapabilities$InboundCall' => '<p>Allows or denies inbound calling for the specified phone number.</p>', 'PhoneNumberCapabilities$OutboundCall' => '<p>Allows or denies outbound calling for the specified phone number.</p>', 'PhoneNumberCapabilities$InboundSMS' => '<p>Allows or denies inbound SMS messaging for the specified phone number.</p>', 'PhoneNumberCapabilities$OutboundSMS' => '<p>Allows or denies outbound SMS messaging for the specified phone number.</p>', 'PhoneNumberCapabilities$InboundMMS' => '<p>Allows or denies inbound MMS messaging for the specified phone number.</p>', 'PhoneNumberCapabilities$OutboundMMS' => '<p>Allows or denies inbound MMS messaging for the specified phone number.</p>', 'UpdateSipRuleRequest$Disabled' => '<p>The new value that indicates whether the rule is disabled.</p>', ], ], 'NumberSelectionBehavior' => [ 'base' => NULL, 'refs' => [ 'CreateProxySessionRequest$NumberSelectionBehavior' => '<p>The preference for proxy phone number reuse, or stickiness, between the same participants across sessions.</p>', 'ProxySession$NumberSelectionBehavior' => '<p>The preference for proxy phone number reuse, or stickiness, between the same participants across sessions.</p>', ], ], 'OrderedPhoneNumber' => [ 'base' => '<p>A phone number for which an order has been placed.</p>', 'refs' => [ 'OrderedPhoneNumberList$member' => NULL, ], ], 'OrderedPhoneNumberList' => [ 'base' => NULL, 'refs' => [ 'PhoneNumberOrder$OrderedPhoneNumbers' => '<p>The ordered phone number details, such as the phone number in E.164 format and the phone number status.</p>', ], ], 'OrderedPhoneNumberStatus' => [ 'base' => NULL, 'refs' => [ 'OrderedPhoneNumber$Status' => '<p>The phone number status.</p>', ], ], 'Origination' => [ 'base' => '<p>Origination settings enable your SIP hosts to receive inbound calls using your Amazon Chime SDK Voice Connector.</p> <note> <p>The parameters listed below are not required, but you must use at least one.</p> </note>', 'refs' => [ 'GetVoiceConnectorOriginationResponse$Origination' => '<p>The origination setting details.</p>', 'PutVoiceConnectorOriginationRequest$Origination' => '<p>The origination settings being updated.</p>', 'PutVoiceConnectorOriginationResponse$Origination' => '<p>The updated origination settings.</p>', ], ], 'OriginationRoute' => [ 'base' => '<p>Origination routes define call distribution properties for your SIP hosts to receive inbound calls using an Amazon Chime SDK Voice Connector. Limit: Ten origination routes for each Voice Connector.</p> <note> <p>The parameters listed below are not required, but you must use at least one.</p> </note>', 'refs' => [ 'OriginationRouteList$member' => NULL, ], ], 'OriginationRouteList' => [ 'base' => NULL, 'refs' => [ 'Origination$Routes' => '<p>The call distribution properties defined for your SIP hosts. Valid range: Minimum value of 1. Maximum value of 20. This parameter is not required, but you must specify this parameter or <code>Disabled</code>.</p>', ], ], 'OriginationRoutePriority' => [ 'base' => NULL, 'refs' => [ 'OriginationRoute$Priority' => '<p>The priority associated with the host, with 1 being the highest priority. Higher priority hosts are attempted first.</p>', ], ], 'OriginationRouteProtocol' => [ 'base' => NULL, 'refs' => [ 'OriginationRoute$Protocol' => '<p>The protocol to use for the origination route. Encryption-enabled Amazon Chime SDK Voice Connectors use TCP protocol by default.</p>', ], ], 'OriginationRouteWeight' => [ 'base' => NULL, 'refs' => [ 'OriginationRoute$Weight' => '<p>The weight assigned to an origination route. When hosts have equal priority, calls are distributed between them based on their relative weights.</p>', ], ], 'Participant' => [ 'base' => '<p>The phone number and proxy phone number for a participant in an Amazon Chime SDK Voice Connector proxy session.</p>', 'refs' => [ 'Participants$member' => NULL, ], ], 'ParticipantPhoneNumberList' => [ 'base' => NULL, 'refs' => [ 'CreateProxySessionRequest$ParticipantPhoneNumbers' => '<p>The participant phone numbers.</p>', ], ], 'Participants' => [ 'base' => NULL, 'refs' => [ 'ProxySession$Participants' => '<p>The proxy session participants.</p>', ], ], 'PhoneNumber' => [ 'base' => '<p>A phone number used to call an Amazon Chime SDK Voice Connector.</p>', 'refs' => [ 'GetPhoneNumberResponse$PhoneNumber' => '<p>The phone number details.</p>', 'PhoneNumberList$member' => NULL, 'RestorePhoneNumberResponse$PhoneNumber' => '<p>The restored phone number.</p>', 'UpdatePhoneNumberResponse$PhoneNumber' => '<p>The updated phone number details.</p>', ], ], 'PhoneNumberAssociation' => [ 'base' => '<p>The phone number associations, such as an Amazon Chime SDK account ID, user ID, Voice Connector ID, or Voice Connector group ID.</p>', 'refs' => [ 'PhoneNumberAssociationList$member' => NULL, ], ], 'PhoneNumberAssociationList' => [ 'base' => NULL, 'refs' => [ 'PhoneNumber$Associations' => '<p>The phone number\'s associations.</p>', ], ], 'PhoneNumberAssociationName' => [ 'base' => NULL, 'refs' => [ 'ListPhoneNumbersRequest$FilterName' => '<p>The filter to limit the number of results.</p>', 'PhoneNumberAssociation$Name' => '<p>Defines the association with an Amazon Chime SDK account ID, user ID, Voice Connector ID, or Voice Connector group ID.</p>', ], ], 'PhoneNumberCapabilities' => [ 'base' => '<p>The phone number capabilities for Amazon Chime SDK phone numbers, such as enabled inbound and outbound calling, and text messaging.</p>', 'refs' => [ 'PhoneNumber$Capabilities' => '<p>The phone number\'s capabilities.</p>', ], ], 'PhoneNumberCountriesList' => [ 'base' => NULL, 'refs' => [ 'ListSupportedPhoneNumberCountriesResponse$PhoneNumberCountries' => '<p>The supported phone number countries.</p>', ], ], 'PhoneNumberCountry' => [ 'base' => '<p>The phone number\'s country.</p>', 'refs' => [ 'PhoneNumberCountriesList$member' => NULL, ], ], 'PhoneNumberError' => [ 'base' => '<p>If a phone number action fails for one or more of the phone numbers in a request, a list of the failed phone numbers is returned, along with error codes and error messages.</p>', 'refs' => [ 'PhoneNumberErrorList$member' => NULL, ], ], 'PhoneNumberErrorList' => [ 'base' => NULL, 'refs' => [ 'AssociatePhoneNumbersWithVoiceConnectorGroupResponse$PhoneNumberErrors' => '<p>If the action fails for one or more of the phone numbers in the request, a list of the phone numbers is returned, along with error codes and error messages.</p>', 'AssociatePhoneNumbersWithVoiceConnectorResponse$PhoneNumberErrors' => '<p>If the action fails for one or more of the phone numbers in the request, a list of the phone numbers is returned, along with error codes and error messages.</p>', 'BatchDeletePhoneNumberResponse$PhoneNumberErrors' => '<p>If the action fails for one or more of the phone numbers in the request, a list of the phone numbers is returned, along with error codes and error messages.</p>', 'BatchUpdatePhoneNumberResponse$PhoneNumberErrors' => '<p>A list of failed phone numbers and their error messages.</p>', 'DisassociatePhoneNumbersFromVoiceConnectorGroupResponse$PhoneNumberErrors' => '<p>If the action fails for one or more of the phone numbers in the request, a list of the phone numbers is returned, along with error codes and error messages.</p>', 'DisassociatePhoneNumbersFromVoiceConnectorResponse$PhoneNumberErrors' => '<p>If the action fails for one or more of the phone numbers in the request, a list of the phone numbers is returned, along with error codes and error messages.</p>', ], ], 'PhoneNumberList' => [ 'base' => NULL, 'refs' => [ 'ListPhoneNumbersResponse$PhoneNumbers' => '<p>The phone number details.</p>', ], ], 'PhoneNumberMaxResults' => [ 'base' => NULL, 'refs' => [ 'SearchAvailablePhoneNumbersRequest$MaxResults' => '<p>The maximum number of results to return.</p>', ], ], 'PhoneNumberName' => [ 'base' => NULL, 'refs' => [ 'CreatePhoneNumberOrderRequest$Name' => '<p>Specifies the name assigned to one or more phone numbers.</p>', 'PhoneNumber$Name' => '<p>The name of the phone number.</p>', 'UpdatePhoneNumberRequest$Name' => '<p>Specifies the updated name assigned to one or more phone numbers.</p>', 'UpdatePhoneNumberRequestItem$Name' => '<p>The name of the phone number.</p>', ], ], 'PhoneNumberOrder' => [ 'base' => '<p>The details of an Amazon Chime SDK phone number order.</p>', 'refs' => [ 'CreatePhoneNumberOrderResponse$PhoneNumberOrder' => '<p>The phone number order details.</p>', 'GetPhoneNumberOrderResponse$PhoneNumberOrder' => '<p>The phone number order details.</p>', 'PhoneNumberOrderList$member' => NULL, ], ], 'PhoneNumberOrderList' => [ 'base' => NULL, 'refs' => [ 'ListPhoneNumberOrdersResponse$PhoneNumberOrders' => '<p>The phone number order details.</p>', ], ], 'PhoneNumberOrderStatus' => [ 'base' => NULL, 'refs' => [ 'PhoneNumberOrder$Status' => '<p>The status of the phone number order.</p>', ], ], 'PhoneNumberOrderType' => [ 'base' => NULL, 'refs' => [ 'PhoneNumberOrder$OrderType' => '<p>The type of phone number being ordered, local or toll-free.</p>', ], ], 'PhoneNumberProductType' => [ 'base' => NULL, 'refs' => [ 'CreatePhoneNumberOrderRequest$ProductType' => '<p>The phone number product type.</p>', 'ListPhoneNumbersRequest$ProductType' => '<p>The phone number product types.</p>', 'ListSupportedPhoneNumberCountriesRequest$ProductType' => '<p>The phone number product type.</p>', 'PhoneNumber$ProductType' => '<p>The phone number\'s product type.</p>', 'PhoneNumberOrder$ProductType' => '<p>The phone number order product type.</p>', 'UpdatePhoneNumberRequest$ProductType' => '<p>The product type.</p>', 'UpdatePhoneNumberRequestItem$ProductType' => '<p>The product type to update.</p>', ], ], 'PhoneNumberStatus' => [ 'base' => NULL, 'refs' => [ 'PhoneNumber$Status' => '<p>The phone number\'s status.</p>', ], ], 'PhoneNumberType' => [ 'base' => NULL, 'refs' => [ 'PhoneNumber$Type' => '<p>The phone number\'s type.</p>', 'PhoneNumberTypeList$member' => NULL, 'SearchAvailablePhoneNumbersRequest$PhoneNumberType' => '<p>Confines a search to just the phone numbers associated with the specified phone number type, either <b>local</b> or <b>toll-free</b>.</p>', ], ], 'PhoneNumberTypeList' => [ 'base' => NULL, 'refs' => [ 'PhoneNumberCountry$SupportedPhoneNumberTypes' => '<p>The supported phone number types.</p>', ], ], 'Port' => [ 'base' => NULL, 'refs' => [ 'OriginationRoute$Port' => '<p>The designated origination route port. Defaults to 5060.</p>', ], ], 'PositiveInteger' => [ 'base' => NULL, 'refs' => [ 'CreateProxySessionRequest$ExpiryMinutes' => '<p>The number of minutes allowed for the proxy session.</p>', 'ProxySession$ExpiryMinutes' => '<p>The number of minutes allowed for the proxy session.</p>', 'UpdateProxySessionRequest$ExpiryMinutes' => '<p>The number of minutes allowed for the proxy session.</p>', ], ], 'Proxy' => [ 'base' => '<p>The proxy configuration for an Amazon Chime SDK Voice Connector.</p>', 'refs' => [ 'GetVoiceConnectorProxyResponse$Proxy' => '<p>The proxy configuration details.</p>', 'PutVoiceConnectorProxyResponse$Proxy' => '<p>The proxy configuration details.</p>', ], ], 'ProxySession' => [ 'base' => '<p>The proxy session for an Amazon Chime SDK Voice Connector.</p>', 'refs' => [ 'CreateProxySessionResponse$ProxySession' => '<p>The proxy session details.</p>', 'GetProxySessionResponse$ProxySession' => '<p>The proxy session details.</p>', 'ProxySessions$member' => NULL, 'UpdateProxySessionResponse$ProxySession' => '<p>The updated proxy session details.</p>', ], ], 'ProxySessionNameString' => [ 'base' => NULL, 'refs' => [ 'CreateProxySessionRequest$Name' => '<p>The name of the proxy session.</p>', ], ], 'ProxySessionStatus' => [ 'base' => NULL, 'refs' => [ 'ListProxySessionsRequest$Status' => '<p>The proxy session status.</p>', 'ProxySession$Status' => '<p>The proxy session status.</p>', ], ], 'ProxySessions' => [ 'base' => NULL, 'refs' => [ 'ListProxySessionsResponse$ProxySessions' => '<p>The proxy sessions\' details.</p>', ], ], 'PutSipMediaApplicationAlexaSkillConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutSipMediaApplicationAlexaSkillConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutSipMediaApplicationLoggingConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutSipMediaApplicationLoggingConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutVoiceConnectorEmergencyCallingConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutVoiceConnectorEmergencyCallingConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutVoiceConnectorLoggingConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutVoiceConnectorLoggingConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutVoiceConnectorOriginationRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutVoiceConnectorOriginationResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutVoiceConnectorProxyRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutVoiceConnectorProxyResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutVoiceConnectorStreamingConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutVoiceConnectorStreamingConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutVoiceConnectorTerminationCredentialsRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutVoiceConnectorTerminationRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutVoiceConnectorTerminationResponse' => [ 'base' => NULL, 'refs' => [], ], 'ResourceLimitExceededException' => [ 'base' => '<p>The request exceeds the resource limit.</p>', 'refs' => [], ], 'RestorePhoneNumberRequest' => [ 'base' => NULL, 'refs' => [], ], 'RestorePhoneNumberResponse' => [ 'base' => NULL, 'refs' => [], ], 'ResultMax' => [ 'base' => NULL, 'refs' => [ 'ListPhoneNumberOrdersRequest$MaxResults' => '<p>The maximum number of results to return in a single call.</p>', 'ListPhoneNumbersRequest$MaxResults' => '<p>The maximum number of results to return in a single call.</p>', 'ListProxySessionsRequest$MaxResults' => '<p>The maximum number of results to return in a single call.</p>', 'ListSipMediaApplicationsRequest$MaxResults' => '<p>The maximum number of results to return in a single call. Defaults to 100.</p>', 'ListSipRulesRequest$MaxResults' => '<p>The maximum number of results to return in a single call. Defaults to 100.</p>', 'ListVoiceConnectorGroupsRequest$MaxResults' => '<p>The maximum number of results to return in a single call. </p>', 'ListVoiceConnectorsRequest$MaxResults' => '<p>The maximum number of results to return in a single call.</p>', 'ListVoiceProfileDomainsRequest$MaxResults' => '<p>The maximum number of results to return in a single call.</p>', 'ListVoiceProfilesRequest$MaxResults' => '<p>The maximum number of results in the request.</p>', ], ], 'SMACreateCallArgumentsMap' => [ 'base' => NULL, 'refs' => [ 'CreateSipMediaApplicationCallRequest$ArgumentsMap' => '<p>Context passed to a CreateSipMediaApplication API call. For example, you could pass key-value pairs such as: <code>"FirstName": "John", "LastName": "Doe"</code> </p>', ], ], 'SMAUpdateCallArgumentsMap' => [ 'base' => NULL, 'refs' => [ 'UpdateSipMediaApplicationCallRequest$Arguments' => '<p>Arguments made available to the Lambda function as part of the <code>CALL_UPDATE_REQUESTED</code> event. Can contain 0-20 key-value pairs.</p>', ], ], 'SearchAvailablePhoneNumbersRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchAvailablePhoneNumbersResponse' => [ 'base' => NULL, 'refs' => [], ], 'SensitiveNonEmptyString' => [ 'base' => NULL, 'refs' => [ 'Address$streetName' => '<p>The address street, such as <code>8th Avenue</code>.</p>', 'Address$streetSuffix' => '<p>The address suffix, such as the <code>N</code> in <code>8th Avenue N</code>.</p>', 'Address$postDirectional' => '<p>An address suffix location, such as the <code>S. Unit A</code> in <code>Central Park S. Unit A</code>.</p>', 'Address$preDirectional' => '<p>An address prefix location, such as the <code>N</code> in <code>N. Third St.</code> </p>', 'Address$streetNumber' => '<p>The numeric portion of an address.</p>', 'Address$city' => '<p>The city of an address.</p>', 'Address$state' => '<p>The state of an address.</p>', 'Address$postalCode' => '<p>The postal code of an address.</p>', 'Address$postalCodePlus4' => '<p>The zip + 4 or postal code + 4 of an address.</p>', 'Address$country' => '<p>The country of an address.</p>', 'CandidateAddress$streetInfo' => '<p>The street information of the candidate address.</p>', 'CandidateAddress$streetNumber' => '<p>The numeric portion of the candidate address.</p>', 'CandidateAddress$city' => '<p>The city of the candidate address.</p>', 'CandidateAddress$state' => '<p>The state of the candidate address.</p>', 'CandidateAddress$postalCode' => '<p>The postal code of the candidate address.</p>', 'CandidateAddress$postalCodePlus4' => '<p>The zip + 4 or postal code +4 of the candidate address.</p>', 'CandidateAddress$country' => '<p>The country of the candidate address.</p>', 'DeletePhoneNumberRequest$PhoneNumberId' => '<p>The phone number ID.</p>', 'GetPhoneNumberRequest$PhoneNumberId' => '<p>The phone number ID.</p>', 'PhoneNumber$PhoneNumberId' => '<p>The phone number\'s ID.</p>', 'PhoneNumberError$PhoneNumberId' => '<p>The phone number ID for which the action failed.</p>', 'RestorePhoneNumberRequest$PhoneNumberId' => '<p>The ID of the phone number being restored.</p>', 'UpdatePhoneNumberRequest$PhoneNumberId' => '<p>The phone number ID.</p>', 'UpdatePhoneNumberRequestItem$PhoneNumberId' => '<p>The phone number ID to update.</p>', 'ValidateE911AddressRequest$StreetNumber' => '<p>The address street number, such as <code>200</code> or <code>2121</code>.</p>', 'ValidateE911AddressRequest$StreetInfo' => '<p>The address street information, such as <code>8th Avenue</code>.</p>', 'ValidateE911AddressRequest$City' => '<p>The address city, such as <code>Portland</code>.</p>', 'ValidateE911AddressRequest$State' => '<p>The address state, such as <code>ME</code>.</p>', 'ValidateE911AddressRequest$Country' => '<p>The country in the address being validated.</p>', 'ValidateE911AddressRequest$PostalCode' => '<p>The dress postal code, such <code>04352</code>.</p>', ], ], 'SensitiveString' => [ 'base' => NULL, 'refs' => [ 'Credential$Username' => '<p>The RFC2617 compliant user name associated with the SIP credentials, in US-ASCII format.</p>', 'Credential$Password' => '<p>The RFC2617 compliant password associated with the SIP credentials, in US-ASCII format.</p>', 'SMACreateCallArgumentsMap$key' => NULL, 'SMACreateCallArgumentsMap$value' => NULL, 'SMAUpdateCallArgumentsMap$key' => NULL, 'SMAUpdateCallArgumentsMap$value' => NULL, 'SensitiveStringList$member' => NULL, 'SipHeadersMap$key' => NULL, 'SipHeadersMap$value' => NULL, ], ], 'SensitiveStringList' => [ 'base' => NULL, 'refs' => [ 'DeleteVoiceConnectorTerminationCredentialsRequest$Usernames' => '<p>The RFC2617 compliant username associated with the SIP credentials, in US-ASCII format.</p>', 'ListVoiceConnectorTerminationCredentialsResponse$Usernames' => '<p>A list of user names.</p>', ], ], 'ServerSideEncryptionConfiguration' => [ 'base' => '<p>A structure that contains the configuration settings for server-side encryption.</p> <note> <p>We only support symmetric keys. Do not use asymmetric or HMAC keys, or KMS aliases.</p> </note>', 'refs' => [ 'CreateVoiceProfileDomainRequest$ServerSideEncryptionConfiguration' => '<p>The server-side encryption configuration for the request.</p>', 'VoiceProfileDomain$ServerSideEncryptionConfiguration' => '<p>A structure that contains the configuration settings for server-side encryption.</p>', ], ], 'ServiceFailureException' => [ 'base' => '<p>The service encountered an unexpected error.</p>', 'refs' => [], ], 'ServiceUnavailableException' => [ 'base' => '<p>The service is currently unavailable.</p>', 'refs' => [], ], 'SipApplicationPriority' => [ 'base' => NULL, 'refs' => [ 'SipRuleTargetApplication$Priority' => '<p>The priority setting of a rule\'s target SIP media application.</p>', ], ], 'SipHeadersMap' => [ 'base' => NULL, 'refs' => [ 'CreateSipMediaApplicationCallRequest$SipHeaders' => '<p>The SIP headers added to an outbound call leg.</p>', ], ], 'SipMediaApplication' => [ 'base' => '<p>The details of the SIP media application, including name and endpoints. An AWS account can have multiple SIP media applications.</p>', 'refs' => [ 'CreateSipMediaApplicationResponse$SipMediaApplication' => '<p>The SIP media application details.</p>', 'GetSipMediaApplicationResponse$SipMediaApplication' => '<p>The details of the SIP media application.</p>', 'SipMediaApplicationList$member' => NULL, 'UpdateSipMediaApplicationResponse$SipMediaApplication' => '<p>The updated SIP media application’s details.</p>', ], ], 'SipMediaApplicationAlexaSkillConfiguration' => [ 'base' => '<p>The Alexa Skill configuration of a SIP media application.</p> <important> <p>Due to changes made by the Amazon Alexa service, this data type is no longer available for use. For more information, refer to the <a href="https://developer.amazon.com/en-US/alexa/alexasmartproperties">Alexa Smart Properties</a> page.</p> </important>', 'refs' => [ 'GetSipMediaApplicationAlexaSkillConfigurationResponse$SipMediaApplicationAlexaSkillConfiguration' => '<p>Returns the Alexa Skill configuration.</p>', 'PutSipMediaApplicationAlexaSkillConfigurationRequest$SipMediaApplicationAlexaSkillConfiguration' => '<p>The Alexa Skill configuration.</p>', 'PutSipMediaApplicationAlexaSkillConfigurationResponse$SipMediaApplicationAlexaSkillConfiguration' => '<p>Returns the Alexa Skill configuration.</p>', ], ], 'SipMediaApplicationCall' => [ 'base' => '<p>A <code>Call</code> instance for a SIP media application.</p>', 'refs' => [ 'CreateSipMediaApplicationCallResponse$SipMediaApplicationCall' => '<p>The actual call.</p>', 'UpdateSipMediaApplicationCallResponse$SipMediaApplicationCall' => '<p>A <code>Call</code> instance for a SIP media application.</p>', ], ], 'SipMediaApplicationEndpoint' => [ 'base' => '<p>The endpoint assigned to a SIP media application.</p>', 'refs' => [ 'SipMediaApplicationEndpointList$member' => NULL, ], ], 'SipMediaApplicationEndpointList' => [ 'base' => NULL, 'refs' => [ 'CreateSipMediaApplicationRequest$Endpoints' => '<p>List of endpoints (Lambda ARNs) specified for the SIP media application.</p>', 'SipMediaApplication$Endpoints' => '<p>List of endpoints for a SIP media application. Currently, only one endpoint per SIP media application is permitted.</p>', 'UpdateSipMediaApplicationRequest$Endpoints' => '<p>The new set of endpoints for the specified SIP media application.</p>', ], ], 'SipMediaApplicationList' => [ 'base' => NULL, 'refs' => [ 'ListSipMediaApplicationsResponse$SipMediaApplications' => '<p>The list of SIP media applications and application details.</p>', ], ], 'SipMediaApplicationLoggingConfiguration' => [ 'base' => '<p>The logging configuration of a SIP media application.</p>', 'refs' => [ 'GetSipMediaApplicationLoggingConfigurationResponse$SipMediaApplicationLoggingConfiguration' => '<p>The actual logging configuration.</p>', 'PutSipMediaApplicationLoggingConfigurationRequest$SipMediaApplicationLoggingConfiguration' => '<p>The logging configuration for the specified SIP media application.</p>', 'PutSipMediaApplicationLoggingConfigurationResponse$SipMediaApplicationLoggingConfiguration' => '<p>The updated logging configuration for the specified SIP media application.</p>', ], ], 'SipMediaApplicationName' => [ 'base' => NULL, 'refs' => [ 'CreateSipMediaApplicationRequest$Name' => '<p>The SIP media application\'s name.</p>', 'SipMediaApplication$Name' => '<p>The SIP media application\'s name.</p>', 'UpdateSipMediaApplicationRequest$Name' => '<p>The new name for the specified SIP media application.</p>', ], ], 'SipRule' => [ 'base' => '<p>The details of a SIP rule, including name, triggers, and target applications. An AWS account can have multiple SIP rules.</p>', 'refs' => [ 'CreateSipRuleResponse$SipRule' => '<p>The SIP rule information, including the rule ID, triggers, and target applications.</p>', 'GetSipRuleResponse$SipRule' => '<p>The SIP rule details.</p>', 'SipRuleList$member' => NULL, 'UpdateSipRuleResponse$SipRule' => '<p>The updated SIP rule details.</p>', ], ], 'SipRuleList' => [ 'base' => NULL, 'refs' => [ 'ListSipRulesResponse$SipRules' => '<p>The list of SIP rules and details.</p>', ], ], 'SipRuleName' => [ 'base' => NULL, 'refs' => [ 'CreateSipRuleRequest$Name' => '<p>The name of the SIP rule.</p>', 'SipRule$Name' => '<p>A SIP rule\'s name.</p>', 'UpdateSipRuleRequest$Name' => '<p>The new name for the specified SIP rule.</p>', ], ], 'SipRuleTargetApplication' => [ 'base' => '<p>A target SIP media application and other details, such as priority and AWS Region, to be specified in the SIP rule. Only one SIP rule per AWS Region can be provided.</p>', 'refs' => [ 'SipRuleTargetApplicationList$member' => NULL, ], ], 'SipRuleTargetApplicationList' => [ 'base' => NULL, 'refs' => [ 'CreateSipRuleRequest$TargetApplications' => '<p>List of SIP media applications, with priority and AWS Region. Only one SIP application per AWS Region can be used.</p>', 'SipRule$TargetApplications' => '<p>The target SIP media application and other details, such as priority and AWS Region, to be specified in the SIP rule. Only one SIP rule per AWS Region can be provided.</p>', 'UpdateSipRuleRequest$TargetApplications' => '<p>The new list of target applications.</p>', ], ], 'SipRuleTriggerType' => [ 'base' => NULL, 'refs' => [ 'CreateSipRuleRequest$TriggerType' => '<p>The type of trigger assigned to the SIP rule in <code>TriggerValue</code>, currently <code>RequestUriHostname</code> or <code>ToPhoneNumber</code>.</p>', 'SipRule$TriggerType' => '<p>The type of trigger set for a SIP rule, either a phone number or a URI request host name.</p>', ], ], 'SpeakerSearchDetails' => [ 'base' => '<p>The details of a speaker search task.</p>', 'refs' => [ 'SpeakerSearchTask$SpeakerSearchDetails' => '<p>The details of a speaker search task.</p>', ], ], 'SpeakerSearchResult' => [ 'base' => '<p>The result of a speaker search analysis.</p>', 'refs' => [ 'SpeakerSearchResultList$member' => NULL, ], ], 'SpeakerSearchResultList' => [ 'base' => NULL, 'refs' => [ 'SpeakerSearchDetails$Results' => '<p>The result value in the speaker search details.</p>', ], ], 'SpeakerSearchTask' => [ 'base' => '<p>A representation of an asynchronous request to perform speaker search analysis on a Voice Connector call.</p>', 'refs' => [ 'GetSpeakerSearchTaskResponse$SpeakerSearchTask' => '<p>The details of the speaker search task.</p>', 'StartSpeakerSearchTaskResponse$SpeakerSearchTask' => '<p>The details of the speaker search task.</p>', ], ], 'StartSpeakerSearchTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartSpeakerSearchTaskResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartVoiceToneAnalysisTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartVoiceToneAnalysisTaskResponse' => [ 'base' => NULL, 'refs' => [], ], 'StopSpeakerSearchTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopVoiceToneAnalysisTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'StreamingConfiguration' => [ 'base' => '<p>The streaming configuration associated with an Amazon Chime SDK Voice Connector. Specifies whether media streaming is enabled for sending to Amazon Kinesis, and shows the retention period for the Amazon Kinesis data, in hours.</p>', 'refs' => [ 'GetVoiceConnectorStreamingConfigurationResponse$StreamingConfiguration' => '<p>The details of the streaming configuration.</p>', 'PutVoiceConnectorStreamingConfigurationRequest$StreamingConfiguration' => '<p>The streaming settings being updated.</p>', 'PutVoiceConnectorStreamingConfigurationResponse$StreamingConfiguration' => '<p>The updated streaming settings.</p>', ], ], 'StreamingNotificationTarget' => [ 'base' => '<p>The target recipient for a streaming configuration notification.</p>', 'refs' => [ 'StreamingNotificationTargetList$member' => NULL, ], ], 'StreamingNotificationTargetList' => [ 'base' => NULL, 'refs' => [ 'StreamingConfiguration$StreamingNotificationTargets' => '<p>The streaming notification targets.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'CreateSipMediaApplicationRequest$AwsRegion' => '<p>The AWS Region assigned to the SIP media application.</p>', 'ListPhoneNumberOrdersRequest$NextToken' => '<p>The token used to retrieve the next page of results.</p>', 'ListPhoneNumberOrdersResponse$NextToken' => '<p>The token used to retrieve the next page of results.</p>', 'ListPhoneNumbersRequest$Status' => '<p>The status of your organization\'s phone numbers.</p>', 'ListPhoneNumbersRequest$FilterValue' => '<p>The filter value.</p>', 'ListPhoneNumbersRequest$NextToken' => '<p>The token used to return the next page of results.</p>', 'ListPhoneNumbersResponse$NextToken' => '<p>The token used to return the next page of results.</p>', 'ListVoiceConnectorGroupsRequest$NextToken' => '<p>The token used to return the next page of results.</p>', 'ListVoiceConnectorGroupsResponse$NextToken' => '<p>The token used to return the next page of results.</p>', 'ListVoiceConnectorsRequest$NextToken' => '<p>The token used to return the next page of results.</p>', 'ListVoiceConnectorsResponse$NextToken' => '<p>The token used to return the next page of results.</p>', 'ListVoiceProfileDomainsRequest$NextToken' => '<p>The token used to return the next page of results.</p>', 'ListVoiceProfileDomainsResponse$NextToken' => '<p>The token used to return the next page of results.</p>', 'ListVoiceProfilesRequest$NextToken' => '<p>The token used to retrieve the next page of results.</p>', 'ListVoiceProfilesResponse$NextToken' => '<p>The token used to retrieve the next page of results.</p>', 'NonEmptyStringList$member' => NULL, 'OriginationRoute$Host' => '<p>The FQDN or IP address to contact for origination traffic.</p>', 'PhoneNumberAssociation$Value' => '<p>Contains the ID for the entity specified in Name.</p>', 'PhoneNumberError$ErrorMessage' => '<p>The error message.</p>', 'SearchAvailablePhoneNumbersRequest$AreaCode' => '<p>Confines a search to just the phone numbers associated with the specified area code.</p>', 'SearchAvailablePhoneNumbersRequest$City' => '<p>Confines a search to just the phone numbers associated with the specified city.</p>', 'SearchAvailablePhoneNumbersRequest$State' => '<p>Confines a search to just the phone numbers associated with the specified state.</p>', 'SearchAvailablePhoneNumbersRequest$NextToken' => '<p>The token used to return the next page of results.</p>', 'SearchAvailablePhoneNumbersResponse$NextToken' => '<p>The token used to return the next page of results.</p>', 'SipMediaApplication$AwsRegion' => '<p>The AWS Region in which the SIP media application is created.</p>', 'SipRuleTargetApplication$AwsRegion' => '<p>The AWS Region of a rule\'s target SIP media application.</p>', 'SpeakerSearchTask$StatusMessage' => '<p>A detailed message about the status of a speaker search.</p>', 'StringList$member' => NULL, 'TerminationHealth$Source' => '<p>The source IP address.</p>', 'ValidateE911AddressResponse$AddressExternalId' => '<p>The ID that represents the address.</p>', 'VoiceConnector$OutboundHostName' => '<p>The outbound host name for the Voice Connector.</p>', 'VoiceConnectorSettings$CdrBucket' => '<p>The S3 bucket that stores the Voice Connector\'s call detail records.</p>', 'VoiceToneAnalysisTask$StatusMessage' => '<p>The status of a voice tone analysis task.</p>', ], ], 'String128' => [ 'base' => NULL, 'refs' => [ 'ProxySession$Name' => '<p>The proxy session name.</p>', ], ], 'StringList' => [ 'base' => NULL, 'refs' => [ 'Proxy$PhoneNumberCountries' => '<p>The countries for proxy phone numbers to be selected from.</p>', 'Termination$CidrAllowedList' => '<p>The IP addresses allowed to make calls, in CIDR format.</p>', ], ], 'Tag' => [ 'base' => '<p>Describes a tag applied to a resource.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>The tag\'s key.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>The keys of the tags being removed from the resource.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateSipMediaApplicationRequest$Tags' => '<p>The tags assigned to the SIP media application.</p>', 'CreateVoiceConnectorRequest$Tags' => '<p>The tags assigned to the Voice Connector.</p>', 'CreateVoiceProfileDomainRequest$Tags' => '<p>The tags assigned to the domain.</p>', 'ListTagsForResourceResponse$Tags' => '<p>The tags in the list.</p>', 'TagResourceRequest$Tags' => '<p>A list of the tags being added to the resource.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The tag\'s value.</p>', ], ], 'Termination' => [ 'base' => '<p>Termination settings enable SIP hosts to make outbound calls using an Amazon Chime SDK Voice Connector.</p>', 'refs' => [ 'GetVoiceConnectorTerminationResponse$Termination' => '<p>The termination setting details.</p>', 'PutVoiceConnectorTerminationRequest$Termination' => '<p>The termination settings to be updated.</p>', 'PutVoiceConnectorTerminationResponse$Termination' => '<p>The updated termination settings.</p>', ], ], 'TerminationHealth' => [ 'base' => '<p>The termination health details, including the source IP address and timestamp of the last successful <code>SIP OPTIONS</code> message from your SIP infrastructure.</p>', 'refs' => [ 'GetVoiceConnectorTerminationHealthResponse$TerminationHealth' => '<p>The termination health details.</p>', ], ], 'ThrottledClientException' => [ 'base' => '<p>The number of customer requests exceeds the request rate limit.</p>', 'refs' => [], ], 'TollFreePrefix' => [ 'base' => NULL, 'refs' => [ 'SearchAvailablePhoneNumbersRequest$TollFreePrefix' => '<p>Confines a search to just the phone numbers associated with the specified toll-free prefix.</p>', ], ], 'UnauthorizedClientException' => [ 'base' => '<p>The client isn\'t authorized to request a resource.</p>', 'refs' => [], ], 'UnprocessableEntityException' => [ 'base' => '<p>A well-formed request couldn\'t be followed due to semantic errors.</p>', 'refs' => [], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGlobalSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePhoneNumberRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePhoneNumberRequestItem' => [ 'base' => '<p>The phone number ID, product type, or calling name fields to update, used with the <a>BatchUpdatePhoneNumber</a> and <a>UpdatePhoneNumber</a> actions.</p>', 'refs' => [ 'UpdatePhoneNumberRequestItemList$member' => NULL, ], ], 'UpdatePhoneNumberRequestItemList' => [ 'base' => NULL, 'refs' => [ 'BatchUpdatePhoneNumberRequest$UpdatePhoneNumberRequestItems' => '<p>Lists the phone numbers in the update request.</p>', ], ], 'UpdatePhoneNumberResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePhoneNumberSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateProxySessionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateProxySessionResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSipMediaApplicationCallRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSipMediaApplicationCallResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSipMediaApplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSipMediaApplicationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSipRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSipRuleResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateVoiceConnectorGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateVoiceConnectorGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateVoiceConnectorRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateVoiceConnectorResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateVoiceProfileDomainRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateVoiceProfileDomainResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateVoiceProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateVoiceProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'ValidateE911AddressRequest' => [ 'base' => NULL, 'refs' => [], ], 'ValidateE911AddressResponse' => [ 'base' => NULL, 'refs' => [], ], 'ValidationResult' => [ 'base' => NULL, 'refs' => [ 'ValidateE911AddressResponse$ValidationResult' => '<p>Number indicating the result of address validation. <code>0</code> means the address was perfect as-is and successfully validated. <code>1</code> means the address was corrected. <code>2</code> means the address sent was not close enough and was not validated.</p>', ], ], 'VoiceConnector' => [ 'base' => '<p>The Amazon Chime SDK Voice Connector configuration, including outbound host name and encryption settings.</p>', 'refs' => [ 'CreateVoiceConnectorResponse$VoiceConnector' => '<p>The details of the Voice Connector.</p>', 'GetVoiceConnectorResponse$VoiceConnector' => '<p>The Voice Connector details.</p>', 'UpdateVoiceConnectorResponse$VoiceConnector' => '<p>The updated Voice Connector details.</p>', 'VoiceConnectorList$member' => NULL, ], ], 'VoiceConnectorAwsRegion' => [ 'base' => NULL, 'refs' => [ 'CreateVoiceConnectorRequest$AwsRegion' => '<p>The AWS Region in which the Amazon Chime SDK Voice Connector is created. Default value: <code>us-east-1</code> .</p>', 'VoiceConnector$AwsRegion' => '<p>The AWS Region in which the Voice Connector is created. Default: us-east-1.</p>', 'VoiceConnectorAwsRegionList$member' => NULL, ], ], 'VoiceConnectorAwsRegionList' => [ 'base' => NULL, 'refs' => [ 'ListAvailableVoiceConnectorRegionsResponse$VoiceConnectorRegions' => '<p>The list of AWS Regions.</p>', ], ], 'VoiceConnectorGroup' => [ 'base' => '<p>The Amazon Chime SDK Voice Connector group configuration, including associated Voice Connectors. You can include Voice Connectors from different AWS Regions in a group. This creates a fault tolerant mechanism for fallback in case of availability events.</p>', 'refs' => [ 'CreateVoiceConnectorGroupResponse$VoiceConnectorGroup' => '<p>The details of the Voice Connector group.</p>', 'GetVoiceConnectorGroupResponse$VoiceConnectorGroup' => '<p>The details of the Voice Connector group.</p>', 'UpdateVoiceConnectorGroupResponse$VoiceConnectorGroup' => '<p>The updated Voice Connector group.</p>', 'VoiceConnectorGroupList$member' => NULL, ], ], 'VoiceConnectorGroupList' => [ 'base' => NULL, 'refs' => [ 'ListVoiceConnectorGroupsResponse$VoiceConnectorGroups' => '<p>The details of the Voice Connector groups.</p>', ], ], 'VoiceConnectorGroupName' => [ 'base' => NULL, 'refs' => [ 'CreateVoiceConnectorGroupRequest$Name' => '<p>The name of the Voice Connector group.</p>', 'UpdateVoiceConnectorGroupRequest$Name' => '<p>The name of the Voice Connector group.</p>', 'VoiceConnectorGroup$Name' => '<p>The name of a Voice Connector group.</p>', ], ], 'VoiceConnectorItem' => [ 'base' => '<p>For Amazon Chime SDK Voice Connector groups, the Amazon Chime SDK Voice Connectors to which you route inbound calls. Includes priority configuration settings. Limit: 3 VoiceConnectorItems per Voice Connector group.</p>', 'refs' => [ 'VoiceConnectorItemList$member' => NULL, ], ], 'VoiceConnectorItemList' => [ 'base' => NULL, 'refs' => [ 'CreateVoiceConnectorGroupRequest$VoiceConnectorItems' => '<p>Lists the Voice Connectors that inbound calls are routed to.</p>', 'UpdateVoiceConnectorGroupRequest$VoiceConnectorItems' => '<p>The <code>VoiceConnectorItems</code> to associate with the Voice Connector group.</p>', 'VoiceConnectorGroup$VoiceConnectorItems' => '<p>The Voice Connectors to which you route inbound calls.</p>', ], ], 'VoiceConnectorItemPriority' => [ 'base' => NULL, 'refs' => [ 'VoiceConnectorItem$Priority' => '<p>The priority setting of a Voice Connector item. Calls are routed to hosts in priority order, with 1 as the highest priority. When hosts have equal priority, the system distributes calls among them based on their relative weight.</p>', ], ], 'VoiceConnectorList' => [ 'base' => NULL, 'refs' => [ 'ListVoiceConnectorsResponse$VoiceConnectors' => '<p>The details of the Voice Connectors.</p>', ], ], 'VoiceConnectorName' => [ 'base' => NULL, 'refs' => [ 'CreateVoiceConnectorRequest$Name' => '<p>The name of the Voice Connector.</p>', 'UpdateVoiceConnectorRequest$Name' => '<p>The name of the Voice Connector.</p>', 'VoiceConnector$Name' => '<p>The Voice Connector\'s name.</p>', ], ], 'VoiceConnectorSettings' => [ 'base' => '<p>The Amazon Chime SDK Voice Connector settings. Includes any Amazon S3 buckets designated for storing call detail records.</p>', 'refs' => [ 'GetGlobalSettingsResponse$VoiceConnector' => '<p>The Voice Connector settings.</p>', 'UpdateGlobalSettingsRequest$VoiceConnector' => '<p>The Voice Connector settings.</p>', ], ], 'VoiceProfile' => [ 'base' => '<p>The combination of a voice print and caller ID.</p>', 'refs' => [ 'CreateVoiceProfileResponse$VoiceProfile' => '<p>The requested voice profile.</p>', 'GetVoiceProfileResponse$VoiceProfile' => '<p>The voice profile details.</p>', 'UpdateVoiceProfileResponse$VoiceProfile' => '<p>The updated voice profile settings.</p>', ], ], 'VoiceProfileDomain' => [ 'base' => '<p>A collection of voice profiles.</p>', 'refs' => [ 'CreateVoiceProfileDomainResponse$VoiceProfileDomain' => '<p>The requested voice profile domain.</p>', 'GetVoiceProfileDomainResponse$VoiceProfileDomain' => '<p>The details of the voice profile domain.</p>', 'UpdateVoiceProfileDomainResponse$VoiceProfileDomain' => '<p>The updated details of the voice profile domain.</p>', ], ], 'VoiceProfileDomainDescription' => [ 'base' => NULL, 'refs' => [ 'CreateVoiceProfileDomainRequest$Description' => '<p>A description of the voice profile domain.</p>', 'UpdateVoiceProfileDomainRequest$Description' => '<p>The description of the voice profile domain.</p>', 'VoiceProfileDomain$Description' => '<p>The description of the voice profile domain.</p>', 'VoiceProfileDomainSummary$Description' => '<p>Describes the voice profile domain summary.</p>', ], ], 'VoiceProfileDomainName' => [ 'base' => NULL, 'refs' => [ 'CreateVoiceProfileDomainRequest$Name' => '<p>The name of the voice profile domain.</p>', 'UpdateVoiceProfileDomainRequest$Name' => '<p>The name of the voice profile domain.</p>', 'VoiceProfileDomain$Name' => '<p>The name of the voice profile domain.</p>', 'VoiceProfileDomainSummary$Name' => '<p>The name of the voice profile domain summary.</p>', ], ], 'VoiceProfileDomainSummary' => [ 'base' => '<p>A high-level overview of a voice profile domain.</p>', 'refs' => [ 'VoiceProfileDomainSummaryList$member' => NULL, ], ], 'VoiceProfileDomainSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListVoiceProfileDomainsResponse$VoiceProfileDomains' => '<p>The list of voice profile domains.</p>', ], ], 'VoiceProfileSummary' => [ 'base' => '<p>A high-level summary of a voice profile.</p>', 'refs' => [ 'VoiceProfileSummaryList$member' => NULL, ], ], 'VoiceProfileSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListVoiceProfilesResponse$VoiceProfiles' => '<p>The list of voice profiles.</p>', ], ], 'VoiceToneAnalysisTask' => [ 'base' => '<p>A representation of an asynchronous request to perform voice tone analysis on a Voice Connector call.</p>', 'refs' => [ 'GetVoiceToneAnalysisTaskResponse$VoiceToneAnalysisTask' => '<p>The details of the voice tone analysis task.</p>', 'StartVoiceToneAnalysisTaskResponse$VoiceToneAnalysisTask' => '<p>The details of the voice tone analysis task.</p>', ], ], ],];
