<?php
// This file was auto-generated from sdk-root/src/data/cleanrooms/2022-02-17/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Welcome to the <i>Clean Rooms API Reference</i>.</p> <p>Clean Rooms is an Amazon Web Services service that helps multiple parties to join their data together in a secure collaboration workspace. In the collaboration, members who can query and receive results can get insights into the collective datasets without either party getting access to the other party\'s raw data.</p> <p>To learn more about Clean Rooms concepts, procedures, and best practices, see the <a href="https://docs.aws.amazon.com/clean-rooms/latest/userguide/what-is.html">Clean Rooms User Guide</a>.</p> <p>To learn more about SQL commands, functions, and conditions supported in Clean Rooms, see the <a href="https://docs.aws.amazon.com/clean-rooms/latest/sql-reference/sql-reference.html">Clean Rooms SQL Reference</a>.</p>', 'operations' => [ 'BatchGetCollaborationAnalysisTemplate' => '<p>Retrieves multiple analysis templates within a collaboration by their Amazon Resource Names (ARNs).</p>', 'BatchGetSchema' => '<p>Retrieves multiple schemas by their identifiers.</p>', 'BatchGetSchemaAnalysisRule' => '<p>Retrieves multiple analysis rule schemas.</p>', 'CreateAnalysisTemplate' => '<p>Creates a new analysis template.</p>', 'CreateCollaboration' => '<p>Creates a new collaboration.</p>', 'CreateConfiguredAudienceModelAssociation' => '<p>Provides the details necessary to create a configured audience model association.</p>', 'CreateConfiguredTable' => '<p>Creates a new configured table resource.</p>', 'CreateConfiguredTableAnalysisRule' => '<p>Creates a new analysis rule for a configured table. Currently, only one analysis rule can be created for a given configured table.</p>', 'CreateConfiguredTableAssociation' => '<p>Creates a configured table association. A configured table association links a configured table with a collaboration.</p>', 'CreateMembership' => '<p>Creates a membership for a specific collaboration identifier and joins the collaboration.</p>', 'CreatePrivacyBudgetTemplate' => '<p>Creates a privacy budget template for a specified membership. Each membership can have only one privacy budget template, but it can be deleted and recreated. If you need to change the privacy budget template for a membership, use the <a>UpdatePrivacyBudgetTemplate</a> operation.</p>', 'DeleteAnalysisTemplate' => '<p>Deletes an analysis template.</p>', 'DeleteCollaboration' => '<p>Deletes a collaboration. It can only be called by the collaboration owner.</p>', 'DeleteConfiguredAudienceModelAssociation' => '<p>Provides the information necessary to delete a configured audience model association.</p>', 'DeleteConfiguredTable' => '<p>Deletes a configured table.</p>', 'DeleteConfiguredTableAnalysisRule' => '<p>Deletes a configured table analysis rule.</p>', 'DeleteConfiguredTableAssociation' => '<p>Deletes a configured table association.</p>', 'DeleteMember' => '<p>Removes the specified member from a collaboration. The removed member is placed in the Removed status and can\'t interact with the collaboration. The removed member\'s data is inaccessible to active members of the collaboration.</p>', 'DeleteMembership' => '<p>Deletes a specified membership. All resources under a membership must be deleted.</p>', 'DeletePrivacyBudgetTemplate' => '<p>Deletes a privacy budget template for a specified membership.</p>', 'GetAnalysisTemplate' => '<p>Retrieves an analysis template.</p>', 'GetCollaboration' => '<p>Returns metadata about a collaboration.</p>', 'GetCollaborationAnalysisTemplate' => '<p>Retrieves an analysis template within a collaboration.</p>', 'GetCollaborationConfiguredAudienceModelAssociation' => '<p>Retrieves a configured audience model association within a collaboration.</p>', 'GetCollaborationPrivacyBudgetTemplate' => '<p>Returns details about a specified privacy budget template.</p>', 'GetConfiguredAudienceModelAssociation' => '<p>Returns information about a configured audience model association.</p>', 'GetConfiguredTable' => '<p>Retrieves a configured table.</p>', 'GetConfiguredTableAnalysisRule' => '<p>Retrieves a configured table analysis rule.</p>', 'GetConfiguredTableAssociation' => '<p>Retrieves a configured table association.</p>', 'GetMembership' => '<p>Retrieves a specified membership for an identifier.</p>', 'GetPrivacyBudgetTemplate' => '<p>Returns details for a specified privacy budget template.</p>', 'GetProtectedQuery' => '<p>Returns query processing metadata.</p>', 'GetSchema' => '<p>Retrieves the schema for a relation within a collaboration.</p>', 'GetSchemaAnalysisRule' => '<p>Retrieves a schema analysis rule.</p>', 'ListAnalysisTemplates' => '<p>Lists analysis templates that the caller owns.</p>', 'ListCollaborationAnalysisTemplates' => '<p>Lists analysis templates within a collaboration.</p>', 'ListCollaborationConfiguredAudienceModelAssociations' => '<p>Lists configured audience model associations within a collaboration.</p>', 'ListCollaborationPrivacyBudgetTemplates' => '<p>Returns an array that summarizes each privacy budget template in a specified collaboration.</p>', 'ListCollaborationPrivacyBudgets' => '<p>Returns an array that summarizes each privacy budget in a specified collaboration. The summary includes the collaboration ARN, creation time, creating account, and privacy budget details.</p>', 'ListCollaborations' => '<p>Lists collaborations the caller owns, is active in, or has been invited to.</p>', 'ListConfiguredAudienceModelAssociations' => '<p>Lists information about requested configured audience model associations.</p>', 'ListConfiguredTableAssociations' => '<p>Lists configured table associations for a membership.</p>', 'ListConfiguredTables' => '<p>Lists configured tables.</p>', 'ListMembers' => '<p>Lists all members within a collaboration.</p>', 'ListMemberships' => '<p>Lists all memberships resources within the caller\'s account.</p>', 'ListPrivacyBudgetTemplates' => '<p>Returns detailed information about the privacy budget templates in a specified membership.</p>', 'ListPrivacyBudgets' => '<p>Returns detailed information about the privacy budgets in a specified membership.</p>', 'ListProtectedQueries' => '<p>Lists protected queries, sorted by the most recent query.</p>', 'ListSchemas' => '<p>Lists the schemas for relations within a collaboration.</p>', 'ListTagsForResource' => '<p>Lists all of the tags that have been added to a resource.</p>', 'PreviewPrivacyImpact' => '<p>An estimate of the number of aggregation functions that the member who can query can run given epsilon and noise parameters.</p>', 'StartProtectedQuery' => '<p>Creates a protected query that is started by Clean Rooms.</p>', 'TagResource' => '<p>Tags a resource.</p>', 'UntagResource' => '<p>Removes a tag or list of tags from a resource.</p>', 'UpdateAnalysisTemplate' => '<p>Updates the analysis template metadata.</p>', 'UpdateCollaboration' => '<p>Updates collaboration metadata and can only be called by the collaboration owner.</p>', 'UpdateConfiguredAudienceModelAssociation' => '<p>Provides the details necessary to update a configured audience model association.</p>', 'UpdateConfiguredTable' => '<p>Updates a configured table.</p>', 'UpdateConfiguredTableAnalysisRule' => '<p>Updates a configured table analysis rule.</p>', 'UpdateConfiguredTableAssociation' => '<p>Updates a configured table association.</p>', 'UpdateMembership' => '<p>Updates a membership.</p>', 'UpdatePrivacyBudgetTemplate' => '<p>Updates the privacy budget template for the specified membership.</p>', 'UpdateProtectedQuery' => '<p>Updates the processing of a currently running query.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>Caller does not have sufficient access to perform this action.</p>', 'refs' => [], ], 'AccessDeniedExceptionReason' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$reason' => '<p>A reason code for the exception.</p>', ], ], 'AccountId' => [ 'base' => NULL, 'refs' => [ 'AnalysisRuleCustomAllowedAnalysisProvidersList$member' => NULL, 'Collaboration$creatorAccountId' => '<p>The identifier used to reference members of the collaboration. Currently only supports Amazon Web Services account ID.</p>', 'CollaborationAnalysisTemplate$creatorAccountId' => '<p>The identifier used to reference members of the collaboration. Currently only supports Amazon Web Services account ID.</p>', 'CollaborationAnalysisTemplateSummary$creatorAccountId' => '<p>The identifier used to reference members of the collaboration. Currently only supports Amazon Web Services account ID.</p>', 'CollaborationConfiguredAudienceModelAssociation$creatorAccountId' => '<p>The identifier used to reference members of the collaboration. Only supports AWS account ID.</p>', 'CollaborationConfiguredAudienceModelAssociationSummary$creatorAccountId' => '<p>The identifier used to reference members of the collaboration. Only supports AWS account ID.</p>', 'CollaborationPrivacyBudgetSummary$creatorAccountId' => '<p>The unique identifier of the account that created this privacy budget.</p>', 'CollaborationPrivacyBudgetTemplate$creatorAccountId' => '<p>The unique identifier of the account that created this collaboration privacy budget template.</p>', 'CollaborationPrivacyBudgetTemplateSummary$creatorAccountId' => '<p>The unique identifier of the account that created this collaboration privacy budget template.</p>', 'CollaborationSummary$creatorAccountId' => '<p>The identifier used to reference members of the collaboration. Currently only supports Amazon Web Services account ID.</p>', 'DeleteMemberInput$accountId' => '<p>The account ID of the member to remove.</p>', 'MemberSpecification$accountId' => '<p>The identifier used to reference members of the collaboration. Currently only supports Amazon Web Services account ID.</p>', 'MemberSummary$accountId' => '<p>The identifier used to reference members of the collaboration. Currently only supports Amazon Web Services account ID.</p>', 'Membership$collaborationCreatorAccountId' => '<p>The identifier used to reference members of the collaboration. Currently only supports Amazon Web Services account ID.</p>', 'MembershipSummary$collaborationCreatorAccountId' => '<p>The identifier of the Amazon Web Services principal that created the collaboration. Currently only supports Amazon Web Services account ID.</p>', 'ProtectedQuerySingleMemberOutput$accountId' => '<p>The Amazon Web Services account ID of the member in the collaboration who can receive results for the query.</p>', 'Schema$creatorAccountId' => '<p>The unique account ID for the Amazon Web Services account that owns the schema.</p>', 'SchemaSummary$creatorAccountId' => '<p>The unique account ID for the Amazon Web Services account that owns the schema.</p>', ], ], 'AggregateColumn' => [ 'base' => '<p>Column in configured table that can be used in aggregate function in query.</p>', 'refs' => [ 'AnalysisRuleAggregationAggregateColumnsList$member' => NULL, ], ], 'AggregateColumnColumnNamesList' => [ 'base' => NULL, 'refs' => [ 'AggregateColumn$columnNames' => '<p>Column names in configured table of aggregate columns.</p>', ], ], 'AggregateFunctionName' => [ 'base' => NULL, 'refs' => [ 'AggregateColumn$function' => '<p>Aggregation function that can be applied to aggregate column in query.</p>', ], ], 'AggregationConstraint' => [ 'base' => '<p>Constraint on query output removing output rows that do not meet a minimum number of distinct values of a specified column.</p>', 'refs' => [ 'AggregationConstraints$member' => NULL, ], ], 'AggregationConstraintMinimumInteger' => [ 'base' => NULL, 'refs' => [ 'AggregationConstraint$minimum' => '<p>The minimum number of distinct values that an output row must be an aggregation of. Minimum threshold of distinct values for a specified column that must exist in an output row for it to be in the query output.</p>', ], ], 'AggregationConstraints' => [ 'base' => NULL, 'refs' => [ 'AnalysisRuleAggregation$outputConstraints' => '<p>Columns that must meet a specific threshold value (after an aggregation function is applied to it) for each output row to be returned.</p>', ], ], 'AggregationType' => [ 'base' => NULL, 'refs' => [ 'AggregationConstraint$type' => '<p>The type of aggregation the constraint allows. The only valid value is currently `COUNT_DISTINCT`.</p>', ], ], 'AllowedColumnList' => [ 'base' => NULL, 'refs' => [ 'ConfiguredTable$allowedColumns' => '<p>The columns within the underlying Glue table that can be utilized within collaborations.</p>', 'CreateConfiguredTableInput$allowedColumns' => '<p>The columns of the underlying table that can be used by collaborations or analysis rules.</p>', ], ], 'AnalysisFormat' => [ 'base' => NULL, 'refs' => [ 'AnalysisTemplate$format' => '<p>The format of the analysis template.</p>', 'CollaborationAnalysisTemplate$format' => '<p>The format of the analysis template in the collaboration.</p>', 'CreateAnalysisTemplateInput$format' => '<p>The format of the analysis template.</p>', ], ], 'AnalysisMethod' => [ 'base' => NULL, 'refs' => [ 'ConfiguredTable$analysisMethod' => '<p>The analysis method for the configured table. The only valid value is currently `DIRECT_QUERY`.</p>', 'ConfiguredTableSummary$analysisMethod' => '<p>The analysis method for the configured tables. The only valid value is currently `DIRECT_QUERY`.</p>', 'CreateConfiguredTableInput$analysisMethod' => '<p>The analysis method for the configured tables. The only valid value is currently `DIRECT_QUERY`.</p>', 'Schema$analysisMethod' => '<p>The analysis method for the schema. The only valid value is currently DIRECT_QUERY.</p>', 'SchemaSummary$analysisMethod' => '<p>The analysis method for the associated schema. The only valid value is currently `DIRECT_QUERY`.</p>', ], ], 'AnalysisParameter' => [ 'base' => '<p>Optional. The member who can query can provide this placeholder for a literal data value in an analysis template.</p>', 'refs' => [ 'AnalysisParameterList$member' => NULL, ], ], 'AnalysisParameterList' => [ 'base' => NULL, 'refs' => [ 'AnalysisTemplate$analysisParameters' => '<p>The parameters of the analysis template.</p>', 'CollaborationAnalysisTemplate$analysisParameters' => '<p>The analysis parameters that have been specified in the analysis template.</p>', 'CreateAnalysisTemplateInput$analysisParameters' => '<p>The parameters of the analysis template.</p>', ], ], 'AnalysisRule' => [ 'base' => '<p>A specification about how data from the configured table can be used in a query.</p>', 'refs' => [ 'GetSchemaAnalysisRuleOutput$analysisRule' => '<p>A specification about how data from the configured table can be used.</p>', 'SchemaAnalysisRuleList$member' => NULL, ], ], 'AnalysisRuleAggregation' => [ 'base' => '<p>A type of analysis rule that enables query structure and specified queries that produce aggregate statistics.</p>', 'refs' => [ 'AnalysisRulePolicyV1$aggregation' => '<p>Analysis rule type that enables only aggregation queries on a configured table.</p>', 'ConfiguredTableAnalysisRulePolicyV1$aggregation' => '<p>Analysis rule type that enables only aggregation queries on a configured table.</p>', ], ], 'AnalysisRuleAggregationAggregateColumnsList' => [ 'base' => NULL, 'refs' => [ 'AnalysisRuleAggregation$aggregateColumns' => '<p>The columns that query runners are allowed to use in aggregation queries.</p>', ], ], 'AnalysisRuleColumnList' => [ 'base' => NULL, 'refs' => [ 'AnalysisRuleAggregation$joinColumns' => '<p>Columns in configured table that can be used in join statements and/or as aggregate columns. They can never be outputted directly.</p>', 'AnalysisRuleAggregation$dimensionColumns' => '<p>The columns that query runners are allowed to select, group by, or filter by.</p>', 'AnalysisRuleList$listColumns' => '<p>Columns that can be listed in the output.</p>', ], ], 'AnalysisRuleColumnName' => [ 'base' => NULL, 'refs' => [ 'AggregateColumnColumnNamesList$member' => NULL, 'AggregationConstraint$columnName' => '<p>Column in aggregation constraint for which there must be a minimum number of distinct values in an output row for it to be in the query output.</p>', 'AnalysisRuleColumnList$member' => NULL, 'AnalysisRuleListJoinColumnsList$member' => NULL, ], ], 'AnalysisRuleCustom' => [ 'base' => '<p>A type of analysis rule that enables the table owner to approve custom SQL queries on their configured tables. It supports differential privacy.</p>', 'refs' => [ 'AnalysisRulePolicyV1$custom' => '<p>Analysis rule type that enables custom SQL queries on a configured table.</p>', 'ConfiguredTableAnalysisRulePolicyV1$custom' => NULL, ], ], 'AnalysisRuleCustomAllowedAnalysesList' => [ 'base' => NULL, 'refs' => [ 'AnalysisRuleCustom$allowedAnalyses' => '<p>The ARN of the analysis templates that are allowed by the custom analysis rule.</p>', ], ], 'AnalysisRuleCustomAllowedAnalysisProvidersList' => [ 'base' => NULL, 'refs' => [ 'AnalysisRuleCustom$allowedAnalysisProviders' => '<p>The IDs of the Amazon Web Services accounts that are allowed to query by the custom analysis rule. Required when <code>allowedAnalyses</code> is <code>ANY_QUERY</code>.</p>', ], ], 'AnalysisRuleList' => [ 'base' => '<p>A type of analysis rule that enables row-level analysis.</p>', 'refs' => [ 'AnalysisRulePolicyV1$list' => '<p>Analysis rule type that enables only list queries on a configured table.</p>', 'ConfiguredTableAnalysisRulePolicyV1$list' => '<p>Analysis rule type that enables only list queries on a configured table.</p>', ], ], 'AnalysisRuleListJoinColumnsList' => [ 'base' => NULL, 'refs' => [ 'AnalysisRuleList$joinColumns' => '<p>Columns that can be used to join a configured table with the table of the member who can query and other members\' configured tables.</p>', ], ], 'AnalysisRulePolicy' => [ 'base' => '<p>Controls on the query specifications that can be run on configured table.</p>', 'refs' => [ 'AnalysisRule$policy' => '<p>A policy that describes the associated data usage limitations.</p>', ], ], 'AnalysisRulePolicyV1' => [ 'base' => '<p>Controls on the query specifications that can be run on configured table.</p>', 'refs' => [ 'AnalysisRulePolicy$v1' => '<p>Controls on the query specifications that can be run on configured table.</p>', ], ], 'AnalysisRuleType' => [ 'base' => NULL, 'refs' => [ 'AnalysisRule$type' => '<p>The type of analysis rule.</p>', 'AnalysisRuleTypeList$member' => NULL, 'BatchGetSchemaAnalysisRuleError$type' => '<p>The analysis rule type.</p>', 'GetSchemaAnalysisRuleInput$type' => '<p>The type of the schema analysis rule to retrieve. Schema analysis rules are uniquely identified by a combination of the collaboration, the schema name, and their type.</p>', 'SchemaAnalysisRuleRequest$type' => '<p>The type of analysis rule schema that you are requesting.</p>', 'SchemaStatusDetail$analysisRuleType' => '<p>The analysis rule type for which the schema status has been evaluated.</p>', ], ], 'AnalysisRuleTypeList' => [ 'base' => NULL, 'refs' => [ 'Schema$analysisRuleTypes' => '<p>The analysis rule types associated with the schema. Currently, only one entry is present.</p>', 'SchemaSummary$analysisRuleTypes' => '<p>The types of analysis rules that are associated with this schema object.</p>', ], ], 'AnalysisSchema' => [ 'base' => '<p>A relation within an analysis.</p>', 'refs' => [ 'AnalysisTemplate$schema' => '<p>The entire schema object.</p>', 'CollaborationAnalysisTemplate$schema' => '<p>The entire schema object.</p>', ], ], 'AnalysisSource' => [ 'base' => '<p>The structure that defines the body of the analysis template.</p>', 'refs' => [ 'AnalysisTemplate$source' => '<p>The source of the analysis template.</p>', 'CollaborationAnalysisTemplate$source' => '<p>The source of the analysis template within a collaboration.</p>', 'CreateAnalysisTemplateInput$source' => '<p>The information in the analysis template. Currently supports <code>text</code>, the query text for the analysis template.</p>', ], ], 'AnalysisTemplate' => [ 'base' => '<p>The analysis template.</p>', 'refs' => [ 'CreateAnalysisTemplateOutput$analysisTemplate' => '<p>The analysis template.</p>', 'GetAnalysisTemplateOutput$analysisTemplate' => '<p>The analysis template.</p>', 'UpdateAnalysisTemplateOutput$analysisTemplate' => '<p>The analysis template.</p>', ], ], 'AnalysisTemplateArn' => [ 'base' => NULL, 'refs' => [ 'AnalysisTemplate$arn' => '<p>The Amazon Resource Name (ARN) of the analysis template.</p>', 'AnalysisTemplateArnList$member' => NULL, 'AnalysisTemplateSummary$arn' => '<p>The Amazon Resource Name (ARN) of the analysis template.</p>', 'BatchGetCollaborationAnalysisTemplateError$arn' => '<p>The Amazon Resource Name (ARN) of the analysis template.</p>', 'CollaborationAnalysisTemplate$arn' => '<p>The Amazon Resource Name (ARN) of the analysis template.</p>', 'CollaborationAnalysisTemplateSummary$arn' => '<p>The Amazon Resource Name (ARN) of the analysis template.</p>', 'GetCollaborationAnalysisTemplateInput$analysisTemplateArn' => '<p>The Amazon Resource Name (ARN) associated with the analysis template within a collaboration.</p>', 'ProtectedQuerySQLParameters$analysisTemplateArn' => '<p>The Amazon Resource Name (ARN) associated with the analysis template within a collaboration.</p>', ], ], 'AnalysisTemplateArnList' => [ 'base' => NULL, 'refs' => [ 'BatchGetCollaborationAnalysisTemplateInput$analysisTemplateArns' => '<p>The Amazon Resource Name (ARN) associated with the analysis template within a collaboration.</p>', ], ], 'AnalysisTemplateArnOrQueryWildcard' => [ 'base' => NULL, 'refs' => [ 'AnalysisRuleCustomAllowedAnalysesList$member' => NULL, ], ], 'AnalysisTemplateIdentifier' => [ 'base' => NULL, 'refs' => [ 'AnalysisTemplate$id' => '<p>The identifier for the analysis template.</p>', 'AnalysisTemplateSummary$id' => '<p>The identifier of the analysis template.</p>', 'CollaborationAnalysisTemplate$id' => '<p>The identifier of the analysis template.</p>', 'CollaborationAnalysisTemplateSummary$id' => '<p>The identifier of the analysis template.</p>', 'DeleteAnalysisTemplateInput$analysisTemplateIdentifier' => '<p>The identifier for the analysis template resource.</p>', 'GetAnalysisTemplateInput$analysisTemplateIdentifier' => '<p>The identifier for the analysis template resource.</p>', 'UpdateAnalysisTemplateInput$analysisTemplateIdentifier' => '<p>The identifier for the analysis template resource.</p>', ], ], 'AnalysisTemplateSummary' => [ 'base' => '<p>The metadata of the analysis template.</p>', 'refs' => [ 'AnalysisTemplateSummaryList$member' => NULL, ], ], 'AnalysisTemplateSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListAnalysisTemplatesOutput$analysisTemplateSummaries' => '<p>Lists analysis template metadata.</p>', ], ], 'AnalysisTemplateText' => [ 'base' => NULL, 'refs' => [ 'AnalysisSource$text' => '<p>The query text.</p>', ], ], 'AnalysisTemplateValidationStatus' => [ 'base' => NULL, 'refs' => [ 'AnalysisTemplateValidationStatusDetail$status' => '<p>The status of the validation.</p>', ], ], 'AnalysisTemplateValidationStatusDetail' => [ 'base' => '<p>The status details of the analysis template validation. Clean Rooms Differential Privacy uses a general-purpose query structure to support complex SQL queries and validates whether an analysis template fits that general-purpose query structure. Validation is performed when analysis templates are created and fetched. Because analysis templates are immutable by design, we recommend that you create analysis templates after you associate the configured tables with their analysis rule to your collaboration.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/clean-rooms/latest/userguide/analysis-rules-custom.html#custom-diff-privacy">https://docs.aws.amazon.com/clean-rooms/latest/userguide/analysis-rules-custom.html#custom-diff-privacy</a>.</p>', 'refs' => [ 'AnalysisTemplateValidationStatusDetailList$member' => NULL, ], ], 'AnalysisTemplateValidationStatusDetailList' => [ 'base' => NULL, 'refs' => [ 'AnalysisTemplate$validations' => '<p>Information about the validations performed on the analysis template.</p>', 'CollaborationAnalysisTemplate$validations' => '<p>The validations that were performed.</p>', ], ], 'AnalysisTemplateValidationStatusReason' => [ 'base' => '<p>The reasons for the validation results.</p>', 'refs' => [ 'AnalysisTemplateValidationStatusReasonList$member' => NULL, ], ], 'AnalysisTemplateValidationStatusReasonList' => [ 'base' => NULL, 'refs' => [ 'AnalysisTemplateValidationStatusDetail$reasons' => '<p>The reasons for the validation results.</p>', ], ], 'AnalysisTemplateValidationType' => [ 'base' => NULL, 'refs' => [ 'AnalysisTemplateValidationStatusDetail$type' => '<p>The type of validation that was performed.</p>', ], ], 'BatchGetCollaborationAnalysisTemplateError' => [ 'base' => '<p>Details of errors thrown by the call to retrieve multiple analysis templates within a collaboration by their identifiers.</p>', 'refs' => [ 'BatchGetCollaborationAnalysisTemplateErrorList$member' => NULL, ], ], 'BatchGetCollaborationAnalysisTemplateErrorList' => [ 'base' => NULL, 'refs' => [ 'BatchGetCollaborationAnalysisTemplateOutput$errors' => '<p>Error reasons for collaboration analysis templates that could not be retrieved. One error is returned for every collaboration analysis template that could not be retrieved.</p>', ], ], 'BatchGetCollaborationAnalysisTemplateInput' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetCollaborationAnalysisTemplateOutput' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetSchemaAnalysisRuleError' => [ 'base' => '<p>An error that describes why a schema could not be fetched.</p>', 'refs' => [ 'BatchGetSchemaAnalysisRuleErrorList$member' => NULL, ], ], 'BatchGetSchemaAnalysisRuleErrorList' => [ 'base' => NULL, 'refs' => [ 'BatchGetSchemaAnalysisRuleOutput$errors' => '<p>Error reasons for schemas that could not be retrieved. One error is returned for every schema that could not be retrieved.</p>', ], ], 'BatchGetSchemaAnalysisRuleInput' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetSchemaAnalysisRuleOutput' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetSchemaError' => [ 'base' => '<p>An error describing why a schema could not be fetched.</p>', 'refs' => [ 'BatchGetSchemaErrorList$member' => NULL, ], ], 'BatchGetSchemaErrorList' => [ 'base' => NULL, 'refs' => [ 'BatchGetSchemaOutput$errors' => '<p>Error reasons for schemas that could not be retrieved. One error is returned for every schema that could not be retrieved.</p>', ], ], 'BatchGetSchemaInput' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetSchemaOutput' => [ 'base' => NULL, 'refs' => [], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'ConfiguredAudienceModelAssociation$manageResourcePolicies' => '<p>When <code>TRUE</code>, indicates that the resource policy for the configured audience model resource being associated is configured for Clean Rooms to manage permissions related to the given collaboration. When <code>FALSE</code>, indicates that the configured audience model resource owner will manage permissions related to the given collaboration.</p>', 'CreateConfiguredAudienceModelAssociationInput$manageResourcePolicies' => '<p>When <code>TRUE</code>, indicates that the resource policy for the configured audience model resource being associated is configured for Clean Rooms to manage permissions related to the given collaboration. When <code>FALSE</code>, indicates that the configured audience model resource owner will manage permissions related to the given collaboration.</p> <p>Setting this to <code>TRUE</code> requires you to have permissions to create, update, and delete the resource policy for the <code>cleanrooms-ml</code> resource when you call the <a>DeleteConfiguredAudienceModelAssociation</a> resource. In addition, if you are the collaboration creator and specify <code>TRUE</code>, you must have the same permissions when you call the <a>DeleteMember</a> and <a>DeleteCollaboration</a> APIs.</p>', 'DataEncryptionMetadata$allowCleartext' => '<p>Indicates whether encrypted tables can contain cleartext data (<code>TRUE</code>) or are to cryptographically process every column (<code>FALSE</code>).</p>', 'DataEncryptionMetadata$allowDuplicates' => '<p>Indicates whether Fingerprint columns can contain duplicate entries (<code>TRUE</code>) or are to contain only non-repeated values (<code>FALSE</code>).</p>', 'DataEncryptionMetadata$allowJoinsOnColumnsWithDifferentNames' => '<p>Indicates whether Fingerprint columns can be joined on any other Fingerprint column with a different name (<code>TRUE</code>) or can only be joined on Fingerprint columns of the same name (<code>FALSE</code>).</p>', 'DataEncryptionMetadata$preserveNulls' => '<p>Indicates whether NULL values are to be copied as NULL to encrypted tables (<code>TRUE</code>) or cryptographically processed (<code>FALSE</code>).</p>', 'MembershipQueryComputePaymentConfig$isResponsible' => '<p>Indicates whether the collaboration member has accepted to pay for query compute costs (<code>TRUE</code>) or has not accepted to pay for query compute costs (<code>FALSE</code>).</p> <p>If the collaboration creator has not specified anyone to pay for query compute costs, then the member who can query is the default payer. </p> <p>An error message is returned for the following reasons: </p> <ul> <li> <p>If you set the value to <code>FALSE</code> but you are responsible to pay for query compute costs. </p> </li> <li> <p>If you set the value to <code>TRUE</code> but you are not responsible to pay for query compute costs. </p> </li> </ul>', 'QueryComputePaymentConfig$isResponsible' => '<p>Indicates whether the collaboration creator has configured the collaboration member to pay for query compute costs (<code>TRUE</code>) or has not configured the collaboration member to pay for query compute costs (<code>FALSE</code>).</p> <p>Exactly one member can be configured to pay for query compute costs. An error is returned if the collaboration creator sets a <code>TRUE</code> value for more than one member in the collaboration. </p> <p>If the collaboration creator hasn\'t specified anyone as the member paying for query compute costs, then the member who can query is the default payer. An error is returned if the collaboration creator sets a <code>FALSE</code> value for the member who can query.</p>', ], ], 'CleanroomsArn' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceInput$resourceArn' => '<p>The Amazon Resource Name (ARN) associated with the resource you want to list tags on.</p>', 'TagResourceInput$resourceArn' => '<p>The Amazon Resource Name (ARN) associated with the resource you want to tag.</p>', 'UntagResourceInput$resourceArn' => '<p>The Amazon Resource Name (ARN) associated with the resource you want to remove the tag from.</p>', ], ], 'Collaboration' => [ 'base' => '<p>The multi-party data share environment. The collaboration contains metadata about its purpose and participants.</p>', 'refs' => [ 'CreateCollaborationOutput$collaboration' => '<p>The entire created collaboration object.</p>', 'GetCollaborationOutput$collaboration' => '<p>The entire collaboration for this identifier.</p>', 'UpdateCollaborationOutput$collaboration' => '<p>The entire collaboration that has been updated.</p>', ], ], 'CollaborationAnalysisTemplate' => [ 'base' => '<p>The analysis template within a collaboration.</p>', 'refs' => [ 'CollaborationAnalysisTemplateList$member' => NULL, 'GetCollaborationAnalysisTemplateOutput$collaborationAnalysisTemplate' => '<p>The analysis template within a collaboration.</p>', ], ], 'CollaborationAnalysisTemplateList' => [ 'base' => NULL, 'refs' => [ 'BatchGetCollaborationAnalysisTemplateOutput$collaborationAnalysisTemplates' => '<p>The retrieved list of analysis templates within a collaboration.</p>', ], ], 'CollaborationAnalysisTemplateSummary' => [ 'base' => '<p>The metadata of the analysis template within a collaboration.</p>', 'refs' => [ 'CollaborationAnalysisTemplateSummaryList$member' => NULL, ], ], 'CollaborationAnalysisTemplateSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListCollaborationAnalysisTemplatesOutput$collaborationAnalysisTemplateSummaries' => '<p>The metadata of the analysis template within a collaboration.</p>', ], ], 'CollaborationArn' => [ 'base' => NULL, 'refs' => [ 'AnalysisTemplate$collaborationArn' => '<p>The unique ARN for the analysis template’s associated collaboration.</p>', 'AnalysisTemplateSummary$collaborationArn' => '<p>The unique ARN for the analysis template summary’s associated collaboration.</p>', 'Collaboration$arn' => '<p>The unique ARN for the collaboration.</p>', 'CollaborationAnalysisTemplate$collaborationArn' => '<p>The unique ARN for the analysis template’s associated collaboration.</p>', 'CollaborationAnalysisTemplateSummary$collaborationArn' => '<p>The unique ARN for the analysis template’s associated collaboration.</p>', 'CollaborationConfiguredAudienceModelAssociation$collaborationArn' => '<p>The unique ARN for the configured audience model\'s associated collaboration.</p>', 'CollaborationConfiguredAudienceModelAssociationSummary$collaborationArn' => '<p>The unique ARN for the configured audience model\'s associated collaboration.</p>', 'CollaborationPrivacyBudgetSummary$collaborationArn' => '<p>The ARN of the collaboration that includes this privacy budget.</p>', 'CollaborationPrivacyBudgetTemplate$collaborationArn' => '<p>The ARN of the collaboration that includes this collaboration privacy budget template.</p>', 'CollaborationPrivacyBudgetTemplateSummary$collaborationArn' => '<p>The ARN of the collaboration that contains this collaboration privacy budget template.</p>', 'CollaborationSummary$arn' => '<p>The ARN of the collaboration.</p>', 'ConfiguredAudienceModelAssociation$collaborationArn' => '<p>The Amazon Resource Name (ARN) of the collaboration that contains this configured audience model association.</p>', 'ConfiguredAudienceModelAssociationSummary$collaborationArn' => '<p>The Amazon Resource Name (ARN) of the collaboration that contains the configured audience model association.</p>', 'Membership$collaborationArn' => '<p>The unique ARN for the membership\'s associated collaboration.</p>', 'MembershipSummary$collaborationArn' => '<p>The unique ARN for the membership\'s associated collaboration.</p>', 'PrivacyBudgetSummary$collaborationArn' => '<p>The ARN of the collaboration that contains this privacy budget.</p>', 'PrivacyBudgetTemplate$collaborationArn' => '<p>The ARN of the collaboration that contains this privacy budget template.</p>', 'PrivacyBudgetTemplateSummary$collaborationArn' => '<p>The ARN of the collaboration that contains this privacy budget template.</p>', 'Schema$collaborationArn' => '<p>The unique ARN for the collaboration that the schema belongs to.</p>', 'SchemaSummary$collaborationArn' => '<p>The unique ARN for the collaboration that the schema belongs to.</p>', ], ], 'CollaborationConfiguredAudienceModelAssociation' => [ 'base' => '<p>The configured audience model association within a collaboration.</p>', 'refs' => [ 'GetCollaborationConfiguredAudienceModelAssociationOutput$collaborationConfiguredAudienceModelAssociation' => '<p>The metadata of the configured audience model association.</p>', ], ], 'CollaborationConfiguredAudienceModelAssociationSummary' => [ 'base' => '<p>A summary of the configured audience model association in the collaboration.</p>', 'refs' => [ 'CollaborationConfiguredAudienceModelAssociationSummaryList$member' => NULL, ], ], 'CollaborationConfiguredAudienceModelAssociationSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListCollaborationConfiguredAudienceModelAssociationsOutput$collaborationConfiguredAudienceModelAssociationSummaries' => '<p>The metadata of the configured audience model association within a collaboration.</p>', ], ], 'CollaborationDescription' => [ 'base' => NULL, 'refs' => [ 'Collaboration$description' => '<p>A description of the collaboration provided by the collaboration owner.</p>', 'CreateCollaborationInput$description' => '<p>A description of the collaboration provided by the collaboration owner.</p>', 'UpdateCollaborationInput$description' => '<p>A description of the collaboration.</p>', ], ], 'CollaborationIdentifier' => [ 'base' => NULL, 'refs' => [ 'AnalysisRule$collaborationId' => '<p>The unique ID for the associated collaboration.</p>', 'BatchGetCollaborationAnalysisTemplateInput$collaborationIdentifier' => '<p>A unique identifier for the collaboration that the analysis templates belong to. Currently accepts collaboration ID.</p>', 'BatchGetSchemaAnalysisRuleInput$collaborationIdentifier' => '<p>The unique identifier of the collaboration that contains the schema analysis rule.</p>', 'BatchGetSchemaInput$collaborationIdentifier' => '<p>A unique identifier for the collaboration that the schemas belong to. Currently accepts collaboration ID.</p>', 'CreateMembershipInput$collaborationIdentifier' => '<p>The unique ID for the associated collaboration.</p>', 'DeleteCollaborationInput$collaborationIdentifier' => '<p>The identifier for the collaboration.</p>', 'DeleteMemberInput$collaborationIdentifier' => '<p>The unique identifier for the associated collaboration.</p>', 'GetCollaborationAnalysisTemplateInput$collaborationIdentifier' => '<p>A unique identifier for the collaboration that the analysis templates belong to. Currently accepts collaboration ID.</p>', 'GetCollaborationConfiguredAudienceModelAssociationInput$collaborationIdentifier' => '<p>A unique identifier for the collaboration that the configured audience model association belongs to. Accepts a collaboration ID.</p>', 'GetCollaborationInput$collaborationIdentifier' => '<p>The identifier for the collaboration.</p>', 'GetCollaborationPrivacyBudgetTemplateInput$collaborationIdentifier' => '<p>A unique identifier for one of your collaborations.</p>', 'GetSchemaAnalysisRuleInput$collaborationIdentifier' => '<p>A unique identifier for the collaboration that the schema belongs to. Currently accepts a collaboration ID.</p>', 'GetSchemaInput$collaborationIdentifier' => '<p>A unique identifier for the collaboration that the schema belongs to. Currently accepts a collaboration ID.</p>', 'ListCollaborationAnalysisTemplatesInput$collaborationIdentifier' => '<p>A unique identifier for the collaboration that the analysis templates belong to. Currently accepts collaboration ID.</p>', 'ListCollaborationConfiguredAudienceModelAssociationsInput$collaborationIdentifier' => '<p>A unique identifier for the collaboration that the configured audience model association belongs to. Accepts a collaboration ID.</p>', 'ListCollaborationPrivacyBudgetTemplatesInput$collaborationIdentifier' => '<p>A unique identifier for one of your collaborations.</p>', 'ListCollaborationPrivacyBudgetsInput$collaborationIdentifier' => '<p>A unique identifier for one of your collaborations.</p>', 'ListMembersInput$collaborationIdentifier' => '<p>The identifier of the collaboration in which the members are listed.</p>', 'ListSchemasInput$collaborationIdentifier' => '<p>A unique identifier for the collaboration that the schema belongs to. Currently accepts a collaboration ID.</p>', 'MembershipSummary$collaborationId' => '<p>The unique ID for the membership\'s collaboration.</p>', 'UpdateCollaborationInput$collaborationIdentifier' => '<p>The identifier for the collaboration.</p>', ], ], 'CollaborationName' => [ 'base' => NULL, 'refs' => [ 'Collaboration$name' => '<p>A human-readable identifier provided by the collaboration owner. Display names are not unique.</p>', 'CollaborationSummary$name' => '<p>A human-readable identifier provided by the collaboration owner. Display names are not unique.</p>', 'CreateCollaborationInput$name' => '<p>The display name for a collaboration.</p>', 'Membership$collaborationName' => '<p>The name of the membership\'s collaboration.</p>', 'MembershipSummary$collaborationName' => '<p>The name for the membership\'s collaboration.</p>', 'UpdateCollaborationInput$name' => '<p>A human-readable identifier provided by the collaboration owner. Display names are not unique.</p>', ], ], 'CollaborationPrivacyBudgetSummary' => [ 'base' => '<p>A summary of the collaboration privacy budgets. This summary includes the collaboration information, creation information, epsilon provided, and utility in terms of aggregations.</p>', 'refs' => [ 'CollaborationPrivacyBudgetSummaryList$member' => NULL, ], ], 'CollaborationPrivacyBudgetSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListCollaborationPrivacyBudgetsOutput$collaborationPrivacyBudgetSummaries' => '<p>Summaries of the collaboration privacy budgets.</p>', ], ], 'CollaborationPrivacyBudgetTemplate' => [ 'base' => '<p>An array that specifies the information for a collaboration\'s privacy budget template.</p>', 'refs' => [ 'GetCollaborationPrivacyBudgetTemplateOutput$collaborationPrivacyBudgetTemplate' => '<p>Returns the details of the privacy budget template that you requested.</p>', ], ], 'CollaborationPrivacyBudgetTemplateSummary' => [ 'base' => '<p>A summary of the collaboration\'s privacy budget template. This summary includes information about who created the privacy budget template and what collaborations it belongs to.</p>', 'refs' => [ 'CollaborationPrivacyBudgetTemplateSummaryList$member' => NULL, ], ], 'CollaborationPrivacyBudgetTemplateSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListCollaborationPrivacyBudgetTemplatesOutput$collaborationPrivacyBudgetTemplateSummaries' => '<p>An array that summarizes the collaboration privacy budget templates. The summary includes collaboration information, creation information, the privacy budget type.</p>', ], ], 'CollaborationQueryLogStatus' => [ 'base' => NULL, 'refs' => [ 'Collaboration$queryLogStatus' => '<p>An indicator as to whether query logging has been enabled or disabled for the collaboration.</p>', 'CreateCollaborationInput$queryLogStatus' => '<p>An indicator as to whether query logging has been enabled or disabled for the collaboration.</p>', ], ], 'CollaborationSummary' => [ 'base' => '<p>The metadata of the collaboration.</p>', 'refs' => [ 'CollaborationSummaryList$member' => NULL, ], ], 'CollaborationSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListCollaborationsOutput$collaborationList' => '<p>The list of collaborations.</p>', ], ], 'Column' => [ 'base' => '<p>A column within a schema relation, derived from the underlying Glue table.</p>', 'refs' => [ 'ColumnList$member' => NULL, ], ], 'ColumnList' => [ 'base' => NULL, 'refs' => [ 'Schema$columns' => '<p>The columns for the relation this schema represents.</p>', 'Schema$partitionKeys' => '<p>The partition keys for the dataset underlying this schema.</p>', ], ], 'ColumnName' => [ 'base' => NULL, 'refs' => [ 'AllowedColumnList$member' => NULL, 'Column$name' => '<p>The name of the column.</p>', ], ], 'ColumnTypeString' => [ 'base' => NULL, 'refs' => [ 'Column$type' => '<p>The type of the column.</p>', ], ], 'ConfiguredAudienceModelArn' => [ 'base' => NULL, 'refs' => [ 'CollaborationConfiguredAudienceModelAssociation$configuredAudienceModelArn' => '<p>The Amazon Resource Name (ARN) of the configure audience model.</p>', 'ConfiguredAudienceModelAssociation$configuredAudienceModelArn' => '<p>The Amazon Resource Name (ARN) of the configured audience model that was used for this configured audience model association.</p>', 'ConfiguredAudienceModelAssociationSummary$configuredAudienceModelArn' => '<p>The Amazon Resource Name (ARN) of the configured audience model that was used for this configured audience model association.</p>', 'CreateConfiguredAudienceModelAssociationInput$configuredAudienceModelArn' => '<p>A unique identifier for the configured audience model that you want to associate.</p>', ], ], 'ConfiguredAudienceModelAssociation' => [ 'base' => '<p>Details about the configured audience model association.</p>', 'refs' => [ 'CreateConfiguredAudienceModelAssociationOutput$configuredAudienceModelAssociation' => '<p>Information about the configured audience model association.</p>', 'GetConfiguredAudienceModelAssociationOutput$configuredAudienceModelAssociation' => '<p>Information about the configured audience model association that you requested.</p>', 'UpdateConfiguredAudienceModelAssociationOutput$configuredAudienceModelAssociation' => '<p>Details about the configured audience model association that you updated.</p>', ], ], 'ConfiguredAudienceModelAssociationArn' => [ 'base' => NULL, 'refs' => [ 'CollaborationConfiguredAudienceModelAssociation$arn' => '<p>The Amazon Resource Name (ARN) of the configured audience model association.</p>', 'CollaborationConfiguredAudienceModelAssociationSummary$arn' => '<p>The Amazon Resource Name (ARN) of the configured audience model association.</p>', 'ConfiguredAudienceModelAssociation$arn' => '<p>The Amazon Resource Name (ARN) of the configured audience model association.</p>', 'ConfiguredAudienceModelAssociationSummary$arn' => '<p>The Amazon Resource Name (ARN) of the configured audience model association.</p>', ], ], 'ConfiguredAudienceModelAssociationIdentifier' => [ 'base' => NULL, 'refs' => [ 'CollaborationConfiguredAudienceModelAssociation$id' => '<p>The identifier of the configured audience model association.</p>', 'CollaborationConfiguredAudienceModelAssociationSummary$id' => '<p>The identifier of the configured audience model association.</p>', 'ConfiguredAudienceModelAssociation$id' => '<p>A unique identifier of the configured audience model association.</p>', 'DeleteConfiguredAudienceModelAssociationInput$configuredAudienceModelAssociationIdentifier' => '<p>A unique identifier of the configured audience model association that you want to delete.</p>', 'GetCollaborationConfiguredAudienceModelAssociationInput$configuredAudienceModelAssociationIdentifier' => '<p>A unique identifier for the configured audience model association that you want to retrieve.</p>', 'GetConfiguredAudienceModelAssociationInput$configuredAudienceModelAssociationIdentifier' => '<p>A unique identifier for the configured audience model association that you want to retrieve.</p>', 'UpdateConfiguredAudienceModelAssociationInput$configuredAudienceModelAssociationIdentifier' => '<p>A unique identifier for the configured audience model association that you want to update.</p>', ], ], 'ConfiguredAudienceModelAssociationName' => [ 'base' => NULL, 'refs' => [ 'CollaborationConfiguredAudienceModelAssociation$name' => '<p>The name of the configured audience model association.</p>', 'CollaborationConfiguredAudienceModelAssociationSummary$name' => '<p>The name of the configured audience model association.</p>', 'ConfiguredAudienceModelAssociation$name' => '<p>The name of the configured audience model association.</p>', 'ConfiguredAudienceModelAssociationSummary$name' => '<p>The name of the configured audience model association.</p>', 'CreateConfiguredAudienceModelAssociationInput$configuredAudienceModelAssociationName' => '<p>The name of the configured audience model association.</p>', 'UpdateConfiguredAudienceModelAssociationInput$name' => '<p>A new name for the configured audience model association.</p>', ], ], 'ConfiguredAudienceModelAssociationSummary' => [ 'base' => '<p>A summary of the configured audience model association.</p>', 'refs' => [ 'ConfiguredAudienceModelAssociationSummaryList$member' => NULL, ], ], 'ConfiguredAudienceModelAssociationSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListConfiguredAudienceModelAssociationsOutput$configuredAudienceModelAssociationSummaries' => '<p>Summaries of the configured audience model associations that you requested.</p>', ], ], 'ConfiguredTable' => [ 'base' => '<p>A table that has been configured for use in a collaboration.</p>', 'refs' => [ 'CreateConfiguredTableOutput$configuredTable' => '<p>The created configured table.</p>', 'GetConfiguredTableOutput$configuredTable' => '<p>The retrieved configured table.</p>', 'UpdateConfiguredTableOutput$configuredTable' => '<p>The updated configured table.</p>', ], ], 'ConfiguredTableAnalysisRule' => [ 'base' => '<p>A configured table analysis rule, which limits how data for this table can be used.</p>', 'refs' => [ 'CreateConfiguredTableAnalysisRuleOutput$analysisRule' => '<p>The entire created analysis rule.</p>', 'GetConfiguredTableAnalysisRuleOutput$analysisRule' => '<p>The entire analysis rule output.</p>', 'UpdateConfiguredTableAnalysisRuleOutput$analysisRule' => '<p>The entire updated analysis rule.</p>', ], ], 'ConfiguredTableAnalysisRulePolicy' => [ 'base' => '<p>Controls on the query specifications that can be run on a configured table.</p>', 'refs' => [ 'ConfiguredTableAnalysisRule$policy' => '<p>The policy that controls SQL query rules.</p>', 'CreateConfiguredTableAnalysisRuleInput$analysisRulePolicy' => '<p>The entire created configured table analysis rule object.</p>', 'UpdateConfiguredTableAnalysisRuleInput$analysisRulePolicy' => '<p>The new analysis rule policy for the configured table analysis rule.</p>', ], ], 'ConfiguredTableAnalysisRulePolicyV1' => [ 'base' => '<p>Controls on the query specifications that can be run on a configured table.</p>', 'refs' => [ 'ConfiguredTableAnalysisRulePolicy$v1' => '<p>Controls on the query specifications that can be run on a configured table.</p>', ], ], 'ConfiguredTableAnalysisRuleType' => [ 'base' => NULL, 'refs' => [ 'ConfiguredTableAnalysisRule$type' => '<p>The type of configured table analysis rule.</p>', 'ConfiguredTableAnalysisRuleTypeList$member' => NULL, 'CreateConfiguredTableAnalysisRuleInput$analysisRuleType' => '<p>The type of analysis rule.</p>', 'DeleteConfiguredTableAnalysisRuleInput$analysisRuleType' => '<p>The analysis rule type to be deleted. Configured table analysis rules are uniquely identified by their configured table identifier and analysis rule type.</p>', 'GetConfiguredTableAnalysisRuleInput$analysisRuleType' => '<p>The analysis rule to be retrieved. Configured table analysis rules are uniquely identified by their configured table identifier and analysis rule type.</p>', 'UpdateConfiguredTableAnalysisRuleInput$analysisRuleType' => '<p>The analysis rule type to be updated. Configured table analysis rules are uniquely identified by their configured table identifier and analysis rule type.</p>', ], ], 'ConfiguredTableAnalysisRuleTypeList' => [ 'base' => NULL, 'refs' => [ 'ConfiguredTable$analysisRuleTypes' => '<p>The types of analysis rules associated with this configured table. Currently, only one analysis rule may be associated with a configured table.</p>', 'ConfiguredTableSummary$analysisRuleTypes' => '<p>The types of analysis rules associated with this configured table.</p>', ], ], 'ConfiguredTableArn' => [ 'base' => NULL, 'refs' => [ 'ConfiguredTable$arn' => '<p>The unique ARN for the configured table.</p>', 'ConfiguredTableAnalysisRule$configuredTableArn' => '<p>The unique ARN for the configured table.</p>', 'ConfiguredTableAssociation$configuredTableArn' => '<p>The unique ARN for the configured table that the association refers to.</p>', 'ConfiguredTableSummary$arn' => '<p>The unique ARN of the configured table.</p>', ], ], 'ConfiguredTableAssociation' => [ 'base' => '<p>A configured table association links a configured table to a collaboration.</p>', 'refs' => [ 'CreateConfiguredTableAssociationOutput$configuredTableAssociation' => '<p>The entire configured table association object.</p>', 'GetConfiguredTableAssociationOutput$configuredTableAssociation' => '<p>The entire configured table association object.</p>', 'UpdateConfiguredTableAssociationOutput$configuredTableAssociation' => '<p>The entire updated configured table association.</p>', ], ], 'ConfiguredTableAssociationArn' => [ 'base' => NULL, 'refs' => [ 'ConfiguredTableAssociation$arn' => '<p>The unique ARN for the configured table association.</p>', 'ConfiguredTableAssociationSummary$arn' => '<p>The unique ARN for the configured table association.</p>', ], ], 'ConfiguredTableAssociationIdentifier' => [ 'base' => NULL, 'refs' => [ 'DeleteConfiguredTableAssociationInput$configuredTableAssociationIdentifier' => '<p>The unique ID for the configured table association to be deleted. Currently accepts the configured table ID.</p>', 'GetConfiguredTableAssociationInput$configuredTableAssociationIdentifier' => '<p>The unique ID for the configured table association to retrieve. Currently accepts the configured table ID.</p>', 'UpdateConfiguredTableAssociationInput$configuredTableAssociationIdentifier' => '<p>The unique identifier for the configured table association to update. Currently accepts the configured table association ID.</p>', ], ], 'ConfiguredTableAssociationSummary' => [ 'base' => '<p>The configured table association summary for the objects listed by the request.</p>', 'refs' => [ 'ConfiguredTableAssociationSummaryList$member' => NULL, ], ], 'ConfiguredTableAssociationSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListConfiguredTableAssociationsOutput$configuredTableAssociationSummaries' => '<p>The retrieved list of configured table associations.</p>', ], ], 'ConfiguredTableIdentifier' => [ 'base' => NULL, 'refs' => [ 'ConfiguredTableSummary$id' => '<p>The unique ID of the configured table.</p>', 'CreateConfiguredTableAnalysisRuleInput$configuredTableIdentifier' => '<p>The identifier for the configured table to create the analysis rule for. Currently accepts the configured table ID. </p>', 'CreateConfiguredTableAssociationInput$configuredTableIdentifier' => '<p>A unique identifier for the configured table to be associated to. Currently accepts a configured table ID.</p>', 'DeleteConfiguredTableAnalysisRuleInput$configuredTableIdentifier' => '<p>The unique identifier for the configured table that the analysis rule applies to. Currently accepts the configured table ID.</p>', 'DeleteConfiguredTableInput$configuredTableIdentifier' => '<p>The unique ID for the configured table to delete.</p>', 'GetConfiguredTableAnalysisRuleInput$configuredTableIdentifier' => '<p>The unique identifier for the configured table to retrieve. Currently accepts the configured table ID.</p>', 'GetConfiguredTableInput$configuredTableIdentifier' => '<p>The unique ID for the configured table to retrieve.</p>', 'UpdateConfiguredTableAnalysisRuleInput$configuredTableIdentifier' => '<p>The unique identifier for the configured table that the analysis rule applies to. Currently accepts the configured table ID.</p>', 'UpdateConfiguredTableInput$configuredTableIdentifier' => '<p>The identifier for the configured table to update. Currently accepts the configured table ID.</p>', ], ], 'ConfiguredTableSummary' => [ 'base' => '<p>The configured table summary for the objects listed by the request.</p>', 'refs' => [ 'ConfiguredTableSummaryList$member' => '<p>The member of the configured table summary list.</p>', ], ], 'ConfiguredTableSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListConfiguredTablesOutput$configuredTableSummaries' => '<p>The configured tables listed by the request.</p>', ], ], 'ConflictException' => [ 'base' => '<p>Updating or deleting a resource can cause an inconsistent state.</p>', 'refs' => [], ], 'ConflictExceptionReason' => [ 'base' => NULL, 'refs' => [ 'ConflictException$reason' => '<p>A reason code for the exception.</p>', ], ], 'CreateAnalysisTemplateInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateAnalysisTemplateOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateCollaborationInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateCollaborationOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateConfiguredAudienceModelAssociationInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateConfiguredAudienceModelAssociationOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateConfiguredTableAnalysisRuleInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateConfiguredTableAnalysisRuleOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateConfiguredTableAssociationInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateConfiguredTableAssociationOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateConfiguredTableInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateConfiguredTableOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateMembershipInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateMembershipOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreatePrivacyBudgetTemplateInput' => [ 'base' => NULL, 'refs' => [], ], 'CreatePrivacyBudgetTemplateOutput' => [ 'base' => NULL, 'refs' => [], ], 'DataEncryptionMetadata' => [ 'base' => '<p>The settings for client-side encryption for cryptographic computing.</p>', 'refs' => [ 'Collaboration$dataEncryptionMetadata' => '<p>The settings for client-side encryption for cryptographic computing.</p>', 'CreateCollaborationInput$dataEncryptionMetadata' => '<p>The settings for client-side encryption with Cryptographic Computing for Clean Rooms.</p>', ], ], 'DeleteAnalysisTemplateInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAnalysisTemplateOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteCollaborationInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteCollaborationOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteConfiguredAudienceModelAssociationInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteConfiguredAudienceModelAssociationOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteConfiguredTableAnalysisRuleInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteConfiguredTableAnalysisRuleOutput' => [ 'base' => '<p>An empty response that indicates a successful delete.</p>', 'refs' => [], ], 'DeleteConfiguredTableAssociationInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteConfiguredTableAssociationOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteConfiguredTableInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteConfiguredTableOutput' => [ 'base' => '<p>The empty output for a successful deletion.</p>', 'refs' => [], ], 'DeleteMemberInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMemberOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMembershipInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMembershipOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeletePrivacyBudgetTemplateInput' => [ 'base' => NULL, 'refs' => [], ], 'DeletePrivacyBudgetTemplateOutput' => [ 'base' => NULL, 'refs' => [], ], 'DifferentialPrivacyAggregationExpression' => [ 'base' => NULL, 'refs' => [ 'DifferentialPrivacySensitivityParameters$aggregationExpression' => '<p>The aggregation expression that was run.</p>', ], ], 'DifferentialPrivacyAggregationType' => [ 'base' => NULL, 'refs' => [ 'DifferentialPrivacyPreviewAggregation$type' => '<p>The type of aggregation function.</p>', 'DifferentialPrivacyPrivacyBudgetAggregation$type' => '<p>The different types of aggregation functions that you can perform.</p>', 'DifferentialPrivacySensitivityParameters$aggregationType' => '<p>The type of aggregation function that was run.</p>', ], ], 'DifferentialPrivacyColumn' => [ 'base' => '<p>Specifies the name of the column that contains the unique identifier of your users, whose privacy you want to protect.</p>', 'refs' => [ 'DifferentialPrivacyColumnList$member' => NULL, ], ], 'DifferentialPrivacyColumnList' => [ 'base' => NULL, 'refs' => [ 'DifferentialPrivacyConfiguration$columns' => '<p>The name of the column (such as user_id) that contains the unique identifier of your users whose privacy you want to protect. If you want to turn on diﬀerential privacy for two or more tables in a collaboration, you must conﬁgure the same column as the user identiﬁer column in both analysis rules.</p>', ], ], 'DifferentialPrivacyConfiguration' => [ 'base' => '<p>Specifies the unique identifier for your users.</p>', 'refs' => [ 'AnalysisRuleCustom$differentialPrivacy' => '<p>The differential privacy configuration.</p>', ], ], 'DifferentialPrivacyParameters' => [ 'base' => '<p>An array that contains the sensitivity parameters.</p>', 'refs' => [ 'ProtectedQuery$differentialPrivacy' => '<p>The sensitivity parameters of the differential privacy results of the protected query.</p>', ], ], 'DifferentialPrivacyPreviewAggregation' => [ 'base' => '<p>Provides an estimate of the number of aggregation functions that the member who can query can run given the epsilon and noise parameters.</p>', 'refs' => [ 'DifferentialPrivacyPreviewAggregationList$member' => NULL, ], ], 'DifferentialPrivacyPreviewAggregationList' => [ 'base' => NULL, 'refs' => [ 'DifferentialPrivacyPrivacyImpact$aggregations' => '<p>The number of aggregation functions that you can perform.</p>', ], ], 'DifferentialPrivacyPreviewAggregationMaxCountInteger' => [ 'base' => NULL, 'refs' => [ 'DifferentialPrivacyPreviewAggregation$maxCount' => '<p>The maximum number of aggregations that the member who can query can run given the epsilon and noise parameters.</p>', ], ], 'DifferentialPrivacyPreviewParametersInput' => [ 'base' => '<p>The epsilon and noise parameters that you want to preview.</p>', 'refs' => [ 'PreviewPrivacyImpactParametersInput$differentialPrivacy' => '<p>An array that specifies the epsilon and noise parameters.</p>', ], ], 'DifferentialPrivacyPrivacyBudget' => [ 'base' => '<p>Specifies the configured epsilon value and the utility in terms of total aggregations, as well as the remaining aggregations available.</p>', 'refs' => [ 'PrivacyBudget$differentialPrivacy' => '<p>An object that specifies the epsilon parameter and the utility in terms of total aggregations, as well as the remaining aggregations available.</p>', ], ], 'DifferentialPrivacyPrivacyBudgetAggregation' => [ 'base' => '<p>Information about the total number of aggregations, as well as the remaining aggregations.</p>', 'refs' => [ 'DifferentialPrivacyPrivacyBudgetAggregationList$member' => NULL, ], ], 'DifferentialPrivacyPrivacyBudgetAggregationList' => [ 'base' => NULL, 'refs' => [ 'DifferentialPrivacyPrivacyBudget$aggregations' => '<p>This information includes the configured epsilon value and the utility in terms of total aggregations, as well as the remaining aggregations.</p>', ], ], 'DifferentialPrivacyPrivacyBudgetAggregationMaxCountInteger' => [ 'base' => NULL, 'refs' => [ 'DifferentialPrivacyPrivacyBudgetAggregation$maxCount' => '<p>The maximum number of aggregation functions that you can perform with the given privacy budget.</p>', ], ], 'DifferentialPrivacyPrivacyBudgetAggregationRemainingCountInteger' => [ 'base' => NULL, 'refs' => [ 'DifferentialPrivacyPrivacyBudgetAggregation$remainingCount' => '<p>The remaining number of aggregation functions that can be run with the available privacy budget.</p>', ], ], 'DifferentialPrivacyPrivacyImpact' => [ 'base' => '<p>Information about the number of aggregation functions that the member who can query can run given the epsilon and noise parameters.</p>', 'refs' => [ 'PrivacyImpact$differentialPrivacy' => '<p>An object that lists the number and type of aggregation functions you can perform.</p>', ], ], 'DifferentialPrivacySensitivityParameters' => [ 'base' => '<p>Provides the sensitivity parameters.</p>', 'refs' => [ 'DifferentialPrivacySensitivityParametersList$member' => NULL, ], ], 'DifferentialPrivacySensitivityParametersList' => [ 'base' => NULL, 'refs' => [ 'DifferentialPrivacyParameters$sensitivityParameters' => '<p>Provides the sensitivity parameters that you can use to better understand the total amount of noise in query results.</p>', ], ], 'DifferentialPrivacySensitivityParametersUserContributionLimitInteger' => [ 'base' => NULL, 'refs' => [ 'DifferentialPrivacySensitivityParameters$userContributionLimit' => '<p>The maximum number of rows contributed by a user in a SQL query.</p>', ], ], 'DifferentialPrivacyTemplateParametersInput' => [ 'base' => '<p>The epsilon and noise parameter values that you want to use for the differential privacy template.</p>', 'refs' => [ 'PrivacyBudgetTemplateParametersInput$differentialPrivacy' => '<p>An object that specifies the epsilon and noise parameters.</p>', ], ], 'DifferentialPrivacyTemplateParametersOutput' => [ 'base' => '<p>The epsilon and noise parameter values that were used for the differential privacy template.</p>', 'refs' => [ 'PrivacyBudgetTemplateParametersOutput$differentialPrivacy' => '<p>The epsilon and noise parameters.</p>', ], ], 'DifferentialPrivacyTemplateUpdateParameters' => [ 'base' => '<p>The epsilon and noise parameter values that you want to update in the differential privacy template.</p>', 'refs' => [ 'PrivacyBudgetTemplateUpdateParameters$differentialPrivacy' => '<p>An object that specifies the new values for the epsilon and noise parameters.</p>', ], ], 'DisplayName' => [ 'base' => NULL, 'refs' => [ 'Collaboration$creatorDisplayName' => '<p>A display name of the collaboration creator.</p>', 'CollaborationSummary$creatorDisplayName' => '<p>The display name of the collaboration creator.</p>', 'ConfiguredTable$name' => '<p>A name for the configured table.</p>', 'ConfiguredTableSummary$name' => '<p>The name of the configured table.</p>', 'CreateCollaborationInput$creatorDisplayName' => '<p>The display name of the collaboration creator.</p>', 'CreateConfiguredTableInput$name' => '<p>The name of the configured table.</p>', 'MemberSpecification$displayName' => '<p>The member\'s display name.</p>', 'MemberSummary$displayName' => '<p>The member\'s display name.</p>', 'Membership$collaborationCreatorDisplayName' => '<p>The display name of the collaboration creator.</p>', 'MembershipSummary$collaborationCreatorDisplayName' => '<p>The display name of the collaboration creator.</p>', 'UpdateConfiguredTableInput$name' => '<p>A new name for the configured table.</p>', ], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'ServiceQuotaExceededException$quotaValue' => '<p>The value of the quota.</p>', ], ], 'Epsilon' => [ 'base' => NULL, 'refs' => [ 'DifferentialPrivacyPreviewParametersInput$epsilon' => '<p>The epsilon value that you want to preview.</p>', 'DifferentialPrivacyPrivacyBudget$epsilon' => '<p>The epsilon value that you configured.</p>', 'DifferentialPrivacyTemplateParametersInput$epsilon' => '<p>The epsilon value that you want to use.</p>', 'DifferentialPrivacyTemplateParametersOutput$epsilon' => '<p>The epsilon value that you specified.</p>', 'DifferentialPrivacyTemplateUpdateParameters$epsilon' => '<p>The updated epsilon value that you want to use.</p>', ], ], 'FilterableMemberStatus' => [ 'base' => NULL, 'refs' => [ 'ListCollaborationsInput$memberStatus' => '<p>The caller\'s status in a collaboration.</p>', ], ], 'Float' => [ 'base' => NULL, 'refs' => [ 'DifferentialPrivacySensitivityParameters$minColumnValue' => '<p>The lower bound of the aggregation expression.</p>', 'DifferentialPrivacySensitivityParameters$maxColumnValue' => '<p>The upper bound of the aggregation expression.</p>', ], ], 'GetAnalysisTemplateInput' => [ 'base' => NULL, 'refs' => [], ], 'GetAnalysisTemplateOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetCollaborationAnalysisTemplateInput' => [ 'base' => NULL, 'refs' => [], ], 'GetCollaborationAnalysisTemplateOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetCollaborationConfiguredAudienceModelAssociationInput' => [ 'base' => NULL, 'refs' => [], ], 'GetCollaborationConfiguredAudienceModelAssociationOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetCollaborationInput' => [ 'base' => NULL, 'refs' => [], ], 'GetCollaborationOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetCollaborationPrivacyBudgetTemplateInput' => [ 'base' => NULL, 'refs' => [], ], 'GetCollaborationPrivacyBudgetTemplateOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetConfiguredAudienceModelAssociationInput' => [ 'base' => NULL, 'refs' => [], ], 'GetConfiguredAudienceModelAssociationOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetConfiguredTableAnalysisRuleInput' => [ 'base' => NULL, 'refs' => [], ], 'GetConfiguredTableAnalysisRuleOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetConfiguredTableAssociationInput' => [ 'base' => NULL, 'refs' => [], ], 'GetConfiguredTableAssociationOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetConfiguredTableInput' => [ 'base' => NULL, 'refs' => [], ], 'GetConfiguredTableOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetMembershipInput' => [ 'base' => NULL, 'refs' => [], ], 'GetMembershipOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetPrivacyBudgetTemplateInput' => [ 'base' => NULL, 'refs' => [], ], 'GetPrivacyBudgetTemplateOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetProtectedQueryInput' => [ 'base' => NULL, 'refs' => [], ], 'GetProtectedQueryOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetSchemaAnalysisRuleInput' => [ 'base' => NULL, 'refs' => [], ], 'GetSchemaAnalysisRuleOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetSchemaInput' => [ 'base' => NULL, 'refs' => [], ], 'GetSchemaOutput' => [ 'base' => NULL, 'refs' => [], ], 'GlueDatabaseName' => [ 'base' => NULL, 'refs' => [ 'GlueTableReference$databaseName' => '<p>The name of the database the Glue table belongs to.</p>', ], ], 'GlueTableName' => [ 'base' => NULL, 'refs' => [ 'GlueTableReference$tableName' => '<p>The name of the Glue table.</p>', ], ], 'GlueTableReference' => [ 'base' => '<p>A reference to a table within an Glue data catalog.</p>', 'refs' => [ 'TableReference$glue' => '<p>If present, a reference to the Glue table referred to by this table reference.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>Unexpected error during processing of request.</p>', 'refs' => [], ], 'JoinOperator' => [ 'base' => NULL, 'refs' => [ 'JoinOperatorsList$member' => NULL, ], ], 'JoinOperatorsList' => [ 'base' => NULL, 'refs' => [ 'AnalysisRuleAggregation$allowedJoinOperators' => '<p>Which logical operators (if any) are to be used in an INNER JOIN match condition. Default is <code>AND</code>.</p>', 'AnalysisRuleList$allowedJoinOperators' => '<p>The logical operators (if any) that are to be used in an INNER JOIN match condition. Default is <code>AND</code>.</p>', ], ], 'JoinRequiredOption' => [ 'base' => NULL, 'refs' => [ 'AnalysisRuleAggregation$joinRequired' => '<p>Control that requires member who runs query to do a join with their configured table and/or other configured table in query.</p>', ], ], 'KeyPrefix' => [ 'base' => NULL, 'refs' => [ 'ProtectedQueryS3OutputConfiguration$keyPrefix' => '<p>The S3 prefix to unload the protected query results.</p>', ], ], 'ListAnalysisTemplatesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListAnalysisTemplatesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListCollaborationAnalysisTemplatesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListCollaborationAnalysisTemplatesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListCollaborationConfiguredAudienceModelAssociationsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListCollaborationConfiguredAudienceModelAssociationsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListCollaborationPrivacyBudgetTemplatesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListCollaborationPrivacyBudgetTemplatesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListCollaborationPrivacyBudgetsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListCollaborationPrivacyBudgetsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListCollaborationsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListCollaborationsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListConfiguredAudienceModelAssociationsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListConfiguredAudienceModelAssociationsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListConfiguredTableAssociationsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListConfiguredTableAssociationsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListConfiguredTablesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListConfiguredTablesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListMembersInput' => [ 'base' => NULL, 'refs' => [], ], 'ListMembersOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListMembershipsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListMembershipsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListPrivacyBudgetTemplatesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListPrivacyBudgetTemplatesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListPrivacyBudgetsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListPrivacyBudgetsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListProtectedQueriesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListProtectedQueriesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListSchemasInput' => [ 'base' => NULL, 'refs' => [], ], 'ListSchemasOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'ProtectedQueryStatistics$totalDurationInMillis' => '<p>The duration of the Protected Query, from creation until query completion.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListAnalysisTemplatesInput$maxResults' => '<p>The maximum size of the results that is returned per call.</p>', 'ListCollaborationAnalysisTemplatesInput$maxResults' => '<p>The maximum size of the results that is returned per call.</p>', 'ListCollaborationConfiguredAudienceModelAssociationsInput$maxResults' => '<p>The maximum size of the results that is returned per call.</p>', 'ListCollaborationPrivacyBudgetTemplatesInput$maxResults' => '<p>The maximum size of the results that is returned per call. Service chooses a default if it has not been set. Service may return a nextToken even if the maximum results has not been met.</p>', 'ListCollaborationPrivacyBudgetsInput$maxResults' => '<p>The maximum size of the results that is returned per call. Service chooses a default if it has not been set. Service may return a nextToken even if the maximum results has not been met.</p>', 'ListCollaborationsInput$maxResults' => '<p>The maximum size of the results that is returned per call. Service chooses a default if it has not been set. Service may return a nextToken even if the maximum results has not been met.</p>', 'ListConfiguredAudienceModelAssociationsInput$maxResults' => '<p>The maximum size of the results that is returned per call. Service chooses a default if it has not been set. Service may return a nextToken even if the maximum results has not been met.</p>', 'ListConfiguredTableAssociationsInput$maxResults' => '<p>The maximum size of the results that is returned per call.</p>', 'ListConfiguredTablesInput$maxResults' => '<p>The maximum size of the results that is returned per call.</p>', 'ListMembersInput$maxResults' => '<p>The maximum size of the results that is returned per call.</p>', 'ListMembershipsInput$maxResults' => '<p>The maximum size of the results that is returned per call.</p>', 'ListPrivacyBudgetTemplatesInput$maxResults' => '<p>The maximum size of the results that is returned per call. Service chooses a default if it has not been set. Service may return a nextToken even if the maximum results has not been met.</p>', 'ListPrivacyBudgetsInput$maxResults' => '<p>The maximum size of the results that is returned per call. Service chooses a default if it has not been set. Service may return a nextToken even if the maximum results has not been met.</p>', 'ListProtectedQueriesInput$maxResults' => '<p>The maximum size of the results that is returned per call. Service chooses a default if it has not been set. Service can return a nextToken even if the maximum results has not been met. </p>', 'ListSchemasInput$maxResults' => '<p>The maximum size of the results that is returned per call.</p>', ], ], 'MemberAbilities' => [ 'base' => NULL, 'refs' => [ 'CreateCollaborationInput$creatorMemberAbilities' => '<p>The abilities granted to the collaboration creator.</p>', 'MemberSpecification$memberAbilities' => '<p>The abilities granted to the collaboration member.</p>', 'MemberSummary$abilities' => '<p>The abilities granted to the collaboration member.</p>', 'Membership$memberAbilities' => '<p>The abilities granted to the collaboration member.</p>', 'MembershipSummary$memberAbilities' => '<p>The abilities granted to the collaboration member.</p>', ], ], 'MemberAbility' => [ 'base' => NULL, 'refs' => [ 'MemberAbilities$member' => NULL, ], ], 'MemberList' => [ 'base' => NULL, 'refs' => [ 'CreateCollaborationInput$members' => '<p>A list of initial members, not including the creator. This list is immutable.</p>', ], ], 'MemberSpecification' => [ 'base' => '<p>Basic metadata used to construct a new member.</p>', 'refs' => [ 'MemberList$member' => NULL, ], ], 'MemberStatus' => [ 'base' => NULL, 'refs' => [ 'Collaboration$memberStatus' => '<p>The status of a member in a collaboration.</p>', 'CollaborationSummary$memberStatus' => '<p>The status of a member in a collaboration.</p>', 'MemberSummary$status' => '<p>The status of the member. </p>', ], ], 'MemberSummary' => [ 'base' => '<p>The member object listed by the request.</p>', 'refs' => [ 'MemberSummaryList$member' => NULL, ], ], 'MemberSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListMembersOutput$memberSummaries' => '<p>The list of members returned by the ListMembers operation.</p>', ], ], 'Membership' => [ 'base' => '<p>The membership object.</p>', 'refs' => [ 'CreateMembershipOutput$membership' => '<p>The membership that was created.</p>', 'GetMembershipOutput$membership' => '<p>The membership retrieved for the provided identifier.</p>', 'UpdateMembershipOutput$membership' => NULL, ], ], 'MembershipArn' => [ 'base' => NULL, 'refs' => [ 'AnalysisTemplate$membershipArn' => '<p>The Amazon Resource Name (ARN) of the member who created the analysis template.</p>', 'AnalysisTemplateSummary$membershipArn' => '<p>The Amazon Resource Name (ARN) of the member who created the analysis template.</p>', 'Collaboration$membershipArn' => '<p>The unique ARN for your membership within the collaboration.</p>', 'CollaborationSummary$membershipArn' => '<p>The ARN of a member in a collaboration.</p>', 'ConfiguredAudienceModelAssociation$membershipArn' => '<p>The Amazon Resource Name (ARN) of the membership that contains this configured audience model association.</p>', 'ConfiguredAudienceModelAssociationSummary$membershipArn' => '<p>The Amazon Resource Name (ARN) of the membership that contains the configured audience model association.</p>', 'ConfiguredTableAssociation$membershipArn' => '<p>The unique ARN for the membership this configured table association belongs to.</p>', 'ConfiguredTableAssociationSummary$membershipArn' => '<p>The unique ARN for the membership that the configured table association belongs to.</p>', 'MemberSummary$membershipArn' => '<p>The unique ARN for the member\'s associated membership, if present.</p>', 'Membership$arn' => '<p>The unique ARN for the membership.</p>', 'MembershipSummary$arn' => '<p>The unique ARN for the membership.</p>', 'PrivacyBudgetSummary$membershipArn' => '<p>The Amazon Resource Name (ARN) of the member who created the privacy budget summary.</p>', 'PrivacyBudgetTemplate$membershipArn' => '<p>The Amazon Resource Name (ARN) of the member who created the privacy budget template.</p>', 'PrivacyBudgetTemplateSummary$membershipArn' => '<p>The Amazon Resource Name (ARN) of the member who created the privacy budget template.</p>', 'ProtectedQuery$membershipArn' => '<p>The ARN of the membership.</p>', 'ProtectedQuerySummary$membershipArn' => '<p>The unique ARN for the membership that initiated the protected query.</p>', ], ], 'MembershipIdentifier' => [ 'base' => NULL, 'refs' => [ 'ConfiguredAudienceModelAssociationSummary$membershipId' => '<p>A unique identifier of the membership that contains the configured audience model association.</p>', 'ConfiguredTableAssociationSummary$membershipId' => '<p>The unique ID for the membership that the configured table association belongs to.</p>', 'CreateAnalysisTemplateInput$membershipIdentifier' => '<p>The identifier for a membership resource.</p>', 'CreateConfiguredAudienceModelAssociationInput$membershipIdentifier' => '<p>A unique identifier for one of your memberships for a collaboration. The configured audience model is associated to the collaboration that this membership belongs to. Accepts a membership ID.</p>', 'CreateConfiguredTableAssociationInput$membershipIdentifier' => '<p>A unique identifier for one of your memberships for a collaboration. The configured table is associated to the collaboration that this membership belongs to. Currently accepts a membership ID.</p>', 'CreatePrivacyBudgetTemplateInput$membershipIdentifier' => '<p>A unique identifier for one of your memberships for a collaboration. The privacy budget template is created in the collaboration that this membership belongs to. Accepts a membership ID.</p>', 'DeleteAnalysisTemplateInput$membershipIdentifier' => '<p>The identifier for a membership resource.</p>', 'DeleteConfiguredAudienceModelAssociationInput$membershipIdentifier' => '<p>A unique identifier of the membership that contains the audience model association that you want to delete.</p>', 'DeleteConfiguredTableAssociationInput$membershipIdentifier' => '<p>A unique identifier for the membership that the configured table association belongs to. Currently accepts the membership ID.</p>', 'DeleteMembershipInput$membershipIdentifier' => '<p>The identifier for a membership resource.</p>', 'DeletePrivacyBudgetTemplateInput$membershipIdentifier' => '<p>A unique identifier for one of your memberships for a collaboration. The privacy budget template is deleted from the collaboration that this membership belongs to. Accepts a membership ID.</p>', 'GetAnalysisTemplateInput$membershipIdentifier' => '<p>The identifier for a membership resource.</p>', 'GetConfiguredAudienceModelAssociationInput$membershipIdentifier' => '<p>A unique identifier for the membership that contains the configured audience model association that you want to retrieve.</p>', 'GetConfiguredTableAssociationInput$membershipIdentifier' => '<p>A unique identifier for the membership that the configured table association belongs to. Currently accepts the membership ID.</p>', 'GetMembershipInput$membershipIdentifier' => '<p>The identifier for a membership resource.</p>', 'GetPrivacyBudgetTemplateInput$membershipIdentifier' => '<p>A unique identifier for one of your memberships for a collaboration. The privacy budget template is retrieved from the collaboration that this membership belongs to. Accepts a membership ID.</p>', 'GetProtectedQueryInput$membershipIdentifier' => '<p>The identifier for a membership in a protected query instance.</p>', 'ListAnalysisTemplatesInput$membershipIdentifier' => '<p>The identifier for a membership resource.</p>', 'ListConfiguredAudienceModelAssociationsInput$membershipIdentifier' => '<p>A unique identifier for a membership that contains the configured audience model associations that you want to retrieve.</p>', 'ListConfiguredTableAssociationsInput$membershipIdentifier' => '<p>A unique identifier for the membership to list configured table associations for. Currently accepts the membership ID.</p>', 'ListPrivacyBudgetTemplatesInput$membershipIdentifier' => '<p>A unique identifier for one of your memberships for a collaboration. The privacy budget templates are retrieved from the collaboration that this membership belongs to. Accepts a membership ID.</p>', 'ListPrivacyBudgetsInput$membershipIdentifier' => '<p>A unique identifier for one of your memberships for a collaboration. The privacy budget is retrieved from the collaboration that this membership belongs to. Accepts a membership ID.</p>', 'ListProtectedQueriesInput$membershipIdentifier' => '<p>The identifier for the membership in the collaboration.</p>', 'PreviewPrivacyImpactInput$membershipIdentifier' => '<p>A unique identifier for one of your memberships for a collaboration. Accepts a membership ID.</p>', 'PrivacyBudgetSummary$membershipId' => '<p>The identifier for a membership resource.</p>', 'StartProtectedQueryInput$membershipIdentifier' => '<p>A unique identifier for the membership to run this query against. Currently accepts a membership ID.</p>', 'UpdateAnalysisTemplateInput$membershipIdentifier' => '<p>The identifier for a membership resource.</p>', 'UpdateConfiguredAudienceModelAssociationInput$membershipIdentifier' => '<p>A unique identifier of the membership that contains the configured audience model association that you want to update.</p>', 'UpdateConfiguredTableAssociationInput$membershipIdentifier' => '<p>The unique ID for the membership that the configured table association belongs to.</p>', 'UpdateMembershipInput$membershipIdentifier' => '<p>The unique identifier of the membership.</p>', 'UpdatePrivacyBudgetTemplateInput$membershipIdentifier' => '<p>A unique identifier for one of your memberships for a collaboration. The privacy budget template is updated in the collaboration that this membership belongs to. Accepts a membership ID.</p>', 'UpdateProtectedQueryInput$membershipIdentifier' => '<p>The identifier for a member of a protected query instance.</p>', ], ], 'MembershipPaymentConfiguration' => [ 'base' => '<p>An object representing the payment responsibilities accepted by the collaboration member.</p>', 'refs' => [ 'CreateMembershipInput$paymentConfiguration' => '<p>The payment responsibilities accepted by the collaboration member.</p> <p>Not required if the collaboration member has the member ability to run queries. </p> <p>Required if the collaboration member doesn\'t have the member ability to run queries but is configured as a payer by the collaboration creator. </p>', 'Membership$paymentConfiguration' => '<p>The payment responsibilities accepted by the collaboration member.</p>', 'MembershipSummary$paymentConfiguration' => '<p>The payment responsibilities accepted by the collaboration member.</p>', ], ], 'MembershipProtectedQueryOutputConfiguration' => [ 'base' => '<p>Contains configurations for protected query results.</p>', 'refs' => [ 'MembershipProtectedQueryResultConfiguration$outputConfiguration' => '<p>Configuration for protected query results.</p>', ], ], 'MembershipProtectedQueryResultConfiguration' => [ 'base' => '<p>Contains configurations for protected query results.</p>', 'refs' => [ 'CreateMembershipInput$defaultResultConfiguration' => '<p>The default protected query result configuration as specified by the member who can receive results.</p>', 'Membership$defaultResultConfiguration' => '<p>The default protected query result configuration as specified by the member who can receive results.</p>', 'UpdateMembershipInput$defaultResultConfiguration' => '<p>The default protected query result configuration as specified by the member who can receive results.</p>', ], ], 'MembershipQueryComputePaymentConfig' => [ 'base' => '<p>An object representing the payment responsibilities accepted by the collaboration member for query compute costs.</p>', 'refs' => [ 'MembershipPaymentConfiguration$queryCompute' => '<p>The payment responsibilities accepted by the collaboration member for query compute costs.</p>', ], ], 'MembershipQueryLogStatus' => [ 'base' => NULL, 'refs' => [ 'CreateMembershipInput$queryLogStatus' => '<p>An indicator as to whether query logging has been enabled or disabled for the membership.</p>', 'Membership$queryLogStatus' => '<p>An indicator as to whether query logging has been enabled or disabled for the membership.</p>', 'UpdateMembershipInput$queryLogStatus' => '<p>An indicator as to whether query logging has been enabled or disabled for the membership.</p>', ], ], 'MembershipStatus' => [ 'base' => NULL, 'refs' => [ 'ListMembershipsInput$status' => '<p>A filter which will return only memberships in the specified status.</p>', 'Membership$status' => '<p>The status of the membership.</p>', 'MembershipSummary$status' => '<p>The status of the membership.</p>', ], ], 'MembershipSummary' => [ 'base' => '<p>The membership object listed by the request.</p>', 'refs' => [ 'MembershipSummaryList$member' => NULL, ], ], 'MembershipSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListMembershipsOutput$membershipSummaries' => '<p>The list of memberships returned from the ListMemberships operation.</p>', ], ], 'PaginationToken' => [ 'base' => NULL, 'refs' => [ 'ListAnalysisTemplatesInput$nextToken' => '<p>The token value retrieved from a previous call to access the next page of results.</p>', 'ListAnalysisTemplatesOutput$nextToken' => '<p>The token value retrieved from a previous call to access the next page of results.</p>', 'ListCollaborationAnalysisTemplatesInput$nextToken' => '<p>The token value retrieved from a previous call to access the next page of results.</p>', 'ListCollaborationAnalysisTemplatesOutput$nextToken' => '<p>The token value retrieved from a previous call to access the next page of results.</p>', 'ListCollaborationConfiguredAudienceModelAssociationsInput$nextToken' => '<p>The token value retrieved from a previous call to access the next page of results.</p>', 'ListCollaborationConfiguredAudienceModelAssociationsOutput$nextToken' => '<p>The token value retrieved from a previous call to access the next page of results.</p>', 'ListCollaborationPrivacyBudgetTemplatesInput$nextToken' => '<p>The token value retrieved from a previous call to access the next page of results.</p>', 'ListCollaborationPrivacyBudgetTemplatesOutput$nextToken' => '<p>The token value retrieved from a previous call to access the next page of results.</p>', 'ListCollaborationPrivacyBudgetsInput$nextToken' => '<p>The token value retrieved from a previous call to access the next page of results.</p>', 'ListCollaborationPrivacyBudgetsOutput$nextToken' => '<p>The token value retrieved from a previous call to access the next page of results.</p>', 'ListCollaborationsInput$nextToken' => '<p>The token value retrieved from a previous call to access the next page of results.</p>', 'ListCollaborationsOutput$nextToken' => '<p>The token value retrieved from a previous call to access the next page of results.</p>', 'ListConfiguredAudienceModelAssociationsInput$nextToken' => '<p>The token value retrieved from a previous call to access the next page of results.</p>', 'ListConfiguredAudienceModelAssociationsOutput$nextToken' => '<p>The token value provided to access the next page of results.</p>', 'ListConfiguredTableAssociationsInput$nextToken' => '<p>The token value retrieved from a previous call to access the next page of results.</p>', 'ListConfiguredTableAssociationsOutput$nextToken' => '<p>The token value retrieved from a previous call to access the next page of results.</p>', 'ListConfiguredTablesInput$nextToken' => '<p>The token value retrieved from a previous call to access the next page of results.</p>', 'ListConfiguredTablesOutput$nextToken' => '<p>The token value retrieved from a previous call to access the next page of results.</p>', 'ListMembersInput$nextToken' => '<p>The token value retrieved from a previous call to access the next page of results.</p>', 'ListMembersOutput$nextToken' => '<p>The token value retrieved from a previous call to access the next page of results.</p>', 'ListMembershipsInput$nextToken' => '<p>The token value retrieved from a previous call to access the next page of results.</p>', 'ListMembershipsOutput$nextToken' => '<p>The token value retrieved from a previous call to access the next page of results.</p>', 'ListPrivacyBudgetTemplatesInput$nextToken' => '<p>The token value retrieved from a previous call to access the next page of results.</p>', 'ListPrivacyBudgetTemplatesOutput$nextToken' => '<p>The token value retrieved from a previous call to access the next page of results.</p>', 'ListPrivacyBudgetsInput$nextToken' => '<p>The token value retrieved from a previous call to access the next page of results.</p>', 'ListPrivacyBudgetsOutput$nextToken' => '<p>The token value retrieved from a previous call to access the next page of results.</p>', 'ListProtectedQueriesInput$nextToken' => '<p>The token value retrieved from a previous call to access the next page of results.</p>', 'ListProtectedQueriesOutput$nextToken' => '<p>The token value retrieved from a previous call to access the next page of results.</p>', 'ListSchemasInput$nextToken' => '<p>The token value retrieved from a previous call to access the next page of results.</p>', 'ListSchemasOutput$nextToken' => '<p>The token value retrieved from a previous call to access the next page of results.</p>', ], ], 'ParameterMap' => [ 'base' => NULL, 'refs' => [ 'ProtectedQuerySQLParameters$parameters' => '<p>The protected query SQL parameters.</p>', ], ], 'ParameterName' => [ 'base' => NULL, 'refs' => [ 'AnalysisParameter$name' => '<p>The name of the parameter. The name must use only alphanumeric, underscore (_), or hyphen (-) characters but cannot start or end with a hyphen.</p>', 'ParameterMap$key' => NULL, ], ], 'ParameterType' => [ 'base' => NULL, 'refs' => [ 'AnalysisParameter$type' => '<p>The type of parameter.</p>', ], ], 'ParameterValue' => [ 'base' => NULL, 'refs' => [ 'AnalysisParameter$defaultValue' => '<p>Optional. The default value that is applied in the analysis template. The member who can query can override this value in the query editor.</p>', 'ParameterMap$value' => NULL, ], ], 'PaymentConfiguration' => [ 'base' => '<p>An object representing the collaboration member\'s payment responsibilities set by the collaboration creator.</p>', 'refs' => [ 'CreateCollaborationInput$creatorPaymentConfiguration' => '<p>The collaboration creator\'s payment responsibilities set by the collaboration creator. </p> <p>If the collaboration creator hasn\'t specified anyone as the member paying for query compute costs, then the member who can query is the default payer.</p>', 'MemberSpecification$paymentConfiguration' => '<p>The collaboration member\'s payment responsibilities set by the collaboration creator. </p> <p>If the collaboration creator hasn\'t speciﬁed anyone as the member paying for query compute costs, then the member who can query is the default payer.</p>', 'MemberSummary$paymentConfiguration' => '<p>The collaboration member\'s payment responsibilities set by the collaboration creator. </p>', ], ], 'PreviewPrivacyImpactInput' => [ 'base' => NULL, 'refs' => [], ], 'PreviewPrivacyImpactOutput' => [ 'base' => NULL, 'refs' => [], ], 'PreviewPrivacyImpactParametersInput' => [ 'base' => '<p>Specifies the updated epsilon and noise parameters to preview. The preview allows you to see how the maximum number of each type of aggregation function would change with the new parameters.</p>', 'refs' => [ 'PreviewPrivacyImpactInput$parameters' => '<p>Specifies the desired epsilon and noise parameters to preview.</p>', ], ], 'PrivacyBudget' => [ 'base' => '<p>The epsilon parameter value and number of each aggregation function that you can perform.</p>', 'refs' => [ 'CollaborationPrivacyBudgetSummary$budget' => '<p>The includes epsilon provided and utility in terms of aggregations.</p>', 'PrivacyBudgetSummary$budget' => '<p>The provided privacy budget.</p>', ], ], 'PrivacyBudgetSummary' => [ 'base' => '<p>An array that summaries the specified privacy budget. This summary includes collaboration information, creation information, membership information, and privacy budget information.</p>', 'refs' => [ 'PrivacyBudgetSummaryList$member' => NULL, ], ], 'PrivacyBudgetSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListPrivacyBudgetsOutput$privacyBudgetSummaries' => '<p>An array that summarizes the privacy budgets. The summary includes collaboration information, membership information, privacy budget template information, and privacy budget details.</p>', ], ], 'PrivacyBudgetTemplate' => [ 'base' => '<p>An object that defines the privacy budget template.</p>', 'refs' => [ 'CreatePrivacyBudgetTemplateOutput$privacyBudgetTemplate' => '<p>A summary of the elements in the privacy budget template.</p>', 'GetPrivacyBudgetTemplateOutput$privacyBudgetTemplate' => '<p>Returns the details of the privacy budget template that you requested.</p>', 'UpdatePrivacyBudgetTemplateOutput$privacyBudgetTemplate' => '<p>Summary of the privacy budget template.</p>', ], ], 'PrivacyBudgetTemplateArn' => [ 'base' => NULL, 'refs' => [ 'CollaborationPrivacyBudgetSummary$privacyBudgetTemplateArn' => '<p>The ARN of the collaboration privacy budget template.</p>', 'CollaborationPrivacyBudgetTemplate$arn' => '<p>The ARN of the collaboration privacy budget template.</p>', 'CollaborationPrivacyBudgetTemplateSummary$arn' => '<p>The ARN of the collaboration privacy budget template.</p>', 'PrivacyBudgetSummary$privacyBudgetTemplateArn' => '<p>The ARN of the privacy budget template.</p>', 'PrivacyBudgetTemplate$arn' => '<p>The ARN of the privacy budget template.</p>', 'PrivacyBudgetTemplateSummary$arn' => '<p>The ARN of the privacy budget template.</p>', ], ], 'PrivacyBudgetTemplateAutoRefresh' => [ 'base' => NULL, 'refs' => [ 'CollaborationPrivacyBudgetTemplate$autoRefresh' => '<p>How often the privacy budget refreshes.</p> <important> <p>If you plan to regularly bring new data into the collaboration, use <code>CALENDAR_MONTH</code> to automatically get a new privacy budget for the collaboration every calendar month. Choosing this option allows arbitrary amounts of information to be revealed about rows of the data when repeatedly queried across refreshes. Avoid choosing this if the same rows will be repeatedly queried between privacy budget refreshes.</p> </important>', 'CreatePrivacyBudgetTemplateInput$autoRefresh' => '<p>How often the privacy budget refreshes.</p> <important> <p>If you plan to regularly bring new data into the collaboration, you can use <code>CALENDAR_MONTH</code> to automatically get a new privacy budget for the collaboration every calendar month. Choosing this option allows arbitrary amounts of information to be revealed about rows of the data when repeatedly queries across refreshes. Avoid choosing this if the same rows will be repeatedly queried between privacy budget refreshes.</p> </important>', 'PrivacyBudgetTemplate$autoRefresh' => '<p>How often the privacy budget refreshes.</p> <important> <p>If you plan to regularly bring new data into the collaboration, use <code>CALENDAR_MONTH</code> to automatically get a new privacy budget for the collaboration every calendar month. Choosing this option allows arbitrary amounts of information to be revealed about rows of the data when repeatedly queried across refreshes. Avoid choosing this if the same rows will be repeatedly queried between privacy budget refreshes.</p> </important>', ], ], 'PrivacyBudgetTemplateIdentifier' => [ 'base' => NULL, 'refs' => [ 'CollaborationPrivacyBudgetSummary$privacyBudgetTemplateId' => '<p>The unique identifier of the collaboration privacy budget template.</p>', 'CollaborationPrivacyBudgetTemplate$id' => '<p>The unique identifier of the collaboration privacy budget template.</p>', 'CollaborationPrivacyBudgetTemplateSummary$id' => '<p>The unique identifier of the collaboration privacy budget template.</p>', 'DeletePrivacyBudgetTemplateInput$privacyBudgetTemplateIdentifier' => '<p>A unique identifier for your privacy budget template. </p>', 'GetCollaborationPrivacyBudgetTemplateInput$privacyBudgetTemplateIdentifier' => '<p>A unique identifier for one of your privacy budget templates.</p>', 'GetPrivacyBudgetTemplateInput$privacyBudgetTemplateIdentifier' => '<p>A unique identifier for your privacy budget template.</p>', 'PrivacyBudgetSummary$privacyBudgetTemplateId' => '<p>The unique identifier of the privacy budget template.</p>', 'PrivacyBudgetTemplate$id' => '<p>The unique identifier of the privacy budget template.</p>', 'PrivacyBudgetTemplateSummary$id' => '<p>The unique identifier of the privacy budget template.</p>', 'UpdatePrivacyBudgetTemplateInput$privacyBudgetTemplateIdentifier' => '<p>A unique identifier for your privacy budget template that you want to update.</p>', ], ], 'PrivacyBudgetTemplateParametersInput' => [ 'base' => '<p>The epsilon and noise parameters that you want to use for the privacy budget template.</p>', 'refs' => [ 'CreatePrivacyBudgetTemplateInput$parameters' => '<p>Specifies your parameters for the privacy budget template.</p>', ], ], 'PrivacyBudgetTemplateParametersOutput' => [ 'base' => '<p>The epsilon and noise parameters that were used in the privacy budget template.</p>', 'refs' => [ 'CollaborationPrivacyBudgetTemplate$parameters' => '<p>Specifies the epsilon and noise parameters for the privacy budget template.</p>', 'PrivacyBudgetTemplate$parameters' => '<p>Specifies the epislon and noise parameters for the privacy budget template.</p>', ], ], 'PrivacyBudgetTemplateSummary' => [ 'base' => '<p>A summary of the privacy budget template. The summary includes membership information, collaboration information, and creation information.</p>', 'refs' => [ 'PrivacyBudgetTemplateSummaryList$member' => NULL, ], ], 'PrivacyBudgetTemplateSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListPrivacyBudgetTemplatesOutput$privacyBudgetTemplateSummaries' => '<p>An array that summarizes the privacy budget templates. The summary includes collaboration information, creation information, and privacy budget type.</p>', ], ], 'PrivacyBudgetTemplateUpdateParameters' => [ 'base' => '<p>The epsilon and noise parameters that you want to update in the privacy budget template.</p>', 'refs' => [ 'UpdatePrivacyBudgetTemplateInput$parameters' => '<p>Specifies the epsilon and noise parameters for the privacy budget template.</p>', ], ], 'PrivacyBudgetType' => [ 'base' => NULL, 'refs' => [ 'CollaborationPrivacyBudgetSummary$type' => '<p>The type of privacy budget template.</p>', 'CollaborationPrivacyBudgetTemplate$privacyBudgetType' => '<p>The type of privacy budget template.</p>', 'CollaborationPrivacyBudgetTemplateSummary$privacyBudgetType' => '<p>The type of the privacy budget template.</p>', 'CreatePrivacyBudgetTemplateInput$privacyBudgetType' => '<p>Specifies the type of the privacy budget template.</p>', 'ListCollaborationPrivacyBudgetsInput$privacyBudgetType' => '<p>Specifies the type of the privacy budget.</p>', 'ListPrivacyBudgetsInput$privacyBudgetType' => '<p>The privacy budget type.</p>', 'PrivacyBudgetSummary$type' => '<p>Specifies the type of the privacy budget.</p>', 'PrivacyBudgetTemplate$privacyBudgetType' => '<p>Specifies the type of the privacy budget template.</p>', 'PrivacyBudgetTemplateSummary$privacyBudgetType' => '<p>The type of the privacy budget template.</p>', 'UpdatePrivacyBudgetTemplateInput$privacyBudgetType' => '<p>Specifies the type of the privacy budget template.</p>', ], ], 'PrivacyImpact' => [ 'base' => '<p>Provides an estimate of the number of aggregation functions that the member who can query can run given the epsilon and noise parameters.</p>', 'refs' => [ 'PreviewPrivacyImpactOutput$privacyImpact' => '<p>An estimate of the number of aggregation functions that the member who can query can run given the epsilon and noise parameters. This does not change the privacy budget.</p>', ], ], 'ProtectedQuery' => [ 'base' => '<p>The parameters for an Clean Rooms protected query.</p>', 'refs' => [ 'GetProtectedQueryOutput$protectedQuery' => '<p>The query processing metadata.</p>', 'StartProtectedQueryOutput$protectedQuery' => '<p>The protected query.</p>', 'UpdateProtectedQueryOutput$protectedQuery' => '<p>The protected query output.</p>', ], ], 'ProtectedQueryError' => [ 'base' => '<p>Details of errors thrown by the protected query.</p>', 'refs' => [ 'ProtectedQuery$error' => '<p>An error thrown by the protected query.</p>', ], ], 'ProtectedQueryIdentifier' => [ 'base' => NULL, 'refs' => [ 'GetProtectedQueryInput$protectedQueryIdentifier' => '<p>The identifier for a protected query instance.</p>', 'UpdateProtectedQueryInput$protectedQueryIdentifier' => '<p>The identifier for a protected query instance.</p>', ], ], 'ProtectedQueryMemberOutputList' => [ 'base' => NULL, 'refs' => [ 'ProtectedQueryOutput$memberList' => '<p>The list of member Amazon Web Services account(s) that received the results of the query. </p>', ], ], 'ProtectedQueryOutput' => [ 'base' => '<p>Contains details about the protected query output.</p>', 'refs' => [ 'ProtectedQueryResult$output' => '<p>The output of the protected query.</p>', ], ], 'ProtectedQueryOutputConfiguration' => [ 'base' => '<p>Contains configuration details for protected query output.</p>', 'refs' => [ 'ProtectedQueryResultConfiguration$outputConfiguration' => '<p>Configuration for protected query results.</p>', ], ], 'ProtectedQueryResult' => [ 'base' => '<p>Details about the query results.</p>', 'refs' => [ 'ProtectedQuery$result' => '<p>The result of the protected query.</p>', ], ], 'ProtectedQueryResultConfiguration' => [ 'base' => '<p>Contains configurations for protected query results.</p>', 'refs' => [ 'ProtectedQuery$resultConfiguration' => '<p>Contains any details needed to write the query results.</p>', 'StartProtectedQueryInput$resultConfiguration' => '<p>The details needed to write the query results.</p>', ], ], 'ProtectedQueryS3Output' => [ 'base' => '<p>Contains output information for protected queries with an S3 output type.</p>', 'refs' => [ 'ProtectedQueryOutput$s3' => '<p>If present, the output for a protected query with an `S3` output type.</p>', ], ], 'ProtectedQueryS3OutputConfiguration' => [ 'base' => '<p>Contains the configuration to write the query results to S3.</p>', 'refs' => [ 'MembershipProtectedQueryOutputConfiguration$s3' => NULL, 'ProtectedQueryOutputConfiguration$s3' => '<p>Required configuration for a protected query with an `S3` output type.</p>', ], ], 'ProtectedQueryS3OutputConfigurationBucketString' => [ 'base' => NULL, 'refs' => [ 'ProtectedQueryS3OutputConfiguration$bucket' => '<p>The S3 bucket to unload the protected query results.</p>', ], ], 'ProtectedQuerySQLParameters' => [ 'base' => '<p>The parameters for the SQL type Protected Query.</p>', 'refs' => [ 'ProtectedQuery$sqlParameters' => '<p>The protected query SQL parameters.</p>', 'StartProtectedQueryInput$sqlParameters' => '<p>The protected SQL query parameters.</p>', ], ], 'ProtectedQuerySQLParametersQueryStringString' => [ 'base' => NULL, 'refs' => [ 'ProtectedQuerySQLParameters$queryString' => '<p>The query string to be submitted.</p>', ], ], 'ProtectedQuerySingleMemberOutput' => [ 'base' => '<p>Details about the member who received the query result.</p>', 'refs' => [ 'ProtectedQueryMemberOutputList$member' => NULL, ], ], 'ProtectedQueryStatistics' => [ 'base' => '<p>Contains statistics about the execution of the protected query.</p>', 'refs' => [ 'ProtectedQuery$statistics' => '<p>Statistics about protected query execution.</p>', ], ], 'ProtectedQueryStatus' => [ 'base' => NULL, 'refs' => [ 'ListProtectedQueriesInput$status' => '<p>A filter on the status of the protected query.</p>', 'ProtectedQuery$status' => '<p>The status of the query.</p>', 'ProtectedQuerySummary$status' => '<p>The status of the protected query. Value values are `SUBMITTED`, `STARTED`, `CANCELLED`, `CANCELLING`, `FAILED`, `SUCCESS`, `TIMED_OUT`.</p>', ], ], 'ProtectedQuerySummary' => [ 'base' => '<p>The protected query summary for the objects listed by the request.</p>', 'refs' => [ 'ProtectedQuerySummaryList$member' => NULL, ], ], 'ProtectedQuerySummaryList' => [ 'base' => NULL, 'refs' => [ 'ListProtectedQueriesOutput$protectedQueries' => '<p>A list of protected queries.</p>', ], ], 'ProtectedQueryType' => [ 'base' => NULL, 'refs' => [ 'StartProtectedQueryInput$type' => '<p>The type of the protected query to be started.</p>', ], ], 'QueryComputePaymentConfig' => [ 'base' => '<p>An object representing the collaboration member\'s payment responsibilities set by the collaboration creator for query compute costs.</p>', 'refs' => [ 'PaymentConfiguration$queryCompute' => '<p>The collaboration member\'s payment responsibilities set by the collaboration creator for query compute costs.</p>', ], ], 'QueryTables' => [ 'base' => NULL, 'refs' => [ 'AnalysisSchema$referencedTables' => '<p>The tables referenced in the analysis schema.</p>', ], ], 'ResourceAlias' => [ 'base' => NULL, 'refs' => [ 'AnalysisTemplate$name' => '<p>The name of the analysis template.</p>', 'AnalysisTemplateSummary$name' => '<p>The name of the analysis template. </p>', 'CollaborationAnalysisTemplate$name' => '<p>The name of the analysis template.</p>', 'CollaborationAnalysisTemplateSummary$name' => '<p>The name of the analysis template.</p>', ], ], 'ResourceDescription' => [ 'base' => NULL, 'refs' => [ 'AnalysisTemplate$description' => '<p>The description of the analysis template.</p>', 'AnalysisTemplateSummary$description' => '<p>The description of the analysis template.</p>', 'CollaborationAnalysisTemplate$description' => '<p>The description of the analysis template.</p>', 'CollaborationAnalysisTemplateSummary$description' => '<p>The description of the analysis template.</p>', 'CollaborationConfiguredAudienceModelAssociation$description' => '<p>The description of the configured audience model association.</p>', 'CollaborationConfiguredAudienceModelAssociationSummary$description' => '<p>The description of the configured audience model association.</p>', 'ConfiguredAudienceModelAssociation$description' => '<p>The description of the configured audience model association.</p>', 'ConfiguredAudienceModelAssociationSummary$description' => '<p>The description of the configured audience model association.</p>', 'CreateAnalysisTemplateInput$description' => '<p>The description of the analysis template.</p>', 'CreateConfiguredAudienceModelAssociationInput$description' => '<p>A description of the configured audience model association.</p>', 'UpdateAnalysisTemplateInput$description' => '<p>A new description for the analysis template.</p>', 'UpdateConfiguredAudienceModelAssociationInput$description' => '<p>A new description for the configured audience model association.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>Request references a resource which does not exist.</p>', 'refs' => [], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'ConflictException$resourceType' => '<p>The type of the conflicting resource.</p>', 'ResourceNotFoundException$resourceType' => '<p>The type of the missing resource.</p>', ], ], 'ResultFormat' => [ 'base' => NULL, 'refs' => [ 'ProtectedQueryS3OutputConfiguration$resultFormat' => '<p>Intended file format of the result.</p>', ], ], 'RoleArn' => [ 'base' => NULL, 'refs' => [ 'ConfiguredTableAssociation$roleArn' => '<p>The service will assume this role to access catalog metadata and query the table.</p>', 'CreateConfiguredTableAssociationInput$roleArn' => '<p>The service will assume this role to access catalog metadata and query the table.</p>', 'MembershipProtectedQueryResultConfiguration$roleArn' => '<p>The unique ARN for an IAM role that is used by Clean Rooms to write protected query results to the result location, given by the member who can receive results.</p>', 'UpdateConfiguredTableAssociationInput$roleArn' => '<p>The service will assume this role to access catalog metadata and query the table.</p>', ], ], 'ScalarFunctions' => [ 'base' => NULL, 'refs' => [ 'ScalarFunctionsList$member' => NULL, ], ], 'ScalarFunctionsList' => [ 'base' => NULL, 'refs' => [ 'AnalysisRuleAggregation$scalarFunctions' => '<p>Set of scalar functions that are allowed to be used on dimension columns and the output of aggregation of metrics.</p>', ], ], 'Schema' => [ 'base' => '<p>A schema is a relation within a collaboration.</p>', 'refs' => [ 'GetSchemaOutput$schema' => '<p>The entire schema object.</p>', 'SchemaList$member' => NULL, ], ], 'SchemaAnalysisRuleList' => [ 'base' => NULL, 'refs' => [ 'BatchGetSchemaAnalysisRuleOutput$analysisRules' => '<p>The retrieved list of analysis rules.</p>', ], ], 'SchemaAnalysisRuleRequest' => [ 'base' => '<p>Defines the information that\'s necessary to retrieve an analysis rule schema. Schema analysis rules are uniquely identiﬁed by a combination of the schema name and the analysis rule type for a given collaboration.</p>', 'refs' => [ 'SchemaAnalysisRuleRequestList$member' => NULL, ], ], 'SchemaAnalysisRuleRequestList' => [ 'base' => NULL, 'refs' => [ 'BatchGetSchemaAnalysisRuleInput$schemaAnalysisRuleRequests' => '<p>The information that\'s necessary to retrieve a schema analysis rule.</p>', ], ], 'SchemaConfiguration' => [ 'base' => NULL, 'refs' => [ 'SchemaConfigurationList$member' => NULL, ], ], 'SchemaConfigurationList' => [ 'base' => NULL, 'refs' => [ 'SchemaStatusDetail$configurations' => '<p>The configuration details of the schema analysis rule for the given type.</p>', ], ], 'SchemaList' => [ 'base' => NULL, 'refs' => [ 'BatchGetSchemaOutput$schemas' => '<p>The retrieved list of schemas.</p>', ], ], 'SchemaStatus' => [ 'base' => NULL, 'refs' => [ 'SchemaStatusDetail$status' => '<p>The status of the schema.</p>', ], ], 'SchemaStatusDetail' => [ 'base' => '<p>Information about the schema status.</p> <p>A status of <code>READY</code> means that based on the schema analysis rule, queries of the given analysis rule type are properly configured to run queries on this schema.</p>', 'refs' => [ 'SchemaStatusDetailList$member' => NULL, ], ], 'SchemaStatusDetailList' => [ 'base' => NULL, 'refs' => [ 'Schema$schemaStatusDetails' => '<p>Details about the status of the schema. Currently, only one entry is present.</p>', ], ], 'SchemaStatusReason' => [ 'base' => '<p>A reason why the schema status is set to its current value.</p>', 'refs' => [ 'SchemaStatusReasonList$member' => NULL, ], ], 'SchemaStatusReasonCode' => [ 'base' => NULL, 'refs' => [ 'SchemaStatusReason$code' => '<p>The schema status reason code.</p>', ], ], 'SchemaStatusReasonList' => [ 'base' => NULL, 'refs' => [ 'SchemaStatusDetail$reasons' => '<p>The reasons why the schema status is set to its current state.</p>', ], ], 'SchemaSummary' => [ 'base' => '<p>The schema summary for the objects listed by the request.</p>', 'refs' => [ 'SchemaSummaryList$member' => NULL, ], ], 'SchemaSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListSchemasOutput$schemaSummaries' => '<p>The retrieved list of schemas.</p>', ], ], 'SchemaType' => [ 'base' => NULL, 'refs' => [ 'ListSchemasInput$schemaType' => '<p>If present, filter schemas by schema type. The only valid schema type is currently `TABLE`.</p>', 'Schema$type' => '<p>The type of schema. The only valid value is currently `TABLE`.</p>', 'SchemaSummary$type' => '<p>The type of schema object. The only valid schema type is currently `TABLE`.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>Request denied because service quota has been exceeded.</p>', 'refs' => [], ], 'StartProtectedQueryInput' => [ 'base' => NULL, 'refs' => [], ], 'StartProtectedQueryOutput' => [ 'base' => NULL, 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'AnalysisTemplateValidationStatusReason$message' => '<p>The validation message.</p>', 'BatchGetCollaborationAnalysisTemplateError$code' => '<p>An error code for the error.</p>', 'BatchGetCollaborationAnalysisTemplateError$message' => '<p>A description of why the call failed.</p>', 'BatchGetSchemaAnalysisRuleError$code' => '<p>An error code for the error.</p>', 'BatchGetSchemaAnalysisRuleError$message' => '<p>A description of why the call failed.</p>', 'BatchGetSchemaError$code' => '<p>An error code for the error. </p>', 'BatchGetSchemaError$message' => '<p>An error message for the error.</p>', 'ConflictException$message' => NULL, 'ConflictException$resourceId' => '<p>The ID of the conflicting resource.</p>', 'DifferentialPrivacyColumn$name' => '<p>The name of the column, such as user_id, that contains the unique identifier of your users, whose privacy you want to protect. If you want to turn on differential privacy for two or more tables in a collaboration, you must configure the same column as the user identifier column in both analysis rules.</p>', 'InternalServerException$message' => NULL, 'ProtectedQueryError$message' => '<p>A description of why the query failed.</p>', 'ProtectedQueryError$code' => '<p>An error code for the error.</p>', 'ProtectedQueryS3Output$location' => '<p>The S3 location of the result.</p>', 'ResourceNotFoundException$message' => NULL, 'ResourceNotFoundException$resourceId' => '<p>The Id of the missing resource.</p>', 'SchemaStatusReason$message' => '<p>An explanation of the schema status reason code.</p>', 'ServiceQuotaExceededException$message' => NULL, 'ServiceQuotaExceededException$quotaName' => '<p>The name of the quota.</p>', 'ThrottlingException$message' => NULL, 'ValidationException$message' => NULL, 'ValidationExceptionField$name' => '<p>The name of the input parameter.</p>', 'ValidationExceptionField$message' => '<p>A message for the input validation error.</p>', ], ], 'TableAlias' => [ 'base' => NULL, 'refs' => [ 'AnalysisRule$name' => '<p>The name for the analysis rule.</p>', 'BatchGetSchemaAnalysisRuleError$name' => '<p>An error name for the error.</p>', 'BatchGetSchemaError$name' => '<p>An error name for the error.</p>', 'ConfiguredTableAssociation$name' => '<p>The name of the configured table association, in lowercase. The table is identified by this name when running protected queries against the underlying data.</p>', 'ConfiguredTableAssociationSummary$name' => '<p>The name of the configured table association. The table is identified by this name when running Protected Queries against the underlying data.</p>', 'CreateAnalysisTemplateInput$name' => '<p>The name of the analysis template.</p>', 'CreateConfiguredTableAssociationInput$name' => '<p>The name of the configured table association. This name is used to query the underlying configured table.</p>', 'GetSchemaAnalysisRuleInput$name' => '<p>The name of the schema to retrieve the analysis rule for.</p>', 'GetSchemaInput$name' => '<p>The name of the relation to retrieve the schema for.</p>', 'QueryTables$member' => NULL, 'Schema$name' => '<p>A name for the schema. The schema relation is referred to by this name when queried by a protected query.</p>', 'SchemaAnalysisRuleRequest$name' => '<p>The name of the analysis rule schema that you are requesting.</p>', 'SchemaSummary$name' => '<p>The name for the schema object.</p>', 'TableAliasList$member' => NULL, ], ], 'TableAliasList' => [ 'base' => NULL, 'refs' => [ 'BatchGetSchemaInput$names' => '<p>The names for the schema objects to retrieve.</p>', ], ], 'TableDescription' => [ 'base' => NULL, 'refs' => [ 'ConfiguredTable$description' => '<p>A description for the configured table.</p>', 'ConfiguredTableAssociation$description' => '<p>A description of the configured table association.</p>', 'CreateConfiguredTableAssociationInput$description' => '<p>A description for the configured table association.</p>', 'CreateConfiguredTableInput$description' => '<p>A description for the configured table.</p>', 'Schema$description' => '<p>A description for the schema.</p>', 'UpdateConfiguredTableAssociationInput$description' => '<p>A new description for the configured table association.</p>', 'UpdateConfiguredTableInput$description' => '<p>A new description for the configured table.</p>', ], ], 'TableReference' => [ 'base' => '<p>A pointer to the dataset that underlies this table. Currently, this can only be an Glue table.</p>', 'refs' => [ 'ConfiguredTable$tableReference' => '<p>The Glue table that this configured table represents.</p>', 'CreateConfiguredTableInput$tableReference' => '<p>A reference to the Glue table being configured.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeys$member' => NULL, 'TagMap$key' => NULL, ], ], 'TagKeys' => [ 'base' => NULL, 'refs' => [ 'UntagResourceInput$tagKeys' => '<p>A list of key names of tags to be removed.</p>', ], ], 'TagMap' => [ 'base' => '<p>Map of tags assigned to a resource</p>', 'refs' => [ 'CreateAnalysisTemplateInput$tags' => '<p>An optional label that you can assign to a resource when you create it. Each tag consists of a key and an optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM policies to control access to this resource.</p>', 'CreateCollaborationInput$tags' => '<p>An optional label that you can assign to a resource when you create it. Each tag consists of a key and an optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM policies to control access to this resource.</p>', 'CreateConfiguredAudienceModelAssociationInput$tags' => '<p>An optional label that you can assign to a resource when you create it. Each tag consists of a key and an optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM policies to control access to this resource.</p>', 'CreateConfiguredTableAssociationInput$tags' => '<p>An optional label that you can assign to a resource when you create it. Each tag consists of a key and an optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM policies to control access to this resource.</p>', 'CreateConfiguredTableInput$tags' => '<p>An optional label that you can assign to a resource when you create it. Each tag consists of a key and an optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM policies to control access to this resource.</p>', 'CreateMembershipInput$tags' => '<p>An optional label that you can assign to a resource when you create it. Each tag consists of a key and an optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM policies to control access to this resource.</p>', 'CreatePrivacyBudgetTemplateInput$tags' => '<p>An optional label that you can assign to a resource when you create it. Each tag consists of a key and an optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM policies to control access to this resource.</p>', 'ListTagsForResourceOutput$tags' => '<p>A map of objects specifying each key name and value.</p>', 'TagResourceInput$tags' => '<p>A map of objects specifying each key name and value.</p>', ], ], 'TagResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagMap$value' => NULL, ], ], 'TargetProtectedQueryStatus' => [ 'base' => NULL, 'refs' => [ 'UpdateProtectedQueryInput$targetStatus' => '<p>The target status of a query. Used to update the execution status of a currently running query.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>Request was denied due to request throttling.</p>', 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'AnalysisRule$createTime' => '<p>The time the analysis rule was created.</p>', 'AnalysisRule$updateTime' => '<p>The time the analysis rule was last updated.</p>', 'AnalysisTemplate$createTime' => '<p>The time that the analysis template was created.</p>', 'AnalysisTemplate$updateTime' => '<p>The time that the analysis template was last updated.</p>', 'AnalysisTemplateSummary$createTime' => '<p>The time that the analysis template summary was created.</p>', 'AnalysisTemplateSummary$updateTime' => '<p>The time that the analysis template summary was last updated.</p>', 'Collaboration$createTime' => '<p>The time when the collaboration was created.</p>', 'Collaboration$updateTime' => '<p>The time the collaboration metadata was last updated.</p>', 'CollaborationAnalysisTemplate$createTime' => '<p>The time that the analysis template within a collaboration was created.</p>', 'CollaborationAnalysisTemplate$updateTime' => '<p>The time that the analysis template in the collaboration was last updated.</p>', 'CollaborationAnalysisTemplateSummary$createTime' => '<p>The time that the summary of the analysis template in a collaboration was created.</p>', 'CollaborationAnalysisTemplateSummary$updateTime' => '<p>The time that the summary of the analysis template in the collaboration was last updated.</p>', 'CollaborationConfiguredAudienceModelAssociation$createTime' => '<p>The time at which the configured audience model association was created.</p>', 'CollaborationConfiguredAudienceModelAssociation$updateTime' => '<p>The most recent time at which the configured audience model association was updated.</p>', 'CollaborationConfiguredAudienceModelAssociationSummary$createTime' => '<p>The time at which the configured audience model association was created.</p>', 'CollaborationConfiguredAudienceModelAssociationSummary$updateTime' => '<p>The most recent time at which the configured audience model association was updated.</p>', 'CollaborationPrivacyBudgetSummary$createTime' => '<p>The time at which the privacy budget was created.</p>', 'CollaborationPrivacyBudgetSummary$updateTime' => '<p>The most recent time at which the privacy budget was updated.</p>', 'CollaborationPrivacyBudgetTemplate$createTime' => '<p>The time at which the collaboration privacy budget template was created.</p>', 'CollaborationPrivacyBudgetTemplate$updateTime' => '<p>The most recent time at which the collaboration privacy budget template was updated.</p>', 'CollaborationPrivacyBudgetTemplateSummary$createTime' => '<p>The time at which the collaboration privacy budget template was created.</p>', 'CollaborationPrivacyBudgetTemplateSummary$updateTime' => '<p>The most recent time at which the collaboration privacy budget template was updated.</p>', 'CollaborationSummary$createTime' => '<p>The time when the collaboration was created.</p>', 'CollaborationSummary$updateTime' => '<p>The time the collaboration metadata was last updated.</p>', 'ConfiguredAudienceModelAssociation$createTime' => '<p>The time at which the configured audience model association was created.</p>', 'ConfiguredAudienceModelAssociation$updateTime' => '<p>The most recent time at which the configured audience model association was updated.</p>', 'ConfiguredAudienceModelAssociationSummary$createTime' => '<p>The time at which the configured audience model association was created.</p>', 'ConfiguredAudienceModelAssociationSummary$updateTime' => '<p>The most recent time at which the configured audience model association was updated.</p>', 'ConfiguredTable$createTime' => '<p>The time the configured table was created.</p>', 'ConfiguredTable$updateTime' => '<p>The time the configured table was last updated</p>', 'ConfiguredTableAnalysisRule$createTime' => '<p>The time the configured table analysis rule was created.</p>', 'ConfiguredTableAnalysisRule$updateTime' => '<p>The time the configured table analysis rule was last updated.</p>', 'ConfiguredTableAssociation$createTime' => '<p>The time the configured table association was created.</p>', 'ConfiguredTableAssociation$updateTime' => '<p>The time the configured table association was last updated.</p>', 'ConfiguredTableAssociationSummary$createTime' => '<p>The time the configured table association was created.</p>', 'ConfiguredTableAssociationSummary$updateTime' => '<p>The time the configured table association was last updated.</p>', 'ConfiguredTableSummary$createTime' => '<p>The time the configured table was created.</p>', 'ConfiguredTableSummary$updateTime' => '<p>The time the configured table was last updated.</p>', 'MemberSummary$createTime' => '<p>The time when the member was created.</p>', 'MemberSummary$updateTime' => '<p>The time the member metadata was last updated.</p>', 'Membership$createTime' => '<p>The time when the membership was created.</p>', 'Membership$updateTime' => '<p>The time the membership metadata was last updated.</p>', 'MembershipSummary$createTime' => '<p>The time when the membership was created.</p>', 'MembershipSummary$updateTime' => '<p>The time the membership metadata was last updated.</p>', 'PrivacyBudgetSummary$createTime' => '<p>The time at which the privacy budget was created.</p>', 'PrivacyBudgetSummary$updateTime' => '<p>The most recent time at which the privacy budget was updated.</p>', 'PrivacyBudgetTemplate$createTime' => '<p>The time at which the privacy budget template was created.</p>', 'PrivacyBudgetTemplate$updateTime' => '<p>The most recent time at which the privacy budget template was updated.</p>', 'PrivacyBudgetTemplateSummary$createTime' => '<p>The time at which the privacy budget template was created.</p>', 'PrivacyBudgetTemplateSummary$updateTime' => '<p>The most recent time at which the privacy budget template was updated.</p>', 'ProtectedQuery$createTime' => '<p>The time at which the protected query was created.</p>', 'ProtectedQuerySummary$createTime' => '<p>The time the protected query was created.</p>', 'Schema$createTime' => '<p>The time the schema was created.</p>', 'Schema$updateTime' => '<p>The time the schema was last updated.</p>', 'SchemaSummary$createTime' => '<p>The time the schema object was created.</p>', 'SchemaSummary$updateTime' => '<p>The time the schema object was last updated.</p>', ], ], 'UUID' => [ 'base' => NULL, 'refs' => [ 'AnalysisTemplate$collaborationId' => '<p>The unique ID for the associated collaboration of the analysis template.</p>', 'AnalysisTemplate$membershipId' => '<p>The identifier of a member who created the analysis template.</p>', 'AnalysisTemplateSummary$membershipId' => '<p>The identifier for a membership resource.</p>', 'AnalysisTemplateSummary$collaborationId' => '<p>A unique identifier for the collaboration that the analysis template summary belongs to. Currently accepts collaboration ID.</p>', 'Collaboration$id' => '<p>The unique ID for the collaboration.</p>', 'Collaboration$membershipId' => '<p>The unique ID for your membership within the collaboration.</p>', 'CollaborationAnalysisTemplate$collaborationId' => '<p>A unique identifier for the collaboration that the analysis templates belong to. Currently accepts collaboration ID.</p>', 'CollaborationAnalysisTemplateSummary$collaborationId' => '<p>A unique identifier for the collaboration that the analysis templates belong to. Currently accepts collaboration ID.</p>', 'CollaborationConfiguredAudienceModelAssociation$collaborationId' => '<p>A unique identifier for the collaboration that the configured audience model associations belong to. Accepts collaboration ID.</p>', 'CollaborationConfiguredAudienceModelAssociationSummary$collaborationId' => '<p>A unique identifier for the collaboration that the configured audience model associations belong to. Accepts collaboration ID.</p>', 'CollaborationPrivacyBudgetSummary$id' => '<p>The unique identifier of the collaboration privacy budget.</p>', 'CollaborationPrivacyBudgetSummary$collaborationId' => '<p>The unique identifier of the collaboration that includes this privacy budget.</p>', 'CollaborationPrivacyBudgetTemplate$collaborationId' => '<p>The unique identifier of the collaboration that includes this collaboration privacy budget template.</p>', 'CollaborationPrivacyBudgetTemplateSummary$collaborationId' => '<p>The unique identifier of the collaboration that contains this collaboration privacy budget template.</p>', 'CollaborationSummary$id' => '<p>The identifier for the collaboration.</p>', 'CollaborationSummary$membershipId' => '<p>The identifier of a member in a collaboration.</p>', 'ConfiguredAudienceModelAssociation$membershipId' => '<p>A unique identifier for the membership that contains this configured audience model association.</p>', 'ConfiguredAudienceModelAssociation$collaborationId' => '<p>A unique identifier of the collaboration that contains this configured audience model association.</p>', 'ConfiguredAudienceModelAssociationSummary$collaborationId' => '<p>A unique identifier of the collaboration that configured audience model is associated with.</p>', 'ConfiguredAudienceModelAssociationSummary$id' => '<p>A unique identifier of the configured audience model association.</p>', 'ConfiguredTable$id' => '<p>The unique ID for the configured table.</p>', 'ConfiguredTableAnalysisRule$configuredTableId' => '<p>The unique ID for the configured table.</p>', 'ConfiguredTableAssociation$id' => '<p>The unique ID for the configured table association.</p>', 'ConfiguredTableAssociation$configuredTableId' => '<p>The unique ID for the configured table that the association refers to.</p>', 'ConfiguredTableAssociation$membershipId' => '<p>The unique ID for the membership this configured table association belongs to.</p>', 'ConfiguredTableAssociationSummary$configuredTableId' => '<p>The unique configured table ID that this configured table association refers to.</p>', 'ConfiguredTableAssociationSummary$id' => '<p>The unique ID for the configured table association.</p>', 'MemberSummary$membershipId' => '<p>The unique ID for the member\'s associated membership, if present.</p>', 'Membership$id' => '<p>The unique ID of the membership.</p>', 'Membership$collaborationId' => '<p>The unique ID for the membership\'s collaboration.</p>', 'MembershipSummary$id' => '<p>The unique ID for the membership\'s collaboration.</p>', 'PrivacyBudgetSummary$id' => '<p>The unique identifier of the privacy budget.</p>', 'PrivacyBudgetSummary$collaborationId' => '<p>The unique identifier of the collaboration that contains this privacy budget.</p>', 'PrivacyBudgetTemplate$membershipId' => '<p>The identifier for a membership resource.</p>', 'PrivacyBudgetTemplate$collaborationId' => '<p>The unique ID of the collaboration that contains this privacy budget template.</p>', 'PrivacyBudgetTemplateSummary$membershipId' => '<p>The identifier for a membership resource.</p>', 'PrivacyBudgetTemplateSummary$collaborationId' => '<p>The unique ID of the collaboration that contains this privacy budget template.</p>', 'ProtectedQuery$id' => '<p>The identifier for a protected query instance.</p>', 'ProtectedQuery$membershipId' => '<p>The identifier for the membership.</p>', 'ProtectedQuerySummary$id' => '<p>The unique ID of the protected query.</p>', 'ProtectedQuerySummary$membershipId' => '<p>The unique ID for the membership that initiated the protected query.</p>', 'Schema$collaborationId' => '<p>The unique ID for the collaboration that the schema belongs to.</p>', 'SchemaSummary$collaborationId' => '<p>The unique ID for the collaboration that the schema belongs to.</p>', ], ], 'UntagResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAnalysisTemplateInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAnalysisTemplateOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateCollaborationInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateCollaborationOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateConfiguredAudienceModelAssociationInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateConfiguredAudienceModelAssociationOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateConfiguredTableAnalysisRuleInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateConfiguredTableAnalysisRuleOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateConfiguredTableAssociationInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateConfiguredTableAssociationOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateConfiguredTableInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateConfiguredTableOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMembershipInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMembershipOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePrivacyBudgetTemplateInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePrivacyBudgetTemplateOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateProtectedQueryInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateProtectedQueryOutput' => [ 'base' => NULL, 'refs' => [], ], 'UsersNoisePerQuery' => [ 'base' => NULL, 'refs' => [ 'DifferentialPrivacyPreviewParametersInput$usersNoisePerQuery' => '<p>Noise added per query is measured in terms of the number of users whose contributions you want to obscure. This value governs the rate at which the privacy budget is depleted.</p>', 'DifferentialPrivacyTemplateParametersInput$usersNoisePerQuery' => '<p>Noise added per query is measured in terms of the number of users whose contributions you want to obscure. This value governs the rate at which the privacy budget is depleted.</p>', 'DifferentialPrivacyTemplateParametersOutput$usersNoisePerQuery' => '<p>Noise added per query is measured in terms of the number of users whose contributions you want to obscure. This value governs the rate at which the privacy budget is depleted.</p>', 'DifferentialPrivacyTemplateUpdateParameters$usersNoisePerQuery' => '<p>The updated value of noise added per query. It is measured in terms of the number of users whose contributions you want to obscure. This value governs the rate at which the privacy budget is depleted.</p>', ], ], 'ValidationException' => [ 'base' => '<p>The input fails to satisfy the specified constraints.</p>', 'refs' => [], ], 'ValidationExceptionField' => [ 'base' => '<p>Describes validation errors for specific input parameters.</p>', 'refs' => [ 'ValidationExceptionFieldList$member' => NULL, ], ], 'ValidationExceptionFieldList' => [ 'base' => NULL, 'refs' => [ 'ValidationException$fieldList' => '<p>Validation errors for specific input parameters.</p>', ], ], 'ValidationExceptionReason' => [ 'base' => NULL, 'refs' => [ 'ValidationException$reason' => '<p>A reason code for the exception.</p>', ], ], ],];
