<?php
// This file was auto-generated from sdk-root/src/data/cloudtrail-data/2021-08-11/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>The CloudTrail Data Service lets you ingest events into CloudTrail from any source in your hybrid environments, such as in-house or SaaS applications hosted on-premises or in the cloud, virtual machines, or containers. You can store, access, analyze, troubleshoot and take action on this data without maintaining multiple log aggregators and reporting tools. After you run <code>PutAuditEvents</code> to ingest your application activity into CloudTrail, you can use CloudTrail Lake to search, query, and analyze the data that is logged from your applications.</p>', 'operations' => [ 'PutAuditEvents' => '<p>Ingests your application events into CloudTrail Lake. A required parameter, <code>auditEvents</code>, accepts the JSON records (also called <i>payload</i>) of events that you want CloudTrail to ingest. You can add up to 100 of these events (or up to 1 MB) per <code>PutAuditEvents</code> request.</p>', ], 'shapes' => [ 'AuditEvent' => [ 'base' => '<p>An event from a source outside of Amazon Web Services that you want CloudTrail to log.</p>', 'refs' => [ 'AuditEvents$member' => NULL, ], ], 'AuditEventResultEntries' => [ 'base' => NULL, 'refs' => [ 'PutAuditEventsResponse$successful' => '<p>Lists events in the provided event payload that were successfully ingested into CloudTrail.</p>', ], ], 'AuditEventResultEntry' => [ 'base' => '<p>A response that includes successful and failed event results.</p>', 'refs' => [ 'AuditEventResultEntries$member' => NULL, ], ], 'AuditEvents' => [ 'base' => NULL, 'refs' => [ 'PutAuditEventsRequest$auditEvents' => '<p>The JSON payload of events that you want to ingest. You can also point to the JSON event payload in a file.</p>', ], ], 'ChannelArn' => [ 'base' => NULL, 'refs' => [ 'PutAuditEventsRequest$channelArn' => '<p>The ARN or ID (the ARN suffix) of a channel.</p>', ], ], 'ChannelInsufficientPermission' => [ 'base' => '<p>The caller\'s account ID must be the same as the channel owner\'s account ID.</p>', 'refs' => [], ], 'ChannelNotFound' => [ 'base' => '<p>The channel could not be found.</p>', 'refs' => [], ], 'ChannelUnsupportedSchema' => [ 'base' => '<p>The schema type of the event is not supported.</p>', 'refs' => [], ], 'DuplicatedAuditEventId' => [ 'base' => '<p>Two or more entries in the request have the same event ID.</p>', 'refs' => [], ], 'ErrorCode' => [ 'base' => NULL, 'refs' => [ 'ResultErrorEntry$errorCode' => '<p>The error code for events that could not be ingested by CloudTrail. Possible error codes include: <code>FieldTooLong</code>, <code>FieldNotFound</code>, <code>InvalidChecksum</code>, <code>InvalidData</code>, <code>InvalidRecipient</code>, <code>InvalidEventSource</code>, <code>AccountNotSubscribed</code>, <code>Throttling</code>, and <code>InternalFailure</code>.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'ResultErrorEntry$errorMessage' => '<p>The message that describes the error for events that could not be ingested by CloudTrail.</p>', ], ], 'ExternalId' => [ 'base' => NULL, 'refs' => [ 'PutAuditEventsRequest$externalId' => '<p>A unique identifier that is conditionally required when the channel\'s resource policy includes an external ID. This value can be any string, such as a passphrase or account number.</p>', ], ], 'InvalidChannelARN' => [ 'base' => '<p>The specified channel ARN is not a valid channel ARN.</p>', 'refs' => [], ], 'PutAuditEventsRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutAuditEventsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ResultErrorEntries' => [ 'base' => NULL, 'refs' => [ 'PutAuditEventsResponse$failed' => '<p>Lists events in the provided event payload that could not be ingested into CloudTrail, and includes the error code and error message returned for events that could not be ingested.</p>', ], ], 'ResultErrorEntry' => [ 'base' => '<p>Includes the error code and error message for events that could not be ingested by CloudTrail.</p>', 'refs' => [ 'ResultErrorEntries$member' => NULL, ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AuditEvent$eventData' => '<p>The content of an audit event that comes from the event, such as <code>userIdentity</code>, <code>userAgent</code>, and <code>eventSource</code>.</p>', 'AuditEvent$eventDataChecksum' => '<p>A checksum is a base64-SHA256 algorithm that helps you verify that CloudTrail receives the event that matches with the checksum. Calculate the checksum by running a command like the following:</p> <p> <code>printf %s <i>$eventdata</i> | openssl dgst -binary -sha256 | base64</code> </p>', 'ChannelInsufficientPermission$message' => NULL, 'ChannelNotFound$message' => NULL, 'ChannelUnsupportedSchema$message' => NULL, 'DuplicatedAuditEventId$message' => NULL, 'InvalidChannelARN$message' => NULL, 'UnsupportedOperationException$message' => NULL, ], ], 'UnsupportedOperationException' => [ 'base' => '<p>The operation requested is not supported in this region or account.</p>', 'refs' => [], ], 'Uuid' => [ 'base' => NULL, 'refs' => [ 'AuditEvent$id' => '<p>The original event ID from the source event.</p>', 'AuditEventResultEntry$eventID' => '<p>The event ID assigned by CloudTrail.</p>', 'AuditEventResultEntry$id' => '<p>The original event ID from the source event.</p>', 'ResultErrorEntry$id' => '<p>The original event ID from the source event that could not be ingested by CloudTrail.</p>', ], ], ],];
