<?php
// This file was auto-generated from sdk-root/src/data/codeconnections/2023-12-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>AWS CodeConnections</fullname> <p>This Amazon Web Services CodeConnections API Reference provides descriptions and usage examples of the operations and data types for the Amazon Web Services CodeConnections API. You can use the connections API to work with connections and installations.</p> <p> <i>Connections</i> are configurations that you use to connect Amazon Web Services resources to external code repositories. Each connection is a resource that can be given to services such as CodePipeline to connect to a third-party repository such as Bitbucket. For example, you can add the connection in CodePipeline so that it triggers your pipeline when a code change is made to your third-party code repository. Each connection is named and associated with a unique ARN that is used to reference the connection.</p> <p>When you create a connection, the console initiates a third-party connection handshake. <i>Installations</i> are the apps that are used to conduct this handshake. For example, the installation for the Bitbucket provider type is the Bitbucket app. When you create a connection, you can choose an existing installation or create one.</p> <p>When you want to create a connection to an installed provider type such as GitHub Enterprise Server, you create a <i>host</i> for your connections.</p> <p>You can work with connections by calling:</p> <ul> <li> <p> <a>CreateConnection</a>, which creates a uniquely named connection that can be referenced by services such as CodePipeline.</p> </li> <li> <p> <a>DeleteConnection</a>, which deletes the specified connection.</p> </li> <li> <p> <a>GetConnection</a>, which returns information about the connection, including the connection status.</p> </li> <li> <p> <a>ListConnections</a>, which lists the connections associated with your account.</p> </li> </ul> <p>You can work with hosts by calling:</p> <ul> <li> <p> <a>CreateHost</a>, which creates a host that represents the infrastructure where your provider is installed.</p> </li> <li> <p> <a>DeleteHost</a>, which deletes the specified host.</p> </li> <li> <p> <a>GetHost</a>, which returns information about the host, including the setup status.</p> </li> <li> <p> <a>ListHosts</a>, which lists the hosts associated with your account.</p> </li> </ul> <p>You can work with tags in Amazon Web Services CodeConnections by calling the following:</p> <ul> <li> <p> <a>ListTagsForResource</a>, which gets information about Amazon Web Services tags for a specified Amazon Resource Name (ARN) in Amazon Web Services CodeConnections.</p> </li> <li> <p> <a>TagResource</a>, which adds or updates tags for a resource in Amazon Web Services CodeConnections.</p> </li> <li> <p> <a>UntagResource</a>, which removes tags for a resource in Amazon Web Services CodeConnections.</p> </li> </ul> <p>For information about how to use Amazon Web Services CodeConnections, see the <a href="https://docs.aws.amazon.com/dtconsole/latest/userguide/welcome-connections.html">Developer Tools User Guide</a>.</p>', 'operations' => [ 'CreateConnection' => '<p>Creates a connection that can then be given to other Amazon Web Services services like CodePipeline so that it can access third-party code repositories. The connection is in pending status until the third-party connection handshake is completed from the console.</p>', 'CreateHost' => '<p>Creates a resource that represents the infrastructure where a third-party provider is installed. The host is used when you create connections to an installed third-party provider type, such as GitHub Enterprise Server. You create one host for all connections to that provider.</p> <note> <p>A host created through the CLI or the SDK is in `PENDING` status by default. You can make its status `AVAILABLE` by setting up the host in the console.</p> </note>', 'CreateRepositoryLink' => '<p>Creates a link to a specified external Git repository. A repository link allows Git sync to monitor and sync changes to files in a specified Git repository.</p>', 'CreateSyncConfiguration' => '<p>Creates a sync configuration which allows Amazon Web Services to sync content from a Git repository to update a specified Amazon Web Services resource. Parameters for the sync configuration are determined by the sync type.</p>', 'DeleteConnection' => '<p>The connection to be deleted.</p>', 'DeleteHost' => '<p>The host to be deleted. Before you delete a host, all connections associated to the host must be deleted.</p> <note> <p>A host cannot be deleted if it is in the VPC_CONFIG_INITIALIZING or VPC_CONFIG_DELETING state.</p> </note>', 'DeleteRepositoryLink' => '<p>Deletes the association between your connection and a specified external Git repository.</p>', 'DeleteSyncConfiguration' => '<p>Deletes the sync configuration for a specified repository and connection.</p>', 'GetConnection' => '<p>Returns the connection ARN and details such as status, owner, and provider type.</p>', 'GetHost' => '<p>Returns the host ARN and details such as status, provider type, endpoint, and, if applicable, the VPC configuration.</p>', 'GetRepositoryLink' => '<p>Returns details about a repository link. A repository link allows Git sync to monitor and sync changes from files in a specified Git repository.</p>', 'GetRepositorySyncStatus' => '<p>Returns details about the sync status for a repository. A repository sync uses Git sync to push and pull changes from your remote repository.</p>', 'GetResourceSyncStatus' => '<p>Returns the status of the sync with the Git repository for a specific Amazon Web Services resource.</p>', 'GetSyncBlockerSummary' => '<p>Returns a list of the most recent sync blockers.</p>', 'GetSyncConfiguration' => '<p>Returns details about a sync configuration, including the sync type and resource name. A sync configuration allows the configuration to sync (push and pull) changes from the remote repository for a specified branch in a Git repository.</p>', 'ListConnections' => '<p>Lists the connections associated with your account.</p>', 'ListHosts' => '<p>Lists the hosts associated with your account.</p>', 'ListRepositoryLinks' => '<p>Lists the repository links created for connections in your account.</p>', 'ListRepositorySyncDefinitions' => '<p>Lists the repository sync definitions for repository links in your account.</p>', 'ListSyncConfigurations' => '<p>Returns a list of sync configurations for a specified repository.</p>', 'ListTagsForResource' => '<p>Gets the set of key-value pairs (metadata) that are used to manage the resource.</p>', 'TagResource' => '<p>Adds to or modifies the tags of the given resource. Tags are metadata that can be used to manage a resource.</p>', 'UntagResource' => '<p>Removes tags from an Amazon Web Services resource.</p>', 'UpdateHost' => '<p>Updates a specified host with the provided configurations.</p>', 'UpdateRepositoryLink' => '<p>Updates the association between your connection and a specified external Git repository. A repository link allows Git sync to monitor and sync changes to files in a specified Git repository.</p>', 'UpdateSyncBlocker' => '<p>Allows you to update the status of a sync blocker, resolving the blocker and allowing syncing to continue.</p>', 'UpdateSyncConfiguration' => '<p>Updates the sync configuration for your connection and a specified external Git repository.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You do not have sufficient access to perform this action.</p>', 'refs' => [], ], 'AccountId' => [ 'base' => NULL, 'refs' => [ 'Connection$OwnerAccountId' => '<p>The identifier of the external provider where your third-party code repository is configured. For Bitbucket, this is the account ID of the owner of the Bitbucket repository.</p>', ], ], 'AmazonResourceName' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceInput$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource for which you want to get information about tags, if any.</p>', 'TagResourceInput$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource to which you want to add or update tags.</p>', 'UntagResourceInput$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource to remove tags from.</p>', ], ], 'BlockerStatus' => [ 'base' => NULL, 'refs' => [ 'SyncBlocker$Status' => '<p>The status for a specific sync blocker.</p>', ], ], 'BlockerType' => [ 'base' => NULL, 'refs' => [ 'SyncBlocker$Type' => '<p>The sync blocker type.</p>', ], ], 'BranchName' => [ 'base' => NULL, 'refs' => [ 'CreateSyncConfigurationInput$Branch' => '<p>The branch in the repository from which changes will be synced.</p>', 'GetRepositorySyncStatusInput$Branch' => '<p>The branch of the repository link for the requested repository sync status.</p>', 'RepositorySyncDefinition$Branch' => '<p>The branch specified for a repository sync definition.</p>', 'Revision$Branch' => '<p>The branch name for a specific revision.</p>', 'SyncConfiguration$Branch' => '<p>The branch associated with a specific sync configuration.</p>', 'UpdateSyncConfigurationInput$Branch' => '<p>The branch for the sync configuration to be updated.</p>', ], ], 'ConcurrentModificationException' => [ 'base' => '<p>Exception thrown as a result of concurrent modification to an application. For example, two individuals attempting to edit the same application at the same time. </p>', 'refs' => [], ], 'ConditionalCheckFailedException' => [ 'base' => '<p>The conditional check failed. Try again later.</p>', 'refs' => [], ], 'ConflictException' => [ 'base' => '<p>Two conflicting operations have been made on the same resource.</p>', 'refs' => [], ], 'Connection' => [ 'base' => '<p>A resource that is used to connect third-party source providers with services like CodePipeline.</p> <p>Note: A connection created through CloudFormation, the CLI, or the SDK is in `PENDING` status by default. You can make its status `AVAILABLE` by updating the connection in the console.</p>', 'refs' => [ 'ConnectionList$member' => NULL, 'GetConnectionOutput$Connection' => '<p>The connection details, such as status, owner, and provider type.</p>', ], ], 'ConnectionArn' => [ 'base' => NULL, 'refs' => [ 'Connection$ConnectionArn' => '<p>The Amazon Resource Name (ARN) of the connection. The ARN is used as the connection reference when the connection is shared between Amazon Web Services.</p> <note> <p>The ARN is never reused if the connection is deleted.</p> </note>', 'CreateConnectionOutput$ConnectionArn' => '<p>The Amazon Resource Name (ARN) of the connection to be created. The ARN is used as the connection reference when the connection is shared between Amazon Web Services services.</p> <note> <p>The ARN is never reused if the connection is deleted.</p> </note>', 'CreateRepositoryLinkInput$ConnectionArn' => '<p>The Amazon Resource Name (ARN) of the connection to be associated with the repository link.</p>', 'DeleteConnectionInput$ConnectionArn' => '<p>The Amazon Resource Name (ARN) of the connection to be deleted.</p> <note> <p>The ARN is never reused if the connection is deleted.</p> </note>', 'GetConnectionInput$ConnectionArn' => '<p>The Amazon Resource Name (ARN) of a connection.</p>', 'RepositoryLinkInfo$ConnectionArn' => '<p>The Amazon Resource Name (ARN) of the connection associated with the repository link.</p>', 'UpdateRepositoryLinkInput$ConnectionArn' => '<p>The Amazon Resource Name (ARN) of the connection for the repository link to be updated. The updated connection ARN must have the same providerType (such as GitHub) as the original connection ARN for the repo link.</p>', ], ], 'ConnectionList' => [ 'base' => NULL, 'refs' => [ 'ListConnectionsOutput$Connections' => '<p>A list of connections and the details for each connection, such as status, owner, and provider type.</p>', ], ], 'ConnectionName' => [ 'base' => NULL, 'refs' => [ 'Connection$ConnectionName' => '<p>The name of the connection. Connection names must be unique in an Amazon Web Services account.</p>', 'CreateConnectionInput$ConnectionName' => '<p>The name of the connection to be created.</p>', ], ], 'ConnectionStatus' => [ 'base' => NULL, 'refs' => [ 'Connection$ConnectionStatus' => '<p>The current status of the connection. </p>', ], ], 'CreateConnectionInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateConnectionOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateHostInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateHostOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateRepositoryLinkInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateRepositoryLinkOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateSyncConfigurationInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateSyncConfigurationOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreatedReason' => [ 'base' => NULL, 'refs' => [ 'SyncBlocker$CreatedReason' => '<p>The provided reason for a specific sync blocker.</p>', ], ], 'DeleteConnectionInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteConnectionOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteHostInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteHostOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRepositoryLinkInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRepositoryLinkOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSyncConfigurationInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSyncConfigurationOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeploymentFilePath' => [ 'base' => NULL, 'refs' => [ 'CreateSyncConfigurationInput$ConfigFile' => '<p>The file name of the configuration file that manages syncing between the connection and the repository. This configuration file is stored in the repository.</p>', 'SyncConfiguration$ConfigFile' => '<p>The file path to the configuration file associated with a specific sync configuration. The path should point to an actual file in the sync configurations linked repository.</p>', 'UpdateSyncConfigurationInput$ConfigFile' => '<p>The configuration file for the sync configuration to be updated.</p>', ], ], 'Directory' => [ 'base' => NULL, 'refs' => [ 'RepositorySyncDefinition$Directory' => '<p>The configuration file for a repository sync definition. This value comes from creating or updating the <code>config-file</code> field of a <code>sync-configuration</code>.</p>', 'Revision$Directory' => '<p>The directory, if any, for a specific revision.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => NULL, 'ConcurrentModificationException$Message' => NULL, 'ConditionalCheckFailedException$Message' => NULL, 'ConflictException$Message' => NULL, 'InternalServerException$Message' => NULL, 'InvalidInputException$Message' => NULL, 'LimitExceededException$Message' => NULL, 'ResourceAlreadyExistsException$Message' => NULL, 'ResourceNotFoundException$Message' => NULL, 'ResourceUnavailableException$Message' => NULL, 'RetryLatestCommitFailedException$Message' => NULL, 'SyncBlockerDoesNotExistException$Message' => NULL, 'SyncConfigurationStillExistsException$Message' => NULL, 'ThrottlingException$Message' => NULL, 'UnsupportedOperationException$Message' => NULL, 'UnsupportedProviderTypeException$Message' => NULL, 'UpdateOutOfSyncException$Message' => NULL, ], ], 'Event' => [ 'base' => NULL, 'refs' => [ 'RepositorySyncEvent$Event' => '<p>A description of a repository sync event.</p>', 'ResourceSyncEvent$Event' => '<p>The event for a resource sync event.</p>', ], ], 'ExternalId' => [ 'base' => NULL, 'refs' => [ 'RepositorySyncEvent$ExternalId' => '<p>The ID for a repository sync event.</p>', 'ResourceSyncEvent$ExternalId' => '<p>The ID for a resource sync event.</p>', ], ], 'GetConnectionInput' => [ 'base' => NULL, 'refs' => [], ], 'GetConnectionOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetHostInput' => [ 'base' => NULL, 'refs' => [], ], 'GetHostOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetRepositoryLinkInput' => [ 'base' => NULL, 'refs' => [], ], 'GetRepositoryLinkOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetRepositorySyncStatusInput' => [ 'base' => NULL, 'refs' => [], ], 'GetRepositorySyncStatusOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetResourceSyncStatusInput' => [ 'base' => NULL, 'refs' => [], ], 'GetResourceSyncStatusOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetSyncBlockerSummaryInput' => [ 'base' => NULL, 'refs' => [], ], 'GetSyncBlockerSummaryOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetSyncConfigurationInput' => [ 'base' => NULL, 'refs' => [], ], 'GetSyncConfigurationOutput' => [ 'base' => NULL, 'refs' => [], ], 'Host' => [ 'base' => '<p>A resource that represents the infrastructure where a third-party provider is installed. The host is used when you create connections to an installed third-party provider type, such as GitHub Enterprise Server. You create one host for all connections to that provider.</p> <note> <p>A host created through the CLI or the SDK is in `PENDING` status by default. You can make its status `AVAILABLE` by setting up the host in the console.</p> </note>', 'refs' => [ 'HostList$member' => NULL, ], ], 'HostArn' => [ 'base' => NULL, 'refs' => [ 'Connection$HostArn' => '<p>The Amazon Resource Name (ARN) of the host associated with the connection.</p>', 'CreateConnectionInput$HostArn' => '<p>The Amazon Resource Name (ARN) of the host associated with the connection to be created.</p>', 'CreateHostOutput$HostArn' => '<p>The Amazon Resource Name (ARN) of the host to be created.</p>', 'DeleteHostInput$HostArn' => '<p>The Amazon Resource Name (ARN) of the host to be deleted.</p>', 'GetHostInput$HostArn' => '<p>The Amazon Resource Name (ARN) of the requested host.</p>', 'Host$HostArn' => '<p>The Amazon Resource Name (ARN) of the host.</p>', 'ListConnectionsInput$HostArnFilter' => '<p>Filters the list of connections to those associated with a specified host.</p>', 'UpdateHostInput$HostArn' => '<p>The Amazon Resource Name (ARN) of the host to be updated.</p>', ], ], 'HostList' => [ 'base' => NULL, 'refs' => [ 'ListHostsOutput$Hosts' => '<p>A list of hosts and the details for each host, such as status, endpoint, and provider type.</p>', ], ], 'HostName' => [ 'base' => NULL, 'refs' => [ 'CreateHostInput$Name' => '<p>The name of the host to be created.</p>', 'GetHostOutput$Name' => '<p>The name of the requested host.</p>', 'Host$Name' => '<p>The name of the host.</p>', ], ], 'HostStatus' => [ 'base' => NULL, 'refs' => [ 'GetHostOutput$Status' => '<p>The status of the requested host.</p>', 'Host$Status' => '<p>The status of the host, such as PENDING, AVAILABLE, VPC_CONFIG_DELETING, VPC_CONFIG_INITIALIZING, and VPC_CONFIG_FAILED_INITIALIZATION.</p>', ], ], 'HostStatusMessage' => [ 'base' => NULL, 'refs' => [ 'Host$StatusMessage' => '<p>The status description for the host.</p>', ], ], 'IamRoleArn' => [ 'base' => NULL, 'refs' => [ 'CreateSyncConfigurationInput$RoleArn' => '<p>The ARN of the IAM role that grants permission for Amazon Web Services to use Git sync to update a given Amazon Web Services resource on your behalf.</p>', 'SyncConfiguration$RoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role associated with a specific sync configuration.</p>', 'UpdateSyncConfigurationInput$RoleArn' => '<p>The ARN of the IAM role for the sync configuration to be updated.</p>', ], ], 'Id' => [ 'base' => NULL, 'refs' => [ 'SyncBlocker$Id' => '<p>The ID for a specific sync blocker.</p>', 'UpdateSyncBlockerInput$Id' => '<p>The ID of the sync blocker to be updated.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>Received an internal server exception. Try again later.</p>', 'refs' => [], ], 'InvalidInputException' => [ 'base' => '<p>The input is not valid. Verify that the action is typed correctly.</p>', 'refs' => [], ], 'KmsKeyArn' => [ 'base' => NULL, 'refs' => [ 'CreateRepositoryLinkInput$EncryptionKeyArn' => '<p>The Amazon Resource Name (ARN) encryption key for the repository to be associated with the repository link.</p>', 'RepositoryLinkInfo$EncryptionKeyArn' => '<p>The Amazon Resource Name (ARN) of the encryption key for the repository associated with the repository link.</p>', 'UpdateRepositoryLinkInput$EncryptionKeyArn' => '<p>The Amazon Resource Name (ARN) of the encryption key for the repository link to be updated.</p>', ], ], 'LatestSyncBlockerList' => [ 'base' => NULL, 'refs' => [ 'SyncBlockerSummary$LatestBlockers' => '<p>The latest events for a sync blocker summary.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>Exceeded the maximum limit for connections.</p>', 'refs' => [], ], 'ListConnectionsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListConnectionsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListHostsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListHostsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListRepositoryLinksInput' => [ 'base' => NULL, 'refs' => [], ], 'ListRepositoryLinksOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListRepositorySyncDefinitionsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListRepositorySyncDefinitionsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListSyncConfigurationsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListSyncConfigurationsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListConnectionsInput$MaxResults' => '<p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', 'ListHostsInput$MaxResults' => '<p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', 'ListRepositoryLinksInput$MaxResults' => '<p> A non-zero, non-negative integer used to limit the number of returned results.</p>', 'ListSyncConfigurationsInput$MaxResults' => '<p>A non-zero, non-negative integer used to limit the number of returned results.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListConnectionsInput$NextToken' => '<p>The token that was returned from the previous <code>ListConnections</code> call, which can be used to return the next set of connections in the list.</p>', 'ListConnectionsOutput$NextToken' => '<p>A token that can be used in the next <code>ListConnections</code> call. To view all items in the list, continue to call this operation with each subsequent token until no more <code>nextToken</code> values are returned.</p>', 'ListHostsInput$NextToken' => '<p>The token that was returned from the previous <code>ListHosts</code> call, which can be used to return the next set of hosts in the list.</p>', 'ListHostsOutput$NextToken' => '<p>A token that can be used in the next <code>ListHosts</code> call. To view all items in the list, continue to call this operation with each subsequent token until no more <code>nextToken</code> values are returned.</p>', ], ], 'OwnerId' => [ 'base' => NULL, 'refs' => [ 'CreateRepositoryLinkInput$OwnerId' => '<p>The owner ID for the repository associated with a specific sync configuration, such as the owner ID in GitHub.</p>', 'RepositoryLinkInfo$OwnerId' => '<p>The owner ID for the repository associated with the repository link, such as the owner ID in GitHub.</p>', 'Revision$OwnerId' => '<p>The owner ID for a specific revision, such as the GitHub owner ID for a GitHub repository.</p>', 'SyncConfiguration$OwnerId' => '<p>The owner ID for the repository associated with a specific sync configuration, such as the owner ID in GitHub.</p>', ], ], 'Parent' => [ 'base' => NULL, 'refs' => [ 'RepositorySyncDefinition$Parent' => '<p>The parent resource specified for a repository sync definition.</p>', ], ], 'ProviderType' => [ 'base' => NULL, 'refs' => [ 'Connection$ProviderType' => '<p>The name of the external provider where your third-party code repository is configured.</p>', 'CreateConnectionInput$ProviderType' => '<p>The name of the external provider where your third-party code repository is configured.</p>', 'CreateHostInput$ProviderType' => '<p>The name of the installed provider to be associated with your connection. The host resource represents the infrastructure where your provider type is installed. The valid provider type is GitHub Enterprise Server.</p>', 'GetHostOutput$ProviderType' => '<p>The provider type of the requested host, such as GitHub Enterprise Server.</p>', 'Host$ProviderType' => '<p>The name of the installed provider to be associated with your connection. The host resource represents the infrastructure where your provider type is installed. The valid provider type is GitHub Enterprise Server.</p>', 'ListConnectionsInput$ProviderTypeFilter' => '<p>Filters the list of connections to those associated with a specified provider, such as Bitbucket.</p>', 'RepositoryLinkInfo$ProviderType' => '<p>The provider type for the connection, such as GitHub, associated with the repository link.</p>', 'Revision$ProviderType' => '<p>The provider type for a revision, such as GitHub.</p>', 'SyncConfiguration$ProviderType' => '<p>The connection provider type associated with a specific sync configuration, such as GitHub.</p>', ], ], 'PublishDeploymentStatus' => [ 'base' => NULL, 'refs' => [ 'CreateSyncConfigurationInput$PublishDeploymentStatus' => '<p>Whether to enable or disable publishing of deployment status to source providers.</p>', 'SyncConfiguration$PublishDeploymentStatus' => '<p>Whether to enable or disable publishing of deployment status to source providers.</p>', 'UpdateSyncConfigurationInput$PublishDeploymentStatus' => '<p>Whether to enable or disable publishing of deployment status to source providers.</p>', ], ], 'RepositoryLinkArn' => [ 'base' => NULL, 'refs' => [ 'RepositoryLinkInfo$RepositoryLinkArn' => '<p>The Amazon Resource Name (ARN) of the repository link.</p>', ], ], 'RepositoryLinkId' => [ 'base' => NULL, 'refs' => [ 'CreateSyncConfigurationInput$RepositoryLinkId' => '<p>The ID of the repository link created for the connection. A repository link allows Git sync to monitor and sync changes to files in a specified Git repository.</p>', 'DeleteRepositoryLinkInput$RepositoryLinkId' => '<p>The ID of the repository link to be deleted.</p>', 'GetRepositoryLinkInput$RepositoryLinkId' => '<p>The ID of the repository link to get.</p>', 'GetRepositorySyncStatusInput$RepositoryLinkId' => '<p>The repository link ID for the requested repository sync status.</p>', 'ListRepositorySyncDefinitionsInput$RepositoryLinkId' => '<p>The ID of the repository link for the sync definition for which you want to retrieve information.</p>', 'ListSyncConfigurationsInput$RepositoryLinkId' => '<p>The ID of the repository link for the requested list of sync configurations.</p>', 'RepositoryLinkInfo$RepositoryLinkId' => '<p>The ID of the repository link.</p>', 'SyncConfiguration$RepositoryLinkId' => '<p>The ID of the repository link associated with a specific sync configuration.</p>', 'UpdateRepositoryLinkInput$RepositoryLinkId' => '<p>The ID of the repository link to be updated.</p>', 'UpdateSyncConfigurationInput$RepositoryLinkId' => '<p>The ID of the repository link for the sync configuration to be updated.</p>', ], ], 'RepositoryLinkInfo' => [ 'base' => '<p>Information about the repository link resource, such as the repository link ARN, the associated connection ARN, encryption key ARN, and owner ID.</p>', 'refs' => [ 'CreateRepositoryLinkOutput$RepositoryLinkInfo' => '<p>The returned information about the created repository link.</p>', 'GetRepositoryLinkOutput$RepositoryLinkInfo' => '<p>The information returned for a specified repository link.</p>', 'RepositoryLinkList$member' => NULL, 'UpdateRepositoryLinkOutput$RepositoryLinkInfo' => '<p>Information about the repository link to be updated.</p>', ], ], 'RepositoryLinkList' => [ 'base' => NULL, 'refs' => [ 'ListRepositoryLinksOutput$RepositoryLinks' => '<p>Lists the repository links called by the list repository links operation.</p>', ], ], 'RepositoryName' => [ 'base' => NULL, 'refs' => [ 'CreateRepositoryLinkInput$RepositoryName' => '<p>The name of the repository to be associated with the repository link.</p>', 'RepositoryLinkInfo$RepositoryName' => '<p>The name of the repository associated with the repository link.</p>', 'Revision$RepositoryName' => '<p>The repository name for a specific revision.</p>', 'SyncConfiguration$RepositoryName' => '<p>The name of the repository associated with a specific sync configuration.</p>', ], ], 'RepositorySyncAttempt' => [ 'base' => '<p>Information about a repository sync attempt for a repository with a sync configuration.</p>', 'refs' => [ 'GetRepositorySyncStatusOutput$LatestSync' => '<p>The status of the latest sync returned for a specified repository and branch.</p>', ], ], 'RepositorySyncDefinition' => [ 'base' => '<p>The definition for a repository with a sync configuration.</p>', 'refs' => [ 'RepositorySyncDefinitionList$member' => NULL, ], ], 'RepositorySyncDefinitionList' => [ 'base' => NULL, 'refs' => [ 'ListRepositorySyncDefinitionsOutput$RepositorySyncDefinitions' => '<p>The list of repository sync definitions returned by the request. A <code>RepositorySyncDefinition</code> is a mapping from a repository branch to all the Amazon Web Services resources that are being synced from that branch.</p>', ], ], 'RepositorySyncEvent' => [ 'base' => '<p>Information about a repository sync event.</p>', 'refs' => [ 'RepositorySyncEventList$member' => NULL, ], ], 'RepositorySyncEventList' => [ 'base' => NULL, 'refs' => [ 'RepositorySyncAttempt$Events' => '<p>The events associated with a specific sync attempt.</p>', ], ], 'RepositorySyncStatus' => [ 'base' => NULL, 'refs' => [ 'RepositorySyncAttempt$Status' => '<p>The status of a specific sync attempt. The following are valid statuses:</p> <ul> <li> <p>INITIATED - A repository sync attempt has been created and will begin soon.</p> </li> <li> <p>IN_PROGRESS - A repository sync attempt has started and work is being done to reconcile the branch.</p> </li> <li> <p>SUCCEEDED - The repository sync attempt has completed successfully.</p> </li> <li> <p>FAILED - The repository sync attempt has failed.</p> </li> <li> <p>QUEUED - The repository sync attempt didn\'t execute and was queued.</p> </li> </ul>', ], ], 'ResolvedReason' => [ 'base' => NULL, 'refs' => [ 'SyncBlocker$ResolvedReason' => '<p>The resolved reason for a specific sync blocker.</p>', 'UpdateSyncBlockerInput$ResolvedReason' => '<p>The reason for resolving the sync blocker.</p>', ], ], 'ResourceAlreadyExistsException' => [ 'base' => '<p>Unable to create resource. Resource already exists.</p>', 'refs' => [], ], 'ResourceName' => [ 'base' => NULL, 'refs' => [ 'CreateSyncConfigurationInput$ResourceName' => '<p>The name of the Amazon Web Services resource (for example, a CloudFormation stack in the case of CFN_STACK_SYNC) that will be synchronized from the linked repository.</p>', 'DeleteSyncConfigurationInput$ResourceName' => '<p>The name of the Amazon Web Services resource associated with the sync configuration to be deleted.</p>', 'GetResourceSyncStatusInput$ResourceName' => '<p>The name of the Amazon Web Services resource for the sync status with the Git repository.</p>', 'GetSyncBlockerSummaryInput$ResourceName' => '<p>The name of the Amazon Web Services resource currently blocked from automatically being synced from a Git repository.</p>', 'GetSyncConfigurationInput$ResourceName' => '<p>The name of the Amazon Web Services resource for the sync configuration for which you want to retrieve information.</p>', 'SyncBlockerSummary$ResourceName' => '<p>The resource name for sync blocker summary.</p>', 'SyncBlockerSummary$ParentResourceName' => '<p>The parent resource name for a sync blocker summary.</p>', 'SyncConfiguration$ResourceName' => '<p>The name of the connection resource associated with a specific sync configuration.</p>', 'UpdateSyncBlockerInput$ResourceName' => '<p>The name of the resource for the sync blocker to be updated.</p>', 'UpdateSyncBlockerOutput$ResourceName' => '<p>The resource name for the sync blocker.</p>', 'UpdateSyncBlockerOutput$ParentResourceName' => '<p>The parent resource name for the sync blocker.</p>', 'UpdateSyncConfigurationInput$ResourceName' => '<p>The name of the Amazon Web Services resource for the sync configuration to be updated.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>Resource not found. Verify the connection resource ARN and try again.</p>', 'refs' => [], ], 'ResourceSyncAttempt' => [ 'base' => '<p>Information about a resource sync attempt.</p>', 'refs' => [ 'GetResourceSyncStatusOutput$LatestSuccessfulSync' => '<p>The latest successful sync for the sync status with the Git repository.</p>', 'GetResourceSyncStatusOutput$LatestSync' => '<p>The latest sync for the sync status with the Git repository, whether successful or not.</p>', ], ], 'ResourceSyncEvent' => [ 'base' => '<p>Information about a resource sync event for the resource associated with a sync configuration.</p>', 'refs' => [ 'ResourceSyncEventList$member' => NULL, ], ], 'ResourceSyncEventList' => [ 'base' => NULL, 'refs' => [ 'ResourceSyncAttempt$Events' => '<p>The events related to a resource sync attempt.</p>', ], ], 'ResourceSyncStatus' => [ 'base' => NULL, 'refs' => [ 'ResourceSyncAttempt$Status' => '<p>The status for a resource sync attempt. The follow are valid statuses:</p> <ul> <li> <p>SYNC-INITIATED - A resource sync attempt has been created and will begin soon.</p> </li> <li> <p>SYNCING - Syncing has started and work is being done to reconcile state.</p> </li> <li> <p>SYNCED - Syncing has completed successfully.</p> </li> <li> <p>SYNC_FAILED - A resource sync attempt has failed.</p> </li> </ul>', ], ], 'ResourceUnavailableException' => [ 'base' => '<p>Resource not found. Verify the ARN for the host resource and try again.</p>', 'refs' => [], ], 'RetryLatestCommitFailedException' => [ 'base' => '<p>Retrying the latest commit failed. Try again later.</p>', 'refs' => [], ], 'Revision' => [ 'base' => '<p>Information about the revision for a specific sync event, such as the branch, owner ID, and name of the repository.</p>', 'refs' => [ 'GetResourceSyncStatusOutput$DesiredState' => '<p>The desired state of the Amazon Web Services resource for the sync status with the Git repository.</p>', 'ResourceSyncAttempt$InitialRevision' => '<p>The current state of the resource as defined in the resource\'s <code>config-file</code> in the linked repository.</p>', 'ResourceSyncAttempt$TargetRevision' => '<p>The desired state of the resource as defined in the resource\'s <code>config-file</code> in the linked repository. Git sync attempts to update the resource to this state.</p>', ], ], 'SHA' => [ 'base' => NULL, 'refs' => [ 'Revision$Sha' => '<p>The SHA, such as the commit ID, for a specific revision.</p>', ], ], 'SecurityGroupId' => [ 'base' => NULL, 'refs' => [ 'SecurityGroupIds$member' => NULL, ], ], 'SecurityGroupIds' => [ 'base' => NULL, 'refs' => [ 'VpcConfiguration$SecurityGroupIds' => '<p>The ID of the security group or security groups associated with the Amazon VPC connected to the infrastructure where your provider type is installed.</p>', ], ], 'SharpNextToken' => [ 'base' => NULL, 'refs' => [ 'ListRepositoryLinksInput$NextToken' => '<p> An enumeration token that, when provided in a request, returns the next batch of the results.</p>', 'ListRepositoryLinksOutput$NextToken' => '<p>An enumeration token that allows the operation to batch the results of the operation. </p>', 'ListRepositorySyncDefinitionsOutput$NextToken' => '<p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>', 'ListSyncConfigurationsInput$NextToken' => '<p>An enumeration token that allows the operation to batch the results of the operation.</p>', 'ListSyncConfigurationsOutput$NextToken' => '<p>An enumeration token that allows the operation to batch the next results of the operation.</p>', ], ], 'SubnetId' => [ 'base' => NULL, 'refs' => [ 'SubnetIds$member' => NULL, ], ], 'SubnetIds' => [ 'base' => NULL, 'refs' => [ 'VpcConfiguration$SubnetIds' => '<p>The ID of the subnet or subnets associated with the Amazon VPC connected to the infrastructure where your provider type is installed.</p>', ], ], 'SyncBlocker' => [ 'base' => '<p>Information about a blocker for a sync event.</p>', 'refs' => [ 'LatestSyncBlockerList$member' => NULL, 'UpdateSyncBlockerOutput$SyncBlocker' => '<p>Information about the sync blocker to be updated.</p>', ], ], 'SyncBlockerContext' => [ 'base' => '<p>The context for a specific sync blocker.</p>', 'refs' => [ 'SyncBlockerContextList$member' => NULL, ], ], 'SyncBlockerContextKey' => [ 'base' => NULL, 'refs' => [ 'SyncBlockerContext$Key' => '<p>The key provided for a context key-value pair for a specific sync blocker.</p>', ], ], 'SyncBlockerContextList' => [ 'base' => NULL, 'refs' => [ 'SyncBlocker$Contexts' => '<p>The contexts for a specific sync blocker.</p>', ], ], 'SyncBlockerContextValue' => [ 'base' => NULL, 'refs' => [ 'SyncBlockerContext$Value' => '<p>The value provided for a context key-value pair for a specific sync blocker.</p>', ], ], 'SyncBlockerDoesNotExistException' => [ 'base' => '<p>Unable to continue. The sync blocker does not exist.</p>', 'refs' => [], ], 'SyncBlockerSummary' => [ 'base' => '<p>A summary for sync blockers.</p>', 'refs' => [ 'GetSyncBlockerSummaryOutput$SyncBlockerSummary' => '<p>The list of sync blockers for a specified resource.</p>', ], ], 'SyncConfiguration' => [ 'base' => '<p>Information, such as repository, branch, provider, and resource names for a specific sync configuration.</p>', 'refs' => [ 'CreateSyncConfigurationOutput$SyncConfiguration' => '<p>The created sync configuration for the connection. A sync configuration allows Amazon Web Services to sync content from a Git repository to update a specified Amazon Web Services resource. </p>', 'GetSyncConfigurationOutput$SyncConfiguration' => '<p>The details about the sync configuration for which you want to retrieve information.</p>', 'SyncConfigurationList$member' => NULL, 'UpdateSyncConfigurationOutput$SyncConfiguration' => '<p>The information returned for the sync configuration to be updated.</p>', ], ], 'SyncConfigurationList' => [ 'base' => NULL, 'refs' => [ 'ListSyncConfigurationsOutput$SyncConfigurations' => '<p>The list of repository sync definitions returned by the request.</p>', ], ], 'SyncConfigurationStillExistsException' => [ 'base' => '<p>Unable to continue. The sync blocker still exists.</p>', 'refs' => [], ], 'SyncConfigurationType' => [ 'base' => NULL, 'refs' => [ 'CreateSyncConfigurationInput$SyncType' => '<p>The type of sync configuration.</p>', 'DeleteSyncConfigurationInput$SyncType' => '<p>The type of sync configuration to be deleted.</p>', 'GetRepositorySyncStatusInput$SyncType' => '<p>The sync type of the requested sync status.</p>', 'GetResourceSyncStatusInput$SyncType' => '<p>The sync type for the sync status with the Git repository.</p>', 'GetSyncBlockerSummaryInput$SyncType' => '<p>The sync type for the sync blocker summary.</p>', 'GetSyncConfigurationInput$SyncType' => '<p>The sync type for the sync configuration for which you want to retrieve information.</p>', 'ListRepositorySyncDefinitionsInput$SyncType' => '<p>The sync type of the repository link for the the sync definition for which you want to retrieve information.</p>', 'ListSyncConfigurationsInput$SyncType' => '<p>The sync type for the requested list of sync configurations.</p>', 'SyncConfiguration$SyncType' => '<p>The type of sync for a specific sync configuration.</p>', 'UpdateSyncBlockerInput$SyncType' => '<p>The sync type of the sync blocker to be updated.</p>', 'UpdateSyncConfigurationInput$SyncType' => '<p>The sync type for the sync configuration to be updated.</p>', ], ], 'Tag' => [ 'base' => '<p>A tag is a key-value pair that is used to manage the resource.</p> <p>This tag is available for use by Amazon Web Services services that support tags.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>The tag\'s key.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceInput$TagKeys' => '<p>The list of keys for the tags to be removed from the resource.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateConnectionInput$Tags' => '<p>The key-value pair to use when tagging the resource.</p>', 'CreateConnectionOutput$Tags' => '<p>Specifies the tags applied to the resource.</p>', 'CreateHostInput$Tags' => '<p>Tags for the host to be created.</p>', 'CreateHostOutput$Tags' => '<p>Tags for the created host.</p>', 'CreateRepositoryLinkInput$Tags' => '<p>The tags for the repository to be associated with the repository link.</p>', 'ListTagsForResourceOutput$Tags' => '<p>A list of tag key and value pairs associated with the specified resource.</p>', 'TagResourceInput$Tags' => '<p>The tags you want to modify or add to the resource.</p>', ], ], 'TagResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The tag\'s value.</p>', ], ], 'Target' => [ 'base' => NULL, 'refs' => [ 'RepositorySyncDefinition$Target' => '<p>The target resource specified for a repository sync definition. In some cases, such as CFN_STACK_SYNC, the parent and target resource are the same.</p>', 'ResourceSyncAttempt$Target' => '<p>The name of the Amazon Web Services resource that is attempted to be synchronized.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The request was denied due to request throttling.</p>', 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'RepositorySyncAttempt$StartedAt' => '<p>The start time of a specific sync attempt.</p>', 'RepositorySyncEvent$Time' => '<p>The time that a repository sync event occurred.</p>', 'ResourceSyncAttempt$StartedAt' => '<p>The start time for a resource sync attempt.</p>', 'ResourceSyncEvent$Time' => '<p>The time that a resource sync event occurred.</p>', 'SyncBlocker$CreatedAt' => '<p>The creation time for a specific sync blocker.</p>', 'SyncBlocker$ResolvedAt' => '<p>The time that a specific sync blocker was resolved.</p>', ], ], 'TlsCertificate' => [ 'base' => NULL, 'refs' => [ 'VpcConfiguration$TlsCertificate' => '<p>The value of the Transport Layer Security (TLS) certificate associated with the infrastructure where your provider type is installed.</p>', ], ], 'TriggerResourceUpdateOn' => [ 'base' => NULL, 'refs' => [ 'CreateSyncConfigurationInput$TriggerResourceUpdateOn' => '<p>When to trigger Git sync to begin the stack update.</p>', 'SyncConfiguration$TriggerResourceUpdateOn' => '<p>When to trigger Git sync to begin the stack update.</p>', 'UpdateSyncConfigurationInput$TriggerResourceUpdateOn' => '<p>When to trigger Git sync to begin the stack update.</p>', ], ], 'Type' => [ 'base' => NULL, 'refs' => [ 'RepositorySyncEvent$Type' => '<p>The event type for a repository sync event.</p>', 'ResourceSyncEvent$Type' => '<p>The type of resource sync event.</p>', ], ], 'UnsupportedOperationException' => [ 'base' => '<p>The operation is not supported. Check the connection status and try again.</p>', 'refs' => [], ], 'UnsupportedProviderTypeException' => [ 'base' => '<p>The specified provider type is not supported for connections.</p>', 'refs' => [], ], 'UntagResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateHostInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateHostOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateOutOfSyncException' => [ 'base' => '<p>The update is out of sync. Try syncing again.</p>', 'refs' => [], ], 'UpdateRepositoryLinkInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRepositoryLinkOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSyncBlockerInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSyncBlockerOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSyncConfigurationInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSyncConfigurationOutput' => [ 'base' => NULL, 'refs' => [], ], 'Url' => [ 'base' => NULL, 'refs' => [ 'CreateHostInput$ProviderEndpoint' => '<p>The endpoint of the infrastructure to be represented by the host after it is created.</p>', 'GetHostOutput$ProviderEndpoint' => '<p>The endpoint of the infrastructure represented by the requested host.</p>', 'Host$ProviderEndpoint' => '<p>The endpoint of the infrastructure where your provider type is installed.</p>', 'UpdateHostInput$ProviderEndpoint' => '<p>The URL or endpoint of the host to be updated.</p>', ], ], 'VpcConfiguration' => [ 'base' => '<p>The VPC configuration provisioned for the host.</p>', 'refs' => [ 'CreateHostInput$VpcConfiguration' => '<p>The VPC configuration to be provisioned for the host. A VPC must be configured and the infrastructure to be represented by the host must already be connected to the VPC.</p>', 'GetHostOutput$VpcConfiguration' => '<p>The VPC configuration of the requested host.</p>', 'Host$VpcConfiguration' => '<p>The VPC configuration provisioned for the host.</p>', 'UpdateHostInput$VpcConfiguration' => '<p>The VPC configuration of the host to be updated. A VPC must be configured and the infrastructure to be represented by the host must already be connected to the VPC.</p>', ], ], 'VpcId' => [ 'base' => NULL, 'refs' => [ 'VpcConfiguration$VpcId' => '<p>The ID of the Amazon VPC connected to the infrastructure where your provider type is installed.</p>', ], ], ],];
