<?php
// This file was auto-generated from sdk-root/src/data/comprehend/2017-11-27/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Amazon Comprehend is an Amazon Web Services service for gaining insight into the content of documents. Use these actions to determine the topics contained in your documents, the topics they discuss, the predominant sentiment expressed in them, the predominant language used, and more.</p>', 'operations' => [ 'BatchDetectDominantLanguage' => '<p>Determines the dominant language of the input text for a batch of documents. For a list of languages that Amazon Comprehend can detect, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/how-languages.html">Amazon Comprehend Supported Languages</a>. </p>', 'BatchDetectEntities' => '<p>Inspects the text of a batch of documents for named entities and returns information about them. For more information about named entities, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/how-entities.html">Entities</a> in the Comprehend Developer Guide. </p>', 'BatchDetectKeyPhrases' => '<p>Detects the key noun phrases found in a batch of documents.</p>', 'BatchDetectSentiment' => '<p>Inspects a batch of documents and returns an inference of the prevailing sentiment, <code>POSITIVE</code>, <code>NEUTRAL</code>, <code>MIXED</code>, or <code>NEGATIVE</code>, in each one.</p>', 'BatchDetectSyntax' => '<p>Inspects the text of a batch of documents for the syntax and part of speech of the words in the document and returns information about them. For more information, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/how-syntax.html">Syntax</a> in the Comprehend Developer Guide. </p>', 'BatchDetectTargetedSentiment' => '<p>Inspects a batch of documents and returns a sentiment analysis for each entity identified in the documents.</p> <p>For more information about targeted sentiment, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/how-targeted-sentiment.html">Targeted sentiment</a> in the <i>Amazon Comprehend Developer Guide</i>.</p>', 'ClassifyDocument' => '<p>Creates a classification request to analyze a single document in real-time. <code>ClassifyDocument</code> supports the following model types:</p> <ul> <li> <p>Custom classifier - a custom model that you have created and trained. For input, you can provide plain text, a single-page document (PDF, Word, or image), or Amazon Textract API output. For more information, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/how-document-classification.html">Custom classification</a> in the <i>Amazon Comprehend Developer Guide</i>.</p> </li> <li> <p>Prompt safety classifier - Amazon Comprehend provides a pre-trained model for classifying input prompts for generative AI applications. For input, you provide English plain text input. For prompt safety classification, the response includes only the <code>Classes</code> field. For more information about prompt safety classifiers, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/trust-safety.html#prompt-classification">Prompt safety classification</a> in the <i>Amazon Comprehend Developer Guide</i>.</p> </li> </ul> <p>If the system detects errors while processing a page in the input document, the API response includes an <code>Errors</code> field that describes the errors.</p> <p>If the system detects a document-level error in your input document, the API returns an <code>InvalidRequestException</code> error response. For details about this exception, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/idp-inputs-sync-err.html"> Errors in semi-structured documents</a> in the Comprehend Developer Guide. </p>', 'ContainsPiiEntities' => '<p>Analyzes input text for the presence of personally identifiable information (PII) and returns the labels of identified PII entity types such as name, address, bank account number, or phone number.</p>', 'CreateDataset' => '<p>Creates a dataset to upload training or test data for a model associated with a flywheel. For more information about datasets, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html"> Flywheel overview</a> in the <i>Amazon Comprehend Developer Guide</i>.</p>', 'CreateDocumentClassifier' => '<p>Creates a new document classifier that you can use to categorize documents. To create a classifier, you provide a set of training documents that are labeled with the categories that you want to use. For more information, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/training-classifier-model.html">Training classifier models</a> in the Comprehend Developer Guide. </p>', 'CreateEndpoint' => '<p>Creates a model-specific endpoint for synchronous inference for a previously trained custom model For information about endpoints, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html">Managing endpoints</a>.</p>', 'CreateEntityRecognizer' => '<p>Creates an entity recognizer using submitted files. After your <code>CreateEntityRecognizer</code> request is submitted, you can check job status using the <code>DescribeEntityRecognizer</code> API. </p>', 'CreateFlywheel' => '<p>A flywheel is an Amazon Web Services resource that orchestrates the ongoing training of a model for custom classification or custom entity recognition. You can create a flywheel to start with an existing trained model, or Comprehend can create and train a new model.</p> <p>When you create the flywheel, Comprehend creates a data lake in your account. The data lake holds the training data and test data for all versions of the model.</p> <p>To use a flywheel with an existing trained model, you specify the active model version. Comprehend copies the model\'s training data and test data into the flywheel\'s data lake.</p> <p>To use the flywheel with a new model, you need to provide a dataset for training data (and optional test data) when you create the flywheel.</p> <p>For more information about flywheels, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html"> Flywheel overview</a> in the <i>Amazon Comprehend Developer Guide</i>.</p>', 'DeleteDocumentClassifier' => '<p>Deletes a previously created document classifier</p> <p>Only those classifiers that are in terminated states (IN_ERROR, TRAINED) will be deleted. If an active inference job is using the model, a <code>ResourceInUseException</code> will be returned.</p> <p>This is an asynchronous action that puts the classifier into a DELETING state, and it is then removed by a background job. Once removed, the classifier disappears from your account and is no longer available for use. </p>', 'DeleteEndpoint' => '<p>Deletes a model-specific endpoint for a previously-trained custom model. All endpoints must be deleted in order for the model to be deleted. For information about endpoints, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html">Managing endpoints</a>.</p>', 'DeleteEntityRecognizer' => '<p>Deletes an entity recognizer.</p> <p>Only those recognizers that are in terminated states (IN_ERROR, TRAINED) will be deleted. If an active inference job is using the model, a <code>ResourceInUseException</code> will be returned.</p> <p>This is an asynchronous action that puts the recognizer into a DELETING state, and it is then removed by a background job. Once removed, the recognizer disappears from your account and is no longer available for use. </p>', 'DeleteFlywheel' => '<p>Deletes a flywheel. When you delete the flywheel, Amazon Comprehend does not delete the data lake or the model associated with the flywheel.</p> <p>For more information about flywheels, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html"> Flywheel overview</a> in the <i>Amazon Comprehend Developer Guide</i>.</p>', 'DeleteResourcePolicy' => '<p>Deletes a resource-based policy that is attached to a custom model.</p>', 'DescribeDataset' => '<p>Returns information about the dataset that you specify. For more information about datasets, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html"> Flywheel overview</a> in the <i>Amazon Comprehend Developer Guide</i>.</p>', 'DescribeDocumentClassificationJob' => '<p>Gets the properties associated with a document classification job. Use this operation to get the status of a classification job.</p>', 'DescribeDocumentClassifier' => '<p>Gets the properties associated with a document classifier.</p>', 'DescribeDominantLanguageDetectionJob' => '<p>Gets the properties associated with a dominant language detection job. Use this operation to get the status of a detection job.</p>', 'DescribeEndpoint' => '<p>Gets the properties associated with a specific endpoint. Use this operation to get the status of an endpoint. For information about endpoints, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html">Managing endpoints</a>.</p>', 'DescribeEntitiesDetectionJob' => '<p>Gets the properties associated with an entities detection job. Use this operation to get the status of a detection job.</p>', 'DescribeEntityRecognizer' => '<p>Provides details about an entity recognizer including status, S3 buckets containing training data, recognizer metadata, metrics, and so on.</p>', 'DescribeEventsDetectionJob' => '<p>Gets the status and details of an events detection job.</p>', 'DescribeFlywheel' => '<p>Provides configuration information about the flywheel. For more information about flywheels, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html"> Flywheel overview</a> in the <i>Amazon Comprehend Developer Guide</i>.</p>', 'DescribeFlywheelIteration' => '<p>Retrieve the configuration properties of a flywheel iteration. For more information about flywheels, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html"> Flywheel overview</a> in the <i>Amazon Comprehend Developer Guide</i>.</p>', 'DescribeKeyPhrasesDetectionJob' => '<p>Gets the properties associated with a key phrases detection job. Use this operation to get the status of a detection job.</p>', 'DescribePiiEntitiesDetectionJob' => '<p>Gets the properties associated with a PII entities detection job. For example, you can use this operation to get the job status.</p>', 'DescribeResourcePolicy' => '<p>Gets the details of a resource-based policy that is attached to a custom model, including the JSON body of the policy.</p>', 'DescribeSentimentDetectionJob' => '<p>Gets the properties associated with a sentiment detection job. Use this operation to get the status of a detection job.</p>', 'DescribeTargetedSentimentDetectionJob' => '<p>Gets the properties associated with a targeted sentiment detection job. Use this operation to get the status of the job.</p>', 'DescribeTopicsDetectionJob' => '<p>Gets the properties associated with a topic detection job. Use this operation to get the status of a detection job.</p>', 'DetectDominantLanguage' => '<p>Determines the dominant language of the input text. For a list of languages that Amazon Comprehend can detect, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/how-languages.html">Amazon Comprehend Supported Languages</a>. </p>', 'DetectEntities' => '<p>Detects named entities in input text when you use the pre-trained model. Detects custom entities if you have a custom entity recognition model. </p> <p> When detecting named entities using the pre-trained model, use plain text as the input. For more information about named entities, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/how-entities.html">Entities</a> in the Comprehend Developer Guide.</p> <p>When you use a custom entity recognition model, you can input plain text or you can upload a single-page input document (text, PDF, Word, or image). </p> <p>If the system detects errors while processing a page in the input document, the API response includes an entry in <code>Errors</code> for each error. </p> <p>If the system detects a document-level error in your input document, the API returns an <code>InvalidRequestException</code> error response. For details about this exception, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/idp-inputs-sync-err.html"> Errors in semi-structured documents</a> in the Comprehend Developer Guide. </p>', 'DetectKeyPhrases' => '<p>Detects the key noun phrases found in the text. </p>', 'DetectPiiEntities' => '<p>Inspects the input text for entities that contain personally identifiable information (PII) and returns information about them.</p>', 'DetectSentiment' => '<p>Inspects text and returns an inference of the prevailing sentiment (<code>POSITIVE</code>, <code>NEUTRAL</code>, <code>MIXED</code>, or <code>NEGATIVE</code>). </p>', 'DetectSyntax' => '<p>Inspects text for syntax and the part of speech of words in the document. For more information, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/how-syntax.html">Syntax</a> in the Comprehend Developer Guide. </p>', 'DetectTargetedSentiment' => '<p>Inspects the input text and returns a sentiment analysis for each entity identified in the text.</p> <p>For more information about targeted sentiment, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/how-targeted-sentiment.html">Targeted sentiment</a> in the <i>Amazon Comprehend Developer Guide</i>.</p>', 'DetectToxicContent' => '<p>Performs toxicity analysis on the list of text strings that you provide as input. The API response contains a results list that matches the size of the input list. For more information about toxicity detection, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/toxicity-detection.html">Toxicity detection</a> in the <i>Amazon Comprehend Developer Guide</i>. </p>', 'ImportModel' => '<p>Creates a new custom model that replicates a source custom model that you import. The source model can be in your Amazon Web Services account or another one.</p> <p>If the source model is in another Amazon Web Services account, then it must have a resource-based policy that authorizes you to import it.</p> <p>The source model must be in the same Amazon Web Services Region that you\'re using when you import. You can\'t import a model that\'s in a different Region.</p>', 'ListDatasets' => '<p>List the datasets that you have configured in this Region. For more information about datasets, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html"> Flywheel overview</a> in the <i>Amazon Comprehend Developer Guide</i>.</p>', 'ListDocumentClassificationJobs' => '<p>Gets a list of the documentation classification jobs that you have submitted.</p>', 'ListDocumentClassifierSummaries' => '<p>Gets a list of summaries of the document classifiers that you have created</p>', 'ListDocumentClassifiers' => '<p>Gets a list of the document classifiers that you have created.</p>', 'ListDominantLanguageDetectionJobs' => '<p>Gets a list of the dominant language detection jobs that you have submitted.</p>', 'ListEndpoints' => '<p>Gets a list of all existing endpoints that you\'ve created. For information about endpoints, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html">Managing endpoints</a>.</p>', 'ListEntitiesDetectionJobs' => '<p>Gets a list of the entity detection jobs that you have submitted.</p>', 'ListEntityRecognizerSummaries' => '<p>Gets a list of summaries for the entity recognizers that you have created.</p>', 'ListEntityRecognizers' => '<p>Gets a list of the properties of all entity recognizers that you created, including recognizers currently in training. Allows you to filter the list of recognizers based on criteria such as status and submission time. This call returns up to 500 entity recognizers in the list, with a default number of 100 recognizers in the list.</p> <p>The results of this list are not in any particular order. Please get the list and sort locally if needed.</p>', 'ListEventsDetectionJobs' => '<p>Gets a list of the events detection jobs that you have submitted.</p>', 'ListFlywheelIterationHistory' => '<p>Information about the history of a flywheel iteration. For more information about flywheels, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html"> Flywheel overview</a> in the <i>Amazon Comprehend Developer Guide</i>.</p>', 'ListFlywheels' => '<p>Gets a list of the flywheels that you have created.</p>', 'ListKeyPhrasesDetectionJobs' => '<p>Get a list of key phrase detection jobs that you have submitted.</p>', 'ListPiiEntitiesDetectionJobs' => '<p>Gets a list of the PII entity detection jobs that you have submitted.</p>', 'ListSentimentDetectionJobs' => '<p>Gets a list of sentiment detection jobs that you have submitted.</p>', 'ListTagsForResource' => '<p>Lists all tags associated with a given Amazon Comprehend resource. </p>', 'ListTargetedSentimentDetectionJobs' => '<p>Gets a list of targeted sentiment detection jobs that you have submitted.</p>', 'ListTopicsDetectionJobs' => '<p>Gets a list of the topic detection jobs that you have submitted.</p>', 'PutResourcePolicy' => '<p>Attaches a resource-based policy to a custom model. You can use this policy to authorize an entity in another Amazon Web Services account to import the custom model, which replicates it in Amazon Comprehend in their account.</p>', 'StartDocumentClassificationJob' => '<p>Starts an asynchronous document classification job using a custom classification model. Use the <code>DescribeDocumentClassificationJob</code> operation to track the progress of the job.</p>', 'StartDominantLanguageDetectionJob' => '<p>Starts an asynchronous dominant language detection job for a collection of documents. Use the operation to track the status of a job.</p>', 'StartEntitiesDetectionJob' => '<p>Starts an asynchronous entity detection job for a collection of documents. Use the operation to track the status of a job.</p> <p>This API can be used for either standard entity detection or custom entity recognition. In order to be used for custom entity recognition, the optional <code>EntityRecognizerArn</code> must be used in order to provide access to the recognizer being used to detect the custom entity.</p>', 'StartEventsDetectionJob' => '<p>Starts an asynchronous event detection job for a collection of documents.</p>', 'StartFlywheelIteration' => '<p>Start the flywheel iteration.This operation uses any new datasets to train a new model version. For more information about flywheels, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html"> Flywheel overview</a> in the <i>Amazon Comprehend Developer Guide</i>.</p>', 'StartKeyPhrasesDetectionJob' => '<p>Starts an asynchronous key phrase detection job for a collection of documents. Use the operation to track the status of a job.</p>', 'StartPiiEntitiesDetectionJob' => '<p>Starts an asynchronous PII entity detection job for a collection of documents.</p>', 'StartSentimentDetectionJob' => '<p>Starts an asynchronous sentiment detection job for a collection of documents. Use the operation to track the status of a job.</p>', 'StartTargetedSentimentDetectionJob' => '<p>Starts an asynchronous targeted sentiment detection job for a collection of documents. Use the <code>DescribeTargetedSentimentDetectionJob</code> operation to track the status of a job.</p>', 'StartTopicsDetectionJob' => '<p>Starts an asynchronous topic detection job. Use the <code>DescribeTopicDetectionJob</code> operation to track the status of a job.</p>', 'StopDominantLanguageDetectionJob' => '<p>Stops a dominant language detection job in progress.</p> <p>If the job state is <code>IN_PROGRESS</code> the job is marked for termination and put into the <code>STOP_REQUESTED</code> state. If the job completes before it can be stopped, it is put into the <code>COMPLETED</code> state; otherwise the job is stopped and put into the <code>STOPPED</code> state.</p> <p>If the job is in the <code>COMPLETED</code> or <code>FAILED</code> state when you call the <code>StopDominantLanguageDetectionJob</code> operation, the operation returns a 400 Internal Request Exception. </p> <p>When a job is stopped, any documents already processed are written to the output location.</p>', 'StopEntitiesDetectionJob' => '<p>Stops an entities detection job in progress.</p> <p>If the job state is <code>IN_PROGRESS</code> the job is marked for termination and put into the <code>STOP_REQUESTED</code> state. If the job completes before it can be stopped, it is put into the <code>COMPLETED</code> state; otherwise the job is stopped and put into the <code>STOPPED</code> state.</p> <p>If the job is in the <code>COMPLETED</code> or <code>FAILED</code> state when you call the <code>StopDominantLanguageDetectionJob</code> operation, the operation returns a 400 Internal Request Exception. </p> <p>When a job is stopped, any documents already processed are written to the output location.</p>', 'StopEventsDetectionJob' => '<p>Stops an events detection job in progress.</p>', 'StopKeyPhrasesDetectionJob' => '<p>Stops a key phrases detection job in progress.</p> <p>If the job state is <code>IN_PROGRESS</code> the job is marked for termination and put into the <code>STOP_REQUESTED</code> state. If the job completes before it can be stopped, it is put into the <code>COMPLETED</code> state; otherwise the job is stopped and put into the <code>STOPPED</code> state.</p> <p>If the job is in the <code>COMPLETED</code> or <code>FAILED</code> state when you call the <code>StopDominantLanguageDetectionJob</code> operation, the operation returns a 400 Internal Request Exception. </p> <p>When a job is stopped, any documents already processed are written to the output location.</p>', 'StopPiiEntitiesDetectionJob' => '<p>Stops a PII entities detection job in progress.</p>', 'StopSentimentDetectionJob' => '<p>Stops a sentiment detection job in progress.</p> <p>If the job state is <code>IN_PROGRESS</code>, the job is marked for termination and put into the <code>STOP_REQUESTED</code> state. If the job completes before it can be stopped, it is put into the <code>COMPLETED</code> state; otherwise the job is be stopped and put into the <code>STOPPED</code> state.</p> <p>If the job is in the <code>COMPLETED</code> or <code>FAILED</code> state when you call the <code>StopDominantLanguageDetectionJob</code> operation, the operation returns a 400 Internal Request Exception. </p> <p>When a job is stopped, any documents already processed are written to the output location.</p>', 'StopTargetedSentimentDetectionJob' => '<p>Stops a targeted sentiment detection job in progress.</p> <p>If the job state is <code>IN_PROGRESS</code>, the job is marked for termination and put into the <code>STOP_REQUESTED</code> state. If the job completes before it can be stopped, it is put into the <code>COMPLETED</code> state; otherwise the job is be stopped and put into the <code>STOPPED</code> state.</p> <p>If the job is in the <code>COMPLETED</code> or <code>FAILED</code> state when you call the <code>StopDominantLanguageDetectionJob</code> operation, the operation returns a 400 Internal Request Exception. </p> <p>When a job is stopped, any documents already processed are written to the output location.</p>', 'StopTrainingDocumentClassifier' => '<p>Stops a document classifier training job while in progress.</p> <p>If the training job state is <code>TRAINING</code>, the job is marked for termination and put into the <code>STOP_REQUESTED</code> state. If the training job completes before it can be stopped, it is put into the <code>TRAINED</code>; otherwise the training job is stopped and put into the <code>STOPPED</code> state and the service sends back an HTTP 200 response with an empty HTTP body. </p>', 'StopTrainingEntityRecognizer' => '<p>Stops an entity recognizer training job while in progress.</p> <p>If the training job state is <code>TRAINING</code>, the job is marked for termination and put into the <code>STOP_REQUESTED</code> state. If the training job completes before it can be stopped, it is put into the <code>TRAINED</code>; otherwise the training job is stopped and putted into the <code>STOPPED</code> state and the service sends back an HTTP 200 response with an empty HTTP body.</p>', 'TagResource' => '<p>Associates a specific tag with an Amazon Comprehend resource. A tag is a key-value pair that adds as a metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department. </p>', 'UntagResource' => '<p>Removes a specific tag associated with an Amazon Comprehend resource. </p>', 'UpdateEndpoint' => '<p>Updates information about the specified endpoint. For information about endpoints, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html">Managing endpoints</a>.</p>', 'UpdateFlywheel' => '<p>Update the configuration information for an existing flywheel.</p>', ], 'shapes' => [ 'AnyLengthString' => [ 'base' => NULL, 'refs' => [ 'DatasetProperties$Message' => '<p>A description of the status of the dataset.</p>', 'DocumentClassificationJobProperties$Message' => '<p>A description of the status of the job.</p>', 'DocumentClassifierProperties$Message' => '<p>Additional information about the status of the classifier.</p>', 'DominantLanguageDetectionJobProperties$Message' => '<p>A description for the status of a job.</p>', 'EndpointProperties$Message' => '<p>Specifies a reason for failure in cases of <code>Failed</code> status.</p>', 'EntitiesDetectionJobProperties$Message' => '<p>A description of the status of a job.</p>', 'EntityRecognizerMetadataEntityTypesListItem$Type' => '<p>Type of entity from the list of entity types in the metadata of an entity recognizer. </p>', 'EntityRecognizerProperties$Message' => '<p> A description of the status of the recognizer.</p>', 'EventsDetectionJobProperties$Message' => '<p>A description of the status of the events detection job.</p>', 'FlywheelIterationProperties$Message' => '<p>A description of the status of the flywheel iteration.</p>', 'FlywheelProperties$Message' => '<p>A description of the status of the flywheel.</p>', 'FlywheelSummary$Message' => '<p>A description of the status of the flywheel.</p>', 'KeyPhrasesDetectionJobProperties$Message' => '<p>A description of the status of a job.</p>', 'PiiEntitiesDetectionJobProperties$Message' => '<p>A description of the status of a job.</p>', 'SentimentDetectionJobProperties$Message' => '<p>A description of the status of a job.</p>', 'TargetedSentimentDetectionJobProperties$Message' => '<p>A description of the status of a job.</p>', 'TopicsDetectionJobProperties$Message' => '<p>A description for the status of a job.</p>', ], ], 'AttributeNamesList' => [ 'base' => NULL, 'refs' => [ 'AugmentedManifestsListItem$AttributeNames' => '<p>The JSON attribute that contains the annotations for your training documents. The number of attribute names that you specify depends on whether your augmented manifest file is the output of a single labeling job or a chained labeling job.</p> <p>If your file is the output of a single labeling job, specify the LabelAttributeName key that was used when the job was created in Ground Truth.</p> <p>If your file is the output of a chained labeling job, specify the LabelAttributeName key for one or more jobs in the chain. Each LabelAttributeName key provides the annotations from an individual job.</p>', 'DatasetAugmentedManifestsListItem$AttributeNames' => '<p>The JSON attribute that contains the annotations for your training documents. The number of attribute names that you specify depends on whether your augmented manifest file is the output of a single labeling job or a chained labeling job.</p> <p>If your file is the output of a single labeling job, specify the LabelAttributeName key that was used when the job was created in Ground Truth.</p> <p>If your file is the output of a chained labeling job, specify the LabelAttributeName key for one or more jobs in the chain. Each LabelAttributeName key provides the annotations from an individual job.</p>', ], ], 'AttributeNamesListItem' => [ 'base' => NULL, 'refs' => [ 'AttributeNamesList$member' => NULL, ], ], 'AugmentedManifestsDocumentTypeFormat' => [ 'base' => NULL, 'refs' => [ 'AugmentedManifestsListItem$DocumentType' => '<p>The type of augmented manifest. PlainTextDocument or SemiStructuredDocument. If you don\'t specify, the default is PlainTextDocument. </p> <ul> <li> <p> <code>PLAIN_TEXT_DOCUMENT</code> A document type that represents any unicode text that is encoded in UTF-8.</p> </li> <li> <p> <code>SEMI_STRUCTURED_DOCUMENT</code> A document type with positional and structural context, like a PDF. For training with Amazon Comprehend, only PDFs are supported. For inference, Amazon Comprehend support PDFs, DOCX and TXT.</p> </li> </ul>', 'DatasetAugmentedManifestsListItem$DocumentType' => '<p>The type of augmented manifest. If you don\'t specify, the default is PlainTextDocument. </p> <p> <code>PLAIN_TEXT_DOCUMENT</code> A document type that represents any unicode text that is encoded in UTF-8.</p>', ], ], 'AugmentedManifestsListItem' => [ 'base' => '<p>An augmented manifest file that provides training data for your custom model. An augmented manifest file is a labeled dataset that is produced by Amazon SageMaker Ground Truth.</p>', 'refs' => [ 'DocumentClassifierAugmentedManifestsList$member' => NULL, 'EntityRecognizerAugmentedManifestsList$member' => NULL, ], ], 'BatchDetectDominantLanguageItemResult' => [ 'base' => '<p>The result of calling the operation. The operation returns one object for each document that is successfully processed by the operation.</p>', 'refs' => [ 'ListOfDetectDominantLanguageResult$member' => NULL, ], ], 'BatchDetectDominantLanguageRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchDetectDominantLanguageResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchDetectEntitiesItemResult' => [ 'base' => '<p>The result of calling the operation. The operation returns one object for each document that is successfully processed by the operation.</p>', 'refs' => [ 'ListOfDetectEntitiesResult$member' => NULL, ], ], 'BatchDetectEntitiesRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchDetectEntitiesResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchDetectKeyPhrasesItemResult' => [ 'base' => '<p>The result of calling the operation. The operation returns one object for each document that is successfully processed by the operation.</p>', 'refs' => [ 'ListOfDetectKeyPhrasesResult$member' => NULL, ], ], 'BatchDetectKeyPhrasesRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchDetectKeyPhrasesResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchDetectSentimentItemResult' => [ 'base' => '<p>The result of calling the operation. The operation returns one object for each document that is successfully processed by the operation.</p>', 'refs' => [ 'ListOfDetectSentimentResult$member' => NULL, ], ], 'BatchDetectSentimentRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchDetectSentimentResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchDetectSyntaxItemResult' => [ 'base' => '<p>The result of calling the operation. The operation returns one object that is successfully processed by the operation.</p>', 'refs' => [ 'ListOfDetectSyntaxResult$member' => NULL, ], ], 'BatchDetectSyntaxRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchDetectSyntaxResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchDetectTargetedSentimentItemResult' => [ 'base' => '<p>Analysis results for one of the documents in the batch.</p>', 'refs' => [ 'ListOfDetectTargetedSentimentResult$member' => NULL, ], ], 'BatchDetectTargetedSentimentRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchDetectTargetedSentimentResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchItemError' => [ 'base' => '<p>Describes an error that occurred while processing a document in a batch. The operation returns on <code>BatchItemError</code> object for each document that contained an error.</p>', 'refs' => [ 'BatchItemErrorList$member' => NULL, ], ], 'BatchItemErrorList' => [ 'base' => NULL, 'refs' => [ 'BatchDetectDominantLanguageResponse$ErrorList' => '<p>A list containing one object for each document that contained an error. The results are sorted in ascending order by the <code>Index</code> field and match the order of the documents in the input list. If there are no errors in the batch, the <code>ErrorList</code> is empty.</p>', 'BatchDetectEntitiesResponse$ErrorList' => '<p>A list containing one object for each document that contained an error. The results are sorted in ascending order by the <code>Index</code> field and match the order of the documents in the input list. If there are no errors in the batch, the <code>ErrorList</code> is empty.</p>', 'BatchDetectKeyPhrasesResponse$ErrorList' => '<p>A list containing one object for each document that contained an error. The results are sorted in ascending order by the <code>Index</code> field and match the order of the documents in the input list. If there are no errors in the batch, the <code>ErrorList</code> is empty.</p>', 'BatchDetectSentimentResponse$ErrorList' => '<p>A list containing one object for each document that contained an error. The results are sorted in ascending order by the <code>Index</code> field and match the order of the documents in the input list. If there are no errors in the batch, the <code>ErrorList</code> is empty.</p>', 'BatchDetectSyntaxResponse$ErrorList' => '<p>A list containing one object for each document that contained an error. The results are sorted in ascending order by the <code>Index</code> field and match the order of the documents in the input list. If there are no errors in the batch, the <code>ErrorList</code> is empty.</p>', 'BatchDetectTargetedSentimentResponse$ErrorList' => '<p>List of errors that the operation can return.</p>', ], ], 'BatchSizeLimitExceededException' => [ 'base' => '<p>The number of documents in the request exceeds the limit of 25. Try your request again with fewer documents.</p>', 'refs' => [], ], 'Block' => [ 'base' => '<p>Information about each word or line of text in the input document.</p> <p>For additional information, see <a href="https://docs.aws.amazon.com/textract/latest/dg/API_Block.html">Block</a> in the Amazon Textract API reference.</p>', 'refs' => [ 'ListOfBlocks$member' => NULL, ], ], 'BlockReference' => [ 'base' => '<p>A reference to a block. </p>', 'refs' => [ 'ListOfBlockReferences$member' => NULL, ], ], 'BlockType' => [ 'base' => NULL, 'refs' => [ 'Block$BlockType' => '<p>The block represents a line of text or one word of text.</p> <ul> <li> <p>WORD - A word that\'s detected on a document page. A word is one or more ISO basic Latin script characters that aren\'t separated by spaces.</p> </li> <li> <p>LINE - A string of tab-delimited, contiguous words that are detected on a document page</p> </li> </ul>', ], ], 'BoundingBox' => [ 'base' => '<p>The bounding box around the detected page or around an element on a document page. The left (x-coordinate) and top (y-coordinate) are coordinates that represent the top and left sides of the bounding box. Note that the upper-left corner of the image is the origin (0,0). </p> <p>For additional information, see <a href="https://docs.aws.amazon.com/textract/latest/dg/API_BoundingBox.html">BoundingBox</a> in the Amazon Textract API reference.</p>', 'refs' => [ 'Geometry$BoundingBox' => '<p>An axis-aligned coarse representation of the location of the recognized item on the document page.</p>', ], ], 'ChildBlock' => [ 'base' => '<p>Nested block contained within a block.</p>', 'refs' => [ 'ListOfChildBlocks$member' => NULL, ], ], 'ClassifierEvaluationMetrics' => [ 'base' => '<p>Describes the result metrics for the test data associated with an documentation classifier.</p>', 'refs' => [ 'ClassifierMetadata$EvaluationMetrics' => '<p> Describes the result metrics for the test data associated with an documentation classifier.</p>', ], ], 'ClassifierMetadata' => [ 'base' => '<p>Provides information about a document classifier.</p>', 'refs' => [ 'DocumentClassifierProperties$ClassifierMetadata' => '<p>Information about the document classifier, including the number of documents used for training the classifier, the number of documents used for test the classifier, and an accuracy rating.</p>', ], ], 'ClassifyDocumentRequest' => [ 'base' => NULL, 'refs' => [], ], 'ClassifyDocumentResponse' => [ 'base' => NULL, 'refs' => [], ], 'ClientRequestTokenString' => [ 'base' => NULL, 'refs' => [ 'CreateDatasetRequest$ClientRequestToken' => '<p>A unique identifier for the request. If you don\'t set the client request token, Amazon Comprehend generates one.</p>', 'CreateDocumentClassifierRequest$ClientRequestToken' => '<p>A unique identifier for the request. If you don\'t set the client request token, Amazon Comprehend generates one.</p>', 'CreateEndpointRequest$ClientRequestToken' => '<p>An idempotency token provided by the customer. If this token matches a previous endpoint creation request, Amazon Comprehend will not return a <code>ResourceInUseException</code>. </p>', 'CreateEntityRecognizerRequest$ClientRequestToken' => '<p> A unique identifier for the request. If you don\'t set the client request token, Amazon Comprehend generates one.</p>', 'CreateFlywheelRequest$ClientRequestToken' => '<p>A unique identifier for the request. If you don\'t set the client request token, Amazon Comprehend generates one.</p>', 'StartDocumentClassificationJobRequest$ClientRequestToken' => '<p>A unique identifier for the request. If you do not set the client request token, Amazon Comprehend generates one.</p>', 'StartDominantLanguageDetectionJobRequest$ClientRequestToken' => '<p>A unique identifier for the request. If you do not set the client request token, Amazon Comprehend generates one.</p>', 'StartEntitiesDetectionJobRequest$ClientRequestToken' => '<p>A unique identifier for the request. If you don\'t set the client request token, Amazon Comprehend generates one.</p>', 'StartEventsDetectionJobRequest$ClientRequestToken' => '<p>An unique identifier for the request. If you don\'t set the client request token, Amazon Comprehend generates one.</p>', 'StartFlywheelIterationRequest$ClientRequestToken' => '<p>A unique identifier for the request. If you don\'t set the client request token, Amazon Comprehend generates one.</p>', 'StartKeyPhrasesDetectionJobRequest$ClientRequestToken' => '<p>A unique identifier for the request. If you don\'t set the client request token, Amazon Comprehend generates one.</p>', 'StartPiiEntitiesDetectionJobRequest$ClientRequestToken' => '<p>A unique identifier for the request. If you don\'t set the client request token, Amazon Comprehend generates one.</p>', 'StartSentimentDetectionJobRequest$ClientRequestToken' => '<p>A unique identifier for the request. If you don\'t set the client request token, Amazon Comprehend generates one.</p>', 'StartTargetedSentimentDetectionJobRequest$ClientRequestToken' => '<p>A unique identifier for the request. If you don\'t set the client request token, Amazon Comprehend generates one.</p>', 'StartTopicsDetectionJobRequest$ClientRequestToken' => '<p>A unique identifier for the request. If you do not set the client request token, Amazon Comprehend generates one.</p>', ], ], 'ComprehendArn' => [ 'base' => NULL, 'refs' => [ 'DocumentClassificationJobProperties$JobArn' => '<p>The Amazon Resource Name (ARN) of the document classification job. It is a unique, fully qualified identifier for the job. It includes the Amazon Web Services account, Amazon Web Services Region, and the job ID. The format of the ARN is as follows:</p> <p> <code>arn:&lt;partition&gt;:comprehend:&lt;region&gt;:&lt;account-id&gt;:document-classification-job/&lt;job-id&gt;</code> </p> <p>The following is an example job ARN:</p> <p> <code>arn:aws:comprehend:us-west-2:111122223333:document-classification-job/1234abcd12ab34cd56ef1234567890ab</code> </p>', 'DominantLanguageDetectionJobProperties$JobArn' => '<p>The Amazon Resource Name (ARN) of the dominant language detection job. It is a unique, fully qualified identifier for the job. It includes the Amazon Web Services account, Amazon Web Services Region, and the job ID. The format of the ARN is as follows:</p> <p> <code>arn:&lt;partition&gt;:comprehend:&lt;region&gt;:&lt;account-id&gt;:dominant-language-detection-job/&lt;job-id&gt;</code> </p> <p>The following is an example job ARN:</p> <p> <code>arn:aws:comprehend:us-west-2:111122223333:dominant-language-detection-job/1234abcd12ab34cd56ef1234567890ab</code> </p>', 'EntitiesDetectionJobProperties$JobArn' => '<p>The Amazon Resource Name (ARN) of the entities detection job. It is a unique, fully qualified identifier for the job. It includes the Amazon Web Services account, Amazon Web Services Region, and the job ID. The format of the ARN is as follows:</p> <p> <code>arn:&lt;partition&gt;:comprehend:&lt;region&gt;:&lt;account-id&gt;:entities-detection-job/&lt;job-id&gt;</code> </p> <p>The following is an example job ARN:</p> <p> <code>arn:aws:comprehend:us-west-2:111122223333:entities-detection-job/1234abcd12ab34cd56ef1234567890ab</code> </p>', 'EventsDetectionJobProperties$JobArn' => '<p>The Amazon Resource Name (ARN) of the events detection job. It is a unique, fully qualified identifier for the job. It includes the Amazon Web Services account, Amazon Web Services Region, and the job ID. The format of the ARN is as follows:</p> <p> <code>arn:&lt;partition&gt;:comprehend:&lt;region&gt;:&lt;account-id&gt;:events-detection-job/&lt;job-id&gt;</code> </p> <p>The following is an example job ARN:</p> <p> <code>arn:aws:comprehend:us-west-2:111122223333:events-detection-job/1234abcd12ab34cd56ef1234567890ab</code> </p>', 'KeyPhrasesDetectionJobProperties$JobArn' => '<p>The Amazon Resource Name (ARN) of the key phrases detection job. It is a unique, fully qualified identifier for the job. It includes the Amazon Web Services account, Amazon Web Services Region, and the job ID. The format of the ARN is as follows:</p> <p> <code>arn:&lt;partition&gt;:comprehend:&lt;region&gt;:&lt;account-id&gt;:key-phrases-detection-job/&lt;job-id&gt;</code> </p> <p>The following is an example job ARN:</p> <p> <code>arn:aws:comprehend:us-west-2:111122223333:key-phrases-detection-job/1234abcd12ab34cd56ef1234567890ab</code> </p>', 'ListTagsForResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the given Amazon Comprehend resource you are querying. </p>', 'ListTagsForResourceResponse$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the given Amazon Comprehend resource you are querying.</p>', 'PiiEntitiesDetectionJobProperties$JobArn' => '<p>The Amazon Resource Name (ARN) of the PII entities detection job. It is a unique, fully qualified identifier for the job. It includes the Amazon Web Services account, Amazon Web Services Region, and the job ID. The format of the ARN is as follows:</p> <p> <code>arn:&lt;partition&gt;:comprehend:&lt;region&gt;:&lt;account-id&gt;:pii-entities-detection-job/&lt;job-id&gt;</code> </p> <p>The following is an example job ARN:</p> <p> <code>arn:aws:comprehend:us-west-2:111122223333:pii-entities-detection-job/1234abcd12ab34cd56ef1234567890ab</code> </p>', 'SentimentDetectionJobProperties$JobArn' => '<p>The Amazon Resource Name (ARN) of the sentiment detection job. It is a unique, fully qualified identifier for the job. It includes the Amazon Web Services account, Amazon Web Services Region, and the job ID. The format of the ARN is as follows:</p> <p> <code>arn:&lt;partition&gt;:comprehend:&lt;region&gt;:&lt;account-id&gt;:sentiment-detection-job/&lt;job-id&gt;</code> </p> <p>The following is an example job ARN:</p> <p> <code>arn:aws:comprehend:us-west-2:111122223333:sentiment-detection-job/1234abcd12ab34cd56ef1234567890ab</code> </p>', 'StartDocumentClassificationJobResponse$JobArn' => '<p>The Amazon Resource Name (ARN) of the document classification job. It is a unique, fully qualified identifier for the job. It includes the Amazon Web Services account, Amazon Web Services Region, and the job ID. The format of the ARN is as follows:</p> <p> <code>arn:&lt;partition&gt;:comprehend:&lt;region&gt;:&lt;account-id&gt;:document-classification-job/&lt;job-id&gt;</code> </p> <p>The following is an example job ARN:</p> <p> <code>arn:aws:comprehend:us-west-2:111122223333:document-classification-job/1234abcd12ab34cd56ef1234567890ab</code> </p>', 'StartDominantLanguageDetectionJobResponse$JobArn' => '<p>The Amazon Resource Name (ARN) of the dominant language detection job. It is a unique, fully qualified identifier for the job. It includes the Amazon Web Services account, Amazon Web Services Region, and the job ID. The format of the ARN is as follows:</p> <p> <code>arn:&lt;partition&gt;:comprehend:&lt;region&gt;:&lt;account-id&gt;:dominant-language-detection-job/&lt;job-id&gt;</code> </p> <p>The following is an example job ARN:</p> <p> <code>arn:aws:comprehend:us-west-2:111122223333:dominant-language-detection-job/1234abcd12ab34cd56ef1234567890ab</code> </p>', 'StartEntitiesDetectionJobResponse$JobArn' => '<p>The Amazon Resource Name (ARN) of the entities detection job. It is a unique, fully qualified identifier for the job. It includes the Amazon Web Services account, Amazon Web Services Region, and the job ID. The format of the ARN is as follows:</p> <p> <code>arn:&lt;partition&gt;:comprehend:&lt;region&gt;:&lt;account-id&gt;:entities-detection-job/&lt;job-id&gt;</code> </p> <p>The following is an example job ARN:</p> <p> <code>arn:aws:comprehend:us-west-2:111122223333:entities-detection-job/1234abcd12ab34cd56ef1234567890ab</code> </p>', 'StartEventsDetectionJobResponse$JobArn' => '<p>The Amazon Resource Name (ARN) of the events detection job. It is a unique, fully qualified identifier for the job. It includes the Amazon Web Services account, Amazon Web Services Region, and the job ID. The format of the ARN is as follows:</p> <p> <code>arn:&lt;partition&gt;:comprehend:&lt;region&gt;:&lt;account-id&gt;:events-detection-job/&lt;job-id&gt;</code> </p> <p>The following is an example job ARN:</p> <p> <code>arn:aws:comprehend:us-west-2:111122223333:events-detection-job/1234abcd12ab34cd56ef1234567890ab</code> </p>', 'StartKeyPhrasesDetectionJobResponse$JobArn' => '<p>The Amazon Resource Name (ARN) of the key phrase detection job. It is a unique, fully qualified identifier for the job. It includes the Amazon Web Services account, Amazon Web Services Region, and the job ID. The format of the ARN is as follows:</p> <p> <code>arn:&lt;partition&gt;:comprehend:&lt;region&gt;:&lt;account-id&gt;:key-phrases-detection-job/&lt;job-id&gt;</code> </p> <p>The following is an example job ARN:</p> <p> <code>arn:aws:comprehend:us-west-2:111122223333:key-phrases-detection-job/1234abcd12ab34cd56ef1234567890ab</code> </p>', 'StartPiiEntitiesDetectionJobResponse$JobArn' => '<p>The Amazon Resource Name (ARN) of the PII entity detection job. It is a unique, fully qualified identifier for the job. It includes the Amazon Web Services account, Amazon Web Services Region, and the job ID. The format of the ARN is as follows:</p> <p> <code>arn:&lt;partition&gt;:comprehend:&lt;region&gt;:&lt;account-id&gt;:pii-entities-detection-job/&lt;job-id&gt;</code> </p> <p>The following is an example job ARN:</p> <p> <code>arn:aws:comprehend:us-west-2:111122223333:pii-entities-detection-job/1234abcd12ab34cd56ef1234567890ab</code> </p>', 'StartSentimentDetectionJobResponse$JobArn' => '<p>The Amazon Resource Name (ARN) of the sentiment detection job. It is a unique, fully qualified identifier for the job. It includes the Amazon Web Services account, Amazon Web Services Region, and the job ID. The format of the ARN is as follows:</p> <p> <code>arn:&lt;partition&gt;:comprehend:&lt;region&gt;:&lt;account-id&gt;:sentiment-detection-job/&lt;job-id&gt;</code> </p> <p>The following is an example job ARN:</p> <p> <code>arn:aws:comprehend:us-west-2:111122223333:sentiment-detection-job/1234abcd12ab34cd56ef1234567890ab</code> </p>', 'StartTargetedSentimentDetectionJobResponse$JobArn' => '<p>The Amazon Resource Name (ARN) of the targeted sentiment detection job. It is a unique, fully qualified identifier for the job. It includes the Amazon Web Services account, Amazon Web Services Region, and the job ID. The format of the ARN is as follows:</p> <p> <code>arn:&lt;partition&gt;:comprehend:&lt;region&gt;:&lt;account-id&gt;:targeted-sentiment-detection-job/&lt;job-id&gt;</code> </p> <p>The following is an example job ARN:</p> <p> <code>arn:aws:comprehend:us-west-2:111122223333:targeted-sentiment-detection-job/1234abcd12ab34cd56ef1234567890ab</code> </p>', 'StartTopicsDetectionJobResponse$JobArn' => '<p>The Amazon Resource Name (ARN) of the topics detection job. It is a unique, fully qualified identifier for the job. It includes the Amazon Web Services account, Amazon Web Services Region, and the job ID. The format of the ARN is as follows:</p> <p> <code>arn:&lt;partition&gt;:comprehend:&lt;region&gt;:&lt;account-id&gt;:topics-detection-job/&lt;job-id&gt;</code> </p> <p>The following is an example job ARN:</p> <p> <code>arn:aws:comprehend:us-west-2:111122223333:document-classification-job/1234abcd12ab34cd56ef1234567890ab</code> </p>', 'TagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the given Amazon Comprehend resource to which you want to associate the tags. </p>', 'TargetedSentimentDetectionJobProperties$JobArn' => '<p>The Amazon Resource Name (ARN) of the targeted sentiment detection job. It is a unique, fully qualified identifier for the job. It includes the Amazon Web Services account, Amazon Web Services Region, and the job ID. The format of the ARN is as follows:</p> <p> <code>arn:&lt;partition&gt;:comprehend:&lt;region&gt;:&lt;account-id&gt;:targeted-sentiment-detection-job/&lt;job-id&gt;</code> </p> <p>The following is an example job ARN:</p> <p> <code>arn:aws:comprehend:us-west-2:111122223333:targeted-sentiment-detection-job/1234abcd12ab34cd56ef1234567890ab</code> </p>', 'TopicsDetectionJobProperties$JobArn' => '<p>The Amazon Resource Name (ARN) of the topics detection job. It is a unique, fully qualified identifier for the job. It includes the Amazon Web Services account, Amazon Web Services Region, and the job ID. The format of the ARN is as follows:</p> <p> <code>arn:&lt;partition&gt;:comprehend:&lt;region&gt;:&lt;account-id&gt;:topics-detection-job/&lt;job-id&gt;</code> </p> <p>The following is an example job ARN:</p> <p> <code>arn:aws:comprehend:us-west-2:111122223333:topics-detection-job/1234abcd12ab34cd56ef1234567890ab</code> </p>', 'UntagResourceRequest$ResourceArn' => '<p> The Amazon Resource Name (ARN) of the given Amazon Comprehend resource from which you want to remove the tags. </p>', ], ], 'ComprehendArnName' => [ 'base' => NULL, 'refs' => [ 'CreateDatasetRequest$DatasetName' => '<p>Name of the dataset.</p>', 'CreateDocumentClassifierRequest$DocumentClassifierName' => '<p>The name of the document classifier.</p>', 'CreateEntityRecognizerRequest$RecognizerName' => '<p>The name given to the newly created recognizer. Recognizer names can be a maximum of 256 characters. Alphanumeric characters, hyphens (-) and underscores (_) are allowed. The name must be unique in the account/Region.</p>', 'CreateFlywheelRequest$FlywheelName' => '<p>Name for the flywheel.</p>', 'DatasetProperties$DatasetName' => '<p>The name of the dataset.</p>', 'DocumentClassifierFilter$DocumentClassifierName' => '<p>The name that you assigned to the document classifier</p>', 'DocumentClassifierSummary$DocumentClassifierName' => '<p>The name that you assigned the document classifier.</p>', 'EntityRecognizerFilter$RecognizerName' => '<p>The name that you assigned the entity recognizer.</p>', 'EntityRecognizerSummary$RecognizerName' => '<p> The name that you assigned the entity recognizer.</p>', 'ImportModelRequest$ModelName' => '<p>The name to assign to the custom model that is created in Amazon Comprehend by this import.</p>', ], ], 'ComprehendDatasetArn' => [ 'base' => NULL, 'refs' => [ 'CreateDatasetResponse$DatasetArn' => '<p>The ARN of the dataset.</p>', 'DatasetProperties$DatasetArn' => '<p>The ARN of the dataset.</p>', 'DescribeDatasetRequest$DatasetArn' => '<p>The ARN of the dataset.</p>', ], ], 'ComprehendEndpointArn' => [ 'base' => NULL, 'refs' => [ 'CreateEndpointResponse$EndpointArn' => '<p>The Amazon Resource Number (ARN) of the endpoint being created.</p>', 'DeleteEndpointRequest$EndpointArn' => '<p>The Amazon Resource Number (ARN) of the endpoint being deleted.</p>', 'DescribeEndpointRequest$EndpointArn' => '<p>The Amazon Resource Number (ARN) of the endpoint being described.</p>', 'EndpointProperties$EndpointArn' => '<p>The Amazon Resource Number (ARN) of the endpoint.</p>', 'UpdateEndpointRequest$EndpointArn' => '<p>The Amazon Resource Number (ARN) of the endpoint being updated.</p>', ], ], 'ComprehendEndpointName' => [ 'base' => NULL, 'refs' => [ 'CreateEndpointRequest$EndpointName' => '<p>This is the descriptive suffix that becomes part of the <code>EndpointArn</code> used for all subsequent requests to this resource. </p>', ], ], 'ComprehendFlywheelArn' => [ 'base' => NULL, 'refs' => [ 'CreateDatasetRequest$FlywheelArn' => '<p>The Amazon Resource Number (ARN) of the flywheel of the flywheel to receive the data.</p>', 'CreateEndpointRequest$FlywheelArn' => '<p>The Amazon Resource Number (ARN) of the flywheel to which the endpoint will be attached.</p>', 'CreateFlywheelResponse$FlywheelArn' => '<p>The Amazon Resource Number (ARN) of the flywheel.</p>', 'DeleteFlywheelRequest$FlywheelArn' => '<p>The Amazon Resource Number (ARN) of the flywheel to delete.</p>', 'DescribeFlywheelIterationRequest$FlywheelArn' => '<p/>', 'DescribeFlywheelRequest$FlywheelArn' => '<p>The Amazon Resource Number (ARN) of the flywheel.</p>', 'DocumentClassificationJobProperties$FlywheelArn' => '<p>The Amazon Resource Number (ARN) of the flywheel</p>', 'DocumentClassifierProperties$FlywheelArn' => '<p>The Amazon Resource Number (ARN) of the flywheel</p>', 'EndpointProperties$FlywheelArn' => '<p>The Amazon Resource Number (ARN) of the flywheel</p>', 'EntitiesDetectionJobProperties$FlywheelArn' => '<p>The Amazon Resource Name (ARN) of the flywheel associated with this job.</p>', 'EntityRecognizerProperties$FlywheelArn' => '<p>The Amazon Resource Number (ARN) of the flywheel</p>', 'FlywheelIterationProperties$FlywheelArn' => '<p/>', 'FlywheelProperties$FlywheelArn' => '<p>The Amazon Resource Number (ARN) of the flywheel.</p>', 'FlywheelSummary$FlywheelArn' => '<p>The Amazon Resource Number (ARN) of the flywheel</p>', 'ListDatasetsRequest$FlywheelArn' => '<p>The Amazon Resource Number (ARN) of the flywheel.</p>', 'ListFlywheelIterationHistoryRequest$FlywheelArn' => '<p>The ARN of the flywheel.</p>', 'StartDocumentClassificationJobRequest$FlywheelArn' => '<p>The Amazon Resource Number (ARN) of the flywheel associated with the model to use.</p>', 'StartEntitiesDetectionJobRequest$FlywheelArn' => '<p>The Amazon Resource Number (ARN) of the flywheel associated with the model to use.</p>', 'StartFlywheelIterationRequest$FlywheelArn' => '<p>The ARN of the flywheel.</p>', 'StartFlywheelIterationResponse$FlywheelArn' => '<p/>', 'UpdateEndpointRequest$FlywheelArn' => '<p>The Amazon Resource Number (ARN) of the flywheel</p>', 'UpdateFlywheelRequest$FlywheelArn' => '<p>The Amazon Resource Number (ARN) of the flywheel to update.</p>', ], ], 'ComprehendModelArn' => [ 'base' => NULL, 'refs' => [ 'CreateEndpointRequest$ModelArn' => '<p>The Amazon Resource Number (ARN) of the model to which the endpoint will be attached.</p>', 'CreateEndpointResponse$ModelArn' => '<p>The Amazon Resource Number (ARN) of the model to which the endpoint is attached.</p>', 'CreateFlywheelRequest$ActiveModelArn' => '<p>To associate an existing model with the flywheel, specify the Amazon Resource Number (ARN) of the model version. Do not set <code>TaskConfig</code> or <code>ModelType</code> if you specify an <code>ActiveModelArn</code>.</p>', 'CreateFlywheelResponse$ActiveModelArn' => '<p>The Amazon Resource Number (ARN) of the active model version.</p>', 'DeleteResourcePolicyRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the custom model version that has the policy to delete.</p>', 'DescribeResourcePolicyRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the custom model version that has the resource policy.</p>', 'EndpointFilter$ModelArn' => '<p>The Amazon Resource Number (ARN) of the model to which the endpoint is attached.</p>', 'EndpointProperties$ModelArn' => '<p>The Amazon Resource Number (ARN) of the model to which the endpoint is attached.</p>', 'EndpointProperties$DesiredModelArn' => '<p>ARN of the new model to use for updating an existing endpoint. This ARN is going to be different from the model ARN when the update is in progress</p>', 'FlywheelIterationProperties$EvaluatedModelArn' => '<p>The ARN of the evaluated model associated with this flywheel iteration.</p>', 'FlywheelIterationProperties$TrainedModelArn' => '<p>The ARN of the trained model associated with this flywheel iteration.</p>', 'FlywheelProperties$ActiveModelArn' => '<p>The Amazon Resource Number (ARN) of the active model version.</p>', 'FlywheelSummary$ActiveModelArn' => '<p>ARN of the active model version for the flywheel.</p>', 'ImportModelRequest$SourceModelArn' => '<p>The Amazon Resource Name (ARN) of the custom model to import.</p>', 'ImportModelResponse$ModelArn' => '<p>The Amazon Resource Name (ARN) of the custom model being imported.</p>', 'PutResourcePolicyRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the custom model to attach the policy to.</p>', 'UpdateEndpointRequest$DesiredModelArn' => '<p>The ARN of the new model to use when updating an existing endpoint.</p>', 'UpdateEndpointResponse$DesiredModelArn' => '<p>The Amazon Resource Number (ARN) of the new model.</p>', 'UpdateFlywheelRequest$ActiveModelArn' => '<p>The Amazon Resource Number (ARN) of the active model version.</p>', ], ], 'ConcurrentModificationException' => [ 'base' => '<p>Concurrent modification of the tags associated with an Amazon Comprehend resource is not supported. </p>', 'refs' => [], ], 'ContainsPiiEntitiesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ContainsPiiEntitiesResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateDatasetRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDatasetResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateDocumentClassifierRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDocumentClassifierResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateEndpointRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateEndpointResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateEntityRecognizerRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateEntityRecognizerResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateFlywheelRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateFlywheelResponse' => [ 'base' => NULL, 'refs' => [], ], 'CustomerInputString' => [ 'base' => NULL, 'refs' => [ 'ClassifyDocumentRequest$Text' => '<p>The document text to be analyzed. If you enter text using this parameter, do not use the <code>Bytes</code> parameter.</p>', 'CustomerInputStringList$member' => NULL, 'DetectDominantLanguageRequest$Text' => '<p>A UTF-8 text string. The string must contain at least 20 characters. The maximum string size is 100 KB.</p>', 'DetectEntitiesRequest$Text' => '<p>A UTF-8 text string. The maximum string size is 100 KB. If you enter text using this parameter, do not use the <code>Bytes</code> parameter.</p>', 'DetectKeyPhrasesRequest$Text' => '<p>A UTF-8 text string. The string must contain less than 100 KB of UTF-8 encoded characters.</p>', 'DetectSentimentRequest$Text' => '<p>A UTF-8 text string. The maximum string size is 5 KB.</p>', 'DetectSyntaxRequest$Text' => '<p>A UTF-8 string. The maximum string size is 5 KB.</p>', 'DetectTargetedSentimentRequest$Text' => '<p>A UTF-8 text string. The maximum string length is 5 KB.</p>', 'TextSegment$Text' => '<p>The text content.</p>', ], ], 'CustomerInputStringList' => [ 'base' => NULL, 'refs' => [ 'BatchDetectDominantLanguageRequest$TextList' => '<p>A list containing the UTF-8 encoded text of the input documents. The list can contain a maximum of 25 documents. Each document should contain at least 20 characters. The maximum size of each document is 5 KB.</p>', 'BatchDetectEntitiesRequest$TextList' => '<p>A list containing the UTF-8 encoded text of the input documents. The list can contain a maximum of 25 documents. The maximum size of each document is 5 KB.</p>', 'BatchDetectKeyPhrasesRequest$TextList' => '<p>A list containing the UTF-8 encoded text of the input documents. The list can contain a maximum of 25 documents. The maximum size of each document is 5 KB.</p>', 'BatchDetectSentimentRequest$TextList' => '<p>A list containing the UTF-8 encoded text of the input documents. The list can contain a maximum of 25 documents. The maximum size of each document is 5 KB. </p>', 'BatchDetectSyntaxRequest$TextList' => '<p>A list containing the UTF-8 encoded text of the input documents. The list can contain a maximum of 25 documents. The maximum size for each document is 5 KB.</p>', 'BatchDetectTargetedSentimentRequest$TextList' => '<p>A list containing the UTF-8 encoded text of the input documents. The list can contain a maximum of 25 documents. The maximum size of each document is 5 KB.</p>', ], ], 'DataSecurityConfig' => [ 'base' => '<p>Data security configuration.</p>', 'refs' => [ 'CreateFlywheelRequest$DataSecurityConfig' => '<p>Data security configurations.</p>', 'FlywheelProperties$DataSecurityConfig' => '<p>Data security configuration.</p>', ], ], 'DatasetAugmentedManifestsList' => [ 'base' => NULL, 'refs' => [ 'DatasetInputDataConfig$AugmentedManifests' => '<p>A list of augmented manifest files that provide training data for your custom model. An augmented manifest file is a labeled dataset that is produced by Amazon SageMaker Ground Truth. </p>', ], ], 'DatasetAugmentedManifestsListItem' => [ 'base' => '<p>An augmented manifest file that provides training data for your custom model. An augmented manifest file is a labeled dataset that is produced by Amazon SageMaker Ground Truth.</p>', 'refs' => [ 'DatasetAugmentedManifestsList$member' => NULL, ], ], 'DatasetDataFormat' => [ 'base' => NULL, 'refs' => [ 'DatasetInputDataConfig$DataFormat' => '<p> <code>COMPREHEND_CSV</code>: The data format is a two-column CSV file, where the first column contains labels and the second column contains documents.</p> <p> <code>AUGMENTED_MANIFEST</code>: The data format </p>', ], ], 'DatasetDocumentClassifierInputDataConfig' => [ 'base' => '<p>Describes the dataset input data configuration for a document classifier model.</p> <p>For more information on how the input file is formatted, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/prep-classifier-data.html">Preparing training data</a> in the Comprehend Developer Guide. </p>', 'refs' => [ 'DatasetInputDataConfig$DocumentClassifierInputDataConfig' => '<p>The input properties for training a document classifier model. </p> <p>For more information on how the input file is formatted, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/prep-classifier-data.html">Preparing training data</a> in the Comprehend Developer Guide. </p>', ], ], 'DatasetEntityRecognizerAnnotations' => [ 'base' => '<p>Describes the annotations associated with a entity recognizer.</p>', 'refs' => [ 'DatasetEntityRecognizerInputDataConfig$Annotations' => '<p>The S3 location of the annotation documents for your custom entity recognizer.</p>', ], ], 'DatasetEntityRecognizerDocuments' => [ 'base' => '<p>Describes the documents submitted with a dataset for an entity recognizer model.</p>', 'refs' => [ 'DatasetEntityRecognizerInputDataConfig$Documents' => '<p>The format and location of the training documents for your custom entity recognizer.</p>', ], ], 'DatasetEntityRecognizerEntityList' => [ 'base' => '<p>Describes the dataset entity list for an entity recognizer model.</p> <p>For more information on how the input file is formatted, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/prep-training-data-cer.html">Preparing training data</a> in the Comprehend Developer Guide. </p>', 'refs' => [ 'DatasetEntityRecognizerInputDataConfig$EntityList' => '<p>The S3 location of the entity list for your custom entity recognizer.</p>', ], ], 'DatasetEntityRecognizerInputDataConfig' => [ 'base' => '<p>Specifies the format and location of the input data. You must provide either the <code>Annotations</code> parameter or the <code>EntityList</code> parameter.</p>', 'refs' => [ 'DatasetInputDataConfig$EntityRecognizerInputDataConfig' => '<p>The input properties for training an entity recognizer model.</p>', ], ], 'DatasetFilter' => [ 'base' => '<p>Filter the datasets based on creation time or dataset status.</p>', 'refs' => [ 'ListDatasetsRequest$Filter' => '<p>Filters the datasets to be returned in the response.</p>', ], ], 'DatasetInputDataConfig' => [ 'base' => '<p>Specifies the format and location of the input data for the dataset.</p>', 'refs' => [ 'CreateDatasetRequest$InputDataConfig' => '<p>Information about the input data configuration. The type of input data varies based on the format of the input and whether the data is for a classifier model or an entity recognition model.</p>', ], ], 'DatasetProperties' => [ 'base' => '<p>Properties associated with the dataset.</p>', 'refs' => [ 'DatasetPropertiesList$member' => NULL, 'DescribeDatasetResponse$DatasetProperties' => '<p>The dataset properties.</p>', ], ], 'DatasetPropertiesList' => [ 'base' => NULL, 'refs' => [ 'ListDatasetsResponse$DatasetPropertiesList' => '<p>The dataset properties list.</p>', ], ], 'DatasetStatus' => [ 'base' => NULL, 'refs' => [ 'DatasetFilter$Status' => '<p>Filter the datasets based on the dataset status.</p>', 'DatasetProperties$Status' => '<p>The dataset status. While the system creates the dataset, the status is <code>CREATING</code>. When the dataset is ready to use, the status changes to <code>COMPLETED</code>. </p>', ], ], 'DatasetType' => [ 'base' => NULL, 'refs' => [ 'CreateDatasetRequest$DatasetType' => '<p>The dataset type. You can specify that the data in a dataset is for training the model or for testing the model.</p>', 'DatasetFilter$DatasetType' => '<p>Filter the datasets based on the dataset type.</p>', 'DatasetProperties$DatasetType' => '<p>The dataset type (training data or test data).</p>', ], ], 'DeleteDocumentClassifierRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDocumentClassifierResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEndpointRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEndpointResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEntityRecognizerRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEntityRecognizerResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFlywheelRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFlywheelResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResourcePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResourcePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDatasetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDatasetResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDocumentClassificationJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDocumentClassificationJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDocumentClassifierRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDocumentClassifierResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDominantLanguageDetectionJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDominantLanguageDetectionJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEndpointRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEndpointResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEntitiesDetectionJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEntitiesDetectionJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEntityRecognizerRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEntityRecognizerResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEventsDetectionJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEventsDetectionJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFlywheelIterationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFlywheelIterationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFlywheelRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFlywheelResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeKeyPhrasesDetectionJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeKeyPhrasesDetectionJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribePiiEntitiesDetectionJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribePiiEntitiesDetectionJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeResourcePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeResourcePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSentimentDetectionJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSentimentDetectionJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTargetedSentimentDetectionJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTargetedSentimentDetectionJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTopicsDetectionJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTopicsDetectionJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'CreateDatasetRequest$Description' => '<p>Description of the dataset.</p>', 'DatasetProperties$Description' => '<p>Description of the dataset.</p>', ], ], 'DetectDominantLanguageRequest' => [ 'base' => NULL, 'refs' => [], ], 'DetectDominantLanguageResponse' => [ 'base' => NULL, 'refs' => [], ], 'DetectEntitiesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DetectEntitiesResponse' => [ 'base' => NULL, 'refs' => [], ], 'DetectKeyPhrasesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DetectKeyPhrasesResponse' => [ 'base' => NULL, 'refs' => [], ], 'DetectPiiEntitiesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DetectPiiEntitiesResponse' => [ 'base' => NULL, 'refs' => [], ], 'DetectSentimentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DetectSentimentResponse' => [ 'base' => NULL, 'refs' => [], ], 'DetectSyntaxRequest' => [ 'base' => NULL, 'refs' => [], ], 'DetectSyntaxResponse' => [ 'base' => NULL, 'refs' => [], ], 'DetectTargetedSentimentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DetectTargetedSentimentResponse' => [ 'base' => NULL, 'refs' => [], ], 'DetectToxicContentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DetectToxicContentResponse' => [ 'base' => NULL, 'refs' => [], ], 'DocumentClass' => [ 'base' => '<p>Specifies the class that categorizes the document being analyzed</p>', 'refs' => [ 'ListOfClasses$member' => NULL, ], ], 'DocumentClassificationConfig' => [ 'base' => '<p>Configuration required for a document classification model.</p>', 'refs' => [ 'TaskConfig$DocumentClassificationConfig' => '<p>Configuration required for a document classification model.</p>', ], ], 'DocumentClassificationJobFilter' => [ 'base' => '<p>Provides information for filtering a list of document classification jobs. For more information, see the operation. You can provide only one filter parameter in each request.</p>', 'refs' => [ 'ListDocumentClassificationJobsRequest$Filter' => '<p>Filters the jobs that are returned. You can filter jobs on their names, status, or the date and time that they were submitted. You can only set one filter at a time.</p>', ], ], 'DocumentClassificationJobProperties' => [ 'base' => '<p>Provides information about a document classification job.</p>', 'refs' => [ 'DescribeDocumentClassificationJobResponse$DocumentClassificationJobProperties' => '<p>An object that describes the properties associated with the document classification job.</p>', 'DocumentClassificationJobPropertiesList$member' => NULL, ], ], 'DocumentClassificationJobPropertiesList' => [ 'base' => NULL, 'refs' => [ 'ListDocumentClassificationJobsResponse$DocumentClassificationJobPropertiesList' => '<p>A list containing the properties of each job returned.</p>', ], ], 'DocumentClassifierArn' => [ 'base' => NULL, 'refs' => [ 'CreateDocumentClassifierResponse$DocumentClassifierArn' => '<p>The Amazon Resource Name (ARN) that identifies the document classifier.</p>', 'DeleteDocumentClassifierRequest$DocumentClassifierArn' => '<p>The Amazon Resource Name (ARN) that identifies the document classifier. </p>', 'DescribeDocumentClassifierRequest$DocumentClassifierArn' => '<p>The Amazon Resource Name (ARN) that identifies the document classifier. The <code>CreateDocumentClassifier</code> operation returns this identifier in its response.</p>', 'DocumentClassificationJobProperties$DocumentClassifierArn' => '<p>The Amazon Resource Name (ARN) that identifies the document classifier. </p>', 'DocumentClassifierProperties$DocumentClassifierArn' => '<p>The Amazon Resource Name (ARN) that identifies the document classifier.</p>', 'DocumentClassifierProperties$SourceModelArn' => '<p>The Amazon Resource Name (ARN) of the source model. This model was imported from a different Amazon Web Services account to create the document classifier model in your Amazon Web Services account.</p>', 'StartDocumentClassificationJobRequest$DocumentClassifierArn' => '<p>The Amazon Resource Name (ARN) of the document classifier to use to process the job.</p>', 'StartDocumentClassificationJobResponse$DocumentClassifierArn' => '<p>The ARN of the custom classification model.</p>', 'StopTrainingDocumentClassifierRequest$DocumentClassifierArn' => '<p>The Amazon Resource Name (ARN) that identifies the document classifier currently being trained.</p>', ], ], 'DocumentClassifierAugmentedManifestsList' => [ 'base' => NULL, 'refs' => [ 'DocumentClassifierInputDataConfig$AugmentedManifests' => '<p>A list of augmented manifest files that provide training data for your custom model. An augmented manifest file is a labeled dataset that is produced by Amazon SageMaker Ground Truth.</p> <p>This parameter is required if you set <code>DataFormat</code> to <code>AUGMENTED_MANIFEST</code>.</p>', ], ], 'DocumentClassifierDataFormat' => [ 'base' => NULL, 'refs' => [ 'DocumentClassifierInputDataConfig$DataFormat' => '<p>The format of your training data:</p> <ul> <li> <p> <code>COMPREHEND_CSV</code>: A two-column CSV file, where labels are provided in the first column, and documents are provided in the second. If you use this value, you must provide the <code>S3Uri</code> parameter in your request.</p> </li> <li> <p> <code>AUGMENTED_MANIFEST</code>: A labeled dataset that is produced by Amazon SageMaker Ground Truth. This file is in JSON lines format. Each line is a complete JSON object that contains a training document and its associated labels. </p> <p>If you use this value, you must provide the <code>AugmentedManifests</code> parameter in your request.</p> </li> </ul> <p>If you don\'t specify a value, Amazon Comprehend uses <code>COMPREHEND_CSV</code> as the default.</p>', ], ], 'DocumentClassifierDocumentTypeFormat' => [ 'base' => NULL, 'refs' => [ 'DocumentClassifierInputDataConfig$DocumentType' => '<p>The type of input documents for training the model. Provide plain-text documents to create a plain-text model, and provide semi-structured documents to create a native document model.</p>', ], ], 'DocumentClassifierDocuments' => [ 'base' => '<p>The location of the training documents. This parameter is required in a request to create a semi-structured document classification model.</p>', 'refs' => [ 'DocumentClassifierInputDataConfig$Documents' => '<p>The S3 location of the training documents. This parameter is required in a request to create a native document model.</p>', ], ], 'DocumentClassifierEndpointArn' => [ 'base' => NULL, 'refs' => [ 'ClassifyDocumentRequest$EndpointArn' => '<p>The Amazon Resource Number (ARN) of the endpoint. </p> <p>For prompt safety classification, Amazon Comprehend provides the endpoint ARN. For more information about prompt safety classifiers, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/trust-safety.html#prompt-classification">Prompt safety classification</a> in the <i>Amazon Comprehend Developer Guide</i> </p> <p>For custom classification, you create an endpoint for your custom model. For more information, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/using-endpoints.html">Using Amazon Comprehend endpoints</a>.</p>', ], ], 'DocumentClassifierFilter' => [ 'base' => '<p>Provides information for filtering a list of document classifiers. You can only specify one filtering parameter in a request. For more information, see the <code>ListDocumentClassifiers</code> operation.</p>', 'refs' => [ 'ListDocumentClassifiersRequest$Filter' => '<p>Filters the jobs that are returned. You can filter jobs on their name, status, or the date and time that they were submitted. You can only set one filter at a time.</p>', ], ], 'DocumentClassifierInputDataConfig' => [ 'base' => '<p>The input properties for training a document classifier. </p> <p>For more information on how the input file is formatted, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/prep-classifier-data.html">Preparing training data</a> in the Comprehend Developer Guide. </p>', 'refs' => [ 'CreateDocumentClassifierRequest$InputDataConfig' => '<p>Specifies the format and location of the input data for the job.</p>', 'DocumentClassifierProperties$InputDataConfig' => '<p>The input data configuration that you supplied when you created the document classifier for training.</p>', ], ], 'DocumentClassifierMode' => [ 'base' => NULL, 'refs' => [ 'CreateDocumentClassifierRequest$Mode' => '<p>Indicates the mode in which the classifier will be trained. The classifier can be trained in multi-class (single-label) mode or multi-label mode. Multi-class mode identifies a single class label for each document and multi-label mode identifies one or more class labels for each document. Multiple labels for an individual document are separated by a delimiter. The default delimiter between labels is a pipe (|).</p>', 'DocumentClassificationConfig$Mode' => '<p>Classification mode indicates whether the documents are <code>MULTI_CLASS</code> or <code>MULTI_LABEL</code>.</p>', 'DocumentClassifierProperties$Mode' => '<p>Indicates the mode in which the specific classifier was trained. This also indicates the format of input documents and the format of the confusion matrix. Each classifier can only be trained in one mode and this cannot be changed once the classifier is trained.</p>', ], ], 'DocumentClassifierOutputDataConfig' => [ 'base' => '<p>Provide the location for output data from a custom classifier job. This field is mandatory if you are training a native document model.</p>', 'refs' => [ 'CreateDocumentClassifierRequest$OutputDataConfig' => '<p>Specifies the location for the output files from a custom classifier job. This parameter is required for a request that creates a native document model.</p>', 'DocumentClassifierProperties$OutputDataConfig' => '<p> Provides output results configuration parameters for custom classifier jobs.</p>', ], ], 'DocumentClassifierProperties' => [ 'base' => '<p>Provides information about a document classifier.</p>', 'refs' => [ 'DescribeDocumentClassifierResponse$DocumentClassifierProperties' => '<p>An object that contains the properties associated with a document classifier.</p>', 'DocumentClassifierPropertiesList$member' => NULL, ], ], 'DocumentClassifierPropertiesList' => [ 'base' => NULL, 'refs' => [ 'ListDocumentClassifiersResponse$DocumentClassifierPropertiesList' => '<p>A list containing the properties of each job returned.</p>', ], ], 'DocumentClassifierSummariesList' => [ 'base' => NULL, 'refs' => [ 'ListDocumentClassifierSummariesResponse$DocumentClassifierSummariesList' => '<p>The list of summaries of document classifiers.</p>', ], ], 'DocumentClassifierSummary' => [ 'base' => '<p>Describes information about a document classifier and its versions.</p>', 'refs' => [ 'DocumentClassifierSummariesList$member' => NULL, ], ], 'DocumentLabel' => [ 'base' => '<p>Specifies one of the label or labels that categorize the document being analyzed.</p>', 'refs' => [ 'ListOfLabels$member' => NULL, ], ], 'DocumentMetadata' => [ 'base' => '<p>Information about the document, discovered during text extraction.</p>', 'refs' => [ 'ClassifyDocumentResponse$DocumentMetadata' => '<p>Extraction information about the document. This field is present in the response only if your request includes the <code>Byte</code> parameter. </p>', 'DetectEntitiesResponse$DocumentMetadata' => '<p>Information about the document, discovered during text extraction. This field is present in the response only if your request used the <code>Byte</code> parameter. </p>', ], ], 'DocumentReadAction' => [ 'base' => NULL, 'refs' => [ 'DocumentReaderConfig$DocumentReadAction' => '<p>This field defines the Amazon Textract API operation that Amazon Comprehend uses to extract text from PDF files and image files. Enter one of the following values:</p> <ul> <li> <p> <code>TEXTRACT_DETECT_DOCUMENT_TEXT</code> - The Amazon Comprehend service uses the <code>DetectDocumentText</code> API operation. </p> </li> <li> <p> <code>TEXTRACT_ANALYZE_DOCUMENT</code> - The Amazon Comprehend service uses the <code>AnalyzeDocument</code> API operation. </p> </li> </ul>', ], ], 'DocumentReadFeatureTypes' => [ 'base' => '<p>TABLES or FORMS</p>', 'refs' => [ 'ListOfDocumentReadFeatureTypes$member' => NULL, ], ], 'DocumentReadMode' => [ 'base' => NULL, 'refs' => [ 'DocumentReaderConfig$DocumentReadMode' => '<p>Determines the text extraction actions for PDF files. Enter one of the following values:</p> <ul> <li> <p> <code>SERVICE_DEFAULT</code> - use the Amazon Comprehend service defaults for PDF files.</p> </li> <li> <p> <code>FORCE_DOCUMENT_READ_ACTION</code> - Amazon Comprehend uses the Textract API specified by DocumentReadAction for all PDF files, including digital PDF files. </p> </li> </ul>', ], ], 'DocumentReaderConfig' => [ 'base' => '<p>Provides configuration parameters to override the default actions for extracting text from PDF documents and image files. </p> <p> By default, Amazon Comprehend performs the following actions to extract text from files, based on the input file type: </p> <ul> <li> <p> <b>Word files</b> - Amazon Comprehend parser extracts the text. </p> </li> <li> <p> <b>Digital PDF files</b> - Amazon Comprehend parser extracts the text. </p> </li> <li> <p> <b>Image files and scanned PDF files</b> - Amazon Comprehend uses the Amazon Textract <code>DetectDocumentText</code> API to extract the text. </p> </li> </ul> <p> <code>DocumentReaderConfig</code> does not apply to plain text files or Word files.</p> <p> For image files and PDF documents, you can override these default actions using the fields listed below. For more information, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/idp-set-textract-options.html"> Setting text extraction options</a> in the Comprehend Developer Guide. </p>', 'refs' => [ 'ClassifyDocumentRequest$DocumentReaderConfig' => '<p>Provides configuration parameters to override the default actions for extracting text from PDF documents and image files.</p>', 'DetectEntitiesRequest$DocumentReaderConfig' => '<p>Provides configuration parameters to override the default actions for extracting text from PDF documents and image files.</p>', 'DocumentClassifierInputDataConfig$DocumentReaderConfig' => NULL, 'InputDataConfig$DocumentReaderConfig' => '<p>Provides configuration parameters to override the default actions for extracting text from PDF documents and image files.</p>', ], ], 'DocumentType' => [ 'base' => NULL, 'refs' => [ 'DocumentTypeListItem$Type' => '<p>Document type.</p>', ], ], 'DocumentTypeListItem' => [ 'base' => '<p>Document type for each page in the document.</p>', 'refs' => [ 'ListOfDocumentType$member' => NULL, ], ], 'DominantLanguage' => [ 'base' => '<p>Returns the code for the dominant language in the input text and the level of confidence that Amazon Comprehend has in the accuracy of the detection.</p>', 'refs' => [ 'ListOfDominantLanguages$member' => NULL, ], ], 'DominantLanguageDetectionJobFilter' => [ 'base' => '<p>Provides information for filtering a list of dominant language detection jobs. For more information, see the operation.</p>', 'refs' => [ 'ListDominantLanguageDetectionJobsRequest$Filter' => '<p>Filters that jobs that are returned. You can filter jobs on their name, status, or the date and time that they were submitted. You can only set one filter at a time.</p>', ], ], 'DominantLanguageDetectionJobProperties' => [ 'base' => '<p>Provides information about a dominant language detection job.</p>', 'refs' => [ 'DescribeDominantLanguageDetectionJobResponse$DominantLanguageDetectionJobProperties' => '<p>An object that contains the properties associated with a dominant language detection job.</p>', 'DominantLanguageDetectionJobPropertiesList$member' => NULL, ], ], 'DominantLanguageDetectionJobPropertiesList' => [ 'base' => NULL, 'refs' => [ 'ListDominantLanguageDetectionJobsResponse$DominantLanguageDetectionJobPropertiesList' => '<p>A list containing the properties of each job that is returned.</p>', ], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'ClassifierEvaluationMetrics$Accuracy' => '<p>The fraction of the labels that were correct recognized. It is computed by dividing the number of labels in the test documents that were correctly recognized by the total number of labels in the test documents.</p>', 'ClassifierEvaluationMetrics$Precision' => '<p>A measure of the usefulness of the classifier results in the test data. High precision means that the classifier returned substantially more relevant results than irrelevant ones.</p>', 'ClassifierEvaluationMetrics$Recall' => '<p>A measure of how complete the classifier results are for the test data. High recall means that the classifier returned most of the relevant results. </p>', 'ClassifierEvaluationMetrics$F1Score' => '<p>A measure of how accurate the classifier results are for the test data. It is derived from the <code>Precision</code> and <code>Recall</code> values. The <code>F1Score</code> is the harmonic average of the two scores. The highest score is 1, and the worst score is 0. </p>', 'ClassifierEvaluationMetrics$MicroPrecision' => '<p>A measure of the usefulness of the recognizer results in the test data. High precision means that the recognizer returned substantially more relevant results than irrelevant ones. Unlike the Precision metric which comes from averaging the precision of all available labels, this is based on the overall score of all precision scores added together.</p>', 'ClassifierEvaluationMetrics$MicroRecall' => '<p>A measure of how complete the classifier results are for the test data. High recall means that the classifier returned most of the relevant results. Specifically, this indicates how many of the correct categories in the text that the model can predict. It is a percentage of correct categories in the text that can found. Instead of averaging the recall scores of all labels (as with Recall), micro Recall is based on the overall score of all recall scores added together.</p>', 'ClassifierEvaluationMetrics$MicroF1Score' => '<p>A measure of how accurate the classifier results are for the test data. It is a combination of the <code>Micro Precision</code> and <code>Micro Recall</code> values. The <code>Micro F1Score</code> is the harmonic mean of the two scores. The highest score is 1, and the worst score is 0.</p>', 'ClassifierEvaluationMetrics$HammingLoss' => '<p>Indicates the fraction of labels that are incorrectly predicted. Also seen as the fraction of wrong labels compared to the total number of labels. Scores closer to zero are better.</p>', 'EntityRecognizerEvaluationMetrics$Precision' => '<p>A measure of the usefulness of the recognizer results in the test data. High precision means that the recognizer returned substantially more relevant results than irrelevant ones. </p>', 'EntityRecognizerEvaluationMetrics$Recall' => '<p>A measure of how complete the recognizer results are for the test data. High recall means that the recognizer returned most of the relevant results.</p>', 'EntityRecognizerEvaluationMetrics$F1Score' => '<p>A measure of how accurate the recognizer results are for the test data. It is derived from the <code>Precision</code> and <code>Recall</code> values. The <code>F1Score</code> is the harmonic average of the two scores. For plain text entity recognizer models, the range is 0 to 100, where 100 is the best score. For PDF/Word entity recognizer models, the range is 0 to 1, where 1 is the best score. </p>', 'EntityTypesEvaluationMetrics$Precision' => '<p>A measure of the usefulness of the recognizer results for a specific entity type in the test data. High precision means that the recognizer returned substantially more relevant results than irrelevant ones. </p>', 'EntityTypesEvaluationMetrics$Recall' => '<p>A measure of how complete the recognizer results are for a specific entity type in the test data. High recall means that the recognizer returned most of the relevant results.</p>', 'EntityTypesEvaluationMetrics$F1Score' => '<p>A measure of how accurate the recognizer results are for a specific entity type in the test data. It is derived from the <code>Precision</code> and <code>Recall</code> values. The <code>F1Score</code> is the harmonic average of the two scores. The highest score is 1, and the worst score is 0. </p>', 'FlywheelModelEvaluationMetrics$AverageF1Score' => '<p>The average F1 score from the evaluation metrics.</p>', 'FlywheelModelEvaluationMetrics$AveragePrecision' => '<p>Average precision metric for the model.</p>', 'FlywheelModelEvaluationMetrics$AverageRecall' => '<p>Average recall metric for the model.</p>', 'FlywheelModelEvaluationMetrics$AverageAccuracy' => '<p>Average accuracy metric for the model.</p>', ], ], 'EndpointFilter' => [ 'base' => '<p>The filter used to determine which endpoints are returned. You can filter jobs on their name, model, status, or the date and time that they were created. You can only set one filter at a time. </p>', 'refs' => [ 'ListEndpointsRequest$Filter' => '<p>Filters the endpoints that are returned. You can filter endpoints on their name, model, status, or the date and time that they were created. You can only set one filter at a time. </p>', ], ], 'EndpointProperties' => [ 'base' => '<p>Specifies information about the specified endpoint. For information about endpoints, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html">Managing endpoints</a>.</p>', 'refs' => [ 'DescribeEndpointResponse$EndpointProperties' => '<p>Describes information associated with the specific endpoint.</p>', 'EndpointPropertiesList$member' => NULL, ], ], 'EndpointPropertiesList' => [ 'base' => NULL, 'refs' => [ 'ListEndpointsResponse$EndpointPropertiesList' => '<p>Displays a list of endpoint properties being retrieved by the service in response to the request.</p>', ], ], 'EndpointStatus' => [ 'base' => NULL, 'refs' => [ 'EndpointFilter$Status' => '<p>Specifies the status of the endpoint being returned. Possible values are: Creating, Ready, Updating, Deleting, Failed.</p>', 'EndpointProperties$Status' => '<p>Specifies the status of the endpoint. Because the endpoint updates and creation are asynchronous, so customers will need to wait for the endpoint to be <code>Ready</code> status before making inference requests.</p>', ], ], 'EntitiesDetectionJobFilter' => [ 'base' => '<p>Provides information for filtering a list of dominant language detection jobs. For more information, see the operation.</p>', 'refs' => [ 'ListEntitiesDetectionJobsRequest$Filter' => '<p>Filters the jobs that are returned. You can filter jobs on their name, status, or the date and time that they were submitted. You can only set one filter at a time.</p>', ], ], 'EntitiesDetectionJobProperties' => [ 'base' => '<p>Provides information about an entities detection job.</p>', 'refs' => [ 'DescribeEntitiesDetectionJobResponse$EntitiesDetectionJobProperties' => '<p>An object that contains the properties associated with an entities detection job.</p>', 'EntitiesDetectionJobPropertiesList$member' => NULL, ], ], 'EntitiesDetectionJobPropertiesList' => [ 'base' => NULL, 'refs' => [ 'ListEntitiesDetectionJobsResponse$EntitiesDetectionJobPropertiesList' => '<p>A list containing the properties of each job that is returned.</p>', ], ], 'Entity' => [ 'base' => '<p>Provides information about an entity. </p> <p> </p>', 'refs' => [ 'ListOfEntities$member' => NULL, ], ], 'EntityLabel' => [ 'base' => '<p>Specifies one of the label or labels that categorize the personally identifiable information (PII) entity being analyzed.</p>', 'refs' => [ 'ListOfEntityLabels$member' => NULL, ], ], 'EntityRecognitionConfig' => [ 'base' => '<p>Configuration required for an entity recognition model.</p>', 'refs' => [ 'TaskConfig$EntityRecognitionConfig' => '<p>Configuration required for an entity recognition model.</p>', ], ], 'EntityRecognizerAnnotations' => [ 'base' => '<p>Describes the annotations associated with a entity recognizer.</p>', 'refs' => [ 'EntityRecognizerInputDataConfig$Annotations' => '<p>The S3 location of the CSV file that annotates your training documents.</p>', ], ], 'EntityRecognizerArn' => [ 'base' => NULL, 'refs' => [ 'CreateEntityRecognizerResponse$EntityRecognizerArn' => '<p>The Amazon Resource Name (ARN) that identifies the entity recognizer.</p>', 'DeleteEntityRecognizerRequest$EntityRecognizerArn' => '<p>The Amazon Resource Name (ARN) that identifies the entity recognizer.</p>', 'DescribeEntityRecognizerRequest$EntityRecognizerArn' => '<p>The Amazon Resource Name (ARN) that identifies the entity recognizer.</p>', 'EntitiesDetectionJobProperties$EntityRecognizerArn' => '<p>The Amazon Resource Name (ARN) that identifies the entity recognizer.</p>', 'EntityRecognizerProperties$EntityRecognizerArn' => '<p>The Amazon Resource Name (ARN) that identifies the entity recognizer.</p>', 'EntityRecognizerProperties$SourceModelArn' => '<p>The Amazon Resource Name (ARN) of the source model. This model was imported from a different Amazon Web Services account to create the entity recognizer model in your Amazon Web Services account.</p>', 'StartEntitiesDetectionJobRequest$EntityRecognizerArn' => '<p>The Amazon Resource Name (ARN) that identifies the specific entity recognizer to be used by the <code>StartEntitiesDetectionJob</code>. This ARN is optional and is only used for a custom entity recognition job.</p>', 'StartEntitiesDetectionJobResponse$EntityRecognizerArn' => '<p>The ARN of the custom entity recognition model.</p>', 'StopTrainingEntityRecognizerRequest$EntityRecognizerArn' => '<p>The Amazon Resource Name (ARN) that identifies the entity recognizer currently being trained.</p>', ], ], 'EntityRecognizerAugmentedManifestsList' => [ 'base' => NULL, 'refs' => [ 'EntityRecognizerInputDataConfig$AugmentedManifests' => '<p>A list of augmented manifest files that provide training data for your custom model. An augmented manifest file is a labeled dataset that is produced by Amazon SageMaker Ground Truth.</p> <p>This parameter is required if you set <code>DataFormat</code> to <code>AUGMENTED_MANIFEST</code>.</p>', ], ], 'EntityRecognizerDataFormat' => [ 'base' => NULL, 'refs' => [ 'EntityRecognizerInputDataConfig$DataFormat' => '<p>The format of your training data:</p> <ul> <li> <p> <code>COMPREHEND_CSV</code>: A CSV file that supplements your training documents. The CSV file contains information about the custom entities that your trained model will detect. The required format of the file depends on whether you are providing annotations or an entity list.</p> <p>If you use this value, you must provide your CSV file by using either the <code>Annotations</code> or <code>EntityList</code> parameters. You must provide your training documents by using the <code>Documents</code> parameter.</p> </li> <li> <p> <code>AUGMENTED_MANIFEST</code>: A labeled dataset that is produced by Amazon SageMaker Ground Truth. This file is in JSON lines format. Each line is a complete JSON object that contains a training document and its labels. Each label annotates a named entity in the training document. </p> <p>If you use this value, you must provide the <code>AugmentedManifests</code> parameter in your request.</p> </li> </ul> <p>If you don\'t specify a value, Amazon Comprehend uses <code>COMPREHEND_CSV</code> as the default.</p>', ], ], 'EntityRecognizerDocuments' => [ 'base' => '<p>Describes the training documents submitted with an entity recognizer.</p>', 'refs' => [ 'EntityRecognizerInputDataConfig$Documents' => '<p>The S3 location of the folder that contains the training documents for your custom entity recognizer.</p> <p>This parameter is required if you set <code>DataFormat</code> to <code>COMPREHEND_CSV</code>.</p>', ], ], 'EntityRecognizerEndpointArn' => [ 'base' => NULL, 'refs' => [ 'DetectEntitiesRequest$EndpointArn' => '<p>The Amazon Resource Name of an endpoint that is associated with a custom entity recognition model. Provide an endpoint if you want to detect entities by using your own custom model instead of the default model that is used by Amazon Comprehend.</p> <p>If you specify an endpoint, Amazon Comprehend uses the language of your custom model, and it ignores any language code that you provide in your request.</p> <p>For information about endpoints, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html">Managing endpoints</a>.</p>', ], ], 'EntityRecognizerEntityList' => [ 'base' => '<p>Describes the entity list submitted with an entity recognizer.</p>', 'refs' => [ 'EntityRecognizerInputDataConfig$EntityList' => '<p>The S3 location of the CSV file that has the entity list for your custom entity recognizer.</p>', ], ], 'EntityRecognizerEvaluationMetrics' => [ 'base' => '<p>Detailed information about the accuracy of an entity recognizer. </p>', 'refs' => [ 'EntityRecognizerMetadata$EvaluationMetrics' => '<p>Detailed information about the accuracy of an entity recognizer.</p>', ], ], 'EntityRecognizerFilter' => [ 'base' => '<p>Provides information for filtering a list of entity recognizers. You can only specify one filtering parameter in a request. For more information, see the <code>ListEntityRecognizers</code> operation./&gt;</p>', 'refs' => [ 'ListEntityRecognizersRequest$Filter' => '<p>Filters the list of entities returned. You can filter on <code>Status</code>, <code>SubmitTimeBefore</code>, or <code>SubmitTimeAfter</code>. You can only set one filter at a time.</p>', ], ], 'EntityRecognizerInputDataConfig' => [ 'base' => '<p>Specifies the format and location of the input data.</p>', 'refs' => [ 'CreateEntityRecognizerRequest$InputDataConfig' => '<p>Specifies the format and location of the input data. The S3 bucket containing the input data must be located in the same Region as the entity recognizer being created. </p>', 'EntityRecognizerProperties$InputDataConfig' => '<p>The input data properties of an entity recognizer.</p>', ], ], 'EntityRecognizerMetadata' => [ 'base' => '<p>Detailed information about an entity recognizer.</p>', 'refs' => [ 'EntityRecognizerProperties$RecognizerMetadata' => '<p> Provides information about an entity recognizer.</p>', ], ], 'EntityRecognizerMetadataEntityTypesList' => [ 'base' => NULL, 'refs' => [ 'EntityRecognizerMetadata$EntityTypes' => '<p>Entity types from the metadata of an entity recognizer.</p>', ], ], 'EntityRecognizerMetadataEntityTypesListItem' => [ 'base' => '<p>Individual item from the list of entity types in the metadata of an entity recognizer.</p>', 'refs' => [ 'EntityRecognizerMetadataEntityTypesList$member' => NULL, ], ], 'EntityRecognizerOutputDataConfig' => [ 'base' => '<p>Output data configuration.</p>', 'refs' => [ 'EntityRecognizerProperties$OutputDataConfig' => '<p>Output data configuration.</p>', ], ], 'EntityRecognizerProperties' => [ 'base' => '<p>Describes information about an entity recognizer.</p>', 'refs' => [ 'DescribeEntityRecognizerResponse$EntityRecognizerProperties' => '<p>Describes information associated with an entity recognizer.</p>', 'EntityRecognizerPropertiesList$member' => NULL, ], ], 'EntityRecognizerPropertiesList' => [ 'base' => NULL, 'refs' => [ 'ListEntityRecognizersResponse$EntityRecognizerPropertiesList' => '<p>The list of properties of an entity recognizer.</p>', ], ], 'EntityRecognizerSummariesList' => [ 'base' => NULL, 'refs' => [ 'ListEntityRecognizerSummariesResponse$EntityRecognizerSummariesList' => '<p>The list entity recognizer summaries.</p>', ], ], 'EntityRecognizerSummary' => [ 'base' => '<p> Describes the information about an entity recognizer and its versions.</p>', 'refs' => [ 'EntityRecognizerSummariesList$member' => NULL, ], ], 'EntityType' => [ 'base' => NULL, 'refs' => [ 'Entity$Type' => '<p>The entity type. For entity detection using the built-in model, this field contains one of the standard entity types listed below.</p> <p>For custom entity detection, this field contains one of the entity types that you specified when you trained your custom model.</p>', ], ], 'EntityTypeName' => [ 'base' => NULL, 'refs' => [ 'EntityTypesListItem$Type' => '<p>An entity type within a labeled training dataset that Amazon Comprehend uses to train a custom entity recognizer.</p> <p>Entity types must not contain the following invalid characters: \\n (line break), \\\\n (escaped line break, \\r (carriage return), \\\\r (escaped carriage return), \\t (tab), \\\\t (escaped tab), and , (comma).</p>', ], ], 'EntityTypesEvaluationMetrics' => [ 'base' => '<p>Detailed information about the accuracy of an entity recognizer for a specific entity type. </p>', 'refs' => [ 'EntityRecognizerMetadataEntityTypesListItem$EvaluationMetrics' => '<p>Detailed information about the accuracy of the entity recognizer for a specific item on the list of entity types. </p>', ], ], 'EntityTypesList' => [ 'base' => NULL, 'refs' => [ 'EntityRecognitionConfig$EntityTypes' => '<p>Up to 25 entity types that the model is trained to recognize.</p>', 'EntityRecognizerInputDataConfig$EntityTypes' => '<p>The entity types in the labeled training data that Amazon Comprehend uses to train the custom entity recognizer. Any entity types that you don\'t specify are ignored.</p> <p>A maximum of 25 entity types can be used at one time to train an entity recognizer. Entity types must not contain the following invalid characters: \\n (line break), \\\\n (escaped line break), \\r (carriage return), \\\\r (escaped carriage return), \\t (tab), \\\\t (escaped tab), space, and , (comma). </p>', ], ], 'EntityTypesListItem' => [ 'base' => '<p>An entity type within a labeled training dataset that Amazon Comprehend uses to train a custom entity recognizer.</p>', 'refs' => [ 'EntityTypesList$member' => NULL, ], ], 'ErrorsListItem' => [ 'base' => '<p>Text extraction encountered one or more page-level errors in the input document.</p> <p>The <code>ErrorCode</code> contains one of the following values:</p> <ul> <li> <p>TEXTRACT_BAD_PAGE - Amazon Textract cannot read the page. For more information about page limits in Amazon Textract, see <a href="https://docs.aws.amazon.com/textract/latest/dg/limits-document.html"> Page Quotas in Amazon Textract</a>.</p> </li> <li> <p>TEXTRACT_PROVISIONED_THROUGHPUT_EXCEEDED - The number of requests exceeded your throughput limit. For more information about throughput quotas in Amazon Textract, see <a href="https://docs.aws.amazon.com/textract/latest/dg/limits-quotas-explained.html"> Default quotas in Amazon Textract</a>.</p> </li> <li> <p>PAGE_CHARACTERS_EXCEEDED - Too many text characters on the page (10,000 characters maximum).</p> </li> <li> <p>PAGE_SIZE_EXCEEDED - The maximum page size is 10 MB.</p> </li> <li> <p>INTERNAL_SERVER_ERROR - The request encountered a service issue. Try the API request again.</p> </li> </ul>', 'refs' => [ 'ListOfErrors$member' => NULL, ], ], 'EventTypeString' => [ 'base' => NULL, 'refs' => [ 'TargetEventTypes$member' => NULL, ], ], 'EventsDetectionJobFilter' => [ 'base' => '<p>Provides information for filtering a list of event detection jobs.</p>', 'refs' => [ 'ListEventsDetectionJobsRequest$Filter' => '<p>Filters the jobs that are returned. You can filter jobs on their name, status, or the date and time that they were submitted. You can only set one filter at a time.</p>', ], ], 'EventsDetectionJobProperties' => [ 'base' => '<p>Provides information about an events detection job.</p>', 'refs' => [ 'DescribeEventsDetectionJobResponse$EventsDetectionJobProperties' => '<p>An object that contains the properties associated with an event detection job.</p>', 'EventsDetectionJobPropertiesList$member' => NULL, ], ], 'EventsDetectionJobPropertiesList' => [ 'base' => NULL, 'refs' => [ 'ListEventsDetectionJobsResponse$EventsDetectionJobPropertiesList' => '<p>A list containing the properties of each job that is returned.</p>', ], ], 'ExtractedCharactersListItem' => [ 'base' => '<p>Array of the number of characters extracted from each page.</p>', 'refs' => [ 'ListOfExtractedCharacters$member' => NULL, ], ], 'Float' => [ 'base' => NULL, 'refs' => [ 'BoundingBox$Height' => '<p>The height of the bounding box as a ratio of the overall document page height.</p>', 'BoundingBox$Left' => '<p>The left coordinate of the bounding box as a ratio of overall document page width.</p>', 'BoundingBox$Top' => '<p>The top coordinate of the bounding box as a ratio of overall document page height.</p>', 'BoundingBox$Width' => '<p>The width of the bounding box as a ratio of the overall document page width.</p>', 'DocumentClass$Score' => '<p>The confidence score that Amazon Comprehend has this class correctly attributed.</p>', 'DocumentLabel$Score' => '<p>The confidence score that Amazon Comprehend has this label correctly attributed.</p>', 'DominantLanguage$Score' => '<p>The level of confidence that Amazon Comprehend has in the accuracy of the detection.</p>', 'Entity$Score' => '<p>The level of confidence that Amazon Comprehend has in the accuracy of the detection.</p>', 'EntityLabel$Score' => '<p>The level of confidence that Amazon Comprehend has in the accuracy of the detection.</p>', 'KeyPhrase$Score' => '<p>The level of confidence that Amazon Comprehend has in the accuracy of the detection.</p>', 'PartOfSpeechTag$Score' => '<p>The confidence that Amazon Comprehend has that the part of speech was correctly identified.</p>', 'PiiEntity$Score' => '<p>The level of confidence that Amazon Comprehend has in the accuracy of the detection.</p>', 'Point$X' => '<p>The value of the X coordinate for a point on a polygon</p>', 'Point$Y' => '<p>The value of the Y coordinate for a point on a polygon</p>', 'SentimentScore$Positive' => '<p>The level of confidence that Amazon Comprehend has in the accuracy of its detection of the <code>POSITIVE</code> sentiment.</p>', 'SentimentScore$Negative' => '<p>The level of confidence that Amazon Comprehend has in the accuracy of its detection of the <code>NEGATIVE</code> sentiment.</p>', 'SentimentScore$Neutral' => '<p>The level of confidence that Amazon Comprehend has in the accuracy of its detection of the <code>NEUTRAL</code> sentiment.</p>', 'SentimentScore$Mixed' => '<p>The level of confidence that Amazon Comprehend has in the accuracy of its detection of the <code>MIXED</code> sentiment.</p>', 'TargetedSentimentMention$Score' => '<p>Model confidence that the entity is relevant. Value range is zero to one, where one is highest confidence.</p>', 'TargetedSentimentMention$GroupScore' => '<p>The confidence that all the entities mentioned in the group relate to the same entity.</p>', 'ToxicContent$Score' => '<p> Model confidence in the detected content type. Value range is zero to one, where one is highest confidence.</p>', 'ToxicLabels$Toxicity' => '<p>Overall toxicity score for the string. Value range is zero to one, where one is the highest confidence.</p>', ], ], 'FlywheelFilter' => [ 'base' => '<p>Filter the flywheels based on creation time or flywheel status.</p>', 'refs' => [ 'ListFlywheelsRequest$Filter' => '<p>Filters the flywheels that are returned. You can filter flywheels on their status, or the date and time that they were submitted. You can only set one filter at a time. </p>', ], ], 'FlywheelIterationFilter' => [ 'base' => '<p>Filter the flywheel iterations based on creation time.</p>', 'refs' => [ 'ListFlywheelIterationHistoryRequest$Filter' => '<p>Filter the flywheel iteration history based on creation time.</p>', ], ], 'FlywheelIterationId' => [ 'base' => NULL, 'refs' => [ 'DescribeFlywheelIterationRequest$FlywheelIterationId' => '<p/>', 'FlywheelIterationProperties$FlywheelIterationId' => '<p/>', 'FlywheelProperties$LatestFlywheelIteration' => '<p>The most recent flywheel iteration.</p>', 'FlywheelSummary$LatestFlywheelIteration' => '<p>The most recent flywheel iteration.</p>', 'StartFlywheelIterationResponse$FlywheelIterationId' => '<p/>', ], ], 'FlywheelIterationProperties' => [ 'base' => '<p>The configuration properties of a flywheel iteration.</p>', 'refs' => [ 'DescribeFlywheelIterationResponse$FlywheelIterationProperties' => '<p>The configuration properties of a flywheel iteration.</p>', 'FlywheelIterationPropertiesList$member' => NULL, ], ], 'FlywheelIterationPropertiesList' => [ 'base' => NULL, 'refs' => [ 'ListFlywheelIterationHistoryResponse$FlywheelIterationPropertiesList' => '<p>List of flywheel iteration properties</p>', ], ], 'FlywheelIterationStatus' => [ 'base' => NULL, 'refs' => [ 'FlywheelIterationProperties$Status' => '<p>The status of the flywheel iteration.</p>', ], ], 'FlywheelModelEvaluationMetrics' => [ 'base' => '<p>The evaluation metrics associated with the evaluated model.</p>', 'refs' => [ 'FlywheelIterationProperties$EvaluatedModelMetrics' => NULL, 'FlywheelIterationProperties$TrainedModelMetrics' => '<p>The metrics associated with the trained model.</p>', ], ], 'FlywheelProperties' => [ 'base' => '<p>The flywheel properties.</p>', 'refs' => [ 'DescribeFlywheelResponse$FlywheelProperties' => '<p>The flywheel properties.</p>', 'UpdateFlywheelResponse$FlywheelProperties' => '<p>The flywheel properties.</p>', ], ], 'FlywheelS3Uri' => [ 'base' => NULL, 'refs' => [ 'CreateFlywheelRequest$DataLakeS3Uri' => '<p>Enter the S3 location for the data lake. You can specify a new S3 bucket or a new folder of an existing S3 bucket. The flywheel creates the data lake at this location.</p>', ], ], 'FlywheelStatus' => [ 'base' => NULL, 'refs' => [ 'FlywheelFilter$Status' => '<p>Filter the flywheels based on the flywheel status.</p>', 'FlywheelProperties$Status' => '<p>The status of the flywheel.</p>', 'FlywheelSummary$Status' => '<p>The status of the flywheel.</p>', ], ], 'FlywheelSummary' => [ 'base' => '<p>Flywheel summary information.</p>', 'refs' => [ 'FlywheelSummaryList$member' => NULL, ], ], 'FlywheelSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListFlywheelsResponse$FlywheelSummaryList' => '<p>A list of flywheel properties retrieved by the service in response to the request. </p>', ], ], 'Geometry' => [ 'base' => '<p>Information about the location of items on a document page.</p> <p>For additional information, see <a href="https://docs.aws.amazon.com/textract/latest/dg/API_Geometry.html">Geometry</a> in the Amazon Textract API reference.</p>', 'refs' => [ 'Block$Geometry' => '<p>Co-ordinates of the rectangle or polygon that contains the text.</p>', ], ], 'IamRoleArn' => [ 'base' => NULL, 'refs' => [ 'CreateDocumentClassifierRequest$DataAccessRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend read access to your input data.</p>', 'CreateEndpointRequest$DataAccessRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend read access to trained custom models encrypted with a customer managed key (ModelKmsKeyId).</p>', 'CreateEntityRecognizerRequest$DataAccessRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend read access to your input data.</p>', 'CreateFlywheelRequest$DataAccessRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend the permissions required to access the flywheel data in the data lake.</p>', 'DocumentClassificationJobProperties$DataAccessRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend read access to your input data.</p>', 'DocumentClassifierProperties$DataAccessRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend read access to your input data.</p>', 'DominantLanguageDetectionJobProperties$DataAccessRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend read access to your input data.</p>', 'EndpointProperties$DataAccessRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend read access to trained custom models encrypted with a customer managed key (ModelKmsKeyId).</p>', 'EndpointProperties$DesiredDataAccessRoleArn' => '<p>Data access role ARN to use in case the new model is encrypted with a customer KMS key.</p>', 'EntitiesDetectionJobProperties$DataAccessRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend read access to your input data.</p>', 'EntityRecognizerProperties$DataAccessRoleArn' => '<p> The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend read access to your input data.</p>', 'EventsDetectionJobProperties$DataAccessRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend read access to your input data.</p>', 'FlywheelProperties$DataAccessRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend permission to access the flywheel data.</p>', 'ImportModelRequest$DataAccessRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend permission to use Amazon Key Management Service (KMS) to encrypt or decrypt the custom model.</p>', 'KeyPhrasesDetectionJobProperties$DataAccessRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend read access to your input data.</p>', 'PiiEntitiesDetectionJobProperties$DataAccessRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend read access to your input data.</p>', 'SentimentDetectionJobProperties$DataAccessRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend read access to your input data.</p>', 'StartDocumentClassificationJobRequest$DataAccessRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend read access to your input data.</p>', 'StartDominantLanguageDetectionJobRequest$DataAccessRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend read access to your input data. For more information, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/security_iam_id-based-policy-examples.html#auth-role-permissions">Role-based permissions</a>.</p>', 'StartEntitiesDetectionJobRequest$DataAccessRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend read access to your input data. For more information, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/security_iam_id-based-policy-examples.html#auth-role-permissions">Role-based permissions</a>.</p>', 'StartEventsDetectionJobRequest$DataAccessRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend read access to your input data.</p>', 'StartKeyPhrasesDetectionJobRequest$DataAccessRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend read access to your input data. For more information, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/security_iam_id-based-policy-examples.html#auth-role-permissions">Role-based permissions</a>.</p>', 'StartPiiEntitiesDetectionJobRequest$DataAccessRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend read access to your input data.</p>', 'StartSentimentDetectionJobRequest$DataAccessRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend read access to your input data. For more information, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/security_iam_id-based-policy-examples.html#auth-role-permissions">Role-based permissions</a>.</p>', 'StartTargetedSentimentDetectionJobRequest$DataAccessRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend read access to your input data. For more information, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/security_iam_id-based-policy-examples.html#auth-role-permissions">Role-based permissions</a>.</p>', 'StartTopicsDetectionJobRequest$DataAccessRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend read access to your input data. For more information, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/security_iam_id-based-policy-examples.html#auth-role-permissions">Role-based permissions</a>.</p>', 'TargetedSentimentDetectionJobProperties$DataAccessRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend read access to your input data.</p>', 'TopicsDetectionJobProperties$DataAccessRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend read access to your job data. </p>', 'UpdateEndpointRequest$DesiredDataAccessRoleArn' => '<p>Data access role ARN to use in case the new model is encrypted with a customer CMK.</p>', 'UpdateFlywheelRequest$DataAccessRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend permission to access the flywheel data.</p>', ], ], 'ImportModelRequest' => [ 'base' => NULL, 'refs' => [], ], 'ImportModelResponse' => [ 'base' => NULL, 'refs' => [], ], 'InferenceUnitsInteger' => [ 'base' => NULL, 'refs' => [ 'CreateEndpointRequest$DesiredInferenceUnits' => '<p> The desired number of inference units to be used by the model using this endpoint. Each inference unit represents of a throughput of 100 characters per second.</p>', 'EndpointProperties$DesiredInferenceUnits' => '<p>The desired number of inference units to be used by the model using this endpoint. Each inference unit represents of a throughput of 100 characters per second.</p>', 'EndpointProperties$CurrentInferenceUnits' => '<p>The number of inference units currently used by the model using this endpoint.</p>', 'UpdateEndpointRequest$DesiredInferenceUnits' => '<p> The desired number of inference units to be used by the model using this endpoint. Each inference unit represents of a throughput of 100 characters per second.</p>', ], ], 'InputDataConfig' => [ 'base' => '<p>The input properties for an inference job. The document reader config field applies only to non-text inputs for custom analysis.</p>', 'refs' => [ 'DocumentClassificationJobProperties$InputDataConfig' => '<p>The input data configuration that you supplied when you created the document classification job.</p>', 'DominantLanguageDetectionJobProperties$InputDataConfig' => '<p>The input data configuration that you supplied when you created the dominant language detection job.</p>', 'EntitiesDetectionJobProperties$InputDataConfig' => '<p>The input data configuration that you supplied when you created the entities detection job.</p>', 'EventsDetectionJobProperties$InputDataConfig' => '<p>The input data configuration that you supplied when you created the events detection job.</p>', 'KeyPhrasesDetectionJobProperties$InputDataConfig' => '<p>The input data configuration that you supplied when you created the key phrases detection job.</p>', 'PiiEntitiesDetectionJobProperties$InputDataConfig' => '<p>The input properties for a PII entities detection job.</p>', 'SentimentDetectionJobProperties$InputDataConfig' => '<p>The input data configuration that you supplied when you created the sentiment detection job.</p>', 'StartDocumentClassificationJobRequest$InputDataConfig' => '<p>Specifies the format and location of the input data for the job.</p>', 'StartDominantLanguageDetectionJobRequest$InputDataConfig' => '<p>Specifies the format and location of the input data for the job.</p>', 'StartEntitiesDetectionJobRequest$InputDataConfig' => '<p>Specifies the format and location of the input data for the job.</p>', 'StartEventsDetectionJobRequest$InputDataConfig' => '<p>Specifies the format and location of the input data for the job.</p>', 'StartKeyPhrasesDetectionJobRequest$InputDataConfig' => '<p>Specifies the format and location of the input data for the job.</p>', 'StartPiiEntitiesDetectionJobRequest$InputDataConfig' => '<p>The input properties for a PII entities detection job.</p>', 'StartSentimentDetectionJobRequest$InputDataConfig' => '<p>Specifies the format and location of the input data for the job.</p>', 'StartTargetedSentimentDetectionJobRequest$InputDataConfig' => NULL, 'StartTopicsDetectionJobRequest$InputDataConfig' => '<p>Specifies the format and location of the input data for the job.</p>', 'TargetedSentimentDetectionJobProperties$InputDataConfig' => NULL, 'TopicsDetectionJobProperties$InputDataConfig' => '<p>The input data configuration supplied when you created the topic detection job.</p>', ], ], 'InputFormat' => [ 'base' => NULL, 'refs' => [ 'DatasetEntityRecognizerDocuments$InputFormat' => '<p> Specifies how the text in an input file should be processed. This is optional, and the default is ONE_DOC_PER_LINE. ONE_DOC_PER_FILE - Each file is considered a separate document. Use this option when you are processing large documents, such as newspaper articles or scientific papers. ONE_DOC_PER_LINE - Each line in a file is considered a separate document. Use this option when you are processing many short documents, such as text messages.</p>', 'EntityRecognizerDocuments$InputFormat' => '<p> Specifies how the text in an input file should be processed. This is optional, and the default is ONE_DOC_PER_LINE. ONE_DOC_PER_FILE - Each file is considered a separate document. Use this option when you are processing large documents, such as newspaper articles or scientific papers. ONE_DOC_PER_LINE - Each line in a file is considered a separate document. Use this option when you are processing many short documents, such as text messages.</p>', 'InputDataConfig$InputFormat' => '<p>Specifies how the text in an input file should be processed:</p> <ul> <li> <p> <code>ONE_DOC_PER_FILE</code> - Each file is considered a separate document. Use this option when you are processing large documents, such as newspaper articles or scientific papers.</p> </li> <li> <p> <code>ONE_DOC_PER_LINE</code> - Each line in a file is considered a separate document. Use this option when you are processing many short documents, such as text messages.</p> </li> </ul>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'BatchDetectDominantLanguageItemResult$Index' => '<p>The zero-based index of the document in the input list.</p>', 'BatchDetectEntitiesItemResult$Index' => '<p>The zero-based index of the document in the input list.</p>', 'BatchDetectKeyPhrasesItemResult$Index' => '<p>The zero-based index of the document in the input list.</p>', 'BatchDetectSentimentItemResult$Index' => '<p>The zero-based index of the document in the input list.</p>', 'BatchDetectSyntaxItemResult$Index' => '<p>The zero-based index of the document in the input list.</p>', 'BatchDetectTargetedSentimentItemResult$Index' => '<p>The zero-based index of this result in the input list.</p>', 'BatchItemError$Index' => '<p>The zero-based index of the document in the input list.</p>', 'Block$Page' => '<p>Page number where the block appears.</p>', 'BlockReference$BeginOffset' => '<p>Offset of the start of the block within its parent block.</p>', 'BlockReference$EndOffset' => '<p>Offset of the end of the block within its parent block.</p>', 'ChildBlock$BeginOffset' => '<p>Offset of the start of the child block within its parent block.</p>', 'ChildBlock$EndOffset' => '<p>Offset of the end of the child block within its parent block.</p>', 'ClassifierMetadata$NumberOfLabels' => '<p>The number of labels in the input data. </p>', 'ClassifierMetadata$NumberOfTrainedDocuments' => '<p>The number of documents in the input data that were used to train the classifier. Typically this is 80 to 90 percent of the input documents.</p>', 'ClassifierMetadata$NumberOfTestDocuments' => '<p>The number of documents in the input data that were used to test the classifier. Typically this is 10 to 20 percent of the input documents, up to 10,000 documents.</p>', 'DocumentClass$Page' => '<p>Page number in the input document. This field is present in the response only if your request includes the <code>Byte</code> parameter. </p>', 'DocumentClassifierSummary$NumberOfVersions' => '<p>The number of versions you created.</p>', 'DocumentLabel$Page' => '<p>Page number where the label occurs. This field is present in the response only if your request includes the <code>Byte</code> parameter. </p>', 'DocumentMetadata$Pages' => '<p>Number of pages in the document.</p>', 'DocumentTypeListItem$Page' => '<p>Page number.</p>', 'Entity$BeginOffset' => '<p>The zero-based offset from the beginning of the source text to the first character in the entity.</p> <p>This field is empty for non-text input.</p>', 'Entity$EndOffset' => '<p>The zero-based offset from the beginning of the source text to the last character in the entity.</p> <p>This field is empty for non-text input.</p>', 'EntityRecognizerMetadata$NumberOfTrainedDocuments' => '<p> The number of documents in the input data that were used to train the entity recognizer. Typically this is 80 to 90 percent of the input documents.</p>', 'EntityRecognizerMetadata$NumberOfTestDocuments' => '<p> The number of documents in the input data that were used to test the entity recognizer. Typically this is 10 to 20 percent of the input documents.</p>', 'EntityRecognizerMetadataEntityTypesListItem$NumberOfTrainMentions' => '<p>Indicates the number of times the given entity type was seen in the training data. </p>', 'EntityRecognizerSummary$NumberOfVersions' => '<p> The number of versions you created.</p>', 'ErrorsListItem$Page' => '<p>Page number where the error occurred.</p>', 'ExtractedCharactersListItem$Page' => '<p>Page number.</p>', 'ExtractedCharactersListItem$Count' => '<p>Number of characters extracted from each page.</p>', 'KeyPhrase$BeginOffset' => '<p>The zero-based offset from the beginning of the source text to the first character in the key phrase.</p>', 'KeyPhrase$EndOffset' => '<p>The zero-based offset from the beginning of the source text to the last character in the key phrase.</p>', 'ListOfDescriptiveMentionIndices$member' => NULL, 'PiiEntity$BeginOffset' => '<p>The zero-based offset from the beginning of the source text to the first character in the entity.</p>', 'PiiEntity$EndOffset' => '<p>The zero-based offset from the beginning of the source text to the last character in the entity.</p>', 'SyntaxToken$TokenId' => '<p>A unique identifier for a token.</p>', 'SyntaxToken$BeginOffset' => '<p>The zero-based offset from the beginning of the source text to the first character in the word.</p>', 'SyntaxToken$EndOffset' => '<p>The zero-based offset from the beginning of the source text to the last character in the word.</p>', 'TargetedSentimentMention$BeginOffset' => '<p>The offset into the document text where the mention begins.</p>', 'TargetedSentimentMention$EndOffset' => '<p>The offset into the document text where the mention ends.</p>', 'TopicsDetectionJobProperties$NumberOfTopics' => '<p>The number of topics to detect supplied when you created the topic detection job. The default is 10. </p>', 'WarningsListItem$Page' => '<p>Page number in the input document.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>An internal server error occurred. Retry your request.</p>', 'refs' => [], ], 'InvalidFilterException' => [ 'base' => '<p>The filter specified for the operation is invalid. Specify a different filter.</p>', 'refs' => [], ], 'InvalidRequestDetail' => [ 'base' => '<p>Provides additional detail about why the request failed.</p>', 'refs' => [ 'InvalidRequestException$Detail' => NULL, ], ], 'InvalidRequestDetailReason' => [ 'base' => NULL, 'refs' => [ 'InvalidRequestDetail$Reason' => '<p>Reason codes include the following values:</p> <ul> <li> <p>DOCUMENT_SIZE_EXCEEDED - Document size is too large. Check the size of your file and resubmit the request.</p> </li> <li> <p>UNSUPPORTED_DOC_TYPE - Document type is not supported. Check the file type and resubmit the request.</p> </li> <li> <p>PAGE_LIMIT_EXCEEDED - Too many pages in the document. Check the number of pages in your file and resubmit the request.</p> </li> <li> <p>TEXTRACT_ACCESS_DENIED - Access denied to Amazon Textract. Verify that your account has permission to use Amazon Textract API operations and resubmit the request.</p> </li> <li> <p>NOT_TEXTRACT_JSON - Document is not Amazon Textract JSON format. Verify the format and resubmit the request.</p> </li> <li> <p>MISMATCHED_TOTAL_PAGE_COUNT - Check the number of pages in your file and resubmit the request.</p> </li> <li> <p>INVALID_DOCUMENT - Invalid document. Check the file and resubmit the request.</p> </li> </ul>', ], ], 'InvalidRequestException' => [ 'base' => '<p>The request is invalid.</p>', 'refs' => [], ], 'InvalidRequestReason' => [ 'base' => NULL, 'refs' => [ 'InvalidRequestException$Reason' => NULL, ], ], 'JobId' => [ 'base' => NULL, 'refs' => [ 'DescribeDocumentClassificationJobRequest$JobId' => '<p>The identifier that Amazon Comprehend generated for the job. The <code>StartDocumentClassificationJob</code> operation returns this identifier in its response.</p>', 'DescribeDominantLanguageDetectionJobRequest$JobId' => '<p>The identifier that Amazon Comprehend generated for the job. The <code>StartDominantLanguageDetectionJob</code> operation returns this identifier in its response.</p>', 'DescribeEntitiesDetectionJobRequest$JobId' => '<p>The identifier that Amazon Comprehend generated for the job. The <code>StartEntitiesDetectionJob</code> operation returns this identifier in its response.</p>', 'DescribeEventsDetectionJobRequest$JobId' => '<p>The identifier of the events detection job.</p>', 'DescribeKeyPhrasesDetectionJobRequest$JobId' => '<p>The identifier that Amazon Comprehend generated for the job. The <code>StartKeyPhrasesDetectionJob</code> operation returns this identifier in its response.</p>', 'DescribePiiEntitiesDetectionJobRequest$JobId' => '<p>The identifier that Amazon Comprehend generated for the job. The operation returns this identifier in its response.</p>', 'DescribeSentimentDetectionJobRequest$JobId' => '<p>The identifier that Amazon Comprehend generated for the job. The operation returns this identifier in its response.</p>', 'DescribeTargetedSentimentDetectionJobRequest$JobId' => '<p>The identifier that Amazon Comprehend generated for the job. The <code>StartTargetedSentimentDetectionJob</code> operation returns this identifier in its response.</p>', 'DescribeTopicsDetectionJobRequest$JobId' => '<p>The identifier assigned by the user to the detection job.</p>', 'DocumentClassificationJobProperties$JobId' => '<p>The identifier assigned to the document classification job.</p>', 'DominantLanguageDetectionJobProperties$JobId' => '<p>The identifier assigned to the dominant language detection job.</p>', 'EntitiesDetectionJobProperties$JobId' => '<p>The identifier assigned to the entities detection job.</p>', 'EventsDetectionJobProperties$JobId' => '<p>The identifier assigned to the events detection job.</p>', 'KeyPhrasesDetectionJobProperties$JobId' => '<p>The identifier assigned to the key phrases detection job.</p>', 'PiiEntitiesDetectionJobProperties$JobId' => '<p>The identifier assigned to the PII entities detection job.</p>', 'SentimentDetectionJobProperties$JobId' => '<p>The identifier assigned to the sentiment detection job.</p>', 'StartDocumentClassificationJobResponse$JobId' => '<p>The identifier generated for the job. To get the status of the job, use this identifier with the <code>DescribeDocumentClassificationJob</code> operation.</p>', 'StartDominantLanguageDetectionJobResponse$JobId' => '<p>The identifier generated for the job. To get the status of a job, use this identifier with the operation.</p>', 'StartEntitiesDetectionJobResponse$JobId' => '<p>The identifier generated for the job. To get the status of job, use this identifier with the operation.</p>', 'StartEventsDetectionJobResponse$JobId' => '<p>An unique identifier for the request. If you don\'t set the client request token, Amazon Comprehend generates one.</p>', 'StartKeyPhrasesDetectionJobResponse$JobId' => '<p>The identifier generated for the job. To get the status of a job, use this identifier with the operation.</p>', 'StartPiiEntitiesDetectionJobResponse$JobId' => '<p>The identifier generated for the job.</p>', 'StartSentimentDetectionJobResponse$JobId' => '<p>The identifier generated for the job. To get the status of a job, use this identifier with the operation.</p>', 'StartTargetedSentimentDetectionJobResponse$JobId' => '<p>The identifier generated for the job. To get the status of a job, use this identifier with the <code>DescribeTargetedSentimentDetectionJob</code> operation.</p>', 'StartTopicsDetectionJobResponse$JobId' => '<p>The identifier generated for the job. To get the status of the job, use this identifier with the <code>DescribeTopicDetectionJob</code> operation.</p>', 'StopDominantLanguageDetectionJobRequest$JobId' => '<p>The identifier of the dominant language detection job to stop.</p>', 'StopDominantLanguageDetectionJobResponse$JobId' => '<p>The identifier of the dominant language detection job to stop.</p>', 'StopEntitiesDetectionJobRequest$JobId' => '<p>The identifier of the entities detection job to stop.</p>', 'StopEntitiesDetectionJobResponse$JobId' => '<p>The identifier of the entities detection job to stop.</p>', 'StopEventsDetectionJobRequest$JobId' => '<p>The identifier of the events detection job to stop.</p>', 'StopEventsDetectionJobResponse$JobId' => '<p>The identifier of the events detection job to stop.</p>', 'StopKeyPhrasesDetectionJobRequest$JobId' => '<p>The identifier of the key phrases detection job to stop.</p>', 'StopKeyPhrasesDetectionJobResponse$JobId' => '<p>The identifier of the key phrases detection job to stop.</p>', 'StopPiiEntitiesDetectionJobRequest$JobId' => '<p>The identifier of the PII entities detection job to stop.</p>', 'StopPiiEntitiesDetectionJobResponse$JobId' => '<p>The identifier of the PII entities detection job to stop.</p>', 'StopSentimentDetectionJobRequest$JobId' => '<p>The identifier of the sentiment detection job to stop.</p>', 'StopSentimentDetectionJobResponse$JobId' => '<p>The identifier of the sentiment detection job to stop.</p>', 'StopTargetedSentimentDetectionJobRequest$JobId' => '<p>The identifier of the targeted sentiment detection job to stop.</p>', 'StopTargetedSentimentDetectionJobResponse$JobId' => '<p>The identifier of the targeted sentiment detection job to stop.</p>', 'TargetedSentimentDetectionJobProperties$JobId' => '<p>The identifier assigned to the targeted sentiment detection job.</p>', 'TopicsDetectionJobProperties$JobId' => '<p>The identifier assigned to the topic detection job.</p>', ], ], 'JobName' => [ 'base' => NULL, 'refs' => [ 'DocumentClassificationJobFilter$JobName' => '<p>Filters on the name of the job.</p>', 'DocumentClassificationJobProperties$JobName' => '<p>The name that you assigned to the document classification job.</p>', 'DominantLanguageDetectionJobFilter$JobName' => '<p>Filters on the name of the job.</p>', 'DominantLanguageDetectionJobProperties$JobName' => '<p>The name that you assigned to the dominant language detection job.</p>', 'EntitiesDetectionJobFilter$JobName' => '<p>Filters on the name of the job.</p>', 'EntitiesDetectionJobProperties$JobName' => '<p>The name that you assigned the entities detection job.</p>', 'EventsDetectionJobFilter$JobName' => '<p>Filters on the name of the events detection job.</p>', 'EventsDetectionJobProperties$JobName' => '<p>The name you assigned the events detection job.</p>', 'KeyPhrasesDetectionJobFilter$JobName' => '<p>Filters on the name of the job.</p>', 'KeyPhrasesDetectionJobProperties$JobName' => '<p>The name that you assigned the key phrases detection job.</p>', 'PiiEntitiesDetectionJobFilter$JobName' => '<p>Filters on the name of the job.</p>', 'PiiEntitiesDetectionJobProperties$JobName' => '<p>The name that you assigned the PII entities detection job.</p>', 'SentimentDetectionJobFilter$JobName' => '<p>Filters on the name of the job.</p>', 'SentimentDetectionJobProperties$JobName' => '<p>The name that you assigned to the sentiment detection job</p>', 'StartDocumentClassificationJobRequest$JobName' => '<p>The identifier of the job.</p>', 'StartDominantLanguageDetectionJobRequest$JobName' => '<p>An identifier for the job.</p>', 'StartEntitiesDetectionJobRequest$JobName' => '<p>The identifier of the job.</p>', 'StartEventsDetectionJobRequest$JobName' => '<p>The identifier of the events detection job.</p>', 'StartKeyPhrasesDetectionJobRequest$JobName' => '<p>The identifier of the job.</p>', 'StartPiiEntitiesDetectionJobRequest$JobName' => '<p>The identifier of the job.</p>', 'StartSentimentDetectionJobRequest$JobName' => '<p>The identifier of the job.</p>', 'StartTargetedSentimentDetectionJobRequest$JobName' => '<p>The identifier of the job.</p>', 'StartTopicsDetectionJobRequest$JobName' => '<p>The identifier of the job.</p>', 'TargetedSentimentDetectionJobFilter$JobName' => '<p>Filters on the name of the job.</p>', 'TargetedSentimentDetectionJobProperties$JobName' => '<p>The name that you assigned to the targeted sentiment detection job.</p>', 'TopicsDetectionJobFilter$JobName' => '<p/>', 'TopicsDetectionJobProperties$JobName' => '<p>The name of the topic detection job.</p>', ], ], 'JobNotFoundException' => [ 'base' => '<p>The specified job was not found. Check the job ID and try again.</p>', 'refs' => [], ], 'JobStatus' => [ 'base' => NULL, 'refs' => [ 'DocumentClassificationJobFilter$JobStatus' => '<p>Filters the list based on job status. Returns only jobs with the specified status.</p>', 'DocumentClassificationJobProperties$JobStatus' => '<p>The current status of the document classification job. If the status is <code>FAILED</code>, the <code>Message</code> field shows the reason for the failure.</p>', 'DominantLanguageDetectionJobFilter$JobStatus' => '<p>Filters the list of jobs based on job status. Returns only jobs with the specified status.</p>', 'DominantLanguageDetectionJobProperties$JobStatus' => '<p>The current status of the dominant language detection job. If the status is <code>FAILED</code>, the <code>Message</code> field shows the reason for the failure.</p>', 'EntitiesDetectionJobFilter$JobStatus' => '<p>Filters the list of jobs based on job status. Returns only jobs with the specified status.</p>', 'EntitiesDetectionJobProperties$JobStatus' => '<p>The current status of the entities detection job. If the status is <code>FAILED</code>, the <code>Message</code> field shows the reason for the failure.</p>', 'EventsDetectionJobFilter$JobStatus' => '<p>Filters the list of jobs based on job status. Returns only jobs with the specified status.</p>', 'EventsDetectionJobProperties$JobStatus' => '<p>The current status of the events detection job.</p>', 'KeyPhrasesDetectionJobFilter$JobStatus' => '<p>Filters the list of jobs based on job status. Returns only jobs with the specified status.</p>', 'KeyPhrasesDetectionJobProperties$JobStatus' => '<p>The current status of the key phrases detection job. If the status is <code>FAILED</code>, the <code>Message</code> field shows the reason for the failure.</p>', 'PiiEntitiesDetectionJobFilter$JobStatus' => '<p>Filters the list of jobs based on job status. Returns only jobs with the specified status.</p>', 'PiiEntitiesDetectionJobProperties$JobStatus' => '<p>The current status of the PII entities detection job. If the status is <code>FAILED</code>, the <code>Message</code> field shows the reason for the failure.</p>', 'SentimentDetectionJobFilter$JobStatus' => '<p>Filters the list of jobs based on job status. Returns only jobs with the specified status.</p>', 'SentimentDetectionJobProperties$JobStatus' => '<p>The current status of the sentiment detection job. If the status is <code>FAILED</code>, the <code>Messages</code> field shows the reason for the failure.</p>', 'StartDocumentClassificationJobResponse$JobStatus' => '<p>The status of the job:</p> <ul> <li> <p>SUBMITTED - The job has been received and queued for processing.</p> </li> <li> <p>IN_PROGRESS - Amazon Comprehend is processing the job.</p> </li> <li> <p>COMPLETED - The job was successfully completed and the output is available.</p> </li> <li> <p>FAILED - The job did not complete. For details, use the <code>DescribeDocumentClassificationJob</code> operation.</p> </li> <li> <p>STOP_REQUESTED - Amazon Comprehend has received a stop request for the job and is processing the request.</p> </li> <li> <p>STOPPED - The job was successfully stopped without completing.</p> </li> </ul>', 'StartDominantLanguageDetectionJobResponse$JobStatus' => '<p>The status of the job. </p> <ul> <li> <p>SUBMITTED - The job has been received and is queued for processing.</p> </li> <li> <p>IN_PROGRESS - Amazon Comprehend is processing the job.</p> </li> <li> <p>COMPLETED - The job was successfully completed and the output is available.</p> </li> <li> <p>FAILED - The job did not complete. To get details, use the operation.</p> </li> </ul>', 'StartEntitiesDetectionJobResponse$JobStatus' => '<p>The status of the job. </p> <ul> <li> <p>SUBMITTED - The job has been received and is queued for processing.</p> </li> <li> <p>IN_PROGRESS - Amazon Comprehend is processing the job.</p> </li> <li> <p>COMPLETED - The job was successfully completed and the output is available.</p> </li> <li> <p>FAILED - The job did not complete. To get details, use the operation.</p> </li> <li> <p>STOP_REQUESTED - Amazon Comprehend has received a stop request for the job and is processing the request.</p> </li> <li> <p>STOPPED - The job was successfully stopped without completing.</p> </li> </ul>', 'StartEventsDetectionJobResponse$JobStatus' => '<p>The status of the events detection job.</p>', 'StartKeyPhrasesDetectionJobResponse$JobStatus' => '<p>The status of the job. </p> <ul> <li> <p>SUBMITTED - The job has been received and is queued for processing.</p> </li> <li> <p>IN_PROGRESS - Amazon Comprehend is processing the job.</p> </li> <li> <p>COMPLETED - The job was successfully completed and the output is available.</p> </li> <li> <p>FAILED - The job did not complete. To get details, use the operation.</p> </li> </ul>', 'StartPiiEntitiesDetectionJobResponse$JobStatus' => '<p>The status of the job.</p>', 'StartSentimentDetectionJobResponse$JobStatus' => '<p>The status of the job. </p> <ul> <li> <p>SUBMITTED - The job has been received and is queued for processing.</p> </li> <li> <p>IN_PROGRESS - Amazon Comprehend is processing the job.</p> </li> <li> <p>COMPLETED - The job was successfully completed and the output is available.</p> </li> <li> <p>FAILED - The job did not complete. To get details, use the operation.</p> </li> </ul>', 'StartTargetedSentimentDetectionJobResponse$JobStatus' => '<p>The status of the job. </p> <ul> <li> <p>SUBMITTED - The job has been received and is queued for processing.</p> </li> <li> <p>IN_PROGRESS - Amazon Comprehend is processing the job.</p> </li> <li> <p>COMPLETED - The job was successfully completed and the output is available.</p> </li> <li> <p>FAILED - The job did not complete. To get details, use the <code>DescribeTargetedSentimentDetectionJob</code> operation.</p> </li> </ul>', 'StartTopicsDetectionJobResponse$JobStatus' => '<p>The status of the job: </p> <ul> <li> <p>SUBMITTED - The job has been received and is queued for processing.</p> </li> <li> <p>IN_PROGRESS - Amazon Comprehend is processing the job.</p> </li> <li> <p>COMPLETED - The job was successfully completed and the output is available.</p> </li> <li> <p>FAILED - The job did not complete. To get details, use the <code>DescribeTopicDetectionJob</code> operation.</p> </li> </ul>', 'StopDominantLanguageDetectionJobResponse$JobStatus' => '<p>Either <code>STOP_REQUESTED</code> if the job is currently running, or <code>STOPPED</code> if the job was previously stopped with the <code>StopDominantLanguageDetectionJob</code> operation.</p>', 'StopEntitiesDetectionJobResponse$JobStatus' => '<p>Either <code>STOP_REQUESTED</code> if the job is currently running, or <code>STOPPED</code> if the job was previously stopped with the <code>StopEntitiesDetectionJob</code> operation.</p>', 'StopEventsDetectionJobResponse$JobStatus' => '<p>The status of the events detection job.</p>', 'StopKeyPhrasesDetectionJobResponse$JobStatus' => '<p>Either <code>STOP_REQUESTED</code> if the job is currently running, or <code>STOPPED</code> if the job was previously stopped with the <code>StopKeyPhrasesDetectionJob</code> operation.</p>', 'StopPiiEntitiesDetectionJobResponse$JobStatus' => '<p>The status of the PII entities detection job.</p>', 'StopSentimentDetectionJobResponse$JobStatus' => '<p>Either <code>STOP_REQUESTED</code> if the job is currently running, or <code>STOPPED</code> if the job was previously stopped with the <code>StopSentimentDetectionJob</code> operation.</p>', 'StopTargetedSentimentDetectionJobResponse$JobStatus' => '<p>Either <code>STOP_REQUESTED</code> if the job is currently running, or <code>STOPPED</code> if the job was previously stopped with the <code>StopSentimentDetectionJob</code> operation.</p>', 'TargetedSentimentDetectionJobFilter$JobStatus' => '<p>Filters the list of jobs based on job status. Returns only jobs with the specified status.</p>', 'TargetedSentimentDetectionJobProperties$JobStatus' => '<p>The current status of the targeted sentiment detection job. If the status is <code>FAILED</code>, the <code>Messages</code> field shows the reason for the failure.</p>', 'TopicsDetectionJobFilter$JobStatus' => '<p>Filters the list of topic detection jobs based on job status. Returns only jobs with the specified status.</p>', 'TopicsDetectionJobProperties$JobStatus' => '<p>The current status of the topic detection job. If the status is <code>Failed</code>, the reason for the failure is shown in the <code>Message</code> field.</p>', ], ], 'KeyPhrase' => [ 'base' => '<p>Describes a key noun phrase.</p>', 'refs' => [ 'ListOfKeyPhrases$member' => NULL, ], ], 'KeyPhrasesDetectionJobFilter' => [ 'base' => '<p>Provides information for filtering a list of dominant language detection jobs. For more information, see the operation.</p>', 'refs' => [ 'ListKeyPhrasesDetectionJobsRequest$Filter' => '<p>Filters the jobs that are returned. You can filter jobs on their name, status, or the date and time that they were submitted. You can only set one filter at a time.</p>', ], ], 'KeyPhrasesDetectionJobProperties' => [ 'base' => '<p>Provides information about a key phrases detection job.</p>', 'refs' => [ 'DescribeKeyPhrasesDetectionJobResponse$KeyPhrasesDetectionJobProperties' => '<p>An object that contains the properties associated with a key phrases detection job. </p>', 'KeyPhrasesDetectionJobPropertiesList$member' => NULL, ], ], 'KeyPhrasesDetectionJobPropertiesList' => [ 'base' => NULL, 'refs' => [ 'ListKeyPhrasesDetectionJobsResponse$KeyPhrasesDetectionJobPropertiesList' => '<p>A list containing the properties of each job that is returned.</p>', ], ], 'KmsKeyId' => [ 'base' => NULL, 'refs' => [ 'CreateDocumentClassifierRequest$VolumeKmsKeyId' => '<p>ID for the Amazon Web Services Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:</p> <ul> <li> <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> <li> <p>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> </ul>', 'CreateDocumentClassifierRequest$ModelKmsKeyId' => '<p>ID for the KMS key that Amazon Comprehend uses to encrypt trained custom models. The ModelKmsKeyId can be either of the following formats:</p> <ul> <li> <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> <li> <p>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> </ul>', 'CreateEntityRecognizerRequest$VolumeKmsKeyId' => '<p>ID for the Amazon Web Services Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:</p> <ul> <li> <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> <li> <p>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> </ul>', 'CreateEntityRecognizerRequest$ModelKmsKeyId' => '<p>ID for the KMS key that Amazon Comprehend uses to encrypt trained custom models. The ModelKmsKeyId can be either of the following formats:</p> <ul> <li> <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> <li> <p>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> </ul>', 'DataSecurityConfig$ModelKmsKeyId' => '<p>ID for the KMS key that Amazon Comprehend uses to encrypt trained custom models. The ModelKmsKeyId can be either of the following formats:</p> <ul> <li> <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> <li> <p>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> </ul>', 'DataSecurityConfig$VolumeKmsKeyId' => '<p>ID for the KMS key that Amazon Comprehend uses to encrypt the volume.</p>', 'DataSecurityConfig$DataLakeKmsKeyId' => '<p>ID for the KMS key that Amazon Comprehend uses to encrypt the data in the data lake.</p>', 'DocumentClassificationJobProperties$VolumeKmsKeyId' => '<p>ID for the Amazon Web Services Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:</p> <ul> <li> <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> <li> <p>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> </ul>', 'DocumentClassifierOutputDataConfig$KmsKeyId' => '<p>ID for the Amazon Web Services Key Management Service (KMS) key that Amazon Comprehend uses to encrypt the output results from an analysis job. The KmsKeyId can be one of the following formats:</p> <ul> <li> <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> <li> <p>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> <li> <p>KMS Key Alias: <code>"alias/ExampleAlias"</code> </p> </li> <li> <p>ARN of a KMS Key Alias: <code>"arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias"</code> </p> </li> </ul>', 'DocumentClassifierProperties$VolumeKmsKeyId' => '<p>ID for the Amazon Web Services Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:</p> <ul> <li> <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> <li> <p>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> </ul>', 'DocumentClassifierProperties$ModelKmsKeyId' => '<p>ID for the KMS key that Amazon Comprehend uses to encrypt trained custom models. The ModelKmsKeyId can be either of the following formats:</p> <ul> <li> <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> <li> <p>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> </ul>', 'DominantLanguageDetectionJobProperties$VolumeKmsKeyId' => '<p>ID for the Amazon Web Services Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:</p> <ul> <li> <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> <li> <p>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> </ul>', 'EntitiesDetectionJobProperties$VolumeKmsKeyId' => '<p>ID for the Amazon Web Services Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:</p> <ul> <li> <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> <li> <p>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> </ul>', 'EntityRecognizerProperties$VolumeKmsKeyId' => '<p>ID for the Amazon Web Services Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:</p> <ul> <li> <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> <li> <p>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> </ul>', 'EntityRecognizerProperties$ModelKmsKeyId' => '<p>ID for the KMS key that Amazon Comprehend uses to encrypt trained custom models. The ModelKmsKeyId can be either of the following formats:</p> <ul> <li> <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> <li> <p>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> </ul>', 'ImportModelRequest$ModelKmsKeyId' => '<p>ID for the KMS key that Amazon Comprehend uses to encrypt trained custom models. The ModelKmsKeyId can be either of the following formats:</p> <ul> <li> <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> <li> <p>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> </ul>', 'KeyPhrasesDetectionJobProperties$VolumeKmsKeyId' => '<p>ID for the KMS key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:</p> <ul> <li> <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> <li> <p>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> </ul>', 'OutputDataConfig$KmsKeyId' => '<p>ID for the Amazon Web Services Key Management Service (KMS) key that Amazon Comprehend uses to encrypt the output results from an analysis job. Specify the Key Id of a symmetric key, because you cannot use an asymmetric key for uploading data to S3.</p> <p>The KmsKeyId can be one of the following formats:</p> <ul> <li> <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> <li> <p>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> <li> <p>KMS Key Alias: <code>"alias/ExampleAlias"</code> </p> </li> <li> <p>ARN of a KMS Key Alias: <code>"arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias"</code> </p> </li> </ul>', 'PiiOutputDataConfig$KmsKeyId' => '<p>ID for the Amazon Web Services Key Management Service (KMS) key that Amazon Comprehend uses to encrypt the output results from an analysis job.</p>', 'SentimentDetectionJobProperties$VolumeKmsKeyId' => '<p>ID for the Amazon Web Services Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:</p> <ul> <li> <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> <li> <p>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> </ul>', 'StartDocumentClassificationJobRequest$VolumeKmsKeyId' => '<p>ID for the Amazon Web Services Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:</p> <ul> <li> <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> <li> <p>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> </ul>', 'StartDominantLanguageDetectionJobRequest$VolumeKmsKeyId' => '<p>ID for the Amazon Web Services Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:</p> <ul> <li> <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> <li> <p>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> </ul>', 'StartEntitiesDetectionJobRequest$VolumeKmsKeyId' => '<p>ID for the Amazon Web Services Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:</p> <ul> <li> <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> <li> <p>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> </ul>', 'StartKeyPhrasesDetectionJobRequest$VolumeKmsKeyId' => '<p>ID for the Amazon Web Services Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:</p> <ul> <li> <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> <li> <p>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> </ul>', 'StartSentimentDetectionJobRequest$VolumeKmsKeyId' => '<p>ID for the Amazon Web Services Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:</p> <ul> <li> <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> <li> <p>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> </ul>', 'StartTargetedSentimentDetectionJobRequest$VolumeKmsKeyId' => '<p>ID for the KMS key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:</p> <ul> <li> <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> <li> <p>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> </ul>', 'StartTopicsDetectionJobRequest$VolumeKmsKeyId' => '<p>ID for the Amazon Web Services Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:</p> <ul> <li> <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> <li> <p>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> </ul>', 'TargetedSentimentDetectionJobProperties$VolumeKmsKeyId' => '<p>ID for the KMS key that Amazon Comprehend uses to encrypt the data on the storage volume attached to the ML compute instance(s) that process the targeted sentiment detection job. The VolumeKmsKeyId can be either of the following formats:</p> <ul> <li> <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> <li> <p>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> </ul>', 'TopicsDetectionJobProperties$VolumeKmsKeyId' => '<p>ID for the Amazon Web Services Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:</p> <ul> <li> <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> <li> <p>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> </ul>', 'UpdateDataSecurityConfig$ModelKmsKeyId' => '<p>ID for the KMS key that Amazon Comprehend uses to encrypt trained custom models. The ModelKmsKeyId can be either of the following formats:</p> <ul> <li> <p>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> <li> <p>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> </ul>', 'UpdateDataSecurityConfig$VolumeKmsKeyId' => '<p>ID for the KMS key that Amazon Comprehend uses to encrypt the volume.</p>', ], ], 'KmsKeyValidationException' => [ 'base' => '<p>The KMS customer managed key (CMK) entered cannot be validated. Verify the key and re-enter it.</p>', 'refs' => [], ], 'LabelDelimiter' => [ 'base' => NULL, 'refs' => [ 'DatasetDocumentClassifierInputDataConfig$LabelDelimiter' => '<p>Indicates the delimiter used to separate each label for training a multi-label classifier. The default delimiter between labels is a pipe (|). You can use a different character as a delimiter (if it\'s an allowed character) by specifying it under Delimiter for labels. If the training documents use a delimiter other than the default or the delimiter you specify, the labels on that line will be combined to make a single unique label, such as LABELLABELLABEL.</p>', 'DocumentClassifierInputDataConfig$LabelDelimiter' => '<p>Indicates the delimiter used to separate each label for training a multi-label classifier. The default delimiter between labels is a pipe (|). You can use a different character as a delimiter (if it\'s an allowed character) by specifying it under Delimiter for labels. If the training documents use a delimiter other than the default or the delimiter you specify, the labels on that line will be combined to make a single unique label, such as LABELLABELLABEL.</p>', ], ], 'LabelListItem' => [ 'base' => NULL, 'refs' => [ 'LabelsList$member' => NULL, ], ], 'LabelsList' => [ 'base' => NULL, 'refs' => [ 'DocumentClassificationConfig$Labels' => '<p>One or more labels to associate with the custom classifier.</p>', ], ], 'LanguageCode' => [ 'base' => NULL, 'refs' => [ 'BatchDetectEntitiesRequest$LanguageCode' => '<p>The language of the input documents. You can specify any of the primary languages supported by Amazon Comprehend. All documents must be in the same language.</p>', 'BatchDetectKeyPhrasesRequest$LanguageCode' => '<p>The language of the input documents. You can specify any of the primary languages supported by Amazon Comprehend. All documents must be in the same language.</p>', 'BatchDetectSentimentRequest$LanguageCode' => '<p>The language of the input documents. You can specify any of the primary languages supported by Amazon Comprehend. All documents must be in the same language.</p>', 'BatchDetectTargetedSentimentRequest$LanguageCode' => '<p>The language of the input documents. Currently, English is the only supported language.</p>', 'ContainsPiiEntitiesRequest$LanguageCode' => '<p>The language of the input documents.</p>', 'CreateDocumentClassifierRequest$LanguageCode' => '<p>The language of the input documents. You can specify any of the languages supported by Amazon Comprehend. All documents must be in the same language.</p>', 'CreateEntityRecognizerRequest$LanguageCode' => '<p> You can specify any of the following languages: English ("en"), Spanish ("es"), French ("fr"), Italian ("it"), German ("de"), or Portuguese ("pt"). If you plan to use this entity recognizer with PDF, Word, or image input files, you must specify English as the language. All training documents must be in the same language.</p>', 'DetectEntitiesRequest$LanguageCode' => '<p>The language of the input documents. You can specify any of the primary languages supported by Amazon Comprehend. If your request includes the endpoint for a custom entity recognition model, Amazon Comprehend uses the language of your custom model, and it ignores any language code that you specify here.</p> <p>All input documents must be in the same language.</p>', 'DetectKeyPhrasesRequest$LanguageCode' => '<p>The language of the input documents. You can specify any of the primary languages supported by Amazon Comprehend. All documents must be in the same language.</p>', 'DetectPiiEntitiesRequest$LanguageCode' => '<p>The language of the input text. Enter the language code for English (en) or Spanish (es).</p>', 'DetectSentimentRequest$LanguageCode' => '<p>The language of the input documents. You can specify any of the primary languages supported by Amazon Comprehend. All documents must be in the same language.</p>', 'DetectTargetedSentimentRequest$LanguageCode' => '<p>The language of the input documents. Currently, English is the only supported language.</p>', 'DetectToxicContentRequest$LanguageCode' => '<p>The language of the input text. Currently, English is the only supported language.</p>', 'DocumentClassifierProperties$LanguageCode' => '<p>The language code for the language of the documents that the classifier was trained on.</p>', 'EntitiesDetectionJobProperties$LanguageCode' => '<p>The language code of the input documents.</p>', 'EntityRecognizerProperties$LanguageCode' => '<p> The language of the input documents. All documents must be in the same language. Only English ("en") is currently supported.</p>', 'EventsDetectionJobProperties$LanguageCode' => '<p>The language code of the input documents.</p>', 'KeyPhrasesDetectionJobProperties$LanguageCode' => '<p>The language code of the input documents.</p>', 'PiiEntitiesDetectionJobProperties$LanguageCode' => '<p>The language code of the input documents.</p>', 'SentimentDetectionJobProperties$LanguageCode' => '<p>The language code of the input documents.</p>', 'StartEntitiesDetectionJobRequest$LanguageCode' => '<p>The language of the input documents. All documents must be in the same language. You can specify any of the languages supported by Amazon Comprehend. If custom entities recognition is used, this parameter is ignored and the language used for training the model is used instead.</p>', 'StartEventsDetectionJobRequest$LanguageCode' => '<p>The language code of the input documents.</p>', 'StartKeyPhrasesDetectionJobRequest$LanguageCode' => '<p>The language of the input documents. You can specify any of the primary languages supported by Amazon Comprehend. All documents must be in the same language.</p>', 'StartPiiEntitiesDetectionJobRequest$LanguageCode' => '<p>The language of the input documents. Enter the language code for English (en) or Spanish (es).</p>', 'StartSentimentDetectionJobRequest$LanguageCode' => '<p>The language of the input documents. You can specify any of the primary languages supported by Amazon Comprehend. All documents must be in the same language.</p>', 'StartTargetedSentimentDetectionJobRequest$LanguageCode' => '<p>The language of the input documents. Currently, English is the only supported language.</p>', 'TargetedSentimentDetectionJobProperties$LanguageCode' => '<p>The language code of the input documents.</p>', 'TaskConfig$LanguageCode' => '<p>Language code for the language that the model supports.</p>', ], ], 'ListDatasetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDatasetsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDocumentClassificationJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDocumentClassificationJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDocumentClassifierSummariesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDocumentClassifierSummariesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDocumentClassifiersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDocumentClassifiersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDominantLanguageDetectionJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDominantLanguageDetectionJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListEndpointsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListEndpointsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListEntitiesDetectionJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListEntitiesDetectionJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListEntityRecognizerSummariesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListEntityRecognizerSummariesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListEntityRecognizersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListEntityRecognizersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListEventsDetectionJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListEventsDetectionJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFlywheelIterationHistoryRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFlywheelIterationHistoryResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFlywheelsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFlywheelsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListKeyPhrasesDetectionJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListKeyPhrasesDetectionJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListOfBlockReferences' => [ 'base' => NULL, 'refs' => [ 'Entity$BlockReferences' => '<p>A reference to each block for this entity. This field is empty for plain-text input.</p>', ], ], 'ListOfBlocks' => [ 'base' => NULL, 'refs' => [ 'DetectEntitiesResponse$Blocks' => '<p>Information about each block of text in the input document. Blocks are nested. A page block contains a block for each line of text, which contains a block for each word. </p> <p>The <code>Block</code> content for a Word input document does not include a <code>Geometry</code> field.</p> <p>The <code>Block</code> field is not present in the response for plain-text inputs.</p>', ], ], 'ListOfChildBlocks' => [ 'base' => NULL, 'refs' => [ 'BlockReference$ChildBlocks' => '<p>List of child blocks within this block.</p>', ], ], 'ListOfClasses' => [ 'base' => NULL, 'refs' => [ 'ClassifyDocumentResponse$Classes' => '<p>The classes used by the document being analyzed. These are used for models trained in multi-class mode. Individual classes are mutually exclusive and each document is expected to have only a single class assigned to it. For example, an animal can be a dog or a cat, but not both at the same time. </p> <p>For prompt safety classification, the response includes only two classes (SAFE_PROMPT and UNSAFE_PROMPT), along with a confidence score for each class. The value range of the score is zero to one, where one is the highest confidence.</p>', ], ], 'ListOfDescriptiveMentionIndices' => [ 'base' => NULL, 'refs' => [ 'TargetedSentimentEntity$DescriptiveMentionIndex' => '<p>One or more index into the Mentions array that provides the best name for the entity group.</p>', ], ], 'ListOfDetectDominantLanguageResult' => [ 'base' => NULL, 'refs' => [ 'BatchDetectDominantLanguageResponse$ResultList' => '<p>A list of objects containing the results of the operation. The results are sorted in ascending order by the <code>Index</code> field and match the order of the documents in the input list. If all of the documents contain an error, the <code>ResultList</code> is empty.</p>', ], ], 'ListOfDetectEntitiesResult' => [ 'base' => NULL, 'refs' => [ 'BatchDetectEntitiesResponse$ResultList' => '<p>A list of objects containing the results of the operation. The results are sorted in ascending order by the <code>Index</code> field and match the order of the documents in the input list. If all of the documents contain an error, the <code>ResultList</code> is empty.</p>', ], ], 'ListOfDetectKeyPhrasesResult' => [ 'base' => NULL, 'refs' => [ 'BatchDetectKeyPhrasesResponse$ResultList' => '<p>A list of objects containing the results of the operation. The results are sorted in ascending order by the <code>Index</code> field and match the order of the documents in the input list. If all of the documents contain an error, the <code>ResultList</code> is empty.</p>', ], ], 'ListOfDetectSentimentResult' => [ 'base' => NULL, 'refs' => [ 'BatchDetectSentimentResponse$ResultList' => '<p>A list of objects containing the results of the operation. The results are sorted in ascending order by the <code>Index</code> field and match the order of the documents in the input list. If all of the documents contain an error, the <code>ResultList</code> is empty.</p>', ], ], 'ListOfDetectSyntaxResult' => [ 'base' => NULL, 'refs' => [ 'BatchDetectSyntaxResponse$ResultList' => '<p>A list of objects containing the results of the operation. The results are sorted in ascending order by the <code>Index</code> field and match the order of the documents in the input list. If all of the documents contain an error, the <code>ResultList</code> is empty.</p>', ], ], 'ListOfDetectTargetedSentimentResult' => [ 'base' => NULL, 'refs' => [ 'BatchDetectTargetedSentimentResponse$ResultList' => '<p>A list of objects containing the results of the operation. The results are sorted in ascending order by the <code>Index</code> field and match the order of the documents in the input list. If all of the documents contain an error, the <code>ResultList</code> is empty.</p>', ], ], 'ListOfDocumentReadFeatureTypes' => [ 'base' => NULL, 'refs' => [ 'DocumentReaderConfig$FeatureTypes' => '<p>Specifies the type of Amazon Textract features to apply. If you chose <code>TEXTRACT_ANALYZE_DOCUMENT</code> as the read action, you must specify one or both of the following values:</p> <ul> <li> <p> <code>TABLES</code> - Returns additional information about any tables that are detected in the input document. </p> </li> <li> <p> <code>FORMS</code> - Returns additional information about any forms that are detected in the input document. </p> </li> </ul>', ], ], 'ListOfDocumentType' => [ 'base' => NULL, 'refs' => [ 'ClassifyDocumentResponse$DocumentType' => '<p>The document type for each page in the input document. This field is present in the response only if your request includes the <code>Byte</code> parameter. </p>', 'DetectEntitiesResponse$DocumentType' => '<p>The document type for each page in the input document. This field is present in the response only if your request used the <code>Byte</code> parameter. </p>', ], ], 'ListOfDominantLanguages' => [ 'base' => NULL, 'refs' => [ 'BatchDetectDominantLanguageItemResult$Languages' => '<p>One or more <a>DominantLanguage</a> objects describing the dominant languages in the document.</p>', 'DetectDominantLanguageResponse$Languages' => '<p>Array of languages that Amazon Comprehend detected in the input text. The array is sorted in descending order of the score (the dominant language is always the first element in the array).</p> <p>For each language, the response returns the RFC 5646 language code and the level of confidence that Amazon Comprehend has in the accuracy of its inference. For more information about RFC 5646, see <a href="https://tools.ietf.org/html/rfc5646">Tags for Identifying Languages</a> on the <i>IETF Tools</i> web site.</p>', ], ], 'ListOfEntities' => [ 'base' => NULL, 'refs' => [ 'BatchDetectEntitiesItemResult$Entities' => '<p>One or more <a>Entity</a> objects, one for each entity detected in the document.</p>', 'DetectEntitiesResponse$Entities' => '<p>A collection of entities identified in the input text. For each entity, the response provides the entity text, entity type, where the entity text begins and ends, and the level of confidence that Amazon Comprehend has in the detection. </p> <p>If your request uses a custom entity recognition model, Amazon Comprehend detects the entities that the model is trained to recognize. Otherwise, it detects the default entity types. For a list of default entity types, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/how-entities.html">Entities</a> in the Comprehend Developer Guide. </p>', ], ], 'ListOfEntityLabels' => [ 'base' => NULL, 'refs' => [ 'ContainsPiiEntitiesResponse$Labels' => '<p>The labels used in the document being analyzed. Individual labels represent personally identifiable information (PII) entity types.</p>', ], ], 'ListOfErrors' => [ 'base' => NULL, 'refs' => [ 'ClassifyDocumentResponse$Errors' => '<p>Page-level errors that the system detected while processing the input document. The field is empty if the system encountered no errors.</p>', 'DetectEntitiesResponse$Errors' => '<p>Page-level errors that the system detected while processing the input document. The field is empty if the system encountered no errors.</p>', ], ], 'ListOfExtractedCharacters' => [ 'base' => NULL, 'refs' => [ 'DocumentMetadata$ExtractedCharacters' => '<p>List of pages in the document, with the number of characters extracted from each page.</p>', ], ], 'ListOfKeyPhrases' => [ 'base' => NULL, 'refs' => [ 'BatchDetectKeyPhrasesItemResult$KeyPhrases' => '<p>One or more <a>KeyPhrase</a> objects, one for each key phrase detected in the document.</p>', 'DetectKeyPhrasesResponse$KeyPhrases' => '<p>A collection of key phrases that Amazon Comprehend identified in the input text. For each key phrase, the response provides the text of the key phrase, where the key phrase begins and ends, and the level of confidence that Amazon Comprehend has in the accuracy of the detection. </p>', ], ], 'ListOfLabels' => [ 'base' => NULL, 'refs' => [ 'ClassifyDocumentResponse$Labels' => '<p>The labels used in the document being analyzed. These are used for multi-label trained models. Individual labels represent different categories that are related in some manner and are not mutually exclusive. For example, a movie can be just an action movie, or it can be an action movie, a science fiction movie, and a comedy, all at the same time. </p>', ], ], 'ListOfMentions' => [ 'base' => NULL, 'refs' => [ 'TargetedSentimentEntity$Mentions' => '<p>An array of mentions of the entity in the document. The array represents a co-reference group. See <a href="https://docs.aws.amazon.com/comprehend/latest/dg/how-targeted-sentiment.html#how-targeted-sentiment-values"> Co-reference group</a> for an example. </p>', ], ], 'ListOfPiiEntities' => [ 'base' => NULL, 'refs' => [ 'DetectPiiEntitiesResponse$Entities' => '<p>A collection of PII entities identified in the input text. For each entity, the response provides the entity type, where the entity text begins and ends, and the level of confidence that Amazon Comprehend has in the detection.</p>', ], ], 'ListOfPiiEntityTypes' => [ 'base' => NULL, 'refs' => [ 'RedactionConfig$PiiEntityTypes' => '<p>An array of the types of PII entities that Amazon Comprehend detects in the input text for your request.</p>', ], ], 'ListOfRelationships' => [ 'base' => NULL, 'refs' => [ 'Block$Relationships' => '<p>A list of child blocks of the current block. For example, a LINE object has child blocks for each WORD block that\'s part of the line of text. </p>', ], ], 'ListOfSyntaxTokens' => [ 'base' => NULL, 'refs' => [ 'BatchDetectSyntaxItemResult$SyntaxTokens' => '<p>The syntax tokens for the words in the document, one token for each word.</p>', 'DetectSyntaxResponse$SyntaxTokens' => '<p>A collection of syntax tokens describing the text. For each token, the response provides the text, the token type, where the text begins and ends, and the level of confidence that Amazon Comprehend has that the token is correct. For a list of token types, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/how-syntax.html">Syntax</a> in the Comprehend Developer Guide. </p>', ], ], 'ListOfTargetedSentimentEntities' => [ 'base' => NULL, 'refs' => [ 'BatchDetectTargetedSentimentItemResult$Entities' => '<p>An array of targeted sentiment entities.</p>', 'DetectTargetedSentimentResponse$Entities' => '<p>Targeted sentiment analysis for each of the entities identified in the input text.</p>', ], ], 'ListOfTextSegments' => [ 'base' => NULL, 'refs' => [ 'DetectToxicContentRequest$TextSegments' => '<p>A list of up to 10 text strings. Each string has a maximum size of 1 KB, and the maximum size of the list is 10 KB.</p>', ], ], 'ListOfToxicContent' => [ 'base' => NULL, 'refs' => [ 'ToxicLabels$Labels' => '<p>Array of toxic content types identified in the string.</p>', ], ], 'ListOfToxicLabels' => [ 'base' => NULL, 'refs' => [ 'DetectToxicContentResponse$ResultList' => '<p>Results of the content moderation analysis. Each entry in the results list contains a list of toxic content types identified in the text, along with a confidence score for each content type. The results list also includes a toxicity score for each entry in the results list. </p>', ], ], 'ListOfWarnings' => [ 'base' => NULL, 'refs' => [ 'ClassifyDocumentResponse$Warnings' => '<p>Warnings detected while processing the input document. The response includes a warning if there is a mismatch between the input document type and the model type associated with the endpoint that you specified. The response can also include warnings for individual pages that have a mismatch. </p> <p>The field is empty if the system generated no warnings.</p>', ], ], 'ListPiiEntitiesDetectionJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPiiEntitiesDetectionJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSentimentDetectionJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSentimentDetectionJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTargetedSentimentDetectionJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTargetedSentimentDetectionJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTopicsDetectionJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTopicsDetectionJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'MaskCharacter' => [ 'base' => NULL, 'refs' => [ 'RedactionConfig$MaskCharacter' => '<p>A character that replaces each character in the redacted PII entity.</p>', ], ], 'MaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListDatasetsRequest$MaxResults' => '<p>Maximum number of results to return in a response. The default is 100.</p>', 'ListDocumentClassificationJobsRequest$MaxResults' => '<p>The maximum number of results to return in each page. The default is 100.</p>', 'ListDocumentClassifierSummariesRequest$MaxResults' => '<p>The maximum number of results to return on each page. The default is 100.</p>', 'ListDocumentClassifiersRequest$MaxResults' => '<p>The maximum number of results to return in each page. The default is 100.</p>', 'ListDominantLanguageDetectionJobsRequest$MaxResults' => '<p>The maximum number of results to return in each page. The default is 100.</p>', 'ListEndpointsRequest$MaxResults' => '<p>The maximum number of results to return in each page. The default is 100.</p>', 'ListEntitiesDetectionJobsRequest$MaxResults' => '<p>The maximum number of results to return in each page. The default is 100.</p>', 'ListEntityRecognizerSummariesRequest$MaxResults' => '<p>The maximum number of results to return on each page. The default is 100.</p>', 'ListEntityRecognizersRequest$MaxResults' => '<p> The maximum number of results to return on each page. The default is 100.</p>', 'ListEventsDetectionJobsRequest$MaxResults' => '<p>The maximum number of results to return in each page.</p>', 'ListFlywheelIterationHistoryRequest$MaxResults' => '<p>Maximum number of iteration history results to return</p>', 'ListFlywheelsRequest$MaxResults' => '<p>Maximum number of results to return in a response. The default is 100.</p>', 'ListKeyPhrasesDetectionJobsRequest$MaxResults' => '<p>The maximum number of results to return in each page. The default is 100.</p>', 'ListPiiEntitiesDetectionJobsRequest$MaxResults' => '<p>The maximum number of results to return in each page.</p>', 'ListSentimentDetectionJobsRequest$MaxResults' => '<p>The maximum number of results to return in each page. The default is 100.</p>', 'ListTargetedSentimentDetectionJobsRequest$MaxResults' => '<p>The maximum number of results to return in each page. The default is 100.</p>', 'ListTopicsDetectionJobsRequest$MaxResults' => '<p>The maximum number of results to return in each page. The default is 100.</p>', ], ], 'MentionSentiment' => [ 'base' => '<p>Contains the sentiment and sentiment score for one mention of an entity.</p> <p>For more information about targeted sentiment, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/how-targeted-sentiment.html">Targeted sentiment</a> in the <i>Amazon Comprehend Developer Guide</i>.</p>', 'refs' => [ 'TargetedSentimentMention$MentionSentiment' => '<p>Contains the sentiment and sentiment score for the mention.</p>', ], ], 'ModelStatus' => [ 'base' => NULL, 'refs' => [ 'DocumentClassifierFilter$Status' => '<p>Filters the list of classifiers based on status.</p>', 'DocumentClassifierProperties$Status' => '<p>The status of the document classifier. If the status is <code>TRAINED</code> the classifier is ready to use. If the status is <code>TRAINED_WITH_WARNINGS</code> the classifier training succeeded, but you should review the warnings returned in the <code>CreateDocumentClassifier</code> response.</p> <p> If the status is <code>FAILED</code> you can see additional information about why the classifier wasn\'t trained in the <code>Message</code> field.</p>', 'DocumentClassifierSummary$LatestVersionStatus' => '<p>Provides the status of the latest document classifier version.</p>', 'EntityRecognizerFilter$Status' => '<p>The status of an entity recognizer.</p>', 'EntityRecognizerProperties$Status' => '<p>Provides the status of the entity recognizer.</p>', 'EntityRecognizerSummary$LatestVersionStatus' => '<p> Provides the status of the latest entity recognizer version.</p>', ], ], 'ModelType' => [ 'base' => NULL, 'refs' => [ 'CreateFlywheelRequest$ModelType' => '<p>The model type. You need to set <code>ModelType</code> if you are creating a flywheel for a new model.</p>', 'FlywheelProperties$ModelType' => '<p>Model type of the flywheel\'s model.</p>', 'FlywheelSummary$ModelType' => '<p>Model type of the flywheel\'s model.</p>', ], ], 'NumberOfDocuments' => [ 'base' => NULL, 'refs' => [ 'DatasetProperties$NumberOfDocuments' => '<p>The number of documents in the dataset.</p>', ], ], 'NumberOfTopicsInteger' => [ 'base' => NULL, 'refs' => [ 'StartTopicsDetectionJobRequest$NumberOfTopics' => '<p>The number of topics to detect.</p>', ], ], 'OutputDataConfig' => [ 'base' => '<p>Provides configuration parameters for the output of inference jobs.</p> <p/>', 'refs' => [ 'DocumentClassificationJobProperties$OutputDataConfig' => '<p>The output data configuration that you supplied when you created the document classification job.</p>', 'DominantLanguageDetectionJobProperties$OutputDataConfig' => '<p>The output data configuration that you supplied when you created the dominant language detection job.</p>', 'EntitiesDetectionJobProperties$OutputDataConfig' => '<p>The output data configuration that you supplied when you created the entities detection job. </p>', 'EventsDetectionJobProperties$OutputDataConfig' => '<p>The output data configuration that you supplied when you created the events detection job.</p>', 'KeyPhrasesDetectionJobProperties$OutputDataConfig' => '<p>The output data configuration that you supplied when you created the key phrases detection job.</p>', 'SentimentDetectionJobProperties$OutputDataConfig' => '<p>The output data configuration that you supplied when you created the sentiment detection job.</p>', 'StartDocumentClassificationJobRequest$OutputDataConfig' => '<p>Specifies where to send the output files.</p>', 'StartDominantLanguageDetectionJobRequest$OutputDataConfig' => '<p>Specifies where to send the output files.</p>', 'StartEntitiesDetectionJobRequest$OutputDataConfig' => '<p>Specifies where to send the output files.</p>', 'StartEventsDetectionJobRequest$OutputDataConfig' => '<p>Specifies where to send the output files.</p>', 'StartKeyPhrasesDetectionJobRequest$OutputDataConfig' => '<p>Specifies where to send the output files.</p>', 'StartPiiEntitiesDetectionJobRequest$OutputDataConfig' => '<p>Provides conﬁguration parameters for the output of PII entity detection jobs.</p>', 'StartSentimentDetectionJobRequest$OutputDataConfig' => '<p>Specifies where to send the output files. </p>', 'StartTargetedSentimentDetectionJobRequest$OutputDataConfig' => '<p>Specifies where to send the output files. </p>', 'StartTopicsDetectionJobRequest$OutputDataConfig' => '<p>Specifies where to send the output files. The output is a compressed archive with two files, <code>topic-terms.csv</code> that lists the terms associated with each topic, and <code>doc-topics.csv</code> that lists the documents associated with each topic</p>', 'TargetedSentimentDetectionJobProperties$OutputDataConfig' => NULL, 'TopicsDetectionJobProperties$OutputDataConfig' => '<p>The output data configuration supplied when you created the topic detection job.</p>', ], ], 'PageBasedErrorCode' => [ 'base' => NULL, 'refs' => [ 'ErrorsListItem$ErrorCode' => '<p>Error code for the cause of the error.</p>', ], ], 'PageBasedWarningCode' => [ 'base' => NULL, 'refs' => [ 'WarningsListItem$WarnCode' => '<p>The type of warning.</p>', ], ], 'PartOfSpeechTag' => [ 'base' => '<p>Identifies the part of speech represented by the token and gives the confidence that Amazon Comprehend has that the part of speech was correctly identified. For more information about the parts of speech that Amazon Comprehend can identify, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/how-syntax.html">Syntax</a> in the Comprehend Developer Guide. </p>', 'refs' => [ 'SyntaxToken$PartOfSpeech' => '<p>Provides the part of speech label and the confidence level that Amazon Comprehend has that the part of speech was correctly identified. For more information, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/how-syntax.html">Syntax</a> in the Comprehend Developer Guide. </p>', ], ], 'PartOfSpeechTagType' => [ 'base' => NULL, 'refs' => [ 'PartOfSpeechTag$Tag' => '<p>Identifies the part of speech that the token represents.</p>', ], ], 'PiiEntitiesDetectionJobFilter' => [ 'base' => '<p>Provides information for filtering a list of PII entity detection jobs.</p>', 'refs' => [ 'ListPiiEntitiesDetectionJobsRequest$Filter' => '<p>Filters the jobs that are returned. You can filter jobs on their name, status, or the date and time that they were submitted. You can only set one filter at a time.</p>', ], ], 'PiiEntitiesDetectionJobProperties' => [ 'base' => '<p>Provides information about a PII entities detection job.</p>', 'refs' => [ 'DescribePiiEntitiesDetectionJobResponse$PiiEntitiesDetectionJobProperties' => NULL, 'PiiEntitiesDetectionJobPropertiesList$member' => NULL, ], ], 'PiiEntitiesDetectionJobPropertiesList' => [ 'base' => NULL, 'refs' => [ 'ListPiiEntitiesDetectionJobsResponse$PiiEntitiesDetectionJobPropertiesList' => '<p>A list containing the properties of each job that is returned.</p>', ], ], 'PiiEntitiesDetectionMaskMode' => [ 'base' => NULL, 'refs' => [ 'RedactionConfig$MaskMode' => '<p>Specifies whether the PII entity is redacted with the mask character or the entity type.</p>', ], ], 'PiiEntitiesDetectionMode' => [ 'base' => NULL, 'refs' => [ 'PiiEntitiesDetectionJobProperties$Mode' => '<p>Specifies whether the output provides the locations (offsets) of PII entities or a file in which PII entities are redacted.</p>', 'StartPiiEntitiesDetectionJobRequest$Mode' => '<p>Specifies whether the output provides the locations (offsets) of PII entities or a file in which PII entities are redacted.</p>', ], ], 'PiiEntity' => [ 'base' => '<p>Provides information about a PII entity.</p>', 'refs' => [ 'ListOfPiiEntities$member' => NULL, ], ], 'PiiEntityType' => [ 'base' => NULL, 'refs' => [ 'EntityLabel$Name' => '<p>The name of the label.</p>', 'ListOfPiiEntityTypes$member' => NULL, 'PiiEntity$Type' => '<p>The entity\'s type.</p>', ], ], 'PiiOutputDataConfig' => [ 'base' => '<p>Provides configuration parameters for the output of PII entity detection jobs.</p>', 'refs' => [ 'PiiEntitiesDetectionJobProperties$OutputDataConfig' => '<p>The output data configuration that you supplied when you created the PII entities detection job.</p>', ], ], 'Point' => [ 'base' => '<p>The X and Y coordinates of a point on a document page.</p> <p>For additional information, see <a href="https://docs.aws.amazon.com/textract/latest/dg/API_Point.html">Point</a> in the Amazon Textract API reference.</p>', 'refs' => [ 'Polygon$member' => NULL, ], ], 'Policy' => [ 'base' => NULL, 'refs' => [ 'CreateDocumentClassifierRequest$ModelPolicy' => '<p>The resource-based policy to attach to your custom document classifier model. You can use this policy to allow another Amazon Web Services account to import your custom model.</p> <p>Provide your policy as a JSON body that you enter as a UTF-8 encoded string without line breaks. To provide valid JSON, enclose the attribute names and values in double quotes. If the JSON body is also enclosed in double quotes, then you must escape the double quotes that are inside the policy:</p> <p> <code>"{\\"attribute\\": \\"value\\", \\"attribute\\": [\\"value\\"]}"</code> </p> <p>To avoid escaping quotes, you can use single quotes to enclose the policy and double quotes to enclose the JSON names and values:</p> <p> <code>\'{"attribute": "value", "attribute": ["value"]}\'</code> </p>', 'CreateEntityRecognizerRequest$ModelPolicy' => '<p>The JSON resource-based policy to attach to your custom entity recognizer model. You can use this policy to allow another Amazon Web Services account to import your custom model.</p> <p>Provide your JSON as a UTF-8 encoded string without line breaks. To provide valid JSON for your policy, enclose the attribute names and values in double quotes. If the JSON body is also enclosed in double quotes, then you must escape the double quotes that are inside the policy:</p> <p> <code>"{\\"attribute\\": \\"value\\", \\"attribute\\": [\\"value\\"]}"</code> </p> <p>To avoid escaping quotes, you can use single quotes to enclose the policy and double quotes to enclose the JSON names and values:</p> <p> <code>\'{"attribute": "value", "attribute": ["value"]}\'</code> </p>', 'DescribeResourcePolicyResponse$ResourcePolicy' => '<p>The JSON body of the resource-based policy.</p>', 'PutResourcePolicyRequest$ResourcePolicy' => '<p>The JSON resource-based policy to attach to your custom model. Provide your JSON as a UTF-8 encoded string without line breaks. To provide valid JSON for your policy, enclose the attribute names and values in double quotes. If the JSON body is also enclosed in double quotes, then you must escape the double quotes that are inside the policy:</p> <p> <code>"{\\"attribute\\": \\"value\\", \\"attribute\\": [\\"value\\"]}"</code> </p> <p>To avoid escaping quotes, you can use single quotes to enclose the policy and double quotes to enclose the JSON names and values:</p> <p> <code>\'{"attribute": "value", "attribute": ["value"]}\'</code> </p>', ], ], 'PolicyRevisionId' => [ 'base' => NULL, 'refs' => [ 'DeleteResourcePolicyRequest$PolicyRevisionId' => '<p>The revision ID of the policy to delete.</p>', 'DescribeResourcePolicyResponse$PolicyRevisionId' => '<p>The revision ID of the policy. Each time you modify a policy, Amazon Comprehend assigns a new revision ID, and it deletes the prior version of the policy.</p>', 'PutResourcePolicyRequest$PolicyRevisionId' => '<p>The revision ID that Amazon Comprehend assigned to the policy that you are updating. If you are creating a new policy that has no prior version, don\'t use this parameter. Amazon Comprehend creates the revision ID for you.</p>', 'PutResourcePolicyResponse$PolicyRevisionId' => '<p>The revision ID of the policy. Each time you modify a policy, Amazon Comprehend assigns a new revision ID, and it deletes the prior version of the policy.</p>', ], ], 'Polygon' => [ 'base' => NULL, 'refs' => [ 'Geometry$Polygon' => '<p>Within the bounding box, a fine-grained polygon around the recognized item.</p>', ], ], 'PutResourcePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutResourcePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'RedactionConfig' => [ 'base' => '<p>Provides configuration parameters for PII entity redaction.</p>', 'refs' => [ 'PiiEntitiesDetectionJobProperties$RedactionConfig' => '<p>Provides configuration parameters for PII entity redaction.</p> <p>This parameter is required if you set the <code>Mode</code> parameter to <code>ONLY_REDACTION</code>. In that case, you must provide a <code>RedactionConfig</code> definition that includes the <code>PiiEntityTypes</code> parameter.</p>', 'StartPiiEntitiesDetectionJobRequest$RedactionConfig' => '<p>Provides configuration parameters for PII entity redaction.</p> <p>This parameter is required if you set the <code>Mode</code> parameter to <code>ONLY_REDACTION</code>. In that case, you must provide a <code>RedactionConfig</code> definition that includes the <code>PiiEntityTypes</code> parameter.</p>', ], ], 'RelationshipType' => [ 'base' => NULL, 'refs' => [ 'RelationshipsListItem$Type' => '<p>Only supported relationship is a child relationship.</p>', ], ], 'RelationshipsListItem' => [ 'base' => '<p>List of child blocks for the current block.</p>', 'refs' => [ 'ListOfRelationships$member' => NULL, ], ], 'ResourceInUseException' => [ 'base' => '<p>The specified resource name is already in use. Use a different name and try your request again.</p>', 'refs' => [], ], 'ResourceLimitExceededException' => [ 'base' => '<p>The maximum number of resources per account has been exceeded. Review the resources, and then try your request again.</p>', 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>The specified resource ARN was not found. Check the ARN and try your request again.</p>', 'refs' => [], ], 'ResourceUnavailableException' => [ 'base' => '<p>The specified resource is not available. Check the resource and try your request again.</p>', 'refs' => [], ], 'S3Uri' => [ 'base' => NULL, 'refs' => [ 'AugmentedManifestsListItem$S3Uri' => '<p>The Amazon S3 location of the augmented manifest file.</p>', 'AugmentedManifestsListItem$AnnotationDataS3Uri' => '<p>The S3 prefix to the annotation files that are referred in the augmented manifest file.</p>', 'AugmentedManifestsListItem$SourceDocumentsS3Uri' => '<p>The S3 prefix to the source files (PDFs) that are referred to in the augmented manifest file.</p>', 'DatasetAugmentedManifestsListItem$S3Uri' => '<p>The Amazon S3 location of the augmented manifest file.</p>', 'DatasetAugmentedManifestsListItem$AnnotationDataS3Uri' => '<p>The S3 prefix to the annotation files that are referred in the augmented manifest file.</p>', 'DatasetAugmentedManifestsListItem$SourceDocumentsS3Uri' => '<p>The S3 prefix to the source files (PDFs) that are referred to in the augmented manifest file.</p>', 'DatasetDocumentClassifierInputDataConfig$S3Uri' => '<p>The Amazon S3 URI for the input data. The S3 bucket must be in the same Region as the API endpoint that you are calling. The URI can point to a single input file or it can provide the prefix for a collection of input files.</p> <p>For example, if you use the URI <code>S3://bucketName/prefix</code>, if the prefix is a single file, Amazon Comprehend uses that file as input. If more than one file begins with the prefix, Amazon Comprehend uses all of them as input.</p> <p>This parameter is required if you set <code>DataFormat</code> to <code>COMPREHEND_CSV</code>.</p>', 'DatasetEntityRecognizerAnnotations$S3Uri' => '<p> Specifies the Amazon S3 location where the training documents for an entity recognizer are located. The URI must be in the same Region as the API endpoint that you are calling.</p>', 'DatasetEntityRecognizerDocuments$S3Uri' => '<p> Specifies the Amazon S3 location where the documents for the dataset are located. </p>', 'DatasetEntityRecognizerEntityList$S3Uri' => '<p>Specifies the Amazon S3 location where the entity list is located.</p>', 'DatasetProperties$DatasetS3Uri' => '<p>The S3 URI where the dataset is stored.</p>', 'DocumentClassifierDocuments$S3Uri' => '<p>The S3 URI location of the training documents specified in the S3Uri CSV file.</p>', 'DocumentClassifierDocuments$TestS3Uri' => '<p>The S3 URI location of the test documents included in the TestS3Uri CSV file. This field is not required if you do not specify a test CSV file.</p>', 'DocumentClassifierInputDataConfig$S3Uri' => '<p>The Amazon S3 URI for the input data. The S3 bucket must be in the same Region as the API endpoint that you are calling. The URI can point to a single input file or it can provide the prefix for a collection of input files.</p> <p>For example, if you use the URI <code>S3://bucketName/prefix</code>, if the prefix is a single file, Amazon Comprehend uses that file as input. If more than one file begins with the prefix, Amazon Comprehend uses all of them as input.</p> <p>This parameter is required if you set <code>DataFormat</code> to <code>COMPREHEND_CSV</code>.</p>', 'DocumentClassifierInputDataConfig$TestS3Uri' => '<p>This specifies the Amazon S3 location that contains the test annotations for the document classifier. The URI must be in the same Amazon Web Services Region as the API endpoint that you are calling. </p>', 'DocumentClassifierOutputDataConfig$S3Uri' => '<p>When you use the <code>OutputDataConfig</code> object while creating a custom classifier, you specify the Amazon S3 location where you want to write the confusion matrix and other output files. The URI must be in the same Region as the API endpoint that you are calling. The location is used as the prefix for the actual location of this output file.</p> <p>When the custom classifier job is finished, the service creates the output file in a directory specific to the job. The <code>S3Uri</code> field contains the location of the output file, called <code>output.tar.gz</code>. It is a compressed archive that contains the confusion matrix.</p>', 'DocumentClassifierOutputDataConfig$FlywheelStatsS3Prefix' => '<p>The Amazon S3 prefix for the data lake location of the flywheel statistics.</p>', 'EntityRecognizerAnnotations$S3Uri' => '<p> Specifies the Amazon S3 location where the annotations for an entity recognizer are located. The URI must be in the same Region as the API endpoint that you are calling.</p>', 'EntityRecognizerAnnotations$TestS3Uri' => '<p> Specifies the Amazon S3 location where the test annotations for an entity recognizer are located. The URI must be in the same Region as the API endpoint that you are calling.</p>', 'EntityRecognizerDocuments$S3Uri' => '<p> Specifies the Amazon S3 location where the training documents for an entity recognizer are located. The URI must be in the same Region as the API endpoint that you are calling.</p>', 'EntityRecognizerDocuments$TestS3Uri' => '<p> Specifies the Amazon S3 location where the test documents for an entity recognizer are located. The URI must be in the same Amazon Web Services Region as the API endpoint that you are calling.</p>', 'EntityRecognizerEntityList$S3Uri' => '<p>Specifies the Amazon S3 location where the entity list is located. The URI must be in the same Region as the API endpoint that you are calling.</p>', 'EntityRecognizerOutputDataConfig$FlywheelStatsS3Prefix' => '<p>The Amazon S3 prefix for the data lake location of the flywheel statistics.</p>', 'FlywheelIterationProperties$EvaluationManifestS3Prefix' => '<p/>', 'FlywheelProperties$DataLakeS3Uri' => '<p>Amazon S3 URI of the data lake location. </p>', 'FlywheelSummary$DataLakeS3Uri' => '<p>Amazon S3 URI of the data lake location. </p>', 'InputDataConfig$S3Uri' => '<p>The Amazon S3 URI for the input data. The URI must be in same Region as the API endpoint that you are calling. The URI can point to a single input file or it can provide the prefix for a collection of data files. </p> <p>For example, if you use the URI <code>S3://bucketName/prefix</code>, if the prefix is a single file, Amazon Comprehend uses that file as input. If more than one file begins with the prefix, Amazon Comprehend uses all of them as input.</p>', 'OutputDataConfig$S3Uri' => '<p>When you use the <code>OutputDataConfig</code> object with asynchronous operations, you specify the Amazon S3 location where you want to write the output data. The URI must be in the same Region as the API endpoint that you are calling. The location is used as the prefix for the actual location of the output file.</p> <p>When the topic detection job is finished, the service creates an output file in a directory specific to the job. The <code>S3Uri</code> field contains the location of the output file, called <code>output.tar.gz</code>. It is a compressed archive that contains the ouput of the operation.</p> <p> For a PII entity detection job, the output file is plain text, not a compressed archive. The output file name is the same as the input file, with <code>.out</code> appended at the end. </p>', 'PiiOutputDataConfig$S3Uri' => '<p>When you use the <code>PiiOutputDataConfig</code> object with asynchronous operations, you specify the Amazon S3 location where you want to write the output data. </p> <p> For a PII entity detection job, the output file is plain text, not a compressed archive. The output file name is the same as the input file, with <code>.out</code> appended at the end. </p>', ], ], 'SecurityGroupId' => [ 'base' => NULL, 'refs' => [ 'SecurityGroupIds$member' => NULL, ], ], 'SecurityGroupIds' => [ 'base' => NULL, 'refs' => [ 'VpcConfig$SecurityGroupIds' => '<p>The ID number for a security group on an instance of your private VPC. Security groups on your VPC function serve as a virtual firewall to control inbound and outbound traffic and provides security for the resources that you’ll be accessing on the VPC. This ID number is preceded by "sg-", for instance: "sg-03b388029b0a285ea". For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html">Security Groups for your VPC</a>. </p>', ], ], 'SemiStructuredDocumentBlob' => [ 'base' => NULL, 'refs' => [ 'ClassifyDocumentRequest$Bytes' => '<p>Use the <code>Bytes</code> parameter to input a text, PDF, Word or image file.</p> <p>When you classify a document using a custom model, you can also use the <code>Bytes</code> parameter to input an Amazon Textract <code>DetectDocumentText</code> or <code>AnalyzeDocument</code> output file.</p> <p>To classify a document using the prompt safety classifier, use the <code>Text</code> parameter for input.</p> <p>Provide the input document as a sequence of base64-encoded bytes. If your code uses an Amazon Web Services SDK to classify documents, the SDK may encode the document file bytes for you. </p> <p>The maximum length of this field depends on the input document type. For details, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/idp-inputs-sync.html"> Inputs for real-time custom analysis</a> in the Comprehend Developer Guide. </p> <p>If you use the <code>Bytes</code> parameter, do not use the <code>Text</code> parameter.</p>', 'DetectEntitiesRequest$Bytes' => '<p>This field applies only when you use a custom entity recognition model that was trained with PDF annotations. For other cases, enter your text input in the <code>Text</code> field.</p> <p> Use the <code>Bytes</code> parameter to input a text, PDF, Word or image file. Using a plain-text file in the <code>Bytes</code> parameter is equivelent to using the <code>Text</code> parameter (the <code>Entities</code> field in the response is identical).</p> <p>You can also use the <code>Bytes</code> parameter to input an Amazon Textract <code>DetectDocumentText</code> or <code>AnalyzeDocument</code> output file.</p> <p>Provide the input document as a sequence of base64-encoded bytes. If your code uses an Amazon Web Services SDK to detect entities, the SDK may encode the document file bytes for you. </p> <p>The maximum length of this field depends on the input document type. For details, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/idp-inputs-sync.html"> Inputs for real-time custom analysis</a> in the Comprehend Developer Guide. </p> <p>If you use the <code>Bytes</code> parameter, do not use the <code>Text</code> parameter.</p>', ], ], 'SentimentDetectionJobFilter' => [ 'base' => '<p>Provides information for filtering a list of dominant language detection jobs. For more information, see the operation.</p>', 'refs' => [ 'ListSentimentDetectionJobsRequest$Filter' => '<p>Filters the jobs that are returned. You can filter jobs on their name, status, or the date and time that they were submitted. You can only set one filter at a time.</p>', ], ], 'SentimentDetectionJobProperties' => [ 'base' => '<p>Provides information about a sentiment detection job.</p>', 'refs' => [ 'DescribeSentimentDetectionJobResponse$SentimentDetectionJobProperties' => '<p>An object that contains the properties associated with a sentiment detection job.</p>', 'SentimentDetectionJobPropertiesList$member' => NULL, ], ], 'SentimentDetectionJobPropertiesList' => [ 'base' => NULL, 'refs' => [ 'ListSentimentDetectionJobsResponse$SentimentDetectionJobPropertiesList' => '<p>A list containing the properties of each job that is returned.</p>', ], ], 'SentimentScore' => [ 'base' => '<p>Describes the level of confidence that Amazon Comprehend has in the accuracy of its detection of sentiments.</p>', 'refs' => [ 'BatchDetectSentimentItemResult$SentimentScore' => '<p>The level of confidence that Amazon Comprehend has in the accuracy of its sentiment detection.</p>', 'DetectSentimentResponse$SentimentScore' => '<p>An object that lists the sentiments, and their corresponding confidence levels.</p>', 'MentionSentiment$SentimentScore' => NULL, ], ], 'SentimentType' => [ 'base' => NULL, 'refs' => [ 'BatchDetectSentimentItemResult$Sentiment' => '<p>The sentiment detected in the document.</p>', 'DetectSentimentResponse$Sentiment' => '<p>The inferred sentiment that Amazon Comprehend has the highest level of confidence in.</p>', 'MentionSentiment$Sentiment' => '<p>The sentiment of the mention. </p>', ], ], 'Split' => [ 'base' => NULL, 'refs' => [ 'AugmentedManifestsListItem$Split' => '<p>The purpose of the data you\'ve provided in the augmented manifest. You can either train or test this data. If you don\'t specify, the default is train.</p> <p>TRAIN - all of the documents in the manifest will be used for training. If no test documents are provided, Amazon Comprehend will automatically reserve a portion of the training documents for testing.</p> <p> TEST - all of the documents in the manifest will be used for testing.</p>', ], ], 'StartDocumentClassificationJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartDocumentClassificationJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartDominantLanguageDetectionJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartDominantLanguageDetectionJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartEntitiesDetectionJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartEntitiesDetectionJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartEventsDetectionJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartEventsDetectionJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartFlywheelIterationRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartFlywheelIterationResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartKeyPhrasesDetectionJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartKeyPhrasesDetectionJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartPiiEntitiesDetectionJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartPiiEntitiesDetectionJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartSentimentDetectionJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartSentimentDetectionJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartTargetedSentimentDetectionJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartTargetedSentimentDetectionJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartTopicsDetectionJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartTopicsDetectionJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'StopDominantLanguageDetectionJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopDominantLanguageDetectionJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'StopEntitiesDetectionJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopEntitiesDetectionJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'StopEventsDetectionJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopEventsDetectionJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'StopKeyPhrasesDetectionJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopKeyPhrasesDetectionJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'StopPiiEntitiesDetectionJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopPiiEntitiesDetectionJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'StopSentimentDetectionJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopSentimentDetectionJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'StopTargetedSentimentDetectionJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopTargetedSentimentDetectionJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'StopTrainingDocumentClassifierRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopTrainingDocumentClassifierResponse' => [ 'base' => NULL, 'refs' => [], ], 'StopTrainingEntityRecognizerRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopTrainingEntityRecognizerResponse' => [ 'base' => NULL, 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'BatchItemError$ErrorCode' => '<p>The numeric error code of the error.</p>', 'BatchItemError$ErrorMessage' => '<p>A text description of the error.</p>', 'BatchSizeLimitExceededException$Message' => NULL, 'Block$Id' => '<p>Unique identifier for the block.</p>', 'Block$Text' => '<p>The word or line of text extracted from the block.</p>', 'BlockReference$BlockId' => '<p>Unique identifier for the block.</p>', 'ChildBlock$ChildBlockId' => '<p>Unique identifier for the child block.</p>', 'ConcurrentModificationException$Message' => NULL, 'ContainsPiiEntitiesRequest$Text' => '<p>A UTF-8 text string. The maximum string size is 100 KB.</p>', 'DetectPiiEntitiesRequest$Text' => '<p>A UTF-8 text string. The maximum string size is 100 KB.</p>', 'DocumentClass$Name' => '<p>The name of the class.</p>', 'DocumentLabel$Name' => '<p>The name of the label.</p>', 'DominantLanguage$LanguageCode' => '<p>The RFC 5646 language code for the dominant language. For more information about RFC 5646, see <a href="https://tools.ietf.org/html/rfc5646">Tags for Identifying Languages</a> on the <i>IETF Tools</i> web site.</p>', 'Entity$Text' => '<p>The text of the entity.</p>', 'ErrorsListItem$ErrorMessage' => '<p>Text message explaining the reason for the error.</p>', 'InternalServerException$Message' => NULL, 'InvalidFilterException$Message' => NULL, 'InvalidRequestException$Message' => NULL, 'JobNotFoundException$Message' => NULL, 'KeyPhrase$Text' => '<p>The text of a key noun phrase.</p>', 'KmsKeyValidationException$Message' => NULL, 'ListDatasetsRequest$NextToken' => '<p>Identifies the next page of results to return.</p>', 'ListDatasetsResponse$NextToken' => '<p>Identifies the next page of results to return.</p>', 'ListDocumentClassificationJobsRequest$NextToken' => '<p>Identifies the next page of results to return.</p>', 'ListDocumentClassificationJobsResponse$NextToken' => '<p>Identifies the next page of results to return.</p>', 'ListDocumentClassifierSummariesRequest$NextToken' => '<p>Identifies the next page of results to return.</p>', 'ListDocumentClassifierSummariesResponse$NextToken' => '<p>Identifies the next page of results to return.</p>', 'ListDocumentClassifiersRequest$NextToken' => '<p>Identifies the next page of results to return.</p>', 'ListDocumentClassifiersResponse$NextToken' => '<p>Identifies the next page of results to return.</p>', 'ListDominantLanguageDetectionJobsRequest$NextToken' => '<p>Identifies the next page of results to return.</p>', 'ListDominantLanguageDetectionJobsResponse$NextToken' => '<p>Identifies the next page of results to return.</p>', 'ListEndpointsRequest$NextToken' => '<p>Identifies the next page of results to return.</p>', 'ListEndpointsResponse$NextToken' => '<p>Identifies the next page of results to return.</p>', 'ListEntitiesDetectionJobsRequest$NextToken' => '<p>Identifies the next page of results to return.</p>', 'ListEntitiesDetectionJobsResponse$NextToken' => '<p>Identifies the next page of results to return.</p>', 'ListEntityRecognizerSummariesRequest$NextToken' => '<p>Identifies the next page of results to return.</p>', 'ListEntityRecognizerSummariesResponse$NextToken' => '<p>Identifies the next page of results to return.</p>', 'ListEntityRecognizersRequest$NextToken' => '<p>Identifies the next page of results to return.</p>', 'ListEntityRecognizersResponse$NextToken' => '<p>Identifies the next page of results to return.</p>', 'ListEventsDetectionJobsRequest$NextToken' => '<p>Identifies the next page of results to return.</p>', 'ListEventsDetectionJobsResponse$NextToken' => '<p>Identifies the next page of results to return.</p>', 'ListFlywheelIterationHistoryRequest$NextToken' => '<p>Next token</p>', 'ListFlywheelIterationHistoryResponse$NextToken' => '<p>Next token</p>', 'ListFlywheelsRequest$NextToken' => '<p>Identifies the next page of results to return.</p>', 'ListFlywheelsResponse$NextToken' => '<p>Identifies the next page of results to return.</p>', 'ListKeyPhrasesDetectionJobsRequest$NextToken' => '<p>Identifies the next page of results to return.</p>', 'ListKeyPhrasesDetectionJobsResponse$NextToken' => '<p>Identifies the next page of results to return.</p>', 'ListPiiEntitiesDetectionJobsRequest$NextToken' => '<p>Identifies the next page of results to return.</p>', 'ListPiiEntitiesDetectionJobsResponse$NextToken' => '<p>Identifies the next page of results to return.</p>', 'ListSentimentDetectionJobsRequest$NextToken' => '<p>Identifies the next page of results to return.</p>', 'ListSentimentDetectionJobsResponse$NextToken' => '<p>Identifies the next page of results to return.</p>', 'ListTargetedSentimentDetectionJobsRequest$NextToken' => '<p>Identifies the next page of results to return.</p>', 'ListTargetedSentimentDetectionJobsResponse$NextToken' => '<p>Identifies the next page of results to return.</p>', 'ListTopicsDetectionJobsRequest$NextToken' => '<p>Identifies the next page of results to return.</p>', 'ListTopicsDetectionJobsResponse$NextToken' => '<p>Identifies the next page of results to return.</p>', 'ResourceInUseException$Message' => NULL, 'ResourceLimitExceededException$Message' => NULL, 'ResourceNotFoundException$Message' => NULL, 'ResourceUnavailableException$Message' => NULL, 'StringList$member' => NULL, 'SyntaxToken$Text' => '<p>The word that was recognized in the source text.</p>', 'TargetedSentimentMention$Text' => '<p>The text in the document that identifies the entity.</p>', 'TextSizeLimitExceededException$Message' => NULL, 'TooManyRequestsException$Message' => NULL, 'TooManyTagKeysException$Message' => NULL, 'TooManyTagsException$Message' => NULL, 'UnsupportedLanguageException$Message' => NULL, 'WarningsListItem$WarnMessage' => '<p>Text message associated with the warning.</p>', ], ], 'StringList' => [ 'base' => NULL, 'refs' => [ 'RelationshipsListItem$Ids' => '<p>Identifers of the child blocks.</p>', ], ], 'SubnetId' => [ 'base' => NULL, 'refs' => [ 'Subnets$member' => NULL, ], ], 'Subnets' => [ 'base' => NULL, 'refs' => [ 'VpcConfig$Subnets' => '<p>The ID for each subnet being used in your private VPC. This subnet is a subset of the a range of IPv4 addresses used by the VPC and is specific to a given availability zone in the VPC’s Region. This ID number is preceded by "subnet-", for instance: "subnet-04ccf456919e69055". For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">VPCs and Subnets</a>. </p>', ], ], 'SyntaxLanguageCode' => [ 'base' => NULL, 'refs' => [ 'BatchDetectSyntaxRequest$LanguageCode' => '<p>The language of the input documents. You can specify any of the following languages supported by Amazon Comprehend: German ("de"), English ("en"), Spanish ("es"), French ("fr"), Italian ("it"), or Portuguese ("pt"). All documents must be in the same language.</p>', 'DetectSyntaxRequest$LanguageCode' => '<p>The language code of the input documents. You can specify any of the following languages supported by Amazon Comprehend: German ("de"), English ("en"), Spanish ("es"), French ("fr"), Italian ("it"), or Portuguese ("pt").</p>', ], ], 'SyntaxToken' => [ 'base' => '<p>Represents a work in the input text that was recognized and assigned a part of speech. There is one syntax token record for each word in the source text.</p>', 'refs' => [ 'ListOfSyntaxTokens$member' => NULL, ], ], 'Tag' => [ 'base' => '<p>A key-value pair that adds as a metadata to a resource used by Amazon Comprehend. For example, a tag with the key-value pair ‘Department’:’Sales’ might be added to a resource to indicate its use by a particular department. </p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>The initial part of a key-value pair that forms a tag associated with a given resource. For instance, if you want to show which resources are used by which departments, you might use “Department” as the key portion of the pair, with multiple possible values such as “sales,” “legal,” and “administration.” </p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>The initial part of a key-value pair that forms a tag being removed from a given resource. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department. Keys must be unique and cannot be duplicated for a particular resource. </p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateDatasetRequest$Tags' => '<p>Tags for the dataset.</p>', 'CreateDocumentClassifierRequest$Tags' => '<p>Tags to associate with the document classifier. A tag is a key-value pair that adds as a metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department. </p>', 'CreateEndpointRequest$Tags' => '<p>Tags to associate with the endpoint. A tag is a key-value pair that adds metadata to the endpoint. For example, a tag with "Sales" as the key might be added to an endpoint to indicate its use by the sales department. </p>', 'CreateEntityRecognizerRequest$Tags' => '<p>Tags to associate with the entity recognizer. A tag is a key-value pair that adds as a metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department. </p>', 'CreateFlywheelRequest$Tags' => '<p>The tags to associate with this flywheel.</p>', 'ImportModelRequest$Tags' => '<p>Tags to associate with the custom model that is created by this import. A tag is a key-value pair that adds as a metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department.</p>', 'ListTagsForResourceResponse$Tags' => '<p>Tags associated with the Amazon Comprehend resource being queried. A tag is a key-value pair that adds as a metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department. </p>', 'StartDocumentClassificationJobRequest$Tags' => '<p>Tags to associate with the document classification job. A tag is a key-value pair that adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department.</p>', 'StartDominantLanguageDetectionJobRequest$Tags' => '<p>Tags to associate with the dominant language detection job. A tag is a key-value pair that adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department.</p>', 'StartEntitiesDetectionJobRequest$Tags' => '<p>Tags to associate with the entities detection job. A tag is a key-value pair that adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department.</p>', 'StartEventsDetectionJobRequest$Tags' => '<p>Tags to associate with the events detection job. A tag is a key-value pair that adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department.</p>', 'StartKeyPhrasesDetectionJobRequest$Tags' => '<p>Tags to associate with the key phrases detection job. A tag is a key-value pair that adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department.</p>', 'StartPiiEntitiesDetectionJobRequest$Tags' => '<p>Tags to associate with the PII entities detection job. A tag is a key-value pair that adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department.</p>', 'StartSentimentDetectionJobRequest$Tags' => '<p>Tags to associate with the sentiment detection job. A tag is a key-value pair that adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department.</p>', 'StartTargetedSentimentDetectionJobRequest$Tags' => '<p>Tags to associate with the targeted sentiment detection job. A tag is a key-value pair that adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department.</p>', 'StartTopicsDetectionJobRequest$Tags' => '<p>Tags to associate with the topics detection job. A tag is a key-value pair that adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department.</p>', 'TagResourceRequest$Tags' => '<p>Tags being associated with a specific Amazon Comprehend resource. There can be a maximum of 50 tags (both existing and pending) associated with a specific resource. </p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p> The second part of a key-value pair that forms a tag associated with a given resource. For instance, if you want to show which resources are used by which departments, you might use “Department” as the initial (key) portion of the pair, with a value of “sales” to indicate the sales department. </p>', ], ], 'TargetEventTypes' => [ 'base' => NULL, 'refs' => [ 'EventsDetectionJobProperties$TargetEventTypes' => '<p>The types of events that are detected by the job.</p>', 'StartEventsDetectionJobRequest$TargetEventTypes' => '<p>The types of events to detect in the input documents.</p>', ], ], 'TargetedSentimentDetectionJobFilter' => [ 'base' => '<p>Provides information for filtering a list of dominant language detection jobs. For more information, see the <code>ListTargetedSentimentDetectionJobs</code> operation.</p>', 'refs' => [ 'ListTargetedSentimentDetectionJobsRequest$Filter' => '<p>Filters the jobs that are returned. You can filter jobs on their name, status, or the date and time that they were submitted. You can only set one filter at a time.</p>', ], ], 'TargetedSentimentDetectionJobProperties' => [ 'base' => '<p>Provides information about a targeted sentiment detection job.</p>', 'refs' => [ 'DescribeTargetedSentimentDetectionJobResponse$TargetedSentimentDetectionJobProperties' => '<p>An object that contains the properties associated with a targeted sentiment detection job.</p>', 'TargetedSentimentDetectionJobPropertiesList$member' => NULL, ], ], 'TargetedSentimentDetectionJobPropertiesList' => [ 'base' => NULL, 'refs' => [ 'ListTargetedSentimentDetectionJobsResponse$TargetedSentimentDetectionJobPropertiesList' => '<p>A list containing the properties of each job that is returned.</p>', ], ], 'TargetedSentimentEntity' => [ 'base' => '<p>Information about one of the entities found by targeted sentiment analysis.</p> <p>For more information about targeted sentiment, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/how-targeted-sentiment.html">Targeted sentiment</a> in the <i>Amazon Comprehend Developer Guide</i>.</p>', 'refs' => [ 'ListOfTargetedSentimentEntities$member' => NULL, ], ], 'TargetedSentimentEntityType' => [ 'base' => NULL, 'refs' => [ 'TargetedSentimentMention$Type' => '<p>The type of the entity. Amazon Comprehend supports a variety of <a href="https://docs.aws.amazon.com/comprehend/latest/dg/how-targeted-sentiment.html#how-targeted-sentiment-entities">entity types</a>.</p>', ], ], 'TargetedSentimentMention' => [ 'base' => '<p>Information about one mention of an entity. The mention information includes the location of the mention in the text and the sentiment of the mention.</p> <p>For more information about targeted sentiment, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/how-targeted-sentiment.html">Targeted sentiment</a> in the <i>Amazon Comprehend Developer Guide</i>.</p>', 'refs' => [ 'ListOfMentions$member' => NULL, ], ], 'TaskConfig' => [ 'base' => '<p>Configuration about the model associated with a flywheel.</p>', 'refs' => [ 'CreateFlywheelRequest$TaskConfig' => '<p>Configuration about the model associated with the flywheel. You need to set <code>TaskConfig</code> if you are creating a flywheel for a new model.</p>', 'FlywheelProperties$TaskConfig' => '<p>Configuration about the model associated with a flywheel.</p>', ], ], 'TextSegment' => [ 'base' => '<p>One of the of text strings. Each string has a size limit of 1KB.</p>', 'refs' => [ 'ListOfTextSegments$member' => NULL, ], ], 'TextSizeLimitExceededException' => [ 'base' => '<p>The size of the input text exceeds the limit. Use a smaller document.</p>', 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'DatasetFilter$CreationTimeAfter' => '<p>Filter the datasets to include datasets created after the specified time.</p>', 'DatasetFilter$CreationTimeBefore' => '<p>Filter the datasets to include datasets created before the specified time.</p>', 'DatasetProperties$CreationTime' => '<p>Creation time of the dataset.</p>', 'DatasetProperties$EndTime' => '<p>Time when the data from the dataset becomes available in the data lake.</p>', 'DescribeResourcePolicyResponse$CreationTime' => '<p>The time at which the policy was created.</p>', 'DescribeResourcePolicyResponse$LastModifiedTime' => '<p>The time at which the policy was last modified.</p>', 'DocumentClassificationJobFilter$SubmitTimeBefore' => '<p>Filters the list of jobs based on the time that the job was submitted for processing. Returns only jobs submitted before the specified time. Jobs are returned in ascending order, oldest to newest.</p>', 'DocumentClassificationJobFilter$SubmitTimeAfter' => '<p>Filters the list of jobs based on the time that the job was submitted for processing. Returns only jobs submitted after the specified time. Jobs are returned in descending order, newest to oldest.</p>', 'DocumentClassificationJobProperties$SubmitTime' => '<p>The time that the document classification job was submitted for processing.</p>', 'DocumentClassificationJobProperties$EndTime' => '<p>The time that the document classification job completed.</p>', 'DocumentClassifierFilter$SubmitTimeBefore' => '<p>Filters the list of classifiers based on the time that the classifier was submitted for processing. Returns only classifiers submitted before the specified time. Classifiers are returned in ascending order, oldest to newest.</p>', 'DocumentClassifierFilter$SubmitTimeAfter' => '<p>Filters the list of classifiers based on the time that the classifier was submitted for processing. Returns only classifiers submitted after the specified time. Classifiers are returned in descending order, newest to oldest.</p>', 'DocumentClassifierProperties$SubmitTime' => '<p>The time that the document classifier was submitted for training.</p>', 'DocumentClassifierProperties$EndTime' => '<p>The time that training the document classifier completed.</p>', 'DocumentClassifierProperties$TrainingStartTime' => '<p>Indicates the time when the training starts on documentation classifiers. You are billed for the time interval between this time and the value of TrainingEndTime. </p>', 'DocumentClassifierProperties$TrainingEndTime' => '<p>The time that training of the document classifier was completed. Indicates the time when the training completes on documentation classifiers. You are billed for the time interval between this time and the value of TrainingStartTime.</p>', 'DocumentClassifierSummary$LatestVersionCreatedAt' => '<p>The time that the latest document classifier version was submitted for processing.</p>', 'DominantLanguageDetectionJobFilter$SubmitTimeBefore' => '<p>Filters the list of jobs based on the time that the job was submitted for processing. Returns only jobs submitted before the specified time. Jobs are returned in ascending order, oldest to newest.</p>', 'DominantLanguageDetectionJobFilter$SubmitTimeAfter' => '<p>Filters the list of jobs based on the time that the job was submitted for processing. Returns only jobs submitted after the specified time. Jobs are returned in descending order, newest to oldest.</p>', 'DominantLanguageDetectionJobProperties$SubmitTime' => '<p>The time that the dominant language detection job was submitted for processing.</p>', 'DominantLanguageDetectionJobProperties$EndTime' => '<p>The time that the dominant language detection job completed.</p>', 'EndpointFilter$CreationTimeBefore' => '<p>Specifies a date before which the returned endpoint or endpoints were created.</p>', 'EndpointFilter$CreationTimeAfter' => '<p>Specifies a date after which the returned endpoint or endpoints were created.</p>', 'EndpointProperties$CreationTime' => '<p>The creation date and time of the endpoint.</p>', 'EndpointProperties$LastModifiedTime' => '<p>The date and time that the endpoint was last modified.</p>', 'EntitiesDetectionJobFilter$SubmitTimeBefore' => '<p>Filters the list of jobs based on the time that the job was submitted for processing. Returns only jobs submitted before the specified time. Jobs are returned in ascending order, oldest to newest.</p>', 'EntitiesDetectionJobFilter$SubmitTimeAfter' => '<p>Filters the list of jobs based on the time that the job was submitted for processing. Returns only jobs submitted after the specified time. Jobs are returned in descending order, newest to oldest.</p>', 'EntitiesDetectionJobProperties$SubmitTime' => '<p>The time that the entities detection job was submitted for processing.</p>', 'EntitiesDetectionJobProperties$EndTime' => '<p>The time that the entities detection job completed</p>', 'EntityRecognizerFilter$SubmitTimeBefore' => '<p>Filters the list of entities based on the time that the list was submitted for processing. Returns only jobs submitted before the specified time. Jobs are returned in descending order, newest to oldest.</p>', 'EntityRecognizerFilter$SubmitTimeAfter' => '<p>Filters the list of entities based on the time that the list was submitted for processing. Returns only jobs submitted after the specified time. Jobs are returned in ascending order, oldest to newest.</p>', 'EntityRecognizerProperties$SubmitTime' => '<p>The time that the recognizer was submitted for processing.</p>', 'EntityRecognizerProperties$EndTime' => '<p>The time that the recognizer creation completed.</p>', 'EntityRecognizerProperties$TrainingStartTime' => '<p>The time that training of the entity recognizer started.</p>', 'EntityRecognizerProperties$TrainingEndTime' => '<p>The time that training of the entity recognizer was completed.</p>', 'EntityRecognizerSummary$LatestVersionCreatedAt' => '<p> The time that the latest entity recognizer version was submitted for processing.</p>', 'EventsDetectionJobFilter$SubmitTimeBefore' => '<p>Filters the list of jobs based on the time that the job was submitted for processing. Returns only jobs submitted before the specified time. Jobs are returned in ascending order, oldest to newest.</p>', 'EventsDetectionJobFilter$SubmitTimeAfter' => '<p>Filters the list of jobs based on the time that the job was submitted for processing. Returns only jobs submitted after the specified time. Jobs are returned in descending order, newest to oldest.</p>', 'EventsDetectionJobProperties$SubmitTime' => '<p>The time that the events detection job was submitted for processing.</p>', 'EventsDetectionJobProperties$EndTime' => '<p>The time that the events detection job completed.</p>', 'FlywheelFilter$CreationTimeAfter' => '<p>Filter the flywheels to include flywheels created after the specified time.</p>', 'FlywheelFilter$CreationTimeBefore' => '<p>Filter the flywheels to include flywheels created before the specified time.</p>', 'FlywheelIterationFilter$CreationTimeAfter' => '<p>Filter the flywheel iterations to include iterations created after the specified time.</p>', 'FlywheelIterationFilter$CreationTimeBefore' => '<p>Filter the flywheel iterations to include iterations created before the specified time.</p>', 'FlywheelIterationProperties$CreationTime' => '<p>The creation start time of the flywheel iteration.</p>', 'FlywheelIterationProperties$EndTime' => '<p>The completion time of this flywheel iteration.</p>', 'FlywheelProperties$CreationTime' => '<p>Creation time of the flywheel.</p>', 'FlywheelProperties$LastModifiedTime' => '<p>Last modified time for the flywheel.</p>', 'FlywheelSummary$CreationTime' => '<p>Creation time of the flywheel.</p>', 'FlywheelSummary$LastModifiedTime' => '<p>Last modified time for the flywheel.</p>', 'KeyPhrasesDetectionJobFilter$SubmitTimeBefore' => '<p>Filters the list of jobs based on the time that the job was submitted for processing. Returns only jobs submitted before the specified time. Jobs are returned in ascending order, oldest to newest.</p>', 'KeyPhrasesDetectionJobFilter$SubmitTimeAfter' => '<p>Filters the list of jobs based on the time that the job was submitted for processing. Returns only jobs submitted after the specified time. Jobs are returned in descending order, newest to oldest.</p>', 'KeyPhrasesDetectionJobProperties$SubmitTime' => '<p>The time that the key phrases detection job was submitted for processing.</p>', 'KeyPhrasesDetectionJobProperties$EndTime' => '<p>The time that the key phrases detection job completed.</p>', 'PiiEntitiesDetectionJobFilter$SubmitTimeBefore' => '<p>Filters the list of jobs based on the time that the job was submitted for processing. Returns only jobs submitted before the specified time. Jobs are returned in ascending order, oldest to newest.</p>', 'PiiEntitiesDetectionJobFilter$SubmitTimeAfter' => '<p>Filters the list of jobs based on the time that the job was submitted for processing. Returns only jobs submitted after the specified time. Jobs are returned in descending order, newest to oldest.</p>', 'PiiEntitiesDetectionJobProperties$SubmitTime' => '<p>The time that the PII entities detection job was submitted for processing.</p>', 'PiiEntitiesDetectionJobProperties$EndTime' => '<p>The time that the PII entities detection job completed.</p>', 'SentimentDetectionJobFilter$SubmitTimeBefore' => '<p>Filters the list of jobs based on the time that the job was submitted for processing. Returns only jobs submitted before the specified time. Jobs are returned in ascending order, oldest to newest.</p>', 'SentimentDetectionJobFilter$SubmitTimeAfter' => '<p>Filters the list of jobs based on the time that the job was submitted for processing. Returns only jobs submitted after the specified time. Jobs are returned in descending order, newest to oldest.</p>', 'SentimentDetectionJobProperties$SubmitTime' => '<p>The time that the sentiment detection job was submitted for processing.</p>', 'SentimentDetectionJobProperties$EndTime' => '<p>The time that the sentiment detection job ended.</p>', 'TargetedSentimentDetectionJobFilter$SubmitTimeBefore' => '<p>Filters the list of jobs based on the time that the job was submitted for processing. Returns only jobs submitted before the specified time. Jobs are returned in ascending order, oldest to newest.</p>', 'TargetedSentimentDetectionJobFilter$SubmitTimeAfter' => '<p>Filters the list of jobs based on the time that the job was submitted for processing. Returns only jobs submitted after the specified time. Jobs are returned in descending order, newest to oldest.</p>', 'TargetedSentimentDetectionJobProperties$SubmitTime' => '<p>The time that the targeted sentiment detection job was submitted for processing.</p>', 'TargetedSentimentDetectionJobProperties$EndTime' => '<p>The time that the targeted sentiment detection job ended.</p>', 'TopicsDetectionJobFilter$SubmitTimeBefore' => '<p>Filters the list of jobs based on the time that the job was submitted for processing. Only returns jobs submitted before the specified time. Jobs are returned in descending order, newest to oldest.</p>', 'TopicsDetectionJobFilter$SubmitTimeAfter' => '<p>Filters the list of jobs based on the time that the job was submitted for processing. Only returns jobs submitted after the specified time. Jobs are returned in ascending order, oldest to newest.</p>', 'TopicsDetectionJobProperties$SubmitTime' => '<p>The time that the topic detection job was submitted for processing.</p>', 'TopicsDetectionJobProperties$EndTime' => '<p>The time that the topic detection job was completed.</p>', ], ], 'TooManyRequestsException' => [ 'base' => '<p>The number of requests exceeds the limit. Resubmit your request later.</p>', 'refs' => [], ], 'TooManyTagKeysException' => [ 'base' => '<p>The request contains more tag keys than can be associated with a resource (50 tag keys per resource).</p>', 'refs' => [], ], 'TooManyTagsException' => [ 'base' => '<p>The request contains more tags than can be associated with a resource (50 tags per resource). The maximum number of tags includes both existing tags and those included in your current request. </p>', 'refs' => [], ], 'TopicsDetectionJobFilter' => [ 'base' => '<p>Provides information for filtering topic detection jobs. For more information, see .</p>', 'refs' => [ 'ListTopicsDetectionJobsRequest$Filter' => '<p>Filters the jobs that are returned. Jobs can be filtered on their name, status, or the date and time that they were submitted. You can set only one filter at a time.</p>', ], ], 'TopicsDetectionJobProperties' => [ 'base' => '<p>Provides information about a topic detection job.</p>', 'refs' => [ 'DescribeTopicsDetectionJobResponse$TopicsDetectionJobProperties' => '<p>The list of properties for the requested job.</p>', 'TopicsDetectionJobPropertiesList$member' => NULL, ], ], 'TopicsDetectionJobPropertiesList' => [ 'base' => NULL, 'refs' => [ 'ListTopicsDetectionJobsResponse$TopicsDetectionJobPropertiesList' => '<p>A list containing the properties of each job that is returned.</p>', ], ], 'ToxicContent' => [ 'base' => '<p>Toxic content analysis result for one string. For more information about toxicity detection, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/toxicity-detection.html">Toxicity detection</a> in the <i>Amazon Comprehend Developer Guide</i> </p>', 'refs' => [ 'ListOfToxicContent$member' => NULL, ], ], 'ToxicContentType' => [ 'base' => NULL, 'refs' => [ 'ToxicContent$Name' => '<p>The name of the toxic content type.</p>', ], ], 'ToxicLabels' => [ 'base' => '<p>Toxicity analysis result for one string. For more information about toxicity detection, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/toxicity-detection.html">Toxicity detection</a> in the <i>Amazon Comprehend Developer Guide</i>.</p>', 'refs' => [ 'ListOfToxicLabels$member' => NULL, ], ], 'UnsupportedLanguageException' => [ 'base' => '<p>Amazon Comprehend can\'t process the language of the input text. For a list of supported languages, <a href="https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html">Supported languages</a> in the Comprehend Developer Guide. </p>', 'refs' => [], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDataSecurityConfig' => [ 'base' => '<p>Data security configuration.</p>', 'refs' => [ 'UpdateFlywheelRequest$DataSecurityConfig' => '<p>Flywheel data security configuration.</p>', ], ], 'UpdateEndpointRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEndpointResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFlywheelRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFlywheelResponse' => [ 'base' => NULL, 'refs' => [], ], 'VersionName' => [ 'base' => NULL, 'refs' => [ 'CreateDocumentClassifierRequest$VersionName' => '<p>The version name given to the newly created classifier. Version names can have a maximum of 256 characters. Alphanumeric characters, hyphens (-) and underscores (_) are allowed. The version name must be unique among all models with the same classifier name in the Amazon Web Services account/Amazon Web Services Region.</p>', 'CreateEntityRecognizerRequest$VersionName' => '<p>The version name given to the newly created recognizer. Version names can be a maximum of 256 characters. Alphanumeric characters, hyphens (-) and underscores (_) are allowed. The version name must be unique among all models with the same recognizer name in the account/Region.</p>', 'DocumentClassifierProperties$VersionName' => '<p>The version name that you assigned to the document classifier.</p>', 'DocumentClassifierSummary$LatestVersionName' => '<p>The version name you assigned to the latest document classifier version.</p>', 'EntityRecognizerProperties$VersionName' => '<p>The version name you assigned to the entity recognizer.</p>', 'EntityRecognizerSummary$LatestVersionName' => '<p> The version name you assigned to the latest entity recognizer version.</p>', 'ImportModelRequest$VersionName' => '<p>The version name given to the custom model that is created by this import. Version names can have a maximum of 256 characters. Alphanumeric characters, hyphens (-) and underscores (_) are allowed. The version name must be unique among all models with the same classifier name in the account/Region.</p>', ], ], 'VpcConfig' => [ 'base' => '<p> Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources you are using for the job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>. </p>', 'refs' => [ 'CreateDocumentClassifierRequest$VpcConfig' => '<p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources you are using for your custom classifier. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>. </p>', 'CreateEntityRecognizerRequest$VpcConfig' => '<p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources you are using for your custom entity recognizer. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>. </p>', 'DataSecurityConfig$VpcConfig' => NULL, 'DocumentClassificationJobProperties$VpcConfig' => '<p> Configuration parameters for a private Virtual Private Cloud (VPC) containing the resources you are using for your document classification job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>. </p>', 'DocumentClassifierProperties$VpcConfig' => '<p> Configuration parameters for a private Virtual Private Cloud (VPC) containing the resources you are using for your custom classifier. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>. </p>', 'DominantLanguageDetectionJobProperties$VpcConfig' => '<p> Configuration parameters for a private Virtual Private Cloud (VPC) containing the resources you are using for your dominant language detection job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>. </p>', 'EntitiesDetectionJobProperties$VpcConfig' => '<p> Configuration parameters for a private Virtual Private Cloud (VPC) containing the resources you are using for your entity detection job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>. </p>', 'EntityRecognizerProperties$VpcConfig' => '<p> Configuration parameters for a private Virtual Private Cloud (VPC) containing the resources you are using for your custom entity recognizer. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>. </p>', 'KeyPhrasesDetectionJobProperties$VpcConfig' => '<p> Configuration parameters for a private Virtual Private Cloud (VPC) containing the resources you are using for your key phrases detection job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>. </p>', 'SentimentDetectionJobProperties$VpcConfig' => '<p> Configuration parameters for a private Virtual Private Cloud (VPC) containing the resources you are using for your sentiment detection job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>. </p>', 'StartDocumentClassificationJobRequest$VpcConfig' => '<p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources you are using for your document classification job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>. </p>', 'StartDominantLanguageDetectionJobRequest$VpcConfig' => '<p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources you are using for your dominant language detection job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>. </p>', 'StartEntitiesDetectionJobRequest$VpcConfig' => '<p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources you are using for your entity detection job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>. </p>', 'StartKeyPhrasesDetectionJobRequest$VpcConfig' => '<p> Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources you are using for your key phrases detection job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>. </p>', 'StartSentimentDetectionJobRequest$VpcConfig' => '<p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources you are using for your sentiment detection job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>. </p>', 'StartTargetedSentimentDetectionJobRequest$VpcConfig' => NULL, 'StartTopicsDetectionJobRequest$VpcConfig' => '<p>Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources you are using for your topic detection job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>. </p>', 'TargetedSentimentDetectionJobProperties$VpcConfig' => NULL, 'TopicsDetectionJobProperties$VpcConfig' => '<p>Configuration parameters for a private Virtual Private Cloud (VPC) containing the resources you are using for your topic detection job. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>. </p>', 'UpdateDataSecurityConfig$VpcConfig' => NULL, ], ], 'WarningsListItem' => [ 'base' => '<p>The system identified one of the following warnings while processing the input document:</p> <ul> <li> <p>The document to classify is plain text, but the classifier is a native document model.</p> </li> <li> <p>The document to classify is semi-structured, but the classifier is a plain-text model.</p> </li> </ul>', 'refs' => [ 'ListOfWarnings$member' => NULL, ], ], ],];
