<?php
// This file was auto-generated from sdk-root/src/data/controlcatalog/2018-05-10/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Welcome to the Amazon Web Services Control Catalog API reference. This guide is for developers who need detailed information about how to programmatically identify and filter the common controls and related metadata that are available to Amazon Web Services customers. This API reference provides descriptions, syntax, and usage examples for each of the actions and data types that are supported by Amazon Web Services Control Catalog. </p> <p>Use the following links to get started with the Amazon Web Services Control Catalog API:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/controlcatalog/latest/APIReference/API_Operations.html">Actions</a>: An alphabetical list of all Control Catalog API operations.</p> </li> <li> <p> <a href="https://docs.aws.amazon.com/controlcatalog/latest/APIReference/API_Types.html">Data types</a>: An alphabetical list of all Control Catalog data types.</p> </li> <li> <p> <a href="https://docs.aws.amazon.com/controlcatalog/latest/APIReference/CommonParameters.html">Common parameters</a>: Parameters that all operations can use.</p> </li> <li> <p> <a href="https://docs.aws.amazon.com/controlcatalog/latest/APIReference/CommonErrors.html">Common errors</a>: Client and server errors that all operations can return.</p> </li> </ul>', 'operations' => [ 'ListCommonControls' => '<p>Returns a paginated list of common controls from the Amazon Web Services Control Catalog.</p> <p>You can apply an optional filter to see common controls that have a specific objective. If you don’t provide a filter, the operation returns all common controls. </p>', 'ListDomains' => '<p>Returns a paginated list of domains from the Amazon Web Services Control Catalog.</p>', 'ListObjectives' => '<p>Returns a paginated list of objectives from the Amazon Web Services Control Catalog.</p> <p>You can apply an optional filter to see the objectives that belong to a specific domain. If you don’t provide a filter, the operation returns all objectives. </p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You do not have sufficient access to perform this action.</p>', 'refs' => [], ], 'AssociatedDomainSummary' => [ 'base' => '<p>A summary of the domain that a common control or an objective belongs to.</p>', 'refs' => [ 'CommonControlSummary$Domain' => '<p>The domain that the common control belongs to.</p>', 'ObjectiveSummary$Domain' => '<p>The domain that the objective belongs to.</p>', ], ], 'AssociatedObjectiveSummary' => [ 'base' => '<p>A summary of the objective that a common control supports.</p>', 'refs' => [ 'CommonControlSummary$Objective' => '<p>The objective that the common control belongs to.</p>', ], ], 'CommonControlArn' => [ 'base' => NULL, 'refs' => [ 'CommonControlSummary$Arn' => '<p>The Amazon Resource Name (ARN) that identifies the common control.</p>', ], ], 'CommonControlFilter' => [ 'base' => '<p>An optional filter that narrows the results to a specific objective.</p>', 'refs' => [ 'ListCommonControlsRequest$CommonControlFilter' => '<p>An optional filter that narrows the results to a specific objective.</p> <p>This filter allows you to specify one objective ARN at a time. Passing multiple ARNs in the <code>CommonControlFilter</code> isn’t currently supported.</p>', ], ], 'CommonControlSummary' => [ 'base' => '<p>A summary of metadata for a common control.</p>', 'refs' => [ 'CommonControlSummaryList$member' => NULL, ], ], 'CommonControlSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListCommonControlsResponse$CommonControls' => '<p>The list of common controls that the <code>ListCommonControls</code> API returns.</p>', ], ], 'DomainArn' => [ 'base' => NULL, 'refs' => [ 'AssociatedDomainSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the related domain.</p>', 'DomainResourceFilter$Arn' => '<p>The Amazon Resource Name (ARN) of the domain.</p>', 'DomainSummary$Arn' => '<p>The Amazon Resource Name (ARN) that identifies the domain.</p>', ], ], 'DomainResourceFilter' => [ 'base' => '<p>The domain resource that\'s being used as a filter.</p>', 'refs' => [ 'DomainResourceFilterList$member' => NULL, ], ], 'DomainResourceFilterList' => [ 'base' => NULL, 'refs' => [ 'ObjectiveFilter$Domains' => '<p>The domain that\'s used as filter criteria.</p> <p>You can use this parameter to specify one domain ARN at a time. Passing multiple ARNs in the <code>ObjectiveFilter</code> isn’t currently supported.</p>', ], ], 'DomainSummary' => [ 'base' => '<p>A summary of metadata for a domain.</p>', 'refs' => [ 'DomainSummaryList$member' => NULL, ], ], 'DomainSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListDomainsResponse$Domains' => '<p>The list of domains that the <code>ListDomains</code> API returns.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>An internal service error occurred during the processing of your request. Try again later.</p>', 'refs' => [], ], 'ListCommonControlsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCommonControlsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDomainsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDomainsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListObjectivesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListObjectivesResponse' => [ 'base' => NULL, 'refs' => [], ], 'MaxListCommonControlsResults' => [ 'base' => NULL, 'refs' => [ 'ListCommonControlsRequest$MaxResults' => '<p>The maximum number of results on a page or for an API request call.</p>', ], ], 'MaxListDomainsResults' => [ 'base' => NULL, 'refs' => [ 'ListDomainsRequest$MaxResults' => '<p>The maximum number of results on a page or for an API request call.</p>', ], ], 'MaxListObjectivesResults' => [ 'base' => NULL, 'refs' => [ 'ListObjectivesRequest$MaxResults' => '<p>The maximum number of results on a page or for an API request call.</p>', ], ], 'ObjectiveArn' => [ 'base' => NULL, 'refs' => [ 'AssociatedObjectiveSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the related objective.</p>', 'ObjectiveResourceFilter$Arn' => '<p>The Amazon Resource Name (ARN) of the objective.</p>', 'ObjectiveSummary$Arn' => '<p>The Amazon Resource Name (ARN) that identifies the objective.</p>', ], ], 'ObjectiveFilter' => [ 'base' => '<p>An optional filter that narrows the list of objectives to a specific domain.</p>', 'refs' => [ 'ListObjectivesRequest$ObjectiveFilter' => '<p>An optional filter that narrows the results to a specific domain.</p> <p>This filter allows you to specify one domain ARN at a time. Passing multiple ARNs in the <code>ObjectiveFilter</code> isn’t currently supported.</p>', ], ], 'ObjectiveResourceFilter' => [ 'base' => '<p>The objective resource that\'s being used as a filter.</p>', 'refs' => [ 'ObjectiveResourceFilterList$member' => NULL, ], ], 'ObjectiveResourceFilterList' => [ 'base' => NULL, 'refs' => [ 'CommonControlFilter$Objectives' => '<p>The objective that\'s used as filter criteria.</p> <p>You can use this parameter to specify one objective ARN at a time. Passing multiple ARNs in the <code>CommonControlFilter</code> isn’t currently supported.</p>', ], ], 'ObjectiveSummary' => [ 'base' => '<p>A summary of metadata for an objective.</p>', 'refs' => [ 'ObjectiveSummaryList$member' => NULL, ], ], 'ObjectiveSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListObjectivesResponse$Objectives' => '<p>The list of objectives that the <code>ListObjectives</code> API returns.</p>', ], ], 'PaginationToken' => [ 'base' => NULL, 'refs' => [ 'ListCommonControlsRequest$NextToken' => '<p>The pagination token that\'s used to fetch the next set of results.</p>', 'ListCommonControlsResponse$NextToken' => '<p>The pagination token that\'s used to fetch the next set of results.</p>', 'ListDomainsRequest$NextToken' => '<p>The pagination token that\'s used to fetch the next set of results.</p>', 'ListDomainsResponse$NextToken' => '<p>The pagination token that\'s used to fetch the next set of results.</p>', 'ListObjectivesRequest$NextToken' => '<p>The pagination token that\'s used to fetch the next set of results.</p>', 'ListObjectivesResponse$NextToken' => '<p>The pagination token that\'s used to fetch the next set of results.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => NULL, 'AssociatedDomainSummary$Name' => '<p>The name of the related domain.</p>', 'AssociatedObjectiveSummary$Name' => '<p>The name of the related objective.</p>', 'CommonControlSummary$Description' => '<p>The description of the common control.</p>', 'CommonControlSummary$Name' => '<p>The name of the common control.</p>', 'DomainSummary$Description' => '<p>The description of the domain.</p>', 'DomainSummary$Name' => '<p>The name of the domain.</p>', 'InternalServerException$Message' => NULL, 'ObjectiveSummary$Description' => '<p>The description of the objective.</p>', 'ObjectiveSummary$Name' => '<p>The name of the objective.</p>', 'ThrottlingException$Message' => NULL, 'ValidationException$Message' => NULL, ], ], 'ThrottlingException' => [ 'base' => '<p>The request was denied due to request throttling.</p>', 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'CommonControlSummary$CreateTime' => '<p>The time when the common control was created.</p>', 'CommonControlSummary$LastUpdateTime' => '<p>The time when the common control was most recently updated.</p>', 'DomainSummary$CreateTime' => '<p>The time when the domain was created.</p>', 'DomainSummary$LastUpdateTime' => '<p>The time when the domain was most recently updated.</p>', 'ObjectiveSummary$CreateTime' => '<p>The time when the objective was created.</p>', 'ObjectiveSummary$LastUpdateTime' => '<p>The time when the objective was most recently updated.</p>', ], ], 'ValidationException' => [ 'base' => '<p>The request has invalid or missing parameters.</p>', 'refs' => [], ], ],];
