<?php
// This file was auto-generated from sdk-root/src/data/cost-optimization-hub/2022-07-26/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>You can use the Cost Optimization Hub API to programmatically identify, filter, aggregate, and quantify savings for your cost optimization recommendations across multiple Amazon Web Services Regions and Amazon Web Services accounts in your organization.</p> <p>The Cost Optimization Hub API provides the following endpoint:</p> <ul> <li> <p> https://cost-optimization-hub.us-east-1.amazonaws.com </p> </li> </ul>', 'operations' => [ 'GetPreferences' => '<p>Returns a set of preferences for an account in order to add account-specific preferences into the service. These preferences impact how the savings associated with recommendations are presented—estimated savings after discounts or estimated savings before discounts, for example.</p>', 'GetRecommendation' => '<p>Returns both the current and recommended resource configuration and the estimated cost impact for a recommendation.</p> <p>The <code>recommendationId</code> is only valid for up to a maximum of 24 hours as recommendations are refreshed daily. To retrieve the <code>recommendationId</code>, use the <code>ListRecommendations</code> API.</p>', 'ListEnrollmentStatuses' => '<p>Retrieves the enrollment status for an account. It can also return the list of accounts that are enrolled under the organization.</p>', 'ListRecommendationSummaries' => '<p>Returns a concise representation of savings estimates for resources. Also returns de-duped savings across different types of recommendations.</p> <note> <p>The following filters are not supported for this API: <code>recommendationIds</code>, <code>resourceArns</code>, and <code>resourceIds</code>.</p> </note>', 'ListRecommendations' => '<p>Returns a list of recommendations.</p>', 'UpdateEnrollmentStatus' => '<p>Updates the enrollment (opt in and opt out) status of an account to the Cost Optimization Hub service.</p> <p>If the account is a management account of an organization, this action can also be used to enroll member accounts of the organization.</p> <p>You must have the appropriate permissions to opt in to Cost Optimization Hub and to view its recommendations. When you opt in, Cost Optimization Hub automatically creates a service-linked role in your account to access its data.</p>', 'UpdatePreferences' => '<p>Updates a set of preferences for an account in order to add account-specific preferences into the service. These preferences impact how the savings associated with recommendations are presented.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You are not authorized to use this operation with the given parameters.</p>', 'refs' => [], ], 'AccountEnrollmentStatus' => [ 'base' => '<p>Describes the enrollment status of an organization\'s member accounts in Cost Optimization Hub.</p>', 'refs' => [ 'AccountEnrollmentStatuses$member' => NULL, ], ], 'AccountEnrollmentStatuses' => [ 'base' => NULL, 'refs' => [ 'ListEnrollmentStatusesResponse$items' => '<p>The enrollment status of a specific account ID, including creation and last updated timestamps.</p>', ], ], 'AccountId' => [ 'base' => NULL, 'refs' => [ 'AccountEnrollmentStatus$accountId' => '<p>The Amazon Web Services account ID.</p>', 'AccountIdList$member' => NULL, 'ListEnrollmentStatusesRequest$accountId' => '<p>The account ID of a member account in the organization.</p>', ], ], 'AccountIdList' => [ 'base' => NULL, 'refs' => [ 'Filter$accountIds' => '<p>The account that the recommendation is for.</p>', ], ], 'ActionType' => [ 'base' => NULL, 'refs' => [ 'ActionTypeList$member' => NULL, 'GetRecommendationResponse$actionType' => '<p>The type of action you can take by adopting the recommendation.</p>', ], ], 'ActionTypeList' => [ 'base' => NULL, 'refs' => [ 'Filter$actionTypes' => '<p>The type of action you can take by adopting the recommendation.</p>', ], ], 'BlockStoragePerformanceConfiguration' => [ 'base' => '<p>Describes the Amazon Elastic Block Store performance configuration of the current and recommended resource configuration for a recommendation.</p>', 'refs' => [ 'EbsVolumeConfiguration$performance' => '<p>The Amazon Elastic Block Store performance configuration.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'Ec2ReservedInstancesConfiguration$sizeFlexEligible' => '<p>Determines whether the recommendation is size flexible.</p>', 'ElastiCacheReservedInstancesConfiguration$sizeFlexEligible' => '<p>Determines whether the recommendation is size flexible.</p>', 'Filter$restartNeeded' => '<p>Whether or not implementing the recommendation requires a restart.</p>', 'Filter$rollbackPossible' => '<p>Whether or not implementing the recommendation can be rolled back.</p>', 'GetRecommendationResponse$restartNeeded' => '<p>Whether or not implementing the recommendation requires a restart.</p>', 'GetRecommendationResponse$rollbackPossible' => '<p>Whether or not implementing the recommendation can be rolled back.</p>', 'ListEnrollmentStatusesResponse$includeMemberAccounts' => '<p>The enrollment status of all member accounts in the organization if the account is the management account.</p>', 'OpenSearchReservedInstancesConfiguration$sizeFlexEligible' => '<p>Determines whether the recommendation is size flexible.</p>', 'RdsReservedInstancesConfiguration$sizeFlexEligible' => '<p>Determines whether the recommendation is size flexible.</p>', 'Recommendation$restartNeeded' => '<p>Whether or not implementing the recommendation requires a restart.</p>', 'Recommendation$rollbackPossible' => '<p>Whether or not implementing the recommendation can be rolled back.</p>', 'RedshiftReservedInstancesConfiguration$sizeFlexEligible' => '<p>Determines whether the recommendation is size flexible.</p>', 'UpdateEnrollmentStatusRequest$includeMemberAccounts' => '<p>Indicates whether to enroll member accounts of the organization if the account is the management account.</p>', ], ], 'ComputeConfiguration' => [ 'base' => '<p>Describes the performance configuration for compute services such as Amazon EC2, Lambda, and ECS.</p>', 'refs' => [ 'EcsServiceConfiguration$compute' => '<p>Details about the compute configuration.</p>', 'LambdaFunctionConfiguration$compute' => '<p>Details about the compute configuration.</p>', ], ], 'ComputeSavingsPlans' => [ 'base' => '<p>The Compute Savings Plans recommendation details.</p>', 'refs' => [ 'ResourceDetails$computeSavingsPlans' => '<p>The Compute Savings Plans recommendation details.</p>', ], ], 'ComputeSavingsPlansConfiguration' => [ 'base' => '<p>The Compute Savings Plans configuration used for recommendations.</p>', 'refs' => [ 'ComputeSavingsPlans$configuration' => '<p>Configuration details of the Compute Savings Plans to purchase.</p>', ], ], 'Datetime' => [ 'base' => NULL, 'refs' => [ 'GetRecommendationResponse$lastRefreshTimestamp' => '<p>The time when the recommendation was last generated.</p>', 'Recommendation$lastRefreshTimestamp' => '<p>The time when the recommendation was last generated.</p>', ], ], 'DbInstanceConfiguration' => [ 'base' => '<p>The DB instance configuration used for recommendations.</p>', 'refs' => [ 'RdsDbInstanceConfiguration$instance' => '<p>Details about the instance configuration.</p>', ], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'BlockStoragePerformanceConfiguration$iops' => '<p>The number of I/O operations per second.</p>', 'BlockStoragePerformanceConfiguration$throughput' => '<p>The throughput that the volume supports.</p>', 'ComputeConfiguration$vCpu' => '<p>The number of vCPU cores in the resource.</p>', 'EstimatedDiscounts$savingsPlansDiscount' => '<p>Estimated Savings Plans discounts.</p>', 'EstimatedDiscounts$reservedInstancesDiscount' => '<p>Estimated reserved instance discounts.</p>', 'EstimatedDiscounts$otherDiscount' => '<p>Estimated other discounts include all discounts that are not itemized. Itemized discounts include <code>reservedInstanceDiscount</code> and <code>savingsPlansDiscount</code>.</p>', 'GetRecommendationResponse$estimatedSavingsPercentage' => '<p>The estimated savings percentage relative to the total cost over the cost calculation lookback period.</p>', 'GetRecommendationResponse$estimatedSavingsOverCostCalculationLookbackPeriod' => '<p>The estimated savings amount over the lookback period used to calculate cost impact for a recommendation.</p>', 'GetRecommendationResponse$estimatedMonthlySavings' => '<p>The estimated monthly savings amount for the recommendation.</p>', 'GetRecommendationResponse$estimatedMonthlyCost' => '<p>The estimated monthly cost of the current resource. For Reserved Instances and Savings Plans, it refers to the cost for eligible usage.</p>', 'ListRecommendationSummariesResponse$estimatedTotalDedupedSavings' => '<p>The total overall savings for the aggregated view.</p>', 'RdsDbInstanceStorageConfiguration$allocatedStorageInGb' => '<p>The new amount of storage in GB to allocate for the DB instance.</p>', 'RdsDbInstanceStorageConfiguration$iops' => '<p>The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for the DB instance.</p>', 'RdsDbInstanceStorageConfiguration$storageThroughput' => '<p>The storage throughput for the DB instance.</p>', 'Recommendation$estimatedMonthlySavings' => '<p>The estimated monthly savings amount for the recommendation.</p>', 'Recommendation$estimatedSavingsPercentage' => '<p>The estimated savings percentage relative to the total cost over the cost calculation lookback period.</p>', 'Recommendation$estimatedMonthlyCost' => '<p>The estimated monthly cost of the current resource. For Reserved Instances and Savings Plans, it refers to the cost for eligible usage.</p>', 'RecommendationSummary$estimatedMonthlySavings' => '<p>The estimated total savings resulting from modifications, on a monthly basis.</p>', 'ReservedInstancesPricing$estimatedOnDemandCost' => '<p>The remaining On-Demand cost estimated to not be covered by the recommended reserved instance, over the length of the lookback period.</p>', 'ReservedInstancesPricing$monthlyReservationEligibleCost' => '<p>The cost of paying for the recommended reserved instance monthly.</p>', 'ReservedInstancesPricing$savingsPercentage' => '<p>The savings percentage relative to the total On-Demand costs that are associated with this instance.</p>', 'ReservedInstancesPricing$estimatedMonthlyAmortizedReservationCost' => '<p>The estimated cost of your recurring monthly fees for the recommended reserved instance across the month.</p>', 'ResourcePricing$estimatedCostBeforeDiscounts' => '<p>The savings estimate using Amazon Web Services public pricing without incorporating any discounts.</p>', 'ResourcePricing$estimatedNetUnusedAmortizedCommitments' => '<p>The estimated net unused amortized commitment for the recommendation.</p>', 'ResourcePricing$estimatedCostAfterDiscounts' => '<p>The savings estimate incorporating all discounts with Amazon Web Services, such as Reserved Instances and Savings Plans.</p>', 'SavingsPlansPricing$monthlySavingsPlansEligibleCost' => '<p>The cost of paying for the recommended Savings Plan monthly.</p>', 'SavingsPlansPricing$estimatedMonthlyCommitment' => '<p>Estimated monthly commitment for the Savings Plan.</p>', 'SavingsPlansPricing$savingsPercentage' => '<p>Estimated savings as a percentage of your overall costs after buying the Savings Plan.</p>', 'SavingsPlansPricing$estimatedOnDemandCost' => '<p>Estimated On-Demand cost you will pay after buying the Savings Plan.</p>', 'StorageConfiguration$sizeInGb' => '<p>The storage volume.</p>', 'Usage$usageAmount' => '<p>The usage amount.</p>', ], ], 'EbsVolume' => [ 'base' => '<p>Describes the Amazon Elastic Block Store volume configuration of the current and recommended resource configuration for a recommendation.</p>', 'refs' => [ 'ResourceDetails$ebsVolume' => '<p>The Amazon Elastic Block Store volume recommendation details.</p>', ], ], 'EbsVolumeConfiguration' => [ 'base' => '<p>The Amazon Elastic Block Store volume configuration used for recommendations.</p>', 'refs' => [ 'EbsVolume$configuration' => '<p>The Amazon Elastic Block Store volume configuration used for recommendations.</p>', ], ], 'Ec2AutoScalingGroup' => [ 'base' => '<p>The EC2 Auto Scaling group recommendation details.</p>', 'refs' => [ 'ResourceDetails$ec2AutoScalingGroup' => '<p>The EC2 Auto Scaling group recommendation details.</p>', ], ], 'Ec2AutoScalingGroupConfiguration' => [ 'base' => '<p>The EC2 auto scaling group configuration used for recommendations.</p>', 'refs' => [ 'Ec2AutoScalingGroup$configuration' => '<p>The EC2 Auto Scaling group configuration used for recommendations.</p>', ], ], 'Ec2Instance' => [ 'base' => '<p>Describes the EC2 instance configuration of the current and recommended resource configuration for a recommendation.</p>', 'refs' => [ 'ResourceDetails$ec2Instance' => '<p>The EC2 instance recommendation details.</p>', ], ], 'Ec2InstanceConfiguration' => [ 'base' => '<p>The EC2 instance configuration used for recommendations.</p>', 'refs' => [ 'Ec2Instance$configuration' => '<p>The EC2 instance configuration used for recommendations.</p>', ], ], 'Ec2InstanceSavingsPlans' => [ 'base' => '<p>The EC2 instance Savings Plans recommendation details.</p>', 'refs' => [ 'ResourceDetails$ec2InstanceSavingsPlans' => '<p>The EC2 instance Savings Plans recommendation details.</p>', ], ], 'Ec2InstanceSavingsPlansConfiguration' => [ 'base' => '<p>The EC2 instance Savings Plans configuration used for recommendations.</p>', 'refs' => [ 'Ec2InstanceSavingsPlans$configuration' => '<p>The EC2 instance Savings Plans configuration used for recommendations.</p>', ], ], 'Ec2ReservedInstances' => [ 'base' => '<p>The EC2 reserved instances recommendation details.</p>', 'refs' => [ 'ResourceDetails$ec2ReservedInstances' => '<p>The EC2 reserved instances recommendation details.</p>', ], ], 'Ec2ReservedInstancesConfiguration' => [ 'base' => '<p>The EC2 reserved instances configuration used for recommendations.</p>', 'refs' => [ 'Ec2ReservedInstances$configuration' => '<p>The EC2 reserved instances configuration used for recommendations.</p>', ], ], 'EcsService' => [ 'base' => '<p>The ECS service recommendation details.</p>', 'refs' => [ 'ResourceDetails$ecsService' => '<p>The ECS service recommendation details.</p>', ], ], 'EcsServiceConfiguration' => [ 'base' => '<p>The ECS service configuration used for recommendations.</p>', 'refs' => [ 'EcsService$configuration' => '<p>The ECS service configuration used for recommendations.</p>', ], ], 'ElastiCacheReservedInstances' => [ 'base' => '<p>The ElastiCache reserved instances recommendation details.</p>', 'refs' => [ 'ResourceDetails$elastiCacheReservedInstances' => '<p>The ElastiCache reserved instances recommendation details.</p>', ], ], 'ElastiCacheReservedInstancesConfiguration' => [ 'base' => '<p>The ElastiCache reserved instances configuration used for recommendations.</p>', 'refs' => [ 'ElastiCacheReservedInstances$configuration' => '<p>The ElastiCache reserved instances configuration used for recommendations.</p>', ], ], 'EnrollmentStatus' => [ 'base' => NULL, 'refs' => [ 'AccountEnrollmentStatus$status' => '<p>The account enrollment status.</p>', 'UpdateEnrollmentStatusRequest$status' => '<p>Sets the account status.</p>', ], ], 'EstimatedDiscounts' => [ 'base' => '<p>Estimated discount details of the current and recommended resource configuration for a recommendation.</p>', 'refs' => [ 'ResourcePricing$estimatedDiscounts' => '<p>The estimated discounts for a recommendation.</p>', ], ], 'Filter' => [ 'base' => '<p>Describes a filter that returns a more specific list of recommendations. Filters recommendations by different dimensions.</p>', 'refs' => [ 'ListRecommendationSummariesRequest$filter' => NULL, 'ListRecommendationsRequest$filter' => '<p>The constraints that you want all returned recommendations to match.</p>', ], ], 'GetPreferencesRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetPreferencesResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetRecommendationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetRecommendationResponse' => [ 'base' => NULL, 'refs' => [], ], 'ImplementationEffort' => [ 'base' => NULL, 'refs' => [ 'GetRecommendationResponse$implementationEffort' => '<p>The effort required to implement the recommendation.</p>', 'ImplementationEffortList$member' => NULL, ], ], 'ImplementationEffortList' => [ 'base' => NULL, 'refs' => [ 'Filter$implementationEfforts' => '<p>The effort required to implement the recommendation.</p>', ], ], 'InstanceConfiguration' => [ 'base' => '<p>The Instance configuration used for recommendations.</p>', 'refs' => [ 'Ec2AutoScalingGroupConfiguration$instance' => '<p>Details about the instance.</p>', 'Ec2InstanceConfiguration$instance' => '<p>Details about the instance.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'ComputeConfiguration$memorySizeInMB' => '<p>The memory size of the resource.</p>', 'GetRecommendationResponse$recommendationLookbackPeriodInDays' => '<p>The lookback period that\'s used to generate the recommendation.</p>', 'GetRecommendationResponse$costCalculationLookbackPeriodInDays' => '<p>The lookback period used to calculate cost impact for a recommendation.</p>', 'Recommendation$recommendationLookbackPeriodInDays' => '<p>The lookback period that\'s used to generate the recommendation.</p>', 'RecommendationSummary$recommendationCount' => '<p>The total number of instance recommendations.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>An error on the server occurred during the processing of your request. Try again later.</p>', 'refs' => [], ], 'LambdaFunction' => [ 'base' => '<p>The Lambda function recommendation details.</p>', 'refs' => [ 'ResourceDetails$lambdaFunction' => '<p>The Lambda function recommendation details.</p>', ], ], 'LambdaFunctionConfiguration' => [ 'base' => '<p>The Lambda function configuration used for recommendations.</p>', 'refs' => [ 'LambdaFunction$configuration' => '<p>The Lambda function configuration used for recommendations.</p>', ], ], 'ListEnrollmentStatusesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListEnrollmentStatusesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListRecommendationSummariesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRecommendationSummariesRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListRecommendationSummariesRequest$maxResults' => '<p>The maximum number of recommendations that are returned for the request.</p>', ], ], 'ListRecommendationSummariesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListRecommendationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRecommendationsRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListRecommendationsRequest$maxResults' => '<p>The maximum number of recommendations that are returned for the request.</p>', ], ], 'ListRecommendationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListEnrollmentStatusesRequest$maxResults' => '<p>The maximum number of objects that are returned for the request.</p>', ], ], 'MemberAccountDiscountVisibility' => [ 'base' => NULL, 'refs' => [ 'GetPreferencesResponse$memberAccountDiscountVisibility' => '<p>Retrieves the status of the "member account discount visibility" preference.</p>', 'UpdatePreferencesRequest$memberAccountDiscountVisibility' => '<p>Sets the "member account discount visibility" preference.</p>', 'UpdatePreferencesResponse$memberAccountDiscountVisibility' => '<p>Shows the status of the "member account discount visibility" preference.</p>', ], ], 'OpenSearchReservedInstances' => [ 'base' => '<p>The OpenSearch reserved instances recommendation details.</p>', 'refs' => [ 'ResourceDetails$openSearchReservedInstances' => '<p>The OpenSearch reserved instances recommendation details.</p>', ], ], 'OpenSearchReservedInstancesConfiguration' => [ 'base' => '<p>The OpenSearch reserved instances configuration used for recommendations.</p>', 'refs' => [ 'OpenSearchReservedInstances$configuration' => '<p>The OpenSearch reserved instances configuration used for recommendations.</p>', ], ], 'Order' => [ 'base' => NULL, 'refs' => [ 'OrderBy$order' => '<p>The order that\'s used to sort the data.</p>', ], ], 'OrderBy' => [ 'base' => '<p>Defines how rows will be sorted in the response.</p>', 'refs' => [ 'ListRecommendationsRequest$orderBy' => '<p>The ordering of recommendations by a dimension.</p>', ], ], 'PrimitiveBoolean' => [ 'base' => NULL, 'refs' => [ 'ListEnrollmentStatusesRequest$includeOrganizationInfo' => '<p>Indicates whether to return the enrollment status for the organization.</p>', 'ListRecommendationsRequest$includeAllRecommendations' => '<p>List of all recommendations for a resource, or a single recommendation if de-duped by <code>resourceId</code>.</p>', ], ], 'RdsDbInstance' => [ 'base' => '<p>Contains the details of an Amazon RDS DB instance.</p>', 'refs' => [ 'ResourceDetails$rdsDbInstance' => '<p>The DB instance recommendation details.</p>', ], ], 'RdsDbInstanceConfiguration' => [ 'base' => '<p>The Amazon RDS DB instance configuration used for recommendations.</p>', 'refs' => [ 'RdsDbInstance$configuration' => '<p>The Amazon RDS DB instance configuration used for recommendations.</p>', ], ], 'RdsDbInstanceStorage' => [ 'base' => '<p>Contains the details of an Amazon RDS DB instance storage.</p>', 'refs' => [ 'ResourceDetails$rdsDbInstanceStorage' => '<p>The DB instance storage recommendation details.</p>', ], ], 'RdsDbInstanceStorageConfiguration' => [ 'base' => '<p>The Amazon RDS DB instance storage configuration used for recommendations.</p>', 'refs' => [ 'RdsDbInstanceStorage$configuration' => '<p>The Amazon RDS DB instance storage configuration used for recommendations.</p>', ], ], 'RdsReservedInstances' => [ 'base' => '<p>The RDS reserved instances recommendation details.</p>', 'refs' => [ 'ResourceDetails$rdsReservedInstances' => '<p>The RDS reserved instances recommendation details.</p>', ], ], 'RdsReservedInstancesConfiguration' => [ 'base' => '<p>The RDS reserved instances configuration used for recommendations.</p>', 'refs' => [ 'RdsReservedInstances$configuration' => '<p>The RDS reserved instances configuration used for recommendations.</p>', ], ], 'Recommendation' => [ 'base' => '<p>Describes a recommendation.</p>', 'refs' => [ 'RecommendationList$member' => NULL, ], ], 'RecommendationIdList' => [ 'base' => NULL, 'refs' => [ 'Filter$recommendationIds' => '<p>The IDs for the recommendations.</p>', ], ], 'RecommendationList' => [ 'base' => NULL, 'refs' => [ 'ListRecommendationsResponse$items' => '<p>List of all savings recommendations.</p>', ], ], 'RecommendationSummariesList' => [ 'base' => NULL, 'refs' => [ 'ListRecommendationSummariesResponse$items' => '<p>List of all savings recommendations.</p>', ], ], 'RecommendationSummary' => [ 'base' => '<p>The summary of rightsizing recommendations, including de-duped savings from all types of recommendations.</p>', 'refs' => [ 'RecommendationSummariesList$member' => NULL, ], ], 'RedshiftReservedInstances' => [ 'base' => '<p>The Redshift reserved instances recommendation details.</p>', 'refs' => [ 'ResourceDetails$redshiftReservedInstances' => '<p>The Redshift reserved instances recommendation details.</p>', ], ], 'RedshiftReservedInstancesConfiguration' => [ 'base' => '<p>The Redshift reserved instances configuration used for recommendations.</p>', 'refs' => [ 'RedshiftReservedInstances$configuration' => '<p>The Redshift reserved instances configuration used for recommendations.</p>', ], ], 'RegionList' => [ 'base' => NULL, 'refs' => [ 'Filter$regions' => '<p>The Amazon Web Services Region of the resource.</p>', ], ], 'ReservedInstancesCostCalculation' => [ 'base' => '<p>Cost impact of the purchase recommendation.</p>', 'refs' => [ 'Ec2ReservedInstances$costCalculation' => '<p>Cost impact of the purchase recommendation.</p>', 'ElastiCacheReservedInstances$costCalculation' => '<p>Cost impact of the purchase recommendation.</p>', 'OpenSearchReservedInstances$costCalculation' => '<p>Cost impact of the purchase recommendation.</p>', 'RdsReservedInstances$costCalculation' => '<p>Cost impact of the purchase recommendation.</p>', 'RedshiftReservedInstances$costCalculation' => '<p>Cost impact of the purchase recommendation.</p>', ], ], 'ReservedInstancesPricing' => [ 'base' => '<p>Pricing details for your recommended reserved instance.</p>', 'refs' => [ 'ReservedInstancesCostCalculation$pricing' => '<p>Pricing details of the purchase recommendation.</p>', ], ], 'ResourceArnList' => [ 'base' => NULL, 'refs' => [ 'Filter$resourceArns' => '<p>The Amazon Resource Name (ARN) of the recommendation.</p>', ], ], 'ResourceCostCalculation' => [ 'base' => '<p>Cost impact of the resource recommendation.</p>', 'refs' => [ 'EbsVolume$costCalculation' => '<p>Cost impact of the recommendation.</p>', 'Ec2AutoScalingGroup$costCalculation' => '<p>Cost impact of the recommendation.</p>', 'Ec2Instance$costCalculation' => '<p>Cost impact of the recommendation.</p>', 'EcsService$costCalculation' => '<p>Cost impact of the recommendation.</p>', 'LambdaFunction$costCalculation' => '<p>Cost impact of the recommendation.</p>', 'RdsDbInstance$costCalculation' => NULL, 'RdsDbInstanceStorage$costCalculation' => NULL, ], ], 'ResourceDetails' => [ 'base' => '<p>Contains detailed information about the specified resource.</p>', 'refs' => [ 'GetRecommendationResponse$currentResourceDetails' => '<p>The details for the resource.</p>', 'GetRecommendationResponse$recommendedResourceDetails' => '<p>The details about the recommended resource.</p>', ], ], 'ResourceIdList' => [ 'base' => NULL, 'refs' => [ 'Filter$resourceIds' => '<p>The resource ID of the recommendation.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The specified Amazon Resource Name (ARN) in the request doesn\'t exist.</p>', 'refs' => [], ], 'ResourcePricing' => [ 'base' => '<p>Contains pricing information about the specified resource.</p>', 'refs' => [ 'ResourceCostCalculation$pricing' => '<p>Pricing details of the resource recommendation.</p>', ], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'GetRecommendationResponse$currentResourceType' => '<p>The type of resource.</p>', 'GetRecommendationResponse$recommendedResourceType' => '<p>The resource type of the recommendation.</p>', 'ResourceTypeList$member' => NULL, ], ], 'ResourceTypeList' => [ 'base' => NULL, 'refs' => [ 'Filter$resourceTypes' => '<p>The resource type of the recommendation.</p>', ], ], 'SageMakerSavingsPlans' => [ 'base' => '<p>The SageMaker Savings Plans recommendation details.</p>', 'refs' => [ 'ResourceDetails$sageMakerSavingsPlans' => '<p>The SageMaker Savings Plans recommendation details.</p>', ], ], 'SageMakerSavingsPlansConfiguration' => [ 'base' => '<p>The SageMaker Savings Plans configuration used for recommendations.</p>', 'refs' => [ 'SageMakerSavingsPlans$configuration' => '<p>The SageMaker Savings Plans configuration used for recommendations.</p>', ], ], 'SavingsEstimationMode' => [ 'base' => NULL, 'refs' => [ 'GetPreferencesResponse$savingsEstimationMode' => '<p>Retrieves the status of the "savings estimation mode" preference.</p>', 'UpdatePreferencesRequest$savingsEstimationMode' => '<p>Sets the "savings estimation mode" preference.</p>', 'UpdatePreferencesResponse$savingsEstimationMode' => '<p>Shows the status of the "savings estimation mode" preference.</p>', ], ], 'SavingsPlansCostCalculation' => [ 'base' => '<p>Cost impact of the purchase recommendation.</p>', 'refs' => [ 'ComputeSavingsPlans$costCalculation' => '<p>Cost impact of the Savings Plans purchase recommendation.</p>', 'Ec2InstanceSavingsPlans$costCalculation' => '<p>Cost impact of the Savings Plans purchase recommendation.</p>', 'SageMakerSavingsPlans$costCalculation' => '<p>Cost impact of the Savings Plans purchase recommendation.</p>', ], ], 'SavingsPlansPricing' => [ 'base' => '<p>Pricing information about a Savings Plan.</p>', 'refs' => [ 'SavingsPlansCostCalculation$pricing' => '<p>Pricing details of the purchase recommendation.</p>', ], ], 'Source' => [ 'base' => NULL, 'refs' => [ 'GetRecommendationResponse$source' => '<p>The source of the recommendation.</p>', 'Recommendation$source' => '<p>The source of the recommendation.</p>', ], ], 'StorageConfiguration' => [ 'base' => '<p>The storage configuration used for recommendations.</p>', 'refs' => [ 'EbsVolumeConfiguration$storage' => '<p>The disk storage of the Amazon Elastic Block Store volume.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'ComputeConfiguration$architecture' => '<p>The architecture of the resource.</p>', 'ComputeConfiguration$platform' => '<p>The platform of the resource. The platform is the specific combination of operating system, license model, and software on an instance.</p>', 'ComputeSavingsPlansConfiguration$accountScope' => '<p>The account scope that you want your recommendations for. Amazon Web Services calculates recommendations including the management account and member accounts if the value is set to <code>PAYER</code>. If the value is <code>LINKED</code>, recommendations are calculated for individual member accounts only.</p>', 'ComputeSavingsPlansConfiguration$term' => '<p>The Savings Plans recommendation term in years.</p>', 'ComputeSavingsPlansConfiguration$paymentOption' => '<p>The payment option for the commitment.</p>', 'ComputeSavingsPlansConfiguration$hourlyCommitment' => '<p>The hourly commitment for the Savings Plans type.</p>', 'DbInstanceConfiguration$dbInstanceClass' => '<p>The DB instance class of the DB instance.</p>', 'EbsVolumeConfiguration$attachmentState' => '<p>The Amazon Elastic Block Store attachment state.</p>', 'Ec2InstanceSavingsPlansConfiguration$accountScope' => '<p>The account scope that you want your recommendations for.</p>', 'Ec2InstanceSavingsPlansConfiguration$term' => '<p>The Savings Plans recommendation term in years.</p>', 'Ec2InstanceSavingsPlansConfiguration$paymentOption' => '<p>The payment option for the commitment.</p>', 'Ec2InstanceSavingsPlansConfiguration$hourlyCommitment' => '<p>The hourly commitment for the Savings Plans type.</p>', 'Ec2InstanceSavingsPlansConfiguration$instanceFamily' => '<p>The instance family of the recommended Savings Plan.</p>', 'Ec2InstanceSavingsPlansConfiguration$savingsPlansRegion' => '<p>The Amazon Web Services Region of the commitment.</p>', 'Ec2ReservedInstancesConfiguration$accountScope' => '<p>The account scope that you want your recommendations for.</p>', 'Ec2ReservedInstancesConfiguration$service' => '<p>The service that you want your recommendations for.</p>', 'Ec2ReservedInstancesConfiguration$normalizedUnitsToPurchase' => '<p>The number of normalized units that Amazon Web Services recommends that you purchase.</p>', 'Ec2ReservedInstancesConfiguration$term' => '<p>The reserved instances recommendation term in years.</p>', 'Ec2ReservedInstancesConfiguration$paymentOption' => '<p>The payment option for the commitment.</p>', 'Ec2ReservedInstancesConfiguration$numberOfInstancesToPurchase' => '<p>The number of instances that Amazon Web Services recommends that you purchase.</p>', 'Ec2ReservedInstancesConfiguration$offeringClass' => '<p>Indicates whether the recommendation is for standard or convertible reservations.</p>', 'Ec2ReservedInstancesConfiguration$instanceFamily' => '<p>The instance family of the recommended reservation.</p>', 'Ec2ReservedInstancesConfiguration$instanceType' => '<p>The type of instance that Amazon Web Services recommends.</p>', 'Ec2ReservedInstancesConfiguration$reservedInstancesRegion' => '<p>The Amazon Web Services Region of the commitment.</p>', 'Ec2ReservedInstancesConfiguration$currentGeneration' => '<p>Determines whether the recommendation is for a current generation instance.</p>', 'Ec2ReservedInstancesConfiguration$platform' => '<p>The platform of the recommended reservation. The platform is the specific combination of operating system, license model, and software on an instance.</p>', 'Ec2ReservedInstancesConfiguration$tenancy' => '<p>Determines whether the recommended reservation is dedicated or shared.</p>', 'Ec2ReservedInstancesConfiguration$upfrontCost' => '<p>How much purchasing this instance costs you upfront.</p>', 'Ec2ReservedInstancesConfiguration$monthlyRecurringCost' => '<p>How much purchasing reserved instances costs you on a monthly basis.</p>', 'ElastiCacheReservedInstancesConfiguration$accountScope' => '<p>The account scope that you want your recommendations for.</p>', 'ElastiCacheReservedInstancesConfiguration$service' => '<p>The service that you want your recommendations for.</p>', 'ElastiCacheReservedInstancesConfiguration$normalizedUnitsToPurchase' => '<p>The number of normalized units that Amazon Web Services recommends that you purchase.</p>', 'ElastiCacheReservedInstancesConfiguration$term' => '<p>The reserved instances recommendation term in years.</p>', 'ElastiCacheReservedInstancesConfiguration$paymentOption' => '<p>The payment option for the commitment.</p>', 'ElastiCacheReservedInstancesConfiguration$numberOfInstancesToPurchase' => '<p>The number of instances that Amazon Web Services recommends that you purchase.</p>', 'ElastiCacheReservedInstancesConfiguration$instanceFamily' => '<p>The instance family of the recommended reservation.</p>', 'ElastiCacheReservedInstancesConfiguration$instanceType' => '<p>The type of instance that Amazon Web Services recommends.</p>', 'ElastiCacheReservedInstancesConfiguration$reservedInstancesRegion' => '<p>The Amazon Web Services Region of the commitment.</p>', 'ElastiCacheReservedInstancesConfiguration$currentGeneration' => '<p>Determines whether the recommendation is for a current generation instance.</p>', 'ElastiCacheReservedInstancesConfiguration$upfrontCost' => '<p>How much purchasing this instance costs you upfront.</p>', 'ElastiCacheReservedInstancesConfiguration$monthlyRecurringCost' => '<p>How much purchasing reserved instances costs you on a monthly basis.</p>', 'GetRecommendationRequest$recommendationId' => '<p>The ID for the recommendation.</p>', 'GetRecommendationResponse$recommendationId' => '<p>The ID for the recommendation.</p>', 'GetRecommendationResponse$resourceId' => '<p>The unique identifier for the resource. This is the same as the Amazon Resource Name (ARN), if available.</p>', 'GetRecommendationResponse$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'GetRecommendationResponse$accountId' => '<p>The account that the recommendation is for.</p>', 'GetRecommendationResponse$currencyCode' => '<p>The currency code used for the recommendation.</p>', 'GetRecommendationResponse$region' => '<p>The Amazon Web Services Region of the resource.</p>', 'InstanceConfiguration$type' => '<p>Details about the type.</p>', 'InternalServerException$message' => NULL, 'ListEnrollmentStatusesRequest$nextToken' => '<p>The token to retrieve the next set of results.</p>', 'ListEnrollmentStatusesResponse$nextToken' => '<p>The token to retrieve the next set of results.</p>', 'ListRecommendationSummariesRequest$groupBy' => '<p>The grouping of recommendations by a dimension.</p>', 'ListRecommendationSummariesRequest$nextToken' => '<p>The token to retrieve the next set of results.</p>', 'ListRecommendationSummariesResponse$groupBy' => '<p>The dimension used to group the recommendations by.</p>', 'ListRecommendationSummariesResponse$currencyCode' => '<p>The currency code used for the recommendation.</p>', 'ListRecommendationSummariesResponse$nextToken' => '<p>The token to retrieve the next set of results.</p>', 'ListRecommendationsRequest$nextToken' => '<p>The token to retrieve the next set of results.</p>', 'ListRecommendationsResponse$nextToken' => '<p>The token to retrieve the next set of results.</p>', 'OpenSearchReservedInstancesConfiguration$accountScope' => '<p>The account scope that you want your recommendations for.</p>', 'OpenSearchReservedInstancesConfiguration$service' => '<p>The service that you want your recommendations for.</p>', 'OpenSearchReservedInstancesConfiguration$normalizedUnitsToPurchase' => '<p>The number of normalized units that Amazon Web Services recommends that you purchase.</p>', 'OpenSearchReservedInstancesConfiguration$term' => '<p>The reserved instances recommendation term in years.</p>', 'OpenSearchReservedInstancesConfiguration$paymentOption' => '<p>The payment option for the commitment.</p>', 'OpenSearchReservedInstancesConfiguration$numberOfInstancesToPurchase' => '<p>The number of instances that Amazon Web Services recommends that you purchase.</p>', 'OpenSearchReservedInstancesConfiguration$instanceType' => '<p>The type of instance that Amazon Web Services recommends.</p>', 'OpenSearchReservedInstancesConfiguration$reservedInstancesRegion' => '<p>The Amazon Web Services Region of the commitment.</p>', 'OpenSearchReservedInstancesConfiguration$currentGeneration' => '<p>Determines whether the recommendation is for a current generation instance.</p>', 'OpenSearchReservedInstancesConfiguration$upfrontCost' => '<p>How much purchasing this instance costs you upfront.</p>', 'OpenSearchReservedInstancesConfiguration$monthlyRecurringCost' => '<p>How much purchasing reserved instances costs you on a monthly basis.</p>', 'OrderBy$dimension' => '<p>Sorts by dimension values.</p>', 'RdsDbInstanceStorageConfiguration$storageType' => '<p>The storage type to associate with the DB instance.</p>', 'RdsReservedInstancesConfiguration$accountScope' => '<p>The account scope that you want your recommendations for.</p>', 'RdsReservedInstancesConfiguration$service' => '<p>The service that you want your recommendations for.</p>', 'RdsReservedInstancesConfiguration$normalizedUnitsToPurchase' => '<p>The number of normalized units that Amazon Web Services recommends that you purchase.</p>', 'RdsReservedInstancesConfiguration$term' => '<p>The reserved instances recommendation term in years.</p>', 'RdsReservedInstancesConfiguration$paymentOption' => '<p>The payment option for the commitment.</p>', 'RdsReservedInstancesConfiguration$numberOfInstancesToPurchase' => '<p>The number of instances that Amazon Web Services recommends that you purchase.</p>', 'RdsReservedInstancesConfiguration$instanceFamily' => '<p>The instance family of the recommended reservation.</p>', 'RdsReservedInstancesConfiguration$instanceType' => '<p>The type of instance that Amazon Web Services recommends.</p>', 'RdsReservedInstancesConfiguration$reservedInstancesRegion' => '<p>The Amazon Web Services Region of the commitment.</p>', 'RdsReservedInstancesConfiguration$currentGeneration' => '<p>Determines whether the recommendation is for a current generation instance.</p>', 'RdsReservedInstancesConfiguration$upfrontCost' => '<p>How much purchasing this instance costs you upfront.</p>', 'RdsReservedInstancesConfiguration$monthlyRecurringCost' => '<p>How much purchasing this instance costs you on a monthly basis.</p>', 'RdsReservedInstancesConfiguration$licenseModel' => '<p>The license model that the recommended reservation supports.</p>', 'RdsReservedInstancesConfiguration$databaseEdition' => '<p>The database edition that the recommended reservation supports.</p>', 'RdsReservedInstancesConfiguration$databaseEngine' => '<p>The database engine that the recommended reservation supports.</p>', 'RdsReservedInstancesConfiguration$deploymentOption' => '<p>Determines whether the recommendation is for a reservation in a single Availability Zone or a reservation with a backup in a second Availability Zone.</p>', 'Recommendation$recommendationId' => '<p>The ID for the recommendation.</p>', 'Recommendation$accountId' => '<p>The account that the recommendation is for.</p>', 'Recommendation$region' => '<p>The Amazon Web Services Region of the resource.</p>', 'Recommendation$resourceId' => '<p>The resource ID for the recommendation.</p>', 'Recommendation$resourceArn' => '<p>The Amazon Resource Name (ARN) for the recommendation.</p>', 'Recommendation$currentResourceType' => '<p>The current resource type.</p>', 'Recommendation$recommendedResourceType' => '<p>The recommended resource type.</p>', 'Recommendation$currencyCode' => '<p>The currency code used for the recommendation.</p>', 'Recommendation$implementationEffort' => '<p>The effort required to implement the recommendation.</p>', 'Recommendation$actionType' => '<p>The type of tasks that can be carried out by this action.</p>', 'Recommendation$currentResourceSummary' => '<p>Describes the current resource.</p>', 'Recommendation$recommendedResourceSummary' => '<p>Describes the recommended resource.</p>', 'RecommendationIdList$member' => NULL, 'RecommendationSummary$group' => '<p>The grouping of recommendations.</p>', 'RedshiftReservedInstancesConfiguration$accountScope' => '<p>The account scope that you want your recommendations for.</p>', 'RedshiftReservedInstancesConfiguration$service' => '<p>The service that you want your recommendations for.</p>', 'RedshiftReservedInstancesConfiguration$normalizedUnitsToPurchase' => '<p>The number of normalized units that Amazon Web Services recommends that you purchase.</p>', 'RedshiftReservedInstancesConfiguration$term' => '<p>The reserved instances recommendation term in years.</p>', 'RedshiftReservedInstancesConfiguration$paymentOption' => '<p>The payment option for the commitment.</p>', 'RedshiftReservedInstancesConfiguration$numberOfInstancesToPurchase' => '<p>The number of instances that Amazon Web Services recommends that you purchase.</p>', 'RedshiftReservedInstancesConfiguration$instanceFamily' => '<p>The instance family of the recommended reservation.</p>', 'RedshiftReservedInstancesConfiguration$instanceType' => '<p>The type of instance that Amazon Web Services recommends.</p>', 'RedshiftReservedInstancesConfiguration$reservedInstancesRegion' => '<p>The Amazon Web Services Region of the commitment.</p>', 'RedshiftReservedInstancesConfiguration$currentGeneration' => '<p>Determines whether the recommendation is for a current generation instance.</p>', 'RedshiftReservedInstancesConfiguration$upfrontCost' => '<p>How much purchasing this instance costs you upfront.</p>', 'RedshiftReservedInstancesConfiguration$monthlyRecurringCost' => '<p>How much purchasing reserved instances costs you on a monthly basis.</p>', 'RegionList$member' => NULL, 'ResourceArnList$member' => NULL, 'ResourceIdList$member' => NULL, 'ResourceNotFoundException$message' => NULL, 'ResourceNotFoundException$resourceId' => '<p>The identifier of the resource that was not found.</p>', 'SageMakerSavingsPlansConfiguration$accountScope' => '<p>The account scope that you want your recommendations for.</p>', 'SageMakerSavingsPlansConfiguration$term' => '<p>The Savings Plans recommendation term in years.</p>', 'SageMakerSavingsPlansConfiguration$paymentOption' => '<p>The payment option for the commitment.</p>', 'SageMakerSavingsPlansConfiguration$hourlyCommitment' => '<p>The hourly commitment for the Savings Plans type.</p>', 'StorageConfiguration$type' => '<p>The storage type.</p>', 'Tag$key' => '<p>The key that\'s associated with the tag.</p>', 'Tag$value' => '<p>The value that\'s associated with the tag.</p>', 'ThrottlingException$message' => NULL, 'UpdateEnrollmentStatusResponse$status' => '<p>The enrollment status of the account.</p>', 'Usage$usageType' => '<p>The usage type.</p>', 'Usage$operation' => '<p>The operation value.</p>', 'Usage$productCode' => '<p>The product code.</p>', 'Usage$unit' => '<p>The usage unit.</p>', 'ValidationException$message' => NULL, 'ValidationExceptionDetail$fieldName' => '<p>The field name where the invalid entry was detected.</p>', 'ValidationExceptionDetail$message' => '<p>A message with the reason for the validation exception error.</p>', ], ], 'Tag' => [ 'base' => '<p>The tag structure that contains a tag key and value.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'Filter$tags' => '<p>A list of tags assigned to the recommendation.</p>', 'GetRecommendationResponse$tags' => '<p>A list of tags associated with the resource for which the recommendation exists.</p>', 'Recommendation$tags' => '<p>A list of tags assigned to the recommendation.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The request was denied due to request throttling.</p>', 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'AccountEnrollmentStatus$lastUpdatedTimestamp' => '<p>The time when the account enrollment status was last updated.</p>', 'AccountEnrollmentStatus$createdTimestamp' => '<p>The time when the account enrollment status was created.</p>', ], ], 'UpdateEnrollmentStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEnrollmentStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePreferencesRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePreferencesResponse' => [ 'base' => NULL, 'refs' => [], ], 'Usage' => [ 'base' => '<p>Details about the usage.</p>', 'refs' => [ 'UsageList$member' => NULL, ], ], 'UsageList' => [ 'base' => NULL, 'refs' => [ 'ResourceCostCalculation$usages' => '<p>Usage details of the resource recommendation.</p>', ], ], 'ValidationException' => [ 'base' => '<p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>', 'refs' => [], ], 'ValidationExceptionDetail' => [ 'base' => '<p>The input failed to meet the constraints specified by the Amazon Web Services service in a specified field.</p>', 'refs' => [ 'ValidationExceptionDetails$member' => NULL, ], ], 'ValidationExceptionDetails' => [ 'base' => NULL, 'refs' => [ 'ValidationException$fields' => '<p>The list of fields that are invalid.</p>', ], ], 'ValidationExceptionReason' => [ 'base' => NULL, 'refs' => [ 'ValidationException$reason' => '<p>The reason for the validation exception.</p>', ], ], ],];
