<?php
// This file was auto-generated from sdk-root/src/data/datazone/2018-05-10/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Amazon DataZone is a data management service that enables you to catalog, discover, govern, share, and analyze your data. With Amazon DataZone, you can share and access your data across accounts and supported regions. Amazon DataZone simplifies your experience across Amazon Web Services services, including, but not limited to, Amazon Redshift, Amazon Athena, Amazon Web Services Glue, and Amazon Web Services Lake Formation.</p>', 'operations' => [ 'AcceptPredictions' => '<p>Accepts automatically generated business-friendly metadata for your Amazon DataZone assets.</p>', 'AcceptSubscriptionRequest' => '<p>Accepts a subscription request to a specific asset. </p>', 'AssociateEnvironmentRole' => '<p>Associates the environment role in Amazon DataZone.</p>', 'CancelMetadataGenerationRun' => '<p>Cancels the metadata generation run.</p>', 'CancelSubscription' => '<p>Cancels the subscription to the specified asset.</p>', 'CreateAsset' => '<p>Creates an asset in Amazon DataZone catalog.</p>', 'CreateAssetRevision' => '<p>Creates a revision of the asset.</p>', 'CreateAssetType' => '<p>Creates a custom asset type.</p>', 'CreateDataSource' => '<p>Creates an Amazon DataZone data source.</p>', 'CreateDomain' => '<p>Creates an Amazon DataZone domain.</p>', 'CreateEnvironment' => '<p>Create an Amazon DataZone environment.</p>', 'CreateEnvironmentAction' => '<p>Creates an action for the environment, for example, creates a console link for an analytics tool that is available in this environment.</p>', 'CreateEnvironmentProfile' => '<p>Creates an Amazon DataZone environment profile.</p>', 'CreateFormType' => '<p>Creates a metadata form type.</p>', 'CreateGlossary' => '<p>Creates an Amazon DataZone business glossary.</p>', 'CreateGlossaryTerm' => '<p>Creates a business glossary term.</p>', 'CreateGroupProfile' => '<p>Creates a group profile in Amazon DataZone.</p>', 'CreateListingChangeSet' => '<p>Publishes a listing (a record of an asset at a given time) or removes a listing from the catalog. </p>', 'CreateProject' => '<p>Creates an Amazon DataZone project.</p>', 'CreateProjectMembership' => '<p>Creates a project membership in Amazon DataZone.</p>', 'CreateSubscriptionGrant' => '<p>Creates a subsscription grant in Amazon DataZone.</p>', 'CreateSubscriptionRequest' => '<p>Creates a subscription request in Amazon DataZone.</p>', 'CreateSubscriptionTarget' => '<p>Creates a subscription target in Amazon DataZone.</p>', 'CreateUserProfile' => '<p>Creates a user profile in Amazon DataZone.</p>', 'DeleteAsset' => '<p>Delets an asset in Amazon DataZone.</p>', 'DeleteAssetType' => '<p>Deletes an asset type in Amazon DataZone.</p>', 'DeleteDataSource' => '<p>Deletes a data source in Amazon DataZone.</p>', 'DeleteDomain' => '<p>Deletes a Amazon DataZone domain.</p>', 'DeleteEnvironment' => '<p>Deletes an environment in Amazon DataZone.</p>', 'DeleteEnvironmentAction' => '<p>Deletes an action for the environment, for example, deletes a console link for an analytics tool that is available in this environment.</p>', 'DeleteEnvironmentBlueprintConfiguration' => '<p>Deletes the blueprint configuration in Amazon DataZone.</p>', 'DeleteEnvironmentProfile' => '<p>Deletes an environment profile in Amazon DataZone.</p>', 'DeleteFormType' => '<p>Delets and metadata form type in Amazon DataZone.</p>', 'DeleteGlossary' => '<p>Deletes a business glossary in Amazon DataZone.</p>', 'DeleteGlossaryTerm' => '<p>Deletes a business glossary term in Amazon DataZone.</p>', 'DeleteListing' => '<p>Deletes a listing (a record of an asset at a given time).</p>', 'DeleteProject' => '<p>Deletes a project in Amazon DataZone. </p>', 'DeleteProjectMembership' => '<p>Deletes project membership in Amazon DataZone.</p>', 'DeleteSubscriptionGrant' => '<p>Deletes and subscription grant in Amazon DataZone.</p>', 'DeleteSubscriptionRequest' => '<p>Deletes a subscription request in Amazon DataZone.</p>', 'DeleteSubscriptionTarget' => '<p>Deletes a subscription target in Amazon DataZone.</p>', 'DeleteTimeSeriesDataPoints' => '<p>Deletes the specified time series form for the specified asset. </p>', 'DisassociateEnvironmentRole' => '<p>Disassociates the environment role in Amazon DataZone.</p>', 'GetAsset' => '<p>Gets an Amazon DataZone asset.</p>', 'GetAssetType' => '<p>Gets an Amazon DataZone asset type.</p>', 'GetDataSource' => '<p>Gets an Amazon DataZone data source.</p>', 'GetDataSourceRun' => '<p>Gets an Amazon DataZone data source run.</p>', 'GetDomain' => '<p>Gets an Amazon DataZone domain.</p>', 'GetEnvironment' => '<p>Gets an Amazon DataZone environment.</p>', 'GetEnvironmentAction' => '<p>Gets the specified environment action.</p>', 'GetEnvironmentBlueprint' => '<p>Gets an Amazon DataZone blueprint.</p>', 'GetEnvironmentBlueprintConfiguration' => '<p>Gets the blueprint configuration in Amazon DataZone.</p>', 'GetEnvironmentProfile' => '<p>Gets an evinronment profile in Amazon DataZone.</p>', 'GetFormType' => '<p>Gets a metadata form type in Amazon DataZone.</p>', 'GetGlossary' => '<p>Gets a business glossary in Amazon DataZone.</p>', 'GetGlossaryTerm' => '<p>Gets a business glossary term in Amazon DataZone.</p>', 'GetGroupProfile' => '<p>Gets a group profile in Amazon DataZone.</p>', 'GetIamPortalLoginUrl' => '<p>Gets the data portal URL for the specified Amazon DataZone domain.</p>', 'GetLineageNode' => '<p>Gets the data lineage node.</p>', 'GetListing' => '<p>Gets a listing (a record of an asset at a given time).</p>', 'GetMetadataGenerationRun' => '<p>Gets a metadata generation run in Amazon DataZone.</p>', 'GetProject' => '<p>Gets a project in Amazon DataZone.</p>', 'GetSubscription' => '<p>Gets a subscription in Amazon DataZone.</p>', 'GetSubscriptionGrant' => '<p>Gets the subscription grant in Amazon DataZone.</p>', 'GetSubscriptionRequestDetails' => '<p>Gets the details of the specified subscription request.</p>', 'GetSubscriptionTarget' => '<p>Gets the subscription target in Amazon DataZone.</p>', 'GetTimeSeriesDataPoint' => '<p>Gets the existing data point for the asset.</p>', 'GetUserProfile' => '<p>Gets a user profile in Amazon DataZone.</p>', 'ListAssetRevisions' => '<p>Lists the revisions for the asset.</p>', 'ListDataSourceRunActivities' => '<p>Lists data source run activities.</p>', 'ListDataSourceRuns' => '<p>Lists data source runs in Amazon DataZone.</p>', 'ListDataSources' => '<p>Lists data sources in Amazon DataZone.</p>', 'ListDomains' => '<p>Lists Amazon DataZone domains.</p>', 'ListEnvironmentActions' => '<p>Lists existing environment actions.</p>', 'ListEnvironmentBlueprintConfigurations' => '<p>Lists blueprint configurations for a Amazon DataZone environment.</p>', 'ListEnvironmentBlueprints' => '<p>Lists blueprints in an Amazon DataZone environment.</p>', 'ListEnvironmentProfiles' => '<p>Lists Amazon DataZone environment profiles.</p>', 'ListEnvironments' => '<p>Lists Amazon DataZone environments.</p>', 'ListLineageNodeHistory' => '<p>Lists the history of the specified data lineage node.</p>', 'ListMetadataGenerationRuns' => '<p>Lists all metadata generation runs.</p>', 'ListNotifications' => '<p>Lists all Amazon DataZone notifications.</p>', 'ListProjectMemberships' => '<p>Lists all members of the specified project.</p>', 'ListProjects' => '<p>Lists Amazon DataZone projects.</p>', 'ListSubscriptionGrants' => '<p>Lists subscription grants.</p>', 'ListSubscriptionRequests' => '<p>Lists Amazon DataZone subscription requests.</p>', 'ListSubscriptionTargets' => '<p>Lists subscription targets in Amazon DataZone.</p>', 'ListSubscriptions' => '<p>Lists subscriptions in Amazon DataZone.</p>', 'ListTagsForResource' => '<p>Lists tags for the specified resource in Amazon DataZone.</p>', 'ListTimeSeriesDataPoints' => '<p>Lists time series data points.</p>', 'PostLineageEvent' => '<p>Posts a data lineage event.</p>', 'PostTimeSeriesDataPoints' => '<p>Posts time series data points to Amazon DataZone for the specified asset.</p>', 'PutEnvironmentBlueprintConfiguration' => '<p>Writes the configuration for the specified environment blueprint in Amazon DataZone.</p>', 'RejectPredictions' => '<p>Rejects automatically generated business-friendly metadata for your Amazon DataZone assets.</p>', 'RejectSubscriptionRequest' => '<p>Rejects the specified subscription request.</p>', 'RevokeSubscription' => '<p>Revokes a specified subscription in Amazon DataZone.</p>', 'Search' => '<p>Searches for assets in Amazon DataZone.</p>', 'SearchGroupProfiles' => '<p>Searches group profiles in Amazon DataZone.</p>', 'SearchListings' => '<p>Searches listings (records of an asset at a given time) in Amazon DataZone.</p>', 'SearchTypes' => '<p>Searches for types in Amazon DataZone.</p>', 'SearchUserProfiles' => '<p>Searches user profiles in Amazon DataZone.</p>', 'StartDataSourceRun' => '<p>Start the run of the specified data source in Amazon DataZone.</p>', 'StartMetadataGenerationRun' => '<p>Starts the metadata generation run.</p>', 'TagResource' => '<p>Tags a resource in Amazon DataZone.</p>', 'UntagResource' => '<p>Untags a resource in Amazon DataZone.</p>', 'UpdateDataSource' => '<p>Updates the specified data source in Amazon DataZone.</p>', 'UpdateDomain' => '<p>Updates a Amazon DataZone domain.</p>', 'UpdateEnvironment' => '<p>Updates the specified environment in Amazon DataZone.</p>', 'UpdateEnvironmentAction' => '<p>Updates an environment action.</p>', 'UpdateEnvironmentProfile' => '<p>Updates the specified environment profile in Amazon DataZone.</p>', 'UpdateGlossary' => '<p>Updates the business glossary in Amazon DataZone.</p>', 'UpdateGlossaryTerm' => '<p>Updates a business glossary term in Amazon DataZone.</p>', 'UpdateGroupProfile' => '<p>Updates the specified group profile in Amazon DataZone.</p>', 'UpdateProject' => '<p>Updates the specified project in Amazon DataZone.</p>', 'UpdateSubscriptionGrantStatus' => '<p>Updates the status of the specified subscription grant status in Amazon DataZone.</p>', 'UpdateSubscriptionRequest' => '<p>Updates a specified subscription request in Amazon DataZone.</p>', 'UpdateSubscriptionTarget' => '<p>Updates the specified subscription target in Amazon DataZone.</p>', 'UpdateUserProfile' => '<p>Updates the specified user profile in Amazon DataZone.</p>', ], 'shapes' => [ 'AcceptChoice' => [ 'base' => '<p>Specifies the prediction (aka, the automatically generated piece of metadata) and the target (for example, a column name) that can be accepted.</p>', 'refs' => [ 'AcceptChoices$member' => NULL, ], ], 'AcceptChoices' => [ 'base' => NULL, 'refs' => [ 'AcceptPredictionsInput$acceptChoices' => '<p>Specifies the prediction (aka, the automatically generated piece of metadata) and the target (for example, a column name) that can be accepted.</p>', ], ], 'AcceptPredictionsInput' => [ 'base' => NULL, 'refs' => [], ], 'AcceptPredictionsOutput' => [ 'base' => NULL, 'refs' => [], ], 'AcceptRule' => [ 'base' => '<p>Specifies the rule and the threshold under which a prediction can be accepted.</p>', 'refs' => [ 'AcceptPredictionsInput$acceptRule' => '<p>Specifies the rule (or the conditions) under which a prediction can be accepted.</p>', ], ], 'AcceptRuleBehavior' => [ 'base' => NULL, 'refs' => [ 'AcceptRule$rule' => '<p>Specifies whether you want to accept the top prediction for all targets or none.</p>', ], ], 'AcceptSubscriptionRequestInput' => [ 'base' => NULL, 'refs' => [], ], 'AcceptSubscriptionRequestOutput' => [ 'base' => NULL, 'refs' => [], ], 'AcceptSubscriptionRequestOutputSubscribedListingsList' => [ 'base' => NULL, 'refs' => [ 'AcceptSubscriptionRequestOutput$subscribedListings' => '<p>Specifies the asset for which the subscription request was created.</p>', ], ], 'AcceptSubscriptionRequestOutputSubscribedPrincipalsList' => [ 'base' => NULL, 'refs' => [ 'AcceptSubscriptionRequestOutput$subscribedPrincipals' => '<p>Specifies the Amazon DataZone users who are subscribed to the asset specified in the subscription request.</p>', ], ], 'AccessDeniedException' => [ 'base' => '<p>You do not have sufficient access to perform this action.</p>', 'refs' => [], ], 'ActionLink' => [ 'base' => NULL, 'refs' => [ 'NotificationOutput$actionLink' => '<p>The action link included in the notification.</p>', ], ], 'ActionParameters' => [ 'base' => '<p>The parameters of the environment action.</p>', 'refs' => [ 'CreateEnvironmentActionInput$parameters' => '<p>The parameters of the environment action.</p>', 'CreateEnvironmentActionOutput$parameters' => '<p>The parameters of the environment action.</p>', 'EnvironmentActionSummary$parameters' => '<p>The parameters of the environment action.</p>', 'GetEnvironmentActionOutput$parameters' => '<p>The parameters of the environment action.</p>', 'UpdateEnvironmentActionInput$parameters' => '<p>The parameters of the environment action.</p>', 'UpdateEnvironmentActionOutput$parameters' => '<p>The parameters of the environment action.</p>', ], ], 'ApplicableAssetTypes' => [ 'base' => NULL, 'refs' => [ 'CreateSubscriptionTargetInput$applicableAssetTypes' => '<p>The asset types that can be included in the subscription target.</p>', 'CreateSubscriptionTargetOutput$applicableAssetTypes' => '<p>The asset types that can be included in the subscription target.</p>', 'GetSubscriptionTargetOutput$applicableAssetTypes' => '<p>The asset types associated with the subscription target.</p>', 'SubscriptionTargetSummary$applicableAssetTypes' => '<p>The asset types included in the subscription target.</p>', 'UpdateSubscriptionTargetInput$applicableAssetTypes' => '<p>The applicable asset types to be updated as part of the <code>UpdateSubscriptionTarget</code> action.</p>', 'UpdateSubscriptionTargetOutput$applicableAssetTypes' => '<p>The applicable asset types to be updated as part of the <code>UpdateSubscriptionTarget</code> action.</p>', ], ], 'AssetId' => [ 'base' => NULL, 'refs' => [ 'AcceptPredictionsOutput$assetId' => '<p>The ID of the asset.</p>', 'AssetListing$assetId' => '<p>The identifier of an asset published in an Amazon DataZone catalog. </p>', 'AssetListingItem$entityId' => '<p>The identifier of the inventory asset.</p>', 'AssetRevision$id' => '<p>The identifier of the inventory asset revision.</p>', 'AssetTargetNameMap$assetId' => '<p>The identifier of the inventory asset.</p>', 'CreateAssetOutput$id' => '<p>The unique identifier of the created asset.</p>', 'CreateAssetRevisionOutput$id' => '<p>The unique identifier of the asset revision.</p>', 'GetAssetOutput$id' => '<p>The ID of the asset.</p>', 'RejectPredictionsOutput$assetId' => '<p>The ID of the asset.</p>', 'SubscribedAsset$assetId' => '<p>The identifier of the asset for which the subscription grant is created.</p>', 'SubscribedAssetListing$entityId' => '<p>The identifier of the published asset for which the subscription grant is created.</p>', 'UpdateSubscriptionGrantStatusInput$assetIdentifier' => '<p>The identifier of the asset the subscription grant status of which is to be updated.</p>', ], ], 'AssetIdentifier' => [ 'base' => NULL, 'refs' => [ 'AcceptPredictionsInput$identifier' => '<p>The identifier of the asset.</p>', 'AssetItem$identifier' => '<p>the identifier of the Amazon DataZone inventory asset.</p>', 'CreateAssetRevisionInput$identifier' => '<p>The identifier of the asset.</p>', 'DeleteAssetInput$identifier' => '<p>The identifier of the asset that is deleted.</p>', 'GetAssetInput$identifier' => '<p>The ID of the Amazon DataZone asset.</p>', 'ListAssetRevisionsInput$identifier' => '<p>The identifier of the asset.</p>', 'RejectPredictionsInput$identifier' => '<p>The identifier of the prediction.</p>', ], ], 'AssetItem' => [ 'base' => '<p>A Amazon DataZone inventory asset.</p>', 'refs' => [ 'SearchInventoryResultItem$assetItem' => '<p>The asset item included in the search results.</p>', ], ], 'AssetItemAdditionalAttributes' => [ 'base' => '<p>The additional attributes of an inventory asset.</p>', 'refs' => [ 'AssetItem$additionalAttributes' => '<p>The additional attributes of a Amazon DataZone inventory asset. </p>', ], ], 'AssetListing' => [ 'base' => '<p>An asset published in an Amazon DataZone catalog.</p>', 'refs' => [ 'ListingItem$assetListing' => '<p>An asset published in an Amazon DataZone catalog.</p>', ], ], 'AssetListingDetails' => [ 'base' => '<p>The details of an asset published in an Amazon DataZone catalog. </p>', 'refs' => [ 'CreateAssetOutput$listing' => '<p>The details of an asset published in an Amazon DataZone catalog.</p>', 'CreateAssetRevisionOutput$listing' => '<p>The details of an asset published in an Amazon DataZone catalog. </p>', 'GetAssetOutput$listing' => '<p>The listing of the asset.</p>', ], ], 'AssetListingItem' => [ 'base' => '<p>The details of an asset published in an Amazon DataZone catalog.</p>', 'refs' => [ 'SearchResultItem$assetListing' => '<p>The asset listing included in the results of the <code>SearchListings</code> action.</p>', ], ], 'AssetListingItemAdditionalAttributes' => [ 'base' => '<p>Additional attributes of an inventory asset.</p>', 'refs' => [ 'AssetListingItem$additionalAttributes' => '<p>The additional attributes of an asset published in an Amazon DataZone catalog.</p>', ], ], 'AssetName' => [ 'base' => NULL, 'refs' => [ 'AssetItem$name' => '<p>The name of the Amazon DataZone inventory asset.</p>', 'AssetListingItem$name' => '<p>The name of the inventory asset.</p>', 'CreateAssetInput$name' => '<p>Asset name.</p>', 'CreateAssetOutput$name' => '<p>The name of the created asset.</p>', 'CreateAssetRevisionInput$name' => '<p>Te revised name of the asset.</p>', 'CreateAssetRevisionOutput$name' => '<p>The revised name of the asset.</p>', 'GetAssetOutput$name' => '<p>The name of the asset.</p>', ], ], 'AssetRevision' => [ 'base' => '<p>The revision of an inventory asset.</p>', 'refs' => [ 'AssetRevisions$member' => NULL, ], ], 'AssetRevisions' => [ 'base' => NULL, 'refs' => [ 'ListAssetRevisionsOutput$items' => '<p>The results of the <code>ListAssetRevisions</code> action.</p>', ], ], 'AssetTargetNameMap' => [ 'base' => '<p>The name map for assets.</p>', 'refs' => [ 'AssetTargetNames$member' => NULL, ], ], 'AssetTargetNames' => [ 'base' => NULL, 'refs' => [ 'CreateSubscriptionGrantInput$assetTargetNames' => '<p>The names of the assets for which the subscription grant is created.</p>', ], ], 'AssetTypeIdentifier' => [ 'base' => NULL, 'refs' => [ 'AssetItem$typeIdentifier' => '<p>The identifier of the asset type of the specified Amazon DataZone inventory asset.</p>', 'CreateAssetInput$typeIdentifier' => '<p>The unique identifier of this asset\'s type.</p>', 'CreateAssetOutput$typeIdentifier' => '<p>The identifier of the created asset type.</p>', 'CreateAssetRevisionOutput$typeIdentifier' => '<p>The identifier of the revision type.</p>', 'DeleteAssetTypeInput$identifier' => '<p>The identifier of the asset type that is deleted.</p>', 'GetAssetOutput$typeIdentifier' => '<p>The ID of the asset type.</p>', 'GetAssetTypeInput$identifier' => '<p>The ID of the asset type.</p>', ], ], 'AssetTypeItem' => [ 'base' => '<p>The details of the asset type.</p>', 'refs' => [ 'SearchTypesResultItem$assetTypeItem' => '<p>The asset type included in the results of the <code>SearchTypes</code> action.</p>', ], ], 'AssociateEnvironmentRoleInput' => [ 'base' => NULL, 'refs' => [], ], 'AssociateEnvironmentRoleOutput' => [ 'base' => NULL, 'refs' => [], ], 'Attribute' => [ 'base' => NULL, 'refs' => [ 'Filter$attribute' => '<p>A search filter attribute in Amazon DataZone.</p>', 'SearchInItem$attribute' => '<p>The search attribute.</p>', 'SearchSort$attribute' => '<p>The attribute detail of the way to sort search results.</p>', ], ], 'AuthType' => [ 'base' => NULL, 'refs' => [ 'SingleSignOn$type' => '<p>The type of single sign-on in Amazon DataZone.</p>', ], ], 'AuthorizedPrincipalIdentifier' => [ 'base' => NULL, 'refs' => [ 'AuthorizedPrincipalIdentifiers$member' => NULL, ], ], 'AuthorizedPrincipalIdentifiers' => [ 'base' => NULL, 'refs' => [ 'CreateSubscriptionTargetInput$authorizedPrincipals' => '<p>The authorized principals of the subscription target.</p>', 'CreateSubscriptionTargetOutput$authorizedPrincipals' => '<p>The authorised principals of the subscription target.</p>', 'GetSubscriptionTargetOutput$authorizedPrincipals' => '<p>The authorized principals of the subscription target.</p>', 'SubscriptionTargetSummary$authorizedPrincipals' => '<p>The authorized principals included in the subscription target.</p>', 'UpdateSubscriptionTargetInput$authorizedPrincipals' => '<p>The authorized principals to be updated as part of the <code>UpdateSubscriptionTarget</code> action.</p>', 'UpdateSubscriptionTargetOutput$authorizedPrincipals' => '<p>The authorized principals to be updated as part of the <code>UpdateSubscriptionTarget</code> action.</p>', ], ], 'AwsAccountId' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentOutput$awsAccountId' => '<p>The Amazon Web Services account in which the Amazon DataZone environment is created.</p>', 'CreateEnvironmentProfileInput$awsAccountId' => '<p>The Amazon Web Services account in which the Amazon DataZone environment is created.</p>', 'CreateEnvironmentProfileOutput$awsAccountId' => '<p>The Amazon Web Services account ID in which this Amazon DataZone environment profile is created.</p>', 'EnvironmentProfileSummary$awsAccountId' => '<p>The identifier of an Amazon Web Services account in which an environment profile exists.</p>', 'EnvironmentSummary$awsAccountId' => '<p>The identifier of the Amazon Web Services account in which an environment exists.</p>', 'GetEnvironmentOutput$awsAccountId' => '<p>The ID of the Amazon Web Services account where the environment exists.</p>', 'GetEnvironmentProfileOutput$awsAccountId' => '<p>The ID of the Amazon Web Services account where this environment profile exists.</p>', 'ListEnvironmentProfilesInput$awsAccountId' => '<p>The identifier of the Amazon Web Services account where you want to list environment profiles.</p>', 'ListEnvironmentsInput$awsAccountId' => '<p>The identifier of the Amazon Web Services account where you want to list environments.</p>', 'UpdateEnvironmentOutput$awsAccountId' => '<p>The identifier of the Amazon Web Services account in which the environment is to be updated.</p>', 'UpdateEnvironmentProfileInput$awsAccountId' => '<p>The Amazon Web Services account in which a specified environment profile is to be udpated.</p>', 'UpdateEnvironmentProfileOutput$awsAccountId' => '<p>The Amazon Web Services account in which a specified environment profile is to be udpated.</p>', ], ], 'AwsConsoleLinkParameters' => [ 'base' => '<p>The parameters of the console link specified as part of the environment action.</p>', 'refs' => [ 'ActionParameters$awsConsoleLink' => '<p>The console link specified as part of the environment action.</p>', ], ], 'AwsRegion' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentOutput$awsAccountRegion' => '<p>The Amazon Web Services region in which the Amazon DataZone environment is created.</p>', 'CreateEnvironmentProfileInput$awsAccountRegion' => '<p>The Amazon Web Services region in which this environment profile is created.</p>', 'CreateEnvironmentProfileOutput$awsAccountRegion' => '<p>The Amazon Web Services region in which this Amazon DataZone environment profile is created.</p>', 'EnvironmentProfileSummary$awsAccountRegion' => '<p>The Amazon Web Services Region in which an environment profile exists.</p>', 'EnvironmentSummary$awsAccountRegion' => '<p>The Amazon Web Services Region in which an environment exists.</p>', 'GetEnvironmentOutput$awsAccountRegion' => '<p>The Amazon Web Services region where the environment exists.</p>', 'GetEnvironmentProfileOutput$awsAccountRegion' => '<p>The Amazon Web Services region where this environment profile exists.</p>', 'ListEnvironmentProfilesInput$awsAccountRegion' => '<p>The Amazon Web Services region where you want to list environment profiles.</p>', 'ListEnvironmentsInput$awsAccountRegion' => '<p>The Amazon Web Services region where you want to list environments.</p>', 'UpdateEnvironmentOutput$awsAccountRegion' => '<p>The Amazon Web Services Region in which the environment is updated.</p>', 'UpdateEnvironmentProfileInput$awsAccountRegion' => '<p>The Amazon Web Services Region in which a specified environment profile is to be updated.</p>', 'UpdateEnvironmentProfileOutput$awsAccountRegion' => '<p>The Amazon Web Services Region in which a specified environment profile is to be updated.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'BusinessNameGenerationConfiguration$enabled' => '<p>Specifies whether the business name generation is enabled.</p>', 'CancelSubscriptionOutput$retainPermissions' => '<p>Specifies whether the permissions to the asset are retained after the subscription is cancelled.</p>', 'CreateDataSourceInput$publishOnImport' => '<p>Specifies whether the assets that this data source creates in the inventory are to be also automatically published to the catalog.</p>', 'CreateDataSourceOutput$publishOnImport' => '<p>Specifies whether the assets that this data source creates in the inventory are to be also automatically published to the catalog.</p>', 'CustomParameter$isEditable' => '<p>Specifies whether the parameter is editable.</p>', 'CustomParameter$isOptional' => '<p>Specifies whether the custom parameter is optional.</p>', 'DeleteDataSourceInput$retainPermissionsOnRevokeFailure' => '<p>Specifies that the granted permissions are retained in case of a self-subscribe functionality failure for a data source.</p>', 'DeleteDataSourceOutput$publishOnImport' => '<p>Specifies whether the assets that this data source creates in the inventory are to be also automatically published to the catalog.</p>', 'DeleteDataSourceOutput$retainPermissionsOnRevokeFailure' => '<p>Specifies that the granted permissions are retained in case of a self-subscribe functionality failure for a data source.</p>', 'DeleteDomainInput$skipDeletionCheck' => '<p>Specifies the optional flag to delete all child entities within the domain.</p>', 'DeleteProjectInput$skipDeletionCheck' => '<p>Specifies the optional flag to delete all child entities within the project.</p>', 'Deployment$isDeploymentComplete' => '<p>Specifies whether the last deployment of the environment is complete.</p>', 'FormEntryInput$required' => '<p>Specifies whether a form entry is required.</p>', 'FormEntryOutput$required' => '<p>Specifies whether a form entry is required.</p>', 'GetDataSourceOutput$publishOnImport' => '<p>Specifies whether the assets that this data source creates in the inventory are to be also automatically published to the catalog.</p>', 'GetSubscriptionOutput$retainPermissions' => '<p>The retain permissions of the subscription.</p>', 'GlueRunConfigurationInput$autoImportDataQualityResult' => '<p>Specifies whether to automatically import data quality metrics as part of the data source run.</p>', 'GlueRunConfigurationOutput$autoImportDataQualityResult' => '<p>Specifies whether to automatically import data quality metrics as part of the data source run.</p>', 'ListEnvironmentBlueprintsInput$managed' => '<p>Specifies whether the environment blueprint is managed by Amazon DataZone.</p>', 'RecommendationConfiguration$enableBusinessNameGeneration' => '<p>Specifies whether automatic business name generation is to be enabled or not as part of the recommendation configuration.</p>', 'RevokeSubscriptionInput$retainPermissions' => '<p>Specifies whether permissions are retained when the subscription is revoked.</p>', 'RevokeSubscriptionOutput$retainPermissions' => '<p>Specifies whether permissions are retained when the subscription is revoked.</p>', 'SearchTypesInput$managed' => '<p>Specifies whether the search is managed.</p>', 'SubscriptionSummary$retainPermissions' => '<p>The retain permissions included in the subscription.</p>', 'UpdateDataSourceInput$publishOnImport' => '<p>The publish on import setting to be updated as part of the <code>UpdateDataSource</code> action.</p>', 'UpdateDataSourceInput$retainPermissionsOnRevokeFailure' => '<p>Specifies that the granted permissions are retained in case of a self-subscribe functionality failure for a data source.</p>', 'UpdateDataSourceOutput$publishOnImport' => '<p>The publish on import setting to be updated as part of the <code>UpdateDataSource</code> action.</p>', 'UpdateDataSourceOutput$retainPermissionsOnRevokeFailure' => '<p>Specifies that the granted permissions are retained in case of a self-subscribe functionality failure for a data source.</p>', ], ], 'BusinessNameGenerationConfiguration' => [ 'base' => '<p>The configuration of the business name generation.</p>', 'refs' => [ 'PredictionConfiguration$businessNameGeneration' => '<p>The business name generation mechanism.</p>', ], ], 'CancelMetadataGenerationRunInput' => [ 'base' => NULL, 'refs' => [], ], 'CancelMetadataGenerationRunOutput' => [ 'base' => NULL, 'refs' => [], ], 'CancelSubscriptionInput' => [ 'base' => NULL, 'refs' => [], ], 'CancelSubscriptionOutput' => [ 'base' => NULL, 'refs' => [], ], 'ChangeAction' => [ 'base' => NULL, 'refs' => [ 'CreateListingChangeSetInput$action' => '<p>Specifies whether to publish or unpublish a listing.</p>', ], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'AcceptPredictionsInput$clientToken' => '<p>A unique, case-sensitive identifier to ensure idempotency of the request. This field is automatically populated if not provided.</p>', 'CreateAssetInput$clientToken' => '<p>A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.</p>', 'CreateAssetRevisionInput$clientToken' => '<p>A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.</p>', 'CreateGlossaryInput$clientToken' => '<p>A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.</p>', 'CreateGlossaryTermInput$clientToken' => '<p>A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.</p>', 'CreateListingChangeSetInput$clientToken' => '<p>A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.</p>', 'DeleteTimeSeriesDataPointsInput$clientToken' => '<p>A unique, case-sensitive identifier to ensure idempotency of the request. This field is automatically populated if not provided.</p>', 'PostLineageEventInput$clientToken' => '<p>A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.</p>', 'PostTimeSeriesDataPointsInput$clientToken' => '<p>A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.</p>', 'RejectPredictionsInput$clientToken' => '<p>A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.</p>', 'StartMetadataGenerationRunInput$clientToken' => '<p>A unique, case-sensitive identifier to ensure idempotency of the request. This field is automatically populated if not provided.</p>', 'UpdateGlossaryInput$clientToken' => '<p>A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.</p>', ], ], 'CloudFormationProperties' => [ 'base' => '<p>Part of the provisioning properties of the environment blueprint.</p>', 'refs' => [ 'ProvisioningProperties$cloudFormation' => '<p>The cloud formation properties included as part of the provisioning properties of an environment blueprint.</p>', ], ], 'ConfigurableActionParameter' => [ 'base' => '<p>The details of the parameters for the configurable environment action.</p>', 'refs' => [ 'ConfigurableActionParameterList$member' => NULL, ], ], 'ConfigurableActionParameterList' => [ 'base' => NULL, 'refs' => [ 'ConfigurableEnvironmentAction$parameters' => '<p>The parameters of a configurable action in a Amazon DataZone environment.</p>', ], ], 'ConfigurableActionTypeAuthorization' => [ 'base' => NULL, 'refs' => [ 'ConfigurableEnvironmentAction$auth' => '<p>The authentication type of a configurable action of a Amazon DataZone environment. </p>', ], ], 'ConfigurableEnvironmentAction' => [ 'base' => '<p>The configurable action of a Amazon DataZone environment.</p>', 'refs' => [ 'EnvironmentActionList$member' => NULL, ], ], 'ConflictException' => [ 'base' => '<p>There is a conflict while performing this action.</p>', 'refs' => [], ], 'CreateAssetInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateAssetOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateAssetRevisionInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateAssetRevisionOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateAssetTypeInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateAssetTypeOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateDataSourceInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateDataSourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateDomainInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateDomainOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateEnvironmentActionInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateEnvironmentActionOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateEnvironmentInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateEnvironmentOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateEnvironmentProfileInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateEnvironmentProfileOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateFormTypeInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateFormTypeOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateGlossaryInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateGlossaryOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateGlossaryTermInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateGlossaryTermOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateGroupProfileInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateGroupProfileOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateListingChangeSetInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateListingChangeSetOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateProjectInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateProjectMembershipInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateProjectMembershipOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateProjectOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateSubscriptionGrantInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateSubscriptionGrantOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateSubscriptionRequestInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateSubscriptionRequestOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateSubscriptionRequestOutputSubscribedListingsList' => [ 'base' => NULL, 'refs' => [ 'CreateSubscriptionRequestOutput$subscribedListings' => '<p>The published asset for which the subscription grant is to be created.</p>', ], ], 'CreateSubscriptionRequestOutputSubscribedPrincipalsList' => [ 'base' => NULL, 'refs' => [ 'CreateSubscriptionRequestOutput$subscribedPrincipals' => '<p>The subscribed principals of the subscription request.</p>', ], ], 'CreateSubscriptionTargetInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateSubscriptionTargetOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateUserProfileInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateUserProfileOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreatedAt' => [ 'base' => NULL, 'refs' => [ 'AcceptSubscriptionRequestOutput$createdAt' => '<p>The timestamp that specifies when the subscription request was accepted.</p>', 'AssetItem$createdAt' => '<p>The timestamp of when the Amazon DataZone inventory asset was created.</p>', 'AssetItem$firstRevisionCreatedAt' => '<p>The timestamp of when the first revision of the inventory asset was created.</p>', 'AssetListing$createdAt' => '<p>The timestamp of when an asset published in an Amazon DataZone catalog was created. </p>', 'AssetListingItem$createdAt' => '<p>The timestamp of when an asset published in an Amazon DataZone catalog was created.</p>', 'AssetRevision$createdAt' => '<p>The timestamp of when an inventory asset revison was created.</p>', 'AssetTypeItem$createdAt' => '<p>The timestamp of when the asset type was created.</p>', 'CancelSubscriptionOutput$createdAt' => '<p>The timestamp that specifies when the request to cancel the subscription was created.</p>', 'CreateAssetOutput$createdAt' => '<p>The timestamp of when the asset was created.</p>', 'CreateAssetOutput$firstRevisionCreatedAt' => '<p>The timestamp of when the first revision of the asset took place.</p>', 'CreateAssetRevisionOutput$createdAt' => '<p>The timestamp of when the asset revision occured.</p>', 'CreateAssetRevisionOutput$firstRevisionCreatedAt' => '<p>The timestamp of when the first asset revision occured.</p>', 'CreateAssetTypeOutput$createdAt' => '<p>The timestamp of when the asset type is to be created.</p>', 'CreateSubscriptionGrantOutput$createdAt' => '<p>A timestamp of when the subscription grant is created.</p>', 'CreateSubscriptionRequestOutput$createdAt' => '<p>A timestamp of when the subscription request is created.</p>', 'CreateSubscriptionTargetOutput$createdAt' => '<p>The timestamp of when the subscription target was created.</p>', 'DataProductSummary$createdAt' => '<p/>', 'DeleteSubscriptionGrantOutput$createdAt' => '<p>The timestamp of when the subscription grant that is deleted was created.</p>', 'DomainSummary$createdAt' => '<p>A timestamp of when a Amazon DataZone domain was created.</p>', 'FormTypeData$createdAt' => '<p>The timestamp of when the metadata form type was created.</p>', 'GetAssetOutput$createdAt' => '<p>The timestamp of when the asset was created.</p>', 'GetAssetOutput$firstRevisionCreatedAt' => '<p>The timestamp of when the first revision of the asset was created.</p>', 'GetAssetTypeOutput$createdAt' => '<p>The timestamp of when the asset type was created.</p>', 'GetDomainOutput$createdAt' => '<p>The timestamp of when the Amazon DataZone domain was created.</p>', 'GetFormTypeOutput$createdAt' => '<p>The timestamp of when this metadata form type was created.</p>', 'GetGlossaryOutput$createdAt' => '<p>The timestamp of when this business glossary was created.</p>', 'GetGlossaryTermOutput$createdAt' => '<p>The timestamp of when the business glossary term was created.</p>', 'GetLineageNodeOutput$createdAt' => '<p>The timestamp at which the data lineage node was created.</p>', 'GetListingOutput$createdAt' => '<p>The timestamp of when the listing was created.</p>', 'GetMetadataGenerationRunOutput$createdAt' => '<p>The timestamp of when the metadata generation run was start.</p>', 'GetSubscriptionGrantOutput$createdAt' => '<p>The timestamp of when the subscription grant is created.</p>', 'GetSubscriptionOutput$createdAt' => '<p>The timestamp of when the subscription was created.</p>', 'GetSubscriptionRequestDetailsOutput$createdAt' => '<p>The timestamp of when the specified subscription request was created.</p>', 'GetSubscriptionTargetOutput$createdAt' => '<p>The timestamp of when the subscription target was created.</p>', 'GlossaryItem$createdAt' => '<p>The timestamp of when the glossary was created.</p>', 'GlossaryTermItem$createdAt' => '<p>The timestamp of when a business glossary term was created.</p>', 'LineageNodeSummary$createdAt' => '<p>The timestamp at which the data lineage node was created.</p>', 'LineageNodeTypeItem$createdAt' => '<p>The timestamp at which the data lineage node type was created.</p>', 'MetadataGenerationRunItem$createdAt' => '<p>The timestamp at which the metadata generation run was created.</p>', 'RejectSubscriptionRequestOutput$createdAt' => '<p>The timestamp of when the subscription request was rejected.</p>', 'RevokeSubscriptionOutput$createdAt' => '<p>The timestamp of when the subscription was revoked.</p>', 'StartMetadataGenerationRunOutput$createdAt' => '<p>The timestamp at which the metadata generation run was started.</p>', 'SubscriptionGrantSummary$createdAt' => '<p>The timestamp of when a subscription grant was created.</p>', 'SubscriptionRequestSummary$createdAt' => '<p>The timestamp of when a subscription request was created.</p>', 'SubscriptionSummary$createdAt' => '<p>The timestamp of when the subscription was created.</p>', 'SubscriptionTargetSummary$createdAt' => '<p>The timestamp of when the subscription target was created.</p>', 'UpdateSubscriptionGrantStatusOutput$createdAt' => '<p>The timestamp of when the subscription grant status was created.</p>', 'UpdateSubscriptionRequestOutput$createdAt' => '<p>The timestamp of when the subscription request was created.</p>', 'UpdateSubscriptionTargetOutput$createdAt' => '<p>The timestamp of when a subscription target was created.</p>', ], ], 'CreatedBy' => [ 'base' => NULL, 'refs' => [ 'AcceptSubscriptionRequestOutput$createdBy' => '<p>Specifies the Amazon DataZone user that accepted the specified subscription request.</p>', 'AssetItem$createdBy' => '<p>The Amazon DataZone user who created the inventory asset.</p>', 'AssetItem$firstRevisionCreatedBy' => '<p>The Amazon DataZone user who created the first revision of the inventory asset.</p>', 'AssetListingItem$listingCreatedBy' => '<p>The Amazon DataZone user who created the listing.</p>', 'AssetRevision$createdBy' => '<p>The Amazon DataZone user who created the asset revision.</p>', 'AssetTypeItem$createdBy' => '<p>The Amazon DataZone user who created the asset type.</p>', 'CancelSubscriptionOutput$createdBy' => '<p>Specifies the Amazon DataZone user who is cancelling the subscription.</p>', 'CreateAssetOutput$createdBy' => '<p>The Amazon DataZone user that created this asset in the catalog.</p>', 'CreateAssetOutput$firstRevisionCreatedBy' => '<p>The Amazon DataZone user that made the first revision of the asset.</p>', 'CreateAssetRevisionOutput$createdBy' => '<p>The Amazon DataZone user who performed the asset revision.</p>', 'CreateAssetRevisionOutput$firstRevisionCreatedBy' => '<p>The Amazon DataZone user who performed the first asset revision.</p>', 'CreateAssetTypeOutput$createdBy' => '<p>The Amazon DataZone user who creates this custom asset type.</p>', 'CreateProjectOutput$createdBy' => '<p>The Amazon DataZone user who created the project.</p>', 'CreateSubscriptionGrantOutput$createdBy' => '<p>The Amazon DataZone user who created the subscription grant.</p>', 'CreateSubscriptionRequestOutput$createdBy' => '<p>The Amazon DataZone user who created the subscription request.</p>', 'CreateSubscriptionTargetOutput$createdBy' => '<p>The Amazon DataZone user who created the subscription target.</p>', 'DataProductSummary$createdBy' => '<p/>', 'DeleteSubscriptionGrantOutput$createdBy' => '<p>The Amazon DataZone user who created the subscription grant that is deleted.</p>', 'FormTypeData$createdBy' => '<p>The Amazon DataZone user who created teh metadata form type.</p>', 'GetAssetOutput$createdBy' => '<p>The Amazon DataZone user who created the asset.</p>', 'GetAssetOutput$firstRevisionCreatedBy' => '<p>The Amazon DataZone user who created the first revision of the asset.</p>', 'GetAssetTypeOutput$createdBy' => '<p>The Amazon DataZone user who created the asset type.</p>', 'GetFormTypeOutput$createdBy' => '<p>The Amazon DataZone user who created this metadata form type.</p>', 'GetGlossaryOutput$createdBy' => '<p>The Amazon DataZone user who created this business glossary.</p>', 'GetGlossaryTermOutput$createdBy' => '<p>The Amazon DataZone user who created the business glossary.</p>', 'GetLineageNodeOutput$createdBy' => '<p>The user who created the data lineage node.</p>', 'GetListingOutput$createdBy' => '<p>The Amazon DataZone user who created the listing.</p>', 'GetMetadataGenerationRunOutput$createdBy' => '<p>The Amazon DataZone user who started the metadata generation run.</p>', 'GetProjectOutput$createdBy' => '<p>The Amazon DataZone user who created the project.</p>', 'GetSubscriptionGrantOutput$createdBy' => '<p>The Amazon DataZone user who created the subscription grant.</p>', 'GetSubscriptionOutput$createdBy' => '<p>The Amazon DataZone user who created the subscription.</p>', 'GetSubscriptionRequestDetailsOutput$createdBy' => '<p>The Amazon DataZone user who created the subscription request.</p>', 'GetSubscriptionTargetOutput$createdBy' => '<p>The Amazon DataZone user who created the subscription target.</p>', 'GlossaryItem$createdBy' => '<p>The Amazon DataZone user who created the glossary.</p>', 'GlossaryTermItem$createdBy' => '<p>The Amazon DataZone user who created the business glossary.</p>', 'LineageNodeSummary$createdBy' => '<p>The user who created the data lineage node.</p>', 'LineageNodeTypeItem$createdBy' => '<p>The user who created the data lineage node type.</p>', 'MetadataGenerationRunItem$createdBy' => '<p>The user who created the metadata generation run.</p>', 'ProjectSummary$createdBy' => '<p>The Amazon DataZone user who created the project.</p>', 'RejectSubscriptionRequestOutput$createdBy' => '<p>The timestamp of when the subscription request was rejected.</p>', 'RevokeSubscriptionOutput$createdBy' => '<p>The identifier of the user who revoked the subscription.</p>', 'StartMetadataGenerationRunOutput$createdBy' => '<p>The ID of the user who started the metadata generation run.</p>', 'SubscriptionGrantSummary$createdBy' => '<p>The datazone user who created the subscription grant.</p>', 'SubscriptionRequestSummary$createdBy' => '<p>The Amazon DataZone user who created the subscription request.</p>', 'SubscriptionSummary$createdBy' => '<p>The Amazon DataZone user who created the subscription.</p>', 'SubscriptionTargetSummary$createdBy' => '<p>The Amazon DataZone user who created the subscription target.</p>', 'UpdateProjectOutput$createdBy' => '<p>The Amazon DataZone user who created the project.</p>', 'UpdateSubscriptionGrantStatusOutput$createdBy' => '<p>The Amazon DataZone domain user who created the subscription grant status.</p>', 'UpdateSubscriptionRequestOutput$createdBy' => '<p>The Amazon DataZone user who created the subscription request.</p>', 'UpdateSubscriptionTargetOutput$createdBy' => '<p>The Amazon DataZone user who created the subscription target.</p>', ], ], 'CronString' => [ 'base' => NULL, 'refs' => [ 'ScheduleConfiguration$schedule' => '<p>The schedule of the data source runs.</p>', ], ], 'CustomParameter' => [ 'base' => '<p>The details of user parameters of an environment blueprint.</p>', 'refs' => [ 'CustomParameterList$member' => NULL, ], ], 'CustomParameterKeyNameString' => [ 'base' => NULL, 'refs' => [ 'CustomParameter$keyName' => '<p>The key name of the parameter.</p>', ], ], 'CustomParameterList' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentOutput$userParameters' => '<p>The user parameters of this Amazon DataZone environment.</p>', 'CreateEnvironmentProfileOutput$userParameters' => '<p>The user parameters of this Amazon DataZone environment profile.</p>', 'GetEnvironmentBlueprintOutput$userParameters' => '<p>The user parameters of this blueprint.</p>', 'GetEnvironmentOutput$userParameters' => '<p>The user parameters of this Amazon DataZone environment.</p>', 'GetEnvironmentProfileOutput$userParameters' => '<p>The user parameters of the environment profile.</p>', 'UpdateEnvironmentOutput$userParameters' => '<p>The user parameters to be updated as part of the <code>UpdateEnvironment</code> action.</p>', 'UpdateEnvironmentProfileOutput$userParameters' => '<p>The user parameters to be updated as part of the <code>UpdateEnvironmentProfile</code> action.</p>', ], ], 'DataAssetActivityStatus' => [ 'base' => NULL, 'refs' => [ 'DataSourceRunActivity$dataAssetStatus' => '<p>The status of the asset included in the data source run activity.</p>', 'ListDataSourceRunActivitiesInput$status' => '<p>The status of the data source run.</p>', ], ], 'DataPointIdentifier' => [ 'base' => NULL, 'refs' => [ 'TimeSeriesDataPointFormOutput$id' => '<p>The ID of the time series data points form.</p>', 'TimeSeriesDataPointSummaryFormOutput$id' => '<p>The ID of the time series data points summary form.</p>', ], ], 'DataProductDescription' => [ 'base' => NULL, 'refs' => [ 'DataProductSummary$description' => '<p/>', ], ], 'DataProductId' => [ 'base' => NULL, 'refs' => [ 'DataProductItem$itemId' => '<p/>', 'DataProductSummary$id' => '<p/>', ], ], 'DataProductItem' => [ 'base' => '<p/>', 'refs' => [ 'DataProductItems$member' => NULL, ], ], 'DataProductItems' => [ 'base' => NULL, 'refs' => [ 'DataProductSummary$dataProductItems' => '<p/>', ], ], 'DataProductName' => [ 'base' => NULL, 'refs' => [ 'DataProductSummary$name' => '<p/>', ], ], 'DataProductSummary' => [ 'base' => '<p/>', 'refs' => [ 'SearchInventoryResultItem$dataProductItem' => '<p>The data product item included in the search results.</p>', ], ], 'DataSourceConfigurationInput' => [ 'base' => '<p>The configuration of the data source.</p>', 'refs' => [ 'CreateDataSourceInput$configuration' => '<p>Specifies the configuration of the data source. It can be set to either <code>glueRunConfiguration</code> or <code>redshiftRunConfiguration</code>.</p>', 'UpdateDataSourceInput$configuration' => '<p>The configuration to be updated as part of the <code>UpdateDataSource</code> action.</p>', ], ], 'DataSourceConfigurationOutput' => [ 'base' => '<p>The configuration of the data source.</p>', 'refs' => [ 'CreateDataSourceOutput$configuration' => '<p>Specifies the configuration of the data source. It can be set to either <code>glueRunConfiguration</code> or <code>redshiftRunConfiguration</code>.</p>', 'DeleteDataSourceOutput$configuration' => '<p>The configuration of the data source that is deleted.</p>', 'GetDataSourceOutput$configuration' => '<p>The configuration of the data source.</p>', 'UpdateDataSourceOutput$configuration' => '<p>The configuration to be updated as part of the <code>UpdateDataSource</code> action.</p>', ], ], 'DataSourceErrorMessage' => [ 'base' => '<p>The details of the error message that is returned if the operation cannot be successfully completed.</p>', 'refs' => [ 'CreateDataSourceOutput$errorMessage' => '<p>Specifies the error message that is returned if the operation cannot be successfully completed.</p>', 'CreateDataSourceOutput$lastRunErrorMessage' => '<p>Specifies the error message that is returned if the operation cannot be successfully completed.</p>', 'DataSourceRunActivity$errorMessage' => NULL, 'DataSourceRunSummary$errorMessage' => NULL, 'DataSourceSummary$lastRunErrorMessage' => NULL, 'DeleteDataSourceOutput$errorMessage' => '<p>Specifies the error message that is returned if the operation cannot be successfully completed.</p>', 'DeleteDataSourceOutput$lastRunErrorMessage' => '<p>Specifies the error message that is returned if the operation cannot be successfully completed.</p>', 'GetDataSourceOutput$errorMessage' => '<p>Specifies the error message that is returned if the operation cannot be successfully completed.</p>', 'GetDataSourceOutput$lastRunErrorMessage' => '<p>Specifies the error message that is returned if the operation cannot be successfully completed.</p>', 'GetDataSourceRunOutput$errorMessage' => '<p>Specifies the error message that is returned if the operation cannot be successfully completed.</p>', 'StartDataSourceRunOutput$errorMessage' => '<p>Specifies the error message that is returned if the operation cannot be successfully completed.</p>', 'UpdateDataSourceOutput$errorMessage' => '<p>Specifies the error message that is returned if the operation cannot be successfully completed.</p>', 'UpdateDataSourceOutput$lastRunErrorMessage' => '<p>The last run error message of the data source.</p>', ], ], 'DataSourceErrorType' => [ 'base' => NULL, 'refs' => [ 'DataSourceErrorMessage$errorType' => '<p>The type of the error message that is returned if the operation cannot be successfully completed.</p>', ], ], 'DataSourceId' => [ 'base' => NULL, 'refs' => [ 'CreateDataSourceOutput$id' => '<p>The unique identifier of the data source.</p>', 'DataSourceRunSummary$dataSourceId' => '<p>The identifier of the data source of the data source run.</p>', 'DataSourceSummary$dataSourceId' => '<p>The ID of the data source.</p>', 'DeleteDataSourceInput$identifier' => '<p>The identifier of the data source that is deleted.</p>', 'DeleteDataSourceOutput$id' => '<p>The ID of the data source that is deleted.</p>', 'GetDataSourceInput$identifier' => '<p>The ID of the Amazon DataZone data source.</p>', 'GetDataSourceOutput$id' => '<p>The ID of the data source.</p>', 'GetDataSourceRunOutput$dataSourceId' => '<p>The ID of the data source for this data source run.</p>', 'ListDataSourceRunsInput$dataSourceIdentifier' => '<p>The identifier of the data source.</p>', 'StartDataSourceRunInput$dataSourceIdentifier' => '<p>The identifier of the data source.</p>', 'StartDataSourceRunOutput$dataSourceId' => '<p>The identifier of the data source.</p>', 'UpdateDataSourceInput$identifier' => '<p>The identifier of the data source to be updated.</p>', 'UpdateDataSourceOutput$id' => '<p>The identifier of the data source to be updated.</p>', ], ], 'DataSourceRunActivities' => [ 'base' => NULL, 'refs' => [ 'ListDataSourceRunActivitiesOutput$items' => '<p>The results of the <code>ListDataSourceRunActivities</code> action.</p>', ], ], 'DataSourceRunActivity' => [ 'base' => '<p>The activity details of the data source run.</p>', 'refs' => [ 'DataSourceRunActivities$member' => NULL, ], ], 'DataSourceRunId' => [ 'base' => NULL, 'refs' => [ 'DataSourceRunActivity$dataSourceRunId' => '<p>The identifier of the data source for the data source run activity.</p>', 'DataSourceRunSummary$id' => '<p>The identifier of the data source run.</p>', 'GetDataSourceRunInput$identifier' => '<p>The ID of the data source run.</p>', 'GetDataSourceRunOutput$id' => '<p>The ID of the data source run.</p>', 'ListDataSourceRunActivitiesInput$identifier' => '<p>The identifier of the data source run.</p>', 'StartDataSourceRunOutput$id' => '<p>The identifier of the data source run.</p>', ], ], 'DataSourceRunStatus' => [ 'base' => NULL, 'refs' => [ 'CreateDataSourceOutput$lastRunStatus' => '<p>The status of the last run of this data source.</p>', 'DataSourceRunSummary$status' => '<p>The status of the data source run.</p>', 'DataSourceSummary$lastRunStatus' => '<p>The status of the last data source run.</p>', 'DeleteDataSourceOutput$lastRunStatus' => '<p>The status of the last run of this data source.</p>', 'GetDataSourceOutput$lastRunStatus' => '<p>The status of the last run of the data source.</p>', 'GetDataSourceRunOutput$status' => '<p>The status of this data source run.</p>', 'ListDataSourceRunsInput$status' => '<p>The status of the data source.</p>', 'StartDataSourceRunOutput$status' => '<p>The status of the data source run.</p>', 'UpdateDataSourceOutput$lastRunStatus' => '<p>The last run status of the data source.</p>', ], ], 'DataSourceRunSummaries' => [ 'base' => NULL, 'refs' => [ 'ListDataSourceRunsOutput$items' => '<p>The results of the <code>ListDataSourceRuns</code> action.</p>', ], ], 'DataSourceRunSummary' => [ 'base' => '<p>The details of a data source run.</p>', 'refs' => [ 'DataSourceRunSummaries$member' => NULL, ], ], 'DataSourceRunType' => [ 'base' => NULL, 'refs' => [ 'DataSourceRunSummary$type' => '<p>The type of the data source run.</p>', 'GetDataSourceRunOutput$type' => '<p>The type of this data source run.</p>', 'StartDataSourceRunOutput$type' => '<p>The type of the data source run.</p>', ], ], 'DataSourceStatus' => [ 'base' => NULL, 'refs' => [ 'CreateDataSourceOutput$status' => '<p>The status of the data source.</p>', 'DataSourceSummary$status' => '<p>The status of the data source.</p>', 'DeleteDataSourceOutput$status' => '<p>The status of this data source.</p>', 'GetDataSourceOutput$status' => '<p>The status of the data source.</p>', 'ListDataSourcesInput$status' => '<p>The status of the data source.</p>', 'UpdateDataSourceOutput$status' => '<p>The status to be updated as part of the <code>UpdateDataSource</code> action.</p>', ], ], 'DataSourceSummaries' => [ 'base' => NULL, 'refs' => [ 'ListDataSourcesOutput$items' => '<p>The results of the <code>ListDataSources</code> action.</p>', ], ], 'DataSourceSummary' => [ 'base' => '<p>The details of the data source.</p>', 'refs' => [ 'DataSourceSummaries$member' => NULL, ], ], 'DataSourceType' => [ 'base' => NULL, 'refs' => [ 'CreateDataSourceInput$type' => '<p>The type of the data source.</p>', 'CreateDataSourceOutput$type' => '<p>The type of the data source.</p>', 'DeleteDataSourceOutput$type' => '<p>The type of this data source.</p>', 'GetDataSourceOutput$type' => '<p>The type of the data source.</p>', 'ListDataSourcesInput$type' => '<p>The type of the data source.</p>', 'UpdateDataSourceOutput$type' => '<p>The type to be updated as part of the <code>UpdateDataSource</code> action.</p>', ], ], 'DateTime' => [ 'base' => NULL, 'refs' => [ 'CreateDataSourceOutput$createdAt' => '<p>The timestamp of when the data source was created.</p>', 'CreateDataSourceOutput$lastRunAt' => '<p>The timestamp that specifies when the data source was last run.</p>', 'CreateDataSourceOutput$updatedAt' => '<p>The timestamp of when the data source was updated.</p>', 'DataSourceRunActivity$createdAt' => '<p>The timestamp of when data source run activity was created.</p>', 'DataSourceRunActivity$updatedAt' => '<p>The timestamp of when data source run activity was updated.</p>', 'DataSourceRunSummary$createdAt' => '<p>The timestamp of when a data source run was created.</p>', 'DataSourceRunSummary$startedAt' => '<p>The timestamp of when a data source run was started.</p>', 'DataSourceRunSummary$stoppedAt' => '<p>The timestamp of when a data source run was stopped.</p>', 'DataSourceRunSummary$updatedAt' => '<p>The timestamp of when a data source run was updated.</p>', 'DataSourceSummary$createdAt' => '<p>The timestamp of when the data source was created.</p>', 'DataSourceSummary$lastRunAt' => '<p>The timestamp of when the data source run was last performed.</p>', 'DataSourceSummary$updatedAt' => '<p>The timestamp of when the data source was updated.</p>', 'DeleteDataSourceOutput$createdAt' => '<p>The timestamp of when this data source was created.</p>', 'DeleteDataSourceOutput$lastRunAt' => '<p>The timestamp of when the data source was last run.</p>', 'DeleteDataSourceOutput$updatedAt' => '<p>The timestamp of when this data source was updated.</p>', 'GetDataSourceOutput$createdAt' => '<p>The timestamp of when the data source was created.</p>', 'GetDataSourceOutput$lastRunAt' => '<p>The timestamp of the last run of the data source.</p>', 'GetDataSourceOutput$updatedAt' => '<p>The timestamp of when the data source was updated.</p>', 'GetDataSourceRunOutput$createdAt' => '<p>The timestamp of when the data source run was created.</p>', 'GetDataSourceRunOutput$startedAt' => '<p>The timestamp of when this data source run started.</p>', 'GetDataSourceRunOutput$stoppedAt' => '<p>The timestamp of when this data source run stopped.</p>', 'GetDataSourceRunOutput$updatedAt' => '<p>The timestamp of when this data source run was updated.</p>', 'StartDataSourceRunOutput$createdAt' => '<p>The timestamp of when data source run was created.</p>', 'StartDataSourceRunOutput$startedAt' => '<p>The timestamp of when the data source run was started.</p>', 'StartDataSourceRunOutput$stoppedAt' => '<p>The timestamp of when the data source run was stopped.</p>', 'StartDataSourceRunOutput$updatedAt' => '<p>The timestamp of when the data source run was updated.</p>', 'UpdateDataSourceOutput$createdAt' => '<p>The timestamp of when the data source was updated.</p>', 'UpdateDataSourceOutput$lastRunAt' => '<p>The timestamp of when the data source was last run.</p>', 'UpdateDataSourceOutput$updatedAt' => '<p>The timestamp of when the data source was updated.</p>', ], ], 'DecisionComment' => [ 'base' => NULL, 'refs' => [ 'AcceptSubscriptionRequestInput$decisionComment' => '<p>A description that specifies the reason for accepting the specified subscription request.</p>', 'AcceptSubscriptionRequestOutput$decisionComment' => '<p>Specifies the reason for accepting the subscription request.</p>', 'CreateSubscriptionRequestOutput$decisionComment' => '<p>The decision comment of the subscription request.</p>', 'GetSubscriptionRequestDetailsOutput$decisionComment' => '<p>The decision comment of the subscription request.</p>', 'RejectSubscriptionRequestInput$decisionComment' => '<p>The decision comment of the rejected subscription request.</p>', 'RejectSubscriptionRequestOutput$decisionComment' => '<p>The decision comment of the rejected subscription request.</p>', 'SubscriptionRequestSummary$decisionComment' => '<p>The decision comment of the subscription request.</p>', 'UpdateSubscriptionRequestOutput$decisionComment' => '<p>The decision comment of the <code>UpdateSubscriptionRequest</code> action.</p>', ], ], 'DeleteAssetInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAssetOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAssetTypeInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAssetTypeOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDataSourceInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDataSourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDomainInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDomainOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEnvironmentActionInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEnvironmentBlueprintConfigurationInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEnvironmentBlueprintConfigurationOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEnvironmentInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEnvironmentProfileInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFormTypeInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFormTypeOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteGlossaryInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteGlossaryOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteGlossaryTermInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteGlossaryTermOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteListingInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteListingOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteProjectInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteProjectMembershipInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteProjectMembershipOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteProjectOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSubscriptionGrantInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSubscriptionGrantOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSubscriptionRequestInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSubscriptionTargetInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTimeSeriesDataPointsInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTimeSeriesDataPointsOutput' => [ 'base' => NULL, 'refs' => [], ], 'Deployment' => [ 'base' => '<p>The details of the last deployment of the environment.</p>', 'refs' => [ 'CreateEnvironmentOutput$lastDeployment' => '<p>The details of the last deployment of this Amazon DataZone environment.</p>', 'GetEnvironmentOutput$lastDeployment' => '<p>The details of the last deployment of the environment.</p>', 'UpdateEnvironmentOutput$lastDeployment' => '<p>The last deployment of the environment.</p>', ], ], 'DeploymentMessage' => [ 'base' => NULL, 'refs' => [ 'DeploymentMessagesList$member' => NULL, ], ], 'DeploymentMessagesList' => [ 'base' => NULL, 'refs' => [ 'Deployment$messages' => '<p>The messages of the last deployment of the environment.</p>', ], ], 'DeploymentProperties' => [ 'base' => '<p>The deployment properties of the Amazon DataZone blueprint.</p>', 'refs' => [ 'CreateEnvironmentOutput$deploymentProperties' => '<p>The deployment properties of this Amazon DataZone environment.</p>', 'GetEnvironmentBlueprintOutput$deploymentProperties' => '<p>The deployment properties of this Amazon DataZone blueprint.</p>', 'GetEnvironmentOutput$deploymentProperties' => '<p>The deployment properties of the environment.</p>', 'UpdateEnvironmentOutput$deploymentProperties' => '<p>The deployment properties to be updated as part of the <code>UpdateEnvironment</code> action.</p>', ], ], 'DeploymentPropertiesEndTimeoutMinutesInteger' => [ 'base' => NULL, 'refs' => [ 'DeploymentProperties$endTimeoutMinutes' => '<p>The end timeout of the environment blueprint deployment.</p>', ], ], 'DeploymentPropertiesStartTimeoutMinutesInteger' => [ 'base' => NULL, 'refs' => [ 'DeploymentProperties$startTimeoutMinutes' => '<p>The start timeout of the environment blueprint deployment.</p>', ], ], 'DeploymentStatus' => [ 'base' => NULL, 'refs' => [ 'Deployment$deploymentStatus' => '<p>The status of the last deployment of the environment.</p>', ], ], 'DeploymentType' => [ 'base' => NULL, 'refs' => [ 'Deployment$deploymentType' => '<p>The type of the last deployment of the environment.</p>', ], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'AssetItem$description' => '<p>The description of an Amazon DataZone inventory asset.</p>', 'AssetListingItem$description' => '<p>The description of an asset published in an Amazon DataZone catalog.</p>', 'AssetTypeItem$description' => '<p>The description of the asset type.</p>', 'CreateAssetInput$description' => '<p>Asset description.</p>', 'CreateAssetOutput$description' => '<p>The description of the created asset.</p>', 'CreateAssetRevisionInput$description' => '<p>The revised description of the asset.</p>', 'CreateAssetRevisionOutput$description' => '<p>The revised asset description.</p>', 'CreateAssetTypeInput$description' => '<p>The descripton of the custom asset type.</p>', 'CreateAssetTypeOutput$description' => '<p>The description of the custom asset type.</p>', 'CreateDataSourceInput$description' => '<p>The description of the data source.</p>', 'CreateDataSourceOutput$description' => '<p>The description of the data source.</p>', 'CreateEnvironmentOutput$description' => '<p>The description of this Amazon DataZone environment.</p>', 'CreateEnvironmentProfileInput$description' => '<p>The description of this Amazon DataZone environment profile.</p>', 'CreateEnvironmentProfileOutput$description' => '<p>The description of this Amazon DataZone environment profile.</p>', 'CreateFormTypeInput$description' => '<p>The description of this Amazon DataZone metadata form type.</p>', 'CreateFormTypeOutput$description' => '<p>The description of this Amazon DataZone metadata form type.</p>', 'CreateProjectInput$description' => '<p>The description of the Amazon DataZone project.</p>', 'CreateProjectOutput$description' => '<p>The description of the project.</p>', 'CustomParameter$description' => '<p>The description of the parameter.</p>', 'DataSourceRunActivity$technicalDescription' => '<p>The technical description included in the data source run activity.</p>', 'DeleteDataSourceOutput$description' => '<p>The description of the data source that is deleted.</p>', 'EnvironmentBlueprintSummary$description' => '<p>The description of a blueprint.</p>', 'EnvironmentProfileSummary$description' => '<p>The description of the environment profile.</p>', 'EnvironmentSummary$description' => '<p>The description of the environment.</p>', 'FormTypeData$description' => '<p>The description of the metadata form type.</p>', 'GetAssetOutput$description' => '<p>The description of the Amazon DataZone asset.</p>', 'GetAssetTypeOutput$description' => '<p>The description of the asset type.</p>', 'GetDataSourceOutput$description' => '<p>The description of the data source.</p>', 'GetEnvironmentBlueprintOutput$description' => '<p>The description of this Amazon DataZone blueprint.</p>', 'GetEnvironmentOutput$description' => '<p>The description of the environment.</p>', 'GetEnvironmentProfileOutput$description' => '<p>The description of the environment profile.</p>', 'GetFormTypeOutput$description' => '<p>The description of the metadata form type.</p>', 'GetListingOutput$description' => '<p>The description of the listing.</p>', 'GetProjectOutput$description' => '<p>The description of the project.</p>', 'ProjectSummary$description' => '<p>The description of a project.</p>', 'SubscribedListing$description' => '<p>The description of the published asset for which the subscription grant is created.</p>', 'UpdateDataSourceInput$description' => '<p>The description to be updated as part of the <code>UpdateDataSource</code> action.</p>', 'UpdateDataSourceOutput$description' => '<p>The description to be updated as part of the <code>UpdateDataSource</code> action.</p>', 'UpdateEnvironmentOutput$description' => '<p>The description to be updated as part of the <code>UpdateEnvironment</code> action.</p>', 'UpdateEnvironmentProfileOutput$description' => '<p>The description to be updated as part of the <code>UpdateEnvironmentProfile</code> action.</p>', 'UpdateProjectInput$description' => '<p>The description to be updated as part of the <code>UpdateProject</code> action.</p>', 'UpdateProjectOutput$description' => '<p>The description of the project that is to be updated.</p>', ], ], 'DetailedGlossaryTerm' => [ 'base' => '<p>Details of a glossary term attached to the inventory asset.</p>', 'refs' => [ 'DetailedGlossaryTerms$member' => NULL, ], ], 'DetailedGlossaryTerms' => [ 'base' => NULL, 'refs' => [ 'AssetListing$glossaryTerms' => '<p>The glossary terms attached to an asset published in an Amazon DataZone catalog. </p>', 'AssetListingItem$glossaryTerms' => '<p>Glossary terms attached to the inventory asset.</p>', 'SubscribedAssetListing$glossaryTerms' => '<p>The glossary terms attached to the published asset for which the subscription grant is created.</p>', ], ], 'DisassociateEnvironmentRoleInput' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateEnvironmentRoleOutput' => [ 'base' => NULL, 'refs' => [], ], 'DomainDescription' => [ 'base' => NULL, 'refs' => [ 'DomainSummary$description' => '<p>A description of an Amazon DataZone domain.</p>', ], ], 'DomainId' => [ 'base' => NULL, 'refs' => [ 'AcceptPredictionsInput$domainIdentifier' => '<p>The identifier of the Amazon DataZone domain.</p>', 'AcceptPredictionsOutput$domainId' => '<p>The identifier of the Amazon DataZone domain.</p>', 'AcceptSubscriptionRequestInput$domainIdentifier' => '<p>The Amazon DataZone domain where the specified subscription request is being accepted.</p>', 'AcceptSubscriptionRequestOutput$domainId' => '<p>The unique identifier of the Amazon DataZone domain where the specified subscription request was accepted.</p>', 'AssetItem$domainId' => '<p>The identifier of the Amazon DataZone domain in which the inventory asset exists.</p>', 'AssetRevision$domainId' => '<p>The Amazon DataZone user who created the inventory asset.</p>', 'AssetTypeItem$domainId' => '<p>The identifier of the Amazon DataZone domain where the asset type exists.</p>', 'AssetTypeItem$originDomainId' => '<p>The identifier of the Amazon DataZone domain where the asset type was originally created.</p>', 'AssociateEnvironmentRoleInput$domainIdentifier' => '<p>The ID of the Amazon DataZone domain in which the environment role is associated.</p>', 'CancelMetadataGenerationRunInput$domainIdentifier' => '<p>The ID of the Amazon DataZone domain in which the metadata generation run is to be cancelled.</p>', 'CancelSubscriptionInput$domainIdentifier' => '<p>The unique identifier of the Amazon DataZone domain where the subscription request is being cancelled.</p>', 'CancelSubscriptionOutput$domainId' => '<p>The unique identifier of the Amazon DataZone domain where the subscription is being cancelled.</p>', 'CreateAssetInput$domainIdentifier' => '<p>Amazon DataZone domain where the asset is created.</p>', 'CreateAssetOutput$domainId' => '<p>The ID of the Amazon DataZone domain in which the asset was created.</p>', 'CreateAssetRevisionInput$domainIdentifier' => '<p>The unique identifier of the domain where the asset is being revised.</p>', 'CreateAssetRevisionOutput$domainId' => '<p>The unique identifier of the Amazon DataZone domain where the asset was revised.</p>', 'CreateAssetTypeInput$domainIdentifier' => '<p>The unique identifier of the Amazon DataZone domain where the custom asset type is being created.</p>', 'CreateAssetTypeOutput$domainId' => '<p>The ID of the Amazon DataZone domain in which the asset type was created.</p>', 'CreateAssetTypeOutput$originDomainId' => '<p>The ID of the Amazon DataZone domain where the asset type was originally created.</p>', 'CreateDataSourceInput$domainIdentifier' => '<p>The ID of the Amazon DataZone domain where the data source is created.</p>', 'CreateDataSourceOutput$domainId' => '<p>The ID of the Amazon DataZone domain in which the data source is created.</p>', 'CreateDomainOutput$id' => '<p>The identifier of the Amazon DataZone domain.</p>', 'CreateEnvironmentActionInput$domainIdentifier' => '<p>The ID of the Amazon DataZone domain in which the environment action is created.</p>', 'CreateEnvironmentActionOutput$domainId' => '<p>The ID of the domain in which the environment action is created.</p>', 'CreateEnvironmentInput$domainIdentifier' => '<p>The identifier of the Amazon DataZone domain in which the environment is created.</p>', 'CreateEnvironmentOutput$domainId' => '<p>The identifier of the Amazon DataZone domain in which the environment is created.</p>', 'CreateEnvironmentProfileInput$domainIdentifier' => '<p>The ID of the Amazon DataZone domain in which this environment profile is created.</p>', 'CreateEnvironmentProfileOutput$domainId' => '<p>The ID of the Amazon DataZone domain in which this environment profile is created.</p>', 'CreateFormTypeInput$domainIdentifier' => '<p>The ID of the Amazon DataZone domain in which this metadata form type is created.</p>', 'CreateFormTypeOutput$domainId' => '<p>The ID of the Amazon DataZone domain in which this metadata form type is created.</p>', 'CreateFormTypeOutput$originDomainId' => '<p>The ID of the Amazon DataZone domain in which this metadata form type was originally created.</p>', 'CreateGlossaryInput$domainIdentifier' => '<p>The ID of the Amazon DataZone domain in which this business glossary is created.</p>', 'CreateGlossaryOutput$domainId' => '<p>The ID of the Amazon DataZone domain in which this business glossary is created.</p>', 'CreateGlossaryTermInput$domainIdentifier' => '<p>The ID of the Amazon DataZone domain in which this business glossary term is created.</p>', 'CreateGlossaryTermOutput$domainId' => '<p>The ID of the Amazon DataZone domain in which this business glossary term is created.</p>', 'CreateGroupProfileInput$domainIdentifier' => '<p>The identifier of the Amazon DataZone domain in which the group profile is created.</p>', 'CreateGroupProfileOutput$domainId' => '<p>The identifier of the Amazon DataZone domain in which the group profile is created.</p>', 'CreateListingChangeSetInput$domainIdentifier' => '<p>The ID of the Amazon DataZone domain.</p>', 'CreateProjectInput$domainIdentifier' => '<p>The ID of the Amazon DataZone domain in which this project is created.</p>', 'CreateProjectMembershipInput$domainIdentifier' => '<p>The ID of the Amazon DataZone domain in which project membership is created.</p>', 'CreateProjectOutput$domainId' => '<p>The identifier of the Amazon DataZone domain in which the project was created.</p>', 'CreateSubscriptionGrantInput$domainIdentifier' => '<p>The ID of the Amazon DataZone domain in which the subscription grant is created.</p>', 'CreateSubscriptionGrantOutput$domainId' => '<p>The ID of the Amazon DataZone domain in which the subscription grant is created.</p>', 'CreateSubscriptionRequestInput$domainIdentifier' => '<p>The ID of the Amazon DataZone domain in which the subscription request is created.</p>', 'CreateSubscriptionRequestOutput$domainId' => '<p>The ID of the Amazon DataZone domain in whcih the subscription request is created.</p>', 'CreateSubscriptionTargetInput$domainIdentifier' => '<p>The ID of the Amazon DataZone domain in which subscription target is created.</p>', 'CreateSubscriptionTargetOutput$domainId' => '<p>The ID of the Amazon DataZone domain in which the subscription target was created.</p>', 'CreateUserProfileInput$domainIdentifier' => '<p>The identifier of the Amazon DataZone domain in which a user profile is created.</p>', 'CreateUserProfileOutput$domainId' => '<p>The identifier of the Amazon DataZone domain in which a user profile is created.</p>', 'DataProductItem$domainId' => '<p/>', 'DataProductSummary$domainId' => '<p/>', 'DataSourceSummary$domainId' => '<p>The ID of the Amazon DataZone domain in which the data source exists.</p>', 'DeleteAssetInput$domainIdentifier' => '<p>The ID of the Amazon DataZone domain in which the asset is deleted.</p>', 'DeleteAssetTypeInput$domainIdentifier' => '<p>The ID of the Amazon DataZone domain in which the asset type is deleted.</p>', 'DeleteDataSourceInput$domainIdentifier' => '<p>The ID of the Amazon DataZone domain in which the data source is deleted.</p>', 'DeleteDataSourceOutput$domainId' => '<p>The ID of the Amazon DataZone domain in which the data source is deleted.</p>', 'DeleteDomainInput$identifier' => '<p>The identifier of the Amazon Web Services domain that is to be deleted.</p>', 'DeleteEnvironmentActionInput$domainIdentifier' => '<p>The ID of the Amazon DataZone domain in which an environment action is deleted.</p>', 'DeleteEnvironmentBlueprintConfigurationInput$domainIdentifier' => '<p>The ID of the Amazon DataZone domain in which the blueprint configuration is deleted.</p>', 'DeleteEnvironmentInput$domainIdentifier' => '<p>The ID of the Amazon DataZone domain in which the environment is deleted.</p>', 'DeleteEnvironmentProfileInput$domainIdentifier' => '<p>The ID of the Amazon DataZone domain in which the environment profile is deleted.</p>', 'DeleteFormTypeInput$domainIdentifier' => '<p>The ID of the Amazon DataZone domain in which the metadata form type is deleted.</p>', 'DeleteGlossaryInput$domainIdentifier' => '<p>The ID of the Amazon DataZone domain in which the business glossary is deleted.</p>', 'DeleteGlossaryTermInput$domainIdentifier' => '<p>The ID of the Amazon DataZone domain in which the business glossary term is deleted.</p>', 'DeleteListingInput$domainIdentifier' => '<p>The ID of the Amazon DataZone domain.</p>', 'DeleteProjectInput$domainIdentifier' => '<p>The ID of the Amazon DataZone domain in which the project is deleted.</p>', 'DeleteProjectMembershipInput$domainIdentifier' => '<p>The ID of the Amazon DataZone domain where project membership is deleted.</p>', 'DeleteSubscriptionGrantInput$domainIdentifier' => '<p>The ID of the Amazon DataZone domain where the subscription grant is deleted.</p>', 'DeleteSubscriptionGrantOutput$domainId' => '<p>The ID of the Amazon DataZone domain in which the subscription grant is deleted.</p>', 'DeleteSubscriptionRequestInput$domainIdentifier' => '<p>The ID of the Amazon DataZone domain in which the subscription request is deleted.</p>', 'DeleteSubscriptionTargetInput$domainIdentifier' => '<p>The ID of the Amazon DataZone domain in which the subscription target is deleted.</p>', 'DeleteTimeSeriesDataPointsInput$domainIdentifier' => '<p>The ID of the Amazon DataZone domain that houses the asset for which you want to delete a time series form.</p>', 'DisassociateEnvironmentRoleInput$domainIdentifier' => '<p>The ID of the Amazon DataZone domain in which an environment role is disassociated.</p>', 'DomainSummary$id' => '<p>The ID of the Amazon DataZone domain.</p>', 'EnvironmentActionSummary$domainId' => '<p>The Amazon DataZone domain ID of the environment action.</p>', 'EnvironmentBlueprintConfigurationItem$domainId' => '<p>The identifier of the Amazon DataZone domain in which an environment blueprint exists.</p>', 'EnvironmentProfileSummary$domainId' => '<p>The identifier of the Amazon DataZone domain in which the environment profile exists.</p>', 'EnvironmentSummary$domainId' => '<p>The identifier of the Amazon DataZone domain in which the environment exists.</p>', 'FormTypeData$domainId' => '<p>The identifier of the Amazon DataZone domain in which the form type exists.</p>', 'FormTypeData$originDomainId' => '<p>The identifier of the Amazon DataZone domain in which the form type was originally created.</p>', 'GetAssetInput$domainIdentifier' => '<p>The ID of the Amazon DataZone domain to which the asset belongs.</p>', 'GetAssetOutput$domainId' => '<p>The ID of the Amazon DataZone domain to which the asset belongs.</p>', 'GetAssetTypeInput$domainIdentifier' => '<p>The ID of the Amazon DataZone domain in which the asset type exists.</p>', 'GetAssetTypeOutput$domainId' => '<p>The ID of the Amazon DataZone domain in which the asset type exists.</p>', 'GetAssetTypeOutput$originDomainId' => '<p>The ID of the Amazon DataZone domain in which the asset type was originally created.</p>', 'GetDataSourceInput$domainIdentifier' => '<p>The ID of the Amazon DataZone domain in which the data source exists.</p>', 'GetDataSourceOutput$domainId' => '<p>The ID of the Amazon DataZone domain in which the data source exists.</p>', 'GetDataSourceRunInput$domainIdentifier' => '<p>The ID of the domain in which this data source run was performed.</p>', 'GetDataSourceRunOutput$domainId' => '<p>The ID of the domain in which this data source run was performed.</p>', 'GetDomainInput$identifier' => '<p>The identifier of the specified Amazon DataZone domain.</p>', 'GetDomainOutput$id' => '<p>The identifier of the specified Amazon DataZone domain.</p>', 'GetEnvironmentActionInput$domainIdentifier' => '<p>The ID of the Amazon DataZone domain in which the <code>GetEnvironmentAction</code> API is invoked. </p>', 'GetEnvironmentActionOutput$domainId' => '<p>The ID of the Amazon DataZone domain in which the environment action lives.</p>', 'GetEnvironmentBlueprintConfigurationInput$domainIdentifier' => '<p>The ID of the Amazon DataZone domain where this blueprint exists.</p>', 'GetEnvironmentBlueprintConfigurationOutput$domainId' => '<p>The ID of the Amazon DataZone domain where this blueprint exists.</p>', 'GetEnvironmentBlueprintInput$domainIdentifier' => '<p>The identifier of the domain in which this blueprint exists.</p>', 'GetEnvironmentInput$domainIdentifier' => '<p>The ID of the Amazon DataZone domain where the environment exists.</p>', 'GetEnvironmentOutput$domainId' => '<p>The ID of the Amazon DataZone domain where the environment exists.</p>', 'GetEnvironmentProfileInput$domainIdentifier' => '<p>The ID of the Amazon DataZone domain in which this environment profile exists.</p>', 'GetEnvironmentProfileOutput$domainId' => '<p>The ID of the Amazon DataZone domain in which this environment profile exists.</p>', 'GetFormTypeInput$domainIdentifier' => '<p>The ID of the Amazon DataZone domain in which this metadata form type exists.</p>', 'GetFormTypeOutput$domainId' => '<p>The ID of the Amazon DataZone domain in which this metadata form type exists.</p>', 'GetFormTypeOutput$originDomainId' => '<p>The ID of the Amazon DataZone domain in which the metadata form type was originally created.</p>', 'GetGlossaryInput$domainIdentifier' => '<p>The ID of the Amazon DataZone domain in which this business glossary exists.</p>', 'GetGlossaryOutput$domainId' => '<p>The ID of the Amazon DataZone domain in which this business glossary exists.</p>', 'GetGlossaryTermInput$domainIdentifier' => '<p>The ID of the Amazon DataZone domain in which this business glossary term exists.</p>', 'GetGlossaryTermOutput$domainId' => '<p>The ID of the Amazon DataZone domain in which this business glossary term exists.</p>', 'GetGroupProfileInput$domainIdentifier' => '<p>The identifier of the Amazon DataZone domain in which the group profile exists.</p>', 'GetGroupProfileOutput$domainId' => '<p>The identifier of the Amazon DataZone domain in which the group profile exists.</p>', 'GetIamPortalLoginUrlInput$domainIdentifier' => '<p>the ID of the Amazon DataZone domain the data portal of which you want to get.</p>', 'GetLineageNodeInput$domainIdentifier' => '<p>The ID of the domain in which you want to get the data lineage node.</p>', 'GetLineageNodeOutput$domainId' => '<p>The ID of the domain where you\'re getting the data lineage node.</p>', 'GetListingInput$domainIdentifier' => '<p>The ID of the Amazon DataZone domain.</p>', 'GetListingOutput$domainId' => '<p>The ID of the Amazon DataZone domain.</p>', 'GetMetadataGenerationRunInput$domainIdentifier' => '<p>The ID of the Amazon DataZone domain the metadata generation run of which you want to get.</p>', 'GetMetadataGenerationRunOutput$domainId' => '<p>The ID of the Amazon DataZone domain the metadata generation run of which you want to get.</p>', 'GetProjectInput$domainIdentifier' => '<p>The ID of the Amazon DataZone domain in which the project exists.</p>', 'GetProjectOutput$domainId' => '<p>The ID of the Amazon DataZone domain in which the project exists.</p>', 'GetSubscriptionGrantInput$domainIdentifier' => '<p>The ID of the Amazon DataZone domain in which the subscription grant exists.</p>', 'GetSubscriptionGrantOutput$domainId' => '<p>The ID of the Amazon DataZone domain in which the subscription grant exists.</p>', 'GetSubscriptionInput$domainIdentifier' => '<p>The ID of the Amazon DataZone domain in which the subscription exists.</p>', 'GetSubscriptionOutput$domainId' => '<p>The ID of the Amazon DataZone domain in which the subscription exists.</p>', 'GetSubscriptionRequestDetailsInput$domainIdentifier' => '<p>The identifier of the Amazon DataZone domain in which to get the subscription request details.</p>', 'GetSubscriptionRequestDetailsOutput$domainId' => '<p>The Amazon DataZone domain of the subscription request.</p>', 'GetSubscriptionTargetInput$domainIdentifier' => '<p>The ID of the Amazon DataZone domain in which the subscription target exists.</p>', 'GetSubscriptionTargetOutput$domainId' => '<p>The ID of the Amazon DataZone domain in which the subscription target exists.</p>', 'GetTimeSeriesDataPointInput$domainIdentifier' => '<p>The ID of the Amazon DataZone domain that houses the asset for which you want to get the data point.</p>', 'GetTimeSeriesDataPointOutput$domainId' => '<p>The ID of the Amazon DataZone domain that houses the asset data point that you want to get.</p>', 'GetUserProfileInput$domainIdentifier' => '<p>the ID of the Amazon DataZone domain the data portal of which you want to get.</p>', 'GetUserProfileOutput$domainId' => '<p>the identifier of the Amazon DataZone domain of which you want to get the user profile.</p>', 'GlossaryItem$domainId' => '<p>The identifier of the Amazon DataZone domain in which the business glossary exists.</p>', 'GlossaryTermItem$domainId' => '<p>The identifier of the Amazon DataZone domain in which the business glossary exists.</p>', 'GroupProfileSummary$domainId' => '<p>The ID of the Amazon DataZone domain of a group profile.</p>', 'LineageNodeSummary$domainId' => '<p>The ID of the domain of the data lineage node.</p>', 'LineageNodeTypeItem$domainId' => '<p>The ID of the domain where the data lineage node type lives.</p>', 'ListAssetRevisionsInput$domainIdentifier' => '<p>The identifier of the domain.</p>', 'ListDataSourceRunActivitiesInput$domainIdentifier' => '<p>The identifier of the Amazon DataZone domain in which to list data source run activities.</p>', 'ListDataSourceRunsInput$domainIdentifier' => '<p>The identifier of the Amazon DataZone domain in which to invoke the <code>ListDataSourceRuns</code> action.</p>', 'ListDataSourcesInput$domainIdentifier' => '<p>The identifier of the Amazon DataZone domain in which to list the data sources.</p>', 'ListEnvironmentActionsInput$domainIdentifier' => '<p>The ID of the Amazon DataZone domain in which the environment actions are listed.</p>', 'ListEnvironmentBlueprintConfigurationsInput$domainIdentifier' => '<p>The identifier of the Amazon DataZone domain.</p>', 'ListEnvironmentBlueprintsInput$domainIdentifier' => '<p>The identifier of the Amazon DataZone domain.</p>', 'ListEnvironmentProfilesInput$domainIdentifier' => '<p>The identifier of the Amazon DataZone domain.</p>', 'ListEnvironmentsInput$domainIdentifier' => '<p>The identifier of the Amazon DataZone domain.</p>', 'ListLineageNodeHistoryInput$domainIdentifier' => '<p>The ID of the domain where you want to list the history of the specified data lineage node.</p>', 'ListMetadataGenerationRunsInput$domainIdentifier' => '<p>The ID of the Amazon DataZone domain where you want to list metadata generation runs.</p>', 'ListNotificationsInput$domainIdentifier' => '<p>The identifier of the Amazon DataZone domain.</p>', 'ListProjectMembershipsInput$domainIdentifier' => '<p>The identifier of the Amazon DataZone domain in which you want to list project memberships.</p>', 'ListProjectsInput$domainIdentifier' => '<p>The identifier of the Amazon DataZone domain.</p>', 'ListSubscriptionGrantsInput$domainIdentifier' => '<p>The identifier of the Amazon DataZone domain.</p>', 'ListSubscriptionRequestsInput$domainIdentifier' => '<p>The identifier of the Amazon DataZone domain.</p>', 'ListSubscriptionTargetsInput$domainIdentifier' => '<p>The identifier of the Amazon DataZone domain where you want to list subscription targets.</p>', 'ListSubscriptionsInput$domainIdentifier' => '<p>The identifier of the Amazon DataZone domain.</p>', 'ListTimeSeriesDataPointsInput$domainIdentifier' => '<p>The ID of the Amazon DataZone domain that houses the assets for which you want to list time series data points.</p>', 'MetadataGenerationRunItem$domainId' => '<p>The ID of the Amazon DataZone domain in which the metadata generation run was created.</p>', 'NotificationOutput$domainIdentifier' => '<p>The identifier of a Amazon DataZone domain in which the notification exists.</p>', 'PostLineageEventInput$domainIdentifier' => '<p>The ID of the domain where you want to post a data lineage event.</p>', 'PostTimeSeriesDataPointsInput$domainIdentifier' => '<p>The ID of the Amazon DataZone domain in which you want to post time series data points.</p>', 'PostTimeSeriesDataPointsOutput$domainId' => '<p>The ID of the Amazon DataZone domain in which you want to post time series data points.</p>', 'ProjectSummary$domainId' => '<p>The identifier of a Amazon DataZone domain where the project exists.</p>', 'PutEnvironmentBlueprintConfigurationInput$domainIdentifier' => '<p>The identifier of the Amazon DataZone domain.</p>', 'PutEnvironmentBlueprintConfigurationOutput$domainId' => '<p>The identifier of the Amazon DataZone domain.</p>', 'RejectPredictionsInput$domainIdentifier' => '<p>The identifier of the Amazon DataZone domain.</p>', 'RejectPredictionsOutput$domainId' => '<p>The ID of the Amazon DataZone domain.</p>', 'RejectSubscriptionRequestInput$domainIdentifier' => '<p>The identifier of the Amazon DataZone domain in which the subscription request was rejected.</p>', 'RejectSubscriptionRequestOutput$domainId' => '<p>The identifier of the Amazon DataZone domain in which the subscription request was rejected.</p>', 'RevokeSubscriptionInput$domainIdentifier' => '<p>The identifier of the Amazon DataZone domain where you want to revoke a subscription.</p>', 'RevokeSubscriptionOutput$domainId' => '<p>The identifier of the Amazon DataZone domain where you want to revoke a subscription.</p>', 'SearchGroupProfilesInput$domainIdentifier' => '<p>The identifier of the Amazon DataZone domain in which you want to search group profiles.</p>', 'SearchInput$domainIdentifier' => '<p>The identifier of the Amazon DataZone domain.</p>', 'SearchListingsInput$domainIdentifier' => '<p>The identifier of the domain in which to search listings.</p>', 'SearchTypesInput$domainIdentifier' => '<p>The identifier of the Amazon DataZone domain in which to invoke the <code>SearchTypes</code> action.</p>', 'SearchUserProfilesInput$domainIdentifier' => '<p>The identifier of the Amazon DataZone domain in which you want to search user profiles.</p>', 'StartDataSourceRunInput$domainIdentifier' => '<p>The identifier of the Amazon DataZone domain in which to start a data source run.</p>', 'StartDataSourceRunOutput$domainId' => '<p>The identifier of the Amazon DataZone domain in which to start a data source run.</p>', 'StartMetadataGenerationRunInput$domainIdentifier' => '<p>The ID of the Amazon DataZone domain where you want to start a metadata generation run.</p>', 'StartMetadataGenerationRunOutput$domainId' => '<p>The ID of the Amazon DataZone domain in which the metadata generation run was started.</p>', 'SubscriptionGrantSummary$domainId' => '<p>The identifier of the Amazon DataZone domain in which a subscription grant exists.</p>', 'SubscriptionRequestSummary$domainId' => '<p>The identifier of the Amazon DataZone domain in which a subscription request exists.</p>', 'SubscriptionSummary$domainId' => '<p>The identifier of the Amazon DataZone domain in which a subscription exists.</p>', 'SubscriptionTargetSummary$domainId' => '<p>The identifier of the Amazon DataZone domain in which the subscription target exists.</p>', 'UpdateDataSourceInput$domainIdentifier' => '<p>The identifier of the domain in which to update a data source.</p>', 'UpdateDataSourceOutput$domainId' => '<p>The identifier of the Amazon DataZone domain in which a data source is to be updated.</p>', 'UpdateDomainInput$identifier' => '<p>The ID of the Amazon Web Services domain that is to be updated.</p>', 'UpdateDomainOutput$id' => '<p>The identifier of the Amazon DataZone domain.</p>', 'UpdateEnvironmentActionInput$domainIdentifier' => '<p>The domain ID of the environment action.</p>', 'UpdateEnvironmentActionOutput$domainId' => '<p>The domain ID of the environment action.</p>', 'UpdateEnvironmentInput$domainIdentifier' => '<p>The identifier of the domain in which the environment is to be updated.</p>', 'UpdateEnvironmentOutput$domainId' => '<p>The identifier of the domain in which the environment is to be updated.</p>', 'UpdateEnvironmentProfileInput$domainIdentifier' => '<p>The identifier of the Amazon DataZone domain in which an environment profile is to be updated.</p>', 'UpdateEnvironmentProfileOutput$domainId' => '<p>The identifier of the Amazon DataZone domain in which the environment profile is to be updated.</p>', 'UpdateGlossaryInput$domainIdentifier' => '<p>The identifier of the Amazon DataZone domain in which a business glossary is to be updated.</p>', 'UpdateGlossaryOutput$domainId' => '<p>The identifier of the Amazon DataZone domain in which a business glossary is to be updated.</p>', 'UpdateGlossaryTermInput$domainIdentifier' => '<p>The identifier of the Amazon DataZone domain in which a business glossary term is to be updated.</p>', 'UpdateGlossaryTermOutput$domainId' => '<p>The identifier of the Amazon DataZone domain in which a business glossary term is to be updated.</p>', 'UpdateGroupProfileInput$domainIdentifier' => '<p>The identifier of the Amazon DataZone domain in which a group profile is updated.</p>', 'UpdateGroupProfileOutput$domainId' => '<p>The identifier of the Amazon DataZone domain in which a group profile is updated.</p>', 'UpdateProjectInput$domainIdentifier' => '<p>The identifier of the Amazon DataZone domain in which a project is to be updated.</p>', 'UpdateProjectOutput$domainId' => '<p>The identifier of the Amazon DataZone domain in which a project is updated.</p>', 'UpdateSubscriptionGrantStatusInput$domainIdentifier' => '<p>The identifier of the Amazon DataZone domain in which a subscription grant status is to be updated.</p>', 'UpdateSubscriptionGrantStatusOutput$domainId' => '<p>The identifier of the Amazon DataZone domain in which a subscription grant status is to be updated.</p>', 'UpdateSubscriptionRequestInput$domainIdentifier' => '<p>The identifier of the Amazon DataZone domain in which a subscription request is to be updated.</p>', 'UpdateSubscriptionRequestOutput$domainId' => '<p>The identifier of the Amazon DataZone domain in which a subscription request is to be updated.</p>', 'UpdateSubscriptionTargetInput$domainIdentifier' => '<p>The identifier of the Amazon DataZone domain in which a subscription target is to be updated.</p>', 'UpdateSubscriptionTargetOutput$domainId' => '<p>The identifier of the Amazon DataZone domain in which a subscription target is to be updated.</p>', 'UpdateUserProfileInput$domainIdentifier' => '<p>The identifier of the Amazon DataZone domain in which a user profile is updated.</p>', 'UpdateUserProfileOutput$domainId' => '<p>The identifier of the Amazon DataZone domain in which a user profile is updated.</p>', 'UserProfileSummary$domainId' => '<p>The ID of the Amazon DataZone domain of the user profile.</p>', ], ], 'DomainName' => [ 'base' => NULL, 'refs' => [ 'DomainSummary$name' => '<p>A name of an Amazon DataZone domain.</p>', ], ], 'DomainStatus' => [ 'base' => NULL, 'refs' => [ 'CreateDomainOutput$status' => '<p>The status of the Amazon DataZone domain.</p>', 'DeleteDomainOutput$status' => '<p>The status of the domain.</p>', 'DomainSummary$status' => '<p>The status of the Amazon DataZone domain.</p>', 'GetDomainOutput$status' => '<p>The status of the specified Amazon DataZone domain.</p>', 'ListDomainsInput$status' => '<p>The status of the data source.</p>', ], ], 'DomainSummaries' => [ 'base' => NULL, 'refs' => [ 'ListDomainsOutput$items' => '<p>The results of the <code>ListDomains</code> action.</p>', ], ], 'DomainSummary' => [ 'base' => '<p>A summary of a Amazon DataZone domain.</p>', 'refs' => [ 'DomainSummaries$member' => NULL, ], ], 'EdgeDirection' => [ 'base' => NULL, 'refs' => [ 'ListLineageNodeHistoryInput$direction' => '<p>The direction of the data lineage node refers to the lineage node having neighbors in that direction. For example, if direction is <code>UPSTREAM</code>, the <code>ListLineageNodeHistory</code> API responds with historical versions with upstream neighbors only.</p>', ], ], 'EditedValue' => [ 'base' => NULL, 'refs' => [ 'AcceptChoice$editedValue' => '<p>The edit of the prediction.</p>', ], ], 'EnableSetting' => [ 'base' => NULL, 'refs' => [ 'CreateDataSourceInput$enableSetting' => '<p>Specifies whether the data source is enabled.</p>', 'CreateDataSourceOutput$enableSetting' => '<p>Specifies whether the data source is enabled.</p>', 'DataSourceSummary$enableSetting' => '<p>Specifies whether the data source is enabled.</p>', 'DeleteDataSourceOutput$enableSetting' => '<p>The enable setting of the data source that specifies whether the data source is enabled or disabled.</p>', 'GetDataSourceOutput$enableSetting' => '<p>Specifies whether this data source is enabled or not.</p>', 'UpdateDataSourceInput$enableSetting' => '<p>The enable setting to be updated as part of the <code>UpdateDataSource</code> action.</p>', 'UpdateDataSourceOutput$enableSetting' => '<p>The enable setting to be updated as part of the <code>UpdateDataSource</code> action.</p>', ], ], 'EnabledRegionList' => [ 'base' => NULL, 'refs' => [ 'EnvironmentBlueprintConfigurationItem$enabledRegions' => '<p>The enabled Amazon Web Services Regions specified in a blueprint configuration.</p>', 'GetEnvironmentBlueprintConfigurationOutput$enabledRegions' => '<p>The Amazon Web Services regions in which this blueprint is enabled.</p>', 'PutEnvironmentBlueprintConfigurationInput$enabledRegions' => '<p>Specifies the enabled Amazon Web Services Regions.</p>', 'PutEnvironmentBlueprintConfigurationOutput$enabledRegions' => '<p>Specifies the enabled Amazon Web Services Regions.</p>', ], ], 'EntityId' => [ 'base' => NULL, 'refs' => [ 'GetTimeSeriesDataPointOutput$entityId' => '<p>The ID of the asset for which you want to get the data point.</p>', 'PostTimeSeriesDataPointsOutput$entityId' => '<p>The ID of the asset for which you want to post time series data points.</p>', ], ], 'EntityIdentifier' => [ 'base' => NULL, 'refs' => [ 'CreateListingChangeSetInput$entityIdentifier' => '<p>The ID of the asset.</p>', 'DeleteTimeSeriesDataPointsInput$entityIdentifier' => '<p>The ID of the asset for which you want to delete a time series form.</p>', 'GetTimeSeriesDataPointInput$entityIdentifier' => '<p>The ID of the asset for which you want to get the data point.</p>', 'ListTimeSeriesDataPointsInput$entityIdentifier' => '<p>The ID of the asset for which you want to list data points.</p>', 'PostTimeSeriesDataPointsInput$entityIdentifier' => '<p>The ID of the asset for which you want to post time series data points.</p>', ], ], 'EntityType' => [ 'base' => NULL, 'refs' => [ 'CreateListingChangeSetInput$entityType' => '<p>The type of an entity.</p>', ], ], 'EnvironmentActionId' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentActionOutput$id' => '<p>The ID of the environment action.</p>', 'EnvironmentActionSummary$id' => '<p>The ID of the environment action.</p>', 'GetEnvironmentActionOutput$id' => '<p>The ID of the environment action.</p>', 'UpdateEnvironmentActionOutput$id' => '<p>The ID of the environment action.</p>', ], ], 'EnvironmentActionList' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentOutput$environmentActions' => '<p>The configurable actions of this Amazon DataZone environment.</p>', 'GetEnvironmentOutput$environmentActions' => '<p>The actions of the environment.</p>', 'UpdateEnvironmentOutput$environmentActions' => '<p>The environment actions to be updated as part of the <code>UpdateEnvironment</code> action.</p>', ], ], 'EnvironmentActionSummary' => [ 'base' => '<p>The details about the specified action configured for an environment. For example, the details of the specified console links for an analytics tool that is available in this environment.</p>', 'refs' => [ 'ListEnvironmentActionSummaries$member' => NULL, ], ], 'EnvironmentBlueprintConfigurationItem' => [ 'base' => '<p>The configuration details of an environment blueprint.</p>', 'refs' => [ 'EnvironmentBlueprintConfigurations$member' => NULL, ], ], 'EnvironmentBlueprintConfigurations' => [ 'base' => NULL, 'refs' => [ 'ListEnvironmentBlueprintConfigurationsOutput$items' => '<p>The results of the <code>ListEnvironmentBlueprintConfigurations</code> action.</p>', ], ], 'EnvironmentBlueprintId' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentOutput$environmentBlueprintId' => '<p>The ID of the blueprint with which this Amazon DataZone environment was created.</p>', 'CreateEnvironmentProfileInput$environmentBlueprintIdentifier' => '<p>The ID of the blueprint with which this environment profile is created.</p>', 'CreateEnvironmentProfileOutput$environmentBlueprintId' => '<p>The ID of the blueprint with which this environment profile is created.</p>', 'DeleteEnvironmentBlueprintConfigurationInput$environmentBlueprintIdentifier' => '<p>The ID of the blueprint the configuration of which is deleted.</p>', 'EnvironmentBlueprintConfigurationItem$environmentBlueprintId' => '<p>The identifier of the environment blueprint.</p>', 'EnvironmentBlueprintSummary$id' => '<p>The identifier of the blueprint.</p>', 'EnvironmentProfileSummary$environmentBlueprintId' => '<p>The identifier of a blueprint with which an environment profile is created.</p>', 'GetEnvironmentBlueprintConfigurationInput$environmentBlueprintIdentifier' => '<p>He ID of the blueprint.</p>', 'GetEnvironmentBlueprintConfigurationOutput$environmentBlueprintId' => '<p>The ID of the blueprint.</p>', 'GetEnvironmentBlueprintInput$identifier' => '<p>The ID of this Amazon DataZone blueprint.</p>', 'GetEnvironmentBlueprintOutput$id' => '<p>The ID of this Amazon DataZone blueprint.</p>', 'GetEnvironmentOutput$environmentBlueprintId' => '<p>The blueprint with which the environment is created.</p>', 'GetEnvironmentProfileOutput$environmentBlueprintId' => '<p>The ID of the blueprint with which this environment profile is created.</p>', 'ListEnvironmentProfilesInput$environmentBlueprintIdentifier' => '<p>The identifier of the blueprint that was used to create the environment profiles that you want to list.</p>', 'ListEnvironmentsInput$environmentBlueprintIdentifier' => '<p>The identifier of the Amazon DataZone blueprint.</p>', 'PutEnvironmentBlueprintConfigurationInput$environmentBlueprintIdentifier' => '<p>The identifier of the environment blueprint.</p>', 'PutEnvironmentBlueprintConfigurationOutput$environmentBlueprintId' => '<p>The identifier of the environment blueprint.</p>', 'UpdateEnvironmentOutput$environmentBlueprintId' => '<p>The blueprint identifier of the environment.</p>', 'UpdateEnvironmentProfileOutput$environmentBlueprintId' => '<p>The identifier of the blueprint of the environment profile that is to be updated.</p>', ], ], 'EnvironmentBlueprintName' => [ 'base' => NULL, 'refs' => [ 'EnvironmentBlueprintSummary$name' => '<p>The name of the blueprint.</p>', 'GetEnvironmentBlueprintOutput$name' => '<p>The name of this Amazon DataZone blueprint.</p>', 'ListEnvironmentBlueprintsInput$name' => '<p>The name of the Amazon DataZone environment.</p>', ], ], 'EnvironmentBlueprintSummaries' => [ 'base' => NULL, 'refs' => [ 'ListEnvironmentBlueprintsOutput$items' => '<p>The results of the <code>ListEnvironmentBlueprints</code> action.</p>', ], ], 'EnvironmentBlueprintSummary' => [ 'base' => '<p>The details of an environment blueprint summary.</p>', 'refs' => [ 'EnvironmentBlueprintSummaries$member' => NULL, ], ], 'EnvironmentError' => [ 'base' => '<p>The failure reasons for the environment deployment.</p>', 'refs' => [ 'Deployment$failureReason' => '<p>The failure reason of the last deployment of the environment.</p>', ], ], 'EnvironmentId' => [ 'base' => NULL, 'refs' => [ 'AssociateEnvironmentRoleInput$environmentIdentifier' => '<p>The ID of the Amazon DataZone environment.</p>', 'CreateDataSourceOutput$environmentId' => '<p>The unique identifier of the Amazon DataZone environment to which the data source publishes assets. </p>', 'CreateEnvironmentActionInput$environmentIdentifier' => '<p>The ID of the environment in which the environment action is created.</p>', 'CreateEnvironmentActionOutput$environmentId' => '<p>The ID of the environment in which the environment is created.</p>', 'CreateEnvironmentOutput$id' => '<p>The ID of this Amazon DataZone environment.</p>', 'CreateSubscriptionGrantInput$environmentIdentifier' => '<p>The ID of the environment in which the subscription grant is created.</p>', 'CreateSubscriptionTargetInput$environmentIdentifier' => '<p>The ID of the environment in which subscription target is created.</p>', 'CreateSubscriptionTargetOutput$environmentId' => '<p>The ID of the environment in which the subscription target was created.</p>', 'DataSourceSummary$environmentId' => '<p>The ID of the environment in which the data source exists.</p>', 'DeleteDataSourceOutput$environmentId' => '<p>The ID of the environemnt associated with this data source.</p>', 'DeleteEnvironmentActionInput$environmentIdentifier' => '<p>The ID of the environment where an environment action is deleted.</p>', 'DeleteEnvironmentInput$identifier' => '<p>The identifier of the environment that is to be deleted.</p>', 'DeleteSubscriptionTargetInput$environmentIdentifier' => '<p>The ID of the Amazon DataZone environment in which the subscription target is deleted.</p>', 'DisassociateEnvironmentRoleInput$environmentIdentifier' => '<p>The ID of the environment.</p>', 'EnvironmentActionSummary$environmentId' => '<p>The environment ID of the environment action.</p>', 'EnvironmentSummary$id' => '<p>The identifier of the environment.</p>', 'GetDataSourceOutput$environmentId' => '<p>The ID of the environment where this data source creates and publishes assets,</p>', 'GetEnvironmentActionInput$environmentIdentifier' => '<p>The environment ID of the environment action.</p>', 'GetEnvironmentActionOutput$environmentId' => '<p>The environment ID of the environment action.</p>', 'GetEnvironmentInput$identifier' => '<p>The ID of the Amazon DataZone environment.</p>', 'GetEnvironmentOutput$id' => '<p>The ID of the environment.</p>', 'GetSubscriptionTargetInput$environmentIdentifier' => '<p>The ID of the environment associated with the subscription target.</p>', 'GetSubscriptionTargetOutput$environmentId' => '<p>The ID of the environment associated with the subscription target.</p>', 'ListEnvironmentActionsInput$environmentIdentifier' => '<p>The ID of the envrironment whose environment actions are listed.</p>', 'ListSubscriptionGrantsInput$environmentId' => '<p>The identifier of the Amazon DataZone environment.</p>', 'ListSubscriptionTargetsInput$environmentIdentifier' => '<p>The identifier of the environment where you want to list subscription targets.</p>', 'SubscriptionTargetSummary$environmentId' => '<p>The identifier of the environment of the subscription target.</p>', 'UpdateDataSourceOutput$environmentId' => '<p>The identifier of the environment in which a data source is to be updated.</p>', 'UpdateEnvironmentActionInput$environmentIdentifier' => '<p>The environment ID of the environment action.</p>', 'UpdateEnvironmentActionOutput$environmentId' => '<p>The environment ID of the environment action.</p>', 'UpdateEnvironmentInput$identifier' => '<p>The identifier of the environment that is to be updated.</p>', 'UpdateEnvironmentOutput$id' => '<p>The identifier of the environment that is to be updated.</p>', 'UpdateSubscriptionTargetInput$environmentIdentifier' => '<p>The identifier of the environment in which a subscription target is to be updated.</p>', 'UpdateSubscriptionTargetOutput$environmentId' => '<p>The identifier of the environment in which a subscription target is to be updated.</p>', ], ], 'EnvironmentName' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentOutput$name' => '<p>The name of this environment.</p>', 'EnvironmentSummary$name' => '<p>The name of the environment.</p>', 'GetEnvironmentOutput$name' => '<p>The name of the environment.</p>', 'UpdateEnvironmentOutput$name' => '<p>The name to be updated as part of the <code>UpdateEnvironment</code> action.</p>', ], ], 'EnvironmentParameter' => [ 'base' => '<p>The parameter details of an evironment profile.</p>', 'refs' => [ 'EnvironmentParametersList$member' => NULL, ], ], 'EnvironmentParametersList' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentInput$userParameters' => '<p>The user parameters of this Amazon DataZone environment.</p>', 'CreateEnvironmentProfileInput$userParameters' => '<p>The user parameters of this Amazon DataZone environment profile.</p>', 'UpdateEnvironmentProfileInput$userParameters' => '<p>The user parameters to be updated as part of the <code>UpdateEnvironmentProfile</code> action.</p>', ], ], 'EnvironmentProfileId' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentInput$environmentProfileIdentifier' => '<p>The identifier of the environment profile that is used to create this Amazon DataZone environment.</p>', 'CreateEnvironmentOutput$environmentProfileId' => '<p>The ID of the environment profile with which this Amazon DataZone environment was created.</p>', 'CreateEnvironmentProfileOutput$id' => '<p>The ID of this Amazon DataZone environment profile.</p>', 'DeleteEnvironmentProfileInput$identifier' => '<p>The ID of the environment profile that is deleted.</p>', 'EnvironmentProfileSummary$id' => '<p>The identifier of the environment profile.</p>', 'EnvironmentSummary$environmentProfileId' => '<p>The identifier of the environment profile with which the environment was created.</p>', 'GetEnvironmentOutput$environmentProfileId' => '<p>The ID of the environment profile with which the environment is created.</p>', 'GetEnvironmentProfileInput$identifier' => '<p>The ID of the environment profile.</p>', 'GetEnvironmentProfileOutput$id' => '<p>The ID of the environment profile.</p>', 'ListEnvironmentsInput$environmentProfileIdentifier' => '<p>The identifier of the environment profile.</p>', 'UpdateEnvironmentOutput$environmentProfileId' => '<p>The profile identifier of the environment.</p>', 'UpdateEnvironmentProfileInput$identifier' => '<p>The identifier of the environment profile that is to be updated.</p>', 'UpdateEnvironmentProfileOutput$id' => '<p>The identifier of the environment profile that is to be udpated.</p>', ], ], 'EnvironmentProfileName' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentProfileInput$name' => '<p>The name of this Amazon DataZone environment profile.</p>', 'CreateEnvironmentProfileOutput$name' => '<p>The name of this Amazon DataZone environment profile.</p>', 'EnvironmentProfileSummary$name' => '<p>The name of the environment profile.</p>', 'GetEnvironmentProfileOutput$name' => '<p>The name of the environment profile.</p>', 'ListEnvironmentProfilesInput$name' => '<p/>', 'UpdateEnvironmentProfileInput$name' => '<p>The name to be updated as part of the <code>UpdateEnvironmentProfile</code> action.</p>', 'UpdateEnvironmentProfileOutput$name' => '<p>The name to be updated as part of the <code>UpdateEnvironmentProfile</code> action.</p>', ], ], 'EnvironmentProfileSummaries' => [ 'base' => NULL, 'refs' => [ 'ListEnvironmentProfilesOutput$items' => '<p>The results of the <code>ListEnvironmentProfiles</code> action. </p>', ], ], 'EnvironmentProfileSummary' => [ 'base' => '<p>The details of an environment profile.</p>', 'refs' => [ 'EnvironmentProfileSummaries$member' => NULL, ], ], 'EnvironmentStatus' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentOutput$status' => '<p>The status of this Amazon DataZone environment.</p>', 'EnvironmentSummary$status' => '<p>The status of the environment.</p>', 'GetEnvironmentOutput$status' => '<p>The status of this Amazon DataZone environment.</p>', 'ListEnvironmentsInput$status' => '<p>The status of the environments that you want to list.</p>', 'UpdateEnvironmentOutput$status' => '<p>The status to be updated as part of the <code>UpdateEnvironment</code> action.</p>', ], ], 'EnvironmentSummaries' => [ 'base' => NULL, 'refs' => [ 'ListEnvironmentsOutput$items' => '<p>The results of the <code>ListEnvironments</code> action.</p>', ], ], 'EnvironmentSummary' => [ 'base' => '<p>The details of an environment.</p>', 'refs' => [ 'EnvironmentSummaries$member' => NULL, ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'ConflictException$message' => NULL, 'InternalServerException$message' => NULL, 'ResourceNotFoundException$message' => NULL, 'ServiceQuotaExceededException$message' => NULL, 'ThrottlingException$message' => NULL, 'UnauthorizedException$message' => NULL, 'ValidationException$message' => NULL, ], ], 'ExternalIdentifier' => [ 'base' => NULL, 'refs' => [ 'AssetItem$externalIdentifier' => '<p>The external identifier of the Amazon DataZone inventory asset.</p>', 'CreateAssetInput$externalIdentifier' => '<p>The external identifier of the asset.</p>', 'CreateAssetOutput$externalIdentifier' => '<p>The external identifier of the asset.</p>', 'CreateAssetRevisionOutput$externalIdentifier' => '<p>The external identifier of the asset.</p>', 'GetAssetOutput$externalIdentifier' => '<p>The external ID of the asset.</p>', ], ], 'FailureCause' => [ 'base' => '<p>Specifies the error message that is returned if the operation cannot be successfully completed.</p>', 'refs' => [ 'SubscribedAsset$failureCause' => '<p>The failure cause included in the details of the asset for which the subscription grant is created.</p>', 'UpdateSubscriptionGrantStatusInput$failureCause' => '<p>Specifies the error message that is returned if the operation cannot be successfully completed.</p>', ], ], 'FailureReasons' => [ 'base' => NULL, 'refs' => [ 'CreateProjectOutput$failureReasons' => '<p>Specifies the error message that is returned if the operation cannot be successfully completed.</p>', 'GetProjectOutput$failureReasons' => '<p>Specifies the error message that is returned if the operation cannot be successfully completed.</p>', 'ProjectSummary$failureReasons' => '<p>Specifies the error message that is returned if the operation cannot be successfully completed.</p>', 'UpdateProjectOutput$failureReasons' => '<p>Specifies the error message that is returned if the operation cannot be successfully completed.</p>', ], ], 'Filter' => [ 'base' => '<p>A search filter in Amazon DataZone.</p>', 'refs' => [ 'FilterClause$filter' => '<p>A search filter in Amazon DataZone.</p>', ], ], 'FilterClause' => [ 'base' => '<p>A search filter clause in Amazon DataZone.</p>', 'refs' => [ 'FilterList$member' => NULL, 'SearchInput$filters' => '<p>Specifies the search filters.</p>', 'SearchListingsInput$filters' => '<p>Specifies the filters for the search of listings.</p>', 'SearchTypesInput$filters' => '<p>The filters for the <code>SearchTypes</code> action.</p>', ], ], 'FilterExpression' => [ 'base' => '<p>A filter expression in Amazon DataZone.</p>', 'refs' => [ 'FilterExpressions$member' => NULL, ], ], 'FilterExpressionExpressionString' => [ 'base' => NULL, 'refs' => [ 'FilterExpression$expression' => '<p>The search filter expression.</p>', ], ], 'FilterExpressionType' => [ 'base' => NULL, 'refs' => [ 'FilterExpression$type' => '<p>The search filter explresison type.</p>', ], ], 'FilterExpressions' => [ 'base' => NULL, 'refs' => [ 'RelationalFilterConfiguration$filterExpressions' => '<p>The filter expressions specified in the relational filter configuration for the data source.</p>', ], ], 'FilterList' => [ 'base' => NULL, 'refs' => [ 'FilterClause$and' => '<p>The \'and\' search filter clause in Amazon DataZone.</p>', 'FilterClause$or' => '<p>The \'or\' search filter clause in Amazon DataZone.</p>', ], ], 'FilterValueString' => [ 'base' => NULL, 'refs' => [ 'Filter$value' => '<p>A search filter value in Amazon DataZone.</p>', ], ], 'FirstName' => [ 'base' => NULL, 'refs' => [ 'SsoUserProfileDetails$firstName' => '<p>The first name included in the single sign-on details of the user profile.</p>', ], ], 'Float' => [ 'base' => NULL, 'refs' => [ 'AcceptRule$threshold' => '<p>The confidence score that specifies the condition at which a prediction can be accepted.</p>', 'RejectRule$threshold' => '<p>The confidence score that specifies the condition at which a prediction can be rejected.</p>', ], ], 'FormEntryInput' => [ 'base' => '<p>The details of the form entry.</p>', 'refs' => [ 'FormsInputMap$value' => NULL, ], ], 'FormEntryOutput' => [ 'base' => '<p>The details of the form entry.</p>', 'refs' => [ 'FormsOutputMap$value' => NULL, ], ], 'FormInput' => [ 'base' => '<p>The details of a metadata form.</p>', 'refs' => [ 'FormInputList$member' => NULL, ], ], 'FormInputContentString' => [ 'base' => NULL, 'refs' => [ 'FormInput$content' => '<p>The content of the metadata form.</p>', ], ], 'FormInputList' => [ 'base' => NULL, 'refs' => [ 'CreateAssetInput$formsInput' => '<p>Metadata forms attached to the asset.</p>', 'CreateAssetRevisionInput$formsInput' => '<p>The metadata forms to be attached to the asset as part of asset revision.</p>', 'CreateDataSourceInput$assetFormsInput' => '<p>The metadata forms that are to be attached to the assets that this data source works with.</p>', 'UpdateDataSourceInput$assetFormsInput' => '<p>The asset forms to be updated as part of the <code>UpdateDataSource</code> action.</p>', ], ], 'FormName' => [ 'base' => NULL, 'refs' => [ 'FormInput$formName' => '<p>The name of the metadata form.</p>', 'FormOutput$formName' => '<p>The name of the metadata form.</p>', 'FormsInputMap$key' => NULL, 'FormsOutputMap$key' => NULL, 'SubscriptionTargetForm$formName' => '<p>The form name included in the subscription target configuration.</p>', ], ], 'FormOutput' => [ 'base' => '<p>The details of a metadata form.</p>', 'refs' => [ 'FormOutputList$member' => NULL, ], ], 'FormOutputList' => [ 'base' => NULL, 'refs' => [ 'AssetItemAdditionalAttributes$formsOutput' => '<p>The forms included in the additional attributes of an inventory asset.</p>', 'AssetItemAdditionalAttributes$readOnlyFormsOutput' => '<p>The read-only forms included in the additional attributes of an inventory asset.</p>', 'CreateAssetOutput$formsOutput' => '<p>The metadata forms that are attached to the created asset.</p>', 'CreateAssetOutput$readOnlyFormsOutput' => '<p>The read-only metadata forms that are attached to the created asset.</p>', 'CreateAssetRevisionOutput$formsOutput' => '<p>The metadata forms that were attached to the asset as part of the asset revision.</p>', 'CreateAssetRevisionOutput$readOnlyFormsOutput' => '<p>The read-only metadata forms that were attached to the asset as part of the asset revision.</p>', 'CreateDataSourceOutput$assetFormsOutput' => '<p>The metadata forms attached to the assets that this data source creates.</p>', 'DeleteDataSourceOutput$assetFormsOutput' => '<p>The asset data forms associated with this data source.</p>', 'GetAssetOutput$formsOutput' => '<p>The metadata forms attached to the asset.</p>', 'GetAssetOutput$readOnlyFormsOutput' => '<p>The read-only metadata forms attached to the asset.</p>', 'GetDataSourceOutput$assetFormsOutput' => '<p>The metadata forms attached to the assets created by this data source.</p>', 'GetLineageNodeOutput$formsOutput' => '<p>The metadata of the specified data lineage node.</p>', 'UpdateDataSourceOutput$assetFormsOutput' => '<p>The asset forms to be updated as part of the <code>UpdateDataSource</code> action.</p>', ], ], 'FormTypeData' => [ 'base' => '<p>The details of the metadata form type.</p>', 'refs' => [ 'SearchTypesResultItem$formTypeItem' => '<p>The form type included in the results of the <code>SearchTypes</code> action.</p>', ], ], 'FormTypeIdentifier' => [ 'base' => NULL, 'refs' => [ 'DeleteFormTypeInput$formTypeIdentifier' => '<p>The ID of the metadata form type that is deleted.</p>', 'FormEntryInput$typeIdentifier' => '<p>The type ID of the form entry.</p>', 'FormInput$typeIdentifier' => '<p>The ID of the metadata form type.</p>', 'GetFormTypeInput$formTypeIdentifier' => '<p>The ID of the metadata form type.</p>', 'TimeSeriesDataPointFormInput$typeIdentifier' => '<p>The ID of the type of the time series data points form.</p>', 'TimeSeriesDataPointFormOutput$typeIdentifier' => '<p>The ID of the type of the time series data points form.</p>', 'TimeSeriesDataPointSummaryFormOutput$typeIdentifier' => '<p>The type ID of the time series data points summary form.</p>', ], ], 'FormTypeName' => [ 'base' => NULL, 'refs' => [ 'CreateFormTypeInput$name' => '<p>The name of this Amazon DataZone metadata form type.</p>', 'CreateFormTypeOutput$name' => '<p>The name of this Amazon DataZone metadata form type.</p>', 'FormEntryOutput$typeName' => '<p>The name of the type of the form entry.</p>', 'FormOutput$typeName' => '<p>The name of the metadata form type.</p>', 'FormTypeData$name' => '<p>The name of the form type.</p>', 'GetFormTypeOutput$name' => '<p>The name of the metadata form type.</p>', 'Import$name' => '<p>The name of the import.</p>', ], ], 'FormTypeStatus' => [ 'base' => NULL, 'refs' => [ 'CreateFormTypeInput$status' => '<p>The status of this Amazon DataZone metadata form type.</p>', 'FormTypeData$status' => '<p>The status of the form type.</p>', 'GetFormTypeOutput$status' => '<p>The status of the metadata form type.</p>', ], ], 'Forms' => [ 'base' => NULL, 'refs' => [ 'AssetListing$forms' => '<p>The metadata forms attached to an asset published in an Amazon DataZone catalog. </p>', 'AssetListingItemAdditionalAttributes$forms' => '<p>The metadata forms that form additional attributes of the metadata asset.</p>', 'SubscribedAssetListing$forms' => '<p>The forms attached to the published asset for which the subscription grant is created.</p>', ], ], 'FormsInputMap' => [ 'base' => NULL, 'refs' => [ 'CreateAssetTypeInput$formsInput' => '<p>The metadata forms that are to be attached to the custom asset type.</p>', ], ], 'FormsOutputMap' => [ 'base' => NULL, 'refs' => [ 'AssetTypeItem$formsOutput' => '<p>The forms included in the details of the asset type.</p>', 'CreateAssetTypeOutput$formsOutput' => '<p>The metadata forms that are attached to the asset type.</p>', 'GetAssetTypeOutput$formsOutput' => '<p>The metadata forms attached to the asset type.</p>', 'LineageNodeTypeItem$formsOutput' => '<p>The forms output of the data lineage node type.</p>', ], ], 'GetAssetInput' => [ 'base' => NULL, 'refs' => [], ], 'GetAssetOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetAssetTypeInput' => [ 'base' => NULL, 'refs' => [], ], 'GetAssetTypeOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetDataSourceInput' => [ 'base' => NULL, 'refs' => [], ], 'GetDataSourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetDataSourceRunInput' => [ 'base' => NULL, 'refs' => [], ], 'GetDataSourceRunOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetDomainInput' => [ 'base' => NULL, 'refs' => [], ], 'GetDomainOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetEnvironmentActionInput' => [ 'base' => NULL, 'refs' => [], ], 'GetEnvironmentActionOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetEnvironmentBlueprintConfigurationInput' => [ 'base' => NULL, 'refs' => [], ], 'GetEnvironmentBlueprintConfigurationOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetEnvironmentBlueprintInput' => [ 'base' => NULL, 'refs' => [], ], 'GetEnvironmentBlueprintOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetEnvironmentInput' => [ 'base' => NULL, 'refs' => [], ], 'GetEnvironmentOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetEnvironmentProfileInput' => [ 'base' => NULL, 'refs' => [], ], 'GetEnvironmentProfileOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetFormTypeInput' => [ 'base' => NULL, 'refs' => [], ], 'GetFormTypeOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetGlossaryInput' => [ 'base' => NULL, 'refs' => [], ], 'GetGlossaryOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetGlossaryTermInput' => [ 'base' => NULL, 'refs' => [], ], 'GetGlossaryTermOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetGroupProfileInput' => [ 'base' => NULL, 'refs' => [], ], 'GetGroupProfileOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetIamPortalLoginUrlInput' => [ 'base' => NULL, 'refs' => [], ], 'GetIamPortalLoginUrlOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetLineageNodeInput' => [ 'base' => NULL, 'refs' => [], ], 'GetLineageNodeOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetListingInput' => [ 'base' => NULL, 'refs' => [], ], 'GetListingOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetMetadataGenerationRunInput' => [ 'base' => NULL, 'refs' => [], ], 'GetMetadataGenerationRunOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetProjectInput' => [ 'base' => NULL, 'refs' => [], ], 'GetProjectOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetSubscriptionGrantInput' => [ 'base' => NULL, 'refs' => [], ], 'GetSubscriptionGrantOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetSubscriptionInput' => [ 'base' => NULL, 'refs' => [], ], 'GetSubscriptionOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetSubscriptionRequestDetailsInput' => [ 'base' => NULL, 'refs' => [], ], 'GetSubscriptionRequestDetailsOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetSubscriptionRequestDetailsOutputSubscribedListingsList' => [ 'base' => NULL, 'refs' => [ 'GetSubscriptionRequestDetailsOutput$subscribedListings' => '<p>The subscribed listings in the subscription request.</p>', ], ], 'GetSubscriptionRequestDetailsOutputSubscribedPrincipalsList' => [ 'base' => NULL, 'refs' => [ 'GetSubscriptionRequestDetailsOutput$subscribedPrincipals' => '<p>The subscribed principals in the subscription request.</p>', ], ], 'GetSubscriptionTargetInput' => [ 'base' => NULL, 'refs' => [], ], 'GetSubscriptionTargetOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetTimeSeriesDataPointInput' => [ 'base' => NULL, 'refs' => [], ], 'GetTimeSeriesDataPointOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetUserProfileInput' => [ 'base' => NULL, 'refs' => [], ], 'GetUserProfileOutput' => [ 'base' => NULL, 'refs' => [], ], 'GlossaryDescription' => [ 'base' => NULL, 'refs' => [ 'CreateGlossaryInput$description' => '<p>The description of this business glossary.</p>', 'CreateGlossaryOutput$description' => '<p>The description of this business glossary.</p>', 'GetGlossaryOutput$description' => '<p>The description of the business glossary.</p>', 'GlossaryItem$description' => '<p>The business glossary description.</p>', 'UpdateGlossaryInput$description' => '<p>The description to be updated as part of the <code>UpdateGlossary</code> action.</p>', 'UpdateGlossaryOutput$description' => '<p>The description to be updated as part of the <code>UpdateGlossary</code> action.</p>', ], ], 'GlossaryId' => [ 'base' => NULL, 'refs' => [ 'CreateGlossaryOutput$id' => '<p>The ID of this business glossary.</p>', 'CreateGlossaryTermOutput$glossaryId' => '<p>The ID of the business glossary in which this term is created.</p>', 'DeleteGlossaryInput$identifier' => '<p>The ID of the business glossary that is deleted.</p>', 'GetGlossaryInput$identifier' => '<p>The ID of the business glossary.</p>', 'GetGlossaryOutput$id' => '<p>The ID of the business glossary.</p>', 'GetGlossaryTermOutput$glossaryId' => '<p>The ID of the business glossary to which this term belongs.</p>', 'GlossaryItem$id' => '<p>The identifier of the glossary.</p>', 'GlossaryTermItem$glossaryId' => '<p>The identifier of the business glossary to which the term belongs.</p>', 'UpdateGlossaryInput$identifier' => '<p>The identifier of the business glossary to be updated.</p>', 'UpdateGlossaryOutput$id' => '<p>The identifier of the business glossary that is to be updated.</p>', 'UpdateGlossaryTermOutput$glossaryId' => '<p>The identifier of the business glossary in which a term is to be updated.</p>', ], ], 'GlossaryItem' => [ 'base' => '<p>The details of a business glossary.</p>', 'refs' => [ 'SearchInventoryResultItem$glossaryItem' => '<p>The glossary item included in the search results.</p>', ], ], 'GlossaryName' => [ 'base' => NULL, 'refs' => [ 'CreateGlossaryInput$name' => '<p>The name of this business glossary.</p>', 'CreateGlossaryOutput$name' => '<p>The name of this business glossary.</p>', 'GetGlossaryOutput$name' => '<p>The name of the business glossary.</p>', 'GlossaryItem$name' => '<p>The name of the glossary.</p>', 'UpdateGlossaryInput$name' => '<p>The name to be updated as part of the <code>UpdateGlossary</code> action.</p>', 'UpdateGlossaryOutput$name' => '<p>The name to be updated as part of the <code>UpdateGlossary</code> action.</p>', ], ], 'GlossaryStatus' => [ 'base' => NULL, 'refs' => [ 'CreateGlossaryInput$status' => '<p>The status of this business glossary.</p>', 'CreateGlossaryOutput$status' => '<p>The status of this business glossary.</p>', 'GetGlossaryOutput$status' => '<p>The status of the business glossary.</p>', 'GlossaryItem$status' => '<p>The business glossary status.</p>', 'UpdateGlossaryInput$status' => '<p>The status to be updated as part of the <code>UpdateGlossary</code> action.</p>', 'UpdateGlossaryOutput$status' => '<p>The status to be updated as part of the <code>UpdateGlossary</code> action.</p>', ], ], 'GlossaryTermId' => [ 'base' => NULL, 'refs' => [ 'CreateGlossaryTermInput$glossaryIdentifier' => '<p>The ID of the business glossary in which this term is created.</p>', 'CreateGlossaryTermOutput$id' => '<p>The ID of this business glossary term.</p>', 'DeleteGlossaryTermInput$identifier' => '<p>The ID of the business glossary term that is deleted.</p>', 'GetGlossaryTermInput$identifier' => '<p>The ID of the business glossary term.</p>', 'GetGlossaryTermOutput$id' => '<p>The ID of the business glossary term.</p>', 'GlossaryTermItem$id' => '<p>The identifier of the business glossary term.</p>', 'GlossaryTerms$member' => NULL, 'TermRelationsClassifiesList$member' => NULL, 'TermRelationsIsAList$member' => NULL, 'UpdateGlossaryTermInput$glossaryIdentifier' => '<p>The identifier of the business glossary in which a term is to be updated.</p>', 'UpdateGlossaryTermInput$identifier' => '<p>The identifier of the business glossary term that is to be updated.</p>', 'UpdateGlossaryTermOutput$id' => '<p>The identifier of the business glossary term that is to be updated.</p>', ], ], 'GlossaryTermItem' => [ 'base' => '<p>The details of a business glossary term.</p>', 'refs' => [ 'SearchInventoryResultItem$glossaryTermItem' => '<p>The glossary term item included in the search results.</p>', ], ], 'GlossaryTermName' => [ 'base' => NULL, 'refs' => [ 'CreateGlossaryTermInput$name' => '<p>The name of this business glossary term.</p>', 'CreateGlossaryTermOutput$name' => '<p>The name of this business glossary term.</p>', 'DetailedGlossaryTerm$name' => '<p>The name of a glossary term attached to the inventory asset.</p>', 'GetGlossaryTermOutput$name' => '<p>The name of the business glossary term.</p>', 'GlossaryTermItem$name' => '<p>The name of the business glossary term.</p>', 'UpdateGlossaryTermInput$name' => '<p>The name to be updated as part of the <code>UpdateGlossaryTerm</code> action.</p>', 'UpdateGlossaryTermOutput$name' => '<p>The name to be updated as part of the <code>UpdateGlossaryTerm</code> action.</p>', ], ], 'GlossaryTermStatus' => [ 'base' => NULL, 'refs' => [ 'CreateGlossaryTermInput$status' => '<p>The status of this business glossary term.</p>', 'CreateGlossaryTermOutput$status' => '<p>The status of this business glossary term.</p>', 'GetGlossaryTermOutput$status' => '<p>The status of the business glossary term.</p>', 'GlossaryTermItem$status' => '<p>The status of the business glossary term.</p>', 'UpdateGlossaryTermInput$status' => '<p>The status to be updated as part of the <code>UpdateGlossaryTerm</code> action.</p>', 'UpdateGlossaryTermOutput$status' => '<p>The status to be updated as part of the <code>UpdateGlossaryTerm</code> action.</p>', ], ], 'GlossaryTerms' => [ 'base' => NULL, 'refs' => [ 'AssetItem$glossaryTerms' => '<p>The glossary terms attached to the Amazon DataZone inventory asset.</p>', 'CreateAssetInput$glossaryTerms' => '<p>Glossary terms attached to the asset.</p>', 'CreateAssetOutput$glossaryTerms' => '<p>The glossary terms that are attached to the created asset.</p>', 'CreateAssetRevisionInput$glossaryTerms' => '<p>The glossary terms to be attached to the asset as part of asset revision.</p>', 'CreateAssetRevisionOutput$glossaryTerms' => '<p>The glossary terms that were attached to the asset as part of asset revision.</p>', 'CreateEnvironmentInput$glossaryTerms' => '<p>The glossary terms that can be used in this Amazon DataZone environment.</p>', 'CreateEnvironmentOutput$glossaryTerms' => '<p>The glossary terms that can be used in this Amazon DataZone environment.</p>', 'CreateProjectInput$glossaryTerms' => '<p>The glossary terms that can be used in this Amazon DataZone project.</p>', 'CreateProjectOutput$glossaryTerms' => '<p>The glossary terms that can be used in the project.</p>', 'DataProductSummary$glossaryTerms' => '<p/>', 'GetAssetOutput$glossaryTerms' => '<p>The business glossary terms attached to the asset.</p>', 'GetEnvironmentBlueprintOutput$glossaryTerms' => '<p>The glossary terms attached to this Amazon DataZone blueprint.</p>', 'GetEnvironmentOutput$glossaryTerms' => '<p>The business glossary terms that can be used in this environment.</p>', 'GetProjectOutput$glossaryTerms' => '<p>The business glossary terms that can be used in the project.</p>', 'UpdateEnvironmentInput$glossaryTerms' => '<p>The glossary terms to be updated as part of the <code>UpdateEnvironment</code> action.</p>', 'UpdateEnvironmentOutput$glossaryTerms' => '<p>The glossary terms to be updated as part of the <code>UpdateEnvironment</code> action.</p>', 'UpdateProjectInput$glossaryTerms' => '<p>The glossary terms to be updated as part of the <code>UpdateProject</code> action.</p>', 'UpdateProjectOutput$glossaryTerms' => '<p>The glossary terms of the project that are to be updated.</p>', ], ], 'GlueRunConfigurationInput' => [ 'base' => '<p>The configuration details of the Amazon Web Services Glue data source.</p>', 'refs' => [ 'DataSourceConfigurationInput$glueRunConfiguration' => '<p>The configuration of the Amazon Web Services Glue data source.</p>', ], ], 'GlueRunConfigurationInputDataAccessRoleString' => [ 'base' => NULL, 'refs' => [ 'GlueRunConfigurationInput$dataAccessRole' => '<p>The data access role included in the configuration details of the Amazon Web Services Glue data source.</p>', ], ], 'GlueRunConfigurationOutput' => [ 'base' => '<p>The configuration details of the Amazon Web Services Glue data source.</p>', 'refs' => [ 'DataSourceConfigurationOutput$glueRunConfiguration' => '<p>The configuration of the Amazon Web Services Glue data source.</p>', ], ], 'GlueRunConfigurationOutputAccountIdString' => [ 'base' => NULL, 'refs' => [ 'GlueRunConfigurationOutput$accountId' => '<p>The Amazon Web Services account ID included in the configuration details of the Amazon Web Services Glue data source. </p>', ], ], 'GlueRunConfigurationOutputDataAccessRoleString' => [ 'base' => NULL, 'refs' => [ 'GlueRunConfigurationOutput$dataAccessRole' => '<p>The data access role included in the configuration details of the Amazon Web Services Glue data source. </p>', ], ], 'GlueRunConfigurationOutputRegionString' => [ 'base' => NULL, 'refs' => [ 'GlueRunConfigurationOutput$region' => '<p>The Amazon Web Services region included in the configuration details of the Amazon Web Services Glue data source. </p>', ], ], 'GlueSelfGrantStatusOutput' => [ 'base' => '<p>The details of the self granting status.</p>', 'refs' => [ 'SelfGrantStatusOutput$glueSelfGrantStatus' => '<p>The details for the self granting status for a Glue data source.</p>', ], ], 'GrantedEntity' => [ 'base' => '<p>The details of a listing for which a subscription is granted.</p>', 'refs' => [ 'CreateSubscriptionGrantOutput$grantedEntity' => '<p>The entity to which the subscription is granted.</p>', 'DeleteSubscriptionGrantOutput$grantedEntity' => '<p>The entity to which the subscription is deleted.</p>', 'GetSubscriptionGrantOutput$grantedEntity' => '<p>The entity to which the subscription is granted.</p>', 'SubscriptionGrantSummary$grantedEntity' => '<p>The entity to which the subscription is granted.</p>', 'UpdateSubscriptionGrantStatusOutput$grantedEntity' => '<p>The granted entity to be updated as part of the <code>UpdateSubscriptionGrantStatus</code> action.</p>', ], ], 'GrantedEntityInput' => [ 'base' => '<p>The details of a listing for which a subscription is to be granted.</p>', 'refs' => [ 'CreateSubscriptionGrantInput$grantedEntity' => '<p>The entity to which the subscription is to be granted.</p>', ], ], 'GroupDetails' => [ 'base' => '<p>The details of a group in Amazon DataZone.</p>', 'refs' => [ 'MemberDetails$group' => '<p>The group details of a project member.</p>', ], ], 'GroupIdentifier' => [ 'base' => NULL, 'refs' => [ 'CreateGroupProfileInput$groupIdentifier' => '<p>The identifier of the group for which the group profile is created.</p>', 'GetGroupProfileInput$groupIdentifier' => '<p>The identifier of the group profile.</p>', 'UpdateGroupProfileInput$groupIdentifier' => '<p>The identifier of the group profile that is updated.</p>', ], ], 'GroupProfileId' => [ 'base' => NULL, 'refs' => [ 'CreateGroupProfileOutput$id' => '<p>The identifier of the group profile.</p>', 'GetGroupProfileOutput$id' => '<p>The identifier of the group profile.</p>', 'GroupProfileSummary$id' => '<p>The ID of a group profile.</p>', 'UpdateGroupProfileOutput$id' => '<p>The identifier of the group profile that is updated.</p>', ], ], 'GroupProfileName' => [ 'base' => NULL, 'refs' => [ 'CreateGroupProfileOutput$groupName' => '<p>The name of the group for which group profile is created.</p>', 'GetGroupProfileOutput$groupName' => '<p>The name of the group for which the specified group profile exists.</p>', 'GroupProfileSummary$groupName' => '<p>The group name of a group profile.</p>', 'UpdateGroupProfileOutput$groupName' => '<p>The name of the group profile that is updated.</p>', ], ], 'GroupProfileStatus' => [ 'base' => NULL, 'refs' => [ 'CreateGroupProfileOutput$status' => '<p>The status of the group profile.</p>', 'GetGroupProfileOutput$status' => '<p>The identifier of the group profile.</p>', 'GroupProfileSummary$status' => '<p>The status of a group profile.</p>', 'UpdateGroupProfileInput$status' => '<p>The status of the group profile that is updated.</p>', 'UpdateGroupProfileOutput$status' => '<p>The status of the group profile that is updated.</p>', ], ], 'GroupProfileSummaries' => [ 'base' => NULL, 'refs' => [ 'SearchGroupProfilesOutput$items' => '<p>The results of the <code>SearchGroupProfiles</code> action.</p>', ], ], 'GroupProfileSummary' => [ 'base' => '<p>The details of a group profile.</p>', 'refs' => [ 'GroupProfileSummaries$member' => NULL, ], ], 'GroupSearchText' => [ 'base' => NULL, 'refs' => [ 'SearchGroupProfilesInput$searchText' => '<p>Specifies the text for which to search.</p>', ], ], 'GroupSearchType' => [ 'base' => NULL, 'refs' => [ 'SearchGroupProfilesInput$groupType' => '<p>The group type for which to search.</p>', ], ], 'IamUserProfileDetails' => [ 'base' => '<p>The details of an IAM user profile in Amazon DataZone.</p>', 'refs' => [ 'UserProfileDetails$iam' => '<p>The IAM details included in the user profile details.</p>', ], ], 'Import' => [ 'base' => '<p>The details of the import of the metadata form type.</p>', 'refs' => [ 'ImportList$member' => NULL, ], ], 'ImportList' => [ 'base' => NULL, 'refs' => [ 'FormTypeData$imports' => '<p>The imports specified in the form type.</p>', 'GetFormTypeOutput$imports' => '<p>The imports of the metadata form type.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'AcceptChoice$predictionChoice' => '<p>Specifies the prediction (aka, the automatically generated piece of metadata) that can be accepted.</p>', 'DataSourceSummary$lastRunAssetCount' => '<p>The count of the assets created during the last data source run.</p>', 'GetDataSourceOutput$lastRunAssetCount' => '<p>The number of assets created by the data source during its last run.</p>', 'PredictionChoices$member' => NULL, 'RunStatisticsForAssets$added' => '<p>The <code>added</code> statistic for the data source run.</p>', 'RunStatisticsForAssets$failed' => '<p>The <code>failed</code> statistic for the data source run.</p>', 'RunStatisticsForAssets$skipped' => '<p>The <code>skipped</code> statistic for the data source run.</p>', 'RunStatisticsForAssets$unchanged' => '<p>The <code>unchanged</code> statistic for the data source run.</p>', 'RunStatisticsForAssets$updated' => '<p>The <code>updated</code> statistic for the data source run.</p>', 'SearchListingsOutput$totalMatchCount' => '<p>Total number of search results.</p>', 'SearchOutput$totalMatchCount' => '<p>Total number of search results.</p>', 'SearchTypesOutput$totalMatchCount' => '<p>Total number of search results.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>The request has failed because of an unknown error, exception or failure.</p>', 'refs' => [], ], 'InventorySearchScope' => [ 'base' => NULL, 'refs' => [ 'SearchInput$searchScope' => '<p>The scope of the search.</p>', ], ], 'KmsKeyArn' => [ 'base' => NULL, 'refs' => [ 'CreateDomainInput$kmsKeyIdentifier' => '<p>The identifier of the Amazon Web Services Key Management Service (KMS) key that is used to encrypt the Amazon DataZone domain, metadata, and reporting data. </p>', 'CreateDomainOutput$kmsKeyIdentifier' => '<p>The identifier of the Amazon Web Services Key Management Service (KMS) key that is used to encrypt the Amazon DataZone domain, metadata, and reporting data. </p>', 'GetDomainOutput$kmsKeyIdentifier' => '<p>The identifier of the Amazon Web Services Key Management Service (KMS) key that is used to encrypt the Amazon DataZone domain, metadata, and reporting data. </p>', ], ], 'LastName' => [ 'base' => NULL, 'refs' => [ 'SsoUserProfileDetails$lastName' => '<p>The last name included in the single sign-on details of the user profile.</p>', ], ], 'LineageEvent' => [ 'base' => NULL, 'refs' => [ 'PostLineageEventInput$event' => '<p>The data lineage event that you want to post. Only open-lineage run event are supported as events. </p>', ], ], 'LineageNodeId' => [ 'base' => NULL, 'refs' => [ 'GetLineageNodeOutput$id' => '<p>The ID of the data lineage node.</p>', 'LineageNodeReference$id' => '<p>The ID of the data lineage node.</p>', 'LineageNodeSummary$id' => '<p>The ID of the data lineage node.</p>', ], ], 'LineageNodeIdentifier' => [ 'base' => NULL, 'refs' => [ 'GetLineageNodeInput$identifier' => '<p>The ID of the data lineage node that you want to get.</p> <p>Both, a lineage node identifier generated by Amazon DataZone and a <code>sourceIdentifier</code> of the lineage node are supported. If <code>sourceIdentifier</code> is greater than 1800 characters, you can use lineage node identifier generated by Amazon DataZone to get the node details.</p>', 'ListLineageNodeHistoryInput$identifier' => '<p>The ID of the data lineage node whose history you want to list.</p>', ], ], 'LineageNodeReference' => [ 'base' => '<p>The reference details for the data lineage node.</p>', 'refs' => [ 'LineageNodeReferenceList$member' => NULL, ], ], 'LineageNodeReferenceList' => [ 'base' => NULL, 'refs' => [ 'GetLineageNodeOutput$downstreamNodes' => '<p>The downsteam nodes of the specified data lineage node.</p>', 'GetLineageNodeOutput$upstreamNodes' => '<p>The upstream nodes of the specified data lineage node.</p>', ], ], 'LineageNodeSummaries' => [ 'base' => NULL, 'refs' => [ 'ListLineageNodeHistoryOutput$nodes' => '<p>The nodes returned by the ListLineageNodeHistory action.</p>', ], ], 'LineageNodeSummary' => [ 'base' => '<p>The summary of the data lineage node.</p>', 'refs' => [ 'LineageNodeSummaries$member' => NULL, ], ], 'LineageNodeTypeItem' => [ 'base' => '<p>The details of a data lineage node type.</p>', 'refs' => [ 'SearchTypesResultItem$lineageNodeTypeItem' => '<p>The details of a data lineage node type.</p>', ], ], 'ListAssetRevisionsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListAssetRevisionsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListDataSourceRunActivitiesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListDataSourceRunActivitiesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListDataSourceRunsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListDataSourceRunsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListDataSourcesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListDataSourcesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListDomainsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListDomainsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListEnvironmentActionSummaries' => [ 'base' => NULL, 'refs' => [ 'ListEnvironmentActionsOutput$items' => '<p>The results of <code>ListEnvironmentActions</code>.</p>', ], ], 'ListEnvironmentActionsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListEnvironmentActionsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListEnvironmentBlueprintConfigurationsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListEnvironmentBlueprintConfigurationsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListEnvironmentBlueprintsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListEnvironmentBlueprintsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListEnvironmentProfilesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListEnvironmentProfilesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListEnvironmentsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListEnvironmentsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListLineageNodeHistoryInput' => [ 'base' => NULL, 'refs' => [], ], 'ListLineageNodeHistoryOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListMetadataGenerationRunsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListMetadataGenerationRunsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListNotificationsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListNotificationsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListProjectMembershipsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListProjectMembershipsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListProjectsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListProjectsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListSubscriptionGrantsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListSubscriptionGrantsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListSubscriptionRequestsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListSubscriptionRequestsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListSubscriptionTargetsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListSubscriptionTargetsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListSubscriptionsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListSubscriptionsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTimeSeriesDataPointsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListTimeSeriesDataPointsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListingId' => [ 'base' => NULL, 'refs' => [ 'AssetListingDetails$listingId' => '<p>The identifier of an asset published in an Amazon DataZone catalog. </p>', 'AssetListingItem$listingId' => '<p>The identifier of the listing (asset published in Amazon DataZone catalog).</p>', 'CreateListingChangeSetOutput$listingId' => '<p>The ID of the listing (a record of an asset at a given time).</p>', 'DeleteListingInput$identifier' => '<p>The ID of the listing to be deleted.</p>', 'GetListingInput$identifier' => '<p>The ID of the listing.</p>', 'GetListingOutput$id' => '<p>The ID of the listing.</p>', 'ListSubscriptionGrantsInput$subscribedListingId' => '<p>The identifier of the subscribed listing.</p>', 'ListSubscriptionRequestsInput$subscribedListingId' => '<p>The identifier of the subscribed listing.</p>', 'ListSubscriptionsInput$subscribedListingId' => '<p>The identifier of the subscribed listing for the subscriptions that you want to list.</p>', 'ListingRevision$id' => '<p>An identifier of a revision of an asset published in a Amazon DataZone catalog.</p>', 'ListingRevisionInput$identifier' => '<p>An identifier of revision to be made to an asset published in a Amazon DataZone catalog.</p>', 'SubscribedListing$id' => '<p>The identifier of the published asset for which the subscription grant is created.</p>', 'SubscribedListingInput$identifier' => '<p>The identifier of the published asset for which the subscription grant is to be created.</p>', ], ], 'ListingItem' => [ 'base' => '<p>The details of a listing (aka asset published in a Amazon DataZone catalog).</p>', 'refs' => [ 'GetListingOutput$item' => '<p>The details of a listing.</p>', ], ], 'ListingName' => [ 'base' => NULL, 'refs' => [ 'GetListingOutput$name' => '<p>The name of the listing.</p>', 'SubscribedListing$name' => '<p>The name of the published asset for which the subscription grant is created.</p>', ], ], 'ListingRevision' => [ 'base' => '<p>A revision of an asset published in a Amazon DataZone catalog.</p>', 'refs' => [ 'GrantedEntity$listing' => '<p>The listing for which a subscription is granted.</p>', ], ], 'ListingRevisionInput' => [ 'base' => '<p>A revision to be made to an asset published in a Amazon DataZone catalog.</p>', 'refs' => [ 'GrantedEntityInput$listing' => '<p>The listing for which a subscription is to be granted.</p>', ], ], 'ListingStatus' => [ 'base' => NULL, 'refs' => [ 'AssetListingDetails$listingStatus' => '<p>The status of an asset published in an Amazon DataZone catalog. </p>', 'CreateListingChangeSetOutput$status' => '<p>Specifies the status of the listing.</p>', 'GetListingOutput$status' => '<p>The status of the listing.</p>', ], ], 'LongDescription' => [ 'base' => NULL, 'refs' => [ 'CreateGlossaryTermInput$longDescription' => '<p>The long description of this business glossary term.</p>', 'CreateGlossaryTermOutput$longDescription' => '<p>The long description of this business glossary term.</p>', 'GetGlossaryTermOutput$longDescription' => '<p>The long description of the business glossary term.</p>', 'GlossaryTermItem$longDescription' => '<p>The long description of the business glossary term.</p>', 'UpdateGlossaryTermInput$longDescription' => '<p>The long description to be updated as part of the <code>UpdateGlossaryTerm</code> action.</p>', 'UpdateGlossaryTermOutput$longDescription' => '<p>The long description to be updated as part of the <code>UpdateGlossaryTerm</code> action.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListAssetRevisionsInput$maxResults' => '<p>The maximum number of revisions to return in a single call to <code>ListAssetRevisions</code>. When the number of revisions to be listed is greater than the value of <code>MaxResults</code>, the response contains a <code>NextToken</code> value that you can use in a subsequent call to <code>ListAssetRevisions</code> to list the next set of revisions.</p>', 'ListDataSourceRunActivitiesInput$maxResults' => '<p>The maximum number of activities to return in a single call to <code>ListDataSourceRunActivities</code>. When the number of activities to be listed is greater than the value of <code>MaxResults</code>, the response contains a <code>NextToken</code> value that you can use in a subsequent call to <code>ListDataSourceRunActivities</code> to list the next set of activities.</p>', 'ListDataSourceRunsInput$maxResults' => '<p>The maximum number of runs to return in a single call to <code>ListDataSourceRuns</code>. When the number of runs to be listed is greater than the value of <code>MaxResults</code>, the response contains a <code>NextToken</code> value that you can use in a subsequent call to <code>ListDataSourceRuns</code> to list the next set of runs.</p>', 'ListDataSourcesInput$maxResults' => '<p>The maximum number of data sources to return in a single call to <code>ListDataSources</code>. When the number of data sources to be listed is greater than the value of <code>MaxResults</code>, the response contains a <code>NextToken</code> value that you can use in a subsequent call to <code>ListDataSources</code> to list the next set of data sources.</p>', 'ListEnvironmentActionsInput$maxResults' => '<p>The maximum number of environment actions to return in a single call to <code>ListEnvironmentActions</code>. When the number of environment actions to be listed is greater than the value of <code>MaxResults</code>, the response contains a <code>NextToken</code> value that you can use in a subsequent call to <code>ListEnvironmentActions</code> to list the next set of environment actions.</p>', 'ListEnvironmentBlueprintConfigurationsInput$maxResults' => '<p>The maximum number of blueprint configurations to return in a single call to <code>ListEnvironmentBlueprintConfigurations</code>. When the number of configurations to be listed is greater than the value of <code>MaxResults</code>, the response contains a <code>NextToken</code> value that you can use in a subsequent call to <code>ListEnvironmentBlueprintConfigurations</code> to list the next set of configurations.</p>', 'ListEnvironmentBlueprintsInput$maxResults' => '<p>The maximum number of blueprints to return in a single call to <code>ListEnvironmentBlueprints</code>. When the number of blueprints to be listed is greater than the value of <code>MaxResults</code>, the response contains a <code>NextToken</code> value that you can use in a subsequent call to <code>ListEnvironmentBlueprints</code> to list the next set of blueprints.</p>', 'ListEnvironmentProfilesInput$maxResults' => '<p>The maximum number of environment profiles to return in a single call to <code>ListEnvironmentProfiles</code>. When the number of environment profiles to be listed is greater than the value of <code>MaxResults</code>, the response contains a <code>NextToken</code> value that you can use in a subsequent call to <code>ListEnvironmentProfiles</code> to list the next set of environment profiles.</p>', 'ListEnvironmentsInput$maxResults' => '<p>The maximum number of environments to return in a single call to <code>ListEnvironments</code>. When the number of environments to be listed is greater than the value of <code>MaxResults</code>, the response contains a <code>NextToken</code> value that you can use in a subsequent call to <code>ListEnvironments</code> to list the next set of environments.</p>', 'ListLineageNodeHistoryInput$maxResults' => '<p>The maximum number of history items to return in a single call to ListLineageNodeHistory. When the number of memberships to be listed is greater than the value of MaxResults, the response contains a NextToken value that you can use in a subsequent call to ListLineageNodeHistory to list the next set of items.</p>', 'ListMetadataGenerationRunsInput$maxResults' => '<p>The maximum number of metadata generation runs to return in a single call to ListMetadataGenerationRuns. When the number of metadata generation runs to be listed is greater than the value of MaxResults, the response contains a NextToken value that you can use in a subsequent call to ListMetadataGenerationRuns to list the next set of revisions.</p>', 'ListNotificationsInput$maxResults' => '<p>The maximum number of notifications to return in a single call to <code>ListNotifications</code>. When the number of notifications to be listed is greater than the value of <code>MaxResults</code>, the response contains a <code>NextToken</code> value that you can use in a subsequent call to <code>ListNotifications</code> to list the next set of notifications.</p>', 'ListProjectMembershipsInput$maxResults' => '<p>The maximum number of memberships to return in a single call to <code>ListProjectMemberships</code>. When the number of memberships to be listed is greater than the value of <code>MaxResults</code>, the response contains a <code>NextToken</code> value that you can use in a subsequent call to <code>ListProjectMemberships</code> to list the next set of memberships.</p>', 'ListProjectsInput$maxResults' => '<p>The maximum number of projects to return in a single call to <code>ListProjects</code>. When the number of projects to be listed is greater than the value of <code>MaxResults</code>, the response contains a <code>NextToken</code> value that you can use in a subsequent call to <code>ListProjects</code> to list the next set of projects.</p>', 'ListSubscriptionGrantsInput$maxResults' => '<p>The maximum number of subscription grants to return in a single call to <code>ListSubscriptionGrants</code>. When the number of subscription grants to be listed is greater than the value of <code>MaxResults</code>, the response contains a <code>NextToken</code> value that you can use in a subsequent call to <code>ListSubscriptionGrants</code> to list the next set of subscription grants.</p>', 'ListSubscriptionRequestsInput$maxResults' => '<p>The maximum number of subscription requests to return in a single call to <code>ListSubscriptionRequests</code>. When the number of subscription requests to be listed is greater than the value of <code>MaxResults</code>, the response contains a <code>NextToken</code> value that you can use in a subsequent call to <code>ListSubscriptionRequests</code> to list the next set of subscription requests.</p>', 'ListSubscriptionTargetsInput$maxResults' => '<p>The maximum number of subscription targets to return in a single call to <code>ListSubscriptionTargets</code>. When the number of subscription targets to be listed is greater than the value of <code>MaxResults</code>, the response contains a <code>NextToken</code> value that you can use in a subsequent call to <code>ListSubscriptionTargets</code> to list the next set of subscription targets. </p>', 'ListSubscriptionsInput$maxResults' => '<p>The maximum number of subscriptions to return in a single call to <code>ListSubscriptions</code>. When the number of subscriptions to be listed is greater than the value of <code>MaxResults</code>, the response contains a <code>NextToken</code> value that you can use in a subsequent call to <code>ListSubscriptions</code> to list the next set of Subscriptions. </p>', 'ListTimeSeriesDataPointsInput$maxResults' => '<p>The maximum number of data points to return in a single call to ListTimeSeriesDataPoints. When the number of data points to be listed is greater than the value of MaxResults, the response contains a NextToken value that you can use in a subsequent call to ListTimeSeriesDataPoints to list the next set of data points.</p>', 'SearchGroupProfilesInput$maxResults' => '<p>The maximum number of results to return in a single call to <code>SearchGroupProfiles</code>. When the number of results to be listed is greater than the value of <code>MaxResults</code>, the response contains a <code>NextToken</code> value that you can use in a subsequent call to <code>SearchGroupProfiles</code> to list the next set of results. </p>', 'SearchInput$maxResults' => '<p>The maximum number of results to return in a single call to <code>Search</code>. When the number of results to be listed is greater than the value of <code>MaxResults</code>, the response contains a <code>NextToken</code> value that you can use in a subsequent call to <code>Search</code> to list the next set of results.</p>', 'SearchListingsInput$maxResults' => '<p>The maximum number of results to return in a single call to <code>SearchListings</code>. When the number of results to be listed is greater than the value of <code>MaxResults</code>, the response contains a <code>NextToken</code> value that you can use in a subsequent call to <code>SearchListings</code> to list the next set of results. </p>', 'SearchTypesInput$maxResults' => '<p>The maximum number of results to return in a single call to <code>SearchTypes</code>. When the number of results to be listed is greater than the value of <code>MaxResults</code>, the response contains a <code>NextToken</code> value that you can use in a subsequent call to <code>SearchTypes</code> to list the next set of results. </p>', 'SearchUserProfilesInput$maxResults' => '<p>The maximum number of results to return in a single call to <code>SearchUserProfiles</code>. When the number of results to be listed is greater than the value of <code>MaxResults</code>, the response contains a <code>NextToken</code> value that you can use in a subsequent call to <code>SearchUserProfiles</code> to list the next set of results. </p>', ], ], 'MaxResultsForListDomains' => [ 'base' => NULL, 'refs' => [ 'ListDomainsInput$maxResults' => '<p>The maximum number of domains to return in a single call to <code>ListDomains</code>. When the number of domains to be listed is greater than the value of <code>MaxResults</code>, the response contains a <code>NextToken</code> value that you can use in a subsequent call to <code>ListDomains</code> to list the next set of domains.</p>', ], ], 'Member' => [ 'base' => '<p>The details about a project member.</p>', 'refs' => [ 'CreateProjectMembershipInput$member' => '<p>The project member whose project membership was created.</p>', 'DeleteProjectMembershipInput$member' => '<p>The project member whose project membership is deleted.</p>', ], ], 'MemberDetails' => [ 'base' => '<p>The details about a project member.</p>', 'refs' => [ 'ProjectMember$memberDetails' => '<p>The membership details of a project member.</p>', ], ], 'Message' => [ 'base' => NULL, 'refs' => [ 'NotificationOutput$message' => '<p>The message included in the notification.</p>', ], ], 'MetadataGenerationRunIdentifier' => [ 'base' => NULL, 'refs' => [ 'CancelMetadataGenerationRunInput$identifier' => '<p>The ID of the metadata generation run.</p>', 'GetMetadataGenerationRunInput$identifier' => '<p>The identifier of the metadata generation run.</p>', 'GetMetadataGenerationRunOutput$id' => '<p>The ID of the metadata generation run.</p>', 'MetadataGenerationRunItem$id' => '<p>The ID of the metadata generation run.</p>', 'StartMetadataGenerationRunOutput$id' => '<p>The ID of the metadata generation run.</p>', ], ], 'MetadataGenerationRunItem' => [ 'base' => '<p>The metadata generation run.</p>', 'refs' => [ 'MetadataGenerationRuns$member' => NULL, ], ], 'MetadataGenerationRunStatus' => [ 'base' => NULL, 'refs' => [ 'GetMetadataGenerationRunOutput$status' => '<p>The status of the metadata generation run.</p>', 'ListMetadataGenerationRunsInput$status' => '<p>The status of the metadata generation runs.</p>', 'MetadataGenerationRunItem$status' => '<p>The status of the metadata generation run.</p>', 'StartMetadataGenerationRunOutput$status' => '<p>The status of the metadata generation run.</p>', ], ], 'MetadataGenerationRunTarget' => [ 'base' => '<p>The asset for which metadata was generated.</p>', 'refs' => [ 'GetMetadataGenerationRunOutput$target' => '<p>The asset for which you\'re generating metadata.</p>', 'MetadataGenerationRunItem$target' => '<p>The asset for which metadata was generated.</p>', 'StartMetadataGenerationRunInput$target' => '<p>The asset for which you want to start a metadata generation run.</p>', ], ], 'MetadataGenerationRunType' => [ 'base' => NULL, 'refs' => [ 'GetMetadataGenerationRunOutput$type' => '<p>The type of metadata generation run.</p>', 'ListMetadataGenerationRunsInput$type' => '<p>The type of the metadata generation runs.</p>', 'MetadataGenerationRunItem$type' => '<p>The type of the metadata generation run.</p>', 'StartMetadataGenerationRunInput$type' => '<p>The type of the metadata generation run.</p>', 'StartMetadataGenerationRunOutput$type' => '<p>The type of the metadata generation run.</p>', ], ], 'MetadataGenerationRuns' => [ 'base' => NULL, 'refs' => [ 'ListMetadataGenerationRunsOutput$items' => '<p>The results of the ListMetadataGenerationRuns action.</p>', ], ], 'MetadataGenerationTargetType' => [ 'base' => NULL, 'refs' => [ 'MetadataGenerationRunTarget$type' => '<p>The type of the asset for which metadata was generated.</p>', ], ], 'MetadataMap' => [ 'base' => NULL, 'refs' => [ 'NotificationOutput$metadata' => '<p>The metadata included in the notification.</p>', ], ], 'Model' => [ 'base' => '<p>The model of the API.</p>', 'refs' => [ 'CreateFormTypeInput$model' => '<p>The model of this Amazon DataZone metadata form type.</p>', 'FormTypeData$model' => '<p>The model of the form type.</p>', 'GetFormTypeOutput$model' => '<p>The model of the metadata form type.</p>', ], ], 'Name' => [ 'base' => NULL, 'refs' => [ 'CreateDataSourceInput$name' => '<p>The name of the data source.</p>', 'CreateDataSourceOutput$name' => '<p>The name of the data source.</p>', 'DataSourceRunActivity$database' => '<p>The database included in the data source run activity.</p>', 'DataSourceRunActivity$technicalName' => '<p>The technical name included in the data source run activity.</p>', 'DataSourceSummary$name' => '<p>The name of the data source.</p>', 'DeleteDataSourceOutput$name' => '<p>The name of the data source that is deleted.</p>', 'GetDataSourceOutput$name' => '<p>The name of the data source.</p>', 'ListDataSourcesInput$name' => '<p>The name of the data source.</p>', 'UpdateDataSourceInput$name' => '<p>The name to be updated as part of the <code>UpdateDataSource</code> action.</p>', 'UpdateDataSourceOutput$name' => '<p>The name to be updated as part of the <code>UpdateDataSource</code> action.</p>', ], ], 'NotificationOutput' => [ 'base' => '<p>The details of a notification generated in Amazon DataZone.</p>', 'refs' => [ 'NotificationsList$member' => NULL, ], ], 'NotificationResource' => [ 'base' => '<p>The details of the resource mentioned in a notification.</p>', 'refs' => [ 'Topic$resource' => NULL, ], ], 'NotificationResourceType' => [ 'base' => NULL, 'refs' => [ 'NotificationResource$type' => '<p>The type of the resource mentioned in a notification.</p>', ], ], 'NotificationRole' => [ 'base' => NULL, 'refs' => [ 'Topic$role' => '<p>The role of the resource mentioned in a notification.</p>', ], ], 'NotificationSubjects' => [ 'base' => NULL, 'refs' => [ 'ListNotificationsInput$subjects' => '<p>The subjects of notifications.</p>', ], ], 'NotificationType' => [ 'base' => NULL, 'refs' => [ 'ListNotificationsInput$type' => '<p>The type of notifications.</p>', 'NotificationOutput$type' => '<p>The type of the notification.</p>', ], ], 'NotificationsList' => [ 'base' => NULL, 'refs' => [ 'ListNotificationsOutput$notifications' => '<p>The results of the <code>ListNotifications</code> action.</p>', ], ], 'PaginationToken' => [ 'base' => NULL, 'refs' => [ 'ListAssetRevisionsInput$nextToken' => '<p>When the number of revisions is greater than the default value for the <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of revisions, the response includes a pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call to <code>ListAssetRevisions</code> to list the next set of revisions.</p>', 'ListAssetRevisionsOutput$nextToken' => '<p>When the number of revisions is greater than the default value for the <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of revisions, the response includes a pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call to <code>ListAssetRevisions</code> to list the next set of revisions.</p>', 'ListDataSourceRunActivitiesInput$nextToken' => '<p>When the number of activities is greater than the default value for the <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of activities, the response includes a pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call to <code>ListDataSourceRunActivities</code> to list the next set of activities.</p>', 'ListDataSourceRunActivitiesOutput$nextToken' => '<p>When the number of activities is greater than the default value for the <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of activities, the response includes a pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call to <code>ListDataSourceRunActivities</code> to list the next set of activities.</p>', 'ListDataSourceRunsInput$nextToken' => '<p>When the number of runs is greater than the default value for the <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of runs, the response includes a pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call to <code>ListDataSourceRuns</code> to list the next set of runs.</p>', 'ListDataSourceRunsOutput$nextToken' => '<p>When the number of runs is greater than the default value for the <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of runs, the response includes a pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call to <code>ListDataSourceRuns</code> to list the next set of runs.</p>', 'ListDataSourcesInput$nextToken' => '<p>When the number of data sources is greater than the default value for the <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of data sources, the response includes a pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call to <code>ListDataSources</code> to list the next set of data sources.</p>', 'ListDataSourcesOutput$nextToken' => '<p>When the number of data sources is greater than the default value for the <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of data sources, the response includes a pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call to <code>ListDataSources</code> to list the next set of data sources.</p>', 'ListDomainsInput$nextToken' => '<p>When the number of domains is greater than the default value for the <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of domains, the response includes a pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call to <code>ListDomains</code> to list the next set of domains.</p>', 'ListDomainsOutput$nextToken' => '<p>When the number of domains is greater than the default value for the <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of domains, the response includes a pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call to <code>ListDomains</code> to list the next set of domains.</p>', 'ListEnvironmentActionsInput$nextToken' => '<p>When the number of environment actions is greater than the default value for the <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of environment actions, the response includes a pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call to <code>ListEnvironmentActions</code> to list the next set of environment actions.</p>', 'ListEnvironmentActionsOutput$nextToken' => '<p>When the number of environment actions is greater than the default value for the <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of environment actions, the response includes a pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call to <code>ListEnvironmentActions</code> to list the next set of environment actions.</p>', 'ListEnvironmentBlueprintConfigurationsInput$nextToken' => '<p>When the number of blueprint configurations is greater than the default value for the <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of configurations, the response includes a pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call to <code>ListEnvironmentBlueprintConfigurations</code> to list the next set of configurations.</p>', 'ListEnvironmentBlueprintConfigurationsOutput$nextToken' => '<p>When the number of blueprint configurations is greater than the default value for the <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of configurations, the response includes a pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call to <code>ListEnvironmentBlueprintConfigurations</code> to list the next set of configurations.</p>', 'ListEnvironmentBlueprintsInput$nextToken' => '<p>When the number of blueprints in the environment is greater than the default value for the <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of blueprints in the environment, the response includes a pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call to <code>ListEnvironmentBlueprints</code>to list the next set of blueprints.</p>', 'ListEnvironmentBlueprintsOutput$nextToken' => '<p>When the number of blueprints in the environment is greater than the default value for the <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of blueprints in the environment, the response includes a pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call to <code>ListEnvironmentBlueprints</code>to list the next set of blueprints.</p>', 'ListEnvironmentProfilesInput$nextToken' => '<p>When the number of environment profiles is greater than the default value for the <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of environment profiles, the response includes a pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call to <code>ListEnvironmentProfiles</code> to list the next set of environment profiles.</p>', 'ListEnvironmentProfilesOutput$nextToken' => '<p>When the number of environment profiles is greater than the default value for the <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of environment profiles, the response includes a pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call to <code>ListEnvironmentProfiles</code> to list the next set of environment profiles.</p>', 'ListEnvironmentsInput$nextToken' => '<p>When the number of environments is greater than the default value for the <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of environments, the response includes a pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call to <code>ListEnvironments</code> to list the next set of environments.</p>', 'ListEnvironmentsOutput$nextToken' => '<p>When the number of environments is greater than the default value for the <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of environments, the response includes a pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call to <code>ListEnvironments</code> to list the next set of environments.</p>', 'ListLineageNodeHistoryInput$nextToken' => '<p>When the number of history items is greater than the default value for the MaxResults parameter, or if you explicitly specify a value for MaxResults that is less than the number of items, the response includes a pagination token named NextToken. You can specify this NextToken value in a subsequent call to ListLineageNodeHistory to list the next set of items.</p>', 'ListLineageNodeHistoryOutput$nextToken' => '<p>When the number of history items is greater than the default value for the MaxResults parameter, or if you explicitly specify a value for MaxResults that is less than the number of items, the response includes a pagination token named NextToken. You can specify this NextToken value in a subsequent call to ListLineageNodeHistory to list the next set of items.</p>', 'ListMetadataGenerationRunsInput$nextToken' => '<p>When the number of metadata generation runs is greater than the default value for the MaxResults parameter, or if you explicitly specify a value for MaxResults that is less than the number of metadata generation runs, the response includes a pagination token named NextToken. You can specify this NextToken value in a subsequent call to ListMetadataGenerationRuns to list the next set of revisions.</p>', 'ListMetadataGenerationRunsOutput$nextToken' => '<p>When the number of metadata generation runs is greater than the default value for the MaxResults parameter, or if you explicitly specify a value for MaxResults that is less than the number of metadata generation runs, the response includes a pagination token named NextToken. You can specify this NextToken value in a subsequent call to ListMetadataGenerationRuns to list the next set of revisions.</p>', 'ListNotificationsInput$nextToken' => '<p>When the number of notifications is greater than the default value for the <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of notifications, the response includes a pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call to <code>ListNotifications</code> to list the next set of notifications.</p>', 'ListNotificationsOutput$nextToken' => '<p>When the number of notifications is greater than the default value for the <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of notifications, the response includes a pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call to <code>ListNotifications</code> to list the next set of notifications.</p>', 'ListProjectMembershipsInput$nextToken' => '<p>When the number of memberships is greater than the default value for the <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of memberships, the response includes a pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call to <code>ListProjectMemberships</code> to list the next set of memberships.</p>', 'ListProjectMembershipsOutput$nextToken' => '<p>When the number of memberships is greater than the default value for the <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of memberships, the response includes a pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call to <code>ListProjectMemberships</code> to list the next set of memberships.</p>', 'ListProjectsInput$nextToken' => '<p>When the number of projects is greater than the default value for the <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of projects, the response includes a pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call to <code>ListProjects</code> to list the next set of projects.</p>', 'ListProjectsOutput$nextToken' => '<p>When the number of projects is greater than the default value for the <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of projects, the response includes a pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call to <code>ListProjects</code> to list the next set of projects.</p>', 'ListSubscriptionGrantsInput$nextToken' => '<p>When the number of subscription grants is greater than the default value for the <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of subscription grants, the response includes a pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call to <code>ListSubscriptionGrants</code> to list the next set of subscription grants.</p>', 'ListSubscriptionGrantsOutput$nextToken' => '<p>When the number of subscription grants is greater than the default value for the <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of subscription grants, the response includes a pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call to <code>ListSubscriptionGrants</code> to list the next set of subscription grants.</p>', 'ListSubscriptionRequestsInput$nextToken' => '<p>When the number of subscription requests is greater than the default value for the <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of subscription requests, the response includes a pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call to <code>ListSubscriptionRequests</code> to list the next set of subscription requests.</p>', 'ListSubscriptionRequestsOutput$nextToken' => '<p>When the number of subscription requests is greater than the default value for the <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of subscription requests, the response includes a pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call to <code>ListSubscriptionRequests</code> to list the next set of subscription requests.</p>', 'ListSubscriptionTargetsInput$nextToken' => '<p>When the number of subscription targets is greater than the default value for the <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of subscription targets, the response includes a pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call to <code>ListSubscriptionTargets</code> to list the next set of subscription targets.</p>', 'ListSubscriptionTargetsOutput$nextToken' => '<p>When the number of subscription targets is greater than the default value for the <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of subscription targets, the response includes a pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call to <code>ListSubscriptionTargets</code> to list the next set of subscription targets.</p>', 'ListSubscriptionsInput$nextToken' => '<p>When the number of subscriptions is greater than the default value for the <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of subscriptions, the response includes a pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call to <code>ListSubscriptions</code> to list the next set of subscriptions.</p>', 'ListSubscriptionsOutput$nextToken' => '<p>When the number of subscriptions is greater than the default value for the <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of subscriptions, the response includes a pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call to <code>ListSubscriptions</code> to list the next set of subscriptions.</p>', 'ListTimeSeriesDataPointsInput$nextToken' => '<p>When the number of data points is greater than the default value for the MaxResults parameter, or if you explicitly specify a value for MaxResults that is less than the number of data points, the response includes a pagination token named NextToken. You can specify this NextToken value in a subsequent call to ListTimeSeriesDataPoints to list the next set of data points.</p>', 'ListTimeSeriesDataPointsOutput$nextToken' => '<p>When the number of data points is greater than the default value for the MaxResults parameter, or if you explicitly specify a value for MaxResults that is less than the number of data points, the response includes a pagination token named NextToken. You can specify this NextToken value in a subsequent call to ListTimeSeriesDataPoints to list the next set of data points.</p>', 'SearchGroupProfilesInput$nextToken' => '<p>When the number of results is greater than the default value for the <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of results, the response includes a pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call to <code>SearchGroupProfiles</code> to list the next set of results.</p>', 'SearchGroupProfilesOutput$nextToken' => '<p>When the number of results is greater than the default value for the <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of results, the response includes a pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call to <code>SearchGroupProfiles</code> to list the next set of results.</p>', 'SearchInput$nextToken' => '<p>When the number of results is greater than the default value for the <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of results, the response includes a pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call to <code>Search</code> to list the next set of results.</p>', 'SearchListingsInput$nextToken' => '<p>When the number of results is greater than the default value for the <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of results, the response includes a pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call to <code>SearchListings</code> to list the next set of results.</p>', 'SearchListingsOutput$nextToken' => '<p>When the number of results is greater than the default value for the <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of results, the response includes a pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call to <code>SearchListings</code> to list the next set of results.</p>', 'SearchOutput$nextToken' => '<p>When the number of results is greater than the default value for the <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of results, the response includes a pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call to <code>Search</code> to list the next set of results.</p>', 'SearchTypesInput$nextToken' => '<p>When the number of results is greater than the default value for the <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of results, the response includes a pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call to <code>SearchTypes</code> to list the next set of results.</p>', 'SearchTypesOutput$nextToken' => '<p>When the number of results is greater than the default value for the <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of results, the response includes a pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call to <code>SearchTypes</code> to list the next set of results.</p>', 'SearchUserProfilesInput$nextToken' => '<p>When the number of results is greater than the default value for the <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of results, the response includes a pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call to <code>SearchUserProfiles</code> to list the next set of results.</p>', 'SearchUserProfilesOutput$nextToken' => '<p>When the number of results is greater than the default value for the <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of results, the response includes a pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call to <code>SearchUserProfiles</code> to list the next set of results.</p>', ], ], 'PostLineageEventInput' => [ 'base' => NULL, 'refs' => [], ], 'PostLineageEventOutput' => [ 'base' => NULL, 'refs' => [], ], 'PostTimeSeriesDataPointsInput' => [ 'base' => NULL, 'refs' => [], ], 'PostTimeSeriesDataPointsOutput' => [ 'base' => NULL, 'refs' => [], ], 'PredictionChoices' => [ 'base' => NULL, 'refs' => [ 'RejectChoice$predictionChoices' => '<p>Specifies the the automatically generated business metadata that can be rejected.</p>', ], ], 'PredictionConfiguration' => [ 'base' => '<p>The configuration of the prediction.</p>', 'refs' => [ 'CreateAssetInput$predictionConfiguration' => '<p>The configuration of the automatically generated business-friendly metadata for the asset.</p>', 'CreateAssetOutput$predictionConfiguration' => '<p>The configuration of the automatically generated business-friendly metadata for the asset.</p>', 'CreateAssetRevisionInput$predictionConfiguration' => '<p>The configuration of the automatically generated business-friendly metadata for the asset.</p>', 'CreateAssetRevisionOutput$predictionConfiguration' => '<p>The configuration of the automatically generated business-friendly metadata for the asset.</p>', ], ], 'ProjectDeletionError' => [ 'base' => '<p>Specifies the error message that is returned if the operation cannot be successfully completed.</p>', 'refs' => [ 'FailureReasons$member' => NULL, ], ], 'ProjectId' => [ 'base' => NULL, 'refs' => [ 'AssetItem$owningProjectId' => '<p>The identifier of the Amazon DataZone project that owns the inventory asset.</p>', 'AssetListing$owningProjectId' => '<p>The identifier of the project where an asset published in an Amazon DataZone catalog exists. </p>', 'AssetListingItem$owningProjectId' => '<p>The identifier of the project that owns the inventory asset.</p>', 'AssetTypeItem$originProjectId' => '<p>The identifier of the Amazon DataZone project where the asset type exists.</p>', 'AssetTypeItem$owningProjectId' => '<p>The identifier of the Amazon DataZone project that owns the asset type.</p>', 'CreateAssetInput$owningProjectIdentifier' => '<p>The unique identifier of the project that owns this asset.</p>', 'CreateAssetOutput$owningProjectId' => '<p>The ID of the Amazon DataZone project that owns the created asset. </p>', 'CreateAssetRevisionOutput$owningProjectId' => '<p>The unique identifier of the revised project that owns the asset.</p>', 'CreateAssetTypeInput$owningProjectIdentifier' => '<p>The identifier of the Amazon DataZone project that is to own the custom asset type.</p>', 'CreateAssetTypeOutput$originProjectId' => '<p>The ID of the Amazon DataZone project where the asset type was originally created.</p>', 'CreateAssetTypeOutput$owningProjectId' => '<p>The ID of the Amazon DataZone project that currently owns this asset type.</p>', 'CreateDataSourceOutput$projectId' => '<p>The ID of the Amazon DataZone project to which the data source is added.</p>', 'CreateEnvironmentInput$projectIdentifier' => '<p>The identifier of the Amazon DataZone project in which this environment is created.</p>', 'CreateEnvironmentOutput$projectId' => '<p>The ID of the Amazon DataZone project in which this environment is created.</p>', 'CreateEnvironmentProfileInput$projectIdentifier' => '<p>The identifier of the project in which to create the environment profile.</p>', 'CreateEnvironmentProfileOutput$projectId' => '<p>The ID of the Amazon DataZone project in which this environment profile is created.</p>', 'CreateFormTypeInput$owningProjectIdentifier' => '<p>The ID of the Amazon DataZone project that owns this metadata form type.</p>', 'CreateFormTypeOutput$originProjectId' => '<p>The ID of the project in which this Amazon DataZone metadata form type was originally created.</p>', 'CreateFormTypeOutput$owningProjectId' => '<p>The ID of the project that owns this Amazon DataZone metadata form type.</p>', 'CreateGlossaryInput$owningProjectIdentifier' => '<p>The ID of the project that currently owns business glossary.</p>', 'CreateGlossaryOutput$owningProjectId' => '<p>The ID of the project that currently owns this business glossary.</p>', 'CreateProjectMembershipInput$projectIdentifier' => '<p>The ID of the project for which this project membership was created.</p>', 'CreateProjectOutput$id' => '<p>The ID of the Amazon DataZone project.</p>', 'CreateSubscriptionTargetOutput$projectId' => '<p>???</p>', 'DataProductSummary$owningProjectId' => '<p/>', 'DataSourceRunActivity$projectId' => '<p>The project ID included in the data source run activity.</p>', 'DataSourceRunSummary$projectId' => '<p>The project ID of the data source run.</p>', 'DeleteDataSourceOutput$projectId' => '<p>The ID of the project in which this data source exists and from which it\'s deleted.</p>', 'DeleteProjectInput$identifier' => '<p>The identifier of the project that is to be deleted.</p>', 'DeleteProjectMembershipInput$projectIdentifier' => '<p>The ID of the Amazon DataZone project the membership to which is deleted.</p>', 'EnvironmentProfileSummary$projectId' => '<p>The identifier of a project in which an environment profile exists.</p>', 'EnvironmentSummary$projectId' => '<p>The identifier of the project in which the environment exists.</p>', 'FormTypeData$originProjectId' => '<p>The identifier of the project in which the form type was originally created.</p>', 'FormTypeData$owningProjectId' => '<p>The identifier of the project that owns the form type.</p>', 'GetAssetOutput$owningProjectId' => '<p>The ID of the project that owns the asset.</p>', 'GetAssetTypeOutput$originProjectId' => '<p>The ID of the Amazon DataZone project in which the asset type was originally created.</p>', 'GetAssetTypeOutput$owningProjectId' => '<p>The ID of the Amazon DataZone project that owns the asset type.</p>', 'GetDataSourceOutput$projectId' => '<p>The ID of the project where the data source creates and publishes assets.</p>', 'GetDataSourceRunOutput$projectId' => '<p>The ID of the project in which this data source run occured.</p>', 'GetEnvironmentOutput$projectId' => '<p>The ID of the Amazon DataZone project in which this environment is created.</p>', 'GetEnvironmentProfileOutput$projectId' => '<p>The ID of the Amazon DataZone project in which this environment profile is created.</p>', 'GetFormTypeOutput$originProjectId' => '<p>The ID of the project in which this metadata form type was originally created.</p>', 'GetFormTypeOutput$owningProjectId' => '<p>The ID of the project that owns this metadata form type.</p>', 'GetGlossaryOutput$owningProjectId' => '<p>The ID of the project that owns this business glossary.</p>', 'GetMetadataGenerationRunOutput$owningProjectId' => '<p>The ID of the project that owns the assets for which you\'re running metadata generation.</p>', 'GetProjectInput$identifier' => '<p>The ID of the project.</p>', 'GetProjectOutput$id' => '<p>&gt;The ID of the project.</p>', 'GetSubscriptionTargetOutput$projectId' => '<p>The ID of the project associated with the subscription target.</p>', 'GlossaryItem$owningProjectId' => '<p>The identifier of the project that owns the business glosary.</p>', 'ListEnvironmentProfilesInput$projectIdentifier' => '<p>The identifier of the Amazon DataZone project.</p>', 'ListEnvironmentsInput$projectIdentifier' => '<p>The identifier of the Amazon DataZone project.</p>', 'ListProjectMembershipsInput$projectIdentifier' => '<p>The identifier of the project whose memberships you want to list.</p>', 'ListSubscriptionRequestsInput$approverProjectId' => '<p>The identifier of the subscription request approver\'s project.</p>', 'ListSubscriptionRequestsInput$owningProjectId' => '<p>The identifier of the project for the subscription requests.</p>', 'ListSubscriptionsInput$approverProjectId' => '<p>The identifier of the project for the subscription\'s approver.</p>', 'ListSubscriptionsInput$owningProjectId' => '<p>The identifier of the owning project.</p>', 'MetadataGenerationRunItem$owningProjectId' => '<p>The ID of the project that owns the asset for which the metadata generation was ran.</p>', 'ProjectSummary$id' => '<p>The identifier of a project.</p>', 'SearchInput$owningProjectIdentifier' => '<p>The identifier of the owning project specified for the search.</p>', 'StartDataSourceRunOutput$projectId' => '<p>The identifier of the project.</p>', 'StartMetadataGenerationRunInput$owningProjectIdentifier' => '<p>The ID of the project that owns the asset for which you want to start a metadata generation run.</p>', 'StartMetadataGenerationRunOutput$owningProjectId' => '<p>The ID of the project that owns the asset for which the metadata generation run was started.</p>', 'SubscribedListing$ownerProjectId' => '<p>The identifier of the project of the published asset for which the subscription grant is created.</p>', 'SubscribedProject$id' => '<p>The identifier of the project that has the subscription grant.</p>', 'SubscribedProjectInput$identifier' => '<p>The identifier of the project that is to be given a subscription grant.</p>', 'SubscriptionTargetSummary$projectId' => '<p>The identifier of the project specified in the subscription target.</p>', 'UpdateDataSourceOutput$projectId' => '<p>The identifier of the project where data source is to be updated.</p>', 'UpdateEnvironmentOutput$projectId' => '<p>The project identifier of the environment.</p>', 'UpdateEnvironmentProfileOutput$projectId' => '<p>The identifier of the project of the environment profile that is to be updated.</p>', 'UpdateGlossaryOutput$owningProjectId' => '<p>The identifier of the project in which to update a business glossary.</p>', 'UpdateProjectInput$identifier' => '<p>The identifier of the project that is to be updated.</p>', 'UpdateProjectOutput$id' => '<p>The identifier of the project that is to be updated.</p>', 'UpdateSubscriptionTargetOutput$projectId' => '<p>The identifier of the project in which a subscription target is to be updated.</p>', ], ], 'ProjectMember' => [ 'base' => '<p>The details of a project member.</p>', 'refs' => [ 'ProjectMembers$member' => NULL, ], ], 'ProjectMembers' => [ 'base' => NULL, 'refs' => [ 'ListProjectMembershipsOutput$members' => '<p>The members of the project.</p>', ], ], 'ProjectName' => [ 'base' => NULL, 'refs' => [ 'CreateProjectInput$name' => '<p>The name of the Amazon DataZone project.</p>', 'CreateProjectOutput$name' => '<p>The name of the project.</p>', 'GetProjectOutput$name' => '<p>The name of the project.</p>', 'ListProjectsInput$name' => '<p>The name of the project.</p>', 'ProjectSummary$name' => '<p>The name of a project.</p>', 'SubscribedProject$name' => '<p>The name of the project that has the subscription grant.</p>', 'UpdateProjectInput$name' => '<p>The name to be updated as part of the <code>UpdateProject</code> action.</p>', 'UpdateProjectOutput$name' => '<p>The name of the project that is to be updated.</p>', ], ], 'ProjectStatus' => [ 'base' => NULL, 'refs' => [ 'CreateProjectOutput$projectStatus' => '<p>The status of the Amazon DataZone project that was created.</p>', 'GetProjectOutput$projectStatus' => '<p>The status of the project.</p>', 'ProjectSummary$projectStatus' => '<p>The status of the project.</p>', 'UpdateProjectOutput$projectStatus' => '<p>The status of the project.</p>', ], ], 'ProjectSummaries' => [ 'base' => NULL, 'refs' => [ 'ListProjectsOutput$items' => '<p>The results of the <code>ListProjects</code> action.</p>', ], ], 'ProjectSummary' => [ 'base' => '<p>The details of a Amazon DataZone project.</p>', 'refs' => [ 'ProjectSummaries$member' => NULL, ], ], 'ProvisioningProperties' => [ 'base' => '<p>The provisioning properties of an environment blueprint.</p>', 'refs' => [ 'CreateEnvironmentOutput$provisioningProperties' => '<p>The provisioning properties of this Amazon DataZone environment.</p>', 'EnvironmentBlueprintSummary$provisioningProperties' => '<p>The provisioning properties of the blueprint.</p>', 'GetEnvironmentBlueprintOutput$provisioningProperties' => '<p>The provisioning properties of this Amazon DataZone blueprint.</p>', 'GetEnvironmentOutput$provisioningProperties' => '<p>The provisioning properties of this Amazon DataZone environment.</p>', 'UpdateEnvironmentOutput$provisioningProperties' => '<p>The provisioning properties to be updated as part of the <code>UpdateEnvironment</code> action.</p>', ], ], 'PutEnvironmentBlueprintConfigurationInput' => [ 'base' => NULL, 'refs' => [], ], 'PutEnvironmentBlueprintConfigurationOutput' => [ 'base' => NULL, 'refs' => [], ], 'RecommendationConfiguration' => [ 'base' => '<p>The recommendation to be updated as part of the <code>UpdateDataSource</code> action.</p>', 'refs' => [ 'CreateDataSourceInput$recommendation' => '<p>Specifies whether the business name generation is to be enabled for this data source.</p>', 'CreateDataSourceOutput$recommendation' => '<p>Specifies whether the business name generation is to be enabled for this data source.</p>', 'GetDataSourceOutput$recommendation' => '<p>The recommendation configuration of the data source.</p>', 'UpdateDataSourceInput$recommendation' => '<p>The recommendation to be updated as part of the <code>UpdateDataSource</code> action.</p>', 'UpdateDataSourceOutput$recommendation' => '<p>The recommendation to be updated as part of the <code>UpdateDataSource</code> action.</p>', ], ], 'RedshiftClusterStorage' => [ 'base' => '<p>The details of the Amazon Redshift cluster storage.</p>', 'refs' => [ 'RedshiftStorage$redshiftClusterSource' => '<p>The details of the Amazon Redshift cluster source.</p>', ], ], 'RedshiftClusterStorageClusterNameString' => [ 'base' => NULL, 'refs' => [ 'RedshiftClusterStorage$clusterName' => '<p>The name of an Amazon Redshift cluster.</p>', ], ], 'RedshiftCredentialConfiguration' => [ 'base' => '<p>The details of the credentials required to access an Amazon Redshift cluster.</p>', 'refs' => [ 'RedshiftRunConfigurationInput$redshiftCredentialConfiguration' => NULL, 'RedshiftRunConfigurationOutput$redshiftCredentialConfiguration' => NULL, ], ], 'RedshiftCredentialConfigurationSecretManagerArnString' => [ 'base' => NULL, 'refs' => [ 'RedshiftCredentialConfiguration$secretManagerArn' => '<p>The ARN of a secret manager for an Amazon Redshift cluster.</p>', ], ], 'RedshiftRunConfigurationInput' => [ 'base' => '<p>The configuration details of the Amazon Redshift data source.</p>', 'refs' => [ 'DataSourceConfigurationInput$redshiftRunConfiguration' => '<p>The configuration of the Amazon Redshift data source.</p>', ], ], 'RedshiftRunConfigurationInputDataAccessRoleString' => [ 'base' => NULL, 'refs' => [ 'RedshiftRunConfigurationInput$dataAccessRole' => '<p>The data access role included in the configuration details of the Amazon Redshift data source.</p>', ], ], 'RedshiftRunConfigurationOutput' => [ 'base' => '<p>The configuration details of the Amazon Redshift data source.</p>', 'refs' => [ 'DataSourceConfigurationOutput$redshiftRunConfiguration' => '<p>The configuration of the Amazon Redshift data source.</p>', ], ], 'RedshiftRunConfigurationOutputAccountIdString' => [ 'base' => NULL, 'refs' => [ 'RedshiftRunConfigurationOutput$accountId' => '<p>The ID of the Amazon Web Services account included in the configuration details of the Amazon Redshift data source.</p>', ], ], 'RedshiftRunConfigurationOutputDataAccessRoleString' => [ 'base' => NULL, 'refs' => [ 'RedshiftRunConfigurationOutput$dataAccessRole' => '<p>The data access role included in the configuration details of the Amazon Redshift data source.</p>', ], ], 'RedshiftRunConfigurationOutputRegionString' => [ 'base' => NULL, 'refs' => [ 'RedshiftRunConfigurationOutput$region' => '<p>The Amazon Web Services region included in the configuration details of the Amazon Redshift data source.</p>', ], ], 'RedshiftSelfGrantStatusOutput' => [ 'base' => '<p>The details for the self granting status for an Amazon Redshift data source.</p>', 'refs' => [ 'SelfGrantStatusOutput$redshiftSelfGrantStatus' => '<p>The details for the self granting status for an Amazon Redshift data source.</p>', ], ], 'RedshiftServerlessStorage' => [ 'base' => '<p>The details of the Amazon Redshift Serverless workgroup storage.</p>', 'refs' => [ 'RedshiftStorage$redshiftServerlessSource' => '<p>The details of the Amazon Redshift Serverless workgroup source.</p>', ], ], 'RedshiftServerlessStorageWorkgroupNameString' => [ 'base' => NULL, 'refs' => [ 'RedshiftServerlessStorage$workgroupName' => '<p>The name of the Amazon Redshift Serverless workgroup.</p>', ], ], 'RedshiftStorage' => [ 'base' => '<p>The details of the Amazon Redshift storage as part of the configuration of an Amazon Redshift data source run.</p>', 'refs' => [ 'RedshiftRunConfigurationInput$redshiftStorage' => NULL, 'RedshiftRunConfigurationOutput$redshiftStorage' => NULL, ], ], 'RegionName' => [ 'base' => NULL, 'refs' => [ 'EnabledRegionList$member' => NULL, 'RegionalParameterMap$key' => NULL, ], ], 'RegionalParameter' => [ 'base' => NULL, 'refs' => [ 'RegionalParameterMap$value' => NULL, ], ], 'RegionalParameterMap' => [ 'base' => NULL, 'refs' => [ 'EnvironmentBlueprintConfigurationItem$regionalParameters' => '<p>The regional parameters of the environment blueprint.</p>', 'GetEnvironmentBlueprintConfigurationOutput$regionalParameters' => '<p>The regional parameters of the blueprint.</p>', 'PutEnvironmentBlueprintConfigurationInput$regionalParameters' => '<p>The regional parameters in the environment blueprint.</p>', 'PutEnvironmentBlueprintConfigurationOutput$regionalParameters' => '<p>The regional parameters in the environment blueprint.</p>', ], ], 'RejectChoice' => [ 'base' => '<p>The details of the automatically generated business metadata that is rejected.</p>', 'refs' => [ 'RejectChoices$member' => NULL, ], ], 'RejectChoices' => [ 'base' => NULL, 'refs' => [ 'RejectPredictionsInput$rejectChoices' => '<p>Specifies the prediction (aka, the automatically generated piece of metadata) and the target (for example, a column name) that can be rejected.</p>', ], ], 'RejectPredictionsInput' => [ 'base' => NULL, 'refs' => [], ], 'RejectPredictionsOutput' => [ 'base' => NULL, 'refs' => [], ], 'RejectRule' => [ 'base' => '<p>Specifies the rule and the threshold under which a prediction can be rejected.</p>', 'refs' => [ 'RejectPredictionsInput$rejectRule' => '<p>Specifies the rule (or the conditions) under which a prediction can be rejected.</p>', ], ], 'RejectRuleBehavior' => [ 'base' => NULL, 'refs' => [ 'RejectRule$rule' => '<p>Specifies whether you want to reject the top prediction for all targets or none.</p>', ], ], 'RejectSubscriptionRequestInput' => [ 'base' => NULL, 'refs' => [], ], 'RejectSubscriptionRequestOutput' => [ 'base' => NULL, 'refs' => [], ], 'RejectSubscriptionRequestOutputSubscribedListingsList' => [ 'base' => NULL, 'refs' => [ 'RejectSubscriptionRequestOutput$subscribedListings' => '<p>The subscribed listings of the subscription request.</p>', ], ], 'RejectSubscriptionRequestOutputSubscribedPrincipalsList' => [ 'base' => NULL, 'refs' => [ 'RejectSubscriptionRequestOutput$subscribedPrincipals' => '<p>The subscribed principals of the subscription request.</p>', ], ], 'RelationalFilterConfiguration' => [ 'base' => '<p>The relational filter configuration for the data source.</p>', 'refs' => [ 'RelationalFilterConfigurations$member' => NULL, ], ], 'RelationalFilterConfigurationDatabaseNameString' => [ 'base' => NULL, 'refs' => [ 'RelationalFilterConfiguration$databaseName' => '<p>The database name specified in the relational filter configuration for the data source.</p>', ], ], 'RelationalFilterConfigurationSchemaNameString' => [ 'base' => NULL, 'refs' => [ 'RelationalFilterConfiguration$schemaName' => '<p>The schema name specified in the relational filter configuration for the data source.</p>', ], ], 'RelationalFilterConfigurations' => [ 'base' => NULL, 'refs' => [ 'GlueRunConfigurationInput$relationalFilterConfigurations' => '<p>The relational filter configurations included in the configuration details of the Amazon Web Services Glue data source.</p>', 'GlueRunConfigurationOutput$relationalFilterConfigurations' => '<p>The relational filter configurations included in the configuration details of the Amazon Web Services Glue data source.</p>', 'RedshiftRunConfigurationInput$relationalFilterConfigurations' => '<p>The relational filger configurations included in the configuration details of the Amazon Redshift data source.</p>', 'RedshiftRunConfigurationOutput$relationalFilterConfigurations' => '<p>The relational filger configurations included in the configuration details of the Amazon Redshift data source.</p>', ], ], 'RequestReason' => [ 'base' => NULL, 'refs' => [ 'AcceptSubscriptionRequestOutput$requestReason' => '<p>Specifies the reason for requesting a subscription to the asset.</p>', 'CreateSubscriptionRequestInput$requestReason' => '<p>The reason for the subscription request.</p>', 'CreateSubscriptionRequestOutput$requestReason' => '<p>The reason for the subscription request.</p>', 'GetSubscriptionRequestDetailsOutput$requestReason' => '<p>The reason for the subscription request.</p>', 'RejectSubscriptionRequestOutput$requestReason' => '<p>The reason for the subscription request.</p>', 'SubscriptionRequestSummary$requestReason' => '<p>The reason for the subscription request.</p>', 'UpdateSubscriptionRequestInput$requestReason' => '<p>The reason for the <code>UpdateSubscriptionRequest</code> action.</p>', 'UpdateSubscriptionRequestOutput$requestReason' => '<p>The reason for the <code>UpdateSubscriptionRequest</code> action.</p>', ], ], 'Resource' => [ 'base' => '<p>The details of a provisioned resource of this Amazon DataZone environment.</p>', 'refs' => [ 'ResourceList$member' => NULL, ], ], 'ResourceList' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentOutput$provisionedResources' => '<p>The provisioned resources of this Amazon DataZone environment.</p>', 'GetEnvironmentOutput$provisionedResources' => '<p>The provisioned resources of this Amazon DataZone environment.</p>', 'UpdateEnvironmentOutput$provisionedResources' => '<p>The provisioned resources to be updated as part of the <code>UpdateEnvironment</code> action.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The specified resource cannot be found.</p>', 'refs' => [], ], 'Revision' => [ 'base' => NULL, 'refs' => [ 'AcceptPredictionsInput$revision' => '<p>The revision that is to be made to the asset.</p>', 'AcceptPredictionsOutput$revision' => '<p>The revision that is to be made to the asset.</p>', 'AssetItem$typeRevision' => '<p>The revision of the inventory asset type.</p>', 'AssetListing$assetRevision' => '<p>The revision of an asset published in an Amazon DataZone catalog. </p>', 'AssetListingItem$entityRevision' => '<p>The revision of the inventory asset.</p>', 'AssetListingItem$listingRevision' => '<p>The revision of the listing (asset published in Amazon DataZone catalog).</p>', 'AssetRevision$revision' => '<p>The revision details of the inventory asset.</p>', 'AssetTypeItem$revision' => '<p>The revision of the asset type.</p>', 'CreateAssetInput$typeRevision' => '<p>The revision of this asset\'s type.</p>', 'CreateAssetOutput$revision' => '<p>The revision of the asset.</p>', 'CreateAssetOutput$typeRevision' => '<p>The revision type of the asset.</p>', 'CreateAssetRevisionInput$typeRevision' => '<p>The revision type of the asset.</p>', 'CreateAssetRevisionOutput$revision' => '<p>The revision of the asset.</p>', 'CreateAssetRevisionOutput$typeRevision' => '<p>The revision type of the asset.</p>', 'CreateAssetTypeOutput$revision' => '<p>The revision of the custom asset type.</p>', 'CreateFormTypeOutput$revision' => '<p>The revision of this Amazon DataZone metadata form type.</p>', 'CreateListingChangeSetInput$entityRevision' => '<p>The revision of an asset.</p>', 'CreateListingChangeSetOutput$listingRevision' => '<p>The revision of a listing.</p>', 'FormEntryInput$typeRevision' => '<p>The type revision of the form entry.</p>', 'FormEntryOutput$typeRevision' => '<p>The type revision of the form entry.</p>', 'FormInput$typeRevision' => '<p>The revision of the metadata form type.</p>', 'FormOutput$typeRevision' => '<p>The revision of the metadata form type.</p>', 'FormTypeData$revision' => '<p>The revision of the form type.</p>', 'GetAssetInput$revision' => '<p>The revision of the Amazon DataZone asset.</p>', 'GetAssetOutput$revision' => '<p>The revision of the asset.</p>', 'GetAssetOutput$typeRevision' => '<p>The revision of the asset type.</p>', 'GetAssetTypeInput$revision' => '<p>The revision of the asset type.</p>', 'GetAssetTypeOutput$revision' => '<p>The revision of the asset type.</p>', 'GetFormTypeInput$revision' => '<p>The revision of this metadata form type.</p>', 'GetFormTypeOutput$revision' => '<p>The revision of the metadata form type.</p>', 'GetLineageNodeOutput$typeRevision' => '<p>The revision type of the specified data lineage node.</p>', 'GetListingInput$listingRevision' => '<p>The revision of the listing.</p>', 'GetListingOutput$listingRevision' => '<p>The revision of a listing.</p>', 'Import$revision' => '<p>The revision of the import.</p>', 'LineageNodeSummary$typeRevision' => '<p>The type of the revision of the data lineage node.</p>', 'LineageNodeTypeItem$revision' => '<p>The revision of the data lineage node type.</p>', 'ListingRevision$revision' => '<p>The details of a revision of an asset published in a Amazon DataZone catalog.</p>', 'ListingRevisionInput$revision' => '<p>The details of a revision to be made to an asset published in a Amazon DataZone catalog.</p>', 'MetadataGenerationRunTarget$revision' => '<p>The revision of the asset for which metadata was generated.</p>', 'RejectPredictionsInput$revision' => '<p>The revision that is to be made to the asset.</p>', 'RejectPredictionsOutput$assetRevision' => '<p>The revision that is to be made to the asset.</p>', 'SubscribedAsset$assetRevision' => '<p>The revision of the asset for which the subscription grant is created.</p>', 'SubscribedAssetListing$entityRevision' => '<p>The revision of the published asset for which the subscription grant is created.</p>', 'SubscribedListing$revision' => '<p>The revision of the published asset for which the subscription grant is created.</p>', 'TimeSeriesDataPointFormInput$typeRevision' => '<p>The revision type of the time series data points form.</p>', 'TimeSeriesDataPointFormOutput$typeRevision' => '<p>The revision type of the time series data points form.</p>', 'TimeSeriesDataPointSummaryFormOutput$typeRevision' => '<p>The type revision of the time series data points summary form.</p>', ], ], 'RevokeSubscriptionInput' => [ 'base' => NULL, 'refs' => [], ], 'RevokeSubscriptionOutput' => [ 'base' => NULL, 'refs' => [], ], 'RoleArn' => [ 'base' => NULL, 'refs' => [ 'CreateDomainInput$domainExecutionRole' => '<p>The domain execution role that is created when an Amazon DataZone domain is created. The domain execution role is created in the Amazon Web Services account that houses the Amazon DataZone domain.</p>', 'CreateDomainOutput$domainExecutionRole' => '<p>The domain execution role that is created when an Amazon DataZone domain is created. The domain execution role is created in the Amazon Web Services account that houses the Amazon DataZone domain.</p>', 'EnvironmentBlueprintConfigurationItem$manageAccessRoleArn' => '<p>The ARN of the manage access role specified in the environment blueprint configuration.</p>', 'EnvironmentBlueprintConfigurationItem$provisioningRoleArn' => '<p>The ARN of the provisioning role specified in the environment blueprint configuration.</p>', 'GetDomainOutput$domainExecutionRole' => '<p>The domain execution role with which the Amazon DataZone domain is created.</p>', 'GetEnvironmentBlueprintConfigurationOutput$manageAccessRoleArn' => '<p>The ARN of the manage access role with which this blueprint is created.</p>', 'GetEnvironmentBlueprintConfigurationOutput$provisioningRoleArn' => '<p>The ARN of the provisioning role with which this blueprint is created.</p>', 'PutEnvironmentBlueprintConfigurationInput$manageAccessRoleArn' => '<p>The ARN of the manage access role.</p>', 'PutEnvironmentBlueprintConfigurationInput$provisioningRoleArn' => '<p>The ARN of the provisioning role.</p>', 'PutEnvironmentBlueprintConfigurationOutput$manageAccessRoleArn' => '<p>The ARN of the manage access role.</p>', 'PutEnvironmentBlueprintConfigurationOutput$provisioningRoleArn' => '<p>The ARN of the provisioning role.</p>', 'UpdateDomainInput$domainExecutionRole' => '<p>The domain execution role to be updated as part of the <code>UpdateDomain</code> action.</p>', 'UpdateDomainOutput$domainExecutionRole' => '<p>The domain execution role to be updated as part of the <code>UpdateDomain</code> action.</p>', ], ], 'RunStatisticsForAssets' => [ 'base' => '<p>The asset statistics from the data source run.</p>', 'refs' => [ 'DataSourceRunSummary$runStatisticsForAssets' => NULL, 'GetDataSourceRunOutput$runStatisticsForAssets' => '<p>The asset statistics from this data source run.</p>', 'StartDataSourceRunOutput$runStatisticsForAssets' => '<p>Specifies run statistics for assets.</p>', ], ], 'ScheduleConfiguration' => [ 'base' => '<p>The details of the schedule of the data source runs.</p>', 'refs' => [ 'CreateDataSourceInput$schedule' => '<p>The schedule of the data source runs.</p>', 'CreateDataSourceOutput$schedule' => '<p>The schedule of the data source runs.</p>', 'DataSourceSummary$schedule' => NULL, 'DeleteDataSourceOutput$schedule' => '<p>The schedule of runs for this data source.</p>', 'GetDataSourceOutput$schedule' => '<p>The schedule of the data source runs.</p>', 'UpdateDataSourceInput$schedule' => '<p>The schedule to be updated as part of the <code>UpdateDataSource</code> action.</p>', 'UpdateDataSourceOutput$schedule' => '<p>The schedule to be updated as part of the <code>UpdateDataSource</code> action.</p>', ], ], 'SearchGroupProfilesInput' => [ 'base' => NULL, 'refs' => [], ], 'SearchGroupProfilesOutput' => [ 'base' => NULL, 'refs' => [], ], 'SearchInItem' => [ 'base' => '<p>The details of the search.</p>', 'refs' => [ 'SearchInList$member' => NULL, ], ], 'SearchInList' => [ 'base' => NULL, 'refs' => [ 'SearchInput$searchIn' => '<p>The details of the search.</p>', 'SearchListingsInput$searchIn' => '<p>The details of the search.</p>', 'SearchTypesInput$searchIn' => '<p>The details of the search.</p>', ], ], 'SearchInput' => [ 'base' => NULL, 'refs' => [], ], 'SearchInventoryResultItem' => [ 'base' => '<p>The details of the search results.</p>', 'refs' => [ 'SearchInventoryResultItems$member' => NULL, ], ], 'SearchInventoryResultItems' => [ 'base' => NULL, 'refs' => [ 'SearchOutput$items' => '<p>The results of the <code>Search</code> action.</p>', ], ], 'SearchListingsInput' => [ 'base' => NULL, 'refs' => [], ], 'SearchListingsOutput' => [ 'base' => NULL, 'refs' => [], ], 'SearchOutput' => [ 'base' => NULL, 'refs' => [], ], 'SearchOutputAdditionalAttribute' => [ 'base' => NULL, 'refs' => [ 'SearchOutputAdditionalAttributes$member' => NULL, ], ], 'SearchOutputAdditionalAttributes' => [ 'base' => NULL, 'refs' => [ 'SearchInput$additionalAttributes' => '<p>Specifies additional attributes for the <code>Search</code> action.</p>', 'SearchListingsInput$additionalAttributes' => '<p>Specifies additional attributes for the search.</p>', ], ], 'SearchResultItem' => [ 'base' => '<p>The details of the results of the <code>SearchListings</code> action.</p>', 'refs' => [ 'SearchResultItems$member' => NULL, ], ], 'SearchResultItems' => [ 'base' => NULL, 'refs' => [ 'SearchListingsOutput$items' => '<p>The results of the <code>SearchListings</code> action.</p>', ], ], 'SearchSort' => [ 'base' => '<p>The details of the way to sort search results.</p>', 'refs' => [ 'SearchInput$sort' => '<p>Specifies the way in which the search results are to be sorted.</p>', 'SearchListingsInput$sort' => '<p>Specifies the way for sorting the search results.</p>', 'SearchTypesInput$sort' => '<p>The specifies the way to sort the <code>SearchTypes</code> results.</p>', ], ], 'SearchText' => [ 'base' => NULL, 'refs' => [ 'SearchInput$searchText' => '<p>Specifies the text for which to search.</p>', 'SearchTypesInput$searchText' => '<p>Specifies the text for which to search.</p>', ], ], 'SearchTypesInput' => [ 'base' => NULL, 'refs' => [], ], 'SearchTypesOutput' => [ 'base' => NULL, 'refs' => [], ], 'SearchTypesResultItem' => [ 'base' => '<p>The details of the results of the <code>SearchTypes</code> action.</p>', 'refs' => [ 'SearchTypesResultItems$member' => NULL, ], ], 'SearchTypesResultItems' => [ 'base' => NULL, 'refs' => [ 'SearchTypesOutput$items' => '<p>The results of the <code>SearchTypes</code> action.</p>', ], ], 'SearchUserProfilesInput' => [ 'base' => NULL, 'refs' => [], ], 'SearchUserProfilesOutput' => [ 'base' => NULL, 'refs' => [], ], 'SelfGrantStatus' => [ 'base' => NULL, 'refs' => [ 'SelfGrantStatusDetail$status' => '<p>The self granting status of the data source.</p>', ], ], 'SelfGrantStatusDetail' => [ 'base' => '<p>The details for the self granting status.</p>', 'refs' => [ 'SelfGrantStatusDetails$member' => NULL, ], ], 'SelfGrantStatusDetailDatabaseNameString' => [ 'base' => NULL, 'refs' => [ 'SelfGrantStatusDetail$databaseName' => '<p>The name of the database used for the data source.</p>', ], ], 'SelfGrantStatusDetailSchemaNameString' => [ 'base' => NULL, 'refs' => [ 'SelfGrantStatusDetail$schemaName' => '<p>The name of the schema used in the data source.</p>', ], ], 'SelfGrantStatusDetails' => [ 'base' => NULL, 'refs' => [ 'GlueSelfGrantStatusOutput$selfGrantStatusDetails' => '<p>The details for the self granting status for a Glue data source.</p>', 'RedshiftSelfGrantStatusOutput$selfGrantStatusDetails' => '<p>The details for the self granting status for an Amazon Redshift data source.</p>', ], ], 'SelfGrantStatusOutput' => [ 'base' => '<p>The details for the self granting status for a data source.</p>', 'refs' => [ 'DeleteDataSourceOutput$selfGrantStatus' => '<p>Specifies the status of the self-granting functionality.</p>', 'GetDataSourceOutput$selfGrantStatus' => '<p>Specifies the status of the self-granting functionality.</p>', 'UpdateDataSourceOutput$selfGrantStatus' => '<p>Specifies the status of the self-granting functionality.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>The request has exceeded the specified service quota.</p>', 'refs' => [], ], 'ShortDescription' => [ 'base' => NULL, 'refs' => [ 'CreateGlossaryTermInput$shortDescription' => '<p>The short description of this business glossary term.</p>', 'CreateGlossaryTermOutput$shortDescription' => '<p>The short description of this business glossary term.</p>', 'DetailedGlossaryTerm$shortDescription' => '<p>The shoft description of a glossary term attached to the inventory asset.</p>', 'GetGlossaryTermOutput$shortDescription' => '<p>The short decription of the business glossary term.</p>', 'GlossaryTermItem$shortDescription' => '<p>The short description of the business glossary term.</p>', 'UpdateGlossaryTermInput$shortDescription' => '<p>The short description to be updated as part of the <code>UpdateGlossaryTerm</code> action.</p>', 'UpdateGlossaryTermOutput$shortDescription' => '<p>The short description to be updated as part of the <code>UpdateGlossaryTerm</code> action.</p>', ], ], 'SingleSignOn' => [ 'base' => '<p>The single sign-on details in Amazon DataZone.</p>', 'refs' => [ 'CreateDomainInput$singleSignOn' => '<p>The single-sign on configuration of the Amazon DataZone domain.</p>', 'CreateDomainOutput$singleSignOn' => '<p>The single-sign on configuration of the Amazon DataZone domain.</p>', 'GetDomainOutput$singleSignOn' => '<p>The single sing-on option of the specified Amazon DataZone domain.</p>', 'UpdateDomainInput$singleSignOn' => '<p>The single sign-on option to be updated as part of the <code>UpdateDomain</code> action.</p>', 'UpdateDomainOutput$singleSignOn' => '<p>The single sign-on option of the Amazon DataZone domain.</p>', ], ], 'Smithy' => [ 'base' => NULL, 'refs' => [ 'Model$smithy' => '<p>Indicates the smithy model of the API.</p>', ], ], 'SortFieldProject' => [ 'base' => NULL, 'refs' => [ 'ListProjectMembershipsInput$sortBy' => '<p>The method by which you want to sort the project memberships.</p>', ], ], 'SortKey' => [ 'base' => NULL, 'refs' => [ 'ListSubscriptionGrantsInput$sortBy' => '<p>Specifies the way of sorting the results of this action.</p>', 'ListSubscriptionRequestsInput$sortBy' => '<p>Specifies the way to sort the results of this action.</p>', 'ListSubscriptionTargetsInput$sortBy' => '<p>Specifies the way in which the results of this action are to be sorted.</p>', 'ListSubscriptionsInput$sortBy' => '<p>Specifies the way in which the results of this action are to be sorted.</p>', ], ], 'SortOrder' => [ 'base' => NULL, 'refs' => [ 'ListLineageNodeHistoryInput$sortOrder' => '<p>The order by which you want data lineage node history to be sorted.</p>', 'ListProjectMembershipsInput$sortOrder' => '<p>The sort order of the project memberships.</p>', 'ListSubscriptionGrantsInput$sortOrder' => '<p>Specifies the sort order of this action.</p>', 'ListSubscriptionRequestsInput$sortOrder' => '<p>Specifies the sort order for the results of this action.</p>', 'ListSubscriptionTargetsInput$sortOrder' => '<p>Specifies the sort order for the results of this action.</p>', 'ListSubscriptionsInput$sortOrder' => '<p>Specifies the sort order for the results of this action.</p>', 'SearchSort$order' => '<p>The order detail of the wya to sort search results.</p>', ], ], 'SsoUserProfileDetails' => [ 'base' => '<p>The single sign-on details of the user profile.</p>', 'refs' => [ 'UserProfileDetails$sso' => '<p>The single sign-on details included in the user profile details.</p>', ], ], 'StartDataSourceRunInput' => [ 'base' => NULL, 'refs' => [], ], 'StartDataSourceRunOutput' => [ 'base' => NULL, 'refs' => [], ], 'StartMetadataGenerationRunInput' => [ 'base' => NULL, 'refs' => [], ], 'StartMetadataGenerationRunOutput' => [ 'base' => NULL, 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AcceptChoice$predictionTarget' => '<p>Specifies the target (for example, a column name) where a prediction can be accepted.</p>', 'AcceptSubscriptionRequestOutput$reviewerId' => '<p>Specifes the ID of the Amazon DataZone user who reviewed the subscription request.</p>', 'AssetTargetNameMap$targetName' => '<p>The target name in the asset target name map.</p>', 'AssociateEnvironmentRoleInput$environmentRoleArn' => '<p>The ARN of the environment role.</p>', 'AwsConsoleLinkParameters$uri' => '<p>The URI of the console link specified as part of the environment action.</p>', 'CloudFormationProperties$templateUrl' => '<p>The template URL of the cloud formation provisioning properties of the environment blueprint.</p>', 'ConfigurableActionParameter$key' => '<p>The key of the configurable action parameter.</p>', 'ConfigurableActionParameter$value' => '<p>The value of the configurable action parameter.</p>', 'ConfigurableEnvironmentAction$type' => '<p>The type of a configurable action in a Amazon DataZone environment.</p>', 'CreateDataSourceInput$clientToken' => '<p>A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.</p>', 'CreateDataSourceInput$environmentIdentifier' => '<p>The unique identifier of the Amazon DataZone environment to which the data source publishes assets. </p>', 'CreateDataSourceInput$projectIdentifier' => '<p>The identifier of the Amazon DataZone project in which you want to add this data source.</p>', 'CreateDomainInput$clientToken' => '<p>A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.</p>', 'CreateDomainInput$description' => '<p>The description of the Amazon DataZone domain.</p>', 'CreateDomainInput$name' => '<p>The name of the Amazon DataZone domain.</p>', 'CreateDomainOutput$arn' => '<p>The ARN of the Amazon DataZone domain.</p>', 'CreateDomainOutput$description' => '<p>The description of the Amazon DataZone domain.</p>', 'CreateDomainOutput$name' => '<p>The name of the Amazon DataZone domain.</p>', 'CreateDomainOutput$portalUrl' => '<p>The URL of the data portal for this Amazon DataZone domain.</p>', 'CreateEnvironmentActionInput$description' => '<p>The description of the environment action that is being created in the environment.</p>', 'CreateEnvironmentActionInput$name' => '<p>The name of the environment action.</p>', 'CreateEnvironmentActionOutput$description' => '<p>The description of the environment action.</p>', 'CreateEnvironmentActionOutput$name' => '<p>The name of the environment action.</p>', 'CreateEnvironmentInput$description' => '<p>The description of the Amazon DataZone environment.</p>', 'CreateEnvironmentInput$environmentAccountIdentifier' => '<p>The ID of the account in which the environment is being created.</p>', 'CreateEnvironmentInput$environmentAccountRegion' => '<p>The region of the account in which the environment is being created.</p>', 'CreateEnvironmentInput$environmentBlueprintIdentifier' => '<p>The ID of the blueprint with which the environment is being created.</p>', 'CreateEnvironmentInput$name' => '<p>The name of the Amazon DataZone environment.</p>', 'CreateEnvironmentOutput$createdBy' => '<p>The Amazon DataZone user who created this environment.</p>', 'CreateEnvironmentOutput$provider' => '<p>The provider of this Amazon DataZone environment.</p>', 'CreateEnvironmentProfileOutput$createdBy' => '<p>The Amazon DataZone user who created this environment profile.</p>', 'CreateGroupProfileInput$clientToken' => '<p> A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.</p>', 'CreateSubscriptionGrantInput$clientToken' => '<p>A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.</p>', 'CreateSubscriptionRequestInput$clientToken' => '<p>A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.</p>', 'CreateSubscriptionRequestOutput$reviewerId' => '<p>The ID of the reviewer of the subscription request.</p>', 'CreateSubscriptionTargetInput$clientToken' => '<p>A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.</p>', 'CreateSubscriptionTargetInput$manageAccessRole' => '<p>The manage access role that is used to create the subscription target.</p>', 'CreateSubscriptionTargetInput$provider' => '<p>The provider of the subscription target.</p>', 'CreateSubscriptionTargetInput$type' => '<p>The type of the subscription target.</p>', 'CreateSubscriptionTargetOutput$manageAccessRole' => '<p>The manage access role with which the subscription target was created.</p>', 'CreateSubscriptionTargetOutput$provider' => '<p>The provider of the subscription target.</p>', 'CreateSubscriptionTargetOutput$type' => '<p>The type of the subscription target.</p>', 'CreateUserProfileInput$clientToken' => '<p>A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.</p>', 'CustomParameter$defaultValue' => '<p>The default value of the parameter.</p>', 'CustomParameter$fieldType' => '<p>The filed type of the parameter.</p>', 'DataSourceErrorMessage$errorDetail' => '<p>The details of the error message that is returned if the operation cannot be successfully completed.</p>', 'DataSourceRunActivity$dataAssetId' => '<p>The identifier of the asset included in the data source run activity.</p>', 'DataSourceSummary$type' => '<p>The type of the data source.</p>', 'DeleteDataSourceInput$clientToken' => '<p>A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.</p>', 'DeleteDomainInput$clientToken' => '<p>A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.</p>', 'DeleteEnvironmentActionInput$identifier' => '<p>The ID of the environment action that is deleted.</p>', 'Deployment$deploymentId' => '<p>The identifier of the last deployment of the environment.</p>', 'DisassociateEnvironmentRoleInput$environmentRoleArn' => '<p>The ARN of the environment role.</p>', 'DomainSummary$arn' => '<p>The ARN of the Amazon DataZone domain.</p>', 'DomainSummary$managedAccountId' => '<p>The identifier of the Amazon Web Services account that manages the domain.</p>', 'DomainSummary$portalUrl' => '<p>The data portal URL for the Amazon DataZone domain.</p>', 'EnvironmentActionSummary$description' => '<p>The environment action description.</p>', 'EnvironmentActionSummary$name' => '<p>The name of the environment action.</p>', 'EnvironmentBlueprintSummary$provider' => '<p>The provider of the blueprint.</p>', 'EnvironmentError$code' => '<p>The error code for the failure reason for the environment deployment.</p>', 'EnvironmentError$message' => '<p>The error message for the failure reason for the environment deployment.</p>', 'EnvironmentParameter$name' => '<p>The name of an environment profile parameter.</p>', 'EnvironmentParameter$value' => '<p>The value of an environment profile parameter.</p>', 'EnvironmentProfileSummary$createdBy' => '<p>The Amazon DataZone user who created the environment profile.</p>', 'EnvironmentSummary$createdBy' => '<p>The Amazon DataZone user who created the environment.</p>', 'EnvironmentSummary$provider' => '<p>The provider of the environment.</p>', 'FailureCause$message' => '<p>The description of the error message.</p>', 'FormOutput$content' => '<p>The content of the metadata form.</p>', 'GetDataSourceRunOutput$dataSourceConfigurationSnapshot' => '<p>The configuration snapshot of the data source run.</p>', 'GetDomainOutput$arn' => '<p>The ARN of the specified Amazon DataZone domain.</p>', 'GetDomainOutput$description' => '<p>The description of the Amazon DataZone domain.</p>', 'GetDomainOutput$name' => '<p>The name of the Amazon DataZone domain.</p>', 'GetDomainOutput$portalUrl' => '<p>The URL of the data portal for this Amazon DataZone domain.</p>', 'GetEnvironmentActionInput$identifier' => '<p>The ID of the environment action</p>', 'GetEnvironmentActionOutput$description' => '<p>The description of the environment action.</p>', 'GetEnvironmentActionOutput$name' => '<p>The name of the environment action.</p>', 'GetEnvironmentBlueprintOutput$provider' => '<p>The provider of this Amazon DataZone blueprint.</p>', 'GetEnvironmentOutput$createdBy' => '<p>The Amazon DataZone user who created the environment.</p>', 'GetEnvironmentOutput$provider' => '<p>The provider of this Amazon DataZone environment.</p>', 'GetEnvironmentProfileOutput$createdBy' => '<p>The Amazon DataZone user who created this environment profile.</p>', 'GetIamPortalLoginUrlOutput$authCodeUrl' => '<p>The data portal URL of the specified Amazon DataZone domain.</p>', 'GetIamPortalLoginUrlOutput$userProfileId' => '<p>The ID of the user profile.</p>', 'GetLineageNodeOutput$description' => '<p>The description of the data lineage node.</p>', 'GetLineageNodeOutput$name' => '<p>The name of the data lineage node.</p>', 'GetLineageNodeOutput$sourceIdentifier' => '<p>The source identifier of the data lineage node.</p>', 'GetLineageNodeOutput$typeName' => '<p>The name of the type of the specified data lineage node.</p>', 'GetSubscriptionRequestDetailsOutput$reviewerId' => '<p>The identifier of the Amazon DataZone user who reviewed the subscription request.</p>', 'GetSubscriptionTargetOutput$manageAccessRole' => '<p>The manage access role with which the subscription target was created.</p>', 'GetSubscriptionTargetOutput$provider' => '<p>The provider of the subscription target.</p>', 'GetSubscriptionTargetOutput$type' => '<p>The type of the subscription target.</p>', 'GroupDetails$groupId' => '<p>The identifier of the group in Amazon DataZone.</p>', 'IamUserProfileDetails$arn' => '<p>The ARN of an IAM user profile in Amazon DataZone.</p>', 'LineageNodeSummary$description' => '<p>The description of the data lineage node.</p>', 'LineageNodeSummary$name' => '<p>The name of the data lineage node.</p>', 'LineageNodeSummary$sourceIdentifier' => '<p>The alternate ID of the data lineage node.</p>', 'LineageNodeSummary$typeName' => '<p>The name of the type of the data lineage node.</p>', 'LineageNodeTypeItem$description' => '<p>The description of the data lineage node type.</p>', 'LineageNodeTypeItem$name' => '<p>The name of the data lineage node type.</p>', 'ListDataSourcesInput$environmentIdentifier' => '<p>The identifier of the environment in which to list the data sources.</p>', 'ListDataSourcesInput$projectIdentifier' => '<p>The identifier of the project in which to list data sources.</p>', 'ListEnvironmentsInput$name' => '<p>The name of the environment.</p>', 'ListEnvironmentsInput$provider' => '<p>The provider of the environment.</p>', 'ListProjectsInput$groupIdentifier' => '<p>The identifier of a group.</p>', 'ListProjectsInput$userIdentifier' => '<p>The identifier of the Amazon DataZone user.</p>', 'ListTagsForResourceRequest$resourceArn' => '<p>The ARN of the resource whose tags you want to list.</p>', 'Member$groupIdentifier' => '<p>The ID of the group of a project member.</p>', 'Member$userIdentifier' => '<p>The user ID of a project member.</p>', 'MetadataGenerationRunTarget$identifier' => '<p>The ID of the metadata generation run\'s target.</p>', 'MetadataMap$key' => NULL, 'MetadataMap$value' => NULL, 'NotificationResource$id' => '<p>The ID of the resource mentioned in a notification.</p>', 'NotificationResource$name' => '<p>The name of the resource mentioned in a notification.</p>', 'NotificationSubjects$member' => NULL, 'ProjectDeletionError$code' => '<p>The code of the project deletion error.</p>', 'ProjectDeletionError$message' => '<p>The message of the project deletion error.</p>', 'RegionalParameter$key' => NULL, 'RegionalParameter$value' => NULL, 'RejectChoice$predictionTarget' => '<p>Specifies the target (for example, a column name) where a prediction can be rejected.</p>', 'RejectSubscriptionRequestOutput$reviewerId' => '<p>The identifier of the subscription request reviewer.</p>', 'Resource$name' => '<p>The name of a provisioned resource of this Amazon DataZone environment.</p>', 'Resource$provider' => '<p>The provider of a provisioned resource of this Amazon DataZone environment.</p>', 'Resource$type' => '<p>The type of a provisioned resource of this Amazon DataZone environment.</p>', 'Resource$value' => '<p>The value of a provisioned resource of this Amazon DataZone environment.</p>', 'SearchListingsInput$searchText' => '<p>Specifies the text for which to search.</p>', 'SelfGrantStatusDetail$failureCause' => '<p>The reason for why the operation failed.</p>', 'StartDataSourceRunInput$clientToken' => '<p>A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.</p>', 'StartDataSourceRunOutput$dataSourceConfigurationSnapshot' => '<p>The configuration snapshot of the data source that is being run.</p>', 'SubscribedAsset$targetName' => '<p>The target name of the asset for which the subscription grant is created.</p>', 'SubscribedListing$ownerProjectName' => '<p>The name of the project that owns the published asset for which the subscription grant is created.</p>', 'SubscriptionRequestSummary$reviewerId' => '<p>The identifier of the subscription request reviewer.</p>', 'SubscriptionTargetForm$content' => '<p>The content of the subscription target configuration.</p>', 'SubscriptionTargetSummary$manageAccessRole' => '<p>The manage access role specified in the subscription target.</p>', 'SubscriptionTargetSummary$provider' => '<p>The provider of the subscription target.</p>', 'SubscriptionTargetSummary$type' => '<p>The type of the subscription target.</p>', 'TagResourceRequest$resourceArn' => '<p>The ARN of the resource to be tagged in Amazon DataZone.</p>', 'Topic$subject' => '<p>The subject of the resource mentioned in a notification.</p>', 'UntagResourceRequest$resourceArn' => '<p>The ARN of the resource to be untagged in Amazon DataZone.</p>', 'UpdateDomainInput$clientToken' => '<p>A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.</p>', 'UpdateDomainInput$description' => '<p>The description to be updated as part of the <code>UpdateDomain</code> action.</p>', 'UpdateDomainInput$name' => '<p>The name to be updated as part of the <code>UpdateDomain</code> action.</p>', 'UpdateDomainOutput$description' => '<p>The description to be updated as part of the <code>UpdateDomain</code> action.</p>', 'UpdateDomainOutput$name' => '<p>The name to be updated as part of the <code>UpdateDomain</code> action.</p>', 'UpdateEnvironmentActionInput$description' => '<p>The description of the environment action.</p>', 'UpdateEnvironmentActionInput$identifier' => '<p>The ID of the environment action.</p>', 'UpdateEnvironmentActionInput$name' => '<p>The name of the environment action.</p>', 'UpdateEnvironmentActionOutput$description' => '<p>The description of the environment action.</p>', 'UpdateEnvironmentActionOutput$name' => '<p>The name of the environment action.</p>', 'UpdateEnvironmentInput$description' => '<p>The description to be updated as part of the <code>UpdateEnvironment</code> action.</p>', 'UpdateEnvironmentInput$name' => '<p>The name to be updated as part of the <code>UpdateEnvironment</code> action.</p>', 'UpdateEnvironmentOutput$createdBy' => '<p>The Amazon DataZone user who created the environment.</p>', 'UpdateEnvironmentOutput$provider' => '<p>The provider identifier of the environment.</p>', 'UpdateEnvironmentProfileInput$description' => '<p>The description to be updated as part of the <code>UpdateEnvironmentProfile</code> action.</p>', 'UpdateEnvironmentProfileOutput$createdBy' => '<p>The Amazon DataZone user who created the environment profile.</p>', 'UpdateSubscriptionGrantStatusInput$targetName' => '<p>The target name to be updated as part of the <code>UpdateSubscriptionGrantStatus</code> action.</p>', 'UpdateSubscriptionRequestOutput$reviewerId' => '<p>The identifier of the Amazon DataZone user who reviews the subscription request.</p>', 'UpdateSubscriptionTargetInput$manageAccessRole' => '<p>The manage access role to be updated as part of the <code>UpdateSubscriptionTarget</code> action.</p>', 'UpdateSubscriptionTargetInput$provider' => '<p>The provider to be updated as part of the <code>UpdateSubscriptionTarget</code> action.</p>', 'UpdateSubscriptionTargetOutput$manageAccessRole' => '<p>The manage access role to be updated as part of the <code>UpdateSubscriptionTarget</code> action.</p>', 'UpdateSubscriptionTargetOutput$provider' => '<p>The provider to be updated as part of the <code>UpdateSubscriptionTarget</code> action.</p>', 'UpdateSubscriptionTargetOutput$type' => '<p>The type to be updated as part of the <code>UpdateSubscriptionTarget</code> action.</p>', 'UserDetails$userId' => '<p>The identifier of the Amazon DataZone user.</p>', ], ], 'SubscribedAsset' => [ 'base' => '<p>The details of the asset for which the subscription grant is created.</p>', 'refs' => [ 'SubscribedAssets$member' => NULL, ], ], 'SubscribedAssetListing' => [ 'base' => '<p>The details of the published asset for which the subscription grant is created.</p>', 'refs' => [ 'SubscribedListingItem$assetListing' => '<p>The asset for which the subscription grant is created.</p>', ], ], 'SubscribedAssets' => [ 'base' => NULL, 'refs' => [ 'CreateSubscriptionGrantOutput$assets' => '<p>The assets for which the subscription grant is created.</p>', 'DeleteSubscriptionGrantOutput$assets' => '<p>The assets for which the subsctiption grant that is deleted gave access.</p>', 'GetSubscriptionGrantOutput$assets' => '<p>The assets for which the subscription grant is created.</p>', 'SubscriptionGrantSummary$assets' => '<p>The assets included in the subscription grant.</p>', 'UpdateSubscriptionGrantStatusOutput$assets' => '<p>The details of the asset for which the subscription grant is created.</p>', ], ], 'SubscribedListing' => [ 'base' => '<p>The details of the published asset for which the subscription grant is created.</p>', 'refs' => [ 'AcceptSubscriptionRequestOutputSubscribedListingsList$member' => NULL, 'CancelSubscriptionOutput$subscribedListing' => '<p>The asset to which a subscription is being cancelled.</p>', 'CreateSubscriptionRequestOutputSubscribedListingsList$member' => NULL, 'GetSubscriptionOutput$subscribedListing' => '<p>The details of the published asset for which the subscription grant is created.</p>', 'GetSubscriptionRequestDetailsOutputSubscribedListingsList$member' => NULL, 'RejectSubscriptionRequestOutputSubscribedListingsList$member' => NULL, 'RevokeSubscriptionOutput$subscribedListing' => '<p>The subscribed listing of the revoked subscription.</p>', 'SubscriptionRequestSummarySubscribedListingsList$member' => NULL, 'SubscriptionSummary$subscribedListing' => '<p>The listing included in the subscription.</p>', 'UpdateSubscriptionRequestOutputSubscribedListingsList$member' => NULL, ], ], 'SubscribedListingInput' => [ 'base' => '<p>The published asset for which the subscription grant is to be created.</p>', 'refs' => [ 'SubscribedListingInputs$member' => NULL, ], ], 'SubscribedListingInputs' => [ 'base' => NULL, 'refs' => [ 'CreateSubscriptionRequestInput$subscribedListings' => '<p>The published asset for which the subscription grant is to be created.</p>', ], ], 'SubscribedListingItem' => [ 'base' => '<p>The published asset for which the subscription grant is created.</p>', 'refs' => [ 'SubscribedListing$item' => '<p>The published asset for which the subscription grant is created.</p>', ], ], 'SubscribedPrincipal' => [ 'base' => '<p>The principal that has the subscription grant for the asset.</p>', 'refs' => [ 'AcceptSubscriptionRequestOutputSubscribedPrincipalsList$member' => NULL, 'CancelSubscriptionOutput$subscribedPrincipal' => '<p>The Amazon DataZone user who is made a subscriber to the specified asset by the subscription that is being cancelled.</p>', 'CreateSubscriptionRequestOutputSubscribedPrincipalsList$member' => NULL, 'GetSubscriptionOutput$subscribedPrincipal' => '<p>The principal that owns the subscription.</p>', 'GetSubscriptionRequestDetailsOutputSubscribedPrincipalsList$member' => NULL, 'RejectSubscriptionRequestOutputSubscribedPrincipalsList$member' => NULL, 'RevokeSubscriptionOutput$subscribedPrincipal' => '<p>The subscribed principal of the revoked subscription.</p>', 'SubscriptionRequestSummarySubscribedPrincipalsList$member' => NULL, 'SubscriptionSummary$subscribedPrincipal' => '<p>The principal included in the subscription.</p>', 'UpdateSubscriptionRequestOutputSubscribedPrincipalsList$member' => NULL, ], ], 'SubscribedPrincipalInput' => [ 'base' => '<p>The principal that is to be given a subscriptiong grant.</p>', 'refs' => [ 'SubscribedPrincipalInputs$member' => NULL, ], ], 'SubscribedPrincipalInputs' => [ 'base' => NULL, 'refs' => [ 'CreateSubscriptionRequestInput$subscribedPrincipals' => '<p>The Amazon DataZone principals for whom the subscription request is created.</p>', ], ], 'SubscribedProject' => [ 'base' => '<p>The project that has the subscription grant.</p>', 'refs' => [ 'SubscribedPrincipal$project' => '<p>The project that has the subscription grant.</p>', ], ], 'SubscribedProjectInput' => [ 'base' => '<p>The project that is to be given a subscription grant.</p>', 'refs' => [ 'SubscribedPrincipalInput$project' => '<p>The project that is to be given a subscription grant.</p>', ], ], 'SubscriptionGrantId' => [ 'base' => NULL, 'refs' => [ 'CreateSubscriptionGrantOutput$id' => '<p>The ID of the subscription grant.</p>', 'DeleteSubscriptionGrantInput$identifier' => '<p>The ID of the subscription grant that is deleted.</p>', 'DeleteSubscriptionGrantOutput$id' => '<p>The ID of the subscription grant that is deleted.</p>', 'GetSubscriptionGrantInput$identifier' => '<p>The ID of the subscription grant.</p>', 'GetSubscriptionGrantOutput$id' => '<p>The ID of the subscription grant.</p>', 'SubscriptionGrantSummary$id' => '<p>The identifier of the subscription grant.</p>', 'UpdateSubscriptionGrantStatusInput$identifier' => '<p>The identifier of the subscription grant the status of which is to be updated.</p>', 'UpdateSubscriptionGrantStatusOutput$id' => '<p>The identifier of the subscription grant.</p>', ], ], 'SubscriptionGrantOverallStatus' => [ 'base' => NULL, 'refs' => [ 'CreateSubscriptionGrantOutput$status' => '<p>The status of the subscription grant.</p>', 'DeleteSubscriptionGrantOutput$status' => '<p>The status of the subscription grant that is deleted.</p>', 'GetSubscriptionGrantOutput$status' => '<p>The status of the subscription grant.</p>', 'SubscriptionGrantSummary$status' => '<p>The status of the subscription grant.</p>', 'UpdateSubscriptionGrantStatusOutput$status' => '<p>The status to be updated as part of the <code>UpdateSubscriptionGrantStatus</code> action.</p>', ], ], 'SubscriptionGrantStatus' => [ 'base' => NULL, 'refs' => [ 'SubscribedAsset$status' => '<p>The status of the asset for which the subscription grant is created.</p>', 'UpdateSubscriptionGrantStatusInput$status' => '<p>The status to be updated as part of the <code>UpdateSubscriptionGrantStatus</code> action.</p>', ], ], 'SubscriptionGrantSummary' => [ 'base' => '<p>The details of the subscription grant.</p>', 'refs' => [ 'SubscriptionGrants$member' => NULL, ], ], 'SubscriptionGrants' => [ 'base' => NULL, 'refs' => [ 'ListSubscriptionGrantsOutput$items' => '<p>The results of the <code>ListSubscriptionGrants</code> action. </p>', ], ], 'SubscriptionId' => [ 'base' => NULL, 'refs' => [ 'CancelSubscriptionInput$identifier' => '<p>The unique identifier of the subscription that is being cancelled.</p>', 'CancelSubscriptionOutput$id' => '<p>The identifier of the subscription.</p>', 'CreateSubscriptionGrantOutput$subscriptionId' => '<p>The identifier of the subscription grant.</p>', 'DeleteSubscriptionGrantOutput$subscriptionId' => '<p>The identifier of the subsctiption whose subscription grant is to be deleted.</p>', 'GetSubscriptionGrantOutput$subscriptionId' => '<p>The identifier of the subscription.</p>', 'GetSubscriptionInput$identifier' => '<p>The ID of the subscription.</p>', 'GetSubscriptionOutput$id' => '<p>The ID of the subscription.</p>', 'ListSubscriptionGrantsInput$subscriptionId' => '<p>The identifier of the subscription.</p>', 'RevokeSubscriptionInput$identifier' => '<p>The identifier of the revoked subscription.</p>', 'RevokeSubscriptionOutput$id' => '<p>The identifier of the revoked subscription.</p>', 'SubscriptionGrantSummary$subscriptionId' => '<p>The ID of the subscription grant.</p>', 'SubscriptionSummary$id' => '<p>The identifier of the subscription.</p>', 'UpdateSubscriptionGrantStatusOutput$subscriptionId' => '<p>The identifier of the subscription.</p>', ], ], 'SubscriptionRequestId' => [ 'base' => NULL, 'refs' => [ 'AcceptSubscriptionRequestInput$identifier' => '<p>The unique identifier of the subscription request that is to be accepted.</p>', 'AcceptSubscriptionRequestOutput$id' => '<p>The identifier of the subscription request.</p>', 'CancelSubscriptionOutput$subscriptionRequestId' => '<p>The unique ID of the subscripton request for the subscription that is being cancelled.</p>', 'CreateSubscriptionRequestOutput$id' => '<p>The ID of the subscription request.</p>', 'DeleteSubscriptionRequestInput$identifier' => '<p>The ID of the subscription request that is deleted.</p>', 'GetSubscriptionOutput$subscriptionRequestId' => '<p>The ID of the subscription request.</p>', 'GetSubscriptionRequestDetailsInput$identifier' => '<p>The identifier of the subscription request the details of which to get.</p>', 'GetSubscriptionRequestDetailsOutput$id' => '<p>The identifier of the subscription request.</p>', 'ListSubscriptionsInput$subscriptionRequestIdentifier' => '<p>The identifier of the subscription request for the subscriptions that you want to list.</p>', 'RejectSubscriptionRequestInput$identifier' => '<p>The identifier of the subscription request that was rejected.</p>', 'RejectSubscriptionRequestOutput$id' => '<p>The identifier of the subscription request that was rejected.</p>', 'RevokeSubscriptionOutput$subscriptionRequestId' => '<p>The identifier of the subscription request for the revoked subscription.</p>', 'SubscriptionRequestSummary$id' => '<p>The identifier of the subscription request.</p>', 'SubscriptionSummary$subscriptionRequestId' => '<p>The identifier of the subscription request for the subscription.</p>', 'UpdateSubscriptionRequestInput$identifier' => '<p>The identifier of the subscription request that is to be updated.</p>', 'UpdateSubscriptionRequestOutput$id' => '<p>The identifier of the subscription request that is to be updated.</p>', ], ], 'SubscriptionRequestStatus' => [ 'base' => NULL, 'refs' => [ 'AcceptSubscriptionRequestOutput$status' => '<p>Specifies the status of the subscription request.</p>', 'CreateSubscriptionRequestOutput$status' => '<p>The status of the subscription request.</p>', 'GetSubscriptionRequestDetailsOutput$status' => '<p>The status of the subscription request.</p>', 'ListSubscriptionRequestsInput$status' => '<p>Specifies the status of the subscription requests.</p>', 'RejectSubscriptionRequestOutput$status' => '<p>The status of the subscription request.</p>', 'SubscriptionRequestSummary$status' => '<p>The status of the subscription request.</p>', 'UpdateSubscriptionRequestOutput$status' => '<p>The status of the subscription request.</p>', ], ], 'SubscriptionRequestSummary' => [ 'base' => '<p>The details of the subscription request.</p>', 'refs' => [ 'SubscriptionRequests$member' => NULL, ], ], 'SubscriptionRequestSummarySubscribedListingsList' => [ 'base' => NULL, 'refs' => [ 'SubscriptionRequestSummary$subscribedListings' => '<p>The listings included in the subscription request.</p>', ], ], 'SubscriptionRequestSummarySubscribedPrincipalsList' => [ 'base' => NULL, 'refs' => [ 'SubscriptionRequestSummary$subscribedPrincipals' => '<p>The principals included in the subscription request. </p>', ], ], 'SubscriptionRequests' => [ 'base' => NULL, 'refs' => [ 'ListSubscriptionRequestsOutput$items' => '<p>The results of the <code>ListSubscriptionRequests</code> action. </p>', ], ], 'SubscriptionStatus' => [ 'base' => NULL, 'refs' => [ 'CancelSubscriptionOutput$status' => '<p>The status of the request to cancel the subscription.</p>', 'GetSubscriptionOutput$status' => '<p>The status of the subscription.</p>', 'ListSubscriptionsInput$status' => '<p>The status of the subscriptions that you want to list.</p>', 'RevokeSubscriptionOutput$status' => '<p>The status of the revoked subscription.</p>', 'SubscriptionSummary$status' => '<p>The status of the subscription.</p>', ], ], 'SubscriptionSummary' => [ 'base' => '<p>The details of the subscription.</p>', 'refs' => [ 'Subscriptions$member' => NULL, ], ], 'SubscriptionTargetForm' => [ 'base' => '<p>The details of the subscription target configuration.</p>', 'refs' => [ 'SubscriptionTargetForms$member' => NULL, ], ], 'SubscriptionTargetForms' => [ 'base' => NULL, 'refs' => [ 'CreateSubscriptionTargetInput$subscriptionTargetConfig' => '<p>The configuration of the subscription target.</p>', 'CreateSubscriptionTargetOutput$subscriptionTargetConfig' => '<p>The configuration of the subscription target.</p>', 'GetSubscriptionTargetOutput$subscriptionTargetConfig' => '<p>The configuration of teh subscription target.</p>', 'SubscriptionTargetSummary$subscriptionTargetConfig' => '<p>The configuration of the subscription target.</p>', 'UpdateSubscriptionTargetInput$subscriptionTargetConfig' => '<p>The configuration to be updated as part of the <code>UpdateSubscriptionTarget</code> action.</p>', 'UpdateSubscriptionTargetOutput$subscriptionTargetConfig' => '<p>The configuration to be updated as part of the <code>UpdateSubscriptionTarget</code> action.</p>', ], ], 'SubscriptionTargetId' => [ 'base' => NULL, 'refs' => [ 'CreateSubscriptionGrantInput$subscriptionTargetIdentifier' => '<p>The ID of the subscription target for which the subscription grant is created.</p>', 'CreateSubscriptionGrantOutput$subscriptionTargetId' => '<p>The ID of the subscription target for which the subscription grant is created.</p>', 'CreateSubscriptionTargetOutput$id' => '<p>The ID of the subscription target.</p>', 'DeleteSubscriptionGrantOutput$subscriptionTargetId' => '<p>The ID of the subscription target associated with the subscription grant that is deleted.</p>', 'DeleteSubscriptionTargetInput$identifier' => '<p>The ID of the subscription target that is deleted.</p>', 'GetSubscriptionGrantOutput$subscriptionTargetId' => '<p>The subscription target ID associated with the subscription grant.</p>', 'GetSubscriptionTargetInput$identifier' => '<p>The ID of the subscription target.</p>', 'GetSubscriptionTargetOutput$id' => '<p>The ID of the subscription target.</p>', 'ListSubscriptionGrantsInput$subscriptionTargetId' => '<p>The identifier of the subscription target.</p>', 'SubscriptionGrantSummary$subscriptionTargetId' => '<p>The identifier of the target of the subscription grant.</p>', 'SubscriptionTargetSummary$id' => '<p>The identifier of the subscription target.</p>', 'UpdateSubscriptionGrantStatusOutput$subscriptionTargetId' => '<p>The identifier of the subscription target whose subscription grant status is to be updated.</p>', 'UpdateSubscriptionTargetInput$identifier' => '<p>Identifier of the subscription target that is to be updated.</p>', 'UpdateSubscriptionTargetOutput$id' => '<p>Identifier of the subscription target that is to be updated.</p>', ], ], 'SubscriptionTargetName' => [ 'base' => NULL, 'refs' => [ 'CreateSubscriptionTargetInput$name' => '<p>The name of the subscription target.</p>', 'CreateSubscriptionTargetOutput$name' => '<p>The name of the subscription target.</p>', 'GetSubscriptionTargetOutput$name' => '<p>The name of the subscription target.</p>', 'SubscriptionTargetSummary$name' => '<p>The name of the subscription target.</p>', 'UpdateSubscriptionTargetInput$name' => '<p>The name to be updated as part of the <code>UpdateSubscriptionTarget</code> action.</p>', 'UpdateSubscriptionTargetOutput$name' => '<p>The name to be updated as part of the <code>UpdateSubscriptionTarget</code> action.</p>', ], ], 'SubscriptionTargetSummary' => [ 'base' => '<p>The details of the subscription target.</p>', 'refs' => [ 'SubscriptionTargets$member' => NULL, ], ], 'SubscriptionTargets' => [ 'base' => NULL, 'refs' => [ 'ListSubscriptionTargetsOutput$items' => '<p>The results of the <code>ListSubscriptionTargets</code> action.</p>', ], ], 'Subscriptions' => [ 'base' => NULL, 'refs' => [ 'ListSubscriptionsOutput$items' => '<p>The results of the <code>ListSubscriptions</code> action.</p>', ], ], 'SyntheticTimestamp_date_time' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentOutput$createdAt' => '<p>The timestamp of when the environment was created.</p>', 'CreateEnvironmentOutput$updatedAt' => '<p>The timestamp of when this environment was updated.</p>', 'CreateEnvironmentProfileOutput$createdAt' => '<p>The timestamp of when this environment profile was created.</p>', 'CreateEnvironmentProfileOutput$updatedAt' => '<p>The timestamp of when this environment profile was updated.</p>', 'CreateProjectOutput$createdAt' => '<p>The timestamp of when the project was created.</p>', 'CreateProjectOutput$lastUpdatedAt' => '<p>The timestamp of when the project was last updated.</p>', 'EnvironmentBlueprintConfigurationItem$createdAt' => '<p>The timestamp of when an environment blueprint was created.</p>', 'EnvironmentBlueprintConfigurationItem$updatedAt' => '<p>The timestamp of when the environment blueprint was updated.</p>', 'EnvironmentBlueprintSummary$createdAt' => '<p>The timestamp of when an environment blueprint was created.</p>', 'EnvironmentBlueprintSummary$updatedAt' => '<p>The timestamp of when the blueprint was enabled.</p>', 'EnvironmentProfileSummary$createdAt' => '<p>The timestamp of when an environment profile was created.</p>', 'EnvironmentProfileSummary$updatedAt' => '<p>The timestamp of when the environment profile was updated.</p>', 'EnvironmentSummary$createdAt' => '<p>The timestamp of when the environment was created.</p>', 'EnvironmentSummary$updatedAt' => '<p>The timestamp of when the environment was updated.</p>', 'GetEnvironmentBlueprintConfigurationOutput$createdAt' => '<p>The timestamp of when this blueprint was created.</p>', 'GetEnvironmentBlueprintConfigurationOutput$updatedAt' => '<p>The timestamp of when this blueprint was upated.</p>', 'GetEnvironmentBlueprintOutput$createdAt' => '<p>A timestamp of when this blueprint was created.</p>', 'GetEnvironmentBlueprintOutput$updatedAt' => '<p>The timestamp of when this blueprint was updated.</p>', 'GetEnvironmentOutput$createdAt' => '<p>The timestamp of when the environment was created.</p>', 'GetEnvironmentOutput$updatedAt' => '<p>The timestamp of when this environment was updated.</p>', 'GetEnvironmentProfileOutput$createdAt' => '<p>The timestamp of when this environment profile was created.</p>', 'GetEnvironmentProfileOutput$updatedAt' => '<p>The timestamp of when this environment profile was upated.</p>', 'GetProjectOutput$createdAt' => '<p>The timestamp of when the project was created.</p>', 'GetProjectOutput$lastUpdatedAt' => '<p>The timestamp of when the project was last updated.</p>', 'ProjectSummary$createdAt' => '<p>The timestamp of when a project was created.</p>', 'ProjectSummary$updatedAt' => '<p>The timestamp of when the project was updated.</p>', 'PutEnvironmentBlueprintConfigurationOutput$createdAt' => '<p>The timestamp of when the environment blueprint was created.</p>', 'PutEnvironmentBlueprintConfigurationOutput$updatedAt' => '<p>The timestamp of when the environment blueprint was updated.</p>', 'UpdateEnvironmentOutput$createdAt' => '<p>The timestamp of when the environment was created.</p>', 'UpdateEnvironmentOutput$updatedAt' => '<p>The timestamp of when the environment was updated.</p>', 'UpdateEnvironmentProfileOutput$createdAt' => '<p>The timestamp of when the environment profile was created.</p>', 'UpdateEnvironmentProfileOutput$updatedAt' => '<p>The timestamp of when the environment profile was updated.</p>', 'UpdateProjectOutput$createdAt' => '<p>The timestamp of when the project was created.</p>', 'UpdateProjectOutput$lastUpdatedAt' => '<p>The timestamp of when the project was last updated.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'Tags$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>Specifies the tag keys for the <code>UntagResource</code> action.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tags$value' => NULL, ], ], 'Tags' => [ 'base' => NULL, 'refs' => [ 'CreateDomainInput$tags' => '<p>The tags specified for the Amazon DataZone domain.</p>', 'CreateDomainOutput$tags' => '<p>The tags specified for the Amazon DataZone domain.</p>', 'GetDomainOutput$tags' => '<p>The tags specified for the Amazon DataZone domain.</p>', 'ListTagsForResourceResponse$tags' => '<p>The tags of the specified resource.</p>', 'TagResourceRequest$tags' => '<p>Specifies the tags for the <code>TagResource</code> action.</p>', ], ], 'TaskId' => [ 'base' => NULL, 'refs' => [ 'NotificationOutput$identifier' => '<p>The identifier of the notification.</p>', ], ], 'TaskStatus' => [ 'base' => NULL, 'refs' => [ 'ListNotificationsInput$taskStatus' => '<p>The task status of notifications.</p>', 'NotificationOutput$status' => '<p>The status included in the notification.</p>', ], ], 'TermRelations' => [ 'base' => '<p>The details of the term relations.</p>', 'refs' => [ 'CreateGlossaryTermInput$termRelations' => '<p>The term relations of this business glossary term.</p>', 'CreateGlossaryTermOutput$termRelations' => '<p>The term relations of this business glossary term.</p>', 'GetGlossaryTermOutput$termRelations' => '<p>The relations of the business glossary term.</p>', 'GlossaryTermItem$termRelations' => '<p>The relations of the business glossary term.</p>', 'UpdateGlossaryTermInput$termRelations' => '<p>The term relations to be updated as part of the <code>UpdateGlossaryTerm</code> action.</p>', 'UpdateGlossaryTermOutput$termRelations' => '<p>The term relations to be updated as part of the <code>UpdateGlossaryTerm</code> action.</p>', ], ], 'TermRelationsClassifiesList' => [ 'base' => NULL, 'refs' => [ 'TermRelations$classifies' => '<p>The classifies of the term relations.</p>', ], ], 'TermRelationsIsAList' => [ 'base' => NULL, 'refs' => [ 'TermRelations$isA' => '<p>The <code>isA</code> property of the term relations.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The request was denied due to request throttling.</p>', 'refs' => [], ], 'TimeSeriesDataPointFormInput' => [ 'base' => '<p>The time series data points form.</p>', 'refs' => [ 'TimeSeriesDataPointFormInputList$member' => NULL, ], ], 'TimeSeriesDataPointFormInputContentString' => [ 'base' => NULL, 'refs' => [ 'TimeSeriesDataPointFormInput$content' => '<p>The content of the time series data points form.</p>', ], ], 'TimeSeriesDataPointFormInputList' => [ 'base' => NULL, 'refs' => [ 'PostTimeSeriesDataPointsInput$forms' => '<p>The forms that contain the data points that you want to post.</p>', ], ], 'TimeSeriesDataPointFormOutput' => [ 'base' => '<p>The time series data points form.</p>', 'refs' => [ 'GetTimeSeriesDataPointOutput$form' => '<p>The time series form that houses the data point that you want to get.</p>', 'TimeSeriesDataPointFormOutputList$member' => NULL, ], ], 'TimeSeriesDataPointFormOutputContentString' => [ 'base' => NULL, 'refs' => [ 'TimeSeriesDataPointFormOutput$content' => '<p>The content of the time series data points form.</p>', ], ], 'TimeSeriesDataPointFormOutputList' => [ 'base' => NULL, 'refs' => [ 'PostTimeSeriesDataPointsOutput$forms' => '<p>The forms that contain the data points that you have posted.</p>', ], ], 'TimeSeriesDataPointIdentifier' => [ 'base' => NULL, 'refs' => [ 'GetTimeSeriesDataPointInput$identifier' => '<p>The ID of the data point that you want to get.</p>', ], ], 'TimeSeriesDataPointSummaryFormOutput' => [ 'base' => '<p>The summary of the time series data points form.</p>', 'refs' => [ 'TimeSeriesDataPointSummaryFormOutputList$member' => NULL, ], ], 'TimeSeriesDataPointSummaryFormOutputContentSummaryString' => [ 'base' => NULL, 'refs' => [ 'TimeSeriesDataPointSummaryFormOutput$contentSummary' => '<p>The content of the summary of the time series data points form.</p>', ], ], 'TimeSeriesDataPointSummaryFormOutputList' => [ 'base' => NULL, 'refs' => [ 'AssetItemAdditionalAttributes$latestTimeSeriesDataPointFormsOutput' => '<p>The latest time series data points forms included in the additional attributes of an asset.</p>', 'AssetListing$latestTimeSeriesDataPointForms' => '<p>The latest time series data points forms included in the additional attributes of an asset.</p>', 'AssetListingItemAdditionalAttributes$latestTimeSeriesDataPointForms' => '<p>The latest time series data points forms included in the additional attributes of an asset.</p>', 'CreateAssetOutput$latestTimeSeriesDataPointFormsOutput' => '<p>The latest data point that was imported into the time series form for the asset. </p>', 'CreateAssetRevisionOutput$latestTimeSeriesDataPointFormsOutput' => '<p>The latest data point that was imported into the time series form for the asset. </p>', 'GetAssetOutput$latestTimeSeriesDataPointFormsOutput' => '<p>The latest data point that was imported into the time series form for the asset. </p>', 'ListTimeSeriesDataPointsOutput$items' => '<p>The results of the ListTimeSeriesDataPoints action. </p>', ], ], 'TimeSeriesEntityType' => [ 'base' => NULL, 'refs' => [ 'DeleteTimeSeriesDataPointsInput$entityType' => '<p>The type of the asset for which you want to delete a time series form.</p>', 'GetTimeSeriesDataPointInput$entityType' => '<p>The type of the asset for which you want to get the data point.</p>', 'GetTimeSeriesDataPointOutput$entityType' => '<p>The type of the asset for which you want to get the data point.</p>', 'ListTimeSeriesDataPointsInput$entityType' => '<p>The type of the asset for which you want to list data points.</p>', 'PostTimeSeriesDataPointsInput$entityType' => '<p>The type of the asset for which you want to post data points.</p>', 'PostTimeSeriesDataPointsOutput$entityType' => '<p>The type of the asset for which you want to post data points.</p>', ], ], 'TimeSeriesFormName' => [ 'base' => NULL, 'refs' => [ 'DeleteTimeSeriesDataPointsInput$formName' => '<p>The name of the time series form that you want to delete.</p>', 'GetTimeSeriesDataPointInput$formName' => '<p>The name of the time series form that houses the data point that you want to get.</p>', 'GetTimeSeriesDataPointOutput$formName' => '<p>The name of the time series form that houses the data point that you want to get.</p>', 'ListTimeSeriesDataPointsInput$formName' => '<p>The name of the time series data points form.</p>', 'TimeSeriesDataPointFormInput$formName' => '<p>The name of the time series data points form.</p>', 'TimeSeriesDataPointFormOutput$formName' => '<p>The name of the time series data points form.</p>', 'TimeSeriesDataPointSummaryFormOutput$formName' => '<p>The name of the time series data points summary form.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'GetLineageNodeInput$eventTimestamp' => '<p>The event time stamp for which you want to get the data lineage node.</p>', 'GetLineageNodeOutput$eventTimestamp' => '<p>The timestamp of the event described in the data lineage node.</p>', 'LineageNodeReference$eventTimestamp' => '<p>The event timestamp of the data lineage node.</p>', 'LineageNodeSummary$eventTimestamp' => '<p>The event timestamp of the data lineage node.</p>', 'ListLineageNodeHistoryInput$eventTimestampGTE' => '<p>Specifies whether the action is to return data lineage node history from the time after the event timestamp.</p>', 'ListLineageNodeHistoryInput$eventTimestampLTE' => '<p>Specifies whether the action is to return data lineage node history from the time prior of the event timestamp.</p>', 'ListNotificationsInput$afterTimestamp' => '<p>The time after which you want to list notifications.</p>', 'ListNotificationsInput$beforeTimestamp' => '<p>The time before which you want to list notifications.</p>', 'ListTimeSeriesDataPointsInput$endedAt' => '<p>The timestamp at which the data points that you wanted to list ended.</p>', 'ListTimeSeriesDataPointsInput$startedAt' => '<p>The timestamp at which the data points that you want to list started.</p>', 'NotificationOutput$creationTimestamp' => '<p>The timestamp of when a notification was created.</p>', 'NotificationOutput$lastUpdatedTimestamp' => '<p>The timestamp of when the notification was last updated.</p>', 'SubscribedAsset$failureTimestamp' => '<p>The failure timestamp included in the details of the asset for which the subscription grant is created.</p>', 'SubscribedAsset$grantedTimestamp' => '<p>The timestamp of when the subscription grant to the asset is created.</p>', 'TimeSeriesDataPointFormInput$timestamp' => '<p>The timestamp of the time series data points form.</p>', 'TimeSeriesDataPointFormOutput$timestamp' => '<p>The timestamp of the time series data points form.</p>', 'TimeSeriesDataPointSummaryFormOutput$timestamp' => '<p>The timestamp of the time series data points summary form.</p>', ], ], 'Timezone' => [ 'base' => NULL, 'refs' => [ 'ScheduleConfiguration$timezone' => '<p>The timezone of the data source run. </p>', ], ], 'Title' => [ 'base' => NULL, 'refs' => [ 'NotificationOutput$title' => '<p>The title of the notification.</p>', ], ], 'Topic' => [ 'base' => '<p>The topic of the notification.</p>', 'refs' => [ 'NotificationOutput$topic' => '<p>The topic of the notification.</p>', ], ], 'TypeName' => [ 'base' => NULL, 'refs' => [ 'ApplicableAssetTypes$member' => NULL, 'AssetListing$assetType' => '<p>The type of an asset published in an Amazon DataZone catalog. </p>', 'AssetListingItem$entityType' => '<p>The type of the inventory asset.</p>', 'AssetTypeItem$name' => '<p>The name of the asset type.</p>', 'CreateAssetTypeInput$name' => '<p>The name of the custom asset type.</p>', 'CreateAssetTypeOutput$name' => '<p>The name of the asset type.</p>', 'GetAssetTypeOutput$name' => '<p>The name of the asset type.</p>', 'SubscribedAssetListing$entityType' => '<p>The type of the published asset for which the subscription grant is created.</p>', ], ], 'TypesSearchScope' => [ 'base' => NULL, 'refs' => [ 'SearchTypesInput$searchScope' => '<p>Specifies the scope of the search for types.</p>', ], ], 'UnauthorizedException' => [ 'base' => '<p>You do not have permission to perform this action.</p>', 'refs' => [], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDataSourceInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDataSourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDomainInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDomainOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEnvironmentActionInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEnvironmentActionOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEnvironmentInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEnvironmentOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEnvironmentProfileInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEnvironmentProfileOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGlossaryInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGlossaryOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGlossaryTermInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGlossaryTermOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGroupProfileInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGroupProfileOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateProjectInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateProjectOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSubscriptionGrantStatusInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSubscriptionGrantStatusOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSubscriptionRequestInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSubscriptionRequestOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSubscriptionRequestOutputSubscribedListingsList' => [ 'base' => NULL, 'refs' => [ 'UpdateSubscriptionRequestOutput$subscribedListings' => '<p>The subscribed listings of the subscription request.</p>', ], ], 'UpdateSubscriptionRequestOutputSubscribedPrincipalsList' => [ 'base' => NULL, 'refs' => [ 'UpdateSubscriptionRequestOutput$subscribedPrincipals' => '<p>The subscribed principals of the subscription request.</p>', ], ], 'UpdateSubscriptionTargetInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSubscriptionTargetOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUserProfileInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUserProfileOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdatedAt' => [ 'base' => NULL, 'refs' => [ 'AcceptSubscriptionRequestOutput$updatedAt' => '<p>Specifies the timestamp when subscription request was updated.</p>', 'AssetTypeItem$updatedAt' => '<p>The timestamp of when the asset type was updated.</p>', 'CancelSubscriptionOutput$updatedAt' => '<p>The timestamp that specifies when the subscription was cancelled.</p>', 'CreateAssetTypeOutput$updatedAt' => '<p>The timestamp of when the custom type was created.</p>', 'CreateSubscriptionGrantOutput$updatedAt' => '<p>A timestamp of when the subscription grant was updated.</p>', 'CreateSubscriptionRequestOutput$updatedAt' => '<p>The timestamp of when the subscription request was updated.</p>', 'CreateSubscriptionTargetOutput$updatedAt' => '<p>The timestamp of when the subscription target was updated.</p>', 'DataProductSummary$updatedAt' => '<p/>', 'DeleteSubscriptionGrantOutput$updatedAt' => '<p>The timestamp of when the subscription grant that is deleted was updated.</p>', 'DomainSummary$lastUpdatedAt' => '<p>A timestamp of when a Amazon DataZone domain was last updated.</p>', 'GetAssetTypeOutput$updatedAt' => '<p>The timestamp of when the asset type was updated.</p>', 'GetDomainOutput$lastUpdatedAt' => '<p>The timestamp of when the Amazon DataZone domain was last updated.</p>', 'GetGlossaryOutput$updatedAt' => '<p>The timestamp of when the business glossary was updated.</p>', 'GetGlossaryTermOutput$updatedAt' => '<p>The timestamp of when the business glossary term was updated.</p>', 'GetLineageNodeOutput$updatedAt' => '<p>The timestamp at which the data lineage node was updated.</p>', 'GetListingOutput$updatedAt' => '<p>The timestamp of when the listing was updated.</p>', 'GetSubscriptionGrantOutput$updatedAt' => '<p>The timestamp of when the subscription grant was upated.</p>', 'GetSubscriptionOutput$updatedAt' => '<p>The timestamp of when the subscription was updated.</p>', 'GetSubscriptionRequestDetailsOutput$updatedAt' => '<p>The timestamp of when the subscription request was updated.</p>', 'GetSubscriptionTargetOutput$updatedAt' => '<p>The timestamp of when the subscription target was updated.</p>', 'GlossaryItem$updatedAt' => '<p>The timestamp of when the business glossary was updated.</p>', 'GlossaryTermItem$updatedAt' => '<p>The timestamp of when a business glossary term was updated.</p>', 'LineageNodeSummary$updatedAt' => '<p>The timestamp at which the data lineage node was updated.</p>', 'LineageNodeTypeItem$updatedAt' => '<p>The timestamp at which the data lineage node type was updated.</p>', 'RejectSubscriptionRequestOutput$updatedAt' => '<p>The timestamp of when the subscription request was updated.</p>', 'RevokeSubscriptionOutput$updatedAt' => '<p>The timestamp of when the subscription was revoked.</p>', 'SubscriptionGrantSummary$updatedAt' => '<p>The timestampf of when the subscription grant was updated.</p>', 'SubscriptionRequestSummary$updatedAt' => '<p>The timestamp of when the subscription request was updated.</p>', 'SubscriptionSummary$updatedAt' => '<p>The timestamp of when the subscription was updated.</p>', 'SubscriptionTargetSummary$updatedAt' => '<p>The timestamp of when the subscription target was updated.</p>', 'UpdateDomainOutput$lastUpdatedAt' => '<p>Specifies the timestamp of when the domain was last updated.</p>', 'UpdateSubscriptionGrantStatusOutput$updatedAt' => '<p>The timestamp of when the subscription grant status is to be updated.</p>', 'UpdateSubscriptionRequestOutput$updatedAt' => '<p>The timestamp of when the subscription request was updated.</p>', 'UpdateSubscriptionTargetOutput$updatedAt' => '<p>The timestamp of when the subscription target was updated.</p>', ], ], 'UpdatedBy' => [ 'base' => NULL, 'refs' => [ 'AcceptSubscriptionRequestOutput$updatedBy' => '<p>Specifies the Amazon DataZone user who updated the subscription request.</p>', 'AssetListingItem$listingUpdatedBy' => '<p>The Amazon DataZone user who updated the listing.</p>', 'AssetTypeItem$updatedBy' => '<p>The Amazon DataZone user who updated the asset type.</p>', 'CancelSubscriptionOutput$updatedBy' => '<p>The Amazon DataZone user that cancelled the subscription.</p>', 'CreateAssetTypeOutput$updatedBy' => '<p>The Amazon DataZone user that created the custom asset type.</p>', 'CreateSubscriptionGrantOutput$updatedBy' => '<p>The Amazon DataZone user who updated the subscription grant.</p>', 'CreateSubscriptionRequestOutput$updatedBy' => '<p>The Amazon DataZone user who updated the subscription request.</p>', 'CreateSubscriptionTargetOutput$updatedBy' => '<p>The Amazon DataZone user who updated the subscription target.</p>', 'DataProductSummary$updatedBy' => '<p/>', 'DeleteSubscriptionGrantOutput$updatedBy' => '<p>The Amazon DataZone user who updated the subscription grant that is deleted.</p>', 'GetAssetTypeOutput$updatedBy' => '<p>The Amazon DataZone user that updated the asset type.</p>', 'GetGlossaryOutput$updatedBy' => '<p>The Amazon DataZone user who updated the business glossary.</p>', 'GetGlossaryTermOutput$updatedBy' => '<p>The Amazon DataZone user who updated the business glossary term.</p>', 'GetLineageNodeOutput$updatedBy' => '<p>The user who updated the data lineage node.</p>', 'GetListingOutput$updatedBy' => '<p>The Amazon DataZone user who updated the listing.</p>', 'GetSubscriptionGrantOutput$updatedBy' => '<p>The Amazon DataZone user who updated the subscription grant.</p>', 'GetSubscriptionOutput$updatedBy' => '<p>The Amazon DataZone user who updated the subscription.</p>', 'GetSubscriptionRequestDetailsOutput$updatedBy' => '<p>The Amazon DataZone user who updated the subscription request.</p>', 'GetSubscriptionTargetOutput$updatedBy' => '<p>The Amazon DataZone user who updated the subscription target.</p>', 'GlossaryItem$updatedBy' => '<p>The Amazon DataZone user who updated the business glossary.</p>', 'GlossaryTermItem$updatedBy' => '<p>The Amazon DataZone user who updated the business glossary term.</p>', 'LineageNodeSummary$updatedBy' => '<p>The user who updated the data lineage node.</p>', 'LineageNodeTypeItem$updatedBy' => '<p>The user who updated the data lineage node type.</p>', 'RejectSubscriptionRequestOutput$updatedBy' => '<p>The Amazon DataZone user who updated the subscription request.</p>', 'RevokeSubscriptionOutput$updatedBy' => '<p>The Amazon DataZone user who revoked the subscription.</p>', 'SubscriptionGrantSummary$updatedBy' => '<p>The Amazon DataZone user who updated the subscription grant.</p>', 'SubscriptionRequestSummary$updatedBy' => '<p>The identifier of the Amazon DataZone user who updated the subscription request.</p>', 'SubscriptionSummary$updatedBy' => '<p>The Amazon DataZone user who updated the subscription.</p>', 'SubscriptionTargetSummary$updatedBy' => '<p>The Amazon DataZone user who updated the subscription target.</p>', 'UpdateSubscriptionGrantStatusOutput$updatedBy' => '<p>The Amazon DataZone user who updated the subscription grant status.</p>', 'UpdateSubscriptionRequestOutput$updatedBy' => '<p>The Amazon DataZone user who updated the subscription request.</p>', 'UpdateSubscriptionTargetOutput$updatedBy' => '<p>The Amazon DataZone user who updated the subscription target.</p>', ], ], 'UserAssignment' => [ 'base' => NULL, 'refs' => [ 'SingleSignOn$userAssignment' => '<p>The single sign-on user assignment in Amazon DataZone.</p>', ], ], 'UserDesignation' => [ 'base' => NULL, 'refs' => [ 'CreateProjectMembershipInput$designation' => '<p>The designation of the project membership.</p>', 'ProjectMember$designation' => '<p>The designated role of a project member.</p>', ], ], 'UserDetails' => [ 'base' => '<p>The user details of a project member.</p>', 'refs' => [ 'MemberDetails$user' => '<p>The user details of a project member.</p>', ], ], 'UserIdentifier' => [ 'base' => NULL, 'refs' => [ 'CreateUserProfileInput$userIdentifier' => '<p>The identifier of the user for which the user profile is created.</p>', 'GetUserProfileInput$userIdentifier' => '<p>The identifier of the user for which you want to get the user profile.</p>', 'UpdateUserProfileInput$userIdentifier' => '<p>The identifier of the user whose user profile is to be updated.</p>', ], ], 'UserProfileDetails' => [ 'base' => '<p>The details of the user profile in Amazon DataZone.</p>', 'refs' => [ 'CreateUserProfileOutput$details' => NULL, 'GetUserProfileOutput$details' => NULL, 'UpdateUserProfileOutput$details' => NULL, 'UserProfileSummary$details' => '<p>The details of the user profile.</p>', ], ], 'UserProfileId' => [ 'base' => NULL, 'refs' => [ 'CreateUserProfileOutput$id' => '<p>The identifier of the user profile.</p>', 'GetUserProfileOutput$id' => '<p>The identifier of the user profile.</p>', 'UpdateUserProfileOutput$id' => '<p>The identifier of the user profile.</p>', 'UserProfileSummary$id' => '<p>The ID of the user profile.</p>', ], ], 'UserProfileName' => [ 'base' => NULL, 'refs' => [ 'SsoUserProfileDetails$username' => '<p>The username included in the single sign-on details of the user profile.</p>', ], ], 'UserProfileStatus' => [ 'base' => NULL, 'refs' => [ 'CreateUserProfileOutput$status' => '<p>The status of the user profile.</p>', 'GetUserProfileOutput$status' => '<p>The status of the user profile.</p>', 'UpdateUserProfileInput$status' => '<p>The status of the user profile that are to be updated.</p>', 'UpdateUserProfileOutput$status' => '<p>The status of the user profile.</p>', 'UserProfileSummary$status' => '<p>The status of the user profile.</p>', ], ], 'UserProfileSummaries' => [ 'base' => NULL, 'refs' => [ 'SearchUserProfilesOutput$items' => '<p>The results of the <code>SearchUserProfiles</code> action.</p>', ], ], 'UserProfileSummary' => [ 'base' => '<p>The details of the user profile.</p>', 'refs' => [ 'UserProfileSummaries$member' => NULL, ], ], 'UserProfileType' => [ 'base' => NULL, 'refs' => [ 'CreateUserProfileOutput$type' => '<p>The type of the user profile.</p>', 'GetUserProfileInput$type' => '<p>The type of the user profile.</p>', 'GetUserProfileOutput$type' => '<p>The type of the user profile.</p>', 'UpdateUserProfileInput$type' => '<p>The type of the user profile that are to be updated.</p>', 'UpdateUserProfileOutput$type' => '<p>The type of the user profile.</p>', 'UserProfileSummary$type' => '<p>The type of the user profile.</p>', ], ], 'UserSearchText' => [ 'base' => NULL, 'refs' => [ 'SearchUserProfilesInput$searchText' => '<p>Specifies the text for which to search.</p>', ], ], 'UserSearchType' => [ 'base' => NULL, 'refs' => [ 'SearchUserProfilesInput$userType' => '<p>Specifies the user type for the <code>SearchUserProfiles</code> action.</p>', ], ], 'UserType' => [ 'base' => NULL, 'refs' => [ 'CreateUserProfileInput$userType' => '<p>The user type of the user for which the user profile is created.</p>', ], ], 'ValidationException' => [ 'base' => '<p>The input fails to satisfy the constraints specified by the Amazon Web Services service.</p>', 'refs' => [], ], ],];
