<?php
// This file was auto-generated from sdk-root/src/data/ec2/2016-09-15/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Amazon Elastic Compute Cloud</fullname> <p>Amazon Elastic Compute Cloud (Amazon EC2) provides resizable computing capacity in the Amazon Web Services (AWS) cloud. Using Amazon EC2 eliminates your need to invest in hardware up front, so you can develop and deploy applications faster.</p>', 'operations' => [ 'AcceptReservedInstancesExchangeQuote' => '<p>Purchases Convertible Reserved Instance offerings described in the <a>GetReservedInstancesExchangeQuote</a> call.</p>', 'AcceptVpcPeeringConnection' => '<p>Accept a VPC peering connection request. To accept a request, the VPC peering connection must be in the <code>pending-acceptance</code> state, and you must be the owner of the peer VPC. Use the <code>DescribeVpcPeeringConnections</code> request to view your outstanding VPC peering connection requests.</p>', 'AllocateAddress' => '<p>Acquires an Elastic IP address.</p> <p>An Elastic IP address is for use either in the EC2-Classic platform or in a VPC. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'AllocateHosts' => '<p>Allocates a Dedicated Host to your account. At minimum you need to specify the instance size type, Availability Zone, and quantity of hosts you want to allocate.</p>', 'AssignPrivateIpAddresses' => '<p>Assigns one or more secondary private IP addresses to the specified network interface. You can specify one or more specific secondary IP addresses, or you can specify the number of secondary IP addresses to be automatically assigned within the subnet\'s CIDR block range. The number of secondary IP addresses that you can assign to an instance varies by instance type. For information about instance types, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. For more information about Elastic IP addresses, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <p>AssignPrivateIpAddresses is available only in EC2-VPC.</p>', 'AssociateAddress' => '<p>Associates an Elastic IP address with an instance or a network interface.</p> <p>An Elastic IP address is for use in either the EC2-Classic platform or in a VPC. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <p>[EC2-Classic, VPC in an EC2-VPC-only account] If the Elastic IP address is already associated with a different instance, it is disassociated from that instance and associated with the specified instance.</p> <p>[VPC in an EC2-Classic account] If you don\'t specify a private IP address, the Elastic IP address is associated with the primary IP address. If the Elastic IP address is already associated with a different instance or a network interface, you get an error unless you allow reassociation.</p> <important> <p>This is an idempotent operation. If you perform the operation more than once, Amazon EC2 doesn\'t return an error, and you may be charged for each time the Elastic IP address is remapped to the same instance. For more information, see the <i>Elastic IP Addresses</i> section of <a href="http://aws.amazon.com/ec2/pricing/">Amazon EC2 Pricing</a>.</p> </important>', 'AssociateDhcpOptions' => '<p>Associates a set of DHCP options (that you\'ve previously created) with the specified VPC, or associates no DHCP options with the VPC.</p> <p>After you associate the options with the VPC, any existing instances and all new instances that you launch in that VPC use the options. You don\'t need to restart or relaunch the instances. They automatically pick up the changes within a few hours, depending on how frequently the instance renews its DHCP lease. You can explicitly renew the lease using the operating system on the instance.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_DHCP_Options.html">DHCP Options Sets</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'AssociateRouteTable' => '<p>Associates a subnet with a route table. The subnet and route table must be in the same VPC. This association causes traffic originating from the subnet to be routed according to the routes in the route table. The action returns an association ID, which you need in order to disassociate the route table from the subnet later. A route table can be associated with multiple subnets.</p> <p>For more information about route tables, see <a href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Route_Tables.html">Route Tables</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'AttachClassicLinkVpc' => '<p>Links an EC2-Classic instance to a ClassicLink-enabled VPC through one or more of the VPC\'s security groups. You cannot link an EC2-Classic instance to more than one VPC at a time. You can only link an instance that\'s in the <code>running</code> state. An instance is automatically unlinked from a VPC when it\'s stopped - you can link it to the VPC again when you restart it.</p> <p>After you\'ve linked an instance, you cannot change the VPC security groups that are associated with it. To change the security groups, you must first unlink the instance, and then link it again.</p> <p>Linking your instance to a VPC is sometimes referred to as <i>attaching</i> your instance.</p>', 'AttachInternetGateway' => '<p>Attaches an Internet gateway to a VPC, enabling connectivity between the Internet and the VPC. For more information about your VPC and Internet gateway, see the <a href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/">Amazon Virtual Private Cloud User Guide</a>.</p>', 'AttachNetworkInterface' => '<p>Attaches a network interface to an instance.</p>', 'AttachVolume' => '<p>Attaches an EBS volume to a running or stopped instance and exposes it to the instance with the specified device name.</p> <p>Encrypted EBS volumes may only be attached to instances that support Amazon EBS encryption. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <p>For a list of supported device names, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-attaching-volume.html">Attaching an EBS Volume to an Instance</a>. Any device names that aren\'t reserved for instance store volumes can be used for EBS volumes. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html">Amazon EC2 Instance Store</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <p>If a volume has an AWS Marketplace product code:</p> <ul> <li> <p>The volume can be attached only to a stopped instance.</p> </li> <li> <p>AWS Marketplace product codes are copied from the volume to the instance.</p> </li> <li> <p>You must be subscribed to the product.</p> </li> <li> <p>The instance type and operating system of the instance must support the product. For example, you can\'t detach a volume from a Windows instance and attach it to a Linux instance.</p> </li> </ul> <p>For an overview of the AWS Marketplace, see <a href="https://aws.amazon.com/marketplace/help/200900000">Introducing AWS Marketplace</a>.</p> <p>For more information about EBS volumes, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-attaching-volume.html">Attaching Amazon EBS Volumes</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'AttachVpnGateway' => '<p>Attaches a virtual private gateway to a VPC. For more information, see <a href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_VPN.html">Adding a Hardware Virtual Private Gateway to Your VPC</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'AuthorizeSecurityGroupEgress' => '<p>[EC2-VPC only] Adds one or more egress rules to a security group for use with a VPC. Specifically, this action permits instances to send traffic to one or more destination CIDR IP address ranges, or to one or more destination security groups for the same VPC. This action doesn\'t apply to security groups for use in EC2-Classic. For more information, see <a href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html">Security Groups for Your VPC</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p> <important> <p>You can have up to 50 rules per security group (covering both ingress and egress rules).</p> </important> <p>Each rule consists of the protocol (for example, TCP), plus either a CIDR range or a source group. For the TCP and UDP protocols, you must also specify the destination port or port range. For the ICMP protocol, you must also specify the ICMP type and code. You can use -1 for the type or code to mean all types or all codes.</p> <p>Rule changes are propagated to affected instances as quickly as possible. However, a small delay might occur.</p>', 'AuthorizeSecurityGroupIngress' => '<p>Adds one or more ingress rules to a security group.</p> <important> <p>EC2-Classic: You can have up to 100 rules per group.</p> <p>EC2-VPC: You can have up to 50 rules per group (covering both ingress and egress rules).</p> </important> <p>Rule changes are propagated to instances within the security group as quickly as possible. However, a small delay might occur.</p> <p>[EC2-Classic] This action gives one or more CIDR IP address ranges permission to access a security group in your account, or gives one or more security groups (called the <i>source groups</i>) permission to access a security group for your account. A source group can be for your own AWS account, or another.</p> <p>[EC2-VPC] This action gives one or more CIDR IP address ranges permission to access a security group in your VPC, or gives one or more other security groups (called the <i>source groups</i>) permission to access a security group for your VPC. The security groups must all be for the same VPC.</p>', 'BundleInstance' => '<p>Bundles an Amazon instance store-backed Windows instance.</p> <p>During bundling, only the root device volume (C:\\) is bundled. Data on other instance store volumes is not preserved.</p> <note> <p>This action is not applicable for Linux/Unix instances or Windows instances that are backed by Amazon EBS.</p> </note> <p>For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/Creating_InstanceStoreBacked_WinAMI.html">Creating an Instance Store-Backed Windows AMI</a>.</p>', 'CancelBundleTask' => '<p>Cancels a bundling operation for an instance store-backed Windows instance.</p>', 'CancelConversionTask' => '<p>Cancels an active conversion task. The task can be the import of an instance or volume. The action removes all artifacts of the conversion, including a partially uploaded volume or instance. If the conversion is complete or is in the process of transferring the final disk image, the command fails and returns an exception.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/CommandLineReference/ec2-cli-vmimport-export.html">Importing a Virtual Machine Using the Amazon EC2 CLI</a>.</p>', 'CancelExportTask' => '<p>Cancels an active export task. The request removes all artifacts of the export, including any partially-created Amazon S3 objects. If the export task is complete or is in the process of transferring the final disk image, the command fails and returns an error.</p>', 'CancelImportTask' => '<p>Cancels an in-process import virtual machine or import snapshot task.</p>', 'CancelReservedInstancesListing' => '<p>Cancels the specified Reserved Instance listing in the Reserved Instance Marketplace.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Reserved Instance Marketplace</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'CancelSpotFleetRequests' => '<p>Cancels the specified Spot fleet requests.</p> <p>After you cancel a Spot fleet request, the Spot fleet launches no new Spot instances. You must specify whether the Spot fleet should also terminate its Spot instances. If you terminate the instances, the Spot fleet request enters the <code>cancelled_terminating</code> state. Otherwise, the Spot fleet request enters the <code>cancelled_running</code> state and the instances continue to run until they are interrupted or you terminate them manually.</p>', 'CancelSpotInstanceRequests' => '<p>Cancels one or more Spot instance requests. Spot instances are instances that Amazon EC2 starts on your behalf when the bid price that you specify exceeds the current Spot price. Amazon EC2 periodically sets the Spot price based on available Spot instance capacity and current Spot instance requests. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-requests.html">Spot Instance Requests</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <important> <p>Canceling a Spot instance request does not terminate running Spot instances associated with the request.</p> </important>', 'ConfirmProductInstance' => '<p>Determines whether a product code is associated with an instance. This action can only be used by the owner of the product code. It is useful when a product code owner needs to verify whether another user\'s instance is eligible for support.</p>', 'CopyImage' => '<p>Initiates the copy of an AMI from the specified source region to the current region. You specify the destination region by using its endpoint when making the request.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/CopyingAMIs.html">Copying AMIs</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'CopySnapshot' => '<p>Copies a point-in-time snapshot of an EBS volume and stores it in Amazon S3. You can copy the snapshot within the same region or from one region to another. You can use the snapshot to create EBS volumes or Amazon Machine Images (AMIs). The snapshot is copied to the regional endpoint that you send the HTTP request to.</p> <p>Copies of encrypted EBS snapshots remain encrypted. Copies of unencrypted snapshots remain unencrypted, unless the <code>Encrypted</code> flag is specified during the snapshot copy operation. By default, encrypted snapshot copies use the default AWS Key Management Service (AWS KMS) customer master key (CMK); however, you can specify a non-default CMK with the <code>KmsKeyId</code> parameter. </p> <note> <p>To copy an encrypted snapshot that has been shared from another account, you must have permissions for the CMK used to encrypt the snapshot.</p> </note> <note> <p>Snapshots created by the CopySnapshot action have an arbitrary volume ID that should not be used for any purpose.</p> </note> <p>For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-copy-snapshot.html">Copying an Amazon EBS Snapshot</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'CreateCustomerGateway' => '<p>Provides information to AWS about your VPN customer gateway device. The customer gateway is the appliance at your end of the VPN connection. (The device on the AWS side of the VPN connection is the virtual private gateway.) You must provide the Internet-routable IP address of the customer gateway\'s external interface. The IP address must be static and may be behind a device performing network address translation (NAT).</p> <p>For devices that use Border Gateway Protocol (BGP), you can also provide the device\'s BGP Autonomous System Number (ASN). You can use an existing ASN assigned to your network. If you don\'t have an ASN already, you can use a private ASN (in the 64512 - 65534 range).</p> <note> <p>Amazon EC2 supports all 2-byte ASN numbers in the range of 1 - 65534, with the exception of 7224, which is reserved in the <code>us-east-1</code> region, and 9059, which is reserved in the <code>eu-west-1</code> region.</p> </note> <p>For more information about VPN customer gateways, see <a href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_VPN.html">Adding a Hardware Virtual Private Gateway to Your VPC</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p> <important> <p>You cannot create more than one customer gateway with the same VPN type, IP address, and BGP ASN parameter values. If you run an identical request more than one time, the first request creates the customer gateway, and subsequent requests return information about the existing customer gateway. The subsequent requests do not create new customer gateway resources.</p> </important>', 'CreateDhcpOptions' => '<p>Creates a set of DHCP options for your VPC. After creating the set, you must associate it with the VPC, causing all existing and new instances that you launch in the VPC to use this set of DHCP options. The following are the individual DHCP options you can specify. For more information about the options, see <a href="http://www.ietf.org/rfc/rfc2132.txt">RFC 2132</a>.</p> <ul> <li> <p> <code>domain-name-servers</code> - The IP addresses of up to four domain name servers, or AmazonProvidedDNS. The default DHCP option set specifies AmazonProvidedDNS. If specifying more than one domain name server, specify the IP addresses in a single parameter, separated by commas. If you want your instance to receive a custom DNS hostname as specified in <code>domain-name</code>, you must set <code>domain-name-servers</code> to a custom DNS server.</p> </li> <li> <p> <code>domain-name</code> - If you\'re using AmazonProvidedDNS in "us-east-1", specify "ec2.internal". If you\'re using AmazonProvidedDNS in another region, specify "region.compute.internal" (for example, "ap-northeast-1.compute.internal"). Otherwise, specify a domain name (for example, "MyCompany.com"). This value is used to complete unqualified DNS hostnames. <b>Important</b>: Some Linux operating systems accept multiple domain names separated by spaces. However, Windows and other Linux operating systems treat the value as a single domain, which results in unexpected behavior. If your DHCP options set is associated with a VPC that has instances with multiple operating systems, specify only one domain name.</p> </li> <li> <p> <code>ntp-servers</code> - The IP addresses of up to four Network Time Protocol (NTP) servers.</p> </li> <li> <p> <code>netbios-name-servers</code> - The IP addresses of up to four NetBIOS name servers.</p> </li> <li> <p> <code>netbios-node-type</code> - The NetBIOS node type (1, 2, 4, or 8). We recommend that you specify 2 (broadcast and multicast are not currently supported). For more information about these node types, see <a href="http://www.ietf.org/rfc/rfc2132.txt">RFC 2132</a>.</p> </li> </ul> <p>Your VPC automatically starts out with a set of DHCP options that includes only a DNS server that we provide (AmazonProvidedDNS). If you create a set of options, and if your VPC has an Internet gateway, make sure to set the <code>domain-name-servers</code> option either to <code>AmazonProvidedDNS</code> or to a domain name server of your choice. For more information about DHCP options, see <a href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_DHCP_Options.html">DHCP Options Sets</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'CreateFlowLogs' => '<p>Creates one or more flow logs to capture IP traffic for a specific network interface, subnet, or VPC. Flow logs are delivered to a specified log group in Amazon CloudWatch Logs. If you specify a VPC or subnet in the request, a log stream is created in CloudWatch Logs for each network interface in the subnet or VPC. Log streams can include information about accepted and rejected traffic to a network interface. You can view the data in your log streams using Amazon CloudWatch Logs.</p> <p>In your request, you must also specify an IAM role that has permission to publish logs to CloudWatch Logs.</p>', 'CreateImage' => '<p>Creates an Amazon EBS-backed AMI from an Amazon EBS-backed instance that is either running or stopped.</p> <p>If you customized your instance with instance store volumes or EBS volumes in addition to the root device volume, the new AMI contains block device mapping information for those volumes. When you launch an instance from this new AMI, the instance automatically launches with those additional volumes.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami-ebs.html">Creating Amazon EBS-Backed Linux AMIs</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'CreateInstanceExportTask' => '<p>Exports a running or stopped instance to an S3 bucket.</p> <p>For information about the supported operating systems, image formats, and known limitations for the types of instances you can export, see <a href="http://docs.aws.amazon.com/vm-import/latest/userguide/vmexport.html">Exporting an Instance as a VM Using VM Import/Export</a> in the <i>VM Import/Export User Guide</i>.</p>', 'CreateInternetGateway' => '<p>Creates an Internet gateway for use with a VPC. After creating the Internet gateway, you attach it to a VPC using <a>AttachInternetGateway</a>.</p> <p>For more information about your VPC and Internet gateway, see the <a href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/">Amazon Virtual Private Cloud User Guide</a>.</p>', 'CreateKeyPair' => '<p>Creates a 2048-bit RSA key pair with the specified name. Amazon EC2 stores the public key and displays the private key for you to save to a file. The private key is returned as an unencrypted PEM encoded PKCS#8 private key. If a key with the specified name already exists, Amazon EC2 returns an error.</p> <p>You can have up to five thousand key pairs per region.</p> <p>The key pair returned to you is available only in the region in which you create it. To create a key pair that is available in all regions, use <a>ImportKeyPair</a>.</p> <p>For more information about key pairs, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Key Pairs</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'CreateNatGateway' => '<p>Creates a NAT gateway in the specified subnet. A NAT gateway can be used to enable instances in a private subnet to connect to the Internet. This action creates a network interface in the specified subnet with a private IP address from the IP address range of the subnet. For more information, see <a href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/vpc-nat-gateway.html">NAT Gateways</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'CreateNetworkAcl' => '<p>Creates a network ACL in a VPC. Network ACLs provide an optional layer of security (in addition to security groups) for the instances in your VPC.</p> <p>For more information about network ACLs, see <a href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_ACLs.html">Network ACLs</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'CreateNetworkAclEntry' => '<p>Creates an entry (a rule) in a network ACL with the specified rule number. Each network ACL has a set of numbered ingress rules and a separate set of numbered egress rules. When determining whether a packet should be allowed in or out of a subnet associated with the ACL, we process the entries in the ACL according to the rule numbers, in ascending order. Each network ACL has a set of ingress rules and a separate set of egress rules.</p> <p>We recommend that you leave room between the rule numbers (for example, 100, 110, 120, ...), and not number them one right after the other (for example, 101, 102, 103, ...). This makes it easier to add a rule between existing ones without having to renumber the rules.</p> <p>After you add an entry, you can\'t modify it; you must either replace it, or create an entry and delete the old one.</p> <p>For more information about network ACLs, see <a href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_ACLs.html">Network ACLs</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'CreateNetworkInterface' => '<p>Creates a network interface in the specified subnet.</p> <p>For more information about network interfaces, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html">Elastic Network Interfaces</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'CreatePlacementGroup' => '<p>Creates a placement group that you launch cluster instances into. You must give the group a name that\'s unique within the scope of your account.</p> <p>For more information about placement groups and cluster instances, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using_cluster_computing.html">Cluster Instances</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'CreateReservedInstancesListing' => '<p>Creates a listing for Amazon EC2 Standard Reserved Instances to be sold in the Reserved Instance Marketplace. You can submit one Standard Reserved Instance listing at a time. To get a list of your Standard Reserved Instances, you can use the <a>DescribeReservedInstances</a> operation.</p> <p>The Reserved Instance Marketplace matches sellers who want to resell Standard Reserved Instance capacity that they no longer need with buyers who want to purchase additional capacity. Reserved Instances bought and sold through the Reserved Instance Marketplace work like any other Reserved Instances.</p> <p>To sell your Standard Reserved Instances, you must first register as a seller in the Reserved Instance Marketplace. After completing the registration process, you can create a Reserved Instance Marketplace listing of some or all of your Standard Reserved Instances, and specify the upfront price to receive for them. Your Standard Reserved Instance listings then become available for purchase. To view the details of your Standard Reserved Instance listing, you can use the <a>DescribeReservedInstancesListings</a> operation.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Reserved Instance Marketplace</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'CreateRoute' => '<p>Creates a route in a route table within a VPC.</p> <p>You must specify one of the following targets: Internet gateway or virtual private gateway, NAT instance, NAT gateway, VPC peering connection, or network interface.</p> <p>When determining how to route traffic, we use the route with the most specific match. For example, let\'s say the traffic is destined for <code>192.0.2.3</code>, and the route table includes the following two routes:</p> <ul> <li> <p> <code>192.0.2.0/24</code> (goes to some target A)</p> </li> <li> <p> <code>192.0.2.0/28</code> (goes to some target B)</p> </li> </ul> <p>Both routes apply to the traffic destined for <code>192.0.2.3</code>. However, the second route in the list covers a smaller number of IP addresses and is therefore more specific, so we use that route to determine where to target the traffic.</p> <p>For more information about route tables, see <a href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Route_Tables.html">Route Tables</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'CreateRouteTable' => '<p>Creates a route table for the specified VPC. After you create a route table, you can add routes and associate the table with a subnet.</p> <p>For more information about route tables, see <a href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Route_Tables.html">Route Tables</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'CreateSecurityGroup' => '<p>Creates a security group.</p> <p>A security group is for use with instances either in the EC2-Classic platform or in a specific VPC. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html">Amazon EC2 Security Groups</a> in the <i>Amazon Elastic Compute Cloud User Guide</i> and <a href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html">Security Groups for Your VPC</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p> <important> <p>EC2-Classic: You can have up to 500 security groups.</p> <p>EC2-VPC: You can create up to 500 security groups per VPC.</p> </important> <p>When you create a security group, you specify a friendly name of your choice. You can have a security group for use in EC2-Classic with the same name as a security group for use in a VPC. However, you can\'t have two security groups for use in EC2-Classic with the same name or two security groups for use in a VPC with the same name.</p> <p>You have a default security group for use in EC2-Classic and a default security group for use in your VPC. If you don\'t specify a security group when you launch an instance, the instance is launched into the appropriate default security group. A default security group includes a default rule that grants instances unrestricted network access to each other.</p> <p>You can add or remove rules from your security groups using <a>AuthorizeSecurityGroupIngress</a>, <a>AuthorizeSecurityGroupEgress</a>, <a>RevokeSecurityGroupIngress</a>, and <a>RevokeSecurityGroupEgress</a>.</p>', 'CreateSnapshot' => '<p>Creates a snapshot of an EBS volume and stores it in Amazon S3. You can use snapshots for backups, to make copies of EBS volumes, and to save data before shutting down an instance.</p> <p>When a snapshot is created, any AWS Marketplace product codes that are associated with the source volume are propagated to the snapshot.</p> <p>You can take a snapshot of an attached volume that is in use. However, snapshots only capture data that has been written to your EBS volume at the time the snapshot command is issued; this may exclude any data that has been cached by any applications or the operating system. If you can pause any file systems on the volume long enough to take a snapshot, your snapshot should be complete. However, if you cannot pause all file writes to the volume, you should unmount the volume from within the instance, issue the snapshot command, and then remount the volume to ensure a consistent and complete snapshot. You may remount and use your volume while the snapshot status is <code>pending</code>.</p> <p>To create a snapshot for EBS volumes that serve as root devices, you should stop the instance before taking the snapshot.</p> <p>Snapshots that are taken from encrypted volumes are automatically encrypted. Volumes that are created from encrypted snapshots are also automatically encrypted. Your encrypted volumes and any associated snapshots always remain protected.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/AmazonEBS.html">Amazon Elastic Block Store</a> and <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'CreateSpotDatafeedSubscription' => '<p>Creates a data feed for Spot instances, enabling you to view Spot instance usage logs. You can create one data feed per AWS account. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-data-feeds.html">Spot Instance Data Feed</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'CreateSubnet' => '<p>Creates a subnet in an existing VPC.</p> <p>When you create each subnet, you provide the VPC ID and the CIDR block you want for the subnet. After you create a subnet, you can\'t change its CIDR block. The subnet\'s CIDR block can be the same as the VPC\'s CIDR block (assuming you want only a single subnet in the VPC), or a subset of the VPC\'s CIDR block. If you create more than one subnet in a VPC, the subnets\' CIDR blocks must not overlap. The smallest subnet (and VPC) you can create uses a /28 netmask (16 IP addresses), and the largest uses a /16 netmask (65,536 IP addresses).</p> <important> <p>AWS reserves both the first four and the last IP address in each subnet\'s CIDR block. They\'re not available for use.</p> </important> <p>If you add more than one subnet to a VPC, they\'re set up in a star topology with a logical router in the middle.</p> <p>If you launch an instance in a VPC using an Amazon EBS-backed AMI, the IP address doesn\'t change if you stop and restart the instance (unlike a similar instance launched outside a VPC, which gets a new IP address when restarted). It\'s therefore possible to have a subnet with no running instances (they\'re all stopped), but no remaining IP addresses available.</p> <p>For more information about subnets, see <a href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Subnets.html">Your VPC and Subnets</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'CreateTags' => '<p>Adds or overwrites one or more tags for the specified Amazon EC2 resource or resources. Each resource can have a maximum of 50 tags. Each tag consists of a key and optional value. Tag keys must be unique per resource.</p> <p>For more information about tags, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tagging Your Resources</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. For more information about creating IAM policies that control users\' access to resources based on tags, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-iam-actions-resources.html">Supported Resource-Level Permissions for Amazon EC2 API Actions</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'CreateVolume' => '<p>Creates an EBS volume that can be attached to an instance in the same Availability Zone. The volume is created in the regional endpoint that you send the HTTP request to. For more information see <a href="http://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.</p> <p>You can create a new empty volume or restore a volume from an EBS snapshot. Any AWS Marketplace product codes from the snapshot are propagated to the volume.</p> <p>You can create encrypted volumes with the <code>Encrypted</code> parameter. Encrypted volumes may only be attached to instances that support Amazon EBS encryption. Volumes that are created from encrypted snapshots are also automatically encrypted. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-creating-volume.html">Creating or Restoring an Amazon EBS Volume</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'CreateVpc' => '<p>Creates a VPC with the specified CIDR block.</p> <p>The smallest VPC you can create uses a /28 netmask (16 IP addresses), and the largest uses a /16 netmask (65,536 IP addresses). To help you decide how big to make your VPC, see <a href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Subnets.html">Your VPC and Subnets</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p> <p>By default, each instance you launch in the VPC has the default DHCP options, which includes only a default DNS server that we provide (AmazonProvidedDNS). For more information about DHCP options, see <a href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_DHCP_Options.html">DHCP Options Sets</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p> <p>You can specify the instance tenancy value for the VPC when you create it. You can\'t change this value for the VPC after you create it. For more information, see <a href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/dedicated-instance.html.html">Dedicated Instances</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'CreateVpcEndpoint' => '<p>Creates a VPC endpoint for a specified AWS service. An endpoint enables you to create a private connection between your VPC and another AWS service in your account. You can specify an endpoint policy to attach to the endpoint that will control access to the service from your VPC. You can also specify the VPC route tables that use the endpoint.</p> <p>Currently, only endpoints to Amazon S3 are supported.</p>', 'CreateVpcPeeringConnection' => '<p>Requests a VPC peering connection between two VPCs: a requester VPC that you own and a peer VPC with which to create the connection. The peer VPC can belong to another AWS account. The requester VPC and peer VPC cannot have overlapping CIDR blocks.</p> <p>The owner of the peer VPC must accept the peering request to activate the peering connection. The VPC peering connection request expires after 7 days, after which it cannot be accepted or rejected.</p> <p>A <code>CreateVpcPeeringConnection</code> request between VPCs with overlapping CIDR blocks results in the VPC peering connection having a status of <code>failed</code>.</p>', 'CreateVpnConnection' => '<p>Creates a VPN connection between an existing virtual private gateway and a VPN customer gateway. The only supported connection type is <code>ipsec.1</code>.</p> <p>The response includes information that you need to give to your network administrator to configure your customer gateway.</p> <important> <p>We strongly recommend that you use HTTPS when calling this operation because the response contains sensitive cryptographic information for configuring your customer gateway.</p> </important> <p>If you decide to shut down your VPN connection for any reason and later create a new VPN connection, you must reconfigure your customer gateway with the new information returned from this call.</p> <p>This is an idempotent operation. If you perform the operation more than once, Amazon EC2 doesn\'t return an error.</p> <p>For more information about VPN connections, see <a href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_VPN.html">Adding a Hardware Virtual Private Gateway to Your VPC</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'CreateVpnConnectionRoute' => '<p>Creates a static route associated with a VPN connection between an existing virtual private gateway and a VPN customer gateway. The static route allows traffic to be routed from the virtual private gateway to the VPN customer gateway.</p> <p>For more information about VPN connections, see <a href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_VPN.html">Adding a Hardware Virtual Private Gateway to Your VPC</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'CreateVpnGateway' => '<p>Creates a virtual private gateway. A virtual private gateway is the endpoint on the VPC side of your VPN connection. You can create a virtual private gateway before creating the VPC itself.</p> <p>For more information about virtual private gateways, see <a href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_VPN.html">Adding a Hardware Virtual Private Gateway to Your VPC</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'DeleteCustomerGateway' => '<p>Deletes the specified customer gateway. You must delete the VPN connection before you can delete the customer gateway.</p>', 'DeleteDhcpOptions' => '<p>Deletes the specified set of DHCP options. You must disassociate the set of DHCP options before you can delete it. You can disassociate the set of DHCP options by associating either a new set of options or the default set of options with the VPC.</p>', 'DeleteFlowLogs' => '<p>Deletes one or more flow logs.</p>', 'DeleteInternetGateway' => '<p>Deletes the specified Internet gateway. You must detach the Internet gateway from the VPC before you can delete it.</p>', 'DeleteKeyPair' => '<p>Deletes the specified key pair, by removing the public key from Amazon EC2.</p>', 'DeleteNatGateway' => '<p>Deletes the specified NAT gateway. Deleting a NAT gateway disassociates its Elastic IP address, but does not release the address from your account. Deleting a NAT gateway does not delete any NAT gateway routes in your route tables.</p>', 'DeleteNetworkAcl' => '<p>Deletes the specified network ACL. You can\'t delete the ACL if it\'s associated with any subnets. You can\'t delete the default network ACL.</p>', 'DeleteNetworkAclEntry' => '<p>Deletes the specified ingress or egress entry (rule) from the specified network ACL.</p>', 'DeleteNetworkInterface' => '<p>Deletes the specified network interface. You must detach the network interface before you can delete it.</p>', 'DeletePlacementGroup' => '<p>Deletes the specified placement group. You must terminate all instances in the placement group before you can delete the placement group. For more information about placement groups and cluster instances, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using_cluster_computing.html">Cluster Instances</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'DeleteRoute' => '<p>Deletes the specified route from the specified route table.</p>', 'DeleteRouteTable' => '<p>Deletes the specified route table. You must disassociate the route table from any subnets before you can delete it. You can\'t delete the main route table.</p>', 'DeleteSecurityGroup' => '<p>Deletes a security group.</p> <p>If you attempt to delete a security group that is associated with an instance, or is referenced by another security group, the operation fails with <code>InvalidGroup.InUse</code> in EC2-Classic or <code>DependencyViolation</code> in EC2-VPC.</p>', 'DeleteSnapshot' => '<p>Deletes the specified snapshot.</p> <p>When you make periodic snapshots of a volume, the snapshots are incremental, and only the blocks on the device that have changed since your last snapshot are saved in the new snapshot. When you delete a snapshot, only the data not needed for any other snapshot is removed. So regardless of which prior snapshots have been deleted, all active snapshots will have access to all the information needed to restore the volume.</p> <p>You cannot delete a snapshot of the root device of an EBS volume used by a registered AMI. You must first de-register the AMI before you can delete the snapshot.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-deleting-snapshot.html">Deleting an Amazon EBS Snapshot</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'DeleteSpotDatafeedSubscription' => '<p>Deletes the data feed for Spot instances.</p>', 'DeleteSubnet' => '<p>Deletes the specified subnet. You must terminate all running instances in the subnet before you can delete the subnet.</p>', 'DeleteTags' => '<p>Deletes the specified set of tags from the specified set of resources. This call is designed to follow a <code>DescribeTags</code> request.</p> <p>For more information about tags, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tagging Your Resources</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'DeleteVolume' => '<p>Deletes the specified EBS volume. The volume must be in the <code>available</code> state (not attached to an instance).</p> <note> <p>The volume may remain in the <code>deleting</code> state for several minutes.</p> </note> <p>For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-deleting-volume.html">Deleting an Amazon EBS Volume</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'DeleteVpc' => '<p>Deletes the specified VPC. You must detach or delete all gateways and resources that are associated with the VPC before you can delete it. For example, you must terminate all instances running in the VPC, delete all security groups associated with the VPC (except the default one), delete all route tables associated with the VPC (except the default one), and so on.</p>', 'DeleteVpcEndpoints' => '<p>Deletes one or more specified VPC endpoints. Deleting the endpoint also deletes the endpoint routes in the route tables that were associated with the endpoint.</p>', 'DeleteVpcPeeringConnection' => '<p>Deletes a VPC peering connection. Either the owner of the requester VPC or the owner of the peer VPC can delete the VPC peering connection if it\'s in the <code>active</code> state. The owner of the requester VPC can delete a VPC peering connection in the <code>pending-acceptance</code> state. </p>', 'DeleteVpnConnection' => '<p>Deletes the specified VPN connection.</p> <p>If you\'re deleting the VPC and its associated components, we recommend that you detach the virtual private gateway from the VPC and delete the VPC before deleting the VPN connection. If you believe that the tunnel credentials for your VPN connection have been compromised, you can delete the VPN connection and create a new one that has new keys, without needing to delete the VPC or virtual private gateway. If you create a new VPN connection, you must reconfigure the customer gateway using the new configuration information returned with the new VPN connection ID.</p>', 'DeleteVpnConnectionRoute' => '<p>Deletes the specified static route associated with a VPN connection between an existing virtual private gateway and a VPN customer gateway. The static route allows traffic to be routed from the virtual private gateway to the VPN customer gateway.</p>', 'DeleteVpnGateway' => '<p>Deletes the specified virtual private gateway. We recommend that before you delete a virtual private gateway, you detach it from the VPC and delete the VPN connection. Note that you don\'t need to delete the virtual private gateway if you plan to delete and recreate the VPN connection between your VPC and your network.</p>', 'DeregisterImage' => '<p>Deregisters the specified AMI. After you deregister an AMI, it can\'t be used to launch new instances.</p> <p>This command does not delete the AMI.</p>', 'DescribeAccountAttributes' => '<p>Describes attributes of your AWS account. The following are the supported account attributes:</p> <ul> <li> <p> <code>supported-platforms</code>: Indicates whether your account can launch instances into EC2-Classic and EC2-VPC, or only into EC2-VPC.</p> </li> <li> <p> <code>default-vpc</code>: The ID of the default VPC for your account, or <code>none</code>.</p> </li> <li> <p> <code>max-instances</code>: The maximum number of On-Demand instances that you can run.</p> </li> <li> <p> <code>vpc-max-security-groups-per-interface</code>: The maximum number of security groups that you can assign to a network interface.</p> </li> <li> <p> <code>max-elastic-ips</code>: The maximum number of Elastic IP addresses that you can allocate for use with EC2-Classic. </p> </li> <li> <p> <code>vpc-max-elastic-ips</code>: The maximum number of Elastic IP addresses that you can allocate for use with EC2-VPC.</p> </li> </ul>', 'DescribeAddresses' => '<p>Describes one or more of your Elastic IP addresses.</p> <p>An Elastic IP address is for use in either the EC2-Classic platform or in a VPC. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'DescribeAvailabilityZones' => '<p>Describes one or more of the Availability Zones that are available to you. The results include zones only for the region you\'re currently using. If there is an event impacting an Availability Zone, you can use this request to view the state and any provided message for that Availability Zone.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html">Regions and Availability Zones</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'DescribeBundleTasks' => '<p>Describes one or more of your bundling tasks.</p> <note> <p>Completed bundle tasks are listed for only a limited time. If your bundle task is no longer in the list, you can still register an AMI from it. Just use <code>RegisterImage</code> with the Amazon S3 bucket name and image manifest name you provided to the bundle task.</p> </note>', 'DescribeClassicLinkInstances' => '<p>Describes one or more of your linked EC2-Classic instances. This request only returns information about EC2-Classic instances linked to a VPC through ClassicLink; you cannot use this request to return information about other instances.</p>', 'DescribeConversionTasks' => '<p>Describes one or more of your conversion tasks. For more information, see the <a href="http://docs.aws.amazon.com/vm-import/latest/userguide/">VM Import/Export User Guide</a>.</p> <p>For information about the import manifest referenced by this API action, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html">VM Import Manifest</a>.</p>', 'DescribeCustomerGateways' => '<p>Describes one or more of your VPN customer gateways.</p> <p>For more information about VPN customer gateways, see <a href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_VPN.html">Adding a Hardware Virtual Private Gateway to Your VPC</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'DescribeDhcpOptions' => '<p>Describes one or more of your DHCP options sets.</p> <p>For more information about DHCP options sets, see <a href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_DHCP_Options.html">DHCP Options Sets</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'DescribeExportTasks' => '<p>Describes one or more of your export tasks.</p>', 'DescribeFlowLogs' => '<p>Describes one or more flow logs. To view the information in your flow logs (the log streams for the network interfaces), you must use the CloudWatch Logs console or the CloudWatch Logs API.</p>', 'DescribeHostReservationOfferings' => '<p>Describes the Dedicated Host Reservations that are available to purchase.</p> <p>The results describe all the Dedicated Host Reservation offerings, including offerings that may not match the instance family and region of your Dedicated Hosts. When purchasing an offering, ensure that the the instance family and region of the offering matches that of the Dedicated Host/s it will be associated with. For an overview of supported instance types, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-overview.html">Dedicated Hosts Overview</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. </p>', 'DescribeHostReservations' => '<p>Describes Dedicated Host Reservations which are associated with Dedicated Hosts in your account.</p>', 'DescribeHosts' => '<p>Describes one or more of your Dedicated Hosts.</p> <p>The results describe only the Dedicated Hosts in the region you\'re currently using. All listed instances consume capacity on your Dedicated Host. Dedicated Hosts that have recently been released will be listed with the state <code>released</code>.</p>', 'DescribeIdFormat' => '<p>Describes the ID format settings for your resources on a per-region basis, for example, to view which resource types are enabled for longer IDs. This request only returns information about resource types whose ID formats can be modified; it does not return information about other resource types.</p> <p>The following resource types support longer IDs: <code>instance</code> | <code>reservation</code> | <code>snapshot</code> | <code>volume</code>. </p> <p>These settings apply to the IAM user who makes the request; they do not apply to the entire AWS account. By default, an IAM user defaults to the same settings as the root user, unless they explicitly override the settings by running the <a>ModifyIdFormat</a> command. Resources created with longer IDs are visible to all IAM users, regardless of these settings and provided that they have permission to use the relevant <code>Describe</code> command for the resource type.</p>', 'DescribeIdentityIdFormat' => '<p>Describes the ID format settings for resources for the specified IAM user, IAM role, or root user. For example, you can view the resource types that are enabled for longer IDs. This request only returns information about resource types whose ID formats can be modified; it does not return information about other resource types. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/resource-ids.html">Resource IDs</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. </p> <p>The following resource types support longer IDs: <code>instance</code> | <code>reservation</code> | <code>snapshot</code> | <code>volume</code>. </p> <p>These settings apply to the principal specified in the request. They do not apply to the principal that makes the request.</p>', 'DescribeImageAttribute' => '<p>Describes the specified attribute of the specified AMI. You can specify only one attribute at a time.</p>', 'DescribeImages' => '<p>Describes one or more of the images (AMIs, AKIs, and ARIs) available to you. Images available to you include public images, private images that you own, and private images owned by other AWS accounts but for which you have explicit launch permissions.</p> <note> <p>Deregistered images are included in the returned results for an unspecified interval after deregistration.</p> </note>', 'DescribeImportImageTasks' => '<p>Displays details about an import virtual machine or import snapshot tasks that are already created.</p>', 'DescribeImportSnapshotTasks' => '<p>Describes your import snapshot tasks.</p>', 'DescribeInstanceAttribute' => '<p>Describes the specified attribute of the specified instance. You can specify only one attribute at a time. Valid attribute values are: <code>instanceType</code> | <code>kernel</code> | <code>ramdisk</code> | <code>userData</code> | <code>disableApiTermination</code> | <code>instanceInitiatedShutdownBehavior</code> | <code>rootDeviceName</code> | <code>blockDeviceMapping</code> | <code>productCodes</code> | <code>sourceDestCheck</code> | <code>groupSet</code> | <code>ebsOptimized</code> | <code>sriovNetSupport</code> </p>', 'DescribeInstanceStatus' => '<p>Describes the status of one or more instances. By default, only running instances are described, unless specified otherwise.</p> <p>Instance status includes the following components:</p> <ul> <li> <p> <b>Status checks</b> - Amazon EC2 performs status checks on running EC2 instances to identify hardware and software issues. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-system-instance-status-check.html">Status Checks for Your Instances</a> and <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/TroubleshootingInstances.html">Troubleshooting Instances with Failed Status Checks</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> </li> <li> <p> <b>Scheduled events</b> - Amazon EC2 can schedule events (such as reboot, stop, or terminate) for your instances related to hardware issues, software updates, or system maintenance. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-instances-status-check_sched.html">Scheduled Events for Your Instances</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> </li> <li> <p> <b>Instance state</b> - You can manage your instances from the moment you launch them through their termination. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-lifecycle.html">Instance Lifecycle</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> </li> </ul>', 'DescribeInstances' => '<p>Describes one or more of your instances.</p> <p>If you specify one or more instance IDs, Amazon EC2 returns information for those instances. If you do not specify instance IDs, Amazon EC2 returns information for all relevant instances. If you specify an instance ID that is not valid, an error is returned. If you specify an instance that you do not own, it is not included in the returned results.</p> <p>Recently terminated instances might appear in the returned results. This interval is usually less than one hour.</p> <p>If you describe instances in the rare case where an Availability Zone is experiencing a service disruption and you specify instance IDs that are in the affected zone, or do not specify any instance IDs at all, the call fails. If you describe instances and specify only instance IDs that are in an unaffected zone, the call works normally.</p>', 'DescribeInternetGateways' => '<p>Describes one or more of your Internet gateways.</p>', 'DescribeKeyPairs' => '<p>Describes one or more of your key pairs.</p> <p>For more information about key pairs, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Key Pairs</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'DescribeMovingAddresses' => '<p>Describes your Elastic IP addresses that are being moved to the EC2-VPC platform, or that are being restored to the EC2-Classic platform. This request does not return information about any other Elastic IP addresses in your account.</p>', 'DescribeNatGateways' => '<p>Describes one or more of the your NAT gateways.</p>', 'DescribeNetworkAcls' => '<p>Describes one or more of your network ACLs.</p> <p>For more information about network ACLs, see <a href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_ACLs.html">Network ACLs</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'DescribeNetworkInterfaceAttribute' => '<p>Describes a network interface attribute. You can specify only one attribute at a time.</p>', 'DescribeNetworkInterfaces' => '<p>Describes one or more of your network interfaces.</p>', 'DescribePlacementGroups' => '<p>Describes one or more of your placement groups. For more information about placement groups and cluster instances, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using_cluster_computing.html">Cluster Instances</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'DescribePrefixLists' => '<p>Describes available AWS services in a prefix list format, which includes the prefix list name and prefix list ID of the service and the IP address range for the service. A prefix list ID is required for creating an outbound security group rule that allows traffic from a VPC to access an AWS service through a VPC endpoint.</p>', 'DescribeRegions' => '<p>Describes one or more regions that are currently available to you.</p> <p>For a list of the regions supported by Amazon EC2, see <a href="http://docs.aws.amazon.com/general/latest/gr/rande.html#ec2_region">Regions and Endpoints</a>.</p>', 'DescribeReservedInstances' => '<p>Describes one or more of the Reserved Instances that you purchased.</p> <p>For more information about Reserved Instances, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/concepts-on-demand-reserved-instances.html">Reserved Instances</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'DescribeReservedInstancesListings' => '<p>Describes your account\'s Reserved Instance listings in the Reserved Instance Marketplace.</p> <p>The Reserved Instance Marketplace matches sellers who want to resell Reserved Instance capacity that they no longer need with buyers who want to purchase additional capacity. Reserved Instances bought and sold through the Reserved Instance Marketplace work like any other Reserved Instances.</p> <p>As a seller, you choose to list some or all of your Reserved Instances, and you specify the upfront price to receive for them. Your Reserved Instances are then listed in the Reserved Instance Marketplace and are available for purchase.</p> <p>As a buyer, you specify the configuration of the Reserved Instance to purchase, and the Marketplace matches what you\'re searching for with what\'s available. The Marketplace first sells the lowest priced Reserved Instances to you, and continues to sell available Reserved Instance listings to you until your demand is met. You are charged based on the total price of all of the listings that you purchase.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Reserved Instance Marketplace</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'DescribeReservedInstancesModifications' => '<p>Describes the modifications made to your Reserved Instances. If no parameter is specified, information about all your Reserved Instances modification requests is returned. If a modification ID is specified, only information about the specific modification is returned.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-modifying.html">Modifying Reserved Instances</a> in the Amazon Elastic Compute Cloud User Guide.</p>', 'DescribeReservedInstancesOfferings' => '<p>Describes Reserved Instance offerings that are available for purchase. With Reserved Instances, you purchase the right to launch instances for a period of time. During that time period, you do not receive insufficient capacity errors, and you pay a lower usage rate than the rate charged for On-Demand instances for the actual time used.</p> <p>If you have listed your own Reserved Instances for sale in the Reserved Instance Marketplace, they will be excluded from these results. This is to ensure that you do not purchase your own Reserved Instances.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Reserved Instance Marketplace</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'DescribeRouteTables' => '<p>Describes one or more of your route tables.</p> <p>Each subnet in your VPC must be associated with a route table. If a subnet is not explicitly associated with any route table, it is implicitly associated with the main route table. This command does not return the subnet ID for implicit associations.</p> <p>For more information about route tables, see <a href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Route_Tables.html">Route Tables</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'DescribeScheduledInstanceAvailability' => '<p>Finds available schedules that meet the specified criteria.</p> <p>You can search for an available schedule no more than 3 months in advance. You must meet the minimum required duration of 1,200 hours per year. For example, the minimum daily schedule is 4 hours, the minimum weekly schedule is 24 hours, and the minimum monthly schedule is 100 hours.</p> <p>After you find a schedule that meets your needs, call <a>PurchaseScheduledInstances</a> to purchase Scheduled Instances with that schedule.</p>', 'DescribeScheduledInstances' => '<p>Describes one or more of your Scheduled Instances.</p>', 'DescribeSecurityGroupReferences' => '<p>[EC2-VPC only] Describes the VPCs on the other side of a VPC peering connection that are referencing the security groups you\'ve specified in this request.</p>', 'DescribeSecurityGroups' => '<p>Describes one or more of your security groups.</p> <p>A security group is for use with instances either in the EC2-Classic platform or in a specific VPC. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html">Amazon EC2 Security Groups</a> in the <i>Amazon Elastic Compute Cloud User Guide</i> and <a href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html">Security Groups for Your VPC</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'DescribeSnapshotAttribute' => '<p>Describes the specified attribute of the specified snapshot. You can specify only one attribute at a time.</p> <p>For more information about EBS snapshots, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSSnapshots.html">Amazon EBS Snapshots</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'DescribeSnapshots' => '<p>Describes one or more of the EBS snapshots available to you. Available snapshots include public snapshots available for any AWS account to launch, private snapshots that you own, and private snapshots owned by another AWS account but for which you\'ve been given explicit create volume permissions.</p> <p>The create volume permissions fall into the following categories:</p> <ul> <li> <p> <i>public</i>: The owner of the snapshot granted create volume permissions for the snapshot to the <code>all</code> group. All AWS accounts have create volume permissions for these snapshots.</p> </li> <li> <p> <i>explicit</i>: The owner of the snapshot granted create volume permissions to a specific AWS account.</p> </li> <li> <p> <i>implicit</i>: An AWS account has implicit create volume permissions for all snapshots it owns.</p> </li> </ul> <p>The list of snapshots returned can be modified by specifying snapshot IDs, snapshot owners, or AWS accounts with create volume permissions. If no options are specified, Amazon EC2 returns all snapshots for which you have create volume permissions.</p> <p>If you specify one or more snapshot IDs, only snapshots that have the specified IDs are returned. If you specify an invalid snapshot ID, an error is returned. If you specify a snapshot ID for which you do not have access, it is not included in the returned results.</p> <p>If you specify one or more snapshot owners using the <code>OwnerIds</code> option, only snapshots from the specified owners and for which you have access are returned. The results can include the AWS account IDs of the specified owners, <code>amazon</code> for snapshots owned by Amazon, or <code>self</code> for snapshots that you own.</p> <p>If you specify a list of restorable users, only snapshots with create snapshot permissions for those users are returned. You can specify AWS account IDs (if you own the snapshots), <code>self</code> for snapshots for which you own or have explicit permissions, or <code>all</code> for public snapshots.</p> <p>If you are describing a long list of snapshots, you can paginate the output to make the list more manageable. The <code>MaxResults</code> parameter sets the maximum number of results returned in a single page. If the list of results exceeds your <code>MaxResults</code> value, then that number of results is returned along with a <code>NextToken</code> value that can be passed to a subsequent <code>DescribeSnapshots</code> request to retrieve the remaining results.</p> <p>For more information about EBS snapshots, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSSnapshots.html">Amazon EBS Snapshots</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'DescribeSpotDatafeedSubscription' => '<p>Describes the data feed for Spot instances. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-data-feeds.html">Spot Instance Data Feed</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'DescribeSpotFleetInstances' => '<p>Describes the running instances for the specified Spot fleet.</p>', 'DescribeSpotFleetRequestHistory' => '<p>Describes the events for the specified Spot fleet request during the specified time.</p> <p>Spot fleet events are delayed by up to 30 seconds before they can be described. This ensures that you can query by the last evaluated time and not miss a recorded event.</p>', 'DescribeSpotFleetRequests' => '<p>Describes your Spot fleet requests.</p> <p>Spot fleet requests are deleted 48 hours after they are canceled and their instances are terminated.</p>', 'DescribeSpotInstanceRequests' => '<p>Describes the Spot instance requests that belong to your account. Spot instances are instances that Amazon EC2 launches when the bid price that you specify exceeds the current Spot price. Amazon EC2 periodically sets the Spot price based on available Spot instance capacity and current Spot instance requests. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-requests.html">Spot Instance Requests</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <p>You can use <code>DescribeSpotInstanceRequests</code> to find a running Spot instance by examining the response. If the status of the Spot instance is <code>fulfilled</code>, the instance ID appears in the response and contains the identifier of the instance. Alternatively, you can use <a>DescribeInstances</a> with a filter to look for instances where the instance lifecycle is <code>spot</code>.</p> <p>Spot instance requests are deleted 4 hours after they are canceled and their instances are terminated.</p>', 'DescribeSpotPriceHistory' => '<p>Describes the Spot price history. The prices returned are listed in chronological order, from the oldest to the most recent, for up to the past 90 days. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-spot-instances-history.html">Spot Instance Pricing History</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <p>When you specify a start and end time, this operation returns the prices of the instance types within the time range that you specified and the time when the price changed. The price is valid within the time period that you specified; the response merely indicates the last time that the price changed.</p>', 'DescribeStaleSecurityGroups' => '<p>[EC2-VPC only] Describes the stale security group rules for security groups in a specified VPC. Rules are stale when they reference a deleted security group in a peer VPC, or a security group in a peer VPC for which the VPC peering connection has been deleted.</p>', 'DescribeSubnets' => '<p>Describes one or more of your subnets.</p> <p>For more information about subnets, see <a href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Subnets.html">Your VPC and Subnets</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'DescribeTags' => '<p>Describes one or more of the tags for your EC2 resources.</p> <p>For more information about tags, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tagging Your Resources</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'DescribeVolumeAttribute' => '<p>Describes the specified attribute of the specified volume. You can specify only one attribute at a time.</p> <p>For more information about EBS volumes, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumes.html">Amazon EBS Volumes</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'DescribeVolumeStatus' => '<p>Describes the status of the specified volumes. Volume status provides the result of the checks performed on your volumes to determine events that can impair the performance of your volumes. The performance of a volume can be affected if an issue occurs on the volume\'s underlying host. If the volume\'s underlying host experiences a power outage or system issue, after the system is restored, there could be data inconsistencies on the volume. Volume events notify you if this occurs. Volume actions notify you if any action needs to be taken in response to the event.</p> <p>The <code>DescribeVolumeStatus</code> operation provides the following information about the specified volumes:</p> <p> <i>Status</i>: Reflects the current status of the volume. The possible values are <code>ok</code>, <code>impaired</code> , <code>warning</code>, or <code>insufficient-data</code>. If all checks pass, the overall status of the volume is <code>ok</code>. If the check fails, the overall status is <code>impaired</code>. If the status is <code>insufficient-data</code>, then the checks may still be taking place on your volume at the time. We recommend that you retry the request. For more information on volume status, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-volume-status.html">Monitoring the Status of Your Volumes</a>.</p> <p> <i>Events</i>: Reflect the cause of a volume status and may require you to take action. For example, if your volume returns an <code>impaired</code> status, then the volume event might be <code>potential-data-inconsistency</code>. This means that your volume has been affected by an issue with the underlying host, has all I/O operations disabled, and may have inconsistent data.</p> <p> <i>Actions</i>: Reflect the actions you may have to take in response to an event. For example, if the status of the volume is <code>impaired</code> and the volume event shows <code>potential-data-inconsistency</code>, then the action shows <code>enable-volume-io</code>. This means that you may want to enable the I/O operations for the volume by calling the <a>EnableVolumeIO</a> action and then check the volume for data consistency.</p> <note> <p>Volume status is based on the volume status checks, and does not reflect the volume state. Therefore, volume status does not indicate volumes in the <code>error</code> state (for example, when a volume is incapable of accepting I/O.)</p> </note>', 'DescribeVolumes' => '<p>Describes the specified EBS volumes.</p> <p>If you are describing a long list of volumes, you can paginate the output to make the list more manageable. The <code>MaxResults</code> parameter sets the maximum number of results returned in a single page. If the list of results exceeds your <code>MaxResults</code> value, then that number of results is returned along with a <code>NextToken</code> value that can be passed to a subsequent <code>DescribeVolumes</code> request to retrieve the remaining results.</p> <p>For more information about EBS volumes, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumes.html">Amazon EBS Volumes</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'DescribeVpcAttribute' => '<p>Describes the specified attribute of the specified VPC. You can specify only one attribute at a time.</p>', 'DescribeVpcClassicLink' => '<p>Describes the ClassicLink status of one or more VPCs.</p>', 'DescribeVpcClassicLinkDnsSupport' => '<p>Describes the ClassicLink DNS support status of one or more VPCs. If enabled, the DNS hostname of a linked EC2-Classic instance resolves to its private IP address when addressed from an instance in the VPC to which it\'s linked. Similarly, the DNS hostname of an instance in a VPC resolves to its private IP address when addressed from a linked EC2-Classic instance. For more information about ClassicLink, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the Amazon Elastic Compute Cloud User Guide.</p>', 'DescribeVpcEndpointServices' => '<p>Describes all supported AWS services that can be specified when creating a VPC endpoint.</p>', 'DescribeVpcEndpoints' => '<p>Describes one or more of your VPC endpoints.</p>', 'DescribeVpcPeeringConnections' => '<p>Describes one or more of your VPC peering connections.</p>', 'DescribeVpcs' => '<p>Describes one or more of your VPCs.</p>', 'DescribeVpnConnections' => '<p>Describes one or more of your VPN connections.</p> <p>For more information about VPN connections, see <a href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_VPN.html">Adding a Hardware Virtual Private Gateway to Your VPC</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'DescribeVpnGateways' => '<p>Describes one or more of your virtual private gateways.</p> <p>For more information about virtual private gateways, see <a href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_VPN.html">Adding an IPsec Hardware VPN to Your VPC</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'DetachClassicLinkVpc' => '<p>Unlinks (detaches) a linked EC2-Classic instance from a VPC. After the instance has been unlinked, the VPC security groups are no longer associated with it. An instance is automatically unlinked from a VPC when it\'s stopped.</p>', 'DetachInternetGateway' => '<p>Detaches an Internet gateway from a VPC, disabling connectivity between the Internet and the VPC. The VPC must not contain any running instances with Elastic IP addresses.</p>', 'DetachNetworkInterface' => '<p>Detaches a network interface from an instance.</p>', 'DetachVolume' => '<p>Detaches an EBS volume from an instance. Make sure to unmount any file systems on the device within your operating system before detaching the volume. Failure to do so can result in the volume becoming stuck in the <code>busy</code> state while detaching. If this happens, detachment can be delayed indefinitely until you unmount the volume, force detachment, reboot the instance, or all three. If an EBS volume is the root device of an instance, it can\'t be detached while the instance is running. To detach the root volume, stop the instance first.</p> <p>When a volume with an AWS Marketplace product code is detached from an instance, the product code is no longer associated with the instance.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-detaching-volume.html">Detaching an Amazon EBS Volume</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'DetachVpnGateway' => '<p>Detaches a virtual private gateway from a VPC. You do this if you\'re planning to turn off the VPC and not use it anymore. You can confirm a virtual private gateway has been completely detached from a VPC by describing the virtual private gateway (any attachments to the virtual private gateway are also described).</p> <p>You must wait for the attachment\'s state to switch to <code>detached</code> before you can delete the VPC or attach a different VPC to the virtual private gateway.</p>', 'DisableVgwRoutePropagation' => '<p>Disables a virtual private gateway (VGW) from propagating routes to a specified route table of a VPC.</p>', 'DisableVpcClassicLink' => '<p>Disables ClassicLink for a VPC. You cannot disable ClassicLink for a VPC that has EC2-Classic instances linked to it.</p>', 'DisableVpcClassicLinkDnsSupport' => '<p>Disables ClassicLink DNS support for a VPC. If disabled, DNS hostnames resolve to public IP addresses when addressed between a linked EC2-Classic instance and instances in the VPC to which it\'s linked. For more information about ClassicLink, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the Amazon Elastic Compute Cloud User Guide.</p>', 'DisassociateAddress' => '<p>Disassociates an Elastic IP address from the instance or network interface it\'s associated with.</p> <p>An Elastic IP address is for use in either the EC2-Classic platform or in a VPC. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <p>This is an idempotent operation. If you perform the operation more than once, Amazon EC2 doesn\'t return an error.</p>', 'DisassociateRouteTable' => '<p>Disassociates a subnet from a route table.</p> <p>After you perform this action, the subnet no longer uses the routes in the route table. Instead, it uses the routes in the VPC\'s main route table. For more information about route tables, see <a href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Route_Tables.html">Route Tables</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'EnableVgwRoutePropagation' => '<p>Enables a virtual private gateway (VGW) to propagate routes to the specified route table of a VPC.</p>', 'EnableVolumeIO' => '<p>Enables I/O operations for a volume that had I/O operations disabled because the data on the volume was potentially inconsistent.</p>', 'EnableVpcClassicLink' => '<p>Enables a VPC for ClassicLink. You can then link EC2-Classic instances to your ClassicLink-enabled VPC to allow communication over private IP addresses. You cannot enable your VPC for ClassicLink if any of your VPC\'s route tables have existing routes for address ranges within the <code>10.0.0.0/8</code> IP address range, excluding local routes for VPCs in the <code>10.0.0.0/16</code> and <code>10.1.0.0/16</code> IP address ranges. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the Amazon Elastic Compute Cloud User Guide.</p>', 'EnableVpcClassicLinkDnsSupport' => '<p>Enables a VPC to support DNS hostname resolution for ClassicLink. If enabled, the DNS hostname of a linked EC2-Classic instance resolves to its private IP address when addressed from an instance in the VPC to which it\'s linked. Similarly, the DNS hostname of an instance in a VPC resolves to its private IP address when addressed from a linked EC2-Classic instance. For more information about ClassicLink, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the Amazon Elastic Compute Cloud User Guide.</p>', 'GetConsoleOutput' => '<p>Gets the console output for the specified instance.</p> <p>Instances do not have a physical monitor through which you can view their console output. They also lack physical controls that allow you to power up, reboot, or shut them down. To allow these actions, we provide them through the Amazon EC2 API and command line interface.</p> <p>Instance console output is buffered and posted shortly after instance boot, reboot, and termination. Amazon EC2 preserves the most recent 64 KB output which is available for at least one hour after the most recent post.</p> <p>For Linux instances, the instance console output displays the exact console output that would normally be displayed on a physical monitor attached to a computer. This output is buffered because the instance produces it and then posts it to a store where the instance\'s owner can retrieve it.</p> <p>For Windows instances, the instance console output includes output from the EC2Config service.</p>', 'GetConsoleScreenshot' => '<p>Retrieve a JPG-format screenshot of a running instance to help with troubleshooting.</p> <p>The returned content is Base64-encoded.</p>', 'GetHostReservationPurchasePreview' => '<p>Preview a reservation purchase with configurations that match those of your Dedicated Host. You must have active Dedicated Hosts in your account before you purchase a reservation.</p> <p>This is a preview of the <a>PurchaseHostReservation</a> action and does not result in the offering being purchased.</p>', 'GetPasswordData' => '<p>Retrieves the encrypted administrator password for an instance running Windows.</p> <p>The Windows password is generated at boot if the <code>EC2Config</code> service plugin, <code>Ec2SetPassword</code>, is enabled. This usually only happens the first time an AMI is launched, and then <code>Ec2SetPassword</code> is automatically disabled. The password is not generated for rebundled AMIs unless <code>Ec2SetPassword</code> is enabled before bundling.</p> <p>The password is encrypted using the key pair that you specified when you launched the instance. You must provide the corresponding key pair file.</p> <p>Password generation and encryption takes a few moments. We recommend that you wait up to 15 minutes after launching an instance before trying to retrieve the generated password.</p>', 'GetReservedInstancesExchangeQuote' => '<p>Returns details about the values and term of your specified Convertible Reserved Instances. When an offering ID is specified it returns information about whether the exchange is valid and can be performed.</p>', 'ImportImage' => '<p>Import single or multi-volume disk images or EBS snapshots into an Amazon Machine Image (AMI). For more information, see <a href="http://docs.aws.amazon.com/vm-import/latest/userguide/vmimport-image-import.html">Importing a VM as an Image Using VM Import/Export</a> in the <i>VM Import/Export User Guide</i>.</p>', 'ImportInstance' => '<p>Creates an import instance task using metadata from the specified disk image. <code>ImportInstance</code> only supports single-volume VMs. To import multi-volume VMs, use <a>ImportImage</a>. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/CommandLineReference/ec2-cli-vmimport-export.html">Importing a Virtual Machine Using the Amazon EC2 CLI</a>.</p> <p>For information about the import manifest referenced by this API action, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html">VM Import Manifest</a>.</p>', 'ImportKeyPair' => '<p>Imports the public key from an RSA key pair that you created with a third-party tool. Compare this with <a>CreateKeyPair</a>, in which AWS creates the key pair and gives the keys to you (AWS keeps a copy of the public key). With ImportKeyPair, you create the key pair and give AWS just the public key. The private key is never transferred between you and AWS.</p> <p>For more information about key pairs, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Key Pairs</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'ImportSnapshot' => '<p>Imports a disk into an EBS snapshot.</p>', 'ImportVolume' => '<p>Creates an import volume task using metadata from the specified disk image.For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/CommandLineReference/importing-your-volumes-into-amazon-ebs.html">Importing Disks to Amazon EBS</a>.</p> <p>For information about the import manifest referenced by this API action, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html">VM Import Manifest</a>.</p>', 'ModifyHosts' => '<p>Modify the auto-placement setting of a Dedicated Host. When auto-placement is enabled, AWS will place instances that you launch with a tenancy of <code>host</code>, but without targeting a specific host ID, onto any available Dedicated Host in your account which has auto-placement enabled. When auto-placement is disabled, you need to provide a host ID if you want the instance to launch onto a specific host. If no host ID is provided, the instance will be launched onto a suitable host which has auto-placement enabled.</p>', 'ModifyIdFormat' => '<p>Modifies the ID format for the specified resource on a per-region basis. You can specify that resources should receive longer IDs (17-character IDs) when they are created. The following resource types support longer IDs: <code>instance</code> | <code>reservation</code> | <code>snapshot</code> | <code>volume</code>.</p> <p>This setting applies to the IAM user who makes the request; it does not apply to the entire AWS account. By default, an IAM user defaults to the same settings as the root user. If you\'re using this action as the root user, then these settings apply to the entire account, unless an IAM user explicitly overrides these settings for themselves. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/resource-ids.html">Resource IDs</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. </p> <p>Resources created with longer IDs are visible to all IAM roles and users, regardless of these settings and provided that they have permission to use the relevant <code>Describe</code> command for the resource type.</p>', 'ModifyIdentityIdFormat' => '<p>Modifies the ID format of a resource for a specified IAM user, IAM role, or the root user for an account; or all IAM users, IAM roles, and the root user for an account. You can specify that resources should receive longer IDs (17-character IDs) when they are created. </p> <p>The following resource types support longer IDs: <code>instance</code> | <code>reservation</code> | <code>snapshot</code> | <code>volume</code>. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/resource-ids.html">Resource IDs</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. </p> <p>This setting applies to the principal specified in the request; it does not apply to the principal that makes the request. </p> <p>Resources created with longer IDs are visible to all IAM roles and users, regardless of these settings and provided that they have permission to use the relevant <code>Describe</code> command for the resource type.</p>', 'ModifyImageAttribute' => '<p>Modifies the specified attribute of the specified AMI. You can specify only one attribute at a time.</p> <note> <p>AWS Marketplace product codes cannot be modified. Images with an AWS Marketplace product code cannot be made public.</p> </note> <note> <p>The SriovNetSupport enhanced networking attribute cannot be changed using this command. Instead, enable SriovNetSupport on an instance and create an AMI from the instance. This will result in an image with SriovNetSupport enabled.</p> </note>', 'ModifyInstanceAttribute' => '<p>Modifies the specified attribute of the specified instance. You can specify only one attribute at a time.</p> <p>To modify some attributes, the instance must be stopped. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_ChangingAttributesWhileInstanceStopped.html">Modifying Attributes of a Stopped Instance</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'ModifyInstancePlacement' => '<p>Set the instance affinity value for a specific stopped instance and modify the instance tenancy setting.</p> <p>Instance affinity is disabled by default. When instance affinity is <code>host</code> and it is not associated with a specific Dedicated Host, the next time it is launched it will automatically be associated with the host it lands on. This relationship will persist if the instance is stopped/started, or rebooted.</p> <p>You can modify the host ID associated with a stopped instance. If a stopped instance has a new host ID association, the instance will target that host when restarted.</p> <p>You can modify the tenancy of a stopped instance with a tenancy of <code>host</code> or <code>dedicated</code>.</p> <p>Affinity, hostID, and tenancy are not required parameters, but at least one of them must be specified in the request. Affinity and tenancy can be modified in the same request, but tenancy can only be modified on instances that are stopped.</p>', 'ModifyNetworkInterfaceAttribute' => '<p>Modifies the specified network interface attribute. You can specify only one attribute at a time.</p>', 'ModifyReservedInstances' => '<p>Modifies the Availability Zone, instance count, instance type, or network platform (EC2-Classic or EC2-VPC) of your Standard Reserved Instances. The Reserved Instances to be modified must be identical, except for Availability Zone, network platform, and instance type.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-modifying.html">Modifying Reserved Instances</a> in the Amazon Elastic Compute Cloud User Guide.</p>', 'ModifySnapshotAttribute' => '<p>Adds or removes permission settings for the specified snapshot. You may add or remove specified AWS account IDs from a snapshot\'s list of create volume permissions, but you cannot do both in a single API call. If you need to both add and remove account IDs for a snapshot, you must use multiple API calls.</p> <note> <p>Encrypted snapshots and snapshots with AWS Marketplace product codes cannot be made public. Snapshots encrypted with your default CMK cannot be shared with other accounts.</p> </note> <p>For more information on modifying snapshot permissions, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-modifying-snapshot-permissions.html">Sharing Snapshots</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'ModifySpotFleetRequest' => '<p>Modifies the specified Spot fleet request.</p> <p>While the Spot fleet request is being modified, it is in the <code>modifying</code> state.</p> <p>To scale up your Spot fleet, increase its target capacity. The Spot fleet launches the additional Spot instances according to the allocation strategy for the Spot fleet request. If the allocation strategy is <code>lowestPrice</code>, the Spot fleet launches instances using the Spot pool with the lowest price. If the allocation strategy is <code>diversified</code>, the Spot fleet distributes the instances across the Spot pools.</p> <p>To scale down your Spot fleet, decrease its target capacity. First, the Spot fleet cancels any open bids that exceed the new target capacity. You can request that the Spot fleet terminate Spot instances until the size of the fleet no longer exceeds the new target capacity. If the allocation strategy is <code>lowestPrice</code>, the Spot fleet terminates the instances with the highest price per unit. If the allocation strategy is <code>diversified</code>, the Spot fleet terminates instances across the Spot pools. Alternatively, you can request that the Spot fleet keep the fleet at its current size, but not replace any Spot instances that are interrupted or that you terminate manually.</p>', 'ModifySubnetAttribute' => '<p>Modifies a subnet attribute.</p>', 'ModifyVolumeAttribute' => '<p>Modifies a volume attribute.</p> <p>By default, all I/O operations for the volume are suspended when the data on the volume is determined to be potentially inconsistent, to prevent undetectable, latent data corruption. The I/O access to the volume can be resumed by first enabling I/O access and then checking the data consistency on your volume.</p> <p>You can change the default behavior to resume I/O operations. We recommend that you change this only for boot volumes or for volumes that are stateless or disposable.</p>', 'ModifyVpcAttribute' => '<p>Modifies the specified attribute of the specified VPC.</p>', 'ModifyVpcEndpoint' => '<p>Modifies attributes of a specified VPC endpoint. You can modify the policy associated with the endpoint, and you can add and remove route tables associated with the endpoint.</p>', 'ModifyVpcPeeringConnectionOptions' => '<p>Modifies the VPC peering connection options on one side of a VPC peering connection. You can do the following:</p> <ul> <li> <p>Enable/disable communication over the peering connection between an EC2-Classic instance that\'s linked to your VPC (using ClassicLink) and instances in the peer VPC.</p> </li> <li> <p>Enable/disable communication over the peering connection between instances in your VPC and an EC2-Classic instance that\'s linked to the peer VPC.</p> </li> <li> <p>Enable/disable a local VPC to resolve public DNS hostnames to private IP addresses when queried from instances in the peer VPC.</p> </li> </ul> <p>If the peered VPCs are in different accounts, each owner must initiate a separate request to modify the peering connection options, depending on whether their VPC was the requester or accepter for the VPC peering connection. If the peered VPCs are in the same account, you can modify the requester and accepter options in the same request. To confirm which VPC is the accepter and requester for a VPC peering connection, use the <a>DescribeVpcPeeringConnections</a> command.</p>', 'MonitorInstances' => '<p>Enables monitoring for a running instance. For more information about monitoring instances, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-cloudwatch.html">Monitoring Your Instances and Volumes</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'MoveAddressToVpc' => '<p>Moves an Elastic IP address from the EC2-Classic platform to the EC2-VPC platform. The Elastic IP address must be allocated to your account for more than 24 hours, and it must not be associated with an instance. After the Elastic IP address is moved, it is no longer available for use in the EC2-Classic platform, unless you move it back using the <a>RestoreAddressToClassic</a> request. You cannot move an Elastic IP address that was originally allocated for use in the EC2-VPC platform to the EC2-Classic platform. </p>', 'PurchaseHostReservation' => '<p>Purchase a reservation with configurations that match those of your Dedicated Host. You must have active Dedicated Hosts in your account before you purchase a reservation. This action results in the specified reservation being purchased and charged to your account.</p>', 'PurchaseReservedInstancesOffering' => '<p>Purchases a Reserved Instance for use with your account. With Reserved Instances, you pay a lower hourly rate compared to On-Demand instance pricing.</p> <p>Use <a>DescribeReservedInstancesOfferings</a> to get a list of Reserved Instance offerings that match your specifications. After you\'ve purchased a Reserved Instance, you can check for your new Reserved Instance with <a>DescribeReservedInstances</a>.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/concepts-on-demand-reserved-instances.html">Reserved Instances</a> and <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Reserved Instance Marketplace</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'PurchaseScheduledInstances' => '<p>Purchases one or more Scheduled Instances with the specified schedule.</p> <p>Scheduled Instances enable you to purchase Amazon EC2 compute capacity by the hour for a one-year term. Before you can purchase a Scheduled Instance, you must call <a>DescribeScheduledInstanceAvailability</a> to check for available schedules and obtain a purchase token. After you purchase a Scheduled Instance, you must call <a>RunScheduledInstances</a> during each scheduled time period.</p> <p>After you purchase a Scheduled Instance, you can\'t cancel, modify, or resell your purchase.</p>', 'RebootInstances' => '<p>Requests a reboot of one or more instances. This operation is asynchronous; it only queues a request to reboot the specified instances. The operation succeeds if the instances are valid and belong to you. Requests to reboot terminated instances are ignored.</p> <p>If an instance does not cleanly shut down within four minutes, Amazon EC2 performs a hard reboot.</p> <p>For more information about troubleshooting, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-console.html">Getting Console Output and Rebooting Instances</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'RegisterImage' => '<p>Registers an AMI. When you\'re creating an AMI, this is the final step you must complete before you can launch an instance from the AMI. For more information about creating AMIs, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami.html">Creating Your Own AMIs</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <note> <p>For Amazon EBS-backed instances, <a>CreateImage</a> creates and registers the AMI in a single request, so you don\'t have to register the AMI yourself.</p> </note> <p>You can also use <code>RegisterImage</code> to create an Amazon EBS-backed Linux AMI from a snapshot of a root device volume. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_LaunchingInstanceFromSnapshot.html">Launching an Instance from a Snapshot</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <important> <p>Some Linux distributions, such as Red Hat Enterprise Linux (RHEL) and SUSE Linux Enterprise Server (SLES), use the EC2 <code>billingProduct</code> code associated with an AMI to verify subscription status for package updates. Creating an AMI from an EBS snapshot does not maintain this billing code, and subsequent instances launched from such an AMI will not be able to connect to package update infrastructure.</p> <p>Similarly, although you can create a Windows AMI from a snapshot, you can\'t successfully launch an instance from the AMI.</p> <p>To create Windows AMIs or to create AMIs for Linux operating systems that must retain AMI billing codes to work properly, see <a>CreateImage</a>.</p> </important> <p>If needed, you can deregister an AMI at any time. Any modifications you make to an AMI backed by an instance store volume invalidates its registration. If you make changes to an image, deregister the previous image and register the new image.</p> <note> <p>You can\'t register an image where a secondary (non-root) snapshot has AWS Marketplace product codes.</p> </note>', 'RejectVpcPeeringConnection' => '<p>Rejects a VPC peering connection request. The VPC peering connection must be in the <code>pending-acceptance</code> state. Use the <a>DescribeVpcPeeringConnections</a> request to view your outstanding VPC peering connection requests. To delete an active VPC peering connection, or to delete a VPC peering connection request that you initiated, use <a>DeleteVpcPeeringConnection</a>.</p>', 'ReleaseAddress' => '<p>Releases the specified Elastic IP address.</p> <p>After releasing an Elastic IP address, it is released to the IP address pool and might be unavailable to you. Be sure to update your DNS records and any servers or devices that communicate with the address. If you attempt to release an Elastic IP address that you already released, you\'ll get an <code>AuthFailure</code> error if the address is already allocated to another AWS account.</p> <p>[EC2-Classic, default VPC] Releasing an Elastic IP address automatically disassociates it from any instance that it\'s associated with. To disassociate an Elastic IP address without releasing it, use <a>DisassociateAddress</a>.</p> <p>[Nondefault VPC] You must use <a>DisassociateAddress</a> to disassociate the Elastic IP address before you try to release it. Otherwise, Amazon EC2 returns an error (<code>InvalidIPAddress.InUse</code>).</p>', 'ReleaseHosts' => '<p>When you no longer want to use an On-Demand Dedicated Host it can be released. On-Demand billing is stopped and the host goes into <code>released</code> state. The host ID of Dedicated Hosts that have been released can no longer be specified in another request, e.g., ModifyHosts. You must stop or terminate all instances on a host before it can be released.</p> <p>When Dedicated Hosts are released, it make take some time for them to stop counting toward your limit and you may receive capacity errors when trying to allocate new Dedicated hosts. Try waiting a few minutes, and then try again.</p> <p>Released hosts will still appear in a <a>DescribeHosts</a> response.</p>', 'ReplaceNetworkAclAssociation' => '<p>Changes which network ACL a subnet is associated with. By default when you create a subnet, it\'s automatically associated with the default network ACL. For more information about network ACLs, see <a href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_ACLs.html">Network ACLs</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'ReplaceNetworkAclEntry' => '<p>Replaces an entry (rule) in a network ACL. For more information about network ACLs, see <a href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_ACLs.html">Network ACLs</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'ReplaceRoute' => '<p>Replaces an existing route within a route table in a VPC. You must provide only one of the following: Internet gateway or virtual private gateway, NAT instance, NAT gateway, VPC peering connection, or network interface.</p> <p>For more information about route tables, see <a href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Route_Tables.html">Route Tables</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'ReplaceRouteTableAssociation' => '<p>Changes the route table associated with a given subnet in a VPC. After the operation completes, the subnet uses the routes in the new route table it\'s associated with. For more information about route tables, see <a href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Route_Tables.html">Route Tables</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p> <p>You can also use ReplaceRouteTableAssociation to change which table is the main route table in the VPC. You just specify the main route table\'s association ID and the route table to be the new main route table.</p>', 'ReportInstanceStatus' => '<p>Submits feedback about the status of an instance. The instance must be in the <code>running</code> state. If your experience with the instance differs from the instance status returned by <a>DescribeInstanceStatus</a>, use <a>ReportInstanceStatus</a> to report your experience with the instance. Amazon EC2 collects this information to improve the accuracy of status checks.</p> <p>Use of this action does not change the value returned by <a>DescribeInstanceStatus</a>.</p>', 'RequestSpotFleet' => '<p>Creates a Spot fleet request.</p> <p>You can submit a single request that includes multiple launch specifications that vary by instance type, AMI, Availability Zone, or subnet.</p> <p>By default, the Spot fleet requests Spot instances in the Spot pool where the price per unit is the lowest. Each launch specification can include its own instance weighting that reflects the value of the instance type to your application workload.</p> <p>Alternatively, you can specify that the Spot fleet distribute the target capacity across the Spot pools included in its launch specifications. By ensuring that the Spot instances in your Spot fleet are in different Spot pools, you can improve the availability of your fleet.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-fleet-requests.html">Spot Fleet Requests</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'RequestSpotInstances' => '<p>Creates a Spot instance request. Spot instances are instances that Amazon EC2 launches when the bid price that you specify exceeds the current Spot price. Amazon EC2 periodically sets the Spot price based on available Spot Instance capacity and current Spot instance requests. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-requests.html">Spot Instance Requests</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'ResetImageAttribute' => '<p>Resets an attribute of an AMI to its default value.</p> <note> <p>The productCodes attribute can\'t be reset.</p> </note>', 'ResetInstanceAttribute' => '<p>Resets an attribute of an instance to its default value. To reset the <code>kernel</code> or <code>ramdisk</code>, the instance must be in a stopped state. To reset the <code>sourceDestCheck</code>, the instance can be either running or stopped.</p> <p>The <code>sourceDestCheck</code> attribute controls whether source/destination checking is enabled. The default value is <code>true</code>, which means checking is enabled. This value must be <code>false</code> for a NAT instance to perform NAT. For more information, see <a href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_NAT_Instance.html">NAT Instances</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'ResetNetworkInterfaceAttribute' => '<p>Resets a network interface attribute. You can specify only one attribute at a time.</p>', 'ResetSnapshotAttribute' => '<p>Resets permission settings for the specified snapshot.</p> <p>For more information on modifying snapshot permissions, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-modifying-snapshot-permissions.html">Sharing Snapshots</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'RestoreAddressToClassic' => '<p>Restores an Elastic IP address that was previously moved to the EC2-VPC platform back to the EC2-Classic platform. You cannot move an Elastic IP address that was originally allocated for use in EC2-VPC. The Elastic IP address must not be associated with an instance or network interface.</p>', 'RevokeSecurityGroupEgress' => '<p>[EC2-VPC only] Removes one or more egress rules from a security group for EC2-VPC. This action doesn\'t apply to security groups for use in EC2-Classic. The values that you specify in the revoke request (for example, ports) must match the existing rule\'s values for the rule to be revoked.</p> <p>Each rule consists of the protocol and the CIDR range or source security group. For the TCP and UDP protocols, you must also specify the destination port or range of ports. For the ICMP protocol, you must also specify the ICMP type and code.</p> <p>Rule changes are propagated to instances within the security group as quickly as possible. However, a small delay might occur.</p>', 'RevokeSecurityGroupIngress' => '<p>Removes one or more ingress rules from a security group. The values that you specify in the revoke request (for example, ports) must match the existing rule\'s values for the rule to be removed.</p> <p>Each rule consists of the protocol and the CIDR range or source security group. For the TCP and UDP protocols, you must also specify the destination port or range of ports. For the ICMP protocol, you must also specify the ICMP type and code.</p> <p>Rule changes are propagated to instances within the security group as quickly as possible. However, a small delay might occur.</p>', 'RunInstances' => '<p>Launches the specified number of instances using an AMI for which you have permissions.</p> <p>When you launch an instance, it enters the <code>pending</code> state. After the instance is ready for you, it enters the <code>running</code> state. To check the state of your instance, call <a>DescribeInstances</a>.</p> <p>To ensure faster instance launches, break up large requests into smaller batches. For example, create five separate launch requests for 100 instances each instead of one launch request for 500 instances.</p> <p>To tag your instance, ensure that it is <code>running</code> as <a>CreateTags</a> requires a resource ID. For more information about tagging, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tagging Your Amazon EC2 Resources</a>.</p> <p>If you don\'t specify a security group when launching an instance, Amazon EC2 uses the default security group. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html">Security Groups</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <p>[EC2-VPC only accounts] If you don\'t specify a subnet in the request, we choose a default subnet from your default VPC for you.</p> <p>[EC2-Classic accounts] If you\'re launching into EC2-Classic and you don\'t specify an Availability Zone, we choose one for you.</p> <p>Linux instances have access to the public key of the key pair at boot. You can use this key to provide secure access to the instance. Amazon EC2 public images use this feature to provide secure access without passwords. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Key Pairs</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <p>You can provide optional user data when launching an instance. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/AESDG-chapter-instancedata.html">Instance Metadata</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <p>If any of the AMIs have a product code attached for which the user has not subscribed, <code>RunInstances</code> fails.</p> <p>Some instance types can only be launched into a VPC. If you do not have a default VPC, or if you do not specify a subnet ID in the request, <code>RunInstances</code> fails. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-vpc.html#vpc-only-instance-types">Instance Types Available Only in a VPC</a>.</p> <p>For more information about troubleshooting, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_InstanceStraightToTerminated.html">What To Do If An Instance Immediately Terminates</a>, and <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/TroubleshootingInstancesConnecting.html">Troubleshooting Connecting to Your Instance</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'RunScheduledInstances' => '<p>Launches the specified Scheduled Instances.</p> <p>Before you can launch a Scheduled Instance, you must purchase it and obtain an identifier using <a>PurchaseScheduledInstances</a>.</p> <p>You must launch a Scheduled Instance during its scheduled time period. You can\'t stop or reboot a Scheduled Instance, but you can terminate it as needed. If you terminate a Scheduled Instance before the current scheduled time period ends, you can launch it again after a few minutes. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-scheduled-instances.html">Scheduled Instances</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'StartInstances' => '<p>Starts an Amazon EBS-backed AMI that you\'ve previously stopped.</p> <p>Instances that use Amazon EBS volumes as their root devices can be quickly stopped and started. When an instance is stopped, the compute resources are released and you are not billed for hourly instance usage. However, your root partition Amazon EBS volume remains, continues to persist your data, and you are charged for Amazon EBS volume usage. You can restart your instance at any time. Each time you transition an instance from stopped to started, Amazon EC2 charges a full instance hour, even if transitions happen multiple times within a single hour.</p> <p>Before stopping an instance, make sure it is in a state from which it can be restarted. Stopping an instance does not preserve data stored in RAM.</p> <p>Performing this operation on an instance that uses an instance store as its root device returns an error.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html">Stopping Instances</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'StopInstances' => '<p>Stops an Amazon EBS-backed instance.</p> <p>We don\'t charge hourly usage for a stopped instance, or data transfer fees; however, your root partition Amazon EBS volume remains, continues to persist your data, and you are charged for Amazon EBS volume usage. Each time you transition an instance from stopped to started, Amazon EC2 charges a full instance hour, even if transitions happen multiple times within a single hour.</p> <p>You can\'t start or stop Spot instances, and you can\'t stop instance store-backed instances.</p> <p>When you stop an instance, we shut it down. You can restart your instance at any time. Before stopping an instance, make sure it is in a state from which it can be restarted. Stopping an instance does not preserve data stored in RAM.</p> <p>Stopping an instance is different to rebooting or terminating it. For example, when you stop an instance, the root device and any other devices attached to the instance persist. When you terminate an instance, the root device and any other devices attached during the instance launch are automatically deleted. For more information about the differences between rebooting, stopping, and terminating instances, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-lifecycle.html">Instance Lifecycle</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <p>When you stop an instance, we attempt to shut it down forcibly after a short while. If your instance appears stuck in the stopping state after a period of time, there may be an issue with the underlying host computer. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/TroubleshootingInstancesStopping.html">Troubleshooting Stopping Your Instance</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'TerminateInstances' => '<p>Shuts down one or more instances. This operation is idempotent; if you terminate an instance more than once, each call succeeds. </p> <p>If you specify multiple instances and the request fails (for example, because of a single incorrect instance ID), none of the instances are terminated.</p> <p>Terminated instances remain visible after termination (for approximately one hour).</p> <p>By default, Amazon EC2 deletes all EBS volumes that were attached when the instance launched. Volumes attached after instance launch continue running.</p> <p>You can stop, start, and terminate EBS-backed instances. You can only terminate instance store-backed instances. What happens to an instance differs if you stop it or terminate it. For example, when you stop an instance, the root device and any other devices attached to the instance persist. When you terminate an instance, any attached EBS volumes with the <code>DeleteOnTermination</code> block device mapping parameter set to <code>true</code> are automatically deleted. For more information about the differences between stopping and terminating instances, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-lifecycle.html">Instance Lifecycle</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <p>For more information about troubleshooting, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/TroubleshootingInstancesShuttingDown.html">Troubleshooting Terminating Your Instance</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'UnassignPrivateIpAddresses' => '<p>Unassigns one or more secondary private IP addresses from a network interface.</p>', 'UnmonitorInstances' => '<p>Disables monitoring for a running instance. For more information about monitoring instances, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-cloudwatch.html">Monitoring Your Instances and Volumes</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', ], 'shapes' => [ 'AcceptReservedInstancesExchangeQuoteRequest' => [ 'base' => '<p>Contains the parameters for accepting the quote.</p>', 'refs' => [], ], 'AcceptReservedInstancesExchangeQuoteResult' => [ 'base' => '<p>The result of the exchange and whether it was <code>successful</code>.</p>', 'refs' => [], ], 'AcceptVpcPeeringConnectionRequest' => [ 'base' => '<p>Contains the parameters for AcceptVpcPeeringConnection.</p>', 'refs' => [], ], 'AcceptVpcPeeringConnectionResult' => [ 'base' => '<p>Contains the output of AcceptVpcPeeringConnection.</p>', 'refs' => [], ], 'AccountAttribute' => [ 'base' => '<p>Describes an account attribute.</p>', 'refs' => [ 'AccountAttributeList$member' => NULL, ], ], 'AccountAttributeList' => [ 'base' => NULL, 'refs' => [ 'DescribeAccountAttributesResult$AccountAttributes' => '<p>Information about one or more account attributes.</p>', ], ], 'AccountAttributeName' => [ 'base' => NULL, 'refs' => [ 'AccountAttributeNameStringList$member' => NULL, ], ], 'AccountAttributeNameStringList' => [ 'base' => NULL, 'refs' => [ 'DescribeAccountAttributesRequest$AttributeNames' => '<p>One or more account attribute names.</p>', ], ], 'AccountAttributeValue' => [ 'base' => '<p>Describes a value of an account attribute.</p>', 'refs' => [ 'AccountAttributeValueList$member' => NULL, ], ], 'AccountAttributeValueList' => [ 'base' => NULL, 'refs' => [ 'AccountAttribute$AttributeValues' => '<p>One or more values for the account attribute.</p>', ], ], 'ActiveInstance' => [ 'base' => '<p>Describes a running instance in a Spot fleet.</p>', 'refs' => [ 'ActiveInstanceSet$member' => NULL, ], ], 'ActiveInstanceSet' => [ 'base' => NULL, 'refs' => [ 'DescribeSpotFleetInstancesResponse$ActiveInstances' => '<p>The running instances. Note that this list is refreshed periodically and might be out of date.</p>', ], ], 'ActivityStatus' => [ 'base' => NULL, 'refs' => [ 'SpotFleetRequestConfig$ActivityStatus' => '<p>The progress of the Spot fleet request. If there is an error, the status is <code>error</code>. After all bids are placed, the status is <code>pending_fulfillment</code>. If the size of the fleet is equal to or greater than its target capacity, the status is <code>fulfilled</code>. If the size of the fleet is decreased, the status is <code>pending_termination</code> while Spot instances are terminating.</p>', ], ], 'Address' => [ 'base' => '<p>Describes an Elastic IP address.</p>', 'refs' => [ 'AddressList$member' => NULL, ], ], 'AddressList' => [ 'base' => NULL, 'refs' => [ 'DescribeAddressesResult$Addresses' => '<p>Information about one or more Elastic IP addresses.</p>', ], ], 'Affinity' => [ 'base' => NULL, 'refs' => [ 'ModifyInstancePlacementRequest$Affinity' => '<p>The new affinity setting for the instance.</p>', ], ], 'AllocateAddressRequest' => [ 'base' => '<p>Contains the parameters for AllocateAddress.</p>', 'refs' => [], ], 'AllocateAddressResult' => [ 'base' => '<p>Contains the output of AllocateAddress.</p>', 'refs' => [], ], 'AllocateHostsRequest' => [ 'base' => '<p>Contains the parameters for AllocateHosts.</p>', 'refs' => [], ], 'AllocateHostsResult' => [ 'base' => '<p>Contains the output of AllocateHosts.</p>', 'refs' => [], ], 'AllocationIdList' => [ 'base' => NULL, 'refs' => [ 'DescribeAddressesRequest$AllocationIds' => '<p>[EC2-VPC] One or more allocation IDs.</p> <p>Default: Describes all your Elastic IP addresses.</p>', ], ], 'AllocationState' => [ 'base' => NULL, 'refs' => [ 'Host$State' => '<p>The Dedicated Host\'s state.</p>', ], ], 'AllocationStrategy' => [ 'base' => NULL, 'refs' => [ 'SpotFleetRequestConfigData$AllocationStrategy' => '<p>Indicates how to allocate the target capacity across the Spot pools specified by the Spot fleet request. The default is <code>lowestPrice</code>.</p>', ], ], 'ArchitectureValues' => [ 'base' => NULL, 'refs' => [ 'Image$Architecture' => '<p>The architecture of the image.</p>', 'ImportInstanceLaunchSpecification$Architecture' => '<p>The architecture of the instance.</p>', 'Instance$Architecture' => '<p>The architecture of the image.</p>', 'RegisterImageRequest$Architecture' => '<p>The architecture of the AMI.</p> <p>Default: For Amazon EBS-backed AMIs, <code>i386</code>. For instance store-backed AMIs, the architecture specified in the manifest file.</p>', ], ], 'AssignPrivateIpAddressesRequest' => [ 'base' => '<p>Contains the parameters for AssignPrivateIpAddresses.</p>', 'refs' => [], ], 'AssociateAddressRequest' => [ 'base' => '<p>Contains the parameters for AssociateAddress.</p>', 'refs' => [], ], 'AssociateAddressResult' => [ 'base' => '<p>Contains the output of AssociateAddress.</p>', 'refs' => [], ], 'AssociateDhcpOptionsRequest' => [ 'base' => '<p>Contains the parameters for AssociateDhcpOptions.</p>', 'refs' => [], ], 'AssociateRouteTableRequest' => [ 'base' => '<p>Contains the parameters for AssociateRouteTable.</p>', 'refs' => [], ], 'AssociateRouteTableResult' => [ 'base' => '<p>Contains the output of AssociateRouteTable.</p>', 'refs' => [], ], 'AttachClassicLinkVpcRequest' => [ 'base' => '<p>Contains the parameters for AttachClassicLinkVpc.</p>', 'refs' => [], ], 'AttachClassicLinkVpcResult' => [ 'base' => '<p>Contains the output of AttachClassicLinkVpc.</p>', 'refs' => [], ], 'AttachInternetGatewayRequest' => [ 'base' => '<p>Contains the parameters for AttachInternetGateway.</p>', 'refs' => [], ], 'AttachNetworkInterfaceRequest' => [ 'base' => '<p>Contains the parameters for AttachNetworkInterface.</p>', 'refs' => [], ], 'AttachNetworkInterfaceResult' => [ 'base' => '<p>Contains the output of AttachNetworkInterface.</p>', 'refs' => [], ], 'AttachVolumeRequest' => [ 'base' => '<p>Contains the parameters for AttachVolume.</p>', 'refs' => [], ], 'AttachVpnGatewayRequest' => [ 'base' => '<p>Contains the parameters for AttachVpnGateway.</p>', 'refs' => [], ], 'AttachVpnGatewayResult' => [ 'base' => '<p>Contains the output of AttachVpnGateway.</p>', 'refs' => [], ], 'AttachmentStatus' => [ 'base' => NULL, 'refs' => [ 'EbsInstanceBlockDevice$Status' => '<p>The attachment state.</p>', 'InstanceNetworkInterfaceAttachment$Status' => '<p>The attachment state.</p>', 'InternetGatewayAttachment$State' => '<p>The current state of the attachment.</p>', 'NetworkInterfaceAttachment$Status' => '<p>The attachment state.</p>', 'VpcAttachment$State' => '<p>The current state of the attachment.</p>', ], ], 'AttributeBooleanValue' => [ 'base' => '<p>Describes a value for a resource attribute that is a Boolean value.</p>', 'refs' => [ 'DescribeNetworkInterfaceAttributeResult$SourceDestCheck' => '<p>Indicates whether source/destination checking is enabled.</p>', 'DescribeVolumeAttributeResult$AutoEnableIO' => '<p>The state of <code>autoEnableIO</code> attribute.</p>', 'DescribeVpcAttributeResult$EnableDnsSupport' => '<p>Indicates whether DNS resolution is enabled for the VPC. If this attribute is <code>true</code>, the Amazon DNS server resolves DNS hostnames for your instances to their corresponding IP addresses; otherwise, it does not.</p>', 'DescribeVpcAttributeResult$EnableDnsHostnames' => '<p>Indicates whether the instances launched in the VPC get DNS hostnames. If this attribute is <code>true</code>, instances in the VPC get DNS hostnames; otherwise, they do not.</p>', 'InstanceAttribute$DisableApiTermination' => '<p>If the value is <code>true</code>, you can\'t terminate the instance through the Amazon EC2 console, CLI, or API; otherwise, you can.</p>', 'InstanceAttribute$EbsOptimized' => '<p>Indicates whether the instance is optimized for EBS I/O.</p>', 'InstanceAttribute$EnaSupport' => '<p>Indicates whether enhanced networking with ENA is enabled.</p>', 'InstanceAttribute$SourceDestCheck' => '<p>Indicates whether source/destination checking is enabled. A value of <code>true</code> means checking is enabled, and <code>false</code> means checking is disabled. This value must be <code>false</code> for a NAT instance to perform NAT.</p>', 'ModifyInstanceAttributeRequest$SourceDestCheck' => '<p>Specifies whether source/destination checking is enabled. A value of <code>true</code> means that checking is enabled, and <code>false</code> means checking is disabled. This value must be <code>false</code> for a NAT instance to perform NAT.</p>', 'ModifyInstanceAttributeRequest$DisableApiTermination' => '<p>If the value is <code>true</code>, you can\'t terminate the instance using the Amazon EC2 console, CLI, or API; otherwise, you can. You cannot use this paramater for Spot Instances.</p>', 'ModifyInstanceAttributeRequest$EbsOptimized' => '<p>Specifies whether the instance is optimized for EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization isn\'t available with all instance types. Additional usage charges apply when using an EBS Optimized instance.</p>', 'ModifyInstanceAttributeRequest$EnaSupport' => '<p>Set to <code>true</code> to enable enhanced networking with ENA for the instance.</p> <p>This option is supported only for HVM instances. Specifying this option with a PV instance can make it unreachable.</p>', 'ModifyNetworkInterfaceAttributeRequest$SourceDestCheck' => '<p>Indicates whether source/destination checking is enabled. A value of <code>true</code> means checking is enabled, and <code>false</code> means checking is disabled. This value must be <code>false</code> for a NAT instance to perform NAT. For more information, see <a href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_NAT_Instance.html">NAT Instances</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'ModifySubnetAttributeRequest$MapPublicIpOnLaunch' => '<p>Specify <code>true</code> to indicate that instances launched into the specified subnet should be assigned public IP address.</p>', 'ModifyVolumeAttributeRequest$AutoEnableIO' => '<p>Indicates whether the volume should be auto-enabled for I/O operations.</p>', 'ModifyVpcAttributeRequest$EnableDnsSupport' => '<p>Indicates whether the DNS resolution is supported for the VPC. If enabled, queries to the Amazon provided DNS server at the 169.254.169.253 IP address, or the reserved IP address at the base of the VPC network range "plus two" will succeed. If disabled, the Amazon provided DNS service in the VPC that resolves public DNS hostnames to IP addresses is not enabled.</p> <p>You cannot modify the DNS resolution and DNS hostnames attributes in the same request. Use separate requests for each attribute.</p>', 'ModifyVpcAttributeRequest$EnableDnsHostnames' => '<p>Indicates whether the instances launched in the VPC get DNS hostnames. If enabled, instances in the VPC get DNS hostnames; otherwise, they do not.</p> <p>You cannot modify the DNS resolution and DNS hostnames attributes in the same request. Use separate requests for each attribute. You can only enable DNS hostnames if you\'ve enabled DNS support.</p>', ], ], 'AttributeValue' => [ 'base' => '<p>Describes a value for a resource attribute that is a String.</p>', 'refs' => [ 'DescribeNetworkInterfaceAttributeResult$Description' => '<p>The description of the network interface.</p>', 'DhcpConfigurationValueList$member' => NULL, 'ImageAttribute$KernelId' => '<p>The kernel ID.</p>', 'ImageAttribute$RamdiskId' => '<p>The RAM disk ID.</p>', 'ImageAttribute$Description' => '<p>A description for the AMI.</p>', 'ImageAttribute$SriovNetSupport' => '<p>Indicates whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.</p>', 'InstanceAttribute$InstanceType' => '<p>The instance type.</p>', 'InstanceAttribute$KernelId' => '<p>The kernel ID.</p>', 'InstanceAttribute$RamdiskId' => '<p>The RAM disk ID.</p>', 'InstanceAttribute$UserData' => '<p>The user data.</p>', 'InstanceAttribute$InstanceInitiatedShutdownBehavior' => '<p>Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the operating system command for system shutdown).</p>', 'InstanceAttribute$RootDeviceName' => '<p>The name of the root device (for example, <code>/dev/sda1</code> or <code>/dev/xvda</code>).</p>', 'InstanceAttribute$SriovNetSupport' => '<p>Indicates whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.</p>', 'ModifyImageAttributeRequest$Description' => '<p>A description for the AMI.</p>', 'ModifyInstanceAttributeRequest$InstanceType' => '<p>Changes the instance type to the specified value. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a>. If the instance type is not valid, the error returned is <code>InvalidInstanceAttributeValue</code>.</p>', 'ModifyInstanceAttributeRequest$Kernel' => '<p>Changes the instance\'s kernel to the specified value. We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedKernels.html">PV-GRUB</a>.</p>', 'ModifyInstanceAttributeRequest$Ramdisk' => '<p>Changes the instance\'s RAM disk to the specified value. We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedKernels.html">PV-GRUB</a>.</p>', 'ModifyInstanceAttributeRequest$InstanceInitiatedShutdownBehavior' => '<p>Specifies whether an instance stops or terminates when you initiate shutdown from the instance (using the operating system command for system shutdown).</p>', 'ModifyInstanceAttributeRequest$SriovNetSupport' => '<p>Set to <code>simple</code> to enable enhanced networking with the Intel 82599 Virtual Function interface for the instance.</p> <p>There is no way to disable enhanced networking with the Intel 82599 Virtual Function interface at this time.</p> <p>This option is supported only for HVM instances. Specifying this option with a PV instance can make it unreachable.</p>', 'ModifyNetworkInterfaceAttributeRequest$Description' => '<p>A description for the network interface.</p>', ], ], 'AuthorizeSecurityGroupEgressRequest' => [ 'base' => '<p>Contains the parameters for AuthorizeSecurityGroupEgress.</p>', 'refs' => [], ], 'AuthorizeSecurityGroupIngressRequest' => [ 'base' => '<p>Contains the parameters for AuthorizeSecurityGroupIngress.</p>', 'refs' => [], ], 'AutoPlacement' => [ 'base' => NULL, 'refs' => [ 'AllocateHostsRequest$AutoPlacement' => '<p>This is enabled by default. This property allows instances to be automatically placed onto available Dedicated Hosts, when you are launching instances without specifying a host ID.</p> <p>Default: Enabled</p>', 'Host$AutoPlacement' => '<p>Whether auto-placement is on or off.</p>', 'ModifyHostsRequest$AutoPlacement' => '<p>Specify whether to enable or disable auto-placement.</p>', ], ], 'AvailabilityZone' => [ 'base' => '<p>Describes an Availability Zone.</p>', 'refs' => [ 'AvailabilityZoneList$member' => NULL, ], ], 'AvailabilityZoneList' => [ 'base' => NULL, 'refs' => [ 'DescribeAvailabilityZonesResult$AvailabilityZones' => '<p>Information about one or more Availability Zones.</p>', ], ], 'AvailabilityZoneMessage' => [ 'base' => '<p>Describes a message about an Availability Zone.</p>', 'refs' => [ 'AvailabilityZoneMessageList$member' => NULL, ], ], 'AvailabilityZoneMessageList' => [ 'base' => NULL, 'refs' => [ 'AvailabilityZone$Messages' => '<p>Any messages about the Availability Zone.</p>', ], ], 'AvailabilityZoneState' => [ 'base' => NULL, 'refs' => [ 'AvailabilityZone$State' => '<p>The state of the Availability Zone.</p>', ], ], 'AvailableCapacity' => [ 'base' => '<p>The capacity information for instances launched onto the Dedicated Host.</p>', 'refs' => [ 'Host$AvailableCapacity' => '<p>The number of new instances that can be launched onto the Dedicated Host.</p>', ], ], 'AvailableInstanceCapacityList' => [ 'base' => NULL, 'refs' => [ 'AvailableCapacity$AvailableInstanceCapacity' => '<p>The total number of instances that the Dedicated Host supports.</p>', ], ], 'BatchState' => [ 'base' => NULL, 'refs' => [ 'CancelSpotFleetRequestsSuccessItem$CurrentSpotFleetRequestState' => '<p>The current state of the Spot fleet request.</p>', 'CancelSpotFleetRequestsSuccessItem$PreviousSpotFleetRequestState' => '<p>The previous state of the Spot fleet request.</p>', 'SpotFleetRequestConfig$SpotFleetRequestState' => '<p>The state of the Spot fleet request.</p>', ], ], 'Blob' => [ 'base' => NULL, 'refs' => [ 'BlobAttributeValue$Value' => NULL, 'ImportKeyPairRequest$PublicKeyMaterial' => '<p>The public key. For API calls, the text must be base64-encoded. For command line tools, base64 encoding is performed for you.</p>', 'S3Storage$UploadPolicy' => '<p>An Amazon S3 upload policy that gives Amazon EC2 permission to upload items into Amazon S3 on your behalf.</p>', ], ], 'BlobAttributeValue' => [ 'base' => NULL, 'refs' => [ 'ModifyInstanceAttributeRequest$UserData' => '<p>Changes the instance\'s user data to the specified value. If you are using an AWS SDK or command line tool, Base64-encoding is performed for you, and you can load the text from a file. Otherwise, you must provide Base64-encoded text.</p>', ], ], 'BlockDeviceMapping' => [ 'base' => '<p>Describes a block device mapping.</p>', 'refs' => [ 'BlockDeviceMappingList$member' => NULL, 'BlockDeviceMappingRequestList$member' => NULL, ], ], 'BlockDeviceMappingList' => [ 'base' => NULL, 'refs' => [ 'Image$BlockDeviceMappings' => '<p>Any block device mapping entries.</p>', 'ImageAttribute$BlockDeviceMappings' => '<p>One or more block device mapping entries.</p>', 'LaunchSpecification$BlockDeviceMappings' => '<p>One or more block device mapping entries.</p> <p>Although you can specify encrypted EBS volumes in this block device mapping for your Spot Instances, these volumes are not encrypted.</p>', 'RequestSpotLaunchSpecification$BlockDeviceMappings' => '<p>One or more block device mapping entries.</p> <p>Although you can specify encrypted EBS volumes in this block device mapping for your Spot Instances, these volumes are not encrypted.</p>', 'SpotFleetLaunchSpecification$BlockDeviceMappings' => '<p>One or more block device mapping entries.</p>', ], ], 'BlockDeviceMappingRequestList' => [ 'base' => NULL, 'refs' => [ 'CreateImageRequest$BlockDeviceMappings' => '<p>Information about one or more block device mappings.</p>', 'RegisterImageRequest$BlockDeviceMappings' => '<p>One or more block device mapping entries.</p>', 'RunInstancesRequest$BlockDeviceMappings' => '<p>The block device mapping.</p> <important> <p>Supplying both a snapshot ID and an encryption value as arguments for block-device mapping results in an error. This is because only blank volumes can be encrypted on start, and these are not created from a snapshot. If a snapshot is the basis for the volume, it contains data by definition and its encryption status cannot be changed using this action.</p> </important>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'AcceptReservedInstancesExchangeQuoteRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AcceptVpcPeeringConnectionRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AllocateAddressRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AssignPrivateIpAddressesRequest$AllowReassignment' => '<p>Indicates whether to allow an IP address that is already assigned to another network interface or instance to be reassigned to the specified network interface.</p>', 'AssociateAddressRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AssociateAddressRequest$AllowReassociation' => '<p>[EC2-VPC] For a VPC in an EC2-Classic account, specify true to allow an Elastic IP address that is already associated with an instance or network interface to be reassociated with the specified instance or network interface. Otherwise, the operation fails. In a VPC in an EC2-VPC-only account, reassociation is automatic, therefore you can specify false to ensure the operation fails if the Elastic IP address is already associated with another resource.</p>', 'AssociateDhcpOptionsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AssociateRouteTableRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AttachClassicLinkVpcRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AttachClassicLinkVpcResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'AttachInternetGatewayRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AttachNetworkInterfaceRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AttachVolumeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AttachVpnGatewayRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AttributeBooleanValue$Value' => '<p>The attribute value. The valid values are <code>true</code> or <code>false</code>.</p>', 'AuthorizeSecurityGroupEgressRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AuthorizeSecurityGroupIngressRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'BundleInstanceRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CancelBundleTaskRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CancelConversionRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CancelImportTaskRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CancelSpotFleetRequestsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CancelSpotFleetRequestsRequest$TerminateInstances' => '<p>Indicates whether to terminate instances for a Spot fleet request if it is canceled successfully.</p>', 'CancelSpotInstanceRequestsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ClassicLinkDnsSupport$ClassicLinkDnsSupported' => '<p>Indicates whether ClassicLink DNS support is enabled for the VPC.</p>', 'ConfirmProductInstanceRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ConfirmProductInstanceResult$Return' => '<p>The return value of the request. Returns <code>true</code> if the specified product code is owned by the requester and associated with the specified instance.</p>', 'CopyImageRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CopyImageRequest$Encrypted' => '<p>Specifies whether the destination snapshots of the copied image should be encrypted. The default CMK for EBS is used unless a non-default AWS Key Management Service (AWS KMS) CMK is specified with <code>KmsKeyId</code>. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'CopySnapshotRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CopySnapshotRequest$Encrypted' => '<p>Specifies whether the destination snapshot should be encrypted. You can encrypt a copy of an unencrypted snapshot using this flag, but you cannot use it to create an unencrypted copy from an encrypted snapshot. Your default CMK for EBS is used unless a non-default AWS Key Management Service (AWS KMS) CMK is specified with <code>KmsKeyId</code>. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'CreateCustomerGatewayRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateDhcpOptionsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateImageRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateImageRequest$NoReboot' => '<p>By default, Amazon EC2 attempts to shut down and reboot the instance before creating the image. If the \'No Reboot\' option is set, Amazon EC2 doesn\'t shut down the instance before creating the image. When this option is used, file system integrity on the created image can\'t be guaranteed.</p>', 'CreateInternetGatewayRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateKeyPairRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateNetworkAclEntryRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateNetworkAclEntryRequest$Egress' => '<p>Indicates whether this is an egress rule (rule is applied to traffic leaving the subnet).</p>', 'CreateNetworkAclRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateNetworkInterfaceRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreatePlacementGroupRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateRouteRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateRouteResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'CreateRouteTableRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateSecurityGroupRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateSnapshotRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateSpotDatafeedSubscriptionRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateSubnetRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateTagsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateVolumeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateVolumeRequest$Encrypted' => '<p>Specifies whether the volume should be encrypted. Encrypted Amazon EBS volumes may only be attached to instances that support Amazon EBS encryption. Volumes that are created from encrypted snapshots are automatically encrypted. There is no way to create an encrypted volume from an unencrypted snapshot or vice versa. If your AMI uses encrypted volumes, you can only launch it on supported instance types. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'CreateVpcEndpointRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateVpcPeeringConnectionRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateVpcRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateVpnConnectionRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateVpnGatewayRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteCustomerGatewayRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteDhcpOptionsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteInternetGatewayRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteKeyPairRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteNetworkAclEntryRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteNetworkAclEntryRequest$Egress' => '<p>Indicates whether the rule is an egress rule.</p>', 'DeleteNetworkAclRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteNetworkInterfaceRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeletePlacementGroupRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteRouteRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteRouteTableRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteSecurityGroupRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteSnapshotRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteSpotDatafeedSubscriptionRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteSubnetRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteTagsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteVolumeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteVpcEndpointsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteVpcPeeringConnectionRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteVpcPeeringConnectionResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'DeleteVpcRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteVpnConnectionRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteVpnGatewayRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeregisterImageRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeAccountAttributesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeAddressesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeAvailabilityZonesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeBundleTasksRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeClassicLinkInstancesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeConversionTasksRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeCustomerGatewaysRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeDhcpOptionsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeImageAttributeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeImagesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeImportImageTasksRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeImportSnapshotTasksRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeInstanceAttributeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeInstanceStatusRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeInstanceStatusRequest$IncludeAllInstances' => '<p>When <code>true</code>, includes the health status for all instances. When <code>false</code>, includes the health status for running instances only.</p> <p>Default: <code>false</code> </p>', 'DescribeInstancesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeInternetGatewaysRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeKeyPairsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeMovingAddressesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeNetworkAclsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeNetworkInterfaceAttributeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeNetworkInterfacesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribePlacementGroupsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribePrefixListsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeRegionsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeReservedInstancesOfferingsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeReservedInstancesOfferingsRequest$IncludeMarketplace' => '<p>Include Reserved Instance Marketplace offerings in the response.</p>', 'DescribeReservedInstancesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeRouteTablesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeScheduledInstanceAvailabilityRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeScheduledInstancesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeSecurityGroupReferencesRequest$DryRun' => '<p>Checks whether you have the required permissions for the operation, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.</p>', 'DescribeSecurityGroupsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeSnapshotAttributeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeSnapshotsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeSpotDatafeedSubscriptionRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeSpotFleetInstancesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeSpotFleetRequestHistoryRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeSpotFleetRequestsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeSpotInstanceRequestsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeSpotPriceHistoryRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeStaleSecurityGroupsRequest$DryRun' => '<p>Checks whether you have the required permissions for the operation, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.</p>', 'DescribeSubnetsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeTagsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeVolumeAttributeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeVolumeStatusRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeVolumesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeVpcAttributeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeVpcClassicLinkRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeVpcEndpointServicesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeVpcEndpointsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeVpcPeeringConnectionsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeVpcsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeVpnConnectionsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeVpnGatewaysRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DetachClassicLinkVpcRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DetachClassicLinkVpcResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'DetachInternetGatewayRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DetachNetworkInterfaceRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DetachNetworkInterfaceRequest$Force' => '<p>Specifies whether to force a detachment.</p>', 'DetachVolumeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DetachVolumeRequest$Force' => '<p>Forces detachment if the previous detachment attempt did not occur cleanly (for example, logging into an instance, unmounting the volume, and detaching normally). This option can lead to data loss or a corrupted file system. Use this option only as a last resort to detach a volume from a failed instance. The instance won\'t have an opportunity to flush file system caches or file system metadata. If you use this option, you must perform file system check and repair procedures.</p>', 'DetachVpnGatewayRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DisableVpcClassicLinkDnsSupportResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'DisableVpcClassicLinkRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DisableVpcClassicLinkResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'DisassociateAddressRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DisassociateRouteTableRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'EbsBlockDevice$DeleteOnTermination' => '<p>Indicates whether the EBS volume is deleted on instance termination.</p>', 'EbsBlockDevice$Encrypted' => '<p>Indicates whether the EBS volume is encrypted. Encrypted Amazon EBS volumes may only be attached to instances that support Amazon EBS encryption.</p>', 'EbsInstanceBlockDevice$DeleteOnTermination' => '<p>Indicates whether the volume is deleted on instance termination.</p>', 'EbsInstanceBlockDeviceSpecification$DeleteOnTermination' => '<p>Indicates whether the volume is deleted on instance termination.</p>', 'EnableVolumeIORequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'EnableVpcClassicLinkDnsSupportResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'EnableVpcClassicLinkRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'EnableVpcClassicLinkResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'GetConsoleOutputRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetConsoleScreenshotRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetConsoleScreenshotRequest$WakeUp' => '<p>When set to <code>true</code>, acts as keystroke input and wakes up an instance that\'s in standby or "sleep" mode.</p>', 'GetPasswordDataRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetReservedInstancesExchangeQuoteRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetReservedInstancesExchangeQuoteResult$IsValidExchange' => '<p>If <code>true</code>, the exchange is valid. If <code>false</code>, the exchange cannot be performed.</p>', 'IdFormat$UseLongIds' => '<p>Indicates whether longer IDs (17-character IDs) are enabled for the resource.</p>', 'Image$Public' => '<p>Indicates whether the image has public launch permissions. The value is <code>true</code> if this image has public launch permissions or <code>false</code> if it has only implicit and explicit launch permissions.</p>', 'Image$EnaSupport' => '<p>Specifies whether enhanced networking with ENA is enabled.</p>', 'ImportImageRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ImportInstanceLaunchSpecification$Monitoring' => '<p>Indicates whether monitoring is enabled.</p>', 'ImportInstanceRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ImportKeyPairRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ImportSnapshotRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ImportVolumeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'Instance$SourceDestCheck' => '<p>Specifies whether to enable an instance launched in a VPC to perform NAT. This controls whether source/destination checking is enabled on the instance. A value of <code>true</code> means checking is enabled, and <code>false</code> means checking is disabled. The value must be <code>false</code> for the instance to perform NAT. For more information, see <a href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_NAT_Instance.html">NAT Instances</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'Instance$EbsOptimized' => '<p>Indicates whether the instance is optimized for EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This optimization isn\'t available with all instance types. Additional usage charges apply when using an EBS Optimized instance.</p>', 'Instance$EnaSupport' => '<p>Specifies whether enhanced networking with ENA is enabled.</p>', 'InstanceNetworkInterface$SourceDestCheck' => '<p>Indicates whether to validate network traffic to or from this network interface.</p>', 'InstanceNetworkInterfaceAttachment$DeleteOnTermination' => '<p>Indicates whether the network interface is deleted when the instance is terminated.</p>', 'InstanceNetworkInterfaceSpecification$DeleteOnTermination' => '<p>If set to <code>true</code>, the interface is deleted when the instance is terminated. You can specify <code>true</code> only if creating a new network interface when launching an instance.</p>', 'InstanceNetworkInterfaceSpecification$AssociatePublicIpAddress' => '<p>Indicates whether to assign a public IP address to an instance you launch in a VPC. The public IP address can only be assigned to a network interface for eth0, and can only be assigned to a new network interface, not an existing one. You cannot specify more than one network interface in the request. If launching into a default subnet, the default value is <code>true</code>.</p>', 'InstancePrivateIpAddress$Primary' => '<p>Indicates whether this IP address is the primary private IP address of the network interface.</p>', 'LaunchSpecification$EbsOptimized' => '<p>Indicates whether the instance is optimized for EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization isn\'t available with all instance types. Additional usage charges apply when using an EBS Optimized instance.</p> <p>Default: <code>false</code> </p>', 'ModifyIdFormatRequest$UseLongIds' => '<p>Indicate whether the resource should use longer IDs (17-character IDs).</p>', 'ModifyIdentityIdFormatRequest$UseLongIds' => '<p>Indicates whether the resource should use longer IDs (17-character IDs)</p>', 'ModifyImageAttributeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyInstanceAttributeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyInstancePlacementResult$Return' => '<p>Is <code>true</code> if the request succeeds, and an error otherwise.</p>', 'ModifyNetworkInterfaceAttributeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifySnapshotAttributeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifySpotFleetRequestResponse$Return' => '<p>Is <code>true</code> if the request succeeds, and an error otherwise.</p>', 'ModifyVolumeAttributeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyVpcEndpointRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyVpcEndpointRequest$ResetPolicy' => '<p>Specify <code>true</code> to reset the policy document to the default policy. The default policy allows access to the service.</p>', 'ModifyVpcEndpointResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'ModifyVpcPeeringConnectionOptionsRequest$DryRun' => '<p>Checks whether you have the required permissions for the operation, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'MonitorInstancesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'MoveAddressToVpcRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'NetworkAcl$IsDefault' => '<p>Indicates whether this is the default network ACL for the VPC.</p>', 'NetworkAclEntry$Egress' => '<p>Indicates whether the rule is an egress rule (applied to traffic leaving the subnet).</p>', 'NetworkInterface$RequesterManaged' => '<p>Indicates whether the network interface is being managed by AWS.</p>', 'NetworkInterface$SourceDestCheck' => '<p>Indicates whether traffic to or from the instance is validated.</p>', 'NetworkInterfaceAttachment$DeleteOnTermination' => '<p>Indicates whether the network interface is deleted when the instance is terminated.</p>', 'NetworkInterfaceAttachmentChanges$DeleteOnTermination' => '<p>Indicates whether the network interface is deleted when the instance is terminated.</p>', 'NetworkInterfacePrivateIpAddress$Primary' => '<p>Indicates whether this IP address is the primary private IP address of the network interface.</p>', 'PeeringConnectionOptions$AllowEgressFromLocalClassicLinkToRemoteVpc' => '<p>If true, enables outbound communication from an EC2-Classic instance that\'s linked to a local VPC via ClassicLink to instances in a peer VPC.</p>', 'PeeringConnectionOptions$AllowEgressFromLocalVpcToRemoteClassicLink' => '<p>If true, enables outbound communication from instances in a local VPC to an EC2-Classic instance that\'s linked to a peer VPC via ClassicLink.</p>', 'PeeringConnectionOptions$AllowDnsResolutionFromRemoteVpc' => '<p>If true, enables a local VPC to resolve public DNS hostnames to private IP addresses when queried from instances in the peer VPC.</p>', 'PeeringConnectionOptionsRequest$AllowEgressFromLocalClassicLinkToRemoteVpc' => '<p>If true, enables outbound communication from an EC2-Classic instance that\'s linked to a local VPC via ClassicLink to instances in a peer VPC.</p>', 'PeeringConnectionOptionsRequest$AllowEgressFromLocalVpcToRemoteClassicLink' => '<p>If true, enables outbound communication from instances in a local VPC to an EC2-Classic instance that\'s linked to a peer VPC via ClassicLink.</p>', 'PeeringConnectionOptionsRequest$AllowDnsResolutionFromRemoteVpc' => '<p>If true, enables a local VPC to resolve public DNS hostnames to private IP addresses when queried from instances in the peer VPC.</p>', 'PriceSchedule$Active' => '<p>The current price schedule, as determined by the term remaining for the Reserved Instance in the listing.</p> <p>A specific price schedule is always in effect, but only one price schedule can be active at any time. Take, for example, a Reserved Instance listing that has five months remaining in its term. When you specify price schedules for five months and two months, this means that schedule 1, covering the first three months of the remaining term, will be active during months 5, 4, and 3. Then schedule 2, covering the last two months of the term, will be active for months 2 and 1.</p>', 'PrivateIpAddressSpecification$Primary' => '<p>Indicates whether the private IP address is the primary private IP address. Only one IP address can be designated as primary.</p>', 'PurchaseReservedInstancesOfferingRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'PurchaseScheduledInstancesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'RebootInstancesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'RegisterImageRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'RegisterImageRequest$EnaSupport' => '<p>Set to <code>true</code> to enable enhanced networking with ENA for the AMI and any instances that you launch from the AMI.</p> <p>This option is supported only for HVM AMIs. Specifying this option with a PV AMI can make instances launched from the AMI unreachable.</p>', 'RejectVpcPeeringConnectionRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'RejectVpcPeeringConnectionResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'ReleaseAddressRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ReplaceNetworkAclAssociationRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ReplaceNetworkAclEntryRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ReplaceNetworkAclEntryRequest$Egress' => '<p>Indicates whether to replace the egress rule.</p> <p>Default: If no value is specified, we replace the ingress rule.</p>', 'ReplaceRouteRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ReplaceRouteTableAssociationRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ReportInstanceStatusRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'RequestSpotFleetRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'RequestSpotInstancesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'RequestSpotLaunchSpecification$EbsOptimized' => '<p>Indicates whether the instance is optimized for EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization isn\'t available with all instance types. Additional usage charges apply when using an EBS Optimized instance.</p> <p>Default: <code>false</code> </p>', 'ReservedInstancesOffering$Marketplace' => '<p>Indicates whether the offering is available through the Reserved Instance Marketplace (resale) or AWS. If it\'s a Reserved Instance Marketplace offering, this is <code>true</code>.</p>', 'ResetImageAttributeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ResetInstanceAttributeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ResetNetworkInterfaceAttributeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ResetSnapshotAttributeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'RestoreAddressToClassicRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'RevokeSecurityGroupEgressRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'RevokeSecurityGroupIngressRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'RouteTableAssociation$Main' => '<p>Indicates whether this is the main route table.</p>', 'RunInstancesMonitoringEnabled$Enabled' => '<p>Indicates whether monitoring is enabled for the instance.</p>', 'RunInstancesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'RunInstancesRequest$DisableApiTermination' => '<p>If you set this parameter to <code>true</code>, you can\'t terminate the instance using the Amazon EC2 console, CLI, or API; otherwise, you can. If you set this parameter to <code>true</code> and then later want to be able to terminate the instance, you must first change the value of the <code>disableApiTermination</code> attribute to <code>false</code> using <a>ModifyInstanceAttribute</a>. Alternatively, if you set <code>InstanceInitiatedShutdownBehavior</code> to <code>terminate</code>, you can terminate the instance by running the shutdown command from the instance.</p> <p>Default: <code>false</code> </p>', 'RunInstancesRequest$EbsOptimized' => '<p>Indicates whether the instance is optimized for EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization isn\'t available with all instance types. Additional usage charges apply when using an EBS-optimized instance.</p> <p>Default: <code>false</code> </p>', 'RunScheduledInstancesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ScheduledInstanceRecurrence$OccurrenceRelativeToEnd' => '<p>Indicates whether the occurrence is relative to the end of the specified week or month.</p>', 'ScheduledInstanceRecurrenceRequest$OccurrenceRelativeToEnd' => '<p>Indicates whether the occurrence is relative to the end of the specified week or month. You can\'t specify this value with a daily schedule.</p>', 'ScheduledInstancesEbs$DeleteOnTermination' => '<p>Indicates whether the volume is deleted on instance termination.</p>', 'ScheduledInstancesEbs$Encrypted' => '<p>Indicates whether the volume is encrypted. You can attached encrypted volumes only to instances that support them.</p>', 'ScheduledInstancesLaunchSpecification$EbsOptimized' => '<p>Indicates whether the instances are optimized for EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization isn\'t available with all instance types. Additional usage charges apply when using an EBS-optimized instance.</p> <p>Default: <code>false</code> </p>', 'ScheduledInstancesMonitoring$Enabled' => '<p>Indicates whether monitoring is enabled.</p>', 'ScheduledInstancesNetworkInterface$AssociatePublicIpAddress' => '<p>Indicates whether to assign a public IP address to instances launched in a VPC. The public IP address can only be assigned to a network interface for eth0, and can only be assigned to a new network interface, not an existing one. You cannot specify more than one network interface in the request. If launching into a default subnet, the default value is <code>true</code>.</p>', 'ScheduledInstancesNetworkInterface$DeleteOnTermination' => '<p>Indicates whether to delete the interface when the instance is terminated.</p>', 'ScheduledInstancesPrivateIpAddressConfig$Primary' => '<p>Indicates whether this is a primary IP address. Otherwise, this is a secondary IP address.</p>', 'Snapshot$Encrypted' => '<p>Indicates whether the snapshot is encrypted.</p>', 'SpotFleetLaunchSpecification$EbsOptimized' => '<p>Indicates whether the instances are optimized for EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization isn\'t available with all instance types. Additional usage charges apply when using an EBS Optimized instance.</p> <p>Default: <code>false</code> </p>', 'SpotFleetMonitoring$Enabled' => '<p>Enables monitoring for the instance.</p> <p>Default: <code>false</code> </p>', 'SpotFleetRequestConfigData$TerminateInstancesWithExpiration' => '<p>Indicates whether running Spot instances should be terminated when the Spot fleet request expires.</p>', 'StartInstancesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'StopInstancesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'StopInstancesRequest$Force' => '<p>Forces the instances to stop. The instances do not have an opportunity to flush file system caches or file system metadata. If you use this option, you must perform file system check and repair procedures. This option is not recommended for Windows instances.</p> <p>Default: <code>false</code> </p>', 'Subnet$DefaultForAz' => '<p>Indicates whether this is the default subnet for the Availability Zone.</p>', 'Subnet$MapPublicIpOnLaunch' => '<p>Indicates whether instances launched in this subnet receive a public IP address.</p>', 'TerminateInstancesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'UnmonitorInstancesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'Volume$Encrypted' => '<p>Indicates whether the volume will be encrypted.</p>', 'VolumeAttachment$DeleteOnTermination' => '<p>Indicates whether the EBS volume is deleted on instance termination.</p>', 'Vpc$IsDefault' => '<p>Indicates whether the VPC is the default VPC.</p>', 'VpcClassicLink$ClassicLinkEnabled' => '<p>Indicates whether the VPC is enabled for ClassicLink.</p>', 'VpcPeeringConnectionOptionsDescription$AllowEgressFromLocalClassicLinkToRemoteVpc' => '<p>Indicates whether a local ClassicLink connection can communicate with the peer VPC over the VPC peering connection.</p>', 'VpcPeeringConnectionOptionsDescription$AllowEgressFromLocalVpcToRemoteClassicLink' => '<p>Indicates whether a local VPC can communicate with a ClassicLink connection in the peer VPC over the VPC peering connection.</p>', 'VpcPeeringConnectionOptionsDescription$AllowDnsResolutionFromRemoteVpc' => '<p>Indicates whether a local VPC can resolve public DNS hostnames to private IP addresses when queried from instances in a peer VPC.</p>', 'VpnConnectionOptions$StaticRoutesOnly' => '<p>Indicates whether the VPN connection uses static routes only. Static routes must be used for devices that don\'t support BGP.</p>', 'VpnConnectionOptionsSpecification$StaticRoutesOnly' => '<p>Indicates whether the VPN connection uses static routes only. Static routes must be used for devices that don\'t support BGP.</p>', ], ], 'BundleIdStringList' => [ 'base' => NULL, 'refs' => [ 'DescribeBundleTasksRequest$BundleIds' => '<p>One or more bundle task IDs.</p> <p>Default: Describes all your bundle tasks.</p>', ], ], 'BundleInstanceRequest' => [ 'base' => '<p>Contains the parameters for BundleInstance.</p>', 'refs' => [], ], 'BundleInstanceResult' => [ 'base' => '<p>Contains the output of BundleInstance.</p>', 'refs' => [], ], 'BundleTask' => [ 'base' => '<p>Describes a bundle task.</p>', 'refs' => [ 'BundleInstanceResult$BundleTask' => '<p>Information about the bundle task.</p>', 'BundleTaskList$member' => NULL, 'CancelBundleTaskResult$BundleTask' => '<p>Information about the bundle task.</p>', ], ], 'BundleTaskError' => [ 'base' => '<p>Describes an error for <a>BundleInstance</a>.</p>', 'refs' => [ 'BundleTask$BundleTaskError' => '<p>If the task fails, a description of the error.</p>', ], ], 'BundleTaskList' => [ 'base' => NULL, 'refs' => [ 'DescribeBundleTasksResult$BundleTasks' => '<p>Information about one or more bundle tasks.</p>', ], ], 'BundleTaskState' => [ 'base' => NULL, 'refs' => [ 'BundleTask$State' => '<p>The state of the task.</p>', ], ], 'CancelBatchErrorCode' => [ 'base' => NULL, 'refs' => [ 'CancelSpotFleetRequestsError$Code' => '<p>The error code.</p>', ], ], 'CancelBundleTaskRequest' => [ 'base' => '<p>Contains the parameters for CancelBundleTask.</p>', 'refs' => [], ], 'CancelBundleTaskResult' => [ 'base' => '<p>Contains the output of CancelBundleTask.</p>', 'refs' => [], ], 'CancelConversionRequest' => [ 'base' => '<p>Contains the parameters for CancelConversionTask.</p>', 'refs' => [], ], 'CancelExportTaskRequest' => [ 'base' => '<p>Contains the parameters for CancelExportTask.</p>', 'refs' => [], ], 'CancelImportTaskRequest' => [ 'base' => '<p>Contains the parameters for CancelImportTask.</p>', 'refs' => [], ], 'CancelImportTaskResult' => [ 'base' => '<p>Contains the output for CancelImportTask.</p>', 'refs' => [], ], 'CancelReservedInstancesListingRequest' => [ 'base' => '<p>Contains the parameters for CancelReservedInstancesListing.</p>', 'refs' => [], ], 'CancelReservedInstancesListingResult' => [ 'base' => '<p>Contains the output of CancelReservedInstancesListing.</p>', 'refs' => [], ], 'CancelSpotFleetRequestsError' => [ 'base' => '<p>Describes a Spot fleet error.</p>', 'refs' => [ 'CancelSpotFleetRequestsErrorItem$Error' => '<p>The error.</p>', ], ], 'CancelSpotFleetRequestsErrorItem' => [ 'base' => '<p>Describes a Spot fleet request that was not successfully canceled.</p>', 'refs' => [ 'CancelSpotFleetRequestsErrorSet$member' => NULL, ], ], 'CancelSpotFleetRequestsErrorSet' => [ 'base' => NULL, 'refs' => [ 'CancelSpotFleetRequestsResponse$UnsuccessfulFleetRequests' => '<p>Information about the Spot fleet requests that are not successfully canceled.</p>', ], ], 'CancelSpotFleetRequestsRequest' => [ 'base' => '<p>Contains the parameters for CancelSpotFleetRequests.</p>', 'refs' => [], ], 'CancelSpotFleetRequestsResponse' => [ 'base' => '<p>Contains the output of CancelSpotFleetRequests.</p>', 'refs' => [], ], 'CancelSpotFleetRequestsSuccessItem' => [ 'base' => '<p>Describes a Spot fleet request that was successfully canceled.</p>', 'refs' => [ 'CancelSpotFleetRequestsSuccessSet$member' => NULL, ], ], 'CancelSpotFleetRequestsSuccessSet' => [ 'base' => NULL, 'refs' => [ 'CancelSpotFleetRequestsResponse$SuccessfulFleetRequests' => '<p>Information about the Spot fleet requests that are successfully canceled.</p>', ], ], 'CancelSpotInstanceRequestState' => [ 'base' => NULL, 'refs' => [ 'CancelledSpotInstanceRequest$State' => '<p>The state of the Spot instance request.</p>', ], ], 'CancelSpotInstanceRequestsRequest' => [ 'base' => '<p>Contains the parameters for CancelSpotInstanceRequests.</p>', 'refs' => [], ], 'CancelSpotInstanceRequestsResult' => [ 'base' => '<p>Contains the output of CancelSpotInstanceRequests.</p>', 'refs' => [], ], 'CancelledSpotInstanceRequest' => [ 'base' => '<p>Describes a request to cancel a Spot instance.</p>', 'refs' => [ 'CancelledSpotInstanceRequestList$member' => NULL, ], ], 'CancelledSpotInstanceRequestList' => [ 'base' => NULL, 'refs' => [ 'CancelSpotInstanceRequestsResult$CancelledSpotInstanceRequests' => '<p>One or more Spot instance requests.</p>', ], ], 'ClassicLinkDnsSupport' => [ 'base' => '<p>Describes the ClassicLink DNS support status of a VPC.</p>', 'refs' => [ 'ClassicLinkDnsSupportList$member' => NULL, ], ], 'ClassicLinkDnsSupportList' => [ 'base' => NULL, 'refs' => [ 'DescribeVpcClassicLinkDnsSupportResult$Vpcs' => '<p>Information about the ClassicLink DNS support status of the VPCs.</p>', ], ], 'ClassicLinkInstance' => [ 'base' => '<p>Describes a linked EC2-Classic instance.</p>', 'refs' => [ 'ClassicLinkInstanceList$member' => NULL, ], ], 'ClassicLinkInstanceList' => [ 'base' => NULL, 'refs' => [ 'DescribeClassicLinkInstancesResult$Instances' => '<p>Information about one or more linked EC2-Classic instances.</p>', ], ], 'ClientData' => [ 'base' => '<p>Describes the client-specific data.</p>', 'refs' => [ 'ImportImageRequest$ClientData' => '<p>The client-specific data.</p>', 'ImportSnapshotRequest$ClientData' => '<p>The client-specific data.</p>', ], ], 'ConfirmProductInstanceRequest' => [ 'base' => '<p>Contains the parameters for ConfirmProductInstance.</p>', 'refs' => [], ], 'ConfirmProductInstanceResult' => [ 'base' => '<p>Contains the output of ConfirmProductInstance.</p>', 'refs' => [], ], 'ContainerFormat' => [ 'base' => NULL, 'refs' => [ 'ExportToS3Task$ContainerFormat' => '<p>The container format used to combine disk images with metadata (such as OVF). If absent, only the disk image is exported.</p>', 'ExportToS3TaskSpecification$ContainerFormat' => '<p>The container format used to combine disk images with metadata (such as OVF). If absent, only the disk image is exported.</p>', ], ], 'ConversionIdStringList' => [ 'base' => NULL, 'refs' => [ 'DescribeConversionTasksRequest$ConversionTaskIds' => '<p>One or more conversion task IDs.</p>', ], ], 'ConversionTask' => [ 'base' => '<p>Describes a conversion task.</p>', 'refs' => [ 'DescribeConversionTaskList$member' => NULL, 'ImportInstanceResult$ConversionTask' => '<p>Information about the conversion task.</p>', 'ImportVolumeResult$ConversionTask' => '<p>Information about the conversion task.</p>', ], ], 'ConversionTaskState' => [ 'base' => NULL, 'refs' => [ 'ConversionTask$State' => '<p>The state of the conversion task.</p>', ], ], 'CopyImageRequest' => [ 'base' => '<p>Contains the parameters for CopyImage.</p>', 'refs' => [], ], 'CopyImageResult' => [ 'base' => '<p>Contains the output of CopyImage.</p>', 'refs' => [], ], 'CopySnapshotRequest' => [ 'base' => '<p>Contains the parameters for CopySnapshot.</p>', 'refs' => [], ], 'CopySnapshotResult' => [ 'base' => '<p>Contains the output of CopySnapshot.</p>', 'refs' => [], ], 'CreateCustomerGatewayRequest' => [ 'base' => '<p>Contains the parameters for CreateCustomerGateway.</p>', 'refs' => [], ], 'CreateCustomerGatewayResult' => [ 'base' => '<p>Contains the output of CreateCustomerGateway.</p>', 'refs' => [], ], 'CreateDhcpOptionsRequest' => [ 'base' => '<p>Contains the parameters for CreateDhcpOptions.</p>', 'refs' => [], ], 'CreateDhcpOptionsResult' => [ 'base' => '<p>Contains the output of CreateDhcpOptions.</p>', 'refs' => [], ], 'CreateFlowLogsRequest' => [ 'base' => '<p>Contains the parameters for CreateFlowLogs.</p>', 'refs' => [], ], 'CreateFlowLogsResult' => [ 'base' => '<p>Contains the output of CreateFlowLogs.</p>', 'refs' => [], ], 'CreateImageRequest' => [ 'base' => '<p>Contains the parameters for CreateImage.</p>', 'refs' => [], ], 'CreateImageResult' => [ 'base' => '<p>Contains the output of CreateImage.</p>', 'refs' => [], ], 'CreateInstanceExportTaskRequest' => [ 'base' => '<p>Contains the parameters for CreateInstanceExportTask.</p>', 'refs' => [], ], 'CreateInstanceExportTaskResult' => [ 'base' => '<p>Contains the output for CreateInstanceExportTask.</p>', 'refs' => [], ], 'CreateInternetGatewayRequest' => [ 'base' => '<p>Contains the parameters for CreateInternetGateway.</p>', 'refs' => [], ], 'CreateInternetGatewayResult' => [ 'base' => '<p>Contains the output of CreateInternetGateway.</p>', 'refs' => [], ], 'CreateKeyPairRequest' => [ 'base' => '<p>Contains the parameters for CreateKeyPair.</p>', 'refs' => [], ], 'CreateNatGatewayRequest' => [ 'base' => '<p>Contains the parameters for CreateNatGateway.</p>', 'refs' => [], ], 'CreateNatGatewayResult' => [ 'base' => '<p>Contains the output of CreateNatGateway.</p>', 'refs' => [], ], 'CreateNetworkAclEntryRequest' => [ 'base' => '<p>Contains the parameters for CreateNetworkAclEntry.</p>', 'refs' => [], ], 'CreateNetworkAclRequest' => [ 'base' => '<p>Contains the parameters for CreateNetworkAcl.</p>', 'refs' => [], ], 'CreateNetworkAclResult' => [ 'base' => '<p>Contains the output of CreateNetworkAcl.</p>', 'refs' => [], ], 'CreateNetworkInterfaceRequest' => [ 'base' => '<p>Contains the parameters for CreateNetworkInterface.</p>', 'refs' => [], ], 'CreateNetworkInterfaceResult' => [ 'base' => '<p>Contains the output of CreateNetworkInterface.</p>', 'refs' => [], ], 'CreatePlacementGroupRequest' => [ 'base' => '<p>Contains the parameters for CreatePlacementGroup.</p>', 'refs' => [], ], 'CreateReservedInstancesListingRequest' => [ 'base' => '<p>Contains the parameters for CreateReservedInstancesListing.</p>', 'refs' => [], ], 'CreateReservedInstancesListingResult' => [ 'base' => '<p>Contains the output of CreateReservedInstancesListing.</p>', 'refs' => [], ], 'CreateRouteRequest' => [ 'base' => '<p>Contains the parameters for CreateRoute.</p>', 'refs' => [], ], 'CreateRouteResult' => [ 'base' => '<p>Contains the output of CreateRoute.</p>', 'refs' => [], ], 'CreateRouteTableRequest' => [ 'base' => '<p>Contains the parameters for CreateRouteTable.</p>', 'refs' => [], ], 'CreateRouteTableResult' => [ 'base' => '<p>Contains the output of CreateRouteTable.</p>', 'refs' => [], ], 'CreateSecurityGroupRequest' => [ 'base' => '<p>Contains the parameters for CreateSecurityGroup.</p>', 'refs' => [], ], 'CreateSecurityGroupResult' => [ 'base' => '<p>Contains the output of CreateSecurityGroup.</p>', 'refs' => [], ], 'CreateSnapshotRequest' => [ 'base' => '<p>Contains the parameters for CreateSnapshot.</p>', 'refs' => [], ], 'CreateSpotDatafeedSubscriptionRequest' => [ 'base' => '<p>Contains the parameters for CreateSpotDatafeedSubscription.</p>', 'refs' => [], ], 'CreateSpotDatafeedSubscriptionResult' => [ 'base' => '<p>Contains the output of CreateSpotDatafeedSubscription.</p>', 'refs' => [], ], 'CreateSubnetRequest' => [ 'base' => '<p>Contains the parameters for CreateSubnet.</p>', 'refs' => [], ], 'CreateSubnetResult' => [ 'base' => '<p>Contains the output of CreateSubnet.</p>', 'refs' => [], ], 'CreateTagsRequest' => [ 'base' => '<p>Contains the parameters for CreateTags.</p>', 'refs' => [], ], 'CreateVolumePermission' => [ 'base' => '<p>Describes the user or group to be added or removed from the permissions for a volume.</p>', 'refs' => [ 'CreateVolumePermissionList$member' => NULL, ], ], 'CreateVolumePermissionList' => [ 'base' => NULL, 'refs' => [ 'CreateVolumePermissionModifications$Add' => '<p>Adds a specific AWS account ID or group to a volume\'s list of create volume permissions.</p>', 'CreateVolumePermissionModifications$Remove' => '<p>Removes a specific AWS account ID or group from a volume\'s list of create volume permissions.</p>', 'DescribeSnapshotAttributeResult$CreateVolumePermissions' => '<p>A list of permissions for creating volumes from the snapshot.</p>', ], ], 'CreateVolumePermissionModifications' => [ 'base' => '<p>Describes modifications to the permissions for a volume.</p>', 'refs' => [ 'ModifySnapshotAttributeRequest$CreateVolumePermission' => '<p>A JSON representation of the snapshot attribute modification.</p>', ], ], 'CreateVolumeRequest' => [ 'base' => '<p>Contains the parameters for CreateVolume.</p>', 'refs' => [], ], 'CreateVpcEndpointRequest' => [ 'base' => '<p>Contains the parameters for CreateVpcEndpoint.</p>', 'refs' => [], ], 'CreateVpcEndpointResult' => [ 'base' => '<p>Contains the output of CreateVpcEndpoint.</p>', 'refs' => [], ], 'CreateVpcPeeringConnectionRequest' => [ 'base' => '<p>Contains the parameters for CreateVpcPeeringConnection.</p>', 'refs' => [], ], 'CreateVpcPeeringConnectionResult' => [ 'base' => '<p>Contains the output of CreateVpcPeeringConnection.</p>', 'refs' => [], ], 'CreateVpcRequest' => [ 'base' => '<p>Contains the parameters for CreateVpc.</p>', 'refs' => [], ], 'CreateVpcResult' => [ 'base' => '<p>Contains the output of CreateVpc.</p>', 'refs' => [], ], 'CreateVpnConnectionRequest' => [ 'base' => '<p>Contains the parameters for CreateVpnConnection.</p>', 'refs' => [], ], 'CreateVpnConnectionResult' => [ 'base' => '<p>Contains the output of CreateVpnConnection.</p>', 'refs' => [], ], 'CreateVpnConnectionRouteRequest' => [ 'base' => '<p>Contains the parameters for CreateVpnConnectionRoute.</p>', 'refs' => [], ], 'CreateVpnGatewayRequest' => [ 'base' => '<p>Contains the parameters for CreateVpnGateway.</p>', 'refs' => [], ], 'CreateVpnGatewayResult' => [ 'base' => '<p>Contains the output of CreateVpnGateway.</p>', 'refs' => [], ], 'CurrencyCodeValues' => [ 'base' => NULL, 'refs' => [ 'GetHostReservationPurchasePreviewResult$CurrencyCode' => '<p>The currency in which the <code>totalUpfrontPrice</code> and <code>totalHourlyPrice</code> amounts are specified. At this time, the only supported currency is <code>USD</code>.</p>', 'HostOffering$CurrencyCode' => '<p>The currency of the offering.</p>', 'HostReservation$CurrencyCode' => '<p>The currency in which the <code>upfrontPrice</code> and <code>hourlyPrice</code> amounts are specified. At this time, the only supported currency is <code>USD</code>.</p>', 'PriceSchedule$CurrencyCode' => '<p>The currency for transacting the Reserved Instance resale. At this time, the only supported currency is <code>USD</code>.</p>', 'PriceScheduleSpecification$CurrencyCode' => '<p>The currency for transacting the Reserved Instance resale. At this time, the only supported currency is <code>USD</code>.</p>', 'Purchase$CurrencyCode' => '<p>The currency in which the <code>UpfrontPrice</code> and <code>HourlyPrice</code> amounts are specified. At this time, the only supported currency is <code>USD</code>.</p>', 'PurchaseHostReservationRequest$CurrencyCode' => '<p>The currency in which the <code>totalUpfrontPrice</code>, <code>LimitPrice</code>, and <code>totalHourlyPrice</code> amounts are specified. At this time, the only supported currency is <code>USD</code>.</p>', 'PurchaseHostReservationResult$CurrencyCode' => '<p>The currency in which the <code>totalUpfrontPrice</code> and <code>totalHourlyPrice</code> amounts are specified. At this time, the only supported currency is <code>USD</code>.</p>', 'ReservedInstanceLimitPrice$CurrencyCode' => '<p>The currency in which the <code>limitPrice</code> amount is specified. At this time, the only supported currency is <code>USD</code>.</p>', 'ReservedInstances$CurrencyCode' => '<p>The currency of the Reserved Instance. It\'s specified using ISO 4217 standard currency codes. At this time, the only supported currency is <code>USD</code>.</p>', 'ReservedInstancesOffering$CurrencyCode' => '<p>The currency of the Reserved Instance offering you are purchasing. It\'s specified using ISO 4217 standard currency codes. At this time, the only supported currency is <code>USD</code>.</p>', ], ], 'CustomerGateway' => [ 'base' => '<p>Describes a customer gateway.</p>', 'refs' => [ 'CreateCustomerGatewayResult$CustomerGateway' => '<p>Information about the customer gateway.</p>', 'CustomerGatewayList$member' => NULL, ], ], 'CustomerGatewayIdStringList' => [ 'base' => NULL, 'refs' => [ 'DescribeCustomerGatewaysRequest$CustomerGatewayIds' => '<p>One or more customer gateway IDs.</p> <p>Default: Describes all your customer gateways.</p>', ], ], 'CustomerGatewayList' => [ 'base' => NULL, 'refs' => [ 'DescribeCustomerGatewaysResult$CustomerGateways' => '<p>Information about one or more customer gateways.</p>', ], ], 'DatafeedSubscriptionState' => [ 'base' => NULL, 'refs' => [ 'SpotDatafeedSubscription$State' => '<p>The state of the Spot instance data feed subscription.</p>', ], ], 'DateTime' => [ 'base' => NULL, 'refs' => [ 'BundleTask$StartTime' => '<p>The time this task started.</p>', 'BundleTask$UpdateTime' => '<p>The time of the most recent update for the task.</p>', 'ClientData$UploadStart' => '<p>The time that the disk upload starts.</p>', 'ClientData$UploadEnd' => '<p>The time that the disk upload ends.</p>', 'DescribeSpotFleetRequestHistoryRequest$StartTime' => '<p>The starting date and time for the events, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>', 'DescribeSpotFleetRequestHistoryResponse$StartTime' => '<p>The starting date and time for the events, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>', 'DescribeSpotFleetRequestHistoryResponse$LastEvaluatedTime' => '<p>The last date and time for the events, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). All records up to this time were retrieved.</p> <p>If <code>nextToken</code> indicates that there are more results, this value is not present.</p>', 'DescribeSpotPriceHistoryRequest$StartTime' => '<p>The date and time, up to the past 90 days, from which to start retrieving the price history data, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>', 'DescribeSpotPriceHistoryRequest$EndTime' => '<p>The date and time, up to the current date, from which to stop retrieving the price history data, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>', 'EbsInstanceBlockDevice$AttachTime' => '<p>The time stamp when the attachment initiated.</p>', 'FlowLog$CreationTime' => '<p>The date and time the flow log was created.</p>', 'GetConsoleOutputResult$Timestamp' => '<p>The time the output was last updated.</p>', 'GetPasswordDataResult$Timestamp' => '<p>The time the data was last updated.</p>', 'GetReservedInstancesExchangeQuoteResult$OutputReservedInstancesWillExpireAt' => '<p>The new end date of the reservation term.</p>', 'HistoryRecord$Timestamp' => '<p>The date and time of the event, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>', 'HostReservation$End' => '<p>The date and time that the reservation ends.</p>', 'HostReservation$Start' => '<p>The date and time that the reservation started.</p>', 'IdFormat$Deadline' => '<p>The date in UTC at which you are permanently switched over to using longer IDs. If a deadline is not yet available for this resource type, this field is not returned.</p>', 'Instance$LaunchTime' => '<p>The time the instance was launched.</p>', 'InstanceNetworkInterfaceAttachment$AttachTime' => '<p>The time stamp when the attachment initiated.</p>', 'InstanceStatusDetails$ImpairedSince' => '<p>The time when a status check failed. For an instance that was launched and impaired, this is the time when the instance was launched.</p>', 'InstanceStatusEvent$NotBefore' => '<p>The earliest scheduled start time for the event.</p>', 'InstanceStatusEvent$NotAfter' => '<p>The latest scheduled end time for the event.</p>', 'NatGateway$CreateTime' => '<p>The date and time the NAT gateway was created.</p>', 'NatGateway$DeleteTime' => '<p>The date and time the NAT gateway was deleted, if applicable.</p>', 'NetworkInterfaceAttachment$AttachTime' => '<p>The timestamp indicating when the attachment initiated.</p>', 'ProvisionedBandwidth$RequestTime' => '<p>Reserved. If you need to sustain traffic greater than the <a href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/vpc-nat-gateway.html">documented limits</a>, contact us through the <a href="https://console.aws.amazon.com/support/home?">Support Center</a>.</p>', 'ProvisionedBandwidth$ProvisionTime' => '<p>Reserved. If you need to sustain traffic greater than the <a href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/vpc-nat-gateway.html">documented limits</a>, contact us through the <a href="https://console.aws.amazon.com/support/home?">Support Center</a>.</p>', 'ReportInstanceStatusRequest$StartTime' => '<p>The time at which the reported instance health state began.</p>', 'ReportInstanceStatusRequest$EndTime' => '<p>The time at which the reported instance health state ended.</p>', 'RequestSpotInstancesRequest$ValidFrom' => '<p>The start date of the request. If this is a one-time request, the request becomes active at this date and time and remains active until all instances launch, the request expires, or the request is canceled. If the request is persistent, the request becomes active at this date and time and remains active until it expires or is canceled.</p> <p>Default: The request is effective indefinitely.</p>', 'RequestSpotInstancesRequest$ValidUntil' => '<p>The end date of the request. If this is a one-time request, the request remains active until all instances launch, the request is canceled, or this date is reached. If the request is persistent, it remains active until it is canceled or this date and time is reached.</p> <p>Default: The request is effective indefinitely.</p>', 'ReservedInstances$Start' => '<p>The date and time the Reserved Instance started.</p>', 'ReservedInstances$End' => '<p>The time when the Reserved Instance expires.</p>', 'ReservedInstancesListing$CreateDate' => '<p>The time the listing was created.</p>', 'ReservedInstancesListing$UpdateDate' => '<p>The last modified timestamp of the listing.</p>', 'ReservedInstancesModification$CreateDate' => '<p>The time when the modification request was created.</p>', 'ReservedInstancesModification$UpdateDate' => '<p>The time when the modification request was last updated.</p>', 'ReservedInstancesModification$EffectiveDate' => '<p>The time for the modification to become effective.</p>', 'ScheduledInstance$PreviousSlotEndTime' => '<p>The time that the previous schedule ended or will end.</p>', 'ScheduledInstance$NextSlotStartTime' => '<p>The time for the next schedule to start.</p>', 'ScheduledInstance$TermStartDate' => '<p>The start date for the Scheduled Instance.</p>', 'ScheduledInstance$TermEndDate' => '<p>The end date for the Scheduled Instance.</p>', 'ScheduledInstance$CreateDate' => '<p>The date when the Scheduled Instance was purchased.</p>', 'ScheduledInstanceAvailability$FirstSlotStartTime' => '<p>The time period for the first schedule to start.</p>', 'SlotDateTimeRangeRequest$EarliestTime' => '<p>The earliest date and time, in UTC, for the Scheduled Instance to start.</p>', 'SlotDateTimeRangeRequest$LatestTime' => '<p>The latest date and time, in UTC, for the Scheduled Instance to start. This value must be later than or equal to the earliest date and at most three months in the future.</p>', 'SlotStartTimeRangeRequest$EarliestTime' => '<p>The earliest date and time, in UTC, for the Scheduled Instance to start.</p>', 'SlotStartTimeRangeRequest$LatestTime' => '<p>The latest date and time, in UTC, for the Scheduled Instance to start.</p>', 'Snapshot$StartTime' => '<p>The time stamp when the snapshot was initiated.</p>', 'SpotFleetRequestConfig$CreateTime' => '<p>The creation date and time of the request.</p>', 'SpotFleetRequestConfigData$ValidFrom' => '<p>The start date and time of the request, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). The default is to start fulfilling the request immediately.</p>', 'SpotFleetRequestConfigData$ValidUntil' => '<p>The end date and time of the request, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). At this point, no new Spot instance requests are placed or enabled to fulfill the request.</p>', 'SpotInstanceRequest$ValidFrom' => '<p>The start date of the request, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). The request becomes active at this date and time.</p>', 'SpotInstanceRequest$ValidUntil' => '<p>The end date of the request, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). If this is a one-time request, it remains active until all instances launch, the request is canceled, or this date is reached. If the request is persistent, it remains active until it is canceled or this date is reached.</p>', 'SpotInstanceRequest$CreateTime' => '<p>The date and time when the Spot instance request was created, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>', 'SpotInstanceStatus$UpdateTime' => '<p>The date and time of the most recent status update, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>', 'SpotPrice$Timestamp' => '<p>The date and time the request was created, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>', 'VgwTelemetry$LastStatusChange' => '<p>The date and time of the last change in status.</p>', 'Volume$CreateTime' => '<p>The time stamp when volume creation was initiated.</p>', 'VolumeAttachment$AttachTime' => '<p>The time stamp when the attachment initiated.</p>', 'VolumeStatusEvent$NotBefore' => '<p>The earliest start time of the event.</p>', 'VolumeStatusEvent$NotAfter' => '<p>The latest end time of the event.</p>', 'VpcEndpoint$CreationTimestamp' => '<p>The date and time the VPC endpoint was created.</p>', 'VpcPeeringConnection$ExpirationTime' => '<p>The time that an unaccepted VPC peering connection will expire.</p>', ], ], 'DeleteCustomerGatewayRequest' => [ 'base' => '<p>Contains the parameters for DeleteCustomerGateway.</p>', 'refs' => [], ], 'DeleteDhcpOptionsRequest' => [ 'base' => '<p>Contains the parameters for DeleteDhcpOptions.</p>', 'refs' => [], ], 'DeleteFlowLogsRequest' => [ 'base' => '<p>Contains the parameters for DeleteFlowLogs.</p>', 'refs' => [], ], 'DeleteFlowLogsResult' => [ 'base' => '<p>Contains the output of DeleteFlowLogs.</p>', 'refs' => [], ], 'DeleteInternetGatewayRequest' => [ 'base' => '<p>Contains the parameters for DeleteInternetGateway.</p>', 'refs' => [], ], 'DeleteKeyPairRequest' => [ 'base' => '<p>Contains the parameters for DeleteKeyPair.</p>', 'refs' => [], ], 'DeleteNatGatewayRequest' => [ 'base' => '<p>Contains the parameters for DeleteNatGateway.</p>', 'refs' => [], ], 'DeleteNatGatewayResult' => [ 'base' => '<p>Contains the output of DeleteNatGateway.</p>', 'refs' => [], ], 'DeleteNetworkAclEntryRequest' => [ 'base' => '<p>Contains the parameters for DeleteNetworkAclEntry.</p>', 'refs' => [], ], 'DeleteNetworkAclRequest' => [ 'base' => '<p>Contains the parameters for DeleteNetworkAcl.</p>', 'refs' => [], ], 'DeleteNetworkInterfaceRequest' => [ 'base' => '<p>Contains the parameters for DeleteNetworkInterface.</p>', 'refs' => [], ], 'DeletePlacementGroupRequest' => [ 'base' => '<p>Contains the parameters for DeletePlacementGroup.</p>', 'refs' => [], ], 'DeleteRouteRequest' => [ 'base' => '<p>Contains the parameters for DeleteRoute.</p>', 'refs' => [], ], 'DeleteRouteTableRequest' => [ 'base' => '<p>Contains the parameters for DeleteRouteTable.</p>', 'refs' => [], ], 'DeleteSecurityGroupRequest' => [ 'base' => '<p>Contains the parameters for DeleteSecurityGroup.</p>', 'refs' => [], ], 'DeleteSnapshotRequest' => [ 'base' => '<p>Contains the parameters for DeleteSnapshot.</p>', 'refs' => [], ], 'DeleteSpotDatafeedSubscriptionRequest' => [ 'base' => '<p>Contains the parameters for DeleteSpotDatafeedSubscription.</p>', 'refs' => [], ], 'DeleteSubnetRequest' => [ 'base' => '<p>Contains the parameters for DeleteSubnet.</p>', 'refs' => [], ], 'DeleteTagsRequest' => [ 'base' => '<p>Contains the parameters for DeleteTags.</p>', 'refs' => [], ], 'DeleteVolumeRequest' => [ 'base' => '<p>Contains the parameters for DeleteVolume.</p>', 'refs' => [], ], 'DeleteVpcEndpointsRequest' => [ 'base' => '<p>Contains the parameters for DeleteVpcEndpoints.</p>', 'refs' => [], ], 'DeleteVpcEndpointsResult' => [ 'base' => '<p>Contains the output of DeleteVpcEndpoints.</p>', 'refs' => [], ], 'DeleteVpcPeeringConnectionRequest' => [ 'base' => '<p>Contains the parameters for DeleteVpcPeeringConnection.</p>', 'refs' => [], ], 'DeleteVpcPeeringConnectionResult' => [ 'base' => '<p>Contains the output of DeleteVpcPeeringConnection.</p>', 'refs' => [], ], 'DeleteVpcRequest' => [ 'base' => '<p>Contains the parameters for DeleteVpc.</p>', 'refs' => [], ], 'DeleteVpnConnectionRequest' => [ 'base' => '<p>Contains the parameters for DeleteVpnConnection.</p>', 'refs' => [], ], 'DeleteVpnConnectionRouteRequest' => [ 'base' => '<p>Contains the parameters for DeleteVpnConnectionRoute.</p>', 'refs' => [], ], 'DeleteVpnGatewayRequest' => [ 'base' => '<p>Contains the parameters for DeleteVpnGateway.</p>', 'refs' => [], ], 'DeregisterImageRequest' => [ 'base' => '<p>Contains the parameters for DeregisterImage.</p>', 'refs' => [], ], 'DescribeAccountAttributesRequest' => [ 'base' => '<p>Contains the parameters for DescribeAccountAttributes.</p>', 'refs' => [], ], 'DescribeAccountAttributesResult' => [ 'base' => '<p>Contains the output of DescribeAccountAttributes.</p>', 'refs' => [], ], 'DescribeAddressesRequest' => [ 'base' => '<p>Contains the parameters for DescribeAddresses.</p>', 'refs' => [], ], 'DescribeAddressesResult' => [ 'base' => '<p>Contains the output of DescribeAddresses.</p>', 'refs' => [], ], 'DescribeAvailabilityZonesRequest' => [ 'base' => '<p>Contains the parameters for DescribeAvailabilityZones.</p>', 'refs' => [], ], 'DescribeAvailabilityZonesResult' => [ 'base' => '<p>Contains the output of DescribeAvailabiltyZones.</p>', 'refs' => [], ], 'DescribeBundleTasksRequest' => [ 'base' => '<p>Contains the parameters for DescribeBundleTasks.</p>', 'refs' => [], ], 'DescribeBundleTasksResult' => [ 'base' => '<p>Contains the output of DescribeBundleTasks.</p>', 'refs' => [], ], 'DescribeClassicLinkInstancesRequest' => [ 'base' => '<p>Contains the parameters for DescribeClassicLinkInstances.</p>', 'refs' => [], ], 'DescribeClassicLinkInstancesResult' => [ 'base' => '<p>Contains the output of DescribeClassicLinkInstances.</p>', 'refs' => [], ], 'DescribeConversionTaskList' => [ 'base' => NULL, 'refs' => [ 'DescribeConversionTasksResult$ConversionTasks' => '<p>Information about the conversion tasks.</p>', ], ], 'DescribeConversionTasksRequest' => [ 'base' => '<p>Contains the parameters for DescribeConversionTasks.</p>', 'refs' => [], ], 'DescribeConversionTasksResult' => [ 'base' => '<p>Contains the output for DescribeConversionTasks.</p>', 'refs' => [], ], 'DescribeCustomerGatewaysRequest' => [ 'base' => '<p>Contains the parameters for DescribeCustomerGateways.</p>', 'refs' => [], ], 'DescribeCustomerGatewaysResult' => [ 'base' => '<p>Contains the output of DescribeCustomerGateways.</p>', 'refs' => [], ], 'DescribeDhcpOptionsRequest' => [ 'base' => '<p>Contains the parameters for DescribeDhcpOptions.</p>', 'refs' => [], ], 'DescribeDhcpOptionsResult' => [ 'base' => '<p>Contains the output of DescribeDhcpOptions.</p>', 'refs' => [], ], 'DescribeExportTasksRequest' => [ 'base' => '<p>Contains the parameters for DescribeExportTasks.</p>', 'refs' => [], ], 'DescribeExportTasksResult' => [ 'base' => '<p>Contains the output for DescribeExportTasks.</p>', 'refs' => [], ], 'DescribeFlowLogsRequest' => [ 'base' => '<p>Contains the parameters for DescribeFlowLogs.</p>', 'refs' => [], ], 'DescribeFlowLogsResult' => [ 'base' => '<p>Contains the output of DescribeFlowLogs.</p>', 'refs' => [], ], 'DescribeHostReservationOfferingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeHostReservationOfferingsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeHostReservationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeHostReservationsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeHostsRequest' => [ 'base' => '<p>Contains the parameters for DescribeHosts.</p>', 'refs' => [], ], 'DescribeHostsResult' => [ 'base' => '<p>Contains the output of DescribeHosts.</p>', 'refs' => [], ], 'DescribeIdFormatRequest' => [ 'base' => '<p>Contains the parameters for DescribeIdFormat.</p>', 'refs' => [], ], 'DescribeIdFormatResult' => [ 'base' => '<p>Contains the output of DescribeIdFormat.</p>', 'refs' => [], ], 'DescribeIdentityIdFormatRequest' => [ 'base' => '<p>Contains the parameters for DescribeIdentityIdFormat.</p>', 'refs' => [], ], 'DescribeIdentityIdFormatResult' => [ 'base' => '<p>Contains the output of DescribeIdentityIdFormat.</p>', 'refs' => [], ], 'DescribeImageAttributeRequest' => [ 'base' => '<p>Contains the parameters for DescribeImageAttribute.</p>', 'refs' => [], ], 'DescribeImagesRequest' => [ 'base' => '<p>Contains the parameters for DescribeImages.</p>', 'refs' => [], ], 'DescribeImagesResult' => [ 'base' => '<p>Contains the output of DescribeImages.</p>', 'refs' => [], ], 'DescribeImportImageTasksRequest' => [ 'base' => '<p>Contains the parameters for DescribeImportImageTasks.</p>', 'refs' => [], ], 'DescribeImportImageTasksResult' => [ 'base' => '<p>Contains the output for DescribeImportImageTasks.</p>', 'refs' => [], ], 'DescribeImportSnapshotTasksRequest' => [ 'base' => '<p>Contains the parameters for DescribeImportSnapshotTasks.</p>', 'refs' => [], ], 'DescribeImportSnapshotTasksResult' => [ 'base' => '<p>Contains the output for DescribeImportSnapshotTasks.</p>', 'refs' => [], ], 'DescribeInstanceAttributeRequest' => [ 'base' => '<p>Contains the parameters for DescribeInstanceAttribute.</p>', 'refs' => [], ], 'DescribeInstanceStatusRequest' => [ 'base' => '<p>Contains the parameters for DescribeInstanceStatus.</p>', 'refs' => [], ], 'DescribeInstanceStatusResult' => [ 'base' => '<p>Contains the output of DescribeInstanceStatus.</p>', 'refs' => [], ], 'DescribeInstancesRequest' => [ 'base' => '<p>Contains the parameters for DescribeInstances.</p>', 'refs' => [], ], 'DescribeInstancesResult' => [ 'base' => '<p>Contains the output of DescribeInstances.</p>', 'refs' => [], ], 'DescribeInternetGatewaysRequest' => [ 'base' => '<p>Contains the parameters for DescribeInternetGateways.</p>', 'refs' => [], ], 'DescribeInternetGatewaysResult' => [ 'base' => '<p>Contains the output of DescribeInternetGateways.</p>', 'refs' => [], ], 'DescribeKeyPairsRequest' => [ 'base' => '<p>Contains the parameters for DescribeKeyPairs.</p>', 'refs' => [], ], 'DescribeKeyPairsResult' => [ 'base' => '<p>Contains the output of DescribeKeyPairs.</p>', 'refs' => [], ], 'DescribeMovingAddressesRequest' => [ 'base' => '<p>Contains the parameters for DescribeMovingAddresses.</p>', 'refs' => [], ], 'DescribeMovingAddressesResult' => [ 'base' => '<p>Contains the output of DescribeMovingAddresses.</p>', 'refs' => [], ], 'DescribeNatGatewaysRequest' => [ 'base' => '<p>Contains the parameters for DescribeNatGateways.</p>', 'refs' => [], ], 'DescribeNatGatewaysResult' => [ 'base' => '<p>Contains the output of DescribeNatGateways.</p>', 'refs' => [], ], 'DescribeNetworkAclsRequest' => [ 'base' => '<p>Contains the parameters for DescribeNetworkAcls.</p>', 'refs' => [], ], 'DescribeNetworkAclsResult' => [ 'base' => '<p>Contains the output of DescribeNetworkAcls.</p>', 'refs' => [], ], 'DescribeNetworkInterfaceAttributeRequest' => [ 'base' => '<p>Contains the parameters for DescribeNetworkInterfaceAttribute.</p>', 'refs' => [], ], 'DescribeNetworkInterfaceAttributeResult' => [ 'base' => '<p>Contains the output of DescribeNetworkInterfaceAttribute.</p>', 'refs' => [], ], 'DescribeNetworkInterfacesRequest' => [ 'base' => '<p>Contains the parameters for DescribeNetworkInterfaces.</p>', 'refs' => [], ], 'DescribeNetworkInterfacesResult' => [ 'base' => '<p>Contains the output of DescribeNetworkInterfaces.</p>', 'refs' => [], ], 'DescribePlacementGroupsRequest' => [ 'base' => '<p>Contains the parameters for DescribePlacementGroups.</p>', 'refs' => [], ], 'DescribePlacementGroupsResult' => [ 'base' => '<p>Contains the output of DescribePlacementGroups.</p>', 'refs' => [], ], 'DescribePrefixListsRequest' => [ 'base' => '<p>Contains the parameters for DescribePrefixLists.</p>', 'refs' => [], ], 'DescribePrefixListsResult' => [ 'base' => '<p>Contains the output of DescribePrefixLists.</p>', 'refs' => [], ], 'DescribeRegionsRequest' => [ 'base' => '<p>Contains the parameters for DescribeRegions.</p>', 'refs' => [], ], 'DescribeRegionsResult' => [ 'base' => '<p>Contains the output of DescribeRegions.</p>', 'refs' => [], ], 'DescribeReservedInstancesListingsRequest' => [ 'base' => '<p>Contains the parameters for DescribeReservedInstancesListings.</p>', 'refs' => [], ], 'DescribeReservedInstancesListingsResult' => [ 'base' => '<p>Contains the output of DescribeReservedInstancesListings.</p>', 'refs' => [], ], 'DescribeReservedInstancesModificationsRequest' => [ 'base' => '<p>Contains the parameters for DescribeReservedInstancesModifications.</p>', 'refs' => [], ], 'DescribeReservedInstancesModificationsResult' => [ 'base' => '<p>Contains the output of DescribeReservedInstancesModifications.</p>', 'refs' => [], ], 'DescribeReservedInstancesOfferingsRequest' => [ 'base' => '<p>Contains the parameters for DescribeReservedInstancesOfferings.</p>', 'refs' => [], ], 'DescribeReservedInstancesOfferingsResult' => [ 'base' => '<p>Contains the output of DescribeReservedInstancesOfferings.</p>', 'refs' => [], ], 'DescribeReservedInstancesRequest' => [ 'base' => '<p>Contains the parameters for DescribeReservedInstances.</p>', 'refs' => [], ], 'DescribeReservedInstancesResult' => [ 'base' => '<p>Contains the output for DescribeReservedInstances.</p>', 'refs' => [], ], 'DescribeRouteTablesRequest' => [ 'base' => '<p>Contains the parameters for DescribeRouteTables.</p>', 'refs' => [], ], 'DescribeRouteTablesResult' => [ 'base' => '<p>Contains the output of DescribeRouteTables.</p>', 'refs' => [], ], 'DescribeScheduledInstanceAvailabilityRequest' => [ 'base' => '<p>Contains the parameters for DescribeScheduledInstanceAvailability.</p>', 'refs' => [], ], 'DescribeScheduledInstanceAvailabilityResult' => [ 'base' => '<p>Contains the output of DescribeScheduledInstanceAvailability.</p>', 'refs' => [], ], 'DescribeScheduledInstancesRequest' => [ 'base' => '<p>Contains the parameters for DescribeScheduledInstances.</p>', 'refs' => [], ], 'DescribeScheduledInstancesResult' => [ 'base' => '<p>Contains the output of DescribeScheduledInstances.</p>', 'refs' => [], ], 'DescribeSecurityGroupReferencesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSecurityGroupReferencesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSecurityGroupsRequest' => [ 'base' => '<p>Contains the parameters for DescribeSecurityGroups.</p>', 'refs' => [], ], 'DescribeSecurityGroupsResult' => [ 'base' => '<p>Contains the output of DescribeSecurityGroups.</p>', 'refs' => [], ], 'DescribeSnapshotAttributeRequest' => [ 'base' => '<p>Contains the parameters for DescribeSnapshotAttribute.</p>', 'refs' => [], ], 'DescribeSnapshotAttributeResult' => [ 'base' => '<p>Contains the output of DescribeSnapshotAttribute.</p>', 'refs' => [], ], 'DescribeSnapshotsRequest' => [ 'base' => '<p>Contains the parameters for DescribeSnapshots.</p>', 'refs' => [], ], 'DescribeSnapshotsResult' => [ 'base' => '<p>Contains the output of DescribeSnapshots.</p>', 'refs' => [], ], 'DescribeSpotDatafeedSubscriptionRequest' => [ 'base' => '<p>Contains the parameters for DescribeSpotDatafeedSubscription.</p>', 'refs' => [], ], 'DescribeSpotDatafeedSubscriptionResult' => [ 'base' => '<p>Contains the output of DescribeSpotDatafeedSubscription.</p>', 'refs' => [], ], 'DescribeSpotFleetInstancesRequest' => [ 'base' => '<p>Contains the parameters for DescribeSpotFleetInstances.</p>', 'refs' => [], ], 'DescribeSpotFleetInstancesResponse' => [ 'base' => '<p>Contains the output of DescribeSpotFleetInstances.</p>', 'refs' => [], ], 'DescribeSpotFleetRequestHistoryRequest' => [ 'base' => '<p>Contains the parameters for DescribeSpotFleetRequestHistory.</p>', 'refs' => [], ], 'DescribeSpotFleetRequestHistoryResponse' => [ 'base' => '<p>Contains the output of DescribeSpotFleetRequestHistory.</p>', 'refs' => [], ], 'DescribeSpotFleetRequestsRequest' => [ 'base' => '<p>Contains the parameters for DescribeSpotFleetRequests.</p>', 'refs' => [], ], 'DescribeSpotFleetRequestsResponse' => [ 'base' => '<p>Contains the output of DescribeSpotFleetRequests.</p>', 'refs' => [], ], 'DescribeSpotInstanceRequestsRequest' => [ 'base' => '<p>Contains the parameters for DescribeSpotInstanceRequests.</p>', 'refs' => [], ], 'DescribeSpotInstanceRequestsResult' => [ 'base' => '<p>Contains the output of DescribeSpotInstanceRequests.</p>', 'refs' => [], ], 'DescribeSpotPriceHistoryRequest' => [ 'base' => '<p>Contains the parameters for DescribeSpotPriceHistory.</p>', 'refs' => [], ], 'DescribeSpotPriceHistoryResult' => [ 'base' => '<p>Contains the output of DescribeSpotPriceHistory.</p>', 'refs' => [], ], 'DescribeStaleSecurityGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStaleSecurityGroupsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSubnetsRequest' => [ 'base' => '<p>Contains the parameters for DescribeSubnets.</p>', 'refs' => [], ], 'DescribeSubnetsResult' => [ 'base' => '<p>Contains the output of DescribeSubnets.</p>', 'refs' => [], ], 'DescribeTagsRequest' => [ 'base' => '<p>Contains the parameters for DescribeTags.</p>', 'refs' => [], ], 'DescribeTagsResult' => [ 'base' => '<p>Contains the output of DescribeTags.</p>', 'refs' => [], ], 'DescribeVolumeAttributeRequest' => [ 'base' => '<p>Contains the parameters for DescribeVolumeAttribute.</p>', 'refs' => [], ], 'DescribeVolumeAttributeResult' => [ 'base' => '<p>Contains the output of DescribeVolumeAttribute.</p>', 'refs' => [], ], 'DescribeVolumeStatusRequest' => [ 'base' => '<p>Contains the parameters for DescribeVolumeStatus.</p>', 'refs' => [], ], 'DescribeVolumeStatusResult' => [ 'base' => '<p>Contains the output of DescribeVolumeStatus.</p>', 'refs' => [], ], 'DescribeVolumesRequest' => [ 'base' => '<p>Contains the parameters for DescribeVolumes.</p>', 'refs' => [], ], 'DescribeVolumesResult' => [ 'base' => '<p>Contains the output of DescribeVolumes.</p>', 'refs' => [], ], 'DescribeVpcAttributeRequest' => [ 'base' => '<p>Contains the parameters for DescribeVpcAttribute.</p>', 'refs' => [], ], 'DescribeVpcAttributeResult' => [ 'base' => '<p>Contains the output of DescribeVpcAttribute.</p>', 'refs' => [], ], 'DescribeVpcClassicLinkDnsSupportRequest' => [ 'base' => '<p>Contains the parameters for DescribeVpcClassicLinkDnsSupport.</p>', 'refs' => [], ], 'DescribeVpcClassicLinkDnsSupportResult' => [ 'base' => '<p>Contains the output of DescribeVpcClassicLinkDnsSupport.</p>', 'refs' => [], ], 'DescribeVpcClassicLinkRequest' => [ 'base' => '<p>Contains the parameters for DescribeVpcClassicLink.</p>', 'refs' => [], ], 'DescribeVpcClassicLinkResult' => [ 'base' => '<p>Contains the output of DescribeVpcClassicLink.</p>', 'refs' => [], ], 'DescribeVpcEndpointServicesRequest' => [ 'base' => '<p>Contains the parameters for DescribeVpcEndpointServices.</p>', 'refs' => [], ], 'DescribeVpcEndpointServicesResult' => [ 'base' => '<p>Contains the output of DescribeVpcEndpointServices.</p>', 'refs' => [], ], 'DescribeVpcEndpointsRequest' => [ 'base' => '<p>Contains the parameters for DescribeVpcEndpoints.</p>', 'refs' => [], ], 'DescribeVpcEndpointsResult' => [ 'base' => '<p>Contains the output of DescribeVpcEndpoints.</p>', 'refs' => [], ], 'DescribeVpcPeeringConnectionsRequest' => [ 'base' => '<p>Contains the parameters for DescribeVpcPeeringConnections.</p>', 'refs' => [], ], 'DescribeVpcPeeringConnectionsResult' => [ 'base' => '<p>Contains the output of DescribeVpcPeeringConnections.</p>', 'refs' => [], ], 'DescribeVpcsRequest' => [ 'base' => '<p>Contains the parameters for DescribeVpcs.</p>', 'refs' => [], ], 'DescribeVpcsResult' => [ 'base' => '<p>Contains the output of DescribeVpcs.</p>', 'refs' => [], ], 'DescribeVpnConnectionsRequest' => [ 'base' => '<p>Contains the parameters for DescribeVpnConnections.</p>', 'refs' => [], ], 'DescribeVpnConnectionsResult' => [ 'base' => '<p>Contains the output of DescribeVpnConnections.</p>', 'refs' => [], ], 'DescribeVpnGatewaysRequest' => [ 'base' => '<p>Contains the parameters for DescribeVpnGateways.</p>', 'refs' => [], ], 'DescribeVpnGatewaysResult' => [ 'base' => '<p>Contains the output of DescribeVpnGateways.</p>', 'refs' => [], ], 'DetachClassicLinkVpcRequest' => [ 'base' => '<p>Contains the parameters for DetachClassicLinkVpc.</p>', 'refs' => [], ], 'DetachClassicLinkVpcResult' => [ 'base' => '<p>Contains the output of DetachClassicLinkVpc.</p>', 'refs' => [], ], 'DetachInternetGatewayRequest' => [ 'base' => '<p>Contains the parameters for DetachInternetGateway.</p>', 'refs' => [], ], 'DetachNetworkInterfaceRequest' => [ 'base' => '<p>Contains the parameters for DetachNetworkInterface.</p>', 'refs' => [], ], 'DetachVolumeRequest' => [ 'base' => '<p>Contains the parameters for DetachVolume.</p>', 'refs' => [], ], 'DetachVpnGatewayRequest' => [ 'base' => '<p>Contains the parameters for DetachVpnGateway.</p>', 'refs' => [], ], 'DeviceType' => [ 'base' => NULL, 'refs' => [ 'Image$RootDeviceType' => '<p>The type of root device used by the AMI. The AMI can use an EBS volume or an instance store volume.</p>', 'Instance$RootDeviceType' => '<p>The root device type used by the AMI. The AMI can use an EBS volume or an instance store volume.</p>', ], ], 'DhcpConfiguration' => [ 'base' => '<p>Describes a DHCP configuration option.</p>', 'refs' => [ 'DhcpConfigurationList$member' => NULL, ], ], 'DhcpConfigurationList' => [ 'base' => NULL, 'refs' => [ 'DhcpOptions$DhcpConfigurations' => '<p>One or more DHCP options in the set.</p>', ], ], 'DhcpConfigurationValueList' => [ 'base' => NULL, 'refs' => [ 'DhcpConfiguration$Values' => '<p>One or more values for the DHCP option.</p>', ], ], 'DhcpOptions' => [ 'base' => '<p>Describes a set of DHCP options.</p>', 'refs' => [ 'CreateDhcpOptionsResult$DhcpOptions' => '<p>A set of DHCP options.</p>', 'DhcpOptionsList$member' => NULL, ], ], 'DhcpOptionsIdStringList' => [ 'base' => NULL, 'refs' => [ 'DescribeDhcpOptionsRequest$DhcpOptionsIds' => '<p>The IDs of one or more DHCP options sets.</p> <p>Default: Describes all your DHCP options sets.</p>', ], ], 'DhcpOptionsList' => [ 'base' => NULL, 'refs' => [ 'DescribeDhcpOptionsResult$DhcpOptions' => '<p>Information about one or more DHCP options sets.</p>', ], ], 'DisableVgwRoutePropagationRequest' => [ 'base' => '<p>Contains the parameters for DisableVgwRoutePropagation.</p>', 'refs' => [], ], 'DisableVpcClassicLinkDnsSupportRequest' => [ 'base' => '<p>Contains the parameters for DisableVpcClassicLinkDnsSupport.</p>', 'refs' => [], ], 'DisableVpcClassicLinkDnsSupportResult' => [ 'base' => '<p>Contains the output of DisableVpcClassicLinkDnsSupport.</p>', 'refs' => [], ], 'DisableVpcClassicLinkRequest' => [ 'base' => '<p>Contains the parameters for DisableVpcClassicLink.</p>', 'refs' => [], ], 'DisableVpcClassicLinkResult' => [ 'base' => '<p>Contains the output of DisableVpcClassicLink.</p>', 'refs' => [], ], 'DisassociateAddressRequest' => [ 'base' => '<p>Contains the parameters for DisassociateAddress.</p>', 'refs' => [], ], 'DisassociateRouteTableRequest' => [ 'base' => '<p>Contains the parameters for DisassociateRouteTable.</p>', 'refs' => [], ], 'DiskImage' => [ 'base' => '<p>Describes a disk image.</p>', 'refs' => [ 'DiskImageList$member' => NULL, ], ], 'DiskImageDescription' => [ 'base' => '<p>Describes a disk image.</p>', 'refs' => [ 'ImportInstanceVolumeDetailItem$Image' => '<p>The image.</p>', 'ImportVolumeTaskDetails$Image' => '<p>The image.</p>', ], ], 'DiskImageDetail' => [ 'base' => '<p>Describes a disk image.</p>', 'refs' => [ 'DiskImage$Image' => '<p>Information about the disk image.</p>', 'ImportVolumeRequest$Image' => '<p>The disk image.</p>', ], ], 'DiskImageFormat' => [ 'base' => NULL, 'refs' => [ 'DiskImageDescription$Format' => '<p>The disk image format.</p>', 'DiskImageDetail$Format' => '<p>The disk image format.</p>', 'ExportToS3Task$DiskImageFormat' => '<p>The format for the exported image.</p>', 'ExportToS3TaskSpecification$DiskImageFormat' => '<p>The format for the exported image.</p>', ], ], 'DiskImageList' => [ 'base' => NULL, 'refs' => [ 'ImportInstanceRequest$DiskImages' => '<p>The disk image.</p>', ], ], 'DiskImageVolumeDescription' => [ 'base' => '<p>Describes a disk image volume.</p>', 'refs' => [ 'ImportInstanceVolumeDetailItem$Volume' => '<p>The volume.</p>', 'ImportVolumeTaskDetails$Volume' => '<p>The volume.</p>', ], ], 'DomainType' => [ 'base' => NULL, 'refs' => [ 'Address$Domain' => '<p>Indicates whether this Elastic IP address is for use with instances in EC2-Classic (<code>standard</code>) or instances in a VPC (<code>vpc</code>).</p>', 'AllocateAddressRequest$Domain' => '<p>Set to <code>vpc</code> to allocate the address for use with instances in a VPC.</p> <p>Default: The address is for use with instances in EC2-Classic.</p>', 'AllocateAddressResult$Domain' => '<p>Indicates whether this Elastic IP address is for use with instances in EC2-Classic (<code>standard</code>) or instances in a VPC (<code>vpc</code>).</p>', ], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'ClientData$UploadSize' => '<p>The size of the uploaded disk image, in GiB.</p>', 'PriceSchedule$Price' => '<p>The fixed price for the term.</p>', 'PriceScheduleSpecification$Price' => '<p>The fixed price for the term.</p>', 'PricingDetail$Price' => '<p>The price per instance.</p>', 'RecurringCharge$Amount' => '<p>The amount of the recurring charge.</p>', 'ReservedInstanceLimitPrice$Amount' => '<p>Used for Reserved Instance Marketplace offerings. Specifies the limit price on the total order (instanceCount * price).</p>', 'SnapshotDetail$DiskImageSize' => '<p>The size of the disk in the snapshot, in GiB.</p>', 'SnapshotTaskDetail$DiskImageSize' => '<p>The size of the disk in the snapshot, in GiB.</p>', 'SpotFleetLaunchSpecification$WeightedCapacity' => '<p>The number of units provided by the specified instance type. These are the same units that you chose to set the target capacity in terms (instances or a performance characteristic such as vCPUs, memory, or I/O).</p> <p>If the target capacity divided by this value is not a whole number, we round the number of instances to the next whole number. If this value is not specified, the default is 1.</p>', 'SpotFleetRequestConfigData$FulfilledCapacity' => '<p>The number of units fulfilled by this request compared to the set target capacity.</p>', ], ], 'EbsBlockDevice' => [ 'base' => '<p>Describes a block device for an EBS volume.</p>', 'refs' => [ 'BlockDeviceMapping$Ebs' => '<p>Parameters used to automatically set up EBS volumes when the instance is launched.</p>', ], ], 'EbsInstanceBlockDevice' => [ 'base' => '<p>Describes a parameter used to set up an EBS volume in a block device mapping.</p>', 'refs' => [ 'InstanceBlockDeviceMapping$Ebs' => '<p>Parameters used to automatically set up EBS volumes when the instance is launched.</p>', ], ], 'EbsInstanceBlockDeviceSpecification' => [ 'base' => '<p>Describes information used to set up an EBS volume specified in a block device mapping.</p>', 'refs' => [ 'InstanceBlockDeviceMappingSpecification$Ebs' => '<p>Parameters used to automatically set up EBS volumes when the instance is launched.</p>', ], ], 'EnableVgwRoutePropagationRequest' => [ 'base' => '<p>Contains the parameters for EnableVgwRoutePropagation.</p>', 'refs' => [], ], 'EnableVolumeIORequest' => [ 'base' => '<p>Contains the parameters for EnableVolumeIO.</p>', 'refs' => [], ], 'EnableVpcClassicLinkDnsSupportRequest' => [ 'base' => '<p>Contains the parameters for EnableVpcClassicLinkDnsSupport.</p>', 'refs' => [], ], 'EnableVpcClassicLinkDnsSupportResult' => [ 'base' => '<p>Contains the output of EnableVpcClassicLinkDnsSupport.</p>', 'refs' => [], ], 'EnableVpcClassicLinkRequest' => [ 'base' => '<p>Contains the parameters for EnableVpcClassicLink.</p>', 'refs' => [], ], 'EnableVpcClassicLinkResult' => [ 'base' => '<p>Contains the output of EnableVpcClassicLink.</p>', 'refs' => [], ], 'EventCode' => [ 'base' => NULL, 'refs' => [ 'InstanceStatusEvent$Code' => '<p>The event code.</p>', ], ], 'EventInformation' => [ 'base' => '<p>Describes a Spot fleet event.</p>', 'refs' => [ 'HistoryRecord$EventInformation' => '<p>Information about the event.</p>', ], ], 'EventType' => [ 'base' => NULL, 'refs' => [ 'DescribeSpotFleetRequestHistoryRequest$EventType' => '<p>The type of events to describe. By default, all events are described.</p>', 'HistoryRecord$EventType' => '<p>The event type.</p> <ul> <li> <p> <code>error</code> - Indicates an error with the Spot fleet request.</p> </li> <li> <p> <code>fleetRequestChange</code> - Indicates a change in the status or configuration of the Spot fleet request.</p> </li> <li> <p> <code>instanceChange</code> - Indicates that an instance was launched or terminated.</p> </li> </ul>', ], ], 'ExcessCapacityTerminationPolicy' => [ 'base' => NULL, 'refs' => [ 'ModifySpotFleetRequestRequest$ExcessCapacityTerminationPolicy' => '<p>Indicates whether running Spot instances should be terminated if the target capacity of the Spot fleet request is decreased below the current size of the Spot fleet.</p>', 'SpotFleetRequestConfigData$ExcessCapacityTerminationPolicy' => '<p>Indicates whether running Spot instances should be terminated if the target capacity of the Spot fleet request is decreased below the current size of the Spot fleet.</p>', ], ], 'ExecutableByStringList' => [ 'base' => NULL, 'refs' => [ 'DescribeImagesRequest$ExecutableUsers' => '<p>Scopes the images by users with explicit launch permissions. Specify an AWS account ID, <code>self</code> (the sender of the request), or <code>all</code> (public AMIs).</p>', ], ], 'ExportEnvironment' => [ 'base' => NULL, 'refs' => [ 'CreateInstanceExportTaskRequest$TargetEnvironment' => '<p>The target virtualization environment.</p>', 'InstanceExportDetails$TargetEnvironment' => '<p>The target virtualization environment.</p>', ], ], 'ExportTask' => [ 'base' => '<p>Describes an instance export task.</p>', 'refs' => [ 'CreateInstanceExportTaskResult$ExportTask' => '<p>Information about the instance export task.</p>', 'ExportTaskList$member' => NULL, ], ], 'ExportTaskIdStringList' => [ 'base' => NULL, 'refs' => [ 'DescribeExportTasksRequest$ExportTaskIds' => '<p>One or more export task IDs.</p>', ], ], 'ExportTaskList' => [ 'base' => NULL, 'refs' => [ 'DescribeExportTasksResult$ExportTasks' => '<p>Information about the export tasks.</p>', ], ], 'ExportTaskState' => [ 'base' => NULL, 'refs' => [ 'ExportTask$State' => '<p>The state of the export task.</p>', ], ], 'ExportToS3Task' => [ 'base' => '<p>Describes the format and location for an instance export task.</p>', 'refs' => [ 'ExportTask$ExportToS3Task' => '<p>Information about the export task.</p>', ], ], 'ExportToS3TaskSpecification' => [ 'base' => '<p>Describes an instance export task.</p>', 'refs' => [ 'CreateInstanceExportTaskRequest$ExportToS3Task' => '<p>The format and location for an instance export task.</p>', ], ], 'Filter' => [ 'base' => '<p>A filter name and value pair that is used to return a more specific list of results. Filters can be used to match a set of resources by various criteria, such as tags, attributes, or IDs.</p>', 'refs' => [ 'FilterList$member' => NULL, ], ], 'FilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeAddressesRequest$Filters' => '<p>One or more filters. Filter names and values are case-sensitive.</p> <ul> <li> <p> <code>allocation-id</code> - [EC2-VPC] The allocation ID for the address.</p> </li> <li> <p> <code>association-id</code> - [EC2-VPC] The association ID for the address.</p> </li> <li> <p> <code>domain</code> - Indicates whether the address is for use in EC2-Classic (<code>standard</code>) or in a VPC (<code>vpc</code>).</p> </li> <li> <p> <code>instance-id</code> - The ID of the instance the address is associated with, if any.</p> </li> <li> <p> <code>network-interface-id</code> - [EC2-VPC] The ID of the network interface that the address is associated with, if any.</p> </li> <li> <p> <code>network-interface-owner-id</code> - The AWS account ID of the owner.</p> </li> <li> <p> <code>private-ip-address</code> - [EC2-VPC] The private IP address associated with the Elastic IP address.</p> </li> <li> <p> <code>public-ip</code> - The Elastic IP address.</p> </li> </ul>', 'DescribeAvailabilityZonesRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>message</code> - Information about the Availability Zone.</p> </li> <li> <p> <code>region-name</code> - The name of the region for the Availability Zone (for example, <code>us-east-1</code>).</p> </li> <li> <p> <code>state</code> - The state of the Availability Zone (<code>available</code> | <code>information</code> | <code>impaired</code> | <code>unavailable</code>).</p> </li> <li> <p> <code>zone-name</code> - The name of the Availability Zone (for example, <code>us-east-1a</code>).</p> </li> </ul>', 'DescribeBundleTasksRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>bundle-id</code> - The ID of the bundle task.</p> </li> <li> <p> <code>error-code</code> - If the task failed, the error code returned.</p> </li> <li> <p> <code>error-message</code> - If the task failed, the error message returned.</p> </li> <li> <p> <code>instance-id</code> - The ID of the instance.</p> </li> <li> <p> <code>progress</code> - The level of task completion, as a percentage (for example, 20%).</p> </li> <li> <p> <code>s3-bucket</code> - The Amazon S3 bucket to store the AMI.</p> </li> <li> <p> <code>s3-prefix</code> - The beginning of the AMI name.</p> </li> <li> <p> <code>start-time</code> - The time the task started (for example, 2013-09-15T17:15:20.000Z).</p> </li> <li> <p> <code>state</code> - The state of the task (<code>pending</code> | <code>waiting-for-shutdown</code> | <code>bundling</code> | <code>storing</code> | <code>cancelling</code> | <code>complete</code> | <code>failed</code>).</p> </li> <li> <p> <code>update-time</code> - The time of the most recent update for the task.</p> </li> </ul>', 'DescribeClassicLinkInstancesRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>group-id</code> - The ID of a VPC security group that\'s associated with the instance.</p> </li> <li> <p> <code>instance-id</code> - The ID of the instance.</p> </li> <li> <p> <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag\'s value is), and the tag value X (regardless of what the tag\'s key is). If you want to list only resources where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.</p> </li> <li> <p> <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the <code>tag-key</code> filter.</p> </li> <li> <p> <code>vpc-id</code> - The ID of the VPC that the instance is linked to.</p> </li> </ul>', 'DescribeCustomerGatewaysRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>bgp-asn</code> - The customer gateway\'s Border Gateway Protocol (BGP) Autonomous System Number (ASN).</p> </li> <li> <p> <code>customer-gateway-id</code> - The ID of the customer gateway.</p> </li> <li> <p> <code>ip-address</code> - The IP address of the customer gateway\'s Internet-routable external interface.</p> </li> <li> <p> <code>state</code> - The state of the customer gateway (<code>pending</code> | <code>available</code> | <code>deleting</code> | <code>deleted</code>).</p> </li> <li> <p> <code>type</code> - The type of customer gateway. Currently, the only supported type is <code>ipsec.1</code>.</p> </li> <li> <p> <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag\'s value is), and the tag value X (regardless of what the tag\'s key is). If you want to list only resources where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.</p> </li> <li> <p> <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the <code>tag-key</code> filter.</p> </li> </ul>', 'DescribeDhcpOptionsRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>dhcp-options-id</code> - The ID of a set of DHCP options.</p> </li> <li> <p> <code>key</code> - The key for one of the options (for example, <code>domain-name</code>).</p> </li> <li> <p> <code>value</code> - The value for one of the options.</p> </li> <li> <p> <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag\'s value is), and the tag value X (regardless of what the tag\'s key is). If you want to list only resources where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.</p> </li> <li> <p> <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the <code>tag-key</code> filter.</p> </li> </ul>', 'DescribeFlowLogsRequest$Filter' => '<p>One or more filters.</p> <ul> <li> <p> <code>deliver-log-status</code> - The status of the logs delivery (<code>SUCCESS</code> | <code>FAILED</code>).</p> </li> <li> <p> <code>flow-log-id</code> - The ID of the flow log.</p> </li> <li> <p> <code>log-group-name</code> - The name of the log group.</p> </li> <li> <p> <code>resource-id</code> - The ID of the VPC, subnet, or network interface.</p> </li> <li> <p> <code>traffic-type</code> - The type of traffic (<code>ACCEPT</code> | <code>REJECT</code> | <code>ALL</code>)</p> </li> </ul>', 'DescribeHostReservationOfferingsRequest$Filter' => '<p>One or more filters.</p> <ul> <li> <p> <code>instance-family</code> - The instance family of the offering (e.g., <code>m4</code>).</p> </li> <li> <p> <code>payment-option</code> - The payment option (<code>No Upfront</code> | <code>Partial Upfront</code> | <code>All Upfront</code>).</p> </li> </ul>', 'DescribeHostReservationsRequest$Filter' => '<p>One or more filters.</p> <ul> <li> <p> <code>instance-family</code> - The instance family (e.g., <code>m4</code>).</p> </li> <li> <p> <code>payment-option</code> - The payment option (<code>No Upfront</code> | <code>Partial Upfront</code> | <code>All Upfront</code>).</p> </li> <li> <p> <code>state</code> - The state of the reservation (<code>payment-pending</code> | <code>payment-failed</code> | <code>active</code> | <code>retired</code>).</p> </li> </ul>', 'DescribeHostsRequest$Filter' => '<p>One or more filters.</p> <ul> <li> <p> <code>instance-type</code> - The instance type size that the Dedicated Host is configured to support.</p> </li> <li> <p> <code>auto-placement</code> - Whether auto-placement is enabled or disabled (<code>on</code> | <code>off</code>).</p> </li> <li> <p> <code>host-reservation-id</code> - The ID of the reservation assigned to this host.</p> </li> <li> <p> <code>client-token</code> - The idempotency token you provided when you launched the instance</p> </li> <li> <p> <code>state</code>- The allocation state of the Dedicated Host (<code>available</code> | <code>under-assessment</code> | <code>permanent-failure</code> | <code>released</code> | <code>released-permanent-failure</code>).</p> </li> <li> <p> <code>availability-zone</code> - The Availability Zone of the host.</p> </li> </ul>', 'DescribeImagesRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>architecture</code> - The image architecture (<code>i386</code> | <code>x86_64</code>).</p> </li> <li> <p> <code>block-device-mapping.delete-on-termination</code> - A Boolean value that indicates whether the Amazon EBS volume is deleted on instance termination.</p> </li> <li> <p> <code>block-device-mapping.device-name</code> - The device name for the EBS volume (for example, <code>/dev/sdh</code>).</p> </li> <li> <p> <code>block-device-mapping.snapshot-id</code> - The ID of the snapshot used for the EBS volume.</p> </li> <li> <p> <code>block-device-mapping.volume-size</code> - The volume size of the EBS volume, in GiB.</p> </li> <li> <p> <code>block-device-mapping.volume-type</code> - The volume type of the EBS volume (<code>gp2</code> | <code>io1</code> | <code>st1 </code>| <code>sc1</code> | <code>standard</code>).</p> </li> <li> <p> <code>description</code> - The description of the image (provided during image creation).</p> </li> <li> <p> <code>hypervisor</code> - The hypervisor type (<code>ovm</code> | <code>xen</code>).</p> </li> <li> <p> <code>image-id</code> - The ID of the image.</p> </li> <li> <p> <code>image-type</code> - The image type (<code>machine</code> | <code>kernel</code> | <code>ramdisk</code>).</p> </li> <li> <p> <code>is-public</code> - A Boolean that indicates whether the image is public.</p> </li> <li> <p> <code>kernel-id</code> - The kernel ID.</p> </li> <li> <p> <code>manifest-location</code> - The location of the image manifest.</p> </li> <li> <p> <code>name</code> - The name of the AMI (provided during image creation).</p> </li> <li> <p> <code>owner-alias</code> - String value from an Amazon-maintained list (<code>amazon</code> | <code>aws-marketplace</code> | <code>microsoft</code>) of snapshot owners. Not to be confused with the user-configured AWS account alias, which is set from the IAM console.</p> </li> <li> <p> <code>owner-id</code> - The AWS account ID of the image owner.</p> </li> <li> <p> <code>platform</code> - The platform. To only list Windows-based AMIs, use <code>windows</code>.</p> </li> <li> <p> <code>product-code</code> - The product code.</p> </li> <li> <p> <code>product-code.type</code> - The type of the product code (<code>devpay</code> | <code>marketplace</code>).</p> </li> <li> <p> <code>ramdisk-id</code> - The RAM disk ID.</p> </li> <li> <p> <code>root-device-name</code> - The name of the root device volume (for example, <code>/dev/sda1</code>).</p> </li> <li> <p> <code>root-device-type</code> - The type of the root device volume (<code>ebs</code> | <code>instance-store</code>).</p> </li> <li> <p> <code>state</code> - The state of the image (<code>available</code> | <code>pending</code> | <code>failed</code>).</p> </li> <li> <p> <code>state-reason-code</code> - The reason code for the state change.</p> </li> <li> <p> <code>state-reason-message</code> - The message for the state change.</p> </li> <li> <p> <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the tag-value filter. For example, if you use both the filter "tag-key=Purpose" and the filter "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag\'s value is), and the tag value X (regardless of what the tag\'s key is). If you want to list only resources where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.</p> </li> <li> <p> <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the <code>tag-key</code> filter.</p> </li> <li> <p> <code>virtualization-type</code> - The virtualization type (<code>paravirtual</code> | <code>hvm</code>).</p> </li> </ul>', 'DescribeImportImageTasksRequest$Filters' => '<p>Filter tasks using the <code>task-state</code> filter and one of the following values: active, completed, deleting, deleted.</p>', 'DescribeImportSnapshotTasksRequest$Filters' => '<p>One or more filters.</p>', 'DescribeInstanceStatusRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>availability-zone</code> - The Availability Zone of the instance.</p> </li> <li> <p> <code>event.code</code> - The code for the scheduled event (<code>instance-reboot</code> | <code>system-reboot</code> | <code>system-maintenance</code> | <code>instance-retirement</code> | <code>instance-stop</code>).</p> </li> <li> <p> <code>event.description</code> - A description of the event.</p> </li> <li> <p> <code>event.not-after</code> - The latest end time for the scheduled event (for example, <code>2014-09-15T17:15:20.000Z</code>).</p> </li> <li> <p> <code>event.not-before</code> - The earliest start time for the scheduled event (for example, <code>2014-09-15T17:15:20.000Z</code>).</p> </li> <li> <p> <code>instance-state-code</code> - The code for the instance state, as a 16-bit unsigned integer. The high byte is an opaque internal value and should be ignored. The low byte is set based on the state represented. The valid values are 0 (pending), 16 (running), 32 (shutting-down), 48 (terminated), 64 (stopping), and 80 (stopped).</p> </li> <li> <p> <code>instance-state-name</code> - The state of the instance (<code>pending</code> | <code>running</code> | <code>shutting-down</code> | <code>terminated</code> | <code>stopping</code> | <code>stopped</code>).</p> </li> <li> <p> <code>instance-status.reachability</code> - Filters on instance status where the name is <code>reachability</code> (<code>passed</code> | <code>failed</code> | <code>initializing</code> | <code>insufficient-data</code>).</p> </li> <li> <p> <code>instance-status.status</code> - The status of the instance (<code>ok</code> | <code>impaired</code> | <code>initializing</code> | <code>insufficient-data</code> | <code>not-applicable</code>).</p> </li> <li> <p> <code>system-status.reachability</code> - Filters on system status where the name is <code>reachability</code> (<code>passed</code> | <code>failed</code> | <code>initializing</code> | <code>insufficient-data</code>).</p> </li> <li> <p> <code>system-status.status</code> - The system status of the instance (<code>ok</code> | <code>impaired</code> | <code>initializing</code> | <code>insufficient-data</code> | <code>not-applicable</code>).</p> </li> </ul>', 'DescribeInstancesRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>affinity</code> - The affinity setting for an instance running on a Dedicated Host (<code>default</code> | <code>host</code>).</p> </li> <li> <p> <code>architecture</code> - The instance architecture (<code>i386</code> | <code>x86_64</code>).</p> </li> <li> <p> <code>availability-zone</code> - The Availability Zone of the instance.</p> </li> <li> <p> <code>block-device-mapping.attach-time</code> - The attach time for an EBS volume mapped to the instance, for example, <code>2010-09-15T17:15:20.000Z</code>.</p> </li> <li> <p> <code>block-device-mapping.delete-on-termination</code> - A Boolean that indicates whether the EBS volume is deleted on instance termination.</p> </li> <li> <p> <code>block-device-mapping.device-name</code> - The device name for the EBS volume (for example, <code>/dev/sdh</code> or <code>xvdh</code>).</p> </li> <li> <p> <code>block-device-mapping.status</code> - The status for the EBS volume (<code>attaching</code> | <code>attached</code> | <code>detaching</code> | <code>detached</code>).</p> </li> <li> <p> <code>block-device-mapping.volume-id</code> - The volume ID of the EBS volume.</p> </li> <li> <p> <code>client-token</code> - The idempotency token you provided when you launched the instance.</p> </li> <li> <p> <code>dns-name</code> - The public DNS name of the instance.</p> </li> <li> <p> <code>group-id</code> - The ID of the security group for the instance. EC2-Classic only.</p> </li> <li> <p> <code>group-name</code> - The name of the security group for the instance. EC2-Classic only.</p> </li> <li> <p> <code>host-id</code> - The ID of the Dedicated Host on which the instance is running, if applicable.</p> </li> <li> <p> <code>hypervisor</code> - The hypervisor type of the instance (<code>ovm</code> | <code>xen</code>).</p> </li> <li> <p> <code>iam-instance-profile.arn</code> - The instance profile associated with the instance. Specified as an ARN.</p> </li> <li> <p> <code>image-id</code> - The ID of the image used to launch the instance.</p> </li> <li> <p> <code>instance-id</code> - The ID of the instance.</p> </li> <li> <p> <code>instance-lifecycle</code> - Indicates whether this is a Spot Instance or a Scheduled Instance (<code>spot</code> | <code>scheduled</code>).</p> </li> <li> <p> <code>instance-state-code</code> - The state of the instance, as a 16-bit unsigned integer. The high byte is an opaque internal value and should be ignored. The low byte is set based on the state represented. The valid values are: 0 (pending), 16 (running), 32 (shutting-down), 48 (terminated), 64 (stopping), and 80 (stopped).</p> </li> <li> <p> <code>instance-state-name</code> - The state of the instance (<code>pending</code> | <code>running</code> | <code>shutting-down</code> | <code>terminated</code> | <code>stopping</code> | <code>stopped</code>).</p> </li> <li> <p> <code>instance-type</code> - The type of instance (for example, <code>t2.micro</code>).</p> </li> <li> <p> <code>instance.group-id</code> - The ID of the security group for the instance. </p> </li> <li> <p> <code>instance.group-name</code> - The name of the security group for the instance. </p> </li> <li> <p> <code>ip-address</code> - The public IP address of the instance.</p> </li> <li> <p> <code>kernel-id</code> - The kernel ID.</p> </li> <li> <p> <code>key-name</code> - The name of the key pair used when the instance was launched.</p> </li> <li> <p> <code>launch-index</code> - When launching multiple instances, this is the index for the instance in the launch group (for example, 0, 1, 2, and so on). </p> </li> <li> <p> <code>launch-time</code> - The time when the instance was launched.</p> </li> <li> <p> <code>monitoring-state</code> - Indicates whether monitoring is enabled for the instance (<code>disabled</code> | <code>enabled</code>).</p> </li> <li> <p> <code>owner-id</code> - The AWS account ID of the instance owner.</p> </li> <li> <p> <code>placement-group-name</code> - The name of the placement group for the instance.</p> </li> <li> <p> <code>platform</code> - The platform. Use <code>windows</code> if you have Windows instances; otherwise, leave blank.</p> </li> <li> <p> <code>private-dns-name</code> - The private DNS name of the instance.</p> </li> <li> <p> <code>private-ip-address</code> - The private IP address of the instance.</p> </li> <li> <p> <code>product-code</code> - The product code associated with the AMI used to launch the instance.</p> </li> <li> <p> <code>product-code.type</code> - The type of product code (<code>devpay</code> | <code>marketplace</code>).</p> </li> <li> <p> <code>ramdisk-id</code> - The RAM disk ID.</p> </li> <li> <p> <code>reason</code> - The reason for the current state of the instance (for example, shows "User Initiated [date]" when you stop or terminate the instance). Similar to the state-reason-code filter.</p> </li> <li> <p> <code>requester-id</code> - The ID of the entity that launched the instance on your behalf (for example, AWS Management Console, Auto Scaling, and so on).</p> </li> <li> <p> <code>reservation-id</code> - The ID of the instance\'s reservation. A reservation ID is created any time you launch an instance. A reservation ID has a one-to-one relationship with an instance launch request, but can be associated with more than one instance if you launch multiple instances using the same launch request. For example, if you launch one instance, you\'ll get one reservation ID. If you launch ten instances using the same launch request, you\'ll also get one reservation ID.</p> </li> <li> <p> <code>root-device-name</code> - The name of the root device for the instance (for example, <code>/dev/sda1</code> or <code>/dev/xvda</code>).</p> </li> <li> <p> <code>root-device-type</code> - The type of root device that the instance uses (<code>ebs</code> | <code>instance-store</code>).</p> </li> <li> <p> <code>source-dest-check</code> - Indicates whether the instance performs source/destination checking. A value of <code>true</code> means that checking is enabled, and <code>false</code> means checking is disabled. The value must be <code>false</code> for the instance to perform network address translation (NAT) in your VPC. </p> </li> <li> <p> <code>spot-instance-request-id</code> - The ID of the Spot instance request.</p> </li> <li> <p> <code>state-reason-code</code> - The reason code for the state change.</p> </li> <li> <p> <code>state-reason-message</code> - A message that describes the state change.</p> </li> <li> <p> <code>subnet-id</code> - The ID of the subnet for the instance.</p> </li> <li> <p> <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource, where <code>tag</code>:<i>key</i> is the tag\'s key. </p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag\'s value is), and the tag value X (regardless of what the tag\'s key is). If you want to list only resources where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.</p> </li> <li> <p> <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the <code>tag-key</code> filter.</p> </li> <li> <p> <code>tenancy</code> - The tenancy of an instance (<code>dedicated</code> | <code>default</code> | <code>host</code>).</p> </li> <li> <p> <code>virtualization-type</code> - The virtualization type of the instance (<code>paravirtual</code> | <code>hvm</code>).</p> </li> <li> <p> <code>vpc-id</code> - The ID of the VPC that the instance is running in.</p> </li> <li> <p> <code>network-interface.description</code> - The description of the network interface.</p> </li> <li> <p> <code>network-interface.subnet-id</code> - The ID of the subnet for the network interface.</p> </li> <li> <p> <code>network-interface.vpc-id</code> - The ID of the VPC for the network interface.</p> </li> <li> <p> <code>network-interface.network-interface-id</code> - The ID of the network interface.</p> </li> <li> <p> <code>network-interface.owner-id</code> - The ID of the owner of the network interface.</p> </li> <li> <p> <code>network-interface.availability-zone</code> - The Availability Zone for the network interface.</p> </li> <li> <p> <code>network-interface.requester-id</code> - The requester ID for the network interface.</p> </li> <li> <p> <code>network-interface.requester-managed</code> - Indicates whether the network interface is being managed by AWS.</p> </li> <li> <p> <code>network-interface.status</code> - The status of the network interface (<code>available</code>) | <code>in-use</code>).</p> </li> <li> <p> <code>network-interface.mac-address</code> - The MAC address of the network interface.</p> </li> <li> <p> <code>network-interface.private-dns-name</code> - The private DNS name of the network interface.</p> </li> <li> <p> <code>network-interface.source-dest-check</code> - Whether the network interface performs source/destination checking. A value of <code>true</code> means checking is enabled, and <code>false</code> means checking is disabled. The value must be <code>false</code> for the network interface to perform network address translation (NAT) in your VPC.</p> </li> <li> <p> <code>network-interface.group-id</code> - The ID of a security group associated with the network interface.</p> </li> <li> <p> <code>network-interface.group-name</code> - The name of a security group associated with the network interface.</p> </li> <li> <p> <code>network-interface.attachment.attachment-id</code> - The ID of the interface attachment.</p> </li> <li> <p> <code>network-interface.attachment.instance-id</code> - The ID of the instance to which the network interface is attached.</p> </li> <li> <p> <code>network-interface.attachment.instance-owner-id</code> - The owner ID of the instance to which the network interface is attached.</p> </li> <li> <p> <code>network-interface.addresses.private-ip-address</code> - The private IP address associated with the network interface.</p> </li> <li> <p> <code>network-interface.attachment.device-index</code> - The device index to which the network interface is attached.</p> </li> <li> <p> <code>network-interface.attachment.status</code> - The status of the attachment (<code>attaching</code> | <code>attached</code> | <code>detaching</code> | <code>detached</code>).</p> </li> <li> <p> <code>network-interface.attachment.attach-time</code> - The time that the network interface was attached to an instance.</p> </li> <li> <p> <code>network-interface.attachment.delete-on-termination</code> - Specifies whether the attachment is deleted when an instance is terminated.</p> </li> <li> <p> <code>network-interface.addresses.primary</code> - Specifies whether the IP address of the network interface is the primary private IP address.</p> </li> <li> <p> <code>network-interface.addresses.association.public-ip</code> - The ID of the association of an Elastic IP address with a network interface.</p> </li> <li> <p> <code>network-interface.addresses.association.ip-owner-id</code> - The owner ID of the private IP address associated with the network interface.</p> </li> <li> <p> <code>association.public-ip</code> - The address of the Elastic IP address bound to the network interface.</p> </li> <li> <p> <code>association.ip-owner-id</code> - The owner of the Elastic IP address associated with the network interface.</p> </li> <li> <p> <code>association.allocation-id</code> - The allocation ID returned when you allocated the Elastic IP address for your network interface.</p> </li> <li> <p> <code>association.association-id</code> - The association ID returned when the network interface was associated with an IP address.</p> </li> </ul>', 'DescribeInternetGatewaysRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>attachment.state</code> - The current state of the attachment between the gateway and the VPC (<code>available</code>). Present only if a VPC is attached.</p> </li> <li> <p> <code>attachment.vpc-id</code> - The ID of an attached VPC.</p> </li> <li> <p> <code>internet-gateway-id</code> - The ID of the Internet gateway.</p> </li> <li> <p> <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag\'s value is), and the tag value X (regardless of what the tag\'s key is). If you want to list only resources where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.</p> </li> <li> <p> <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the <code>tag-key</code> filter.</p> </li> </ul>', 'DescribeKeyPairsRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>fingerprint</code> - The fingerprint of the key pair.</p> </li> <li> <p> <code>key-name</code> - The name of the key pair.</p> </li> </ul>', 'DescribeMovingAddressesRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>moving-status</code> - The status of the Elastic IP address (<code>MovingToVpc</code> | <code>RestoringToClassic</code>).</p> </li> </ul>', 'DescribeNatGatewaysRequest$Filter' => '<p>One or more filters.</p> <ul> <li> <p> <code>nat-gateway-id</code> - The ID of the NAT gateway.</p> </li> <li> <p> <code>state</code> - The state of the NAT gateway (<code>pending</code> | <code>failed</code> | <code>available</code> | <code>deleting</code> | <code>deleted</code>).</p> </li> <li> <p> <code>subnet-id</code> - The ID of the subnet in which the NAT gateway resides.</p> </li> <li> <p> <code>vpc-id</code> - The ID of the VPC in which the NAT gateway resides.</p> </li> </ul>', 'DescribeNetworkAclsRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>association.association-id</code> - The ID of an association ID for the ACL.</p> </li> <li> <p> <code>association.network-acl-id</code> - The ID of the network ACL involved in the association.</p> </li> <li> <p> <code>association.subnet-id</code> - The ID of the subnet involved in the association.</p> </li> <li> <p> <code>default</code> - Indicates whether the ACL is the default network ACL for the VPC.</p> </li> <li> <p> <code>entry.cidr</code> - The CIDR range specified in the entry.</p> </li> <li> <p> <code>entry.egress</code> - Indicates whether the entry applies to egress traffic.</p> </li> <li> <p> <code>entry.icmp.code</code> - The ICMP code specified in the entry, if any.</p> </li> <li> <p> <code>entry.icmp.type</code> - The ICMP type specified in the entry, if any.</p> </li> <li> <p> <code>entry.port-range.from</code> - The start of the port range specified in the entry. </p> </li> <li> <p> <code>entry.port-range.to</code> - The end of the port range specified in the entry. </p> </li> <li> <p> <code>entry.protocol</code> - The protocol specified in the entry (<code>tcp</code> | <code>udp</code> | <code>icmp</code> or a protocol number).</p> </li> <li> <p> <code>entry.rule-action</code> - Allows or denies the matching traffic (<code>allow</code> | <code>deny</code>).</p> </li> <li> <p> <code>entry.rule-number</code> - The number of an entry (in other words, rule) in the ACL\'s set of entries.</p> </li> <li> <p> <code>network-acl-id</code> - The ID of the network ACL.</p> </li> <li> <p> <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag\'s value is), and the tag value X (regardless of what the tag\'s key is). If you want to list only resources where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.</p> </li> <li> <p> <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the <code>tag-key</code> filter.</p> </li> <li> <p> <code>vpc-id</code> - The ID of the VPC for the network ACL.</p> </li> </ul>', 'DescribeNetworkInterfacesRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>addresses.private-ip-address</code> - The private IP addresses associated with the network interface.</p> </li> <li> <p> <code>addresses.primary</code> - Whether the private IP address is the primary IP address associated with the network interface. </p> </li> <li> <p> <code>addresses.association.public-ip</code> - The association ID returned when the network interface was associated with the Elastic IP address.</p> </li> <li> <p> <code>addresses.association.owner-id</code> - The owner ID of the addresses associated with the network interface.</p> </li> <li> <p> <code>association.association-id</code> - The association ID returned when the network interface was associated with an IP address.</p> </li> <li> <p> <code>association.allocation-id</code> - The allocation ID returned when you allocated the Elastic IP address for your network interface.</p> </li> <li> <p> <code>association.ip-owner-id</code> - The owner of the Elastic IP address associated with the network interface.</p> </li> <li> <p> <code>association.public-ip</code> - The address of the Elastic IP address bound to the network interface.</p> </li> <li> <p> <code>association.public-dns-name</code> - The public DNS name for the network interface.</p> </li> <li> <p> <code>attachment.attachment-id</code> - The ID of the interface attachment.</p> </li> <li> <p> <code>attachment.attach.time</code> - The time that the network interface was attached to an instance.</p> </li> <li> <p> <code>attachment.delete-on-termination</code> - Indicates whether the attachment is deleted when an instance is terminated.</p> </li> <li> <p> <code>attachment.device-index</code> - The device index to which the network interface is attached.</p> </li> <li> <p> <code>attachment.instance-id</code> - The ID of the instance to which the network interface is attached.</p> </li> <li> <p> <code>attachment.instance-owner-id</code> - The owner ID of the instance to which the network interface is attached.</p> </li> <li> <p> <code>attachment.nat-gateway-id</code> - The ID of the NAT gateway to which the network interface is attached.</p> </li> <li> <p> <code>attachment.status</code> - The status of the attachment (<code>attaching</code> | <code>attached</code> | <code>detaching</code> | <code>detached</code>).</p> </li> <li> <p> <code>availability-zone</code> - The Availability Zone of the network interface.</p> </li> <li> <p> <code>description</code> - The description of the network interface.</p> </li> <li> <p> <code>group-id</code> - The ID of a security group associated with the network interface.</p> </li> <li> <p> <code>group-name</code> - The name of a security group associated with the network interface.</p> </li> <li> <p> <code>mac-address</code> - The MAC address of the network interface.</p> </li> <li> <p> <code>network-interface-id</code> - The ID of the network interface.</p> </li> <li> <p> <code>owner-id</code> - The AWS account ID of the network interface owner.</p> </li> <li> <p> <code>private-ip-address</code> - The private IP address or addresses of the network interface.</p> </li> <li> <p> <code>private-dns-name</code> - The private DNS name of the network interface.</p> </li> <li> <p> <code>requester-id</code> - The ID of the entity that launched the instance on your behalf (for example, AWS Management Console, Auto Scaling, and so on).</p> </li> <li> <p> <code>requester-managed</code> - Indicates whether the network interface is being managed by an AWS service (for example, AWS Management Console, Auto Scaling, and so on).</p> </li> <li> <p> <code>source-desk-check</code> - Indicates whether the network interface performs source/destination checking. A value of <code>true</code> means checking is enabled, and <code>false</code> means checking is disabled. The value must be <code>false</code> for the network interface to perform network address translation (NAT) in your VPC. </p> </li> <li> <p> <code>status</code> - The status of the network interface. If the network interface is not attached to an instance, the status is <code>available</code>; if a network interface is attached to an instance the status is <code>in-use</code>.</p> </li> <li> <p> <code>subnet-id</code> - The ID of the subnet for the network interface.</p> </li> <li> <p> <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag\'s value is), and the tag value X (regardless of what the tag\'s key is). If you want to list only resources where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.</p> </li> <li> <p> <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the <code>tag-key</code> filter.</p> </li> <li> <p> <code>vpc-id</code> - The ID of the VPC for the network interface.</p> </li> </ul>', 'DescribePlacementGroupsRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>group-name</code> - The name of the placement group.</p> </li> <li> <p> <code>state</code> - The state of the placement group (<code>pending</code> | <code>available</code> | <code>deleting</code> | <code>deleted</code>).</p> </li> <li> <p> <code>strategy</code> - The strategy of the placement group (<code>cluster</code>).</p> </li> </ul>', 'DescribePrefixListsRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>prefix-list-id</code>: The ID of a prefix list.</p> </li> <li> <p> <code>prefix-list-name</code>: The name of a prefix list.</p> </li> </ul>', 'DescribeRegionsRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>endpoint</code> - The endpoint of the region (for example, <code>ec2.us-east-1.amazonaws.com</code>).</p> </li> <li> <p> <code>region-name</code> - The name of the region (for example, <code>us-east-1</code>).</p> </li> </ul>', 'DescribeReservedInstancesListingsRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>reserved-instances-id</code> - The ID of the Reserved Instances.</p> </li> <li> <p> <code>reserved-instances-listing-id</code> - The ID of the Reserved Instances listing.</p> </li> <li> <p> <code>status</code> - The status of the Reserved Instance listing (<code>pending</code> | <code>active</code> | <code>cancelled</code> | <code>closed</code>).</p> </li> <li> <p> <code>status-message</code> - The reason for the status.</p> </li> </ul>', 'DescribeReservedInstancesModificationsRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>client-token</code> - The idempotency token for the modification request.</p> </li> <li> <p> <code>create-date</code> - The time when the modification request was created.</p> </li> <li> <p> <code>effective-date</code> - The time when the modification becomes effective.</p> </li> <li> <p> <code>modification-result.reserved-instances-id</code> - The ID for the Reserved Instances created as part of the modification request. This ID is only available when the status of the modification is <code>fulfilled</code>.</p> </li> <li> <p> <code>modification-result.target-configuration.availability-zone</code> - The Availability Zone for the new Reserved Instances.</p> </li> <li> <p> <code>modification-result.target-configuration.instance-count </code> - The number of new Reserved Instances.</p> </li> <li> <p> <code>modification-result.target-configuration.instance-type</code> - The instance type of the new Reserved Instances.</p> </li> <li> <p> <code>modification-result.target-configuration.platform</code> - The network platform of the new Reserved Instances (<code>EC2-Classic</code> | <code>EC2-VPC</code>).</p> </li> <li> <p> <code>reserved-instances-id</code> - The ID of the Reserved Instances modified.</p> </li> <li> <p> <code>reserved-instances-modification-id</code> - The ID of the modification request.</p> </li> <li> <p> <code>status</code> - The status of the Reserved Instances modification request (<code>processing</code> | <code>fulfilled</code> | <code>failed</code>).</p> </li> <li> <p> <code>status-message</code> - The reason for the status.</p> </li> <li> <p> <code>update-date</code> - The time when the modification request was last updated.</p> </li> </ul>', 'DescribeReservedInstancesOfferingsRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>availability-zone</code> - The Availability Zone where the Reserved Instance can be used.</p> </li> <li> <p> <code>duration</code> - The duration of the Reserved Instance (for example, one year or three years), in seconds (<code>31536000</code> | <code>94608000</code>).</p> </li> <li> <p> <code>fixed-price</code> - The purchase price of the Reserved Instance (for example, 9800.0).</p> </li> <li> <p> <code>instance-type</code> - The instance type that is covered by the reservation.</p> </li> <li> <p> <code>marketplace</code> - Set to <code>true</code> to show only Reserved Instance Marketplace offerings. When this filter is not used, which is the default behavior, all offerings from both AWS and the Reserved Instance Marketplace are listed.</p> </li> <li> <p> <code>product-description</code> - The Reserved Instance product platform description. Instances that include <code>(Amazon VPC)</code> in the product platform description will only be displayed to EC2-Classic account holders and are for use with Amazon VPC. (<code>Linux/UNIX</code> | <code>Linux/UNIX (Amazon VPC)</code> | <code>SUSE Linux</code> | <code>SUSE Linux (Amazon VPC)</code> | <code>Red Hat Enterprise Linux</code> | <code>Red Hat Enterprise Linux (Amazon VPC)</code> | <code>Windows</code> | <code>Windows (Amazon VPC)</code> | <code>Windows with SQL Server Standard</code> | <code>Windows with SQL Server Standard (Amazon VPC)</code> | <code>Windows with SQL Server Web</code> | <code> Windows with SQL Server Web (Amazon VPC)</code> | <code>Windows with SQL Server Enterprise</code> | <code>Windows with SQL Server Enterprise (Amazon VPC)</code>) </p> </li> <li> <p> <code>reserved-instances-offering-id</code> - The Reserved Instances offering ID.</p> </li> <li> <p> <code>scope</code> - The scope of the Reserved Instance (<code>Availability Zone</code> or <code>Region</code>).</p> </li> <li> <p> <code>usage-price</code> - The usage price of the Reserved Instance, per hour (for example, 0.84).</p> </li> </ul>', 'DescribeReservedInstancesRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>availability-zone</code> - The Availability Zone where the Reserved Instance can be used.</p> </li> <li> <p> <code>duration</code> - The duration of the Reserved Instance (one year or three years), in seconds (<code>31536000</code> | <code>94608000</code>).</p> </li> <li> <p> <code>end</code> - The time when the Reserved Instance expires (for example, 2015-08-07T11:54:42.000Z).</p> </li> <li> <p> <code>fixed-price</code> - The purchase price of the Reserved Instance (for example, 9800.0).</p> </li> <li> <p> <code>instance-type</code> - The instance type that is covered by the reservation.</p> </li> <li> <p> <code>scope</code> - The scope of the Reserved Instance (<code>Region</code> or <code>Availability Zone</code>).</p> </li> <li> <p> <code>product-description</code> - The Reserved Instance product platform description. Instances that include <code>(Amazon VPC)</code> in the product platform description will only be displayed to EC2-Classic account holders and are for use with Amazon VPC (<code>Linux/UNIX</code> | <code>Linux/UNIX (Amazon VPC)</code> | <code>SUSE Linux</code> | <code>SUSE Linux (Amazon VPC)</code> | <code>Red Hat Enterprise Linux</code> | <code>Red Hat Enterprise Linux (Amazon VPC)</code> | <code>Windows</code> | <code>Windows (Amazon VPC)</code> | <code>Windows with SQL Server Standard</code> | <code>Windows with SQL Server Standard (Amazon VPC)</code> | <code>Windows with SQL Server Web</code> | <code>Windows with SQL Server Web (Amazon VPC)</code> | <code>Windows with SQL Server Enterprise</code> | <code>Windows with SQL Server Enterprise (Amazon VPC)</code>).</p> </li> <li> <p> <code>reserved-instances-id</code> - The ID of the Reserved Instance.</p> </li> <li> <p> <code>start</code> - The time at which the Reserved Instance purchase request was placed (for example, 2014-08-07T11:54:42.000Z).</p> </li> <li> <p> <code>state</code> - The state of the Reserved Instance (<code>payment-pending</code> | <code>active</code> | <code>payment-failed</code> | <code>retired</code>).</p> </li> <li> <p> <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag\'s value is), and the tag value X (regardless of what the tag\'s key is). If you want to list only resources where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.</p> </li> <li> <p> <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the <code>tag-key</code> filter.</p> </li> <li> <p> <code>usage-price</code> - The usage price of the Reserved Instance, per hour (for example, 0.84).</p> </li> </ul>', 'DescribeRouteTablesRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>association.route-table-association-id</code> - The ID of an association ID for the route table.</p> </li> <li> <p> <code>association.route-table-id</code> - The ID of the route table involved in the association.</p> </li> <li> <p> <code>association.subnet-id</code> - The ID of the subnet involved in the association.</p> </li> <li> <p> <code>association.main</code> - Indicates whether the route table is the main route table for the VPC (<code>true</code> | <code>false</code>).</p> </li> <li> <p> <code>route-table-id</code> - The ID of the route table.</p> </li> <li> <p> <code>route.destination-cidr-block</code> - The CIDR range specified in a route in the table.</p> </li> <li> <p> <code>route.destination-prefix-list-id</code> - The ID (prefix) of the AWS service specified in a route in the table.</p> </li> <li> <p> <code>route.gateway-id</code> - The ID of a gateway specified in a route in the table.</p> </li> <li> <p> <code>route.instance-id</code> - The ID of an instance specified in a route in the table.</p> </li> <li> <p> <code>route.nat-gateway-id</code> - The ID of a NAT gateway.</p> </li> <li> <p> <code>route.origin</code> - Describes how the route was created. <code>CreateRouteTable</code> indicates that the route was automatically created when the route table was created; <code>CreateRoute</code> indicates that the route was manually added to the route table; <code>EnableVgwRoutePropagation</code> indicates that the route was propagated by route propagation.</p> </li> <li> <p> <code>route.state</code> - The state of a route in the route table (<code>active</code> | <code>blackhole</code>). The blackhole state indicates that the route\'s target isn\'t available (for example, the specified gateway isn\'t attached to the VPC, the specified NAT instance has been terminated, and so on).</p> </li> <li> <p> <code>route.vpc-peering-connection-id</code> - The ID of a VPC peering connection specified in a route in the table.</p> </li> <li> <p> <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag\'s value is), and the tag value X (regardless of what the tag\'s key is). If you want to list only resources where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.</p> </li> <li> <p> <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the <code>tag-key</code> filter.</p> </li> <li> <p> <code>vpc-id</code> - The ID of the VPC for the route table.</p> </li> </ul>', 'DescribeScheduledInstanceAvailabilityRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>availability-zone</code> - The Availability Zone (for example, <code>us-west-2a</code>).</p> </li> <li> <p> <code>instance-type</code> - The instance type (for example, <code>c4.large</code>).</p> </li> <li> <p> <code>network-platform</code> - The network platform (<code>EC2-Classic</code> or <code>EC2-VPC</code>).</p> </li> <li> <p> <code>platform</code> - The platform (<code>Linux/UNIX</code> or <code>Windows</code>).</p> </li> </ul>', 'DescribeScheduledInstancesRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>availability-zone</code> - The Availability Zone (for example, <code>us-west-2a</code>).</p> </li> <li> <p> <code>instance-type</code> - The instance type (for example, <code>c4.large</code>).</p> </li> <li> <p> <code>network-platform</code> - The network platform (<code>EC2-Classic</code> or <code>EC2-VPC</code>).</p> </li> <li> <p> <code>platform</code> - The platform (<code>Linux/UNIX</code> or <code>Windows</code>).</p> </li> </ul>', 'DescribeSecurityGroupsRequest$Filters' => '<p>One or more filters. If using multiple filters for rules, the results include security groups for which any combination of rules - not necessarily a single rule - match all filters.</p> <ul> <li> <p> <code>description</code> - The description of the security group.</p> </li> <li> <p> <code>egress.ip-permission.prefix-list-id</code> - The ID (prefix) of the AWS service to which the security group allows access.</p> </li> <li> <p> <code>group-id</code> - The ID of the security group. </p> </li> <li> <p> <code>group-name</code> - The name of the security group.</p> </li> <li> <p> <code>ip-permission.cidr</code> - A CIDR range that has been granted permission.</p> </li> <li> <p> <code>ip-permission.from-port</code> - The start of port range for the TCP and UDP protocols, or an ICMP type number.</p> </li> <li> <p> <code>ip-permission.group-id</code> - The ID of a security group that has been granted permission.</p> </li> <li> <p> <code>ip-permission.group-name</code> - The name of a security group that has been granted permission.</p> </li> <li> <p> <code>ip-permission.protocol</code> - The IP protocol for the permission (<code>tcp</code> | <code>udp</code> | <code>icmp</code> or a protocol number).</p> </li> <li> <p> <code>ip-permission.to-port</code> - The end of port range for the TCP and UDP protocols, or an ICMP code.</p> </li> <li> <p> <code>ip-permission.user-id</code> - The ID of an AWS account that has been granted permission.</p> </li> <li> <p> <code>owner-id</code> - The AWS account ID of the owner of the security group.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the security group.</p> </li> <li> <p> <code>tag-value</code> - The value of a tag assigned to the security group.</p> </li> <li> <p> <code>vpc-id</code> - The ID of the VPC specified when the security group was created.</p> </li> </ul>', 'DescribeSnapshotsRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>description</code> - A description of the snapshot.</p> </li> <li> <p> <code>owner-alias</code> - Value from an Amazon-maintained list (<code>amazon</code> | <code>aws-marketplace</code> | <code>microsoft</code>) of snapshot owners. Not to be confused with the user-configured AWS account alias, which is set from the IAM consolew.</p> </li> <li> <p> <code>owner-id</code> - The ID of the AWS account that owns the snapshot.</p> </li> <li> <p> <code>progress</code> - The progress of the snapshot, as a percentage (for example, 80%).</p> </li> <li> <p> <code>snapshot-id</code> - The snapshot ID.</p> </li> <li> <p> <code>start-time</code> - The time stamp when the snapshot was initiated.</p> </li> <li> <p> <code>status</code> - The status of the snapshot (<code>pending</code> | <code>completed</code> | <code>error</code>).</p> </li> <li> <p> <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag\'s value is), and the tag value X (regardless of what the tag\'s key is). If you want to list only resources where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.</p> </li> <li> <p> <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the <code>tag-key</code> filter.</p> </li> <li> <p> <code>volume-id</code> - The ID of the volume the snapshot is for.</p> </li> <li> <p> <code>volume-size</code> - The size of the volume, in GiB.</p> </li> </ul>', 'DescribeSpotInstanceRequestsRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>availability-zone-group</code> - The Availability Zone group.</p> </li> <li> <p> <code>create-time</code> - The time stamp when the Spot instance request was created.</p> </li> <li> <p> <code>fault-code</code> - The fault code related to the request.</p> </li> <li> <p> <code>fault-message</code> - The fault message related to the request.</p> </li> <li> <p> <code>instance-id</code> - The ID of the instance that fulfilled the request.</p> </li> <li> <p> <code>launch-group</code> - The Spot instance launch group.</p> </li> <li> <p> <code>launch.block-device-mapping.delete-on-termination</code> - Indicates whether the Amazon EBS volume is deleted on instance termination.</p> </li> <li> <p> <code>launch.block-device-mapping.device-name</code> - The device name for the Amazon EBS volume (for example, <code>/dev/sdh</code>).</p> </li> <li> <p> <code>launch.block-device-mapping.snapshot-id</code> - The ID of the snapshot used for the Amazon EBS volume.</p> </li> <li> <p> <code>launch.block-device-mapping.volume-size</code> - The size of the Amazon EBS volume, in GiB.</p> </li> <li> <p> <code>launch.block-device-mapping.volume-type</code> - The type of the Amazon EBS volume: <code>gp2</code> for General Purpose SSD, <code>io1</code> for Provisioned IOPS SSD, <code>st1</code> for Throughput Optimized HDD, <code>sc1</code>for Cold HDD, or <code>standard</code> for Magnetic.</p> </li> <li> <p> <code>launch.group-id</code> - The security group for the instance.</p> </li> <li> <p> <code>launch.image-id</code> - The ID of the AMI.</p> </li> <li> <p> <code>launch.instance-type</code> - The type of instance (for example, <code>m3.medium</code>).</p> </li> <li> <p> <code>launch.kernel-id</code> - The kernel ID.</p> </li> <li> <p> <code>launch.key-name</code> - The name of the key pair the instance launched with.</p> </li> <li> <p> <code>launch.monitoring-enabled</code> - Whether monitoring is enabled for the Spot instance.</p> </li> <li> <p> <code>launch.ramdisk-id</code> - The RAM disk ID.</p> </li> <li> <p> <code>network-interface.network-interface-id</code> - The ID of the network interface.</p> </li> <li> <p> <code>network-interface.device-index</code> - The index of the device for the network interface attachment on the instance.</p> </li> <li> <p> <code>network-interface.subnet-id</code> - The ID of the subnet for the instance.</p> </li> <li> <p> <code>network-interface.description</code> - A description of the network interface.</p> </li> <li> <p> <code>network-interface.private-ip-address</code> - The primary private IP address of the network interface.</p> </li> <li> <p> <code>network-interface.delete-on-termination</code> - Indicates whether the network interface is deleted when the instance is terminated.</p> </li> <li> <p> <code>network-interface.group-id</code> - The ID of the security group associated with the network interface.</p> </li> <li> <p> <code>network-interface.group-name</code> - The name of the security group associated with the network interface.</p> </li> <li> <p> <code>network-interface.addresses.primary</code> - Indicates whether the IP address is the primary private IP address.</p> </li> <li> <p> <code>product-description</code> - The product description associated with the instance (<code>Linux/UNIX</code> | <code>Windows</code>).</p> </li> <li> <p> <code>spot-instance-request-id</code> - The Spot instance request ID.</p> </li> <li> <p> <code>spot-price</code> - The maximum hourly price for any Spot instance launched to fulfill the request.</p> </li> <li> <p> <code>state</code> - The state of the Spot instance request (<code>open</code> | <code>active</code> | <code>closed</code> | <code>cancelled</code> | <code>failed</code>). Spot bid status information can help you track your Amazon EC2 Spot instance requests. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html">Spot Bid Status</a> in the Amazon Elastic Compute Cloud User Guide.</p> </li> <li> <p> <code>status-code</code> - The short code describing the most recent evaluation of your Spot instance request.</p> </li> <li> <p> <code>status-message</code> - The message explaining the status of the Spot instance request.</p> </li> <li> <p> <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag\'s value is), and the tag value X (regardless of what the tag\'s key is). If you want to list only resources where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.</p> </li> <li> <p> <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the <code>tag-key</code> filter.</p> </li> <li> <p> <code>type</code> - The type of Spot instance request (<code>one-time</code> | <code>persistent</code>).</p> </li> <li> <p> <code>launched-availability-zone</code> - The Availability Zone in which the bid is launched.</p> </li> <li> <p> <code>valid-from</code> - The start date of the request.</p> </li> <li> <p> <code>valid-until</code> - The end date of the request.</p> </li> </ul>', 'DescribeSpotPriceHistoryRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>availability-zone</code> - The Availability Zone for which prices should be returned.</p> </li> <li> <p> <code>instance-type</code> - The type of instance (for example, <code>m3.medium</code>).</p> </li> <li> <p> <code>product-description</code> - The product description for the Spot price (<code>Linux/UNIX</code> | <code>SUSE Linux</code> | <code>Windows</code> | <code>Linux/UNIX (Amazon VPC)</code> | <code>SUSE Linux (Amazon VPC)</code> | <code>Windows (Amazon VPC)</code>).</p> </li> <li> <p> <code>spot-price</code> - The Spot price. The value must match exactly (or use wildcards; greater than or less than comparison is not supported).</p> </li> <li> <p> <code>timestamp</code> - The timestamp of the Spot price history, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). You can use wildcards (* and ?). Greater than or less than comparison is not supported.</p> </li> </ul>', 'DescribeSubnetsRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>availabilityZone</code> - The Availability Zone for the subnet. You can also use <code>availability-zone</code> as the filter name.</p> </li> <li> <p> <code>available-ip-address-count</code> - The number of IP addresses in the subnet that are available.</p> </li> <li> <p> <code>cidrBlock</code> - The CIDR block of the subnet. The CIDR block you specify must exactly match the subnet\'s CIDR block for information to be returned for the subnet. You can also use <code>cidr</code> or <code>cidr-block</code> as the filter names.</p> </li> <li> <p> <code>defaultForAz</code> - Indicates whether this is the default subnet for the Availability Zone. You can also use <code>default-for-az</code> as the filter name.</p> </li> <li> <p> <code>state</code> - The state of the subnet (<code>pending</code> | <code>available</code>).</p> </li> <li> <p> <code>subnet-id</code> - The ID of the subnet.</p> </li> <li> <p> <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag\'s value is), and the tag value X (regardless of what the tag\'s key is). If you want to list only resources where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.</p> </li> <li> <p> <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the <code>tag-key</code> filter.</p> </li> <li> <p> <code>vpc-id</code> - The ID of the VPC for the subnet.</p> </li> </ul>', 'DescribeTagsRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>key</code> - The tag key.</p> </li> <li> <p> <code>resource-id</code> - The resource ID.</p> </li> <li> <p> <code>resource-type</code> - The resource type (<code>customer-gateway</code> | <code>dhcp-options</code> | <code>image</code> | <code>instance</code> | <code>internet-gateway</code> | <code>network-acl</code> | <code>network-interface</code> | <code>reserved-instances</code> | <code>route-table</code> | <code>security-group</code> | <code>snapshot</code> | <code>spot-instances-request</code> | <code>subnet</code> | <code>volume</code> | <code>vpc</code> | <code>vpn-connection</code> | <code>vpn-gateway</code>).</p> </li> <li> <p> <code>value</code> - The tag value.</p> </li> </ul>', 'DescribeVolumeStatusRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>action.code</code> - The action code for the event (for example, <code>enable-volume-io</code>).</p> </li> <li> <p> <code>action.description</code> - A description of the action.</p> </li> <li> <p> <code>action.event-id</code> - The event ID associated with the action.</p> </li> <li> <p> <code>availability-zone</code> - The Availability Zone of the instance.</p> </li> <li> <p> <code>event.description</code> - A description of the event.</p> </li> <li> <p> <code>event.event-id</code> - The event ID.</p> </li> <li> <p> <code>event.event-type</code> - The event type (for <code>io-enabled</code>: <code>passed</code> | <code>failed</code>; for <code>io-performance</code>: <code>io-performance:degraded</code> | <code>io-performance:severely-degraded</code> | <code>io-performance:stalled</code>).</p> </li> <li> <p> <code>event.not-after</code> - The latest end time for the event.</p> </li> <li> <p> <code>event.not-before</code> - The earliest start time for the event.</p> </li> <li> <p> <code>volume-status.details-name</code> - The cause for <code>volume-status.status</code> (<code>io-enabled</code> | <code>io-performance</code>).</p> </li> <li> <p> <code>volume-status.details-status</code> - The status of <code>volume-status.details-name</code> (for <code>io-enabled</code>: <code>passed</code> | <code>failed</code>; for <code>io-performance</code>: <code>normal</code> | <code>degraded</code> | <code>severely-degraded</code> | <code>stalled</code>).</p> </li> <li> <p> <code>volume-status.status</code> - The status of the volume (<code>ok</code> | <code>impaired</code> | <code>warning</code> | <code>insufficient-data</code>).</p> </li> </ul>', 'DescribeVolumesRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>attachment.attach-time</code> - The time stamp when the attachment initiated.</p> </li> <li> <p> <code>attachment.delete-on-termination</code> - Whether the volume is deleted on instance termination.</p> </li> <li> <p> <code>attachment.device</code> - The device name that is exposed to the instance (for example, <code>/dev/sda1</code>).</p> </li> <li> <p> <code>attachment.instance-id</code> - The ID of the instance the volume is attached to.</p> </li> <li> <p> <code>attachment.status</code> - The attachment state (<code>attaching</code> | <code>attached</code> | <code>detaching</code> | <code>detached</code>).</p> </li> <li> <p> <code>availability-zone</code> - The Availability Zone in which the volume was created.</p> </li> <li> <p> <code>create-time</code> - The time stamp when the volume was created.</p> </li> <li> <p> <code>encrypted</code> - The encryption status of the volume.</p> </li> <li> <p> <code>size</code> - The size of the volume, in GiB.</p> </li> <li> <p> <code>snapshot-id</code> - The snapshot from which the volume was created.</p> </li> <li> <p> <code>status</code> - The status of the volume (<code>creating</code> | <code>available</code> | <code>in-use</code> | <code>deleting</code> | <code>deleted</code> | <code>error</code>).</p> </li> <li> <p> <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag\'s value is), and the tag value X (regardless of what the tag\'s key is). If you want to list only resources where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.</p> </li> <li> <p> <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the <code>tag-key</code> filter.</p> </li> <li> <p> <code>volume-id</code> - The volume ID.</p> </li> <li> <p> <code>volume-type</code> - The Amazon EBS volume type. This can be <code>gp2</code> for General Purpose SSD, <code>io1</code> for Provisioned IOPS SSD, <code>st1</code> for Throughput Optimized HDD, <code>sc1</code> for Cold HDD, or <code>standard</code> for Magnetic volumes.</p> </li> </ul>', 'DescribeVpcClassicLinkRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>is-classic-link-enabled</code> - Whether the VPC is enabled for ClassicLink (<code>true</code> | <code>false</code>).</p> </li> <li> <p> <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag\'s value is), and the tag value X (regardless of what the tag\'s key is). If you want to list only resources where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.</p> </li> <li> <p> <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the <code>tag-key</code> filter.</p> </li> </ul>', 'DescribeVpcEndpointsRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>service-name</code>: The name of the AWS service.</p> </li> <li> <p> <code>vpc-id</code>: The ID of the VPC in which the endpoint resides.</p> </li> <li> <p> <code>vpc-endpoint-id</code>: The ID of the endpoint.</p> </li> <li> <p> <code>vpc-endpoint-state</code>: The state of the endpoint. (<code>pending</code> | <code>available</code> | <code>deleting</code> | <code>deleted</code>)</p> </li> </ul>', 'DescribeVpcPeeringConnectionsRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>accepter-vpc-info.cidr-block</code> - The CIDR block of the peer VPC.</p> </li> <li> <p> <code>accepter-vpc-info.owner-id</code> - The AWS account ID of the owner of the peer VPC.</p> </li> <li> <p> <code>accepter-vpc-info.vpc-id</code> - The ID of the peer VPC.</p> </li> <li> <p> <code>expiration-time</code> - The expiration date and time for the VPC peering connection.</p> </li> <li> <p> <code>requester-vpc-info.cidr-block</code> - The CIDR block of the requester\'s VPC.</p> </li> <li> <p> <code>requester-vpc-info.owner-id</code> - The AWS account ID of the owner of the requester VPC.</p> </li> <li> <p> <code>requester-vpc-info.vpc-id</code> - The ID of the requester VPC.</p> </li> <li> <p> <code>status-code</code> - The status of the VPC peering connection (<code>pending-acceptance</code> | <code>failed</code> | <code>expired</code> | <code>provisioning</code> | <code>active</code> | <code>deleted</code> | <code>rejected</code>).</p> </li> <li> <p> <code>status-message</code> - A message that provides more information about the status of the VPC peering connection, if applicable.</p> </li> <li> <p> <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag\'s value is), and the tag value X (regardless of what the tag\'s key is). If you want to list only resources where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.</p> </li> <li> <p> <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the <code>tag-key</code> filter.</p> </li> <li> <p> <code>vpc-peering-connection-id</code> - The ID of the VPC peering connection.</p> </li> </ul>', 'DescribeVpcsRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>cidr</code> - The CIDR block of the VPC. The CIDR block you specify must exactly match the VPC\'s CIDR block for information to be returned for the VPC. Must contain the slash followed by one or two digits (for example, <code>/28</code>).</p> </li> <li> <p> <code>dhcp-options-id</code> - The ID of a set of DHCP options.</p> </li> <li> <p> <code>isDefault</code> - Indicates whether the VPC is the default VPC.</p> </li> <li> <p> <code>state</code> - The state of the VPC (<code>pending</code> | <code>available</code>).</p> </li> <li> <p> <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag\'s value is), and the tag value X (regardless of what the tag\'s key is). If you want to list only resources where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.</p> </li> <li> <p> <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the <code>tag-key</code> filter.</p> </li> <li> <p> <code>vpc-id</code> - The ID of the VPC.</p> </li> </ul>', 'DescribeVpnConnectionsRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>customer-gateway-configuration</code> - The configuration information for the customer gateway.</p> </li> <li> <p> <code>customer-gateway-id</code> - The ID of a customer gateway associated with the VPN connection.</p> </li> <li> <p> <code>state</code> - The state of the VPN connection (<code>pending</code> | <code>available</code> | <code>deleting</code> | <code>deleted</code>).</p> </li> <li> <p> <code>option.static-routes-only</code> - Indicates whether the connection has static routes only. Used for devices that do not support Border Gateway Protocol (BGP).</p> </li> <li> <p> <code>route.destination-cidr-block</code> - The destination CIDR block. This corresponds to the subnet used in a customer data center.</p> </li> <li> <p> <code>bgp-asn</code> - The BGP Autonomous System Number (ASN) associated with a BGP device.</p> </li> <li> <p> <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag\'s value is), and the tag value X (regardless of what the tag\'s key is). If you want to list only resources where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.</p> </li> <li> <p> <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the <code>tag-key</code> filter.</p> </li> <li> <p> <code>type</code> - The type of VPN connection. Currently the only supported type is <code>ipsec.1</code>.</p> </li> <li> <p> <code>vpn-connection-id</code> - The ID of the VPN connection.</p> </li> <li> <p> <code>vpn-gateway-id</code> - The ID of a virtual private gateway associated with the VPN connection.</p> </li> </ul>', 'DescribeVpnGatewaysRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>attachment.state</code> - The current state of the attachment between the gateway and the VPC (<code>attaching</code> | <code>attached</code> | <code>detaching</code> | <code>detached</code>).</p> </li> <li> <p> <code>attachment.vpc-id</code> - The ID of an attached VPC.</p> </li> <li> <p> <code>availability-zone</code> - The Availability Zone for the virtual private gateway (if applicable).</p> </li> <li> <p> <code>state</code> - The state of the virtual private gateway (<code>pending</code> | <code>available</code> | <code>deleting</code> | <code>deleted</code>).</p> </li> <li> <p> <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag\'s value is), and the tag value X (regardless of what the tag\'s key is). If you want to list only resources where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.</p> </li> <li> <p> <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the <code>tag-key</code> filter.</p> </li> <li> <p> <code>type</code> - The type of virtual private gateway. Currently the only supported type is <code>ipsec.1</code>.</p> </li> <li> <p> <code>vpn-gateway-id</code> - The ID of the virtual private gateway.</p> </li> </ul>', ], ], 'FleetType' => [ 'base' => NULL, 'refs' => [ 'SpotFleetRequestConfigData$Type' => '<p>The type of request. Indicates whether the fleet will only <code>request</code> the target capacity or also attempt to <code>maintain</code> it. When you <code>request</code> a certain target capacity, the fleet will only place the required bids. It will not attempt to replenish Spot instances if capacity is diminished, nor will it submit bids in alternative Spot pools if capacity is not available. When you want to <code>maintain</code> a certain target capacity, fleet will place the required bids to meet this target capacity. It will also automatically replenish any interrupted instances. Default: <code>maintain</code>.</p>', ], ], 'Float' => [ 'base' => NULL, 'refs' => [ 'ReservedInstances$UsagePrice' => '<p>The usage price of the Reserved Instance, per hour.</p>', 'ReservedInstances$FixedPrice' => '<p>The purchase price of the Reserved Instance.</p>', 'ReservedInstancesOffering$UsagePrice' => '<p>The usage price of the Reserved Instance, per hour.</p>', 'ReservedInstancesOffering$FixedPrice' => '<p>The purchase price of the Reserved Instance.</p>', ], ], 'FlowLog' => [ 'base' => '<p>Describes a flow log.</p>', 'refs' => [ 'FlowLogSet$member' => NULL, ], ], 'FlowLogSet' => [ 'base' => NULL, 'refs' => [ 'DescribeFlowLogsResult$FlowLogs' => '<p>Information about the flow logs.</p>', ], ], 'FlowLogsResourceType' => [ 'base' => NULL, 'refs' => [ 'CreateFlowLogsRequest$ResourceType' => '<p>The type of resource on which to create the flow log.</p>', ], ], 'GatewayType' => [ 'base' => NULL, 'refs' => [ 'CreateCustomerGatewayRequest$Type' => '<p>The type of VPN connection that this customer gateway supports (<code>ipsec.1</code>).</p>', 'CreateVpnGatewayRequest$Type' => '<p>The type of VPN connection this virtual private gateway supports.</p>', 'VpnConnection$Type' => '<p>The type of VPN connection.</p>', 'VpnGateway$Type' => '<p>The type of VPN connection the virtual private gateway supports.</p>', ], ], 'GetConsoleOutputRequest' => [ 'base' => '<p>Contains the parameters for GetConsoleOutput.</p>', 'refs' => [], ], 'GetConsoleOutputResult' => [ 'base' => '<p>Contains the output of GetConsoleOutput.</p>', 'refs' => [], ], 'GetConsoleScreenshotRequest' => [ 'base' => '<p>Contains the parameters for the request.</p>', 'refs' => [], ], 'GetConsoleScreenshotResult' => [ 'base' => '<p>Contains the output of the request.</p>', 'refs' => [], ], 'GetHostReservationPurchasePreviewRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetHostReservationPurchasePreviewResult' => [ 'base' => NULL, 'refs' => [], ], 'GetPasswordDataRequest' => [ 'base' => '<p>Contains the parameters for GetPasswordData.</p>', 'refs' => [], ], 'GetPasswordDataResult' => [ 'base' => '<p>Contains the output of GetPasswordData.</p>', 'refs' => [], ], 'GetReservedInstancesExchangeQuoteRequest' => [ 'base' => '<p>Contains the parameters for GetReservedInstanceExchangeQuote.</p>', 'refs' => [], ], 'GetReservedInstancesExchangeQuoteResult' => [ 'base' => '<p>Contains the output of GetReservedInstancesExchangeQuote.</p>', 'refs' => [], ], 'GroupIdStringList' => [ 'base' => NULL, 'refs' => [ 'AttachClassicLinkVpcRequest$Groups' => '<p>The ID of one or more of the VPC\'s security groups. You cannot specify security groups from a different VPC.</p>', 'DescribeSecurityGroupsRequest$GroupIds' => '<p>One or more security group IDs. Required for security groups in a nondefault VPC.</p> <p>Default: Describes all your security groups.</p>', 'ModifyInstanceAttributeRequest$Groups' => '<p>[EC2-VPC] Changes the security groups of the instance. You must specify at least one security group, even if it\'s just the default security group for the VPC. You must specify the security group ID, not the security group name.</p>', ], ], 'GroupIdentifier' => [ 'base' => '<p>Describes a security group.</p>', 'refs' => [ 'GroupIdentifierList$member' => NULL, ], ], 'GroupIdentifierList' => [ 'base' => NULL, 'refs' => [ 'ClassicLinkInstance$Groups' => '<p>A list of security groups.</p>', 'DescribeNetworkInterfaceAttributeResult$Groups' => '<p>The security groups associated with the network interface.</p>', 'Instance$SecurityGroups' => '<p>One or more security groups for the instance.</p>', 'InstanceAttribute$Groups' => '<p>The security groups associated with the instance.</p>', 'InstanceNetworkInterface$Groups' => '<p>One or more security groups.</p>', 'LaunchSpecification$SecurityGroups' => '<p>One or more security groups. When requesting instances in a VPC, you must specify the IDs of the security groups. When requesting instances in EC2-Classic, you can specify the names or the IDs of the security groups.</p>', 'NetworkInterface$Groups' => '<p>Any security groups for the network interface.</p>', 'Reservation$Groups' => '<p>[EC2-Classic only] One or more security groups.</p>', 'SpotFleetLaunchSpecification$SecurityGroups' => '<p>One or more security groups. When requesting instances in a VPC, you must specify the IDs of the security groups. When requesting instances in EC2-Classic, you can specify the names or the IDs of the security groups.</p>', ], ], 'GroupIds' => [ 'base' => NULL, 'refs' => [ 'DescribeSecurityGroupReferencesRequest$GroupId' => '<p>One or more security group IDs in your account.</p>', ], ], 'GroupNameStringList' => [ 'base' => NULL, 'refs' => [ 'DescribeSecurityGroupsRequest$GroupNames' => '<p>[EC2-Classic and default VPC only] One or more security group names. You can specify either the security group name or the security group ID. For security groups in a nondefault VPC, use the <code>group-name</code> filter to describe security groups by name.</p> <p>Default: Describes all your security groups.</p>', 'ModifySnapshotAttributeRequest$GroupNames' => '<p>The group to modify for the snapshot.</p>', ], ], 'HistoryRecord' => [ 'base' => '<p>Describes an event in the history of the Spot fleet request.</p>', 'refs' => [ 'HistoryRecords$member' => NULL, ], ], 'HistoryRecords' => [ 'base' => NULL, 'refs' => [ 'DescribeSpotFleetRequestHistoryResponse$HistoryRecords' => '<p>Information about the events in the history of the Spot fleet request.</p>', ], ], 'Host' => [ 'base' => '<p>Describes the properties of the Dedicated Host.</p>', 'refs' => [ 'HostList$member' => NULL, ], ], 'HostInstance' => [ 'base' => '<p>Describes an instance running on a Dedicated Host.</p>', 'refs' => [ 'HostInstanceList$member' => NULL, ], ], 'HostInstanceList' => [ 'base' => NULL, 'refs' => [ 'Host$Instances' => '<p>The IDs and instance type that are currently running on the Dedicated Host.</p>', ], ], 'HostList' => [ 'base' => NULL, 'refs' => [ 'DescribeHostsResult$Hosts' => '<p>Information about the Dedicated Hosts.</p>', ], ], 'HostOffering' => [ 'base' => '<p>Details about the Dedicated Host Reservation offering.</p>', 'refs' => [ 'HostOfferingSet$member' => NULL, ], ], 'HostOfferingSet' => [ 'base' => NULL, 'refs' => [ 'DescribeHostReservationOfferingsResult$OfferingSet' => '<p>Information about the offerings.</p>', ], ], 'HostProperties' => [ 'base' => '<p>Describes properties of a Dedicated Host.</p>', 'refs' => [ 'Host$HostProperties' => '<p>The hardware specifications of the Dedicated Host.</p>', ], ], 'HostReservation' => [ 'base' => '<p>Details about the Dedicated Host Reservation and associated Dedicated Hosts.</p>', 'refs' => [ 'HostReservationSet$member' => NULL, ], ], 'HostReservationIdSet' => [ 'base' => NULL, 'refs' => [ 'DescribeHostReservationsRequest$HostReservationIdSet' => '<p>One or more host reservation IDs.</p>', ], ], 'HostReservationSet' => [ 'base' => NULL, 'refs' => [ 'DescribeHostReservationsResult$HostReservationSet' => '<p>Details about the reservation\'s configuration.</p>', ], ], 'HostTenancy' => [ 'base' => NULL, 'refs' => [ 'ModifyInstancePlacementRequest$Tenancy' => '<p>The tenancy of the instance that you are modifying.</p>', ], ], 'HypervisorType' => [ 'base' => NULL, 'refs' => [ 'Image$Hypervisor' => '<p>The hypervisor type of the image.</p>', 'Instance$Hypervisor' => '<p>The hypervisor type of the instance.</p>', ], ], 'IamInstanceProfile' => [ 'base' => '<p>Describes an IAM instance profile.</p>', 'refs' => [ 'Instance$IamInstanceProfile' => '<p>The IAM instance profile associated with the instance, if applicable.</p>', ], ], 'IamInstanceProfileSpecification' => [ 'base' => '<p>Describes an IAM instance profile.</p>', 'refs' => [ 'LaunchSpecification$IamInstanceProfile' => '<p>The IAM instance profile.</p>', 'RequestSpotLaunchSpecification$IamInstanceProfile' => '<p>The IAM instance profile.</p>', 'RunInstancesRequest$IamInstanceProfile' => '<p>The IAM instance profile.</p>', 'SpotFleetLaunchSpecification$IamInstanceProfile' => '<p>The IAM instance profile.</p>', ], ], 'IcmpTypeCode' => [ 'base' => '<p>Describes the ICMP type and code.</p>', 'refs' => [ 'CreateNetworkAclEntryRequest$IcmpTypeCode' => '<p>ICMP protocol: The ICMP type and code. Required if specifying ICMP for the protocol.</p>', 'NetworkAclEntry$IcmpTypeCode' => '<p>ICMP protocol: The ICMP type and code.</p>', 'ReplaceNetworkAclEntryRequest$IcmpTypeCode' => '<p>ICMP protocol: The ICMP type and code. Required if specifying 1 (ICMP) for the protocol.</p>', ], ], 'IdFormat' => [ 'base' => '<p>Describes the ID format for a resource.</p>', 'refs' => [ 'IdFormatList$member' => NULL, ], ], 'IdFormatList' => [ 'base' => NULL, 'refs' => [ 'DescribeIdFormatResult$Statuses' => '<p>Information about the ID format for the resource.</p>', 'DescribeIdentityIdFormatResult$Statuses' => '<p>Information about the ID format for the resources.</p>', ], ], 'Image' => [ 'base' => '<p>Describes an image.</p>', 'refs' => [ 'ImageList$member' => NULL, ], ], 'ImageAttribute' => [ 'base' => '<p>Describes an image attribute.</p>', 'refs' => [], ], 'ImageAttributeName' => [ 'base' => NULL, 'refs' => [ 'DescribeImageAttributeRequest$Attribute' => '<p>The AMI attribute.</p> <p> <b>Note</b>: Depending on your account privileges, the <code>blockDeviceMapping</code> attribute may return a <code>Client.AuthFailure</code> error. If this happens, use <a>DescribeImages</a> to get information about the block device mapping for the AMI.</p>', ], ], 'ImageDiskContainer' => [ 'base' => '<p>Describes the disk container object for an import image task.</p>', 'refs' => [ 'ImageDiskContainerList$member' => NULL, ], ], 'ImageDiskContainerList' => [ 'base' => NULL, 'refs' => [ 'ImportImageRequest$DiskContainers' => '<p>Information about the disk containers.</p>', ], ], 'ImageIdStringList' => [ 'base' => NULL, 'refs' => [ 'DescribeImagesRequest$ImageIds' => '<p>One or more image IDs.</p> <p>Default: Describes all images available to you.</p>', ], ], 'ImageList' => [ 'base' => NULL, 'refs' => [ 'DescribeImagesResult$Images' => '<p>Information about one or more images.</p>', ], ], 'ImageState' => [ 'base' => NULL, 'refs' => [ 'Image$State' => '<p>The current state of the AMI. If the state is <code>available</code>, the image is successfully registered and can be used to launch an instance.</p>', ], ], 'ImageTypeValues' => [ 'base' => NULL, 'refs' => [ 'Image$ImageType' => '<p>The type of image.</p>', ], ], 'ImportImageRequest' => [ 'base' => '<p>Contains the parameters for ImportImage.</p>', 'refs' => [], ], 'ImportImageResult' => [ 'base' => '<p>Contains the output for ImportImage.</p>', 'refs' => [], ], 'ImportImageTask' => [ 'base' => '<p>Describes an import image task.</p>', 'refs' => [ 'ImportImageTaskList$member' => NULL, ], ], 'ImportImageTaskList' => [ 'base' => NULL, 'refs' => [ 'DescribeImportImageTasksResult$ImportImageTasks' => '<p>A list of zero or more import image tasks that are currently active or were completed or canceled in the previous 7 days.</p>', ], ], 'ImportInstanceLaunchSpecification' => [ 'base' => '<p>Describes the launch specification for VM import.</p>', 'refs' => [ 'ImportInstanceRequest$LaunchSpecification' => '<p>The launch specification.</p>', ], ], 'ImportInstanceRequest' => [ 'base' => '<p>Contains the parameters for ImportInstance.</p>', 'refs' => [], ], 'ImportInstanceResult' => [ 'base' => '<p>Contains the output for ImportInstance.</p>', 'refs' => [], ], 'ImportInstanceTaskDetails' => [ 'base' => '<p>Describes an import instance task.</p>', 'refs' => [ 'ConversionTask$ImportInstance' => '<p>If the task is for importing an instance, this contains information about the import instance task.</p>', ], ], 'ImportInstanceVolumeDetailItem' => [ 'base' => '<p>Describes an import volume task.</p>', 'refs' => [ 'ImportInstanceVolumeDetailSet$member' => NULL, ], ], 'ImportInstanceVolumeDetailSet' => [ 'base' => NULL, 'refs' => [ 'ImportInstanceTaskDetails$Volumes' => '<p>One or more volumes.</p>', ], ], 'ImportKeyPairRequest' => [ 'base' => '<p>Contains the parameters for ImportKeyPair.</p>', 'refs' => [], ], 'ImportKeyPairResult' => [ 'base' => '<p>Contains the output of ImportKeyPair.</p>', 'refs' => [], ], 'ImportSnapshotRequest' => [ 'base' => '<p>Contains the parameters for ImportSnapshot.</p>', 'refs' => [], ], 'ImportSnapshotResult' => [ 'base' => '<p>Contains the output for ImportSnapshot.</p>', 'refs' => [], ], 'ImportSnapshotTask' => [ 'base' => '<p>Describes an import snapshot task.</p>', 'refs' => [ 'ImportSnapshotTaskList$member' => NULL, ], ], 'ImportSnapshotTaskList' => [ 'base' => NULL, 'refs' => [ 'DescribeImportSnapshotTasksResult$ImportSnapshotTasks' => '<p>A list of zero or more import snapshot tasks that are currently active or were completed or canceled in the previous 7 days.</p>', ], ], 'ImportTaskIdList' => [ 'base' => NULL, 'refs' => [ 'DescribeImportImageTasksRequest$ImportTaskIds' => '<p>A list of import image task IDs.</p>', 'DescribeImportSnapshotTasksRequest$ImportTaskIds' => '<p>A list of import snapshot task IDs.</p>', ], ], 'ImportVolumeRequest' => [ 'base' => '<p>Contains the parameters for ImportVolume.</p>', 'refs' => [], ], 'ImportVolumeResult' => [ 'base' => '<p>Contains the output for ImportVolume.</p>', 'refs' => [], ], 'ImportVolumeTaskDetails' => [ 'base' => '<p>Describes an import volume task.</p>', 'refs' => [ 'ConversionTask$ImportVolume' => '<p>If the task is for importing a volume, this contains information about the import volume task.</p>', ], ], 'Instance' => [ 'base' => '<p>Describes an instance.</p>', 'refs' => [ 'InstanceList$member' => NULL, ], ], 'InstanceAttribute' => [ 'base' => '<p>Describes an instance attribute.</p>', 'refs' => [], ], 'InstanceAttributeName' => [ 'base' => NULL, 'refs' => [ 'DescribeInstanceAttributeRequest$Attribute' => '<p>The instance attribute.</p> <p>Note: The <code>enaSupport</code> attribute is not supported at this time.</p>', 'ModifyInstanceAttributeRequest$Attribute' => '<p>The name of the attribute.</p>', 'ResetInstanceAttributeRequest$Attribute' => '<p>The attribute to reset.</p> <important> <p>You can only reset the following attributes: <code>kernel</code> | <code>ramdisk</code> | <code>sourceDestCheck</code>. To change an instance attribute, use <a>ModifyInstanceAttribute</a>.</p> </important>', ], ], 'InstanceBlockDeviceMapping' => [ 'base' => '<p>Describes a block device mapping.</p>', 'refs' => [ 'InstanceBlockDeviceMappingList$member' => NULL, ], ], 'InstanceBlockDeviceMappingList' => [ 'base' => NULL, 'refs' => [ 'Instance$BlockDeviceMappings' => '<p>Any block device mapping entries for the instance.</p>', 'InstanceAttribute$BlockDeviceMappings' => '<p>The block device mapping of the instance.</p>', ], ], 'InstanceBlockDeviceMappingSpecification' => [ 'base' => '<p>Describes a block device mapping entry.</p>', 'refs' => [ 'InstanceBlockDeviceMappingSpecificationList$member' => NULL, ], ], 'InstanceBlockDeviceMappingSpecificationList' => [ 'base' => NULL, 'refs' => [ 'ModifyInstanceAttributeRequest$BlockDeviceMappings' => '<p>Modifies the <code>DeleteOnTermination</code> attribute for volumes that are currently attached. The volume must be owned by the caller. If no value is specified for <code>DeleteOnTermination</code>, the default is <code>true</code> and the volume is deleted when the instance is terminated.</p> <p>To add instance store volumes to an Amazon EBS-backed instance, you must add them when you launch the instance. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html#Using_OverridingAMIBDM">Updating the Block Device Mapping when Launching an Instance</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', ], ], 'InstanceCapacity' => [ 'base' => '<p>Information about the instance type that the Dedicated Host supports.</p>', 'refs' => [ 'AvailableInstanceCapacityList$member' => NULL, ], ], 'InstanceCount' => [ 'base' => '<p>Describes a Reserved Instance listing state.</p>', 'refs' => [ 'InstanceCountList$member' => NULL, ], ], 'InstanceCountList' => [ 'base' => NULL, 'refs' => [ 'ReservedInstancesListing$InstanceCounts' => '<p>The number of instances in this state.</p>', ], ], 'InstanceExportDetails' => [ 'base' => '<p>Describes an instance to export.</p>', 'refs' => [ 'ExportTask$InstanceExportDetails' => '<p>Information about the instance to export.</p>', ], ], 'InstanceIdSet' => [ 'base' => NULL, 'refs' => [ 'RunScheduledInstancesResult$InstanceIdSet' => '<p>The IDs of the newly launched instances.</p>', ], ], 'InstanceIdStringList' => [ 'base' => NULL, 'refs' => [ 'DescribeClassicLinkInstancesRequest$InstanceIds' => '<p>One or more instance IDs. Must be instances linked to a VPC through ClassicLink.</p>', 'DescribeInstanceStatusRequest$InstanceIds' => '<p>One or more instance IDs.</p> <p>Default: Describes all your instances.</p> <p>Constraints: Maximum 100 explicitly specified instance IDs.</p>', 'DescribeInstancesRequest$InstanceIds' => '<p>One or more instance IDs.</p> <p>Default: Describes all your instances.</p>', 'MonitorInstancesRequest$InstanceIds' => '<p>One or more instance IDs.</p>', 'RebootInstancesRequest$InstanceIds' => '<p>One or more instance IDs.</p>', 'ReportInstanceStatusRequest$Instances' => '<p>One or more instances.</p>', 'StartInstancesRequest$InstanceIds' => '<p>One or more instance IDs.</p>', 'StopInstancesRequest$InstanceIds' => '<p>One or more instance IDs.</p>', 'TerminateInstancesRequest$InstanceIds' => '<p>One or more instance IDs.</p> <p>Constraints: Up to 1000 instance IDs. We recommend breaking up this request into smaller batches.</p>', 'UnmonitorInstancesRequest$InstanceIds' => '<p>One or more instance IDs.</p>', ], ], 'InstanceLifecycleType' => [ 'base' => NULL, 'refs' => [ 'Instance$InstanceLifecycle' => '<p>Indicates whether this is a Spot instance or a Scheduled Instance.</p>', ], ], 'InstanceList' => [ 'base' => NULL, 'refs' => [ 'Reservation$Instances' => '<p>One or more instances.</p>', ], ], 'InstanceMonitoring' => [ 'base' => '<p>Describes the monitoring information of the instance.</p>', 'refs' => [ 'InstanceMonitoringList$member' => NULL, ], ], 'InstanceMonitoringList' => [ 'base' => NULL, 'refs' => [ 'MonitorInstancesResult$InstanceMonitorings' => '<p>Monitoring information for one or more instances.</p>', 'UnmonitorInstancesResult$InstanceMonitorings' => '<p>Monitoring information for one or more instances.</p>', ], ], 'InstanceNetworkInterface' => [ 'base' => '<p>Describes a network interface.</p>', 'refs' => [ 'InstanceNetworkInterfaceList$member' => NULL, ], ], 'InstanceNetworkInterfaceAssociation' => [ 'base' => '<p>Describes association information for an Elastic IP address.</p>', 'refs' => [ 'InstanceNetworkInterface$Association' => '<p>The association information for an Elastic IP associated with the network interface.</p>', 'InstancePrivateIpAddress$Association' => '<p>The association information for an Elastic IP address for the network interface.</p>', ], ], 'InstanceNetworkInterfaceAttachment' => [ 'base' => '<p>Describes a network interface attachment.</p>', 'refs' => [ 'InstanceNetworkInterface$Attachment' => '<p>The network interface attachment.</p>', ], ], 'InstanceNetworkInterfaceList' => [ 'base' => NULL, 'refs' => [ 'Instance$NetworkInterfaces' => '<p>[EC2-VPC] One or more network interfaces for the instance.</p>', ], ], 'InstanceNetworkInterfaceSpecification' => [ 'base' => '<p>Describes a network interface.</p>', 'refs' => [ 'InstanceNetworkInterfaceSpecificationList$member' => NULL, ], ], 'InstanceNetworkInterfaceSpecificationList' => [ 'base' => NULL, 'refs' => [ 'LaunchSpecification$NetworkInterfaces' => '<p>One or more network interfaces.</p>', 'RequestSpotLaunchSpecification$NetworkInterfaces' => '<p>One or more network interfaces.</p>', 'RunInstancesRequest$NetworkInterfaces' => '<p>One or more network interfaces.</p>', 'SpotFleetLaunchSpecification$NetworkInterfaces' => '<p>One or more network interfaces.</p>', ], ], 'InstancePrivateIpAddress' => [ 'base' => '<p>Describes a private IP address.</p>', 'refs' => [ 'InstancePrivateIpAddressList$member' => NULL, ], ], 'InstancePrivateIpAddressList' => [ 'base' => NULL, 'refs' => [ 'InstanceNetworkInterface$PrivateIpAddresses' => '<p>The private IP addresses associated with the network interface.</p>', ], ], 'InstanceState' => [ 'base' => '<p>Describes the current state of the instance.</p>', 'refs' => [ 'Instance$State' => '<p>The current state of the instance.</p>', 'InstanceStateChange$CurrentState' => '<p>The current state of the instance.</p>', 'InstanceStateChange$PreviousState' => '<p>The previous state of the instance.</p>', 'InstanceStatus$InstanceState' => '<p>The intended state of the instance. <a>DescribeInstanceStatus</a> requires that an instance be in the <code>running</code> state.</p>', ], ], 'InstanceStateChange' => [ 'base' => '<p>Describes an instance state change.</p>', 'refs' => [ 'InstanceStateChangeList$member' => NULL, ], ], 'InstanceStateChangeList' => [ 'base' => NULL, 'refs' => [ 'StartInstancesResult$StartingInstances' => '<p>Information about one or more started instances.</p>', 'StopInstancesResult$StoppingInstances' => '<p>Information about one or more stopped instances.</p>', 'TerminateInstancesResult$TerminatingInstances' => '<p>Information about one or more terminated instances.</p>', ], ], 'InstanceStateName' => [ 'base' => NULL, 'refs' => [ 'InstanceState$Name' => '<p>The current state of the instance.</p>', ], ], 'InstanceStatus' => [ 'base' => '<p>Describes the status of an instance.</p>', 'refs' => [ 'InstanceStatusList$member' => NULL, ], ], 'InstanceStatusDetails' => [ 'base' => '<p>Describes the instance status.</p>', 'refs' => [ 'InstanceStatusDetailsList$member' => NULL, ], ], 'InstanceStatusDetailsList' => [ 'base' => NULL, 'refs' => [ 'InstanceStatusSummary$Details' => '<p>The system instance health or application instance health.</p>', ], ], 'InstanceStatusEvent' => [ 'base' => '<p>Describes a scheduled event for an instance.</p>', 'refs' => [ 'InstanceStatusEventList$member' => NULL, ], ], 'InstanceStatusEventList' => [ 'base' => NULL, 'refs' => [ 'InstanceStatus$Events' => '<p>Any scheduled events associated with the instance.</p>', ], ], 'InstanceStatusList' => [ 'base' => NULL, 'refs' => [ 'DescribeInstanceStatusResult$InstanceStatuses' => '<p>One or more instance status descriptions.</p>', ], ], 'InstanceStatusSummary' => [ 'base' => '<p>Describes the status of an instance.</p>', 'refs' => [ 'InstanceStatus$SystemStatus' => '<p>Reports impaired functionality that stems from issues related to the systems that support an instance, such as hardware failures and network connectivity problems.</p>', 'InstanceStatus$InstanceStatus' => '<p>Reports impaired functionality that stems from issues internal to the instance, such as impaired reachability.</p>', ], ], 'InstanceType' => [ 'base' => NULL, 'refs' => [ 'DescribeReservedInstancesOfferingsRequest$InstanceType' => '<p>The instance type that the reservation will cover (for example, <code>m1.small</code>). For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'ImportInstanceLaunchSpecification$InstanceType' => '<p>The instance type. For more information about the instance types that you can import, see <a href="http://docs.aws.amazon.com/vm-import/latest/userguide/vmimport-image-import.html#vmimport-instance-types">Instance Types</a> in the VM Import/Export User Guide.</p>', 'Instance$InstanceType' => '<p>The instance type.</p>', 'InstanceTypeList$member' => NULL, 'LaunchSpecification$InstanceType' => '<p>The instance type.</p>', 'RequestSpotLaunchSpecification$InstanceType' => '<p>The instance type.</p>', 'ReservedInstances$InstanceType' => '<p>The instance type on which the Reserved Instance can be used.</p>', 'ReservedInstancesConfiguration$InstanceType' => '<p>The instance type for the modified Reserved Instances.</p>', 'ReservedInstancesOffering$InstanceType' => '<p>The instance type on which the Reserved Instance can be used.</p>', 'RunInstancesRequest$InstanceType' => '<p>The instance type. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <p>Default: <code>m1.small</code> </p>', 'SpotFleetLaunchSpecification$InstanceType' => '<p>The instance type.</p>', 'SpotPrice$InstanceType' => '<p>The instance type.</p>', ], ], 'InstanceTypeList' => [ 'base' => NULL, 'refs' => [ 'DescribeSpotPriceHistoryRequest$InstanceTypes' => '<p>Filters the results by the specified instance types.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'AllocateHostsRequest$Quantity' => '<p>The number of Dedicated Hosts you want to allocate to your account with these parameters.</p>', 'AssignPrivateIpAddressesRequest$SecondaryPrivateIpAddressCount' => '<p>The number of secondary IP addresses to assign to the network interface. You can\'t specify this parameter when also specifying private IP addresses.</p>', 'AttachNetworkInterfaceRequest$DeviceIndex' => '<p>The index of the device for the network interface attachment.</p>', 'AuthorizeSecurityGroupEgressRequest$FromPort' => '<p>The start of port range for the TCP and UDP protocols, or an ICMP type number. We recommend that you specify the port range in a set of IP permissions instead.</p>', 'AuthorizeSecurityGroupEgressRequest$ToPort' => '<p>The end of port range for the TCP and UDP protocols, or an ICMP type number. We recommend that you specify the port range in a set of IP permissions instead.</p>', 'AuthorizeSecurityGroupIngressRequest$FromPort' => '<p>The start of port range for the TCP and UDP protocols, or an ICMP type number. For the ICMP type number, use <code>-1</code> to specify all ICMP types.</p>', 'AuthorizeSecurityGroupIngressRequest$ToPort' => '<p>The end of port range for the TCP and UDP protocols, or an ICMP code number. For the ICMP code number, use <code>-1</code> to specify all ICMP codes for the ICMP type.</p>', 'AvailableCapacity$AvailableVCpus' => '<p>The number of vCPUs available on the Dedicated Host.</p>', 'CreateCustomerGatewayRequest$BgpAsn' => '<p>For devices that support BGP, the customer gateway\'s BGP ASN.</p> <p>Default: 65000</p>', 'CreateNetworkAclEntryRequest$RuleNumber' => '<p>The rule number for the entry (for example, 100). ACL entries are processed in ascending order by rule number.</p> <p>Constraints: Positive integer from 1 to 32766. The range 32767 to 65535 is reserved for internal use.</p>', 'CreateNetworkInterfaceRequest$SecondaryPrivateIpAddressCount' => '<p>The number of secondary private IP addresses to assign to a network interface. When you specify a number of secondary IP addresses, Amazon EC2 selects these IP addresses within the subnet range. You can\'t specify this option and specify more than one private IP address using <code>privateIpAddresses</code>.</p> <p>The number of IP addresses you can assign to a network interface varies by instance type. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI">Private IP Addresses Per ENI Per Instance Type</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'CreateReservedInstancesListingRequest$InstanceCount' => '<p>The number of instances that are a part of a Reserved Instance account to be listed in the Reserved Instance Marketplace. This number should be less than or equal to the instance count associated with the Reserved Instance ID specified in this call.</p>', 'CreateVolumeRequest$Size' => '<p>The size of the volume, in GiBs.</p> <p>Constraints: 1-16384 for <code>gp2</code>, 4-16384 for <code>io1</code>, 500-16384 for <code>st1</code>, 500-16384 for <code>sc1</code>, and 1-1024 for <code>standard</code>. If you specify a snapshot, the volume size must be equal to or larger than the snapshot size.</p> <p>Default: If you\'re creating the volume from a snapshot and don\'t specify a volume size, the default is the snapshot size.</p>', 'CreateVolumeRequest$Iops' => '<p>Only valid for Provisioned IOPS SSD volumes. The number of I/O operations per second (IOPS) to provision for the volume, with a maximum ratio of 30 IOPS/GiB.</p> <p>Constraint: Range is 100 to 20000 for Provisioned IOPS SSD volumes </p>', 'DeleteNetworkAclEntryRequest$RuleNumber' => '<p>The rule number of the entry to delete.</p>', 'DescribeClassicLinkInstancesRequest$MaxResults' => '<p>The maximum number of results to return for the request in a single page. The remaining results of the initial request can be seen by sending another request with the returned <code>NextToken</code> value. This value can be between 5 and 1000; if <code>MaxResults</code> is given a value larger than 1000, only 1000 results are returned. You cannot specify this parameter and the instance IDs parameter in the same request.</p> <p>Constraint: If the value is greater than 1000, we return only 1000 items.</p>', 'DescribeFlowLogsRequest$MaxResults' => '<p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the returned <code>NextToken</code> value. This value can be between 5 and 1000; if <code>MaxResults</code> is given a value larger than 1000, only 1000 results are returned. You cannot specify this parameter and the flow log IDs parameter in the same request.</p>', 'DescribeHostReservationOfferingsRequest$MinDuration' => '<p>This is the minimum duration of the reservation you\'d like to purchase, specified in seconds. Reservations are available in one-year and three-year terms. The number of seconds specified must be the number of seconds in a year (365x24x60x60) times one of the supported durations (1 or 3). For example, specify 31536000 for one year.</p>', 'DescribeHostReservationOfferingsRequest$MaxDuration' => '<p>This is the maximum duration of the reservation you\'d like to purchase, specified in seconds. Reservations are available in one-year and three-year terms. The number of seconds specified must be the number of seconds in a year (365x24x60x60) times one of the supported durations (1 or 3). For example, specify 94608000 for three years.</p>', 'DescribeHostReservationOfferingsRequest$MaxResults' => '<p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the returned <code>nextToken</code> value. This value can be between 5 and 500; if <code>maxResults</code> is given a larger value than 500, you will receive an error.</p>', 'DescribeHostReservationsRequest$MaxResults' => '<p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the returned <code>nextToken</code> value. This value can be between 5 and 500; if <code>maxResults</code> is given a larger value than 500, you will receive an error.</p>', 'DescribeHostsRequest$MaxResults' => '<p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the returned <code>nextToken</code> value. This value can be between 5 and 500; if <code>maxResults</code> is given a larger value than 500, you will receive an error. You cannot specify this parameter and the host IDs parameter in the same request.</p>', 'DescribeImportImageTasksRequest$MaxResults' => '<p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>', 'DescribeImportSnapshotTasksRequest$MaxResults' => '<p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>', 'DescribeInstanceStatusRequest$MaxResults' => '<p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value. This value can be between 5 and 1000. You cannot specify this parameter and the instance IDs parameter in the same call.</p>', 'DescribeInstancesRequest$MaxResults' => '<p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value. This value can be between 5 and 1000. You cannot specify this parameter and the instance IDs parameter or tag filters in the same call.</p>', 'DescribeMovingAddressesRequest$MaxResults' => '<p>The maximum number of results to return for the request in a single page. The remaining results of the initial request can be seen by sending another request with the returned <code>NextToken</code> value. This value can be between 5 and 1000; if <code>MaxResults</code> is given a value outside of this range, an error is returned.</p> <p>Default: If no value is provided, the default is 1000.</p>', 'DescribeNatGatewaysRequest$MaxResults' => '<p>The maximum number of items to return for this request. The request returns a token that you can specify in a subsequent call to get the next set of results.</p> <p>Constraint: If the value specified is greater than 1000, we return only 1000 items.</p>', 'DescribePrefixListsRequest$MaxResults' => '<p>The maximum number of items to return for this request. The request returns a token that you can specify in a subsequent call to get the next set of results.</p> <p>Constraint: If the value specified is greater than 1000, we return only 1000 items.</p>', 'DescribeReservedInstancesOfferingsRequest$MaxResults' => '<p>The maximum number of results to return for the request in a single page. The remaining results of the initial request can be seen by sending another request with the returned <code>NextToken</code> value. The maximum is 100.</p> <p>Default: 100</p>', 'DescribeReservedInstancesOfferingsRequest$MaxInstanceCount' => '<p>The maximum number of instances to filter when searching for offerings.</p> <p>Default: 20</p>', 'DescribeScheduledInstanceAvailabilityRequest$MinSlotDurationInHours' => '<p>The minimum available duration, in hours. The minimum required duration is 1,200 hours per year. For example, the minimum daily schedule is 4 hours, the minimum weekly schedule is 24 hours, and the minimum monthly schedule is 100 hours.</p>', 'DescribeScheduledInstanceAvailabilityRequest$MaxSlotDurationInHours' => '<p>The maximum available duration, in hours. This value must be greater than <code>MinSlotDurationInHours</code> and less than 1,720.</p>', 'DescribeScheduledInstanceAvailabilityRequest$MaxResults' => '<p>The maximum number of results to return in a single call. This value can be between 5 and 300. The default value is 300. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>', 'DescribeScheduledInstancesRequest$MaxResults' => '<p>The maximum number of results to return in a single call. This value can be between 5 and 300. The default value is 100. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>', 'DescribeSnapshotsRequest$MaxResults' => '<p>The maximum number of snapshot results returned by <code>DescribeSnapshots</code> in paginated output. When this parameter is used, <code>DescribeSnapshots</code> only returns <code>MaxResults</code> results in a single page along with a <code>NextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>DescribeSnapshots</code> request with the returned <code>NextToken</code> value. This value can be between 5 and 1000; if <code>MaxResults</code> is given a value larger than 1000, only 1000 results are returned. If this parameter is not used, then <code>DescribeSnapshots</code> returns all results. You cannot specify this parameter and the snapshot IDs parameter in the same request.</p>', 'DescribeSpotFleetInstancesRequest$MaxResults' => '<p>The maximum number of results to return in a single call. Specify a value between 1 and 1000. The default value is 1000. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>', 'DescribeSpotFleetRequestHistoryRequest$MaxResults' => '<p>The maximum number of results to return in a single call. Specify a value between 1 and 1000. The default value is 1000. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>', 'DescribeSpotFleetRequestsRequest$MaxResults' => '<p>The maximum number of results to return in a single call. Specify a value between 1 and 1000. The default value is 1000. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>', 'DescribeSpotPriceHistoryRequest$MaxResults' => '<p>The maximum number of results to return in a single call. Specify a value between 1 and 1000. The default value is 1000. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>', 'DescribeTagsRequest$MaxResults' => '<p>The maximum number of results to return in a single call. This value can be between 5 and 1000. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>', 'DescribeVolumeStatusRequest$MaxResults' => '<p>The maximum number of volume results returned by <code>DescribeVolumeStatus</code> in paginated output. When this parameter is used, the request only returns <code>MaxResults</code> results in a single page along with a <code>NextToken</code> response element. The remaining results of the initial request can be seen by sending another request with the returned <code>NextToken</code> value. This value can be between 5 and 1000; if <code>MaxResults</code> is given a value larger than 1000, only 1000 results are returned. If this parameter is not used, then <code>DescribeVolumeStatus</code> returns all results. You cannot specify this parameter and the volume IDs parameter in the same request.</p>', 'DescribeVolumesRequest$MaxResults' => '<p>The maximum number of volume results returned by <code>DescribeVolumes</code> in paginated output. When this parameter is used, <code>DescribeVolumes</code> only returns <code>MaxResults</code> results in a single page along with a <code>NextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>DescribeVolumes</code> request with the returned <code>NextToken</code> value. This value can be between 5 and 1000; if <code>MaxResults</code> is given a value larger than 1000, only 1000 results are returned. If this parameter is not used, then <code>DescribeVolumes</code> returns all results. You cannot specify this parameter and the volume IDs parameter in the same request.</p>', 'DescribeVpcEndpointServicesRequest$MaxResults' => '<p>The maximum number of items to return for this request. The request returns a token that you can specify in a subsequent call to get the next set of results.</p> <p>Constraint: If the value is greater than 1000, we return only 1000 items.</p>', 'DescribeVpcEndpointsRequest$MaxResults' => '<p>The maximum number of items to return for this request. The request returns a token that you can specify in a subsequent call to get the next set of results.</p> <p>Constraint: If the value is greater than 1000, we return only 1000 items.</p>', 'EbsBlockDevice$VolumeSize' => '<p>The size of the volume, in GiB.</p> <p>Constraints: 1-16384 for General Purpose SSD (<code>gp2</code>), 4-16384 for Provisioned IOPS SSD (<code>io1</code>), 500-16384 for Throughput Optimized HDD (<code>st1</code>), 500-16384 for Cold HDD (<code>sc1</code>), and 1-1024 for Magnetic (<code>standard</code>) volumes. If you specify a snapshot, the volume size must be equal to or larger than the snapshot size.</p> <p>Default: If you\'re creating the volume from a snapshot and don\'t specify a volume size, the default is the snapshot size.</p>', 'EbsBlockDevice$Iops' => '<p>The number of I/O operations per second (IOPS) that the volume supports. For <code>io1</code>, this represents the number of IOPS that are provisioned for the volume. For <code>gp2</code>, this represents the baseline performance of the volume and the rate at which the volume accumulates I/O credits for bursting. For more information about General Purpose SSD baseline performance, I/O credits, and bursting, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">Amazon EBS Volume Types</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <p>Constraint: Range is 100-20000 IOPS for <code>io1</code> volumes and 100-10000 IOPS for <code>gp2</code> volumes.</p> <p>Condition: This parameter is required for requests to create <code>io1</code> volumes; it is not used in requests to create <code>gp2</code>, <code>st1</code>, <code>sc1</code>, or <code>standard</code> volumes.</p>', 'HostOffering$Duration' => '<p>The duration of the offering (in seconds).</p>', 'HostProperties$Sockets' => '<p>The number of sockets on the Dedicated Host.</p>', 'HostProperties$Cores' => '<p>The number of cores on the Dedicated Host.</p>', 'HostProperties$TotalVCpus' => '<p>The number of vCPUs on the Dedicated Host.</p>', 'HostReservation$Count' => '<p>The number of Dedicated Hosts the reservation is associated with.</p>', 'HostReservation$Duration' => '<p>The length of the reservation\'s term, specified in seconds. Can be <code>31536000 (1 year)</code> | <code>94608000 (3 years)</code>.</p>', 'IcmpTypeCode$Type' => '<p>The ICMP code. A value of -1 means all codes for the specified ICMP type.</p>', 'IcmpTypeCode$Code' => '<p>The ICMP type. A value of -1 means all types.</p>', 'Instance$AmiLaunchIndex' => '<p>The AMI launch index, which can be used to find this instance in the launch group.</p>', 'InstanceCapacity$AvailableCapacity' => '<p>The number of instances that can still be launched onto the Dedicated Host.</p>', 'InstanceCapacity$TotalCapacity' => '<p>The total number of instances that can be launched onto the Dedicated Host.</p>', 'InstanceCount$InstanceCount' => '<p>The number of listed Reserved Instances in the state specified by the <code>state</code>.</p>', 'InstanceNetworkInterfaceAttachment$DeviceIndex' => '<p>The index of the device on the instance for the network interface attachment.</p>', 'InstanceNetworkInterfaceSpecification$DeviceIndex' => '<p>The index of the device on the instance for the network interface attachment. If you are specifying a network interface in a <a>RunInstances</a> request, you must provide the device index.</p>', 'InstanceNetworkInterfaceSpecification$SecondaryPrivateIpAddressCount' => '<p>The number of secondary private IP addresses. You can\'t specify this option and specify more than one private IP address using the private IP addresses option. You cannot specify this option if you\'re launching more than one instance in a <a>RunInstances</a> request.</p>', 'InstanceState$Code' => '<p>The low byte represents the state. The high byte is an opaque internal value and should be ignored.</p> <ul> <li> <p> <code>0</code> : <code>pending</code> </p> </li> <li> <p> <code>16</code> : <code>running</code> </p> </li> <li> <p> <code>32</code> : <code>shutting-down</code> </p> </li> <li> <p> <code>48</code> : <code>terminated</code> </p> </li> <li> <p> <code>64</code> : <code>stopping</code> </p> </li> <li> <p> <code>80</code> : <code>stopped</code> </p> </li> </ul>', 'IpPermission$FromPort' => '<p>The start of port range for the TCP and UDP protocols, or an ICMP type number. A value of <code>-1</code> indicates all ICMP types.</p>', 'IpPermission$ToPort' => '<p>The end of port range for the TCP and UDP protocols, or an ICMP code. A value of <code>-1</code> indicates all ICMP codes for the specified ICMP type.</p>', 'ModifySpotFleetRequestRequest$TargetCapacity' => '<p>The size of the fleet.</p>', 'NetworkAclEntry$RuleNumber' => '<p>The rule number for the entry. ACL entries are processed in ascending order by rule number.</p>', 'NetworkInterfaceAttachment$DeviceIndex' => '<p>The device index of the network interface attachment on the instance.</p>', 'OccurrenceDayRequestSet$member' => NULL, 'OccurrenceDaySet$member' => NULL, 'PortRange$From' => '<p>The first port in the range.</p>', 'PortRange$To' => '<p>The last port in the range.</p>', 'PricingDetail$Count' => '<p>The number of reservations available for the price.</p>', 'Purchase$Duration' => '<p>The duration of the reservation\'s term in seconds.</p>', 'PurchaseRequest$InstanceCount' => '<p>The number of instances.</p>', 'PurchaseReservedInstancesOfferingRequest$InstanceCount' => '<p>The number of Reserved Instances to purchase.</p>', 'ReplaceNetworkAclEntryRequest$RuleNumber' => '<p>The rule number of the entry to replace.</p>', 'RequestSpotInstancesRequest$InstanceCount' => '<p>The maximum number of Spot instances to launch.</p> <p>Default: 1</p>', 'RequestSpotInstancesRequest$BlockDurationMinutes' => '<p>The required duration for the Spot instances (also known as Spot blocks), in minutes. This value must be a multiple of 60 (60, 120, 180, 240, 300, or 360).</p> <p>The duration period starts as soon as your Spot instance receives its instance ID. At the end of the duration period, Amazon EC2 marks the Spot instance for termination and provides a Spot instance termination notice, which gives the instance a two-minute warning before it terminates.</p> <p>Note that you can\'t specify an Availability Zone group or a launch group if you specify a duration.</p>', 'ReservedInstances$InstanceCount' => '<p>The number of reservations purchased.</p>', 'ReservedInstancesConfiguration$InstanceCount' => '<p>The number of modified Reserved Instances.</p>', 'RevokeSecurityGroupEgressRequest$FromPort' => '<p>The start of port range for the TCP and UDP protocols, or an ICMP type number. We recommend that you specify the port range in a set of IP permissions instead.</p>', 'RevokeSecurityGroupEgressRequest$ToPort' => '<p>The end of port range for the TCP and UDP protocols, or an ICMP type number. We recommend that you specify the port range in a set of IP permissions instead.</p>', 'RevokeSecurityGroupIngressRequest$FromPort' => '<p>The start of port range for the TCP and UDP protocols, or an ICMP type number. For the ICMP type number, use <code>-1</code> to specify all ICMP types.</p>', 'RevokeSecurityGroupIngressRequest$ToPort' => '<p>The end of port range for the TCP and UDP protocols, or an ICMP code number. For the ICMP code number, use <code>-1</code> to specify all ICMP codes for the ICMP type.</p>', 'RunInstancesRequest$MinCount' => '<p>The minimum number of instances to launch. If you specify a minimum that is more instances than Amazon EC2 can launch in the target Availability Zone, Amazon EC2 launches no instances.</p> <p>Constraints: Between 1 and the maximum number you\'re allowed for the specified instance type. For more information about the default limits, and how to request an increase, see <a href="http://aws.amazon.com/ec2/faqs/#How_many_instances_can_I_run_in_Amazon_EC2">How many instances can I run in Amazon EC2</a> in the Amazon EC2 General FAQ.</p>', 'RunInstancesRequest$MaxCount' => '<p>The maximum number of instances to launch. If you specify more instances than Amazon EC2 can launch in the target Availability Zone, Amazon EC2 launches the largest possible number of instances above <code>MinCount</code>.</p> <p>Constraints: Between 1 and the maximum number you\'re allowed for the specified instance type. For more information about the default limits, and how to request an increase, see <a href="http://aws.amazon.com/ec2/faqs/#How_many_instances_can_I_run_in_Amazon_EC2">How many instances can I run in Amazon EC2</a> in the Amazon EC2 FAQ.</p>', 'RunScheduledInstancesRequest$InstanceCount' => '<p>The number of instances.</p> <p>Default: 1</p>', 'ScheduledInstance$SlotDurationInHours' => '<p>The number of hours in the schedule.</p>', 'ScheduledInstance$TotalScheduledInstanceHours' => '<p>The total number of hours for a single instance for the entire term.</p>', 'ScheduledInstance$InstanceCount' => '<p>The number of instances.</p>', 'ScheduledInstanceAvailability$SlotDurationInHours' => '<p>The number of hours in the schedule.</p>', 'ScheduledInstanceAvailability$TotalScheduledInstanceHours' => '<p>The total number of hours for a single instance for the entire term.</p>', 'ScheduledInstanceAvailability$AvailableInstanceCount' => '<p>The number of available instances.</p>', 'ScheduledInstanceAvailability$MinTermDurationInDays' => '<p>The minimum term. The only possible value is 365 days.</p>', 'ScheduledInstanceAvailability$MaxTermDurationInDays' => '<p>The maximum term. The only possible value is 365 days.</p>', 'ScheduledInstanceRecurrence$Interval' => '<p>The interval quantity. The interval unit depends on the value of <code>frequency</code>. For example, every 2 weeks or every 2 months.</p>', 'ScheduledInstanceRecurrenceRequest$Interval' => '<p>The interval quantity. The interval unit depends on the value of <code>Frequency</code>. For example, every 2 weeks or every 2 months.</p>', 'ScheduledInstancesEbs$VolumeSize' => '<p>The size of the volume, in GiB.</p> <p>Default: If you\'re creating the volume from a snapshot and don\'t specify a volume size, the default is the snapshot size.</p>', 'ScheduledInstancesEbs$Iops' => '<p>The number of I/O operations per second (IOPS) that the volume supports. For io1 volumes, this represents the number of IOPS that are provisioned for the volume. For <code>gp2</code> volumes, this represents the baseline performance of the volume and the rate at which the volume accumulates I/O credits for bursting. For more information about <code>gp2</code> baseline performance, I/O credits, and bursting, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">Amazon EBS Volume Types</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <p>Constraint: Range is 100-20000 IOPS for <code>io1</code> volumes and 100-10000 IOPS for <code>gp2</code> volumes.</p> <p>Condition: This parameter is required for requests to create <code>io1</code>volumes; it is not used in requests to create <code>gp2</code>, <code>st1</code>, <code>sc1</code>, or <code>standard</code> volumes.</p>', 'ScheduledInstancesNetworkInterface$DeviceIndex' => '<p>The index of the device for the network interface attachment.</p>', 'ScheduledInstancesNetworkInterface$SecondaryPrivateIpAddressCount' => '<p>The number of secondary private IP addresses.</p>', 'Snapshot$VolumeSize' => '<p>The size of the volume, in GiB.</p>', 'SpotFleetRequestConfigData$TargetCapacity' => '<p>The number of units to request. You can choose to set the target capacity in terms of instances or a performance characteristic that is important to your application workload, such as vCPUs, memory, or I/O.</p>', 'SpotInstanceRequest$BlockDurationMinutes' => '<p>The duration for the Spot instance, in minutes.</p>', 'StaleIpPermission$FromPort' => '<p>The start of the port range for the TCP and UDP protocols, or an ICMP type number. A value of <code>-1</code> indicates all ICMP types. </p>', 'StaleIpPermission$ToPort' => '<p>The end of the port range for the TCP and UDP protocols, or an ICMP type number. A value of <code>-1</code> indicates all ICMP types. </p>', 'Subnet$AvailableIpAddressCount' => '<p>The number of unused IP addresses in the subnet. Note that the IP addresses for any stopped instances are considered unavailable.</p>', 'TargetConfiguration$InstanceCount' => '<p>The number of instances the Convertible Reserved Instance offering can be applied to. This parameter is reserved and cannot be specified in a request</p>', 'TargetConfigurationRequest$InstanceCount' => '<p>The number of instances the Covertible Reserved Instance offering can be applied to. This parameter is reserved and cannot be specified in a request</p>', 'VgwTelemetry$AcceptedRouteCount' => '<p>The number of accepted routes.</p>', 'Volume$Size' => '<p>The size of the volume, in GiBs.</p>', 'Volume$Iops' => '<p>The number of I/O operations per second (IOPS) that the volume supports. For Provisioned IOPS SSD volumes, this represents the number of IOPS that are provisioned for the volume. For General Purpose SSD volumes, this represents the baseline performance of the volume and the rate at which the volume accumulates I/O credits for bursting. For more information on General Purpose SSD baseline performance, I/O credits, and bursting, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">Amazon EBS Volume Types</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <p>Constraint: Range is 100-20000 IOPS for io1 volumes and 100-10000 IOPS for <code>gp2</code> volumes.</p> <p>Condition: This parameter is required for requests to create <code>io1</code> volumes; it is not used in requests to create <code>gp2</code>, <code>st1</code>, <code>sc1</code>, or <code>standard</code> volumes.</p>', ], ], 'InternetGateway' => [ 'base' => '<p>Describes an Internet gateway.</p>', 'refs' => [ 'CreateInternetGatewayResult$InternetGateway' => '<p>Information about the Internet gateway.</p>', 'InternetGatewayList$member' => NULL, ], ], 'InternetGatewayAttachment' => [ 'base' => '<p>Describes the attachment of a VPC to an Internet gateway.</p>', 'refs' => [ 'InternetGatewayAttachmentList$member' => NULL, ], ], 'InternetGatewayAttachmentList' => [ 'base' => NULL, 'refs' => [ 'InternetGateway$Attachments' => '<p>Any VPCs attached to the Internet gateway.</p>', ], ], 'InternetGatewayList' => [ 'base' => NULL, 'refs' => [ 'DescribeInternetGatewaysResult$InternetGateways' => '<p>Information about one or more Internet gateways.</p>', ], ], 'IpPermission' => [ 'base' => '<p>Describes a security group rule.</p>', 'refs' => [ 'IpPermissionList$member' => NULL, ], ], 'IpPermissionList' => [ 'base' => NULL, 'refs' => [ 'AuthorizeSecurityGroupEgressRequest$IpPermissions' => '<p>A set of IP permissions. You can\'t specify a destination security group and a CIDR IP address range.</p>', 'AuthorizeSecurityGroupIngressRequest$IpPermissions' => '<p>A set of IP permissions. Can be used to specify multiple rules in a single command.</p>', 'RevokeSecurityGroupEgressRequest$IpPermissions' => '<p>A set of IP permissions. You can\'t specify a destination security group and a CIDR IP address range.</p>', 'RevokeSecurityGroupIngressRequest$IpPermissions' => '<p>A set of IP permissions. You can\'t specify a source security group and a CIDR IP address range.</p>', 'SecurityGroup$IpPermissions' => '<p>One or more inbound rules associated with the security group.</p>', 'SecurityGroup$IpPermissionsEgress' => '<p>[EC2-VPC] One or more outbound rules associated with the security group.</p>', ], ], 'IpRange' => [ 'base' => '<p>Describes an IP range.</p>', 'refs' => [ 'IpRangeList$member' => NULL, ], ], 'IpRangeList' => [ 'base' => NULL, 'refs' => [ 'IpPermission$IpRanges' => '<p>One or more IP ranges.</p>', ], ], 'IpRanges' => [ 'base' => NULL, 'refs' => [ 'StaleIpPermission$IpRanges' => '<p>One or more IP ranges. Not applicable for stale security group rules.</p>', ], ], 'KeyNameStringList' => [ 'base' => NULL, 'refs' => [ 'DescribeKeyPairsRequest$KeyNames' => '<p>One or more key pair names.</p> <p>Default: Describes all your key pairs.</p>', ], ], 'KeyPair' => [ 'base' => '<p>Describes a key pair.</p>', 'refs' => [], ], 'KeyPairInfo' => [ 'base' => '<p>Describes a key pair.</p>', 'refs' => [ 'KeyPairList$member' => NULL, ], ], 'KeyPairList' => [ 'base' => NULL, 'refs' => [ 'DescribeKeyPairsResult$KeyPairs' => '<p>Information about one or more key pairs.</p>', ], ], 'LaunchPermission' => [ 'base' => '<p>Describes a launch permission.</p>', 'refs' => [ 'LaunchPermissionList$member' => NULL, ], ], 'LaunchPermissionList' => [ 'base' => NULL, 'refs' => [ 'ImageAttribute$LaunchPermissions' => '<p>One or more launch permissions.</p>', 'LaunchPermissionModifications$Add' => '<p>The AWS account ID to add to the list of launch permissions for the AMI.</p>', 'LaunchPermissionModifications$Remove' => '<p>The AWS account ID to remove from the list of launch permissions for the AMI.</p>', ], ], 'LaunchPermissionModifications' => [ 'base' => '<p>Describes a launch permission modification.</p>', 'refs' => [ 'ModifyImageAttributeRequest$LaunchPermission' => '<p>A launch permission modification.</p>', ], ], 'LaunchSpecification' => [ 'base' => '<p>Describes the launch specification for an instance.</p>', 'refs' => [ 'SpotInstanceRequest$LaunchSpecification' => '<p>Additional information for launching instances.</p>', ], ], 'LaunchSpecsList' => [ 'base' => NULL, 'refs' => [ 'SpotFleetRequestConfigData$LaunchSpecifications' => '<p>Information about the launch specifications for the Spot fleet request.</p>', ], ], 'ListingState' => [ 'base' => NULL, 'refs' => [ 'InstanceCount$State' => '<p>The states of the listed Reserved Instances.</p>', ], ], 'ListingStatus' => [ 'base' => NULL, 'refs' => [ 'ReservedInstancesListing$Status' => '<p>The status of the Reserved Instance listing.</p>', ], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'DescribeReservedInstancesOfferingsRequest$MinDuration' => '<p>The minimum duration (in seconds) to filter when searching for offerings.</p> <p>Default: 2592000 (1 month)</p>', 'DescribeReservedInstancesOfferingsRequest$MaxDuration' => '<p>The maximum duration (in seconds) to filter when searching for offerings.</p> <p>Default: 94608000 (3 years)</p>', 'DiskImageDescription$Size' => '<p>The size of the disk image, in GiB.</p>', 'DiskImageDetail$Bytes' => '<p>The size of the disk image, in GiB.</p>', 'DiskImageVolumeDescription$Size' => '<p>The size of the volume, in GiB.</p>', 'ImportInstanceVolumeDetailItem$BytesConverted' => '<p>The number of bytes converted so far.</p>', 'ImportVolumeTaskDetails$BytesConverted' => '<p>The number of bytes converted so far.</p>', 'PriceSchedule$Term' => '<p>The number of months remaining in the reservation. For example, 2 is the second to the last month before the capacity reservation expires.</p>', 'PriceScheduleSpecification$Term' => '<p>The number of months remaining in the reservation. For example, 2 is the second to the last month before the capacity reservation expires.</p>', 'ReservedInstances$Duration' => '<p>The duration of the Reserved Instance, in seconds.</p>', 'ReservedInstancesOffering$Duration' => '<p>The duration of the Reserved Instance, in seconds.</p>', 'VolumeDetail$Size' => '<p>The size of the volume, in GiB.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeStaleSecurityGroupsRequest$MaxResults' => '<p>The maximum number of items to return for this request. The request returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'DescribeVpcClassicLinkDnsSupportRequest$MaxResults' => '<p>The maximum number of items to return for this request. The request returns a token that you can specify in a subsequent call to get the next set of results.</p>', ], ], 'ModifyHostsRequest' => [ 'base' => '<p>Contains the parameters for ModifyHosts.</p>', 'refs' => [], ], 'ModifyHostsResult' => [ 'base' => '<p>Contains the output of ModifyHosts.</p>', 'refs' => [], ], 'ModifyIdFormatRequest' => [ 'base' => '<p>Contains the parameters of ModifyIdFormat.</p>', 'refs' => [], ], 'ModifyIdentityIdFormatRequest' => [ 'base' => '<p>Contains the parameters of ModifyIdentityIdFormat.</p>', 'refs' => [], ], 'ModifyImageAttributeRequest' => [ 'base' => '<p>Contains the parameters for ModifyImageAttribute.</p>', 'refs' => [], ], 'ModifyInstanceAttributeRequest' => [ 'base' => '<p>Contains the parameters for ModifyInstanceAttribute.</p>', 'refs' => [], ], 'ModifyInstancePlacementRequest' => [ 'base' => '<p>Contains the parameters for ModifyInstancePlacement.</p>', 'refs' => [], ], 'ModifyInstancePlacementResult' => [ 'base' => '<p>Contains the output of ModifyInstancePlacement.</p>', 'refs' => [], ], 'ModifyNetworkInterfaceAttributeRequest' => [ 'base' => '<p>Contains the parameters for ModifyNetworkInterfaceAttribute.</p>', 'refs' => [], ], 'ModifyReservedInstancesRequest' => [ 'base' => '<p>Contains the parameters for ModifyReservedInstances.</p>', 'refs' => [], ], 'ModifyReservedInstancesResult' => [ 'base' => '<p>Contains the output of ModifyReservedInstances.</p>', 'refs' => [], ], 'ModifySnapshotAttributeRequest' => [ 'base' => '<p>Contains the parameters for ModifySnapshotAttribute.</p>', 'refs' => [], ], 'ModifySpotFleetRequestRequest' => [ 'base' => '<p>Contains the parameters for ModifySpotFleetRequest.</p>', 'refs' => [], ], 'ModifySpotFleetRequestResponse' => [ 'base' => '<p>Contains the output of ModifySpotFleetRequest.</p>', 'refs' => [], ], 'ModifySubnetAttributeRequest' => [ 'base' => '<p>Contains the parameters for ModifySubnetAttribute.</p>', 'refs' => [], ], 'ModifyVolumeAttributeRequest' => [ 'base' => '<p>Contains the parameters for ModifyVolumeAttribute.</p>', 'refs' => [], ], 'ModifyVpcAttributeRequest' => [ 'base' => '<p>Contains the parameters for ModifyVpcAttribute.</p>', 'refs' => [], ], 'ModifyVpcEndpointRequest' => [ 'base' => '<p>Contains the parameters for ModifyVpcEndpoint.</p>', 'refs' => [], ], 'ModifyVpcEndpointResult' => [ 'base' => '<p>Contains the output of ModifyVpcEndpoint.</p>', 'refs' => [], ], 'ModifyVpcPeeringConnectionOptionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ModifyVpcPeeringConnectionOptionsResult' => [ 'base' => NULL, 'refs' => [], ], 'MonitorInstancesRequest' => [ 'base' => '<p>Contains the parameters for MonitorInstances.</p>', 'refs' => [], ], 'MonitorInstancesResult' => [ 'base' => '<p>Contains the output of MonitorInstances.</p>', 'refs' => [], ], 'Monitoring' => [ 'base' => '<p>Describes the monitoring for the instance.</p>', 'refs' => [ 'Instance$Monitoring' => '<p>The monitoring information for the instance.</p>', 'InstanceMonitoring$Monitoring' => '<p>The monitoring information.</p>', ], ], 'MonitoringState' => [ 'base' => NULL, 'refs' => [ 'Monitoring$State' => '<p>Indicates whether monitoring is enabled for the instance.</p>', ], ], 'MoveAddressToVpcRequest' => [ 'base' => '<p>Contains the parameters for MoveAddressToVpc.</p>', 'refs' => [], ], 'MoveAddressToVpcResult' => [ 'base' => '<p>Contains the output of MoveAddressToVpc.</p>', 'refs' => [], ], 'MoveStatus' => [ 'base' => NULL, 'refs' => [ 'MovingAddressStatus$MoveStatus' => '<p>The status of the Elastic IP address that\'s being moved to the EC2-VPC platform, or restored to the EC2-Classic platform.</p>', ], ], 'MovingAddressStatus' => [ 'base' => '<p>Describes the status of a moving Elastic IP address.</p>', 'refs' => [ 'MovingAddressStatusSet$member' => NULL, ], ], 'MovingAddressStatusSet' => [ 'base' => NULL, 'refs' => [ 'DescribeMovingAddressesResult$MovingAddressStatuses' => '<p>The status for each Elastic IP address.</p>', ], ], 'NatGateway' => [ 'base' => '<p>Describes a NAT gateway.</p>', 'refs' => [ 'CreateNatGatewayResult$NatGateway' => '<p>Information about the NAT gateway.</p>', 'NatGatewayList$member' => NULL, ], ], 'NatGatewayAddress' => [ 'base' => '<p>Describes the IP addresses and network interface associated with a NAT gateway.</p>', 'refs' => [ 'NatGatewayAddressList$member' => NULL, ], ], 'NatGatewayAddressList' => [ 'base' => NULL, 'refs' => [ 'NatGateway$NatGatewayAddresses' => '<p>Information about the IP addresses and network interface associated with the NAT gateway.</p>', ], ], 'NatGatewayList' => [ 'base' => NULL, 'refs' => [ 'DescribeNatGatewaysResult$NatGateways' => '<p>Information about the NAT gateways.</p>', ], ], 'NatGatewayState' => [ 'base' => NULL, 'refs' => [ 'NatGateway$State' => '<p>The state of the NAT gateway.</p> <ul> <li> <p> <code>pending</code>: The NAT gateway is being created and is not ready to process traffic.</p> </li> <li> <p> <code>failed</code>: The NAT gateway could not be created. Check the <code>failureCode</code> and <code>failureMessage</code> fields for the reason.</p> </li> <li> <p> <code>available</code>: The NAT gateway is able to process traffic. This status remains until you delete the NAT gateway, and does not indicate the health of the NAT gateway.</p> </li> <li> <p> <code>deleting</code>: The NAT gateway is in the process of being terminated and may still be processing traffic.</p> </li> <li> <p> <code>deleted</code>: The NAT gateway has been terminated and is no longer processing traffic.</p> </li> </ul>', ], ], 'NetworkAcl' => [ 'base' => '<p>Describes a network ACL.</p>', 'refs' => [ 'CreateNetworkAclResult$NetworkAcl' => '<p>Information about the network ACL.</p>', 'NetworkAclList$member' => NULL, ], ], 'NetworkAclAssociation' => [ 'base' => '<p>Describes an association between a network ACL and a subnet.</p>', 'refs' => [ 'NetworkAclAssociationList$member' => NULL, ], ], 'NetworkAclAssociationList' => [ 'base' => NULL, 'refs' => [ 'NetworkAcl$Associations' => '<p>Any associations between the network ACL and one or more subnets</p>', ], ], 'NetworkAclEntry' => [ 'base' => '<p>Describes an entry in a network ACL.</p>', 'refs' => [ 'NetworkAclEntryList$member' => NULL, ], ], 'NetworkAclEntryList' => [ 'base' => NULL, 'refs' => [ 'NetworkAcl$Entries' => '<p>One or more entries (rules) in the network ACL.</p>', ], ], 'NetworkAclList' => [ 'base' => NULL, 'refs' => [ 'DescribeNetworkAclsResult$NetworkAcls' => '<p>Information about one or more network ACLs.</p>', ], ], 'NetworkInterface' => [ 'base' => '<p>Describes a network interface.</p>', 'refs' => [ 'CreateNetworkInterfaceResult$NetworkInterface' => '<p>Information about the network interface.</p>', 'NetworkInterfaceList$member' => NULL, ], ], 'NetworkInterfaceAssociation' => [ 'base' => '<p>Describes association information for an Elastic IP address.</p>', 'refs' => [ 'NetworkInterface$Association' => '<p>The association information for an Elastic IP associated with the network interface.</p>', 'NetworkInterfacePrivateIpAddress$Association' => '<p>The association information for an Elastic IP address associated with the network interface.</p>', ], ], 'NetworkInterfaceAttachment' => [ 'base' => '<p>Describes a network interface attachment.</p>', 'refs' => [ 'DescribeNetworkInterfaceAttributeResult$Attachment' => '<p>The attachment (if any) of the network interface.</p>', 'NetworkInterface$Attachment' => '<p>The network interface attachment.</p>', ], ], 'NetworkInterfaceAttachmentChanges' => [ 'base' => '<p>Describes an attachment change.</p>', 'refs' => [ 'ModifyNetworkInterfaceAttributeRequest$Attachment' => '<p>Information about the interface attachment. If modifying the \'delete on termination\' attribute, you must specify the ID of the interface attachment.</p>', ], ], 'NetworkInterfaceAttribute' => [ 'base' => NULL, 'refs' => [ 'DescribeNetworkInterfaceAttributeRequest$Attribute' => '<p>The attribute of the network interface.</p>', ], ], 'NetworkInterfaceIdList' => [ 'base' => NULL, 'refs' => [ 'DescribeNetworkInterfacesRequest$NetworkInterfaceIds' => '<p>One or more network interface IDs.</p> <p>Default: Describes all your network interfaces.</p>', ], ], 'NetworkInterfaceList' => [ 'base' => NULL, 'refs' => [ 'DescribeNetworkInterfacesResult$NetworkInterfaces' => '<p>Information about one or more network interfaces.</p>', ], ], 'NetworkInterfacePrivateIpAddress' => [ 'base' => '<p>Describes the private IP address of a network interface.</p>', 'refs' => [ 'NetworkInterfacePrivateIpAddressList$member' => NULL, ], ], 'NetworkInterfacePrivateIpAddressList' => [ 'base' => NULL, 'refs' => [ 'NetworkInterface$PrivateIpAddresses' => '<p>The private IP addresses associated with the network interface.</p>', ], ], 'NetworkInterfaceStatus' => [ 'base' => NULL, 'refs' => [ 'InstanceNetworkInterface$Status' => '<p>The status of the network interface.</p>', 'NetworkInterface$Status' => '<p>The status of the network interface.</p>', ], ], 'NetworkInterfaceType' => [ 'base' => NULL, 'refs' => [ 'NetworkInterface$InterfaceType' => '<p>The type of interface.</p>', ], ], 'NewDhcpConfiguration' => [ 'base' => NULL, 'refs' => [ 'NewDhcpConfigurationList$member' => NULL, ], ], 'NewDhcpConfigurationList' => [ 'base' => NULL, 'refs' => [ 'CreateDhcpOptionsRequest$DhcpConfigurations' => '<p>A DHCP configuration option.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'DescribeStaleSecurityGroupsRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a prior call.)</p>', 'DescribeVpcClassicLinkDnsSupportRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a prior call.)</p>', 'DescribeVpcClassicLinkDnsSupportResult$NextToken' => '<p>The token to use when requesting the next set of items.</p>', ], ], 'OccurrenceDayRequestSet' => [ 'base' => NULL, 'refs' => [ 'ScheduledInstanceRecurrenceRequest$OccurrenceDays' => '<p>The days. For a monthly schedule, this is one or more days of the month (1-31). For a weekly schedule, this is one or more days of the week (1-7, where 1 is Sunday). You can\'t specify this value with a daily schedule. If the occurrence is relative to the end of the month, you can specify only a single day.</p>', ], ], 'OccurrenceDaySet' => [ 'base' => NULL, 'refs' => [ 'ScheduledInstanceRecurrence$OccurrenceDaySet' => '<p>The days. For a monthly schedule, this is one or more days of the month (1-31). For a weekly schedule, this is one or more days of the week (1-7, where 1 is Sunday).</p>', ], ], 'OfferingClassType' => [ 'base' => NULL, 'refs' => [ 'DescribeReservedInstancesOfferingsRequest$OfferingClass' => '<p>The offering class of the Reserved Instance. Can be <code>standard</code> or <code>convertible</code>.</p>', 'DescribeReservedInstancesRequest$OfferingClass' => '<p>Describes whether the Reserved Instance is Standard or Convertible.</p>', 'ReservedInstances$OfferingClass' => '<p>The offering class of the Reserved Instance.</p>', 'ReservedInstancesOffering$OfferingClass' => '<p>If <code>convertible</code> it can be exchanged for Reserved Instances of the same or higher monetary value, with different configurations. If <code>standard</code>, it is not possible to perform an exchange.</p>', ], ], 'OfferingTypeValues' => [ 'base' => NULL, 'refs' => [ 'DescribeReservedInstancesOfferingsRequest$OfferingType' => '<p>The Reserved Instance offering type. If you are using tools that predate the 2011-11-01 API version, you only have access to the <code>Medium Utilization</code> Reserved Instance offering type. </p>', 'DescribeReservedInstancesRequest$OfferingType' => '<p>The Reserved Instance offering type. If you are using tools that predate the 2011-11-01 API version, you only have access to the <code>Medium Utilization</code> Reserved Instance offering type.</p>', 'ReservedInstances$OfferingType' => '<p>The Reserved Instance offering type.</p>', 'ReservedInstancesOffering$OfferingType' => '<p>The Reserved Instance offering type.</p>', ], ], 'OperationType' => [ 'base' => NULL, 'refs' => [ 'ModifyImageAttributeRequest$OperationType' => '<p>The operation type.</p>', 'ModifySnapshotAttributeRequest$OperationType' => '<p>The type of operation to perform to the attribute.</p>', ], ], 'OwnerStringList' => [ 'base' => NULL, 'refs' => [ 'DescribeImagesRequest$Owners' => '<p>Filters the images by the owner. Specify an AWS account ID, <code>self</code> (owner is the sender of the request), or an AWS owner alias (valid values are <code>amazon</code> | <code>aws-marketplace</code> | <code>microsoft</code>). Omitting this option returns all images for which you have launch permissions, regardless of ownership.</p>', 'DescribeSnapshotsRequest$OwnerIds' => '<p>Returns the snapshots owned by the specified owner. Multiple owners can be specified.</p>', ], ], 'PaymentOption' => [ 'base' => NULL, 'refs' => [ 'HostOffering$PaymentOption' => '<p>The available payment option.</p>', 'HostReservation$PaymentOption' => '<p>The payment option selected for this reservation.</p>', 'Purchase$PaymentOption' => '<p>The payment option for the reservation.</p>', ], ], 'PeeringConnectionOptions' => [ 'base' => '<p>Describes the VPC peering connection options.</p>', 'refs' => [ 'ModifyVpcPeeringConnectionOptionsResult$RequesterPeeringConnectionOptions' => '<p>Information about the VPC peering connection options for the requester VPC.</p>', 'ModifyVpcPeeringConnectionOptionsResult$AccepterPeeringConnectionOptions' => '<p>Information about the VPC peering connection options for the accepter VPC.</p>', ], ], 'PeeringConnectionOptionsRequest' => [ 'base' => '<p>The VPC peering connection options.</p>', 'refs' => [ 'ModifyVpcPeeringConnectionOptionsRequest$RequesterPeeringConnectionOptions' => '<p>The VPC peering connection options for the requester VPC.</p>', 'ModifyVpcPeeringConnectionOptionsRequest$AccepterPeeringConnectionOptions' => '<p>The VPC peering connection options for the accepter VPC.</p>', ], ], 'PermissionGroup' => [ 'base' => NULL, 'refs' => [ 'CreateVolumePermission$Group' => '<p>The specific group that is to be added or removed from a volume\'s list of create volume permissions.</p>', 'LaunchPermission$Group' => '<p>The name of the group.</p>', ], ], 'Placement' => [ 'base' => '<p>Describes the placement for the instance.</p>', 'refs' => [ 'ImportInstanceLaunchSpecification$Placement' => '<p>The placement information for the instance.</p>', 'Instance$Placement' => '<p>The location where the instance launched, if applicable.</p>', 'RunInstancesRequest$Placement' => '<p>The placement for the instance.</p>', ], ], 'PlacementGroup' => [ 'base' => '<p>Describes a placement group.</p>', 'refs' => [ 'PlacementGroupList$member' => NULL, ], ], 'PlacementGroupList' => [ 'base' => NULL, 'refs' => [ 'DescribePlacementGroupsResult$PlacementGroups' => '<p>One or more placement groups.</p>', ], ], 'PlacementGroupState' => [ 'base' => NULL, 'refs' => [ 'PlacementGroup$State' => '<p>The state of the placement group.</p>', ], ], 'PlacementGroupStringList' => [ 'base' => NULL, 'refs' => [ 'DescribePlacementGroupsRequest$GroupNames' => '<p>One or more placement group names.</p> <p>Default: Describes all your placement groups, or only those otherwise specified.</p>', ], ], 'PlacementStrategy' => [ 'base' => NULL, 'refs' => [ 'CreatePlacementGroupRequest$Strategy' => '<p>The placement strategy.</p>', 'PlacementGroup$Strategy' => '<p>The placement strategy.</p>', ], ], 'PlatformValues' => [ 'base' => NULL, 'refs' => [ 'Image$Platform' => '<p>The value is <code>Windows</code> for Windows AMIs; otherwise blank.</p>', 'ImportInstanceRequest$Platform' => '<p>The instance operating system.</p>', 'ImportInstanceTaskDetails$Platform' => '<p>The instance operating system.</p>', 'Instance$Platform' => '<p>The value is <code>Windows</code> for Windows instances; otherwise blank.</p>', ], ], 'PortRange' => [ 'base' => '<p>Describes a range of ports.</p>', 'refs' => [ 'CreateNetworkAclEntryRequest$PortRange' => '<p>TCP or UDP protocols: The range of ports the rule applies to.</p>', 'NetworkAclEntry$PortRange' => '<p>TCP or UDP protocols: The range of ports the rule applies to.</p>', 'ReplaceNetworkAclEntryRequest$PortRange' => '<p>TCP or UDP protocols: The range of ports the rule applies to. Required if specifying 6 (TCP) or 17 (UDP) for the protocol.</p>', ], ], 'PrefixList' => [ 'base' => '<p>Describes prefixes for AWS services.</p>', 'refs' => [ 'PrefixListSet$member' => NULL, ], ], 'PrefixListId' => [ 'base' => '<p>The ID of the prefix.</p>', 'refs' => [ 'PrefixListIdList$member' => NULL, ], ], 'PrefixListIdList' => [ 'base' => NULL, 'refs' => [ 'IpPermission$PrefixListIds' => '<p>(Valid for <a>AuthorizeSecurityGroupEgress</a>, <a>RevokeSecurityGroupEgress</a> and <a>DescribeSecurityGroups</a> only) One or more prefix list IDs for an AWS service. In an <a>AuthorizeSecurityGroupEgress</a> request, this is the AWS service that you want to access through a VPC endpoint from instances associated with the security group.</p>', ], ], 'PrefixListIdSet' => [ 'base' => NULL, 'refs' => [ 'StaleIpPermission$PrefixListIds' => '<p>One or more prefix list IDs for an AWS service. Not applicable for stale security group rules.</p>', ], ], 'PrefixListSet' => [ 'base' => NULL, 'refs' => [ 'DescribePrefixListsResult$PrefixLists' => '<p>All available prefix lists.</p>', ], ], 'PriceSchedule' => [ 'base' => '<p>Describes the price for a Reserved Instance.</p>', 'refs' => [ 'PriceScheduleList$member' => NULL, ], ], 'PriceScheduleList' => [ 'base' => NULL, 'refs' => [ 'ReservedInstancesListing$PriceSchedules' => '<p>The price of the Reserved Instance listing.</p>', ], ], 'PriceScheduleSpecification' => [ 'base' => '<p>Describes the price for a Reserved Instance.</p>', 'refs' => [ 'PriceScheduleSpecificationList$member' => NULL, ], ], 'PriceScheduleSpecificationList' => [ 'base' => NULL, 'refs' => [ 'CreateReservedInstancesListingRequest$PriceSchedules' => '<p>A list specifying the price of the Standard Reserved Instance for each month remaining in the Reserved Instance term.</p>', ], ], 'PricingDetail' => [ 'base' => '<p>Describes a Reserved Instance offering.</p>', 'refs' => [ 'PricingDetailsList$member' => NULL, ], ], 'PricingDetailsList' => [ 'base' => NULL, 'refs' => [ 'ReservedInstancesOffering$PricingDetails' => '<p>The pricing details of the Reserved Instance offering.</p>', ], ], 'PrivateIpAddressConfigSet' => [ 'base' => NULL, 'refs' => [ 'ScheduledInstancesNetworkInterface$PrivateIpAddressConfigs' => '<p>The private IP addresses.</p>', ], ], 'PrivateIpAddressSpecification' => [ 'base' => '<p>Describes a secondary private IP address for a network interface.</p>', 'refs' => [ 'PrivateIpAddressSpecificationList$member' => NULL, ], ], 'PrivateIpAddressSpecificationList' => [ 'base' => NULL, 'refs' => [ 'CreateNetworkInterfaceRequest$PrivateIpAddresses' => '<p>One or more private IP addresses.</p>', 'InstanceNetworkInterfaceSpecification$PrivateIpAddresses' => '<p>One or more private IP addresses to assign to the network interface. Only one private IP address can be designated as primary. You cannot specify this option if you\'re launching more than one instance in a <a>RunInstances</a> request.</p>', ], ], 'PrivateIpAddressStringList' => [ 'base' => NULL, 'refs' => [ 'AssignPrivateIpAddressesRequest$PrivateIpAddresses' => '<p>One or more IP addresses to be assigned as a secondary private IP address to the network interface. You can\'t specify this parameter when also specifying a number of secondary IP addresses.</p> <p>If you don\'t specify an IP address, Amazon EC2 automatically selects an IP address within the subnet range.</p>', 'UnassignPrivateIpAddressesRequest$PrivateIpAddresses' => '<p>The secondary private IP addresses to unassign from the network interface. You can specify this option multiple times to unassign more than one IP address.</p>', ], ], 'ProductCode' => [ 'base' => '<p>Describes a product code.</p>', 'refs' => [ 'ProductCodeList$member' => NULL, ], ], 'ProductCodeList' => [ 'base' => NULL, 'refs' => [ 'DescribeSnapshotAttributeResult$ProductCodes' => '<p>A list of product codes.</p>', 'DescribeVolumeAttributeResult$ProductCodes' => '<p>A list of product codes.</p>', 'Image$ProductCodes' => '<p>Any product codes associated with the AMI.</p>', 'ImageAttribute$ProductCodes' => '<p>One or more product codes.</p>', 'Instance$ProductCodes' => '<p>The product codes attached to this instance, if applicable.</p>', 'InstanceAttribute$ProductCodes' => '<p>A list of product codes.</p>', ], ], 'ProductCodeStringList' => [ 'base' => NULL, 'refs' => [ 'ModifyImageAttributeRequest$ProductCodes' => '<p>One or more product codes. After you add a product code to an AMI, it can\'t be removed. This is only valid when modifying the <code>productCodes</code> attribute.</p>', ], ], 'ProductCodeValues' => [ 'base' => NULL, 'refs' => [ 'ProductCode$ProductCodeType' => '<p>The type of product code.</p>', ], ], 'ProductDescriptionList' => [ 'base' => NULL, 'refs' => [ 'DescribeSpotPriceHistoryRequest$ProductDescriptions' => '<p>Filters the results by the specified basic product descriptions.</p>', ], ], 'PropagatingVgw' => [ 'base' => '<p>Describes a virtual private gateway propagating route.</p>', 'refs' => [ 'PropagatingVgwList$member' => NULL, ], ], 'PropagatingVgwList' => [ 'base' => NULL, 'refs' => [ 'RouteTable$PropagatingVgws' => '<p>Any virtual private gateway (VGW) propagating routes.</p>', ], ], 'ProvisionedBandwidth' => [ 'base' => '<p>Reserved. If you need to sustain traffic greater than the <a href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/vpc-nat-gateway.html">documented limits</a>, contact us through the <a href="https://console.aws.amazon.com/support/home?">Support Center</a>.</p>', 'refs' => [ 'NatGateway$ProvisionedBandwidth' => '<p>Reserved. If you need to sustain traffic greater than the <a href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/vpc-nat-gateway.html">documented limits</a>, contact us through the <a href="https://console.aws.amazon.com/support/home?">Support Center</a>.</p>', ], ], 'PublicIpStringList' => [ 'base' => NULL, 'refs' => [ 'DescribeAddressesRequest$PublicIps' => '<p>[EC2-Classic] One or more Elastic IP addresses.</p> <p>Default: Describes all your Elastic IP addresses.</p>', ], ], 'Purchase' => [ 'base' => '<p>Describes the result of the purchase.</p>', 'refs' => [ 'PurchaseSet$member' => NULL, ], ], 'PurchaseHostReservationRequest' => [ 'base' => NULL, 'refs' => [], ], 'PurchaseHostReservationResult' => [ 'base' => NULL, 'refs' => [], ], 'PurchaseRequest' => [ 'base' => '<p>Describes a request to purchase Scheduled Instances.</p>', 'refs' => [ 'PurchaseRequestSet$member' => NULL, ], ], 'PurchaseRequestSet' => [ 'base' => NULL, 'refs' => [ 'PurchaseScheduledInstancesRequest$PurchaseRequests' => '<p>One or more purchase requests.</p>', ], ], 'PurchaseReservedInstancesOfferingRequest' => [ 'base' => '<p>Contains the parameters for PurchaseReservedInstancesOffering.</p>', 'refs' => [], ], 'PurchaseReservedInstancesOfferingResult' => [ 'base' => '<p>Contains the output of PurchaseReservedInstancesOffering.</p>', 'refs' => [], ], 'PurchaseScheduledInstancesRequest' => [ 'base' => '<p>Contains the parameters for PurchaseScheduledInstances.</p>', 'refs' => [], ], 'PurchaseScheduledInstancesResult' => [ 'base' => '<p>Contains the output of PurchaseScheduledInstances.</p>', 'refs' => [], ], 'PurchaseSet' => [ 'base' => NULL, 'refs' => [ 'GetHostReservationPurchasePreviewResult$Purchase' => '<p>The purchase information of the Dedicated Host Reservation and the Dedicated Hosts associated with it.</p>', 'PurchaseHostReservationResult$Purchase' => '<p>Describes the details of the purchase.</p>', ], ], 'PurchasedScheduledInstanceSet' => [ 'base' => NULL, 'refs' => [ 'PurchaseScheduledInstancesResult$ScheduledInstanceSet' => '<p>Information about the Scheduled Instances.</p>', ], ], 'RIProductDescription' => [ 'base' => NULL, 'refs' => [ 'DescribeReservedInstancesOfferingsRequest$ProductDescription' => '<p>The Reserved Instance product platform description. Instances that include <code>(Amazon VPC)</code> in the description are for use with Amazon VPC.</p>', 'ReservedInstances$ProductDescription' => '<p>The Reserved Instance product platform description.</p>', 'ReservedInstancesOffering$ProductDescription' => '<p>The Reserved Instance product platform description.</p>', 'SpotInstanceRequest$ProductDescription' => '<p>The product description associated with the Spot instance.</p>', 'SpotPrice$ProductDescription' => '<p>A general description of the AMI.</p>', ], ], 'ReasonCodesList' => [ 'base' => NULL, 'refs' => [ 'ReportInstanceStatusRequest$ReasonCodes' => '<p>One or more reason codes that describes the health state of your instance.</p> <ul> <li> <p> <code>instance-stuck-in-state</code>: My instance is stuck in a state.</p> </li> <li> <p> <code>unresponsive</code>: My instance is unresponsive.</p> </li> <li> <p> <code>not-accepting-credentials</code>: My instance is not accepting my credentials.</p> </li> <li> <p> <code>password-not-available</code>: A password is not available for my instance.</p> </li> <li> <p> <code>performance-network</code>: My instance is experiencing performance problems which I believe are network related.</p> </li> <li> <p> <code>performance-instance-store</code>: My instance is experiencing performance problems which I believe are related to the instance stores.</p> </li> <li> <p> <code>performance-ebs-volume</code>: My instance is experiencing performance problems which I believe are related to an EBS volume.</p> </li> <li> <p> <code>performance-other</code>: My instance is experiencing performance problems.</p> </li> <li> <p> <code>other</code>: [explain using the description parameter]</p> </li> </ul>', ], ], 'RebootInstancesRequest' => [ 'base' => '<p>Contains the parameters for RebootInstances.</p>', 'refs' => [], ], 'RecurringCharge' => [ 'base' => '<p>Describes a recurring charge.</p>', 'refs' => [ 'RecurringChargesList$member' => NULL, ], ], 'RecurringChargeFrequency' => [ 'base' => NULL, 'refs' => [ 'RecurringCharge$Frequency' => '<p>The frequency of the recurring charge.</p>', ], ], 'RecurringChargesList' => [ 'base' => NULL, 'refs' => [ 'ReservedInstances$RecurringCharges' => '<p>The recurring charge tag assigned to the resource.</p>', 'ReservedInstancesOffering$RecurringCharges' => '<p>The recurring charge tag assigned to the resource.</p>', ], ], 'Region' => [ 'base' => '<p>Describes a region.</p>', 'refs' => [ 'RegionList$member' => NULL, ], ], 'RegionList' => [ 'base' => NULL, 'refs' => [ 'DescribeRegionsResult$Regions' => '<p>Information about one or more regions.</p>', ], ], 'RegionNameStringList' => [ 'base' => NULL, 'refs' => [ 'DescribeRegionsRequest$RegionNames' => '<p>The names of one or more regions.</p>', ], ], 'RegisterImageRequest' => [ 'base' => '<p>Contains the parameters for RegisterImage.</p>', 'refs' => [], ], 'RegisterImageResult' => [ 'base' => '<p>Contains the output of RegisterImage.</p>', 'refs' => [], ], 'RejectVpcPeeringConnectionRequest' => [ 'base' => '<p>Contains the parameters for RejectVpcPeeringConnection.</p>', 'refs' => [], ], 'RejectVpcPeeringConnectionResult' => [ 'base' => '<p>Contains the output of RejectVpcPeeringConnection.</p>', 'refs' => [], ], 'ReleaseAddressRequest' => [ 'base' => '<p>Contains the parameters for ReleaseAddress.</p>', 'refs' => [], ], 'ReleaseHostsRequest' => [ 'base' => '<p>Contains the parameters for ReleaseHosts.</p>', 'refs' => [], ], 'ReleaseHostsResult' => [ 'base' => '<p>Contains the output of ReleaseHosts.</p>', 'refs' => [], ], 'ReplaceNetworkAclAssociationRequest' => [ 'base' => '<p>Contains the parameters for ReplaceNetworkAclAssociation.</p>', 'refs' => [], ], 'ReplaceNetworkAclAssociationResult' => [ 'base' => '<p>Contains the output of ReplaceNetworkAclAssociation.</p>', 'refs' => [], ], 'ReplaceNetworkAclEntryRequest' => [ 'base' => '<p>Contains the parameters for ReplaceNetworkAclEntry.</p>', 'refs' => [], ], 'ReplaceRouteRequest' => [ 'base' => '<p>Contains the parameters for ReplaceRoute.</p>', 'refs' => [], ], 'ReplaceRouteTableAssociationRequest' => [ 'base' => '<p>Contains the parameters for ReplaceRouteTableAssociation.</p>', 'refs' => [], ], 'ReplaceRouteTableAssociationResult' => [ 'base' => '<p>Contains the output of ReplaceRouteTableAssociation.</p>', 'refs' => [], ], 'ReportInstanceReasonCodes' => [ 'base' => NULL, 'refs' => [ 'ReasonCodesList$member' => NULL, ], ], 'ReportInstanceStatusRequest' => [ 'base' => '<p>Contains the parameters for ReportInstanceStatus.</p>', 'refs' => [], ], 'ReportStatusType' => [ 'base' => NULL, 'refs' => [ 'ReportInstanceStatusRequest$Status' => '<p>The status of all instances listed.</p>', ], ], 'RequestHostIdList' => [ 'base' => NULL, 'refs' => [ 'DescribeHostsRequest$HostIds' => '<p>The IDs of the Dedicated Hosts. The IDs are used for targeted instance launches.</p>', 'ModifyHostsRequest$HostIds' => '<p>The host IDs of the Dedicated Hosts you want to modify.</p>', 'ReleaseHostsRequest$HostIds' => '<p>The IDs of the Dedicated Hosts you want to release.</p>', ], ], 'RequestHostIdSet' => [ 'base' => NULL, 'refs' => [ 'GetHostReservationPurchasePreviewRequest$HostIdSet' => '<p>The ID/s of the Dedicated Host/s that the reservation will be associated with.</p>', 'PurchaseHostReservationRequest$HostIdSet' => '<p>The ID/s of the Dedicated Host/s that the reservation will be associated with.</p>', ], ], 'RequestSpotFleetRequest' => [ 'base' => '<p>Contains the parameters for RequestSpotFleet.</p>', 'refs' => [], ], 'RequestSpotFleetResponse' => [ 'base' => '<p>Contains the output of RequestSpotFleet.</p>', 'refs' => [], ], 'RequestSpotInstancesRequest' => [ 'base' => '<p>Contains the parameters for RequestSpotInstances.</p>', 'refs' => [], ], 'RequestSpotInstancesResult' => [ 'base' => '<p>Contains the output of RequestSpotInstances.</p>', 'refs' => [], ], 'RequestSpotLaunchSpecification' => [ 'base' => '<p>Describes the launch specification for an instance.</p>', 'refs' => [ 'RequestSpotInstancesRequest$LaunchSpecification' => NULL, ], ], 'Reservation' => [ 'base' => '<p>Describes a reservation.</p>', 'refs' => [ 'ReservationList$member' => NULL, ], ], 'ReservationList' => [ 'base' => NULL, 'refs' => [ 'DescribeInstancesResult$Reservations' => '<p>Zero or more reservations.</p>', ], ], 'ReservationState' => [ 'base' => NULL, 'refs' => [ 'HostReservation$State' => '<p>The state of the reservation.</p>', ], ], 'ReservationValue' => [ 'base' => '<p>The cost associated with the Reserved Instance.</p>', 'refs' => [ 'GetReservedInstancesExchangeQuoteResult$ReservedInstanceValueRollup' => NULL, 'GetReservedInstancesExchangeQuoteResult$TargetConfigurationValueRollup' => NULL, 'ReservedInstanceReservationValue$ReservationValue' => '<p>The total value of the Convertible Reserved Instance that you are exchanging.</p>', 'TargetReservationValue$ReservationValue' => '<p>The total value of the Convertible Reserved Instances that make up the exchange. This is the sum of the list value, remaining upfront price, and additional upfront cost of the exchange.</p>', ], ], 'ReservedInstanceIdSet' => [ 'base' => NULL, 'refs' => [ 'AcceptReservedInstancesExchangeQuoteRequest$ReservedInstanceIds' => '<p>The IDs of the Convertible Reserved Instances that you want to exchange for other Convertible Reserved Instances of the same or higher value.</p>', 'GetReservedInstancesExchangeQuoteRequest$ReservedInstanceIds' => '<p>The ID/s of the Convertible Reserved Instances you want to exchange.</p>', ], ], 'ReservedInstanceLimitPrice' => [ 'base' => '<p>Describes the limit price of a Reserved Instance offering.</p>', 'refs' => [ 'PurchaseReservedInstancesOfferingRequest$LimitPrice' => '<p>Specified for Reserved Instance Marketplace offerings to limit the total order and ensure that the Reserved Instances are not purchased at unexpected prices.</p>', ], ], 'ReservedInstanceReservationValue' => [ 'base' => '<p>The total value of the Convertible Reserved Instance.</p>', 'refs' => [ 'ReservedInstanceReservationValueSet$member' => NULL, ], ], 'ReservedInstanceReservationValueSet' => [ 'base' => NULL, 'refs' => [ 'GetReservedInstancesExchangeQuoteResult$ReservedInstanceValueSet' => '<p>The configuration of your Convertible Reserved Instances.</p>', ], ], 'ReservedInstanceState' => [ 'base' => NULL, 'refs' => [ 'ReservedInstances$State' => '<p>The state of the Reserved Instance purchase.</p>', ], ], 'ReservedInstances' => [ 'base' => '<p>Describes a Reserved Instance.</p>', 'refs' => [ 'ReservedInstancesList$member' => NULL, ], ], 'ReservedInstancesConfiguration' => [ 'base' => '<p>Describes the configuration settings for the modified Reserved Instances.</p>', 'refs' => [ 'ReservedInstancesConfigurationList$member' => NULL, 'ReservedInstancesModificationResult$TargetConfiguration' => '<p>The target Reserved Instances configurations supplied as part of the modification request.</p>', ], ], 'ReservedInstancesConfigurationList' => [ 'base' => NULL, 'refs' => [ 'ModifyReservedInstancesRequest$TargetConfigurations' => '<p>The configuration settings for the Reserved Instances to modify.</p>', ], ], 'ReservedInstancesId' => [ 'base' => '<p>Describes the ID of a Reserved Instance.</p>', 'refs' => [ 'ReservedIntancesIds$member' => NULL, ], ], 'ReservedInstancesIdStringList' => [ 'base' => NULL, 'refs' => [ 'DescribeReservedInstancesRequest$ReservedInstancesIds' => '<p>One or more Reserved Instance IDs.</p> <p>Default: Describes all your Reserved Instances, or only those otherwise specified.</p>', 'ModifyReservedInstancesRequest$ReservedInstancesIds' => '<p>The IDs of the Reserved Instances to modify.</p>', ], ], 'ReservedInstancesList' => [ 'base' => NULL, 'refs' => [ 'DescribeReservedInstancesResult$ReservedInstances' => '<p>A list of Reserved Instances.</p>', ], ], 'ReservedInstancesListing' => [ 'base' => '<p>Describes a Reserved Instance listing.</p>', 'refs' => [ 'ReservedInstancesListingList$member' => NULL, ], ], 'ReservedInstancesListingList' => [ 'base' => NULL, 'refs' => [ 'CancelReservedInstancesListingResult$ReservedInstancesListings' => '<p>The Reserved Instance listing.</p>', 'CreateReservedInstancesListingResult$ReservedInstancesListings' => '<p>Information about the Standard Reserved Instance listing.</p>', 'DescribeReservedInstancesListingsResult$ReservedInstancesListings' => '<p>Information about the Reserved Instance listing.</p>', ], ], 'ReservedInstancesModification' => [ 'base' => '<p>Describes a Reserved Instance modification.</p>', 'refs' => [ 'ReservedInstancesModificationList$member' => NULL, ], ], 'ReservedInstancesModificationIdStringList' => [ 'base' => NULL, 'refs' => [ 'DescribeReservedInstancesModificationsRequest$ReservedInstancesModificationIds' => '<p>IDs for the submitted modification request.</p>', ], ], 'ReservedInstancesModificationList' => [ 'base' => NULL, 'refs' => [ 'DescribeReservedInstancesModificationsResult$ReservedInstancesModifications' => '<p>The Reserved Instance modification information.</p>', ], ], 'ReservedInstancesModificationResult' => [ 'base' => '<p>Describes the modification request/s.</p>', 'refs' => [ 'ReservedInstancesModificationResultList$member' => NULL, ], ], 'ReservedInstancesModificationResultList' => [ 'base' => NULL, 'refs' => [ 'ReservedInstancesModification$ModificationResults' => '<p>Contains target configurations along with their corresponding new Reserved Instance IDs.</p>', ], ], 'ReservedInstancesOffering' => [ 'base' => '<p>Describes a Reserved Instance offering.</p>', 'refs' => [ 'ReservedInstancesOfferingList$member' => NULL, ], ], 'ReservedInstancesOfferingIdStringList' => [ 'base' => NULL, 'refs' => [ 'DescribeReservedInstancesOfferingsRequest$ReservedInstancesOfferingIds' => '<p>One or more Reserved Instances offering IDs.</p>', ], ], 'ReservedInstancesOfferingList' => [ 'base' => NULL, 'refs' => [ 'DescribeReservedInstancesOfferingsResult$ReservedInstancesOfferings' => '<p>A list of Reserved Instances offerings.</p>', ], ], 'ReservedIntancesIds' => [ 'base' => NULL, 'refs' => [ 'ReservedInstancesModification$ReservedInstancesIds' => '<p>The IDs of one or more Reserved Instances.</p>', ], ], 'ResetImageAttributeName' => [ 'base' => NULL, 'refs' => [ 'ResetImageAttributeRequest$Attribute' => '<p>The attribute to reset (currently you can only reset the launch permission attribute).</p>', ], ], 'ResetImageAttributeRequest' => [ 'base' => '<p>Contains the parameters for ResetImageAttribute.</p>', 'refs' => [], ], 'ResetInstanceAttributeRequest' => [ 'base' => '<p>Contains the parameters for ResetInstanceAttribute.</p>', 'refs' => [], ], 'ResetNetworkInterfaceAttributeRequest' => [ 'base' => '<p>Contains the parameters for ResetNetworkInterfaceAttribute.</p>', 'refs' => [], ], 'ResetSnapshotAttributeRequest' => [ 'base' => '<p>Contains the parameters for ResetSnapshotAttribute.</p>', 'refs' => [], ], 'ResourceIdList' => [ 'base' => NULL, 'refs' => [ 'CreateTagsRequest$Resources' => '<p>The IDs of one or more resources to tag. For example, ami-1a2b3c4d.</p>', 'DeleteTagsRequest$Resources' => '<p>The ID of the resource. For example, ami-1a2b3c4d. You can specify more than one resource ID.</p>', ], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'TagDescription$ResourceType' => '<p>The resource type.</p>', ], ], 'ResponseHostIdList' => [ 'base' => NULL, 'refs' => [ 'AllocateHostsResult$HostIds' => '<p>The ID of the allocated Dedicated Host. This is used when you want to launch an instance onto a specific host.</p>', 'ModifyHostsResult$Successful' => '<p>The IDs of the Dedicated Hosts that were successfully modified.</p>', 'ReleaseHostsResult$Successful' => '<p>The IDs of the Dedicated Hosts that were successfully released.</p>', ], ], 'ResponseHostIdSet' => [ 'base' => NULL, 'refs' => [ 'HostReservation$HostIdSet' => '<p>The IDs of the Dedicated Hosts associated with the reservation.</p>', 'Purchase$HostIdSet' => '<p>The IDs of the Dedicated Hosts associated with the reservation.</p>', ], ], 'RestorableByStringList' => [ 'base' => NULL, 'refs' => [ 'DescribeSnapshotsRequest$RestorableByUserIds' => '<p>One or more AWS accounts IDs that can create volumes from the snapshot.</p>', ], ], 'RestoreAddressToClassicRequest' => [ 'base' => '<p>Contains the parameters for RestoreAddressToClassic.</p>', 'refs' => [], ], 'RestoreAddressToClassicResult' => [ 'base' => '<p>Contains the output of RestoreAddressToClassic.</p>', 'refs' => [], ], 'RevokeSecurityGroupEgressRequest' => [ 'base' => '<p>Contains the parameters for RevokeSecurityGroupEgress.</p>', 'refs' => [], ], 'RevokeSecurityGroupIngressRequest' => [ 'base' => '<p>Contains the parameters for RevokeSecurityGroupIngress.</p>', 'refs' => [], ], 'Route' => [ 'base' => '<p>Describes a route in a route table.</p>', 'refs' => [ 'RouteList$member' => NULL, ], ], 'RouteList' => [ 'base' => NULL, 'refs' => [ 'RouteTable$Routes' => '<p>The routes in the route table.</p>', ], ], 'RouteOrigin' => [ 'base' => NULL, 'refs' => [ 'Route$Origin' => '<p>Describes how the route was created.</p> <ul> <li> <p> <code>CreateRouteTable</code> - The route was automatically created when the route table was created.</p> </li> <li> <p> <code>CreateRoute</code> - The route was manually added to the route table.</p> </li> <li> <p> <code>EnableVgwRoutePropagation</code> - The route was propagated by route propagation.</p> </li> </ul>', ], ], 'RouteState' => [ 'base' => NULL, 'refs' => [ 'Route$State' => '<p>The state of the route. The <code>blackhole</code> state indicates that the route\'s target isn\'t available (for example, the specified gateway isn\'t attached to the VPC, or the specified NAT instance has been terminated).</p>', ], ], 'RouteTable' => [ 'base' => '<p>Describes a route table.</p>', 'refs' => [ 'CreateRouteTableResult$RouteTable' => '<p>Information about the route table.</p>', 'RouteTableList$member' => NULL, ], ], 'RouteTableAssociation' => [ 'base' => '<p>Describes an association between a route table and a subnet.</p>', 'refs' => [ 'RouteTableAssociationList$member' => NULL, ], ], 'RouteTableAssociationList' => [ 'base' => NULL, 'refs' => [ 'RouteTable$Associations' => '<p>The associations between the route table and one or more subnets.</p>', ], ], 'RouteTableList' => [ 'base' => NULL, 'refs' => [ 'DescribeRouteTablesResult$RouteTables' => '<p>Information about one or more route tables.</p>', ], ], 'RuleAction' => [ 'base' => NULL, 'refs' => [ 'CreateNetworkAclEntryRequest$RuleAction' => '<p>Indicates whether to allow or deny the traffic that matches the rule.</p>', 'NetworkAclEntry$RuleAction' => '<p>Indicates whether to allow or deny the traffic that matches the rule.</p>', 'ReplaceNetworkAclEntryRequest$RuleAction' => '<p>Indicates whether to allow or deny the traffic that matches the rule.</p>', ], ], 'RunInstancesMonitoringEnabled' => [ 'base' => '<p>Describes the monitoring for the instance.</p>', 'refs' => [ 'LaunchSpecification$Monitoring' => NULL, 'RequestSpotLaunchSpecification$Monitoring' => NULL, 'RunInstancesRequest$Monitoring' => '<p>The monitoring for the instance.</p>', ], ], 'RunInstancesRequest' => [ 'base' => '<p>Contains the parameters for RunInstances.</p>', 'refs' => [], ], 'RunScheduledInstancesRequest' => [ 'base' => '<p>Contains the parameters for RunScheduledInstances.</p>', 'refs' => [], ], 'RunScheduledInstancesResult' => [ 'base' => '<p>Contains the output of RunScheduledInstances.</p>', 'refs' => [], ], 'S3Storage' => [ 'base' => '<p>Describes the storage parameters for S3 and S3 buckets for an instance store-backed AMI.</p>', 'refs' => [ 'Storage$S3' => '<p>An Amazon S3 storage location.</p>', ], ], 'ScheduledInstance' => [ 'base' => '<p>Describes a Scheduled Instance.</p>', 'refs' => [ 'PurchasedScheduledInstanceSet$member' => NULL, 'ScheduledInstanceSet$member' => NULL, ], ], 'ScheduledInstanceAvailability' => [ 'base' => '<p>Describes a schedule that is available for your Scheduled Instances.</p>', 'refs' => [ 'ScheduledInstanceAvailabilitySet$member' => NULL, ], ], 'ScheduledInstanceAvailabilitySet' => [ 'base' => NULL, 'refs' => [ 'DescribeScheduledInstanceAvailabilityResult$ScheduledInstanceAvailabilitySet' => '<p>Information about the available Scheduled Instances.</p>', ], ], 'ScheduledInstanceIdRequestSet' => [ 'base' => NULL, 'refs' => [ 'DescribeScheduledInstancesRequest$ScheduledInstanceIds' => '<p>One or more Scheduled Instance IDs.</p>', ], ], 'ScheduledInstanceRecurrence' => [ 'base' => '<p>Describes the recurring schedule for a Scheduled Instance.</p>', 'refs' => [ 'ScheduledInstance$Recurrence' => '<p>The schedule recurrence.</p>', 'ScheduledInstanceAvailability$Recurrence' => '<p>The schedule recurrence.</p>', ], ], 'ScheduledInstanceRecurrenceRequest' => [ 'base' => '<p>Describes the recurring schedule for a Scheduled Instance.</p>', 'refs' => [ 'DescribeScheduledInstanceAvailabilityRequest$Recurrence' => '<p>The schedule recurrence.</p>', ], ], 'ScheduledInstanceSet' => [ 'base' => NULL, 'refs' => [ 'DescribeScheduledInstancesResult$ScheduledInstanceSet' => '<p>Information about the Scheduled Instances.</p>', ], ], 'ScheduledInstancesBlockDeviceMapping' => [ 'base' => '<p>Describes a block device mapping for a Scheduled Instance.</p>', 'refs' => [ 'ScheduledInstancesBlockDeviceMappingSet$member' => NULL, ], ], 'ScheduledInstancesBlockDeviceMappingSet' => [ 'base' => NULL, 'refs' => [ 'ScheduledInstancesLaunchSpecification$BlockDeviceMappings' => '<p>One or more block device mapping entries.</p>', ], ], 'ScheduledInstancesEbs' => [ 'base' => '<p>Describes an EBS volume for a Scheduled Instance.</p>', 'refs' => [ 'ScheduledInstancesBlockDeviceMapping$Ebs' => '<p>Parameters used to set up EBS volumes automatically when the instance is launched.</p>', ], ], 'ScheduledInstancesIamInstanceProfile' => [ 'base' => '<p>Describes an IAM instance profile for a Scheduled Instance.</p>', 'refs' => [ 'ScheduledInstancesLaunchSpecification$IamInstanceProfile' => '<p>The IAM instance profile.</p>', ], ], 'ScheduledInstancesLaunchSpecification' => [ 'base' => '<p>Describes the launch specification for a Scheduled Instance.</p> <p>If you are launching the Scheduled Instance in EC2-VPC, you must specify the ID of the subnet. You can specify the subnet using either <code>SubnetId</code> or <code>NetworkInterface</code>.</p>', 'refs' => [ 'RunScheduledInstancesRequest$LaunchSpecification' => '<p>The launch specification. You must match the instance type, Availability Zone, network, and platform of the schedule that you purchased.</p>', ], ], 'ScheduledInstancesMonitoring' => [ 'base' => '<p>Describes whether monitoring is enabled for a Scheduled Instance.</p>', 'refs' => [ 'ScheduledInstancesLaunchSpecification$Monitoring' => '<p>Enable or disable monitoring for the instances.</p>', ], ], 'ScheduledInstancesNetworkInterface' => [ 'base' => '<p>Describes a network interface for a Scheduled Instance.</p>', 'refs' => [ 'ScheduledInstancesNetworkInterfaceSet$member' => NULL, ], ], 'ScheduledInstancesNetworkInterfaceSet' => [ 'base' => NULL, 'refs' => [ 'ScheduledInstancesLaunchSpecification$NetworkInterfaces' => '<p>One or more network interfaces.</p>', ], ], 'ScheduledInstancesPlacement' => [ 'base' => '<p>Describes the placement for a Scheduled Instance.</p>', 'refs' => [ 'ScheduledInstancesLaunchSpecification$Placement' => '<p>The placement information.</p>', ], ], 'ScheduledInstancesPrivateIpAddressConfig' => [ 'base' => '<p>Describes a private IP address for a Scheduled Instance.</p>', 'refs' => [ 'PrivateIpAddressConfigSet$member' => NULL, ], ], 'ScheduledInstancesSecurityGroupIdSet' => [ 'base' => NULL, 'refs' => [ 'ScheduledInstancesLaunchSpecification$SecurityGroupIds' => '<p>The IDs of one or more security groups.</p>', 'ScheduledInstancesNetworkInterface$Groups' => '<p>The IDs of one or more security groups.</p>', ], ], 'SecurityGroup' => [ 'base' => '<p>Describes a security group</p>', 'refs' => [ 'SecurityGroupList$member' => NULL, ], ], 'SecurityGroupIdStringList' => [ 'base' => NULL, 'refs' => [ 'CreateNetworkInterfaceRequest$Groups' => '<p>The IDs of one or more security groups.</p>', 'ImportInstanceLaunchSpecification$GroupIds' => '<p>One or more security group IDs.</p>', 'InstanceNetworkInterfaceSpecification$Groups' => '<p>The IDs of the security groups for the network interface. Applies only if creating a network interface when launching an instance.</p>', 'ModifyNetworkInterfaceAttributeRequest$Groups' => '<p>Changes the security groups for the network interface. The new set of groups you specify replaces the current set. You must specify at least one group, even if it\'s just the default security group in the VPC. You must specify the ID of the security group, not the name.</p>', 'RunInstancesRequest$SecurityGroupIds' => '<p>One or more security group IDs. You can create a security group using <a>CreateSecurityGroup</a>.</p> <p>Default: Amazon EC2 uses the default security group.</p>', ], ], 'SecurityGroupList' => [ 'base' => NULL, 'refs' => [ 'DescribeSecurityGroupsResult$SecurityGroups' => '<p>Information about one or more security groups.</p>', ], ], 'SecurityGroupReference' => [ 'base' => '<p>Describes a VPC with a security group that references your security group.</p>', 'refs' => [ 'SecurityGroupReferences$member' => NULL, ], ], 'SecurityGroupReferences' => [ 'base' => NULL, 'refs' => [ 'DescribeSecurityGroupReferencesResult$SecurityGroupReferenceSet' => '<p>Information about the VPCs with the referencing security groups.</p>', ], ], 'SecurityGroupStringList' => [ 'base' => NULL, 'refs' => [ 'ImportInstanceLaunchSpecification$GroupNames' => '<p>One or more security group names.</p>', 'RunInstancesRequest$SecurityGroups' => '<p>[EC2-Classic, default VPC] One or more security group names. For a nondefault VPC, you must use security group IDs instead.</p> <p>Default: Amazon EC2 uses the default security group.</p>', ], ], 'ShutdownBehavior' => [ 'base' => NULL, 'refs' => [ 'ImportInstanceLaunchSpecification$InstanceInitiatedShutdownBehavior' => '<p>Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the operating system command for system shutdown).</p>', 'RunInstancesRequest$InstanceInitiatedShutdownBehavior' => '<p>Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the operating system command for system shutdown).</p> <p>Default: <code>stop</code> </p>', ], ], 'SlotDateTimeRangeRequest' => [ 'base' => '<p>Describes the time period for a Scheduled Instance to start its first schedule. The time period must span less than one day.</p>', 'refs' => [ 'DescribeScheduledInstanceAvailabilityRequest$FirstSlotStartTimeRange' => '<p>The time period for the first schedule to start.</p>', ], ], 'SlotStartTimeRangeRequest' => [ 'base' => '<p>Describes the time period for a Scheduled Instance to start its first schedule.</p>', 'refs' => [ 'DescribeScheduledInstancesRequest$SlotStartTimeRange' => '<p>The time period for the first schedule to start.</p>', ], ], 'Snapshot' => [ 'base' => '<p>Describes a snapshot.</p>', 'refs' => [ 'SnapshotList$member' => NULL, ], ], 'SnapshotAttributeName' => [ 'base' => NULL, 'refs' => [ 'DescribeSnapshotAttributeRequest$Attribute' => '<p>The snapshot attribute you would like to view.</p>', 'ModifySnapshotAttributeRequest$Attribute' => '<p>The snapshot attribute to modify.</p> <note> <p>Only volume creation permissions may be modified at the customer level.</p> </note>', 'ResetSnapshotAttributeRequest$Attribute' => '<p>The attribute to reset. Currently, only the attribute for permission to create volumes can be reset.</p>', ], ], 'SnapshotDetail' => [ 'base' => '<p>Describes the snapshot created from the imported disk.</p>', 'refs' => [ 'SnapshotDetailList$member' => NULL, ], ], 'SnapshotDetailList' => [ 'base' => NULL, 'refs' => [ 'ImportImageResult$SnapshotDetails' => '<p>Information about the snapshots.</p>', 'ImportImageTask$SnapshotDetails' => '<p>Information about the snapshots.</p>', ], ], 'SnapshotDiskContainer' => [ 'base' => '<p>The disk container object for the import snapshot request.</p>', 'refs' => [ 'ImportSnapshotRequest$DiskContainer' => '<p>Information about the disk container.</p>', ], ], 'SnapshotIdStringList' => [ 'base' => NULL, 'refs' => [ 'DescribeSnapshotsRequest$SnapshotIds' => '<p>One or more snapshot IDs.</p> <p>Default: Describes snapshots for which you have launch permissions.</p>', ], ], 'SnapshotList' => [ 'base' => NULL, 'refs' => [ 'DescribeSnapshotsResult$Snapshots' => '<p>Information about the snapshots.</p>', ], ], 'SnapshotState' => [ 'base' => NULL, 'refs' => [ 'Snapshot$State' => '<p>The snapshot state.</p>', ], ], 'SnapshotTaskDetail' => [ 'base' => '<p>Details about the import snapshot task.</p>', 'refs' => [ 'ImportSnapshotResult$SnapshotTaskDetail' => '<p>Information about the import snapshot task.</p>', 'ImportSnapshotTask$SnapshotTaskDetail' => '<p>Describes an import snapshot task.</p>', ], ], 'SpotDatafeedSubscription' => [ 'base' => '<p>Describes the data feed for a Spot instance.</p>', 'refs' => [ 'CreateSpotDatafeedSubscriptionResult$SpotDatafeedSubscription' => '<p>The Spot instance data feed subscription.</p>', 'DescribeSpotDatafeedSubscriptionResult$SpotDatafeedSubscription' => '<p>The Spot instance data feed subscription.</p>', ], ], 'SpotFleetLaunchSpecification' => [ 'base' => '<p>Describes the launch specification for one or more Spot instances.</p>', 'refs' => [ 'LaunchSpecsList$member' => NULL, ], ], 'SpotFleetMonitoring' => [ 'base' => '<p>Describes whether monitoring is enabled.</p>', 'refs' => [ 'SpotFleetLaunchSpecification$Monitoring' => '<p>Enable or disable monitoring for the instances.</p>', ], ], 'SpotFleetRequestConfig' => [ 'base' => '<p>Describes a Spot fleet request.</p>', 'refs' => [ 'SpotFleetRequestConfigSet$member' => NULL, ], ], 'SpotFleetRequestConfigData' => [ 'base' => '<p>Describes the configuration of a Spot fleet request.</p>', 'refs' => [ 'RequestSpotFleetRequest$SpotFleetRequestConfig' => '<p>The configuration for the Spot fleet request.</p>', 'SpotFleetRequestConfig$SpotFleetRequestConfig' => '<p>Information about the configuration of the Spot fleet request.</p>', ], ], 'SpotFleetRequestConfigSet' => [ 'base' => NULL, 'refs' => [ 'DescribeSpotFleetRequestsResponse$SpotFleetRequestConfigs' => '<p>Information about the configuration of your Spot fleet.</p>', ], ], 'SpotInstanceRequest' => [ 'base' => '<p>Describes a Spot instance request.</p>', 'refs' => [ 'SpotInstanceRequestList$member' => NULL, ], ], 'SpotInstanceRequestIdList' => [ 'base' => NULL, 'refs' => [ 'CancelSpotInstanceRequestsRequest$SpotInstanceRequestIds' => '<p>One or more Spot instance request IDs.</p>', 'DescribeSpotInstanceRequestsRequest$SpotInstanceRequestIds' => '<p>One or more Spot instance request IDs.</p>', ], ], 'SpotInstanceRequestList' => [ 'base' => NULL, 'refs' => [ 'DescribeSpotInstanceRequestsResult$SpotInstanceRequests' => '<p>One or more Spot instance requests.</p>', 'RequestSpotInstancesResult$SpotInstanceRequests' => '<p>One or more Spot instance requests.</p>', ], ], 'SpotInstanceState' => [ 'base' => NULL, 'refs' => [ 'SpotInstanceRequest$State' => '<p>The state of the Spot instance request. Spot bid status information can help you track your Spot instance requests. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html">Spot Bid Status</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', ], ], 'SpotInstanceStateFault' => [ 'base' => '<p>Describes a Spot instance state change.</p>', 'refs' => [ 'SpotDatafeedSubscription$Fault' => '<p>The fault codes for the Spot instance request, if any.</p>', 'SpotInstanceRequest$Fault' => '<p>The fault codes for the Spot instance request, if any.</p>', ], ], 'SpotInstanceStatus' => [ 'base' => '<p>Describes the status of a Spot instance request.</p>', 'refs' => [ 'SpotInstanceRequest$Status' => '<p>The status code and status message describing the Spot instance request.</p>', ], ], 'SpotInstanceType' => [ 'base' => NULL, 'refs' => [ 'RequestSpotInstancesRequest$Type' => '<p>The Spot instance request type.</p> <p>Default: <code>one-time</code> </p>', 'SpotInstanceRequest$Type' => '<p>The Spot instance request type.</p>', ], ], 'SpotPlacement' => [ 'base' => '<p>Describes Spot instance placement.</p>', 'refs' => [ 'LaunchSpecification$Placement' => '<p>The placement information for the instance.</p>', 'RequestSpotLaunchSpecification$Placement' => '<p>The placement information for the instance.</p>', 'SpotFleetLaunchSpecification$Placement' => '<p>The placement information.</p>', ], ], 'SpotPrice' => [ 'base' => '<p>Describes the maximum hourly price (bid) for any Spot instance launched to fulfill the request.</p>', 'refs' => [ 'SpotPriceHistoryList$member' => NULL, ], ], 'SpotPriceHistoryList' => [ 'base' => NULL, 'refs' => [ 'DescribeSpotPriceHistoryResult$SpotPriceHistory' => '<p>The historical Spot prices.</p>', ], ], 'StaleIpPermission' => [ 'base' => '<p>Describes a stale rule in a security group.</p>', 'refs' => [ 'StaleIpPermissionSet$member' => NULL, ], ], 'StaleIpPermissionSet' => [ 'base' => NULL, 'refs' => [ 'StaleSecurityGroup$StaleIpPermissions' => '<p>Information about the stale inbound rules in the security group.</p>', 'StaleSecurityGroup$StaleIpPermissionsEgress' => '<p>Information about the stale outbound rules in the security group.</p>', ], ], 'StaleSecurityGroup' => [ 'base' => '<p>Describes a stale security group (a security group that contains stale rules).</p>', 'refs' => [ 'StaleSecurityGroupSet$member' => NULL, ], ], 'StaleSecurityGroupSet' => [ 'base' => NULL, 'refs' => [ 'DescribeStaleSecurityGroupsResult$StaleSecurityGroupSet' => '<p>Information about the stale security groups.</p>', ], ], 'StartInstancesRequest' => [ 'base' => '<p>Contains the parameters for StartInstances.</p>', 'refs' => [], ], 'StartInstancesResult' => [ 'base' => '<p>Contains the output of StartInstances.</p>', 'refs' => [], ], 'State' => [ 'base' => NULL, 'refs' => [ 'VpcEndpoint$State' => '<p>The state of the VPC endpoint.</p>', ], ], 'StateReason' => [ 'base' => '<p>Describes a state change.</p>', 'refs' => [ 'Image$StateReason' => '<p>The reason for the state change.</p>', 'Instance$StateReason' => '<p>The reason for the most recent state transition.</p>', ], ], 'Status' => [ 'base' => NULL, 'refs' => [ 'MoveAddressToVpcResult$Status' => '<p>The status of the move of the IP address.</p>', 'RestoreAddressToClassicResult$Status' => '<p>The move status for the IP address.</p>', ], ], 'StatusName' => [ 'base' => NULL, 'refs' => [ 'InstanceStatusDetails$Name' => '<p>The type of instance status.</p>', ], ], 'StatusType' => [ 'base' => NULL, 'refs' => [ 'InstanceStatusDetails$Status' => '<p>The status.</p>', ], ], 'StopInstancesRequest' => [ 'base' => '<p>Contains the parameters for StopInstances.</p>', 'refs' => [], ], 'StopInstancesResult' => [ 'base' => '<p>Contains the output of StopInstances.</p>', 'refs' => [], ], 'Storage' => [ 'base' => '<p>Describes the storage location for an instance store-backed AMI.</p>', 'refs' => [ 'BundleInstanceRequest$Storage' => '<p>The bucket in which to store the AMI. You can specify a bucket that you already own or a new bucket that Amazon EC2 creates on your behalf. If you specify a bucket that belongs to someone else, Amazon EC2 returns an error.</p>', 'BundleTask$Storage' => '<p>The Amazon S3 storage locations.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AcceptReservedInstancesExchangeQuoteResult$ExchangeId' => '<p>The ID of the successful exchange.</p>', 'AcceptVpcPeeringConnectionRequest$VpcPeeringConnectionId' => '<p>The ID of the VPC peering connection.</p>', 'AccountAttribute$AttributeName' => '<p>The name of the account attribute.</p>', 'AccountAttributeValue$AttributeValue' => '<p>The value of the attribute.</p>', 'ActiveInstance$InstanceType' => '<p>The instance type.</p>', 'ActiveInstance$InstanceId' => '<p>The ID of the instance.</p>', 'ActiveInstance$SpotInstanceRequestId' => '<p>The ID of the Spot instance request.</p>', 'Address$InstanceId' => '<p>The ID of the instance that the address is associated with (if any).</p>', 'Address$PublicIp' => '<p>The Elastic IP address.</p>', 'Address$AllocationId' => '<p>The ID representing the allocation of the address for use with EC2-VPC.</p>', 'Address$AssociationId' => '<p>The ID representing the association of the address with an instance in a VPC.</p>', 'Address$NetworkInterfaceId' => '<p>The ID of the network interface.</p>', 'Address$NetworkInterfaceOwnerId' => '<p>The ID of the AWS account that owns the network interface.</p>', 'Address$PrivateIpAddress' => '<p>The private IP address associated with the Elastic IP address.</p>', 'AllocateAddressResult$PublicIp' => '<p>The Elastic IP address.</p>', 'AllocateAddressResult$AllocationId' => '<p>[EC2-VPC] The ID that AWS assigns to represent the allocation of the Elastic IP address for use with instances in a VPC.</p>', 'AllocateHostsRequest$ClientToken' => '<p>Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure Idempotency</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. </p>', 'AllocateHostsRequest$InstanceType' => '<p>Specify the instance type that you want your Dedicated Hosts to be configured for. When you specify the instance type, that is the only instance type that you can launch onto that host.</p>', 'AllocateHostsRequest$AvailabilityZone' => '<p>The Availability Zone for the Dedicated Hosts.</p>', 'AllocationIdList$member' => NULL, 'AssignPrivateIpAddressesRequest$NetworkInterfaceId' => '<p>The ID of the network interface.</p>', 'AssociateAddressRequest$InstanceId' => '<p>The ID of the instance. This is required for EC2-Classic. For EC2-VPC, you can specify either the instance ID or the network interface ID, but not both. The operation fails if you specify an instance ID unless exactly one network interface is attached.</p>', 'AssociateAddressRequest$PublicIp' => '<p>The Elastic IP address. This is required for EC2-Classic.</p>', 'AssociateAddressRequest$AllocationId' => '<p>[EC2-VPC] The allocation ID. This is required for EC2-VPC.</p>', 'AssociateAddressRequest$NetworkInterfaceId' => '<p>[EC2-VPC] The ID of the network interface. If the instance has more than one network interface, you must specify a network interface ID.</p>', 'AssociateAddressRequest$PrivateIpAddress' => '<p>[EC2-VPC] The primary or secondary private IP address to associate with the Elastic IP address. If no private IP address is specified, the Elastic IP address is associated with the primary private IP address.</p>', 'AssociateAddressResult$AssociationId' => '<p>[EC2-VPC] The ID that represents the association of the Elastic IP address with an instance.</p>', 'AssociateDhcpOptionsRequest$DhcpOptionsId' => '<p>The ID of the DHCP options set, or <code>default</code> to associate no DHCP options with the VPC.</p>', 'AssociateDhcpOptionsRequest$VpcId' => '<p>The ID of the VPC.</p>', 'AssociateRouteTableRequest$SubnetId' => '<p>The ID of the subnet.</p>', 'AssociateRouteTableRequest$RouteTableId' => '<p>The ID of the route table.</p>', 'AssociateRouteTableResult$AssociationId' => '<p>The route table association ID (needed to disassociate the route table).</p>', 'AttachClassicLinkVpcRequest$InstanceId' => '<p>The ID of an EC2-Classic instance to link to the ClassicLink-enabled VPC.</p>', 'AttachClassicLinkVpcRequest$VpcId' => '<p>The ID of a ClassicLink-enabled VPC.</p>', 'AttachInternetGatewayRequest$InternetGatewayId' => '<p>The ID of the Internet gateway.</p>', 'AttachInternetGatewayRequest$VpcId' => '<p>The ID of the VPC.</p>', 'AttachNetworkInterfaceRequest$NetworkInterfaceId' => '<p>The ID of the network interface.</p>', 'AttachNetworkInterfaceRequest$InstanceId' => '<p>The ID of the instance.</p>', 'AttachNetworkInterfaceResult$AttachmentId' => '<p>The ID of the network interface attachment.</p>', 'AttachVolumeRequest$VolumeId' => '<p>The ID of the EBS volume. The volume and instance must be within the same Availability Zone.</p>', 'AttachVolumeRequest$InstanceId' => '<p>The ID of the instance.</p>', 'AttachVolumeRequest$Device' => '<p>The device name to expose to the instance (for example, <code>/dev/sdh</code> or <code>xvdh</code>).</p>', 'AttachVpnGatewayRequest$VpnGatewayId' => '<p>The ID of the virtual private gateway.</p>', 'AttachVpnGatewayRequest$VpcId' => '<p>The ID of the VPC.</p>', 'AttributeValue$Value' => '<p>The attribute value. Note that the value is case-sensitive.</p>', 'AuthorizeSecurityGroupEgressRequest$GroupId' => '<p>The ID of the security group.</p>', 'AuthorizeSecurityGroupEgressRequest$SourceSecurityGroupName' => '<p>The name of a destination security group. To authorize outbound access to a destination security group, we recommend that you use a set of IP permissions instead.</p>', 'AuthorizeSecurityGroupEgressRequest$SourceSecurityGroupOwnerId' => '<p>The AWS account number for a destination security group. To authorize outbound access to a destination security group, we recommend that you use a set of IP permissions instead.</p>', 'AuthorizeSecurityGroupEgressRequest$IpProtocol' => '<p>The IP protocol name or number. We recommend that you specify the protocol in a set of IP permissions instead.</p>', 'AuthorizeSecurityGroupEgressRequest$CidrIp' => '<p>The CIDR IP address range. We recommend that you specify the CIDR range in a set of IP permissions instead.</p>', 'AuthorizeSecurityGroupIngressRequest$GroupName' => '<p>[EC2-Classic, default VPC] The name of the security group.</p>', 'AuthorizeSecurityGroupIngressRequest$GroupId' => '<p>The ID of the security group. Required for a nondefault VPC.</p>', 'AuthorizeSecurityGroupIngressRequest$SourceSecurityGroupName' => '<p>[EC2-Classic, default VPC] The name of the source security group. You can\'t specify this parameter in combination with the following parameters: the CIDR IP address range, the start of the port range, the IP protocol, and the end of the port range. Creates rules that grant full ICMP, UDP, and TCP access. To create a rule with a specific IP protocol and port range, use a set of IP permissions instead. For EC2-VPC, the source security group must be in the same VPC.</p>', 'AuthorizeSecurityGroupIngressRequest$SourceSecurityGroupOwnerId' => '<p>[EC2-Classic] The AWS account number for the source security group, if the source security group is in a different account. You can\'t specify this parameter in combination with the following parameters: the CIDR IP address range, the IP protocol, the start of the port range, and the end of the port range. Creates rules that grant full ICMP, UDP, and TCP access. To create a rule with a specific IP protocol and port range, use a set of IP permissions instead.</p>', 'AuthorizeSecurityGroupIngressRequest$IpProtocol' => '<p>The IP protocol name (<code>tcp</code>, <code>udp</code>, <code>icmp</code>) or number (see <a href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a>). (VPC only) Use <code>-1</code> to specify all traffic. If you specify <code>-1</code>, traffic on all ports is allowed, regardless of any ports you specify.</p>', 'AuthorizeSecurityGroupIngressRequest$CidrIp' => '<p>The CIDR IP address range. You can\'t specify this parameter when specifying a source security group.</p>', 'AvailabilityZone$ZoneName' => '<p>The name of the Availability Zone.</p>', 'AvailabilityZone$RegionName' => '<p>The name of the region.</p>', 'AvailabilityZoneMessage$Message' => '<p>The message about the Availability Zone.</p>', 'BlockDeviceMapping$VirtualName' => '<p>The virtual device name (<code>ephemeral</code>N). Instance store volumes are numbered starting from 0. An instance type with 2 available instance store volumes can specify mappings for <code>ephemeral0</code> and <code>ephemeral1</code>.The number of available instance store volumes depends on the instance type. After you connect to the instance, you must mount the volume.</p> <p>Constraints: For M3 instances, you must specify instance store volumes in the block device mapping for the instance. When you launch an M3 instance, we ignore any instance store volumes specified in the block device mapping for the AMI.</p>', 'BlockDeviceMapping$DeviceName' => '<p>The device name exposed to the instance (for example, <code>/dev/sdh</code> or <code>xvdh</code>).</p>', 'BlockDeviceMapping$NoDevice' => '<p>Suppresses the specified device included in the block device mapping of the AMI.</p>', 'BundleIdStringList$member' => NULL, 'BundleInstanceRequest$InstanceId' => '<p>The ID of the instance to bundle.</p> <p>Type: String</p> <p>Default: None</p> <p>Required: Yes</p>', 'BundleTask$InstanceId' => '<p>The ID of the instance associated with this bundle task.</p>', 'BundleTask$BundleId' => '<p>The ID of the bundle task.</p>', 'BundleTask$Progress' => '<p>The level of task completion, as a percent (for example, 20%).</p>', 'BundleTaskError$Code' => '<p>The error code.</p>', 'BundleTaskError$Message' => '<p>The error message.</p>', 'CancelBundleTaskRequest$BundleId' => '<p>The ID of the bundle task.</p>', 'CancelConversionRequest$ConversionTaskId' => '<p>The ID of the conversion task.</p>', 'CancelConversionRequest$ReasonMessage' => '<p>The reason for canceling the conversion task.</p>', 'CancelExportTaskRequest$ExportTaskId' => '<p>The ID of the export task. This is the ID returned by <code>CreateInstanceExportTask</code>.</p>', 'CancelImportTaskRequest$ImportTaskId' => '<p>The ID of the import image or import snapshot task to be canceled.</p>', 'CancelImportTaskRequest$CancelReason' => '<p>The reason for canceling the task.</p>', 'CancelImportTaskResult$ImportTaskId' => '<p>The ID of the task being canceled.</p>', 'CancelImportTaskResult$State' => '<p>The current state of the task being canceled.</p>', 'CancelImportTaskResult$PreviousState' => '<p>The current state of the task being canceled.</p>', 'CancelReservedInstancesListingRequest$ReservedInstancesListingId' => '<p>The ID of the Reserved Instance listing.</p>', 'CancelSpotFleetRequestsError$Message' => '<p>The description for the error code.</p>', 'CancelSpotFleetRequestsErrorItem$SpotFleetRequestId' => '<p>The ID of the Spot fleet request.</p>', 'CancelSpotFleetRequestsSuccessItem$SpotFleetRequestId' => '<p>The ID of the Spot fleet request.</p>', 'CancelledSpotInstanceRequest$SpotInstanceRequestId' => '<p>The ID of the Spot instance request.</p>', 'ClassicLinkDnsSupport$VpcId' => '<p>The ID of the VPC.</p>', 'ClassicLinkInstance$InstanceId' => '<p>The ID of the instance.</p>', 'ClassicLinkInstance$VpcId' => '<p>The ID of the VPC.</p>', 'ClientData$Comment' => '<p>A user-defined comment about the disk upload.</p>', 'ConfirmProductInstanceRequest$ProductCode' => '<p>The product code. This must be a product code that you own.</p>', 'ConfirmProductInstanceRequest$InstanceId' => '<p>The ID of the instance.</p>', 'ConfirmProductInstanceResult$OwnerId' => '<p>The AWS account ID of the instance owner. This is only present if the product code is attached to the instance.</p>', 'ConversionIdStringList$member' => NULL, 'ConversionTask$ConversionTaskId' => '<p>The ID of the conversion task.</p>', 'ConversionTask$ExpirationTime' => '<p>The time when the task expires. If the upload isn\'t complete before the expiration time, we automatically cancel the task.</p>', 'ConversionTask$StatusMessage' => '<p>The status message related to the conversion task.</p>', 'CopyImageRequest$SourceRegion' => '<p>The name of the region that contains the AMI to copy.</p>', 'CopyImageRequest$SourceImageId' => '<p>The ID of the AMI to copy.</p>', 'CopyImageRequest$Name' => '<p>The name of the new AMI in the destination region.</p>', 'CopyImageRequest$Description' => '<p>A description for the new AMI in the destination region.</p>', 'CopyImageRequest$ClientToken' => '<p>Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure Idempotency</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'CopyImageRequest$KmsKeyId' => '<p>The full ARN of the AWS Key Management Service (AWS KMS) CMK to use when encrypting the snapshots of an image during a copy operation. This parameter is only required if you want to use a non-default CMK; if this parameter is not specified, the default CMK for EBS is used. The ARN contains the <code>arn:aws:kms</code> namespace, followed by the region of the CMK, the AWS account ID of the CMK owner, the <code>key</code> namespace, and then the CMK ID. For example, arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:key/<i>abcd1234-a123-456a-a12b-a123b4cd56ef</i>. The specified CMK must exist in the region that the snapshot is being copied to. If a <code>KmsKeyId</code> is specified, the <code>Encrypted</code> flag must also be set.</p>', 'CopyImageResult$ImageId' => '<p>The ID of the new AMI.</p>', 'CopySnapshotRequest$SourceRegion' => '<p>The ID of the region that contains the snapshot to be copied.</p>', 'CopySnapshotRequest$SourceSnapshotId' => '<p>The ID of the EBS snapshot to copy.</p>', 'CopySnapshotRequest$Description' => '<p>A description for the EBS snapshot.</p>', 'CopySnapshotRequest$DestinationRegion' => '<p>The destination region to use in the <code>PresignedUrl</code> parameter of a snapshot copy operation. This parameter is only valid for specifying the destination region in a <code>PresignedUrl</code> parameter, where it is required.</p> <note> <p> <code>CopySnapshot</code> sends the snapshot copy to the regional endpoint that you send the HTTP request to, such as <code>ec2.us-east-1.amazonaws.com</code> (in the AWS CLI, this is specified with the <code>--region</code> parameter or the default region in your AWS configuration file).</p> </note>', 'CopySnapshotRequest$PresignedUrl' => '<p>The pre-signed URL that facilitates copying an encrypted snapshot. This parameter is only required when copying an encrypted snapshot with the Amazon EC2 Query API; it is available as an optional parameter in all other cases. The <code>PresignedUrl</code> should use the snapshot source endpoint, the <code>CopySnapshot</code> action, and include the <code>SourceRegion</code>, <code>SourceSnapshotId</code>, and <code>DestinationRegion</code> parameters. The <code>PresignedUrl</code> must be signed using AWS Signature Version 4. Because EBS snapshots are stored in Amazon S3, the signing algorithm for this parameter uses the same logic that is described in <a href="http://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html">Authenticating Requests by Using Query Parameters (AWS Signature Version 4)</a> in the <i>Amazon Simple Storage Service API Reference</i>. An invalid or improperly signed <code>PresignedUrl</code> will cause the copy operation to fail asynchronously, and the snapshot will move to an <code>error</code> state.</p>', 'CopySnapshotRequest$KmsKeyId' => '<p>The full ARN of the AWS Key Management Service (AWS KMS) CMK to use when creating the snapshot copy. This parameter is only required if you want to use a non-default CMK; if this parameter is not specified, the default CMK for EBS is used. The ARN contains the <code>arn:aws:kms</code> namespace, followed by the region of the CMK, the AWS account ID of the CMK owner, the <code>key</code> namespace, and then the CMK ID. For example, arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:key/<i>abcd1234-a123-456a-a12b-a123b4cd56ef</i>. The specified CMK must exist in the region that the snapshot is being copied to. If a <code>KmsKeyId</code> is specified, the <code>Encrypted</code> flag must also be set.</p>', 'CopySnapshotResult$SnapshotId' => '<p>The ID of the new snapshot.</p>', 'CreateCustomerGatewayRequest$PublicIp' => '<p>The Internet-routable IP address for the customer gateway\'s outside interface. The address must be static.</p>', 'CreateFlowLogsRequest$LogGroupName' => '<p>The name of the CloudWatch log group.</p>', 'CreateFlowLogsRequest$DeliverLogsPermissionArn' => '<p>The ARN for the IAM role that\'s used to post flow logs to a CloudWatch Logs log group.</p>', 'CreateFlowLogsRequest$ClientToken' => '<p>Unique, case-sensitive identifier you provide to ensure the idempotency of the request. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure Idempotency</a>.</p>', 'CreateFlowLogsResult$ClientToken' => '<p>Unique, case-sensitive identifier you provide to ensure the idempotency of the request.</p>', 'CreateImageRequest$InstanceId' => '<p>The ID of the instance.</p>', 'CreateImageRequest$Name' => '<p>A name for the new image.</p> <p>Constraints: 3-128 alphanumeric characters, parentheses (()), square brackets ([]), spaces ( ), periods (.), slashes (/), dashes (-), single quotes (\'), at-signs (@), or underscores(_)</p>', 'CreateImageRequest$Description' => '<p>A description for the new image.</p>', 'CreateImageResult$ImageId' => '<p>The ID of the new AMI.</p>', 'CreateInstanceExportTaskRequest$Description' => '<p>A description for the conversion task or the resource being exported. The maximum length is 255 bytes.</p>', 'CreateInstanceExportTaskRequest$InstanceId' => '<p>The ID of the instance.</p>', 'CreateKeyPairRequest$KeyName' => '<p>A unique name for the key pair.</p> <p>Constraints: Up to 255 ASCII characters</p>', 'CreateNatGatewayRequest$SubnetId' => '<p>The subnet in which to create the NAT gateway.</p>', 'CreateNatGatewayRequest$AllocationId' => '<p>The allocation ID of an Elastic IP address to associate with the NAT gateway. If the Elastic IP address is associated with another resource, you must first disassociate it.</p>', 'CreateNatGatewayRequest$ClientToken' => '<p>Unique, case-sensitive identifier you provide to ensure the idempotency of the request. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to Ensure Idempotency</a>.</p> <p>Constraint: Maximum 64 ASCII characters.</p>', 'CreateNatGatewayResult$ClientToken' => '<p>Unique, case-sensitive identifier to ensure the idempotency of the request. Only returned if a client token was provided in the request.</p>', 'CreateNetworkAclEntryRequest$NetworkAclId' => '<p>The ID of the network ACL.</p>', 'CreateNetworkAclEntryRequest$Protocol' => '<p>The protocol. A value of -1 means all protocols.</p>', 'CreateNetworkAclEntryRequest$CidrBlock' => '<p>The network range to allow or deny, in CIDR notation (for example <code>172.16.0.0/24</code>).</p>', 'CreateNetworkAclRequest$VpcId' => '<p>The ID of the VPC.</p>', 'CreateNetworkInterfaceRequest$SubnetId' => '<p>The ID of the subnet to associate with the network interface.</p>', 'CreateNetworkInterfaceRequest$Description' => '<p>A description for the network interface.</p>', 'CreateNetworkInterfaceRequest$PrivateIpAddress' => '<p>The primary private IP address of the network interface. If you don\'t specify an IP address, Amazon EC2 selects one for you from the subnet range. If you specify an IP address, you cannot indicate any IP addresses specified in <code>privateIpAddresses</code> as primary (only one IP address can be designated as primary).</p>', 'CreatePlacementGroupRequest$GroupName' => '<p>A name for the placement group.</p> <p>Constraints: Up to 255 ASCII characters</p>', 'CreateReservedInstancesListingRequest$ReservedInstancesId' => '<p>The ID of the active Standard Reserved Instance.</p>', 'CreateReservedInstancesListingRequest$ClientToken' => '<p>Unique, case-sensitive identifier you provide to ensure idempotency of your listings. This helps avoid duplicate listings. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>', 'CreateRouteRequest$RouteTableId' => '<p>The ID of the route table for the route.</p>', 'CreateRouteRequest$DestinationCidrBlock' => '<p>The CIDR address block used for the destination match. Routing decisions are based on the most specific match.</p>', 'CreateRouteRequest$GatewayId' => '<p>The ID of an Internet gateway or virtual private gateway attached to your VPC.</p>', 'CreateRouteRequest$InstanceId' => '<p>The ID of a NAT instance in your VPC. The operation fails if you specify an instance ID unless exactly one network interface is attached.</p>', 'CreateRouteRequest$NetworkInterfaceId' => '<p>The ID of a network interface.</p>', 'CreateRouteRequest$VpcPeeringConnectionId' => '<p>The ID of a VPC peering connection.</p>', 'CreateRouteRequest$NatGatewayId' => '<p>The ID of a NAT gateway.</p>', 'CreateRouteTableRequest$VpcId' => '<p>The ID of the VPC.</p>', 'CreateSecurityGroupRequest$GroupName' => '<p>The name of the security group.</p> <p>Constraints: Up to 255 characters in length</p> <p>Constraints for EC2-Classic: ASCII characters</p> <p>Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and ._-:/()#,@[]+=&amp;;{}!$*</p>', 'CreateSecurityGroupRequest$Description' => '<p>A description for the security group. This is informational only.</p> <p>Constraints: Up to 255 characters in length</p> <p>Constraints for EC2-Classic: ASCII characters</p> <p>Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and ._-:/()#,@[]+=&amp;;{}!$*</p>', 'CreateSecurityGroupRequest$VpcId' => '<p>[EC2-VPC] The ID of the VPC. Required for EC2-VPC.</p>', 'CreateSecurityGroupResult$GroupId' => '<p>The ID of the security group.</p>', 'CreateSnapshotRequest$VolumeId' => '<p>The ID of the EBS volume.</p>', 'CreateSnapshotRequest$Description' => '<p>A description for the snapshot.</p>', 'CreateSpotDatafeedSubscriptionRequest$Bucket' => '<p>The Amazon S3 bucket in which to store the Spot instance data feed.</p>', 'CreateSpotDatafeedSubscriptionRequest$Prefix' => '<p>A prefix for the data feed file names.</p>', 'CreateSubnetRequest$VpcId' => '<p>The ID of the VPC.</p>', 'CreateSubnetRequest$CidrBlock' => '<p>The network range for the subnet, in CIDR notation. For example, <code>10.0.0.0/24</code>.</p>', 'CreateSubnetRequest$AvailabilityZone' => '<p>The Availability Zone for the subnet.</p> <p>Default: AWS selects one for you. If you create more than one subnet in your VPC, we may not necessarily select a different zone for each subnet.</p>', 'CreateVolumePermission$UserId' => '<p>The specific AWS account ID that is to be added or removed from a volume\'s list of create volume permissions.</p>', 'CreateVolumeRequest$SnapshotId' => '<p>The snapshot from which to create the volume.</p>', 'CreateVolumeRequest$AvailabilityZone' => '<p>The Availability Zone in which to create the volume. Use <a>DescribeAvailabilityZones</a> to list the Availability Zones that are currently available to you.</p>', 'CreateVolumeRequest$KmsKeyId' => '<p>The full ARN of the AWS Key Management Service (AWS KMS) customer master key (CMK) to use when creating the encrypted volume. This parameter is only required if you want to use a non-default CMK; if this parameter is not specified, the default CMK for EBS is used. The ARN contains the <code>arn:aws:kms</code> namespace, followed by the region of the CMK, the AWS account ID of the CMK owner, the <code>key</code> namespace, and then the CMK ID. For example, arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:key/<i>abcd1234-a123-456a-a12b-a123b4cd56ef</i>. If a <code>KmsKeyId</code> is specified, the <code>Encrypted</code> flag must also be set.</p>', 'CreateVpcEndpointRequest$VpcId' => '<p>The ID of the VPC in which the endpoint will be used.</p>', 'CreateVpcEndpointRequest$ServiceName' => '<p>The AWS service name, in the form <code>com.amazonaws.<i>region</i>.<i>service</i> </code>. To get a list of available services, use the <a>DescribeVpcEndpointServices</a> request.</p>', 'CreateVpcEndpointRequest$PolicyDocument' => '<p>A policy to attach to the endpoint that controls access to the service. The policy must be in valid JSON format. If this parameter is not specified, we attach a default policy that allows full access to the service.</p>', 'CreateVpcEndpointRequest$ClientToken' => '<p>Unique, case-sensitive identifier you provide to ensure the idempotency of the request. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to Ensure Idempotency</a>.</p>', 'CreateVpcEndpointResult$ClientToken' => '<p>Unique, case-sensitive identifier you provide to ensure the idempotency of the request.</p>', 'CreateVpcPeeringConnectionRequest$VpcId' => '<p>The ID of the requester VPC.</p>', 'CreateVpcPeeringConnectionRequest$PeerVpcId' => '<p>The ID of the VPC with which you are creating the VPC peering connection.</p>', 'CreateVpcPeeringConnectionRequest$PeerOwnerId' => '<p>The AWS account ID of the owner of the peer VPC.</p> <p>Default: Your AWS account ID</p>', 'CreateVpcRequest$CidrBlock' => '<p>The network range for the VPC, in CIDR notation. For example, <code>10.0.0.0/16</code>.</p>', 'CreateVpnConnectionRequest$Type' => '<p>The type of VPN connection (<code>ipsec.1</code>).</p>', 'CreateVpnConnectionRequest$CustomerGatewayId' => '<p>The ID of the customer gateway.</p>', 'CreateVpnConnectionRequest$VpnGatewayId' => '<p>The ID of the virtual private gateway.</p>', 'CreateVpnConnectionRouteRequest$VpnConnectionId' => '<p>The ID of the VPN connection.</p>', 'CreateVpnConnectionRouteRequest$DestinationCidrBlock' => '<p>The CIDR block associated with the local subnet of the customer network.</p>', 'CreateVpnGatewayRequest$AvailabilityZone' => '<p>The Availability Zone for the virtual private gateway.</p>', 'CustomerGateway$CustomerGatewayId' => '<p>The ID of the customer gateway.</p>', 'CustomerGateway$State' => '<p>The current state of the customer gateway (<code>pending | available | deleting | deleted</code>).</p>', 'CustomerGateway$Type' => '<p>The type of VPN connection the customer gateway supports (<code>ipsec.1</code>).</p>', 'CustomerGateway$IpAddress' => '<p>The Internet-routable IP address of the customer gateway\'s outside interface.</p>', 'CustomerGateway$BgpAsn' => '<p>The customer gateway\'s Border Gateway Protocol (BGP) Autonomous System Number (ASN).</p>', 'CustomerGatewayIdStringList$member' => NULL, 'DeleteCustomerGatewayRequest$CustomerGatewayId' => '<p>The ID of the customer gateway.</p>', 'DeleteDhcpOptionsRequest$DhcpOptionsId' => '<p>The ID of the DHCP options set.</p>', 'DeleteInternetGatewayRequest$InternetGatewayId' => '<p>The ID of the Internet gateway.</p>', 'DeleteKeyPairRequest$KeyName' => '<p>The name of the key pair.</p>', 'DeleteNatGatewayRequest$NatGatewayId' => '<p>The ID of the NAT gateway.</p>', 'DeleteNatGatewayResult$NatGatewayId' => '<p>The ID of the NAT gateway.</p>', 'DeleteNetworkAclEntryRequest$NetworkAclId' => '<p>The ID of the network ACL.</p>', 'DeleteNetworkAclRequest$NetworkAclId' => '<p>The ID of the network ACL.</p>', 'DeleteNetworkInterfaceRequest$NetworkInterfaceId' => '<p>The ID of the network interface.</p>', 'DeletePlacementGroupRequest$GroupName' => '<p>The name of the placement group.</p>', 'DeleteRouteRequest$RouteTableId' => '<p>The ID of the route table.</p>', 'DeleteRouteRequest$DestinationCidrBlock' => '<p>The CIDR range for the route. The value you specify must match the CIDR for the route exactly.</p>', 'DeleteRouteTableRequest$RouteTableId' => '<p>The ID of the route table.</p>', 'DeleteSecurityGroupRequest$GroupName' => '<p>[EC2-Classic, default VPC] The name of the security group. You can specify either the security group name or the security group ID.</p>', 'DeleteSecurityGroupRequest$GroupId' => '<p>The ID of the security group. Required for a nondefault VPC.</p>', 'DeleteSnapshotRequest$SnapshotId' => '<p>The ID of the EBS snapshot.</p>', 'DeleteSubnetRequest$SubnetId' => '<p>The ID of the subnet.</p>', 'DeleteVolumeRequest$VolumeId' => '<p>The ID of the volume.</p>', 'DeleteVpcPeeringConnectionRequest$VpcPeeringConnectionId' => '<p>The ID of the VPC peering connection.</p>', 'DeleteVpcRequest$VpcId' => '<p>The ID of the VPC.</p>', 'DeleteVpnConnectionRequest$VpnConnectionId' => '<p>The ID of the VPN connection.</p>', 'DeleteVpnConnectionRouteRequest$VpnConnectionId' => '<p>The ID of the VPN connection.</p>', 'DeleteVpnConnectionRouteRequest$DestinationCidrBlock' => '<p>The CIDR block associated with the local subnet of the customer network.</p>', 'DeleteVpnGatewayRequest$VpnGatewayId' => '<p>The ID of the virtual private gateway.</p>', 'DeregisterImageRequest$ImageId' => '<p>The ID of the AMI.</p>', 'DescribeClassicLinkInstancesRequest$NextToken' => '<p>The token to retrieve the next page of results.</p>', 'DescribeClassicLinkInstancesResult$NextToken' => '<p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'DescribeFlowLogsRequest$NextToken' => '<p>The token to retrieve the next page of results.</p>', 'DescribeFlowLogsResult$NextToken' => '<p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'DescribeHostReservationOfferingsRequest$OfferingId' => '<p>The ID of the reservation offering.</p>', 'DescribeHostReservationOfferingsRequest$NextToken' => '<p>The token to use to retrieve the next page of results.</p>', 'DescribeHostReservationOfferingsResult$NextToken' => '<p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'DescribeHostReservationsRequest$NextToken' => '<p>The token to use to retrieve the next page of results.</p>', 'DescribeHostReservationsResult$NextToken' => '<p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'DescribeHostsRequest$NextToken' => '<p>The token to retrieve the next page of results.</p>', 'DescribeHostsResult$NextToken' => '<p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'DescribeIdFormatRequest$Resource' => '<p>The type of resource: <code>instance</code> | <code>reservation</code> | <code>snapshot</code> | <code>volume</code> </p>', 'DescribeIdentityIdFormatRequest$Resource' => '<p>The type of resource: <code>instance</code> | <code>reservation</code> | <code>snapshot</code> | <code>volume</code> </p>', 'DescribeIdentityIdFormatRequest$PrincipalArn' => '<p>The ARN of the principal, which can be an IAM role, IAM user, or the root user.</p>', 'DescribeImageAttributeRequest$ImageId' => '<p>The ID of the AMI.</p>', 'DescribeImportImageTasksRequest$NextToken' => '<p>A token that indicates the next page of results.</p>', 'DescribeImportImageTasksResult$NextToken' => '<p>The token to use to get the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'DescribeImportSnapshotTasksRequest$NextToken' => '<p>A token that indicates the next page of results.</p>', 'DescribeImportSnapshotTasksResult$NextToken' => '<p>The token to use to get the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'DescribeInstanceAttributeRequest$InstanceId' => '<p>The ID of the instance.</p>', 'DescribeInstanceStatusRequest$NextToken' => '<p>The token to retrieve the next page of results.</p>', 'DescribeInstanceStatusResult$NextToken' => '<p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'DescribeInstancesRequest$NextToken' => '<p>The token to request the next page of results.</p>', 'DescribeInstancesResult$NextToken' => '<p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'DescribeMovingAddressesRequest$NextToken' => '<p>The token to use to retrieve the next page of results.</p>', 'DescribeMovingAddressesResult$NextToken' => '<p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'DescribeNatGatewaysRequest$NextToken' => '<p>The token to retrieve the next page of results.</p>', 'DescribeNatGatewaysResult$NextToken' => '<p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'DescribeNetworkInterfaceAttributeRequest$NetworkInterfaceId' => '<p>The ID of the network interface.</p>', 'DescribeNetworkInterfaceAttributeResult$NetworkInterfaceId' => '<p>The ID of the network interface.</p>', 'DescribePrefixListsRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a prior call.)</p>', 'DescribePrefixListsResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'DescribeReservedInstancesListingsRequest$ReservedInstancesId' => '<p>One or more Reserved Instance IDs.</p>', 'DescribeReservedInstancesListingsRequest$ReservedInstancesListingId' => '<p>One or more Reserved Instance listing IDs.</p>', 'DescribeReservedInstancesModificationsRequest$NextToken' => '<p>The token to retrieve the next page of results.</p>', 'DescribeReservedInstancesModificationsResult$NextToken' => '<p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'DescribeReservedInstancesOfferingsRequest$AvailabilityZone' => '<p>The Availability Zone in which the Reserved Instance can be used.</p>', 'DescribeReservedInstancesOfferingsRequest$NextToken' => '<p>The token to retrieve the next page of results.</p>', 'DescribeReservedInstancesOfferingsResult$NextToken' => '<p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'DescribeScheduledInstanceAvailabilityRequest$NextToken' => '<p>The token for the next set of results.</p>', 'DescribeScheduledInstanceAvailabilityResult$NextToken' => '<p>The token required to retrieve the next set of results. This value is <code>null</code> when there are no more results to return.</p>', 'DescribeScheduledInstancesRequest$NextToken' => '<p>The token for the next set of results.</p>', 'DescribeScheduledInstancesResult$NextToken' => '<p>The token required to retrieve the next set of results. This value is <code>null</code> when there are no more results to return.</p>', 'DescribeSnapshotAttributeRequest$SnapshotId' => '<p>The ID of the EBS snapshot.</p>', 'DescribeSnapshotAttributeResult$SnapshotId' => '<p>The ID of the EBS snapshot.</p>', 'DescribeSnapshotsRequest$NextToken' => '<p>The <code>NextToken</code> value returned from a previous paginated <code>DescribeSnapshots</code> request where <code>MaxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>NextToken</code> value. This value is <code>null</code> when there are no more results to return.</p>', 'DescribeSnapshotsResult$NextToken' => '<p>The <code>NextToken</code> value to include in a future <code>DescribeSnapshots</code> request. When the results of a <code>DescribeSnapshots</code> request exceed <code>MaxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'DescribeSpotFleetInstancesRequest$SpotFleetRequestId' => '<p>The ID of the Spot fleet request.</p>', 'DescribeSpotFleetInstancesRequest$NextToken' => '<p>The token for the next set of results.</p>', 'DescribeSpotFleetInstancesResponse$SpotFleetRequestId' => '<p>The ID of the Spot fleet request.</p>', 'DescribeSpotFleetInstancesResponse$NextToken' => '<p>The token required to retrieve the next set of results. This value is <code>null</code> when there are no more results to return.</p>', 'DescribeSpotFleetRequestHistoryRequest$SpotFleetRequestId' => '<p>The ID of the Spot fleet request.</p>', 'DescribeSpotFleetRequestHistoryRequest$NextToken' => '<p>The token for the next set of results.</p>', 'DescribeSpotFleetRequestHistoryResponse$SpotFleetRequestId' => '<p>The ID of the Spot fleet request.</p>', 'DescribeSpotFleetRequestHistoryResponse$NextToken' => '<p>The token required to retrieve the next set of results. This value is <code>null</code> when there are no more results to return.</p>', 'DescribeSpotFleetRequestsRequest$NextToken' => '<p>The token for the next set of results.</p>', 'DescribeSpotFleetRequestsResponse$NextToken' => '<p>The token required to retrieve the next set of results. This value is <code>null</code> when there are no more results to return.</p>', 'DescribeSpotPriceHistoryRequest$AvailabilityZone' => '<p>Filters the results by the specified Availability Zone.</p>', 'DescribeSpotPriceHistoryRequest$NextToken' => '<p>The token for the next set of results.</p>', 'DescribeSpotPriceHistoryResult$NextToken' => '<p>The token required to retrieve the next set of results. This value is <code>null</code> when there are no more results to return.</p>', 'DescribeStaleSecurityGroupsRequest$VpcId' => '<p>The ID of the VPC.</p>', 'DescribeStaleSecurityGroupsResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'DescribeTagsRequest$NextToken' => '<p>The token to retrieve the next page of results.</p>', 'DescribeTagsResult$NextToken' => '<p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return..</p>', 'DescribeVolumeAttributeRequest$VolumeId' => '<p>The ID of the volume.</p>', 'DescribeVolumeAttributeResult$VolumeId' => '<p>The ID of the volume.</p>', 'DescribeVolumeStatusRequest$NextToken' => '<p>The <code>NextToken</code> value to include in a future <code>DescribeVolumeStatus</code> request. When the results of the request exceed <code>MaxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'DescribeVolumeStatusResult$NextToken' => '<p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'DescribeVolumesRequest$NextToken' => '<p>The <code>NextToken</code> value returned from a previous paginated <code>DescribeVolumes</code> request where <code>MaxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>NextToken</code> value. This value is <code>null</code> when there are no more results to return.</p>', 'DescribeVolumesResult$NextToken' => '<p>The <code>NextToken</code> value to include in a future <code>DescribeVolumes</code> request. When the results of a <code>DescribeVolumes</code> request exceed <code>MaxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'DescribeVpcAttributeRequest$VpcId' => '<p>The ID of the VPC.</p>', 'DescribeVpcAttributeResult$VpcId' => '<p>The ID of the VPC.</p>', 'DescribeVpcEndpointServicesRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a prior call.)</p>', 'DescribeVpcEndpointServicesResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'DescribeVpcEndpointsRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a prior call.)</p>', 'DescribeVpcEndpointsResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'DetachClassicLinkVpcRequest$InstanceId' => '<p>The ID of the instance to unlink from the VPC.</p>', 'DetachClassicLinkVpcRequest$VpcId' => '<p>The ID of the VPC to which the instance is linked.</p>', 'DetachInternetGatewayRequest$InternetGatewayId' => '<p>The ID of the Internet gateway.</p>', 'DetachInternetGatewayRequest$VpcId' => '<p>The ID of the VPC.</p>', 'DetachNetworkInterfaceRequest$AttachmentId' => '<p>The ID of the attachment.</p>', 'DetachVolumeRequest$VolumeId' => '<p>The ID of the volume.</p>', 'DetachVolumeRequest$InstanceId' => '<p>The ID of the instance.</p>', 'DetachVolumeRequest$Device' => '<p>The device name.</p>', 'DetachVpnGatewayRequest$VpnGatewayId' => '<p>The ID of the virtual private gateway.</p>', 'DetachVpnGatewayRequest$VpcId' => '<p>The ID of the VPC.</p>', 'DhcpConfiguration$Key' => '<p>The name of a DHCP option.</p>', 'DhcpOptions$DhcpOptionsId' => '<p>The ID of the set of DHCP options.</p>', 'DhcpOptionsIdStringList$member' => NULL, 'DisableVgwRoutePropagationRequest$RouteTableId' => '<p>The ID of the route table.</p>', 'DisableVgwRoutePropagationRequest$GatewayId' => '<p>The ID of the virtual private gateway.</p>', 'DisableVpcClassicLinkDnsSupportRequest$VpcId' => '<p>The ID of the VPC.</p>', 'DisableVpcClassicLinkRequest$VpcId' => '<p>The ID of the VPC.</p>', 'DisassociateAddressRequest$PublicIp' => '<p>[EC2-Classic] The Elastic IP address. Required for EC2-Classic.</p>', 'DisassociateAddressRequest$AssociationId' => '<p>[EC2-VPC] The association ID. Required for EC2-VPC.</p>', 'DisassociateRouteTableRequest$AssociationId' => '<p>The association ID representing the current association between the route table and subnet.</p>', 'DiskImage$Description' => '<p>A description of the disk image.</p>', 'DiskImageDescription$ImportManifestUrl' => '<p>A presigned URL for the import manifest stored in Amazon S3. For information about creating a presigned URL for an Amazon S3 object, read the "Query String Request Authentication Alternative" section of the <a href="http://docs.aws.amazon.com/AmazonS3/latest/dev/RESTAuthentication.html">Authenticating REST Requests</a> topic in the <i>Amazon Simple Storage Service Developer Guide</i>.</p> <p>For information about the import manifest referenced by this API action, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html">VM Import Manifest</a>.</p>', 'DiskImageDescription$Checksum' => '<p>The checksum computed for the disk image.</p>', 'DiskImageDetail$ImportManifestUrl' => '<p>A presigned URL for the import manifest stored in Amazon S3 and presented here as an Amazon S3 presigned URL. For information about creating a presigned URL for an Amazon S3 object, read the "Query String Request Authentication Alternative" section of the <a href="http://docs.aws.amazon.com/AmazonS3/latest/dev/RESTAuthentication.html">Authenticating REST Requests</a> topic in the <i>Amazon Simple Storage Service Developer Guide</i>.</p> <p>For information about the import manifest referenced by this API action, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html">VM Import Manifest</a>.</p>', 'DiskImageVolumeDescription$Id' => '<p>The volume identifier.</p>', 'EbsBlockDevice$SnapshotId' => '<p>The ID of the snapshot.</p>', 'EbsInstanceBlockDevice$VolumeId' => '<p>The ID of the EBS volume.</p>', 'EbsInstanceBlockDeviceSpecification$VolumeId' => '<p>The ID of the EBS volume.</p>', 'EnableVgwRoutePropagationRequest$RouteTableId' => '<p>The ID of the route table.</p>', 'EnableVgwRoutePropagationRequest$GatewayId' => '<p>The ID of the virtual private gateway.</p>', 'EnableVolumeIORequest$VolumeId' => '<p>The ID of the volume.</p>', 'EnableVpcClassicLinkDnsSupportRequest$VpcId' => '<p>The ID of the VPC.</p>', 'EnableVpcClassicLinkRequest$VpcId' => '<p>The ID of the VPC.</p>', 'EventInformation$InstanceId' => '<p>The ID of the instance. This information is available only for <code>instanceChange</code> events.</p>', 'EventInformation$EventSubType' => '<p>The event.</p> <p>The following are the <code>error</code> events.</p> <ul> <li> <p> <code>iamFleetRoleInvalid</code> - The Spot fleet did not have the required permissions either to launch or terminate an instance.</p> </li> <li> <p> <code>launchSpecTemporarilyBlacklisted</code> - The configuration is not valid and several attempts to launch instances have failed. For more information, see the description of the event.</p> </li> <li> <p> <code>spotFleetRequestConfigurationInvalid</code> - The configuration is not valid. For more information, see the description of the event.</p> </li> <li> <p> <code>spotInstanceCountLimitExceeded</code> - You\'ve reached the limit on the number of Spot instances that you can launch.</p> </li> </ul> <p>The following are the <code>fleetRequestChange</code> events.</p> <ul> <li> <p> <code>active</code> - The Spot fleet has been validated and Amazon EC2 is attempting to maintain the target number of running Spot instances.</p> </li> <li> <p> <code>cancelled</code> - The Spot fleet is canceled and has no running Spot instances. The Spot fleet will be deleted two days after its instances were terminated.</p> </li> <li> <p> <code>cancelled_running</code> - The Spot fleet is canceled and will not launch additional Spot instances, but its existing Spot instances continue to run until they are interrupted or terminated.</p> </li> <li> <p> <code>cancelled_terminating</code> - The Spot fleet is canceled and its Spot instances are terminating.</p> </li> <li> <p> <code>expired</code> - The Spot fleet request has expired. A subsequent event indicates that the instances were terminated, if the request was created with <code>TerminateInstancesWithExpiration</code> set.</p> </li> <li> <p> <code>modify_in_progress</code> - A request to modify the Spot fleet request was accepted and is in progress.</p> </li> <li> <p> <code>modify_successful</code> - The Spot fleet request was modified.</p> </li> <li> <p> <code>price_update</code> - The bid price for a launch configuration was adjusted because it was too high. This change is permanent.</p> </li> <li> <p> <code>submitted</code> - The Spot fleet request is being evaluated and Amazon EC2 is preparing to launch the target number of Spot instances.</p> </li> </ul> <p>The following are the <code>instanceChange</code> events.</p> <ul> <li> <p> <code>launched</code> - A bid was fulfilled and a new instance was launched.</p> </li> <li> <p> <code>terminated</code> - An instance was terminated by the user.</p> </li> </ul>', 'EventInformation$EventDescription' => '<p>The description of the event.</p>', 'ExecutableByStringList$member' => NULL, 'ExportTask$ExportTaskId' => '<p>The ID of the export task.</p>', 'ExportTask$Description' => '<p>A description of the resource being exported.</p>', 'ExportTask$StatusMessage' => '<p>The status message related to the export task.</p>', 'ExportTaskIdStringList$member' => NULL, 'ExportToS3Task$S3Bucket' => '<p>The S3 bucket for the destination image. The destination bucket must exist and grant WRITE and READ_ACP permissions to the AWS account <code>vm-import-export@amazon.com</code>.</p>', 'ExportToS3Task$S3Key' => '<p>The encryption key for your S3 bucket.</p>', 'ExportToS3TaskSpecification$S3Bucket' => '<p>The S3 bucket for the destination image. The destination bucket must exist and grant WRITE and READ_ACP permissions to the AWS account <code>vm-import-export@amazon.com</code>.</p>', 'ExportToS3TaskSpecification$S3Prefix' => '<p>The image is written to a single object in the S3 bucket at the S3 key s3prefix + exportTaskId + \'.\' + diskImageFormat.</p>', 'Filter$Name' => '<p>The name of the filter. Filter names are case-sensitive.</p>', 'FlowLog$FlowLogId' => '<p>The flow log ID.</p>', 'FlowLog$FlowLogStatus' => '<p>The status of the flow log (<code>ACTIVE</code>).</p>', 'FlowLog$ResourceId' => '<p>The ID of the resource on which the flow log was created.</p>', 'FlowLog$LogGroupName' => '<p>The name of the flow log group.</p>', 'FlowLog$DeliverLogsStatus' => '<p>The status of the logs delivery (<code>SUCCESS</code> | <code>FAILED</code>).</p>', 'FlowLog$DeliverLogsErrorMessage' => '<p>Information about the error that occurred. <code>Rate limited</code> indicates that CloudWatch logs throttling has been applied for one or more network interfaces, or that you\'ve reached the limit on the number of CloudWatch Logs log groups that you can create. <code>Access error</code> indicates that the IAM role associated with the flow log does not have sufficient permissions to publish to CloudWatch Logs. <code>Unknown error</code> indicates an internal error.</p>', 'FlowLog$DeliverLogsPermissionArn' => '<p>The ARN of the IAM role that posts logs to CloudWatch Logs.</p>', 'GetConsoleOutputRequest$InstanceId' => '<p>The ID of the instance.</p>', 'GetConsoleOutputResult$InstanceId' => '<p>The ID of the instance.</p>', 'GetConsoleOutputResult$Output' => '<p>The console output, Base64-encoded. If using a command line tool, the tool decodes the output for you.</p>', 'GetConsoleScreenshotRequest$InstanceId' => '<p>The ID of the instance.</p>', 'GetConsoleScreenshotResult$InstanceId' => '<p>The ID of the instance.</p>', 'GetConsoleScreenshotResult$ImageData' => '<p>The data that comprises the image.</p>', 'GetHostReservationPurchasePreviewRequest$OfferingId' => '<p>The offering ID of the reservation.</p>', 'GetHostReservationPurchasePreviewResult$TotalUpfrontPrice' => '<p>The potential total upfront price. This is billed immediately.</p>', 'GetHostReservationPurchasePreviewResult$TotalHourlyPrice' => '<p>The potential total hourly price of the reservation per hour.</p>', 'GetPasswordDataRequest$InstanceId' => '<p>The ID of the Windows instance.</p>', 'GetPasswordDataResult$InstanceId' => '<p>The ID of the Windows instance.</p>', 'GetPasswordDataResult$PasswordData' => '<p>The password of the instance.</p>', 'GetReservedInstancesExchangeQuoteResult$PaymentDue' => '<p>The total true upfront charge for the exchange.</p>', 'GetReservedInstancesExchangeQuoteResult$CurrencyCode' => '<p>The currency of the transaction.</p>', 'GetReservedInstancesExchangeQuoteResult$ValidationFailureReason' => '<p>Describes the reason why the exchange can not be completed.</p>', 'GroupIdStringList$member' => NULL, 'GroupIdentifier$GroupName' => '<p>The name of the security group.</p>', 'GroupIdentifier$GroupId' => '<p>The ID of the security group.</p>', 'GroupIds$member' => NULL, 'GroupNameStringList$member' => NULL, 'Host$HostId' => '<p>The ID of the Dedicated Host.</p>', 'Host$HostReservationId' => '<p>The reservation ID of the Dedicated Host. This returns a <code>null</code> response if the Dedicated Host doesn\'t have an associated reservation.</p>', 'Host$ClientToken' => '<p>Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure Idempotency</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. </p>', 'Host$AvailabilityZone' => '<p>The Availability Zone of the Dedicated Host.</p>', 'HostInstance$InstanceId' => '<p>the IDs of instances that are running on the Dedicated Host.</p>', 'HostInstance$InstanceType' => '<p>The instance type size (for example, <code>m3.medium</code>) of the running instance.</p>', 'HostOffering$OfferingId' => '<p>The ID of the offering.</p>', 'HostOffering$InstanceFamily' => '<p>The instance family of the offering.</p>', 'HostOffering$UpfrontPrice' => '<p>The upfront price of the offering. Does not apply to No Upfront offerings.</p>', 'HostOffering$HourlyPrice' => '<p>The hourly price of the offering.</p>', 'HostProperties$InstanceType' => '<p>The instance type size that the Dedicated Host supports (for example, <code>m3.medium</code>).</p>', 'HostReservation$HostReservationId' => '<p>The ID of the reservation that specifies the associated Dedicated Hosts.</p>', 'HostReservation$OfferingId' => '<p>The ID of the reservation. This remains the same regardless of which Dedicated Hosts are associated with it.</p>', 'HostReservation$InstanceFamily' => '<p>The instance family of the Dedicated Host Reservation. The instance family on the Dedicated Host must be the same in order for it to benefit from the reservation.</p>', 'HostReservation$HourlyPrice' => '<p>The hourly price of the reservation.</p>', 'HostReservation$UpfrontPrice' => '<p>The upfront price of the reservation.</p>', 'HostReservationIdSet$member' => NULL, 'IamInstanceProfile$Arn' => '<p>The Amazon Resource Name (ARN) of the instance profile.</p>', 'IamInstanceProfile$Id' => '<p>The ID of the instance profile.</p>', 'IamInstanceProfileSpecification$Arn' => '<p>The Amazon Resource Name (ARN) of the instance profile.</p>', 'IamInstanceProfileSpecification$Name' => '<p>The name of the instance profile.</p>', 'IdFormat$Resource' => '<p>The type of resource.</p>', 'Image$ImageId' => '<p>The ID of the AMI.</p>', 'Image$ImageLocation' => '<p>The location of the AMI.</p>', 'Image$OwnerId' => '<p>The AWS account ID of the image owner.</p>', 'Image$CreationDate' => '<p>The date and time the image was created.</p>', 'Image$KernelId' => '<p>The kernel associated with the image, if any. Only applicable for machine images.</p>', 'Image$RamdiskId' => '<p>The RAM disk associated with the image, if any. Only applicable for machine images.</p>', 'Image$SriovNetSupport' => '<p>Specifies whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.</p>', 'Image$ImageOwnerAlias' => '<p>The AWS account alias (for example, <code>amazon</code>, <code>self</code>) or the AWS account ID of the AMI owner.</p>', 'Image$Name' => '<p>The name of the AMI that was provided during image creation.</p>', 'Image$Description' => '<p>The description of the AMI that was provided during image creation.</p>', 'Image$RootDeviceName' => '<p>The device name of the root device (for example, <code>/dev/sda1</code> or <code>/dev/xvda</code>).</p>', 'ImageAttribute$ImageId' => '<p>The ID of the AMI.</p>', 'ImageDiskContainer$Description' => '<p>The description of the disk image.</p>', 'ImageDiskContainer$Format' => '<p>The format of the disk image being imported.</p> <p>Valid values: <code>RAW</code> | <code>VHD</code> | <code>VMDK</code> | <code>OVA</code> </p>', 'ImageDiskContainer$Url' => '<p>The URL to the Amazon S3-based disk image being imported. The URL can either be a https URL (https://..) or an Amazon S3 URL (s3://..)</p>', 'ImageDiskContainer$DeviceName' => '<p>The block device mapping for the disk.</p>', 'ImageDiskContainer$SnapshotId' => '<p>The ID of the EBS snapshot to be used for importing the snapshot.</p>', 'ImageIdStringList$member' => NULL, 'ImportImageRequest$Description' => '<p>A description string for the import image task.</p>', 'ImportImageRequest$LicenseType' => '<p>The license type to be used for the Amazon Machine Image (AMI) after importing.</p> <p> <b>Note:</b> You may only use BYOL if you have existing licenses with rights to use these licenses in a third party cloud like AWS. For more information, see <a href="http://docs.aws.amazon.com/vm-import/latest/userguide/vmimport-image-import.html#prerequisites-image">Prerequisites</a> in the VM Import/Export User Guide.</p> <p>Valid values: <code>AWS</code> | <code>BYOL</code> </p>', 'ImportImageRequest$Hypervisor' => '<p>The target hypervisor platform.</p> <p>Valid values: <code>xen</code> </p>', 'ImportImageRequest$Architecture' => '<p>The architecture of the virtual machine.</p> <p>Valid values: <code>i386</code> | <code>x86_64</code> </p>', 'ImportImageRequest$Platform' => '<p>The operating system of the virtual machine.</p> <p>Valid values: <code>Windows</code> | <code>Linux</code> </p>', 'ImportImageRequest$ClientToken' => '<p>The token to enable idempotency for VM import requests.</p>', 'ImportImageRequest$RoleName' => '<p>The name of the role to use when not using the default role, \'vmimport\'.</p>', 'ImportImageResult$ImportTaskId' => '<p>The task ID of the import image task.</p>', 'ImportImageResult$Architecture' => '<p>The architecture of the virtual machine.</p>', 'ImportImageResult$LicenseType' => '<p>The license type of the virtual machine.</p>', 'ImportImageResult$Platform' => '<p>The operating system of the virtual machine.</p>', 'ImportImageResult$Hypervisor' => '<p>The target hypervisor of the import task.</p>', 'ImportImageResult$Description' => '<p>A description of the import task.</p>', 'ImportImageResult$ImageId' => '<p>The ID of the Amazon Machine Image (AMI) created by the import task.</p>', 'ImportImageResult$Progress' => '<p>The progress of the task.</p>', 'ImportImageResult$StatusMessage' => '<p>A detailed status message of the import task.</p>', 'ImportImageResult$Status' => '<p>A brief status of the task.</p>', 'ImportImageTask$ImportTaskId' => '<p>The ID of the import image task.</p>', 'ImportImageTask$Architecture' => '<p>The architecture of the virtual machine.</p> <p>Valid values: <code>i386</code> | <code>x86_64</code> </p>', 'ImportImageTask$LicenseType' => '<p>The license type of the virtual machine.</p>', 'ImportImageTask$Platform' => '<p>The description string for the import image task.</p>', 'ImportImageTask$Hypervisor' => '<p>The target hypervisor for the import task.</p> <p>Valid values: <code>xen</code> </p>', 'ImportImageTask$Description' => '<p>A description of the import task.</p>', 'ImportImageTask$ImageId' => '<p>The ID of the Amazon Machine Image (AMI) of the imported virtual machine.</p>', 'ImportImageTask$Progress' => '<p>The percentage of progress of the import image task.</p>', 'ImportImageTask$StatusMessage' => '<p>A descriptive status message for the import image task.</p>', 'ImportImageTask$Status' => '<p>A brief status for the import image task.</p>', 'ImportInstanceLaunchSpecification$AdditionalInfo' => '<p>Reserved.</p>', 'ImportInstanceLaunchSpecification$SubnetId' => '<p>[EC2-VPC] The ID of the subnet in which to launch the instance.</p>', 'ImportInstanceLaunchSpecification$PrivateIpAddress' => '<p>[EC2-VPC] An available IP address from the IP address range of the subnet.</p>', 'ImportInstanceRequest$Description' => '<p>A description for the instance being imported.</p>', 'ImportInstanceTaskDetails$InstanceId' => '<p>The ID of the instance.</p>', 'ImportInstanceTaskDetails$Description' => '<p>A description of the task.</p>', 'ImportInstanceVolumeDetailItem$AvailabilityZone' => '<p>The Availability Zone where the resulting instance will reside.</p>', 'ImportInstanceVolumeDetailItem$Status' => '<p>The status of the import of this particular disk image.</p>', 'ImportInstanceVolumeDetailItem$StatusMessage' => '<p>The status information or errors related to the disk image.</p>', 'ImportInstanceVolumeDetailItem$Description' => '<p>A description of the task.</p>', 'ImportKeyPairRequest$KeyName' => '<p>A unique name for the key pair.</p>', 'ImportKeyPairResult$KeyName' => '<p>The key pair name you provided.</p>', 'ImportKeyPairResult$KeyFingerprint' => '<p>The MD5 public key fingerprint as specified in section 4 of RFC 4716.</p>', 'ImportSnapshotRequest$Description' => '<p>The description string for the import snapshot task.</p>', 'ImportSnapshotRequest$ClientToken' => '<p>Token to enable idempotency for VM import requests.</p>', 'ImportSnapshotRequest$RoleName' => '<p>The name of the role to use when not using the default role, \'vmimport\'.</p>', 'ImportSnapshotResult$ImportTaskId' => '<p>The ID of the import snapshot task.</p>', 'ImportSnapshotResult$Description' => '<p>A description of the import snapshot task.</p>', 'ImportSnapshotTask$ImportTaskId' => '<p>The ID of the import snapshot task.</p>', 'ImportSnapshotTask$Description' => '<p>A description of the import snapshot task.</p>', 'ImportTaskIdList$member' => NULL, 'ImportVolumeRequest$AvailabilityZone' => '<p>The Availability Zone for the resulting EBS volume.</p>', 'ImportVolumeRequest$Description' => '<p>A description of the volume.</p>', 'ImportVolumeTaskDetails$AvailabilityZone' => '<p>The Availability Zone where the resulting volume will reside.</p>', 'ImportVolumeTaskDetails$Description' => '<p>The description you provided when starting the import volume task.</p>', 'Instance$InstanceId' => '<p>The ID of the instance.</p>', 'Instance$ImageId' => '<p>The ID of the AMI used to launch the instance.</p>', 'Instance$PrivateDnsName' => '<p>The private DNS name assigned to the instance. This DNS name can only be used inside the Amazon EC2 network. This name is not available until the instance enters the <code>running</code> state. For EC2-VPC, this name is only available if you\'ve enabled DNS hostnames for your VPC.</p>', 'Instance$PublicDnsName' => '<p>The public DNS name assigned to the instance. This name is not available until the instance enters the <code>running</code> state. For EC2-VPC, this name is only available if you\'ve enabled DNS hostnames for your VPC.</p>', 'Instance$StateTransitionReason' => '<p>The reason for the most recent state transition. This might be an empty string.</p>', 'Instance$KeyName' => '<p>The name of the key pair, if this instance was launched with an associated key pair.</p>', 'Instance$KernelId' => '<p>The kernel associated with this instance, if applicable.</p>', 'Instance$RamdiskId' => '<p>The RAM disk associated with this instance, if applicable.</p>', 'Instance$SubnetId' => '<p>[EC2-VPC] The ID of the subnet in which the instance is running.</p>', 'Instance$VpcId' => '<p>[EC2-VPC] The ID of the VPC in which the instance is running.</p>', 'Instance$PrivateIpAddress' => '<p>The private IP address assigned to the instance.</p>', 'Instance$PublicIpAddress' => '<p>The public IP address assigned to the instance, if applicable.</p>', 'Instance$RootDeviceName' => '<p>The root device name (for example, <code>/dev/sda1</code> or <code>/dev/xvda</code>).</p>', 'Instance$SpotInstanceRequestId' => '<p>If the request is a Spot instance request, the ID of the request.</p>', 'Instance$ClientToken' => '<p>The idempotency token you provided when you launched the instance, if applicable.</p>', 'Instance$SriovNetSupport' => '<p>Specifies whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.</p>', 'InstanceAttribute$InstanceId' => '<p>The ID of the instance.</p>', 'InstanceBlockDeviceMapping$DeviceName' => '<p>The device name exposed to the instance (for example, <code>/dev/sdh</code> or <code>xvdh</code>).</p>', 'InstanceBlockDeviceMappingSpecification$DeviceName' => '<p>The device name exposed to the instance (for example, <code>/dev/sdh</code> or <code>xvdh</code>).</p>', 'InstanceBlockDeviceMappingSpecification$VirtualName' => '<p>The virtual device name.</p>', 'InstanceBlockDeviceMappingSpecification$NoDevice' => '<p>suppress the specified device included in the block device mapping.</p>', 'InstanceCapacity$InstanceType' => '<p>The instance type size supported by the Dedicated Host.</p>', 'InstanceExportDetails$InstanceId' => '<p>The ID of the resource being exported.</p>', 'InstanceIdSet$member' => NULL, 'InstanceIdStringList$member' => NULL, 'InstanceMonitoring$InstanceId' => '<p>The ID of the instance.</p>', 'InstanceNetworkInterface$NetworkInterfaceId' => '<p>The ID of the network interface.</p>', 'InstanceNetworkInterface$SubnetId' => '<p>The ID of the subnet.</p>', 'InstanceNetworkInterface$VpcId' => '<p>The ID of the VPC.</p>', 'InstanceNetworkInterface$Description' => '<p>The description.</p>', 'InstanceNetworkInterface$OwnerId' => '<p>The ID of the AWS account that created the network interface.</p>', 'InstanceNetworkInterface$MacAddress' => '<p>The MAC address.</p>', 'InstanceNetworkInterface$PrivateIpAddress' => '<p>The IP address of the network interface within the subnet.</p>', 'InstanceNetworkInterface$PrivateDnsName' => '<p>The private DNS name.</p>', 'InstanceNetworkInterfaceAssociation$PublicIp' => '<p>The public IP address or Elastic IP address bound to the network interface.</p>', 'InstanceNetworkInterfaceAssociation$PublicDnsName' => '<p>The public DNS name.</p>', 'InstanceNetworkInterfaceAssociation$IpOwnerId' => '<p>The ID of the owner of the Elastic IP address.</p>', 'InstanceNetworkInterfaceAttachment$AttachmentId' => '<p>The ID of the network interface attachment.</p>', 'InstanceNetworkInterfaceSpecification$NetworkInterfaceId' => '<p>The ID of the network interface.</p>', 'InstanceNetworkInterfaceSpecification$SubnetId' => '<p>The ID of the subnet associated with the network string. Applies only if creating a network interface when launching an instance.</p>', 'InstanceNetworkInterfaceSpecification$Description' => '<p>The description of the network interface. Applies only if creating a network interface when launching an instance.</p>', 'InstanceNetworkInterfaceSpecification$PrivateIpAddress' => '<p>The private IP address of the network interface. Applies only if creating a network interface when launching an instance. You cannot specify this option if you\'re launching more than one instance in a <a>RunInstances</a> request.</p>', 'InstancePrivateIpAddress$PrivateIpAddress' => '<p>The private IP address of the network interface.</p>', 'InstancePrivateIpAddress$PrivateDnsName' => '<p>The private DNS name.</p>', 'InstanceStateChange$InstanceId' => '<p>The ID of the instance.</p>', 'InstanceStatus$InstanceId' => '<p>The ID of the instance.</p>', 'InstanceStatus$AvailabilityZone' => '<p>The Availability Zone of the instance.</p>', 'InstanceStatusEvent$Description' => '<p>A description of the event.</p> <p>After a scheduled event is completed, it can still be described for up to a week. If the event has been completed, this description starts with the following text: [Completed].</p>', 'InternetGateway$InternetGatewayId' => '<p>The ID of the Internet gateway.</p>', 'InternetGatewayAttachment$VpcId' => '<p>The ID of the VPC.</p>', 'IpPermission$IpProtocol' => '<p>The IP protocol name (for <code>tcp</code>, <code>udp</code>, and <code>icmp</code>) or number (see <a href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a>). </p> <p>[EC2-VPC only] When you authorize or revoke security group rules, you can use <code>-1</code> to specify all.</p>', 'IpRange$CidrIp' => '<p>The CIDR range. You can either specify a CIDR range or a source security group, not both.</p>', 'IpRanges$member' => NULL, 'KeyNameStringList$member' => NULL, 'KeyPair$KeyName' => '<p>The name of the key pair.</p>', 'KeyPair$KeyFingerprint' => '<p>The SHA-1 digest of the DER encoded private key.</p>', 'KeyPair$KeyMaterial' => '<p>An unencrypted PEM encoded RSA private key.</p>', 'KeyPairInfo$KeyName' => '<p>The name of the key pair.</p>', 'KeyPairInfo$KeyFingerprint' => '<p>If you used <a>CreateKeyPair</a> to create the key pair, this is the SHA-1 digest of the DER encoded private key. If you used <a>ImportKeyPair</a> to provide AWS the public key, this is the MD5 public key fingerprint as specified in section 4 of RFC4716.</p>', 'LaunchPermission$UserId' => '<p>The AWS account ID.</p>', 'LaunchSpecification$ImageId' => '<p>The ID of the AMI.</p>', 'LaunchSpecification$KeyName' => '<p>The name of the key pair.</p>', 'LaunchSpecification$UserData' => '<p>The user data to make available to the instances. If you are using an AWS SDK or command line tool, Base64-encoding is performed for you, and you can load the text from a file. Otherwise, you must provide Base64-encoded text.</p>', 'LaunchSpecification$AddressingType' => '<p>Deprecated.</p>', 'LaunchSpecification$KernelId' => '<p>The ID of the kernel.</p>', 'LaunchSpecification$RamdiskId' => '<p>The ID of the RAM disk.</p>', 'LaunchSpecification$SubnetId' => '<p>The ID of the subnet in which to launch the instance.</p>', 'ModifyIdFormatRequest$Resource' => '<p>The type of resource: <code>instance</code> | <code>reservation</code> | <code>snapshot</code> | <code>volume</code> </p>', 'ModifyIdentityIdFormatRequest$Resource' => '<p>The type of resource: <code>instance</code> | <code>reservation</code> | <code>snapshot</code> | <code>volume</code> </p>', 'ModifyIdentityIdFormatRequest$PrincipalArn' => '<p>The ARN of the principal, which can be an IAM user, IAM role, or the root user. Specify <code>all</code> to modify the ID format for all IAM users, IAM roles, and the root user of the account.</p>', 'ModifyImageAttributeRequest$ImageId' => '<p>The ID of the AMI.</p>', 'ModifyImageAttributeRequest$Attribute' => '<p>The name of the attribute to modify.</p>', 'ModifyImageAttributeRequest$Value' => '<p>The value of the attribute being modified. This is only valid when modifying the <code>description</code> attribute.</p>', 'ModifyInstanceAttributeRequest$InstanceId' => '<p>The ID of the instance.</p>', 'ModifyInstanceAttributeRequest$Value' => '<p>A new value for the attribute. Use only with the <code>kernel</code>, <code>ramdisk</code>, <code>userData</code>, <code>disableApiTermination</code>, or <code>instanceInitiatedShutdownBehavior</code> attribute.</p>', 'ModifyInstancePlacementRequest$InstanceId' => '<p>The ID of the instance that you are modifying.</p>', 'ModifyInstancePlacementRequest$HostId' => '<p>The ID of the Dedicated Host that the instance will have affinity with.</p>', 'ModifyNetworkInterfaceAttributeRequest$NetworkInterfaceId' => '<p>The ID of the network interface.</p>', 'ModifyReservedInstancesRequest$ClientToken' => '<p>A unique, case-sensitive token you provide to ensure idempotency of your modification request. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>', 'ModifyReservedInstancesResult$ReservedInstancesModificationId' => '<p>The ID for the modification.</p>', 'ModifySnapshotAttributeRequest$SnapshotId' => '<p>The ID of the snapshot.</p>', 'ModifySpotFleetRequestRequest$SpotFleetRequestId' => '<p>The ID of the Spot fleet request.</p>', 'ModifySubnetAttributeRequest$SubnetId' => '<p>The ID of the subnet.</p>', 'ModifyVolumeAttributeRequest$VolumeId' => '<p>The ID of the volume.</p>', 'ModifyVpcAttributeRequest$VpcId' => '<p>The ID of the VPC.</p>', 'ModifyVpcEndpointRequest$VpcEndpointId' => '<p>The ID of the endpoint.</p>', 'ModifyVpcEndpointRequest$PolicyDocument' => '<p>A policy document to attach to the endpoint. The policy must be in valid JSON format.</p>', 'ModifyVpcPeeringConnectionOptionsRequest$VpcPeeringConnectionId' => '<p>The ID of the VPC peering connection.</p>', 'MoveAddressToVpcRequest$PublicIp' => '<p>The Elastic IP address.</p>', 'MoveAddressToVpcResult$AllocationId' => '<p>The allocation ID for the Elastic IP address.</p>', 'MovingAddressStatus$PublicIp' => '<p>The Elastic IP address.</p>', 'NatGateway$VpcId' => '<p>The ID of the VPC in which the NAT gateway is located.</p>', 'NatGateway$SubnetId' => '<p>The ID of the subnet in which the NAT gateway is located.</p>', 'NatGateway$NatGatewayId' => '<p>The ID of the NAT gateway.</p>', 'NatGateway$FailureCode' => '<p>If the NAT gateway could not be created, specifies the error code for the failure. (<code>InsufficientFreeAddressesInSubnet</code> | <code>Gateway.NotAttached</code> | <code>InvalidAllocationID.NotFound</code> | <code>Resource.AlreadyAssociated</code> | <code>InternalError</code> | <code>InvalidSubnetID.NotFound</code>)</p>', 'NatGateway$FailureMessage' => '<p>If the NAT gateway could not be created, specifies the error message for the failure, that corresponds to the error code.</p> <ul> <li> <p>For InsufficientFreeAddressesInSubnet: "Subnet has insufficient free addresses to create this NAT gateway"</p> </li> <li> <p>For Gateway.NotAttached: "Network vpc-xxxxxxxx has no Internet gateway attached"</p> </li> <li> <p>For InvalidAllocationID.NotFound: "Elastic IP address eipalloc-xxxxxxxx could not be associated with this NAT gateway"</p> </li> <li> <p>For Resource.AlreadyAssociated: "Elastic IP address eipalloc-xxxxxxxx is already associated"</p> </li> <li> <p>For InternalError: "Network interface eni-xxxxxxxx, created and used internally by this NAT gateway is in an invalid state. Please try again."</p> </li> <li> <p>For InvalidSubnetID.NotFound: "The specified subnet subnet-xxxxxxxx does not exist or could not be found."</p> </li> </ul>', 'NatGatewayAddress$PublicIp' => '<p>The Elastic IP address associated with the NAT gateway.</p>', 'NatGatewayAddress$AllocationId' => '<p>The allocation ID of the Elastic IP address that\'s associated with the NAT gateway.</p>', 'NatGatewayAddress$PrivateIp' => '<p>The private IP address associated with the Elastic IP address.</p>', 'NatGatewayAddress$NetworkInterfaceId' => '<p>The ID of the network interface associated with the NAT gateway.</p>', 'NetworkAcl$NetworkAclId' => '<p>The ID of the network ACL.</p>', 'NetworkAcl$VpcId' => '<p>The ID of the VPC for the network ACL.</p>', 'NetworkAclAssociation$NetworkAclAssociationId' => '<p>The ID of the association between a network ACL and a subnet.</p>', 'NetworkAclAssociation$NetworkAclId' => '<p>The ID of the network ACL.</p>', 'NetworkAclAssociation$SubnetId' => '<p>The ID of the subnet.</p>', 'NetworkAclEntry$Protocol' => '<p>The protocol. A value of <code>-1</code> means all protocols.</p>', 'NetworkAclEntry$CidrBlock' => '<p>The network range to allow or deny, in CIDR notation.</p>', 'NetworkInterface$NetworkInterfaceId' => '<p>The ID of the network interface.</p>', 'NetworkInterface$SubnetId' => '<p>The ID of the subnet.</p>', 'NetworkInterface$VpcId' => '<p>The ID of the VPC.</p>', 'NetworkInterface$AvailabilityZone' => '<p>The Availability Zone.</p>', 'NetworkInterface$Description' => '<p>A description.</p>', 'NetworkInterface$OwnerId' => '<p>The AWS account ID of the owner of the network interface.</p>', 'NetworkInterface$RequesterId' => '<p>The ID of the entity that launched the instance on your behalf (for example, AWS Management Console or Auto Scaling).</p>', 'NetworkInterface$MacAddress' => '<p>The MAC address.</p>', 'NetworkInterface$PrivateIpAddress' => '<p>The IP address of the network interface within the subnet.</p>', 'NetworkInterface$PrivateDnsName' => '<p>The private DNS name.</p>', 'NetworkInterfaceAssociation$PublicIp' => '<p>The address of the Elastic IP address bound to the network interface.</p>', 'NetworkInterfaceAssociation$PublicDnsName' => '<p>The public DNS name.</p>', 'NetworkInterfaceAssociation$IpOwnerId' => '<p>The ID of the Elastic IP address owner.</p>', 'NetworkInterfaceAssociation$AllocationId' => '<p>The allocation ID.</p>', 'NetworkInterfaceAssociation$AssociationId' => '<p>The association ID.</p>', 'NetworkInterfaceAttachment$AttachmentId' => '<p>The ID of the network interface attachment.</p>', 'NetworkInterfaceAttachment$InstanceId' => '<p>The ID of the instance.</p>', 'NetworkInterfaceAttachment$InstanceOwnerId' => '<p>The AWS account ID of the owner of the instance.</p>', 'NetworkInterfaceAttachmentChanges$AttachmentId' => '<p>The ID of the network interface attachment.</p>', 'NetworkInterfaceIdList$member' => NULL, 'NetworkInterfacePrivateIpAddress$PrivateIpAddress' => '<p>The private IP address.</p>', 'NetworkInterfacePrivateIpAddress$PrivateDnsName' => '<p>The private DNS name.</p>', 'NewDhcpConfiguration$Key' => NULL, 'OwnerStringList$member' => NULL, 'Placement$AvailabilityZone' => '<p>The Availability Zone of the instance.</p>', 'Placement$GroupName' => '<p>The name of the placement group the instance is in (for cluster compute instances).</p>', 'Placement$HostId' => '<p>The ID of the Dedicted host on which the instance resides. This parameter is not support for the <a>ImportInstance</a> command.</p>', 'Placement$Affinity' => '<p>The affinity setting for the instance on the Dedicated Host. This parameter is not supported for the <a>ImportInstance</a> command.</p>', 'PlacementGroup$GroupName' => '<p>The name of the placement group.</p>', 'PlacementGroupStringList$member' => NULL, 'PrefixList$PrefixListId' => '<p>The ID of the prefix.</p>', 'PrefixList$PrefixListName' => '<p>The name of the prefix.</p>', 'PrefixListId$PrefixListId' => '<p>The ID of the prefix.</p>', 'PrefixListIdSet$member' => NULL, 'PrivateIpAddressSpecification$PrivateIpAddress' => '<p>The private IP addresses.</p>', 'PrivateIpAddressStringList$member' => NULL, 'ProductCode$ProductCodeId' => '<p>The product code.</p>', 'ProductCodeStringList$member' => NULL, 'ProductDescriptionList$member' => NULL, 'PropagatingVgw$GatewayId' => '<p>The ID of the virtual private gateway (VGW).</p>', 'ProvisionedBandwidth$Provisioned' => '<p>Reserved. If you need to sustain traffic greater than the <a href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/vpc-nat-gateway.html">documented limits</a>, contact us through the <a href="https://console.aws.amazon.com/support/home?">Support Center</a>.</p>', 'ProvisionedBandwidth$Requested' => '<p>Reserved. If you need to sustain traffic greater than the <a href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/vpc-nat-gateway.html">documented limits</a>, contact us through the <a href="https://console.aws.amazon.com/support/home?">Support Center</a>.</p>', 'ProvisionedBandwidth$Status' => '<p>Reserved. If you need to sustain traffic greater than the <a href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/vpc-nat-gateway.html">documented limits</a>, contact us through the <a href="https://console.aws.amazon.com/support/home?">Support Center</a>.</p>', 'PublicIpStringList$member' => NULL, 'Purchase$HostReservationId' => '<p>The ID of the reservation.</p>', 'Purchase$InstanceFamily' => '<p>The instance family on the Dedicated Host that the reservation can be associated with.</p>', 'Purchase$UpfrontPrice' => '<p>The upfront price of the reservation.</p>', 'Purchase$HourlyPrice' => '<p>The hourly price of the reservation per hour.</p>', 'PurchaseHostReservationRequest$OfferingId' => '<p>The ID of the offering.</p>', 'PurchaseHostReservationRequest$LimitPrice' => '<p>The specified limit is checked against the total upfront cost of the reservation (calculated as the offering\'s upfront cost multiplied by the host count). If the total upfront cost is greater than the specified price limit, the request will fail. This is used to ensure that the purchase does not exceed the expected upfront cost of the purchase. At this time, the only supported currency is <code>USD</code>. For example, to indicate a limit price of USD 100, specify 100.00.</p>', 'PurchaseHostReservationRequest$ClientToken' => '<p>Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure Idempotency</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'PurchaseHostReservationResult$TotalUpfrontPrice' => '<p>The total amount that will be charged to your account when you purchase the reservation.</p>', 'PurchaseHostReservationResult$TotalHourlyPrice' => '<p>The total hourly price of the reservation calculated per hour.</p>', 'PurchaseHostReservationResult$ClientToken' => '<p>Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure Idempotency</a> in the <i>Amazon Elastic Compute Cloud User Guide</i> </p>', 'PurchaseRequest$PurchaseToken' => '<p>The purchase token.</p>', 'PurchaseReservedInstancesOfferingRequest$ReservedInstancesOfferingId' => '<p>The ID of the Reserved Instance offering to purchase.</p>', 'PurchaseReservedInstancesOfferingResult$ReservedInstancesId' => '<p>The IDs of the purchased Reserved Instances.</p>', 'PurchaseScheduledInstancesRequest$ClientToken' => '<p>Unique, case-sensitive identifier that ensures the idempotency of the request. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>', 'Region$RegionName' => '<p>The name of the region.</p>', 'Region$Endpoint' => '<p>The region service endpoint.</p>', 'RegionNameStringList$member' => NULL, 'RegisterImageRequest$ImageLocation' => '<p>The full path to your AMI manifest in Amazon S3 storage.</p>', 'RegisterImageRequest$Name' => '<p>A name for your AMI.</p> <p>Constraints: 3-128 alphanumeric characters, parentheses (()), square brackets ([]), spaces ( ), periods (.), slashes (/), dashes (-), single quotes (\'), at-signs (@), or underscores(_)</p>', 'RegisterImageRequest$Description' => '<p>A description for your AMI.</p>', 'RegisterImageRequest$KernelId' => '<p>The ID of the kernel.</p>', 'RegisterImageRequest$RamdiskId' => '<p>The ID of the RAM disk.</p>', 'RegisterImageRequest$RootDeviceName' => '<p>The name of the root device (for example, <code>/dev/sda1</code>, or <code>/dev/xvda</code>).</p>', 'RegisterImageRequest$VirtualizationType' => '<p>The type of virtualization.</p> <p>Default: <code>paravirtual</code> </p>', 'RegisterImageRequest$SriovNetSupport' => '<p>Set to <code>simple</code> to enable enhanced networking with the Intel 82599 Virtual Function interface for the AMI and any instances that you launch from the AMI.</p> <p>There is no way to disable <code>sriovNetSupport</code> at this time.</p> <p>This option is supported only for HVM AMIs. Specifying this option with a PV AMI can make instances launched from the AMI unreachable.</p>', 'RegisterImageResult$ImageId' => '<p>The ID of the newly registered AMI.</p>', 'RejectVpcPeeringConnectionRequest$VpcPeeringConnectionId' => '<p>The ID of the VPC peering connection.</p>', 'ReleaseAddressRequest$PublicIp' => '<p>[EC2-Classic] The Elastic IP address. Required for EC2-Classic.</p>', 'ReleaseAddressRequest$AllocationId' => '<p>[EC2-VPC] The allocation ID. Required for EC2-VPC.</p>', 'ReplaceNetworkAclAssociationRequest$AssociationId' => '<p>The ID of the current association between the original network ACL and the subnet.</p>', 'ReplaceNetworkAclAssociationRequest$NetworkAclId' => '<p>The ID of the new network ACL to associate with the subnet.</p>', 'ReplaceNetworkAclAssociationResult$NewAssociationId' => '<p>The ID of the new association.</p>', 'ReplaceNetworkAclEntryRequest$NetworkAclId' => '<p>The ID of the ACL.</p>', 'ReplaceNetworkAclEntryRequest$Protocol' => '<p>The IP protocol. You can specify <code>all</code> or <code>-1</code> to mean all protocols.</p>', 'ReplaceNetworkAclEntryRequest$CidrBlock' => '<p>The network range to allow or deny, in CIDR notation.</p>', 'ReplaceRouteRequest$RouteTableId' => '<p>The ID of the route table.</p>', 'ReplaceRouteRequest$DestinationCidrBlock' => '<p>The CIDR address block used for the destination match. The value you provide must match the CIDR of an existing route in the table.</p>', 'ReplaceRouteRequest$GatewayId' => '<p>The ID of an Internet gateway or virtual private gateway.</p>', 'ReplaceRouteRequest$InstanceId' => '<p>The ID of a NAT instance in your VPC.</p>', 'ReplaceRouteRequest$NetworkInterfaceId' => '<p>The ID of a network interface.</p>', 'ReplaceRouteRequest$VpcPeeringConnectionId' => '<p>The ID of a VPC peering connection.</p>', 'ReplaceRouteRequest$NatGatewayId' => '<p>The ID of a NAT gateway.</p>', 'ReplaceRouteTableAssociationRequest$AssociationId' => '<p>The association ID.</p>', 'ReplaceRouteTableAssociationRequest$RouteTableId' => '<p>The ID of the new route table to associate with the subnet.</p>', 'ReplaceRouteTableAssociationResult$NewAssociationId' => '<p>The ID of the new association.</p>', 'ReportInstanceStatusRequest$Description' => '<p>Descriptive text about the health state of your instance.</p>', 'RequestHostIdList$member' => NULL, 'RequestHostIdSet$member' => NULL, 'RequestSpotFleetResponse$SpotFleetRequestId' => '<p>The ID of the Spot fleet request.</p>', 'RequestSpotInstancesRequest$SpotPrice' => '<p>The maximum hourly price (bid) for any Spot instance launched to fulfill the request.</p>', 'RequestSpotInstancesRequest$ClientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure Idempotency</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'RequestSpotInstancesRequest$LaunchGroup' => '<p>The instance launch group. Launch groups are Spot instances that launch together and terminate together.</p> <p>Default: Instances are launched and terminated individually</p>', 'RequestSpotInstancesRequest$AvailabilityZoneGroup' => '<p>The user-specified name for a logical grouping of bids.</p> <p>When you specify an Availability Zone group in a Spot Instance request, all Spot instances in the request are launched in the same Availability Zone. Instance proximity is maintained with this parameter, but the choice of Availability Zone is not. The group applies only to bids for Spot Instances of the same instance type. Any additional Spot instance requests that are specified with the same Availability Zone group name are launched in that same Availability Zone, as long as at least one instance from the group is still active.</p> <p>If there is no active instance running in the Availability Zone group that you specify for a new Spot instance request (all instances are terminated, the bid is expired, or the bid falls below current market), then Amazon EC2 launches the instance in any Availability Zone where the constraint can be met. Consequently, the subsequent set of Spot instances could be placed in a different zone from the original request, even if you specified the same Availability Zone group.</p> <p>Default: Instances are launched in any available Availability Zone.</p>', 'RequestSpotLaunchSpecification$ImageId' => '<p>The ID of the AMI.</p>', 'RequestSpotLaunchSpecification$KeyName' => '<p>The name of the key pair.</p>', 'RequestSpotLaunchSpecification$UserData' => '<p>The user data to make available to the instances. If you are using an AWS SDK or command line tool, Base64-encoding is performed for you, and you can load the text from a file. Otherwise, you must provide Base64-encoded text.</p>', 'RequestSpotLaunchSpecification$AddressingType' => '<p>Deprecated.</p>', 'RequestSpotLaunchSpecification$KernelId' => '<p>The ID of the kernel.</p>', 'RequestSpotLaunchSpecification$RamdiskId' => '<p>The ID of the RAM disk.</p>', 'RequestSpotLaunchSpecification$SubnetId' => '<p>The ID of the subnet in which to launch the instance.</p>', 'Reservation$ReservationId' => '<p>The ID of the reservation.</p>', 'Reservation$OwnerId' => '<p>The ID of the AWS account that owns the reservation.</p>', 'Reservation$RequesterId' => '<p>The ID of the requester that launched the instances on your behalf (for example, AWS Management Console or Auto Scaling).</p>', 'ReservationValue$RemainingTotalValue' => '<p>The balance of the total value (the sum of remainingUpfrontValue + hourlyPrice * number of hours remaining).</p>', 'ReservationValue$RemainingUpfrontValue' => '<p>The remaining upfront cost of the reservation.</p>', 'ReservationValue$HourlyPrice' => '<p>The hourly rate of the reservation.</p>', 'ReservedInstanceIdSet$member' => NULL, 'ReservedInstanceReservationValue$ReservedInstanceId' => '<p>The ID of the Convertible Reserved Instance that you are exchanging.</p>', 'ReservedInstances$ReservedInstancesId' => '<p>The ID of the Reserved Instance.</p>', 'ReservedInstances$AvailabilityZone' => '<p>The Availability Zone in which the Reserved Instance can be used.</p>', 'ReservedInstancesConfiguration$AvailabilityZone' => '<p>The Availability Zone for the modified Reserved Instances.</p>', 'ReservedInstancesConfiguration$Platform' => '<p>The network platform of the modified Reserved Instances, which is either EC2-Classic or EC2-VPC.</p>', 'ReservedInstancesId$ReservedInstancesId' => '<p>The ID of the Reserved Instance.</p>', 'ReservedInstancesIdStringList$member' => NULL, 'ReservedInstancesListing$ReservedInstancesListingId' => '<p>The ID of the Reserved Instance listing.</p>', 'ReservedInstancesListing$ReservedInstancesId' => '<p>The ID of the Reserved Instance.</p>', 'ReservedInstancesListing$StatusMessage' => '<p>The reason for the current status of the Reserved Instance listing. The response can be blank.</p>', 'ReservedInstancesListing$ClientToken' => '<p>A unique, case-sensitive key supplied by the client to ensure that the request is idempotent. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>', 'ReservedInstancesModification$ReservedInstancesModificationId' => '<p>A unique ID for the Reserved Instance modification.</p>', 'ReservedInstancesModification$Status' => '<p>The status of the Reserved Instances modification request.</p>', 'ReservedInstancesModification$StatusMessage' => '<p>The reason for the status.</p>', 'ReservedInstancesModification$ClientToken' => '<p>A unique, case-sensitive key supplied by the client to ensure that the request is idempotent. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>', 'ReservedInstancesModificationIdStringList$member' => NULL, 'ReservedInstancesModificationResult$ReservedInstancesId' => '<p>The ID for the Reserved Instances that were created as part of the modification request. This field is only available when the modification is fulfilled.</p>', 'ReservedInstancesOffering$ReservedInstancesOfferingId' => '<p>The ID of the Reserved Instance offering. This is the offering ID used in <a>GetReservedInstancesExchangeQuote</a> to confirm that an exchange can be made.</p>', 'ReservedInstancesOffering$AvailabilityZone' => '<p>The Availability Zone in which the Reserved Instance can be used.</p>', 'ReservedInstancesOfferingIdStringList$member' => NULL, 'ResetImageAttributeRequest$ImageId' => '<p>The ID of the AMI.</p>', 'ResetInstanceAttributeRequest$InstanceId' => '<p>The ID of the instance.</p>', 'ResetNetworkInterfaceAttributeRequest$NetworkInterfaceId' => '<p>The ID of the network interface.</p>', 'ResetNetworkInterfaceAttributeRequest$SourceDestCheck' => '<p>The source/destination checking attribute. Resets the value to <code>true</code>.</p>', 'ResetSnapshotAttributeRequest$SnapshotId' => '<p>The ID of the snapshot.</p>', 'ResourceIdList$member' => NULL, 'ResponseHostIdList$member' => NULL, 'ResponseHostIdSet$member' => NULL, 'RestorableByStringList$member' => NULL, 'RestoreAddressToClassicRequest$PublicIp' => '<p>The Elastic IP address.</p>', 'RestoreAddressToClassicResult$PublicIp' => '<p>The Elastic IP address.</p>', 'RevokeSecurityGroupEgressRequest$GroupId' => '<p>The ID of the security group.</p>', 'RevokeSecurityGroupEgressRequest$SourceSecurityGroupName' => '<p>The name of a destination security group. To revoke outbound access to a destination security group, we recommend that you use a set of IP permissions instead.</p>', 'RevokeSecurityGroupEgressRequest$SourceSecurityGroupOwnerId' => '<p>The AWS account number for a destination security group. To revoke outbound access to a destination security group, we recommend that you use a set of IP permissions instead.</p>', 'RevokeSecurityGroupEgressRequest$IpProtocol' => '<p>The IP protocol name or number. We recommend that you specify the protocol in a set of IP permissions instead.</p>', 'RevokeSecurityGroupEgressRequest$CidrIp' => '<p>The CIDR IP address range. We recommend that you specify the CIDR range in a set of IP permissions instead.</p>', 'RevokeSecurityGroupIngressRequest$GroupName' => '<p>[EC2-Classic, default VPC] The name of the security group.</p>', 'RevokeSecurityGroupIngressRequest$GroupId' => '<p>The ID of the security group. Required for a security group in a nondefault VPC.</p>', 'RevokeSecurityGroupIngressRequest$SourceSecurityGroupName' => '<p>[EC2-Classic, default VPC] The name of the source security group. You can\'t specify this parameter in combination with the following parameters: the CIDR IP address range, the start of the port range, the IP protocol, and the end of the port range. For EC2-VPC, the source security group must be in the same VPC. To revoke a specific rule for an IP protocol and port range, use a set of IP permissions instead.</p>', 'RevokeSecurityGroupIngressRequest$SourceSecurityGroupOwnerId' => '<p>[EC2-Classic] The AWS account ID of the source security group, if the source security group is in a different account. You can\'t specify this parameter in combination with the following parameters: the CIDR IP address range, the IP protocol, the start of the port range, and the end of the port range. To revoke a specific rule for an IP protocol and port range, use a set of IP permissions instead.</p>', 'RevokeSecurityGroupIngressRequest$IpProtocol' => '<p>The IP protocol name (<code>tcp</code>, <code>udp</code>, <code>icmp</code>) or number (see <a href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a>). Use <code>-1</code> to specify all.</p>', 'RevokeSecurityGroupIngressRequest$CidrIp' => '<p>The CIDR IP address range. You can\'t specify this parameter when specifying a source security group.</p>', 'Route$DestinationCidrBlock' => '<p>The CIDR block used for the destination match.</p>', 'Route$DestinationPrefixListId' => '<p>The prefix of the AWS service.</p>', 'Route$GatewayId' => '<p>The ID of a gateway attached to your VPC.</p>', 'Route$InstanceId' => '<p>The ID of a NAT instance in your VPC.</p>', 'Route$InstanceOwnerId' => '<p>The AWS account ID of the owner of the instance.</p>', 'Route$NetworkInterfaceId' => '<p>The ID of the network interface.</p>', 'Route$VpcPeeringConnectionId' => '<p>The ID of the VPC peering connection.</p>', 'Route$NatGatewayId' => '<p>The ID of a NAT gateway.</p>', 'RouteTable$RouteTableId' => '<p>The ID of the route table.</p>', 'RouteTable$VpcId' => '<p>The ID of the VPC.</p>', 'RouteTableAssociation$RouteTableAssociationId' => '<p>The ID of the association between a route table and a subnet.</p>', 'RouteTableAssociation$RouteTableId' => '<p>The ID of the route table.</p>', 'RouteTableAssociation$SubnetId' => '<p>The ID of the subnet. A subnet ID is not returned for an implicit association.</p>', 'RunInstancesRequest$ImageId' => '<p>The ID of the AMI, which you can get by calling <a>DescribeImages</a>.</p>', 'RunInstancesRequest$KeyName' => '<p>The name of the key pair. You can create a key pair using <a>CreateKeyPair</a> or <a>ImportKeyPair</a>.</p> <important> <p>If you do not specify a key pair, you can\'t connect to the instance unless you choose an AMI that is configured to allow users another way to log in.</p> </important>', 'RunInstancesRequest$UserData' => '<p>The user data to make available to the instance. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/user-data.html">Running Commands on Your Linux Instance at Launch</a> (Linux) and <a href="http://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-instance-metadata.html#instancedata-add-user-data">Adding User Data</a> (Windows). If you are using an AWS SDK or command line tool, Base64-encoding is performed for you, and you can load the text from a file. Otherwise, you must provide Base64-encoded text.</p>', 'RunInstancesRequest$KernelId' => '<p>The ID of the kernel.</p> <important> <p>We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html"> PV-GRUB</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> </important>', 'RunInstancesRequest$RamdiskId' => '<p>The ID of the RAM disk.</p> <important> <p>We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html"> PV-GRUB</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> </important>', 'RunInstancesRequest$SubnetId' => '<p>[EC2-VPC] The ID of the subnet to launch the instance into.</p>', 'RunInstancesRequest$PrivateIpAddress' => '<p>[EC2-VPC] The primary IP address. You must specify a value from the IP address range of the subnet.</p> <p>Only one private IP address can be designated as primary. Therefore, you can\'t specify this parameter if <code>PrivateIpAddresses.n.Primary</code> is set to <code>true</code> and <code>PrivateIpAddresses.n.PrivateIpAddress</code> is set to an IP address. </p> <p>You cannot specify this option if you\'re launching more than one instance in the request.</p> <p>Default: We select an IP address from the IP address range of the subnet.</p>', 'RunInstancesRequest$ClientToken' => '<p>Unique, case-sensitive identifier you provide to ensure the idempotency of the request. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p> <p>Constraints: Maximum 64 ASCII characters</p>', 'RunInstancesRequest$AdditionalInfo' => '<p>Reserved.</p>', 'RunScheduledInstancesRequest$ClientToken' => '<p>Unique, case-sensitive identifier that ensures the idempotency of the request. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>', 'RunScheduledInstancesRequest$ScheduledInstanceId' => '<p>The Scheduled Instance ID.</p>', 'S3Storage$Bucket' => '<p>The bucket in which to store the AMI. You can specify a bucket that you already own or a new bucket that Amazon EC2 creates on your behalf. If you specify a bucket that belongs to someone else, Amazon EC2 returns an error.</p>', 'S3Storage$Prefix' => '<p>The beginning of the file name of the AMI.</p>', 'S3Storage$AWSAccessKeyId' => '<p>The access key ID of the owner of the bucket. Before you specify a value for your access key ID, review and follow the guidance in <a href="http://docs.aws.amazon.com/general/latest/gr/aws-access-keys-best-practices.html">Best Practices for Managing AWS Access Keys</a>.</p>', 'S3Storage$UploadPolicySignature' => '<p>The signature of the JSON document.</p>', 'ScheduledInstance$ScheduledInstanceId' => '<p>The Scheduled Instance ID.</p>', 'ScheduledInstance$InstanceType' => '<p>The instance type.</p>', 'ScheduledInstance$Platform' => '<p>The platform (<code>Linux/UNIX</code> or <code>Windows</code>).</p>', 'ScheduledInstance$NetworkPlatform' => '<p>The network platform (<code>EC2-Classic</code> or <code>EC2-VPC</code>).</p>', 'ScheduledInstance$AvailabilityZone' => '<p>The Availability Zone.</p>', 'ScheduledInstance$HourlyPrice' => '<p>The hourly price for a single instance.</p>', 'ScheduledInstanceAvailability$InstanceType' => '<p>The instance type. You can specify one of the C3, C4, M4, or R3 instance types.</p>', 'ScheduledInstanceAvailability$Platform' => '<p>The platform (<code>Linux/UNIX</code> or <code>Windows</code>).</p>', 'ScheduledInstanceAvailability$NetworkPlatform' => '<p>The network platform (<code>EC2-Classic</code> or <code>EC2-VPC</code>).</p>', 'ScheduledInstanceAvailability$AvailabilityZone' => '<p>The Availability Zone.</p>', 'ScheduledInstanceAvailability$PurchaseToken' => '<p>The purchase token. This token expires in two hours.</p>', 'ScheduledInstanceAvailability$HourlyPrice' => '<p>The hourly price for a single instance.</p>', 'ScheduledInstanceIdRequestSet$member' => NULL, 'ScheduledInstanceRecurrence$Frequency' => '<p>The frequency (<code>Daily</code>, <code>Weekly</code>, or <code>Monthly</code>).</p>', 'ScheduledInstanceRecurrence$OccurrenceUnit' => '<p>The unit for <code>occurrenceDaySet</code> (<code>DayOfWeek</code> or <code>DayOfMonth</code>).</p>', 'ScheduledInstanceRecurrenceRequest$Frequency' => '<p>The frequency (<code>Daily</code>, <code>Weekly</code>, or <code>Monthly</code>).</p>', 'ScheduledInstanceRecurrenceRequest$OccurrenceUnit' => '<p>The unit for <code>OccurrenceDays</code> (<code>DayOfWeek</code> or <code>DayOfMonth</code>). This value is required for a monthly schedule. You can\'t specify <code>DayOfWeek</code> with a weekly schedule. You can\'t specify this value with a daily schedule.</p>', 'ScheduledInstancesBlockDeviceMapping$DeviceName' => '<p>The device name exposed to the instance (for example, <code>/dev/sdh</code> or <code>xvdh</code>).</p>', 'ScheduledInstancesBlockDeviceMapping$NoDevice' => '<p>Suppresses the specified device included in the block device mapping of the AMI.</p>', 'ScheduledInstancesBlockDeviceMapping$VirtualName' => '<p>The virtual device name (<code>ephemeral</code>N). Instance store volumes are numbered starting from 0. An instance type with two available instance store volumes can specify mappings for <code>ephemeral0</code> and <code>ephemeral1</code>.The number of available instance store volumes depends on the instance type. After you connect to the instance, you must mount the volume.</p> <p>Constraints: For M3 instances, you must specify instance store volumes in the block device mapping for the instance. When you launch an M3 instance, we ignore any instance store volumes specified in the block device mapping for the AMI.</p>', 'ScheduledInstancesEbs$SnapshotId' => '<p>The ID of the snapshot.</p>', 'ScheduledInstancesEbs$VolumeType' => '<p>The volume type. <code>gp2</code> for General Purpose SSD, <code>io1</code> for Provisioned IOPS SSD, Throughput Optimized HDD for <code>st1</code>, Cold HDD for <code>sc1</code>, or <code>standard</code> for Magnetic.</p> <p>Default: <code>standard</code> </p>', 'ScheduledInstancesIamInstanceProfile$Arn' => '<p>The Amazon Resource Name (ARN).</p>', 'ScheduledInstancesIamInstanceProfile$Name' => '<p>The name.</p>', 'ScheduledInstancesLaunchSpecification$ImageId' => '<p>The ID of the Amazon Machine Image (AMI).</p>', 'ScheduledInstancesLaunchSpecification$KeyName' => '<p>The name of the key pair.</p>', 'ScheduledInstancesLaunchSpecification$UserData' => '<p>The base64-encoded MIME user data.</p>', 'ScheduledInstancesLaunchSpecification$KernelId' => '<p>The ID of the kernel.</p>', 'ScheduledInstancesLaunchSpecification$InstanceType' => '<p>The instance type.</p>', 'ScheduledInstancesLaunchSpecification$RamdiskId' => '<p>The ID of the RAM disk.</p>', 'ScheduledInstancesLaunchSpecification$SubnetId' => '<p>The ID of the subnet in which to launch the instances.</p>', 'ScheduledInstancesNetworkInterface$NetworkInterfaceId' => '<p>The ID of the network interface.</p>', 'ScheduledInstancesNetworkInterface$SubnetId' => '<p>The ID of the subnet.</p>', 'ScheduledInstancesNetworkInterface$Description' => '<p>The description.</p>', 'ScheduledInstancesNetworkInterface$PrivateIpAddress' => '<p>The IP address of the network interface within the subnet.</p>', 'ScheduledInstancesPlacement$AvailabilityZone' => '<p>The Availability Zone.</p>', 'ScheduledInstancesPlacement$GroupName' => '<p>The name of the placement group.</p>', 'ScheduledInstancesPrivateIpAddressConfig$PrivateIpAddress' => '<p>The IP address.</p>', 'ScheduledInstancesSecurityGroupIdSet$member' => NULL, 'SecurityGroup$OwnerId' => '<p>The AWS account ID of the owner of the security group.</p>', 'SecurityGroup$GroupName' => '<p>The name of the security group.</p>', 'SecurityGroup$GroupId' => '<p>The ID of the security group.</p>', 'SecurityGroup$Description' => '<p>A description of the security group.</p>', 'SecurityGroup$VpcId' => '<p>[EC2-VPC] The ID of the VPC for the security group.</p>', 'SecurityGroupIdStringList$member' => NULL, 'SecurityGroupReference$GroupId' => '<p>The ID of your security group.</p>', 'SecurityGroupReference$ReferencingVpcId' => '<p>The ID of the VPC with the referencing security group.</p>', 'SecurityGroupReference$VpcPeeringConnectionId' => '<p>The ID of the VPC peering connection.</p>', 'SecurityGroupStringList$member' => NULL, 'Snapshot$SnapshotId' => '<p>The ID of the snapshot. Each snapshot receives a unique identifier when it is created.</p>', 'Snapshot$VolumeId' => '<p>The ID of the volume that was used to create the snapshot. Snapshots created by the <a>CopySnapshot</a> action have an arbitrary volume ID that should not be used for any purpose.</p>', 'Snapshot$StateMessage' => '<p>Encrypted Amazon EBS snapshots are copied asynchronously. If a snapshot copy operation fails (for example, if the proper AWS Key Management Service (AWS KMS) permissions are not obtained) this field displays error state details to help you diagnose why the error occurred. This parameter is only returned by the <a>DescribeSnapshots</a> API operation.</p>', 'Snapshot$Progress' => '<p>The progress of the snapshot, as a percentage.</p>', 'Snapshot$OwnerId' => '<p>The AWS account ID of the EBS snapshot owner.</p>', 'Snapshot$Description' => '<p>The description for the snapshot.</p>', 'Snapshot$OwnerAlias' => '<p> Value from an Amazon-maintained list (<code>amazon</code> | <code>aws-marketplace</code> | <code>microsoft</code>) of snapshot owners. Not to be confused with the user-configured AWS account alias, which is set from the IAM console. </p>', 'Snapshot$KmsKeyId' => '<p>The full ARN of the AWS Key Management Service (AWS KMS) customer master key (CMK) that was used to protect the volume encryption key for the parent volume.</p>', 'Snapshot$DataEncryptionKeyId' => '<p>The data encryption key identifier for the snapshot. This value is a unique identifier that corresponds to the data encryption key that was used to encrypt the original volume or snapshot copy. Because data encryption keys are inherited by volumes created from snapshots, and vice versa, if snapshots share the same data encryption key identifier, then they belong to the same volume/snapshot lineage. This parameter is only returned by the <a>DescribeSnapshots</a> API operation.</p>', 'SnapshotDetail$Description' => '<p>A description for the snapshot.</p>', 'SnapshotDetail$Format' => '<p>The format of the disk image from which the snapshot is created.</p>', 'SnapshotDetail$Url' => '<p>The URL used to access the disk image.</p>', 'SnapshotDetail$DeviceName' => '<p>The block device mapping for the snapshot.</p>', 'SnapshotDetail$SnapshotId' => '<p>The snapshot ID of the disk being imported.</p>', 'SnapshotDetail$Progress' => '<p>The percentage of progress for the task.</p>', 'SnapshotDetail$StatusMessage' => '<p>A detailed status message for the snapshot creation.</p>', 'SnapshotDetail$Status' => '<p>A brief status of the snapshot creation.</p>', 'SnapshotDiskContainer$Description' => '<p>The description of the disk image being imported.</p>', 'SnapshotDiskContainer$Format' => '<p>The format of the disk image being imported.</p> <p>Valid values: <code>RAW</code> | <code>VHD</code> | <code>VMDK</code> | <code>OVA</code> </p>', 'SnapshotDiskContainer$Url' => '<p>The URL to the Amazon S3-based disk image being imported. It can either be a https URL (https://..) or an Amazon S3 URL (s3://..).</p>', 'SnapshotIdStringList$member' => NULL, 'SnapshotTaskDetail$Description' => '<p>The description of the snapshot.</p>', 'SnapshotTaskDetail$Format' => '<p>The format of the disk image from which the snapshot is created.</p>', 'SnapshotTaskDetail$Url' => '<p>The URL of the disk image from which the snapshot is created.</p>', 'SnapshotTaskDetail$SnapshotId' => '<p>The snapshot ID of the disk being imported.</p>', 'SnapshotTaskDetail$Progress' => '<p>The percentage of completion for the import snapshot task.</p>', 'SnapshotTaskDetail$StatusMessage' => '<p>A detailed status message for the import snapshot task.</p>', 'SnapshotTaskDetail$Status' => '<p>A brief status for the import snapshot task.</p>', 'SpotDatafeedSubscription$OwnerId' => '<p>The AWS account ID of the account.</p>', 'SpotDatafeedSubscription$Bucket' => '<p>The Amazon S3 bucket where the Spot instance data feed is located.</p>', 'SpotDatafeedSubscription$Prefix' => '<p>The prefix that is prepended to data feed files.</p>', 'SpotFleetLaunchSpecification$ImageId' => '<p>The ID of the AMI.</p>', 'SpotFleetLaunchSpecification$KeyName' => '<p>The name of the key pair.</p>', 'SpotFleetLaunchSpecification$UserData' => '<p>The user data to make available to the instances. If you are using an AWS SDK or command line tool, Base64-encoding is performed for you, and you can load the text from a file. Otherwise, you must provide Base64-encoded text.</p>', 'SpotFleetLaunchSpecification$AddressingType' => '<p>Deprecated.</p>', 'SpotFleetLaunchSpecification$KernelId' => '<p>The ID of the kernel.</p>', 'SpotFleetLaunchSpecification$RamdiskId' => '<p>The ID of the RAM disk.</p>', 'SpotFleetLaunchSpecification$SubnetId' => '<p>The ID of the subnet in which to launch the instances. To specify multiple subnets, separate them using commas; for example, "subnet-a61dafcf, subnet-65ea5f08".</p>', 'SpotFleetLaunchSpecification$SpotPrice' => '<p>The bid price per unit hour for the specified instance type. If this value is not specified, the default is the Spot bid price specified for the fleet. To determine the bid price per unit hour, divide the Spot bid price by the value of <code>WeightedCapacity</code>.</p>', 'SpotFleetRequestConfig$SpotFleetRequestId' => '<p>The ID of the Spot fleet request.</p>', 'SpotFleetRequestConfigData$ClientToken' => '<p>A unique, case-sensitive identifier you provide to ensure idempotency of your listings. This helps avoid duplicate listings. For more information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>', 'SpotFleetRequestConfigData$SpotPrice' => '<p>The bid price per unit hour.</p>', 'SpotFleetRequestConfigData$IamFleetRole' => '<p>Grants the Spot fleet permission to terminate Spot instances on your behalf when you cancel its Spot fleet request using <a>CancelSpotFleetRequests</a> or when the Spot fleet request expires, if you set <code>terminateInstancesWithExpiration</code>.</p>', 'SpotInstanceRequest$SpotInstanceRequestId' => '<p>The ID of the Spot instance request.</p>', 'SpotInstanceRequest$SpotPrice' => '<p>The maximum hourly price (bid) for the Spot instance launched to fulfill the request.</p>', 'SpotInstanceRequest$LaunchGroup' => '<p>The instance launch group. Launch groups are Spot instances that launch together and terminate together.</p>', 'SpotInstanceRequest$AvailabilityZoneGroup' => '<p>The Availability Zone group. If you specify the same Availability Zone group for all Spot instance requests, all Spot instances are launched in the same Availability Zone.</p>', 'SpotInstanceRequest$InstanceId' => '<p>The instance ID, if an instance has been launched to fulfill the Spot instance request.</p>', 'SpotInstanceRequest$ActualBlockHourlyPrice' => '<p>If you specified a duration and your Spot instance request was fulfilled, this is the fixed hourly price in effect for the Spot instance while it runs.</p>', 'SpotInstanceRequest$LaunchedAvailabilityZone' => '<p>The Availability Zone in which the bid is launched.</p>', 'SpotInstanceRequestIdList$member' => NULL, 'SpotInstanceStateFault$Code' => '<p>The reason code for the Spot instance state change.</p>', 'SpotInstanceStateFault$Message' => '<p>The message for the Spot instance state change.</p>', 'SpotInstanceStatus$Code' => '<p>The status code. For a list of status codes, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html#spot-instance-bid-status-understand">Spot Bid Status Codes</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'SpotInstanceStatus$Message' => '<p>The description for the status code.</p>', 'SpotPlacement$AvailabilityZone' => '<p>The Availability Zone.</p> <p>[Spot fleet only] To specify multiple Availability Zones, separate them using commas; for example, "us-west-2a, us-west-2b".</p>', 'SpotPlacement$GroupName' => '<p>The name of the placement group (for cluster instances).</p>', 'SpotPrice$SpotPrice' => '<p>The maximum price (bid) that you are willing to pay for a Spot instance.</p>', 'SpotPrice$AvailabilityZone' => '<p>The Availability Zone.</p>', 'StaleIpPermission$IpProtocol' => '<p>The IP protocol name (for <code>tcp</code>, <code>udp</code>, and <code>icmp</code>) or number (see <a href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers)</a>.</p>', 'StaleSecurityGroup$GroupId' => '<p>The ID of the security group.</p>', 'StaleSecurityGroup$GroupName' => '<p>The name of the security group.</p>', 'StaleSecurityGroup$Description' => '<p>The description of the security group.</p>', 'StaleSecurityGroup$VpcId' => '<p>The ID of the VPC for the security group.</p>', 'StartInstancesRequest$AdditionalInfo' => '<p>Reserved.</p>', 'StateReason$Code' => '<p>The reason code for the state change.</p>', 'StateReason$Message' => '<p>The message for the state change.</p> <ul> <li> <p> <code>Server.SpotInstanceTermination</code>: A Spot instance was terminated due to an increase in the market price.</p> </li> <li> <p> <code>Server.InternalError</code>: An internal error occurred during instance launch, resulting in termination.</p> </li> <li> <p> <code>Server.InsufficientInstanceCapacity</code>: There was insufficient instance capacity to satisfy the launch request.</p> </li> <li> <p> <code>Client.InternalError</code>: A client error caused the instance to terminate on launch.</p> </li> <li> <p> <code>Client.InstanceInitiatedShutdown</code>: The instance was shut down using the <code>shutdown -h</code> command from the instance.</p> </li> <li> <p> <code>Client.UserInitiatedShutdown</code>: The instance was shut down using the Amazon EC2 API.</p> </li> <li> <p> <code>Client.VolumeLimitExceeded</code>: The limit on the number of EBS volumes or total storage was exceeded. Decrease usage or request an increase in your limits.</p> </li> <li> <p> <code>Client.InvalidSnapshot.NotFound</code>: The specified snapshot was not found.</p> </li> </ul>', 'Subnet$SubnetId' => '<p>The ID of the subnet.</p>', 'Subnet$VpcId' => '<p>The ID of the VPC the subnet is in.</p>', 'Subnet$CidrBlock' => '<p>The CIDR block assigned to the subnet.</p>', 'Subnet$AvailabilityZone' => '<p>The Availability Zone of the subnet.</p>', 'SubnetIdStringList$member' => NULL, 'Tag$Key' => '<p>The key of the tag.</p> <p>Constraints: Tag keys are case-sensitive and accept a maximum of 127 Unicode characters. May not begin with <code>aws:</code> </p>', 'Tag$Value' => '<p>The value of the tag.</p> <p>Constraints: Tag values are case-sensitive and accept a maximum of 255 Unicode characters.</p>', 'TagDescription$ResourceId' => '<p>The ID of the resource. For example, <code>ami-1a2b3c4d</code>.</p>', 'TagDescription$Key' => '<p>The tag key.</p>', 'TagDescription$Value' => '<p>The tag value.</p>', 'TargetConfiguration$OfferingId' => '<p>The ID of the Convertible Reserved Instance offering.</p>', 'TargetConfigurationRequest$OfferingId' => '<p>The Convertible Reserved Instance offering ID. If this isn\'t included in the request, the response lists your current Convertible Reserved Instance/s and their value/s.</p>', 'UnassignPrivateIpAddressesRequest$NetworkInterfaceId' => '<p>The ID of the network interface.</p>', 'UnsuccessfulItem$ResourceId' => '<p>The ID of the resource.</p>', 'UnsuccessfulItemError$Code' => '<p>The error code.</p>', 'UnsuccessfulItemError$Message' => '<p>The error message accompanying the error code.</p>', 'UserBucket$S3Bucket' => '<p>The name of the S3 bucket where the disk image is located.</p>', 'UserBucket$S3Key' => '<p>The file name of the disk image.</p>', 'UserBucketDetails$S3Bucket' => '<p>The S3 bucket from which the disk image was created.</p>', 'UserBucketDetails$S3Key' => '<p>The file name of the disk image.</p>', 'UserData$Data' => '<p>The user data. If you are using an AWS SDK or command line tool, Base64-encoding is performed for you, and you can load the text from a file. Otherwise, you must provide Base64-encoded text.</p>', 'UserGroupStringList$member' => NULL, 'UserIdGroupPair$UserId' => '<p>The ID of an AWS account. For a referenced security group in another VPC, the account ID of the referenced security group is returned.</p> <p>[EC2-Classic] Required when adding or removing rules that reference a security group in another AWS account.</p>', 'UserIdGroupPair$GroupName' => '<p>The name of the security group. In a request, use this parameter for a security group in EC2-Classic or a default VPC only. For a security group in a nondefault VPC, use the security group ID.</p>', 'UserIdGroupPair$GroupId' => '<p>The ID of the security group.</p>', 'UserIdGroupPair$VpcId' => '<p>The ID of the VPC for the referenced security group, if applicable.</p>', 'UserIdGroupPair$VpcPeeringConnectionId' => '<p>The ID of the VPC peering connection, if applicable.</p>', 'UserIdGroupPair$PeeringStatus' => '<p>The status of a VPC peering connection, if applicable.</p>', 'UserIdStringList$member' => NULL, 'ValueStringList$member' => NULL, 'VgwTelemetry$OutsideIpAddress' => '<p>The Internet-routable IP address of the virtual private gateway\'s outside interface.</p>', 'VgwTelemetry$StatusMessage' => '<p>If an error occurs, a description of the error.</p>', 'Volume$VolumeId' => '<p>The ID of the volume.</p>', 'Volume$SnapshotId' => '<p>The snapshot from which the volume was created, if applicable.</p>', 'Volume$AvailabilityZone' => '<p>The Availability Zone for the volume.</p>', 'Volume$KmsKeyId' => '<p>The full ARN of the AWS Key Management Service (AWS KMS) customer master key (CMK) that was used to protect the volume encryption key for the volume.</p>', 'VolumeAttachment$VolumeId' => '<p>The ID of the volume.</p>', 'VolumeAttachment$InstanceId' => '<p>The ID of the instance.</p>', 'VolumeAttachment$Device' => '<p>The device name.</p>', 'VolumeIdStringList$member' => NULL, 'VolumeStatusAction$Code' => '<p>The code identifying the operation, for example, <code>enable-volume-io</code>.</p>', 'VolumeStatusAction$Description' => '<p>A description of the operation.</p>', 'VolumeStatusAction$EventType' => '<p>The event type associated with this operation.</p>', 'VolumeStatusAction$EventId' => '<p>The ID of the event associated with this operation.</p>', 'VolumeStatusDetails$Status' => '<p>The intended status of the volume status.</p>', 'VolumeStatusEvent$EventType' => '<p>The type of this event.</p>', 'VolumeStatusEvent$Description' => '<p>A description of the event.</p>', 'VolumeStatusEvent$EventId' => '<p>The ID of this event.</p>', 'VolumeStatusItem$VolumeId' => '<p>The volume ID.</p>', 'VolumeStatusItem$AvailabilityZone' => '<p>The Availability Zone of the volume.</p>', 'Vpc$VpcId' => '<p>The ID of the VPC.</p>', 'Vpc$CidrBlock' => '<p>The CIDR block for the VPC.</p>', 'Vpc$DhcpOptionsId' => '<p>The ID of the set of DHCP options you\'ve associated with the VPC (or <code>default</code> if the default options are associated with the VPC).</p>', 'VpcAttachment$VpcId' => '<p>The ID of the VPC.</p>', 'VpcClassicLink$VpcId' => '<p>The ID of the VPC.</p>', 'VpcClassicLinkIdList$member' => NULL, 'VpcEndpoint$VpcEndpointId' => '<p>The ID of the VPC endpoint.</p>', 'VpcEndpoint$VpcId' => '<p>The ID of the VPC to which the endpoint is associated.</p>', 'VpcEndpoint$ServiceName' => '<p>The name of the AWS service to which the endpoint is associated.</p>', 'VpcEndpoint$PolicyDocument' => '<p>The policy document associated with the endpoint.</p>', 'VpcIdStringList$member' => NULL, 'VpcPeeringConnection$VpcPeeringConnectionId' => '<p>The ID of the VPC peering connection.</p>', 'VpcPeeringConnectionStateReason$Message' => '<p>A message that provides more information about the status, if applicable.</p>', 'VpcPeeringConnectionVpcInfo$CidrBlock' => '<p>The CIDR block for the VPC.</p>', 'VpcPeeringConnectionVpcInfo$OwnerId' => '<p>The AWS account ID of the VPC owner.</p>', 'VpcPeeringConnectionVpcInfo$VpcId' => '<p>The ID of the VPC.</p>', 'VpnConnection$VpnConnectionId' => '<p>The ID of the VPN connection.</p>', 'VpnConnection$CustomerGatewayConfiguration' => '<p>The configuration information for the VPN connection\'s customer gateway (in the native XML format). This element is always present in the <a>CreateVpnConnection</a> response; however, it\'s present in the <a>DescribeVpnConnections</a> response only if the VPN connection is in the <code>pending</code> or <code>available</code> state.</p>', 'VpnConnection$CustomerGatewayId' => '<p>The ID of the customer gateway at your end of the VPN connection.</p>', 'VpnConnection$VpnGatewayId' => '<p>The ID of the virtual private gateway at the AWS side of the VPN connection.</p>', 'VpnConnectionIdStringList$member' => NULL, 'VpnGateway$VpnGatewayId' => '<p>The ID of the virtual private gateway.</p>', 'VpnGateway$AvailabilityZone' => '<p>The Availability Zone where the virtual private gateway was created, if applicable. This field may be empty or not returned.</p>', 'VpnGatewayIdStringList$member' => NULL, 'VpnStaticRoute$DestinationCidrBlock' => '<p>The CIDR block associated with the local subnet of the customer data center.</p>', 'ZoneNameStringList$member' => NULL, ], ], 'Subnet' => [ 'base' => '<p>Describes a subnet.</p>', 'refs' => [ 'CreateSubnetResult$Subnet' => '<p>Information about the subnet.</p>', 'SubnetList$member' => NULL, ], ], 'SubnetIdStringList' => [ 'base' => NULL, 'refs' => [ 'DescribeSubnetsRequest$SubnetIds' => '<p>One or more subnet IDs.</p> <p>Default: Describes all your subnets.</p>', ], ], 'SubnetList' => [ 'base' => NULL, 'refs' => [ 'DescribeSubnetsResult$Subnets' => '<p>Information about one or more subnets.</p>', ], ], 'SubnetState' => [ 'base' => NULL, 'refs' => [ 'Subnet$State' => '<p>The current state of the subnet.</p>', ], ], 'SummaryStatus' => [ 'base' => NULL, 'refs' => [ 'InstanceStatusSummary$Status' => '<p>The status.</p>', ], ], 'Tag' => [ 'base' => '<p>Describes a tag.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagDescription' => [ 'base' => '<p>Describes a tag.</p>', 'refs' => [ 'TagDescriptionList$member' => NULL, ], ], 'TagDescriptionList' => [ 'base' => NULL, 'refs' => [ 'DescribeTagsResult$Tags' => '<p>A list of tags.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'ClassicLinkInstance$Tags' => '<p>Any tags assigned to the instance.</p>', 'ConversionTask$Tags' => '<p>Any tags assigned to the task.</p>', 'CreateTagsRequest$Tags' => '<p>One or more tags. The <code>value</code> parameter is required, but if you don\'t want the tag to have a value, specify the parameter with no value, and we set the value to an empty string. </p>', 'CustomerGateway$Tags' => '<p>Any tags assigned to the customer gateway.</p>', 'DeleteTagsRequest$Tags' => '<p>One or more tags to delete. If you omit the <code>value</code> parameter, we delete the tag regardless of its value. If you specify this parameter with an empty string as the value, we delete the key only if its value is an empty string.</p>', 'DhcpOptions$Tags' => '<p>Any tags assigned to the DHCP options set.</p>', 'Image$Tags' => '<p>Any tags assigned to the image.</p>', 'Instance$Tags' => '<p>Any tags assigned to the instance.</p>', 'InternetGateway$Tags' => '<p>Any tags assigned to the Internet gateway.</p>', 'NetworkAcl$Tags' => '<p>Any tags assigned to the network ACL.</p>', 'NetworkInterface$TagSet' => '<p>Any tags assigned to the network interface.</p>', 'ReservedInstances$Tags' => '<p>Any tags assigned to the resource.</p>', 'ReservedInstancesListing$Tags' => '<p>Any tags assigned to the resource.</p>', 'RouteTable$Tags' => '<p>Any tags assigned to the route table.</p>', 'SecurityGroup$Tags' => '<p>Any tags assigned to the security group.</p>', 'Snapshot$Tags' => '<p>Any tags assigned to the snapshot.</p>', 'SpotInstanceRequest$Tags' => '<p>Any tags assigned to the resource.</p>', 'Subnet$Tags' => '<p>Any tags assigned to the subnet.</p>', 'Volume$Tags' => '<p>Any tags assigned to the volume.</p>', 'Vpc$Tags' => '<p>Any tags assigned to the VPC.</p>', 'VpcClassicLink$Tags' => '<p>Any tags assigned to the VPC.</p>', 'VpcPeeringConnection$Tags' => '<p>Any tags assigned to the resource.</p>', 'VpnConnection$Tags' => '<p>Any tags assigned to the VPN connection.</p>', 'VpnGateway$Tags' => '<p>Any tags assigned to the virtual private gateway.</p>', ], ], 'TargetConfiguration' => [ 'base' => '<p>Information about the Convertible Reserved Instance offering.</p>', 'refs' => [ 'TargetReservationValue$TargetConfiguration' => '<p>The configuration of the Convertible Reserved Instances that make up the exchange.</p>', ], ], 'TargetConfigurationRequest' => [ 'base' => '<p>Details about the target configuration.</p>', 'refs' => [ 'TargetConfigurationRequestSet$member' => NULL, ], ], 'TargetConfigurationRequestSet' => [ 'base' => NULL, 'refs' => [ 'AcceptReservedInstancesExchangeQuoteRequest$TargetConfigurations' => '<p>The configurations of the Convertible Reserved Instance offerings you are purchasing in this exchange.</p>', 'GetReservedInstancesExchangeQuoteRequest$TargetConfigurations' => '<p>The configuration requirements of the Convertible Reserved Instances you want in exchange for your current Convertible Reserved Instances.</p>', ], ], 'TargetReservationValue' => [ 'base' => '<p>The total value of the new Convertible Reserved Instances.</p>', 'refs' => [ 'TargetReservationValueSet$member' => NULL, ], ], 'TargetReservationValueSet' => [ 'base' => NULL, 'refs' => [ 'GetReservedInstancesExchangeQuoteResult$TargetConfigurationValueSet' => '<p>The values of the target Convertible Reserved Instances.</p>', ], ], 'TelemetryStatus' => [ 'base' => NULL, 'refs' => [ 'VgwTelemetry$Status' => '<p>The status of the VPN tunnel.</p>', ], ], 'Tenancy' => [ 'base' => NULL, 'refs' => [ 'CreateVpcRequest$InstanceTenancy' => '<p>The tenancy options for instances launched into the VPC. For <code>default</code>, instances are launched with shared tenancy by default. You can launch instances with any tenancy into a shared tenancy VPC. For <code>dedicated</code>, instances are launched as dedicated tenancy instances by default. You can only launch instances with a tenancy of <code>dedicated</code> or <code>host</code> into a dedicated tenancy VPC. </p> <p> <b>Important:</b> The <code>host</code> value cannot be used with this parameter. Use the <code>default</code> or <code>dedicated</code> values only.</p> <p>Default: <code>default</code> </p>', 'DescribeReservedInstancesOfferingsRequest$InstanceTenancy' => '<p>The tenancy of the instances covered by the reservation. A Reserved Instance with a tenancy of <code>dedicated</code> is applied to instances that run in a VPC on single-tenant hardware (i.e., Dedicated Instances).</p> <p>Default: <code>default</code> </p>', 'Placement$Tenancy' => '<p>The tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of <code>dedicated</code> runs on single-tenant hardware. The <code>host</code> tenancy is not supported for the <a>ImportInstance</a> command.</p>', 'ReservedInstances$InstanceTenancy' => '<p>The tenancy of the instance.</p>', 'ReservedInstancesOffering$InstanceTenancy' => '<p>The tenancy of the instance.</p>', 'Vpc$InstanceTenancy' => '<p>The allowed tenancy of instances launched into the VPC.</p>', ], ], 'TerminateInstancesRequest' => [ 'base' => '<p>Contains the parameters for TerminateInstances.</p>', 'refs' => [], ], 'TerminateInstancesResult' => [ 'base' => '<p>Contains the output of TerminateInstances.</p>', 'refs' => [], ], 'TrafficType' => [ 'base' => NULL, 'refs' => [ 'CreateFlowLogsRequest$TrafficType' => '<p>The type of traffic to log.</p>', 'FlowLog$TrafficType' => '<p>The type of traffic captured for the flow log.</p>', ], ], 'UnassignPrivateIpAddressesRequest' => [ 'base' => '<p>Contains the parameters for UnassignPrivateIpAddresses.</p>', 'refs' => [], ], 'UnmonitorInstancesRequest' => [ 'base' => '<p>Contains the parameters for UnmonitorInstances.</p>', 'refs' => [], ], 'UnmonitorInstancesResult' => [ 'base' => '<p>Contains the output of UnmonitorInstances.</p>', 'refs' => [], ], 'UnsuccessfulItem' => [ 'base' => '<p>Information about items that were not successfully processed in a batch call.</p>', 'refs' => [ 'UnsuccessfulItemList$member' => NULL, 'UnsuccessfulItemSet$member' => NULL, ], ], 'UnsuccessfulItemError' => [ 'base' => '<p>Information about the error that occurred. For more information about errors, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html">Error Codes</a>.</p>', 'refs' => [ 'UnsuccessfulItem$Error' => '<p>Information about the error.</p>', ], ], 'UnsuccessfulItemList' => [ 'base' => NULL, 'refs' => [ 'ModifyHostsResult$Unsuccessful' => '<p>The IDs of the Dedicated Hosts that could not be modified. Check whether the setting you requested can be used.</p>', 'ReleaseHostsResult$Unsuccessful' => '<p>The IDs of the Dedicated Hosts that could not be released, including an error message.</p>', ], ], 'UnsuccessfulItemSet' => [ 'base' => NULL, 'refs' => [ 'CreateFlowLogsResult$Unsuccessful' => '<p>Information about the flow logs that could not be created successfully.</p>', 'DeleteFlowLogsResult$Unsuccessful' => '<p>Information about the flow logs that could not be deleted successfully.</p>', 'DeleteVpcEndpointsResult$Unsuccessful' => '<p>Information about the endpoints that were not successfully deleted.</p>', ], ], 'UserBucket' => [ 'base' => '<p>Describes the S3 bucket for the disk image.</p>', 'refs' => [ 'ImageDiskContainer$UserBucket' => '<p>The S3 bucket for the disk image.</p>', 'SnapshotDiskContainer$UserBucket' => '<p>The S3 bucket for the disk image.</p>', ], ], 'UserBucketDetails' => [ 'base' => '<p>Describes the S3 bucket for the disk image.</p>', 'refs' => [ 'SnapshotDetail$UserBucket' => '<p>The S3 bucket for the disk image.</p>', 'SnapshotTaskDetail$UserBucket' => '<p>The S3 bucket for the disk image.</p>', ], ], 'UserData' => [ 'base' => '<p>Describes the user data for an instance.</p>', 'refs' => [ 'ImportInstanceLaunchSpecification$UserData' => '<p>The user data to make available to the instance. If you are using an AWS SDK or command line tool, Base64-encoding is performed for you, and you can load the text from a file. Otherwise, you must provide Base64-encoded text.</p>', ], ], 'UserGroupStringList' => [ 'base' => NULL, 'refs' => [ 'ModifyImageAttributeRequest$UserGroups' => '<p>One or more user groups. This is only valid when modifying the <code>launchPermission</code> attribute.</p>', ], ], 'UserIdGroupPair' => [ 'base' => '<p>Describes a security group and AWS account ID pair.</p>', 'refs' => [ 'UserIdGroupPairList$member' => NULL, 'UserIdGroupPairSet$member' => NULL, ], ], 'UserIdGroupPairList' => [ 'base' => NULL, 'refs' => [ 'IpPermission$UserIdGroupPairs' => '<p>One or more security group and AWS account ID pairs.</p>', ], ], 'UserIdGroupPairSet' => [ 'base' => NULL, 'refs' => [ 'StaleIpPermission$UserIdGroupPairs' => '<p>One or more security group pairs. Returns the ID of the referenced security group and VPC, and the ID and status of the VPC peering connection.</p>', ], ], 'UserIdStringList' => [ 'base' => NULL, 'refs' => [ 'ModifyImageAttributeRequest$UserIds' => '<p>One or more AWS account IDs. This is only valid when modifying the <code>launchPermission</code> attribute.</p>', 'ModifySnapshotAttributeRequest$UserIds' => '<p>The account ID to modify for the snapshot.</p>', ], ], 'ValueStringList' => [ 'base' => NULL, 'refs' => [ 'CancelSpotFleetRequestsRequest$SpotFleetRequestIds' => '<p>The IDs of the Spot fleet requests.</p>', 'CreateFlowLogsRequest$ResourceIds' => '<p>One or more subnet, network interface, or VPC IDs.</p> <p>Constraints: Maximum of 1000 resources</p>', 'CreateFlowLogsResult$FlowLogIds' => '<p>The IDs of the flow logs.</p>', 'CreateVpcEndpointRequest$RouteTableIds' => '<p>One or more route table IDs.</p>', 'DeleteFlowLogsRequest$FlowLogIds' => '<p>One or more flow log IDs.</p>', 'DeleteVpcEndpointsRequest$VpcEndpointIds' => '<p>One or more endpoint IDs.</p>', 'DescribeFlowLogsRequest$FlowLogIds' => '<p>One or more flow log IDs.</p>', 'DescribeInternetGatewaysRequest$InternetGatewayIds' => '<p>One or more Internet gateway IDs.</p> <p>Default: Describes all your Internet gateways.</p>', 'DescribeMovingAddressesRequest$PublicIps' => '<p>One or more Elastic IP addresses.</p>', 'DescribeNatGatewaysRequest$NatGatewayIds' => '<p>One or more NAT gateway IDs.</p>', 'DescribeNetworkAclsRequest$NetworkAclIds' => '<p>One or more network ACL IDs.</p> <p>Default: Describes all your network ACLs.</p>', 'DescribePrefixListsRequest$PrefixListIds' => '<p>One or more prefix list IDs.</p>', 'DescribeRouteTablesRequest$RouteTableIds' => '<p>One or more route table IDs.</p> <p>Default: Describes all your route tables.</p>', 'DescribeSpotFleetRequestsRequest$SpotFleetRequestIds' => '<p>The IDs of the Spot fleet requests.</p>', 'DescribeVpcEndpointServicesResult$ServiceNames' => '<p>A list of supported AWS services.</p>', 'DescribeVpcEndpointsRequest$VpcEndpointIds' => '<p>One or more endpoint IDs.</p>', 'DescribeVpcPeeringConnectionsRequest$VpcPeeringConnectionIds' => '<p>One or more VPC peering connection IDs.</p> <p>Default: Describes all your VPC peering connections.</p>', 'Filter$Values' => '<p>One or more filter values. Filter values are case-sensitive.</p>', 'ModifyVpcEndpointRequest$AddRouteTableIds' => '<p>One or more route tables IDs to associate with the endpoint.</p>', 'ModifyVpcEndpointRequest$RemoveRouteTableIds' => '<p>One or more route table IDs to disassociate from the endpoint.</p>', 'NewDhcpConfiguration$Values' => NULL, 'PrefixList$Cidrs' => '<p>The IP address range of the AWS service.</p>', 'RequestSpotLaunchSpecification$SecurityGroups' => NULL, 'RequestSpotLaunchSpecification$SecurityGroupIds' => NULL, 'VpcEndpoint$RouteTableIds' => '<p>One or more route tables associated with the endpoint.</p>', ], ], 'VgwTelemetry' => [ 'base' => '<p>Describes telemetry for a VPN tunnel.</p>', 'refs' => [ 'VgwTelemetryList$member' => NULL, ], ], 'VgwTelemetryList' => [ 'base' => NULL, 'refs' => [ 'VpnConnection$VgwTelemetry' => '<p>Information about the VPN tunnel.</p>', ], ], 'VirtualizationType' => [ 'base' => NULL, 'refs' => [ 'Image$VirtualizationType' => '<p>The type of virtualization of the AMI.</p>', 'Instance$VirtualizationType' => '<p>The virtualization type of the instance.</p>', ], ], 'Volume' => [ 'base' => '<p>Describes a volume.</p>', 'refs' => [ 'VolumeList$member' => NULL, ], ], 'VolumeAttachment' => [ 'base' => '<p>Describes volume attachment details.</p>', 'refs' => [ 'VolumeAttachmentList$member' => NULL, ], ], 'VolumeAttachmentList' => [ 'base' => NULL, 'refs' => [ 'Volume$Attachments' => '<p>Information about the volume attachments.</p>', ], ], 'VolumeAttachmentState' => [ 'base' => NULL, 'refs' => [ 'VolumeAttachment$State' => '<p>The attachment state of the volume.</p>', ], ], 'VolumeAttributeName' => [ 'base' => NULL, 'refs' => [ 'DescribeVolumeAttributeRequest$Attribute' => '<p>The instance attribute.</p>', ], ], 'VolumeDetail' => [ 'base' => '<p>Describes an EBS volume.</p>', 'refs' => [ 'DiskImage$Volume' => '<p>Information about the volume.</p>', 'ImportVolumeRequest$Volume' => '<p>The volume size.</p>', ], ], 'VolumeIdStringList' => [ 'base' => NULL, 'refs' => [ 'DescribeVolumeStatusRequest$VolumeIds' => '<p>One or more volume IDs.</p> <p>Default: Describes all your volumes.</p>', 'DescribeVolumesRequest$VolumeIds' => '<p>One or more volume IDs.</p>', ], ], 'VolumeList' => [ 'base' => NULL, 'refs' => [ 'DescribeVolumesResult$Volumes' => '<p>Information about the volumes.</p>', ], ], 'VolumeState' => [ 'base' => NULL, 'refs' => [ 'Volume$State' => '<p>The volume state.</p>', ], ], 'VolumeStatusAction' => [ 'base' => '<p>Describes a volume status operation code.</p>', 'refs' => [ 'VolumeStatusActionsList$member' => NULL, ], ], 'VolumeStatusActionsList' => [ 'base' => NULL, 'refs' => [ 'VolumeStatusItem$Actions' => '<p>The details of the operation.</p>', ], ], 'VolumeStatusDetails' => [ 'base' => '<p>Describes a volume status.</p>', 'refs' => [ 'VolumeStatusDetailsList$member' => NULL, ], ], 'VolumeStatusDetailsList' => [ 'base' => NULL, 'refs' => [ 'VolumeStatusInfo$Details' => '<p>The details of the volume status.</p>', ], ], 'VolumeStatusEvent' => [ 'base' => '<p>Describes a volume status event.</p>', 'refs' => [ 'VolumeStatusEventsList$member' => NULL, ], ], 'VolumeStatusEventsList' => [ 'base' => NULL, 'refs' => [ 'VolumeStatusItem$Events' => '<p>A list of events associated with the volume.</p>', ], ], 'VolumeStatusInfo' => [ 'base' => '<p>Describes the status of a volume.</p>', 'refs' => [ 'VolumeStatusItem$VolumeStatus' => '<p>The volume status.</p>', ], ], 'VolumeStatusInfoStatus' => [ 'base' => NULL, 'refs' => [ 'VolumeStatusInfo$Status' => '<p>The status of the volume.</p>', ], ], 'VolumeStatusItem' => [ 'base' => '<p>Describes the volume status.</p>', 'refs' => [ 'VolumeStatusList$member' => NULL, ], ], 'VolumeStatusList' => [ 'base' => NULL, 'refs' => [ 'DescribeVolumeStatusResult$VolumeStatuses' => '<p>A list of volumes.</p>', ], ], 'VolumeStatusName' => [ 'base' => NULL, 'refs' => [ 'VolumeStatusDetails$Name' => '<p>The name of the volume status.</p>', ], ], 'VolumeType' => [ 'base' => NULL, 'refs' => [ 'CreateVolumeRequest$VolumeType' => '<p>The volume type. This can be <code>gp2</code> for General Purpose SSD, <code>io1</code> for Provisioned IOPS SSD, <code>st1</code> for Throughput Optimized HDD, <code>sc1</code> for Cold HDD, or <code>standard</code> for Magnetic volumes.</p> <p>Default: <code>standard</code> </p>', 'EbsBlockDevice$VolumeType' => '<p>The volume type: <code>gp2</code>, <code>io1</code>, <code>st1</code>, <code>sc1</code>, or <code>standard</code>.</p> <p>Default: <code>standard</code> </p>', 'Volume$VolumeType' => '<p>The volume type. This can be <code>gp2</code> for General Purpose SSD, <code>io1</code> for Provisioned IOPS SSD, <code>st1</code> for Throughput Optimized HDD, <code>sc1</code> for Cold HDD, or <code>standard</code> for Magnetic volumes.</p>', ], ], 'Vpc' => [ 'base' => '<p>Describes a VPC.</p>', 'refs' => [ 'CreateVpcResult$Vpc' => '<p>Information about the VPC.</p>', 'VpcList$member' => NULL, ], ], 'VpcAttachment' => [ 'base' => '<p>Describes an attachment between a virtual private gateway and a VPC.</p>', 'refs' => [ 'AttachVpnGatewayResult$VpcAttachment' => '<p>Information about the attachment.</p>', 'VpcAttachmentList$member' => NULL, ], ], 'VpcAttachmentList' => [ 'base' => NULL, 'refs' => [ 'VpnGateway$VpcAttachments' => '<p>Any VPCs attached to the virtual private gateway.</p>', ], ], 'VpcAttributeName' => [ 'base' => NULL, 'refs' => [ 'DescribeVpcAttributeRequest$Attribute' => '<p>The VPC attribute.</p>', ], ], 'VpcClassicLink' => [ 'base' => '<p>Describes whether a VPC is enabled for ClassicLink.</p>', 'refs' => [ 'VpcClassicLinkList$member' => NULL, ], ], 'VpcClassicLinkIdList' => [ 'base' => NULL, 'refs' => [ 'DescribeVpcClassicLinkDnsSupportRequest$VpcIds' => '<p>One or more VPC IDs.</p>', 'DescribeVpcClassicLinkRequest$VpcIds' => '<p>One or more VPCs for which you want to describe the ClassicLink status.</p>', ], ], 'VpcClassicLinkList' => [ 'base' => NULL, 'refs' => [ 'DescribeVpcClassicLinkResult$Vpcs' => '<p>The ClassicLink status of one or more VPCs.</p>', ], ], 'VpcEndpoint' => [ 'base' => '<p>Describes a VPC endpoint.</p>', 'refs' => [ 'CreateVpcEndpointResult$VpcEndpoint' => '<p>Information about the endpoint.</p>', 'VpcEndpointSet$member' => NULL, ], ], 'VpcEndpointSet' => [ 'base' => NULL, 'refs' => [ 'DescribeVpcEndpointsResult$VpcEndpoints' => '<p>Information about the endpoints.</p>', ], ], 'VpcIdStringList' => [ 'base' => NULL, 'refs' => [ 'DescribeVpcsRequest$VpcIds' => '<p>One or more VPC IDs.</p> <p>Default: Describes all your VPCs.</p>', ], ], 'VpcList' => [ 'base' => NULL, 'refs' => [ 'DescribeVpcsResult$Vpcs' => '<p>Information about one or more VPCs.</p>', ], ], 'VpcPeeringConnection' => [ 'base' => '<p>Describes a VPC peering connection.</p>', 'refs' => [ 'AcceptVpcPeeringConnectionResult$VpcPeeringConnection' => '<p>Information about the VPC peering connection.</p>', 'CreateVpcPeeringConnectionResult$VpcPeeringConnection' => '<p>Information about the VPC peering connection.</p>', 'VpcPeeringConnectionList$member' => NULL, ], ], 'VpcPeeringConnectionList' => [ 'base' => NULL, 'refs' => [ 'DescribeVpcPeeringConnectionsResult$VpcPeeringConnections' => '<p>Information about the VPC peering connections.</p>', ], ], 'VpcPeeringConnectionOptionsDescription' => [ 'base' => '<p>Describes the VPC peering connection options.</p>', 'refs' => [ 'VpcPeeringConnectionVpcInfo$PeeringOptions' => '<p>Information about the VPC peering connection options for the accepter or requester VPC.</p>', ], ], 'VpcPeeringConnectionStateReason' => [ 'base' => '<p>Describes the status of a VPC peering connection.</p>', 'refs' => [ 'VpcPeeringConnection$Status' => '<p>The status of the VPC peering connection.</p>', ], ], 'VpcPeeringConnectionStateReasonCode' => [ 'base' => NULL, 'refs' => [ 'VpcPeeringConnectionStateReason$Code' => '<p>The status of the VPC peering connection.</p>', ], ], 'VpcPeeringConnectionVpcInfo' => [ 'base' => '<p>Describes a VPC in a VPC peering connection.</p>', 'refs' => [ 'VpcPeeringConnection$AccepterVpcInfo' => '<p>Information about the accepter VPC. CIDR block information is not returned when creating a VPC peering connection, or when describing a VPC peering connection that\'s in the <code>initiating-request</code> or <code>pending-acceptance</code> state.</p>', 'VpcPeeringConnection$RequesterVpcInfo' => '<p>Information about the requester VPC.</p>', ], ], 'VpcState' => [ 'base' => NULL, 'refs' => [ 'Vpc$State' => '<p>The current state of the VPC.</p>', ], ], 'VpnConnection' => [ 'base' => '<p>Describes a VPN connection.</p>', 'refs' => [ 'CreateVpnConnectionResult$VpnConnection' => '<p>Information about the VPN connection.</p>', 'VpnConnectionList$member' => NULL, ], ], 'VpnConnectionIdStringList' => [ 'base' => NULL, 'refs' => [ 'DescribeVpnConnectionsRequest$VpnConnectionIds' => '<p>One or more VPN connection IDs.</p> <p>Default: Describes your VPN connections.</p>', ], ], 'VpnConnectionList' => [ 'base' => NULL, 'refs' => [ 'DescribeVpnConnectionsResult$VpnConnections' => '<p>Information about one or more VPN connections.</p>', ], ], 'VpnConnectionOptions' => [ 'base' => '<p>Describes VPN connection options.</p>', 'refs' => [ 'VpnConnection$Options' => '<p>The VPN connection options.</p>', ], ], 'VpnConnectionOptionsSpecification' => [ 'base' => '<p>Describes VPN connection options.</p>', 'refs' => [ 'CreateVpnConnectionRequest$Options' => '<p>Indicates whether the VPN connection requires static routes. If you are creating a VPN connection for a device that does not support BGP, you must specify <code>true</code>.</p> <p>Default: <code>false</code> </p>', ], ], 'VpnGateway' => [ 'base' => '<p>Describes a virtual private gateway.</p>', 'refs' => [ 'CreateVpnGatewayResult$VpnGateway' => '<p>Information about the virtual private gateway.</p>', 'VpnGatewayList$member' => NULL, ], ], 'VpnGatewayIdStringList' => [ 'base' => NULL, 'refs' => [ 'DescribeVpnGatewaysRequest$VpnGatewayIds' => '<p>One or more virtual private gateway IDs.</p> <p>Default: Describes all your virtual private gateways.</p>', ], ], 'VpnGatewayList' => [ 'base' => NULL, 'refs' => [ 'DescribeVpnGatewaysResult$VpnGateways' => '<p>Information about one or more virtual private gateways.</p>', ], ], 'VpnState' => [ 'base' => NULL, 'refs' => [ 'VpnConnection$State' => '<p>The current state of the VPN connection.</p>', 'VpnGateway$State' => '<p>The current state of the virtual private gateway.</p>', 'VpnStaticRoute$State' => '<p>The current state of the static route.</p>', ], ], 'VpnStaticRoute' => [ 'base' => '<p>Describes a static route for a VPN connection.</p>', 'refs' => [ 'VpnStaticRouteList$member' => NULL, ], ], 'VpnStaticRouteList' => [ 'base' => NULL, 'refs' => [ 'VpnConnection$Routes' => '<p>The static routes associated with the VPN connection.</p>', ], ], 'VpnStaticRouteSource' => [ 'base' => NULL, 'refs' => [ 'VpnStaticRoute$Source' => '<p>Indicates how the routes were provided.</p>', ], ], 'ZoneNameStringList' => [ 'base' => NULL, 'refs' => [ 'DescribeAvailabilityZonesRequest$ZoneNames' => '<p>The names of one or more Availability Zones.</p>', ], ], 'scope' => [ 'base' => NULL, 'refs' => [ 'ReservedInstances$Scope' => '<p>The scope of the Reserved Instance.</p>', 'ReservedInstancesConfiguration$Scope' => '<p>Whether the Reserved Instance is <code>standard</code> or <code>convertible</code>.</p>', 'ReservedInstancesOffering$Scope' => '<p>Whether the Reserved Instance is applied to instances in a region or an Availability Zone.</p>', ], ], ],];
