<?php
// This file was auto-generated from sdk-root/src/data/eks/2017-11-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Amazon Elastic Kubernetes Service (Amazon EKS) is a managed service that makes it easy for you to run Kubernetes on Amazon Web Services without needing to setup or maintain your own Kubernetes control plane. Kubernetes is an open-source system for automating the deployment, scaling, and management of containerized applications.</p> <p>Amazon EKS runs up-to-date versions of the open-source Kubernetes software, so you can use all the existing plugins and tooling from the Kubernetes community. Applications running on Amazon EKS are fully compatible with applications running on any standard Kubernetes environment, whether running in on-premises data centers or public clouds. This means that you can easily migrate any standard Kubernetes application to Amazon EKS without any code modification required.</p>', 'operations' => [ 'AssociateAccessPolicy' => '<p>Associates an access policy and its scope to an access entry. For more information about associating access policies, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/access-policies.html">Associating and disassociating access policies to and from access entries</a> in the <i>Amazon EKS User Guide</i>.</p>', 'AssociateEncryptionConfig' => '<p>Associates an encryption configuration to an existing cluster.</p> <p>Use this API to enable encryption on existing clusters that don\'t already have encryption enabled. This allows you to implement a defense-in-depth security strategy without migrating applications to new Amazon EKS clusters.</p>', 'AssociateIdentityProviderConfig' => '<p>Associates an identity provider configuration to a cluster.</p> <p>If you want to authenticate identities using an identity provider, you can create an identity provider configuration and associate it to your cluster. After configuring authentication to your cluster you can create Kubernetes <code>Role</code> and <code>ClusterRole</code> objects, assign permissions to them, and then bind them to the identities using Kubernetes <code>RoleBinding</code> and <code>ClusterRoleBinding</code> objects. For more information see <a href="https://kubernetes.io/docs/reference/access-authn-authz/rbac/">Using RBAC Authorization</a> in the Kubernetes documentation.</p>', 'CreateAccessEntry' => '<p>Creates an access entry.</p> <p>An access entry allows an IAM principal to access your cluster. Access entries can replace the need to maintain entries in the <code>aws-auth</code> <code>ConfigMap</code> for authentication. You have the following options for authorizing an IAM principal to access Kubernetes objects on your cluster: Kubernetes role-based access control (RBAC), Amazon EKS, or both. Kubernetes RBAC authorization requires you to create and manage Kubernetes <code>Role</code>, <code>ClusterRole</code>, <code>RoleBinding</code>, and <code>ClusterRoleBinding</code> objects, in addition to managing access entries. If you use Amazon EKS authorization exclusively, you don\'t need to create and manage Kubernetes <code>Role</code>, <code>ClusterRole</code>, <code>RoleBinding</code>, and <code>ClusterRoleBinding</code> objects.</p> <p>For more information about access entries, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/access-entries.html">Access entries</a> in the <i>Amazon EKS User Guide</i>.</p>', 'CreateAddon' => '<p>Creates an Amazon EKS add-on.</p> <p>Amazon EKS add-ons help to automate the provisioning and lifecycle management of common operational software for Amazon EKS clusters. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/eks-add-ons.html">Amazon EKS add-ons</a> in the <i>Amazon EKS User Guide</i>.</p>', 'CreateCluster' => '<p>Creates an Amazon EKS control plane.</p> <p>The Amazon EKS control plane consists of control plane instances that run the Kubernetes software, such as <code>etcd</code> and the API server. The control plane runs in an account managed by Amazon Web Services, and the Kubernetes API is exposed by the Amazon EKS API server endpoint. Each Amazon EKS cluster control plane is single tenant and unique. It runs on its own set of Amazon EC2 instances.</p> <p>The cluster control plane is provisioned across multiple Availability Zones and fronted by an Elastic Load Balancing Network Load Balancer. Amazon EKS also provisions elastic network interfaces in your VPC subnets to provide connectivity from the control plane instances to the nodes (for example, to support <code>kubectl exec</code>, <code>logs</code>, and <code>proxy</code> data flows).</p> <p>Amazon EKS nodes run in your Amazon Web Services account and connect to your cluster\'s control plane over the Kubernetes API server endpoint and a certificate file that is created for your cluster.</p> <p>You can use the <code>endpointPublicAccess</code> and <code>endpointPrivateAccess</code> parameters to enable or disable public and private access to your cluster\'s Kubernetes API server endpoint. By default, public access is enabled, and private access is disabled. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Amazon EKS Cluster Endpoint Access Control</a> in the <i> <i>Amazon EKS User Guide</i> </i>. </p> <p>You can use the <code>logging</code> parameter to enable or disable exporting the Kubernetes control plane logs for your cluster to CloudWatch Logs. By default, cluster control plane logs aren\'t exported to CloudWatch Logs. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html">Amazon EKS Cluster Control Plane Logs</a> in the <i> <i>Amazon EKS User Guide</i> </i>.</p> <note> <p>CloudWatch Logs ingestion, archive storage, and data scanning rates apply to exported control plane logs. For more information, see <a href="http://aws.amazon.com/cloudwatch/pricing/">CloudWatch Pricing</a>.</p> </note> <p>In most cases, it takes several minutes to create a cluster. After you create an Amazon EKS cluster, you must configure your Kubernetes tooling to communicate with the API server and launch nodes into your cluster. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-auth.html">Allowing users to access your cluster</a> and <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-workers.html">Launching Amazon EKS nodes</a> in the <i>Amazon EKS User Guide</i>.</p>', 'CreateEksAnywhereSubscription' => '<p>Creates an EKS Anywhere subscription. When a subscription is created, it is a contract agreement for the length of the term specified in the request. Licenses that are used to validate support are provisioned in Amazon Web Services License Manager and the caller account is granted access to EKS Anywhere Curated Packages.</p>', 'CreateFargateProfile' => '<p>Creates an Fargate profile for your Amazon EKS cluster. You must have at least one Fargate profile in a cluster to be able to run pods on Fargate.</p> <p>The Fargate profile allows an administrator to declare which pods run on Fargate and specify which pods run on which Fargate profile. This declaration is done through the profile’s selectors. Each profile can have up to five selectors that contain a namespace and labels. A namespace is required for every selector. The label field consists of multiple optional key-value pairs. Pods that match the selectors are scheduled on Fargate. If a to-be-scheduled pod matches any of the selectors in the Fargate profile, then that pod is run on Fargate.</p> <p>When you create a Fargate profile, you must specify a pod execution role to use with the pods that are scheduled with the profile. This role is added to the cluster\'s Kubernetes <a href="https://kubernetes.io/docs/reference/access-authn-authz/rbac/">Role Based Access Control</a> (RBAC) for authorization so that the <code>kubelet</code> that is running on the Fargate infrastructure can register with your Amazon EKS cluster so that it can appear in your cluster as a node. The pod execution role also provides IAM permissions to the Fargate infrastructure to allow read access to Amazon ECR image repositories. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/pod-execution-role.html">Pod Execution Role</a> in the <i>Amazon EKS User Guide</i>.</p> <p>Fargate profiles are immutable. However, you can create a new updated profile to replace an existing profile and then delete the original after the updated profile has finished creating.</p> <p>If any Fargate profiles in a cluster are in the <code>DELETING</code> status, you must wait for that Fargate profile to finish deleting before you can create any other profiles in that cluster.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/fargate-profile.html">Fargate profile</a> in the <i>Amazon EKS User Guide</i>.</p>', 'CreateNodegroup' => '<p>Creates a managed node group for an Amazon EKS cluster.</p> <p>You can only create a node group for your cluster that is equal to the current Kubernetes version for the cluster. All node groups are created with the latest AMI release version for the respective minor Kubernetes version of the cluster, unless you deploy a custom AMI using a launch template. For more information about using launch templates, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Customizing managed nodes with launch templates</a>.</p> <p>An Amazon EKS managed node group is an Amazon EC2 Auto Scaling group and associated Amazon EC2 instances that are managed by Amazon Web Services for an Amazon EKS cluster. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/managed-node-groups.html">Managed node groups</a> in the <i>Amazon EKS User Guide</i>.</p> <note> <p>Windows AMI types are only supported for commercial Amazon Web Services Regions that support Windows on Amazon EKS.</p> </note>', 'CreatePodIdentityAssociation' => '<p>Creates an EKS Pod Identity association between a service account in an Amazon EKS cluster and an IAM role with <i>EKS Pod Identity</i>. Use EKS Pod Identity to give temporary IAM credentials to pods and the credentials are rotated automatically.</p> <p>Amazon EKS Pod Identity associations provide the ability to manage credentials for your applications, similar to the way that Amazon EC2 instance profiles provide credentials to Amazon EC2 instances.</p> <p>If a pod uses a service account that has an association, Amazon EKS sets environment variables in the containers of the pod. The environment variables configure the Amazon Web Services SDKs, including the Command Line Interface, to use the EKS Pod Identity credentials.</p> <p>Pod Identity is a simpler method than <i>IAM roles for service accounts</i>, as this method doesn\'t use OIDC identity providers. Additionally, you can configure a role for Pod Identity once, and reuse it across clusters.</p>', 'DeleteAccessEntry' => '<p>Deletes an access entry.</p> <p>Deleting an access entry of a type other than <code>Standard</code> can cause your cluster to function improperly. If you delete an access entry in error, you can recreate it.</p>', 'DeleteAddon' => '<p>Deletes an Amazon EKS add-on.</p> <p>When you remove an add-on, it\'s deleted from the cluster. You can always manually start an add-on on the cluster using the Kubernetes API.</p>', 'DeleteCluster' => '<p>Deletes an Amazon EKS cluster control plane.</p> <p>If you have active services in your cluster that are associated with a load balancer, you must delete those services before deleting the cluster so that the load balancers are deleted properly. Otherwise, you can have orphaned resources in your VPC that prevent you from being able to delete the VPC. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/delete-cluster.html">Deleting a cluster</a> in the <i>Amazon EKS User Guide</i>.</p> <p>If you have managed node groups or Fargate profiles attached to the cluster, you must delete them first. For more information, see <code>DeleteNodgroup</code> and <code>DeleteFargateProfile</code>.</p>', 'DeleteEksAnywhereSubscription' => '<p>Deletes an expired or inactive subscription. Deleting inactive subscriptions removes them from the Amazon Web Services Management Console view and from list/describe API responses. Subscriptions can only be cancelled within 7 days of creation and are cancelled by creating a ticket in the Amazon Web Services Support Center. </p>', 'DeleteFargateProfile' => '<p>Deletes an Fargate profile.</p> <p>When you delete a Fargate profile, any <code>Pod</code> running on Fargate that was created with the profile is deleted. If the <code>Pod</code> matches another Fargate profile, then it is scheduled on Fargate with that profile. If it no longer matches any Fargate profiles, then it\'s not scheduled on Fargate and may remain in a pending state.</p> <p>Only one Fargate profile in a cluster can be in the <code>DELETING</code> status at a time. You must wait for a Fargate profile to finish deleting before you can delete any other profiles in that cluster.</p>', 'DeleteNodegroup' => '<p>Deletes a managed node group.</p>', 'DeletePodIdentityAssociation' => '<p>Deletes a EKS Pod Identity association.</p> <p>The temporary Amazon Web Services credentials from the previous IAM role session might still be valid until the session expiry. If you need to immediately revoke the temporary session credentials, then go to the role in the IAM console.</p>', 'DeregisterCluster' => '<p>Deregisters a connected cluster to remove it from the Amazon EKS control plane.</p> <p>A connected cluster is a Kubernetes cluster that you\'ve connected to your control plane using the <a href="https://docs.aws.amazon.com/eks/latest/userguide/eks-connector.html">Amazon EKS Connector</a>.</p>', 'DescribeAccessEntry' => '<p>Describes an access entry.</p>', 'DescribeAddon' => '<p>Describes an Amazon EKS add-on.</p>', 'DescribeAddonConfiguration' => '<p>Returns configuration options.</p>', 'DescribeAddonVersions' => '<p>Describes the versions for an add-on.</p> <p>Information such as the Kubernetes versions that you can use the add-on with, the <code>owner</code>, <code>publisher</code>, and the <code>type</code> of the add-on are returned.</p>', 'DescribeCluster' => '<p>Describes an Amazon EKS cluster.</p> <p>The API server endpoint and certificate authority data returned by this operation are required for <code>kubelet</code> and <code>kubectl</code> to communicate with your Kubernetes API server. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/create-kubeconfig.html">Creating or updating a <code>kubeconfig</code> file for an Amazon EKS cluster</a>.</p> <note> <p>The API server endpoint and certificate authority data aren\'t available until the cluster reaches the <code>ACTIVE</code> state.</p> </note>', 'DescribeEksAnywhereSubscription' => '<p>Returns descriptive information about a subscription.</p>', 'DescribeFargateProfile' => '<p>Describes an Fargate profile.</p>', 'DescribeIdentityProviderConfig' => '<p>Describes an identity provider configuration.</p>', 'DescribeInsight' => '<p>Returns details about an insight that you specify using its ID.</p>', 'DescribeNodegroup' => '<p>Describes a managed node group.</p>', 'DescribePodIdentityAssociation' => '<p>Returns descriptive information about an EKS Pod Identity association.</p> <p>This action requires the ID of the association. You can get the ID from the response to the <code>CreatePodIdentityAssocation</code> for newly created associations. Or, you can list the IDs for associations with <code>ListPodIdentityAssociations</code> and filter the list by namespace or service account.</p>', 'DescribeUpdate' => '<p>Describes an update to an Amazon EKS resource.</p> <p>When the status of the update is <code>Succeeded</code>, the update is complete. If an update fails, the status is <code>Failed</code>, and an error detail explains the reason for the failure.</p>', 'DisassociateAccessPolicy' => '<p>Disassociates an access policy from an access entry.</p>', 'DisassociateIdentityProviderConfig' => '<p>Disassociates an identity provider configuration from a cluster.</p> <p>If you disassociate an identity provider from your cluster, users included in the provider can no longer access the cluster. However, you can still access the cluster with IAM principals.</p>', 'ListAccessEntries' => '<p>Lists the access entries for your cluster.</p>', 'ListAccessPolicies' => '<p>Lists the available access policies. </p>', 'ListAddons' => '<p>Lists the installed add-ons.</p>', 'ListAssociatedAccessPolicies' => '<p>Lists the access policies associated with an access entry.</p>', 'ListClusters' => '<p>Lists the Amazon EKS clusters in your Amazon Web Services account in the specified Amazon Web Services Region.</p>', 'ListEksAnywhereSubscriptions' => '<p>Displays the full description of the subscription.</p>', 'ListFargateProfiles' => '<p>Lists the Fargate profiles associated with the specified cluster in your Amazon Web Services account in the specified Amazon Web Services Region.</p>', 'ListIdentityProviderConfigs' => '<p>Lists the identity provider configurations for your cluster.</p>', 'ListInsights' => '<p>Returns a list of all insights checked for against the specified cluster. You can filter which insights are returned by category, associated Kubernetes version, and status.</p>', 'ListNodegroups' => '<p>Lists the managed node groups associated with the specified cluster in your Amazon Web Services account in the specified Amazon Web Services Region. Self-managed node groups aren\'t listed.</p>', 'ListPodIdentityAssociations' => '<p>List the EKS Pod Identity associations in a cluster. You can filter the list by the namespace that the association is in or the service account that the association uses.</p>', 'ListTagsForResource' => '<p>List the tags for an Amazon EKS resource.</p>', 'ListUpdates' => '<p>Lists the updates associated with an Amazon EKS resource in your Amazon Web Services account, in the specified Amazon Web Services Region.</p>', 'RegisterCluster' => '<p>Connects a Kubernetes cluster to the Amazon EKS control plane. </p> <p>Any Kubernetes cluster can be connected to the Amazon EKS control plane to view current information about the cluster and its nodes. </p> <p>Cluster connection requires two steps. First, send a <code> <a>RegisterClusterRequest</a> </code> to add it to the Amazon EKS control plane.</p> <p>Second, a <a href="https://amazon-eks.s3.us-west-2.amazonaws.com/eks-connector/manifests/eks-connector/latest/eks-connector.yaml">Manifest</a> containing the <code>activationID</code> and <code>activationCode</code> must be applied to the Kubernetes cluster through it\'s native provider to provide visibility.</p> <p>After the manifest is updated and applied, the connected cluster is visible to the Amazon EKS control plane. If the manifest isn\'t applied within three days, the connected cluster will no longer be visible and must be deregistered using <code>DeregisterCluster</code>.</p>', 'TagResource' => '<p>Associates the specified tags to an Amazon EKS resource with the specified <code>resourceArn</code>. If existing tags on a resource are not specified in the request parameters, they aren\'t changed. When a resource is deleted, the tags associated with that resource are also deleted. Tags that you create for Amazon EKS resources don\'t propagate to any other resources associated with the cluster. For example, if you tag a cluster with this operation, that tag doesn\'t automatically propagate to the subnets and nodes associated with the cluster.</p>', 'UntagResource' => '<p>Deletes specified tags from an Amazon EKS resource.</p>', 'UpdateAccessEntry' => '<p>Updates an access entry.</p>', 'UpdateAddon' => '<p>Updates an Amazon EKS add-on.</p>', 'UpdateClusterConfig' => '<p>Updates an Amazon EKS cluster configuration. Your cluster continues to function during the update. The response output includes an update ID that you can use to track the status of your cluster update with <code>DescribeUpdate</code>"/&gt;.</p> <p>You can use this API operation to enable or disable exporting the Kubernetes control plane logs for your cluster to CloudWatch Logs. By default, cluster control plane logs aren\'t exported to CloudWatch Logs. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html">Amazon EKS Cluster control plane logs</a> in the <i> <i>Amazon EKS User Guide</i> </i>.</p> <note> <p>CloudWatch Logs ingestion, archive storage, and data scanning rates apply to exported control plane logs. For more information, see <a href="http://aws.amazon.com/cloudwatch/pricing/">CloudWatch Pricing</a>.</p> </note> <p>You can also use this API operation to enable or disable public and private access to your cluster\'s Kubernetes API server endpoint. By default, public access is enabled, and private access is disabled. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Amazon EKS cluster endpoint access control</a> in the <i> <i>Amazon EKS User Guide</i> </i>.</p> <p>You can also use this API operation to choose different subnets and security groups for the cluster. You must specify at least two subnets that are in different Availability Zones. You can\'t change which VPC the subnets are from, the subnets must be in the same VPC as the subnets that the cluster was created with. For more information about the VPC requirements, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html">https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html</a> in the <i> <i>Amazon EKS User Guide</i> </i>.</p> <p>Cluster updates are asynchronous, and they should finish within a few minutes. During an update, the cluster status moves to <code>UPDATING</code> (this status transition is eventually consistent). When the update is complete (either <code>Failed</code> or <code>Successful</code>), the cluster status moves to <code>Active</code>.</p>', 'UpdateClusterVersion' => '<p>Updates an Amazon EKS cluster to the specified Kubernetes version. Your cluster continues to function during the update. The response output includes an update ID that you can use to track the status of your cluster update with the <a>DescribeUpdate</a> API operation.</p> <p>Cluster updates are asynchronous, and they should finish within a few minutes. During an update, the cluster status moves to <code>UPDATING</code> (this status transition is eventually consistent). When the update is complete (either <code>Failed</code> or <code>Successful</code>), the cluster status moves to <code>Active</code>.</p> <p>If your cluster has managed node groups attached to it, all of your node groups’ Kubernetes versions must match the cluster’s Kubernetes version in order to update the cluster to a new Kubernetes version.</p>', 'UpdateEksAnywhereSubscription' => '<p>Update an EKS Anywhere Subscription. Only auto renewal and tags can be updated after subscription creation.</p>', 'UpdateNodegroupConfig' => '<p>Updates an Amazon EKS managed node group configuration. Your node group continues to function during the update. The response output includes an update ID that you can use to track the status of your node group update with the <a>DescribeUpdate</a> API operation. Currently you can update the Kubernetes labels for a node group or the scaling configuration.</p>', 'UpdateNodegroupVersion' => '<p>Updates the Kubernetes version or AMI version of an Amazon EKS managed node group.</p> <p>You can update a node group using a launch template only if the node group was originally deployed with a launch template. If you need to update a custom AMI in a node group that was deployed with a launch template, then update your custom AMI, specify the new ID in a new version of the launch template, and then update the node group to the new version of the launch template.</p> <p>If you update without a launch template, then you can update to the latest available AMI version of a node group\'s current Kubernetes version by not specifying a Kubernetes version in the request. You can update to the latest AMI version of your cluster\'s current Kubernetes version by specifying your cluster\'s Kubernetes version in the request. For information about Linux versions, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html">Amazon EKS optimized Amazon Linux AMI versions</a> in the <i>Amazon EKS User Guide</i>. For information about Windows versions, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/eks-ami-versions-windows.html">Amazon EKS optimized Windows AMI versions</a> in the <i>Amazon EKS User Guide</i>. </p> <p>You cannot roll back a node group to an earlier Kubernetes version or AMI version.</p> <p>When a node in a managed node group is terminated due to a scaling action or update, every <code>Pod</code> on that node is drained first. Amazon EKS attempts to drain the nodes gracefully and will fail if it is unable to do so. You can <code>force</code> the update if Amazon EKS is unable to drain the nodes as a result of a <code>Pod</code> disruption budget issue.</p>', 'UpdatePodIdentityAssociation' => '<p>Updates a EKS Pod Identity association. Only the IAM role can be changed; an association can\'t be moved between clusters, namespaces, or service accounts. If you need to edit the namespace or service account, you need to delete the association and then create a new association with your desired settings.</p>', ], 'shapes' => [ 'AMITypes' => [ 'base' => NULL, 'refs' => [ 'CreateNodegroupRequest$amiType' => '<p>The AMI type for your node group. If you specify <code>launchTemplate</code>, and your launch template uses a custom AMI, then don\'t specify <code>amiType</code>, or the node group deployment will fail. If your launch template uses a Windows custom AMI, then add <code>eks:kube-proxy-windows</code> to your Windows nodes <code>rolearn</code> in the <code>aws-auth</code> <code>ConfigMap</code>. For more information about using launch templates with Amazon EKS, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Customizing managed nodes with launch templates</a> in the <i>Amazon EKS User Guide</i>.</p>', 'Nodegroup$amiType' => '<p>If the node group was deployed using a launch template with a custom AMI, then this is <code>CUSTOM</code>. For node groups that weren\'t deployed using a launch template, this is the AMI type that was specified in the node group configuration.</p>', ], ], 'AccessConfigResponse' => [ 'base' => '<p>The access configuration for the cluster.</p>', 'refs' => [ 'Cluster$accessConfig' => '<p>The access configuration for the cluster.</p>', ], ], 'AccessDeniedException' => [ 'base' => '<p>You don\'t have permissions to perform the requested operation. The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html">IAM principal</a> making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access management</a> in the <i>IAM User Guide</i>. </p>', 'refs' => [], ], 'AccessEntry' => [ 'base' => '<p>An access entry allows an IAM principal (user or role) to access your cluster. Access entries can replace the need to maintain the <code>aws-auth</code> <code>ConfigMap</code> for authentication. For more information about access entries, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/access-entries.html">Access entries</a> in the <i>Amazon EKS User Guide</i>.</p>', 'refs' => [ 'CreateAccessEntryResponse$accessEntry' => NULL, 'DescribeAccessEntryResponse$accessEntry' => '<p>Information about the access entry.</p>', 'UpdateAccessEntryResponse$accessEntry' => '<p>The ARN of the IAM principal for the <code>AccessEntry</code>.</p>', ], ], 'AccessPoliciesList' => [ 'base' => NULL, 'refs' => [ 'ListAccessPoliciesResponse$accessPolicies' => '<p>The list of available access policies. You can\'t view the contents of an access policy using the API. To view the contents, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/access-policies.html#access-policy-permissions">Access policy permissions</a> in the <i>Amazon EKS User Guide</i>.</p>', ], ], 'AccessPolicy' => [ 'base' => '<p>An access policy includes permissions that allow Amazon EKS to authorize an IAM principal to work with Kubernetes objects on your cluster. The policies are managed by Amazon EKS, but they\'re not IAM policies. You can\'t view the permissions in the policies using the API. The permissions for many of the policies are similar to the Kubernetes <code>cluster-admin</code>, <code>admin</code>, <code>edit</code>, and <code>view</code> cluster roles. For more information about these cluster roles, see <a href="https://kubernetes.io/docs/reference/access-authn-authz/rbac/#user-facing-roles">User-facing roles</a> in the Kubernetes documentation. To view the contents of the policies, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/access-policies.html#access-policy-permissions">Access policy permissions</a> in the <i>Amazon EKS User Guide</i>.</p>', 'refs' => [ 'AccessPoliciesList$member' => NULL, ], ], 'AccessScope' => [ 'base' => '<p>The scope of an <code>AccessPolicy</code> that\'s associated to an <code>AccessEntry</code>.</p>', 'refs' => [ 'AssociateAccessPolicyRequest$accessScope' => '<p>The scope for the <code>AccessPolicy</code>. You can scope access policies to an entire cluster or to specific Kubernetes namespaces.</p>', 'AssociatedAccessPolicy$accessScope' => '<p>The scope of the access policy.</p>', ], ], 'AccessScopeType' => [ 'base' => NULL, 'refs' => [ 'AccessScope$type' => '<p>The scope type of an access policy.</p>', ], ], 'AdditionalInfoMap' => [ 'base' => NULL, 'refs' => [ 'Insight$additionalInfo' => '<p>Links to sources that provide additional context on the insight.</p>', ], ], 'Addon' => [ 'base' => '<p>An Amazon EKS add-on. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/eks-add-ons.html">Amazon EKS add-ons</a> in the <i>Amazon EKS User Guide</i>.</p>', 'refs' => [ 'CreateAddonResponse$addon' => NULL, 'DeleteAddonResponse$addon' => NULL, 'DescribeAddonResponse$addon' => NULL, ], ], 'AddonHealth' => [ 'base' => '<p>The health of the add-on.</p>', 'refs' => [ 'Addon$health' => '<p>An object that represents the health of the add-on.</p>', ], ], 'AddonInfo' => [ 'base' => '<p>Information about an add-on.</p>', 'refs' => [ 'Addons$member' => NULL, ], ], 'AddonIssue' => [ 'base' => '<p>An issue related to an add-on.</p>', 'refs' => [ 'AddonIssueList$member' => NULL, ], ], 'AddonIssueCode' => [ 'base' => NULL, 'refs' => [ 'AddonIssue$code' => '<p>A code that describes the type of issue.</p>', ], ], 'AddonIssueList' => [ 'base' => NULL, 'refs' => [ 'AddonHealth$issues' => '<p>An object representing the health issues for an add-on.</p>', ], ], 'AddonPodIdentityAssociations' => [ 'base' => '<p>A type of Pod Identity Association owned by an Amazon EKS Add-on.</p> <p>Each EKS Pod Identity Association maps a role to a service account in a namespace in the cluster.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/add-ons-iam.html">Attach an IAM Role to an Amazon EKS add-on using Pod Identity</a> in the EKS User Guide.</p>', 'refs' => [ 'AddonPodIdentityAssociationsList$member' => NULL, ], ], 'AddonPodIdentityAssociationsList' => [ 'base' => NULL, 'refs' => [ 'CreateAddonRequest$podIdentityAssociations' => '<p>An array of Pod Identity Assocations to be created. Each EKS Pod Identity association maps a Kubernetes service account to an IAM Role.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/add-ons-iam.html">Attach an IAM Role to an Amazon EKS add-on using Pod Identity</a> in the EKS User Guide.</p>', 'UpdateAddonRequest$podIdentityAssociations' => '<p>An array of Pod Identity Assocations to be updated. Each EKS Pod Identity association maps a Kubernetes service account to an IAM Role. If this value is left blank, no change. If an empty array is provided, existing Pod Identity Assocations owned by the Addon are deleted.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/add-ons-iam.html">Attach an IAM Role to an Amazon EKS add-on using Pod Identity</a> in the EKS User Guide.</p>', ], ], 'AddonPodIdentityConfiguration' => [ 'base' => '<p>Information about how to configure IAM for an Addon.</p>', 'refs' => [ 'AddonPodIdentityConfigurationList$member' => NULL, ], ], 'AddonPodIdentityConfigurationList' => [ 'base' => NULL, 'refs' => [ 'DescribeAddonConfigurationResponse$podIdentityConfiguration' => '<p>The Kubernetes service account name used by the addon, and any suggested IAM policies. Use this information to create an IAM Role for the Addon.</p>', ], ], 'AddonStatus' => [ 'base' => NULL, 'refs' => [ 'Addon$status' => '<p>The status of the add-on.</p>', ], ], 'AddonVersionInfo' => [ 'base' => '<p>Information about an add-on version.</p>', 'refs' => [ 'AddonVersionInfoList$member' => NULL, ], ], 'AddonVersionInfoList' => [ 'base' => NULL, 'refs' => [ 'AddonInfo$addonVersions' => '<p>An object representing information about available add-on versions and compatible Kubernetes versions.</p>', ], ], 'Addons' => [ 'base' => NULL, 'refs' => [ 'DescribeAddonVersionsResponse$addons' => '<p>The list of available versions with Kubernetes version compatibility and other properties.</p>', ], ], 'AssociateAccessPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateAccessPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociateEncryptionConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateEncryptionConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociateIdentityProviderConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateIdentityProviderConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociatedAccessPoliciesList' => [ 'base' => NULL, 'refs' => [ 'ListAssociatedAccessPoliciesResponse$associatedAccessPolicies' => '<p>The list of access policies associated with the access entry.</p>', ], ], 'AssociatedAccessPolicy' => [ 'base' => '<p>An access policy association.</p>', 'refs' => [ 'AssociateAccessPolicyResponse$associatedAccessPolicy' => '<p>The <code>AccessPolicy</code> and scope associated to the <code>AccessEntry</code>.</p>', 'AssociatedAccessPoliciesList$member' => NULL, ], ], 'AuthenticationMode' => [ 'base' => NULL, 'refs' => [ 'AccessConfigResponse$authenticationMode' => '<p>The current authentication mode of the cluster.</p>', 'CreateAccessConfigRequest$authenticationMode' => '<p>The desired authentication mode for the cluster. If you create a cluster by using the EKS API, Amazon Web Services SDKs, or CloudFormation, the default is <code>CONFIG_MAP</code>. If you create the cluster by using the Amazon Web Services Management Console, the default value is <code>API_AND_CONFIG_MAP</code>.</p>', 'UpdateAccessConfigRequest$authenticationMode' => '<p>The desired authentication mode for the cluster.</p>', ], ], 'AutoScalingGroup' => [ 'base' => '<p>An Auto Scaling group that is associated with an Amazon EKS managed node group.</p>', 'refs' => [ 'AutoScalingGroupList$member' => NULL, ], ], 'AutoScalingGroupList' => [ 'base' => NULL, 'refs' => [ 'NodegroupResources$autoScalingGroups' => '<p>The Auto Scaling groups associated with the node group.</p>', ], ], 'BadRequestException' => [ 'base' => '<p>This exception is thrown if the request contains a semantic error. The precise meaning will depend on the API, and will be documented in the error message.</p>', 'refs' => [], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'AddonVersionInfo$requiresConfiguration' => '<p>Whether the add-on requires configuration.</p>', 'AddonVersionInfo$requiresIamPermissions' => '<p>Indicates if the Addon requires IAM Permissions to operate, such as networking permissions.</p>', 'Compatibility$defaultVersion' => '<p>The supported default version.</p>', 'CreateEksAnywhereSubscriptionRequest$autoRenew' => '<p>A boolean indicating whether the subscription auto renews at the end of the term.</p>', 'DeleteAddonRequest$preserve' => '<p>Specifying this option preserves the add-on software on your cluster but Amazon EKS stops managing any settings for the add-on. If an IAM account is associated with the add-on, it isn\'t removed.</p>', 'EksAnywhereSubscription$autoRenew' => '<p>A boolean indicating whether or not a subscription will auto renew when it expires.</p>', 'UpdateEksAnywhereSubscriptionRequest$autoRenew' => '<p>A boolean indicating whether or not to automatically renew the subscription.</p>', 'UpdateNodegroupVersionRequest$force' => '<p>Force the update if any <code>Pod</code> on the existing node group can\'t be drained due to a <code>Pod</code> disruption budget issue. If an update fails because all Pods can\'t be drained, you can force the update after it fails to terminate the old node whether or not any <code>Pod</code> is running on the node.</p>', 'VpcConfigResponse$endpointPublicAccess' => '<p>Whether the public API server endpoint is enabled.</p>', 'VpcConfigResponse$endpointPrivateAccess' => '<p>This parameter indicates whether the Amazon EKS private API server endpoint is enabled. If the Amazon EKS private API server endpoint is enabled, Kubernetes API requests that originate from within your cluster\'s VPC use the private VPC endpoint instead of traversing the internet. If this value is disabled and you have nodes or Fargate pods in the cluster, then ensure that <code>publicAccessCidrs</code> includes the necessary CIDR blocks for communication with the nodes or Fargate pods. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Amazon EKS cluster endpoint access control</a> in the <i> <i>Amazon EKS User Guide</i> </i>.</p>', ], ], 'BoxedBoolean' => [ 'base' => NULL, 'refs' => [ 'AccessConfigResponse$bootstrapClusterCreatorAdminPermissions' => '<p>Specifies whether or not the cluster creator IAM principal was set as a cluster admin access entry during cluster creation time.</p>', 'CreateAccessConfigRequest$bootstrapClusterCreatorAdminPermissions' => '<p>Specifies whether or not the cluster creator IAM principal was set as a cluster admin access entry during cluster creation time. The default value is <code>true</code>.</p>', 'CreateClusterRequest$bootstrapSelfManagedAddons' => '<p>If you set this value to <code>False</code> when creating a cluster, the default networking add-ons will not be installed.</p> <p>The default networking addons include vpc-cni, coredns, and kube-proxy.</p> <p>Use this option when you plan to install third-party alternative add-ons or self-manage the default networking add-ons.</p>', 'LogSetup$enabled' => '<p>If a log type is enabled, that log type exports its control plane logs to CloudWatch Logs. If a log type isn\'t enabled, that log type doesn\'t export its control plane logs. Each individual log type can be enabled or disabled independently.</p>', 'VpcConfigRequest$endpointPublicAccess' => '<p>Set this value to <code>false</code> to disable public access to your cluster\'s Kubernetes API server endpoint. If you disable public access, your cluster\'s Kubernetes API server can only receive requests from within the cluster VPC. The default value for this parameter is <code>true</code>, which enables public access for your Kubernetes API server. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Amazon EKS cluster endpoint access control</a> in the <i> <i>Amazon EKS User Guide</i> </i>.</p>', 'VpcConfigRequest$endpointPrivateAccess' => '<p>Set this value to <code>true</code> to enable private access for your cluster\'s Kubernetes API server endpoint. If you enable private access, Kubernetes API requests from within your cluster\'s VPC use the private VPC endpoint. The default value for this parameter is <code>false</code>, which disables private access for your Kubernetes API server. If you disable private access and you have nodes or Fargate pods in the cluster, then ensure that <code>publicAccessCidrs</code> includes the necessary CIDR blocks for communication with the nodes or Fargate pods. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Amazon EKS cluster endpoint access control</a> in the <i> <i>Amazon EKS User Guide</i> </i>.</p>', ], ], 'BoxedInteger' => [ 'base' => NULL, 'refs' => [ 'CreateNodegroupRequest$diskSize' => '<p>The root device disk size (in GiB) for your node group instances. The default disk size is 20 GiB for Linux and Bottlerocket. The default disk size is 50 GiB for Windows. If you specify <code>launchTemplate</code>, then don\'t specify <code>diskSize</code>, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Customizing managed nodes with launch templates</a> in the <i>Amazon EKS User Guide</i>.</p>', 'Nodegroup$diskSize' => '<p>If the node group wasn\'t deployed with a launch template, then this is the disk size in the node group configuration. If the node group was deployed with a launch template, then this is <code>null</code>.</p>', ], ], 'Capacity' => [ 'base' => NULL, 'refs' => [ 'NodegroupScalingConfig$maxSize' => '<p>The maximum number of nodes that the managed node group can scale out to. For information about the maximum number that you can specify, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/service-quotas.html">Amazon EKS service quotas</a> in the <i>Amazon EKS User Guide</i>.</p>', ], ], 'CapacityTypes' => [ 'base' => NULL, 'refs' => [ 'CreateNodegroupRequest$capacityType' => '<p>The capacity type for your node group.</p>', 'Nodegroup$capacityType' => '<p>The capacity type of your managed node group.</p>', ], ], 'Category' => [ 'base' => NULL, 'refs' => [ 'CategoryList$member' => NULL, 'Insight$category' => '<p>The category of the insight.</p>', 'InsightSummary$category' => '<p>The category of the insight.</p>', ], ], 'CategoryList' => [ 'base' => NULL, 'refs' => [ 'InsightsFilter$categories' => '<p>The categories to use to filter insights.</p>', ], ], 'Certificate' => [ 'base' => '<p>An object representing the <code>certificate-authority-data</code> for your cluster.</p>', 'refs' => [ 'Cluster$certificateAuthority' => '<p>The <code>certificate-authority-data</code> for your cluster.</p>', ], ], 'ClientException' => [ 'base' => '<p>These errors are usually caused by a client action. Actions can include using an action or resource on behalf of an <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html">IAM principal</a> that doesn\'t have permissions to use the action or resource or specifying an identifier that is not valid.</p>', 'refs' => [], ], 'ClientStat' => [ 'base' => '<p>Details about clients using the deprecated resources.</p>', 'refs' => [ 'ClientStats$member' => NULL, ], ], 'ClientStats' => [ 'base' => NULL, 'refs' => [ 'DeprecationDetail$clientStats' => '<p>Details about Kubernetes clients using the deprecated resources.</p>', ], ], 'Cluster' => [ 'base' => '<p>An object representing an Amazon EKS cluster.</p>', 'refs' => [ 'CreateClusterResponse$cluster' => '<p>The full description of your new cluster.</p>', 'DeleteClusterResponse$cluster' => '<p>The full description of the cluster to delete.</p>', 'DeregisterClusterResponse$cluster' => NULL, 'DescribeClusterResponse$cluster' => '<p>The full description of your specified cluster.</p>', 'RegisterClusterResponse$cluster' => NULL, ], ], 'ClusterHealth' => [ 'base' => '<p>An object representing the health of your Amazon EKS cluster.</p>', 'refs' => [ 'Cluster$health' => '<p>An object representing the health of your Amazon EKS cluster.</p>', ], ], 'ClusterIssue' => [ 'base' => '<p>An issue with your Amazon EKS cluster.</p>', 'refs' => [ 'ClusterIssueList$member' => NULL, ], ], 'ClusterIssueCode' => [ 'base' => NULL, 'refs' => [ 'ClusterIssue$code' => '<p>The error code of the issue.</p>', ], ], 'ClusterIssueList' => [ 'base' => NULL, 'refs' => [ 'ClusterHealth$issues' => '<p>An object representing the health issues of your Amazon EKS cluster.</p>', ], ], 'ClusterName' => [ 'base' => NULL, 'refs' => [ 'Addon$clusterName' => '<p>The name of your cluster.</p>', 'CreateAddonRequest$clusterName' => '<p>The name of your cluster.</p>', 'CreateClusterRequest$name' => '<p>The unique name to give to your cluster.</p>', 'DeleteAddonRequest$clusterName' => '<p>The name of your cluster.</p>', 'DescribeAddonRequest$clusterName' => '<p>The name of your cluster.</p>', 'ListAddonsRequest$clusterName' => '<p>The name of your cluster.</p>', 'RegisterClusterRequest$name' => '<p>A unique name for this cluster in your Amazon Web Services Region.</p>', 'UpdateAddonRequest$clusterName' => '<p>The name of your cluster.</p>', ], ], 'ClusterStatus' => [ 'base' => NULL, 'refs' => [ 'Cluster$status' => '<p>The current status of the cluster.</p>', ], ], 'Compatibilities' => [ 'base' => NULL, 'refs' => [ 'AddonVersionInfo$compatibilities' => '<p>An object representing the compatibilities of a version.</p>', ], ], 'Compatibility' => [ 'base' => '<p>Compatibility information.</p>', 'refs' => [ 'Compatibilities$member' => NULL, ], ], 'ConnectorConfigProvider' => [ 'base' => NULL, 'refs' => [ 'ConnectorConfigRequest$provider' => '<p>The cloud provider for the target cluster to connect.</p>', ], ], 'ConnectorConfigRequest' => [ 'base' => '<p>The configuration sent to a cluster for configuration.</p>', 'refs' => [ 'RegisterClusterRequest$connectorConfig' => '<p>The configuration settings required to connect the Kubernetes cluster to the Amazon EKS control plane.</p>', ], ], 'ConnectorConfigResponse' => [ 'base' => '<p>The full description of your connected cluster.</p>', 'refs' => [ 'Cluster$connectorConfig' => '<p>The configuration used to connect to a cluster for registration.</p>', ], ], 'ControlPlanePlacementRequest' => [ 'base' => '<p>The placement configuration for all the control plane instances of your local Amazon EKS cluster on an Amazon Web Services Outpost. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/eks-outposts-capacity-considerations.html">Capacity considerations</a> in the Amazon EKS User Guide.</p>', 'refs' => [ 'OutpostConfigRequest$controlPlanePlacement' => '<p>An object representing the placement configuration for all the control plane instances of your local Amazon EKS cluster on an Amazon Web Services Outpost. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/eks-outposts-capacity-considerations.html">Capacity considerations</a> in the <i>Amazon EKS User Guide</i>.</p>', ], ], 'ControlPlanePlacementResponse' => [ 'base' => '<p>The placement configuration for all the control plane instances of your local Amazon EKS cluster on an Amazon Web Services Outpost. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/eks-outposts-capacity-considerations.html">Capacity considerations</a> in the <i>Amazon EKS User Guide</i>.</p>', 'refs' => [ 'OutpostConfigResponse$controlPlanePlacement' => '<p>An object representing the placement configuration for all the control plane instances of your local Amazon EKS cluster on an Amazon Web Services Outpost. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/eks-outposts-capacity-considerations.html">Capacity considerations</a> in the <i>Amazon EKS User Guide</i>.</p>', ], ], 'CreateAccessConfigRequest' => [ 'base' => '<p>The access configuration information for the cluster.</p>', 'refs' => [ 'CreateClusterRequest$accessConfig' => '<p>The access configuration for the cluster.</p>', ], ], 'CreateAccessEntryRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAccessEntryResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateAddonRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAddonResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateClusterRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateClusterResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateEksAnywhereSubscriptionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateEksAnywhereSubscriptionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateFargateProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateFargateProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateNodegroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateNodegroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreatePodIdentityAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreatePodIdentityAssociationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAccessEntryRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAccessEntryResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAddonRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAddonResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteClusterRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteClusterResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEksAnywhereSubscriptionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEksAnywhereSubscriptionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFargateProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFargateProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteNodegroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteNodegroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeletePodIdentityAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletePodIdentityAssociationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeprecationDetail' => [ 'base' => '<p>The summary information about deprecated resource usage for an insight check in the <code>UPGRADE_READINESS</code> category.</p>', 'refs' => [ 'DeprecationDetails$member' => NULL, ], ], 'DeprecationDetails' => [ 'base' => NULL, 'refs' => [ 'InsightCategorySpecificSummary$deprecationDetails' => '<p>The summary information about deprecated resource usage for an insight check in the <code>UPGRADE_READINESS</code> category.</p>', ], ], 'DeregisterClusterRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterClusterResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccessEntryRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccessEntryResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAddonConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAddonConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAddonRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAddonResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAddonVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAddonVersionsRequestMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeAddonVersionsRequest$maxResults' => '<p>The maximum number of results, returned in paginated output. You receive <code>maxResults</code> in a single page, along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don\'t use this parameter, 100 results and a <code>nextToken</code> value, if applicable, are returned.</p>', ], ], 'DescribeAddonVersionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeClusterRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeClusterResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEksAnywhereSubscriptionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEksAnywhereSubscriptionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFargateProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFargateProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIdentityProviderConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIdentityProviderConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInsightRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInsightResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeNodegroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeNodegroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribePodIdentityAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribePodIdentityAssociationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUpdateRequest' => [ 'base' => '<p>Describes an update request.</p>', 'refs' => [], ], 'DescribeUpdateResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateAccessPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateAccessPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateIdentityProviderConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateIdentityProviderConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'EksAnywhereSubscription' => [ 'base' => '<p>An EKS Anywhere subscription authorizing the customer to support for licensed clusters and access to EKS Anywhere Curated Packages.</p>', 'refs' => [ 'CreateEksAnywhereSubscriptionResponse$subscription' => '<p>The full description of the subscription.</p>', 'DeleteEksAnywhereSubscriptionResponse$subscription' => '<p>The full description of the subscription to be deleted.</p>', 'DescribeEksAnywhereSubscriptionResponse$subscription' => '<p>The full description of the subscription.</p>', 'EksAnywhereSubscriptionList$member' => NULL, 'UpdateEksAnywhereSubscriptionResponse$subscription' => '<p>The full description of the updated subscription.</p>', ], ], 'EksAnywhereSubscriptionLicenseType' => [ 'base' => NULL, 'refs' => [ 'CreateEksAnywhereSubscriptionRequest$licenseType' => '<p>The license type for all licenses in the subscription. Valid value is CLUSTER. With the CLUSTER license type, each license covers support for a single EKS Anywhere cluster.</p>', 'EksAnywhereSubscription$licenseType' => '<p>The type of licenses included in the subscription. Valid value is CLUSTER. With the CLUSTER license type, each license covers support for a single EKS Anywhere cluster.</p>', ], ], 'EksAnywhereSubscriptionList' => [ 'base' => NULL, 'refs' => [ 'ListEksAnywhereSubscriptionsResponse$subscriptions' => '<p>A list of all subscription objects in the region, filtered by includeStatus and paginated by nextToken and maxResults.</p>', ], ], 'EksAnywhereSubscriptionName' => [ 'base' => NULL, 'refs' => [ 'CreateEksAnywhereSubscriptionRequest$name' => '<p>The unique name for your subscription. It must be unique in your Amazon Web Services account in the Amazon Web Services Region you\'re creating the subscription in. The name can contain only alphanumeric characters (case-sensitive), hyphens, and underscores. It must start with an alphabetic character and can\'t be longer than 100 characters.</p>', ], ], 'EksAnywhereSubscriptionStatus' => [ 'base' => NULL, 'refs' => [ 'EksAnywhereSubscriptionStatusValues$member' => NULL, ], ], 'EksAnywhereSubscriptionStatusValues' => [ 'base' => NULL, 'refs' => [ 'ListEksAnywhereSubscriptionsRequest$includeStatus' => '<p>An array of subscription statuses to filter on.</p>', ], ], 'EksAnywhereSubscriptionTerm' => [ 'base' => '<p>An object representing the term duration and term unit type of your subscription. This determines the term length of your subscription. Valid values are MONTHS for term unit and 12 or 36 for term duration, indicating a 12 month or 36 month subscription.</p>', 'refs' => [ 'CreateEksAnywhereSubscriptionRequest$term' => '<p>An object representing the term duration and term unit type of your subscription. This determines the term length of your subscription. Valid values are MONTHS for term unit and 12 or 36 for term duration, indicating a 12 month or 36 month subscription. This value cannot be changed after creating the subscription.</p>', 'EksAnywhereSubscription$term' => '<p>An EksAnywhereSubscriptionTerm object. </p>', ], ], 'EksAnywhereSubscriptionTermUnit' => [ 'base' => NULL, 'refs' => [ 'EksAnywhereSubscriptionTerm$unit' => '<p>The term unit of the subscription. Valid value is <code>MONTHS</code>.</p>', ], ], 'EncryptionConfig' => [ 'base' => '<p>The encryption configuration for the cluster.</p>', 'refs' => [ 'EncryptionConfigList$member' => NULL, ], ], 'EncryptionConfigList' => [ 'base' => NULL, 'refs' => [ 'AssociateEncryptionConfigRequest$encryptionConfig' => '<p>The configuration you are using for encryption.</p>', 'Cluster$encryptionConfig' => '<p>The encryption configuration for the cluster.</p>', 'CreateClusterRequest$encryptionConfig' => '<p>The encryption configuration for the cluster.</p>', ], ], 'ErrorCode' => [ 'base' => NULL, 'refs' => [ 'ErrorDetail$errorCode' => '<p>A brief description of the error. </p> <ul> <li> <p> <b>SubnetNotFound</b>: We couldn\'t find one of the subnets associated with the cluster.</p> </li> <li> <p> <b>SecurityGroupNotFound</b>: We couldn\'t find one of the security groups associated with the cluster.</p> </li> <li> <p> <b>EniLimitReached</b>: You have reached the elastic network interface limit for your account.</p> </li> <li> <p> <b>IpNotAvailable</b>: A subnet associated with the cluster doesn\'t have any available IP addresses.</p> </li> <li> <p> <b>AccessDenied</b>: You don\'t have permissions to perform the specified operation.</p> </li> <li> <p> <b>OperationNotPermitted</b>: The service role associated with the cluster doesn\'t have the required access permissions for Amazon EKS.</p> </li> <li> <p> <b>VpcIdNotFound</b>: We couldn\'t find the VPC associated with the cluster.</p> </li> </ul>', ], ], 'ErrorDetail' => [ 'base' => '<p>An object representing an error when an asynchronous operation fails.</p>', 'refs' => [ 'ErrorDetails$member' => NULL, ], ], 'ErrorDetails' => [ 'base' => NULL, 'refs' => [ 'Update$errors' => '<p>Any errors associated with a <code>Failed</code> update.</p>', ], ], 'FargateProfile' => [ 'base' => '<p>An object representing an Fargate profile.</p>', 'refs' => [ 'CreateFargateProfileResponse$fargateProfile' => '<p>The full description of your new Fargate profile.</p>', 'DeleteFargateProfileResponse$fargateProfile' => '<p>The deleted Fargate profile.</p>', 'DescribeFargateProfileResponse$fargateProfile' => '<p>The full description of your Fargate profile.</p>', ], ], 'FargateProfileHealth' => [ 'base' => '<p>The health status of the Fargate profile. If there are issues with your Fargate profile\'s health, they are listed here.</p>', 'refs' => [ 'FargateProfile$health' => '<p>The health status of the Fargate profile. If there are issues with your Fargate profile\'s health, they are listed here.</p>', ], ], 'FargateProfileIssue' => [ 'base' => '<p>An issue that is associated with the Fargate profile.</p>', 'refs' => [ 'FargateProfileIssueList$member' => NULL, ], ], 'FargateProfileIssueCode' => [ 'base' => NULL, 'refs' => [ 'FargateProfileIssue$code' => '<p>A brief description of the error.</p>', ], ], 'FargateProfileIssueList' => [ 'base' => NULL, 'refs' => [ 'FargateProfileHealth$issues' => '<p>Any issues that are associated with the Fargate profile.</p>', ], ], 'FargateProfileLabel' => [ 'base' => NULL, 'refs' => [ 'FargateProfileSelector$labels' => '<p>The Kubernetes labels that the selector should match. A pod must contain all of the labels that are specified in the selector for it to be considered a match.</p>', ], ], 'FargateProfileSelector' => [ 'base' => '<p>An object representing an Fargate profile selector.</p>', 'refs' => [ 'FargateProfileSelectors$member' => NULL, ], ], 'FargateProfileSelectors' => [ 'base' => NULL, 'refs' => [ 'CreateFargateProfileRequest$selectors' => '<p>The selectors to match for a <code>Pod</code> to use this Fargate profile. Each selector must have an associated Kubernetes <code>namespace</code>. Optionally, you can also specify <code>labels</code> for a <code>namespace</code>. You may specify up to five selectors in a Fargate profile.</p>', 'FargateProfile$selectors' => '<p>The selectors to match for a <code>Pod</code> to use this Fargate profile.</p>', ], ], 'FargateProfileStatus' => [ 'base' => NULL, 'refs' => [ 'FargateProfile$status' => '<p>The current status of the Fargate profile.</p>', ], ], 'FargateProfilesRequestMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListFargateProfilesRequest$maxResults' => '<p>The maximum number of results, returned in paginated output. You receive <code>maxResults</code> in a single page, along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don\'t use this parameter, 100 results and a <code>nextToken</code> value, if applicable, are returned.</p>', ], ], 'Identity' => [ 'base' => '<p>An object representing an identity provider.</p>', 'refs' => [ 'Cluster$identity' => '<p>The identity provider information for the cluster.</p>', ], ], 'IdentityProviderConfig' => [ 'base' => '<p>An object representing an identity provider configuration.</p>', 'refs' => [ 'DescribeIdentityProviderConfigRequest$identityProviderConfig' => '<p>An object representing an identity provider configuration.</p>', 'DisassociateIdentityProviderConfigRequest$identityProviderConfig' => '<p>An object representing an identity provider configuration.</p>', 'IdentityProviderConfigs$member' => NULL, ], ], 'IdentityProviderConfigResponse' => [ 'base' => '<p>The full description of your identity configuration.</p>', 'refs' => [ 'DescribeIdentityProviderConfigResponse$identityProviderConfig' => '<p>The object that represents an OpenID Connect (OIDC) identity provider configuration.</p>', ], ], 'IdentityProviderConfigs' => [ 'base' => NULL, 'refs' => [ 'ListIdentityProviderConfigsResponse$identityProviderConfigs' => '<p>The identity provider configurations for the cluster.</p>', ], ], 'IncludeClustersList' => [ 'base' => NULL, 'refs' => [ 'ListClustersRequest$include' => '<p>Indicates whether external clusters are included in the returned list. Use \'<code>all</code>\' to return <a href="https://docs.aws.amazon.com/eks/latest/userguide/eks-connector.html">https://docs.aws.amazon.com/eks/latest/userguide/eks-connector.html</a>connected clusters, or blank to return only Amazon EKS clusters. \'<code>all</code>\' must be in lowercase otherwise an error occurs.</p>', ], ], 'Insight' => [ 'base' => '<p>A check that provides recommendations to remedy potential upgrade-impacting issues.</p>', 'refs' => [ 'DescribeInsightResponse$insight' => '<p>The full description of the insight.</p>', ], ], 'InsightCategorySpecificSummary' => [ 'base' => '<p>Summary information that relates to the category of the insight. Currently only returned with certain insights having category <code>UPGRADE_READINESS</code>.</p>', 'refs' => [ 'Insight$categorySpecificSummary' => '<p>Summary information that relates to the category of the insight. Currently only returned with certain insights having category <code>UPGRADE_READINESS</code>.</p>', ], ], 'InsightResourceDetail' => [ 'base' => '<p>Returns information about the resource being evaluated.</p>', 'refs' => [ 'InsightResourceDetails$member' => NULL, ], ], 'InsightResourceDetails' => [ 'base' => NULL, 'refs' => [ 'Insight$resources' => '<p>The details about each resource listed in the insight check result.</p>', ], ], 'InsightStatus' => [ 'base' => '<p>The status of the insight.</p>', 'refs' => [ 'Insight$insightStatus' => '<p>An object containing more detail on the status of the insight resource.</p>', 'InsightResourceDetail$insightStatus' => '<p>An object containing more detail on the status of the insight resource.</p>', 'InsightSummary$insightStatus' => '<p>An object containing more detail on the status of the insight.</p>', ], ], 'InsightStatusValue' => [ 'base' => NULL, 'refs' => [ 'InsightStatus$status' => '<p>The status of the resource.</p>', 'InsightStatusValueList$member' => NULL, ], ], 'InsightStatusValueList' => [ 'base' => NULL, 'refs' => [ 'InsightsFilter$statuses' => '<p>The statuses to use to filter the insights. </p>', ], ], 'InsightSummaries' => [ 'base' => NULL, 'refs' => [ 'ListInsightsResponse$insights' => '<p>The returned list of insights.</p>', ], ], 'InsightSummary' => [ 'base' => '<p>The summarized description of the insight.</p>', 'refs' => [ 'InsightSummaries$member' => NULL, ], ], 'InsightsFilter' => [ 'base' => '<p>The criteria to use for the insights.</p>', 'refs' => [ 'ListInsightsRequest$filter' => '<p>The criteria to filter your list of insights for your cluster. You can filter which insights are returned by category, associated Kubernetes version, and status.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'ClientStat$numberOfRequestsLast30Days' => '<p>The number of requests from the Kubernetes client seen over the last 30 days.</p>', 'CreateEksAnywhereSubscriptionRequest$licenseQuantity' => '<p>The number of licenses to purchase with the subscription. Valid values are between 1 and 100. This value can\'t be changed after creating the subscription.</p>', 'EksAnywhereSubscription$licenseQuantity' => '<p>The number of licenses included in a subscription. Valid values are between 1 and 100.</p>', 'EksAnywhereSubscriptionTerm$duration' => '<p>The duration of the subscription term. Valid values are 12 and 36, indicating a 12 month or 36 month subscription.</p>', ], ], 'InvalidParameterException' => [ 'base' => '<p>The specified parameter is invalid. Review the available parameters for the API request.</p>', 'refs' => [], ], 'InvalidRequestException' => [ 'base' => '<p>The request is invalid given the state of the cluster. Check the state of the cluster and the associated operations.</p>', 'refs' => [], ], 'IpFamily' => [ 'base' => NULL, 'refs' => [ 'KubernetesNetworkConfigRequest$ipFamily' => '<p>Specify which IP family is used to assign Kubernetes pod and service IP addresses. If you don\'t specify a value, <code>ipv4</code> is used by default. You can only specify an IP family when you create a cluster and can\'t change this value once the cluster is created. If you specify <code>ipv6</code>, the VPC and subnets that you specify for cluster creation must have both <code>IPv4</code> and <code>IPv6</code> CIDR blocks assigned to them. You can\'t specify <code>ipv6</code> for clusters in China Regions.</p> <p>You can only specify <code>ipv6</code> for <code>1.21</code> and later clusters that use version <code>1.10.1</code> or later of the Amazon VPC CNI add-on. If you specify <code>ipv6</code>, then ensure that your VPC meets the requirements listed in the considerations listed in <a href="https://docs.aws.amazon.com/eks/latest/userguide/cni-ipv6.html">Assigning IPv6 addresses to pods and services</a> in the Amazon EKS User Guide. Kubernetes assigns services <code>IPv6</code> addresses from the unique local address range <code>(fc00::/7)</code>. You can\'t specify a custom <code>IPv6</code> CIDR block. Pod addresses are assigned from the subnet\'s <code>IPv6</code> CIDR.</p>', 'KubernetesNetworkConfigResponse$ipFamily' => '<p>The IP family used to assign Kubernetes <code>Pod</code> and <code>Service</code> objects IP addresses. The IP family is always <code>ipv4</code>, unless you have a <code>1.21</code> or later cluster running version <code>1.10.1</code> or later of the Amazon VPC CNI plugin for Kubernetes and specified <code>ipv6</code> when you created the cluster. </p>', ], ], 'Issue' => [ 'base' => '<p>An object representing an issue with an Amazon EKS resource.</p>', 'refs' => [ 'IssueList$member' => NULL, ], ], 'IssueList' => [ 'base' => NULL, 'refs' => [ 'NodegroupHealth$issues' => '<p>Any issues that are associated with the node group. </p>', ], ], 'KubernetesNetworkConfigRequest' => [ 'base' => '<p>The Kubernetes network configuration for the cluster.</p>', 'refs' => [ 'CreateClusterRequest$kubernetesNetworkConfig' => '<p>The Kubernetes network configuration for the cluster.</p>', ], ], 'KubernetesNetworkConfigResponse' => [ 'base' => '<p>The Kubernetes network configuration for the cluster. The response contains a value for <b>serviceIpv6Cidr</b> or <b>serviceIpv4Cidr</b>, but not both. </p>', 'refs' => [ 'Cluster$kubernetesNetworkConfig' => '<p>The Kubernetes network configuration for the cluster.</p>', ], ], 'LaunchTemplateSpecification' => [ 'base' => '<p>An object representing a node group launch template specification. The launch template can\'t include <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkInterface.html"> <code>SubnetId</code> </a>, <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_IamInstanceProfile.html"> <code>IamInstanceProfile</code> </a>, <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RequestSpotInstances.html"> <code>RequestSpotInstances</code> </a>, <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_HibernationOptionsRequest.html"> <code>HibernationOptions</code> </a>, or <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TerminateInstances.html"> <code>TerminateInstances</code> </a>, or the node group deployment or update will fail. For more information about launch templates, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateLaunchTemplate.html"> <code>CreateLaunchTemplate</code> </a> in the Amazon EC2 API Reference. For more information about using launch templates with Amazon EKS, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Customizing managed nodes with launch templates</a> in the <i>Amazon EKS User Guide</i>.</p> <p>You must specify either the launch template ID or the launch template name in the request, but not both.</p>', 'refs' => [ 'CreateNodegroupRequest$launchTemplate' => '<p>An object representing a node group\'s launch template specification. When using this object, don\'t directly specify <code>instanceTypes</code>, <code>diskSize</code>, or <code>remoteAccess</code>. Make sure that the launch template meets the requirements in <code>launchTemplateSpecification</code>. Also refer to <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Customizing managed nodes with launch templates</a> in the <i>Amazon EKS User Guide</i>.</p>', 'Nodegroup$launchTemplate' => '<p>If a launch template was used to create the node group, then this is the launch template that was used.</p>', 'UpdateNodegroupVersionRequest$launchTemplate' => '<p>An object representing a node group\'s launch template specification. You can only update a node group using a launch template if the node group was originally deployed with a launch template.</p>', ], ], 'ListAccessEntriesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAccessEntriesRequestMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListAccessEntriesRequest$maxResults' => '<p>The maximum number of results, returned in paginated output. You receive <code>maxResults</code> in a single page, along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don\'t use this parameter, 100 results and a <code>nextToken</code> value, if applicable, are returned.</p>', ], ], 'ListAccessEntriesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAccessPoliciesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAccessPoliciesRequestMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListAccessPoliciesRequest$maxResults' => '<p>The maximum number of results, returned in paginated output. You receive <code>maxResults</code> in a single page, along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don\'t use this parameter, 100 results and a <code>nextToken</code> value, if applicable, are returned.</p>', ], ], 'ListAccessPoliciesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAddonsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAddonsRequestMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListAddonsRequest$maxResults' => '<p>The maximum number of results, returned in paginated output. You receive <code>maxResults</code> in a single page, along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don\'t use this parameter, 100 results and a <code>nextToken</code> value, if applicable, are returned.</p>', ], ], 'ListAddonsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAssociatedAccessPoliciesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAssociatedAccessPoliciesRequestMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListAssociatedAccessPoliciesRequest$maxResults' => '<p>The maximum number of results, returned in paginated output. You receive <code>maxResults</code> in a single page, along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don\'t use this parameter, 100 results and a <code>nextToken</code> value, if applicable, are returned.</p>', ], ], 'ListAssociatedAccessPoliciesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListClustersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListClustersRequestMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListClustersRequest$maxResults' => '<p>The maximum number of results, returned in paginated output. You receive <code>maxResults</code> in a single page, along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don\'t use this parameter, 100 results and a <code>nextToken</code> value, if applicable, are returned.</p>', ], ], 'ListClustersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListEksAnywhereSubscriptionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListEksAnywhereSubscriptionsRequestMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListEksAnywhereSubscriptionsRequest$maxResults' => '<p>The maximum number of cluster results returned by ListEksAnywhereSubscriptions in paginated output. When you use this parameter, ListEksAnywhereSubscriptions returns only maxResults results in a single page along with a nextToken response element. You can see the remaining results of the initial request by sending another ListEksAnywhereSubscriptions request with the returned nextToken value. This value can be between 1 and 100. If you don\'t use this parameter, ListEksAnywhereSubscriptions returns up to 10 results and a nextToken value if applicable.</p>', ], ], 'ListEksAnywhereSubscriptionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFargateProfilesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFargateProfilesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListIdentityProviderConfigsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListIdentityProviderConfigsRequestMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListIdentityProviderConfigsRequest$maxResults' => '<p>The maximum number of results, returned in paginated output. You receive <code>maxResults</code> in a single page, along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don\'t use this parameter, 100 results and a <code>nextToken</code> value, if applicable, are returned.</p>', ], ], 'ListIdentityProviderConfigsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListInsightsMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListInsightsRequest$maxResults' => '<p>The maximum number of identity provider configurations returned by <code>ListInsights</code> in paginated output. When you use this parameter, <code>ListInsights</code> returns only <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListInsights</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don\'t use this parameter, <code>ListInsights</code> returns up to 100 results and a <code>nextToken</code> value, if applicable.</p>', ], ], 'ListInsightsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListInsightsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListNodegroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListNodegroupsRequestMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListNodegroupsRequest$maxResults' => '<p>The maximum number of results, returned in paginated output. You receive <code>maxResults</code> in a single page, along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don\'t use this parameter, 100 results and a <code>nextToken</code> value, if applicable, are returned.</p>', ], ], 'ListNodegroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPodIdentityAssociationsMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListPodIdentityAssociationsRequest$maxResults' => '<p>The maximum number of EKS Pod Identity association results returned by <code>ListPodIdentityAssociations</code> in paginated output. When you use this parameter, <code>ListPodIdentityAssociations</code> returns only <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListPodIdentityAssociations</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don\'t use this parameter, <code>ListPodIdentityAssociations</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>', ], ], 'ListPodIdentityAssociationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPodIdentityAssociationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListUpdatesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListUpdatesRequestMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListUpdatesRequest$maxResults' => '<p>The maximum number of results, returned in paginated output. You receive <code>maxResults</code> in a single page, along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don\'t use this parameter, 100 results and a <code>nextToken</code> value, if applicable, are returned.</p>', ], ], 'ListUpdatesResponse' => [ 'base' => NULL, 'refs' => [], ], 'LogSetup' => [ 'base' => '<p>An object representing the enabled or disabled Kubernetes control plane logs for your cluster.</p>', 'refs' => [ 'LogSetups$member' => NULL, ], ], 'LogSetups' => [ 'base' => NULL, 'refs' => [ 'Logging$clusterLogging' => '<p>The cluster control plane logging configuration for your cluster.</p>', ], ], 'LogType' => [ 'base' => NULL, 'refs' => [ 'LogTypes$member' => NULL, ], ], 'LogTypes' => [ 'base' => NULL, 'refs' => [ 'LogSetup$types' => '<p>The available cluster control plane log types.</p>', ], ], 'Logging' => [ 'base' => '<p>An object representing the logging configuration for resources in your cluster.</p>', 'refs' => [ 'Cluster$logging' => '<p>The logging configuration for your cluster.</p>', 'CreateClusterRequest$logging' => '<p>Enable or disable exporting the Kubernetes control plane logs for your cluster to CloudWatch Logs. By default, cluster control plane logs aren\'t exported to CloudWatch Logs. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html">Amazon EKS Cluster control plane logs</a> in the <i> <i>Amazon EKS User Guide</i> </i>.</p> <note> <p>CloudWatch Logs ingestion, archive storage, and data scanning rates apply to exported control plane logs. For more information, see <a href="http://aws.amazon.com/cloudwatch/pricing/">CloudWatch Pricing</a>.</p> </note>', 'UpdateClusterConfigRequest$logging' => '<p>Enable or disable exporting the Kubernetes control plane logs for your cluster to CloudWatch Logs. By default, cluster control plane logs aren\'t exported to CloudWatch Logs. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html">Amazon EKS cluster control plane logs</a> in the <i> <i>Amazon EKS User Guide</i> </i>.</p> <note> <p>CloudWatch Logs ingestion, archive storage, and data scanning rates apply to exported control plane logs. For more information, see <a href="http://aws.amazon.com/cloudwatch/pricing/">CloudWatch Pricing</a>.</p> </note>', ], ], 'MarketplaceInformation' => [ 'base' => '<p>Information about an Amazon EKS add-on from the Amazon Web Services Marketplace.</p>', 'refs' => [ 'Addon$marketplaceInformation' => '<p>Information about an Amazon EKS add-on from the Amazon Web Services Marketplace.</p>', 'AddonInfo$marketplaceInformation' => '<p>Information about the add-on from the Amazon Web Services Marketplace.</p>', ], ], 'Nodegroup' => [ 'base' => '<p>An object representing an Amazon EKS managed node group.</p>', 'refs' => [ 'CreateNodegroupResponse$nodegroup' => '<p>The full description of your new node group.</p>', 'DeleteNodegroupResponse$nodegroup' => '<p>The full description of your deleted node group.</p>', 'DescribeNodegroupResponse$nodegroup' => '<p>The full description of your node group.</p>', ], ], 'NodegroupHealth' => [ 'base' => '<p>An object representing the health status of the node group.</p>', 'refs' => [ 'Nodegroup$health' => '<p>The health status of the node group. If there are issues with your node group\'s health, they are listed here.</p>', ], ], 'NodegroupIssueCode' => [ 'base' => NULL, 'refs' => [ 'Issue$code' => '<p>A brief description of the error.</p> <ul> <li> <p> <b>AccessDenied</b>: Amazon EKS or one or more of your managed nodes is failing to authenticate or authorize with your Kubernetes cluster API server.</p> </li> <li> <p> <b>AsgInstanceLaunchFailures</b>: Your Auto Scaling group is experiencing failures while attempting to launch instances.</p> </li> <li> <p> <b>AutoScalingGroupNotFound</b>: We couldn\'t find the Auto Scaling group associated with the managed node group. You may be able to recreate an Auto Scaling group with the same settings to recover.</p> </li> <li> <p> <b>ClusterUnreachable</b>: Amazon EKS or one or more of your managed nodes is unable to to communicate with your Kubernetes cluster API server. This can happen if there are network disruptions or if API servers are timing out processing requests. </p> </li> <li> <p> <b>Ec2LaunchTemplateNotFound</b>: We couldn\'t find the Amazon EC2 launch template for your managed node group. You may be able to recreate a launch template with the same settings to recover.</p> </li> <li> <p> <b>Ec2LaunchTemplateVersionMismatch</b>: The Amazon EC2 launch template version for your managed node group does not match the version that Amazon EKS created. You may be able to revert to the version that Amazon EKS created to recover.</p> </li> <li> <p> <b>Ec2SecurityGroupDeletionFailure</b>: We could not delete the remote access security group for your managed node group. Remove any dependencies from the security group.</p> </li> <li> <p> <b>Ec2SecurityGroupNotFound</b>: We couldn\'t find the cluster security group for the cluster. You must recreate your cluster.</p> </li> <li> <p> <b>Ec2SubnetInvalidConfiguration</b>: One or more Amazon EC2 subnets specified for a node group do not automatically assign public IP addresses to instances launched into it. If you want your instances to be assigned a public IP address, then you need to enable the <code>auto-assign public IP address</code> setting for the subnet. See <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-ip-addressing.html#subnet-public-ip">Modifying the public <code>IPv4</code> addressing attribute for your subnet</a> in the <i>Amazon VPC User Guide</i>.</p> </li> <li> <p> <b>IamInstanceProfileNotFound</b>: We couldn\'t find the IAM instance profile for your managed node group. You may be able to recreate an instance profile with the same settings to recover.</p> </li> <li> <p> <b>IamNodeRoleNotFound</b>: We couldn\'t find the IAM role for your managed node group. You may be able to recreate an IAM role with the same settings to recover.</p> </li> <li> <p> <b>InstanceLimitExceeded</b>: Your Amazon Web Services account is unable to launch any more instances of the specified instance type. You may be able to request an Amazon EC2 instance limit increase to recover.</p> </li> <li> <p> <b>InsufficientFreeAddresses</b>: One or more of the subnets associated with your managed node group does not have enough available IP addresses for new nodes.</p> </li> <li> <p> <b>InternalFailure</b>: These errors are usually caused by an Amazon EKS server-side issue.</p> </li> <li> <p> <b>NodeCreationFailure</b>: Your launched instances are unable to register with your Amazon EKS cluster. Common causes of this failure are insufficient <a href="https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html">node IAM role</a> permissions or lack of outbound internet access for the nodes. </p> </li> </ul>', ], ], 'NodegroupResources' => [ 'base' => '<p>An object representing the resources associated with the node group, such as Auto Scaling groups and security groups for remote access.</p>', 'refs' => [ 'Nodegroup$resources' => '<p>The resources associated with the node group, such as Auto Scaling groups and security groups for remote access.</p>', ], ], 'NodegroupScalingConfig' => [ 'base' => '<p>An object representing the scaling configuration details for the Auto Scaling group that is associated with your node group. When creating a node group, you must specify all or none of the properties. When updating a node group, you can specify any or none of the properties.</p>', 'refs' => [ 'CreateNodegroupRequest$scalingConfig' => '<p>The scaling configuration details for the Auto Scaling group that is created for your node group.</p>', 'Nodegroup$scalingConfig' => '<p>The scaling configuration details for the Auto Scaling group that is associated with your node group.</p>', 'UpdateNodegroupConfigRequest$scalingConfig' => '<p>The scaling configuration details for the Auto Scaling group after the update.</p>', ], ], 'NodegroupStatus' => [ 'base' => NULL, 'refs' => [ 'Nodegroup$status' => '<p>The current status of the managed node group.</p>', ], ], 'NodegroupUpdateConfig' => [ 'base' => '<p>The node group update configuration.</p>', 'refs' => [ 'CreateNodegroupRequest$updateConfig' => '<p>The node group update configuration.</p>', 'Nodegroup$updateConfig' => '<p>The node group update configuration.</p>', 'UpdateNodegroupConfigRequest$updateConfig' => '<p>The node group update configuration.</p>', ], ], 'NonZeroInteger' => [ 'base' => NULL, 'refs' => [ 'NodegroupUpdateConfig$maxUnavailable' => '<p>The maximum number of nodes unavailable at once during a version update. Nodes are updated in parallel. This value or <code>maxUnavailablePercentage</code> is required to have a value.The maximum number is 100.</p>', ], ], 'NotFoundException' => [ 'base' => '<p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>', 'refs' => [], ], 'OIDC' => [ 'base' => '<p>An object representing the <a href="https://openid.net/connect/">OpenID Connect</a> (OIDC) identity provider information for the cluster.</p>', 'refs' => [ 'Identity$oidc' => '<p>An object representing the <a href="https://openid.net/connect/">OpenID Connect</a> identity provider information.</p>', ], ], 'OidcIdentityProviderConfig' => [ 'base' => '<p>An object representing the configuration for an OpenID Connect (OIDC) identity provider. </p>', 'refs' => [ 'IdentityProviderConfigResponse$oidc' => '<p>An object representing an OpenID Connect (OIDC) identity provider configuration.</p>', ], ], 'OidcIdentityProviderConfigRequest' => [ 'base' => '<p>An object representing an OpenID Connect (OIDC) configuration. Before associating an OIDC identity provider to your cluster, review the considerations in <a href="https://docs.aws.amazon.com/eks/latest/userguide/authenticate-oidc-identity-provider.html">Authenticating users for your cluster from an OIDC identity provider</a> in the <i>Amazon EKS User Guide</i>.</p>', 'refs' => [ 'AssociateIdentityProviderConfigRequest$oidc' => '<p>An object representing an OpenID Connect (OIDC) identity provider configuration.</p>', ], ], 'OutpostConfigRequest' => [ 'base' => '<p>The configuration of your local Amazon EKS cluster on an Amazon Web Services Outpost. Before creating a cluster on an Outpost, review <a href="https://docs.aws.amazon.com/eks/latest/userguide/eks-outposts-local-cluster-create.html">Creating a local cluster on an Outpost</a> in the <i>Amazon EKS User Guide</i>. This API isn\'t available for Amazon EKS clusters on the Amazon Web Services cloud.</p>', 'refs' => [ 'CreateClusterRequest$outpostConfig' => '<p>An object representing the configuration of your local Amazon EKS cluster on an Amazon Web Services Outpost. Before creating a local cluster on an Outpost, review <a href="https://docs.aws.amazon.com/eks/latest/userguide/eks-outposts-local-cluster-overview.html">Local clusters for Amazon EKS on Amazon Web Services Outposts</a> in the <i>Amazon EKS User Guide</i>. This object isn\'t available for creating Amazon EKS clusters on the Amazon Web Services cloud.</p>', ], ], 'OutpostConfigResponse' => [ 'base' => '<p>An object representing the configuration of your local Amazon EKS cluster on an Amazon Web Services Outpost. This API isn\'t available for Amazon EKS clusters on the Amazon Web Services cloud.</p>', 'refs' => [ 'Cluster$outpostConfig' => '<p>An object representing the configuration of your local Amazon EKS cluster on an Amazon Web Services Outpost. This object isn\'t available for clusters on the Amazon Web Services cloud.</p>', ], ], 'PercentCapacity' => [ 'base' => NULL, 'refs' => [ 'NodegroupUpdateConfig$maxUnavailablePercentage' => '<p>The maximum percentage of nodes unavailable during a version update. This percentage of nodes are updated in parallel, up to 100 nodes at once. This value or <code>maxUnavailable</code> is required to have a value.</p>', ], ], 'PodIdentityAssociation' => [ 'base' => '<p>Amazon EKS Pod Identity associations provide the ability to manage credentials for your applications, similar to the way that Amazon EC2 instance profiles provide credentials to Amazon EC2 instances.</p>', 'refs' => [ 'CreatePodIdentityAssociationResponse$association' => '<p>The full description of your new association.</p> <p>The description includes an ID for the association. Use the ID of the association in further actions to manage the association.</p>', 'DeletePodIdentityAssociationResponse$association' => '<p>The full description of the EKS Pod Identity association that was deleted.</p>', 'DescribePodIdentityAssociationResponse$association' => '<p>The full description of the EKS Pod Identity association.</p>', 'UpdatePodIdentityAssociationResponse$association' => '<p>The full description of the EKS Pod Identity association that was updated.</p>', ], ], 'PodIdentityAssociationSummaries' => [ 'base' => NULL, 'refs' => [ 'ListPodIdentityAssociationsResponse$associations' => '<p>The list of summarized descriptions of the associations that are in the cluster and match any filters that you provided.</p> <p>Each summary is simplified by removing these fields compared to the full <code> <a>PodIdentityAssociation</a> </code>:</p> <ul> <li> <p>The IAM role: <code>roleArn</code> </p> </li> <li> <p>The timestamp that the association was created at: <code>createdAt</code> </p> </li> <li> <p>The most recent timestamp that the association was modified at:. <code>modifiedAt</code> </p> </li> <li> <p>The tags on the association: <code>tags</code> </p> </li> </ul>', ], ], 'PodIdentityAssociationSummary' => [ 'base' => '<p>The summarized description of the association.</p> <p>Each summary is simplified by removing these fields compared to the full <code> <a>PodIdentityAssociation</a> </code>:</p> <ul> <li> <p>The IAM role: <code>roleArn</code> </p> </li> <li> <p>The timestamp that the association was created at: <code>createdAt</code> </p> </li> <li> <p>The most recent timestamp that the association was modified at:. <code>modifiedAt</code> </p> </li> <li> <p>The tags on the association: <code>tags</code> </p> </li> </ul>', 'refs' => [ 'PodIdentityAssociationSummaries$member' => NULL, ], ], 'Provider' => [ 'base' => '<p>Identifies the Key Management Service (KMS) key used to encrypt the secrets.</p>', 'refs' => [ 'EncryptionConfig$provider' => '<p>Key Management Service (KMS) key. Either the ARN or the alias can be used.</p>', ], ], 'RegisterClusterRequest' => [ 'base' => NULL, 'refs' => [], ], 'RegisterClusterResponse' => [ 'base' => NULL, 'refs' => [], ], 'RemoteAccessConfig' => [ 'base' => '<p>An object representing the remote access configuration for the managed node group.</p>', 'refs' => [ 'CreateNodegroupRequest$remoteAccess' => '<p>The remote access configuration to use with your node group. For Linux, the protocol is SSH. For Windows, the protocol is RDP. If you specify <code>launchTemplate</code>, then don\'t specify <code>remoteAccess</code>, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Customizing managed nodes with launch templates</a> in the <i>Amazon EKS User Guide</i>.</p>', 'Nodegroup$remoteAccess' => '<p>If the node group wasn\'t deployed with a launch template, then this is the remote access configuration that is associated with the node group. If the node group was deployed with a launch template, then this is <code>null</code>.</p>', ], ], 'ResolveConflicts' => [ 'base' => NULL, 'refs' => [ 'CreateAddonRequest$resolveConflicts' => '<p>How to resolve field value conflicts for an Amazon EKS add-on. Conflicts are handled based on the value you choose:</p> <ul> <li> <p> <b>None</b> – If the self-managed version of the add-on is installed on your cluster, Amazon EKS doesn\'t change the value. Creation of the add-on might fail.</p> </li> <li> <p> <b>Overwrite</b> – If the self-managed version of the add-on is installed on your cluster and the Amazon EKS default value is different than the existing value, Amazon EKS changes the value to the Amazon EKS default value.</p> </li> <li> <p> <b>Preserve</b> – This is similar to the NONE option. If the self-managed version of the add-on is installed on your cluster Amazon EKS doesn\'t change the add-on resource properties. Creation of the add-on might fail if conflicts are detected. This option works differently during the update operation. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/APIReference/API_UpdateAddon.html">UpdateAddon</a>.</p> </li> </ul> <p>If you don\'t currently have the self-managed version of the add-on installed on your cluster, the Amazon EKS add-on is installed. Amazon EKS sets all values to default values, regardless of the option that you specify.</p>', 'UpdateAddonRequest$resolveConflicts' => '<p>How to resolve field value conflicts for an Amazon EKS add-on if you\'ve changed a value from the Amazon EKS default value. Conflicts are handled based on the option you choose:</p> <ul> <li> <p> <b>None</b> – Amazon EKS doesn\'t change the value. The update might fail.</p> </li> <li> <p> <b>Overwrite</b> – Amazon EKS overwrites the changed value back to the Amazon EKS default value.</p> </li> <li> <p> <b>Preserve</b> – Amazon EKS preserves the value. If you choose this option, we recommend that you test any field and value changes on a non-production cluster before updating the add-on on your production cluster.</p> </li> </ul>', ], ], 'ResourceInUseException' => [ 'base' => '<p>The specified resource is in use.</p>', 'refs' => [], ], 'ResourceLimitExceededException' => [ 'base' => '<p>You have encountered a service limit on the specified resource.</p>', 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>The specified resource could not be found. You can view your available clusters with <code>ListClusters</code>. You can view your available managed node groups with <code>ListNodegroups</code>. Amazon EKS clusters and node groups are Amazon Web Services Region specific.</p>', 'refs' => [], ], 'ResourcePropagationDelayException' => [ 'base' => '<p>Required resources (such as service-linked roles) were created and are still propagating. Retry later.</p>', 'refs' => [], ], 'RoleArn' => [ 'base' => NULL, 'refs' => [ 'CreateAddonRequest$serviceAccountRoleArn' => '<p>The Amazon Resource Name (ARN) of an existing IAM role to bind to the add-on\'s service account. The role must be assigned the IAM permissions required by the add-on. If you don\'t specify an existing IAM role, then the add-on uses the permissions assigned to the node IAM role. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html">Amazon EKS node IAM role</a> in the <i>Amazon EKS User Guide</i>.</p> <note> <p>To specify an existing IAM role, you must have an IAM OpenID Connect (OIDC) provider created for your cluster. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/enable-iam-roles-for-service-accounts.html">Enabling IAM roles for service accounts on your cluster</a> in the <i>Amazon EKS User Guide</i>.</p> </note>', 'UpdateAddonRequest$serviceAccountRoleArn' => '<p>The Amazon Resource Name (ARN) of an existing IAM role to bind to the add-on\'s service account. The role must be assigned the IAM permissions required by the add-on. If you don\'t specify an existing IAM role, then the add-on uses the permissions assigned to the node IAM role. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html">Amazon EKS node IAM role</a> in the <i>Amazon EKS User Guide</i>.</p> <note> <p>To specify an existing IAM role, you must have an IAM OpenID Connect (OIDC) provider created for your cluster. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/enable-iam-roles-for-service-accounts.html">Enabling IAM roles for service accounts on your cluster</a> in the <i>Amazon EKS User Guide</i>.</p> </note>', ], ], 'ServerException' => [ 'base' => '<p>These errors are usually caused by a server-side issue.</p>', 'refs' => [], ], 'ServiceUnavailableException' => [ 'base' => '<p>The service is unavailable. Back off and retry the operation.</p>', 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => '<p>You do not have sufficient access to perform this action.</p>', 'AccessEntry$clusterName' => '<p>The name of your cluster.</p>', 'AccessEntry$principalArn' => '<p>The ARN of the IAM principal for the access entry. If you ever delete the IAM principal with this ARN, the access entry isn\'t automatically deleted. We recommend that you delete the access entry with an ARN for an IAM principal that you delete. If you don\'t delete the access entry and ever recreate the IAM principal, even if it has the same ARN, the access entry won\'t work. This is because even though the ARN is the same for the recreated IAM principal, the <code>roleID</code> or <code>userID</code> (you can see this with the Security Token Service <code>GetCallerIdentity</code> API) is different for the recreated IAM principal than it was for the original IAM principal. Even though you don\'t see the IAM principal\'s <code>roleID</code> or <code>userID</code> for an access entry, Amazon EKS stores it with the access entry.</p>', 'AccessEntry$accessEntryArn' => '<p>The ARN of the access entry.</p>', 'AccessEntry$username' => '<p>The <code>name</code> of a user that can authenticate to your cluster.</p>', 'AccessEntry$type' => '<p>The type of the access entry.</p>', 'AccessPolicy$name' => '<p>The name of the access policy.</p>', 'AccessPolicy$arn' => '<p>The ARN of the access policy.</p>', 'AdditionalInfoMap$key' => NULL, 'AdditionalInfoMap$value' => NULL, 'Addon$addonName' => '<p>The name of the add-on.</p>', 'Addon$addonVersion' => '<p>The version of the add-on.</p>', 'Addon$addonArn' => '<p>The Amazon Resource Name (ARN) of the add-on.</p>', 'Addon$serviceAccountRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that\'s bound to the Kubernetes <code>ServiceAccount</code> object that the add-on uses.</p>', 'Addon$publisher' => '<p>The publisher of the add-on.</p>', 'Addon$owner' => '<p>The owner of the add-on.</p>', 'Addon$configurationValues' => '<p>The configuration values that you provided.</p>', 'AddonInfo$addonName' => '<p>The name of the add-on.</p>', 'AddonInfo$type' => '<p>The type of the add-on.</p>', 'AddonInfo$publisher' => '<p>The publisher of the add-on.</p>', 'AddonInfo$owner' => '<p>The owner of the add-on.</p>', 'AddonIssue$message' => '<p>A message that provides details about the issue and what might cause it.</p>', 'AddonPodIdentityAssociations$serviceAccount' => '<p>The name of a Kubernetes Service Account.</p>', 'AddonPodIdentityAssociations$roleArn' => '<p>The ARN of an IAM Role.</p>', 'AddonPodIdentityConfiguration$serviceAccount' => '<p>The Kubernetes Service Account name used by the addon.</p>', 'AddonVersionInfo$addonVersion' => '<p>The version of the add-on.</p>', 'AssociateAccessPolicyRequest$clusterName' => '<p>The name of your cluster.</p>', 'AssociateAccessPolicyRequest$principalArn' => '<p>The Amazon Resource Name (ARN) of the IAM user or role for the <code>AccessEntry</code> that you\'re associating the access policy to. </p>', 'AssociateAccessPolicyRequest$policyArn' => '<p>The ARN of the <code>AccessPolicy</code> that you\'re associating. For a list of ARNs, use <code>ListAccessPolicies</code>.</p>', 'AssociateAccessPolicyResponse$clusterName' => '<p>The name of your cluster.</p>', 'AssociateAccessPolicyResponse$principalArn' => '<p>The ARN of the IAM principal for the <code>AccessEntry</code>.</p>', 'AssociateEncryptionConfigRequest$clusterName' => '<p>The name of your cluster.</p>', 'AssociateEncryptionConfigRequest$clientRequestToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', 'AssociateIdentityProviderConfigRequest$clusterName' => '<p>The name of your cluster.</p>', 'AssociateIdentityProviderConfigRequest$clientRequestToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', 'AssociatedAccessPolicy$policyArn' => '<p>The ARN of the <code>AccessPolicy</code>.</p>', 'AutoScalingGroup$name' => '<p>The name of the Auto Scaling group associated with an Amazon EKS managed node group.</p>', 'BadRequestException$message' => '<p>This exception is thrown if the request contains a semantic error. The precise meaning will depend on the API, and will be documented in the error message.</p>', 'Certificate$data' => '<p>The Base64-encoded certificate data required to communicate with your cluster. Add this to the <code>certificate-authority-data</code> section of the <code>kubeconfig</code> file for your cluster.</p>', 'ClientException$clusterName' => '<p>The Amazon EKS cluster associated with the exception.</p>', 'ClientException$nodegroupName' => '<p>The Amazon EKS managed node group associated with the exception.</p>', 'ClientException$addonName' => '<p>The Amazon EKS add-on name associated with the exception.</p>', 'ClientException$subscriptionId' => '<p>The Amazon EKS subscription ID with the exception.</p>', 'ClientException$message' => '<p>These errors are usually caused by a client action. Actions can include using an action or resource on behalf of an <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html">IAM principal</a> that doesn\'t have permissions to use the action or resource or specifying an identifier that is not valid.</p>', 'ClientStat$userAgent' => '<p>The user agent of the Kubernetes client using the deprecated resource.</p>', 'Cluster$name' => '<p>The name of your cluster.</p>', 'Cluster$arn' => '<p>The Amazon Resource Name (ARN) of the cluster.</p>', 'Cluster$version' => '<p>The Kubernetes server version for the cluster.</p>', 'Cluster$endpoint' => '<p>The endpoint for your Kubernetes API server.</p>', 'Cluster$roleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that provides permissions for the Kubernetes control plane to make calls to Amazon Web Services API operations on your behalf.</p>', 'Cluster$clientRequestToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', 'Cluster$platformVersion' => '<p>The platform version of your Amazon EKS cluster. For more information about clusters deployed on the Amazon Web Services Cloud, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/platform-versions.html">Platform versions</a> in the <i> <i>Amazon EKS User Guide</i> </i>. For more information about local clusters deployed on an Outpost, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/eks-outposts-platform-versions.html">Amazon EKS local cluster platform versions</a> in the <i> <i>Amazon EKS User Guide</i> </i>.</p>', 'Cluster$id' => '<p>The ID of your local Amazon EKS cluster on an Amazon Web Services Outpost. This property isn\'t available for an Amazon EKS cluster on the Amazon Web Services cloud.</p>', 'ClusterIssue$message' => '<p>A description of the issue.</p>', 'Compatibility$clusterVersion' => '<p>The supported Kubernetes version of the cluster.</p>', 'ConnectorConfigRequest$roleArn' => '<p>The Amazon Resource Name (ARN) of the role that is authorized to request the connector configuration.</p>', 'ConnectorConfigResponse$activationId' => '<p>A unique ID associated with the cluster for registration purposes.</p>', 'ConnectorConfigResponse$activationCode' => '<p>A unique code associated with the cluster for registration purposes.</p>', 'ConnectorConfigResponse$provider' => '<p>The cluster\'s cloud service provider.</p>', 'ConnectorConfigResponse$roleArn' => '<p>The Amazon Resource Name (ARN) of the role to communicate with services from the connected Kubernetes cluster.</p>', 'ControlPlanePlacementRequest$groupName' => '<p>The name of the placement group for the Kubernetes control plane instances. This setting can\'t be changed after cluster creation. </p>', 'ControlPlanePlacementResponse$groupName' => '<p>The name of the placement group for the Kubernetes control plane instances.</p>', 'CreateAccessEntryRequest$clusterName' => '<p>The name of your cluster.</p>', 'CreateAccessEntryRequest$principalArn' => '<p>The ARN of the IAM principal for the <code>AccessEntry</code>. You can specify one ARN for each access entry. You can\'t specify the same ARN in more than one access entry. This value can\'t be changed after access entry creation.</p> <p>The valid principals differ depending on the type of the access entry in the <code>type</code> field. The only valid ARN is IAM roles for the types of access entries for nodes: <code/> <code/>. You can use every IAM principal type for <code>STANDARD</code> access entries. You can\'t use the STS session principal type with access entries because this is a temporary principal for each session and not a permanent identity that can be assigned permissions.</p> <p> <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/best-practices.html#bp-users-federation-idp">IAM best practices</a> recommend using IAM roles with temporary credentials, rather than IAM users with long-term credentials. </p>', 'CreateAccessEntryRequest$clientRequestToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', 'CreateAccessEntryRequest$username' => '<p>The username to authenticate to Kubernetes with. We recommend not specifying a username and letting Amazon EKS specify it for you. For more information about the value Amazon EKS specifies for you, or constraints before specifying your own username, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/access-entries.html#creating-access-entries">Creating access entries</a> in the <i>Amazon EKS User Guide</i>.</p>', 'CreateAccessEntryRequest$type' => '<p>The type of the new access entry. Valid values are <code>Standard</code>, <code>FARGATE_LINUX</code>, <code>EC2_LINUX</code>, and <code>EC2_WINDOWS</code>.</p> <p>If the <code>principalArn</code> is for an IAM role that\'s used for self-managed Amazon EC2 nodes, specify <code>EC2_LINUX</code> or <code>EC2_WINDOWS</code>. Amazon EKS grants the necessary permissions to the node for you. If the <code>principalArn</code> is for any other purpose, specify <code>STANDARD</code>. If you don\'t specify a value, Amazon EKS sets the value to <code>STANDARD</code>. It\'s unnecessary to create access entries for IAM roles used with Fargate profiles or managed Amazon EC2 nodes, because Amazon EKS creates entries in the <code>aws-auth</code> <code>ConfigMap</code> for the roles. You can\'t change this value once you\'ve created the access entry.</p> <p>If you set the value to <code>EC2_LINUX</code> or <code>EC2_WINDOWS</code>, you can\'t specify values for <code>kubernetesGroups</code>, or associate an <code>AccessPolicy</code> to the access entry.</p>', 'CreateAddonRequest$addonName' => '<p>The name of the add-on. The name must match one of the names returned by <code>DescribeAddonVersions</code>.</p>', 'CreateAddonRequest$addonVersion' => '<p>The version of the add-on. The version must match one of the versions returned by <a href="https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeAddonVersions.html"> <code>DescribeAddonVersions</code> </a>.</p>', 'CreateAddonRequest$clientRequestToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', 'CreateAddonRequest$configurationValues' => '<p>The set of configuration values for the add-on that\'s created. The values that you provide are validated against the schema returned by <code>DescribeAddonConfiguration</code>.</p>', 'CreateClusterRequest$version' => '<p>The desired Kubernetes version for your cluster. If you don\'t specify a value here, the default version available in Amazon EKS is used.</p> <note> <p>The default version might not be the latest version available.</p> </note>', 'CreateClusterRequest$roleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that provides permissions for the Kubernetes control plane to make calls to Amazon Web Services API operations on your behalf. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/service_IAM_role.html">Amazon EKS Service IAM Role</a> in the <i> <i>Amazon EKS User Guide</i> </i>.</p>', 'CreateClusterRequest$clientRequestToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', 'CreateEksAnywhereSubscriptionRequest$clientRequestToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', 'CreateFargateProfileRequest$fargateProfileName' => '<p>The name of the Fargate profile.</p>', 'CreateFargateProfileRequest$clusterName' => '<p>The name of your cluster.</p>', 'CreateFargateProfileRequest$podExecutionRoleArn' => '<p>The Amazon Resource Name (ARN) of the <code>Pod</code> execution role to use for a <code>Pod</code> that matches the selectors in the Fargate profile. The <code>Pod</code> execution role allows Fargate infrastructure to register with your cluster as a node, and it provides read access to Amazon ECR image repositories. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/pod-execution-role.html"> <code>Pod</code> execution role</a> in the <i>Amazon EKS User Guide</i>.</p>', 'CreateFargateProfileRequest$clientRequestToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', 'CreateNodegroupRequest$clusterName' => '<p>The name of your cluster.</p>', 'CreateNodegroupRequest$nodegroupName' => '<p>The unique name to give your node group.</p>', 'CreateNodegroupRequest$nodeRole' => '<p>The Amazon Resource Name (ARN) of the IAM role to associate with your node group. The Amazon EKS worker node <code>kubelet</code> daemon makes calls to Amazon Web Services APIs on your behalf. Nodes receive permissions for these API calls through an IAM instance profile and associated policies. Before you can launch nodes and register them into a cluster, you must create an IAM role for those nodes to use when they are launched. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html">Amazon EKS node IAM role</a> in the <i> <i>Amazon EKS User Guide</i> </i>. If you specify <code>launchTemplate</code>, then don\'t specify <code> <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_IamInstanceProfile.html">IamInstanceProfile</a> </code> in your launch template, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Customizing managed nodes with launch templates</a> in the <i>Amazon EKS User Guide</i>.</p>', 'CreateNodegroupRequest$clientRequestToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', 'CreateNodegroupRequest$version' => '<p>The Kubernetes version to use for your managed nodes. By default, the Kubernetes version of the cluster is used, and this is the only accepted specified value. If you specify <code>launchTemplate</code>, and your launch template uses a custom AMI, then don\'t specify <code>version</code>, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Customizing managed nodes with launch templates</a> in the <i>Amazon EKS User Guide</i>.</p>', 'CreateNodegroupRequest$releaseVersion' => '<p>The AMI version of the Amazon EKS optimized AMI to use with your node group. By default, the latest available AMI version for the node group\'s current Kubernetes version is used. For information about Linux versions, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html">Amazon EKS optimized Amazon Linux AMI versions</a> in the <i>Amazon EKS User Guide</i>. Amazon EKS managed node groups support the November 2022 and later releases of the Windows AMIs. For information about Windows versions, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/eks-ami-versions-windows.html">Amazon EKS optimized Windows AMI versions</a> in the <i>Amazon EKS User Guide</i>.</p> <p>If you specify <code>launchTemplate</code>, and your launch template uses a custom AMI, then don\'t specify <code>releaseVersion</code>, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Customizing managed nodes with launch templates</a> in the <i>Amazon EKS User Guide</i>.</p>', 'CreatePodIdentityAssociationRequest$clusterName' => '<p>The name of the cluster to create the association in.</p>', 'CreatePodIdentityAssociationRequest$namespace' => '<p>The name of the Kubernetes namespace inside the cluster to create the association in. The service account and the pods that use the service account must be in this namespace.</p>', 'CreatePodIdentityAssociationRequest$serviceAccount' => '<p>The name of the Kubernetes service account inside the cluster to associate the IAM credentials with.</p>', 'CreatePodIdentityAssociationRequest$roleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role to associate with the service account. The EKS Pod Identity agent manages credentials to assume this role for applications in the containers in the pods that use this service account.</p>', 'CreatePodIdentityAssociationRequest$clientRequestToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', 'DeleteAccessEntryRequest$clusterName' => '<p>The name of your cluster.</p>', 'DeleteAccessEntryRequest$principalArn' => '<p>The ARN of the IAM principal for the <code>AccessEntry</code>.</p>', 'DeleteAddonRequest$addonName' => '<p>The name of the add-on. The name must match one of the names returned by <a href="https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html"> <code>ListAddons</code> </a>.</p>', 'DeleteClusterRequest$name' => '<p>The name of the cluster to delete.</p>', 'DeleteEksAnywhereSubscriptionRequest$id' => '<p>The ID of the subscription.</p>', 'DeleteFargateProfileRequest$clusterName' => '<p>The name of your cluster.</p>', 'DeleteFargateProfileRequest$fargateProfileName' => '<p>The name of the Fargate profile to delete.</p>', 'DeleteNodegroupRequest$clusterName' => '<p>The name of your cluster.</p>', 'DeleteNodegroupRequest$nodegroupName' => '<p>The name of the node group to delete.</p>', 'DeletePodIdentityAssociationRequest$clusterName' => '<p>The cluster name that</p>', 'DeletePodIdentityAssociationRequest$associationId' => '<p>The ID of the association to be deleted.</p>', 'DeprecationDetail$usage' => '<p>The deprecated version of the resource.</p>', 'DeprecationDetail$replacedWith' => '<p>The newer version of the resource to migrate to if applicable. </p>', 'DeprecationDetail$stopServingVersion' => '<p>The version of the software where the deprecated resource version will stop being served.</p>', 'DeprecationDetail$startServingReplacementVersion' => '<p>The version of the software where the newer resource version became available to migrate to if applicable.</p>', 'DeregisterClusterRequest$name' => '<p>The name of the connected cluster to deregister.</p>', 'DescribeAccessEntryRequest$clusterName' => '<p>The name of your cluster.</p>', 'DescribeAccessEntryRequest$principalArn' => '<p>The ARN of the IAM principal for the <code>AccessEntry</code>.</p>', 'DescribeAddonConfigurationRequest$addonName' => '<p>The name of the add-on. The name must match one of the names returned by <code>DescribeAddonVersions</code>.</p>', 'DescribeAddonConfigurationRequest$addonVersion' => '<p>The version of the add-on. The version must match one of the versions returned by <a href="https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeAddonVersions.html"> <code>DescribeAddonVersions</code> </a>.</p>', 'DescribeAddonConfigurationResponse$addonName' => '<p>The name of the add-on.</p>', 'DescribeAddonConfigurationResponse$addonVersion' => '<p>The version of the add-on. The version must match one of the versions returned by <a href="https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeAddonVersions.html"> <code>DescribeAddonVersions</code> </a>.</p>', 'DescribeAddonConfigurationResponse$configurationSchema' => '<p>A JSON schema that\'s used to validate the configuration values you provide when an add-on is created or updated.</p>', 'DescribeAddonRequest$addonName' => '<p>The name of the add-on. The name must match one of the names returned by <a href="https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html"> <code>ListAddons</code> </a>.</p>', 'DescribeAddonVersionsRequest$kubernetesVersion' => '<p>The Kubernetes versions that you can use the add-on with.</p>', 'DescribeAddonVersionsRequest$nextToken' => '<p>The <code>nextToken</code> value returned from a previous paginated request, where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. This value is null when there are no more results to return.</p> <note> <p>This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and not for other programmatic purposes.</p> </note>', 'DescribeAddonVersionsRequest$addonName' => '<p>The name of the add-on. The name must match one of the names returned by <a href="https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html"> <code>ListAddons</code> </a>.</p>', 'DescribeAddonVersionsResponse$nextToken' => '<p>The <code>nextToken</code> value to include in a future <code>DescribeAddonVersions</code> request. When the results of a <code>DescribeAddonVersions</code> request exceed <code>maxResults</code>, you can use this value to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p> <note> <p>This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and not for other programmatic purposes.</p> </note>', 'DescribeClusterRequest$name' => '<p>The name of your cluster.</p>', 'DescribeEksAnywhereSubscriptionRequest$id' => '<p>The ID of the subscription.</p>', 'DescribeFargateProfileRequest$clusterName' => '<p>The name of your cluster.</p>', 'DescribeFargateProfileRequest$fargateProfileName' => '<p>The name of the Fargate profile to describe.</p>', 'DescribeIdentityProviderConfigRequest$clusterName' => '<p>The name of your cluster.</p>', 'DescribeInsightRequest$clusterName' => '<p>The name of the cluster to describe the insight for.</p>', 'DescribeInsightRequest$id' => '<p>The identity of the insight to describe.</p>', 'DescribeNodegroupRequest$clusterName' => '<p>The name of your cluster.</p>', 'DescribeNodegroupRequest$nodegroupName' => '<p>The name of the node group to describe.</p>', 'DescribePodIdentityAssociationRequest$clusterName' => '<p>The name of the cluster that the association is in.</p>', 'DescribePodIdentityAssociationRequest$associationId' => '<p>The ID of the association that you want the description of.</p>', 'DescribeUpdateRequest$name' => '<p>The name of the Amazon EKS cluster associated with the update.</p>', 'DescribeUpdateRequest$updateId' => '<p>The ID of the update to describe.</p>', 'DescribeUpdateRequest$nodegroupName' => '<p>The name of the Amazon EKS node group associated with the update. This parameter is required if the update is a node group update.</p>', 'DescribeUpdateRequest$addonName' => '<p>The name of the add-on. The name must match one of the names returned by <a href="https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html"> <code>ListAddons</code> </a>. This parameter is required if the update is an add-on update.</p>', 'DisassociateAccessPolicyRequest$clusterName' => '<p>The name of your cluster.</p>', 'DisassociateAccessPolicyRequest$principalArn' => '<p>The ARN of the IAM principal for the <code>AccessEntry</code>.</p>', 'DisassociateAccessPolicyRequest$policyArn' => '<p>The ARN of the policy to disassociate from the access entry. For a list of associated policies ARNs, use <code>ListAssociatedAccessPolicies</code>.</p>', 'DisassociateIdentityProviderConfigRequest$clusterName' => '<p>The name of your cluster.</p>', 'DisassociateIdentityProviderConfigRequest$clientRequestToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', 'EksAnywhereSubscription$id' => '<p>UUID identifying a subscription.</p>', 'EksAnywhereSubscription$arn' => '<p>The Amazon Resource Name (ARN) for the subscription.</p>', 'EksAnywhereSubscription$status' => '<p>The status of a subscription.</p>', 'ErrorDetail$errorMessage' => '<p>A more complete description of the error.</p>', 'FargateProfile$fargateProfileName' => '<p>The name of the Fargate profile.</p>', 'FargateProfile$fargateProfileArn' => '<p>The full Amazon Resource Name (ARN) of the Fargate profile.</p>', 'FargateProfile$clusterName' => '<p>The name of your cluster.</p>', 'FargateProfile$podExecutionRoleArn' => '<p>The Amazon Resource Name (ARN) of the <code>Pod</code> execution role to use for any <code>Pod</code> that matches the selectors in the Fargate profile. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/pod-execution-role.html"> <code>Pod</code> execution role</a> in the <i>Amazon EKS User Guide</i>.</p>', 'FargateProfileIssue$message' => '<p>The error message associated with the issue.</p>', 'FargateProfileLabel$key' => NULL, 'FargateProfileLabel$value' => NULL, 'FargateProfileSelector$namespace' => '<p>The Kubernetes <code>namespace</code> that the selector should match.</p>', 'IdentityProviderConfig$type' => '<p>The type of the identity provider configuration. The only type available is <code>oidc</code>.</p>', 'IdentityProviderConfig$name' => '<p>The name of the identity provider configuration.</p>', 'IncludeClustersList$member' => NULL, 'Insight$id' => '<p>The ID of the insight.</p>', 'Insight$name' => '<p>The name of the insight.</p>', 'Insight$kubernetesVersion' => '<p>The Kubernetes minor version associated with an insight if applicable.</p>', 'Insight$description' => '<p>The description of the insight which includes alert criteria, remediation recommendation, and additional resources (contains Markdown).</p>', 'Insight$recommendation' => '<p>A summary of how to remediate the finding of this insight if applicable. </p>', 'InsightResourceDetail$kubernetesResourceUri' => '<p>The Kubernetes resource URI if applicable.</p>', 'InsightResourceDetail$arn' => '<p>The Amazon Resource Name (ARN) if applicable.</p>', 'InsightStatus$reason' => '<p>Explanation on the reasoning for the status of the resource. </p>', 'InsightSummary$id' => '<p>The ID of the insight.</p>', 'InsightSummary$name' => '<p>The name of the insight.</p>', 'InsightSummary$kubernetesVersion' => '<p>The Kubernetes minor version associated with an insight if applicable. </p>', 'InsightSummary$description' => '<p>The description of the insight which includes alert criteria, remediation recommendation, and additional resources (contains Markdown).</p>', 'InvalidParameterException$clusterName' => '<p>The Amazon EKS cluster associated with the exception.</p>', 'InvalidParameterException$nodegroupName' => '<p>The Amazon EKS managed node group associated with the exception.</p>', 'InvalidParameterException$fargateProfileName' => '<p>The Fargate profile associated with the exception.</p>', 'InvalidParameterException$addonName' => '<p>The specified parameter for the add-on name is invalid. Review the available parameters for the API request</p>', 'InvalidParameterException$subscriptionId' => '<p>The Amazon EKS subscription ID with the exception.</p>', 'InvalidParameterException$message' => '<p>The specified parameter is invalid. Review the available parameters for the API request.</p>', 'InvalidRequestException$clusterName' => '<p>The Amazon EKS cluster associated with the exception.</p>', 'InvalidRequestException$nodegroupName' => '<p>The Amazon EKS managed node group associated with the exception.</p>', 'InvalidRequestException$addonName' => '<p>The request is invalid given the state of the add-on name. Check the state of the cluster and the associated operations.</p>', 'InvalidRequestException$subscriptionId' => '<p>The Amazon EKS subscription ID with the exception.</p>', 'InvalidRequestException$message' => '<p>The Amazon EKS add-on name associated with the exception.</p>', 'Issue$message' => '<p>The error message associated with the issue.</p>', 'KubernetesNetworkConfigRequest$serviceIpv4Cidr' => '<p>Don\'t specify a value if you select <code>ipv6</code> for <b>ipFamily</b>. The CIDR block to assign Kubernetes service IP addresses from. If you don\'t specify a block, Kubernetes assigns addresses from either the <code>10.100.0.0/16</code> or <code>172.20.0.0/16</code> CIDR blocks. We recommend that you specify a block that does not overlap with resources in other networks that are peered or connected to your VPC. The block must meet the following requirements:</p> <ul> <li> <p>Within one of the following private IP address blocks: <code>10.0.0.0/8</code>, <code>172.16.0.0/12</code>, or <code>192.168.0.0/16</code>.</p> </li> <li> <p>Doesn\'t overlap with any CIDR block assigned to the VPC that you selected for VPC.</p> </li> <li> <p>Between <code>/24</code> and <code>/12</code>.</p> </li> </ul> <important> <p>You can only specify a custom CIDR block when you create a cluster. You can\'t change this value after the cluster is created.</p> </important>', 'KubernetesNetworkConfigResponse$serviceIpv4Cidr' => '<p>The CIDR block that Kubernetes <code>Pod</code> and <code>Service</code> object IP addresses are assigned from. Kubernetes assigns addresses from an <code>IPv4</code> CIDR block assigned to a subnet that the node is in. If you didn\'t specify a CIDR block when you created the cluster, then Kubernetes assigns addresses from either the <code>10.100.0.0/16</code> or <code>172.20.0.0/16</code> CIDR blocks. If this was specified, then it was specified when the cluster was created and it can\'t be changed.</p>', 'KubernetesNetworkConfigResponse$serviceIpv6Cidr' => '<p>The CIDR block that Kubernetes pod and service IP addresses are assigned from if you created a 1.21 or later cluster with version 1.10.1 or later of the Amazon VPC CNI add-on and specified <code>ipv6</code> for <b>ipFamily</b> when you created the cluster. Kubernetes assigns service addresses from the unique local address range (<code>fc00::/7</code>) because you can\'t specify a custom IPv6 CIDR block when you create the cluster.</p>', 'LaunchTemplateSpecification$name' => '<p>The name of the launch template.</p> <p>You must specify either the launch template name or the launch template ID in the request, but not both.</p>', 'LaunchTemplateSpecification$version' => '<p>The version number of the launch template to use. If no version is specified, then the template\'s default version is used.</p>', 'LaunchTemplateSpecification$id' => '<p>The ID of the launch template.</p> <p>You must specify either the launch template ID or the launch template name in the request, but not both.</p>', 'ListAccessEntriesRequest$clusterName' => '<p>The name of your cluster.</p>', 'ListAccessEntriesRequest$associatedPolicyArn' => '<p>The ARN of an <code>AccessPolicy</code>. When you specify an access policy ARN, only the access entries associated to that access policy are returned. For a list of available policy ARNs, use <code>ListAccessPolicies</code>.</p>', 'ListAccessEntriesRequest$nextToken' => '<p>The <code>nextToken</code> value returned from a previous paginated request, where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. This value is null when there are no more results to return.</p> <note> <p>This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and not for other programmatic purposes.</p> </note>', 'ListAccessEntriesResponse$nextToken' => '<p>The <code>nextToken</code> value returned from a previous paginated request, where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. This value is null when there are no more results to return.</p> <note> <p>This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and not for other programmatic purposes.</p> </note>', 'ListAccessPoliciesRequest$nextToken' => '<p>The <code>nextToken</code> value returned from a previous paginated request, where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. This value is null when there are no more results to return.</p> <note> <p>This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and not for other programmatic purposes.</p> </note>', 'ListAccessPoliciesResponse$nextToken' => '<p>The <code>nextToken</code> value returned from a previous paginated request, where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. This value is null when there are no more results to return.</p> <note> <p>This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and not for other programmatic purposes.</p> </note>', 'ListAddonsRequest$nextToken' => '<p>The <code>nextToken</code> value returned from a previous paginated request, where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. This value is null when there are no more results to return.</p> <note> <p>This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and not for other programmatic purposes.</p> </note>', 'ListAddonsResponse$nextToken' => '<p>The <code>nextToken</code> value to include in a future <code>ListAddons</code> request. When the results of a <code>ListAddons</code> request exceed <code>maxResults</code>, you can use this value to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p> <note> <p>This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and not for other programmatic purposes.</p> </note>', 'ListAssociatedAccessPoliciesRequest$clusterName' => '<p>The name of your cluster.</p>', 'ListAssociatedAccessPoliciesRequest$principalArn' => '<p>The ARN of the IAM principal for the <code>AccessEntry</code>.</p>', 'ListAssociatedAccessPoliciesRequest$nextToken' => '<p>The <code>nextToken</code> value returned from a previous paginated request, where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. This value is null when there are no more results to return.</p> <note> <p>This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and not for other programmatic purposes.</p> </note>', 'ListAssociatedAccessPoliciesResponse$clusterName' => '<p>The name of your cluster.</p>', 'ListAssociatedAccessPoliciesResponse$principalArn' => '<p>The ARN of the IAM principal for the <code>AccessEntry</code>.</p>', 'ListAssociatedAccessPoliciesResponse$nextToken' => '<p>The <code>nextToken</code> value returned from a previous paginated request, where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. This value is null when there are no more results to return.</p> <note> <p>This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and not for other programmatic purposes.</p> </note>', 'ListClustersRequest$nextToken' => '<p>The <code>nextToken</code> value returned from a previous paginated request, where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. This value is null when there are no more results to return.</p> <note> <p>This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and not for other programmatic purposes.</p> </note>', 'ListClustersResponse$nextToken' => '<p>The <code>nextToken</code> value returned from a previous paginated request, where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. This value is null when there are no more results to return.</p> <note> <p>This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and not for other programmatic purposes.</p> </note>', 'ListEksAnywhereSubscriptionsRequest$nextToken' => '<p>The <code>nextToken</code> value returned from a previous paginated <code>ListEksAnywhereSubscriptions</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>', 'ListEksAnywhereSubscriptionsResponse$nextToken' => '<p>The nextToken value to include in a future ListEksAnywhereSubscriptions request. When the results of a ListEksAnywhereSubscriptions request exceed maxResults, you can use this value to retrieve the next page of results. This value is null when there are no more results to return.</p>', 'ListFargateProfilesRequest$clusterName' => '<p>The name of your cluster.</p>', 'ListFargateProfilesRequest$nextToken' => '<p>The <code>nextToken</code> value returned from a previous paginated request, where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. This value is null when there are no more results to return.</p> <note> <p>This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and not for other programmatic purposes.</p> </note>', 'ListFargateProfilesResponse$nextToken' => '<p>The <code>nextToken</code> value returned from a previous paginated request, where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. This value is null when there are no more results to return.</p> <note> <p>This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and not for other programmatic purposes.</p> </note>', 'ListIdentityProviderConfigsRequest$clusterName' => '<p>The name of your cluster.</p>', 'ListIdentityProviderConfigsRequest$nextToken' => '<p>The <code>nextToken</code> value returned from a previous paginated request, where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. This value is null when there are no more results to return.</p> <note> <p>This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and not for other programmatic purposes.</p> </note>', 'ListIdentityProviderConfigsResponse$nextToken' => '<p>The <code>nextToken</code> value to include in a future <code>ListIdentityProviderConfigsResponse</code> request. When the results of a <code>ListIdentityProviderConfigsResponse</code> request exceed <code>maxResults</code>, you can use this value to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p> <note> <p>This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and not for other programmatic purposes.</p> </note>', 'ListInsightsRequest$clusterName' => '<p>The name of the Amazon EKS cluster associated with the insights.</p>', 'ListInsightsRequest$nextToken' => '<p>The <code>nextToken</code> value returned from a previous paginated <code>ListInsights</code> request. When the results of a <code>ListInsights</code> request exceed <code>maxResults</code>, you can use this value to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'ListInsightsResponse$nextToken' => '<p>The <code>nextToken</code> value to include in a future <code>ListInsights</code> request. When the results of a <code>ListInsights</code> request exceed <code>maxResults</code>, you can use this value to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'ListNodegroupsRequest$clusterName' => '<p>The name of your cluster.</p>', 'ListNodegroupsRequest$nextToken' => '<p>The <code>nextToken</code> value returned from a previous paginated request, where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. This value is null when there are no more results to return.</p> <note> <p>This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and not for other programmatic purposes.</p> </note>', 'ListNodegroupsResponse$nextToken' => '<p>The <code>nextToken</code> value returned from a previous paginated request, where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. This value is null when there are no more results to return.</p> <note> <p>This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and not for other programmatic purposes.</p> </note>', 'ListPodIdentityAssociationsRequest$clusterName' => '<p>The name of the cluster that the associations are in.</p>', 'ListPodIdentityAssociationsRequest$namespace' => '<p>The name of the Kubernetes namespace inside the cluster that the associations are in.</p>', 'ListPodIdentityAssociationsRequest$serviceAccount' => '<p>The name of the Kubernetes service account that the associations use.</p>', 'ListPodIdentityAssociationsRequest$nextToken' => '<p>The <code>nextToken</code> value returned from a previous paginated <code>ListUpdates</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p> <note> <p>This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and not for other programmatic purposes.</p> </note>', 'ListPodIdentityAssociationsResponse$nextToken' => '<p>The <code>nextToken</code> value to include in a future <code>ListPodIdentityAssociations</code> request. When the results of a <code>ListPodIdentityAssociations</code> request exceed <code>maxResults</code>, you can use this value to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p> <note> <p>This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and not for other programmatic purposes.</p> </note>', 'ListTagsForResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) that identifies the resource to list tags for.</p>', 'ListUpdatesRequest$name' => '<p>The name of the Amazon EKS cluster to list updates for.</p>', 'ListUpdatesRequest$nodegroupName' => '<p>The name of the Amazon EKS managed node group to list updates for.</p>', 'ListUpdatesRequest$addonName' => '<p>The names of the installed add-ons that have available updates.</p>', 'ListUpdatesRequest$nextToken' => '<p>The <code>nextToken</code> value returned from a previous paginated request, where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. This value is null when there are no more results to return.</p> <note> <p>This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and not for other programmatic purposes.</p> </note>', 'ListUpdatesResponse$nextToken' => '<p>The <code>nextToken</code> value returned from a previous paginated request, where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. This value is null when there are no more results to return.</p> <note> <p>This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and not for other programmatic purposes.</p> </note>', 'MarketplaceInformation$productId' => '<p>The product ID from the Amazon Web Services Marketplace.</p>', 'MarketplaceInformation$productUrl' => '<p>The product URL from the Amazon Web Services Marketplace.</p>', 'Nodegroup$nodegroupName' => '<p>The name associated with an Amazon EKS managed node group.</p>', 'Nodegroup$nodegroupArn' => '<p>The Amazon Resource Name (ARN) associated with the managed node group.</p>', 'Nodegroup$clusterName' => '<p>The name of your cluster.</p>', 'Nodegroup$version' => '<p>The Kubernetes version of the managed node group.</p>', 'Nodegroup$releaseVersion' => '<p>If the node group was deployed using a launch template with a custom AMI, then this is the AMI ID that was specified in the launch template. For node groups that weren\'t deployed using a launch template, this is the version of the Amazon EKS optimized AMI that the node group was deployed with.</p>', 'Nodegroup$nodeRole' => '<p>The IAM role associated with your node group. The Amazon EKS node <code>kubelet</code> daemon makes calls to Amazon Web Services APIs on your behalf. Nodes receive permissions for these API calls through an IAM instance profile and associated policies.</p>', 'NodegroupResources$remoteAccessSecurityGroup' => '<p>The remote access security group associated with the node group. This security group controls SSH access to the nodes.</p>', 'NotFoundException$message' => '<p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>', 'OIDC$issuer' => '<p>The issuer URL for the OIDC identity provider.</p>', 'OidcIdentityProviderConfig$identityProviderConfigName' => '<p>The name of the configuration.</p>', 'OidcIdentityProviderConfig$identityProviderConfigArn' => '<p>The ARN of the configuration.</p>', 'OidcIdentityProviderConfig$clusterName' => '<p>The name of your cluster.</p>', 'OidcIdentityProviderConfig$issuerUrl' => '<p>The URL of the OIDC identity provider that allows the API server to discover public signing keys for verifying tokens.</p>', 'OidcIdentityProviderConfig$clientId' => '<p>This is also known as <i>audience</i>. The ID of the client application that makes authentication requests to the OIDC identity provider.</p>', 'OidcIdentityProviderConfig$usernameClaim' => '<p>The JSON Web token (JWT) claim that is used as the username.</p>', 'OidcIdentityProviderConfig$usernamePrefix' => '<p>The prefix that is prepended to username claims to prevent clashes with existing names. The prefix can\'t contain <code>system:</code> </p>', 'OidcIdentityProviderConfig$groupsClaim' => '<p>The JSON web token (JWT) claim that the provider uses to return your groups.</p>', 'OidcIdentityProviderConfig$groupsPrefix' => '<p>The prefix that is prepended to group claims to prevent clashes with existing names (such as <code>system:</code> groups). For example, the value<code> oidc:</code> creates group names like <code>oidc:engineering</code> and <code>oidc:infra</code>. The prefix can\'t contain <code>system:</code> </p>', 'OidcIdentityProviderConfigRequest$identityProviderConfigName' => '<p>The name of the OIDC provider configuration.</p>', 'OidcIdentityProviderConfigRequest$issuerUrl' => '<p>The URL of the OIDC identity provider that allows the API server to discover public signing keys for verifying tokens. The URL must begin with <code>https://</code> and should correspond to the <code>iss</code> claim in the provider\'s OIDC ID tokens. Based on the OIDC standard, path components are allowed but query parameters are not. Typically the URL consists of only a hostname, like <code>https://server.example.org</code> or <code>https://example.com</code>. This URL should point to the level below <code>.well-known/openid-configuration</code> and must be publicly accessible over the internet.</p>', 'OidcIdentityProviderConfigRequest$clientId' => '<p>This is also known as <i>audience</i>. The ID for the client application that makes authentication requests to the OIDC identity provider.</p>', 'OidcIdentityProviderConfigRequest$usernameClaim' => '<p>The JSON Web Token (JWT) claim to use as the username. The default is <code>sub</code>, which is expected to be a unique identifier of the end user. You can choose other claims, such as <code>email</code> or <code>name</code>, depending on the OIDC identity provider. Claims other than <code>email</code> are prefixed with the issuer URL to prevent naming clashes with other plug-ins.</p>', 'OidcIdentityProviderConfigRequest$usernamePrefix' => '<p>The prefix that is prepended to username claims to prevent clashes with existing names. If you do not provide this field, and <code>username</code> is a value other than <code>email</code>, the prefix defaults to <code>issuerurl#</code>. You can use the value <code>-</code> to disable all prefixing.</p>', 'OidcIdentityProviderConfigRequest$groupsClaim' => '<p>The JWT claim that the provider uses to return your groups.</p>', 'OidcIdentityProviderConfigRequest$groupsPrefix' => '<p>The prefix that is prepended to group claims to prevent clashes with existing names (such as <code>system:</code> groups). For example, the value<code> oidc:</code> will create group names like <code>oidc:engineering</code> and <code>oidc:infra</code>.</p>', 'OutpostConfigRequest$controlPlaneInstanceType' => '<p>The Amazon EC2 instance type that you want to use for your local Amazon EKS cluster on Outposts. Choose an instance type based on the number of nodes that your cluster will have. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/eks-outposts-capacity-considerations.html">Capacity considerations</a> in the <i>Amazon EKS User Guide</i>.</p> <p>The instance type that you specify is used for all Kubernetes control plane instances. The instance type can\'t be changed after cluster creation. The control plane is not automatically scaled by Amazon EKS.</p> <p> </p>', 'OutpostConfigResponse$controlPlaneInstanceType' => '<p>The Amazon EC2 instance type used for the control plane. The instance type is the same for all control plane instances.</p>', 'PodIdentityAssociation$clusterName' => '<p>The name of the cluster that the association is in.</p>', 'PodIdentityAssociation$namespace' => '<p>The name of the Kubernetes namespace inside the cluster to create the association in. The service account and the pods that use the service account must be in this namespace.</p>', 'PodIdentityAssociation$serviceAccount' => '<p>The name of the Kubernetes service account inside the cluster to associate the IAM credentials with.</p>', 'PodIdentityAssociation$roleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role to associate with the service account. The EKS Pod Identity agent manages credentials to assume this role for applications in the containers in the pods that use this service account.</p>', 'PodIdentityAssociation$associationArn' => '<p>The Amazon Resource Name (ARN) of the association.</p>', 'PodIdentityAssociation$associationId' => '<p>The ID of the association.</p>', 'PodIdentityAssociation$ownerArn' => '<p>If defined, the Pod Identity Association is owned by an Amazon EKS Addon.</p>', 'PodIdentityAssociationSummary$clusterName' => '<p>The name of the cluster that the association is in.</p>', 'PodIdentityAssociationSummary$namespace' => '<p>The name of the Kubernetes namespace inside the cluster to create the association in. The service account and the pods that use the service account must be in this namespace.</p>', 'PodIdentityAssociationSummary$serviceAccount' => '<p>The name of the Kubernetes service account inside the cluster to associate the IAM credentials with.</p>', 'PodIdentityAssociationSummary$associationArn' => '<p>The Amazon Resource Name (ARN) of the association.</p>', 'PodIdentityAssociationSummary$associationId' => '<p>The ID of the association.</p>', 'PodIdentityAssociationSummary$ownerArn' => '<p>If defined, the Pod Identity Association is owned by an Amazon EKS Addon.</p>', 'Provider$keyArn' => '<p>Amazon Resource Name (ARN) or alias of the KMS key. The KMS key must be symmetric and created in the same Amazon Web Services Region as the cluster. If the KMS key was created in a different account, the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html">IAM principal</a> must have access to the KMS key. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policy-modifying-external-accounts.html">Allowing users in other accounts to use a KMS key</a> in the <i>Key Management Service Developer Guide</i>.</p>', 'RegisterClusterRequest$clientRequestToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', 'RemoteAccessConfig$ec2SshKey' => '<p>The Amazon EC2 SSH key name that provides access for SSH communication with the nodes in the managed node group. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Amazon EC2 key pairs and Linux instances</a> in the <i>Amazon Elastic Compute Cloud User Guide for Linux Instances</i>. For Windows, an Amazon EC2 SSH key is used to obtain the RDP password. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-key-pairs.html">Amazon EC2 key pairs and Windows instances</a> in the <i>Amazon Elastic Compute Cloud User Guide for Windows Instances</i>.</p>', 'ResourceInUseException$clusterName' => '<p>The Amazon EKS cluster associated with the exception.</p>', 'ResourceInUseException$nodegroupName' => '<p>The Amazon EKS managed node group associated with the exception.</p>', 'ResourceInUseException$addonName' => '<p>The specified add-on name is in use.</p>', 'ResourceInUseException$message' => '<p>The Amazon EKS message associated with the exception.</p>', 'ResourceLimitExceededException$clusterName' => '<p>The Amazon EKS cluster associated with the exception.</p>', 'ResourceLimitExceededException$nodegroupName' => '<p>The Amazon EKS managed node group associated with the exception.</p>', 'ResourceLimitExceededException$subscriptionId' => '<p>The Amazon EKS subscription ID with the exception.</p>', 'ResourceLimitExceededException$message' => '<p>The Amazon EKS message associated with the exception.</p>', 'ResourceNotFoundException$clusterName' => '<p>The Amazon EKS cluster associated with the exception.</p>', 'ResourceNotFoundException$nodegroupName' => '<p>The Amazon EKS managed node group associated with the exception.</p>', 'ResourceNotFoundException$fargateProfileName' => '<p>The Fargate profile associated with the exception.</p>', 'ResourceNotFoundException$addonName' => '<p>The Amazon EKS add-on name associated with the exception.</p>', 'ResourceNotFoundException$subscriptionId' => '<p>The Amazon EKS subscription ID with the exception.</p>', 'ResourceNotFoundException$message' => '<p>The Amazon EKS message associated with the exception.</p>', 'ResourcePropagationDelayException$message' => '<p>Required resources (such as service-linked roles) were created and are still propagating. Retry later.</p>', 'ServerException$clusterName' => '<p>The Amazon EKS cluster associated with the exception.</p>', 'ServerException$nodegroupName' => '<p>The Amazon EKS managed node group associated with the exception.</p>', 'ServerException$addonName' => '<p>The Amazon EKS add-on name associated with the exception.</p>', 'ServerException$subscriptionId' => '<p>The Amazon EKS subscription ID with the exception.</p>', 'ServerException$message' => '<p>These errors are usually caused by a server-side issue.</p>', 'ServiceUnavailableException$message' => '<p>The request has failed due to a temporary failure of the server.</p>', 'StringList$member' => NULL, 'TagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource to add tags to.</p>', 'UnsupportedAvailabilityZoneException$message' => '<p>At least one of your specified cluster subnets is in an Availability Zone that does not support Amazon EKS. The exception output specifies the supported Availability Zones for your account, from which you can choose subnets for your cluster.</p>', 'UnsupportedAvailabilityZoneException$clusterName' => '<p>The Amazon EKS cluster associated with the exception.</p>', 'UnsupportedAvailabilityZoneException$nodegroupName' => '<p>The Amazon EKS managed node group associated with the exception.</p>', 'UntagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource to delete tags from.</p>', 'Update$id' => '<p>A UUID that is used to track the update.</p>', 'UpdateAccessEntryRequest$clusterName' => '<p>The name of your cluster.</p>', 'UpdateAccessEntryRequest$principalArn' => '<p>The ARN of the IAM principal for the <code>AccessEntry</code>.</p>', 'UpdateAccessEntryRequest$clientRequestToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', 'UpdateAccessEntryRequest$username' => '<p>The username to authenticate to Kubernetes with. We recommend not specifying a username and letting Amazon EKS specify it for you. For more information about the value Amazon EKS specifies for you, or constraints before specifying your own username, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/access-entries.html#creating-access-entries">Creating access entries</a> in the <i>Amazon EKS User Guide</i>.</p>', 'UpdateAddonRequest$addonName' => '<p>The name of the add-on. The name must match one of the names returned by <a href="https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html"> <code>ListAddons</code> </a>.</p>', 'UpdateAddonRequest$addonVersion' => '<p>The version of the add-on. The version must match one of the versions returned by <a href="https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeAddonVersions.html"> <code>DescribeAddonVersions</code> </a>.</p>', 'UpdateAddonRequest$clientRequestToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', 'UpdateAddonRequest$configurationValues' => '<p>The set of configuration values for the add-on that\'s created. The values that you provide are validated against the schema returned by <code>DescribeAddonConfiguration</code>.</p>', 'UpdateClusterConfigRequest$name' => '<p>The name of the Amazon EKS cluster to update.</p>', 'UpdateClusterConfigRequest$clientRequestToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', 'UpdateClusterVersionRequest$name' => '<p>The name of the Amazon EKS cluster to update.</p>', 'UpdateClusterVersionRequest$version' => '<p>The desired Kubernetes version following a successful update.</p>', 'UpdateClusterVersionRequest$clientRequestToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', 'UpdateEksAnywhereSubscriptionRequest$id' => '<p>The ID of the subscription.</p>', 'UpdateEksAnywhereSubscriptionRequest$clientRequestToken' => '<p>Unique, case-sensitive identifier to ensure the idempotency of the request.</p>', 'UpdateNodegroupConfigRequest$clusterName' => '<p>The name of your cluster.</p>', 'UpdateNodegroupConfigRequest$nodegroupName' => '<p>The name of the managed node group to update.</p>', 'UpdateNodegroupConfigRequest$clientRequestToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', 'UpdateNodegroupVersionRequest$clusterName' => '<p>The name of your cluster.</p>', 'UpdateNodegroupVersionRequest$nodegroupName' => '<p>The name of the managed node group to update.</p>', 'UpdateNodegroupVersionRequest$version' => '<p>The Kubernetes version to update to. If no version is specified, then the Kubernetes version of the node group does not change. You can specify the Kubernetes version of the cluster to update the node group to the latest AMI version of the cluster\'s Kubernetes version. If you specify <code>launchTemplate</code>, and your launch template uses a custom AMI, then don\'t specify <code>version</code>, or the node group update will fail. For more information about using launch templates with Amazon EKS, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Customizing managed nodes with launch templates</a> in the <i>Amazon EKS User Guide</i>.</p>', 'UpdateNodegroupVersionRequest$releaseVersion' => '<p>The AMI version of the Amazon EKS optimized AMI to use for the update. By default, the latest available AMI version for the node group\'s Kubernetes version is used. For information about Linux versions, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html">Amazon EKS optimized Amazon Linux AMI versions</a> in the <i>Amazon EKS User Guide</i>. Amazon EKS managed node groups support the November 2022 and later releases of the Windows AMIs. For information about Windows versions, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/eks-ami-versions-windows.html">Amazon EKS optimized Windows AMI versions</a> in the <i>Amazon EKS User Guide</i>.</p> <p>If you specify <code>launchTemplate</code>, and your launch template uses a custom AMI, then don\'t specify <code>releaseVersion</code>, or the node group update will fail. For more information about using launch templates with Amazon EKS, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Customizing managed nodes with launch templates</a> in the <i>Amazon EKS User Guide</i>.</p>', 'UpdateNodegroupVersionRequest$clientRequestToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', 'UpdateParam$value' => '<p>The value of the keys submitted as part of an update request.</p>', 'UpdatePodIdentityAssociationRequest$clusterName' => '<p>The name of the cluster that you want to update the association in.</p>', 'UpdatePodIdentityAssociationRequest$associationId' => '<p>The ID of the association to be updated.</p>', 'UpdatePodIdentityAssociationRequest$roleArn' => '<p>The new IAM role to change the </p>', 'UpdatePodIdentityAssociationRequest$clientRequestToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', 'VpcConfigResponse$clusterSecurityGroupId' => '<p>The cluster security group that was created by Amazon EKS for the cluster. Managed node groups use this security group for control-plane-to-data-plane communication.</p>', 'VpcConfigResponse$vpcId' => '<p>The VPC associated with your cluster.</p>', 'labelsKeyList$member' => NULL, ], ], 'StringList' => [ 'base' => NULL, 'refs' => [ 'AccessEntry$kubernetesGroups' => '<p>A <code>name</code> that you\'ve specified in a Kubernetes <code>RoleBinding</code> or <code>ClusterRoleBinding</code> object so that Kubernetes authorizes the <code>principalARN</code> access to cluster objects.</p>', 'AccessScope$namespaces' => '<p>A Kubernetes <code>namespace</code> that an access policy is scoped to. A value is required if you specified <code>namespace</code> for <code>Type</code>.</p>', 'Addon$podIdentityAssociations' => '<p>An array of Pod Identity Assocations owned by the Addon. Each EKS Pod Identity association maps a role to a service account in a namespace in the cluster.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/add-ons-iam.html">Attach an IAM Role to an Amazon EKS add-on using Pod Identity</a> in the EKS User Guide.</p>', 'AddonIssue$resourceIds' => '<p>The resource IDs of the issue.</p>', 'AddonPodIdentityConfiguration$recommendedManagedPolicies' => '<p>A suggested IAM Policy for the addon.</p>', 'AddonVersionInfo$architecture' => '<p>The architectures that the version supports.</p>', 'ClusterIssue$resourceIds' => '<p>The resource IDs that the issue relates to.</p>', 'Compatibility$platformVersions' => '<p>The supported compute platform.</p>', 'CreateAccessEntryRequest$kubernetesGroups' => '<p>The value for <code>name</code> that you\'ve specified for <code>kind: Group</code> as a <code>subject</code> in a Kubernetes <code>RoleBinding</code> or <code>ClusterRoleBinding</code> object. Amazon EKS doesn\'t confirm that the value for <code>name</code> exists in any bindings on your cluster. You can specify one or more names.</p> <p>Kubernetes authorizes the <code>principalArn</code> of the access entry to access any cluster objects that you\'ve specified in a Kubernetes <code>Role</code> or <code>ClusterRole</code> object that is also specified in a binding\'s <code>roleRef</code>. For more information about creating Kubernetes <code>RoleBinding</code>, <code>ClusterRoleBinding</code>, <code>Role</code>, or <code>ClusterRole</code> objects, see <a href="https://kubernetes.io/docs/reference/access-authn-authz/rbac/">Using RBAC Authorization in the Kubernetes documentation</a>.</p> <p>If you want Amazon EKS to authorize the <code>principalArn</code> (instead of, or in addition to Kubernetes authorizing the <code>principalArn</code>), you can associate one or more access policies to the access entry using <code>AssociateAccessPolicy</code>. If you associate any access policies, the <code>principalARN</code> has all permissions assigned in the associated access policies and all permissions in any Kubernetes <code>Role</code> or <code>ClusterRole</code> objects that the group names are bound to.</p>', 'CreateFargateProfileRequest$subnets' => '<p>The IDs of subnets to launch a <code>Pod</code> into. A <code>Pod</code> running on Fargate isn\'t assigned a public IP address, so only private subnets (with no direct route to an Internet Gateway) are accepted for this parameter.</p>', 'CreateNodegroupRequest$subnets' => '<p>The subnets to use for the Auto Scaling group that is created for your node group. If you specify <code>launchTemplate</code>, then don\'t specify <code> <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkInterface.html">SubnetId</a> </code> in your launch template, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Customizing managed nodes with launch templates</a> in the <i>Amazon EKS User Guide</i>.</p>', 'CreateNodegroupRequest$instanceTypes' => '<p>Specify the instance types for a node group. If you specify a GPU instance type, make sure to also specify an applicable GPU AMI type with the <code>amiType</code> parameter. If you specify <code>launchTemplate</code>, then you can specify zero or one instance type in your launch template <i>or</i> you can specify 0-20 instance types for <code>instanceTypes</code>. If however, you specify an instance type in your launch template <i>and</i> specify any <code>instanceTypes</code>, the node group deployment will fail. If you don\'t specify an instance type in a launch template or for <code>instanceTypes</code>, then <code>t3.medium</code> is used, by default. If you specify <code>Spot</code> for <code>capacityType</code>, then we recommend specifying multiple values for <code>instanceTypes</code>. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/managed-node-groups.html#managed-node-group-capacity-types">Managed node group capacity types</a> and <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Customizing managed nodes with launch templates</a> in the <i>Amazon EKS User Guide</i>.</p>', 'DescribeAddonVersionsRequest$types' => '<p>The type of the add-on. For valid <code>types</code>, don\'t specify a value for this property.</p>', 'DescribeAddonVersionsRequest$publishers' => '<p>The publisher of the add-on. For valid <code>publishers</code>, don\'t specify a value for this property.</p>', 'DescribeAddonVersionsRequest$owners' => '<p>The owner of the add-on. For valid <code>owners</code>, don\'t specify a value for this property.</p>', 'EksAnywhereSubscription$licenseArns' => '<p>Amazon Web Services License Manager ARN associated with the subscription.</p>', 'EncryptionConfig$resources' => '<p>Specifies the resources to be encrypted. The only supported value is <code>secrets</code>.</p>', 'ErrorDetail$resourceIds' => '<p>An optional field that contains the resource IDs associated with the error.</p>', 'FargateProfile$subnets' => '<p>The IDs of subnets to launch a <code>Pod</code> into.</p>', 'FargateProfileIssue$resourceIds' => '<p>The Amazon Web Services resources that are affected by this issue.</p>', 'InsightsFilter$kubernetesVersions' => '<p>The Kubernetes versions to use to filter the insights.</p>', 'Issue$resourceIds' => '<p>The Amazon Web Services resources that are afflicted by this issue.</p>', 'ListAccessEntriesResponse$accessEntries' => '<p>The list of access entries that exist for the cluster.</p>', 'ListAddonsResponse$addons' => '<p>A list of installed add-ons.</p>', 'ListClustersResponse$clusters' => '<p>A list of all of the clusters for your account in the specified Amazon Web Services Region.</p>', 'ListFargateProfilesResponse$fargateProfileNames' => '<p>A list of all of the Fargate profiles associated with the specified cluster.</p>', 'ListNodegroupsResponse$nodegroups' => '<p>A list of all of the node groups associated with the specified cluster.</p>', 'ListUpdatesResponse$updateIds' => '<p>A list of all the updates for the specified cluster and Region.</p>', 'Nodegroup$instanceTypes' => '<p>If the node group wasn\'t deployed with a launch template, then this is the instance type that is associated with the node group. If the node group was deployed with a launch template, then this is <code>null</code>.</p>', 'Nodegroup$subnets' => '<p>The subnets that were specified for the Auto Scaling group that is associated with your node group.</p>', 'OutpostConfigRequest$outpostArns' => '<p>The ARN of the Outpost that you want to use for your local Amazon EKS cluster on Outposts. Only a single Outpost ARN is supported.</p>', 'OutpostConfigResponse$outpostArns' => '<p>The ARN of the Outpost that you specified for use with your local Amazon EKS cluster on Outposts.</p>', 'RemoteAccessConfig$sourceSecurityGroups' => '<p>The security group IDs that are allowed SSH access (port 22) to the nodes. For Windows, the port is 3389. If you specify an Amazon EC2 SSH key but don\'t specify a source security group when you create a managed node group, then the port on the nodes is opened to the internet (<code>0.0.0.0/0</code>). For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html">Security Groups for Your VPC</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'UnsupportedAvailabilityZoneException$validZones' => '<p>The supported Availability Zones for your account. Choose subnets in these Availability Zones for your cluster.</p>', 'UpdateAccessEntryRequest$kubernetesGroups' => '<p>The value for <code>name</code> that you\'ve specified for <code>kind: Group</code> as a <code>subject</code> in a Kubernetes <code>RoleBinding</code> or <code>ClusterRoleBinding</code> object. Amazon EKS doesn\'t confirm that the value for <code>name</code> exists in any bindings on your cluster. You can specify one or more names.</p> <p>Kubernetes authorizes the <code>principalArn</code> of the access entry to access any cluster objects that you\'ve specified in a Kubernetes <code>Role</code> or <code>ClusterRole</code> object that is also specified in a binding\'s <code>roleRef</code>. For more information about creating Kubernetes <code>RoleBinding</code>, <code>ClusterRoleBinding</code>, <code>Role</code>, or <code>ClusterRole</code> objects, see <a href="https://kubernetes.io/docs/reference/access-authn-authz/rbac/">Using RBAC Authorization in the Kubernetes documentation</a>.</p> <p>If you want Amazon EKS to authorize the <code>principalArn</code> (instead of, or in addition to Kubernetes authorizing the <code>principalArn</code>), you can associate one or more access policies to the access entry using <code>AssociateAccessPolicy</code>. If you associate any access policies, the <code>principalARN</code> has all permissions assigned in the associated access policies and all permissions in any Kubernetes <code>Role</code> or <code>ClusterRole</code> objects that the group names are bound to.</p>', 'VpcConfigRequest$subnetIds' => '<p>Specify subnets for your Amazon EKS nodes. Amazon EKS creates cross-account elastic network interfaces in these subnets to allow communication between your nodes and the Kubernetes control plane.</p>', 'VpcConfigRequest$securityGroupIds' => '<p>Specify one or more security groups for the cross-account elastic network interfaces that Amazon EKS creates to use that allow communication between your nodes and the Kubernetes control plane. If you don\'t specify any security groups, then familiarize yourself with the difference between Amazon EKS defaults for clusters deployed with Kubernetes. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html">Amazon EKS security group considerations</a> in the <i> <i>Amazon EKS User Guide</i> </i>.</p>', 'VpcConfigRequest$publicAccessCidrs' => '<p>The CIDR blocks that are allowed access to your cluster\'s public Kubernetes API server endpoint. Communication to the endpoint from addresses outside of the CIDR blocks that you specify is denied. The default value is <code>0.0.0.0/0</code>. If you\'ve disabled private endpoint access, make sure that you specify the necessary CIDR blocks for every node and Fargate <code>Pod</code> in the cluster. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Amazon EKS cluster endpoint access control</a> in the <i> <i>Amazon EKS User Guide</i> </i>.</p>', 'VpcConfigResponse$subnetIds' => '<p>The subnets associated with your cluster.</p>', 'VpcConfigResponse$securityGroupIds' => '<p>The security groups associated with the cross-account elastic network interfaces that are used to allow communication between your nodes and the Kubernetes control plane.</p>', 'VpcConfigResponse$publicAccessCidrs' => '<p>The CIDR blocks that are allowed access to your cluster\'s public Kubernetes API server endpoint.</p>', ], ], 'TagKey' => [ 'base' => '<p>One part of a key-value pair that make up a tag. A <code>key</code> is a general label that acts like a category for more specific tag values.</p>', 'refs' => [ 'TagKeyList$member' => NULL, 'TagMap$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>The keys of the tags to remove.</p>', ], ], 'TagMap' => [ 'base' => '<p>The metadata that you apply to a resource to help you categorize and organize them. Each tag consists of a key and an optional value. You define them.</p> <p>The following basic restrictions apply to tags:</p> <ul> <li> <p>Maximum number of tags per resource – 50</p> </li> <li> <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p> </li> <li> <p>Maximum key length – 128 Unicode characters in UTF-8</p> </li> <li> <p>Maximum value length – 256 Unicode characters in UTF-8</p> </li> <li> <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p> </li> <li> <p>Tag keys and values are case-sensitive.</p> </li> <li> <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.</p> </li> </ul>', 'refs' => [ 'AccessEntry$tags' => '<p>Metadata that assists with categorization and organization. Each tag consists of a key and an optional value. You define both. Tags don\'t propagate to any other cluster or Amazon Web Services resources.</p>', 'Addon$tags' => '<p>Metadata that assists with categorization and organization. Each tag consists of a key and an optional value. You define both. Tags don\'t propagate to any other cluster or Amazon Web Services resources.</p>', 'AssociateIdentityProviderConfigRequest$tags' => '<p>Metadata that assists with categorization and organization. Each tag consists of a key and an optional value. You define both. Tags don\'t propagate to any other cluster or Amazon Web Services resources.</p>', 'AssociateIdentityProviderConfigResponse$tags' => '<p>The tags for the resource.</p>', 'Cluster$tags' => '<p>Metadata that assists with categorization and organization. Each tag consists of a key and an optional value. You define both. Tags don\'t propagate to any other cluster or Amazon Web Services resources.</p>', 'CreateAccessEntryRequest$tags' => '<p>Metadata that assists with categorization and organization. Each tag consists of a key and an optional value. You define both. Tags don\'t propagate to any other cluster or Amazon Web Services resources.</p>', 'CreateAddonRequest$tags' => '<p>Metadata that assists with categorization and organization. Each tag consists of a key and an optional value. You define both. Tags don\'t propagate to any other cluster or Amazon Web Services resources.</p>', 'CreateClusterRequest$tags' => '<p>Metadata that assists with categorization and organization. Each tag consists of a key and an optional value. You define both. Tags don\'t propagate to any other cluster or Amazon Web Services resources.</p>', 'CreateEksAnywhereSubscriptionRequest$tags' => '<p>The metadata for a subscription to assist with categorization and organization. Each tag consists of a key and an optional value. Subscription tags don\'t propagate to any other resources associated with the subscription.</p>', 'CreateFargateProfileRequest$tags' => '<p>Metadata that assists with categorization and organization. Each tag consists of a key and an optional value. You define both. Tags don\'t propagate to any other cluster or Amazon Web Services resources.</p>', 'CreateNodegroupRequest$tags' => '<p>Metadata that assists with categorization and organization. Each tag consists of a key and an optional value. You define both. Tags don\'t propagate to any other cluster or Amazon Web Services resources.</p>', 'CreatePodIdentityAssociationRequest$tags' => '<p>Metadata that assists with categorization and organization. Each tag consists of a key and an optional value. You define both. Tags don\'t propagate to any other cluster or Amazon Web Services resources.</p> <p>The following basic restrictions apply to tags:</p> <ul> <li> <p>Maximum number of tags per resource – 50</p> </li> <li> <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p> </li> <li> <p>Maximum key length – 128 Unicode characters in UTF-8</p> </li> <li> <p>Maximum value length – 256 Unicode characters in UTF-8</p> </li> <li> <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p> </li> <li> <p>Tag keys and values are case-sensitive.</p> </li> <li> <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.</p> </li> </ul>', 'EksAnywhereSubscription$tags' => '<p>The metadata for a subscription to assist with categorization and organization. Each tag consists of a key and an optional value. Subscription tags do not propagate to any other resources associated with the subscription.</p>', 'FargateProfile$tags' => '<p>Metadata that assists with categorization and organization. Each tag consists of a key and an optional value. You define both. Tags don\'t propagate to any other cluster or Amazon Web Services resources.</p>', 'ListTagsForResourceResponse$tags' => '<p>The tags for the resource.</p>', 'Nodegroup$tags' => '<p>Metadata that assists with categorization and organization. Each tag consists of a key and an optional value. You define both. Tags don\'t propagate to any other cluster or Amazon Web Services resources.</p>', 'OidcIdentityProviderConfig$tags' => '<p>Metadata that assists with categorization and organization. Each tag consists of a key and an optional value. You define both. Tags don\'t propagate to any other cluster or Amazon Web Services resources.</p>', 'PodIdentityAssociation$tags' => '<p>Metadata that assists with categorization and organization. Each tag consists of a key and an optional value. You define both. Tags don\'t propagate to any other cluster or Amazon Web Services resources.</p> <p>The following basic restrictions apply to tags:</p> <ul> <li> <p>Maximum number of tags per resource – 50</p> </li> <li> <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p> </li> <li> <p>Maximum key length – 128 Unicode characters in UTF-8</p> </li> <li> <p>Maximum value length – 256 Unicode characters in UTF-8</p> </li> <li> <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p> </li> <li> <p>Tag keys and values are case-sensitive.</p> </li> <li> <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.</p> </li> </ul>', 'RegisterClusterRequest$tags' => '<p>Metadata that assists with categorization and organization. Each tag consists of a key and an optional value. You define both. Tags don\'t propagate to any other cluster or Amazon Web Services resources.</p>', 'TagResourceRequest$tags' => '<p>Metadata that assists with categorization and organization. Each tag consists of a key and an optional value. You define both. Tags don\'t propagate to any other cluster or Amazon Web Services resources.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => '<p>The optional part of a key-value pair that make up a tag. A <code>value</code> acts as a descriptor within a tag category (key).</p>', 'refs' => [ 'TagMap$value' => NULL, ], ], 'Taint' => [ 'base' => '<p>A property that allows a node to repel a <code>Pod</code>. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/node-taints-managed-node-groups.html">Node taints on managed node groups</a> in the <i>Amazon EKS User Guide</i>.</p>', 'refs' => [ 'taintsList$member' => NULL, ], ], 'TaintEffect' => [ 'base' => NULL, 'refs' => [ 'Taint$effect' => '<p>The effect of the taint.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'AccessEntry$createdAt' => '<p>The Unix epoch timestamp at object creation.</p>', 'AccessEntry$modifiedAt' => '<p>The Unix epoch timestamp for the last modification to the object.</p>', 'Addon$createdAt' => '<p>The Unix epoch timestamp at object creation.</p>', 'Addon$modifiedAt' => '<p>The Unix epoch timestamp for the last modification to the object.</p>', 'AssociatedAccessPolicy$associatedAt' => '<p>The date and time the <code>AccessPolicy</code> was associated with an <code>AccessEntry</code>.</p>', 'AssociatedAccessPolicy$modifiedAt' => '<p>The Unix epoch timestamp for the last modification to the object.</p>', 'ClientStat$lastRequestTime' => '<p>The timestamp of the last request seen from the Kubernetes client.</p>', 'Cluster$createdAt' => '<p>The Unix epoch timestamp at object creation.</p>', 'ConnectorConfigResponse$activationExpiry' => '<p>The expiration time of the connected cluster. The cluster\'s YAML file must be applied through the native provider.</p>', 'EksAnywhereSubscription$createdAt' => '<p>The Unix timestamp in seconds for when the subscription was created.</p>', 'EksAnywhereSubscription$effectiveDate' => '<p>The Unix timestamp in seconds for when the subscription is effective.</p>', 'EksAnywhereSubscription$expirationDate' => '<p>The Unix timestamp in seconds for when the subscription will expire or auto renew, depending on the auto renew configuration of the subscription object.</p>', 'FargateProfile$createdAt' => '<p>The Unix epoch timestamp at object creation.</p>', 'Insight$lastRefreshTime' => '<p>The time Amazon EKS last successfully completed a refresh of this insight check on the cluster.</p>', 'Insight$lastTransitionTime' => '<p>The time the status of the insight last changed.</p>', 'InsightSummary$lastRefreshTime' => '<p>The time Amazon EKS last successfully completed a refresh of this insight check on the cluster.</p>', 'InsightSummary$lastTransitionTime' => '<p>The time the status of the insight last changed.</p>', 'Nodegroup$createdAt' => '<p>The Unix epoch timestamp at object creation.</p>', 'Nodegroup$modifiedAt' => '<p>The Unix epoch timestamp for the last modification to the object.</p>', 'PodIdentityAssociation$createdAt' => '<p>The timestamp that the association was created at.</p>', 'PodIdentityAssociation$modifiedAt' => '<p>The most recent timestamp that the association was modified at</p>', 'Update$createdAt' => '<p>The Unix epoch timestamp at object creation.</p>', ], ], 'UnsupportedAvailabilityZoneException' => [ 'base' => '<p>At least one of your specified cluster subnets is in an Availability Zone that does not support Amazon EKS. The exception output specifies the supported Availability Zones for your account, from which you can choose subnets for your cluster.</p>', 'refs' => [], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'Update' => [ 'base' => '<p>An object representing an asynchronous update.</p>', 'refs' => [ 'AssociateEncryptionConfigResponse$update' => NULL, 'AssociateIdentityProviderConfigResponse$update' => NULL, 'DescribeUpdateResponse$update' => '<p>The full description of the specified update.</p>', 'DisassociateIdentityProviderConfigResponse$update' => NULL, 'UpdateAddonResponse$update' => NULL, 'UpdateClusterConfigResponse$update' => NULL, 'UpdateClusterVersionResponse$update' => '<p>The full description of the specified update</p>', 'UpdateNodegroupConfigResponse$update' => NULL, 'UpdateNodegroupVersionResponse$update' => NULL, ], ], 'UpdateAccessConfigRequest' => [ 'base' => '<p>The access configuration information for the cluster.</p>', 'refs' => [ 'UpdateClusterConfigRequest$accessConfig' => '<p>The access configuration for the cluster.</p>', ], ], 'UpdateAccessEntryRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAccessEntryResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAddonRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAddonResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateClusterConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateClusterConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateClusterVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateClusterVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEksAnywhereSubscriptionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEksAnywhereSubscriptionResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateLabelsPayload' => [ 'base' => '<p>An object representing a Kubernetes <code>label</code> change for a managed node group.</p>', 'refs' => [ 'UpdateNodegroupConfigRequest$labels' => '<p>The Kubernetes <code>labels</code> to apply to the nodes in the node group after the update.</p>', ], ], 'UpdateNodegroupConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateNodegroupConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateNodegroupVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateNodegroupVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateParam' => [ 'base' => '<p>An object representing the details of an update request.</p>', 'refs' => [ 'UpdateParams$member' => NULL, ], ], 'UpdateParamType' => [ 'base' => NULL, 'refs' => [ 'UpdateParam$type' => '<p>The keys associated with an update request.</p>', ], ], 'UpdateParams' => [ 'base' => NULL, 'refs' => [ 'Update$params' => '<p>A key-value map that contains the parameters associated with the update.</p>', ], ], 'UpdatePodIdentityAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePodIdentityAssociationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateStatus' => [ 'base' => NULL, 'refs' => [ 'Update$status' => '<p>The current status of the update.</p>', ], ], 'UpdateTaintsPayload' => [ 'base' => '<p>An object representing the details of an update to a taints payload. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/node-taints-managed-node-groups.html">Node taints on managed node groups</a> in the <i>Amazon EKS User Guide</i>.</p>', 'refs' => [ 'UpdateNodegroupConfigRequest$taints' => '<p>The Kubernetes taints to be applied to the nodes in the node group after the update. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/node-taints-managed-node-groups.html">Node taints on managed node groups</a>.</p>', ], ], 'UpdateType' => [ 'base' => NULL, 'refs' => [ 'Update$type' => '<p>The type of the update.</p>', ], ], 'VpcConfigRequest' => [ 'base' => '<p>An object representing the VPC configuration to use for an Amazon EKS cluster.</p>', 'refs' => [ 'CreateClusterRequest$resourcesVpcConfig' => '<p>The VPC configuration that\'s used by the cluster control plane. Amazon EKS VPC resources have specific requirements to work properly with Kubernetes. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html">Cluster VPC Considerations</a> and <a href="https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html">Cluster Security Group Considerations</a> in the <i>Amazon EKS User Guide</i>. You must specify at least two subnets. You can specify up to five security groups. However, we recommend that you use a dedicated security group for your cluster control plane.</p>', 'UpdateClusterConfigRequest$resourcesVpcConfig' => NULL, ], ], 'VpcConfigResponse' => [ 'base' => '<p>An object representing an Amazon EKS cluster VPC configuration response.</p>', 'refs' => [ 'Cluster$resourcesVpcConfig' => '<p>The VPC configuration used by the cluster control plane. Amazon EKS VPC resources have specific requirements to work properly with Kubernetes. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html">Cluster VPC considerations</a> and <a href="https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html">Cluster security group considerations</a> in the <i>Amazon EKS User Guide</i>.</p>', ], ], 'ZeroCapacity' => [ 'base' => NULL, 'refs' => [ 'NodegroupScalingConfig$minSize' => '<p>The minimum number of nodes that the managed node group can scale in to.</p>', 'NodegroupScalingConfig$desiredSize' => '<p>The current number of nodes that the managed node group should maintain.</p> <important> <p>If you use the Kubernetes <a href="https://github.com/kubernetes/autoscaler#kubernetes-autoscaler">Cluster Autoscaler</a>, you shouldn\'t change the <code>desiredSize</code> value directly, as this can cause the Cluster Autoscaler to suddenly scale up or scale down.</p> </important> <p>Whenever this parameter changes, the number of worker nodes in the node group is updated to the specified size. If this parameter is given a value that is smaller than the current number of running worker nodes, the necessary number of worker nodes are terminated to match the given value. When using CloudFormation, no action occurs if you remove this parameter from your CFN template.</p> <p>This parameter can be different from <code>minSize</code> in some cases, such as when starting with extra hosts for testing. This parameter can also be different when you want to start with an estimated number of needed hosts, but let the Cluster Autoscaler reduce the number if there are too many. When the Cluster Autoscaler is used, the <code>desiredSize</code> parameter is altered by the Cluster Autoscaler (but can be out-of-date for short periods of time). the Cluster Autoscaler doesn\'t scale a managed node group lower than <code>minSize</code> or higher than <code>maxSize</code>.</p>', ], ], 'configStatus' => [ 'base' => NULL, 'refs' => [ 'OidcIdentityProviderConfig$status' => '<p>The status of the OIDC identity provider.</p>', ], ], 'labelKey' => [ 'base' => NULL, 'refs' => [ 'labelsMap$key' => NULL, ], ], 'labelValue' => [ 'base' => NULL, 'refs' => [ 'labelsMap$value' => NULL, ], ], 'labelsKeyList' => [ 'base' => NULL, 'refs' => [ 'UpdateLabelsPayload$removeLabels' => '<p>The Kubernetes <code>labels</code> to remove.</p>', ], ], 'labelsMap' => [ 'base' => NULL, 'refs' => [ 'CreateNodegroupRequest$labels' => '<p>The Kubernetes <code>labels</code> to apply to the nodes in the node group when they are created.</p>', 'Nodegroup$labels' => '<p>The Kubernetes <code>labels</code> applied to the nodes in the node group.</p> <note> <p>Only <code>labels</code> that are applied with the Amazon EKS API are shown here. There may be other Kubernetes <code>labels</code> applied to the nodes in this group.</p> </note>', 'UpdateLabelsPayload$addOrUpdateLabels' => '<p>The Kubernetes <code>labels</code> to add or update.</p>', ], ], 'requiredClaimsKey' => [ 'base' => NULL, 'refs' => [ 'requiredClaimsMap$key' => NULL, ], ], 'requiredClaimsMap' => [ 'base' => NULL, 'refs' => [ 'OidcIdentityProviderConfig$requiredClaims' => '<p>The key-value pairs that describe required claims in the identity token. If set, each claim is verified to be present in the token with a matching value.</p>', 'OidcIdentityProviderConfigRequest$requiredClaims' => '<p>The key value pairs that describe required claims in the identity token. If set, each claim is verified to be present in the token with a matching value. For the maximum number of claims that you can require, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/service-quotas.html">Amazon EKS service quotas</a> in the <i>Amazon EKS User Guide</i>.</p>', ], ], 'requiredClaimsValue' => [ 'base' => NULL, 'refs' => [ 'requiredClaimsMap$value' => NULL, ], ], 'taintKey' => [ 'base' => NULL, 'refs' => [ 'Taint$key' => '<p>The key of the taint.</p>', ], ], 'taintValue' => [ 'base' => NULL, 'refs' => [ 'Taint$value' => '<p>The value of the taint.</p>', ], ], 'taintsList' => [ 'base' => NULL, 'refs' => [ 'CreateNodegroupRequest$taints' => '<p>The Kubernetes taints to be applied to the nodes in the node group. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/node-taints-managed-node-groups.html">Node taints on managed node groups</a>.</p>', 'Nodegroup$taints' => '<p>The Kubernetes taints to be applied to the nodes in the node group when they are created. Effect is one of <code>No_Schedule</code>, <code>Prefer_No_Schedule</code>, or <code>No_Execute</code>. Kubernetes taints can be used together with tolerations to control how workloads are scheduled to your nodes. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/node-taints-managed-node-groups.html">Node taints on managed node groups</a>.</p>', 'UpdateTaintsPayload$addOrUpdateTaints' => '<p>Kubernetes taints to be added or updated.</p>', 'UpdateTaintsPayload$removeTaints' => '<p>Kubernetes taints to remove.</p>', ], ], ],];
