<?php
// This file was auto-generated from sdk-root/src/data/elasticloadbalancingv2/2015-12-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Elastic Load Balancing</fullname> <p>A load balancer distributes incoming traffic across targets, such as your EC2 instances. This enables you to increase the availability of your application. The load balancer also monitors the health of its registered targets and ensures that it routes traffic only to healthy targets. You configure your load balancer to accept incoming traffic by specifying one or more listeners, which are configured with a protocol and port number for connections from clients to the load balancer. You configure a target group with a protocol and port number for connections from the load balancer to the targets, and with health check settings to be used when checking the health status of the targets.</p> <p>Elastic Load Balancing supports the following types of load balancers: Application Load Balancers, Network Load Balancers, Gateway Load Balancers, and Classic Load Balancers. This reference covers the following load balancer types:</p> <ul> <li> <p>Application Load Balancer - Operates at the application layer (layer 7) and supports HTTP and HTTPS.</p> </li> <li> <p>Network Load Balancer - Operates at the transport layer (layer 4) and supports TCP, TLS, and UDP.</p> </li> <li> <p>Gateway Load Balancer - Operates at the network layer (layer 3).</p> </li> </ul> <p>For more information, see the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/userguide/">Elastic Load Balancing User Guide</a>.</p> <p>All Elastic Load Balancing operations are idempotent, which means that they complete at most one time. If you repeat an operation, it succeeds.</p>', 'operations' => [ 'AddListenerCertificates' => '<p>Adds the specified SSL server certificate to the certificate list for the specified HTTPS or TLS listener.</p> <p>If the certificate in already in the certificate list, the call is successful but the certificate is not added again.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html">HTTPS listeners</a> in the <i>Application Load Balancers Guide</i> or <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html">TLS listeners</a> in the <i>Network Load Balancers Guide</i>.</p>', 'AddTags' => '<p>Adds the specified tags to the specified Elastic Load Balancing resource. You can tag your Application Load Balancers, Network Load Balancers, Gateway Load Balancers, target groups, trust stores, listeners, and rules.</p> <p>Each tag consists of a key and an optional value. If a resource already has a tag with the same key, <code>AddTags</code> updates its value.</p>', 'AddTrustStoreRevocations' => '<p>Adds the specified revocation file to the specified trust store.</p>', 'CreateListener' => '<p>Creates a listener for the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer.</p> <p>For more information, see the following:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html">Listeners for your Application Load Balancers</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-listeners.html">Listeners for your Network Load Balancers</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/gateway-listeners.html">Listeners for your Gateway Load Balancers</a> </p> </li> </ul> <p>This operation is idempotent, which means that it completes at most one time. If you attempt to create multiple listeners with the same settings, each call succeeds.</p>', 'CreateLoadBalancer' => '<p>Creates an Application Load Balancer, Network Load Balancer, or Gateway Load Balancer.</p> <p>For more information, see the following:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/application-load-balancers.html">Application Load Balancers</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html">Network Load Balancers</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/gateway-load-balancers.html">Gateway Load Balancers</a> </p> </li> </ul> <p>This operation is idempotent, which means that it completes at most one time. If you attempt to create multiple load balancers with the same settings, each call succeeds.</p>', 'CreateRule' => '<p>Creates a rule for the specified listener. The listener must be associated with an Application Load Balancer.</p> <p>Each rule consists of a priority, one or more actions, and one or more conditions. Rules are evaluated in priority order, from the lowest value to the highest value. When the conditions for a rule are met, its actions are performed. If the conditions for no rules are met, the actions for the default rule are performed. For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#listener-rules">Listener rules</a> in the <i>Application Load Balancers Guide</i>.</p>', 'CreateTargetGroup' => '<p>Creates a target group.</p> <p>For more information, see the following:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html">Target groups for your Application Load Balancers</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html">Target groups for your Network Load Balancers</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/target-groups.html">Target groups for your Gateway Load Balancers</a> </p> </li> </ul> <p>This operation is idempotent, which means that it completes at most one time. If you attempt to create multiple target groups with the same settings, each call succeeds.</p>', 'CreateTrustStore' => '<p>Creates a trust store.</p>', 'DeleteListener' => '<p>Deletes the specified listener.</p> <p>Alternatively, your listener is deleted when you delete the load balancer to which it is attached.</p>', 'DeleteLoadBalancer' => '<p>Deletes the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer. Deleting a load balancer also deletes its listeners.</p> <p>You can\'t delete a load balancer if deletion protection is enabled. If the load balancer does not exist or has already been deleted, the call succeeds.</p> <p>Deleting a load balancer does not affect its registered targets. For example, your EC2 instances continue to run and are still registered to their target groups. If you no longer need these EC2 instances, you can stop or terminate them.</p>', 'DeleteRule' => '<p>Deletes the specified rule.</p> <p>You can\'t delete the default rule.</p>', 'DeleteTargetGroup' => '<p>Deletes the specified target group.</p> <p>You can delete a target group if it is not referenced by any actions. Deleting a target group also deletes any associated health checks. Deleting a target group does not affect its registered targets. For example, any EC2 instances continue to run until you stop or terminate them.</p>', 'DeleteTrustStore' => '<p>Deletes a trust store.</p>', 'DeregisterTargets' => '<p>Deregisters the specified targets from the specified target group. After the targets are deregistered, they no longer receive traffic from the load balancer.</p> <p>The load balancer stops sending requests to targets that are deregistering, but uses connection draining to ensure that in-flight traffic completes on the existing connections. This deregistration delay is configured by default but can be updated for each target group.</p> <p>For more information, see the following:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html#deregistration-delay"> Deregistration delay</a> in the <i>Application Load Balancers User Guide</i> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#deregistration-delay"> Deregistration delay</a> in the <i>Network Load Balancers User Guide</i> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/target-groups.html#deregistration-delay"> Deregistration delay</a> in the <i>Gateway Load Balancers User Guide</i> </p> </li> </ul> <p>Note: If the specified target does not exist, the action returns successfully.</p>', 'DescribeAccountLimits' => '<p>Describes the current Elastic Load Balancing resource limits for your Amazon Web Services account.</p> <p>For more information, see the following:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-limits.html">Quotas for your Application Load Balancers</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-limits.html">Quotas for your Network Load Balancers</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/quotas-limits.html">Quotas for your Gateway Load Balancers</a> </p> </li> </ul>', 'DescribeListenerCertificates' => '<p>Describes the default certificate and the certificate list for the specified HTTPS or TLS listener.</p> <p>If the default certificate is also in the certificate list, it appears twice in the results (once with <code>IsDefault</code> set to true and once with <code>IsDefault</code> set to false).</p> <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#https-listener-certificates">SSL certificates</a> in the <i>Application Load Balancers Guide</i> or <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#tls-listener-certificate">Server certificates</a> in the <i>Network Load Balancers Guide</i>.</p>', 'DescribeListeners' => '<p>Describes the specified listeners or the listeners for the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer. You must specify either a load balancer or one or more listeners.</p>', 'DescribeLoadBalancerAttributes' => '<p>Describes the attributes for the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer.</p> <p>For more information, see the following:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/application-load-balancers.html#load-balancer-attributes">Load balancer attributes</a> in the <i>Application Load Balancers Guide</i> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html#load-balancer-attributes">Load balancer attributes</a> in the <i>Network Load Balancers Guide</i> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/gateway-load-balancers.html#load-balancer-attributes">Load balancer attributes</a> in the <i>Gateway Load Balancers Guide</i> </p> </li> </ul>', 'DescribeLoadBalancers' => '<p>Describes the specified load balancers or all of your load balancers.</p>', 'DescribeRules' => '<p>Describes the specified rules or the rules for the specified listener. You must specify either a listener or one or more rules.</p>', 'DescribeSSLPolicies' => '<p>Describes the specified policies or all policies used for SSL negotiation.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#describe-ssl-policies">Security policies</a> in the <i>Application Load Balancers Guide</i> or <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#describe-ssl-policies">Security policies</a> in the <i>Network Load Balancers Guide</i>.</p>', 'DescribeTags' => '<p>Describes the tags for the specified Elastic Load Balancing resources. You can describe the tags for one or more Application Load Balancers, Network Load Balancers, Gateway Load Balancers, target groups, listeners, or rules.</p>', 'DescribeTargetGroupAttributes' => '<p>Describes the attributes for the specified target group.</p> <p>For more information, see the following:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html#target-group-attributes">Target group attributes</a> in the <i>Application Load Balancers Guide</i> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#target-group-attributes">Target group attributes</a> in the <i>Network Load Balancers Guide</i> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/target-groups.html#target-group-attributes">Target group attributes</a> in the <i>Gateway Load Balancers Guide</i> </p> </li> </ul>', 'DescribeTargetGroups' => '<p>Describes the specified target groups or all of your target groups. By default, all target groups are described. Alternatively, you can specify one of the following to filter the results: the ARN of the load balancer, the names of one or more target groups, or the ARNs of one or more target groups.</p>', 'DescribeTargetHealth' => '<p>Describes the health of the specified targets or all of your targets.</p>', 'DescribeTrustStoreAssociations' => '<p>Describes all resources associated with the specified trust store.</p>', 'DescribeTrustStoreRevocations' => '<p>Describes the revocation files in use by the specified trust store arn, or revocation ID.</p>', 'DescribeTrustStores' => '<p>Describes all trust stores for a given account by trust store arn’s or name.</p>', 'GetTrustStoreCaCertificatesBundle' => '<p>Retrieves the ca certificate bundle.</p> <p>This action returns a pre-signed S3 URI which is active for ten minutes.</p>', 'GetTrustStoreRevocationContent' => '<p>Retrieves the specified revocation file.</p> <p>This action returns a pre-signed S3 URI which is active for ten minutes.</p>', 'ModifyListener' => '<p>Replaces the specified properties of the specified listener. Any properties that you do not specify remain unchanged.</p> <p>Changing the protocol from HTTPS to HTTP, or from TLS to TCP, removes the security policy and default certificate properties. If you change the protocol from HTTP to HTTPS, or from TCP to TLS, you must add the security policy and default certificate properties.</p> <p>To add an item to a list, remove an item from a list, or update an item in a list, you must provide the entire list. For example, to add an action, specify a list with the current actions plus the new action.</p>', 'ModifyLoadBalancerAttributes' => '<p>Modifies the specified attributes of the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer.</p> <p>If any of the specified attributes can\'t be modified as requested, the call fails. Any existing attributes that you do not modify retain their current values.</p>', 'ModifyRule' => '<p>Replaces the specified properties of the specified rule. Any properties that you do not specify are unchanged.</p> <p>To add an item to a list, remove an item from a list, or update an item in a list, you must provide the entire list. For example, to add an action, specify a list with the current actions plus the new action.</p>', 'ModifyTargetGroup' => '<p>Modifies the health checks used when evaluating the health state of the targets in the specified target group.</p>', 'ModifyTargetGroupAttributes' => '<p>Modifies the specified attributes of the specified target group.</p>', 'ModifyTrustStore' => '<p>Update the ca certificate bundle for a given trust store.</p>', 'RegisterTargets' => '<p>Registers the specified targets with the specified target group.</p> <p>If the target is an EC2 instance, it must be in the <code>running</code> state when you register it.</p> <p>By default, the load balancer routes requests to registered targets using the protocol and port for the target group. Alternatively, you can override the port for a target when you register it. You can register each EC2 instance or IP address with the same target group multiple times using different ports.</p> <p>With a Network Load Balancer, you cannot register instances by instance ID if they have the following instance types: C1, CC1, CC2, CG1, CG2, CR1, CS1, G1, G2, HI1, HS1, M1, M2, M3, and T1. You can register instances of these types by IP address.</p>', 'RemoveListenerCertificates' => '<p>Removes the specified certificate from the certificate list for the specified HTTPS or TLS listener.</p>', 'RemoveTags' => '<p>Removes the specified tags from the specified Elastic Load Balancing resources. You can remove the tags for one or more Application Load Balancers, Network Load Balancers, Gateway Load Balancers, target groups, listeners, or rules.</p>', 'RemoveTrustStoreRevocations' => '<p>Removes the specified revocation file from the specified trust store.</p>', 'SetIpAddressType' => '<p>Sets the type of IP addresses used by the subnets of the specified load balancer.</p>', 'SetRulePriorities' => '<p>Sets the priorities of the specified rules.</p> <p>You can reorder the rules as long as there are no priority conflicts in the new order. Any existing rules that you do not specify retain their current priority.</p>', 'SetSecurityGroups' => '<p>Associates the specified security groups with the specified Application Load Balancer or Network Load Balancer. The specified security groups override the previously associated security groups.</p> <p>You can\'t perform this operation on a Network Load Balancer unless you specified a security group for the load balancer when you created it.</p> <p>You can\'t associate a security group with a Gateway Load Balancer.</p>', 'SetSubnets' => '<p>Enables the Availability Zones for the specified public subnets for the specified Application Load Balancer, Network Load Balancer or Gateway Load Balancer. The specified subnets replace the previously enabled subnets.</p> <p>When you specify subnets for a Network Load Balancer, or Gateway Load Balancer you must include all subnets that were enabled previously, with their existing configurations, plus any additional subnets.</p>', ], 'shapes' => [ 'ALPNPolicyNotSupportedException' => [ 'base' => '<p>The specified ALPN policy is not supported.</p>', 'refs' => [], ], 'Action' => [ 'base' => '<p>Information about an action.</p> <p>Each rule must include exactly one of the following types of actions: <code>forward</code>, <code>fixed-response</code>, or <code>redirect</code>, and it must be the last action to be performed.</p>', 'refs' => [ 'Actions$member' => NULL, ], ], 'ActionOrder' => [ 'base' => NULL, 'refs' => [ 'Action$Order' => '<p>The order for the action. This value is required for rules with multiple actions. The action with the lowest value for order is performed first.</p>', ], ], 'ActionTypeEnum' => [ 'base' => NULL, 'refs' => [ 'Action$Type' => '<p>The type of action.</p>', ], ], 'Actions' => [ 'base' => NULL, 'refs' => [ 'CreateListenerInput$DefaultActions' => '<p>The actions for the default rule.</p>', 'CreateRuleInput$Actions' => '<p>The actions.</p>', 'Listener$DefaultActions' => '<p>The default actions for the listener.</p>', 'ModifyListenerInput$DefaultActions' => '<p>The actions for the default rule.</p>', 'ModifyRuleInput$Actions' => '<p>The actions.</p>', 'Rule$Actions' => '<p>The actions. Each rule must include exactly one of the following types of actions: <code>forward</code>, <code>redirect</code>, or <code>fixed-response</code>, and it must be the last action to be performed.</p>', ], ], 'AddListenerCertificatesInput' => [ 'base' => NULL, 'refs' => [], ], 'AddListenerCertificatesOutput' => [ 'base' => NULL, 'refs' => [], ], 'AddTagsInput' => [ 'base' => NULL, 'refs' => [], ], 'AddTagsOutput' => [ 'base' => NULL, 'refs' => [], ], 'AddTrustStoreRevocationsInput' => [ 'base' => NULL, 'refs' => [], ], 'AddTrustStoreRevocationsOutput' => [ 'base' => NULL, 'refs' => [], ], 'AllocationId' => [ 'base' => NULL, 'refs' => [ 'LoadBalancerAddress$AllocationId' => '<p>[Network Load Balancers] The allocation ID of the Elastic IP address for an internal-facing load balancer.</p>', 'SubnetMapping$AllocationId' => '<p>[Network Load Balancers] The allocation ID of the Elastic IP address for an internet-facing load balancer.</p>', ], ], 'AllocationIdNotFoundException' => [ 'base' => '<p>The specified allocation ID does not exist.</p>', 'refs' => [], ], 'AlpnPolicyName' => [ 'base' => NULL, 'refs' => [ 'CreateListenerInput$AlpnPolicy' => '<p>[TLS listeners] The name of the Application-Layer Protocol Negotiation (ALPN) policy. You can specify one policy name. The following are the possible values:</p> <ul> <li> <p> <code>HTTP1Only</code> </p> </li> <li> <p> <code>HTTP2Only</code> </p> </li> <li> <p> <code>HTTP2Optional</code> </p> </li> <li> <p> <code>HTTP2Preferred</code> </p> </li> <li> <p> <code>None</code> </p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#alpn-policies">ALPN policies</a> in the <i>Network Load Balancers Guide</i>.</p>', 'Listener$AlpnPolicy' => '<p>[TLS listener] The name of the Application-Layer Protocol Negotiation (ALPN) policy.</p>', 'ModifyListenerInput$AlpnPolicy' => '<p>[TLS listeners] The name of the Application-Layer Protocol Negotiation (ALPN) policy. You can specify one policy name. The following are the possible values:</p> <ul> <li> <p> <code>HTTP1Only</code> </p> </li> <li> <p> <code>HTTP2Only</code> </p> </li> <li> <p> <code>HTTP2Optional</code> </p> </li> <li> <p> <code>HTTP2Preferred</code> </p> </li> <li> <p> <code>None</code> </p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#alpn-policies">ALPN policies</a> in the <i>Network Load Balancers Guide</i>.</p>', ], ], 'AlpnPolicyValue' => [ 'base' => NULL, 'refs' => [ 'AlpnPolicyName$member' => NULL, ], ], 'AnomalyDetection' => [ 'base' => '<p>Information about anomaly detection and mitigation.</p>', 'refs' => [ 'TargetHealthDescription$AnomalyDetection' => '<p>The anomaly detection result for the target.</p> <p>If no anomalies were detected, the result is <code>normal</code>.</p> <p>If anomalies were detected, the result is <code>anomalous</code>.</p>', ], ], 'AnomalyResultEnum' => [ 'base' => NULL, 'refs' => [ 'AnomalyDetection$Result' => '<p>The latest anomaly detection result.</p>', ], ], 'AuthenticateCognitoActionAuthenticationRequestExtraParams' => [ 'base' => NULL, 'refs' => [ 'AuthenticateCognitoActionConfig$AuthenticationRequestExtraParams' => '<p>The query parameters (up to 10) to include in the redirect request to the authorization endpoint.</p>', ], ], 'AuthenticateCognitoActionAuthenticationRequestParamName' => [ 'base' => NULL, 'refs' => [ 'AuthenticateCognitoActionAuthenticationRequestExtraParams$key' => NULL, ], ], 'AuthenticateCognitoActionAuthenticationRequestParamValue' => [ 'base' => NULL, 'refs' => [ 'AuthenticateCognitoActionAuthenticationRequestExtraParams$value' => NULL, ], ], 'AuthenticateCognitoActionConditionalBehaviorEnum' => [ 'base' => NULL, 'refs' => [ 'AuthenticateCognitoActionConfig$OnUnauthenticatedRequest' => '<p>The behavior if the user is not authenticated. The following are possible values:</p> <ul> <li> <p>deny<code/> - Return an HTTP 401 Unauthorized error.</p> </li> <li> <p>allow<code/> - Allow the request to be forwarded to the target.</p> </li> <li> <p>authenticate<code/> - Redirect the request to the IdP authorization endpoint. This is the default value.</p> </li> </ul>', ], ], 'AuthenticateCognitoActionConfig' => [ 'base' => '<p>Request parameters to use when integrating with Amazon Cognito to authenticate users.</p>', 'refs' => [ 'Action$AuthenticateCognitoConfig' => '<p>[HTTPS listeners] Information for using Amazon Cognito to authenticate users. Specify only when <code>Type</code> is <code>authenticate-cognito</code>.</p>', ], ], 'AuthenticateCognitoActionScope' => [ 'base' => NULL, 'refs' => [ 'AuthenticateCognitoActionConfig$Scope' => '<p>The set of user claims to be requested from the IdP. The default is <code>openid</code>.</p> <p>To verify which scope values your IdP supports and how to separate multiple values, see the documentation for your IdP.</p>', ], ], 'AuthenticateCognitoActionSessionCookieName' => [ 'base' => NULL, 'refs' => [ 'AuthenticateCognitoActionConfig$SessionCookieName' => '<p>The name of the cookie used to maintain session information. The default is AWSELBAuthSessionCookie.</p>', ], ], 'AuthenticateCognitoActionSessionTimeout' => [ 'base' => NULL, 'refs' => [ 'AuthenticateCognitoActionConfig$SessionTimeout' => '<p>The maximum duration of the authentication session, in seconds. The default is 604800 seconds (7 days).</p>', ], ], 'AuthenticateCognitoActionUserPoolArn' => [ 'base' => NULL, 'refs' => [ 'AuthenticateCognitoActionConfig$UserPoolArn' => '<p>The Amazon Resource Name (ARN) of the Amazon Cognito user pool.</p>', ], ], 'AuthenticateCognitoActionUserPoolClientId' => [ 'base' => NULL, 'refs' => [ 'AuthenticateCognitoActionConfig$UserPoolClientId' => '<p>The ID of the Amazon Cognito user pool client.</p>', ], ], 'AuthenticateCognitoActionUserPoolDomain' => [ 'base' => NULL, 'refs' => [ 'AuthenticateCognitoActionConfig$UserPoolDomain' => '<p>The domain prefix or fully-qualified domain name of the Amazon Cognito user pool.</p>', ], ], 'AuthenticateOidcActionAuthenticationRequestExtraParams' => [ 'base' => NULL, 'refs' => [ 'AuthenticateOidcActionConfig$AuthenticationRequestExtraParams' => '<p>The query parameters (up to 10) to include in the redirect request to the authorization endpoint.</p>', ], ], 'AuthenticateOidcActionAuthenticationRequestParamName' => [ 'base' => NULL, 'refs' => [ 'AuthenticateOidcActionAuthenticationRequestExtraParams$key' => NULL, ], ], 'AuthenticateOidcActionAuthenticationRequestParamValue' => [ 'base' => NULL, 'refs' => [ 'AuthenticateOidcActionAuthenticationRequestExtraParams$value' => NULL, ], ], 'AuthenticateOidcActionAuthorizationEndpoint' => [ 'base' => NULL, 'refs' => [ 'AuthenticateOidcActionConfig$AuthorizationEndpoint' => '<p>The authorization endpoint of the IdP. This must be a full URL, including the HTTPS protocol, the domain, and the path.</p>', ], ], 'AuthenticateOidcActionClientId' => [ 'base' => NULL, 'refs' => [ 'AuthenticateOidcActionConfig$ClientId' => '<p>The OAuth 2.0 client identifier.</p>', ], ], 'AuthenticateOidcActionClientSecret' => [ 'base' => NULL, 'refs' => [ 'AuthenticateOidcActionConfig$ClientSecret' => '<p>The OAuth 2.0 client secret. This parameter is required if you are creating a rule. If you are modifying a rule, you can omit this parameter if you set <code>UseExistingClientSecret</code> to true.</p>', ], ], 'AuthenticateOidcActionConditionalBehaviorEnum' => [ 'base' => NULL, 'refs' => [ 'AuthenticateOidcActionConfig$OnUnauthenticatedRequest' => '<p>The behavior if the user is not authenticated. The following are possible values:</p> <ul> <li> <p>deny<code/> - Return an HTTP 401 Unauthorized error.</p> </li> <li> <p>allow<code/> - Allow the request to be forwarded to the target.</p> </li> <li> <p>authenticate<code/> - Redirect the request to the IdP authorization endpoint. This is the default value.</p> </li> </ul>', ], ], 'AuthenticateOidcActionConfig' => [ 'base' => '<p>Request parameters when using an identity provider (IdP) that is compliant with OpenID Connect (OIDC) to authenticate users.</p>', 'refs' => [ 'Action$AuthenticateOidcConfig' => '<p>[HTTPS listeners] Information about an identity provider that is compliant with OpenID Connect (OIDC). Specify only when <code>Type</code> is <code>authenticate-oidc</code>.</p>', ], ], 'AuthenticateOidcActionIssuer' => [ 'base' => NULL, 'refs' => [ 'AuthenticateOidcActionConfig$Issuer' => '<p>The OIDC issuer identifier of the IdP. This must be a full URL, including the HTTPS protocol, the domain, and the path.</p>', ], ], 'AuthenticateOidcActionScope' => [ 'base' => NULL, 'refs' => [ 'AuthenticateOidcActionConfig$Scope' => '<p>The set of user claims to be requested from the IdP. The default is <code>openid</code>.</p> <p>To verify which scope values your IdP supports and how to separate multiple values, see the documentation for your IdP.</p>', ], ], 'AuthenticateOidcActionSessionCookieName' => [ 'base' => NULL, 'refs' => [ 'AuthenticateOidcActionConfig$SessionCookieName' => '<p>The name of the cookie used to maintain session information. The default is AWSELBAuthSessionCookie.</p>', ], ], 'AuthenticateOidcActionSessionTimeout' => [ 'base' => NULL, 'refs' => [ 'AuthenticateOidcActionConfig$SessionTimeout' => '<p>The maximum duration of the authentication session, in seconds. The default is 604800 seconds (7 days).</p>', ], ], 'AuthenticateOidcActionTokenEndpoint' => [ 'base' => NULL, 'refs' => [ 'AuthenticateOidcActionConfig$TokenEndpoint' => '<p>The token endpoint of the IdP. This must be a full URL, including the HTTPS protocol, the domain, and the path.</p>', ], ], 'AuthenticateOidcActionUseExistingClientSecret' => [ 'base' => NULL, 'refs' => [ 'AuthenticateOidcActionConfig$UseExistingClientSecret' => '<p>Indicates whether to use the existing client secret when modifying a rule. If you are creating a rule, you can omit this parameter or set it to false.</p>', ], ], 'AuthenticateOidcActionUserInfoEndpoint' => [ 'base' => NULL, 'refs' => [ 'AuthenticateOidcActionConfig$UserInfoEndpoint' => '<p>The user info endpoint of the IdP. This must be a full URL, including the HTTPS protocol, the domain, and the path.</p>', ], ], 'AvailabilityZone' => [ 'base' => '<p>Information about an Availability Zone.</p>', 'refs' => [ 'AvailabilityZones$member' => NULL, ], ], 'AvailabilityZoneNotSupportedException' => [ 'base' => '<p>The specified Availability Zone is not supported.</p>', 'refs' => [], ], 'AvailabilityZones' => [ 'base' => NULL, 'refs' => [ 'LoadBalancer$AvailabilityZones' => '<p>The subnets for the load balancer.</p>', 'SetSubnetsOutput$AvailabilityZones' => '<p>Information about the subnets.</p>', ], ], 'CaCertificatesBundleNotFoundException' => [ 'base' => '<p>The specified ca certificate bundle does not exist.</p>', 'refs' => [], ], 'CanonicalHostedZoneId' => [ 'base' => NULL, 'refs' => [ 'LoadBalancer$CanonicalHostedZoneId' => '<p>The ID of the Amazon Route 53 hosted zone associated with the load balancer.</p>', ], ], 'Certificate' => [ 'base' => '<p>Information about an SSL server certificate.</p>', 'refs' => [ 'CertificateList$member' => NULL, ], ], 'CertificateArn' => [ 'base' => NULL, 'refs' => [ 'Certificate$CertificateArn' => '<p>The Amazon Resource Name (ARN) of the certificate.</p>', ], ], 'CertificateList' => [ 'base' => NULL, 'refs' => [ 'AddListenerCertificatesInput$Certificates' => '<p>The certificate to add. You can specify one certificate per call. Set <code>CertificateArn</code> to the certificate ARN but do not set <code>IsDefault</code>.</p>', 'AddListenerCertificatesOutput$Certificates' => '<p>Information about the certificates in the certificate list.</p>', 'CreateListenerInput$Certificates' => '<p>[HTTPS and TLS listeners] The default certificate for the listener. You must provide exactly one certificate. Set <code>CertificateArn</code> to the certificate ARN but do not set <code>IsDefault</code>.</p>', 'DescribeListenerCertificatesOutput$Certificates' => '<p>Information about the certificates.</p>', 'Listener$Certificates' => '<p>[HTTPS or TLS listener] The default certificate for the listener.</p>', 'ModifyListenerInput$Certificates' => '<p>[HTTPS and TLS listeners] The default certificate for the listener. You must provide exactly one certificate. Set <code>CertificateArn</code> to the certificate ARN but do not set <code>IsDefault</code>.</p>', 'RemoveListenerCertificatesInput$Certificates' => '<p>The certificate to remove. You can specify one certificate per call. Set <code>CertificateArn</code> to the certificate ARN but do not set <code>IsDefault</code>.</p>', ], ], 'CertificateNotFoundException' => [ 'base' => '<p>The specified certificate does not exist.</p>', 'refs' => [], ], 'Cipher' => [ 'base' => '<p>Information about a cipher used in a policy.</p>', 'refs' => [ 'Ciphers$member' => NULL, ], ], 'CipherName' => [ 'base' => NULL, 'refs' => [ 'Cipher$Name' => '<p>The name of the cipher.</p>', ], ], 'CipherPriority' => [ 'base' => NULL, 'refs' => [ 'Cipher$Priority' => '<p>The priority of the cipher.</p>', ], ], 'Ciphers' => [ 'base' => NULL, 'refs' => [ 'SslPolicy$Ciphers' => '<p>The ciphers.</p>', ], ], 'ConditionFieldName' => [ 'base' => NULL, 'refs' => [ 'RuleCondition$Field' => '<p>The field in the HTTP request. The following are the possible values:</p> <ul> <li> <p> <code>http-header</code> </p> </li> <li> <p> <code>http-request-method</code> </p> </li> <li> <p> <code>host-header</code> </p> </li> <li> <p> <code>path-pattern</code> </p> </li> <li> <p> <code>query-string</code> </p> </li> <li> <p> <code>source-ip</code> </p> </li> </ul>', ], ], 'CreateListenerInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateListenerOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateLoadBalancerInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateLoadBalancerOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateRuleInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateRuleOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateTargetGroupInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateTargetGroupOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateTrustStoreInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateTrustStoreOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreatedTime' => [ 'base' => NULL, 'refs' => [ 'LoadBalancer$CreatedTime' => '<p>The date and time the load balancer was created.</p>', ], ], 'CustomerOwnedIpv4Pool' => [ 'base' => NULL, 'refs' => [ 'CreateLoadBalancerInput$CustomerOwnedIpv4Pool' => '<p>[Application Load Balancers on Outposts] The ID of the customer-owned address pool (CoIP pool).</p>', 'LoadBalancer$CustomerOwnedIpv4Pool' => '<p>[Application Load Balancers on Outposts] The ID of the customer-owned address pool.</p>', ], ], 'DNSName' => [ 'base' => NULL, 'refs' => [ 'LoadBalancer$DNSName' => '<p>The public DNS name of the load balancer.</p>', ], ], 'Default' => [ 'base' => NULL, 'refs' => [ 'Certificate$IsDefault' => '<p>Indicates whether the certificate is the default certificate. Do not set this value when specifying a certificate as an input. This value is not included in the output when describing a listener, but is included when describing listener certificates.</p>', ], ], 'DeleteListenerInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteListenerOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLoadBalancerInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLoadBalancerOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRuleInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRuleOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTargetGroupInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTargetGroupOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTrustStoreInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTrustStoreOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterTargetsInput' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterTargetsOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccountLimitsInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccountLimitsOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeListenerCertificatesInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeListenerCertificatesOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeListenersInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeListenersOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLoadBalancerAttributesInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLoadBalancerAttributesOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLoadBalancersInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLoadBalancersOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRulesInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRulesOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSSLPoliciesInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSSLPoliciesOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTagsInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTagsOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTargetGroupAttributesInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTargetGroupAttributesOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTargetGroupsInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTargetGroupsOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTargetHealthInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTargetHealthInputIncludeEnum' => [ 'base' => NULL, 'refs' => [ 'ListOfDescribeTargetHealthIncludeOptions$member' => NULL, ], ], 'DescribeTargetHealthOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTrustStoreAssociationsInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTrustStoreAssociationsOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTrustStoreRevocation' => [ 'base' => '<p>Information about the revocations used by a trust store.</p>', 'refs' => [ 'DescribeTrustStoreRevocationResponse$member' => NULL, ], ], 'DescribeTrustStoreRevocationResponse' => [ 'base' => NULL, 'refs' => [ 'DescribeTrustStoreRevocationsOutput$TrustStoreRevocations' => '<p>Information about the revocation file in the trust store.</p>', ], ], 'DescribeTrustStoreRevocationsInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTrustStoreRevocationsOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTrustStoresInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTrustStoresOutput' => [ 'base' => NULL, 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'TargetHealth$Description' => '<p>A description of the target health that provides additional details. If the state is <code>healthy</code>, a description is not provided.</p>', ], ], 'DuplicateListenerException' => [ 'base' => '<p>A listener with the specified port already exists.</p>', 'refs' => [], ], 'DuplicateLoadBalancerNameException' => [ 'base' => '<p>A load balancer with the specified name already exists.</p>', 'refs' => [], ], 'DuplicateTagKeysException' => [ 'base' => '<p>A tag key was specified more than once.</p>', 'refs' => [], ], 'DuplicateTargetGroupNameException' => [ 'base' => '<p>A target group with the specified name already exists.</p>', 'refs' => [], ], 'DuplicateTrustStoreNameException' => [ 'base' => '<p>A trust store with the specified name already exists.</p>', 'refs' => [], ], 'EnforceSecurityGroupInboundRulesOnPrivateLinkTraffic' => [ 'base' => NULL, 'refs' => [ 'LoadBalancer$EnforceSecurityGroupInboundRulesOnPrivateLinkTraffic' => '<p>Indicates whether to evaluate inbound security group rules for traffic sent to a Network Load Balancer through Amazon Web Services PrivateLink.</p>', ], ], 'EnforceSecurityGroupInboundRulesOnPrivateLinkTrafficEnum' => [ 'base' => NULL, 'refs' => [ 'SetSecurityGroupsInput$EnforceSecurityGroupInboundRulesOnPrivateLinkTraffic' => '<p>Indicates whether to evaluate inbound security group rules for traffic sent to a Network Load Balancer through Amazon Web Services PrivateLink. The default is <code>on</code>.</p>', 'SetSecurityGroupsOutput$EnforceSecurityGroupInboundRulesOnPrivateLinkTraffic' => '<p>Indicates whether to evaluate inbound security group rules for traffic sent to a Network Load Balancer through Amazon Web Services PrivateLink.</p>', ], ], 'FixedResponseActionConfig' => [ 'base' => '<p>Information about an action that returns a custom HTTP response.</p>', 'refs' => [ 'Action$FixedResponseConfig' => '<p>[Application Load Balancer] Information for creating an action that returns a custom HTTP response. Specify only when <code>Type</code> is <code>fixed-response</code>.</p>', ], ], 'FixedResponseActionContentType' => [ 'base' => NULL, 'refs' => [ 'FixedResponseActionConfig$ContentType' => '<p>The content type.</p> <p>Valid Values: text/plain | text/css | text/html | application/javascript | application/json</p>', ], ], 'FixedResponseActionMessage' => [ 'base' => NULL, 'refs' => [ 'FixedResponseActionConfig$MessageBody' => '<p>The message.</p>', ], ], 'FixedResponseActionStatusCode' => [ 'base' => NULL, 'refs' => [ 'FixedResponseActionConfig$StatusCode' => '<p>The HTTP response code (2XX, 4XX, or 5XX).</p>', ], ], 'ForwardActionConfig' => [ 'base' => '<p>Information about a forward action.</p>', 'refs' => [ 'Action$ForwardConfig' => '<p>Information for creating an action that distributes requests among one or more target groups. For Network Load Balancers, you can specify a single target group. Specify only when <code>Type</code> is <code>forward</code>. If you specify both <code>ForwardConfig</code> and <code>TargetGroupArn</code>, you can specify only one target group using <code>ForwardConfig</code> and it must be the same target group specified in <code>TargetGroupArn</code>.</p>', ], ], 'GetTrustStoreCaCertificatesBundleInput' => [ 'base' => NULL, 'refs' => [], ], 'GetTrustStoreCaCertificatesBundleOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetTrustStoreRevocationContentInput' => [ 'base' => NULL, 'refs' => [], ], 'GetTrustStoreRevocationContentOutput' => [ 'base' => NULL, 'refs' => [], ], 'GrpcCode' => [ 'base' => NULL, 'refs' => [ 'Matcher$GrpcCode' => '<p>You can specify values between 0 and 99. You can specify multiple values (for example, "0,1") or a range of values (for example, "0-5"). The default value is 12.</p>', ], ], 'HealthCheckEnabled' => [ 'base' => NULL, 'refs' => [ 'CreateTargetGroupInput$HealthCheckEnabled' => '<p>Indicates whether health checks are enabled. If the target type is <code>lambda</code>, health checks are disabled by default but can be enabled. If the target type is <code>instance</code>, <code>ip</code>, or <code>alb</code>, health checks are always enabled and cannot be disabled.</p>', 'ModifyTargetGroupInput$HealthCheckEnabled' => '<p>Indicates whether health checks are enabled.</p>', 'TargetGroup$HealthCheckEnabled' => '<p>Indicates whether health checks are enabled.</p>', ], ], 'HealthCheckIntervalSeconds' => [ 'base' => NULL, 'refs' => [ 'CreateTargetGroupInput$HealthCheckIntervalSeconds' => '<p>The approximate amount of time, in seconds, between health checks of an individual target. The range is 5-300. If the target group protocol is TCP, TLS, UDP, TCP_UDP, HTTP or HTTPS, the default is 30 seconds. If the target group protocol is GENEVE, the default is 10 seconds. If the target type is <code>lambda</code>, the default is 35 seconds.</p>', 'ModifyTargetGroupInput$HealthCheckIntervalSeconds' => '<p>The approximate amount of time, in seconds, between health checks of an individual target.</p>', 'TargetGroup$HealthCheckIntervalSeconds' => '<p>The approximate amount of time, in seconds, between health checks of an individual target.</p>', ], ], 'HealthCheckPort' => [ 'base' => NULL, 'refs' => [ 'CreateTargetGroupInput$HealthCheckPort' => '<p>The port the load balancer uses when performing health checks on targets. If the protocol is HTTP, HTTPS, TCP, TLS, UDP, or TCP_UDP, the default is <code>traffic-port</code>, which is the port on which each target receives traffic from the load balancer. If the protocol is GENEVE, the default is port 80.</p>', 'ModifyTargetGroupInput$HealthCheckPort' => '<p>The port the load balancer uses when performing health checks on targets.</p>', 'TargetGroup$HealthCheckPort' => '<p>The port to use to connect with the target.</p>', 'TargetHealthDescription$HealthCheckPort' => '<p>The port to use to connect with the target.</p>', ], ], 'HealthCheckThresholdCount' => [ 'base' => NULL, 'refs' => [ 'CreateTargetGroupInput$HealthyThresholdCount' => '<p>The number of consecutive health check successes required before considering a target healthy. The range is 2-10. If the target group protocol is TCP, TCP_UDP, UDP, TLS, HTTP or HTTPS, the default is 5. For target groups with a protocol of GENEVE, the default is 5. If the target type is <code>lambda</code>, the default is 5.</p>', 'CreateTargetGroupInput$UnhealthyThresholdCount' => '<p>The number of consecutive health check failures required before considering a target unhealthy. The range is 2-10. If the target group protocol is TCP, TCP_UDP, UDP, TLS, HTTP or HTTPS, the default is 2. For target groups with a protocol of GENEVE, the default is 2. If the target type is <code>lambda</code>, the default is 5.</p>', 'ModifyTargetGroupInput$HealthyThresholdCount' => '<p>The number of consecutive health checks successes required before considering an unhealthy target healthy.</p>', 'ModifyTargetGroupInput$UnhealthyThresholdCount' => '<p>The number of consecutive health check failures required before considering the target unhealthy.</p>', 'TargetGroup$HealthyThresholdCount' => '<p>The number of consecutive health checks successes required before considering an unhealthy target healthy.</p>', 'TargetGroup$UnhealthyThresholdCount' => '<p>The number of consecutive health check failures required before considering the target unhealthy.</p>', ], ], 'HealthCheckTimeoutSeconds' => [ 'base' => NULL, 'refs' => [ 'CreateTargetGroupInput$HealthCheckTimeoutSeconds' => '<p>The amount of time, in seconds, during which no response from a target means a failed health check. The range is 2–120 seconds. For target groups with a protocol of HTTP, the default is 6 seconds. For target groups with a protocol of TCP, TLS or HTTPS, the default is 10 seconds. For target groups with a protocol of GENEVE, the default is 5 seconds. If the target type is <code>lambda</code>, the default is 30 seconds.</p>', 'ModifyTargetGroupInput$HealthCheckTimeoutSeconds' => '<p>[HTTP/HTTPS health checks] The amount of time, in seconds, during which no response means a failed health check.</p>', 'TargetGroup$HealthCheckTimeoutSeconds' => '<p>The amount of time, in seconds, during which no response means a failed health check.</p>', ], ], 'HealthUnavailableException' => [ 'base' => '<p>The health of the specified targets could not be retrieved due to an internal error.</p>', 'refs' => [], ], 'HostHeaderConditionConfig' => [ 'base' => '<p>Information about a host header condition.</p>', 'refs' => [ 'RuleCondition$HostHeaderConfig' => '<p>Information for a host header condition. Specify only when <code>Field</code> is <code>host-header</code>.</p>', ], ], 'HttpCode' => [ 'base' => NULL, 'refs' => [ 'Matcher$HttpCode' => '<p>For Application Load Balancers, you can specify values between 200 and 499, with the default value being 200. You can specify multiple values (for example, "200,202") or a range of values (for example, "200-299").</p> <p>For Network Load Balancers, you can specify values between 200 and 599, with the default value being 200-399. You can specify multiple values (for example, "200,202") or a range of values (for example, "200-299").</p> <p>For Gateway Load Balancers, this must be "200–399".</p> <p>Note that when using shorthand syntax, some values such as commas need to be escaped.</p>', ], ], 'HttpHeaderConditionConfig' => [ 'base' => '<p>Information about an HTTP header condition.</p> <p>There is a set of standard HTTP header fields. You can also define custom HTTP header fields.</p>', 'refs' => [ 'RuleCondition$HttpHeaderConfig' => '<p>Information for an HTTP header condition. Specify only when <code>Field</code> is <code>http-header</code>.</p>', ], ], 'HttpHeaderConditionName' => [ 'base' => NULL, 'refs' => [ 'HttpHeaderConditionConfig$HttpHeaderName' => '<p>The name of the HTTP header field. The maximum size is 40 characters. The header name is case insensitive. The allowed characters are specified by RFC 7230. Wildcards are not supported.</p> <p>You can\'t use an HTTP header condition to specify the host header. Use <a>HostHeaderConditionConfig</a> to specify a host header condition.</p>', ], ], 'HttpRequestMethodConditionConfig' => [ 'base' => '<p>Information about an HTTP method condition.</p> <p>HTTP defines a set of request methods, also referred to as HTTP verbs. For more information, see the <a href="https://www.iana.org/assignments/http-methods/http-methods.xhtml">HTTP Method Registry</a>. You can also define custom HTTP methods.</p>', 'refs' => [ 'RuleCondition$HttpRequestMethodConfig' => '<p>Information for an HTTP method condition. Specify only when <code>Field</code> is <code>http-request-method</code>.</p>', ], ], 'IPv6Address' => [ 'base' => NULL, 'refs' => [ 'LoadBalancerAddress$IPv6Address' => '<p>[Network Load Balancers] The IPv6 address.</p>', 'SubnetMapping$IPv6Address' => '<p>[Network Load Balancers] The IPv6 address.</p>', ], ], 'IgnoreClientCertificateExpiry' => [ 'base' => NULL, 'refs' => [ 'MutualAuthenticationAttributes$IgnoreClientCertificateExpiry' => '<p>Indicates whether expired client certificates are ignored.</p>', ], ], 'IncompatibleProtocolsException' => [ 'base' => '<p>The specified configuration is not valid with this protocol.</p>', 'refs' => [], ], 'InvalidCaCertificatesBundleException' => [ 'base' => '<p>The specified ca certificate bundle is in an invalid format, or corrupt.</p>', 'refs' => [], ], 'InvalidConfigurationRequestException' => [ 'base' => '<p>The requested configuration is not valid.</p>', 'refs' => [], ], 'InvalidLoadBalancerActionException' => [ 'base' => '<p>The requested action is not valid.</p>', 'refs' => [], ], 'InvalidRevocationContentException' => [ 'base' => '<p>The provided revocation file is an invalid format, or uses an incorrect algorithm.</p>', 'refs' => [], ], 'InvalidSchemeException' => [ 'base' => '<p>The requested scheme is not valid.</p>', 'refs' => [], ], 'InvalidSecurityGroupException' => [ 'base' => '<p>The specified security group does not exist.</p>', 'refs' => [], ], 'InvalidSubnetException' => [ 'base' => '<p>The specified subnet is out of available addresses.</p>', 'refs' => [], ], 'InvalidTargetException' => [ 'base' => '<p>The specified target does not exist, is not in the same VPC as the target group, or has an unsupported instance type.</p>', 'refs' => [], ], 'IpAddress' => [ 'base' => NULL, 'refs' => [ 'LoadBalancerAddress$IpAddress' => '<p>The static IP address.</p>', ], ], 'IpAddressType' => [ 'base' => NULL, 'refs' => [ 'CreateLoadBalancerInput$IpAddressType' => '<p>Note: Internal load balancers must use the <code>ipv4</code> IP address type.</p> <p>[Application Load Balancers] The IP address type. The possible values are <code>ipv4</code> (for only IPv4 addresses), <code>dualstack</code> (for IPv4 and IPv6 addresses), and <code>dualstack-without-public-ipv4</code> (for IPv6 only public addresses, with private IPv4 and IPv6 addresses).</p> <p>[Network Load Balancers] The IP address type. The possible values are <code>ipv4</code> (for only IPv4 addresses) and <code>dualstack</code> (for IPv4 and IPv6 addresses). You can’t specify <code>dualstack</code> for a load balancer with a UDP or TCP_UDP listener.</p> <p>[Gateway Load Balancers] The IP address type. The possible values are <code>ipv4</code> (for only IPv4 addresses) and <code>dualstack</code> (for IPv4 and IPv6 addresses).</p>', 'LoadBalancer$IpAddressType' => '<p>[Application Load Balancers] The type of IP addresses used for public or private connections by the subnets attached to your load balancer. The possible values are <code>ipv4</code> (for only IPv4 addresses), <code>dualstack</code> (for IPv4 and IPv6 addresses), and <code>dualstack-without-public-ipv4</code> (for IPv6 only public addresses, with private IPv4 and IPv6 addresses).</p> <p>[Network Load Balancers and Gateway Load Balancers] The type of IP addresses used for public or private connections by the subnets attached to your load balancer. The possible values are <code>ipv4</code> (for only IPv4 addresses) and <code>dualstack</code> (for IPv4 and IPv6 addresses).</p>', 'SetIpAddressTypeInput$IpAddressType' => '<p>Note: Internal load balancers must use the <code>ipv4</code> IP address type.</p> <p>[Application Load Balancers] The IP address type. The possible values are <code>ipv4</code> (for only IPv4 addresses), <code>dualstack</code> (for IPv4 and IPv6 addresses), and <code>dualstack-without-public-ipv4</code> (for IPv6 only public addresses, with private IPv4 and IPv6 addresses).</p> <p>[Network Load Balancers] The IP address type. The possible values are <code>ipv4</code> (for only IPv4 addresses) and <code>dualstack</code> (for IPv4 and IPv6 addresses). You can’t specify <code>dualstack</code> for a load balancer with a UDP or TCP_UDP listener.</p> <p>[Gateway Load Balancers] The IP address type. The possible values are <code>ipv4</code> (for only IPv4 addresses) and <code>dualstack</code> (for IPv4 and IPv6 addresses).</p>', 'SetIpAddressTypeOutput$IpAddressType' => '<p>The IP address type.</p>', 'SetSubnetsInput$IpAddressType' => '<p>[Application Load Balancers] The IP address type. The possible values are <code>ipv4</code> (for only IPv4 addresses), <code>dualstack</code> (for IPv4 and IPv6 addresses), and <code>dualstack-without-public-ipv4</code> (for IPv6 only public addresses, with private IPv4 and IPv6 addresses).</p> <p>[Network Load Balancers] The type of IP addresses used by the subnets for your load balancer. The possible values are <code>ipv4</code> (for IPv4 addresses) and <code>dualstack</code> (for IPv4 and IPv6 addresses). You can’t specify <code>dualstack</code> for a load balancer with a UDP or TCP_UDP listener.</p> <p>[Gateway Load Balancers] The type of IP addresses used by the subnets for your load balancer. The possible values are <code>ipv4</code> (for IPv4 addresses) and <code>dualstack</code> (for IPv4 and IPv6 addresses).</p>', 'SetSubnetsOutput$IpAddressType' => '<p>[Application Load Balancers] The IP address type.</p> <p>[Network Load Balancers] The IP address type.</p> <p>[Gateway Load Balancers] The IP address type.</p>', ], ], 'IsDefault' => [ 'base' => NULL, 'refs' => [ 'Rule$IsDefault' => '<p>Indicates whether this is the default rule.</p>', ], ], 'Limit' => [ 'base' => '<p>Information about an Elastic Load Balancing resource limit for your Amazon Web Services account.</p> <p>For more information, see the following:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-limits.html">Quotas for your Application Load Balancers</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-limits.html">Quotas for your Network Load Balancers</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/quotas-limits.html">Quotas for your Gateway Load Balancers</a> </p> </li> </ul>', 'refs' => [ 'Limits$member' => NULL, ], ], 'Limits' => [ 'base' => NULL, 'refs' => [ 'DescribeAccountLimitsOutput$Limits' => '<p>Information about the limits.</p>', ], ], 'ListOfDescribeTargetHealthIncludeOptions' => [ 'base' => NULL, 'refs' => [ 'DescribeTargetHealthInput$Include' => '<p>Used to inclue anomaly detection information.</p>', ], ], 'ListOfString' => [ 'base' => NULL, 'refs' => [ 'HostHeaderConditionConfig$Values' => '<p>The host names. The maximum size of each name is 128 characters. The comparison is case insensitive. The following wildcard characters are supported: * (matches 0 or more characters) and ? (matches exactly 1 character).</p> <p>If you specify multiple strings, the condition is satisfied if one of the strings matches the host name.</p>', 'HttpHeaderConditionConfig$Values' => '<p>The strings to compare against the value of the HTTP header. The maximum size of each string is 128 characters. The comparison strings are case insensitive. The following wildcard characters are supported: * (matches 0 or more characters) and ? (matches exactly 1 character).</p> <p>If the same header appears multiple times in the request, we search them in order until a match is found.</p> <p>If you specify multiple strings, the condition is satisfied if one of the strings matches the value of the HTTP header. To require that all of the strings are a match, create one condition per string.</p>', 'HttpRequestMethodConditionConfig$Values' => '<p>The name of the request method. The maximum size is 40 characters. The allowed characters are A-Z, hyphen (-), and underscore (_). The comparison is case sensitive. Wildcards are not supported; therefore, the method name must be an exact match.</p> <p>If you specify multiple strings, the condition is satisfied if one of the strings matches the HTTP request method. We recommend that you route GET and HEAD requests in the same way, because the response to a HEAD request may be cached.</p>', 'PathPatternConditionConfig$Values' => '<p>The path patterns to compare against the request URL. The maximum size of each string is 128 characters. The comparison is case sensitive. The following wildcard characters are supported: * (matches 0 or more characters) and ? (matches exactly 1 character).</p> <p>If you specify multiple strings, the condition is satisfied if one of them matches the request URL. The path pattern is compared only to the path of the URL, not to its query string. To compare against the query string, use <a>QueryStringConditionConfig</a>.</p>', 'RuleCondition$Values' => '<p>The condition value. Specify only when <code>Field</code> is <code>host-header</code> or <code>path-pattern</code>. Alternatively, to specify multiple host names or multiple path patterns, use <code>HostHeaderConfig</code> or <code>PathPatternConfig</code>.</p> <p>If <code>Field</code> is <code>host-header</code> and you are not using <code>HostHeaderConfig</code>, you can specify a single host name (for example, my.example.com) in <code>Values</code>. A host name is case insensitive, can be up to 128 characters in length, and can contain any of the following characters.</p> <ul> <li> <p>A-Z, a-z, 0-9</p> </li> <li> <p>- .</p> </li> <li> <p>* (matches 0 or more characters)</p> </li> <li> <p>? (matches exactly 1 character)</p> </li> </ul> <p>If <code>Field</code> is <code>path-pattern</code> and you are not using <code>PathPatternConfig</code>, you can specify a single path pattern (for example, /img/*) in <code>Values</code>. A path pattern is case-sensitive, can be up to 128 characters in length, and can contain any of the following characters.</p> <ul> <li> <p>A-Z, a-z, 0-9</p> </li> <li> <p>_ - . $ / ~ " \' @ : +</p> </li> <li> <p>&amp; (using &amp;amp;)</p> </li> <li> <p>* (matches 0 or more characters)</p> </li> <li> <p>? (matches exactly 1 character)</p> </li> </ul>', 'SourceIpConditionConfig$Values' => '<p>The source IP addresses, in CIDR format. You can use both IPv4 and IPv6 addresses. Wildcards are not supported.</p> <p>If you specify multiple addresses, the condition is satisfied if the source IP address of the request matches one of the CIDR blocks. This condition is not satisfied by the addresses in the X-Forwarded-For header. To search for addresses in the X-Forwarded-For header, use <a>HttpHeaderConditionConfig</a>.</p> <p>The total number of values must be less than, or equal to five.</p>', 'SslPolicy$SupportedLoadBalancerTypes' => '<p> The supported load balancers. </p>', ], ], 'Listener' => [ 'base' => '<p>Information about a listener.</p>', 'refs' => [ 'Listeners$member' => NULL, ], ], 'ListenerArn' => [ 'base' => NULL, 'refs' => [ 'AddListenerCertificatesInput$ListenerArn' => '<p>The Amazon Resource Name (ARN) of the listener.</p>', 'CreateRuleInput$ListenerArn' => '<p>The Amazon Resource Name (ARN) of the listener.</p>', 'DeleteListenerInput$ListenerArn' => '<p>The Amazon Resource Name (ARN) of the listener.</p>', 'DescribeListenerCertificatesInput$ListenerArn' => '<p>The Amazon Resource Names (ARN) of the listener.</p>', 'DescribeRulesInput$ListenerArn' => '<p>The Amazon Resource Name (ARN) of the listener.</p>', 'Listener$ListenerArn' => '<p>The Amazon Resource Name (ARN) of the listener.</p>', 'ListenerArns$member' => NULL, 'ModifyListenerInput$ListenerArn' => '<p>The Amazon Resource Name (ARN) of the listener.</p>', 'RemoveListenerCertificatesInput$ListenerArn' => '<p>The Amazon Resource Name (ARN) of the listener.</p>', ], ], 'ListenerArns' => [ 'base' => NULL, 'refs' => [ 'DescribeListenersInput$ListenerArns' => '<p>The Amazon Resource Names (ARN) of the listeners.</p>', ], ], 'ListenerNotFoundException' => [ 'base' => '<p>The specified listener does not exist.</p>', 'refs' => [], ], 'Listeners' => [ 'base' => NULL, 'refs' => [ 'CreateListenerOutput$Listeners' => '<p>Information about the listener.</p>', 'DescribeListenersOutput$Listeners' => '<p>Information about the listeners.</p>', 'ModifyListenerOutput$Listeners' => '<p>Information about the modified listener.</p>', ], ], 'LoadBalancer' => [ 'base' => '<p>Information about a load balancer.</p>', 'refs' => [ 'LoadBalancers$member' => NULL, ], ], 'LoadBalancerAddress' => [ 'base' => '<p>Information about a static IP address for a load balancer.</p>', 'refs' => [ 'LoadBalancerAddresses$member' => NULL, ], ], 'LoadBalancerAddresses' => [ 'base' => NULL, 'refs' => [ 'AvailabilityZone$LoadBalancerAddresses' => '<p>[Network Load Balancers] If you need static IP addresses for your load balancer, you can specify one Elastic IP address per Availability Zone when you create an internal-facing load balancer. For internal load balancers, you can specify a private IP address from the IPv4 range of the subnet.</p>', ], ], 'LoadBalancerArn' => [ 'base' => NULL, 'refs' => [ 'CreateListenerInput$LoadBalancerArn' => '<p>The Amazon Resource Name (ARN) of the load balancer.</p>', 'DeleteLoadBalancerInput$LoadBalancerArn' => '<p>The Amazon Resource Name (ARN) of the load balancer.</p>', 'DescribeListenersInput$LoadBalancerArn' => '<p>The Amazon Resource Name (ARN) of the load balancer.</p>', 'DescribeLoadBalancerAttributesInput$LoadBalancerArn' => '<p>The Amazon Resource Name (ARN) of the load balancer.</p>', 'DescribeTargetGroupsInput$LoadBalancerArn' => '<p>The Amazon Resource Name (ARN) of the load balancer.</p>', 'Listener$LoadBalancerArn' => '<p>The Amazon Resource Name (ARN) of the load balancer.</p>', 'LoadBalancer$LoadBalancerArn' => '<p>The Amazon Resource Name (ARN) of the load balancer.</p>', 'LoadBalancerArns$member' => NULL, 'ModifyLoadBalancerAttributesInput$LoadBalancerArn' => '<p>The Amazon Resource Name (ARN) of the load balancer.</p>', 'SetIpAddressTypeInput$LoadBalancerArn' => '<p>The Amazon Resource Name (ARN) of the load balancer.</p>', 'SetSecurityGroupsInput$LoadBalancerArn' => '<p>The Amazon Resource Name (ARN) of the load balancer.</p>', 'SetSubnetsInput$LoadBalancerArn' => '<p>The Amazon Resource Name (ARN) of the load balancer.</p>', ], ], 'LoadBalancerArns' => [ 'base' => NULL, 'refs' => [ 'DescribeLoadBalancersInput$LoadBalancerArns' => '<p>The Amazon Resource Names (ARN) of the load balancers. You can specify up to 20 load balancers in a single call.</p>', 'TargetGroup$LoadBalancerArns' => '<p>The Amazon Resource Name (ARN) of the load balancer that routes traffic to this target group. You can use each target group with only one load balancer.</p>', ], ], 'LoadBalancerAttribute' => [ 'base' => '<p>Information about a load balancer attribute.</p>', 'refs' => [ 'LoadBalancerAttributes$member' => NULL, ], ], 'LoadBalancerAttributeKey' => [ 'base' => NULL, 'refs' => [ 'LoadBalancerAttribute$Key' => '<p>The name of the attribute.</p> <p>The following attributes are supported by all load balancers:</p> <ul> <li> <p> <code>deletion_protection.enabled</code> - Indicates whether deletion protection is enabled. The value is <code>true</code> or <code>false</code>. The default is <code>false</code>.</p> </li> <li> <p> <code>load_balancing.cross_zone.enabled</code> - Indicates whether cross-zone load balancing is enabled. The possible values are <code>true</code> and <code>false</code>. The default for Network Load Balancers and Gateway Load Balancers is <code>false</code>. The default for Application Load Balancers is <code>true</code>, and cannot be changed.</p> </li> </ul> <p>The following attributes are supported by both Application Load Balancers and Network Load Balancers:</p> <ul> <li> <p> <code>access_logs.s3.enabled</code> - Indicates whether access logs are enabled. The value is <code>true</code> or <code>false</code>. The default is <code>false</code>.</p> </li> <li> <p> <code>access_logs.s3.bucket</code> - The name of the S3 bucket for the access logs. This attribute is required if access logs are enabled. The bucket must exist in the same region as the load balancer and have a bucket policy that grants Elastic Load Balancing permissions to write to the bucket.</p> </li> <li> <p> <code>access_logs.s3.prefix</code> - The prefix for the location in the S3 bucket for the access logs.</p> </li> <li> <p> <code>ipv6.deny_all_igw_traffic</code> - Blocks internet gateway (IGW) access to the load balancer. It is set to <code>false</code> for internet-facing load balancers and <code>true</code> for internal load balancers, preventing unintended access to your internal load balancer through an internet gateway.</p> </li> </ul> <p>The following attributes are supported by only Application Load Balancers:</p> <ul> <li> <p> <code>idle_timeout.timeout_seconds</code> - The idle timeout value, in seconds. The valid range is 1-4000 seconds. The default is 60 seconds.</p> </li> <li> <p> <code>client_keep_alive.seconds</code> - The client keep alive value, in seconds. The valid range is 60-604800 seconds. The default is 3600 seconds.</p> </li> <li> <p> <code>connection_logs.s3.enabled</code> - Indicates whether connection logs are enabled. The value is <code>true</code> or <code>false</code>. The default is <code>false</code>.</p> </li> <li> <p> <code>connection_logs.s3.bucket</code> - The name of the S3 bucket for the connection logs. This attribute is required if connection logs are enabled. The bucket must exist in the same region as the load balancer and have a bucket policy that grants Elastic Load Balancing permissions to write to the bucket.</p> </li> <li> <p> <code>connection_logs.s3.prefix</code> - The prefix for the location in the S3 bucket for the connection logs.</p> </li> <li> <p> <code>routing.http.desync_mitigation_mode</code> - Determines how the load balancer handles requests that might pose a security risk to your application. The possible values are <code>monitor</code>, <code>defensive</code>, and <code>strictest</code>. The default is <code>defensive</code>.</p> </li> <li> <p> <code>routing.http.drop_invalid_header_fields.enabled</code> - Indicates whether HTTP headers with invalid header fields are removed by the load balancer (<code>true</code>) or routed to targets (<code>false</code>). The default is <code>false</code>.</p> </li> <li> <p> <code>routing.http.preserve_host_header.enabled</code> - Indicates whether the Application Load Balancer should preserve the <code>Host</code> header in the HTTP request and send it to the target without any change. The possible values are <code>true</code> and <code>false</code>. The default is <code>false</code>.</p> </li> <li> <p> <code>routing.http.x_amzn_tls_version_and_cipher_suite.enabled</code> - Indicates whether the two headers (<code>x-amzn-tls-version</code> and <code>x-amzn-tls-cipher-suite</code>), which contain information about the negotiated TLS version and cipher suite, are added to the client request before sending it to the target. The <code>x-amzn-tls-version</code> header has information about the TLS protocol version negotiated with the client, and the <code>x-amzn-tls-cipher-suite</code> header has information about the cipher suite negotiated with the client. Both headers are in OpenSSL format. The possible values for the attribute are <code>true</code> and <code>false</code>. The default is <code>false</code>.</p> </li> <li> <p> <code>routing.http.xff_client_port.enabled</code> - Indicates whether the <code>X-Forwarded-For</code> header should preserve the source port that the client used to connect to the load balancer. The possible values are <code>true</code> and <code>false</code>. The default is <code>false</code>.</p> </li> <li> <p> <code>routing.http.xff_header_processing.mode</code> - Enables you to modify, preserve, or remove the <code>X-Forwarded-For</code> header in the HTTP request before the Application Load Balancer sends the request to the target. The possible values are <code>append</code>, <code>preserve</code>, and <code>remove</code>. The default is <code>append</code>.</p> <ul> <li> <p>If the value is <code>append</code>, the Application Load Balancer adds the client IP address (of the last hop) to the <code>X-Forwarded-For</code> header in the HTTP request before it sends it to targets.</p> </li> <li> <p>If the value is <code>preserve</code> the Application Load Balancer preserves the <code>X-Forwarded-For</code> header in the HTTP request, and sends it to targets without any change.</p> </li> <li> <p>If the value is <code>remove</code>, the Application Load Balancer removes the <code>X-Forwarded-For</code> header in the HTTP request before it sends it to targets.</p> </li> </ul> </li> <li> <p> <code>routing.http2.enabled</code> - Indicates whether HTTP/2 is enabled. The possible values are <code>true</code> and <code>false</code>. The default is <code>true</code>. Elastic Load Balancing requires that message header names contain only alphanumeric characters and hyphens.</p> </li> <li> <p> <code>waf.fail_open.enabled</code> - Indicates whether to allow a WAF-enabled load balancer to route requests to targets if it is unable to forward the request to Amazon Web Services WAF. The possible values are <code>true</code> and <code>false</code>. The default is <code>false</code>.</p> </li> </ul> <p>The following attributes are supported by only Network Load Balancers:</p> <ul> <li> <p> <code>dns_record.client_routing_policy</code> - Indicates how traffic is distributed among the load balancer Availability Zones. The possible values are <code>availability_zone_affinity</code> with 100 percent zonal affinity, <code>partial_availability_zone_affinity</code> with 85 percent zonal affinity, and <code>any_availability_zone</code> with 0 percent zonal affinity.</p> </li> </ul>', ], ], 'LoadBalancerAttributeValue' => [ 'base' => NULL, 'refs' => [ 'LoadBalancerAttribute$Value' => '<p>The value of the attribute.</p>', ], ], 'LoadBalancerAttributes' => [ 'base' => NULL, 'refs' => [ 'DescribeLoadBalancerAttributesOutput$Attributes' => '<p>Information about the load balancer attributes.</p>', 'ModifyLoadBalancerAttributesInput$Attributes' => '<p>The load balancer attributes.</p>', 'ModifyLoadBalancerAttributesOutput$Attributes' => '<p>Information about the load balancer attributes.</p>', ], ], 'LoadBalancerName' => [ 'base' => NULL, 'refs' => [ 'CreateLoadBalancerInput$Name' => '<p>The name of the load balancer.</p> <p>This name must be unique per region per account, can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, must not begin or end with a hyphen, and must not begin with "internal-".</p>', 'LoadBalancer$LoadBalancerName' => '<p>The name of the load balancer.</p>', 'LoadBalancerNames$member' => NULL, ], ], 'LoadBalancerNames' => [ 'base' => NULL, 'refs' => [ 'DescribeLoadBalancersInput$Names' => '<p>The names of the load balancers.</p>', ], ], 'LoadBalancerNotFoundException' => [ 'base' => '<p>The specified load balancer does not exist.</p>', 'refs' => [], ], 'LoadBalancerSchemeEnum' => [ 'base' => NULL, 'refs' => [ 'CreateLoadBalancerInput$Scheme' => '<p>The nodes of an Internet-facing load balancer have public IP addresses. The DNS name of an Internet-facing load balancer is publicly resolvable to the public IP addresses of the nodes. Therefore, Internet-facing load balancers can route requests from clients over the internet.</p> <p>The nodes of an internal load balancer have only private IP addresses. The DNS name of an internal load balancer is publicly resolvable to the private IP addresses of the nodes. Therefore, internal load balancers can route requests only from clients with access to the VPC for the load balancer.</p> <p>The default is an Internet-facing load balancer.</p> <p>You cannot specify a scheme for a Gateway Load Balancer.</p>', 'LoadBalancer$Scheme' => '<p>The nodes of an Internet-facing load balancer have public IP addresses. The DNS name of an Internet-facing load balancer is publicly resolvable to the public IP addresses of the nodes. Therefore, Internet-facing load balancers can route requests from clients over the internet.</p> <p>The nodes of an internal load balancer have only private IP addresses. The DNS name of an internal load balancer is publicly resolvable to the private IP addresses of the nodes. Therefore, internal load balancers can route requests only from clients with access to the VPC for the load balancer.</p>', ], ], 'LoadBalancerState' => [ 'base' => '<p>Information about the state of the load balancer.</p>', 'refs' => [ 'LoadBalancer$State' => '<p>The state of the load balancer.</p>', ], ], 'LoadBalancerStateEnum' => [ 'base' => NULL, 'refs' => [ 'LoadBalancerState$Code' => '<p>The state code. The initial state of the load balancer is <code>provisioning</code>. After the load balancer is fully set up and ready to route traffic, its state is <code>active</code>. If load balancer is routing traffic but does not have the resources it needs to scale, its state is<code>active_impaired</code>. If the load balancer could not be set up, its state is <code>failed</code>.</p>', ], ], 'LoadBalancerTypeEnum' => [ 'base' => NULL, 'refs' => [ 'CreateLoadBalancerInput$Type' => '<p>The type of load balancer. The default is <code>application</code>.</p>', 'DescribeSSLPoliciesInput$LoadBalancerType' => '<p> The type of load balancer. The default lists the SSL policies for all load balancers.</p>', 'LoadBalancer$Type' => '<p>The type of load balancer.</p>', ], ], 'LoadBalancers' => [ 'base' => NULL, 'refs' => [ 'CreateLoadBalancerOutput$LoadBalancers' => '<p>Information about the load balancer.</p>', 'DescribeLoadBalancersOutput$LoadBalancers' => '<p>Information about the load balancers.</p>', ], ], 'Location' => [ 'base' => NULL, 'refs' => [ 'GetTrustStoreCaCertificatesBundleOutput$Location' => '<p>The ca certificate bundles Amazon S3 URI.</p>', 'GetTrustStoreRevocationContentOutput$Location' => '<p>The revocation files Amazon S3 URI.</p>', ], ], 'Marker' => [ 'base' => NULL, 'refs' => [ 'DescribeAccountLimitsInput$Marker' => '<p>The marker for the next set of results. (You received this marker from a previous call.)</p>', 'DescribeAccountLimitsOutput$NextMarker' => '<p>If there are additional results, this is the marker for the next set of results. Otherwise, this is null.</p>', 'DescribeListenerCertificatesInput$Marker' => '<p>The marker for the next set of results. (You received this marker from a previous call.)</p>', 'DescribeListenerCertificatesOutput$NextMarker' => '<p>If there are additional results, this is the marker for the next set of results. Otherwise, this is null.</p>', 'DescribeListenersInput$Marker' => '<p>The marker for the next set of results. (You received this marker from a previous call.)</p>', 'DescribeListenersOutput$NextMarker' => '<p>If there are additional results, this is the marker for the next set of results. Otherwise, this is null.</p>', 'DescribeLoadBalancersInput$Marker' => '<p>The marker for the next set of results. (You received this marker from a previous call.)</p>', 'DescribeLoadBalancersOutput$NextMarker' => '<p>If there are additional results, this is the marker for the next set of results. Otherwise, this is null.</p>', 'DescribeRulesInput$Marker' => '<p>The marker for the next set of results. (You received this marker from a previous call.)</p>', 'DescribeRulesOutput$NextMarker' => '<p>If there are additional results, this is the marker for the next set of results. Otherwise, this is null.</p>', 'DescribeSSLPoliciesInput$Marker' => '<p>The marker for the next set of results. (You received this marker from a previous call.)</p>', 'DescribeSSLPoliciesOutput$NextMarker' => '<p>If there are additional results, this is the marker for the next set of results. Otherwise, this is null.</p>', 'DescribeTargetGroupsInput$Marker' => '<p>The marker for the next set of results. (You received this marker from a previous call.)</p>', 'DescribeTargetGroupsOutput$NextMarker' => '<p>If there are additional results, this is the marker for the next set of results. Otherwise, this is null.</p>', 'DescribeTrustStoreAssociationsInput$Marker' => '<p>The marker for the next set of results. (You received this marker from a previous call.)</p>', 'DescribeTrustStoreAssociationsOutput$NextMarker' => '<p>If there are additional results, this is the marker for the next set of results. Otherwise, this is null.</p>', 'DescribeTrustStoreRevocationsInput$Marker' => '<p>The marker for the next set of results. (You received this marker from a previous call.)</p>', 'DescribeTrustStoreRevocationsOutput$NextMarker' => '<p>If there are additional results, this is the marker for the next set of results. Otherwise, this is null.</p>', 'DescribeTrustStoresInput$Marker' => '<p>The marker for the next set of results. (You received this marker from a previous call.)</p>', 'DescribeTrustStoresOutput$NextMarker' => '<p>If there are additional results, this is the marker for the next set of results. Otherwise, this is null.</p>', ], ], 'Matcher' => [ 'base' => '<p>The codes to use when checking for a successful response from a target. If the protocol version is gRPC, these are gRPC codes. Otherwise, these are HTTP codes. </p>', 'refs' => [ 'CreateTargetGroupInput$Matcher' => '<p>[HTTP/HTTPS health checks] The HTTP or gRPC codes to use when checking for a successful response from a target. For target groups with a protocol of TCP, TCP_UDP, UDP or TLS the range is 200-599. For target groups with a protocol of HTTP or HTTPS, the range is 200-499. For target groups with a protocol of GENEVE, the range is 200-399.</p>', 'ModifyTargetGroupInput$Matcher' => '<p>[HTTP/HTTPS health checks] The HTTP or gRPC codes to use when checking for a successful response from a target. For target groups with a protocol of TCP, TCP_UDP, UDP or TLS the range is 200-599. For target groups with a protocol of HTTP or HTTPS, the range is 200-499. For target groups with a protocol of GENEVE, the range is 200-399.</p>', 'TargetGroup$Matcher' => '<p>The HTTP or gRPC codes to use when checking for a successful response from a target.</p>', ], ], 'Max' => [ 'base' => NULL, 'refs' => [ 'Limit$Max' => '<p>The maximum value of the limit.</p>', ], ], 'MitigationInEffectEnum' => [ 'base' => NULL, 'refs' => [ 'AnomalyDetection$MitigationInEffect' => '<p>Indicates whether anomaly mitigation is in progress.</p>', ], ], 'Mode' => [ 'base' => NULL, 'refs' => [ 'MutualAuthenticationAttributes$Mode' => '<p>The client certificate handling method. Options are <code>off</code>, <code>passthrough</code> or <code>verify</code>. The default value is <code>off</code>.</p>', ], ], 'ModifyListenerInput' => [ 'base' => NULL, 'refs' => [], ], 'ModifyListenerOutput' => [ 'base' => NULL, 'refs' => [], ], 'ModifyLoadBalancerAttributesInput' => [ 'base' => NULL, 'refs' => [], ], 'ModifyLoadBalancerAttributesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ModifyRuleInput' => [ 'base' => NULL, 'refs' => [], ], 'ModifyRuleOutput' => [ 'base' => NULL, 'refs' => [], ], 'ModifyTargetGroupAttributesInput' => [ 'base' => NULL, 'refs' => [], ], 'ModifyTargetGroupAttributesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ModifyTargetGroupInput' => [ 'base' => NULL, 'refs' => [], ], 'ModifyTargetGroupOutput' => [ 'base' => NULL, 'refs' => [], ], 'ModifyTrustStoreInput' => [ 'base' => NULL, 'refs' => [], ], 'ModifyTrustStoreOutput' => [ 'base' => NULL, 'refs' => [], ], 'MutualAuthenticationAttributes' => [ 'base' => '<p>Information about the mutual authentication attributes of a listener.</p>', 'refs' => [ 'CreateListenerInput$MutualAuthentication' => '<p>The mutual authentication configuration information.</p>', 'Listener$MutualAuthentication' => '<p>The mutual authentication configuration information.</p>', 'ModifyListenerInput$MutualAuthentication' => '<p>The mutual authentication configuration information.</p>', ], ], 'Name' => [ 'base' => NULL, 'refs' => [ 'Limit$Name' => '<p>The name of the limit. The possible values are:</p> <ul> <li> <p>application-load-balancers</p> </li> <li> <p>condition-values-per-alb-rule</p> </li> <li> <p>condition-wildcards-per-alb-rule</p> </li> <li> <p>gateway-load-balancers</p> </li> <li> <p>gateway-load-balancers-per-vpc</p> </li> <li> <p>geneve-target-groups</p> </li> <li> <p>listeners-per-application-load-balancer</p> </li> <li> <p>listeners-per-network-load-balancer</p> </li> <li> <p>network-load-balancers</p> </li> <li> <p>rules-per-application-load-balancer</p> </li> <li> <p>target-groups</p> </li> <li> <p>target-groups-per-action-on-application-load-balancer</p> </li> <li> <p>target-groups-per-action-on-network-load-balancer</p> </li> <li> <p>target-groups-per-application-load-balancer</p> </li> <li> <p>targets-per-application-load-balancer</p> </li> <li> <p>targets-per-availability-zone-per-gateway-load-balancer</p> </li> <li> <p>targets-per-availability-zone-per-network-load-balancer</p> </li> <li> <p>targets-per-network-load-balancer</p> </li> </ul>', ], ], 'NumberOfCaCertificates' => [ 'base' => NULL, 'refs' => [ 'TrustStore$NumberOfCaCertificates' => '<p>The number of ca certificates in the trust store.</p>', ], ], 'NumberOfRevokedEntries' => [ 'base' => NULL, 'refs' => [ 'DescribeTrustStoreRevocation$NumberOfRevokedEntries' => '<p>The number of revoked certificates.</p>', 'TrustStoreRevocation$NumberOfRevokedEntries' => '<p>The number of revoked certificates.</p>', ], ], 'OperationNotPermittedException' => [ 'base' => '<p>This operation is not allowed.</p>', 'refs' => [], ], 'OutpostId' => [ 'base' => NULL, 'refs' => [ 'AvailabilityZone$OutpostId' => '<p>[Application Load Balancers on Outposts] The ID of the Outpost.</p>', ], ], 'PageSize' => [ 'base' => NULL, 'refs' => [ 'DescribeAccountLimitsInput$PageSize' => '<p>The maximum number of results to return with this call.</p>', 'DescribeListenerCertificatesInput$PageSize' => '<p>The maximum number of results to return with this call.</p>', 'DescribeListenersInput$PageSize' => '<p>The maximum number of results to return with this call.</p>', 'DescribeLoadBalancersInput$PageSize' => '<p>The maximum number of results to return with this call.</p>', 'DescribeRulesInput$PageSize' => '<p>The maximum number of results to return with this call.</p>', 'DescribeSSLPoliciesInput$PageSize' => '<p>The maximum number of results to return with this call.</p>', 'DescribeTargetGroupsInput$PageSize' => '<p>The maximum number of results to return with this call.</p>', 'DescribeTrustStoreAssociationsInput$PageSize' => '<p>The maximum number of results to return with this call.</p>', 'DescribeTrustStoreRevocationsInput$PageSize' => '<p>The maximum number of results to return with this call.</p>', 'DescribeTrustStoresInput$PageSize' => '<p>The maximum number of results to return with this call.</p>', ], ], 'Path' => [ 'base' => NULL, 'refs' => [ 'CreateTargetGroupInput$HealthCheckPath' => '<p>[HTTP/HTTPS health checks] The destination for health checks on the targets.</p> <p>[HTTP1 or HTTP2 protocol version] The ping path. The default is /.</p> <p>[GRPC protocol version] The path of a custom health check method with the format /package.service/method. The default is /Amazon Web Services.ALB/healthcheck.</p>', 'ModifyTargetGroupInput$HealthCheckPath' => '<p>[HTTP/HTTPS health checks] The destination for health checks on the targets.</p> <p>[HTTP1 or HTTP2 protocol version] The ping path. The default is /.</p> <p>[GRPC protocol version] The path of a custom health check method with the format /package.service/method. The default is /Amazon Web Services.ALB/healthcheck.</p>', 'TargetGroup$HealthCheckPath' => '<p>The destination for health checks on the targets.</p>', ], ], 'PathPatternConditionConfig' => [ 'base' => '<p>Information about a path pattern condition.</p>', 'refs' => [ 'RuleCondition$PathPatternConfig' => '<p>Information for a path pattern condition. Specify only when <code>Field</code> is <code>path-pattern</code>.</p>', ], ], 'Port' => [ 'base' => NULL, 'refs' => [ 'CreateListenerInput$Port' => '<p>The port on which the load balancer is listening. You cannot specify a port for a Gateway Load Balancer.</p>', 'CreateTargetGroupInput$Port' => '<p>The port on which the targets receive traffic. This port is used unless you specify a port override when registering the target. If the target is a Lambda function, this parameter does not apply. If the protocol is GENEVE, the supported port is 6081.</p>', 'Listener$Port' => '<p>The port on which the load balancer is listening.</p>', 'ModifyListenerInput$Port' => '<p>The port for connections from clients to the load balancer. You cannot specify a port for a Gateway Load Balancer.</p>', 'TargetDescription$Port' => '<p>The port on which the target is listening. If the target group protocol is GENEVE, the supported port is 6081. If the target type is <code>alb</code>, the targeted Application Load Balancer must have at least one listener whose port matches the target group port. This parameter is not used if the target is a Lambda function.</p>', 'TargetGroup$Port' => '<p>The port on which the targets are listening. This parameter is not used if the target is a Lambda function.</p>', ], ], 'PriorityInUseException' => [ 'base' => '<p>The specified priority is in use.</p>', 'refs' => [], ], 'PrivateIPv4Address' => [ 'base' => NULL, 'refs' => [ 'LoadBalancerAddress$PrivateIPv4Address' => '<p>[Network Load Balancers] The private IPv4 address for an internal load balancer.</p>', 'SubnetMapping$PrivateIPv4Address' => '<p>[Network Load Balancers] The private IPv4 address for an internal load balancer.</p>', ], ], 'ProtocolEnum' => [ 'base' => NULL, 'refs' => [ 'CreateListenerInput$Protocol' => '<p>The protocol for connections from clients to the load balancer. For Application Load Balancers, the supported protocols are HTTP and HTTPS. For Network Load Balancers, the supported protocols are TCP, TLS, UDP, and TCP_UDP. You can’t specify the UDP or TCP_UDP protocol if dual-stack mode is enabled. You cannot specify a protocol for a Gateway Load Balancer.</p>', 'CreateTargetGroupInput$Protocol' => '<p>The protocol to use for routing traffic to the targets. For Application Load Balancers, the supported protocols are HTTP and HTTPS. For Network Load Balancers, the supported protocols are TCP, TLS, UDP, or TCP_UDP. For Gateway Load Balancers, the supported protocol is GENEVE. A TCP_UDP listener must be associated with a TCP_UDP target group. If the target is a Lambda function, this parameter does not apply.</p>', 'CreateTargetGroupInput$HealthCheckProtocol' => '<p>The protocol the load balancer uses when performing health checks on targets. For Application Load Balancers, the default is HTTP. For Network Load Balancers and Gateway Load Balancers, the default is TCP. The TCP protocol is not supported for health checks if the protocol of the target group is HTTP or HTTPS. The GENEVE, TLS, UDP, and TCP_UDP protocols are not supported for health checks.</p>', 'Listener$Protocol' => '<p>The protocol for connections from clients to the load balancer.</p>', 'ModifyListenerInput$Protocol' => '<p>The protocol for connections from clients to the load balancer. Application Load Balancers support the HTTP and HTTPS protocols. Network Load Balancers support the TCP, TLS, UDP, and TCP_UDP protocols. You can’t change the protocol to UDP or TCP_UDP if dual-stack mode is enabled. You cannot specify a protocol for a Gateway Load Balancer.</p>', 'ModifyTargetGroupInput$HealthCheckProtocol' => '<p>The protocol the load balancer uses when performing health checks on targets. For Application Load Balancers, the default is HTTP. For Network Load Balancers and Gateway Load Balancers, the default is TCP. The TCP protocol is not supported for health checks if the protocol of the target group is HTTP or HTTPS. It is supported for health checks only if the protocol of the target group is TCP, TLS, UDP, or TCP_UDP. The GENEVE, TLS, UDP, and TCP_UDP protocols are not supported for health checks.</p>', 'TargetGroup$Protocol' => '<p>The protocol to use for routing traffic to the targets.</p>', 'TargetGroup$HealthCheckProtocol' => '<p>The protocol to use to connect with the target. The GENEVE, TLS, UDP, and TCP_UDP protocols are not supported for health checks.</p>', ], ], 'ProtocolVersion' => [ 'base' => NULL, 'refs' => [ 'CreateTargetGroupInput$ProtocolVersion' => '<p>[HTTP/HTTPS protocol] The protocol version. Specify <code>GRPC</code> to send requests to targets using gRPC. Specify <code>HTTP2</code> to send requests to targets using HTTP/2. The default is <code>HTTP1</code>, which sends requests to targets using HTTP/1.1.</p>', 'TargetGroup$ProtocolVersion' => '<p>[HTTP/HTTPS protocol] The protocol version. The possible values are <code>GRPC</code>, <code>HTTP1</code>, and <code>HTTP2</code>.</p>', ], ], 'QueryStringConditionConfig' => [ 'base' => '<p>Information about a query string condition.</p> <p>The query string component of a URI starts after the first \'?\' character and is terminated by either a \'#\' character or the end of the URI. A typical query string contains key/value pairs separated by \'&amp;\' characters. The allowed characters are specified by RFC 3986. Any character can be percentage encoded.</p>', 'refs' => [ 'RuleCondition$QueryStringConfig' => '<p>Information for a query string condition. Specify only when <code>Field</code> is <code>query-string</code>.</p>', ], ], 'QueryStringKeyValuePair' => [ 'base' => '<p>Information about a key/value pair.</p>', 'refs' => [ 'QueryStringKeyValuePairList$member' => NULL, ], ], 'QueryStringKeyValuePairList' => [ 'base' => NULL, 'refs' => [ 'QueryStringConditionConfig$Values' => '<p>The key/value pairs or values to find in the query string. The maximum size of each string is 128 characters. The comparison is case insensitive. The following wildcard characters are supported: * (matches 0 or more characters) and ? (matches exactly 1 character). To search for a literal \'*\' or \'?\' character in a query string, you must escape these characters in <code>Values</code> using a \'\\\' character.</p> <p>If you specify multiple key/value pairs or values, the condition is satisfied if one of them is found in the query string.</p>', ], ], 'RedirectActionConfig' => [ 'base' => '<p>Information about a redirect action.</p> <p>A URI consists of the following components: protocol://hostname:port/path?query. You must modify at least one of the following components to avoid a redirect loop: protocol, hostname, port, or path. Any components that you do not modify retain their original values.</p> <p>You can reuse URI components using the following reserved keywords:</p> <ul> <li> <p>#{protocol}</p> </li> <li> <p>#{host}</p> </li> <li> <p>#{port}</p> </li> <li> <p>#{path} (the leading "/" is removed)</p> </li> <li> <p>#{query}</p> </li> </ul> <p>For example, you can change the path to "/new/#{path}", the hostname to "example.#{host}", or the query to "#{query}&amp;value=xyz".</p>', 'refs' => [ 'Action$RedirectConfig' => '<p>[Application Load Balancer] Information for creating a redirect action. Specify only when <code>Type</code> is <code>redirect</code>.</p>', ], ], 'RedirectActionHost' => [ 'base' => NULL, 'refs' => [ 'RedirectActionConfig$Host' => '<p>The hostname. This component is not percent-encoded. The hostname can contain #{host}.</p>', ], ], 'RedirectActionPath' => [ 'base' => NULL, 'refs' => [ 'RedirectActionConfig$Path' => '<p>The absolute path, starting with the leading "/". This component is not percent-encoded. The path can contain #{host}, #{path}, and #{port}.</p>', ], ], 'RedirectActionPort' => [ 'base' => NULL, 'refs' => [ 'RedirectActionConfig$Port' => '<p>The port. You can specify a value from 1 to 65535 or #{port}.</p>', ], ], 'RedirectActionProtocol' => [ 'base' => NULL, 'refs' => [ 'RedirectActionConfig$Protocol' => '<p>The protocol. You can specify HTTP, HTTPS, or #{protocol}. You can redirect HTTP to HTTP, HTTP to HTTPS, and HTTPS to HTTPS. You cannot redirect HTTPS to HTTP.</p>', ], ], 'RedirectActionQuery' => [ 'base' => NULL, 'refs' => [ 'RedirectActionConfig$Query' => '<p>The query parameters, URL-encoded when necessary, but not percent-encoded. Do not include the leading "?", as it is automatically added. You can specify any of the reserved keywords.</p>', ], ], 'RedirectActionStatusCodeEnum' => [ 'base' => NULL, 'refs' => [ 'RedirectActionConfig$StatusCode' => '<p>The HTTP redirect code. The redirect is either permanent (HTTP 301) or temporary (HTTP 302).</p>', ], ], 'RegisterTargetsInput' => [ 'base' => NULL, 'refs' => [], ], 'RegisterTargetsOutput' => [ 'base' => NULL, 'refs' => [], ], 'RemoveListenerCertificatesInput' => [ 'base' => NULL, 'refs' => [], ], 'RemoveListenerCertificatesOutput' => [ 'base' => NULL, 'refs' => [], ], 'RemoveTagsInput' => [ 'base' => NULL, 'refs' => [], ], 'RemoveTagsOutput' => [ 'base' => NULL, 'refs' => [], ], 'RemoveTrustStoreRevocationsInput' => [ 'base' => NULL, 'refs' => [], ], 'RemoveTrustStoreRevocationsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ResourceArn' => [ 'base' => NULL, 'refs' => [ 'ResourceArns$member' => NULL, 'TagDescription$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', ], ], 'ResourceArns' => [ 'base' => NULL, 'refs' => [ 'AddTagsInput$ResourceArns' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'DescribeTagsInput$ResourceArns' => '<p>The Amazon Resource Names (ARN) of the resources. You can specify up to 20 resources in a single call.</p>', 'RemoveTagsInput$ResourceArns' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', ], ], 'ResourceInUseException' => [ 'base' => '<p>A specified resource is in use.</p>', 'refs' => [], ], 'RevocationContent' => [ 'base' => '<p>Information about a revocation file.</p>', 'refs' => [ 'RevocationContents$member' => NULL, ], ], 'RevocationContentNotFoundException' => [ 'base' => '<p>The specified revocation file does not exist.</p>', 'refs' => [], ], 'RevocationContents' => [ 'base' => NULL, 'refs' => [ 'AddTrustStoreRevocationsInput$RevocationContents' => '<p>The revocation file to add.</p>', ], ], 'RevocationId' => [ 'base' => NULL, 'refs' => [ 'DescribeTrustStoreRevocation$RevocationId' => '<p>The revocation ID of a revocation file in use.</p>', 'GetTrustStoreRevocationContentInput$RevocationId' => '<p>The revocation ID of the revocation file.</p>', 'RevocationIds$member' => NULL, 'TrustStoreRevocation$RevocationId' => '<p>The revocation ID of the revocation file.</p>', ], ], 'RevocationIdNotFoundException' => [ 'base' => '<p>The specified revocation ID does not exist.</p>', 'refs' => [], ], 'RevocationIds' => [ 'base' => NULL, 'refs' => [ 'DescribeTrustStoreRevocationsInput$RevocationIds' => '<p>The revocation IDs of the revocation files you want to describe.</p>', 'RemoveTrustStoreRevocationsInput$RevocationIds' => '<p>The revocation IDs of the revocation files you want to remove.</p>', ], ], 'RevocationType' => [ 'base' => NULL, 'refs' => [ 'DescribeTrustStoreRevocation$RevocationType' => '<p>The type of revocation file.</p>', 'RevocationContent$RevocationType' => '<p>The type of revocation file.</p>', 'TrustStoreRevocation$RevocationType' => '<p>The type of revocation file.</p>', ], ], 'Rule' => [ 'base' => '<p>Information about a rule.</p>', 'refs' => [ 'Rules$member' => NULL, ], ], 'RuleArn' => [ 'base' => NULL, 'refs' => [ 'DeleteRuleInput$RuleArn' => '<p>The Amazon Resource Name (ARN) of the rule.</p>', 'ModifyRuleInput$RuleArn' => '<p>The Amazon Resource Name (ARN) of the rule.</p>', 'Rule$RuleArn' => '<p>The Amazon Resource Name (ARN) of the rule.</p>', 'RuleArns$member' => NULL, 'RulePriorityPair$RuleArn' => '<p>The Amazon Resource Name (ARN) of the rule.</p>', ], ], 'RuleArns' => [ 'base' => NULL, 'refs' => [ 'DescribeRulesInput$RuleArns' => '<p>The Amazon Resource Names (ARN) of the rules.</p>', ], ], 'RuleCondition' => [ 'base' => '<p>Information about a condition for a rule.</p> <p>Each rule can optionally include up to one of each of the following conditions: <code>http-request-method</code>, <code>host-header</code>, <code>path-pattern</code>, and <code>source-ip</code>. Each rule can also optionally include one or more of each of the following conditions: <code>http-header</code> and <code>query-string</code>. Note that the value for a condition cannot be empty.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-limits.html">Quotas for your Application Load Balancers</a>.</p>', 'refs' => [ 'RuleConditionList$member' => NULL, ], ], 'RuleConditionList' => [ 'base' => NULL, 'refs' => [ 'CreateRuleInput$Conditions' => '<p>The conditions.</p>', 'ModifyRuleInput$Conditions' => '<p>The conditions.</p>', 'Rule$Conditions' => '<p>The conditions. Each rule can include zero or one of the following conditions: <code>http-request-method</code>, <code>host-header</code>, <code>path-pattern</code>, and <code>source-ip</code>, and zero or more of the following conditions: <code>http-header</code> and <code>query-string</code>.</p>', ], ], 'RuleNotFoundException' => [ 'base' => '<p>The specified rule does not exist.</p>', 'refs' => [], ], 'RulePriority' => [ 'base' => NULL, 'refs' => [ 'CreateRuleInput$Priority' => '<p>The rule priority. A listener can\'t have multiple rules with the same priority.</p>', 'RulePriorityPair$Priority' => '<p>The rule priority.</p>', ], ], 'RulePriorityList' => [ 'base' => NULL, 'refs' => [ 'SetRulePrioritiesInput$RulePriorities' => '<p>The rule priorities.</p>', ], ], 'RulePriorityPair' => [ 'base' => '<p>Information about the priorities for the rules for a listener.</p>', 'refs' => [ 'RulePriorityList$member' => NULL, ], ], 'Rules' => [ 'base' => NULL, 'refs' => [ 'CreateRuleOutput$Rules' => '<p>Information about the rule.</p>', 'DescribeRulesOutput$Rules' => '<p>Information about the rules.</p>', 'ModifyRuleOutput$Rules' => '<p>Information about the modified rule.</p>', 'SetRulePrioritiesOutput$Rules' => '<p>Information about the rules.</p>', ], ], 'S3Bucket' => [ 'base' => NULL, 'refs' => [ 'CreateTrustStoreInput$CaCertificatesBundleS3Bucket' => '<p>The Amazon S3 bucket for the ca certificates bundle.</p>', 'ModifyTrustStoreInput$CaCertificatesBundleS3Bucket' => '<p>The Amazon S3 bucket for the ca certificates bundle.</p>', 'RevocationContent$S3Bucket' => '<p>The Amazon S3 bucket for the revocation file.</p>', ], ], 'S3Key' => [ 'base' => NULL, 'refs' => [ 'CreateTrustStoreInput$CaCertificatesBundleS3Key' => '<p>The Amazon S3 path for the ca certificates bundle.</p>', 'ModifyTrustStoreInput$CaCertificatesBundleS3Key' => '<p>The Amazon S3 path for the ca certificates bundle.</p>', 'RevocationContent$S3Key' => '<p>The Amazon S3 path for the revocation file.</p>', ], ], 'S3ObjectVersion' => [ 'base' => NULL, 'refs' => [ 'CreateTrustStoreInput$CaCertificatesBundleS3ObjectVersion' => '<p>The Amazon S3 object version for the ca certificates bundle. If undefined the current version is used.</p>', 'ModifyTrustStoreInput$CaCertificatesBundleS3ObjectVersion' => '<p>The Amazon S3 object version for the ca certificates bundle. If undefined the current version is used.</p>', 'RevocationContent$S3ObjectVersion' => '<p>The Amazon S3 object version of the revocation file.</p>', ], ], 'SSLPolicyNotFoundException' => [ 'base' => '<p>The specified SSL policy does not exist.</p>', 'refs' => [], ], 'SecurityGroupId' => [ 'base' => NULL, 'refs' => [ 'SecurityGroups$member' => NULL, ], ], 'SecurityGroups' => [ 'base' => NULL, 'refs' => [ 'CreateLoadBalancerInput$SecurityGroups' => '<p>[Application Load Balancers and Network Load Balancers] The IDs of the security groups for the load balancer.</p>', 'LoadBalancer$SecurityGroups' => '<p>The IDs of the security groups for the load balancer.</p>', 'SetSecurityGroupsInput$SecurityGroups' => '<p>The IDs of the security groups.</p>', 'SetSecurityGroupsOutput$SecurityGroupIds' => '<p>The IDs of the security groups associated with the load balancer.</p>', ], ], 'SetIpAddressTypeInput' => [ 'base' => NULL, 'refs' => [], ], 'SetIpAddressTypeOutput' => [ 'base' => NULL, 'refs' => [], ], 'SetRulePrioritiesInput' => [ 'base' => NULL, 'refs' => [], ], 'SetRulePrioritiesOutput' => [ 'base' => NULL, 'refs' => [], ], 'SetSecurityGroupsInput' => [ 'base' => NULL, 'refs' => [], ], 'SetSecurityGroupsOutput' => [ 'base' => NULL, 'refs' => [], ], 'SetSubnetsInput' => [ 'base' => NULL, 'refs' => [], ], 'SetSubnetsOutput' => [ 'base' => NULL, 'refs' => [], ], 'SourceIpConditionConfig' => [ 'base' => '<p>Information about a source IP condition.</p> <p>You can use this condition to route based on the IP address of the source that connects to the load balancer. If a client is behind a proxy, this is the IP address of the proxy not the IP address of the client.</p>', 'refs' => [ 'RuleCondition$SourceIpConfig' => '<p>Information for a source IP condition. Specify only when <code>Field</code> is <code>source-ip</code>.</p>', ], ], 'SslPolicies' => [ 'base' => NULL, 'refs' => [ 'DescribeSSLPoliciesOutput$SslPolicies' => '<p>Information about the security policies.</p>', ], ], 'SslPolicy' => [ 'base' => '<p>Information about a policy used for SSL negotiation.</p>', 'refs' => [ 'SslPolicies$member' => NULL, ], ], 'SslPolicyName' => [ 'base' => NULL, 'refs' => [ 'CreateListenerInput$SslPolicy' => '<p>[HTTPS and TLS listeners] The security policy that defines which protocols and ciphers are supported.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#describe-ssl-policies">Security policies</a> in the <i>Application Load Balancers Guide</i> and <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#describe-ssl-policies">Security policies</a> in the <i>Network Load Balancers Guide</i>.</p>', 'Listener$SslPolicy' => '<p>[HTTPS or TLS listener] The security policy that defines which protocols and ciphers are supported.</p>', 'ModifyListenerInput$SslPolicy' => '<p>[HTTPS and TLS listeners] The security policy that defines which protocols and ciphers are supported.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#describe-ssl-policies">Security policies</a> in the <i>Application Load Balancers Guide</i> or <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#describe-ssl-policies">Security policies</a> in the <i>Network Load Balancers Guide</i>.</p>', 'SslPolicy$Name' => '<p>The name of the policy.</p>', 'SslPolicyNames$member' => NULL, ], ], 'SslPolicyNames' => [ 'base' => NULL, 'refs' => [ 'DescribeSSLPoliciesInput$Names' => '<p>The names of the policies.</p>', ], ], 'SslProtocol' => [ 'base' => NULL, 'refs' => [ 'SslProtocols$member' => NULL, ], ], 'SslProtocols' => [ 'base' => NULL, 'refs' => [ 'SslPolicy$SslProtocols' => '<p>The protocols.</p>', ], ], 'StateReason' => [ 'base' => NULL, 'refs' => [ 'LoadBalancerState$Reason' => '<p>A description of the state.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'Rule$Priority' => '<p>The priority.</p>', ], ], 'StringValue' => [ 'base' => NULL, 'refs' => [ 'ListOfString$member' => NULL, 'QueryStringKeyValuePair$Key' => '<p>The key. You can omit the key.</p>', 'QueryStringKeyValuePair$Value' => '<p>The value.</p>', ], ], 'SubnetId' => [ 'base' => NULL, 'refs' => [ 'AvailabilityZone$SubnetId' => '<p>The ID of the subnet. You can specify one subnet per Availability Zone.</p>', 'SubnetMapping$SubnetId' => '<p>The ID of the subnet.</p>', 'Subnets$member' => NULL, ], ], 'SubnetMapping' => [ 'base' => '<p>Information about a subnet mapping.</p>', 'refs' => [ 'SubnetMappings$member' => NULL, ], ], 'SubnetMappings' => [ 'base' => NULL, 'refs' => [ 'CreateLoadBalancerInput$SubnetMappings' => '<p>The IDs of the subnets. You can specify only one subnet per Availability Zone. You must specify either subnets or subnet mappings, but not both.</p> <p>[Application Load Balancers] You must specify subnets from at least two Availability Zones. You cannot specify Elastic IP addresses for your subnets.</p> <p>[Application Load Balancers on Outposts] You must specify one Outpost subnet.</p> <p>[Application Load Balancers on Local Zones] You can specify subnets from one or more Local Zones.</p> <p>[Network Load Balancers] You can specify subnets from one or more Availability Zones. You can specify one Elastic IP address per subnet if you need static IP addresses for your internet-facing load balancer. For internal load balancers, you can specify one private IP address per subnet from the IPv4 range of the subnet. For internet-facing load balancer, you can specify one IPv6 address per subnet.</p> <p>[Gateway Load Balancers] You can specify subnets from one or more Availability Zones. You cannot specify Elastic IP addresses for your subnets.</p>', 'SetSubnetsInput$SubnetMappings' => '<p>The IDs of the public subnets. You can specify only one subnet per Availability Zone. You must specify either subnets or subnet mappings.</p> <p>[Application Load Balancers] You must specify subnets from at least two Availability Zones. You cannot specify Elastic IP addresses for your subnets.</p> <p>[Application Load Balancers on Outposts] You must specify one Outpost subnet.</p> <p>[Application Load Balancers on Local Zones] You can specify subnets from one or more Local Zones.</p> <p>[Network Load Balancers] You can specify subnets from one or more Availability Zones. You can specify one Elastic IP address per subnet if you need static IP addresses for your internet-facing load balancer. For internal load balancers, you can specify one private IP address per subnet from the IPv4 range of the subnet. For internet-facing load balancer, you can specify one IPv6 address per subnet.</p> <p>[Gateway Load Balancers] You can specify subnets from one or more Availability Zones.</p>', ], ], 'SubnetNotFoundException' => [ 'base' => '<p>The specified subnet does not exist.</p>', 'refs' => [], ], 'Subnets' => [ 'base' => NULL, 'refs' => [ 'CreateLoadBalancerInput$Subnets' => '<p>The IDs of the subnets. You can specify only one subnet per Availability Zone. You must specify either subnets or subnet mappings, but not both. To specify an Elastic IP address, specify subnet mappings instead of subnets.</p> <p>[Application Load Balancers] You must specify subnets from at least two Availability Zones.</p> <p>[Application Load Balancers on Outposts] You must specify one Outpost subnet.</p> <p>[Application Load Balancers on Local Zones] You can specify subnets from one or more Local Zones.</p> <p>[Network Load Balancers] You can specify subnets from one or more Availability Zones.</p> <p>[Gateway Load Balancers] You can specify subnets from one or more Availability Zones.</p>', 'SetSubnetsInput$Subnets' => '<p>The IDs of the public subnets. You can specify only one subnet per Availability Zone. You must specify either subnets or subnet mappings.</p> <p>[Application Load Balancers] You must specify subnets from at least two Availability Zones.</p> <p>[Application Load Balancers on Outposts] You must specify one Outpost subnet.</p> <p>[Application Load Balancers on Local Zones] You can specify subnets from one or more Local Zones.</p> <p>[Network Load Balancers] You can specify subnets from one or more Availability Zones.</p> <p>[Gateway Load Balancers] You can specify subnets from one or more Availability Zones.</p>', ], ], 'Tag' => [ 'base' => '<p>Information about a tag.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagDescription' => [ 'base' => '<p>The tags associated with a resource.</p>', 'refs' => [ 'TagDescriptions$member' => NULL, ], ], 'TagDescriptions' => [ 'base' => NULL, 'refs' => [ 'DescribeTagsOutput$TagDescriptions' => '<p>Information about the tags.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>The key of the tag.</p>', 'TagKeys$member' => NULL, ], ], 'TagKeys' => [ 'base' => NULL, 'refs' => [ 'RemoveTagsInput$TagKeys' => '<p>The tag keys for the tags to remove.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'AddTagsInput$Tags' => '<p>The tags.</p>', 'CreateListenerInput$Tags' => '<p>The tags to assign to the listener.</p>', 'CreateLoadBalancerInput$Tags' => '<p>The tags to assign to the load balancer.</p>', 'CreateRuleInput$Tags' => '<p>The tags to assign to the rule.</p>', 'CreateTargetGroupInput$Tags' => '<p>The tags to assign to the target group.</p>', 'CreateTrustStoreInput$Tags' => '<p>The tags to assign to the trust store.</p>', 'TagDescription$Tags' => '<p>Information about the tags.</p>', ], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The value of the tag.</p>', ], ], 'TargetDescription' => [ 'base' => '<p>Information about a target.</p>', 'refs' => [ 'TargetDescriptions$member' => NULL, 'TargetHealthDescription$Target' => '<p>The description of the target.</p>', ], ], 'TargetDescriptions' => [ 'base' => NULL, 'refs' => [ 'DeregisterTargetsInput$Targets' => '<p>The targets. If you specified a port override when you registered a target, you must specify both the target ID and the port when you deregister it.</p>', 'DescribeTargetHealthInput$Targets' => '<p>The targets.</p>', 'RegisterTargetsInput$Targets' => '<p>The targets.</p>', ], ], 'TargetGroup' => [ 'base' => '<p>Information about a target group.</p>', 'refs' => [ 'TargetGroups$member' => NULL, ], ], 'TargetGroupArn' => [ 'base' => NULL, 'refs' => [ 'Action$TargetGroupArn' => '<p>The Amazon Resource Name (ARN) of the target group. Specify only when <code>Type</code> is <code>forward</code> and you want to route to a single target group. To route to one or more target groups, use <code>ForwardConfig</code> instead.</p>', 'DeleteTargetGroupInput$TargetGroupArn' => '<p>The Amazon Resource Name (ARN) of the target group.</p>', 'DeregisterTargetsInput$TargetGroupArn' => '<p>The Amazon Resource Name (ARN) of the target group.</p>', 'DescribeTargetGroupAttributesInput$TargetGroupArn' => '<p>The Amazon Resource Name (ARN) of the target group.</p>', 'DescribeTargetHealthInput$TargetGroupArn' => '<p>The Amazon Resource Name (ARN) of the target group.</p>', 'ModifyTargetGroupAttributesInput$TargetGroupArn' => '<p>The Amazon Resource Name (ARN) of the target group.</p>', 'ModifyTargetGroupInput$TargetGroupArn' => '<p>The Amazon Resource Name (ARN) of the target group.</p>', 'RegisterTargetsInput$TargetGroupArn' => '<p>The Amazon Resource Name (ARN) of the target group.</p>', 'TargetGroup$TargetGroupArn' => '<p>The Amazon Resource Name (ARN) of the target group.</p>', 'TargetGroupArns$member' => NULL, 'TargetGroupTuple$TargetGroupArn' => '<p>The Amazon Resource Name (ARN) of the target group.</p>', ], ], 'TargetGroupArns' => [ 'base' => NULL, 'refs' => [ 'DescribeTargetGroupsInput$TargetGroupArns' => '<p>The Amazon Resource Names (ARN) of the target groups.</p>', ], ], 'TargetGroupAssociationLimitException' => [ 'base' => '<p>You\'ve reached the limit on the number of load balancers per target group.</p>', 'refs' => [], ], 'TargetGroupAttribute' => [ 'base' => '<p>Information about a target group attribute.</p>', 'refs' => [ 'TargetGroupAttributes$member' => NULL, ], ], 'TargetGroupAttributeKey' => [ 'base' => NULL, 'refs' => [ 'TargetGroupAttribute$Key' => '<p>The name of the attribute.</p> <p>The following attributes are supported by all load balancers:</p> <ul> <li> <p> <code>deregistration_delay.timeout_seconds</code> - The amount of time, in seconds, for Elastic Load Balancing to wait before changing the state of a deregistering target from <code>draining</code> to <code>unused</code>. The range is 0-3600 seconds. The default value is 300 seconds. If the target is a Lambda function, this attribute is not supported.</p> </li> <li> <p> <code>stickiness.enabled</code> - Indicates whether target stickiness is enabled. The value is <code>true</code> or <code>false</code>. The default is <code>false</code>.</p> </li> <li> <p> <code>stickiness.type</code> - Indicates the type of stickiness. The possible values are:</p> <ul> <li> <p> <code>lb_cookie</code> and <code>app_cookie</code> for Application Load Balancers.</p> </li> <li> <p> <code>source_ip</code> for Network Load Balancers.</p> </li> <li> <p> <code>source_ip_dest_ip</code> and <code>source_ip_dest_ip_proto</code> for Gateway Load Balancers.</p> </li> </ul> </li> </ul> <p>The following attributes are supported by Application Load Balancers and Network Load Balancers:</p> <ul> <li> <p> <code>load_balancing.cross_zone.enabled</code> - Indicates whether cross zone load balancing is enabled. The value is <code>true</code>, <code>false</code> or <code>use_load_balancer_configuration</code>. The default is <code>use_load_balancer_configuration</code>.</p> </li> <li> <p> <code>target_group_health.dns_failover.minimum_healthy_targets.count</code> - The minimum number of targets that must be healthy. If the number of healthy targets is below this value, mark the zone as unhealthy in DNS, so that traffic is routed only to healthy zones. The possible values are <code>off</code> or an integer from 1 to the maximum number of targets. The default is <code>off</code>.</p> </li> <li> <p> <code>target_group_health.dns_failover.minimum_healthy_targets.percentage</code> - The minimum percentage of targets that must be healthy. If the percentage of healthy targets is below this value, mark the zone as unhealthy in DNS, so that traffic is routed only to healthy zones. The possible values are <code>off</code> or an integer from 1 to 100. The default is <code>off</code>.</p> </li> <li> <p> <code>target_group_health.unhealthy_state_routing.minimum_healthy_targets.count</code> - The minimum number of targets that must be healthy. If the number of healthy targets is below this value, send traffic to all targets, including unhealthy targets. The possible values are 1 to the maximum number of targets. The default is 1.</p> </li> <li> <p> <code>target_group_health.unhealthy_state_routing.minimum_healthy_targets.percentage</code> - The minimum percentage of targets that must be healthy. If the percentage of healthy targets is below this value, send traffic to all targets, including unhealthy targets. The possible values are <code>off</code> or an integer from 1 to 100. The default is <code>off</code>.</p> </li> </ul> <p>The following attributes are supported only if the load balancer is an Application Load Balancer and the target is an instance or an IP address:</p> <ul> <li> <p> <code>load_balancing.algorithm.type</code> - The load balancing algorithm determines how the load balancer selects targets when routing requests. The value is <code>round_robin</code>, <code>least_outstanding_requests</code>, or <code>weighted_random</code>. The default is <code>round_robin</code>.</p> </li> <li> <p> <code>load_balancing.algorithm.anomaly_mitigation</code> - Only available when <code>load_balancing.algorithm.type</code> is <code>weighted_random</code>. Indicates whether anomaly mitigation is enabled. The value is <code>on</code> or <code>off</code>. The default is <code>off</code>.</p> </li> <li> <p> <code>slow_start.duration_seconds</code> - The time period, in seconds, during which a newly registered target receives an increasing share of the traffic to the target group. After this time period ends, the target receives its full share of traffic. The range is 30-900 seconds (15 minutes). The default is 0 seconds (disabled).</p> </li> <li> <p> <code>stickiness.app_cookie.cookie_name</code> - Indicates the name of the application-based cookie. Names that start with the following prefixes are not allowed: <code>AWSALB</code>, <code>AWSALBAPP</code>, and <code>AWSALBTG</code>; they\'re reserved for use by the load balancer.</p> </li> <li> <p> <code>stickiness.app_cookie.duration_seconds</code> - The time period, in seconds, during which requests from a client should be routed to the same target. After this time period expires, the application-based cookie is considered stale. The range is 1 second to 1 week (604800 seconds). The default value is 1 day (86400 seconds).</p> </li> <li> <p> <code>stickiness.lb_cookie.duration_seconds</code> - The time period, in seconds, during which requests from a client should be routed to the same target. After this time period expires, the load balancer-generated cookie is considered stale. The range is 1 second to 1 week (604800 seconds). The default value is 1 day (86400 seconds). </p> </li> </ul> <p>The following attribute is supported only if the load balancer is an Application Load Balancer and the target is a Lambda function:</p> <ul> <li> <p> <code>lambda.multi_value_headers.enabled</code> - Indicates whether the request and response headers that are exchanged between the load balancer and the Lambda function include arrays of values or strings. The value is <code>true</code> or <code>false</code>. The default is <code>false</code>. If the value is <code>false</code> and the request contains a duplicate header field name or query parameter key, the load balancer uses the last value sent by the client.</p> </li> </ul> <p>The following attributes are supported only by Network Load Balancers:</p> <ul> <li> <p> <code>deregistration_delay.connection_termination.enabled</code> - Indicates whether the load balancer terminates connections at the end of the deregistration timeout. The value is <code>true</code> or <code>false</code>. For new UDP/TCP_UDP target groups the default is <code>true</code>. Otherwise, the default is <code>false</code>.</p> </li> <li> <p> <code>preserve_client_ip.enabled</code> - Indicates whether client IP preservation is enabled. The value is <code>true</code> or <code>false</code>. The default is disabled if the target group type is IP address and the target group protocol is TCP or TLS. Otherwise, the default is enabled. Client IP preservation cannot be disabled for UDP and TCP_UDP target groups.</p> </li> <li> <p> <code>proxy_protocol_v2.enabled</code> - Indicates whether Proxy Protocol version 2 is enabled. The value is <code>true</code> or <code>false</code>. The default is <code>false</code>. </p> </li> <li> <p> <code>target_health_state.unhealthy.connection_termination.enabled</code> - Indicates whether the load balancer terminates connections to unhealthy targets. The value is <code>true</code> or <code>false</code>. The default is <code>true</code>.</p> </li> <li> <p> <code>target_health_state.unhealthy.draining_interval_seconds</code> - The amount of time for Elastic Load Balancing to wait before changing the state of an unhealthy target from <code>unhealthy.draining</code> to <code>unhealthy</code>. The range is 0-360000 seconds. The default value is 0 seconds.</p> <p>Note: This attribute can only be configured when <code>target_health_state.unhealthy.connection_termination.enabled</code> is <code>false</code>.</p> </li> </ul> <p>The following attributes are supported only by Gateway Load Balancers:</p> <ul> <li> <p> <code>target_failover.on_deregistration</code> - Indicates how the Gateway Load Balancer handles existing flows when a target is deregistered. The possible values are <code>rebalance</code> and <code>no_rebalance</code>. The default is <code>no_rebalance</code>. The two attributes (<code>target_failover.on_deregistration</code> and <code>target_failover.on_unhealthy</code>) can\'t be set independently. The value you set for both attributes must be the same. </p> </li> <li> <p> <code>target_failover.on_unhealthy</code> - Indicates how the Gateway Load Balancer handles existing flows when a target is unhealthy. The possible values are <code>rebalance</code> and <code>no_rebalance</code>. The default is <code>no_rebalance</code>. The two attributes (<code>target_failover.on_deregistration</code> and <code>target_failover.on_unhealthy</code>) cannot be set independently. The value you set for both attributes must be the same. </p> </li> </ul>', ], ], 'TargetGroupAttributeValue' => [ 'base' => NULL, 'refs' => [ 'TargetGroupAttribute$Value' => '<p>The value of the attribute.</p>', ], ], 'TargetGroupAttributes' => [ 'base' => NULL, 'refs' => [ 'DescribeTargetGroupAttributesOutput$Attributes' => '<p>Information about the target group attributes</p>', 'ModifyTargetGroupAttributesInput$Attributes' => '<p>The attributes.</p>', 'ModifyTargetGroupAttributesOutput$Attributes' => '<p>Information about the attributes.</p>', ], ], 'TargetGroupIpAddressTypeEnum' => [ 'base' => NULL, 'refs' => [ 'CreateTargetGroupInput$IpAddressType' => '<p>The type of IP address used for this target group. The possible values are <code>ipv4</code> and <code>ipv6</code>. This is an optional parameter. If not specified, the IP address type defaults to <code>ipv4</code>.</p>', 'TargetGroup$IpAddressType' => '<p>The type of IP address used for this target group. The possible values are <code>ipv4</code> and <code>ipv6</code>. This is an optional parameter. If not specified, the IP address type defaults to <code>ipv4</code>.</p>', ], ], 'TargetGroupList' => [ 'base' => NULL, 'refs' => [ 'ForwardActionConfig$TargetGroups' => '<p>The target groups. For Network Load Balancers, you can specify a single target group.</p>', ], ], 'TargetGroupName' => [ 'base' => NULL, 'refs' => [ 'CreateTargetGroupInput$Name' => '<p>The name of the target group.</p> <p>This name must be unique per region per account, can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, and must not begin or end with a hyphen.</p>', 'TargetGroup$TargetGroupName' => '<p>The name of the target group.</p>', 'TargetGroupNames$member' => NULL, ], ], 'TargetGroupNames' => [ 'base' => NULL, 'refs' => [ 'DescribeTargetGroupsInput$Names' => '<p>The names of the target groups.</p>', ], ], 'TargetGroupNotFoundException' => [ 'base' => '<p>The specified target group does not exist.</p>', 'refs' => [], ], 'TargetGroupStickinessConfig' => [ 'base' => '<p>Information about the target group stickiness for a rule.</p>', 'refs' => [ 'ForwardActionConfig$TargetGroupStickinessConfig' => '<p>The target group stickiness for the rule.</p>', ], ], 'TargetGroupStickinessDurationSeconds' => [ 'base' => NULL, 'refs' => [ 'TargetGroupStickinessConfig$DurationSeconds' => '<p>The time period, in seconds, during which requests from a client should be routed to the same target group. The range is 1-604800 seconds (7 days).</p>', ], ], 'TargetGroupStickinessEnabled' => [ 'base' => NULL, 'refs' => [ 'TargetGroupStickinessConfig$Enabled' => '<p>Indicates whether target group stickiness is enabled.</p>', ], ], 'TargetGroupTuple' => [ 'base' => '<p>Information about how traffic will be distributed between multiple target groups in a forward rule.</p>', 'refs' => [ 'TargetGroupList$member' => NULL, ], ], 'TargetGroupWeight' => [ 'base' => NULL, 'refs' => [ 'TargetGroupTuple$Weight' => '<p>The weight. The range is 0 to 999.</p>', ], ], 'TargetGroups' => [ 'base' => NULL, 'refs' => [ 'CreateTargetGroupOutput$TargetGroups' => '<p>Information about the target group.</p>', 'DescribeTargetGroupsOutput$TargetGroups' => '<p>Information about the target groups.</p>', 'ModifyTargetGroupOutput$TargetGroups' => '<p>Information about the modified target group.</p>', ], ], 'TargetHealth' => [ 'base' => '<p>Information about the current health of a target.</p>', 'refs' => [ 'TargetHealthDescription$TargetHealth' => '<p>The health information for the target.</p>', ], ], 'TargetHealthDescription' => [ 'base' => '<p>Information about the health of a target.</p>', 'refs' => [ 'TargetHealthDescriptions$member' => NULL, ], ], 'TargetHealthDescriptions' => [ 'base' => NULL, 'refs' => [ 'DescribeTargetHealthOutput$TargetHealthDescriptions' => '<p>Information about the health of the targets.</p>', ], ], 'TargetHealthReasonEnum' => [ 'base' => NULL, 'refs' => [ 'TargetHealth$Reason' => '<p>The reason code.</p> <p>If the target state is <code>healthy</code>, a reason code is not provided.</p> <p>If the target state is <code>initial</code>, the reason code can be one of the following values:</p> <ul> <li> <p> <code>Elb.RegistrationInProgress</code> - The target is in the process of being registered with the load balancer.</p> </li> <li> <p> <code>Elb.InitialHealthChecking</code> - The load balancer is still sending the target the minimum number of health checks required to determine its health status.</p> </li> </ul> <p>If the target state is <code>unhealthy</code>, the reason code can be one of the following values:</p> <ul> <li> <p> <code>Target.ResponseCodeMismatch</code> - The health checks did not return an expected HTTP code. Applies only to Application Load Balancers and Gateway Load Balancers.</p> </li> <li> <p> <code>Target.Timeout</code> - The health check requests timed out. Applies only to Application Load Balancers and Gateway Load Balancers.</p> </li> <li> <p> <code>Target.FailedHealthChecks</code> - The load balancer received an error while establishing a connection to the target or the target response was malformed.</p> </li> <li> <p> <code>Elb.InternalError</code> - The health checks failed due to an internal error. Applies only to Application Load Balancers.</p> </li> </ul> <p>If the target state is <code>unused</code>, the reason code can be one of the following values:</p> <ul> <li> <p> <code>Target.NotRegistered</code> - The target is not registered with the target group.</p> </li> <li> <p> <code>Target.NotInUse</code> - The target group is not used by any load balancer or the target is in an Availability Zone that is not enabled for its load balancer.</p> </li> <li> <p> <code>Target.InvalidState</code> - The target is in the stopped or terminated state.</p> </li> <li> <p> <code>Target.IpUnusable</code> - The target IP address is reserved for use by a load balancer.</p> </li> </ul> <p>If the target state is <code>draining</code>, the reason code can be the following value:</p> <ul> <li> <p> <code>Target.DeregistrationInProgress</code> - The target is in the process of being deregistered and the deregistration delay period has not expired.</p> </li> </ul> <p>If the target state is <code>unavailable</code>, the reason code can be the following value:</p> <ul> <li> <p> <code>Target.HealthCheckDisabled</code> - Health checks are disabled for the target group. Applies only to Application Load Balancers.</p> </li> <li> <p> <code>Elb.InternalError</code> - Target health is unavailable due to an internal error. Applies only to Network Load Balancers.</p> </li> </ul>', ], ], 'TargetHealthStateEnum' => [ 'base' => NULL, 'refs' => [ 'TargetHealth$State' => '<p>The state of the target.</p>', ], ], 'TargetId' => [ 'base' => NULL, 'refs' => [ 'TargetDescription$Id' => '<p>The ID of the target. If the target type of the target group is <code>instance</code>, specify an instance ID. If the target type is <code>ip</code>, specify an IP address. If the target type is <code>lambda</code>, specify the ARN of the Lambda function. If the target type is <code>alb</code>, specify the ARN of the Application Load Balancer target. </p>', ], ], 'TargetTypeEnum' => [ 'base' => NULL, 'refs' => [ 'CreateTargetGroupInput$TargetType' => '<p>The type of target that you must specify when registering targets with this target group. You can\'t specify targets for a target group using more than one target type.</p> <ul> <li> <p> <code>instance</code> - Register targets by instance ID. This is the default value.</p> </li> <li> <p> <code>ip</code> - Register targets by IP address. You can specify IP addresses from the subnets of the virtual private cloud (VPC) for the target group, the RFC 1918 range (10.0.0.0/8, 172.16.0.0/12, and 192.168.0.0/16), and the RFC 6598 range (100.64.0.0/10). You can\'t specify publicly routable IP addresses.</p> </li> <li> <p> <code>lambda</code> - Register a single Lambda function as a target.</p> </li> <li> <p> <code>alb</code> - Register a single Application Load Balancer as a target.</p> </li> </ul>', 'TargetGroup$TargetType' => '<p>The type of target that you must specify when registering targets with this target group. The possible values are <code>instance</code> (register targets by instance ID), <code>ip</code> (register targets by IP address), <code>lambda</code> (register a single Lambda function as a target), or <code>alb</code> (register a single Application Load Balancer as a target).</p>', ], ], 'TooManyActionsException' => [ 'base' => '<p>You\'ve reached the limit on the number of actions per rule.</p>', 'refs' => [], ], 'TooManyCertificatesException' => [ 'base' => '<p>You\'ve reached the limit on the number of certificates per load balancer.</p>', 'refs' => [], ], 'TooManyListenersException' => [ 'base' => '<p>You\'ve reached the limit on the number of listeners per load balancer.</p>', 'refs' => [], ], 'TooManyLoadBalancersException' => [ 'base' => '<p>You\'ve reached the limit on the number of load balancers for your Amazon Web Services account.</p>', 'refs' => [], ], 'TooManyRegistrationsForTargetIdException' => [ 'base' => '<p>You\'ve reached the limit on the number of times a target can be registered with a load balancer.</p>', 'refs' => [], ], 'TooManyRulesException' => [ 'base' => '<p>You\'ve reached the limit on the number of rules per load balancer.</p>', 'refs' => [], ], 'TooManyTagsException' => [ 'base' => '<p>You\'ve reached the limit on the number of tags for this resource.</p>', 'refs' => [], ], 'TooManyTargetGroupsException' => [ 'base' => '<p>You\'ve reached the limit on the number of target groups for your Amazon Web Services account.</p>', 'refs' => [], ], 'TooManyTargetsException' => [ 'base' => '<p>You\'ve reached the limit on the number of targets.</p>', 'refs' => [], ], 'TooManyTrustStoreRevocationEntriesException' => [ 'base' => '<p>The specified trust store has too many revocation entries.</p>', 'refs' => [], ], 'TooManyTrustStoresException' => [ 'base' => '<p>You\'ve reached the limit on the number of trust stores for your Amazon Web Services account.</p>', 'refs' => [], ], 'TooManyUniqueTargetGroupsPerLoadBalancerException' => [ 'base' => '<p>You\'ve reached the limit on the number of unique target groups per load balancer across all listeners. If a target group is used by multiple actions for a load balancer, it is counted as only one use.</p>', 'refs' => [], ], 'TotalRevokedEntries' => [ 'base' => NULL, 'refs' => [ 'TrustStore$TotalRevokedEntries' => '<p>The number of revoked certificates in the trust store.</p>', ], ], 'TrustStore' => [ 'base' => '<p>Information about a trust store.</p>', 'refs' => [ 'TrustStores$member' => NULL, ], ], 'TrustStoreArn' => [ 'base' => NULL, 'refs' => [ 'AddTrustStoreRevocationsInput$TrustStoreArn' => '<p>The Amazon Resource Name (ARN) of the trust store.</p>', 'DeleteTrustStoreInput$TrustStoreArn' => '<p>The Amazon Resource Name (ARN) of the trust store.</p>', 'DescribeTrustStoreAssociationsInput$TrustStoreArn' => '<p>The Amazon Resource Name (ARN) of the trust store.</p>', 'DescribeTrustStoreRevocation$TrustStoreArn' => '<p>The Amazon Resource Name (ARN) of the trust store.</p>', 'DescribeTrustStoreRevocationsInput$TrustStoreArn' => '<p>The Amazon Resource Name (ARN) of the trust store.</p>', 'GetTrustStoreCaCertificatesBundleInput$TrustStoreArn' => '<p>The Amazon Resource Name (ARN) of the trust store.</p>', 'GetTrustStoreRevocationContentInput$TrustStoreArn' => '<p>The Amazon Resource Name (ARN) of the trust store.</p>', 'ModifyTrustStoreInput$TrustStoreArn' => '<p>The Amazon Resource Name (ARN) of the trust store.</p>', 'MutualAuthenticationAttributes$TrustStoreArn' => '<p>The Amazon Resource Name (ARN) of the trust store.</p>', 'RemoveTrustStoreRevocationsInput$TrustStoreArn' => '<p>The Amazon Resource Name (ARN) of the trust store.</p>', 'TrustStore$TrustStoreArn' => '<p>The Amazon Resource Name (ARN) of the trust store.</p>', 'TrustStoreArns$member' => NULL, 'TrustStoreRevocation$TrustStoreArn' => '<p>The Amazon Resource Name (ARN) of the trust store.</p>', ], ], 'TrustStoreArns' => [ 'base' => NULL, 'refs' => [ 'DescribeTrustStoresInput$TrustStoreArns' => '<p>The Amazon Resource Name (ARN) of the trust store.</p>', ], ], 'TrustStoreAssociation' => [ 'base' => '<p>Information about the resources a trust store is associated with.</p>', 'refs' => [ 'TrustStoreAssociations$member' => NULL, ], ], 'TrustStoreAssociationResourceArn' => [ 'base' => NULL, 'refs' => [ 'TrustStoreAssociation$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', ], ], 'TrustStoreAssociations' => [ 'base' => NULL, 'refs' => [ 'DescribeTrustStoreAssociationsOutput$TrustStoreAssociations' => '<p>Information about the resources the trust store is associated to.</p>', ], ], 'TrustStoreInUseException' => [ 'base' => '<p>The specified trust store is currently in use.</p>', 'refs' => [], ], 'TrustStoreName' => [ 'base' => NULL, 'refs' => [ 'CreateTrustStoreInput$Name' => '<p>The name of the trust store.</p> <p>This name must be unique per region and cannot be changed after creation.</p>', 'TrustStore$Name' => '<p>The name of the trust store.</p>', 'TrustStoreNames$member' => NULL, ], ], 'TrustStoreNames' => [ 'base' => NULL, 'refs' => [ 'DescribeTrustStoresInput$Names' => '<p>The names of the trust stores.</p>', ], ], 'TrustStoreNotFoundException' => [ 'base' => '<p>The specified trust store does not exist.</p>', 'refs' => [], ], 'TrustStoreNotReadyException' => [ 'base' => '<p>The specified trust store is not active.</p>', 'refs' => [], ], 'TrustStoreRevocation' => [ 'base' => '<p>Information about a revocation file in use by a trust store.</p>', 'refs' => [ 'TrustStoreRevocations$member' => NULL, ], ], 'TrustStoreRevocations' => [ 'base' => NULL, 'refs' => [ 'AddTrustStoreRevocationsOutput$TrustStoreRevocations' => '<p>Information about the revocation file added to the trust store.</p>', ], ], 'TrustStoreStatus' => [ 'base' => NULL, 'refs' => [ 'TrustStore$Status' => '<p>The current status of the trust store.</p>', ], ], 'TrustStores' => [ 'base' => NULL, 'refs' => [ 'CreateTrustStoreOutput$TrustStores' => '<p>Information about the trust store created.</p>', 'DescribeTrustStoresOutput$TrustStores' => '<p>Information about the trust stores.</p>', 'ModifyTrustStoreOutput$TrustStores' => '<p>Information about the modified trust store.</p>', ], ], 'UnsupportedProtocolException' => [ 'base' => '<p>The specified protocol is not supported.</p>', 'refs' => [], ], 'VpcId' => [ 'base' => NULL, 'refs' => [ 'CreateTargetGroupInput$VpcId' => '<p>The identifier of the virtual private cloud (VPC). If the target is a Lambda function, this parameter does not apply. Otherwise, this parameter is required.</p>', 'LoadBalancer$VpcId' => '<p>The ID of the VPC for the load balancer.</p>', 'TargetGroup$VpcId' => '<p>The ID of the VPC for the targets.</p>', ], ], 'ZoneName' => [ 'base' => NULL, 'refs' => [ 'AvailabilityZone$ZoneName' => '<p>The name of the Availability Zone.</p>', 'TargetDescription$AvailabilityZone' => '<p>An Availability Zone or <code>all</code>. This determines whether the target receives traffic from the load balancer nodes in the specified Availability Zone or from all enabled Availability Zones for the load balancer.</p> <p>For Application Load Balancer target groups, the specified Availability Zone value is only applicable when cross-zone load balancing is off. Otherwise the parameter is ignored and treated as <code>all</code>.</p> <p>This parameter is not supported if the target type of the target group is <code>instance</code> or <code>alb</code>.</p> <p>If the target type is <code>ip</code> and the IP address is in a subnet of the VPC for the target group, the Availability Zone is automatically detected and this parameter is optional. If the IP address is outside the VPC, this parameter is required.</p> <p>For Application Load Balancer target groups with cross-zone load balancing off, if the target type is <code>ip</code> and the IP address is outside of the VPC for the target group, this should be an Availability Zone inside the VPC for the target group.</p> <p>If the target type is <code>lambda</code>, this parameter is optional and the only supported value is <code>all</code>.</p>', ], ], ],];
