<?php
// This file was auto-generated from sdk-root/src/data/frauddetector/2019-11-15/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>This is the Amazon Fraud Detector API Reference. This guide is for developers who need detailed information about Amazon Fraud Detector API actions, data types, and errors. For more information about Amazon Fraud Detector features, see the <a href="https://docs.aws.amazon.com/frauddetector/latest/ug/">Amazon Fraud Detector User Guide</a>.</p> <p>We provide the Query API as well as AWS software development kits (SDK) for Amazon Fraud Detector in Java and Python programming languages.</p> <p>The Amazon Fraud Detector Query API provides HTTPS requests that use the HTTP verb GET or POST and a Query parameter <code>Action</code>. AWS SDK provides libraries, sample code, tutorials, and other resources for software developers who prefer to build applications using language-specific APIs instead of submitting a request over HTTP or HTTPS. These libraries provide basic functions that automatically take care of tasks such as cryptographically signing your requests, retrying requests, and handling error responses, so that it is easier for you to get started. For more information about the AWS SDKs, go to <a href="https://aws.amazon.com/developer/tools/">Tools to build on AWS</a> page, scroll down to the <b>SDK</b> section, and choose plus (+) sign to expand the section. </p>', 'operations' => [ 'BatchCreateVariable' => '<p>Creates a batch of variables.</p>', 'BatchGetVariable' => '<p>Gets a batch of variables.</p>', 'CancelBatchImportJob' => '<p> Cancels an in-progress batch import job.</p>', 'CancelBatchPredictionJob' => '<p>Cancels the specified batch prediction job.</p>', 'CreateBatchImportJob' => '<p>Creates a batch import job. </p>', 'CreateBatchPredictionJob' => '<p>Creates a batch prediction job.</p>', 'CreateDetectorVersion' => '<p>Creates a detector version. The detector version starts in a <code>DRAFT</code> status.</p>', 'CreateList' => '<p> Creates a list. </p> <p>List is a set of input data for a variable in your event dataset. You use the input data in a rule that\'s associated with your detector. For more information, see <a href="https://docs.aws.amazon.com/frauddetector/latest/ug/lists.html">Lists</a>.</p>', 'CreateModel' => '<p>Creates a model using the specified model type.</p>', 'CreateModelVersion' => '<p>Creates a version of the model using the specified model type and model id. </p>', 'CreateRule' => '<p>Creates a rule for use with the specified detector. </p>', 'CreateVariable' => '<p>Creates a variable.</p>', 'DeleteBatchImportJob' => '<p>Deletes the specified batch import job ID record. This action does not delete the data that was batch imported. </p>', 'DeleteBatchPredictionJob' => '<p>Deletes a batch prediction job.</p>', 'DeleteDetector' => '<p>Deletes the detector. Before deleting a detector, you must first delete all detector versions and rule versions associated with the detector.</p> <p>When you delete a detector, Amazon Fraud Detector permanently deletes the detector and the data is no longer stored in Amazon Fraud Detector.</p>', 'DeleteDetectorVersion' => '<p>Deletes the detector version. You cannot delete detector versions that are in <code>ACTIVE</code> status.</p> <p>When you delete a detector version, Amazon Fraud Detector permanently deletes the detector and the data is no longer stored in Amazon Fraud Detector.</p>', 'DeleteEntityType' => '<p>Deletes an entity type.</p> <p>You cannot delete an entity type that is included in an event type.</p> <p>When you delete an entity type, Amazon Fraud Detector permanently deletes that entity type and the data is no longer stored in Amazon Fraud Detector.</p>', 'DeleteEvent' => '<p>Deletes the specified event.</p> <p>When you delete an event, Amazon Fraud Detector permanently deletes that event and the event data is no longer stored in Amazon Fraud Detector. If <code>deleteAuditHistory</code> is <code>True</code>, event data is available through search for up to 30 seconds after the delete operation is completed.</p>', 'DeleteEventType' => '<p>Deletes an event type.</p> <p>You cannot delete an event type that is used in a detector or a model.</p> <p>When you delete an event type, Amazon Fraud Detector permanently deletes that event type and the data is no longer stored in Amazon Fraud Detector.</p>', 'DeleteEventsByEventType' => '<p>Deletes all events of a particular event type.</p>', 'DeleteExternalModel' => '<p>Removes a SageMaker model from Amazon Fraud Detector.</p> <p>You can remove an Amazon SageMaker model if it is not associated with a detector version. Removing a SageMaker model disconnects it from Amazon Fraud Detector, but the model remains available in SageMaker.</p>', 'DeleteLabel' => '<p>Deletes a label.</p> <p>You cannot delete labels that are included in an event type in Amazon Fraud Detector.</p> <p>You cannot delete a label assigned to an event ID. You must first delete the relevant event ID.</p> <p>When you delete a label, Amazon Fraud Detector permanently deletes that label and the data is no longer stored in Amazon Fraud Detector.</p>', 'DeleteList' => '<p> Deletes the list, provided it is not used in a rule. </p> <p> When you delete a list, Amazon Fraud Detector permanently deletes that list and the elements in the list.</p>', 'DeleteModel' => '<p>Deletes a model.</p> <p>You can delete models and model versions in Amazon Fraud Detector, provided that they are not associated with a detector version.</p> <p> When you delete a model, Amazon Fraud Detector permanently deletes that model and the data is no longer stored in Amazon Fraud Detector.</p>', 'DeleteModelVersion' => '<p>Deletes a model version.</p> <p>You can delete models and model versions in Amazon Fraud Detector, provided that they are not associated with a detector version.</p> <p> When you delete a model version, Amazon Fraud Detector permanently deletes that model version and the data is no longer stored in Amazon Fraud Detector.</p>', 'DeleteOutcome' => '<p>Deletes an outcome.</p> <p>You cannot delete an outcome that is used in a rule version.</p> <p>When you delete an outcome, Amazon Fraud Detector permanently deletes that outcome and the data is no longer stored in Amazon Fraud Detector.</p>', 'DeleteRule' => '<p>Deletes the rule. You cannot delete a rule if it is used by an <code>ACTIVE</code> or <code>INACTIVE</code> detector version.</p> <p>When you delete a rule, Amazon Fraud Detector permanently deletes that rule and the data is no longer stored in Amazon Fraud Detector.</p>', 'DeleteVariable' => '<p>Deletes a variable.</p> <p>You can\'t delete variables that are included in an event type in Amazon Fraud Detector.</p> <p>Amazon Fraud Detector automatically deletes model output variables and SageMaker model output variables when you delete the model. You can\'t delete these variables manually.</p> <p>When you delete a variable, Amazon Fraud Detector permanently deletes that variable and the data is no longer stored in Amazon Fraud Detector.</p>', 'DescribeDetector' => '<p>Gets all versions for a specified detector.</p>', 'DescribeModelVersions' => '<p>Gets all of the model versions for the specified model type or for the specified model type and model ID. You can also get details for a single, specified model version. </p>', 'GetBatchImportJobs' => '<p>Gets all batch import jobs or a specific job of the specified ID. This is a paginated API. If you provide a null <code>maxResults</code>, this action retrieves a maximum of 50 records per page. If you provide a <code>maxResults</code>, the value must be between 1 and 50. To get the next page results, provide the pagination token from the <code>GetBatchImportJobsResponse</code> as part of your request. A null pagination token fetches the records from the beginning.</p>', 'GetBatchPredictionJobs' => '<p>Gets all batch prediction jobs or a specific job if you specify a job ID. This is a paginated API. If you provide a null maxResults, this action retrieves a maximum of 50 records per page. If you provide a maxResults, the value must be between 1 and 50. To get the next page results, provide the pagination token from the GetBatchPredictionJobsResponse as part of your request. A null pagination token fetches the records from the beginning.</p>', 'GetDeleteEventsByEventTypeStatus' => '<p>Retrieves the status of a <code>DeleteEventsByEventType</code> action.</p>', 'GetDetectorVersion' => '<p>Gets a particular detector version. </p>', 'GetDetectors' => '<p>Gets all detectors or a single detector if a <code>detectorId</code> is specified. This is a paginated API. If you provide a null <code>maxResults</code>, this action retrieves a maximum of 10 records per page. If you provide a <code>maxResults</code>, the value must be between 5 and 10. To get the next page results, provide the pagination token from the <code>GetDetectorsResponse</code> as part of your request. A null pagination token fetches the records from the beginning. </p>', 'GetEntityTypes' => '<p>Gets all entity types or a specific entity type if a name is specified. This is a paginated API. If you provide a null <code>maxResults</code>, this action retrieves a maximum of 10 records per page. If you provide a <code>maxResults</code>, the value must be between 5 and 10. To get the next page results, provide the pagination token from the <code>GetEntityTypesResponse</code> as part of your request. A null pagination token fetches the records from the beginning. </p>', 'GetEvent' => '<p>Retrieves details of events stored with Amazon Fraud Detector. This action does not retrieve prediction results.</p>', 'GetEventPrediction' => '<p>Evaluates an event against a detector version. If a version ID is not provided, the detector’s (<code>ACTIVE</code>) version is used.</p>', 'GetEventPredictionMetadata' => '<p> Gets details of the past fraud predictions for the specified event ID, event type, detector ID, and detector version ID that was generated in the specified time period. </p>', 'GetEventTypes' => '<p>Gets all event types or a specific event type if name is provided. This is a paginated API. If you provide a null <code>maxResults</code>, this action retrieves a maximum of 10 records per page. If you provide a <code>maxResults</code>, the value must be between 5 and 10. To get the next page results, provide the pagination token from the <code>GetEventTypesResponse</code> as part of your request. A null pagination token fetches the records from the beginning. </p>', 'GetExternalModels' => '<p>Gets the details for one or more Amazon SageMaker models that have been imported into the service. This is a paginated API. If you provide a null <code>maxResults</code>, this actions retrieves a maximum of 10 records per page. If you provide a <code>maxResults</code>, the value must be between 5 and 10. To get the next page results, provide the pagination token from the <code>GetExternalModelsResult</code> as part of your request. A null pagination token fetches the records from the beginning. </p>', 'GetKMSEncryptionKey' => '<p>Gets the encryption key if a KMS key has been specified to be used to encrypt content in Amazon Fraud Detector.</p>', 'GetLabels' => '<p>Gets all labels or a specific label if name is provided. This is a paginated API. If you provide a null <code>maxResults</code>, this action retrieves a maximum of 50 records per page. If you provide a <code>maxResults</code>, the value must be between 10 and 50. To get the next page results, provide the pagination token from the <code>GetGetLabelsResponse</code> as part of your request. A null pagination token fetches the records from the beginning. </p>', 'GetListElements' => '<p> Gets all the elements in the specified list. </p>', 'GetListsMetadata' => '<p> Gets the metadata of either all the lists under the account or the specified list. </p>', 'GetModelVersion' => '<p>Gets the details of the specified model version.</p>', 'GetModels' => '<p>Gets one or more models. Gets all models for the Amazon Web Services account if no model type and no model id provided. Gets all models for the Amazon Web Services account and model type, if the model type is specified but model id is not provided. Gets a specific model if (model type, model id) tuple is specified. </p> <p>This is a paginated API. If you provide a null <code>maxResults</code>, this action retrieves a maximum of 10 records per page. If you provide a <code>maxResults</code>, the value must be between 1 and 10. To get the next page results, provide the pagination token from the response as part of your request. A null pagination token fetches the records from the beginning.</p>', 'GetOutcomes' => '<p>Gets one or more outcomes. This is a paginated API. If you provide a null <code>maxResults</code>, this actions retrieves a maximum of 100 records per page. If you provide a <code>maxResults</code>, the value must be between 50 and 100. To get the next page results, provide the pagination token from the <code>GetOutcomesResult</code> as part of your request. A null pagination token fetches the records from the beginning. </p>', 'GetRules' => '<p>Get all rules for a detector (paginated) if <code>ruleId</code> and <code>ruleVersion</code> are not specified. Gets all rules for the detector and the <code>ruleId</code> if present (paginated). Gets a specific rule if both the <code>ruleId</code> and the <code>ruleVersion</code> are specified.</p> <p>This is a paginated API. Providing null maxResults results in retrieving maximum of 100 records per page. If you provide maxResults the value must be between 50 and 100. To get the next page result, a provide a pagination token from GetRulesResult as part of your request. Null pagination token fetches the records from the beginning.</p>', 'GetVariables' => '<p>Gets all of the variables or the specific variable. This is a paginated API. Providing null <code>maxSizePerPage</code> results in retrieving maximum of 100 records per page. If you provide <code>maxSizePerPage</code> the value must be between 50 and 100. To get the next page result, a provide a pagination token from <code>GetVariablesResult</code> as part of your request. Null pagination token fetches the records from the beginning. </p>', 'ListEventPredictions' => '<p>Gets a list of past predictions. The list can be filtered by detector ID, detector version ID, event ID, event type, or by specifying a time period. If filter is not specified, the most recent prediction is returned.</p> <p>For example, the following filter lists all past predictions for <code>xyz</code> event type - <code>{ "eventType":{ "value": "xyz" }” } </code> </p> <p>This is a paginated API. If you provide a null <code>maxResults</code>, this action will retrieve a maximum of 10 records per page. If you provide a <code>maxResults</code>, the value must be between 50 and 100. To get the next page results, provide the <code>nextToken</code> from the response as part of your request. A null <code>nextToken</code> fetches the records from the beginning. </p>', 'ListTagsForResource' => '<p>Lists all tags associated with the resource. This is a paginated API. To get the next page results, provide the pagination token from the response as part of your request. A null pagination token fetches the records from the beginning. </p>', 'PutDetector' => '<p>Creates or updates a detector. </p>', 'PutEntityType' => '<p>Creates or updates an entity type. An entity represents who is performing the event. As part of a fraud prediction, you pass the entity ID to indicate the specific entity who performed the event. An entity type classifies the entity. Example classifications include customer, merchant, or account.</p>', 'PutEventType' => '<p>Creates or updates an event type. An event is a business activity that is evaluated for fraud risk. With Amazon Fraud Detector, you generate fraud predictions for events. An event type defines the structure for an event sent to Amazon Fraud Detector. This includes the variables sent as part of the event, the entity performing the event (such as a customer), and the labels that classify the event. Example event types include online payment transactions, account registrations, and authentications.</p>', 'PutExternalModel' => '<p>Creates or updates an Amazon SageMaker model endpoint. You can also use this action to update the configuration of the model endpoint, including the IAM role and/or the mapped variables. </p>', 'PutKMSEncryptionKey' => '<p>Specifies the KMS key to be used to encrypt content in Amazon Fraud Detector.</p>', 'PutLabel' => '<p>Creates or updates label. A label classifies an event as fraudulent or legitimate. Labels are associated with event types and used to train supervised machine learning models in Amazon Fraud Detector. </p>', 'PutOutcome' => '<p>Creates or updates an outcome. </p>', 'SendEvent' => '<p>Stores events in Amazon Fraud Detector without generating fraud predictions for those events. For example, you can use <code>SendEvent</code> to upload a historical dataset, which you can then later use to train a model.</p>', 'TagResource' => '<p>Assigns tags to a resource.</p>', 'UntagResource' => '<p>Removes tags from a resource.</p>', 'UpdateDetectorVersion' => '<p> Updates a detector version. The detector version attributes that you can update include models, external model endpoints, rules, rule execution mode, and description. You can only update a <code>DRAFT</code> detector version.</p>', 'UpdateDetectorVersionMetadata' => '<p>Updates the detector version\'s description. You can update the metadata for any detector version (<code>DRAFT, ACTIVE,</code> or <code>INACTIVE</code>). </p>', 'UpdateDetectorVersionStatus' => '<p>Updates the detector version’s status. You can perform the following promotions or demotions using <code>UpdateDetectorVersionStatus</code>: <code>DRAFT</code> to <code>ACTIVE</code>, <code>ACTIVE</code> to <code>INACTIVE</code>, and <code>INACTIVE</code> to <code>ACTIVE</code>.</p>', 'UpdateEventLabel' => '<p>Updates the specified event with a new label.</p>', 'UpdateList' => '<p> Updates a list. </p>', 'UpdateModel' => '<p>Updates model description.</p>', 'UpdateModelVersion' => '<p>Updates a model version. Updating a model version retrains an existing model version using updated training data and produces a new minor version of the model. You can update the training data set location and data access role attributes using this action. This action creates and trains a new minor version of the model, for example version 1.01, 1.02, 1.03.</p>', 'UpdateModelVersionStatus' => '<p>Updates the status of a model version.</p> <p>You can perform the following status updates:</p> <ol> <li> <p>Change the <code>TRAINING_IN_PROGRESS</code> status to <code>TRAINING_CANCELLED</code>.</p> </li> <li> <p>Change the <code>TRAINING_COMPLETE</code> status to <code>ACTIVE</code>.</p> </li> <li> <p>Change <code>ACTIVE</code> to <code>INACTIVE</code>.</p> </li> </ol>', 'UpdateRuleMetadata' => '<p>Updates a rule\'s metadata. The description attribute can be updated.</p>', 'UpdateRuleVersion' => '<p>Updates a rule version resulting in a new rule version. Updates a rule version resulting in a new rule version (version 1, 2, 3 ...). </p>', 'UpdateVariable' => '<p>Updates a variable.</p>', ], 'shapes' => [ 'ATIMetricDataPoint' => [ 'base' => '<p> The Account Takeover Insights (ATI) model performance metrics data points. </p>', 'refs' => [ 'ATIMetricDataPointsList$member' => NULL, ], ], 'ATIMetricDataPointsList' => [ 'base' => NULL, 'refs' => [ 'ATITrainingMetricsValue$metricDataPoints' => '<p> The model\'s performance metrics data points. </p>', ], ], 'ATIModelPerformance' => [ 'base' => '<p> The Account Takeover Insights (ATI) model performance score. </p>', 'refs' => [ 'ATITrainingMetricsValue$modelPerformance' => '<p> The model\'s overall performance scores. </p>', ], ], 'ATITrainingMetricsValue' => [ 'base' => '<p> The Account Takeover Insights (ATI) model training metric details. </p>', 'refs' => [ 'TrainingMetricsV2$ati' => '<p> The Account Takeover Insights (ATI) model training metric details. </p>', ], ], 'AccessDeniedException' => [ 'base' => '<p>An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your account.</p>', 'refs' => [], ], 'AggregatedLogOddsMetric' => [ 'base' => '<p>The log odds metric details.</p> <p>Account Takeover Insights (ATI) model uses event variables from the login data you provide to continuously calculate a set of variables (aggregated variables) based on historical events. For example, your ATI model might calculate the number of times an user has logged in using the same IP address. In this case, event variables used to derive the aggregated variables are <code>IP address</code> and <code>user</code>.</p>', 'refs' => [ 'ListOfAggregatedLogOddsMetrics$member' => NULL, ], ], 'AggregatedVariablesImpactExplanation' => [ 'base' => '<p> The details of the impact of aggregated variables on the prediction score. </p> <p>Account Takeover Insights (ATI) model uses the login data you provide to continuously calculate a set of variables (aggregated variables) based on historical events. For example, the model might calculate the number of times an user has logged in using the same IP address. In this case, event variables used to derive the aggregated variables are <code>IP address</code> and <code>user</code>.</p>', 'refs' => [ 'ListOfAggregatedVariablesImpactExplanations$member' => NULL, ], ], 'AggregatedVariablesImportanceMetrics' => [ 'base' => '<p>The details of the relative importance of the aggregated variables.</p> <p>Account Takeover Insights (ATI) model uses event variables from the login data you provide to continuously calculate a set of variables (aggregated variables) based on historical events. For example, your ATI model might calculate the number of times an user has logged in using the same IP address. In this case, event variables used to derive the aggregated variables are <code>IP address</code> and <code>user</code>.</p>', 'refs' => [ 'TrainingResultV2$aggregatedVariablesImportanceMetrics' => '<p> The variable importance metrics of the aggregated variables. </p> <p>Account Takeover Insights (ATI) model uses event variables from the login data you provide to continuously calculate a set of variables (aggregated variables) based on historical events. For example, your ATI model might calculate the number of times an user has logged in using the same IP address. In this case, event variables used to derive the aggregated variables are <code>IP address</code> and <code>user</code>.</p>', ], ], 'AllowDenyList' => [ 'base' => '<p> The metadata of a list. </p>', 'refs' => [ 'AllowDenyLists$member' => NULL, ], ], 'AllowDenyLists' => [ 'base' => NULL, 'refs' => [ 'GetListsMetadataResult$lists' => '<p> The metadata of the specified list or all lists under the account. </p>', ], ], 'AsyncJobStatus' => [ 'base' => NULL, 'refs' => [ 'BatchImport$status' => '<p>The status of the batch import job.</p>', 'BatchPrediction$status' => '<p>The batch prediction status.</p>', 'GetDeleteEventsByEventTypeStatusResult$eventsDeletionStatus' => '<p>The deletion status.</p>', ], ], 'BatchCreateVariableError' => [ 'base' => '<p>Provides the error of the batch create variable API.</p>', 'refs' => [ 'BatchCreateVariableErrorList$member' => NULL, ], ], 'BatchCreateVariableErrorList' => [ 'base' => NULL, 'refs' => [ 'BatchCreateVariableResult$errors' => '<p>Provides the errors for the <code>BatchCreateVariable</code> request.</p>', ], ], 'BatchCreateVariableRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchCreateVariableResult' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetVariableError' => [ 'base' => '<p>Provides the error of the batch get variable API.</p>', 'refs' => [ 'BatchGetVariableErrorList$member' => NULL, ], ], 'BatchGetVariableErrorList' => [ 'base' => NULL, 'refs' => [ 'BatchGetVariableResult$errors' => '<p>The errors from the request.</p>', ], ], 'BatchGetVariableRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetVariableResult' => [ 'base' => NULL, 'refs' => [], ], 'BatchImport' => [ 'base' => '<p>The batch import job details.</p>', 'refs' => [ 'BatchImportList$member' => NULL, ], ], 'BatchImportList' => [ 'base' => NULL, 'refs' => [ 'GetBatchImportJobsResult$batchImports' => '<p>An array containing the details of each batch import job.</p>', ], ], 'BatchPrediction' => [ 'base' => '<p>The batch prediction details.</p>', 'refs' => [ 'BatchPredictionList$member' => NULL, ], ], 'BatchPredictionList' => [ 'base' => NULL, 'refs' => [ 'GetBatchPredictionJobsResult$batchPredictions' => '<p>An array containing the details of each batch prediction job.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'EvaluatedExternalModel$useEventVariables' => '<p> Indicates whether event variables were used to generate predictions. </p>', 'EvaluatedRule$evaluated' => '<p> Indicates whether the rule was evaluated. </p>', 'EvaluatedRule$matched' => '<p> Indicates whether the rule matched. </p>', 'EventOrchestration$eventBridgeEnabled' => '<p>Specifies if event orchestration is enabled through Amazon EventBridge.</p>', ], ], 'CancelBatchImportJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CancelBatchImportJobResult' => [ 'base' => NULL, 'refs' => [], ], 'CancelBatchPredictionJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CancelBatchPredictionJobResult' => [ 'base' => NULL, 'refs' => [], ], 'ConflictException' => [ 'base' => '<p>An exception indicating there was a conflict during a delete operation.</p>', 'refs' => [], ], 'CreateBatchImportJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateBatchImportJobResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateBatchPredictionJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateBatchPredictionJobResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateDetectorVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDetectorVersionResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateListRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateListResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateModelRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateModelResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateModelVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateModelVersionResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateRuleResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateVariableRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateVariableResult' => [ 'base' => NULL, 'refs' => [], ], 'CsvIndexToVariableMap' => [ 'base' => NULL, 'refs' => [ 'ModelOutputConfiguration$csvIndexToVariableMap' => '<p>A map of CSV index values in the SageMaker response to the Amazon Fraud Detector variables. </p>', ], ], 'DataSource' => [ 'base' => NULL, 'refs' => [ 'CreateVariableRequest$dataSource' => '<p>The source of the data.</p>', 'Variable$dataSource' => '<p>The data source of the variable.</p>', ], ], 'DataType' => [ 'base' => NULL, 'refs' => [ 'CreateVariableRequest$dataType' => '<p>The data type of the variable.</p>', 'Variable$dataType' => '<p>The data type of the variable. For more information see <a href="https://docs.aws.amazon.com/frauddetector/latest/ug/create-a-variable.html#variable-types">Variable types</a>.</p>', ], ], 'DataValidationMetrics' => [ 'base' => '<p>The model training data validation metrics.</p>', 'refs' => [ 'TrainingResult$dataValidationMetrics' => '<p>The validation metrics.</p>', 'TrainingResultV2$dataValidationMetrics' => NULL, ], ], 'DeleteAuditHistory' => [ 'base' => NULL, 'refs' => [ 'DeleteEventRequest$deleteAuditHistory' => '<p>Specifies whether or not to delete any predictions associated with the event. If set to <code>True</code>, </p>', ], ], 'DeleteBatchImportJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBatchImportJobResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBatchPredictionJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBatchPredictionJobResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDetectorRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDetectorResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDetectorVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDetectorVersionResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEntityTypeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEntityTypeResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEventRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEventResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEventTypeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEventTypeResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEventsByEventTypeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEventsByEventTypeResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteExternalModelRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteExternalModelResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLabelRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLabelResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteListRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteListResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteModelRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteModelResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteModelVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteModelVersionResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteOutcomeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteOutcomeResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRuleResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVariableRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVariableResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDetectorRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDetectorResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeModelVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeModelVersionsResult' => [ 'base' => NULL, 'refs' => [], ], 'Detector' => [ 'base' => '<p>The detector.</p>', 'refs' => [ 'DetectorList$member' => NULL, ], ], 'DetectorList' => [ 'base' => NULL, 'refs' => [ 'GetDetectorsResult$detectors' => '<p>The detectors.</p>', ], ], 'DetectorVersionMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeDetectorRequest$maxResults' => '<p>The maximum number of results to return for the request.</p>', ], ], 'DetectorVersionStatus' => [ 'base' => NULL, 'refs' => [ 'CreateDetectorVersionResult$status' => '<p>The status of the detector version.</p>', 'DetectorVersionSummary$status' => '<p>The detector version status. </p>', 'GetDetectorVersionResult$status' => '<p>The status of the detector version.</p>', 'UpdateDetectorVersionStatusRequest$status' => '<p>The new status.</p> <p>The only supported values are <code>ACTIVE</code> and <code>INACTIVE</code> </p>', ], ], 'DetectorVersionSummary' => [ 'base' => '<p>The summary of the detector version.</p>', 'refs' => [ 'DetectorVersionSummaryList$member' => NULL, ], ], 'DetectorVersionSummaryList' => [ 'base' => NULL, 'refs' => [ 'DescribeDetectorResult$detectorVersionSummaries' => '<p>The status and description for each detector version.</p>', ], ], 'DetectorsMaxResults' => [ 'base' => NULL, 'refs' => [ 'GetDetectorsRequest$maxResults' => '<p>The maximum number of objects to return for the request.</p>', ], ], 'Elements' => [ 'base' => NULL, 'refs' => [ 'ElementsList$member' => NULL, ], ], 'ElementsList' => [ 'base' => NULL, 'refs' => [ 'CreateListRequest$elements' => '<p> The names of the elements, if providing. You can also create an empty list and add elements later using the <a href="https://docs.aws.amazon.com/frauddetector/latest/api/API_Updatelist.html">UpdateList</a> API. </p>', 'GetListElementsResult$elements' => '<p> The list elements. </p>', 'UpdateListRequest$elements' => '<p> One or more list elements to add or replace. If you are providing the elements, make sure to specify the <code>updateMode</code> to use. </p> <p>If you are deleting all elements from the list, use <code>REPLACE</code> for the <code>updateMode</code> and provide an empty list (0 elements).</p>', ], ], 'Entity' => [ 'base' => '<p>The entity details. </p>', 'refs' => [ 'listOfEntities$member' => NULL, ], ], 'EntityType' => [ 'base' => '<p>The entity type details.</p>', 'refs' => [ 'entityTypeList$member' => NULL, ], ], 'EvaluatedExternalModel' => [ 'base' => '<p> The details of the external (Amazon Sagemaker) model evaluated for generating predictions. </p>', 'refs' => [ 'ListOfEvaluatedExternalModels$member' => NULL, ], ], 'EvaluatedModelVersion' => [ 'base' => '<p> The model version evaluated for generating prediction. </p>', 'refs' => [ 'ListOfEvaluatedModelVersions$member' => NULL, ], ], 'EvaluatedRule' => [ 'base' => '<p> The details of the rule used for evaluating variable values. </p>', 'refs' => [ 'EvaluatedRuleList$member' => NULL, ], ], 'EvaluatedRuleList' => [ 'base' => NULL, 'refs' => [ 'GetEventPredictionMetadataResult$rules' => '<p> List of rules associated with the detector version that were used for evaluating variable values. </p>', ], ], 'Event' => [ 'base' => '<p>The event details.</p>', 'refs' => [ 'GetEventResult$event' => '<p>The details of the event.</p>', ], ], 'EventAttributeMap' => [ 'base' => NULL, 'refs' => [ 'Event$eventVariables' => '<p>Names of the event type\'s variables you defined in Amazon Fraud Detector to represent data elements and their corresponding values for the event you are sending for evaluation.</p>', ], ], 'EventIngestion' => [ 'base' => NULL, 'refs' => [ 'EventType$eventIngestion' => '<p>If <code>Enabled</code>, Amazon Fraud Detector stores event data when you generate a prediction and uses that data to update calculated variables in near real-time. Amazon Fraud Detector uses this data, known as <code>INGESTED_EVENTS</code>, to train your model and improve fraud predictions.</p>', 'PutEventTypeRequest$eventIngestion' => '<p>Specifies if ingestion is enabled or disabled.</p>', ], ], 'EventOrchestration' => [ 'base' => '<p> The event orchestration status. </p>', 'refs' => [ 'EventType$eventOrchestration' => '<p>The event orchestration status. </p>', 'PutEventTypeRequest$eventOrchestration' => '<p>Enables or disables event orchestration. If enabled, you can send event predictions to select AWS services for downstream processing of the events.</p>', ], ], 'EventPredictionSummary' => [ 'base' => '<p> Information about the summary of an event prediction. </p>', 'refs' => [ 'ListOfEventPredictionSummaries$member' => NULL, ], ], 'EventPredictionsMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListEventPredictionsRequest$maxResults' => '<p> The maximum number of predictions to return for the request. </p>', ], ], 'EventType' => [ 'base' => '<p>The event type details.</p>', 'refs' => [ 'eventTypeList$member' => NULL, ], ], 'EventVariableMap' => [ 'base' => NULL, 'refs' => [ 'GetEventPredictionRequest$eventVariables' => '<p>Names of the event type\'s variables you defined in Amazon Fraud Detector to represent data elements and their corresponding values for the event you are sending for evaluation.</p> <important> <p>You must provide at least one eventVariable</p> </important> <p>To ensure most accurate fraud prediction and to simplify your data preparation, Amazon Fraud Detector will replace all missing variables or values as follows:</p> <p> <b>For Amazon Fraud Detector trained models:</b> </p> <p>If a null value is provided explicitly for a variable or if a variable is missing, model will replace the null value or the missing variable (no variable name in the eventVariables map) with calculated default mean/medians for numeric variables and with special values for categorical variables.</p> <p> <b>For imported SageMaker models:</b> </p> <p>If a null value is provided explicitly for a variable, the model and rules will use “null” as the value. If a variable is not provided (no variable name in the eventVariables map), model and rules will use the default value that is provided for the variable. </p>', 'SendEventRequest$eventVariables' => '<p>Names of the event type\'s variables you defined in Amazon Fraud Detector to represent data elements and their corresponding values for the event you are sending for evaluation.</p>', ], ], 'EventVariableSummary' => [ 'base' => '<p> Information about the summary of an event variable that was evaluated for generating prediction. </p>', 'refs' => [ 'ListOfEventVariableSummaries$member' => NULL, ], ], 'ExternalEventsDetail' => [ 'base' => '<p>Details for the external events data used for model version training.</p>', 'refs' => [ 'CreateModelVersionRequest$externalEventsDetail' => '<p>Details of the external events data used for model version training. Required if <code>trainingDataSource</code> is <code>EXTERNAL_EVENTS</code>.</p>', 'GetModelVersionResult$externalEventsDetail' => '<p>The details of the external events data used for training the model version. This will be populated if the <code>trainingDataSource</code> is <code>EXTERNAL_EVENTS</code> </p>', 'ModelVersionDetail$externalEventsDetail' => '<p>The external events data details. This will be populated if the <code>trainingDataSource</code> for the model version is specified as <code>EXTERNAL_EVENTS</code>.</p>', 'UpdateModelVersionRequest$externalEventsDetail' => '<p>The details of the external events data used for training the model version. Required if <code>trainingDataSource</code> is <code>EXTERNAL_EVENTS</code>.</p>', ], ], 'ExternalModel' => [ 'base' => '<p>The Amazon SageMaker model.</p>', 'refs' => [ 'ExternalModelList$member' => NULL, ], ], 'ExternalModelEndpointDataBlobMap' => [ 'base' => NULL, 'refs' => [ 'GetEventPredictionRequest$externalModelEndpointDataBlobs' => '<p>The Amazon SageMaker model endpoint input data blobs.</p>', ], ], 'ExternalModelList' => [ 'base' => NULL, 'refs' => [ 'GetExternalModelsResult$externalModels' => '<p>Gets the Amazon SageMaker models.</p>', ], ], 'ExternalModelOutputs' => [ 'base' => '<p>The fraud prediction scores from Amazon SageMaker model.</p>', 'refs' => [ 'ListOfExternalModelOutputs$member' => NULL, ], ], 'ExternalModelPredictionMap' => [ 'base' => NULL, 'refs' => [ 'ExternalModelOutputs$outputs' => '<p>The fraud prediction scores from Amazon SageMaker model.</p>', ], ], 'ExternalModelSummary' => [ 'base' => '<p>The Amazon SageMaker model.</p>', 'refs' => [ 'ExternalModelOutputs$externalModel' => '<p>The Amazon SageMaker model.</p>', ], ], 'ExternalModelsMaxResults' => [ 'base' => NULL, 'refs' => [ 'GetExternalModelsRequest$maxResults' => '<p>The maximum number of objects to return for the request.</p>', ], ], 'FieldValidationMessage' => [ 'base' => '<p>The message details.</p>', 'refs' => [ 'fieldValidationMessageList$member' => NULL, ], ], 'FileValidationMessage' => [ 'base' => '<p>The message details.</p>', 'refs' => [ 'fileValidationMessageList$member' => NULL, ], ], 'FilterCondition' => [ 'base' => '<p> A conditional statement for filtering a list of past predictions. </p>', 'refs' => [ 'ListEventPredictionsRequest$eventId' => '<p> The event ID. </p>', 'ListEventPredictionsRequest$eventType' => '<p> The event type associated with the detector. </p>', 'ListEventPredictionsRequest$detectorId' => '<p> The detector ID. </p>', 'ListEventPredictionsRequest$detectorVersionId' => '<p> The detector version ID. </p>', ], ], 'GetBatchImportJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetBatchImportJobsResult' => [ 'base' => NULL, 'refs' => [], ], 'GetBatchPredictionJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetBatchPredictionJobsResult' => [ 'base' => NULL, 'refs' => [], ], 'GetDeleteEventsByEventTypeStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDeleteEventsByEventTypeStatusResult' => [ 'base' => NULL, 'refs' => [], ], 'GetDetectorVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDetectorVersionResult' => [ 'base' => NULL, 'refs' => [], ], 'GetDetectorsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDetectorsResult' => [ 'base' => NULL, 'refs' => [], ], 'GetEntityTypesRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetEntityTypesResult' => [ 'base' => NULL, 'refs' => [], ], 'GetEventPredictionMetadataRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetEventPredictionMetadataResult' => [ 'base' => NULL, 'refs' => [], ], 'GetEventPredictionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetEventPredictionResult' => [ 'base' => NULL, 'refs' => [], ], 'GetEventRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetEventResult' => [ 'base' => NULL, 'refs' => [], ], 'GetEventTypesRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetEventTypesResult' => [ 'base' => NULL, 'refs' => [], ], 'GetExternalModelsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetExternalModelsResult' => [ 'base' => NULL, 'refs' => [], ], 'GetKMSEncryptionKeyResult' => [ 'base' => NULL, 'refs' => [], ], 'GetLabelsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetLabelsResult' => [ 'base' => NULL, 'refs' => [], ], 'GetListElementsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetListElementsResult' => [ 'base' => NULL, 'refs' => [], ], 'GetListsMetadataRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetListsMetadataResult' => [ 'base' => NULL, 'refs' => [], ], 'GetModelVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetModelVersionResult' => [ 'base' => NULL, 'refs' => [], ], 'GetModelsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetModelsResult' => [ 'base' => NULL, 'refs' => [], ], 'GetOutcomesRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetOutcomesResult' => [ 'base' => NULL, 'refs' => [], ], 'GetRulesRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetRulesResult' => [ 'base' => NULL, 'refs' => [], ], 'GetVariablesRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetVariablesResult' => [ 'base' => NULL, 'refs' => [], ], 'IngestedEventStatistics' => [ 'base' => '<p>Data about the stored events.</p>', 'refs' => [ 'EventType$ingestedEventStatistics' => '<p>Data about the stored events.</p>', ], ], 'IngestedEventsDetail' => [ 'base' => '<p>The details of the ingested event.</p>', 'refs' => [ 'CreateModelVersionRequest$ingestedEventsDetail' => '<p>Details of the ingested events data used for model version training. Required if <code>trainingDataSource</code> is <code>INGESTED_EVENTS</code>.</p>', 'GetModelVersionResult$ingestedEventsDetail' => '<p>The details of the ingested events data used for training the model version. This will be populated if the <code>trainingDataSource</code> is <code>INGESTED_EVENTS</code>.</p>', 'ModelVersionDetail$ingestedEventsDetail' => '<p>The ingested events data details. This will be populated if the <code>trainingDataSource</code> for the model version is specified as <code>INGESTED_EVENTS</code>.</p>', 'UpdateModelVersionRequest$ingestedEventsDetail' => '<p>The details of the ingested event used for training the model version. Required if your <code>trainingDataSource</code> is <code>INGESTED_EVENTS</code>.</p>', ], ], 'IngestedEventsTimeWindow' => [ 'base' => '<p>The start and stop time of the ingested events.</p>', 'refs' => [ 'IngestedEventsDetail$ingestedEventsTimeWindow' => '<p>The start and stop time of the ingested events.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'BatchImport$processedRecordsCount' => '<p>The number of records processed by batch import job.</p>', 'BatchImport$failedRecordsCount' => '<p>The number of records that failed to import. </p>', 'BatchImport$totalRecordsCount' => '<p>The total number of records in the batch import job.</p>', 'BatchPrediction$processedRecordsCount' => '<p>The number of records processed by the batch prediction job.</p>', 'BatchPrediction$totalRecordsCount' => '<p>The total number of records in the batch prediction job.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>An exception indicating an internal server error.</p>', 'refs' => [], ], 'JsonKeyToVariableMap' => [ 'base' => NULL, 'refs' => [ 'ModelOutputConfiguration$jsonKeyToVariableMap' => '<p>A map of JSON keys in response from SageMaker to the Amazon Fraud Detector variables. </p>', ], ], 'KMSKey' => [ 'base' => '<p>The KMS key details.</p>', 'refs' => [ 'GetKMSEncryptionKeyResult$kmsKey' => '<p>The KMS encryption key.</p>', ], ], 'KmsEncryptionKeyArn' => [ 'base' => NULL, 'refs' => [ 'KMSKey$kmsEncryptionKeyArn' => '<p>The encryption key ARN.</p>', 'PutKMSEncryptionKeyRequest$kmsEncryptionKeyArn' => '<p>The KMS encryption key ARN.</p> <p>The KMS key must be single-Region key. Amazon Fraud Detector does not support multi-Region KMS key.</p>', ], ], 'Label' => [ 'base' => '<p>The label details.</p>', 'refs' => [ 'labelList$member' => NULL, ], ], 'LabelSchema' => [ 'base' => '<p>The label schema.</p>', 'refs' => [ 'TrainingDataSchema$labelSchema' => NULL, ], ], 'Language' => [ 'base' => NULL, 'refs' => [ 'CreateRuleRequest$language' => '<p>The language of the rule.</p>', 'RuleDetail$language' => '<p>The rule language.</p>', 'UpdateRuleVersionRequest$language' => '<p>The language.</p>', ], ], 'ListEventPredictionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListEventPredictionsResult' => [ 'base' => NULL, 'refs' => [], ], 'ListOfAggregatedLogOddsMetrics' => [ 'base' => NULL, 'refs' => [ 'AggregatedVariablesImportanceMetrics$logOddsMetrics' => '<p> List of variables\' metrics. </p>', ], ], 'ListOfAggregatedVariablesImpactExplanations' => [ 'base' => NULL, 'refs' => [ 'PredictionExplanations$aggregatedVariablesImpactExplanations' => '<p> The details of the aggregated variables impact on the prediction score. </p> <p>Account Takeover Insights (ATI) model uses event variables from the login data you provide to continuously calculate a set of variables (aggregated variables) based on historical events. For example, your ATI model might calculate the number of times an user has logged in using the same IP address. In this case, event variables used to derive the aggregated variables are <code>IP address</code> and <code>user</code>.</p>', ], ], 'ListOfEvaluatedExternalModels' => [ 'base' => NULL, 'refs' => [ 'GetEventPredictionMetadataResult$evaluatedExternalModels' => '<p> External (Amazon SageMaker) models that were evaluated for generating predictions. </p>', ], ], 'ListOfEvaluatedModelVersions' => [ 'base' => NULL, 'refs' => [ 'GetEventPredictionMetadataResult$evaluatedModelVersions' => '<p> Model versions that were evaluated for generating predictions. </p>', ], ], 'ListOfEventPredictionSummaries' => [ 'base' => NULL, 'refs' => [ 'ListEventPredictionsResult$eventPredictionSummaries' => '<p> The summary of the past predictions. </p>', ], ], 'ListOfEventVariableSummaries' => [ 'base' => NULL, 'refs' => [ 'GetEventPredictionMetadataResult$eventVariables' => '<p> A list of event variables that influenced the prediction scores. </p>', ], ], 'ListOfExternalModelOutputs' => [ 'base' => NULL, 'refs' => [ 'GetEventPredictionResult$externalModelOutputs' => '<p>The model scores for Amazon SageMaker models.</p>', ], ], 'ListOfLogOddsMetrics' => [ 'base' => NULL, 'refs' => [ 'VariableImportanceMetrics$logOddsMetrics' => '<p>List of variable metrics.</p>', ], ], 'ListOfModelScores' => [ 'base' => NULL, 'refs' => [ 'GetEventPredictionResult$modelScores' => '<p>The model scores. Amazon Fraud Detector generates model scores between 0 and 1000, where 0 is low fraud risk and 1000 is high fraud risk. Model scores are directly related to the false positive rate (FPR). For example, a score of 600 corresponds to an estimated 10% false positive rate whereas a score of 900 corresponds to an estimated 2% false positive rate.</p>', ], ], 'ListOfModelVersionEvaluations' => [ 'base' => NULL, 'refs' => [ 'EvaluatedModelVersion$evaluations' => '<p> Evaluations generated for the model version. </p>', ], ], 'ListOfModelVersions' => [ 'base' => NULL, 'refs' => [ 'CreateDetectorVersionRequest$modelVersions' => '<p>The model versions to include in the detector version.</p>', 'GetDetectorVersionResult$modelVersions' => '<p>The model versions included in the detector version. </p>', 'UpdateDetectorVersionRequest$modelVersions' => '<p>The model versions to include in the detector version.</p>', ], ], 'ListOfRuleResults' => [ 'base' => NULL, 'refs' => [ 'GetEventPredictionResult$ruleResults' => '<p>The results from the rules.</p>', ], ], 'ListOfStrings' => [ 'base' => NULL, 'refs' => [ 'AggregatedLogOddsMetric$variableNames' => '<p> The names of all the variables. </p>', 'AggregatedVariablesImpactExplanation$eventVariableNames' => '<p> The names of all the event variables that were used to derive the aggregated variables. </p>', 'CreateDetectorVersionRequest$externalModelEndpoints' => '<p>The Amazon Sagemaker model endpoints to include in the detector version.</p>', 'EvaluatedRule$outcomes' => '<p> The rule outcome. </p>', 'EventType$eventVariables' => '<p>The event type event variables.</p>', 'EventType$labels' => '<p>The event type labels.</p>', 'GetDetectorVersionResult$externalModelEndpoints' => '<p>The Amazon SageMaker model endpoints included in the detector version.</p>', 'GetEventPredictionMetadataResult$outcomes' => '<p> The outcomes of the matched rule, based on the rule execution mode. </p>', 'PutEventTypeRequest$labels' => '<p>The event type labels.</p>', 'RuleResult$outcomes' => '<p>The outcomes of the matched rule, based on the rule execution mode.</p>', 'TrainingDataSchema$modelVariables' => '<p>The training data schema variables.</p>', 'UpdateDetectorVersionRequest$externalModelEndpoints' => '<p>The Amazon SageMaker model endpoints to include in the detector version.</p>', 'labelMapper$value' => NULL, ], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResult' => [ 'base' => NULL, 'refs' => [], ], 'ListUpdateMode' => [ 'base' => NULL, 'refs' => [ 'UpdateListRequest$updateMode' => '<p> The update mode (type). </p> <ul> <li> <p>Use <code>APPEND</code> if you are adding elements to the list.</p> </li> <li> <p>Use <code>REPLACE</code> if you replacing existing elements in the list.</p> </li> <li> <p>Use <code>REMOVE</code> if you are removing elements from the list.</p> </li> </ul>', ], ], 'ListsElementsMaxResults' => [ 'base' => NULL, 'refs' => [ 'GetListElementsRequest$maxResults' => '<p> The maximum number of objects to return for the request. </p>', ], ], 'ListsMetadataMaxResults' => [ 'base' => NULL, 'refs' => [ 'GetListsMetadataRequest$maxResults' => '<p> The maximum number of objects to return for the request. </p>', ], ], 'LogOddsMetric' => [ 'base' => '<p>The log odds metric details.</p>', 'refs' => [ 'ListOfLogOddsMetrics$member' => NULL, ], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'IngestedEventStatistics$numberOfEvents' => '<p>The number of stored events.</p>', 'IngestedEventStatistics$eventDataSizeInBytes' => '<p>The total size of the stored events.</p>', ], ], 'MapOfStrings' => [ 'base' => NULL, 'refs' => [ 'EvaluatedExternalModel$inputVariables' => '<p> Input variables use for generating predictions. </p>', 'EvaluatedExternalModel$outputVariables' => '<p> Output variables. </p>', ], ], 'MetricDataPoint' => [ 'base' => '<p>Model performance metrics data points.</p>', 'refs' => [ 'metricDataPointsList$member' => NULL, ], ], 'Model' => [ 'base' => '<p>The model.</p>', 'refs' => [ 'modelList$member' => NULL, ], ], 'ModelEndpointDataBlob' => [ 'base' => '<p>A pre-formed Amazon SageMaker model input you can include if your detector version includes an imported Amazon SageMaker model endpoint with pass-through input configuration.</p>', 'refs' => [ 'ExternalModelEndpointDataBlobMap$value' => NULL, ], ], 'ModelEndpointStatus' => [ 'base' => NULL, 'refs' => [ 'ExternalModel$modelEndpointStatus' => '<p>The Amazon Fraud Detector status for the external model endpoint</p>', 'PutExternalModelRequest$modelEndpointStatus' => '<p>The model endpoint’s status in Amazon Fraud Detector.</p>', ], ], 'ModelInputConfiguration' => [ 'base' => '<p>The Amazon SageMaker model input configuration.</p>', 'refs' => [ 'ExternalModel$inputConfiguration' => '<p>The input configuration.</p>', 'PutExternalModelRequest$inputConfiguration' => '<p>The model endpoint input configuration.</p>', ], ], 'ModelInputDataFormat' => [ 'base' => NULL, 'refs' => [ 'ModelInputConfiguration$format' => '<p> The format of the model input configuration. The format differs depending on if it is passed through to SageMaker or constructed by Amazon Fraud Detector.</p>', ], ], 'ModelOutputConfiguration' => [ 'base' => '<p>Provides the Amazon Sagemaker model output configuration.</p>', 'refs' => [ 'ExternalModel$outputConfiguration' => '<p>The output configuration.</p>', 'PutExternalModelRequest$outputConfiguration' => '<p>The model endpoint output configuration.</p>', ], ], 'ModelOutputDataFormat' => [ 'base' => NULL, 'refs' => [ 'ModelOutputConfiguration$format' => '<p>The format of the model output configuration.</p>', ], ], 'ModelPredictionMap' => [ 'base' => NULL, 'refs' => [ 'ModelScores$scores' => '<p>The model\'s fraud prediction scores.</p>', ], ], 'ModelScores' => [ 'base' => '<p>The fraud prediction scores.</p>', 'refs' => [ 'ListOfModelScores$member' => NULL, ], ], 'ModelSource' => [ 'base' => NULL, 'refs' => [ 'ExternalModel$modelSource' => '<p>The source of the model.</p>', 'ExternalModelSummary$modelSource' => '<p>The source of the model.</p>', 'PutExternalModelRequest$modelSource' => '<p>The source of the model.</p>', ], ], 'ModelTypeEnum' => [ 'base' => NULL, 'refs' => [ 'CreateModelRequest$modelType' => '<p>The model type. </p>', 'CreateModelVersionRequest$modelType' => '<p>The model type.</p>', 'CreateModelVersionResult$modelType' => '<p>The model type.</p>', 'DeleteModelRequest$modelType' => '<p>The model type of the model to delete.</p>', 'DeleteModelVersionRequest$modelType' => '<p>The model type of the model version to delete.</p>', 'DescribeModelVersionsRequest$modelType' => '<p>The model type.</p>', 'GetModelVersionRequest$modelType' => '<p>The model type.</p>', 'GetModelVersionResult$modelType' => '<p>The model type.</p>', 'GetModelsRequest$modelType' => '<p>The model type.</p>', 'Model$modelType' => '<p>The model type.</p>', 'ModelVersion$modelType' => '<p>The model type.</p>', 'ModelVersionDetail$modelType' => '<p>The model type.</p>', 'UpdateModelRequest$modelType' => '<p>The model type.</p>', 'UpdateModelVersionRequest$modelType' => '<p>The model type.</p>', 'UpdateModelVersionResult$modelType' => '<p>The model type.</p>', 'UpdateModelVersionStatusRequest$modelType' => '<p>The model type.</p>', ], ], 'ModelVersion' => [ 'base' => '<p>The model version.</p>', 'refs' => [ 'ListOfModelVersions$member' => NULL, 'ModelScores$modelVersion' => '<p>The model version.</p>', ], ], 'ModelVersionDetail' => [ 'base' => '<p>The details of the model version.</p>', 'refs' => [ 'modelVersionDetailList$member' => NULL, ], ], 'ModelVersionEvaluation' => [ 'base' => '<p> The model version evalutions. </p>', 'refs' => [ 'ListOfModelVersionEvaluations$member' => NULL, ], ], 'ModelVersionStatus' => [ 'base' => NULL, 'refs' => [ 'UpdateModelVersionStatusRequest$status' => '<p>The model version status.</p>', ], ], 'NameList' => [ 'base' => NULL, 'refs' => [ 'BatchGetVariableRequest$names' => '<p>The list of variable names to get.</p>', ], ], 'NonEmptyListOfStrings' => [ 'base' => NULL, 'refs' => [ 'CreateRuleRequest$outcomes' => '<p>The outcome or outcomes returned when the rule expression matches.</p>', 'EventType$entityTypes' => '<p>The event type entity types.</p>', 'PutEventTypeRequest$eventVariables' => '<p>The event type variables.</p>', 'PutEventTypeRequest$entityTypes' => '<p>The entity type for the event type. Example entity types: customer, merchant, account.</p>', 'RuleDetail$outcomes' => '<p>The rule outcomes.</p>', 'UpdateRuleVersionRequest$outcomes' => '<p>The outcomes.</p>', ], ], 'OFIMetricDataPoint' => [ 'base' => '<p> The Online Fraud Insights (OFI) model performance metrics data points. </p>', 'refs' => [ 'OFIMetricDataPointsList$member' => NULL, ], ], 'OFIMetricDataPointsList' => [ 'base' => NULL, 'refs' => [ 'OFITrainingMetricsValue$metricDataPoints' => '<p> The model\'s performance metrics data points. </p>', ], ], 'OFIModelPerformance' => [ 'base' => '<p> The Online Fraud Insights (OFI) model performance score. </p>', 'refs' => [ 'OFITrainingMetricsValue$modelPerformance' => '<p> The model\'s overall performance score. </p>', ], ], 'OFITrainingMetricsValue' => [ 'base' => '<p> The Online Fraud Insights (OFI) model training metric details. </p>', 'refs' => [ 'TrainingMetricsV2$ofi' => '<p> The Online Fraud Insights (OFI) model training metric details. </p>', ], ], 'Outcome' => [ 'base' => '<p>The outcome.</p>', 'refs' => [ 'OutcomeList$member' => NULL, ], ], 'OutcomeList' => [ 'base' => NULL, 'refs' => [ 'GetOutcomesResult$outcomes' => '<p>The outcomes. </p>', ], ], 'OutcomesMaxResults' => [ 'base' => NULL, 'refs' => [ 'GetOutcomesRequest$maxResults' => '<p>The maximum number of objects to return for the request. </p>', ], ], 'PredictionExplanations' => [ 'base' => '<p> The prediction explanations that provide insight into how each event variable impacted the model version\'s fraud prediction score. </p>', 'refs' => [ 'ModelVersionEvaluation$predictionExplanations' => '<p> The prediction explanations generated for the model version. </p>', ], ], 'PredictionTimeRange' => [ 'base' => '<p> The time period for when the predictions were generated. </p>', 'refs' => [ 'ListEventPredictionsRequest$predictionTimeRange' => '<p> The time period for when the predictions were generated. </p>', ], ], 'PutDetectorRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutDetectorResult' => [ 'base' => NULL, 'refs' => [], ], 'PutEntityTypeRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutEntityTypeResult' => [ 'base' => NULL, 'refs' => [], ], 'PutEventTypeRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutEventTypeResult' => [ 'base' => NULL, 'refs' => [], ], 'PutExternalModelRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutExternalModelResult' => [ 'base' => NULL, 'refs' => [], ], 'PutKMSEncryptionKeyRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutKMSEncryptionKeyResult' => [ 'base' => NULL, 'refs' => [], ], 'PutLabelRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutLabelResult' => [ 'base' => NULL, 'refs' => [], ], 'PutOutcomeRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutOutcomeResult' => [ 'base' => NULL, 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>An exception indicating the specified resource was not found.</p>', 'refs' => [], ], 'ResourceUnavailableException' => [ 'base' => '<p>An exception indicating that the attached customer-owned (external) model threw an exception when Amazon Fraud Detector invoked the model.</p>', 'refs' => [], ], 'Rule' => [ 'base' => '<p>A rule.</p>', 'refs' => [ 'CreateRuleResult$rule' => '<p>The created rule.</p>', 'DeleteRuleRequest$rule' => NULL, 'RuleList$member' => NULL, 'UpdateRuleMetadataRequest$rule' => '<p>The rule to update.</p>', 'UpdateRuleVersionRequest$rule' => '<p>The rule to update.</p>', 'UpdateRuleVersionResult$rule' => '<p>The new rule version that was created.</p>', ], ], 'RuleDetail' => [ 'base' => '<p>The details of the rule.</p>', 'refs' => [ 'RuleDetailList$member' => NULL, ], ], 'RuleDetailList' => [ 'base' => NULL, 'refs' => [ 'GetRulesResult$ruleDetails' => '<p>The details of the requested rule.</p>', ], ], 'RuleExecutionMode' => [ 'base' => NULL, 'refs' => [ 'CreateDetectorVersionRequest$ruleExecutionMode' => '<p>The rule execution mode for the rules included in the detector version.</p> <p>You can define and edit the rule mode at the detector version level, when it is in draft status.</p> <p>If you specify <code>FIRST_MATCHED</code>, Amazon Fraud Detector evaluates rules sequentially, first to last, stopping at the first matched rule. Amazon Fraud dectector then provides the outcomes for that single rule.</p> <p>If you specifiy <code>ALL_MATCHED</code>, Amazon Fraud Detector evaluates all rules and returns the outcomes for all matched rules. </p> <p>The default behavior is <code>FIRST_MATCHED</code>.</p>', 'GetDetectorVersionResult$ruleExecutionMode' => '<p>The execution mode of the rule in the dectector</p> <p> <code>FIRST_MATCHED</code> indicates that Amazon Fraud Detector evaluates rules sequentially, first to last, stopping at the first matched rule. Amazon Fraud dectector then provides the outcomes for that single rule.</p> <p> <code>ALL_MATCHED</code> indicates that Amazon Fraud Detector evaluates all rules and returns the outcomes for all matched rules. You can define and edit the rule mode at the detector version level, when it is in draft status.</p>', 'GetEventPredictionMetadataResult$ruleExecutionMode' => '<p> The execution mode of the rule used for evaluating variable values. </p>', 'UpdateDetectorVersionRequest$ruleExecutionMode' => '<p>The rule execution mode to add to the detector.</p> <p>If you specify <code>FIRST_MATCHED</code>, Amazon Fraud Detector evaluates rules sequentially, first to last, stopping at the first matched rule. Amazon Fraud dectector then provides the outcomes for that single rule.</p> <p>If you specifiy <code>ALL_MATCHED</code>, Amazon Fraud Detector evaluates all rules and returns the outcomes for all matched rules. You can define and edit the rule mode at the detector version level, when it is in draft status.</p> <p>The default behavior is <code>FIRST_MATCHED</code>.</p>', ], ], 'RuleList' => [ 'base' => NULL, 'refs' => [ 'CreateDetectorVersionRequest$rules' => '<p>The rules to include in the detector version.</p>', 'GetDetectorVersionResult$rules' => '<p>The rules included in the detector version.</p>', 'UpdateDetectorVersionRequest$rules' => '<p>The rules to include in the detector version.</p>', ], ], 'RuleResult' => [ 'base' => '<p>The rule results.</p>', 'refs' => [ 'ListOfRuleResults$member' => NULL, ], ], 'RulesMaxResults' => [ 'base' => NULL, 'refs' => [ 'GetRulesRequest$maxResults' => '<p>The maximum number of rules to return for the request.</p>', ], ], 'SendEventRequest' => [ 'base' => NULL, 'refs' => [], ], 'SendEventResult' => [ 'base' => NULL, 'refs' => [], ], 'TFIMetricDataPoint' => [ 'base' => '<p> The performance metrics data points for Transaction Fraud Insights (TFI) model. </p>', 'refs' => [ 'TFIMetricDataPointsList$member' => NULL, ], ], 'TFIMetricDataPointsList' => [ 'base' => NULL, 'refs' => [ 'TFITrainingMetricsValue$metricDataPoints' => '<p> The model\'s performance metrics data points. </p>', ], ], 'TFIModelPerformance' => [ 'base' => '<p> The Transaction Fraud Insights (TFI) model performance score. </p>', 'refs' => [ 'TFITrainingMetricsValue$modelPerformance' => '<p> The model performance score. </p>', ], ], 'TFITrainingMetricsValue' => [ 'base' => '<p> The Transaction Fraud Insights (TFI) model training metric details. </p>', 'refs' => [ 'TrainingMetricsV2$tfi' => '<p> The Transaction Fraud Insights (TFI) model training metric details. </p>', ], ], 'Tag' => [ 'base' => '<p>A key and value pair. </p>', 'refs' => [ 'tagList$member' => NULL, ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResult' => [ 'base' => NULL, 'refs' => [], ], 'TagsMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$maxResults' => '<p>The maximum number of objects to return for the request. </p>', ], ], 'ThrottlingException' => [ 'base' => '<p>An exception indicating a throttling error.</p>', 'refs' => [], ], 'TrainingDataSchema' => [ 'base' => '<p>The training data schema.</p>', 'refs' => [ 'CreateModelVersionRequest$trainingDataSchema' => '<p>The training data schema.</p>', 'GetModelVersionResult$trainingDataSchema' => '<p>The training data schema.</p>', 'ModelVersionDetail$trainingDataSchema' => '<p>The training data schema.</p>', ], ], 'TrainingDataSourceEnum' => [ 'base' => NULL, 'refs' => [ 'CreateModelVersionRequest$trainingDataSource' => '<p>The training data source location in Amazon S3. </p>', 'GetModelVersionResult$trainingDataSource' => '<p>The training data source.</p>', 'ModelVersionDetail$trainingDataSource' => '<p>The model version training data source.</p>', ], ], 'TrainingMetrics' => [ 'base' => '<p>The training metric details.</p>', 'refs' => [ 'TrainingResult$trainingMetrics' => '<p>The training metric details.</p>', ], ], 'TrainingMetricsV2' => [ 'base' => '<p> The training metrics details. </p>', 'refs' => [ 'TrainingResultV2$trainingMetricsV2' => '<p> The training metric details. </p>', ], ], 'TrainingResult' => [ 'base' => '<p>The training result details.</p>', 'refs' => [ 'ModelVersionDetail$trainingResult' => '<p>The training results.</p>', ], ], 'TrainingResultV2' => [ 'base' => '<p> The training result details. </p>', 'refs' => [ 'ModelVersionDetail$trainingResultV2' => '<p> The training result details. The details include the relative importance of the variables. </p>', ], ], 'UncertaintyRange' => [ 'base' => '<p> Range of area under curve (auc) expected from the model. A range greater than 0.1 indicates higher model uncertainity. A range is the difference between upper and lower bound of auc. </p>', 'refs' => [ 'OFIModelPerformance$uncertaintyRange' => '<p> Indicates the range of area under curve (auc) expected from the OFI model. A range greater than 0.1 indicates higher model uncertainity. </p>', 'TFIModelPerformance$uncertaintyRange' => '<p> Indicates the range of area under curve (auc) expected from the TFI model. A range greater than 0.1 indicates higher model uncertainity. </p>', ], ], 'UnlabeledEventsTreatment' => [ 'base' => NULL, 'refs' => [ 'LabelSchema$unlabeledEventsTreatment' => '<p>The action to take for unlabeled events.</p> <ul> <li> <p>Use <code>IGNORE</code> if you want the unlabeled events to be ignored. This is recommended when the majority of the events in the dataset are labeled.</p> </li> <li> <p>Use <code>FRAUD</code> if you want to categorize all unlabeled events as “Fraud”. This is recommended when most of the events in your dataset are fraudulent.</p> </li> <li> <p>Use <code>LEGIT</code> if you want to categorize all unlabeled events as “Legit”. This is recommended when most of the events in your dataset are legitimate.</p> </li> <li> <p>Use <code>AUTO</code> if you want Amazon Fraud Detector to decide how to use the unlabeled data. This is recommended when there is significant unlabeled events in the dataset.</p> </li> </ul> <p>By default, Amazon Fraud Detector ignores the unlabeled data.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDetectorVersionMetadataRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDetectorVersionMetadataResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDetectorVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDetectorVersionResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDetectorVersionStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDetectorVersionStatusResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEventLabelRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEventLabelResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateListRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateListResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateModelRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateModelResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateModelVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateModelVersionResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateModelVersionStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateModelVersionStatusResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRuleMetadataRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRuleMetadataResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRuleVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRuleVersionResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateVariableRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateVariableResult' => [ 'base' => NULL, 'refs' => [], ], 'UseEventVariables' => [ 'base' => NULL, 'refs' => [ 'ModelInputConfiguration$useEventVariables' => '<p>The event variables.</p>', ], ], 'ValidationException' => [ 'base' => '<p>An exception indicating a specified value is not allowed.</p>', 'refs' => [], ], 'Variable' => [ 'base' => '<p>The variable.</p>', 'refs' => [ 'VariableList$member' => NULL, ], ], 'VariableEntry' => [ 'base' => '<p>A variable in the list of variables for the batch create variable request.</p>', 'refs' => [ 'VariableEntryList$member' => NULL, ], ], 'VariableEntryList' => [ 'base' => NULL, 'refs' => [ 'BatchCreateVariableRequest$variableEntries' => '<p>The list of variables for the batch create variable request.</p>', ], ], 'VariableImpactExplanation' => [ 'base' => '<p> The details of the event variable\'s impact on the prediction score. </p>', 'refs' => [ 'listOfVariableImpactExplanations$member' => NULL, ], ], 'VariableImportanceMetrics' => [ 'base' => '<p>The variable importance metrics details.</p>', 'refs' => [ 'TrainingResult$variableImportanceMetrics' => '<p>The variable importance metrics.</p>', 'TrainingResultV2$variableImportanceMetrics' => NULL, ], ], 'VariableList' => [ 'base' => NULL, 'refs' => [ 'BatchGetVariableResult$variables' => '<p>The returned variables.</p>', 'GetVariablesResult$variables' => '<p>The names of the variables returned. </p>', ], ], 'VariablesMaxResults' => [ 'base' => NULL, 'refs' => [ 'GetVariablesRequest$maxResults' => '<p>The max size per page determined for the get variable request. </p>', ], ], 'attributeKey' => [ 'base' => NULL, 'refs' => [ 'EventAttributeMap$key' => NULL, ], ], 'attributeValue' => [ 'base' => NULL, 'refs' => [ 'EventAttributeMap$value' => NULL, ], ], 'batchImportsMaxPageSize' => [ 'base' => NULL, 'refs' => [ 'GetBatchImportJobsRequest$maxResults' => '<p>The maximum number of objects to return for request.</p>', ], ], 'batchPredictionsMaxPageSize' => [ 'base' => NULL, 'refs' => [ 'GetBatchPredictionJobsRequest$maxResults' => '<p>The maximum number of objects to return for the request.</p>', ], ], 'blob' => [ 'base' => NULL, 'refs' => [ 'ModelEndpointDataBlob$byteBuffer' => '<p>The byte buffer of the Amazon SageMaker model endpoint input data blob.</p>', ], ], 'contentType' => [ 'base' => NULL, 'refs' => [ 'ModelEndpointDataBlob$contentType' => '<p>The content type of the Amazon SageMaker model endpoint input data blob. </p>', ], ], 'description' => [ 'base' => NULL, 'refs' => [ 'AllowDenyList$description' => '<p> The description of the list. </p>', 'CreateDetectorVersionRequest$description' => '<p>The description of the detector version.</p>', 'CreateListRequest$description' => '<p> The description of the list. </p>', 'CreateModelRequest$description' => '<p>The model description. </p>', 'CreateRuleRequest$description' => '<p>The rule description.</p>', 'Detector$description' => '<p>The detector description.</p>', 'DetectorVersionSummary$description' => '<p>The detector version description. </p>', 'EntityType$description' => '<p>The entity type description.</p>', 'EventType$description' => '<p>The event type description.</p>', 'GetDetectorVersionResult$description' => '<p>The detector version description.</p>', 'Label$description' => '<p>The label description.</p>', 'Model$description' => '<p>The model description.</p>', 'Outcome$description' => '<p>The outcome description.</p>', 'PutDetectorRequest$description' => '<p>The description of the detector.</p>', 'PutEntityTypeRequest$description' => '<p>The description.</p>', 'PutEventTypeRequest$description' => '<p>The description of the event type.</p>', 'PutLabelRequest$description' => '<p>The label description.</p>', 'PutOutcomeRequest$description' => '<p>The outcome description.</p>', 'RuleDetail$description' => '<p>The rule description.</p>', 'UpdateDetectorVersionMetadataRequest$description' => '<p>The description.</p>', 'UpdateDetectorVersionRequest$description' => '<p>The detector version description. </p>', 'UpdateListRequest$description' => '<p> The new description. </p>', 'UpdateModelRequest$description' => '<p>The new model description.</p>', 'UpdateRuleMetadataRequest$description' => '<p>The rule description.</p>', 'UpdateRuleVersionRequest$description' => '<p>The description.</p>', ], ], 'entityRestrictedString' => [ 'base' => NULL, 'refs' => [ 'Entity$entityId' => '<p>The entity ID. If you do not know the <code>entityId</code>, you can pass <code>unknown</code>, which is areserved string literal.</p>', ], ], 'entityTypeList' => [ 'base' => NULL, 'refs' => [ 'GetEntityTypesResult$entityTypes' => '<p>An array of entity types.</p>', ], ], 'entityTypesMaxResults' => [ 'base' => NULL, 'refs' => [ 'GetEntityTypesRequest$maxResults' => '<p>The maximum number of objects to return for the request.</p>', ], ], 'eventTypeList' => [ 'base' => NULL, 'refs' => [ 'GetEventTypesResult$eventTypes' => '<p>An array of event types.</p>', ], ], 'eventTypesMaxResults' => [ 'base' => NULL, 'refs' => [ 'GetEventTypesRequest$maxResults' => '<p>The maximum number of objects to return for the request.</p>', ], ], 'fieldValidationMessageList' => [ 'base' => NULL, 'refs' => [ 'DataValidationMetrics$fieldLevelMessages' => '<p>The field-specific model training validation messages.</p>', ], ], 'fileValidationMessageList' => [ 'base' => NULL, 'refs' => [ 'DataValidationMetrics$fileLevelMessages' => '<p>The file-specific model training data validation messages.</p>', ], ], 'filterString' => [ 'base' => NULL, 'refs' => [ 'FilterCondition$value' => '<p> A statement containing a resource property and a value to specify filter condition. </p>', ], ], 'float' => [ 'base' => NULL, 'refs' => [ 'ATIMetricDataPoint$cr' => '<p> The challenge rate. This indicates the percentage of login events that the model recommends to challenge such as one-time password, multi-factor authentication, and investigations. </p>', 'ATIMetricDataPoint$adr' => '<p> The anomaly discovery rate. This metric quantifies the percentage of anomalies that can be detected by the model at the selected score threshold. A lower score threshold increases the percentage of anomalies captured by the model, but would also require challenging a larger percentage of login events, leading to a higher customer friction. </p>', 'ATIMetricDataPoint$threshold' => '<p> The model\'s threshold that specifies an acceptable fraud capture rate. For example, a threshold of 500 means any model score 500 or above is labeled as fraud. </p>', 'ATIMetricDataPoint$atodr' => '<p> The account takeover discovery rate. This metric quantifies the percentage of account compromise events that can be detected by the model at the selected score threshold. This metric is only available if 50 or more entities with at-least one labeled account takeover event is present in the ingested dataset. </p>', 'ATIModelPerformance$asi' => '<p> The anomaly separation index (ASI) score. This metric summarizes the overall ability of the model to separate anomalous activities from the normal behavior. Depending on the business, a large fraction of these anomalous activities can be malicious and correspond to the account takeover attacks. A model with no separability power will have the lowest possible ASI score of 0.5, whereas the a model with a high separability power will have the highest possible ASI score of 1.0 </p>', 'AggregatedLogOddsMetric$aggregatedVariablesImportance' => '<p> The relative importance of the variables in the list to the other event variable. </p>', 'AggregatedVariablesImpactExplanation$logOddsImpact' => '<p> The raw, uninterpreted value represented as log-odds of the fraud. These values are usually between -10 to +10, but range from -infinity to +infinity.</p> <ul> <li> <p>A positive value indicates that the variables drove the risk score up.</p> </li> <li> <p>A negative value indicates that the variables drove the risk score down.</p> </li> </ul>', 'LogOddsMetric$variableImportance' => '<p>The relative importance of the variable. For more information, see <a href="https://docs.aws.amazon.com/frauddetector/latest/ug/model-variable-importance.html">Model variable importance</a>.</p>', 'MetricDataPoint$fpr' => '<p>The false positive rate. This is the percentage of total legitimate events that are incorrectly predicted as fraud.</p>', 'MetricDataPoint$precision' => '<p>The percentage of fraud events correctly predicted as fraudulent as compared to all events predicted as fraudulent.</p>', 'MetricDataPoint$tpr' => '<p>The true positive rate. This is the percentage of total fraud the model detects. Also known as capture rate.</p>', 'MetricDataPoint$threshold' => '<p>The model threshold that specifies an acceptable fraud capture rate. For example, a threshold of 500 means any model score 500 or above is labeled as fraud.</p>', 'ModelPredictionMap$value' => NULL, 'OFIMetricDataPoint$fpr' => '<p> The false positive rate. This is the percentage of total legitimate events that are incorrectly predicted as fraud. </p>', 'OFIMetricDataPoint$precision' => '<p> The percentage of fraud events correctly predicted as fraudulent as compared to all events predicted as fraudulent. </p>', 'OFIMetricDataPoint$tpr' => '<p> The true positive rate. This is the percentage of total fraud the model detects. Also known as capture rate. </p>', 'OFIMetricDataPoint$threshold' => '<p> The model threshold that specifies an acceptable fraud capture rate. For example, a threshold of 500 means any model score 500 or above is labeled as fraud. </p>', 'OFIModelPerformance$auc' => '<p> The area under the curve (auc). This summarizes the total positive rate (tpr) and false positive rate (FPR) across all possible model score thresholds. </p>', 'TFIMetricDataPoint$fpr' => '<p> The false positive rate. This is the percentage of total legitimate events that are incorrectly predicted as fraud. </p>', 'TFIMetricDataPoint$precision' => '<p> The percentage of fraud events correctly predicted as fraudulent as compared to all events predicted as fraudulent. </p>', 'TFIMetricDataPoint$tpr' => '<p> The true positive rate. This is the percentage of total fraud the model detects. Also known as capture rate. </p>', 'TFIMetricDataPoint$threshold' => '<p> The model threshold that specifies an acceptable fraud capture rate. For example, a threshold of 500 means any model score 500 or above is labeled as fraud. </p>', 'TFIModelPerformance$auc' => '<p> The area under the curve (auc). This summarizes the total positive rate (tpr) and false positive rate (FPR) across all possible model score thresholds. </p>', 'TrainingMetrics$auc' => '<p>The area under the curve. This summarizes true positive rate (TPR) and false positive rate (FPR) across all possible model score thresholds. A model with no predictive power has an AUC of 0.5, whereas a perfect model has a score of 1.0.</p>', 'UncertaintyRange$lowerBoundValue' => '<p> The lower bound value of the area under curve (auc). </p>', 'UncertaintyRange$upperBoundValue' => '<p> The upper bound value of the area under curve (auc). </p>', 'VariableImpactExplanation$logOddsImpact' => '<p> The raw, uninterpreted value represented as log-odds of the fraud. These values are usually between -10 to +10, but range from - infinity to + infinity.</p> <ul> <li> <p>A positive value indicates that the variable drove the risk score up.</p> </li> <li> <p>A negative value indicates that the variable drove the risk score down.</p> </li> </ul>', ], ], 'floatVersionString' => [ 'base' => NULL, 'refs' => [ 'BatchPrediction$detectorVersion' => '<p>The detector version. </p>', 'CreateModelVersionResult$modelVersionNumber' => '<p>The model version number of the model version created.</p>', 'DeleteModelVersionRequest$modelVersionNumber' => '<p>The model version number of the model version to delete.</p>', 'DescribeModelVersionsRequest$modelVersionNumber' => '<p>The model version number.</p>', 'GetModelVersionRequest$modelVersionNumber' => '<p>The model version number.</p>', 'GetModelVersionResult$modelVersionNumber' => '<p>The model version number.</p>', 'ModelVersion$modelVersionNumber' => '<p>The model version number.</p>', 'ModelVersionDetail$modelVersionNumber' => '<p>The model version number.</p>', 'UpdateModelVersionResult$modelVersionNumber' => '<p>The model version number of the model version updated.</p>', 'UpdateModelVersionStatusRequest$modelVersionNumber' => '<p>The model version number.</p>', ], ], 'fraudDetectorArn' => [ 'base' => NULL, 'refs' => [ 'AllowDenyList$arn' => '<p> The ARN of the list. </p>', 'BatchImport$arn' => '<p>The ARN of the batch import job.</p>', 'BatchPrediction$arn' => '<p>The ARN of batch prediction job.</p>', 'DescribeDetectorResult$arn' => '<p>The detector ARN.</p>', 'Detector$arn' => '<p>The detector ARN.</p>', 'EntityType$arn' => '<p>The entity type ARN.</p>', 'EventType$arn' => '<p>The entity type ARN.</p>', 'ExternalModel$arn' => '<p>The model ARN.</p>', 'GetDetectorVersionResult$arn' => '<p>The detector version ARN.</p>', 'GetModelVersionResult$arn' => '<p>The model version ARN.</p>', 'Label$arn' => '<p>The label ARN.</p>', 'ListTagsForResourceRequest$resourceARN' => '<p>The ARN that specifies the resource whose tags you want to list.</p>', 'Model$arn' => '<p>The ARN of the model.</p>', 'ModelVersion$arn' => '<p>The model version ARN.</p>', 'ModelVersionDetail$arn' => '<p>The model version ARN.</p>', 'Outcome$arn' => '<p>The outcome ARN.</p>', 'RuleDetail$arn' => '<p>The rule ARN.</p>', 'TagResourceRequest$resourceARN' => '<p>The resource ARN.</p>', 'UntagResourceRequest$resourceARN' => '<p>The ARN of the resource from which to remove the tag.</p>', 'Variable$arn' => '<p>The ARN of the variable.</p>', ], ], 'iamRoleArn' => [ 'base' => NULL, 'refs' => [ 'BatchImport$iamRoleArn' => '<p>The ARN of the IAM role to use for this job request.</p>', 'BatchPrediction$iamRoleArn' => '<p>The ARN of the IAM role to use for this job request.</p>', 'CreateBatchImportJobRequest$iamRoleArn' => '<p>The ARN of the IAM role created for Amazon S3 bucket that holds your data file.</p> <p>The IAM role must have read permissions to your input S3 bucket and write permissions to your output S3 bucket. For more information about bucket permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/example-policies-s3.html">User policy examples</a> in the <i>Amazon S3 User Guide</i>.</p>', 'CreateBatchPredictionJobRequest$iamRoleArn' => '<p>The ARN of the IAM role to use for this job request.</p> <p>The IAM Role must have read permissions to your input S3 bucket and write permissions to your output S3 bucket. For more information about bucket permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/example-policies-s3.html">User policy examples</a> in the <i>Amazon S3 User Guide</i>.</p>', 'ExternalEventsDetail$dataAccessRoleArn' => '<p>The ARN of the role that provides Amazon Fraud Detector access to the data location.</p>', ], ], 'identifier' => [ 'base' => NULL, 'refs' => [ 'BatchImport$jobId' => '<p>The ID of the batch import job. </p>', 'BatchImport$eventTypeName' => '<p>The name of the event type.</p>', 'BatchPrediction$jobId' => '<p>The job ID for the batch prediction.</p>', 'BatchPrediction$eventTypeName' => '<p>The name of the event type.</p>', 'BatchPrediction$detectorName' => '<p>The name of the detector.</p>', 'CancelBatchImportJobRequest$jobId' => '<p> The ID of an in-progress batch import job to cancel. </p> <p>Amazon Fraud Detector will throw an error if the batch import job is in <code>FAILED</code>, <code>CANCELED</code>, or <code>COMPLETED</code> state.</p>', 'CancelBatchPredictionJobRequest$jobId' => '<p>The ID of the batch prediction job to cancel.</p>', 'CreateBatchImportJobRequest$jobId' => '<p>The ID of the batch import job. The ID cannot be of a past job, unless the job exists in <code>CREATE_FAILED</code> state.</p>', 'CreateBatchImportJobRequest$eventTypeName' => '<p>The name of the event type.</p>', 'CreateBatchPredictionJobRequest$jobId' => '<p>The ID of the batch prediction job.</p>', 'CreateBatchPredictionJobRequest$eventTypeName' => '<p>The name of the event type.</p>', 'CreateBatchPredictionJobRequest$detectorName' => '<p>The name of the detector.</p>', 'CreateDetectorVersionRequest$detectorId' => '<p>The ID of the detector under which you want to create a new version.</p>', 'CreateDetectorVersionResult$detectorId' => '<p>The ID for the created version\'s parent detector.</p>', 'CreateRuleRequest$ruleId' => '<p>The rule ID.</p>', 'CreateRuleRequest$detectorId' => '<p>The detector ID for the rule\'s parent detector.</p>', 'DeleteBatchImportJobRequest$jobId' => '<p>The ID of the batch import job to delete. </p>', 'DeleteBatchPredictionJobRequest$jobId' => '<p>The ID of the batch prediction job to delete.</p>', 'DeleteDetectorRequest$detectorId' => '<p>The ID of the detector to delete.</p>', 'DeleteDetectorVersionRequest$detectorId' => '<p>The ID of the parent detector for the detector version to delete.</p>', 'DeleteEntityTypeRequest$name' => '<p>The name of the entity type to delete.</p>', 'DeleteEventRequest$eventId' => '<p>The ID of the event to delete.</p>', 'DeleteEventRequest$eventTypeName' => '<p>The name of the event type.</p>', 'DeleteEventTypeRequest$name' => '<p>The name of the event type to delete.</p>', 'DeleteEventsByEventTypeRequest$eventTypeName' => '<p>The name of the event type.</p>', 'DeleteEventsByEventTypeResult$eventTypeName' => '<p>Name of event type for which to delete the events.</p>', 'DeleteLabelRequest$name' => '<p>The name of the label to delete.</p>', 'DeleteOutcomeRequest$name' => '<p>The name of the outcome to delete.</p>', 'DescribeDetectorRequest$detectorId' => '<p>The detector ID.</p>', 'DescribeDetectorResult$detectorId' => '<p>The detector ID.</p>', 'Detector$detectorId' => '<p>The detector ID.</p>', 'Detector$eventTypeName' => '<p>The name of the event type.</p>', 'EvaluatedRule$ruleId' => '<p> The rule ID. </p>', 'EventPredictionSummary$eventId' => '<p> The event ID. </p>', 'EventPredictionSummary$eventTypeName' => '<p> The event type. </p>', 'EventPredictionSummary$detectorId' => '<p> The detector ID. </p>', 'GetBatchImportJobsRequest$jobId' => '<p>The ID of the batch import job to get.</p>', 'GetBatchPredictionJobsRequest$jobId' => '<p>The batch prediction job for which to get the details.</p>', 'GetDeleteEventsByEventTypeStatusRequest$eventTypeName' => '<p>Name of event type for which to get the deletion status.</p>', 'GetDeleteEventsByEventTypeStatusResult$eventTypeName' => '<p>The event type name.</p>', 'GetDetectorVersionRequest$detectorId' => '<p>The detector ID.</p>', 'GetDetectorVersionResult$detectorId' => '<p>The detector ID.</p>', 'GetDetectorsRequest$detectorId' => '<p>The detector ID.</p>', 'GetEntityTypesRequest$name' => '<p>The name.</p>', 'GetEventPredictionMetadataRequest$eventId' => '<p> The event ID. </p>', 'GetEventPredictionMetadataRequest$eventTypeName' => '<p> The event type associated with the detector specified for the prediction. </p>', 'GetEventPredictionMetadataRequest$detectorId' => '<p> The detector ID. </p>', 'GetEventPredictionMetadataResult$eventId' => '<p> The event ID. </p>', 'GetEventPredictionMetadataResult$eventTypeName' => '<p> The event type associated with the detector specified for this prediction. </p>', 'GetEventPredictionMetadataResult$detectorId' => '<p> The detector ID. </p>', 'GetEventTypesRequest$name' => '<p>The name.</p>', 'GetLabelsRequest$name' => '<p>The name of the label or labels to get.</p>', 'GetOutcomesRequest$name' => '<p>The name of the outcome or outcomes to get.</p>', 'GetRulesRequest$ruleId' => '<p>The rule ID.</p>', 'GetRulesRequest$detectorId' => '<p>The detector ID.</p>', 'ModelInputConfiguration$eventTypeName' => '<p>The event type name.</p>', 'Outcome$name' => '<p>The outcome name.</p>', 'PutDetectorRequest$detectorId' => '<p>The detector ID. </p>', 'PutDetectorRequest$eventTypeName' => '<p>The name of the event type.</p>', 'PutEntityTypeRequest$name' => '<p>The name of the entity type.</p>', 'PutEventTypeRequest$name' => '<p>The name.</p>', 'PutLabelRequest$name' => '<p>The label name.</p>', 'PutOutcomeRequest$name' => '<p>The name of the outcome.</p>', 'Rule$detectorId' => '<p>The detector for which the rule is associated.</p>', 'Rule$ruleId' => '<p>The rule ID.</p>', 'RuleDetail$ruleId' => '<p>The rule ID.</p>', 'RuleDetail$detectorId' => '<p>The detector for which the rule is associated.</p>', 'SendEventRequest$eventId' => '<p>The event ID to upload.</p>', 'SendEventRequest$eventTypeName' => '<p>The event type name of the event.</p>', 'SendEventRequest$assignedLabel' => '<p>The label to associate with the event. Required if specifying <code>labelTimestamp</code>.</p>', 'UpdateDetectorVersionMetadataRequest$detectorId' => '<p>The detector ID.</p>', 'UpdateDetectorVersionRequest$detectorId' => '<p>The parent detector ID for the detector version you want to update.</p>', 'UpdateDetectorVersionStatusRequest$detectorId' => '<p>The detector ID. </p>', 'UpdateEventLabelRequest$eventId' => '<p>The ID of the event associated with the label to update.</p>', 'UpdateEventLabelRequest$eventTypeName' => '<p>The event type of the event associated with the label to update.</p>', 'UpdateEventLabelRequest$assignedLabel' => '<p>The new label to assign to the event.</p>', ], ], 'integer' => [ 'base' => NULL, 'refs' => [ 'BatchCreateVariableError$code' => '<p>The error code. </p>', 'BatchGetVariableError$code' => '<p>The error code. </p>', ], ], 'labelList' => [ 'base' => NULL, 'refs' => [ 'GetLabelsResult$labels' => '<p>An array of labels.</p>', ], ], 'labelMapper' => [ 'base' => NULL, 'refs' => [ 'LabelSchema$labelMapper' => '<p>The label mapper maps the Amazon Fraud Detector supported model classification labels (<code>FRAUD</code>, <code>LEGIT</code>) to the appropriate event type labels. For example, if "<code>FRAUD</code>" and "<code>LEGIT</code>" are Amazon Fraud Detector supported labels, this mapper could be: <code>{"FRAUD" =&gt; ["0"]</code>, <code>"LEGIT" =&gt; ["1"]}</code> or <code>{"FRAUD" =&gt; ["false"]</code>, <code>"LEGIT" =&gt; ["true"]}</code> or <code>{"FRAUD" =&gt; ["fraud", "abuse"]</code>, <code>"LEGIT" =&gt; ["legit", "safe"]}</code>. The value part of the mapper is a list, because you may have multiple label variants from your event type for a single Amazon Fraud Detector label. </p>', ], ], 'labelsMaxResults' => [ 'base' => NULL, 'refs' => [ 'GetLabelsRequest$maxResults' => '<p>The maximum number of objects to return for the request.</p>', ], ], 'listOfEntities' => [ 'base' => NULL, 'refs' => [ 'Event$entities' => '<p>The event entities.</p>', 'GetEventPredictionRequest$entities' => '<p>The entity type (associated with the detector\'s event type) and specific entity ID representing who performed the event. If an entity id is not available, use "UNKNOWN."</p>', 'SendEventRequest$entities' => '<p>An array of entities.</p>', ], ], 'listOfVariableImpactExplanations' => [ 'base' => NULL, 'refs' => [ 'PredictionExplanations$variableImpactExplanations' => '<p> The details of the event variable\'s impact on the prediction score. </p>', ], ], 'metricDataPointsList' => [ 'base' => NULL, 'refs' => [ 'TrainingMetrics$metricDataPoints' => '<p>The data points details.</p>', ], ], 'modelIdentifier' => [ 'base' => NULL, 'refs' => [ 'CreateModelRequest$modelId' => '<p>The model ID.</p>', 'CreateModelVersionRequest$modelId' => '<p>The model ID. </p>', 'CreateModelVersionResult$modelId' => '<p>The model ID.</p>', 'DeleteModelRequest$modelId' => '<p>The model ID of the model to delete.</p>', 'DeleteModelVersionRequest$modelId' => '<p>The model ID of the model version to delete.</p>', 'DescribeModelVersionsRequest$modelId' => '<p>The model ID.</p>', 'GetModelVersionRequest$modelId' => '<p>The model ID.</p>', 'GetModelVersionResult$modelId' => '<p>The model ID.</p>', 'GetModelsRequest$modelId' => '<p>The model ID.</p>', 'Model$modelId' => '<p>The model ID.</p>', 'ModelVersion$modelId' => '<p>The model ID.</p>', 'ModelVersionDetail$modelId' => '<p>The model ID.</p>', 'UpdateModelRequest$modelId' => '<p>The model ID.</p>', 'UpdateModelVersionRequest$modelId' => '<p>The model ID.</p>', 'UpdateModelVersionResult$modelId' => '<p>The model ID.</p>', 'UpdateModelVersionStatusRequest$modelId' => '<p>The model ID of the model version to update.</p>', ], ], 'modelInputTemplate' => [ 'base' => NULL, 'refs' => [ 'ModelInputConfiguration$jsonInputTemplate' => '<p> Template for constructing the JSON input-data sent to SageMaker. At event-evaluation, the placeholders for variable names in the template will be replaced with the variable values before being sent to SageMaker. </p>', 'ModelInputConfiguration$csvInputTemplate' => '<p> Template for constructing the CSV input-data sent to SageMaker. At event-evaluation, the placeholders for variable-names in the template will be replaced with the variable values before being sent to SageMaker. </p>', ], ], 'modelList' => [ 'base' => NULL, 'refs' => [ 'GetModelsResult$models' => '<p>The array of models.</p>', ], ], 'modelVersionDetailList' => [ 'base' => NULL, 'refs' => [ 'DescribeModelVersionsResult$modelVersionDetails' => '<p>The model version details.</p>', ], ], 'modelsMaxPageSize' => [ 'base' => NULL, 'refs' => [ 'DescribeModelVersionsRequest$maxResults' => '<p>The maximum number of results to return.</p>', 'GetModelsRequest$maxResults' => '<p>The maximum number of objects to return for the request. </p>', ], ], 'nextToken' => [ 'base' => NULL, 'refs' => [ 'GetListElementsRequest$nextToken' => '<p> The next token for the subsequent request. </p>', 'GetListElementsResult$nextToken' => '<p> The next page token. </p>', 'GetListsMetadataRequest$nextToken' => '<p> The next token for the subsequent request. </p>', 'GetListsMetadataResult$nextToken' => '<p> The next page token. </p>', ], ], 'noDashIdentifier' => [ 'base' => NULL, 'refs' => [ 'AllowDenyList$name' => '<p> The name of the list. </p>', 'CreateListRequest$name' => '<p> The name of the list. </p>', 'DeleteListRequest$name' => '<p> The name of the list to delete. </p>', 'GetListElementsRequest$name' => '<p> The name of the list. </p>', 'GetListsMetadataRequest$name' => '<p> The name of the list. </p>', 'UpdateListRequest$name' => '<p> The name of the list to update. </p>', ], ], 'ruleExpression' => [ 'base' => NULL, 'refs' => [ 'CreateRuleRequest$expression' => '<p>The rule expression.</p>', 'RuleDetail$expression' => '<p>The rule expression.</p>', 'UpdateRuleVersionRequest$expression' => '<p>The rule expression.</p>', ], ], 's3BucketLocation' => [ 'base' => NULL, 'refs' => [ 'BatchImport$inputPath' => '<p>The Amazon S3 location of your data file for batch import.</p>', 'BatchImport$outputPath' => '<p>The Amazon S3 location of your output file.</p>', 'BatchPrediction$inputPath' => '<p>The Amazon S3 location of your training file.</p>', 'BatchPrediction$outputPath' => '<p>The Amazon S3 location of your output file.</p>', 'CreateBatchImportJobRequest$inputPath' => '<p>The URI that points to the Amazon S3 location of your data file.</p>', 'CreateBatchImportJobRequest$outputPath' => '<p>The URI that points to the Amazon S3 location for storing your results. </p>', 'CreateBatchPredictionJobRequest$inputPath' => '<p>The Amazon S3 location of your training file.</p>', 'CreateBatchPredictionJobRequest$outputPath' => '<p>The Amazon S3 location of your output file.</p>', 'ExternalEventsDetail$dataLocation' => '<p>The Amazon S3 bucket location for the data.</p>', ], ], 'sageMakerEndpointIdentifier' => [ 'base' => NULL, 'refs' => [ 'DeleteExternalModelRequest$modelEndpoint' => '<p>The endpoint of the Amazon Sagemaker model to delete.</p>', 'ExternalModelEndpointDataBlobMap$key' => NULL, 'PutExternalModelRequest$modelEndpoint' => '<p>The model endpoints name.</p>', ], ], 'sensitiveString' => [ 'base' => NULL, 'refs' => [ 'EvaluatedRule$expression' => '<p> The rule expression. </p>', 'EvaluatedRule$expressionWithValues' => '<p> The rule expression value. </p>', 'EventVariableSummary$name' => '<p> The event variable name. </p>', 'EventVariableSummary$value' => '<p> The value of the event variable. </p>', 'EventVariableSummary$source' => '<p> The event variable source. </p>', ], ], 'string' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'AggregatedVariablesImpactExplanation$relativeImpact' => '<p> The relative impact of the aggregated variables in terms of magnitude on the prediction scores. </p>', 'BatchCreateVariableError$name' => '<p>The name.</p>', 'BatchCreateVariableError$message' => '<p>The error message.</p>', 'BatchGetVariableError$name' => '<p>The error name. </p>', 'BatchGetVariableError$message' => '<p>The error message.</p>', 'BatchImport$failureReason' => '<p>The reason batch import job failed.</p>', 'BatchPrediction$failureReason' => '<p>The reason a batch prediction job failed.</p>', 'ConflictException$message' => NULL, 'CreateModelRequest$eventTypeName' => '<p>The name of the event type.</p>', 'CreateModelVersionResult$status' => '<p>The model version status. </p>', 'CreateVariableRequest$name' => '<p>The name of the variable.</p>', 'CreateVariableRequest$defaultValue' => '<p>The default value for the variable when no value is received.</p>', 'CreateVariableRequest$description' => '<p>The description.</p>', 'CreateVariableRequest$variableType' => '<p>The variable type. For more information see <a href="https://docs.aws.amazon.com/frauddetector/latest/ug/create-a-variable.html#variable-types">Variable types</a>. </p> <p>Valid Values: <code>AUTH_CODE | AVS | BILLING_ADDRESS_L1 | BILLING_ADDRESS_L2 | BILLING_CITY | BILLING_COUNTRY | BILLING_NAME | BILLING_PHONE | BILLING_STATE | BILLING_ZIP | CARD_BIN | CATEGORICAL | CURRENCY_CODE | EMAIL_ADDRESS | FINGERPRINT | FRAUD_LABEL | FREE_FORM_TEXT | IP_ADDRESS | NUMERIC | ORDER_ID | PAYMENT_TYPE | PHONE_NUMBER | PRICE | PRODUCT_CATEGORY | SHIPPING_ADDRESS_L1 | SHIPPING_ADDRESS_L2 | SHIPPING_CITY | SHIPPING_COUNTRY | SHIPPING_NAME | SHIPPING_PHONE | SHIPPING_STATE | SHIPPING_ZIP | USERAGENT</code> </p>', 'CsvIndexToVariableMap$key' => NULL, 'CsvIndexToVariableMap$value' => NULL, 'DeleteEventsByEventTypeResult$eventsDeletionStatus' => '<p>The status of the delete request.</p>', 'DeleteVariableRequest$name' => '<p>The name of the variable to delete.</p>', 'DescribeDetectorRequest$nextToken' => '<p>The next token from the previous response.</p>', 'DescribeDetectorResult$nextToken' => '<p>The next token to be used for subsequent requests.</p>', 'DescribeModelVersionsRequest$nextToken' => '<p>The next token from the previous results.</p>', 'DescribeModelVersionsResult$nextToken' => '<p>The next token.</p>', 'Entity$entityType' => '<p>The entity type.</p>', 'EntityType$name' => '<p>The entity type name.</p>', 'EvaluatedExternalModel$modelEndpoint' => '<p> The endpoint of the external (Amazon Sagemaker) model. </p>', 'EvaluatedModelVersion$modelId' => '<p> The model ID. </p>', 'EvaluatedModelVersion$modelVersion' => '<p> The model version. </p>', 'EvaluatedModelVersion$modelType' => '<p>The model type. </p> <p>Valid values: <code>ONLINE_FRAUD_INSIGHTS</code> | <code>TRANSACTION_FRAUD_INSIGHTS</code> </p>', 'Event$eventId' => '<p>The event ID.</p>', 'Event$eventTypeName' => '<p>The event type.</p>', 'Event$eventTimestamp' => '<p>The timestamp that defines when the event under evaluation occurred. The timestamp must be specified using ISO 8601 standard in UTC.</p>', 'Event$currentLabel' => '<p>The label associated with the event.</p>', 'Event$labelTimestamp' => '<p>The timestamp associated with the label to update. The timestamp must be specified using ISO 8601 standard in UTC.</p>', 'EventType$name' => '<p>The event type name.</p>', 'ExternalModel$modelEndpoint' => '<p>The Amazon SageMaker model endpoints.</p>', 'ExternalModel$invokeModelEndpointRoleArn' => '<p>The role used to invoke the model. </p>', 'ExternalModelPredictionMap$key' => NULL, 'ExternalModelPredictionMap$value' => NULL, 'ExternalModelSummary$modelEndpoint' => '<p>The endpoint of the Amazon SageMaker model.</p>', 'FieldValidationMessage$fieldName' => '<p>The field name.</p>', 'FieldValidationMessage$identifier' => '<p>The message ID.</p>', 'FieldValidationMessage$title' => '<p>The message title.</p>', 'FieldValidationMessage$content' => '<p>The message content.</p>', 'FieldValidationMessage$type' => '<p>The message type.</p>', 'FileValidationMessage$title' => '<p>The message title.</p>', 'FileValidationMessage$content' => '<p>The message content.</p>', 'FileValidationMessage$type' => '<p>The message type.</p>', 'GetBatchImportJobsRequest$nextToken' => '<p>The next token from the previous request.</p>', 'GetBatchImportJobsResult$nextToken' => '<p>The next token for the subsequent resquest.</p>', 'GetBatchPredictionJobsRequest$nextToken' => '<p>The next token from the previous request.</p>', 'GetBatchPredictionJobsResult$nextToken' => '<p>The next token for the subsequent request.</p>', 'GetDetectorsRequest$nextToken' => '<p>The next token for the subsequent request.</p>', 'GetDetectorsResult$nextToken' => '<p>The next page token.</p>', 'GetEntityTypesRequest$nextToken' => '<p>The next token for the subsequent request.</p>', 'GetEntityTypesResult$nextToken' => '<p>The next page token.</p>', 'GetEventPredictionMetadataResult$entityId' => '<p> The entity ID. </p>', 'GetEventPredictionMetadataResult$entityType' => '<p> The entity type. </p>', 'GetEventPredictionMetadataResult$detectorVersionStatus' => '<p> The status of the detector version. </p>', 'GetEventPredictionRequest$detectorId' => '<p>The detector ID.</p>', 'GetEventPredictionRequest$eventId' => '<p>The unique ID used to identify the event.</p>', 'GetEventPredictionRequest$eventTypeName' => '<p>The event type associated with the detector specified for the prediction.</p>', 'GetEventRequest$eventId' => '<p>The ID of the event to retrieve.</p>', 'GetEventRequest$eventTypeName' => '<p>The event type of the event to retrieve.</p>', 'GetEventTypesRequest$nextToken' => '<p>The next token for the subsequent request.</p>', 'GetEventTypesResult$nextToken' => '<p>The next page token.</p>', 'GetExternalModelsRequest$modelEndpoint' => '<p>The Amazon SageMaker model endpoint.</p>', 'GetExternalModelsRequest$nextToken' => '<p>The next page token for the request.</p>', 'GetExternalModelsResult$nextToken' => '<p>The next page token to be used in subsequent requests.</p>', 'GetLabelsRequest$nextToken' => '<p>The next token for the subsequent request.</p>', 'GetLabelsResult$nextToken' => '<p>The next page token.</p>', 'GetModelVersionResult$status' => '<p>The model version status.</p> <p>Possible values are:</p> <ul> <li> <p> <code>TRAINING_IN_PROGRESS</code> </p> </li> <li> <p> <code>TRAINING_COMPLETE</code> </p> </li> <li> <p> <code>ACTIVATE_REQUESTED</code> </p> </li> <li> <p> <code>ACTIVATE_IN_PROGRESS</code> </p> </li> <li> <p> <code>ACTIVE</code> </p> </li> <li> <p> <code>INACTIVATE_REQUESTED</code> </p> </li> <li> <p> <code>INACTIVATE_IN_PROGRESS</code> </p> </li> <li> <p> <code>INACTIVE</code> </p> </li> <li> <p> <code>ERROR</code> </p> </li> </ul>', 'GetModelsRequest$nextToken' => '<p>The next token for the subsequent request.</p>', 'GetModelsResult$nextToken' => '<p>The next page token to be used in subsequent requests.</p>', 'GetOutcomesRequest$nextToken' => '<p>The next page token for the request. </p>', 'GetOutcomesResult$nextToken' => '<p>The next page token for subsequent requests.</p>', 'GetRulesRequest$nextToken' => '<p>The next page token.</p>', 'GetRulesResult$nextToken' => '<p>The next page token to be used in subsequent requests.</p>', 'GetVariablesRequest$name' => '<p>The name of the variable. </p>', 'GetVariablesRequest$nextToken' => '<p>The next page token of the get variable request. </p>', 'GetVariablesResult$nextToken' => '<p>The next page token to be used in subsequent requests. </p>', 'InternalServerException$message' => NULL, 'JsonKeyToVariableMap$key' => NULL, 'JsonKeyToVariableMap$value' => NULL, 'Label$name' => '<p>The label name.</p>', 'ListEventPredictionsRequest$nextToken' => '<p> Identifies the next page of results to return. Use the token to make the call again to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. </p>', 'ListEventPredictionsResult$nextToken' => '<p> Identifies the next page of results to return. Use the token to make the call again to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. </p>', 'ListOfStrings$member' => NULL, 'ListTagsForResourceRequest$nextToken' => '<p>The next token from the previous results.</p>', 'ListTagsForResourceResult$nextToken' => '<p>The next token for subsequent requests. </p>', 'LogOddsMetric$variableName' => '<p>The name of the variable.</p>', 'LogOddsMetric$variableType' => '<p>The type of variable.</p>', 'MapOfStrings$key' => NULL, 'MapOfStrings$value' => NULL, 'Model$eventTypeName' => '<p>The name of the event type.</p>', 'ModelPredictionMap$key' => NULL, 'ModelVersionDetail$status' => '<p>The status of the model version.</p>', 'ModelVersionEvaluation$outputVariableName' => '<p> The output variable name. </p>', 'ModelVersionEvaluation$evaluationScore' => '<p> The evaluation score generated for the model version. </p>', 'NameList$member' => NULL, 'NonEmptyListOfStrings$member' => NULL, 'PutExternalModelRequest$invokeModelEndpointRoleArn' => '<p>The IAM role used to invoke the model endpoint.</p>', 'ResourceNotFoundException$message' => NULL, 'ResourceUnavailableException$message' => NULL, 'RuleResult$ruleId' => '<p>The rule ID that was matched, based on the rule execution mode.</p>', 'ThrottlingException$message' => NULL, 'UpdateModelVersionResult$status' => '<p>The status of the updated model version.</p>', 'UpdateVariableRequest$name' => '<p>The name of the variable.</p>', 'UpdateVariableRequest$defaultValue' => '<p>The new default value of the variable.</p>', 'UpdateVariableRequest$description' => '<p>The new description.</p>', 'UpdateVariableRequest$variableType' => '<p>The variable type. For more information see <a href="https://docs.aws.amazon.com/frauddetector/latest/ug/create-a-variable.html#variable-types">Variable types</a>.</p>', 'ValidationException$message' => NULL, 'Variable$name' => '<p>The name of the variable.</p>', 'Variable$defaultValue' => '<p>The default value of the variable.</p>', 'Variable$description' => '<p>The description of the variable. </p>', 'Variable$variableType' => '<p>The variable type of the variable.</p> <p>Valid Values: <code>AUTH_CODE | AVS | BILLING_ADDRESS_L1 | BILLING_ADDRESS_L2 | BILLING_CITY | BILLING_COUNTRY | BILLING_NAME | BILLING_PHONE | BILLING_STATE | BILLING_ZIP | CARD_BIN | CATEGORICAL | CURRENCY_CODE | EMAIL_ADDRESS | FINGERPRINT | FRAUD_LABEL | FREE_FORM_TEXT | IP_ADDRESS | NUMERIC | ORDER_ID | PAYMENT_TYPE | PHONE_NUMBER | PRICE | PRODUCT_CATEGORY | SHIPPING_ADDRESS_L1 | SHIPPING_ADDRESS_L2 | SHIPPING_CITY | SHIPPING_COUNTRY | SHIPPING_NAME | SHIPPING_PHONE | SHIPPING_STATE | SHIPPING_ZIP | USERAGENT </code> </p>', 'VariableEntry$name' => '<p>The name of the variable.</p>', 'VariableEntry$dataType' => '<p>The data type of the variable.</p>', 'VariableEntry$dataSource' => '<p>The data source of the variable.</p>', 'VariableEntry$defaultValue' => '<p>The default value of the variable.</p>', 'VariableEntry$description' => '<p>The description of the variable.</p>', 'VariableEntry$variableType' => '<p>The type of the variable. For more information see <a href="https://docs.aws.amazon.com/frauddetector/latest/ug/create-a-variable.html#variable-types">Variable types</a>.</p> <p>Valid Values: <code>AUTH_CODE | AVS | BILLING_ADDRESS_L1 | BILLING_ADDRESS_L2 | BILLING_CITY | BILLING_COUNTRY | BILLING_NAME | BILLING_PHONE | BILLING_STATE | BILLING_ZIP | CARD_BIN | CATEGORICAL | CURRENCY_CODE | EMAIL_ADDRESS | FINGERPRINT | FRAUD_LABEL | FREE_FORM_TEXT | IP_ADDRESS | NUMERIC | ORDER_ID | PAYMENT_TYPE | PHONE_NUMBER | PRICE | PRODUCT_CATEGORY | SHIPPING_ADDRESS_L1 | SHIPPING_ADDRESS_L2 | SHIPPING_CITY | SHIPPING_COUNTRY | SHIPPING_NAME | SHIPPING_PHONE | SHIPPING_STATE | SHIPPING_ZIP | USERAGENT </code> </p>', 'VariableImpactExplanation$eventVariableName' => '<p> The event variable name. </p>', 'VariableImpactExplanation$relativeImpact' => '<p> The event variable\'s relative impact in terms of magnitude on the prediction scores. The relative impact values consist of a numerical rating (0-5, 5 being the highest) and direction (increased/decreased) impact of the fraud risk. </p>', 'labelMapper$key' => NULL, ], ], 'tagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$key' => '<p>A tag key.</p>', 'tagKeyList$member' => NULL, ], ], 'tagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>The resource ARN.</p>', ], ], 'tagList' => [ 'base' => NULL, 'refs' => [ 'BatchCreateVariableRequest$tags' => '<p>A collection of key and value pairs.</p>', 'CreateBatchImportJobRequest$tags' => '<p>A collection of key-value pairs associated with this request. </p>', 'CreateBatchPredictionJobRequest$tags' => '<p>A collection of key and value pairs.</p>', 'CreateDetectorVersionRequest$tags' => '<p>A collection of key and value pairs.</p>', 'CreateListRequest$tags' => '<p> A collection of the key and value pairs. </p>', 'CreateModelRequest$tags' => '<p>A collection of key and value pairs.</p>', 'CreateModelVersionRequest$tags' => '<p>A collection of key and value pairs.</p>', 'CreateRuleRequest$tags' => '<p>A collection of key and value pairs.</p>', 'CreateVariableRequest$tags' => '<p>A collection of key and value pairs.</p>', 'ListTagsForResourceResult$tags' => '<p>A collection of key and value pairs.</p>', 'PutDetectorRequest$tags' => '<p>A collection of key and value pairs.</p>', 'PutEntityTypeRequest$tags' => '<p>A collection of key and value pairs.</p>', 'PutEventTypeRequest$tags' => '<p>A collection of key and value pairs.</p>', 'PutExternalModelRequest$tags' => '<p>A collection of key and value pairs.</p>', 'PutLabelRequest$tags' => '<p>A collection of key and value pairs.</p>', 'PutOutcomeRequest$tags' => '<p>A collection of key and value pairs.</p>', 'TagResourceRequest$tags' => '<p>The tags to assign to the resource.</p>', 'UpdateModelVersionRequest$tags' => '<p>A collection of key and value pairs.</p>', 'UpdateRuleVersionRequest$tags' => '<p>The tags to assign to the rule version.</p>', ], ], 'tagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$value' => '<p>A value assigned to a tag key.</p>', ], ], 'time' => [ 'base' => NULL, 'refs' => [ 'AllowDenyList$createdTime' => '<p> The time the list was created. </p>', 'AllowDenyList$updatedTime' => '<p> The time the list was last updated. </p>', 'BatchImport$startTime' => '<p>Timestamp of when the batch import job started.</p>', 'BatchImport$completionTime' => '<p>Timestamp of when batch import job completed.</p>', 'BatchPrediction$startTime' => '<p>Timestamp of when the batch prediction job started.</p>', 'BatchPrediction$completionTime' => '<p>Timestamp of when the batch prediction job completed.</p>', 'BatchPrediction$lastHeartbeatTime' => '<p>Timestamp of most recent heartbeat indicating the batch prediction job was making progress.</p>', 'Detector$lastUpdatedTime' => '<p>Timestamp of when the detector was last updated.</p>', 'Detector$createdTime' => '<p>Timestamp of when the detector was created.</p>', 'DetectorVersionSummary$lastUpdatedTime' => '<p>Timestamp of when the detector version was last updated.</p>', 'EntityType$lastUpdatedTime' => '<p>Timestamp of when the entity type was last updated.</p>', 'EntityType$createdTime' => '<p>Timestamp of when the entity type was created.</p>', 'EventPredictionSummary$eventTimestamp' => '<p> The timestamp of the event. </p>', 'EventPredictionSummary$predictionTimestamp' => '<p> The timestamp when the prediction was generated. </p>', 'EventType$lastUpdatedTime' => '<p>Timestamp of when the event type was last updated.</p>', 'EventType$createdTime' => '<p>Timestamp of when the event type was created.</p>', 'ExternalModel$lastUpdatedTime' => '<p>Timestamp of when the model was last updated.</p>', 'ExternalModel$createdTime' => '<p>Timestamp of when the model was last created.</p>', 'GetDetectorVersionResult$lastUpdatedTime' => '<p>The timestamp when the detector version was last updated. </p>', 'GetDetectorVersionResult$createdTime' => '<p>The timestamp when the detector version was created. </p>', 'GetEventPredictionMetadataRequest$predictionTimestamp' => '<p> The timestamp that defines when the prediction was generated. The timestamp must be specified using ISO 8601 standard in UTC.</p> <p>We recommend calling <a href="https://docs.aws.amazon.com/frauddetector/latest/api/API_ListEventPredictions.html">ListEventPredictions</a> first, and using the <code>predictionTimestamp</code> value in the response to provide an accurate prediction timestamp value.</p>', 'GetEventPredictionMetadataResult$eventTimestamp' => '<p> The timestamp for when the prediction was generated for the associated event ID. </p>', 'GetEventPredictionMetadataResult$predictionTimestamp' => '<p>The timestamp that defines when the prediction was generated. </p>', 'IngestedEventStatistics$leastRecentEvent' => '<p>The oldest stored event.</p>', 'IngestedEventStatistics$mostRecentEvent' => '<p>The newest stored event.</p>', 'IngestedEventStatistics$lastUpdatedTime' => '<p>Timestamp of when the stored event was last updated. </p>', 'IngestedEventsTimeWindow$startTime' => '<p>Timestamp of the first ingensted event.</p>', 'IngestedEventsTimeWindow$endTime' => '<p>Timestamp of the final ingested event.</p>', 'Label$lastUpdatedTime' => '<p>Timestamp of when the label was last updated.</p>', 'Label$createdTime' => '<p>Timestamp of when the event type was created.</p>', 'Model$createdTime' => '<p>Timestamp of when the model was created.</p>', 'Model$lastUpdatedTime' => '<p>Timestamp of last time the model was updated.</p>', 'ModelVersionDetail$lastUpdatedTime' => '<p>The timestamp when the model was last updated.</p>', 'ModelVersionDetail$createdTime' => '<p>The timestamp when the model was created.</p>', 'Outcome$lastUpdatedTime' => '<p>The timestamp when the outcome was last updated.</p>', 'Outcome$createdTime' => '<p>The timestamp when the outcome was created.</p>', 'PredictionTimeRange$startTime' => '<p> The start time of the time period for when the predictions were generated. </p>', 'PredictionTimeRange$endTime' => '<p> The end time of the time period for when the predictions were generated. </p>', 'RuleDetail$lastUpdatedTime' => '<p>Timestamp of the last time the rule was updated.</p>', 'RuleDetail$createdTime' => '<p>The timestamp of when the rule was created.</p>', 'Variable$lastUpdatedTime' => '<p>The time when variable was last updated.</p>', 'Variable$createdTime' => '<p>The time when the variable was created.</p>', ], ], 'utcTimestampISO8601' => [ 'base' => NULL, 'refs' => [ 'GetEventPredictionRequest$eventTimestamp' => '<p>Timestamp that defines when the event under evaluation occurred. The timestamp must be specified using ISO 8601 standard in UTC.</p>', 'SendEventRequest$eventTimestamp' => '<p>The timestamp that defines when the event under evaluation occurred. The timestamp must be specified using ISO 8601 standard in UTC.</p>', 'SendEventRequest$labelTimestamp' => '<p>The timestamp associated with the label. Required if specifying <code>assignedLabel</code>.</p>', 'UpdateEventLabelRequest$labelTimestamp' => '<p>The timestamp associated with the label. The timestamp must be specified using ISO 8601 standard in UTC. </p>', ], ], 'variableName' => [ 'base' => NULL, 'refs' => [ 'EventVariableMap$key' => NULL, ], ], 'variableType' => [ 'base' => NULL, 'refs' => [ 'AllowDenyList$variableType' => '<p> The variable type of the list. </p>', 'CreateListRequest$variableType' => '<p> The variable type of the list. You can only assign the variable type with String data type. For more information, see <a href="https://docs.aws.amazon.com/frauddetector/latest/ug/create-a-variable.html#variable-types">Variable types</a>. </p>', 'UpdateListRequest$variableType' => '<p> The variable type you want to assign to the list. </p> <note> <p>You cannot update a variable type of a list that already has a variable type assigned to it. You can assign a variable type to a list only if the list does not already have a variable type.</p> </note>', ], ], 'variableValue' => [ 'base' => NULL, 'refs' => [ 'EventVariableMap$value' => NULL, ], ], 'wholeNumberVersionString' => [ 'base' => NULL, 'refs' => [ 'CreateBatchPredictionJobRequest$detectorVersion' => '<p>The detector version.</p>', 'CreateDetectorVersionResult$detectorVersionId' => '<p>The ID for the created detector. </p>', 'DeleteDetectorVersionRequest$detectorVersionId' => '<p>The ID of the detector version to delete.</p>', 'DetectorVersionSummary$detectorVersionId' => '<p>The detector version ID. </p>', 'EvaluatedRule$ruleVersion' => '<p> The rule version. </p>', 'EventPredictionSummary$detectorVersionId' => '<p> The detector version ID. </p>', 'GetDetectorVersionRequest$detectorVersionId' => '<p>The detector version ID.</p>', 'GetDetectorVersionResult$detectorVersionId' => '<p>The detector version ID.</p>', 'GetEventPredictionMetadataRequest$detectorVersionId' => '<p> The detector version ID. </p>', 'GetEventPredictionMetadataResult$detectorVersionId' => '<p> The detector version ID. </p>', 'GetEventPredictionRequest$detectorVersionId' => '<p>The detector version ID.</p>', 'GetRulesRequest$ruleVersion' => '<p>The rule version.</p>', 'Rule$ruleVersion' => '<p>The rule version.</p>', 'RuleDetail$ruleVersion' => '<p>The rule version.</p>', 'UpdateDetectorVersionMetadataRequest$detectorVersionId' => '<p>The detector version ID. </p>', 'UpdateDetectorVersionRequest$detectorVersionId' => '<p>The detector version ID. </p>', 'UpdateDetectorVersionStatusRequest$detectorVersionId' => '<p>The detector version ID. </p>', 'UpdateModelVersionRequest$majorVersionNumber' => '<p>The major version number.</p>', ], ], ],];
