<?php
// This file was auto-generated from sdk-root/src/data/glacier/2012-06-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<p> Amazon S3 Glacier (Glacier) is a storage solution for "cold data."</p> <p>Glacier is an extremely low-cost storage service that provides secure, durable, and easy-to-use storage for data backup and archival. With Glacier, customers can store their data cost effectively for months, years, or decades. Glacier also enables customers to offload the administrative burdens of operating and scaling storage to AWS, so they don\'t have to worry about capacity planning, hardware provisioning, data replication, hardware failure and recovery, or time-consuming hardware migrations.</p> <p>Glacier is a great storage choice when low storage cost is paramount and your data is rarely retrieved. If your application requires fast or frequent access to your data, consider using Amazon S3. For more information, see <a href="http://aws.amazon.com/s3/">Amazon Simple Storage Service (Amazon S3)</a>.</p> <p>You can store any kind of data in any format. There is no maximum limit on the total amount of data you can store in Glacier.</p> <p>If you are a first-time user of Glacier, we recommend that you begin by reading the following sections in the <i>Amazon S3 Glacier Developer Guide</i>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/introduction.html">What is Amazon S3 Glacier</a> - This section of the Developer Guide describes the underlying data model, the operations it supports, and the AWS SDKs that you can use to interact with the service.</p> </li> <li> <p> <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/amazon-glacier-getting-started.html">Getting Started with Amazon S3 Glacier</a> - The Getting Started section walks you through the process of creating a vault, uploading archives, creating jobs to download archives, retrieving the job output, and deleting archives.</p> </li> </ul>', 'operations' => [ 'AbortMultipartUpload' => '<p>This operation aborts a multipart upload identified by the upload ID.</p> <p>After the Abort Multipart Upload request succeeds, you cannot upload any more parts to the multipart upload or complete the multipart upload. Aborting a completed upload fails. However, aborting an already-aborted upload will succeed, for a short time. For more information about uploading a part and completing a multipart upload, see <a>UploadMultipartPart</a> and <a>CompleteMultipartUpload</a>.</p> <p>This operation is idempotent.</p> <p>An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access Management (IAM) users don\'t have any permissions by default. You must grant them explicit permission to perform specific actions. For more information, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control Using AWS Identity and Access Management (IAM)</a>.</p> <p> For conceptual information and underlying REST API, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/working-with-archives.html">Working with Archives in Amazon S3 Glacier</a> and <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-abort-upload.html">Abort Multipart Upload</a> in the <i>Amazon Glacier Developer Guide</i>. </p>', 'AbortVaultLock' => '<p>This operation aborts the vault locking process if the vault lock is not in the <code>Locked</code> state. If the vault lock is in the <code>Locked</code> state when this operation is requested, the operation returns an <code>AccessDeniedException</code> error. Aborting the vault locking process removes the vault lock policy from the specified vault. </p> <p>A vault lock is put into the <code>InProgress</code> state by calling <a>InitiateVaultLock</a>. A vault lock is put into the <code>Locked</code> state by calling <a>CompleteVaultLock</a>. You can get the state of a vault lock by calling <a>GetVaultLock</a>. For more information about the vault locking process, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-lock.html">Amazon Glacier Vault Lock</a>. For more information about vault lock policies, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-lock-policy.html">Amazon Glacier Access Control with Vault Lock Policies</a>. </p> <p>This operation is idempotent. You can successfully invoke this operation multiple times, if the vault lock is in the <code>InProgress</code> state or if there is no policy associated with the vault.</p>', 'AddTagsToVault' => '<p>This operation adds the specified tags to a vault. Each tag is composed of a key and a value. Each vault can have up to 10 tags. If your request would cause the tag limit for the vault to be exceeded, the operation throws the <code>LimitExceededException</code> error. If a tag already exists on the vault under a specified key, the existing key value will be overwritten. For more information about tags, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/tagging.html">Tagging Amazon S3 Glacier Resources</a>. </p>', 'CompleteMultipartUpload' => '<p>You call this operation to inform Amazon S3 Glacier (Glacier) that all the archive parts have been uploaded and that Glacier can now assemble the archive from the uploaded parts. After assembling and saving the archive to the vault, Glacier returns the URI path of the newly created archive resource. Using the URI path, you can then access the archive. After you upload an archive, you should save the archive ID returned to retrieve the archive at a later point. You can also get the vault inventory to obtain a list of archive IDs in a vault. For more information, see <a>InitiateJob</a>.</p> <p>In the request, you must include the computed SHA256 tree hash of the entire archive you have uploaded. For information about computing a SHA256 tree hash, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/checksum-calculations.html">Computing Checksums</a>. On the server side, Glacier also constructs the SHA256 tree hash of the assembled archive. If the values match, Glacier saves the archive to the vault; otherwise, it returns an error, and the operation fails. The <a>ListParts</a> operation returns a list of parts uploaded for a specific multipart upload. It includes checksum information for each uploaded part that can be used to debug a bad checksum issue.</p> <p>Additionally, Glacier also checks for any missing content ranges when assembling the archive, if missing content ranges are found, Glacier returns an error and the operation fails.</p> <p>Complete Multipart Upload is an idempotent operation. After your first successful complete multipart upload, if you call the operation again within a short period, the operation will succeed and return the same archive ID. This is useful in the event you experience a network issue that causes an aborted connection or receive a 500 server error, in which case you can repeat your Complete Multipart Upload request and get the same archive ID without creating duplicate archives. Note, however, that after the multipart upload completes, you cannot call the List Parts operation and the multipart upload will not appear in List Multipart Uploads response, even if idempotent complete is possible.</p> <p>An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access Management (IAM) users don\'t have any permissions by default. You must grant them explicit permission to perform specific actions. For more information, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control Using AWS Identity and Access Management (IAM)</a>.</p> <p> For conceptual information and underlying REST API, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/uploading-archive-mpu.html">Uploading Large Archives in Parts (Multipart Upload)</a> and <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-complete-upload.html">Complete Multipart Upload</a> in the <i>Amazon Glacier Developer Guide</i>. </p>', 'CompleteVaultLock' => '<p>This operation completes the vault locking process by transitioning the vault lock from the <code>InProgress</code> state to the <code>Locked</code> state, which causes the vault lock policy to become unchangeable. A vault lock is put into the <code>InProgress</code> state by calling <a>InitiateVaultLock</a>. You can obtain the state of the vault lock by calling <a>GetVaultLock</a>. For more information about the vault locking process, <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-lock.html">Amazon Glacier Vault Lock</a>. </p> <p>This operation is idempotent. This request is always successful if the vault lock is in the <code>Locked</code> state and the provided lock ID matches the lock ID originally used to lock the vault.</p> <p>If an invalid lock ID is passed in the request when the vault lock is in the <code>Locked</code> state, the operation returns an <code>AccessDeniedException</code> error. If an invalid lock ID is passed in the request when the vault lock is in the <code>InProgress</code> state, the operation throws an <code>InvalidParameter</code> error.</p>', 'CreateVault' => '<p>This operation creates a new vault with the specified name. The name of the vault must be unique within a region for an AWS account. You can create up to 1,000 vaults per account. If you need to create more vaults, contact Amazon S3 Glacier.</p> <p>You must use the following guidelines when naming a vault.</p> <ul> <li> <p>Names can be between 1 and 255 characters long.</p> </li> <li> <p>Allowed characters are a-z, A-Z, 0-9, \'_\' (underscore), \'-\' (hyphen), and \'.\' (period).</p> </li> </ul> <p>This operation is idempotent.</p> <p>An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access Management (IAM) users don\'t have any permissions by default. You must grant them explicit permission to perform specific actions. For more information, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control Using AWS Identity and Access Management (IAM)</a>.</p> <p> For conceptual information and underlying REST API, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/creating-vaults.html">Creating a Vault in Amazon Glacier</a> and <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vault-put.html">Create Vault </a> in the <i>Amazon Glacier Developer Guide</i>. </p>', 'DeleteArchive' => '<p>This operation deletes an archive from a vault. Subsequent requests to initiate a retrieval of this archive will fail. Archive retrievals that are in progress for this archive ID may or may not succeed according to the following scenarios:</p> <ul> <li> <p>If the archive retrieval job is actively preparing the data for download when Amazon S3 Glacier receives the delete archive request, the archival retrieval operation might fail.</p> </li> <li> <p>If the archive retrieval job has successfully prepared the archive for download when Amazon S3 Glacier receives the delete archive request, you will be able to download the output.</p> </li> </ul> <p>This operation is idempotent. Attempting to delete an already-deleted archive does not result in an error.</p> <p>An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access Management (IAM) users don\'t have any permissions by default. You must grant them explicit permission to perform specific actions. For more information, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control Using AWS Identity and Access Management (IAM)</a>.</p> <p> For conceptual information and underlying REST API, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/deleting-an-archive.html">Deleting an Archive in Amazon Glacier</a> and <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-archive-delete.html">Delete Archive</a> in the <i>Amazon Glacier Developer Guide</i>. </p>', 'DeleteVault' => '<p>This operation deletes a vault. Amazon S3 Glacier will delete a vault only if there are no archives in the vault as of the last inventory and there have been no writes to the vault since the last inventory. If either of these conditions is not satisfied, the vault deletion fails (that is, the vault is not removed) and Amazon S3 Glacier returns an error. You can use <a>DescribeVault</a> to return the number of archives in a vault, and you can use <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-initiate-job-post.html">Initiate a Job (POST jobs)</a> to initiate a new inventory retrieval for a vault. The inventory contains the archive IDs you use to delete archives using <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-archive-delete.html">Delete Archive (DELETE archive)</a>.</p> <p>This operation is idempotent.</p> <p>An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access Management (IAM) users don\'t have any permissions by default. You must grant them explicit permission to perform specific actions. For more information, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control Using AWS Identity and Access Management (IAM)</a>.</p> <p> For conceptual information and underlying REST API, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/deleting-vaults.html">Deleting a Vault in Amazon Glacier</a> and <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vault-delete.html">Delete Vault </a> in the <i>Amazon S3 Glacier Developer Guide</i>. </p>', 'DeleteVaultAccessPolicy' => '<p>This operation deletes the access policy associated with the specified vault. The operation is eventually consistent; that is, it might take some time for Amazon S3 Glacier to completely remove the access policy, and you might still see the effect of the policy for a short time after you send the delete request.</p> <p>This operation is idempotent. You can invoke delete multiple times, even if there is no policy associated with the vault. For more information about vault access policies, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-access-policy.html">Amazon Glacier Access Control with Vault Access Policies</a>. </p>', 'DeleteVaultNotifications' => '<p>This operation deletes the notification configuration set for a vault. The operation is eventually consistent; that is, it might take some time for Amazon S3 Glacier to completely disable the notifications and you might still receive some notifications for a short time after you send the delete request.</p> <p>An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access Management (IAM) users don\'t have any permissions by default. You must grant them explicit permission to perform specific actions. For more information, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control Using AWS Identity and Access Management (IAM)</a>.</p> <p> For conceptual information and underlying REST API, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/configuring-notifications.html">Configuring Vault Notifications in Amazon S3 Glacier</a> and <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vault-notifications-delete.html">Delete Vault Notification Configuration </a> in the Amazon S3 Glacier Developer Guide. </p>', 'DescribeJob' => '<p>This operation returns information about a job you previously initiated, including the job initiation date, the user who initiated the job, the job status code/message and the Amazon SNS topic to notify after Amazon S3 Glacier (Glacier) completes the job. For more information about initiating a job, see <a>InitiateJob</a>. </p> <note> <p>This operation enables you to check the status of your job. However, it is strongly recommended that you set up an Amazon SNS topic and specify it in your initiate job request so that Glacier can notify the topic after it completes the job.</p> </note> <p>A job ID will not expire for at least 24 hours after Glacier completes the job.</p> <p>An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access Management (IAM) users don\'t have any permissions by default. You must grant them explicit permission to perform specific actions. For more information, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control Using AWS Identity and Access Management (IAM)</a>.</p> <p> For more information about using this operation, see the documentation for the underlying REST API <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-describe-job-get.html">Describe Job</a> in the <i>Amazon Glacier Developer Guide</i>. </p>', 'DescribeVault' => '<p>This operation returns information about a vault, including the vault\'s Amazon Resource Name (ARN), the date the vault was created, the number of archives it contains, and the total size of all the archives in the vault. The number of archives and their total size are as of the last inventory generation. This means that if you add or remove an archive from a vault, and then immediately use Describe Vault, the change in contents will not be immediately reflected. If you want to retrieve the latest inventory of the vault, use <a>InitiateJob</a>. Amazon S3 Glacier generates vault inventories approximately daily. For more information, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-inventory.html">Downloading a Vault Inventory in Amazon S3 Glacier</a>. </p> <p>An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access Management (IAM) users don\'t have any permissions by default. You must grant them explicit permission to perform specific actions. For more information, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control Using AWS Identity and Access Management (IAM)</a>.</p> <p>For conceptual information and underlying REST API, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/retrieving-vault-info.html">Retrieving Vault Metadata in Amazon S3 Glacier</a> and <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vault-get.html">Describe Vault </a> in the <i>Amazon Glacier Developer Guide</i>. </p>', 'GetDataRetrievalPolicy' => '<p>This operation returns the current data retrieval policy for the account and region specified in the GET request. For more information about data retrieval policies, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/data-retrieval-policy.html">Amazon Glacier Data Retrieval Policies</a>.</p>', 'GetJobOutput' => '<p>This operation downloads the output of the job you initiated using <a>InitiateJob</a>. Depending on the job type you specified when you initiated the job, the output will be either the content of an archive or a vault inventory.</p> <p>You can download all the job output or download a portion of the output by specifying a byte range. In the case of an archive retrieval job, depending on the byte range you specify, Amazon S3 Glacier (Glacier) returns the checksum for the portion of the data. You can compute the checksum on the client and verify that the values match to ensure the portion you downloaded is the correct data.</p> <p>A job ID will not expire for at least 24 hours after Glacier completes the job. That a byte range. For both archive and inventory retrieval jobs, you should verify the downloaded size against the size returned in the headers from the <b>Get Job Output</b> response.</p> <p>For archive retrieval jobs, you should also verify that the size is what you expected. If you download a portion of the output, the expected size is based on the range of bytes you specified. For example, if you specify a range of <code>bytes=0-1048575</code>, you should verify your download size is 1,048,576 bytes. If you download an entire archive, the expected size is the size of the archive when you uploaded it to Amazon S3 Glacier The expected size is also returned in the headers from the <b>Get Job Output</b> response.</p> <p>In the case of an archive retrieval job, depending on the byte range you specify, Glacier returns the checksum for the portion of the data. To ensure the portion you downloaded is the correct data, compute the checksum on the client, verify that the values match, and verify that the size is what you expected.</p> <p>A job ID does not expire for at least 24 hours after Glacier completes the job. That is, you can download the job output within the 24 hours period after Amazon Glacier completes the job.</p> <p>An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access Management (IAM) users don\'t have any permissions by default. You must grant them explicit permission to perform specific actions. For more information, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control Using AWS Identity and Access Management (IAM)</a>.</p> <p>For conceptual information and the underlying REST API, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-inventory.html">Downloading a Vault Inventory</a>, <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/downloading-an-archive.html">Downloading an Archive</a>, and <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-job-output-get.html">Get Job Output </a> </p>', 'GetVaultAccessPolicy' => '<p>This operation retrieves the <code>access-policy</code> subresource set on the vault; for more information on setting this subresource, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-SetVaultAccessPolicy.html">Set Vault Access Policy (PUT access-policy)</a>. If there is no access policy set on the vault, the operation returns a <code>404 Not found</code> error. For more information about vault access policies, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-access-policy.html">Amazon Glacier Access Control with Vault Access Policies</a>.</p>', 'GetVaultLock' => '<p>This operation retrieves the following attributes from the <code>lock-policy</code> subresource set on the specified vault: </p> <ul> <li> <p>The vault lock policy set on the vault.</p> </li> <li> <p>The state of the vault lock, which is either <code>InProgess</code> or <code>Locked</code>.</p> </li> <li> <p>When the lock ID expires. The lock ID is used to complete the vault locking process.</p> </li> <li> <p>When the vault lock was initiated and put into the <code>InProgress</code> state.</p> </li> </ul> <p>A vault lock is put into the <code>InProgress</code> state by calling <a>InitiateVaultLock</a>. A vault lock is put into the <code>Locked</code> state by calling <a>CompleteVaultLock</a>. You can abort the vault locking process by calling <a>AbortVaultLock</a>. For more information about the vault locking process, <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-lock.html">Amazon Glacier Vault Lock</a>. </p> <p>If there is no vault lock policy set on the vault, the operation returns a <code>404 Not found</code> error. For more information about vault lock policies, <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-lock-policy.html">Amazon Glacier Access Control with Vault Lock Policies</a>. </p>', 'GetVaultNotifications' => '<p>This operation retrieves the <code>notification-configuration</code> subresource of the specified vault.</p> <p>For information about setting a notification configuration on a vault, see <a>SetVaultNotifications</a>. If a notification configuration for a vault is not set, the operation returns a <code>404 Not Found</code> error. For more information about vault notifications, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/configuring-notifications.html">Configuring Vault Notifications in Amazon S3 Glacier</a>. </p> <p>An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access Management (IAM) users don\'t have any permissions by default. You must grant them explicit permission to perform specific actions. For more information, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control Using AWS Identity and Access Management (IAM)</a>.</p> <p>For conceptual information and underlying REST API, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/configuring-notifications.html">Configuring Vault Notifications in Amazon S3 Glacier</a> and <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vault-notifications-get.html">Get Vault Notification Configuration </a> in the <i>Amazon Glacier Developer Guide</i>. </p>', 'InitiateJob' => '<p>This operation initiates a job of the specified type, which can be a select, an archival retrieval, or a vault retrieval. For more information about using this operation, see the documentation for the underlying REST API <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-initiate-job-post.html">Initiate a Job</a>. </p>', 'InitiateMultipartUpload' => '<p>This operation initiates a multipart upload. Amazon S3 Glacier creates a multipart upload resource and returns its ID in the response. The multipart upload ID is used in subsequent requests to upload parts of an archive (see <a>UploadMultipartPart</a>).</p> <p>When you initiate a multipart upload, you specify the part size in number of bytes. The part size must be a megabyte (1024 KB) multiplied by a power of 2-for example, 1048576 (1 MB), 2097152 (2 MB), 4194304 (4 MB), 8388608 (8 MB), and so on. The minimum allowable part size is 1 MB, and the maximum is 4 GB.</p> <p>Every part you upload to this resource (see <a>UploadMultipartPart</a>), except the last one, must have the same size. The last one can be the same size or smaller. For example, suppose you want to upload a 16.2 MB file. If you initiate the multipart upload with a part size of 4 MB, you will upload four parts of 4 MB each and one part of 0.2 MB. </p> <note> <p>You don\'t need to know the size of the archive when you start a multipart upload because Amazon S3 Glacier does not require you to specify the overall archive size.</p> </note> <p>After you complete the multipart upload, Amazon S3 Glacier (Glacier) removes the multipart upload resource referenced by the ID. Glacier also removes the multipart upload resource if you cancel the multipart upload or it may be removed if there is no activity for a period of 24 hours.</p> <p>An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access Management (IAM) users don\'t have any permissions by default. You must grant them explicit permission to perform specific actions. For more information, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control Using AWS Identity and Access Management (IAM)</a>.</p> <p>For conceptual information and underlying REST API, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/uploading-archive-mpu.html">Uploading Large Archives in Parts (Multipart Upload)</a> and <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-initiate-upload.html">Initiate Multipart Upload</a> in the <i>Amazon Glacier Developer Guide</i>.</p>', 'InitiateVaultLock' => '<p>This operation initiates the vault locking process by doing the following:</p> <ul> <li> <p>Installing a vault lock policy on the specified vault.</p> </li> <li> <p>Setting the lock state of vault lock to <code>InProgress</code>.</p> </li> <li> <p>Returning a lock ID, which is used to complete the vault locking process.</p> </li> </ul> <p>You can set one vault lock policy for each vault and this policy can be up to 20 KB in size. For more information about vault lock policies, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-lock-policy.html">Amazon Glacier Access Control with Vault Lock Policies</a>. </p> <p>You must complete the vault locking process within 24 hours after the vault lock enters the <code>InProgress</code> state. After the 24 hour window ends, the lock ID expires, the vault automatically exits the <code>InProgress</code> state, and the vault lock policy is removed from the vault. You call <a>CompleteVaultLock</a> to complete the vault locking process by setting the state of the vault lock to <code>Locked</code>. </p> <p>After a vault lock is in the <code>Locked</code> state, you cannot initiate a new vault lock for the vault.</p> <p>You can abort the vault locking process by calling <a>AbortVaultLock</a>. You can get the state of the vault lock by calling <a>GetVaultLock</a>. For more information about the vault locking process, <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-lock.html">Amazon Glacier Vault Lock</a>.</p> <p>If this operation is called when the vault lock is in the <code>InProgress</code> state, the operation returns an <code>AccessDeniedException</code> error. When the vault lock is in the <code>InProgress</code> state you must call <a>AbortVaultLock</a> before you can initiate a new vault lock policy. </p>', 'ListJobs' => '<p>This operation lists jobs for a vault, including jobs that are in-progress and jobs that have recently finished. The List Job operation returns a list of these jobs sorted by job initiation time.</p> <note> <p>Amazon Glacier retains recently completed jobs for a period before deleting them; however, it eventually removes completed jobs. The output of completed jobs can be retrieved. Retaining completed jobs for a period of time after they have completed enables you to get a job output in the event you miss the job completion notification or your first attempt to download it fails. For example, suppose you start an archive retrieval job to download an archive. After the job completes, you start to download the archive but encounter a network error. In this scenario, you can retry and download the archive while the job exists.</p> </note> <p>The List Jobs operation supports pagination. You should always check the response <code>Marker</code> field. If there are no more jobs to list, the <code>Marker</code> field is set to <code>null</code>. If there are more jobs to list, the <code>Marker</code> field is set to a non-null value, which you can use to continue the pagination of the list. To return a list of jobs that begins at a specific job, set the marker request parameter to the <code>Marker</code> value for that job that you obtained from a previous List Jobs request.</p> <p>You can set a maximum limit for the number of jobs returned in the response by specifying the <code>limit</code> parameter in the request. The default limit is 50. The number of jobs returned might be fewer than the limit, but the number of returned jobs never exceeds the limit.</p> <p>Additionally, you can filter the jobs list returned by specifying the optional <code>statuscode</code> parameter or <code>completed</code> parameter, or both. Using the <code>statuscode</code> parameter, you can specify to return only jobs that match either the <code>InProgress</code>, <code>Succeeded</code>, or <code>Failed</code> status. Using the <code>completed</code> parameter, you can specify to return only jobs that were completed (<code>true</code>) or jobs that were not completed (<code>false</code>).</p> <p>For more information about using this operation, see the documentation for the underlying REST API <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-jobs-get.html">List Jobs</a>. </p>', 'ListMultipartUploads' => '<p>This operation lists in-progress multipart uploads for the specified vault. An in-progress multipart upload is a multipart upload that has been initiated by an <a>InitiateMultipartUpload</a> request, but has not yet been completed or aborted. The list returned in the List Multipart Upload response has no guaranteed order. </p> <p>The List Multipart Uploads operation supports pagination. By default, this operation returns up to 50 multipart uploads in the response. You should always check the response for a <code>marker</code> at which to continue the list; if there are no more items the <code>marker</code> is <code>null</code>. To return a list of multipart uploads that begins at a specific upload, set the <code>marker</code> request parameter to the value you obtained from a previous List Multipart Upload request. You can also limit the number of uploads returned in the response by specifying the <code>limit</code> parameter in the request.</p> <p>Note the difference between this operation and listing parts (<a>ListParts</a>). The List Multipart Uploads operation lists all multipart uploads for a vault and does not require a multipart upload ID. The List Parts operation requires a multipart upload ID since parts are associated with a single upload.</p> <p>An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access Management (IAM) users don\'t have any permissions by default. You must grant them explicit permission to perform specific actions. For more information, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control Using AWS Identity and Access Management (IAM)</a>.</p> <p>For conceptual information and the underlying REST API, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/working-with-archives.html">Working with Archives in Amazon S3 Glacier</a> and <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-list-uploads.html">List Multipart Uploads </a> in the <i>Amazon Glacier Developer Guide</i>.</p>', 'ListParts' => '<p>This operation lists the parts of an archive that have been uploaded in a specific multipart upload. You can make this request at any time during an in-progress multipart upload before you complete the upload (see <a>CompleteMultipartUpload</a>. List Parts returns an error for completed uploads. The list returned in the List Parts response is sorted by part range. </p> <p>The List Parts operation supports pagination. By default, this operation returns up to 50 uploaded parts in the response. You should always check the response for a <code>marker</code> at which to continue the list; if there are no more items the <code>marker</code> is <code>null</code>. To return a list of parts that begins at a specific part, set the <code>marker</code> request parameter to the value you obtained from a previous List Parts request. You can also limit the number of parts returned in the response by specifying the <code>limit</code> parameter in the request. </p> <p>An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access Management (IAM) users don\'t have any permissions by default. You must grant them explicit permission to perform specific actions. For more information, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control Using AWS Identity and Access Management (IAM)</a>.</p> <p>For conceptual information and the underlying REST API, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/working-with-archives.html">Working with Archives in Amazon S3 Glacier</a> and <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-list-parts.html">List Parts</a> in the <i>Amazon Glacier Developer Guide</i>.</p>', 'ListProvisionedCapacity' => '<p>This operation lists the provisioned capacity units for the specified AWS account.</p>', 'ListTagsForVault' => '<p>This operation lists all the tags attached to a vault. The operation returns an empty map if there are no tags. For more information about tags, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/tagging.html">Tagging Amazon S3 Glacier Resources</a>.</p>', 'ListVaults' => '<p>This operation lists all vaults owned by the calling user\'s account. The list returned in the response is ASCII-sorted by vault name.</p> <p>By default, this operation returns up to 10 items. If there are more vaults to list, the response <code>marker</code> field contains the vault Amazon Resource Name (ARN) at which to continue the list with a new List Vaults request; otherwise, the <code>marker</code> field is <code>null</code>. To return a list of vaults that begins at a specific vault, set the <code>marker</code> request parameter to the vault ARN you obtained from a previous List Vaults request. You can also limit the number of vaults returned in the response by specifying the <code>limit</code> parameter in the request. </p> <p>An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access Management (IAM) users don\'t have any permissions by default. You must grant them explicit permission to perform specific actions. For more information, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control Using AWS Identity and Access Management (IAM)</a>.</p> <p>For conceptual information and underlying REST API, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/retrieving-vault-info.html">Retrieving Vault Metadata in Amazon S3 Glacier</a> and <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vaults-get.html">List Vaults </a> in the <i>Amazon Glacier Developer Guide</i>. </p>', 'PurchaseProvisionedCapacity' => '<p>This operation purchases a provisioned capacity unit for an AWS account. </p>', 'RemoveTagsFromVault' => '<p>This operation removes one or more tags from the set of tags attached to a vault. For more information about tags, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/tagging.html">Tagging Amazon S3 Glacier Resources</a>. This operation is idempotent. The operation will be successful, even if there are no tags attached to the vault. </p>', 'SetDataRetrievalPolicy' => '<p>This operation sets and then enacts a data retrieval policy in the region specified in the PUT request. You can set one policy per region for an AWS account. The policy is enacted within a few minutes of a successful PUT operation.</p> <p>The set policy operation does not affect retrieval jobs that were in progress before the policy was enacted. For more information about data retrieval policies, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/data-retrieval-policy.html">Amazon Glacier Data Retrieval Policies</a>. </p>', 'SetVaultAccessPolicy' => '<p>This operation configures an access policy for a vault and will overwrite an existing policy. To configure a vault access policy, send a PUT request to the <code>access-policy</code> subresource of the vault. An access policy is specific to a vault and is also called a vault subresource. You can set one access policy per vault and the policy can be up to 20 KB in size. For more information about vault access policies, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-access-policy.html">Amazon Glacier Access Control with Vault Access Policies</a>. </p>', 'SetVaultNotifications' => '<p>This operation configures notifications that will be sent when specific events happen to a vault. By default, you don\'t get any notifications.</p> <p>To configure vault notifications, send a PUT request to the <code>notification-configuration</code> subresource of the vault. The request should include a JSON document that provides an Amazon SNS topic and specific events for which you want Amazon S3 Glacier to send notifications to the topic.</p> <p>Amazon SNS topics must grant permission to the vault to be allowed to publish notifications to the topic. You can configure a vault to publish a notification for the following vault events:</p> <ul> <li> <p> <b>ArchiveRetrievalCompleted</b> This event occurs when a job that was initiated for an archive retrieval is completed (<a>InitiateJob</a>). The status of the completed job can be "Succeeded" or "Failed". The notification sent to the SNS topic is the same output as returned from <a>DescribeJob</a>. </p> </li> <li> <p> <b>InventoryRetrievalCompleted</b> This event occurs when a job that was initiated for an inventory retrieval is completed (<a>InitiateJob</a>). The status of the completed job can be "Succeeded" or "Failed". The notification sent to the SNS topic is the same output as returned from <a>DescribeJob</a>. </p> </li> </ul> <p>An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access Management (IAM) users don\'t have any permissions by default. You must grant them explicit permission to perform specific actions. For more information, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control Using AWS Identity and Access Management (IAM)</a>.</p> <p>For conceptual information and underlying REST API, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/configuring-notifications.html">Configuring Vault Notifications in Amazon S3 Glacier</a> and <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vault-notifications-put.html">Set Vault Notification Configuration </a> in the <i>Amazon Glacier Developer Guide</i>. </p>', 'UploadArchive' => '<p>This operation adds an archive to a vault. This is a synchronous operation, and for a successful upload, your data is durably persisted. Amazon S3 Glacier returns the archive ID in the <code>x-amz-archive-id</code> header of the response. </p> <p>You must use the archive ID to access your data in Amazon S3 Glacier. After you upload an archive, you should save the archive ID returned so that you can retrieve or delete the archive later. Besides saving the archive ID, you can also index it and give it a friendly name to allow for better searching. You can also use the optional archive description field to specify how the archive is referred to in an external index of archives, such as you might create in Amazon DynamoDB. You can also get the vault inventory to obtain a list of archive IDs in a vault. For more information, see <a>InitiateJob</a>. </p> <p>You must provide a SHA256 tree hash of the data you are uploading. For information about computing a SHA256 tree hash, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/checksum-calculations.html">Computing Checksums</a>. </p> <p>You can optionally specify an archive description of up to 1,024 printable ASCII characters. You can get the archive description when you either retrieve the archive or get the vault inventory. For more information, see <a>InitiateJob</a>. Amazon Glacier does not interpret the description in any way. An archive description does not need to be unique. You cannot use the description to retrieve or sort the archive list. </p> <p>Archives are immutable. After you upload an archive, you cannot edit the archive or its description.</p> <p>An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access Management (IAM) users don\'t have any permissions by default. You must grant them explicit permission to perform specific actions. For more information, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control Using AWS Identity and Access Management (IAM)</a>.</p> <p> For conceptual information and underlying REST API, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/uploading-an-archive.html">Uploading an Archive in Amazon Glacier</a> and <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-archive-post.html">Upload Archive</a> in the <i>Amazon Glacier Developer Guide</i>. </p>', 'UploadMultipartPart' => '<p>This operation uploads a part of an archive. You can upload archive parts in any order. You can also upload them in parallel. You can upload up to 10,000 parts for a multipart upload.</p> <p>Amazon Glacier rejects your upload part request if any of the following conditions is true:</p> <ul> <li> <p> <b>SHA256 tree hash does not match</b>To ensure that part data is not corrupted in transmission, you compute a SHA256 tree hash of the part and include it in your request. Upon receiving the part data, Amazon S3 Glacier also computes a SHA256 tree hash. If these hash values don\'t match, the operation fails. For information about computing a SHA256 tree hash, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/checksum-calculations.html">Computing Checksums</a>.</p> </li> <li> <p> <b>Part size does not match</b>The size of each part except the last must match the size specified in the corresponding <a>InitiateMultipartUpload</a> request. The size of the last part must be the same size as, or smaller than, the specified size.</p> <note> <p>If you upload a part whose size is smaller than the part size you specified in your initiate multipart upload request and that part is not the last part, then the upload part request will succeed. However, the subsequent Complete Multipart Upload request will fail.</p> </note> </li> <li> <p> <b>Range does not align</b>The byte range value in the request does not align with the part size specified in the corresponding initiate request. For example, if you specify a part size of 4194304 bytes (4 MB), then 0 to 4194303 bytes (4 MB - 1) and 4194304 (4 MB) to 8388607 (8 MB - 1) are valid part ranges. However, if you set a range value of 2 MB to 6 MB, the range does not align with the part size and the upload will fail. </p> </li> </ul> <p>This operation is idempotent. If you upload the same part multiple times, the data included in the most recent request overwrites the previously uploaded data.</p> <p>An AWS account has full permission to perform all operations (actions). However, AWS Identity and Access Management (IAM) users don\'t have any permissions by default. You must grant them explicit permission to perform specific actions. For more information, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html">Access Control Using AWS Identity and Access Management (IAM)</a>.</p> <p> For conceptual information and underlying REST API, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/uploading-archive-mpu.html">Uploading Large Archives in Parts (Multipart Upload)</a> and <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-upload-part.html">Upload Part </a> in the <i>Amazon Glacier Developer Guide</i>.</p>', ], 'shapes' => [ 'AbortMultipartUploadInput' => [ 'base' => '<p>Provides options to abort a multipart upload identified by the upload ID.</p> <p>For information about the underlying REST API, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-abort-upload.html">Abort Multipart Upload</a>. For conceptual information, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/working-with-archives.html">Working with Archives in Amazon S3 Glacier</a>.</p>', 'refs' => [], ], 'AbortVaultLockInput' => [ 'base' => '<p>The input values for <code>AbortVaultLock</code>.</p>', 'refs' => [], ], 'AccessControlPolicyList' => [ 'base' => NULL, 'refs' => [ 'S3Location$AccessControlList' => '<p>A list of grants that control access to the staged results.</p>', ], ], 'ActionCode' => [ 'base' => NULL, 'refs' => [ 'GlacierJobDescription$Action' => '<p>The job type. This value is either <code>ArchiveRetrieval</code>, <code>InventoryRetrieval</code>, or <code>Select</code>. </p>', ], ], 'AddTagsToVaultInput' => [ 'base' => '<p>The input values for <code>AddTagsToVault</code>.</p>', 'refs' => [], ], 'ArchiveCreationOutput' => [ 'base' => '<p>Contains the Amazon S3 Glacier response to your request.</p> <p>For information about the underlying REST API, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-archive-post.html">Upload Archive</a>. For conceptual information, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/working-with-archives.html">Working with Archives in Amazon S3 Glacier</a>.</p>', 'refs' => [], ], 'CSVInput' => [ 'base' => '<p>Contains information about the comma-separated value (CSV) file to select from.</p>', 'refs' => [ 'InputSerialization$csv' => '<p>Describes the serialization of a CSV-encoded object.</p>', ], ], 'CSVOutput' => [ 'base' => '<p>Contains information about the comma-separated value (CSV) file that the job results are stored in.</p>', 'refs' => [ 'OutputSerialization$csv' => '<p>Describes the serialization of CSV-encoded query results.</p>', ], ], 'CannedACL' => [ 'base' => NULL, 'refs' => [ 'S3Location$CannedACL' => '<p>The canned access control list (ACL) to apply to the job results.</p>', ], ], 'CompleteMultipartUploadInput' => [ 'base' => '<p>Provides options to complete a multipart upload operation. This informs Amazon Glacier that all the archive parts have been uploaded and Amazon S3 Glacier (Glacier) can now assemble the archive from the uploaded parts. After assembling and saving the archive to the vault, Glacier returns the URI path of the newly created archive resource.</p>', 'refs' => [], ], 'CompleteVaultLockInput' => [ 'base' => '<p>The input values for <code>CompleteVaultLock</code>.</p>', 'refs' => [], ], 'CreateVaultInput' => [ 'base' => '<p>Provides options to create a vault.</p>', 'refs' => [], ], 'CreateVaultOutput' => [ 'base' => '<p>Contains the Amazon S3 Glacier response to your request.</p>', 'refs' => [], ], 'DataRetrievalPolicy' => [ 'base' => '<p>Data retrieval policy.</p>', 'refs' => [ 'GetDataRetrievalPolicyOutput$Policy' => '<p>Contains the returned data retrieval policy in JSON format.</p>', 'SetDataRetrievalPolicyInput$Policy' => '<p>The data retrieval policy in JSON format.</p>', ], ], 'DataRetrievalRule' => [ 'base' => '<p>Data retrieval policy rule.</p>', 'refs' => [ 'DataRetrievalRulesList$member' => NULL, ], ], 'DataRetrievalRulesList' => [ 'base' => NULL, 'refs' => [ 'DataRetrievalPolicy$Rules' => '<p>The policy rule. Although this is a list type, currently there must be only one rule, which contains a Strategy field and optionally a BytesPerHour field.</p>', ], ], 'DateTime' => [ 'base' => NULL, 'refs' => [ 'InventoryRetrievalJobDescription$StartDate' => '<p>The start of the date range in Universal Coordinated Time (UTC) for vault inventory retrieval that includes archives created on or after this date. This value should be a string in the ISO 8601 date format, for example <code>2013-03-20T17:03:43Z</code>.</p>', 'InventoryRetrievalJobDescription$EndDate' => '<p>The end of the date range in UTC for vault inventory retrieval that includes archives created before this date. This value should be a string in the ISO 8601 date format, for example <code>2013-03-20T17:03:43Z</code>.</p>', ], ], 'DeleteArchiveInput' => [ 'base' => '<p>Provides options for deleting an archive from an Amazon S3 Glacier vault.</p>', 'refs' => [], ], 'DeleteVaultAccessPolicyInput' => [ 'base' => '<p>DeleteVaultAccessPolicy input.</p>', 'refs' => [], ], 'DeleteVaultInput' => [ 'base' => '<p>Provides options for deleting a vault from Amazon S3 Glacier.</p>', 'refs' => [], ], 'DeleteVaultNotificationsInput' => [ 'base' => '<p>Provides options for deleting a vault notification configuration from an Amazon Glacier vault.</p>', 'refs' => [], ], 'DescribeJobInput' => [ 'base' => '<p>Provides options for retrieving a job description.</p>', 'refs' => [], ], 'DescribeVaultInput' => [ 'base' => '<p>Provides options for retrieving metadata for a specific vault in Amazon Glacier.</p>', 'refs' => [], ], 'DescribeVaultOutput' => [ 'base' => '<p>Contains the Amazon S3 Glacier response to your request.</p>', 'refs' => [ 'VaultList$member' => NULL, ], ], 'Encryption' => [ 'base' => '<p>Contains information about the encryption used to store the job results in Amazon S3. </p>', 'refs' => [ 'S3Location$Encryption' => '<p>Contains information about the encryption used to store the job results in Amazon S3.</p>', ], ], 'EncryptionType' => [ 'base' => NULL, 'refs' => [ 'Encryption$EncryptionType' => '<p>The server-side encryption algorithm used when storing job results in Amazon S3, for example <code>AES256</code> or <code>aws:kms</code>.</p>', ], ], 'ExpressionType' => [ 'base' => NULL, 'refs' => [ 'SelectParameters$ExpressionType' => '<p>The type of the provided expression, for example <code>SQL</code>.</p>', ], ], 'FileHeaderInfo' => [ 'base' => NULL, 'refs' => [ 'CSVInput$FileHeaderInfo' => '<p>Describes the first line of input. Valid values are <code>None</code>, <code>Ignore</code>, and <code>Use</code>.</p>', ], ], 'GetDataRetrievalPolicyInput' => [ 'base' => '<p>Input for GetDataRetrievalPolicy.</p>', 'refs' => [], ], 'GetDataRetrievalPolicyOutput' => [ 'base' => '<p>Contains the Amazon S3 Glacier response to the <code>GetDataRetrievalPolicy</code> request.</p>', 'refs' => [], ], 'GetJobOutputInput' => [ 'base' => '<p>Provides options for downloading output of an Amazon S3 Glacier job.</p>', 'refs' => [], ], 'GetJobOutputOutput' => [ 'base' => '<p>Contains the Amazon S3 Glacier response to your request.</p>', 'refs' => [], ], 'GetVaultAccessPolicyInput' => [ 'base' => '<p>Input for GetVaultAccessPolicy.</p>', 'refs' => [], ], 'GetVaultAccessPolicyOutput' => [ 'base' => '<p>Output for GetVaultAccessPolicy.</p>', 'refs' => [], ], 'GetVaultLockInput' => [ 'base' => '<p>The input values for <code>GetVaultLock</code>.</p>', 'refs' => [], ], 'GetVaultLockOutput' => [ 'base' => '<p>Contains the Amazon S3 Glacier response to your request.</p>', 'refs' => [], ], 'GetVaultNotificationsInput' => [ 'base' => '<p>Provides options for retrieving the notification configuration set on an Amazon Glacier vault.</p>', 'refs' => [], ], 'GetVaultNotificationsOutput' => [ 'base' => '<p>Contains the Amazon S3 Glacier response to your request.</p>', 'refs' => [], ], 'GlacierJobDescription' => [ 'base' => '<p>Contains the description of an Amazon S3 Glacier job.</p>', 'refs' => [ 'JobList$member' => NULL, ], ], 'Grant' => [ 'base' => '<p>Contains information about a grant.</p>', 'refs' => [ 'AccessControlPolicyList$member' => NULL, ], ], 'Grantee' => [ 'base' => '<p>Contains information about the grantee.</p>', 'refs' => [ 'Grant$Grantee' => '<p>The grantee.</p>', ], ], 'InitiateJobInput' => [ 'base' => '<p>Provides options for initiating an Amazon S3 Glacier job.</p>', 'refs' => [], ], 'InitiateJobOutput' => [ 'base' => '<p>Contains the Amazon S3 Glacier response to your request.</p>', 'refs' => [], ], 'InitiateMultipartUploadInput' => [ 'base' => '<p>Provides options for initiating a multipart upload to an Amazon S3 Glacier vault.</p>', 'refs' => [], ], 'InitiateMultipartUploadOutput' => [ 'base' => '<p>The Amazon S3 Glacier response to your request.</p>', 'refs' => [], ], 'InitiateVaultLockInput' => [ 'base' => '<p>The input values for <code>InitiateVaultLock</code>.</p>', 'refs' => [], ], 'InitiateVaultLockOutput' => [ 'base' => '<p>Contains the Amazon S3 Glacier response to your request.</p>', 'refs' => [], ], 'InputSerialization' => [ 'base' => '<p>Describes how the archive is serialized.</p>', 'refs' => [ 'SelectParameters$InputSerialization' => '<p>Describes the serialization format of the object.</p>', ], ], 'InsufficientCapacityException' => [ 'base' => '<p>Returned if there is insufficient capacity to process this expedited request. This error only applies to expedited retrievals and not to standard or bulk retrievals.</p>', 'refs' => [], ], 'InvalidParameterValueException' => [ 'base' => '<p>Returned if a parameter of the request is incorrectly specified.</p>', 'refs' => [], ], 'InventoryRetrievalJobDescription' => [ 'base' => '<p>Describes the options for a range inventory retrieval job.</p>', 'refs' => [ 'GlacierJobDescription$InventoryRetrievalParameters' => '<p>Parameters used for range inventory retrieval.</p>', ], ], 'InventoryRetrievalJobInput' => [ 'base' => '<p>Provides options for specifying a range inventory retrieval job.</p>', 'refs' => [ 'JobParameters$InventoryRetrievalParameters' => '<p>Input parameters used for range inventory retrieval.</p>', ], ], 'JobList' => [ 'base' => NULL, 'refs' => [ 'ListJobsOutput$JobList' => '<p>A list of job objects. Each job object contains metadata describing the job.</p>', ], ], 'JobParameters' => [ 'base' => '<p>Provides options for defining a job.</p>', 'refs' => [ 'InitiateJobInput$jobParameters' => '<p>Provides options for specifying job information.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>Returned if the request results in a vault or account limit being exceeded.</p>', 'refs' => [], ], 'ListJobsInput' => [ 'base' => '<p>Provides options for retrieving a job list for an Amazon S3 Glacier vault.</p>', 'refs' => [], ], 'ListJobsOutput' => [ 'base' => '<p>Contains the Amazon S3 Glacier response to your request.</p>', 'refs' => [], ], 'ListMultipartUploadsInput' => [ 'base' => '<p>Provides options for retrieving list of in-progress multipart uploads for an Amazon Glacier vault.</p>', 'refs' => [], ], 'ListMultipartUploadsOutput' => [ 'base' => '<p>Contains the Amazon S3 Glacier response to your request.</p>', 'refs' => [], ], 'ListPartsInput' => [ 'base' => '<p>Provides options for retrieving a list of parts of an archive that have been uploaded in a specific multipart upload.</p>', 'refs' => [], ], 'ListPartsOutput' => [ 'base' => '<p>Contains the Amazon S3 Glacier response to your request.</p>', 'refs' => [], ], 'ListProvisionedCapacityInput' => [ 'base' => NULL, 'refs' => [], ], 'ListProvisionedCapacityOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForVaultInput' => [ 'base' => '<p>The input value for <code>ListTagsForVaultInput</code>.</p>', 'refs' => [], ], 'ListTagsForVaultOutput' => [ 'base' => '<p>Contains the Amazon S3 Glacier response to your request.</p>', 'refs' => [], ], 'ListVaultsInput' => [ 'base' => '<p>Provides options to retrieve the vault list owned by the calling user\'s account. The list provides metadata information for each vault.</p>', 'refs' => [], ], 'ListVaultsOutput' => [ 'base' => '<p>Contains the Amazon S3 Glacier response to your request.</p>', 'refs' => [], ], 'MissingParameterValueException' => [ 'base' => '<p>Returned if a required header or parameter is missing from the request.</p>', 'refs' => [], ], 'NotificationEventList' => [ 'base' => NULL, 'refs' => [ 'VaultNotificationConfig$Events' => '<p>A list of one or more events for which Amazon S3 Glacier will send a notification to the specified Amazon SNS topic.</p>', ], ], 'NullableLong' => [ 'base' => NULL, 'refs' => [ 'DataRetrievalRule$BytesPerHour' => '<p>The maximum number of bytes that can be retrieved in an hour.</p> <p>This field is required only if the value of the Strategy field is <code>BytesPerHour</code>. Your PUT operation will be rejected if the Strategy field is not set to <code>BytesPerHour</code> and you set this field.</p>', ], ], 'OutputLocation' => [ 'base' => '<p>Contains information about the location where the select job results are stored.</p>', 'refs' => [ 'GlacierJobDescription$OutputLocation' => '<p>Contains the location where the data from the select job is stored.</p>', 'JobParameters$OutputLocation' => '<p>Contains information about the location where the select job results are stored.</p>', ], ], 'OutputSerialization' => [ 'base' => '<p>Describes how the select output is serialized.</p>', 'refs' => [ 'SelectParameters$OutputSerialization' => '<p>Describes how the results of the select job are serialized.</p>', ], ], 'PartList' => [ 'base' => NULL, 'refs' => [ 'ListPartsOutput$Parts' => '<p>A list of the part sizes of the multipart upload. Each object in the array contains a <code>RangeBytes</code> and <code>sha256-tree-hash</code> name/value pair.</p>', ], ], 'PartListElement' => [ 'base' => '<p>A list of the part sizes of the multipart upload.</p>', 'refs' => [ 'PartList$member' => NULL, ], ], 'Permission' => [ 'base' => NULL, 'refs' => [ 'Grant$Permission' => '<p>Specifies the permission given to the grantee. </p>', ], ], 'PolicyEnforcedException' => [ 'base' => '<p>Returned if a retrieval job would exceed the current data policy\'s retrieval rate limit. For more information about data retrieval policies,</p>', 'refs' => [], ], 'ProvisionedCapacityDescription' => [ 'base' => '<p>The definition for a provisioned capacity unit.</p>', 'refs' => [ 'ProvisionedCapacityList$member' => NULL, ], ], 'ProvisionedCapacityList' => [ 'base' => NULL, 'refs' => [ 'ListProvisionedCapacityOutput$ProvisionedCapacityList' => '<p>The response body contains the following JSON fields.</p>', ], ], 'PurchaseProvisionedCapacityInput' => [ 'base' => NULL, 'refs' => [], ], 'PurchaseProvisionedCapacityOutput' => [ 'base' => NULL, 'refs' => [], ], 'QuoteFields' => [ 'base' => NULL, 'refs' => [ 'CSVOutput$QuoteFields' => '<p>A value that indicates whether all output fields should be contained within quotation marks.</p>', ], ], 'RemoveTagsFromVaultInput' => [ 'base' => '<p>The input value for <code>RemoveTagsFromVaultInput</code>.</p>', 'refs' => [], ], 'RequestTimeoutException' => [ 'base' => '<p>Returned if, when uploading an archive, Amazon S3 Glacier times out while receiving the upload.</p>', 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>Returned if the specified resource (such as a vault, upload ID, or job ID) doesn\'t exist.</p>', 'refs' => [], ], 'S3Location' => [ 'base' => '<p>Contains information about the location in Amazon S3 where the select job results are stored.</p>', 'refs' => [ 'OutputLocation$S3' => '<p>Describes an S3 location that will receive the results of the job request.</p>', ], ], 'SelectParameters' => [ 'base' => '<p>Contains information about the parameters used for a select.</p>', 'refs' => [ 'GlacierJobDescription$SelectParameters' => '<p>Contains the parameters used for a select.</p>', 'JobParameters$SelectParameters' => '<p>Contains the parameters that define a job.</p>', ], ], 'ServiceUnavailableException' => [ 'base' => '<p>Returned if the service cannot complete the request.</p>', 'refs' => [], ], 'SetDataRetrievalPolicyInput' => [ 'base' => '<p>SetDataRetrievalPolicy input.</p>', 'refs' => [], ], 'SetVaultAccessPolicyInput' => [ 'base' => '<p>SetVaultAccessPolicy input.</p>', 'refs' => [], ], 'SetVaultNotificationsInput' => [ 'base' => '<p>Provides options to configure notifications that will be sent when specific events happen to a vault.</p>', 'refs' => [], ], 'Size' => [ 'base' => NULL, 'refs' => [ 'GlacierJobDescription$ArchiveSizeInBytes' => '<p>For an archive retrieval job, this value is the size in bytes of the archive being requested for download. For an inventory retrieval or select job, this value is null.</p>', 'GlacierJobDescription$InventorySizeInBytes' => '<p>For an inventory retrieval job, this value is the size in bytes of the inventory requested for download. For an archive retrieval or select job, this value is null.</p>', ], ], 'StatusCode' => [ 'base' => NULL, 'refs' => [ 'GlacierJobDescription$StatusCode' => '<p>The status code can be <code>InProgress</code>, <code>Succeeded</code>, or <code>Failed</code>, and indicates the status of the job.</p>', ], ], 'StorageClass' => [ 'base' => NULL, 'refs' => [ 'S3Location$StorageClass' => '<p>The storage class used to store the job results.</p>', ], ], 'Stream' => [ 'base' => NULL, 'refs' => [ 'GetJobOutputOutput$body' => '<p>The job data, either archive data or inventory data.</p>', 'UploadArchiveInput$body' => '<p>The data to upload.</p>', 'UploadMultipartPartInput$body' => '<p>The data to upload.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagMap$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'RemoveTagsFromVaultInput$TagKeys' => '<p>A list of tag keys. Each corresponding tag is removed from the vault.</p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'AddTagsToVaultInput$Tags' => '<p>The tags to add to the vault. Each tag is composed of a key and a value. The value can be an empty string.</p>', 'ListTagsForVaultOutput$Tags' => '<p>The tags attached to the vault. Each tag is composed of a key and a value.</p>', ], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagMap$value' => NULL, ], ], 'Type' => [ 'base' => NULL, 'refs' => [ 'Grantee$Type' => '<p>Type of grantee</p>', ], ], 'UploadArchiveInput' => [ 'base' => '<p>Provides options to add an archive to a vault.</p>', 'refs' => [], ], 'UploadListElement' => [ 'base' => '<p>A list of in-progress multipart uploads for a vault.</p>', 'refs' => [ 'UploadsList$member' => NULL, ], ], 'UploadMultipartPartInput' => [ 'base' => '<p>Provides options to upload a part of an archive in a multipart upload operation.</p>', 'refs' => [], ], 'UploadMultipartPartOutput' => [ 'base' => '<p>Contains the Amazon S3 Glacier response to your request.</p>', 'refs' => [], ], 'UploadsList' => [ 'base' => NULL, 'refs' => [ 'ListMultipartUploadsOutput$UploadsList' => '<p>A list of in-progress multipart uploads.</p>', ], ], 'VaultAccessPolicy' => [ 'base' => '<p>Contains the vault access policy.</p>', 'refs' => [ 'GetVaultAccessPolicyOutput$policy' => '<p>Contains the returned vault access policy as a JSON string.</p>', 'SetVaultAccessPolicyInput$policy' => '<p>The vault access policy as a JSON string.</p>', ], ], 'VaultList' => [ 'base' => NULL, 'refs' => [ 'ListVaultsOutput$VaultList' => '<p>List of vaults.</p>', ], ], 'VaultLockPolicy' => [ 'base' => '<p>Contains the vault lock policy.</p>', 'refs' => [ 'InitiateVaultLockInput$policy' => '<p>The vault lock policy as a JSON string, which uses "\\" as an escape character.</p>', ], ], 'VaultNotificationConfig' => [ 'base' => '<p>Represents a vault\'s notification configuration.</p>', 'refs' => [ 'GetVaultNotificationsOutput$vaultNotificationConfig' => '<p>Returns the notification configuration set on the vault.</p>', 'SetVaultNotificationsInput$vaultNotificationConfig' => '<p>Provides options for specifying notification configuration.</p>', ], ], 'boolean' => [ 'base' => NULL, 'refs' => [ 'GlacierJobDescription$Completed' => '<p>The job status. When a job is completed, you get the job\'s output using Get Job Output (GET output).</p>', ], ], 'hashmap' => [ 'base' => NULL, 'refs' => [ 'S3Location$Tagging' => '<p>The tag-set that is applied to the job results.</p>', 'S3Location$UserMetadata' => '<p>A map of metadata to store with the job results in Amazon S3.</p>', ], ], 'httpstatus' => [ 'base' => NULL, 'refs' => [ 'GetJobOutputOutput$status' => '<p>The HTTP response code for a job output request. The value depends on whether a range was specified in the request.</p>', ], ], 'long' => [ 'base' => NULL, 'refs' => [ 'DescribeVaultOutput$NumberOfArchives' => '<p>The number of archives in the vault as of the last inventory date. This field will return <code>null</code> if an inventory has not yet run on the vault, for example if you just created the vault.</p>', 'DescribeVaultOutput$SizeInBytes' => '<p>Total size, in bytes, of the archives in the vault as of the last inventory date. This field will return null if an inventory has not yet run on the vault, for example if you just created the vault.</p>', 'ListPartsOutput$PartSizeInBytes' => '<p>The part size in bytes. This is the same value that you specified in the Initiate Multipart Upload request.</p>', 'UploadListElement$PartSizeInBytes' => '<p>The part size, in bytes, specified in the Initiate Multipart Upload request. This is the size of all the parts in the upload except the last part, which may be smaller than this size.</p>', ], ], 'string' => [ 'base' => NULL, 'refs' => [ 'AbortMultipartUploadInput$accountId' => '<p>The <code>AccountId</code> value is the AWS account ID of the account that owns the vault. You can either specify an AWS account ID or optionally a single \'<code>-</code>\' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If you use an account ID, do not include any hyphens (\'-\') in the ID.</p>', 'AbortMultipartUploadInput$vaultName' => '<p>The name of the vault.</p>', 'AbortMultipartUploadInput$uploadId' => '<p>The upload ID of the multipart upload to delete.</p>', 'AbortVaultLockInput$accountId' => '<p>The <code>AccountId</code> value is the AWS account ID. This value must match the AWS account ID associated with the credentials used to sign the request. You can either specify an AWS account ID or optionally a single \'<code>-</code>\' (hyphen), in which case Amazon Glacier uses the AWS account ID associated with the credentials used to sign the request. If you specify your account ID, do not include any hyphens (\'-\') in the ID.</p>', 'AbortVaultLockInput$vaultName' => '<p>The name of the vault.</p>', 'AddTagsToVaultInput$accountId' => '<p>The <code>AccountId</code> value is the AWS account ID of the account that owns the vault. You can either specify an AWS account ID or optionally a single \'<code>-</code>\' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If you use an account ID, do not include any hyphens (\'-\') in the ID.</p>', 'AddTagsToVaultInput$vaultName' => '<p>The name of the vault.</p>', 'ArchiveCreationOutput$location' => '<p>The relative URI path of the newly added archive resource.</p>', 'ArchiveCreationOutput$checksum' => '<p>The checksum of the archive computed by Amazon S3 Glacier.</p>', 'ArchiveCreationOutput$archiveId' => '<p>The ID of the archive. This value is also included as part of the location.</p>', 'CSVInput$Comments' => '<p>A single character used to indicate that a row should be ignored when the character is present at the start of that row.</p>', 'CSVInput$QuoteEscapeCharacter' => '<p>A single character used for escaping the quotation-mark character inside an already escaped value.</p>', 'CSVInput$RecordDelimiter' => '<p>A value used to separate individual records from each other.</p>', 'CSVInput$FieldDelimiter' => '<p>A value used to separate individual fields from each other within a record.</p>', 'CSVInput$QuoteCharacter' => '<p>A value used as an escape character where the field delimiter is part of the value.</p>', 'CSVOutput$QuoteEscapeCharacter' => '<p>A single character used for escaping the quotation-mark character inside an already escaped value.</p>', 'CSVOutput$RecordDelimiter' => '<p>A value used to separate individual records from each other.</p>', 'CSVOutput$FieldDelimiter' => '<p>A value used to separate individual fields from each other within a record.</p>', 'CSVOutput$QuoteCharacter' => '<p>A value used as an escape character where the field delimiter is part of the value.</p>', 'CompleteMultipartUploadInput$accountId' => '<p>The <code>AccountId</code> value is the AWS account ID of the account that owns the vault. You can either specify an AWS account ID or optionally a single \'<code>-</code>\' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If you use an account ID, do not include any hyphens (\'-\') in the ID.</p>', 'CompleteMultipartUploadInput$vaultName' => '<p>The name of the vault.</p>', 'CompleteMultipartUploadInput$uploadId' => '<p>The upload ID of the multipart upload.</p>', 'CompleteMultipartUploadInput$archiveSize' => '<p>The total size, in bytes, of the entire archive. This value should be the sum of all the sizes of the individual parts that you uploaded.</p>', 'CompleteMultipartUploadInput$checksum' => '<p>The SHA256 tree hash of the entire archive. It is the tree hash of SHA256 tree hash of the individual parts. If the value you specify in the request does not match the SHA256 tree hash of the final assembled archive as computed by Amazon S3 Glacier (Glacier), Glacier returns an error and the request fails.</p>', 'CompleteVaultLockInput$accountId' => '<p>The <code>AccountId</code> value is the AWS account ID. This value must match the AWS account ID associated with the credentials used to sign the request. You can either specify an AWS account ID or optionally a single \'<code>-</code>\' (hyphen), in which case Amazon Glacier uses the AWS account ID associated with the credentials used to sign the request. If you specify your account ID, do not include any hyphens (\'-\') in the ID.</p>', 'CompleteVaultLockInput$vaultName' => '<p>The name of the vault.</p>', 'CompleteVaultLockInput$lockId' => '<p>The <code>lockId</code> value is the lock ID obtained from a <a>InitiateVaultLock</a> request.</p>', 'CreateVaultInput$accountId' => '<p>The <code>AccountId</code> value is the AWS account ID. This value must match the AWS account ID associated with the credentials used to sign the request. You can either specify an AWS account ID or optionally a single \'<code>-</code>\' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If you specify your account ID, do not include any hyphens (\'-\') in the ID.</p>', 'CreateVaultInput$vaultName' => '<p>The name of the vault.</p>', 'CreateVaultOutput$location' => '<p>The URI of the vault that was created.</p>', 'DataRetrievalRule$Strategy' => '<p>The type of data retrieval policy to set.</p> <p>Valid values: BytesPerHour|FreeTier|None</p>', 'DeleteArchiveInput$accountId' => '<p>The <code>AccountId</code> value is the AWS account ID of the account that owns the vault. You can either specify an AWS account ID or optionally a single \'<code>-</code>\' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If you use an account ID, do not include any hyphens (\'-\') in the ID.</p>', 'DeleteArchiveInput$vaultName' => '<p>The name of the vault.</p>', 'DeleteArchiveInput$archiveId' => '<p>The ID of the archive to delete.</p>', 'DeleteVaultAccessPolicyInput$accountId' => '<p>The <code>AccountId</code> value is the AWS account ID of the account that owns the vault. You can either specify an AWS account ID or optionally a single \'<code>-</code>\' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If you use an account ID, do not include any hyphens (\'-\') in the ID. </p>', 'DeleteVaultAccessPolicyInput$vaultName' => '<p>The name of the vault.</p>', 'DeleteVaultInput$accountId' => '<p>The <code>AccountId</code> value is the AWS account ID of the account that owns the vault. You can either specify an AWS account ID or optionally a single \'<code>-</code>\' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If you use an account ID, do not include any hyphens (\'-\') in the ID.</p>', 'DeleteVaultInput$vaultName' => '<p>The name of the vault.</p>', 'DeleteVaultNotificationsInput$accountId' => '<p>The <code>AccountId</code> value is the AWS account ID of the account that owns the vault. You can either specify an AWS account ID or optionally a single \'<code>-</code>\' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If you use an account ID, do not include any hyphens (\'-\') in the ID. </p>', 'DeleteVaultNotificationsInput$vaultName' => '<p>The name of the vault.</p>', 'DescribeJobInput$accountId' => '<p>The <code>AccountId</code> value is the AWS account ID of the account that owns the vault. You can either specify an AWS account ID or optionally a single \'<code>-</code>\' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If you use an account ID, do not include any hyphens (\'-\') in the ID. </p>', 'DescribeJobInput$vaultName' => '<p>The name of the vault.</p>', 'DescribeJobInput$jobId' => '<p>The ID of the job to describe.</p>', 'DescribeVaultInput$accountId' => '<p>The <code>AccountId</code> value is the AWS account ID of the account that owns the vault. You can either specify an AWS account ID or optionally a single \'<code>-</code>\' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If you use an account ID, do not include any hyphens (\'-\') in the ID. </p>', 'DescribeVaultInput$vaultName' => '<p>The name of the vault.</p>', 'DescribeVaultOutput$VaultARN' => '<p>The Amazon Resource Name (ARN) of the vault.</p>', 'DescribeVaultOutput$VaultName' => '<p>The name of the vault.</p>', 'DescribeVaultOutput$CreationDate' => '<p>The Universal Coordinated Time (UTC) date when the vault was created. This value should be a string in the ISO 8601 date format, for example <code>2012-03-20T17:03:43.221Z</code>.</p>', 'DescribeVaultOutput$LastInventoryDate' => '<p>The Universal Coordinated Time (UTC) date when Amazon S3 Glacier completed the last vault inventory. This value should be a string in the ISO 8601 date format, for example <code>2012-03-20T17:03:43.221Z</code>.</p>', 'Encryption$KMSKeyId' => '<p>The AWS KMS key ID to use for object encryption. All GET and PUT requests for an object protected by AWS KMS fail if not made by using Secure Sockets Layer (SSL) or Signature Version 4. </p>', 'Encryption$KMSContext' => '<p>Optional. If the encryption type is <code>aws:kms</code>, you can use this value to specify the encryption context for the job results.</p>', 'GetDataRetrievalPolicyInput$accountId' => '<p>The <code>AccountId</code> value is the AWS account ID. This value must match the AWS account ID associated with the credentials used to sign the request. You can either specify an AWS account ID or optionally a single \'<code>-</code>\' (hyphen), in which case Amazon Glacier uses the AWS account ID associated with the credentials used to sign the request. If you specify your account ID, do not include any hyphens (\'-\') in the ID. </p>', 'GetJobOutputInput$accountId' => '<p>The <code>AccountId</code> value is the AWS account ID of the account that owns the vault. You can either specify an AWS account ID or optionally a single \'<code>-</code>\' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If you use an account ID, do not include any hyphens (\'-\') in the ID.</p>', 'GetJobOutputInput$vaultName' => '<p>The name of the vault.</p>', 'GetJobOutputInput$jobId' => '<p>The job ID whose data is downloaded.</p>', 'GetJobOutputInput$range' => '<p>The range of bytes to retrieve from the output. For example, if you want to download the first 1,048,576 bytes, specify the range as <code>bytes=0-1048575</code>. By default, this operation downloads the entire output.</p> <p>If the job output is large, then you can use a range to retrieve a portion of the output. This allows you to download the entire output in smaller chunks of bytes. For example, suppose you have 1 GB of job output you want to download and you decide to download 128 MB chunks of data at a time, which is a total of eight Get Job Output requests. You use the following process to download the job output:</p> <ol> <li> <p>Download a 128 MB chunk of output by specifying the appropriate byte range. Verify that all 128 MB of data was received.</p> </li> <li> <p>Along with the data, the response includes a SHA256 tree hash of the payload. You compute the checksum of the payload on the client and compare it with the checksum you received in the response to ensure you received all the expected data.</p> </li> <li> <p>Repeat steps 1 and 2 for all the eight 128 MB chunks of output data, each time specifying the appropriate byte range.</p> </li> <li> <p>After downloading all the parts of the job output, you have a list of eight checksum values. Compute the tree hash of these values to find the checksum of the entire output. Using the <a>DescribeJob</a> API, obtain job information of the job that provided you the output. The response includes the checksum of the entire archive stored in Amazon S3 Glacier. You compare this value with the checksum you computed to ensure you have downloaded the entire archive content with no errors.</p> <p/> </li> </ol>', 'GetJobOutputOutput$checksum' => '<p>The checksum of the data in the response. This header is returned only when retrieving the output for an archive retrieval job. Furthermore, this header appears only under the following conditions:</p> <ul> <li> <p>You get the entire range of the archive.</p> </li> <li> <p>You request a range to return of the archive that starts and ends on a multiple of 1 MB. For example, if you have an 3.1 MB archive and you specify a range to return that starts at 1 MB and ends at 2 MB, then the x-amz-sha256-tree-hash is returned as a response header.</p> </li> <li> <p>You request a range of the archive to return that starts on a multiple of 1 MB and goes to the end of the archive. For example, if you have a 3.1 MB archive and you specify a range that starts at 2 MB and ends at 3.1 MB (the end of the archive), then the x-amz-sha256-tree-hash is returned as a response header.</p> </li> </ul>', 'GetJobOutputOutput$contentRange' => '<p>The range of bytes returned by Amazon S3 Glacier. If only partial output is downloaded, the response provides the range of bytes Amazon S3 Glacier returned. For example, bytes 0-1048575/8388608 returns the first 1 MB from 8 MB.</p>', 'GetJobOutputOutput$acceptRanges' => '<p>Indicates the range units accepted. For more information, see <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html">RFC2616</a>. </p>', 'GetJobOutputOutput$contentType' => '<p>The Content-Type depends on whether the job output is an archive or a vault inventory. For archive data, the Content-Type is application/octet-stream. For vault inventory, if you requested CSV format when you initiated the job, the Content-Type is text/csv. Otherwise, by default, vault inventory is returned as JSON, and the Content-Type is application/json.</p>', 'GetJobOutputOutput$archiveDescription' => '<p>The description of an archive.</p>', 'GetVaultAccessPolicyInput$accountId' => '<p>The <code>AccountId</code> value is the AWS account ID of the account that owns the vault. You can either specify an AWS account ID or optionally a single \'<code>-</code>\' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If you use an account ID, do not include any hyphens (\'-\') in the ID.</p>', 'GetVaultAccessPolicyInput$vaultName' => '<p>The name of the vault.</p>', 'GetVaultLockInput$accountId' => '<p>The <code>AccountId</code> value is the AWS account ID of the account that owns the vault. You can either specify an AWS account ID or optionally a single \'<code>-</code>\' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If you use an account ID, do not include any hyphens (\'-\') in the ID.</p>', 'GetVaultLockInput$vaultName' => '<p>The name of the vault.</p>', 'GetVaultLockOutput$Policy' => '<p>The vault lock policy as a JSON string, which uses "\\" as an escape character.</p>', 'GetVaultLockOutput$State' => '<p>The state of the vault lock. <code>InProgress</code> or <code>Locked</code>.</p>', 'GetVaultLockOutput$ExpirationDate' => '<p>The UTC date and time at which the lock ID expires. This value can be <code>null</code> if the vault lock is in a <code>Locked</code> state.</p>', 'GetVaultLockOutput$CreationDate' => '<p>The UTC date and time at which the vault lock was put into the <code>InProgress</code> state.</p>', 'GetVaultNotificationsInput$accountId' => '<p>The <code>AccountId</code> value is the AWS account ID of the account that owns the vault. You can either specify an AWS account ID or optionally a single \'<code>-</code>\' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If you use an account ID, do not include any hyphens (\'-\') in the ID.</p>', 'GetVaultNotificationsInput$vaultName' => '<p>The name of the vault.</p>', 'GlacierJobDescription$JobId' => '<p>An opaque string that identifies an Amazon S3 Glacier job.</p>', 'GlacierJobDescription$JobDescription' => '<p>The job description provided when initiating the job.</p>', 'GlacierJobDescription$ArchiveId' => '<p>The archive ID requested for a select job or archive retrieval. Otherwise, this field is null.</p>', 'GlacierJobDescription$VaultARN' => '<p>The Amazon Resource Name (ARN) of the vault from which an archive retrieval was requested.</p>', 'GlacierJobDescription$CreationDate' => '<p>The UTC date when the job was created. This value is a string representation of ISO 8601 date format, for example <code>"2012-03-20T17:03:43.221Z"</code>.</p>', 'GlacierJobDescription$StatusMessage' => '<p>A friendly message that describes the job status.</p>', 'GlacierJobDescription$SNSTopic' => '<p>An Amazon SNS topic that receives notification.</p>', 'GlacierJobDescription$CompletionDate' => '<p>The UTC time that the job request completed. While the job is in progress, the value is null.</p>', 'GlacierJobDescription$SHA256TreeHash' => '<p>For an archive retrieval job, this value is the checksum of the archive. Otherwise, this value is null.</p> <p>The SHA256 tree hash value for the requested range of an archive. If the <b>InitiateJob</b> request for an archive specified a tree-hash aligned range, then this field returns a value.</p> <p>If the whole archive is retrieved, this value is the same as the ArchiveSHA256TreeHash value.</p> <p>This field is null for the following:</p> <ul> <li> <p>Archive retrieval jobs that specify a range that is not tree-hash aligned</p> </li> </ul> <ul> <li> <p>Archival jobs that specify a range that is equal to the whole archive, when the job status is <code>InProgress</code> </p> </li> </ul> <ul> <li> <p>Inventory jobs</p> </li> <li> <p>Select jobs</p> </li> </ul>', 'GlacierJobDescription$ArchiveSHA256TreeHash' => '<p>The SHA256 tree hash of the entire archive for an archive retrieval. For inventory retrieval or select jobs, this field is null.</p>', 'GlacierJobDescription$RetrievalByteRange' => '<p>The retrieved byte range for archive retrieval jobs in the form <i>StartByteValue</i>-<i>EndByteValue</i>. If no range was specified in the archive retrieval, then the whole archive is retrieved. In this case, <i>StartByteValue</i> equals 0 and <i>EndByteValue</i> equals the size of the archive minus 1. For inventory retrieval or select jobs, this field is null. </p>', 'GlacierJobDescription$Tier' => '<p>The tier to use for a select or an archive retrieval. Valid values are <code>Expedited</code>, <code>Standard</code>, or <code>Bulk</code>. <code>Standard</code> is the default.</p>', 'GlacierJobDescription$JobOutputPath' => '<p>Contains the job output location.</p>', 'Grantee$DisplayName' => '<p>Screen name of the grantee.</p>', 'Grantee$URI' => '<p>URI of the grantee group.</p>', 'Grantee$ID' => '<p>The canonical user ID of the grantee.</p>', 'Grantee$EmailAddress' => '<p>Email address of the grantee.</p>', 'InitiateJobInput$accountId' => '<p>The <code>AccountId</code> value is the AWS account ID of the account that owns the vault. You can either specify an AWS account ID or optionally a single \'<code>-</code>\' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If you use an account ID, do not include any hyphens (\'-\') in the ID.</p>', 'InitiateJobInput$vaultName' => '<p>The name of the vault.</p>', 'InitiateJobOutput$location' => '<p>The relative URI path of the job.</p>', 'InitiateJobOutput$jobId' => '<p>The ID of the job.</p>', 'InitiateJobOutput$jobOutputPath' => '<p>The path to the location of where the select results are stored.</p>', 'InitiateMultipartUploadInput$accountId' => '<p>The <code>AccountId</code> value is the AWS account ID of the account that owns the vault. You can either specify an AWS account ID or optionally a single \'<code>-</code>\' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If you use an account ID, do not include any hyphens (\'-\') in the ID. </p>', 'InitiateMultipartUploadInput$vaultName' => '<p>The name of the vault.</p>', 'InitiateMultipartUploadInput$archiveDescription' => '<p>The archive description that you are uploading in parts.</p> <p>The part size must be a megabyte (1024 KB) multiplied by a power of 2, for example 1048576 (1 MB), 2097152 (2 MB), 4194304 (4 MB), 8388608 (8 MB), and so on. The minimum allowable part size is 1 MB, and the maximum is 4 GB (4096 MB).</p>', 'InitiateMultipartUploadInput$partSize' => '<p>The size of each part except the last, in bytes. The last part can be smaller than this part size.</p>', 'InitiateMultipartUploadOutput$location' => '<p>The relative URI path of the multipart upload ID Amazon S3 Glacier created.</p>', 'InitiateMultipartUploadOutput$uploadId' => '<p>The ID of the multipart upload. This value is also included as part of the location.</p>', 'InitiateVaultLockInput$accountId' => '<p>The <code>AccountId</code> value is the AWS account ID. This value must match the AWS account ID associated with the credentials used to sign the request. You can either specify an AWS account ID or optionally a single \'<code>-</code>\' (hyphen), in which case Amazon Glacier uses the AWS account ID associated with the credentials used to sign the request. If you specify your account ID, do not include any hyphens (\'-\') in the ID.</p>', 'InitiateVaultLockInput$vaultName' => '<p>The name of the vault.</p>', 'InitiateVaultLockOutput$lockId' => '<p>The lock ID, which is used to complete the vault locking process.</p>', 'InsufficientCapacityException$type' => NULL, 'InsufficientCapacityException$code' => NULL, 'InsufficientCapacityException$message' => NULL, 'InvalidParameterValueException$type' => '<p>Client</p>', 'InvalidParameterValueException$code' => '<p>400 Bad Request</p>', 'InvalidParameterValueException$message' => '<p>Returned if a parameter of the request is incorrectly specified.</p>', 'InventoryRetrievalJobDescription$Format' => '<p>The output format for the vault inventory list, which is set by the <b>InitiateJob</b> request when initiating a job to retrieve a vault inventory. Valid values are <code>CSV</code> and <code>JSON</code>.</p>', 'InventoryRetrievalJobDescription$Limit' => '<p>The maximum number of inventory items returned per vault inventory retrieval request. This limit is set when initiating the job with the a <b>InitiateJob</b> request. </p>', 'InventoryRetrievalJobDescription$Marker' => '<p>An opaque string that represents where to continue pagination of the vault inventory retrieval results. You use the marker in a new <b>InitiateJob</b> request to obtain additional inventory items. If there are no more inventory items, this value is <code>null</code>. For more information, see <a href="https://docs.aws.amazon.com/amazonglacier/latest/dev/api-initiate-job-post.html#api-initiate-job-post-vault-inventory-list-filtering"> Range Inventory Retrieval</a>.</p>', 'InventoryRetrievalJobInput$StartDate' => '<p>The start of the date range in UTC for vault inventory retrieval that includes archives created on or after this date. This value should be a string in the ISO 8601 date format, for example <code>2013-03-20T17:03:43Z</code>.</p>', 'InventoryRetrievalJobInput$EndDate' => '<p>The end of the date range in UTC for vault inventory retrieval that includes archives created before this date. This value should be a string in the ISO 8601 date format, for example <code>2013-03-20T17:03:43Z</code>.</p>', 'InventoryRetrievalJobInput$Limit' => '<p>Specifies the maximum number of inventory items returned per vault inventory retrieval request. Valid values are greater than or equal to 1.</p>', 'InventoryRetrievalJobInput$Marker' => '<p>An opaque string that represents where to continue pagination of the vault inventory retrieval results. You use the marker in a new <b>InitiateJob</b> request to obtain additional inventory items. If there are no more inventory items, this value is <code>null</code>.</p>', 'JobParameters$Format' => '<p>When initiating a job to retrieve a vault inventory, you can optionally add this parameter to your request to specify the output format. If you are initiating an inventory job and do not specify a Format field, JSON is the default format. Valid values are "CSV" and "JSON".</p>', 'JobParameters$Type' => '<p>The job type. You can initiate a job to perform a select query on an archive, retrieve an archive, or get an inventory of a vault. Valid values are "select", "archive-retrieval" and "inventory-retrieval".</p>', 'JobParameters$ArchiveId' => '<p>The ID of the archive that you want to retrieve. This field is required only if <code>Type</code> is set to <code>select</code> or <code>archive-retrieval</code>code&gt;. An error occurs if you specify this request parameter for an inventory retrieval job request. </p>', 'JobParameters$Description' => '<p>The optional description for the job. The description must be less than or equal to 1,024 bytes. The allowable characters are 7-bit ASCII without control codes-specifically, ASCII values 32-126 decimal or 0x20-0x7E hexadecimal.</p>', 'JobParameters$SNSTopic' => '<p>The Amazon SNS topic ARN to which Amazon S3 Glacier sends a notification when the job is completed and the output is ready for you to download. The specified topic publishes the notification to its subscribers. The SNS topic must exist.</p>', 'JobParameters$RetrievalByteRange' => '<p>The byte range to retrieve for an archive retrieval. in the form "<i>StartByteValue</i>-<i>EndByteValue</i>" If not specified, the whole archive is retrieved. If specified, the byte range must be megabyte (1024*1024) aligned which means that <i>StartByteValue</i> must be divisible by 1 MB and <i>EndByteValue</i> plus 1 must be divisible by 1 MB or be the end of the archive specified as the archive byte size value minus 1. If RetrievalByteRange is not megabyte aligned, this operation returns a 400 response. </p> <p>An error occurs if you specify this field for an inventory retrieval job request.</p>', 'JobParameters$Tier' => '<p>The tier to use for a select or an archive retrieval job. Valid values are <code>Expedited</code>, <code>Standard</code>, or <code>Bulk</code>. <code>Standard</code> is the default.</p>', 'LimitExceededException$type' => '<p>Client</p>', 'LimitExceededException$code' => '<p>400 Bad Request</p>', 'LimitExceededException$message' => '<p>Returned if the request results in a vault limit or tags limit being exceeded.</p>', 'ListJobsInput$accountId' => '<p>The <code>AccountId</code> value is the AWS account ID of the account that owns the vault. You can either specify an AWS account ID or optionally a single \'<code>-</code>\' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If you use an account ID, do not include any hyphens (\'-\') in the ID. </p>', 'ListJobsInput$vaultName' => '<p>The name of the vault.</p>', 'ListJobsInput$limit' => '<p>The maximum number of jobs to be returned. The default limit is 50. The number of jobs returned might be fewer than the specified limit, but the number of returned jobs never exceeds the limit.</p>', 'ListJobsInput$marker' => '<p>An opaque string used for pagination. This value specifies the job at which the listing of jobs should begin. Get the marker value from a previous List Jobs response. You only need to include the marker if you are continuing the pagination of results started in a previous List Jobs request.</p>', 'ListJobsInput$statuscode' => '<p>The type of job status to return. You can specify the following values: <code>InProgress</code>, <code>Succeeded</code>, or <code>Failed</code>.</p>', 'ListJobsInput$completed' => '<p>The state of the jobs to return. You can specify <code>true</code> or <code>false</code>.</p>', 'ListJobsOutput$Marker' => '<p> An opaque string used for pagination that specifies the job at which the listing of jobs should begin. You get the <code>marker</code> value from a previous List Jobs response. You only need to include the marker if you are continuing the pagination of the results started in a previous List Jobs request. </p>', 'ListMultipartUploadsInput$accountId' => '<p>The <code>AccountId</code> value is the AWS account ID of the account that owns the vault. You can either specify an AWS account ID or optionally a single \'<code>-</code>\' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If you use an account ID, do not include any hyphens (\'-\') in the ID. </p>', 'ListMultipartUploadsInput$vaultName' => '<p>The name of the vault.</p>', 'ListMultipartUploadsInput$marker' => '<p>An opaque string used for pagination. This value specifies the upload at which the listing of uploads should begin. Get the marker value from a previous List Uploads response. You need only include the marker if you are continuing the pagination of results started in a previous List Uploads request.</p>', 'ListMultipartUploadsInput$limit' => '<p>Specifies the maximum number of uploads returned in the response body. If this value is not specified, the List Uploads operation returns up to 50 uploads.</p>', 'ListMultipartUploadsOutput$Marker' => '<p>An opaque string that represents where to continue pagination of the results. You use the marker in a new List Multipart Uploads request to obtain more uploads in the list. If there are no more uploads, this value is <code>null</code>.</p>', 'ListPartsInput$accountId' => '<p>The <code>AccountId</code> value is the AWS account ID of the account that owns the vault. You can either specify an AWS account ID or optionally a single \'<code>-</code>\' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If you use an account ID, do not include any hyphens (\'-\') in the ID. </p>', 'ListPartsInput$vaultName' => '<p>The name of the vault.</p>', 'ListPartsInput$uploadId' => '<p>The upload ID of the multipart upload.</p>', 'ListPartsInput$marker' => '<p>An opaque string used for pagination. This value specifies the part at which the listing of parts should begin. Get the marker value from the response of a previous List Parts response. You need only include the marker if you are continuing the pagination of results started in a previous List Parts request.</p>', 'ListPartsInput$limit' => '<p>The maximum number of parts to be returned. The default limit is 50. The number of parts returned might be fewer than the specified limit, but the number of returned parts never exceeds the limit.</p>', 'ListPartsOutput$MultipartUploadId' => '<p>The ID of the upload to which the parts are associated.</p>', 'ListPartsOutput$VaultARN' => '<p>The Amazon Resource Name (ARN) of the vault to which the multipart upload was initiated.</p>', 'ListPartsOutput$ArchiveDescription' => '<p>The description of the archive that was specified in the Initiate Multipart Upload request.</p>', 'ListPartsOutput$CreationDate' => '<p>The UTC time at which the multipart upload was initiated.</p>', 'ListPartsOutput$Marker' => '<p>An opaque string that represents where to continue pagination of the results. You use the marker in a new List Parts request to obtain more jobs in the list. If there are no more parts, this value is <code>null</code>.</p>', 'ListProvisionedCapacityInput$accountId' => '<p>The AWS account ID of the account that owns the vault. You can either specify an AWS account ID or optionally a single \'-\' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If you use an account ID, don\'t include any hyphens (\'-\') in the ID. </p>', 'ListTagsForVaultInput$accountId' => '<p>The <code>AccountId</code> value is the AWS account ID of the account that owns the vault. You can either specify an AWS account ID or optionally a single \'<code>-</code>\' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If you use an account ID, do not include any hyphens (\'-\') in the ID.</p>', 'ListTagsForVaultInput$vaultName' => '<p>The name of the vault.</p>', 'ListVaultsInput$accountId' => '<p>The <code>AccountId</code> value is the AWS account ID. This value must match the AWS account ID associated with the credentials used to sign the request. You can either specify an AWS account ID or optionally a single \'<code>-</code>\' (hyphen), in which case Amazon Glacier uses the AWS account ID associated with the credentials used to sign the request. If you specify your account ID, do not include any hyphens (\'-\') in the ID.</p>', 'ListVaultsInput$marker' => '<p>A string used for pagination. The marker specifies the vault ARN after which the listing of vaults should begin.</p>', 'ListVaultsInput$limit' => '<p>The maximum number of vaults to be returned. The default limit is 10. The number of vaults returned might be fewer than the specified limit, but the number of returned vaults never exceeds the limit.</p>', 'ListVaultsOutput$Marker' => '<p>The vault ARN at which to continue pagination of the results. You use the marker in another List Vaults request to obtain more vaults in the list.</p>', 'MissingParameterValueException$type' => '<p>Client.</p>', 'MissingParameterValueException$code' => '<p>400 Bad Request</p>', 'MissingParameterValueException$message' => '<p>Returned if no authentication data is found for the request.</p>', 'NotificationEventList$member' => NULL, 'PartListElement$RangeInBytes' => '<p>The byte range of a part, inclusive of the upper value of the range.</p>', 'PartListElement$SHA256TreeHash' => '<p>The SHA256 tree hash value that Amazon S3 Glacier calculated for the part. This field is never <code>null</code>.</p>', 'PolicyEnforcedException$type' => '<p>Client</p>', 'PolicyEnforcedException$code' => '<p>PolicyEnforcedException</p>', 'PolicyEnforcedException$message' => '<p>InitiateJob request denied by current data retrieval policy.</p>', 'ProvisionedCapacityDescription$CapacityId' => '<p>The ID that identifies the provisioned capacity unit.</p>', 'ProvisionedCapacityDescription$StartDate' => '<p>The date that the provisioned capacity unit was purchased, in Universal Coordinated Time (UTC).</p>', 'ProvisionedCapacityDescription$ExpirationDate' => '<p>The date that the provisioned capacity unit expires, in Universal Coordinated Time (UTC).</p>', 'PurchaseProvisionedCapacityInput$accountId' => '<p>The AWS account ID of the account that owns the vault. You can either specify an AWS account ID or optionally a single \'-\' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If you use an account ID, don\'t include any hyphens (\'-\') in the ID. </p>', 'PurchaseProvisionedCapacityOutput$capacityId' => '<p>The ID that identifies the provisioned capacity unit.</p>', 'RemoveTagsFromVaultInput$accountId' => '<p>The <code>AccountId</code> value is the AWS account ID of the account that owns the vault. You can either specify an AWS account ID or optionally a single \'<code>-</code>\' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If you use an account ID, do not include any hyphens (\'-\') in the ID.</p>', 'RemoveTagsFromVaultInput$vaultName' => '<p>The name of the vault.</p>', 'RequestTimeoutException$type' => '<p>Client</p>', 'RequestTimeoutException$code' => '<p>408 Request Timeout</p>', 'RequestTimeoutException$message' => '<p>Returned if, when uploading an archive, Amazon S3 Glacier times out while receiving the upload.</p>', 'ResourceNotFoundException$type' => '<p>Client</p>', 'ResourceNotFoundException$code' => '<p>404 Not Found</p>', 'ResourceNotFoundException$message' => '<p>Returned if the specified resource (such as a vault, upload ID, or job ID) doesn\'t exist.</p>', 'S3Location$BucketName' => '<p>The name of the Amazon S3 bucket where the job results are stored.</p>', 'S3Location$Prefix' => '<p>The prefix that is prepended to the results for this request.</p>', 'SelectParameters$Expression' => '<p>The expression that is used to select the object.</p>', 'ServiceUnavailableException$type' => '<p>Server</p>', 'ServiceUnavailableException$code' => '<p>500 Internal Server Error</p>', 'ServiceUnavailableException$message' => '<p>Returned if the service cannot complete the request.</p>', 'SetDataRetrievalPolicyInput$accountId' => '<p>The <code>AccountId</code> value is the AWS account ID. This value must match the AWS account ID associated with the credentials used to sign the request. You can either specify an AWS account ID or optionally a single \'<code>-</code>\' (hyphen), in which case Amazon Glacier uses the AWS account ID associated with the credentials used to sign the request. If you specify your account ID, do not include any hyphens (\'-\') in the ID.</p>', 'SetVaultAccessPolicyInput$accountId' => '<p>The <code>AccountId</code> value is the AWS account ID of the account that owns the vault. You can either specify an AWS account ID or optionally a single \'<code>-</code>\' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If you use an account ID, do not include any hyphens (\'-\') in the ID.</p>', 'SetVaultAccessPolicyInput$vaultName' => '<p>The name of the vault.</p>', 'SetVaultNotificationsInput$accountId' => '<p>The <code>AccountId</code> value is the AWS account ID of the account that owns the vault. You can either specify an AWS account ID or optionally a single \'<code>-</code>\' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If you use an account ID, do not include any hyphens (\'-\') in the ID.</p>', 'SetVaultNotificationsInput$vaultName' => '<p>The name of the vault.</p>', 'TagKeyList$member' => NULL, 'UploadArchiveInput$vaultName' => '<p>The name of the vault.</p>', 'UploadArchiveInput$accountId' => '<p>The <code>AccountId</code> value is the AWS account ID of the account that owns the vault. You can either specify an AWS account ID or optionally a single \'<code>-</code>\' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If you use an account ID, do not include any hyphens (\'-\') in the ID. </p>', 'UploadArchiveInput$archiveDescription' => '<p>The optional description of the archive you are uploading.</p>', 'UploadArchiveInput$checksum' => '<p>The SHA256 tree hash of the data being uploaded.</p>', 'UploadListElement$MultipartUploadId' => '<p>The ID of a multipart upload.</p>', 'UploadListElement$VaultARN' => '<p>The Amazon Resource Name (ARN) of the vault that contains the archive.</p>', 'UploadListElement$ArchiveDescription' => '<p>The description of the archive that was specified in the Initiate Multipart Upload request.</p>', 'UploadListElement$CreationDate' => '<p>The UTC time at which the multipart upload was initiated.</p>', 'UploadMultipartPartInput$accountId' => '<p>The <code>AccountId</code> value is the AWS account ID of the account that owns the vault. You can either specify an AWS account ID or optionally a single \'<code>-</code>\' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If you use an account ID, do not include any hyphens (\'-\') in the ID. </p>', 'UploadMultipartPartInput$vaultName' => '<p>The name of the vault.</p>', 'UploadMultipartPartInput$uploadId' => '<p>The upload ID of the multipart upload.</p>', 'UploadMultipartPartInput$checksum' => '<p>The SHA256 tree hash of the data being uploaded.</p>', 'UploadMultipartPartInput$range' => '<p>Identifies the range of bytes in the assembled archive that will be uploaded in this part. Amazon S3 Glacier uses this information to assemble the archive in the proper sequence. The format of this header follows RFC 2616. An example header is Content-Range:bytes 0-4194303/*.</p>', 'UploadMultipartPartOutput$checksum' => '<p>The SHA256 tree hash that Amazon S3 Glacier computed for the uploaded part.</p>', 'VaultAccessPolicy$Policy' => '<p>The vault access policy.</p>', 'VaultLockPolicy$Policy' => '<p>The vault lock policy.</p>', 'VaultNotificationConfig$SNSTopic' => '<p>The Amazon Simple Notification Service (Amazon SNS) topic Amazon Resource Name (ARN).</p>', 'hashmap$key' => NULL, 'hashmap$value' => NULL, ], ], ],];
