<?php
// This file was auto-generated from sdk-root/src/data/groundstation/2019-05-23/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Welcome to the AWS Ground Station API Reference. AWS Ground Station is a fully managed service that enables you to control satellite communications, downlink and process satellite data, and scale your satellite operations efficiently and cost-effectively without having to build or manage your own ground station infrastructure.</p>', 'operations' => [ 'CancelContact' => '<p>Cancels a contact with a specified contact ID.</p>', 'CreateConfig' => '<p>Creates a <code>Config</code> with the specified <code>configData</code> parameters.</p> <p>Only one type of <code>configData</code> can be specified.</p>', 'CreateDataflowEndpointGroup' => '<p>Creates a <code>DataflowEndpoint</code> group containing the specified list of <code>DataflowEndpoint</code> objects.</p> <p>The <code>name</code> field in each endpoint is used in your mission profile <code>DataflowEndpointConfig</code> to specify which endpoints to use during a contact.</p> <p>When a contact uses multiple <code>DataflowEndpointConfig</code> objects, each <code>Config</code> must match a <code>DataflowEndpoint</code> in the same group.</p>', 'CreateEphemeris' => '<p>Creates an Ephemeris with the specified <code>EphemerisData</code>.</p>', 'CreateMissionProfile' => '<p>Creates a mission profile.</p> <p> <code>dataflowEdges</code> is a list of lists of strings. Each lower level list of strings has two elements: a <i>from</i> ARN and a <i>to</i> ARN.</p>', 'DeleteConfig' => '<p>Deletes a <code>Config</code>.</p>', 'DeleteDataflowEndpointGroup' => '<p>Deletes a dataflow endpoint group.</p>', 'DeleteEphemeris' => '<p>Deletes an ephemeris</p>', 'DeleteMissionProfile' => '<p>Deletes a mission profile.</p>', 'DescribeContact' => '<p>Describes an existing contact.</p>', 'DescribeEphemeris' => '<p>Describes an existing ephemeris.</p>', 'GetAgentConfiguration' => '<note> <p> For use by AWS Ground Station Agent and shouldn\'t be called directly.</p> </note> <p>Gets the latest configuration information for a registered agent.</p>', 'GetConfig' => '<p>Returns <code>Config</code> information.</p> <p>Only one <code>Config</code> response can be returned.</p>', 'GetDataflowEndpointGroup' => '<p>Returns the dataflow endpoint group.</p>', 'GetMinuteUsage' => '<p>Returns the number of reserved minutes used by account.</p>', 'GetMissionProfile' => '<p>Returns a mission profile.</p>', 'GetSatellite' => '<p>Returns a satellite.</p>', 'ListConfigs' => '<p>Returns a list of <code>Config</code> objects.</p>', 'ListContacts' => '<p>Returns a list of contacts.</p> <p>If <code>statusList</code> contains AVAILABLE, the request must include <code>groundStation</code>, <code>missionprofileArn</code>, and <code>satelliteArn</code>. </p>', 'ListDataflowEndpointGroups' => '<p>Returns a list of <code>DataflowEndpoint</code> groups.</p>', 'ListEphemerides' => '<p>List existing ephemerides.</p>', 'ListGroundStations' => '<p>Returns a list of ground stations. </p>', 'ListMissionProfiles' => '<p>Returns a list of mission profiles.</p>', 'ListSatellites' => '<p>Returns a list of satellites.</p>', 'ListTagsForResource' => '<p>Returns a list of tags for a specified resource.</p>', 'RegisterAgent' => '<note> <p> For use by AWS Ground Station Agent and shouldn\'t be called directly.</p> </note> <p> Registers a new agent with AWS Ground Station. </p>', 'ReserveContact' => '<p>Reserves a contact using specified parameters.</p>', 'TagResource' => '<p>Assigns a tag to a resource.</p>', 'UntagResource' => '<p>Deassigns a resource tag.</p>', 'UpdateAgentStatus' => '<note> <p> For use by AWS Ground Station Agent and shouldn\'t be called directly.</p> </note> <p>Update the status of the agent.</p>', 'UpdateConfig' => '<p>Updates the <code>Config</code> used when scheduling contacts.</p> <p>Updating a <code>Config</code> will not update the execution parameters for existing future contacts scheduled with this <code>Config</code>.</p>', 'UpdateEphemeris' => '<p>Updates an existing ephemeris</p>', 'UpdateMissionProfile' => '<p>Updates a mission profile.</p> <p>Updating a mission profile will not update the execution parameters for existing future contacts.</p>', ], 'shapes' => [ 'AWSRegion' => [ 'base' => NULL, 'refs' => [ 'GetMissionProfileResponse$region' => '<p>Region of a mission profile.</p>', 'GroundStationData$region' => '<p>Ground station Region.</p>', 'MissionProfileListItem$region' => '<p>Region of a mission profile.</p>', ], ], 'AgentCpuCoresList' => [ 'base' => NULL, 'refs' => [ 'AgentDetails$agentCpuCores' => '<p>List of CPU cores reserved for the agent.</p>', 'AgentDetails$reservedCpuCores' => '<note> <p>This field should not be used. Use agentCpuCores instead.</p> </note> <p>List of CPU cores reserved for processes other than the agent running on the EC2 instance.</p>', ], ], 'AgentDetails' => [ 'base' => '<p>Detailed information about the agent.</p>', 'refs' => [ 'RegisterAgentRequest$agentDetails' => '<p>Detailed information about the agent being registered.</p>', ], ], 'AgentStatus' => [ 'base' => NULL, 'refs' => [ 'AggregateStatus$status' => '<p>Aggregate status.</p>', 'AwsGroundStationAgentEndpoint$agentStatus' => '<p>The status of AgentEndpoint.</p>', 'ComponentStatusData$status' => '<p>Component status.</p>', ], ], 'AggregateStatus' => [ 'base' => '<p>Aggregate status of Agent components.</p>', 'refs' => [ 'UpdateAgentStatusRequest$aggregateStatus' => '<p>Aggregate status for agent.</p>', ], ], 'AngleUnits' => [ 'base' => NULL, 'refs' => [ 'Elevation$unit' => '<p>Elevation angle units.</p>', ], ], 'AntennaDemodDecodeDetails' => [ 'base' => '<p>Details about an antenna demod decode <code>Config</code> used in a contact.</p>', 'refs' => [ 'ConfigDetails$antennaDemodDecodeDetails' => '<p>Details for antenna demod decode <code>Config</code> in a contact.</p>', ], ], 'AntennaDownlinkConfig' => [ 'base' => '<p>Information about how AWS Ground Station should configure an antenna for downlink during a contact.</p>', 'refs' => [ 'ConfigTypeData$antennaDownlinkConfig' => '<p>Information about how AWS Ground Station should configure an antenna for downlink during a contact.</p>', ], ], 'AntennaDownlinkDemodDecodeConfig' => [ 'base' => '<p>Information about how AWS Ground Station should conﬁgure an antenna for downlink demod decode during a contact.</p>', 'refs' => [ 'ConfigTypeData$antennaDownlinkDemodDecodeConfig' => '<p>Information about how AWS Ground Station should conﬁgure an antenna for downlink demod decode during a contact.</p>', ], ], 'AntennaUplinkConfig' => [ 'base' => '<p>Information about the uplink <code>Config</code> of an antenna.</p>', 'refs' => [ 'ConfigTypeData$antennaUplinkConfig' => '<p>Information about how AWS Ground Station should conﬁgure an antenna for uplink during a contact.</p>', ], ], 'AnyArn' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$resourceArn' => '<p>ARN of a resource.</p>', 'TagResourceRequest$resourceArn' => '<p>ARN of a resource tag.</p>', 'UntagResourceRequest$resourceArn' => '<p>ARN of a resource.</p>', ], ], 'AuditResults' => [ 'base' => NULL, 'refs' => [ 'AwsGroundStationAgentEndpoint$auditResults' => '<p>The results of the audit.</p>', ], ], 'AwsGroundStationAgentEndpoint' => [ 'base' => '<p>Information about AwsGroundStationAgentEndpoint.</p>', 'refs' => [ 'EndpointDetails$awsGroundStationAgentEndpoint' => '<p>An agent endpoint.</p>', ], ], 'BandwidthUnits' => [ 'base' => NULL, 'refs' => [ 'FrequencyBandwidth$units' => '<p>Frequency bandwidth units.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'AntennaUplinkConfig$transmitDisabled' => '<p>Whether or not uplink transmit is disabled.</p>', 'CreateEphemerisRequest$enabled' => '<p>Whether to set the ephemeris status to <code>ENABLED</code> after validation.</p> <p>Setting this to false will set the ephemeris status to <code>DISABLED</code> after validation.</p>', 'DescribeEphemerisResponse$enabled' => '<p>Whether or not the ephemeris is enabled.</p>', 'EphemerisItem$enabled' => '<p>Whether or not the ephemeris is enabled.</p>', 'GetMinuteUsageResponse$isReservedMinutesCustomer' => '<p>Returns whether or not an account has signed up for the reserved minutes pricing plan, specific to the month being requested.</p>', 'SignatureMap$value' => NULL, 'UpdateEphemerisRequest$enabled' => '<p>Whether the ephemeris is enabled or not. Changing this value will not require the ephemeris to be re-validated.</p>', 'UplinkEchoConfig$enabled' => '<p>Whether or not an uplink <code>Config</code> is enabled.</p>', ], ], 'BucketArn' => [ 'base' => NULL, 'refs' => [ 'S3RecordingConfig$bucketArn' => '<p>ARN of the bucket to record to.</p>', 'S3RecordingDetails$bucketArn' => '<p>ARN of the bucket used.</p>', ], ], 'CancelContactRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'CapabilityArn' => [ 'base' => NULL, 'refs' => [ 'CapabilityArnList$member' => NULL, 'ComponentStatusData$capabilityArn' => '<p>Capability ARN of the component.</p>', ], ], 'CapabilityArnList' => [ 'base' => NULL, 'refs' => [ 'DiscoveryData$capabilityArns' => '<p>List of capabilities to associate with agent.</p>', ], ], 'CapabilityHealth' => [ 'base' => NULL, 'refs' => [ 'EndpointDetails$healthStatus' => '<p>A dataflow endpoint health status. This field is ignored when calling <code>CreateDataflowEndpointGroup</code>.</p>', ], ], 'CapabilityHealthReason' => [ 'base' => NULL, 'refs' => [ 'CapabilityHealthReasonList$member' => NULL, ], ], 'CapabilityHealthReasonList' => [ 'base' => NULL, 'refs' => [ 'EndpointDetails$healthReasons' => '<p>Health reasons for a dataflow endpoint. This field is ignored when calling <code>CreateDataflowEndpointGroup</code>.</p>', ], ], 'ComponentStatusData' => [ 'base' => '<p>Data on the status of agent components.</p>', 'refs' => [ 'ComponentStatusList$member' => NULL, ], ], 'ComponentStatusList' => [ 'base' => NULL, 'refs' => [ 'UpdateAgentStatusRequest$componentStatuses' => '<p>List of component statuses for agent.</p>', ], ], 'ComponentTypeString' => [ 'base' => NULL, 'refs' => [ 'ComponentStatusData$componentType' => '<p>The Component type.</p>', 'ComponentVersion$componentType' => '<p>Component type.</p>', ], ], 'ComponentVersion' => [ 'base' => '<p>Version information for agent components.</p>', 'refs' => [ 'ComponentVersionList$member' => NULL, ], ], 'ComponentVersionList' => [ 'base' => NULL, 'refs' => [ 'AgentDetails$componentVersions' => '<p>List of versions being used by agent components.</p>', ], ], 'ConfigArn' => [ 'base' => NULL, 'refs' => [ 'ConfigIdResponse$configArn' => '<p>ARN of a <code>Config</code>.</p>', 'ConfigListItem$configArn' => '<p>ARN of a <code>Config</code>.</p>', 'CreateMissionProfileRequest$trackingConfigArn' => '<p>ARN of a tracking <code>Config</code>.</p>', 'DataflowEdge$member' => NULL, 'GetConfigResponse$configArn' => '<p>ARN of a <code>Config</code> </p>', 'GetMissionProfileResponse$trackingConfigArn' => '<p>ARN of a tracking <code>Config</code>.</p>', 'UpdateMissionProfileRequest$trackingConfigArn' => '<p>ARN of a tracking <code>Config</code>.</p>', 'UplinkEchoConfig$antennaUplinkConfigArn' => '<p>ARN of an uplink <code>Config</code>.</p>', ], ], 'ConfigCapabilityType' => [ 'base' => NULL, 'refs' => [ 'ConfigIdResponse$configType' => '<p>Type of a <code>Config</code>.</p>', 'ConfigListItem$configType' => '<p>Type of a <code>Config</code>.</p>', 'DeleteConfigRequest$configType' => '<p>Type of a <code>Config</code>.</p>', 'Destination$configType' => '<p>Type of a <code>Config</code>.</p>', 'GetConfigRequest$configType' => '<p>Type of a <code>Config</code>.</p>', 'GetConfigResponse$configType' => '<p>Type of a <code>Config</code>.</p>', 'Source$configType' => '<p>Type of a <code>Config</code>.</p>', 'UpdateConfigRequest$configType' => '<p>Type of a <code>Config</code>.</p>', ], ], 'ConfigDetails' => [ 'base' => '<p>Details for certain <code>Config</code> object types in a contact.</p>', 'refs' => [ 'Destination$configDetails' => '<p>Additional details for a <code>Config</code>, if type is dataflow endpoint or antenna demod decode.</p>', 'Source$configDetails' => '<p>Additional details for a <code>Config</code>, if type is <code>dataflow-endpoint</code> or <code>antenna-downlink-demod-decode</code> </p>', ], ], 'ConfigIdResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'ConfigList' => [ 'base' => NULL, 'refs' => [ 'ListConfigsResponse$configList' => '<p>List of <code>Config</code> items.</p>', ], ], 'ConfigListItem' => [ 'base' => '<p>An item in a list of <code>Config</code> objects.</p>', 'refs' => [ 'ConfigList$member' => NULL, ], ], 'ConfigTypeData' => [ 'base' => '<p>Object containing the parameters of a <code>Config</code>.</p> <p>See the subtype definitions for what each type of <code>Config</code> contains.</p>', 'refs' => [ 'CreateConfigRequest$configData' => '<p>Parameters of a <code>Config</code>.</p>', 'GetConfigResponse$configData' => '<p>Data elements in a <code>Config</code>.</p>', 'UpdateConfigRequest$configData' => '<p>Parameters of a <code>Config</code>.</p>', ], ], 'ConnectionDetails' => [ 'base' => '<p>Egress address of AgentEndpoint with an optional mtu.</p>', 'refs' => [ 'AwsGroundStationAgentEndpoint$egressAddress' => '<p>The egress address of AgentEndpoint.</p>', ], ], 'ContactData' => [ 'base' => '<p>Data describing a contact.</p>', 'refs' => [ 'ContactList$member' => NULL, ], ], 'ContactIdResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'ContactList' => [ 'base' => NULL, 'refs' => [ 'ListContactsResponse$contactList' => '<p>List of contacts.</p>', ], ], 'ContactStatus' => [ 'base' => NULL, 'refs' => [ 'ContactData$contactStatus' => '<p>Status of a contact.</p>', 'DescribeContactResponse$contactStatus' => '<p>Status of a contact.</p>', 'StatusList$member' => NULL, ], ], 'CreateConfigRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'CreateDataflowEndpointGroupRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'CreateEphemerisRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateMissionProfileRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'Criticality' => [ 'base' => NULL, 'refs' => [ 'TrackingConfig$autotrack' => '<p>Current setting for autotrack.</p>', ], ], 'CustomerEphemerisPriority' => [ 'base' => NULL, 'refs' => [ 'CreateEphemerisRequest$priority' => '<p>Customer-provided priority score to establish the order in which overlapping ephemerides should be used.</p> <p>The default for customer-provided ephemeris priority is 1, and higher numbers take precedence.</p> <p>Priority must be 1 or greater</p>', ], ], 'DataflowDetail' => [ 'base' => '<p>Information about a dataflow edge used in a contact.</p>', 'refs' => [ 'DataflowList$member' => NULL, ], ], 'DataflowEdge' => [ 'base' => NULL, 'refs' => [ 'DataflowEdgeList$member' => NULL, ], ], 'DataflowEdgeList' => [ 'base' => NULL, 'refs' => [ 'CreateMissionProfileRequest$dataflowEdges' => '<p>A list of lists of ARNs. Each list of ARNs is an edge, with a <i>from</i> <code>Config</code> and a <i>to</i> <code>Config</code>.</p>', 'GetMissionProfileResponse$dataflowEdges' => '<p>A list of lists of ARNs. Each list of ARNs is an edge, with a <i>from</i> <code>Config</code> and a <i>to</i> <code>Config</code>.</p>', 'UpdateMissionProfileRequest$dataflowEdges' => '<p>A list of lists of ARNs. Each list of ARNs is an edge, with a <i>from</i> <code>Config</code> and a <i>to</i> <code>Config</code>.</p>', ], ], 'DataflowEndpoint' => [ 'base' => '<p>Information about a dataflow endpoint.</p>', 'refs' => [ 'EndpointDetails$endpoint' => '<p>A dataflow endpoint.</p>', ], ], 'DataflowEndpointConfig' => [ 'base' => '<p>Information about the dataflow endpoint <code>Config</code>.</p>', 'refs' => [ 'ConfigTypeData$dataflowEndpointConfig' => '<p>Information about the dataflow endpoint <code>Config</code>.</p>', ], ], 'DataflowEndpointGroupArn' => [ 'base' => NULL, 'refs' => [ 'DataflowEndpointListItem$dataflowEndpointGroupArn' => '<p>ARN of a dataflow endpoint group.</p>', 'GetDataflowEndpointGroupResponse$dataflowEndpointGroupArn' => '<p>ARN of a dataflow endpoint group.</p>', ], ], 'DataflowEndpointGroupDurationInSeconds' => [ 'base' => NULL, 'refs' => [ 'CreateDataflowEndpointGroupRequest$contactPostPassDurationSeconds' => '<p>Amount of time, in seconds, after a contact ends that the Ground Station Dataflow Endpoint Group will be in a <code>POSTPASS</code> state. A Ground Station Dataflow Endpoint Group State Change event will be emitted when the Dataflow Endpoint Group enters and exits the <code>POSTPASS</code> state.</p>', 'CreateDataflowEndpointGroupRequest$contactPrePassDurationSeconds' => '<p>Amount of time, in seconds, before a contact starts that the Ground Station Dataflow Endpoint Group will be in a <code>PREPASS</code> state. A Ground Station Dataflow Endpoint Group State Change event will be emitted when the Dataflow Endpoint Group enters and exits the <code>PREPASS</code> state.</p>', 'GetDataflowEndpointGroupResponse$contactPostPassDurationSeconds' => '<p>Amount of time, in seconds, after a contact ends that the Ground Station Dataflow Endpoint Group will be in a <code>POSTPASS</code> state. A Ground Station Dataflow Endpoint Group State Change event will be emitted when the Dataflow Endpoint Group enters and exits the <code>POSTPASS</code> state.</p>', 'GetDataflowEndpointGroupResponse$contactPrePassDurationSeconds' => '<p>Amount of time, in seconds, before a contact starts that the Ground Station Dataflow Endpoint Group will be in a <code>PREPASS</code> state. A Ground Station Dataflow Endpoint Group State Change event will be emitted when the Dataflow Endpoint Group enters and exits the <code>PREPASS</code> state.</p>', ], ], 'DataflowEndpointGroupIdResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'DataflowEndpointGroupList' => [ 'base' => NULL, 'refs' => [ 'ListDataflowEndpointGroupsResponse$dataflowEndpointGroupList' => '<p>A list of dataflow endpoint groups.</p>', ], ], 'DataflowEndpointListItem' => [ 'base' => '<p>Item in a list of <code>DataflowEndpoint</code> groups.</p>', 'refs' => [ 'DataflowEndpointGroupList$member' => NULL, ], ], 'DataflowEndpointMtuInteger' => [ 'base' => NULL, 'refs' => [ 'DataflowEndpoint$mtu' => '<p>Maximum transmission unit (MTU) size in bytes of a dataflow endpoint.</p>', ], ], 'DataflowList' => [ 'base' => NULL, 'refs' => [ 'DescribeContactResponse$dataflowList' => '<p>List describing source and destination details for each dataflow edge.</p>', ], ], 'DecodeConfig' => [ 'base' => '<p>Information about the decode <code>Config</code>.</p>', 'refs' => [ 'AntennaDownlinkDemodDecodeConfig$decodeConfig' => '<p>Information about the decode <code>Config</code>.</p>', ], ], 'DeleteConfigRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'DeleteDataflowEndpointGroupRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'DeleteEphemerisRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMissionProfileRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'DemodulationConfig' => [ 'base' => '<p>Information about the demodulation <code>Config</code>.</p>', 'refs' => [ 'AntennaDownlinkDemodDecodeConfig$demodulationConfig' => '<p>Information about the demodulation <code>Config</code>.</p>', ], ], 'DependencyException' => [ 'base' => '<p>Dependency encountered an error.</p>', 'refs' => [], ], 'DescribeContactRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeContactResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeEphemerisRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEphemerisResponse' => [ 'base' => NULL, 'refs' => [], ], 'Destination' => [ 'base' => '<p>Dataflow details for the destination side.</p>', 'refs' => [ 'DataflowDetail$destination' => NULL, ], ], 'DiscoveryData' => [ 'base' => '<p>Data for agent discovery.</p>', 'refs' => [ 'RegisterAgentRequest$discoveryData' => '<p>Data for associating an agent with the capabilities it is managing.</p>', ], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'Eirp$value' => '<p>Value of an EIRP. Valid values are between 20.0 to 50.0 dBW.</p>', 'Elevation$value' => '<p>Elevation angle value.</p>', 'Frequency$value' => '<p>Frequency value. Valid values are between 2200 to 2300 MHz and 7750 to 8400 MHz for downlink and 2025 to 2120 MHz for uplink.</p>', 'FrequencyBandwidth$value' => '<p>Frequency bandwidth value. AWS Ground Station currently has the following bandwidth limitations:</p> <ul> <li> <p>For <code>AntennaDownlinkDemodDecodeconfig</code>, valid values are between 125 kHz to 650 MHz.</p> </li> <li> <p>For <code>AntennaDownlinkconfig</code>, valid values are between 10 kHz to 54 MHz.</p> </li> <li> <p>For <code>AntennaUplinkConfig</code>, valid values are between 10 kHz to 54 MHz.</p> </li> </ul>', ], ], 'DurationInSeconds' => [ 'base' => NULL, 'refs' => [ 'CreateMissionProfileRequest$contactPostPassDurationSeconds' => '<p>Amount of time after a contact ends that you’d like to receive a Ground Station Contact State Change event indicating the pass has finished.</p>', 'CreateMissionProfileRequest$contactPrePassDurationSeconds' => '<p>Amount of time prior to contact start you’d like to receive a Ground Station Contact State Change event indicating an upcoming pass.</p>', 'GetMissionProfileResponse$contactPostPassDurationSeconds' => '<p>Amount of time after a contact ends that you’d like to receive a CloudWatch event indicating the pass has finished.</p>', 'GetMissionProfileResponse$contactPrePassDurationSeconds' => '<p>Amount of time prior to contact start you’d like to receive a CloudWatch event indicating an upcoming pass.</p>', 'UpdateMissionProfileRequest$contactPostPassDurationSeconds' => '<p>Amount of time after a contact ends that you’d like to receive a Ground Station Contact State Change event indicating the pass has finished.</p>', 'UpdateMissionProfileRequest$contactPrePassDurationSeconds' => '<p>Amount of time after a contact ends that you’d like to receive a Ground Station Contact State Change event indicating the pass has finished.</p>', ], ], 'Eirp' => [ 'base' => '<p>Object that represents EIRP.</p>', 'refs' => [ 'AntennaUplinkConfig$targetEirp' => '<p>EIRP of the target.</p>', ], ], 'EirpUnits' => [ 'base' => NULL, 'refs' => [ 'Eirp$units' => '<p>Units of an EIRP.</p>', ], ], 'Elevation' => [ 'base' => '<p>Elevation angle of the satellite in the sky during a contact.</p>', 'refs' => [ 'ContactData$maximumElevation' => '<p>Maximum elevation angle of a contact.</p>', 'DescribeContactResponse$maximumElevation' => '<p>Maximum elevation angle of a contact.</p>', ], ], 'EndpointDetails' => [ 'base' => '<p>Information about the endpoint details.</p>', 'refs' => [ 'ConfigDetails$endpointDetails' => NULL, 'EndpointDetailsList$member' => NULL, ], ], 'EndpointDetailsList' => [ 'base' => NULL, 'refs' => [ 'CreateDataflowEndpointGroupRequest$endpointDetails' => '<p>Endpoint details of each endpoint in the dataflow endpoint group.</p>', 'GetDataflowEndpointGroupResponse$endpointsDetails' => '<p>Details of a dataflow endpoint.</p>', ], ], 'EndpointStatus' => [ 'base' => NULL, 'refs' => [ 'DataflowEndpoint$status' => '<p>Status of a dataflow endpoint.</p>', ], ], 'EphemeridesList' => [ 'base' => NULL, 'refs' => [ 'ListEphemeridesResponse$ephemerides' => '<p>List of ephemerides.</p>', ], ], 'EphemerisData' => [ 'base' => '<p>Ephemeris data.</p>', 'refs' => [ 'CreateEphemerisRequest$ephemeris' => '<p>Ephemeris data.</p>', ], ], 'EphemerisDescription' => [ 'base' => '<p>Description of ephemeris.</p>', 'refs' => [ 'EphemerisTypeDescription$oem' => NULL, 'EphemerisTypeDescription$tle' => NULL, ], ], 'EphemerisIdResponse' => [ 'base' => NULL, 'refs' => [], ], 'EphemerisInvalidReason' => [ 'base' => NULL, 'refs' => [ 'DescribeEphemerisResponse$invalidReason' => '<p>Reason that an ephemeris failed validation. Only provided for ephemerides with <code>INVALID</code> status.</p>', ], ], 'EphemerisItem' => [ 'base' => '<p>Ephemeris item.</p>', 'refs' => [ 'EphemeridesList$member' => NULL, ], ], 'EphemerisMetaData' => [ 'base' => '<p>Metadata describing a particular ephemeris.</p>', 'refs' => [ 'GetSatelliteResponse$currentEphemeris' => '<p>The current ephemeris being used to compute the trajectory of the satellite.</p>', 'SatelliteListItem$currentEphemeris' => '<p>The current ephemeris being used to compute the trajectory of the satellite.</p>', ], ], 'EphemerisPriority' => [ 'base' => NULL, 'refs' => [ 'DescribeEphemerisResponse$priority' => '<p>Customer-provided priority score to establish the order in which overlapping ephemerides should be used.</p> <p>The default for customer-provided ephemeris priority is 1, and higher numbers take precedence.</p> <p>Priority must be 1 or greater</p>', 'EphemerisItem$priority' => '<p>Customer-provided priority score to establish the order in which overlapping ephemerides should be used.</p> <p>The default for customer-provided ephemeris priority is 1, and higher numbers take precedence.</p> <p>Priority must be 1 or greater</p>', 'UpdateEphemerisRequest$priority' => '<p>Customer-provided priority score to establish the order in which overlapping ephemerides should be used.</p> <p>The default for customer-provided ephemeris priority is 1, and higher numbers take precedence.</p> <p>Priority must be 1 or greater</p>', ], ], 'EphemerisSource' => [ 'base' => NULL, 'refs' => [ 'EphemerisMetaData$source' => '<p>The <code>EphemerisSource</code> that generated a given ephemeris.</p>', ], ], 'EphemerisStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeEphemerisResponse$status' => '<p>The status of the ephemeris.</p>', 'EphemerisItem$status' => '<p>The status of the ephemeris.</p>', 'EphemerisStatusList$member' => NULL, ], ], 'EphemerisStatusList' => [ 'base' => NULL, 'refs' => [ 'ListEphemeridesRequest$statusList' => '<p>The list of ephemeris status to return.</p>', ], ], 'EphemerisTypeDescription' => [ 'base' => '<p/>', 'refs' => [ 'DescribeEphemerisResponse$suppliedData' => '<p>Supplied ephemeris data.</p>', ], ], 'Frequency' => [ 'base' => '<p>Object that describes the frequency.</p>', 'refs' => [ 'SpectrumConfig$centerFrequency' => '<p>Center frequency of a spectral <code>Config</code>. Valid values are between 2200 to 2300 MHz and 7750 to 8400 MHz for downlink and 2025 to 2120 MHz for uplink.</p>', 'UplinkSpectrumConfig$centerFrequency' => '<p>Center frequency of an uplink spectral <code>Config</code>. Valid values are between 2025 to 2120 MHz.</p>', ], ], 'FrequencyBandwidth' => [ 'base' => '<p>Object that describes the frequency bandwidth. </p>', 'refs' => [ 'SpectrumConfig$bandwidth' => '<p>Bandwidth of a spectral <code>Config</code>. AWS Ground Station currently has the following bandwidth limitations:</p> <ul> <li> <p>For <code>AntennaDownlinkDemodDecodeconfig</code>, valid values are between 125 kHz to 650 MHz.</p> </li> <li> <p>For <code>AntennaDownlinkconfig</code> valid values are between 10 kHz to 54 MHz.</p> </li> <li> <p>For <code>AntennaUplinkConfig</code>, valid values are between 10 kHz to 54 MHz.</p> </li> </ul>', ], ], 'FrequencyUnits' => [ 'base' => NULL, 'refs' => [ 'Frequency$units' => '<p>Frequency units.</p>', ], ], 'GetAgentConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAgentConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetConfigRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'GetConfigResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'GetDataflowEndpointGroupRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'GetDataflowEndpointGroupResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'GetMinuteUsageRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'GetMinuteUsageResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'GetMissionProfileRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'GetMissionProfileResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'GetSatelliteRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'GetSatelliteResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'GroundStationData' => [ 'base' => '<p>Information about the ground station data.</p>', 'refs' => [ 'GroundStationList$member' => NULL, ], ], 'GroundStationIdList' => [ 'base' => NULL, 'refs' => [ 'GetSatelliteResponse$groundStations' => '<p>A list of ground stations to which the satellite is on-boarded.</p>', 'SatelliteListItem$groundStations' => '<p>A list of ground stations to which the satellite is on-boarded.</p>', ], ], 'GroundStationList' => [ 'base' => NULL, 'refs' => [ 'ListGroundStationsResponse$groundStationList' => '<p>List of ground stations.</p>', ], ], 'GroundStationName' => [ 'base' => NULL, 'refs' => [ 'GroundStationData$groundStationId' => '<p>UUID of a ground station.</p>', 'GroundStationData$groundStationName' => '<p>Name of a ground station.</p>', 'GroundStationIdList$member' => NULL, 'ListContactsRequest$groundStation' => '<p>Name of a ground station.</p>', 'ReserveContactRequest$groundStation' => '<p>Name of a ground station.</p>', ], ], 'InstanceId' => [ 'base' => NULL, 'refs' => [ 'AgentDetails$instanceId' => '<p>ID of EC2 instance agent is running on.</p>', ], ], 'InstanceType' => [ 'base' => NULL, 'refs' => [ 'AgentDetails$instanceType' => '<p>Type of EC2 instance agent is running on.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'AgentCpuCoresList$member' => NULL, 'ConnectionDetails$mtu' => '<p>Maximum transmission unit (MTU) size in bytes of a dataflow endpoint.</p>', 'GetMinuteUsageResponse$estimatedMinutesRemaining' => '<p>Estimated number of minutes remaining for an account, specific to the month being requested.</p>', 'GetMinuteUsageResponse$totalReservedMinuteAllocation' => '<p>Total number of reserved minutes allocated, specific to the month being requested.</p>', 'GetMinuteUsageResponse$totalScheduledMinutes' => '<p>Total scheduled minutes for an account, specific to the month being requested.</p>', 'GetMinuteUsageResponse$upcomingMinutesScheduled' => '<p>Upcoming minutes scheduled for an account, specific to the month being requested.</p>', 'IntegerRange$maximum' => '<p>A maximum value.</p>', 'IntegerRange$minimum' => '<p>A minimum value.</p>', 'SocketAddress$port' => '<p>Port of a socket address.</p>', ], ], 'IntegerRange' => [ 'base' => '<p>An integer range that has a minimum and maximum value.</p>', 'refs' => [ 'RangedSocketAddress$portRange' => '<p>Port range of a socket address.</p>', ], ], 'InvalidParameterException' => [ 'base' => '<p>One or more parameters are not valid.</p>', 'refs' => [], ], 'IpAddressList' => [ 'base' => NULL, 'refs' => [ 'DiscoveryData$privateIpAddresses' => '<p>List of private IP addresses to associate with agent.</p>', 'DiscoveryData$publicIpAddresses' => '<p>List of public IP addresses to associate with agent.</p>', ], ], 'IpV4Address' => [ 'base' => NULL, 'refs' => [ 'IpAddressList$member' => NULL, 'RangedSocketAddress$name' => '<p>IPv4 socket address.</p>', ], ], 'JsonString' => [ 'base' => NULL, 'refs' => [ 'DecodeConfig$unvalidatedJSON' => '<p>Unvalidated JSON of a decode <code>Config</code>.</p>', 'DemodulationConfig$unvalidatedJSON' => '<p>Unvalidated JSON of a demodulation <code>Config</code>.</p>', ], ], 'KeyAliasArn' => [ 'base' => NULL, 'refs' => [ 'KmsKey$kmsAliasArn' => '<p>KMS Alias Arn.</p>', ], ], 'KeyAliasName' => [ 'base' => NULL, 'refs' => [ 'KmsKey$kmsAliasName' => '<p>KMS Alias Name.</p>', ], ], 'KeyArn' => [ 'base' => NULL, 'refs' => [ 'CreateEphemerisRequest$kmsKeyArn' => '<p>The ARN of a KMS key used to encrypt the ephemeris in Ground Station.</p>', 'KmsKey$kmsKeyArn' => '<p>KMS Key Arn.</p>', ], ], 'KmsKey' => [ 'base' => '<p>AWS Key Management Service (KMS) Key.</p>', 'refs' => [ 'CreateMissionProfileRequest$streamsKmsKey' => '<p>KMS key to use for encrypting streams.</p>', 'GetMissionProfileResponse$streamsKmsKey' => '<p>KMS key to use for encrypting streams.</p>', 'UpdateMissionProfileRequest$streamsKmsKey' => '<p>KMS key to use for encrypting streams.</p>', ], ], 'ListConfigsRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'ListConfigsResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'ListContactsRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'ListContactsResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'ListDataflowEndpointGroupsRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'ListDataflowEndpointGroupsResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'ListEphemeridesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListEphemeridesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListGroundStationsRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'ListGroundStationsResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'ListMissionProfilesRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'ListMissionProfilesResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'ListSatellitesRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'ListSatellitesResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'ComponentStatusData$bytesReceived' => '<p>Bytes received by the component.</p>', 'ComponentStatusData$bytesSent' => '<p>Bytes sent by the component.</p>', 'ComponentStatusData$packetsDropped' => '<p>Packets dropped by component.</p>', ], ], 'MissionProfileArn' => [ 'base' => NULL, 'refs' => [ 'ContactData$missionProfileArn' => '<p>ARN of a mission profile.</p>', 'DescribeContactResponse$missionProfileArn' => '<p>ARN of a mission profile.</p>', 'GetMissionProfileResponse$missionProfileArn' => '<p>ARN of a mission profile.</p>', 'ListContactsRequest$missionProfileArn' => '<p>ARN of a mission profile.</p>', 'MissionProfileListItem$missionProfileArn' => '<p>ARN of a mission profile.</p>', 'ReserveContactRequest$missionProfileArn' => '<p>ARN of a mission profile.</p>', ], ], 'MissionProfileIdResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'MissionProfileList' => [ 'base' => NULL, 'refs' => [ 'ListMissionProfilesResponse$missionProfileList' => '<p>List of mission profiles.</p>', ], ], 'MissionProfileListItem' => [ 'base' => '<p>Item in a list of mission profiles.</p>', 'refs' => [ 'MissionProfileList$member' => NULL, ], ], 'Month' => [ 'base' => NULL, 'refs' => [ 'GetMinuteUsageRequest$month' => '<p>The month being requested, with a value of 1-12.</p>', ], ], 'OEMEphemeris' => [ 'base' => '<p> Ephemeris data in Orbit Ephemeris Message (OEM) format. </p> <p> Position, velocity, and acceleration units must be represented in <code>km</code>, <code>km/s</code>, and <code>km/s**2</code>, respectively, in ephemeris data lines. Covariance matrix line units must be represented in <code>km**2</code> if computed from two positions, <code>km**2/s</code> if computed from one position and one velocity, and <code>km**2/s**2</code> if computed from two velocities. Consult section 7.7.2 of The Consultative Committee for Space Data Systems (CCSDS) <a href="https://public.ccsds.org/Pubs/502x0b3e1.pdf">Recommended Standard for Orbit Data Messages</a> for more information. </p>', 'refs' => [ 'EphemerisData$oem' => NULL, ], ], 'PaginationMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListConfigsRequest$maxResults' => '<p>Maximum number of <code>Configs</code> returned.</p>', 'ListContactsRequest$maxResults' => '<p>Maximum number of contacts returned.</p>', 'ListDataflowEndpointGroupsRequest$maxResults' => '<p>Maximum number of dataflow endpoint groups returned.</p>', 'ListEphemeridesRequest$maxResults' => '<p>Maximum number of ephemerides to return.</p>', 'ListGroundStationsRequest$maxResults' => '<p>Maximum number of ground stations returned.</p>', 'ListMissionProfilesRequest$maxResults' => '<p>Maximum number of mission profiles returned.</p>', 'ListSatellitesRequest$maxResults' => '<p>Maximum number of satellites returned.</p>', ], ], 'PaginationToken' => [ 'base' => NULL, 'refs' => [ 'ListConfigsRequest$nextToken' => '<p>Next token returned in the request of a previous <code>ListConfigs</code> call. Used to get the next page of results.</p>', 'ListConfigsResponse$nextToken' => '<p>Next token returned in the response of a previous <code>ListConfigs</code> call. Used to get the next page of results.</p>', 'ListContactsRequest$nextToken' => '<p>Next token returned in the request of a previous <code>ListContacts</code> call. Used to get the next page of results.</p>', 'ListContactsResponse$nextToken' => '<p>Next token returned in the response of a previous <code>ListContacts</code> call. Used to get the next page of results.</p>', 'ListDataflowEndpointGroupsRequest$nextToken' => '<p>Next token returned in the request of a previous <code>ListDataflowEndpointGroups</code> call. Used to get the next page of results.</p>', 'ListDataflowEndpointGroupsResponse$nextToken' => '<p>Next token returned in the response of a previous <code>ListDataflowEndpointGroups</code> call. Used to get the next page of results.</p>', 'ListEphemeridesRequest$nextToken' => '<p>Pagination token.</p>', 'ListEphemeridesResponse$nextToken' => '<p>Pagination token.</p>', 'ListGroundStationsRequest$nextToken' => '<p>Next token that can be supplied in the next call to get the next page of ground stations.</p>', 'ListGroundStationsResponse$nextToken' => '<p>Next token that can be supplied in the next call to get the next page of ground stations.</p>', 'ListMissionProfilesRequest$nextToken' => '<p>Next token returned in the request of a previous <code>ListMissionProfiles</code> call. Used to get the next page of results.</p>', 'ListMissionProfilesResponse$nextToken' => '<p>Next token returned in the response of a previous <code>ListMissionProfiles</code> call. Used to get the next page of results.</p>', 'ListSatellitesRequest$nextToken' => '<p>Next token that can be supplied in the next call to get the next page of satellites.</p>', 'ListSatellitesResponse$nextToken' => '<p>Next token that can be supplied in the next call to get the next page of satellites.</p>', ], ], 'Polarization' => [ 'base' => NULL, 'refs' => [ 'SpectrumConfig$polarization' => '<p>Polarization of a spectral <code>Config</code>. Capturing both <code>"RIGHT_HAND"</code> and <code>"LEFT_HAND"</code> polarization requires two separate configs.</p>', 'UplinkSpectrumConfig$polarization' => '<p>Polarization of an uplink spectral <code>Config</code>. Capturing both <code>"RIGHT_HAND"</code> and <code>"LEFT_HAND"</code> polarization requires two separate configs.</p>', ], ], 'PositiveDurationInSeconds' => [ 'base' => NULL, 'refs' => [ 'CreateMissionProfileRequest$minimumViableContactDurationSeconds' => '<p>Smallest amount of time in seconds that you’d like to see for an available contact. AWS Ground Station will not present you with contacts shorter than this duration.</p>', 'GetMissionProfileResponse$minimumViableContactDurationSeconds' => '<p>Smallest amount of time in seconds that you’d like to see for an available contact. AWS Ground Station will not present you with contacts shorter than this duration.</p>', 'UpdateMissionProfileRequest$minimumViableContactDurationSeconds' => '<p>Smallest amount of time in seconds that you’d like to see for an available contact. AWS Ground Station will not present you with contacts shorter than this duration.</p>', ], ], 'RangedConnectionDetails' => [ 'base' => '<p>Ingress address of AgentEndpoint with a port range and an optional mtu.</p>', 'refs' => [ 'AwsGroundStationAgentEndpoint$ingressAddress' => '<p>The ingress address of AgentEndpoint.</p>', ], ], 'RangedConnectionDetailsMtuInteger' => [ 'base' => NULL, 'refs' => [ 'RangedConnectionDetails$mtu' => '<p>Maximum transmission unit (MTU) size in bytes of a dataflow endpoint.</p>', ], ], 'RangedSocketAddress' => [ 'base' => '<p>A socket address with a port range.</p>', 'refs' => [ 'RangedConnectionDetails$socketAddress' => '<p>A ranged socket address.</p>', ], ], 'RegisterAgentRequest' => [ 'base' => NULL, 'refs' => [], ], 'RegisterAgentResponse' => [ 'base' => NULL, 'refs' => [], ], 'ReserveContactRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'ResourceLimitExceededException' => [ 'base' => '<p>Account limits for this resource have been exceeded.</p>', 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>Resource was not found.</p>', 'refs' => [], ], 'RoleArn' => [ 'base' => NULL, 'refs' => [ 'CreateMissionProfileRequest$streamsKmsRole' => '<p>Role to use for encrypting streams with KMS key.</p>', 'GetMissionProfileResponse$streamsKmsRole' => '<p>Role to use for encrypting streams with KMS key.</p>', 'S3RecordingConfig$roleArn' => '<p>ARN of the role Ground Station assumes to write data to the bucket.</p>', 'SecurityDetails$roleArn' => '<p>ARN to a role needed for connecting streams to your instances. </p>', 'UpdateMissionProfileRequest$streamsKmsRole' => '<p>Role to use for encrypting streams with KMS key.</p>', ], ], 'S3BucketName' => [ 'base' => NULL, 'refs' => [ 'S3Object$bucket' => '<p>An Amazon S3 Bucket name.</p>', ], ], 'S3KeyPrefix' => [ 'base' => NULL, 'refs' => [ 'S3RecordingConfig$prefix' => '<p>S3 Key prefix to prefice data files.</p>', ], ], 'S3Object' => [ 'base' => '<p>Object stored in S3 containing ephemeris data.</p>', 'refs' => [ 'EphemerisDescription$sourceS3Object' => '<p>Source S3 object used for the ephemeris.</p>', 'EphemerisItem$sourceS3Object' => '<p>Source S3 object used for the ephemeris.</p>', 'OEMEphemeris$s3Object' => '<p>Identifies the S3 object to be used as the ephemeris.</p>', 'TLEEphemeris$s3Object' => '<p>Identifies the S3 object to be used as the ephemeris.</p>', ], ], 'S3ObjectKey' => [ 'base' => NULL, 'refs' => [ 'S3Object$key' => '<p>An Amazon S3 key for the ephemeris.</p>', ], ], 'S3RecordingConfig' => [ 'base' => '<p>Information about an S3 recording <code>Config</code>.</p>', 'refs' => [ 'ConfigTypeData$s3RecordingConfig' => '<p>Information about an S3 recording <code>Config</code>.</p>', ], ], 'S3RecordingDetails' => [ 'base' => '<p>Details about an S3 recording <code>Config</code> used in a contact.</p>', 'refs' => [ 'ConfigDetails$s3RecordingDetails' => '<p>Details for an S3 recording <code>Config</code> in a contact.</p>', ], ], 'S3VersionId' => [ 'base' => NULL, 'refs' => [ 'S3Object$version' => '<p>For versioned S3 objects, the version to use for the ephemeris.</p>', ], ], 'SafeName' => [ 'base' => NULL, 'refs' => [ 'AwsGroundStationAgentEndpoint$name' => '<p>Name string associated with AgentEndpoint. Used as a human-readable identifier for AgentEndpoint.</p>', 'CreateConfigRequest$name' => '<p>Name of a <code>Config</code>.</p>', 'CreateEphemerisRequest$name' => '<p>A name string associated with the ephemeris. Used as a human-readable identifier for the ephemeris.</p>', 'CreateMissionProfileRequest$name' => '<p>Name of a mission profile.</p>', 'DataflowEndpoint$name' => '<p>Name of a dataflow endpoint.</p>', 'DescribeEphemerisResponse$name' => '<p>A name string associated with the ephemeris. Used as a human-readable identifier for the ephemeris.</p>', 'EphemerisItem$name' => '<p>A name string associated with the ephemeris. Used as a human-readable identifier for the ephemeris.</p>', 'EphemerisMetaData$name' => '<p>A name string associated with the ephemeris. Used as a human-readable identifier for the ephemeris.</p> <p>A name is only returned for customer-provider ephemerides that have a name associated.</p>', 'GetMissionProfileResponse$name' => '<p>Name of a mission profile.</p>', 'MissionProfileListItem$name' => '<p>Name of a mission profile.</p>', 'UpdateConfigRequest$name' => '<p>Name of a <code>Config</code>.</p>', 'UpdateEphemerisRequest$name' => '<p>A name string associated with the ephemeris. Used as a human-readable identifier for the ephemeris.</p>', 'UpdateMissionProfileRequest$name' => '<p>Name of a mission profile.</p>', ], ], 'SatelliteList' => [ 'base' => NULL, 'refs' => [ 'ListSatellitesResponse$satellites' => '<p>List of satellites.</p>', ], ], 'SatelliteListItem' => [ 'base' => '<p>Item in a list of satellites.</p>', 'refs' => [ 'SatelliteList$member' => NULL, ], ], 'SecurityDetails' => [ 'base' => '<p>Information about endpoints.</p>', 'refs' => [ 'EndpointDetails$securityDetails' => '<p>Endpoint security details including a list of subnets, a list of security groups and a role to connect streams to instances.</p>', ], ], 'SecurityGroupIdList' => [ 'base' => NULL, 'refs' => [ 'SecurityDetails$securityGroupIds' => '<p>The security groups to attach to the elastic network interfaces.</p>', ], ], 'SignatureMap' => [ 'base' => NULL, 'refs' => [ 'AggregateStatus$signatureMap' => '<p>Sparse map of failure signatures.</p>', ], ], 'SocketAddress' => [ 'base' => '<p>Information about the socket address.</p>', 'refs' => [ 'ConnectionDetails$socketAddress' => '<p>A socket address.</p>', 'DataflowEndpoint$address' => '<p>Socket address of a dataflow endpoint.</p>', ], ], 'Source' => [ 'base' => '<p>Dataflow details for the source side.</p>', 'refs' => [ 'DataflowDetail$source' => NULL, ], ], 'SpectrumConfig' => [ 'base' => '<p>Object that describes a spectral <code>Config</code>.</p>', 'refs' => [ 'AntennaDownlinkConfig$spectrumConfig' => '<p>Object that describes a spectral <code>Config</code>.</p>', 'AntennaDownlinkDemodDecodeConfig$spectrumConfig' => '<p>Information about the spectral <code>Config</code>.</p>', ], ], 'StatusList' => [ 'base' => NULL, 'refs' => [ 'ListContactsRequest$statusList' => '<p>Status of a contact reservation.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AntennaDemodDecodeDetails$outputNode' => '<p>Name of an antenna demod decode output node used in a contact.</p>', 'ConfigIdResponse$configId' => '<p>UUID of a <code>Config</code>.</p>', 'ConfigListItem$configId' => '<p>UUID of a <code>Config</code>.</p>', 'ConfigListItem$name' => '<p>Name of a <code>Config</code>.</p>', 'ContactData$errorMessage' => '<p>Error message of a contact.</p>', 'ContactData$groundStation' => '<p>Name of a ground station.</p>', 'ContactData$region' => '<p>Region of a contact.</p>', 'DataflowDetail$errorMessage' => '<p>Error message for a dataflow.</p>', 'DataflowEndpointConfig$dataflowEndpointName' => '<p>Name of a dataflow endpoint.</p>', 'DataflowEndpointConfig$dataflowEndpointRegion' => '<p>Region of a dataflow endpoint.</p>', 'DependencyException$message' => NULL, 'DependencyException$parameterName' => '<p/>', 'DescribeContactResponse$errorMessage' => '<p>Error message for a contact.</p>', 'DescribeContactResponse$groundStation' => '<p>Ground station for a contact.</p>', 'DescribeContactResponse$region' => '<p>Region of a contact.</p>', 'Destination$dataflowDestinationRegion' => '<p>Region of a dataflow destination.</p>', 'GetAgentConfigurationResponse$taskingDocument' => '<p>Tasking document for agent.</p>', 'GetConfigResponse$configId' => '<p>UUID of a <code>Config</code>.</p>', 'GetConfigResponse$name' => '<p>Name of a <code>Config</code>.</p>', 'InvalidParameterException$message' => NULL, 'InvalidParameterException$parameterName' => '<p/>', 'ResourceLimitExceededException$message' => NULL, 'ResourceLimitExceededException$parameterName' => '<p/>', 'ResourceNotFoundException$message' => NULL, 'S3RecordingDetails$keyTemplate' => '<p>Key template used for the S3 Recording Configuration</p>', 'SecurityGroupIdList$member' => NULL, 'SignatureMap$key' => NULL, 'SocketAddress$name' => '<p>Name of a socket address.</p>', 'Source$configId' => '<p>UUID of a <code>Config</code>.</p>', 'Source$dataflowSourceRegion' => '<p>Region of a dataflow source.</p>', 'SubnetList$member' => NULL, 'TagsMap$key' => NULL, 'TagsMap$value' => NULL, ], ], 'SubnetList' => [ 'base' => NULL, 'refs' => [ 'SecurityDetails$subnetIds' => '<p>A list of subnets where AWS Ground Station places elastic network interfaces to send streams to your instances.</p>', ], ], 'TLEData' => [ 'base' => '<p>Two-line element set (TLE) data.</p>', 'refs' => [ 'TLEDataList$member' => NULL, ], ], 'TLEDataList' => [ 'base' => NULL, 'refs' => [ 'TLEEphemeris$tleData' => '<p>The data for a TLE ephemeris, supplied directly in the request rather than through an S3 object.</p>', ], ], 'TLEEphemeris' => [ 'base' => '<p>Two-line element set (TLE) ephemeris.</p>', 'refs' => [ 'EphemerisData$tle' => NULL, ], ], 'TagKeys' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>Keys of a resource tag.</p>', ], ], 'TagResourceRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'TagResourceResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'TagsMap' => [ 'base' => NULL, 'refs' => [ 'ContactData$tags' => '<p>Tags assigned to a contact.</p>', 'CreateConfigRequest$tags' => '<p>Tags assigned to a <code>Config</code>.</p>', 'CreateDataflowEndpointGroupRequest$tags' => '<p>Tags of a dataflow endpoint group.</p>', 'CreateEphemerisRequest$tags' => '<p>Tags assigned to an ephemeris.</p>', 'CreateMissionProfileRequest$tags' => '<p>Tags assigned to a mission profile.</p>', 'DescribeContactResponse$tags' => '<p>Tags assigned to a contact.</p>', 'DescribeEphemerisResponse$tags' => '<p>Tags assigned to an ephemeris.</p>', 'GetConfigResponse$tags' => '<p>Tags assigned to a <code>Config</code>.</p>', 'GetDataflowEndpointGroupResponse$tags' => '<p>Tags assigned to a dataflow endpoint group.</p>', 'GetMissionProfileResponse$tags' => '<p>Tags assigned to a mission profile.</p>', 'ListTagsForResourceResponse$tags' => '<p>Tags assigned to a resource.</p>', 'ReserveContactRequest$tags' => '<p>Tags assigned to a contact.</p>', 'TagResourceRequest$tags' => '<p>Tags assigned to a resource.</p>', ], ], 'TimeRange' => [ 'base' => '<p>A time range with a start and end time.</p>', 'refs' => [ 'TLEData$validTimeRange' => '<p>The valid time range for the TLE. Gaps or overlap are not permitted.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'ContactData$endTime' => '<p>End time of a contact in UTC.</p>', 'ContactData$postPassEndTime' => '<p>Amount of time after a contact ends that you’d like to receive a CloudWatch event indicating the pass has finished.</p>', 'ContactData$prePassStartTime' => '<p>Amount of time prior to contact start you’d like to receive a CloudWatch event indicating an upcoming pass.</p>', 'ContactData$startTime' => '<p>Start time of a contact in UTC.</p>', 'ContactData$visibilityEndTime' => '<p> Projected time in UTC your satellite will set below the <a href="https://docs.aws.amazon.com/ground-station/latest/ug/site-masks.html">receive mask</a>. This time is based on the satellite\'s current active ephemeris for future contacts and the ephemeris that was active during contact execution for completed contacts. <i>This field is not present for contacts with a <code>SCHEDULING</code> or <code>SCHEDULED</code> status.</i> </p>', 'ContactData$visibilityStartTime' => '<p> Projected time in UTC your satellite will rise above the <a href="https://docs.aws.amazon.com/ground-station/latest/ug/site-masks.html">receive mask</a>. This time is based on the satellite\'s current active ephemeris for future contacts and the ephemeris that was active during contact execution for completed contacts. <i>This field is not present for contacts with a <code>SCHEDULING</code> or <code>SCHEDULED</code> status.</i> </p>', 'CreateEphemerisRequest$expirationTime' => '<p>An overall expiration time for the ephemeris in UTC, after which it will become <code>EXPIRED</code>.</p>', 'DescribeContactResponse$endTime' => '<p>End time of a contact in UTC.</p>', 'DescribeContactResponse$postPassEndTime' => '<p>Amount of time after a contact ends that you’d like to receive a CloudWatch event indicating the pass has finished.</p>', 'DescribeContactResponse$prePassStartTime' => '<p>Amount of time prior to contact start you’d like to receive a CloudWatch event indicating an upcoming pass.</p>', 'DescribeContactResponse$startTime' => '<p>Start time of a contact in UTC.</p>', 'DescribeContactResponse$visibilityEndTime' => '<p> Projected time in UTC your satellite will set below the <a href="https://docs.aws.amazon.com/ground-station/latest/ug/site-masks.html">receive mask</a>. This time is based on the satellite\'s current active ephemeris for future contacts and the ephemeris that was active during contact execution for completed contacts. </p>', 'DescribeContactResponse$visibilityStartTime' => '<p> Projected time in UTC your satellite will rise above the <a href="https://docs.aws.amazon.com/ground-station/latest/ug/site-masks.html">receive mask</a>. This time is based on the satellite\'s current active ephemeris for future contacts and the ephemeris that was active during contact execution for completed contacts. </p>', 'DescribeEphemerisResponse$creationTime' => '<p>The time the ephemeris was uploaded in UTC.</p>', 'EphemerisItem$creationTime' => '<p>The time the ephemeris was uploaded in UTC.</p>', 'EphemerisMetaData$epoch' => '<p>The epoch of a default, ephemeris from Space Track in UTC.</p> <p>This field is not populated for customer-provided ephemerides.</p>', 'ListContactsRequest$endTime' => '<p>End time of a contact in UTC.</p>', 'ListContactsRequest$startTime' => '<p>Start time of a contact in UTC.</p>', 'ListEphemeridesRequest$endTime' => '<p>The end time to list in UTC. The operation will return an ephemeris if its expiration time is within the time range defined by the <code>startTime</code> and <code>endTime</code>.</p>', 'ListEphemeridesRequest$startTime' => '<p>The start time to list in UTC. The operation will return an ephemeris if its expiration time is within the time range defined by the <code>startTime</code> and <code>endTime</code>.</p>', 'ReserveContactRequest$endTime' => '<p>End time of a contact in UTC.</p>', 'ReserveContactRequest$startTime' => '<p>Start time of a contact in UTC.</p>', 'TimeRange$endTime' => '<p>Time in UTC at which the time range ends.</p>', 'TimeRange$startTime' => '<p>Time in UTC at which the time range starts.</p>', ], ], 'TleLineOne' => [ 'base' => NULL, 'refs' => [ 'TLEData$tleLine1' => '<p>First line of two-line element set (TLE) data.</p>', ], ], 'TleLineTwo' => [ 'base' => NULL, 'refs' => [ 'TLEData$tleLine2' => '<p>Second line of two-line element set (TLE) data.</p>', ], ], 'TrackingConfig' => [ 'base' => '<p>Object that determines whether tracking should be used during a contact executed with this <code>Config</code> in the mission profile.</p>', 'refs' => [ 'ConfigTypeData$trackingConfig' => '<p>Object that determines whether tracking should be used during a contact executed with this <code>Config</code> in the mission profile. </p>', ], ], 'UnboundedString' => [ 'base' => NULL, 'refs' => [ 'EphemerisDescription$ephemerisData' => '<p>Supplied ephemeris data.</p>', 'OEMEphemeris$oemData' => '<p>The data for an OEM ephemeris, supplied directly in the request rather than through an S3 object.</p>', 'TagKeys$member' => NULL, ], ], 'UntagResourceRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => '<p/>', 'refs' => [], ], 'UpdateAgentStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAgentStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateConfigRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'UpdateEphemerisRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMissionProfileRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'UplinkEchoConfig' => [ 'base' => '<p>Information about an uplink echo <code>Config</code>.</p> <p>Parameters from the <code>AntennaUplinkConfig</code>, corresponding to the specified <code>AntennaUplinkConfigArn</code>, are used when this <code>UplinkEchoConfig</code> is used in a contact.</p>', 'refs' => [ 'ConfigTypeData$uplinkEchoConfig' => '<p>Information about an uplink echo <code>Config</code>.</p> <p>Parameters from the <code>AntennaUplinkConfig</code>, corresponding to the specified <code>AntennaUplinkConfigArn</code>, are used when this <code>UplinkEchoConfig</code> is used in a contact.</p>', ], ], 'UplinkSpectrumConfig' => [ 'base' => '<p>Information about the uplink spectral <code>Config</code>.</p>', 'refs' => [ 'AntennaUplinkConfig$spectrumConfig' => '<p>Information about the uplink spectral <code>Config</code>.</p>', ], ], 'Uuid' => [ 'base' => NULL, 'refs' => [ 'CancelContactRequest$contactId' => '<p>UUID of a contact.</p>', 'ComponentStatusData$dataflowId' => '<p>Dataflow UUID associated with the component.</p>', 'ContactData$contactId' => '<p>UUID of a contact.</p>', 'ContactIdResponse$contactId' => '<p>UUID of a contact.</p>', 'CreateEphemerisRequest$satelliteId' => '<p>AWS Ground Station satellite ID for this ephemeris.</p>', 'DataflowEndpointGroupIdResponse$dataflowEndpointGroupId' => '<p>UUID of a dataflow endpoint group.</p>', 'DataflowEndpointListItem$dataflowEndpointGroupId' => '<p>UUID of a dataflow endpoint group.</p>', 'DeleteConfigRequest$configId' => '<p>UUID of a <code>Config</code>.</p>', 'DeleteDataflowEndpointGroupRequest$dataflowEndpointGroupId' => '<p>UUID of a dataflow endpoint group.</p>', 'DeleteEphemerisRequest$ephemerisId' => '<p>The AWS Ground Station ephemeris ID.</p>', 'DeleteMissionProfileRequest$missionProfileId' => '<p>UUID of a mission profile.</p>', 'DescribeContactRequest$contactId' => '<p>UUID of a contact.</p>', 'DescribeContactResponse$contactId' => '<p>UUID of a contact.</p>', 'DescribeEphemerisRequest$ephemerisId' => '<p>The AWS Ground Station ephemeris ID.</p>', 'DescribeEphemerisResponse$ephemerisId' => '<p>The AWS Ground Station ephemeris ID.</p>', 'DescribeEphemerisResponse$satelliteId' => '<p>The AWS Ground Station satellite ID associated with ephemeris.</p>', 'Destination$configId' => '<p>UUID of a <code>Config</code>.</p>', 'EphemerisIdResponse$ephemerisId' => '<p>The AWS Ground Station ephemeris ID.</p>', 'EphemerisItem$ephemerisId' => '<p>The AWS Ground Station ephemeris ID.</p>', 'EphemerisMetaData$ephemerisId' => '<p>UUID of a customer-provided ephemeris.</p> <p>This field is not populated for default ephemerides from Space Track.</p>', 'GetAgentConfigurationRequest$agentId' => '<p>UUID of agent to get configuration information for.</p>', 'GetAgentConfigurationResponse$agentId' => '<p>UUID of agent.</p>', 'GetConfigRequest$configId' => '<p>UUID of a <code>Config</code>.</p>', 'GetDataflowEndpointGroupRequest$dataflowEndpointGroupId' => '<p>UUID of a dataflow endpoint group.</p>', 'GetDataflowEndpointGroupResponse$dataflowEndpointGroupId' => '<p>UUID of a dataflow endpoint group.</p>', 'GetMissionProfileRequest$missionProfileId' => '<p>UUID of a mission profile.</p>', 'GetMissionProfileResponse$missionProfileId' => '<p>UUID of a mission profile.</p>', 'GetSatelliteRequest$satelliteId' => '<p>UUID of a satellite.</p>', 'GetSatelliteResponse$satelliteId' => '<p>UUID of a satellite.</p>', 'ListEphemeridesRequest$satelliteId' => '<p>The AWS Ground Station satellite ID to list ephemeris for.</p>', 'ListGroundStationsRequest$satelliteId' => '<p>Satellite ID to retrieve on-boarded ground stations.</p>', 'MissionProfileIdResponse$missionProfileId' => '<p>UUID of a mission profile.</p>', 'MissionProfileListItem$missionProfileId' => '<p>UUID of a mission profile.</p>', 'RegisterAgentResponse$agentId' => '<p>UUID of registered agent.</p>', 'SatelliteListItem$satelliteId' => '<p>UUID of a satellite.</p>', 'UpdateAgentStatusRequest$agentId' => '<p>UUID of agent to update.</p>', 'UpdateAgentStatusRequest$taskId' => '<p>GUID of agent task.</p>', 'UpdateAgentStatusResponse$agentId' => '<p>UUID of updated agent.</p>', 'UpdateConfigRequest$configId' => '<p>UUID of a <code>Config</code>.</p>', 'UpdateEphemerisRequest$ephemerisId' => '<p>The AWS Ground Station ephemeris ID.</p>', 'UpdateMissionProfileRequest$missionProfileId' => '<p>UUID of a mission profile.</p>', ], ], 'VersionString' => [ 'base' => NULL, 'refs' => [ 'AgentDetails$agentVersion' => '<p>Current agent version.</p>', 'VersionStringList$member' => NULL, ], ], 'VersionStringList' => [ 'base' => NULL, 'refs' => [ 'ComponentVersion$versions' => '<p>List of versions.</p>', ], ], 'Year' => [ 'base' => NULL, 'refs' => [ 'GetMinuteUsageRequest$year' => '<p>The year being requested, in the format of YYYY.</p>', ], ], 'noradSatelliteID' => [ 'base' => NULL, 'refs' => [ 'GetSatelliteResponse$noradSatelliteID' => '<p>NORAD satellite ID number.</p>', 'SatelliteListItem$noradSatelliteID' => '<p>NORAD satellite ID number.</p>', ], ], 'satelliteArn' => [ 'base' => NULL, 'refs' => [ 'ContactData$satelliteArn' => '<p>ARN of a satellite.</p>', 'DescribeContactResponse$satelliteArn' => '<p>ARN of a satellite.</p>', 'GetSatelliteResponse$satelliteArn' => '<p>ARN of a satellite.</p>', 'ListContactsRequest$satelliteArn' => '<p>ARN of a satellite.</p>', 'ReserveContactRequest$satelliteArn' => '<p>ARN of a satellite</p>', 'SatelliteListItem$satelliteArn' => '<p>ARN of a satellite.</p>', ], ], ],];
