<?php
// This file was auto-generated from sdk-root/src/data/healthlake/2017-07-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>AWS HealthLake is a HIPAA eligibile service that allows customers to store, transform, query, and analyze their FHIR-formatted data in a consistent fashion in the cloud.</p>', 'operations' => [ 'CreateFHIRDatastore' => '<p>Creates a data store that can ingest and export FHIR formatted data.</p>', 'DeleteFHIRDatastore' => '<p>Deletes a data store. </p>', 'DescribeFHIRDatastore' => '<p>Gets the properties associated with the FHIR data store, including the data store ID, data store ARN, data store name, data store status, when the data store was created, data store type version, and the data store\'s endpoint.</p>', 'DescribeFHIRExportJob' => '<p>Displays the properties of a FHIR export job, including the ID, ARN, name, and the status of the job.</p>', 'DescribeFHIRImportJob' => '<p>Displays the properties of a FHIR import job, including the ID, ARN, name, and the status of the job. </p>', 'ListFHIRDatastores' => '<p>Lists all FHIR data stores that are in the user’s account, regardless of data store status.</p>', 'ListFHIRExportJobs' => '<p> Lists all FHIR export jobs associated with an account and their statuses. </p>', 'ListFHIRImportJobs' => '<p> Lists all FHIR import jobs associated with an account and their statuses. </p>', 'ListTagsForResource' => '<p> Returns a list of all existing tags associated with a data store. </p>', 'StartFHIRExportJob' => '<p>Begins a FHIR export job.</p>', 'StartFHIRImportJob' => '<p>Begins a FHIR Import job.</p>', 'TagResource' => '<p> Adds a user specified key and value tag to a data store. </p>', 'UntagResource' => '<p> Removes tags from a data store. </p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>Access is denied. Your account is not authorized to perform this operation.</p>', 'refs' => [], ], 'AmazonResourceName' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$ResourceARN' => '<p> The Amazon Resource Name(ARN) of the data store for which tags are being added. </p>', 'TagResourceRequest$ResourceARN' => '<p> The Amazon Resource Name(ARN)that gives AWS HealthLake access to the data store which tags are being added to. </p>', 'UntagResourceRequest$ResourceARN' => '<p>The Amazon Resource Name(ARN) of the data store for which tags are being removed.</p>', ], ], 'AuthorizationStrategy' => [ 'base' => NULL, 'refs' => [ 'IdentityProviderConfiguration$AuthorizationStrategy' => '<p>The authorization strategy that you selected when you created the data store.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'IdentityProviderConfiguration$FineGrainedAuthorizationEnabled' => '<p>If you enabled fine-grained authorization when you created the data store.</p>', ], ], 'BoundedLengthString' => [ 'base' => NULL, 'refs' => [ 'CreateFHIRDatastoreResponse$DatastoreEndpoint' => '<p>The AWS endpoint for the created data store.</p>', 'DeleteFHIRDatastoreResponse$DatastoreEndpoint' => '<p>The AWS endpoint for the data store the user has requested to be deleted.</p>', ], ], 'ClientTokenString' => [ 'base' => NULL, 'refs' => [ 'CreateFHIRDatastoreRequest$ClientToken' => '<p>Optional user provided token used for ensuring idempotency.</p>', 'StartFHIRExportJobRequest$ClientToken' => '<p>An optional user provided token used for ensuring idempotency.</p>', 'StartFHIRImportJobRequest$ClientToken' => '<p>Optional user provided token used for ensuring idempotency.</p>', ], ], 'CmkType' => [ 'base' => NULL, 'refs' => [ 'KmsEncryptionConfig$CmkType' => '<p> The type of customer-managed-key(CMK) used for encryption. The two types of supported CMKs are customer owned CMKs and AWS owned CMKs. </p>', ], ], 'ConfigurationMetadata' => [ 'base' => NULL, 'refs' => [ 'IdentityProviderConfiguration$Metadata' => '<p>The JSON metadata elements that you want to use in your identity provider configuration. Required elements are listed based on the launch specification of the SMART application. For more information on all possible elements, see <a href="https://build.fhir.org/ig/HL7/smart-app-launch/conformance.html#metadata">Metadata</a> in SMART\'s App Launch specification.</p> <p> <code>authorization_endpoint</code>: The URL to the OAuth2 authorization endpoint.</p> <p> <code>grant_types_supported</code>: An array of grant types that are supported at the token endpoint. You must provide at least one grant type option. Valid options are <code>authorization_code</code> and <code>client_credentials</code>.</p> <p> <code>token_endpoint</code>: The URL to the OAuth2 token endpoint.</p> <p> <code>capabilities</code>: An array of strings of the SMART capabilities that the authorization server supports.</p> <p> <code>code_challenge_methods_supported</code>: An array of strings of supported PKCE code challenge methods. You must include the <code>S256</code> method in the array of PKCE code challenge methods.</p>', ], ], 'ConflictException' => [ 'base' => '<p>The data store is in a transition state and the user requested action can not be performed.</p>', 'refs' => [], ], 'CreateFHIRDatastoreRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateFHIRDatastoreResponse' => [ 'base' => NULL, 'refs' => [], ], 'DatastoreArn' => [ 'base' => NULL, 'refs' => [ 'CreateFHIRDatastoreResponse$DatastoreArn' => '<p>The data store ARN is generated during the creation of the data store and can be found in the output from the initial data store creation call.</p>', 'DatastoreProperties$DatastoreArn' => '<p>The Amazon Resource Name used in the creation of the data store.</p>', 'DeleteFHIRDatastoreResponse$DatastoreArn' => '<p>The Amazon Resource Name (ARN) that gives AWS HealthLake access permission.</p>', ], ], 'DatastoreFilter' => [ 'base' => '<p>The filters applied to data store query.</p>', 'refs' => [ 'ListFHIRDatastoresRequest$Filter' => '<p>Lists all filters associated with a FHIR data store request.</p>', ], ], 'DatastoreId' => [ 'base' => NULL, 'refs' => [ 'CreateFHIRDatastoreResponse$DatastoreId' => '<p>The AWS-generated data store id. This id is in the output from the initial data store creation call.</p>', 'DatastoreProperties$DatastoreId' => '<p>The AWS-generated ID number for the data store.</p>', 'DeleteFHIRDatastoreRequest$DatastoreId' => '<p> The AWS-generated ID for the data store to be deleted.</p>', 'DeleteFHIRDatastoreResponse$DatastoreId' => '<p>The AWS-generated ID for the data store to be deleted.</p>', 'DescribeFHIRDatastoreRequest$DatastoreId' => '<p>The AWS-generated data store ID.</p>', 'DescribeFHIRExportJobRequest$DatastoreId' => '<p>The AWS generated ID for the data store from which files are being exported from for an export job.</p>', 'DescribeFHIRImportJobRequest$DatastoreId' => '<p>The AWS-generated ID of the data store.</p>', 'ExportJobProperties$DatastoreId' => '<p>The AWS generated ID for the data store from which files are being exported for an export job.</p>', 'ImportJobProperties$DatastoreId' => '<p>The datastore id used when the Import job was created. </p>', 'ListFHIRExportJobsRequest$DatastoreId' => '<p> This parameter limits the response to the export job with the specified data store ID. </p>', 'ListFHIRImportJobsRequest$DatastoreId' => '<p> This parameter limits the response to the import job with the specified data store ID. </p>', 'StartFHIRExportJobRequest$DatastoreId' => '<p>The AWS generated ID for the data store from which files are being exported for an export job.</p>', 'StartFHIRExportJobResponse$DatastoreId' => '<p>The AWS generated ID for the data store from which files are being exported for an export job.</p>', 'StartFHIRImportJobRequest$DatastoreId' => '<p>The AWS-generated data store ID.</p>', 'StartFHIRImportJobResponse$DatastoreId' => '<p>The AWS-generated data store ID.</p>', ], ], 'DatastoreName' => [ 'base' => NULL, 'refs' => [ 'CreateFHIRDatastoreRequest$DatastoreName' => '<p>The user generated name for the data store.</p>', 'DatastoreFilter$DatastoreName' => '<p>Allows the user to filter data store results by name.</p>', 'DatastoreProperties$DatastoreName' => '<p>The user-generated name for the data store.</p>', ], ], 'DatastoreProperties' => [ 'base' => '<p>Displays the properties of the data store, including the ID, ARN, name, and the status of the data store.</p>', 'refs' => [ 'DatastorePropertiesList$member' => NULL, 'DescribeFHIRDatastoreResponse$DatastoreProperties' => '<p>All properties associated with a data store, including the data store ID, data store ARN, data store name, data store status, when the data store was created, data store type version, and the data store\'s endpoint.</p>', ], ], 'DatastorePropertiesList' => [ 'base' => NULL, 'refs' => [ 'ListFHIRDatastoresResponse$DatastorePropertiesList' => '<p>All properties associated with the listed data stores.</p>', ], ], 'DatastoreStatus' => [ 'base' => NULL, 'refs' => [ 'CreateFHIRDatastoreResponse$DatastoreStatus' => '<p>The status of the FHIR data store.</p>', 'DatastoreFilter$DatastoreStatus' => '<p>Allows the user to filter data store results by status.</p>', 'DatastoreProperties$DatastoreStatus' => '<p>The status of the data store.</p>', 'DeleteFHIRDatastoreResponse$DatastoreStatus' => '<p>The status of the data store that the user has requested to be deleted. </p>', ], ], 'DeleteFHIRDatastoreRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFHIRDatastoreResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFHIRDatastoreRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFHIRDatastoreResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFHIRExportJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFHIRExportJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFHIRImportJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFHIRImportJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'EncryptionKeyID' => [ 'base' => NULL, 'refs' => [ 'KmsEncryptionConfig$KmsKeyId' => '<p> The KMS encryption key id/alias used to encrypt the data store contents at rest. </p>', 'S3Configuration$KmsKeyId' => '<p> The KMS key ID used to access the S3 bucket. </p>', ], ], 'ErrorCategory' => [ 'base' => NULL, 'refs' => [ 'ErrorCause$ErrorCategory' => '<p>The error category of the create/delete data store operation. Possible statuses are RETRYABLE_ERROR or NON_RETRYABLE_ERROR.</p>', ], ], 'ErrorCause' => [ 'base' => '<p>The error info of the create/delete data store operation.</p>', 'refs' => [ 'DatastoreProperties$ErrorCause' => '<p>The error cause for the current data store operation.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'ErrorCause$ErrorMessage' => '<p>The text of the error message.</p>', ], ], 'ExportJobProperties' => [ 'base' => '<p>The properties of a FHIR export job, including the ID, ARN, name, and the status of the job.</p>', 'refs' => [ 'DescribeFHIRExportJobResponse$ExportJobProperties' => '<p>Displays the properties of the export job, including the ID, Arn, Name, and the status of the job. </p>', 'ExportJobPropertiesList$member' => NULL, ], ], 'ExportJobPropertiesList' => [ 'base' => NULL, 'refs' => [ 'ListFHIRExportJobsResponse$ExportJobPropertiesList' => '<p> The properties of listed FHIR export jobs, including the ID, ARN, name, and the status of the job. </p>', ], ], 'FHIRVersion' => [ 'base' => NULL, 'refs' => [ 'CreateFHIRDatastoreRequest$DatastoreTypeVersion' => '<p>The FHIR version of the data store. The only supported version is R4.</p>', 'DatastoreProperties$DatastoreTypeVersion' => '<p>The FHIR version. Only R4 version data is supported.</p>', ], ], 'GenericDouble' => [ 'base' => NULL, 'refs' => [ 'JobProgressReport$TotalSizeOfScannedFilesInMB' => '<p>The size (in MB) of the files scanned from the input S3 bucket.</p>', 'JobProgressReport$Throughput' => '<p>The throughput (in MB/sec) of the import job.</p>', ], ], 'GenericLong' => [ 'base' => NULL, 'refs' => [ 'JobProgressReport$TotalNumberOfScannedFiles' => '<p>The number of files scanned from input S3 bucket.</p>', 'JobProgressReport$TotalNumberOfImportedFiles' => '<p>The number of files imported so far.</p>', 'JobProgressReport$TotalNumberOfResourcesScanned' => '<p>The number of resources scanned from the input S3 bucket.</p>', 'JobProgressReport$TotalNumberOfResourcesImported' => '<p>The number of resources imported so far.</p>', 'JobProgressReport$TotalNumberOfResourcesWithCustomerError' => '<p>The number of resources that failed due to customer error.</p>', 'JobProgressReport$TotalNumberOfFilesReadWithCustomerError' => '<p>The number of files that failed to be read from the input S3 bucket due to customer error.</p>', ], ], 'IamRoleArn' => [ 'base' => NULL, 'refs' => [ 'ExportJobProperties$DataAccessRoleArn' => '<p>The Amazon Resource Name used during the initiation of the job.</p>', 'ImportJobProperties$DataAccessRoleArn' => '<p>The Amazon Resource Name (ARN) that gives AWS HealthLake access to your input data.</p>', 'StartFHIRExportJobRequest$DataAccessRoleArn' => '<p>The Amazon Resource Name used during the initiation of the job.</p>', 'StartFHIRImportJobRequest$DataAccessRoleArn' => '<p>The Amazon Resource Name (ARN) that gives AWS HealthLake access permission.</p>', ], ], 'IdentityProviderConfiguration' => [ 'base' => '<p>The identity provider configuration that you gave when the data store was created.</p>', 'refs' => [ 'CreateFHIRDatastoreRequest$IdentityProviderConfiguration' => '<p>The configuration of the identity provider that you want to use for your data store.</p>', 'DatastoreProperties$IdentityProviderConfiguration' => '<p>The identity provider that you selected when you created the data store.</p>', ], ], 'ImportJobProperties' => [ 'base' => '<p>Displays the properties of the import job, including the ID, Arn, Name, the status of the job, and the progress report of the job.</p>', 'refs' => [ 'DescribeFHIRImportJobResponse$ImportJobProperties' => '<p>The properties of the Import job request, including the ID, ARN, name, status of the job, and the progress report of the job.</p>', 'ImportJobPropertiesList$member' => NULL, ], ], 'ImportJobPropertiesList' => [ 'base' => NULL, 'refs' => [ 'ListFHIRImportJobsResponse$ImportJobPropertiesList' => '<p> The properties of a listed FHIR import jobs, including the ID, ARN, name, the status of the job, and the progress report of the job. </p>', ], ], 'InputDataConfig' => [ 'base' => '<p> The input properties for an import job.</p>', 'refs' => [ 'ImportJobProperties$InputDataConfig' => '<p>The input data configuration that was supplied when the Import job was created.</p>', 'StartFHIRImportJobRequest$InputDataConfig' => '<p>The input properties of the FHIR Import job in the StartFHIRImport job request.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>Unknown error occurs in the service.</p>', 'refs' => [], ], 'JobId' => [ 'base' => NULL, 'refs' => [ 'DescribeFHIRExportJobRequest$JobId' => '<p>The AWS generated ID for an export job.</p>', 'DescribeFHIRImportJobRequest$JobId' => '<p>The AWS-generated job ID.</p>', 'ExportJobProperties$JobId' => '<p>The AWS generated ID for an export job.</p>', 'ImportJobProperties$JobId' => '<p>The AWS-generated id number for the Import job.</p>', 'StartFHIRExportJobResponse$JobId' => '<p>The AWS generated ID for an export job.</p>', 'StartFHIRImportJobResponse$JobId' => '<p>The AWS-generated job ID.</p>', ], ], 'JobName' => [ 'base' => NULL, 'refs' => [ 'ExportJobProperties$JobName' => '<p>The user generated name for an export job.</p>', 'ImportJobProperties$JobName' => '<p>The user-generated name for an Import job.</p>', 'ListFHIRExportJobsRequest$JobName' => '<p> This parameter limits the response to the export job with the specified job name. </p>', 'ListFHIRImportJobsRequest$JobName' => '<p> This parameter limits the response to the import job with the specified job name. </p>', 'StartFHIRExportJobRequest$JobName' => '<p>The user generated name for an export job.</p>', 'StartFHIRImportJobRequest$JobName' => '<p>The name of the FHIR Import job in the StartFHIRImport job request.</p>', ], ], 'JobProgressReport' => [ 'base' => '<p>The progress report of an import job.</p>', 'refs' => [ 'ImportJobProperties$JobProgressReport' => '<p>Displays the progress of the import job, including total resources scanned, total resources ingested, and total size of data ingested.</p>', ], ], 'JobStatus' => [ 'base' => NULL, 'refs' => [ 'ExportJobProperties$JobStatus' => '<p>The status of a FHIR export job. Possible statuses are SUBMITTED, IN_PROGRESS, COMPLETED, or FAILED.</p>', 'ImportJobProperties$JobStatus' => '<p>The job status for an Import job. Possible statuses are SUBMITTED, IN_PROGRESS, COMPLETED_WITH_ERRORS, COMPLETED, FAILED.</p>', 'ListFHIRExportJobsRequest$JobStatus' => '<p> This parameter limits the response to the export jobs with the specified job status. </p>', 'ListFHIRImportJobsRequest$JobStatus' => '<p> This parameter limits the response to the import job with the specified job status. </p>', 'StartFHIRExportJobResponse$JobStatus' => '<p>The status of a FHIR export job. Possible statuses are SUBMITTED, IN_PROGRESS, COMPLETED, or FAILED.</p>', 'StartFHIRImportJobResponse$JobStatus' => '<p>The status of an import job.</p>', ], ], 'KmsEncryptionConfig' => [ 'base' => '<p> The customer-managed-key(CMK) used when creating a data store. If a customer owned key is not specified, an AWS owned key will be used for encryption. </p>', 'refs' => [ 'SseConfiguration$KmsEncryptionConfig' => '<p> The KMS encryption configuration used to provide details for data encryption. </p>', ], ], 'LambdaArn' => [ 'base' => NULL, 'refs' => [ 'IdentityProviderConfiguration$IdpLambdaArn' => '<p>The Amazon Resource Name (ARN) of the Lambda function that you want to use to decode the access token created by the authorization server.</p>', ], ], 'ListFHIRDatastoresRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFHIRDatastoresResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFHIRExportJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFHIRExportJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFHIRImportJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFHIRImportJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'MaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListFHIRDatastoresRequest$MaxResults' => '<p>The maximum number of data stores returned in a single page of a ListFHIRDatastoresRequest call.</p>', 'ListFHIRExportJobsRequest$MaxResults' => '<p> This parameter limits the number of results returned for a ListFHIRExportJobs to a maximum quantity specified by the user. </p>', 'ListFHIRImportJobsRequest$MaxResults' => '<p> This parameter limits the number of results returned for a ListFHIRImportJobs to a maximum quantity specified by the user. </p>', ], ], 'Message' => [ 'base' => NULL, 'refs' => [ 'ExportJobProperties$Message' => '<p>An explanation of any errors that may have occurred during the export job.</p>', 'ImportJobProperties$Message' => '<p>An explanation of any errors that may have occurred during the FHIR import job. </p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListFHIRDatastoresRequest$NextToken' => '<p>Fetches the next page of data stores when results are paginated.</p>', 'ListFHIRDatastoresResponse$NextToken' => '<p>Pagination token that can be used to retrieve the next page of results.</p>', 'ListFHIRExportJobsRequest$NextToken' => '<p> A pagination token used to identify the next page of results to return for a ListFHIRExportJobs query. </p>', 'ListFHIRExportJobsResponse$NextToken' => '<p> A pagination token used to identify the next page of results to return for a ListFHIRExportJobs query. </p>', 'ListFHIRImportJobsRequest$NextToken' => '<p> A pagination token used to identify the next page of results to return for a ListFHIRImportJobs query. </p>', 'ListFHIRImportJobsResponse$NextToken' => '<p> A pagination token used to identify the next page of results to return for a ListFHIRImportJobs query. </p>', ], ], 'OutputDataConfig' => [ 'base' => '<p>The output data configuration that was supplied when the export job was created.</p>', 'refs' => [ 'ExportJobProperties$OutputDataConfig' => '<p>The output data configuration that was supplied when the export job was created.</p>', 'ImportJobProperties$JobOutputDataConfig' => NULL, 'StartFHIRExportJobRequest$OutputDataConfig' => '<p>The output data configuration that was supplied when the export job was created.</p>', 'StartFHIRImportJobRequest$JobOutputDataConfig' => NULL, ], ], 'PreloadDataConfig' => [ 'base' => '<p> The input properties for the preloaded data store. Only data preloaded from Synthea is supported.</p>', 'refs' => [ 'CreateFHIRDatastoreRequest$PreloadDataConfig' => '<p>Optional parameter to preload data upon creation of the data store. Currently, the only supported preloaded data is synthetic data generated from Synthea.</p>', 'DatastoreProperties$PreloadDataConfig' => '<p>The preloaded data configuration for the data store. Only data preloaded from Synthea is supported.</p>', ], ], 'PreloadDataType' => [ 'base' => NULL, 'refs' => [ 'PreloadDataConfig$PreloadDataType' => '<p>The type of preloaded data. Only Synthea preloaded data is supported.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p> The requested data store was not found.</p>', 'refs' => [], ], 'S3Configuration' => [ 'base' => '<p> The configuration of the S3 bucket for either an import or export job. This includes assigning permissions for access. </p>', 'refs' => [ 'OutputDataConfig$S3Configuration' => '<p> The output data configuration that was supplied when the export job was created. </p>', ], ], 'S3Uri' => [ 'base' => NULL, 'refs' => [ 'InputDataConfig$S3Uri' => '<p>The S3Uri is the user specified S3 location of the FHIR data to be imported into AWS HealthLake. </p>', 'S3Configuration$S3Uri' => '<p> The S3Uri is the user specified S3 location of the FHIR data to be imported into AWS HealthLake. </p>', ], ], 'SseConfiguration' => [ 'base' => '<p> The server-side encryption key configuration for a customer provided encryption key. </p>', 'refs' => [ 'CreateFHIRDatastoreRequest$SseConfiguration' => '<p> The server-side encryption key configuration for a customer provided encryption key specified for creating a data store. </p>', 'DatastoreProperties$SseConfiguration' => '<p> The server-side encryption key configuration for a customer provided encryption key (CMK). </p>', ], ], 'StartFHIRExportJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartFHIRExportJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartFHIRImportJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartFHIRImportJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => NULL, 'ConflictException$Message' => NULL, 'DatastoreProperties$DatastoreEndpoint' => '<p>The AWS endpoint for the data store. Each data store will have it\'s own endpoint with data store ID in the endpoint URL.</p>', 'InternalServerException$Message' => NULL, 'ResourceNotFoundException$Message' => NULL, 'ThrottlingException$Message' => NULL, 'ValidationException$Message' => NULL, ], ], 'Tag' => [ 'base' => '<p> A tag is a label consisting of a user-defined key and value. The form for tags is {"Key", "Value"} </p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p> The key portion of a tag. Tag keys are case sensitive. </p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p> The keys for the tags to be removed from the HealthLake data store. </p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateFHIRDatastoreRequest$Tags' => '<p> Resource tags that are applied to a data store when it is created. </p>', 'ListTagsForResourceResponse$Tags' => '<p> Returns a list of tags associated with a data store. </p>', 'TagResourceRequest$Tags' => '<p> The user specified key and value pair tags being added to a data store. </p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p> The value portion of a tag. Tag values are case sensitive. </p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The user has exceeded their maximum number of allowed calls to the given API. </p>', 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'DatastoreFilter$CreatedBefore' => '<p>A filter that allows the user to set cutoff dates for records. All data stores created before the specified date will be included in the results. </p>', 'DatastoreFilter$CreatedAfter' => '<p>A filter that allows the user to set cutoff dates for records. All data stores created after the specified date will be included in the results.</p>', 'DatastoreProperties$CreatedAt' => '<p>The time that a data store was created. </p>', 'ExportJobProperties$SubmitTime' => '<p>The time an export job was initiated.</p>', 'ExportJobProperties$EndTime' => '<p>The time an export job completed.</p>', 'ImportJobProperties$SubmitTime' => '<p>The time that the Import job was submitted for processing.</p>', 'ImportJobProperties$EndTime' => '<p>The time that the Import job was completed.</p>', 'ListFHIRExportJobsRequest$SubmittedBefore' => '<p> This parameter limits the response to FHIR export jobs submitted before a user specified date. </p>', 'ListFHIRExportJobsRequest$SubmittedAfter' => '<p> This parameter limits the response to FHIR export jobs submitted after a user specified date. </p>', 'ListFHIRImportJobsRequest$SubmittedBefore' => '<p> This parameter limits the response to FHIR import jobs submitted before a user specified date. </p>', 'ListFHIRImportJobsRequest$SubmittedAfter' => '<p> This parameter limits the response to FHIR import jobs submitted after a user specified date. </p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>The user input parameter was invalid.</p>', 'refs' => [], ], ],];
