<?php
// This file was auto-generated from sdk-root/src/data/imagebuilder/2019-12-02/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>EC2 Image Builder is a fully managed Amazon Web Services service that makes it easier to automate the creation, management, and deployment of customized, secure, and up-to-date "golden" server images that are pre-installed and pre-configured with software and settings to meet specific IT standards.</p>', 'operations' => [ 'CancelImageCreation' => '<p>CancelImageCreation cancels the creation of Image. This operation can only be used on images in a non-terminal state.</p>', 'CancelLifecycleExecution' => '<p>Cancel a specific image lifecycle policy runtime instance.</p>', 'CreateComponent' => '<p>Creates a new component that can be used to build, validate, test, and assess your image. The component is based on a YAML document that you specify using exactly one of the following methods:</p> <ul> <li> <p>Inline, using the <code>data</code> property in the request body.</p> </li> <li> <p>A URL that points to a YAML document file stored in Amazon S3, using the <code>uri</code> property in the request body.</p> </li> </ul>', 'CreateContainerRecipe' => '<p>Creates a new container recipe. Container recipes define how images are configured, tested, and assessed.</p>', 'CreateDistributionConfiguration' => '<p>Creates a new distribution configuration. Distribution configurations define and configure the outputs of your pipeline.</p>', 'CreateImage' => '<p>Creates a new image. This request will create a new image along with all of the configured output resources defined in the distribution configuration. You must specify exactly one recipe for your image, using either a ContainerRecipeArn or an ImageRecipeArn.</p>', 'CreateImagePipeline' => '<p>Creates a new image pipeline. Image pipelines enable you to automate the creation and distribution of images.</p>', 'CreateImageRecipe' => '<p>Creates a new image recipe. Image recipes define how images are configured, tested, and assessed.</p>', 'CreateInfrastructureConfiguration' => '<p>Creates a new infrastructure configuration. An infrastructure configuration defines the environment in which your image will be built and tested.</p>', 'CreateLifecyclePolicy' => '<p>Create a lifecycle policy resource.</p>', 'CreateWorkflow' => '<p>Create a new workflow or a new version of an existing workflow.</p>', 'DeleteComponent' => '<p>Deletes a component build version.</p>', 'DeleteContainerRecipe' => '<p>Deletes a container recipe.</p>', 'DeleteDistributionConfiguration' => '<p>Deletes a distribution configuration.</p>', 'DeleteImage' => '<p>Deletes an Image Builder image resource. This does not delete any EC2 AMIs or ECR container images that are created during the image build process. You must clean those up separately, using the appropriate Amazon EC2 or Amazon ECR console actions, or API or CLI commands.</p> <ul> <li> <p>To deregister an EC2 Linux AMI, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/deregister-ami.html">Deregister your Linux AMI</a> in the <i> <i>Amazon EC2 User Guide</i> </i>.</p> </li> <li> <p>To deregister an EC2 Windows AMI, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/deregister-ami.html">Deregister your Windows AMI</a> in the <i> <i>Amazon EC2 Windows Guide</i> </i>.</p> </li> <li> <p>To delete a container image from Amazon ECR, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/delete_image.html">Deleting an image</a> in the <i>Amazon ECR User Guide</i>.</p> </li> </ul>', 'DeleteImagePipeline' => '<p>Deletes an image pipeline.</p>', 'DeleteImageRecipe' => '<p>Deletes an image recipe.</p>', 'DeleteInfrastructureConfiguration' => '<p>Deletes an infrastructure configuration.</p>', 'DeleteLifecyclePolicy' => '<p>Delete the specified lifecycle policy resource.</p>', 'DeleteWorkflow' => '<p>Deletes a specific workflow resource.</p>', 'GetComponent' => '<p>Gets a component object.</p>', 'GetComponentPolicy' => '<p>Gets a component policy.</p>', 'GetContainerRecipe' => '<p>Retrieves a container recipe.</p>', 'GetContainerRecipePolicy' => '<p>Retrieves the policy for a container recipe.</p>', 'GetDistributionConfiguration' => '<p>Gets a distribution configuration.</p>', 'GetImage' => '<p>Gets an image.</p>', 'GetImagePipeline' => '<p>Gets an image pipeline.</p>', 'GetImagePolicy' => '<p>Gets an image policy.</p>', 'GetImageRecipe' => '<p>Gets an image recipe.</p>', 'GetImageRecipePolicy' => '<p>Gets an image recipe policy.</p>', 'GetInfrastructureConfiguration' => '<p>Gets an infrastructure configuration.</p>', 'GetLifecycleExecution' => '<p>Get the runtime information that was logged for a specific runtime instance of the lifecycle policy.</p>', 'GetLifecyclePolicy' => '<p>Get details for the specified image lifecycle policy.</p>', 'GetWorkflow' => '<p>Get a workflow resource object.</p>', 'GetWorkflowExecution' => '<p>Get the runtime information that was logged for a specific runtime instance of the workflow.</p>', 'GetWorkflowStepExecution' => '<p>Get the runtime information that was logged for a specific runtime instance of the workflow step.</p>', 'ImportComponent' => '<p>Imports a component and transforms its data into a component document.</p>', 'ImportVmImage' => '<p>When you export your virtual machine (VM) from its virtualization environment, that process creates a set of one or more disk container files that act as snapshots of your VM’s environment, settings, and data. The Amazon EC2 API <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportImage.html">ImportImage</a> action uses those files to import your VM and create an AMI. To import using the CLI command, see <a href="https://docs.aws.amazon.com/cli/latest/reference/ec2/import-image.html">import-image</a> </p> <p>You can reference the task ID from the VM import to pull in the AMI that the import created as the base image for your Image Builder recipe.</p>', 'ListComponentBuildVersions' => '<p>Returns the list of component build versions for the specified semantic version.</p> <note> <p>The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can assign values for the first three, and can filter on all of them.</p> <p> <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x) to specify the most recent versions or nodes when selecting the base image or components for your recipe. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be wildcards.</p> </note>', 'ListComponents' => '<p>Returns the list of components that can be filtered by name, or by using the listed <code>filters</code> to streamline results. Newly created components can take up to two minutes to appear in the ListComponents API Results.</p> <note> <p>The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can assign values for the first three, and can filter on all of them.</p> <p> <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x) to specify the most recent versions or nodes when selecting the base image or components for your recipe. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be wildcards.</p> </note>', 'ListContainerRecipes' => '<p>Returns a list of container recipes.</p>', 'ListDistributionConfigurations' => '<p>Returns a list of distribution configurations.</p>', 'ListImageBuildVersions' => '<p>Returns a list of image build versions.</p>', 'ListImagePackages' => '<p>List the Packages that are associated with an Image Build Version, as determined by Amazon Web Services Systems Manager Inventory at build time.</p>', 'ListImagePipelineImages' => '<p>Returns a list of images created by the specified pipeline.</p>', 'ListImagePipelines' => '<p>Returns a list of image pipelines.</p>', 'ListImageRecipes' => '<p>Returns a list of image recipes.</p>', 'ListImageScanFindingAggregations' => '<p>Returns a list of image scan aggregations for your account. You can filter by the type of key that Image Builder uses to group results. For example, if you want to get a list of findings by severity level for one of your pipelines, you might specify your pipeline with the <code>imagePipelineArn</code> filter. If you don\'t specify a filter, Image Builder returns an aggregation for your account.</p> <p>To streamline results, you can use the following filters in your request:</p> <ul> <li> <p> <code>accountId</code> </p> </li> <li> <p> <code>imageBuildVersionArn</code> </p> </li> <li> <p> <code>imagePipelineArn</code> </p> </li> <li> <p> <code>vulnerabilityId</code> </p> </li> </ul>', 'ListImageScanFindings' => '<p>Returns a list of image scan findings for your account.</p>', 'ListImages' => '<p>Returns the list of images that you have access to. Newly created images can take up to two minutes to appear in the ListImages API Results.</p>', 'ListInfrastructureConfigurations' => '<p>Returns a list of infrastructure configurations.</p>', 'ListLifecycleExecutionResources' => '<p>List resources that the runtime instance of the image lifecycle identified for lifecycle actions.</p>', 'ListLifecycleExecutions' => '<p>Get the lifecycle runtime history for the specified resource.</p>', 'ListLifecyclePolicies' => '<p>Get a list of lifecycle policies in your Amazon Web Services account.</p>', 'ListTagsForResource' => '<p>Returns the list of tags for the specified resource.</p>', 'ListWaitingWorkflowSteps' => '<p>Get a list of workflow steps that are waiting for action for workflows in your Amazon Web Services account.</p>', 'ListWorkflowBuildVersions' => '<p>Returns a list of build versions for a specific workflow resource.</p>', 'ListWorkflowExecutions' => '<p>Returns a list of workflow runtime instance metadata objects for a specific image build version.</p>', 'ListWorkflowStepExecutions' => '<p>Returns runtime data for each step in a runtime instance of the workflow that you specify in the request.</p>', 'ListWorkflows' => '<p>Lists workflow build versions based on filtering parameters.</p>', 'PutComponentPolicy' => '<p>Applies a policy to a component. We recommend that you call the RAM API <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html">CreateResourceShare</a> to share resources. If you call the Image Builder API <code>PutComponentPolicy</code>, you must also call the RAM API <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html">PromoteResourceShareCreatedFromPolicy</a> in order for the resource to be visible to all principals with whom the resource is shared.</p>', 'PutContainerRecipePolicy' => '<p>Applies a policy to a container image. We recommend that you call the RAM API CreateResourceShare (https://docs.aws.amazon.com//ram/latest/APIReference/API_CreateResourceShare.html) to share resources. If you call the Image Builder API <code>PutContainerImagePolicy</code>, you must also call the RAM API PromoteResourceShareCreatedFromPolicy (https://docs.aws.amazon.com//ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html) in order for the resource to be visible to all principals with whom the resource is shared.</p>', 'PutImagePolicy' => '<p>Applies a policy to an image. We recommend that you call the RAM API <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html">CreateResourceShare</a> to share resources. If you call the Image Builder API <code>PutImagePolicy</code>, you must also call the RAM API <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html">PromoteResourceShareCreatedFromPolicy</a> in order for the resource to be visible to all principals with whom the resource is shared.</p>', 'PutImageRecipePolicy' => '<p>Applies a policy to an image recipe. We recommend that you call the RAM API <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html">CreateResourceShare</a> to share resources. If you call the Image Builder API <code>PutImageRecipePolicy</code>, you must also call the RAM API <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html">PromoteResourceShareCreatedFromPolicy</a> in order for the resource to be visible to all principals with whom the resource is shared.</p>', 'SendWorkflowStepAction' => '<p>Pauses or resumes image creation when the associated workflow runs a <code>WaitForAction</code> step.</p>', 'StartImagePipelineExecution' => '<p>Manually triggers a pipeline to create an image.</p>', 'StartResourceStateUpdate' => '<p>Begin asynchronous resource state update for lifecycle changes to the specified image resources.</p>', 'TagResource' => '<p>Adds a tag to a resource.</p>', 'UntagResource' => '<p>Removes a tag from a resource.</p>', 'UpdateDistributionConfiguration' => '<p>Updates a new distribution configuration. Distribution configurations define and configure the outputs of your pipeline.</p>', 'UpdateImagePipeline' => '<p>Updates an image pipeline. Image pipelines enable you to automate the creation and distribution of images. You must specify exactly one recipe for your image, using either a <code>containerRecipeArn</code> or an <code>imageRecipeArn</code>.</p> <note> <p>UpdateImagePipeline does not support selective updates for the pipeline. You must specify all of the required properties in the update request, not just the properties that have changed.</p> </note>', 'UpdateInfrastructureConfiguration' => '<p>Updates a new infrastructure configuration. An infrastructure configuration defines the environment in which your image will be built and tested.</p>', 'UpdateLifecyclePolicy' => '<p>Update the specified lifecycle policy.</p>', ], 'shapes' => [ 'AccountAggregation' => [ 'base' => '<p>Contains counts of vulnerability findings from image scans that run when you create new Image Builder images, or build new versions of existing images. The vulnerability counts are grouped by severity level. The counts are aggregated across resources to create the final tally for the account that owns them.</p>', 'refs' => [ 'ImageScanFindingAggregation$accountAggregation' => '<p>Returns an object that contains severity counts based on an account ID.</p>', ], ], 'AccountId' => [ 'base' => NULL, 'refs' => [ 'AccountList$member' => NULL, 'FastLaunchConfiguration$accountId' => '<p>The owner account ID for the fast-launch enabled Windows AMI.</p>', 'LaunchTemplateConfiguration$accountId' => '<p>The account ID that this configuration applies to.</p>', ], ], 'AccountList' => [ 'base' => NULL, 'refs' => [ 'AmiDistributionConfiguration$targetAccountIds' => '<p>The ID of an account to which you want to distribute an image.</p>', 'LaunchPermissionConfiguration$userIds' => '<p>The Amazon Web Services account ID.</p>', 'LifecyclePolicyDetailExclusionRulesAmis$sharedAccounts' => '<p>Specifies Amazon Web Services accounts whose resources are excluded from the lifecycle action.</p>', ], ], 'AdditionalInstanceConfiguration' => [ 'base' => '<p>In addition to your infrastructure configuration, these settings provide an extra layer of control over your build instances. You can also specify commands to run on launch for all of your build instances.</p> <p>Image Builder does not automatically install the Systems Manager agent on Windows instances. If your base image includes the Systems Manager agent, then the AMI that you create will also include the agent. For Linux instances, if the base image does not already include the Systems Manager agent, Image Builder installs it. For Linux instances where Image Builder installs the Systems Manager agent, you can choose whether to keep it for the AMI that you create.</p>', 'refs' => [ 'CreateImageRecipeRequest$additionalInstanceConfiguration' => '<p>Specify additional settings and launch scripts for your build instances.</p>', 'ImageRecipe$additionalInstanceConfiguration' => '<p>Before you create a new AMI, Image Builder launches temporary Amazon EC2 instances to build and test your image configuration. Instance configuration adds a layer of control over those instances. You can define settings and add scripts to run when an instance is launched from your AMI.</p>', ], ], 'Ami' => [ 'base' => '<p>Details of an Amazon EC2 AMI.</p>', 'refs' => [ 'AmiList$member' => NULL, ], ], 'AmiDistributionConfiguration' => [ 'base' => '<p>Define and configure the output AMIs of the pipeline.</p>', 'refs' => [ 'Distribution$amiDistributionConfiguration' => '<p>The specific AMI settings; for example, launch permissions or AMI tags.</p>', ], ], 'AmiList' => [ 'base' => NULL, 'refs' => [ 'OutputResources$amis' => '<p>The Amazon EC2 AMIs created by this image.</p>', ], ], 'AmiNameString' => [ 'base' => NULL, 'refs' => [ 'AmiDistributionConfiguration$name' => '<p>The name of the output AMI.</p>', ], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'Image$sourcePipelineArn' => '<p>The Amazon Resource Name (ARN) of the image pipeline that created this image.</p>', 'ImagePipeline$imageRecipeArn' => '<p>The Amazon Resource Name (ARN) of the image recipe associated with this image pipeline.</p>', 'ImagePipeline$containerRecipeArn' => '<p>The Amazon Resource Name (ARN) of the container recipe that is used for this pipeline.</p>', 'ImagePipeline$infrastructureConfigurationArn' => '<p>The Amazon Resource Name (ARN) of the infrastructure configuration associated with this image pipeline.</p>', 'ImagePipeline$distributionConfigurationArn' => '<p>The Amazon Resource Name (ARN) of the distribution configuration associated with this image pipeline.</p>', 'ImportVmImageResponse$imageArn' => '<p>The Amazon Resource Name (ARN) of the AMI that was created during the VM import process. This AMI is used as the base image for the recipe that imported the VM.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'Component$obfuscate' => '<p>Indicates whether component source is hidden from view in the console, and from component detail results for API, CLI, or SDK operations.</p>', 'ComponentSummary$obfuscate' => '<p>Indicates whether component source is hidden from view in the console, and from component detail results for API, CLI, or SDK operations.</p>', 'FastLaunchConfiguration$enabled' => '<p>A Boolean that represents the current state of faster launching for the Windows AMI. Set to <code>true</code> to start using Windows faster launching, or <code>false</code> to stop using it.</p>', 'LaunchTemplateConfiguration$setDefaultVersion' => '<p>Set the specified Amazon EC2 launch template as the default launch template for the specified account.</p>', 'LifecycleExecutionResourcesImpactedSummary$hasImpactedResources' => '<p>Indicates whether an image resource that was identified for a lifecycle action has associated resources that are also impacted.</p>', 'LifecyclePolicyDetailActionIncludeResources$amis' => '<p>Specifies whether the lifecycle action should apply to distributed AMIs.</p>', 'LifecyclePolicyDetailActionIncludeResources$snapshots' => '<p>Specifies whether the lifecycle action should apply to snapshots associated with distributed AMIs.</p>', 'LifecyclePolicyDetailActionIncludeResources$containers' => '<p>Specifies whether the lifecycle action should apply to distributed containers.</p>', 'LifecyclePolicyDetailExclusionRulesAmis$isPublic' => '<p>Configures whether public AMIs are excluded from the lifecycle action.</p>', 'ListComponentsRequest$byName' => '<p>Returns the list of components for the specified name.</p>', 'ListImagesRequest$byName' => '<p>Requests a list of images with a specific recipe name.</p>', 'ListWorkflowsRequest$byName' => '<p>Specify all or part of the workflow name to streamline results.</p>', 'ResourceStateUpdateIncludeResources$amis' => '<p>Specifies whether the lifecycle action should apply to distributed AMIs</p>', 'ResourceStateUpdateIncludeResources$snapshots' => '<p>Specifies whether the lifecycle action should apply to snapshots associated with distributed AMIs.</p>', 'ResourceStateUpdateIncludeResources$containers' => '<p>Specifies whether the lifecycle action should apply to distributed containers.</p>', ], ], 'BuildType' => [ 'base' => NULL, 'refs' => [ 'Image$buildType' => '<p>Indicates the type of build that created this image. The build can be initiated in the following ways:</p> <ul> <li> <p> <b>USER_INITIATED</b> – A manual pipeline build request.</p> </li> <li> <p> <b>SCHEDULED</b> – A pipeline build initiated by a cron expression in the Image Builder pipeline, or from EventBridge.</p> </li> <li> <p> <b>IMPORT</b> – A VM import created the image to use as the base image for the recipe.</p> </li> </ul>', 'ImageSummary$buildType' => '<p>Indicates the type of build that created this image. The build can be initiated in the following ways:</p> <ul> <li> <p> <b>USER_INITIATED</b> – A manual pipeline build request.</p> </li> <li> <p> <b>SCHEDULED</b> – A pipeline build initiated by a cron expression in the Image Builder pipeline, or from EventBridge.</p> </li> <li> <p> <b>IMPORT</b> – A VM import created the image to use as the base image for the recipe.</p> </li> </ul>', 'ImageVersion$buildType' => '<p>Indicates the type of build that created this image. The build can be initiated in the following ways:</p> <ul> <li> <p> <b>USER_INITIATED</b> – A manual pipeline build request.</p> </li> <li> <p> <b>SCHEDULED</b> – A pipeline build initiated by a cron expression in the Image Builder pipeline, or from EventBridge.</p> </li> <li> <p> <b>IMPORT</b> – A VM import created the image to use as the base image for the recipe.</p> </li> </ul>', ], ], 'CallRateLimitExceededException' => [ 'base' => '<p>You have exceeded the permitted request rate for the specific operation.</p>', 'refs' => [], ], 'CancelImageCreationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CancelImageCreationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CancelLifecycleExecutionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CancelLifecycleExecutionResponse' => [ 'base' => NULL, 'refs' => [], ], 'ClientException' => [ 'base' => '<p>These errors are usually caused by a client action, such as using an action or resource on behalf of a user that doesn\'t have permissions to use the action or resource, or specifying an invalid resource identifier.</p>', 'refs' => [], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'CancelImageCreationRequest$clientToken' => '<p>Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a> in the <i>Amazon EC2 API Reference</i>.</p>', 'CancelImageCreationResponse$clientToken' => '<p>The client token that uniquely identifies the request.</p>', 'CancelLifecycleExecutionRequest$clientToken' => '<p>Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a> in the <i>Amazon EC2 API Reference</i>.</p>', 'CreateComponentRequest$clientToken' => '<p>Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a> in the <i>Amazon EC2 API Reference</i>.</p>', 'CreateComponentResponse$clientToken' => '<p>The client token that uniquely identifies the request.</p>', 'CreateContainerRecipeRequest$clientToken' => '<p>Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a> in the <i>Amazon EC2 API Reference</i>.</p>', 'CreateContainerRecipeResponse$clientToken' => '<p>The client token that uniquely identifies the request.</p>', 'CreateDistributionConfigurationRequest$clientToken' => '<p>Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a> in the <i>Amazon EC2 API Reference</i>.</p>', 'CreateDistributionConfigurationResponse$clientToken' => '<p>The client token that uniquely identifies the request.</p>', 'CreateImagePipelineRequest$clientToken' => '<p>Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a> in the <i>Amazon EC2 API Reference</i>.</p>', 'CreateImagePipelineResponse$clientToken' => '<p>The client token that uniquely identifies the request.</p>', 'CreateImageRecipeRequest$clientToken' => '<p>Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a> in the <i>Amazon EC2 API Reference</i>.</p>', 'CreateImageRecipeResponse$clientToken' => '<p>The client token that uniquely identifies the request.</p>', 'CreateImageRequest$clientToken' => '<p>Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a> in the <i>Amazon EC2 API Reference</i>.</p>', 'CreateImageResponse$clientToken' => '<p>The client token that uniquely identifies the request.</p>', 'CreateInfrastructureConfigurationRequest$clientToken' => '<p>Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a> in the <i>Amazon EC2 API Reference</i>.</p>', 'CreateInfrastructureConfigurationResponse$clientToken' => '<p>The client token that uniquely identifies the request.</p>', 'CreateLifecyclePolicyRequest$clientToken' => '<p>Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a> in the <i>Amazon EC2 API Reference</i>.</p>', 'CreateLifecyclePolicyResponse$clientToken' => '<p>The client token that uniquely identifies the request.</p>', 'CreateWorkflowRequest$clientToken' => '<p>Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a> in the <i>Amazon EC2 API Reference</i>.</p>', 'CreateWorkflowResponse$clientToken' => '<p>The client token that uniquely identifies the request.</p>', 'ImportComponentRequest$clientToken' => '<p>Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a> in the <i>Amazon EC2 API Reference</i>.</p>', 'ImportComponentResponse$clientToken' => '<p>The client token that uniquely identifies the request.</p>', 'ImportVmImageRequest$clientToken' => '<p>Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a> in the <i>Amazon EC2 API Reference</i>.</p>', 'ImportVmImageResponse$clientToken' => '<p>The client token that uniquely identifies the request.</p>', 'SendWorkflowStepActionRequest$clientToken' => '<p>Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a> in the <i>Amazon EC2 API Reference</i>.</p>', 'SendWorkflowStepActionResponse$clientToken' => '<p>The client token that uniquely identifies the request.</p>', 'StartImagePipelineExecutionRequest$clientToken' => '<p>Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a> in the <i>Amazon EC2 API Reference</i>.</p>', 'StartImagePipelineExecutionResponse$clientToken' => '<p>The client token that uniquely identifies the request.</p>', 'StartResourceStateUpdateRequest$clientToken' => '<p>Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a> in the <i>Amazon EC2 API Reference</i>.</p>', 'UpdateDistributionConfigurationRequest$clientToken' => '<p>Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a> in the <i>Amazon EC2 API Reference</i>.</p>', 'UpdateDistributionConfigurationResponse$clientToken' => '<p>The client token that uniquely identifies the request.</p>', 'UpdateImagePipelineRequest$clientToken' => '<p>Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a> in the <i>Amazon EC2 API Reference</i>.</p>', 'UpdateImagePipelineResponse$clientToken' => '<p>The client token that uniquely identifies the request.</p>', 'UpdateInfrastructureConfigurationRequest$clientToken' => '<p>Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a> in the <i>Amazon EC2 API Reference</i>.</p>', 'UpdateInfrastructureConfigurationResponse$clientToken' => '<p>The client token that uniquely identifies the request.</p>', 'UpdateLifecyclePolicyRequest$clientToken' => '<p>Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a> in the <i>Amazon EC2 API Reference</i>.</p>', ], ], 'Component' => [ 'base' => '<p>A detailed view of a component.</p>', 'refs' => [ 'GetComponentResponse$component' => '<p>The component object specified in the request.</p>', ], ], 'ComponentBuildVersionArn' => [ 'base' => NULL, 'refs' => [ 'CreateComponentResponse$componentBuildVersionArn' => '<p>The Amazon Resource Name (ARN) of the component that the request created.</p>', 'DeleteComponentRequest$componentBuildVersionArn' => '<p>The Amazon Resource Name (ARN) of the component build version to delete.</p>', 'DeleteComponentResponse$componentBuildVersionArn' => '<p>The ARN of the component build version that this request deleted.</p>', 'GetComponentPolicyRequest$componentArn' => '<p>The Amazon Resource Name (ARN) of the component whose policy you want to retrieve.</p>', 'ImportComponentResponse$componentBuildVersionArn' => '<p>The Amazon Resource Name (ARN) of the imported component.</p>', 'PutComponentPolicyRequest$componentArn' => '<p>The Amazon Resource Name (ARN) of the component that this policy should be applied to.</p>', 'PutComponentPolicyResponse$componentArn' => '<p>The Amazon Resource Name (ARN) of the component that this policy was applied to.</p>', ], ], 'ComponentConfiguration' => [ 'base' => '<p>Configuration details of the component.</p>', 'refs' => [ 'ComponentConfigurationList$member' => NULL, ], ], 'ComponentConfigurationList' => [ 'base' => NULL, 'refs' => [ 'ContainerRecipe$components' => '<p>Build and test components that are included in the container recipe. Recipes require a minimum of one build component, and can have a maximum of 20 build and test components in any combination.</p>', 'CreateContainerRecipeRequest$components' => '<p>Components for build and test that are included in the container recipe. Recipes require a minimum of one build component, and can have a maximum of 20 build and test components in any combination.</p>', 'CreateImageRecipeRequest$components' => '<p>The components included in the image recipe.</p>', 'ImageRecipe$components' => '<p>The components that are included in the image recipe. Recipes require a minimum of one build component, and can have a maximum of 20 build and test components in any combination.</p>', ], ], 'ComponentData' => [ 'base' => NULL, 'refs' => [ 'Component$data' => '<p>Component data contains the YAML document content for the component.</p>', ], ], 'ComponentFormat' => [ 'base' => NULL, 'refs' => [ 'ImportComponentRequest$format' => '<p>The format of the resource that you want to import as a component.</p>', ], ], 'ComponentParameter' => [ 'base' => '<p>Contains a key/value pair that sets the named component parameter.</p>', 'refs' => [ 'ComponentParameterList$member' => NULL, ], ], 'ComponentParameterDescription' => [ 'base' => NULL, 'refs' => [ 'ComponentParameterDetail$description' => '<p>Describes this parameter.</p>', ], ], 'ComponentParameterDetail' => [ 'base' => '<p>Defines a parameter that is used to provide configuration details for the component.</p>', 'refs' => [ 'ComponentParameterDetailList$member' => NULL, ], ], 'ComponentParameterDetailList' => [ 'base' => NULL, 'refs' => [ 'Component$parameters' => '<p>Contains parameter details for each of the parameters that the component document defined for the component.</p>', ], ], 'ComponentParameterList' => [ 'base' => NULL, 'refs' => [ 'ComponentConfiguration$parameters' => '<p>A group of parameter settings that Image Builder uses to configure the component for a specific recipe.</p>', ], ], 'ComponentParameterName' => [ 'base' => NULL, 'refs' => [ 'ComponentParameter$name' => '<p>The name of the component parameter to set.</p>', 'ComponentParameterDetail$name' => '<p>The name of this input parameter.</p>', ], ], 'ComponentParameterType' => [ 'base' => NULL, 'refs' => [ 'ComponentParameterDetail$type' => '<p>The type of input this parameter provides. The currently supported value is "string".</p>', ], ], 'ComponentParameterValue' => [ 'base' => NULL, 'refs' => [ 'ComponentParameterValueList$member' => NULL, ], ], 'ComponentParameterValueList' => [ 'base' => NULL, 'refs' => [ 'ComponentParameter$value' => '<p>Sets the value for the named component parameter.</p>', 'ComponentParameterDetail$defaultValue' => '<p>The default value of this parameter if no input is provided.</p>', ], ], 'ComponentState' => [ 'base' => '<p>A group of fields that describe the current status of components.</p>', 'refs' => [ 'Component$state' => '<p>Describes the current status of the component. This is used for components that are no longer active.</p>', 'ComponentSummary$state' => '<p>Describes the current status of the component.</p>', ], ], 'ComponentStatus' => [ 'base' => NULL, 'refs' => [ 'ComponentState$status' => '<p>The current state of the component.</p>', ], ], 'ComponentSummary' => [ 'base' => '<p>A high-level summary of a component.</p>', 'refs' => [ 'ComponentSummaryList$member' => NULL, ], ], 'ComponentSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListComponentBuildVersionsResponse$componentSummaryList' => '<p>The list of component summaries for the specified semantic version.</p>', ], ], 'ComponentType' => [ 'base' => NULL, 'refs' => [ 'Component$type' => '<p>The component type specifies whether Image Builder uses the component to build the image or only to test it.</p>', 'ComponentSummary$type' => '<p>The component type specifies whether Image Builder uses the component to build the image or only to test it.</p>', 'ComponentVersion$type' => '<p>The type of the component denotes whether the component is used to build the image or only to test it.</p>', 'ImportComponentRequest$type' => '<p>The type of the component denotes whether the component is used to build the image, or only to test it.</p>', ], ], 'ComponentVersion' => [ 'base' => '<p>The defining characteristics of a specific version of an Amazon Web Services TOE component.</p>', 'refs' => [ 'ComponentVersionList$member' => NULL, ], ], 'ComponentVersionArn' => [ 'base' => NULL, 'refs' => [ 'ListComponentBuildVersionsRequest$componentVersionArn' => '<p>The component version Amazon Resource Name (ARN) whose versions you want to list.</p>', ], ], 'ComponentVersionArnOrBuildVersionArn' => [ 'base' => NULL, 'refs' => [ 'ComponentConfiguration$componentArn' => '<p>The Amazon Resource Name (ARN) of the component.</p>', 'GetComponentRequest$componentBuildVersionArn' => '<p>The Amazon Resource Name (ARN) of the component that you want to get. Regex requires the suffix <code>/\\d+$</code>.</p>', ], ], 'ComponentVersionList' => [ 'base' => NULL, 'refs' => [ 'ListComponentsResponse$componentVersionList' => '<p>The list of component semantic versions.</p> <note> <p>The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can assign values for the first three, and can filter on all of them.</p> </note>', ], ], 'Container' => [ 'base' => '<p>A container encapsulates the runtime environment for an application.</p>', 'refs' => [ 'ContainerList$member' => NULL, ], ], 'ContainerDistributionConfiguration' => [ 'base' => '<p>Container distribution settings for encryption, licensing, and sharing in a specific Region.</p>', 'refs' => [ 'Distribution$containerDistributionConfiguration' => '<p>Container distribution settings for encryption, licensing, and sharing in a specific Region.</p>', ], ], 'ContainerList' => [ 'base' => NULL, 'refs' => [ 'OutputResources$containers' => '<p>Container images that the pipeline has generated and stored in the output repository.</p>', ], ], 'ContainerRecipe' => [ 'base' => '<p>A container recipe.</p>', 'refs' => [ 'GetContainerRecipeResponse$containerRecipe' => '<p>The container recipe object that is returned.</p>', 'Image$containerRecipe' => '<p>For container images, this is the container recipe that Image Builder used to create the image. For images that distribute an AMI, this is empty.</p>', ], ], 'ContainerRecipeArn' => [ 'base' => NULL, 'refs' => [ 'CreateContainerRecipeResponse$containerRecipeArn' => '<p>Returns the Amazon Resource Name (ARN) of the container recipe that the request created.</p>', 'CreateImagePipelineRequest$containerRecipeArn' => '<p>The Amazon Resource Name (ARN) of the container recipe that is used to configure images created by this container pipeline.</p>', 'CreateImageRequest$containerRecipeArn' => '<p>The Amazon Resource Name (ARN) of the container recipe that defines how images are configured and tested.</p>', 'DeleteContainerRecipeRequest$containerRecipeArn' => '<p>The Amazon Resource Name (ARN) of the container recipe to delete.</p>', 'DeleteContainerRecipeResponse$containerRecipeArn' => '<p>The Amazon Resource Name (ARN) of the container recipe that was deleted.</p>', 'GetContainerRecipePolicyRequest$containerRecipeArn' => '<p>The Amazon Resource Name (ARN) of the container recipe for the policy being requested.</p>', 'GetContainerRecipeRequest$containerRecipeArn' => '<p>The Amazon Resource Name (ARN) of the container recipe to retrieve.</p>', 'PutContainerRecipePolicyRequest$containerRecipeArn' => '<p>The Amazon Resource Name (ARN) of the container recipe that this policy should be applied to.</p>', 'PutContainerRecipePolicyResponse$containerRecipeArn' => '<p>The Amazon Resource Name (ARN) of the container recipe that this policy was applied to.</p>', 'UpdateImagePipelineRequest$containerRecipeArn' => '<p>The Amazon Resource Name (ARN) of the container pipeline to update.</p>', ], ], 'ContainerRecipeSummary' => [ 'base' => '<p>A summary of a container recipe</p>', 'refs' => [ 'ContainerRecipeSummaryList$member' => NULL, ], ], 'ContainerRecipeSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListContainerRecipesResponse$containerRecipeSummaryList' => '<p>The list of container recipes returned for the request.</p>', ], ], 'ContainerRepositoryService' => [ 'base' => NULL, 'refs' => [ 'TargetContainerRepository$service' => '<p>Specifies the service in which this image was registered.</p>', ], ], 'ContainerType' => [ 'base' => NULL, 'refs' => [ 'ContainerRecipe$containerType' => '<p>Specifies the type of container, such as Docker.</p>', 'ContainerRecipeSummary$containerType' => '<p>Specifies the type of container, such as "Docker".</p>', 'CreateContainerRecipeRequest$containerType' => '<p>The type of container to create.</p>', ], ], 'CreateComponentRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateComponentResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateContainerRecipeRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateContainerRecipeResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateDistributionConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDistributionConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateImagePipelineRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateImagePipelineResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateImageRecipeRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateImageRecipeResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateImageRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateImageResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateInfrastructureConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateInfrastructureConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateLifecyclePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateLifecyclePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateWorkflowRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateWorkflowResponse' => [ 'base' => NULL, 'refs' => [], ], 'CvssScore' => [ 'base' => '<p>Amazon Inspector generates a risk score for each finding. This score helps you to prioritize findings, to focus on the most critical findings and the most vulnerable resources. The score uses the Common Vulnerability Scoring System (CVSS) format. This format is a modification of the base CVSS score that the National Vulnerability Database (NVD) provides. For more information about severity levels, see <a href="https://docs.aws.amazon.com/inspector/latest/user/findings-understanding-severity.html">Severity levels for Amazon Inspector findings</a> in the <i>Amazon Inspector User Guide</i>.</p>', 'refs' => [ 'CvssScoreList$member' => NULL, ], ], 'CvssScoreAdjustment' => [ 'base' => '<p>Details about an adjustment that Amazon Inspector made to the CVSS score for a finding.</p>', 'refs' => [ 'CvssScoreAdjustmentList$member' => NULL, ], ], 'CvssScoreAdjustmentList' => [ 'base' => NULL, 'refs' => [ 'CvssScoreDetails$adjustments' => '<p>An object that contains details about an adjustment that Amazon Inspector made to the CVSS score for the finding.</p>', ], ], 'CvssScoreDetails' => [ 'base' => '<p>Details about the source of the score, and the factors that determined the adjustments to create the final score.</p>', 'refs' => [ 'InspectorScoreDetails$adjustedCvss' => '<p>An object that contains details about an adjustment that Amazon Inspector made to the CVSS score for the finding.</p>', ], ], 'CvssScoreList' => [ 'base' => NULL, 'refs' => [ 'PackageVulnerabilityDetails$cvss' => '<p>CVSS scores for one or more vulnerabilities that Amazon Inspector identified for a package.</p>', ], ], 'DateTime' => [ 'base' => NULL, 'refs' => [ 'Component$dateCreated' => '<p>The date that Image Builder created the component.</p>', 'ComponentSummary$dateCreated' => '<p>The original creation date of the component.</p>', 'ComponentVersion$dateCreated' => '<p>The date that the component was created.</p>', 'ContainerRecipe$dateCreated' => '<p>The date when this container recipe was created.</p>', 'ContainerRecipeSummary$dateCreated' => '<p>The date when this container recipe was created.</p>', 'DistributionConfiguration$dateCreated' => '<p>The date on which this distribution configuration was created.</p>', 'DistributionConfiguration$dateUpdated' => '<p>The date on which this distribution configuration was last updated.</p>', 'DistributionConfigurationSummary$dateCreated' => '<p>The date on which the distribution configuration was created.</p>', 'DistributionConfigurationSummary$dateUpdated' => '<p>The date on which the distribution configuration was updated.</p>', 'GetWorkflowExecutionResponse$startTime' => '<p>The timestamp when the specified runtime instance of the workflow started.</p>', 'GetWorkflowExecutionResponse$endTime' => '<p>The timestamp when the specified runtime instance of the workflow finished.</p>', 'GetWorkflowStepExecutionResponse$startTime' => '<p>The timestamp when the specified runtime version of the workflow step started.</p>', 'GetWorkflowStepExecutionResponse$endTime' => '<p>The timestamp when the specified runtime instance of the workflow step finished.</p>', 'Image$dateCreated' => '<p>The date on which Image Builder created this image.</p>', 'ImagePipeline$dateCreated' => '<p>The date on which this image pipeline was created.</p>', 'ImagePipeline$dateUpdated' => '<p>The date on which this image pipeline was last updated.</p>', 'ImagePipeline$dateLastRun' => '<p>This is no longer supported, and does not return a value.</p>', 'ImagePipeline$dateNextRun' => '<p>The next date when the pipeline is scheduled to run.</p>', 'ImageRecipe$dateCreated' => '<p>The date on which this image recipe was created.</p>', 'ImageRecipeSummary$dateCreated' => '<p>The date on which this image recipe was created.</p>', 'ImageSummary$dateCreated' => '<p>The date on which Image Builder created this image.</p>', 'ImageVersion$dateCreated' => '<p>The date on which this specific version of the Image Builder image was created.</p>', 'InfrastructureConfiguration$dateCreated' => '<p>The date on which the infrastructure configuration was created.</p>', 'InfrastructureConfiguration$dateUpdated' => '<p>The date on which the infrastructure configuration was last updated.</p>', 'InfrastructureConfigurationSummary$dateCreated' => '<p>The date on which the infrastructure configuration was created.</p>', 'InfrastructureConfigurationSummary$dateUpdated' => '<p>The date on which the infrastructure configuration was last updated.</p>', 'Workflow$dateCreated' => '<p>The timestamp when Image Builder created the workflow resource.</p>', 'WorkflowExecutionMetadata$startTime' => '<p>The timestamp when the runtime instance of this workflow started.</p>', 'WorkflowExecutionMetadata$endTime' => '<p>The timestamp when this runtime instance of the workflow finished.</p>', 'WorkflowStepExecution$startTime' => '<p>The timestamp when the workflow step started.</p>', 'WorkflowStepMetadata$startTime' => '<p>The timestamp when the workflow step started.</p>', 'WorkflowStepMetadata$endTime' => '<p>The timestamp when the workflow step finished.</p>', 'WorkflowSummary$dateCreated' => '<p>The original creation date of the workflow resource.</p>', 'WorkflowVersion$dateCreated' => '<p>The timestamp when Image Builder created the workflow version.</p>', ], ], 'DateTimeTimestamp' => [ 'base' => NULL, 'refs' => [ 'Image$deprecationTime' => '<p>The time when deprecation occurs for an image resource. This can be a past or future date.</p>', 'ImageScanFinding$firstObservedAt' => '<p>The date and time when the finding was first observed.</p>', 'ImageScanFinding$updatedAt' => '<p>The timestamp when the finding was last updated.</p>', 'ImageSummary$deprecationTime' => '<p>The time when deprecation occurs for an image resource. This can be a past or future date.</p>', 'LifecycleExecution$startTime' => '<p>The timestamp when the lifecycle runtime instance started.</p>', 'LifecycleExecution$endTime' => '<p>The timestamp when the lifecycle runtime instance completed.</p>', 'LifecycleExecutionResource$startTime' => '<p>The starting timestamp from the lifecycle action that was applied to the resource.</p>', 'LifecycleExecutionResource$endTime' => '<p>The ending timestamp from the lifecycle action that was applied to the resource.</p>', 'LifecyclePolicy$dateCreated' => '<p>The timestamp when Image Builder created the lifecycle policy resource.</p>', 'LifecyclePolicy$dateUpdated' => '<p>The timestamp when Image Builder updated the lifecycle policy resource.</p>', 'LifecyclePolicy$dateLastRun' => '<p>The timestamp for the last time Image Builder ran the lifecycle policy.</p>', 'LifecyclePolicySummary$dateCreated' => '<p>The timestamp when Image Builder created the lifecycle policy resource.</p>', 'LifecyclePolicySummary$dateUpdated' => '<p>The timestamp when Image Builder updated the lifecycle policy resource.</p>', 'LifecyclePolicySummary$dateLastRun' => '<p>The timestamp for the last time Image Builder ran the lifecycle policy.</p>', 'PackageVulnerabilityDetails$vendorCreatedAt' => '<p>The date and time when this vulnerability was first added to the vendor\'s database.</p>', 'PackageVulnerabilityDetails$vendorUpdatedAt' => '<p>The date and time when the vendor last updated this vulnerability in their database.</p>', 'StartResourceStateUpdateRequest$updateAt' => '<p>The timestamp that indicates when resources are updated by a lifecycle action.</p>', ], ], 'DeleteComponentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteComponentResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteContainerRecipeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteContainerRecipeResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDistributionConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDistributionConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteImagePipelineRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteImagePipelineResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteImageRecipeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteImageRecipeResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteImageRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteImageResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteInfrastructureConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteInfrastructureConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLifecyclePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLifecyclePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWorkflowRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWorkflowResponse' => [ 'base' => NULL, 'refs' => [], ], 'DiskImageFormat' => [ 'base' => NULL, 'refs' => [ 'S3ExportConfiguration$diskImageFormat' => '<p>Export the updated image to one of the following supported disk image formats:</p> <ul> <li> <p> <b>Virtual Hard Disk (VHD)</b> – Compatible with Citrix Xen and Microsoft Hyper-V virtualization products.</p> </li> <li> <p> <b>Stream-optimized ESX Virtual Machine Disk (VMDK)</b> – Compatible with VMware ESX and VMware vSphere versions 4, 5, and 6.</p> </li> <li> <p> <b>Raw</b> – Raw format.</p> </li> </ul>', ], ], 'Distribution' => [ 'base' => '<p>Defines the settings for a specific Region.</p>', 'refs' => [ 'DistributionList$member' => NULL, ], ], 'DistributionConfiguration' => [ 'base' => '<p>A distribution configuration.</p>', 'refs' => [ 'GetDistributionConfigurationResponse$distributionConfiguration' => '<p>The distribution configuration object.</p>', 'Image$distributionConfiguration' => '<p>The distribution configuration that Image Builder used to create this image.</p>', ], ], 'DistributionConfigurationArn' => [ 'base' => NULL, 'refs' => [ 'CreateDistributionConfigurationResponse$distributionConfigurationArn' => '<p>The Amazon Resource Name (ARN) of the distribution configuration that was created by this request.</p>', 'CreateImagePipelineRequest$distributionConfigurationArn' => '<p>The Amazon Resource Name (ARN) of the distribution configuration that will be used to configure and distribute images created by this image pipeline.</p>', 'CreateImageRequest$distributionConfigurationArn' => '<p>The Amazon Resource Name (ARN) of the distribution configuration that defines and configures the outputs of your pipeline.</p>', 'DeleteDistributionConfigurationRequest$distributionConfigurationArn' => '<p>The Amazon Resource Name (ARN) of the distribution configuration to delete.</p>', 'DeleteDistributionConfigurationResponse$distributionConfigurationArn' => '<p>The Amazon Resource Name (ARN) of the distribution configuration that was deleted.</p>', 'GetDistributionConfigurationRequest$distributionConfigurationArn' => '<p>The Amazon Resource Name (ARN) of the distribution configuration that you want to retrieve.</p>', 'UpdateDistributionConfigurationRequest$distributionConfigurationArn' => '<p>The Amazon Resource Name (ARN) of the distribution configuration that you want to update.</p>', 'UpdateDistributionConfigurationResponse$distributionConfigurationArn' => '<p>The Amazon Resource Name (ARN) of the distribution configuration that was updated by this request.</p>', 'UpdateImagePipelineRequest$distributionConfigurationArn' => '<p>The Amazon Resource Name (ARN) of the distribution configuration that Image Builder uses to configure and distribute images that this image pipeline has updated.</p>', ], ], 'DistributionConfigurationSummary' => [ 'base' => '<p>A high-level overview of a distribution configuration.</p>', 'refs' => [ 'DistributionConfigurationSummaryList$member' => NULL, ], ], 'DistributionConfigurationSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListDistributionConfigurationsResponse$distributionConfigurationSummaryList' => '<p>The list of distributions.</p>', ], ], 'DistributionList' => [ 'base' => NULL, 'refs' => [ 'CreateDistributionConfigurationRequest$distributions' => '<p>The distributions of the distribution configuration.</p>', 'DistributionConfiguration$distributions' => '<p>The distribution objects that apply Region-specific settings for the deployment of the image to targeted Regions.</p>', 'UpdateDistributionConfigurationRequest$distributions' => '<p>The distributions of the distribution configuration.</p>', ], ], 'DistributionTimeoutMinutes' => [ 'base' => NULL, 'refs' => [ 'DistributionConfiguration$timeoutMinutes' => '<p>The maximum duration in minutes for this distribution configuration.</p>', ], ], 'DockerFileTemplate' => [ 'base' => NULL, 'refs' => [ 'ContainerRecipe$dockerfileTemplateData' => '<p>Dockerfiles are text documents that are used to build Docker containers, and ensure that they contain all of the elements required by the application running inside. The template data consists of contextual variables where Image Builder places build information or scripts, based on your container image recipe.</p>', ], ], 'EbsInstanceBlockDeviceSpecification' => [ 'base' => '<p>Amazon EBS-specific block device mapping specifications.</p>', 'refs' => [ 'InstanceBlockDeviceMapping$ebs' => '<p>Use to manage Amazon EBS-specific configuration for this mapping.</p>', ], ], 'EbsIopsInteger' => [ 'base' => NULL, 'refs' => [ 'EbsInstanceBlockDeviceSpecification$iops' => '<p>Use to configure device IOPS.</p>', ], ], 'EbsVolumeSizeInteger' => [ 'base' => NULL, 'refs' => [ 'EbsInstanceBlockDeviceSpecification$volumeSize' => '<p>Use to override the device\'s volume size.</p>', ], ], 'EbsVolumeThroughput' => [ 'base' => NULL, 'refs' => [ 'EbsInstanceBlockDeviceSpecification$throughput' => '<p> <b>For GP3 volumes only</b> – The throughput in MiB/s that the volume supports.</p>', ], ], 'EbsVolumeType' => [ 'base' => NULL, 'refs' => [ 'EbsInstanceBlockDeviceSpecification$volumeType' => '<p>Use to override the device\'s volume type.</p>', ], ], 'EcrConfiguration' => [ 'base' => '<p>Settings that Image Builder uses to configure the ECR repository and the output container images that Amazon Inspector scans.</p>', 'refs' => [ 'ImageScanningConfiguration$ecrConfiguration' => '<p>Contains Amazon ECR settings for vulnerability scans.</p>', ], ], 'EmptyString' => [ 'base' => NULL, 'refs' => [ 'InstanceBlockDeviceMapping$noDevice' => '<p>Use to remove a mapping from the base image.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'CallRateLimitExceededException$message' => NULL, 'ClientException$message' => NULL, 'ForbiddenException$message' => NULL, 'IdempotentParameterMismatchException$message' => NULL, 'InvalidPaginationTokenException$message' => NULL, 'InvalidParameterCombinationException$message' => NULL, 'InvalidParameterException$message' => NULL, 'InvalidParameterValueException$message' => NULL, 'InvalidRequestException$message' => NULL, 'InvalidVersionNumberException$message' => NULL, 'ResourceAlreadyExistsException$message' => NULL, 'ResourceDependencyException$message' => NULL, 'ResourceInUseException$message' => NULL, 'ResourceNotFoundException$message' => NULL, 'ServiceException$message' => NULL, 'ServiceQuotaExceededException$message' => NULL, 'ServiceUnavailableException$message' => NULL, ], ], 'FastLaunchConfiguration' => [ 'base' => '<p>Define and configure faster launching for output Windows AMIs.</p>', 'refs' => [ 'FastLaunchConfigurationList$member' => NULL, ], ], 'FastLaunchConfigurationList' => [ 'base' => NULL, 'refs' => [ 'Distribution$fastLaunchConfigurations' => '<p>The Windows faster-launching configurations to use for AMI distribution.</p>', ], ], 'FastLaunchLaunchTemplateSpecification' => [ 'base' => '<p>Identifies the launch template that the associated Windows AMI uses for launching an instance when faster launching is enabled.</p> <note> <p>You can specify either the <code>launchTemplateName</code> or the <code>launchTemplateId</code>, but not both.</p> </note>', 'refs' => [ 'FastLaunchConfiguration$launchTemplate' => '<p>The launch template that the fast-launch enabled Windows AMI uses when it launches Windows instances to create pre-provisioned snapshots.</p>', ], ], 'FastLaunchSnapshotConfiguration' => [ 'base' => '<p>Configuration settings for creating and managing pre-provisioned snapshots for a fast-launch enabled Windows AMI.</p>', 'refs' => [ 'FastLaunchConfiguration$snapshotConfiguration' => '<p>Configuration settings for managing the number of snapshots that are created from pre-provisioned instances for the Windows AMI when faster launching is enabled.</p>', ], ], 'Filter' => [ 'base' => '<p>A filter name and value pair that is used to return a more specific list of results from a list operation. Filters can be used to match a set of resources by specific criteria, such as tags, attributes, or IDs.</p>', 'refs' => [ 'FilterList$member' => NULL, 'ListImageScanFindingAggregationsRequest$filter' => NULL, ], ], 'FilterList' => [ 'base' => NULL, 'refs' => [ 'ListComponentsRequest$filters' => '<p>Use the following filters to streamline results:</p> <ul> <li> <p> <code>description</code> </p> </li> <li> <p> <code>name</code> </p> </li> <li> <p> <code>platform</code> </p> </li> <li> <p> <code>supportedOsVersion</code> </p> </li> <li> <p> <code>type</code> </p> </li> <li> <p> <code>version</code> </p> </li> </ul>', 'ListContainerRecipesRequest$filters' => '<p>Use the following filters to streamline results:</p> <ul> <li> <p> <code>containerType</code> </p> </li> <li> <p> <code>name</code> </p> </li> <li> <p> <code>parentImage</code> </p> </li> <li> <p> <code>platform</code> </p> </li> </ul>', 'ListDistributionConfigurationsRequest$filters' => '<p>You can filter on <code>name</code> to streamline results.</p>', 'ListImageBuildVersionsRequest$filters' => '<p>Use the following filters to streamline results:</p> <ul> <li> <p> <code>name</code> </p> </li> <li> <p> <code>osVersion</code> </p> </li> <li> <p> <code>platform</code> </p> </li> <li> <p> <code>type</code> </p> </li> <li> <p> <code>version</code> </p> </li> </ul>', 'ListImagePipelineImagesRequest$filters' => '<p>Use the following filters to streamline results:</p> <ul> <li> <p> <code>name</code> </p> </li> <li> <p> <code>version</code> </p> </li> </ul>', 'ListImagePipelinesRequest$filters' => '<p>Use the following filters to streamline results:</p> <ul> <li> <p> <code>description</code> </p> </li> <li> <p> <code>distributionConfigurationArn</code> </p> </li> <li> <p> <code>imageRecipeArn</code> </p> </li> <li> <p> <code>infrastructureConfigurationArn</code> </p> </li> <li> <p> <code>name</code> </p> </li> <li> <p> <code>status</code> </p> </li> </ul>', 'ListImageRecipesRequest$filters' => '<p>Use the following filters to streamline results:</p> <ul> <li> <p> <code>name</code> </p> </li> <li> <p> <code>parentImage</code> </p> </li> <li> <p> <code>platform</code> </p> </li> </ul>', 'ListImagesRequest$filters' => '<p>Use the following filters to streamline results:</p> <ul> <li> <p> <code>name</code> </p> </li> <li> <p> <code>osVersion</code> </p> </li> <li> <p> <code>platform</code> </p> </li> <li> <p> <code>type</code> </p> </li> <li> <p> <code>version</code> </p> </li> </ul>', 'ListInfrastructureConfigurationsRequest$filters' => '<p>You can filter on <code>name</code> to streamline results.</p>', 'ListLifecyclePoliciesRequest$filters' => '<p>Streamline results based on one of the following values: <code>Name</code>, <code>Status</code>.</p>', 'ListWorkflowsRequest$filters' => '<p>Used to streamline search results.</p>', ], ], 'FilterName' => [ 'base' => NULL, 'refs' => [ 'Filter$name' => '<p>The name of the filter. Filter names are case-sensitive.</p>', 'ImageScanFindingsFilter$name' => '<p>The name of the image scan finding filter. Filter names are case-sensitive.</p>', ], ], 'FilterValue' => [ 'base' => NULL, 'refs' => [ 'FilterValues$member' => NULL, 'ImageScanFindingsFilterValues$member' => NULL, ], ], 'FilterValues' => [ 'base' => NULL, 'refs' => [ 'Filter$values' => '<p>The filter values. Filter values are case-sensitive.</p>', ], ], 'ForbiddenException' => [ 'base' => '<p>You are not authorized to perform the requested operation.</p>', 'refs' => [], ], 'GetComponentPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetComponentPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetComponentRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetComponentResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetContainerRecipePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetContainerRecipePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetContainerRecipeRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetContainerRecipeResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetDistributionConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDistributionConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetImagePipelineRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetImagePipelineResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetImagePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetImagePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetImageRecipePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetImageRecipePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetImageRecipeRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetImageRecipeResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetImageRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetImageResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetInfrastructureConfigurationRequest' => [ 'base' => '<p>GetInfrastructureConfiguration request object.</p>', 'refs' => [], ], 'GetInfrastructureConfigurationResponse' => [ 'base' => '<p>GetInfrastructureConfiguration response object.</p>', 'refs' => [], ], 'GetLifecycleExecutionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetLifecycleExecutionResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetLifecyclePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetLifecyclePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetWorkflowExecutionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetWorkflowExecutionResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetWorkflowRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetWorkflowResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetWorkflowStepExecutionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetWorkflowStepExecutionResponse' => [ 'base' => NULL, 'refs' => [], ], 'HttpPutResponseHopLimit' => [ 'base' => NULL, 'refs' => [ 'InstanceMetadataOptions$httpPutResponseHopLimit' => '<p>Limit the number of hops that an instance metadata request can traverse to reach its destination. The default is one hop. However, if HTTP tokens are required, container image builds need a minimum of two hops.</p>', ], ], 'HttpTokens' => [ 'base' => NULL, 'refs' => [ 'InstanceMetadataOptions$httpTokens' => '<p>Indicates whether a signed token header is required for instance metadata retrieval requests. The values affect the response as follows:</p> <ul> <li> <p> <b>required</b> – When you retrieve the IAM role credentials, version 2.0 credentials are returned in all cases.</p> </li> <li> <p> <b>optional</b> – You can include a signed token header in your request to retrieve instance metadata, or you can leave it out. If you include it, version 2.0 credentials are returned for the IAM role. Otherwise, version 1.0 credentials are returned.</p> </li> </ul> <p>The default setting is <b>optional</b>.</p>', ], ], 'IdempotentParameterMismatchException' => [ 'base' => '<p>You have specified a client token for an operation using parameter values that differ from a previous request that used the same client token.</p>', 'refs' => [], ], 'Image' => [ 'base' => '<p>An Image Builder image. You must specify exactly one recipe for the image – either a container recipe (<code>containerRecipe</code>), which creates a container image, or an image recipe (<code>imageRecipe</code>), which creates an AMI.</p>', 'refs' => [ 'GetImageResponse$image' => '<p>The image object.</p>', ], ], 'ImageAggregation' => [ 'base' => '<p>Contains vulnerability counts for a specific image.</p>', 'refs' => [ 'ImageScanFindingAggregation$imageAggregation' => '<p>Returns an object that contains severity counts based on the Amazon Resource Name (ARN) for a specific image.</p>', ], ], 'ImageBuildMessage' => [ 'base' => NULL, 'refs' => [ 'ListWorkflowExecutionsResponse$message' => '<p>The output message from the list action, if applicable.</p>', 'ListWorkflowStepExecutionsResponse$message' => '<p>The output message from the list action, if applicable.</p>', ], ], 'ImageBuildVersionArn' => [ 'base' => NULL, 'refs' => [ 'CancelImageCreationRequest$imageBuildVersionArn' => '<p>The Amazon Resource Name (ARN) of the image that you want to cancel creation for.</p>', 'CancelImageCreationResponse$imageBuildVersionArn' => '<p>The ARN of the image whose creation this request canceled.</p>', 'CreateImageResponse$imageBuildVersionArn' => '<p>The Amazon Resource Name (ARN) of the image that the request created.</p>', 'DeleteImageRequest$imageBuildVersionArn' => '<p>The Amazon Resource Name (ARN) of the Image Builder image resource to delete.</p>', 'DeleteImageResponse$imageBuildVersionArn' => '<p>The ARN of the Image Builder image resource that this request deleted.</p>', 'GetImagePolicyRequest$imageArn' => '<p>The Amazon Resource Name (ARN) of the image whose policy you want to retrieve.</p>', 'GetWorkflowExecutionResponse$imageBuildVersionArn' => '<p>The Amazon Resource Name (ARN) of the image resource build version that the specified runtime instance of the workflow created.</p>', 'GetWorkflowStepExecutionResponse$imageBuildVersionArn' => '<p>The Amazon Resource Name (ARN) of the image resource build version that the specified runtime instance of the workflow step creates.</p>', 'ImageAggregation$imageBuildVersionArn' => '<p>The Amazon Resource Name (ARN) that identifies the image for this aggregation.</p>', 'ImageScanFinding$imageBuildVersionArn' => '<p>The Amazon Resource Name (ARN) of the image build version that\'s associated with the finding.</p>', 'ListImagePackagesRequest$imageBuildVersionArn' => '<p>Filter results for the ListImagePackages request by the Image Build Version ARN</p>', 'ListWorkflowExecutionsRequest$imageBuildVersionArn' => '<p>List all workflow runtime instances for the specified image build version resource ARN.</p>', 'ListWorkflowExecutionsResponse$imageBuildVersionArn' => '<p>The resource ARN of the image build version for which you requested a list of workflow runtime details.</p>', 'ListWorkflowStepExecutionsResponse$imageBuildVersionArn' => '<p>The image build version resource ARN that\'s associated with the specified runtime instance of the workflow.</p>', 'PutImagePolicyRequest$imageArn' => '<p>The Amazon Resource Name (ARN) of the image that this policy should be applied to.</p>', 'PutImagePolicyResponse$imageArn' => '<p>The Amazon Resource Name (ARN) of the image that this policy was applied to.</p>', 'SendWorkflowStepActionRequest$imageBuildVersionArn' => '<p>The Amazon Resource Name (ARN) of the image build version to send action for.</p>', 'SendWorkflowStepActionResponse$imageBuildVersionArn' => '<p>The Amazon Resource Name (ARN) of the image build version that received the action request.</p>', 'StartImagePipelineExecutionResponse$imageBuildVersionArn' => '<p>The Amazon Resource Name (ARN) of the image that the request created.</p>', 'StartResourceStateUpdateRequest$resourceArn' => '<p>The ARN of the Image Builder resource that is updated. The state update might also impact associated resources.</p>', 'StartResourceStateUpdateResponse$resourceArn' => '<p>The requested ARN of the Image Builder resource for the asynchronous update.</p>', 'WorkflowStepExecution$imageBuildVersionArn' => '<p>The Amazon Resource Name (ARN) of the image build version that ran the workflow.</p>', ], ], 'ImageBuilderArn' => [ 'base' => NULL, 'refs' => [ 'Component$arn' => '<p>The Amazon Resource Name (ARN) of the component.</p>', 'ComponentSummary$arn' => '<p>The Amazon Resource Name (ARN) of the component.</p>', 'ComponentVersion$arn' => '<p>The Amazon Resource Name (ARN) of the component.</p> <note> <p>Semantic versioning is included in each object\'s Amazon Resource Name (ARN), at the level that applies to that object as follows:</p> <ol> <li> <p>Versionless ARNs and Name ARNs do not include specific values in any of the nodes. The nodes are either left off entirely, or they are specified as wildcards, for example: x.x.x.</p> </li> <li> <p>Version ARNs have only the first three nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;</p> </li> <li> <p>Build version ARNs have all four nodes, and point to a specific build for a specific version of an object.</p> </li> </ol> </note>', 'ContainerRecipe$arn' => '<p>The Amazon Resource Name (ARN) of the container recipe.</p> <note> <p>Semantic versioning is included in each object\'s Amazon Resource Name (ARN), at the level that applies to that object as follows:</p> <ol> <li> <p>Versionless ARNs and Name ARNs do not include specific values in any of the nodes. The nodes are either left off entirely, or they are specified as wildcards, for example: x.x.x.</p> </li> <li> <p>Version ARNs have only the first three nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;</p> </li> <li> <p>Build version ARNs have all four nodes, and point to a specific build for a specific version of an object.</p> </li> </ol> </note>', 'ContainerRecipeSummary$arn' => '<p>The Amazon Resource Name (ARN) of the container recipe.</p>', 'DistributionConfiguration$arn' => '<p>The Amazon Resource Name (ARN) of the distribution configuration.</p>', 'DistributionConfigurationSummary$arn' => '<p>The Amazon Resource Name (ARN) of the distribution configuration.</p>', 'Image$arn' => '<p>The Amazon Resource Name (ARN) of the image.</p> <note> <p>Semantic versioning is included in each object\'s Amazon Resource Name (ARN), at the level that applies to that object as follows:</p> <ol> <li> <p>Versionless ARNs and Name ARNs do not include specific values in any of the nodes. The nodes are either left off entirely, or they are specified as wildcards, for example: x.x.x.</p> </li> <li> <p>Version ARNs have only the first three nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;</p> </li> <li> <p>Build version ARNs have all four nodes, and point to a specific build for a specific version of an object.</p> </li> </ol> </note>', 'ImagePipeline$arn' => '<p>The Amazon Resource Name (ARN) of the image pipeline.</p>', 'ImageRecipe$arn' => '<p>The Amazon Resource Name (ARN) of the image recipe.</p>', 'ImageRecipeSummary$arn' => '<p>The Amazon Resource Name (ARN) of the image recipe.</p>', 'ImageSummary$arn' => '<p>The Amazon Resource Name (ARN) of the image.</p>', 'ImageVersion$arn' => '<p>The Amazon Resource Name (ARN) of a specific version of an Image Builder image.</p> <note> <p>Semantic versioning is included in each object\'s Amazon Resource Name (ARN), at the level that applies to that object as follows:</p> <ol> <li> <p>Versionless ARNs and Name ARNs do not include specific values in any of the nodes. The nodes are either left off entirely, or they are specified as wildcards, for example: x.x.x.</p> </li> <li> <p>Version ARNs have only the first three nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;</p> </li> <li> <p>Build version ARNs have all four nodes, and point to a specific build for a specific version of an object.</p> </li> </ol> </note>', 'InfrastructureConfiguration$arn' => '<p>The Amazon Resource Name (ARN) of the infrastructure configuration.</p>', 'InfrastructureConfigurationSummary$arn' => '<p>The Amazon Resource Name (ARN) of the infrastructure configuration.</p>', 'ListLifecycleExecutionsRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource for which to get a list of lifecycle runtime instances.</p>', 'ListTagsForResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource whose tags you want to retrieve.</p>', 'TagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource that you want to tag.</p>', 'UntagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource that you want to untag.</p>', ], ], 'ImagePackage' => [ 'base' => '<p>Represents a package installed on an Image Builder image.</p>', 'refs' => [ 'ImagePackageList$member' => NULL, ], ], 'ImagePackageList' => [ 'base' => NULL, 'refs' => [ 'ListImagePackagesResponse$imagePackageList' => '<p>The list of Image Packages returned in the response.</p>', ], ], 'ImagePipeline' => [ 'base' => '<p>Details of an image pipeline.</p>', 'refs' => [ 'GetImagePipelineResponse$imagePipeline' => '<p>The image pipeline object.</p>', 'ImagePipelineList$member' => NULL, ], ], 'ImagePipelineAggregation' => [ 'base' => '<p>Contains vulnerability counts for a specific image pipeline.</p>', 'refs' => [ 'ImageScanFindingAggregation$imagePipelineAggregation' => '<p>Returns an object that contains severity counts based on an image pipeline ARN.</p>', ], ], 'ImagePipelineArn' => [ 'base' => NULL, 'refs' => [ 'CreateImagePipelineResponse$imagePipelineArn' => '<p>The Amazon Resource Name (ARN) of the image pipeline that was created by this request.</p>', 'DeleteImagePipelineRequest$imagePipelineArn' => '<p>The Amazon Resource Name (ARN) of the image pipeline to delete.</p>', 'DeleteImagePipelineResponse$imagePipelineArn' => '<p>The Amazon Resource Name (ARN) of the image pipeline that was deleted.</p>', 'GetImagePipelineRequest$imagePipelineArn' => '<p>The Amazon Resource Name (ARN) of the image pipeline that you want to retrieve.</p>', 'ImagePipelineAggregation$imagePipelineArn' => '<p>The Amazon Resource Name (ARN) that identifies the image pipeline for this aggregation.</p>', 'ImageScanFinding$imagePipelineArn' => '<p>The Amazon Resource Name (ARN) of the image pipeline that\'s associated with the finding.</p>', 'ListImagePipelineImagesRequest$imagePipelineArn' => '<p>The Amazon Resource Name (ARN) of the image pipeline whose images you want to view.</p>', 'StartImagePipelineExecutionRequest$imagePipelineArn' => '<p>The Amazon Resource Name (ARN) of the image pipeline that you want to manually invoke.</p>', 'UpdateImagePipelineRequest$imagePipelineArn' => '<p>The Amazon Resource Name (ARN) of the image pipeline that you want to update.</p>', 'UpdateImagePipelineResponse$imagePipelineArn' => '<p>The Amazon Resource Name (ARN) of the image pipeline that was updated by this request.</p>', ], ], 'ImagePipelineList' => [ 'base' => NULL, 'refs' => [ 'ListImagePipelinesResponse$imagePipelineList' => '<p>The list of image pipelines.</p>', ], ], 'ImageRecipe' => [ 'base' => '<p>An image recipe.</p>', 'refs' => [ 'GetImageRecipeResponse$imageRecipe' => '<p>The image recipe object.</p>', 'Image$imageRecipe' => '<p>For images that distribute an AMI, this is the image recipe that Image Builder used to create the image. For container images, this is empty.</p>', ], ], 'ImageRecipeArn' => [ 'base' => NULL, 'refs' => [ 'CreateImagePipelineRequest$imageRecipeArn' => '<p>The Amazon Resource Name (ARN) of the image recipe that will be used to configure images created by this image pipeline.</p>', 'CreateImageRecipeResponse$imageRecipeArn' => '<p>The Amazon Resource Name (ARN) of the image recipe that was created by this request.</p>', 'CreateImageRequest$imageRecipeArn' => '<p>The Amazon Resource Name (ARN) of the image recipe that defines how images are configured, tested, and assessed.</p>', 'DeleteImageRecipeRequest$imageRecipeArn' => '<p>The Amazon Resource Name (ARN) of the image recipe to delete.</p>', 'DeleteImageRecipeResponse$imageRecipeArn' => '<p>The Amazon Resource Name (ARN) of the image recipe that was deleted.</p>', 'GetImageRecipePolicyRequest$imageRecipeArn' => '<p>The Amazon Resource Name (ARN) of the image recipe whose policy you want to retrieve.</p>', 'GetImageRecipeRequest$imageRecipeArn' => '<p>The Amazon Resource Name (ARN) of the image recipe that you want to retrieve.</p>', 'PutImageRecipePolicyRequest$imageRecipeArn' => '<p>The Amazon Resource Name (ARN) of the image recipe that this policy should be applied to.</p>', 'PutImageRecipePolicyResponse$imageRecipeArn' => '<p>The Amazon Resource Name (ARN) of the image recipe that this policy was applied to.</p>', 'UpdateImagePipelineRequest$imageRecipeArn' => '<p>The Amazon Resource Name (ARN) of the image recipe that will be used to configure images updated by this image pipeline.</p>', ], ], 'ImageRecipeSummary' => [ 'base' => '<p>A summary of an image recipe.</p>', 'refs' => [ 'ImageRecipeSummaryList$member' => NULL, ], ], 'ImageRecipeSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListImageRecipesResponse$imageRecipeSummaryList' => '<p>The list of image pipelines.</p>', ], ], 'ImageScanFinding' => [ 'base' => '<p>Contains details about a vulnerability scan finding.</p>', 'refs' => [ 'ImageScanFindingsList$member' => NULL, ], ], 'ImageScanFindingAggregation' => [ 'base' => '<p>This returns exactly one type of aggregation, based on the filter that Image Builder applies in its API action.</p>', 'refs' => [ 'ImageScanFindingAggregationsList$member' => NULL, ], ], 'ImageScanFindingAggregationsList' => [ 'base' => NULL, 'refs' => [ 'ListImageScanFindingAggregationsResponse$responses' => '<p>An array of image scan finding aggregations that match the filter criteria.</p>', ], ], 'ImageScanFindingsFilter' => [ 'base' => '<p>A name value pair that Image Builder applies to streamline results from the vulnerability scan findings list action.</p>', 'refs' => [ 'ImageScanFindingsFilterList$member' => NULL, ], ], 'ImageScanFindingsFilterList' => [ 'base' => NULL, 'refs' => [ 'ListImageScanFindingsRequest$filters' => '<p>An array of name value pairs that you can use to filter your results. You can use the following filters to streamline results:</p> <ul> <li> <p> <code>imageBuildVersionArn</code> </p> </li> <li> <p> <code>imagePipelineArn</code> </p> </li> <li> <p> <code>vulnerabilityId</code> </p> </li> <li> <p> <code>severity</code> </p> </li> </ul> <p>If you don\'t request a filter, then all findings in your account are listed.</p>', ], ], 'ImageScanFindingsFilterValues' => [ 'base' => NULL, 'refs' => [ 'ImageScanFindingsFilter$values' => '<p>The filter values. Filter values are case-sensitive.</p>', ], ], 'ImageScanFindingsList' => [ 'base' => NULL, 'refs' => [ 'ListImageScanFindingsResponse$findings' => '<p>The image scan findings for your account that meet your request filter criteria.</p>', ], ], 'ImageScanState' => [ 'base' => '<p>Shows the vulnerability scan status for a specific image, and the reason for that status.</p>', 'refs' => [ 'Image$scanState' => '<p>Contains information about the current state of scans for this image.</p>', ], ], 'ImageScanStatus' => [ 'base' => NULL, 'refs' => [ 'ImageScanState$status' => '<p>The current state of vulnerability scans for the image.</p>', ], ], 'ImageScanningConfiguration' => [ 'base' => '<p>Contains settings for Image Builder image resource and container image scans.</p>', 'refs' => [ 'CreateImagePipelineRequest$imageScanningConfiguration' => '<p>Contains settings for vulnerability scans.</p>', 'CreateImageRequest$imageScanningConfiguration' => '<p>Contains settings for vulnerability scans.</p>', 'Image$imageScanningConfiguration' => '<p>Contains settings for vulnerability scans.</p>', 'ImagePipeline$imageScanningConfiguration' => '<p>Contains settings for vulnerability scans.</p>', 'UpdateImagePipelineRequest$imageScanningConfiguration' => '<p>Contains settings for vulnerability scans.</p>', ], ], 'ImageSource' => [ 'base' => NULL, 'refs' => [ 'Image$imageSource' => '<p>The origin of the base image that Image Builder used to build this image.</p>', 'ImageSummary$imageSource' => '<p>The origin of the base image that Image Builder used to build this image.</p>', 'ImageVersion$imageSource' => '<p>The origin of the base image that Image Builder used to build this image.</p>', ], ], 'ImageState' => [ 'base' => '<p>Image status and the reason for that status.</p>', 'refs' => [ 'Ami$state' => NULL, 'Image$state' => '<p>The state of the image.</p>', 'ImageSummary$state' => '<p>The state of the image.</p>', ], ], 'ImageStatus' => [ 'base' => NULL, 'refs' => [ 'ImageState$status' => '<p>The status of the image.</p>', ], ], 'ImageSummary' => [ 'base' => '<p>An image summary.</p>', 'refs' => [ 'ImageSummaryList$member' => NULL, ], ], 'ImageSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListImageBuildVersionsResponse$imageSummaryList' => '<p>The list of image build versions.</p>', 'ListImagePipelineImagesResponse$imageSummaryList' => '<p>The list of images built by this pipeline.</p>', ], ], 'ImageTestsConfiguration' => [ 'base' => '<p>Configure image tests for your pipeline build. Tests run after building the image, to verify that the AMI or container image is valid before distributing it.</p>', 'refs' => [ 'CreateImagePipelineRequest$imageTestsConfiguration' => '<p>The image test configuration of the image pipeline.</p>', 'CreateImageRequest$imageTestsConfiguration' => '<p>The image tests configuration of the image.</p>', 'Image$imageTestsConfiguration' => '<p>The image tests that ran when that Image Builder created this image.</p>', 'ImagePipeline$imageTestsConfiguration' => '<p>The image tests configuration of the image pipeline.</p>', 'UpdateImagePipelineRequest$imageTestsConfiguration' => '<p>The image test configuration of the image pipeline.</p>', ], ], 'ImageTestsTimeoutMinutes' => [ 'base' => NULL, 'refs' => [ 'ImageTestsConfiguration$timeoutMinutes' => '<p>The maximum time in minutes that tests are permitted to run.</p> <note> <p>The timeoutMinutes attribute is not currently active. This value is ignored.</p> </note>', ], ], 'ImageType' => [ 'base' => NULL, 'refs' => [ 'Image$type' => '<p>Specifies whether this image produces an AMI or a container image.</p>', 'ImageRecipe$type' => '<p>Specifies which type of image is created by the recipe - an AMI or a container image.</p>', 'ImageSummary$type' => '<p>Specifies whether this image produces an AMI or a container image.</p>', 'ImageVersion$type' => '<p>Specifies whether this image produces an AMI or a container image.</p>', ], ], 'ImageVersion' => [ 'base' => '<p>The defining characteristics of a specific version of an Image Builder image.</p>', 'refs' => [ 'ImageVersionList$member' => NULL, ], ], 'ImageVersionArn' => [ 'base' => NULL, 'refs' => [ 'ListImageBuildVersionsRequest$imageVersionArn' => '<p>The Amazon Resource Name (ARN) of the image whose build versions you want to retrieve.</p>', ], ], 'ImageVersionArnOrBuildVersionArn' => [ 'base' => NULL, 'refs' => [ 'GetImageRequest$imageBuildVersionArn' => '<p>The Amazon Resource Name (ARN) of the image that you want to get.</p>', ], ], 'ImageVersionList' => [ 'base' => NULL, 'refs' => [ 'ListImagesResponse$imageVersionList' => '<p>The list of image semantic versions.</p> <note> <p>The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can assign values for the first three, and can filter on all of them.</p> <p> <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x) to specify the most recent versions or nodes when selecting the base image or components for your recipe. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be wildcards.</p> </note>', ], ], 'ImportComponentRequest' => [ 'base' => NULL, 'refs' => [], ], 'ImportComponentResponse' => [ 'base' => NULL, 'refs' => [], ], 'ImportVmImageRequest' => [ 'base' => NULL, 'refs' => [], ], 'ImportVmImageResponse' => [ 'base' => NULL, 'refs' => [], ], 'InfrastructureConfiguration' => [ 'base' => '<p>Details of the infrastructure configuration.</p>', 'refs' => [ 'GetInfrastructureConfigurationResponse$infrastructureConfiguration' => '<p>The infrastructure configuration object.</p>', 'Image$infrastructureConfiguration' => '<p>The infrastructure that Image Builder used to create this image.</p>', ], ], 'InfrastructureConfigurationArn' => [ 'base' => NULL, 'refs' => [ 'CreateImagePipelineRequest$infrastructureConfigurationArn' => '<p>The Amazon Resource Name (ARN) of the infrastructure configuration that will be used to build images created by this image pipeline.</p>', 'CreateImageRequest$infrastructureConfigurationArn' => '<p>The Amazon Resource Name (ARN) of the infrastructure configuration that defines the environment in which your image will be built and tested.</p>', 'CreateInfrastructureConfigurationResponse$infrastructureConfigurationArn' => '<p>The Amazon Resource Name (ARN) of the infrastructure configuration that was created by this request.</p>', 'DeleteInfrastructureConfigurationRequest$infrastructureConfigurationArn' => '<p>The Amazon Resource Name (ARN) of the infrastructure configuration to delete.</p>', 'DeleteInfrastructureConfigurationResponse$infrastructureConfigurationArn' => '<p>The Amazon Resource Name (ARN) of the infrastructure configuration that was deleted.</p>', 'GetInfrastructureConfigurationRequest$infrastructureConfigurationArn' => '<p>The Amazon Resource Name (ARN) of the infrastructure configuration that you want to retrieve.</p>', 'UpdateImagePipelineRequest$infrastructureConfigurationArn' => '<p>The Amazon Resource Name (ARN) of the infrastructure configuration that Image Builder uses to build images that this image pipeline has updated.</p>', 'UpdateInfrastructureConfigurationRequest$infrastructureConfigurationArn' => '<p>The Amazon Resource Name (ARN) of the infrastructure configuration that you want to update.</p>', 'UpdateInfrastructureConfigurationResponse$infrastructureConfigurationArn' => '<p>The Amazon Resource Name (ARN) of the infrastructure configuration that was updated by this request.</p>', ], ], 'InfrastructureConfigurationSummary' => [ 'base' => '<p>The infrastructure used when building Amazon EC2 AMIs.</p>', 'refs' => [ 'InfrastructureConfigurationSummaryList$member' => NULL, ], ], 'InfrastructureConfigurationSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListInfrastructureConfigurationsResponse$infrastructureConfigurationSummaryList' => '<p>The list of infrastructure configurations.</p>', ], ], 'InlineComponentData' => [ 'base' => NULL, 'refs' => [ 'CreateComponentRequest$data' => '<p>Component <code>data</code> contains inline YAML document content for the component. Alternatively, you can specify the <code>uri</code> of a YAML document file stored in Amazon S3. However, you cannot specify both properties.</p>', ], ], 'InlineDockerFileTemplate' => [ 'base' => NULL, 'refs' => [ 'CreateContainerRecipeRequest$dockerfileTemplateData' => '<p>The Dockerfile template used to build your image as an inline data blob.</p>', ], ], 'InlineWorkflowData' => [ 'base' => NULL, 'refs' => [ 'CreateWorkflowRequest$data' => '<p>Contains the UTF-8 encoded YAML document content for the workflow. Alternatively, you can specify the <code>uri</code> of a YAML document file stored in Amazon S3. However, you cannot specify both properties.</p>', ], ], 'InspectorScoreDetails' => [ 'base' => '<p>Information about the factors that influenced the score that Amazon Inspector assigned for a finding.</p>', 'refs' => [ 'ImageScanFinding$inspectorScoreDetails' => '<p>An object that contains details of the Amazon Inspector score.</p>', ], ], 'InstanceBlockDeviceMapping' => [ 'base' => '<p>Defines block device mappings for the instance used to configure your image.</p>', 'refs' => [ 'InstanceBlockDeviceMappings$member' => NULL, ], ], 'InstanceBlockDeviceMappings' => [ 'base' => NULL, 'refs' => [ 'CreateImageRecipeRequest$blockDeviceMappings' => '<p>The block device mappings of the image recipe.</p>', 'ImageRecipe$blockDeviceMappings' => '<p>The block device mappings to apply when creating images from this recipe.</p>', 'InstanceConfiguration$blockDeviceMappings' => '<p>Defines the block devices to attach for building an instance from this Image Builder AMI.</p>', ], ], 'InstanceConfiguration' => [ 'base' => '<p>Defines a custom base AMI and block device mapping configurations of an instance used for building and testing container images.</p>', 'refs' => [ 'ContainerRecipe$instanceConfiguration' => '<p>A group of options that can be used to configure an instance for building and testing container images.</p>', 'CreateContainerRecipeRequest$instanceConfiguration' => '<p>A group of options that can be used to configure an instance for building and testing container images.</p>', ], ], 'InstanceMetadataOptions' => [ 'base' => '<p>The instance metadata options that apply to the HTTP requests that pipeline builds use to launch EC2 build and test instances. For more information about instance metadata options, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-instance-metadata-options.html">Configure the instance metadata options</a> in the <i> <i>Amazon EC2 User Guide</i> </i> for Linux instances, or <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/configuring-instance-metadata-options.html">Configure the instance metadata options</a> in the <i> <i>Amazon EC2 Windows Guide</i> </i> for Windows instances.</p>', 'refs' => [ 'CreateInfrastructureConfigurationRequest$instanceMetadataOptions' => '<p>The instance metadata options that you can set for the HTTP requests that pipeline builds use to launch EC2 build and test instances.</p>', 'InfrastructureConfiguration$instanceMetadataOptions' => '<p>The instance metadata option settings for the infrastructure configuration.</p>', 'UpdateInfrastructureConfigurationRequest$instanceMetadataOptions' => '<p>The instance metadata options that you can set for the HTTP requests that pipeline builds use to launch EC2 build and test instances. For more information about instance metadata options, see one of the following links:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-instance-metadata-options.html">Configure the instance metadata options</a> in the <i> <i>Amazon EC2 User Guide</i> </i> for Linux instances.</p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/configuring-instance-metadata-options.html">Configure the instance metadata options</a> in the <i> <i>Amazon EC2 Windows Guide</i> </i> for Windows instances.</p> </li> </ul>', ], ], 'InstanceProfileNameType' => [ 'base' => NULL, 'refs' => [ 'CreateInfrastructureConfigurationRequest$instanceProfileName' => '<p>The instance profile to associate with the instance used to customize your Amazon EC2 AMI.</p>', 'InfrastructureConfiguration$instanceProfileName' => '<p>The instance profile of the infrastructure configuration.</p>', 'InfrastructureConfigurationSummary$instanceProfileName' => '<p>The instance profile of the infrastructure configuration.</p>', 'UpdateInfrastructureConfigurationRequest$instanceProfileName' => '<p>The instance profile to associate with the instance used to customize your Amazon EC2 AMI.</p>', ], ], 'InstanceType' => [ 'base' => NULL, 'refs' => [ 'InstanceTypeList$member' => NULL, ], ], 'InstanceTypeList' => [ 'base' => NULL, 'refs' => [ 'CreateInfrastructureConfigurationRequest$instanceTypes' => '<p>The instance types of the infrastructure configuration. You can specify one or more instance types to use for this build. The service will pick one of these instance types based on availability.</p>', 'InfrastructureConfiguration$instanceTypes' => '<p>The instance types of the infrastructure configuration.</p>', 'InfrastructureConfigurationSummary$instanceTypes' => '<p>The instance types of the infrastructure configuration.</p>', 'UpdateInfrastructureConfigurationRequest$instanceTypes' => '<p>The instance types of the infrastructure configuration. You can specify one or more instance types to use for this build. The service will pick one of these instance types based on availability.</p>', ], ], 'InvalidPaginationTokenException' => [ 'base' => '<p>You have provided an invalid pagination token in your request.</p>', 'refs' => [], ], 'InvalidParameterCombinationException' => [ 'base' => '<p>You have specified two or more mutually exclusive parameters. Review the error message for details.</p>', 'refs' => [], ], 'InvalidParameterException' => [ 'base' => '<p>The specified parameter is invalid. Review the available parameters for the API request.</p>', 'refs' => [], ], 'InvalidParameterValueException' => [ 'base' => '<p>The value that you provided for the specified parameter is invalid.</p>', 'refs' => [], ], 'InvalidRequestException' => [ 'base' => '<p>You have requested an action that that the service doesn\'t support.</p>', 'refs' => [], ], 'InvalidVersionNumberException' => [ 'base' => '<p>Your version number is out of bounds or does not follow the required syntax.</p>', 'refs' => [], ], 'LaunchPermissionConfiguration' => [ 'base' => '<p>Describes the configuration for a launch permission. The launch permission modification request is sent to the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyImageAttribute.html">Amazon EC2 ModifyImageAttribute</a> API on behalf of the user for each Region they have selected to distribute the AMI. To make an AMI public, set the launch permission authorized accounts to <code>all</code>. See the examples for making an AMI public at <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyImageAttribute.html">Amazon EC2 ModifyImageAttribute</a>.</p>', 'refs' => [ 'AmiDistributionConfiguration$launchPermission' => '<p>Launch permissions can be used to configure which Amazon Web Services accounts can use the AMI to launch instances.</p>', ], ], 'LaunchTemplateConfiguration' => [ 'base' => '<p>Identifies an Amazon EC2 launch template to use for a specific account.</p>', 'refs' => [ 'LaunchTemplateConfigurationList$member' => NULL, ], ], 'LaunchTemplateConfigurationList' => [ 'base' => NULL, 'refs' => [ 'Distribution$launchTemplateConfigurations' => '<p>A group of launchTemplateConfiguration settings that apply to image distribution for specified accounts.</p>', ], ], 'LaunchTemplateId' => [ 'base' => NULL, 'refs' => [ 'FastLaunchLaunchTemplateSpecification$launchTemplateId' => '<p>The ID of the launch template to use for faster launching for a Windows AMI.</p>', 'LaunchTemplateConfiguration$launchTemplateId' => '<p>Identifies the Amazon EC2 launch template to use.</p>', ], ], 'LicenseConfigurationArn' => [ 'base' => NULL, 'refs' => [ 'LicenseConfigurationArnList$member' => NULL, ], ], 'LicenseConfigurationArnList' => [ 'base' => NULL, 'refs' => [ 'Distribution$licenseConfigurationArns' => '<p>The License Manager Configuration to associate with the AMI in the specified Region.</p>', ], ], 'LifecycleExecution' => [ 'base' => '<p>Contains metadata from a runtime instance of a lifecycle policy.</p>', 'refs' => [ 'GetLifecycleExecutionResponse$lifecycleExecution' => '<p>Runtime details for the specified runtime instance of the lifecycle policy.</p>', 'LifecycleExecutionsList$member' => NULL, ], ], 'LifecycleExecutionId' => [ 'base' => NULL, 'refs' => [ 'CancelLifecycleExecutionRequest$lifecycleExecutionId' => '<p>Identifies the specific runtime instance of the image lifecycle to cancel.</p>', 'CancelLifecycleExecutionResponse$lifecycleExecutionId' => '<p>The unique identifier for the image lifecycle runtime instance that was canceled.</p>', 'GetLifecycleExecutionRequest$lifecycleExecutionId' => '<p>Use the unique identifier for a runtime instance of the lifecycle policy to get runtime details.</p>', 'Image$lifecycleExecutionId' => '<p>Identifies the last runtime instance of the lifecycle policy to take action on the image.</p>', 'ImageSummary$lifecycleExecutionId' => '<p>Identifies the last runtime instance of the lifecycle policy to take action on the image.</p>', 'LifecycleExecution$lifecycleExecutionId' => '<p>Identifies the lifecycle policy runtime instance.</p>', 'ListLifecycleExecutionResourcesRequest$lifecycleExecutionId' => '<p>Use the unique identifier for a runtime instance of the lifecycle policy to get runtime details.</p>', 'ListLifecycleExecutionResourcesResponse$lifecycleExecutionId' => '<p>Runtime details for the specified runtime instance of the lifecycle policy.</p>', 'StartResourceStateUpdateResponse$lifecycleExecutionId' => '<p>Identifies the lifecycle runtime instance that started the resource state update.</p>', ], ], 'LifecycleExecutionResource' => [ 'base' => '<p>Contains details for a resource that the runtime instance of the lifecycle policy identified for action.</p>', 'refs' => [ 'LifecycleExecutionResourceList$member' => NULL, ], ], 'LifecycleExecutionResourceAction' => [ 'base' => '<p>The lifecycle policy action that was identified for the impacted resource.</p>', 'refs' => [ 'LifecycleExecutionResource$action' => '<p>The action to take for the identified resource.</p>', ], ], 'LifecycleExecutionResourceActionName' => [ 'base' => NULL, 'refs' => [ 'LifecycleExecutionResourceAction$name' => '<p>The name of the resource that was identified for a lifecycle policy action.</p>', ], ], 'LifecycleExecutionResourceList' => [ 'base' => NULL, 'refs' => [ 'ListLifecycleExecutionResourcesResponse$resources' => '<p>A list of resources that were identified for lifecycle actions.</p>', ], ], 'LifecycleExecutionResourceState' => [ 'base' => '<p>Contains the state of an impacted resource that the runtime instance of the lifecycle policy identified for action.</p>', 'refs' => [ 'LifecycleExecutionResource$state' => '<p>The runtime state for the lifecycle execution.</p>', 'LifecycleExecutionSnapshotResource$state' => '<p>The runtime status of the lifecycle action taken for the snapshot.</p>', ], ], 'LifecycleExecutionResourceStatus' => [ 'base' => NULL, 'refs' => [ 'LifecycleExecutionResourceState$status' => '<p>The runtime status of the lifecycle action taken for the impacted resource.</p>', ], ], 'LifecycleExecutionResourcesImpactedSummary' => [ 'base' => '<p>Contains details for an image resource that was identified for a lifecycle action.</p>', 'refs' => [ 'LifecycleExecution$resourcesImpactedSummary' => '<p>Contains information about associated resources that are identified for action by the runtime instance of the lifecycle policy.</p>', ], ], 'LifecycleExecutionSnapshotResource' => [ 'base' => '<p>Contains the state of an impacted snapshot resource that the runtime instance of the lifecycle policy identified for action.</p>', 'refs' => [ 'LifecycleExecutionSnapshotResourceList$member' => NULL, ], ], 'LifecycleExecutionSnapshotResourceList' => [ 'base' => NULL, 'refs' => [ 'LifecycleExecutionResource$snapshots' => '<p>A list of associated resource snapshots for the impacted resource if it’s an AMI.</p>', ], ], 'LifecycleExecutionState' => [ 'base' => '<p>The current state of the runtime instance of the lifecycle policy.</p>', 'refs' => [ 'LifecycleExecution$state' => '<p>Runtime state that reports if the policy action ran successfully, failed, or was skipped.</p>', 'ListLifecycleExecutionResourcesResponse$lifecycleExecutionState' => '<p>The current state of the lifecycle runtime instance.</p>', ], ], 'LifecycleExecutionStatus' => [ 'base' => NULL, 'refs' => [ 'LifecycleExecutionState$status' => '<p>The runtime status of the lifecycle execution.</p>', ], ], 'LifecycleExecutionsList' => [ 'base' => NULL, 'refs' => [ 'ListLifecycleExecutionsResponse$lifecycleExecutions' => '<p>A list of lifecycle runtime instances for the specified resource.</p>', ], ], 'LifecyclePolicy' => [ 'base' => '<p>The configuration details for a lifecycle policy resource.</p>', 'refs' => [ 'GetLifecyclePolicyResponse$lifecyclePolicy' => '<p>The ARN of the image lifecycle policy resource that was returned.</p>', ], ], 'LifecyclePolicyArn' => [ 'base' => NULL, 'refs' => [ 'CreateLifecyclePolicyResponse$lifecyclePolicyArn' => '<p>The Amazon Resource Name (ARN) of the lifecycle policy that the request created.</p>', 'DeleteLifecyclePolicyRequest$lifecyclePolicyArn' => '<p>The Amazon Resource Name (ARN) of the lifecycle policy resource to delete.</p>', 'DeleteLifecyclePolicyResponse$lifecyclePolicyArn' => '<p>The ARN of the lifecycle policy that was deleted.</p>', 'GetLifecyclePolicyRequest$lifecyclePolicyArn' => '<p>Specifies the Amazon Resource Name (ARN) of the image lifecycle policy resource to get.</p>', 'LifecycleExecution$lifecyclePolicyArn' => '<p>The Amazon Resource Name (ARN) of the lifecycle policy that ran.</p>', 'LifecyclePolicy$arn' => '<p>The Amazon Resource Name (ARN) of the lifecycle policy resource.</p>', 'LifecyclePolicySummary$arn' => '<p>The Amazon Resource Name (ARN) of the lifecycle policy summary resource.</p>', 'UpdateLifecyclePolicyRequest$lifecyclePolicyArn' => '<p>The Amazon Resource Name (ARN) of the lifecycle policy resource.</p>', 'UpdateLifecyclePolicyResponse$lifecyclePolicyArn' => '<p>The ARN of the image lifecycle policy resource that was updated.</p>', ], ], 'LifecyclePolicyDetail' => [ 'base' => '<p>The configuration details for a lifecycle policy resource.</p>', 'refs' => [ 'LifecyclePolicyDetails$member' => NULL, ], ], 'LifecyclePolicyDetailAction' => [ 'base' => '<p>Contains selection criteria for the lifecycle policy.</p>', 'refs' => [ 'LifecyclePolicyDetail$action' => '<p>Configuration details for the policy action.</p>', ], ], 'LifecyclePolicyDetailActionIncludeResources' => [ 'base' => '<p>Specifies how the lifecycle policy should apply actions to selected resources.</p>', 'refs' => [ 'LifecyclePolicyDetailAction$includeResources' => '<p>Specifies the resources that the lifecycle policy applies to.</p>', ], ], 'LifecyclePolicyDetailActionType' => [ 'base' => NULL, 'refs' => [ 'LifecyclePolicyDetailAction$type' => '<p>Specifies the lifecycle action to take.</p>', ], ], 'LifecyclePolicyDetailExclusionRules' => [ 'base' => '<p>Specifies resources that lifecycle policy actions should not apply to.</p>', 'refs' => [ 'LifecyclePolicyDetail$exclusionRules' => '<p>Additional rules to specify resources that should be exempt from policy actions.</p>', ], ], 'LifecyclePolicyDetailExclusionRulesAmis' => [ 'base' => '<p>Defines criteria for AMIs that are excluded from lifecycle actions.</p>', 'refs' => [ 'LifecyclePolicyDetailExclusionRules$amis' => '<p>Lists configuration values that apply to AMIs that Image Builder should exclude from the lifecycle action.</p>', 'ResourceStateUpdateExclusionRules$amis' => NULL, ], ], 'LifecyclePolicyDetailExclusionRulesAmisLastLaunched' => [ 'base' => '<p>Defines criteria to exclude AMIs from lifecycle actions based on the last time they were used to launch an instance.</p>', 'refs' => [ 'LifecyclePolicyDetailExclusionRulesAmis$lastLaunched' => '<p>Specifies configuration details for Image Builder to exclude the most recent resources from lifecycle actions.</p>', ], ], 'LifecyclePolicyDetailExclusionRulesAmisLastLaunchedValue' => [ 'base' => NULL, 'refs' => [ 'LifecyclePolicyDetailExclusionRulesAmisLastLaunched$value' => '<p>The integer number of units for the time period. For example <code>6</code> (months).</p>', ], ], 'LifecyclePolicyDetailFilter' => [ 'base' => '<p>Defines filters that the lifecycle policy uses to determine impacted resource.</p>', 'refs' => [ 'LifecyclePolicyDetail$filter' => '<p>Specifies the resources that the lifecycle policy applies to.</p>', ], ], 'LifecyclePolicyDetailFilterRetainAtLeast' => [ 'base' => NULL, 'refs' => [ 'LifecyclePolicyDetailFilter$retainAtLeast' => '<p>For age-based filters, this is the number of resources to keep on hand after the lifecycle <code>DELETE</code> action is applied. Impacted resources are only deleted if you have more than this number of resources. If you have fewer resources than this number, the impacted resource is not deleted.</p>', ], ], 'LifecyclePolicyDetailFilterType' => [ 'base' => NULL, 'refs' => [ 'LifecyclePolicyDetailFilter$type' => '<p>Filter resources based on either <code>age</code> or <code>count</code>.</p>', ], ], 'LifecyclePolicyDetailFilterValue' => [ 'base' => NULL, 'refs' => [ 'LifecyclePolicyDetailFilter$value' => '<p>The number of units for the time period or for the count. For example, a value of <code>6</code> might refer to six months or six AMIs.</p> <note> <p>For count-based filters, this value represents the minimum number of resources to keep on hand. If you have fewer resources than this number, the resource is excluded from lifecycle actions.</p> </note>', ], ], 'LifecyclePolicyDetails' => [ 'base' => NULL, 'refs' => [ 'CreateLifecyclePolicyRequest$policyDetails' => '<p>Configuration details for the lifecycle policy rules.</p>', 'LifecyclePolicy$policyDetails' => '<p>The configuration details for a lifecycle policy resource.</p>', 'UpdateLifecyclePolicyRequest$policyDetails' => '<p>The configuration details for a lifecycle policy resource.</p>', ], ], 'LifecyclePolicyResourceSelection' => [ 'base' => '<p>Resource selection criteria for the lifecycle policy.</p>', 'refs' => [ 'CreateLifecyclePolicyRequest$resourceSelection' => '<p>Selection criteria for the resources that the lifecycle policy applies to. </p>', 'LifecyclePolicy$resourceSelection' => '<p>Resource selection criteria used to run the lifecycle policy.</p>', 'UpdateLifecyclePolicyRequest$resourceSelection' => '<p>Selection criteria for resources that the lifecycle policy applies to.</p>', ], ], 'LifecyclePolicyResourceSelectionRecipe' => [ 'base' => '<p>Specifies an Image Builder recipe that the lifecycle policy uses for resource selection.</p>', 'refs' => [ 'LifecyclePolicyResourceSelectionRecipes$member' => NULL, ], ], 'LifecyclePolicyResourceSelectionRecipes' => [ 'base' => NULL, 'refs' => [ 'LifecyclePolicyResourceSelection$recipes' => '<p>A list of recipes that are used as selection criteria for the output images that the lifecycle policy applies to.</p>', ], ], 'LifecyclePolicyResourceType' => [ 'base' => NULL, 'refs' => [ 'CreateLifecyclePolicyRequest$resourceType' => '<p>The type of Image Builder resource that the lifecycle policy applies to.</p>', 'LifecyclePolicy$resourceType' => '<p>The type of resources the lifecycle policy targets.</p>', 'LifecyclePolicySummary$resourceType' => '<p>The type of resources the lifecycle policy targets.</p>', 'UpdateLifecyclePolicyRequest$resourceType' => '<p>The type of image resource that the lifecycle policy applies to.</p>', ], ], 'LifecyclePolicyStatus' => [ 'base' => NULL, 'refs' => [ 'CreateLifecyclePolicyRequest$status' => '<p>Indicates whether the lifecycle policy resource is enabled.</p>', 'LifecyclePolicy$status' => '<p>Indicates whether the lifecycle policy resource is enabled.</p>', 'LifecyclePolicySummary$status' => '<p>The lifecycle policy resource status.</p>', 'UpdateLifecyclePolicyRequest$status' => '<p>Indicates whether the lifecycle policy resource is enabled.</p>', ], ], 'LifecyclePolicySummary' => [ 'base' => '<p>Contains a summary of lifecycle policy resources.</p>', 'refs' => [ 'LifecyclePolicySummaryList$member' => NULL, ], ], 'LifecyclePolicySummaryList' => [ 'base' => NULL, 'refs' => [ 'ListLifecyclePoliciesResponse$lifecyclePolicySummaryList' => '<p>A list of lifecycle policies in your Amazon Web Services account that meet the criteria specified in the request.</p>', ], ], 'LifecyclePolicyTimeUnit' => [ 'base' => NULL, 'refs' => [ 'LifecyclePolicyDetailExclusionRulesAmisLastLaunched$unit' => '<p>Defines the unit of time that the lifecycle policy uses to calculate elapsed time since the last instance launched from the AMI. For example: days, weeks, months, or years.</p>', 'LifecyclePolicyDetailFilter$unit' => '<p>Defines the unit of time that the lifecycle policy uses to determine impacted resources. This is required for age-based rules.</p>', ], ], 'ListComponentBuildVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListComponentBuildVersionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListComponentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListComponentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListContainerRecipesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListContainerRecipesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDistributionConfigurationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDistributionConfigurationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListImageBuildVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListImageBuildVersionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListImagePackagesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListImagePackagesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListImagePipelineImagesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListImagePipelineImagesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListImagePipelinesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListImagePipelinesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListImageRecipesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListImageRecipesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListImageScanFindingAggregationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListImageScanFindingAggregationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListImageScanFindingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListImageScanFindingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListImagesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListImagesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListInfrastructureConfigurationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListInfrastructureConfigurationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListLifecycleExecutionResourcesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListLifecycleExecutionResourcesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListLifecycleExecutionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListLifecycleExecutionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListLifecyclePoliciesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListLifecyclePoliciesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListWaitingWorkflowStepsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListWaitingWorkflowStepsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkflowBuildVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkflowBuildVersionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkflowExecutionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkflowExecutionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkflowStepExecutionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkflowStepExecutionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkflowsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkflowsResponse' => [ 'base' => NULL, 'refs' => [], ], 'Logging' => [ 'base' => '<p>Logging configuration defines where Image Builder uploads your logs.</p>', 'refs' => [ 'CreateInfrastructureConfigurationRequest$logging' => '<p>The logging configuration of the infrastructure configuration.</p>', 'InfrastructureConfiguration$logging' => '<p>The logging configuration of the infrastructure configuration.</p>', 'UpdateInfrastructureConfigurationRequest$logging' => '<p>The logging configuration of the infrastructure configuration.</p>', ], ], 'MaxParallelLaunches' => [ 'base' => NULL, 'refs' => [ 'FastLaunchConfiguration$maxParallelLaunches' => '<p>The maximum number of parallel instances that are launched for creating resources.</p>', ], ], 'NonEmptyString' => [ 'base' => NULL, 'refs' => [ 'AccountAggregation$accountId' => '<p>Identifies the account that owns the aggregated resource findings.</p>', 'Ami$region' => '<p>The Amazon Web Services Region of the Amazon EC2 AMI.</p>', 'Ami$image' => '<p>The AMI ID of the Amazon EC2 AMI.</p>', 'Ami$name' => '<p>The name of the Amazon EC2 AMI.</p>', 'Ami$description' => '<p>The description of the Amazon EC2 AMI. Minimum and maximum length are in characters.</p>', 'Ami$accountId' => '<p>The account ID of the owner of the AMI.</p>', 'AmiDistributionConfiguration$description' => '<p>The description of the AMI distribution configuration. Minimum and maximum length are in characters.</p>', 'AmiDistributionConfiguration$kmsKeyId' => '<p>The KMS key identifier used to encrypt the distributed image.</p>', 'CancelImageCreationResponse$requestId' => '<p>The request ID that uniquely identifies this request.</p>', 'Component$description' => '<p>The description of the component.</p>', 'Component$changeDescription' => '<p>Describes what change has been made in this version of the component, or what makes this version different from other versions of the component.</p>', 'Component$owner' => '<p>The owner of the component.</p>', 'Component$kmsKeyId' => '<p>The KMS key identifier used to encrypt the component.</p>', 'Component$publisher' => '<p>Contains the name of the publisher if this is a third-party component. Otherwise, this property is empty.</p>', 'ComponentState$reason' => '<p>Describes how or why the component changed state.</p>', 'ComponentSummary$owner' => '<p>The owner of the component.</p>', 'ComponentSummary$description' => '<p>The description of the component.</p>', 'ComponentSummary$changeDescription' => '<p>The change description for the current version of the component.</p>', 'ComponentSummary$publisher' => '<p>Contains the name of the publisher if this is a third-party component. Otherwise, this property is empty.</p>', 'ComponentVersion$description' => '<p>The description of the component.</p>', 'ComponentVersion$owner' => '<p>The owner of the component.</p>', 'Container$region' => '<p>Containers and container images are Region-specific. This is the Region context for the container.</p>', 'ContainerDistributionConfiguration$description' => '<p>The description of the container distribution configuration.</p>', 'ContainerRecipe$description' => '<p>The description of the container recipe.</p>', 'ContainerRecipe$owner' => '<p>The owner of the container recipe.</p>', 'ContainerRecipe$kmsKeyId' => '<p>Identifies which KMS key is used to encrypt the container image for distribution to the target Region.</p>', 'ContainerRecipe$parentImage' => '<p>The base image for the container recipe.</p>', 'ContainerRecipe$workingDirectory' => '<p>The working directory for use during build and test workflows.</p>', 'ContainerRecipeSummary$owner' => '<p>The owner of the container recipe.</p>', 'ContainerRecipeSummary$parentImage' => '<p>The base image for the container recipe.</p>', 'CreateComponentRequest$description' => '<p>Describes the contents of the component.</p>', 'CreateComponentRequest$changeDescription' => '<p>The change description of the component. Describes what change has been made in this version, or what makes this version different from other versions of the component.</p>', 'CreateComponentRequest$kmsKeyId' => '<p>The ID of the KMS key that is used to encrypt this component.</p>', 'CreateComponentResponse$requestId' => '<p>The request ID that uniquely identifies this request.</p>', 'CreateContainerRecipeRequest$description' => '<p>The description of the container recipe.</p>', 'CreateContainerRecipeRequest$imageOsVersionOverride' => '<p>Specifies the operating system version for the base image.</p>', 'CreateContainerRecipeRequest$parentImage' => '<p>The base image for the container recipe.</p>', 'CreateContainerRecipeRequest$workingDirectory' => '<p>The working directory for use during build and test workflows.</p>', 'CreateContainerRecipeRequest$kmsKeyId' => '<p>Identifies which KMS key is used to encrypt the container image.</p>', 'CreateContainerRecipeResponse$requestId' => '<p>The request ID that uniquely identifies this request.</p>', 'CreateDistributionConfigurationRequest$description' => '<p>The description of the distribution configuration.</p>', 'CreateDistributionConfigurationResponse$requestId' => '<p>The request ID that uniquely identifies this request.</p>', 'CreateImagePipelineRequest$description' => '<p>The description of the image pipeline.</p>', 'CreateImagePipelineResponse$requestId' => '<p>The request ID that uniquely identifies this request.</p>', 'CreateImageRecipeRequest$description' => '<p>The description of the image recipe.</p>', 'CreateImageRecipeRequest$parentImage' => '<p>The base image of the image recipe. The value of the string can be the ARN of the base image or an AMI ID. The format for the ARN follows this example: <code>arn:aws:imagebuilder:us-west-2:aws:image/windows-server-2016-english-full-base-x86/x.x.x</code>. You can provide the specific version that you want to use, or you can use a wildcard in all of the fields. If you enter an AMI ID for the string value, you must have access to the AMI, and the AMI must be in the same Region in which you are using Image Builder.</p>', 'CreateImageRecipeRequest$workingDirectory' => '<p>The working directory used during build and test workflows.</p>', 'CreateImageRecipeResponse$requestId' => '<p>The request ID that uniquely identifies this request.</p>', 'CreateImageResponse$requestId' => '<p>The request ID that uniquely identifies this request.</p>', 'CreateInfrastructureConfigurationRequest$description' => '<p>The description of the infrastructure configuration.</p>', 'CreateInfrastructureConfigurationRequest$subnetId' => '<p>The subnet ID in which to place the instance used to customize your Amazon EC2 AMI.</p>', 'CreateInfrastructureConfigurationRequest$keyPair' => '<p>The key pair of the infrastructure configuration. You can use this to log on to and debug the instance used to create your image.</p>', 'CreateInfrastructureConfigurationResponse$requestId' => '<p>The request ID that uniquely identifies this request.</p>', 'CreateLifecyclePolicyRequest$description' => '<p>Optional description for the lifecycle policy.</p>', 'CreateWorkflowRequest$description' => '<p>Describes the workflow.</p>', 'CreateWorkflowRequest$changeDescription' => '<p>Describes what change has been made in this version of the workflow, or what makes this version different from other versions of the workflow.</p>', 'CreateWorkflowRequest$kmsKeyId' => '<p>The ID of the KMS key that is used to encrypt this workflow resource.</p>', 'CvssScore$scoringVector' => '<p>The vector string of the CVSS score.</p>', 'CvssScore$version' => '<p>The CVSS version that generated the score.</p>', 'CvssScore$source' => '<p>The source of the CVSS score.</p>', 'CvssScoreAdjustment$metric' => '<p>The metric that Amazon Inspector used to adjust the CVSS score.</p>', 'CvssScoreAdjustment$reason' => '<p>The reason for the CVSS score adjustment.</p>', 'CvssScoreDetails$scoreSource' => '<p>The source for the CVSS score.</p>', 'CvssScoreDetails$cvssSource' => '<p>The source of the finding.</p>', 'CvssScoreDetails$version' => '<p>The CVSS version that generated the score.</p>', 'CvssScoreDetails$scoringVector' => '<p>A vector that measures the severity of the vulnerability.</p>', 'DeleteComponentResponse$requestId' => '<p>The request ID that uniquely identifies this request.</p>', 'DeleteContainerRecipeResponse$requestId' => '<p>The request ID that uniquely identifies this request.</p>', 'DeleteDistributionConfigurationResponse$requestId' => '<p>The request ID that uniquely identifies this request.</p>', 'DeleteImagePipelineResponse$requestId' => '<p>The request ID that uniquely identifies this request.</p>', 'DeleteImageRecipeResponse$requestId' => '<p>The request ID that uniquely identifies this request.</p>', 'DeleteImageResponse$requestId' => '<p>The request ID that uniquely identifies this request.</p>', 'DeleteInfrastructureConfigurationResponse$requestId' => '<p>The request ID that uniquely identifies this request.</p>', 'Distribution$region' => '<p>The target Region.</p>', 'DistributionConfiguration$description' => '<p>The description of the distribution configuration.</p>', 'DistributionConfigurationSummary$description' => '<p>The description of the distribution configuration.</p>', 'EbsInstanceBlockDeviceSpecification$kmsKeyId' => '<p>Use to configure the KMS key to use when encrypting the device.</p>', 'EbsInstanceBlockDeviceSpecification$snapshotId' => '<p>The snapshot that defines the device contents.</p>', 'EcrConfiguration$repositoryName' => '<p>The name of the container repository that Amazon Inspector scans to identify findings for your container images. The name includes the path for the repository location. If you don’t provide this information, Image Builder creates a repository in your account named <code>image-builder-image-scanning-repository</code> for vulnerability scans of your output container images.</p>', 'FastLaunchLaunchTemplateSpecification$launchTemplateName' => '<p>The name of the launch template to use for faster launching for a Windows AMI.</p>', 'FastLaunchLaunchTemplateSpecification$launchTemplateVersion' => '<p>The version of the launch template to use for faster launching for a Windows AMI.</p>', 'GetComponentPolicyResponse$requestId' => '<p>The request ID that uniquely identifies this request.</p>', 'GetComponentResponse$requestId' => '<p>The request ID that uniquely identifies this request.</p>', 'GetContainerRecipePolicyResponse$requestId' => '<p>The request ID that uniquely identifies this request.</p>', 'GetContainerRecipeResponse$requestId' => '<p>The request ID that uniquely identifies this request.</p>', 'GetDistributionConfigurationResponse$requestId' => '<p>The request ID that uniquely identifies this request.</p>', 'GetImagePipelineResponse$requestId' => '<p>The request ID that uniquely identifies this request.</p>', 'GetImagePolicyResponse$requestId' => '<p>The request ID that uniquely identifies this request.</p>', 'GetImageRecipePolicyResponse$requestId' => '<p>The request ID that uniquely identifies this request.</p>', 'GetImageRecipeResponse$requestId' => '<p>The request ID that uniquely identifies this request.</p>', 'GetImageResponse$requestId' => '<p>The request ID that uniquely identifies this request.</p>', 'GetInfrastructureConfigurationResponse$requestId' => '<p>The request ID that uniquely identifies this request.</p>', 'GetWorkflowExecutionResponse$requestId' => '<p>The request ID that uniquely identifies this request.</p>', 'GetWorkflowStepExecutionResponse$requestId' => '<p>The request ID that uniquely identifies this request.</p>', 'GetWorkflowStepExecutionResponse$onFailure' => '<p>The action to perform if the workflow step fails.</p>', 'ImagePackage$packageName' => '<p>The name of the package as reported to the operating system package manager.</p>', 'ImagePackage$packageVersion' => '<p>The version of the package as reported to the operating system package manager.</p>', 'ImagePipeline$description' => '<p>The description of the image pipeline.</p>', 'ImageRecipe$description' => '<p>The description of the image recipe.</p>', 'ImageRecipe$owner' => '<p>The owner of the image recipe.</p>', 'ImageRecipe$parentImage' => '<p>The base image of the image recipe.</p>', 'ImageRecipe$workingDirectory' => '<p>The working directory to be used during build and test workflows.</p>', 'ImageRecipeSummary$owner' => '<p>The owner of the image recipe.</p>', 'ImageRecipeSummary$parentImage' => '<p>The base image of the image recipe.</p>', 'ImageScanFinding$awsAccountId' => '<p>The Amazon Web Services account ID that\'s associated with the finding.</p>', 'ImageScanFinding$type' => '<p>The type of the finding. Image Builder looks for findings of the type <code>PACKAGE_VULNERABILITY</code> that apply to output images, and excludes other types.</p>', 'ImageScanFinding$description' => '<p>The description of the finding.</p>', 'ImageScanFinding$title' => '<p>The title of the finding.</p>', 'ImageScanFinding$severity' => '<p>The severity of the finding.</p>', 'ImageScanFinding$fixAvailable' => '<p>Details about whether a fix is available for any of the packages that are identified in the finding through a version update.</p>', 'ImageScanState$reason' => '<p>The reason for the scan status for the image.</p>', 'ImageState$reason' => '<p>The reason for the status of the image.</p>', 'ImageSummary$owner' => '<p>The owner of the image.</p>', 'ImageVersion$owner' => '<p>The owner of the image version.</p>', 'ImportComponentRequest$description' => '<p>The description of the component. Describes the contents of the component.</p>', 'ImportComponentRequest$changeDescription' => '<p>The change description of the component. This description indicates the change that has been made in this version, or what makes this version different from other versions of the component.</p>', 'ImportComponentRequest$data' => '<p>The data of the component. Used to specify the data inline. Either <code>data</code> or <code>uri</code> can be used to specify the data within the component.</p>', 'ImportComponentRequest$kmsKeyId' => '<p>The ID of the KMS key that should be used to encrypt this component.</p>', 'ImportComponentResponse$requestId' => '<p>The request ID that uniquely identifies this request.</p>', 'ImportVmImageRequest$name' => '<p>The name of the base image that is created by the import process.</p>', 'ImportVmImageRequest$description' => '<p>The description for the base image that is created by the import process.</p>', 'ImportVmImageRequest$vmImportTaskId' => '<p>The <code>importTaskId</code> (API) or <code>ImportTaskId</code> (CLI) from the Amazon EC2 VM import process. Image Builder retrieves information from the import process to pull in the AMI that is created from the VM source as the base image for your recipe.</p>', 'ImportVmImageResponse$requestId' => '<p>The request ID that uniquely identifies this request.</p>', 'InfrastructureConfiguration$description' => '<p>The description of the infrastructure configuration.</p>', 'InfrastructureConfiguration$subnetId' => '<p>The subnet ID of the infrastructure configuration.</p>', 'InfrastructureConfiguration$keyPair' => '<p>The Amazon EC2 key pair of the infrastructure configuration.</p>', 'InfrastructureConfiguration$snsTopicArn' => '<p>The Amazon Resource Name (ARN) for the SNS topic to which we send image build event notifications.</p> <note> <p>EC2 Image Builder is unable to send notifications to SNS topics that are encrypted using keys from other accounts. The key that is used to encrypt the SNS topic must reside in the account that the Image Builder service runs under.</p> </note>', 'InfrastructureConfigurationSummary$description' => '<p>The description of the infrastructure configuration.</p>', 'InstanceBlockDeviceMapping$deviceName' => '<p>The device to which these mappings apply.</p>', 'InstanceBlockDeviceMapping$virtualName' => '<p>Use to manage instance ephemeral devices.</p>', 'InstanceConfiguration$image' => '<p>The AMI ID to use as the base image for a container build and test instance. If not specified, Image Builder will use the appropriate ECS-optimized AMI as a base image.</p>', 'LifecycleExecutionResource$accountId' => '<p>The account that owns the impacted resource.</p>', 'LifecycleExecutionResource$resourceId' => '<p>Identifies the impacted resource. The resource ID depends on the type of resource, as follows.</p> <ul> <li> <p>Image Builder image resources: Amazon Resource Name (ARN)</p> </li> <li> <p>Distributed AMIs: AMI ID</p> </li> <li> <p>Container images distributed to an ECR repository: image URI or SHA Digest</p> </li> </ul>', 'LifecycleExecutionResource$region' => '<p>The Amazon Web Services Region where the lifecycle execution resource is stored.</p>', 'LifecycleExecutionResourceAction$reason' => '<p>The reason why the lifecycle policy action is taken.</p>', 'LifecycleExecutionResourceState$reason' => '<p>Messaging that clarifies the reason for the assigned status.</p>', 'LifecycleExecutionSnapshotResource$snapshotId' => '<p>Identifies the impacted snapshot resource.</p>', 'LifecycleExecutionState$reason' => '<p>The reason for the current status.</p>', 'LifecyclePolicy$description' => '<p>Optional description for the lifecycle policy.</p>', 'LifecyclePolicySummary$description' => '<p>Optional description for the lifecycle policy.</p>', 'ListComponentBuildVersionsResponse$requestId' => '<p>The request ID that uniquely identifies this request.</p>', 'ListComponentsResponse$requestId' => '<p>The request ID that uniquely identifies this request.</p>', 'ListContainerRecipesRequest$nextToken' => '<p>A token to specify where to start paginating. This is the nextToken from a previously truncated response.</p>', 'ListContainerRecipesResponse$requestId' => '<p>The request ID that uniquely identifies this request.</p>', 'ListContainerRecipesResponse$nextToken' => '<p>The next token used for paginated responses. When this field isn\'t empty, there are additional elements that the service hasn\'t included in this request. Use this token with the next request to retrieve additional objects.</p>', 'ListDistributionConfigurationsResponse$requestId' => '<p>The request ID that uniquely identifies this request.</p>', 'ListImageBuildVersionsResponse$requestId' => '<p>The request ID that uniquely identifies this request.</p>', 'ListImagePackagesResponse$requestId' => '<p>The request ID that uniquely identifies this request.</p>', 'ListImagePipelineImagesResponse$requestId' => '<p>The request ID that uniquely identifies this request.</p>', 'ListImagePipelinesResponse$requestId' => '<p>The request ID that uniquely identifies this request.</p>', 'ListImageRecipesResponse$requestId' => '<p>The request ID that uniquely identifies this request.</p>', 'ListImageScanFindingAggregationsResponse$requestId' => '<p>The request ID that uniquely identifies this request.</p>', 'ListImageScanFindingAggregationsResponse$aggregationType' => '<p>The aggregation type specifies what type of key is used to group the image scan findings. Image Builder returns results based on the request filter. If you didn\'t specify a filter in the request, the type defaults to <code>accountId</code>.</p> <p class="title"> <b>Aggregation types</b> </p> <ul> <li> <p>accountId</p> </li> <li> <p>imageBuildVersionArn</p> </li> <li> <p>imagePipelineArn</p> </li> <li> <p>vulnerabilityId</p> </li> </ul> <p>Each aggregation includes counts by severity level for medium severity and higher level findings, plus a total for all of the findings for each key value.</p>', 'ListImageScanFindingsResponse$requestId' => '<p>The request ID that uniquely identifies this request.</p>', 'ListImagesResponse$requestId' => '<p>The request ID that uniquely identifies this request.</p>', 'ListInfrastructureConfigurationsResponse$requestId' => '<p>The request ID that uniquely identifies this request.</p>', 'ListLifecycleExecutionResourcesRequest$parentResourceId' => '<p>You can leave this empty to get a list of Image Builder resources that were identified for lifecycle actions.</p> <p>To get a list of associated resources that are impacted for an individual resource (the parent), specify its Amazon Resource Name (ARN). Associated resources are produced from your image and distributed when you run a build, such as AMIs or container images stored in ECR repositories.</p>', 'ListWorkflowExecutionsResponse$requestId' => '<p>The request ID that uniquely identifies this request.</p>', 'ListWorkflowStepExecutionsResponse$requestId' => '<p>The request ID that uniquely identifies this request.</p>', 'NonEmptyStringList$member' => NULL, 'PackageVulnerabilityDetails$source' => '<p>The source of the vulnerability information.</p>', 'PackageVulnerabilityDetails$sourceUrl' => '<p>A link to the source of the vulnerability information.</p>', 'PackageVulnerabilityDetails$vendorSeverity' => '<p>The severity that the vendor assigned to this vulnerability type.</p>', 'PutComponentPolicyResponse$requestId' => '<p>The request ID that uniquely identifies this request.</p>', 'PutContainerRecipePolicyResponse$requestId' => '<p>The request ID that uniquely identifies this request.</p>', 'PutImagePolicyResponse$requestId' => '<p>The request ID that uniquely identifies this request.</p>', 'PutImageRecipePolicyResponse$requestId' => '<p>The request ID that uniquely identifies this request.</p>', 'RegionList$member' => NULL, 'RemediationRecommendation$text' => '<p>The recommended course of action to remediate the finding.</p>', 'RemediationRecommendation$url' => '<p>A link to more information about the recommended remediation for this vulnerability.</p>', 'S3ExportConfiguration$roleName' => '<p>The name of the role that grants VM Import/Export permission to export images to your S3 bucket.</p>', 'S3ExportConfiguration$s3Bucket' => '<p>The S3 bucket in which to store the output disk images for your VM.</p>', 'S3ExportConfiguration$s3Prefix' => '<p>The Amazon S3 path for the bucket where the output disk images for your VM are stored.</p>', 'S3Logs$s3BucketName' => '<p>The S3 bucket in which to store the logs.</p>', 'S3Logs$s3KeyPrefix' => '<p>The Amazon S3 path to the bucket where the logs are stored.</p>', 'Schedule$scheduleExpression' => '<p>The cron expression determines how often EC2 Image Builder evaluates your <code>pipelineExecutionStartCondition</code>.</p> <p>For information on how to format a cron expression in Image Builder, see <a href="https://docs.aws.amazon.com/imagebuilder/latest/userguide/image-builder-cron.html">Use cron expressions in EC2 Image Builder</a>.</p>', 'SecurityGroupIds$member' => NULL, 'SendWorkflowStepActionRequest$reason' => '<p>The reason why this action is sent.</p>', 'StartImagePipelineExecutionResponse$requestId' => '<p>The request ID that uniquely identifies this request.</p>', 'StringList$member' => NULL, 'TargetContainerRepository$repositoryName' => '<p>The name of the container repository where the output container image is stored. This name is prefixed by the repository location.</p>', 'UpdateDistributionConfigurationRequest$description' => '<p>The description of the distribution configuration.</p>', 'UpdateDistributionConfigurationResponse$requestId' => '<p>The request ID that uniquely identifies this request.</p>', 'UpdateImagePipelineRequest$description' => '<p>The description of the image pipeline.</p>', 'UpdateImagePipelineResponse$requestId' => '<p>The request ID that uniquely identifies this request.</p>', 'UpdateInfrastructureConfigurationRequest$description' => '<p>The description of the infrastructure configuration.</p>', 'UpdateInfrastructureConfigurationRequest$subnetId' => '<p>The subnet ID to place the instance used to customize your Amazon EC2 AMI in.</p>', 'UpdateInfrastructureConfigurationRequest$keyPair' => '<p>The key pair of the infrastructure configuration. You can use this to log on to and debug the instance used to create your image.</p>', 'UpdateInfrastructureConfigurationResponse$requestId' => '<p>The request ID that uniquely identifies this request.</p>', 'UpdateLifecyclePolicyRequest$description' => '<p>Optional description for the lifecycle policy.</p>', 'VulnerabilityIdAggregation$vulnerabilityId' => '<p>The vulnerability Id for this set of counts.</p>', 'VulnerablePackage$name' => '<p>The name of the vulnerable package.</p>', 'VulnerablePackage$version' => '<p>The version of the vulnerable package.</p>', 'VulnerablePackage$release' => '<p>The release of the vulnerable package.</p>', 'VulnerablePackage$packageManager' => '<p>The package manager of the vulnerable package.</p>', 'VulnerablePackage$filePath' => '<p>The file path of the vulnerable package.</p>', 'VulnerablePackage$fixedInVersion' => '<p>The version of the package that contains the vulnerability fix.</p>', 'VulnerablePackage$remediation' => '<p>The code to run in your environment to update packages with a fix available.</p>', 'Workflow$description' => '<p>The description of the workflow.</p>', 'Workflow$changeDescription' => '<p>Describes what change has been made in this version of the workflow, or what makes this version different from other versions of the workflow.</p>', 'Workflow$owner' => '<p>The owner of the workflow resource.</p>', 'Workflow$kmsKeyId' => '<p>The KMS key identifier used to encrypt the workflow resource.</p>', 'WorkflowState$reason' => '<p>Describes how or why the workflow changed state.</p>', 'WorkflowSummary$description' => '<p>Describes the workflow.</p>', 'WorkflowSummary$changeDescription' => '<p>The change description for the current version of the workflow resource.</p>', 'WorkflowSummary$owner' => '<p>The owner of the workflow resource.</p>', 'WorkflowVersion$description' => '<p>Describes the workflow.</p>', 'WorkflowVersion$owner' => '<p>The owner of the workflow resource.</p>', ], ], 'NonEmptyStringList' => [ 'base' => NULL, 'refs' => [ 'PackageVulnerabilityDetails$referenceUrls' => '<p>Links to web pages that contain details about the vulnerabilities that Amazon Inspector identified for the package.</p>', ], ], 'NonNegativeDouble' => [ 'base' => NULL, 'refs' => [ 'CvssScore$baseScore' => '<p>The CVSS base score.</p>', 'CvssScoreDetails$score' => '<p>The CVSS score.</p>', 'ImageScanFinding$inspectorScore' => '<p>The score that Amazon Inspector assigned for the finding.</p>', ], ], 'NullableBoolean' => [ 'base' => NULL, 'refs' => [ 'Component$encrypted' => '<p>The encryption status of the component.</p>', 'ContainerRecipe$encrypted' => '<p>A flag that indicates if the target container is encrypted.</p>', 'CreateImagePipelineRequest$enhancedImageMetadataEnabled' => '<p>Collects additional information about the image being created, including the operating system (OS) version and package list. This information is used to enhance the overall experience of using EC2 Image Builder. Enabled by default.</p>', 'CreateImageRequest$enhancedImageMetadataEnabled' => '<p>Collects additional information about the image being created, including the operating system (OS) version and package list. This information is used to enhance the overall experience of using EC2 Image Builder. Enabled by default.</p>', 'CreateInfrastructureConfigurationRequest$terminateInstanceOnFailure' => '<p>The terminate instance on failure setting of the infrastructure configuration. Set to false if you want Image Builder to retain the instance used to configure your AMI if the build or test phase of your workflow fails.</p>', 'EbsInstanceBlockDeviceSpecification$encrypted' => '<p>Use to configure device encryption.</p>', 'EbsInstanceBlockDeviceSpecification$deleteOnTermination' => '<p>Use to configure delete on termination of the associated device.</p>', 'Image$enhancedImageMetadataEnabled' => '<p>Indicates whether Image Builder collects additional information about the image, such as the operating system (OS) version and package list.</p>', 'ImagePipeline$enhancedImageMetadataEnabled' => '<p>Collects additional information about the image being created, including the operating system (OS) version and package list. This information is used to enhance the overall experience of using EC2 Image Builder. Enabled by default.</p>', 'ImageScanningConfiguration$imageScanningEnabled' => '<p>A setting that indicates whether Image Builder keeps a snapshot of the vulnerability scans that Amazon Inspector runs against the build instance when you create a new image.</p>', 'ImageTestsConfiguration$imageTestsEnabled' => '<p>Determines if tests should run after building the image. Image Builder defaults to enable tests to run following the image build, before image distribution.</p>', 'InfrastructureConfiguration$terminateInstanceOnFailure' => '<p>The terminate instance on failure configuration of the infrastructure configuration.</p>', 'ListImagesRequest$includeDeprecated' => '<p>Includes deprecated images in the response list.</p>', 'SystemsManagerAgent$uninstallAfterBuild' => '<p>Controls whether the Systems Manager agent is removed from your final build image, prior to creating the new AMI. If this is set to true, then the agent is removed from the final image. If it\'s set to false, then the agent is left in, so that it is included in the new AMI. The default value is false.</p>', 'UpdateImagePipelineRequest$enhancedImageMetadataEnabled' => '<p>Collects additional information about the image being created, including the operating system (OS) version and package list. This information is used to enhance the overall experience of using EC2 Image Builder. Enabled by default.</p>', 'UpdateInfrastructureConfigurationRequest$terminateInstanceOnFailure' => '<p>The terminate instance on failure setting of the infrastructure configuration. Set to false if you want Image Builder to retain the instance used to configure your AMI if the build or test phase of your workflow fails.</p>', ], ], 'OnWorkflowFailure' => [ 'base' => NULL, 'refs' => [ 'WorkflowConfiguration$onFailure' => '<p>The action to take if the workflow fails.</p>', ], ], 'OrganizationArn' => [ 'base' => NULL, 'refs' => [ 'OrganizationArnList$member' => NULL, ], ], 'OrganizationArnList' => [ 'base' => NULL, 'refs' => [ 'LaunchPermissionConfiguration$organizationArns' => '<p>The ARN for an Amazon Web Services Organization that you want to share your AMI with. For more information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_introduction.html">What is Organizations?</a>.</p>', ], ], 'OrganizationalUnitArn' => [ 'base' => NULL, 'refs' => [ 'OrganizationalUnitArnList$member' => NULL, ], ], 'OrganizationalUnitArnList' => [ 'base' => NULL, 'refs' => [ 'LaunchPermissionConfiguration$organizationalUnitArns' => '<p>The ARN for an Organizations organizational unit (OU) that you want to share your AMI with. For more information about key concepts for Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html">Organizations terminology and concepts</a>.</p>', ], ], 'OsVersion' => [ 'base' => NULL, 'refs' => [ 'Image$osVersion' => '<p>The operating system version for instances that launch from this image. For example, Amazon Linux 2, Ubuntu 18, or Microsoft Windows Server 2019.</p>', 'ImageSummary$osVersion' => '<p>The operating system version of the instances that launch from this image. For example, Amazon Linux 2, Ubuntu 18, or Microsoft Windows Server 2019.</p>', 'ImageVersion$osVersion' => '<p>The operating system version of the Amazon EC2 build instance. For example, Amazon Linux 2, Ubuntu 18, or Microsoft Windows Server 2019.</p>', 'ImportVmImageRequest$osVersion' => '<p>The operating system version for the imported VM.</p>', 'OsVersionList$member' => NULL, ], ], 'OsVersionList' => [ 'base' => NULL, 'refs' => [ 'Component$supportedOsVersions' => '<p>The operating system (OS) version supported by the component. If the OS information is available, Image Builder performs a prefix match against the base image OS version during image recipe creation.</p>', 'ComponentSummary$supportedOsVersions' => '<p>The operating system (OS) version that the component supports. If the OS information is available, Image Builder performs a prefix match against the base image OS version during image recipe creation.</p>', 'ComponentVersion$supportedOsVersions' => '<p>he operating system (OS) version supported by the component. If the OS information is available, a prefix match is performed against the base image OS version during image recipe creation.</p>', 'CreateComponentRequest$supportedOsVersions' => '<p>The operating system (OS) version supported by the component. If the OS information is available, a prefix match is performed against the base image OS version during image recipe creation.</p>', ], ], 'OutputResources' => [ 'base' => '<p>The resources produced by this image.</p>', 'refs' => [ 'Image$outputResources' => '<p>The output resources that Image Builder produces for this image.</p>', 'ImageSummary$outputResources' => '<p>The output resources that Image Builder produced when it created this image.</p>', ], ], 'Ownership' => [ 'base' => NULL, 'refs' => [ 'ListComponentsRequest$owner' => '<p>Filters results based on the type of owner for the component. By default, this request returns a list of components that your account owns. To see results for other types of owners, you can specify components that Amazon manages, third party components, or components that other accounts have shared with you.</p>', 'ListContainerRecipesRequest$owner' => '<p>Returns container recipes belonging to the specified owner, that have been shared with you. You can omit this field to return container recipes belonging to your account.</p>', 'ListImageRecipesRequest$owner' => '<p>The owner defines which image recipes you want to list. By default, this request will only show image recipes owned by your account. You can use this field to specify if you want to view image recipes owned by yourself, by Amazon, or those image recipes that have been shared with you by other customers.</p>', 'ListImagesRequest$owner' => '<p>The owner defines which images you want to list. By default, this request will only show images owned by your account. You can use this field to specify if you want to view images owned by yourself, by Amazon, or those images that have been shared with you by other customers.</p>', 'ListWorkflowsRequest$owner' => '<p>Used to get a list of workflow build version filtered by the identity of the creator.</p>', ], ], 'PackageArchitecture' => [ 'base' => NULL, 'refs' => [ 'VulnerablePackage$arch' => '<p>The architecture of the vulnerable package.</p>', ], ], 'PackageEpoch' => [ 'base' => NULL, 'refs' => [ 'VulnerablePackage$epoch' => '<p>The epoch of the vulnerable package.</p>', ], ], 'PackageVulnerabilityDetails' => [ 'base' => '<p>Information about package vulnerability findings.</p>', 'refs' => [ 'ImageScanFinding$packageVulnerabilityDetails' => '<p>An object that contains the details of a package vulnerability finding.</p>', ], ], 'PaginationToken' => [ 'base' => NULL, 'refs' => [ 'ListComponentBuildVersionsRequest$nextToken' => '<p>A token to specify where to start paginating. This is the nextToken from a previously truncated response.</p>', 'ListComponentBuildVersionsResponse$nextToken' => '<p>The next token used for paginated responses. When this field isn\'t empty, there are additional elements that the service hasn\'t included in this request. Use this token with the next request to retrieve additional objects.</p>', 'ListComponentsRequest$nextToken' => '<p>A token to specify where to start paginating. This is the nextToken from a previously truncated response.</p>', 'ListComponentsResponse$nextToken' => '<p>The next token used for paginated responses. When this field isn\'t empty, there are additional elements that the service hasn\'t included in this request. Use this token with the next request to retrieve additional objects.</p>', 'ListDistributionConfigurationsRequest$nextToken' => '<p>A token to specify where to start paginating. This is the nextToken from a previously truncated response.</p>', 'ListDistributionConfigurationsResponse$nextToken' => '<p>The next token used for paginated responses. When this field isn\'t empty, there are additional elements that the service hasn\'t included in this request. Use this token with the next request to retrieve additional objects.</p>', 'ListImageBuildVersionsRequest$nextToken' => '<p>A token to specify where to start paginating. This is the nextToken from a previously truncated response.</p>', 'ListImageBuildVersionsResponse$nextToken' => '<p>The next token used for paginated responses. When this field isn\'t empty, there are additional elements that the service hasn\'t included in this request. Use this token with the next request to retrieve additional objects.</p>', 'ListImagePackagesRequest$nextToken' => '<p>A token to specify where to start paginating. This is the nextToken from a previously truncated response.</p>', 'ListImagePackagesResponse$nextToken' => '<p>The next token used for paginated responses. When this field isn\'t empty, there are additional elements that the service hasn\'t included in this request. Use this token with the next request to retrieve additional objects.</p>', 'ListImagePipelineImagesRequest$nextToken' => '<p>A token to specify where to start paginating. This is the nextToken from a previously truncated response.</p>', 'ListImagePipelineImagesResponse$nextToken' => '<p>The next token used for paginated responses. When this field isn\'t empty, there are additional elements that the service hasn\'t included in this request. Use this token with the next request to retrieve additional objects.</p>', 'ListImagePipelinesRequest$nextToken' => '<p>A token to specify where to start paginating. This is the nextToken from a previously truncated response.</p>', 'ListImagePipelinesResponse$nextToken' => '<p>The next token used for paginated responses. When this field isn\'t empty, there are additional elements that the service hasn\'t included in this request. Use this token with the next request to retrieve additional objects.</p>', 'ListImageRecipesRequest$nextToken' => '<p>A token to specify where to start paginating. This is the nextToken from a previously truncated response.</p>', 'ListImageRecipesResponse$nextToken' => '<p>The next token used for paginated responses. When this field isn\'t empty, there are additional elements that the service hasn\'t included in this request. Use this token with the next request to retrieve additional objects.</p>', 'ListImageScanFindingAggregationsRequest$nextToken' => '<p>A token to specify where to start paginating. This is the nextToken from a previously truncated response.</p>', 'ListImageScanFindingAggregationsResponse$nextToken' => '<p>The next token used for paginated responses. When this field isn\'t empty, there are additional elements that the service hasn\'t included in this request. Use this token with the next request to retrieve additional objects.</p>', 'ListImageScanFindingsRequest$nextToken' => '<p>A token to specify where to start paginating. This is the nextToken from a previously truncated response.</p>', 'ListImageScanFindingsResponse$nextToken' => '<p>The next token used for paginated responses. When this field isn\'t empty, there are additional elements that the service hasn\'t included in this request. Use this token with the next request to retrieve additional objects.</p>', 'ListImagesRequest$nextToken' => '<p>A token to specify where to start paginating. This is the nextToken from a previously truncated response.</p>', 'ListImagesResponse$nextToken' => '<p>The next token used for paginated responses. When this field isn\'t empty, there are additional elements that the service hasn\'t included in this request. Use this token with the next request to retrieve additional objects.</p>', 'ListInfrastructureConfigurationsRequest$nextToken' => '<p>A token to specify where to start paginating. This is the nextToken from a previously truncated response.</p>', 'ListInfrastructureConfigurationsResponse$nextToken' => '<p>The next token used for paginated responses. When this field isn\'t empty, there are additional elements that the service hasn\'t included in this request. Use this token with the next request to retrieve additional objects.</p>', 'ListLifecycleExecutionResourcesRequest$nextToken' => '<p>A token to specify where to start paginating. This is the nextToken from a previously truncated response.</p>', 'ListLifecycleExecutionResourcesResponse$nextToken' => '<p>The next token used for paginated responses. When this field isn\'t empty, there are additional elements that the service hasn\'t included in this request. Use this token with the next request to retrieve additional objects.</p>', 'ListLifecycleExecutionsRequest$nextToken' => '<p>A token to specify where to start paginating. This is the nextToken from a previously truncated response.</p>', 'ListLifecycleExecutionsResponse$nextToken' => '<p>The next token used for paginated responses. When this field isn\'t empty, there are additional elements that the service hasn\'t included in this request. Use this token with the next request to retrieve additional objects.</p>', 'ListLifecyclePoliciesRequest$nextToken' => '<p>A token to specify where to start paginating. This is the nextToken from a previously truncated response.</p>', 'ListLifecyclePoliciesResponse$nextToken' => '<p>The next token used for paginated responses. When this field isn\'t empty, there are additional elements that the service hasn\'t included in this request. Use this token with the next request to retrieve additional objects.</p>', 'ListWaitingWorkflowStepsRequest$nextToken' => '<p>A token to specify where to start paginating. This is the nextToken from a previously truncated response.</p>', 'ListWaitingWorkflowStepsResponse$nextToken' => '<p>The next token used for paginated responses. When this field isn\'t empty, there are additional elements that the service hasn\'t included in this request. Use this token with the next request to retrieve additional objects.</p>', 'ListWorkflowBuildVersionsRequest$nextToken' => '<p>A token to specify where to start paginating. This is the nextToken from a previously truncated response.</p>', 'ListWorkflowBuildVersionsResponse$nextToken' => '<p>The next token used for paginated responses. When this field isn\'t empty, there are additional elements that the service hasn\'t included in this request. Use this token with the next request to retrieve additional objects.</p>', 'ListWorkflowExecutionsRequest$nextToken' => '<p>A token to specify where to start paginating. This is the nextToken from a previously truncated response.</p>', 'ListWorkflowExecutionsResponse$nextToken' => '<p>The next token used for paginated responses. When this field isn\'t empty, there are additional elements that the service hasn\'t included in this request. Use this token with the next request to retrieve additional objects.</p>', 'ListWorkflowStepExecutionsRequest$nextToken' => '<p>A token to specify where to start paginating. This is the nextToken from a previously truncated response.</p>', 'ListWorkflowStepExecutionsResponse$nextToken' => '<p>The next token used for paginated responses. When this field isn\'t empty, there are additional elements that the service hasn\'t included in this request. Use this token with the next request to retrieve additional objects.</p>', 'ListWorkflowsRequest$nextToken' => '<p>A token to specify where to start paginating. This is the nextToken from a previously truncated response.</p>', 'ListWorkflowsResponse$nextToken' => '<p>The next token used for paginated responses. When this field isn\'t empty, there are additional elements that the service hasn\'t included in this request. Use this token with the next request to retrieve additional objects.</p>', ], ], 'ParallelGroup' => [ 'base' => NULL, 'refs' => [ 'GetWorkflowExecutionResponse$parallelGroup' => '<p>Test workflows are defined within named runtime groups. The parallel group is a named group that contains one or more test workflows.</p>', 'WorkflowConfiguration$parallelGroup' => '<p>Test workflows are defined within named runtime groups called parallel groups. The parallel group is the named group that contains this test workflow. Test workflows within a parallel group can run at the same time. Image Builder starts up to five test workflows in the group at the same time, and starts additional workflows as others complete, until all workflows in the group have completed. This field only applies for test workflows.</p>', 'WorkflowExecutionMetadata$parallelGroup' => '<p>The name of the test group that included the test workflow resource at runtime.</p>', ], ], 'PipelineExecutionStartCondition' => [ 'base' => NULL, 'refs' => [ 'Schedule$pipelineExecutionStartCondition' => '<p>The condition configures when the pipeline should trigger a new image build. When the <code>pipelineExecutionStartCondition</code> is set to <code>EXPRESSION_MATCH_AND_DEPENDENCY_UPDATES_AVAILABLE</code>, and you use semantic version filters on the base image or components in your image recipe, EC2 Image Builder will build a new image only when there are new versions of the image or components in your recipe that match the semantic version filter. When it is set to <code>EXPRESSION_MATCH_ONLY</code>, it will build a new image every time the CRON expression matches the current time. For semantic version syntax, see <a href="https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_CreateComponent.html">CreateComponent</a> in the <i> EC2 Image Builder API Reference</i>.</p>', ], ], 'PipelineStatus' => [ 'base' => NULL, 'refs' => [ 'CreateImagePipelineRequest$status' => '<p>The status of the image pipeline.</p>', 'ImagePipeline$status' => '<p>The status of the image pipeline.</p>', 'UpdateImagePipelineRequest$status' => '<p>The status of the image pipeline.</p>', ], ], 'Platform' => [ 'base' => NULL, 'refs' => [ 'Component$platform' => '<p>The operating system platform of the component.</p>', 'ComponentSummary$platform' => '<p>The operating system platform of the component.</p>', 'ComponentVersion$platform' => '<p>The platform of the component.</p>', 'ContainerRecipe$platform' => '<p>The system platform for the container, such as Windows or Linux.</p>', 'ContainerRecipeSummary$platform' => '<p>The system platform for the container, such as Windows or Linux.</p>', 'CreateComponentRequest$platform' => '<p>The operating system platform of the component.</p>', 'CreateContainerRecipeRequest$platformOverride' => '<p>Specifies the operating system platform when you use a custom base image.</p>', 'Image$platform' => '<p>The image operating system platform, such as Linux or Windows.</p>', 'ImagePipeline$platform' => '<p>The platform of the image pipeline.</p>', 'ImageRecipe$platform' => '<p>The platform of the image recipe.</p>', 'ImageRecipeSummary$platform' => '<p>The platform of the image recipe.</p>', 'ImageSummary$platform' => '<p>The image operating system platform, such as Linux or Windows.</p>', 'ImageVersion$platform' => '<p>The operating system platform of the image version, for example "Windows" or "Linux".</p>', 'ImportComponentRequest$platform' => '<p>The platform of the component.</p>', 'ImportVmImageRequest$platform' => '<p>The operating system platform for the imported VM.</p>', ], ], 'PutComponentPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutComponentPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutContainerRecipePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutContainerRecipePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutImagePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutImagePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutImageRecipePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutImageRecipePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'RegionList' => [ 'base' => NULL, 'refs' => [ 'DistributionConfigurationSummary$regions' => '<p>A list of Regions where the container image is distributed to.</p>', ], ], 'Remediation' => [ 'base' => '<p>Information about how to remediate a finding.</p>', 'refs' => [ 'ImageScanFinding$remediation' => '<p>An object that contains the details about how to remediate the finding.</p>', ], ], 'RemediationRecommendation' => [ 'base' => '<p>Details about the recommended course of action to remediate the finding.</p>', 'refs' => [ 'Remediation$recommendation' => '<p>An object that contains information about the recommended course of action to remediate the finding.</p>', ], ], 'ResourceAlreadyExistsException' => [ 'base' => '<p>The resource that you are trying to create already exists.</p>', 'refs' => [], ], 'ResourceDependencyException' => [ 'base' => '<p>You have attempted to mutate or delete a resource with a dependency that prohibits this action. See the error message for more details.</p>', 'refs' => [], ], 'ResourceInUseException' => [ 'base' => '<p>The resource that you are trying to operate on is currently in use. Review the message details and retry later.</p>', 'refs' => [], ], 'ResourceName' => [ 'base' => NULL, 'refs' => [ 'Component$name' => '<p>The name of the component.</p>', 'ComponentSummary$name' => '<p>The name of the component.</p>', 'ComponentVersion$name' => '<p>The name of the component.</p>', 'ContainerRecipe$name' => '<p>The name of the container recipe.</p>', 'ContainerRecipeSummary$name' => '<p>The name of the container recipe.</p>', 'CreateComponentRequest$name' => '<p>The name of the component.</p>', 'CreateContainerRecipeRequest$name' => '<p>The name of the container recipe.</p>', 'CreateDistributionConfigurationRequest$name' => '<p>The name of the distribution configuration.</p>', 'CreateImagePipelineRequest$name' => '<p>The name of the image pipeline.</p>', 'CreateImageRecipeRequest$name' => '<p>The name of the image recipe.</p>', 'CreateInfrastructureConfigurationRequest$name' => '<p>The name of the infrastructure configuration.</p>', 'CreateLifecyclePolicyRequest$name' => '<p>The name of the lifecycle policy to create.</p>', 'CreateWorkflowRequest$name' => '<p>The name of the workflow to create.</p>', 'DistributionConfiguration$name' => '<p>The name of the distribution configuration.</p>', 'DistributionConfigurationSummary$name' => '<p>The name of the distribution configuration.</p>', 'Image$name' => '<p>The name of the image.</p>', 'Image$sourcePipelineName' => '<p>The name of the image pipeline that created this image.</p>', 'ImagePipeline$name' => '<p>The name of the image pipeline.</p>', 'ImageRecipe$name' => '<p>The name of the image recipe.</p>', 'ImageRecipeSummary$name' => '<p>The name of the image recipe.</p>', 'ImageSummary$name' => '<p>The name of the image.</p>', 'ImageVersion$name' => '<p>The name of this specific version of an Image Builder image.</p>', 'ImportComponentRequest$name' => '<p>The name of the component.</p>', 'InfrastructureConfiguration$name' => '<p>The name of the infrastructure configuration.</p>', 'InfrastructureConfigurationSummary$name' => '<p>The name of the infrastructure configuration.</p>', 'LifecyclePolicy$name' => '<p>The name of the lifecycle policy.</p>', 'LifecyclePolicyResourceSelectionRecipe$name' => '<p>The name of an Image Builder recipe that the lifecycle policy uses for resource selection.</p>', 'LifecyclePolicySummary$name' => '<p>The name of the lifecycle policy.</p>', 'Workflow$name' => '<p>The name of the workflow resource.</p>', 'WorkflowSummary$name' => '<p>The name of the workflow.</p>', 'WorkflowVersion$name' => '<p>The name of the workflow.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>At least one of the resources referenced by your request does not exist.</p>', 'refs' => [], ], 'ResourcePolicyDocument' => [ 'base' => NULL, 'refs' => [ 'GetComponentPolicyResponse$policy' => '<p>The component policy.</p>', 'GetContainerRecipePolicyResponse$policy' => '<p>The container recipe policy object that is returned.</p>', 'GetImagePolicyResponse$policy' => '<p>The image policy object.</p>', 'GetImageRecipePolicyResponse$policy' => '<p>The image recipe policy object.</p>', 'PutComponentPolicyRequest$policy' => '<p>The policy to apply.</p>', 'PutContainerRecipePolicyRequest$policy' => '<p>The policy to apply to the container recipe.</p>', 'PutImagePolicyRequest$policy' => '<p>The policy to apply.</p>', 'PutImageRecipePolicyRequest$policy' => '<p>The policy to apply.</p>', ], ], 'ResourceState' => [ 'base' => '<p>The current state of an impacted resource.</p>', 'refs' => [ 'StartResourceStateUpdateRequest$state' => '<p>Indicates the lifecycle action to take for this request.</p>', ], ], 'ResourceStateUpdateExclusionRules' => [ 'base' => '<p>Additional rules to specify resources that should be exempt from ad-hoc lifecycle actions.</p>', 'refs' => [ 'StartResourceStateUpdateRequest$exclusionRules' => '<p>Skip action on the image resource and associated resources if specified exclusion rules are met.</p>', ], ], 'ResourceStateUpdateIncludeResources' => [ 'base' => '<p>Specifies if the lifecycle policy should apply actions to selected resources.</p>', 'refs' => [ 'StartResourceStateUpdateRequest$includeResources' => '<p>A list of image resources to update state for.</p>', ], ], 'ResourceStatus' => [ 'base' => NULL, 'refs' => [ 'ResourceState$status' => '<p>Shows the current lifecycle policy action that was applied to an impacted resource.</p>', ], ], 'ResourceTagMap' => [ 'base' => NULL, 'refs' => [ 'CreateInfrastructureConfigurationRequest$resourceTags' => '<p>The tags attached to the resource created by Image Builder.</p>', 'InfrastructureConfiguration$resourceTags' => '<p>The tags attached to the resource created by Image Builder.</p>', 'InfrastructureConfigurationSummary$resourceTags' => '<p>The tags attached to the image created by Image Builder.</p>', 'UpdateInfrastructureConfigurationRequest$resourceTags' => '<p>The tags attached to the resource created by Image Builder.</p>', ], ], 'RestrictedInteger' => [ 'base' => NULL, 'refs' => [ 'ListComponentBuildVersionsRequest$maxResults' => '<p>The maximum items to return in a request.</p>', 'ListComponentsRequest$maxResults' => '<p>The maximum items to return in a request.</p>', 'ListContainerRecipesRequest$maxResults' => '<p>The maximum items to return in a request.</p>', 'ListDistributionConfigurationsRequest$maxResults' => '<p>The maximum items to return in a request.</p>', 'ListImageBuildVersionsRequest$maxResults' => '<p>The maximum items to return in a request.</p>', 'ListImagePackagesRequest$maxResults' => '<p>The maximum items to return in a request.</p>', 'ListImagePipelineImagesRequest$maxResults' => '<p>The maximum items to return in a request.</p>', 'ListImagePipelinesRequest$maxResults' => '<p>The maximum items to return in a request.</p>', 'ListImageRecipesRequest$maxResults' => '<p>The maximum items to return in a request.</p>', 'ListImageScanFindingsRequest$maxResults' => '<p>The maximum items to return in a request.</p>', 'ListImagesRequest$maxResults' => '<p>The maximum items to return in a request.</p>', 'ListInfrastructureConfigurationsRequest$maxResults' => '<p>The maximum items to return in a request.</p>', 'ListLifecycleExecutionResourcesRequest$maxResults' => '<p>The maximum items to return in a request.</p>', 'ListLifecycleExecutionsRequest$maxResults' => '<p>The maximum items to return in a request.</p>', 'ListLifecyclePoliciesRequest$maxResults' => '<p>The maximum items to return in a request.</p>', 'ListWaitingWorkflowStepsRequest$maxResults' => '<p>The maximum items to return in a request.</p>', 'ListWorkflowBuildVersionsRequest$maxResults' => '<p>The maximum items to return in a request.</p>', 'ListWorkflowExecutionsRequest$maxResults' => '<p>The maximum items to return in a request.</p>', 'ListWorkflowStepExecutionsRequest$maxResults' => '<p>The maximum items to return in a request.</p>', 'ListWorkflowsRequest$maxResults' => '<p>The maximum items to return in a request.</p>', ], ], 'RoleNameOrArn' => [ 'base' => NULL, 'refs' => [ 'CreateImagePipelineRequest$executionRole' => '<p>The name or Amazon Resource Name (ARN) for the IAM role you create that grants Image Builder access to perform workflow actions.</p>', 'CreateImageRequest$executionRole' => '<p>The name or Amazon Resource Name (ARN) for the IAM role you create that grants Image Builder access to perform workflow actions.</p>', 'CreateLifecyclePolicyRequest$executionRole' => '<p>The name or Amazon Resource Name (ARN) for the IAM role you create that grants Image Builder access to run lifecycle actions.</p>', 'Image$executionRole' => '<p>The name or Amazon Resource Name (ARN) for the IAM role you create that grants Image Builder access to perform workflow actions.</p>', 'ImagePipeline$executionRole' => '<p>The name or Amazon Resource Name (ARN) for the IAM role you create that grants Image Builder access to perform workflow actions.</p>', 'LifecyclePolicy$executionRole' => '<p>The name or Amazon Resource Name (ARN) of the IAM role that Image Builder uses to run the lifecycle policy. This is a custom role that you create.</p>', 'LifecyclePolicySummary$executionRole' => '<p>The name or Amazon Resource Name (ARN) of the IAM role that Image Builder uses to run the lifecycle policy.</p>', 'StartResourceStateUpdateRequest$executionRole' => '<p>The name or Amazon Resource Name (ARN) of the IAM role that’s used to update image state.</p>', 'UpdateImagePipelineRequest$executionRole' => '<p>The name or Amazon Resource Name (ARN) for the IAM role you create that grants Image Builder access to perform workflow actions.</p>', 'UpdateLifecyclePolicyRequest$executionRole' => '<p>The name or Amazon Resource Name (ARN) of the IAM role that Image Builder uses to update the lifecycle policy.</p>', ], ], 'S3ExportConfiguration' => [ 'base' => '<p>Properties that configure export from your build instance to a compatible file format for your VM.</p>', 'refs' => [ 'Distribution$s3ExportConfiguration' => '<p>Configure export settings to deliver disk images created from your image build, using a file format that is compatible with your VMs in that Region.</p>', ], ], 'S3Logs' => [ 'base' => '<p>Amazon S3 logging configuration.</p>', 'refs' => [ 'Logging$s3Logs' => '<p>The Amazon S3 logging configuration.</p>', ], ], 'Schedule' => [ 'base' => '<p>A schedule configures when and how often a pipeline will automatically create a new image.</p>', 'refs' => [ 'CreateImagePipelineRequest$schedule' => '<p>The schedule of the image pipeline.</p>', 'ImagePipeline$schedule' => '<p>The schedule of the image pipeline.</p>', 'UpdateImagePipelineRequest$schedule' => '<p>The schedule of the image pipeline.</p>', ], ], 'SecurityGroupIds' => [ 'base' => NULL, 'refs' => [ 'CreateInfrastructureConfigurationRequest$securityGroupIds' => '<p>The security group IDs to associate with the instance used to customize your Amazon EC2 AMI.</p>', 'InfrastructureConfiguration$securityGroupIds' => '<p>The security group IDs of the infrastructure configuration.</p>', 'UpdateInfrastructureConfigurationRequest$securityGroupIds' => '<p>The security group IDs to associate with the instance used to customize your Amazon EC2 AMI.</p>', ], ], 'SendWorkflowStepActionRequest' => [ 'base' => NULL, 'refs' => [], ], 'SendWorkflowStepActionResponse' => [ 'base' => NULL, 'refs' => [], ], 'ServiceException' => [ 'base' => '<p>This exception is thrown when the service encounters an unrecoverable exception.</p>', 'refs' => [], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>You have exceeded the number of permitted resources or operations for this service. For service quotas, see <a href="https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder">EC2 Image Builder endpoints and quotas</a>.</p>', 'refs' => [], ], 'ServiceUnavailableException' => [ 'base' => '<p>The service is unable to process your request at this time.</p>', 'refs' => [], ], 'SeverityCountNumber' => [ 'base' => NULL, 'refs' => [ 'SeverityCounts$all' => '<p>The total number of findings across all severity levels for the specified filter.</p>', 'SeverityCounts$critical' => '<p>The number of critical severity findings for the specified filter.</p>', 'SeverityCounts$high' => '<p>The number of high severity findings for the specified filter.</p>', 'SeverityCounts$medium' => '<p>The number of medium severity findings for the specified filter.</p>', ], ], 'SeverityCounts' => [ 'base' => '<p>Includes counts by severity level for medium severity and higher level findings, plus a total for all of the findings for the specified filter.</p>', 'refs' => [ 'AccountAggregation$severityCounts' => '<p>Counts by severity level for medium severity and higher level findings, plus a total for all of the findings.</p>', 'ImageAggregation$severityCounts' => '<p>Counts by severity level for medium severity and higher level findings, plus a total for all of the findings for the specified image.</p>', 'ImagePipelineAggregation$severityCounts' => '<p>Counts by severity level for medium severity and higher level findings, plus a total for all of the findings for the specified image pipeline.</p>', 'VulnerabilityIdAggregation$severityCounts' => '<p>Counts by severity level for medium severity and higher level findings, plus a total for all of the findings for the specified vulnerability.</p>', ], ], 'SnsTopicArn' => [ 'base' => NULL, 'refs' => [ 'CreateInfrastructureConfigurationRequest$snsTopicArn' => '<p>The Amazon Resource Name (ARN) for the SNS topic to which we send image build event notifications.</p> <note> <p>EC2 Image Builder is unable to send notifications to SNS topics that are encrypted using keys from other accounts. The key that is used to encrypt the SNS topic must reside in the account that the Image Builder service runs under.</p> </note>', 'UpdateInfrastructureConfigurationRequest$snsTopicArn' => '<p>The Amazon Resource Name (ARN) for the SNS topic to which we send image build event notifications.</p> <note> <p>EC2 Image Builder is unable to send notifications to SNS topics that are encrypted using keys from other accounts. The key that is used to encrypt the SNS topic must reside in the account that the Image Builder service runs under.</p> </note>', ], ], 'SourceLayerHash' => [ 'base' => NULL, 'refs' => [ 'VulnerablePackage$sourceLayerHash' => '<p>The source layer hash of the vulnerable package.</p>', ], ], 'StartImagePipelineExecutionRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartImagePipelineExecutionResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartResourceStateUpdateRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartResourceStateUpdateResponse' => [ 'base' => NULL, 'refs' => [], ], 'StringList' => [ 'base' => NULL, 'refs' => [ 'Container$imageUris' => '<p>A list of URIs for containers created in the context Region.</p>', 'ContainerDistributionConfiguration$containerTags' => '<p>Tags that are attached to the container distribution configuration.</p>', 'EcrConfiguration$containerTags' => '<p>Tags for Image Builder to apply to the output container image that &amp;INS; scans. Tags can help you identify and manage your scanned images.</p>', 'LaunchPermissionConfiguration$userGroups' => '<p>The name of the group.</p>', 'LifecycleExecutionResource$imageUris' => '<p>For an impacted container image, this identifies a list of URIs for associated container images distributed to ECR repositories.</p>', 'LifecyclePolicyDetailExclusionRulesAmis$regions' => '<p>Configures Amazon Web Services Regions that are excluded from the lifecycle action.</p>', ], ], 'SystemsManagerAgent' => [ 'base' => '<p>Contains settings for the Systems Manager agent on your build instance.</p>', 'refs' => [ 'AdditionalInstanceConfiguration$systemsManagerAgent' => '<p>Contains settings for the Systems Manager agent on your build instance.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'ResourceTagMap$key' => NULL, 'TagKeyList$member' => NULL, 'TagMap$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>The tag keys to remove from the resource.</p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'AmiDistributionConfiguration$amiTags' => '<p>The tags to apply to AMIs distributed to this Region.</p>', 'Component$tags' => '<p>The tags that apply to the component.</p>', 'ComponentSummary$tags' => '<p>The tags that apply to the component.</p>', 'ContainerRecipe$tags' => '<p>Tags that are attached to the container recipe.</p>', 'ContainerRecipeSummary$tags' => '<p>Tags that are attached to the container recipe.</p>', 'CreateComponentRequest$tags' => '<p>The tags that apply to the component.</p>', 'CreateContainerRecipeRequest$tags' => '<p>Tags that are attached to the container recipe.</p>', 'CreateDistributionConfigurationRequest$tags' => '<p>The tags of the distribution configuration.</p>', 'CreateImagePipelineRequest$tags' => '<p>The tags of the image pipeline.</p>', 'CreateImageRecipeRequest$tags' => '<p>The tags of the image recipe.</p>', 'CreateImageRequest$tags' => '<p>The tags of the image.</p>', 'CreateInfrastructureConfigurationRequest$tags' => '<p>The tags of the infrastructure configuration.</p>', 'CreateLifecyclePolicyRequest$tags' => '<p>Tags to apply to the lifecycle policy resource.</p>', 'CreateWorkflowRequest$tags' => '<p>Tags that apply to the workflow resource.</p>', 'DistributionConfiguration$tags' => '<p>The tags of the distribution configuration.</p>', 'DistributionConfigurationSummary$tags' => '<p>The tags associated with the distribution configuration.</p>', 'Image$tags' => '<p>The tags that apply to this image.</p>', 'ImagePipeline$tags' => '<p>The tags of this image pipeline.</p>', 'ImageRecipe$tags' => '<p>The tags of the image recipe.</p>', 'ImageRecipeSummary$tags' => '<p>The tags of the image recipe.</p>', 'ImageSummary$tags' => '<p>The tags that apply to this image.</p>', 'ImportComponentRequest$tags' => '<p>The tags of the component.</p>', 'ImportVmImageRequest$tags' => '<p>Tags that are attached to the import resources.</p>', 'InfrastructureConfiguration$tags' => '<p>The tags of the infrastructure configuration.</p>', 'InfrastructureConfigurationSummary$tags' => '<p>The tags of the infrastructure configuration.</p>', 'LifecyclePolicy$tags' => '<p>To help manage your lifecycle policy resources, you can assign your own metadata to each resource in the form of tags. Each tag consists of a key and an optional value, both of which you define.</p>', 'LifecyclePolicyDetailExclusionRules$tagMap' => '<p>Contains a list of tags that Image Builder uses to skip lifecycle actions for Image Builder image resources that have them.</p>', 'LifecyclePolicyDetailExclusionRulesAmis$tagMap' => '<p>Lists tags that should be excluded from lifecycle actions for the AMIs that have them.</p>', 'LifecyclePolicyResourceSelection$tagMap' => '<p>A list of tags that are used as selection criteria for the Image Builder image resources that the lifecycle policy applies to.</p>', 'LifecyclePolicySummary$tags' => '<p>To help manage your lifecycle policy resources, you can assign your own metadata to each resource in the form of tags. Each tag consists of a key and an optional value, both of which you define.</p>', 'ListTagsForResourceResponse$tags' => '<p>The tags for the specified resource.</p>', 'TagResourceRequest$tags' => '<p>The tags to apply to the resource.</p>', 'Workflow$tags' => '<p>The tags that apply to the workflow resource</p>', 'WorkflowSummary$tags' => '<p>Contains a list of tags that are defined for the workflow.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'ResourceTagMap$value' => NULL, 'TagMap$value' => NULL, ], ], 'TargetContainerRepository' => [ 'base' => '<p>The container repository where the output container image is stored.</p>', 'refs' => [ 'ContainerDistributionConfiguration$targetRepository' => '<p>The destination repository for the container distribution configuration.</p>', 'ContainerRecipe$targetRepository' => '<p>The destination repository for the container image.</p>', 'CreateContainerRecipeRequest$targetRepository' => '<p>The destination repository for the container image.</p>', ], ], 'TargetResourceCount' => [ 'base' => NULL, 'refs' => [ 'FastLaunchSnapshotConfiguration$targetResourceCount' => '<p>The number of pre-provisioned snapshots to keep on hand for a fast-launch enabled Windows AMI.</p>', ], ], 'Timezone' => [ 'base' => NULL, 'refs' => [ 'Schedule$timezone' => '<p>The timezone that applies to the scheduling expression. For example, "Etc/UTC", "America/Los_Angeles" in the <a href="https://www.joda.org/joda-time/timezones.html">IANA timezone format</a>. If not specified this defaults to UTC.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDistributionConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDistributionConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateImagePipelineRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateImagePipelineResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateInfrastructureConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateInfrastructureConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateLifecyclePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateLifecyclePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'Uri' => [ 'base' => NULL, 'refs' => [ 'CreateComponentRequest$uri' => '<p>The <code>uri</code> of a YAML component document file. This must be an S3 URL (<code>s3://bucket/key</code>), and the requester must have permission to access the S3 bucket it points to. If you use Amazon S3, you can specify component content up to your service quota.</p> <p>Alternatively, you can specify the YAML document inline, using the component <code>data</code> property. You cannot specify both properties.</p>', 'CreateContainerRecipeRequest$dockerfileTemplateUri' => '<p>The Amazon S3 URI for the Dockerfile that will be used to build your container image.</p>', 'CreateWorkflowRequest$uri' => '<p>The <code>uri</code> of a YAML component document file. This must be an S3 URL (<code>s3://bucket/key</code>), and the requester must have permission to access the S3 bucket it points to. If you use Amazon S3, you can specify component content up to your service quota.</p> <p>Alternatively, you can specify the YAML document inline, using the component <code>data</code> property. You cannot specify both properties.</p>', 'ImportComponentRequest$uri' => '<p>The uri of the component. Must be an Amazon S3 URL and the requester must have permission to access the Amazon S3 bucket. If you use Amazon S3, you can specify component content up to your service quota. Either <code>data</code> or <code>uri</code> can be used to specify the data within the component.</p>', ], ], 'UserDataOverride' => [ 'base' => NULL, 'refs' => [ 'AdditionalInstanceConfiguration$userDataOverride' => '<p>Use this property to provide commands or a command script to run when you launch your build instance.</p> <p>The userDataOverride property replaces any commands that Image Builder might have added to ensure that Systems Manager is installed on your Linux build instance. If you override the user data, make sure that you add commands to install Systems Manager, if it is not pre-installed on your base image.</p> <note> <p>The user data is always base 64 encoded. For example, the following commands are encoded as <code>IyEvYmluL2Jhc2gKbWtkaXIgLXAgL3Zhci9iYi8KdG91Y2ggL3Zhci$</code>:</p> <p> <i>#!/bin/bash</i> </p> <p>mkdir -p /var/bb/</p> <p>touch /var</p> </note>', ], ], 'VersionNumber' => [ 'base' => NULL, 'refs' => [ 'Component$version' => '<p>The version of the component.</p>', 'ComponentSummary$version' => '<p>The version of the component.</p>', 'ComponentVersion$version' => '<p>The semantic version of the component.</p> <note> <p>The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can assign values for the first three, and can filter on all of them.</p> <p> <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number to the fourth node.</p> <p> <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.</p> <p> <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x) to specify the most recent versions or nodes when selecting the base image or components for your recipe. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be wildcards.</p> </note>', 'ContainerRecipe$version' => '<p>The semantic version of the container recipe.</p> <note> <p>The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can assign values for the first three, and can filter on all of them.</p> <p> <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number to the fourth node.</p> <p> <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.</p> <p> <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x) to specify the most recent versions or nodes when selecting the base image or components for your recipe. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be wildcards.</p> </note>', 'CreateComponentRequest$semanticVersion' => '<p>The semantic version of the component. This version follows the semantic version syntax.</p> <note> <p>The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can assign values for the first three, and can filter on all of them.</p> <p> <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number to the fourth node.</p> <p> <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.</p> </note>', 'CreateContainerRecipeRequest$semanticVersion' => '<p>The semantic version of the container recipe. This version follows the semantic version syntax.</p> <note> <p>The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can assign values for the first three, and can filter on all of them.</p> <p> <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number to the fourth node.</p> <p> <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.</p> </note>', 'CreateImageRecipeRequest$semanticVersion' => '<p>The semantic version of the image recipe. This version follows the semantic version syntax.</p> <note> <p>The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can assign values for the first three, and can filter on all of them.</p> <p> <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number to the fourth node.</p> <p> <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.</p> </note>', 'CreateWorkflowRequest$semanticVersion' => '<p>The semantic version of this workflow resource. The semantic version syntax adheres to the following rules.</p> <note> <p>The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can assign values for the first three, and can filter on all of them.</p> <p> <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number to the fourth node.</p> <p> <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.</p> </note>', 'Image$version' => '<p>The semantic version of the image.</p> <note> <p>The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can assign values for the first three, and can filter on all of them.</p> <p> <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number to the fourth node.</p> <p> <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.</p> <p> <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x) to specify the most recent versions or nodes when selecting the base image or components for your recipe. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be wildcards.</p> </note>', 'ImageRecipe$version' => '<p>The version of the image recipe.</p>', 'ImageSummary$version' => '<p>The version of the image.</p>', 'ImageVersion$version' => '<p>Details for a specific version of an Image Builder image. This version follows the semantic version syntax.</p> <note> <p>The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can assign values for the first three, and can filter on all of them.</p> <p> <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number to the fourth node.</p> <p> <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.</p> <p> <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x) to specify the most recent versions or nodes when selecting the base image or components for your recipe. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be wildcards.</p> </note>', 'ImportComponentRequest$semanticVersion' => '<p>The semantic version of the component. This version follows the semantic version syntax.</p> <note> <p>The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can assign values for the first three, and can filter on all of them.</p> <p> <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x) to specify the most recent versions or nodes when selecting the base image or components for your recipe. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be wildcards.</p> </note>', 'ImportVmImageRequest$semanticVersion' => '<p>The semantic version to attach to the base image that was created during the import process. This version follows the semantic version syntax.</p> <note> <p>The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can assign values for the first three, and can filter on all of them.</p> <p> <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number to the fourth node.</p> <p> <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.</p> </note>', 'LifecyclePolicyResourceSelectionRecipe$semanticVersion' => '<p>The version of the Image Builder recipe specified by the <code>name</code> field.</p>', 'Workflow$version' => '<p>The workflow resource version. Workflow resources are immutable. To make a change, you can clone a workflow or create a new version.</p>', 'WorkflowSummary$version' => '<p>The version of the workflow.</p>', 'WorkflowVersion$version' => '<p>The semantic version of the workflow resource. The format includes three nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;.</p>', ], ], 'VulnerabilityId' => [ 'base' => NULL, 'refs' => [ 'PackageVulnerabilityDetails$vulnerabilityId' => '<p>A unique identifier for this vulnerability.</p>', 'VulnerabilityIdList$member' => NULL, ], ], 'VulnerabilityIdAggregation' => [ 'base' => '<p>Includes counts of image and pipeline resource findings by vulnerability.</p>', 'refs' => [ 'ImageScanFindingAggregation$vulnerabilityIdAggregation' => '<p>Returns an object that contains severity counts based on vulnerability ID.</p>', ], ], 'VulnerabilityIdList' => [ 'base' => NULL, 'refs' => [ 'PackageVulnerabilityDetails$relatedVulnerabilities' => '<p>Vulnerabilities that are often related to the findings for the package.</p>', ], ], 'VulnerablePackage' => [ 'base' => '<p>Information about a vulnerable package that Amazon Inspector identifies in a finding.</p>', 'refs' => [ 'VulnerablePackageList$member' => NULL, ], ], 'VulnerablePackageList' => [ 'base' => NULL, 'refs' => [ 'PackageVulnerabilityDetails$vulnerablePackages' => '<p>The packages that this vulnerability impacts.</p>', ], ], 'Workflow' => [ 'base' => '<p>Defines a process that Image Builder uses to build and test images during the image creation process.</p>', 'refs' => [ 'GetWorkflowResponse$workflow' => '<p>The workflow resource specified in the request.</p>', ], ], 'WorkflowBuildVersionArn' => [ 'base' => NULL, 'refs' => [ 'CreateWorkflowResponse$workflowBuildVersionArn' => '<p>The Amazon Resource Name (ARN) of the workflow resource that the request created.</p>', 'DeleteWorkflowRequest$workflowBuildVersionArn' => '<p>The Amazon Resource Name (ARN) of the workflow resource to delete.</p>', 'DeleteWorkflowResponse$workflowBuildVersionArn' => '<p>The ARN of the workflow resource that this request deleted.</p>', 'GetWorkflowExecutionResponse$workflowBuildVersionArn' => '<p>The Amazon Resource Name (ARN) of the build version for the Image Builder workflow resource that defines the specified runtime instance of the workflow.</p>', 'GetWorkflowStepExecutionResponse$workflowBuildVersionArn' => '<p>The Amazon Resource Name (ARN) of the build version for the Image Builder workflow resource that defines this workflow step.</p>', 'ListWorkflowStepExecutionsResponse$workflowBuildVersionArn' => '<p>The build version ARN for the Image Builder workflow resource that defines the steps for this runtime instance of the workflow.</p>', 'Workflow$arn' => '<p>The Amazon Resource Name (ARN) of the workflow resource.</p>', 'WorkflowExecutionMetadata$workflowBuildVersionArn' => '<p>The Amazon Resource Name (ARN) of the workflow resource build version that ran.</p>', 'WorkflowStepExecution$workflowBuildVersionArn' => '<p>The ARN of the workflow resource that ran.</p>', ], ], 'WorkflowConfiguration' => [ 'base' => '<p>Contains control settings and configurable inputs for a workflow resource.</p>', 'refs' => [ 'WorkflowConfigurationList$member' => NULL, ], ], 'WorkflowConfigurationList' => [ 'base' => NULL, 'refs' => [ 'CreateImagePipelineRequest$workflows' => '<p>Contains an array of workflow configuration objects.</p>', 'CreateImageRequest$workflows' => '<p>Contains an array of workflow configuration objects.</p>', 'Image$workflows' => '<p>Contains the build and test workflows that are associated with the image.</p>', 'ImagePipeline$workflows' => '<p>Contains the workflows that run for the image pipeline.</p>', 'UpdateImagePipelineRequest$workflows' => '<p>Contains the workflows to run for the pipeline.</p>', ], ], 'WorkflowData' => [ 'base' => NULL, 'refs' => [ 'Workflow$data' => '<p>Contains the YAML document content for the workflow.</p>', ], ], 'WorkflowExecutionId' => [ 'base' => NULL, 'refs' => [ 'GetWorkflowExecutionRequest$workflowExecutionId' => '<p>Use the unique identifier for a runtime instance of the workflow to get runtime details.</p>', 'GetWorkflowExecutionResponse$workflowExecutionId' => '<p>The unique identifier that Image Builder assigned to keep track of runtime details when it ran the workflow.</p>', 'GetWorkflowStepExecutionResponse$workflowExecutionId' => '<p>The unique identifier that Image Builder assigned to keep track of runtime details when it ran the workflow.</p>', 'ListWorkflowStepExecutionsRequest$workflowExecutionId' => '<p>The unique identifier that Image Builder assigned to keep track of runtime details when it ran the workflow.</p>', 'ListWorkflowStepExecutionsResponse$workflowExecutionId' => '<p>The unique identifier that Image Builder assigned to keep track of runtime details when it ran the workflow.</p>', 'WorkflowExecutionMetadata$workflowExecutionId' => '<p>Unique identifier that Image Builder assigns to keep track of runtime resources each time it runs a workflow.</p>', 'WorkflowStepExecution$workflowExecutionId' => '<p>Uniquely identifies the runtime instance of the workflow that contains the workflow step that ran for the associated image build version.</p>', ], ], 'WorkflowExecutionMessage' => [ 'base' => NULL, 'refs' => [ 'GetWorkflowExecutionResponse$message' => '<p>The output message from the specified runtime instance of the workflow, if applicable.</p>', 'WorkflowExecutionMetadata$message' => '<p>The runtime output message from the workflow, if applicable.</p>', ], ], 'WorkflowExecutionMetadata' => [ 'base' => '<p>Metadata that includes details and status from this runtime instance of the workflow.</p>', 'refs' => [ 'WorkflowExecutionsList$member' => NULL, ], ], 'WorkflowExecutionStatus' => [ 'base' => NULL, 'refs' => [ 'GetWorkflowExecutionResponse$status' => '<p>The current runtime status for the specified runtime instance of the workflow.</p>', 'WorkflowExecutionMetadata$status' => '<p>The current runtime status for this workflow.</p>', ], ], 'WorkflowExecutionsList' => [ 'base' => NULL, 'refs' => [ 'ListWorkflowExecutionsResponse$workflowExecutions' => '<p>Contains an array of runtime details that represents each time a workflow ran for the requested image build version.</p>', ], ], 'WorkflowNameArn' => [ 'base' => NULL, 'refs' => [ 'WorkflowSummary$arn' => '<p>The Amazon Resource Name (ARN) of the workflow resource.</p>', ], ], 'WorkflowParameter' => [ 'base' => '<p>Contains a key/value pair that sets the named workflow parameter.</p>', 'refs' => [ 'WorkflowParameterList$member' => NULL, ], ], 'WorkflowParameterDescription' => [ 'base' => NULL, 'refs' => [ 'WorkflowParameterDetail$description' => '<p>Describes this parameter.</p>', ], ], 'WorkflowParameterDetail' => [ 'base' => '<p>Defines a parameter that\'s used to provide configuration details for the workflow.</p>', 'refs' => [ 'WorkflowParameterDetailList$member' => NULL, ], ], 'WorkflowParameterDetailList' => [ 'base' => NULL, 'refs' => [ 'Workflow$parameters' => '<p>An array of input parameters that that the image workflow uses to control actions or configure settings.</p>', ], ], 'WorkflowParameterList' => [ 'base' => NULL, 'refs' => [ 'WorkflowConfiguration$parameters' => '<p>Contains parameter values for each of the parameters that the workflow document defined for the workflow resource.</p>', ], ], 'WorkflowParameterName' => [ 'base' => NULL, 'refs' => [ 'WorkflowParameter$name' => '<p>The name of the workflow parameter to set.</p>', 'WorkflowParameterDetail$name' => '<p>The name of this input parameter.</p>', ], ], 'WorkflowParameterType' => [ 'base' => NULL, 'refs' => [ 'WorkflowParameterDetail$type' => '<p>The type of input this parameter provides. The currently supported value is "string".</p>', ], ], 'WorkflowParameterValue' => [ 'base' => NULL, 'refs' => [ 'WorkflowParameterValueList$member' => NULL, ], ], 'WorkflowParameterValueList' => [ 'base' => NULL, 'refs' => [ 'WorkflowParameter$value' => '<p>Sets the value for the named workflow parameter.</p>', 'WorkflowParameterDetail$defaultValue' => '<p>The default value of this parameter if no input is provided.</p>', ], ], 'WorkflowState' => [ 'base' => '<p>A group of fields that describe the current status of workflow.</p>', 'refs' => [ 'Workflow$state' => '<p>Describes the current status of the workflow and the reason for that status.</p>', 'WorkflowSummary$state' => '<p>Describes the current state of the workflow resource.</p>', ], ], 'WorkflowStatus' => [ 'base' => NULL, 'refs' => [ 'WorkflowState$status' => '<p>The current state of the workflow.</p>', ], ], 'WorkflowStepAction' => [ 'base' => NULL, 'refs' => [ 'GetWorkflowStepExecutionResponse$action' => '<p>The name of the action that the specified step performs.</p>', 'WorkflowStepExecution$action' => '<p>The name of the step action.</p>', 'WorkflowStepMetadata$action' => '<p>The step action name.</p>', ], ], 'WorkflowStepActionType' => [ 'base' => NULL, 'refs' => [ 'SendWorkflowStepActionRequest$action' => '<p>The action for the image creation process to take while a workflow <code>WaitForAction</code> step waits for an asynchronous action to complete.</p>', ], ], 'WorkflowStepCount' => [ 'base' => NULL, 'refs' => [ 'GetWorkflowExecutionResponse$totalStepCount' => '<p>The total number of steps in the specified runtime instance of the workflow that ran. This number should equal the sum of the step counts for steps that succeeded, were skipped, and failed.</p>', 'GetWorkflowExecutionResponse$totalStepsSucceeded' => '<p>A runtime count for the number of steps that ran successfully in the specified runtime instance of the workflow.</p>', 'GetWorkflowExecutionResponse$totalStepsFailed' => '<p>A runtime count for the number of steps that failed in the specified runtime instance of the workflow.</p>', 'GetWorkflowExecutionResponse$totalStepsSkipped' => '<p>A runtime count for the number of steps that were skipped in the specified runtime instance of the workflow.</p>', 'WorkflowExecutionMetadata$totalStepCount' => '<p>The total number of steps in the workflow. This should equal the sum of the step counts for steps that succeeded, were skipped, and failed.</p>', 'WorkflowExecutionMetadata$totalStepsSucceeded' => '<p>A runtime count for the number of steps in the workflow that ran successfully.</p>', 'WorkflowExecutionMetadata$totalStepsFailed' => '<p>A runtime count for the number of steps in the workflow that failed.</p>', 'WorkflowExecutionMetadata$totalStepsSkipped' => '<p>A runtime count for the number of steps in the workflow that were skipped.</p>', ], ], 'WorkflowStepDescription' => [ 'base' => NULL, 'refs' => [ 'GetWorkflowStepExecutionResponse$description' => '<p>Describes the specified workflow step.</p>', 'WorkflowStepMetadata$description' => '<p>Description of the workflow step.</p>', ], ], 'WorkflowStepExecution' => [ 'base' => '<p>Contains runtime details for an instance of a workflow that ran for the associated image build version.</p>', 'refs' => [ 'WorkflowStepExecutionList$member' => NULL, ], ], 'WorkflowStepExecutionId' => [ 'base' => NULL, 'refs' => [ 'GetWorkflowStepExecutionRequest$stepExecutionId' => '<p>Use the unique identifier for a specific runtime instance of the workflow step to get runtime details for that step.</p>', 'GetWorkflowStepExecutionResponse$stepExecutionId' => '<p>The unique identifier for the runtime version of the workflow step that you specified in the request.</p>', 'SendWorkflowStepActionRequest$stepExecutionId' => '<p>Uniquely identifies the workflow step that sent the step action.</p>', 'SendWorkflowStepActionResponse$stepExecutionId' => '<p>The workflow step that sent the step action.</p>', 'WorkflowStepExecution$stepExecutionId' => '<p>Uniquely identifies the workflow step that ran for the associated image build version.</p>', 'WorkflowStepMetadata$stepExecutionId' => '<p>A unique identifier for the workflow step, assigned at runtime.</p>', ], ], 'WorkflowStepExecutionList' => [ 'base' => NULL, 'refs' => [ 'ListWaitingWorkflowStepsResponse$steps' => '<p>An array of the workflow steps that are waiting for action in your Amazon Web Services account.</p>', ], ], 'WorkflowStepExecutionRollbackStatus' => [ 'base' => NULL, 'refs' => [ 'GetWorkflowStepExecutionResponse$rollbackStatus' => '<p>Reports on the rollback status of the specified runtime version of the workflow step, if applicable.</p>', 'WorkflowStepMetadata$rollbackStatus' => '<p>Reports on the rollback status of the step, if applicable.</p>', ], ], 'WorkflowStepExecutionStatus' => [ 'base' => NULL, 'refs' => [ 'GetWorkflowStepExecutionResponse$status' => '<p>The current status for the specified runtime version of the workflow step.</p>', 'WorkflowStepMetadata$status' => '<p>Runtime status for the workflow step.</p>', ], ], 'WorkflowStepExecutionsList' => [ 'base' => NULL, 'refs' => [ 'ListWorkflowStepExecutionsResponse$steps' => '<p>Contains an array of runtime details that represents each step in this runtime instance of the workflow.</p>', ], ], 'WorkflowStepInputs' => [ 'base' => NULL, 'refs' => [ 'GetWorkflowStepExecutionResponse$inputs' => '<p>Input parameters that Image Builder provided for the specified runtime instance of the workflow step.</p>', 'WorkflowStepMetadata$inputs' => '<p>Input parameters that Image Builder provides for the workflow step.</p>', ], ], 'WorkflowStepMessage' => [ 'base' => NULL, 'refs' => [ 'GetWorkflowStepExecutionResponse$message' => '<p>The output message from the specified runtime instance of the workflow step, if applicable.</p>', 'WorkflowStepMetadata$message' => '<p>Detailed output message that the workflow step provides at runtime.</p>', ], ], 'WorkflowStepMetadata' => [ 'base' => '<p>Runtime details and status for the workflow step.</p>', 'refs' => [ 'WorkflowStepExecutionsList$member' => NULL, ], ], 'WorkflowStepName' => [ 'base' => NULL, 'refs' => [ 'GetWorkflowStepExecutionResponse$name' => '<p>The name of the specified runtime instance of the workflow step.</p>', 'WorkflowStepExecution$name' => '<p>The name of the workflow step.</p>', 'WorkflowStepMetadata$name' => '<p>The name of the workflow step.</p>', ], ], 'WorkflowStepOutputs' => [ 'base' => NULL, 'refs' => [ 'GetWorkflowStepExecutionResponse$outputs' => '<p>The file names that the specified runtime version of the workflow step created as output.</p>', 'WorkflowStepMetadata$outputs' => '<p>The file names that the workflow step created as output for this runtime instance of the workflow.</p>', ], ], 'WorkflowStepTimeoutSecondsInteger' => [ 'base' => NULL, 'refs' => [ 'GetWorkflowStepExecutionResponse$timeoutSeconds' => '<p>The maximum duration in seconds for this step to complete its action.</p>', ], ], 'WorkflowSummary' => [ 'base' => '<p>Contains metadata about the workflow resource.</p>', 'refs' => [ 'WorkflowSummaryList$member' => NULL, ], ], 'WorkflowSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListWorkflowBuildVersionsResponse$workflowSummaryList' => '<p>A list that contains metadata for the workflow builds that have run for the workflow resource specified in the request.</p>', ], ], 'WorkflowType' => [ 'base' => NULL, 'refs' => [ 'CreateWorkflowRequest$type' => '<p>The phase in the image build process for which the workflow resource is responsible.</p>', 'GetWorkflowExecutionResponse$type' => '<p>The type of workflow that Image Builder ran for the specified runtime instance of the workflow.</p>', 'Workflow$type' => '<p>Specifies the image creation stage that the workflow applies to. Image Builder currently supports build and test workflows.</p>', 'WorkflowExecutionMetadata$type' => '<p>Indicates what type of workflow that Image Builder ran for this runtime instance of the workflow.</p>', 'WorkflowSummary$type' => '<p>The image creation stage that this workflow applies to. Image Builder currently supports build and test stage workflows.</p>', 'WorkflowVersion$type' => '<p>The image creation stage that this workflow applies to. Image Builder currently supports build and test stage workflows.</p>', ], ], 'WorkflowVersion' => [ 'base' => '<p>Contains details about this version of the workflow.</p>', 'refs' => [ 'WorkflowVersionList$member' => NULL, ], ], 'WorkflowVersionArn' => [ 'base' => NULL, 'refs' => [ 'WorkflowVersion$arn' => '<p>The Amazon Resource Name (ARN) of the workflow resource.</p>', ], ], 'WorkflowVersionArnOrBuildVersionArn' => [ 'base' => NULL, 'refs' => [ 'GetWorkflowRequest$workflowBuildVersionArn' => '<p>The Amazon Resource Name (ARN) of the workflow resource that you want to get.</p>', 'WorkflowConfiguration$workflowArn' => '<p>The Amazon Resource Name (ARN) of the workflow resource.</p>', ], ], 'WorkflowVersionList' => [ 'base' => NULL, 'refs' => [ 'ListWorkflowsResponse$workflowVersionList' => '<p>A list of workflow build versions that match the request criteria.</p>', ], ], 'WorkflowWildcardVersionArn' => [ 'base' => NULL, 'refs' => [ 'ListWorkflowBuildVersionsRequest$workflowVersionArn' => '<p>The Amazon Resource Name (ARN) of the workflow resource for which to get a list of build versions.</p>', ], ], ],];
