<?php
// This file was auto-generated from sdk-root/src/data/inspector2/2020-06-08/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Amazon Inspector is a vulnerability discovery service that automates continuous scanning for security vulnerabilities within your Amazon EC2, Amazon ECR, and Amazon Web Services Lambda environments.</p>', 'operations' => [ 'AssociateMember' => '<p>Associates an Amazon Web Services account with an Amazon Inspector delegated administrator. An HTTP 200 response indicates the association was successfully started, but doesn’t indicate whether it was completed. You can check if the association completed by using <a href="https://docs.aws.amazon.com/inspector/v2/APIReference/API_ListMembers.html">ListMembers</a> for multiple accounts or <a href="https://docs.aws.amazon.com/inspector/v2/APIReference/API_GetMember.html">GetMembers</a> for a single account.</p>', 'BatchGetAccountStatus' => '<p>Retrieves the Amazon Inspector status of multiple Amazon Web Services accounts within your environment.</p>', 'BatchGetCodeSnippet' => '<p>Retrieves code snippets from findings that Amazon Inspector detected code vulnerabilities in.</p>', 'BatchGetFindingDetails' => '<p>Gets vulnerability details for findings.</p>', 'BatchGetFreeTrialInfo' => '<p>Gets free trial status for multiple Amazon Web Services accounts.</p>', 'BatchGetMemberEc2DeepInspectionStatus' => '<p>Retrieves Amazon Inspector deep inspection activation status of multiple member accounts within your organization. You must be the delegated administrator of an organization in Amazon Inspector to use this API.</p>', 'BatchUpdateMemberEc2DeepInspectionStatus' => '<p>Activates or deactivates Amazon Inspector deep inspection for the provided member accounts in your organization. You must be the delegated administrator of an organization in Amazon Inspector to use this API.</p>', 'CancelFindingsReport' => '<p>Cancels the given findings report.</p>', 'CancelSbomExport' => '<p>Cancels a software bill of materials (SBOM) report.</p>', 'CreateCisScanConfiguration' => '<p>Creates a CIS scan configuration.</p>', 'CreateFilter' => '<p>Creates a filter resource using specified filter criteria. When the filter action is set to <code>SUPPRESS</code> this action creates a suppression rule.</p>', 'CreateFindingsReport' => '<p>Creates a finding report. By default only <code>ACTIVE</code> findings are returned in the report. To see <code>SUPRESSED</code> or <code>CLOSED</code> findings you must specify a value for the <code>findingStatus</code> filter criteria. </p>', 'CreateSbomExport' => '<p>Creates a software bill of materials (SBOM) report.</p>', 'DeleteCisScanConfiguration' => '<p>Deletes a CIS scan configuration.</p>', 'DeleteFilter' => '<p>Deletes a filter resource.</p>', 'DescribeOrganizationConfiguration' => '<p>Describe Amazon Inspector configuration settings for an Amazon Web Services organization.</p>', 'Disable' => '<p>Disables Amazon Inspector scans for one or more Amazon Web Services accounts. Disabling all scan types in an account disables the Amazon Inspector service.</p>', 'DisableDelegatedAdminAccount' => '<p>Disables the Amazon Inspector delegated administrator for your organization.</p>', 'DisassociateMember' => '<p>Disassociates a member account from an Amazon Inspector delegated administrator.</p>', 'Enable' => '<p>Enables Amazon Inspector scans for one or more Amazon Web Services accounts.</p>', 'EnableDelegatedAdminAccount' => '<p>Enables the Amazon Inspector delegated administrator for your Organizations organization.</p>', 'GetCisScanReport' => '<p>Retrieves a CIS scan report.</p>', 'GetCisScanResultDetails' => '<p>Retrieves CIS scan result details.</p>', 'GetConfiguration' => '<p>Retrieves setting configurations for Inspector scans.</p>', 'GetDelegatedAdminAccount' => '<p>Retrieves information about the Amazon Inspector delegated administrator for your organization.</p>', 'GetEc2DeepInspectionConfiguration' => '<p>Retrieves the activation status of Amazon Inspector deep inspection and custom paths associated with your account. </p>', 'GetEncryptionKey' => '<p>Gets an encryption key.</p>', 'GetFindingsReportStatus' => '<p>Gets the status of a findings report.</p>', 'GetMember' => '<p>Gets member information for your organization.</p>', 'GetSbomExport' => '<p>Gets details of a software bill of materials (SBOM) report.</p>', 'ListAccountPermissions' => '<p>Lists the permissions an account has to configure Amazon Inspector.</p>', 'ListCisScanConfigurations' => '<p>Lists CIS scan configurations.</p>', 'ListCisScanResultsAggregatedByChecks' => '<p>Lists scan results aggregated by checks.</p>', 'ListCisScanResultsAggregatedByTargetResource' => '<p>Lists scan results aggregated by a target resource.</p>', 'ListCisScans' => '<p>Returns a CIS scan list.</p>', 'ListCoverage' => '<p>Lists coverage details for you environment.</p>', 'ListCoverageStatistics' => '<p>Lists Amazon Inspector coverage statistics for your environment.</p>', 'ListDelegatedAdminAccounts' => '<p>Lists information about the Amazon Inspector delegated administrator of your organization.</p>', 'ListFilters' => '<p>Lists the filters associated with your account.</p>', 'ListFindingAggregations' => '<p>Lists aggregated finding data for your environment based on specific criteria.</p>', 'ListFindings' => '<p>Lists findings for your environment.</p>', 'ListMembers' => '<p>List members associated with the Amazon Inspector delegated administrator for your organization.</p>', 'ListTagsForResource' => '<p>Lists all tags attached to a given resource.</p>', 'ListUsageTotals' => '<p>Lists the Amazon Inspector usage totals over the last 30 days.</p>', 'ResetEncryptionKey' => '<p>Resets an encryption key. After the key is reset your resources will be encrypted by an Amazon Web Services owned key.</p>', 'SearchVulnerabilities' => '<p>Lists Amazon Inspector coverage details for a specific vulnerability.</p>', 'SendCisSessionHealth' => '<p> Sends a CIS session health. This API is used by the Amazon Inspector SSM plugin to communicate with the Amazon Inspector service. The Amazon Inspector SSM plugin calls this API to start a CIS scan session for the scan ID supplied by the service. </p>', 'SendCisSessionTelemetry' => '<p> Sends a CIS session telemetry. This API is used by the Amazon Inspector SSM plugin to communicate with the Amazon Inspector service. The Amazon Inspector SSM plugin calls this API to start a CIS scan session for the scan ID supplied by the service. </p>', 'StartCisSession' => '<p> Starts a CIS session. This API is used by the Amazon Inspector SSM plugin to communicate with the Amazon Inspector service. The Amazon Inspector SSM plugin calls this API to start a CIS scan session for the scan ID supplied by the service. </p>', 'StopCisSession' => '<p> Stops a CIS session. This API is used by the Amazon Inspector SSM plugin to communicate with the Amazon Inspector service. The Amazon Inspector SSM plugin calls this API to start a CIS scan session for the scan ID supplied by the service. </p>', 'TagResource' => '<p>Adds tags to a resource.</p>', 'UntagResource' => '<p>Removes tags from a resource.</p>', 'UpdateCisScanConfiguration' => '<p>Updates a CIS scan configuration.</p>', 'UpdateConfiguration' => '<p>Updates setting configurations for your Amazon Inspector account. When you use this API as an Amazon Inspector delegated administrator this updates the setting for all accounts you manage. Member accounts in an organization cannot update this setting.</p>', 'UpdateEc2DeepInspectionConfiguration' => '<p>Activates, deactivates Amazon Inspector deep inspection, or updates custom paths for your account. </p>', 'UpdateEncryptionKey' => '<p>Updates an encryption key. A <code>ResourceNotFoundException</code> means that an Amazon Web Services owned key is being used for encryption.</p>', 'UpdateFilter' => '<p>Specifies the action that is to be applied to the findings that match the filter.</p>', 'UpdateOrgEc2DeepInspectionConfiguration' => '<p>Updates the Amazon Inspector deep inspection custom paths for your organization. You must be an Amazon Inspector delegated administrator to use this API.</p>', 'UpdateOrganizationConfiguration' => '<p>Updates the configurations for your Amazon Inspector organization.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You do not have sufficient access to perform this action.</p>', 'refs' => [], ], 'Account' => [ 'base' => '<p>An Amazon Web Services account within your environment that Amazon Inspector has been enabled for.</p>', 'refs' => [ 'AccountList$member' => NULL, ], ], 'AccountAggregation' => [ 'base' => '<p>An object that contains details about an aggregation response based on Amazon Web Services accounts.</p>', 'refs' => [ 'AggregationRequest$accountAggregation' => '<p>An object that contains details about an aggregation request based on Amazon Web Services account IDs.</p>', ], ], 'AccountAggregationResponse' => [ 'base' => '<p>An aggregation of findings by Amazon Web Services account ID.</p>', 'refs' => [ 'AggregationResponse$accountAggregation' => '<p>An object that contains details about an aggregation response based on Amazon Web Services account IDs.</p>', ], ], 'AccountId' => [ 'base' => NULL, 'refs' => [ 'Account$accountId' => '<p>The ID of the Amazon Web Services account.</p>', 'AccountAggregationResponse$accountId' => '<p>The Amazon Web Services account ID.</p>', 'AccountIdSet$member' => NULL, 'AccountState$accountId' => '<p>The Amazon Web Services account ID.</p>', 'AmiAggregationResponse$accountId' => '<p>The Amazon Web Services account ID for the AMI.</p>', 'AssociateMemberRequest$accountId' => '<p>The Amazon Web Services account ID of the member account to be associated.</p>', 'AssociateMemberResponse$accountId' => '<p>The Amazon Web Services account ID of the successfully associated member account.</p>', 'AwsEcrContainerAggregationResponse$accountId' => '<p>The Amazon Web Services account ID of the account that owns the container.</p>', 'CisAccountIdList$member' => NULL, 'CisCheckAggregation$accountId' => '<p>The account ID for the CIS check.</p>', 'CisScanResultDetails$accountId' => '<p>The CIS scan result details\' account ID.</p>', 'CisTargetResourceAggregation$accountId' => '<p>The account ID for the CIS target resource.</p>', 'CoveredResource$accountId' => '<p>The Amazon Web Services account ID of the covered resource.</p>', 'DelegatedAdmin$accountId' => '<p>The Amazon Web Services account ID of the Amazon Inspector delegated administrator for your organization.</p>', 'DelegatedAdminAccount$accountId' => '<p>The Amazon Web Services account ID of the Amazon Inspector delegated administrator for your organization.</p>', 'DisableDelegatedAdminAccountRequest$delegatedAdminAccountId' => '<p>The Amazon Web Services account ID of the current Amazon Inspector delegated administrator.</p>', 'DisableDelegatedAdminAccountResponse$delegatedAdminAccountId' => '<p>The Amazon Web Services account ID of the successfully disabled delegated administrator.</p>', 'DisassociateMemberRequest$accountId' => '<p>The Amazon Web Services account ID of the member account to disassociate.</p>', 'DisassociateMemberResponse$accountId' => '<p>The Amazon Web Services account ID of the successfully disassociated member.</p>', 'EnableDelegatedAdminAccountRequest$delegatedAdminAccountId' => '<p>The Amazon Web Services account ID of the Amazon Inspector delegated administrator.</p>', 'EnableDelegatedAdminAccountResponse$delegatedAdminAccountId' => '<p>The Amazon Web Services account ID of the successfully Amazon Inspector delegated administrator.</p>', 'FailedAccount$accountId' => '<p>The Amazon Web Services account ID.</p>', 'FailedMemberAccountEc2DeepInspectionStatusState$accountId' => '<p>The unique identifier for the Amazon Web Services account of the organization member that failed to activate Amazon Inspector deep inspection.</p>', 'Finding$awsAccountId' => '<p>The Amazon Web Services account ID associated with the finding.</p>', 'FindingTypeAggregationResponse$accountId' => '<p>The ID of the Amazon Web Services account associated with the findings.</p>', 'GetCisScanResultDetailsRequest$accountId' => '<p>The account ID.</p>', 'GetMemberRequest$accountId' => '<p>The Amazon Web Services account ID of the member account to retrieve information on.</p>', 'ImageLayerAggregationResponse$accountId' => '<p>The ID of the Amazon Web Services account that owns the container image hosting the layer image.</p>', 'LambdaFunctionAggregationResponse$accountId' => '<p>The ID of the Amazon Web Services account that owns the Amazon Web Services Lambda function. </p>', 'LambdaLayerAggregationResponse$accountId' => '<p>The account ID of the Amazon Web Services Lambda function layer.</p>', 'Member$accountId' => '<p>The Amazon Web Services account ID of the member account.</p>', 'Member$delegatedAdminAccountId' => '<p>The Amazon Web Services account ID of the Amazon Inspector delegated administrator for this member account.</p>', 'MemberAccountEc2DeepInspectionStatus$accountId' => '<p>The unique identifier for the Amazon Web Services account of the organization member.</p>', 'MemberAccountEc2DeepInspectionStatusState$accountId' => '<p>The unique identifier for the Amazon Web Services account of the organization member</p>', 'PackageAggregationResponse$accountId' => '<p>The ID of the Amazon Web Services account associated with the findings.</p>', 'ReportTargetAccounts$member' => NULL, 'RepositoryAggregationResponse$accountId' => '<p>The ID of the Amazon Web Services account associated with the findings.</p>', 'TitleAggregationResponse$accountId' => '<p>The ID of the Amazon Web Services account associated with the findings.</p>', ], ], 'AccountIdFilterList' => [ 'base' => NULL, 'refs' => [ 'CisScanResultsAggregatedByTargetResourceFilterCriteria$accountIdFilters' => '<p>The criteria\'s account ID filters.</p>', 'ListCisScansFilterCriteria$targetAccountIdFilters' => '<p>The list of target account ID filters.</p>', ], ], 'AccountIdSet' => [ 'base' => NULL, 'refs' => [ 'BatchGetAccountStatusRequest$accountIds' => '<p>The 12-digit Amazon Web Services account IDs of the accounts to retrieve Amazon Inspector status for.</p>', 'BatchGetMemberEc2DeepInspectionStatusRequest$accountIds' => '<p>The unique identifiers for the Amazon Web Services accounts to retrieve Amazon Inspector deep inspection activation status for. <pre><code> &lt;/p&gt; </code></pre>', 'DisableRequest$accountIds' => '<p>An array of account IDs you want to disable Amazon Inspector scans for.</p>', 'EnableRequest$accountIds' => '<p>A list of account IDs you want to enable Amazon Inspector scans for.</p>', ], ], 'AccountList' => [ 'base' => NULL, 'refs' => [ 'DisableResponse$accounts' => '<p>Information on the accounts that have had Amazon Inspector scans successfully disabled. Details are provided for each account.</p>', 'EnableResponse$accounts' => '<p>Information on the accounts that have had Amazon Inspector scans successfully enabled. Details are provided for each account.</p>', ], ], 'AccountSortBy' => [ 'base' => NULL, 'refs' => [ 'AccountAggregation$sortBy' => '<p>The value to sort by.</p>', ], ], 'AccountState' => [ 'base' => '<p>An object with details the status of an Amazon Web Services account within your Amazon Inspector environment.</p>', 'refs' => [ 'AccountStateList$member' => NULL, ], ], 'AccountStateList' => [ 'base' => NULL, 'refs' => [ 'BatchGetAccountStatusResponse$accounts' => '<p>An array of objects that provide details on the status of Amazon Inspector for each of the requested accounts.</p>', ], ], 'AggCounts' => [ 'base' => NULL, 'refs' => [ 'Counts$count' => '<p>The number of resources.</p>', ], ], 'AggregationFindingType' => [ 'base' => NULL, 'refs' => [ 'AccountAggregation$findingType' => '<p>The type of finding.</p>', 'FindingTypeAggregation$findingType' => '<p>The finding type to aggregate.</p>', 'TitleAggregation$findingType' => '<p>The type of finding to aggregate on.</p>', ], ], 'AggregationRequest' => [ 'base' => '<p>Contains details about an aggregation request.</p>', 'refs' => [ 'ListFindingAggregationsRequest$aggregationRequest' => '<p>Details of the aggregation request that is used to filter your aggregation results.</p>', ], ], 'AggregationResourceType' => [ 'base' => NULL, 'refs' => [ 'AccountAggregation$resourceType' => '<p>The type of resource.</p>', 'FindingTypeAggregation$resourceType' => '<p>The resource type to aggregate.</p>', 'TitleAggregation$resourceType' => '<p>The resource type to aggregate on.</p>', ], ], 'AggregationResponse' => [ 'base' => '<p>A structure that contains details about the results of an aggregation type.</p>', 'refs' => [ 'AggregationResponseList$member' => NULL, ], ], 'AggregationResponseList' => [ 'base' => NULL, 'refs' => [ 'ListFindingAggregationsResponse$responses' => '<p>Objects that contain the results of an aggregation operation.</p>', ], ], 'AggregationType' => [ 'base' => NULL, 'refs' => [ 'ListFindingAggregationsRequest$aggregationType' => '<p>The type of the aggregation request.</p>', 'ListFindingAggregationsResponse$aggregationType' => '<p>The type of aggregation to perform.</p>', ], ], 'AmiAggregation' => [ 'base' => '<p>The details that define an aggregation based on Amazon machine images (AMIs).</p>', 'refs' => [ 'AggregationRequest$amiAggregation' => '<p>An object that contains details about an aggregation request based on Amazon Machine Images (AMIs).</p>', ], ], 'AmiAggregationResponse' => [ 'base' => '<p>A response that contains the results of a finding aggregation by AMI.</p>', 'refs' => [ 'AggregationResponse$amiAggregation' => '<p>An object that contains details about an aggregation response based on Amazon Machine Images (AMIs).</p>', ], ], 'AmiId' => [ 'base' => NULL, 'refs' => [ 'AmiAggregationResponse$ami' => '<p>The ID of the AMI that findings were aggregated for.</p>', 'Ec2InstanceAggregationResponse$ami' => '<p>The Amazon Machine Image (AMI) of the Amazon EC2 instance.</p>', 'Ec2Metadata$amiId' => '<p>The ID of the Amazon Machine Image (AMI) used to launch the instance.</p>', ], ], 'AmiSortBy' => [ 'base' => NULL, 'refs' => [ 'AmiAggregation$sortBy' => '<p>The value to sort results by.</p>', ], ], 'Architecture' => [ 'base' => NULL, 'refs' => [ 'ArchitectureList$member' => NULL, ], ], 'ArchitectureList' => [ 'base' => NULL, 'refs' => [ 'AwsLambdaFunctionDetails$architectures' => '<p>The instruction set architecture that the Amazon Web Services Lambda function supports. Architecture is a string array with one of the valid values. The default architecture value is <code>x86_64</code>.</p>', ], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$resourceArn' => '<p>The Amazon resource number (ARN) of the resource to list tags of.</p>', 'TagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource to apply a tag to.</p>', 'UntagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) for the resource to remove tags from.</p>', ], ], 'AssociateMemberRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateMemberResponse' => [ 'base' => NULL, 'refs' => [], ], 'AtigData' => [ 'base' => '<p>The Amazon Web Services Threat Intel Group (ATIG) details for a specific vulnerability.</p>', 'refs' => [ 'Vulnerability$atigData' => '<p>An object that contains information about the Amazon Web Services Threat Intel Group (ATIG) details for the vulnerability.</p>', ], ], 'AutoEnable' => [ 'base' => '<p>Represents which scan types are automatically enabled for new members of your Amazon Inspector organization.</p>', 'refs' => [ 'DescribeOrganizationConfigurationResponse$autoEnable' => '<p>The scan types are automatically enabled for new members of your organization.</p>', 'UpdateOrganizationConfigurationRequest$autoEnable' => '<p>Defines which scan types are enabled automatically for new members of your Amazon Inspector organization.</p>', 'UpdateOrganizationConfigurationResponse$autoEnable' => '<p>The updated status of scan types automatically enabled for new members of your Amazon Inspector organization.</p>', ], ], 'AwsEc2InstanceDetails' => [ 'base' => '<p>Details of the Amazon EC2 instance involved in a finding.</p>', 'refs' => [ 'ResourceDetails$awsEc2Instance' => '<p>An object that contains details about the Amazon EC2 instance involved in the finding.</p>', ], ], 'AwsEcrContainerAggregation' => [ 'base' => '<p>An aggregation of information about Amazon ECR containers.</p>', 'refs' => [ 'AggregationRequest$awsEcrContainerAggregation' => '<p>An object that contains details about an aggregation request based on Amazon ECR container images.</p>', ], ], 'AwsEcrContainerAggregationResponse' => [ 'base' => '<p>An aggregation of information about Amazon ECR containers.</p>', 'refs' => [ 'AggregationResponse$awsEcrContainerAggregation' => '<p>An object that contains details about an aggregation response based on Amazon ECR container images.</p>', ], ], 'AwsEcrContainerImageDetails' => [ 'base' => '<p>The image details of the Amazon ECR container image.</p>', 'refs' => [ 'ResourceDetails$awsEcrContainerImage' => '<p>An object that contains details about the Amazon ECR container image involved in the finding.</p>', ], ], 'AwsEcrContainerSortBy' => [ 'base' => NULL, 'refs' => [ 'AwsEcrContainerAggregation$sortBy' => '<p>The value to sort by.</p>', ], ], 'AwsLambdaFunctionDetails' => [ 'base' => '<p> A summary of information about the Amazon Web Services Lambda function.</p>', 'refs' => [ 'ResourceDetails$awsLambdaFunction' => '<p>A summary of the information about an Amazon Web Services Lambda function affected by a finding.</p>', ], ], 'BadRequestException' => [ 'base' => '<p>One or more tags submitted as part of the request is not valid.</p>', 'refs' => [], ], 'BatchGetAccountStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetAccountStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetCodeSnippetRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetCodeSnippetRequestFindingArnsList' => [ 'base' => NULL, 'refs' => [ 'BatchGetCodeSnippetRequest$findingArns' => '<p>An array of finding ARNs for the findings you want to retrieve code snippets from.</p>', ], ], 'BatchGetCodeSnippetResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetFindingDetailsRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetFindingDetailsResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetFreeTrialInfoRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetFreeTrialInfoRequestAccountIdsList' => [ 'base' => NULL, 'refs' => [ 'BatchGetFreeTrialInfoRequest$accountIds' => '<p>The account IDs to get free trial status for.</p>', ], ], 'BatchGetFreeTrialInfoResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetMemberEc2DeepInspectionStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetMemberEc2DeepInspectionStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchUpdateMemberEc2DeepInspectionStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchUpdateMemberEc2DeepInspectionStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'BenchmarkProfile' => [ 'base' => NULL, 'refs' => [ 'StopCisSessionMessage$benchmarkProfile' => '<p>The message benchmark profile.</p>', ], ], 'BenchmarkVersion' => [ 'base' => NULL, 'refs' => [ 'StopCisSessionMessage$benchmarkVersion' => '<p>The message benchmark version.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'AutoEnable$ec2' => '<p>Represents whether Amazon EC2 scans are automatically enabled for new members of your Amazon Inspector organization.</p>', 'AutoEnable$ecr' => '<p>Represents whether Amazon ECR scans are automatically enabled for new members of your Amazon Inspector organization.</p>', 'AutoEnable$lambda' => '<p>Represents whether Amazon Web Services Lambda standard scans are automatically enabled for new members of your Amazon Inspector organization. </p>', 'AutoEnable$lambdaCode' => '<p>Represents whether Lambda code scans are automatically enabled for new members of your Amazon Inspector organization. <pre><code> &lt;/p&gt; </code></pre>', 'DescribeOrganizationConfigurationResponse$maxAccountLimitReached' => '<p>Represents whether your organization has reached the maximum Amazon Web Services account limit for Amazon Inspector.</p>', 'ListMembersRequest$onlyAssociated' => '<p>Specifies whether to list only currently associated members if <code>True</code> or to list all members within the organization if <code>False</code>.</p>', 'MemberAccountEc2DeepInspectionStatus$activateDeepInspection' => '<p>Whether Amazon Inspector deep inspection is active in the account. If <code>TRUE</code> Amazon Inspector deep inspection is active, if <code>FALSE</code> it is not active.</p>', 'UpdateEc2DeepInspectionConfigurationRequest$activateDeepInspection' => '<p>Specify <code>TRUE</code> to activate Amazon Inspector deep inspection in your account, or <code>FALSE</code> to deactivate. Member accounts in an organization cannot deactivate deep inspection, instead the delegated administrator for the organization can deactivate a member account using <a href="https://docs.aws.amazon.com/inspector/v2/APIReference/API_BatchUpdateMemberEc2DeepInspectionStatus.html">BatchUpdateMemberEc2DeepInspectionStatus</a>.</p>', ], ], 'CancelFindingsReportRequest' => [ 'base' => NULL, 'refs' => [], ], 'CancelFindingsReportResponse' => [ 'base' => NULL, 'refs' => [], ], 'CancelSbomExportRequest' => [ 'base' => NULL, 'refs' => [], ], 'CancelSbomExportResponse' => [ 'base' => NULL, 'refs' => [], ], 'CheckCount' => [ 'base' => NULL, 'refs' => [ 'StopCisMessageProgress$errorChecks' => '<p>The progress\' error checks.</p>', 'StopCisMessageProgress$failedChecks' => '<p>The progress\' failed checks.</p>', 'StopCisMessageProgress$informationalChecks' => '<p>The progress\' informational checks.</p>', 'StopCisMessageProgress$notApplicableChecks' => '<p>The progress\' not applicable checks.</p>', 'StopCisMessageProgress$notEvaluatedChecks' => '<p>The progress\' not evaluated checks.</p>', 'StopCisMessageProgress$successfulChecks' => '<p>The progress\' successful checks.</p>', 'StopCisMessageProgress$totalChecks' => '<p>The progress\' total checks.</p>', 'StopCisMessageProgress$unknownChecks' => '<p>The progress\' unknown checks.</p>', ], ], 'CheckIdFilterList' => [ 'base' => NULL, 'refs' => [ 'CisScanResultDetailsFilterCriteria$checkIdFilters' => '<p>The criteria\'s check ID filters.</p>', 'CisScanResultsAggregatedByChecksFilterCriteria$checkIdFilters' => '<p>The criteria\'s check ID filters.</p>', 'CisScanResultsAggregatedByTargetResourceFilterCriteria$checkIdFilters' => '<p>The criteria\'s check ID filters.</p>', ], ], 'CisAccountIdList' => [ 'base' => NULL, 'refs' => [ 'CisTargets$accountIds' => '<p>The CIS target account ids.</p>', ], ], 'CisCheckAggregation' => [ 'base' => '<p>A CIS check.</p>', 'refs' => [ 'CisCheckAggregationList$member' => NULL, ], ], 'CisCheckAggregationList' => [ 'base' => NULL, 'refs' => [ 'ListCisScanResultsAggregatedByChecksResponse$checkAggregations' => '<p>The check aggregations.</p>', ], ], 'CisDateFilter' => [ 'base' => '<p>The CIS date filter.</p>', 'refs' => [ 'CisScanDateFilterList$member' => NULL, ], ], 'CisFindingArn' => [ 'base' => NULL, 'refs' => [ 'CisScanResultDetails$findingArn' => '<p>The CIS scan result details\' finding ARN.</p>', ], ], 'CisFindingArnFilterList' => [ 'base' => NULL, 'refs' => [ 'CisScanResultDetailsFilterCriteria$findingArnFilters' => '<p>The criteria\'s finding ARN filters.</p>', ], ], 'CisFindingStatus' => [ 'base' => NULL, 'refs' => [ 'CisFindingStatusFilter$value' => '<p>The value of the CIS finding status filter.</p>', 'CisScanResultDetails$status' => '<p>The CIS scan result details\' status.</p>', ], ], 'CisFindingStatusComparison' => [ 'base' => NULL, 'refs' => [ 'CisFindingStatusFilter$comparison' => '<p>The comparison value of the CIS finding status filter.</p>', ], ], 'CisFindingStatusFilter' => [ 'base' => '<p>The CIS finding status filter.</p>', 'refs' => [ 'CisFindingStatusFilterList$member' => NULL, ], ], 'CisFindingStatusFilterList' => [ 'base' => NULL, 'refs' => [ 'CisScanResultDetailsFilterCriteria$findingStatusFilters' => '<p>The criteria\'s finding status filters.</p>', ], ], 'CisNumberFilter' => [ 'base' => '<p>The CIS number filter.</p>', 'refs' => [ 'CisNumberFilterList$member' => NULL, ], ], 'CisNumberFilterList' => [ 'base' => NULL, 'refs' => [ 'CisScanResultsAggregatedByChecksFilterCriteria$failedResourcesFilters' => '<p>The criteria\'s failed resources filters.</p>', 'CisScanResultsAggregatedByTargetResourceFilterCriteria$failedChecksFilters' => '<p>The criteria\'s failed checks filters.</p>', 'ListCisScansFilterCriteria$failedChecksFilters' => '<p>The list of failed checks filters.</p>', ], ], 'CisOwnerId' => [ 'base' => NULL, 'refs' => [ 'CisScanConfiguration$ownerId' => '<p>The CIS scan configuration\'s owner ID.</p>', ], ], 'CisReportFormat' => [ 'base' => NULL, 'refs' => [ 'GetCisScanReportRequest$reportFormat' => '<p> The format of the report. Valid values are <code>PDF</code> and <code>CSV</code>. If no value is specified, the report format defaults to <code>PDF</code>. </p>', ], ], 'CisReportStatus' => [ 'base' => NULL, 'refs' => [ 'GetCisScanReportResponse$status' => '<p>The status.</p>', ], ], 'CisResultStatus' => [ 'base' => NULL, 'refs' => [ 'CisResultStatusFilter$value' => '<p>The value of the CIS result status filter.</p>', ], ], 'CisResultStatusComparison' => [ 'base' => NULL, 'refs' => [ 'CisResultStatusFilter$comparison' => '<p>The comparison value of the CIS result status filter.</p>', ], ], 'CisResultStatusFilter' => [ 'base' => '<p>The CIS result status filter.</p>', 'refs' => [ 'CisResultStatusFilterList$member' => NULL, ], ], 'CisResultStatusFilterList' => [ 'base' => NULL, 'refs' => [ 'CisScanResultsAggregatedByTargetResourceFilterCriteria$statusFilters' => '<p>The criteria\'s status filter.</p>', ], ], 'CisRuleDetails' => [ 'base' => NULL, 'refs' => [ 'CisSessionMessage$cisRuleDetails' => '<p>The CIS rule details for the CIS session message.</p>', ], ], 'CisRuleStatus' => [ 'base' => NULL, 'refs' => [ 'CisSessionMessage$status' => '<p>The status of the CIS session message.</p>', ], ], 'CisScan' => [ 'base' => '<p>The CIS scan.</p>', 'refs' => [ 'CisScanList$member' => NULL, ], ], 'CisScanArn' => [ 'base' => NULL, 'refs' => [ 'CisCheckAggregation$scanArn' => '<p>The scan ARN for the CIS check scan ARN.</p>', 'CisScan$scanArn' => '<p>The CIS scan\'s ARN.</p>', 'CisScanResultDetails$scanArn' => '<p>The CIS scan result details\' scan ARN.</p>', 'CisTargetResourceAggregation$scanArn' => '<p>The scan ARN for the CIS target resource.</p>', 'GetCisScanReportRequest$scanArn' => '<p>The scan ARN.</p>', 'GetCisScanResultDetailsRequest$scanArn' => '<p>The scan ARN.</p>', 'ListCisScanResultsAggregatedByChecksRequest$scanArn' => '<p>The scan ARN.</p>', 'ListCisScanResultsAggregatedByTargetResourceRequest$scanArn' => '<p>The scan ARN.</p>', ], ], 'CisScanArnFilterList' => [ 'base' => NULL, 'refs' => [ 'ListCisScansFilterCriteria$scanArnFilters' => '<p>The list of scan ARN filters.</p>', ], ], 'CisScanConfiguration' => [ 'base' => '<p>The CIS scan configuration.</p>', 'refs' => [ 'CisScanConfigurationList$member' => NULL, ], ], 'CisScanConfigurationArn' => [ 'base' => NULL, 'refs' => [ 'CisScan$scanConfigurationArn' => '<p>The CIS scan\'s configuration ARN.</p>', 'CisScanConfiguration$scanConfigurationArn' => '<p>The CIS scan configuration\'s scan configuration ARN.</p>', 'CreateCisScanConfigurationResponse$scanConfigurationArn' => '<p>The scan configuration ARN for the CIS scan configuration.</p>', 'DeleteCisScanConfigurationRequest$scanConfigurationArn' => '<p>The ARN of the CIS scan configuration.</p>', 'DeleteCisScanConfigurationResponse$scanConfigurationArn' => '<p>The ARN of the CIS scan configuration.</p>', 'UpdateCisScanConfigurationRequest$scanConfigurationArn' => '<p>The CIS scan configuration ARN.</p>', 'UpdateCisScanConfigurationResponse$scanConfigurationArn' => '<p>The CIS scan configuration ARN.</p>', ], ], 'CisScanConfigurationArnFilterList' => [ 'base' => NULL, 'refs' => [ 'ListCisScanConfigurationsFilterCriteria$scanConfigurationArnFilters' => '<p>The list of scan configuration ARN filters.</p>', 'ListCisScansFilterCriteria$scanConfigurationArnFilters' => '<p>The list of scan configuration ARN filters.</p>', ], ], 'CisScanConfigurationList' => [ 'base' => NULL, 'refs' => [ 'ListCisScanConfigurationsResponse$scanConfigurations' => '<p>The CIS scan configuration scan configurations.</p>', ], ], 'CisScanConfigurationsSortBy' => [ 'base' => NULL, 'refs' => [ 'ListCisScanConfigurationsRequest$sortBy' => '<p>The CIS scan configuration sort by order.</p>', ], ], 'CisScanDateFilterList' => [ 'base' => NULL, 'refs' => [ 'ListCisScansFilterCriteria$scanAtFilters' => '<p>The list of scan at filters.</p>', ], ], 'CisScanList' => [ 'base' => NULL, 'refs' => [ 'ListCisScansResponse$scans' => '<p>The CIS scans.</p>', ], ], 'CisScanName' => [ 'base' => NULL, 'refs' => [ 'CisScan$scanName' => '<p>The the name of the scan configuration that\'s associated with this scan.</p>', 'CisScanConfiguration$scanName' => '<p>The name of the CIS scan configuration.</p>', 'CreateCisScanConfigurationRequest$scanName' => '<p>The scan name for the CIS scan configuration.</p>', 'UpdateCisScanConfigurationRequest$scanName' => '<p>The scan name for the CIS scan configuration.</p>', ], ], 'CisScanNameFilterList' => [ 'base' => NULL, 'refs' => [ 'ListCisScanConfigurationsFilterCriteria$scanNameFilters' => '<p>The list of scan name filters.</p>', 'ListCisScansFilterCriteria$scanNameFilters' => '<p>The list of scan name filters.</p>', ], ], 'CisScanResultDetails' => [ 'base' => '<p>The CIS scan result details.</p>', 'refs' => [ 'CisScanResultDetailsList$member' => NULL, ], ], 'CisScanResultDetailsFilterCriteria' => [ 'base' => '<p>The CIS scan result details filter criteria.</p>', 'refs' => [ 'GetCisScanResultDetailsRequest$filterCriteria' => '<p>The filter criteria.</p>', ], ], 'CisScanResultDetailsList' => [ 'base' => NULL, 'refs' => [ 'GetCisScanResultDetailsResponse$scanResultDetails' => '<p>The scan result details.</p>', ], ], 'CisScanResultDetailsSortBy' => [ 'base' => NULL, 'refs' => [ 'GetCisScanResultDetailsRequest$sortBy' => '<p>The sort by order.</p>', ], ], 'CisScanResultsAggregatedByChecksFilterCriteria' => [ 'base' => '<p>The scan results aggregated by checks filter criteria.</p>', 'refs' => [ 'ListCisScanResultsAggregatedByChecksRequest$filterCriteria' => '<p>The filter criteria.</p>', ], ], 'CisScanResultsAggregatedByChecksSortBy' => [ 'base' => NULL, 'refs' => [ 'ListCisScanResultsAggregatedByChecksRequest$sortBy' => '<p>The sort by order.</p>', ], ], 'CisScanResultsAggregatedByTargetResourceFilterCriteria' => [ 'base' => '<p>The scan results aggregated by target resource filter criteria.</p>', 'refs' => [ 'ListCisScanResultsAggregatedByTargetResourceRequest$filterCriteria' => '<p>The filter criteria.</p>', ], ], 'CisScanResultsAggregatedByTargetResourceSortBy' => [ 'base' => NULL, 'refs' => [ 'ListCisScanResultsAggregatedByTargetResourceRequest$sortBy' => '<p>The sort by order.</p>', ], ], 'CisScanResultsMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListCisScanResultsAggregatedByChecksRequest$maxResults' => '<p>The maximum number of scan results aggregated by checks to be returned in a single page of results.</p>', 'ListCisScanResultsAggregatedByTargetResourceRequest$maxResults' => '<p>The maximum number of scan results aggregated by a target resource to be returned in a single page of results.</p>', ], ], 'CisScanStatus' => [ 'base' => NULL, 'refs' => [ 'CisScan$status' => '<p>The CIS scan\'s status.</p>', 'CisScanStatusFilter$value' => '<p>The filter value.</p>', ], ], 'CisScanStatusComparison' => [ 'base' => NULL, 'refs' => [ 'CisScanStatusFilter$comparison' => '<p>The filter comparison value.</p>', ], ], 'CisScanStatusFilter' => [ 'base' => '<p>The CIS scan status filter.</p>', 'refs' => [ 'CisScanStatusFilterList$member' => NULL, ], ], 'CisScanStatusFilterList' => [ 'base' => NULL, 'refs' => [ 'ListCisScansFilterCriteria$scanStatusFilters' => '<p>The list of scan status filters.</p>', ], ], 'CisScheduledByFilterList' => [ 'base' => NULL, 'refs' => [ 'ListCisScansFilterCriteria$scheduledByFilters' => '<p>The list of scheduled by filters.</p>', ], ], 'CisSecurityLevel' => [ 'base' => NULL, 'refs' => [ 'CisCheckAggregation$level' => '<p>The CIS check level.</p>', 'CisScan$securityLevel' => '<p> The security level for the CIS scan. Security level refers to the Benchmark levels that CIS assigns to a profile. </p>', 'CisScanConfiguration$securityLevel' => '<p>The CIS scan configuration\'s security level.</p>', 'CisScanResultDetails$level' => '<p>The CIS scan result details\' level.</p>', 'CisSecurityLevelFilter$value' => '<p>The CIS security filter value.</p>', 'CreateCisScanConfigurationRequest$securityLevel' => '<p> The security level for the CIS scan configuration. Security level refers to the Benchmark levels that CIS assigns to a profile. </p>', 'UpdateCisScanConfigurationRequest$securityLevel' => '<p> The security level for the CIS scan configuration. Security level refers to the Benchmark levels that CIS assigns to a profile. </p>', ], ], 'CisSecurityLevelComparison' => [ 'base' => NULL, 'refs' => [ 'CisSecurityLevelFilter$comparison' => '<p>The CIS security filter comparison value.</p>', ], ], 'CisSecurityLevelFilter' => [ 'base' => '<p> The CIS security level filter. Security level refers to the Benchmark levels that CIS assigns to a profile. </p>', 'refs' => [ 'CisSecurityLevelFilterList$member' => NULL, ], ], 'CisSecurityLevelFilterList' => [ 'base' => NULL, 'refs' => [ 'CisScanResultDetailsFilterCriteria$securityLevelFilters' => '<p> The criteria\'s security level filters. . Security level refers to the Benchmark levels that CIS assigns to a profile. </p>', 'CisScanResultsAggregatedByChecksFilterCriteria$securityLevelFilters' => '<p>The criteria\'s security level filters.</p>', ], ], 'CisSessionMessage' => [ 'base' => '<p>The CIS session message.</p>', 'refs' => [ 'CisSessionMessages$member' => NULL, ], ], 'CisSessionMessages' => [ 'base' => NULL, 'refs' => [ 'SendCisSessionTelemetryRequest$messages' => '<p>The CIS session telemetry messages.</p>', ], ], 'CisSortOrder' => [ 'base' => NULL, 'refs' => [ 'GetCisScanResultDetailsRequest$sortOrder' => '<p>The sort order.</p>', 'ListCisScanConfigurationsRequest$sortOrder' => '<p>The CIS scan configuration sort order order.</p>', 'ListCisScanResultsAggregatedByChecksRequest$sortOrder' => '<p>The sort order.</p>', 'ListCisScanResultsAggregatedByTargetResourceRequest$sortOrder' => '<p>The sort order.</p>', 'ListCisScansRequest$sortOrder' => '<p>The CIS scans sort order.</p>', ], ], 'CisStringComparison' => [ 'base' => NULL, 'refs' => [ 'CisStringFilter$comparison' => '<p>The comparison value of the CIS string filter.</p>', ], ], 'CisStringFilter' => [ 'base' => '<p>The CIS string filter.</p>', 'refs' => [ 'AccountIdFilterList$member' => NULL, 'CheckIdFilterList$member' => NULL, 'CisFindingArnFilterList$member' => NULL, 'CisScanArnFilterList$member' => NULL, 'CisScanConfigurationArnFilterList$member' => NULL, 'CisScanNameFilterList$member' => NULL, 'CisScheduledByFilterList$member' => NULL, 'OneAccountIdFilterList$member' => NULL, 'PlatformFilterList$member' => NULL, 'ResourceIdFilterList$member' => NULL, 'TitleFilterList$member' => NULL, ], ], 'CisTagMap' => [ 'base' => NULL, 'refs' => [ 'CisScanConfiguration$tags' => '<p>The CIS scan configuration\'s tags.</p>', 'CreateCisScanConfigurationRequest$tags' => '<p>The tags for the CIS scan configuration.</p>', ], ], 'CisTargetResourceAggregation' => [ 'base' => '<p>The CIS target resource aggregation.</p>', 'refs' => [ 'CisTargetResourceAggregationList$member' => NULL, ], ], 'CisTargetResourceAggregationList' => [ 'base' => NULL, 'refs' => [ 'ListCisScanResultsAggregatedByTargetResourceResponse$targetResourceAggregations' => '<p>The resource aggregations.</p>', ], ], 'CisTargetStatus' => [ 'base' => NULL, 'refs' => [ 'CisTargetResourceAggregation$targetStatus' => '<p>The status of the target resource.</p>', 'CisTargetStatusFilter$value' => '<p>The value of the CIS target status filter.</p>', ], ], 'CisTargetStatusComparison' => [ 'base' => NULL, 'refs' => [ 'CisTargetStatusFilter$comparison' => '<p>The comparison value of the CIS target status filter.</p>', 'CisTargetStatusReasonFilter$comparison' => '<p>The comparison value of the CIS target status reason filter.</p>', ], ], 'CisTargetStatusFilter' => [ 'base' => '<p>The CIS target status filter.</p>', 'refs' => [ 'TargetStatusFilterList$member' => NULL, ], ], 'CisTargetStatusReason' => [ 'base' => NULL, 'refs' => [ 'CisTargetResourceAggregation$targetStatusReason' => '<p>The reason for the target resource.</p>', 'CisTargetStatusReasonFilter$value' => '<p>The value of the CIS target status reason filter.</p>', ], ], 'CisTargetStatusReasonFilter' => [ 'base' => '<p>The CIS target status reason filter.</p>', 'refs' => [ 'TargetStatusReasonFilterList$member' => NULL, ], ], 'CisTargets' => [ 'base' => '<p>The CIS targets.</p>', 'refs' => [ 'CisScan$targets' => '<p>The CIS scan\'s targets.</p>', 'CisScanConfiguration$targets' => '<p>The CIS scan configuration\'s targets.</p>', ], ], 'CisaAction' => [ 'base' => NULL, 'refs' => [ 'CisaData$action' => '<p>The remediation action recommended by CISA for this vulnerability.</p>', ], ], 'CisaData' => [ 'base' => '<p>The Cybersecurity and Infrastructure Security Agency (CISA) details for a specific vulnerability.</p>', 'refs' => [ 'FindingDetail$cisaData' => NULL, 'Vulnerability$cisaData' => '<p>An object that contains the Cybersecurity and Infrastructure Security Agency (CISA) details for the vulnerability.</p>', ], ], 'CisaDateAdded' => [ 'base' => NULL, 'refs' => [ 'CisaData$dateAdded' => '<p>The date and time CISA added this vulnerability to their catalogue.</p>', ], ], 'CisaDateDue' => [ 'base' => NULL, 'refs' => [ 'CisaData$dateDue' => '<p>The date and time CISA expects a fix to have been provided vulnerability.</p>', ], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'EnableDelegatedAdminAccountRequest$clientToken' => '<p>The idempotency token for the request.</p>', 'EnableRequest$clientToken' => '<p>The idempotency token for the request.</p>', ], ], 'CodeFilePath' => [ 'base' => '<p>Contains information on where a code vulnerability is located in your Lambda function.</p>', 'refs' => [ 'CodeVulnerabilityDetails$filePath' => '<p>Contains information on where the code vulnerability is located in your code.</p>', ], ], 'CodeLine' => [ 'base' => '<p>Contains information on the lines of code associated with a code snippet.</p>', 'refs' => [ 'CodeLineList$member' => NULL, ], ], 'CodeLineContentString' => [ 'base' => NULL, 'refs' => [ 'CodeLine$content' => '<p>The content of a line of code</p>', ], ], 'CodeLineList' => [ 'base' => NULL, 'refs' => [ 'CodeSnippetResult$codeSnippet' => '<p>Contains information on the retrieved code snippet.</p>', ], ], 'CodeSnippetError' => [ 'base' => '<p>Contains information about any errors encountered while trying to retrieve a code snippet.</p>', 'refs' => [ 'CodeSnippetErrorList$member' => NULL, ], ], 'CodeSnippetErrorCode' => [ 'base' => NULL, 'refs' => [ 'CodeSnippetError$errorCode' => '<p>The error code for the error that prevented a code snippet from being retrieved.</p>', ], ], 'CodeSnippetErrorList' => [ 'base' => NULL, 'refs' => [ 'BatchGetCodeSnippetResponse$errors' => '<p>Any errors Amazon Inspector encountered while trying to retrieve the requested code snippets.</p>', ], ], 'CodeSnippetResult' => [ 'base' => '<p>Contains information on a code snippet retrieved by Amazon Inspector from a code vulnerability finding.</p>', 'refs' => [ 'CodeSnippetResultList$member' => NULL, ], ], 'CodeSnippetResultList' => [ 'base' => NULL, 'refs' => [ 'BatchGetCodeSnippetResponse$codeSnippetResults' => '<p>The retrieved code snippets associated with the provided finding ARNs.</p>', ], ], 'CodeVulnerabilityDetails' => [ 'base' => '<p>Contains information on the code vulnerability identified in your Lambda function.</p>', 'refs' => [ 'Finding$codeVulnerabilityDetails' => '<p>Details about the code vulnerability identified in a Lambda function used to filter findings.</p>', ], ], 'Component' => [ 'base' => NULL, 'refs' => [ 'Step$componentId' => '<p>The component ID.</p>', ], ], 'ComponentType' => [ 'base' => NULL, 'refs' => [ 'Step$componentType' => '<p>The component type.</p>', ], ], 'ComputePlatform' => [ 'base' => '<p>A compute platform.</p>', 'refs' => [ 'StopCisSessionMessage$computePlatform' => '<p>The message compute platform.</p>', ], ], 'ConflictException' => [ 'base' => '<p>A conflict occurred.</p>', 'refs' => [], ], 'Counts' => [ 'base' => '<p>a structure that contains information on the count of resources within a group.</p>', 'refs' => [ 'CountsList$member' => NULL, ], ], 'CountsList' => [ 'base' => NULL, 'refs' => [ 'ListCoverageStatisticsResponse$countsByGroup' => '<p>An array with the number for each group.</p>', ], ], 'CoverageDateFilter' => [ 'base' => '<p>Contains details of a coverage date filter.</p>', 'refs' => [ 'CoverageDateFilterList$member' => NULL, ], ], 'CoverageDateFilterList' => [ 'base' => NULL, 'refs' => [ 'CoverageFilterCriteria$imagePulledAt' => '<p>The date an image was last pulled at.</p>', 'CoverageFilterCriteria$lastScannedAt' => '<p>Filters Amazon Web Services resources based on whether Amazon Inspector has checked them for vulnerabilities within the specified time range.</p>', ], ], 'CoverageFilterCriteria' => [ 'base' => '<p>A structure that identifies filter criteria for <code>GetCoverageStatistics</code>.</p>', 'refs' => [ 'ListCoverageRequest$filterCriteria' => '<p>An object that contains details on the filters to apply to the coverage data for your environment.</p>', 'ListCoverageStatisticsRequest$filterCriteria' => '<p>An object that contains details on the filters to apply to the coverage data for your environment.</p>', ], ], 'CoverageMapComparison' => [ 'base' => NULL, 'refs' => [ 'CoverageMapFilter$comparison' => '<p>The operator to compare coverage on.</p>', ], ], 'CoverageMapFilter' => [ 'base' => '<p>Contains details of a coverage map filter.</p>', 'refs' => [ 'CoverageMapFilterList$member' => NULL, ], ], 'CoverageMapFilterList' => [ 'base' => NULL, 'refs' => [ 'CoverageFilterCriteria$ec2InstanceTags' => '<p>The Amazon EC2 instance tags to filter on.</p>', 'CoverageFilterCriteria$lambdaFunctionTags' => '<p>Returns coverage statistics for Amazon Web Services Lambda functions filtered by tag.</p>', ], ], 'CoverageResourceType' => [ 'base' => NULL, 'refs' => [ 'CoveredResource$resourceType' => '<p>The type of the covered resource.</p>', ], ], 'CoverageStringComparison' => [ 'base' => NULL, 'refs' => [ 'CoverageStringFilter$comparison' => '<p>The operator to compare strings on.</p>', ], ], 'CoverageStringFilter' => [ 'base' => '<p>Contains details of a coverage string filter.</p>', 'refs' => [ 'CoverageStringFilterList$member' => NULL, ], ], 'CoverageStringFilterList' => [ 'base' => NULL, 'refs' => [ 'CoverageFilterCriteria$accountId' => '<p>An array of Amazon Web Services account IDs to return coverage statistics for.</p>', 'CoverageFilterCriteria$ecrImageTags' => '<p>The Amazon ECR image tags to filter on.</p>', 'CoverageFilterCriteria$ecrRepositoryName' => '<p>The Amazon ECR repository name to filter on.</p>', 'CoverageFilterCriteria$lambdaFunctionName' => '<p>Returns coverage statistics for Amazon Web Services Lambda functions filtered by function names.</p>', 'CoverageFilterCriteria$lambdaFunctionRuntime' => '<p>Returns coverage statistics for Amazon Web Services Lambda functions filtered by runtime.</p>', 'CoverageFilterCriteria$resourceId' => '<p>An array of Amazon Web Services resource IDs to return coverage statistics for.</p>', 'CoverageFilterCriteria$resourceType' => '<p>An array of Amazon Web Services resource types to return coverage statistics for. The values can be <code>AWS_EC2_INSTANCE</code>, <code>AWS_LAMBDA_FUNCTION</code>, <code>AWS_ECR_CONTAINER_IMAGE</code>, <code>AWS_ECR_REPOSITORY</code> or <code>AWS_ACCOUNT</code>.</p>', 'CoverageFilterCriteria$scanMode' => '<p>The filter to search for Amazon EC2 instance coverage by scan mode. Valid values are <code>EC2_SSM_AGENT_BASED</code> and <code>EC2_HYBRID</code>.</p>', 'CoverageFilterCriteria$scanStatusCode' => '<p>The scan status code to filter on. Valid values are: <code>ValidationException</code>, <code>InternalServerException</code>, <code>ResourceNotFoundException</code>, <code>BadRequestException</code>, and <code>ThrottlingException</code>.</p>', 'CoverageFilterCriteria$scanStatusReason' => '<p>The scan status reason to filter on.</p>', 'CoverageFilterCriteria$scanType' => '<p>An array of Amazon Inspector scan types to return coverage statistics for.</p>', ], ], 'CoverageStringInput' => [ 'base' => NULL, 'refs' => [ 'CoverageStringFilter$value' => '<p>The value to compare strings on.</p>', ], ], 'CoveredResource' => [ 'base' => '<p>An object that contains details about a resource covered by Amazon Inspector.</p>', 'refs' => [ 'CoveredResources$member' => NULL, ], ], 'CoveredResources' => [ 'base' => NULL, 'refs' => [ 'ListCoverageResponse$coveredResources' => '<p>An object that contains details on the covered resources in your environment.</p>', ], ], 'CreateCisScanConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateCisScanConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateCisTargets' => [ 'base' => '<p>Creates CIS targets.</p>', 'refs' => [ 'CreateCisScanConfigurationRequest$targets' => '<p>The targets for the CIS scan configuration.</p>', ], ], 'CreateFilterRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateFilterResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateFindingsReportRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateFindingsReportResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateSbomExportRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSbomExportResponse' => [ 'base' => NULL, 'refs' => [], ], 'Currency' => [ 'base' => NULL, 'refs' => [ 'Usage$currency' => '<p>The currency type used when calculating usage data.</p>', ], ], 'Cvss2' => [ 'base' => '<p>The Common Vulnerability Scoring System (CVSS) version 2 details for the vulnerability.</p>', 'refs' => [ 'Vulnerability$cvss2' => '<p>An object that contains the Common Vulnerability Scoring System (CVSS) Version 2 details for the vulnerability.</p>', ], ], 'Cvss2BaseScore' => [ 'base' => NULL, 'refs' => [ 'Cvss2$baseScore' => '<p>The CVSS v2 base score for the vulnerability.</p>', ], ], 'Cvss2ScoringVector' => [ 'base' => NULL, 'refs' => [ 'Cvss2$scoringVector' => '<p>The scoring vector associated with the CVSS v2 score.</p>', ], ], 'Cvss3' => [ 'base' => '<p>The Common Vulnerability Scoring System (CVSS) version 3 details for the vulnerability.</p>', 'refs' => [ 'Vulnerability$cvss3' => '<p>An object that contains the Common Vulnerability Scoring System (CVSS) Version 3 details for the vulnerability.</p>', ], ], 'Cvss3BaseScore' => [ 'base' => NULL, 'refs' => [ 'Cvss3$baseScore' => '<p>The CVSS v3 base score for the vulnerability.</p>', ], ], 'Cvss3ScoringVector' => [ 'base' => NULL, 'refs' => [ 'Cvss3$scoringVector' => '<p>The scoring vector associated with the CVSS v3 score.</p>', ], ], 'CvssScore' => [ 'base' => '<p>The CVSS score for a finding.</p>', 'refs' => [ 'CvssScoreList$member' => NULL, ], ], 'CvssScoreAdjustment' => [ 'base' => '<p>Details on adjustments Amazon Inspector made to the CVSS score for a finding.</p>', 'refs' => [ 'CvssScoreAdjustmentList$member' => NULL, ], ], 'CvssScoreAdjustmentList' => [ 'base' => NULL, 'refs' => [ 'CvssScoreDetails$adjustments' => '<p>An object that contains details about adjustment Amazon Inspector made to the CVSS score.</p>', ], ], 'CvssScoreDetails' => [ 'base' => '<p>Information about the CVSS score.</p>', 'refs' => [ 'InspectorScoreDetails$adjustedCvss' => '<p>An object that contains details about the CVSS score given to a finding.</p>', ], ], 'CvssScoreList' => [ 'base' => NULL, 'refs' => [ 'PackageVulnerabilityDetails$cvss' => '<p>An object that contains details about the CVSS score of a finding.</p>', ], ], 'Cwe' => [ 'base' => NULL, 'refs' => [ 'Cwes$member' => NULL, ], ], 'CweList' => [ 'base' => NULL, 'refs' => [ 'CodeVulnerabilityDetails$cwes' => '<p>The Common Weakness Enumeration (CWE) item associated with the detected vulnerability.</p>', ], ], 'Cwes' => [ 'base' => NULL, 'refs' => [ 'FindingDetail$cwes' => '<p>The Common Weakness Enumerations (CWEs) associated with the vulnerability.</p>', 'Vulnerability$cwes' => '<p>The Common Weakness Enumeration (CWE) associated with the vulnerability.</p>', ], ], 'DailySchedule' => [ 'base' => '<p>A daily schedule.</p>', 'refs' => [ 'Schedule$daily' => '<p>The schedule\'s daily.</p>', ], ], 'DateFilter' => [ 'base' => '<p>Contains details on the time range used to filter findings.</p>', 'refs' => [ 'DateFilterList$member' => NULL, ], ], 'DateFilterList' => [ 'base' => NULL, 'refs' => [ 'FilterCriteria$ecrImagePushedAt' => '<p>Details on the Amazon ECR image push date and time used to filter findings.</p>', 'FilterCriteria$firstObservedAt' => '<p>Details on the date and time a finding was first seen used to filter findings.</p>', 'FilterCriteria$lambdaFunctionLastModifiedAt' => '<p>Filters the list of Amazon Web Services Lambda functions by the date and time that a user last updated the configuration, in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601 format</a> </p>', 'FilterCriteria$lastObservedAt' => '<p>Details on the date and time a finding was last seen used to filter findings.</p>', 'FilterCriteria$updatedAt' => '<p>Details on the date and time a finding was last updated at used to filter findings.</p>', ], ], 'DateTimeTimestamp' => [ 'base' => NULL, 'refs' => [ 'AwsEc2InstanceDetails$launchedAt' => '<p>The date and time the Amazon EC2 instance was launched at.</p>', 'AwsEcrContainerImageDetails$pushedAt' => '<p>The date and time the Amazon ECR container image was pushed.</p>', 'CoverageDateFilter$endInclusive' => '<p>A timestamp representing the end of the time period to filter results by.</p>', 'CoverageDateFilter$startInclusive' => '<p>A timestamp representing the start of the time period to filter results by.</p>', 'CoveredResource$lastScannedAt' => '<p>The date and time the resource was last checked for vulnerabilities.</p>', 'EcrContainerImageMetadata$imagePulledAt' => '<p>The date an image was last pulled at.</p>', 'EcrRescanDurationState$updatedAt' => '<p>A timestamp representing when the last time the ECR scan duration setting was changed.</p>', 'ExploitabilityDetails$lastKnownExploitAt' => '<p>The date and time of the last exploit associated with a finding discovered in your environment.</p>', 'Filter$createdAt' => '<p>The date and time this filter was created at.</p>', 'Filter$updatedAt' => '<p>The date and time the filter was last updated at.</p>', 'Finding$firstObservedAt' => '<p>The date and time that the finding was first observed.</p>', 'Finding$lastObservedAt' => '<p> The date and time the finding was last observed. This timestamp for this field remains unchanged until a finding is updated. </p>', 'Finding$updatedAt' => '<p>The date and time the finding was last updated at.</p>', 'LambdaFunctionAggregationResponse$lastModifiedAt' => '<p>The date that the Amazon Web Services Lambda function included in the aggregation results was last changed.</p>', 'Member$updatedAt' => '<p>A timestamp showing when the status of this member was last updated.</p>', 'PackageVulnerabilityDetails$vendorCreatedAt' => '<p>The date and time that this vulnerability was first added to the vendor\'s database.</p>', 'PackageVulnerabilityDetails$vendorUpdatedAt' => '<p>The date and time the vendor last updated this vulnerability in their database.</p>', ], ], 'Day' => [ 'base' => NULL, 'refs' => [ 'DaysList$member' => NULL, 'MonthlySchedule$day' => '<p>The monthly schedule\'s day.</p>', ], ], 'DaysList' => [ 'base' => NULL, 'refs' => [ 'WeeklySchedule$days' => '<p>The weekly schedule\'s days.</p>', ], ], 'DelegatedAdmin' => [ 'base' => '<p>Details of the Amazon Inspector delegated administrator for your organization.</p>', 'refs' => [ 'GetDelegatedAdminAccountResponse$delegatedAdmin' => '<p>The Amazon Web Services account ID of the Amazon Inspector delegated administrator.</p>', ], ], 'DelegatedAdminAccount' => [ 'base' => '<p>Details of the Amazon Inspector delegated administrator for your organization.</p>', 'refs' => [ 'DelegatedAdminAccountList$member' => NULL, ], ], 'DelegatedAdminAccountList' => [ 'base' => NULL, 'refs' => [ 'ListDelegatedAdminAccountsResponse$delegatedAdminAccounts' => '<p>Details of the Amazon Inspector delegated administrator of your organization.</p>', ], ], 'DelegatedAdminStatus' => [ 'base' => NULL, 'refs' => [ 'DelegatedAdminAccount$status' => '<p>The status of the Amazon Inspector delegated administrator.</p>', ], ], 'DeleteCisScanConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteCisScanConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFilterRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFilterResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeOrganizationConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeOrganizationConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'Destination' => [ 'base' => '<p>Contains details of the Amazon S3 bucket and KMS key used to export findings.</p>', 'refs' => [ 'CreateFindingsReportRequest$s3Destination' => '<p>The Amazon S3 export destination for the report.</p>', 'CreateSbomExportRequest$s3Destination' => NULL, 'GetFindingsReportStatusResponse$destination' => '<p>The destination of the report.</p>', 'GetSbomExportResponse$s3Destination' => NULL, ], ], 'DetectionPlatforms' => [ 'base' => NULL, 'refs' => [ 'Vulnerability$detectionPlatforms' => '<p>Platforms that the vulnerability can be detected on.</p>', ], ], 'DetectorTagList' => [ 'base' => NULL, 'refs' => [ 'CodeVulnerabilityDetails$detectorTags' => '<p>The detector tag associated with the vulnerability. Detector tags group related vulnerabilities by common themes or tactics. For a list of available tags by programming language, see <a href="https://docs.aws.amazon.com/codeguru/detector-library/java/tags/">Java tags</a>, or <a href="https://docs.aws.amazon.com/codeguru/detector-library/python/tags/">Python tags</a>. </p>', ], ], 'DisableDelegatedAdminAccountRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisableDelegatedAdminAccountResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisableRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisableResourceTypeList' => [ 'base' => NULL, 'refs' => [ 'DisableRequest$resourceTypes' => '<p>The resource scan types you want to disable.</p>', ], ], 'DisableResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateMemberRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateMemberResponse' => [ 'base' => NULL, 'refs' => [], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'CvssScore$baseScore' => '<p>The base CVSS score used for the finding.</p>', 'CvssScoreDetails$score' => '<p>The CVSS score.</p>', 'Finding$inspectorScore' => '<p>The Amazon Inspector score given to the finding.</p>', 'FindingDetail$epssScore' => '<p>The Exploit Prediction Scoring System (EPSS) score of the vulnerability.</p>', 'NumberFilter$lowerInclusive' => '<p>The lowest number to be included in the filter.</p>', 'NumberFilter$upperInclusive' => '<p>The highest number to be included in the filter.</p>', ], ], 'Ec2Configuration' => [ 'base' => '<p>Enables agent-based scanning, which scans instances that are not managed by SSM.</p>', 'refs' => [ 'UpdateConfigurationRequest$ec2Configuration' => '<p>Specifies how the Amazon EC2 automated scan will be updated for your environment.</p>', ], ], 'Ec2ConfigurationState' => [ 'base' => '<p>Details about the state of the EC2 scan configuration for your environment.</p>', 'refs' => [ 'GetConfigurationResponse$ec2Configuration' => '<p>Specifies how the Amazon EC2 automated scan mode is currently configured for your environment.</p>', ], ], 'Ec2DeepInspectionStatus' => [ 'base' => NULL, 'refs' => [ 'GetEc2DeepInspectionConfigurationResponse$status' => '<p>The activation status of Amazon Inspector deep inspection in your account.</p>', 'MemberAccountEc2DeepInspectionStatusState$status' => '<p>The state of Amazon Inspector deep inspection in the member account.</p>', 'UpdateEc2DeepInspectionConfigurationResponse$status' => '<p>The status of Amazon Inspector deep inspection in your account.</p>', ], ], 'Ec2InstanceAggregation' => [ 'base' => '<p>The details that define an aggregation based on Amazon EC2 instances.</p>', 'refs' => [ 'AggregationRequest$ec2InstanceAggregation' => '<p>An object that contains details about an aggregation request based on Amazon EC2 instances.</p>', ], ], 'Ec2InstanceAggregationResponse' => [ 'base' => '<p>A response that contains the results of a finding aggregation by Amazon EC2 instance.</p>', 'refs' => [ 'AggregationResponse$ec2InstanceAggregation' => '<p>An object that contains details about an aggregation response based on Amazon EC2 instances.</p>', ], ], 'Ec2InstanceSortBy' => [ 'base' => NULL, 'refs' => [ 'Ec2InstanceAggregation$sortBy' => '<p>The value to sort results by.</p>', ], ], 'Ec2Metadata' => [ 'base' => '<p>Meta data details of an Amazon EC2 instance.</p>', 'refs' => [ 'ResourceScanMetadata$ec2' => '<p>An object that contains metadata details for an Amazon EC2 instance.</p>', ], ], 'Ec2Platform' => [ 'base' => NULL, 'refs' => [ 'Ec2Metadata$platform' => '<p>The platform of the instance.</p>', ], ], 'Ec2ScanMode' => [ 'base' => NULL, 'refs' => [ 'Ec2Configuration$scanMode' => '<p>The scan method that is applied to the instance.</p>', 'Ec2ScanModeState$scanMode' => '<p>The scan method that is applied to the instance.</p>', ], ], 'Ec2ScanModeState' => [ 'base' => '<p>The state of your Amazon EC2 scan mode configuration.</p>', 'refs' => [ 'Ec2ConfigurationState$scanModeState' => '<p>An object that contains details about the state of the Amazon EC2 scan mode.</p>', ], ], 'Ec2ScanModeStatus' => [ 'base' => NULL, 'refs' => [ 'Ec2ScanModeState$scanModeStatus' => '<p>The status of the Amazon EC2 scan mode setting.</p>', ], ], 'EcrConfiguration' => [ 'base' => '<p>Details about the ECR automated re-scan duration setting for your environment.</p>', 'refs' => [ 'UpdateConfigurationRequest$ecrConfiguration' => '<p>Specifies how the ECR automated re-scan will be updated for your environment.</p>', ], ], 'EcrConfigurationState' => [ 'base' => '<p>Details about the state of the ECR scans for your environment.</p>', 'refs' => [ 'GetConfigurationResponse$ecrConfiguration' => '<p>Specifies how the ECR automated re-scan duration is currently configured for your environment.</p>', ], ], 'EcrContainerImageMetadata' => [ 'base' => '<p>Information on the Amazon ECR image metadata associated with a finding.</p>', 'refs' => [ 'ResourceScanMetadata$ecrImage' => '<p>An object that contains details about the container metadata for an Amazon ECR image.</p>', ], ], 'EcrPullDateRescanDuration' => [ 'base' => NULL, 'refs' => [ 'EcrConfiguration$pullDateRescanDuration' => '<p>The rescan duration configured for image pull date.</p>', 'EcrRescanDurationState$pullDateRescanDuration' => '<p>The rescan duration configured for image pull date.</p>', ], ], 'EcrRepositoryMetadata' => [ 'base' => '<p>Information on the Amazon ECR repository metadata associated with a finding.</p>', 'refs' => [ 'ResourceScanMetadata$ecrRepository' => '<p>An object that contains details about the repository an Amazon ECR image resides in.</p>', ], ], 'EcrRescanDuration' => [ 'base' => NULL, 'refs' => [ 'EcrConfiguration$rescanDuration' => '<p>The rescan duration configured for image push date.</p>', 'EcrRescanDurationState$rescanDuration' => '<p>The rescan duration configured for image push date. <pre><code> &lt;/p&gt; </code></pre>', ], ], 'EcrRescanDurationState' => [ 'base' => '<p>Details about the state of your ECR re-scan duration settings. The ECR re-scan duration defines how long an ECR image will be actively scanned by Amazon Inspector. When the number of days since an image was last pushed exceeds the duration configured for image pull date, and the duration configured for image pull date, the monitoring state of that image becomes <code>inactive</code> and all associated findings are scheduled for closure.</p>', 'refs' => [ 'EcrConfigurationState$rescanDurationState' => '<p>An object that contains details about the state of the ECR re-scan settings.</p>', ], ], 'EcrRescanDurationStatus' => [ 'base' => NULL, 'refs' => [ 'EcrRescanDurationState$status' => '<p>The status of changes to the ECR automated re-scan duration.</p>', ], ], 'EcrScanFrequency' => [ 'base' => NULL, 'refs' => [ 'EcrRepositoryMetadata$scanFrequency' => '<p>The frequency of scans.</p>', ], ], 'EnableDelegatedAdminAccountRequest' => [ 'base' => NULL, 'refs' => [], ], 'EnableDelegatedAdminAccountResponse' => [ 'base' => NULL, 'refs' => [], ], 'EnableRequest' => [ 'base' => NULL, 'refs' => [], ], 'EnableResourceTypeList' => [ 'base' => NULL, 'refs' => [ 'EnableRequest$resourceTypes' => '<p>The resource scan types you want to enable.</p>', ], ], 'EnableResponse' => [ 'base' => NULL, 'refs' => [], ], 'Epss' => [ 'base' => '<p>Details about the Exploit Prediction Scoring System (EPSS) score.</p>', 'refs' => [ 'Vulnerability$epss' => '<p>An object that contains the Exploit Prediction Scoring System (EPSS) score for a vulnerability.</p>', ], ], 'EpssDetails' => [ 'base' => '<p>Details about the Exploit Prediction Scoring System (EPSS) score for a finding.</p>', 'refs' => [ 'Finding$epss' => '<p>The finding\'s EPSS score.</p>', ], ], 'EpssScore' => [ 'base' => NULL, 'refs' => [ 'Epss$score' => '<p>The Exploit Prediction Scoring System (EPSS) score.</p>', ], ], 'EpssScoreValue' => [ 'base' => NULL, 'refs' => [ 'EpssDetails$score' => '<p>The EPSS score.</p>', ], ], 'ErrorCode' => [ 'base' => NULL, 'refs' => [ 'FailedAccount$errorCode' => '<p>The error code explaining why the account failed to enable Amazon Inspector.</p>', 'State$errorCode' => '<p>The error code explaining why the account failed to enable Amazon Inspector.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'GetFindingsReportStatusResponse$errorMessage' => '<p>The error message of the report.</p>', ], ], 'Evidence' => [ 'base' => '<p>Details of the evidence for a vulnerability identified in a finding.</p>', 'refs' => [ 'EvidenceList$member' => NULL, ], ], 'EvidenceDetail' => [ 'base' => NULL, 'refs' => [ 'Evidence$evidenceDetail' => '<p>The evidence details.</p>', ], ], 'EvidenceList' => [ 'base' => NULL, 'refs' => [ 'FindingDetail$evidences' => '<p>Information on the evidence of the vulnerability.</p>', ], ], 'EvidenceRule' => [ 'base' => NULL, 'refs' => [ 'Evidence$evidenceRule' => '<p>The evidence rule.</p>', ], ], 'EvidenceSeverity' => [ 'base' => NULL, 'refs' => [ 'Evidence$severity' => '<p>The evidence severity.</p>', ], ], 'ExecutionRoleArn' => [ 'base' => NULL, 'refs' => [ 'AwsLambdaFunctionDetails$executionRoleArn' => '<p>The Amazon Web Services Lambda function\'s execution role.</p>', ], ], 'ExploitAvailable' => [ 'base' => NULL, 'refs' => [ 'Finding$exploitAvailable' => '<p>If a finding discovered in your environment has an exploit available.</p>', ], ], 'ExploitObserved' => [ 'base' => '<p>Contains information on when this exploit was observed.</p>', 'refs' => [ 'FindingDetail$exploitObserved' => NULL, 'Vulnerability$exploitObserved' => '<p>An object that contains details on when the exploit was observed.</p>', ], ], 'ExploitabilityDetails' => [ 'base' => '<p>The details of an exploit available for a finding discovered in your environment.</p>', 'refs' => [ 'Finding$exploitabilityDetails' => '<p>The details of an exploit available for a finding discovered in your environment.</p>', ], ], 'ExternalReportStatus' => [ 'base' => NULL, 'refs' => [ 'GetFindingsReportStatusResponse$status' => '<p>The status of the report.</p>', 'GetSbomExportResponse$status' => '<p>The status of the software bill of materials (SBOM) report.</p>', ], ], 'FailedAccount' => [ 'base' => '<p>An object with details on why an account failed to enable Amazon Inspector.</p>', 'refs' => [ 'FailedAccountList$member' => NULL, ], ], 'FailedAccountList' => [ 'base' => NULL, 'refs' => [ 'BatchGetAccountStatusResponse$failedAccounts' => '<p>An array of objects detailing any accounts that failed to enable Amazon Inspector and why.</p>', 'DisableResponse$failedAccounts' => '<p>Information on any accounts for which Amazon Inspector scans could not be disabled. Details are provided for each account.</p>', 'EnableResponse$failedAccounts' => '<p>Information on any accounts for which Amazon Inspector scans could not be enabled. Details are provided for each account.</p>', ], ], 'FailedMemberAccountEc2DeepInspectionStatusState' => [ 'base' => '<p>An object that contains details about a member account in your organization that failed to activate Amazon Inspector deep inspection.</p>', 'refs' => [ 'FailedMemberAccountEc2DeepInspectionStatusStateList$member' => NULL, ], ], 'FailedMemberAccountEc2DeepInspectionStatusStateList' => [ 'base' => NULL, 'refs' => [ 'BatchGetMemberEc2DeepInspectionStatusResponse$failedAccountIds' => '<p>An array of objects that provide details on any accounts that failed to activate Amazon Inspector deep inspection and why. <pre><code> &lt;/p&gt; </code></pre>', 'BatchUpdateMemberEc2DeepInspectionStatusResponse$failedAccountIds' => '<p>An array of objects that provide details for each of the accounts that Amazon Inspector deep inspection status could not be successfully changed for. </p>', ], ], 'FilePath' => [ 'base' => NULL, 'refs' => [ 'VulnerablePackage$filePath' => '<p>The file path of the vulnerable package.</p>', ], ], 'Filter' => [ 'base' => '<p>Details about a filter.</p>', 'refs' => [ 'FilterList$member' => NULL, ], ], 'FilterAction' => [ 'base' => NULL, 'refs' => [ 'CreateFilterRequest$action' => '<p>Defines the action that is to be applied to the findings that match the filter.</p>', 'Filter$action' => '<p>The action that is to be applied to the findings that match the filter.</p>', 'ListFiltersRequest$action' => '<p>The action the filter applies to matched findings.</p>', 'UpdateFilterRequest$action' => '<p>Specifies the action that is to be applied to the findings that match the filter.</p>', ], ], 'FilterArn' => [ 'base' => NULL, 'refs' => [ 'CreateFilterResponse$arn' => '<p>The Amazon Resource Number (ARN) of the successfully created filter.</p>', 'DeleteFilterRequest$arn' => '<p>The Amazon Resource Number (ARN) of the filter to be deleted.</p>', 'DeleteFilterResponse$arn' => '<p>The Amazon Resource Number (ARN) of the filter that has been deleted.</p>', 'Filter$arn' => '<p>The Amazon Resource Number (ARN) associated with this filter.</p>', 'FilterArnList$member' => NULL, 'UpdateFilterRequest$filterArn' => '<p>The Amazon Resource Number (ARN) of the filter to update.</p>', 'UpdateFilterResponse$arn' => '<p>The Amazon Resource Number (ARN) of the successfully updated filter.</p>', ], ], 'FilterArnList' => [ 'base' => NULL, 'refs' => [ 'ListFiltersRequest$arns' => '<p>The Amazon resource number (ARN) of the filter.</p>', ], ], 'FilterCriteria' => [ 'base' => '<p>Details on the criteria used to define the filter.</p>', 'refs' => [ 'CreateFilterRequest$filterCriteria' => '<p>Defines the criteria to be used in the filter for querying findings.</p>', 'CreateFindingsReportRequest$filterCriteria' => '<p>The filter criteria to apply to the results of the finding report.</p>', 'Filter$criteria' => '<p>Details on the filter criteria associated with this filter.</p>', 'GetFindingsReportStatusResponse$filterCriteria' => '<p>The filter criteria associated with the report.</p>', 'ListFindingsRequest$filterCriteria' => '<p>Details on the filters to apply to your finding results.</p>', 'UpdateFilterRequest$filterCriteria' => '<p>Defines the criteria to be update in the filter.</p>', ], ], 'FilterDescription' => [ 'base' => NULL, 'refs' => [ 'CreateFilterRequest$description' => '<p>A description of the filter.</p>', 'Filter$description' => '<p>A description of the filter.</p>', 'UpdateFilterRequest$description' => '<p>A description of the filter.</p>', ], ], 'FilterList' => [ 'base' => NULL, 'refs' => [ 'ListFiltersResponse$filters' => '<p>Contains details on the filters associated with your account.</p>', ], ], 'FilterName' => [ 'base' => NULL, 'refs' => [ 'CreateFilterRequest$name' => '<p>The name of the filter. Minimum length of 3. Maximum length of 64. Valid characters include alphanumeric characters, dot (.), underscore (_), and dash (-). Spaces are not allowed.</p>', 'Filter$name' => '<p>The name of the filter.</p>', 'UpdateFilterRequest$name' => '<p>The name of the filter.</p>', ], ], 'FilterReason' => [ 'base' => NULL, 'refs' => [ 'CreateFilterRequest$reason' => '<p>The reason for creating the filter.</p>', 'Filter$reason' => '<p>The reason for the filter.</p>', 'UpdateFilterRequest$reason' => '<p>The reason the filter was updated.</p>', ], ], 'Finding' => [ 'base' => '<p>Details about an Amazon Inspector finding.</p>', 'refs' => [ 'FindingList$member' => NULL, ], ], 'FindingArn' => [ 'base' => NULL, 'refs' => [ 'BatchGetCodeSnippetRequestFindingArnsList$member' => NULL, 'CodeSnippetError$findingArn' => '<p>The ARN of the finding that a code snippet couldn\'t be retrieved for.</p>', 'CodeSnippetResult$findingArn' => '<p>The ARN of a finding that the code snippet is associated with.</p>', 'Finding$findingArn' => '<p>The Amazon Resource Number (ARN) of the finding.</p>', 'FindingArnList$member' => NULL, 'FindingDetail$findingArn' => '<p>The finding ARN that the vulnerability details are associated with.</p>', 'FindingDetailsError$findingArn' => '<p>The finding ARN that returned an error.</p>', ], ], 'FindingArnList' => [ 'base' => NULL, 'refs' => [ 'BatchGetFindingDetailsRequest$findingArns' => '<p>A list of finding ARNs.</p>', ], ], 'FindingDescription' => [ 'base' => NULL, 'refs' => [ 'Finding$description' => '<p>The description of the finding.</p>', ], ], 'FindingDetail' => [ 'base' => '<p>Details of the vulnerability identified in a finding.</p>', 'refs' => [ 'FindingDetails$member' => NULL, ], ], 'FindingDetails' => [ 'base' => NULL, 'refs' => [ 'BatchGetFindingDetailsResponse$findingDetails' => '<p>A finding\'s vulnerability details.</p>', ], ], 'FindingDetailsError' => [ 'base' => '<p>Details about an error encountered when trying to return vulnerability data for a finding.</p>', 'refs' => [ 'FindingDetailsErrorList$member' => NULL, ], ], 'FindingDetailsErrorCode' => [ 'base' => NULL, 'refs' => [ 'FindingDetailsError$errorCode' => '<p>The error code.</p>', ], ], 'FindingDetailsErrorList' => [ 'base' => NULL, 'refs' => [ 'BatchGetFindingDetailsResponse$errors' => '<p>Error information for findings that details could not be returned for.</p>', ], ], 'FindingList' => [ 'base' => NULL, 'refs' => [ 'ListFindingsResponse$findings' => '<p>Contains details on the findings in your environment.</p>', ], ], 'FindingStatus' => [ 'base' => NULL, 'refs' => [ 'Finding$status' => '<p>The status of the finding.</p>', ], ], 'FindingTitle' => [ 'base' => NULL, 'refs' => [ 'Finding$title' => '<p>The title of the finding.</p>', ], ], 'FindingType' => [ 'base' => NULL, 'refs' => [ 'Finding$type' => '<p>The type of the finding. The <code>type</code> value determines the valid values for <code>resource</code> in your request. For more information, see <a href="https://docs.aws.amazon.com/inspector/latest/user/findings-types.html">Finding types</a> in the Amazon Inspector user guide.</p>', ], ], 'FindingTypeAggregation' => [ 'base' => '<p>The details that define an aggregation based on finding type.</p>', 'refs' => [ 'AggregationRequest$findingTypeAggregation' => '<p>An object that contains details about an aggregation request based on finding types.</p>', ], ], 'FindingTypeAggregationResponse' => [ 'base' => '<p>A response that contains the results of a finding type aggregation.</p>', 'refs' => [ 'AggregationResponse$findingTypeAggregation' => '<p>An object that contains details about an aggregation response based on finding types.</p>', ], ], 'FindingTypeSortBy' => [ 'base' => NULL, 'refs' => [ 'FindingTypeAggregation$sortBy' => '<p>The value to sort results by.</p>', ], ], 'FirstSeen' => [ 'base' => NULL, 'refs' => [ 'AtigData$firstSeen' => '<p>The date and time this vulnerability was first observed.</p>', 'ExploitObserved$firstSeen' => '<p>The date an time when the exploit was first seen.</p>', ], ], 'FixAvailable' => [ 'base' => NULL, 'refs' => [ 'Finding$fixAvailable' => '<p>Details on whether a fix is available through a version update. This value can be <code>YES</code>, <code>NO</code>, or <code>PARTIAL</code>. A <code>PARTIAL</code> fix means that some, but not all, of the packages identified in the finding have fixes available through updated versions.</p>', ], ], 'FreeTrialAccountInfo' => [ 'base' => '<p>Information about the Amazon Inspector free trial for an account.</p>', 'refs' => [ 'FreeTrialAccountInfoList$member' => NULL, ], ], 'FreeTrialAccountInfoList' => [ 'base' => NULL, 'refs' => [ 'BatchGetFreeTrialInfoResponse$accounts' => '<p>An array of objects that provide Amazon Inspector free trial details for each of the requested accounts. </p>', ], ], 'FreeTrialInfo' => [ 'base' => '<p>An object that contains information about the Amazon Inspector free trial for an account.</p>', 'refs' => [ 'FreeTrialInfoList$member' => NULL, ], ], 'FreeTrialInfoError' => [ 'base' => '<p>Information about an error received while accessing free trail data for an account.</p>', 'refs' => [ 'FreeTrialInfoErrorList$member' => NULL, ], ], 'FreeTrialInfoErrorCode' => [ 'base' => NULL, 'refs' => [ 'FreeTrialInfoError$code' => '<p>The error code.</p>', ], ], 'FreeTrialInfoErrorList' => [ 'base' => NULL, 'refs' => [ 'BatchGetFreeTrialInfoResponse$failedAccounts' => '<p>An array of objects detailing any accounts that free trial data could not be returned for.</p>', ], ], 'FreeTrialInfoList' => [ 'base' => NULL, 'refs' => [ 'FreeTrialAccountInfo$freeTrialInfo' => '<p>Contains information about the Amazon Inspector free trial for an account.</p>', ], ], 'FreeTrialStatus' => [ 'base' => NULL, 'refs' => [ 'FreeTrialInfo$status' => '<p>The order to sort results by.</p>', ], ], 'FreeTrialType' => [ 'base' => NULL, 'refs' => [ 'FreeTrialInfo$type' => '<p>The type of scan covered by the Amazon Inspector free trail.</p>', ], ], 'FunctionName' => [ 'base' => NULL, 'refs' => [ 'AwsLambdaFunctionDetails$functionName' => '<p>The name of the Amazon Web Services Lambda function.</p>', ], ], 'GetCisScanReportRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCisScanReportResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetCisScanResultDetailsMaxResults' => [ 'base' => NULL, 'refs' => [ 'GetCisScanResultDetailsRequest$maxResults' => '<p>The maximum number of CIS scan result details to be returned in a single page of results.</p>', ], ], 'GetCisScanResultDetailsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCisScanResultDetailsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetDelegatedAdminAccountRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDelegatedAdminAccountResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetEc2DeepInspectionConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetEc2DeepInspectionConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetEncryptionKeyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetEncryptionKeyResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetFindingsReportStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetFindingsReportStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetMemberRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMemberResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetSbomExportRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSbomExportResponse' => [ 'base' => NULL, 'refs' => [], ], 'GroupKey' => [ 'base' => NULL, 'refs' => [ 'Counts$groupKey' => '<p>The key associated with this group</p>', 'ListCoverageStatisticsRequest$groupBy' => '<p>The value to group the results by.</p>', ], ], 'ImageHash' => [ 'base' => NULL, 'refs' => [ 'AwsEcrContainerImageDetails$imageHash' => '<p>The image hash of the Amazon ECR container image.</p>', ], ], 'ImageLayerAggregation' => [ 'base' => '<p>The details that define an aggregation based on container image layers.</p>', 'refs' => [ 'AggregationRequest$imageLayerAggregation' => '<p>An object that contains details about an aggregation request based on container image layers.</p>', ], ], 'ImageLayerAggregationResponse' => [ 'base' => '<p>A response that contains the results of a finding aggregation by image layer.</p>', 'refs' => [ 'AggregationResponse$imageLayerAggregation' => '<p>An object that contains details about an aggregation response based on container image layers.</p>', ], ], 'ImageLayerSortBy' => [ 'base' => NULL, 'refs' => [ 'ImageLayerAggregation$sortBy' => '<p>The value to sort results by.</p>', ], ], 'ImageTagList' => [ 'base' => NULL, 'refs' => [ 'AwsEcrContainerImageDetails$imageTags' => '<p>The image tags attached to the Amazon ECR container image.</p>', ], ], 'InspectorScoreDetails' => [ 'base' => '<p>Information about the Amazon Inspector score given to a finding.</p>', 'refs' => [ 'Finding$inspectorScoreDetails' => '<p>An object that contains details of the Amazon Inspector score.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'CisNumberFilter$lowerInclusive' => '<p>The CIS number filter\'s lower inclusive.</p>', 'CisNumberFilter$upperInclusive' => '<p>The CIS number filter\'s upper inclusive.</p>', 'CisScan$failedChecks' => '<p>The CIS scan\'s failed checks.</p>', 'CisScan$totalChecks' => '<p>The CIS scan\'s total checks.</p>', 'CodeFilePath$endLine' => '<p>The line number of the last line of code that a vulnerability was found in.</p>', 'CodeFilePath$startLine' => '<p>The line number of the first line of code that a vulnerability was found in.</p>', 'CodeLine$lineNumber' => '<p>The line number that a section of code is located at.</p>', 'CodeSnippetResult$endLine' => '<p>The line number of the last line of a code snippet.</p>', 'CodeSnippetResult$startLine' => '<p>The line number of the first line of a code snippet.</p>', 'InternalServerException$retryAfterSeconds' => '<p>The number of seconds to wait before retrying the request.</p>', 'StatusCounts$failed' => '<p>The number of checks that failed.</p>', 'StatusCounts$passed' => '<p>The number of checks that passed.</p>', 'StatusCounts$skipped' => '<p>The number of checks that were skipped.</p>', 'ThrottlingException$retryAfterSeconds' => '<p>The number of seconds to wait before retrying the request.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>The request has failed due to an internal failure of the Amazon Inspector service.</p>', 'refs' => [], ], 'IpV4Address' => [ 'base' => NULL, 'refs' => [ 'IpV4AddressList$member' => NULL, ], ], 'IpV4AddressList' => [ 'base' => NULL, 'refs' => [ 'AwsEc2InstanceDetails$ipV4Addresses' => '<p>The IPv4 addresses of the Amazon EC2 instance.</p>', ], ], 'IpV6Address' => [ 'base' => NULL, 'refs' => [ 'IpV6AddressList$member' => NULL, ], ], 'IpV6AddressList' => [ 'base' => NULL, 'refs' => [ 'AwsEc2InstanceDetails$ipV6Addresses' => '<p>The IPv6 addresses of the Amazon EC2 instance.</p>', ], ], 'KmsKeyArn' => [ 'base' => NULL, 'refs' => [ 'GetEncryptionKeyResponse$kmsKeyId' => '<p>A kms key ID.</p>', 'UpdateEncryptionKeyRequest$kmsKeyId' => '<p>A KMS key ID for the encryption key.</p>', ], ], 'LambdaFunctionAggregation' => [ 'base' => '<p>The details that define a findings aggregation based on Amazon Web Services Lambda functions.</p>', 'refs' => [ 'AggregationRequest$lambdaFunctionAggregation' => '<p>Returns an object with findings aggregated by Amazon Web Services Lambda function.</p>', ], ], 'LambdaFunctionAggregationResponse' => [ 'base' => '<p>A response that contains the results of an Amazon Web Services Lambda function finding aggregation.</p>', 'refs' => [ 'AggregationResponse$lambdaFunctionAggregation' => '<p>An aggregation of findings by Amazon Web Services Lambda function.</p>', ], ], 'LambdaFunctionMetadata' => [ 'base' => '<p>The Amazon Web Services Lambda function metadata.</p>', 'refs' => [ 'ResourceScanMetadata$lambdaFunction' => '<p>An object that contains metadata details for an Amazon Web Services Lambda function.</p>', ], ], 'LambdaFunctionSortBy' => [ 'base' => NULL, 'refs' => [ 'LambdaFunctionAggregation$sortBy' => '<p>The finding severity to use for sorting the results.</p>', ], ], 'LambdaLayerAggregation' => [ 'base' => '<p>The details that define a findings aggregation based on an Amazon Web Services Lambda function\'s layers.</p>', 'refs' => [ 'AggregationRequest$lambdaLayerAggregation' => '<p>Returns an object with findings aggregated by Amazon Web Services Lambda layer.</p>', ], ], 'LambdaLayerAggregationResponse' => [ 'base' => '<p>A response that contains the results of an Amazon Web Services Lambda function layer finding aggregation.</p>', 'refs' => [ 'AggregationResponse$lambdaLayerAggregation' => '<p>An aggregation of findings by Amazon Web Services Lambda layer.</p>', ], ], 'LambdaLayerArn' => [ 'base' => NULL, 'refs' => [ 'CodeVulnerabilityDetails$sourceLambdaLayerArn' => '<p>The Amazon Resource Name (ARN) of the Lambda layer that the code vulnerability was detected in.</p>', 'LayerList$member' => NULL, 'VulnerablePackage$sourceLambdaLayerArn' => '<p>The Amazon Resource Number (ARN) of the Amazon Web Services Lambda function affected by a finding.</p>', ], ], 'LambdaLayerList' => [ 'base' => NULL, 'refs' => [ 'LambdaFunctionMetadata$layers' => '<p>The layers for an Amazon Web Services Lambda function. A Lambda function can have up to five layers.</p>', ], ], 'LambdaLayerSortBy' => [ 'base' => NULL, 'refs' => [ 'LambdaLayerAggregation$sortBy' => '<p>The finding severity to use for sorting the results.</p>', ], ], 'LambdaVpcConfig' => [ 'base' => '<p>The VPC security groups and subnets that are attached to an Amazon Web Services Lambda function. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-vpc.html">VPC Settings</a>.</p>', 'refs' => [ 'AwsLambdaFunctionDetails$vpcConfig' => '<p>The Amazon Web Services Lambda function\'s networking configuration.</p>', ], ], 'LastSeen' => [ 'base' => NULL, 'refs' => [ 'AtigData$lastSeen' => '<p>The date and time this vulnerability was last observed.</p>', 'ExploitObserved$lastSeen' => '<p>The date an time when the exploit was last seen.</p>', ], ], 'LayerList' => [ 'base' => NULL, 'refs' => [ 'AwsLambdaFunctionDetails$layers' => '<p>The Amazon Web Services Lambda function\'s <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html"> layers</a>. A Lambda function can have up to five layers.</p>', ], ], 'ListAccountPermissionsMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListAccountPermissionsRequest$maxResults' => '<p>The maximum number of results the response can return. If your request would return more than the maximum the response will return a <code>nextToken</code> value, use this value when you call the action again to get the remaining results.</p>', ], ], 'ListAccountPermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAccountPermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListCisScanConfigurationsFilterCriteria' => [ 'base' => '<p>A list of CIS scan configurations filter criteria.</p>', 'refs' => [ 'ListCisScanConfigurationsRequest$filterCriteria' => '<p>The CIS scan configuration filter criteria.</p>', ], ], 'ListCisScanConfigurationsMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListCisScanConfigurationsRequest$maxResults' => '<p>The maximum number of CIS scan configurations to be returned in a single page of results.</p>', ], ], 'ListCisScanConfigurationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCisScanConfigurationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListCisScanResultsAggregatedByChecksRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCisScanResultsAggregatedByChecksResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListCisScanResultsAggregatedByTargetResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCisScanResultsAggregatedByTargetResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListCisScansDetailLevel' => [ 'base' => NULL, 'refs' => [ 'ListCisScansRequest$detailLevel' => '<p>The detail applied to the CIS scan.</p>', ], ], 'ListCisScansFilterCriteria' => [ 'base' => '<p>A list of CIS scans filter criteria.</p>', 'refs' => [ 'ListCisScansRequest$filterCriteria' => '<p>The CIS scan filter criteria.</p>', ], ], 'ListCisScansMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListCisScansRequest$maxResults' => '<p>The maximum number of results to be returned.</p>', ], ], 'ListCisScansRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCisScansResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListCisScansSortBy' => [ 'base' => NULL, 'refs' => [ 'ListCisScansRequest$sortBy' => '<p>The CIS scans sort by order.</p>', ], ], 'ListCoverageMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListCoverageRequest$maxResults' => '<p>The maximum number of results the response can return. If your request would return more than the maximum the response will return a <code>nextToken</code> value, use this value when you call the action again to get the remaining results.</p>', ], ], 'ListCoverageRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCoverageResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListCoverageStatisticsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCoverageStatisticsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDelegatedAdminAccountsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDelegatedAdminAccountsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDelegatedAdminMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListDelegatedAdminAccountsRequest$maxResults' => '<p>The maximum number of results the response can return. If your request would return more than the maximum the response will return a <code>nextToken</code> value, use this value when you call the action again to get the remaining results.</p>', ], ], 'ListFilterMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListFiltersRequest$maxResults' => '<p>The maximum number of results the response can return. If your request would return more than the maximum the response will return a <code>nextToken</code> value, use this value when you call the action again to get the remaining results.</p>', ], ], 'ListFiltersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFiltersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFindingAggregationsMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListFindingAggregationsRequest$maxResults' => '<p>The maximum number of results the response can return. If your request would return more than the maximum the response will return a <code>nextToken</code> value, use this value when you call the action again to get the remaining results.</p>', ], ], 'ListFindingAggregationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFindingAggregationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFindingsMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListFindingsRequest$maxResults' => '<p>The maximum number of results the response can return. If your request would return more than the maximum the response will return a <code>nextToken</code> value, use this value when you call the action again to get the remaining results.</p>', ], ], 'ListFindingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFindingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListMembersMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListMembersRequest$maxResults' => '<p>The maximum number of results the response can return. If your request would return more than the maximum the response will return a <code>nextToken</code> value, use this value when you call the action again to get the remaining results.</p>', ], ], 'ListMembersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListMembersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListUsageTotalsMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListUsageTotalsRequest$maxResults' => '<p>The maximum number of results the response can return. If your request would return more than the maximum the response will return a <code>nextToken</code> value, use this value when you call the action again to get the remaining results.</p>', ], ], 'ListUsageTotalsNextToken' => [ 'base' => NULL, 'refs' => [ 'ListUsageTotalsRequest$nextToken' => '<p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. If your response returns more than the <code>maxResults</code> maximum value it will also return a <code>nextToken</code> value. For subsequent calls, use the <code>nextToken</code> value returned from the previous request to continue listing results after the first page.</p>', 'ListUsageTotalsResponse$nextToken' => '<p>The pagination parameter to be used on the next list operation to retrieve more items.</p>', ], ], 'ListUsageTotalsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListUsageTotalsResponse' => [ 'base' => NULL, 'refs' => [], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'AmiAggregationResponse$affectedInstances' => '<p>The IDs of Amazon EC2 instances using this AMI.</p>', 'Ec2InstanceAggregationResponse$networkFindings' => '<p>The number of network findings for the Amazon EC2 instance.</p>', 'ListCoverageStatisticsResponse$totalCounts' => '<p>The total number for all groups.</p>', 'RepositoryAggregationResponse$affectedImages' => '<p>The number of container images impacted by the findings.</p>', 'SeverityCounts$all' => '<p>The total count of findings from all severities.</p>', 'SeverityCounts$critical' => '<p>The total count of critical severity findings.</p>', 'SeverityCounts$high' => '<p>The total count of high severity findings.</p>', 'SeverityCounts$medium' => '<p>The total count of medium severity findings.</p>', ], ], 'MapComparison' => [ 'base' => NULL, 'refs' => [ 'MapFilter$comparison' => '<p>The operator to use when comparing values in the filter.</p>', ], ], 'MapFilter' => [ 'base' => '<p>An object that describes details of a map filter.</p>', 'refs' => [ 'MapFilterList$member' => NULL, ], ], 'MapFilterList' => [ 'base' => NULL, 'refs' => [ 'Ec2InstanceAggregation$instanceTags' => '<p>The Amazon EC2 instance tags to aggregate findings for.</p>', 'FilterCriteria$resourceTags' => '<p>Details on the resource tags used to filter findings.</p>', 'LambdaFunctionAggregation$functionTags' => '<p>The tags to include in the aggregation results.</p>', ], ], 'MapKey' => [ 'base' => NULL, 'refs' => [ 'CisTagMap$key' => NULL, 'MapFilter$key' => '<p>The tag key used in the filter.</p>', 'TagMap$key' => NULL, ], ], 'MapValue' => [ 'base' => NULL, 'refs' => [ 'CisTagMap$value' => NULL, 'MapFilter$value' => '<p>The tag value used in the filter.</p>', 'TagMap$value' => NULL, ], ], 'Member' => [ 'base' => '<p>Details on a member account in your organization.</p>', 'refs' => [ 'GetMemberResponse$member' => '<p>Details of the retrieved member account.</p>', 'MemberList$member' => NULL, ], ], 'MemberAccountEc2DeepInspectionStatus' => [ 'base' => '<p>An object that contains details about the status of Amazon Inspector deep inspection for a member account in your organization.</p>', 'refs' => [ 'MemberAccountEc2DeepInspectionStatusList$member' => NULL, ], ], 'MemberAccountEc2DeepInspectionStatusList' => [ 'base' => NULL, 'refs' => [ 'BatchUpdateMemberEc2DeepInspectionStatusRequest$accountIds' => '<p>The unique identifiers for the Amazon Web Services accounts to change Amazon Inspector deep inspection status for.</p>', ], ], 'MemberAccountEc2DeepInspectionStatusState' => [ 'base' => '<p>An object that contains details about the state of Amazon Inspector deep inspection for a member account.</p>', 'refs' => [ 'MemberAccountEc2DeepInspectionStatusStateList$member' => NULL, ], ], 'MemberAccountEc2DeepInspectionStatusStateList' => [ 'base' => NULL, 'refs' => [ 'BatchGetMemberEc2DeepInspectionStatusResponse$accountIds' => '<p>An array of objects that provide details on the activation status of Amazon Inspector deep inspection for each of the requested accounts. <pre><code> &lt;/p&gt; </code></pre>', 'BatchUpdateMemberEc2DeepInspectionStatusResponse$accountIds' => '<p>An array of objects that provide details for each of the accounts that Amazon Inspector deep inspection status was successfully changed for. </p>', ], ], 'MemberList' => [ 'base' => NULL, 'refs' => [ 'ListMembersResponse$members' => '<p>An object that contains details for each member account.</p>', ], ], 'MeteringAccountId' => [ 'base' => NULL, 'refs' => [ 'BatchGetFreeTrialInfoRequestAccountIdsList$member' => NULL, 'FreeTrialAccountInfo$accountId' => '<p>The account associated with the Amazon Inspector free trial information.</p>', 'FreeTrialInfoError$accountId' => '<p>The account associated with the Amazon Inspector free trial information.</p>', 'UsageTotal$accountId' => '<p>The account ID of the account that usage data was retrieved for.</p>', ], ], 'MonthlyCostEstimate' => [ 'base' => NULL, 'refs' => [ 'Usage$estimatedMonthlyCost' => '<p>The estimated monthly cost of Amazon Inspector.</p>', ], ], 'MonthlySchedule' => [ 'base' => '<p>A monthly schedule.</p>', 'refs' => [ 'Schedule$monthly' => '<p>The schedule\'s monthly.</p>', ], ], 'NetworkPath' => [ 'base' => '<p>Information on the network path associated with a finding.</p>', 'refs' => [ 'NetworkReachabilityDetails$networkPath' => '<p>An object that contains details about a network path associated with a finding.</p>', ], ], 'NetworkProtocol' => [ 'base' => NULL, 'refs' => [ 'NetworkReachabilityDetails$protocol' => '<p>The protocol associated with a finding.</p>', ], ], 'NetworkReachabilityDetails' => [ 'base' => '<p>Contains the details of a network reachability finding.</p>', 'refs' => [ 'Finding$networkReachabilityDetails' => '<p>An object that contains the details of a network reachability finding.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'GetCisScanResultDetailsRequest$nextToken' => '<p>The pagination token from a previous request that\'s used to retrieve the next page of results.</p>', 'GetCisScanResultDetailsResponse$nextToken' => '<p>The pagination token from a previous request that\'s used to retrieve the next page of results.</p>', 'ListAccountPermissionsRequest$nextToken' => '<p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. If your response returns more than the <code>maxResults</code> maximum value it will also return a <code>nextToken</code> value. For subsequent calls, use the NextToken value returned from the previous request to continue listing results after the first page.</p>', 'ListAccountPermissionsResponse$nextToken' => '<p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>', 'ListCisScanConfigurationsRequest$nextToken' => '<p>The pagination token from a previous request that\'s used to retrieve the next page of results.</p>', 'ListCisScanConfigurationsResponse$nextToken' => '<p>The pagination token from a previous request that\'s used to retrieve the next page of results.</p>', 'ListCisScanResultsAggregatedByChecksRequest$nextToken' => '<p>The pagination token from a previous request that\'s used to retrieve the next page of results.</p>', 'ListCisScanResultsAggregatedByChecksResponse$nextToken' => '<p>The pagination token from a previous request that\'s used to retrieve the next page of results.</p>', 'ListCisScanResultsAggregatedByTargetResourceRequest$nextToken' => '<p>The pagination token from a previous request that\'s used to retrieve the next page of results.</p>', 'ListCisScanResultsAggregatedByTargetResourceResponse$nextToken' => '<p>The pagination token from a previous request that\'s used to retrieve the next page of results.</p>', 'ListCisScansRequest$nextToken' => '<p>The pagination token from a previous request that\'s used to retrieve the next page of results.</p>', 'ListCisScansResponse$nextToken' => '<p>The pagination token from a previous request that\'s used to retrieve the next page of results.</p>', 'ListCoverageRequest$nextToken' => '<p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. If your response returns more than the <code>maxResults</code> maximum value it will also return a <code>nextToken</code> value. For subsequent calls, use the <code>nextToken</code> value returned from the previous request to continue listing results after the first page.</p>', 'ListCoverageResponse$nextToken' => '<p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>', 'ListCoverageStatisticsRequest$nextToken' => '<p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>', 'ListCoverageStatisticsResponse$nextToken' => '<p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>', 'ListDelegatedAdminAccountsRequest$nextToken' => '<p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. If your response returns more than the <code>maxResults</code> maximum value it will also return a <code>nextToken</code> value. For subsequent calls, use the <code>nextToken</code> value returned from the previous request to continue listing results after the first page.</p>', 'ListDelegatedAdminAccountsResponse$nextToken' => '<p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>', 'ListFiltersRequest$nextToken' => '<p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. If your response returns more than the <code>maxResults</code> maximum value it will also return a <code>nextToken</code> value. For subsequent calls, use the <code>nextToken</code> value returned from the previous request to continue listing results after the first page.</p>', 'ListFiltersResponse$nextToken' => '<p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>', 'ListFindingAggregationsRequest$nextToken' => '<p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. If your response returns more than the <code>maxResults</code> maximum value it will also return a <code>nextToken</code> value. For subsequent calls, use the <code>nextToken</code> value returned from the previous request to continue listing results after the first page.</p>', 'ListFindingAggregationsResponse$nextToken' => '<p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>', 'ListFindingsRequest$nextToken' => '<p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. If your response returns more than the <code>maxResults</code> maximum value it will also return a <code>nextToken</code> value. For subsequent calls, use the <code>nextToken</code> value returned from the previous request to continue listing results after the first page.</p>', 'ListFindingsResponse$nextToken' => '<p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>', 'ListMembersRequest$nextToken' => '<p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. If your response returns more than the <code>maxResults</code> maximum value it will also return a <code>nextToken</code> value. For subsequent calls, use the <code>nextToken</code> value returned from the previous request to continue listing results after the first page.</p>', 'ListMembersResponse$nextToken' => '<p>The pagination parameter to be used on the next list operation to retrieve more items.</p>', 'SearchVulnerabilitiesRequest$nextToken' => '<p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>', 'SearchVulnerabilitiesResponse$nextToken' => '<p>The pagination parameter to be used on the next list operation to retrieve more items.</p>', ], ], 'NonEmptyString' => [ 'base' => NULL, 'refs' => [ 'AwsEc2InstanceDetails$iamInstanceProfileArn' => '<p>The IAM instance profile ARN of the Amazon EC2 instance.</p>', 'AwsEc2InstanceDetails$imageId' => '<p>The image ID of the Amazon EC2 instance.</p>', 'AwsEc2InstanceDetails$keyName' => '<p>The name of the key pair used to launch the Amazon EC2 instance.</p>', 'AwsEc2InstanceDetails$subnetId' => '<p>The subnet ID of the Amazon EC2 instance.</p>', 'AwsEc2InstanceDetails$type' => '<p>The type of the Amazon EC2 instance.</p>', 'AwsEc2InstanceDetails$vpcId' => '<p>The VPC ID of the Amazon EC2 instance.</p>', 'AwsEcrContainerAggregationResponse$resourceId' => '<p>The resource ID of the container.</p>', 'AwsEcrContainerImageDetails$architecture' => '<p>The architecture of the Amazon ECR container image.</p>', 'AwsEcrContainerImageDetails$registry' => '<p>The registry for the Amazon ECR container image.</p>', 'AwsEcrContainerImageDetails$repositoryName' => '<p>The name of the repository the Amazon ECR container image resides in.</p>', 'AwsLambdaFunctionDetails$codeSha256' => '<p>The SHA256 hash of the Amazon Web Services Lambda function\'s deployment package.</p>', 'CodeFilePath$fileName' => '<p>The name of the file the code vulnerability was found in.</p>', 'CodeFilePath$filePath' => '<p>The file path to the code that a vulnerability was found in.</p>', 'CodeSnippetError$errorMessage' => '<p>The error message received when Amazon Inspector failed to retrieve a code snippet.</p>', 'CodeVulnerabilityDetails$detectorId' => '<p>The ID for the Amazon CodeGuru detector associated with the finding. For more information on detectors see <a href="https://docs.aws.amazon.com/codeguru/detector-library">Amazon CodeGuru Detector Library</a>.</p>', 'CodeVulnerabilityDetails$detectorName' => '<p>The name of the detector used to identify the code vulnerability. For more information on detectors see <a href="https://docs.aws.amazon.com/codeguru/detector-library">CodeGuru Detector Library</a>.</p>', 'CodeVulnerabilityDetails$ruleId' => '<p>The identifier for a rule that was used to detect the code vulnerability.</p>', 'CoverageMapFilter$key' => '<p>The tag key associated with the coverage map filter.</p>', 'CoverageMapFilter$value' => '<p>The tag value associated with the coverage map filter.</p>', 'CvssScore$scoringVector' => '<p>The vector string of the CVSS score.</p>', 'CvssScore$source' => '<p>The source of the CVSS score.</p>', 'CvssScore$version' => '<p>The version of CVSS used for the score.</p>', 'CvssScoreAdjustment$metric' => '<p>The metric used to adjust the CVSS score.</p>', 'CvssScoreAdjustment$reason' => '<p>The reason the CVSS score has been adjustment.</p>', 'CvssScoreDetails$cvssSource' => '<p>The source of the CVSS data.</p>', 'CvssScoreDetails$scoreSource' => '<p>The source for the CVSS score.</p>', 'CvssScoreDetails$scoringVector' => '<p>The vector for the CVSS score.</p>', 'CvssScoreDetails$version' => '<p>The CVSS version used in scoring.</p>', 'CweList$member' => NULL, 'DetectionPlatforms$member' => NULL, 'DetectorTagList$member' => NULL, 'Ec2InstanceAggregationResponse$instanceId' => '<p>The Amazon EC2 instance ID.</p>', 'FailedAccount$errorMessage' => '<p>The error message received when the account failed to enable Amazon Inspector.</p>', 'FailedMemberAccountEc2DeepInspectionStatusState$errorMessage' => '<p>The error message explaining why the account failed to activate Amazon Inspector deep inspection.</p>', 'FindingDetailsError$errorMessage' => '<p>The error message.</p>', 'GetEc2DeepInspectionConfigurationResponse$errorMessage' => '<p>An error message explaining why Amazon Inspector deep inspection configurations could not be retrieved for your account.</p>', 'GetSbomExportResponse$errorMessage' => '<p>An error message.</p>', 'ImageLayerAggregationResponse$layerHash' => '<p>The layer hash.</p>', 'ImageLayerAggregationResponse$repository' => '<p>The repository the layer resides in.</p>', 'ImageLayerAggregationResponse$resourceId' => '<p>The resource ID of the container image layer.</p>', 'ImageTagList$member' => NULL, 'LambdaFunctionAggregationResponse$resourceId' => '<p>The resource IDs included in the aggregation results.</p>', 'LambdaLayerAggregationResponse$functionName' => '<p>The names of the Amazon Web Services Lambda functions associated with the layers.</p>', 'LambdaLayerAggregationResponse$layerArn' => '<p>The Amazon Resource Name (ARN) of the Amazon Web Services Lambda function layer.</p>', 'LambdaLayerAggregationResponse$resourceId' => '<p>The Resource ID of the Amazon Web Services Lambda function layer.</p>', 'MemberAccountEc2DeepInspectionStatusState$errorMessage' => '<p>The error message explaining why the account failed to activate Amazon Inspector deep inspection.</p>', 'NonEmptyStringList$member' => NULL, 'PackageAggregationResponse$packageName' => '<p>The name of the operating system package.</p>', 'PackageVulnerabilityDetails$source' => '<p>The source of the vulnerability information.</p>', 'PackageVulnerabilityDetails$sourceUrl' => '<p>A URL to the source of the vulnerability information.</p>', 'PackageVulnerabilityDetails$vendorSeverity' => '<p>The severity the vendor has given to this vulnerability type.</p>', 'Recommendation$Url' => '<p>The URL address to the CVE remediation recommendations.</p>', 'Recommendation$text' => '<p>The recommended course of action to remediate the finding.</p>', 'ReferenceUrls$member' => NULL, 'RepositoryAggregationResponse$repository' => '<p>The name of the repository associated with the findings.</p>', 'Resource$id' => '<p>The ID of the resource.</p>', 'Resource$partition' => '<p>The partition of the resource.</p>', 'Resource$region' => '<p>The Amazon Web Services Region the impacted resource is located in.</p>', 'ResourceMapFilter$key' => '<p>The filter\'s key.</p>', 'ResourceMapFilter$value' => '<p>The filter\'s value.</p>', 'State$errorMessage' => '<p>The error message received when the account failed to enable Amazon Inspector.</p>', 'StringList$member' => NULL, 'TagFilter$key' => '<p>The tag filter key.</p>', 'TagFilter$value' => '<p>The tag filter value.</p>', 'TargetResourceTags$key' => NULL, 'TitleAggregationResponse$title' => '<p>The title that the findings were aggregated on.</p>', 'UpdateEc2DeepInspectionConfigurationResponse$errorMessage' => '<p>An error message explaining why new Amazon Inspector deep inspection custom paths could not be added.</p>', 'Vulnerability$id' => '<p>The ID for the specific vulnerability.</p>', ], ], 'NonEmptyStringList' => [ 'base' => NULL, 'refs' => [ 'PackageVulnerabilityDetails$referenceUrls' => '<p>One or more URLs that contain details about this vulnerability type.</p>', ], ], 'NumberFilter' => [ 'base' => '<p>An object that describes the details of a number filter.</p>', 'refs' => [ 'NumberFilterList$member' => NULL, 'PackageFilter$epoch' => '<p>An object that contains details on the package epoch to filter on.</p>', ], ], 'NumberFilterList' => [ 'base' => NULL, 'refs' => [ 'FilterCriteria$epssScore' => '<p>The EPSS score used to filter findings.</p>', 'FilterCriteria$inspectorScore' => '<p>The Amazon Inspector score to filter on.</p>', ], ], 'OneAccountIdFilterList' => [ 'base' => NULL, 'refs' => [ 'CisScanResultsAggregatedByChecksFilterCriteria$accountIdFilters' => '<p>The criteria\'s account ID filters.</p>', ], ], 'OneTimeSchedule' => [ 'base' => '<p>A one time schedule.</p>', 'refs' => [ 'Schedule$oneTime' => '<p>The schedule\'s one time.</p>', ], ], 'Operation' => [ 'base' => NULL, 'refs' => [ 'Permission$operation' => '<p>The operations that can be performed with the given permissions.</p>', ], ], 'OwnerId' => [ 'base' => NULL, 'refs' => [ 'Filter$ownerId' => '<p>The Amazon Web Services account ID of the account that created the filter.</p>', ], ], 'PackageAggregation' => [ 'base' => '<p>The details that define an aggregation based on operating system package type.</p>', 'refs' => [ 'AggregationRequest$packageAggregation' => '<p>An object that contains details about an aggregation request based on operating system package type.</p>', ], ], 'PackageAggregationResponse' => [ 'base' => '<p>A response that contains the results of a finding aggregation by image layer.</p>', 'refs' => [ 'AggregationResponse$packageAggregation' => '<p>An object that contains details about an aggregation response based on operating system package type.</p>', ], ], 'PackageArchitecture' => [ 'base' => NULL, 'refs' => [ 'VulnerablePackage$arch' => '<p>The architecture of the vulnerable package.</p>', ], ], 'PackageEpoch' => [ 'base' => NULL, 'refs' => [ 'VulnerablePackage$epoch' => '<p>The epoch of the vulnerable package.</p>', ], ], 'PackageFilter' => [ 'base' => '<p>Contains information on the details of a package filter.</p>', 'refs' => [ 'PackageFilterList$member' => NULL, ], ], 'PackageFilterList' => [ 'base' => NULL, 'refs' => [ 'FilterCriteria$vulnerablePackages' => '<p>Details on the vulnerable packages used to filter findings.</p>', ], ], 'PackageManager' => [ 'base' => NULL, 'refs' => [ 'VulnerablePackage$packageManager' => '<p>The package manager of the vulnerable package.</p>', ], ], 'PackageName' => [ 'base' => NULL, 'refs' => [ 'VulnerablePackage$name' => '<p>The name of the vulnerable package.</p>', ], ], 'PackageRelease' => [ 'base' => NULL, 'refs' => [ 'VulnerablePackage$release' => '<p>The release of the vulnerable package.</p>', ], ], 'PackageSortBy' => [ 'base' => NULL, 'refs' => [ 'PackageAggregation$sortBy' => '<p>The value to sort results by.</p>', ], ], 'PackageType' => [ 'base' => NULL, 'refs' => [ 'AwsLambdaFunctionDetails$packageType' => '<p>The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code> for .zip file archive.</p>', ], ], 'PackageVersion' => [ 'base' => NULL, 'refs' => [ 'VulnerablePackage$fixedInVersion' => '<p>The version of the package that contains the vulnerability fix.</p>', 'VulnerablePackage$version' => '<p>The version of the vulnerable package.</p>', ], ], 'PackageVulnerabilityDetails' => [ 'base' => '<p>Information about a package vulnerability finding.</p>', 'refs' => [ 'Finding$packageVulnerabilityDetails' => '<p>An object that contains the details of a package vulnerability finding.</p>', ], ], 'Path' => [ 'base' => NULL, 'refs' => [ 'PathList$member' => NULL, ], ], 'PathList' => [ 'base' => NULL, 'refs' => [ 'GetEc2DeepInspectionConfigurationResponse$orgPackagePaths' => '<p>The Amazon Inspector deep inspection custom paths for your organization.</p>', 'GetEc2DeepInspectionConfigurationResponse$packagePaths' => '<p>The Amazon Inspector deep inspection custom paths for your account.</p>', 'UpdateEc2DeepInspectionConfigurationRequest$packagePaths' => '<p>The Amazon Inspector deep inspection custom paths you are adding for your account.</p>', 'UpdateEc2DeepInspectionConfigurationResponse$orgPackagePaths' => '<p>The current Amazon Inspector deep inspection custom paths for the organization.</p>', 'UpdateEc2DeepInspectionConfigurationResponse$packagePaths' => '<p>The current Amazon Inspector deep inspection custom paths for your account.</p>', 'UpdateOrgEc2DeepInspectionConfigurationRequest$orgPackagePaths' => '<p>The Amazon Inspector deep inspection custom paths you are adding for your organization.</p>', ], ], 'Permission' => [ 'base' => '<p>Contains information on the permissions an account has within Amazon Inspector.</p>', 'refs' => [ 'Permissions$member' => NULL, ], ], 'Permissions' => [ 'base' => NULL, 'refs' => [ 'ListAccountPermissionsResponse$permissions' => '<p>Contains details on the permissions an account has to configure Amazon Inspector.</p>', ], ], 'Platform' => [ 'base' => NULL, 'refs' => [ 'AwsEc2InstanceDetails$platform' => '<p>The platform of the Amazon EC2 instance.</p>', 'AwsEcrContainerImageDetails$platform' => '<p>The platform of the Amazon ECR container image.</p>', ], ], 'PlatformFilterList' => [ 'base' => NULL, 'refs' => [ 'CisScanResultsAggregatedByChecksFilterCriteria$platformFilters' => '<p>The criteria\'s platform filters.</p>', 'CisScanResultsAggregatedByTargetResourceFilterCriteria$platformFilters' => '<p>The criteria\'s platform filters.</p>', ], ], 'PlatformVersion' => [ 'base' => NULL, 'refs' => [ 'ComputePlatform$version' => '<p>The compute platform version.</p>', ], ], 'Port' => [ 'base' => NULL, 'refs' => [ 'PortRange$begin' => '<p>The beginning port in a port range.</p>', 'PortRange$end' => '<p>The ending port in a port range.</p>', 'PortRangeFilter$beginInclusive' => '<p>The port number the port range begins at.</p>', 'PortRangeFilter$endInclusive' => '<p>The port number the port range ends at.</p>', ], ], 'PortRange' => [ 'base' => '<p>Details about the port range associated with a finding.</p>', 'refs' => [ 'NetworkReachabilityDetails$openPortRange' => '<p>An object that contains details about the open port range associated with a finding.</p>', ], ], 'PortRangeFilter' => [ 'base' => '<p>An object that describes the details of a port range filter.</p>', 'refs' => [ 'PortRangeFilterList$member' => NULL, ], ], 'PortRangeFilterList' => [ 'base' => NULL, 'refs' => [ 'FilterCriteria$portRange' => '<p>Details on the port ranges used to filter findings.</p>', ], ], 'Product' => [ 'base' => NULL, 'refs' => [ 'ComputePlatform$product' => '<p>The compute platform product.</p>', ], ], 'Reason' => [ 'base' => NULL, 'refs' => [ 'StopCisSessionMessage$reason' => '<p>The reason for the message.</p>', ], ], 'Recommendation' => [ 'base' => '<p>Details about the recommended course of action to remediate the finding.</p>', 'refs' => [ 'Remediation$recommendation' => '<p>An object that contains information about the recommended course of action to remediate the finding.</p>', ], ], 'ReferenceUrls' => [ 'base' => NULL, 'refs' => [ 'CodeVulnerabilityDetails$referenceUrls' => '<p>A URL containing supporting documentation about the code vulnerability detected.</p>', ], ], 'RelatedVulnerabilities' => [ 'base' => NULL, 'refs' => [ 'Vulnerability$relatedVulnerabilities' => '<p>A list of related vulnerabilities.</p>', ], ], 'RelatedVulnerability' => [ 'base' => NULL, 'refs' => [ 'RelatedVulnerabilities$member' => NULL, ], ], 'RelationshipStatus' => [ 'base' => NULL, 'refs' => [ 'DelegatedAdmin$relationshipStatus' => '<p>The status of the Amazon Inspector delegated administrator.</p>', 'Member$relationshipStatus' => '<p>The status of the member account.</p>', ], ], 'Remediation' => [ 'base' => '<p>Information on how to remediate a finding.</p>', 'refs' => [ 'Finding$remediation' => '<p>An object that contains the details about how to remediate a finding.</p>', ], ], 'ReportFormat' => [ 'base' => NULL, 'refs' => [ 'CreateFindingsReportRequest$reportFormat' => '<p>The format to generate the report in.</p>', ], ], 'ReportId' => [ 'base' => NULL, 'refs' => [ 'CancelFindingsReportRequest$reportId' => '<p>The ID of the report to be canceled.</p>', 'CancelFindingsReportResponse$reportId' => '<p>The ID of the canceled report.</p>', 'CancelSbomExportRequest$reportId' => '<p>The report ID of the SBOM export to cancel.</p>', 'CancelSbomExportResponse$reportId' => '<p>The report ID of the canceled SBOM export.</p>', 'CreateFindingsReportResponse$reportId' => '<p>The ID of the report.</p>', 'CreateSbomExportResponse$reportId' => '<p>The report ID for the software bill of materials (SBOM) report.</p>', 'GetFindingsReportStatusRequest$reportId' => '<p>The ID of the report to retrieve the status of.</p>', 'GetFindingsReportStatusResponse$reportId' => '<p>The ID of the report.</p>', 'GetSbomExportRequest$reportId' => '<p>The report ID of the SBOM export to get details for.</p>', 'GetSbomExportResponse$reportId' => '<p>The report ID of the software bill of materials (SBOM) report.</p>', ], ], 'ReportTargetAccounts' => [ 'base' => NULL, 'refs' => [ 'GetCisScanReportRequest$targetAccounts' => '<p>The target accounts.</p>', ], ], 'ReportingErrorCode' => [ 'base' => NULL, 'refs' => [ 'GetFindingsReportStatusResponse$errorCode' => '<p>The error code of the report.</p>', 'GetSbomExportResponse$errorCode' => '<p>An error code.</p>', ], ], 'RepositoryAggregation' => [ 'base' => '<p>The details that define an aggregation based on repository.</p>', 'refs' => [ 'AggregationRequest$repositoryAggregation' => '<p>An object that contains details about an aggregation request based on Amazon ECR repositories.</p>', ], ], 'RepositoryAggregationResponse' => [ 'base' => '<p>A response that contains details on the results of a finding aggregation by repository.</p>', 'refs' => [ 'AggregationResponse$repositoryAggregation' => '<p>An object that contains details about an aggregation response based on Amazon ECR repositories.</p>', ], ], 'RepositorySortBy' => [ 'base' => NULL, 'refs' => [ 'RepositoryAggregation$sortBy' => '<p>The value to sort results by.</p>', ], ], 'ResetEncryptionKeyRequest' => [ 'base' => NULL, 'refs' => [], ], 'ResetEncryptionKeyResponse' => [ 'base' => NULL, 'refs' => [], ], 'Resource' => [ 'base' => '<p>Details about the resource involved in a finding.</p>', 'refs' => [ 'ResourceList$member' => NULL, ], ], 'ResourceDetails' => [ 'base' => '<p>Contains details about the resource involved in the finding.</p>', 'refs' => [ 'Resource$details' => '<p>An object that contains details about the resource involved in a finding.</p>', ], ], 'ResourceFilterCriteria' => [ 'base' => '<p>The resource filter criteria for a Software bill of materials (SBOM) report.</p>', 'refs' => [ 'CreateSbomExportRequest$resourceFilterCriteria' => '<p>The resource filter criteria for the software bill of materials (SBOM) report.</p>', 'GetSbomExportResponse$filterCriteria' => '<p>Contains details about the resource filter criteria used for the software bill of materials (SBOM) report.</p>', ], ], 'ResourceId' => [ 'base' => NULL, 'refs' => [ 'CisScanResultDetails$targetResourceId' => '<p>The CIS scan result details\' target resource ID.</p>', 'CisTargetResourceAggregation$targetResourceId' => '<p>The ID of the target resource.</p>', 'CoveredResource$resourceId' => '<p>The ID of the covered resource.</p>', 'GetCisScanResultDetailsRequest$targetResourceId' => '<p>The target resource ID.</p>', ], ], 'ResourceIdFilterList' => [ 'base' => NULL, 'refs' => [ 'CisScanResultsAggregatedByTargetResourceFilterCriteria$targetResourceIdFilters' => '<p>The criteria\'s target resource ID filters.</p>', 'ListCisScansFilterCriteria$targetResourceIdFilters' => '<p>The list of target resource ID filters.</p>', ], ], 'ResourceList' => [ 'base' => NULL, 'refs' => [ 'Finding$resources' => '<p>Contains information on the resources involved in a finding. The <code>resource</code> value determines the valid values for <code>type</code> in your request. For more information, see <a href="https://docs.aws.amazon.com/inspector/latest/user/findings-types.html">Finding types</a> in the Amazon Inspector user guide.</p>', ], ], 'ResourceMapComparison' => [ 'base' => NULL, 'refs' => [ 'ResourceMapFilter$comparison' => '<p>The filter\'s comparison.</p>', ], ], 'ResourceMapFilter' => [ 'base' => '<p>A resource map filter for a software bill of material report.</p>', 'refs' => [ 'ResourceMapFilterList$member' => NULL, ], ], 'ResourceMapFilterList' => [ 'base' => NULL, 'refs' => [ 'ResourceFilterCriteria$ec2InstanceTags' => '<p>The EC2 instance tags used as resource filter criteria.</p>', 'ResourceFilterCriteria$lambdaFunctionTags' => '<p>The Amazon Web Services Lambda function tags used as resource filter criteria.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The operation tried to access an invalid resource. Make sure the resource is specified correctly.</p>', 'refs' => [], ], 'ResourceScanMetadata' => [ 'base' => '<p>An object that contains details about the metadata for an Amazon ECR resource.</p>', 'refs' => [ 'CoveredResource$resourceMetadata' => '<p>An object that contains details about the metadata.</p>', ], ], 'ResourceScanType' => [ 'base' => NULL, 'refs' => [ 'DisableResourceTypeList$member' => NULL, 'EnableResourceTypeList$member' => NULL, ], ], 'ResourceState' => [ 'base' => '<p>Details the state of Amazon Inspector for each resource type Amazon Inspector scans.</p>', 'refs' => [ 'AccountState$resourceState' => '<p>An object detailing which resources Amazon Inspector is enabled to scan for the account.</p>', ], ], 'ResourceStatus' => [ 'base' => '<p>Details the status of Amazon Inspector for each resource type Amazon Inspector scans.</p>', 'refs' => [ 'Account$resourceStatus' => '<p>Details of the status of Amazon Inspector scans by resource type.</p>', 'FailedAccount$resourceStatus' => '<p>An object detailing which resources Amazon Inspector is enabled to scan for the account.</p>', ], ], 'ResourceStringComparison' => [ 'base' => NULL, 'refs' => [ 'ResourceStringFilter$comparison' => '<p>The filter\'s comparison.</p>', ], ], 'ResourceStringFilter' => [ 'base' => '<p>A resource string filter for a software bill of materials report.</p>', 'refs' => [ 'ResourceStringFilterList$member' => NULL, ], ], 'ResourceStringFilterList' => [ 'base' => NULL, 'refs' => [ 'ResourceFilterCriteria$accountId' => '<p>The account IDs used as resource filter criteria.</p>', 'ResourceFilterCriteria$ecrImageTags' => '<p>The ECR image tags used as resource filter criteria.</p>', 'ResourceFilterCriteria$ecrRepositoryName' => '<p>The ECR repository names used as resource filter criteria.</p>', 'ResourceFilterCriteria$lambdaFunctionName' => '<p>The Amazon Web Services Lambda function name used as resource filter criteria.</p>', 'ResourceFilterCriteria$resourceId' => '<p>The resource IDs used as resource filter criteria.</p>', 'ResourceFilterCriteria$resourceType' => '<p>The resource types used as resource filter criteria.</p>', ], ], 'ResourceStringInput' => [ 'base' => NULL, 'refs' => [ 'ResourceStringFilter$value' => '<p>The filter\'s value.</p>', ], ], 'ResourceTagFilterList' => [ 'base' => NULL, 'refs' => [ 'CisScanResultsAggregatedByTargetResourceFilterCriteria$targetResourceTagFilters' => '<p>The criteria\'s target resource tag filters.</p>', 'ListCisScanConfigurationsFilterCriteria$targetResourceTagFilters' => '<p>The list of target resource tag filters.</p>', 'ListCisScansFilterCriteria$targetResourceTagFilters' => '<p>The list of target resource tag filters.</p>', ], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'GetEncryptionKeyRequest$resourceType' => '<p>The resource type the key encrypts.</p>', 'ResetEncryptionKeyRequest$resourceType' => '<p>The resource type the key encrypts.</p>', 'Resource$type' => '<p>The type of resource.</p>', 'UpdateEncryptionKeyRequest$resourceType' => '<p>The resource type for the encryption key.</p>', ], ], 'RiskScore' => [ 'base' => NULL, 'refs' => [ 'FindingDetail$riskScore' => '<p>The risk score of the vulnerability.</p>', ], ], 'RuleId' => [ 'base' => NULL, 'refs' => [ 'CisSessionMessage$ruleId' => '<p>The rule ID for the CIS session message.</p>', ], ], 'Runtime' => [ 'base' => NULL, 'refs' => [ 'AwsLambdaFunctionDetails$runtime' => '<p>The runtime environment for the Amazon Web Services Lambda function.</p>', 'LambdaFunctionMetadata$runtime' => '<p>An Amazon Web Services Lambda function\'s runtime.</p>', ], ], 'SbomReportFormat' => [ 'base' => NULL, 'refs' => [ 'CreateSbomExportRequest$reportFormat' => '<p>The output format for the software bill of materials (SBOM) report.</p>', 'GetSbomExportResponse$format' => '<p>The format of the software bill of materials (SBOM) report.</p>', ], ], 'ScanMode' => [ 'base' => NULL, 'refs' => [ 'CoveredResource$scanMode' => '<p>The scan method that is applied to the instance.</p>', ], ], 'ScanStatus' => [ 'base' => '<p>The status of the scan.</p>', 'refs' => [ 'CoveredResource$scanStatus' => '<p>The status of the scan covering the resource.</p>', ], ], 'ScanStatusCode' => [ 'base' => NULL, 'refs' => [ 'ScanStatus$statusCode' => '<p>The status code of the scan.</p>', ], ], 'ScanStatusReason' => [ 'base' => NULL, 'refs' => [ 'ScanStatus$reason' => '<p>The scan status. Possible return values and descriptions are: </p> <p> <code>PENDING_INITIAL_SCAN</code> - This resource has been identified for scanning, results will be available soon.</p> <p> <code>ACCESS_DENIED</code> - Resource access policy restricting Amazon Inspector access. Please update the IAM policy.</p> <p> <code>INTERNAL_ERROR</code> - Amazon Inspector has encountered an internal error for this resource. Amazon Inspector service will automatically resolve the issue and resume the scanning. No action required from the user.</p> <p> <code>UNMANAGED_EC2_INSTANCE</code> - The EC2 instance is not managed by SSM, please use the following SSM automation to remediate the issue: <a href="https://docs.aws.amazon.com/systems-manager-automation-runbooks/latest/userguide/automation-awssupport-troubleshoot-managed-instance.html">https://docs.aws.amazon.com/systems-manager-automation-runbooks/latest/userguide/automation-awssupport-troubleshoot-managed-instance.html</a>. Once the instance becomes managed by SSM, Inspector will automatically begin scanning this instance. </p> <p> <code>UNSUPPORTED_OS</code> - Amazon Inspector does not support this OS, architecture, or image manifest type at this time. To see a complete list of supported operating systems see: <a href=" https://docs.aws.amazon.com/inspector/latest/user/supported.html">https://docs.aws.amazon.com/inspector/latest/user/supported.html</a>.</p> <p> <code>SCAN_ELIGIBILITY_EXPIRED</code> - The configured scan duration has lapsed for this image.</p> <p> <code>RESOURCE_TERMINATED</code> - This resource has been terminated. The findings and coverage associated with this resource are in the process of being cleaned up.</p> <p> <code>SUCCESSFUL</code> - The scan was successful.</p> <p> <code>NO_RESOURCES_FOUND</code> - Reserved for future use.</p> <p> <code>IMAGE_SIZE_EXCEEDED</code> - Reserved for future use.</p> <p> <code>SCAN_FREQUENCY_MANUAL</code> - This image will not be covered by Amazon Inspector due to the repository scan frequency configuration.</p> <p> <code>SCAN_FREQUENCY_SCAN_ON_PUSH </code>- This image will be scanned one time and will not new findings because of the scan frequency configuration.</p> <p> <code>EC2_INSTANCE_STOPPED</code> - This EC2 instance is in a stopped state, therefore, Amazon Inspector will pause scanning. The existing findings will continue to exist until the instance is terminated. Once the instance is re-started, Inspector will automatically start scanning the instance again. Please note that you will not be charged for this instance while it’s in a stopped state.</p> <p> <code>PENDING_DISABLE</code> - This resource is pending cleanup during disablement. The customer will not be billed while a resource is in the pending disable status.</p> <p> <code>NO INVENTORY</code> - Amazon Inspector couldn’t find software application inventory to scan for vulnerabilities. This might be caused due to required Amazon Inspector associations being deleted or failing to run on your resource. Please verify the status of <code>InspectorInventoryCollection-do-not-delete</code> association in the SSM console for the resource. Additionally, you can verify the instance’s inventory in the SSM Fleet Manager console.</p> <p> <code>STALE_INVENTORY</code> - Amazon Inspector wasn’t able to collect an updated software application inventory in the last 7 days. Please confirm the required Amazon Inspector associations still exist and you can still see an updated inventory in the SSM console.</p> <p> <code>EXCLUDED_BY_TAG</code> - This resource was not scanned because it has been excluded by a tag.</p> <p> <code>UNSUPPORTED_RUNTIME</code> - The function was not scanned because it has an unsupported runtime. To see a complete list of supported runtimes see: <a href=" https://docs.aws.amazon.com/inspector/latest/user/supported.html">https://docs.aws.amazon.com/inspector/latest/user/supported.html</a>.</p> <p> <code>UNSUPPORTED_MEDIA_TYPE </code>- The ECR image has an unsupported media type.</p> <p> <code>UNSUPPORTED_CONFIG_FILE</code> - Reserved for future use.</p> <p> <code>DEEP_INSPECTION_PACKAGE_COLLECTION_LIMIT_EXCEEDED</code> - The instance has exceeded the 5000 package limit for Amazon Inspector Deep inspection. To resume Deep inspection for this instance you can try to adjust the custom paths associated with the account.</p> <p> <code>DEEP_INSPECTION_DAILY_SSM_INVENTORY_LIMIT_EXCEEDED</code> - The SSM agent couldn\'t send inventory to Amazon Inspector because the SSM quota for Inventory data collected per instance per day has already been reached for this instance.</p> <p> <code>DEEP_INSPECTION_COLLECTION_TIME_LIMIT_EXCEEDED</code> - Amazon Inspector failed to extract the package inventory because the package collection time exceeding the maximum threshold of 15 minutes.</p> <p> <code>DEEP_INSPECTION_NO_INVENTORY</code> The Amazon Inspector plugin hasn\'t yet been able to collect an inventory of packages for this instance. This is usually the result of a pending scan, however, if this status persists after 6 hours, use SSM to ensure that the required Amazon Inspector associations exist and are running for the instance.</p> <p/>', ], ], 'ScanType' => [ 'base' => NULL, 'refs' => [ 'CoveredResource$scanType' => '<p>The Amazon Inspector scan type covering the resource.</p>', 'GetEncryptionKeyRequest$scanType' => '<p>The scan type the key encrypts.</p>', 'ResetEncryptionKeyRequest$scanType' => '<p>The scan type the key encrypts.</p>', 'UpdateEncryptionKeyRequest$scanType' => '<p>The scan type for the encryption key.</p>', ], ], 'Schedule' => [ 'base' => '<p>A schedule.</p>', 'refs' => [ 'CisScanConfiguration$schedule' => '<p>The CIS scan configuration\'s schedule.</p>', 'CreateCisScanConfigurationRequest$schedule' => '<p>The schedule for the CIS scan configuration.</p>', 'UpdateCisScanConfigurationRequest$schedule' => '<p>The schedule for the CIS scan configuration.</p>', ], ], 'SearchVulnerabilitiesFilterCriteria' => [ 'base' => '<p>Details on the criteria used to define the filter for a vulnerability search. </p>', 'refs' => [ 'SearchVulnerabilitiesRequest$filterCriteria' => '<p>The criteria used to filter the results of a vulnerability search.</p>', ], ], 'SearchVulnerabilitiesRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchVulnerabilitiesResponse' => [ 'base' => NULL, 'refs' => [], ], 'SecurityGroupId' => [ 'base' => NULL, 'refs' => [ 'SecurityGroupIdList$member' => NULL, ], ], 'SecurityGroupIdList' => [ 'base' => NULL, 'refs' => [ 'LambdaVpcConfig$securityGroupIds' => '<p>The VPC security groups and subnets that are attached to an Amazon Web Services Lambda function. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-vpc.html">VPC Settings</a>.</p>', ], ], 'SendCisSessionHealthRequest' => [ 'base' => NULL, 'refs' => [], ], 'SendCisSessionHealthResponse' => [ 'base' => NULL, 'refs' => [], ], 'SendCisSessionTelemetryRequest' => [ 'base' => NULL, 'refs' => [], ], 'SendCisSessionTelemetryResponse' => [ 'base' => NULL, 'refs' => [], ], 'Service' => [ 'base' => NULL, 'refs' => [ 'ListAccountPermissionsRequest$service' => '<p>The service scan type to check permissions for.</p>', 'Permission$service' => '<p>The services that the permissions allow an account to perform the given operations for.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>You have exceeded your service quota. To perform the requested action, remove some of the relevant resources, or use Service Quotas to request a service quota increase.</p>', 'refs' => [], ], 'Severity' => [ 'base' => NULL, 'refs' => [ 'Finding$severity' => '<p>The severity of the finding. <code>UNTRIAGED</code> applies to <code>PACKAGE_VULNERABILITY</code> type findings that the vendor has not assigned a severity yet. For more information, see <a href="https://docs.aws.amazon.com/inspector/latest/user/findings-understanding-severity.html">Severity levels for findings</a> in the Amazon Inspector user guide.</p>', ], ], 'SeverityCounts' => [ 'base' => '<p>An object that contains the counts of aggregated finding per severity.</p>', 'refs' => [ 'AccountAggregationResponse$severityCounts' => '<p>The number of findings by severity.</p>', 'AmiAggregationResponse$severityCounts' => '<p>An object that contains the count of matched findings per severity.</p>', 'AwsEcrContainerAggregationResponse$severityCounts' => '<p>The number of finding by severity.</p>', 'Ec2InstanceAggregationResponse$severityCounts' => '<p>An object that contains the count of matched findings per severity.</p>', 'FindingTypeAggregationResponse$severityCounts' => '<p>The value to sort results by.</p>', 'ImageLayerAggregationResponse$severityCounts' => '<p>An object that represents the count of matched findings per severity.</p>', 'LambdaFunctionAggregationResponse$severityCounts' => NULL, 'LambdaLayerAggregationResponse$severityCounts' => NULL, 'PackageAggregationResponse$severityCounts' => '<p>An object that contains the count of matched findings per severity.</p>', 'RepositoryAggregationResponse$severityCounts' => '<p>An object that represent the count of matched findings per severity.</p>', 'TitleAggregationResponse$severityCounts' => '<p>An object that represent the count of matched findings per severity.</p>', ], ], 'SortCriteria' => [ 'base' => '<p>Details about the criteria used to sort finding results.</p>', 'refs' => [ 'ListFindingsRequest$sortCriteria' => '<p>Details on the sort criteria to apply to your finding results.</p>', ], ], 'SortField' => [ 'base' => NULL, 'refs' => [ 'SortCriteria$field' => '<p>The finding detail field by which results are sorted.</p>', ], ], 'SortOrder' => [ 'base' => NULL, 'refs' => [ 'AccountAggregation$sortOrder' => '<p>The sort order (ascending or descending).</p>', 'AmiAggregation$sortOrder' => '<p>The order to sort results by.</p>', 'AwsEcrContainerAggregation$sortOrder' => '<p>The sort order (ascending or descending).</p>', 'Ec2InstanceAggregation$sortOrder' => '<p>The order to sort results by.</p>', 'FindingTypeAggregation$sortOrder' => '<p>The order to sort results by.</p>', 'ImageLayerAggregation$sortOrder' => '<p>The order to sort results by.</p>', 'LambdaFunctionAggregation$sortOrder' => '<p>The order to use for sorting the results.</p>', 'LambdaLayerAggregation$sortOrder' => '<p>The order to use for sorting the results.</p>', 'PackageAggregation$sortOrder' => '<p>The order to sort results by.</p>', 'RepositoryAggregation$sortOrder' => '<p>The order to sort results by.</p>', 'SortCriteria$sortOrder' => '<p>The order by which findings are sorted.</p>', 'TitleAggregation$sortOrder' => '<p>The order to sort results by.</p>', ], ], 'SourceLayerHash' => [ 'base' => NULL, 'refs' => [ 'VulnerablePackage$sourceLayerHash' => '<p>The source layer hash of the vulnerable package.</p>', ], ], 'StartCisSessionMessage' => [ 'base' => '<p>The start CIS session message.</p>', 'refs' => [ 'StartCisSessionRequest$message' => '<p>The start CIS session message.</p>', ], ], 'StartCisSessionRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartCisSessionResponse' => [ 'base' => NULL, 'refs' => [], ], 'State' => [ 'base' => '<p>An object that described the state of Amazon Inspector scans for an account.</p>', 'refs' => [ 'AccountState$state' => '<p>An object detailing the status of Amazon Inspector for the account.</p>', 'ResourceState$ec2' => '<p>An object detailing the state of Amazon Inspector scanning for Amazon EC2 resources.</p>', 'ResourceState$ecr' => '<p>An object detailing the state of Amazon Inspector scanning for Amazon ECR resources.</p>', 'ResourceState$lambda' => NULL, 'ResourceState$lambdaCode' => NULL, ], ], 'Status' => [ 'base' => NULL, 'refs' => [ 'Account$status' => '<p>The status of Amazon Inspector for the account.</p>', 'FailedAccount$status' => '<p>The status of Amazon Inspector for the account.</p>', 'FailedMemberAccountEc2DeepInspectionStatusState$ec2ScanStatus' => '<p>The status of EC2 scanning in the account that failed to activate Amazon Inspector deep inspection.</p>', 'ResourceStatus$ec2' => '<p>The status of Amazon Inspector scanning for Amazon EC2 resources.</p>', 'ResourceStatus$ecr' => '<p>The status of Amazon Inspector scanning for Amazon ECR resources.</p>', 'ResourceStatus$lambda' => '<p>The status of Amazon Inspector scanning for Amazon Web Services Lambda function.</p>', 'ResourceStatus$lambdaCode' => '<p>The status of Amazon Inspector scanning for custom application code for Amazon Web Services Lambda functions. </p>', 'State$status' => '<p>The status of Amazon Inspector for the account.</p>', ], ], 'StatusCounts' => [ 'base' => '<p>The status counts.</p>', 'refs' => [ 'CisCheckAggregation$statusCounts' => '<p>The CIS check status counts.</p>', 'CisTargetResourceAggregation$statusCounts' => '<p>The target resource status counts.</p>', ], ], 'Step' => [ 'base' => '<p>Details about the step associated with a finding.</p>', 'refs' => [ 'StepList$member' => NULL, ], ], 'StepList' => [ 'base' => NULL, 'refs' => [ 'NetworkPath$steps' => '<p>The details on the steps in the network path.</p>', ], ], 'StopCisMessageProgress' => [ 'base' => '<p>The stop CIS message progress.</p>', 'refs' => [ 'StopCisSessionMessage$progress' => '<p>The progress of the message.</p>', ], ], 'StopCisSessionMessage' => [ 'base' => '<p>The stop CIS session message.</p>', 'refs' => [ 'StopCisSessionRequest$message' => '<p>The stop CIS session message.</p>', ], ], 'StopCisSessionRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopCisSessionResponse' => [ 'base' => NULL, 'refs' => [], ], 'StopCisSessionStatus' => [ 'base' => NULL, 'refs' => [ 'StopCisSessionMessage$status' => '<p>The status of the message.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'AwsEcrContainerAggregationResponse$architecture' => '<p>The architecture of the container.</p>', 'AwsEcrContainerAggregationResponse$imageSha' => '<p>The SHA value of the container image.</p>', 'AwsEcrContainerAggregationResponse$repository' => '<p>The container repository.</p>', 'AwsEcrContainerImageDetails$author' => '<p>The image author of the Amazon ECR container image.</p>', 'BadRequestException$message' => NULL, 'CisCheckAggregation$checkDescription' => '<p>The description for the CIS check.</p>', 'CisCheckAggregation$checkId' => '<p>The check ID for the CIS check.</p>', 'CisCheckAggregation$platform' => '<p>The CIS check platform.</p>', 'CisCheckAggregation$title' => '<p>The CIS check title.</p>', 'CisScan$scheduledBy' => '<p>The account or organization that schedules the CIS scan.</p>', 'CisScanResultDetails$checkDescription' => '<p>The account ID that\'s associated with the CIS scan result details.</p>', 'CisScanResultDetails$checkId' => '<p>The CIS scan result details\' check ID.</p>', 'CisScanResultDetails$platform' => '<p>The CIS scan result details\' platform.</p>', 'CisScanResultDetails$remediation' => '<p>The CIS scan result details\' remediation.</p>', 'CisScanResultDetails$statusReason' => '<p>The CIS scan result details\' status reason.</p>', 'CisScanResultDetails$title' => '<p>The CIS scan result details\' title.</p>', 'CisStringFilter$value' => '<p>The value of the CIS string filter.</p>', 'CisTargetResourceAggregation$platform' => '<p>The platform for the CIS target resource.</p>', 'ConflictException$message' => NULL, 'ConflictException$resourceId' => '<p>The ID of the conflicting resource.</p>', 'ConflictException$resourceType' => '<p>The type of the conflicting resource.</p>', 'Destination$bucketName' => '<p>The name of the Amazon S3 bucket to export findings to.</p>', 'Destination$keyPrefix' => '<p>The prefix that the findings will be written under.</p>', 'Destination$kmsKeyArn' => '<p>The ARN of the KMS key used to encrypt data when exporting findings.</p>', 'Ec2InstanceAggregationResponse$accountId' => '<p>The Amazon Web Services account for the Amazon EC2 instance.</p>', 'Ec2InstanceAggregationResponse$operatingSystem' => '<p>The operating system of the Amazon EC2 instance.</p>', 'EcrRepositoryMetadata$name' => '<p>The name of the Amazon ECR repository.</p>', 'FreeTrialInfoError$message' => '<p>The error message returned.</p>', 'GetCisScanReportResponse$url' => '<p> The URL where a PDF or CSV of the CIS scan report can be downloaded. </p>', 'InternalServerException$message' => NULL, 'LambdaFunctionAggregationResponse$functionName' => '<p>The Amazon Web Services Lambda function names included in the aggregation results.</p>', 'LambdaFunctionAggregationResponse$runtime' => '<p>The runtimes included in the aggregation results.</p>', 'LambdaFunctionMetadata$functionName' => '<p>The name of a function.</p>', 'LambdaLayerList$member' => NULL, 'ResourceNotFoundException$message' => NULL, 'ServiceQuotaExceededException$message' => NULL, 'ServiceQuotaExceededException$resourceId' => '<p>The ID of the resource that exceeds a service quota.</p>', 'TagList$member' => NULL, 'TagValueList$member' => NULL, 'ThrottlingException$message' => NULL, 'TitleAggregationResponse$vulnerabilityId' => '<p>The vulnerability ID of the finding.</p>', 'ValidationException$message' => NULL, 'ValidationExceptionField$message' => '<p>The validation exception message.</p>', 'ValidationExceptionField$name' => '<p>The name of the validation exception.</p>', ], ], 'StringComparison' => [ 'base' => NULL, 'refs' => [ 'StringFilter$comparison' => '<p>The operator to use when comparing values in the filter.</p>', ], ], 'StringFilter' => [ 'base' => '<p>An object that describes the details of a string filter.</p>', 'refs' => [ 'PackageFilter$architecture' => '<p>An object that contains details on the package architecture type to filter on.</p>', 'PackageFilter$name' => '<p>An object that contains details on the name of the package to filter on.</p>', 'PackageFilter$release' => '<p>An object that contains details on the package release to filter on.</p>', 'PackageFilter$sourceLambdaLayerArn' => NULL, 'PackageFilter$sourceLayerHash' => '<p>An object that contains details on the source layer hash to filter on.</p>', 'PackageFilter$version' => '<p>The package version to filter on.</p>', 'StringFilterList$member' => NULL, ], ], 'StringFilterList' => [ 'base' => NULL, 'refs' => [ 'AmiAggregation$amis' => '<p>The IDs of AMIs to aggregate findings for.</p>', 'AwsEcrContainerAggregation$architectures' => '<p>The architecture of the containers.</p>', 'AwsEcrContainerAggregation$imageShas' => '<p>The image SHA values.</p>', 'AwsEcrContainerAggregation$imageTags' => '<p>The image tags.</p>', 'AwsEcrContainerAggregation$repositories' => '<p>The container repositories.</p>', 'AwsEcrContainerAggregation$resourceIds' => '<p>The container resource IDs.</p>', 'Ec2InstanceAggregation$amis' => '<p>The AMI IDs associated with the Amazon EC2 instances to aggregate findings for.</p>', 'Ec2InstanceAggregation$instanceIds' => '<p>The Amazon EC2 instance IDs to aggregate findings for.</p>', 'Ec2InstanceAggregation$operatingSystems' => '<p>The operating system types to aggregate findings for. Valid values must be uppercase and underscore separated, examples are <code>ORACLE_LINUX_7</code> and <code>ALPINE_LINUX_3_8</code>.</p>', 'FilterCriteria$awsAccountId' => '<p>Details of the Amazon Web Services account IDs used to filter findings.</p>', 'FilterCriteria$codeVulnerabilityDetectorName' => '<p>The name of the detector used to identify a code vulnerability in a Lambda function used to filter findings.</p>', 'FilterCriteria$codeVulnerabilityDetectorTags' => '<p>The detector type tag associated with the vulnerability used to filter findings. Detector tags group related vulnerabilities by common themes or tactics. For a list of available tags by programming language, see <a href="https://docs.aws.amazon.com/codeguru/detector-library/java/tags/">Java tags</a>, or <a href="https://docs.aws.amazon.com/codeguru/detector-library/python/tags/">Python tags</a>. </p>', 'FilterCriteria$codeVulnerabilityFilePath' => '<p>The file path to the file in a Lambda function that contains a code vulnerability used to filter findings.</p>', 'FilterCriteria$componentId' => '<p>Details of the component IDs used to filter findings.</p>', 'FilterCriteria$componentType' => '<p>Details of the component types used to filter findings.</p>', 'FilterCriteria$ec2InstanceImageId' => '<p>Details of the Amazon EC2 instance image IDs used to filter findings.</p>', 'FilterCriteria$ec2InstanceSubnetId' => '<p>Details of the Amazon EC2 instance subnet IDs used to filter findings.</p>', 'FilterCriteria$ec2InstanceVpcId' => '<p>Details of the Amazon EC2 instance VPC IDs used to filter findings.</p>', 'FilterCriteria$ecrImageArchitecture' => '<p>Details of the Amazon ECR image architecture types used to filter findings.</p>', 'FilterCriteria$ecrImageHash' => '<p>Details of the Amazon ECR image hashes used to filter findings.</p>', 'FilterCriteria$ecrImageRegistry' => '<p>Details on the Amazon ECR registry used to filter findings.</p>', 'FilterCriteria$ecrImageRepositoryName' => '<p>Details on the name of the Amazon ECR repository used to filter findings.</p>', 'FilterCriteria$ecrImageTags' => '<p>The tags attached to the Amazon ECR container image.</p>', 'FilterCriteria$exploitAvailable' => '<p>Filters the list of Amazon Web Services Lambda findings by the availability of exploits.</p>', 'FilterCriteria$findingArn' => '<p>Details on the finding ARNs used to filter findings.</p>', 'FilterCriteria$findingStatus' => '<p>Details on the finding status types used to filter findings.</p>', 'FilterCriteria$findingType' => '<p>Details on the finding types used to filter findings.</p>', 'FilterCriteria$fixAvailable' => '<p>Details on whether a fix is available through a version update. This value can be <code>YES</code>, <code>NO</code>, or <code>PARTIAL</code>. A <code>PARTIAL</code> fix means that some, but not all, of the packages identified in the finding have fixes available through updated versions.</p>', 'FilterCriteria$lambdaFunctionExecutionRoleArn' => '<p>Filters the list of Amazon Web Services Lambda functions by execution role.</p>', 'FilterCriteria$lambdaFunctionLayers' => '<p>Filters the list of Amazon Web Services Lambda functions by the function\'s <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html"> layers</a>. A Lambda function can have up to five layers.</p>', 'FilterCriteria$lambdaFunctionName' => '<p>Filters the list of Amazon Web Services Lambda functions by the name of the function.</p>', 'FilterCriteria$lambdaFunctionRuntime' => '<p>Filters the list of Amazon Web Services Lambda functions by the runtime environment for the Lambda function.</p>', 'FilterCriteria$networkProtocol' => '<p>Details on network protocol used to filter findings.</p>', 'FilterCriteria$relatedVulnerabilities' => '<p>Details on the related vulnerabilities used to filter findings.</p>', 'FilterCriteria$resourceId' => '<p>Details on the resource IDs used to filter findings.</p>', 'FilterCriteria$resourceType' => '<p>Details on the resource types used to filter findings.</p>', 'FilterCriteria$severity' => '<p>Details on the severity used to filter findings.</p>', 'FilterCriteria$title' => '<p>Details on the finding title used to filter findings.</p>', 'FilterCriteria$vendorSeverity' => '<p>Details on the vendor severity used to filter findings.</p>', 'FilterCriteria$vulnerabilityId' => '<p>Details on the vulnerability ID used to filter findings.</p>', 'FilterCriteria$vulnerabilitySource' => '<p>Details on the vulnerability type used to filter findings.</p>', 'ImageLayerAggregation$layerHashes' => '<p>The hashes associated with the layers.</p>', 'ImageLayerAggregation$repositories' => '<p>The repository associated with the container image hosting the layers.</p>', 'ImageLayerAggregation$resourceIds' => '<p>The ID of the container image layer.</p>', 'LambdaFunctionAggregation$functionNames' => '<p>The Amazon Web Services Lambda function names to include in the aggregation results.</p>', 'LambdaFunctionAggregation$resourceIds' => '<p>The resource IDs to include in the aggregation results.</p>', 'LambdaFunctionAggregation$runtimes' => '<p>Returns findings aggregated by Amazon Web Services Lambda function runtime environments.</p>', 'LambdaLayerAggregation$functionNames' => '<p>The names of the Amazon Web Services Lambda functions associated with the layers.</p>', 'LambdaLayerAggregation$layerArns' => '<p>The Amazon Resource Name (ARN) of the Amazon Web Services Lambda function layer. </p>', 'LambdaLayerAggregation$resourceIds' => '<p>The resource IDs for the Amazon Web Services Lambda function layers.</p>', 'ListFindingAggregationsRequest$accountIds' => '<p>The Amazon Web Services account IDs to retrieve finding aggregation data for.</p>', 'PackageAggregation$packageNames' => '<p>The names of packages to aggregate findings on.</p>', 'RepositoryAggregation$repositories' => '<p>The names of repositories to aggregate findings on.</p>', 'TitleAggregation$titles' => '<p>The finding titles to aggregate on.</p>', 'TitleAggregation$vulnerabilityIds' => '<p>The vulnerability IDs of the findings.</p>', ], ], 'StringInput' => [ 'base' => NULL, 'refs' => [ 'StringFilter$value' => '<p>The value to filter on.</p>', ], ], 'StringList' => [ 'base' => NULL, 'refs' => [ 'AwsEcrContainerAggregationResponse$imageTags' => '<p>The container image stags.</p>', ], ], 'SubnetId' => [ 'base' => NULL, 'refs' => [ 'SubnetIdList$member' => NULL, ], ], 'SubnetIdList' => [ 'base' => NULL, 'refs' => [ 'LambdaVpcConfig$subnetIds' => '<p>A list of VPC subnet IDs.</p>', ], ], 'SuggestedFix' => [ 'base' => '<p>A suggested fix for a vulnerability in your Lambda function code.</p>', 'refs' => [ 'SuggestedFixes$member' => NULL, ], ], 'SuggestedFixCodeString' => [ 'base' => NULL, 'refs' => [ 'SuggestedFix$code' => '<p>The fix\'s code.</p>', ], ], 'SuggestedFixDescriptionString' => [ 'base' => NULL, 'refs' => [ 'SuggestedFix$description' => '<p>The fix\'s description.</p>', ], ], 'SuggestedFixes' => [ 'base' => NULL, 'refs' => [ 'CodeSnippetResult$suggestedFixes' => '<p>Details of a suggested code fix.</p>', ], ], 'TagComparison' => [ 'base' => NULL, 'refs' => [ 'TagFilter$comparison' => '<p>The tag filter comparison value.</p>', ], ], 'TagFilter' => [ 'base' => '<p>The tag filter.</p>', 'refs' => [ 'ResourceTagFilterList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>The tag keys to remove from the resource.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'EcrContainerImageMetadata$tags' => '<p>Tags associated with the Amazon ECR image metadata.</p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'CreateFilterRequest$tags' => '<p>A list of tags for the filter.</p>', 'Ec2InstanceAggregationResponse$instanceTags' => '<p>The tags attached to the instance.</p>', 'Ec2Metadata$tags' => '<p>The tags attached to the instance.</p>', 'Filter$tags' => '<p>The tags attached to the filter.</p>', 'LambdaFunctionAggregationResponse$lambdaTags' => '<p>The tags included in the aggregation results.</p>', 'LambdaFunctionMetadata$functionTags' => '<p>The resource tags on an Amazon Web Services Lambda function.</p>', 'ListTagsForResourceResponse$tags' => '<p>The tags associated with the resource.</p>', 'Resource$tags' => '<p>The tags attached to the resource.</p>', 'TagResourceRequest$tags' => '<p>The tags to be added to a resource.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValueList' => [ 'base' => NULL, 'refs' => [ 'TargetResourceTags$value' => NULL, ], ], 'Target' => [ 'base' => NULL, 'refs' => [ 'Targets$member' => NULL, ], ], 'TargetAccount' => [ 'base' => NULL, 'refs' => [ 'TargetAccountList$member' => NULL, ], ], 'TargetAccountList' => [ 'base' => NULL, 'refs' => [ 'CreateCisTargets$accountIds' => '<p>The CIS target account ids.</p>', 'UpdateCisTargets$accountIds' => '<p>The target account ids.</p>', ], ], 'TargetResourceTags' => [ 'base' => NULL, 'refs' => [ 'CisTargetResourceAggregation$targetResourceTags' => '<p>The tag for the target resource.</p>', 'CisTargets$targetResourceTags' => '<p>The CIS target resource tags.</p>', 'CreateCisTargets$targetResourceTags' => '<p>The CIS target resource tags.</p>', 'UpdateCisTargets$targetResourceTags' => '<p>The target resource tags.</p>', ], ], 'TargetStatusFilterList' => [ 'base' => NULL, 'refs' => [ 'CisScanResultsAggregatedByTargetResourceFilterCriteria$targetStatusFilters' => '<p>The criteria\'s target status filters.</p>', ], ], 'TargetStatusReasonFilterList' => [ 'base' => NULL, 'refs' => [ 'CisScanResultsAggregatedByTargetResourceFilterCriteria$targetStatusReasonFilters' => '<p>The criteria\'s target status reason filters.</p>', ], ], 'Targets' => [ 'base' => NULL, 'refs' => [ 'AtigData$targets' => '<p>The commercial sectors this vulnerability targets.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The limit on the number of requests per second was exceeded.</p>', 'refs' => [], ], 'Time' => [ 'base' => '<p>The time.</p>', 'refs' => [ 'DailySchedule$startTime' => '<p>The schedule start time.</p>', 'MonthlySchedule$startTime' => '<p>The monthly schedule\'s start time.</p>', 'WeeklySchedule$startTime' => '<p>The weekly schedule\'s start time.</p>', ], ], 'TimeOfDay' => [ 'base' => NULL, 'refs' => [ 'Time$timeOfDay' => '<p>The time of day in 24-hour format (00:00).</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'AwsLambdaFunctionDetails$lastModifiedAt' => '<p>The date and time that a user last updated the configuration, in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601 format</a> </p>', 'CisDateFilter$earliestScanStartTime' => '<p>The CIS date filter\'s earliest scan start time.</p>', 'CisDateFilter$latestScanStartTime' => '<p>The CIS date filter\'s latest scan start time.</p>', 'CisScan$scanDate' => '<p>The CIS scan\'s date.</p>', 'DateFilter$endInclusive' => '<p>A timestamp representing the end of the time period filtered on.</p>', 'DateFilter$startInclusive' => '<p>A timestamp representing the start of the time period filtered on.</p>', 'FreeTrialInfo$end' => '<p>The date and time that the Amazon Inspector free trail ends for a given account.</p>', 'FreeTrialInfo$start' => '<p>The date and time that the Amazon Inspector free trail started for a given account.</p>', ], ], 'Timezone' => [ 'base' => NULL, 'refs' => [ 'Time$timezone' => '<p>The timezone.</p>', ], ], 'TitleAggregation' => [ 'base' => '<p>The details that define an aggregation based on finding title.</p>', 'refs' => [ 'AggregationRequest$titleAggregation' => '<p>An object that contains details about an aggregation request based on finding title.</p>', ], ], 'TitleAggregationResponse' => [ 'base' => '<p>A response that contains details on the results of a finding aggregation by title.</p>', 'refs' => [ 'AggregationResponse$titleAggregation' => '<p>An object that contains details about an aggregation response based on finding title.</p>', ], ], 'TitleFilterList' => [ 'base' => NULL, 'refs' => [ 'CisScanResultDetailsFilterCriteria$titleFilters' => '<p>The criteria\'s title filters.</p>', 'CisScanResultsAggregatedByChecksFilterCriteria$titleFilters' => '<p>The criteria\'s title filters.</p>', ], ], 'TitleSortBy' => [ 'base' => NULL, 'refs' => [ 'TitleAggregation$sortBy' => '<p>The value to sort results by.</p>', ], ], 'Tool' => [ 'base' => NULL, 'refs' => [ 'Tools$member' => NULL, ], ], 'Tools' => [ 'base' => NULL, 'refs' => [ 'FindingDetail$tools' => '<p>The known malware tools or kits that can exploit the vulnerability.</p>', ], ], 'Ttp' => [ 'base' => NULL, 'refs' => [ 'Ttps$member' => NULL, ], ], 'Ttps' => [ 'base' => NULL, 'refs' => [ 'AtigData$ttps' => '<p>The <a href="https://attack.mitre.org/">MITRE ATT&amp;CK</a> tactics, techniques, and procedures (TTPs) associated with vulnerability.</p>', 'FindingDetail$ttps' => '<p>The MITRE adversary tactics, techniques, or procedures (TTPs) associated with the vulnerability.</p>', ], ], 'UUID' => [ 'base' => NULL, 'refs' => [ 'SendCisSessionHealthRequest$scanJobId' => '<p>A unique identifier for the scan job.</p>', 'SendCisSessionHealthRequest$sessionToken' => '<p>The unique token that identifies the CIS session.</p>', 'SendCisSessionTelemetryRequest$scanJobId' => '<p>A unique identifier for the scan job.</p>', 'SendCisSessionTelemetryRequest$sessionToken' => '<p>The unique token that identifies the CIS session.</p>', 'StartCisSessionMessage$sessionToken' => '<p>The unique token that identifies the CIS session.</p>', 'StartCisSessionRequest$scanJobId' => '<p>A unique identifier for the scan job.</p>', 'StopCisSessionRequest$scanJobId' => '<p>A unique identifier for the scan job.</p>', 'StopCisSessionRequest$sessionToken' => '<p>The unique token that identifies the CIS session.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateCisScanConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateCisScanConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateCisTargets' => [ 'base' => '<p>Updates CIS targets.</p>', 'refs' => [ 'UpdateCisScanConfigurationRequest$targets' => '<p>The targets for the CIS scan configuration.</p>', ], ], 'UpdateConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEc2DeepInspectionConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEc2DeepInspectionConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEncryptionKeyRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEncryptionKeyResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFilterRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFilterResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateOrgEc2DeepInspectionConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateOrgEc2DeepInspectionConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateOrganizationConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateOrganizationConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'Usage' => [ 'base' => '<p>Contains usage information about the cost of Amazon Inspector operation.</p>', 'refs' => [ 'UsageList$member' => NULL, ], ], 'UsageAccountId' => [ 'base' => NULL, 'refs' => [ 'UsageAccountIdList$member' => NULL, ], ], 'UsageAccountIdList' => [ 'base' => NULL, 'refs' => [ 'ListUsageTotalsRequest$accountIds' => '<p>The Amazon Web Services account IDs to retrieve usage totals for.</p>', ], ], 'UsageList' => [ 'base' => NULL, 'refs' => [ 'UsageTotal$usage' => '<p>An object representing the total usage for an account.</p>', ], ], 'UsageTotal' => [ 'base' => '<p>The total of usage for an account ID.</p>', 'refs' => [ 'UsageTotalList$member' => NULL, ], ], 'UsageTotalList' => [ 'base' => NULL, 'refs' => [ 'ListUsageTotalsResponse$totals' => '<p>An object with details on the total usage for the requested account.</p>', ], ], 'UsageType' => [ 'base' => NULL, 'refs' => [ 'Usage$type' => '<p>The type scan.</p>', ], ], 'UsageValue' => [ 'base' => NULL, 'refs' => [ 'Usage$total' => '<p>The total of usage.</p>', ], ], 'ValidationException' => [ 'base' => '<p>The request has failed validation due to missing required fields or having invalid inputs.</p>', 'refs' => [], ], 'ValidationExceptionField' => [ 'base' => '<p>An object that describes a validation exception.</p>', 'refs' => [ 'ValidationExceptionFields$member' => NULL, ], ], 'ValidationExceptionFields' => [ 'base' => NULL, 'refs' => [ 'ValidationException$fields' => '<p>The fields that failed validation.</p>', ], ], 'ValidationExceptionReason' => [ 'base' => NULL, 'refs' => [ 'ValidationException$reason' => '<p>The reason for the validation failure.</p>', ], ], 'Vendor' => [ 'base' => NULL, 'refs' => [ 'ComputePlatform$vendor' => '<p>The compute platform vendor.</p>', ], ], 'VendorCreatedAt' => [ 'base' => NULL, 'refs' => [ 'Vulnerability$vendorCreatedAt' => '<p>The date and time when the vendor created this vulnerability.</p>', ], ], 'VendorSeverity' => [ 'base' => NULL, 'refs' => [ 'Vulnerability$vendorSeverity' => '<p>The severity assigned by the vendor.</p>', ], ], 'VendorUpdatedAt' => [ 'base' => NULL, 'refs' => [ 'Vulnerability$vendorUpdatedAt' => '<p>The date and time when the vendor last updated this vulnerability.</p>', ], ], 'Version' => [ 'base' => NULL, 'refs' => [ 'AwsLambdaFunctionDetails$version' => '<p>The version of the Amazon Web Services Lambda function.</p>', ], ], 'VpcId' => [ 'base' => NULL, 'refs' => [ 'LambdaVpcConfig$vpcId' => '<p>The ID of the VPC.</p>', ], ], 'VulnId' => [ 'base' => NULL, 'refs' => [ 'VulnIdList$member' => NULL, ], ], 'VulnIdList' => [ 'base' => NULL, 'refs' => [ 'SearchVulnerabilitiesFilterCriteria$vulnerabilityIds' => '<p>The IDs for specific vulnerabilities.</p>', ], ], 'Vulnerabilities' => [ 'base' => NULL, 'refs' => [ 'SearchVulnerabilitiesResponse$vulnerabilities' => '<p>Details about the listed vulnerability.</p>', ], ], 'Vulnerability' => [ 'base' => '<p>Contains details about a specific vulnerability Amazon Inspector can detect.</p>', 'refs' => [ 'Vulnerabilities$member' => NULL, ], ], 'VulnerabilityDescription' => [ 'base' => NULL, 'refs' => [ 'Vulnerability$description' => '<p>A description of the vulnerability.</p>', ], ], 'VulnerabilityId' => [ 'base' => NULL, 'refs' => [ 'PackageVulnerabilityDetails$vulnerabilityId' => '<p>The ID given to this vulnerability.</p>', 'VulnerabilityIdList$member' => NULL, ], ], 'VulnerabilityIdList' => [ 'base' => NULL, 'refs' => [ 'PackageVulnerabilityDetails$relatedVulnerabilities' => '<p>One or more vulnerabilities related to the one identified in this finding.</p>', ], ], 'VulnerabilityReferenceUrl' => [ 'base' => NULL, 'refs' => [ 'VulnerabilityReferenceUrls$member' => NULL, ], ], 'VulnerabilityReferenceUrls' => [ 'base' => NULL, 'refs' => [ 'FindingDetail$referenceUrls' => '<p>The reference URLs for the vulnerability data.</p>', 'Vulnerability$referenceUrls' => '<p>Links to various resources with more information on this vulnerability. </p>', ], ], 'VulnerabilitySource' => [ 'base' => NULL, 'refs' => [ 'Vulnerability$source' => '<p>The source of the vulnerability information. Possible results are <code>RHEL</code>, <code>AMAZON_CVE</code>, <code>DEBIAN</code> or <code>NVD</code>.</p>', ], ], 'VulnerabilitySourceUrl' => [ 'base' => NULL, 'refs' => [ 'Vulnerability$sourceUrl' => '<p>A link to the official source material for this vulnerability.</p>', ], ], 'VulnerablePackage' => [ 'base' => '<p>Information on the vulnerable package identified by a finding.</p>', 'refs' => [ 'VulnerablePackageList$member' => NULL, ], ], 'VulnerablePackageList' => [ 'base' => NULL, 'refs' => [ 'PackageVulnerabilityDetails$vulnerablePackages' => '<p>The packages impacted by this vulnerability.</p>', ], ], 'VulnerablePackageRemediation' => [ 'base' => NULL, 'refs' => [ 'VulnerablePackage$remediation' => '<p>The code to run in your environment to update packages with a fix available.</p>', ], ], 'WeeklySchedule' => [ 'base' => '<p>A weekly schedule.</p>', 'refs' => [ 'Schedule$weekly' => '<p>The schedule\'s weekly.</p>', ], ], ],];
