<?php
// This file was auto-generated from sdk-root/src/data/iotfleetwise/2021-06-17/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Amazon Web Services IoT FleetWise is a fully managed service that you can use to collect, model, and transfer vehicle data to the Amazon Web Services cloud at scale. With Amazon Web Services IoT FleetWise, you can standardize all of your vehicle data models, independent of the in-vehicle communication architecture, and define data collection rules to transfer only high-value data to the cloud. </p> <p>For more information, see <a href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/">What is Amazon Web Services IoT FleetWise?</a> in the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.</p>', 'operations' => [ 'AssociateVehicleFleet' => '<p> Adds, or associates, a vehicle with a fleet. </p>', 'BatchCreateVehicle' => '<p> Creates a group, or batch, of vehicles. </p> <note> <p> You must specify a decoder manifest and a vehicle model (model manifest) for each vehicle. </p> </note> <p>For more information, see <a href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/create-vehicles-cli.html">Create multiple vehicles (AWS CLI)</a> in the <i>Amazon Web Services IoT FleetWise Developer Guide</i>. </p>', 'BatchUpdateVehicle' => '<p> Updates a group, or batch, of vehicles.</p> <note> <p> You must specify a decoder manifest and a vehicle model (model manifest) for each vehicle. </p> </note> <p>For more information, see <a href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/update-vehicles-cli.html">Update multiple vehicles (AWS CLI)</a> in the <i>Amazon Web Services IoT FleetWise Developer Guide</i>. </p>', 'CreateCampaign' => '<p>Creates an orchestration of data collection rules. The Amazon Web Services IoT FleetWise Edge Agent software running in vehicles uses campaigns to decide how to collect and transfer data to the cloud. You create campaigns in the cloud. After you or your team approve campaigns, Amazon Web Services IoT FleetWise automatically deploys them to vehicles. </p> <p>For more information, see <a href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/campaigns.html">Collect and transfer data with campaigns</a> in the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.</p>', 'CreateDecoderManifest' => '<p>Creates the decoder manifest associated with a model manifest. To create a decoder manifest, the following must be true:</p> <ul> <li> <p>Every signal decoder has a unique name.</p> </li> <li> <p>Each signal decoder is associated with a network interface.</p> </li> <li> <p>Each network interface has a unique ID.</p> </li> <li> <p>The signal decoders are specified in the model manifest.</p> </li> </ul>', 'CreateFleet' => '<p> Creates a fleet that represents a group of vehicles. </p> <note> <p>You must create both a signal catalog and vehicles before you can create a fleet. </p> </note> <p>For more information, see <a href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/fleets.html">Fleets</a> in the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.</p>', 'CreateModelManifest' => '<p> Creates a vehicle model (model manifest) that specifies signals (attributes, branches, sensors, and actuators). </p> <p>For more information, see <a href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/vehicle-models.html">Vehicle models</a> in the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.</p>', 'CreateSignalCatalog' => '<p> Creates a collection of standardized signals that can be reused to create vehicle models.</p>', 'CreateVehicle' => '<p> Creates a vehicle, which is an instance of a vehicle model (model manifest). Vehicles created from the same vehicle model consist of the same signals inherited from the vehicle model.</p> <note> <p> If you have an existing Amazon Web Services IoT thing, you can use Amazon Web Services IoT FleetWise to create a vehicle and collect data from your thing. </p> </note> <p>For more information, see <a href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/create-vehicle-cli.html">Create a vehicle (AWS CLI)</a> in the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.</p>', 'DeleteCampaign' => '<p> Deletes a data collection campaign. Deleting a campaign suspends all data collection and removes it from any vehicles. </p>', 'DeleteDecoderManifest' => '<p> Deletes a decoder manifest. You can\'t delete a decoder manifest if it has vehicles associated with it. </p> <note> <p>If the decoder manifest is successfully deleted, Amazon Web Services IoT FleetWise sends back an HTTP 200 response with an empty body.</p> </note>', 'DeleteFleet' => '<p> Deletes a fleet. Before you delete a fleet, all vehicles must be dissociated from the fleet. For more information, see <a href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/delete-fleet-cli.html">Delete a fleet (AWS CLI)</a> in the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.</p> <note> <p>If the fleet is successfully deleted, Amazon Web Services IoT FleetWise sends back an HTTP 200 response with an empty body.</p> </note>', 'DeleteModelManifest' => '<p> Deletes a vehicle model (model manifest).</p> <note> <p>If the vehicle model is successfully deleted, Amazon Web Services IoT FleetWise sends back an HTTP 200 response with an empty body.</p> </note>', 'DeleteSignalCatalog' => '<p> Deletes a signal catalog. </p> <note> <p>If the signal catalog is successfully deleted, Amazon Web Services IoT FleetWise sends back an HTTP 200 response with an empty body.</p> </note>', 'DeleteVehicle' => '<p> Deletes a vehicle and removes it from any campaigns.</p> <note> <p>If the vehicle is successfully deleted, Amazon Web Services IoT FleetWise sends back an HTTP 200 response with an empty body.</p> </note>', 'DisassociateVehicleFleet' => '<p>Removes, or disassociates, a vehicle from a fleet. Disassociating a vehicle from a fleet doesn\'t delete the vehicle.</p> <note> <p>If the vehicle is successfully dissociated from a fleet, Amazon Web Services IoT FleetWise sends back an HTTP 200 response with an empty body.</p> </note>', 'GetCampaign' => '<p> Retrieves information about a campaign. </p>', 'GetDecoderManifest' => '<p> Retrieves information about a created decoder manifest. </p>', 'GetEncryptionConfiguration' => '<p>Retrieves the encryption configuration for resources and data in Amazon Web Services IoT FleetWise.</p>', 'GetFleet' => '<p> Retrieves information about a fleet. </p>', 'GetLoggingOptions' => '<p>Retrieves the logging options.</p>', 'GetModelManifest' => '<p> Retrieves information about a vehicle model (model manifest). </p>', 'GetRegisterAccountStatus' => '<p> Retrieves information about the status of registering your Amazon Web Services account, IAM, and Amazon Timestream resources so that Amazon Web Services IoT FleetWise can transfer your vehicle data to the Amazon Web Services Cloud. </p> <p>For more information, including step-by-step procedures, see <a href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/setting-up.html">Setting up Amazon Web Services IoT FleetWise</a>. </p> <note> <p>This API operation doesn\'t require input parameters.</p> </note>', 'GetSignalCatalog' => '<p> Retrieves information about a signal catalog. </p>', 'GetVehicle' => '<p> Retrieves information about a vehicle. </p>', 'GetVehicleStatus' => '<p> Retrieves information about the status of a vehicle with any associated campaigns. </p>', 'ImportDecoderManifest' => '<p> Creates a decoder manifest using your existing CAN DBC file from your local device. </p>', 'ImportSignalCatalog' => '<p> Creates a signal catalog using your existing VSS formatted content from your local device. </p>', 'ListCampaigns' => '<p> Lists information about created campaigns. </p> <note> <p>This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more results.</p> </note>', 'ListDecoderManifestNetworkInterfaces' => '<p> Lists the network interfaces specified in a decoder manifest. </p> <note> <p>This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more results.</p> </note>', 'ListDecoderManifestSignals' => '<p> A list of information about signal decoders specified in a decoder manifest. </p> <note> <p>This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more results.</p> </note>', 'ListDecoderManifests' => '<p> Lists decoder manifests. </p> <note> <p>This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more results.</p> </note>', 'ListFleets' => '<p> Retrieves information for each created fleet in an Amazon Web Services account. </p> <note> <p>This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more results.</p> </note>', 'ListFleetsForVehicle' => '<p>Retrieves a list of IDs for all fleets that the vehicle is associated with.</p> <note> <p>This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more results.</p> </note>', 'ListModelManifestNodes' => '<p> Lists information about nodes specified in a vehicle model (model manifest). </p> <note> <p>This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more results.</p> </note>', 'ListModelManifests' => '<p> Retrieves a list of vehicle models (model manifests). </p> <note> <p>This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more results.</p> </note>', 'ListSignalCatalogNodes' => '<p> Lists of information about the signals (nodes) specified in a signal catalog. </p> <note> <p>This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more results.</p> </note>', 'ListSignalCatalogs' => '<p> Lists all the created signal catalogs in an Amazon Web Services account. </p> <p>You can use to list information about each signal (node) specified in a signal catalog.</p> <note> <p>This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more results.</p> </note>', 'ListTagsForResource' => '<p>Lists the tags (metadata) you have assigned to the resource.</p>', 'ListVehicles' => '<p> Retrieves a list of summaries of created vehicles. </p> <note> <p>This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more results.</p> </note>', 'ListVehiclesInFleet' => '<p> Retrieves a list of summaries of all vehicles associated with a fleet. </p> <note> <p>This API operation uses pagination. Specify the <code>nextToken</code> parameter in the request to return more results.</p> </note>', 'PutEncryptionConfiguration' => '<p>Creates or updates the encryption configuration. Amazon Web Services IoT FleetWise can encrypt your data and resources using an Amazon Web Services managed key. Or, you can use a KMS key that you own and manage. For more information, see <a href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/data-encryption.html">Data encryption</a> in the <i>Amazon Web Services IoT FleetWise Developer Guide</i>.</p>', 'PutLoggingOptions' => '<p>Creates or updates the logging option.</p>', 'RegisterAccount' => '<important> <p>This API operation contains deprecated parameters. Register your account again without the Timestream resources parameter so that Amazon Web Services IoT FleetWise can remove the Timestream metadata stored. You should then pass the data destination into the <a href="https://docs.aws.amazon.com/iot-fleetwise/latest/APIReference/API_CreateCampaign.html">CreateCampaign</a> API operation.</p> <p>You must delete any existing campaigns that include an empty data destination before you register your account again. For more information, see the <a href="https://docs.aws.amazon.com/iot-fleetwise/latest/APIReference/API_DeleteCampaign.html">DeleteCampaign</a> API operation.</p> <p>If you want to delete the Timestream inline policy from the service-linked role, such as to mitigate an overly permissive policy, you must first delete any existing campaigns. Then delete the service-linked role and register your account again to enable CloudWatch metrics. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteServiceLinkedRole.html">DeleteServiceLinkedRole</a> in the <i>Identity and Access Management API Reference</i>.</p> </important> <p>Registers your Amazon Web Services account, IAM, and Amazon Timestream resources so Amazon Web Services IoT FleetWise can transfer your vehicle data to the Amazon Web Services Cloud. For more information, including step-by-step procedures, see <a href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/setting-up.html">Setting up Amazon Web Services IoT FleetWise</a>. </p> <note> <p>An Amazon Web Services account is <b>not</b> the same thing as a "user." An <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/introduction_identity-management.html#intro-identity-users">Amazon Web Services user</a> is an identity that you create using Identity and Access Management (IAM) and takes the form of either an <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_users.html">IAM user</a> or an <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM role, both with credentials</a>. A single Amazon Web Services account can, and typically does, contain many users and roles.</p> </note>', 'TagResource' => '<p>Adds to or modifies the tags of the given resource. Tags are metadata which can be used to manage a resource.</p>', 'UntagResource' => '<p>Removes the given tags (metadata) from the resource.</p>', 'UpdateCampaign' => '<p> Updates a campaign. </p>', 'UpdateDecoderManifest' => '<p> Updates a decoder manifest.</p> <p>A decoder manifest can only be updated when the status is <code>DRAFT</code>. Only <code>ACTIVE</code> decoder manifests can be associated with vehicles.</p>', 'UpdateFleet' => '<p> Updates the description of an existing fleet. </p> <note> <p>If the fleet is successfully updated, Amazon Web Services IoT FleetWise sends back an HTTP 200 response with an empty HTTP body.</p> </note>', 'UpdateModelManifest' => '<p> Updates a vehicle model (model manifest). If created vehicles are associated with a vehicle model, it can\'t be updated.</p>', 'UpdateSignalCatalog' => '<p> Updates a signal catalog. </p>', 'UpdateVehicle' => '<p> Updates a vehicle. </p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You don\'t have sufficient permission to perform this action.</p>', 'refs' => [], ], 'Actuator' => [ 'base' => '<p>A signal that represents a vehicle device such as the engine, heater, and door locks. Data from an actuator reports the state of a certain vehicle device.</p> <note> <p> Updating actuator data can change the state of a device. For example, you can turn on or off the heater by updating its actuator data.</p> </note>', 'refs' => [ 'Node$actuator' => '<p>Information about a node specified as an actuator.</p> <note> <p>An actuator is a digital representation of a vehicle device.</p> </note>', ], ], 'AmazonResourceName' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$ResourceARN' => '<p>The ARN of the resource.</p>', 'TagResourceRequest$ResourceARN' => '<p>The ARN of the resource.</p>', 'UntagResourceRequest$ResourceARN' => '<p>The ARN of the resource.</p>', ], ], 'AssociateVehicleFleetRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateVehicleFleetResponse' => [ 'base' => NULL, 'refs' => [], ], 'Attribute' => [ 'base' => '<p>A signal that represents static information about the vehicle, such as engine type or manufacturing date.</p>', 'refs' => [ 'Node$attribute' => '<p>Information about a node specified as an attribute.</p> <note> <p>An attribute represents static information about a vehicle.</p> </note>', ], ], 'BatchCreateVehicleRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchCreateVehicleResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchUpdateVehicleRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchUpdateVehicleResponse' => [ 'base' => NULL, 'refs' => [], ], 'Branch' => [ 'base' => '<p>A group of signals that are defined in a hierarchical structure.</p>', 'refs' => [ 'Node$branch' => '<p>Information about a node specified as a branch.</p> <note> <p>A group of signals that are defined in a hierarchical structure.</p> </note>', ], ], 'CampaignStatus' => [ 'base' => NULL, 'refs' => [ 'CampaignSummary$status' => '<p>The state of a campaign. The status can be one of the following:</p> <ul> <li> <p> <code>CREATING</code> - Amazon Web Services IoT FleetWise is processing your request to create the campaign.</p> </li> <li> <p> <code>WAITING_FOR_APPROVAL</code> - After a campaign is created, it enters the <code>WAITING_FOR_APPROVAL</code> state. To allow Amazon Web Services IoT FleetWise to deploy the campaign to the target vehicle or fleet, use the API operation to approve the campaign. </p> </li> <li> <p> <code>RUNNING</code> - The campaign is active. </p> </li> <li> <p> <code>SUSPENDED</code> - The campaign is suspended. To resume the campaign, use the API operation. </p> </li> </ul>', 'GetCampaignResponse$status' => '<p>The state of the campaign. The status can be one of: <code>CREATING</code>, <code>WAITING_FOR_APPROVAL</code>, <code>RUNNING</code>, and <code>SUSPENDED</code>. </p>', 'UpdateCampaignResponse$status' => '<p>The state of a campaign. The status can be one of:</p> <ul> <li> <p> <code>CREATING</code> - Amazon Web Services IoT FleetWise is processing your request to create the campaign. </p> </li> <li> <p> <code>WAITING_FOR_APPROVAL</code> - After a campaign is created, it enters the <code>WAITING_FOR_APPROVAL</code> state. To allow Amazon Web Services IoT FleetWise to deploy the campaign to the target vehicle or fleet, use the API operation to approve the campaign. </p> </li> <li> <p> <code>RUNNING</code> - The campaign is active. </p> </li> <li> <p> <code>SUSPENDED</code> - The campaign is suspended. To resume the campaign, use the API operation. </p> </li> </ul>', ], ], 'CampaignSummary' => [ 'base' => '<p>Information about a campaign. </p> <p>You can use the API operation to return this information about multiple created campaigns.</p>', 'refs' => [ 'campaignSummaries$member' => NULL, ], ], 'CanDbcDefinition' => [ 'base' => '<p>Configurations used to create a decoder manifest.</p>', 'refs' => [ 'NetworkFileDefinition$canDbc' => '<p>Information, including CAN DBC files, about the configurations used to create a decoder manifest.</p>', ], ], 'CanInterface' => [ 'base' => '<p>A single controller area network (CAN) device interface.</p>', 'refs' => [ 'NetworkInterface$canInterface' => '<p>Information about a network interface specified by the Controller Area Network (CAN) protocol.</p>', ], ], 'CanInterfaceName' => [ 'base' => NULL, 'refs' => [ 'CanInterface$name' => '<p>The unique name of the interface.</p>', ], ], 'CanSignal' => [ 'base' => '<p>Information about a single controller area network (CAN) signal and the messages it receives and transmits.</p>', 'refs' => [ 'SignalDecoder$canSignal' => '<p>Information about signal decoder using the Controller Area Network (CAN) protocol.</p>', ], ], 'CanSignalName' => [ 'base' => NULL, 'refs' => [ 'CanSignal$name' => '<p>The name of the signal.</p>', ], ], 'CloudWatchLogDeliveryOptions' => [ 'base' => '<p>The log delivery option to send data to Amazon CloudWatch Logs.</p>', 'refs' => [ 'GetLoggingOptionsResponse$cloudWatchLogDelivery' => '<p>Returns information about log delivery to Amazon CloudWatch Logs.</p>', 'PutLoggingOptionsRequest$cloudWatchLogDelivery' => '<p>Creates or updates the log delivery option to Amazon CloudWatch Logs.</p>', ], ], 'CloudWatchLogGroupName' => [ 'base' => NULL, 'refs' => [ 'CloudWatchLogDeliveryOptions$logGroupName' => '<p>The Amazon CloudWatch Logs group the operation sends data to.</p>', ], ], 'CollectionScheme' => [ 'base' => '<p>Specifies what data to collect and how often or when to collect it.</p>', 'refs' => [ 'CreateCampaignRequest$collectionScheme' => '<p> The data collection scheme associated with the campaign. You can specify a scheme that collects data based on time or an event.</p>', 'GetCampaignResponse$collectionScheme' => '<p> Information about the data collection scheme associated with the campaign. </p>', ], ], 'Compression' => [ 'base' => NULL, 'refs' => [ 'CreateCampaignRequest$compression' => '<p> (Optional) Whether to compress signals before transmitting data to Amazon Web Services IoT FleetWise. If you don\'t want to compress the signals, use <code>OFF</code>. If it\'s not specified, <code>SNAPPY</code> is used. </p> <p>Default: <code>SNAPPY</code> </p>', 'GetCampaignResponse$compression' => '<p> Whether to compress signals before transmitting data to Amazon Web Services IoT FleetWise. If <code>OFF</code> is specified, the signals aren\'t compressed. If it\'s not specified, <code>SNAPPY</code> is used. </p>', ], ], 'ConditionBasedCollectionScheme' => [ 'base' => '<p>Information about a collection scheme that uses a simple logical expression to recognize what data to collect.</p>', 'refs' => [ 'CollectionScheme$conditionBasedCollectionScheme' => '<p>Information about a collection scheme that uses a simple logical expression to recognize what data to collect.</p>', ], ], 'ConflictException' => [ 'base' => '<p>The request has conflicting operations. This can occur if you\'re trying to perform more than one operation on the same resource at the same time.</p>', 'refs' => [], ], 'CreateCampaignRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateCampaignResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateDecoderManifestRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDecoderManifestResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateFleetRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateFleetResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateModelManifestRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateModelManifestResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateSignalCatalogRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSignalCatalogResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateVehicleError' => [ 'base' => '<p>An HTTP error resulting from creating a vehicle.</p>', 'refs' => [ 'createVehicleErrors$member' => NULL, ], ], 'CreateVehicleRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateVehicleRequestItem' => [ 'base' => '<p>Information about the vehicle to create.</p>', 'refs' => [ 'createVehicleRequestItems$member' => NULL, ], ], 'CreateVehicleResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateVehicleResponseItem' => [ 'base' => '<p>Information about a created vehicle.</p>', 'refs' => [ 'createVehicleResponses$member' => NULL, ], ], 'CustomProperty' => [ 'base' => '<p>Represents a member of the complex data structure. The data type of the property can be either primitive or another <code>struct</code>.</p>', 'refs' => [ 'Node$property' => '<p>Represents a member of the complex data structure. The <code>datatype</code> of the property can be either primitive or another <code>struct</code>.</p>', ], ], 'CustomStruct' => [ 'base' => '<p>The custom structure represents a complex or higher-order data structure.</p>', 'refs' => [ 'Node$struct' => '<p>Represents a complex or higher-order data structure.</p>', ], ], 'DataDestinationConfig' => [ 'base' => '<p>The destination where the Amazon Web Services IoT FleetWise campaign sends data. You can send data to be stored in Amazon S3 or Amazon Timestream.</p>', 'refs' => [ 'DataDestinationConfigs$member' => NULL, ], ], 'DataDestinationConfigs' => [ 'base' => NULL, 'refs' => [ 'CreateCampaignRequest$dataDestinationConfigs' => '<p>The destination where the campaign sends data. You can choose to send data to be stored in Amazon S3 or Amazon Timestream.</p> <p>Amazon S3 optimizes the cost of data storage and provides additional mechanisms to use vehicle data, such as data lakes, centralized data storage, data processing pipelines, and analytics. Amazon Web Services IoT FleetWise supports at-least-once file delivery to S3. Your vehicle data is stored on multiple Amazon Web Services IoT FleetWise servers for redundancy and high availability.</p> <p>You can use Amazon Timestream to access and analyze time series data, and Timestream to query vehicle data so that you can identify trends and patterns.</p>', 'GetCampaignResponse$dataDestinationConfigs' => '<p>The destination where the campaign sends data. You can choose to send data to be stored in Amazon S3 or Amazon Timestream.</p> <p>Amazon S3 optimizes the cost of data storage and provides additional mechanisms to use vehicle data, such as data lakes, centralized data storage, data processing pipelines, and analytics. </p> <p>You can use Amazon Timestream to access and analyze time series data, and Timestream to query vehicle data so that you can identify trends and patterns.</p>', ], ], 'DataExtraDimensionNodePathList' => [ 'base' => NULL, 'refs' => [ 'CreateCampaignRequest$dataExtraDimensions' => '<p> (Optional) A list of vehicle attributes to associate with a campaign. </p> <p>Enrich the data with specified vehicle attributes. For example, add <code>make</code> and <code>model</code> to the campaign, and Amazon Web Services IoT FleetWise will associate the data with those attributes as dimensions in Amazon Timestream. You can then query the data against <code>make</code> and <code>model</code>.</p> <p>Default: An empty array</p>', 'GetCampaignResponse$dataExtraDimensions' => '<p> A list of vehicle attributes associated with the campaign. </p>', 'UpdateCampaignRequest$dataExtraDimensions' => '<p> A list of vehicle attributes to associate with a signal. </p> <p>Default: An empty array</p>', ], ], 'DataFormat' => [ 'base' => NULL, 'refs' => [ 'S3Config$dataFormat' => '<p>Specify the format that files are saved in the Amazon S3 bucket. You can save files in an Apache Parquet or JSON format.</p> <ul> <li> <p>Parquet - Store data in a columnar storage file format. Parquet is optimal for fast data retrieval and can reduce costs. This option is selected by default.</p> </li> <li> <p>JSON - Store data in a standard text-based JSON file format.</p> </li> </ul>', ], ], 'DecoderManifestSummary' => [ 'base' => '<p>Information about a created decoder manifest. You can use the API operation to return this information about multiple decoder manifests.</p>', 'refs' => [ 'decoderManifestSummaries$member' => NULL, ], ], 'DecoderManifestValidationException' => [ 'base' => '<p>The request couldn\'t be completed because it contains signal decoders with one or more validation errors.</p>', 'refs' => [], ], 'DeleteCampaignRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteCampaignResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDecoderManifestRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDecoderManifestResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFleetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFleetResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteModelManifestRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteModelManifestResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSignalCatalogRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSignalCatalogResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVehicleRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVehicleResponse' => [ 'base' => NULL, 'refs' => [], ], 'DiagnosticsMode' => [ 'base' => NULL, 'refs' => [ 'CreateCampaignRequest$diagnosticsMode' => '<p> (Optional) Option for a vehicle to send diagnostic trouble codes to Amazon Web Services IoT FleetWise. If you want to send diagnostic trouble codes, use <code>SEND_ACTIVE_DTCS</code>. If it\'s not specified, <code>OFF</code> is used.</p> <p>Default: <code>OFF</code> </p>', 'GetCampaignResponse$diagnosticsMode' => '<p> Option for a vehicle to send diagnostic trouble codes to Amazon Web Services IoT FleetWise. </p>', ], ], 'DisassociateVehicleFleetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateVehicleFleetResponse' => [ 'base' => NULL, 'refs' => [], ], 'EncryptionStatus' => [ 'base' => NULL, 'refs' => [ 'GetEncryptionConfigurationResponse$encryptionStatus' => '<p>The encryption status.</p>', 'PutEncryptionConfigurationResponse$encryptionStatus' => '<p>The encryption status.</p>', ], ], 'EncryptionType' => [ 'base' => NULL, 'refs' => [ 'GetEncryptionConfigurationResponse$encryptionType' => '<p>The type of encryption. Set to <code>KMS_BASED_ENCRYPTION</code> to use a KMS key that you own and manage. Set to <code>FLEETWISE_DEFAULT_ENCRYPTION</code> to use an Amazon Web Services managed key that is owned by the Amazon Web Services IoT FleetWise service account.</p>', 'PutEncryptionConfigurationRequest$encryptionType' => '<p>The type of encryption. Choose <code>KMS_BASED_ENCRYPTION</code> to use a KMS key or <code>FLEETWISE_DEFAULT_ENCRYPTION</code> to use an Amazon Web Services managed key.</p>', 'PutEncryptionConfigurationResponse$encryptionType' => '<p>The type of encryption. Set to <code>KMS_BASED_ENCRYPTION</code> to use an KMS key that you own and manage. Set to <code>FLEETWISE_DEFAULT_ENCRYPTION</code> to use an Amazon Web Services managed key that is owned by the Amazon Web Services IoT FleetWise service account.</p>', ], ], 'FleetSummary' => [ 'base' => '<p>Information about a fleet.</p> <p>You can use the API operation to return this information about multiple fleets.</p>', 'refs' => [ 'fleetSummaries$member' => NULL, ], ], 'FormattedVss' => [ 'base' => '<p> <a href="https://www.w3.org/auto/wg/wiki/Vehicle_Signal_Specification_(VSS)/Vehicle_Data_Spec">Vehicle Signal Specification (VSS)</a> is a precise language used to describe and model signals in vehicle networks. The JSON file collects signal specificiations in a VSS format.</p>', 'refs' => [ 'ImportSignalCatalogRequest$vss' => '<p>The contents of the Vehicle Signal Specification (VSS) configuration. VSS is a precise language used to describe and model signals in vehicle networks.</p>', ], ], 'Fqns' => [ 'base' => NULL, 'refs' => [ 'UpdateDecoderManifestRequest$signalDecodersToRemove' => '<p> A list of signal decoders to remove from the decoder manifest. </p>', ], ], 'FullyQualifiedName' => [ 'base' => NULL, 'refs' => [ 'Fqns$member' => NULL, 'InvalidSignal$name' => '<p>The name of the signal that isn\'t valid.</p>', 'InvalidSignalDecoder$name' => '<p>The name of a signal decoder that isn\'t valid.</p>', 'SignalDecoder$fullyQualifiedName' => '<p>The fully qualified name of a signal decoder as defined in a vehicle model.</p>', ], ], 'GetCampaignRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCampaignResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetDecoderManifestRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDecoderManifestResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetEncryptionConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetEncryptionConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetFleetRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetFleetResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetLoggingOptionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetLoggingOptionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetModelManifestRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetModelManifestResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetRegisterAccountStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetRegisterAccountStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetSignalCatalogRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSignalCatalogResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetVehicleRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetVehicleResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetVehicleStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetVehicleStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'IAMRoleArn' => [ 'base' => NULL, 'refs' => [ 'IamResources$roleArn' => '<p>The Amazon Resource Name (ARN) of the IAM resource that allows Amazon Web Services IoT FleetWise to send data to Amazon Timestream. For example, <code>arn:aws:iam::123456789012:role/SERVICE-ROLE-ARN</code>. </p>', 'TimestreamConfig$executionRoleArn' => '<p>The Amazon Resource Name (ARN) of the task execution role that grants Amazon Web Services IoT FleetWise permission to deliver data to the Amazon Timestream table.</p>', ], ], 'IamRegistrationResponse' => [ 'base' => '<p>Information about registering an Identity and Access Management (IAM) resource so Amazon Web Services IoT FleetWise edge agent software can transfer your vehicle data to Amazon Timestream.</p>', 'refs' => [ 'GetRegisterAccountStatusResponse$iamRegistrationResponse' => '<p> Information about the registered IAM resources or errors, if any. </p>', ], ], 'IamResources' => [ 'base' => '<p>The IAM resource that enables Amazon Web Services IoT FleetWise edge agent software to send data to Amazon Timestream. </p> <p>For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM roles</a> in the <i>Identity and Access Management User Guide</i>.</p>', 'refs' => [ 'RegisterAccountRequest$iamResources' => '<p>The IAM resource that allows Amazon Web Services IoT FleetWise to send data to Amazon Timestream.</p>', 'RegisterAccountResponse$iamResources' => '<p> The registered IAM resource that allows Amazon Web Services IoT FleetWise to send data to Amazon Timestream. </p>', ], ], 'ImportDecoderManifestRequest' => [ 'base' => NULL, 'refs' => [], ], 'ImportDecoderManifestResponse' => [ 'base' => NULL, 'refs' => [], ], 'ImportSignalCatalogRequest' => [ 'base' => NULL, 'refs' => [], ], 'ImportSignalCatalogResponse' => [ 'base' => NULL, 'refs' => [], ], 'InterfaceId' => [ 'base' => NULL, 'refs' => [ 'CanDbcDefinition$networkInterface' => '<p>Contains information about a network interface.</p>', 'InterfaceIds$member' => NULL, 'InvalidNetworkInterface$interfaceId' => '<p>The ID of the interface that isn\'t valid.</p>', 'NetworkInterface$interfaceId' => '<p>The ID of the network interface.</p>', 'SignalDecoder$interfaceId' => '<p>The ID of a network interface that specifies what network protocol a vehicle follows.</p>', ], ], 'InterfaceIds' => [ 'base' => NULL, 'refs' => [ 'UpdateDecoderManifestRequest$networkInterfacesToRemove' => '<p> A list of network interfaces to remove from the decoder manifest.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>The request couldn\'t be completed because the server temporarily failed.</p>', 'refs' => [], ], 'InvalidNetworkInterface' => [ 'base' => '<p>A reason a vehicle network interface isn\'t valid.</p>', 'refs' => [ 'InvalidNetworkInterfaces$member' => NULL, ], ], 'InvalidNetworkInterfaces' => [ 'base' => NULL, 'refs' => [ 'DecoderManifestValidationException$invalidNetworkInterfaces' => '<p>The request couldn\'t be completed because of invalid network interfaces in the request.</p>', ], ], 'InvalidNodeException' => [ 'base' => '<p>The specified node type doesn\'t match the expected node type for a node. You can specify the node type as branch, sensor, actuator, or attribute.</p>', 'refs' => [], ], 'InvalidSignal' => [ 'base' => '<p>A reason that a signal isn\'t valid.</p>', 'refs' => [ 'InvalidSignals$member' => NULL, ], ], 'InvalidSignalDecoder' => [ 'base' => '<p>A reason that a signal decoder isn\'t valid.</p>', 'refs' => [ 'InvalidSignalDecoders$member' => NULL, ], ], 'InvalidSignalDecoders' => [ 'base' => NULL, 'refs' => [ 'DecoderManifestValidationException$invalidSignals' => '<p>The request couldn\'t be completed because of invalid signals in the request.</p>', ], ], 'InvalidSignals' => [ 'base' => NULL, 'refs' => [ 'InvalidSignalsException$invalidSignals' => '<p>The signals which caused the exception.</p>', ], ], 'InvalidSignalsException' => [ 'base' => '<p>The request couldn\'t be completed because it contains signals that aren\'t valid.</p>', 'refs' => [], ], 'LimitExceededException' => [ 'base' => '<p>A service quota was exceeded. </p>', 'refs' => [], ], 'ListCampaignsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCampaignsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDecoderManifestNetworkInterfacesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDecoderManifestNetworkInterfacesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDecoderManifestSignalsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDecoderManifestSignalsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDecoderManifestsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDecoderManifestsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFleetsForVehicleRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFleetsForVehicleResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFleetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFleetsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListModelManifestNodesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListModelManifestNodesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListModelManifestsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListModelManifestsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSignalCatalogNodesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSignalCatalogNodesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSignalCatalogsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSignalCatalogsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListVehiclesInFleetRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListVehiclesInFleetResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListVehiclesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListVehiclesResponse' => [ 'base' => NULL, 'refs' => [], ], 'LogType' => [ 'base' => NULL, 'refs' => [ 'CloudWatchLogDeliveryOptions$logType' => '<p>The type of log to send data to Amazon CloudWatch Logs.</p>', ], ], 'ManifestStatus' => [ 'base' => NULL, 'refs' => [ 'DecoderManifestSummary$status' => '<p>The state of the decoder manifest. If the status is <code>ACTIVE</code>, the decoder manifest can\'t be edited. If the status is marked <code>DRAFT</code>, you can edit the decoder manifest.</p>', 'GetDecoderManifestResponse$status' => '<p> The state of the decoder manifest. If the status is <code>ACTIVE</code>, the decoder manifest can\'t be edited. If the status is marked <code>DRAFT</code>, you can edit the decoder manifest.</p>', 'GetModelManifestResponse$status' => '<p> The state of the vehicle model. If the status is <code>ACTIVE</code>, the vehicle model can\'t be edited. You can edit the vehicle model if the status is marked <code>DRAFT</code>.</p>', 'ModelManifestSummary$status' => '<p>The state of the vehicle model. If the status is <code>ACTIVE</code>, the vehicle model can\'t be edited. If the status is <code>DRAFT</code>, you can edit the vehicle model.</p>', 'UpdateDecoderManifestRequest$status' => '<p> The state of the decoder manifest. If the status is <code>ACTIVE</code>, the decoder manifest can\'t be edited. If the status is <code>DRAFT</code>, you can edit the decoder manifest. </p>', 'UpdateModelManifestRequest$status' => '<p> The state of the vehicle model. If the status is <code>ACTIVE</code>, the vehicle model can\'t be edited. If the status is <code>DRAFT</code>, you can edit the vehicle model. </p>', ], ], 'MessageSignal' => [ 'base' => '<p>The decoding information for a specific message which support higher order data types. </p>', 'refs' => [ 'SignalDecoder$messageSignal' => '<p>The decoding information for a specific message which supports higher order data types. </p>', ], ], 'ModelManifestSummary' => [ 'base' => '<p>Information about a vehicle model (model manifest). You can use the API operation to return this information about multiple vehicle models.</p>', 'refs' => [ 'modelManifestSummaries$member' => NULL, ], ], 'ModelSignalsMap' => [ 'base' => NULL, 'refs' => [ 'CanDbcDefinition$signalsMap' => '<p>Pairs every signal specified in your vehicle model with a signal decoder.</p>', ], ], 'NetworkFileBlob' => [ 'base' => NULL, 'refs' => [ 'NetworkFilesList$member' => NULL, ], ], 'NetworkFileDefinition' => [ 'base' => '<p>Specifications for defining a vehicle network.</p>', 'refs' => [ 'NetworkFileDefinitions$member' => NULL, ], ], 'NetworkFileDefinitions' => [ 'base' => NULL, 'refs' => [ 'ImportDecoderManifestRequest$networkFileDefinitions' => '<p> The file to load into an Amazon Web Services account. </p>', ], ], 'NetworkFilesList' => [ 'base' => NULL, 'refs' => [ 'CanDbcDefinition$canDbcFiles' => '<p>A list of DBC files. You can upload only one DBC file for each network interface and specify up to five (inclusive) files in the list. The DBC file can be a maximum size of 200 MB.</p>', ], ], 'NetworkInterface' => [ 'base' => '<p>Represents a node and its specifications in an in-vehicle communication network. All signal decoders must be associated with a network node. </p> <p> To return this information about all the network interfaces specified in a decoder manifest, use the API operation.</p>', 'refs' => [ 'NetworkInterfaces$member' => NULL, ], ], 'NetworkInterfaceFailureReason' => [ 'base' => NULL, 'refs' => [ 'InvalidNetworkInterface$reason' => '<p>A message about why the interface isn\'t valid. </p>', ], ], 'NetworkInterfaceType' => [ 'base' => NULL, 'refs' => [ 'NetworkInterface$type' => '<p>The network protocol for the vehicle. For example, <code>CAN_SIGNAL</code> specifies a protocol that defines how data is communicated between electronic control units (ECUs). <code>OBD_SIGNAL</code> specifies a protocol that defines how self-diagnostic data is communicated between ECUs.</p>', ], ], 'NetworkInterfaces' => [ 'base' => NULL, 'refs' => [ 'CreateDecoderManifestRequest$networkInterfaces' => '<p> A list of information about available network interfaces. </p>', 'ListDecoderManifestNetworkInterfacesResponse$networkInterfaces' => '<p> A list of information about network interfaces. </p>', 'UpdateDecoderManifestRequest$networkInterfacesToAdd' => '<p> A list of information about the network interfaces to add to the decoder manifest. </p>', 'UpdateDecoderManifestRequest$networkInterfacesToUpdate' => '<p> A list of information about the network interfaces to update in the decoder manifest. </p>', ], ], 'Node' => [ 'base' => '<p>A general abstraction of a signal. A node can be specified as an actuator, attribute, branch, or sensor.</p>', 'refs' => [ 'Nodes$member' => NULL, ], ], 'NodeCounts' => [ 'base' => '<p>Information about the number of nodes and node types in a vehicle network.</p>', 'refs' => [ 'GetSignalCatalogResponse$nodeCounts' => '<p> The total number of network nodes specified in a signal catalog. </p>', ], ], 'NodeDataEncoding' => [ 'base' => NULL, 'refs' => [ 'CustomProperty$dataEncoding' => '<p>Indicates whether the property is binary data.</p>', ], ], 'NodeDataType' => [ 'base' => NULL, 'refs' => [ 'Actuator$dataType' => '<p>The specified data type of the actuator. </p>', 'Attribute$dataType' => '<p>The specified data type of the attribute. </p>', 'CustomProperty$dataType' => '<p>The data type for the custom property. </p>', 'Sensor$dataType' => '<p>The specified data type of the sensor. </p>', ], ], 'NodePath' => [ 'base' => NULL, 'refs' => [ 'Actuator$structFullyQualifiedName' => '<p>The fully qualified name of the struct node for the actuator if the data type of the actuator is <code>Struct</code> or <code>StructArray</code>. For example, the struct fully qualified name of an actuator might be <code>Vehicle.Door.LockStruct</code>.</p>', 'CustomProperty$structFullyQualifiedName' => '<p>The fully qualified name of the struct node for the custom property if the data type of the custom property is <code>Struct</code> or <code>StructArray</code>. </p>', 'DataExtraDimensionNodePathList$member' => NULL, 'NodePaths$member' => NULL, 'Sensor$structFullyQualifiedName' => '<p>The fully qualified name of the struct node for a sensor if the data type of the actuator is <code>Struct</code> or <code>StructArray</code>. For example, the struct fully qualified name of a sensor might be <code>Vehicle.ADAS.CameraStruct</code>.</p>', ], ], 'NodePaths' => [ 'base' => NULL, 'refs' => [ 'UpdateModelManifestRequest$nodesToAdd' => '<p> A list of <code>fullyQualifiedName</code> of nodes, which are a general abstraction of signals, to add to the vehicle model. </p>', 'UpdateModelManifestRequest$nodesToRemove' => '<p> A list of <code>fullyQualifiedName</code> of nodes, which are a general abstraction of signals, to remove from the vehicle model. </p>', 'UpdateSignalCatalogRequest$nodesToRemove' => '<p> A list of <code>fullyQualifiedName</code> of nodes to remove from the signal catalog. </p>', ], ], 'Nodes' => [ 'base' => NULL, 'refs' => [ 'CreateSignalCatalogRequest$nodes' => '<p> A list of information about nodes, which are a general abstraction of signals. For more information, see the API data type.</p>', 'InvalidNodeException$invalidNodes' => '<p>The specified node type isn\'t valid.</p>', 'ListModelManifestNodesResponse$nodes' => '<p> A list of information about nodes. </p>', 'ListSignalCatalogNodesResponse$nodes' => '<p> A list of information about nodes. </p>', 'UpdateSignalCatalogRequest$nodesToAdd' => '<p> A list of information about nodes to add to the signal catalog. </p>', 'UpdateSignalCatalogRequest$nodesToUpdate' => '<p> A list of information about nodes to update in the signal catalog. </p>', ], ], 'ObdBitmaskLength' => [ 'base' => NULL, 'refs' => [ 'ObdSignal$bitMaskLength' => '<p>The number of bits to mask in a message.</p>', ], ], 'ObdByteLength' => [ 'base' => NULL, 'refs' => [ 'ObdSignal$byteLength' => '<p>The length of a message.</p>', ], ], 'ObdInterface' => [ 'base' => '<p>A network interface that specifies the On-board diagnostic (OBD) II network protocol.</p>', 'refs' => [ 'NetworkInterface$obdInterface' => '<p>Information about a network interface specified by the On-board diagnostic (OBD) II protocol.</p>', ], ], 'ObdInterfaceName' => [ 'base' => NULL, 'refs' => [ 'ObdInterface$name' => '<p>The name of the interface.</p>', ], ], 'ObdSignal' => [ 'base' => '<p>Information about signal messages using the on-board diagnostics (OBD) II protocol in a vehicle.</p>', 'refs' => [ 'SignalDecoder$obdSignal' => '<p>Information about signal decoder using the On-board diagnostic (OBD) II protocol.</p>', ], ], 'ObdStandard' => [ 'base' => NULL, 'refs' => [ 'ObdInterface$obdStandard' => '<p>The standard OBD II PID.</p>', ], ], 'Prefix' => [ 'base' => NULL, 'refs' => [ 'S3Config$prefix' => '<p>(Optional) Enter an S3 bucket prefix. The prefix is the string of characters after the bucket name and before the object name. You can use the prefix to organize data stored in Amazon S3 buckets. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-prefixes.html">Organizing objects using prefixes</a> in the <i>Amazon Simple Storage Service User Guide</i>.</p> <p>By default, Amazon Web Services IoT FleetWise sets the prefix <code>processed-data/year=YY/month=MM/date=DD/hour=HH/</code> (in UTC) to data it delivers to Amazon S3. You can enter a prefix to append it to this default prefix. For example, if you enter the prefix <code>vehicles</code>, the prefix will be <code>vehicles/processed-data/year=YY/month=MM/date=DD/hour=HH/</code>.</p>', ], ], 'PrimitiveBoolean' => [ 'base' => NULL, 'refs' => [ 'CanSignal$isBigEndian' => '<p>Whether the byte ordering of a CAN message is big-endian.</p>', 'CanSignal$isSigned' => '<p>Whether the message data is specified as a signed value.</p>', 'ObdInterface$useExtendedIds' => '<p>Whether to use extended IDs in the message.</p>', 'ObdInterface$hasTransmissionEcu' => '<p>Whether the vehicle has a transmission control module (TCM).</p>', ], ], 'PrimitiveMessageDefinition' => [ 'base' => '<p>Represents a primitive type node of the complex data structure.</p>', 'refs' => [ 'StructuredMessage$primitiveMessageDefinition' => '<p>Represents a primitive type node of the complex data structure.</p>', ], ], 'ProtocolName' => [ 'base' => NULL, 'refs' => [ 'CanInterface$protocolName' => '<p>The name of the communication protocol for the interface.</p>', ], ], 'ProtocolVersion' => [ 'base' => NULL, 'refs' => [ 'CanInterface$protocolVersion' => '<p>The version of the communication protocol for the interface.</p>', ], ], 'PutEncryptionConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutEncryptionConfigurationRequestKmsKeyIdString' => [ 'base' => NULL, 'refs' => [ 'PutEncryptionConfigurationRequest$kmsKeyId' => '<p>The ID of the KMS key that is used for encryption.</p>', ], ], 'PutEncryptionConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutLoggingOptionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutLoggingOptionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ROS2PrimitiveMessageDefinition' => [ 'base' => '<p>Represents a ROS 2 compliant primitive type message of the complex data structure.</p>', 'refs' => [ 'PrimitiveMessageDefinition$ros2PrimitiveMessageDefinition' => '<p>Information about a <code>PrimitiveMessage</code> using a ROS 2 compliant primitive type message of the complex data structure.</p>', ], ], 'ROS2PrimitiveMessageDefinitionUpperBoundLong' => [ 'base' => NULL, 'refs' => [ 'ROS2PrimitiveMessageDefinition$upperBound' => '<p>An optional attribute specifying the upper bound for <code>STRING</code> and <code>WSTRING</code>.</p>', ], ], 'ROS2PrimitiveType' => [ 'base' => NULL, 'refs' => [ 'ROS2PrimitiveMessageDefinition$primitiveType' => '<p>The primitive type (integer, floating point, boolean, etc.) for the ROS 2 primitive message definition.</p>', ], ], 'RegisterAccountRequest' => [ 'base' => NULL, 'refs' => [], ], 'RegisterAccountResponse' => [ 'base' => NULL, 'refs' => [], ], 'RegistrationStatus' => [ 'base' => NULL, 'refs' => [ 'GetRegisterAccountStatusResponse$accountStatus' => '<p> The status of registering your account and resources. The status can be one of:</p> <ul> <li> <p> <code>REGISTRATION_SUCCESS</code> - The Amazon Web Services resource is successfully registered.</p> </li> <li> <p> <code>REGISTRATION_PENDING</code> - Amazon Web Services IoT FleetWise is processing the registration request. This process takes approximately five minutes to complete.</p> </li> <li> <p> <code>REGISTRATION_FAILURE</code> - Amazon Web Services IoT FleetWise can\'t register the AWS resource. Try again later.</p> </li> </ul>', 'IamRegistrationResponse$registrationStatus' => '<p>The status of registering your IAM resource. The status can be one of <code>REGISTRATION_SUCCESS</code>, <code>REGISTRATION_PENDING</code>, <code>REGISTRATION_FAILURE</code>.</p>', 'RegisterAccountResponse$registerAccountStatus' => '<p> The status of registering your Amazon Web Services account, IAM role, and Timestream resources. </p>', 'TimestreamRegistrationResponse$registrationStatus' => '<p>The status of registering your Amazon Timestream resources. The status can be one of <code>REGISTRATION_SUCCESS</code>, <code>REGISTRATION_PENDING</code>, <code>REGISTRATION_FAILURE</code>.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The resource wasn\'t found.</p>', 'refs' => [], ], 'RetryAfterSeconds' => [ 'base' => NULL, 'refs' => [ 'InternalServerException$retryAfterSeconds' => '<p>The number of seconds to wait before retrying the command.</p>', 'ThrottlingException$retryAfterSeconds' => '<p>The number of seconds to wait before retrying the command.</p>', ], ], 'S3BucketArn' => [ 'base' => NULL, 'refs' => [ 'S3Config$bucketArn' => '<p>The Amazon Resource Name (ARN) of the Amazon S3 bucket.</p>', ], ], 'S3Config' => [ 'base' => '<p>The Amazon S3 bucket where the Amazon Web Services IoT FleetWise campaign sends data. Amazon S3 is an object storage service that stores data as objects within buckets. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/creating-buckets-s3.html">Creating, configuring, and working with Amazon S3 buckets</a> in the <i>Amazon Simple Storage Service User Guide</i>.</p>', 'refs' => [ 'DataDestinationConfig$s3Config' => '<p>The Amazon S3 bucket where the Amazon Web Services IoT FleetWise campaign sends data.</p>', ], ], 'Sensor' => [ 'base' => '<p>An input component that reports the environmental condition of a vehicle.</p> <note> <p>You can collect data about fluid levels, temperatures, vibrations, or battery voltage from sensors.</p> </note>', 'refs' => [ 'Node$sensor' => NULL, ], ], 'SignalCatalogSummary' => [ 'base' => '<p>Information about a collection of standardized signals, which can be attributes, branches, sensors, or actuators.</p>', 'refs' => [ 'signalCatalogSummaries$member' => NULL, ], ], 'SignalDecoder' => [ 'base' => '<p>Information about a signal decoder.</p>', 'refs' => [ 'SignalDecoders$member' => NULL, ], ], 'SignalDecoderFailureReason' => [ 'base' => NULL, 'refs' => [ 'InvalidSignalDecoder$reason' => '<p>A message about why the signal decoder isn\'t valid.</p>', ], ], 'SignalDecoderType' => [ 'base' => NULL, 'refs' => [ 'SignalDecoder$type' => '<p>The network protocol for the vehicle. For example, <code>CAN_SIGNAL</code> specifies a protocol that defines how data is communicated between electronic control units (ECUs). <code>OBD_SIGNAL</code> specifies a protocol that defines how self-diagnostic data is communicated between ECUs.</p>', ], ], 'SignalDecoders' => [ 'base' => NULL, 'refs' => [ 'CreateDecoderManifestRequest$signalDecoders' => '<p> A list of information about signal decoders. </p>', 'ListDecoderManifestSignalsResponse$signalDecoders' => '<p> Information about a list of signals to decode. </p>', 'UpdateDecoderManifestRequest$signalDecodersToAdd' => '<p> A list of information about decoding additional signals to add to the decoder manifest. </p>', 'UpdateDecoderManifestRequest$signalDecodersToUpdate' => '<p> A list of updated information about decoding signals to update in the decoder manifest. </p>', ], ], 'SignalInformation' => [ 'base' => '<p>Information about a signal.</p>', 'refs' => [ 'SignalInformationList$member' => NULL, ], ], 'SignalInformationList' => [ 'base' => NULL, 'refs' => [ 'CreateCampaignRequest$signalsToCollect' => '<p>(Optional) A list of information about signals to collect. </p>', 'GetCampaignResponse$signalsToCollect' => '<p> Information about a list of signals to collect data on. </p>', ], ], 'SignalNodeType' => [ 'base' => NULL, 'refs' => [ 'ListSignalCatalogNodesRequest$signalNodeType' => '<p>The type of node in the signal catalog.</p>', ], ], 'SpoolingMode' => [ 'base' => NULL, 'refs' => [ 'CreateCampaignRequest$spoolingMode' => '<p>(Optional) Whether to store collected data after a vehicle lost a connection with the cloud. After a connection is re-established, the data is automatically forwarded to Amazon Web Services IoT FleetWise. If you want to store collected data when a vehicle loses connection with the cloud, use <code>TO_DISK</code>. If it\'s not specified, <code>OFF</code> is used.</p> <p>Default: <code>OFF</code> </p>', 'GetCampaignResponse$spoolingMode' => '<p> Whether to store collected data after a vehicle lost a connection with the cloud. After a connection is re-established, the data is automatically forwarded to Amazon Web Services IoT FleetWise. </p>', ], ], 'StorageCompressionFormat' => [ 'base' => NULL, 'refs' => [ 'S3Config$storageCompressionFormat' => '<p>By default, stored data is compressed as a .gzip file. Compressed files have a reduced file size, which can optimize the cost of data storage.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'FormattedVss$vssJson' => '<p>Provides the VSS in JSON format.</p>', 'GetEncryptionConfigurationResponse$kmsKeyId' => '<p>The ID of the KMS key that is used for encryption.</p>', 'PutEncryptionConfigurationResponse$kmsKeyId' => '<p>The ID of the KMS key that is used for encryption.</p>', 'ValidationExceptionField$name' => '<p>The name of the parameter field with the validation error.</p>', 'ValidationExceptionField$message' => '<p>A message about the validation error.</p>', ], ], 'StructureMessageName' => [ 'base' => NULL, 'refs' => [ 'StructuredMessageFieldNameAndDataTypePair$fieldName' => '<p>The field name of the structured message. It determines how a data value is referenced in the target language. </p>', 'StructuredMessageListDefinition$name' => '<p>The name of the structured message list definition. </p>', ], ], 'StructuredMessage' => [ 'base' => '<p>The structured message for the message signal. It can be defined with either a <code>primitiveMessageDefinition</code>, <code>structuredMessageListDefinition</code>, or <code>structuredMessageDefinition</code> recursively.</p>', 'refs' => [ 'MessageSignal$structuredMessage' => '<p>The structured message for the message signal. It can be defined with either a <code>primitiveMessageDefinition</code>, <code>structuredMessageListDefinition</code>, or <code>structuredMessageDefinition</code> recursively.</p>', 'StructuredMessageFieldNameAndDataTypePair$dataType' => '<p>The data type. </p>', 'StructuredMessageListDefinition$memberType' => '<p>The member type of the structured message list definition.</p>', ], ], 'StructuredMessageDefinition' => [ 'base' => NULL, 'refs' => [ 'StructuredMessage$structuredMessageDefinition' => '<p>Represents a struct type node of the complex data structure.</p>', ], ], 'StructuredMessageFieldNameAndDataTypePair' => [ 'base' => '<p>Represents a <code>StructureMessageName</code> to <code>DataType</code> map element.</p>', 'refs' => [ 'StructuredMessageDefinition$member' => NULL, ], ], 'StructuredMessageListDefinition' => [ 'base' => '<p>Represents a list type node of the complex data structure.</p>', 'refs' => [ 'StructuredMessage$structuredMessageListDefinition' => '<p>Represents a list type node of the complex data structure.</p>', ], ], 'StructuredMessageListType' => [ 'base' => NULL, 'refs' => [ 'StructuredMessageListDefinition$listType' => '<p>The type of list of the structured message list definition.</p>', ], ], 'Tag' => [ 'base' => '<p>A set of key/value pairs that are used to manage the resource.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>The tag\'s key.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>A list of the keys of the tags to be removed from the resource.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateCampaignRequest$tags' => '<p>Metadata that can be used to manage the campaign.</p>', 'CreateDecoderManifestRequest$tags' => '<p>Metadata that can be used to manage the decoder manifest.</p>', 'CreateFleetRequest$tags' => '<p>Metadata that can be used to manage the fleet.</p>', 'CreateModelManifestRequest$tags' => '<p>Metadata that can be used to manage the vehicle model.</p>', 'CreateSignalCatalogRequest$tags' => '<p>Metadata that can be used to manage the signal catalog.</p>', 'CreateVehicleRequest$tags' => '<p>Metadata that can be used to manage the vehicle.</p>', 'CreateVehicleRequestItem$tags' => '<p>Metadata which can be used to manage the vehicle.</p>', 'ImportSignalCatalogRequest$tags' => '<p>Metadata that can be used to manage the signal catalog.</p>', 'ListTagsForResourceResponse$Tags' => '<p>The list of tags assigned to the resource.</p>', 'TagResourceRequest$Tags' => '<p>The new or modified tags for the resource.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The tag\'s value.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The request couldn\'t be completed due to throttling.</p>', 'refs' => [], ], 'TimeBasedCollectionScheme' => [ 'base' => '<p>Information about a collection scheme that uses a time period to decide how often to collect data.</p>', 'refs' => [ 'CollectionScheme$timeBasedCollectionScheme' => '<p>Information about a collection scheme that uses a time period to decide how often to collect data.</p>', ], ], 'TimestreamConfig' => [ 'base' => '<p>The Amazon Timestream table where the Amazon Web Services IoT FleetWise campaign sends data. Timestream stores and organizes data to optimize query processing time and to reduce storage costs. For more information, see <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/data-modeling.html">Data modeling</a> in the <i>Amazon Timestream Developer Guide</i>.</p>', 'refs' => [ 'DataDestinationConfig$timestreamConfig' => '<p>The Amazon Timestream table where the campaign sends data.</p>', ], ], 'TimestreamDatabaseName' => [ 'base' => NULL, 'refs' => [ 'TimestreamRegistrationResponse$timestreamDatabaseName' => '<p>The name of the Timestream database.</p>', 'TimestreamResources$timestreamDatabaseName' => '<p>The name of the registered Amazon Timestream database.</p>', ], ], 'TimestreamRegistrationResponse' => [ 'base' => '<p>Information about the registered Amazon Timestream resources or errors, if any.</p>', 'refs' => [ 'GetRegisterAccountStatusResponse$timestreamRegistrationResponse' => '<p> Information about the registered Amazon Timestream resources or errors, if any.</p>', ], ], 'TimestreamResources' => [ 'base' => '<p>The registered Amazon Timestream resources that Amazon Web Services IoT FleetWise edge agent software can transfer your vehicle data to.</p>', 'refs' => [ 'RegisterAccountRequest$timestreamResources' => NULL, 'RegisterAccountResponse$timestreamResources' => NULL, ], ], 'TimestreamTableArn' => [ 'base' => NULL, 'refs' => [ 'TimestreamConfig$timestreamTableArn' => '<p>The Amazon Resource Name (ARN) of the Amazon Timestream table.</p>', ], ], 'TimestreamTableName' => [ 'base' => NULL, 'refs' => [ 'TimestreamRegistrationResponse$timestreamTableName' => '<p>The name of the Timestream database table.</p>', 'TimestreamResources$timestreamTableName' => '<p>The name of the registered Amazon Timestream database table.</p>', ], ], 'TopicName' => [ 'base' => NULL, 'refs' => [ 'MessageSignal$topicName' => '<p>The topic name for the message signal. It corresponds to topics in ROS 2. </p>', ], ], 'TriggerMode' => [ 'base' => NULL, 'refs' => [ 'ConditionBasedCollectionScheme$triggerMode' => '<p>Whether to collect data for all triggering events (<code>ALWAYS</code>). Specify (<code>RISING_EDGE</code>), or specify only when the condition first evaluates to false. For example, triggering on "AirbagDeployed"; Users aren\'t interested on triggering when the airbag is already exploded; they only care about the change from not deployed =&gt; deployed.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateCampaignAction' => [ 'base' => NULL, 'refs' => [ 'UpdateCampaignRequest$action' => '<p> Specifies how to update a campaign. The action can be one of the following:</p> <ul> <li> <p> <code>APPROVE</code> - To approve delivering a data collection scheme to vehicles. </p> </li> <li> <p> <code>SUSPEND</code> - To suspend collecting signal data. The campaign is deleted from vehicles and all vehicles in the suspended campaign will stop sending data.</p> </li> <li> <p> <code>RESUME</code> - To reactivate the <code>SUSPEND</code> campaign. The campaign is redeployed to all vehicles and the vehicles will resume sending data.</p> </li> <li> <p> <code>UPDATE</code> - To update a campaign. </p> </li> </ul>', ], ], 'UpdateCampaignRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateCampaignResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDecoderManifestRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDecoderManifestResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFleetRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFleetResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMode' => [ 'base' => NULL, 'refs' => [ 'UpdateVehicleRequest$attributeUpdateMode' => '<p>The method the specified attributes will update the existing attributes on the vehicle. Use<code>Overwite</code> to replace the vehicle attributes with the specified attributes. Or use <code>Merge</code> to combine all attributes.</p> <p>This is required if attributes are present in the input.</p>', 'UpdateVehicleRequestItem$attributeUpdateMode' => '<p>The method the specified attributes will update the existing attributes on the vehicle. Use<code>Overwite</code> to replace the vehicle attributes with the specified attributes. Or use <code>Merge</code> to combine all attributes.</p> <p>This is required if attributes are present in the input.</p>', ], ], 'UpdateModelManifestRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateModelManifestResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSignalCatalogRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSignalCatalogResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateVehicleError' => [ 'base' => '<p>An HTTP error resulting from updating the description for a vehicle.</p>', 'refs' => [ 'updateVehicleErrors$member' => NULL, ], ], 'UpdateVehicleRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateVehicleRequestItem' => [ 'base' => '<p>Information about the vehicle to update.</p>', 'refs' => [ 'updateVehicleRequestItems$member' => NULL, ], ], 'UpdateVehicleResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateVehicleResponseItem' => [ 'base' => '<p>Information about the updated vehicle.</p>', 'refs' => [ 'updateVehicleResponseItems$member' => NULL, ], ], 'ValidationException' => [ 'base' => '<p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>', 'refs' => [], ], 'ValidationExceptionField' => [ 'base' => '<p>A validation error due to mismatch between the expected data type, length, or pattern of the parameter and the input.</p>', 'refs' => [ 'ValidationExceptionFieldList$member' => NULL, ], ], 'ValidationExceptionFieldList' => [ 'base' => NULL, 'refs' => [ 'ValidationException$fieldList' => '<p>The list of fields that fail to satisfy the constraints specified by an Amazon Web Services service.</p>', ], ], 'ValidationExceptionReason' => [ 'base' => NULL, 'refs' => [ 'ValidationException$reason' => '<p>The reason the input failed to satisfy the constraints specified by an Amazon Web Services service.</p>', ], ], 'VehicleAssociationBehavior' => [ 'base' => NULL, 'refs' => [ 'CreateVehicleRequest$associationBehavior' => '<p> An option to create a new Amazon Web Services IoT thing when creating a vehicle, or to validate an existing Amazon Web Services IoT thing as a vehicle. </p> <p>Default: <code/> </p>', 'CreateVehicleRequestItem$associationBehavior' => '<p>An option to create a new Amazon Web Services IoT thing when creating a vehicle, or to validate an existing thing as a vehicle.</p>', ], ], 'VehicleMiddleware' => [ 'base' => '<p>The vehicle middleware defined as a type of network interface. Examples of vehicle middleware include <code>ROS2</code> and <code>SOME/IP</code>.</p>', 'refs' => [ 'NetworkInterface$vehicleMiddleware' => '<p>The vehicle middleware defined as a type of network interface. Examples of vehicle middleware include <code>ROS2</code> and <code>SOME/IP</code>.</p>', ], ], 'VehicleMiddlewareName' => [ 'base' => NULL, 'refs' => [ 'VehicleMiddleware$name' => '<p>The name of the vehicle middleware. </p>', ], ], 'VehicleMiddlewareProtocol' => [ 'base' => NULL, 'refs' => [ 'VehicleMiddleware$protocolName' => '<p>The protocol name of the vehicle middleware. </p>', ], ], 'VehicleState' => [ 'base' => NULL, 'refs' => [ 'VehicleStatus$status' => '<p>The state of a vehicle, which can be one of the following:</p> <ul> <li> <p> <code>CREATED</code> - Amazon Web Services IoT FleetWise sucessfully created the vehicle. </p> </li> <li> <p> <code>READY</code> - The vehicle is ready to receive a campaign deployment. </p> </li> <li> <p> <code>HEALTHY</code> - A campaign deployment was delivered to the vehicle. </p> </li> <li> <p> <code>SUSPENDED</code> - A campaign associated with the vehicle was suspended and data collection was paused. </p> </li> <li> <p> <code>DELETING</code> - Amazon Web Services IoT FleetWise is removing a campaign from the vehicle. </p> </li> </ul>', ], ], 'VehicleStatus' => [ 'base' => '<p>Information about the state of a vehicle and how it relates to the status of a campaign.</p>', 'refs' => [ 'VehicleStatusList$member' => NULL, ], ], 'VehicleStatusList' => [ 'base' => NULL, 'refs' => [ 'GetVehicleStatusResponse$campaigns' => '<p> Lists information about the state of the vehicle with deployed campaigns. </p>', ], ], 'VehicleSummary' => [ 'base' => '<p>Information about a vehicle.</p> <p>To return this information about vehicles in your account, you can use the API operation.</p>', 'refs' => [ 'vehicleSummaries$member' => NULL, ], ], 'arn' => [ 'base' => NULL, 'refs' => [ 'CampaignSummary$arn' => '<p>The Amazon Resource Name (ARN) of a campaign.</p>', 'CampaignSummary$signalCatalogArn' => '<p>The ARN of the signal catalog associated with the campaign.</p>', 'CampaignSummary$targetArn' => '<p>The ARN of a vehicle or fleet to which the campaign is deployed.</p>', 'CreateCampaignRequest$signalCatalogArn' => '<p>The Amazon Resource Name (ARN) of the signal catalog to associate with the campaign. </p>', 'CreateCampaignRequest$targetArn' => '<p> The ARN of the vehicle or fleet to deploy a campaign to. </p>', 'CreateCampaignResponse$arn' => '<p> The ARN of the created campaign. </p>', 'CreateDecoderManifestRequest$modelManifestArn' => '<p> The Amazon Resource Name (ARN) of the vehicle model (model manifest). </p>', 'CreateDecoderManifestResponse$arn' => '<p> The ARN of the created decoder manifest. </p>', 'CreateFleetRequest$signalCatalogArn' => '<p> The Amazon Resource Name (ARN) of a signal catalog. </p>', 'CreateFleetResponse$arn' => '<p> The ARN of the created fleet. </p>', 'CreateModelManifestRequest$signalCatalogArn' => '<p> The Amazon Resource Name (ARN) of a signal catalog. </p>', 'CreateModelManifestResponse$arn' => '<p> The ARN of the created vehicle model.</p>', 'CreateSignalCatalogResponse$arn' => '<p> The ARN of the created signal catalog. </p>', 'CreateVehicleRequest$modelManifestArn' => '<p> The Amazon Resource Name ARN of a vehicle model. </p>', 'CreateVehicleRequest$decoderManifestArn' => '<p> The ARN of a decoder manifest. </p>', 'CreateVehicleRequestItem$modelManifestArn' => '<p>The ARN of the vehicle model (model manifest) to create the vehicle from.</p>', 'CreateVehicleRequestItem$decoderManifestArn' => '<p>The Amazon Resource Name (ARN) of a decoder manifest associated with the vehicle to create. </p>', 'CreateVehicleResponse$arn' => '<p> The ARN of the created vehicle. </p>', 'CreateVehicleResponse$thingArn' => '<p> The ARN of a created or validated Amazon Web Services IoT thing. </p>', 'CreateVehicleResponseItem$arn' => '<p>The ARN of the created vehicle.</p>', 'CreateVehicleResponseItem$thingArn' => '<p>The ARN of a created or validated Amazon Web Services IoT thing.</p>', 'DecoderManifestSummary$arn' => '<p>The ARN of a vehicle model (model manifest) associated with the decoder manifest. </p>', 'DecoderManifestSummary$modelManifestArn' => '<p>The ARN of a vehicle model (model manifest) associated with the decoder manifest.</p>', 'DeleteCampaignResponse$arn' => '<p> The Amazon Resource Name (ARN) of the deleted campaign.</p> <note> <p>The ARN isn’t returned if a campaign doesn’t exist.</p> </note>', 'DeleteDecoderManifestResponse$arn' => '<p>The Amazon Resource Name (ARN) of the deleted decoder manifest.</p>', 'DeleteFleetResponse$arn' => '<p>The Amazon Resource Name (ARN) of the deleted fleet.</p>', 'DeleteModelManifestResponse$arn' => '<p>The Amazon Resource Name (ARN) of the deleted model manifest.</p>', 'DeleteSignalCatalogResponse$arn' => '<p>The Amazon Resource Name (ARN) of the deleted signal catalog.</p>', 'DeleteVehicleResponse$arn' => '<p>The Amazon Resource Name (ARN) of the deleted vehicle.</p>', 'FleetSummary$arn' => '<p>The Amazon Resource Name (ARN) of the fleet.</p>', 'FleetSummary$signalCatalogArn' => '<p>The ARN of the signal catalog associated with the fleet.</p>', 'GetCampaignResponse$arn' => '<p> The Amazon Resource Name (ARN) of the campaign. </p>', 'GetCampaignResponse$signalCatalogArn' => '<p> The ARN of a signal catalog. </p>', 'GetCampaignResponse$targetArn' => '<p> The ARN of the vehicle or the fleet targeted by the campaign. </p>', 'GetDecoderManifestResponse$arn' => '<p> The Amazon Resource Name (ARN) of the decoder manifest. </p>', 'GetDecoderManifestResponse$modelManifestArn' => '<p> The ARN of a vehicle model (model manifest) associated with the decoder manifest.</p>', 'GetFleetResponse$arn' => '<p> The Amazon Resource Name (ARN) of the fleet. </p>', 'GetFleetResponse$signalCatalogArn' => '<p> The ARN of a signal catalog associated with the fleet. </p>', 'GetModelManifestResponse$arn' => '<p> The Amazon Resource Name (ARN) of the vehicle model. </p>', 'GetModelManifestResponse$signalCatalogArn' => '<p> The ARN of the signal catalog associated with the vehicle model. </p>', 'GetSignalCatalogResponse$arn' => '<p> The Amazon Resource Name (ARN) of the signal catalog. </p>', 'GetVehicleResponse$arn' => '<p> The Amazon Resource Name (ARN) of the vehicle to retrieve information about. </p>', 'GetVehicleResponse$modelManifestArn' => '<p> The ARN of a vehicle model (model manifest) associated with the vehicle. </p>', 'GetVehicleResponse$decoderManifestArn' => '<p> The ARN of a decoder manifest associated with the vehicle. </p>', 'IamRegistrationResponse$roleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role to register.</p>', 'ImportDecoderManifestResponse$arn' => '<p> The Amazon Resource Name (ARN) of the decoder manifest that was imported. </p>', 'ImportSignalCatalogResponse$arn' => '<p> The Amazon Resource Name (ARN) of the imported signal catalog.</p>', 'ListDecoderManifestsRequest$modelManifestArn' => '<p> The Amazon Resource Name (ARN) of a vehicle model (model manifest) associated with the decoder manifest. </p>', 'ListModelManifestsRequest$signalCatalogArn' => '<p> The ARN of a signal catalog. If you specify a signal catalog, only the vehicle models associated with it are returned.</p>', 'ListVehiclesRequest$modelManifestArn' => '<p> The Amazon Resource Name (ARN) of a vehicle model (model manifest). You can use this optional parameter to list only the vehicles created from a certain vehicle model. </p>', 'ModelManifestSummary$arn' => '<p>The Amazon Resource Name (ARN) of the vehicle model.</p>', 'ModelManifestSummary$signalCatalogArn' => '<p>The ARN of the signal catalog associated with the vehicle model.</p>', 'SignalCatalogSummary$arn' => '<p>The Amazon Resource Name (ARN) of the signal catalog.</p>', 'TimestreamRegistrationResponse$timestreamDatabaseArn' => '<p>The Amazon Resource Name (ARN) of the Timestream database.</p>', 'TimestreamRegistrationResponse$timestreamTableArn' => '<p>The ARN of the Timestream database table.</p>', 'UpdateCampaignResponse$arn' => '<p> The Amazon Resource Name (ARN) of the campaign. </p>', 'UpdateDecoderManifestResponse$arn' => '<p> The Amazon Resource Name (ARN) of the updated decoder manifest. </p>', 'UpdateFleetResponse$arn' => '<p>The Amazon Resource Name (ARN) of the updated fleet.</p>', 'UpdateModelManifestResponse$arn' => '<p> The Amazon Resource Name (ARN) of the updated vehicle model. </p>', 'UpdateSignalCatalogResponse$arn' => '<p> The ARN of the updated signal catalog. </p>', 'UpdateVehicleRequest$modelManifestArn' => '<p>The ARN of a vehicle model (model manifest) associated with the vehicle.</p>', 'UpdateVehicleRequest$decoderManifestArn' => '<p>The ARN of the decoder manifest associated with this vehicle.</p>', 'UpdateVehicleRequestItem$modelManifestArn' => '<p>The ARN of the vehicle model (model manifest) associated with the vehicle to update.</p>', 'UpdateVehicleRequestItem$decoderManifestArn' => '<p>The ARN of the signal decoder manifest associated with the vehicle to update.</p>', 'UpdateVehicleResponse$arn' => '<p>The ARN of the updated vehicle.</p>', 'UpdateVehicleResponseItem$arn' => '<p>The Amazon Resource Name (ARN) of the updated vehicle.</p>', 'VehicleSummary$arn' => '<p>The Amazon Resource Name (ARN) of the vehicle.</p>', 'VehicleSummary$modelManifestArn' => '<p>The ARN of a vehicle model (model manifest) associated with the vehicle.</p>', 'VehicleSummary$decoderManifestArn' => '<p>The ARN of a decoder manifest associated with the vehicle.</p>', ], ], 'attributeName' => [ 'base' => NULL, 'refs' => [ 'attributeNamesList$member' => NULL, 'attributesMap$key' => NULL, ], ], 'attributeNamesList' => [ 'base' => NULL, 'refs' => [ 'ListVehiclesRequest$attributeNames' => '<p>The fully qualified names of the attributes. For example, the fully qualified name of an attribute might be <code>Vehicle.Body.Engine.Type</code>.</p>', ], ], 'attributeValue' => [ 'base' => NULL, 'refs' => [ 'attributeValuesList$member' => NULL, 'attributesMap$value' => NULL, ], ], 'attributeValuesList' => [ 'base' => NULL, 'refs' => [ 'ListVehiclesRequest$attributeValues' => '<p>Static information about a vehicle attribute value in string format. For example:</p> <p> <code>"1.3 L R2"</code> </p>', ], ], 'attributesMap' => [ 'base' => NULL, 'refs' => [ 'CreateVehicleRequest$attributes' => '<p>Static information about a vehicle in a key-value pair. For example: <code>"engineType"</code> : <code>"1.3 L R2"</code> </p> <p>A campaign must include the keys (attribute names) in <code>dataExtraDimensions</code> for them to display in Amazon Timestream.</p>', 'CreateVehicleRequestItem$attributes' => '<p>Static information about a vehicle in a key-value pair. For example: <code>"engine Type"</code> : <code>"v6"</code> </p>', 'GetVehicleResponse$attributes' => '<p>Static information about a vehicle in a key-value pair. For example:</p> <p> <code>"engineType"</code> : <code>"1.3 L R2"</code> </p>', 'UpdateVehicleRequest$attributes' => '<p>Static information about a vehicle in a key-value pair. For example:</p> <p> <code>"engineType"</code> : <code>"1.3 L R2"</code> </p>', 'UpdateVehicleRequestItem$attributes' => '<p>Static information about a vehicle in a key-value pair. For example:</p> <p> <code>"engineType"</code> : <code>"1.3 L R2"</code> </p>', 'VehicleSummary$attributes' => '<p>Static information about a vehicle in a key-value pair. For example:</p> <p> <code>"engineType"</code> : <code>"1.3 L R2"</code> </p>', ], ], 'campaignName' => [ 'base' => NULL, 'refs' => [ 'CampaignSummary$name' => '<p>The name of a campaign.</p>', 'CreateCampaignRequest$name' => '<p> The name of the campaign to create. </p>', 'CreateCampaignResponse$name' => '<p>The name of the created campaign.</p>', 'DeleteCampaignRequest$name' => '<p> The name of the campaign to delete. </p>', 'DeleteCampaignResponse$name' => '<p>The name of the deleted campaign.</p>', 'GetCampaignRequest$name' => '<p> The name of the campaign to retrieve information about. </p>', 'GetCampaignResponse$name' => '<p>The name of the campaign.</p>', 'UpdateCampaignRequest$name' => '<p> The name of the campaign to update. </p>', 'UpdateCampaignResponse$name' => '<p>The name of the updated campaign.</p>', ], ], 'campaignSummaries' => [ 'base' => NULL, 'refs' => [ 'ListCampaignsResponse$campaignSummaries' => '<p> A summary of information about each campaign. </p>', ], ], 'collectionPeriodMs' => [ 'base' => NULL, 'refs' => [ 'TimeBasedCollectionScheme$periodMs' => '<p>The time period (in milliseconds) to decide how often to collect data. For example, if the time period is <code>60000</code>, the Edge Agent software collects data once every minute.</p>', ], ], 'createVehicleErrors' => [ 'base' => NULL, 'refs' => [ 'BatchCreateVehicleResponse$errors' => '<p>A list of information about creation errors, or an empty list if there aren\'t any errors. </p>', ], ], 'createVehicleRequestItems' => [ 'base' => NULL, 'refs' => [ 'BatchCreateVehicleRequest$vehicles' => '<p> A list of information about each vehicle to create. For more information, see the API data type.</p>', ], ], 'createVehicleResponses' => [ 'base' => NULL, 'refs' => [ 'BatchCreateVehicleResponse$vehicles' => '<p> A list of information about a batch of created vehicles. For more information, see the API data type.</p>', ], ], 'customerAccountId' => [ 'base' => NULL, 'refs' => [ 'GetRegisterAccountStatusResponse$customerAccountId' => '<p> The unique ID of the Amazon Web Services account, provided at account creation. </p>', ], ], 'decoderManifestSummaries' => [ 'base' => NULL, 'refs' => [ 'ListDecoderManifestsResponse$summaries' => '<p> A list of information about each decoder manifest. </p>', ], ], 'description' => [ 'base' => NULL, 'refs' => [ 'Actuator$description' => '<p>A brief description of the actuator.</p>', 'Attribute$description' => '<p>A brief description of the attribute.</p>', 'Branch$description' => '<p>A brief description of the branch.</p>', 'CampaignSummary$description' => '<p>The description of the campaign.</p>', 'CreateCampaignRequest$description' => '<p>An optional description of the campaign to help identify its purpose.</p>', 'CreateDecoderManifestRequest$description' => '<p> A brief description of the decoder manifest. </p>', 'CreateFleetRequest$description' => '<p> A brief description of the fleet to create. </p>', 'CreateModelManifestRequest$description' => '<p> A brief description of the vehicle model. </p>', 'CreateSignalCatalogRequest$description' => '<p>A brief description of the signal catalog.</p>', 'CustomProperty$description' => '<p>A brief description of the custom property.</p>', 'CustomStruct$description' => '<p>A brief description of the custom structure.</p>', 'DecoderManifestSummary$description' => '<p>A brief description of the decoder manifest.</p>', 'FleetSummary$description' => '<p>A brief description of the fleet.</p>', 'GetCampaignResponse$description' => '<p>The description of the campaign.</p>', 'GetDecoderManifestResponse$description' => '<p> A brief description of the decoder manifest.</p>', 'GetFleetResponse$description' => '<p> A brief description of the fleet. </p>', 'GetModelManifestResponse$description' => '<p> A brief description of the vehicle model. </p>', 'GetSignalCatalogResponse$description' => '<p> A brief description of the signal catalog. </p>', 'ImportSignalCatalogRequest$description' => '<p> A brief description of the signal catalog. </p>', 'ModelManifestSummary$description' => '<p>A brief description of the vehicle model.</p>', 'Sensor$description' => '<p>A brief description of a sensor.</p>', 'UpdateCampaignRequest$description' => '<p>The description of the campaign.</p>', 'UpdateDecoderManifestRequest$description' => '<p> A brief description of the decoder manifest to update. </p>', 'UpdateFleetRequest$description' => '<p> An updated description of the fleet. </p>', 'UpdateModelManifestRequest$description' => '<p> A brief description of the vehicle model. </p>', 'UpdateSignalCatalogRequest$description' => '<p> A brief description of the signal catalog to update.</p>', ], ], 'double' => [ 'base' => NULL, 'refs' => [ 'Actuator$min' => '<p>The specified possible minimum value of an actuator.</p>', 'Actuator$max' => '<p>The specified possible maximum value of an actuator.</p>', 'Attribute$min' => '<p>The specified possible minimum value of the attribute.</p>', 'Attribute$max' => '<p>The specified possible maximum value of the attribute.</p>', 'CanSignal$offset' => '<p>The offset used to calculate the signal value. Combined with factor, the calculation is <code>value = raw_value * factor + offset</code>.</p>', 'CanSignal$factor' => '<p>A multiplier used to decode the CAN message.</p>', 'ObdSignal$scaling' => '<p>A multiplier used to decode the message.</p>', 'ObdSignal$offset' => '<p>The offset used to calculate the signal value. Combined with scaling, the calculation is <code>value = raw_value * scaling + offset</code>.</p>', 'ROS2PrimitiveMessageDefinition$offset' => '<p>The offset used to calculate the signal value. Combined with scaling, the calculation is <code>value = raw_value * scaling + offset</code>.</p>', 'ROS2PrimitiveMessageDefinition$scaling' => '<p>A multiplier used to decode the message.</p>', 'Sensor$min' => '<p>The specified possible minimum value of the sensor.</p>', 'Sensor$max' => '<p>The specified possible maximum value of the sensor.</p>', ], ], 'errorMessage' => [ 'base' => NULL, 'refs' => [ 'GetEncryptionConfigurationResponse$errorMessage' => '<p>The error message that describes why encryption settings couldn\'t be configured, if applicable.</p>', 'IamRegistrationResponse$errorMessage' => '<p>A message associated with a registration error.</p>', 'TimestreamRegistrationResponse$errorMessage' => '<p>A message associated with a registration error.</p>', ], ], 'eventExpression' => [ 'base' => NULL, 'refs' => [ 'ConditionBasedCollectionScheme$expression' => '<p>The logical expression used to recognize what data to collect. For example, <code>$variable.`Vehicle.OutsideAirTemperature` &gt;= 105.0</code>.</p>', ], ], 'fleetId' => [ 'base' => NULL, 'refs' => [ 'AssociateVehicleFleetRequest$fleetId' => '<p> The ID of a fleet. </p>', 'CreateFleetRequest$fleetId' => '<p> The unique ID of the fleet to create. </p>', 'CreateFleetResponse$id' => '<p> The ID of the created fleet. </p>', 'DeleteFleetRequest$fleetId' => '<p> The ID of the fleet to delete. </p>', 'DeleteFleetResponse$id' => '<p>The ID of the deleted fleet.</p>', 'DisassociateVehicleFleetRequest$fleetId' => '<p> The unique ID of a fleet. </p>', 'FleetSummary$id' => '<p>The unique ID of the fleet.</p>', 'GetFleetRequest$fleetId' => '<p> The ID of the fleet to retrieve information about. </p>', 'GetFleetResponse$id' => '<p> The ID of the fleet.</p>', 'ListVehiclesInFleetRequest$fleetId' => '<p> The ID of a fleet. </p>', 'UpdateFleetRequest$fleetId' => '<p> The ID of the fleet to update. </p>', 'UpdateFleetResponse$id' => '<p>The ID of the updated fleet.</p>', 'fleets$member' => NULL, ], ], 'fleetSummaries' => [ 'base' => NULL, 'refs' => [ 'ListFleetsResponse$fleetSummaries' => '<p> A list of information for each fleet. </p>', ], ], 'fleets' => [ 'base' => NULL, 'refs' => [ 'ListFleetsForVehicleResponse$fleets' => '<p> A list of fleet IDs that the vehicle is associated with. </p>', ], ], 'languageVersion' => [ 'base' => NULL, 'refs' => [ 'ConditionBasedCollectionScheme$conditionLanguageVersion' => '<p>Specifies the version of the conditional expression language.</p>', ], ], 'listOfStrings' => [ 'base' => NULL, 'refs' => [ 'Actuator$allowedValues' => '<p>A list of possible values an actuator can take.</p>', 'Attribute$allowedValues' => '<p>A list of possible values an attribute can be assigned.</p>', 'CreateModelManifestRequest$nodes' => '<p> A list of nodes, which are a general abstraction of signals. </p>', 'Sensor$allowedValues' => '<p>A list of possible values a sensor can take.</p>', ], ], 'listVehiclesMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListVehiclesRequest$maxResults' => '<p> The maximum number of items to return, between 1 and 100, inclusive. </p>', ], ], 'maxResults' => [ 'base' => NULL, 'refs' => [ 'GetVehicleStatusRequest$maxResults' => '<p> The maximum number of items to return, between 1 and 100, inclusive. </p>', 'ListCampaignsRequest$maxResults' => '<p> The maximum number of items to return, between 1 and 100, inclusive. </p>', 'ListDecoderManifestNetworkInterfacesRequest$maxResults' => '<p> The maximum number of items to return, between 1 and 100, inclusive. </p>', 'ListDecoderManifestSignalsRequest$maxResults' => '<p> The maximum number of items to return, between 1 and 100, inclusive. </p>', 'ListDecoderManifestsRequest$maxResults' => '<p> The maximum number of items to return, between 1 and 100, inclusive. </p>', 'ListFleetsForVehicleRequest$maxResults' => '<p> The maximum number of items to return, between 1 and 100, inclusive. </p>', 'ListFleetsRequest$maxResults' => '<p> The maximum number of items to return, between 1 and 100, inclusive. </p>', 'ListModelManifestNodesRequest$maxResults' => '<p> The maximum number of items to return, between 1 and 100, inclusive. </p>', 'ListModelManifestsRequest$maxResults' => '<p> The maximum number of items to return, between 1 and 100, inclusive. </p>', 'ListSignalCatalogNodesRequest$maxResults' => '<p> The maximum number of items to return, between 1 and 100, inclusive. </p>', 'ListSignalCatalogsRequest$maxResults' => '<p> The maximum number of items to return, between 1 and 100, inclusive. </p>', 'ListVehiclesInFleetRequest$maxResults' => '<p> The maximum number of items to return, between 1 and 100, inclusive. </p>', ], ], 'maxSampleCount' => [ 'base' => NULL, 'refs' => [ 'SignalInformation$maxSampleCount' => '<p>The maximum number of samples to collect.</p>', ], ], 'message' => [ 'base' => NULL, 'refs' => [ 'Actuator$deprecationMessage' => '<p>The deprecation message for the node or the branch that was moved or deleted.</p>', 'Actuator$comment' => '<p>A comment in addition to the description.</p>', 'Attribute$deprecationMessage' => '<p>The deprecation message for the node or the branch that was moved or deleted.</p>', 'Attribute$comment' => '<p>A comment in addition to the description.</p>', 'Branch$deprecationMessage' => '<p>The deprecation message for the node or the branch that was moved or deleted.</p>', 'Branch$comment' => '<p>A comment in addition to the description.</p>', 'CustomProperty$deprecationMessage' => '<p>The deprecation message for the node or the branch that was moved or deleted.</p>', 'CustomProperty$comment' => '<p>A comment in addition to the description.</p>', 'CustomStruct$deprecationMessage' => '<p>The deprecation message for the node or the branch that was moved or deleted.</p>', 'CustomStruct$comment' => '<p>A comment in addition to the description.</p>', 'DecoderManifestSummary$message' => '<p>The detailed message for the decoder manifest. When a decoder manifest is in an <code>INVALID</code> status, the message contains detailed reason and help information.</p>', 'GetDecoderManifestResponse$message' => '<p>The detailed message for the decoder manifest. When a decoder manifest is in an <code>INVALID</code> status, the message contains detailed reason and help information.</p>', 'InvalidSignalDecoder$hint' => '<p>The possible cause for the invalid signal decoder.</p>', 'Sensor$deprecationMessage' => '<p>The deprecation message for the node or the branch that was moved or deleted.</p>', 'Sensor$comment' => '<p>A comment in addition to the description.</p>', ], ], 'modelManifestSummaries' => [ 'base' => NULL, 'refs' => [ 'ListModelManifestsResponse$summaries' => '<p> A list of information about vehicle models.</p>', ], ], 'nextToken' => [ 'base' => NULL, 'refs' => [ 'GetVehicleStatusRequest$nextToken' => '<p>A pagination token for the next set of results.</p> <p>If the results of a search are large, only a portion of the results are returned, and a <code>nextToken</code> pagination token is returned in the response. To retrieve the next set of results, reissue the search request and include the returned token. When all results have been returned, the response does not contain a pagination token value. </p>', 'GetVehicleStatusResponse$nextToken' => '<p> The token to retrieve the next set of results, or <code>null</code> if there are no more results. </p>', 'ListCampaignsRequest$nextToken' => '<p>A pagination token for the next set of results.</p> <p>If the results of a search are large, only a portion of the results are returned, and a <code>nextToken</code> pagination token is returned in the response. To retrieve the next set of results, reissue the search request and include the returned token. When all results have been returned, the response does not contain a pagination token value. </p>', 'ListCampaignsResponse$nextToken' => '<p> The token to retrieve the next set of results, or <code>null</code> if there are no more results. </p>', 'ListDecoderManifestNetworkInterfacesRequest$nextToken' => '<p>A pagination token for the next set of results.</p> <p>If the results of a search are large, only a portion of the results are returned, and a <code>nextToken</code> pagination token is returned in the response. To retrieve the next set of results, reissue the search request and include the returned token. When all results have been returned, the response does not contain a pagination token value. </p>', 'ListDecoderManifestNetworkInterfacesResponse$nextToken' => '<p> The token to retrieve the next set of results, or <code>null</code> if there are no more results. </p>', 'ListDecoderManifestSignalsRequest$nextToken' => '<p>A pagination token for the next set of results.</p> <p>If the results of a search are large, only a portion of the results are returned, and a <code>nextToken</code> pagination token is returned in the response. To retrieve the next set of results, reissue the search request and include the returned token. When all results have been returned, the response does not contain a pagination token value. </p>', 'ListDecoderManifestSignalsResponse$nextToken' => '<p> The token to retrieve the next set of results, or <code>null</code> if there are no more results. </p>', 'ListDecoderManifestsRequest$nextToken' => '<p>A pagination token for the next set of results.</p> <p>If the results of a search are large, only a portion of the results are returned, and a <code>nextToken</code> pagination token is returned in the response. To retrieve the next set of results, reissue the search request and include the returned token. When all results have been returned, the response does not contain a pagination token value. </p>', 'ListDecoderManifestsResponse$nextToken' => '<p> The token to retrieve the next set of results, or <code>null</code> if there are no more results. </p>', 'ListFleetsForVehicleRequest$nextToken' => '<p>A pagination token for the next set of results.</p> <p>If the results of a search are large, only a portion of the results are returned, and a <code>nextToken</code> pagination token is returned in the response. To retrieve the next set of results, reissue the search request and include the returned token. When all results have been returned, the response does not contain a pagination token value. </p>', 'ListFleetsForVehicleResponse$nextToken' => '<p> The token to retrieve the next set of results, or <code>null</code> if there are no more results. </p>', 'ListFleetsRequest$nextToken' => '<p>A pagination token for the next set of results.</p> <p>If the results of a search are large, only a portion of the results are returned, and a <code>nextToken</code> pagination token is returned in the response. To retrieve the next set of results, reissue the search request and include the returned token. When all results have been returned, the response does not contain a pagination token value. </p>', 'ListFleetsResponse$nextToken' => '<p> The token to retrieve the next set of results, or <code>null</code> if there are no more results. </p>', 'ListModelManifestNodesRequest$nextToken' => '<p>A pagination token for the next set of results.</p> <p>If the results of a search are large, only a portion of the results are returned, and a <code>nextToken</code> pagination token is returned in the response. To retrieve the next set of results, reissue the search request and include the returned token. When all results have been returned, the response does not contain a pagination token value. </p>', 'ListModelManifestNodesResponse$nextToken' => '<p> The token to retrieve the next set of results, or <code>null</code> if there are no more results. </p>', 'ListModelManifestsRequest$nextToken' => '<p>A pagination token for the next set of results.</p> <p>If the results of a search are large, only a portion of the results are returned, and a <code>nextToken</code> pagination token is returned in the response. To retrieve the next set of results, reissue the search request and include the returned token. When all results have been returned, the response does not contain a pagination token value. </p>', 'ListModelManifestsResponse$nextToken' => '<p> The token to retrieve the next set of results, or <code>null</code> if there are no more results. </p>', 'ListSignalCatalogNodesRequest$nextToken' => '<p>A pagination token for the next set of results.</p> <p>If the results of a search are large, only a portion of the results are returned, and a <code>nextToken</code> pagination token is returned in the response. To retrieve the next set of results, reissue the search request and include the returned token. When all results have been returned, the response does not contain a pagination token value. </p>', 'ListSignalCatalogNodesResponse$nextToken' => '<p> The token to retrieve the next set of results, or <code>null</code> if there are no more results. </p>', 'ListSignalCatalogsRequest$nextToken' => '<p>A pagination token for the next set of results.</p> <p>If the results of a search are large, only a portion of the results are returned, and a <code>nextToken</code> pagination token is returned in the response. To retrieve the next set of results, reissue the search request and include the returned token. When all results have been returned, the response does not contain a pagination token value. </p>', 'ListSignalCatalogsResponse$nextToken' => '<p> The token to retrieve the next set of results, or <code>null</code> if there are no more results. </p>', 'ListVehiclesInFleetRequest$nextToken' => '<p>A pagination token for the next set of results.</p> <p>If the results of a search are large, only a portion of the results are returned, and a <code>nextToken</code> pagination token is returned in the response. To retrieve the next set of results, reissue the search request and include the returned token. When all results have been returned, the response does not contain a pagination token value. </p>', 'ListVehiclesInFleetResponse$nextToken' => '<p> The token to retrieve the next set of results, or <code>null</code> if there are no more results. </p>', 'ListVehiclesRequest$nextToken' => '<p>A pagination token for the next set of results.</p> <p>If the results of a search are large, only a portion of the results are returned, and a <code>nextToken</code> pagination token is returned in the response. To retrieve the next set of results, reissue the search request and include the returned token. When all results have been returned, the response does not contain a pagination token value. </p>', 'ListVehiclesResponse$nextToken' => '<p> The token to retrieve the next set of results, or <code>null</code> if there are no more results. </p>', ], ], 'nonNegativeInteger' => [ 'base' => NULL, 'refs' => [ 'CanSignal$messageId' => '<p>The ID of the message.</p>', 'CanSignal$startBit' => '<p>Indicates the beginning of the CAN signal. This should always be the least significant bit (LSB).</p> <p>This value might be different from the value in a DBC file. For little endian signals, <code>startBit</code> is the same value as in the DBC file. For big endian signals in a DBC file, the start bit is the most significant bit (MSB). You will have to calculate the LSB instead and pass it as the <code>startBit</code>.</p>', 'CanSignal$length' => '<p>How many bytes of data are in the message.</p>', 'ObdInterface$requestMessageId' => '<p>The ID of the message requesting vehicle data.</p>', 'ObdInterface$pidRequestIntervalSeconds' => '<p>The maximum number message requests per second.</p>', 'ObdInterface$dtcRequestIntervalSeconds' => '<p>The maximum number message requests per diagnostic trouble code per second.</p>', 'ObdSignal$serviceMode' => '<p>The mode of operation (diagnostic service) in a message.</p>', 'ObdSignal$pid' => '<p>The diagnostic code used to request data from a vehicle for this signal.</p>', 'ObdSignal$startByte' => '<p>Indicates the beginning of the message.</p>', 'ObdSignal$bitRightShift' => '<p>The number of positions to shift bits in the message.</p>', 'StructuredMessageListDefinition$capacity' => '<p>The capacity of the structured message list definition when the list type is <code>FIXED_CAPACITY</code> or <code>DYNAMIC_BOUNDED_CAPACITY</code>.</p>', ], ], 'number' => [ 'base' => NULL, 'refs' => [ 'NodeCounts$totalNodes' => '<p>The total number of nodes in a vehicle network.</p>', 'NodeCounts$totalBranches' => '<p>The total number of nodes in a vehicle network that represent branches.</p>', 'NodeCounts$totalSensors' => '<p>The total number of nodes in a vehicle network that represent sensors.</p>', 'NodeCounts$totalAttributes' => '<p>The total number of nodes in a vehicle network that represent attributes.</p>', 'NodeCounts$totalActuators' => '<p>The total number of nodes in a vehicle network that represent actuators.</p>', 'NodeCounts$totalStructs' => '<p>The total structure for the node.</p>', 'NodeCounts$totalProperties' => '<p>The total properties for the node.</p>', 'UpdateVehicleError$code' => '<p>The relevant HTTP error code (400+).</p>', ], ], 'positiveInteger' => [ 'base' => NULL, 'refs' => [ 'ObdSignal$pidResponseLength' => '<p>The length of the requested data.</p>', ], ], 'priority' => [ 'base' => NULL, 'refs' => [ 'CreateCampaignRequest$priority' => '<p>(Optional) A number indicating the priority of one campaign over another campaign for a certain vehicle or fleet. A campaign with the lowest value is deployed to vehicles before any other campaigns. If it\'s not specified, <code>0</code> is used. </p> <p>Default: <code>0</code> </p>', 'GetCampaignResponse$priority' => '<p> A number indicating the priority of one campaign over another campaign for a certain vehicle or fleet. A campaign with the lowest value is deployed to vehicles before any other campaigns.</p>', ], ], 'resourceName' => [ 'base' => NULL, 'refs' => [ 'CreateDecoderManifestRequest$name' => '<p> The unique name of the decoder manifest to create.</p>', 'CreateDecoderManifestResponse$name' => '<p> The name of the created decoder manifest. </p>', 'CreateModelManifestRequest$name' => '<p> The name of the vehicle model to create.</p>', 'CreateModelManifestResponse$name' => '<p> The name of the created vehicle model.</p>', 'CreateSignalCatalogRequest$name' => '<p> The name of the signal catalog to create. </p>', 'CreateSignalCatalogResponse$name' => '<p> The name of the created signal catalog. </p>', 'DeleteDecoderManifestRequest$name' => '<p> The name of the decoder manifest to delete. </p>', 'DeleteDecoderManifestResponse$name' => '<p>The name of the deleted decoder manifest.</p>', 'DeleteModelManifestRequest$name' => '<p> The name of the model manifest to delete. </p>', 'DeleteModelManifestResponse$name' => '<p>The name of the deleted model manifest.</p>', 'DeleteSignalCatalogRequest$name' => '<p> The name of the signal catalog to delete. </p>', 'DeleteSignalCatalogResponse$name' => '<p>The name of the deleted signal catalog.</p>', 'GetDecoderManifestRequest$name' => '<p> The name of the decoder manifest to retrieve information about. </p>', 'GetModelManifestRequest$name' => '<p> The name of the vehicle model to retrieve information about. </p>', 'GetModelManifestResponse$name' => '<p> The name of the vehicle model. </p>', 'GetSignalCatalogRequest$name' => '<p> The name of the signal catalog to retrieve information about. </p>', 'GetSignalCatalogResponse$name' => '<p> The name of the signal catalog. </p>', 'ImportDecoderManifestRequest$name' => '<p> The name of the decoder manifest to import. </p>', 'ImportDecoderManifestResponse$name' => '<p> The name of the imported decoder manifest. </p>', 'ImportSignalCatalogRequest$name' => '<p>The name of the signal catalog to import.</p>', 'ImportSignalCatalogResponse$name' => '<p> The name of the imported signal catalog. </p>', 'ListDecoderManifestNetworkInterfacesRequest$name' => '<p> The name of the decoder manifest to list information about. </p>', 'ListDecoderManifestSignalsRequest$name' => '<p> The name of the decoder manifest to list information about. </p>', 'ListModelManifestNodesRequest$name' => '<p> The name of the vehicle model to list information about. </p>', 'ListSignalCatalogNodesRequest$name' => '<p> The name of the signal catalog to list information about. </p>', 'UpdateDecoderManifestRequest$name' => '<p> The name of the decoder manifest to update.</p>', 'UpdateDecoderManifestResponse$name' => '<p> The name of the updated decoder manifest. </p>', 'UpdateModelManifestRequest$name' => '<p> The name of the vehicle model to update. </p>', 'UpdateModelManifestResponse$name' => '<p> The name of the updated vehicle model. </p>', 'UpdateSignalCatalogRequest$name' => '<p> The name of the signal catalog to update. </p>', 'UpdateSignalCatalogResponse$name' => '<p> The name of the updated signal catalog. </p>', ], ], 'signalCatalogSummaries' => [ 'base' => NULL, 'refs' => [ 'ListSignalCatalogsResponse$summaries' => '<p> A list of information about each signal catalog. </p>', ], ], 'status' => [ 'base' => NULL, 'refs' => [ 'ListCampaignsRequest$status' => '<p>Optional parameter to filter the results by the status of each created campaign in your account. The status can be one of: <code>CREATING</code>, <code>WAITING_FOR_APPROVAL</code>, <code>RUNNING</code>, or <code>SUSPENDED</code>.</p>', ], ], 'string' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'Actuator$fullyQualifiedName' => '<p>The fully qualified name of the actuator. For example, the fully qualified name of an actuator might be <code>Vehicle.Front.Left.Door.Lock</code>.</p>', 'Actuator$unit' => '<p>The scientific unit for the actuator.</p>', 'Actuator$assignedValue' => '<p>A specified value for the actuator.</p>', 'Attribute$fullyQualifiedName' => '<p>The fully qualified name of the attribute. For example, the fully qualified name of an attribute might be <code>Vehicle.Body.Engine.Type</code>.</p>', 'Attribute$unit' => '<p>The scientific unit for the attribute.</p>', 'Attribute$assignedValue' => '<p>A specified value for the attribute.</p>', 'Attribute$defaultValue' => '<p>The default value of the attribute.</p>', 'Branch$fullyQualifiedName' => '<p>The fully qualified name of the branch. For example, the fully qualified name of a branch might be <code>Vehicle.Body.Engine</code>.</p>', 'ConflictException$message' => NULL, 'ConflictException$resource' => '<p>The resource on which there are conflicting operations.</p>', 'ConflictException$resourceType' => '<p>The type of resource on which there are conflicting operations..</p>', 'CreateVehicleError$code' => '<p>An HTTP error code.</p>', 'CreateVehicleError$message' => '<p>A description of the HTTP error.</p>', 'CustomProperty$fullyQualifiedName' => '<p>The fully qualified name of the custom property. For example, the fully qualified name of a custom property might be <code>ComplexDataTypes.VehicleDataTypes.SVMCamera.FPS</code>.</p>', 'CustomStruct$fullyQualifiedName' => '<p>The fully qualified name of the custom structure. For example, the fully qualified name of a custom structure might be <code>ComplexDataTypes.VehicleDataTypes.SVMCamera</code>.</p>', 'DecoderManifestSummary$name' => '<p>The name of the decoder manifest.</p>', 'DecoderManifestValidationException$message' => NULL, 'GetDecoderManifestResponse$name' => '<p> The name of the decoder manifest. </p>', 'InternalServerException$message' => NULL, 'InvalidNodeException$reason' => '<p>The reason the node validation failed.</p>', 'InvalidNodeException$message' => NULL, 'InvalidSignal$reason' => '<p>A message about why the signal isn\'t valid.</p>', 'InvalidSignalsException$message' => NULL, 'LimitExceededException$message' => NULL, 'LimitExceededException$resourceId' => '<p>The identifier of the resource that was exceeded.</p>', 'LimitExceededException$resourceType' => '<p>The type of resource that was exceeded.</p>', 'ModelManifestSummary$name' => '<p>The name of the vehicle model.</p>', 'ModelSignalsMap$key' => NULL, 'ModelSignalsMap$value' => NULL, 'ResourceNotFoundException$message' => NULL, 'ResourceNotFoundException$resourceId' => '<p>The identifier of the resource that wasn\'t found.</p>', 'ResourceNotFoundException$resourceType' => '<p>The type of resource that wasn\'t found.</p>', 'Sensor$fullyQualifiedName' => '<p>The fully qualified name of the sensor. For example, the fully qualified name of a sensor might be <code>Vehicle.Body.Engine.Battery</code>.</p>', 'Sensor$unit' => '<p>The scientific unit of measurement for data collected by the sensor.</p>', 'SignalCatalogSummary$name' => '<p>The name of the signal catalog.</p>', 'ThrottlingException$message' => NULL, 'ThrottlingException$quotaCode' => '<p>The quota identifier of the applied throttling rules for this request.</p>', 'ThrottlingException$serviceCode' => '<p>The code for the service that couldn\'t be completed due to throttling.</p>', 'UpdateVehicleError$message' => '<p>A message associated with the error.</p>', 'ValidationException$message' => NULL, 'VehicleStatus$campaignName' => '<p>The name of a campaign.</p>', 'listOfStrings$member' => NULL, ], ], 'timestamp' => [ 'base' => NULL, 'refs' => [ 'CampaignSummary$creationTime' => '<p>The time the campaign was created.</p>', 'CampaignSummary$lastModificationTime' => '<p>The last time the campaign was modified.</p>', 'CreateCampaignRequest$startTime' => '<p>(Optional) The time, in milliseconds, to deliver a campaign after it was approved. If it\'s not specified, <code>0</code> is used.</p> <p>Default: <code>0</code> </p>', 'CreateCampaignRequest$expiryTime' => '<p> (Optional) The time the campaign expires, in seconds since epoch (January 1, 1970 at midnight UTC time). Vehicle data isn\'t collected after the campaign expires. </p> <p>Default: 253402214400 (December 31, 9999, 00:00:00 UTC)</p>', 'DecoderManifestSummary$creationTime' => '<p>The time the decoder manifest was created in seconds since epoch (January 1, 1970 at midnight UTC time).</p>', 'DecoderManifestSummary$lastModificationTime' => '<p>The time the decoder manifest was last updated in seconds since epoch (January 1, 1970 at midnight UTC time).</p>', 'FleetSummary$creationTime' => '<p>The time the fleet was created, in seconds since epoch (January 1, 1970 at midnight UTC time).</p>', 'FleetSummary$lastModificationTime' => '<p>The time the fleet was last updated in seconds since epoch (January 1, 1970 at midnight UTC time).</p>', 'GetCampaignResponse$startTime' => '<p> The time, in milliseconds, to deliver a campaign after it was approved.</p>', 'GetCampaignResponse$expiryTime' => '<p> The time the campaign expires, in seconds since epoch (January 1, 1970 at midnight UTC time). Vehicle data won\'t be collected after the campaign expires.</p>', 'GetCampaignResponse$creationTime' => '<p> The time the campaign was created in seconds since epoch (January 1, 1970 at midnight UTC time). </p>', 'GetCampaignResponse$lastModificationTime' => '<p>The last time the campaign was modified.</p>', 'GetDecoderManifestResponse$creationTime' => '<p> The time the decoder manifest was created in seconds since epoch (January 1, 1970 at midnight UTC time). </p>', 'GetDecoderManifestResponse$lastModificationTime' => '<p> The time the decoder manifest was last updated in seconds since epoch (January 1, 1970 at midnight UTC time). </p>', 'GetEncryptionConfigurationResponse$creationTime' => '<p>The time when encryption was configured in seconds since epoch (January 1, 1970 at midnight UTC time).</p>', 'GetEncryptionConfigurationResponse$lastModificationTime' => '<p>The time when encryption was last updated in seconds since epoch (January 1, 1970 at midnight UTC time).</p>', 'GetFleetResponse$creationTime' => '<p> The time the fleet was created in seconds since epoch (January 1, 1970 at midnight UTC time). </p>', 'GetFleetResponse$lastModificationTime' => '<p> The time the fleet was last updated, in seconds since epoch (January 1, 1970 at midnight UTC time). </p>', 'GetModelManifestResponse$creationTime' => '<p>The time the vehicle model was created, in seconds since epoch (January 1, 1970 at midnight UTC time).</p>', 'GetModelManifestResponse$lastModificationTime' => '<p>The last time the vehicle model was modified.</p>', 'GetRegisterAccountStatusResponse$creationTime' => '<p> The time the account was registered, in seconds since epoch (January 1, 1970 at midnight UTC time). </p>', 'GetRegisterAccountStatusResponse$lastModificationTime' => '<p> The time this registration was last updated, in seconds since epoch (January 1, 1970 at midnight UTC time). </p>', 'GetSignalCatalogResponse$creationTime' => '<p> The time the signal catalog was created in seconds since epoch (January 1, 1970 at midnight UTC time). </p>', 'GetSignalCatalogResponse$lastModificationTime' => '<p>The last time the signal catalog was modified.</p>', 'GetVehicleResponse$creationTime' => '<p> The time the vehicle was created in seconds since epoch (January 1, 1970 at midnight UTC time). </p>', 'GetVehicleResponse$lastModificationTime' => '<p> The time the vehicle was last updated in seconds since epoch (January 1, 1970 at midnight UTC time). </p>', 'ModelManifestSummary$creationTime' => '<p>The time the vehicle model was created, in seconds since epoch (January 1, 1970 at midnight UTC time).</p>', 'ModelManifestSummary$lastModificationTime' => '<p>The time the vehicle model was last updated, in seconds since epoch (January 1, 1970 at midnight UTC time).</p>', 'RegisterAccountResponse$creationTime' => '<p> The time the account was registered, in seconds since epoch (January 1, 1970 at midnight UTC time). </p>', 'RegisterAccountResponse$lastModificationTime' => '<p> The time this registration was last updated, in seconds since epoch (January 1, 1970 at midnight UTC time). </p>', 'SignalCatalogSummary$creationTime' => '<p>The time the signal catalog was created in seconds since epoch (January 1, 1970 at midnight UTC time). </p>', 'SignalCatalogSummary$lastModificationTime' => '<p>The time the signal catalog was last updated in seconds since epoch (January 1, 1970 at midnight UTC time). </p>', 'VehicleSummary$creationTime' => '<p>The time the vehicle was created in seconds since epoch (January 1, 1970 at midnight UTC time).</p>', 'VehicleSummary$lastModificationTime' => '<p>The time the vehicle was last updated in seconds since epoch (January 1, 1970 at midnight UTC time). </p>', ], ], 'uint32' => [ 'base' => NULL, 'refs' => [ 'ConditionBasedCollectionScheme$minimumTriggerIntervalMs' => '<p>The minimum duration of time between two triggering events to collect data, in milliseconds.</p> <note> <p>If a signal changes often, you might want to collect data at a slower rate.</p> </note>', 'CreateCampaignRequest$postTriggerCollectionDuration' => '<p> (Optional) How long (in milliseconds) to collect raw data after a triggering event initiates the collection. If it\'s not specified, <code>0</code> is used.</p> <p>Default: <code>0</code> </p>', 'GetCampaignResponse$postTriggerCollectionDuration' => '<p> How long (in seconds) to collect raw data after a triggering event initiates the collection. </p>', 'SignalInformation$minimumSamplingIntervalMs' => '<p>The minimum duration of time (in milliseconds) between two triggering events to collect data.</p> <note> <p>If a signal changes often, you might want to collect data at a slower rate.</p> </note>', ], ], 'updateVehicleErrors' => [ 'base' => NULL, 'refs' => [ 'BatchUpdateVehicleResponse$errors' => '<p>A list of information about errors returned while updating a batch of vehicles, or, if there aren\'t any errors, an empty list.</p>', ], ], 'updateVehicleRequestItems' => [ 'base' => NULL, 'refs' => [ 'BatchUpdateVehicleRequest$vehicles' => '<p> A list of information about the vehicles to update. For more information, see the API data type.</p>', ], ], 'updateVehicleResponseItems' => [ 'base' => NULL, 'refs' => [ 'BatchUpdateVehicleResponse$vehicles' => '<p> A list of information about the batch of updated vehicles. </p> <note> <p>This list contains only unique IDs for the vehicles that were updated.</p> </note>', ], ], 'vehicleName' => [ 'base' => NULL, 'refs' => [ 'AssociateVehicleFleetRequest$vehicleName' => '<p> The unique ID of the vehicle to associate with the fleet. </p>', 'CreateVehicleError$vehicleName' => '<p>The ID of the vehicle with the error.</p>', 'CreateVehicleRequest$vehicleName' => '<p> The unique ID of the vehicle to create. </p>', 'CreateVehicleRequestItem$vehicleName' => '<p>The unique ID of the vehicle to create.</p>', 'CreateVehicleResponse$vehicleName' => '<p>The unique ID of the created vehicle.</p>', 'CreateVehicleResponseItem$vehicleName' => '<p>The unique ID of the vehicle to create.</p>', 'DeleteVehicleRequest$vehicleName' => '<p>The ID of the vehicle to delete. </p>', 'DeleteVehicleResponse$vehicleName' => '<p>The ID of the deleted vehicle.</p>', 'DisassociateVehicleFleetRequest$vehicleName' => '<p> The unique ID of the vehicle to disassociate from the fleet.</p>', 'GetVehicleRequest$vehicleName' => '<p> The ID of the vehicle to retrieve information about. </p>', 'GetVehicleResponse$vehicleName' => '<p>The ID of the vehicle.</p>', 'GetVehicleStatusRequest$vehicleName' => '<p> The ID of the vehicle to retrieve information about. </p>', 'ListFleetsForVehicleRequest$vehicleName' => '<p> The ID of the vehicle to retrieve information about. </p>', 'UpdateVehicleError$vehicleName' => '<p>The ID of the vehicle with the error.</p>', 'UpdateVehicleRequest$vehicleName' => '<p>The unique ID of the vehicle to update.</p>', 'UpdateVehicleRequestItem$vehicleName' => '<p>The unique ID of the vehicle to update.</p>', 'UpdateVehicleResponse$vehicleName' => '<p>The ID of the updated vehicle.</p>', 'UpdateVehicleResponseItem$vehicleName' => '<p>The unique ID of the updated vehicle.</p>', 'VehicleStatus$vehicleName' => '<p>The unique ID of the vehicle.</p>', 'VehicleSummary$vehicleName' => '<p>The unique ID of the vehicle.</p>', 'vehicles$member' => NULL, ], ], 'vehicleSummaries' => [ 'base' => NULL, 'refs' => [ 'ListVehiclesResponse$vehicleSummaries' => '<p> A list of vehicles and information about them. </p>', ], ], 'vehicles' => [ 'base' => NULL, 'refs' => [ 'ListVehiclesInFleetResponse$vehicles' => '<p> A list of vehicles associated with the fleet. </p>', ], ], 'wildcardSignalName' => [ 'base' => NULL, 'refs' => [ 'SignalInformation$name' => '<p>The name of the signal.</p>', ], ], ],];
