<?php
// This file was auto-generated from sdk-root/src/data/iotsitewise/2019-12-02/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Welcome to the IoT SiteWise API Reference. IoT SiteWise is an Amazon Web Services service that connects <a href="https://en.wikipedia.org/wiki/Internet_of_things#Industrial_applications">Industrial Internet of Things (IIoT)</a> devices to the power of the Amazon Web Services Cloud. For more information, see the <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/">IoT SiteWise User Guide</a>. For information about IoT SiteWise quotas, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'operations' => [ 'AssociateAssets' => '<p>Associates a child asset with the given parent asset through a hierarchy defined in the parent asset\'s model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/add-associated-assets.html">Associating assets</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'AssociateTimeSeriesToAssetProperty' => '<p>Associates a time series (data stream) with an asset property.</p>', 'BatchAssociateProjectAssets' => '<p>Associates a group (batch) of assets with an IoT SiteWise Monitor project.</p>', 'BatchDisassociateProjectAssets' => '<p>Disassociates a group (batch) of assets from an IoT SiteWise Monitor project.</p>', 'BatchGetAssetPropertyAggregates' => '<p>Gets aggregated values (for example, average, minimum, and maximum) for one or more asset properties. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#aggregates">Querying aggregates</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'BatchGetAssetPropertyValue' => '<p>Gets the current value for one or more asset properties. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#current-values">Querying current values</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'BatchGetAssetPropertyValueHistory' => '<p>Gets the historical values for one or more asset properties. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#historical-values">Querying historical values</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'BatchPutAssetPropertyValue' => '<p>Sends a list of asset property values to IoT SiteWise. Each value is a timestamp-quality-value (TQV) data point. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/ingest-api.html">Ingesting data using the API</a> in the <i>IoT SiteWise User Guide</i>.</p> <p>To identify an asset property, you must specify one of the following:</p> <ul> <li> <p>The <code>assetId</code> and <code>propertyId</code> of an asset property.</p> </li> <li> <p>A <code>propertyAlias</code>, which is a data stream alias (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). To define an asset property\'s alias, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html">UpdateAssetProperty</a>.</p> </li> </ul> <important> <p>With respect to Unix epoch time, IoT SiteWise accepts only TQVs that have a timestamp of no more than 7 days in the past and no more than 10 minutes in the future. IoT SiteWise rejects timestamps outside of the inclusive range of [-7 days, +10 minutes] and returns a <code>TimestampOutOfRangeException</code> error.</p> <p>For each asset property, IoT SiteWise overwrites TQVs with duplicate timestamps unless the newer TQV has a different quality. For example, if you store a TQV <code>{T1, GOOD, V1}</code>, then storing <code>{T1, GOOD, V2}</code> replaces the existing TQV.</p> </important> <p>IoT SiteWise authorizes access to each <code>BatchPutAssetPropertyValue</code> entry individually. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/security_iam_service-with-iam.html#security_iam_service-with-iam-id-based-policies-batchputassetpropertyvalue-action">BatchPutAssetPropertyValue authorization</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'CreateAccessPolicy' => '<p>Creates an access policy that grants the specified identity (IAM Identity Center user, IAM Identity Center group, or IAM user) access to the specified IoT SiteWise Monitor portal or project resource.</p>', 'CreateAsset' => '<p>Creates an asset from an existing asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-assets.html">Creating assets</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'CreateAssetModel' => '<p>Creates an asset model from specified property and hierarchy definitions. You create assets from asset models. With asset models, you can easily create assets of the same type that have standardized definitions. Each asset created from a model inherits the asset model\'s property and hierarchy definitions. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/define-models.html">Defining asset models</a> in the <i>IoT SiteWise User Guide</i>.</p> <p>You can create two types of asset models, <code>ASSET_MODEL</code> or <code>COMPONENT_MODEL</code>.</p> <ul> <li> <p> <b>ASSET_MODEL</b> – (default) An asset model that you can use to create assets. Can\'t be included as a component in another asset model.</p> </li> <li> <p> <b>COMPONENT_MODEL</b> – A reusable component that you can include in the composite models of other asset models. You can\'t create assets directly from this type of asset model. </p> </li> </ul>', 'CreateAssetModelCompositeModel' => '<p>Creates a custom composite model from specified property and hierarchy definitions. There are two types of custom composite models, <code>inline</code> and <code>component-model-based</code>. </p> <p>Use component-model-based custom composite models to define standard, reusable components. A component-model-based custom composite model consists of a name, a description, and the ID of the component model it references. A component-model-based custom composite model has no properties of its own; its referenced component model provides its associated properties to any created assets. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/custom-composite-models.html">Custom composite models (Components)</a> in the <i>IoT SiteWise User Guide</i>.</p> <p>Use inline custom composite models to organize the properties of an asset model. The properties of inline custom composite models are local to the asset model where they are included and can\'t be used to create multiple assets.</p> <p>To create a component-model-based model, specify the <code>composedAssetModelId</code> of an existing asset model with <code>assetModelType</code> of <code>COMPONENT_MODEL</code>.</p> <p>To create an inline model, specify the <code>assetModelCompositeModelProperties</code> and don\'t include an <code>composedAssetModelId</code>.</p>', 'CreateBulkImportJob' => '<p>Defines a job to ingest data to IoT SiteWise from Amazon S3. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/CreateBulkImportJob.html">Create a bulk import job (CLI)</a> in the <i>Amazon Simple Storage Service User Guide</i>.</p> <important> <p>Before you create a bulk import job, you must enable IoT SiteWise warm tier or IoT SiteWise cold tier. For more information about how to configure storage settings, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_PutStorageConfiguration.html">PutStorageConfiguration</a>.</p> <p>Bulk import is designed to store historical data to IoT SiteWise. It does not trigger computations or notifications on IoT SiteWise warm or cold tier storage.</p> </important>', 'CreateDashboard' => '<p>Creates a dashboard in an IoT SiteWise Monitor project.</p>', 'CreateGateway' => '<p>Creates a gateway, which is a virtual or edge device that delivers industrial data streams from local servers to IoT SiteWise. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/gateway-connector.html">Ingesting data using a gateway</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'CreatePortal' => '<p>Creates a portal, which can contain projects and dashboards. IoT SiteWise Monitor uses IAM Identity Center or IAM to authenticate portal users and manage user permissions.</p> <note> <p>Before you can sign in to a new portal, you must add at least one identity to that portal. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/administer-portals.html#portal-change-admins">Adding or removing portal administrators</a> in the <i>IoT SiteWise User Guide</i>.</p> </note>', 'CreateProject' => '<p>Creates a project in the specified portal.</p> <note> <p>Make sure that the project name and description don\'t contain confidential information.</p> </note>', 'DeleteAccessPolicy' => '<p>Deletes an access policy that grants the specified identity access to the specified IoT SiteWise Monitor resource. You can use this operation to revoke access to an IoT SiteWise Monitor resource.</p>', 'DeleteAsset' => '<p>Deletes an asset. This action can\'t be undone. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/delete-assets-and-models.html">Deleting assets and models</a> in the <i>IoT SiteWise User Guide</i>.</p> <note> <p>You can\'t delete an asset that\'s associated to another asset. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DisassociateAssets.html">DisassociateAssets</a>.</p> </note>', 'DeleteAssetModel' => '<p>Deletes an asset model. This action can\'t be undone. You must delete all assets created from an asset model before you can delete the model. Also, you can\'t delete an asset model if a parent asset model exists that contains a property formula expression that depends on the asset model that you want to delete. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/delete-assets-and-models.html">Deleting assets and models</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'DeleteAssetModelCompositeModel' => '<p>Deletes a composite model. This action can\'t be undone. You must delete all assets created from a composite model before you can delete the model. Also, you can\'t delete a composite model if a parent asset model exists that contains a property formula expression that depends on the asset model that you want to delete. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/delete-assets-and-models.html">Deleting assets and models</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'DeleteDashboard' => '<p>Deletes a dashboard from IoT SiteWise Monitor.</p>', 'DeleteGateway' => '<p>Deletes a gateway from IoT SiteWise. When you delete a gateway, some of the gateway\'s files remain in your gateway\'s file system.</p>', 'DeletePortal' => '<p>Deletes a portal from IoT SiteWise Monitor.</p>', 'DeleteProject' => '<p>Deletes a project from IoT SiteWise Monitor.</p>', 'DeleteTimeSeries' => '<p>Deletes a time series (data stream). If you delete a time series that\'s associated with an asset property, the asset property still exists, but the time series will no longer be associated with this asset property.</p> <p>To identify a time series, do one of the following:</p> <ul> <li> <p>If the time series isn\'t associated with an asset property, specify the <code>alias</code> of the time series.</p> </li> <li> <p>If the time series is associated with an asset property, specify one of the following: </p> <ul> <li> <p>The <code>alias</code> of the time series.</p> </li> <li> <p>The <code>assetId</code> and <code>propertyId</code> that identifies the asset property.</p> </li> </ul> </li> </ul>', 'DescribeAccessPolicy' => '<p>Describes an access policy, which specifies an identity\'s access to an IoT SiteWise Monitor portal or project.</p>', 'DescribeAction' => '<p>Retrieves information about an action.</p>', 'DescribeAsset' => '<p>Retrieves information about an asset.</p>', 'DescribeAssetCompositeModel' => '<p>Retrieves information about an asset composite model (also known as an asset component). An <code>AssetCompositeModel</code> is an instance of an <code>AssetModelCompositeModel</code>. If you want to see information about the model this is based on, call <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAssetModelCompositeModel.html">DescribeAssetModelCompositeModel</a>.</p>', 'DescribeAssetModel' => '<p>Retrieves information about an asset model.</p>', 'DescribeAssetModelCompositeModel' => '<p>Retrieves information about an asset model composite model (also known as an asset model component). For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/custom-composite-models.html">Custom composite models (Components)</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'DescribeAssetProperty' => '<p>Retrieves information about an asset property.</p> <note> <p>When you call this operation for an attribute property, this response includes the default attribute value that you define in the asset model. If you update the default value in the model, this operation\'s response includes the new default value.</p> </note> <p>This operation doesn\'t return the value of the asset property. To get the value of an asset property, use <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_GetAssetPropertyValue.html">GetAssetPropertyValue</a>.</p>', 'DescribeBulkImportJob' => '<p>Retrieves information about a bulk import job request. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/DescribeBulkImportJob.html">Describe a bulk import job (CLI)</a> in the <i>Amazon Simple Storage Service User Guide</i>.</p>', 'DescribeDashboard' => '<p>Retrieves information about a dashboard.</p>', 'DescribeDefaultEncryptionConfiguration' => '<p>Retrieves information about the default encryption configuration for the Amazon Web Services account in the default or specified Region. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/key-management.html">Key management</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'DescribeGateway' => '<p>Retrieves information about a gateway.</p>', 'DescribeGatewayCapabilityConfiguration' => '<p>Retrieves information about a gateway capability configuration. Each gateway capability defines data sources for a gateway. A capability configuration can contain multiple data source configurations. If you define OPC-UA sources for a gateway in the IoT SiteWise console, all of your OPC-UA sources are stored in one capability configuration. To list all capability configurations for a gateway, use <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGateway.html">DescribeGateway</a>.</p>', 'DescribeLoggingOptions' => '<p>Retrieves the current IoT SiteWise logging options.</p>', 'DescribePortal' => '<p>Retrieves information about a portal.</p>', 'DescribeProject' => '<p>Retrieves information about a project.</p>', 'DescribeStorageConfiguration' => '<p>Retrieves information about the storage configuration for IoT SiteWise.</p>', 'DescribeTimeSeries' => '<p>Retrieves information about a time series (data stream).</p> <p>To identify a time series, do one of the following:</p> <ul> <li> <p>If the time series isn\'t associated with an asset property, specify the <code>alias</code> of the time series.</p> </li> <li> <p>If the time series is associated with an asset property, specify one of the following: </p> <ul> <li> <p>The <code>alias</code> of the time series.</p> </li> <li> <p>The <code>assetId</code> and <code>propertyId</code> that identifies the asset property.</p> </li> </ul> </li> </ul>', 'DisassociateAssets' => '<p>Disassociates a child asset from the given parent asset through a hierarchy defined in the parent asset\'s model.</p>', 'DisassociateTimeSeriesFromAssetProperty' => '<p>Disassociates a time series (data stream) from an asset property.</p>', 'ExecuteAction' => '<p>Executes an action on a target resource.</p>', 'ExecuteQuery' => '<p>Run SQL queries to retrieve metadata and time-series data from asset models, assets, measurements, metrics, transforms, and aggregates.</p>', 'GetAssetPropertyAggregates' => '<p>Gets aggregated values for an asset property. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#aggregates">Querying aggregates</a> in the <i>IoT SiteWise User Guide</i>.</p> <p>To identify an asset property, you must specify one of the following:</p> <ul> <li> <p>The <code>assetId</code> and <code>propertyId</code> of an asset property.</p> </li> <li> <p>A <code>propertyAlias</code>, which is a data stream alias (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). To define an asset property\'s alias, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html">UpdateAssetProperty</a>.</p> </li> </ul>', 'GetAssetPropertyValue' => '<p>Gets an asset property\'s current value. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#current-values">Querying current values</a> in the <i>IoT SiteWise User Guide</i>.</p> <p>To identify an asset property, you must specify one of the following:</p> <ul> <li> <p>The <code>assetId</code> and <code>propertyId</code> of an asset property.</p> </li> <li> <p>A <code>propertyAlias</code>, which is a data stream alias (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). To define an asset property\'s alias, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html">UpdateAssetProperty</a>.</p> </li> </ul>', 'GetAssetPropertyValueHistory' => '<p>Gets the history of an asset property\'s values. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#historical-values">Querying historical values</a> in the <i>IoT SiteWise User Guide</i>.</p> <p>To identify an asset property, you must specify one of the following:</p> <ul> <li> <p>The <code>assetId</code> and <code>propertyId</code> of an asset property.</p> </li> <li> <p>A <code>propertyAlias</code>, which is a data stream alias (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). To define an asset property\'s alias, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html">UpdateAssetProperty</a>.</p> </li> </ul>', 'GetInterpolatedAssetPropertyValues' => '<p>Get interpolated values for an asset property for a specified time interval, during a period of time. If your time series is missing data points during the specified time interval, you can use interpolation to estimate the missing data.</p> <p>For example, you can use this operation to return the interpolated temperature values for a wind turbine every 24 hours over a duration of 7 days.</p> <p>To identify an asset property, you must specify one of the following:</p> <ul> <li> <p>The <code>assetId</code> and <code>propertyId</code> of an asset property.</p> </li> <li> <p>A <code>propertyAlias</code>, which is a data stream alias (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). To define an asset property\'s alias, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html">UpdateAssetProperty</a>.</p> </li> </ul>', 'ListAccessPolicies' => '<p>Retrieves a paginated list of access policies for an identity (an IAM Identity Center user, an IAM Identity Center group, or an IAM user) or an IoT SiteWise Monitor resource (a portal or project).</p>', 'ListActions' => '<p>Retrieves a paginated list of actions for a specific target resource.</p>', 'ListAssetModelCompositeModels' => '<p>Retrieves a paginated list of composite models associated with the asset model</p>', 'ListAssetModelProperties' => '<p>Retrieves a paginated list of properties associated with an asset model. If you update properties associated with the model before you finish listing all the properties, you need to start all over again.</p>', 'ListAssetModels' => '<p>Retrieves a paginated list of summaries of all asset models.</p>', 'ListAssetProperties' => '<p>Retrieves a paginated list of properties associated with an asset. If you update properties associated with the model before you finish listing all the properties, you need to start all over again.</p>', 'ListAssetRelationships' => '<p>Retrieves a paginated list of asset relationships for an asset. You can use this operation to identify an asset\'s root asset and all associated assets between that asset and its root.</p>', 'ListAssets' => '<p>Retrieves a paginated list of asset summaries.</p> <p>You can use this operation to do the following:</p> <ul> <li> <p>List assets based on a specific asset model.</p> </li> <li> <p>List top-level assets.</p> </li> </ul> <p>You can\'t use this operation to list all assets. To retrieve summaries for all of your assets, use <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_ListAssetModels.html">ListAssetModels</a> to get all of your asset model IDs. Then, use ListAssets to get all assets for each asset model.</p>', 'ListAssociatedAssets' => '<p>Retrieves a paginated list of associated assets.</p> <p>You can use this operation to do the following:</p> <ul> <li> <p>List child assets associated to a parent asset by a hierarchy that you specify.</p> </li> <li> <p>List an asset\'s parent asset.</p> </li> </ul>', 'ListBulkImportJobs' => '<p>Retrieves a paginated list of bulk import job requests. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/ListBulkImportJobs.html">List bulk import jobs (CLI)</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'ListCompositionRelationships' => '<p>Retrieves a paginated list of composition relationships for an asset model of type <code>COMPONENT_MODEL</code>.</p>', 'ListDashboards' => '<p>Retrieves a paginated list of dashboards for an IoT SiteWise Monitor project.</p>', 'ListGateways' => '<p>Retrieves a paginated list of gateways.</p>', 'ListPortals' => '<p>Retrieves a paginated list of IoT SiteWise Monitor portals.</p>', 'ListProjectAssets' => '<p>Retrieves a paginated list of assets associated with an IoT SiteWise Monitor project.</p>', 'ListProjects' => '<p>Retrieves a paginated list of projects for an IoT SiteWise Monitor portal.</p>', 'ListTagsForResource' => '<p>Retrieves the list of tags for an IoT SiteWise resource.</p>', 'ListTimeSeries' => '<p>Retrieves a paginated list of time series (data streams).</p>', 'PutDefaultEncryptionConfiguration' => '<p>Sets the default encryption configuration for the Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/key-management.html">Key management</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'PutLoggingOptions' => '<p>Sets logging options for IoT SiteWise.</p>', 'PutStorageConfiguration' => '<p>Configures storage settings for IoT SiteWise.</p>', 'TagResource' => '<p>Adds tags to an IoT SiteWise resource. If a tag already exists for the resource, this operation updates the tag\'s value.</p>', 'UntagResource' => '<p>Removes a tag from an IoT SiteWise resource.</p>', 'UpdateAccessPolicy' => '<p>Updates an existing access policy that specifies an identity\'s access to an IoT SiteWise Monitor portal or project resource.</p>', 'UpdateAsset' => '<p>Updates an asset\'s name. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/update-assets-and-models.html">Updating assets and models</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'UpdateAssetModel' => '<p>Updates an asset model and all of the assets that were created from the model. Each asset created from the model inherits the updated asset model\'s property and hierarchy definitions. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/update-assets-and-models.html">Updating assets and models</a> in the <i>IoT SiteWise User Guide</i>.</p> <important> <p>This operation overwrites the existing model with the provided model. To avoid deleting your asset model\'s properties or hierarchies, you must include their IDs and definitions in the updated asset model payload. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAssetModel.html">DescribeAssetModel</a>.</p> <p>If you remove a property from an asset model, IoT SiteWise deletes all previous data for that property. If you remove a hierarchy definition from an asset model, IoT SiteWise disassociates every asset associated with that hierarchy. You can\'t change the type or data type of an existing property.</p> </important>', 'UpdateAssetModelCompositeModel' => '<p>Updates a composite model and all of the assets that were created from the model. Each asset created from the model inherits the updated asset model\'s property and hierarchy definitions. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/update-assets-and-models.html">Updating assets and models</a> in the <i>IoT SiteWise User Guide</i>.</p> <important> <p>If you remove a property from a composite asset model, IoT SiteWise deletes all previous data for that property. You can’t change the type or data type of an existing property.</p> <p>To replace an existing composite asset model property with a new one with the same <code>name</code>, do the following:</p> <ol> <li> <p>Submit an <code>UpdateAssetModelCompositeModel</code> request with the entire existing property removed.</p> </li> <li> <p>Submit a second <code>UpdateAssetModelCompositeModel</code> request that includes the new property. The new asset property will have the same <code>name</code> as the previous one and IoT SiteWise will generate a new unique <code>id</code>.</p> </li> </ol> </important>', 'UpdateAssetProperty' => '<p>Updates an asset property\'s alias and notification state.</p> <important> <p>This operation overwrites the property\'s existing alias and notification state. To keep your existing property\'s alias or notification state, you must include the existing values in the UpdateAssetProperty request. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAssetProperty.html">DescribeAssetProperty</a>.</p> </important>', 'UpdateDashboard' => '<p>Updates an IoT SiteWise Monitor dashboard.</p>', 'UpdateGateway' => '<p>Updates a gateway\'s name.</p>', 'UpdateGatewayCapabilityConfiguration' => '<p>Updates a gateway capability configuration or defines a new capability configuration. Each gateway capability defines data sources for a gateway. A capability configuration can contain multiple data source configurations. If you define OPC-UA sources for a gateway in the IoT SiteWise console, all of your OPC-UA sources are stored in one capability configuration. To list all capability configurations for a gateway, use <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGateway.html">DescribeGateway</a>.</p>', 'UpdatePortal' => '<p>Updates an IoT SiteWise Monitor portal.</p>', 'UpdateProject' => '<p>Updates an IoT SiteWise Monitor project.</p>', ], 'shapes' => [ 'ARN' => [ 'base' => NULL, 'refs' => [ 'Alarms$alarmRoleArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the IAM role that allows the alarm to perform actions and access Amazon Web Services resources and services, such as IoT Events.</p>', 'Alarms$notificationLambdaArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the Lambda function that manages alarm notifications. For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/lambda-support.html">Managing alarm notifications</a> in the <i>IoT Events Developer Guide</i>.</p>', 'AssetModelSummary$arn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the asset model, which has the following format.</p> <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset-model/${AssetModelId}</code> </p>', 'AssetSummary$arn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the asset, which has the following format.</p> <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}</code> </p>', 'AssociatedAssetsSummary$arn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the asset, which has the following format.</p> <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}</code> </p>', 'CreateAccessPolicyResponse$accessPolicyArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the access policy, which has the following format.</p> <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:access-policy/${AccessPolicyId}</code> </p>', 'CreateAssetModelResponse$assetModelArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the asset model, which has the following format.</p> <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset-model/${AssetModelId}</code> </p>', 'CreateAssetResponse$assetArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the asset, which has the following format.</p> <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}</code> </p>', 'CreateBulkImportJobRequest$jobRoleArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the IAM role that allows IoT SiteWise to read Amazon S3 data.</p>', 'CreateDashboardResponse$dashboardArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the dashboard, which has the following format.</p> <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:dashboard/${DashboardId}</code> </p>', 'CreateGatewayResponse$gatewayArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the gateway, which has the following format.</p> <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:gateway/${GatewayId}</code> </p>', 'CreatePortalRequest$roleArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of a service role that allows the portal\'s users to access your IoT SiteWise resources on your behalf. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using service roles for IoT SiteWise Monitor</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'CreatePortalResponse$portalArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the portal, which has the following format.</p> <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:portal/${PortalId}</code> </p>', 'CreateProjectResponse$projectArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the project, which has the following format.</p> <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:project/${ProjectId}</code> </p>', 'CustomerManagedS3Storage$s3ResourceArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the Amazon S3 object. For more information about how to find the ARN for an Amazon S3 object, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-arn-format.html">Amazon S3 resources</a> in the <i>Amazon Simple Storage Service User Guide</i>.</p>', 'CustomerManagedS3Storage$roleArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the Identity and Access Management role that allows IoT SiteWise to send data to Amazon S3.</p>', 'DescribeAccessPolicyResponse$accessPolicyArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the access policy, which has the following format.</p> <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:access-policy/${AccessPolicyId}</code> </p>', 'DescribeAssetModelResponse$assetModelArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the asset model, which has the following format.</p> <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset-model/${AssetModelId}</code> </p>', 'DescribeAssetResponse$assetArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the asset, which has the following format.</p> <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}</code> </p>', 'DescribeBulkImportJobResponse$jobRoleArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the IAM role that allows IoT SiteWise to read Amazon S3 data.</p>', 'DescribeDashboardResponse$dashboardArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the dashboard, which has the following format.</p> <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:dashboard/${DashboardId}</code> </p>', 'DescribeDefaultEncryptionConfigurationResponse$kmsKeyArn' => '<p>The key ARN of the customer managed key used for KMS encryption if you use <code>KMS_BASED_ENCRYPTION</code>.</p>', 'DescribeGatewayResponse$gatewayArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the gateway, which has the following format.</p> <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:gateway/${GatewayId}</code> </p>', 'DescribePortalResponse$portalArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the portal, which has the following format.</p> <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:portal/${PortalId}</code> </p>', 'DescribePortalResponse$roleArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the service role that allows the portal\'s users to access your IoT SiteWise resources on your behalf. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using service roles for IoT SiteWise Monitor</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'DescribeProjectResponse$projectArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the project, which has the following format.</p> <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:project/${ProjectId}</code> </p>', 'DescribeTimeSeriesResponse$timeSeriesArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the time series, which has the following format.</p> <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:time-series/${TimeSeriesId}</code> </p>', 'Greengrass$groupArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the Greengrass group. For more information about how to find a group\'s ARN, see <a href="https://docs.aws.amazon.com/greengrass/latest/apireference/listgroups-get.html">ListGroups</a> and <a href="https://docs.aws.amazon.com/greengrass/latest/apireference/getgroup-get.html">GetGroup</a> in the <i>IoT Greengrass API Reference</i>.</p>', 'IAMRoleIdentity$arn' => '<p>The ARN of the IAM role. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM ARNs</a> in the <i>IAM User Guide</i>.</p>', 'IAMUserIdentity$arn' => '<p>The ARN of the IAM user. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM ARNs</a> in the <i>IAM User Guide</i>.</p> <note> <p>If you delete the IAM user, access policies that contain this identity include an empty <code>arn</code>. You can delete the access policy for the IAM user that no longer exists.</p> </note>', 'ListAccessPoliciesRequest$iamArn' => '<p>The ARN of the IAM user. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM ARNs</a> in the <i>IAM User Guide</i>. This parameter is required if you specify <code>IAM</code> for <code>identityType</code>.</p>', 'PortalSummary$roleArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the service role that allows the portal\'s users to access your IoT SiteWise resources on your behalf. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using service roles for IoT SiteWise Monitor</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'PutDefaultEncryptionConfigurationResponse$kmsKeyArn' => '<p>The Key ARN of the KMS key used for KMS encryption if you use <code>KMS_BASED_ENCRYPTION</code>.</p>', 'TimeSeriesSummary$timeSeriesArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the time series, which has the following format.</p> <p> <code>arn:${Partition}:iotsitewise:${Region}:${Account}:time-series/${TimeSeriesId}</code> </p>', 'UpdatePortalRequest$roleArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of a service role that allows the portal\'s users to access your IoT SiteWise resources on your behalf. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using service roles for IoT SiteWise Monitor</a> in the <i>IoT SiteWise User Guide</i>.</p>', ], ], 'AccessDeniedException' => [ 'base' => '<p>Access is denied.</p>', 'refs' => [], ], 'AccessPolicySummaries' => [ 'base' => NULL, 'refs' => [ 'ListAccessPoliciesResponse$accessPolicySummaries' => '<p>A list that summarizes each access policy.</p>', ], ], 'AccessPolicySummary' => [ 'base' => '<p>Contains an access policy that defines an identity\'s access to an IoT SiteWise Monitor resource.</p>', 'refs' => [ 'AccessPolicySummaries$member' => NULL, ], ], 'ActionDefinition' => [ 'base' => '<p>Contains a definition for an action.</p>', 'refs' => [ 'ActionDefinitions$member' => NULL, ], ], 'ActionDefinitions' => [ 'base' => NULL, 'refs' => [ 'DescribeAssetCompositeModelResponse$actionDefinitions' => '<p>The available actions for a composite model on this asset.</p>', 'DescribeAssetModelCompositeModelResponse$actionDefinitions' => '<p>The available actions for a composite model on this asset model.</p>', ], ], 'ActionPayload' => [ 'base' => '<p>The JSON payload of the action.</p>', 'refs' => [ 'DescribeActionResponse$actionPayload' => '<p>The JSON payload of the action.</p>', 'ExecuteActionRequest$actionPayload' => '<p>The JSON payload of the action.</p>', ], ], 'ActionPayloadString' => [ 'base' => NULL, 'refs' => [ 'ActionPayload$stringValue' => '<p>The payload of the action in a JSON string.</p>', ], ], 'ActionSummaries' => [ 'base' => NULL, 'refs' => [ 'ListActionsResponse$actionSummaries' => '<p>A list that summarizes the actions associated with the specified asset.</p>', ], ], 'ActionSummary' => [ 'base' => '<p>Contains the summary of the actions.</p>', 'refs' => [ 'ActionSummaries$member' => NULL, ], ], 'AdaptiveIngestion' => [ 'base' => NULL, 'refs' => [ 'CreateBulkImportJobRequest$adaptiveIngestion' => '<p>If set to true, ingest new data into IoT SiteWise storage. Measurements with notifications, metrics and transforms are computed. If set to false, historical data is ingested into IoT SiteWise as is.</p>', 'DescribeBulkImportJobResponse$adaptiveIngestion' => '<p>If set to true, ingest new data into IoT SiteWise storage. Measurements with notifications, metrics and transforms are computed. If set to false, historical data is ingested into IoT SiteWise as is.</p>', ], ], 'AggregateType' => [ 'base' => NULL, 'refs' => [ 'AggregateTypes$member' => NULL, ], ], 'AggregateTypes' => [ 'base' => NULL, 'refs' => [ 'BatchGetAssetPropertyAggregatesEntry$aggregateTypes' => '<p>The data aggregating function.</p>', 'GetAssetPropertyAggregatesRequest$aggregateTypes' => '<p>The data aggregating function.</p>', ], ], 'AggregatedDoubleValue' => [ 'base' => NULL, 'refs' => [ 'Aggregates$average' => '<p>The average (mean) value of the time series over a time interval window.</p>', 'Aggregates$count' => '<p>The count of data points in the time series over a time interval window.</p>', 'Aggregates$maximum' => '<p>The maximum value of the time series over a time interval window.</p>', 'Aggregates$minimum' => '<p>The minimum value of the time series over a time interval window.</p>', 'Aggregates$sum' => '<p>The sum of the time series over a time interval window.</p>', 'Aggregates$standardDeviation' => '<p>The standard deviation of the time series over a time interval window.</p>', ], ], 'AggregatedValue' => [ 'base' => '<p>Contains aggregated asset property values (for example, average, minimum, and maximum).</p>', 'refs' => [ 'AggregatedValues$member' => NULL, ], ], 'AggregatedValues' => [ 'base' => NULL, 'refs' => [ 'BatchGetAssetPropertyAggregatesSuccessEntry$aggregatedValues' => '<p>The requested aggregated asset property values (for example, average, minimum, and maximum).</p>', 'GetAssetPropertyAggregatesResponse$aggregatedValues' => '<p>The requested aggregated values.</p>', ], ], 'Aggregates' => [ 'base' => '<p>Contains the (pre-calculated) aggregate values for an asset property.</p>', 'refs' => [ 'AggregatedValue$value' => '<p>The value of the aggregates.</p>', ], ], 'Alarms' => [ 'base' => '<p>Contains the configuration information of an alarm created in an IoT SiteWise Monitor portal. You can use the alarm to monitor an asset property and get notified when the asset property value is outside a specified range. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/appguide/monitor-alarms.html">Monitoring with alarms</a> in the <i>IoT SiteWise Application Guide</i>.</p>', 'refs' => [ 'CreatePortalRequest$alarms' => '<p>Contains the configuration information of an alarm created in an IoT SiteWise Monitor portal. You can use the alarm to monitor an asset property and get notified when the asset property value is outside a specified range. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/appguide/monitor-alarms.html">Monitoring with alarms</a> in the <i>IoT SiteWise Application Guide</i>.</p>', 'DescribePortalResponse$alarms' => '<p>Contains the configuration information of an alarm created in an IoT SiteWise Monitor portal.</p>', 'UpdatePortalRequest$alarms' => '<p>Contains the configuration information of an alarm created in an IoT SiteWise Monitor portal. You can use the alarm to monitor an asset property and get notified when the asset property value is outside a specified range. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/appguide/monitor-alarms.html">Monitoring with alarms</a> in the <i>IoT SiteWise Application Guide</i>.</p>', ], ], 'AmazonResourceName' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$resourceArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the resource.</p>', 'TagResourceRequest$resourceArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the resource to tag.</p>', 'TooManyTagsException$resourceName' => '<p>The name of the resource with too many tags.</p>', 'UntagResourceRequest$resourceArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the resource to untag.</p>', ], ], 'AssetCompositeModel' => [ 'base' => '<p>Contains information about a composite model in an asset. This object contains the asset\'s properties that you define in the composite model.</p>', 'refs' => [ 'AssetCompositeModels$member' => NULL, ], ], 'AssetCompositeModelPath' => [ 'base' => NULL, 'refs' => [ 'AssetCompositeModelSummary$path' => '<p>The path that includes all the components of the asset model for the asset.</p>', 'DescribeAssetCompositeModelResponse$assetCompositeModelPath' => '<p>The path to the composite model listing the parent composite models.</p>', ], ], 'AssetCompositeModelPathSegment' => [ 'base' => '<p>Represents one level between a composite model and the root of the asset.</p>', 'refs' => [ 'AssetCompositeModelPath$member' => NULL, ], ], 'AssetCompositeModelSummaries' => [ 'base' => NULL, 'refs' => [ 'DescribeAssetCompositeModelResponse$assetCompositeModelSummaries' => '<p>The list of composite model summaries.</p>', 'DescribeAssetResponse$assetCompositeModelSummaries' => '<p>The list of the immediate child custom composite model summaries for the asset.</p>', ], ], 'AssetCompositeModelSummary' => [ 'base' => '<p>Contains a summary of the composite model for a specific asset.</p>', 'refs' => [ 'AssetCompositeModelSummaries$member' => NULL, ], ], 'AssetCompositeModels' => [ 'base' => NULL, 'refs' => [ 'DescribeAssetResponse$assetCompositeModels' => '<p>The composite models for the asset.</p>', ], ], 'AssetErrorCode' => [ 'base' => NULL, 'refs' => [ 'AssetErrorDetails$code' => '<p>The error code.</p>', ], ], 'AssetErrorDetails' => [ 'base' => '<p>Contains error details for the requested associate project asset action.</p>', 'refs' => [ 'BatchAssociateProjectAssetsErrors$member' => NULL, 'BatchDisassociateProjectAssetsErrors$member' => NULL, ], ], 'AssetErrorMessage' => [ 'base' => NULL, 'refs' => [ 'AssetErrorDetails$message' => '<p>The error message.</p>', ], ], 'AssetHierarchies' => [ 'base' => NULL, 'refs' => [ 'AssetSummary$hierarchies' => '<p>A list of asset hierarchies that each contain a <code>hierarchyId</code>. A hierarchy specifies allowed parent/child asset relationships.</p>', 'AssociatedAssetsSummary$hierarchies' => '<p>A list of asset hierarchies that each contain a <code>hierarchyId</code>. A hierarchy specifies allowed parent/child asset relationships.</p>', 'DescribeAssetResponse$assetHierarchies' => '<p>A list of asset hierarchies that each contain a <code>hierarchyId</code>. A hierarchy specifies allowed parent/child asset relationships.</p>', ], ], 'AssetHierarchy' => [ 'base' => '<p>Describes an asset hierarchy that contains a hierarchy\'s name and ID.</p>', 'refs' => [ 'AssetHierarchies$member' => NULL, ], ], 'AssetHierarchyInfo' => [ 'base' => '<p>Contains information about a parent asset and a child asset that are related through an asset hierarchy.</p>', 'refs' => [ 'AssetRelationshipSummary$hierarchyInfo' => '<p>The assets that are related through an asset hierarchy.</p> <p>This object is present if the <code>relationshipType</code> is <code>HIERARCHY</code>.</p>', ], ], 'AssetIDs' => [ 'base' => NULL, 'refs' => [ 'ListProjectAssetsResponse$assetIds' => '<p>A list that contains the IDs of each asset associated with the project.</p>', ], ], 'AssetModelCompositeModel' => [ 'base' => '<p>Contains information about a composite model in an asset model. This object contains the asset property definitions that you define in the composite model.</p>', 'refs' => [ 'AssetModelCompositeModels$member' => NULL, ], ], 'AssetModelCompositeModelDefinition' => [ 'base' => '<p>Contains a composite model definition in an asset model. This composite model definition is applied to all assets created from the asset model.</p>', 'refs' => [ 'AssetModelCompositeModelDefinitions$member' => NULL, ], ], 'AssetModelCompositeModelDefinitions' => [ 'base' => NULL, 'refs' => [ 'CreateAssetModelRequest$assetModelCompositeModels' => '<p>The composite models that are part of this asset model. It groups properties (such as attributes, measurements, transforms, and metrics) and child composite models that model parts of your industrial equipment. Each composite model has a type that defines the properties that the composite model supports. Use composite models to define alarms on this asset model.</p> <note> <p>When creating custom composite models, you need to use <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModelCompositeModel.html">CreateAssetModelCompositeModel</a>. For more information, see &lt;LINK&gt;.</p> </note>', ], ], 'AssetModelCompositeModelPath' => [ 'base' => NULL, 'refs' => [ 'AssetModelCompositeModelSummary$path' => '<p>The path that includes all the pieces that make up the composite model.</p>', 'CreateAssetModelCompositeModelResponse$assetModelCompositeModelPath' => '<p>The path to the composite model listing the parent composite models.</p>', 'DescribeAssetModelCompositeModelResponse$assetModelCompositeModelPath' => '<p>The path to the composite model listing the parent composite models.</p>', 'UpdateAssetModelCompositeModelResponse$assetModelCompositeModelPath' => '<p>The path to the composite model listing the parent composite models.</p>', ], ], 'AssetModelCompositeModelPathSegment' => [ 'base' => '<p>Represents one level between a composite model and the root of the asset model.</p>', 'refs' => [ 'AssetModelCompositeModelPath$member' => NULL, ], ], 'AssetModelCompositeModelSummaries' => [ 'base' => NULL, 'refs' => [ 'DescribeAssetModelCompositeModelResponse$assetModelCompositeModelSummaries' => '<p>The list of composite model summaries for the composite model.</p>', 'DescribeAssetModelResponse$assetModelCompositeModelSummaries' => '<p>The list of the immediate child custom composite model summaries for the asset model.</p>', 'ListAssetModelCompositeModelsResponse$assetModelCompositeModelSummaries' => '<p>A list that summarizes each composite model.</p>', ], ], 'AssetModelCompositeModelSummary' => [ 'base' => '<p>Contains a summary of the composite model.</p>', 'refs' => [ 'AssetModelCompositeModelSummaries$member' => NULL, ], ], 'AssetModelCompositeModels' => [ 'base' => NULL, 'refs' => [ 'DescribeAssetModelResponse$assetModelCompositeModels' => '<p>The list of built-in composite models for the asset model, such as those with those of type <code>AWS/ALARMS</code>.</p>', 'UpdateAssetModelRequest$assetModelCompositeModels' => '<p>The composite models that are part of this asset model. It groups properties (such as attributes, measurements, transforms, and metrics) and child composite models that model parts of your industrial equipment. Each composite model has a type that defines the properties that the composite model supports. Use composite models to define alarms on this asset model.</p> <note> <p>When creating custom composite models, you need to use <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModelCompositeModel.html">CreateAssetModelCompositeModel</a>. For more information, see &lt;LINK&gt;.</p> </note>', ], ], 'AssetModelHierarchies' => [ 'base' => NULL, 'refs' => [ 'DescribeAssetModelResponse$assetModelHierarchies' => '<p>A list of asset model hierarchies that each contain a <code>childAssetModelId</code> and a <code>hierarchyId</code> (named <code>id</code>). A hierarchy specifies allowed parent/child asset relationships for an asset model.</p>', 'UpdateAssetModelRequest$assetModelHierarchies' => '<p>The updated hierarchy definitions of the asset model. Each hierarchy specifies an asset model whose assets can be children of any other assets created from this asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p> <p>You can specify up to 10 hierarchies per asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>', ], ], 'AssetModelHierarchy' => [ 'base' => '<p>Describes an asset hierarchy that contains a hierarchy\'s name, ID, and child asset model ID that specifies the type of asset that can be in this hierarchy.</p>', 'refs' => [ 'AssetModelHierarchies$member' => NULL, ], ], 'AssetModelHierarchyDefinition' => [ 'base' => '<p>Contains an asset model hierarchy used in asset model creation. An asset model hierarchy determines the kind (or type) of asset that can belong to a hierarchy.</p>', 'refs' => [ 'AssetModelHierarchyDefinitions$member' => NULL, ], ], 'AssetModelHierarchyDefinitions' => [ 'base' => NULL, 'refs' => [ 'CreateAssetModelRequest$assetModelHierarchies' => '<p>The hierarchy definitions of the asset model. Each hierarchy specifies an asset model whose assets can be children of any other assets created from this asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p> <p>You can specify up to 10 hierarchies per asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>', ], ], 'AssetModelProperties' => [ 'base' => NULL, 'refs' => [ 'AssetModelCompositeModel$properties' => '<p>The asset property definitions for this composite model.</p>', 'DescribeAssetModelCompositeModelResponse$assetModelCompositeModelProperties' => '<p>The property definitions of the composite model.</p>', 'DescribeAssetModelResponse$assetModelProperties' => '<p>The list of asset properties for the asset model.</p> <p>This object doesn\'t include properties that you define in composite models. You can find composite model properties in the <code>assetModelCompositeModels</code> object.</p>', 'UpdateAssetModelCompositeModelRequest$assetModelCompositeModelProperties' => '<p>The property definitions of the composite model. For more information, see &lt;LINK&gt;.</p> <p>You can specify up to 200 properties per composite model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'UpdateAssetModelRequest$assetModelProperties' => '<p>The updated property definitions of the asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html">Asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p> <p>You can specify up to 200 properties per asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>', ], ], 'AssetModelProperty' => [ 'base' => '<p>Contains information about an asset model property.</p>', 'refs' => [ 'AssetModelProperties$member' => NULL, ], ], 'AssetModelPropertyDefinition' => [ 'base' => '<p>Contains an asset model property definition. This property definition is applied to all assets created from the asset model.</p>', 'refs' => [ 'AssetModelPropertyDefinitions$member' => NULL, ], ], 'AssetModelPropertyDefinitions' => [ 'base' => NULL, 'refs' => [ 'AssetModelCompositeModelDefinition$properties' => '<p>The asset property definitions for this composite model.</p>', 'CreateAssetModelCompositeModelRequest$assetModelCompositeModelProperties' => '<p>The property definitions of the composite model. For more information, see &lt;LINK&gt;.</p> <p>You can specify up to 200 properties per composite model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'CreateAssetModelRequest$assetModelProperties' => '<p>The property definitions of the asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html">Asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p> <p>You can specify up to 200 properties per asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>', ], ], 'AssetModelPropertyPath' => [ 'base' => NULL, 'refs' => [ 'AssetModelProperty$path' => '<p>The structured path to the property from the root of the asset model.</p>', 'AssetModelPropertySummary$path' => '<p>The structured path to the property from the root of the asset model.</p>', 'VariableValue$propertyPath' => '<p>The path of the property.</p>', ], ], 'AssetModelPropertyPathSegment' => [ 'base' => '<p>Represents one level between a property and the root of the asset model.</p>', 'refs' => [ 'AssetModelPropertyPath$member' => NULL, ], ], 'AssetModelPropertySummaries' => [ 'base' => NULL, 'refs' => [ 'ListAssetModelPropertiesResponse$assetModelPropertySummaries' => '<p>A list that summarizes the properties associated with the specified asset model.</p>', ], ], 'AssetModelPropertySummary' => [ 'base' => '<p>Contains a summary of a property associated with a model.</p>', 'refs' => [ 'AssetModelPropertySummaries$member' => NULL, ], ], 'AssetModelState' => [ 'base' => NULL, 'refs' => [ 'AssetModelStatus$state' => '<p>The current state of the asset model.</p>', ], ], 'AssetModelStatus' => [ 'base' => '<p>Contains current status information for an asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-and-model-states.html">Asset and model states</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'refs' => [ 'AssetModelSummary$status' => '<p>The current status of the asset model.</p>', 'CreateAssetModelCompositeModelResponse$assetModelStatus' => NULL, 'CreateAssetModelResponse$assetModelStatus' => '<p>The status of the asset model, which contains a state (<code>CREATING</code> after successfully calling this operation) and any error message.</p>', 'DeleteAssetModelCompositeModelResponse$assetModelStatus' => NULL, 'DeleteAssetModelResponse$assetModelStatus' => '<p>The status of the asset model, which contains a state (<code>DELETING</code> after successfully calling this operation) and any error message.</p>', 'DescribeAssetModelResponse$assetModelStatus' => '<p>The current status of the asset model, which contains a state and any error message.</p>', 'UpdateAssetModelCompositeModelResponse$assetModelStatus' => NULL, 'UpdateAssetModelResponse$assetModelStatus' => '<p>The status of the asset model, which contains a state (<code>UPDATING</code> after successfully calling this operation) and any error message.</p>', ], ], 'AssetModelSummaries' => [ 'base' => NULL, 'refs' => [ 'ListAssetModelsResponse$assetModelSummaries' => '<p>A list that summarizes each asset model.</p>', ], ], 'AssetModelSummary' => [ 'base' => '<p>Contains a summary of an asset model.</p>', 'refs' => [ 'AssetModelSummaries$member' => NULL, ], ], 'AssetModelType' => [ 'base' => NULL, 'refs' => [ 'AssetModelSummary$assetModelType' => '<p>The type of asset model.</p> <ul> <li> <p> <b>ASSET_MODEL</b> – (default) An asset model that you can use to create assets. Can\'t be included as a component in another asset model.</p> </li> <li> <p> <b>COMPONENT_MODEL</b> – A reusable component that you can include in the composite models of other asset models. You can\'t create assets directly from this type of asset model. </p> </li> </ul>', 'CreateAssetModelRequest$assetModelType' => '<p>The type of asset model.</p> <ul> <li> <p> <b>ASSET_MODEL</b> – (default) An asset model that you can use to create assets. Can\'t be included as a component in another asset model.</p> </li> <li> <p> <b>COMPONENT_MODEL</b> – A reusable component that you can include in the composite models of other asset models. You can\'t create assets directly from this type of asset model. </p> </li> </ul>', 'DescribeAssetModelResponse$assetModelType' => '<p>The type of asset model.</p> <ul> <li> <p> <b>ASSET_MODEL</b> – (default) An asset model that you can use to create assets. Can\'t be included as a component in another asset model.</p> </li> <li> <p> <b>COMPONENT_MODEL</b> – A reusable component that you can include in the composite models of other asset models. You can\'t create assets directly from this type of asset model. </p> </li> </ul>', 'ListAssetModelsTypeFilter$member' => NULL, ], ], 'AssetProperties' => [ 'base' => NULL, 'refs' => [ 'AssetCompositeModel$properties' => '<p>The asset properties that this composite model defines.</p>', 'DescribeAssetCompositeModelResponse$assetCompositeModelProperties' => '<p>The property definitions of the composite model that was used to create the asset.</p>', 'DescribeAssetResponse$assetProperties' => '<p>The list of asset properties for the asset.</p> <p>This object doesn\'t include properties that you define in composite models. You can find composite model properties in the <code>assetCompositeModels</code> object.</p>', ], ], 'AssetProperty' => [ 'base' => '<p>Contains asset property information.</p>', 'refs' => [ 'AssetProperties$member' => NULL, ], ], 'AssetPropertyAlias' => [ 'base' => NULL, 'refs' => [ 'BatchGetAssetPropertyAggregatesEntry$propertyAlias' => '<p>The alias that identifies the property, such as an OPC-UA server data stream path (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'BatchGetAssetPropertyValueEntry$propertyAlias' => '<p>The alias that identifies the property, such as an OPC-UA server data stream path (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'BatchGetAssetPropertyValueHistoryEntry$propertyAlias' => '<p>The alias that identifies the property, such as an OPC-UA server data stream path (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'GetAssetPropertyAggregatesRequest$propertyAlias' => '<p>The alias that identifies the property, such as an OPC-UA server data stream path (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'GetAssetPropertyValueHistoryRequest$propertyAlias' => '<p>The alias that identifies the property, such as an OPC-UA server data stream path (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'GetAssetPropertyValueRequest$propertyAlias' => '<p>The alias that identifies the property, such as an OPC-UA server data stream path (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'GetInterpolatedAssetPropertyValuesRequest$propertyAlias' => '<p>The alias that identifies the property, such as an OPC-UA server data stream path (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'PutAssetPropertyValueEntry$propertyAlias' => '<p>The alias that identifies the property, such as an OPC-UA server data stream path (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p>', ], ], 'AssetPropertyPath' => [ 'base' => NULL, 'refs' => [ 'AssetProperty$path' => '<p>The structured path to the property from the root of the asset.</p>', 'AssetPropertySummary$path' => '<p>The structured path to the property from the root of the asset.</p>', 'Property$path' => '<p>The structured path to the property from the root of the asset.</p>', ], ], 'AssetPropertyPathSegment' => [ 'base' => '<p>Represents one level between a property and the root of the asset.</p>', 'refs' => [ 'AssetPropertyPath$member' => NULL, ], ], 'AssetPropertySummaries' => [ 'base' => NULL, 'refs' => [ 'ListAssetPropertiesResponse$assetPropertySummaries' => '<p>A list that summarizes the properties associated with the specified asset.</p>', ], ], 'AssetPropertySummary' => [ 'base' => '<p>Contains a summary of a property associated with an asset.</p>', 'refs' => [ 'AssetPropertySummaries$member' => NULL, ], ], 'AssetPropertyValue' => [ 'base' => '<p>Contains asset property value information.</p>', 'refs' => [ 'AssetPropertyValueHistory$member' => NULL, 'AssetPropertyValues$member' => NULL, 'BatchGetAssetPropertyValueSuccessEntry$assetPropertyValue' => NULL, 'GetAssetPropertyValueResponse$propertyValue' => '<p>The current asset property value.</p>', ], ], 'AssetPropertyValueHistory' => [ 'base' => NULL, 'refs' => [ 'BatchGetAssetPropertyValueHistorySuccessEntry$assetPropertyValueHistory' => '<p>The requested historical values for the specified asset property.</p>', 'GetAssetPropertyValueHistoryResponse$assetPropertyValueHistory' => '<p>The asset property\'s value history.</p>', ], ], 'AssetPropertyValues' => [ 'base' => NULL, 'refs' => [ 'PutAssetPropertyValueEntry$propertyValues' => '<p>The list of property values to upload. You can specify up to 10 <code>propertyValues</code> array elements. </p>', ], ], 'AssetRelationshipSummaries' => [ 'base' => NULL, 'refs' => [ 'ListAssetRelationshipsResponse$assetRelationshipSummaries' => '<p>A list that summarizes each asset relationship.</p>', ], ], 'AssetRelationshipSummary' => [ 'base' => '<p>Contains information about assets that are related to one another.</p>', 'refs' => [ 'AssetRelationshipSummaries$member' => NULL, ], ], 'AssetRelationshipType' => [ 'base' => NULL, 'refs' => [ 'AssetRelationshipSummary$relationshipType' => '<p>The relationship type of the assets in this relationship. This value is one of the following:</p> <ul> <li> <p> <code>HIERARCHY</code> – The assets are related through an asset hierarchy. If you specify this relationship type, this asset relationship includes the <code>hierarchyInfo</code> object.</p> </li> </ul>', ], ], 'AssetState' => [ 'base' => NULL, 'refs' => [ 'AssetStatus$state' => '<p>The current status of the asset.</p>', ], ], 'AssetStatus' => [ 'base' => '<p>Contains information about the current status of an asset. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-and-model-states.html">Asset and model states</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'refs' => [ 'AssetSummary$status' => '<p>The current status of the asset.</p>', 'AssociatedAssetsSummary$status' => '<p>The current status of the asset.</p>', 'CreateAssetResponse$assetStatus' => '<p>The status of the asset, which contains a state (<code>CREATING</code> after successfully calling this operation) and any error message.</p>', 'DeleteAssetResponse$assetStatus' => '<p>The status of the asset, which contains a state (<code>DELETING</code> after successfully calling this operation) and any error message.</p>', 'DescribeAssetResponse$assetStatus' => '<p>The current status of the asset, which contains a state and any error message.</p>', 'UpdateAssetResponse$assetStatus' => '<p>The status of the asset, which contains a state (<code>UPDATING</code> after successfully calling this operation) and any error message.</p>', ], ], 'AssetSummaries' => [ 'base' => NULL, 'refs' => [ 'ListAssetsResponse$assetSummaries' => '<p>A list that summarizes each asset.</p>', ], ], 'AssetSummary' => [ 'base' => '<p>Contains a summary of an asset.</p>', 'refs' => [ 'AssetSummaries$member' => NULL, ], ], 'AssociateAssetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateTimeSeriesToAssetPropertyRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociatedAssetsSummaries' => [ 'base' => NULL, 'refs' => [ 'ListAssociatedAssetsResponse$assetSummaries' => '<p>A list that summarizes the associated assets.</p>', ], ], 'AssociatedAssetsSummary' => [ 'base' => '<p>Contains a summary of an associated asset.</p>', 'refs' => [ 'AssociatedAssetsSummaries$member' => NULL, ], ], 'Attribute' => [ 'base' => '<p>Contains an asset attribute property. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html#attributes">Attributes</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'refs' => [ 'PropertyType$attribute' => '<p>Specifies an asset attribute property. An attribute generally contains static information, such as the serial number of an <a href="https://en.wikipedia.org/wiki/Internet_of_things#Industrial_applications">IIoT</a> wind turbine.</p>', ], ], 'AuthMode' => [ 'base' => NULL, 'refs' => [ 'CreatePortalRequest$portalAuthMode' => '<p>The service to use to authenticate users to the portal. Choose from the following options:</p> <ul> <li> <p> <code>SSO</code> – The portal uses IAM Identity Center to authenticate users and manage user permissions. Before you can create a portal that uses IAM Identity Center, you must enable IAM Identity Center. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-get-started.html#mon-gs-sso">Enabling IAM Identity Center</a> in the <i>IoT SiteWise User Guide</i>. This option is only available in Amazon Web Services Regions other than the China Regions.</p> </li> <li> <p> <code>IAM</code> – The portal uses Identity and Access Management to authenticate users and manage user permissions.</p> </li> </ul> <p>You can\'t change this value after you create a portal.</p> <p>Default: <code>SSO</code> </p>', 'DescribePortalResponse$portalAuthMode' => '<p>The service to use to authenticate users to the portal.</p>', ], ], 'BatchAssociateProjectAssetsErrors' => [ 'base' => NULL, 'refs' => [ 'BatchAssociateProjectAssetsResponse$errors' => '<p>A list of associated error information, if any.</p>', ], ], 'BatchAssociateProjectAssetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchAssociateProjectAssetsResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchDisassociateProjectAssetsErrors' => [ 'base' => NULL, 'refs' => [ 'BatchDisassociateProjectAssetsResponse$errors' => '<p>A list of associated error information, if any.</p>', ], ], 'BatchDisassociateProjectAssetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchDisassociateProjectAssetsResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchEntryCompletionStatus' => [ 'base' => NULL, 'refs' => [ 'BatchGetAssetPropertyAggregatesSkippedEntry$completionStatus' => '<p>The completion status of each entry that is associated with the <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyAggregates.html">BatchGetAssetPropertyAggregates</a> API.</p>', 'BatchGetAssetPropertyValueHistorySkippedEntry$completionStatus' => '<p>The completion status of each entry that is associated with the <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyValueHistory.html">BatchGetAssetPropertyValueHistory</a> API.</p>', 'BatchGetAssetPropertyValueSkippedEntry$completionStatus' => '<p>The completion status of each entry that is associated with the <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyValue.html">BatchGetAssetPropertyValue</a> request.</p>', ], ], 'BatchGetAssetPropertyAggregatesEntries' => [ 'base' => NULL, 'refs' => [ 'BatchGetAssetPropertyAggregatesRequest$entries' => '<p>The list of asset property aggregate entries for the batch get request. You can specify up to 16 entries per request.</p>', ], ], 'BatchGetAssetPropertyAggregatesEntry' => [ 'base' => '<p>Contains information for an asset property aggregate entry that is associated with the <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyAggregates.html">BatchGetAssetPropertyAggregates</a> API.</p> <p>To identify an asset property, you must specify one of the following:</p> <ul> <li> <p>The <code>assetId</code> and <code>propertyId</code> of an asset property.</p> </li> <li> <p>A <code>propertyAlias</code>, which is a data stream alias (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). To define an asset property\'s alias, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html">UpdateAssetProperty</a>.</p> </li> </ul>', 'refs' => [ 'BatchGetAssetPropertyAggregatesEntries$member' => NULL, ], ], 'BatchGetAssetPropertyAggregatesErrorCode' => [ 'base' => NULL, 'refs' => [ 'BatchGetAssetPropertyAggregatesErrorEntry$errorCode' => '<p>The error code.</p>', 'BatchGetAssetPropertyAggregatesErrorInfo$errorCode' => '<p>The error code.</p>', ], ], 'BatchGetAssetPropertyAggregatesErrorEntries' => [ 'base' => NULL, 'refs' => [ 'BatchGetAssetPropertyAggregatesResponse$errorEntries' => '<p>A list of the errors (if any) associated with the batch request. Each error entry contains the <code>entryId</code> of the entry that failed.</p>', ], ], 'BatchGetAssetPropertyAggregatesErrorEntry' => [ 'base' => '<p>Contains error information for an asset property aggregate entry that is associated with the <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyAggregates.html">BatchGetAssetPropertyAggregates</a> API.</p>', 'refs' => [ 'BatchGetAssetPropertyAggregatesErrorEntries$member' => NULL, ], ], 'BatchGetAssetPropertyAggregatesErrorInfo' => [ 'base' => '<p>Contains the error code and the timestamp for an asset property aggregate entry that is associated with the <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyAggregates.html">BatchGetAssetPropertyAggregates</a> API.</p>', 'refs' => [ 'BatchGetAssetPropertyAggregatesSkippedEntry$errorInfo' => '<p>The error information, such as the error code and the timestamp.</p>', ], ], 'BatchGetAssetPropertyAggregatesMaxResults' => [ 'base' => NULL, 'refs' => [ 'BatchGetAssetPropertyAggregatesRequest$maxResults' => '<p>The maximum number of results to return for each paginated request. A result set is returned in the two cases, whichever occurs first.</p> <ul> <li> <p>The size of the result set is equal to 1 MB.</p> </li> <li> <p>The number of data points in the result set is equal to the value of <code>maxResults</code>. The maximum value of <code>maxResults</code> is 4000.</p> </li> </ul>', ], ], 'BatchGetAssetPropertyAggregatesRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetAssetPropertyAggregatesResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetAssetPropertyAggregatesSkippedEntries' => [ 'base' => NULL, 'refs' => [ 'BatchGetAssetPropertyAggregatesResponse$skippedEntries' => '<p>A list of entries that were not processed by this batch request. because these entries had been completely processed by previous paginated requests. Each skipped entry contains the <code>entryId</code> of the entry that skipped.</p>', ], ], 'BatchGetAssetPropertyAggregatesSkippedEntry' => [ 'base' => '<p>Contains information for an entry that has been processed by the previous <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyAggregates.html">BatchGetAssetPropertyAggregates</a> request.</p>', 'refs' => [ 'BatchGetAssetPropertyAggregatesSkippedEntries$member' => NULL, ], ], 'BatchGetAssetPropertyAggregatesSuccessEntries' => [ 'base' => NULL, 'refs' => [ 'BatchGetAssetPropertyAggregatesResponse$successEntries' => '<p>A list of entries that were processed successfully by this batch request. Each success entry contains the <code>entryId</code> of the entry that succeeded and the latest query result.</p>', ], ], 'BatchGetAssetPropertyAggregatesSuccessEntry' => [ 'base' => '<p>Contains success information for an entry that is associated with the <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyAggregates.html">BatchGetAssetPropertyAggregates</a> API.</p>', 'refs' => [ 'BatchGetAssetPropertyAggregatesSuccessEntries$member' => NULL, ], ], 'BatchGetAssetPropertyValueEntries' => [ 'base' => NULL, 'refs' => [ 'BatchGetAssetPropertyValueRequest$entries' => '<p>The list of asset property value entries for the batch get request. You can specify up to 128 entries per request.</p>', ], ], 'BatchGetAssetPropertyValueEntry' => [ 'base' => '<p>Contains information for an asset property value entry that is associated with the <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyValue.html">BatchGetAssetPropertyValue</a> API.</p> <p>To identify an asset property, you must specify one of the following:</p> <ul> <li> <p>The <code>assetId</code> and <code>propertyId</code> of an asset property.</p> </li> <li> <p>A <code>propertyAlias</code>, which is a data stream alias (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). To define an asset property\'s alias, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html">UpdateAssetProperty</a>.</p> </li> </ul>', 'refs' => [ 'BatchGetAssetPropertyValueEntries$member' => NULL, ], ], 'BatchGetAssetPropertyValueErrorCode' => [ 'base' => NULL, 'refs' => [ 'BatchGetAssetPropertyValueErrorEntry$errorCode' => '<p>The error code.</p>', 'BatchGetAssetPropertyValueErrorInfo$errorCode' => '<p>The error code.</p>', ], ], 'BatchGetAssetPropertyValueErrorEntries' => [ 'base' => NULL, 'refs' => [ 'BatchGetAssetPropertyValueResponse$errorEntries' => '<p>A list of the errors (if any) associated with the batch request. Each error entry contains the <code>entryId</code> of the entry that failed.</p>', ], ], 'BatchGetAssetPropertyValueErrorEntry' => [ 'base' => '<p>Contains error information for an asset property value entry that is associated with the <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyValue.html">BatchGetAssetPropertyValue</a> API.</p>', 'refs' => [ 'BatchGetAssetPropertyValueErrorEntries$member' => NULL, ], ], 'BatchGetAssetPropertyValueErrorInfo' => [ 'base' => '<p>The error information, such as the error code and the timestamp.</p>', 'refs' => [ 'BatchGetAssetPropertyValueSkippedEntry$errorInfo' => '<p>The error information, such as the error code and the timestamp.</p>', ], ], 'BatchGetAssetPropertyValueHistoryEntries' => [ 'base' => NULL, 'refs' => [ 'BatchGetAssetPropertyValueHistoryRequest$entries' => '<p>The list of asset property historical value entries for the batch get request. You can specify up to 16 entries per request.</p>', ], ], 'BatchGetAssetPropertyValueHistoryEntry' => [ 'base' => '<p>Contains information for an asset property historical value entry that is associated with the <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyValue.html">BatchGetAssetPropertyValueHistory</a> API.</p> <p>To identify an asset property, you must specify one of the following:</p> <ul> <li> <p>The <code>assetId</code> and <code>propertyId</code> of an asset property.</p> </li> <li> <p>A <code>propertyAlias</code>, which is a data stream alias (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). To define an asset property\'s alias, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html">UpdateAssetProperty</a>.</p> </li> </ul>', 'refs' => [ 'BatchGetAssetPropertyValueHistoryEntries$member' => NULL, ], ], 'BatchGetAssetPropertyValueHistoryErrorCode' => [ 'base' => NULL, 'refs' => [ 'BatchGetAssetPropertyValueHistoryErrorEntry$errorCode' => '<p>The error code.</p>', 'BatchGetAssetPropertyValueHistoryErrorInfo$errorCode' => '<p>The error code.</p>', ], ], 'BatchGetAssetPropertyValueHistoryErrorEntries' => [ 'base' => NULL, 'refs' => [ 'BatchGetAssetPropertyValueHistoryResponse$errorEntries' => '<p>A list of the errors (if any) associated with the batch request. Each error entry contains the <code>entryId</code> of the entry that failed.</p>', ], ], 'BatchGetAssetPropertyValueHistoryErrorEntry' => [ 'base' => '<p>A list of the errors (if any) associated with the batch request. Each error entry contains the <code>entryId</code> of the entry that failed.</p>', 'refs' => [ 'BatchGetAssetPropertyValueHistoryErrorEntries$member' => NULL, ], ], 'BatchGetAssetPropertyValueHistoryErrorInfo' => [ 'base' => '<p>The error information, such as the error code and the timestamp.</p>', 'refs' => [ 'BatchGetAssetPropertyValueHistorySkippedEntry$errorInfo' => '<p>The error information, such as the error code and the timestamp.</p>', ], ], 'BatchGetAssetPropertyValueHistoryMaxResults' => [ 'base' => NULL, 'refs' => [ 'BatchGetAssetPropertyValueHistoryRequest$maxResults' => '<p>The maximum number of results to return for each paginated request. A result set is returned in the two cases, whichever occurs first.</p> <ul> <li> <p>The size of the result set is equal to 4 MB.</p> </li> <li> <p>The number of data points in the result set is equal to the value of <code>maxResults</code>. The maximum value of <code>maxResults</code> is 20000.</p> </li> </ul>', ], ], 'BatchGetAssetPropertyValueHistoryRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetAssetPropertyValueHistoryResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetAssetPropertyValueHistorySkippedEntries' => [ 'base' => NULL, 'refs' => [ 'BatchGetAssetPropertyValueHistoryResponse$skippedEntries' => '<p>A list of entries that were not processed by this batch request. because these entries had been completely processed by previous paginated requests. Each skipped entry contains the <code>entryId</code> of the entry that skipped.</p>', ], ], 'BatchGetAssetPropertyValueHistorySkippedEntry' => [ 'base' => '<p>Contains information for an entry that has been processed by the previous <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyValue.html">BatchGetAssetPropertyValueHistory</a> request.</p>', 'refs' => [ 'BatchGetAssetPropertyValueHistorySkippedEntries$member' => NULL, ], ], 'BatchGetAssetPropertyValueHistorySuccessEntries' => [ 'base' => NULL, 'refs' => [ 'BatchGetAssetPropertyValueHistoryResponse$successEntries' => '<p>A list of entries that were processed successfully by this batch request. Each success entry contains the <code>entryId</code> of the entry that succeeded and the latest query result.</p>', ], ], 'BatchGetAssetPropertyValueHistorySuccessEntry' => [ 'base' => '<p>Contains success information for an entry that is associated with the <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyValue.html">BatchGetAssetPropertyValueHistory</a> API.</p>', 'refs' => [ 'BatchGetAssetPropertyValueHistorySuccessEntries$member' => NULL, ], ], 'BatchGetAssetPropertyValueRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetAssetPropertyValueResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetAssetPropertyValueSkippedEntries' => [ 'base' => NULL, 'refs' => [ 'BatchGetAssetPropertyValueResponse$skippedEntries' => '<p>A list of entries that were not processed by this batch request. because these entries had been completely processed by previous paginated requests. Each skipped entry contains the <code>entryId</code> of the entry that skipped.</p>', ], ], 'BatchGetAssetPropertyValueSkippedEntry' => [ 'base' => '<p>Contains information for an entry that has been processed by the previous <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyValue.html">BatchGetAssetPropertyValue</a> request.</p>', 'refs' => [ 'BatchGetAssetPropertyValueSkippedEntries$member' => NULL, ], ], 'BatchGetAssetPropertyValueSuccessEntries' => [ 'base' => NULL, 'refs' => [ 'BatchGetAssetPropertyValueResponse$successEntries' => '<p>A list of entries that were processed successfully by this batch request. Each success entry contains the <code>entryId</code> of the entry that succeeded and the latest query result.</p>', ], ], 'BatchGetAssetPropertyValueSuccessEntry' => [ 'base' => '<p>Contains success information for an entry that is associated with the <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyValue.html">BatchGetAssetPropertyValue</a> API.</p>', 'refs' => [ 'BatchGetAssetPropertyValueSuccessEntries$member' => NULL, ], ], 'BatchPutAssetPropertyError' => [ 'base' => '<p>Contains error information from updating a batch of asset property values.</p>', 'refs' => [ 'BatchPutAssetPropertyErrors$member' => NULL, ], ], 'BatchPutAssetPropertyErrorEntries' => [ 'base' => NULL, 'refs' => [ 'BatchPutAssetPropertyValueResponse$errorEntries' => '<p>A list of the errors (if any) associated with the batch put request. Each error entry contains the <code>entryId</code> of the entry that failed.</p>', ], ], 'BatchPutAssetPropertyErrorEntry' => [ 'base' => '<p>Contains error information for asset property value entries that are associated with the <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchPutAssetPropertyValue.html">BatchPutAssetPropertyValue</a> API.</p>', 'refs' => [ 'BatchPutAssetPropertyErrorEntries$member' => NULL, ], ], 'BatchPutAssetPropertyErrors' => [ 'base' => NULL, 'refs' => [ 'BatchPutAssetPropertyErrorEntry$errors' => '<p>The list of update property value errors.</p>', ], ], 'BatchPutAssetPropertyValueErrorCode' => [ 'base' => NULL, 'refs' => [ 'BatchPutAssetPropertyError$errorCode' => '<p>The error code.</p>', ], ], 'BatchPutAssetPropertyValueRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchPutAssetPropertyValueResponse' => [ 'base' => NULL, 'refs' => [], ], 'Bucket' => [ 'base' => NULL, 'refs' => [ 'ErrorReportLocation$bucket' => '<p>The name of the Amazon S3 bucket to which errors associated with the bulk import job are sent.</p>', 'File$bucket' => '<p>The name of the Amazon S3 bucket from which data is imported.</p>', ], ], 'CapabilityConfiguration' => [ 'base' => NULL, 'refs' => [ 'DescribeGatewayCapabilityConfigurationResponse$capabilityConfiguration' => '<p>The JSON document that defines the gateway capability\'s configuration. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/configure-sources.html#configure-source-cli">Configuring data sources (CLI)</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'UpdateGatewayCapabilityConfigurationRequest$capabilityConfiguration' => '<p>The JSON document that defines the configuration for the gateway capability. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/configure-sources.html#configure-source-cli">Configuring data sources (CLI)</a> in the <i>IoT SiteWise User Guide</i>.</p>', ], ], 'CapabilityNamespace' => [ 'base' => NULL, 'refs' => [ 'DescribeGatewayCapabilityConfigurationRequest$capabilityNamespace' => '<p>The namespace of the capability configuration. For example, if you configure OPC-UA sources from the IoT SiteWise console, your OPC-UA capability configuration has the namespace <code>iotsitewise:opcuacollector:version</code>, where <code>version</code> is a number such as <code>1</code>.</p>', 'DescribeGatewayCapabilityConfigurationResponse$capabilityNamespace' => '<p>The namespace of the gateway capability.</p>', 'GatewayCapabilitySummary$capabilityNamespace' => '<p>The namespace of the capability configuration. For example, if you configure OPC-UA sources from the IoT SiteWise console, your OPC-UA capability configuration has the namespace <code>iotsitewise:opcuacollector:version</code>, where <code>version</code> is a number such as <code>1</code>.</p>', 'UpdateGatewayCapabilityConfigurationRequest$capabilityNamespace' => '<p>The namespace of the gateway capability configuration to be updated. For example, if you configure OPC-UA sources from the IoT SiteWise console, your OPC-UA capability configuration has the namespace <code>iotsitewise:opcuacollector:version</code>, where <code>version</code> is a number such as <code>1</code>.</p>', 'UpdateGatewayCapabilityConfigurationResponse$capabilityNamespace' => '<p>The namespace of the gateway capability.</p>', ], ], 'CapabilitySyncStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeGatewayCapabilityConfigurationResponse$capabilitySyncStatus' => '<p>The synchronization status of the capability configuration. The sync status can be one of the following:</p> <ul> <li> <p> <code>IN_SYNC</code> – The gateway is running the capability configuration.</p> </li> <li> <p> <code>OUT_OF_SYNC</code> – The gateway hasn\'t received the capability configuration.</p> </li> <li> <p> <code>SYNC_FAILED</code> – The gateway rejected the capability configuration.</p> </li> </ul>', 'GatewayCapabilitySummary$capabilitySyncStatus' => '<p>The synchronization status of the capability configuration. The sync status can be one of the following:</p> <ul> <li> <p> <code>IN_SYNC</code> – The gateway is running the capability configuration.</p> </li> <li> <p> <code>OUT_OF_SYNC</code> – The gateway hasn\'t received the capability configuration.</p> </li> <li> <p> <code>SYNC_FAILED</code> – The gateway rejected the capability configuration.</p> </li> </ul>', 'UpdateGatewayCapabilityConfigurationResponse$capabilitySyncStatus' => '<p>The synchronization status of the capability configuration. The sync status can be one of the following:</p> <ul> <li> <p> <code>IN_SYNC</code> – The gateway is running the capability configuration.</p> </li> <li> <p> <code>OUT_OF_SYNC</code> – The gateway hasn\'t received the capability configuration.</p> </li> <li> <p> <code>SYNC_FAILED</code> – The gateway rejected the capability configuration.</p> </li> </ul> <p>After you update a capability configuration, its sync status is <code>OUT_OF_SYNC</code> until the gateway receives and applies or rejects the updated configuration.</p>', ], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'AssociateAssetsRequest$clientToken' => '<p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don\'t reuse this client token if a new idempotent request is required.</p>', 'AssociateTimeSeriesToAssetPropertyRequest$clientToken' => '<p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don\'t reuse this client token if a new idempotent request is required.</p>', 'BatchAssociateProjectAssetsRequest$clientToken' => '<p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don\'t reuse this client token if a new idempotent request is required.</p>', 'BatchDisassociateProjectAssetsRequest$clientToken' => '<p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don\'t reuse this client token if a new idempotent request is required.</p>', 'CreateAccessPolicyRequest$clientToken' => '<p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don\'t reuse this client token if a new idempotent request is required.</p>', 'CreateAssetModelCompositeModelRequest$clientToken' => '<p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don\'t reuse this client token if a new idempotent request is required.</p>', 'CreateAssetModelRequest$clientToken' => '<p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don\'t reuse this client token if a new idempotent request is required.</p>', 'CreateAssetRequest$clientToken' => '<p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don\'t reuse this client token if a new idempotent request is required.</p>', 'CreateDashboardRequest$clientToken' => '<p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don\'t reuse this client token if a new idempotent request is required.</p>', 'CreatePortalRequest$clientToken' => '<p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don\'t reuse this client token if a new idempotent request is required.</p>', 'CreateProjectRequest$clientToken' => '<p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don\'t reuse this client token if a new idempotent request is required.</p>', 'DeleteAccessPolicyRequest$clientToken' => '<p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don\'t reuse this client token if a new idempotent request is required.</p>', 'DeleteAssetModelCompositeModelRequest$clientToken' => '<p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don\'t reuse this client token if a new idempotent request is required.</p>', 'DeleteAssetModelRequest$clientToken' => '<p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don\'t reuse this client token if a new idempotent request is required.</p>', 'DeleteAssetRequest$clientToken' => '<p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don\'t reuse this client token if a new idempotent request is required.</p>', 'DeleteDashboardRequest$clientToken' => '<p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don\'t reuse this client token if a new idempotent request is required.</p>', 'DeletePortalRequest$clientToken' => '<p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don\'t reuse this client token if a new idempotent request is required.</p>', 'DeleteProjectRequest$clientToken' => '<p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don\'t reuse this client token if a new idempotent request is required.</p>', 'DeleteTimeSeriesRequest$clientToken' => '<p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don\'t reuse this client token if a new idempotent request is required.</p>', 'DisassociateAssetsRequest$clientToken' => '<p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don\'t reuse this client token if a new idempotent request is required.</p>', 'DisassociateTimeSeriesFromAssetPropertyRequest$clientToken' => '<p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don\'t reuse this client token if a new idempotent request is required.</p>', 'ExecuteActionRequest$clientToken' => '<p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don\'t reuse this client token if a new idempotent request is required.</p>', 'UpdateAccessPolicyRequest$clientToken' => '<p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don\'t reuse this client token if a new idempotent request is required.</p>', 'UpdateAssetModelCompositeModelRequest$clientToken' => '<p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don\'t reuse this client token if a new idempotent request is required.</p>', 'UpdateAssetModelRequest$clientToken' => '<p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don\'t reuse this client token if a new idempotent request is required.</p>', 'UpdateAssetPropertyRequest$clientToken' => '<p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don\'t reuse this client token if a new idempotent request is required.</p>', 'UpdateAssetRequest$clientToken' => '<p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don\'t reuse this client token if a new idempotent request is required.</p>', 'UpdateDashboardRequest$clientToken' => '<p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don\'t reuse this client token if a new idempotent request is required.</p>', 'UpdatePortalRequest$clientToken' => '<p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don\'t reuse this client token if a new idempotent request is required.</p>', 'UpdateProjectRequest$clientToken' => '<p>A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don\'t reuse this client token if a new idempotent request is required.</p>', ], ], 'ColumnInfo' => [ 'base' => '<p>A description of the column in the query results.</p>', 'refs' => [ 'ColumnsList$member' => NULL, ], ], 'ColumnName' => [ 'base' => NULL, 'refs' => [ 'ColumnNames$member' => NULL, ], ], 'ColumnNames' => [ 'base' => NULL, 'refs' => [ 'Csv$columnNames' => '<p>The column names specified in the .csv file.</p>', ], ], 'ColumnType' => [ 'base' => '<p>The data type of the column.</p>', 'refs' => [ 'ColumnInfo$type' => '<p>The type of the column description.</p>', ], ], 'ColumnsList' => [ 'base' => NULL, 'refs' => [ 'ExecuteQueryResponse$columns' => '<p>Represents a single column in the query results.</p>', ], ], 'CompositeModelProperty' => [ 'base' => '<p>Contains information about a composite model property on an asset.</p>', 'refs' => [ 'DescribeAssetPropertyResponse$compositeModel' => '<p>The composite model that declares this asset property, if this asset property exists in a composite model.</p>', ], ], 'CompositionDetails' => [ 'base' => '<p>Metadata for the composition relationship established by using <code>composedAssetModelId</code> in <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModelCompositeModel.html"> <code>CreateAssetModelCompositeModel</code> </a>.</p>', 'refs' => [ 'DescribeAssetModelCompositeModelResponse$compositionDetails' => '<p>Metadata for the composition relationship established by using <code>composedAssetModelId</code> in <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModelCompositeModel.html"> <code>CreateAssetModelCompositeModel</code> </a>. For instance, an array detailing the path of the composition relationship for this composite model.</p>', ], ], 'CompositionRelationship' => [ 'base' => NULL, 'refs' => [ 'CompositionDetails$compositionRelationship' => '<p>An array detailing the composition relationship for this composite model.</p>', ], ], 'CompositionRelationshipItem' => [ 'base' => '<p>Represents a composite model that composed an asset model of type <code>COMPONENT_MODEL</code>.</p>', 'refs' => [ 'CompositionRelationship$member' => NULL, ], ], 'CompositionRelationshipSummaries' => [ 'base' => NULL, 'refs' => [ 'ListCompositionRelationshipsResponse$compositionRelationshipSummaries' => '<p>A list that summarizes each composition relationship.</p>', ], ], 'CompositionRelationshipSummary' => [ 'base' => '<p>Contains a summary of the components of the composite model.</p>', 'refs' => [ 'CompositionRelationshipSummaries$member' => NULL, ], ], 'ComputeLocation' => [ 'base' => NULL, 'refs' => [ 'MetricProcessingConfig$computeLocation' => '<p>The compute location for the given metric property. </p>', 'TransformProcessingConfig$computeLocation' => '<p>The compute location for the given transform property. </p>', ], ], 'ConfigurationErrorDetails' => [ 'base' => '<p>Contains the details of an IoT SiteWise configuration error.</p>', 'refs' => [ 'ConfigurationStatus$error' => '<p>Contains associated error information, if any.</p>', ], ], 'ConfigurationState' => [ 'base' => NULL, 'refs' => [ 'ConfigurationStatus$state' => '<p>The current state of the configuration.</p>', ], ], 'ConfigurationStatus' => [ 'base' => '<p>Contains current status information for the configuration.</p>', 'refs' => [ 'DescribeDefaultEncryptionConfigurationResponse$configurationStatus' => '<p>The status of the account configuration. This contains the <code>ConfigurationState</code>. If there\'s an error, it also contains the <code>ErrorDetails</code>.</p>', 'DescribeStorageConfigurationResponse$configurationStatus' => NULL, 'PutDefaultEncryptionConfigurationResponse$configurationStatus' => '<p>The status of the account configuration. This contains the <code>ConfigurationState</code>. If there is an error, it also contains the <code>ErrorDetails</code>.</p>', 'PutStorageConfigurationResponse$configurationStatus' => NULL, ], ], 'ConflictingOperationException' => [ 'base' => '<p>Your request has conflicting operations. This can occur if you\'re trying to perform more than one operation on the same resource at the same time.</p>', 'refs' => [], ], 'CoreDeviceThingName' => [ 'base' => NULL, 'refs' => [ 'GreengrassV2$coreDeviceThingName' => '<p>The name of the IoT thing for your IoT Greengrass V2 core device.</p>', ], ], 'CreateAccessPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAccessPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateAssetModelCompositeModelRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAssetModelCompositeModelResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateAssetModelRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAssetModelResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateAssetRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAssetResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateBulkImportJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateBulkImportJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateDashboardRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDashboardResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateGatewayRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateGatewayResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreatePortalRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreatePortalResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateProjectRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateProjectResponse' => [ 'base' => NULL, 'refs' => [], ], 'Csv' => [ 'base' => '<p>A .CSV file.</p>', 'refs' => [ 'FileFormat$csv' => '<p>The file is in .CSV format.</p>', ], ], 'CustomID' => [ 'base' => NULL, 'refs' => [ 'AssetModelCompositeModel$id' => '<p> The ID of the asset model composite model. </p>', 'AssetModelHierarchy$id' => '<p>The ID of the asset model hierarchy. This ID is a <code>hierarchyId</code>.</p> <ul> <li> <p>If you are callling <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html">UpdateAssetModel</a> to create a <i>new</i> hierarchy: You can specify its ID here, if desired. IoT SiteWise automatically generates a unique ID for you, so this parameter is never required. However, if you prefer to supply your own ID instead, you can specify it here in UUID format. If you specify your own ID, it must be globally unique.</p> </li> <li> <p>If you are calling UpdateAssetModel to modify an <i>existing</i> hierarchy: This can be either the actual ID in UUID format, or else <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references">Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p> </li> </ul>', 'AssetModelHierarchy$childAssetModelId' => '<p>The ID of the asset model, in UUID format. All assets in this hierarchy must be instances of the <code>childAssetModelId</code> asset model. IoT SiteWise will always return the actual asset model ID for this value. However, when you are specifying this value as part of a call to <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html">UpdateAssetModel</a>, you may provide either the asset model ID or else <code>externalId:</code> followed by the asset model\'s external ID. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external IDs</a> in the <i>IoT SiteWise User Guide</i>. </p>', 'AssetModelHierarchyDefinition$childAssetModelId' => '<p>The ID of an asset model for this hierarchy. This can be either the actual ID in UUID format, or else <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references">Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'AssetModelProperty$id' => '<p>The ID of the asset model property.</p> <ul> <li> <p>If you are callling <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html">UpdateAssetModel</a> to create a <i>new</i> property: You can specify its ID here, if desired. IoT SiteWise automatically generates a unique ID for you, so this parameter is never required. However, if you prefer to supply your own ID instead, you can specify it here in UUID format. If you specify your own ID, it must be globally unique.</p> </li> <li> <p>If you are calling UpdateAssetModel to modify an <i>existing</i> property: This can be either the actual ID in UUID format, or else <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references">Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p> </li> </ul>', 'AssociateAssetsRequest$assetId' => '<p>The ID of the parent asset. This can be either the actual ID in UUID format, or else <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references">Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'AssociateAssetsRequest$hierarchyId' => '<p>The ID of a hierarchy in the parent asset\'s model. (This can be either the actual ID in UUID format, or else <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references">Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.) Hierarchies allow different groupings of assets to be formed that all come from the same asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'AssociateAssetsRequest$childAssetId' => '<p>The ID of the child asset to be associated. This can be either the actual ID in UUID format, or else <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references">Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'AssociateTimeSeriesToAssetPropertyRequest$assetId' => '<p>The ID of the asset in which the asset property was created. This can be either the actual ID in UUID format, or else <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references">Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'AssociateTimeSeriesToAssetPropertyRequest$propertyId' => '<p>The ID of the asset property. This can be either the actual ID in UUID format, or else <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references">Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'CreateAssetModelCompositeModelRequest$assetModelId' => '<p>The ID of the asset model this composite model is a part of.</p>', 'CreateAssetModelCompositeModelRequest$parentAssetModelCompositeModelId' => '<p>The ID of the parent composite model in this asset model relationship.</p>', 'CreateAssetModelCompositeModelRequest$composedAssetModelId' => '<p>The ID of a composite model on this asset.</p>', 'CreateAssetRequest$assetModelId' => '<p>The ID of the asset model from which to create the asset. This can be either the actual ID in UUID format, or else <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references">Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'DeleteAssetModelCompositeModelRequest$assetModelId' => '<p>The ID of the asset model, in UUID format.</p>', 'DeleteAssetModelCompositeModelRequest$assetModelCompositeModelId' => '<p>The ID of a composite model on this asset model.</p>', 'DeleteAssetModelRequest$assetModelId' => '<p>The ID of the asset model to delete. This can be either the actual ID in UUID format, or else <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references">Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'DeleteAssetRequest$assetId' => '<p>The ID of the asset to delete. This can be either the actual ID in UUID format, or else <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references">Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'DeleteTimeSeriesRequest$assetId' => '<p>The ID of the asset in which the asset property was created. This can be either the actual ID in UUID format, or else <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references">Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'DeleteTimeSeriesRequest$propertyId' => '<p>The ID of the asset property. This can be either the actual ID in UUID format, or else <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references">Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'DescribeAssetCompositeModelRequest$assetId' => '<p>The ID of the asset. This can be either the actual ID in UUID format, or else <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references">Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'DescribeAssetCompositeModelRequest$assetCompositeModelId' => '<p>The ID of a composite model on this asset. This can be either the actual ID in UUID format, or else <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references">Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'DescribeAssetModelCompositeModelRequest$assetModelId' => '<p>The ID of the asset model. This can be either the actual ID in UUID format, or else <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references">Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'DescribeAssetModelCompositeModelRequest$assetModelCompositeModelId' => '<p>The ID of a composite model on this asset model. This can be either the actual ID in UUID format, or else <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references">Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'DescribeAssetModelRequest$assetModelId' => '<p>The ID of the asset model. This can be either the actual ID in UUID format, or else <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references">Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'DescribeAssetPropertyRequest$assetId' => '<p>The ID of the asset. This can be either the actual ID in UUID format, or else <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references">Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'DescribeAssetPropertyRequest$propertyId' => '<p>The ID of the asset property. This can be either the actual ID in UUID format, or else <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references">Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'DescribeAssetRequest$assetId' => '<p>The ID of the asset. This can be either the actual ID in UUID format, or else <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references">Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'DescribeTimeSeriesRequest$assetId' => '<p>The ID of the asset in which the asset property was created. This can be either the actual ID in UUID format, or else <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references">Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'DescribeTimeSeriesRequest$propertyId' => '<p>The ID of the asset property. This can be either the actual ID in UUID format, or else <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references">Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'DisassociateAssetsRequest$assetId' => '<p>The ID of the parent asset from which to disassociate the child asset. This can be either the actual ID in UUID format, or else <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references">Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'DisassociateAssetsRequest$hierarchyId' => '<p>The ID of a hierarchy in the parent asset\'s model. (This can be either the actual ID in UUID format, or else <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references">Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.) Hierarchies allow different groupings of assets to be formed that all come from the same asset model. You can use the hierarchy ID to identify the correct asset to disassociate. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'DisassociateAssetsRequest$childAssetId' => '<p>The ID of the child asset to disassociate. This can be either the actual ID in UUID format, or else <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references">Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'DisassociateTimeSeriesFromAssetPropertyRequest$assetId' => '<p>The ID of the asset in which the asset property was created. This can be either the actual ID in UUID format, or else <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references">Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'DisassociateTimeSeriesFromAssetPropertyRequest$propertyId' => '<p>The ID of the asset property. This can be either the actual ID in UUID format, or else <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references">Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'ListActionsRequest$targetResourceId' => '<p>The ID of the target resource.</p>', 'ListAssetModelCompositeModelsRequest$assetModelId' => '<p>The ID of the asset model. This can be either the actual ID in UUID format, or else <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references">Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'ListAssetModelPropertiesRequest$assetModelId' => '<p>The ID of the asset model. This can be either the actual ID in UUID format, or else <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references">Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'ListAssetPropertiesRequest$assetId' => '<p>The ID of the asset. This can be either the actual ID in UUID format, or else <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references">Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'ListAssetRelationshipsRequest$assetId' => '<p>The ID of the asset. This can be either the actual ID in UUID format, or else <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references">Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'ListAssetsRequest$assetModelId' => '<p>The ID of the asset model by which to filter the list of assets. This parameter is required if you choose <code>ALL</code> for <code>filter</code>. This can be either the actual ID in UUID format, or else <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references">Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'ListAssociatedAssetsRequest$assetId' => '<p>The ID of the asset to query. This can be either the actual ID in UUID format, or else <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references">Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'ListAssociatedAssetsRequest$hierarchyId' => '<p>The ID of the hierarchy by which child assets are associated to the asset. (This can be either the actual ID in UUID format, or else <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references">Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.) To find a hierarchy ID, use the <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAsset.html">DescribeAsset</a> or <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAssetModel.html">DescribeAssetModel</a> operations. This parameter is required if you choose <code>CHILD</code> for <code>traversalDirection</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'ListTimeSeriesRequest$assetId' => '<p>The ID of the asset in which the asset property was created. This can be either the actual ID in UUID format, or else <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references">Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'TargetResource$assetId' => '<p>The ID of the asset, in UUID format.</p>', 'UpdateAssetModelCompositeModelRequest$assetModelId' => '<p>The ID of the asset model, in UUID format.</p>', 'UpdateAssetModelCompositeModelRequest$assetModelCompositeModelId' => '<p>The ID of a composite model on this asset model.</p>', 'UpdateAssetModelRequest$assetModelId' => '<p>The ID of the asset model to update. This can be either the actual ID in UUID format, or else <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references">Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'UpdateAssetPropertyRequest$assetId' => '<p>The ID of the asset to be updated. This can be either the actual ID in UUID format, or else <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references">Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'UpdateAssetPropertyRequest$propertyId' => '<p>The ID of the asset property to be updated. This can be either the actual ID in UUID format, or else <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references">Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'UpdateAssetRequest$assetId' => '<p>The ID of the asset to update. This can be either the actual ID in UUID format, or else <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references">Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>', ], ], 'CustomerManagedS3Storage' => [ 'base' => '<p>Contains information about a customer managed Amazon S3 bucket.</p>', 'refs' => [ 'MultiLayerStorage$customerManagedS3Storage' => '<p>Contains information about a customer managed Amazon S3 bucket.</p>', ], ], 'DashboardDefinition' => [ 'base' => NULL, 'refs' => [ 'CreateDashboardRequest$dashboardDefinition' => '<p>The dashboard definition specified in a JSON literal. For detailed information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-dashboards-using-aws-cli.html">Creating dashboards (CLI)</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'DescribeDashboardResponse$dashboardDefinition' => '<p>The dashboard\'s definition JSON literal. For detailed information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-dashboards-using-aws-cli.html">Creating dashboards (CLI)</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'UpdateDashboardRequest$dashboardDefinition' => '<p>The new dashboard definition, as specified in a JSON literal. For detailed information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-dashboards-using-aws-cli.html">Creating dashboards (CLI)</a> in the <i>IoT SiteWise User Guide</i>.</p>', ], ], 'DashboardSummaries' => [ 'base' => NULL, 'refs' => [ 'ListDashboardsResponse$dashboardSummaries' => '<p>A list that summarizes each dashboard in the project.</p>', ], ], 'DashboardSummary' => [ 'base' => '<p>Contains a dashboard summary.</p>', 'refs' => [ 'DashboardSummaries$member' => NULL, ], ], 'Datum' => [ 'base' => '<p>Represents a single data point in a query result. </p>', 'refs' => [ 'DatumList$member' => NULL, ], ], 'DatumList' => [ 'base' => NULL, 'refs' => [ 'Datum$arrayValue' => '<p>Indicates if the data point is an array. </p>', 'Row$data' => '<p>List of data points in a single row of the result set.</p>', ], ], 'DefaultValue' => [ 'base' => NULL, 'refs' => [ 'Attribute$defaultValue' => '<p>The default value of the asset model property attribute. All assets that you create from the asset model contain this attribute value. You can update an attribute\'s value after you create an asset. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/update-attribute-values.html">Updating attribute values</a> in the <i>IoT SiteWise User Guide</i>.</p>', ], ], 'DeleteAccessPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAccessPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAssetModelCompositeModelRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAssetModelCompositeModelResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAssetModelRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAssetModelResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAssetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAssetResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDashboardRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDashboardResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFilesAfterImport' => [ 'base' => NULL, 'refs' => [ 'CreateBulkImportJobRequest$deleteFilesAfterImport' => '<p>If set to true, your data files is deleted from S3, after ingestion into IoT SiteWise storage.</p>', 'DescribeBulkImportJobResponse$deleteFilesAfterImport' => '<p>If set to true, your data files is deleted from S3, after ingestion into IoT SiteWise storage.</p>', ], ], 'DeleteGatewayRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletePortalRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletePortalResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteProjectRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteProjectResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTimeSeriesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccessPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccessPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeActionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeActionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAssetCompositeModelRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAssetCompositeModelResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAssetModelCompositeModelRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAssetModelCompositeModelResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAssetModelRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAssetModelResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAssetPropertyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAssetPropertyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAssetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAssetResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeBulkImportJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeBulkImportJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDashboardRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDashboardResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDefaultEncryptionConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDefaultEncryptionConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeGatewayCapabilityConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeGatewayCapabilityConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeGatewayRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeGatewayResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLoggingOptionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLoggingOptionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribePortalRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribePortalResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeProjectRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeProjectResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStorageConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStorageConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTimeSeriesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTimeSeriesResponse' => [ 'base' => NULL, 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'AssetCompositeModel$description' => '<p>The description of the composite model.</p>', 'AssetCompositeModelSummary$description' => '<p>A description of the composite model that this summary describes.</p>', 'AssetModelCompositeModel$description' => '<p>The description of the composite model.</p>', 'AssetModelCompositeModelDefinition$description' => '<p>The description of the composite model.</p>', 'AssetModelCompositeModelSummary$description' => '<p>The description of the the composite model that this summary describes..</p>', 'AssetModelSummary$description' => '<p>The asset model description.</p>', 'AssetSummary$description' => '<p>A description for the asset.</p>', 'AssociatedAssetsSummary$description' => '<p>A description for the asset.</p>', 'CreateAssetModelCompositeModelRequest$assetModelCompositeModelDescription' => '<p>A description for the composite model.</p>', 'CreateAssetModelRequest$assetModelDescription' => '<p>A description for the asset model.</p>', 'CreateAssetRequest$assetDescription' => '<p>A description for the asset.</p>', 'CreateDashboardRequest$dashboardDescription' => '<p>A description for the dashboard.</p>', 'CreatePortalRequest$portalDescription' => '<p>A description for the portal.</p>', 'CreateProjectRequest$projectDescription' => '<p>A description for the project.</p>', 'DashboardSummary$description' => '<p>The dashboard\'s description.</p>', 'DescribeAssetCompositeModelResponse$assetCompositeModelDescription' => '<p>A description for the composite model.</p>', 'DescribeAssetModelCompositeModelResponse$assetModelCompositeModelDescription' => '<p>The description for the composite model.</p>', 'DescribeAssetModelResponse$assetModelDescription' => '<p>The asset model\'s description.</p>', 'DescribeAssetResponse$assetDescription' => '<p>A description for the asset.</p>', 'DescribeDashboardResponse$dashboardDescription' => '<p>The dashboard\'s description.</p>', 'DescribePortalResponse$portalDescription' => '<p>The portal\'s description.</p>', 'DescribeProjectResponse$projectDescription' => '<p>The project\'s description.</p>', 'PortalSummary$description' => '<p>The portal\'s description.</p>', 'ProjectSummary$description' => '<p>The project\'s description.</p>', 'UpdateAssetModelCompositeModelRequest$assetModelCompositeModelDescription' => '<p>A description for the composite model.</p>', 'UpdateAssetModelRequest$assetModelDescription' => '<p>A description for the asset model.</p>', 'UpdateAssetRequest$assetDescription' => '<p>A description for the asset.</p>', 'UpdateDashboardRequest$dashboardDescription' => '<p>A new description for the dashboard.</p>', 'UpdatePortalRequest$portalDescription' => '<p>A new description for the portal.</p>', 'UpdateProjectRequest$projectDescription' => '<p>A new description for the project.</p>', ], ], 'DetailedError' => [ 'base' => '<p>Contains detailed error information. </p>', 'refs' => [ 'DetailedErrors$member' => NULL, ], ], 'DetailedErrorCode' => [ 'base' => NULL, 'refs' => [ 'DetailedError$code' => '<p>The error code. </p>', ], ], 'DetailedErrorMessage' => [ 'base' => NULL, 'refs' => [ 'DetailedError$message' => '<p>The error message. </p>', ], ], 'DetailedErrors' => [ 'base' => NULL, 'refs' => [ 'ErrorDetails$details' => '<p> A list of detailed errors. </p>', ], ], 'DisassociateAssetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateTimeSeriesFromAssetPropertyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociatedDataStorageState' => [ 'base' => NULL, 'refs' => [ 'DescribeStorageConfigurationResponse$disassociatedDataStorage' => '<p>Contains the storage configuration for time series (data streams) that aren\'t associated with asset properties. The <code>disassociatedDataStorage</code> can be one of the following values:</p> <ul> <li> <p> <code>ENABLED</code> – IoT SiteWise accepts time series that aren\'t associated with asset properties.</p> <important> <p>After the <code>disassociatedDataStorage</code> is enabled, you can\'t disable it.</p> </important> </li> <li> <p> <code>DISABLED</code> – IoT SiteWise doesn\'t accept time series (data streams) that aren\'t associated with asset properties.</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/data-streams.html">Data streams</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'PutStorageConfigurationRequest$disassociatedDataStorage' => '<p>Contains the storage configuration for time series (data streams) that aren\'t associated with asset properties. The <code>disassociatedDataStorage</code> can be one of the following values:</p> <ul> <li> <p> <code>ENABLED</code> – IoT SiteWise accepts time series that aren\'t associated with asset properties.</p> <important> <p>After the <code>disassociatedDataStorage</code> is enabled, you can\'t disable it.</p> </important> </li> <li> <p> <code>DISABLED</code> – IoT SiteWise doesn\'t accept time series (data streams) that aren\'t associated with asset properties.</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/data-streams.html">Data streams</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'PutStorageConfigurationResponse$disassociatedDataStorage' => '<p>Contains the storage configuration for time series (data streams) that aren\'t associated with asset properties. The <code>disassociatedDataStorage</code> can be one of the following values:</p> <ul> <li> <p> <code>ENABLED</code> – IoT SiteWise accepts time series that aren\'t associated with asset properties.</p> <important> <p>After the <code>disassociatedDataStorage</code> is enabled, you can\'t disable it.</p> </important> </li> <li> <p> <code>DISABLED</code> – IoT SiteWise doesn\'t accept time series (data streams) that aren\'t associated with asset properties.</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/data-streams.html">Data streams</a> in the <i>IoT SiteWise User Guide</i>.</p>', ], ], 'Email' => [ 'base' => NULL, 'refs' => [ 'CreatePortalRequest$portalContactEmail' => '<p>The Amazon Web Services administrator\'s contact email address.</p>', 'CreatePortalRequest$notificationSenderEmail' => '<p>The email address that sends alarm notifications.</p> <important> <p>If you use the <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/lambda-support.html">IoT Events managed Lambda function</a> to manage your emails, you must <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-email-addresses.html">verify the sender email address in Amazon SES</a>.</p> </important>', 'DescribePortalResponse$portalContactEmail' => '<p>The Amazon Web Services administrator\'s contact email address.</p>', 'DescribePortalResponse$notificationSenderEmail' => '<p>The email address that sends alarm notifications.</p>', 'UpdatePortalRequest$portalContactEmail' => '<p>The Amazon Web Services administrator\'s contact email address.</p>', 'UpdatePortalRequest$notificationSenderEmail' => '<p>The email address that sends alarm notifications.</p>', ], ], 'EncryptionType' => [ 'base' => NULL, 'refs' => [ 'DescribeDefaultEncryptionConfigurationResponse$encryptionType' => '<p>The type of encryption used for the encryption configuration.</p>', 'PutDefaultEncryptionConfigurationRequest$encryptionType' => '<p>The type of encryption used for the encryption configuration.</p>', 'PutDefaultEncryptionConfigurationResponse$encryptionType' => '<p>The type of encryption used for the encryption configuration.</p>', ], ], 'EntryId' => [ 'base' => NULL, 'refs' => [ 'BatchGetAssetPropertyAggregatesEntry$entryId' => '<p>The ID of the entry.</p>', 'BatchGetAssetPropertyAggregatesErrorEntry$entryId' => '<p>The ID of the entry.</p>', 'BatchGetAssetPropertyAggregatesSkippedEntry$entryId' => '<p>The ID of the entry.</p>', 'BatchGetAssetPropertyAggregatesSuccessEntry$entryId' => '<p>The ID of the entry.</p>', 'BatchGetAssetPropertyValueEntry$entryId' => '<p>The ID of the entry.</p>', 'BatchGetAssetPropertyValueErrorEntry$entryId' => '<p>The ID of the entry.</p>', 'BatchGetAssetPropertyValueHistoryEntry$entryId' => '<p>The ID of the entry.</p>', 'BatchGetAssetPropertyValueHistoryErrorEntry$entryId' => '<p>The ID of the entry.</p>', 'BatchGetAssetPropertyValueHistorySkippedEntry$entryId' => '<p>The ID of the entry.</p>', 'BatchGetAssetPropertyValueHistorySuccessEntry$entryId' => '<p>The ID of the entry.</p>', 'BatchGetAssetPropertyValueSkippedEntry$entryId' => '<p>The ID of the entry.</p>', 'BatchGetAssetPropertyValueSuccessEntry$entryId' => '<p>The ID of the entry.</p>', 'BatchPutAssetPropertyErrorEntry$entryId' => '<p>The ID of the failed entry.</p>', 'PutAssetPropertyValueEntry$entryId' => '<p>The user specified ID for the entry. You can use this ID to identify which entries failed.</p>', ], ], 'ErrorCode' => [ 'base' => NULL, 'refs' => [ 'ConfigurationErrorDetails$code' => '<p>The error code.</p>', 'ErrorDetails$code' => '<p>The error code.</p>', ], ], 'ErrorDetails' => [ 'base' => '<p>Contains the details of an IoT SiteWise error.</p>', 'refs' => [ 'AssetModelStatus$error' => '<p>Contains associated error information, if any.</p>', 'AssetStatus$error' => '<p>Contains associated error information, if any.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'BatchGetAssetPropertyAggregatesErrorEntry$errorMessage' => '<p>The associated error message.</p>', 'BatchGetAssetPropertyValueErrorEntry$errorMessage' => '<p>The associated error message.</p>', 'BatchGetAssetPropertyValueHistoryErrorEntry$errorMessage' => '<p>The associated error message.</p>', 'BatchPutAssetPropertyError$errorMessage' => '<p>The associated error message.</p>', 'ConfigurationErrorDetails$message' => '<p>The error message.</p>', 'ConflictingOperationException$message' => NULL, 'ErrorDetails$message' => '<p>The error message.</p>', 'InternalFailureException$message' => NULL, 'InvalidRequestException$message' => NULL, 'LimitExceededException$message' => NULL, 'ResourceAlreadyExistsException$message' => NULL, 'ResourceNotFoundException$message' => NULL, 'ServiceUnavailableException$message' => NULL, 'ThrottlingException$message' => NULL, 'UnauthorizedException$message' => NULL, ], ], 'ErrorReportLocation' => [ 'base' => '<p>The Amazon S3 destination where errors associated with the job creation request are saved.</p>', 'refs' => [ 'CreateBulkImportJobRequest$errorReportLocation' => '<p>The Amazon S3 destination where errors associated with the job creation request are saved.</p>', 'DescribeBulkImportJobResponse$errorReportLocation' => '<p>The Amazon S3 destination where errors associated with the job creation request are saved.</p>', ], ], 'ExceptionMessage' => [ 'base' => NULL, 'refs' => [ 'TooManyTagsException$message' => NULL, ], ], 'ExcludeProperties' => [ 'base' => NULL, 'refs' => [ 'DescribeAssetModelRequest$excludeProperties' => '<p> Whether or not to exclude asset model properties from the response. </p>', 'DescribeAssetRequest$excludeProperties' => '<p> Whether or not to exclude asset properties from the response. </p>', ], ], 'ExecuteActionRequest' => [ 'base' => NULL, 'refs' => [], ], 'ExecuteActionResponse' => [ 'base' => NULL, 'refs' => [], ], 'ExecuteQueryMaxResults' => [ 'base' => NULL, 'refs' => [ 'ExecuteQueryRequest$maxResults' => '<p>The maximum number of results to return at one time. The default is 25.</p>', ], ], 'ExecuteQueryNextToken' => [ 'base' => NULL, 'refs' => [ 'ExecuteQueryRequest$nextToken' => '<p>The string that specifies the next page of results.</p>', 'ExecuteQueryResponse$nextToken' => '<p>The string that specifies the next page of results.</p>', ], ], 'ExecuteQueryRequest' => [ 'base' => NULL, 'refs' => [], ], 'ExecuteQueryResponse' => [ 'base' => NULL, 'refs' => [], ], 'Expression' => [ 'base' => NULL, 'refs' => [ 'Metric$expression' => '<p>The mathematical expression that defines the metric aggregation function. You can specify up to 10 variables per expression. You can specify up to 10 functions per expression. </p> <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'Transform$expression' => '<p>The mathematical expression that defines the transformation function. You can specify up to 10 variables per expression. You can specify up to 10 functions per expression. </p> <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>', ], ], 'ExpressionVariable' => [ 'base' => '<p>Contains expression variable information.</p>', 'refs' => [ 'ExpressionVariables$member' => NULL, ], ], 'ExpressionVariables' => [ 'base' => NULL, 'refs' => [ 'Metric$variables' => '<p>The list of variables used in the expression.</p>', 'Transform$variables' => '<p>The list of variables used in the expression.</p>', ], ], 'ExternalId' => [ 'base' => NULL, 'refs' => [ 'AssetCompositeModel$externalId' => '<p>The external ID of the asset composite model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'AssetCompositeModelSummary$externalId' => '<p>An external ID to assign to the asset model.</p> <p>If the composite model is a derived composite model, or one nested inside a component model, you can only set the external ID using <code>UpdateAssetModelCompositeModel</code> and specifying the derived ID of the model or property from the created model it\'s a part of.</p>', 'AssetHierarchy$externalId' => '<p>The external ID of the hierarchy, if it has one. When you update an asset hierarchy, you may assign an external ID if it doesn\'t already have one. You can\'t change the external ID of an asset hierarchy that already has one. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'AssetModelCompositeModel$externalId' => '<p>The external ID of the asset model composite model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'AssetModelCompositeModelDefinition$externalId' => '<p>An external ID to assign to the composite model. The external ID must be unique among composite models within this asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'AssetModelCompositeModelSummary$externalId' => '<p>The external ID of a composite model on this asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'AssetModelHierarchy$externalId' => '<p>The external ID (if any) provided in the <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModel.html">CreateAssetModel</a> or <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html">UpdateAssetModel</a> operation. You can assign an external ID by specifying this value as part of a call to <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html">UpdateAssetModel</a>. However, you can\'t change the external ID if one is already assigned. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'AssetModelHierarchyDefinition$externalId' => '<p>An external ID to assign to the asset model hierarchy. The external ID must be unique among asset model hierarchies within this asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'AssetModelProperty$externalId' => '<p>The external ID (if any) provided in the <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModel.html">CreateAssetModel</a> or <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html">UpdateAssetModel</a> operation. You can assign an external ID by specifying this value as part of a call to <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html">UpdateAssetModel</a>. However, you can\'t change the external ID if one is already assigned. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'AssetModelPropertyDefinition$externalId' => '<p>An external ID to assign to the property definition. The external ID must be unique among property definitions within this asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'AssetModelPropertySummary$externalId' => '<p>The external ID of the property. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'AssetModelSummary$externalId' => '<p>The external ID of the asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'AssetProperty$externalId' => '<p>The external ID of the asset property. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'AssetPropertySummary$externalId' => '<p>The external ID of the property. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'AssetSummary$externalId' => '<p>The external ID of the asset. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'AssociatedAssetsSummary$externalId' => '<p>The external ID of the asset. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'CompositeModelProperty$externalId' => '<p>The external ID of the composite model that contains the property. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'CreateAssetModelCompositeModelRequest$assetModelCompositeModelExternalId' => '<p>An external ID to assign to the composite model.</p> <p>If the composite model is a derived composite model, or one nested inside a component model, you can only set the external ID using <code>UpdateAssetModelCompositeModel</code> and specifying the derived ID of the model or property from the created model it\'s a part of.</p>', 'CreateAssetModelRequest$assetModelExternalId' => '<p>An external ID to assign to the asset model. The external ID must be unique within your Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'CreateAssetRequest$assetExternalId' => '<p>An external ID to assign to the asset. The external ID must be unique within your Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'DescribeAssetCompositeModelResponse$assetCompositeModelExternalId' => '<p>An external ID to assign to the asset model.</p> <p>If the composite model is a component-based composite model, or one nested inside a component model, you can only set the external ID using <code>UpdateAssetModelCompositeModel</code> and specifying the derived ID of the model or property from the created model it\'s a part of.</p>', 'DescribeAssetModelCompositeModelResponse$assetModelCompositeModelExternalId' => '<p>The external ID of a composite model on this asset model.</p>', 'DescribeAssetModelResponse$assetModelExternalId' => '<p>The external ID of the asset model, if any.</p>', 'DescribeAssetPropertyResponse$assetExternalId' => '<p>The external ID of the asset. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'DescribeAssetResponse$assetExternalId' => '<p>The external ID of the asset, if any.</p>', 'Property$externalId' => '<p>The external ID of the asset property. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'UpdateAssetModelCompositeModelRequest$assetModelCompositeModelExternalId' => '<p>An external ID to assign to the asset model. You can only set the external ID of the asset model if it wasn\'t set when it was created, or you\'re setting it to the exact same thing as when it was created.</p>', 'UpdateAssetModelRequest$assetModelExternalId' => '<p>An external ID to assign to the asset model. The asset model must not already have an external ID. The external ID must be unique within your Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'UpdateAssetRequest$assetExternalId' => '<p>An external ID to assign to the asset. The asset must not already have an external ID. The external ID must be unique within your Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>', ], ], 'File' => [ 'base' => '<p>The file in Amazon S3 where your data is saved. </p>', 'refs' => [ 'Files$member' => NULL, ], ], 'FileFormat' => [ 'base' => '<p>The file format of the data in S3.</p>', 'refs' => [ 'JobConfiguration$fileFormat' => '<p>The file format of the data in S3.</p>', ], ], 'Files' => [ 'base' => NULL, 'refs' => [ 'CreateBulkImportJobRequest$files' => '<p>The files in the specified Amazon S3 bucket that contain your data.</p>', 'DescribeBulkImportJobResponse$files' => '<p>The files in the specified Amazon S3 bucket that contain your data.</p>', ], ], 'ForwardingConfig' => [ 'base' => '<p>The forwarding configuration for a given property.</p>', 'refs' => [ 'MeasurementProcessingConfig$forwardingConfig' => '<p>The forwarding configuration for the given measurement property. </p>', 'TransformProcessingConfig$forwardingConfig' => NULL, ], ], 'ForwardingConfigState' => [ 'base' => NULL, 'refs' => [ 'ForwardingConfig$state' => '<p>The forwarding state for the given property. </p>', ], ], 'GatewayCapabilitySummaries' => [ 'base' => NULL, 'refs' => [ 'DescribeGatewayResponse$gatewayCapabilitySummaries' => '<p>A list of gateway capability summaries that each contain a namespace and status. Each gateway capability defines data sources for the gateway. To retrieve a capability configuration\'s definition, use <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGatewayCapabilityConfiguration.html">DescribeGatewayCapabilityConfiguration</a>.</p>', 'GatewaySummary$gatewayCapabilitySummaries' => '<p>A list of gateway capability summaries that each contain a namespace and status. Each gateway capability defines data sources for the gateway. To retrieve a capability configuration\'s definition, use <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGatewayCapabilityConfiguration.html">DescribeGatewayCapabilityConfiguration</a>.</p>', ], ], 'GatewayCapabilitySummary' => [ 'base' => '<p>Contains a summary of a gateway capability configuration.</p>', 'refs' => [ 'GatewayCapabilitySummaries$member' => NULL, ], ], 'GatewayPlatform' => [ 'base' => '<p>Contains a gateway\'s platform information.</p>', 'refs' => [ 'CreateGatewayRequest$gatewayPlatform' => '<p>The gateway\'s platform. You can only specify one platform in a gateway.</p>', 'DescribeGatewayResponse$gatewayPlatform' => '<p>The gateway\'s platform.</p>', 'GatewaySummary$gatewayPlatform' => NULL, ], ], 'GatewaySummaries' => [ 'base' => NULL, 'refs' => [ 'ListGatewaysResponse$gatewaySummaries' => '<p>A list that summarizes each gateway.</p>', ], ], 'GatewaySummary' => [ 'base' => '<p>Contains a summary of a gateway.</p>', 'refs' => [ 'GatewaySummaries$member' => NULL, ], ], 'GetAssetPropertyAggregatesRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAssetPropertyAggregatesResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetAssetPropertyValueAggregatesMaxResults' => [ 'base' => NULL, 'refs' => [ 'GetAssetPropertyAggregatesRequest$maxResults' => '<p>The maximum number of results to return for each paginated request. A result set is returned in the two cases, whichever occurs first.</p> <ul> <li> <p>The size of the result set is equal to 1 MB.</p> </li> <li> <p>The number of data points in the result set is equal to the value of <code>maxResults</code>. The maximum value of <code>maxResults</code> is 2500.</p> </li> </ul>', ], ], 'GetAssetPropertyValueHistoryMaxResults' => [ 'base' => NULL, 'refs' => [ 'GetAssetPropertyValueHistoryRequest$maxResults' => '<p>The maximum number of results to return for each paginated request. A result set is returned in the two cases, whichever occurs first.</p> <ul> <li> <p>The size of the result set is equal to 4 MB.</p> </li> <li> <p>The number of data points in the result set is equal to the value of <code>maxResults</code>. The maximum value of <code>maxResults</code> is 20000.</p> </li> </ul>', ], ], 'GetAssetPropertyValueHistoryRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAssetPropertyValueHistoryResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetAssetPropertyValueRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAssetPropertyValueResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetInterpolatedAssetPropertyValuesRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetInterpolatedAssetPropertyValuesResponse' => [ 'base' => NULL, 'refs' => [], ], 'Greengrass' => [ 'base' => '<p>Contains details for a gateway that runs on IoT Greengrass. To create a gateway that runs on IoT Greengrass, you must add the IoT SiteWise connector to a Greengrass group and deploy it. Your Greengrass group must also have permissions to upload data to IoT SiteWise. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/gateway-connector.html">Ingesting data using a gateway</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'refs' => [ 'GatewayPlatform$greengrass' => '<p>A gateway that runs on IoT Greengrass.</p>', ], ], 'GreengrassV2' => [ 'base' => '<p>Contains details for a gateway that runs on IoT Greengrass V2. To create a gateway that runs on IoT Greengrass V2, you must deploy the IoT SiteWise Edge component to your gateway device. Your <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/device-service-role.html">Greengrass device role</a> must use the <code>AWSIoTSiteWiseEdgeAccess</code> policy. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/sw-gateways.html">Using IoT SiteWise at the edge</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'refs' => [ 'GatewayPlatform$greengrassV2' => '<p>A gateway that runs on IoT Greengrass V2.</p>', ], ], 'GroupIdentity' => [ 'base' => '<p>Contains information for a group identity in an access policy.</p>', 'refs' => [ 'Identity$group' => '<p>An IAM Identity Center group identity.</p>', ], ], 'IAMRoleIdentity' => [ 'base' => '<p>Contains information about an Identity and Access Management role. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM roles</a> in the <i>IAM User Guide</i>.</p>', 'refs' => [ 'Identity$iamRole' => '<p>An IAM role identity.</p>', ], ], 'IAMUserIdentity' => [ 'base' => '<p>Contains information about an Identity and Access Management user.</p>', 'refs' => [ 'Identity$iamUser' => '<p>An IAM user identity.</p>', ], ], 'ID' => [ 'base' => NULL, 'refs' => [ 'AccessPolicySummary$id' => '<p>The ID of the access policy.</p>', 'ActionDefinition$actionDefinitionId' => '<p>The ID of the action definition.</p>', 'ActionSummary$actionId' => '<p>The ID of the action.</p>', 'ActionSummary$actionDefinitionId' => '<p>The ID of the action definition.</p>', 'AssetCompositeModel$id' => '<p> The ID of the asset composite model. </p>', 'AssetCompositeModelPathSegment$id' => '<p>The ID of the path segment.</p>', 'AssetCompositeModelSummary$id' => '<p>The ID of the composite model that this summary describes.</p>', 'AssetErrorDetails$assetId' => '<p>The ID of the asset, in UUID format.</p>', 'AssetHierarchy$id' => '<p>The ID of the hierarchy. This ID is a <code>hierarchyId</code>.</p>', 'AssetHierarchyInfo$parentAssetId' => '<p>The ID of the parent asset in this asset relationship.</p>', 'AssetHierarchyInfo$childAssetId' => '<p>The ID of the child asset in this asset relationship.</p>', 'AssetIDs$member' => NULL, 'AssetModelCompositeModelDefinition$id' => '<p>The ID to assign to the composite model, if desired. IoT SiteWise automatically generates a unique ID for you, so this parameter is never required. However, if you prefer to supply your own ID instead, you can specify it here in UUID format. If you specify your own ID, it must be globally unique.</p>', 'AssetModelCompositeModelPathSegment$id' => '<p>The ID of the path segment.</p>', 'AssetModelCompositeModelSummary$id' => '<p>The ID of the the composite model that this summary describes..</p>', 'AssetModelHierarchyDefinition$id' => '<p>The ID to assign to the asset model hierarchy, if desired. IoT SiteWise automatically generates a unique ID for you, so this parameter is never required. However, if you prefer to supply your own ID instead, you can specify it here in UUID format. If you specify your own ID, it must be globally unique.</p>', 'AssetModelPropertyDefinition$id' => '<p>The ID to assign to the asset model property, if desired. IoT SiteWise automatically generates a unique ID for you, so this parameter is never required. However, if you prefer to supply your own ID instead, you can specify it here in UUID format. If you specify your own ID, it must be globally unique.</p>', 'AssetModelPropertyPathSegment$id' => '<p>The ID of the path segment.</p>', 'AssetModelPropertySummary$id' => '<p>The ID of the property.</p>', 'AssetModelPropertySummary$assetModelCompositeModelId' => '<p> The ID of the composite model that contains the asset model property. </p>', 'AssetModelSummary$id' => '<p>The ID of the asset model (used with IoT SiteWise API operations).</p>', 'AssetProperty$id' => '<p>The ID of the asset property.</p>', 'AssetPropertyPathSegment$id' => '<p>The ID of the path segment.</p>', 'AssetPropertySummary$id' => '<p>The ID of the property.</p>', 'AssetPropertySummary$assetCompositeModelId' => '<p> The ID of the composite model that contains the asset property. </p>', 'AssetSummary$id' => '<p>The ID of the asset, in UUID format.</p>', 'AssetSummary$assetModelId' => '<p>The ID of the asset model used to create this asset.</p>', 'AssociatedAssetsSummary$id' => '<p>The ID of the asset, in UUID format.</p>', 'AssociatedAssetsSummary$assetModelId' => '<p>The ID of the asset model used to create the asset.</p>', 'BatchAssociateProjectAssetsRequest$projectId' => '<p>The ID of the project to which to associate the assets.</p>', 'BatchDisassociateProjectAssetsRequest$projectId' => '<p>The ID of the project from which to disassociate the assets.</p>', 'BatchGetAssetPropertyAggregatesEntry$assetId' => '<p>The ID of the asset in which the asset property was created.</p>', 'BatchGetAssetPropertyAggregatesEntry$propertyId' => '<p>The ID of the asset property, in UUID format.</p>', 'BatchGetAssetPropertyValueEntry$assetId' => '<p>The ID of the asset in which the asset property was created.</p>', 'BatchGetAssetPropertyValueEntry$propertyId' => '<p>The ID of the asset property, in UUID format.</p>', 'BatchGetAssetPropertyValueHistoryEntry$assetId' => '<p>The ID of the asset in which the asset property was created.</p>', 'BatchGetAssetPropertyValueHistoryEntry$propertyId' => '<p>The ID of the asset property, in UUID format.</p>', 'CompositeModelProperty$id' => '<p> The ID of the composite model that contains the property. </p>', 'CompositionRelationshipItem$id' => '<p>The ID of the component.</p>', 'CompositionRelationshipSummary$assetModelId' => '<p>The ID of the asset model, in UUID format.</p>', 'CompositionRelationshipSummary$assetModelCompositeModelId' => '<p>The ID of a composite model on this asset model.</p>', 'CreateAccessPolicyResponse$accessPolicyId' => '<p>The ID of the access policy.</p>', 'CreateAssetModelCompositeModelRequest$assetModelCompositeModelId' => '<p>The ID of the composite model. IoT SiteWise automatically generates a unique ID for you, so this parameter is never required. However, if you prefer to supply your own ID instead, you can specify it here in UUID format. If you specify your own ID, it must be globally unique.</p>', 'CreateAssetModelCompositeModelResponse$assetModelCompositeModelId' => '<p>The ID of the composed asset model. You can use this ID when you call other IoT SiteWise APIs.</p>', 'CreateAssetModelRequest$assetModelId' => '<p>The ID to assign to the asset model, if desired. IoT SiteWise automatically generates a unique ID for you, so this parameter is never required. However, if you prefer to supply your own ID instead, you can specify it here in UUID format. If you specify your own ID, it must be globally unique.</p>', 'CreateAssetModelResponse$assetModelId' => '<p>The ID of the asset model, in UUID format. You can use this ID when you call other IoT SiteWise API operations.</p>', 'CreateAssetRequest$assetId' => '<p>The ID to assign to the asset, if desired. IoT SiteWise automatically generates a unique ID for you, so this parameter is never required. However, if you prefer to supply your own ID instead, you can specify it here in UUID format. If you specify your own ID, it must be globally unique.</p>', 'CreateAssetResponse$assetId' => '<p>The ID of the asset, in UUID format. This ID uniquely identifies the asset within IoT SiteWise and can be used with other IoT SiteWise API operations.</p>', 'CreateBulkImportJobResponse$jobId' => '<p>The ID of the job.</p>', 'CreateDashboardRequest$projectId' => '<p>The ID of the project in which to create the dashboard.</p>', 'CreateDashboardResponse$dashboardId' => '<p>The ID of the dashboard.</p>', 'CreateGatewayResponse$gatewayId' => '<p>The ID of the gateway device. You can use this ID when you call other IoT SiteWise API operations.</p>', 'CreatePortalResponse$portalId' => '<p>The ID of the created portal.</p>', 'CreateProjectRequest$portalId' => '<p>The ID of the portal in which to create the project.</p>', 'CreateProjectResponse$projectId' => '<p>The ID of the project.</p>', 'DashboardSummary$id' => '<p>The ID of the dashboard.</p>', 'DeleteAccessPolicyRequest$accessPolicyId' => '<p>The ID of the access policy to be deleted.</p>', 'DeleteDashboardRequest$dashboardId' => '<p>The ID of the dashboard to delete.</p>', 'DeleteGatewayRequest$gatewayId' => '<p>The ID of the gateway to delete.</p>', 'DeletePortalRequest$portalId' => '<p>The ID of the portal to delete.</p>', 'DeleteProjectRequest$projectId' => '<p>The ID of the project.</p>', 'DescribeAccessPolicyRequest$accessPolicyId' => '<p>The ID of the access policy.</p>', 'DescribeAccessPolicyResponse$accessPolicyId' => '<p>The ID of the access policy.</p>', 'DescribeActionRequest$actionId' => '<p>The ID of the action.</p>', 'DescribeActionResponse$actionId' => '<p>The ID of the action.</p>', 'DescribeActionResponse$actionDefinitionId' => '<p>The ID of the action definition.</p>', 'DescribeAssetCompositeModelResponse$assetId' => '<p>The ID of the asset, in UUID format. This ID uniquely identifies the asset within IoT SiteWise and can be used with other IoT SiteWise APIs.</p>', 'DescribeAssetCompositeModelResponse$assetCompositeModelId' => '<p>The ID of a composite model on this asset.</p>', 'DescribeAssetModelCompositeModelResponse$assetModelId' => '<p>The ID of the asset model, in UUID format.</p>', 'DescribeAssetModelCompositeModelResponse$assetModelCompositeModelId' => '<p>The ID of a composite model on this asset model.</p>', 'DescribeAssetModelResponse$assetModelId' => '<p>The ID of the asset model, in UUID format.</p>', 'DescribeAssetPropertyResponse$assetId' => '<p>The ID of the asset, in UUID format.</p>', 'DescribeAssetPropertyResponse$assetModelId' => '<p>The ID of the asset model, in UUID format.</p>', 'DescribeAssetResponse$assetId' => '<p>The ID of the asset, in UUID format.</p>', 'DescribeAssetResponse$assetModelId' => '<p>The ID of the asset model that was used to create the asset.</p>', 'DescribeBulkImportJobRequest$jobId' => '<p>The ID of the job.</p>', 'DescribeBulkImportJobResponse$jobId' => '<p>The ID of the job.</p>', 'DescribeDashboardRequest$dashboardId' => '<p>The ID of the dashboard.</p>', 'DescribeDashboardResponse$dashboardId' => '<p>The ID of the dashboard.</p>', 'DescribeDashboardResponse$projectId' => '<p>The ID of the project that the dashboard is in.</p>', 'DescribeGatewayCapabilityConfigurationRequest$gatewayId' => '<p>The ID of the gateway that defines the capability configuration.</p>', 'DescribeGatewayCapabilityConfigurationResponse$gatewayId' => '<p>The ID of the gateway that defines the capability configuration.</p>', 'DescribeGatewayRequest$gatewayId' => '<p>The ID of the gateway device.</p>', 'DescribeGatewayResponse$gatewayId' => '<p>The ID of the gateway device.</p>', 'DescribePortalRequest$portalId' => '<p>The ID of the portal.</p>', 'DescribePortalResponse$portalId' => '<p>The ID of the portal.</p>', 'DescribeProjectRequest$projectId' => '<p>The ID of the project.</p>', 'DescribeProjectResponse$projectId' => '<p>The ID of the project.</p>', 'DescribeProjectResponse$portalId' => '<p>The ID of the portal that the project is in.</p>', 'DescribeTimeSeriesResponse$assetId' => '<p>The ID of the asset in which the asset property was created.</p>', 'DescribeTimeSeriesResponse$propertyId' => '<p>The ID of the asset property, in UUID format.</p>', 'ExecuteActionRequest$actionDefinitionId' => '<p>The ID of the action definition.</p>', 'ExecuteActionResponse$actionId' => '<p>The ID of the action.</p>', 'GatewaySummary$gatewayId' => '<p>The ID of the gateway device.</p>', 'GetAssetPropertyAggregatesRequest$assetId' => '<p>The ID of the asset, in UUID format.</p>', 'GetAssetPropertyAggregatesRequest$propertyId' => '<p>The ID of the asset property, in UUID format.</p>', 'GetAssetPropertyValueHistoryRequest$assetId' => '<p>The ID of the asset, in UUID format.</p>', 'GetAssetPropertyValueHistoryRequest$propertyId' => '<p>The ID of the asset property, in UUID format.</p>', 'GetAssetPropertyValueRequest$assetId' => '<p>The ID of the asset, in UUID format.</p>', 'GetAssetPropertyValueRequest$propertyId' => '<p>The ID of the asset property, in UUID format.</p>', 'GetInterpolatedAssetPropertyValuesRequest$assetId' => '<p>The ID of the asset, in UUID format.</p>', 'GetInterpolatedAssetPropertyValuesRequest$propertyId' => '<p>The ID of the asset property, in UUID format.</p>', 'IDs$member' => NULL, 'Image$id' => '<p>The ID of an existing image. Specify this parameter to keep an existing image.</p>', 'ImageLocation$id' => '<p>The ID of the image.</p>', 'JobSummary$id' => '<p>The ID of the job.</p>', 'ListAccessPoliciesRequest$resourceId' => '<p>The ID of the resource. This parameter is required if you specify <code>resourceType</code>.</p>', 'ListCompositionRelationshipsRequest$assetModelId' => '<p>The ID of the asset model. This can be either the actual ID in UUID format, or else <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references">Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'ListDashboardsRequest$projectId' => '<p>The ID of the project.</p>', 'ListProjectAssetsRequest$projectId' => '<p>The ID of the project.</p>', 'ListProjectsRequest$portalId' => '<p>The ID of the portal.</p>', 'PortalResource$id' => '<p>The ID of the portal.</p>', 'PortalSummary$id' => '<p>The ID of the portal.</p>', 'ProjectResource$id' => '<p>The ID of the project.</p>', 'ProjectSummary$id' => '<p>The ID of the project.</p>', 'Property$id' => '<p>The ID of the asset property.</p>', 'PutAssetPropertyValueEntry$assetId' => '<p>The ID of the asset to update.</p>', 'PutAssetPropertyValueEntry$propertyId' => '<p>The ID of the asset property for this entry.</p>', 'TimeSeriesSummary$assetId' => '<p>The ID of the asset in which the asset property was created.</p>', 'TimeSeriesSummary$propertyId' => '<p>The ID of the asset property, in UUID format.</p>', 'UpdateAccessPolicyRequest$accessPolicyId' => '<p>The ID of the access policy.</p>', 'UpdateDashboardRequest$dashboardId' => '<p>The ID of the dashboard to update.</p>', 'UpdateGatewayCapabilityConfigurationRequest$gatewayId' => '<p>The ID of the gateway to be updated.</p>', 'UpdateGatewayRequest$gatewayId' => '<p>The ID of the gateway to update.</p>', 'UpdatePortalRequest$portalId' => '<p>The ID of the portal to update.</p>', 'UpdateProjectRequest$projectId' => '<p>The ID of the project to update.</p>', ], ], 'IDs' => [ 'base' => NULL, 'refs' => [ 'BatchAssociateProjectAssetsRequest$assetIds' => '<p>The IDs of the assets to be associated to the project.</p>', 'BatchDisassociateProjectAssetsRequest$assetIds' => '<p>The IDs of the assets to be disassociated from the project.</p>', ], ], 'Identity' => [ 'base' => '<p>Contains an identity that can access an IoT SiteWise Monitor resource.</p> <note> <p>Currently, you can\'t use Amazon Web Services API operations to retrieve IAM Identity Center identity IDs. You can find the IAM Identity Center identity IDs in the URL of user and group pages in the <a href="https://console.aws.amazon.com/singlesignon">IAM Identity Center console</a>.</p> </note>', 'refs' => [ 'AccessPolicySummary$identity' => '<p>The identity (an IAM Identity Center user, an IAM Identity Center group, or an IAM user).</p>', 'CreateAccessPolicyRequest$accessPolicyIdentity' => '<p>The identity for this access policy. Choose an IAM Identity Center user, an IAM Identity Center group, or an IAM user.</p>', 'DescribeAccessPolicyResponse$accessPolicyIdentity' => '<p>The identity (IAM Identity Center user, IAM Identity Center group, or IAM user) to which this access policy applies.</p>', 'UpdateAccessPolicyRequest$accessPolicyIdentity' => '<p>The identity for this access policy. Choose an IAM Identity Center user, an IAM Identity Center group, or an IAM user.</p>', ], ], 'IdentityId' => [ 'base' => NULL, 'refs' => [ 'GroupIdentity$id' => '<p>The IAM Identity Center ID of the group.</p>', 'ListAccessPoliciesRequest$identityId' => '<p>The ID of the identity. This parameter is required if you specify <code>USER</code> or <code>GROUP</code> for <code>identityType</code>.</p>', 'UserIdentity$id' => '<p>The IAM Identity Center ID of the user.</p>', ], ], 'IdentityType' => [ 'base' => NULL, 'refs' => [ 'ListAccessPoliciesRequest$identityType' => '<p>The type of identity (IAM Identity Center user, IAM Identity Center group, or IAM user). This parameter is required if you specify <code>identityId</code>.</p>', ], ], 'Image' => [ 'base' => '<p>Contains an image that is one of the following:</p> <ul> <li> <p>An image file. Choose this option to upload a new image.</p> </li> <li> <p>The ID of an existing image. Choose this option to keep an existing image.</p> </li> </ul>', 'refs' => [ 'UpdatePortalRequest$portalLogoImage' => NULL, ], ], 'ImageFile' => [ 'base' => '<p>Contains an image file.</p>', 'refs' => [ 'CreatePortalRequest$portalLogoImageFile' => '<p>A logo image to display in the portal. Upload a square, high-resolution image. The image is displayed on a dark background.</p>', 'Image$file' => NULL, ], ], 'ImageFileData' => [ 'base' => NULL, 'refs' => [ 'ImageFile$data' => '<p>The image file contents, represented as a base64-encoded string. The file size must be less than 1 MB.</p>', ], ], 'ImageFileType' => [ 'base' => NULL, 'refs' => [ 'ImageFile$type' => '<p>The file type of the image.</p>', ], ], 'ImageLocation' => [ 'base' => '<p>Contains an image that is uploaded to IoT SiteWise and available at a URL.</p>', 'refs' => [ 'DescribePortalResponse$portalLogoImageLocation' => '<p>The portal\'s logo image, which is available at a URL.</p>', ], ], 'InternalFailureException' => [ 'base' => '<p>IoT SiteWise can\'t process your request right now. Try again later.</p>', 'refs' => [], ], 'InterpolatedAssetPropertyValue' => [ 'base' => '<p>Contains information about an interpolated asset property value.</p>', 'refs' => [ 'InterpolatedAssetPropertyValues$member' => NULL, ], ], 'InterpolatedAssetPropertyValues' => [ 'base' => NULL, 'refs' => [ 'GetInterpolatedAssetPropertyValuesResponse$interpolatedAssetPropertyValues' => '<p>The requested interpolated values.</p>', ], ], 'InterpolationType' => [ 'base' => NULL, 'refs' => [ 'GetInterpolatedAssetPropertyValuesRequest$type' => '<p>The interpolation type.</p> <p>Valid values: <code>LINEAR_INTERPOLATION | LOCF_INTERPOLATION</code> </p> <ul> <li> <p> <code>LINEAR_INTERPOLATION</code> – Estimates missing data using <a href="https://en.wikipedia.org/wiki/Linear_interpolation">linear interpolation</a>.</p> <p>For example, you can use this operation to return the interpolated temperature values for a wind turbine every 24 hours over a duration of 7 days. If the interpolation starts July 1, 2021, at 9 AM, IoT SiteWise returns the first interpolated value on July 2, 2021, at 9 AM, the second interpolated value on July 3, 2021, at 9 AM, and so on.</p> </li> <li> <p> <code>LOCF_INTERPOLATION</code> – Estimates missing data using last observation carried forward interpolation</p> <p>If no data point is found for an interval, IoT SiteWise returns the last observed data point for the previous interval and carries forward this interpolated value until a new data point is found.</p> <p>For example, you can get the state of an on-off valve every 24 hours over a duration of 7 days. If the interpolation starts July 1, 2021, at 9 AM, IoT SiteWise returns the last observed data point between July 1, 2021, at 9 AM and July 2, 2021, at 9 AM as the first interpolated value. If a data point isn\'t found after 9 AM on July 2, 2021, IoT SiteWise uses the same interpolated value for the rest of the days.</p> </li> </ul>', ], ], 'Interval' => [ 'base' => NULL, 'refs' => [ 'TumblingWindow$interval' => '<p>The time interval for the tumbling window. The interval time must be between 1 minute and 1 week.</p> <p>IoT SiteWise computes the <code>1w</code> interval the end of Sunday at midnight each week (UTC), the <code>1d</code> interval at the end of each day at midnight (UTC), the <code>1h</code> interval at the end of each hour, and so on. </p> <p>When IoT SiteWise aggregates data points for metric computations, the start of each interval is exclusive and the end of each interval is inclusive. IoT SiteWise places the computed data point at the end of the interval.</p>', ], ], 'IntervalInSeconds' => [ 'base' => NULL, 'refs' => [ 'GetInterpolatedAssetPropertyValuesRequest$intervalInSeconds' => '<p>The time interval in seconds over which to interpolate data. Each interval starts when the previous one ends.</p>', ], ], 'IntervalWindowInSeconds' => [ 'base' => NULL, 'refs' => [ 'GetInterpolatedAssetPropertyValuesRequest$intervalWindowInSeconds' => '<p>The query interval for the window, in seconds. IoT SiteWise computes each interpolated value by using data points from the timestamp of each interval, minus the window to the timestamp of each interval plus the window. If not specified, the window ranges between the start time minus the interval and the end time plus the interval.</p> <note> <ul> <li> <p>If you specify a value for the <code>intervalWindowInSeconds</code> parameter, the value for the <code>type</code> parameter must be <code>LINEAR_INTERPOLATION</code>.</p> </li> <li> <p>If a data point isn\'t found during the specified query window, IoT SiteWise won\'t return an interpolated value for the interval. This indicates that there\'s a gap in the ingested data points.</p> </li> </ul> </note> <p>For example, you can get the interpolated temperature values for a wind turbine every 24 hours over a duration of 7 days. If the interpolation starts on July 1, 2021, at 9 AM with a window of 2 hours, IoT SiteWise uses the data points from 7 AM (9 AM minus 2 hours) to 11 AM (9 AM plus 2 hours) on July 2, 2021 to compute the first interpolated value. Next, IoT SiteWise uses the data points from 7 AM (9 AM minus 2 hours) to 11 AM (9 AM plus 2 hours) on July 3, 2021 to compute the second interpolated value, and so on. </p>', ], ], 'InvalidRequestException' => [ 'base' => '<p>The request isn\'t valid. This can occur if your request contains malformed JSON or unsupported characters. Check your request and try again.</p>', 'refs' => [], ], 'JobConfiguration' => [ 'base' => '<p>Contains the configuration information of a job, such as the file format used to save data in Amazon S3.</p>', 'refs' => [ 'CreateBulkImportJobRequest$jobConfiguration' => '<p>Contains the configuration information of a job, such as the file format used to save data in Amazon S3.</p>', 'DescribeBulkImportJobResponse$jobConfiguration' => '<p>Contains the configuration information of a job, such as the file format used to save data in Amazon S3.</p>', ], ], 'JobStatus' => [ 'base' => NULL, 'refs' => [ 'CreateBulkImportJobResponse$jobStatus' => '<p>The status of the bulk import job can be one of following values:</p> <ul> <li> <p> <code>PENDING</code> – IoT SiteWise is waiting for the current bulk import job to finish.</p> </li> <li> <p> <code>CANCELLED</code> – The bulk import job has been canceled.</p> </li> <li> <p> <code>RUNNING</code> – IoT SiteWise is processing your request to import your data from Amazon S3.</p> </li> <li> <p> <code>COMPLETED</code> – IoT SiteWise successfully completed your request to import data from Amazon S3.</p> </li> <li> <p> <code>FAILED</code> – IoT SiteWise couldn\'t process your request to import data from Amazon S3. You can use logs saved in the specified error report location in Amazon S3 to troubleshoot issues.</p> </li> <li> <p> <code>COMPLETED_WITH_FAILURES</code> – IoT SiteWise completed your request to import data from Amazon S3 with errors. You can use logs saved in the specified error report location in Amazon S3 to troubleshoot issues.</p> </li> </ul>', 'DescribeBulkImportJobResponse$jobStatus' => '<p>The status of the bulk import job can be one of following values:</p> <ul> <li> <p> <code>PENDING</code> – IoT SiteWise is waiting for the current bulk import job to finish.</p> </li> <li> <p> <code>CANCELLED</code> – The bulk import job has been canceled.</p> </li> <li> <p> <code>RUNNING</code> – IoT SiteWise is processing your request to import your data from Amazon S3.</p> </li> <li> <p> <code>COMPLETED</code> – IoT SiteWise successfully completed your request to import data from Amazon S3.</p> </li> <li> <p> <code>FAILED</code> – IoT SiteWise couldn\'t process your request to import data from Amazon S3. You can use logs saved in the specified error report location in Amazon S3 to troubleshoot issues.</p> </li> <li> <p> <code>COMPLETED_WITH_FAILURES</code> – IoT SiteWise completed your request to import data from Amazon S3 with errors. You can use logs saved in the specified error report location in Amazon S3 to troubleshoot issues.</p> </li> </ul>', 'JobSummary$status' => '<p>The status of the bulk import job can be one of following values:</p> <ul> <li> <p> <code>PENDING</code> – IoT SiteWise is waiting for the current bulk import job to finish.</p> </li> <li> <p> <code>CANCELLED</code> – The bulk import job has been canceled.</p> </li> <li> <p> <code>RUNNING</code> – IoT SiteWise is processing your request to import your data from Amazon S3.</p> </li> <li> <p> <code>COMPLETED</code> – IoT SiteWise successfully completed your request to import data from Amazon S3.</p> </li> <li> <p> <code>FAILED</code> – IoT SiteWise couldn\'t process your request to import data from Amazon S3. You can use logs saved in the specified error report location in Amazon S3 to troubleshoot issues.</p> </li> <li> <p> <code>COMPLETED_WITH_FAILURES</code> – IoT SiteWise completed your request to import data from Amazon S3 with errors. You can use logs saved in the specified error report location in Amazon S3 to troubleshoot issues.</p> </li> </ul>', ], ], 'JobSummaries' => [ 'base' => NULL, 'refs' => [ 'ListBulkImportJobsResponse$jobSummaries' => '<p>One or more job summaries to list.</p>', ], ], 'JobSummary' => [ 'base' => '<p>Contains the job summary information.</p>', 'refs' => [ 'JobSummaries$member' => NULL, ], ], 'KmsKeyId' => [ 'base' => NULL, 'refs' => [ 'PutDefaultEncryptionConfigurationRequest$kmsKeyId' => '<p>The Key ID of the customer managed key used for KMS encryption. This is required if you use <code>KMS_BASED_ENCRYPTION</code>.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>You\'ve reached the limit for a resource. For example, this can occur if you\'re trying to associate more than the allowed number of child assets or attempting to create more than the allowed number of properties for an asset model.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'refs' => [], ], 'ListAccessPoliciesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAccessPoliciesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListActionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListActionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAssetModelCompositeModelsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAssetModelCompositeModelsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAssetModelPropertiesFilter' => [ 'base' => NULL, 'refs' => [ 'ListAssetModelPropertiesRequest$filter' => '<p> Filters the requested list of asset model properties. You can choose one of the following options:</p> <ul> <li> <p> <code>ALL</code> – The list includes all asset model properties for a given asset model ID. </p> </li> <li> <p> <code>BASE</code> – The list includes only base asset model properties for a given asset model ID. </p> </li> </ul> <p>Default: <code>BASE</code> </p>', ], ], 'ListAssetModelPropertiesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAssetModelPropertiesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAssetModelsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAssetModelsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAssetModelsTypeFilter' => [ 'base' => NULL, 'refs' => [ 'ListAssetModelsRequest$assetModelTypes' => '<p>The type of asset model.</p> <ul> <li> <p> <b>ASSET_MODEL</b> – (default) An asset model that you can use to create assets. Can\'t be included as a component in another asset model.</p> </li> <li> <p> <b>COMPONENT_MODEL</b> – A reusable component that you can include in the composite models of other asset models. You can\'t create assets directly from this type of asset model. </p> </li> </ul>', ], ], 'ListAssetPropertiesFilter' => [ 'base' => NULL, 'refs' => [ 'ListAssetPropertiesRequest$filter' => '<p> Filters the requested list of asset properties. You can choose one of the following options:</p> <ul> <li> <p> <code>ALL</code> – The list includes all asset properties for a given asset model ID. </p> </li> <li> <p> <code>BASE</code> – The list includes only base asset properties for a given asset model ID. </p> </li> </ul> <p>Default: <code>BASE</code> </p>', ], ], 'ListAssetPropertiesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAssetPropertiesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAssetRelationshipsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAssetRelationshipsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAssetsFilter' => [ 'base' => NULL, 'refs' => [ 'ListAssetsRequest$filter' => '<p>The filter for the requested list of assets. Choose one of the following options:</p> <ul> <li> <p> <code>ALL</code> – The list includes all assets for a given asset model ID. The <code>assetModelId</code> parameter is required if you filter by <code>ALL</code>.</p> </li> <li> <p> <code>TOP_LEVEL</code> – The list includes only top-level assets in the asset hierarchy tree.</p> </li> </ul> <p>Default: <code>ALL</code> </p>', ], ], 'ListAssetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAssetsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAssociatedAssetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAssociatedAssetsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListBulkImportJobsFilter' => [ 'base' => NULL, 'refs' => [ 'ListBulkImportJobsRequest$filter' => '<p>You can use a filter to select the bulk import jobs that you want to retrieve.</p>', ], ], 'ListBulkImportJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListBulkImportJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListCompositionRelationshipsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCompositionRelationshipsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDashboardsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDashboardsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListGatewaysRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListGatewaysResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPortalsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPortalsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListProjectAssetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListProjectAssetsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListProjectsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListProjectsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTimeSeriesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTimeSeriesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTimeSeriesType' => [ 'base' => NULL, 'refs' => [ 'ListTimeSeriesRequest$timeSeriesType' => '<p>The type of the time series. The time series type can be one of the following values:</p> <ul> <li> <p> <code>ASSOCIATED</code> – The time series is associated with an asset property.</p> </li> <li> <p> <code>DISASSOCIATED</code> – The time series isn\'t associated with any asset property.</p> </li> </ul>', ], ], 'LoggingLevel' => [ 'base' => NULL, 'refs' => [ 'LoggingOptions$level' => '<p>The IoT SiteWise logging verbosity level.</p>', ], ], 'LoggingOptions' => [ 'base' => '<p>Contains logging options.</p>', 'refs' => [ 'DescribeLoggingOptionsResponse$loggingOptions' => '<p>The current logging options.</p>', 'PutLoggingOptionsRequest$loggingOptions' => '<p>The logging options to set.</p>', ], ], 'Macro' => [ 'base' => NULL, 'refs' => [ 'VariableValue$propertyId' => '<p>The ID of the property to use as the variable. You can use the property <code>name</code> if it\'s from the same asset model. If the property has an external ID, you can specify <code>externalId:</code> followed by the external ID. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'VariableValue$hierarchyId' => '<p>The ID of the hierarchy to query for the property ID. You can use the hierarchy\'s name instead of the hierarchy\'s ID. If the hierarchy has an external ID, you can specify <code>externalId:</code> followed by the external ID. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external IDs</a> in the <i>IoT SiteWise User Guide</i>.</p> <p>You use a hierarchy ID instead of a model ID because you can have several hierarchies using the same model and therefore the same <code>propertyId</code>. For example, you might have separately grouped assets that come from the same asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p>', ], ], 'MaxInterpolatedResults' => [ 'base' => NULL, 'refs' => [ 'GetInterpolatedAssetPropertyValuesRequest$maxResults' => '<p>The maximum number of results to return for each paginated request. If not specified, the default value is 10.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListAccessPoliciesRequest$maxResults' => '<p>The maximum number of results to return for each paginated request.</p> <p>Default: 50</p>', 'ListActionsRequest$maxResults' => '<p>The maximum number of results to return for each paginated request.</p>', 'ListAssetModelCompositeModelsRequest$maxResults' => '<p>The maximum number of results to return for each paginated request.</p> <p>Default: 50</p>', 'ListAssetModelPropertiesRequest$maxResults' => '<p>The maximum number of results to return for each paginated request. If not specified, the default value is 50.</p>', 'ListAssetModelsRequest$maxResults' => '<p>The maximum number of results to return for each paginated request.</p> <p>Default: 50</p>', 'ListAssetPropertiesRequest$maxResults' => '<p>The maximum number of results to return for each paginated request. If not specified, the default value is 50.</p>', 'ListAssetRelationshipsRequest$maxResults' => '<p>The maximum number of results to return for each paginated request.</p>', 'ListAssetsRequest$maxResults' => '<p>The maximum number of results to return for each paginated request.</p> <p>Default: 50</p>', 'ListAssociatedAssetsRequest$maxResults' => '<p>The maximum number of results to return for each paginated request.</p> <p>Default: 50</p>', 'ListBulkImportJobsRequest$maxResults' => '<p>The maximum number of results to return for each paginated request.</p>', 'ListCompositionRelationshipsRequest$maxResults' => '<p>The maximum number of results to return for each paginated request.</p> <p>Default: 50</p>', 'ListDashboardsRequest$maxResults' => '<p>The maximum number of results to return for each paginated request.</p> <p>Default: 50</p>', 'ListGatewaysRequest$maxResults' => '<p>The maximum number of results to return for each paginated request.</p> <p>Default: 50</p>', 'ListPortalsRequest$maxResults' => '<p>The maximum number of results to return for each paginated request.</p> <p>Default: 50</p>', 'ListProjectAssetsRequest$maxResults' => '<p>The maximum number of results to return for each paginated request.</p> <p>Default: 50</p>', 'ListProjectsRequest$maxResults' => '<p>The maximum number of results to return for each paginated request.</p> <p>Default: 50</p>', 'ListTimeSeriesRequest$maxResults' => '<p>The maximum number of results to return for each paginated request.</p>', ], ], 'Measurement' => [ 'base' => '<p>Contains an asset measurement property. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html#measurements">Measurements</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'refs' => [ 'PropertyType$measurement' => '<p>Specifies an asset measurement property. A measurement represents a device\'s raw sensor data stream, such as timestamped temperature values or timestamped power values.</p>', ], ], 'MeasurementProcessingConfig' => [ 'base' => '<p>The processing configuration for the given measurement property. You can configure measurements to be kept at the edge or forwarded to the Amazon Web Services Cloud. By default, measurements are forwarded to the cloud.</p>', 'refs' => [ 'Measurement$processingConfig' => '<p>The processing configuration for the given measurement property. You can configure measurements to be kept at the edge or forwarded to the Amazon Web Services Cloud. By default, measurements are forwarded to the cloud.</p>', ], ], 'Metric' => [ 'base' => '<p>Contains an asset metric property. With metrics, you can calculate aggregate functions, such as an average, maximum, or minimum, as specified through an expression. A metric maps several values to a single value (such as a sum).</p> <p>The maximum number of dependent/cascading variables used in any one metric calculation is 10. Therefore, a <i>root</i> metric can have up to 10 cascading metrics in its computational dependency tree. Additionally, a metric can only have a data type of <code>DOUBLE</code> and consume properties with data types of <code>INTEGER</code> or <code>DOUBLE</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html#metrics">Metrics</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'refs' => [ 'PropertyType$metric' => '<p>Specifies an asset metric property. A metric contains a mathematical expression that uses aggregate functions to process all input data points over a time interval and output a single data point, such as to calculate the average hourly temperature.</p>', ], ], 'MetricProcessingConfig' => [ 'base' => '<p>The processing configuration for the given metric property. You can configure metrics to be computed at the edge or in the Amazon Web Services Cloud. By default, metrics are forwarded to the cloud.</p>', 'refs' => [ 'Metric$processingConfig' => '<p>The processing configuration for the given metric property. You can configure metrics to be computed at the edge or in the Amazon Web Services Cloud. By default, metrics are forwarded to the cloud.</p>', ], ], 'MetricWindow' => [ 'base' => '<p>Contains a time interval window used for data aggregate computations (for example, average, sum, count, and so on).</p>', 'refs' => [ 'Metric$window' => '<p>The window (time interval) over which IoT SiteWise computes the metric\'s aggregation expression. IoT SiteWise computes one data point per <code>window</code>.</p>', ], ], 'MonitorErrorCode' => [ 'base' => NULL, 'refs' => [ 'MonitorErrorDetails$code' => '<p>The error code.</p>', ], ], 'MonitorErrorDetails' => [ 'base' => '<p>Contains IoT SiteWise Monitor error details.</p>', 'refs' => [ 'PortalStatus$error' => '<p>Contains associated error information, if any.</p>', ], ], 'MonitorErrorMessage' => [ 'base' => NULL, 'refs' => [ 'MonitorErrorDetails$message' => '<p>The error message.</p>', ], ], 'MultiLayerStorage' => [ 'base' => '<p>Contains information about the storage destination.</p>', 'refs' => [ 'DescribeStorageConfigurationResponse$multiLayerStorage' => '<p>Contains information about the storage destination.</p>', 'PutStorageConfigurationRequest$multiLayerStorage' => '<p>Identifies a storage destination. If you specified <code>MULTI_LAYER_STORAGE</code> for the storage type, you must specify a <code>MultiLayerStorage</code> object.</p>', 'PutStorageConfigurationResponse$multiLayerStorage' => '<p>Contains information about the storage destination.</p>', ], ], 'Name' => [ 'base' => NULL, 'refs' => [ 'ActionDefinition$actionName' => '<p>The name of the action definition.</p>', 'ActionDefinition$actionType' => '<p>The type of the action definition.</p>', 'AssetCompositeModel$name' => '<p>The name of the composite model.</p>', 'AssetCompositeModel$type' => '<p>The type of the composite model. For alarm composite models, this type is <code>AWS/ALARM</code>.</p>', 'AssetCompositeModelPathSegment$name' => '<p>The name of the path segment.</p>', 'AssetCompositeModelSummary$name' => '<p>The name of the composite model that this summary describes.</p>', 'AssetCompositeModelSummary$type' => '<p>The type of asset model.</p> <ul> <li> <p> <b>ASSET_MODEL</b> – (default) An asset model that you can use to create assets. Can\'t be included as a component in another asset model.</p> </li> <li> <p> <b>COMPONENT_MODEL</b> – A reusable component that you can include in the composite models of other asset models. You can\'t create assets directly from this type of asset model. </p> </li> </ul>', 'AssetHierarchy$name' => '<p>The hierarchy name provided in the <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModel.html">CreateAssetModel</a> or <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html">UpdateAssetModel</a> API operation.</p>', 'AssetModelCompositeModel$name' => '<p>The name of the composite model.</p>', 'AssetModelCompositeModel$type' => '<p>The type of the composite model. For alarm composite models, this type is <code>AWS/ALARM</code>.</p>', 'AssetModelCompositeModelDefinition$name' => '<p>The name of the composite model.</p>', 'AssetModelCompositeModelDefinition$type' => '<p>The type of the composite model. For alarm composite models, this type is <code>AWS/ALARM</code>.</p>', 'AssetModelCompositeModelPathSegment$name' => '<p>The name of the path segment.</p>', 'AssetModelCompositeModelSummary$name' => '<p>The name of the the composite model that this summary describes..</p>', 'AssetModelCompositeModelSummary$type' => '<p>The type of asset model.</p> <ul> <li> <p> <b>ASSET_MODEL</b> – (default) An asset model that you can use to create assets. Can\'t be included as a component in another asset model.</p> </li> <li> <p> <b>COMPONENT_MODEL</b> – A reusable component that you can include in the composite models of other asset models. You can\'t create assets directly from this type of asset model. </p> </li> </ul>', 'AssetModelHierarchy$name' => '<p>The name of the asset model hierarchy that you specify by using the <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModel.html">CreateAssetModel</a> or <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html">UpdateAssetModel</a> API operation.</p>', 'AssetModelHierarchyDefinition$name' => '<p>The name of the asset model hierarchy definition (as specified in the <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModel.html">CreateAssetModel</a> or <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html">UpdateAssetModel</a> API operation).</p>', 'AssetModelProperty$name' => '<p>The name of the asset model property.</p>', 'AssetModelProperty$dataTypeSpec' => '<p>The data type of the structure for this property. This parameter exists on properties that have the <code>STRUCT</code> data type.</p>', 'AssetModelPropertyDefinition$name' => '<p>The name of the property definition.</p>', 'AssetModelPropertyDefinition$dataTypeSpec' => '<p>The data type of the structure for this property. This parameter is required on properties that have the <code>STRUCT</code> data type.</p> <p>The options for this parameter depend on the type of the composite model in which you define this property. Use <code>AWS/ALARM_STATE</code> for alarm state in alarm composite models.</p>', 'AssetModelPropertyPathSegment$name' => '<p>The name of the path segment.</p>', 'AssetModelPropertySummary$name' => '<p>The name of the property.</p>', 'AssetModelPropertySummary$dataTypeSpec' => '<p>The data type of the structure for this property. This parameter exists on properties that have the <code>STRUCT</code> data type.</p>', 'AssetModelSummary$name' => '<p>The name of the asset model.</p>', 'AssetProperty$name' => '<p>The name of the property.</p>', 'AssetProperty$dataTypeSpec' => '<p>The data type of the structure for this property. This parameter exists on properties that have the <code>STRUCT</code> data type.</p>', 'AssetPropertyPathSegment$name' => '<p>The name of the path segment.</p>', 'AssetSummary$name' => '<p>The name of the asset.</p>', 'AssociatedAssetsSummary$name' => '<p>The name of the asset.</p>', 'CompositeModelProperty$name' => '<p>The name of the property.</p>', 'CompositeModelProperty$type' => '<p>The type of the composite model that defines this property.</p>', 'CompositionRelationshipSummary$assetModelCompositeModelType' => '<p>The composite model type. Valid values are <code>AWS/ALARM</code>, <code>CUSTOM</code>, or <code> AWS/L4E_ANOMALY</code>.</p>', 'CreateAssetModelCompositeModelRequest$assetModelCompositeModelName' => '<p>A unique, friendly name for the composite model.</p>', 'CreateAssetModelCompositeModelRequest$assetModelCompositeModelType' => '<p>The composite model type. Valid values are <code>AWS/ALARM</code>, <code>CUSTOM</code>, or <code> AWS/L4E_ANOMALY</code>.</p>', 'CreateAssetModelRequest$assetModelName' => '<p>A unique, friendly name for the asset model.</p>', 'CreateAssetRequest$assetName' => '<p>A friendly name for the asset.</p>', 'CreateBulkImportJobRequest$jobName' => '<p>The unique name that helps identify the job request.</p>', 'CreateBulkImportJobResponse$jobName' => '<p>The unique name that helps identify the job request.</p>', 'CreateDashboardRequest$dashboardName' => '<p>A friendly name for the dashboard.</p>', 'CreateGatewayRequest$gatewayName' => '<p>A unique, friendly name for the gateway.</p>', 'CreatePortalRequest$portalName' => '<p>A friendly name for the portal.</p>', 'CreateProjectRequest$projectName' => '<p>A friendly name for the project.</p>', 'DashboardSummary$name' => '<p>The name of the dashboard</p>', 'DescribeAssetCompositeModelResponse$assetCompositeModelName' => '<p>The unique, friendly name for the composite model.</p>', 'DescribeAssetCompositeModelResponse$assetCompositeModelType' => '<p>The composite model type. Valid values are <code>AWS/ALARM</code>, <code>CUSTOM</code>, or <code> AWS/L4E_ANOMALY</code>.</p>', 'DescribeAssetModelCompositeModelResponse$assetModelCompositeModelName' => '<p>The unique, friendly name for the composite model.</p>', 'DescribeAssetModelCompositeModelResponse$assetModelCompositeModelType' => '<p>The composite model type. Valid values are <code>AWS/ALARM</code>, <code>CUSTOM</code>, or <code> AWS/L4E_ANOMALY</code>.</p>', 'DescribeAssetModelResponse$assetModelName' => '<p>The name of the asset model.</p>', 'DescribeAssetPropertyResponse$assetName' => '<p>The name of the asset.</p>', 'DescribeAssetResponse$assetName' => '<p>The name of the asset.</p>', 'DescribeBulkImportJobResponse$jobName' => '<p>The unique name that helps identify the job request.</p>', 'DescribeDashboardResponse$dashboardName' => '<p>The name of the dashboard.</p>', 'DescribeGatewayResponse$gatewayName' => '<p>The name of the gateway.</p>', 'DescribePortalResponse$portalName' => '<p>The name of the portal.</p>', 'DescribeProjectResponse$projectName' => '<p>The name of the project.</p>', 'DescribeTimeSeriesResponse$dataTypeSpec' => '<p>The data type of the structure for this time series. This parameter is required for time series that have the <code>STRUCT</code> data type.</p> <p>The options for this parameter depend on the type of the composite model in which you created the asset property that is associated with your time series. Use <code>AWS/ALARM_STATE</code> for alarm state in alarm composite models.</p>', 'GatewaySummary$gatewayName' => '<p>The name of the asset.</p>', 'JobSummary$name' => '<p>The unique name that helps identify the job request.</p>', 'PortalSummary$name' => '<p>The name of the portal.</p>', 'ProjectSummary$name' => '<p>The name of the project.</p>', 'Property$name' => '<p>The name of the property.</p>', 'TimeSeriesSummary$dataTypeSpec' => '<p>The data type of the structure for this time series. This parameter is required for time series that have the <code>STRUCT</code> data type.</p> <p>The options for this parameter depend on the type of the composite model in which you created the asset property that is associated with your time series. Use <code>AWS/ALARM_STATE</code> for alarm state in alarm composite models.</p>', 'UpdateAssetModelCompositeModelRequest$assetModelCompositeModelName' => '<p>A unique, friendly name for the composite model.</p>', 'UpdateAssetModelRequest$assetModelName' => '<p>A unique, friendly name for the asset model.</p>', 'UpdateAssetRequest$assetName' => '<p>A friendly name for the asset.</p>', 'UpdateDashboardRequest$dashboardName' => '<p>A new friendly name for the dashboard.</p>', 'UpdateGatewayRequest$gatewayName' => '<p>A unique, friendly name for the gateway.</p>', 'UpdatePortalRequest$portalName' => '<p>A new friendly name for the portal.</p>', 'UpdateProjectRequest$projectName' => '<p>A new friendly name for the project.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'BatchGetAssetPropertyAggregatesRequest$nextToken' => '<p>The token to be used for the next set of paginated results.</p>', 'BatchGetAssetPropertyAggregatesResponse$nextToken' => '<p>The token for the next set of results, or null if there are no additional results.</p>', 'BatchGetAssetPropertyValueHistoryRequest$nextToken' => '<p>The token to be used for the next set of paginated results.</p>', 'BatchGetAssetPropertyValueHistoryResponse$nextToken' => '<p>The token for the next set of results, or null if there are no additional results.</p>', 'BatchGetAssetPropertyValueRequest$nextToken' => '<p>The token to be used for the next set of paginated results.</p>', 'BatchGetAssetPropertyValueResponse$nextToken' => '<p>The token for the next set of results, or null if there are no additional results.</p>', 'GetAssetPropertyAggregatesRequest$nextToken' => '<p>The token to be used for the next set of paginated results.</p>', 'GetAssetPropertyAggregatesResponse$nextToken' => '<p>The token for the next set of results, or null if there are no additional results.</p>', 'GetAssetPropertyValueHistoryRequest$nextToken' => '<p>The token to be used for the next set of paginated results.</p>', 'GetAssetPropertyValueHistoryResponse$nextToken' => '<p>The token for the next set of results, or null if there are no additional results.</p>', 'GetInterpolatedAssetPropertyValuesRequest$nextToken' => '<p>The token to be used for the next set of paginated results.</p>', 'GetInterpolatedAssetPropertyValuesResponse$nextToken' => '<p>The token for the next set of results, or null if there are no additional results.</p>', 'ListAccessPoliciesRequest$nextToken' => '<p>The token to be used for the next set of paginated results.</p>', 'ListAccessPoliciesResponse$nextToken' => '<p>The token for the next set of results, or null if there are no additional results.</p>', 'ListActionsRequest$nextToken' => '<p>The token to be used for the next set of paginated results.</p>', 'ListActionsResponse$nextToken' => '<p>The token for the next set of results, or null if there are no additional results.</p>', 'ListAssetModelCompositeModelsRequest$nextToken' => '<p>The token to be used for the next set of paginated results.</p>', 'ListAssetModelCompositeModelsResponse$nextToken' => '<p>The token for the next set of results, or null if there are no additional results.</p>', 'ListAssetModelPropertiesRequest$nextToken' => '<p>The token to be used for the next set of paginated results.</p>', 'ListAssetModelPropertiesResponse$nextToken' => '<p>The token for the next set of results, or null if there are no additional results.</p>', 'ListAssetModelsRequest$nextToken' => '<p>The token to be used for the next set of paginated results.</p>', 'ListAssetModelsResponse$nextToken' => '<p>The token for the next set of results, or null if there are no additional results.</p>', 'ListAssetPropertiesRequest$nextToken' => '<p>The token to be used for the next set of paginated results.</p>', 'ListAssetPropertiesResponse$nextToken' => '<p>The token for the next set of results, or null if there are no additional results.</p>', 'ListAssetRelationshipsRequest$nextToken' => '<p>The token to be used for the next set of paginated results.</p>', 'ListAssetRelationshipsResponse$nextToken' => '<p>The token for the next set of results, or null if there are no additional results.</p>', 'ListAssetsRequest$nextToken' => '<p>The token to be used for the next set of paginated results.</p>', 'ListAssetsResponse$nextToken' => '<p>The token for the next set of results, or null if there are no additional results.</p>', 'ListAssociatedAssetsRequest$nextToken' => '<p>The token to be used for the next set of paginated results.</p>', 'ListAssociatedAssetsResponse$nextToken' => '<p>The token for the next set of results, or null if there are no additional results.</p>', 'ListBulkImportJobsRequest$nextToken' => '<p>The token to be used for the next set of paginated results.</p>', 'ListBulkImportJobsResponse$nextToken' => '<p>The token for the next set of results, or null if there are no additional results.</p>', 'ListCompositionRelationshipsRequest$nextToken' => '<p>The token to be used for the next set of paginated results.</p>', 'ListCompositionRelationshipsResponse$nextToken' => '<p>The token for the next set of results, or null if there are no additional results.</p>', 'ListDashboardsRequest$nextToken' => '<p>The token to be used for the next set of paginated results.</p>', 'ListDashboardsResponse$nextToken' => '<p>The token for the next set of results, or null if there are no additional results.</p>', 'ListGatewaysRequest$nextToken' => '<p>The token to be used for the next set of paginated results.</p>', 'ListGatewaysResponse$nextToken' => '<p>The token for the next set of results, or null if there are no additional results.</p>', 'ListPortalsRequest$nextToken' => '<p>The token to be used for the next set of paginated results.</p>', 'ListPortalsResponse$nextToken' => '<p>The token for the next set of results, or null if there are no additional results.</p>', 'ListProjectAssetsRequest$nextToken' => '<p>The token to be used for the next set of paginated results.</p>', 'ListProjectAssetsResponse$nextToken' => '<p>The token for the next set of results, or null if there are no additional results.</p>', 'ListProjectsRequest$nextToken' => '<p>The token to be used for the next set of paginated results.</p>', 'ListProjectsResponse$nextToken' => '<p>The token for the next set of results, or null if there are no additional results.</p>', 'ListTimeSeriesRequest$nextToken' => '<p>The token to be used for the next set of paginated results.</p>', 'ListTimeSeriesResponse$nextToken' => '<p>The token for the next set of results, or null if there are no additional results.</p>', ], ], 'NullableBoolean' => [ 'base' => NULL, 'refs' => [ 'Datum$nullValue' => '<p>Indicates if the data point is null.</p>', ], ], 'NumberOfDays' => [ 'base' => NULL, 'refs' => [ 'RetentionPeriod$numberOfDays' => '<p>The number of days that your data is kept.</p> <note> <p>If you specified a value for this parameter, the <code>unlimited</code> parameter must be <code>false</code>.</p> </note>', 'WarmTierRetentionPeriod$numberOfDays' => '<p>The number of days the data is stored in the warm tier.</p>', ], ], 'Offset' => [ 'base' => NULL, 'refs' => [ 'TumblingWindow$offset' => '<p>The offset for the tumbling window. The <code>offset</code> parameter accepts the following:</p> <ul> <li> <p>The offset time.</p> <p>For example, if you specify <code>18h</code> for <code>offset</code> and <code>1d</code> for <code>interval</code>, IoT SiteWise aggregates data in one of the following ways:</p> <ul> <li> <p>If you create the metric before or at 6 PM (UTC), you get the first aggregation result at 6 PM (UTC) on the day when you create the metric.</p> </li> <li> <p>If you create the metric after 6 PM (UTC), you get the first aggregation result at 6 PM (UTC) the next day.</p> </li> </ul> </li> <li> <p>The ISO 8601 format.</p> <p>For example, if you specify <code>PT18H</code> for <code>offset</code> and <code>1d</code> for <code>interval</code>, IoT SiteWise aggregates data in one of the following ways:</p> <ul> <li> <p>If you create the metric before or at 6 PM (UTC), you get the first aggregation result at 6 PM (UTC) on the day when you create the metric.</p> </li> <li> <p>If you create the metric after 6 PM (UTC), you get the first aggregation result at 6 PM (UTC) the next day.</p> </li> </ul> </li> <li> <p>The 24-hour clock.</p> <p>For example, if you specify <code>00:03:00</code> for <code>offset</code>, <code>5m</code> for <code>interval</code>, and you create the metric at 2 PM (UTC), you get the first aggregation result at 2:03 PM (UTC). You get the second aggregation result at 2:08 PM (UTC). </p> </li> <li> <p>The offset time zone.</p> <p>For example, if you specify <code>2021-07-23T18:00-08</code> for <code>offset</code> and <code>1d</code> for <code>interval</code>, IoT SiteWise aggregates data in one of the following ways:</p> <ul> <li> <p>If you create the metric before or at 6 PM (PST), you get the first aggregation result at 6 PM (PST) on the day when you create the metric.</p> </li> <li> <p>If you create the metric after 6 PM (PST), you get the first aggregation result at 6 PM (PST) the next day.</p> </li> </ul> </li> </ul>', ], ], 'OffsetInNanos' => [ 'base' => NULL, 'refs' => [ 'GetInterpolatedAssetPropertyValuesRequest$startTimeOffsetInNanos' => '<p>The nanosecond offset converted from <code>startTimeInSeconds</code>.</p>', 'GetInterpolatedAssetPropertyValuesRequest$endTimeOffsetInNanos' => '<p>The nanosecond offset converted from <code>endTimeInSeconds</code>.</p>', 'TimeInNanos$offsetInNanos' => '<p>The nanosecond offset from <code>timeInSeconds</code>.</p>', ], ], 'Parquet' => [ 'base' => '<p>A parquet file.</p>', 'refs' => [ 'FileFormat$parquet' => '<p>The file is in parquet format.</p>', ], ], 'Permission' => [ 'base' => NULL, 'refs' => [ 'AccessPolicySummary$permission' => '<p>The permissions for the access policy. Note that a project <code>ADMINISTRATOR</code> is also known as a project owner.</p>', 'CreateAccessPolicyRequest$accessPolicyPermission' => '<p>The permission level for this access policy. Note that a project <code>ADMINISTRATOR</code> is also known as a project owner.</p>', 'DescribeAccessPolicyResponse$accessPolicyPermission' => '<p>The access policy permission. Note that a project <code>ADMINISTRATOR</code> is also known as a project owner.</p>', 'UpdateAccessPolicyRequest$accessPolicyPermission' => '<p>The permission level for this access policy. Note that a project <code>ADMINISTRATOR</code> is also known as a project owner.</p>', ], ], 'PortalClientId' => [ 'base' => NULL, 'refs' => [ 'DescribePortalResponse$portalClientId' => '<p>The IAM Identity Center application generated client ID (used with IAM Identity Center API operations). IoT SiteWise includes <code>portalClientId</code> for only portals that use IAM Identity Center to authenticate users.</p>', ], ], 'PortalResource' => [ 'base' => '<p>Identifies an IoT SiteWise Monitor portal.</p>', 'refs' => [ 'Resource$portal' => '<p>A portal resource.</p>', ], ], 'PortalState' => [ 'base' => NULL, 'refs' => [ 'PortalStatus$state' => '<p>The current state of the portal.</p>', ], ], 'PortalStatus' => [ 'base' => '<p>Contains information about the current status of a portal.</p>', 'refs' => [ 'CreatePortalResponse$portalStatus' => '<p>The status of the portal, which contains a state (<code>CREATING</code> after successfully calling this operation) and any error message.</p>', 'DeletePortalResponse$portalStatus' => '<p>The status of the portal, which contains a state (<code>DELETING</code> after successfully calling this operation) and any error message.</p>', 'DescribePortalResponse$portalStatus' => '<p>The current status of the portal, which contains a state and any error message.</p>', 'PortalSummary$status' => NULL, 'UpdatePortalResponse$portalStatus' => '<p>The status of the portal, which contains a state (<code>UPDATING</code> after successfully calling this operation) and any error message.</p>', ], ], 'PortalSummaries' => [ 'base' => NULL, 'refs' => [ 'ListPortalsResponse$portalSummaries' => '<p>A list that summarizes each portal.</p>', ], ], 'PortalSummary' => [ 'base' => '<p>Contains a portal summary.</p>', 'refs' => [ 'PortalSummaries$member' => NULL, ], ], 'ProjectResource' => [ 'base' => '<p>Identifies a specific IoT SiteWise Monitor project.</p>', 'refs' => [ 'Resource$project' => '<p>A project resource.</p>', ], ], 'ProjectSummaries' => [ 'base' => NULL, 'refs' => [ 'ListProjectsResponse$projectSummaries' => '<p>A list that summarizes each project in the portal.</p>', ], ], 'ProjectSummary' => [ 'base' => '<p>Contains project summary information.</p>', 'refs' => [ 'ProjectSummaries$member' => NULL, ], ], 'Property' => [ 'base' => '<p>Contains asset property information.</p>', 'refs' => [ 'CompositeModelProperty$assetProperty' => NULL, 'DescribeAssetPropertyResponse$assetProperty' => '<p>The asset property\'s definition, alias, and notification state.</p> <p>This response includes this object for normal asset properties. If you describe an asset property in a composite model, this response includes the asset property information in <code>compositeModel</code>.</p>', ], ], 'PropertyAlias' => [ 'base' => NULL, 'refs' => [ 'AssetProperty$alias' => '<p>The alias that identifies the property, such as an OPC-UA server data stream path (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'AssetPropertySummary$alias' => '<p>The alias that identifies the property, such as an OPC-UA server data stream path (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'AssociateTimeSeriesToAssetPropertyRequest$alias' => '<p>The alias that identifies the time series.</p>', 'DeleteTimeSeriesRequest$alias' => '<p>The alias that identifies the time series.</p>', 'DescribeTimeSeriesRequest$alias' => '<p>The alias that identifies the time series.</p>', 'DescribeTimeSeriesResponse$alias' => '<p>The alias that identifies the time series.</p>', 'DisassociateTimeSeriesFromAssetPropertyRequest$alias' => '<p>The alias that identifies the time series.</p>', 'ListTimeSeriesRequest$aliasPrefix' => '<p>The alias prefix of the time series.</p>', 'Property$alias' => '<p>The alias that identifies the property, such as an OPC-UA server data stream path (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'TimeSeriesSummary$alias' => '<p>The alias that identifies the time series.</p>', 'UpdateAssetPropertyRequest$propertyAlias' => '<p>The alias that identifies the property, such as an OPC-UA server data stream path (for example, <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p> <p>If you omit this parameter, the alias is removed from the property.</p>', ], ], 'PropertyDataType' => [ 'base' => NULL, 'refs' => [ 'AssetModelProperty$dataType' => '<p>The data type of the asset model property.</p>', 'AssetModelPropertyDefinition$dataType' => '<p>The data type of the property definition.</p> <p>If you specify <code>STRUCT</code>, you must also specify <code>dataTypeSpec</code> to identify the type of the structure for this property.</p>', 'AssetModelPropertySummary$dataType' => '<p>The data type of the property.</p>', 'AssetProperty$dataType' => '<p>The data type of the asset property.</p>', 'DescribeTimeSeriesResponse$dataType' => '<p>The data type of the time series.</p> <p>If you specify <code>STRUCT</code>, you must also specify <code>dataTypeSpec</code> to identify the type of the structure for this time series.</p>', 'Property$dataType' => '<p>The property data type.</p>', 'TimeSeriesSummary$dataType' => '<p>The data type of the time series.</p> <p>If you specify <code>STRUCT</code>, you must also specify <code>dataTypeSpec</code> to identify the type of the structure for this time series.</p>', ], ], 'PropertyNotification' => [ 'base' => '<p>Contains asset property value notification information. When the notification state is enabled, IoT SiteWise publishes property value updates to a unique MQTT topic. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/interact-with-other-services.html">Interacting with other services</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'refs' => [ 'AssetProperty$notification' => '<p>The asset property\'s notification topic and state. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html">UpdateAssetProperty</a>.</p>', 'AssetPropertySummary$notification' => NULL, 'Property$notification' => '<p>The asset property\'s notification topic and state. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html">UpdateAssetProperty</a>.</p>', ], ], 'PropertyNotificationState' => [ 'base' => NULL, 'refs' => [ 'PropertyNotification$state' => '<p>The current notification state.</p>', 'UpdateAssetPropertyRequest$propertyNotificationState' => '<p>The MQTT notification state (enabled or disabled) for this asset property. When the notification state is enabled, IoT SiteWise publishes property value updates to a unique MQTT topic. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/interact-with-other-services.html">Interacting with other services</a> in the <i>IoT SiteWise User Guide</i>.</p> <p>If you omit this parameter, the notification state is set to <code>DISABLED</code>.</p>', ], ], 'PropertyNotificationTopic' => [ 'base' => NULL, 'refs' => [ 'PropertyNotification$topic' => '<p>The MQTT topic to which IoT SiteWise publishes property value update notifications.</p>', ], ], 'PropertyType' => [ 'base' => '<p>Contains a property type, which can be one of <code>attribute</code>, <code>measurement</code>, <code>metric</code>, or <code>transform</code>.</p>', 'refs' => [ 'AssetModelProperty$type' => '<p>The property type (see <code>PropertyType</code>).</p>', 'AssetModelPropertyDefinition$type' => '<p>The property definition type (see <code>PropertyType</code>). You can only specify one type in a property definition.</p>', 'AssetModelPropertySummary$type' => NULL, 'Property$type' => '<p>The property type (see <code>PropertyType</code>). A property contains one type.</p>', ], ], 'PropertyUnit' => [ 'base' => NULL, 'refs' => [ 'AssetModelProperty$unit' => '<p>The unit of the asset model property, such as <code>Newtons</code> or <code>RPM</code>.</p>', 'AssetModelPropertyDefinition$unit' => '<p>The unit of the property definition, such as <code>Newtons</code> or <code>RPM</code>.</p>', 'AssetModelPropertySummary$unit' => '<p>The unit (such as <code>Newtons</code> or <code>RPM</code>) of the property.</p>', 'AssetProperty$unit' => '<p>The unit (such as <code>Newtons</code> or <code>RPM</code>) of the asset property.</p>', 'AssetPropertySummary$unit' => '<p> The unit of measure (such as Newtons or RPM) of the asset property. </p>', 'Property$unit' => '<p>The unit (such as <code>Newtons</code> or <code>RPM</code>) of the asset property.</p>', 'UpdateAssetPropertyRequest$propertyUnit' => '<p>The unit of measure (such as Newtons or RPM) of the asset property. If you don\'t specify a value for this parameter, the service uses the value of the <code>assetModelProperty</code> in the asset model.</p>', ], ], 'PropertyValueBooleanValue' => [ 'base' => NULL, 'refs' => [ 'Variant$booleanValue' => '<p>Asset property data of type Boolean (true or false).</p>', ], ], 'PropertyValueDoubleValue' => [ 'base' => NULL, 'refs' => [ 'Variant$doubleValue' => '<p>Asset property data of type double (floating point number).</p>', ], ], 'PropertyValueIntegerValue' => [ 'base' => NULL, 'refs' => [ 'Variant$integerValue' => '<p>Asset property data of type integer (number that\'s greater than or equal to zero).</p>', ], ], 'PropertyValueStringValue' => [ 'base' => NULL, 'refs' => [ 'Variant$stringValue' => '<p>Asset property data of type string (sequence of characters).</p>', ], ], 'PutAssetPropertyValueEntries' => [ 'base' => NULL, 'refs' => [ 'BatchPutAssetPropertyValueRequest$entries' => '<p>The list of asset property value entries for the batch put request. You can specify up to 10 entries per request.</p>', ], ], 'PutAssetPropertyValueEntry' => [ 'base' => '<p>Contains a list of value updates for an asset property in the list of asset entries consumed by the <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchPutAssetPropertyValue.html">BatchPutAssetPropertyValue</a> API operation.</p>', 'refs' => [ 'PutAssetPropertyValueEntries$member' => NULL, ], ], 'PutDefaultEncryptionConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutDefaultEncryptionConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutLoggingOptionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutLoggingOptionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutStorageConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutStorageConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'Qualities' => [ 'base' => NULL, 'refs' => [ 'BatchGetAssetPropertyAggregatesEntry$qualities' => '<p>The quality by which to filter asset data.</p>', 'BatchGetAssetPropertyValueHistoryEntry$qualities' => '<p>The quality by which to filter asset data.</p>', 'GetAssetPropertyAggregatesRequest$qualities' => '<p>The quality by which to filter asset data.</p>', 'GetAssetPropertyValueHistoryRequest$qualities' => '<p>The quality by which to filter asset data.</p>', ], ], 'Quality' => [ 'base' => NULL, 'refs' => [ 'AggregatedValue$quality' => '<p>The quality of the aggregated data.</p>', 'AssetPropertyValue$quality' => '<p>The quality of the asset property value.</p>', 'GetInterpolatedAssetPropertyValuesRequest$quality' => '<p>The quality of the asset property value. You can use this parameter as a filter to choose only the asset property values that have a specific quality.</p>', 'Qualities$member' => NULL, ], ], 'QueryStatement' => [ 'base' => NULL, 'refs' => [ 'ExecuteQueryRequest$queryStatement' => '<p>The IoT SiteWise query statement.</p>', ], ], 'QueryTimeoutException' => [ 'base' => '<p>The query timed out.</p>', 'refs' => [], ], 'Resolution' => [ 'base' => NULL, 'refs' => [ 'BatchGetAssetPropertyAggregatesEntry$resolution' => '<p>The time interval over which to aggregate data.</p>', 'GetAssetPropertyAggregatesRequest$resolution' => '<p>The time interval over which to aggregate data.</p>', ], ], 'Resource' => [ 'base' => '<p>Contains an IoT SiteWise Monitor resource ID for a portal or project.</p>', 'refs' => [ 'AccessPolicySummary$resource' => '<p>The IoT SiteWise Monitor resource (a portal or project).</p>', 'CreateAccessPolicyRequest$accessPolicyResource' => '<p>The IoT SiteWise Monitor resource for this access policy. Choose either a portal or a project.</p>', 'DescribeAccessPolicyResponse$accessPolicyResource' => '<p>The IoT SiteWise Monitor resource (portal or project) to which this access policy provides access.</p>', 'UpdateAccessPolicyRequest$accessPolicyResource' => '<p>The IoT SiteWise Monitor resource for this access policy. Choose either a portal or a project.</p>', ], ], 'ResourceAlreadyExistsException' => [ 'base' => '<p>The resource already exists.</p>', 'refs' => [], ], 'ResourceArn' => [ 'base' => NULL, 'refs' => [ 'ConflictingOperationException$resourceArn' => '<p>The ARN of the resource that conflicts with this operation.</p>', 'ResourceAlreadyExistsException$resourceArn' => '<p>The ARN of the resource that already exists.</p>', ], ], 'ResourceId' => [ 'base' => NULL, 'refs' => [ 'ConflictingOperationException$resourceId' => '<p>The ID of the resource that conflicts with this operation.</p>', 'ResourceAlreadyExistsException$resourceId' => '<p>The ID of the resource that already exists.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The requested resource can\'t be found.</p>', 'refs' => [], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'ListAccessPoliciesRequest$resourceType' => '<p>The type of resource (portal or project). This parameter is required if you specify <code>resourceId</code>.</p>', ], ], 'RetentionPeriod' => [ 'base' => '<p>The number of days your data is kept in the hot tier. By default, your data is kept indefinitely in the hot tier.</p>', 'refs' => [ 'DescribeStorageConfigurationResponse$retentionPeriod' => '<p>The number of days your data is kept in the hot tier. By default, your data is kept indefinitely in the hot tier.</p>', 'PutStorageConfigurationRequest$retentionPeriod' => NULL, 'PutStorageConfigurationResponse$retentionPeriod' => NULL, ], ], 'Row' => [ 'base' => '<p>Represents a single row in the query results.</p>', 'refs' => [ 'Datum$rowValue' => '<p>Indicates if the data point is a row.</p>', 'Rows$member' => NULL, ], ], 'Rows' => [ 'base' => NULL, 'refs' => [ 'ExecuteQueryResponse$rows' => '<p>Represents a single row in the query results.</p>', ], ], 'SSOApplicationId' => [ 'base' => NULL, 'refs' => [ 'CreatePortalResponse$ssoApplicationId' => '<p>The associated IAM Identity Center application ID, if the portal uses IAM Identity Center.</p>', ], ], 'ScalarType' => [ 'base' => NULL, 'refs' => [ 'ColumnType$scalarType' => '<p>The allowed data types that the column has as it\'s value.</p>', ], ], 'ScalarValue' => [ 'base' => NULL, 'refs' => [ 'Datum$scalarValue' => '<p>Indicates if the data point is a scalar value such as integer, string, double, or Boolean. </p>', ], ], 'ServiceUnavailableException' => [ 'base' => '<p>The requested service is unavailable.</p>', 'refs' => [], ], 'StorageType' => [ 'base' => NULL, 'refs' => [ 'DescribeStorageConfigurationResponse$storageType' => '<p>The storage tier that you specified for your data. The <code>storageType</code> parameter can be one of the following values:</p> <ul> <li> <p> <code>SITEWISE_DEFAULT_STORAGE</code> – IoT SiteWise saves your data into the hot tier. The hot tier is a service-managed database.</p> </li> <li> <p> <code>MULTI_LAYER_STORAGE</code> – IoT SiteWise saves your data in both the cold tier and the hot tier. The cold tier is a customer-managed Amazon S3 bucket.</p> </li> </ul>', 'PutStorageConfigurationRequest$storageType' => '<p>The storage tier that you specified for your data. The <code>storageType</code> parameter can be one of the following values:</p> <ul> <li> <p> <code>SITEWISE_DEFAULT_STORAGE</code> – IoT SiteWise saves your data into the hot tier. The hot tier is a service-managed database.</p> </li> <li> <p> <code>MULTI_LAYER_STORAGE</code> – IoT SiteWise saves your data in both the cold tier and the hot tier. The cold tier is a customer-managed Amazon S3 bucket.</p> </li> </ul>', 'PutStorageConfigurationResponse$storageType' => '<p>The storage tier that you specified for your data. The <code>storageType</code> parameter can be one of the following values:</p> <ul> <li> <p> <code>SITEWISE_DEFAULT_STORAGE</code> – IoT SiteWise saves your data into the hot tier. The hot tier is a service-managed database.</p> </li> <li> <p> <code>MULTI_LAYER_STORAGE</code> – IoT SiteWise saves your data in both the cold tier and the hot tier. The cold tier is a customer-managed Amazon S3 bucket.</p> </li> </ul>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'ColumnInfo$name' => '<p>The name of the column description.</p>', 'ErrorReportLocation$prefix' => '<p>Amazon S3 uses the prefix as a folder name to organize data in the bucket. Each Amazon S3 object has a key that is its unique identifier in the bucket. Each object in a bucket has exactly one key. The prefix must end with a forward slash (/). For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-prefixes.html">Organizing objects using prefixes</a> in the <i>Amazon Simple Storage Service User Guide</i>.</p>', 'File$key' => '<p>The key of the Amazon S3 object that contains your data. Each object has a key that is a unique identifier. Each object has exactly one key.</p>', 'File$versionId' => '<p>The version ID to identify a specific version of the Amazon S3 object that contains your data.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'TagMap$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>A list of keys for tags to remove from the resource.</p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'CreateAccessPolicyRequest$tags' => '<p>A list of key-value pairs that contain metadata for the access policy. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise resources</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'CreateAssetModelRequest$tags' => '<p>A list of key-value pairs that contain metadata for the asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise resources</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'CreateAssetRequest$tags' => '<p>A list of key-value pairs that contain metadata for the asset. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise resources</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'CreateDashboardRequest$tags' => '<p>A list of key-value pairs that contain metadata for the dashboard. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise resources</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'CreateGatewayRequest$tags' => '<p>A list of key-value pairs that contain metadata for the gateway. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise resources</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'CreatePortalRequest$tags' => '<p>A list of key-value pairs that contain metadata for the portal. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise resources</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'CreateProjectRequest$tags' => '<p>A list of key-value pairs that contain metadata for the project. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise resources</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'ListTagsForResourceResponse$tags' => '<p>The list of key-value pairs that contain metadata for the resource. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise resources</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'TagResourceRequest$tags' => '<p>A list of key-value pairs that contain metadata for the resource. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise resources</a> in the <i>IoT SiteWise User Guide</i>.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagMap$value' => NULL, ], ], 'TargetResource' => [ 'base' => '<p>The resource the action will be taken on.</p>', 'refs' => [ 'ActionSummary$targetResource' => '<p>The resource the action will be taken on.</p>', 'DescribeActionResponse$targetResource' => '<p>The resource the action will be taken on.</p>', 'ExecuteActionRequest$targetResource' => '<p>The resource the action will be taken on.</p>', ], ], 'TargetResourceType' => [ 'base' => NULL, 'refs' => [ 'ListActionsRequest$targetResourceType' => '<p>The type of resource.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise assets that can be created per second, the allowed number of messages per second, and so on.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'refs' => [], ], 'TimeInNanos' => [ 'base' => '<p>Contains a timestamp with optional nanosecond granularity.</p>', 'refs' => [ 'AssetPropertyValue$timestamp' => '<p>The timestamp of the asset property value.</p>', 'InterpolatedAssetPropertyValue$timestamp' => NULL, 'Timestamps$member' => NULL, ], ], 'TimeInSeconds' => [ 'base' => NULL, 'refs' => [ 'GetInterpolatedAssetPropertyValuesRequest$startTimeInSeconds' => '<p>The exclusive start of the range from which to interpolate data, expressed in seconds in Unix epoch time.</p>', 'GetInterpolatedAssetPropertyValuesRequest$endTimeInSeconds' => '<p>The inclusive end of the range from which to interpolate data, expressed in seconds in Unix epoch time.</p>', 'TimeInNanos$timeInSeconds' => '<p>The timestamp date, in seconds, in the Unix epoch format. Fractional nanosecond data is provided by <code>offsetInNanos</code>.</p>', ], ], 'TimeOrdering' => [ 'base' => NULL, 'refs' => [ 'BatchGetAssetPropertyAggregatesEntry$timeOrdering' => '<p>The chronological sorting order of the requested information.</p> <p>Default: <code>ASCENDING</code> </p>', 'BatchGetAssetPropertyValueHistoryEntry$timeOrdering' => '<p>The chronological sorting order of the requested information.</p> <p>Default: <code>ASCENDING</code> </p>', 'GetAssetPropertyAggregatesRequest$timeOrdering' => '<p>The chronological sorting order of the requested information.</p> <p>Default: <code>ASCENDING</code> </p>', 'GetAssetPropertyValueHistoryRequest$timeOrdering' => '<p>The chronological sorting order of the requested information.</p> <p>Default: <code>ASCENDING</code> </p>', ], ], 'TimeSeriesId' => [ 'base' => NULL, 'refs' => [ 'DescribeTimeSeriesResponse$timeSeriesId' => '<p>The ID of the time series.</p>', 'TimeSeriesSummary$timeSeriesId' => '<p>The ID of the time series.</p>', ], ], 'TimeSeriesSummaries' => [ 'base' => NULL, 'refs' => [ 'ListTimeSeriesResponse$TimeSeriesSummaries' => '<p>One or more time series summaries to list.</p>', ], ], 'TimeSeriesSummary' => [ 'base' => '<p>Contains a summary of a time series (data stream).</p>', 'refs' => [ 'TimeSeriesSummaries$member' => NULL, ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'AccessPolicySummary$creationDate' => '<p>The date the access policy was created, in Unix epoch time.</p>', 'AccessPolicySummary$lastUpdateDate' => '<p>The date the access policy was last updated, in Unix epoch time.</p>', 'AggregatedValue$timestamp' => '<p>The date the aggregating computations occurred, in Unix epoch time.</p>', 'AssetModelSummary$creationDate' => '<p>The date the asset model was created, in Unix epoch time.</p>', 'AssetModelSummary$lastUpdateDate' => '<p>The date the asset model was last updated, in Unix epoch time.</p>', 'AssetSummary$creationDate' => '<p>The date the asset was created, in Unix epoch time.</p>', 'AssetSummary$lastUpdateDate' => '<p>The date the asset was last updated, in Unix epoch time.</p>', 'AssociatedAssetsSummary$creationDate' => '<p>The date the asset was created, in Unix epoch time.</p>', 'AssociatedAssetsSummary$lastUpdateDate' => '<p>The date the asset was last updated, in Unix epoch time.</p>', 'BatchGetAssetPropertyAggregatesEntry$startDate' => '<p>The exclusive start of the range from which to query historical data, expressed in seconds in Unix epoch time.</p>', 'BatchGetAssetPropertyAggregatesEntry$endDate' => '<p>The inclusive end of the range from which to query historical data, expressed in seconds in Unix epoch time.</p>', 'BatchGetAssetPropertyAggregatesErrorInfo$errorTimestamp' => '<p>The date the error occurred, in Unix epoch time.</p>', 'BatchGetAssetPropertyValueErrorInfo$errorTimestamp' => '<p>The date the error occurred, in Unix epoch time.</p>', 'BatchGetAssetPropertyValueHistoryEntry$startDate' => '<p>The exclusive start of the range from which to query historical data, expressed in seconds in Unix epoch time.</p>', 'BatchGetAssetPropertyValueHistoryEntry$endDate' => '<p>The inclusive end of the range from which to query historical data, expressed in seconds in Unix epoch time.</p>', 'BatchGetAssetPropertyValueHistoryErrorInfo$errorTimestamp' => '<p>The date the error occurred, in Unix epoch time.</p>', 'DashboardSummary$creationDate' => '<p>The date the dashboard was created, in Unix epoch time.</p>', 'DashboardSummary$lastUpdateDate' => '<p>The date the dashboard was last updated, in Unix epoch time.</p>', 'DescribeAccessPolicyResponse$accessPolicyCreationDate' => '<p>The date the access policy was created, in Unix epoch time.</p>', 'DescribeAccessPolicyResponse$accessPolicyLastUpdateDate' => '<p>The date the access policy was last updated, in Unix epoch time.</p>', 'DescribeActionResponse$executionTime' => '<p>The time the action was executed.</p>', 'DescribeAssetModelResponse$assetModelCreationDate' => '<p>The date the asset model was created, in Unix epoch time.</p>', 'DescribeAssetModelResponse$assetModelLastUpdateDate' => '<p>The date the asset model was last updated, in Unix epoch time.</p>', 'DescribeAssetResponse$assetCreationDate' => '<p>The date the asset was created, in Unix epoch time.</p>', 'DescribeAssetResponse$assetLastUpdateDate' => '<p>The date the asset was last updated, in Unix epoch time.</p>', 'DescribeBulkImportJobResponse$jobCreationDate' => '<p>The date the job was created, in Unix epoch TIME.</p>', 'DescribeBulkImportJobResponse$jobLastUpdateDate' => '<p>The date the job was last updated, in Unix epoch time.</p>', 'DescribeDashboardResponse$dashboardCreationDate' => '<p>The date the dashboard was created, in Unix epoch time.</p>', 'DescribeDashboardResponse$dashboardLastUpdateDate' => '<p>The date the dashboard was last updated, in Unix epoch time.</p>', 'DescribeGatewayResponse$creationDate' => '<p>The date the gateway was created, in Unix epoch time.</p>', 'DescribeGatewayResponse$lastUpdateDate' => '<p>The date the gateway was last updated, in Unix epoch time.</p>', 'DescribePortalResponse$portalCreationDate' => '<p>The date the portal was created, in Unix epoch time.</p>', 'DescribePortalResponse$portalLastUpdateDate' => '<p>The date the portal was last updated, in Unix epoch time.</p>', 'DescribeProjectResponse$projectCreationDate' => '<p>The date the project was created, in Unix epoch time.</p>', 'DescribeProjectResponse$projectLastUpdateDate' => '<p>The date the project was last updated, in Unix epoch time.</p>', 'DescribeStorageConfigurationResponse$lastUpdateDate' => '<p>The date the storage configuration was last updated, in Unix epoch time.</p>', 'DescribeTimeSeriesResponse$timeSeriesCreationDate' => '<p>The date that the time series was created, in Unix epoch time.</p>', 'DescribeTimeSeriesResponse$timeSeriesLastUpdateDate' => '<p>The date that the time series was last updated, in Unix epoch time.</p>', 'GatewaySummary$creationDate' => '<p>The date the gateway was created, in Unix epoch time.</p>', 'GatewaySummary$lastUpdateDate' => '<p>The date the gateway was last updated, in Unix epoch time.</p>', 'GetAssetPropertyAggregatesRequest$startDate' => '<p>The exclusive start of the range from which to query historical data, expressed in seconds in Unix epoch time.</p>', 'GetAssetPropertyAggregatesRequest$endDate' => '<p>The inclusive end of the range from which to query historical data, expressed in seconds in Unix epoch time.</p>', 'GetAssetPropertyValueHistoryRequest$startDate' => '<p>The exclusive start of the range from which to query historical data, expressed in seconds in Unix epoch time.</p>', 'GetAssetPropertyValueHistoryRequest$endDate' => '<p>The inclusive end of the range from which to query historical data, expressed in seconds in Unix epoch time.</p>', 'PortalSummary$creationDate' => '<p>The date the portal was created, in Unix epoch time.</p>', 'PortalSummary$lastUpdateDate' => '<p>The date the portal was last updated, in Unix epoch time.</p>', 'ProjectSummary$creationDate' => '<p>The date the project was created, in Unix epoch time.</p>', 'ProjectSummary$lastUpdateDate' => '<p>The date the project was last updated, in Unix epoch time.</p>', 'TimeSeriesSummary$timeSeriesCreationDate' => '<p>The date that the time series was created, in Unix epoch time.</p>', 'TimeSeriesSummary$timeSeriesLastUpdateDate' => '<p>The date that the time series was last updated, in Unix epoch time.</p>', ], ], 'Timestamps' => [ 'base' => NULL, 'refs' => [ 'BatchPutAssetPropertyError$timestamps' => '<p>A list of timestamps for each error, if any.</p>', ], ], 'TooManyTagsException' => [ 'base' => '<p>You\'ve reached the limit for the number of tags allowed for a resource. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html#tag-conventions">Tag naming limits and requirements</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'refs' => [], ], 'Transform' => [ 'base' => '<p>Contains an asset transform property. A transform is a one-to-one mapping of a property\'s data points from one form to another. For example, you can use a transform to convert a Celsius data stream to Fahrenheit by applying the transformation expression to each data point of the Celsius stream. A transform can only have a data type of <code>DOUBLE</code> and consume properties with data types of <code>INTEGER</code> or <code>DOUBLE</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html#transforms">Transforms</a> in the <i>IoT SiteWise User Guide</i>.</p>', 'refs' => [ 'PropertyType$transform' => '<p>Specifies an asset transform property. A transform contains a mathematical expression that maps a property\'s data points from one form to another, such as a unit conversion from Celsius to Fahrenheit.</p>', ], ], 'TransformProcessingConfig' => [ 'base' => '<p>The processing configuration for the given transform property. You can configure transforms to be kept at the edge or forwarded to the Amazon Web Services Cloud. You can also configure transforms to be computed at the edge or in the cloud.</p>', 'refs' => [ 'Transform$processingConfig' => '<p>The processing configuration for the given transform property. You can configure transforms to be kept at the edge or forwarded to the Amazon Web Services Cloud. You can also configure transforms to be computed at the edge or in the cloud.</p>', ], ], 'TraversalDirection' => [ 'base' => NULL, 'refs' => [ 'ListAssociatedAssetsRequest$traversalDirection' => '<p>The direction to list associated assets. Choose one of the following options:</p> <ul> <li> <p> <code>CHILD</code> – The list includes all child assets associated to the asset. The <code>hierarchyId</code> parameter is required if you choose <code>CHILD</code>.</p> </li> <li> <p> <code>PARENT</code> – The list includes the asset\'s parent asset.</p> </li> </ul> <p>Default: <code>CHILD</code> </p>', ], ], 'TraversalType' => [ 'base' => NULL, 'refs' => [ 'ListAssetRelationshipsRequest$traversalType' => '<p>The type of traversal to use to identify asset relationships. Choose the following option:</p> <ul> <li> <p> <code>PATH_TO_ROOT</code> – Identify the asset\'s parent assets up to the root asset. The asset that you specify in <code>assetId</code> is the first result in the list of <code>assetRelationshipSummaries</code>, and the root asset is the last result.</p> </li> </ul>', ], ], 'TumblingWindow' => [ 'base' => '<p>Contains a tumbling window, which is a repeating fixed-sized, non-overlapping, and contiguous time window. You can use this window in metrics to aggregate data from properties and other assets.</p> <p>You can use <code>m</code>, <code>h</code>, <code>d</code>, and <code>w</code> when you specify an interval or offset. Note that <code>m</code> represents minutes, <code>h</code> represents hours, <code>d</code> represents days, and <code>w</code> represents weeks. You can also use <code>s</code> to represent seconds in <code>offset</code>.</p> <p>The <code>interval</code> and <code>offset</code> parameters support the <a href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601 format</a>. For example, <code>PT5S</code> represents 5 seconds, <code>PT5M</code> represents 5 minutes, and <code>PT5H</code> represents 5 hours.</p>', 'refs' => [ 'MetricWindow$tumbling' => '<p>The tumbling time interval window.</p>', ], ], 'UnauthorizedException' => [ 'base' => '<p>You are not authorized.</p>', 'refs' => [], ], 'Unlimited' => [ 'base' => NULL, 'refs' => [ 'RetentionPeriod$unlimited' => '<p>If true, your data is kept indefinitely.</p> <note> <p>If configured to <code>true</code>, you must not specify a value for the <code>numberOfDays</code> parameter.</p> </note>', 'WarmTierRetentionPeriod$unlimited' => '<p>If set to true, the data is stored indefinitely in the warm tier.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAccessPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAccessPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAssetModelCompositeModelRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAssetModelCompositeModelResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAssetModelRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAssetModelResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAssetPropertyRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAssetRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAssetResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDashboardRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDashboardResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGatewayCapabilityConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGatewayCapabilityConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGatewayRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePortalRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePortalResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateProjectRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateProjectResponse' => [ 'base' => NULL, 'refs' => [], ], 'Url' => [ 'base' => NULL, 'refs' => [ 'CreatePortalResponse$portalStartUrl' => '<p>The URL for the IoT SiteWise Monitor portal. You can use this URL to access portals that use IAM Identity Center for authentication. For portals that use IAM for authentication, you must use the IoT SiteWise console to get a URL that you can use to access the portal.</p>', 'DescribePortalResponse$portalStartUrl' => '<p>The URL for the IoT SiteWise Monitor portal. You can use this URL to access portals that use IAM Identity Center for authentication. For portals that use IAM for authentication, you must use the IoT SiteWise console to get a URL that you can use to access the portal.</p>', 'ImageLocation$url' => '<p>The URL where the image is available. The URL is valid for 15 minutes so that you can view and download the image</p>', 'PortalSummary$startUrl' => '<p>The URL for the IoT SiteWise Monitor portal. You can use this URL to access portals that use IAM Identity Center for authentication. For portals that use IAM for authentication, you must use the IoT SiteWise console to get a URL that you can use to access the portal.</p>', ], ], 'UserIdentity' => [ 'base' => '<p>Contains information for a user identity in an access policy.</p>', 'refs' => [ 'Identity$user' => '<p>An IAM Identity Center user identity.</p>', ], ], 'ValidationException' => [ 'base' => '<p>The validation failed for this query.</p>', 'refs' => [], ], 'VariableName' => [ 'base' => NULL, 'refs' => [ 'ExpressionVariable$name' => '<p>The friendly name of the variable to be used in the expression.</p>', ], ], 'VariableValue' => [ 'base' => '<p>Identifies a property value used in an expression.</p>', 'refs' => [ 'ExpressionVariable$value' => '<p>The variable that identifies an asset property from which to use values.</p>', ], ], 'Variant' => [ 'base' => '<p>Contains an asset property value (of a single type only).</p>', 'refs' => [ 'AssetPropertyValue$value' => '<p>The value of the asset property (see <code>Variant</code>).</p>', 'InterpolatedAssetPropertyValue$value' => NULL, ], ], 'WarmTierRetentionPeriod' => [ 'base' => '<p>Set this period to specify how long your data is stored in the warm tier before it is deleted. You can set this only if cold tier is enabled.</p>', 'refs' => [ 'DescribeStorageConfigurationResponse$warmTierRetentionPeriod' => '<p>Set this period to specify how long your data is stored in the warm tier before it is deleted. You can set this only if cold tier is enabled.</p>', 'PutStorageConfigurationRequest$warmTierRetentionPeriod' => '<p>Set this period to specify how long your data is stored in the warm tier before it is deleted. You can set this only if cold tier is enabled.</p>', 'PutStorageConfigurationResponse$warmTierRetentionPeriod' => '<p>Set this period to specify how long your data is stored in the warm tier before it is deleted. You can set this only if cold tier is enabled.</p>', ], ], 'WarmTierState' => [ 'base' => NULL, 'refs' => [ 'DescribeStorageConfigurationResponse$warmTier' => '<p>A service managed storage tier optimized for analytical queries. It stores periodically uploaded, buffered and historical data ingested with the CreaeBulkImportJob API.</p>', 'PutStorageConfigurationRequest$warmTier' => '<p>A service managed storage tier optimized for analytical queries. It stores periodically uploaded, buffered and historical data ingested with the CreaeBulkImportJob API.</p>', 'PutStorageConfigurationResponse$warmTier' => '<p>A service managed storage tier optimized for analytical queries. It stores periodically uploaded, buffered and historical data ingested with the CreaeBulkImportJob API.</p>', ], ], 'errorMessage' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'QueryTimeoutException$message' => NULL, 'ValidationException$message' => NULL, ], ], ],];
