<?php
// This file was auto-generated from sdk-root/src/data/ivs/2020-07-14/docs-2.json
return [ 'version' => '2.0', 'service' => '<p> <b>Introduction</b> </p> <p>The Amazon Interactive Video Service (IVS) API is REST compatible, using a standard HTTP API and an Amazon Web Services EventBridge event stream for responses. JSON is used for both requests and responses, including errors.</p> <p>The API is an Amazon Web Services regional service. For a list of supported regions and Amazon IVS HTTPS service endpoints, see the <a href="https://docs.aws.amazon.com/general/latest/gr/ivs.html">Amazon IVS page</a> in the <i>Amazon Web Services General Reference</i>.</p> <p> <i> <b>All API request parameters and URLs are case sensitive. </b> </i> </p> <p>For a summary of notable documentation changes in each release, see <a href="https://docs.aws.amazon.com/ivs/latest/userguide/doc-history.html"> Document History</a>.</p> <p> <b>Allowed Header Values</b> </p> <ul> <li> <p> <code> <b>Accept:</b> </code> application/json</p> </li> <li> <p> <code> <b>Accept-Encoding:</b> </code> gzip, deflate</p> </li> <li> <p> <code> <b>Content-Type:</b> </code>application/json</p> </li> </ul> <p> <b>Key Concepts</b> </p> <ul> <li> <p> <b>Channel</b> — Stores configuration data related to your live stream. You first create a channel and then use the channel’s stream key to start your live stream.</p> </li> <li> <p> <b>Stream key</b> — An identifier assigned by Amazon IVS when you create a channel, which is then used to authorize streaming. <i> <b>Treat the stream key like a secret, since it allows anyone to stream to the channel.</b> </i> </p> </li> <li> <p> <b>Playback key pair</b> — Video playback may be restricted using playback-authorization tokens, which use public-key encryption. A playback key pair is the public-private pair of keys used to sign and validate the playback-authorization token.</p> </li> <li> <p> <b>Recording configuration</b> — Stores configuration related to recording a live stream and where to store the recorded content. Multiple channels can reference the same recording configuration.</p> </li> <li> <p> <b>Playback restriction policy</b> — Restricts playback by countries and/or origin sites.</p> </li> </ul> <p>For more information about your IVS live stream, also see <a href="https://docs.aws.amazon.com/ivs/latest/LowLatencyUserGuide/getting-started.html">Getting Started with IVS Low-Latency Streaming</a>.</p> <p> <b>Tagging</b> </p> <p>A <i>tag</i> is a metadata label that you assign to an Amazon Web Services resource. A tag comprises a <i>key</i> and a <i>value</i>, both set by you. For example, you might set a tag as <code>topic:nature</code> to label a particular video category. See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a> for more information, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no service-specific constraints beyond what is documented there.</p> <p>Tags can help you identify and organize your Amazon Web Services resources. For example, you can use the same tag for different resources to indicate that they are related. You can also use tags to manage access (see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html"> Access Tags</a>). </p> <p>The Amazon IVS API has these tag-related endpoints: <a>TagResource</a>, <a>UntagResource</a>, and <a>ListTagsForResource</a>. The following resources support tagging: Channels, Stream Keys, Playback Key Pairs, and Recording Configurations.</p> <p>At most 50 tags can be applied to a resource. </p> <p> <b>Authentication versus Authorization</b> </p> <p>Note the differences between these concepts:</p> <ul> <li> <p> <i>Authentication</i> is about verifying identity. You need to be authenticated to sign Amazon IVS API requests.</p> </li> <li> <p> <i>Authorization</i> is about granting permissions. Your IAM roles need to have permissions for Amazon IVS API requests. In addition, authorization is needed to view <a href="https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html">Amazon IVS private channels</a>. (Private channels are channels that are enabled for "playback authorization.")</p> </li> </ul> <p> <b>Authentication</b> </p> <p>All Amazon IVS API requests must be authenticated with a signature. The Amazon Web Services Command-Line Interface (CLI) and Amazon IVS Player SDKs take care of signing the underlying API calls for you. However, if your application calls the Amazon IVS API directly, it’s your responsibility to sign the requests.</p> <p>You generate a signature using valid Amazon Web Services credentials that have permission to perform the requested action. For example, you must sign PutMetadata requests with a signature generated from a user account that has the <code>ivs:PutMetadata</code> permission.</p> <p>For more information:</p> <ul> <li> <p>Authentication and generating signatures — See <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sig-v4-authenticating-requests.html">Authenticating Requests (Amazon Web Services Signature Version 4)</a> in the <i>Amazon Web Services General Reference</i>.</p> </li> <li> <p>Managing Amazon IVS permissions — See <a href="https://docs.aws.amazon.com/ivs/latest/userguide/security-iam.html">Identity and Access Management</a> on the Security page of the <i>Amazon IVS User Guide</i>.</p> </li> </ul> <p> <b>Amazon Resource Names (ARNs)</b> </p> <p>ARNs uniquely identify AWS resources. An ARN is required when you need to specify a resource unambiguously across all of AWS, such as in IAM policies and API calls. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names</a> in the <i>AWS General Reference</i>.</p> <p> <b>Channel Endpoints</b> </p> <ul> <li> <p> <a>CreateChannel</a> — Creates a new channel and an associated stream key to start streaming.</p> </li> <li> <p> <a>GetChannel</a> — Gets the channel configuration for the specified channel ARN.</p> </li> <li> <p> <a>BatchGetChannel</a> — Performs <a>GetChannel</a> on multiple ARNs simultaneously.</p> </li> <li> <p> <a>ListChannels</a> — Gets summary information about all channels in your account, in the Amazon Web Services region where the API request is processed. This list can be filtered to match a specified name or recording-configuration ARN. Filters are mutually exclusive and cannot be used together. If you try to use both filters, you will get an error (409 Conflict Exception).</p> </li> <li> <p> <a>UpdateChannel</a> — Updates a channel\'s configuration. This does not affect an ongoing stream of this channel. You must stop and restart the stream for the changes to take effect.</p> </li> <li> <p> <a>DeleteChannel</a> — Deletes the specified channel.</p> </li> </ul> <p> <b>Playback Restriction Policy Endpoints</b> </p> <ul> <li> <p> <a>CreatePlaybackRestrictionPolicy</a> — Creates a new playback restriction policy, for constraining playback by countries and/or origins.</p> </li> <li> <p> <a>DeletePlaybackRestrictionPolicy</a> — Deletes the specified playback restriction policy</p> </li> <li> <p> <a>GetPlaybackRestrictionPolicy</a> — Gets the specified playback restriction policy.</p> </li> <li> <p> <a>ListPlaybackRestrictionPolicies</a> — Gets summary information about playback restriction policies.</p> </li> <li> <p> <a>UpdatePlaybackRestrictionPolicy</a> — Updates a specified playback restriction policy.</p> </li> </ul> <p> <b>Private Channel Endpoints</b> </p> <p>For more information, see <a href="https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html">Setting Up Private Channels</a> in the <i>Amazon IVS User Guide</i>.</p> <ul> <li> <p> <a>ImportPlaybackKeyPair</a> — Imports the public portion of a new key pair and returns its <code>arn</code> and <code>fingerprint</code>. The <code>privateKey</code> can then be used to generate viewer authorization tokens, to grant viewers access to private channels (channels enabled for playback authorization).</p> </li> <li> <p> <a>GetPlaybackKeyPair</a> — Gets a specified playback authorization key pair and returns the <code>arn</code> and <code>fingerprint</code>. The <code>privateKey</code> held by the caller can be used to generate viewer authorization tokens, to grant viewers access to private channels.</p> </li> <li> <p> <a>ListPlaybackKeyPairs</a> — Gets summary information about playback key pairs.</p> </li> <li> <p> <a>DeletePlaybackKeyPair</a> — Deletes a specified authorization key pair. This invalidates future viewer tokens generated using the key pair’s <code>privateKey</code>.</p> </li> <li> <p> <a>StartViewerSessionRevocation</a> — Starts the process of revoking the viewer session associated with a specified channel ARN and viewer ID. Optionally, you can provide a version to revoke viewer sessions less than and including that version.</p> </li> <li> <p> <a>BatchStartViewerSessionRevocation</a> — Performs <a>StartViewerSessionRevocation</a> on multiple channel ARN and viewer ID pairs simultaneously.</p> </li> </ul> <p> <b>Recording Configuration Endpoints</b> </p> <ul> <li> <p> <a>CreateRecordingConfiguration</a> — Creates a new recording configuration, used to enable recording to Amazon S3.</p> </li> <li> <p> <a>GetRecordingConfiguration</a> — Gets the recording-configuration metadata for the specified ARN.</p> </li> <li> <p> <a>ListRecordingConfigurations</a> — Gets summary information about all recording configurations in your account, in the Amazon Web Services region where the API request is processed.</p> </li> <li> <p> <a>DeleteRecordingConfiguration</a> — Deletes the recording configuration for the specified ARN.</p> </li> </ul> <p> <b>Stream Endpoints</b> </p> <ul> <li> <p> <a>GetStream</a> — Gets information about the active (live) stream on a specified channel.</p> </li> <li> <p> <a>GetStreamSession</a> — Gets metadata on a specified stream.</p> </li> <li> <p> <a>ListStreams</a> — Gets summary information about live streams in your account, in the Amazon Web Services region where the API request is processed.</p> </li> <li> <p> <a>ListStreamSessions</a> — Gets a summary of current and previous streams for a specified channel in your account, in the AWS region where the API request is processed.</p> </li> <li> <p> <a>StopStream</a> — Disconnects the incoming RTMPS stream for the specified channel. Can be used in conjunction with <a>DeleteStreamKey</a> to prevent further streaming to a channel.</p> </li> <li> <p> <a>PutMetadata</a> — Inserts metadata into the active stream of the specified channel. At most 5 requests per second per channel are allowed, each with a maximum 1 KB payload. (If 5 TPS is not sufficient for your needs, we recommend batching your data into a single PutMetadata call.) At most 155 requests per second per account are allowed.</p> </li> </ul> <p> <b>Stream Key Endpoints</b> </p> <ul> <li> <p> <a>CreateStreamKey</a> — Creates a stream key, used to initiate a stream, for the specified channel ARN.</p> </li> <li> <p> <a>GetStreamKey</a> — Gets stream key information for the specified ARN.</p> </li> <li> <p> <a>BatchGetStreamKey</a> — Performs <a>GetStreamKey</a> on multiple ARNs simultaneously.</p> </li> <li> <p> <a>ListStreamKeys</a> — Gets summary information about stream keys for the specified channel.</p> </li> <li> <p> <a>DeleteStreamKey</a> — Deletes the stream key for the specified ARN, so it can no longer be used to stream.</p> </li> </ul> <p> <b>Amazon Web Services Tags Endpoints</b> </p> <ul> <li> <p> <a>TagResource</a> — Adds or updates tags for the Amazon Web Services resource with the specified ARN.</p> </li> <li> <p> <a>UntagResource</a> — Removes tags from the resource with the specified ARN.</p> </li> <li> <p> <a>ListTagsForResource</a> — Gets information about Amazon Web Services tags for the specified ARN.</p> </li> </ul>', 'operations' => [ 'BatchGetChannel' => '<p>Performs <a>GetChannel</a> on multiple ARNs simultaneously.</p>', 'BatchGetStreamKey' => '<p>Performs <a>GetStreamKey</a> on multiple ARNs simultaneously.</p>', 'BatchStartViewerSessionRevocation' => '<p>Performs <a>StartViewerSessionRevocation</a> on multiple channel ARN and viewer ID pairs simultaneously.</p>', 'CreateChannel' => '<p>Creates a new channel and an associated stream key to start streaming.</p>', 'CreatePlaybackRestrictionPolicy' => '<p>Creates a new playback restriction policy, for constraining playback by countries and/or origins.</p>', 'CreateRecordingConfiguration' => '<p>Creates a new recording configuration, used to enable recording to Amazon S3.</p> <p> <b>Known issue:</b> In the us-east-1 region, if you use the Amazon Web Services CLI to create a recording configuration, it returns success even if the S3 bucket is in a different region. In this case, the <code>state</code> of the recording configuration is <code>CREATE_FAILED</code> (instead of <code>ACTIVE</code>). (In other regions, the CLI correctly returns failure if the bucket is in a different region.)</p> <p> <b>Workaround:</b> Ensure that your S3 bucket is in the same region as the recording configuration. If you create a recording configuration in a different region as your S3 bucket, delete that recording configuration and create a new one with an S3 bucket from the correct region.</p>', 'CreateStreamKey' => '<p>Creates a stream key, used to initiate a stream, for the specified channel ARN.</p> <p>Note that <a>CreateChannel</a> creates a stream key. If you subsequently use CreateStreamKey on the same channel, it will fail because a stream key already exists and there is a limit of 1 stream key per channel. To reset the stream key on a channel, use <a>DeleteStreamKey</a> and then CreateStreamKey.</p>', 'DeleteChannel' => '<p>Deletes the specified channel and its associated stream keys.</p> <p>If you try to delete a live channel, you will get an error (409 ConflictException). To delete a channel that is live, call <a>StopStream</a>, wait for the Amazon EventBridge "Stream End" event (to verify that the stream\'s state is no longer Live), then call DeleteChannel. (See <a href="https://docs.aws.amazon.com/ivs/latest/userguide/eventbridge.html"> Using EventBridge with Amazon IVS</a>.) </p>', 'DeletePlaybackKeyPair' => '<p>Deletes a specified authorization key pair. This invalidates future viewer tokens generated using the key pair’s <code>privateKey</code>. For more information, see <a href="https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html">Setting Up Private Channels</a> in the <i>Amazon IVS User Guide</i>.</p>', 'DeletePlaybackRestrictionPolicy' => '<p>Deletes the specified playback restriction policy.</p>', 'DeleteRecordingConfiguration' => '<p>Deletes the recording configuration for the specified ARN.</p> <p>If you try to delete a recording configuration that is associated with a channel, you will get an error (409 ConflictException). To avoid this, for all channels that reference the recording configuration, first use <a>UpdateChannel</a> to set the <code>recordingConfigurationArn</code> field to an empty string, then use DeleteRecordingConfiguration.</p>', 'DeleteStreamKey' => '<p>Deletes the stream key for the specified ARN, so it can no longer be used to stream.</p>', 'GetChannel' => '<p>Gets the channel configuration for the specified channel ARN. See also <a>BatchGetChannel</a>.</p>', 'GetPlaybackKeyPair' => '<p>Gets a specified playback authorization key pair and returns the <code>arn</code> and <code>fingerprint</code>. The <code>privateKey</code> held by the caller can be used to generate viewer authorization tokens, to grant viewers access to private channels. For more information, see <a href="https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html">Setting Up Private Channels</a> in the <i>Amazon IVS User Guide</i>.</p>', 'GetPlaybackRestrictionPolicy' => '<p>Gets the specified playback restriction policy.</p>', 'GetRecordingConfiguration' => '<p>Gets the recording configuration for the specified ARN.</p>', 'GetStream' => '<p>Gets information about the active (live) stream on a specified channel.</p>', 'GetStreamKey' => '<p>Gets stream-key information for a specified ARN.</p>', 'GetStreamSession' => '<p>Gets metadata on a specified stream.</p>', 'ImportPlaybackKeyPair' => '<p>Imports the public portion of a new key pair and returns its <code>arn</code> and <code>fingerprint</code>. The <code>privateKey</code> can then be used to generate viewer authorization tokens, to grant viewers access to private channels. For more information, see <a href="https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html">Setting Up Private Channels</a> in the <i>Amazon IVS User Guide</i>.</p>', 'ListChannels' => '<p>Gets summary information about all channels in your account, in the Amazon Web Services region where the API request is processed. This list can be filtered to match a specified name or recording-configuration ARN. Filters are mutually exclusive and cannot be used together. If you try to use both filters, you will get an error (409 ConflictException).</p>', 'ListPlaybackKeyPairs' => '<p>Gets summary information about playback key pairs. For more information, see <a href="https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html">Setting Up Private Channels</a> in the <i>Amazon IVS User Guide</i>.</p>', 'ListPlaybackRestrictionPolicies' => '<p>Gets summary information about playback restriction policies.</p>', 'ListRecordingConfigurations' => '<p>Gets summary information about all recording configurations in your account, in the Amazon Web Services region where the API request is processed.</p>', 'ListStreamKeys' => '<p>Gets summary information about stream keys for the specified channel.</p>', 'ListStreamSessions' => '<p>Gets a summary of current and previous streams for a specified channel in your account, in the AWS region where the API request is processed.</p>', 'ListStreams' => '<p>Gets summary information about live streams in your account, in the Amazon Web Services region where the API request is processed.</p>', 'ListTagsForResource' => '<p>Gets information about Amazon Web Services tags for the specified ARN.</p>', 'PutMetadata' => '<p>Inserts metadata into the active stream of the specified channel. At most 5 requests per second per channel are allowed, each with a maximum 1 KB payload. (If 5 TPS is not sufficient for your needs, we recommend batching your data into a single PutMetadata call.) At most 155 requests per second per account are allowed. Also see <a href="https://docs.aws.amazon.com/ivs/latest/userguide/metadata.html">Embedding Metadata within a Video Stream</a> in the <i>Amazon IVS User Guide</i>.</p>', 'StartViewerSessionRevocation' => '<p>Starts the process of revoking the viewer session associated with a specified channel ARN and viewer ID. Optionally, you can provide a version to revoke viewer sessions less than and including that version. For instructions on associating a viewer ID with a viewer session, see <a href="https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html">Setting Up Private Channels</a>.</p>', 'StopStream' => '<p>Disconnects the incoming RTMPS stream for the specified channel. Can be used in conjunction with <a>DeleteStreamKey</a> to prevent further streaming to a channel.</p> <note> <p>Many streaming client-software libraries automatically reconnect a dropped RTMPS session, so to stop the stream permanently, you may want to first revoke the <code>streamKey</code> attached to the channel.</p> </note>', 'TagResource' => '<p>Adds or updates tags for the Amazon Web Services resource with the specified ARN.</p>', 'UntagResource' => '<p>Removes tags from the resource with the specified ARN.</p>', 'UpdateChannel' => '<p>Updates a channel\'s configuration. Live channels cannot be updated. You must stop the ongoing stream, update the channel, and restart the stream for the changes to take effect.</p>', 'UpdatePlaybackRestrictionPolicy' => '<p>Updates a specified playback restriction policy.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p/>', 'refs' => [], ], 'AudioConfiguration' => [ 'base' => '<p>Object specifying a stream’s audio configuration, as set up by the broadcaster (usually in an encoder). This is part of the <a>IngestConfiguration</a> object and used for monitoring stream health.</p>', 'refs' => [ 'IngestConfiguration$audio' => '<p>Encoder settings for audio.</p>', ], ], 'BatchError' => [ 'base' => '<p>Error related to a specific channel, specified by its ARN.</p>', 'refs' => [ 'BatchErrors$member' => NULL, ], ], 'BatchErrors' => [ 'base' => NULL, 'refs' => [ 'BatchGetChannelResponse$errors' => '<p>Each error object is related to a specific ARN in the request.</p>', 'BatchGetStreamKeyResponse$errors' => '<p/>', ], ], 'BatchGetChannelRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetChannelResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetStreamKeyRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetStreamKeyResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchStartViewerSessionRevocationError' => [ 'base' => '<p>Error for a request in the batch for BatchStartViewerSessionRevocation. Each error is related to a specific channel-ARN and viewer-ID pair.</p>', 'refs' => [ 'BatchStartViewerSessionRevocationErrors$member' => NULL, ], ], 'BatchStartViewerSessionRevocationErrors' => [ 'base' => NULL, 'refs' => [ 'BatchStartViewerSessionRevocationResponse$errors' => '<p>Each error object is related to a specific <code>channelArn</code> and <code>viewerId</code> pair in the request.</p>', ], ], 'BatchStartViewerSessionRevocationRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchStartViewerSessionRevocationResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchStartViewerSessionRevocationViewerSession' => [ 'base' => '<p>A viewer session to revoke in the call to <a>BatchStartViewerSessionRevocation</a>.</p>', 'refs' => [ 'BatchStartViewerSessionRevocationViewerSessionList$member' => NULL, ], ], 'BatchStartViewerSessionRevocationViewerSessionList' => [ 'base' => NULL, 'refs' => [ 'BatchStartViewerSessionRevocationRequest$viewerSessions' => '<p>Array of viewer sessions, one per channel-ARN and viewer-ID pair.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'CreateChannelRequest$authorized' => '<p>Whether the channel is private (enabled for playback authorization). Default: <code>false</code>.</p>', 'CreateChannelRequest$insecureIngest' => '<p>Whether the channel allows insecure RTMP and SRT ingest. Default: <code>false</code>.</p>', 'StreamSessionSummary$hasErrorEvent' => '<p>If <code>true</code>, this stream encountered a quota breach or failure.</p>', 'UpdateChannelRequest$authorized' => '<p>Whether the channel is private (enabled for playback authorization).</p>', 'UpdateChannelRequest$insecureIngest' => '<p>Whether the channel allows insecure RTMP and SRT ingest. Default: <code>false</code>.</p>', ], ], 'Channel' => [ 'base' => '<p>Object specifying a channel.</p>', 'refs' => [ 'Channels$member' => NULL, 'CreateChannelResponse$channel' => '<p/>', 'GetChannelResponse$channel' => '<p/>', 'StreamSession$channel' => '<p>The properties of the channel at the time of going live.</p>', 'UpdateChannelResponse$channel' => '<p>Object specifying the updated channel.</p>', ], ], 'ChannelArn' => [ 'base' => NULL, 'refs' => [ 'BatchStartViewerSessionRevocationError$channelArn' => '<p>Channel ARN.</p>', 'BatchStartViewerSessionRevocationViewerSession$channelArn' => '<p>The ARN of the channel associated with the viewer session to revoke.</p>', 'Channel$arn' => '<p>Channel ARN.</p>', 'ChannelArnList$member' => NULL, 'ChannelSummary$arn' => '<p>Channel ARN.</p>', 'CreateStreamKeyRequest$channelArn' => '<p>ARN of the channel for which to create the stream key.</p>', 'DeleteChannelRequest$arn' => '<p>ARN of the channel to be deleted.</p>', 'GetChannelRequest$arn' => '<p>ARN of the channel for which the configuration is to be retrieved.</p>', 'GetStreamRequest$channelArn' => '<p>Channel ARN for stream to be accessed.</p>', 'GetStreamSessionRequest$channelArn' => '<p>ARN of the channel resource</p>', 'ListStreamKeysRequest$channelArn' => '<p>Channel ARN used to filter the list.</p>', 'ListStreamSessionsRequest$channelArn' => '<p>Channel ARN used to filter the list.</p>', 'PutMetadataRequest$channelArn' => '<p>ARN of the channel into which metadata is inserted. This channel must have an active stream.</p>', 'StartViewerSessionRevocationRequest$channelArn' => '<p>The ARN of the channel associated with the viewer session to revoke.</p>', 'StopStreamRequest$channelArn' => '<p>ARN of the channel for which the stream is to be stopped.</p>', 'Stream$channelArn' => '<p>Channel ARN for the stream.</p>', 'StreamKey$channelArn' => '<p>Channel ARN for the stream.</p>', 'StreamKeySummary$channelArn' => '<p>Channel ARN for the stream.</p>', 'StreamSummary$channelArn' => '<p>Channel ARN for the stream.</p>', 'UpdateChannelRequest$arn' => '<p>ARN of the channel to be updated.</p>', ], ], 'ChannelArnList' => [ 'base' => NULL, 'refs' => [ 'BatchGetChannelRequest$arns' => '<p>Array of ARNs, one per channel.</p>', ], ], 'ChannelLatencyMode' => [ 'base' => NULL, 'refs' => [ 'Channel$latencyMode' => '<p>Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to Full HD. Use <code>LOW</code> for near-real-time interaction with viewers. Default: <code>LOW</code>.</p>', 'ChannelSummary$latencyMode' => '<p>Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to Full HD. Use <code>LOW</code> for near-real-time interaction with viewers. Default: <code>LOW</code>.</p>', 'CreateChannelRequest$latencyMode' => '<p>Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to Full HD. Use <code>LOW</code> for near-real-time interaction with viewers. Default: <code>LOW</code>.</p>', 'UpdateChannelRequest$latencyMode' => '<p>Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to Full HD. Use <code>LOW</code> for near-real-time interaction with viewers.</p>', ], ], 'ChannelList' => [ 'base' => NULL, 'refs' => [ 'ListChannelsResponse$channels' => '<p>List of the matching channels.</p>', ], ], 'ChannelName' => [ 'base' => NULL, 'refs' => [ 'Channel$name' => '<p>Channel name.</p>', 'ChannelSummary$name' => '<p>Channel name.</p>', 'CreateChannelRequest$name' => '<p>Channel name.</p>', 'ListChannelsRequest$filterByName' => '<p>Filters the channel list to match the specified name.</p>', 'UpdateChannelRequest$name' => '<p>Channel name.</p>', ], ], 'ChannelNotBroadcasting' => [ 'base' => '<p/>', 'refs' => [], ], 'ChannelPlaybackRestrictionPolicyArn' => [ 'base' => NULL, 'refs' => [ 'Channel$playbackRestrictionPolicyArn' => '<p>Playback-restriction-policy ARN. A valid ARN value here both specifies the ARN and enables playback restriction. Default: "" (empty string, no playback restriction policy is applied).</p>', 'ChannelSummary$playbackRestrictionPolicyArn' => '<p>Playback-restriction-policy ARN. A valid ARN value here both specifies the ARN and enables playback restriction. Default: "" (empty string, no playback restriction policy is applied).</p>', 'CreateChannelRequest$playbackRestrictionPolicyArn' => '<p>Playback-restriction-policy ARN. A valid ARN value here both specifies the ARN and enables playback restriction. Default: "" (empty string, no playback restriction policy is applied).</p>', 'ListChannelsRequest$filterByPlaybackRestrictionPolicyArn' => '<p>Filters the channel list to match the specified policy.</p>', 'UpdateChannelRequest$playbackRestrictionPolicyArn' => '<p>Playback-restriction-policy ARN. A valid ARN value here both specifies the ARN and enables playback restriction. If this is set to an empty string, playback restriction policy is disabled.</p>', ], ], 'ChannelRecordingConfigurationArn' => [ 'base' => NULL, 'refs' => [ 'Channel$recordingConfigurationArn' => '<p>Recording-configuration ARN. A valid ARN value here both specifies the ARN and enables recording. Default: "" (empty string, recording is disabled).</p>', 'ChannelSummary$recordingConfigurationArn' => '<p>Recording-configuration ARN. A valid ARN value here both specifies the ARN and enables recording. Default: "" (empty string, recording is disabled).</p>', 'CreateChannelRequest$recordingConfigurationArn' => '<p>Recording-configuration ARN. A valid ARN value here both specifies the ARN and enables recording. Default: "" (empty string, recording is disabled).</p>', 'ListChannelsRequest$filterByRecordingConfigurationArn' => '<p>Filters the channel list to match the specified recording-configuration ARN.</p>', 'UpdateChannelRequest$recordingConfigurationArn' => '<p>Recording-configuration ARN. A valid ARN value here both specifies the ARN and enables recording. If this is set to an empty string, recording is disabled.</p>', ], ], 'ChannelSummary' => [ 'base' => '<p>Summary information about a channel.</p>', 'refs' => [ 'ChannelList$member' => NULL, ], ], 'ChannelType' => [ 'base' => NULL, 'refs' => [ 'Channel$type' => '<p>Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable input resolution or bitrate, the stream probably will disconnect immediately.</i> Default: <code>STANDARD</code>. For details, see <a href="https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/channel-types.html">Channel Types</a>.</p>', 'ChannelSummary$type' => '<p>Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable input resolution or bitrate, the stream probably will disconnect immediately.</i> Default: <code>STANDARD</code>. For details, see <a href="https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/channel-types.html">Channel Types</a>.</p>', 'CreateChannelRequest$type' => '<p>Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable input resolution or bitrate, the stream probably will disconnect immediately.</i> Default: <code>STANDARD</code>. For details, see <a href="https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/channel-types.html">Channel Types</a>.</p>', 'UpdateChannelRequest$type' => '<p>Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable input resolution or bitrate, the stream probably will disconnect immediately.</i> Default: <code>STANDARD</code>. For details, see <a href="https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/channel-types.html">Channel Types</a>.</p>', ], ], 'Channels' => [ 'base' => NULL, 'refs' => [ 'BatchGetChannelResponse$channels' => '<p/>', ], ], 'ConflictException' => [ 'base' => '<p/>', 'refs' => [], ], 'CreateChannelRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateChannelResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreatePlaybackRestrictionPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreatePlaybackRestrictionPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateRecordingConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateRecordingConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateStreamKeyRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateStreamKeyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteChannelRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletePlaybackKeyPairRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletePlaybackKeyPairResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeletePlaybackRestrictionPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRecordingConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStreamKeyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DestinationConfiguration' => [ 'base' => '<p>A complex type that describes a location where recorded videos will be stored. Each member represents a type of destination configuration. For recording, you define one and only one type of destination configuration.</p>', 'refs' => [ 'CreateRecordingConfigurationRequest$destinationConfiguration' => '<p>A complex type that contains a destination configuration for where recorded video will be stored.</p>', 'RecordingConfiguration$destinationConfiguration' => '<p>A complex type that contains information about where recorded video will be stored.</p>', 'RecordingConfigurationSummary$destinationConfiguration' => '<p>A complex type that contains information about where recorded video will be stored.</p>', ], ], 'GetChannelRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetChannelResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetPlaybackKeyPairRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetPlaybackKeyPairResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetPlaybackRestrictionPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetPlaybackRestrictionPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetRecordingConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetRecordingConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetStreamKeyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetStreamKeyResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetStreamRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetStreamResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetStreamSessionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetStreamSessionResponse' => [ 'base' => NULL, 'refs' => [], ], 'ImportPlaybackKeyPairRequest' => [ 'base' => NULL, 'refs' => [], ], 'ImportPlaybackKeyPairResponse' => [ 'base' => NULL, 'refs' => [], ], 'IngestConfiguration' => [ 'base' => '<p>Object specifying the ingest configuration set up by the broadcaster, usually in an encoder.</p>', 'refs' => [ 'StreamSession$ingestConfiguration' => '<p>The properties of the incoming RTMP stream for the stream.</p>', ], ], 'IngestEndpoint' => [ 'base' => NULL, 'refs' => [ 'Channel$ingestEndpoint' => '<p>Channel ingest endpoint, part of the definition of an ingest server, used when you set up streaming software.</p>', ], ], 'InsecureIngest' => [ 'base' => NULL, 'refs' => [ 'Channel$insecureIngest' => '<p>Whether the channel allows insecure RTMP ingest. Default: <code>false</code>.</p>', 'ChannelSummary$insecureIngest' => '<p>Whether the channel allows insecure RTMP ingest. Default: <code>false</code>.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'AudioConfiguration$channels' => '<p>Number of audio channels.</p>', 'AudioConfiguration$sampleRate' => '<p>Number of audio samples recorded per second.</p>', 'AudioConfiguration$targetBitrate' => '<p>The expected ingest bitrate (bits per second). This is configured in the encoder.</p>', 'VideoConfiguration$targetBitrate' => '<p>The expected ingest bitrate (bits per second). This is configured in the encoder.</p>', 'VideoConfiguration$targetFramerate' => '<p>The expected ingest framerate. This is configured in the encoder.</p>', 'VideoConfiguration$videoHeight' => '<p>Video-resolution height in pixels.</p>', 'VideoConfiguration$videoWidth' => '<p>Video-resolution width in pixels.</p>', ], ], 'InternalServerException' => [ 'base' => '<p/>', 'refs' => [], ], 'IsAuthorized' => [ 'base' => NULL, 'refs' => [ 'Channel$authorized' => '<p>Whether the channel is private (enabled for playback authorization). Default: <code>false</code>.</p>', 'ChannelSummary$authorized' => '<p>Whether the channel is private (enabled for playback authorization). Default: <code>false</code>.</p>', ], ], 'ListChannelsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListChannelsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPlaybackKeyPairsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPlaybackKeyPairsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPlaybackRestrictionPoliciesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPlaybackRestrictionPoliciesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListRecordingConfigurationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRecordingConfigurationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListStreamKeysRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListStreamKeysResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListStreamSessionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListStreamSessionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListStreamsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListStreamsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'MaxChannelResults' => [ 'base' => NULL, 'refs' => [ 'ListChannelsRequest$maxResults' => '<p>Maximum number of channels to return. Default: 100.</p>', ], ], 'MaxPlaybackKeyPairResults' => [ 'base' => NULL, 'refs' => [ 'ListPlaybackKeyPairsRequest$maxResults' => '<p>Maximum number of key pairs to return. Default: your service quota or 100, whichever is smaller.</p>', ], ], 'MaxPlaybackRestrictionPolicyResults' => [ 'base' => NULL, 'refs' => [ 'ListPlaybackRestrictionPoliciesRequest$maxResults' => '<p>Maximum number of policies to return. Default: 1.</p>', ], ], 'MaxRecordingConfigurationResults' => [ 'base' => NULL, 'refs' => [ 'ListRecordingConfigurationsRequest$maxResults' => '<p>Maximum number of recording configurations to return. Default: your service quota or 100, whichever is smaller. </p>', ], ], 'MaxStreamKeyResults' => [ 'base' => NULL, 'refs' => [ 'ListStreamKeysRequest$maxResults' => '<p>Maximum number of streamKeys to return. Default: 1.</p>', ], ], 'MaxStreamResults' => [ 'base' => NULL, 'refs' => [ 'ListStreamSessionsRequest$maxResults' => '<p>Maximum number of streams to return. Default: 100.</p>', 'ListStreamsRequest$maxResults' => '<p>Maximum number of streams to return. Default: 100.</p>', ], ], 'PaginationToken' => [ 'base' => NULL, 'refs' => [ 'ListChannelsRequest$nextToken' => '<p>The first channel to retrieve. This is used for pagination; see the <code>nextToken</code> response field.</p>', 'ListChannelsResponse$nextToken' => '<p>If there are more channels than <code>maxResults</code>, use <code>nextToken</code> in the request to get the next set.</p>', 'ListPlaybackKeyPairsRequest$nextToken' => '<p>The first key pair to retrieve. This is used for pagination; see the <code>nextToken</code> response field.</p>', 'ListPlaybackKeyPairsResponse$nextToken' => '<p>If there are more key pairs than <code>maxResults</code>, use <code>nextToken</code> in the request to get the next set.</p>', 'ListPlaybackRestrictionPoliciesRequest$nextToken' => '<p>The first policy to retrieve. This is used for pagination; see the <code>nextToken</code> response field.</p>', 'ListPlaybackRestrictionPoliciesResponse$nextToken' => '<p>If there are more channels than <code>maxResults</code>, use <code>nextToken</code> in the request to get the next set.</p>', 'ListRecordingConfigurationsRequest$nextToken' => '<p>The first recording configuration to retrieve. This is used for pagination; see the <code>nextToken</code> response field.</p>', 'ListRecordingConfigurationsResponse$nextToken' => '<p>If there are more recording configurations than <code>maxResults</code>, use <code>nextToken</code> in the request to get the next set.</p>', 'ListStreamKeysRequest$nextToken' => '<p>The first stream key to retrieve. This is used for pagination; see the <code>nextToken</code> response field.</p>', 'ListStreamKeysResponse$nextToken' => '<p>If there are more stream keys than <code>maxResults</code>, use <code>nextToken</code> in the request to get the next set.</p>', 'ListStreamSessionsRequest$nextToken' => '<p>The first stream to retrieve. This is used for pagination; see the <code>nextToken</code> response field.</p>', 'ListStreamSessionsResponse$nextToken' => '<p>If there are more streams than <code>maxResults</code>, use <code>nextToken</code> in the request to get the next set.</p>', 'ListStreamsRequest$nextToken' => '<p>The first stream to retrieve. This is used for pagination; see the <code>nextToken</code> response field.</p>', 'ListStreamsResponse$nextToken' => '<p>If there are more streams than <code>maxResults</code>, use <code>nextToken</code> in the request to get the next set.</p>', ], ], 'PendingVerification' => [ 'base' => '<p/>', 'refs' => [], ], 'PlaybackKeyPair' => [ 'base' => '<p>A key pair used to sign and validate a playback authorization token.</p>', 'refs' => [ 'GetPlaybackKeyPairResponse$keyPair' => '<zonbook></zonbook><xhtml></xhtml>', 'ImportPlaybackKeyPairResponse$keyPair' => '<p/>', ], ], 'PlaybackKeyPairArn' => [ 'base' => NULL, 'refs' => [ 'DeletePlaybackKeyPairRequest$arn' => '<p>ARN of the key pair to be deleted.</p>', 'GetPlaybackKeyPairRequest$arn' => '<p>ARN of the key pair to be returned.</p>', 'PlaybackKeyPair$arn' => '<p>Key-pair ARN.</p>', 'PlaybackKeyPairSummary$arn' => '<p>Key-pair ARN.</p>', ], ], 'PlaybackKeyPairFingerprint' => [ 'base' => NULL, 'refs' => [ 'PlaybackKeyPair$fingerprint' => '<p>Key-pair identifier.</p>', ], ], 'PlaybackKeyPairList' => [ 'base' => NULL, 'refs' => [ 'ListPlaybackKeyPairsResponse$keyPairs' => '<p>List of key pairs.</p>', ], ], 'PlaybackKeyPairName' => [ 'base' => NULL, 'refs' => [ 'ImportPlaybackKeyPairRequest$name' => '<p>Playback-key-pair name. The value does not need to be unique.</p>', 'PlaybackKeyPair$name' => '<p>Playback-key-pair name. The value does not need to be unique.</p>', 'PlaybackKeyPairSummary$name' => '<p>Playback-key-pair name. The value does not need to be unique.</p>', ], ], 'PlaybackKeyPairSummary' => [ 'base' => '<p>Summary information about a playback key pair.</p>', 'refs' => [ 'PlaybackKeyPairList$member' => NULL, ], ], 'PlaybackPublicKeyMaterial' => [ 'base' => NULL, 'refs' => [ 'ImportPlaybackKeyPairRequest$publicKeyMaterial' => '<p>The public portion of a customer-generated key pair.</p>', ], ], 'PlaybackRestrictionPolicy' => [ 'base' => '<p>An object representing a policy to constrain playback by country and/or origin sites.</p>', 'refs' => [ 'CreatePlaybackRestrictionPolicyResponse$playbackRestrictionPolicy' => '<p/>', 'GetPlaybackRestrictionPolicyResponse$playbackRestrictionPolicy' => '<p/>', 'UpdatePlaybackRestrictionPolicyResponse$playbackRestrictionPolicy' => '<p>Object specifying the updated policy.</p>', ], ], 'PlaybackRestrictionPolicyAllowedCountry' => [ 'base' => NULL, 'refs' => [ 'PlaybackRestrictionPolicyAllowedCountryList$member' => NULL, ], ], 'PlaybackRestrictionPolicyAllowedCountryList' => [ 'base' => NULL, 'refs' => [ 'CreatePlaybackRestrictionPolicyRequest$allowedCountries' => '<p>A list of country codes that control geoblocking restriction. Allowed values are the officially assigned <a href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO 3166-1 alpha-2</a> codes. Default: All countries (an empty array).</p>', 'PlaybackRestrictionPolicy$allowedCountries' => '<p>A list of country codes that control geoblocking restriction. Allowed values are the officially assigned <a href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO 3166-1 alpha-2</a> codes. Default: All countries (an empty array).</p>', 'PlaybackRestrictionPolicySummary$allowedCountries' => '<p>A list of country codes that control geoblocking restriction. Allowed values are the officially assigned <a href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO 3166-1 alpha-2</a> codes. Default: All countries (an empty array).</p>', 'UpdatePlaybackRestrictionPolicyRequest$allowedCountries' => '<p>A list of country codes that control geoblocking restriction. Allowed values are the officially assigned <a href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO 3166-1 alpha-2</a> codes. Default: All countries (an empty array).</p>', ], ], 'PlaybackRestrictionPolicyAllowedOrigin' => [ 'base' => NULL, 'refs' => [ 'PlaybackRestrictionPolicyAllowedOriginList$member' => NULL, ], ], 'PlaybackRestrictionPolicyAllowedOriginList' => [ 'base' => NULL, 'refs' => [ 'CreatePlaybackRestrictionPolicyRequest$allowedOrigins' => '<p>A list of origin sites that control CORS restriction. Allowed values are the same as valid values of the Origin header defined at <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Origin">https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Origin</a>. Default: All origins (an empty array).</p>', 'PlaybackRestrictionPolicy$allowedOrigins' => '<p>A list of origin sites that control CORS restriction. Allowed values are the same as valid values of the Origin header defined at <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Origin">https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Origin</a>. Default: All origins (an empty array).</p>', 'PlaybackRestrictionPolicySummary$allowedOrigins' => '<p>A list of origin sites that control CORS restriction. Allowed values are the same as valid values of the Origin header defined at <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Origin">https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Origin</a>. Default: All origins (an empty array).</p>', 'UpdatePlaybackRestrictionPolicyRequest$allowedOrigins' => '<p>A list of origin sites that control CORS restriction. Allowed values are the same as valid values of the Origin header defined at <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Origin">https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Origin</a>. Default: All origins (an empty array).</p>', ], ], 'PlaybackRestrictionPolicyArn' => [ 'base' => NULL, 'refs' => [ 'DeletePlaybackRestrictionPolicyRequest$arn' => '<p>ARN of the playback restriction policy to be deleted.</p>', 'GetPlaybackRestrictionPolicyRequest$arn' => '<p>ARN of the playback restriction policy to be returned.</p>', 'PlaybackRestrictionPolicy$arn' => '<p>Playback-restriction-policy ARN</p>', 'PlaybackRestrictionPolicySummary$arn' => '<p>Playback-restriction-policy ARN</p>', 'UpdatePlaybackRestrictionPolicyRequest$arn' => '<p>ARN of the playback-restriction-policy to be updated.</p>', ], ], 'PlaybackRestrictionPolicyEnableStrictOriginEnforcement' => [ 'base' => NULL, 'refs' => [ 'CreatePlaybackRestrictionPolicyRequest$enableStrictOriginEnforcement' => '<p>Whether channel playback is constrained by origin site. Default: <code>false</code>.</p>', 'PlaybackRestrictionPolicy$enableStrictOriginEnforcement' => '<p>Whether channel playback is constrained by origin site. Default: <code>false</code>.</p>', 'PlaybackRestrictionPolicySummary$enableStrictOriginEnforcement' => '<p>Whether channel playback is constrained by origin site. Default: <code>false</code>.</p>', 'UpdatePlaybackRestrictionPolicyRequest$enableStrictOriginEnforcement' => '<p>Whether channel playback is constrained by origin site. Default: <code>false</code>.</p>', ], ], 'PlaybackRestrictionPolicyList' => [ 'base' => NULL, 'refs' => [ 'ListPlaybackRestrictionPoliciesResponse$playbackRestrictionPolicies' => '<p>List of the matching policies.</p>', ], ], 'PlaybackRestrictionPolicyName' => [ 'base' => NULL, 'refs' => [ 'CreatePlaybackRestrictionPolicyRequest$name' => '<p>Playback-restriction-policy name. The value does not need to be unique.</p>', 'PlaybackRestrictionPolicy$name' => '<p>Playback-restriction-policy name. The value does not need to be unique.</p>', 'PlaybackRestrictionPolicySummary$name' => '<p>Playback-restriction-policy name. The value does not need to be unique.</p>', 'UpdatePlaybackRestrictionPolicyRequest$name' => '<p>Playback-restriction-policy name. The value does not need to be unique.</p>', ], ], 'PlaybackRestrictionPolicySummary' => [ 'base' => '<p>Summary information about a PlaybackRestrictionPolicy.</p>', 'refs' => [ 'PlaybackRestrictionPolicyList$member' => NULL, ], ], 'PlaybackURL' => [ 'base' => NULL, 'refs' => [ 'Channel$playbackUrl' => '<p>Channel playback URL.</p>', 'Stream$playbackUrl' => '<p>URL of the master playlist, required by the video player to play the HLS stream.</p>', ], ], 'PutMetadataRequest' => [ 'base' => NULL, 'refs' => [], ], 'RecordingConfiguration' => [ 'base' => '<p>An object representing a configuration to record a channel stream.</p>', 'refs' => [ 'CreateRecordingConfigurationResponse$recordingConfiguration' => '<zonbook></zonbook><xhtml></xhtml>', 'GetRecordingConfigurationResponse$recordingConfiguration' => '<zonbook></zonbook><xhtml></xhtml>', 'StreamSession$recordingConfiguration' => '<p>The properties of recording the live stream.</p>', ], ], 'RecordingConfigurationArn' => [ 'base' => NULL, 'refs' => [ 'DeleteRecordingConfigurationRequest$arn' => '<p>ARN of the recording configuration to be deleted.</p>', 'GetRecordingConfigurationRequest$arn' => '<p>ARN of the recording configuration to be retrieved.</p>', 'RecordingConfiguration$arn' => '<p>Recording-configuration ARN.</p>', 'RecordingConfigurationSummary$arn' => '<p>Recording-configuration ARN.</p>', ], ], 'RecordingConfigurationList' => [ 'base' => NULL, 'refs' => [ 'ListRecordingConfigurationsResponse$recordingConfigurations' => '<p>List of the matching recording configurations.</p>', ], ], 'RecordingConfigurationName' => [ 'base' => NULL, 'refs' => [ 'CreateRecordingConfigurationRequest$name' => '<p>Recording-configuration name. The value does not need to be unique.</p>', 'RecordingConfiguration$name' => '<p>Recording-configuration name. The value does not need to be unique.</p>', 'RecordingConfigurationSummary$name' => '<p>Recording-configuration name. The value does not need to be unique.</p>', ], ], 'RecordingConfigurationState' => [ 'base' => NULL, 'refs' => [ 'RecordingConfiguration$state' => '<p>Indicates the current state of the recording configuration. When the state is <code>ACTIVE</code>, the configuration is ready for recording a channel stream.</p>', 'RecordingConfigurationSummary$state' => '<p>Indicates the current state of the recording configuration. When the state is <code>ACTIVE</code>, the configuration is ready for recording a channel stream.</p>', ], ], 'RecordingConfigurationSummary' => [ 'base' => '<p>Summary information about a RecordingConfiguration.</p>', 'refs' => [ 'RecordingConfigurationList$member' => NULL, ], ], 'RecordingMode' => [ 'base' => NULL, 'refs' => [ 'ThumbnailConfiguration$recordingMode' => '<p>Thumbnail recording mode. Default: <code>INTERVAL</code>.</p>', ], ], 'RecordingReconnectWindowSeconds' => [ 'base' => NULL, 'refs' => [ 'CreateRecordingConfigurationRequest$recordingReconnectWindowSeconds' => '<p>If a broadcast disconnects and then reconnects within the specified interval, the multiple streams will be considered a single broadcast and merged together. Default: 0.</p>', 'RecordingConfiguration$recordingReconnectWindowSeconds' => '<p>If a broadcast disconnects and then reconnects within the specified interval, the multiple streams will be considered a single broadcast and merged together. Default: 0.</p>', ], ], 'RenditionConfiguration' => [ 'base' => '<p>Object that describes which renditions should be recorded for a stream.</p>', 'refs' => [ 'CreateRecordingConfigurationRequest$renditionConfiguration' => '<p>Object that describes which renditions should be recorded for a stream.</p>', 'RecordingConfiguration$renditionConfiguration' => '<p>Object that describes which renditions should be recorded for a stream.</p>', ], ], 'RenditionConfigurationRendition' => [ 'base' => NULL, 'refs' => [ 'RenditionConfigurationRenditionList$member' => NULL, ], ], 'RenditionConfigurationRenditionList' => [ 'base' => NULL, 'refs' => [ 'RenditionConfiguration$renditions' => '<p>Indicates which renditions are recorded for a stream, if <code>renditionSelection</code> is <code>CUSTOM</code>; otherwise, this field is irrelevant. The selected renditions are recorded if they are available during the stream. If a selected rendition is unavailable, the best available rendition is recorded. For details on the resolution dimensions of each rendition, see <a href="https://docs.aws.amazon.com/ivs/latest/userguide/record-to-s3.html">Auto-Record to Amazon S3</a>.</p>', ], ], 'RenditionConfigurationRenditionSelection' => [ 'base' => NULL, 'refs' => [ 'RenditionConfiguration$renditionSelection' => '<p>Indicates which set of renditions are recorded for a stream. For <code>BASIC</code> channels, the <code>CUSTOM</code> value has no effect. If <code>CUSTOM</code> is specified, a set of renditions must be specified in the <code>renditions</code> field. Default: <code>ALL</code>.</p>', ], ], 'ResourceArn' => [ 'base' => NULL, 'refs' => [ 'BatchError$arn' => '<p>ARN of an IVS resource; e.g., channel.</p>', 'ListTagsForResourceRequest$resourceArn' => '<p>The ARN of the resource to be retrieved. The ARN must be URL-encoded.</p>', 'TagResourceRequest$resourceArn' => '<p>ARN of the resource for which tags are to be added or updated. The ARN must be URL-encoded.</p>', 'UntagResourceRequest$resourceArn' => '<p>ARN of the resource for which tags are to be removed. The ARN must be URL-encoded.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p/>', 'refs' => [], ], 'S3DestinationBucketName' => [ 'base' => NULL, 'refs' => [ 'S3DestinationConfiguration$bucketName' => '<p>Location (S3 bucket name) where recorded videos will be stored.</p>', ], ], 'S3DestinationConfiguration' => [ 'base' => '<p>A complex type that describes an S3 location where recorded videos will be stored.</p>', 'refs' => [ 'DestinationConfiguration$s3' => '<p>An S3 destination configuration where recorded videos will be stored.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p/>', 'refs' => [], ], 'Srt' => [ 'base' => '<p>Specifies information needed to stream using the SRT protocol.</p>', 'refs' => [ 'Channel$srt' => '<p>Specifies the endpoint and optional passphrase for streaming with the SRT protocol.</p>', ], ], 'SrtEndpoint' => [ 'base' => NULL, 'refs' => [ 'Srt$endpoint' => '<p>The endpoint to be used when streaming with IVS using the SRT protocol.</p>', ], ], 'SrtPassphrase' => [ 'base' => NULL, 'refs' => [ 'Srt$passphrase' => '<p>Auto-generated passphrase to enable encryption. This field is applicable only if the end user has <i>not</i> enabled the <code>insecureIngest</code> option for the channel.</p>', ], ], 'StartViewerSessionRevocationRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartViewerSessionRevocationResponse' => [ 'base' => NULL, 'refs' => [], ], 'StopStreamRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopStreamResponse' => [ 'base' => NULL, 'refs' => [], ], 'Stream' => [ 'base' => '<p>Specifies a live video stream that has been ingested and distributed.</p>', 'refs' => [ 'GetStreamResponse$stream' => '<p/>', ], ], 'StreamEvent' => [ 'base' => '<p>Object specifying a stream’s events. For a list of events, see <a href="https://docs.aws.amazon.com/ivs/latest/userguide/eventbridge.html">Using Amazon EventBridge with Amazon IVS</a>.</p>', 'refs' => [ 'StreamEvents$member' => NULL, ], ], 'StreamEvents' => [ 'base' => NULL, 'refs' => [ 'StreamSession$truncatedEvents' => '<p>List of Amazon IVS events that the stream encountered. The list is sorted by most recent events and contains up to 500 events. For Amazon IVS events, see <a href="https://docs.aws.amazon.com/ivs/latest/userguide/eventbridge.html">Using Amazon EventBridge with Amazon IVS</a>.</p>', ], ], 'StreamFilters' => [ 'base' => '<p>Object specifying the stream attribute on which to filter.</p>', 'refs' => [ 'ListStreamsRequest$filterBy' => '<p>Filters the stream list to match the specified criterion.</p>', ], ], 'StreamHealth' => [ 'base' => NULL, 'refs' => [ 'Stream$health' => '<p>The stream’s health.</p>', 'StreamFilters$health' => '<p>The stream’s health.</p>', 'StreamSummary$health' => '<p>The stream’s health.</p>', ], ], 'StreamId' => [ 'base' => NULL, 'refs' => [ 'GetStreamSessionRequest$streamId' => '<p>Unique identifier for a live or previously live stream in the specified channel. If no <code>streamId</code> is provided, this returns the most recent stream session for the channel, if it exists.</p>', 'Stream$streamId' => '<p>Unique identifier for a live or previously live stream in the specified channel.</p>', 'StreamSession$streamId' => '<p>Unique identifier for a live or previously live stream in the specified channel.</p>', 'StreamSessionSummary$streamId' => '<p>Unique identifier for a live or previously live stream in the specified channel.</p>', 'StreamSummary$streamId' => '<p>Unique identifier for a live or previously live stream in the specified channel.</p>', ], ], 'StreamKey' => [ 'base' => '<p>Object specifying a stream key.</p>', 'refs' => [ 'CreateChannelResponse$streamKey' => '<p/>', 'CreateStreamKeyResponse$streamKey' => '<p>Stream key used to authenticate an RTMPS stream for ingestion.</p>', 'GetStreamKeyResponse$streamKey' => '<zonbook></zonbook><xhtml></xhtml>', 'StreamKeys$member' => NULL, ], ], 'StreamKeyArn' => [ 'base' => NULL, 'refs' => [ 'DeleteStreamKeyRequest$arn' => '<p>ARN of the stream key to be deleted.</p>', 'GetStreamKeyRequest$arn' => '<p>ARN for the stream key to be retrieved.</p>', 'StreamKey$arn' => '<p>Stream-key ARN.</p>', 'StreamKeyArnList$member' => NULL, 'StreamKeySummary$arn' => '<p>Stream-key ARN.</p>', ], ], 'StreamKeyArnList' => [ 'base' => NULL, 'refs' => [ 'BatchGetStreamKeyRequest$arns' => '<p>Array of ARNs, one per stream key.</p>', ], ], 'StreamKeyList' => [ 'base' => NULL, 'refs' => [ 'ListStreamKeysResponse$streamKeys' => '<p>List of stream keys.</p>', ], ], 'StreamKeySummary' => [ 'base' => '<p>Summary information about a stream key.</p>', 'refs' => [ 'StreamKeyList$member' => NULL, ], ], 'StreamKeyValue' => [ 'base' => NULL, 'refs' => [ 'StreamKey$value' => '<p>Stream-key value.</p>', ], ], 'StreamKeys' => [ 'base' => NULL, 'refs' => [ 'BatchGetStreamKeyResponse$streamKeys' => '<p/>', ], ], 'StreamList' => [ 'base' => NULL, 'refs' => [ 'ListStreamsResponse$streams' => '<p>List of streams.</p>', ], ], 'StreamMetadata' => [ 'base' => NULL, 'refs' => [ 'PutMetadataRequest$metadata' => '<p>Metadata to insert into the stream. Maximum: 1 KB per request.</p>', ], ], 'StreamSession' => [ 'base' => '<p>Object that captures the Amazon IVS configuration that the customer provisioned, the ingest configurations that the broadcaster used, and the most recent Amazon IVS stream events it encountered.</p>', 'refs' => [ 'GetStreamSessionResponse$streamSession' => '<p>List of stream details.</p>', ], ], 'StreamSessionList' => [ 'base' => NULL, 'refs' => [ 'ListStreamSessionsResponse$streamSessions' => '<p>List of stream sessions.</p>', ], ], 'StreamSessionSummary' => [ 'base' => '<p>Summary information about a stream session.</p>', 'refs' => [ 'StreamSessionList$member' => NULL, ], ], 'StreamStartTime' => [ 'base' => NULL, 'refs' => [ 'Stream$startTime' => '<p>Time of the stream’s start. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>', 'StreamSummary$startTime' => '<p>Time of the stream’s start. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>. </p>', ], ], 'StreamState' => [ 'base' => NULL, 'refs' => [ 'Stream$state' => '<p>The stream’s state. Do not rely on the <code>OFFLINE</code> state, as the API may not return it; instead, a "NotBroadcasting" error will indicate that the stream is not live.</p>', 'StreamSummary$state' => '<p>The stream’s state. Do not rely on the <code>OFFLINE</code> state, as the API may not return it; instead, a "NotBroadcasting" error will indicate that the stream is not live.</p>', ], ], 'StreamSummary' => [ 'base' => '<p>Summary information about a stream.</p>', 'refs' => [ 'StreamList$member' => NULL, ], ], 'StreamUnavailable' => [ 'base' => '<p/>', 'refs' => [], ], 'StreamViewerCount' => [ 'base' => NULL, 'refs' => [ 'Stream$viewerCount' => '<p>A count of concurrent views of the stream. Typically, a new view appears in <code>viewerCount</code> within 15 seconds of when video playback starts and a view is removed from <code>viewerCount</code> within 1 minute of when video playback ends. A value of -1 indicates that the request timed out; in this case, retry.</p>', 'StreamSummary$viewerCount' => '<p>A count of concurrent views of the stream. Typically, a new view appears in <code>viewerCount</code> within 15 seconds of when video playback starts and a view is removed from <code>viewerCount</code> within 1 minute of when video playback ends. A value of -1 indicates that the request timed out; in this case, retry.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AudioConfiguration$codec' => '<p>Codec used for the audio encoding.</p>', 'StreamEvent$name' => '<p>Name that identifies the stream event within a <code>type</code>.</p>', 'StreamEvent$type' => '<p>Logical group for certain events.</p>', 'VideoConfiguration$avcLevel' => '<p>Indicates the degree of required decoder performance for a profile. Normally this is set automatically by the encoder. For details, see the H.264 specification.</p>', 'VideoConfiguration$avcProfile' => '<p>Indicates to the decoder the requirements for decoding the stream. For definitions of the valid values, see the H.264 specification.</p>', 'VideoConfiguration$codec' => '<p>Codec used for the video encoding.</p>', 'VideoConfiguration$encoder' => '<p>Software or hardware used to encode the video.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'Tags$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>Array of tags to be removed. Array of maps, each of the form <code>string:string (key:value)</code>. See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a> for more information, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no service-specific constraints beyond what is documented there.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tags$value' => NULL, ], ], 'Tags' => [ 'base' => NULL, 'refs' => [ 'Channel$tags' => '<p>Tags attached to the resource. Array of 1-50 maps, each of the form <code>string:string (key:value)</code>. See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a> for more information, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no service-specific constraints beyond what is documented there.</p>', 'ChannelSummary$tags' => '<p>Tags attached to the resource. Array of 1-50 maps, each of the form <code>string:string (key:value)</code>. See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a> for more information, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no service-specific constraints beyond what is documented there.</p>', 'CreateChannelRequest$tags' => '<p>Array of 1-50 maps, each of the form <code>string:string (key:value)</code>. See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a> for more information, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no service-specific constraints beyond what is documented there.</p>', 'CreatePlaybackRestrictionPolicyRequest$tags' => '<p>Array of 1-50 maps, each of the form <code>string:string (key:value)</code>. See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a> for more information, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no service-specific constraints beyond what is documented there.</p>', 'CreateRecordingConfigurationRequest$tags' => '<p>Array of 1-50 maps, each of the form <code>string:string (key:value)</code>. See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a> for more information, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no service-specific constraints beyond what is documented there.</p>', 'CreateStreamKeyRequest$tags' => '<p>Array of 1-50 maps, each of the form <code>string:string (key:value)</code>. See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a> for more information, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no service-specific constraints beyond what is documented there.</p>', 'ImportPlaybackKeyPairRequest$tags' => '<p>Any tags provided with the request are added to the playback key pair tags. See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a> for more information, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no service-specific constraints beyond what is documented there.</p>', 'ListTagsForResourceResponse$tags' => '<p>Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>.</p>', 'PlaybackKeyPair$tags' => '<p>Tags attached to the resource. Array of 1-50 maps, each of the form <code>string:string (key:value)</code>. See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a> for more information, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no service-specific constraints beyond what is documented there.</p>', 'PlaybackKeyPairSummary$tags' => '<p>Tags attached to the resource. Array of 1-50 maps, each of the form <code>string:string (key:value)</code>. See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a> for more information, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no service-specific constraints beyond what is documented there.</p>', 'PlaybackRestrictionPolicy$tags' => '<p>Tags attached to the resource. Array of 1-50 maps, each of the form <code>string:string (key:value)</code>. See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a> for more information, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no service-specific constraints beyond what is documented there.</p>', 'PlaybackRestrictionPolicySummary$tags' => '<p>Tags attached to the resource. Array of 1-50 maps, each of the form <code>string:string (key:value)</code>. See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a> for more information, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no service-specific constraints beyond what is documented there.</p>', 'RecordingConfiguration$tags' => '<p>Tags attached to the resource. Array of 1-50 maps, each of the form <code>string:string (key:value)</code>. See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a> for more information, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no service-specific constraints beyond what is documented there.</p>', 'RecordingConfigurationSummary$tags' => '<p>Tags attached to the resource. Array of 1-50 maps, each of the form <code>string:string (key:value)</code>. See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a> for more information, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no service-specific constraints beyond what is documented there.</p>', 'StreamKey$tags' => '<p>Tags attached to the resource. Array of 1-50 maps, each of the form <code>string:string (key:value)</code>. See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a> for more information, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no service-specific constraints beyond what is documented there.</p>', 'StreamKeySummary$tags' => '<p>Tags attached to the resource. Array of 1-50 maps, each of the form <code>string:string (key:value)</code>. See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a> for more information, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no service-specific constraints beyond what is documented there.</p>', 'TagResourceRequest$tags' => '<p>Array of tags to be added or updated. Array of maps, each of the form <code>string:string (key:value)</code>. See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a> for more information, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no service-specific constraints beyond what is documented there.</p>', ], ], 'TargetIntervalSeconds' => [ 'base' => NULL, 'refs' => [ 'ThumbnailConfiguration$targetIntervalSeconds' => '<p>The targeted thumbnail-generation interval in seconds. This is configurable (and required) only if <code>recordingMode</code> is <code>INTERVAL</code>. Default: 60.</p> <p> <b>Important:</b> For the <code>BASIC</code> channel type, setting a value for <code>targetIntervalSeconds</code> does not guarantee that thumbnails are generated at the specified interval. For thumbnails to be generated at the <code>targetIntervalSeconds</code> interval, the <code>IDR/Keyframe</code> value for the input video must be less than the <code>targetIntervalSeconds</code> value. See <a href="https://docs.aws.amazon.com/ivs/latest/userguide/streaming-config.html"> Amazon IVS Streaming Configuration</a> for information on setting <code>IDR/Keyframe</code> to the recommended value in video-encoder settings.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p/>', 'refs' => [], ], 'ThumbnailConfiguration' => [ 'base' => '<p>An object representing a configuration of thumbnails for recorded video.</p>', 'refs' => [ 'CreateRecordingConfigurationRequest$thumbnailConfiguration' => '<p>A complex type that allows you to enable/disable the recording of thumbnails for a live session and modify the interval at which thumbnails are generated for the live session.</p>', 'RecordingConfiguration$thumbnailConfiguration' => '<p>A complex type that allows you to enable/disable the recording of thumbnails for a live session and modify the interval at which thumbnails are generated for the live session.</p>', ], ], 'ThumbnailConfigurationResolution' => [ 'base' => NULL, 'refs' => [ 'ThumbnailConfiguration$resolution' => '<p>Indicates the desired resolution of recorded thumbnails. Thumbnails are recorded at the selected resolution if the corresponding rendition is available during the stream; otherwise, they are recorded at source resolution. For more information about resolution values and their corresponding height and width dimensions, see <a href="https://docs.aws.amazon.com/ivs/latest/userguide/record-to-s3.html">Auto-Record to Amazon S3</a>. Default: Null (source resolution is returned).</p>', ], ], 'ThumbnailConfigurationStorage' => [ 'base' => NULL, 'refs' => [ 'ThumbnailConfigurationStorageList$member' => NULL, ], ], 'ThumbnailConfigurationStorageList' => [ 'base' => NULL, 'refs' => [ 'ThumbnailConfiguration$storage' => '<p>Indicates the format in which thumbnails are recorded. <code>SEQUENTIAL</code> records all generated thumbnails in a serial manner, to the media/thumbnails directory. <code>LATEST</code> saves the latest thumbnail in media/latest_thumbnail/thumb.jpg and overwrites it at the interval specified by <code>targetIntervalSeconds</code>. You can enable both <code>SEQUENTIAL</code> and <code>LATEST</code>. Default: <code>SEQUENTIAL</code>.</p>', ], ], 'Time' => [ 'base' => NULL, 'refs' => [ 'StreamEvent$eventTime' => '<p>Time when the event occurred. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>', 'StreamSession$endTime' => '<p>Time when the channel went offline. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>. For live streams, this is <code>NULL</code>.</p>', 'StreamSession$startTime' => '<p>Time when the channel went live. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>', 'StreamSessionSummary$endTime' => '<p>Time when the channel went offline. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>. For live streams, this is <code>NULL</code>.</p>', 'StreamSessionSummary$startTime' => '<p>Time when the channel went live. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>', ], ], 'TranscodePreset' => [ 'base' => NULL, 'refs' => [ 'Channel$preset' => '<p>Optional transcode preset for the channel. This is selectable only for <code>ADVANCED_HD</code> and <code>ADVANCED_SD</code> channel types. For those channel types, the default <code>preset</code> is <code>HIGHER_BANDWIDTH_DELIVERY</code>. For other channel types (<code>BASIC</code> and <code>STANDARD</code>), <code>preset</code> is the empty string (<code>""</code>).</p>', 'ChannelSummary$preset' => '<p>Optional transcode preset for the channel. This is selectable only for <code>ADVANCED_HD</code> and <code>ADVANCED_SD</code> channel types. For those channel types, the default <code>preset</code> is <code>HIGHER_BANDWIDTH_DELIVERY</code>. For other channel types (<code>BASIC</code> and <code>STANDARD</code>), <code>preset</code> is the empty string (<code>""</code>).</p>', 'CreateChannelRequest$preset' => '<p>Optional transcode preset for the channel. This is selectable only for <code>ADVANCED_HD</code> and <code>ADVANCED_SD</code> channel types. For those channel types, the default <code>preset</code> is <code>HIGHER_BANDWIDTH_DELIVERY</code>. For other channel types (<code>BASIC</code> and <code>STANDARD</code>), <code>preset</code> is the empty string (<code>""</code>).</p>', 'UpdateChannelRequest$preset' => '<p>Optional transcode preset for the channel. This is selectable only for <code>ADVANCED_HD</code> and <code>ADVANCED_SD</code> channel types. For those channel types, the default <code>preset</code> is <code>HIGHER_BANDWIDTH_DELIVERY</code>. For other channel types (<code>BASIC</code> and <code>STANDARD</code>), <code>preset</code> is the empty string (<code>""</code>).</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateChannelRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateChannelResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePlaybackRestrictionPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePlaybackRestrictionPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p/>', 'refs' => [], ], 'VideoConfiguration' => [ 'base' => '<p>Object specifying a stream’s video configuration, as set up by the broadcaster (usually in an encoder). This is part of the <a>IngestConfiguration</a> object and used for monitoring stream health.</p>', 'refs' => [ 'IngestConfiguration$video' => '<p>Encoder settings for video.</p>', ], ], 'ViewerId' => [ 'base' => NULL, 'refs' => [ 'BatchStartViewerSessionRevocationError$viewerId' => '<p>The ID of the viewer session to revoke.</p>', 'BatchStartViewerSessionRevocationViewerSession$viewerId' => '<p>The ID of the viewer associated with the viewer session to revoke. Do not use this field for personally identifying, confidential, or sensitive information.</p>', 'StartViewerSessionRevocationRequest$viewerId' => '<p>The ID of the viewer associated with the viewer session to revoke. Do not use this field for personally identifying, confidential, or sensitive information.</p>', ], ], 'ViewerSessionVersion' => [ 'base' => NULL, 'refs' => [ 'BatchStartViewerSessionRevocationViewerSession$viewerSessionVersionsLessThanOrEqualTo' => '<p>An optional filter on which versions of the viewer session to revoke. All versions less than or equal to the specified version will be revoked. Default: 0.</p>', 'StartViewerSessionRevocationRequest$viewerSessionVersionsLessThanOrEqualTo' => '<p>An optional filter on which versions of the viewer session to revoke. All versions less than or equal to the specified version will be revoked. Default: 0.</p>', ], ], 'errorCode' => [ 'base' => NULL, 'refs' => [ 'BatchError$code' => '<p>Error code.</p>', 'BatchStartViewerSessionRevocationError$code' => '<p>Error code.</p>', ], ], 'errorMessage' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$exceptionMessage' => '<p>User does not have sufficient access to perform this action.</p>', 'BatchError$message' => '<p>Error message, determined by the application.</p>', 'BatchStartViewerSessionRevocationError$message' => '<p>Error message, determined by the application.</p>', 'ChannelNotBroadcasting$exceptionMessage' => '<p>The stream is offline for the given channel ARN.</p>', 'ConflictException$exceptionMessage' => '<p>Updating or deleting a resource can cause an inconsistent state.</p>', 'InternalServerException$exceptionMessage' => '<p>Unexpected error during processing of request.</p>', 'PendingVerification$exceptionMessage' => '<p> Your account is pending verification. </p>', 'ResourceNotFoundException$exceptionMessage' => '<p>Request references a resource which does not exist.</p>', 'ServiceQuotaExceededException$exceptionMessage' => '<p>Request would cause a service quota to be exceeded.</p>', 'StreamUnavailable$exceptionMessage' => '<p>The stream is temporarily unavailable.</p>', 'ThrottlingException$exceptionMessage' => '<p>Request was denied due to request throttling.</p>', 'ValidationException$exceptionMessage' => '<p>The input fails to satisfy the constraints specified by an Amazon Web Services service.</p>', ], ], ],];
