<?php
// This file was auto-generated from sdk-root/src/data/ivschat/2020-07-14/docs-2.json
return [ 'version' => '2.0', 'service' => '<p> <b>Introduction</b> </p> <p>The Amazon IVS Chat control-plane API enables you to create and manage Amazon IVS Chat resources. You also need to integrate with the <a href="https://docs.aws.amazon.com/ivs/latest/chatmsgapireference/chat-messaging-api.html"> Amazon IVS Chat Messaging API</a>, to enable users to interact with chat rooms in real time.</p> <p>The API is an AWS regional service. For a list of supported regions and Amazon IVS Chat HTTPS service endpoints, see the Amazon IVS Chat information on the <a href="https://docs.aws.amazon.com/general/latest/gr/ivs.html">Amazon IVS page</a> in the <i>AWS General Reference</i>. </p> <p> <b>Notes on terminology:</b> </p> <ul> <li> <p>You create service applications using the Amazon IVS Chat API. We refer to these as <i>applications</i>.</p> </li> <li> <p>You create front-end client applications (browser and Android/iOS apps) using the Amazon IVS Chat Messaging API. We refer to these as <i>clients</i>. </p> </li> </ul> <p> <b>Key Concepts</b> </p> <ul> <li> <p> <b>LoggingConfiguration</b> — A configuration that allows customers to store and record sent messages in a chat room.</p> </li> <li> <p> <b>Room</b> — The central Amazon IVS Chat resource through which clients connect to and exchange chat messages.</p> </li> </ul> <p> <b>Tagging</b> </p> <p>A <i>tag</i> is a metadata label that you assign to an AWS resource. A tag comprises a <i>key</i> and a <i>value</i>, both set by you. For example, you might set a tag as <code>topic:nature</code> to label a particular video category. See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a> for more information, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS Chat has no service-specific constraints beyond what is documented there.</p> <p>Tags can help you identify and organize your AWS resources. For example, you can use the same tag for different resources to indicate that they are related. You can also use tags to manage access (see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Access Tags</a>).</p> <p>The Amazon IVS Chat API has these tag-related endpoints: <a>TagResource</a>, <a>UntagResource</a>, and <a>ListTagsForResource</a>. The following resource supports tagging: Room.</p> <p>At most 50 tags can be applied to a resource.</p> <p> <b>API Access Security</b> </p> <p>Your Amazon IVS Chat applications (service applications and clients) must be authenticated and authorized to access Amazon IVS Chat resources. Note the differences between these concepts:</p> <ul> <li> <p> <i>Authentication</i> is about verifying identity. Requests to the Amazon IVS Chat API must be signed to verify your identity.</p> </li> <li> <p> <i>Authorization</i> is about granting permissions. Your IAM roles need to have permissions for Amazon IVS Chat API requests.</p> </li> </ul> <p>Users (viewers) connect to a room using secure access tokens that you create using the <a>CreateChatToken</a> endpoint through the AWS SDK. You call CreateChatToken for every user’s chat session, passing identity and authorization information about the user.</p> <p> <b>Signing API Requests</b> </p> <p>HTTP API requests must be signed with an AWS SigV4 signature using your AWS security credentials. The AWS Command Line Interface (CLI) and the AWS SDKs take care of signing the underlying API calls for you. However, if your application calls the Amazon IVS Chat HTTP API directly, it’s your responsibility to sign the requests.</p> <p>You generate a signature using valid AWS credentials for an IAM role that has permission to perform the requested action. For example, DeleteMessage requests must be made using an IAM role that has the <code>ivschat:DeleteMessage</code> permission.</p> <p>For more information:</p> <ul> <li> <p>Authentication and generating signatures — See <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sig-v4-authenticating-requests.html">Authenticating Requests (Amazon Web Services Signature Version 4)</a> in the <i>Amazon Web Services General Reference</i>.</p> </li> <li> <p>Managing Amazon IVS permissions — See <a href="https://docs.aws.amazon.com/ivs/latest/userguide/security-iam.html">Identity and Access Management</a> on the Security page of the <i>Amazon IVS User Guide</i>.</p> </li> </ul> <p> <b>Amazon Resource Names (ARNs)</b> </p> <p>ARNs uniquely identify AWS resources. An ARN is required when you need to specify a resource unambiguously across all of AWS, such as in IAM policies and API calls. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names</a> in the <i>AWS General Reference</i>.</p> <p> <b>Messaging Endpoints</b> </p> <ul> <li> <p> <a>DeleteMessage</a> — Sends an event to a specific room which directs clients to delete a specific message; that is, unrender it from view and delete it from the client’s chat history. This event’s <code>EventName</code> is <code>aws:DELETE_MESSAGE</code>. This replicates the <a href="https://docs.aws.amazon.com/ivs/latest/chatmsgapireference/actions-deletemessage-publish.html"> DeleteMessage</a> WebSocket operation in the Amazon IVS Chat Messaging API.</p> </li> <li> <p> <a>DisconnectUser</a> — Disconnects all connections using a specified user ID from a room. This replicates the <a href="https://docs.aws.amazon.com/ivs/latest/chatmsgapireference/actions-disconnectuser-publish.html"> DisconnectUser</a> WebSocket operation in the Amazon IVS Chat Messaging API.</p> </li> <li> <p> <a>SendEvent</a> — Sends an event to a room. Use this within your application’s business logic to send events to clients of a room; e.g., to notify clients to change the way the chat UI is rendered.</p> </li> </ul> <p> <b>Chat Token Endpoint</b> </p> <ul> <li> <p> <a>CreateChatToken</a> — Creates an encrypted token that is used by a chat participant to establish an individual WebSocket chat connection to a room. When the token is used to connect to chat, the connection is valid for the session duration specified in the request. The token becomes invalid at the token-expiration timestamp included in the response.</p> </li> </ul> <p> <b>Room Endpoints</b> </p> <ul> <li> <p> <a>CreateRoom</a> — Creates a room that allows clients to connect and pass messages.</p> </li> <li> <p> <a>DeleteRoom</a> — Deletes the specified room.</p> </li> <li> <p> <a>GetRoom</a> — Gets the specified room.</p> </li> <li> <p> <a>ListRooms</a> — Gets summary information about all your rooms in the AWS region where the API request is processed. </p> </li> <li> <p> <a>UpdateRoom</a> — Updates a room’s configuration.</p> </li> </ul> <p> <b>Logging Configuration Endpoints</b> </p> <ul> <li> <p> <a>CreateLoggingConfiguration</a> — Creates a logging configuration that allows clients to store and record sent messages.</p> </li> <li> <p> <a>DeleteLoggingConfiguration</a> — Deletes the specified logging configuration.</p> </li> <li> <p> <a>GetLoggingConfiguration</a> — Gets the specified logging configuration.</p> </li> <li> <p> <a>ListLoggingConfigurations</a> — Gets summary information about all your logging configurations in the AWS region where the API request is processed.</p> </li> <li> <p> <a>UpdateLoggingConfiguration</a> — Updates a specified logging configuration.</p> </li> </ul> <p> <b>Tags Endpoints</b> </p> <ul> <li> <p> <a>ListTagsForResource</a> — Gets information about AWS tags for the specified ARN.</p> </li> <li> <p> <a>TagResource</a> — Adds or updates tags for the AWS resource with the specified ARN.</p> </li> <li> <p> <a>UntagResource</a> — Removes tags from the resource with the specified ARN.</p> </li> </ul> <p>All the above are HTTP operations. There is a separate <i>messaging</i> API for managing Chat resources; see the <a href="https://docs.aws.amazon.com/ivs/latest/chatmsgapireference/chat-messaging-api.html"> Amazon IVS Chat Messaging API Reference</a>.</p>', 'operations' => [ 'CreateChatToken' => '<p>Creates an encrypted token that is used by a chat participant to establish an individual WebSocket chat connection to a room. When the token is used to connect to chat, the connection is valid for the session duration specified in the request. The token becomes invalid at the token-expiration timestamp included in the response.</p> <p>Use the <code>capabilities</code> field to permit an end user to send messages or moderate a room.</p> <p>The <code>attributes</code> field securely attaches structured data to the chat session; the data is included within each message sent by the end user and received by other participants in the room. Common use cases for attributes include passing end-user profile data like an icon, display name, colors, badges, and other display features.</p> <p>Encryption keys are owned by Amazon IVS Chat and never used directly by your application.</p>', 'CreateLoggingConfiguration' => '<p>Creates a logging configuration that allows clients to store and record sent messages.</p>', 'CreateRoom' => '<p>Creates a room that allows clients to connect and pass messages.</p>', 'DeleteLoggingConfiguration' => '<p>Deletes the specified logging configuration.</p>', 'DeleteMessage' => '<p>Sends an event to a specific room which directs clients to delete a specific message; that is, unrender it from view and delete it from the client’s chat history. This event’s <code>EventName</code> is <code>aws:DELETE_MESSAGE</code>. This replicates the <a href="https://docs.aws.amazon.com/ivs/latest/chatmsgapireference/actions-deletemessage-publish.html"> DeleteMessage</a> WebSocket operation in the Amazon IVS Chat Messaging API.</p>', 'DeleteRoom' => '<p>Deletes the specified room.</p>', 'DisconnectUser' => '<p>Disconnects all connections using a specified user ID from a room. This replicates the <a href="https://docs.aws.amazon.com/ivs/latest/chatmsgapireference/actions-disconnectuser-publish.html"> DisconnectUser</a> WebSocket operation in the Amazon IVS Chat Messaging API.</p>', 'GetLoggingConfiguration' => '<p>Gets the specified logging configuration.</p>', 'GetRoom' => '<p>Gets the specified room.</p>', 'ListLoggingConfigurations' => '<p>Gets summary information about all your logging configurations in the AWS region where the API request is processed.</p>', 'ListRooms' => '<p>Gets summary information about all your rooms in the AWS region where the API request is processed. Results are sorted in descending order of <code>updateTime</code>.</p>', 'ListTagsForResource' => '<p>Gets information about AWS tags for the specified ARN.</p>', 'SendEvent' => '<p>Sends an event to a room. Use this within your application’s business logic to send events to clients of a room; e.g., to notify clients to change the way the chat UI is rendered.</p>', 'TagResource' => '<p>Adds or updates tags for the AWS resource with the specified ARN.</p>', 'UntagResource' => '<p>Removes tags from the resource with the specified ARN.</p>', 'UpdateLoggingConfiguration' => '<p>Updates a specified logging configuration.</p>', 'UpdateRoom' => '<p>Updates a room’s configuration.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p/>', 'refs' => [], ], 'BucketName' => [ 'base' => NULL, 'refs' => [ 'S3DestinationConfiguration$bucketName' => '<p>Name of the Amazon S3 bucket where chat activity will be logged.</p>', ], ], 'ChatToken' => [ 'base' => NULL, 'refs' => [ 'CreateChatTokenResponse$token' => '<p>The issued client token, encrypted.</p>', ], ], 'ChatTokenAttributes' => [ 'base' => NULL, 'refs' => [ 'CreateChatTokenRequest$attributes' => '<p>Application-provided attributes to encode into the token and attach to a chat session. Map keys and values can contain UTF-8 encoded text. The maximum length of this field is 1 KB total.</p>', ], ], 'ChatTokenCapabilities' => [ 'base' => NULL, 'refs' => [ 'CreateChatTokenRequest$capabilities' => '<p>Set of capabilities that the user is allowed to perform in the room. Default: None (the capability to view messages is implicitly included in all requests).</p>', ], ], 'ChatTokenCapability' => [ 'base' => NULL, 'refs' => [ 'ChatTokenCapabilities$member' => NULL, ], ], 'CloudWatchLogsDestinationConfiguration' => [ 'base' => '<p>Specifies a CloudWatch Logs location where chat logs will be stored.</p>', 'refs' => [ 'DestinationConfiguration$cloudWatchLogs' => '<p>An Amazon CloudWatch Logs destination configuration where chat activity will be logged.</p>', ], ], 'ConflictException' => [ 'base' => '<p/>', 'refs' => [], ], 'CreateChatTokenRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateChatTokenResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateLoggingConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateLoggingConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateLoggingConfigurationState' => [ 'base' => NULL, 'refs' => [ 'CreateLoggingConfigurationResponse$state' => '<p>The state of the logging configuration. When the state is <code>ACTIVE</code>, the configuration is ready to log chat content.</p>', ], ], 'CreateRoomRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateRoomResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLoggingConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMessageRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMessageResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRoomRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeliveryStreamName' => [ 'base' => NULL, 'refs' => [ 'FirehoseDestinationConfiguration$deliveryStreamName' => '<p>Name of the Amazon Kinesis Firehose delivery stream where chat activity will be logged.</p>', ], ], 'DestinationConfiguration' => [ 'base' => '<p>A complex type that describes a location where chat logs will be stored. Each member represents the configuration of one log destination. For logging, you define only one type of destination (for CloudWatch Logs, Kinesis Firehose, or S3).</p>', 'refs' => [ 'CreateLoggingConfigurationRequest$destinationConfiguration' => '<p>A complex type that contains a destination configuration for where chat content will be logged. There can be only one type of destination (<code>cloudWatchLogs</code>, <code>firehose</code>, or <code>s3</code>) in a <code>destinationConfiguration</code>.</p>', 'CreateLoggingConfigurationResponse$destinationConfiguration' => '<p>A complex type that contains a destination configuration for where chat content will be logged, from the request. There is only one type of destination (<code>cloudWatchLogs</code>, <code>firehose</code>, or <code>s3</code>) in a <code>destinationConfiguration</code>.</p>', 'GetLoggingConfigurationResponse$destinationConfiguration' => '<p>A complex type that contains a destination configuration for where chat content will be logged. There is only one type of destination (<code>cloudWatchLogs</code>, <code>firehose</code>, or <code>s3</code>) in a <code>destinationConfiguration</code>.</p>', 'LoggingConfigurationSummary$destinationConfiguration' => '<p>A complex type that contains a destination configuration for where chat content will be logged.</p>', 'UpdateLoggingConfigurationRequest$destinationConfiguration' => '<p>A complex type that contains a destination configuration for where chat content will be logged. There can be only one type of destination (<code>cloudWatchLogs</code>, <code>firehose</code>, or <code>s3</code>) in a <code>destinationConfiguration</code>.</p>', 'UpdateLoggingConfigurationResponse$destinationConfiguration' => '<p>A complex type that contains a destination configuration for where chat content will be logged, from the request. There is only one type of destination (<code>cloudWatchLogs</code>, <code>firehose</code>, or <code>s3</code>) in a <code>destinationConfiguration</code>.</p>', ], ], 'DisconnectUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisconnectUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'ConflictException$message' => NULL, 'InternalServerException$message' => NULL, 'PendingVerification$message' => NULL, 'ResourceNotFoundException$message' => NULL, 'ServiceQuotaExceededException$message' => NULL, 'ThrottlingException$message' => NULL, 'ValidationException$message' => NULL, 'ValidationExceptionField$message' => '<p>Explanation of the reason for the validation error.</p>', ], ], 'EventAttributes' => [ 'base' => NULL, 'refs' => [ 'SendEventRequest$attributes' => '<p>Application-defined metadata to attach to the event sent to clients. The maximum length of the metadata is 1 KB total.</p>', ], ], 'EventName' => [ 'base' => NULL, 'refs' => [ 'SendEventRequest$eventName' => '<p>Application-defined name of the event to send to clients.</p>', ], ], 'FallbackResult' => [ 'base' => NULL, 'refs' => [ 'MessageReviewHandler$fallbackResult' => '<p>Specifies the fallback behavior (whether the message is allowed or denied) if the handler does not return a valid response, encounters an error, or times out. (For the timeout period, see <a href="https://docs.aws.amazon.com/ivs/latest/userguide/service-quotas.html"> Service Quotas</a>.) If allowed, the message is delivered with returned content to all users connected to the room. If denied, the message is not delivered to any user. Default: <code>ALLOW</code>.</p>', ], ], 'FieldName' => [ 'base' => NULL, 'refs' => [ 'ValidationExceptionField$name' => '<p>Name of the field which failed validation.</p>', ], ], 'FirehoseDestinationConfiguration' => [ 'base' => '<p>Specifies a Kinesis Firehose location where chat logs will be stored.</p>', 'refs' => [ 'DestinationConfiguration$firehose' => '<p>An Amazon Kinesis Data Firehose destination configuration where chat activity will be logged.</p>', ], ], 'GetLoggingConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetLoggingConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetRoomRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetRoomResponse' => [ 'base' => NULL, 'refs' => [], ], 'ID' => [ 'base' => NULL, 'refs' => [ 'DeleteMessageResponse$id' => '<p>Operation identifier, generated by Amazon IVS Chat.</p>', 'SendEventResponse$id' => '<p>An identifier generated by Amazon IVS Chat. This identifier must be used in subsequent operations for this message, such as DeleteMessage.</p>', ], ], 'InternalServerException' => [ 'base' => '<p/>', 'refs' => [], ], 'LambdaArn' => [ 'base' => NULL, 'refs' => [ 'ListRoomsRequest$messageReviewHandlerUri' => '<p>Filters the list to match the specified message review handler URI.</p>', 'MessageReviewHandler$uri' => '<p>Identifier of the message review handler. Currently this must be an ARN of a lambda function.</p>', ], ], 'Limit' => [ 'base' => NULL, 'refs' => [ 'ServiceQuotaExceededException$limit' => '<p/>', 'ThrottlingException$limit' => '<p/>', ], ], 'ListLoggingConfigurationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListLoggingConfigurationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListRoomsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRoomsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'LogGroupName' => [ 'base' => NULL, 'refs' => [ 'CloudWatchLogsDestinationConfiguration$logGroupName' => '<p>Name of the Amazon Cloudwatch Logs destination where chat activity will be logged.</p>', ], ], 'LoggingConfigurationArn' => [ 'base' => NULL, 'refs' => [ 'CreateLoggingConfigurationResponse$arn' => '<p>Logging-configuration ARN, assigned by the system.</p>', 'GetLoggingConfigurationResponse$arn' => '<p>Logging-configuration ARN, from the request (if <code>identifier</code> was an ARN).</p>', 'LoggingConfigurationSummary$arn' => '<p>Logging-configuration ARN.</p>', 'UpdateLoggingConfigurationResponse$arn' => '<p>Logging-configuration ARN, from the request (if <code>identifier</code> was an ARN).</p>', ], ], 'LoggingConfigurationID' => [ 'base' => NULL, 'refs' => [ 'CreateLoggingConfigurationResponse$id' => '<p>Logging-configuration ID, generated by the system. This is a relative identifier, the part of the ARN that uniquely identifies the logging configuration.</p>', 'GetLoggingConfigurationResponse$id' => '<p>Logging-configuration ID, generated by the system. This is a relative identifier, the part of the ARN that uniquely identifies the logging configuration.</p>', 'LoggingConfigurationSummary$id' => '<p>Logging-configuration ID, generated by the system. This is a relative identifier, the part of the ARN that uniquely identifies the room.</p>', 'UpdateLoggingConfigurationResponse$id' => '<p>Logging-configuration ID, generated by the system. This is a relative identifier, the part of the ARN that uniquely identifies the room.</p>', ], ], 'LoggingConfigurationIdentifier' => [ 'base' => NULL, 'refs' => [ 'DeleteLoggingConfigurationRequest$identifier' => '<p>Identifier of the logging configuration to be deleted.</p>', 'GetLoggingConfigurationRequest$identifier' => '<p>Identifier of the logging configuration to be retrieved.</p>', 'ListRoomsRequest$loggingConfigurationIdentifier' => '<p>Logging-configuration identifier.</p>', 'LoggingConfigurationIdentifierList$member' => NULL, 'UpdateLoggingConfigurationRequest$identifier' => '<p>Identifier of the logging configuration to be updated.</p>', ], ], 'LoggingConfigurationIdentifierList' => [ 'base' => NULL, 'refs' => [ 'CreateRoomRequest$loggingConfigurationIdentifiers' => '<p>Array of logging-configuration identifiers attached to the room.</p>', 'CreateRoomResponse$loggingConfigurationIdentifiers' => '<p>Array of logging configurations attached to the room, from the request (if specified).</p>', 'GetRoomResponse$loggingConfigurationIdentifiers' => '<p>Array of logging configurations attached to the room.</p>', 'RoomSummary$loggingConfigurationIdentifiers' => '<p>List of logging-configuration identifiers attached to the room.</p>', 'UpdateRoomRequest$loggingConfigurationIdentifiers' => '<p>Array of logging-configuration identifiers attached to the room.</p>', 'UpdateRoomResponse$loggingConfigurationIdentifiers' => '<p>Array of logging configurations attached to the room, from the request (if specified).</p>', ], ], 'LoggingConfigurationList' => [ 'base' => NULL, 'refs' => [ 'ListLoggingConfigurationsResponse$loggingConfigurations' => '<p>List of the matching logging configurations (summary information only). There is only one type of destination (<code>cloudWatchLogs</code>, <code>firehose</code>, or <code>s3</code>) in a <code>destinationConfiguration</code>.</p>', ], ], 'LoggingConfigurationName' => [ 'base' => NULL, 'refs' => [ 'CreateLoggingConfigurationRequest$name' => '<p>Logging-configuration name. The value does not need to be unique.</p>', 'CreateLoggingConfigurationResponse$name' => '<p>Logging-configuration name, from the request (if specified).</p>', 'GetLoggingConfigurationResponse$name' => '<p>Logging-configuration name. This value does not need to be unique.</p>', 'LoggingConfigurationSummary$name' => '<p>Logging-configuration name. The value does not need to be unique.</p>', 'UpdateLoggingConfigurationRequest$name' => '<p>Logging-configuration name. The value does not need to be unique.</p>', 'UpdateLoggingConfigurationResponse$name' => '<p>Logging-configuration name, from the request (if specified).</p>', ], ], 'LoggingConfigurationState' => [ 'base' => NULL, 'refs' => [ 'GetLoggingConfigurationResponse$state' => '<p>The state of the logging configuration. When the state is <code>ACTIVE</code>, the configuration is ready to log chat content.</p>', 'LoggingConfigurationSummary$state' => '<p>The state of the logging configuration. When this is <code>ACTIVE</code>, the configuration is ready for logging chat content.</p>', ], ], 'LoggingConfigurationSummary' => [ 'base' => '<p>Summary information about a logging configuration.</p>', 'refs' => [ 'LoggingConfigurationList$member' => NULL, ], ], 'MaxLoggingConfigurationResults' => [ 'base' => NULL, 'refs' => [ 'ListLoggingConfigurationsRequest$maxResults' => '<p>Maximum number of logging configurations to return. Default: 50.</p>', ], ], 'MaxRoomResults' => [ 'base' => NULL, 'refs' => [ 'ListRoomsRequest$maxResults' => '<p>Maximum number of rooms to return. Default: 50.</p>', ], ], 'MessageID' => [ 'base' => NULL, 'refs' => [ 'DeleteMessageRequest$id' => '<p>ID of the message to be deleted. This is the <code>Id</code> field in the received message (see <a href="https://docs.aws.amazon.com/ivs/latest/chatmsgapireference/actions-message-subscribe.html"> Message (Subscribe)</a> in the Chat Messaging API).</p>', ], ], 'MessageReviewHandler' => [ 'base' => '<p>Configuration information for optional message review.</p>', 'refs' => [ 'CreateRoomRequest$messageReviewHandler' => '<p>Configuration information for optional review of messages.</p>', 'CreateRoomResponse$messageReviewHandler' => '<p>Configuration information for optional review of messages.</p>', 'GetRoomResponse$messageReviewHandler' => '<p>Configuration information for optional review of messages.</p>', 'RoomSummary$messageReviewHandler' => '<p>Configuration information for optional review of messages.</p>', 'UpdateRoomRequest$messageReviewHandler' => '<p>Configuration information for optional review of messages. Specify an empty <code>uri</code> string to disassociate a message review handler from the specified room.</p>', 'UpdateRoomResponse$messageReviewHandler' => '<p>Configuration information for optional review of messages.</p>', ], ], 'PaginationToken' => [ 'base' => NULL, 'refs' => [ 'ListLoggingConfigurationsRequest$nextToken' => '<p>The first logging configurations to retrieve. This is used for pagination; see the <code>nextToken</code> response field.</p>', 'ListLoggingConfigurationsResponse$nextToken' => '<p>If there are more logging configurations than <code>maxResults</code>, use <code>nextToken</code> in the request to get the next set.</p>', 'ListRoomsRequest$nextToken' => '<p>The first room to retrieve. This is used for pagination; see the <code>nextToken</code> response field.</p>', 'ListRoomsResponse$nextToken' => '<p>If there are more rooms than <code>maxResults</code>, use <code>nextToken</code> in the request to get the next set.</p>', ], ], 'PendingVerification' => [ 'base' => '<p/>', 'refs' => [], ], 'Reason' => [ 'base' => NULL, 'refs' => [ 'DeleteMessageRequest$reason' => '<p>Reason for deleting the message.</p>', 'DisconnectUserRequest$reason' => '<p>Reason for disconnecting the user.</p>', ], ], 'ResourceArn' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$resourceArn' => '<p>The ARN of the resource to be retrieved. The ARN must be URL-encoded.</p>', 'TagResourceRequest$resourceArn' => '<p>The ARN of the resource to be tagged. The ARN must be URL-encoded.</p>', 'UntagResourceRequest$resourceArn' => '<p>The ARN of the resource to be untagged. The ARN must be URL-encoded.</p>', ], ], 'ResourceId' => [ 'base' => NULL, 'refs' => [ 'ConflictException$resourceId' => '<p/>', 'ResourceNotFoundException$resourceId' => '<p/>', 'ServiceQuotaExceededException$resourceId' => '<p/>', 'ThrottlingException$resourceId' => '<p/>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p/>', 'refs' => [], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'ConflictException$resourceType' => '<p/>', 'ResourceNotFoundException$resourceType' => '<p/>', 'ServiceQuotaExceededException$resourceType' => '<p/>', 'ThrottlingException$resourceType' => '<p/>', ], ], 'RoomArn' => [ 'base' => NULL, 'refs' => [ 'CreateRoomResponse$arn' => '<p>Room ARN, assigned by the system.</p>', 'GetRoomResponse$arn' => '<p>Room ARN, from the request (if <code>identifier</code> was an ARN).</p>', 'RoomSummary$arn' => '<p>Room ARN.</p>', 'UpdateRoomResponse$arn' => '<p>Room ARN, from the request (if <code>identifier</code> was an ARN).</p>', ], ], 'RoomID' => [ 'base' => NULL, 'refs' => [ 'CreateRoomResponse$id' => '<p>Room ID, generated by the system. This is a relative identifier, the part of the ARN that uniquely identifies the room.</p>', 'GetRoomResponse$id' => '<p>Room ID, generated by the system. This is a relative identifier, the part of the ARN that uniquely identifies the room.</p>', 'RoomSummary$id' => '<p>Room ID, generated by the system. This is a relative identifier, the part of the ARN that uniquely identifies the room.</p>', 'UpdateRoomResponse$id' => '<p>Room ID, generated by the system. This is a relative identifier, the part of the ARN that uniquely identifies the room.</p>', ], ], 'RoomIdentifier' => [ 'base' => NULL, 'refs' => [ 'CreateChatTokenRequest$roomIdentifier' => '<p>Identifier of the room that the client is trying to access. Currently this must be an ARN. </p>', 'DeleteMessageRequest$roomIdentifier' => '<p>Identifier of the room where the message should be deleted. Currently this must be an ARN. </p>', 'DeleteRoomRequest$identifier' => '<p>Identifier of the room to be deleted. Currently this must be an ARN.</p>', 'DisconnectUserRequest$roomIdentifier' => '<p>Identifier of the room from which the user\'s clients should be disconnected. Currently this must be an ARN.</p>', 'GetRoomRequest$identifier' => '<p>Identifier of the room for which the configuration is to be retrieved. Currently this must be an ARN.</p>', 'SendEventRequest$roomIdentifier' => '<p>Identifier of the room to which the event will be sent. Currently this must be an ARN.</p>', 'UpdateRoomRequest$identifier' => '<p>Identifier of the room to be updated. Currently this must be an ARN.</p>', ], ], 'RoomList' => [ 'base' => NULL, 'refs' => [ 'ListRoomsResponse$rooms' => '<p>List of the matching rooms (summary information only).</p>', ], ], 'RoomMaxMessageLength' => [ 'base' => NULL, 'refs' => [ 'CreateRoomRequest$maximumMessageLength' => '<p>Maximum number of characters in a single message. Messages are expected to be UTF-8 encoded and this limit applies specifically to rune/code-point count, not number of bytes. Default: 500.</p>', 'CreateRoomResponse$maximumMessageLength' => '<p>Maximum number of characters in a single message, from the request (if specified).</p>', 'GetRoomResponse$maximumMessageLength' => '<p>Maximum number of characters in a single message. Messages are expected to be UTF-8 encoded and this limit applies specifically to rune/code-point count, not number of bytes. Default: 500.</p>', 'UpdateRoomRequest$maximumMessageLength' => '<p>The maximum number of characters in a single message. Messages are expected to be UTF-8 encoded and this limit applies specifically to rune/code-point count, not number of bytes. Default: 500.</p>', 'UpdateRoomResponse$maximumMessageLength' => '<p>Maximum number of characters in a single message, from the request (if specified).</p>', ], ], 'RoomMaxMessageRatePerSecond' => [ 'base' => NULL, 'refs' => [ 'CreateRoomRequest$maximumMessageRatePerSecond' => '<p>Maximum number of messages per second that can be sent to the room (by all clients). Default: 10. </p>', 'CreateRoomResponse$maximumMessageRatePerSecond' => '<p>Maximum number of messages per second that can be sent to the room (by all clients), from the request (if specified).</p>', 'GetRoomResponse$maximumMessageRatePerSecond' => '<p>Maximum number of messages per second that can be sent to the room (by all clients). Default: 10.</p>', 'UpdateRoomRequest$maximumMessageRatePerSecond' => '<p>Maximum number of messages per second that can be sent to the room (by all clients). Default: 10.</p>', 'UpdateRoomResponse$maximumMessageRatePerSecond' => '<p>Maximum number of messages per second that can be sent to the room (by all clients), from the request (if specified).</p>', ], ], 'RoomName' => [ 'base' => NULL, 'refs' => [ 'CreateRoomRequest$name' => '<p>Room name. The value does not need to be unique.</p>', 'CreateRoomResponse$name' => '<p>Room name, from the request (if specified).</p>', 'GetRoomResponse$name' => '<p>Room name. The value does not need to be unique.</p>', 'ListRoomsRequest$name' => '<p>Filters the list to match the specified room name.</p>', 'RoomSummary$name' => '<p>Room name. The value does not need to be unique.</p>', 'UpdateRoomRequest$name' => '<p>Room name. The value does not need to be unique.</p>', 'UpdateRoomResponse$name' => '<p>Room name, from the request (if specified).</p>', ], ], 'RoomSummary' => [ 'base' => '<p>Summary information about a room.</p>', 'refs' => [ 'RoomList$member' => NULL, ], ], 'S3DestinationConfiguration' => [ 'base' => '<p>Specifies an S3 location where chat logs will be stored.</p>', 'refs' => [ 'DestinationConfiguration$s3' => '<p>An Amazon S3 destination configuration where chat activity will be logged.</p>', ], ], 'SendEventRequest' => [ 'base' => NULL, 'refs' => [], ], 'SendEventResponse' => [ 'base' => NULL, 'refs' => [], ], 'ServiceQuotaExceededException' => [ 'base' => '<p/>', 'refs' => [], ], 'SessionDurationInMinutes' => [ 'base' => NULL, 'refs' => [ 'CreateChatTokenRequest$sessionDurationInMinutes' => '<p>Session duration (in minutes), after which the session expires. Default: 60 (1 hour).</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'ChatTokenAttributes$key' => NULL, 'ChatTokenAttributes$value' => NULL, 'EventAttributes$key' => NULL, 'EventAttributes$value' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'Tags$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>Array of tags to be removed. Array of maps, each of the form <code>string:string (key:value)</code>. See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a> for details, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS Chat has no constraints beyond what is documented there.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tags$value' => NULL, ], ], 'Tags' => [ 'base' => NULL, 'refs' => [ 'CreateLoggingConfigurationRequest$tags' => '<p>Tags to attach to the resource. Array of maps, each of the form <code>string:string (key:value)</code>. See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a> for details, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS Chat has no constraints on tags beyond what is documented there.</p>', 'CreateLoggingConfigurationResponse$tags' => '<p>Tags attached to the resource, from the request (if specified). Array of maps, each of the form <code>string:string (key:value)</code>.</p>', 'CreateRoomRequest$tags' => '<p>Tags to attach to the resource. Array of maps, each of the form <code>string:string (key:value)</code>. See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a> for details, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS Chat has no constraints beyond what is documented there.</p>', 'CreateRoomResponse$tags' => '<p>Tags attached to the resource, from the request (if specified).</p>', 'GetLoggingConfigurationResponse$tags' => '<p>Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>.</p>', 'GetRoomResponse$tags' => '<p>Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>.</p>', 'ListTagsForResourceResponse$tags' => '<p>Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>.</p>', 'LoggingConfigurationSummary$tags' => '<p>Tags to attach to the resource. Array of maps, each of the form <code>string:string (key:value)</code>. See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a> for details, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS Chat has no constraints on tags beyond what is documented there.</p>', 'RoomSummary$tags' => '<p>Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>. See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a> for details, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS Chat has no constraints beyond what is documented there.</p>', 'TagResourceRequest$tags' => '<p>Array of tags to be added or updated. Array of maps, each of the form <code>string:string (key:value)</code>. See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a> for details, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS Chat has no constraints beyond what is documented there.</p>', 'UpdateLoggingConfigurationResponse$tags' => '<p>Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>. </p>', 'UpdateRoomResponse$tags' => '<p>Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p/>', 'refs' => [], ], 'Time' => [ 'base' => NULL, 'refs' => [ 'CreateChatTokenResponse$sessionExpirationTime' => '<p>Time after which an end user\'s session is no longer valid. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>', 'CreateChatTokenResponse$tokenExpirationTime' => '<p>Time after which the token is no longer valid and cannot be used to connect to a room. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>', 'CreateLoggingConfigurationResponse$createTime' => '<p>Time when the logging configuration was created. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>', 'CreateLoggingConfigurationResponse$updateTime' => '<p>Time of the logging configuration’s last update. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>', 'CreateRoomResponse$createTime' => '<p>Time when the room was created. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>', 'CreateRoomResponse$updateTime' => '<p>Time of the room’s last update. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>', 'GetLoggingConfigurationResponse$createTime' => '<p>Time when the logging configuration was created. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>', 'GetLoggingConfigurationResponse$updateTime' => '<p>Time of the logging configuration’s last update. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>', 'GetRoomResponse$createTime' => '<p>Time when the room was created. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>', 'GetRoomResponse$updateTime' => '<p>Time of the room’s last update. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>', 'LoggingConfigurationSummary$createTime' => '<p>Time when the logging configuration was created. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>', 'LoggingConfigurationSummary$updateTime' => '<p>Time of the logging configuration’s last update. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>', 'RoomSummary$createTime' => '<p>Time when the room was created. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>. </p>', 'RoomSummary$updateTime' => '<p>Time of the room’s last update. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>. </p>', 'UpdateLoggingConfigurationResponse$createTime' => '<p>Time when the logging configuration was created. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>', 'UpdateLoggingConfigurationResponse$updateTime' => '<p>Time of the logging configuration’s last update. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>', 'UpdateRoomResponse$createTime' => '<p>Time when the room was created. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>', 'UpdateRoomResponse$updateTime' => '<p>Time of the room’s last update. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateLoggingConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateLoggingConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateLoggingConfigurationState' => [ 'base' => NULL, 'refs' => [ 'UpdateLoggingConfigurationResponse$state' => '<p>The state of the logging configuration. When the state is <code>ACTIVE</code>, the configuration is ready to log chat content.</p>', ], ], 'UpdateRoomRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRoomResponse' => [ 'base' => NULL, 'refs' => [], ], 'UserID' => [ 'base' => NULL, 'refs' => [ 'CreateChatTokenRequest$userId' => '<p>Application-provided ID that uniquely identifies the user associated with this token. This can be any UTF-8 encoded text.</p>', 'DisconnectUserRequest$userId' => '<p>ID of the user (connection) to disconnect from the room.</p>', ], ], 'ValidationException' => [ 'base' => '<p/>', 'refs' => [], ], 'ValidationExceptionField' => [ 'base' => '<p>This object is used in the ValidationException error.</p>', 'refs' => [ 'ValidationExceptionFieldList$member' => NULL, ], ], 'ValidationExceptionFieldList' => [ 'base' => NULL, 'refs' => [ 'ValidationException$fieldList' => '<p/>', ], ], 'ValidationExceptionReason' => [ 'base' => NULL, 'refs' => [ 'ValidationException$reason' => '<p/>', ], ], ],];
