<?php
// This file was auto-generated from sdk-root/src/data/kendra/2019-02-03/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Amazon Kendra is a service for indexing large document sets.</p>', 'operations' => [ 'AssociateEntitiesToExperience' => '<p>Grants users or groups in your IAM Identity Center identity source access to your Amazon Kendra experience. You can create an Amazon Kendra experience such as a search application. For more information on creating a search application experience, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search experience with no code</a>.</p>', 'AssociatePersonasToEntities' => '<p>Defines the specific permissions of users or groups in your IAM Identity Center identity source with access to your Amazon Kendra experience. You can create an Amazon Kendra experience such as a search application. For more information on creating a search application experience, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search experience with no code</a>.</p>', 'BatchDeleteDocument' => '<p>Removes one or more documents from an index. The documents must have been added with the <code>BatchPutDocument</code> API.</p> <p>The documents are deleted asynchronously. You can see the progress of the deletion by using Amazon Web Services CloudWatch. Any error messages related to the processing of the batch are sent to your Amazon Web Services CloudWatch log. You can also use the <code>BatchGetDocumentStatus</code> API to monitor the progress of deleting your documents.</p> <p>Deleting documents from an index using <code>BatchDeleteDocument</code> could take up to an hour or more, depending on the number of documents you want to delete.</p>', 'BatchDeleteFeaturedResultsSet' => '<p>Removes one or more sets of featured results. Features results are placed above all other results for certain queries. If there\'s an exact match of a query, then one or more specific documents are featured in the search results.</p>', 'BatchGetDocumentStatus' => '<p>Returns the indexing status for one or more documents submitted with the <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_BatchPutDocument.html"> BatchPutDocument</a> API.</p> <p>When you use the <code>BatchPutDocument</code> API, documents are indexed asynchronously. You can use the <code>BatchGetDocumentStatus</code> API to get the current status of a list of documents so that you can determine if they have been successfully indexed.</p> <p>You can also use the <code>BatchGetDocumentStatus</code> API to check the status of the <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_BatchDeleteDocument.html"> BatchDeleteDocument</a> API. When a document is deleted from the index, Amazon Kendra returns <code>NOT_FOUND</code> as the status.</p>', 'BatchPutDocument' => '<p>Adds one or more documents to an index.</p> <p>The <code>BatchPutDocument</code> API enables you to ingest inline documents or a set of documents stored in an Amazon S3 bucket. Use this API to ingest your text and unstructured text into an index, add custom attributes to the documents, and to attach an access control list to the documents added to the index.</p> <p>The documents are indexed asynchronously. You can see the progress of the batch using Amazon Web Services CloudWatch. Any error messages related to processing the batch are sent to your Amazon Web Services CloudWatch log. You can also use the <code>BatchGetDocumentStatus</code> API to monitor the progress of indexing your documents.</p> <p>For an example of ingesting inline documents using Python and Java SDKs, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-binary-doc.html">Adding files directly to an index</a>.</p>', 'ClearQuerySuggestions' => '<p>Clears existing query suggestions from an index.</p> <p>This deletes existing suggestions only, not the queries in the query log. After you clear suggestions, Amazon Kendra learns new suggestions based on new queries added to the query log from the time you cleared suggestions. If you do not see any new suggestions, then please allow Amazon Kendra to collect enough queries to learn new suggestions.</p> <p> <code>ClearQuerySuggestions</code> is currently not supported in the Amazon Web Services GovCloud (US-West) region.</p>', 'CreateAccessControlConfiguration' => '<p>Creates an access configuration for your documents. This includes user and group access information for your documents. This is useful for user context filtering, where search results are filtered based on the user or their group access to documents.</p> <p>You can use this to re-configure your existing document level access control without indexing all of your documents again. For example, your index contains top-secret company documents that only certain employees or users should access. One of these users leaves the company or switches to a team that should be blocked from accessing top-secret documents. The user still has access to top-secret documents because the user had access when your documents were previously indexed. You can create a specific access control configuration for the user with deny access. You can later update the access control configuration to allow access if the user returns to the company and re-joins the \'top-secret\' team. You can re-configure access control for your documents as circumstances change.</p> <p>To apply your access control configuration to certain documents, you call the <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_BatchPutDocument.html">BatchPutDocument</a> API with the <code>AccessControlConfigurationId</code> included in the <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_Document.html">Document</a> object. If you use an S3 bucket as a data source, you update the <code>.metadata.json</code> with the <code>AccessControlConfigurationId</code> and synchronize your data source. Amazon Kendra currently only supports access control configuration for S3 data sources and documents indexed using the <code>BatchPutDocument</code> API.</p>', 'CreateDataSource' => '<p>Creates a data source connector that you want to use with an Amazon Kendra index.</p> <p>You specify a name, data source connector type and description for your data source. You also specify configuration information for the data source connector.</p> <p> <code>CreateDataSource</code> is a synchronous operation. The operation returns 200 if the data source was successfully created. Otherwise, an exception is raised.</p> <p>For an example of creating an index and data source using the Python SDK, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/gs-python.html">Getting started with Python SDK</a>. For an example of creating an index and data source using the Java SDK, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/gs-java.html">Getting started with Java SDK</a>.</p>', 'CreateExperience' => '<p>Creates an Amazon Kendra experience such as a search application. For more information on creating a search application experience, including using the Python and Java SDKs, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search experience with no code</a>.</p>', 'CreateFaq' => '<p>Creates a set of frequently ask questions (FAQs) using a specified FAQ file stored in an Amazon S3 bucket.</p> <p>Adding FAQs to an index is an asynchronous operation.</p> <p>For an example of adding an FAQ to an index using Python and Java SDKs, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-creating-faq.html#using-faq-file">Using your FAQ file</a>.</p>', 'CreateFeaturedResultsSet' => '<p>Creates a set of featured results to display at the top of the search results page. Featured results are placed above all other results for certain queries. You map specific queries to specific documents for featuring in the results. If a query contains an exact match, then one or more specific documents are featured in the search results.</p> <p>You can create up to 50 sets of featured results per index. You can request to increase this limit by contacting <a href="http://aws.amazon.com/contact-us/">Support</a>.</p>', 'CreateIndex' => '<p>Creates an Amazon Kendra index. Index creation is an asynchronous API. To determine if index creation has completed, check the <code>Status</code> field returned from a call to <code>DescribeIndex</code>. The <code>Status</code> field is set to <code>ACTIVE</code> when the index is ready to use.</p> <p>Once the index is active, you can index your documents using the <code>BatchPutDocument</code> API or using one of the supported <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-sources.html">data sources</a>.</p> <p>For an example of creating an index and data source using the Python SDK, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/gs-python.html">Getting started with Python SDK</a>. For an example of creating an index and data source using the Java SDK, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/gs-java.html">Getting started with Java SDK</a>.</p>', 'CreateQuerySuggestionsBlockList' => '<p>Creates a block list to exlcude certain queries from suggestions.</p> <p>Any query that contains words or phrases specified in the block list is blocked or filtered out from being shown as a suggestion.</p> <p>You need to provide the file location of your block list text file in your S3 bucket. In your text file, enter each block word or phrase on a separate line.</p> <p>For information on the current quota limits for block lists, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas for Amazon Kendra</a>.</p> <p> <code>CreateQuerySuggestionsBlockList</code> is currently not supported in the Amazon Web Services GovCloud (US-West) region.</p> <p>For an example of creating a block list for query suggestions using the Python SDK, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/query-suggestions.html#query-suggestions-blocklist">Query suggestions block list</a>.</p>', 'CreateThesaurus' => '<p>Creates a thesaurus for an index. The thesaurus contains a list of synonyms in Solr format.</p> <p>For an example of adding a thesaurus file to an index, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/index-synonyms-adding-thesaurus-file.html">Adding custom synonyms to an index</a>.</p>', 'DeleteAccessControlConfiguration' => '<p>Deletes an access control configuration that you created for your documents in an index. This includes user and group access information for your documents. This is useful for user context filtering, where search results are filtered based on the user or their group access to documents.</p>', 'DeleteDataSource' => '<p>Deletes an Amazon Kendra data source connector. An exception is not thrown if the data source is already being deleted. While the data source is being deleted, the <code>Status</code> field returned by a call to the <code>DescribeDataSource</code> API is set to <code>DELETING</code>. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/delete-data-source.html">Deleting Data Sources</a>.</p> <p>Deleting an entire data source or re-syncing your index after deleting specific documents from a data source could take up to an hour or more, depending on the number of documents you want to delete.</p>', 'DeleteExperience' => '<p>Deletes your Amazon Kendra experience such as a search application. For more information on creating a search application experience, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search experience with no code</a>.</p>', 'DeleteFaq' => '<p>Removes an FAQ from an index.</p>', 'DeleteIndex' => '<p>Deletes an Amazon Kendra index. An exception is not thrown if the index is already being deleted. While the index is being deleted, the <code>Status</code> field returned by a call to the <code>DescribeIndex</code> API is set to <code>DELETING</code>.</p>', 'DeletePrincipalMapping' => '<p>Deletes a group so that all users and sub groups that belong to the group can no longer access documents only available to that group.</p> <p>For example, after deleting the group "Summer Interns", all interns who belonged to that group no longer see intern-only documents in their search results.</p> <p>If you want to delete or replace users or sub groups of a group, you need to use the <code>PutPrincipalMapping</code> operation. For example, if a user in the group "Engineering" leaves the engineering team and another user takes their place, you provide an updated list of users or sub groups that belong to the "Engineering" group when calling <code>PutPrincipalMapping</code>. You can update your internal list of users or sub groups and input this list when calling <code>PutPrincipalMapping</code>.</p> <p> <code>DeletePrincipalMapping</code> is currently not supported in the Amazon Web Services GovCloud (US-West) region.</p>', 'DeleteQuerySuggestionsBlockList' => '<p>Deletes a block list used for query suggestions for an index.</p> <p>A deleted block list might not take effect right away. Amazon Kendra needs to refresh the entire suggestions list to add back the queries that were previously blocked.</p> <p> <code>DeleteQuerySuggestionsBlockList</code> is currently not supported in the Amazon Web Services GovCloud (US-West) region.</p>', 'DeleteThesaurus' => '<p>Deletes an Amazon Kendra thesaurus. </p>', 'DescribeAccessControlConfiguration' => '<p>Gets information about an access control configuration that you created for your documents in an index. This includes user and group access information for your documents. This is useful for user context filtering, where search results are filtered based on the user or their group access to documents.</p>', 'DescribeDataSource' => '<p>Gets information about an Amazon Kendra data source connector.</p>', 'DescribeExperience' => '<p>Gets information about your Amazon Kendra experience such as a search application. For more information on creating a search application experience, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search experience with no code</a>.</p>', 'DescribeFaq' => '<p>Gets information about an FAQ list.</p>', 'DescribeFeaturedResultsSet' => '<p>Gets information about a set of featured results. Features results are placed above all other results for certain queries. If there\'s an exact match of a query, then one or more specific documents are featured in the search results.</p>', 'DescribeIndex' => '<p>Gets information about an Amazon Kendra index.</p>', 'DescribePrincipalMapping' => '<p>Describes the processing of <code>PUT</code> and <code>DELETE</code> actions for mapping users to their groups. This includes information on the status of actions currently processing or yet to be processed, when actions were last updated, when actions were received by Amazon Kendra, the latest action that should process and apply after other actions, and useful error messages if an action could not be processed.</p> <p> <code>DescribePrincipalMapping</code> is currently not supported in the Amazon Web Services GovCloud (US-West) region.</p>', 'DescribeQuerySuggestionsBlockList' => '<p>Gets information about a block list used for query suggestions for an index.</p> <p>This is used to check the current settings that are applied to a block list.</p> <p> <code>DescribeQuerySuggestionsBlockList</code> is currently not supported in the Amazon Web Services GovCloud (US-West) region.</p>', 'DescribeQuerySuggestionsConfig' => '<p>Gets information on the settings of query suggestions for an index.</p> <p>This is used to check the current settings applied to query suggestions.</p> <p> <code>DescribeQuerySuggestionsConfig</code> is currently not supported in the Amazon Web Services GovCloud (US-West) region.</p>', 'DescribeThesaurus' => '<p>Gets information about an Amazon Kendra thesaurus.</p>', 'DisassociateEntitiesFromExperience' => '<p>Prevents users or groups in your IAM Identity Center identity source from accessing your Amazon Kendra experience. You can create an Amazon Kendra experience such as a search application. For more information on creating a search application experience, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search experience with no code</a>.</p>', 'DisassociatePersonasFromEntities' => '<p>Removes the specific permissions of users or groups in your IAM Identity Center identity source with access to your Amazon Kendra experience. You can create an Amazon Kendra experience such as a search application. For more information on creating a search application experience, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search experience with no code</a>.</p>', 'GetQuerySuggestions' => '<p>Fetches the queries that are suggested to your users.</p> <p> <code>GetQuerySuggestions</code> is currently not supported in the Amazon Web Services GovCloud (US-West) region.</p>', 'GetSnapshots' => '<p>Retrieves search metrics data. The data provides a snapshot of how your users interact with your search application and how effective the application is.</p>', 'ListAccessControlConfigurations' => '<p>Lists one or more access control configurations for an index. This includes user and group access information for your documents. This is useful for user context filtering, where search results are filtered based on the user or their group access to documents.</p>', 'ListDataSourceSyncJobs' => '<p>Gets statistics about synchronizing a data source connector.</p>', 'ListDataSources' => '<p>Lists the data source connectors that you have created.</p>', 'ListEntityPersonas' => '<p>Lists specific permissions of users and groups with access to your Amazon Kendra experience.</p>', 'ListExperienceEntities' => '<p>Lists users or groups in your IAM Identity Center identity source that are granted access to your Amazon Kendra experience. You can create an Amazon Kendra experience such as a search application. For more information on creating a search application experience, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search experience with no code</a>.</p>', 'ListExperiences' => '<p>Lists one or more Amazon Kendra experiences. You can create an Amazon Kendra experience such as a search application. For more information on creating a search application experience, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search experience with no code</a>.</p>', 'ListFaqs' => '<p>Gets a list of FAQ lists associated with an index.</p>', 'ListFeaturedResultsSets' => '<p>Lists all your sets of featured results for a given index. Features results are placed above all other results for certain queries. If there\'s an exact match of a query, then one or more specific documents are featured in the search results.</p>', 'ListGroupsOlderThanOrderingId' => '<p>Provides a list of groups that are mapped to users before a given ordering or timestamp identifier.</p> <p> <code>ListGroupsOlderThanOrderingId</code> is currently not supported in the Amazon Web Services GovCloud (US-West) region.</p>', 'ListIndices' => '<p>Lists the Amazon Kendra indexes that you created.</p>', 'ListQuerySuggestionsBlockLists' => '<p>Lists the block lists used for query suggestions for an index.</p> <p>For information on the current quota limits for block lists, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas for Amazon Kendra</a>.</p> <p> <code>ListQuerySuggestionsBlockLists</code> is currently not supported in the Amazon Web Services GovCloud (US-West) region.</p>', 'ListTagsForResource' => '<p>Gets a list of tags associated with a specified resource. Indexes, FAQs, and data sources can have tags associated with them.</p>', 'ListThesauri' => '<p>Lists the thesauri for an index.</p>', 'PutPrincipalMapping' => '<p>Maps users to their groups so that you only need to provide the user ID when you issue the query.</p> <p>You can also map sub groups to groups. For example, the group "Company Intellectual Property Teams" includes sub groups "Research" and "Engineering". These sub groups include their own list of users or people who work in these teams. Only users who work in research and engineering, and therefore belong in the intellectual property group, can see top-secret company documents in their search results.</p> <p>This is useful for user context filtering, where search results are filtered based on the user or their group access to documents. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/user-context-filter.html">Filtering on user context</a>.</p> <p>If more than five <code>PUT</code> actions for a group are currently processing, a validation exception is thrown.</p>', 'Query' => '<p>Searches an index given an input query.</p> <note> <p>If you are working with large language models (LLMs) or implementing retrieval augmented generation (RAG) systems, you can use Amazon Kendra\'s <a href="https://docs.aws.amazon.com/kendra/latest/APIReference/API_Retrieve.html">Retrieve</a> API, which can return longer semantically relevant passages. We recommend using the <code>Retrieve</code> API instead of filing a service limit increase to increase the <code>Query</code> API document excerpt length.</p> </note> <p>You can configure boosting or relevance tuning at the query level to override boosting at the index level, filter based on document fields/attributes and faceted search, and filter based on the user or their group access to documents. You can also include certain fields in the response that might provide useful additional information.</p> <p>A query response contains three types of results.</p> <ul> <li> <p>Relevant suggested answers. The answers can be either a text excerpt or table excerpt. The answer can be highlighted in the excerpt.</p> </li> <li> <p>Matching FAQs or questions-answer from your FAQ file.</p> </li> <li> <p>Relevant documents. This result type includes an excerpt of the document with the document title. The searched terms can be highlighted in the excerpt.</p> </li> </ul> <p>You can specify that the query return only one type of result using the <code>QueryResultTypeFilter</code> parameter. Each query returns the 100 most relevant results. If you filter result type to only question-answers, a maximum of four results are returned. If you filter result type to only answers, a maximum of three results are returned.</p>', 'Retrieve' => '<p>Retrieves relevant passages or text excerpts given an input query.</p> <p>This API is similar to the <a href="https://docs.aws.amazon.com/kendra/latest/APIReference/API_Query.html">Query</a> API. However, by default, the <code>Query</code> API only returns excerpt passages of up to 100 token words. With the <code>Retrieve</code> API, you can retrieve longer passages of up to 200 token words and up to 100 semantically relevant passages. This doesn\'t include question-answer or FAQ type responses from your index. The passages are text excerpts that can be semantically extracted from multiple documents and multiple parts of the same document. If in extreme cases your documents produce zero passages using the <code>Retrieve</code> API, you can alternatively use the <code>Query</code> API and its types of responses.</p> <p>You can also do the following:</p> <ul> <li> <p>Override boosting at the index level</p> </li> <li> <p>Filter based on document fields or attributes</p> </li> <li> <p>Filter based on the user or their group access to documents</p> </li> <li> <p>View the confidence score bucket for a retrieved passage result. The confidence bucket provides a relative ranking that indicates how confident Amazon Kendra is that the response is relevant to the query.</p> <note> <p>Confidence score buckets are currently available only for English.</p> </note> </li> </ul> <p>You can also include certain fields in the response that might provide useful additional information.</p> <p>The <code>Retrieve</code> API shares the number of <a href="https://docs.aws.amazon.com/kendra/latest/APIReference/API_CapacityUnitsConfiguration.html">query capacity units</a> that you set for your index. For more information on what\'s included in a single capacity unit and the default base capacity for an index, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/adjusting-capacity.html">Adjusting capacity</a>.</p>', 'StartDataSourceSyncJob' => '<p>Starts a synchronization job for a data source connector. If a synchronization job is already in progress, Amazon Kendra returns a <code>ResourceInUseException</code> exception.</p> <p>Re-syncing your data source with your index after modifying, adding, or deleting documents from your data source respository could take up to an hour or more, depending on the number of documents to sync.</p>', 'StopDataSourceSyncJob' => '<p>Stops a synchronization job that is currently running. You can\'t stop a scheduled synchronization job.</p>', 'SubmitFeedback' => '<p>Enables you to provide feedback to Amazon Kendra to improve the performance of your index.</p> <p> <code>SubmitFeedback</code> is currently not supported in the Amazon Web Services GovCloud (US-West) region.</p>', 'TagResource' => '<p>Adds the specified tag to the specified index, FAQ, or data source resource. If the tag already exists, the existing value is replaced with the new value.</p>', 'UntagResource' => '<p>Removes a tag from an index, FAQ, or a data source.</p>', 'UpdateAccessControlConfiguration' => '<p>Updates an access control configuration for your documents in an index. This includes user and group access information for your documents. This is useful for user context filtering, where search results are filtered based on the user or their group access to documents.</p> <p>You can update an access control configuration you created without indexing all of your documents again. For example, your index contains top-secret company documents that only certain employees or users should access. You created an \'allow\' access control configuration for one user who recently joined the \'top-secret\' team, switching from a team with \'deny\' access to top-secret documents. However, the user suddenly returns to their previous team and should no longer have access to top secret documents. You can update the access control configuration to re-configure access control for your documents as circumstances change.</p> <p>You call the <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_BatchPutDocument.html">BatchPutDocument</a> API to apply the updated access control configuration, with the <code>AccessControlConfigurationId</code> included in the <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_Document.html">Document</a> object. If you use an S3 bucket as a data source, you synchronize your data source to apply the <code>AccessControlConfigurationId</code> in the <code>.metadata.json</code> file. Amazon Kendra currently only supports access control configuration for S3 data sources and documents indexed using the <code>BatchPutDocument</code> API.</p>', 'UpdateDataSource' => '<p>Updates an Amazon Kendra data source connector.</p>', 'UpdateExperience' => '<p>Updates your Amazon Kendra experience such as a search application. For more information on creating a search application experience, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search experience with no code</a>.</p>', 'UpdateFeaturedResultsSet' => '<p>Updates a set of featured results. Features results are placed above all other results for certain queries. You map specific queries to specific documents for featuring in the results. If a query contains an exact match of a query, then one or more specific documents are featured in the search results.</p>', 'UpdateIndex' => '<p>Updates an Amazon Kendra index.</p>', 'UpdateQuerySuggestionsBlockList' => '<p>Updates a block list used for query suggestions for an index.</p> <p>Updates to a block list might not take effect right away. Amazon Kendra needs to refresh the entire suggestions list to apply any updates to the block list. Other changes not related to the block list apply immediately.</p> <p>If a block list is updating, then you need to wait for the first update to finish before submitting another update.</p> <p>Amazon Kendra supports partial updates, so you only need to provide the fields you want to update.</p> <p> <code>UpdateQuerySuggestionsBlockList</code> is currently not supported in the Amazon Web Services GovCloud (US-West) region.</p>', 'UpdateQuerySuggestionsConfig' => '<p>Updates the settings of query suggestions for an index.</p> <p>Amazon Kendra supports partial updates, so you only need to provide the fields you want to update.</p> <p>If an update is currently processing, you need to wait for the update to finish before making another update.</p> <p>Updates to query suggestions settings might not take effect right away. The time for your updated settings to take effect depends on the updates made and the number of search queries in your index.</p> <p>You can still enable/disable query suggestions at any time.</p> <p> <code>UpdateQuerySuggestionsConfig</code> is currently not supported in the Amazon Web Services GovCloud (US-West) region.</p>', 'UpdateThesaurus' => '<p>Updates a thesaurus for an index.</p>', ], 'shapes' => [ 'AccessControlConfigurationId' => [ 'base' => NULL, 'refs' => [ 'AccessControlConfigurationSummary$Id' => '<p>The identifier of the access control configuration.</p>', 'CreateAccessControlConfigurationResponse$Id' => '<p>The identifier of the access control configuration for your documents in an index.</p>', 'DeleteAccessControlConfigurationRequest$Id' => '<p>The identifier of the access control configuration you want to delete.</p>', 'DescribeAccessControlConfigurationRequest$Id' => '<p>The identifier of the access control configuration you want to get information on.</p>', 'Document$AccessControlConfigurationId' => '<p>The identifier of the access control configuration that you want to apply to the document.</p>', 'UpdateAccessControlConfigurationRequest$Id' => '<p>The identifier of the access control configuration you want to update.</p>', ], ], 'AccessControlConfigurationName' => [ 'base' => NULL, 'refs' => [ 'CreateAccessControlConfigurationRequest$Name' => '<p>A name for the access control configuration.</p>', 'DescribeAccessControlConfigurationResponse$Name' => '<p>The name for the access control configuration.</p>', 'UpdateAccessControlConfigurationRequest$Name' => '<p>A new name for the access control configuration.</p>', ], ], 'AccessControlConfigurationSummary' => [ 'base' => '<p>Summary information on an access control configuration that you created for your documents in an index.</p>', 'refs' => [ 'AccessControlConfigurationSummaryList$member' => NULL, ], ], 'AccessControlConfigurationSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListAccessControlConfigurationsResponse$AccessControlConfigurations' => '<p>The details of your access control configurations.</p>', ], ], 'AccessControlListConfiguration' => [ 'base' => '<p>Access Control List files for the documents in a data source. For the format of the file, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/s3-acl.html">Access control for S3 data sources</a>.</p>', 'refs' => [ 'S3DataSourceConfiguration$AccessControlListConfiguration' => '<p>Provides the path to the S3 bucket that contains the user context filtering files for the data source. For the format of the file, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/s3-acl.html">Access control for S3 data sources</a>.</p>', ], ], 'AccessDeniedException' => [ 'base' => '<p>You don\'t have sufficient access to perform this action. Please ensure you have the required permission policies and user accounts and try again.</p>', 'refs' => [], ], 'AclConfiguration' => [ 'base' => '<p>Provides information about the column that should be used for filtering the query response by groups.</p>', 'refs' => [ 'DatabaseConfiguration$AclConfiguration' => '<p>Information about the database column that provides information for user context filtering.</p>', ], ], 'AdditionalResultAttribute' => [ 'base' => '<p>An attribute returned from an index query.</p>', 'refs' => [ 'AdditionalResultAttributeList$member' => NULL, ], ], 'AdditionalResultAttributeList' => [ 'base' => NULL, 'refs' => [ 'FeaturedResultsItem$AdditionalAttributes' => '<p>One or more additional attributes associated with the featured result.</p>', 'QueryResultItem$AdditionalAttributes' => '<p>One or more additional fields/attributes associated with the query result.</p>', ], ], 'AdditionalResultAttributeValue' => [ 'base' => '<p>An attribute returned with a document from a search.</p>', 'refs' => [ 'AdditionalResultAttribute$Value' => '<p>An object that contains the attribute value.</p>', ], ], 'AdditionalResultAttributeValueType' => [ 'base' => NULL, 'refs' => [ 'AdditionalResultAttribute$ValueType' => '<p>The data type of the <code>Value</code> property.</p>', ], ], 'AlfrescoConfiguration' => [ 'base' => '<p>Provides the configuration information to connect to Alfresco as your data source.</p> <note> <p>Support for <code>AlfrescoConfiguration</code> ended May 2023. We recommend migrating to or using the Alfresco data source template schema / <a href="https://docs.aws.amazon.com/kendra/latest/APIReference/API_TemplateConfiguration.html">TemplateConfiguration</a> API.</p> </note>', 'refs' => [ 'DataSourceConfiguration$AlfrescoConfiguration' => '<p>Provides the configuration information to connect to Alfresco as your data source.</p> <note> <p>Support for <code>AlfrescoConfiguration</code> ended May 2023. We recommend migrating to or using the Alfresco data source template schema / <a href="https://docs.aws.amazon.com/kendra/latest/APIReference/API_TemplateConfiguration.html">TemplateConfiguration</a> API.</p> </note>', ], ], 'AlfrescoEntity' => [ 'base' => NULL, 'refs' => [ 'EntityFilter$member' => NULL, ], ], 'AmazonResourceName' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$ResourceARN' => '<p>The Amazon Resource Name (ARN) of the index, FAQ, or data source to get a list of tags for.</p>', 'TagResourceRequest$ResourceARN' => '<p>The Amazon Resource Name (ARN) of the index, FAQ, or data source to tag.</p>', 'UntagResourceRequest$ResourceARN' => '<p>The Amazon Resource Name (ARN) of the index, FAQ, or data source to remove the tag from.</p>', ], ], 'AssociateEntitiesToExperienceFailedEntityList' => [ 'base' => NULL, 'refs' => [ 'AssociateEntitiesToExperienceResponse$FailedEntityList' => '<p>Lists the users or groups in your IAM Identity Center identity source that failed to properly configure with your Amazon Kendra experience.</p>', ], ], 'AssociateEntitiesToExperienceRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateEntitiesToExperienceResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociateEntityList' => [ 'base' => NULL, 'refs' => [ 'AssociateEntitiesToExperienceRequest$EntityList' => '<p>Lists users or groups in your IAM Identity Center identity source.</p>', ], ], 'AssociatePersonasToEntitiesRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociatePersonasToEntitiesResponse' => [ 'base' => NULL, 'refs' => [], ], 'AttributeFilter' => [ 'base' => '<p>Filters the search results based on document attributes or fields.</p> <p>You can filter results using attributes for your particular documents. The attributes must exist in your index. For example, if your documents include the custom attribute "Department", you can filter documents that belong to the "HR" department. You would use the <code>EqualsTo</code> operation to filter results or documents with "Department" equals to "HR".</p> <p>You can use <code>AndAllFilters</code> and <code>AndOrFilters</code> in combination with each other or with other operations such as <code>EqualsTo</code>. For example:</p> <p> <code>AndAllFilters</code> </p> <ul> <li> <p> <code>EqualsTo</code>: "Department", "HR"</p> </li> <li> <p> <code>AndOrFilters</code> </p> <ul> <li> <p> <code>ContainsAny</code>: "Project Name", ["new hires", "new hiring"]</p> </li> </ul> </li> </ul> <p>This example filters results or documents that belong to the HR department <i>and</i> belong to projects that contain "new hires" <i>or</i> "new hiring" in the project name (must use <code>ContainAny</code> with <code>StringListValue</code>). This example is filtering with a depth of 2.</p> <p>You cannot filter more than a depth of 2, otherwise you receive a <code>ValidationException</code> exception with the message "AttributeFilter cannot have a depth of more than 2." Also, if you use more than 10 attribute filters in a given list for <code>AndAllFilters</code> or <code>OrAllFilters</code>, you receive a <code>ValidationException</code> with the message "AttributeFilter cannot have a length of more than 10".</p> <p>For examples of using <code>AttributeFilter</code>, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/filtering.html#search-filtering">Using document attributes to filter search results</a>.</p>', 'refs' => [ 'AttributeFilter$NotFilter' => '<p>Performs a logical <code>NOT</code> operation on all filters that you specify.</p>', 'AttributeFilterList$member' => NULL, 'AttributeSuggestionsGetConfig$AttributeFilter' => '<p>Filters the search results based on document fields/attributes.</p>', 'QueryRequest$AttributeFilter' => '<p>Filters search results by document fields/attributes. You can only provide one attribute filter; however, the <code>AndAllFilters</code>, <code>NotFilter</code>, and <code>OrAllFilters</code> parameters contain a list of other filters.</p> <p>The <code>AttributeFilter</code> parameter means you can create a set of filtering rules that a document must satisfy to be included in the query results.</p>', 'RetrieveRequest$AttributeFilter' => '<p>Filters search results by document fields/attributes. You can only provide one attribute filter; however, the <code>AndAllFilters</code>, <code>NotFilter</code>, and <code>OrAllFilters</code> parameters contain a list of other filters.</p> <p>The <code>AttributeFilter</code> parameter means you can create a set of filtering rules that a document must satisfy to be included in the query results.</p>', ], ], 'AttributeFilterList' => [ 'base' => NULL, 'refs' => [ 'AttributeFilter$AndAllFilters' => '<p>Performs a logical <code>AND</code> operation on all filters that you specify.</p>', 'AttributeFilter$OrAllFilters' => '<p>Performs a logical <code>OR</code> operation on all filters that you specify.</p>', ], ], 'AttributeSuggestionsDescribeConfig' => [ 'base' => '<p>Gets information on the configuration of document fields/attributes that you want to base query suggestions on. To change your configuration, use <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_AttributeSuggestionsUpdateConfig.html">AttributeSuggestionsUpdateConfig</a> and then call <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateQuerySuggestionsConfig.html">UpdateQuerySuggestionsConfig</a>.</p>', 'refs' => [ 'DescribeQuerySuggestionsConfigResponse$AttributeSuggestionsConfig' => '<p>Configuration information for the document fields/attributes that you want to base query suggestions on.</p>', ], ], 'AttributeSuggestionsGetConfig' => [ 'base' => '<p>Provides the configuration information for the document fields/attributes that you want to base query suggestions on.</p>', 'refs' => [ 'GetQuerySuggestionsRequest$AttributeSuggestionsConfig' => '<p>Configuration information for the document fields/attributes that you want to base query suggestions on.</p>', ], ], 'AttributeSuggestionsMode' => [ 'base' => NULL, 'refs' => [ 'AttributeSuggestionsDescribeConfig$AttributeSuggestionsMode' => '<p>The mode is set to either <code>ACTIVE</code> or <code>INACTIVE</code>. If the <code>Mode</code> for query history is set to <code>ENABLED</code> when calling <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateQuerySuggestionsConfig.html">UpdateQuerySuggestionsConfig</a> and <code>AttributeSuggestionsMode</code> to use fields/attributes is set to <code>ACTIVE</code>, and you haven\'t set your <code>SuggestionTypes</code> preference to <code>DOCUMENT_ATTRIBUTES</code>, then Amazon Kendra uses the query history.</p>', 'AttributeSuggestionsUpdateConfig$AttributeSuggestionsMode' => '<p>You can set the mode to <code>ACTIVE</code> or <code>INACTIVE</code>. You must also set <code>SuggestionTypes</code> as either <code>QUERY</code> or <code>DOCUMENT_ATTRIBUTES</code> and then call <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_GetQuerySuggestions.html">GetQuerySuggestions</a>. If <code>Mode</code> to use query history is set to <code>ENABLED</code> when calling <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateQuerySuggestionsConfig.html">UpdateQuerySuggestionsConfig</a> and <code>AttributeSuggestionsMode</code> to use fields/attributes is set to <code>ACTIVE</code>, and you haven\'t set your <code>SuggestionTypes</code> preference to <code>DOCUMENT_ATTRIBUTES</code>, then Amazon Kendra uses the query history.</p>', ], ], 'AttributeSuggestionsUpdateConfig' => [ 'base' => '<p>Updates the configuration information for the document fields/attributes that you want to base query suggestions on.</p> <p>To deactivate using documents fields for query suggestions, set the mode to <code>INACTIVE</code>. You must also set <code>SuggestionTypes</code> as either <code>QUERY</code> or <code>DOCUMENT_ATTRIBUTES</code> and then call <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_GetQuerySuggestions.html">GetQuerySuggestions</a>. If you set to <code>QUERY</code>, then Amazon Kendra uses the query history to base suggestions on. If you set to <code>DOCUMENT_ATTRIBUTES</code>, then Amazon Kendra uses the contents of document fields to base suggestions on.</p>', 'refs' => [ 'UpdateQuerySuggestionsConfigRequest$AttributeSuggestionsConfig' => '<p>Configuration information for the document fields/attributes that you want to base query suggestions on.</p>', ], ], 'AuthenticationConfiguration' => [ 'base' => '<p>Provides the configuration information to connect to websites that require user authentication.</p>', 'refs' => [ 'WebCrawlerConfiguration$AuthenticationConfiguration' => '<p>Configuration information required to connect to websites using authentication.</p> <p>You can connect to websites using basic authentication of user name and password. You use a secret in <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html">Secrets Manager</a> to store your authentication credentials.</p> <p>You must provide the website host name and port number. For example, the host name of https://a.example.com/page1.html is "a.example.com" and the port is 443, the standard port for HTTPS.</p>', ], ], 'BasicAuthenticationConfiguration' => [ 'base' => '<p>Provides the configuration information to connect to websites that require basic user authentication.</p>', 'refs' => [ 'BasicAuthenticationConfigurationList$member' => NULL, ], ], 'BasicAuthenticationConfigurationList' => [ 'base' => NULL, 'refs' => [ 'AuthenticationConfiguration$BasicAuthentication' => '<p>The list of configuration information that\'s required to connect to and crawl a website host using basic authentication credentials.</p> <p>The list includes the name and port number of the website host.</p>', ], ], 'BatchDeleteDocumentRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchDeleteDocumentResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchDeleteDocumentResponseFailedDocument' => [ 'base' => '<p>Provides information about documents that could not be removed from an index by the <code>BatchDeleteDocument</code> API.</p>', 'refs' => [ 'BatchDeleteDocumentResponseFailedDocuments$member' => NULL, ], ], 'BatchDeleteDocumentResponseFailedDocuments' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteDocumentResponse$FailedDocuments' => '<p>A list of documents that could not be removed from the index. Each entry contains an error message that indicates why the document couldn\'t be removed from the index.</p>', ], ], 'BatchDeleteFeaturedResultsSetError' => [ 'base' => '<p>Provides information about a set of featured results that couldn\'t be removed from an index by the <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_BatchDeleteFeaturedResultsSet.html">BatchDeleteFeaturedResultsSet</a> API.</p>', 'refs' => [ 'BatchDeleteFeaturedResultsSetErrors$member' => NULL, ], ], 'BatchDeleteFeaturedResultsSetErrors' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteFeaturedResultsSetResponse$Errors' => '<p>The list of errors for the featured results set IDs, explaining why they couldn\'t be removed from the index.</p>', ], ], 'BatchDeleteFeaturedResultsSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchDeleteFeaturedResultsSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetDocumentStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetDocumentStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetDocumentStatusResponseError' => [ 'base' => '<p>Provides a response when the status of a document could not be retrieved.</p>', 'refs' => [ 'BatchGetDocumentStatusResponseErrors$member' => NULL, ], ], 'BatchGetDocumentStatusResponseErrors' => [ 'base' => NULL, 'refs' => [ 'BatchGetDocumentStatusResponse$Errors' => '<p>A list of documents that Amazon Kendra couldn\'t get the status for. The list includes the ID of the document and the reason that the status couldn\'t be found.</p>', ], ], 'BatchPutDocumentRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchPutDocumentResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchPutDocumentResponseFailedDocument' => [ 'base' => '<p>Provides information about a document that could not be indexed.</p>', 'refs' => [ 'BatchPutDocumentResponseFailedDocuments$member' => NULL, ], ], 'BatchPutDocumentResponseFailedDocuments' => [ 'base' => NULL, 'refs' => [ 'BatchPutDocumentResponse$FailedDocuments' => '<p>A list of documents that were not added to the index because the document failed a validation check. Each document contains an error message that indicates why the document couldn\'t be added to the index.</p> <p>If there was an error adding a document to an index the error is reported in your Amazon Web Services CloudWatch log. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/cloudwatch-logs.html">Monitoring Amazon Kendra with Amazon CloudWatch logs</a>.</p>', ], ], 'Blob' => [ 'base' => NULL, 'refs' => [ 'Document$Blob' => '<p>The contents of the document. </p> <p>Documents passed to the <code>Blob</code> parameter must be base64 encoded. Your code might not need to encode the document file bytes if you\'re using an Amazon Web Services SDK to call Amazon Kendra APIs. If you are calling the Amazon Kendra endpoint directly using REST, you must base64 encode the contents before sending.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'AlfrescoConfiguration$CrawlSystemFolders' => '<p> <code>TRUE</code> to index shared files.</p>', 'AlfrescoConfiguration$CrawlComments' => '<p> <code>TRUE</code> to index comments of blogs and other content.</p>', 'BoxConfiguration$UseChangeLog' => '<p> <code>TRUE</code> to use the Slack change log to determine which documents require updating in the index. Depending on the data source change log\'s size, it may take longer for Amazon Kendra to use the change log than to scan all of your documents.</p>', 'BoxConfiguration$CrawlComments' => '<p> <code>TRUE</code> to index comments.</p>', 'BoxConfiguration$CrawlTasks' => '<p> <code>TRUE</code> to index the contents of tasks.</p>', 'BoxConfiguration$CrawlWebLinks' => '<p> <code>TRUE</code> to index web links.</p>', 'CollapseConfiguration$Expand' => '<p>Specifies whether to expand the collapsed results.</p>', 'ConfluenceAttachmentConfiguration$CrawlAttachments' => '<p> <code>TRUE</code> to index attachments of pages and blogs in Confluence.</p>', 'ConfluenceSpaceConfiguration$CrawlPersonalSpaces' => '<p> <code>TRUE</code> to index personal spaces. You can add restrictions to items in personal spaces. If personal spaces are indexed, queries without user context information may return restricted items from a personal space in their results. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/user-context-filter.html">Filtering on user context</a>.</p>', 'ConfluenceSpaceConfiguration$CrawlArchivedSpaces' => '<p> <code>TRUE</code> to index archived spaces.</p>', 'ContentSourceConfiguration$DirectPutContent' => '<p> <code>TRUE</code> to use documents you indexed directly using the <code>BatchPutDocument</code> API.</p>', 'DocumentAttributeTarget$TargetDocumentAttributeValueDeletion' => '<p> <code>TRUE</code> to delete the existing target value for your specified target attribute key. You cannot create a target value and set this to <code>TRUE</code>. To create a target value (<code>TargetDocumentAttributeValue</code>), set this to <code>FALSE</code>.</p>', 'GitHubConfiguration$UseChangeLog' => '<p> <code>TRUE</code> to use the GitHub change log to determine which documents require updating in the index. Depending on the GitHub change log\'s size, it may take longer for Amazon Kendra to use the change log than to scan all of your documents in GitHub.</p>', 'GitHubDocumentCrawlProperties$CrawlRepositoryDocuments' => '<p> <code>TRUE</code> to index all files with a repository.</p>', 'GitHubDocumentCrawlProperties$CrawlIssue' => '<p> <code>TRUE</code> to index all issues within a repository.</p>', 'GitHubDocumentCrawlProperties$CrawlIssueComment' => '<p> <code>TRUE</code> to index all comments on issues.</p>', 'GitHubDocumentCrawlProperties$CrawlIssueCommentAttachment' => '<p> <code>TRUE</code> to include all comment attachments for issues.</p>', 'GitHubDocumentCrawlProperties$CrawlPullRequest' => '<p> <code>TRUE</code> to index all pull requests within a repository.</p>', 'GitHubDocumentCrawlProperties$CrawlPullRequestComment' => '<p> <code>TRUE</code> to index all comments on pull requests.</p>', 'GitHubDocumentCrawlProperties$CrawlPullRequestCommentAttachment' => '<p> <code>TRUE</code> to include all comment attachments for pull requests.</p>', 'Highlight$TopAnswer' => '<p>Indicates whether the response is the best response. True if this is the best response; otherwise, false.</p>', 'InlineCustomDocumentEnrichmentConfiguration$DocumentContentDeletion' => '<p> <code>TRUE</code> to delete content if the condition used for the target attribute is met.</p>', 'JiraConfiguration$UseChangeLog' => '<p> <code>TRUE</code> to use the Jira change log to determine which documents require updating in the index. Depending on the change log\'s size, it may take longer for Amazon Kendra to use the change log than to scan all of your documents in Jira.</p>', 'OneDriveConfiguration$DisableLocalGroups' => '<p> <code>TRUE</code> to disable local groups information.</p>', 'QuipConfiguration$CrawlFileComments' => '<p> <code>TRUE</code> to index file comments.</p>', 'QuipConfiguration$CrawlChatRooms' => '<p> <code>TRUE</code> to index the contents of chat rooms.</p>', 'QuipConfiguration$CrawlAttachments' => '<p> <code>TRUE</code> to index attachments.</p>', 'SalesforceConfiguration$CrawlAttachments' => '<p>Indicates whether Amazon Kendra should index attachments to Salesforce objects.</p>', 'Search$Facetable' => '<p>Indicates that the field can be used to create search facets, a count of results for each value in the field. The default is <code>false</code> .</p>', 'Search$Searchable' => '<p>Determines whether the field is used in the search. If the <code>Searchable</code> field is <code>true</code>, you can use relevance tuning to manually tune how Amazon Kendra weights the field in the search. The default is <code>true</code> for string fields and <code>false</code> for number and date fields.</p>', 'Search$Displayable' => '<p>Determines whether the field is returned in the query response. The default is <code>true</code>.</p>', 'Search$Sortable' => '<p>Determines whether the field can be used to sort the results of a query. If you specify sorting on a field that does not have <code>Sortable</code> set to <code>true</code>, Amazon Kendra returns an exception. The default is <code>false</code>.</p>', 'ServiceNowKnowledgeArticleConfiguration$CrawlAttachments' => '<p> <code>TRUE</code> to index attachments to knowledge articles.</p>', 'ServiceNowServiceCatalogConfiguration$CrawlAttachments' => '<p> <code>TRUE</code> to index attachments to service catalog items.</p>', 'SharePointConfiguration$CrawlAttachments' => '<p> <code>TRUE</code> to index document attachments.</p>', 'SharePointConfiguration$UseChangeLog' => '<p> <code>TRUE</code> to use the SharePoint change log to determine which documents require updating in the index. Depending on the change log\'s size, it may take longer for Amazon Kendra to use the change log than to scan all of your documents in SharePoint.</p>', 'SharePointConfiguration$DisableLocalGroups' => '<p> <code>TRUE</code> to disable local groups information.</p>', 'SlackConfiguration$UseChangeLog' => '<p> <code>TRUE</code> to use the Slack change log to determine which documents require updating in the index. Depending on the Slack change log\'s size, it may take longer for Amazon Kendra to use the change log than to scan all of your documents in Slack.</p>', 'SlackConfiguration$CrawlBotMessage' => '<p> <code>TRUE</code> to index bot messages from your Slack workspace team.</p>', 'SlackConfiguration$ExcludeArchived' => '<p> <code>TRUE</code> to exclude archived messages to index from your Slack workspace team.</p>', 'SpellCorrectionConfiguration$IncludeQuerySpellCheckSuggestions' => '<p> <code>TRUE</code> to suggest spell corrections for queries.</p>', 'TableCell$TopAnswer' => '<p> <code>TRUE</code> if the response of the table cell is the top answer. This is the cell value or content with the highest confidence score or is the most relevant to the query.</p>', 'TableCell$Highlighted' => '<p> <code>TRUE</code> means that the table cell has a high enough confidence and is relevant to the query, so the value or content should be highlighted.</p>', 'TableCell$Header' => '<p> <code>TRUE</code> means that the table cell should be treated as a header.</p>', 'WorkDocsConfiguration$CrawlComments' => '<p> <code>TRUE</code> to include comments on documents in your index. Including comments in your index means each comment is a document that can be searched on.</p> <p>The default is set to <code>FALSE</code>.</p>', 'WorkDocsConfiguration$UseChangeLog' => '<p> <code>TRUE</code> to use the Amazon WorkDocs change log to determine which documents require updating in the index. Depending on the change log\'s size, it may take longer for Amazon Kendra to use the change log than to scan all of your documents in Amazon WorkDocs.</p>', ], ], 'BoxConfiguration' => [ 'base' => '<p>Provides the configuration information to connect to Box as your data source.</p>', 'refs' => [ 'DataSourceConfiguration$BoxConfiguration' => '<p>Provides the configuration information to connect to Box as your data source.</p>', ], ], 'CapacityUnitsConfiguration' => [ 'base' => '<p>Specifies additional capacity units configured for your Enterprise Edition index. You can add and remove capacity units to fit your usage requirements.</p>', 'refs' => [ 'DescribeIndexResponse$CapacityUnits' => '<p>For Enterprise Edition indexes, you can choose to use additional capacity to meet the needs of your application. This contains the capacity units used for the index. A query or document storage capacity of zero indicates that the index is using the default capacity. For more information on the default capacity for an index and adjusting this, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/adjusting-capacity.html">Adjusting capacity</a>.</p>', 'UpdateIndexRequest$CapacityUnits' => '<p>Sets the number of additional document storage and query capacity units that should be used by the index. You can change the capacity of the index up to 5 times per day, or make 5 API calls.</p> <p>If you are using extra storage units, you can\'t reduce the storage capacity below what is required to meet the storage needs for your index.</p>', ], ], 'ChangeDetectingColumns' => [ 'base' => NULL, 'refs' => [ 'ColumnConfiguration$ChangeDetectingColumns' => '<p>One to five columns that indicate when a document in the database has changed.</p>', ], ], 'ClaimRegex' => [ 'base' => NULL, 'refs' => [ 'JwtTokenTypeConfiguration$ClaimRegex' => '<p>The regular expression that identifies the claim.</p>', ], ], 'ClearQuerySuggestionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ClickFeedback' => [ 'base' => '<p>Gathers information about when a particular result was clicked by a user. Your application uses the <code>SubmitFeedback</code> API to provide click information.</p>', 'refs' => [ 'ClickFeedbackList$member' => NULL, ], ], 'ClickFeedbackList' => [ 'base' => NULL, 'refs' => [ 'SubmitFeedbackRequest$ClickFeedbackItems' => '<p>Tells Amazon Kendra that a particular search result link was chosen by the user. </p>', ], ], 'ClientTokenName' => [ 'base' => NULL, 'refs' => [ 'CreateAccessControlConfigurationRequest$ClientToken' => '<p>A token that you provide to identify the request to create an access control configuration. Multiple calls to the <code>CreateAccessControlConfiguration</code> API with the same client token will create only one access control configuration.</p>', 'CreateDataSourceRequest$ClientToken' => '<p>A token that you provide to identify the request to create a data source connector. Multiple calls to the <code>CreateDataSource</code> API with the same client token will create only one data source connector.</p>', 'CreateExperienceRequest$ClientToken' => '<p>A token that you provide to identify the request to create your Amazon Kendra experience. Multiple calls to the <code>CreateExperience</code> API with the same client token creates only one Amazon Kendra experience.</p>', 'CreateFaqRequest$ClientToken' => '<p>A token that you provide to identify the request to create a FAQ. Multiple calls to the <code>CreateFaqRequest</code> API with the same client token will create only one FAQ. </p>', 'CreateFeaturedResultsSetRequest$ClientToken' => '<p>A token that you provide to identify the request to create a set of featured results. Multiple calls to the <code>CreateFeaturedResultsSet</code> API with the same client token will create only one featured results set.</p>', 'CreateIndexRequest$ClientToken' => '<p>A token that you provide to identify the request to create an index. Multiple calls to the <code>CreateIndex</code> API with the same client token will create only one index.</p>', 'CreateQuerySuggestionsBlockListRequest$ClientToken' => '<p>A token that you provide to identify the request to create a query suggestions block list.</p>', 'CreateThesaurusRequest$ClientToken' => '<p>A token that you provide to identify the request to create a thesaurus. Multiple calls to the <code>CreateThesaurus</code> API with the same client token will create only one thesaurus. </p>', ], ], 'CollapseConfiguration' => [ 'base' => '<p>Specifies how to group results by document attribute value, and how to display them collapsed/expanded under a designated primary document for each group.</p>', 'refs' => [ 'QueryRequest$CollapseConfiguration' => '<p>Provides configuration to determine how to group results by document attribute value, and how to display them (collapsed or expanded) under a designated primary document for each group.</p>', ], ], 'CollapsedResultDetail' => [ 'base' => '<p>Provides details about a collapsed group of search results.</p>', 'refs' => [ 'QueryResultItem$CollapsedResultDetail' => '<p>Provides details about a collapsed group of search results.</p>', ], ], 'ColumnConfiguration' => [ 'base' => '<p>Provides information about how Amazon Kendra should use the columns of a database in an index.</p>', 'refs' => [ 'DatabaseConfiguration$ColumnConfiguration' => '<p>Information about where the index should get the document information from the database.</p>', ], ], 'ColumnName' => [ 'base' => NULL, 'refs' => [ 'AclConfiguration$AllowedGroupsColumnName' => '<p>A list of groups, separated by semi-colons, that filters a query response based on user context. The document is only returned to users that are in one of the groups specified in the <code>UserContext</code> field of the <code>Query</code> API.</p>', 'ChangeDetectingColumns$member' => NULL, 'ColumnConfiguration$DocumentIdColumnName' => '<p>The column that provides the document\'s identifier.</p>', 'ColumnConfiguration$DocumentDataColumnName' => '<p>The column that contains the contents of the document.</p>', 'ColumnConfiguration$DocumentTitleColumnName' => '<p>The column that contains the title of the document.</p>', ], ], 'ConditionOperator' => [ 'base' => NULL, 'refs' => [ 'DocumentAttributeCondition$Operator' => '<p>The condition operator.</p> <p>For example, you can use \'Contains\' to partially match a string.</p>', ], ], 'ConflictException' => [ 'base' => '<p>A conflict occurred with the request. Please fix any inconsistences with your resources and try again.</p>', 'refs' => [], ], 'ConflictingItem' => [ 'base' => '<p>Information about a conflicting query used across different sets of featured results. When you create a featured results set, you must check that the queries are unique per featured results set for each index.</p>', 'refs' => [ 'ConflictingItems$member' => NULL, ], ], 'ConflictingItems' => [ 'base' => NULL, 'refs' => [ 'FeaturedResultsConflictException$ConflictingItems' => '<p>A list of the conflicting queries, including the query text, the name for the featured results set, and the identifier of the featured results set.</p>', ], ], 'ConfluenceAttachmentConfiguration' => [ 'base' => '<p>Configuration of attachment settings for the Confluence data source. Attachment settings are optional, if you don\'t specify settings attachments, Amazon Kendra won\'t index them.</p>', 'refs' => [ 'ConfluenceConfiguration$AttachmentConfiguration' => '<p>Configuration information for indexing attachments to Confluence blogs and pages.</p>', ], ], 'ConfluenceAttachmentFieldMappingsList' => [ 'base' => NULL, 'refs' => [ 'ConfluenceAttachmentConfiguration$AttachmentFieldMappings' => '<p>Maps attributes or field names of Confluence attachments to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API before you map to Confluence fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The Confluence data source field names must exist in your Confluence custom metadata.</p> <p>If you specify the <code>AttachentFieldMappings</code> parameter, you must specify at least one field mapping.</p>', ], ], 'ConfluenceAttachmentFieldName' => [ 'base' => NULL, 'refs' => [ 'ConfluenceAttachmentToIndexFieldMapping$DataSourceFieldName' => '<p>The name of the field in the data source. </p> <p>You must first create the index field using the <code>UpdateIndex</code> API. </p>', ], ], 'ConfluenceAttachmentToIndexFieldMapping' => [ 'base' => '<p>Maps attributes or field names of Confluence attachments to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API before you map to Confluence fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The Confuence data source field names must exist in your Confluence custom metadata.</p>', 'refs' => [ 'ConfluenceAttachmentFieldMappingsList$member' => NULL, ], ], 'ConfluenceAuthenticationType' => [ 'base' => NULL, 'refs' => [ 'ConfluenceConfiguration$AuthenticationType' => '<p>Whether you want to connect to Confluence using basic authentication of user name and password, or a personal access token. You can use a personal access token for Confluence Server.</p>', ], ], 'ConfluenceBlogConfiguration' => [ 'base' => '<p>Configuration of blog settings for the Confluence data source. Blogs are always indexed unless filtered from the index by the <code>ExclusionPatterns</code> or <code>InclusionPatterns</code> fields in the <code>ConfluenceConfiguration</code> object.</p>', 'refs' => [ 'ConfluenceConfiguration$BlogConfiguration' => '<p>Configuration information for indexing Confluence blogs.</p>', ], ], 'ConfluenceBlogFieldMappingsList' => [ 'base' => NULL, 'refs' => [ 'ConfluenceBlogConfiguration$BlogFieldMappings' => '<p>Maps attributes or field names of Confluence blogs to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API before you map to Confluence fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The Confluence data source field names must exist in your Confluence custom metadata.</p> <p>If you specify the <code>BlogFieldMappings</code> parameter, you must specify at least one field mapping.</p>', ], ], 'ConfluenceBlogFieldName' => [ 'base' => NULL, 'refs' => [ 'ConfluenceBlogToIndexFieldMapping$DataSourceFieldName' => '<p>The name of the field in the data source. </p>', ], ], 'ConfluenceBlogToIndexFieldMapping' => [ 'base' => '<p>Maps attributes or field names of Confluence blog to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API before you map to Confluence fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The Confluence data source field names must exist in your Confluence custom metadata.</p>', 'refs' => [ 'ConfluenceBlogFieldMappingsList$member' => NULL, ], ], 'ConfluenceConfiguration' => [ 'base' => '<p>Provides the configuration information to connect to Confluence as your data source.</p>', 'refs' => [ 'DataSourceConfiguration$ConfluenceConfiguration' => '<p>Provides the configuration information to connect to Confluence as your data source.</p>', ], ], 'ConfluencePageConfiguration' => [ 'base' => '<p>Configuration of the page settings for the Confluence data source.</p>', 'refs' => [ 'ConfluenceConfiguration$PageConfiguration' => '<p>Configuration information for indexing Confluence pages.</p>', ], ], 'ConfluencePageFieldMappingsList' => [ 'base' => NULL, 'refs' => [ 'ConfluencePageConfiguration$PageFieldMappings' => '<p>Maps attributes or field names of Confluence pages to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API before you map to Confluence fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The Confluence data source field names must exist in your Confluence custom metadata.</p> <p>If you specify the <code>PageFieldMappings</code> parameter, you must specify at least one field mapping.</p>', ], ], 'ConfluencePageFieldName' => [ 'base' => NULL, 'refs' => [ 'ConfluencePageToIndexFieldMapping$DataSourceFieldName' => '<p>The name of the field in the data source.</p>', ], ], 'ConfluencePageToIndexFieldMapping' => [ 'base' => '<p>Maps attributes or field names of Confluence pages to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API before you map to Confluence fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The Confluence data source field names must exist in your Confluence custom metadata.</p>', 'refs' => [ 'ConfluencePageFieldMappingsList$member' => NULL, ], ], 'ConfluenceSpaceConfiguration' => [ 'base' => '<p>Configuration information for indexing Confluence spaces.</p>', 'refs' => [ 'ConfluenceConfiguration$SpaceConfiguration' => '<p>Configuration information for indexing Confluence spaces.</p>', ], ], 'ConfluenceSpaceFieldMappingsList' => [ 'base' => NULL, 'refs' => [ 'ConfluenceSpaceConfiguration$SpaceFieldMappings' => '<p>Maps attributes or field names of Confluence spaces to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API before you map to Confluence fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The Confluence data source field names must exist in your Confluence custom metadata.</p> <p>If you specify the <code>SpaceFieldMappings</code> parameter, you must specify at least one field mapping.</p>', ], ], 'ConfluenceSpaceFieldName' => [ 'base' => NULL, 'refs' => [ 'ConfluenceSpaceToIndexFieldMapping$DataSourceFieldName' => '<p>The name of the field in the data source. </p>', ], ], 'ConfluenceSpaceIdentifier' => [ 'base' => NULL, 'refs' => [ 'ConfluenceSpaceList$member' => NULL, ], ], 'ConfluenceSpaceList' => [ 'base' => NULL, 'refs' => [ 'ConfluenceSpaceConfiguration$IncludeSpaces' => '<p>A list of space keys for Confluence spaces. If you include a key, the blogs, documents, and attachments in the space are indexed. Spaces that aren\'t in the list aren\'t indexed. A space in the list must exist. Otherwise, Amazon Kendra logs an error when the data source is synchronized. If a space is in both the <code>IncludeSpaces</code> and the <code>ExcludeSpaces</code> list, the space is excluded.</p>', 'ConfluenceSpaceConfiguration$ExcludeSpaces' => '<p>A list of space keys of Confluence spaces. If you include a key, the blogs, documents, and attachments in the space are not indexed. If a space is in both the <code>ExcludeSpaces</code> and the <code>IncludeSpaces</code> list, the space is excluded.</p>', ], ], 'ConfluenceSpaceToIndexFieldMapping' => [ 'base' => '<p>Maps attributes or field names of Confluence spaces to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API before you map to Confluence fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The Confluence data source field names must exist in your Confluence custom metadata.</p>', 'refs' => [ 'ConfluenceSpaceFieldMappingsList$member' => NULL, ], ], 'ConfluenceVersion' => [ 'base' => NULL, 'refs' => [ 'ConfluenceConfiguration$Version' => '<p>The version or the type of Confluence installation to connect to.</p>', ], ], 'ConnectionConfiguration' => [ 'base' => '<p>Provides the configuration information that\'s required to connect to a database.</p>', 'refs' => [ 'DatabaseConfiguration$ConnectionConfiguration' => '<p>Configuration information that\'s required to connect to a database.</p>', ], ], 'Content' => [ 'base' => NULL, 'refs' => [ 'RetrieveResultItem$Content' => '<p>The contents of the relevant passage.</p>', ], ], 'ContentSourceConfiguration' => [ 'base' => '<p>Provides the configuration information for your content sources, such as data sources, FAQs, and content indexed directly via <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_BatchPutDocument.html">BatchPutDocument</a>.</p>', 'refs' => [ 'ExperienceConfiguration$ContentSourceConfiguration' => '<p>The identifiers of your data sources and FAQs. Or, you can specify that you want to use documents indexed via the <code>BatchPutDocument</code> API. This is the content you want to use for your Amazon Kendra experience.</p>', ], ], 'ContentType' => [ 'base' => NULL, 'refs' => [ 'Document$ContentType' => '<p>The file type of the document in the <code>Blob</code> field.</p> <p>If you want to index snippets or subsets of HTML documents instead of the entirety of the HTML documents, you must add the <code>HTML</code> start and closing tags (<code>&lt;HTML&gt;content&lt;/HTML&gt;</code>) around the content.</p>', ], ], 'Correction' => [ 'base' => '<p>A corrected misspelled word in a query.</p>', 'refs' => [ 'CorrectionList$member' => NULL, ], ], 'CorrectionList' => [ 'base' => NULL, 'refs' => [ 'SpellCorrectedQuery$Corrections' => '<p>The corrected misspelled word or words in a query.</p>', ], ], 'CrawlDepth' => [ 'base' => NULL, 'refs' => [ 'WebCrawlerConfiguration$CrawlDepth' => '<p>The \'depth\' or number of levels from the seed level to crawl. For example, the seed URL page is depth 1 and any hyperlinks on this page that are also crawled are depth 2.</p>', ], ], 'CreateAccessControlConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAccessControlConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateDataSourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDataSourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateExperienceRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateExperienceResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateFaqRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateFaqResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateFeaturedResultsSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateFeaturedResultsSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateIndexRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateIndexResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateQuerySuggestionsBlockListRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateQuerySuggestionsBlockListResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateThesaurusRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateThesaurusResponse' => [ 'base' => NULL, 'refs' => [], ], 'CustomDocumentEnrichmentConfiguration' => [ 'base' => '<p>Provides the configuration information for altering document metadata and content during the document ingestion process.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html">Customizing document metadata during the ingestion process</a>.</p>', 'refs' => [ 'BatchPutDocumentRequest$CustomDocumentEnrichmentConfiguration' => '<p>Configuration information for altering your document metadata and content during the document ingestion process when you use the <code>BatchPutDocument</code> API.</p> <p>For more information on how to create, modify and delete document metadata, or make other content alterations when you ingest documents into Amazon Kendra, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html">Customizing document metadata during the ingestion process</a>.</p>', 'CreateDataSourceRequest$CustomDocumentEnrichmentConfiguration' => '<p>Configuration information for altering document metadata and content during the document ingestion process.</p> <p>For more information on how to create, modify and delete document metadata, or make other content alterations when you ingest documents into Amazon Kendra, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html">Customizing document metadata during the ingestion process</a>.</p>', 'DescribeDataSourceResponse$CustomDocumentEnrichmentConfiguration' => '<p>Configuration information for altering document metadata and content during the document ingestion process when you describe a data source.</p> <p>For more information on how to create, modify and delete document metadata, or make other content alterations when you ingest documents into Amazon Kendra, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html">Customizing document metadata during the ingestion process</a>.</p>', 'UpdateDataSourceRequest$CustomDocumentEnrichmentConfiguration' => '<p>Configuration information you want to update for altering document metadata and content during the document ingestion process.</p> <p>For more information on how to create, modify and delete document metadata, or make other content alterations when you ingest documents into Amazon Kendra, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html">Customizing document metadata during the ingestion process</a>.</p>', ], ], 'DataSourceConfiguration' => [ 'base' => '<p>Provides the configuration information for an Amazon Kendra data source.</p>', 'refs' => [ 'CreateDataSourceRequest$Configuration' => '<p>Configuration information to connect to your data source repository.</p> <p>You can\'t specify the <code>Configuration</code> parameter when the <code>Type</code> parameter is set to <code>CUSTOM</code>. If you do, you receive a <code>ValidationException</code> exception.</p> <p>The <code>Configuration</code> parameter is required for all other data sources.</p>', 'DescribeDataSourceResponse$Configuration' => '<p>Configuration details for the data source connector. This shows how the data source is configured. The configuration options for a data source depend on the data source provider.</p>', 'UpdateDataSourceRequest$Configuration' => '<p>Configuration information you want to update for the data source connector.</p>', ], ], 'DataSourceDateFieldFormat' => [ 'base' => NULL, 'refs' => [ 'ConfluenceAttachmentToIndexFieldMapping$DateFieldFormat' => '<p>The format for date fields in the data source. If the field specified in <code>DataSourceFieldName</code> is a date field you must specify the date format. If the field is not a date field, an exception is thrown.</p>', 'ConfluenceBlogToIndexFieldMapping$DateFieldFormat' => '<p>The format for date fields in the data source. If the field specified in <code>DataSourceFieldName</code> is a date field you must specify the date format. If the field is not a date field, an exception is thrown.</p>', 'ConfluencePageToIndexFieldMapping$DateFieldFormat' => '<p>The format for date fields in the data source. If the field specified in <code>DataSourceFieldName</code> is a date field you must specify the date format. If the field is not a date field, an exception is thrown.</p>', 'ConfluenceSpaceToIndexFieldMapping$DateFieldFormat' => '<p>The format for date fields in the data source. If the field specified in <code>DataSourceFieldName</code> is a date field you must specify the date format. If the field is not a date field, an exception is thrown.</p>', 'DataSourceToIndexFieldMapping$DateFieldFormat' => '<p>The format for date fields in the data source. If the field specified in <code>DataSourceFieldName</code> is a date field, you must specify the date format. If the field is not a date field, an exception is thrown.</p>', ], ], 'DataSourceFieldName' => [ 'base' => NULL, 'refs' => [ 'DataSourceToIndexFieldMapping$DataSourceFieldName' => '<p>The name of the field in the data source. You must first create the index field using the <code>UpdateIndex</code> API.</p>', 'SalesforceChatterFeedConfiguration$DocumentDataFieldName' => '<p>The name of the column in the Salesforce FeedItem table that contains the content to index. Typically this is the <code>Body</code> column.</p>', 'SalesforceChatterFeedConfiguration$DocumentTitleFieldName' => '<p>The name of the column in the Salesforce FeedItem table that contains the title of the document. This is typically the <code>Title</code> column.</p>', 'SalesforceCustomKnowledgeArticleTypeConfiguration$DocumentDataFieldName' => '<p>The name of the field in the custom knowledge article that contains the document data to index.</p>', 'SalesforceCustomKnowledgeArticleTypeConfiguration$DocumentTitleFieldName' => '<p>The name of the field in the custom knowledge article that contains the document title.</p>', 'SalesforceStandardKnowledgeArticleTypeConfiguration$DocumentDataFieldName' => '<p>The name of the field that contains the document data to index.</p>', 'SalesforceStandardKnowledgeArticleTypeConfiguration$DocumentTitleFieldName' => '<p>The name of the field that contains the document title.</p>', 'SalesforceStandardObjectAttachmentConfiguration$DocumentTitleFieldName' => '<p>The name of the field used for the document title.</p>', 'SalesforceStandardObjectConfiguration$DocumentDataFieldName' => '<p>The name of the field in the standard object table that contains the document contents.</p>', 'SalesforceStandardObjectConfiguration$DocumentTitleFieldName' => '<p>The name of the field in the standard object table that contains the document title.</p>', 'ServiceNowKnowledgeArticleConfiguration$DocumentDataFieldName' => '<p>The name of the ServiceNow field that is mapped to the index document contents field in the Amazon Kendra index.</p>', 'ServiceNowKnowledgeArticleConfiguration$DocumentTitleFieldName' => '<p>The name of the ServiceNow field that is mapped to the index document title field.</p>', 'ServiceNowServiceCatalogConfiguration$DocumentDataFieldName' => '<p>The name of the ServiceNow field that is mapped to the index document contents field in the Amazon Kendra index.</p>', 'ServiceNowServiceCatalogConfiguration$DocumentTitleFieldName' => '<p>The name of the ServiceNow field that is mapped to the index document title field.</p>', 'SharePointConfiguration$DocumentTitleFieldName' => '<p>The Microsoft SharePoint attribute field that contains the title of the document.</p>', ], ], 'DataSourceGroup' => [ 'base' => '<p>Data source information for user context filtering.</p>', 'refs' => [ 'DataSourceGroups$member' => NULL, ], ], 'DataSourceGroups' => [ 'base' => NULL, 'refs' => [ 'UserContext$DataSourceGroups' => '<p>The list of data source groups you want to filter search results based on groups\' access to documents in that data source.</p>', ], ], 'DataSourceId' => [ 'base' => NULL, 'refs' => [ 'CreateDataSourceResponse$Id' => '<p>The identifier of the data source connector.</p>', 'DataSourceGroup$DataSourceId' => '<p>The identifier of the data source group you want to add to your list of data source groups. This is for filtering search results based on the groups\' access to documents in that data source.</p>', 'DataSourceIdList$member' => NULL, 'DataSourceSummary$Id' => '<p>The identifier for the data source.</p>', 'DataSourceSyncJobMetricTarget$DataSourceId' => '<p>The ID of the data source that is running the sync job.</p>', 'DeleteDataSourceRequest$Id' => '<p>The identifier of the data source connector you want to delete.</p>', 'DeletePrincipalMappingRequest$DataSourceId' => '<p>The identifier of the data source you want to delete a group from.</p> <p>A group can be tied to multiple data sources. You can delete a group from accessing documents in a certain data source. For example, the groups "Research", "Engineering", and "Sales and Marketing" are all tied to the company\'s documents stored in the data sources Confluence and Salesforce. You want to delete "Research" and "Engineering" groups from Salesforce, so that these groups cannot access customer-related documents stored in Salesforce. Only "Sales and Marketing" should access documents in the Salesforce data source.</p>', 'DescribeDataSourceRequest$Id' => '<p>The identifier of the data source connector.</p>', 'DescribeDataSourceResponse$Id' => '<p>The identifier of the data source connector.</p>', 'DescribePrincipalMappingRequest$DataSourceId' => '<p>The identifier of the data source to check the processing of <code>PUT</code> and <code>DELETE</code> actions for mapping users to their groups.</p>', 'DescribePrincipalMappingResponse$DataSourceId' => '<p>Shows the identifier of the data source to see information on the processing of <code>PUT</code> and <code>DELETE</code> actions for mapping users to their groups.</p>', 'ListDataSourceSyncJobsRequest$Id' => '<p>The identifier of the data source connector.</p>', 'ListGroupsOlderThanOrderingIdRequest$DataSourceId' => '<p>The identifier of the data source for getting a list of groups mapped to users before a given ordering timestamp identifier.</p>', 'MemberGroup$DataSourceId' => '<p>The identifier of the data source for the sub group you want to map to a group.</p>', 'Principal$DataSourceId' => '<p>The identifier of the data source the principal should access documents from.</p>', 'PutPrincipalMappingRequest$DataSourceId' => '<p>The identifier of the data source you want to map users to their groups.</p> <p>This is useful if a group is tied to multiple data sources, but you only want the group to access documents of a certain data source. For example, the groups "Research", "Engineering", and "Sales and Marketing" are all tied to the company\'s documents stored in the data sources Confluence and Salesforce. However, "Sales and Marketing" team only needs access to customer-related documents stored in Salesforce.</p>', 'StartDataSourceSyncJobRequest$Id' => '<p>The identifier of the data source connector to synchronize.</p>', 'StopDataSourceSyncJobRequest$Id' => '<p>The identifier of the data source connector for which to stop the synchronization jobs.</p>', 'UpdateDataSourceRequest$Id' => '<p>The identifier of the data source connector you want to update.</p>', ], ], 'DataSourceIdList' => [ 'base' => NULL, 'refs' => [ 'ContentSourceConfiguration$DataSourceIds' => '<p>The identifier of the data sources you want to use for your Amazon Kendra experience.</p>', ], ], 'DataSourceInclusionsExclusionsStrings' => [ 'base' => NULL, 'refs' => [ 'AlfrescoConfiguration$InclusionPatterns' => '<p>A list of regular expression patterns to include certain files in your Alfresco data source. Files that match the patterns are included in the index. Files that don\'t match the patterns are excluded from the index. If a file matches both an inclusion pattern and an exclusion pattern, the exclusion pattern takes precedence and the file isn\'t included in the index.</p>', 'AlfrescoConfiguration$ExclusionPatterns' => '<p>A list of regular expression patterns to exclude certain files in your Alfresco data source. Files that match the patterns are excluded from the index. Files that don\'t match the patterns are included in the index. If a file matches both an inclusion pattern and an exclusion pattern, the exclusion pattern takes precedence and the file isn\'t included in the index.</p>', 'BoxConfiguration$InclusionPatterns' => '<p>A list of regular expression patterns to include certain files and folders in your Box platform. Files and folders that match the patterns are included in the index. Files and folders that don\'t match the patterns are excluded from the index. If a file or folder matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the file or folder isn\'t included in the index.</p>', 'BoxConfiguration$ExclusionPatterns' => '<p>A list of regular expression patterns to exclude certain files and folders from your Box platform. Files and folders that match the patterns are excluded from the index.Files and folders that don\'t match the patterns are included in the index. If a file or folder matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the file or folder isn\'t included in the index.</p>', 'ConfluenceConfiguration$InclusionPatterns' => '<p>A list of regular expression patterns to include certain blog posts, pages, spaces, or attachments in your Confluence. Content that matches the patterns are included in the index. Content that doesn\'t match the patterns is excluded from the index. If content matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the content isn\'t included in the index.</p>', 'ConfluenceConfiguration$ExclusionPatterns' => '<p>A list of regular expression patterns to exclude certain blog posts, pages, spaces, or attachments in your Confluence. Content that matches the patterns are excluded from the index. Content that doesn\'t match the patterns is included in the index. If content matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the content isn\'t included in the index.</p>', 'FsxConfiguration$InclusionPatterns' => '<p>A list of regular expression patterns to include certain files in your Amazon FSx file system. Files that match the patterns are included in the index. Files that don\'t match the patterns are excluded from the index. If a file matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the file isn\'t included in the index.</p>', 'FsxConfiguration$ExclusionPatterns' => '<p>A list of regular expression patterns to exclude certain files in your Amazon FSx file system. Files that match the patterns are excluded from the index. Files that don\'t match the patterns are included in the index. If a file matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the file isn\'t included in the index.</p>', 'GoogleDriveConfiguration$InclusionPatterns' => '<p>A list of regular expression patterns to include certain items in your Google Drive, including shared drives and users\' My Drives. Items that match the patterns are included in the index. Items that don\'t match the patterns are excluded from the index. If an item matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the item isn\'t included in the index.</p>', 'GoogleDriveConfiguration$ExclusionPatterns' => '<p>A list of regular expression patterns to exclude certain items in your Google Drive, including shared drives and users\' My Drives. Items that match the patterns are excluded from the index. Items that don\'t match the patterns are included in the index. If an item matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the item isn\'t included in the index.</p>', 'JiraConfiguration$InclusionPatterns' => '<p>A list of regular expression patterns to include certain file paths, file names, and file types in your Jira data source. Files that match the patterns are included in the index. Files that don\'t match the patterns are excluded from the index. If a file matches both an inclusion pattern and an exclusion pattern, the exclusion pattern takes precedence and the file isn\'t included in the index.</p>', 'JiraConfiguration$ExclusionPatterns' => '<p>A list of regular expression patterns to exclude certain file paths, file names, and file types in your Jira data source. Files that match the patterns are excluded from the index. Files that don’t match the patterns are included in the index. If a file matches both an inclusion pattern and an exclusion pattern, the exclusion pattern takes precedence and the file isn\'t included in the index.</p>', 'OneDriveConfiguration$InclusionPatterns' => '<p>A list of regular expression patterns to include certain documents in your OneDrive. Documents that match the patterns are included in the index. Documents that don\'t match the patterns are excluded from the index. If a document matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the document isn\'t included in the index.</p> <p>The pattern is applied to the file name.</p>', 'OneDriveConfiguration$ExclusionPatterns' => '<p>A list of regular expression patterns to exclude certain documents in your OneDrive. Documents that match the patterns are excluded from the index. Documents that don\'t match the patterns are included in the index. If a document matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the document isn\'t included in the index.</p> <p>The pattern is applied to the file name.</p>', 'QuipConfiguration$InclusionPatterns' => '<p>A list of regular expression patterns to include certain files in your Quip file system. Files that match the patterns are included in the index. Files that don\'t match the patterns are excluded from the index. If a file matches both an inclusion pattern and an exclusion pattern, the exclusion pattern takes precedence, and the file isn\'t included in the index.</p>', 'QuipConfiguration$ExclusionPatterns' => '<p>A list of regular expression patterns to exclude certain files in your Quip file system. Files that match the patterns are excluded from the index. Files that don’t match the patterns are included in the index. If a file matches both an inclusion pattern and an exclusion pattern, the exclusion pattern takes precedence, and the file isn\'t included in the index.</p>', 'S3DataSourceConfiguration$InclusionPrefixes' => '<p>A list of S3 prefixes for the documents that should be included in the index.</p>', 'S3DataSourceConfiguration$InclusionPatterns' => '<p>A list of glob patterns (patterns that can expand a wildcard pattern into a list of path names that match the given pattern) for certain file names and file types to include in your index. If a document matches both an inclusion and exclusion prefix or pattern, the exclusion prefix takes precendence and the document is not indexed. Examples of glob patterns include:</p> <ul> <li> <p> <i>/myapp/config/*</i>—All files inside config directory.</p> </li> <li> <p> <i>**/*.png</i>—All .png files in all directories.</p> </li> <li> <p> <i>**/*.{png, ico, md}</i>—All .png, .ico or .md files in all directories.</p> </li> <li> <p> <i>/myapp/src/**/*.ts</i>—All .ts files inside src directory (and all its subdirectories).</p> </li> <li> <p> <i>**/!(*.module).ts</i>—All .ts files but not .module.ts</p> </li> <li> <p> <i>*.png , *.jpg</i>—All PNG and JPEG image files in a directory (files with the extensions .png and .jpg).</p> </li> <li> <p> <i>*internal*</i>—All files in a directory that contain \'internal\' in the file name, such as \'internal\', \'internal_only\', \'company_internal\'.</p> </li> <li> <p> <i>**/*internal*</i>—All internal-related files in a directory and its subdirectories.</p> </li> </ul> <p>For more examples, see <a href="https://docs.aws.amazon.com/cli/latest/reference/s3/#use-of-exclude-and-include-filters">Use of Exclude and Include Filters</a> in the Amazon Web Services CLI Command Reference.</p>', 'S3DataSourceConfiguration$ExclusionPatterns' => '<p>A list of glob patterns (patterns that can expand a wildcard pattern into a list of path names that match the given pattern) for certain file names and file types to exclude from your index. If a document matches both an inclusion and exclusion prefix or pattern, the exclusion prefix takes precendence and the document is not indexed. Examples of glob patterns include:</p> <ul> <li> <p> <i>/myapp/config/*</i>—All files inside config directory.</p> </li> <li> <p> <i>**/*.png</i>—All .png files in all directories.</p> </li> <li> <p> <i>**/*.{png, ico, md}</i>—All .png, .ico or .md files in all directories.</p> </li> <li> <p> <i>/myapp/src/**/*.ts</i>—All .ts files inside src directory (and all its subdirectories).</p> </li> <li> <p> <i>**/!(*.module).ts</i>—All .ts files but not .module.ts</p> </li> <li> <p> <i>*.png , *.jpg</i>—All PNG and JPEG image files in a directory (files with the extensions .png and .jpg).</p> </li> <li> <p> <i>*internal*</i>—All files in a directory that contain \'internal\' in the file name, such as \'internal\', \'internal_only\', \'company_internal\'.</p> </li> <li> <p> <i>**/*internal*</i>—All internal-related files in a directory and its subdirectories.</p> </li> </ul> <p>For more examples, see <a href="https://docs.aws.amazon.com/cli/latest/reference/s3/#use-of-exclude-and-include-filters">Use of Exclude and Include Filters</a> in the Amazon Web Services CLI Command Reference.</p>', 'SalesforceConfiguration$IncludeAttachmentFilePatterns' => '<p>A list of regular expression patterns to include certain documents in your Salesforce. Documents that match the patterns are included in the index. Documents that don\'t match the patterns are excluded from the index. If a document matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the document isn\'t included in the index.</p> <p>The pattern is applied to the name of the attached file.</p>', 'SalesforceConfiguration$ExcludeAttachmentFilePatterns' => '<p>A list of regular expression patterns to exclude certain documents in your Salesforce. Documents that match the patterns are excluded from the index. Documents that don\'t match the patterns are included in the index. If a document matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the document isn\'t included in the index.</p> <p>The pattern is applied to the name of the attached file.</p>', 'ServiceNowKnowledgeArticleConfiguration$IncludeAttachmentFilePatterns' => '<p>A list of regular expression patterns applied to include knowledge article attachments. Attachments that match the patterns are included in the index. Items that don\'t match the patterns are excluded from the index. If an item matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the item isn\'t included in the index.</p>', 'ServiceNowKnowledgeArticleConfiguration$ExcludeAttachmentFilePatterns' => '<p>A list of regular expression patterns applied to exclude certain knowledge article attachments. Attachments that match the patterns are excluded from the index. Items that don\'t match the patterns are included in the index. If an item matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the item isn\'t included in the index.</p>', 'ServiceNowServiceCatalogConfiguration$IncludeAttachmentFilePatterns' => '<p>A list of regular expression patterns to include certain attachments of catalogs in your ServiceNow. Item that match the patterns are included in the index. Items that don\'t match the patterns are excluded from the index. If an item matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the item isn\'t included in the index.</p> <p>The regex is applied to the file name of the attachment.</p>', 'ServiceNowServiceCatalogConfiguration$ExcludeAttachmentFilePatterns' => '<p>A list of regular expression patterns to exclude certain attachments of catalogs in your ServiceNow. Item that match the patterns are excluded from the index. Items that don\'t match the patterns are included in the index. If an item matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the item isn\'t included in the index.</p> <p>The regex is applied to the file name of the attachment.</p>', 'SharePointConfiguration$InclusionPatterns' => '<p>A list of regular expression patterns to include certain documents in your SharePoint. Documents that match the patterns are included in the index. Documents that don\'t match the patterns are excluded from the index. If a document matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the document isn\'t included in the index.</p> <p>The regex applies to the display URL of the SharePoint document.</p>', 'SharePointConfiguration$ExclusionPatterns' => '<p>A list of regular expression patterns to exclude certain documents in your SharePoint. Documents that match the patterns are excluded from the index. Documents that don\'t match the patterns are included in the index. If a document matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the document isn\'t included in the index.</p> <p>The regex applies to the display URL of the SharePoint document.</p>', 'SlackConfiguration$InclusionPatterns' => '<p>A list of regular expression patterns to include certain attached files in your Slack workspace team. Files that match the patterns are included in the index. Files that don\'t match the patterns are excluded from the index. If a file matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the file isn\'t included in the index.</p>', 'SlackConfiguration$ExclusionPatterns' => '<p>A list of regular expression patterns to exclude certain attached files in your Slack workspace team. Files that match the patterns are excluded from the index. Files that don’t match the patterns are included in the index. If a file matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the file isn\'t included in the index.</p>', 'WebCrawlerConfiguration$UrlInclusionPatterns' => '<p>A list of regular expression patterns to include certain URLs to crawl. URLs that match the patterns are included in the index. URLs that don\'t match the patterns are excluded from the index. If a URL matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the URL file isn\'t included in the index.</p>', 'WebCrawlerConfiguration$UrlExclusionPatterns' => '<p>A list of regular expression patterns to exclude certain URLs to crawl. URLs that match the patterns are excluded from the index. URLs that don\'t match the patterns are included in the index. If a URL matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the URL file isn\'t included in the index.</p>', 'WorkDocsConfiguration$InclusionPatterns' => '<p>A list of regular expression patterns to include certain files in your Amazon WorkDocs site repository. Files that match the patterns are included in the index. Files that don\'t match the patterns are excluded from the index. If a file matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the file isn\'t included in the index.</p>', 'WorkDocsConfiguration$ExclusionPatterns' => '<p>A list of regular expression patterns to exclude certain files in your Amazon WorkDocs site repository. Files that match the patterns are excluded from the index. Files that don’t match the patterns are included in the index. If a file matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the file isn\'t included in the index.</p>', ], ], 'DataSourceInclusionsExclusionsStringsMember' => [ 'base' => NULL, 'refs' => [ 'DataSourceInclusionsExclusionsStrings$member' => NULL, ], ], 'DataSourceName' => [ 'base' => NULL, 'refs' => [ 'CreateDataSourceRequest$Name' => '<p>A name for the data source connector.</p>', 'DataSourceSummary$Name' => '<p>The name of the data source.</p>', 'DescribeDataSourceResponse$Name' => '<p>The name for the data source connector.</p>', 'UpdateDataSourceRequest$Name' => '<p>A new name for the data source connector.</p>', ], ], 'DataSourceStatus' => [ 'base' => NULL, 'refs' => [ 'DataSourceSummary$Status' => '<p>The status of the data source. When the status is <code>ACTIVE</code> the data source is ready to use.</p>', 'DescribeDataSourceResponse$Status' => '<p>The current status of the data source connector. When the status is <code>ACTIVE</code> the data source is ready to use. When the status is <code>FAILED</code>, the <code>ErrorMessage</code> field contains the reason that the data source failed.</p>', ], ], 'DataSourceSummary' => [ 'base' => '<p>Summary information for a Amazon Kendra data source.</p>', 'refs' => [ 'DataSourceSummaryList$member' => NULL, ], ], 'DataSourceSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListDataSourcesResponse$SummaryItems' => '<p>An array of summary information for one or more data source connector.</p>', ], ], 'DataSourceSyncJob' => [ 'base' => '<p>Provides information about a data source synchronization job.</p>', 'refs' => [ 'DataSourceSyncJobHistoryList$member' => NULL, ], ], 'DataSourceSyncJobHistoryList' => [ 'base' => NULL, 'refs' => [ 'ListDataSourceSyncJobsResponse$History' => '<p>A history of synchronization jobs for the data source connector.</p>', ], ], 'DataSourceSyncJobId' => [ 'base' => NULL, 'refs' => [ 'DataSourceSyncJobMetricTarget$DataSourceSyncJobId' => '<p>The ID of the sync job that is running on the data source.</p> <p>If the ID of a sync job is not provided and there is a sync job running, then the ID of this sync job is used and metrics are generated for this sync job.</p> <p>If the ID of a sync job is not provided and there is no sync job running, then no metrics are generated and documents are indexed/deleted at the index level without sync job metrics included.</p>', ], ], 'DataSourceSyncJobMetricTarget' => [ 'base' => '<p>Maps a particular data source sync job to a particular data source.</p>', 'refs' => [ 'BatchDeleteDocumentRequest$DataSourceSyncJobMetricTarget' => NULL, ], ], 'DataSourceSyncJobMetrics' => [ 'base' => '<p>Maps a batch delete document request to a specific data source sync job. This is optional and should only be supplied when documents are deleted by a data source connector.</p>', 'refs' => [ 'DataSourceSyncJob$Metrics' => '<p>Maps a batch delete document request to a specific data source sync job. This is optional and should only be supplied when documents are deleted by a data source connector.</p>', ], ], 'DataSourceSyncJobStatus' => [ 'base' => NULL, 'refs' => [ 'DataSourceSyncJob$Status' => '<p>The execution status of the synchronization job. When the <code>Status</code> field is set to <code>SUCCEEDED</code>, the synchronization job is done. If the status code is set to <code>FAILED</code>, the <code>ErrorCode</code> and <code>ErrorMessage</code> fields give you the reason for the failure.</p>', 'ListDataSourceSyncJobsRequest$StatusFilter' => '<p>Only returns synchronization jobs with the <code>Status</code> field equal to the specified status.</p>', ], ], 'DataSourceToIndexFieldMapping' => [ 'base' => '<p>Maps attributes or field names of the documents synced from the data source to Amazon Kendra index field names. You can set up field mappings for each data source when calling <a href="https://docs.aws.amazon.com/kendra/latest/APIReference/API_CreateDataSource.html">CreateDataSource</a> or <a href="https://docs.aws.amazon.com/kendra/latest/APIReference/API_UpdateDataSource.html">UpdateDataSource</a> API. To create custom fields, use the <code>UpdateIndex</code> API to first create an index field and then map to the data source field. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>.</p>', 'refs' => [ 'DataSourceToIndexFieldMappingList$member' => NULL, ], ], 'DataSourceToIndexFieldMappingList' => [ 'base' => NULL, 'refs' => [ 'AlfrescoConfiguration$DocumentLibraryFieldMappings' => '<p>A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of Alfresco document libraries to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API before you map to Alfresco fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html"> Mapping data source fields</a>. The Alfresco data source field names must exist in your Alfresco custom metadata.</p>', 'AlfrescoConfiguration$BlogFieldMappings' => '<p>A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of Alfresco blogs to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API before you map to Alfresco fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html"> Mapping data source fields</a>. The Alfresco data source field names must exist in your Alfresco custom metadata.</p>', 'AlfrescoConfiguration$WikiFieldMappings' => '<p>A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of Alfresco wikis to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API before you map to Alfresco fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html"> Mapping data source fields</a>. The Alfresco data source field names must exist in your Alfresco custom metadata.</p>', 'BoxConfiguration$FileFieldMappings' => '<p>A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of Box files to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API before you map to Box fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The Box field names must exist in your Box custom metadata.</p>', 'BoxConfiguration$TaskFieldMappings' => '<p>A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of Box tasks to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API before you map to Box fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The Box field names must exist in your Box custom metadata.</p>', 'BoxConfiguration$CommentFieldMappings' => '<p>A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of Box comments to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API before you map to Box fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The Box field names must exist in your Box custom metadata.</p>', 'BoxConfiguration$WebLinkFieldMappings' => '<p>A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of Box web links to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API before you map to Box fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The Box field names must exist in your Box custom metadata.</p>', 'ColumnConfiguration$FieldMappings' => '<p>An array of objects that map database column names to the corresponding fields in an index. You must first create the fields in the index using the <code>UpdateIndex</code> API.</p>', 'FsxConfiguration$FieldMappings' => '<p>A list of <code>DataSourceToIndexFieldMapping</code> objects that map Amazon FSx data source attributes or field names to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API before you map to Amazon FSx fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The Amazon FSx data source field names must exist in your Amazon FSx custom metadata.</p>', 'GitHubConfiguration$GitHubRepositoryConfigurationFieldMappings' => '<p>A list of <code>DataSourceToIndexFieldMapping</code> objects that map GitHub repository attributes or field names to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API before you map to GitHub fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The GitHub data source field names must exist in your GitHub custom metadata.</p>', 'GitHubConfiguration$GitHubCommitConfigurationFieldMappings' => '<p>A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of GitHub commits to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API before you map to GitHub fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The GitHub data source field names must exist in your GitHub custom metadata.</p>', 'GitHubConfiguration$GitHubIssueDocumentConfigurationFieldMappings' => '<p>A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of GitHub issues to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API before you map to GitHub fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The GitHub data source field names must exist in your GitHub custom metadata.</p>', 'GitHubConfiguration$GitHubIssueCommentConfigurationFieldMappings' => '<p>A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of GitHub issue comments to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API before you map to GitHub fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The GitHub data source field names must exist in your GitHub custom metadata.</p>', 'GitHubConfiguration$GitHubIssueAttachmentConfigurationFieldMappings' => '<p>A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of GitHub issue attachments to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API before you map to GitHub fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The GitHub data source field names must exist in your GitHub custom metadata.</p>', 'GitHubConfiguration$GitHubPullRequestCommentConfigurationFieldMappings' => '<p>A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of GitHub pull request comments to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API before you map to GitHub fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The GitHub data source field names must exist in your GitHub custom metadata.</p>', 'GitHubConfiguration$GitHubPullRequestDocumentConfigurationFieldMappings' => '<p>A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of GitHub pull requests to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API before you map to GitHub fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The GitHub data source field names must exist in your GitHub custom metadata.</p>', 'GitHubConfiguration$GitHubPullRequestDocumentAttachmentConfigurationFieldMappings' => '<p>A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of GitHub pull request attachments to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API before you map to GitHub fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The GitHub data source field names must exist in your GitHub custom metadata.</p>', 'GoogleDriveConfiguration$FieldMappings' => '<p>Maps Google Drive data source attributes or field names to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API before you map to Google Drive fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The Google Drive data source field names must exist in your Google Drive custom metadata.</p>', 'JiraConfiguration$AttachmentFieldMappings' => '<p>A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of Jira attachments to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API before you map to Jira fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html"> Mapping data source fields</a>. The Jira data source field names must exist in your Jira custom metadata.</p>', 'JiraConfiguration$CommentFieldMappings' => '<p>A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of Jira comments to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API before you map to Jira fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html"> Mapping data source fields</a>. The Jira data source field names must exist in your Jira custom metadata.</p>', 'JiraConfiguration$IssueFieldMappings' => '<p>A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of Jira issues to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API before you map to Jira fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html"> Mapping data source fields</a>. The Jira data source field names must exist in your Jira custom metadata.</p>', 'JiraConfiguration$ProjectFieldMappings' => '<p>A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of Jira projects to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API before you map to Jira fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html"> Mapping data source fields</a>. The Jira data source field names must exist in your Jira custom metadata.</p>', 'JiraConfiguration$WorkLogFieldMappings' => '<p>A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of Jira work logs to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API before you map to Jira fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html"> Mapping data source fields</a>. The Jira data source field names must exist in your Jira custom metadata.</p>', 'OneDriveConfiguration$FieldMappings' => '<p>A list of <code>DataSourceToIndexFieldMapping</code> objects that map OneDrive data source attributes or field names to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API before you map to OneDrive fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The OneDrive data source field names must exist in your OneDrive custom metadata.</p>', 'QuipConfiguration$ThreadFieldMappings' => '<p>A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of Quip threads to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API before you map to Quip fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The Quip field names must exist in your Quip custom metadata.</p>', 'QuipConfiguration$MessageFieldMappings' => '<p>A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of Quip messages to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API before you map to Quip fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The Quip field names must exist in your Quip custom metadata.</p>', 'QuipConfiguration$AttachmentFieldMappings' => '<p>A list of <code>DataSourceToIndexFieldMapping</code> objects that map attributes or field names of Quip attachments to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API before you map to Quip fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The Quip field names must exist in your Quip custom metadata.</p>', 'SalesforceChatterFeedConfiguration$FieldMappings' => '<p>Maps fields from a Salesforce chatter feed into Amazon Kendra index fields.</p>', 'SalesforceCustomKnowledgeArticleTypeConfiguration$FieldMappings' => '<p>Maps attributes or field names of the custom knowledge article to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API before you map to Salesforce fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The Salesforce data source field names must exist in your Salesforce custom metadata.</p>', 'SalesforceStandardKnowledgeArticleTypeConfiguration$FieldMappings' => '<p>Maps attributes or field names of the knowledge article to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API before you map to Salesforce fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The Salesforce data source field names must exist in your Salesforce custom metadata.</p>', 'SalesforceStandardObjectAttachmentConfiguration$FieldMappings' => '<p>One or more objects that map fields in attachments to Amazon Kendra index fields.</p>', 'SalesforceStandardObjectConfiguration$FieldMappings' => '<p>Maps attributes or field names of the standard object to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API before you map to Salesforce fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The Salesforce data source field names must exist in your Salesforce custom metadata.</p>', 'ServiceNowKnowledgeArticleConfiguration$FieldMappings' => '<p>Maps attributes or field names of knoweldge articles to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API before you map to ServiceNow fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The ServiceNow data source field names must exist in your ServiceNow custom metadata.</p>', 'ServiceNowServiceCatalogConfiguration$FieldMappings' => '<p>Maps attributes or field names of catalogs to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API before you map to ServiceNow fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The ServiceNow data source field names must exist in your ServiceNow custom metadata.</p>', 'SharePointConfiguration$FieldMappings' => '<p>A list of <code>DataSourceToIndexFieldMapping</code> objects that map SharePoint data source attributes or field names to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API before you map to SharePoint fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The SharePoint data source field names must exist in your SharePoint custom metadata.</p>', 'SlackConfiguration$FieldMappings' => '<p>A list of <code>DataSourceToIndexFieldMapping</code> objects that map Slack data source attributes or field names to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API before you map to Slack fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The Slack data source field names must exist in your Slack custom metadata.</p>', 'WorkDocsConfiguration$FieldMappings' => '<p>A list of <code>DataSourceToIndexFieldMapping</code> objects that map Amazon WorkDocs data source attributes or field names to Amazon Kendra index field names. To create custom fields, use the <code>UpdateIndex</code> API before you map to Amazon WorkDocs fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The Amazon WorkDocs data source field names must exist in your Amazon WorkDocs custom metadata.</p>', ], ], 'DataSourceType' => [ 'base' => NULL, 'refs' => [ 'CreateDataSourceRequest$Type' => '<p>The type of data source repository. For example, <code>SHAREPOINT</code>.</p>', 'DataSourceSummary$Type' => '<p>The type of the data source.</p>', 'DescribeDataSourceResponse$Type' => '<p>The type of the data source. For example, <code>SHAREPOINT</code>.</p>', ], ], 'DataSourceVpcConfiguration' => [ 'base' => '<p>Provides the configuration information to connect to an Amazon VPC.</p>', 'refs' => [ 'AlfrescoConfiguration$VpcConfiguration' => '<p>Configuration information for an Amazon Virtual Private Cloud to connect to your Alfresco. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html">Configuring a VPC</a>.</p>', 'BoxConfiguration$VpcConfiguration' => '<p>Configuration information for an Amazon VPC to connect to your Box. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html">Configuring a VPC</a>.</p>', 'ConfluenceConfiguration$VpcConfiguration' => '<p>Configuration information for an Amazon Virtual Private Cloud to connect to your Confluence. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html">Configuring a VPC</a>.</p>', 'CreateDataSourceRequest$VpcConfiguration' => '<p>Configuration information for an Amazon Virtual Private Cloud to connect to your data source. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html">Configuring a VPC</a>.</p>', 'DatabaseConfiguration$VpcConfiguration' => NULL, 'DescribeDataSourceResponse$VpcConfiguration' => '<p>Configuration information for an Amazon Virtual Private Cloud to connect to your data source. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html">Configuring a VPC</a>.</p>', 'FsxConfiguration$VpcConfiguration' => '<p>Configuration information for an Amazon Virtual Private Cloud to connect to your Amazon FSx. Your Amazon FSx instance must reside inside your VPC.</p>', 'GitHubConfiguration$VpcConfiguration' => '<p>Configuration information of an Amazon Virtual Private Cloud to connect to your GitHub. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html">Configuring a VPC</a>.</p>', 'JiraConfiguration$VpcConfiguration' => '<p>Configuration information for an Amazon Virtual Private Cloud to connect to your Jira. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html">Configuring a VPC</a>.</p>', 'QuipConfiguration$VpcConfiguration' => '<p>Configuration information for an Amazon Virtual Private Cloud (VPC) to connect to your Quip. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html">Configuring a VPC</a>.</p>', 'SharePointConfiguration$VpcConfiguration' => '<p>Configuration information for an Amazon Virtual Private Cloud to connect to your Microsoft SharePoint. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html">Configuring a VPC</a>.</p>', 'SlackConfiguration$VpcConfiguration' => '<p>Configuration information for an Amazon Virtual Private Cloud to connect to your Slack. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html">Configuring a VPC</a>.</p>', 'UpdateDataSourceRequest$VpcConfiguration' => '<p>Configuration information for an Amazon Virtual Private Cloud to connect to your data source. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html">Configuring a VPC</a>.</p>', ], ], 'DatabaseConfiguration' => [ 'base' => '<p>Provides the configuration information to an <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-database.html">Amazon Kendra supported database</a>.</p>', 'refs' => [ 'DataSourceConfiguration$DatabaseConfiguration' => '<p>Provides the configuration information to connect to a database as your data source.</p>', ], ], 'DatabaseEngineType' => [ 'base' => NULL, 'refs' => [ 'DatabaseConfiguration$DatabaseEngineType' => '<p>The type of database engine that runs the database.</p>', ], ], 'DatabaseHost' => [ 'base' => NULL, 'refs' => [ 'ConnectionConfiguration$DatabaseHost' => '<p>The name of the host for the database. Can be either a string (host.subdomain.domain.tld) or an IPv4 or IPv6 address.</p>', ], ], 'DatabaseName' => [ 'base' => NULL, 'refs' => [ 'ConnectionConfiguration$DatabaseName' => '<p>The name of the database containing the document data.</p>', ], ], 'DatabasePort' => [ 'base' => NULL, 'refs' => [ 'ConnectionConfiguration$DatabasePort' => '<p>The port that the database uses for connections.</p>', ], ], 'DeleteAccessControlConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAccessControlConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDataSourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteExperienceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteExperienceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFaqRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteIndexRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletePrincipalMappingRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteQuerySuggestionsBlockListRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteThesaurusRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccessControlConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccessControlConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDataSourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDataSourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeExperienceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeExperienceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFaqRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFaqResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFeaturedResultsSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFeaturedResultsSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIndexRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIndexResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribePrincipalMappingRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribePrincipalMappingResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeQuerySuggestionsBlockListRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeQuerySuggestionsBlockListResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeQuerySuggestionsConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeQuerySuggestionsConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeThesaurusRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeThesaurusResponse' => [ 'base' => NULL, 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'CreateAccessControlConfigurationRequest$Description' => '<p>A description for the access control configuration.</p>', 'CreateDataSourceRequest$Description' => '<p>A description for the data source connector.</p>', 'CreateExperienceRequest$Description' => '<p>A description for your Amazon Kendra experience.</p>', 'CreateFaqRequest$Description' => '<p>A description for the FAQ.</p>', 'CreateIndexRequest$Description' => '<p>A description for the index.</p>', 'CreateQuerySuggestionsBlockListRequest$Description' => '<p>A description for the block list.</p> <p>For example, the description "List of all offensive words that can appear in user queries and need to be blocked from suggestions."</p>', 'CreateThesaurusRequest$Description' => '<p>A description for the thesaurus.</p>', 'DescribeAccessControlConfigurationResponse$Description' => '<p>The description for the access control configuration.</p>', 'DescribeDataSourceResponse$Description' => '<p>The description for the data source connector.</p>', 'DescribeExperienceResponse$Description' => '<p>Shows the description for your Amazon Kendra experience.</p>', 'DescribeFaqResponse$Description' => '<p>The description of the FAQ that you provided when it was created.</p>', 'DescribeIndexResponse$Description' => '<p>The description for the index.</p>', 'DescribeQuerySuggestionsBlockListResponse$Description' => '<p>The description for the block list.</p>', 'DescribeThesaurusResponse$Description' => '<p>The thesaurus description.</p>', 'UpdateAccessControlConfigurationRequest$Description' => '<p>A new description for the access control configuration.</p>', 'UpdateDataSourceRequest$Description' => '<p>A new description for the data source connector.</p>', 'UpdateExperienceRequest$Description' => '<p>A new description for your Amazon Kendra experience.</p>', 'UpdateIndexRequest$Description' => '<p>A new description for the index.</p>', 'UpdateQuerySuggestionsBlockListRequest$Description' => '<p>A new description for the block list.</p>', 'UpdateThesaurusRequest$Description' => '<p>A new description for the thesaurus.</p>', ], ], 'DisassociateEntitiesFromExperienceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateEntitiesFromExperienceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateEntityList' => [ 'base' => NULL, 'refs' => [ 'DisassociateEntitiesFromExperienceRequest$EntityList' => '<p>Lists users or groups in your IAM Identity Center identity source.</p>', ], ], 'DisassociatePersonasFromEntitiesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociatePersonasFromEntitiesResponse' => [ 'base' => NULL, 'refs' => [], ], 'Document' => [ 'base' => '<p>A document in an index.</p>', 'refs' => [ 'DocumentList$member' => NULL, ], ], 'DocumentAttribute' => [ 'base' => '<p>A document attribute or metadata field. To create custom document attributes, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/custom-attributes.html">Custom attributes</a>.</p>', 'refs' => [ 'AttributeFilter$EqualsTo' => '<p>Performs an equals operation on document attributes/fields and their values.</p>', 'AttributeFilter$ContainsAll' => '<p>Returns true when a document contains all of the specified document attributes/fields. This filter is only applicable to <a href="https://docs.aws.amazon.com/kendra/latest/APIReference/API_DocumentAttributeValue.html">StringListValue</a>.</p>', 'AttributeFilter$ContainsAny' => '<p>Returns true when a document contains any of the specified document attributes/fields. This filter is only applicable to <a href="https://docs.aws.amazon.com/kendra/latest/APIReference/API_DocumentAttributeValue.html">StringListValue</a>.</p>', 'AttributeFilter$GreaterThan' => '<p>Performs a greater than operation on document attributes/fields and their values. Use with the <a href="https://docs.aws.amazon.com/kendra/latest/APIReference/API_DocumentAttributeValue.html">document attribute type</a> <code>Date</code> or <code>Long</code>.</p>', 'AttributeFilter$GreaterThanOrEquals' => '<p>Performs a greater or equals than operation on document attributes/fields and their values. Use with the <a href="https://docs.aws.amazon.com/kendra/latest/APIReference/API_DocumentAttributeValue.html">document attribute type</a> <code>Date</code> or <code>Long</code>.</p>', 'AttributeFilter$LessThan' => '<p>Performs a less than operation on document attributes/fields and their values. Use with the <a href="https://docs.aws.amazon.com/kendra/latest/APIReference/API_DocumentAttributeValue.html">document attribute type</a> <code>Date</code> or <code>Long</code>.</p>', 'AttributeFilter$LessThanOrEquals' => '<p>Performs a less than or equals operation on document attributes/fields and their values. Use with the <a href="https://docs.aws.amazon.com/kendra/latest/APIReference/API_DocumentAttributeValue.html">document attribute type</a> <code>Date</code> or <code>Long</code>.</p>', 'CollapsedResultDetail$DocumentAttribute' => '<p>The value of the document attribute that results are collapsed on.</p>', 'DocumentAttributeList$member' => NULL, ], ], 'DocumentAttributeCondition' => [ 'base' => '<p>The condition used for the target document attribute or metadata field when ingesting documents into Amazon Kendra. You use this with <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_DocumentAttributeTarget.html">DocumentAttributeTarget to apply the condition</a>.</p> <p>For example, you can create the \'Department\' target field and have it prefill department names associated with the documents based on information in the \'Source_URI\' field. Set the condition that if the \'Source_URI\' field contains \'financial\' in its URI value, then prefill the target field \'Department\' with the target value \'Finance\' for the document.</p> <p>Amazon Kendra cannot create a target field if it has not already been created as an index field. After you create your index field, you can create a document metadata field using <code>DocumentAttributeTarget</code>. Amazon Kendra then will map your newly created metadata field to your index field.</p>', 'refs' => [ 'HookConfiguration$InvocationCondition' => '<p>The condition used for when a Lambda function should be invoked.</p> <p>For example, you can specify a condition that if there are empty date-time values, then Amazon Kendra should invoke a function that inserts the current date-time.</p>', 'InlineCustomDocumentEnrichmentConfiguration$Condition' => '<p>Configuration of the condition used for the target document attribute or metadata field when ingesting documents into Amazon Kendra.</p>', ], ], 'DocumentAttributeKey' => [ 'base' => NULL, 'refs' => [ 'CollapseConfiguration$DocumentAttributeKey' => '<p>The document attribute used to group search results. You can use any attribute that has the <code>Sortable</code> flag set to true. You can also sort by any of the following built-in attributes:"_category","_created_at", "_last_updated_at", "_version", "_view_count".</p>', 'DocumentAttribute$Key' => '<p>The identifier for the attribute.</p>', 'DocumentAttributeCondition$ConditionDocumentAttributeKey' => '<p>The identifier of the document attribute used for the condition.</p> <p>For example, \'Source_URI\' could be an identifier for the attribute or metadata field that contains source URIs associated with the documents.</p> <p>Amazon Kendra currently does not support <code>_document_body</code> as an attribute key used for the condition.</p>', 'DocumentAttributeKeyList$member' => NULL, 'DocumentAttributeTarget$TargetDocumentAttributeKey' => '<p>The identifier of the target document attribute or metadata field.</p> <p>For example, \'Department\' could be an identifier for the target attribute or metadata field that includes the department names associated with the documents.</p>', 'Facet$DocumentAttributeKey' => '<p>The unique key for the document attribute.</p>', 'FacetResult$DocumentAttributeKey' => '<p>The key for the facet values. This is the same as the <code>DocumentAttributeKey</code> provided in the query.</p>', 'SortingConfiguration$DocumentAttributeKey' => '<p>The name of the document attribute used to sort the response. You can use any field that has the <code>Sortable</code> flag set to true.</p> <p>You can also sort by any of the following built-in attributes:</p> <ul> <li> <p>_category</p> </li> <li> <p>_created_at</p> </li> <li> <p>_last_updated_at</p> </li> <li> <p>_version</p> </li> <li> <p>_view_count</p> </li> </ul>', 'SuggestableConfig$AttributeName' => '<p>The name of the document field/attribute.</p>', ], ], 'DocumentAttributeKeyList' => [ 'base' => NULL, 'refs' => [ 'AttributeSuggestionsGetConfig$SuggestionAttributes' => '<p>The list of document field/attribute keys or field names to use for query suggestions. If the content within any of the fields match what your user starts typing as their query, then the field content is returned as a query suggestion.</p>', 'AttributeSuggestionsGetConfig$AdditionalResponseAttributes' => '<p>The list of additional document field/attribute keys or field names to include in the response. You can use additional fields to provide extra information in the response. Additional fields are not used to based suggestions on.</p>', 'QueryRequest$RequestedDocumentAttributes' => '<p>An array of document fields/attributes to include in the response. You can limit the response to include certain document fields. By default, all document attributes are included in the response.</p>', 'RetrieveRequest$RequestedDocumentAttributes' => '<p>A list of document fields/attributes to include in the response. You can limit the response to include certain document fields. By default, all document fields are included in the response.</p>', 'SourceDocument$SuggestionAttributes' => '<p>The document fields/attributes used for a query suggestion.</p>', ], ], 'DocumentAttributeList' => [ 'base' => NULL, 'refs' => [ 'Document$Attributes' => '<p>Custom attributes to apply to the document. Use the custom attributes to provide additional information for searching, to provide facets for refining searches, and to provide additional information in the query response.</p> <p>For example, \'DataSourceId\' and \'DataSourceSyncJobId\' are custom attributes that provide information on the synchronization of documents running on a data source. Note, \'DataSourceSyncJobId\' could be an optional custom attribute as Amazon Kendra will use the ID of a running sync job.</p>', 'DocumentInfo$Attributes' => '<p>Attributes that identify a specific version of a document to check.</p> <p>The only valid attributes are:</p> <ul> <li> <p>version</p> </li> <li> <p>datasourceId</p> </li> <li> <p>jobExecutionId</p> </li> </ul> <p>The attributes follow these rules:</p> <ul> <li> <p> <code>dataSourceId</code> and <code>jobExecutionId</code> must be used together.</p> </li> <li> <p> <code>version</code> is ignored if <code>dataSourceId</code> and <code>jobExecutionId</code> are not provided.</p> </li> <li> <p>If <code>dataSourceId</code> and <code>jobExecutionId</code> are provided, but <code>version</code> is not, the version defaults to "0".</p> </li> </ul>', 'ExpandedResultItem$DocumentAttributes' => '<p>An array of document attributes assigned to a document in the search results. For example, the document author ("_author") or the source URI ("_source_uri") of the document.</p>', 'FeaturedResultsItem$DocumentAttributes' => '<p>An array of document attributes assigned to a featured document in the search results. For example, the document author (<code>_author</code>) or the source URI (<code>_source_uri</code>) of the document.</p>', 'QueryResultItem$DocumentAttributes' => '<p>An array of document fields/attributes assigned to a document in the search results. For example, the document author (<code>_author</code>) or the source URI (<code>_source_uri</code>) of the document.</p>', 'RetrieveResultItem$DocumentAttributes' => '<p>An array of document fields/attributes assigned to a document in the search results. For example, the document author (<code>_author</code>) or the source URI (<code>_source_uri</code>) of the document.</p>', 'SourceDocument$AdditionalAttributes' => '<p>The additional fields/attributes to include in the response. You can use additional fields to provide extra information in the response. Additional fields are not used to based suggestions on.</p>', ], ], 'DocumentAttributeStringListValue' => [ 'base' => NULL, 'refs' => [ 'DocumentAttributeValue$StringListValue' => '<p>A list of strings. The default maximum length or number of strings is 10.</p>', ], ], 'DocumentAttributeStringValue' => [ 'base' => NULL, 'refs' => [ 'DocumentAttributeValue$StringValue' => '<p>A string, such as "department".</p>', ], ], 'DocumentAttributeTarget' => [ 'base' => '<p>The target document attribute or metadata field you want to alter when ingesting documents into Amazon Kendra.</p> <p>For example, you can delete customer identification numbers associated with the documents, stored in the document metadata field called \'Customer_ID\'. You set the target key as \'Customer_ID\' and the deletion flag to <code>TRUE</code>. This removes all customer ID values in the field \'Customer_ID\'. This would scrub personally identifiable information from each document\'s metadata.</p> <p>Amazon Kendra cannot create a target field if it has not already been created as an index field. After you create your index field, you can create a document metadata field using <code>DocumentAttributeTarget</code>. Amazon Kendra then will map your newly created metadata field to your index field.</p> <p>You can also use this with <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_DocumentAttributeCondition.html">DocumentAttributeCondition</a>.</p>', 'refs' => [ 'InlineCustomDocumentEnrichmentConfiguration$Target' => '<p>Configuration of the target document attribute or metadata field when ingesting documents into Amazon Kendra. You can also include a value.</p>', ], ], 'DocumentAttributeValue' => [ 'base' => '<p>The value of a document attribute. You can only provide one value for a document attribute.</p>', 'refs' => [ 'DocumentAttribute$Value' => '<p>The value of the attribute.</p>', 'DocumentAttributeCondition$ConditionOnValue' => '<p>The value used by the operator.</p> <p>For example, you can specify the value \'financial\' for strings in the \'Source_URI\' field that partially match or contain this value.</p>', 'DocumentAttributeTarget$TargetDocumentAttributeValue' => '<p>The target value you want to create for the target attribute.</p> <p>For example, \'Finance\' could be the target value for the target attribute key \'Department\'.</p>', 'DocumentAttributeValueCountPair$DocumentAttributeValue' => '<p>The value of the attribute/field. For example, "HR".</p>', ], ], 'DocumentAttributeValueCountPair' => [ 'base' => '<p>Provides the count of documents that match a particular document attribute or field when doing a faceted search.</p>', 'refs' => [ 'DocumentAttributeValueCountPairList$member' => NULL, ], ], 'DocumentAttributeValueCountPairList' => [ 'base' => NULL, 'refs' => [ 'FacetResult$DocumentAttributeValueCountPairs' => '<p>An array of key/value pairs, where the key is the value of the attribute and the count is the number of documents that share the key value.</p>', ], ], 'DocumentAttributeValueType' => [ 'base' => NULL, 'refs' => [ 'DocumentMetadataConfiguration$Type' => '<p>The data type of the index field. </p>', 'FacetResult$DocumentAttributeValueType' => '<p>The data type of the facet value. This is the same as the type defined for the index field when it was created.</p>', ], ], 'DocumentId' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteDocumentResponseFailedDocument$Id' => '<p>The identifier of the document that couldn\'t be removed from the index.</p>', 'BatchGetDocumentStatusResponseError$DocumentId' => '<p>The identifier of the document whose status could not be retrieved.</p>', 'BatchPutDocumentResponseFailedDocument$Id' => '<p>The identifier of the document.</p>', 'Document$Id' => '<p>A identifier of the document in the index.</p> <p>Note, each document ID must be unique per index. You cannot create a data source to index your documents with their unique IDs and then use the <code>BatchPutDocument</code> API to index the same documents, or vice versa. You can delete a data source and then use the <code>BatchPutDocument</code> API to index the same documents, or vice versa.</p>', 'DocumentIdList$member' => NULL, 'DocumentInfo$DocumentId' => '<p>The identifier of the document.</p>', 'ExpandedResultItem$DocumentId' => '<p>The idenitifier of the document.</p>', 'FeaturedDocument$Id' => '<p>The identifier of the document to feature in the search results. You can use the <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_Query.html">Query</a> API to search for specific documents with their document IDs included in the result items, or you can use the console.</p>', 'FeaturedDocumentMissing$Id' => '<p>The identifier of the document that doesn\'t exist but you have specified as a featured document.</p>', 'FeaturedDocumentWithMetadata$Id' => '<p>The identifier of the featured document with its metadata. You can use the <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_Query.html">Query</a> API to search for specific documents with their document IDs included in the result items, or you can use the console.</p>', 'FeaturedResultsItem$DocumentId' => '<p>The identifier of the featured document.</p>', 'QueryResultItem$DocumentId' => '<p>The identifier for the document.</p>', 'RetrieveResultItem$DocumentId' => '<p>The identifier of the document.</p>', 'Status$DocumentId' => '<p>The identifier of the document.</p>', ], ], 'DocumentIdList' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteDocumentRequest$DocumentIdList' => '<p>One or more identifiers for documents to delete from the index.</p>', ], ], 'DocumentInfo' => [ 'base' => '<p>Identifies a document for which to retrieve status information</p>', 'refs' => [ 'DocumentInfoList$member' => NULL, ], ], 'DocumentInfoList' => [ 'base' => NULL, 'refs' => [ 'BatchGetDocumentStatusRequest$DocumentInfoList' => '<p>A list of <code>DocumentInfo</code> objects that identify the documents for which to get the status. You identify the documents by their document ID and optional attributes.</p>', ], ], 'DocumentList' => [ 'base' => NULL, 'refs' => [ 'BatchPutDocumentRequest$Documents' => '<p>One or more documents to add to the index.</p> <p>Documents have the following file size limits.</p> <ul> <li> <p>50 MB total size for any file</p> </li> <li> <p>5 MB extracted text for any file</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas</a>.</p>', ], ], 'DocumentMetadataBoolean' => [ 'base' => NULL, 'refs' => [ 'Relevance$Freshness' => '<p>Indicates that this field determines how "fresh" a document is. For example, if document 1 was created on November 5, and document 2 was created on October 31, document 1 is "fresher" than document 2. Only applies to <code>DATE</code> fields.</p>', ], ], 'DocumentMetadataConfiguration' => [ 'base' => '<p>Specifies the properties, such as relevance tuning and searchability, of an index field.</p>', 'refs' => [ 'DocumentMetadataConfigurationList$member' => NULL, ], ], 'DocumentMetadataConfigurationList' => [ 'base' => NULL, 'refs' => [ 'DescribeIndexResponse$DocumentMetadataConfigurations' => '<p>Configuration information for document metadata or fields. Document metadata are fields or attributes associated with your documents. For example, the company department name associated with each document.</p>', 'UpdateIndexRequest$DocumentMetadataConfigurationUpdates' => '<p>The document metadata configuration you want to update for the index. Document metadata are fields or attributes associated with your documents. For example, the company department name associated with each document.</p>', ], ], 'DocumentMetadataConfigurationName' => [ 'base' => NULL, 'refs' => [ 'DocumentMetadataConfiguration$Name' => '<p>The name of the index field.</p>', 'DocumentRelevanceConfiguration$Name' => '<p>The name of the index field.</p>', ], ], 'DocumentRelevanceConfiguration' => [ 'base' => '<p>Overrides the document relevance properties of a custom index field.</p>', 'refs' => [ 'DocumentRelevanceOverrideConfigurationList$member' => NULL, ], ], 'DocumentRelevanceOverrideConfigurationList' => [ 'base' => NULL, 'refs' => [ 'QueryRequest$DocumentRelevanceOverrideConfigurations' => '<p>Overrides relevance tuning configurations of fields/attributes set at the index level.</p> <p>If you use this API to override the relevance tuning configured at the index level, but there is no relevance tuning configured at the index level, then Amazon Kendra does not apply any relevance tuning.</p> <p>If there is relevance tuning configured for fields at the index level, and you use this API to override only some of these fields, then for the fields you did not override, the importance is set to 1.</p>', 'RetrieveRequest$DocumentRelevanceOverrideConfigurations' => '<p>Overrides relevance tuning configurations of fields/attributes set at the index level.</p> <p>If you use this API to override the relevance tuning configured at the index level, but there is no relevance tuning configured at the index level, then Amazon Kendra does not apply any relevance tuning.</p> <p>If there is relevance tuning configured for fields at the index level, and you use this API to override only some of these fields, then for the fields you did not override, the importance is set to 1.</p>', ], ], 'DocumentStatus' => [ 'base' => NULL, 'refs' => [ 'Status$DocumentStatus' => '<p>The current status of a document.</p> <p>If the document was submitted for deletion, the status is <code>NOT_FOUND</code> after the document is deleted.</p>', ], ], 'DocumentStatusList' => [ 'base' => NULL, 'refs' => [ 'BatchGetDocumentStatusResponse$DocumentStatusList' => '<p>The status of documents. The status indicates if the document is waiting to be indexed, is in the process of indexing, has completed indexing, or failed indexing. If a document failed indexing, the status provides the reason why.</p>', ], ], 'DocumentTitle' => [ 'base' => NULL, 'refs' => [ 'RetrieveResultItem$DocumentTitle' => '<p>The title of the document.</p>', ], ], 'DocumentsMetadataConfiguration' => [ 'base' => '<p>Document metadata files that contain information such as the document access control information, source URI, document author, and custom attributes. Each metadata file contains metadata about a single document.</p>', 'refs' => [ 'S3DataSourceConfiguration$DocumentsMetadataConfiguration' => NULL, ], ], 'Domain' => [ 'base' => NULL, 'refs' => [ 'QuipConfiguration$Domain' => '<p>The Quip site domain. For example, <i>https://quip-company.quipdomain.com/browse</i>. The domain in this example is "quipdomain".</p>', ], ], 'Duration' => [ 'base' => NULL, 'refs' => [ 'Relevance$Duration' => '<p>Specifies the time period that the boost applies to. For example, to make the boost apply to documents with the field value within the last month, you would use "2628000s". Once the field value is beyond the specified range, the effect of the boost drops off. The higher the importance, the faster the effect drops off. If you don\'t specify a value, the default is 3 months. The value of the field is a numeric string followed by the character "s", for example "86400s" for one day, or "604800s" for one week. </p> <p>Only applies to <code>DATE</code> fields.</p>', ], ], 'Endpoint' => [ 'base' => NULL, 'refs' => [ 'ExperienceEndpoint$Endpoint' => '<p>The endpoint of your Amazon Kendra experience.</p>', ], ], 'EndpointType' => [ 'base' => NULL, 'refs' => [ 'ExperienceEndpoint$EndpointType' => '<p>The type of endpoint for your Amazon Kendra experience. The type currently available is <code>HOME</code>, which is a unique and fully hosted URL to the home page of your Amazon Kendra experience.</p>', ], ], 'EnterpriseId' => [ 'base' => NULL, 'refs' => [ 'BoxConfiguration$EnterpriseId' => '<p>The identifier of the Box Enterprise platform. You can find the enterprise ID in the Box Developer Console settings or when you create an app in Box and download your authentication credentials. For example, <i>801234567</i>.</p>', ], ], 'EntityConfiguration' => [ 'base' => '<p>Provides the configuration information for users or groups in your IAM Identity Center identity source to grant access your Amazon Kendra experience.</p>', 'refs' => [ 'AssociateEntityList$member' => NULL, 'DisassociateEntityList$member' => NULL, ], ], 'EntityDisplayData' => [ 'base' => '<p>Information about the user entity.</p>', 'refs' => [ 'ExperienceEntitiesSummary$DisplayData' => '<p>Information about the user entity.</p>', ], ], 'EntityFilter' => [ 'base' => NULL, 'refs' => [ 'AlfrescoConfiguration$EntityFilter' => '<p>Specify whether to index document libraries, wikis, or blogs. You can specify one or more of these options.</p>', ], ], 'EntityId' => [ 'base' => NULL, 'refs' => [ 'EntityConfiguration$EntityId' => '<p>The identifier of a user or group in your IAM Identity Center identity source. For example, a user ID could be an email.</p>', 'EntityIdsList$member' => NULL, 'EntityPersonaConfiguration$EntityId' => '<p>The identifier of a user or group in your IAM Identity Center identity source. For example, a user ID could be an email.</p>', 'ExperienceEntitiesSummary$EntityId' => '<p>The identifier of a user or group in your IAM Identity Center identity source. For example, a user ID could be an email.</p>', 'FailedEntity$EntityId' => '<p>The identifier of the user or group in your IAM Identity Center identity source. For example, a user ID could be an email.</p>', 'PersonasSummary$EntityId' => '<p>The identifier of a user or group in your IAM Identity Center identity source. For example, a user ID could be an email.</p>', ], ], 'EntityIdsList' => [ 'base' => NULL, 'refs' => [ 'DisassociatePersonasFromEntitiesRequest$EntityIds' => '<p>The identifiers of users or groups in your IAM Identity Center identity source. For example, user IDs could be user emails.</p>', ], ], 'EntityPersonaConfiguration' => [ 'base' => '<p>Provides the configuration information for users or groups in your IAM Identity Center identity source for access to your Amazon Kendra experience. Specific permissions are defined for each user or group once they are granted access to your Amazon Kendra experience.</p>', 'refs' => [ 'EntityPersonaConfigurationList$member' => NULL, ], ], 'EntityPersonaConfigurationList' => [ 'base' => NULL, 'refs' => [ 'AssociatePersonasToEntitiesRequest$Personas' => '<p>The personas that define the specific permissions of users or groups in your IAM Identity Center identity source. The available personas or access roles are <code>Owner</code> and <code>Viewer</code>. For more information on these personas, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html#access-search-experience">Providing access to your search page</a>.</p>', ], ], 'EntityType' => [ 'base' => NULL, 'refs' => [ 'EntityConfiguration$EntityType' => '<p>Specifies whether you are configuring a <code>User</code> or a <code>Group</code>.</p>', 'ExperienceEntitiesSummary$EntityType' => '<p>Shows the type as <code>User</code> or <code>Group</code>.</p>', ], ], 'ErrorCode' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteDocumentResponseFailedDocument$ErrorCode' => '<p>The error code for why the document couldn\'t be removed from the index.</p>', 'BatchDeleteFeaturedResultsSetError$ErrorCode' => '<p>The error code for why the set of featured results couldn\'t be removed from the index.</p>', 'BatchGetDocumentStatusResponseError$ErrorCode' => '<p>Indicates the source of the error.</p>', 'BatchPutDocumentResponseFailedDocument$ErrorCode' => '<p>The type of error that caused the document to fail to be indexed.</p>', 'DataSourceSyncJob$ErrorCode' => '<p>If the <code>Status</code> field is set to <code>FAILED</code>, the <code>ErrorCode</code> field indicates the reason the synchronization failed.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => NULL, 'BatchDeleteDocumentResponseFailedDocument$ErrorMessage' => '<p>An explanation for why the document couldn\'t be removed from the index.</p>', 'BatchDeleteFeaturedResultsSetError$ErrorMessage' => '<p>An explanation for why the set of featured results couldn\'t be removed from the index.</p>', 'BatchGetDocumentStatusResponseError$ErrorMessage' => '<p>States that the API could not get the status of a document. This could be because the request is not valid or there is a system error.</p>', 'BatchPutDocumentResponseFailedDocument$ErrorMessage' => '<p>A description of the reason why the document could not be indexed.</p>', 'ConflictException$Message' => NULL, 'DataSourceSyncJob$ErrorMessage' => '<p>If the <code>Status</code> field is set to <code>ERROR</code>, the <code>ErrorMessage</code> field contains a description of the error that caused the synchronization to fail.</p>', 'DescribeAccessControlConfigurationResponse$ErrorMessage' => '<p>The error message containing details if there are issues processing the access control configuration.</p>', 'DescribeDataSourceResponse$ErrorMessage' => '<p>When the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field contains a description of the error that caused the data source to fail.</p>', 'DescribeExperienceResponse$ErrorMessage' => '<p>The reason your Amazon Kendra experience could not properly process.</p>', 'DescribeFaqResponse$ErrorMessage' => '<p>If the <code>Status</code> field is <code>FAILED</code>, the <code>ErrorMessage</code> field contains the reason why the FAQ failed.</p>', 'DescribeIndexResponse$ErrorMessage' => '<p>When the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field contains a message that explains why.</p>', 'DescribeQuerySuggestionsBlockListResponse$ErrorMessage' => '<p>The error message containing details if there are issues processing the block list.</p>', 'DescribeThesaurusResponse$ErrorMessage' => '<p>When the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field provides more information. </p>', 'FailedEntity$ErrorMessage' => '<p>The reason the user or group in your IAM Identity Center identity source failed to properly configure with your Amazon Kendra experience.</p>', 'InternalServerException$Message' => NULL, 'InvalidRequestException$Message' => NULL, 'ResourceAlreadyExistException$Message' => NULL, 'ResourceInUseException$Message' => NULL, 'ResourceNotFoundException$Message' => NULL, 'ResourceUnavailableException$Message' => NULL, 'ServiceQuotaExceededException$Message' => NULL, 'ThrottlingException$Message' => NULL, 'ValidationException$Message' => NULL, ], ], 'ExcludeMimeTypesList' => [ 'base' => NULL, 'refs' => [ 'GoogleDriveConfiguration$ExcludeMimeTypes' => '<p>A list of MIME types to exclude from the index. All documents matching the specified MIME type are excluded. </p> <p>For a list of MIME types, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-google-drive.html">Using a Google Workspace Drive data source</a>.</p>', ], ], 'ExcludeSharedDrivesList' => [ 'base' => NULL, 'refs' => [ 'GoogleDriveConfiguration$ExcludeSharedDrives' => '<p>A list of identifiers or shared drives to exclude from the index. All files and folders stored on the shared drive are excluded.</p>', ], ], 'ExcludeUserAccountsList' => [ 'base' => NULL, 'refs' => [ 'GoogleDriveConfiguration$ExcludeUserAccounts' => '<p>A list of email addresses of the users. Documents owned by these users are excluded from the index. Documents shared with excluded users are indexed unless they are excluded in another way.</p>', ], ], 'ExpandConfiguration' => [ 'base' => '<p>Specifies the configuration information needed to customize how collapsed search result groups expand.</p>', 'refs' => [ 'CollapseConfiguration$ExpandConfiguration' => '<p>Provides configuration information to customize expansion options for a collapsed group.</p>', ], ], 'ExpandedResultItem' => [ 'base' => '<p> A single expanded result in a collapsed group of search results.</p> <p>An expanded result item contains information about an expanded result document within a collapsed group of search results. This includes the original location of the document, a list of attributes assigned to the document, and relevant text from the document that satisfies the query. </p>', 'refs' => [ 'ExpandedResultList$member' => NULL, ], ], 'ExpandedResultList' => [ 'base' => NULL, 'refs' => [ 'CollapsedResultDetail$ExpandedResults' => '<p>A list of results in the collapsed group.</p>', ], ], 'ExperienceConfiguration' => [ 'base' => '<p>Provides the configuration information for your Amazon Kendra experience. This includes the data source IDs and/or FAQ IDs, and user or group information to grant access to your Amazon Kendra experience.</p>', 'refs' => [ 'CreateExperienceRequest$Configuration' => '<p>Configuration information for your Amazon Kendra experience. This includes <code>ContentSourceConfiguration</code>, which specifies the data source IDs and/or FAQ IDs, and <code>UserIdentityConfiguration</code>, which specifies the user or group information to grant access to your Amazon Kendra experience.</p>', 'DescribeExperienceResponse$Configuration' => '<p>Shows the configuration information for your Amazon Kendra experience. This includes <code>ContentSourceConfiguration</code>, which specifies the data source IDs and/or FAQ IDs, and <code>UserIdentityConfiguration</code>, which specifies the user or group information to grant access to your Amazon Kendra experience.</p>', 'UpdateExperienceRequest$Configuration' => '<p>Configuration information you want to update for your Amazon Kendra experience.</p>', ], ], 'ExperienceEndpoint' => [ 'base' => '<p>Provides the configuration information for the endpoint for your Amazon Kendra experience.</p>', 'refs' => [ 'ExperienceEndpoints$member' => NULL, ], ], 'ExperienceEndpoints' => [ 'base' => NULL, 'refs' => [ 'DescribeExperienceResponse$Endpoints' => '<p>Shows the endpoint URLs for your Amazon Kendra experiences. The URLs are unique and fully hosted by Amazon Web Services.</p>', 'ExperiencesSummary$Endpoints' => '<p>The endpoint URLs for your Amazon Kendra experiences. The URLs are unique and fully hosted by Amazon Web Services.</p>', ], ], 'ExperienceEntitiesSummary' => [ 'base' => '<p>Summary information for users or groups in your IAM Identity Center identity source with granted access to your Amazon Kendra experience. You can create an Amazon Kendra experience such as a search application. For more information on creating a search application experience, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search experience with no code</a>.</p>', 'refs' => [ 'ExperienceEntitiesSummaryList$member' => NULL, ], ], 'ExperienceEntitiesSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListExperienceEntitiesResponse$SummaryItems' => '<p>An array of summary information for one or more users or groups.</p>', ], ], 'ExperienceId' => [ 'base' => NULL, 'refs' => [ 'AssociateEntitiesToExperienceRequest$Id' => '<p>The identifier of your Amazon Kendra experience.</p>', 'AssociatePersonasToEntitiesRequest$Id' => '<p>The identifier of your Amazon Kendra experience.</p>', 'CreateExperienceResponse$Id' => '<p>The identifier of your Amazon Kendra experience.</p>', 'DeleteExperienceRequest$Id' => '<p>The identifier of your Amazon Kendra experience you want to delete.</p>', 'DescribeExperienceRequest$Id' => '<p>The identifier of your Amazon Kendra experience you want to get information on.</p>', 'DescribeExperienceResponse$Id' => '<p>Shows the identifier of your Amazon Kendra experience.</p>', 'DisassociateEntitiesFromExperienceRequest$Id' => '<p>The identifier of your Amazon Kendra experience.</p>', 'DisassociatePersonasFromEntitiesRequest$Id' => '<p>The identifier of your Amazon Kendra experience.</p>', 'ExperiencesSummary$Id' => '<p>The identifier of your Amazon Kendra experience.</p>', 'ListEntityPersonasRequest$Id' => '<p>The identifier of your Amazon Kendra experience.</p>', 'ListExperienceEntitiesRequest$Id' => '<p>The identifier of your Amazon Kendra experience.</p>', 'UpdateExperienceRequest$Id' => '<p>The identifier of your Amazon Kendra experience you want to update.</p>', ], ], 'ExperienceName' => [ 'base' => NULL, 'refs' => [ 'CreateExperienceRequest$Name' => '<p>A name for your Amazon Kendra experience.</p>', 'DescribeExperienceResponse$Name' => '<p>Shows the name of your Amazon Kendra experience.</p>', 'ExperiencesSummary$Name' => '<p>The name of your Amazon Kendra experience.</p>', 'UpdateExperienceRequest$Name' => '<p>A new name for your Amazon Kendra experience.</p>', ], ], 'ExperienceStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeExperienceResponse$Status' => '<p>The current processing status of your Amazon Kendra experience. When the status is <code>ACTIVE</code>, your Amazon Kendra experience is ready to use. When the status is <code>FAILED</code>, the <code>ErrorMessage</code> field contains the reason that this failed.</p>', 'ExperiencesSummary$Status' => '<p>The processing status of your Amazon Kendra experience.</p>', ], ], 'ExperiencesSummary' => [ 'base' => '<p>Summary information for your Amazon Kendra experience. You can create an Amazon Kendra experience such as a search application. For more information on creating a search application experience, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search experience with no code</a>.</p>', 'refs' => [ 'ExperiencesSummaryList$member' => NULL, ], ], 'ExperiencesSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListExperiencesResponse$SummaryItems' => '<p>An array of summary information for one or more Amazon Kendra experiences.</p>', ], ], 'Facet' => [ 'base' => '<p>Information about a document attribute or field. You can use document attributes as facets.</p> <p>For example, the document attribute or facet "Department" includes the values "HR", "Engineering", and "Accounting". You can display these values in the search results so that documents can be searched by department.</p> <p>You can display up to 10 facet values per facet for a query. If you want to increase this limit, contact <a href="http://aws.amazon.com/contact-us/">Support</a>.</p>', 'refs' => [ 'FacetList$member' => NULL, ], ], 'FacetList' => [ 'base' => NULL, 'refs' => [ 'Facet$Facets' => '<p>An array of document attributes that are nested facets within a facet.</p> <p>For example, the document attribute or facet "Department" includes a value called "Engineering". In addition, the document attribute or facet "SubDepartment" includes the values "Frontend" and "Backend" for documents assigned to "Engineering". You can display nested facets in the search results so that documents can be searched not only by department but also by a sub department within a department. This helps your users further narrow their search.</p> <p>You can only have one nested facet within a facet. If you want to increase this limit, contact <a href="http://aws.amazon.com/contact-us/">Support</a>.</p>', 'QueryRequest$Facets' => '<p>An array of documents fields/attributes for faceted search. Amazon Kendra returns a count for each field key specified. This helps your users narrow their search.</p>', ], ], 'FacetResult' => [ 'base' => '<p>The facet values for the documents in the response.</p>', 'refs' => [ 'FacetResultList$member' => NULL, ], ], 'FacetResultList' => [ 'base' => NULL, 'refs' => [ 'DocumentAttributeValueCountPair$FacetResults' => '<p>Contains the results of a document attribute/field that is a nested facet. A <code>FacetResult</code> contains the counts for each facet nested within a facet.</p> <p>For example, the document attribute or facet "Department" includes a value called "Engineering". In addition, the document attribute or facet "SubDepartment" includes the values "Frontend" and "Backend" for documents assigned to "Engineering". You can display nested facets in the search results so that documents can be searched not only by department but also by a sub department within a department. The counts for documents that belong to "Frontend" and "Backend" within "Engineering" are returned for a query.</p> <p/> <p/>', 'QueryResult$FacetResults' => '<p>Contains the facet results. A <code>FacetResult</code> contains the counts for each field/attribute key that was specified in the <code>Facets</code> input parameter.</p>', ], ], 'FailedEntity' => [ 'base' => '<p>Information on the users or groups in your IAM Identity Center identity source that failed to properly configure with your Amazon Kendra experience.</p>', 'refs' => [ 'AssociateEntitiesToExperienceFailedEntityList$member' => NULL, 'FailedEntityList$member' => NULL, ], ], 'FailedEntityList' => [ 'base' => NULL, 'refs' => [ 'AssociatePersonasToEntitiesResponse$FailedEntityList' => '<p>Lists the users or groups in your IAM Identity Center identity source that failed to properly configure with your Amazon Kendra experience.</p>', 'DisassociateEntitiesFromExperienceResponse$FailedEntityList' => '<p>Lists the users or groups in your IAM Identity Center identity source that failed to properly remove access to your Amazon Kendra experience.</p>', 'DisassociatePersonasFromEntitiesResponse$FailedEntityList' => '<p>Lists the users or groups in your IAM Identity Center identity source that failed to properly remove access to your Amazon Kendra experience.</p>', ], ], 'FailureReason' => [ 'base' => NULL, 'refs' => [ 'GroupOrderingIdSummary$FailureReason' => '<p>The reason an action could not be processed. An action can be a <code>PUT</code> or <code>DELETE</code> action for mapping users to their groups.</p>', ], ], 'FaqFileFormat' => [ 'base' => NULL, 'refs' => [ 'CreateFaqRequest$FileFormat' => '<p>The format of the FAQ input file. You can choose between a basic CSV format, a CSV format that includes customs attributes in a header, and a JSON format that includes custom attributes.</p> <p>The default format is CSV.</p> <p>The format must match the format of the file stored in the S3 bucket identified in the <code>S3Path</code> parameter.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-creating-faq.html">Adding questions and answers</a>.</p>', 'DescribeFaqResponse$FileFormat' => '<p>The file format used by the input files for the FAQ.</p>', 'FaqSummary$FileFormat' => '<p>The file type used to create the FAQ. </p>', ], ], 'FaqId' => [ 'base' => NULL, 'refs' => [ 'CreateFaqResponse$Id' => '<p>The identifier of the FAQ.</p>', 'DeleteFaqRequest$Id' => '<p>The identifier of the FAQ you want to remove.</p>', 'DescribeFaqRequest$Id' => '<p>The identifier of the FAQ you want to get information on.</p>', 'DescribeFaqResponse$Id' => '<p>The identifier of the FAQ.</p>', 'FaqIdsList$member' => NULL, 'FaqSummary$Id' => '<p>The identifier of the FAQ.</p>', ], ], 'FaqIdsList' => [ 'base' => NULL, 'refs' => [ 'ContentSourceConfiguration$FaqIds' => '<p>The identifier of the FAQs that you want to use for your Amazon Kendra experience.</p>', ], ], 'FaqName' => [ 'base' => NULL, 'refs' => [ 'CreateFaqRequest$Name' => '<p>A name for the FAQ.</p>', 'DescribeFaqResponse$Name' => '<p>The name that you gave the FAQ when it was created.</p>', 'FaqSummary$Name' => '<p>The name that you assigned the FAQ when you created or updated the FAQ.</p>', ], ], 'FaqStatistics' => [ 'base' => '<p>Provides statistical information about the FAQ questions and answers contained in an index.</p>', 'refs' => [ 'IndexStatistics$FaqStatistics' => '<p>The number of question and answer topics in the index.</p>', ], ], 'FaqStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeFaqResponse$Status' => '<p>The status of the FAQ. It is ready to use when the status is <code>ACTIVE</code>.</p>', 'FaqSummary$Status' => '<p>The current status of the FAQ. When the status is <code>ACTIVE</code> the FAQ is ready for use.</p>', ], ], 'FaqSummary' => [ 'base' => '<p>Summary information for frequently asked questions and answers included in an index.</p>', 'refs' => [ 'FaqSummaryItems$member' => NULL, ], ], 'FaqSummaryItems' => [ 'base' => NULL, 'refs' => [ 'ListFaqsResponse$FaqSummaryItems' => '<p>information about the FAQs associated with the specified index.</p>', ], ], 'FeaturedDocument' => [ 'base' => '<p>A featured document. This document is displayed at the top of the search results page, placed above all other results for certain queries. If there\'s an exact match of a query, then the document is featured in the search results.</p>', 'refs' => [ 'FeaturedDocumentList$member' => NULL, ], ], 'FeaturedDocumentList' => [ 'base' => NULL, 'refs' => [ 'CreateFeaturedResultsSetRequest$FeaturedDocuments' => '<p>A list of document IDs for the documents you want to feature at the top of the search results page. For more information on the list of documents, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_FeaturedResultsSet.html">FeaturedResultsSet</a>.</p>', 'FeaturedResultsSet$FeaturedDocuments' => '<p>The list of document IDs for the documents you want to feature at the top of the search results page. You can use the <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_Query.html">Query</a> API to search for specific documents with their document IDs included in the result items, or you can use the console.</p> <p>You can add up to four featured documents. You can request to increase this limit by contacting <a href="http://aws.amazon.com/contact-us/">Support</a>.</p> <p>Specific queries are mapped to specific documents for featuring in the results. If a query contains an exact match, then one or more specific documents are featured in the results. The exact match applies to the full query. For example, if you only specify \'Kendra\', queries such as \'How does kendra semantically rank results?\' will not render the featured results. Featured results are designed for specific queries, rather than queries that are too broad in scope.</p>', 'UpdateFeaturedResultsSetRequest$FeaturedDocuments' => '<p>A list of document IDs for the documents you want to feature at the top of the search results page. For more information on the list of featured documents, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_FeaturedResultsSet.html">FeaturedResultsSet</a>.</p>', ], ], 'FeaturedDocumentMissing' => [ 'base' => '<p>A document ID doesn\'t exist but you have specified as a featured document. Amazon Kendra cannot feature the document if it doesn\'t exist in the index. You can check the status of a document and its ID or check for documents with status errors using the <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_BatchGetDocumentStatus.html">BatchGetDocumentStatus</a> API.</p>', 'refs' => [ 'FeaturedDocumentMissingList$member' => NULL, ], ], 'FeaturedDocumentMissingList' => [ 'base' => NULL, 'refs' => [ 'DescribeFeaturedResultsSetResponse$FeaturedDocumentsMissing' => '<p>The list of document IDs that don\'t exist but you have specified as featured documents. Amazon Kendra cannot feature these documents if they don\'t exist in the index. You can check the status of a document and its ID or check for documents with status errors using the <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_BatchGetDocumentStatus.html">BatchGetDocumentStatus</a> API.</p>', ], ], 'FeaturedDocumentWithMetadata' => [ 'base' => '<p>A featured document with its metadata information. This document is displayed at the top of the search results page, placed above all other results for certain queries. If there\'s an exact match of a query, then the document is featured in the search results.</p>', 'refs' => [ 'FeaturedDocumentWithMetadataList$member' => NULL, ], ], 'FeaturedDocumentWithMetadataList' => [ 'base' => NULL, 'refs' => [ 'DescribeFeaturedResultsSetResponse$FeaturedDocumentsWithMetadata' => '<p>The list of document IDs for the documents you want to feature with their metadata information. For more information on the list of featured documents, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_FeaturedResultsSet.html">FeaturedResultsSet</a>.</p>', ], ], 'FeaturedResultsConflictException' => [ 'base' => '<p>An error message with a list of conflicting queries used across different sets of featured results. This occurred with the request for a new featured results set. Check that the queries you specified for featured results are unique per featured results set for each index.</p>', 'refs' => [], ], 'FeaturedResultsItem' => [ 'base' => '<p>A single featured result item. A featured result is displayed at the top of the search results page, placed above all other results for certain queries. If there\'s an exact match of a query, then certain documents are featured in the search results.</p>', 'refs' => [ 'FeaturedResultsItemList$member' => NULL, ], ], 'FeaturedResultsItemList' => [ 'base' => NULL, 'refs' => [ 'QueryResult$FeaturedResultsItems' => '<p>The list of featured result items. Featured results are displayed at the top of the search results page, placed above all other results for certain queries. If there\'s an exact match of a query, then certain documents are featured in the search results.</p>', ], ], 'FeaturedResultsSet' => [ 'base' => '<p>A set of featured results that are displayed at the top of your search results. Featured results are placed above all other results for certain queries. If there\'s an exact match of a query, then one or more specific documents are featured in the search results.</p>', 'refs' => [ 'CreateFeaturedResultsSetResponse$FeaturedResultsSet' => '<p>Information on the set of featured results. This includes the identifier of the featured results set, whether the featured results set is active or inactive, when the featured results set was created, and more.</p>', 'UpdateFeaturedResultsSetResponse$FeaturedResultsSet' => '<p>Information on the set of featured results. This includes the identifier of the featured results set, whether the featured results set is active or inactive, when the featured results set was last updated, and more.</p>', ], ], 'FeaturedResultsSetDescription' => [ 'base' => NULL, 'refs' => [ 'CreateFeaturedResultsSetRequest$Description' => '<p>A description for the set of featured results.</p>', 'DescribeFeaturedResultsSetResponse$Description' => '<p>The description for the set of featured results.</p>', 'FeaturedResultsSet$Description' => '<p>The description for the set of featured results.</p>', 'UpdateFeaturedResultsSetRequest$Description' => '<p>A new description for the set of featured results.</p>', ], ], 'FeaturedResultsSetId' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteFeaturedResultsSetError$Id' => '<p>The identifier of the set of featured results that couldn\'t be removed from the index.</p>', 'DescribeFeaturedResultsSetRequest$FeaturedResultsSetId' => '<p>The identifier of the set of featured results that you want to get information on.</p>', 'DescribeFeaturedResultsSetResponse$FeaturedResultsSetId' => '<p>The identifier of the set of featured results.</p>', 'FeaturedResultsSet$FeaturedResultsSetId' => '<p>The identifier of the set of featured results.</p>', 'FeaturedResultsSetIdList$member' => NULL, 'FeaturedResultsSetSummary$FeaturedResultsSetId' => '<p>The identifier of the set of featured results.</p>', 'UpdateFeaturedResultsSetRequest$FeaturedResultsSetId' => '<p>The identifier of the set of featured results that you want to update.</p>', ], ], 'FeaturedResultsSetIdList' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteFeaturedResultsSetRequest$FeaturedResultsSetIds' => '<p>The identifiers of the featured results sets that you want to delete.</p>', ], ], 'FeaturedResultsSetName' => [ 'base' => NULL, 'refs' => [ 'CreateFeaturedResultsSetRequest$FeaturedResultsSetName' => '<p>A name for the set of featured results.</p>', 'DescribeFeaturedResultsSetResponse$FeaturedResultsSetName' => '<p>The name for the set of featured results.</p>', 'FeaturedResultsSet$FeaturedResultsSetName' => '<p>The name for the set of featured results.</p>', 'FeaturedResultsSetSummary$FeaturedResultsSetName' => '<p>The name for the set of featured results.</p>', 'UpdateFeaturedResultsSetRequest$FeaturedResultsSetName' => '<p>A new name for the set of featured results.</p>', ], ], 'FeaturedResultsSetStatus' => [ 'base' => NULL, 'refs' => [ 'CreateFeaturedResultsSetRequest$Status' => '<p>The current status of the set of featured results. When the value is <code>ACTIVE</code>, featured results are ready for use. You can still configure your settings before setting the status to <code>ACTIVE</code>. You can set the status to <code>ACTIVE</code> or <code>INACTIVE</code> using the <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateFeaturedResultsSet.html">UpdateFeaturedResultsSet</a> API. The queries you specify for featured results must be unique per featured results set for each index, whether the status is <code>ACTIVE</code> or <code>INACTIVE</code>.</p>', 'DescribeFeaturedResultsSetResponse$Status' => '<p>The current status of the set of featured results. When the value is <code>ACTIVE</code>, featured results are ready for use. You can still configure your settings before setting the status to <code>ACTIVE</code>. You can set the status to <code>ACTIVE</code> or <code>INACTIVE</code> using the <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateFeaturedResultsSet.html">UpdateFeaturedResultsSet</a> API. The queries you specify for featured results must be unique per featured results set for each index, whether the status is <code>ACTIVE</code> or <code>INACTIVE</code>.</p>', 'FeaturedResultsSet$Status' => '<p>The current status of the set of featured results. When the value is <code>ACTIVE</code>, featured results are ready for use. You can still configure your settings before setting the status to <code>ACTIVE</code>. You can set the status to <code>ACTIVE</code> or <code>INACTIVE</code> using the <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateFeaturedResultsSet.html">UpdateFeaturedResultsSet</a> API. The queries you specify for featured results must be unique per featured results set for each index, whether the status is <code>ACTIVE</code> or <code>INACTIVE</code>.</p>', 'FeaturedResultsSetSummary$Status' => '<p>The current status of the set of featured results. When the value is <code>ACTIVE</code>, featured results are ready for use. You can still configure your settings before setting the status to <code>ACTIVE</code>. You can set the status to <code>ACTIVE</code> or <code>INACTIVE</code> using the <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateFeaturedResultsSet.html">UpdateFeaturedResultsSet</a> API. The queries you specify for featured results must be unique per featured results set for each index, whether the status is <code>ACTIVE</code> or <code>INACTIVE</code>.</p>', 'UpdateFeaturedResultsSetRequest$Status' => '<p>You can set the status to <code>ACTIVE</code> or <code>INACTIVE</code>. When the value is <code>ACTIVE</code>, featured results are ready for use. You can still configure your settings before setting the status to <code>ACTIVE</code>. The queries you specify for featured results must be unique per featured results set for each index, whether the status is <code>ACTIVE</code> or <code>INACTIVE</code>.</p>', ], ], 'FeaturedResultsSetSummary' => [ 'base' => '<p>Summary information for a set of featured results. Featured results are placed above all other results for certain queries. If there\'s an exact match of a query, then one or more specific documents are featured in the search results.</p>', 'refs' => [ 'FeaturedResultsSetSummaryItems$member' => NULL, ], ], 'FeaturedResultsSetSummaryItems' => [ 'base' => NULL, 'refs' => [ 'ListFeaturedResultsSetsResponse$FeaturedResultsSetSummaryItems' => '<p>An array of summary information for one or more featured results sets.</p>', ], ], 'FeedbackToken' => [ 'base' => NULL, 'refs' => [ 'FeaturedResultsItem$FeedbackToken' => '<p>A token that identifies a particular featured result from a particular query. Use this token to provide click-through feedback for the result. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/submitting-feedback.html">Submitting feedback</a>.</p>', 'QueryResultItem$FeedbackToken' => '<p>A token that identifies a particular result from a particular query. Use this token to provide click-through feedback for the result. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/submitting-feedback.html">Submitting feedback</a>.</p>', ], ], 'FileSystemId' => [ 'base' => NULL, 'refs' => [ 'FsxConfiguration$FileSystemId' => '<p>The identifier of the Amazon FSx file system.</p> <p>You can find your file system ID on the file system dashboard in the Amazon FSx console. For information on how to create a file system in Amazon FSx console, using Windows File Server as an example, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/getting-started-step1.html">Amazon FSx Getting started guide</a>.</p>', ], ], 'FolderId' => [ 'base' => NULL, 'refs' => [ 'FolderIdList$member' => NULL, ], ], 'FolderIdList' => [ 'base' => NULL, 'refs' => [ 'QuipConfiguration$FolderIds' => '<p>The identifiers of the Quip folders you want to index. You can find the folder ID in your browser URL when you access your folder in Quip. For example, <i>https://quip-company.quipdomain.com/zlLuOVNSarTL/folder-name</i>. The folder ID in this example is "zlLuOVNSarTL".</p>', ], ], 'FsxConfiguration' => [ 'base' => '<p>Provides the configuration information to connect to Amazon FSx as your data source.</p> <note> <p>Amazon Kendra now supports an upgraded Amazon FSx Windows connector.</p> <p>You must now use the <a href="https://docs.aws.amazon.com/kendra/latest/APIReference/API_TemplateConfiguration.html">TemplateConfiguration</a> object instead of the <code>FsxConfiguration</code> object to configure your connector.</p> <p>Connectors configured using the older console and API architecture will continue to function as configured. However, you won\'t be able to edit or update them. If you want to edit or update your connector configuration, you must create a new connector.</p> <p>We recommended migrating your connector workflow to the upgraded version. Support for connectors configured using the older architecture is scheduled to end by June 2024.</p> </note>', 'refs' => [ 'DataSourceConfiguration$FsxConfiguration' => '<p>Provides the configuration information to connect to Amazon FSx as your data source.</p> <note> <p>Amazon Kendra now supports an upgraded Amazon FSx Windows connector.</p> <p>You must now use the <a href="https://docs.aws.amazon.com/kendra/latest/APIReference/API_TemplateConfiguration.html">TemplateConfiguration</a> object instead of the <code>FsxConfiguration</code> object to configure your connector.</p> <p>Connectors configured using the older console and API architecture will continue to function as configured. However, you won\'t be able to edit or update them. If you want to edit or update your connector configuration, you must create a new connector.</p> <p>We recommended migrating your connector workflow to the upgraded version. Support for connectors configured using the older architecture is scheduled to end by June 2024.</p> </note>', ], ], 'FsxFileSystemType' => [ 'base' => NULL, 'refs' => [ 'FsxConfiguration$FileSystemType' => '<p>The Amazon FSx file system type. Windows is currently the only supported type.</p>', ], ], 'GetQuerySuggestionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetQuerySuggestionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetSnapshotsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSnapshotsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GitHubConfiguration' => [ 'base' => '<p>Provides the configuration information to connect to GitHub as your data source.</p> <note> <p>Amazon Kendra now supports an upgraded GitHub connector.</p> <p>You must now use the <a href="https://docs.aws.amazon.com/kendra/latest/APIReference/API_TemplateConfiguration.html">TemplateConfiguration</a> object instead of the <code>GitHubConfiguration</code> object to configure your connector.</p> <p>Connectors configured using the older console and API architecture will continue to function as configured. However, you won’t be able to edit or update them. If you want to edit or update your connector configuration, you must create a new connector.</p> <p>We recommended migrating your connector workflow to the upgraded version. Support for connectors configured using the older architecture is scheduled to end by June 2024.</p> </note>', 'refs' => [ 'DataSourceConfiguration$GitHubConfiguration' => '<p>Provides the configuration information to connect to GitHub as your data source.</p> <note> <p>Amazon Kendra now supports an upgraded GitHub connector.</p> <p>You must now use the <a href="https://docs.aws.amazon.com/kendra/latest/APIReference/API_TemplateConfiguration.html">TemplateConfiguration</a> object instead of the <code>GitHubConfiguration</code> object to configure your connector.</p> <p>Connectors configured using the older console and API architecture will continue to function as configured. However, you won’t be able to edit or update them. If you want to edit or update your connector configuration, you must create a new connector.</p> <p>We recommended migrating your connector workflow to the upgraded version. Support for connectors configured using the older architecture is scheduled to end by June 2024.</p> </note>', ], ], 'GitHubDocumentCrawlProperties' => [ 'base' => '<p>Provides the configuration information to include certain types of GitHub content. You can configure to index repository files only, or also include issues and pull requests, comments, and comment attachments.</p>', 'refs' => [ 'GitHubConfiguration$GitHubDocumentCrawlProperties' => '<p>Configuration information to include certain types of GitHub content. You can configure to index repository files only, or also include issues and pull requests, comments, and comment attachments.</p>', ], ], 'GoogleDriveConfiguration' => [ 'base' => '<p>Provides the configuration information to connect to Google Drive as your data source.</p>', 'refs' => [ 'DataSourceConfiguration$GoogleDriveConfiguration' => '<p>Provides the configuration information to connect to Google Drive as your data source.</p>', ], ], 'GroupAttributeField' => [ 'base' => NULL, 'refs' => [ 'JwtTokenTypeConfiguration$GroupAttributeField' => '<p>The group attribute field.</p>', ], ], 'GroupId' => [ 'base' => NULL, 'refs' => [ 'DeletePrincipalMappingRequest$GroupId' => '<p>The identifier of the group you want to delete.</p>', 'DescribePrincipalMappingRequest$GroupId' => '<p>The identifier of the group required to check the processing of <code>PUT</code> and <code>DELETE</code> actions for mapping users to their groups.</p>', 'DescribePrincipalMappingResponse$GroupId' => '<p>Shows the identifier of the group to see information on the processing of <code>PUT</code> and <code>DELETE</code> actions for mapping users to their groups.</p>', 'GroupSummary$GroupId' => '<p>The identifier of the group you want group summary information on.</p>', 'MemberGroup$GroupId' => '<p>The identifier of the sub group you want to map to a group.</p>', 'PutPrincipalMappingRequest$GroupId' => '<p>The identifier of the group you want to map its users to.</p>', ], ], 'GroupMembers' => [ 'base' => '<p>A list of users or sub groups that belong to a group. This is useful for user context filtering, where search results are filtered based on the user or their group access to documents.</p>', 'refs' => [ 'PutPrincipalMappingRequest$GroupMembers' => '<p>The list that contains your users or sub groups that belong the same group.</p> <p>For example, the group "Company" includes the user "CEO" and the sub groups "Research", "Engineering", and "Sales and Marketing".</p> <p>If you have more than 1000 users and/or sub groups for a single group, you need to provide the path to the S3 file that lists your users and sub groups for a group. Your sub groups can contain more than 1000 users, but the list of sub groups that belong to a group (and/or users) must be no more than 1000.</p>', ], ], 'GroupOrderingIdSummaries' => [ 'base' => NULL, 'refs' => [ 'DescribePrincipalMappingResponse$GroupOrderingIdSummaries' => '<p>Shows the following information on the processing of <code>PUT</code> and <code>DELETE</code> actions for mapping users to their groups:</p> <ul> <li> <p>Status—the status can be either <code>PROCESSING</code>, <code>SUCCEEDED</code>, <code>DELETING</code>, <code>DELETED</code>, or <code>FAILED</code>.</p> </li> <li> <p>Last updated—the last date-time an action was updated.</p> </li> <li> <p>Received—the last date-time an action was received or submitted.</p> </li> <li> <p>Ordering ID—the latest action that should process and apply after other actions.</p> </li> <li> <p>Failure reason—the reason an action could not be processed.</p> </li> </ul>', ], ], 'GroupOrderingIdSummary' => [ 'base' => '<p>Summary information on the processing of <code>PUT</code> and <code>DELETE</code> actions for mapping users to their groups.</p>', 'refs' => [ 'GroupOrderingIdSummaries$member' => NULL, ], ], 'GroupSummary' => [ 'base' => '<p>Summary information for groups.</p>', 'refs' => [ 'ListOfGroupSummaries$member' => NULL, ], ], 'Groups' => [ 'base' => NULL, 'refs' => [ 'UserContext$Groups' => '<p>The list of groups you want to filter search results based on the groups\' access to documents.</p>', ], ], 'HierarchicalPrincipal' => [ 'base' => '<p> Information to define the hierarchy for which documents users should have access to. </p>', 'refs' => [ 'HierarchicalPrincipalList$member' => NULL, ], ], 'HierarchicalPrincipalList' => [ 'base' => '<p>A list of <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_Principal.html">principal</a> lists that define the hierarchy for which documents users should have access to. Each hierarchical list specifies which user or group has allow or deny access for each document.</p>', 'refs' => [ 'CreateAccessControlConfigurationRequest$HierarchicalAccessControlList' => '<p>The list of <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_Principal.html">principal</a> lists that define the hierarchy for which documents users should have access to.</p>', 'DescribeAccessControlConfigurationResponse$HierarchicalAccessControlList' => '<p>The list of <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_Principal.html">principal</a> lists that define the hierarchy for which documents users should have access to.</p>', 'Document$HierarchicalAccessControlList' => '<p>The list of <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_Principal.html">principal</a> lists that define the hierarchy for which documents users should have access to.</p>', 'UpdateAccessControlConfigurationRequest$HierarchicalAccessControlList' => '<p>The updated list of <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_Principal.html">principal</a> lists that define the hierarchy for which documents users should have access to.</p>', ], ], 'Highlight' => [ 'base' => '<p>Provides information that you can use to highlight a search result so that your users can quickly identify terms in the response.</p>', 'refs' => [ 'HighlightList$member' => NULL, ], ], 'HighlightList' => [ 'base' => NULL, 'refs' => [ 'TextWithHighlights$Highlights' => '<p>The beginning and end of the text that should be highlighted.</p>', ], ], 'HighlightType' => [ 'base' => NULL, 'refs' => [ 'Highlight$Type' => '<p>The highlight type. </p>', ], ], 'HookConfiguration' => [ 'base' => '<p>Provides the configuration information for invoking a Lambda function in Lambda to alter document metadata and content when ingesting documents into Amazon Kendra. You can configure your Lambda function using <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_CustomDocumentEnrichmentConfiguration.html">PreExtractionHookConfiguration</a> if you want to apply advanced alterations on the original or raw documents. If you want to apply advanced alterations on the Amazon Kendra structured documents, you must configure your Lambda function using <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_CustomDocumentEnrichmentConfiguration.html">PostExtractionHookConfiguration</a>. You can only invoke one Lambda function. However, this function can invoke other functions it requires.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html">Customizing document metadata during the ingestion process</a>.</p>', 'refs' => [ 'CustomDocumentEnrichmentConfiguration$PreExtractionHookConfiguration' => '<p>Configuration information for invoking a Lambda function in Lambda on the original or raw documents before extracting their metadata and text. You can use a Lambda function to apply advanced logic for creating, modifying, or deleting document metadata and content. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html#advanced-data-manipulation">Advanced data manipulation</a>.</p>', 'CustomDocumentEnrichmentConfiguration$PostExtractionHookConfiguration' => '<p>Configuration information for invoking a Lambda function in Lambda on the structured documents with their metadata and text extracted. You can use a Lambda function to apply advanced logic for creating, modifying, or deleting document metadata and content. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html#advanced-data-manipulation">Advanced data manipulation</a>.</p>', ], ], 'Host' => [ 'base' => NULL, 'refs' => [ 'BasicAuthenticationConfiguration$Host' => '<p>The name of the website host you want to connect to using authentication credentials.</p> <p>For example, the host name of https://a.example.com/page1.html is "a.example.com".</p>', 'ProxyConfiguration$Host' => '<p>The name of the website host you want to connect to via a web proxy server.</p> <p>For example, the host name of https://a.example.com/page1.html is "a.example.com".</p>', ], ], 'IdentityAttributeName' => [ 'base' => NULL, 'refs' => [ 'UserIdentityConfiguration$IdentityAttributeName' => '<p>The IAM Identity Center field name that contains the identifiers of your users, such as their emails. This is used for <a href="https://docs.aws.amazon.com/kendra/latest/dg/user-context-filter.html">user context filtering</a> and for granting access to your Amazon Kendra experience. You must set up IAM Identity Center with Amazon Kendra. You must include your users and groups in your Access Control List when you ingest documents into your index. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/getting-started-aws-sso.html">Getting started with an IAM Identity Center identity source</a>.</p>', ], ], 'Importance' => [ 'base' => NULL, 'refs' => [ 'Relevance$Importance' => '<p>The relative importance of the field in the search. Larger numbers provide more of a boost than smaller numbers.</p>', 'ValueImportanceMap$value' => NULL, ], ], 'IndexConfigurationSummary' => [ 'base' => '<p>Summary information on the configuration of an index.</p>', 'refs' => [ 'IndexConfigurationSummaryList$member' => NULL, ], ], 'IndexConfigurationSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListIndicesResponse$IndexConfigurationSummaryItems' => '<p>An array of summary information on the configuration of one or more indexes.</p>', ], ], 'IndexEdition' => [ 'base' => NULL, 'refs' => [ 'CreateIndexRequest$Edition' => '<p>The Amazon Kendra edition to use for the index. Choose <code>DEVELOPER_EDITION</code> for indexes intended for development, testing, or proof of concept. Use <code>ENTERPRISE_EDITION</code> for production. Once you set the edition for an index, it can\'t be changed.</p> <p>The <code>Edition</code> parameter is optional. If you don\'t supply a value, the default is <code>ENTERPRISE_EDITION</code>.</p> <p>For more information on quota limits for Enterprise and Developer editions, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas</a>.</p>', 'DescribeIndexResponse$Edition' => '<p>The Amazon Kendra edition used for the index. You decide the edition when you create the index.</p>', 'IndexConfigurationSummary$Edition' => '<p>Indicates whether the index is a Enterprise Edition index or a Developer Edition index. </p>', ], ], 'IndexFieldName' => [ 'base' => NULL, 'refs' => [ 'ConfluenceAttachmentToIndexFieldMapping$IndexFieldName' => '<p>The name of the index field to map to the Confluence data source field. The index field type must match the Confluence field type.</p>', 'ConfluenceBlogToIndexFieldMapping$IndexFieldName' => '<p>The name of the index field to map to the Confluence data source field. The index field type must match the Confluence field type.</p>', 'ConfluencePageToIndexFieldMapping$IndexFieldName' => '<p>The name of the index field to map to the Confluence data source field. The index field type must match the Confluence field type.</p>', 'ConfluenceSpaceToIndexFieldMapping$IndexFieldName' => '<p>The name of the index field to map to the Confluence data source field. The index field type must match the Confluence field type.</p>', 'DataSourceToIndexFieldMapping$IndexFieldName' => '<p>The name of the index field to map to the data source field. The index field type must match the data source field type.</p>', ], ], 'IndexId' => [ 'base' => NULL, 'refs' => [ 'AssociateEntitiesToExperienceRequest$IndexId' => '<p>The identifier of the index for your Amazon Kendra experience.</p>', 'AssociatePersonasToEntitiesRequest$IndexId' => '<p>The identifier of the index for your Amazon Kendra experience.</p>', 'BatchDeleteDocumentRequest$IndexId' => '<p>The identifier of the index that contains the documents to delete.</p>', 'BatchDeleteFeaturedResultsSetRequest$IndexId' => '<p>The identifier of the index used for featuring results.</p>', 'BatchGetDocumentStatusRequest$IndexId' => '<p>The identifier of the index to add documents to. The index ID is returned by the <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_CreateIndex.html">CreateIndex </a> API.</p>', 'BatchPutDocumentRequest$IndexId' => '<p>The identifier of the index to add the documents to. You need to create the index first using the <code>CreateIndex</code> API.</p>', 'ClearQuerySuggestionsRequest$IndexId' => '<p>The identifier of the index you want to clear query suggestions from.</p>', 'CreateAccessControlConfigurationRequest$IndexId' => '<p>The identifier of the index to create an access control configuration for your documents.</p>', 'CreateDataSourceRequest$IndexId' => '<p>The identifier of the index you want to use with the data source connector.</p>', 'CreateExperienceRequest$IndexId' => '<p>The identifier of the index for your Amazon Kendra experience.</p>', 'CreateFaqRequest$IndexId' => '<p>The identifier of the index for the FAQ.</p>', 'CreateFeaturedResultsSetRequest$IndexId' => '<p>The identifier of the index that you want to use for featuring results.</p>', 'CreateIndexResponse$Id' => '<p>The identifier of the index. Use this identifier when you query an index, set up a data source, or index a document.</p>', 'CreateQuerySuggestionsBlockListRequest$IndexId' => '<p>The identifier of the index you want to create a query suggestions block list for.</p>', 'CreateThesaurusRequest$IndexId' => '<p>The identifier of the index for the thesaurus.</p>', 'DeleteAccessControlConfigurationRequest$IndexId' => '<p>The identifier of the index for an access control configuration.</p>', 'DeleteDataSourceRequest$IndexId' => '<p>The identifier of the index used with the data source connector.</p>', 'DeleteExperienceRequest$IndexId' => '<p>The identifier of the index for your Amazon Kendra experience.</p>', 'DeleteFaqRequest$IndexId' => '<p>The identifier of the index for the FAQ.</p>', 'DeleteIndexRequest$Id' => '<p>The identifier of the index you want to delete.</p>', 'DeletePrincipalMappingRequest$IndexId' => '<p>The identifier of the index you want to delete a group from.</p>', 'DeleteQuerySuggestionsBlockListRequest$IndexId' => '<p>The identifier of the index for the block list.</p>', 'DeleteThesaurusRequest$IndexId' => '<p>The identifier of the index for the thesaurus.</p>', 'DescribeAccessControlConfigurationRequest$IndexId' => '<p>The identifier of the index for an access control configuration.</p>', 'DescribeDataSourceRequest$IndexId' => '<p>The identifier of the index used with the data source connector.</p>', 'DescribeDataSourceResponse$IndexId' => '<p>The identifier of the index used with the data source connector.</p>', 'DescribeExperienceRequest$IndexId' => '<p>The identifier of the index for your Amazon Kendra experience.</p>', 'DescribeExperienceResponse$IndexId' => '<p>Shows the identifier of the index for your Amazon Kendra experience.</p>', 'DescribeFaqRequest$IndexId' => '<p>The identifier of the index for the FAQ.</p>', 'DescribeFaqResponse$IndexId' => '<p>The identifier of the index for the FAQ.</p>', 'DescribeFeaturedResultsSetRequest$IndexId' => '<p>The identifier of the index used for featuring results.</p>', 'DescribeIndexRequest$Id' => '<p>The identifier of the index you want to get information on.</p>', 'DescribeIndexResponse$Id' => '<p>The identifier of the index.</p>', 'DescribePrincipalMappingRequest$IndexId' => '<p>The identifier of the index required to check the processing of <code>PUT</code> and <code>DELETE</code> actions for mapping users to their groups.</p>', 'DescribePrincipalMappingResponse$IndexId' => '<p>Shows the identifier of the index to see information on the processing of <code>PUT</code> and <code>DELETE</code> actions for mapping users to their groups.</p>', 'DescribeQuerySuggestionsBlockListRequest$IndexId' => '<p>The identifier of the index for the block list.</p>', 'DescribeQuerySuggestionsBlockListResponse$IndexId' => '<p>The identifier of the index for the block list.</p>', 'DescribeQuerySuggestionsConfigRequest$IndexId' => '<p>The identifier of the index with query suggestions that you want to get information on.</p>', 'DescribeThesaurusRequest$IndexId' => '<p>The identifier of the index for the thesaurus.</p>', 'DescribeThesaurusResponse$IndexId' => '<p>The identifier of the index for the thesaurus.</p>', 'DisassociateEntitiesFromExperienceRequest$IndexId' => '<p>The identifier of the index for your Amazon Kendra experience.</p>', 'DisassociatePersonasFromEntitiesRequest$IndexId' => '<p>The identifier of the index for your Amazon Kendra experience.</p>', 'GetQuerySuggestionsRequest$IndexId' => '<p>The identifier of the index you want to get query suggestions from.</p>', 'GetSnapshotsRequest$IndexId' => '<p>The identifier of the index to get search metrics data.</p>', 'IndexConfigurationSummary$Id' => '<p>A identifier for the index. Use this to identify the index when you are using APIs such as <code>Query</code>, <code>DescribeIndex</code>, <code>UpdateIndex</code>, and <code>DeleteIndex</code>.</p>', 'ListAccessControlConfigurationsRequest$IndexId' => '<p>The identifier of the index for the access control configuration.</p>', 'ListDataSourceSyncJobsRequest$IndexId' => '<p>The identifier of the index used with the data source connector.</p>', 'ListDataSourcesRequest$IndexId' => '<p>The identifier of the index used with one or more data source connectors.</p>', 'ListEntityPersonasRequest$IndexId' => '<p>The identifier of the index for your Amazon Kendra experience.</p>', 'ListExperienceEntitiesRequest$IndexId' => '<p>The identifier of the index for your Amazon Kendra experience.</p>', 'ListExperiencesRequest$IndexId' => '<p>The identifier of the index for your Amazon Kendra experience.</p>', 'ListFaqsRequest$IndexId' => '<p>The index that contains the FAQ lists.</p>', 'ListFeaturedResultsSetsRequest$IndexId' => '<p>The identifier of the index used for featuring results.</p>', 'ListGroupsOlderThanOrderingIdRequest$IndexId' => '<p>The identifier of the index for getting a list of groups mapped to users before a given ordering or timestamp identifier.</p>', 'ListQuerySuggestionsBlockListsRequest$IndexId' => '<p>The identifier of the index for a list of all block lists that exist for that index.</p> <p>For information on the current quota limits for block lists, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas for Amazon Kendra</a>.</p>', 'ListThesauriRequest$IndexId' => '<p>The identifier of the index with one or more thesauri.</p>', 'PutPrincipalMappingRequest$IndexId' => '<p>The identifier of the index you want to map users to their groups.</p>', 'QueryRequest$IndexId' => '<p>The identifier of the index for the search.</p>', 'RetrieveRequest$IndexId' => '<p>The identifier of the index to retrieve relevant passages for the search.</p>', 'StartDataSourceSyncJobRequest$IndexId' => '<p>The identifier of the index used with the data source connector.</p>', 'StopDataSourceSyncJobRequest$IndexId' => '<p>The identifier of the index used with the data source connector.</p>', 'SubmitFeedbackRequest$IndexId' => '<p>The identifier of the index that was queried.</p>', 'UpdateAccessControlConfigurationRequest$IndexId' => '<p>The identifier of the index for an access control configuration.</p>', 'UpdateDataSourceRequest$IndexId' => '<p>The identifier of the index used with the data source connector.</p>', 'UpdateExperienceRequest$IndexId' => '<p>The identifier of the index for your Amazon Kendra experience.</p>', 'UpdateFeaturedResultsSetRequest$IndexId' => '<p>The identifier of the index used for featuring results.</p>', 'UpdateIndexRequest$Id' => '<p>The identifier of the index you want to update.</p>', 'UpdateQuerySuggestionsBlockListRequest$IndexId' => '<p>The identifier of the index for the block list.</p>', 'UpdateQuerySuggestionsConfigRequest$IndexId' => '<p> The identifier of the index with query suggestions you want to update.</p>', 'UpdateThesaurusRequest$IndexId' => '<p>The identifier of the index for the thesaurus.</p>', ], ], 'IndexName' => [ 'base' => NULL, 'refs' => [ 'CreateIndexRequest$Name' => '<p>A name for the index.</p>', 'DescribeIndexResponse$Name' => '<p>The name of the index.</p>', 'IndexConfigurationSummary$Name' => '<p>The name of the index.</p>', 'UpdateIndexRequest$Name' => '<p>A new name for the index.</p>', ], ], 'IndexStatistics' => [ 'base' => '<p>Provides information about the number of documents and the number of questions and answers in an index.</p>', 'refs' => [ 'DescribeIndexResponse$IndexStatistics' => '<p>Provides information about the number of FAQ questions and answers and the number of text documents indexed.</p>', ], ], 'IndexStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeIndexResponse$Status' => '<p>The current status of the index. When the value is <code>ACTIVE</code>, the index is ready for use. If the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field contains a message that explains why.</p>', 'IndexConfigurationSummary$Status' => '<p>The current status of the index. When the status is <code>ACTIVE</code>, the index is ready to search.</p>', ], ], 'IndexedQuestionAnswersCount' => [ 'base' => NULL, 'refs' => [ 'FaqStatistics$IndexedQuestionAnswersCount' => '<p>The total number of FAQ questions and answers contained in the index.</p>', ], ], 'IndexedTextBytes' => [ 'base' => NULL, 'refs' => [ 'TextDocumentStatistics$IndexedTextBytes' => '<p>The total size, in bytes, of the indexed documents.</p>', ], ], 'IndexedTextDocumentsCount' => [ 'base' => NULL, 'refs' => [ 'TextDocumentStatistics$IndexedTextDocumentsCount' => '<p>The number of text documents indexed.</p>', ], ], 'InlineCustomDocumentEnrichmentConfiguration' => [ 'base' => '<p>Provides the configuration information for applying basic logic to alter document metadata and content when ingesting documents into Amazon Kendra. To apply advanced logic, to go beyond what you can do with basic logic, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_HookConfiguration.html">HookConfiguration</a>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html">Customizing document metadata during the ingestion process</a>.</p>', 'refs' => [ 'InlineCustomDocumentEnrichmentConfigurationList$member' => NULL, ], ], 'InlineCustomDocumentEnrichmentConfigurationList' => [ 'base' => NULL, 'refs' => [ 'CustomDocumentEnrichmentConfiguration$InlineConfigurations' => '<p>Configuration information to alter document attributes or metadata fields and content when ingesting documents into Amazon Kendra.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'Correction$BeginOffset' => '<p>The zero-based location in the response string or text where the corrected word starts.</p>', 'Correction$EndOffset' => '<p>The zero-based location in the response string or text where the corrected word ends.</p>', 'DescribeQuerySuggestionsBlockListResponse$ItemCount' => '<p>The current number of valid, non-empty words or phrases in the block list text file.</p>', 'DescribeQuerySuggestionsConfigResponse$QueryLogLookBackWindowInDays' => '<p>How recent your queries are in your query log time window (in days).</p>', 'DescribeQuerySuggestionsConfigResponse$TotalSuggestionsCount' => '<p>The current total count of query suggestions for an index.</p> <p>This count can change when you update your query suggestions settings, if you filter out certain queries from suggestions using a block list, and as the query log accumulates more queries for Amazon Kendra to learn from.</p> <p>If the count is much lower than you expected, it could be because Amazon Kendra needs more queries in the query history to learn from or your current query suggestions settings are too strict.</p>', 'DocumentAttributeValueCountPair$Count' => '<p>The number of documents in the response that have the attribute/field value for the key.</p>', 'ExpandConfiguration$MaxResultItemsToExpand' => '<p>The number of collapsed search result groups to expand. If you set this value to 10, for example, only the first 10 out of 100 result groups will have expand functionality. </p>', 'ExpandConfiguration$MaxExpandedResultsPerItem' => '<p>The number of expanded results to show per collapsed primary document. For instance, if you set this value to 3, then at most 3 results per collapsed group will be displayed.</p>', 'GetQuerySuggestionsRequest$MaxSuggestionsCount' => '<p>The maximum number of query suggestions you want to show to your users.</p>', 'GetSnapshotsRequest$MaxResults' => '<p>The maximum number of returned data for the metric.</p>', 'Highlight$BeginOffset' => '<p>The zero-based location in the response string where the highlight starts.</p>', 'Highlight$EndOffset' => '<p>The zero-based location in the response string where the highlight ends.</p>', 'QueryRequest$PageNumber' => '<p>Query results are returned in pages the size of the <code>PageSize</code> parameter. By default, Amazon Kendra returns the first page of results. Use this parameter to get result pages after the first one.</p>', 'QueryRequest$PageSize' => '<p>Sets the number of results that are returned in each page of results. The default page size is 10. The maximum number of results returned is 100. If you ask for more than 100 results, only 100 are returned.</p>', 'QueryResult$TotalNumberOfResults' => '<p>The total number of items found by the search. However, you can only retrieve up to 100 items. For example, if the search found 192 items, you can only retrieve the first 100 of the items.</p>', 'QuerySuggestionsBlockListSummary$ItemCount' => '<p>The number of items in the block list file.</p>', 'RetrieveRequest$PageNumber' => '<p>Retrieved relevant passages are returned in pages the size of the <code>PageSize</code> parameter. By default, Amazon Kendra returns the first page of results. Use this parameter to get result pages after the first one.</p>', 'RetrieveRequest$PageSize' => '<p>Sets the number of retrieved relevant passages that are returned in each page of results. The default page size is 10. The maximum number of results returned is 100. If you ask for more than 100 results, only 100 are returned.</p>', 'SuggestionHighlight$BeginOffset' => '<p>The zero-based location in the response string where the highlight starts.</p>', 'SuggestionHighlight$EndOffset' => '<p>The zero-based location in the response string where the highlight ends.</p>', 'TableExcerpt$TotalNumberOfRows' => '<p>A count of the number of rows in the original table within the document.</p>', 'UpdateQuerySuggestionsConfigRequest$QueryLogLookBackWindowInDays' => '<p>How recent your queries are in your query log time window.</p> <p>The time window is the number of days from current day to past days.</p> <p>By default, Amazon Kendra sets this to 180.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>An issue occurred with the internal server used for your Amazon Kendra service. Please wait a few minutes and try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.</p>', 'refs' => [], ], 'Interval' => [ 'base' => NULL, 'refs' => [ 'GetSnapshotsRequest$Interval' => '<p>The time interval or time window to get search metrics data. The time interval uses the time zone of your index. You can view data in the following time windows:</p> <ul> <li> <p> <code>THIS_WEEK</code>: The current week, starting on the Sunday and ending on the day before the current date.</p> </li> <li> <p> <code>ONE_WEEK_AGO</code>: The previous week, starting on the Sunday and ending on the following Saturday.</p> </li> <li> <p> <code>TWO_WEEKS_AGO</code>: The week before the previous week, starting on the Sunday and ending on the following Saturday.</p> </li> <li> <p> <code>THIS_MONTH</code>: The current month, starting on the first day of the month and ending on the day before the current date.</p> </li> <li> <p> <code>ONE_MONTH_AGO</code>: The previous month, starting on the first day of the month and ending on the last day of the month.</p> </li> <li> <p> <code>TWO_MONTHS_AGO</code>: The month before the previous month, starting on the first day of the month and ending on last day of the month.</p> </li> </ul>', ], ], 'InvalidRequestException' => [ 'base' => '<p>The input to the request is not valid. Please provide the correct input and try again.</p>', 'refs' => [], ], 'IssueSubEntity' => [ 'base' => NULL, 'refs' => [ 'IssueSubEntityFilter$member' => NULL, ], ], 'IssueSubEntityFilter' => [ 'base' => NULL, 'refs' => [ 'JiraConfiguration$IssueSubEntityFilter' => '<p>Specify whether to crawl comments, attachments, and work logs. You can specify one or more of these options.</p>', ], ], 'IssueType' => [ 'base' => NULL, 'refs' => [ 'JiraConfiguration$IssueType' => '<p>Specify which issue types to crawl in your Jira data source. You can specify one or more of these options to crawl.</p>', ], ], 'Issuer' => [ 'base' => NULL, 'refs' => [ 'JwtTokenTypeConfiguration$Issuer' => '<p>The issuer of the token.</p>', ], ], 'JiraAccountUrl' => [ 'base' => NULL, 'refs' => [ 'JiraConfiguration$JiraAccountUrl' => '<p>The URL of the Jira account. For example, <i>company.atlassian.net</i>.</p>', ], ], 'JiraConfiguration' => [ 'base' => '<p>Provides the configuration information to connect to Jira as your data source.</p>', 'refs' => [ 'DataSourceConfiguration$JiraConfiguration' => '<p>Provides the configuration information to connect to Jira as your data source.</p>', ], ], 'JiraStatus' => [ 'base' => NULL, 'refs' => [ 'JiraConfiguration$Status' => '<p>Specify which statuses to crawl in your Jira data source. You can specify one or more of these options to crawl.</p>', ], ], 'JsonTokenTypeConfiguration' => [ 'base' => '<p>Provides the configuration information for the JSON token type.</p>', 'refs' => [ 'UserTokenConfiguration$JsonTokenTypeConfiguration' => '<p>Information about the JSON token type configuration.</p>', ], ], 'JwtTokenTypeConfiguration' => [ 'base' => '<p>Provides the configuration information for the JWT token type.</p>', 'refs' => [ 'UserTokenConfiguration$JwtTokenTypeConfiguration' => '<p>Information about the JWT token type configuration.</p>', ], ], 'KeyLocation' => [ 'base' => NULL, 'refs' => [ 'JwtTokenTypeConfiguration$KeyLocation' => '<p>The location of the key.</p>', ], ], 'KmsKeyId' => [ 'base' => NULL, 'refs' => [ 'ServerSideEncryptionConfiguration$KmsKeyId' => '<p>The identifier of the KMS key. Amazon Kendra doesn\'t support asymmetric keys.</p>', ], ], 'LambdaArn' => [ 'base' => NULL, 'refs' => [ 'HookConfiguration$LambdaArn' => '<p>The Amazon Resource Name (ARN) of a role with permission to run a Lambda function during ingestion. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM roles for Amazon Kendra</a>.</p>', ], ], 'LanguageCode' => [ 'base' => '<p>The code for a language. The default language is English. For more information on supported languages, including their codes, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding documents in languages other than English</a>.</p>', 'refs' => [ 'CreateDataSourceRequest$LanguageCode' => '<p>The code for a language. This allows you to support a language for all documents when creating the data source connector. English is supported by default. For more information on supported languages, including their codes, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding documents in languages other than English</a>.</p>', 'CreateFaqRequest$LanguageCode' => '<p>The code for a language. This allows you to support a language for the FAQ document. English is supported by default. For more information on supported languages, including their codes, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding documents in languages other than English</a>.</p>', 'DataSourceSummary$LanguageCode' => '<p>The code for a language. This shows a supported language for all documents in the data source. English is supported by default. For more information on supported languages, including their codes, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding documents in languages other than English</a>.</p>', 'DescribeDataSourceResponse$LanguageCode' => '<p>The code for a language. This shows a supported language for all documents in the data source. English is supported by default. For more information on supported languages, including their codes, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding documents in languages other than English</a>.</p>', 'DescribeFaqResponse$LanguageCode' => '<p>The code for a language. This shows a supported language for the FAQ document. English is supported by default. For more information on supported languages, including their codes, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding documents in languages other than English</a>.</p>', 'FaqSummary$LanguageCode' => '<p>The code for a language. This shows a supported language for the FAQ document as part of the summary information for FAQs. English is supported by default. For more information on supported languages, including their codes, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding documents in languages other than English</a>.</p>', 'UpdateDataSourceRequest$LanguageCode' => '<p>The code for a language you want to update for the data source connector. This allows you to support a language for all documents when updating the data source. English is supported by default. For more information on supported languages, including their codes, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding documents in languages other than English</a>.</p>', ], ], 'ListAccessControlConfigurationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAccessControlConfigurationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDataSourceSyncJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDataSourceSyncJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDataSourcesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDataSourcesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListEntityPersonasRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListEntityPersonasResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListExperienceEntitiesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListExperienceEntitiesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListExperiencesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListExperiencesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFaqsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFaqsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFeaturedResultsSetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFeaturedResultsSetsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListGroupsOlderThanOrderingIdRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListGroupsOlderThanOrderingIdResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListIndicesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListIndicesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListOfGroupSummaries' => [ 'base' => NULL, 'refs' => [ 'ListGroupsOlderThanOrderingIdResponse$GroupsSummaries' => '<p> Summary information for list of groups that are mapped to users before a given ordering or timestamp identifier. </p>', ], ], 'ListQuerySuggestionsBlockListsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListQuerySuggestionsBlockListsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListThesauriRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListThesauriResponse' => [ 'base' => NULL, 'refs' => [], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'DescribeFeaturedResultsSetResponse$LastUpdatedTimestamp' => '<p>The timestamp when the set of featured results was last updated.</p>', 'DescribeFeaturedResultsSetResponse$CreationTimestamp' => '<p>The Unix timestamp when the set of the featured results was created.</p>', 'DescribeQuerySuggestionsBlockListResponse$FileSizeBytes' => '<p>The current size of the block list text file in S3.</p>', 'DescribeThesaurusResponse$FileSizeBytes' => '<p>The size of the thesaurus file in bytes.</p>', 'DescribeThesaurusResponse$TermCount' => '<p>The number of unique terms in the thesaurus file. For example, the synonyms <code>a,b,c</code> and <code>a=&gt;d</code>, the term count would be 4. </p>', 'DescribeThesaurusResponse$SynonymRuleCount' => '<p>The number of synonym rules in the thesaurus file.</p>', 'DocumentAttributeValue$LongValue' => '<p>A long integer value.</p>', 'FeaturedResultsSet$LastUpdatedTimestamp' => '<p>The Unix timestamp when the set of featured results was last updated.</p>', 'FeaturedResultsSet$CreationTimestamp' => '<p>The Unix timestamp when the set of featured results was created.</p>', 'FeaturedResultsSetSummary$LastUpdatedTimestamp' => '<p>The Unix timestamp when the set of featured results was last updated.</p>', 'FeaturedResultsSetSummary$CreationTimestamp' => '<p>The Unix timestamp when the set of featured results was created.</p>', ], ], 'LookBackPeriod' => [ 'base' => NULL, 'refs' => [ 'SlackConfiguration$LookBackPeriod' => '<p>The number of hours for change log to look back from when you last synchronized your data. You can look back up to 7 days or 168 hours.</p> <p>Change log updates your index only if new content was added since you last synced your data. Updated or deleted content from before you last synced does not get updated in your index. To capture updated or deleted content before you last synced, set the <code>LookBackPeriod</code> to the number of hours you want change log to look back.</p>', ], ], 'MaxContentSizePerPageInMegaBytes' => [ 'base' => NULL, 'refs' => [ 'WebCrawlerConfiguration$MaxContentSizePerPageInMegaBytes' => '<p>The maximum size (in MB) of a web page or attachment to crawl.</p> <p>Files larger than this size (in MB) are skipped/not crawled.</p> <p>The default maximum size of a web page or attachment is set to 50 MB.</p>', ], ], 'MaxLinksPerPage' => [ 'base' => NULL, 'refs' => [ 'WebCrawlerConfiguration$MaxLinksPerPage' => '<p>The maximum number of URLs on a web page to include when crawling a website. This number is per web page.</p> <p>As a website’s web pages are crawled, any URLs the web pages link to are also crawled. URLs on a web page are crawled in order of appearance.</p> <p>The default maximum links per page is 100.</p>', ], ], 'MaxResultsIntegerForListAccessControlConfigurationsRequest' => [ 'base' => NULL, 'refs' => [ 'ListAccessControlConfigurationsRequest$MaxResults' => '<p>The maximum number of access control configurations to return.</p>', ], ], 'MaxResultsIntegerForListDataSourceSyncJobsRequest' => [ 'base' => NULL, 'refs' => [ 'ListDataSourceSyncJobsRequest$MaxResults' => '<p>The maximum number of synchronization jobs to return in the response. If there are fewer results in the list, this response contains only the actual results.</p>', ], ], 'MaxResultsIntegerForListDataSourcesRequest' => [ 'base' => NULL, 'refs' => [ 'ListDataSourcesRequest$MaxResults' => '<p>The maximum number of data source connectors to return.</p>', ], ], 'MaxResultsIntegerForListEntityPersonasRequest' => [ 'base' => NULL, 'refs' => [ 'ListEntityPersonasRequest$MaxResults' => '<p>The maximum number of returned users or groups.</p>', ], ], 'MaxResultsIntegerForListExperiencesRequest' => [ 'base' => NULL, 'refs' => [ 'ListExperiencesRequest$MaxResults' => '<p>The maximum number of returned Amazon Kendra experiences.</p>', ], ], 'MaxResultsIntegerForListFaqsRequest' => [ 'base' => NULL, 'refs' => [ 'ListFaqsRequest$MaxResults' => '<p>The maximum number of FAQs to return in the response. If there are fewer results in the list, this response contains only the actual results.</p>', ], ], 'MaxResultsIntegerForListFeaturedResultsSetsRequest' => [ 'base' => NULL, 'refs' => [ 'ListFeaturedResultsSetsRequest$MaxResults' => '<p>The maximum number of featured results sets to return.</p>', ], ], 'MaxResultsIntegerForListIndicesRequest' => [ 'base' => NULL, 'refs' => [ 'ListIndicesRequest$MaxResults' => '<p>The maximum number of indices to return.</p>', ], ], 'MaxResultsIntegerForListPrincipalsRequest' => [ 'base' => NULL, 'refs' => [ 'ListGroupsOlderThanOrderingIdRequest$MaxResults' => '<p> The maximum number of returned groups that are mapped to users before a given ordering or timestamp identifier. </p>', ], ], 'MaxResultsIntegerForListQuerySuggestionsBlockLists' => [ 'base' => NULL, 'refs' => [ 'ListQuerySuggestionsBlockListsRequest$MaxResults' => '<p>The maximum number of block lists to return.</p>', ], ], 'MaxResultsIntegerForListThesauriRequest' => [ 'base' => NULL, 'refs' => [ 'ListThesauriRequest$MaxResults' => '<p>The maximum number of thesauri to return.</p>', ], ], 'MaxUrlsPerMinuteCrawlRate' => [ 'base' => NULL, 'refs' => [ 'WebCrawlerConfiguration$MaxUrlsPerMinuteCrawlRate' => '<p>The maximum number of URLs crawled per website host per minute.</p> <p>A minimum of one URL is required.</p> <p>The default maximum number of URLs crawled per website host per minute is 300.</p>', ], ], 'MemberGroup' => [ 'base' => '<p>The sub groups that belong to a group.</p>', 'refs' => [ 'MemberGroups$member' => NULL, ], ], 'MemberGroups' => [ 'base' => NULL, 'refs' => [ 'GroupMembers$MemberGroups' => '<p>A list of sub groups that belong to a group. For example, the sub groups "Research", "Engineering", and "Sales and Marketing" all belong to the group "Company".</p>', ], ], 'MemberUser' => [ 'base' => '<p>The users that belong to a group.</p>', 'refs' => [ 'MemberUsers$member' => NULL, ], ], 'MemberUsers' => [ 'base' => NULL, 'refs' => [ 'GroupMembers$MemberUsers' => '<p>A list of users that belong to a group. For example, a list of interns all belong to the "Interns" group.</p>', ], ], 'MetricType' => [ 'base' => NULL, 'refs' => [ 'GetSnapshotsRequest$MetricType' => '<p>The metric you want to retrieve. You can specify only one metric per call.</p> <p>For more information about the metrics you can view, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/search-analytics.html">Gaining insights with search analytics</a>.</p>', ], ], 'MetricValue' => [ 'base' => NULL, 'refs' => [ 'DataSourceSyncJobMetrics$DocumentsAdded' => '<p>The number of documents added from the data source up to now in the data source sync.</p>', 'DataSourceSyncJobMetrics$DocumentsModified' => '<p>The number of documents modified in the data source up to now in the data source sync run.</p>', 'DataSourceSyncJobMetrics$DocumentsDeleted' => '<p>The number of documents deleted from the data source up to now in the data source sync run.</p>', 'DataSourceSyncJobMetrics$DocumentsFailed' => '<p>The number of documents that failed to sync from the data source up to now in the data source sync run.</p>', 'DataSourceSyncJobMetrics$DocumentsScanned' => '<p>The current number of documents crawled by the current sync job in the data source.</p>', ], ], 'MimeType' => [ 'base' => NULL, 'refs' => [ 'ExcludeMimeTypesList$member' => NULL, ], ], 'MinimumNumberOfQueryingUsers' => [ 'base' => NULL, 'refs' => [ 'DescribeQuerySuggestionsConfigResponse$MinimumNumberOfQueryingUsers' => '<p>The minimum number of unique users who must search a query in order for the query to be eligible to suggest to your users.</p>', 'UpdateQuerySuggestionsConfigRequest$MinimumNumberOfQueryingUsers' => '<p>The minimum number of unique users who must search a query in order for the query to be eligible to suggest to your users.</p> <p>Increasing this number might decrease the number of suggestions. However, this ensures a query is searched by many users and is truly popular to suggest to users.</p> <p>How you tune this setting depends on your specific needs.</p>', ], ], 'MinimumQueryCount' => [ 'base' => NULL, 'refs' => [ 'DescribeQuerySuggestionsConfigResponse$MinimumQueryCount' => '<p>The minimum number of times a query must be searched in order for the query to be eligible to suggest to your users.</p>', 'UpdateQuerySuggestionsConfigRequest$MinimumQueryCount' => '<p>The the minimum number of times a query must be searched in order to be eligible to suggest to your users.</p> <p>Decreasing this number increases the number of suggestions. However, this affects the quality of suggestions as it sets a low bar for a query to be considered popular to suggest to users.</p> <p>How you tune this setting depends on your specific needs.</p>', ], ], 'MissingAttributeKeyStrategy' => [ 'base' => NULL, 'refs' => [ 'CollapseConfiguration$MissingAttributeKeyStrategy' => '<p>Specifies the behavior for documents without a value for the collapse attribute.</p> <p>Amazon Kendra offers three customization options:</p> <ul> <li> <p>Choose to <code>COLLAPSE</code> all documents with null or missing values in one group. This is the default configuration.</p> </li> <li> <p>Choose to <code>IGNORE</code> documents with null or missing values. Ignored documents will not appear in query results.</p> </li> <li> <p>Choose to <code>EXPAND</code> each document with a null or missing value into a group of its own.</p> </li> </ul>', ], ], 'Mode' => [ 'base' => NULL, 'refs' => [ 'DescribeQuerySuggestionsConfigResponse$Mode' => '<p>Whether query suggestions are currently in <code>ENABLED</code> mode or <code>LEARN_ONLY</code> mode.</p> <p>By default, Amazon Kendra enables query suggestions.<code>LEARN_ONLY</code> turns off query suggestions for your users. You can change the mode using the <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateQuerySuggestionsConfig.html">UpdateQuerySuggestionsConfig</a> API.</p>', 'UpdateQuerySuggestionsConfigRequest$Mode' => '<p>Set the mode to <code>ENABLED</code> or <code>LEARN_ONLY</code>.</p> <p>By default, Amazon Kendra enables query suggestions. <code>LEARN_ONLY</code> mode allows you to turn off query suggestions. You can to update this at any time.</p> <p>In <code>LEARN_ONLY</code> mode, Amazon Kendra continues to learn from new queries to keep suggestions up to date for when you are ready to switch to ENABLED mode again.</p>', ], ], 'NameType' => [ 'base' => NULL, 'refs' => [ 'EntityDisplayData$UserName' => '<p>The name of the user.</p>', 'EntityDisplayData$GroupName' => '<p>The name of the group.</p>', 'EntityDisplayData$IdentifiedUserName' => '<p>The user name of the user.</p>', 'EntityDisplayData$FirstName' => '<p>The first name of the user.</p>', 'EntityDisplayData$LastName' => '<p>The last name of the user.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'GetSnapshotsRequest$NextToken' => '<p>If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of search metrics data.</p>', 'GetSnapshotsResponse$NextToken' => '<p>If the response is truncated, Amazon Kendra returns this token, which you can use in a later request to retrieve the next set of search metrics data.</p>', 'ListDataSourceSyncJobsRequest$NextToken' => '<p>If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of jobs.</p>', 'ListDataSourceSyncJobsResponse$NextToken' => '<p>If the response is truncated, Amazon Kendra returns this token that you can use in the subsequent request to retrieve the next set of jobs.</p>', 'ListDataSourcesRequest$NextToken' => '<p>If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of data source connectors. </p>', 'ListDataSourcesResponse$NextToken' => '<p>If the response is truncated, Amazon Kendra returns this token that you can use in the subsequent request to retrieve the next set of data source connectors.</p>', 'ListEntityPersonasRequest$NextToken' => '<p>If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of users or groups.</p>', 'ListEntityPersonasResponse$NextToken' => '<p>If the response is truncated, Amazon Kendra returns this token, which you can use in a later request to retrieve the next set of users or groups.</p>', 'ListExperienceEntitiesRequest$NextToken' => '<p>If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of users or groups.</p>', 'ListExperienceEntitiesResponse$NextToken' => '<p>If the response is truncated, Amazon Kendra returns this token, which you can use in a later request to retrieve the next set of users or groups.</p>', 'ListExperiencesRequest$NextToken' => '<p>If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of Amazon Kendra experiences.</p>', 'ListExperiencesResponse$NextToken' => '<p>If the response is truncated, Amazon Kendra returns this token, which you can use in a later request to retrieve the next set of Amazon Kendra experiences.</p>', 'ListFaqsRequest$NextToken' => '<p>If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of FAQs.</p>', 'ListFaqsResponse$NextToken' => '<p>If the response is truncated, Amazon Kendra returns this token that you can use in the subsequent request to retrieve the next set of FAQs.</p>', 'ListFeaturedResultsSetsRequest$NextToken' => '<p>If the response is truncated, Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of featured results sets.</p>', 'ListFeaturedResultsSetsResponse$NextToken' => '<p>If the response is truncated, Amazon Kendra returns a pagination token in the response.</p>', 'ListGroupsOlderThanOrderingIdRequest$NextToken' => '<p> If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of groups that are mapped to users before a given ordering or timestamp identifier. </p>', 'ListGroupsOlderThanOrderingIdResponse$NextToken' => '<p> If the response is truncated, Amazon Kendra returns this token that you can use in the subsequent request to retrieve the next set of groups that are mapped to users before a given ordering or timestamp identifier. </p>', 'ListIndicesRequest$NextToken' => '<p>If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of indexes. </p>', 'ListIndicesResponse$NextToken' => '<p>If the response is truncated, Amazon Kendra returns this token that you can use in the subsequent request to retrieve the next set of indexes.</p>', 'ListQuerySuggestionsBlockListsRequest$NextToken' => '<p>If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of block lists (<code>BlockListSummaryItems</code>).</p>', 'ListQuerySuggestionsBlockListsResponse$NextToken' => '<p>If the response is truncated, Amazon Kendra returns this token that you can use in the subsequent request to retrieve the next set of block lists.</p>', 'ListThesauriRequest$NextToken' => '<p>If the previous response was incomplete (because there is more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of thesauri (<code>ThesaurusSummaryItems</code>). </p>', 'ListThesauriResponse$NextToken' => '<p>If the response is truncated, Amazon Kendra returns this token that you can use in the subsequent request to retrieve the next set of thesauri. </p>', ], ], 'ObjectBoolean' => [ 'base' => NULL, 'refs' => [ 'DescribeQuerySuggestionsConfigResponse$IncludeQueriesWithoutUserInformation' => '<p> <code>TRUE</code> to use all queries, otherwise use only queries that include user information to generate the query suggestions.</p>', 'SuggestableConfig$Suggestable' => '<p> <code>TRUE</code> means the document field/attribute is suggestible, so the contents within the field can be used for query suggestions.</p>', 'UpdateQuerySuggestionsConfigRequest$IncludeQueriesWithoutUserInformation' => '<p> <code>TRUE</code> to include queries without user information (i.e. all queries, irrespective of the user), otherwise <code>FALSE</code> to only include queries with user information.</p> <p>If you pass user information to Amazon Kendra along with the queries, you can set this flag to <code>FALSE</code> and instruct Amazon Kendra to only consider queries with user information.</p> <p>If you set to <code>FALSE</code>, Amazon Kendra only considers queries searched at least <code>MinimumQueryCount</code> times across <code>MinimumNumberOfQueryingUsers</code> unique users for suggestions.</p> <p>If you set to <code>TRUE</code>, Amazon Kendra ignores all user information and learns from all queries.</p>', ], ], 'OnPremiseConfiguration' => [ 'base' => '<p>Provides the configuration information to connect to GitHub Enterprise Server (on premises).</p>', 'refs' => [ 'GitHubConfiguration$OnPremiseConfiguration' => '<p>Configuration information to connect to GitHub Enterprise Server (on premises).</p>', ], ], 'OneDriveConfiguration' => [ 'base' => '<p>Provides the configuration information to connect to OneDrive as your data source.</p>', 'refs' => [ 'DataSourceConfiguration$OneDriveConfiguration' => '<p>Provides the configuration information to connect to Microsoft OneDrive as your data source.</p>', ], ], 'OneDriveUser' => [ 'base' => NULL, 'refs' => [ 'OneDriveUserList$member' => NULL, ], ], 'OneDriveUserList' => [ 'base' => NULL, 'refs' => [ 'OneDriveUsers$OneDriveUserList' => '<p>A list of users whose documents should be indexed. Specify the user names in email format, for example, <code>username@tenantdomain</code>. If you need to index the documents of more than 100 users, use the <code>OneDriveUserS3Path</code> field to specify the location of a file containing a list of users.</p>', ], ], 'OneDriveUsers' => [ 'base' => '<p>User accounts whose documents should be indexed.</p>', 'refs' => [ 'OneDriveConfiguration$OneDriveUsers' => '<p>A list of user accounts whose documents should be indexed.</p>', ], ], 'Order' => [ 'base' => NULL, 'refs' => [ 'Relevance$RankOrder' => '<p>Determines how values should be interpreted.</p> <p>When the <code>RankOrder</code> field is <code>ASCENDING</code>, higher numbers are better. For example, a document with a rating score of 10 is higher ranking than a document with a rating score of 1.</p> <p>When the <code>RankOrder</code> field is <code>DESCENDING</code>, lower numbers are better. For example, in a task tracking application, a priority 1 task is more important than a priority 5 task.</p> <p>Only applies to <code>LONG</code> fields.</p>', ], ], 'OrganizationId' => [ 'base' => NULL, 'refs' => [ 'WorkDocsConfiguration$OrganizationId' => '<p>The identifier of the directory corresponding to your Amazon WorkDocs site repository.</p> <p>You can find the organization ID in the <a href="https://console.aws.amazon.com/directoryservicev2/">Directory Service</a> by going to <b>Active Directory</b>, then <b>Directories</b>. Your Amazon WorkDocs site directory has an ID, which is the organization ID. You can also set up a new Amazon WorkDocs directory in the Directory Service console and enable a Amazon WorkDocs site for the directory in the Amazon WorkDocs console.</p>', ], ], 'OrganizationName' => [ 'base' => NULL, 'refs' => [ 'OnPremiseConfiguration$OrganizationName' => '<p>The name of the organization of the GitHub Enterprise Server (on-premises) account you want to connect to. You can find your organization name by logging into GitHub desktop and selecting <b>Your organizations</b> under your profile picture dropdown.</p>', 'SaaSConfiguration$OrganizationName' => '<p>The name of the organization of the GitHub Enterprise Cloud (SaaS) account you want to connect to. You can find your organization name by logging into GitHub desktop and selecting <b>Your organizations</b> under your profile picture dropdown.</p>', ], ], 'Persona' => [ 'base' => NULL, 'refs' => [ 'EntityPersonaConfiguration$Persona' => '<p>The persona that defines the specific permissions of the user or group in your IAM Identity Center identity source. The available personas or access roles are <code>Owner</code> and <code>Viewer</code>. For more information on these personas, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html#access-search-experience">Providing access to your search page</a>.</p>', 'PersonasSummary$Persona' => '<p>The persona that defines the specific permissions of the user or group in your IAM Identity Center identity source. The available personas or access roles are <code>Owner</code> and <code>Viewer</code>. For more information on these personas, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html#access-search-experience">Providing access to your search page</a>.</p>', ], ], 'PersonasSummary' => [ 'base' => '<p>Summary information for users or groups in your IAM Identity Center identity source. This applies to users and groups with specific permissions that define their level of access to your Amazon Kendra experience. You can create an Amazon Kendra experience such as a search application. For more information on creating a search application experience, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search experience with no code</a>.</p>', 'refs' => [ 'PersonasSummaryList$member' => NULL, ], ], 'PersonasSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListEntityPersonasResponse$SummaryItems' => '<p>An array of summary information for one or more users or groups.</p>', ], ], 'Port' => [ 'base' => NULL, 'refs' => [ 'BasicAuthenticationConfiguration$Port' => '<p>The port number of the website host you want to connect to using authentication credentials.</p> <p>For example, the port for https://a.example.com/page1.html is 443, the standard port for HTTPS.</p>', 'ProxyConfiguration$Port' => '<p>The port number of the website host you want to connect to via a web proxy server. </p> <p>For example, the port for https://a.example.com/page1.html is 443, the standard port for HTTPS.</p>', ], ], 'Principal' => [ 'base' => '<p>Provides user and group information for <a href="https://docs.aws.amazon.com/kendra/latest/dg/user-context-filter.html">user context filtering</a>.</p>', 'refs' => [ 'PrincipalList$member' => NULL, ], ], 'PrincipalList' => [ 'base' => NULL, 'refs' => [ 'CreateAccessControlConfigurationRequest$AccessControlList' => '<p>Information on principals (users and/or groups) and which documents they should have access to. This is useful for user context filtering, where search results are filtered based on the user or their group access to documents.</p>', 'DescribeAccessControlConfigurationResponse$AccessControlList' => '<p>Information on principals (users and/or groups) and which documents they should have access to. This is useful for user context filtering, where search results are filtered based on the user or their group access to documents.</p>', 'Document$AccessControlList' => '<p>Information on principals (users and/or groups) and which documents they should have access to. This is useful for user context filtering, where search results are filtered based on the user or their group access to documents.</p>', 'HierarchicalPrincipal$PrincipalList' => '<p>A list of <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_Principal.html">principal</a> lists that define the hierarchy for which documents users should have access to. Each hierarchical list specifies which user or group has allow or deny access for each document.</p>', 'UpdateAccessControlConfigurationRequest$AccessControlList' => '<p>Information you want to update on principals (users and/or groups) and which documents they should have access to. This is useful for user context filtering, where search results are filtered based on the user or their group access to documents.</p>', ], ], 'PrincipalMappingStatus' => [ 'base' => NULL, 'refs' => [ 'GroupOrderingIdSummary$Status' => '<p>The current processing status of actions for mapping users to their groups. The status can be either <code>PROCESSING</code>, <code>SUCCEEDED</code>, <code>DELETING</code>, <code>DELETED</code>, or <code>FAILED</code>.</p>', ], ], 'PrincipalName' => [ 'base' => NULL, 'refs' => [ 'DataSourceGroup$GroupId' => '<p>The identifier of the group you want to add to your list of groups. This is for filtering search results based on the groups\' access to documents.</p>', 'Groups$member' => NULL, 'Principal$Name' => '<p>The name of the user or group.</p>', 'UserContext$UserId' => '<p>The identifier of the user you want to filter search results based on their access to documents.</p>', ], ], 'PrincipalOrderingId' => [ 'base' => NULL, 'refs' => [ 'DeletePrincipalMappingRequest$OrderingId' => '<p>The timestamp identifier you specify to ensure Amazon Kendra does not override the latest <code>DELETE</code> action with previous actions. The highest number ID, which is the ordering ID, is the latest action you want to process and apply on top of other actions with lower number IDs. This prevents previous actions with lower number IDs from possibly overriding the latest action.</p> <p>The ordering ID can be the Unix time of the last update you made to a group members list. You would then provide this list when calling <code>PutPrincipalMapping</code>. This ensures your <code>DELETE</code> action for that updated group with the latest members list doesn\'t get overwritten by earlier <code>DELETE</code> actions for the same group which are yet to be processed.</p> <p>The default ordering ID is the current Unix time in milliseconds that the action was received by Amazon Kendra. </p>', 'GroupOrderingIdSummary$OrderingId' => '<p>The order in which actions should complete processing. An action can be a <code>PUT</code> or <code>DELETE</code> action for mapping users to their groups.</p>', 'GroupSummary$OrderingId' => '<p>The timestamp identifier used for the latest <code>PUT</code> or <code>DELETE</code> action.</p>', 'ListGroupsOlderThanOrderingIdRequest$OrderingId' => '<p>The timestamp identifier used for the latest <code>PUT</code> or <code>DELETE</code> action for mapping users to their groups.</p>', 'PutPrincipalMappingRequest$OrderingId' => '<p>The timestamp identifier you specify to ensure Amazon Kendra does not override the latest <code>PUT</code> action with previous actions. The highest number ID, which is the ordering ID, is the latest action you want to process and apply on top of other actions with lower number IDs. This prevents previous actions with lower number IDs from possibly overriding the latest action.</p> <p>The ordering ID can be the Unix time of the last update you made to a group members list. You would then provide this list when calling <code>PutPrincipalMapping</code>. This ensures your <code>PUT</code> action for that updated group with the latest members list doesn\'t get overwritten by earlier <code>PUT</code> actions for the same group which are yet to be processed.</p> <p>The default ordering ID is the current Unix time in milliseconds that the action was received by Amazon Kendra.</p>', ], ], 'PrincipalType' => [ 'base' => NULL, 'refs' => [ 'Principal$Type' => '<p>The type of principal.</p>', ], ], 'PrivateChannelFilter' => [ 'base' => NULL, 'refs' => [ 'SlackConfiguration$PrivateChannelFilter' => '<p>The list of private channel names from your Slack workspace team. You use this if you want to index specific private channels, not all private channels. You can also use regular expression patterns to filter private channels.</p>', ], ], 'Project' => [ 'base' => NULL, 'refs' => [ 'JiraConfiguration$Project' => '<p>Specify which projects to crawl in your Jira data source. You can specify one or more Jira project IDs.</p>', ], ], 'ProxyConfiguration' => [ 'base' => '<p>Provides the configuration information for a web proxy to connect to website hosts.</p>', 'refs' => [ 'ConfluenceConfiguration$ProxyConfiguration' => '<p>Configuration information to connect to your Confluence URL instance via a web proxy. You can use this option for Confluence Server.</p> <p>You must provide the website host name and port number. For example, the host name of <i>https://a.example.com/page1.html</i> is "a.example.com" and the port is 443, the standard port for HTTPS.</p> <p>Web proxy credentials are optional and you can use them to connect to a web proxy server that requires basic authentication of user name and password. To store web proxy credentials, you use a secret in Secrets Manager.</p> <p>It is recommended that you follow best security practices when configuring your web proxy. This includes setting up throttling, setting up logging and monitoring, and applying security patches on a regular basis. If you use your web proxy with multiple data sources, sync jobs that occur at the same time could strain the load on your proxy. It is recommended you prepare your proxy beforehand for any security and load requirements.</p>', 'SharePointConfiguration$ProxyConfiguration' => '<p>Configuration information to connect to your Microsoft SharePoint site URLs via instance via a web proxy. You can use this option for SharePoint Server.</p> <p>You must provide the website host name and port number. For example, the host name of <i>https://a.example.com/page1.html</i> is "a.example.com" and the port is 443, the standard port for HTTPS.</p> <p>Web proxy credentials are optional and you can use them to connect to a web proxy server that requires basic authentication of user name and password. To store web proxy credentials, you use a secret in Secrets Manager.</p> <p>It is recommended that you follow best security practices when configuring your web proxy. This includes setting up throttling, setting up logging and monitoring, and applying security patches on a regular basis. If you use your web proxy with multiple data sources, sync jobs that occur at the same time could strain the load on your proxy. It is recommended you prepare your proxy beforehand for any security and load requirements.</p>', 'WebCrawlerConfiguration$ProxyConfiguration' => '<p>Configuration information required to connect to your internal websites via a web proxy.</p> <p>You must provide the website host name and port number. For example, the host name of https://a.example.com/page1.html is "a.example.com" and the port is 443, the standard port for HTTPS.</p> <p>Web proxy credentials are optional and you can use them to connect to a web proxy server that requires basic authentication. To store web proxy credentials, you use a secret in <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html">Secrets Manager</a>.</p>', ], ], 'PublicChannelFilter' => [ 'base' => NULL, 'refs' => [ 'SlackConfiguration$PublicChannelFilter' => '<p>The list of public channel names to index from your Slack workspace team. You use this if you want to index specific public channels, not all public channels. You can also use regular expression patterns to filter public channels.</p>', ], ], 'PutPrincipalMappingRequest' => [ 'base' => NULL, 'refs' => [], ], 'QueryCapacityUnit' => [ 'base' => NULL, 'refs' => [ 'CapacityUnitsConfiguration$QueryCapacityUnits' => '<p>The amount of extra query capacity for an index and <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_GetQuerySuggestions.html">GetQuerySuggestions</a> capacity.</p> <p>A single extra capacity unit for an index provides 0.1 queries per second or approximately 8,000 queries per day. You can add up to 100 extra capacity units.</p> <p> <code>GetQuerySuggestions</code> capacity is five times the provisioned query capacity for an index, or the base capacity of 2.5 calls per second, whichever is higher. For example, the base capacity for an index is 0.1 queries per second, and <code>GetQuerySuggestions</code> capacity has a base of 2.5 calls per second. If you add another 0.1 queries per second to total 0.2 queries per second for an index, the <code>GetQuerySuggestions</code> capacity is 2.5 calls per second (higher than five times 0.2 queries per second).</p>', ], ], 'QueryId' => [ 'base' => NULL, 'refs' => [ 'QueryResult$QueryId' => '<p>The identifier for the search. You also use <code>QueryId</code> to identify the search when using the <a href="https://docs.aws.amazon.com/kendra/latest/APIReference/API_SubmitFeedback.html">SubmitFeedback</a> API.</p>', 'RetrieveResult$QueryId' => '<p>The identifier of query used for the search. You also use <code>QueryId</code> to identify the search when using the <a href="https://docs.aws.amazon.com/kendra/latest/APIReference/API_SubmitFeedback.html">Submitfeedback</a> API.</p>', 'SubmitFeedbackRequest$QueryId' => '<p>The identifier of the specific query for which you are submitting feedback. The query ID is returned in the response to the <code>Query</code> API.</p>', ], ], 'QueryIdentifiersEnclosingOption' => [ 'base' => NULL, 'refs' => [ 'SqlConfiguration$QueryIdentifiersEnclosingOption' => '<p>Determines whether Amazon Kendra encloses SQL identifiers for tables and column names in double quotes (") when making a database query.</p> <p>By default, Amazon Kendra passes SQL identifiers the way that they are entered into the data source configuration. It does not change the case of identifiers or enclose them in quotes.</p> <p>PostgreSQL internally converts uppercase characters to lower case characters in identifiers unless they are quoted. Choosing this option encloses identifiers in quotes so that PostgreSQL does not convert the character\'s case.</p> <p>For MySQL databases, you must enable the <code>ansi_quotes</code> option when you set this field to <code>DOUBLE_QUOTES</code>.</p>', ], ], 'QueryRequest' => [ 'base' => NULL, 'refs' => [], ], 'QueryResult' => [ 'base' => NULL, 'refs' => [], ], 'QueryResultFormat' => [ 'base' => NULL, 'refs' => [ 'QueryResultItem$Format' => '<p>If the <code>Type</code> of document within the response is <code>ANSWER</code>, then it is either a <code>TABLE</code> answer or <code>TEXT</code> answer. If it\'s a table answer, a table excerpt is returned in <code>TableExcerpt</code>. If it\'s a text answer, a text excerpt is returned in <code>DocumentExcerpt</code>.</p>', ], ], 'QueryResultItem' => [ 'base' => '<p>A single query result.</p> <p>A query result contains information about a document returned by the query. This includes the original location of the document, a list of attributes assigned to the document, and relevant text from the document that satisfies the query.</p>', 'refs' => [ 'QueryResultItemList$member' => NULL, ], ], 'QueryResultItemList' => [ 'base' => NULL, 'refs' => [ 'QueryResult$ResultItems' => '<p>The results of the search.</p>', ], ], 'QueryResultType' => [ 'base' => NULL, 'refs' => [ 'FeaturedResultsItem$Type' => '<p>The type of document within the featured result response. For example, a response could include a question-answer type that\'s relevant to the query.</p>', 'QueryRequest$QueryResultTypeFilter' => '<p>Sets the type of query result or response. Only results for the specified type are returned.</p>', 'QueryResultItem$Type' => '<p>The type of document within the response. For example, a response could include a question-answer that\'s relevant to the query.</p>', ], ], 'QuerySuggestionsBlockListId' => [ 'base' => NULL, 'refs' => [ 'CreateQuerySuggestionsBlockListResponse$Id' => '<p>The identifier of the block list.</p>', 'DeleteQuerySuggestionsBlockListRequest$Id' => '<p>The identifier of the block list you want to delete.</p>', 'DescribeQuerySuggestionsBlockListRequest$Id' => '<p>The identifier of the block list you want to get information on.</p>', 'DescribeQuerySuggestionsBlockListResponse$Id' => '<p>The identifier of the block list.</p>', 'QuerySuggestionsBlockListSummary$Id' => '<p>The identifier of a block list.</p>', 'UpdateQuerySuggestionsBlockListRequest$Id' => '<p>The identifier of the block list you want to update.</p>', ], ], 'QuerySuggestionsBlockListName' => [ 'base' => NULL, 'refs' => [ 'CreateQuerySuggestionsBlockListRequest$Name' => '<p>A name for the block list.</p> <p>For example, the name \'offensive-words\', which includes all offensive words that could appear in user queries and need to be blocked from suggestions.</p>', 'DescribeQuerySuggestionsBlockListResponse$Name' => '<p>The name of the block list.</p>', 'QuerySuggestionsBlockListSummary$Name' => '<p>The name of the block list.</p>', 'UpdateQuerySuggestionsBlockListRequest$Name' => '<p>A new name for the block list.</p>', ], ], 'QuerySuggestionsBlockListStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeQuerySuggestionsBlockListResponse$Status' => '<p>The current status of the block list. When the value is <code>ACTIVE</code>, the block list is ready for use.</p>', 'QuerySuggestionsBlockListSummary$Status' => '<p>The status of the block list.</p>', ], ], 'QuerySuggestionsBlockListSummary' => [ 'base' => '<p>Summary information on a query suggestions block list.</p> <p>This includes information on the block list ID, block list name, when the block list was created, when the block list was last updated, and the count of block words/phrases in the block list.</p> <p>For information on the current quota limits for block lists, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas for Amazon Kendra</a>.</p>', 'refs' => [ 'QuerySuggestionsBlockListSummaryItems$member' => NULL, ], ], 'QuerySuggestionsBlockListSummaryItems' => [ 'base' => NULL, 'refs' => [ 'ListQuerySuggestionsBlockListsResponse$BlockListSummaryItems' => '<p>Summary items for a block list.</p> <p>This includes summary items on the block list ID, block list name, when the block list was created, when the block list was last updated, and the count of block words/phrases in the block list.</p> <p>For information on the current quota limits for block lists, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas for Amazon Kendra</a>.</p>', ], ], 'QuerySuggestionsId' => [ 'base' => NULL, 'refs' => [ 'GetQuerySuggestionsResponse$QuerySuggestionsId' => '<p>The identifier for a list of query suggestions for an index.</p>', ], ], 'QuerySuggestionsStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeQuerySuggestionsConfigResponse$Status' => '<p>Whether the status of query suggestions settings is currently <code>ACTIVE</code> or <code>UPDATING</code>.</p> <p>Active means the current settings apply and Updating means your changed settings are in the process of applying.</p>', ], ], 'QueryText' => [ 'base' => NULL, 'refs' => [ 'ConflictingItem$QueryText' => '<p>The text of the conflicting query.</p>', 'QueryRequest$QueryText' => '<p>The input query text for the search. Amazon Kendra truncates queries at 30 token words, which excludes punctuation and stop words. Truncation still applies if you use Boolean or more advanced, complex queries. For example, <code>Timeoff AND October AND Category:HR</code> is counted as 3 tokens: <code>timeoff</code>, <code>october</code>, <code>hr</code>. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/searching-example.html#searching-index-query-syntax">Searching with advanced query syntax</a> in the Amazon Kendra Developer Guide. </p>', 'QueryTextList$member' => NULL, 'RetrieveRequest$QueryText' => '<p>The input query text to retrieve relevant passages for the search. Amazon Kendra truncates queries at 30 token words, which excludes punctuation and stop words. Truncation still applies if you use Boolean or more advanced, complex queries. For example, <code>Timeoff AND October AND Category:HR</code> is counted as 3 tokens: <code>timeoff</code>, <code>october</code>, <code>hr</code>. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/searching-example.html#searching-index-query-syntax">Searching with advanced query syntax</a> in the Amazon Kendra Developer Guide. </p>', ], ], 'QueryTextList' => [ 'base' => NULL, 'refs' => [ 'CreateFeaturedResultsSetRequest$QueryTexts' => '<p>A list of queries for featuring results. For more information on the list of queries, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_FeaturedResultsSet.html">FeaturedResultsSet</a>.</p>', 'DescribeFeaturedResultsSetResponse$QueryTexts' => '<p>The list of queries for featuring results. For more information on the list of queries, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_FeaturedResultsSet.html">FeaturedResultsSet</a>.</p>', 'FeaturedResultsSet$QueryTexts' => '<p>The list of queries for featuring results.</p> <p>Specific queries are mapped to specific documents for featuring in the results. If a query contains an exact match, then one or more specific documents are featured in the results. The exact match applies to the full query. For example, if you only specify \'Kendra\', queries such as \'How does kendra semantically rank results?\' will not render the featured results. Featured results are designed for specific queries, rather than queries that are too broad in scope.</p>', 'UpdateFeaturedResultsSetRequest$QueryTexts' => '<p>A list of queries for featuring results. For more information on the list of queries, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_FeaturedResultsSet.html">FeaturedResultsSet</a>.</p>', ], ], 'QuipConfiguration' => [ 'base' => '<p>Provides the configuration information to connect to Quip as your data source.</p>', 'refs' => [ 'DataSourceConfiguration$QuipConfiguration' => '<p>Provides the configuration information to connect to Quip as your data source.</p>', ], ], 'ReadAccessType' => [ 'base' => NULL, 'refs' => [ 'Principal$Access' => '<p>Whether to allow or deny document access to the principal.</p>', ], ], 'Relevance' => [ 'base' => '<p>Provides information for tuning the relevance of a field in a search. When a query includes terms that match the field, the results are given a boost in the response based on these tuning parameters.</p>', 'refs' => [ 'DocumentMetadataConfiguration$Relevance' => '<p>Provides tuning parameters to determine how the field affects the search results.</p>', 'DocumentRelevanceConfiguration$Relevance' => '<p>Provides information for tuning the relevance of a field in a search. When a query includes terms that match the field, the results are given a boost in the response based on these tuning parameters.</p>', ], ], 'RelevanceFeedback' => [ 'base' => '<p>Provides feedback on how relevant a document is to a search. Your application uses the <code>SubmitFeedback</code> API to provide relevance information.</p>', 'refs' => [ 'RelevanceFeedbackList$member' => NULL, ], ], 'RelevanceFeedbackList' => [ 'base' => NULL, 'refs' => [ 'SubmitFeedbackRequest$RelevanceFeedbackItems' => '<p>Provides Amazon Kendra with relevant or not relevant feedback for whether a particular item was relevant to the search.</p>', ], ], 'RelevanceType' => [ 'base' => NULL, 'refs' => [ 'RelevanceFeedback$RelevanceValue' => '<p>Whether the document was relevant or not relevant to the search.</p>', ], ], 'RepositoryName' => [ 'base' => NULL, 'refs' => [ 'RepositoryNames$member' => NULL, ], ], 'RepositoryNames' => [ 'base' => NULL, 'refs' => [ 'GitHubConfiguration$RepositoryFilter' => '<p>A list of names of the specific repositories you want to index.</p>', ], ], 'ResourceAlreadyExistException' => [ 'base' => '<p>The resource you want to use already exists. Please check you have provided the correct resource and try again.</p>', 'refs' => [], ], 'ResourceInUseException' => [ 'base' => '<p>The resource you want to use is currently in use. Please check you have provided the correct resource and try again.</p>', 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>The resource you want to use doesn’t exist. Please check you have provided the correct resource and try again.</p>', 'refs' => [], ], 'ResourceUnavailableException' => [ 'base' => '<p>The resource you want to use isn\'t available. Please check you have provided the correct resource and try again.</p>', 'refs' => [], ], 'ResultId' => [ 'base' => NULL, 'refs' => [ 'ClickFeedback$ResultId' => '<p>The identifier of the search result that was clicked.</p>', 'ExpandedResultItem$Id' => '<p>The identifier for the expanded result.</p>', 'FeaturedResultsItem$Id' => '<p>The identifier of the featured result.</p>', 'QueryResultItem$Id' => '<p>The unique identifier for the query result item id (<code>Id</code>) and the query result item document id (<code>DocumentId</code>) combined. The value of this field changes with every request, even when you have the same documents.</p>', 'RelevanceFeedback$ResultId' => '<p>The identifier of the search result that the user provided relevance feedback for.</p>', 'RetrieveResultItem$Id' => '<p>The identifier of the relevant passage result.</p>', 'Suggestion$Id' => '<p>The UUID (universally unique identifier) of a single query suggestion.</p>', ], ], 'RetrieveRequest' => [ 'base' => NULL, 'refs' => [], ], 'RetrieveResult' => [ 'base' => NULL, 'refs' => [], ], 'RetrieveResultItem' => [ 'base' => '<p>A single retrieved relevant passage result.</p>', 'refs' => [ 'RetrieveResultItemList$member' => NULL, ], ], 'RetrieveResultItemList' => [ 'base' => NULL, 'refs' => [ 'RetrieveResult$ResultItems' => '<p>The results of the retrieved relevant passages for the search.</p>', ], ], 'RoleArn' => [ 'base' => NULL, 'refs' => [ 'BatchPutDocumentRequest$RoleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role with permission to access your S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM access roles for Amazon Kendra</a>.</p>', 'CreateDataSourceRequest$RoleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role with permission to access the data source and required resources. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM access roles for Amazon Kendra.</a>.</p> <p>You can\'t specify the <code>RoleArn</code> parameter when the <code>Type</code> parameter is set to <code>CUSTOM</code>. If you do, you receive a <code>ValidationException</code> exception.</p> <p>The <code>RoleArn</code> parameter is required for all other data sources.</p>', 'CreateExperienceRequest$RoleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role with permission to access <code>Query</code> API, <code>GetQuerySuggestions</code> API, and other required APIs. The role also must include permission to access IAM Identity Center that stores your user and group information. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM access roles for Amazon Kendra</a>.</p>', 'CreateFaqRequest$RoleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role with permission to access the S3 bucket that contains the FAQs. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM access roles for Amazon Kendra</a>.</p>', 'CreateIndexRequest$RoleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role with permission to access your Amazon CloudWatch logs and metrics. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM access roles for Amazon Kendra</a>.</p>', 'CreateQuerySuggestionsBlockListRequest$RoleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role with permission to access your S3 bucket that contains the block list text file. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM access roles for Amazon Kendra</a>.</p>', 'CreateThesaurusRequest$RoleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role with permission to access your S3 bucket that contains the thesaurus file. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM access roles for Amazon Kendra</a>.</p>', 'CustomDocumentEnrichmentConfiguration$RoleArn' => '<p>The Amazon Resource Name (ARN) of a role with permission to run <code>PreExtractionHookConfiguration</code> and <code>PostExtractionHookConfiguration</code> for altering document metadata and content during the document ingestion process. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM roles for Amazon Kendra</a>.</p>', 'DescribeDataSourceResponse$RoleArn' => '<p>The Amazon Resource Name (ARN) of the role with permission to access the data source and required resources.</p>', 'DescribeExperienceResponse$RoleArn' => '<p>Shows the Amazon Resource Name (ARN) of a role with permission to access <code>Query</code> API, <code>QuerySuggestions</code> API, <code>SubmitFeedback</code> API, and IAM Identity Center that stores your user and group information.</p>', 'DescribeFaqResponse$RoleArn' => '<p>The Amazon Resource Name (ARN) of the role that provides access to the S3 bucket containing the input files for the FAQ.</p>', 'DescribeIndexResponse$RoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that gives Amazon Kendra permission to write to your Amazon CloudWatch logs.</p>', 'DescribeQuerySuggestionsBlockListResponse$RoleArn' => '<p>The IAM (Identity and Access Management) role used by Amazon Kendra to access the block list text file in S3.</p> <p>The role needs S3 read permissions to your file in S3 and needs to give STS (Security Token Service) assume role permissions to Amazon Kendra.</p>', 'DescribeThesaurusResponse$RoleArn' => '<p>An IAM role that gives Amazon Kendra permissions to access thesaurus file specified in <code>SourceS3Path</code>. </p>', 'JwtTokenTypeConfiguration$SecretManagerArn' => '<p>The Amazon Resource Name (arn) of the secret.</p>', 'PutPrincipalMappingRequest$RoleArn' => '<p>The Amazon Resource Name (ARN) of a role that has access to the S3 file that contains your list of users or sub groups that belong to a group.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html#iam-roles-ds">IAM roles for Amazon Kendra</a>.</p>', 'UpdateDataSourceRequest$RoleArn' => '<p>The Amazon Resource Name (ARN) of a role with permission to access the data source and required resources. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM roles for Amazon Kendra</a>.</p>', 'UpdateExperienceRequest$RoleArn' => '<p>The Amazon Resource Name (ARN) of a role with permission to access <code>Query</code> API, <code>QuerySuggestions</code> API, <code>SubmitFeedback</code> API, and IAM Identity Center that stores your user and group information. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM roles for Amazon Kendra</a>.</p>', 'UpdateIndexRequest$RoleArn' => '<p>An Identity and Access Management (IAM) role that gives Amazon Kendra permission to access Amazon CloudWatch logs and metrics.</p>', 'UpdateQuerySuggestionsBlockListRequest$RoleArn' => '<p>The IAM (Identity and Access Management) role used to access the block list text file in S3.</p>', 'UpdateThesaurusRequest$RoleArn' => '<p>An IAM role that gives Amazon Kendra permissions to access thesaurus file specified in <code>SourceS3Path</code>.</p>', ], ], 'S3BucketName' => [ 'base' => NULL, 'refs' => [ 'HookConfiguration$S3Bucket' => '<p>Stores the original, raw documents or the structured, parsed documents before and after altering them. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html#cde-data-contracts-lambda">Data contracts for Lambda functions</a>.</p>', 'S3DataSourceConfiguration$BucketName' => '<p>The name of the bucket that contains the documents.</p>', 'S3Path$Bucket' => '<p>The name of the S3 bucket that contains the file.</p>', ], ], 'S3DataSourceConfiguration' => [ 'base' => '<p>Provides the configuration information to connect to an Amazon S3 bucket.</p> <note> <p>Amazon Kendra now supports an upgraded Amazon S3 connector.</p> <p>You must now use the <a href="https://docs.aws.amazon.com/kendra/latest/APIReference/API_TemplateConfiguration.html">TemplateConfiguration</a> object instead of the <code>S3DataSourceConfiguration</code> object to configure your connector.</p> <p>Connectors configured using the older console and API architecture will continue to function as configured. However, you won\'t be able to edit or update them. If you want to edit or update your connector configuration, you must create a new connector.</p> <p>We recommended migrating your connector workflow to the upgraded version. Support for connectors configured using the older architecture is scheduled to end by June 2024.</p> </note>', 'refs' => [ 'DataSourceConfiguration$S3Configuration' => '<p>Provides the configuration information to connect to an Amazon S3 bucket as your data source.</p> <note> <p>Amazon Kendra now supports an upgraded Amazon S3 connector.</p> <p>You must now use the <a href="https://docs.aws.amazon.com/kendra/latest/APIReference/API_TemplateConfiguration.html">TemplateConfiguration</a> object instead of the <code>S3DataSourceConfiguration</code> object to configure your connector.</p> <p>Connectors configured using the older console and API architecture will continue to function as configured. However, you won\'t be able to edit or update them. If you want to edit or update your connector configuration, you must create a new connector.</p> <p>We recommended migrating your connector workflow to the upgraded version. Support for connectors configured using the older architecture is scheduled to end by June 2024.</p> </note>', ], ], 'S3ObjectKey' => [ 'base' => NULL, 'refs' => [ 'AccessControlListConfiguration$KeyPath' => '<p>Path to the Amazon S3 bucket that contains the ACL files.</p>', 'DocumentsMetadataConfiguration$S3Prefix' => '<p>A prefix used to filter metadata configuration files in the Amazon Web Services S3 bucket. The S3 bucket might contain multiple metadata files. Use <code>S3Prefix</code> to include only the desired metadata files.</p>', 'S3Path$Key' => '<p>The name of the file.</p>', ], ], 'S3Path' => [ 'base' => '<p>Information required to find a specific file in an Amazon S3 bucket.</p>', 'refs' => [ 'AlfrescoConfiguration$SslCertificateS3Path' => '<p>The path to the SSL certificate stored in an Amazon S3 bucket. You use this to connect to Alfresco if you require a secure SSL connection.</p> <p>You can simply generate a self-signed X509 certificate on any computer using OpenSSL. For an example of using OpenSSL to create an X509 certificate, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/configuring-https-ssl.html">Create and sign an X509 certificate</a>.</p>', 'CreateFaqRequest$S3Path' => '<p>The path to the FAQ file in S3.</p>', 'CreateQuerySuggestionsBlockListRequest$SourceS3Path' => '<p>The S3 path to your block list text file in your S3 bucket.</p> <p>Each block word or phrase should be on a separate line in a text file.</p> <p>For information on the current quota limits for block lists, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas for Amazon Kendra</a>.</p>', 'CreateThesaurusRequest$SourceS3Path' => '<p>The path to the thesaurus file in S3.</p>', 'DescribeFaqResponse$S3Path' => NULL, 'DescribeQuerySuggestionsBlockListResponse$SourceS3Path' => '<p>Shows the current S3 path to your block list text file in your S3 bucket.</p> <p>Each block word or phrase should be on a separate line in a text file.</p> <p>For information on the current quota limits for block lists, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas for Amazon Kendra</a>.</p>', 'DescribeThesaurusResponse$SourceS3Path' => NULL, 'Document$S3Path' => NULL, 'GroupMembers$S3PathforGroupMembers' => '<p>If you have more than 1000 users and/or sub groups for a single group, you need to provide the path to the S3 file that lists your users and sub groups for a group. Your sub groups can contain more than 1000 users, but the list of sub groups that belong to a group (and/or users) must be no more than 1000.</p> <p>You can download this <a href="https://docs.aws.amazon.com/kendra/latest/dg/samples/group_members.zip">example S3 file</a> that uses the correct format for listing group members. Note, <code>dataSourceId</code> is optional. The value of <code>type</code> for a group is always <code>GROUP</code> and for a user it is always <code>USER</code>.</p>', 'OnPremiseConfiguration$SslCertificateS3Path' => '<p>The path to the SSL certificate stored in an Amazon S3 bucket. You use this to connect to GitHub if you require a secure SSL connection.</p> <p>You can simply generate a self-signed X509 certificate on any computer using OpenSSL. For an example of using OpenSSL to create an X509 certificate, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/configuring-https-ssl.html">Create and sign an X509 certificate</a>.</p>', 'OneDriveUsers$OneDriveUserS3Path' => '<p>The S3 bucket location of a file containing a list of users whose documents should be indexed.</p>', 'SharePointConfiguration$SslCertificateS3Path' => '<p>The path to the SSL certificate stored in an Amazon S3 bucket. You use this to connect to SharePoint Server if you require a secure SSL connection.</p> <p>You can generate a self-signed X509 certificate on any computer using OpenSSL. For an example of using OpenSSL to create an X509 certificate, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/configuring-https-ssl.html">Create and sign an X509 certificate</a>.</p>', 'UpdateQuerySuggestionsBlockListRequest$SourceS3Path' => '<p>The S3 path where your block list text file sits in S3.</p> <p>If you update your block list and provide the same path to the block list text file in S3, then Amazon Kendra reloads the file to refresh the block list. Amazon Kendra does not automatically refresh your block list. You need to call the <code>UpdateQuerySuggestionsBlockList</code> API to refresh you block list.</p> <p>If you update your block list, then Amazon Kendra asynchronously refreshes all query suggestions with the latest content in the S3 file. This means changes might not take effect immediately.</p>', 'UpdateThesaurusRequest$SourceS3Path' => NULL, ], ], 'SaaSConfiguration' => [ 'base' => '<p>Provides the configuration information to connect to GitHub Enterprise Cloud (SaaS).</p>', 'refs' => [ 'GitHubConfiguration$SaaSConfiguration' => '<p>Configuration information to connect to GitHub Enterprise Cloud (SaaS).</p>', ], ], 'SalesforceChatterFeedConfiguration' => [ 'base' => '<p>The configuration information for syncing a Salesforce chatter feed. The contents of the object comes from the Salesforce FeedItem table.</p>', 'refs' => [ 'SalesforceConfiguration$ChatterFeedConfiguration' => '<p>Configuration information for Salesforce chatter feeds.</p>', ], ], 'SalesforceChatterFeedIncludeFilterType' => [ 'base' => NULL, 'refs' => [ 'SalesforceChatterFeedIncludeFilterTypes$member' => NULL, ], ], 'SalesforceChatterFeedIncludeFilterTypes' => [ 'base' => NULL, 'refs' => [ 'SalesforceChatterFeedConfiguration$IncludeFilterTypes' => '<p>Filters the documents in the feed based on status of the user. When you specify <code>ACTIVE_USERS</code> only documents from users who have an active account are indexed. When you specify <code>STANDARD_USER</code> only documents for Salesforce standard users are documented. You can specify both.</p>', ], ], 'SalesforceConfiguration' => [ 'base' => '<p>Provides the configuration information to connect to Salesforce as your data source.</p>', 'refs' => [ 'DataSourceConfiguration$SalesforceConfiguration' => '<p>Provides the configuration information to connect to Salesforce as your data source.</p>', ], ], 'SalesforceCustomKnowledgeArticleTypeConfiguration' => [ 'base' => '<p>Provides the configuration information for indexing Salesforce custom articles.</p>', 'refs' => [ 'SalesforceCustomKnowledgeArticleTypeConfigurationList$member' => NULL, ], ], 'SalesforceCustomKnowledgeArticleTypeConfigurationList' => [ 'base' => NULL, 'refs' => [ 'SalesforceKnowledgeArticleConfiguration$CustomKnowledgeArticleTypeConfigurations' => '<p>Configuration information for custom Salesforce knowledge articles.</p>', ], ], 'SalesforceCustomKnowledgeArticleTypeName' => [ 'base' => NULL, 'refs' => [ 'SalesforceCustomKnowledgeArticleTypeConfiguration$Name' => '<p>The name of the configuration.</p>', ], ], 'SalesforceKnowledgeArticleConfiguration' => [ 'base' => '<p>Provides the configuration information for the knowledge article types that Amazon Kendra indexes. Amazon Kendra indexes standard knowledge articles and the standard fields of knowledge articles, or the custom fields of custom knowledge articles, but not both </p>', 'refs' => [ 'SalesforceConfiguration$KnowledgeArticleConfiguration' => '<p>Configuration information for the knowledge article types that Amazon Kendra indexes. Amazon Kendra indexes standard knowledge articles and the standard fields of knowledge articles, or the custom fields of custom knowledge articles, but not both.</p>', ], ], 'SalesforceKnowledgeArticleState' => [ 'base' => NULL, 'refs' => [ 'SalesforceKnowledgeArticleStateList$member' => NULL, ], ], 'SalesforceKnowledgeArticleStateList' => [ 'base' => NULL, 'refs' => [ 'SalesforceKnowledgeArticleConfiguration$IncludedStates' => '<p>Specifies the document states that should be included when Amazon Kendra indexes knowledge articles. You must specify at least one state.</p>', ], ], 'SalesforceStandardKnowledgeArticleTypeConfiguration' => [ 'base' => '<p>Provides the configuration information for standard Salesforce knowledge articles.</p>', 'refs' => [ 'SalesforceKnowledgeArticleConfiguration$StandardKnowledgeArticleTypeConfiguration' => '<p>Configuration information for standard Salesforce knowledge articles.</p>', ], ], 'SalesforceStandardObjectAttachmentConfiguration' => [ 'base' => '<p>Provides the configuration information for processing attachments to Salesforce standard objects.</p>', 'refs' => [ 'SalesforceConfiguration$StandardObjectAttachmentConfiguration' => '<p>Configuration information for processing attachments to Salesforce standard objects. </p>', ], ], 'SalesforceStandardObjectConfiguration' => [ 'base' => '<p>Provides the configuration information for indexing a single standard object.</p>', 'refs' => [ 'SalesforceStandardObjectConfigurationList$member' => NULL, ], ], 'SalesforceStandardObjectConfigurationList' => [ 'base' => NULL, 'refs' => [ 'SalesforceConfiguration$StandardObjectConfigurations' => '<p>Configuration of the Salesforce standard objects that Amazon Kendra indexes.</p>', ], ], 'SalesforceStandardObjectName' => [ 'base' => NULL, 'refs' => [ 'SalesforceStandardObjectConfiguration$Name' => '<p>The name of the standard object.</p>', ], ], 'ScanSchedule' => [ 'base' => NULL, 'refs' => [ 'CreateDataSourceRequest$Schedule' => '<p>Sets the frequency for Amazon Kendra to check the documents in your data source repository and update the index. If you don\'t set a schedule Amazon Kendra will not periodically update the index. You can call the <code>StartDataSourceSyncJob</code> API to update the index.</p> <p>Specify a <code>cron-</code> format schedule string or an empty string to indicate that the index is updated on demand.</p> <p>You can\'t specify the <code>Schedule</code> parameter when the <code>Type</code> parameter is set to <code>CUSTOM</code>. If you do, you receive a <code>ValidationException</code> exception.</p>', 'DescribeDataSourceResponse$Schedule' => '<p>The schedule for Amazon Kendra to update the index.</p>', 'UpdateDataSourceRequest$Schedule' => '<p>The sync schedule you want to update for the data source connector.</p>', ], ], 'ScoreAttributes' => [ 'base' => '<p>Provides a relative ranking that indicates how confident Amazon Kendra is that the response is relevant to the query.</p>', 'refs' => [ 'QueryResultItem$ScoreAttributes' => '<p>Indicates the confidence level of Amazon Kendra providing a relevant result for the query. Each result is placed into a bin that indicates the confidence, <code>VERY_HIGH</code>, <code>HIGH</code>, <code>MEDIUM</code> and <code>LOW</code>. You can use the score to determine if a response meets the confidence needed for your application.</p> <p>The field is only set to <code>LOW</code> when the <code>Type</code> field is set to <code>DOCUMENT</code> and Amazon Kendra is not confident that the result is relevant to the query.</p>', 'RetrieveResultItem$ScoreAttributes' => '<p>The confidence score bucket for a retrieved passage result. The confidence bucket provides a relative ranking that indicates how confident Amazon Kendra is that the response is relevant to the query.</p>', ], ], 'ScoreConfidence' => [ 'base' => 'Enumeration for query score confidence.', 'refs' => [ 'ScoreAttributes$ScoreConfidence' => '<p>A relative ranking for how relevant the response is to the query.</p>', ], ], 'Search' => [ 'base' => '<p>Provides information about how a custom index field is used during a search.</p>', 'refs' => [ 'DocumentMetadataConfiguration$Search' => '<p>Provides information about how the field is used during a search.</p>', ], ], 'SecretArn' => [ 'base' => NULL, 'refs' => [ 'AlfrescoConfiguration$SecretArn' => '<p>The Amazon Resource Name (ARN) of an Secrets Manager secret that contains the key-value pairs required to connect to your Alfresco data source. The secret must contain a JSON structure with the following keys:</p> <ul> <li> <p>username—The user name of the Alfresco account.</p> </li> <li> <p>password—The password of the Alfresco account.</p> </li> </ul>', 'BasicAuthenticationConfiguration$Credentials' => '<p>Your secret ARN, which you can create in <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html">Secrets Manager</a> </p> <p>You use a secret if basic authentication credentials are required to connect to a website. The secret stores your credentials of user name and password.</p>', 'BoxConfiguration$SecretArn' => '<p>The Amazon Resource Name (ARN) of an Secrets Manager secret that contains the key-value pairs required to connect to your Box platform. The secret must contain a JSON structure with the following keys:</p> <ul> <li> <p>clientID—The identifier of the client OAuth 2.0 authentication application created in Box.</p> </li> <li> <p>clientSecret—A set of characters known only to the OAuth 2.0 authentication application created in Box.</p> </li> <li> <p>publicKeyId—The identifier of the public key contained within an identity certificate.</p> </li> <li> <p>privateKey—A set of characters that make up an encryption key.</p> </li> <li> <p>passphrase—A set of characters that act like a password.</p> </li> </ul> <p>You create an application in Box to generate the keys or credentials required for the secret. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-box.html">Using a Box data source</a>.</p>', 'ConfluenceConfiguration$SecretArn' => '<p>The Amazon Resource Name (ARN) of an Secrets Manager secret that contains the user name and password required to connect to the Confluence instance. If you use Confluence Cloud, you use a generated API token as the password.</p> <p>You can also provide authentication credentials in the form of a personal access token. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-confluence.html">Using a Confluence data source</a>.</p>', 'ConnectionConfiguration$SecretArn' => '<p>The Amazon Resource Name (ARN) of credentials stored in Secrets Manager. The credentials should be a user/password pair. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-database.html">Using a Database Data Source</a>. For more information about Secrets Manager, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html"> What Is Secrets Manager</a> in the <i> Secrets Manager </i> user guide.</p>', 'FsxConfiguration$SecretArn' => '<p>The Amazon Resource Name (ARN) of an Secrets Manager secret that contains the key-value pairs required to connect to your Amazon FSx file system. Windows is currently the only supported type. The secret must contain a JSON structure with the following keys:</p> <ul> <li> <p>username—The Active Directory user name, along with the Domain Name System (DNS) domain name. For example, <i>user@corp.example.com</i>. The Active Directory user account must have read and mounting access to the Amazon FSx file system for Windows.</p> </li> <li> <p>password—The password of the Active Directory user account with read and mounting access to the Amazon FSx Windows file system.</p> </li> </ul>', 'GitHubConfiguration$SecretArn' => '<p>The Amazon Resource Name (ARN) of an Secrets Manager secret that contains the key-value pairs required to connect to your GitHub. The secret must contain a JSON structure with the following keys:</p> <ul> <li> <p>personalToken—The access token created in GitHub. For more information on creating a token in GitHub, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-github.html">Using a GitHub data source</a>.</p> </li> </ul>', 'GoogleDriveConfiguration$SecretArn' => '<p>The Amazon Resource Name (ARN) of a Secrets Managersecret that contains the credentials required to connect to Google Drive. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-google-drive.html">Using a Google Workspace Drive data source</a>.</p>', 'JiraConfiguration$SecretArn' => '<p>The Amazon Resource Name (ARN) of a secret in Secrets Manager contains the key-value pairs required to connect to your Jira data source. The secret must contain a JSON structure with the following keys:</p> <ul> <li> <p>jiraId—The Jira user name or email.</p> </li> <li> <p>jiraCredentials—The Jira API token. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-jira.html">Using a Jira data source</a>.</p> </li> </ul>', 'OneDriveConfiguration$SecretArn' => '<p>The Amazon Resource Name (ARN) of an Secrets Managersecret that contains the user name and password to connect to OneDrive. The user name should be the application ID for the OneDrive application, and the password is the application key for the OneDrive application.</p>', 'ProxyConfiguration$Credentials' => '<p>Your secret ARN, which you can create in <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html">Secrets Manager</a> </p> <p>The credentials are optional. You use a secret if web proxy credentials are required to connect to a website host. Amazon Kendra currently support basic authentication to connect to a web proxy server. The secret stores your credentials.</p>', 'QuipConfiguration$SecretArn' => '<p>The Amazon Resource Name (ARN) of an Secrets Manager secret that contains the key-value pairs that are required to connect to your Quip. The secret must contain a JSON structure with the following keys:</p> <ul> <li> <p>accessToken—The token created in Quip. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-slack.html">Using a Quip data source</a>.</p> </li> </ul>', 'SalesforceConfiguration$SecretArn' => '<p>The Amazon Resource Name (ARN) of an Secrets Managersecret that contains the key/value pairs required to connect to your Salesforce instance. The secret must contain a JSON structure with the following keys:</p> <ul> <li> <p>authenticationUrl - The OAUTH endpoint that Amazon Kendra connects to get an OAUTH token. </p> </li> <li> <p>consumerKey - The application public key generated when you created your Salesforce application.</p> </li> <li> <p>consumerSecret - The application private key generated when you created your Salesforce application.</p> </li> <li> <p>password - The password associated with the user logging in to the Salesforce instance.</p> </li> <li> <p>securityToken - The token associated with the user logging in to the Salesforce instance.</p> </li> <li> <p>username - The user name of the user logging in to the Salesforce instance.</p> </li> </ul>', 'ServiceNowConfiguration$SecretArn' => '<p>The Amazon Resource Name (ARN) of the Secrets Manager secret that contains the user name and password required to connect to the ServiceNow instance. You can also provide OAuth authentication credentials of user name, password, client ID, and client secret. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-servicenow.html">Using a ServiceNow data source</a>.</p>', 'SharePointConfiguration$SecretArn' => '<p>The Amazon Resource Name (ARN) of an Secrets Manager secret that contains the user name and password required to connect to the SharePoint instance. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-sharepoint.html">Microsoft SharePoint</a>.</p>', 'SlackConfiguration$SecretArn' => '<p>The Amazon Resource Name (ARN) of an Secrets Manager secret that contains the key-value pairs required to connect to your Slack workspace team. The secret must contain a JSON structure with the following keys:</p> <ul> <li> <p>slackToken—The user or bot token created in Slack. For more information on creating a token in Slack, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-slack.html#slack-authentication">Authentication for a Slack data source</a>.</p> </li> </ul>', ], ], 'SecurityGroupIdList' => [ 'base' => NULL, 'refs' => [ 'DataSourceVpcConfiguration$SecurityGroupIds' => '<p>A list of identifiers of security groups within your Amazon VPC. The security groups should enable Amazon Kendra to connect to the data source.</p>', ], ], 'SeedUrl' => [ 'base' => NULL, 'refs' => [ 'SeedUrlList$member' => NULL, ], ], 'SeedUrlConfiguration' => [ 'base' => '<p>Provides the configuration information for the seed or starting point URLs to crawl.</p> <p> <i>When selecting websites to index, you must adhere to the <a href="https://aws.amazon.com/aup/">Amazon Acceptable Use Policy</a> and all other Amazon terms. Remember that you must only use Amazon Kendra Web Crawler to index your own web pages, or web pages that you have authorization to index.</i> </p>', 'refs' => [ 'Urls$SeedUrlConfiguration' => '<p>Configuration of the seed or starting point URLs of the websites you want to crawl.</p> <p>You can choose to crawl only the website host names, or the website host names with subdomains, or the website host names with subdomains and other domains that the web pages link to.</p> <p>You can list up to 100 seed URLs.</p>', ], ], 'SeedUrlList' => [ 'base' => NULL, 'refs' => [ 'SeedUrlConfiguration$SeedUrls' => '<p>The list of seed or starting point URLs of the websites you want to crawl.</p> <p>The list can include a maximum of 100 seed URLs.</p>', ], ], 'ServerSideEncryptionConfiguration' => [ 'base' => '<p>Provides the identifier of the KMS key used to encrypt data indexed by Amazon Kendra. Amazon Kendra doesn\'t support asymmetric keys.</p>', 'refs' => [ 'CreateIndexRequest$ServerSideEncryptionConfiguration' => '<p>The identifier of the KMS customer managed key (CMK) that\'s used to encrypt data indexed by Amazon Kendra. Amazon Kendra doesn\'t support asymmetric CMKs.</p>', 'DescribeIndexResponse$ServerSideEncryptionConfiguration' => '<p>The identifier of the KMS customer master key (CMK) that is used to encrypt your data. Amazon Kendra doesn\'t support asymmetric CMKs.</p>', ], ], 'ServiceNowAuthenticationType' => [ 'base' => NULL, 'refs' => [ 'ServiceNowConfiguration$AuthenticationType' => '<p>The type of authentication used to connect to the ServiceNow instance. If you choose <code>HTTP_BASIC</code>, Amazon Kendra is authenticated using the user name and password provided in the Secrets Manager secret in the <code>SecretArn</code> field. If you choose <code>OAUTH2</code>, Amazon Kendra is authenticated using the credentials of client ID, client secret, user name and password.</p> <p>When you use <code>OAUTH2</code> authentication, you must generate a token and a client secret using the ServiceNow console. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-servicenow.html">Using a ServiceNow data source</a>.</p>', ], ], 'ServiceNowBuildVersionType' => [ 'base' => NULL, 'refs' => [ 'ServiceNowConfiguration$ServiceNowBuildVersion' => '<p>The identifier of the release that the ServiceNow host is running. If the host is not running the <code>LONDON</code> release, use <code>OTHERS</code>.</p>', ], ], 'ServiceNowConfiguration' => [ 'base' => '<p>Provides the configuration information to connect to ServiceNow as your data source.</p>', 'refs' => [ 'DataSourceConfiguration$ServiceNowConfiguration' => '<p>Provides the configuration information to connect to ServiceNow as your data source.</p>', ], ], 'ServiceNowHostUrl' => [ 'base' => NULL, 'refs' => [ 'ServiceNowConfiguration$HostUrl' => '<p>The ServiceNow instance that the data source connects to. The host endpoint should look like the following: <i>{instance}.service-now.com.</i> </p>', ], ], 'ServiceNowKnowledgeArticleConfiguration' => [ 'base' => '<p>Provides the configuration information for crawling knowledge articles in the ServiceNow site.</p>', 'refs' => [ 'ServiceNowConfiguration$KnowledgeArticleConfiguration' => '<p>Configuration information for crawling knowledge articles in the ServiceNow site.</p>', ], ], 'ServiceNowKnowledgeArticleFilterQuery' => [ 'base' => NULL, 'refs' => [ 'ServiceNowKnowledgeArticleConfiguration$FilterQuery' => '<p>A query that selects the knowledge articles to index. The query can return articles from multiple knowledge bases, and the knowledge bases can be public or private.</p> <p>The query string must be one generated by the ServiceNow console. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/servicenow-query.html">Specifying documents to index with a query</a>. </p>', ], ], 'ServiceNowServiceCatalogConfiguration' => [ 'base' => '<p>Provides the configuration information for crawling service catalog items in the ServiceNow site</p>', 'refs' => [ 'ServiceNowConfiguration$ServiceCatalogConfiguration' => '<p>Configuration information for crawling service catalogs in the ServiceNow site.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>You have exceeded the set limits for your Amazon Kendra service. Please see <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas</a> for more information, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> to inquire about an increase of limits.</p>', 'refs' => [], ], 'SharePointConfiguration' => [ 'base' => '<p>Provides the configuration information to connect to Microsoft SharePoint as your data source.</p>', 'refs' => [ 'DataSourceConfiguration$SharePointConfiguration' => '<p>Provides the configuration information to connect to Microsoft SharePoint as your data source.</p>', ], ], 'SharePointOnlineAuthenticationType' => [ 'base' => NULL, 'refs' => [ 'SharePointConfiguration$AuthenticationType' => '<p>Whether you want to connect to SharePoint Online using basic authentication of user name and password, or OAuth authentication of user name, password, client ID, and client secret, or AD App-only authentication of client secret.</p>', ], ], 'SharePointUrlList' => [ 'base' => NULL, 'refs' => [ 'SharePointConfiguration$Urls' => '<p>The Microsoft SharePoint site URLs for the documents you want to index.</p>', ], ], 'SharePointVersion' => [ 'base' => NULL, 'refs' => [ 'SharePointConfiguration$SharePointVersion' => '<p>The version of Microsoft SharePoint that you use.</p>', ], ], 'SharedDriveId' => [ 'base' => NULL, 'refs' => [ 'ExcludeSharedDrivesList$member' => NULL, ], ], 'SinceCrawlDate' => [ 'base' => NULL, 'refs' => [ 'SlackConfiguration$SinceCrawlDate' => '<p>The date to start crawling your data from your Slack workspace team. The date must follow this format: <code>yyyy-mm-dd</code>.</p>', ], ], 'SiteId' => [ 'base' => NULL, 'refs' => [ 'AlfrescoConfiguration$SiteId' => '<p>The identifier of the Alfresco site. For example, <i>my-site</i>.</p>', ], ], 'SiteMap' => [ 'base' => NULL, 'refs' => [ 'SiteMapsList$member' => NULL, ], ], 'SiteMapsConfiguration' => [ 'base' => '<p>Provides the configuration information for the sitemap URLs to crawl.</p> <p> <i>When selecting websites to index, you must adhere to the <a href="https://aws.amazon.com/aup/">Amazon Acceptable Use Policy</a> and all other Amazon terms. Remember that you must only use Amazon Kendra Web Crawler to index your own web pages, or web pages that you have authorization to index.</i> </p>', 'refs' => [ 'Urls$SiteMapsConfiguration' => '<p>Configuration of the sitemap URLs of the websites you want to crawl.</p> <p>Only URLs belonging to the same website host names are crawled. You can list up to three sitemap URLs.</p>', ], ], 'SiteMapsList' => [ 'base' => NULL, 'refs' => [ 'SiteMapsConfiguration$SiteMaps' => '<p>The list of sitemap URLs of the websites you want to crawl.</p> <p>The list can include a maximum of three sitemap URLs.</p>', ], ], 'SiteUrl' => [ 'base' => NULL, 'refs' => [ 'AlfrescoConfiguration$SiteUrl' => '<p>The URL of the Alfresco site. For example, <i>https://hostname:8080</i>.</p>', ], ], 'SlackConfiguration' => [ 'base' => '<p>Provides the configuration information to connect to Slack as your data source.</p> <note> <p>Amazon Kendra now supports an upgraded Slack connector.</p> <p>You must now use the <a href="https://docs.aws.amazon.com/kendra/latest/APIReference/API_TemplateConfiguration.html">TemplateConfiguration</a> object instead of the <code>SlackConfiguration</code> object to configure your connector.</p> <p>Connectors configured using the older console and API architecture will continue to function as configured. However, you won’t be able to edit or update them. If you want to edit or update your connector configuration, you must create a new connector.</p> <p>We recommended migrating your connector workflow to the upgraded version. Support for connectors configured using the older architecture is scheduled to end by June 2024.</p> </note>', 'refs' => [ 'DataSourceConfiguration$SlackConfiguration' => '<p>Provides the configuration information to connect to Slack as your data source.</p> <note> <p>Amazon Kendra now supports an upgraded Slack connector.</p> <p>You must now use the <a href="https://docs.aws.amazon.com/kendra/latest/APIReference/API_TemplateConfiguration.html">TemplateConfiguration</a> object instead of the <code>SlackConfiguration</code> object to configure your connector.</p> <p>Connectors configured using the older console and API architecture will continue to function as configured. However, you won\'t be able to edit or update them. If you want to edit or update your connector configuration, you must create a new connector.</p> <p>We recommended migrating your connector workflow to the upgraded version. Support for connectors configured using the older architecture is scheduled to end by June 2024.</p> </note>', ], ], 'SlackEntity' => [ 'base' => NULL, 'refs' => [ 'SlackEntityList$member' => NULL, ], ], 'SlackEntityList' => [ 'base' => NULL, 'refs' => [ 'SlackConfiguration$SlackEntityList' => '<p>Specify whether to index public channels, private channels, group messages, and direct messages. You can specify one or more of these options.</p>', ], ], 'SnapshotsDataHeaderFields' => [ 'base' => NULL, 'refs' => [ 'GetSnapshotsResponse$SnapshotsDataHeader' => '<p>The column headers for the search metrics data.</p>', ], ], 'SnapshotsDataRecord' => [ 'base' => NULL, 'refs' => [ 'SnapshotsDataRecords$member' => NULL, ], ], 'SnapshotsDataRecords' => [ 'base' => NULL, 'refs' => [ 'GetSnapshotsResponse$SnapshotsData' => '<p>The search metrics data. The data returned depends on the metric type you requested.</p>', ], ], 'SortOrder' => [ 'base' => NULL, 'refs' => [ 'SortingConfiguration$SortOrder' => '<p>The order that the results should be returned in. In case of ties, the relevance assigned to the result by Amazon Kendra is used as the tie-breaker.</p>', ], ], 'SortingConfiguration' => [ 'base' => '<p>Specifies the document attribute to use to sort the response to a Amazon Kendra query. You can specify a single attribute for sorting. The attribute must have the <code>Sortable</code> flag set to <code>true</code>, otherwise Amazon Kendra returns an exception.</p> <p>You can sort attributes of the following types.</p> <ul> <li> <p>Date value</p> </li> <li> <p>Long value</p> </li> <li> <p>String value</p> </li> </ul> <p>You can\'t sort attributes of the following type.</p> <ul> <li> <p>String list value</p> </li> </ul>', 'refs' => [ 'QueryRequest$SortingConfiguration' => '<p>Provides information that determines how the results of the query are sorted. You can set the field that Amazon Kendra should sort the results on, and specify whether the results should be sorted in ascending or descending order. In the case of ties in sorting the results, the results are sorted by relevance.</p> <p>If you don\'t provide sorting configuration, the results are sorted by the relevance that Amazon Kendra determines for the result.</p>', 'SortingConfigurationList$member' => NULL, ], ], 'SortingConfigurationList' => [ 'base' => NULL, 'refs' => [ 'CollapseConfiguration$SortingConfigurations' => '<p>A prioritized list of document attributes/fields that determine the primary document among those in a collapsed group.</p>', 'QueryRequest$SortingConfigurations' => '<p>Provides configuration information to determine how the results of a query are sorted.</p> <p>You can set upto 3 fields that Amazon Kendra should sort the results on, and specify whether the results should be sorted in ascending or descending order. The sort field quota can be increased.</p> <p>If you don\'t provide a sorting configuration, the results are sorted by the relevance that Amazon Kendra determines for the result. In the case of ties in sorting the results, the results are sorted by relevance. </p>', ], ], 'SourceDocument' => [ 'base' => '<p>The document ID and its fields/attributes that are used for a query suggestion, if document fields set to use for query suggestions.</p>', 'refs' => [ 'SourceDocuments$member' => NULL, ], ], 'SourceDocuments' => [ 'base' => NULL, 'refs' => [ 'Suggestion$SourceDocuments' => '<p>The list of document IDs and their fields/attributes that are used for a single query suggestion, if document fields set to use for query suggestions.</p>', ], ], 'SpellCorrectedQuery' => [ 'base' => '<p>A query with suggested spell corrections. </p>', 'refs' => [ 'SpellCorrectedQueryList$member' => NULL, ], ], 'SpellCorrectedQueryList' => [ 'base' => NULL, 'refs' => [ 'QueryResult$SpellCorrectedQueries' => '<p>A list of information related to suggested spell corrections for a query.</p>', ], ], 'SpellCorrectionConfiguration' => [ 'base' => '<p>Provides the configuration information for suggested query spell corrections.</p> <p>Suggested spell corrections are based on words that appear in your indexed documents and how closely a corrected word matches a misspelled word.</p> <p>This feature is designed with certain defaults or limits. For information on the current limits and how to request more support for some limits, see the <a href="https://docs.aws.amazon.com/kendra/latest/dg/query-spell-check.html">Spell Checker documentation</a>.</p>', 'refs' => [ 'QueryRequest$SpellCorrectionConfiguration' => '<p>Enables suggested spell corrections for queries.</p>', ], ], 'SqlConfiguration' => [ 'base' => '<p>Provides the configuration information to use a SQL database.</p>', 'refs' => [ 'DatabaseConfiguration$SqlConfiguration' => '<p>Provides information about how Amazon Kendra uses quote marks around SQL identifiers when querying a database data source.</p>', ], ], 'StartDataSourceSyncJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartDataSourceSyncJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'Status' => [ 'base' => '<p>Provides information about the status of documents submitted for indexing.</p>', 'refs' => [ 'DocumentStatusList$member' => NULL, ], ], 'StopDataSourceSyncJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StorageCapacityUnit' => [ 'base' => NULL, 'refs' => [ 'CapacityUnitsConfiguration$StorageCapacityUnits' => '<p>The amount of extra storage capacity for an index. A single capacity unit provides 30 GB of storage space or 100,000 documents, whichever is reached first. You can add up to 100 extra capacity units.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AdditionalResultAttribute$Key' => '<p>The key that identifies the attribute.</p>', 'ConflictingItem$SetName' => '<p>The name for the set of featured results that the conflicting query belongs to.</p>', 'ConflictingItem$SetId' => '<p>The identifier of the set of featured results that the conflicting query belongs to.</p>', 'Correction$Term' => '<p>The string or text of a misspelled word in a query.</p>', 'Correction$CorrectedTerm' => '<p>The string or text of a corrected misspelled word in a query.</p>', 'DataSourceSyncJob$ExecutionId' => '<p>A identifier for the synchronization job.</p>', 'DataSourceSyncJob$DataSourceErrorCode' => '<p>If the reason that the synchronization failed is due to an error with the underlying data source, this field contains a code that identifies the error.</p>', 'DocumentAttributeStringListValue$member' => NULL, 'FeaturedDocumentWithMetadata$Title' => '<p>The main title of the featured document.</p>', 'FeaturedResultsConflictException$Message' => '<p>An explanation for the conflicting queries.</p>', 'IssueType$member' => NULL, 'JiraStatus$member' => NULL, 'JsonTokenTypeConfiguration$UserNameAttributeField' => '<p>The user name attribute field.</p>', 'JsonTokenTypeConfiguration$GroupAttributeField' => '<p>The group attribute field.</p>', 'ListAccessControlConfigurationsRequest$NextToken' => '<p>If the previous response was incomplete (because there\'s more data to retrieve), Amazon Kendra returns a pagination token in the response. You can use this pagination token to retrieve the next set of access control configurations.</p>', 'ListAccessControlConfigurationsResponse$NextToken' => '<p>If the response is truncated, Amazon Kendra returns this token, which you can use in the subsequent request to retrieve the next set of access control configurations.</p>', 'PrivateChannelFilter$member' => NULL, 'Project$member' => NULL, 'PublicChannelFilter$member' => NULL, 'SnapshotsDataHeaderFields$member' => NULL, 'SnapshotsDataRecord$member' => NULL, 'SourceDocument$DocumentId' => '<p>The identifier of the document used for a query suggestion.</p>', 'StartDataSourceSyncJobResponse$ExecutionId' => '<p>Identifies a particular synchronization job.</p>', 'Status$FailureCode' => '<p>Indicates the source of the error.</p>', 'Status$FailureReason' => '<p>Provides detailed information about why the document couldn\'t be indexed. Use this information to correct the error before you resubmit the document for indexing.</p>', 'StringList$member' => NULL, 'SuggestionTextWithHighlights$Text' => '<p>The query suggestion text to display to the user.</p>', 'TableCell$Value' => '<p>The actual value or content within a table cell. A table cell could contain a date value of a year, or a string value of text, for example.</p>', 'TextWithHighlights$Text' => '<p>The text to display to the user.</p>', ], ], 'StringList' => [ 'base' => NULL, 'refs' => [ 'GitHubConfiguration$InclusionFolderNamePatterns' => '<p>A list of regular expression patterns to include certain folder names in your GitHub repository or repositories. Folder names that match the patterns are included in the index. Folder names that don\'t match the patterns are excluded from the index. If a folder matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the folder isn\'t included in the index.</p>', 'GitHubConfiguration$InclusionFileTypePatterns' => '<p>A list of regular expression patterns to include certain file types in your GitHub repository or repositories. File types that match the patterns are included in the index. File types that don\'t match the patterns are excluded from the index. If a file matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the file isn\'t included in the index.</p>', 'GitHubConfiguration$InclusionFileNamePatterns' => '<p>A list of regular expression patterns to include certain file names in your GitHub repository or repositories. File names that match the patterns are included in the index. File names that don\'t match the patterns are excluded from the index. If a file matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the file isn\'t included in the index.</p>', 'GitHubConfiguration$ExclusionFolderNamePatterns' => '<p>A list of regular expression patterns to exclude certain folder names in your GitHub repository or repositories. Folder names that match the patterns are excluded from the index. Folder names that don\'t match the patterns are included in the index. If a folder matches both an exclusion and inclusion pattern, the exclusion pattern takes precedence and the folder isn\'t included in the index.</p>', 'GitHubConfiguration$ExclusionFileTypePatterns' => '<p>A list of regular expression patterns to exclude certain file types in your GitHub repository or repositories. File types that match the patterns are excluded from the index. File types that don\'t match the patterns are included in the index. If a file matches both an exclusion and inclusion pattern, the exclusion pattern takes precedence and the file isn\'t included in the index.</p>', 'GitHubConfiguration$ExclusionFileNamePatterns' => '<p>A list of regular expression patterns to exclude certain file names in your GitHub repository or repositories. File names that match the patterns are excluded from the index. File names that don\'t match the patterns are included in the index. If a file matches both an exclusion and inclusion pattern, the exclusion pattern takes precedence and the file isn\'t included in the index.</p>', ], ], 'SubmitFeedbackRequest' => [ 'base' => NULL, 'refs' => [], ], 'SubnetId' => [ 'base' => NULL, 'refs' => [ 'SubnetIdList$member' => NULL, ], ], 'SubnetIdList' => [ 'base' => NULL, 'refs' => [ 'DataSourceVpcConfiguration$SubnetIds' => '<p>A list of identifiers for subnets within your Amazon VPC. The subnets should be able to connect to each other in the VPC, and they should have outgoing access to the Internet through a NAT device.</p>', ], ], 'SuggestableConfig' => [ 'base' => '<p>Provides the configuration information for a document field/attribute that you want to base query suggestions on.</p>', 'refs' => [ 'SuggestableConfigList$member' => NULL, ], ], 'SuggestableConfigList' => [ 'base' => NULL, 'refs' => [ 'AttributeSuggestionsDescribeConfig$SuggestableConfigList' => '<p>The list of fields/attributes that you want to set as suggestible for query suggestions.</p>', 'AttributeSuggestionsUpdateConfig$SuggestableConfigList' => '<p>The list of fields/attributes that you want to set as suggestible for query suggestions.</p>', ], ], 'SuggestedQueryText' => [ 'base' => NULL, 'refs' => [ 'SpellCorrectedQuery$SuggestedQueryText' => '<p>The query with the suggested spell corrections.</p>', ], ], 'Suggestion' => [ 'base' => '<p>A single query suggestion.</p>', 'refs' => [ 'SuggestionList$member' => NULL, ], ], 'SuggestionHighlight' => [ 'base' => '<p>The text highlights for a single query suggestion.</p>', 'refs' => [ 'SuggestionHighlightList$member' => NULL, ], ], 'SuggestionHighlightList' => [ 'base' => NULL, 'refs' => [ 'SuggestionTextWithHighlights$Highlights' => '<p>The beginning and end of the query suggestion text that should be highlighted.</p>', ], ], 'SuggestionList' => [ 'base' => NULL, 'refs' => [ 'GetQuerySuggestionsResponse$Suggestions' => '<p>A list of query suggestions for an index.</p>', ], ], 'SuggestionQueryText' => [ 'base' => NULL, 'refs' => [ 'GetQuerySuggestionsRequest$QueryText' => '<p>The text of a user\'s query to generate query suggestions.</p> <p>A query is suggested if the query prefix matches what a user starts to type as their query.</p> <p>Amazon Kendra does not show any suggestions if a user types fewer than two characters or more than 60 characters. A query must also have at least one search result and contain at least one word of more than four characters.</p>', ], ], 'SuggestionTextWithHighlights' => [ 'base' => '<p>Provides text and information about where to highlight the query suggestion text.</p>', 'refs' => [ 'SuggestionValue$Text' => '<p>The <code>SuggestionTextWithHighlights</code> structure that contains the query suggestion text and highlights.</p>', ], ], 'SuggestionType' => [ 'base' => NULL, 'refs' => [ 'SuggestionTypes$member' => NULL, ], ], 'SuggestionTypes' => [ 'base' => NULL, 'refs' => [ 'GetQuerySuggestionsRequest$SuggestionTypes' => '<p>The suggestions type to base query suggestions on. The suggestion types are query history or document fields/attributes. You can set one type or the other.</p> <p>If you set query history as your suggestions type, Amazon Kendra suggests queries relevant to your users based on popular queries in the query history.</p> <p>If you set document fields/attributes as your suggestions type, Amazon Kendra suggests queries relevant to your users based on the contents of document fields.</p>', ], ], 'SuggestionValue' => [ 'base' => '<p>The <code>SuggestionTextWithHighlights</code> structure information.</p>', 'refs' => [ 'Suggestion$Value' => '<p>The value for the UUID (universally unique identifier) of a single query suggestion.</p> <p>The value is the text string of a suggestion.</p>', ], ], 'TableCell' => [ 'base' => '<p>Provides information about a table cell in a table excerpt.</p>', 'refs' => [ 'TableCellList$member' => NULL, ], ], 'TableCellList' => [ 'base' => NULL, 'refs' => [ 'TableRow$Cells' => '<p>A list of table cells in a row.</p>', ], ], 'TableExcerpt' => [ 'base' => '<p>An excerpt from a table within a document. The table excerpt displays up to five columns and three rows, depending on how many table cells are relevant to the query and how many columns are available in the original table. The top most relevant cell is displayed in the table excerpt, along with the next most relevant cells.</p>', 'refs' => [ 'QueryResultItem$TableExcerpt' => '<p>An excerpt from a table within a document.</p>', ], ], 'TableName' => [ 'base' => NULL, 'refs' => [ 'ConnectionConfiguration$TableName' => '<p>The name of the table that contains the document data.</p>', ], ], 'TableRow' => [ 'base' => '<p>Information about a row in a table excerpt.</p>', 'refs' => [ 'TableRowList$member' => NULL, ], ], 'TableRowList' => [ 'base' => NULL, 'refs' => [ 'TableExcerpt$Rows' => '<p>A list of rows in the table excerpt.</p>', ], ], 'Tag' => [ 'base' => '<p>A list of key/value pairs that identify an index, FAQ, or data source. Tag keys and values can consist of Unicode letters, digits, white space, and any of the following symbols: _ . : / = + - @.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>The key for the tag. Keys are not case sensitive and must be unique for the index, FAQ, or data source.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>A list of tag keys to remove from the index, FAQ, or data source. If a tag key does not exist on the resource, it is ignored.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateDataSourceRequest$Tags' => '<p>A list of key-value pairs that identify or categorize the data source connector. You can also use tags to help control access to the data source connector. Tag keys and values can consist of Unicode letters, digits, white space, and any of the following symbols: _ . : / = + - @.</p>', 'CreateFaqRequest$Tags' => '<p>A list of key-value pairs that identify the FAQ. You can use the tags to identify and organize your resources and to control access to resources.</p>', 'CreateFeaturedResultsSetRequest$Tags' => '<p>A list of key-value pairs that identify or categorize the featured results set. You can also use tags to help control access to the featured results set. Tag keys and values can consist of Unicode letters, digits, white space, and any of the following symbols:_ . : / = + - @.</p>', 'CreateIndexRequest$Tags' => '<p>A list of key-value pairs that identify or categorize the index. You can also use tags to help control access to the index. Tag keys and values can consist of Unicode letters, digits, white space, and any of the following symbols: _ . : / = + - @.</p>', 'CreateQuerySuggestionsBlockListRequest$Tags' => '<p>A list of key-value pairs that identify or categorize the block list. Tag keys and values can consist of Unicode letters, digits, white space, and any of the following symbols: _ . : / = + - @.</p>', 'CreateThesaurusRequest$Tags' => '<p>A list of key-value pairs that identify or categorize the thesaurus. You can also use tags to help control access to the thesaurus. Tag keys and values can consist of Unicode letters, digits, white space, and any of the following symbols: _ . : / = + - @.</p>', 'ListTagsForResourceResponse$Tags' => '<p>A list of tags associated with the index, FAQ, or data source.</p>', 'TagResourceRequest$Tags' => '<p>A list of tag keys to add to the index, FAQ, or data source. If a tag already exists, the existing value is replaced with the new value.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The value associated with the tag. The value may be an empty string but it can\'t be null.</p>', ], ], 'TeamId' => [ 'base' => NULL, 'refs' => [ 'SlackConfiguration$TeamId' => '<p>The identifier of the team in the Slack workspace. For example, <i>T0123456789</i>.</p> <p>You can find your team ID in the URL of the main page of your Slack workspace. When you log in to Slack via a browser, you are directed to the URL of the main page. For example, <i>https://app.slack.com/client/<b>T0123456789</b>/...</i>.</p>', ], ], 'Template' => [ 'base' => '<p>The template schema used for the data source, where templates schemas are supported.</p> <p>See <a href="https://docs.aws.amazon.com/kendra/latest/dg/ds-schemas.html">Data source template schemas</a>.</p>', 'refs' => [ 'TemplateConfiguration$Template' => '<p>The template schema used for the data source, where templates schemas are supported.</p> <p>See <a href="https://docs.aws.amazon.com/kendra/latest/dg/ds-schemas.html">Data source template schemas</a>.</p>', ], ], 'TemplateConfiguration' => [ 'base' => '<p>Provides a template for the configuration information to connect to your data source.</p>', 'refs' => [ 'DataSourceConfiguration$TemplateConfiguration' => '<p>Provides a template for the configuration information to connect to your data source.</p>', ], ], 'TenantDomain' => [ 'base' => NULL, 'refs' => [ 'OneDriveConfiguration$TenantDomain' => '<p>The Azure Active Directory domain of the organization. </p>', ], ], 'TextDocumentStatistics' => [ 'base' => '<p>Provides information about text documents indexed in an index.</p>', 'refs' => [ 'IndexStatistics$TextDocumentStatistics' => '<p>The number of text documents indexed.</p>', ], ], 'TextWithHighlights' => [ 'base' => '<p>Provides text and information about where to highlight the text.</p>', 'refs' => [ 'AdditionalResultAttributeValue$TextWithHighlightsValue' => '<p>The text associated with the attribute and information about the highlight to apply to the text.</p>', 'ExpandedResultItem$DocumentTitle' => NULL, 'ExpandedResultItem$DocumentExcerpt' => NULL, 'FeaturedResultsItem$DocumentTitle' => NULL, 'FeaturedResultsItem$DocumentExcerpt' => NULL, 'QueryResultItem$DocumentTitle' => '<p>The title of the document. Contains the text of the title and information for highlighting the relevant terms in the title.</p>', 'QueryResultItem$DocumentExcerpt' => '<p>An extract of the text in the document. Contains information about highlighting the relevant terms in the excerpt.</p>', ], ], 'ThesaurusId' => [ 'base' => NULL, 'refs' => [ 'CreateThesaurusResponse$Id' => '<p>The identifier of the thesaurus. </p>', 'DeleteThesaurusRequest$Id' => '<p>The identifier of the thesaurus you want to delete.</p>', 'DescribeThesaurusRequest$Id' => '<p>The identifier of the thesaurus you want to get information on.</p>', 'DescribeThesaurusResponse$Id' => '<p>The identifier of the thesaurus.</p>', 'ThesaurusSummary$Id' => '<p>The identifier of the thesaurus.</p>', 'UpdateThesaurusRequest$Id' => '<p>The identifier of the thesaurus you want to update.</p>', ], ], 'ThesaurusName' => [ 'base' => NULL, 'refs' => [ 'CreateThesaurusRequest$Name' => '<p>A name for the thesaurus.</p>', 'DescribeThesaurusResponse$Name' => '<p>The thesaurus name.</p>', 'ThesaurusSummary$Name' => '<p>The name of the thesaurus.</p>', 'UpdateThesaurusRequest$Name' => '<p>A new name for the thesaurus.</p>', ], ], 'ThesaurusStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeThesaurusResponse$Status' => '<p>The current status of the thesaurus. When the value is <code>ACTIVE</code>, queries are able to use the thesaurus. If the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field provides more information. </p> <p>If the status is <code>ACTIVE_BUT_UPDATE_FAILED</code>, it means that Amazon Kendra could not ingest the new thesaurus file. The old thesaurus file is still active. </p>', 'ThesaurusSummary$Status' => '<p>The status of the thesaurus.</p>', ], ], 'ThesaurusSummary' => [ 'base' => '<p>An array of summary information for a thesaurus or multiple thesauri.</p>', 'refs' => [ 'ThesaurusSummaryItems$member' => NULL, ], ], 'ThesaurusSummaryItems' => [ 'base' => NULL, 'refs' => [ 'ListThesauriResponse$ThesaurusSummaryItems' => '<p>An array of summary information for a thesaurus or multiple thesauri.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The request was denied due to request throttling. Please reduce the number of requests and try again.</p>', 'refs' => [], ], 'TimeRange' => [ 'base' => '<p>Provides a range of time.</p>', 'refs' => [ 'GetSnapshotsResponse$SnapShotTimeFilter' => '<p>The Unix timestamp for the beginning and end of the time window for the search metrics data.</p>', 'ListDataSourceSyncJobsRequest$StartTimeFilter' => '<p>When specified, the synchronization jobs returned in the list are limited to jobs between the specified dates.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'ClickFeedback$ClickTime' => '<p>The Unix timestamp when the result was clicked.</p>', 'DataSourceSummary$CreatedAt' => '<p>The Unix timestamp when the data source connector was created.</p>', 'DataSourceSummary$UpdatedAt' => '<p>The Unix timestamp when the data source connector was last updated.</p>', 'DataSourceSyncJob$StartTime' => '<p>The Unix timestamp when the synchronization job started.</p>', 'DataSourceSyncJob$EndTime' => '<p>The Unix timestamp when the synchronization job completed.</p>', 'DescribeDataSourceResponse$CreatedAt' => '<p>The Unix timestamp when the data source connector was created.</p>', 'DescribeDataSourceResponse$UpdatedAt' => '<p>The Unix timestamp when the data source connector was last updated.</p>', 'DescribeExperienceResponse$CreatedAt' => '<p>The Unix timestamp when your Amazon Kendra experience was created.</p>', 'DescribeExperienceResponse$UpdatedAt' => '<p>The Unix timestamp when your Amazon Kendra experience was last updated.</p>', 'DescribeFaqResponse$CreatedAt' => '<p>The Unix timestamp when the FAQ was created.</p>', 'DescribeFaqResponse$UpdatedAt' => '<p>The Unix timestamp when the FAQ was last updated.</p>', 'DescribeIndexResponse$CreatedAt' => '<p>The Unix timestamp when the index was created.</p>', 'DescribeIndexResponse$UpdatedAt' => '<p>The Unix timestamp when the index was last updated.</p>', 'DescribeQuerySuggestionsBlockListResponse$CreatedAt' => '<p>The Unix timestamp when a block list for query suggestions was created.</p>', 'DescribeQuerySuggestionsBlockListResponse$UpdatedAt' => '<p>The Unix timestamp when a block list for query suggestions was last updated.</p>', 'DescribeQuerySuggestionsConfigResponse$LastSuggestionsBuildTime' => '<p>The Unix timestamp when query suggestions for an index was last updated.</p> <p>Amazon Kendra automatically updates suggestions every 24 hours, after you change a setting or after you apply a <a href="https://docs.aws.amazon.com/kendra/latest/dg/query-suggestions.html#query-suggestions-blocklist">block list</a>.</p>', 'DescribeQuerySuggestionsConfigResponse$LastClearTime' => '<p>The Unix timestamp when query suggestions for an index was last cleared.</p> <p>After you clear suggestions, Amazon Kendra learns new suggestions based on new queries added to the query log from the time you cleared suggestions. Amazon Kendra only considers re-occurences of a query from the time you cleared suggestions. </p>', 'DescribeThesaurusResponse$CreatedAt' => '<p>The Unix timestamp when the thesaurus was created.</p>', 'DescribeThesaurusResponse$UpdatedAt' => '<p>The Unix timestamp when the thesaurus was last updated.</p>', 'DocumentAttributeValue$DateValue' => '<p>A date expressed as an ISO 8601 string.</p> <p>It is important for the time zone to be included in the ISO 8601 date-time format. For example, 2012-03-25T12:30:10+01:00 is the ISO 8601 date-time format for March 25th 2012 at 12:30PM (plus 10 seconds) in Central European Time.</p>', 'ExperiencesSummary$CreatedAt' => '<p>The Unix timestamp when your Amazon Kendra experience was created.</p>', 'FaqSummary$CreatedAt' => '<p>The Unix timestamp when the FAQ was created.</p>', 'FaqSummary$UpdatedAt' => '<p>The Unix timestamp when the FAQ was last updated.</p>', 'GroupOrderingIdSummary$LastUpdatedAt' => '<p>The Unix timestamp when an action was last updated. An action can be a <code>PUT</code> or <code>DELETE</code> action for mapping users to their groups.</p>', 'GroupOrderingIdSummary$ReceivedAt' => '<p>The Unix timestamp when an action was received by Amazon Kendra. An action can be a <code>PUT</code> or <code>DELETE</code> action for mapping users to their groups.</p>', 'IndexConfigurationSummary$CreatedAt' => '<p>The Unix timestamp when the index was created.</p>', 'IndexConfigurationSummary$UpdatedAt' => '<p>The Unix timestamp when the index was last updated.</p>', 'PersonasSummary$CreatedAt' => '<p>The Unix timestamp when the summary information was created.</p>', 'PersonasSummary$UpdatedAt' => '<p>The Unix timestamp when the summary information was last updated.</p>', 'QuerySuggestionsBlockListSummary$CreatedAt' => '<p>The Unix timestamp when the block list was created.</p>', 'QuerySuggestionsBlockListSummary$UpdatedAt' => '<p>The Unix timestamp when the block list was last updated.</p>', 'ThesaurusSummary$CreatedAt' => '<p>The Unix timestamp when the thesaurus was created.</p>', 'ThesaurusSummary$UpdatedAt' => '<p>The Unix timestamp when the thesaurus was last updated.</p>', 'TimeRange$StartTime' => '<p>The Unix timestamp for the beginning of the time range.</p>', 'TimeRange$EndTime' => '<p>The Unix timestamp for the end of the time range.</p>', ], ], 'Title' => [ 'base' => NULL, 'refs' => [ 'Document$Title' => '<p>The title of the document.</p>', ], ], 'Token' => [ 'base' => NULL, 'refs' => [ 'UserContext$Token' => '<p>The user context token for filtering search results for a user. It must be a JWT or a JSON token.</p>', ], ], 'TopDocumentAttributeValueCountPairsSize' => [ 'base' => NULL, 'refs' => [ 'Facet$MaxResults' => '<p>Maximum number of facet values per facet. The default is 10. You can use this to limit the number of facet values to less than 10. If you want to increase the default, contact <a href="http://aws.amazon.com/contact-us/">Support</a>.</p>', ], ], 'Type' => [ 'base' => NULL, 'refs' => [ 'GitHubConfiguration$Type' => '<p>The type of GitHub service you want to connect to—GitHub Enterprise Cloud (SaaS) or GitHub Enterprise Server (on premises).</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAccessControlConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAccessControlConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDataSourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateExperienceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFeaturedResultsSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFeaturedResultsSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateIndexRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateQuerySuggestionsBlockListRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateQuerySuggestionsConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateThesaurusRequest' => [ 'base' => NULL, 'refs' => [], ], 'Url' => [ 'base' => NULL, 'refs' => [ 'ConfluenceConfiguration$ServerUrl' => '<p>The URL of your Confluence instance. Use the full URL of the server. For example, <i>https://server.example.com:port/</i>. You can also use an IP address, for example, <i>https://192.168.1.113/</i>.</p>', 'ExpandedResultItem$DocumentURI' => '<p>The URI of the original location of the document.</p>', 'FeaturedDocumentWithMetadata$URI' => '<p>The source URI location of the featured document.</p>', 'FeaturedResultsItem$DocumentURI' => '<p>The source URI location of the featured document.</p>', 'JwtTokenTypeConfiguration$URL' => '<p>The signing key URL.</p>', 'OnPremiseConfiguration$HostUrl' => '<p>The GitHub host URL or API endpoint URL. For example, <i>https://on-prem-host-url/api/v3/</i> </p>', 'QueryResultItem$DocumentURI' => '<p>The URI of the original location of the document.</p>', 'RetrieveResultItem$DocumentURI' => '<p>The URI of the original location of the document.</p>', 'SaaSConfiguration$HostUrl' => '<p>The GitHub host URL or API endpoint URL. For example, <i>https://api.github.com</i>.</p>', 'SalesforceConfiguration$ServerUrl' => '<p>The instance URL for the Salesforce site that you want to index.</p>', 'SharePointUrlList$member' => NULL, ], ], 'Urls' => [ 'base' => '<p>Provides the configuration information of the URLs to crawl.</p> <p>You can only crawl websites that use the secure communication protocol, Hypertext Transfer Protocol Secure (HTTPS). If you receive an error when crawling a website, it could be that the website is blocked from crawling.</p> <p> <i>When selecting websites to index, you must adhere to the <a href="https://aws.amazon.com/aup/">Amazon Acceptable Use Policy</a> and all other Amazon terms. Remember that you must only use Amazon Kendra Web Crawler to index your own web pages, or web pages that you have authorization to index.</i> </p>', 'refs' => [ 'WebCrawlerConfiguration$Urls' => '<p>Specifies the seed or starting point URLs of the websites or the sitemap URLs of the websites you want to crawl.</p> <p>You can include website subdomains. You can list up to 100 seed URLs and up to three sitemap URLs.</p> <p>You can only crawl websites that use the secure communication protocol, Hypertext Transfer Protocol Secure (HTTPS). If you receive an error when crawling a website, it could be that the website is blocked from crawling.</p> <p> <i>When selecting websites to index, you must adhere to the <a href="https://aws.amazon.com/aup/">Amazon Acceptable Use Policy</a> and all other Amazon terms. Remember that you must only use Amazon Kendra Web Crawler to index your own web pages, or web pages that you have authorization to index.</i> </p>', ], ], 'UserAccount' => [ 'base' => NULL, 'refs' => [ 'ExcludeUserAccountsList$member' => NULL, ], ], 'UserContext' => [ 'base' => '<p>Provides information about the user context for an Amazon Kendra index.</p> <p>User context filtering is a kind of personalized search with the benefit of controlling access to documents. For example, not all teams that search the company portal for information should access top-secret company documents, nor are these documents relevant to all users. Only specific users or groups of teams given access to top-secret documents should see these documents in their search results.</p> <p>You provide one of the following:</p> <ul> <li> <p>User token</p> </li> <li> <p>User ID, the groups the user belongs to, and any data sources the groups can access.</p> </li> </ul> <p>If you provide both, an exception is thrown.</p>', 'refs' => [ 'AttributeSuggestionsGetConfig$UserContext' => '<p>Applies user context filtering so that only users who are given access to certain documents see these document in their search results.</p>', 'QueryRequest$UserContext' => '<p>The user context token or user and group information.</p>', 'RetrieveRequest$UserContext' => '<p>The user context token or user and group information.</p>', ], ], 'UserContextPolicy' => [ 'base' => NULL, 'refs' => [ 'CreateIndexRequest$UserContextPolicy' => '<p>The user context policy.</p> <dl> <dt>ATTRIBUTE_FILTER</dt> <dd> <p>All indexed content is searchable and displayable for all users. If you want to filter search results on user context, you can use the attribute filters of <code>_user_id</code> and <code>_group_ids</code> or you can provide user and group information in <code>UserContext</code>. </p> </dd> <dt>USER_TOKEN</dt> <dd> <p>Enables token-based user access control to filter search results on user context. All documents with no access control and all documents accessible to the user will be searchable and displayable. </p> </dd> </dl>', 'DescribeIndexResponse$UserContextPolicy' => '<p>The user context policy for the Amazon Kendra index.</p>', 'UpdateIndexRequest$UserContextPolicy' => '<p>The user context policy.</p>', ], ], 'UserGroupResolutionConfiguration' => [ 'base' => '<p>Provides the configuration information to get users and groups from an IAM Identity Center identity source. This is useful for user context filtering, where search results are filtered based on the user or their group access to documents. You can also use the <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_PutPrincipalMapping.html">PutPrincipalMapping</a> API to map users to their groups so that you only need to provide the user ID when you issue the query.</p> <p>To set up an IAM Identity Center identity source in the console to use with Amazon Kendra, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/getting-started-aws-sso.html">Getting started with an IAM Identity Center identity source</a>. You must also grant the required permissions to use IAM Identity Center with Amazon Kendra. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html#iam-roles-aws-sso">IAM roles for IAM Identity Center</a>.</p> <p>Amazon Kendra currently does not support using <code>UserGroupResolutionConfiguration</code> with an Amazon Web Services organization member account for your IAM Identity Center identify source. You must create your index in the management account for the organization in order to use <code>UserGroupResolutionConfiguration</code>.</p>', 'refs' => [ 'CreateIndexRequest$UserGroupResolutionConfiguration' => '<p>Gets users and groups from IAM Identity Center identity source. To configure this, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_UserGroupResolutionConfiguration.html">UserGroupResolutionConfiguration</a>. This is useful for user context filtering, where search results are filtered based on the user or their group access to documents.</p>', 'DescribeIndexResponse$UserGroupResolutionConfiguration' => '<p>Whether you have enabled IAM Identity Center identity source for your users and groups. This is useful for user context filtering, where search results are filtered based on the user or their group access to documents.</p>', 'UpdateIndexRequest$UserGroupResolutionConfiguration' => '<p>Gets users and groups from IAM Identity Center identity source. To configure this, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_UserGroupResolutionConfiguration.html">UserGroupResolutionConfiguration</a>. This is useful for user context filtering, where search results are filtered based on the user or their group access to documents.</p>', ], ], 'UserGroupResolutionMode' => [ 'base' => NULL, 'refs' => [ 'UserGroupResolutionConfiguration$UserGroupResolutionMode' => '<p>The identity store provider (mode) you want to use to get users and groups. IAM Identity Center is currently the only available mode. Your users and groups must exist in an IAM Identity Center identity source in order to use this mode.</p>', ], ], 'UserId' => [ 'base' => NULL, 'refs' => [ 'MemberUser$UserId' => '<p>The identifier of the user you want to map to a group.</p>', ], ], 'UserIdentityConfiguration' => [ 'base' => '<p>Provides the configuration information for the identifiers of your users.</p>', 'refs' => [ 'ExperienceConfiguration$UserIdentityConfiguration' => '<p>The IAM Identity Center field name that contains the identifiers of your users, such as their emails.</p>', ], ], 'UserNameAttributeField' => [ 'base' => NULL, 'refs' => [ 'JwtTokenTypeConfiguration$UserNameAttributeField' => '<p>The user name attribute field.</p>', ], ], 'UserTokenConfiguration' => [ 'base' => '<p>Provides the configuration information for a token.</p>', 'refs' => [ 'UserTokenConfigurationList$member' => NULL, ], ], 'UserTokenConfigurationList' => [ 'base' => NULL, 'refs' => [ 'CreateIndexRequest$UserTokenConfigurations' => '<p>The user token configuration.</p>', 'DescribeIndexResponse$UserTokenConfigurations' => '<p>The user token configuration for the Amazon Kendra index.</p>', 'UpdateIndexRequest$UserTokenConfigurations' => '<p>The user token configuration.</p>', ], ], 'ValidationException' => [ 'base' => '<p>The input fails to satisfy the constraints set by the Amazon Kendra service. Please provide the correct input and try again.</p>', 'refs' => [], ], 'ValueImportanceMap' => [ 'base' => NULL, 'refs' => [ 'Relevance$ValueImportanceMap' => '<p>A list of values that should be given a different boost when they appear in the result list. For example, if you are boosting a field called "department", query terms that match the department field are boosted in the result. However, you can add entries from the department field to boost documents with those values higher. </p> <p>For example, you can add entries to the map with names of departments. If you add "HR",5 and "Legal",3 those departments are given special attention when they appear in the metadata of a document. When those terms appear they are given the specified importance instead of the regular importance for the boost.</p>', ], ], 'ValueImportanceMapKey' => [ 'base' => NULL, 'refs' => [ 'ValueImportanceMap$key' => NULL, ], ], 'VisitorId' => [ 'base' => NULL, 'refs' => [ 'QueryRequest$VisitorId' => '<p>Provides an identifier for a specific user. The <code>VisitorId</code> should be a unique identifier, such as a GUID. Don\'t use personally identifiable information, such as the user\'s email address, as the <code>VisitorId</code>.</p>', ], ], 'VpcSecurityGroupId' => [ 'base' => NULL, 'refs' => [ 'SecurityGroupIdList$member' => NULL, ], ], 'Warning' => [ 'base' => '<p>The warning code and message that explains a problem with a query.</p>', 'refs' => [ 'WarningList$member' => NULL, ], ], 'WarningCode' => [ 'base' => NULL, 'refs' => [ 'Warning$Code' => '<p>The code used to show the type of warning for the query.</p>', ], ], 'WarningList' => [ 'base' => NULL, 'refs' => [ 'QueryResult$Warnings' => '<p>A list of warning codes and their messages on problems with your query.</p> <p>Amazon Kendra currently only supports one type of warning, which is a warning on invalid syntax used in the query. For examples of invalid query syntax, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/searching-example.html#searching-index-query-syntax">Searching with advanced query syntax</a>.</p>', ], ], 'WarningMessage' => [ 'base' => NULL, 'refs' => [ 'Warning$Message' => '<p>The message that explains the problem with the query.</p>', ], ], 'WebCrawlerConfiguration' => [ 'base' => '<p>Provides the configuration information required for Amazon Kendra Web Crawler.</p>', 'refs' => [ 'DataSourceConfiguration$WebCrawlerConfiguration' => NULL, ], ], 'WebCrawlerMode' => [ 'base' => NULL, 'refs' => [ 'SeedUrlConfiguration$WebCrawlerMode' => '<p>You can choose one of the following modes:</p> <ul> <li> <p> <code>HOST_ONLY</code>—crawl only the website host names. For example, if the seed URL is "abc.example.com", then only URLs with host name "abc.example.com" are crawled.</p> </li> <li> <p> <code>SUBDOMAINS</code>—crawl the website host names with subdomains. For example, if the seed URL is "abc.example.com", then "a.abc.example.com" and "b.abc.example.com" are also crawled.</p> </li> <li> <p> <code>EVERYTHING</code>—crawl the website host names with subdomains and other domains that the web pages link to.</p> </li> </ul> <p>The default mode is set to <code>HOST_ONLY</code>.</p>', ], ], 'WorkDocsConfiguration' => [ 'base' => '<p>Provides the configuration information to connect to Amazon WorkDocs as your data source.</p> <p>Amazon WorkDocs connector is available in Oregon, North Virginia, Sydney, Singapore and Ireland regions.</p>', 'refs' => [ 'DataSourceConfiguration$WorkDocsConfiguration' => '<p>Provides the configuration information to connect to Amazon WorkDocs as your data source.</p>', ], ], ],];
