<?php
// This file was auto-generated from sdk-root/src/data/marketplace-agreement/2020-03-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>AWS Marketplace is a curated digital catalog that customers can use to find, buy, deploy, and manage third-party software, data, and services to build solutions and run their businesses. The AWS Marketplace Agreement Service provides an API interface that helps AWS Marketplace sellers manage their product-related agreements, including listing, searching, and filtering agreements.</p> <p>To manage agreements in AWS Marketplace, you must ensure that your AWS Identity and Access Management (IAM) policies and roles are set up. The user must have the required policies/permissions that allow them to carry out the actions in AWS:</p> <ul> <li> <p> <code>DescribeAgreement</code> – Grants permission to users to obtain detailed meta data about any of their agreements.</p> </li> <li> <p> <code>GetAgreementTerms</code> – Grants permission to users to obtain details about the terms of an agreement.</p> </li> <li> <p> <code>SearchAgreements</code> – Grants permission to users to search through all their agreements.</p> </li> </ul>', 'operations' => [ 'DescribeAgreement' => '<p>Provides details about an agreement, such as the proposer, acceptor, start date, and end date.</p>', 'GetAgreementTerms' => '<p>Obtains details about the terms in an agreement that you participated in as proposer or acceptor.</p> <p>The details include:</p> <ul> <li> <p> <code>TermType</code> – The type of term, such as <code>LegalTerm</code>, <code>RenewalTerm</code>, or <code>ConfigurableUpfrontPricingTerm</code>.</p> </li> <li> <p> <code>TermID</code> – The ID of the particular term, which is common between offer and agreement.</p> </li> <li> <p> <code>TermPayload</code> – The key information contained in the term, such as the EULA for <code>LegalTerm</code> or pricing and dimensions for various pricing terms, such as <code>ConfigurableUpfrontPricingTerm</code> or <code>UsageBasedPricingTerm</code>.</p> </li> </ul> <ul> <li> <p> <code>Configuration</code> – The buyer/acceptor\'s selection at the time of agreement creation, such as the number of units purchased for a dimension or setting the <code>EnableAutoRenew</code> flag.</p> </li> </ul>', 'SearchAgreements' => '<p>Searches across all agreements that a proposer or an acceptor has in AWS Marketplace. The search returns a list of agreements with basic agreement information.</p> <p>The following filter combinations are supported:</p> <ul> <li> <p> <code>PartyType</code> as <code>Proposer</code> + <code>AgreementType</code> + <code>ResourceIdentifier</code> </p> </li> <li> <p> <code>PartyType</code> as <code>Proposer</code> + <code>AgreementType</code> + <code>OfferId</code> </p> </li> <li> <p> <code>PartyType</code> as <code>Proposer</code> + <code>AgreementType</code> + <code>AcceptorAccountId</code> </p> </li> <li> <p> <code>PartyType</code> as <code>Proposer</code> + <code>AgreementType</code> + <code>Status</code> </p> </li> <li> <p> <code>PartyType</code> as <code>Proposer</code> + <code>AgreementType</code> + <code>ResourceIdentifier</code> + <code>Status</code> </p> </li> <li> <p> <code>PartyType</code> as <code>Proposer</code> + <code>AgreementType</code> + <code>OfferId</code> + <code>Status</code> </p> </li> <li> <p> <code>PartyType</code> as <code>Proposer</code> + <code>AgreementType</code> + <code>AcceptorAccountId</code> + <code>Status</code> </p> </li> <li> <p> <code>PartyType</code> as <code>Proposer</code> + <code>AgreementType</code> + <code>ResourceType</code> + <code>Status</code> </p> </li> <li> <p> <code>PartyType</code> as <code>Proposer</code> + <code>AgreementType</code> + <code>AcceptorAccountId</code> + <code>ResourceType</code> + <code>Status</code> </p> </li> <li> <p> <code>PartyType</code> as <code>Proposer</code> + <code>AgreementType</code> + <code>AcceptorAccountId</code> + <code>OfferId</code> </p> </li> <li> <p> <code>PartyType</code> as <code>Proposer</code> + <code>AgreementType</code> + <code>AcceptorAccountId</code> + <code>OfferId</code> + <code>Status</code> </p> </li> <li> <p> <code>PartyType</code> as <code>Proposer</code> + <code>AgreementType</code> + <code>AcceptorAccountId</code> + <code>ResourceIdentifier</code> </p> </li> <li> <p> <code>PartyType</code> as <code>Proposer</code> + <code>AgreementType</code> + <code>AcceptorAccountId</code> + <code>ResourceIdentifier</code> + <code>Status</code> </p> </li> <li> <p> <code>PartyType</code> as <code>Proposer</code> + <code>AgreementType</code> + <code>AcceptorAccountId</code> + <code>ResourceType</code> </p> </li> </ul>', ], 'shapes' => [ 'AWSAccountId' => [ 'base' => NULL, 'refs' => [ 'Acceptor$accountId' => '<p>The AWS account ID of the acceptor.</p>', 'Proposer$accountId' => '<p>The AWS account ID of the proposer.</p>', ], ], 'AcceptedTerm' => [ 'base' => '<p>A subset of terms proposed by the proposer, which have been accepted by the acceptor as part of agreement creation.</p>', 'refs' => [ 'AcceptedTermList$member' => NULL, ], ], 'AcceptedTermList' => [ 'base' => NULL, 'refs' => [ 'GetAgreementTermsOutput$acceptedTerms' => '<p>A subset of terms proposed by the proposer that have been accepted by the acceptor as part of the agreement creation.</p>', ], ], 'Acceptor' => [ 'base' => '<p>The details of the party accepting the agreement terms. This is commonly the buyer for <code>PurchaseAgreement</code>.</p>', 'refs' => [ 'AgreementViewSummary$acceptor' => '<p>Details of the party accepting the agreement terms. This is commonly the buyer for <code>PurchaseAgreement.</code> </p>', 'DescribeAgreementOutput$acceptor' => '<p>The details of the party accepting the agreement terms. This is commonly the buyer for <code>PurchaseAgreement</code>.</p>', ], ], 'AccessDeniedException' => [ 'base' => '<p>User does not have sufficient access to perform this action.</p>', 'refs' => [], ], 'AgreementResourceType' => [ 'base' => NULL, 'refs' => [ 'Resource$type' => '<p>Type of the resource, which is the product. Values include <code>SaaSProduct</code> or <code>AmiProduct</code>.</p>', ], ], 'AgreementStatus' => [ 'base' => NULL, 'refs' => [ 'AgreementViewSummary$status' => '<p>The current status of the agreement. </p>', 'DescribeAgreementOutput$status' => '<p>The current status of the agreement.</p> <p>Statuses include:</p> <ul> <li> <p> <code>ACTIVE</code> – The terms of the agreement are active.</p> </li> <li> <p> <code>ARCHIVED</code> – The agreement ended without a specified reason.</p> </li> <li> <p> <code>CANCELLED</code> – The acceptor ended the agreement before the defined end date.</p> </li> <li> <p> <code>EXPIRED</code> – The agreement ended on the defined end date.</p> </li> <li> <p> <code>RENEWED</code> – The agreement was renewed into a new agreement (for example, an auto-renewal).</p> </li> <li> <p> <code>REPLACED</code> – The agreement was replaced using an agreement replacement offer.</p> </li> <li> <p> <code>ROLLED_BACK</code> (Only applicable to inactive agreement revisions) – The agreement revision has been rolled back because of an error. An earlier revision is now active.</p> </li> <li> <p> <code>SUPERCEDED</code> (Only applicable to inactive agreement revisions) – The agreement revision is no longer active and another agreement revision is now active.</p> </li> <li> <p> <code>TERMINATED</code> – The agreement ended before the defined end date because of an AWS termination (for example, a payment failure).</p> </li> </ul>', ], ], 'AgreementType' => [ 'base' => NULL, 'refs' => [ 'AgreementViewSummary$agreementType' => '<p>The type of agreement. Values are <code>PurchaseAgreement</code> or <code>VendorInsightsAgreement</code>.</p>', 'DescribeAgreementOutput$agreementType' => '<p>The type of agreement. Values are <code>PurchaseAgreement</code> or <code>VendorInsightsAgreement</code>.</p>', ], ], 'AgreementViewSummary' => [ 'base' => '<p>A summary of the agreement, including top-level attributes (for example, the agreement ID, version, proposer, and acceptor).</p>', 'refs' => [ 'AgreementViewSummaryList$member' => NULL, ], ], 'AgreementViewSummaryList' => [ 'base' => NULL, 'refs' => [ 'SearchAgreementsOutput$agreementViewSummaries' => '<p>A summary of the agreement, including top-level attributes (for example, the agreement ID, version, proposer, and acceptor).</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'RenewalTermConfiguration$enableAutoRenew' => '<p>Defines whether the acceptor has chosen to auto-renew the agreement at the end of its lifecycle. Can be set to <code>True</code> or <code>False</code>.</p>', ], ], 'BoundedString' => [ 'base' => NULL, 'refs' => [ 'ConfigurableUpfrontPricingTermConfiguration$selectorValue' => '<p>Defines the length of time for which the particular pricing/dimension is being purchased by the acceptor.</p>', 'Constraints$multipleDimensionSelection' => '<p>Determines if buyers are allowed to select multiple dimensions in the rate card. The possible values are <code>Allowed</code> and <code>Disallowed</code>. The default value is <code>Allowed</code>.</p>', 'Constraints$quantityConfiguration' => '<p>Determines if acceptors are allowed to configure quantity for each dimension in rate card. The possible values are <code>Allowed</code> and <code>Disallowed</code>. The default value is <code>Allowed</code>.</p>', 'Dimension$dimensionKey' => '<p>The name of key value of the dimension.</p>', 'DocumentItem$type' => '<p>Category of the document. Document types include:</p> <ul> <li> <p> <code>CustomEula</code> – A custom EULA provided by you as seller. A URL for a EULA stored in an accessible Amazon S3 bucket is required for this document type.</p> </li> <li> <p> <code>CustomDsa</code> – A custom Data Subscription Agreement (DSA) provided by you as seller. A URL for a DSA stored in an accessible Amazon S3 bucket is required for this document type.</p> </li> <li> <p> <code>StandardEula</code> – The Standard Contract for AWS Marketplace (SCMP). For more information about SCMP, see the AWS Marketplace Seller Guide. You don’t provide a URL for this type because it’s managed by AWS Marketplace.</p> </li> <li> <p> <code>StandardDsa</code> – DSA for AWS Marketplace. For more information about the DSA, see the AWS Data Exchange User Guide. You don’t provide a URL for this type because it’s managed by AWS Marketplace.</p> </li> </ul>', 'DocumentItem$url' => '<p>A URL to the legal document for buyers to read. Required when <code>Type</code> is <code>CustomEula</code>.</p>', 'DocumentItem$version' => '<p>Version of standard contracts provided by AWS Marketplace. Required when Type is <code>StandardEula</code> or <code>StandardDsa</code>. </p>', 'EstimatedCharges$agreementValue' => '<p>The total known amount customer has to pay across the lifecycle of the agreement.</p> <note> <p>This is the total contract value if accepted terms contain <code>ConfigurableUpfrontPricingTerm</code> or <code>FixedUpfrontPricingTerm</code>. In the case of pure contract pricing, this will be the total value of the contract. In the case of contracts with consumption pricing, this will only include the committed value and not include any overages that occur.</p> <p>If the accepted terms contain <code>PaymentScheduleTerm</code>, it will be the total payment schedule amount. This occurs when flexible payment schedule is used, and is the sum of all invoice charges in the payment schedule.</p> <p>In case a customer has amended an agreement, by purchasing more units of any dimension, this will include both the original cost as well as the added cost incurred due to addition of new units. </p> <p>This is <code>0</code> if the accepted terms contain <code>UsageBasedPricingTerm</code> without <code>ConfigurableUpfrontPricingTerm</code> or <code>RecurringPaymentTerm</code>. This occurs for usage-based pricing (such as SaaS metered or AMI/container hourly or monthly), because the exact usage is not known upfront.</p> </note>', 'FixedUpfrontPricingTerm$duration' => '<p>Contract duration for the terms.</p>', 'FixedUpfrontPricingTerm$price' => '<p>Fixed amount to be charged to the customer when this term is accepted.</p>', 'FreeTrialPricingTerm$duration' => '<p>Duration of the free trial period (5–31 days). </p>', 'GrantItem$dimensionKey' => '<p>Unique dimension key defined in the product document. Dimensions represent categories of capacity in a product and are specified when the product is listed in AWS Marketplace. </p>', 'RateCardItem$dimensionKey' => '<p>Dimension for which the given entitlement applies. Dimensions represent categories of capacity in a product and are specified when the product is listed in AWS Marketplace.</p>', 'RateCardItem$price' => '<p>Per unit price for the product dimension that’s used for calculating the amount to be charged.</p>', 'RecurringPaymentTerm$billingPeriod' => '<p>Defines the recurrence at which buyers are charged.</p>', 'RecurringPaymentTerm$price' => '<p>Amount charged to the buyer every billing period.</p>', 'ScheduleItem$chargeAmount' => '<p>The price that the customer would pay on the scheduled date (chargeDate).</p>', 'Selector$type' => '<p>Category of selector.</p>', 'Selector$value' => '<p>Contract duration. This field supports the ISO 8601 format. </p>', 'SupportTerm$refundPolicy' => '<p>Free-text field about the refund policy description that will be shown to customers as is on the website and console.</p>', 'ValidationExceptionField$message' => '<p>See applicable actions.</p>', 'ValidationExceptionField$name' => '<p>The name of the field associated with the error.</p>', 'ValidityTerm$agreementDuration' => '<p>Defines the duration that the agreement remains active. If <code>AgreementStartDate</code> isn’t provided, the agreement duration is relative to the agreement signature time. The duration is represented in the ISO_8601 format.</p>', ], ], 'ByolPricingTerm' => [ 'base' => '<p>Enables you and your customers to move your existing agreements to AWS Marketplace. The customer won\'t be charged for product usage in AWS Marketplace because they already paid for the product outside of AWS Marketplace.</p>', 'refs' => [ 'AcceptedTerm$byolPricingTerm' => '<p>Enables you and your customers to move your existing agreements to AWS Marketplace. The customer won\'t be charged for product usage in AWS Marketplace because they already paid for the product outside of AWS Marketplace.</p>', ], ], 'Catalog' => [ 'base' => NULL, 'refs' => [ 'SearchAgreementsInput$catalog' => '<p>The catalog in which the agreement was created.</p>', ], ], 'ConfigurableUpfrontPricingTerm' => [ 'base' => '<p>Defines a prepaid payment model that allows buyers to configure the entitlements they want to purchase and the duration.</p>', 'refs' => [ 'AcceptedTerm$configurableUpfrontPricingTerm' => '<p>Defines a prepaid payment model that allows buyers to configure the entitlements they want to purchase and the duration.</p>', ], ], 'ConfigurableUpfrontPricingTermConfiguration' => [ 'base' => '<p>Defines a prepaid payment model that allows buyers to configure the entitlements they want to purchase and the duration.</p>', 'refs' => [ 'ConfigurableUpfrontPricingTerm$configuration' => '<p>Additional parameters specified by the acceptor while accepting the term.</p>', ], ], 'ConfigurableUpfrontRateCardItem' => [ 'base' => '<p>Within the prepaid payment model defined under <code>ConfigurableUpfrontPricingTerm</code>, the <code>RateCardItem</code> defines all the various rate cards (including pricing and dimensions) that have been proposed.</p>', 'refs' => [ 'ConfigurableUpfrontRateCardList$member' => NULL, ], ], 'ConfigurableUpfrontRateCardList' => [ 'base' => NULL, 'refs' => [ 'ConfigurableUpfrontPricingTerm$rateCards' => '<p>A rate card defines the per unit rates for product dimensions.</p>', ], ], 'Constraints' => [ 'base' => '<p>Defines limits on how the term can be configured by acceptors. </p>', 'refs' => [ 'ConfigurableUpfrontRateCardItem$constraints' => '<p>Defines limits on how the term can be configured by acceptors.</p>', ], ], 'CurrencyCode' => [ 'base' => NULL, 'refs' => [ 'ConfigurableUpfrontPricingTerm$currencyCode' => '<p>Defines the currency for the prices mentioned in the term.</p>', 'EstimatedCharges$currencyCode' => '<p>Defines the currency code for the charge.</p>', 'FixedUpfrontPricingTerm$currencyCode' => '<p>Defines the currency for the prices mentioned in this term. </p>', 'PaymentScheduleTerm$currencyCode' => '<p>Defines the currency for the prices mentioned in the term. </p>', 'RecurringPaymentTerm$currencyCode' => '<p>Defines the currency for the prices mentioned in this term. </p>', 'UsageBasedPricingTerm$currencyCode' => '<p>Defines the currency for the prices mentioned in the term. </p>', ], ], 'DescribeAgreementInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAgreementOutput' => [ 'base' => NULL, 'refs' => [], ], 'Dimension' => [ 'base' => '<p>Defines the dimensions that the acceptor has purchased from the overall set of dimensions presented in the rate card.</p>', 'refs' => [ 'DimensionList$member' => NULL, ], ], 'DimensionList' => [ 'base' => NULL, 'refs' => [ 'ConfigurableUpfrontPricingTermConfiguration$dimensions' => '<p>Defines the dimensions that the acceptor has purchased from the overall set of dimensions presented in the rate card.</p>', ], ], 'DocumentItem' => [ 'base' => '<p>Includes the list of references to legal resources proposed by the proposer to the acceptor. Each <code>DocumentItem</code> refers to an individual reference.</p>', 'refs' => [ 'DocumentList$member' => NULL, ], ], 'DocumentList' => [ 'base' => NULL, 'refs' => [ 'LegalTerm$documents' => '<p>List of references to legal resources proposed to the buyers. An example is the EULA.</p>', ], ], 'EstimatedCharges' => [ 'base' => '<p>Estimated cost of the agreement.</p>', 'refs' => [ 'DescribeAgreementOutput$estimatedCharges' => '<p>The estimated cost of the agreement.</p>', ], ], 'ExceptionMessage' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'InternalServerException$message' => NULL, 'ResourceNotFoundException$message' => NULL, 'ThrottlingException$message' => NULL, 'ValidationException$message' => NULL, ], ], 'Filter' => [ 'base' => '<p>The filter name and value pair that is used to return a more specific list of results. Filters can be used to match a set of resources by various criteria, such as <code>offerId</code> or <code>productId</code>.</p>', 'refs' => [ 'FilterList$member' => NULL, ], ], 'FilterList' => [ 'base' => NULL, 'refs' => [ 'SearchAgreementsInput$filters' => '<p>The filter name and value pair used to return a specific list of results.</p> <p>The following filters are supported:</p> <ul> <li> <p> <code>ResourceIdentifier</code> – The unique identifier of the resource.</p> </li> <li> <p> <code>ResourceType</code> – Type of the resource, which is the product (<code>AmiProduct</code>, <code>ContainerProduct</code>, or <code>SaaSProduct</code>).</p> </li> <li> <p> <code>PartyType</code> – The party type (either <code>Acceptor</code> or <code>Proposer</code>) of the caller. For agreements where the caller is the proposer, use the <code>Proposer</code> filter. For agreements where the caller is the acceptor, use the <code>Acceptor</code> filter.</p> </li> <li> <p> <code>AcceptorAccountId</code> – The AWS account ID of the party accepting the agreement terms.</p> </li> <li> <p> <code>OfferId</code> – The unique identifier of the offer in which the terms are registered in the agreement token.</p> </li> <li> <p> <code>Status</code> – The current status of the agreement. Values include <code>ACTIVE</code>, <code>ARCHIVED</code>, <code>CANCELLED</code>, <code>EXPIRED</code>, <code>RENEWED</code>, <code>REPLACED</code>, and <code>TERMINATED</code>.</p> </li> <li> <p> <code>BeforeEndTime</code> – A date used to filter agreements with a date before the <code>endTime</code> of an agreement.</p> </li> <li> <p> <code>AfterEndTime</code> – A date used to filter agreements with a date after the <code>endTime</code> of an agreement.</p> </li> <li> <p> <code>AgreementType</code> – The type of agreement. Values include <code>PurchaseAgreement</code> or <code>VendorInsightsAgreement</code>.</p> </li> </ul>', ], ], 'FilterName' => [ 'base' => NULL, 'refs' => [ 'Filter$name' => '<p>The name of the filter.</p>', ], ], 'FilterValue' => [ 'base' => NULL, 'refs' => [ 'FilterValueList$member' => NULL, ], ], 'FilterValueList' => [ 'base' => NULL, 'refs' => [ 'Filter$values' => '<p>The filter value.</p>', ], ], 'FixedUpfrontPricingTerm' => [ 'base' => '<p>Defines a prepaid pricing model where the customers are charged a fixed upfront amount.</p>', 'refs' => [ 'AcceptedTerm$fixedUpfrontPricingTerm' => '<p>Defines a pre-paid pricing model where the customers are charged a fixed upfront amount.</p>', ], ], 'FreeTrialPricingTerm' => [ 'base' => '<p>Defines a short-term free pricing model where the buyers aren’t charged anything within a specified limit.</p>', 'refs' => [ 'AcceptedTerm$freeTrialPricingTerm' => '<p>Defines a short-term free pricing model where the buyers aren’t charged anything within a specified limit.</p>', ], ], 'GetAgreementTermsInput' => [ 'base' => NULL, 'refs' => [], ], 'GetAgreementTermsOutput' => [ 'base' => NULL, 'refs' => [], ], 'GrantItem' => [ 'base' => '<p>Entitlements granted to the acceptor of fixed upfront as part of agreement execution.</p>', 'refs' => [ 'GrantList$member' => NULL, ], ], 'GrantList' => [ 'base' => NULL, 'refs' => [ 'FixedUpfrontPricingTerm$grants' => '<p>Entitlements granted to the acceptor of fixed upfront as part of agreement execution.</p>', 'FreeTrialPricingTerm$grants' => '<p>Entitlements granted to the acceptor of a free trial as part of an agreement execution.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>Unexpected error during processing of request.</p>', 'refs' => [], ], 'LegalTerm' => [ 'base' => '<p>Defines the list of text agreements proposed to the acceptors. An example is the end user license agreement (EULA).</p>', 'refs' => [ 'AcceptedTerm$legalTerm' => '<p>Defines the list of text agreements proposed to the acceptors. An example is the end user license agreement (EULA).</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'GetAgreementTermsInput$maxResults' => '<p>The maximum number of agreements to return in the response.</p>', 'SearchAgreementsInput$maxResults' => '<p>The maximum number of agreements to return in the response.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'GetAgreementTermsInput$nextToken' => '<p>A token to specify where to start pagination</p>', 'GetAgreementTermsOutput$nextToken' => '<p>A token to specify where to start pagination</p>', 'SearchAgreementsInput$nextToken' => '<p>A token to specify where to start pagination.</p>', 'SearchAgreementsOutput$nextToken' => '<p>The token used for pagination. The field is <code>null</code> if there are no more results.</p>', ], ], 'OfferId' => [ 'base' => NULL, 'refs' => [ 'ProposalSummary$offerId' => '<p>The unique identifier of the offer in AWS Marketplace.</p>', ], ], 'PaymentScheduleTerm' => [ 'base' => '<p>Defines an installment-based pricing model where customers are charged a fixed price on different dates during the agreement validity period. This is used most commonly for flexible payment schedule pricing.</p>', 'refs' => [ 'AcceptedTerm$paymentScheduleTerm' => '<p>Defines an installment-based pricing model where customers are charged a fixed price on different dates during the agreement validity period. This is used most commonly for flexible payment schedule pricing.</p>', ], ], 'PositiveIntegerWithDefaultValueOne' => [ 'base' => NULL, 'refs' => [ 'GrantItem$maxQuantity' => '<p>Maximum amount of capacity that the buyer can be entitled to the given dimension of the product. If <code>MaxQuantity</code> is not provided, the buyer will be able to use an unlimited amount of the given dimension. </p>', ], ], 'ProposalSummary' => [ 'base' => '<p>A summary of the proposal received from the proposer.</p>', 'refs' => [ 'AgreementViewSummary$proposalSummary' => '<p>A summary of the proposal</p>', 'DescribeAgreementOutput$proposalSummary' => '<p>A summary of the proposal received from the proposer.</p>', ], ], 'Proposer' => [ 'base' => '<p>Details of the party proposing the agreement terms,. This is commonly the seller for <code>PurchaseAgreement</code>. </p>', 'refs' => [ 'AgreementViewSummary$proposer' => '<p>Details of the party proposing the agreement terms, most commonly the seller for <code>PurchaseAgreement</code>.</p>', 'DescribeAgreementOutput$proposer' => '<p>The details of the party proposing the agreement terms. This is commonly the seller for <code>PurchaseAgreement</code>.</p>', ], ], 'RateCardItem' => [ 'base' => '<p>Defines the per unit rates for each individual product dimension.</p>', 'refs' => [ 'RateCardList$member' => NULL, ], ], 'RateCardList' => [ 'base' => NULL, 'refs' => [ 'ConfigurableUpfrontRateCardItem$rateCard' => '<p>Defines the per unit rates for product dimensions.</p>', 'UsageBasedRateCardItem$rateCard' => '<p>Defines the per unit rates for product dimensions.</p>', ], ], 'RecurringPaymentTerm' => [ 'base' => '<p>Defines a pricing model where customers are charged a fixed recurring price at the end of each billing period.</p>', 'refs' => [ 'AcceptedTerm$recurringPaymentTerm' => '<p>Defines a pricing model where customers are charged a fixed recurring price at the end of each billing period.</p>', ], ], 'RenewalTerm' => [ 'base' => '<p>Defines that on graceful expiration of the agreement (when the agreement ends on its pre-defined end date), a new agreement will be created using the accepted terms on the existing agreement. In other words, the agreement will be renewed. The presence of <code>RenewalTerm</code> in the offer document means that auto-renewal is allowed. Buyers will have the option to accept or decline auto-renewal at the offer acceptance/agreement creation. Buyers can also change this flag from <code>True</code> to <code>False</code> or <code>False</code> to <code>True</code> at anytime during the agreement\'s lifecycle.</p>', 'refs' => [ 'AcceptedTerm$renewalTerm' => '<p>Defines that on graceful expiration of the agreement (when the agreement ends on its pre-defined end date), a new agreement will be created using the accepted terms on the existing agreement. In other words, the agreement will be renewed. Presence of <code>RenewalTerm</code> in the offer document means that auto-renewal is allowed. Buyers will have the option to accept or decline auto-renewal at the offer acceptance/agreement creation. Buyers can also change this flag from <code>True</code> to <code>False</code> or <code>False</code> to <code>True</code> at anytime during the agreement\'s lifecycle.</p>', ], ], 'RenewalTermConfiguration' => [ 'base' => '<p>Additional parameters specified by the acceptor while accepting the term.</p>', 'refs' => [ 'RenewalTerm$configuration' => '<p>Additional parameters specified by the acceptor while accepting the term.</p>', ], ], 'RequestId' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$requestId' => '<p>The unique identifier for the error.</p>', 'InternalServerException$requestId' => '<p>The unique identifier for the error.</p>', 'ResourceNotFoundException$requestId' => '<p>The unique identifier for the error.</p>', 'ThrottlingException$requestId' => '<p>The unique identifier for the error.</p>', 'ValidationException$requestId' => '<p>The unique identifier associated with the error.</p>', ], ], 'Resource' => [ 'base' => '<p>The list of resources involved in the agreement.</p>', 'refs' => [ 'Resources$member' => NULL, ], ], 'ResourceId' => [ 'base' => NULL, 'refs' => [ 'AgreementViewSummary$agreementId' => '<p>The unique identifier of the agreement.</p>', 'DescribeAgreementInput$agreementId' => '<p>The unique identifier of the agreement.</p>', 'DescribeAgreementOutput$agreementId' => '<p>The unique identifier of the agreement.</p>', 'GetAgreementTermsInput$agreementId' => '<p>The unique identifier of the agreement.</p>', 'Resource$id' => '<p>The unique identifier of the resource.</p> <note> <p>We mention the term resource, which is most commonly a product, so a <code>resourceId</code> is also a <code>productId</code>.</p> </note>', 'ResourceNotFoundException$resourceId' => '<p>The unique identifier for the resource.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>Request references a resource which does not exist.</p>', 'refs' => [], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'ResourceNotFoundException$resourceType' => '<p>The type of resource.</p>', ], ], 'Resources' => [ 'base' => NULL, 'refs' => [ 'ProposalSummary$resources' => '<p>The list of resources involved in the agreement.</p>', ], ], 'ScheduleItem' => [ 'base' => '<p>An individual installment of the payment that includes the date and amount of the charge.</p>', 'refs' => [ 'ScheduleList$member' => NULL, ], ], 'ScheduleList' => [ 'base' => NULL, 'refs' => [ 'PaymentScheduleTerm$schedule' => '<p>List of the payment schedule where each element defines one installment of payment. It contains the information necessary for calculating the price.</p>', ], ], 'SearchAgreementsInput' => [ 'base' => NULL, 'refs' => [], ], 'SearchAgreementsOutput' => [ 'base' => NULL, 'refs' => [], ], 'Selector' => [ 'base' => '<p>Differentiates between the mutually exclusive rate cards in the same pricing term to be selected by the buyer.</p>', 'refs' => [ 'ConfigurableUpfrontRateCardItem$selector' => '<p>Differentiates between the mutually exclusive rate cards in the same pricing term to be selected by the buyer.</p>', ], ], 'Sort' => [ 'base' => '<p>An object that contains the <code>SortBy</code> and <code>SortOrder</code> attributes.</p>', 'refs' => [ 'SearchAgreementsInput$sort' => '<p>An object that contains the <code>SortBy</code> and <code>SortOrder</code> attributes.</p>', ], ], 'SortBy' => [ 'base' => NULL, 'refs' => [ 'Sort$sortBy' => '<p>The attribute on which the data is grouped, which can be by <code>StartTime</code> and <code>EndTime</code>. The default value is <code>EndTime</code>.</p>', ], ], 'SortOrder' => [ 'base' => NULL, 'refs' => [ 'Sort$sortOrder' => '<p>The sorting order, which can be <code>ASCENDING</code> or <code>DESCENDING</code>. The default value is <code>DESCENDING</code>.</p>', ], ], 'SupportTerm' => [ 'base' => '<p>Defines the customer support available for the acceptors when they purchase the software.</p>', 'refs' => [ 'AcceptedTerm$supportTerm' => '<p>Defines the customer support available for the acceptors when they purchase the software.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>Request was denied due to request throttling.</p>', 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'AgreementViewSummary$acceptanceTime' => '<p>The date and time that the agreement was accepted.</p>', 'AgreementViewSummary$endTime' => '<p>The date and time when the agreement ends. The field is <code>null</code> for pay-as-you-go agreements, which don’t have end dates.</p>', 'AgreementViewSummary$startTime' => '<p>The date and time when the agreement starts.</p>', 'DescribeAgreementOutput$acceptanceTime' => '<p>The date and time the offer was accepted or the agreement was created.</p> <note> <p> <code>AcceptanceTime</code> and <code>StartTime</code> can differ for future dated agreements (FDAs).</p> </note>', 'DescribeAgreementOutput$endTime' => '<p>The date and time when the agreement ends. The field is <code>null</code> for pay-as-you-go agreements, which don’t have end dates.</p>', 'DescribeAgreementOutput$startTime' => '<p>The date and time when the agreement starts.</p>', 'ScheduleItem$chargeDate' => '<p>The date that the customer would pay the price defined in this payment schedule term. Invoices are generated on the date provided.</p>', 'ValidityTerm$agreementEndDate' => '<p>Defines the date when the agreement ends. The agreement ends at 23:59:59.999 UTC on the date provided. If <code>AgreementEndDate</code> isn’t provided, the agreement end date is determined by the validity of individual terms.</p>', 'ValidityTerm$agreementStartDate' => '<p>Defines the date when agreement starts. The agreement starts at 00:00:00.000 UTC on the date provided. If <code>AgreementStartDate</code> isn’t provided, the agreement start date is determined based on agreement signature time.</p>', ], ], 'UnversionedTermType' => [ 'base' => NULL, 'refs' => [ 'ByolPricingTerm$type' => '<p>Type of the term being updated.</p>', 'ConfigurableUpfrontPricingTerm$type' => '<p>Category of selector.</p>', 'FixedUpfrontPricingTerm$type' => '<p>Category of the term being updated.</p>', 'FreeTrialPricingTerm$type' => '<p>Category of the term.</p>', 'LegalTerm$type' => '<p>Category of the term being updated.</p>', 'PaymentScheduleTerm$type' => '<p>Type of the term.</p>', 'RecurringPaymentTerm$type' => '<p>Type of the term being updated.</p>', 'RenewalTerm$type' => '<p>Category of the term being updated. </p>', 'SupportTerm$type' => '<p>Category of the term being updated.</p>', 'UsageBasedPricingTerm$type' => '<p>Category of the term.</p>', 'ValidityTerm$type' => '<p>Category of the term being updated. </p>', ], ], 'UsageBasedPricingTerm' => [ 'base' => '<p>Defines a usage-based pricing model (typically, pay-as-you-go pricing), where the customers are charged based on product usage.</p>', 'refs' => [ 'AcceptedTerm$usageBasedPricingTerm' => '<p>Defines a usage-based pricing model (typically, pay-as-you-go pricing), where the customers are charged based on product usage.</p>', ], ], 'UsageBasedRateCardItem' => [ 'base' => '<p>Within the pay-as-you-go model defined under <code>UsageBasedPricingTerm</code>, the <code>UsageBasedRateCardItem</code> defines an individual rate for a product dimension.</p>', 'refs' => [ 'UsageBasedRateCardList$member' => NULL, ], ], 'UsageBasedRateCardList' => [ 'base' => NULL, 'refs' => [ 'UsageBasedPricingTerm$rateCards' => '<p>List of rate cards.</p>', ], ], 'ValidationException' => [ 'base' => '<p>The input fails to satisfy the constraints specified by the service.</p>', 'refs' => [], ], 'ValidationExceptionField' => [ 'base' => '<p>The input fails to satisfy the constraints specified by the service.</p>', 'refs' => [ 'ValidationExceptionFieldList$member' => NULL, ], ], 'ValidationExceptionFieldList' => [ 'base' => NULL, 'refs' => [ 'ValidationException$fields' => '<p>The fields associated with the error.</p>', ], ], 'ValidationExceptionReason' => [ 'base' => NULL, 'refs' => [ 'ValidationException$reason' => '<p>The reason associated with the error.</p>', ], ], 'ValidityTerm' => [ 'base' => '<p>Defines the conditions that will keep an agreement created from this offer valid. </p>', 'refs' => [ 'AcceptedTerm$validityTerm' => '<p>Defines the conditions that will keep an agreement created from this offer valid.</p>', ], ], 'ZeroValueInteger' => [ 'base' => NULL, 'refs' => [ 'Dimension$dimensionValue' => '<p>The number of units of the dimension the acceptor has purchased.</p> <note> <p>For Agreements with <code>ConfigurableUpfrontPricingTerm</code>, the <code>RateCard</code> section will define the prices and dimensions defined by the seller (proposer), whereas the <code>Configuration</code> section will define the actual dimensions, prices, and units the buyer has chosen to accept.</p> </note>', ], ], ],];
