<?php
// This file was auto-generated from sdk-root/src/data/migrationhuborchestrator/2021-08-28/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>This API reference provides descriptions, syntax, and other details about each of the actions and data types for AWS Migration Hub Orchestrator. The topic for each action shows the API request parameters and responses. Alternatively, you can use one of the AWS SDKs to access an API that is tailored to the programming language or platform that you\'re using.</p>', 'operations' => [ 'CreateTemplate' => '<p>Creates a migration workflow template.</p>', 'CreateWorkflow' => '<p>Create a workflow to orchestrate your migrations.</p>', 'CreateWorkflowStep' => '<p>Create a step in the migration workflow.</p>', 'CreateWorkflowStepGroup' => '<p>Create a step group in a migration workflow.</p>', 'DeleteTemplate' => '<p>Deletes a migration workflow template.</p>', 'DeleteWorkflow' => '<p>Delete a migration workflow. You must pause a running workflow in Migration Hub Orchestrator console to delete it.</p>', 'DeleteWorkflowStep' => '<p>Delete a step in a migration workflow. Pause the workflow to delete a running step.</p>', 'DeleteWorkflowStepGroup' => '<p>Delete a step group in a migration workflow.</p>', 'GetTemplate' => '<p>Get the template you want to use for creating a migration workflow.</p>', 'GetTemplateStep' => '<p>Get a specific step in a template.</p>', 'GetTemplateStepGroup' => '<p>Get a step group in a template.</p>', 'GetWorkflow' => '<p>Get migration workflow.</p>', 'GetWorkflowStep' => '<p>Get a step in the migration workflow.</p>', 'GetWorkflowStepGroup' => '<p>Get the step group of a migration workflow.</p>', 'ListPlugins' => '<p>List AWS Migration Hub Orchestrator plugins.</p>', 'ListTagsForResource' => '<p>List the tags added to a resource.</p>', 'ListTemplateStepGroups' => '<p>List the step groups in a template.</p>', 'ListTemplateSteps' => '<p>List the steps in a template.</p>', 'ListTemplates' => '<p>List the templates available in Migration Hub Orchestrator to create a migration workflow.</p>', 'ListWorkflowStepGroups' => '<p>List the step groups in a migration workflow.</p>', 'ListWorkflowSteps' => '<p>List the steps in a workflow.</p>', 'ListWorkflows' => '<p>List the migration workflows.</p>', 'RetryWorkflowStep' => '<p>Retry a failed step in a migration workflow.</p>', 'StartWorkflow' => '<p>Start a migration workflow.</p>', 'StopWorkflow' => '<p>Stop an ongoing migration workflow.</p>', 'TagResource' => '<p>Tag a resource by specifying its Amazon Resource Name (ARN).</p>', 'UntagResource' => '<p>Deletes the tags for a resource.</p>', 'UpdateTemplate' => '<p>Updates a migration workflow template.</p>', 'UpdateWorkflow' => '<p>Update a migration workflow.</p>', 'UpdateWorkflowStep' => '<p>Update a step in a migration workflow.</p>', 'UpdateWorkflowStepGroup' => '<p>Update the step group in a migration workflow.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You do not have sufficient access to perform this action.</p>', 'refs' => [], ], 'ApplicationConfigurationName' => [ 'base' => NULL, 'refs' => [ 'ListMigrationWorkflowsRequest$adsApplicationConfigurationName' => '<p>The name of the application configured in Application Discovery Service.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'StepOutput$required' => '<p>Determine if an output is required from a step.</p>', 'TemplateInput$required' => '<p>Determine if an input is required from the template.</p>', 'WorkflowStepOutput$required' => '<p>Determine if an output is required from a step.</p>', ], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'CreateTemplateRequest$clientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://smithy.io/2.0/spec/behavior-traits.html#idempotencytoken-trait">Idempotency</a> in the Smithy documentation.</p>', 'UpdateTemplateRequest$clientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', ], ], 'ConflictException' => [ 'base' => '<p>This exception is thrown when an attempt to update or delete a resource would cause an inconsistent state.</p>', 'refs' => [], ], 'CreateMigrationWorkflowRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateMigrationWorkflowRequestApplicationConfigurationIdString' => [ 'base' => NULL, 'refs' => [ 'CreateMigrationWorkflowRequest$applicationConfigurationId' => '<p>The configuration ID of the application configured in Application Discovery Service.</p>', ], ], 'CreateMigrationWorkflowRequestDescriptionString' => [ 'base' => NULL, 'refs' => [ 'CreateMigrationWorkflowRequest$description' => '<p>The description of the migration workflow.</p>', ], ], 'CreateMigrationWorkflowRequestNameString' => [ 'base' => NULL, 'refs' => [ 'CreateMigrationWorkflowRequest$name' => '<p>The name of the migration workflow.</p>', ], ], 'CreateMigrationWorkflowRequestTemplateIdString' => [ 'base' => NULL, 'refs' => [ 'CreateMigrationWorkflowRequest$templateId' => '<p>The ID of the template.</p>', ], ], 'CreateMigrationWorkflowResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTemplateRequestTemplateDescriptionString' => [ 'base' => NULL, 'refs' => [ 'CreateTemplateRequest$templateDescription' => '<p>A description of the migration workflow template.</p>', ], ], 'CreateTemplateRequestTemplateNameString' => [ 'base' => NULL, 'refs' => [ 'CreateTemplateRequest$templateName' => '<p>The name of the migration workflow template.</p>', ], ], 'CreateTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateWorkflowStepGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateWorkflowStepGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateWorkflowStepRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateWorkflowStepResponse' => [ 'base' => NULL, 'refs' => [], ], 'DataType' => [ 'base' => NULL, 'refs' => [ 'StepOutput$dataType' => '<p>The data type of the step output.</p>', 'TemplateInput$dataType' => '<p>The data type of the template input.</p>', 'WorkflowStepOutput$dataType' => '<p>The data type of the output.</p>', ], ], 'DeleteMigrationWorkflowRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMigrationWorkflowResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWorkflowStepGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWorkflowStepGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWorkflowStepRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWorkflowStepResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetMigrationWorkflowRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMigrationWorkflowResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetMigrationWorkflowTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMigrationWorkflowTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetTemplateStepGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetTemplateStepGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetTemplateStepRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetTemplateStepResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetWorkflowStepGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetWorkflowStepGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetWorkflowStepRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetWorkflowStepResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetWorkflowStepResponseOutputsList' => [ 'base' => NULL, 'refs' => [ 'GetWorkflowStepResponse$outputs' => '<p>The outputs of the step.</p>', ], ], 'IPAddress' => [ 'base' => NULL, 'refs' => [ 'PluginSummary$ipAddress' => '<p>The IP address at which the plugin is located.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'GetMigrationWorkflowResponse$totalSteps' => '<p>The total number of steps in the migration workflow.</p>', 'GetMigrationWorkflowResponse$completedSteps' => '<p>Get a list of completed steps in the migration workflow.</p>', 'GetWorkflowStepResponse$noOfSrvCompleted' => '<p>The number of servers that have been migrated.</p>', 'GetWorkflowStepResponse$noOfSrvFailed' => '<p>The number of servers that have failed to migrate.</p>', 'GetWorkflowStepResponse$totalNoOfSrv' => '<p>The total number of servers that have been migrated.</p>', 'MigrationWorkflowSummary$completedSteps' => '<p>The steps completed in the migration workflow.</p>', 'MigrationWorkflowSummary$totalSteps' => '<p>All the steps in a migration workflow.</p>', 'StepInput$integerValue' => '<p>The value of the integer.</p>', 'WorkflowStepOutputUnion$integerValue' => '<p>The integer value. </p>', 'WorkflowStepSummary$noOfSrvCompleted' => '<p>The number of servers that have been migrated.</p>', 'WorkflowStepSummary$noOfSrvFailed' => '<p>The number of servers that have failed to migrate.</p>', 'WorkflowStepSummary$totalNoOfSrv' => '<p>The total number of servers that have been migrated.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>An internal error has occurred.</p>', 'refs' => [], ], 'ListMigrationWorkflowTemplatesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListMigrationWorkflowTemplatesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListMigrationWorkflowsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListMigrationWorkflowsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPluginsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPluginsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTemplateStepGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTemplateStepGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTemplateStepsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTemplateStepsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkflowStepGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkflowStepGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkflowStepsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkflowStepsResponse' => [ 'base' => NULL, 'refs' => [], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListMigrationWorkflowTemplatesRequest$maxResults' => '<p>The maximum number of results that can be returned.</p>', 'ListMigrationWorkflowsRequest$maxResults' => '<p>The maximum number of results that can be returned.</p>', 'ListPluginsRequest$maxResults' => '<p>The maximum number of plugins that can be returned.</p>', 'ListTemplateStepGroupsRequest$maxResults' => '<p>The maximum number of results that can be returned.</p>', 'ListTemplateStepsRequest$maxResults' => '<p>The maximum number of results that can be returned.</p>', 'ListWorkflowStepGroupsRequest$maxResults' => '<p>The maximum number of results that can be returned.</p>', 'ListWorkflowStepsRequest$maxResults' => '<p>The maximum number of results that can be returned.</p>', ], ], 'MaxStringList' => [ 'base' => NULL, 'refs' => [ 'WorkflowStepOutputUnion$listOfStringValue' => '<p>The list of string value.</p>', ], ], 'MaxStringValue' => [ 'base' => NULL, 'refs' => [ 'MaxStringList$member' => NULL, 'WorkflowStepOutputUnion$stringValue' => '<p>The string value.</p>', ], ], 'MigrationWorkflowDescription' => [ 'base' => NULL, 'refs' => [ 'CreateWorkflowStepRequest$description' => '<p>The description of the step.</p>', ], ], 'MigrationWorkflowId' => [ 'base' => NULL, 'refs' => [ 'CreateMigrationWorkflowResponse$id' => '<p>The ID of the migration workflow.</p>', 'CreateWorkflowStepGroupRequest$workflowId' => '<p>The ID of the migration workflow that will contain the step group.</p>', 'CreateWorkflowStepRequest$workflowId' => '<p>The ID of the migration workflow.</p>', 'DeleteMigrationWorkflowRequest$id' => '<p>The ID of the migration workflow you want to delete.</p>', 'DeleteMigrationWorkflowResponse$id' => '<p>The ID of the migration workflow.</p>', 'DeleteWorkflowStepGroupRequest$workflowId' => '<p>The ID of the migration workflow.</p>', 'DeleteWorkflowStepRequest$workflowId' => '<p>The ID of the migration workflow.</p>', 'GetMigrationWorkflowRequest$id' => '<p>The ID of the migration workflow.</p>', 'GetMigrationWorkflowResponse$id' => '<p>The ID of the migration workflow.</p>', 'GetWorkflowStepGroupRequest$workflowId' => '<p>The ID of the migration workflow.</p>', 'GetWorkflowStepRequest$workflowId' => '<p>The ID of the migration workflow.</p>', 'ListWorkflowStepGroupsRequest$workflowId' => '<p>The ID of the migration workflow.</p>', 'ListWorkflowStepsRequest$workflowId' => '<p>The ID of the migration workflow.</p>', 'MigrationWorkflowSummary$id' => '<p>The ID of the migration workflow.</p>', 'RetryWorkflowStepRequest$workflowId' => '<p>The ID of the migration workflow.</p>', 'StartMigrationWorkflowRequest$id' => '<p>The ID of the migration workflow.</p>', 'StartMigrationWorkflowResponse$id' => '<p>The ID of the migration workflow.</p>', 'StopMigrationWorkflowRequest$id' => '<p>The ID of the migration workflow.</p>', 'StopMigrationWorkflowResponse$id' => '<p>The ID of the migration workflow.</p>', 'TemplateSource$workflowId' => '<p>The ID of the workflow from the source migration workflow template.</p>', 'UpdateMigrationWorkflowRequest$id' => '<p>The ID of the migration workflow.</p>', 'UpdateMigrationWorkflowResponse$id' => '<p>The ID of the migration workflow.</p>', 'UpdateWorkflowStepGroupRequest$workflowId' => '<p>The ID of the migration workflow.</p>', 'UpdateWorkflowStepRequest$workflowId' => '<p>The ID of the migration workflow.</p>', ], ], 'MigrationWorkflowName' => [ 'base' => NULL, 'refs' => [ 'CreateWorkflowStepRequest$name' => '<p>The name of the step.</p>', ], ], 'MigrationWorkflowStatusEnum' => [ 'base' => NULL, 'refs' => [ 'CreateMigrationWorkflowResponse$status' => '<p>The status of the migration workflow.</p>', 'DeleteMigrationWorkflowResponse$status' => '<p>The status of the migration workflow.</p>', 'GetMigrationWorkflowResponse$status' => '<p>The status of the migration workflow.</p>', 'ListMigrationWorkflowsRequest$status' => '<p>The status of the migration workflow.</p>', 'MigrationWorkflowSummary$status' => '<p>The status of the migration workflow.</p>', 'StartMigrationWorkflowResponse$status' => '<p>The status of the migration workflow.</p>', 'StopMigrationWorkflowResponse$status' => '<p>The status of the migration workflow.</p>', 'UpdateMigrationWorkflowResponse$status' => '<p>The status of the migration workflow.</p>', ], ], 'MigrationWorkflowSummary' => [ 'base' => '<p>The summary of a migration workflow.</p>', 'refs' => [ 'MigrationWorkflowSummaryList$member' => NULL, ], ], 'MigrationWorkflowSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListMigrationWorkflowsResponse$migrationWorkflowSummary' => '<p>The summary of the migration workflow.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListMigrationWorkflowTemplatesRequest$nextToken' => '<p>The pagination token.</p>', 'ListMigrationWorkflowTemplatesResponse$nextToken' => '<p>The pagination token.</p>', 'ListMigrationWorkflowsRequest$nextToken' => '<p>The pagination token.</p>', 'ListMigrationWorkflowsResponse$nextToken' => '<p>The pagination token.</p>', 'ListPluginsRequest$nextToken' => '<p>The pagination token.</p>', 'ListPluginsResponse$nextToken' => '<p>The pagination token.</p>', 'ListTemplateStepGroupsRequest$nextToken' => '<p>The pagination token.</p>', 'ListTemplateStepGroupsResponse$nextToken' => '<p>The pagination token.</p>', 'ListTemplateStepsRequest$nextToken' => '<p>The pagination token.</p>', 'ListTemplateStepsResponse$nextToken' => '<p>The pagination token.</p>', 'ListWorkflowStepGroupsRequest$nextToken' => '<p>The pagination token.</p>', 'ListWorkflowStepGroupsResponse$nextToken' => '<p>The pagination token.</p>', 'ListWorkflowStepsRequest$nextToken' => '<p>The pagination token.</p>', 'ListWorkflowStepsResponse$nextToken' => '<p>The pagination token.</p>', ], ], 'Owner' => [ 'base' => NULL, 'refs' => [ 'GetWorkflowStepGroupResponse$owner' => '<p>The owner of the step group.</p>', 'GetWorkflowStepResponse$owner' => '<p>The owner of the step.</p>', 'TemplateStepSummary$owner' => '<p>The owner of the step.</p>', 'WorkflowStepGroupSummary$owner' => '<p>The owner of the step group.</p>', 'WorkflowStepSummary$owner' => '<p>The owner of the step.</p>', ], ], 'PlatformCommand' => [ 'base' => '<p>Command to be run on a particular operating system.</p>', 'refs' => [ 'StepAutomationConfiguration$command' => '<p>The command to run the script.</p>', 'WorkflowStepAutomationConfiguration$command' => '<p>The command required to run the script.</p>', ], ], 'PlatformScriptKey' => [ 'base' => '<p>The script location for a particular operating system.</p>', 'refs' => [ 'StepAutomationConfiguration$scriptLocationS3Key' => '<p>The Amazon S3 key for the script location.</p>', 'WorkflowStepAutomationConfiguration$scriptLocationS3Key' => '<p>The Amazon S3 key for the script location.</p>', ], ], 'PluginHealth' => [ 'base' => NULL, 'refs' => [ 'PluginSummary$status' => '<p>The status of the plugin.</p>', ], ], 'PluginId' => [ 'base' => NULL, 'refs' => [ 'PluginSummary$pluginId' => '<p>The ID of the plugin.</p>', ], ], 'PluginSummaries' => [ 'base' => NULL, 'refs' => [ 'ListPluginsResponse$plugins' => '<p>Migration Hub Orchestrator plugins.</p>', ], ], 'PluginSummary' => [ 'base' => '<p>The summary of the Migration Hub Orchestrator plugin.</p>', 'refs' => [ 'PluginSummaries$member' => NULL, ], ], 'PluginVersion' => [ 'base' => NULL, 'refs' => [ 'PluginSummary$version' => '<p>The version of the plugin.</p>', ], ], 'ResourceArn' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'TagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource to which you want to add tags.</p>', 'UntagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource from which you want to remove tags.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The resource is not available.</p>', 'refs' => [], ], 'RetryWorkflowStepRequest' => [ 'base' => NULL, 'refs' => [], ], 'RetryWorkflowStepResponse' => [ 'base' => NULL, 'refs' => [], ], 'RunEnvironment' => [ 'base' => NULL, 'refs' => [ 'StepAutomationConfiguration$runEnvironment' => '<p>The source or target environment.</p>', 'WorkflowStepAutomationConfiguration$runEnvironment' => '<p>The source or target environment.</p>', ], ], 'S3Bucket' => [ 'base' => NULL, 'refs' => [ 'WorkflowStepAutomationConfiguration$scriptLocationS3Bucket' => '<p>The Amazon S3 bucket where the script is located.</p>', ], ], 'S3Key' => [ 'base' => NULL, 'refs' => [ 'PlatformScriptKey$linux' => '<p>The script location for Linux.</p>', 'PlatformScriptKey$windows' => '<p>The script location for Windows.</p>', ], ], 'StartMigrationWorkflowRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartMigrationWorkflowResponse' => [ 'base' => NULL, 'refs' => [], ], 'StepActionType' => [ 'base' => NULL, 'refs' => [ 'CreateWorkflowStepRequest$stepActionType' => '<p>The action type of the step. You must run and update the status of a manual step for the workflow to continue after the completion of the step.</p>', 'GetTemplateStepResponse$stepActionType' => '<p>The action type of the step. You must run and update the status of a manual step for the workflow to continue after the completion of the step.</p>', 'GetWorkflowStepResponse$stepActionType' => '<p>The action type of the step. You must run and update the status of a manual step for the workflow to continue after the completion of the step.</p>', 'TemplateStepSummary$stepActionType' => '<p>The action type of the step. You must run and update the status of a manual step for the workflow to continue after the completion of the step.</p>', 'UpdateWorkflowStepRequest$stepActionType' => '<p>The action type of the step. You must run and update the status of a manual step for the workflow to continue after the completion of the step.</p>', 'WorkflowStepSummary$stepActionType' => '<p>The action type of the step. You must run and update the status of a manual step for the workflow to continue after the completion of the step.</p>', ], ], 'StepAutomationConfiguration' => [ 'base' => '<p>The custom script to run tests on source or target environments.</p>', 'refs' => [ 'GetTemplateStepResponse$stepAutomationConfiguration' => '<p>The custom script to run tests on source or target environments.</p>', ], ], 'StepDescription' => [ 'base' => NULL, 'refs' => [ 'UpdateWorkflowStepRequest$description' => '<p>The description of the step.</p>', ], ], 'StepGroupDescription' => [ 'base' => NULL, 'refs' => [ 'CreateWorkflowStepGroupRequest$description' => '<p>The description of the step group.</p>', 'UpdateWorkflowStepGroupRequest$description' => '<p>The description of the step group.</p>', ], ], 'StepGroupId' => [ 'base' => NULL, 'refs' => [ 'CreateWorkflowStepRequest$stepGroupId' => '<p>The ID of the step group.</p>', 'DeleteWorkflowStepGroupRequest$id' => '<p>The ID of the step group you want to delete.</p>', 'DeleteWorkflowStepRequest$stepGroupId' => '<p>The ID of the step group that contains the step you want to delete.</p>', 'GetTemplateStepGroupRequest$id' => '<p>The ID of the step group.</p>', 'GetTemplateStepRequest$stepGroupId' => '<p>The ID of the step group.</p>', 'GetTemplateStepResponse$stepGroupId' => '<p>The ID of the step group.</p>', 'GetWorkflowStepGroupRequest$id' => '<p>The ID of the step group.</p>', 'GetWorkflowStepGroupResponse$id' => '<p>The ID of the step group.</p>', 'GetWorkflowStepRequest$stepGroupId' => '<p>The ID of the step group.</p>', 'ListTemplateStepsRequest$stepGroupId' => '<p>The ID of the step group.</p>', 'ListWorkflowStepsRequest$stepGroupId' => '<p>The ID of the step group.</p>', 'RetryWorkflowStepRequest$stepGroupId' => '<p>The ID of the step group.</p>', 'UpdateWorkflowStepGroupRequest$id' => '<p>The ID of the step group.</p>', 'UpdateWorkflowStepRequest$stepGroupId' => '<p>The ID of the step group.</p>', ], ], 'StepGroupName' => [ 'base' => NULL, 'refs' => [ 'CreateWorkflowStepGroupRequest$name' => '<p>The name of the step group.</p>', 'UpdateWorkflowStepGroupRequest$name' => '<p>The name of the step group.</p>', ], ], 'StepGroupStatus' => [ 'base' => NULL, 'refs' => [ 'GetTemplateStepGroupResponse$status' => '<p>The status of the step group.</p>', 'GetWorkflowStepGroupResponse$status' => '<p>The status of the step group.</p>', 'WorkflowStepGroupSummary$status' => '<p>The status of the step group.</p>', ], ], 'StepId' => [ 'base' => NULL, 'refs' => [ 'DeleteWorkflowStepRequest$id' => '<p>The ID of the step you want to delete.</p>', 'GetTemplateStepRequest$id' => '<p>The ID of the step.</p>', 'GetTemplateStepResponse$id' => '<p>The ID of the step.</p>', 'GetWorkflowStepRequest$id' => '<p>The ID of the step.</p>', 'RetryWorkflowStepRequest$id' => '<p>The ID of the step.</p>', 'UpdateWorkflowStepRequest$id' => '<p>The ID of the step.</p>', 'UpdateWorkflowStepResponse$id' => '<p>The ID of the step.</p>', ], ], 'StepInput' => [ 'base' => '<p>A map of key value pairs that is generated when you create a migration workflow. The key value pairs will differ based on your selection of the template.</p>', 'refs' => [ 'StepInputParameters$value' => NULL, ], ], 'StepInputParameters' => [ 'base' => NULL, 'refs' => [ 'CreateMigrationWorkflowRequest$inputParameters' => '<p>The input parameters required to create a migration workflow.</p>', 'CreateMigrationWorkflowResponse$workflowInputs' => '<p>The inputs for creating a migration workflow.</p>', 'GetMigrationWorkflowResponse$workflowInputs' => '<p>The inputs required for creating the migration workflow.</p>', 'UpdateMigrationWorkflowRequest$inputParameters' => '<p>The input parameters required to update a migration workflow.</p>', 'UpdateMigrationWorkflowResponse$workflowInputs' => '<p>The inputs required to update a migration workflow.</p>', ], ], 'StepInputParametersKey' => [ 'base' => NULL, 'refs' => [ 'StepInputParameters$key' => NULL, ], ], 'StepName' => [ 'base' => NULL, 'refs' => [ 'UpdateWorkflowStepRequest$name' => '<p>The name of the step.</p>', ], ], 'StepOutput' => [ 'base' => '<p>The output of the step.</p>', 'refs' => [ 'StepOutputList$member' => NULL, ], ], 'StepOutputList' => [ 'base' => NULL, 'refs' => [ 'GetTemplateStepResponse$outputs' => '<p>The outputs of the step.</p>', ], ], 'StepStatus' => [ 'base' => NULL, 'refs' => [ 'GetWorkflowStepResponse$status' => '<p>The status of the step.</p>', 'RetryWorkflowStepResponse$status' => '<p>The status of the step.</p>', 'UpdateWorkflowStepRequest$status' => '<p>The status of the step.</p>', 'WorkflowStepSummary$status' => '<p>The status of the step.</p>', ], ], 'StopMigrationWorkflowRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopMigrationWorkflowResponse' => [ 'base' => NULL, 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'ConflictException$message' => NULL, 'CreateMigrationWorkflowResponse$arn' => '<p>The Amazon Resource Name (ARN) of the migration workflow.</p>', 'CreateMigrationWorkflowResponse$name' => '<p>The name of the migration workflow.</p>', 'CreateMigrationWorkflowResponse$description' => '<p>The description of the migration workflow.</p>', 'CreateMigrationWorkflowResponse$templateId' => '<p>The ID of the template.</p>', 'CreateMigrationWorkflowResponse$adsApplicationConfigurationId' => '<p>The configuration ID of the application configured in Application Discovery Service.</p>', 'CreateTemplateResponse$templateId' => '<p>The ID of the migration workflow template.</p>', 'CreateTemplateResponse$templateArn' => '<p>The Amazon Resource Name (ARN) of the migration workflow template. The format for an Migration Hub Orchestrator template ARN is <code>arn:aws:migrationhub-orchestrator:region:account:template/template-abcd1234</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'CreateWorkflowStepGroupResponse$workflowId' => '<p>The ID of the migration workflow that contains the step group.</p>', 'CreateWorkflowStepGroupResponse$name' => '<p>The name of the step group.</p>', 'CreateWorkflowStepGroupResponse$id' => '<p>The ID of the step group.</p>', 'CreateWorkflowStepGroupResponse$description' => '<p>The description of the step group.</p>', 'CreateWorkflowStepResponse$id' => '<p>The ID of the step.</p>', 'CreateWorkflowStepResponse$stepGroupId' => '<p>The ID of the step group.</p>', 'CreateWorkflowStepResponse$workflowId' => '<p>The ID of the migration workflow.</p>', 'CreateWorkflowStepResponse$name' => '<p>The name of the step.</p>', 'DeleteMigrationWorkflowResponse$arn' => '<p>The Amazon Resource Name (ARN) of the migration workflow.</p>', 'GetMigrationWorkflowResponse$arn' => '<p>The Amazon Resource Name (ARN) of the migration workflow.</p>', 'GetMigrationWorkflowResponse$name' => '<p>The name of the migration workflow.</p>', 'GetMigrationWorkflowResponse$description' => '<p>The description of the migration workflow.</p>', 'GetMigrationWorkflowResponse$templateId' => '<p>The ID of the template.</p>', 'GetMigrationWorkflowResponse$adsApplicationConfigurationId' => '<p>The configuration ID of the application configured in Application Discovery Service.</p>', 'GetMigrationWorkflowResponse$adsApplicationName' => '<p>The name of the application configured in Application Discovery Service.</p>', 'GetMigrationWorkflowResponse$statusMessage' => '<p>The status message of the migration workflow.</p>', 'GetMigrationWorkflowResponse$workflowBucket' => '<p>The Amazon S3 bucket where the migration logs are stored.</p>', 'GetMigrationWorkflowTemplateResponse$id' => '<p>The ID of the template.</p>', 'GetMigrationWorkflowTemplateResponse$templateArn' => '<p>&gt;The Amazon Resource Name (ARN) of the migration workflow template. The format for an Migration Hub Orchestrator template ARN is <code>arn:aws:migrationhub-orchestrator:region:account:template/template-abcd1234</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'GetMigrationWorkflowTemplateResponse$name' => '<p>The name of the template.</p>', 'GetMigrationWorkflowTemplateResponse$description' => '<p>The time at which the template was last created.</p>', 'GetMigrationWorkflowTemplateResponse$owner' => '<p>The owner of the migration workflow template.</p>', 'GetMigrationWorkflowTemplateResponse$statusMessage' => '<p>The status message of retrieving migration workflow templates.</p>', 'GetMigrationWorkflowTemplateResponse$templateClass' => '<p>The class of the migration workflow template. The available template classes are:</p> <ul> <li> <p>A2C</p> </li> <li> <p>MGN</p> </li> <li> <p>SAP_MULTI</p> </li> <li> <p>SQL_EC2</p> </li> <li> <p>SQL_RDS</p> </li> <li> <p>VMIE</p> </li> </ul>', 'GetTemplateStepGroupResponse$templateId' => '<p>The ID of the template.</p>', 'GetTemplateStepGroupResponse$id' => '<p>The ID of the step group.</p>', 'GetTemplateStepGroupResponse$name' => '<p>The name of the step group.</p>', 'GetTemplateStepGroupResponse$description' => '<p>The description of the step group.</p>', 'GetTemplateStepResponse$name' => '<p>The name of the step.</p>', 'GetTemplateStepResponse$description' => '<p>The description of the step.</p>', 'GetTemplateStepResponse$creationTime' => '<p>The time at which the step was created.</p>', 'GetWorkflowStepGroupResponse$workflowId' => '<p>The ID of the migration workflow.</p>', 'GetWorkflowStepGroupResponse$name' => '<p>The name of the step group.</p>', 'GetWorkflowStepGroupResponse$description' => '<p>The description of the step group.</p>', 'GetWorkflowStepResponse$name' => '<p>The name of the step.</p>', 'GetWorkflowStepResponse$stepGroupId' => '<p>The ID of the step group.</p>', 'GetWorkflowStepResponse$workflowId' => '<p>The ID of the migration workflow.</p>', 'GetWorkflowStepResponse$stepId' => '<p>The ID of the step.</p>', 'GetWorkflowStepResponse$description' => '<p>The description of the step.</p>', 'GetWorkflowStepResponse$statusMessage' => '<p>The status message of the migration workflow.</p>', 'GetWorkflowStepResponse$scriptOutputLocation' => '<p>The output location of the script.</p>', 'InternalServerException$message' => NULL, 'ListMigrationWorkflowsRequest$name' => '<p>The name of the migration workflow.</p>', 'MigrationWorkflowSummary$name' => '<p>The name of the migration workflow.</p>', 'MigrationWorkflowSummary$templateId' => '<p>The ID of the template.</p>', 'MigrationWorkflowSummary$adsApplicationConfigurationName' => '<p>The name of the application configured in Application Discovery Service.</p>', 'MigrationWorkflowSummary$statusMessage' => '<p>The status message of the migration workflow.</p>', 'PlatformCommand$linux' => '<p>Command for Linux.</p>', 'PlatformCommand$windows' => '<p>Command for Windows.</p>', 'PluginSummary$hostname' => '<p>The name of the host.</p>', 'PluginSummary$registeredTime' => '<p>The time at which the plugin was registered.</p>', 'ResourceNotFoundException$message' => NULL, 'RetryWorkflowStepResponse$stepGroupId' => '<p>The ID of the step group.</p>', 'RetryWorkflowStepResponse$workflowId' => '<p>The ID of the migration workflow.</p>', 'RetryWorkflowStepResponse$id' => '<p>The ID of the step.</p>', 'StartMigrationWorkflowResponse$arn' => '<p>The Amazon Resource Name (ARN) of the migration workflow.</p>', 'StartMigrationWorkflowResponse$statusMessage' => '<p>The status message of the migration workflow.</p>', 'StepAutomationConfiguration$scriptLocationS3Bucket' => '<p>The Amazon S3 bucket where the script is located.</p>', 'StepOutput$name' => '<p>The name of the step.</p>', 'StopMigrationWorkflowResponse$arn' => '<p>The Amazon Resource Name (ARN) of the migration workflow.</p>', 'StopMigrationWorkflowResponse$statusMessage' => '<p>The status message of the migration workflow.</p>', 'TemplateStepGroupSummary$id' => '<p>The ID of the step group.</p>', 'TemplateStepGroupSummary$name' => '<p>The name of the step group.</p>', 'TemplateStepSummary$id' => '<p>The ID of the step.</p>', 'TemplateStepSummary$stepGroupId' => '<p>The ID of the step group.</p>', 'TemplateStepSummary$templateId' => '<p>The ID of the template.</p>', 'TemplateStepSummary$name' => '<p>The name of the step.</p>', 'TemplateSummary$id' => '<p>The ID of the template.</p>', 'TemplateSummary$name' => '<p>The name of the template.</p>', 'TemplateSummary$arn' => '<p>The Amazon Resource Name (ARN) of the template.</p>', 'TemplateSummary$description' => '<p>The description of the template.</p>', 'ThrottlingException$message' => NULL, 'Tool$name' => '<p>The name of an AWS service. </p>', 'Tool$url' => '<p>The URL of an AWS service.</p>', 'UpdateMigrationWorkflowResponse$arn' => '<p>The Amazon Resource Name (ARN) of the migration workflow.</p>', 'UpdateMigrationWorkflowResponse$name' => '<p>The name of the migration workflow.</p>', 'UpdateMigrationWorkflowResponse$description' => '<p>The description of the migration workflow.</p>', 'UpdateMigrationWorkflowResponse$templateId' => '<p>The ID of the template.</p>', 'UpdateMigrationWorkflowResponse$adsApplicationConfigurationId' => '<p>The ID of the application configured in Application Discovery Service.</p>', 'UpdateTemplateResponse$templateId' => '<p>The ID of the migration workflow template being updated.</p>', 'UpdateTemplateResponse$templateArn' => '<p>The ARN of the migration workflow template being updated. The format for an Migration Hub Orchestrator template ARN is <code>arn:aws:migrationhub-orchestrator:region:account:template/template-abcd1234</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'UpdateWorkflowStepGroupResponse$workflowId' => '<p>The ID of the migration workflow.</p>', 'UpdateWorkflowStepGroupResponse$name' => '<p>The name of the step group.</p>', 'UpdateWorkflowStepGroupResponse$id' => '<p>The ID of the step group.</p>', 'UpdateWorkflowStepGroupResponse$description' => '<p>The description of the step group.</p>', 'UpdateWorkflowStepResponse$stepGroupId' => '<p>The ID of the step group.</p>', 'UpdateWorkflowStepResponse$workflowId' => '<p>The ID of the migration workflow.</p>', 'UpdateWorkflowStepResponse$name' => '<p>The name of the step.</p>', 'ValidationException$message' => NULL, 'WorkflowStepGroupSummary$id' => '<p>The ID of the step group.</p>', 'WorkflowStepGroupSummary$name' => '<p>The name of the step group.</p>', 'WorkflowStepSummary$stepId' => '<p>The ID of the step.</p>', 'WorkflowStepSummary$name' => '<p>The name of the step.</p>', 'WorkflowStepSummary$statusMessage' => '<p>The status message of the migration workflow.</p>', 'WorkflowStepSummary$description' => '<p>The description of the step.</p>', 'WorkflowStepSummary$scriptLocation' => '<p>The location of the script.</p>', ], ], 'StringList' => [ 'base' => NULL, 'refs' => [ 'CreateMigrationWorkflowRequest$stepTargets' => '<p>The servers on which a step will be run.</p>', 'CreateMigrationWorkflowResponse$stepTargets' => '<p>The servers on which a step will be run.</p>', 'CreateWorkflowStepGroupRequest$next' => '<p>The next step group.</p>', 'CreateWorkflowStepGroupRequest$previous' => '<p>The previous step group.</p>', 'CreateWorkflowStepGroupResponse$next' => '<p>The next step group.</p>', 'CreateWorkflowStepGroupResponse$previous' => '<p>The previous step group.</p>', 'CreateWorkflowStepRequest$stepTarget' => '<p>The servers on which a step will be run.</p>', 'CreateWorkflowStepRequest$previous' => '<p>The previous step.</p>', 'CreateWorkflowStepRequest$next' => '<p>The next step.</p>', 'GetTemplateStepGroupResponse$previous' => '<p>The previous step group.</p>', 'GetTemplateStepGroupResponse$next' => '<p>The next step group.</p>', 'GetTemplateStepResponse$previous' => '<p>The previous step.</p>', 'GetTemplateStepResponse$next' => '<p>The next step.</p>', 'GetWorkflowStepGroupResponse$previous' => '<p>The previous step group.</p>', 'GetWorkflowStepGroupResponse$next' => '<p>The next step group.</p>', 'GetWorkflowStepResponse$stepTarget' => '<p>The servers on which a step will be run.</p>', 'GetWorkflowStepResponse$previous' => '<p>The previous step.</p>', 'GetWorkflowStepResponse$next' => '<p>The next step.</p>', 'StepInput$listOfStringsValue' => '<p>List of string values.</p>', 'TemplateStepGroupSummary$previous' => '<p>The previous step group.</p>', 'TemplateStepGroupSummary$next' => '<p>The next step group.</p>', 'TemplateStepSummary$previous' => '<p>The previous step.</p>', 'TemplateStepSummary$next' => '<p>The next step.</p>', 'UpdateMigrationWorkflowRequest$stepTargets' => '<p>The servers on which a step will be run.</p>', 'UpdateMigrationWorkflowResponse$stepTargets' => '<p>The servers on which a step will be run.</p>', 'UpdateWorkflowStepGroupRequest$next' => '<p>The next step group.</p>', 'UpdateWorkflowStepGroupRequest$previous' => '<p>The previous step group.</p>', 'UpdateWorkflowStepGroupResponse$next' => '<p>The next step group.</p>', 'UpdateWorkflowStepGroupResponse$previous' => '<p>The previous step group.</p>', 'UpdateWorkflowStepRequest$stepTarget' => '<p>The servers on which a step will be run.</p>', 'UpdateWorkflowStepRequest$previous' => '<p>The previous step.</p>', 'UpdateWorkflowStepRequest$next' => '<p>The next step.</p>', 'WorkflowStepGroupSummary$previous' => '<p>The previous step group.</p>', 'WorkflowStepGroupSummary$next' => '<p>The next step group.</p>', 'WorkflowStepSummary$previous' => '<p>The previous step.</p>', 'WorkflowStepSummary$next' => '<p>The next step.</p>', ], ], 'StringListMember' => [ 'base' => NULL, 'refs' => [ 'StringList$member' => NULL, ], ], 'StringMap' => [ 'base' => NULL, 'refs' => [ 'CreateMigrationWorkflowRequest$tags' => '<p>The tags to add on a migration workflow.</p>', 'CreateMigrationWorkflowResponse$tags' => '<p>The tags to add on a migration workflow.</p>', 'CreateTemplateResponse$tags' => '<p>The tags added to the migration workflow template.</p>', 'GetMigrationWorkflowResponse$tags' => '<p>The tags added to the migration workflow.</p>', 'GetMigrationWorkflowTemplateResponse$tags' => '<p>The tags added to the migration workflow template.</p>', 'StepInput$mapOfStringValue' => '<p>Map of string values.</p>', 'UpdateMigrationWorkflowResponse$tags' => '<p>The tags added to the migration workflow.</p>', 'UpdateTemplateResponse$tags' => '<p>The tags added to the migration workflow template.</p>', ], ], 'StringMapKey' => [ 'base' => NULL, 'refs' => [ 'StringMap$key' => NULL, ], ], 'StringMapValue' => [ 'base' => NULL, 'refs' => [ 'StringMap$value' => NULL, ], ], 'StringValue' => [ 'base' => NULL, 'refs' => [ 'StepInput$stringValue' => '<p>String value.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'TagMap$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>One or more tag keys. Specify only the tag keys, not the tag values.</p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'CreateTemplateRequest$tags' => '<p>The tags to add to the migration workflow template.</p>', 'ListTagsForResourceResponse$tags' => '<p>The tags added to a resource.</p>', 'TagResourceRequest$tags' => '<p>A collection of labels, in the form of key:value pairs, that apply to this resource.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagMap$value' => NULL, ], ], 'TargetType' => [ 'base' => NULL, 'refs' => [ 'StepAutomationConfiguration$targetType' => '<p>The servers on which to run the script.</p>', 'TemplateStepSummary$targetType' => '<p>The servers on which to run the script.</p>', 'WorkflowStepAutomationConfiguration$targetType' => '<p>The servers on which to run the script.</p>', ], ], 'TemplateId' => [ 'base' => NULL, 'refs' => [ 'DeleteTemplateRequest$id' => '<p>The ID of the request to delete a migration workflow template.</p>', 'GetMigrationWorkflowTemplateRequest$id' => '<p>The ID of the template.</p>', 'GetTemplateStepGroupRequest$templateId' => '<p>The ID of the template.</p>', 'GetTemplateStepRequest$templateId' => '<p>The ID of the template.</p>', 'GetTemplateStepResponse$templateId' => '<p>The ID of the template.</p>', 'ListMigrationWorkflowsRequest$templateId' => '<p>The ID of the template.</p>', 'ListTemplateStepGroupsRequest$templateId' => '<p>The ID of the template.</p>', 'ListTemplateStepsRequest$templateId' => '<p>The ID of the template.</p>', 'UpdateTemplateRequest$id' => '<p>The ID of the request to update a migration workflow template.</p>', ], ], 'TemplateInput' => [ 'base' => '<p>The input parameters of a template.</p>', 'refs' => [ 'TemplateInputList$member' => NULL, ], ], 'TemplateInputList' => [ 'base' => NULL, 'refs' => [ 'GetMigrationWorkflowTemplateResponse$inputs' => '<p>The inputs provided for the creation of the migration workflow.</p>', ], ], 'TemplateInputName' => [ 'base' => NULL, 'refs' => [ 'TemplateInput$inputName' => '<p>The name of the template.</p>', ], ], 'TemplateName' => [ 'base' => NULL, 'refs' => [ 'ListMigrationWorkflowTemplatesRequest$name' => '<p>The name of the template.</p>', ], ], 'TemplateSource' => [ 'base' => '<p>The migration workflow template used as the source for the new template.</p>', 'refs' => [ 'CreateTemplateRequest$templateSource' => '<p>The source of the migration workflow template.</p>', ], ], 'TemplateStatus' => [ 'base' => NULL, 'refs' => [ 'GetMigrationWorkflowTemplateResponse$status' => '<p>The status of the template.</p>', ], ], 'TemplateStepGroupSummary' => [ 'base' => '<p>The summary of the step group in the template.</p>', 'refs' => [ 'TemplateStepGroupSummaryList$member' => NULL, ], ], 'TemplateStepGroupSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListTemplateStepGroupsResponse$templateStepGroupSummary' => '<p>The summary of the step group in the template.</p>', ], ], 'TemplateStepSummary' => [ 'base' => '<p>The summary of the step.</p>', 'refs' => [ 'TemplateStepSummaryList$member' => NULL, ], ], 'TemplateStepSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListTemplateStepsResponse$templateStepSummaryList' => '<p>The list of summaries of steps in a template.</p>', ], ], 'TemplateSummary' => [ 'base' => '<p>The summary of the template.</p>', 'refs' => [ 'TemplateSummaryList$member' => NULL, ], ], 'TemplateSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListMigrationWorkflowTemplatesResponse$templateSummary' => '<p>The summary of the template.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The request was denied due to request throttling.</p>', 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'CreateMigrationWorkflowResponse$creationTime' => '<p>The time at which the migration workflow was created.</p>', 'CreateWorkflowStepGroupResponse$creationTime' => '<p>The time at which the step group is created.</p>', 'GetMigrationWorkflowResponse$creationTime' => '<p>The time at which the migration workflow was created.</p>', 'GetMigrationWorkflowResponse$lastStartTime' => '<p>The time at which the migration workflow was last started.</p>', 'GetMigrationWorkflowResponse$lastStopTime' => '<p>The time at which the migration workflow was last stopped.</p>', 'GetMigrationWorkflowResponse$lastModifiedTime' => '<p>The time at which the migration workflow was last modified.</p>', 'GetMigrationWorkflowResponse$endTime' => '<p>The time at which the migration workflow ended.</p>', 'GetMigrationWorkflowTemplateResponse$creationTime' => '<p>The time at which the template was last created.</p>', 'GetTemplateStepGroupResponse$creationTime' => '<p>The time at which the step group was created.</p>', 'GetTemplateStepGroupResponse$lastModifiedTime' => '<p>The time at which the step group was last modified.</p>', 'GetWorkflowStepGroupResponse$creationTime' => '<p>The time at which the step group was created.</p>', 'GetWorkflowStepGroupResponse$lastModifiedTime' => '<p>The time at which the step group was last modified.</p>', 'GetWorkflowStepGroupResponse$endTime' => '<p>The time at which the step group ended.</p>', 'GetWorkflowStepResponse$creationTime' => '<p>The time at which the step was created.</p>', 'GetWorkflowStepResponse$lastStartTime' => '<p>The time at which the workflow was last started.</p>', 'GetWorkflowStepResponse$endTime' => '<p>The time at which the step ended.</p>', 'MigrationWorkflowSummary$creationTime' => '<p>The time at which the migration workflow was created.</p>', 'MigrationWorkflowSummary$endTime' => '<p>The time at which the migration workflow ended.</p>', 'StartMigrationWorkflowResponse$lastStartTime' => '<p>The time at which the migration workflow was last started.</p>', 'StopMigrationWorkflowResponse$lastStopTime' => '<p>The time at which the migration workflow was stopped.</p>', 'UpdateMigrationWorkflowResponse$creationTime' => '<p>The time at which the migration workflow was created.</p>', 'UpdateMigrationWorkflowResponse$lastModifiedTime' => '<p>The time at which the migration workflow was last modified.</p>', 'UpdateWorkflowStepGroupResponse$lastModifiedTime' => '<p>The time at which the step group was last modified.</p>', ], ], 'Tool' => [ 'base' => '<p>List of AWS services utilized in a migration workflow.</p>', 'refs' => [ 'ToolsList$member' => NULL, ], ], 'ToolsList' => [ 'base' => NULL, 'refs' => [ 'CreateWorkflowStepGroupResponse$tools' => '<p>List of AWS services utilized in a migration workflow.</p>', 'GetMigrationWorkflowResponse$tools' => '<p>List of AWS services utilized in a migration workflow.</p>', 'GetMigrationWorkflowTemplateResponse$tools' => '<p>List of AWS services utilized in a migration workflow.</p>', 'GetTemplateStepGroupResponse$tools' => '<p>List of AWS services utilized in a migration workflow.</p>', 'GetWorkflowStepGroupResponse$tools' => '<p>List of AWS services utilized in a migration workflow.</p>', 'UpdateWorkflowStepGroupResponse$tools' => '<p>List of AWS services utilized in a migration workflow.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMigrationWorkflowRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMigrationWorkflowRequestDescriptionString' => [ 'base' => NULL, 'refs' => [ 'UpdateMigrationWorkflowRequest$description' => '<p>The description of the migration workflow.</p>', ], ], 'UpdateMigrationWorkflowRequestNameString' => [ 'base' => NULL, 'refs' => [ 'UpdateMigrationWorkflowRequest$name' => '<p>The name of the migration workflow.</p>', ], ], 'UpdateMigrationWorkflowResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTemplateRequestTemplateDescriptionString' => [ 'base' => NULL, 'refs' => [ 'UpdateTemplateRequest$templateDescription' => '<p>The description of the migration workflow template to update.</p>', ], ], 'UpdateTemplateRequestTemplateNameString' => [ 'base' => NULL, 'refs' => [ 'UpdateTemplateRequest$templateName' => '<p>The name of the migration workflow template to update.</p>', ], ], 'UpdateTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateWorkflowStepGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateWorkflowStepGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateWorkflowStepRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateWorkflowStepResponse' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>The input fails to satisfy the constraints specified by an AWS service.</p>', 'refs' => [], ], 'WorkflowStepAutomationConfiguration' => [ 'base' => '<p>The custom script to run tests on source or target environments.</p>', 'refs' => [ 'CreateWorkflowStepRequest$workflowStepAutomationConfiguration' => '<p>The custom script to run tests on source or target environments.</p>', 'GetWorkflowStepResponse$workflowStepAutomationConfiguration' => '<p>The custom script to run tests on source or target environments.</p>', 'UpdateWorkflowStepRequest$workflowStepAutomationConfiguration' => '<p>The custom script to run tests on the source and target environments.</p>', ], ], 'WorkflowStepGroupSummary' => [ 'base' => '<p>The summary of a step group in a workflow.</p>', 'refs' => [ 'WorkflowStepGroupsSummaryList$member' => NULL, ], ], 'WorkflowStepGroupsSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListWorkflowStepGroupsResponse$workflowStepGroupsSummary' => '<p>The summary of step groups in a migration workflow.</p>', ], ], 'WorkflowStepOutput' => [ 'base' => '<p>The output of a step.</p>', 'refs' => [ 'GetWorkflowStepResponseOutputsList$member' => NULL, 'WorkflowStepOutputList$member' => NULL, ], ], 'WorkflowStepOutputList' => [ 'base' => NULL, 'refs' => [ 'CreateWorkflowStepRequest$outputs' => '<p>The key value pairs added for the expected output.</p>', 'UpdateWorkflowStepRequest$outputs' => '<p>The outputs of a step.</p>', ], ], 'WorkflowStepOutputName' => [ 'base' => NULL, 'refs' => [ 'WorkflowStepOutput$name' => '<p>The name of the step.</p>', ], ], 'WorkflowStepOutputUnion' => [ 'base' => '<p>A structure to hold multiple values of an output.</p>', 'refs' => [ 'WorkflowStepOutput$value' => '<p>The value of the output.</p>', ], ], 'WorkflowStepSummary' => [ 'base' => '<p>The summary of the step in a migration workflow.</p>', 'refs' => [ 'WorkflowStepsSummaryList$member' => NULL, ], ], 'WorkflowStepsSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListWorkflowStepsResponse$workflowStepsSummary' => '<p>The summary of steps in a migration workflow.</p>', ], ], ],];
