<?php
// This file was auto-generated from sdk-root/src/data/models.lex.v2/2020-08-07/docs-2.json
return [ 'version' => '2.0', 'service' => '<p/>', 'operations' => [ 'BatchCreateCustomVocabularyItem' => '<p>Create a batch of custom vocabulary items for a given bot locale\'s custom vocabulary.</p>', 'BatchDeleteCustomVocabularyItem' => '<p>Delete a batch of custom vocabulary items for a given bot locale\'s custom vocabulary.</p>', 'BatchUpdateCustomVocabularyItem' => '<p>Update a batch of custom vocabulary items for a given bot locale\'s custom vocabulary.</p>', 'BuildBotLocale' => '<p>Builds a bot, its intents, and its slot types into a specific locale. A bot can be built into multiple locales. At runtime the locale is used to choose a specific build of the bot.</p>', 'CreateBot' => '<p>Creates an Amazon Lex conversational bot. </p>', 'CreateBotAlias' => '<p>Creates an alias for the specified version of a bot. Use an alias to enable you to change the version of a bot without updating applications that use the bot.</p> <p>For example, you can create an alias called "PROD" that your applications use to call the Amazon Lex bot. </p>', 'CreateBotLocale' => '<p>Creates a locale in the bot. The locale contains the intents and slot types that the bot uses in conversations with users in the specified language and locale. You must add a locale to a bot before you can add intents and slot types to the bot.</p>', 'CreateBotReplica' => '<p>Action to create a replication of the source bot in the secondary region.</p>', 'CreateBotVersion' => '<p>Creates an immutable version of the bot. When you create the first version of a bot, Amazon Lex sets the version number to 1. Subsequent bot versions increase in an increment of 1. The version number will always represent the total number of versions created of the bot, not the current number of versions. If a bot version is deleted, that bot version number will not be reused.</p>', 'CreateExport' => '<p>Creates a zip archive containing the contents of a bot or a bot locale. The archive contains a directory structure that contains JSON files that define the bot.</p> <p>You can create an archive that contains the complete definition of a bot, or you can specify that the archive contain only the definition of a single bot locale.</p> <p>For more information about exporting bots, and about the structure of the export archive, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/importing-exporting.html"> Importing and exporting bots </a> </p>', 'CreateIntent' => '<p>Creates an intent.</p> <p>To define the interaction between the user and your bot, you define one or more intents. For example, for a pizza ordering bot you would create an <code>OrderPizza</code> intent.</p> <p>When you create an intent, you must provide a name. You can optionally provide the following:</p> <ul> <li> <p>Sample utterances. For example, "I want to order a pizza" and "Can I order a pizza." You can\'t provide utterances for built-in intents.</p> </li> <li> <p>Information to be gathered. You specify slots for the information that you bot requests from the user. You can specify standard slot types, such as date and time, or custom slot types for your application.</p> </li> <li> <p>How the intent is fulfilled. You can provide a Lambda function or configure the intent to return the intent information to your client application. If you use a Lambda function, Amazon Lex invokes the function when all of the intent information is available.</p> </li> <li> <p>A confirmation prompt to send to the user to confirm an intent. For example, "Shall I order your pizza?"</p> </li> <li> <p>A conclusion statement to send to the user after the intent is fulfilled. For example, "I ordered your pizza."</p> </li> <li> <p>A follow-up prompt that asks the user for additional activity. For example, "Do you want a drink with your pizza?"</p> </li> </ul>', 'CreateResourcePolicy' => '<p>Creates a new resource policy with the specified policy statements.</p>', 'CreateResourcePolicyStatement' => '<p>Adds a new resource policy statement to a bot or bot alias. If a resource policy exists, the statement is added to the current resource policy. If a policy doesn\'t exist, a new policy is created.</p> <p>You can\'t create a resource policy statement that allows cross-account access.</p>', 'CreateSlot' => '<p>Creates a slot in an intent. A slot is a variable needed to fulfill an intent. For example, an <code>OrderPizza</code> intent might need slots for size, crust, and number of pizzas. For each slot, you define one or more utterances that Amazon Lex uses to elicit a response from the user. </p>', 'CreateSlotType' => '<p>Creates a custom slot type</p> <p> To create a custom slot type, specify a name for the slot type and a set of enumeration values, the values that a slot of this type can assume. </p>', 'CreateTestSetDiscrepancyReport' => '<p>Create a report that describes the differences between the bot and the test set.</p>', 'CreateUploadUrl' => '<p>Gets a pre-signed S3 write URL that you use to upload the zip archive when importing a bot or a bot locale. </p>', 'DeleteBot' => '<p>Deletes all versions of a bot, including the <code>Draft</code> version. To delete a specific version, use the <code>DeleteBotVersion</code> operation.</p> <p>When you delete a bot, all of the resources contained in the bot are also deleted. Deleting a bot removes all locales, intents, slot, and slot types defined for the bot.</p> <p>If a bot has an alias, the <code>DeleteBot</code> operation returns a <code>ResourceInUseException</code> exception. If you want to delete the bot and the alias, set the <code>skipResourceInUseCheck</code> parameter to <code>true</code>.</p>', 'DeleteBotAlias' => '<p>Deletes the specified bot alias.</p>', 'DeleteBotLocale' => '<p>Removes a locale from a bot.</p> <p>When you delete a locale, all intents, slots, and slot types defined for the locale are also deleted.</p>', 'DeleteBotReplica' => '<p>The action to delete the replicated bot in the secondary region.</p>', 'DeleteBotVersion' => '<p>Deletes a specific version of a bot. To delete all versions of a bot, use the <a href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DeleteBot.html">DeleteBot</a> operation.</p>', 'DeleteCustomVocabulary' => '<p>Removes a custom vocabulary from the specified locale in the specified bot.</p>', 'DeleteExport' => '<p>Removes a previous export and the associated files stored in an S3 bucket.</p>', 'DeleteImport' => '<p>Removes a previous import and the associated file stored in an S3 bucket.</p>', 'DeleteIntent' => '<p>Removes the specified intent.</p> <p>Deleting an intent also deletes the slots associated with the intent.</p>', 'DeleteResourcePolicy' => '<p>Removes an existing policy from a bot or bot alias. If the resource doesn\'t have a policy attached, Amazon Lex returns an exception.</p>', 'DeleteResourcePolicyStatement' => '<p>Deletes a policy statement from a resource policy. If you delete the last statement from a policy, the policy is deleted. If you specify a statement ID that doesn\'t exist in the policy, or if the bot or bot alias doesn\'t have a policy attached, Amazon Lex returns an exception.</p>', 'DeleteSlot' => '<p>Deletes the specified slot from an intent.</p>', 'DeleteSlotType' => '<p>Deletes a slot type from a bot locale.</p> <p>If a slot is using the slot type, Amazon Lex throws a <code>ResourceInUseException</code> exception. To avoid the exception, set the <code>skipResourceInUseCheck</code> parameter to <code>true</code>.</p>', 'DeleteTestSet' => '<p>The action to delete the selected test set.</p>', 'DeleteUtterances' => '<p>Deletes stored utterances.</p> <p>Amazon Lex stores the utterances that users send to your bot. Utterances are stored for 15 days for use with the <a href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListAggregatedUtterances.html">ListAggregatedUtterances</a> operation, and then stored indefinitely for use in improving the ability of your bot to respond to user input..</p> <p>Use the <code>DeleteUtterances</code> operation to manually delete utterances for a specific session. When you use the <code>DeleteUtterances</code> operation, utterances stored for improving your bot\'s ability to respond to user input are deleted immediately. Utterances stored for use with the <code>ListAggregatedUtterances</code> operation are deleted after 15 days.</p>', 'DescribeBot' => '<p>Provides metadata information about a bot. </p>', 'DescribeBotAlias' => '<p>Get information about a specific bot alias.</p>', 'DescribeBotLocale' => '<p>Describes the settings that a bot has for a specific locale. </p>', 'DescribeBotRecommendation' => '<p>Provides metadata information about a bot recommendation. This information will enable you to get a description on the request inputs, to download associated transcripts after processing is complete, and to download intents and slot-types generated by the bot recommendation.</p>', 'DescribeBotReplica' => '<p>Monitors the bot replication status through the UI console.</p>', 'DescribeBotResourceGeneration' => '<p>Returns information about a request to generate a bot through natural language description, made through the <code>StartBotResource</code> API. Use the <code>generatedBotLocaleUrl</code> to retrieve the Amazon S3 object containing the bot locale configuration. You can then modify and import this configuration.</p>', 'DescribeBotVersion' => '<p>Provides metadata about a version of a bot.</p>', 'DescribeCustomVocabularyMetadata' => '<p>Provides metadata information about a custom vocabulary.</p>', 'DescribeExport' => '<p>Gets information about a specific export.</p>', 'DescribeImport' => '<p>Gets information about a specific import.</p>', 'DescribeIntent' => '<p>Returns metadata about an intent.</p>', 'DescribeResourcePolicy' => '<p>Gets the resource policy and policy revision for a bot or bot alias.</p>', 'DescribeSlot' => '<p>Gets metadata information about a slot.</p>', 'DescribeSlotType' => '<p>Gets metadata information about a slot type.</p>', 'DescribeTestExecution' => '<p>Gets metadata information about the test execution.</p>', 'DescribeTestSet' => '<p>Gets metadata information about the test set.</p>', 'DescribeTestSetDiscrepancyReport' => '<p>Gets metadata information about the test set discrepancy report.</p>', 'DescribeTestSetGeneration' => '<p>Gets metadata information about the test set generation.</p>', 'GenerateBotElement' => '<p>Generates sample utterances for an intent.</p>', 'GetTestExecutionArtifactsUrl' => '<p>The pre-signed Amazon S3 URL to download the test execution result artifacts.</p>', 'ListAggregatedUtterances' => '<p>Provides a list of utterances that users have sent to the bot.</p> <p>Utterances are aggregated by the text of the utterance. For example, all instances where customers used the phrase "I want to order pizza" are aggregated into the same line in the response.</p> <p>You can see both detected utterances and missed utterances. A detected utterance is where the bot properly recognized the utterance and activated the associated intent. A missed utterance was not recognized by the bot and didn\'t activate an intent.</p> <p>Utterances can be aggregated for a bot alias or for a bot version, but not both at the same time.</p> <p>Utterances statistics are not generated under the following conditions:</p> <ul> <li> <p>The <code>childDirected</code> field was set to true when the bot was created.</p> </li> <li> <p>You are using slot obfuscation with one or more slots.</p> </li> <li> <p>You opted out of participating in improving Amazon Lex.</p> </li> </ul>', 'ListBotAliasReplicas' => '<p>The action to list the replicated bots created from the source bot alias.</p>', 'ListBotAliases' => '<p>Gets a list of aliases for the specified bot.</p>', 'ListBotLocales' => '<p>Gets a list of locales for the specified bot.</p>', 'ListBotRecommendations' => '<p>Get a list of bot recommendations that meet the specified criteria.</p>', 'ListBotReplicas' => '<p>The action to list the replicated bots.</p>', 'ListBotResourceGenerations' => '<p>Lists the generation requests made for a bot locale.</p>', 'ListBotVersionReplicas' => '<p>Contains information about all the versions replication statuses applicable for Global Resiliency.</p>', 'ListBotVersions' => '<p>Gets information about all of the versions of a bot.</p> <p>The <code>ListBotVersions</code> operation returns a summary of each version of a bot. For example, if a bot has three numbered versions, the <code>ListBotVersions</code> operation returns for summaries, one for each numbered version and one for the <code>DRAFT</code> version.</p> <p>The <code>ListBotVersions</code> operation always returns at least one version, the <code>DRAFT</code> version.</p>', 'ListBots' => '<p>Gets a list of available bots.</p>', 'ListBuiltInIntents' => '<p>Gets a list of built-in intents provided by Amazon Lex that you can use in your bot. </p> <p>To use a built-in intent as a the base for your own intent, include the built-in intent signature in the <code>parentIntentSignature</code> parameter when you call the <code>CreateIntent</code> operation. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_CreateIntent.html">CreateIntent</a>.</p>', 'ListBuiltInSlotTypes' => '<p>Gets a list of built-in slot types that meet the specified criteria.</p>', 'ListCustomVocabularyItems' => '<p>Paginated list of custom vocabulary items for a given bot locale\'s custom vocabulary.</p>', 'ListExports' => '<p>Lists the exports for a bot, bot locale, or custom vocabulary. Exports are kept in the list for 7 days.</p>', 'ListImports' => '<p>Lists the imports for a bot, bot locale, or custom vocabulary. Imports are kept in the list for 7 days.</p>', 'ListIntentMetrics' => '<p>Retrieves summary metrics for the intents in your bot. The following fields are required:</p> <ul> <li> <p> <code>metrics</code> – A list of <a href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_AnalyticsIntentMetric.html">AnalyticsIntentMetric</a> objects. In each object, use the <code>name</code> field to specify the metric to calculate, the <code>statistic</code> field to specify whether to calculate the <code>Sum</code>, <code>Average</code>, or <code>Max</code> number, and the <code>order</code> field to specify whether to sort the results in <code>Ascending</code> or <code>Descending</code> order.</p> </li> <li> <p> <code>startDateTime</code> and <code>endDateTime</code> – Define a time range for which you want to retrieve results.</p> </li> </ul> <p>Of the optional fields, you can organize the results in the following ways:</p> <ul> <li> <p>Use the <code>filters</code> field to filter the results, the <code>groupBy</code> field to specify categories by which to group the results, and the <code>binBy</code> field to specify time intervals by which to group the results.</p> </li> <li> <p>Use the <code>maxResults</code> field to limit the number of results to return in a single response and the <code>nextToken</code> field to return the next batch of results if the response does not return the full set of results.</p> </li> </ul> <p>Note that an <code>order</code> field exists in both <code>binBy</code> and <code>metrics</code>. You can specify only one <code>order</code> in a given request.</p>', 'ListIntentPaths' => '<p>Retrieves summary statistics for a path of intents that users take over sessions with your bot. The following fields are required:</p> <ul> <li> <p> <code>startDateTime</code> and <code>endDateTime</code> – Define a time range for which you want to retrieve results.</p> </li> <li> <p> <code>intentPath</code> – Define an order of intents for which you want to retrieve metrics. Separate intents in the path with a forward slash. For example, populate the <code>intentPath</code> field with <code>/BookCar/BookHotel</code> to see details about how many times users invoked the <code>BookCar</code> and <code>BookHotel</code> intents in that order.</p> </li> </ul> <p>Use the optional <code>filters</code> field to filter the results.</p>', 'ListIntentStageMetrics' => '<p>Retrieves summary metrics for the stages within intents in your bot. The following fields are required:</p> <ul> <li> <p> <code>metrics</code> – A list of <a href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_AnalyticsIntentStageMetric.html">AnalyticsIntentStageMetric</a> objects. In each object, use the <code>name</code> field to specify the metric to calculate, the <code>statistic</code> field to specify whether to calculate the <code>Sum</code>, <code>Average</code>, or <code>Max</code> number, and the <code>order</code> field to specify whether to sort the results in <code>Ascending</code> or <code>Descending</code> order.</p> </li> <li> <p> <code>startDateTime</code> and <code>endDateTime</code> – Define a time range for which you want to retrieve results.</p> </li> </ul> <p>Of the optional fields, you can organize the results in the following ways:</p> <ul> <li> <p>Use the <code>filters</code> field to filter the results, the <code>groupBy</code> field to specify categories by which to group the results, and the <code>binBy</code> field to specify time intervals by which to group the results.</p> </li> <li> <p>Use the <code>maxResults</code> field to limit the number of results to return in a single response and the <code>nextToken</code> field to return the next batch of results if the response does not return the full set of results.</p> </li> </ul> <p>Note that an <code>order</code> field exists in both <code>binBy</code> and <code>metrics</code>. You can only specify one <code>order</code> in a given request.</p>', 'ListIntents' => '<p>Get a list of intents that meet the specified criteria.</p>', 'ListRecommendedIntents' => '<p>Gets a list of recommended intents provided by the bot recommendation that you can use in your bot. Intents in the response are ordered by relevance.</p>', 'ListSessionAnalyticsData' => '<p>Retrieves a list of metadata for individual user sessions with your bot. The <code>startDateTime</code> and <code>endDateTime</code> fields are required. These fields define a time range for which you want to retrieve results. Of the optional fields, you can organize the results in the following ways:</p> <ul> <li> <p>Use the <code>filters</code> field to filter the results and the <code>sortBy</code> field to specify the values by which to sort the results.</p> </li> <li> <p>Use the <code>maxResults</code> field to limit the number of results to return in a single response and the <code>nextToken</code> field to return the next batch of results if the response does not return the full set of results.</p> </li> </ul>', 'ListSessionMetrics' => '<p>Retrieves summary metrics for the user sessions with your bot. The following fields are required:</p> <ul> <li> <p> <code>metrics</code> – A list of <a href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_AnalyticsSessionMetric.html">AnalyticsSessionMetric</a> objects. In each object, use the <code>name</code> field to specify the metric to calculate, the <code>statistic</code> field to specify whether to calculate the <code>Sum</code>, <code>Average</code>, or <code>Max</code> number, and the <code>order</code> field to specify whether to sort the results in <code>Ascending</code> or <code>Descending</code> order.</p> </li> <li> <p> <code>startDateTime</code> and <code>endDateTime</code> – Define a time range for which you want to retrieve results.</p> </li> </ul> <p>Of the optional fields, you can organize the results in the following ways:</p> <ul> <li> <p>Use the <code>filters</code> field to filter the results, the <code>groupBy</code> field to specify categories by which to group the results, and the <code>binBy</code> field to specify time intervals by which to group the results.</p> </li> <li> <p>Use the <code>maxResults</code> field to limit the number of results to return in a single response and the <code>nextToken</code> field to return the next batch of results if the response does not return the full set of results.</p> </li> </ul> <p>Note that an <code>order</code> field exists in both <code>binBy</code> and <code>metrics</code>. Currently, you can specify it in either field, but not in both.</p>', 'ListSlotTypes' => '<p>Gets a list of slot types that match the specified criteria.</p>', 'ListSlots' => '<p>Gets a list of slots that match the specified criteria.</p>', 'ListTagsForResource' => '<p>Gets a list of tags associated with a resource. Only bots, bot aliases, and bot channels can have tags associated with them.</p>', 'ListTestExecutionResultItems' => '<p>Gets a list of test execution result items.</p>', 'ListTestExecutions' => '<p>The list of test set executions.</p>', 'ListTestSetRecords' => '<p>The list of test set records.</p>', 'ListTestSets' => '<p>The list of the test sets</p>', 'ListUtteranceAnalyticsData' => '<note> <p>To use this API operation, your IAM role must have permissions to perform the <a href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListAggregatedUtterances.html">ListAggregatedUtterances</a> operation, which provides access to utterance-related analytics. See <a href="https://docs.aws.amazon.com/lexv2/latest/dg/monitoring-utterances.html">Viewing utterance statistics</a> for the IAM policy to apply to the IAM role.</p> </note> <p>Retrieves a list of metadata for individual user utterances to your bot. The following fields are required:</p> <ul> <li> <p> <code>startDateTime</code> and <code>endDateTime</code> – Define a time range for which you want to retrieve results.</p> </li> </ul> <p>Of the optional fields, you can organize the results in the following ways:</p> <ul> <li> <p>Use the <code>filters</code> field to filter the results and the <code>sortBy</code> field to specify the values by which to sort the results.</p> </li> <li> <p>Use the <code>maxResults</code> field to limit the number of results to return in a single response and the <code>nextToken</code> field to return the next batch of results if the response does not return the full set of results.</p> </li> </ul>', 'ListUtteranceMetrics' => '<note> <p>To use this API operation, your IAM role must have permissions to perform the <a href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListAggregatedUtterances.html">ListAggregatedUtterances</a> operation, which provides access to utterance-related analytics. See <a href="https://docs.aws.amazon.com/lexv2/latest/dg/monitoring-utterances.html">Viewing utterance statistics</a> for the IAM policy to apply to the IAM role.</p> </note> <p>Retrieves summary metrics for the utterances in your bot. The following fields are required:</p> <ul> <li> <p> <code>metrics</code> – A list of <a href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_AnalyticsUtteranceMetric.html">AnalyticsUtteranceMetric</a> objects. In each object, use the <code>name</code> field to specify the metric to calculate, the <code>statistic</code> field to specify whether to calculate the <code>Sum</code>, <code>Average</code>, or <code>Max</code> number, and the <code>order</code> field to specify whether to sort the results in <code>Ascending</code> or <code>Descending</code> order.</p> </li> <li> <p> <code>startDateTime</code> and <code>endDateTime</code> – Define a time range for which you want to retrieve results.</p> </li> </ul> <p>Of the optional fields, you can organize the results in the following ways:</p> <ul> <li> <p>Use the <code>filters</code> field to filter the results, the <code>groupBy</code> field to specify categories by which to group the results, and the <code>binBy</code> field to specify time intervals by which to group the results.</p> </li> <li> <p>Use the <code>maxResults</code> field to limit the number of results to return in a single response and the <code>nextToken</code> field to return the next batch of results if the response does not return the full set of results.</p> </li> </ul> <p>Note that an <code>order</code> field exists in both <code>binBy</code> and <code>metrics</code>. Currently, you can specify it in either field, but not in both.</p>', 'SearchAssociatedTranscripts' => '<p>Search for associated transcripts that meet the specified criteria.</p>', 'StartBotRecommendation' => '<p>Use this to provide your transcript data, and to start the bot recommendation process.</p>', 'StartBotResourceGeneration' => '<p>Starts a request for the descriptive bot builder to generate a bot locale configuration based on the prompt you provide it. After you make this call, use the <code>DescribeBotResourceGeneration</code> operation to check on the status of the generation and for the <code>generatedBotLocaleUrl</code> when the generation is complete. Use that value to retrieve the Amazon S3 object containing the bot locale configuration. You can then modify and import this configuration.</p>', 'StartImport' => '<p>Starts importing a bot, bot locale, or custom vocabulary from a zip archive that you uploaded to an S3 bucket.</p>', 'StartTestExecution' => '<p>The action to start test set execution.</p>', 'StartTestSetGeneration' => '<p>The action to start the generation of test set.</p>', 'StopBotRecommendation' => '<p>Stop an already running Bot Recommendation request.</p>', 'TagResource' => '<p>Adds the specified tags to the specified resource. If a tag key already exists, the existing value is replaced with the new value.</p>', 'UntagResource' => '<p>Removes tags from a bot, bot alias, or bot channel.</p>', 'UpdateBot' => '<p>Updates the configuration of an existing bot. </p>', 'UpdateBotAlias' => '<p>Updates the configuration of an existing bot alias.</p>', 'UpdateBotLocale' => '<p>Updates the settings that a bot has for a specific locale.</p>', 'UpdateBotRecommendation' => '<p>Updates an existing bot recommendation request.</p>', 'UpdateExport' => '<p>Updates the password used to protect an export zip archive.</p> <p>The password is not required. If you don\'t supply a password, Amazon Lex generates a zip file that is not protected by a password. This is the archive that is available at the pre-signed S3 URL provided by the <a href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DescribeExport.html">DescribeExport</a> operation.</p>', 'UpdateIntent' => '<p>Updates the settings for an intent.</p>', 'UpdateResourcePolicy' => '<p>Replaces the existing resource policy for a bot or bot alias with a new one. If the policy doesn\'t exist, Amazon Lex returns an exception.</p>', 'UpdateSlot' => '<p>Updates the settings for a slot.</p>', 'UpdateSlotType' => '<p>Updates the configuration of an existing slot type.</p>', 'UpdateTestSet' => '<p>The action to update the test set.</p>', ], 'shapes' => [ 'ActiveContext' => [ 'base' => '<p>The active context used in the test execution.</p>', 'refs' => [ 'ActiveContextList$member' => NULL, ], ], 'ActiveContextList' => [ 'base' => NULL, 'refs' => [ 'InputSessionStateSpecification$activeContexts' => '<p>Active contexts for the session state.</p>', 'UserTurnOutputSpecification$activeContexts' => '<p>The contexts that are active in the turn.</p>', ], ], 'ActiveContextName' => [ 'base' => NULL, 'refs' => [ 'ActiveContext$name' => '<p>The name of active context.</p>', ], ], 'AdvancedRecognitionSetting' => [ 'base' => '<p>Provides settings that enable advanced recognition settings for slot values.</p>', 'refs' => [ 'SlotValueSelectionSetting$advancedRecognitionSetting' => '<p>Provides settings that enable advanced recognition settings for slot values. You can use this to enable using slot values as a custom vocabulary for recognizing user utterances.</p>', ], ], 'AgentTurnResult' => [ 'base' => '<p>The information about the agent turn in a test set execution.</p>', 'refs' => [ 'TestSetTurnResult$agent' => '<p>Contains information about the agent messages in the turn.</p>', ], ], 'AgentTurnSpecification' => [ 'base' => '<p>The specification of an agent turn.</p>', 'refs' => [ 'TurnSpecification$agentTurn' => '<p>Contains information about the agent messages in the turn.</p>', ], ], 'AggregatedUtterancesFilter' => [ 'base' => '<p>Filters responses returned by the <code>ListAggregatedUtterances</code> operation.</p>', 'refs' => [ 'AggregatedUtterancesFilters$member' => NULL, ], ], 'AggregatedUtterancesFilterName' => [ 'base' => NULL, 'refs' => [ 'AggregatedUtterancesFilter$name' => '<p>The name of the field to filter the utterance list.</p>', ], ], 'AggregatedUtterancesFilterOperator' => [ 'base' => NULL, 'refs' => [ 'AggregatedUtterancesFilter$operator' => '<p>The operator to use for the filter. Specify <code>EQ</code> when the <code>ListAggregatedUtterances</code> operation should return only utterances that equal the specified value. Specify <code>CO</code> when the <code>ListAggregatedUtterances</code> operation should return utterances that contain the specified value.</p>', ], ], 'AggregatedUtterancesFilters' => [ 'base' => NULL, 'refs' => [ 'ListAggregatedUtterancesRequest$filters' => '<p>Provides the specification of a filter used to limit the utterances in the response to only those that match the filter specification. You can only specify one filter and one string to filter on.</p>', ], ], 'AggregatedUtterancesSortAttribute' => [ 'base' => NULL, 'refs' => [ 'AggregatedUtterancesSortBy$attribute' => '<p>The utterance attribute to sort by.</p>', ], ], 'AggregatedUtterancesSortBy' => [ 'base' => '<p>Specifies attributes for sorting a list of utterances.</p>', 'refs' => [ 'ListAggregatedUtterancesRequest$sortBy' => '<p>Specifies sorting parameters for the list of utterances. You can sort by the hit count, the missed count, or the number of distinct sessions the utterance appeared in.</p>', ], ], 'AggregatedUtterancesSummary' => [ 'base' => '<p>Provides summary information for aggregated utterances. The <code>ListAggregatedUtterances</code> operations combines all instances of the same utterance into a single aggregated summary.</p>', 'refs' => [ 'AggregatedUtterancesSummaryList$member' => NULL, ], ], 'AggregatedUtterancesSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListAggregatedUtterancesResponse$aggregatedUtterancesSummaries' => '<p>Summaries of the aggregated utterance data. Each response contains information about the number of times that the utterance was seen during the time period, whether it was detected or missed, and when it was seen during the time period.</p>', ], ], 'AllowedInputTypes' => [ 'base' => '<p>Specifies the allowed input types.</p>', 'refs' => [ 'PromptAttemptSpecification$allowedInputTypes' => '<p>Indicates the allowed input types of the prompt attempt.</p>', ], ], 'AmazonResourceName' => [ 'base' => NULL, 'refs' => [ 'CreateResourcePolicyRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>', 'CreateResourcePolicyResponse$resourceArn' => '<p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy was attached to.</p>', 'CreateResourcePolicyStatementRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>', 'CreateResourcePolicyStatementResponse$resourceArn' => '<p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>', 'DeleteResourcePolicyRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the bot or bot alias that has the resource policy attached.</p>', 'DeleteResourcePolicyResponse$resourceArn' => '<p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy was deleted from.</p>', 'DeleteResourcePolicyStatementRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>', 'DeleteResourcePolicyStatementResponse$resourceArn' => '<p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy statement was removed from.</p>', 'DescribeResourcePolicyRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>', 'DescribeResourcePolicyResponse$resourceArn' => '<p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>', 'ListTagsForResourceRequest$resourceARN' => '<p>The Amazon Resource Name (ARN) of the resource to get a list of tags for.</p>', 'TagResourceRequest$resourceARN' => '<p>The Amazon Resource Name (ARN) of the bot, bot alias, or bot channel to tag.</p>', 'UntagResourceRequest$resourceARN' => '<p>The Amazon Resource Name (ARN) of the resource to remove the tags from.</p>', 'UpdateResourcePolicyRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>', 'UpdateResourcePolicyResponse$resourceArn' => '<p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>', ], ], 'AnalyticsBinByList' => [ 'base' => NULL, 'refs' => [ 'ListIntentMetricsRequest$binBy' => '<p>A list of objects, each of which contains specifications for organizing the results by time.</p>', 'ListIntentStageMetricsRequest$binBy' => '<p>A list of objects, each of which contains specifications for organizing the results by time.</p>', 'ListSessionMetricsRequest$binBy' => '<p>A list of objects, each of which contains specifications for organizing the results by time.</p>', 'ListUtteranceMetricsRequest$binBy' => '<p>A list of objects, each of which contains specifications for organizing the results by time.</p>', ], ], 'AnalyticsBinByName' => [ 'base' => NULL, 'refs' => [ 'AnalyticsBinBySpecification$name' => '<p>Specifies the time metric by which to bin the analytics data.</p>', 'AnalyticsBinKey$name' => '<p>The criterion by which to bin the results.</p>', ], ], 'AnalyticsBinBySpecification' => [ 'base' => '<p>Contains the time metric, interval, and method by which to bin the analytics data.</p>', 'refs' => [ 'AnalyticsBinByList$member' => NULL, ], ], 'AnalyticsBinKey' => [ 'base' => '<p>An object containing the criterion by which to bin the results and the value that defines that bin.</p>', 'refs' => [ 'AnalyticsBinKeys$member' => NULL, ], ], 'AnalyticsBinKeys' => [ 'base' => NULL, 'refs' => [ 'AnalyticsIntentResult$binKeys' => '<p>A list of objects containing the criteria you requested for binning results and the values of the bins.</p>', 'AnalyticsIntentStageResult$binKeys' => '<p>A list of objects containing the criteria you requested for binning results and the values of the bins.</p>', 'AnalyticsSessionResult$binKeys' => '<p>A list of objects containing the criteria you requested for binning results and the values of the bins.</p>', 'AnalyticsUtteranceResult$binKeys' => '<p>A list of objects containing the criteria you requested for binning results and the values of the bins.</p>', ], ], 'AnalyticsBinValue' => [ 'base' => NULL, 'refs' => [ 'AnalyticsBinKey$value' => '<p>The value of the criterion that defines the bin.</p>', ], ], 'AnalyticsChannel' => [ 'base' => NULL, 'refs' => [ 'SessionSpecification$channel' => '<p>The channel that is integrated with the bot that the session was held with.</p>', 'UtteranceSpecification$channel' => '<p>The channel that is integrated with the bot that the utterance was made to.</p>', ], ], 'AnalyticsCommonFilterName' => [ 'base' => NULL, 'refs' => [ 'AnalyticsPathFilter$name' => '<p>The category by which to filter the intent paths. The descriptions for each option are as follows:</p> <ul> <li> <p> <code>BotAlias</code> – The name of the bot alias.</p> </li> <li> <p> <code>BotVersion</code> – The version of the bot.</p> </li> <li> <p> <code>LocaleId</code> – The locale of the bot.</p> </li> <li> <p> <code>Modality</code> – The modality of the session with the bot (audio, DTMF, or text).</p> </li> <li> <p> <code>Channel</code> – The channel that the bot is integrated with.</p> </li> </ul>', ], ], 'AnalyticsFilterOperator' => [ 'base' => NULL, 'refs' => [ 'AnalyticsIntentFilter$operator' => '<p>The operation by which to filter the category. The following operations are possible:</p> <ul> <li> <p> <code>CO</code> – Contains</p> </li> <li> <p> <code>EQ</code> – Equals</p> </li> <li> <p> <code>GT</code> – Greater than</p> </li> <li> <p> <code>LT</code> – Less than</p> </li> </ul> <p>The operators that each filter supports are listed below:</p> <ul> <li> <p> <code>BotAlias</code> – <code>EQ</code>.</p> </li> <li> <p> <code>BotVersion</code> – <code>EQ</code>.</p> </li> <li> <p> <code>LocaleId</code> – <code>EQ</code>.</p> </li> <li> <p> <code>Modality</code> – <code>EQ</code>.</p> </li> <li> <p> <code>Channel</code> – <code>EQ</code>.</p> </li> <li> <p> <code>SessionId</code> – <code>EQ</code>.</p> </li> <li> <p> <code>OriginatingRequestId</code> – <code>EQ</code>.</p> </li> <li> <p> <code>IntentName</code> – <code>EQ</code>, <code>CO</code>.</p> </li> <li> <p> <code>IntentEndState</code> – <code>EQ</code>, <code>CO</code>.</p> </li> </ul>', 'AnalyticsIntentStageFilter$operator' => '<p>The operation by which to filter the category. The following operations are possible:</p> <ul> <li> <p> <code>CO</code> – Contains</p> </li> <li> <p> <code>EQ</code> – Equals</p> </li> <li> <p> <code>GT</code> – Greater than</p> </li> <li> <p> <code>LT</code> – Less than</p> </li> </ul> <p>The operators that each filter supports are listed below:</p> <ul> <li> <p> <code>BotAlias</code> – <code>EQ</code>.</p> </li> <li> <p> <code>BotVersion</code> – <code>EQ</code>.</p> </li> <li> <p> <code>LocaleId</code> – <code>EQ</code>.</p> </li> <li> <p> <code>Modality</code> – <code>EQ</code>.</p> </li> <li> <p> <code>Channel</code> – <code>EQ</code>.</p> </li> <li> <p> <code>SessionId</code> – <code>EQ</code>.</p> </li> <li> <p> <code>OriginatingRequestId</code> – <code>EQ</code>.</p> </li> <li> <p> <code>IntentName</code> – <code>EQ</code>, <code>CO</code>.</p> </li> <li> <p> <code>IntentStageName</code> – <code>EQ</code>, <code>CO</code>.</p> </li> </ul>', 'AnalyticsPathFilter$operator' => '<p>The operation by which to filter the category. The following operations are possible:</p> <ul> <li> <p> <code>CO</code> – Contains</p> </li> <li> <p> <code>EQ</code> – Equals</p> </li> <li> <p> <code>GT</code> – Greater than</p> </li> <li> <p> <code>LT</code> – Less than</p> </li> </ul> <p>The operators that each filter supports are listed below:</p> <ul> <li> <p> <code>BotAlias</code> – <code>EQ</code>.</p> </li> <li> <p> <code>BotVersion</code> – <code>EQ</code>.</p> </li> <li> <p> <code>LocaleId</code> – <code>EQ</code>.</p> </li> <li> <p> <code>Modality</code> – <code>EQ</code>.</p> </li> <li> <p> <code>Channel</code> – <code>EQ</code>.</p> </li> </ul>', 'AnalyticsSessionFilter$operator' => '<p>The operation by which to filter the category. The following operations are possible:</p> <ul> <li> <p> <code>CO</code> – Contains</p> </li> <li> <p> <code>EQ</code> – Equals</p> </li> <li> <p> <code>GT</code> – Greater than</p> </li> <li> <p> <code>LT</code> – Less than</p> </li> </ul> <p>The operators that each filter supports are listed below:</p> <ul> <li> <p> <code>BotAlias</code> – <code>EQ</code>.</p> </li> <li> <p> <code>BotVersion</code> – <code>EQ</code>.</p> </li> <li> <p> <code>LocaleId</code> – <code>EQ</code>.</p> </li> <li> <p> <code>Modality</code> – <code>EQ</code>.</p> </li> <li> <p> <code>Channel</code> – <code>EQ</code>.</p> </li> <li> <p> <code>Duration</code> – <code>EQ</code>, <code>GT</code>, <code>LT</code>.</p> </li> <li> <p> <code>conversationEndState</code> – <code>EQ</code>, <code>CO</code>.</p> </li> <li> <p> <code>SessionId</code> – <code>EQ</code>.</p> </li> <li> <p> <code>OriginatingRequestId</code> – <code>EQ</code>.</p> </li> <li> <p> <code>IntentPath</code> – <code>EQ</code>.</p> </li> </ul>', 'AnalyticsUtteranceFilter$operator' => '<p>The operation by which to filter the category. The following operations are possible:</p> <ul> <li> <p> <code>CO</code> – Contains</p> </li> <li> <p> <code>EQ</code> – Equals</p> </li> <li> <p> <code>GT</code> – Greater than</p> </li> <li> <p> <code>LT</code> – Less than</p> </li> </ul> <p>The operators that each filter supports are listed below:</p> <ul> <li> <p> <code>BotAlias</code> – <code>EQ</code>.</p> </li> <li> <p> <code>BotVersion</code> – <code>EQ</code>.</p> </li> <li> <p> <code>LocaleId</code> – <code>EQ</code>.</p> </li> <li> <p> <code>Modality</code> – <code>EQ</code>.</p> </li> <li> <p> <code>Channel</code> – <code>EQ</code>.</p> </li> <li> <p> <code>SessionId</code> – <code>EQ</code>.</p> </li> <li> <p> <code>OriginatingRequestId</code> – <code>EQ</code>.</p> </li> <li> <p> <code>UtteranceState</code> – <code>EQ</code>.</p> </li> <li> <p> <code>UtteranceText</code> – <code>EQ</code>, <code>CO</code>.</p> </li> </ul>', ], ], 'AnalyticsFilterValue' => [ 'base' => NULL, 'refs' => [ 'AnalyticsFilterValues$member' => NULL, ], ], 'AnalyticsFilterValues' => [ 'base' => NULL, 'refs' => [ 'AnalyticsIntentFilter$values' => '<p>An array containing the values of the category by which to apply the operator to filter the results. You can provide multiple values if the operator is <code>EQ</code> or <code>CO</code>. If you provide multiple values, you filter for results that equal/contain any of the values. For example, if the <code>name</code>, <code>operator</code>, and <code>values</code> fields are <code>Modality</code>, <code>EQ</code>, and <code>[Speech, Text]</code>, the operation filters for results where the modality was either <code>Speech</code> or <code>Text</code>.</p>', 'AnalyticsIntentStageFilter$values' => '<p>An array containing the values of the category by which to apply the operator to filter the results. You can provide multiple values if the operator is <code>EQ</code> or <code>CO</code>. If you provide multiple values, you filter for results that equal/contain any of the values. For example, if the <code>name</code>, <code>operator</code>, and <code>values</code> fields are <code>Modality</code>, <code>EQ</code>, and <code>[Speech, Text]</code>, the operation filters for results where the modality was either <code>Speech</code> or <code>Text</code>.</p>', 'AnalyticsPathFilter$values' => '<p>An array containing the values of the category by which to apply the operator to filter the results. You can provide multiple values if the operator is <code>EQ</code> or <code>CO</code>. If you provide multiple values, you filter for results that equal/contain any of the values. For example, if the <code>name</code>, <code>operator</code>, and <code>values</code> fields are <code>Modality</code>, <code>EQ</code>, and <code>[Speech, Text]</code>, the operation filters for results where the modality was either <code>Speech</code> or <code>Text</code>.</p>', 'AnalyticsSessionFilter$values' => '<p>An array containing the values of the category by which to apply the operator to filter the results. You can provide multiple values if the operator is <code>EQ</code> or <code>CO</code>. If you provide multiple values, you filter for results that equal/contain any of the values. For example, if the <code>name</code>, <code>operator</code>, and <code>values</code> fields are <code>Modality</code>, <code>EQ</code>, and <code>[Speech, Text]</code>, the operation filters for results where the modality was either <code>Speech</code> or <code>Text</code>.</p>', 'AnalyticsUtteranceFilter$values' => '<p>An array containing the values of the category by which to apply the operator to filter the results. You can provide multiple values if the operator is <code>EQ</code> or <code>CO</code>. If you provide multiple values, you filter for results that equal/contain any of the values. For example, if the <code>name</code>, <code>operator</code>, and <code>values</code> fields are <code>Modality</code>, <code>EQ</code>, and <code>[Speech, Text]</code>, the operation filters for results where the modality was either <code>Speech</code> or <code>Text</code>.</p>', ], ], 'AnalyticsGroupByValue' => [ 'base' => NULL, 'refs' => [ 'AnalyticsIntentGroupByKey$value' => '<p>A member of the category by which the intent analytics were grouped.</p>', 'AnalyticsIntentStageGroupByKey$value' => '<p>A member of the category by which the intent stage analytics were grouped.</p>', 'AnalyticsSessionGroupByKey$value' => '<p>A member of the category by which the session analytics were grouped.</p>', 'AnalyticsUtteranceGroupByKey$value' => '<p>A member of the category by which the utterance analytics were grouped.</p>', ], ], 'AnalyticsIntentField' => [ 'base' => NULL, 'refs' => [ 'AnalyticsIntentGroupByKey$name' => '<p>A category by which the intent analytics were grouped.</p>', 'AnalyticsIntentGroupBySpecification$name' => '<p>Specifies whether to group the intent stages by their name or their end state.</p>', ], ], 'AnalyticsIntentFilter' => [ 'base' => '<p>Contains fields describing a condition by which to filter the intents. The expression may be understood as <code>name</code> <code>operator</code> <code>values</code>. For example:</p> <ul> <li> <p> <code>IntentName CO Book</code> – The intent name contains the string "Book."</p> </li> <li> <p> <code>BotVersion EQ 2</code> – The bot version is equal to two.</p> </li> </ul> <p>The operators that each filter supports are listed below:</p> <ul> <li> <p> <code>BotAlias</code> – <code>EQ</code>.</p> </li> <li> <p> <code>BotVersion</code> – <code>EQ</code>.</p> </li> <li> <p> <code>LocaleId</code> – <code>EQ</code>.</p> </li> <li> <p> <code>Modality</code> – <code>EQ</code>.</p> </li> <li> <p> <code>Channel</code> – <code>EQ</code>.</p> </li> <li> <p> <code>SessionId</code> – <code>EQ</code>.</p> </li> <li> <p> <code>OriginatingRequestId</code> – <code>EQ</code>.</p> </li> <li> <p> <code>IntentName</code> – <code>EQ</code>, <code>CO</code>.</p> </li> <li> <p> <code>IntentEndState</code> – <code>EQ</code>, <code>CO</code>.</p> </li> </ul>', 'refs' => [ 'AnalyticsIntentFilters$member' => NULL, ], ], 'AnalyticsIntentFilterName' => [ 'base' => NULL, 'refs' => [ 'AnalyticsIntentFilter$name' => '<p>The category by which to filter the intents. The descriptions for each option are as follows:</p> <ul> <li> <p> <code>BotAlias</code> – The name of the bot alias.</p> </li> <li> <p> <code>BotVersion</code> – The version of the bot.</p> </li> <li> <p> <code>LocaleId</code> – The locale of the bot.</p> </li> <li> <p> <code>Modality</code> – The modality of the session with the bot (audio, DTMF, or text).</p> </li> <li> <p> <code>Channel</code> – The channel that the bot is integrated with.</p> </li> <li> <p> <code>SessionId</code> – The identifier of the session with the bot.</p> </li> <li> <p> <code>OriginatingRequestId</code> – The identifier of the first request in a session.</p> </li> <li> <p> <code>IntentName</code> – The name of the intent.</p> </li> <li> <p> <code>IntentEndState</code> – The final state of the intent.</p> </li> </ul>', ], ], 'AnalyticsIntentFilters' => [ 'base' => NULL, 'refs' => [ 'ListIntentMetricsRequest$filters' => '<p>A list of objects, each of which describes a condition by which you want to filter the results.</p>', ], ], 'AnalyticsIntentGroupByKey' => [ 'base' => '<p>Contains the category by which the intent analytics were grouped and a member of that category.</p>', 'refs' => [ 'AnalyticsIntentGroupByKeys$member' => NULL, ], ], 'AnalyticsIntentGroupByKeys' => [ 'base' => NULL, 'refs' => [ 'AnalyticsIntentResult$groupByKeys' => '<p>A list of objects containing the criteria you requested for grouping results and the values of the groups.</p>', ], ], 'AnalyticsIntentGroupByList' => [ 'base' => NULL, 'refs' => [ 'ListIntentMetricsRequest$groupBy' => '<p>A list of objects, each of which specifies how to group the results. You can group by the following criteria:</p> <ul> <li> <p> <code>IntentName</code> – The name of the intent.</p> </li> <li> <p> <code>IntentEndState</code> – The final state of the intent. The possible end states are detailed in <a href="https://docs.aws.amazon.com/analytics-key-definitions-intents">Key definitions</a> in the user guide.</p> </li> </ul>', ], ], 'AnalyticsIntentGroupBySpecification' => [ 'base' => '<p>Contains the category by which to group the intents.</p>', 'refs' => [ 'AnalyticsIntentGroupByList$member' => NULL, ], ], 'AnalyticsIntentMetric' => [ 'base' => '<p>Contains the metric and the summary statistic you want to calculate, and the order in which to sort the results, for the intents in the bot.</p>', 'refs' => [ 'AnalyticsIntentMetrics$member' => NULL, ], ], 'AnalyticsIntentMetricName' => [ 'base' => NULL, 'refs' => [ 'AnalyticsIntentMetric$name' => '<p>The metric for which you want to get intent summary statistics.</p> <ul> <li> <p> <code>Count</code> – The number of times the intent was invoked.</p> </li> <li> <p> <code>Success</code> – The number of times the intent succeeded.</p> </li> <li> <p> <code>Failure</code> – The number of times the intent failed.</p> </li> <li> <p> <code>Switched</code> – The number of times there was a switch to a different intent.</p> </li> <li> <p> <code>Dropped</code> – The number of times the user dropped the intent.</p> </li> </ul>', 'AnalyticsIntentMetricResult$name' => '<p>The metric that you requested. See <a href="https://docs.aws.amazon.com/lexv2/latest/dg/analytics-key-definitions.html">Key definitions</a> for more details about these metrics.</p> <ul> <li> <p> <code>Count</code> – The number of times the intent was invoked.</p> </li> <li> <p> <code>Success</code> – The number of times the intent succeeded.</p> </li> <li> <p> <code>Failure</code> – The number of times the intent failed.</p> </li> <li> <p> <code>Switched</code> – The number of times there was a switch to a different intent.</p> </li> <li> <p> <code>Dropped</code> – The number of times the user dropped the intent.</p> </li> </ul>', ], ], 'AnalyticsIntentMetricResult' => [ 'base' => '<p>An object containing the results for the intent metric you requested.</p>', 'refs' => [ 'AnalyticsIntentMetricResults$member' => NULL, ], ], 'AnalyticsIntentMetricResults' => [ 'base' => NULL, 'refs' => [ 'AnalyticsIntentResult$metricsResults' => '<p>A list of objects, each of which contains a metric you want to list, the statistic for the metric you want to return, and the method by which to organize the results.</p>', ], ], 'AnalyticsIntentMetrics' => [ 'base' => NULL, 'refs' => [ 'ListIntentMetricsRequest$metrics' => '<p>A list of objects, each of which contains a metric you want to list, the statistic for the metric you want to return, and the order by which to organize the results.</p>', ], ], 'AnalyticsIntentNodeSummaries' => [ 'base' => NULL, 'refs' => [ 'ListIntentPathsResponse$nodeSummaries' => '<p>A list of objects, each of which contains information about a node in the intent path for which you requested metrics.</p>', ], ], 'AnalyticsIntentNodeSummary' => [ 'base' => '<p>An object containing information about the requested path.</p>', 'refs' => [ 'AnalyticsIntentNodeSummaries$member' => NULL, ], ], 'AnalyticsIntentResult' => [ 'base' => '<p>An object containing the results for the intent metrics you requested and the bin and/or group(s) they refer to, if applicable.</p>', 'refs' => [ 'AnalyticsIntentResults$member' => NULL, ], ], 'AnalyticsIntentResults' => [ 'base' => NULL, 'refs' => [ 'ListIntentMetricsResponse$results' => '<p>The results for the intent metrics.</p>', ], ], 'AnalyticsIntentStageField' => [ 'base' => NULL, 'refs' => [ 'AnalyticsIntentStageGroupByKey$name' => '<p>A category by which the intent stage analytics were grouped.</p>', 'AnalyticsIntentStageGroupBySpecification$name' => '<p>Specifies whether to group the intent stages by their name or the intent to which the session was switched.</p>', ], ], 'AnalyticsIntentStageFilter' => [ 'base' => '<p>Contains fields describing a condition by which to filter the intent stages. The expression may be understood as <code>name</code> <code>operator</code> <code>values</code>. For example:</p> <ul> <li> <p> <code>IntentName CO Book</code> – The intent name contains the string "Book."</p> </li> <li> <p> <code>BotVersion EQ 2</code> – The bot version is equal to two.</p> </li> </ul> <p>The operators that each filter supports are listed below:</p> <ul> <li> <p> <code>BotAlias</code> – <code>EQ</code>.</p> </li> <li> <p> <code>BotVersion</code> – <code>EQ</code>.</p> </li> <li> <p> <code>LocaleId</code> – <code>EQ</code>.</p> </li> <li> <p> <code>Modality</code> – <code>EQ</code>.</p> </li> <li> <p> <code>Channel</code> – <code>EQ</code>.</p> </li> <li> <p> <code>SessionId</code> – <code>EQ</code>.</p> </li> <li> <p> <code>OriginatingRequestId</code> – <code>EQ</code>.</p> </li> <li> <p> <code>IntentName</code> – <code>EQ</code>, <code>CO</code>.</p> </li> <li> <p> <code>IntentStageName</code> – <code>EQ</code>, <code>CO</code>.</p> </li> </ul>', 'refs' => [ 'AnalyticsIntentStageFilters$member' => NULL, ], ], 'AnalyticsIntentStageFilterName' => [ 'base' => NULL, 'refs' => [ 'AnalyticsIntentStageFilter$name' => '<p>The category by which to filter the intent stages. The descriptions for each option are as follows:</p> <ul> <li> <p> <code>BotAlias</code> – The name of the bot alias.</p> </li> <li> <p> <code>BotVersion</code> – The version of the bot.</p> </li> <li> <p> <code>LocaleId</code> – The locale of the bot.</p> </li> <li> <p> <code>Modality</code> – The modality of the session with the bot (audio, DTMF, or text).</p> </li> <li> <p> <code>Channel</code> – The channel that the bot is integrated with.</p> </li> <li> <p> <code>SessionId</code> – The identifier of the session with the bot.</p> </li> <li> <p> <code>OriginatingRequestId</code> – The identifier of the first request in a session.</p> </li> <li> <p> <code>IntentName</code> – The name of the intent.</p> </li> <li> <p> <code>IntentStageName</code> – The stage in the intent.</p> </li> </ul>', ], ], 'AnalyticsIntentStageFilters' => [ 'base' => NULL, 'refs' => [ 'ListIntentStageMetricsRequest$filters' => '<p>A list of objects, each of which describes a condition by which you want to filter the results.</p>', ], ], 'AnalyticsIntentStageGroupByKey' => [ 'base' => '<p>Contains the category by which the intent stage analytics and the values for that category were grouped.</p>', 'refs' => [ 'AnalyticsIntentStageGroupByKeys$member' => NULL, ], ], 'AnalyticsIntentStageGroupByKeys' => [ 'base' => NULL, 'refs' => [ 'AnalyticsIntentStageResult$groupByKeys' => '<p>A list of objects containing the criteria you requested for grouping results and the values of the bins.</p>', ], ], 'AnalyticsIntentStageGroupByList' => [ 'base' => NULL, 'refs' => [ 'ListIntentStageMetricsRequest$groupBy' => '<p>A list of objects, each of which specifies how to group the results. You can group by the following criteria:</p> <ul> <li> <p> <code>IntentStageName</code> – The name of the intent stage.</p> </li> <li> <p> <code>SwitchedToIntent</code> – The intent to which the conversation was switched (if any).</p> </li> </ul>', ], ], 'AnalyticsIntentStageGroupBySpecification' => [ 'base' => '<p>Contains the category by which to group the intent stages.</p>', 'refs' => [ 'AnalyticsIntentStageGroupByList$member' => NULL, ], ], 'AnalyticsIntentStageMetric' => [ 'base' => '<p>Contains the metric and the summary statistic you want to calculate, and the order in which to sort the results, for the intent stages across the user sessions with the bot.</p>', 'refs' => [ 'AnalyticsIntentStageMetrics$member' => NULL, ], ], 'AnalyticsIntentStageMetricName' => [ 'base' => NULL, 'refs' => [ 'AnalyticsIntentStageMetric$name' => '<p>The metric for which you want to get intent stage summary statistics. See <a href="https://docs.aws.amazon.com/lexv2/latest/dg/analytics-key-definitions.html">Key definitions</a> for more details about these metrics.</p> <ul> <li> <p> <code>Count</code> – The number of times the intent stage occurred.</p> </li> <li> <p> <code>Success</code> – The number of times the intent stage succeeded.</p> </li> <li> <p> <code>Failure</code> – The number of times the intent stage failed.</p> </li> <li> <p> <code>Dropped</code> – The number of times the user dropped the intent stage.</p> </li> <li> <p> <code>Retry</code> – The number of times the bot tried to elicit a response from the user at this stage.</p> </li> </ul>', 'AnalyticsIntentStageMetricResult$name' => '<p>The metric that you requested.</p> <ul> <li> <p> <code>Count</code> – The number of times the intent stage occurred.</p> </li> <li> <p> <code>Success</code> – The number of times the intent stage succeeded.</p> </li> <li> <p> <code>Failure</code> – The number of times the intent stage failed.</p> </li> <li> <p> <code>Dropped</code> – The number of times the user dropped the intent stage.</p> </li> <li> <p> <code>Retry</code> – The number of times the bot tried to elicit a response from the user at this stage.</p> </li> </ul>', ], ], 'AnalyticsIntentStageMetricResult' => [ 'base' => '<p>An object containing the results for an intent stage metric you requested.</p>', 'refs' => [ 'AnalyticsIntentStageMetricResults$member' => NULL, ], ], 'AnalyticsIntentStageMetricResults' => [ 'base' => NULL, 'refs' => [ 'AnalyticsIntentStageResult$metricsResults' => '<p>A list of objects, each of which contains a metric you want to list, the statistic for the metric you want to return, and the method by which to organize the results.</p>', ], ], 'AnalyticsIntentStageMetrics' => [ 'base' => NULL, 'refs' => [ 'ListIntentStageMetricsRequest$metrics' => '<p>A list of objects, each of which contains a metric you want to list, the statistic for the metric you want to return, and the method by which to organize the results.</p>', ], ], 'AnalyticsIntentStageResult' => [ 'base' => '<p>An object containing the results for the intent stage metrics you requested and the bin and/or group they refer to, if applicable.</p>', 'refs' => [ 'AnalyticsIntentStageResults$member' => NULL, ], ], 'AnalyticsIntentStageResults' => [ 'base' => NULL, 'refs' => [ 'ListIntentStageMetricsResponse$results' => '<p>The results for the intent stage metrics.</p>', ], ], 'AnalyticsInterval' => [ 'base' => NULL, 'refs' => [ 'AnalyticsBinBySpecification$interval' => '<p>Specifies the interval of time by which to bin the analytics data.</p>', ], ], 'AnalyticsLongValue' => [ 'base' => NULL, 'refs' => [ 'SessionSpecification$conversationDurationSeconds' => '<p>The duration of the conversation in seconds. A conversation is defined as a unique combination of a <code>sessionId</code> and an <code>originatingRequestId</code>.</p>', 'SessionSpecification$numberOfTurns' => '<p>The number of turns that the session took.</p>', 'UtteranceSpecification$audioVoiceDurationMillis' => '<p>The duration in milliseconds of the audio associated with the utterance.</p>', ], ], 'AnalyticsMetricStatistic' => [ 'base' => NULL, 'refs' => [ 'AnalyticsIntentMetric$statistic' => '<p>The summary statistic to calculate.</p> <ul> <li> <p> <code>Sum</code> – The total count for the category you provide in <code>name</code>.</p> </li> <li> <p> <code>Average</code> – The total count divided by the number of intents in the category you provide in <code>name</code>.</p> </li> <li> <p> <code>Max</code> – The highest count in the category you provide in <code>name</code>.</p> </li> </ul>', 'AnalyticsIntentMetricResult$statistic' => '<p>The statistic that you requested to calculate.</p> <ul> <li> <p> <code>Sum</code> – The total count for the category you provide in <code>name</code>.</p> </li> <li> <p> <code>Average</code> – The total count divided by the number of intents in the category you provide in <code>name</code>.</p> </li> <li> <p> <code>Max</code> – The highest count in the category you provide in <code>name</code>.</p> </li> </ul>', 'AnalyticsIntentStageMetric$statistic' => '<p>The summary statistic to calculate.</p> <ul> <li> <p> <code>Sum</code> – The total count for the category you provide in <code>name</code>.</p> </li> <li> <p> <code>Average</code> – The total count divided by the number of intent stages in the category you provide in <code>name</code>.</p> </li> <li> <p> <code>Max</code> – The highest count in the category you provide in <code>name</code>.</p> </li> </ul>', 'AnalyticsIntentStageMetricResult$statistic' => '<p>The summary statistic that you requested to calculate.</p> <ul> <li> <p> <code>Sum</code> – The total count for the category you provide in <code>name</code>.</p> </li> <li> <p> <code>Average</code> – The total count divided by the number of intent stages in the category you provide in <code>name</code>.</p> </li> <li> <p> <code>Max</code> – The highest count in the category you provide in <code>name</code>.</p> </li> </ul>', 'AnalyticsSessionMetric$statistic' => '<p>The summary statistic to calculate.</p> <ul> <li> <p> <code>Sum</code> – The total count for the category you provide in <code>name</code>.</p> </li> <li> <p> <code>Average</code> – The total count divided by the number of sessions in the category you provide in <code>name</code>.</p> </li> <li> <p> <code>Max</code> – The highest count in the category you provide in <code>name</code>.</p> </li> </ul>', 'AnalyticsSessionMetricResult$statistic' => '<p>The summary statistic that you requested to calculate.</p> <ul> <li> <p> <code>Sum</code> – The total count for the category you provide in <code>name</code>.</p> </li> <li> <p> <code>Average</code> – The total count divided by the number of sessions in the category you provide in <code>name</code>.</p> </li> <li> <p> <code>Max</code> – The highest count in the category you provide in <code>name</code>.</p> </li> </ul>', 'AnalyticsUtteranceMetric$statistic' => '<p>The summary statistic to calculate.</p> <ul> <li> <p> <code>Sum</code> – The total count for the category you provide in <code>name</code>.</p> </li> <li> <p> <code>Average</code> – The total count divided by the number of utterances in the category you provide in <code>name</code>.</p> </li> <li> <p> <code>Max</code> – The highest count in the category you provide in <code>name</code>.</p> </li> </ul>', 'AnalyticsUtteranceMetricResult$statistic' => '<p>The summary statistic that you requested to calculate.</p> <ul> <li> <p> <code>Sum</code> – The total count for the category you provide in <code>name</code>.</p> </li> <li> <p> <code>Average</code> – The total count divided by the number of utterances in the category you provide in <code>name</code>.</p> </li> <li> <p> <code>Max</code> – The highest count in the category you provide in <code>name</code>.</p> </li> </ul>', ], ], 'AnalyticsMetricValue' => [ 'base' => NULL, 'refs' => [ 'AnalyticsIntentMetricResult$value' => '<p>The value of the summary statistic for the metric that you requested.</p>', 'AnalyticsIntentStageMetricResult$value' => '<p>The value of the summary statistic for the metric that you requested.</p>', 'AnalyticsSessionMetricResult$value' => '<p>The value of the summary statistic for the metric that you requested.</p>', 'AnalyticsUtteranceMetricResult$value' => '<p>The value of the summary statistic for the metric that you requested.</p>', ], ], 'AnalyticsModality' => [ 'base' => NULL, 'refs' => [ 'SessionSpecification$mode' => '<p>The mode of the session. The possible values are as follows:</p> <ul> <li> <p> <code>Speech</code> – The session was spoken.</p> </li> <li> <p> <code>Text</code> – The session was written.</p> </li> <li> <p> <code>DTMF</code> – The session used a touch-tone keypad (Dual Tone Multi-Frequency).</p> </li> <li> <p> <code>MultiMode</code> – The session used multiple modes.</p> </li> </ul>', 'UtteranceSpecification$mode' => '<p>The mode of the session. The possible values are as follows:</p> <ul> <li> <p> <code>Speech</code> – The session consisted of spoken dialogue.</p> </li> <li> <p> <code>Text</code> – The session consisted of written dialogue.</p> </li> <li> <p> <code>DTMF</code> – The session consisted of touch-tone keypad (Dual Tone Multi-Frequency) key presses.</p> </li> <li> <p> <code>MultiMode</code> – The session consisted of multiple modes.</p> </li> </ul>', ], ], 'AnalyticsNodeCount' => [ 'base' => NULL, 'refs' => [ 'AnalyticsIntentNodeSummary$intentCount' => '<p>The total number of sessions that follow the given path to the given intent.</p>', ], ], 'AnalyticsNodeLevel' => [ 'base' => NULL, 'refs' => [ 'AnalyticsIntentNodeSummary$intentLevel' => '<p>The number of intents up to and including the requested path.</p>', ], ], 'AnalyticsNodeType' => [ 'base' => NULL, 'refs' => [ 'AnalyticsIntentNodeSummary$nodeType' => '<p>Specifies whether the node is the end of a path (<code>Exit</code>) or not (<code>Inner</code>).</p>', ], ], 'AnalyticsOriginatingRequestId' => [ 'base' => NULL, 'refs' => [ 'SessionSpecification$originatingRequestId' => '<p>The identifier of the first request in a session.</p>', ], ], 'AnalyticsPath' => [ 'base' => NULL, 'refs' => [ 'AnalyticsIntentNodeSummary$intentPath' => '<p>The path.</p>', 'ListIntentPathsRequest$intentPath' => '<p>The intent path for which you want to retrieve metrics. Use a forward slash to separate intents in the path. For example:</p> <ul> <li> <p>/BookCar</p> </li> <li> <p>/BookCar/BookHotel</p> </li> <li> <p>/BookHotel/BookCar</p> </li> </ul>', ], ], 'AnalyticsPathFilter' => [ 'base' => '<p>Contains fields describing a condition by which to filter the paths. The expression may be understood as <code>name</code> <code>operator</code> <code>values</code>. For example:</p> <ul> <li> <p> <code>LocaleId EQ en</code> – The locale is "en".</p> </li> <li> <p> <code>BotVersion EQ 2</code> – The bot version is equal to two.</p> </li> </ul> <p>The operators that each filter supports are listed below:</p> <ul> <li> <p> <code>BotAlias</code> – <code>EQ</code>.</p> </li> <li> <p> <code>BotVersion</code> – <code>EQ</code>.</p> </li> <li> <p> <code>LocaleId</code> – <code>EQ</code>.</p> </li> <li> <p> <code>Modality</code> – <code>EQ</code>.</p> </li> <li> <p> <code>Channel</code> – <code>EQ</code>.</p> </li> </ul>', 'refs' => [ 'AnalyticsPathFilters$member' => NULL, ], ], 'AnalyticsPathFilters' => [ 'base' => NULL, 'refs' => [ 'ListIntentPathsRequest$filters' => '<p>A list of objects, each describes a condition by which you want to filter the results.</p>', ], ], 'AnalyticsSessionField' => [ 'base' => NULL, 'refs' => [ 'AnalyticsSessionGroupByKey$name' => '<p>The category by which the session analytics were grouped.</p>', 'AnalyticsSessionGroupBySpecification$name' => '<p>Specifies whether to group the session by their end state or their locale.</p>', ], ], 'AnalyticsSessionFilter' => [ 'base' => '<p>Contains fields describing a condition by which to filter the sessions. The expression may be understood as <code>name</code> <code>operator</code> <code>values</code>. For example:</p> <ul> <li> <p> <code>LocaleId EQ en</code> – The locale is "en".</p> </li> <li> <p> <code>Duration GT 200</code> – The duration is greater than 200 seconds.</p> </li> </ul> <p>The operators that each filter supports are listed below:</p> <ul> <li> <p> <code>BotAlias</code> – <code>EQ</code>.</p> </li> <li> <p> <code>BotVersion</code> – <code>EQ</code>.</p> </li> <li> <p> <code>LocaleId</code> – <code>EQ</code>.</p> </li> <li> <p> <code>Modality</code> – <code>EQ</code>.</p> </li> <li> <p> <code>Channel</code> – <code>EQ</code>.</p> </li> <li> <p> <code>Duration</code> – <code>EQ</code>, <code>GT</code>, <code>LT</code>.</p> </li> <li> <p> <code>conversationEndState</code> – <code>EQ</code>, <code>CO</code>.</p> </li> <li> <p> <code>SessionId</code> – <code>EQ</code>.</p> </li> <li> <p> <code>OriginatingRequestId</code> – <code>EQ</code>.</p> </li> <li> <p> <code>IntentPath</code> – <code>EQ</code>.</p> </li> </ul>', 'refs' => [ 'AnalyticsSessionFilters$member' => NULL, ], ], 'AnalyticsSessionFilterName' => [ 'base' => NULL, 'refs' => [ 'AnalyticsSessionFilter$name' => '<p>The category by which to filter the sessions. The descriptions for each option are as follows:</p> <ul> <li> <p> <code>BotAlias</code> – The name of the bot alias.</p> </li> <li> <p> <code>BotVersion</code> – The version of the bot.</p> </li> <li> <p> <code>LocaleId</code> – The locale of the bot.</p> </li> <li> <p> <code>Modality</code> – The modality of the session with the bot (audio, DTMF, or text).</p> </li> <li> <p> <code>Channel</code> – The channel that the bot is integrated with.</p> </li> <li> <p> <code>Duration</code> – The duration of the session.</p> </li> <li> <p> <code>conversationEndState</code> – The final state of the session.</p> </li> <li> <p> <code>SessionId</code> – The identifier of the session with the bot.</p> </li> <li> <p> <code>OriginatingRequestId</code> – The identifier of the first request in a session.</p> </li> <li> <p> <code>IntentPath</code> – The order of intents taken in a session.</p> </li> </ul>', ], ], 'AnalyticsSessionFilters' => [ 'base' => NULL, 'refs' => [ 'ListSessionAnalyticsDataRequest$filters' => '<p>A list of objects, each of which describes a condition by which you want to filter the results.</p>', 'ListSessionMetricsRequest$filters' => '<p>A list of objects, each of which describes a condition by which you want to filter the results.</p>', ], ], 'AnalyticsSessionGroupByKey' => [ 'base' => '<p>Contains the category by which the session analytics were grouped and a member of that category.</p>', 'refs' => [ 'AnalyticsSessionGroupByKeys$member' => NULL, ], ], 'AnalyticsSessionGroupByKeys' => [ 'base' => NULL, 'refs' => [ 'AnalyticsSessionResult$groupByKeys' => '<p>A list of objects containing the criteria you requested for grouping results and the values of the bins.</p>', ], ], 'AnalyticsSessionGroupByList' => [ 'base' => NULL, 'refs' => [ 'ListSessionMetricsRequest$groupBy' => '<p>A list of objects, each of which specifies how to group the results. You can group by the following criteria:</p> <ul> <li> <p> <code>ConversationEndState</code> – The final state of the conversation. The possible end states are detailed in <a href="https://docs.aws.amazon.com/analytics-key-definitions-conversations">Key definitions</a> in the user guide.</p> </li> <li> <p> <code>LocaleId</code> – The unique identifier of the bot locale.</p> </li> </ul>', ], ], 'AnalyticsSessionGroupBySpecification' => [ 'base' => '<p>Contains the category by which to group the sessions.</p>', 'refs' => [ 'AnalyticsSessionGroupByList$member' => NULL, ], ], 'AnalyticsSessionId' => [ 'base' => NULL, 'refs' => [ 'SessionSpecification$sessionId' => '<p>The identifier of the session.</p>', 'UtteranceSpecification$sessionId' => '<p>The identifier of the session that the utterance was made in.</p>', ], ], 'AnalyticsSessionMetric' => [ 'base' => '<p>Contains the metric and the summary statistic you want to calculate, and the order in which to sort the results, for the user sessions with the bot.</p>', 'refs' => [ 'AnalyticsSessionMetrics$member' => NULL, ], ], 'AnalyticsSessionMetricName' => [ 'base' => NULL, 'refs' => [ 'AnalyticsSessionMetric$name' => '<p>The metric for which you want to get session summary statistics.</p> <ul> <li> <p> <code>Count</code> – The number of sessions.</p> </li> <li> <p> <code>Success</code> – The number of sessions that succeeded.</p> </li> <li> <p> <code>Failure</code> – The number of sessions that failed.</p> </li> <li> <p> <code>Dropped</code> – The number of sessions that the user dropped.</p> </li> <li> <p> <code>Duration</code> – The duration of sessions.</p> </li> <li> <p> <code>TurnsPerSession</code> – The number of turns in the sessions.</p> </li> <li> <p> <code>Concurrency</code> – The number of sessions occurring in the same period of time.</p> </li> </ul>', 'AnalyticsSessionMetricResult$name' => '<p>The metric that you requested.</p> <ul> <li> <p> <code>Count</code> – The number of sessions.</p> </li> <li> <p> <code>Success</code> – The number of sessions that succeeded.</p> </li> <li> <p> <code>Failure</code> – The number of sessions that failed.</p> </li> <li> <p> <code>Dropped</code> – The number of sessions that the user dropped.</p> </li> <li> <p> <code>Duration</code> – The duration of sessions.</p> </li> <li> <p> <code>TurnPersession</code> – The number of turns in the sessions.</p> </li> <li> <p> <code>Concurrency</code> – The number of sessions occurring in the same period of time.</p> </li> </ul>', ], ], 'AnalyticsSessionMetricResult' => [ 'base' => '<p>An object containing the results for a session metric you requested.</p>', 'refs' => [ 'AnalyticsSessionMetricResults$member' => NULL, ], ], 'AnalyticsSessionMetricResults' => [ 'base' => NULL, 'refs' => [ 'AnalyticsSessionResult$metricsResults' => '<p>A list of objects, each of which contains a metric you want to list, the statistic for the metric you want to return, and the method by which to organize the results.</p>', ], ], 'AnalyticsSessionMetrics' => [ 'base' => NULL, 'refs' => [ 'ListSessionMetricsRequest$metrics' => '<p>A list of objects, each of which contains a metric you want to list, the statistic for the metric you want to return, and the method by which to organize the results.</p>', ], ], 'AnalyticsSessionResult' => [ 'base' => '<p>An object containing the results for the session metrics you requested and the bin and/or group(s) they refer to, if applicable.</p>', 'refs' => [ 'AnalyticsSessionResults$member' => NULL, ], ], 'AnalyticsSessionResults' => [ 'base' => NULL, 'refs' => [ 'ListSessionMetricsResponse$results' => '<p>The results for the session metrics.</p>', ], ], 'AnalyticsSessionSortByName' => [ 'base' => NULL, 'refs' => [ 'SessionDataSortBy$name' => '<p>The measure by which to sort the session analytics data.</p> <ul> <li> <p> <code>conversationStartTime</code> – The date and time when the conversation began. A conversation is defined as a unique combination of a <code>sessionId</code> and an <code>originatingRequestId</code>.</p> </li> <li> <p> <code>numberOfTurns</code> – The number of turns that the session took.</p> </li> <li> <p> <code>conversationDurationSeconds</code> – The duration of the conversation in seconds.</p> </li> </ul>', ], ], 'AnalyticsSortOrder' => [ 'base' => NULL, 'refs' => [ 'AnalyticsBinBySpecification$order' => '<p>Specifies whether to bin the analytics data in ascending or descending order. If this field is left blank, the default order is by the key of the bin in descending order.</p>', 'AnalyticsIntentMetric$order' => '<p>Specifies whether to sort the results in ascending or descending order.</p>', 'AnalyticsIntentStageMetric$order' => '<p>Specifies whether to sort the results in ascending or descending order of the summary statistic (<code>value</code> in the response).</p>', 'AnalyticsSessionMetric$order' => '<p>Specifies whether to sort the results in ascending or descending order.</p>', 'AnalyticsUtteranceMetric$order' => '<p>Specifies whether to sort the results in ascending or descending order.</p>', 'SessionDataSortBy$order' => '<p>Specifies whether to sort the results in ascending or descending order.</p>', 'UtteranceDataSortBy$order' => '<p>Specifies whether to sort the results in ascending or descending order.</p>', ], ], 'AnalyticsUtteranceAttribute' => [ 'base' => '<p>An object that specifies the last used intent at the time of the utterance as an attribute to return.</p>', 'refs' => [ 'AnalyticsUtteranceAttributes$member' => NULL, ], ], 'AnalyticsUtteranceAttributeName' => [ 'base' => NULL, 'refs' => [ 'AnalyticsUtteranceAttribute$name' => '<p>An attribute to return. The only available attribute is the intent that the bot mapped the utterance to.</p>', ], ], 'AnalyticsUtteranceAttributeResult' => [ 'base' => '<p>An object containing the intent that the bot mapped the utterance to.</p>', 'refs' => [ 'AnalyticsUtteranceAttributeResults$member' => NULL, ], ], 'AnalyticsUtteranceAttributeResults' => [ 'base' => NULL, 'refs' => [ 'AnalyticsUtteranceResult$attributeResults' => '<p>A list of objects containing information about the last used intent at the time of an utterance.</p>', ], ], 'AnalyticsUtteranceAttributes' => [ 'base' => NULL, 'refs' => [ 'ListUtteranceMetricsRequest$attributes' => '<p>A list containing attributes related to the utterance that you want the response to return. The following attributes are possible:</p> <ul> <li> <p> <code>LastUsedIntent</code> – The last used intent at the time of the utterance.</p> </li> </ul>', ], ], 'AnalyticsUtteranceField' => [ 'base' => NULL, 'refs' => [ 'AnalyticsUtteranceGroupByKey$name' => '<p>The category by which the utterance analytics were grouped.</p>', 'AnalyticsUtteranceGroupBySpecification$name' => '<p>Specifies whether to group the utterances by their text or their state.</p>', ], ], 'AnalyticsUtteranceFilter' => [ 'base' => '<p>Contains fields describing a condition by which to filter the utterances. The expression may be understood as <code>name</code> <code>operator</code> <code>values</code>. For example:</p> <ul> <li> <p> <code>LocaleId EQ Book</code> – The locale is the string "en".</p> </li> <li> <p> <code>UtteranceText CO help</code> – The text of the utterance contains the string "help".</p> </li> </ul> <p>The operators that each filter supports are listed below:</p> <ul> <li> <p> <code>BotAlias</code> – <code>EQ</code>.</p> </li> <li> <p> <code>BotVersion</code> – <code>EQ</code>.</p> </li> <li> <p> <code>LocaleId</code> – <code>EQ</code>.</p> </li> <li> <p> <code>Modality</code> – <code>EQ</code>.</p> </li> <li> <p> <code>Channel</code> – <code>EQ</code>.</p> </li> <li> <p> <code>SessionId</code> – <code>EQ</code>.</p> </li> <li> <p> <code>OriginatingRequestId</code> – <code>EQ</code>.</p> </li> <li> <p> <code>UtteranceState</code> – <code>EQ</code>.</p> </li> <li> <p> <code>UtteranceText</code> – <code>EQ</code>, <code>CO</code>.</p> </li> </ul>', 'refs' => [ 'AnalyticsUtteranceFilters$member' => NULL, ], ], 'AnalyticsUtteranceFilterName' => [ 'base' => NULL, 'refs' => [ 'AnalyticsUtteranceFilter$name' => '<p>The category by which to filter the utterances. The descriptions for each option are as follows:</p> <ul> <li> <p> <code>BotAlias</code> – The name of the bot alias.</p> </li> <li> <p> <code>BotVersion</code> – The version of the bot.</p> </li> <li> <p> <code>LocaleId</code> – The locale of the bot.</p> </li> <li> <p> <code>Modality</code> – The modality of the session with the bot (audio, DTMF, or text).</p> </li> <li> <p> <code>Channel</code> – The channel that the bot is integrated with.</p> </li> <li> <p> <code>SessionId</code> – The identifier of the session with the bot.</p> </li> <li> <p> <code>OriginatingRequestId</code> – The identifier of the first request in a session.</p> </li> <li> <p> <code>UtteranceState</code> – The state of the utterance.</p> </li> <li> <p> <code>UtteranceText</code> – The text in the utterance.</p> </li> </ul>', ], ], 'AnalyticsUtteranceFilters' => [ 'base' => NULL, 'refs' => [ 'ListUtteranceAnalyticsDataRequest$filters' => '<p>A list of objects, each of which describes a condition by which you want to filter the results.</p>', 'ListUtteranceMetricsRequest$filters' => '<p>A list of objects, each of which describes a condition by which you want to filter the results.</p>', ], ], 'AnalyticsUtteranceGroupByKey' => [ 'base' => '<p>Contains the category by which the utterance analytics were grouped and the values for that category.</p>', 'refs' => [ 'AnalyticsUtteranceGroupByKeys$member' => NULL, ], ], 'AnalyticsUtteranceGroupByKeys' => [ 'base' => NULL, 'refs' => [ 'AnalyticsUtteranceResult$groupByKeys' => '<p>A list of objects containing the criteria you requested for grouping results and the values of the bins.</p>', ], ], 'AnalyticsUtteranceGroupByList' => [ 'base' => NULL, 'refs' => [ 'ListUtteranceMetricsRequest$groupBy' => '<p>A list of objects, each of which specifies how to group the results. You can group by the following criteria:</p> <ul> <li> <p> <code>UtteranceText</code> – The transcription of the utterance.</p> </li> <li> <p> <code>UtteranceState</code> – The state of the utterance. The possible states are detailed in <a href="https://docs.aws.amazon.com/analytics-key-definitions-utterances">Key definitions</a> in the user guide.</p> </li> </ul>', ], ], 'AnalyticsUtteranceGroupBySpecification' => [ 'base' => '<p>Contains the category by which to group the utterances.</p>', 'refs' => [ 'AnalyticsUtteranceGroupByList$member' => NULL, ], ], 'AnalyticsUtteranceMetric' => [ 'base' => '<p>Contains the metric and the summary statistic you want to calculate, and the order in which to sort the results, for the utterances across the user sessions with the bot.</p>', 'refs' => [ 'AnalyticsUtteranceMetrics$member' => NULL, ], ], 'AnalyticsUtteranceMetricName' => [ 'base' => NULL, 'refs' => [ 'AnalyticsUtteranceMetric$name' => '<p>The metric for which you want to get utterance summary statistics.</p> <ul> <li> <p> <code>Count</code> – The number of utterances.</p> </li> <li> <p> <code>Missed</code> – The number of utterances that Amazon Lex failed to recognize.</p> </li> <li> <p> <code>Detected</code> – The number of utterances that Amazon Lex managed to detect.</p> </li> <li> <p> <code>UtteranceTimestamp</code> – The date and time of the utterance.</p> </li> </ul>', 'AnalyticsUtteranceMetricResult$name' => '<p>The metric that you requested.</p> <ul> <li> <p> <code>Count</code> – The number of utterances.</p> </li> <li> <p> <code>Missed</code> – The number of utterances that Amazon Lex failed to recognize.</p> </li> <li> <p> <code>Detected</code> – The number of utterances that Amazon Lex managed to detect.</p> </li> <li> <p> <code>UtteranceTimestamp</code> – The date and time of the utterance.</p> </li> </ul>', ], ], 'AnalyticsUtteranceMetricResult' => [ 'base' => '<p>An object containing the results for the utterance metric you requested.</p>', 'refs' => [ 'AnalyticsUtteranceMetricResults$member' => NULL, ], ], 'AnalyticsUtteranceMetricResults' => [ 'base' => NULL, 'refs' => [ 'AnalyticsUtteranceResult$metricsResults' => '<p>A list of objects, each of which contains a metric you want to list, the statistic for the metric you want to return, and the method by which to organize the results.</p>', ], ], 'AnalyticsUtteranceMetrics' => [ 'base' => NULL, 'refs' => [ 'ListUtteranceMetricsRequest$metrics' => '<p>A list of objects, each of which contains a metric you want to list, the statistic for the metric you want to return, and the method by which to organize the results.</p>', ], ], 'AnalyticsUtteranceResult' => [ 'base' => '<p>An object containing the results for the utterance metrics you requested and the bin and/or group(s) they refer to, if applicable.</p>', 'refs' => [ 'AnalyticsUtteranceResults$member' => NULL, ], ], 'AnalyticsUtteranceResults' => [ 'base' => NULL, 'refs' => [ 'ListUtteranceMetricsResponse$results' => '<p>The results for the utterance metrics.</p>', ], ], 'AnalyticsUtteranceSortByName' => [ 'base' => NULL, 'refs' => [ 'UtteranceDataSortBy$name' => '<p>The measure by which to sort the utterance analytics data.</p> <ul> <li> <p> <code>Count</code> – The number of utterances.</p> </li> <li> <p> <code>UtteranceTimestamp</code> – The date and time of the utterance.</p> </li> </ul>', ], ], 'AnswerField' => [ 'base' => NULL, 'refs' => [ 'ExactResponseFields$answerField' => '<p>The name of the field that contains the answer to the query made to the OpenSearch Service database.</p>', ], ], 'AssociatedTranscript' => [ 'base' => '<p>The object containing information that associates the recommended intent/slot type with a conversation.</p>', 'refs' => [ 'AssociatedTranscriptList$member' => NULL, ], ], 'AssociatedTranscriptFilter' => [ 'base' => '<p>Filters to search for the associated transcript.</p>', 'refs' => [ 'AssociatedTranscriptFilters$member' => NULL, ], ], 'AssociatedTranscriptFilterName' => [ 'base' => NULL, 'refs' => [ 'AssociatedTranscriptFilter$name' => '<p>The name of the field to use for filtering. The allowed names are IntentId and SlotTypeId.</p>', ], ], 'AssociatedTranscriptFilters' => [ 'base' => NULL, 'refs' => [ 'SearchAssociatedTranscriptsRequest$filters' => '<p>A list of filter objects.</p>', ], ], 'AssociatedTranscriptList' => [ 'base' => NULL, 'refs' => [ 'SearchAssociatedTranscriptsResponse$associatedTranscripts' => '<p>The object that contains the associated transcript that meet the criteria you specified.</p>', ], ], 'AttachmentTitle' => [ 'base' => NULL, 'refs' => [ 'ImageResponseCard$title' => '<p>The title to display on the response card. The format of the title is determined by the platform displaying the response card.</p>', 'ImageResponseCard$subtitle' => '<p>The subtitle to display on the response card. The format of the subtitle is determined by the platform displaying the response card.</p>', ], ], 'AttachmentUrl' => [ 'base' => NULL, 'refs' => [ 'ImageResponseCard$imageUrl' => '<p>The URL of an image to display on the response card. The image URL must be publicly available so that the platform displaying the response card has access to the image.</p>', ], ], 'AudioAndDTMFInputSpecification' => [ 'base' => '<p>Specifies the audio and DTMF input specification.</p>', 'refs' => [ 'PromptAttemptSpecification$audioAndDTMFInputSpecification' => '<p>Specifies the settings on audio and DTMF input.</p>', ], ], 'AudioFileS3Location' => [ 'base' => NULL, 'refs' => [ 'UtteranceAudioInputSpecification$audioFileS3Location' => '<p>Amazon S3 file pointing to the audio.</p>', ], ], 'AudioLogDestination' => [ 'base' => '<p>The location of audio log files collected when conversation logging is enabled for a bot.</p>', 'refs' => [ 'AudioLogSetting$destination' => NULL, ], ], 'AudioLogSetting' => [ 'base' => '<p>Settings for logging audio of conversations between Amazon Lex and a user. You specify whether to log audio and the Amazon S3 bucket where the audio file is stored.</p>', 'refs' => [ 'AudioLogSettingsList$member' => NULL, ], ], 'AudioLogSettingsList' => [ 'base' => NULL, 'refs' => [ 'ConversationLogSettings$audioLogSettings' => '<p>The Amazon S3 settings for logging audio to an S3 bucket.</p>', ], ], 'AudioRecognitionStrategy' => [ 'base' => NULL, 'refs' => [ 'AdvancedRecognitionSetting$audioRecognitionStrategy' => '<p>Enables using the slot values as a custom vocabulary for recognizing user utterances.</p>', ], ], 'AudioSpecification' => [ 'base' => '<p>Specifies the audio input specifications.</p>', 'refs' => [ 'AudioAndDTMFInputSpecification$audioSpecification' => '<p>Specifies the settings on audio input.</p>', ], ], 'BatchCreateCustomVocabularyItemRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchCreateCustomVocabularyItemResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchDeleteCustomVocabularyItemRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchDeleteCustomVocabularyItemResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchUpdateCustomVocabularyItemRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchUpdateCustomVocabularyItemResponse' => [ 'base' => NULL, 'refs' => [], ], 'BedrockKnowledgeBaseArn' => [ 'base' => NULL, 'refs' => [ 'BedrockKnowledgeStoreConfiguration$bedrockKnowledgeBaseArn' => '<p>The ARN of the knowledge base used.</p>', ], ], 'BedrockKnowledgeStoreConfiguration' => [ 'base' => '<p>Contains details about the configuration of a Amazon Bedrock knowledge base.</p>', 'refs' => [ 'DataSourceConfiguration$bedrockKnowledgeStoreConfiguration' => '<p>Contains details about the configuration of the Amazon Bedrock knowledge base used for the <code>AMAZON.QnAIntent</code>. To set up a knowledge base, follow the steps at <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base.html">Building a knowledge base</a>.</p>', ], ], 'BedrockModelArn' => [ 'base' => NULL, 'refs' => [ 'BedrockModelSpecification$modelArn' => '<p>The ARN of the foundation model used in descriptive bot building.</p>', 'DescribeBotResourceGenerationResponse$modelArn' => '<p>The ARN of the model used to generate the bot resources.</p>', ], ], 'BedrockModelSpecification' => [ 'base' => '<p>Contains information about the Amazon Bedrock model used to interpret the prompt used in descriptive bot building.</p>', 'refs' => [ 'DescriptiveBotBuilderSpecification$bedrockModelSpecification' => '<p>An object containing information about the Amazon Bedrock model used to interpret the prompt used in descriptive bot building.</p>', 'QnAIntentConfiguration$bedrockModelConfiguration' => NULL, 'SampleUtteranceGenerationSpecification$bedrockModelSpecification' => NULL, 'SlotResolutionImprovementSpecification$bedrockModelSpecification' => '<p>An object containing information about the Amazon Bedrock model used to assist slot resolution.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'AudioLogSetting$enabled' => '<p>Determines whether audio logging in enabled for the bot.</p>', 'BotAliasLocaleSettings$enabled' => '<p>Determines whether the locale is enabled for the bot. If the value is <code>false</code>, the locale isn\'t available for use.</p>', 'DescriptiveBotBuilderSpecification$enabled' => '<p>Specifies whether the descriptive bot building feature is activated or not.</p>', 'DialogCodeHookSettings$enabled' => '<p>Enables the dialog code hook so that it processes user requests.</p>', 'FulfillmentCodeHookSettings$enabled' => '<p>Indicates whether a Lambda function should be invoked to fulfill a specific intent.</p>', 'IntentClassificationTestResultItem$multiTurnConversation' => '<p>Indicates whether the conversation involves multiple turns or not.</p>', 'IntentLevelSlotResolutionTestResultItem$multiTurnConversation' => '<p>Indicates whether the conversation involves multiple turns or not.</p>', 'KendraConfiguration$queryFilterStringEnabled' => '<p>Determines whether the <code>AMAZON.KendraSearchIntent</code> intent uses a custom query string to query the Amazon Kendra index.</p>', 'MultipleValuesSetting$allowMultipleValues' => '<p>Indicates whether a slot can return multiple values. When <code>true</code>, the slot may return more than one value in a response. When <code>false</code>, the slot returns only a single value.</p> <p>Multi-value slots are only available in the en-US locale. If you set this value to <code>true</code> in any other locale, Amazon Lex throws a <code>ValidationException</code>.</p> <p>If the <code>allowMutlipleValues</code> is not set, the default value is <code>false</code>.</p>', 'OpensearchConfiguration$exactResponse' => '<p>Specifies whether to return an exact response or to return an answer generated by the model using the fields you specify from the database.</p>', 'OverallTestResultItem$multiTurnConversation' => '<p>Indicates whether the conversation contains multiple turns or not.</p>', 'QnAKendraConfiguration$queryFilterStringEnabled' => '<p>Specifies whether to enable an Amazon Kendra filter string or not.</p>', 'QnAKendraConfiguration$exactResponse' => '<p>Specifies whether to return an exact response from the Amazon Kendra index or to let the Amazon Bedrock model you select generate a response based on the results. To use this feature, you must first add FAQ questions to your index by following the steps at <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-creating-faq.html">Adding frequently asked questions (FAQs) to an index</a>.</p>', 'SampleUtteranceGenerationSpecification$enabled' => '<p>Specifies whether to enable sample utterance generation or not.</p>', 'SentimentAnalysisSettings$detectSentiment' => '<p>Sets whether Amazon Lex uses Amazon Comprehend to detect the sentiment of user utterances.</p>', 'TextLogSetting$enabled' => '<p>Determines whether conversation logs should be stored for an alias.</p>', ], ], 'BotAliasHistoryEvent' => [ 'base' => '<p>Provides a record of an event that affects a bot alias. For example, when the version of a bot that the alias points to changes.</p>', 'refs' => [ 'BotAliasHistoryEventsList$member' => NULL, ], ], 'BotAliasHistoryEventsList' => [ 'base' => NULL, 'refs' => [ 'DescribeBotAliasResponse$botAliasHistoryEvents' => '<p>A list of events that affect a bot alias. For example, an event is recorded when the version that the alias points to changes.</p>', ], ], 'BotAliasId' => [ 'base' => NULL, 'refs' => [ 'BotAliasReplicaSummary$botAliasId' => '<p>The bot alias ID for all the alias bot replications.</p>', 'BotAliasSummary$botAliasId' => '<p>The unique identifier assigned to the bot alias. You can use this ID to get detailed information about the alias using the <a href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DescribeBotAlias.html">DescribeBotAlias</a> operation.</p>', 'BotAliasTestExecutionTarget$botAliasId' => '<p>The bot alias Id of the bot alias used in the test set execution.</p>', 'BotMember$botMemberAliasId' => '<p>The alias ID of a bot that is a member of this network of bots.</p>', 'ConversationLogsDataSource$botAliasId' => '<p>The bot alias Id from the conversation logs.</p>', 'CreateBotAliasResponse$botAliasId' => '<p>The unique identifier of the bot alias.</p>', 'DeleteBotAliasRequest$botAliasId' => '<p>The unique identifier of the bot alias to delete.</p>', 'DeleteBotAliasResponse$botAliasId' => '<p>The unique identifier of the bot alias to delete.</p>', 'DescribeBotAliasRequest$botAliasId' => '<p>The identifier of the bot alias to describe.</p>', 'DescribeBotAliasResponse$botAliasId' => '<p>The identifier of the bot alias.</p>', 'ListAggregatedUtterancesRequest$botAliasId' => '<p>The identifier of the bot alias associated with this request. If you specify the bot alias, you can\'t specify the bot version.</p>', 'ListAggregatedUtterancesResponse$botAliasId' => '<p>The identifier of the bot alias that contains the utterances. If you specified the bot version, the bot alias ID isn\'t returned.</p>', 'SessionSpecification$botAliasId' => '<p>The identifier of the alias of the bot that the session was held with.</p>', 'TestSetDiscrepancyReportBotAliasTarget$botAliasId' => '<p>The unique identifier for the bot associated with the bot alias.</p>', 'UpdateBotAliasRequest$botAliasId' => '<p>The unique identifier of the bot alias.</p>', 'UpdateBotAliasResponse$botAliasId' => '<p>The identifier of the updated bot alias.</p>', 'UtteranceSpecification$botAliasId' => '<p>The identifier of the alias of the bot that the utterance was made to.</p>', ], ], 'BotAliasLocaleSettings' => [ 'base' => '<p>Specifies settings that are unique to a locale. For example, you can use different Lambda function depending on the bot\'s locale.</p>', 'refs' => [ 'BotAliasLocaleSettingsMap$value' => NULL, ], ], 'BotAliasLocaleSettingsMap' => [ 'base' => NULL, 'refs' => [ 'CreateBotAliasRequest$botAliasLocaleSettings' => '<p>Maps configuration information to a specific locale. You can use this parameter to specify a specific Lambda function to run different functions in different locales.</p>', 'CreateBotAliasResponse$botAliasLocaleSettings' => '<p>Configuration information for a specific locale.</p>', 'DescribeBotAliasResponse$botAliasLocaleSettings' => '<p>The locale settings that are unique to the alias.</p>', 'UpdateBotAliasRequest$botAliasLocaleSettings' => '<p>The new Lambda functions to use in each locale for the bot alias.</p>', 'UpdateBotAliasResponse$botAliasLocaleSettings' => '<p>The updated Lambda functions to use in each locale for the bot alias.</p>', ], ], 'BotAliasName' => [ 'base' => NULL, 'refs' => [ 'BotMember$botMemberAliasName' => '<p>The alias name of a bot that is a member of this network of bots.</p>', ], ], 'BotAliasReplicaSummary' => [ 'base' => '<p>Contains information about all the aliases replication statuses applicable for global resiliency.</p>', 'refs' => [ 'BotAliasReplicaSummaryList$member' => NULL, ], ], 'BotAliasReplicaSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListBotAliasReplicasResponse$botAliasReplicaSummaries' => '<p>The summary information of the replicated bot created from the source bot alias.</p>', ], ], 'BotAliasReplicationStatus' => [ 'base' => '<p>The status of the operation to replicate the bot alias. Values: Creating, Updating, Available, Deleting, Failed.</p>', 'refs' => [ 'BotAliasReplicaSummary$botAliasReplicationStatus' => '<p>The replication statuses for all the alias bot replications.</p>', ], ], 'BotAliasStatus' => [ 'base' => NULL, 'refs' => [ 'BotAliasSummary$botAliasStatus' => '<p>The current state of the bot alias. If the status is <code>Available</code>, the alias is ready for use.</p>', 'CreateBotAliasResponse$botAliasStatus' => '<p>The current status of the alias. The alias is first put into the <code>Creating</code> state. When the alias is ready to be used, it is put into the <code>Available</code> state. You can use the <code>DescribeBotAlias</code> operation to get the current state of an alias.</p>', 'DeleteBotAliasResponse$botAliasStatus' => '<p>The current status of the alias. The status is <code>Deleting</code> while the alias is in the process of being deleted. Once the alias is deleted, it will no longer appear in the list of aliases returned by the <code>ListBotAliases</code> operation.</p>', 'DescribeBotAliasResponse$botAliasStatus' => '<p>The current status of the alias. When the alias is <code>Available</code>, the alias is ready for use with your bot.</p>', 'UpdateBotAliasResponse$botAliasStatus' => '<p>The current status of the bot alias. When the status is <code>Available</code> the alias is ready for use.</p>', ], ], 'BotAliasSummary' => [ 'base' => '<p>Summary information about bot aliases returned from the <a href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListBotAliases.html">ListBotAliases</a> operation.</p>', 'refs' => [ 'BotAliasSummaryList$member' => NULL, ], ], 'BotAliasSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListBotAliasesResponse$botAliasSummaries' => '<p>Summary information for the bot aliases that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more aliases available, the <code>nextToken</code> field contains a token to get the next page of results.</p>', ], ], 'BotAliasTestExecutionTarget' => [ 'base' => '<p>The target Amazon S3 location for the test set execution using a bot alias.</p>', 'refs' => [ 'TestExecutionTarget$botAliasTarget' => '<p>Contains information about the bot alias used for the test execution.</p>', ], ], 'BotExportSpecification' => [ 'base' => '<p>Provides the identity of a the bot that was exported.</p>', 'refs' => [ 'ExportResourceSpecification$botExportSpecification' => '<p>Parameters for exporting a bot.</p>', ], ], 'BotFilter' => [ 'base' => '<p>Filters the responses returned by the <code>ListBots</code> operation.</p>', 'refs' => [ 'BotFilters$member' => NULL, ], ], 'BotFilterName' => [ 'base' => NULL, 'refs' => [ 'BotFilter$name' => '<p>The name of the field to filter the list of bots.</p>', ], ], 'BotFilterOperator' => [ 'base' => NULL, 'refs' => [ 'BotFilter$operator' => '<p>The operator to use for the filter. Specify <code>EQ</code> when the <code>ListBots</code> operation should return only aliases that equal the specified value. Specify <code>CO</code> when the <code>ListBots</code> operation should return aliases that contain the specified value.</p>', ], ], 'BotFilters' => [ 'base' => NULL, 'refs' => [ 'ListBotsRequest$filters' => '<p>Provides the specification of a filter used to limit the bots in the response to only those that match the filter specification. You can only specify one filter and one string to filter on.</p>', ], ], 'BotImportSpecification' => [ 'base' => '<p>Provides the bot parameters required for importing a bot.</p>', 'refs' => [ 'ImportResourceSpecification$botImportSpecification' => '<p>Parameters for importing a bot.</p>', ], ], 'BotLocaleExportSpecification' => [ 'base' => '<p>Provides the bot locale parameters required for exporting a bot locale.</p>', 'refs' => [ 'ExportResourceSpecification$botLocaleExportSpecification' => '<p>Parameters for exporting a bot locale.</p>', ], ], 'BotLocaleFilter' => [ 'base' => '<p>Filters responses returned by the <code>ListBotLocales</code> operation.</p>', 'refs' => [ 'BotLocaleFilters$member' => NULL, ], ], 'BotLocaleFilterName' => [ 'base' => NULL, 'refs' => [ 'BotLocaleFilter$name' => '<p>The name of the field to filter the list of bots.</p>', ], ], 'BotLocaleFilterOperator' => [ 'base' => NULL, 'refs' => [ 'BotLocaleFilter$operator' => '<p>The operator to use for the filter. Specify <code>EQ</code> when the <code>ListBotLocales</code> operation should return only aliases that equal the specified value. Specify <code>CO</code> when the <code>ListBotLocales</code> operation should return aliases that contain the specified value.</p>', ], ], 'BotLocaleFilters' => [ 'base' => NULL, 'refs' => [ 'ListBotLocalesRequest$filters' => '<p>Provides the specification for a filter used to limit the response to only those locales that match the filter specification. You can only specify one filter and one value to filter on.</p>', ], ], 'BotLocaleHistoryEvent' => [ 'base' => '<p>Provides information about an event that occurred affecting the bot locale.</p>', 'refs' => [ 'BotLocaleHistoryEventsList$member' => NULL, ], ], 'BotLocaleHistoryEventDescription' => [ 'base' => NULL, 'refs' => [ 'BotLocaleHistoryEvent$event' => '<p>A description of the event that occurred.</p>', ], ], 'BotLocaleHistoryEventsList' => [ 'base' => NULL, 'refs' => [ 'DescribeBotLocaleResponse$botLocaleHistoryEvents' => '<p>History of changes, such as when a locale is used in an alias, that have taken place for the locale.</p>', ], ], 'BotLocaleImportSpecification' => [ 'base' => '<p>Provides the bot locale parameters required for importing a bot locale.</p>', 'refs' => [ 'ImportResourceSpecification$botLocaleImportSpecification' => '<p>Parameters for importing a bot locale.</p>', ], ], 'BotLocaleSortAttribute' => [ 'base' => NULL, 'refs' => [ 'BotLocaleSortBy$attribute' => '<p>The bot locale attribute to sort by.</p>', ], ], 'BotLocaleSortBy' => [ 'base' => '<p>Specifies attributes for sorting a list of bot locales.</p>', 'refs' => [ 'ListBotLocalesRequest$sortBy' => '<p>Specifies sorting parameters for the list of locales. You can sort by locale name in ascending or descending order.</p>', ], ], 'BotLocaleStatus' => [ 'base' => NULL, 'refs' => [ 'BotLocaleSummary$botLocaleStatus' => '<p>The current status of the bot locale. When the status is <code>Built</code> the locale is ready for use.</p>', 'BuildBotLocaleResponse$botLocaleStatus' => '<p>The bot\'s build status. When the status is <code>ReadyExpressTesting</code> you can test the bot using the utterances defined for the intents and slot types. When the status is <code>Built</code>, the bot is ready for use and can be tested using any utterance.</p>', 'CreateBotLocaleResponse$botLocaleStatus' => '<p>The status of the bot.</p> <p>When the status is <code>Creating</code> the bot locale is being configured. When the status is <code>Building</code> Amazon Lex is building the bot for testing and use.</p> <p>If the status of the bot is <code>ReadyExpressTesting</code>, you can test the bot using the exact utterances specified in the bots\' intents. When the bot is ready for full testing or to run, the status is <code>Built</code>.</p> <p>If there was a problem with building the bot, the status is <code>Failed</code>. If the bot was saved but not built, the status is <code>NotBuilt</code>.</p>', 'DeleteBotLocaleResponse$botLocaleStatus' => '<p>The status of deleting the bot locale. The locale first enters the <code>Deleting</code> status. Once the locale is deleted it no longer appears in the list of locales for the bot.</p>', 'DescribeBotLocaleResponse$botLocaleStatus' => '<p>The status of the bot. If the status is <code>Failed</code>, the reasons for the failure are listed in the <code>failureReasons</code> field.</p>', 'UpdateBotLocaleResponse$botLocaleStatus' => '<p>The current status of the locale. When the bot status is <code>Built</code> the locale is ready for use.</p>', ], ], 'BotLocaleSummary' => [ 'base' => '<p>Summary information about bot locales returned by the <a href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListBotLocales.html">ListBotLocales</a> operation.</p>', 'refs' => [ 'BotLocaleSummaryList$member' => NULL, ], ], 'BotLocaleSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListBotLocalesResponse$botLocaleSummaries' => '<p>Summary information for the locales that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more locales available, the <code>nextToken</code> field contains a token to get the next page of results.</p>', ], ], 'BotMember' => [ 'base' => '<p>A bot that is a member of a network of bots.</p>', 'refs' => [ 'BotMembers$member' => NULL, ], ], 'BotMembers' => [ 'base' => NULL, 'refs' => [ 'CreateBotRequest$botMembers' => '<p>The list of bot members in a network to be created.</p>', 'CreateBotResponse$botMembers' => '<p>The list of bots in a network that was created.</p>', 'DescribeBotResponse$botMembers' => '<p>The list of bots in the network that was described.</p>', 'DescribeBotVersionResponse$botMembers' => '<p>The members of bot network in the version that was described.</p>', 'UpdateBotRequest$botMembers' => '<p>The list of bot members in the network associated with the update action.</p>', 'UpdateBotResponse$botMembers' => '<p>The list of bot members in the network that was updated.</p>', ], ], 'BotRecommendationResultStatistics' => [ 'base' => '<p>A statistical summary of the bot recommendation results.</p>', 'refs' => [ 'BotRecommendationResults$statistics' => '<p>The statistical summary of the bot recommendation results.</p>', ], ], 'BotRecommendationResults' => [ 'base' => '<p>The object representing the URL of the bot definition, the URL of the associated transcript, and a statistical summary of the bot recommendation results.</p>', 'refs' => [ 'DescribeBotRecommendationResponse$botRecommendationResults' => '<p>The object representing the URL of the bot definition, the URL of the associated transcript and a statistical summary of the bot recommendation results.</p>', ], ], 'BotRecommendationStatus' => [ 'base' => NULL, 'refs' => [ 'BotRecommendationSummary$botRecommendationStatus' => '<p>The status of the bot recommendation.</p> <p>If the status is Failed, then the reasons for the failure are listed in the failureReasons field. </p>', 'DescribeBotRecommendationResponse$botRecommendationStatus' => '<p>The status of the bot recommendation. If the status is Failed, then the reasons for the failure are listed in the failureReasons field. </p>', 'StartBotRecommendationResponse$botRecommendationStatus' => '<p>The status of the bot recommendation.</p> <p>If the status is Failed, then the reasons for the failure are listed in the failureReasons field. </p>', 'StopBotRecommendationResponse$botRecommendationStatus' => '<p>The status of the bot recommendation. If the status is Failed, then the reasons for the failure are listed in the failureReasons field.</p>', 'UpdateBotRecommendationResponse$botRecommendationStatus' => '<p>The status of the bot recommendation.</p> <p>If the status is Failed, then the reasons for the failure are listed in the failureReasons field. </p>', ], ], 'BotRecommendationSummary' => [ 'base' => '<p>A summary of the bot recommendation.</p>', 'refs' => [ 'BotRecommendationSummaryList$member' => NULL, ], ], 'BotRecommendationSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListBotRecommendationsResponse$botRecommendationSummaries' => '<p>Summary information for the bot recommendations that meet the filter specified in this request. The length of the list is specified in the maxResults parameter of the request. If there are more bot recommendations available, the nextToken field contains a token to get the next page of results.</p>', ], ], 'BotReplicaStatus' => [ 'base' => '<p>The status of the operation to replicate the bot. Values: Enabling, Enabled, Deleting, Failed.</p>', 'refs' => [ 'BotReplicaSummary$botReplicaStatus' => '<p>The operation status for the replicated bot applicable.</p>', 'CreateBotReplicaResponse$botReplicaStatus' => '<p>The operational status of the replicated bot generated.</p>', 'DeleteBotReplicaResponse$botReplicaStatus' => '<p>The operational status of the replicated bot generated.</p>', 'DescribeBotReplicaResponse$botReplicaStatus' => '<p>The operational status of the replicated bot being monitored.</p>', ], ], 'BotReplicaSummary' => [ 'base' => '<p>Contains summary information about all the replication statuses applicable for global resiliency.</p>', 'refs' => [ 'BotReplicaSummaryList$member' => NULL, ], ], 'BotReplicaSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListBotReplicasResponse$botReplicaSummaries' => '<p>The summary details for the replicated bots.</p>', ], ], 'BotSortAttribute' => [ 'base' => NULL, 'refs' => [ 'BotSortBy$attribute' => '<p>The attribute to use to sort the list of bots.</p>', ], ], 'BotSortBy' => [ 'base' => '<p>Specifies attributes for sorting a list of bots.</p>', 'refs' => [ 'ListBotsRequest$sortBy' => '<p>Specifies sorting parameters for the list of bots. You can specify that the list be sorted by bot name in ascending or descending order.</p>', ], ], 'BotStatus' => [ 'base' => NULL, 'refs' => [ 'BotSummary$botStatus' => '<p>The current status of the bot. When the status is <code>Available</code> the bot is ready for use.</p>', 'BotVersionSummary$botStatus' => '<p>The status of the bot. When the status is available, the version of the bot is ready for use.</p>', 'CreateBotResponse$botStatus' => '<p>Shows the current status of the bot. The bot is first in the <code>Creating</code> status. Once the bot is read for use, it changes to the <code>Available</code> status. After the bot is created, you can use the <code>DRAFT</code> version of the bot.</p>', 'CreateBotVersionResponse$botStatus' => '<p>When you send a request to create or update a bot, Amazon Lex sets the status response element to <code>Creating</code>. After Amazon Lex builds the bot, it sets status to <code>Available</code>. If Amazon Lex can\'t build the bot, it sets status to <code>Failed</code>.</p>', 'DeleteBotResponse$botStatus' => '<p>The current status of the bot. The status is <code>Deleting</code> while the bot and its associated resources are being deleted.</p>', 'DeleteBotVersionResponse$botStatus' => '<p>The current status of the bot. </p>', 'DescribeBotResponse$botStatus' => '<p>The current status of the bot. When the status is <code>Available</code> the bot is ready to be used in conversations with users.</p>', 'DescribeBotVersionResponse$botStatus' => '<p>The current status of the bot. When the status is <code>Available</code>, the bot version is ready for use.</p>', 'UpdateBotResponse$botStatus' => '<p>Shows the current status of the bot. The bot is first in the <code>Creating</code> status. Once the bot is read for use, it changes to the <code>Available</code> status. After the bot is created, you can use the <code>DRAFT</code> version of the bot.</p>', ], ], 'BotSummary' => [ 'base' => '<p>Summary information about a bot returned by the <a href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListBots.html">ListBots</a> operation.</p>', 'refs' => [ 'BotSummaryList$member' => NULL, ], ], 'BotSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListBotsResponse$botSummaries' => '<p>Summary information for the bots that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more bots available, the <code>nextToken</code> field contains a token to the next page of results.</p>', ], ], 'BotType' => [ 'base' => NULL, 'refs' => [ 'BotSummary$botType' => '<p>The type of the bot.</p>', 'CreateBotRequest$botType' => '<p>The type of a bot to create.</p>', 'CreateBotResponse$botType' => '<p>The type of a bot that was created.</p>', 'DescribeBotResponse$botType' => '<p>The type of the bot that was described.</p>', 'DescribeBotVersionResponse$botType' => '<p>The type of the bot in the version that was described.</p>', 'UpdateBotRequest$botType' => '<p>The type of the bot to be updated.</p>', 'UpdateBotResponse$botType' => '<p>The type of the bot that was updated.</p>', ], ], 'BotVersion' => [ 'base' => NULL, 'refs' => [ 'BatchCreateCustomVocabularyItemRequest$botVersion' => '<p>The identifier of the version of the bot associated with this custom vocabulary.</p>', 'BatchCreateCustomVocabularyItemResponse$botVersion' => '<p>The identifier of the version of the bot associated with this custom vocabulary.</p>', 'BatchDeleteCustomVocabularyItemRequest$botVersion' => '<p>The identifier of the version of the bot associated with this custom vocabulary.</p>', 'BatchDeleteCustomVocabularyItemResponse$botVersion' => '<p>The identifier of the version of the bot associated with this custom vocabulary.</p>', 'BatchUpdateCustomVocabularyItemRequest$botVersion' => '<p>The identifier of the version of the bot associated with this custom vocabulary.</p>', 'BatchUpdateCustomVocabularyItemResponse$botVersion' => '<p>The identifier of the version of the bot associated with this custom vocabulary.</p>', 'BotAliasHistoryEvent$botVersion' => '<p>The version of the bot that was used in the event. </p>', 'BotAliasReplicaSummary$botVersion' => '<p>The bot version for all the alias bot replications.</p>', 'BotAliasSummary$botVersion' => '<p>The version of the bot that the bot alias references.</p>', 'BotExportSpecification$botVersion' => '<p>The version of the bot that was exported. This will be either <code>DRAFT</code> or the version number.</p>', 'BotLocaleExportSpecification$botVersion' => '<p>The version of the bot to export.</p>', 'BotMember$botMemberVersion' => '<p>The version of a bot that is a member of this network of bots.</p>', 'BotVersionLocaleDetails$sourceBotVersion' => '<p>The version of a bot used for a bot locale.</p>', 'BotVersionReplicaSummary$botVersion' => '<p>The bot version for the summary information for all the version replication statuses.</p>', 'BotVersionSummary$botVersion' => '<p>The numeric version of the bot, or <code>DRAFT</code> to indicate that this is the version of the bot that can be updated..</p>', 'CustomVocabularyExportSpecification$botVersion' => '<p>The version of the bot that contains the custom vocabulary to export.</p>', 'DescribeBotAliasResponse$botVersion' => '<p>The version of the bot associated with the bot alias.</p>', 'DescribeBotLocaleRequest$botVersion' => '<p>The version of the bot associated with the locale.</p>', 'DescribeBotLocaleResponse$botVersion' => '<p>The version of the bot associated with the locale.</p>', 'DescribeBotResourceGenerationRequest$botVersion' => '<p>The version of the bot for which to return the generation details.</p>', 'DescribeBotResourceGenerationResponse$botVersion' => '<p>The version of the bot for which the generation request was made.</p>', 'DescribeCustomVocabularyMetadataRequest$botVersion' => '<p>The bot version of the bot to return metadata for.</p>', 'DescribeCustomVocabularyMetadataResponse$botVersion' => '<p>The version of the bot that contains the custom vocabulary to describe.</p>', 'DescribeIntentRequest$botVersion' => '<p>The version of the bot associated with the intent.</p>', 'DescribeSlotRequest$botVersion' => '<p>The version of the bot associated with the slot.</p>', 'DescribeSlotResponse$botVersion' => '<p>The version of the bot associated with the slot.</p>', 'DescribeSlotTypeRequest$botVersion' => '<p>The version of the bot associated with the slot type.</p>', 'DescribeSlotTypeResponse$botVersion' => '<p>The version of the bot associated with the slot type.</p>', 'GenerateBotElementRequest$botVersion' => '<p>The bot version for the bot request to generate utterances.</p>', 'ListAggregatedUtterancesRequest$botVersion' => '<p>The identifier of the bot version associated with this request. If you specify the bot version, you can\'t specify the bot alias.</p>', 'ListAggregatedUtterancesResponse$botVersion' => '<p>The identifier of the bot version that contains the utterances. If you specified the bot alias, the bot version isn\'t returned.</p>', 'ListBotLocalesRequest$botVersion' => '<p>The version of the bot to list locales for.</p>', 'ListBotLocalesResponse$botVersion' => '<p>The version of the bot.</p>', 'ListBotResourceGenerationsRequest$botVersion' => '<p>The version of the bot whose generation requests you want to view.</p>', 'ListBotResourceGenerationsResponse$botVersion' => '<p>The version of the bot for which the generation requests were made.</p>', 'ListCustomVocabularyItemsRequest$botVersion' => '<p>The bot version of the bot to the list custom vocabulary request.</p>', 'ListCustomVocabularyItemsResponse$botVersion' => '<p>The identifier of the version of the bot associated with this custom vocabulary.</p>', 'ListExportsRequest$botVersion' => '<p>The version of the bot to list exports for. </p>', 'ListExportsResponse$botVersion' => '<p>The version of the bot that was exported.</p>', 'ListIntentsRequest$botVersion' => '<p>The version of the bot that contains the intent.</p>', 'ListIntentsResponse$botVersion' => '<p>The version of the bot that contains the intent.</p>', 'ListSlotTypesRequest$botVersion' => '<p>The version of the bot that contains the slot type.</p>', 'ListSlotTypesResponse$botVersion' => '<p>The version of the bot that contains the slot types.</p>', 'ListSlotsRequest$botVersion' => '<p>The version of the bot that contains the slot.</p>', 'ListSlotsResponse$botVersion' => '<p>The version of the bot that contains the slots.</p>', 'ParentBotNetwork$botVersion' => '<p>The version of the network of bots.</p>', 'SearchAssociatedTranscriptsRequest$botVersion' => '<p>The version of the bot containing the transcripts that you are searching.</p>', 'SearchAssociatedTranscriptsResponse$botVersion' => '<p>The version of the bot containing the transcripts that you are searching.</p>', 'StartBotResourceGenerationRequest$botVersion' => '<p>The version of the bot for which to generate intents and slot types.</p>', 'StartBotResourceGenerationResponse$botVersion' => '<p>The version of the bot for which the generation request was made.</p>', 'UpdateBotAliasRequest$botVersion' => '<p>The new bot version to assign to the bot alias.</p>', 'UpdateBotAliasResponse$botVersion' => '<p>The updated version of the bot that the alias points to.</p>', ], ], 'BotVersionLocaleDetails' => [ 'base' => '<p>The version of a bot used for a bot locale.</p>', 'refs' => [ 'BotVersionLocaleSpecification$value' => NULL, ], ], 'BotVersionLocaleSpecification' => [ 'base' => NULL, 'refs' => [ 'CreateBotVersionRequest$botVersionLocaleSpecification' => '<p>Specifies the locales that Amazon Lex adds to this version. You can choose the <code>Draft</code> version or any other previously published version for each locale. When you specify a source version, the locale data is copied from the source version to the new version.</p>', 'CreateBotVersionResponse$botVersionLocaleSpecification' => '<p>The source versions used for each locale in the new version.</p>', ], ], 'BotVersionReplicaSortAttribute' => [ 'base' => NULL, 'refs' => [ 'BotVersionReplicaSortBy$attribute' => '<p>The attribute of the sort category for the version replicated bots.</p>', ], ], 'BotVersionReplicaSortBy' => [ 'base' => '<p>The sort category for the version replicated bots.</p>', 'refs' => [ 'ListBotVersionReplicasRequest$sortBy' => '<p>The requested sort category for the list of replicated bots.</p>', ], ], 'BotVersionReplicaSummary' => [ 'base' => '<p>Contains summary information for all the version replication statuses applicable for Global resiliency.</p>', 'refs' => [ 'BotVersionReplicaSummaryList$member' => NULL, ], ], 'BotVersionReplicaSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListBotVersionReplicasResponse$botVersionReplicaSummaries' => '<p>The information summary used for the replicated bots in the list of replicated bots.</p>', ], ], 'BotVersionReplicationStatus' => [ 'base' => '<p>The status of the operation to replicate the bot version. Values: Creating, Available, Deleting, Failed.</p>', 'refs' => [ 'BotVersionReplicaSummary$botVersionReplicationStatus' => '<p>The version replication status for all the replicated bots.</p>', ], ], 'BotVersionSortAttribute' => [ 'base' => NULL, 'refs' => [ 'BotVersionSortBy$attribute' => '<p>The attribute to use to sort the list of versions.</p>', ], ], 'BotVersionSortBy' => [ 'base' => '<p>Specifies attributes for sorting a list of bot versions.</p>', 'refs' => [ 'ListBotVersionsRequest$sortBy' => '<p>Specifies sorting parameters for the list of versions. You can specify that the list be sorted by version name in either ascending or descending order.</p>', ], ], 'BotVersionSummary' => [ 'base' => '<p>Summary information about a bot version returned by the <a href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListBotVersions.html">ListBotVersions</a> operation.</p>', 'refs' => [ 'BotVersionSummaryList$member' => NULL, ], ], 'BotVersionSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListBotVersionsResponse$botVersionSummaries' => '<p>Summary information for the bot versions that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more versions available, the <code>nextToken</code> field contains a token to get the next page of results.</p>', ], ], 'BoxedBoolean' => [ 'base' => NULL, 'refs' => [ 'AggregatedUtterancesSummary$containsDataFromDeletedResources' => '<p>Aggregated utterance data may contain utterances from versions of your bot that have since been deleted. When the aggregated contains this kind of data, this field is set to true.</p>', 'AllowedInputTypes$allowAudioInput' => '<p>Indicates whether audio input is allowed.</p>', 'AllowedInputTypes$allowDTMFInput' => '<p>Indicates whether DTMF input is allowed.</p>', 'AudioLogSetting$selectiveLoggingEnabled' => '<p>The option to enable selective conversation log capture for audio.</p>', 'ConditionalSpecification$active' => '<p>Determines whether a conditional branch is active. When <code>active</code> is false, the conditions are not evaluated.</p>', 'DialogAction$suppressNextMessage' => '<p>When true the next message for the intent is not used.</p>', 'DialogCodeHookInvocationSetting$enableCodeHookInvocation' => '<p>Indicates whether a Lambda function should be invoked for the dialog.</p>', 'DialogCodeHookInvocationSetting$active' => '<p>Determines whether a dialog code hook is used when the intent is activated.</p>', 'ElicitationCodeHookInvocationSetting$enableCodeHookInvocation' => '<p>Indicates whether a Lambda function should be invoked for the dialog.</p>', 'FulfillmentCodeHookSettings$active' => '<p>Determines whether the fulfillment code hook is used. When <code>active</code> is false, the code hook doesn\'t run.</p>', 'FulfillmentStartResponseSpecification$allowInterrupt' => '<p>Determines whether the user can interrupt the start message while it is playing.</p>', 'FulfillmentUpdateResponseSpecification$allowInterrupt' => '<p>Determines whether the user can interrupt an update message while it is playing.</p>', 'FulfillmentUpdatesSpecification$active' => '<p>Determines whether fulfillment updates are sent to the user. When this field is true, updates are sent.</p> <p>If the <code>active</code> field is set to true, the <code>startResponse</code>, <code>updateResponse</code>, and <code>timeoutInSeconds</code> fields are required.</p>', 'IntentClosingSetting$active' => '<p>Specifies whether an intent\'s closing response is used. When this field is false, the closing response isn\'t sent to the user. If the <code>active</code> field isn\'t specified, the default is true.</p>', 'IntentConfirmationSetting$active' => '<p>Specifies whether the intent\'s confirmation is sent to the user. When this field is false, confirmation and declination responses aren\'t sent. If the <code>active</code> field isn\'t specified, the default is true.</p>', 'PromptAttemptSpecification$allowInterrupt' => '<p>Indicates whether the user can interrupt a speech prompt attempt from the bot.</p>', 'PromptSpecification$allowInterrupt' => '<p>Indicates whether the user can interrupt a speech prompt from the bot.</p>', 'ResponseSpecification$allowInterrupt' => '<p>Indicates whether the user can interrupt a speech response from Amazon Lex.</p>', 'StillWaitingResponseSpecification$allowInterrupt' => '<p>Indicates that the user can interrupt the response by speaking while the message is being played.</p>', 'TextLogSetting$selectiveLoggingEnabled' => '<p>The option to enable selective conversation log capture for text.</p>', 'WaitAndContinueSpecification$active' => '<p>Specifies whether the bot will wait for a user to respond. When this field is false, wait and continue responses for a slot aren\'t used. If the <code>active</code> field isn\'t specified, the default is true.</p>', ], ], 'BuildBotLocaleRequest' => [ 'base' => NULL, 'refs' => [], ], 'BuildBotLocaleResponse' => [ 'base' => NULL, 'refs' => [], ], 'BuildtimeSettings' => [ 'base' => '<p>Contains specifications about the Amazon Lex build time generative AI capabilities from Amazon Bedrock that you can turn on for your bot.</p>', 'refs' => [ 'GenerativeAISettings$buildtimeSettings' => NULL, ], ], 'BuiltInIntentSortAttribute' => [ 'base' => NULL, 'refs' => [ 'BuiltInIntentSortBy$attribute' => '<p>The attribute to use to sort the list of built-in intents.</p>', ], ], 'BuiltInIntentSortBy' => [ 'base' => '<p>Specifies attributes for sorting a list of built-in intents.</p>', 'refs' => [ 'ListBuiltInIntentsRequest$sortBy' => '<p>Specifies sorting parameters for the list of built-in intents. You can specify that the list be sorted by the built-in intent signature in either ascending or descending order.</p>', ], ], 'BuiltInIntentSummary' => [ 'base' => '<p>Provides summary information about a built-in intent for the <a href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListBuiltInIntents.html"> ListBuiltInIntents </a> operation.</p>', 'refs' => [ 'BuiltInIntentSummaryList$member' => NULL, ], ], 'BuiltInIntentSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListBuiltInIntentsResponse$builtInIntentSummaries' => '<p>Summary information for the built-in intents that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more intents available, the <code>nextToken</code> field contains a token to get the next page of results.</p>', ], ], 'BuiltInOrCustomSlotTypeId' => [ 'base' => NULL, 'refs' => [ 'CreateSlotRequest$slotTypeId' => '<p>The unique identifier for the slot type associated with this slot. The slot type determines the values that can be entered into the slot.</p>', 'CreateSlotResponse$slotTypeId' => '<p>The unique identifier of the slot type associated with this slot.</p>', 'DescribeSlotResponse$slotTypeId' => '<p>The identifier of the slot type that determines the values entered into the slot.</p>', 'SlotSummary$slotTypeId' => '<p>The unique identifier for the slot type that defines the values for the slot.</p>', 'Specifications$slotTypeId' => '<p>The unique identifier assigned to the slot type.</p>', 'SubSlotTypeComposition$slotTypeId' => '<p>The unique identifier assigned to a slot type. This refers to either a built-in slot type or the unique slotTypeId of a custom slot type.</p>', 'UpdateSlotRequest$slotTypeId' => '<p>The unique identifier of the new slot type to associate with this slot. </p>', 'UpdateSlotResponse$slotTypeId' => '<p>The updated identifier of the slot type that provides values for the slot.</p>', ], ], 'BuiltInSlotTypeSortAttribute' => [ 'base' => NULL, 'refs' => [ 'BuiltInSlotTypeSortBy$attribute' => '<p>The attribute to use to sort the list of built-in intents.</p>', ], ], 'BuiltInSlotTypeSortBy' => [ 'base' => '<p>Specifies attributes for sorting a list of built-in slot types.</p>', 'refs' => [ 'ListBuiltInSlotTypesRequest$sortBy' => '<p>Determines the sort order for the response from the <code>ListBuiltInSlotTypes</code> operation. You can choose to sort by the slot type signature in either ascending or descending order.</p>', ], ], 'BuiltInSlotTypeSummary' => [ 'base' => '<p>Provides summary information about a built-in slot type for the <a href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListBuiltInSlotTypes.html"> ListBuiltInSlotTypes </a> operation.</p>', 'refs' => [ 'BuiltInSlotTypeSummaryList$member' => NULL, ], ], 'BuiltInSlotTypeSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListBuiltInSlotTypesResponse$builtInSlotTypeSummaries' => '<p>Summary information for the built-in slot types that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more slot types available, the <code>nextToken</code> field contains a token to get the next page of results.</p>', ], ], 'BuiltInsMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListBuiltInIntentsRequest$maxResults' => '<p>The maximum number of built-in intents to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>', 'ListBuiltInSlotTypesRequest$maxResults' => '<p>The maximum number of built-in slot types to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>', ], ], 'Button' => [ 'base' => '<p>Describes a button to use on a response card used to gather slot values from a user.</p>', 'refs' => [ 'ButtonsList$member' => NULL, ], ], 'ButtonText' => [ 'base' => NULL, 'refs' => [ 'Button$text' => '<p>The text that appears on the button. Use this to tell the user what value is returned when they choose this button.</p>', ], ], 'ButtonValue' => [ 'base' => NULL, 'refs' => [ 'Button$value' => '<p>The value returned to Amazon Lex when the user chooses this button. This must be one of the slot values configured for the slot.</p>', ], ], 'ButtonsList' => [ 'base' => NULL, 'refs' => [ 'ImageResponseCard$buttons' => '<p>A list of buttons that should be displayed on the response card. The arrangement of the buttons is determined by the platform that displays the button.</p>', ], ], 'ChildDirected' => [ 'base' => NULL, 'refs' => [ 'DataPrivacy$childDirected' => '<p>For each Amazon Lex bot created with the Amazon Lex Model Building Service, you must specify whether your use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to the Children\'s Online Privacy Protection Act (COPPA) by specifying <code>true</code> or <code>false</code> in the <code>childDirected</code> field. By specifying <code>true</code> in the <code>childDirected</code> field, you confirm that your use of Amazon Lex <b>is</b> related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. By specifying <code>false</code> in the <code>childDirected</code> field, you confirm that your use of Amazon Lex <b>is not</b> related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. You may not specify a default value for the <code>childDirected</code> field that does not accurately reflect whether your use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. If your use of Amazon Lex relates to a website, program, or other application that is directed in whole or in part, to children under age 13, you must obtain any required verifiable parental consent under COPPA. For information regarding the use of Amazon Lex in connection with websites, programs, or other applications that are directed or targeted, in whole or in part, to children under age 13, see the <a href="http://aws.amazon.com/lex/faqs#data-security">Amazon Lex FAQ</a>.</p>', ], ], 'CloudWatchLogGroupArn' => [ 'base' => NULL, 'refs' => [ 'CloudWatchLogGroupLogDestination$cloudWatchLogGroupArn' => '<p>The Amazon Resource Name (ARN) of the log group where text and metadata logs are delivered.</p>', ], ], 'CloudWatchLogGroupLogDestination' => [ 'base' => '<p>The Amazon CloudWatch Logs log group where the text and metadata logs are delivered. The log group must exist before you enable logging.</p>', 'refs' => [ 'TextLogDestination$cloudWatch' => '<p>Defines the Amazon CloudWatch Logs log group where text and metadata logs are delivered.</p>', ], ], 'CodeHookInterfaceVersion' => [ 'base' => NULL, 'refs' => [ 'LambdaCodeHook$codeHookInterfaceVersion' => '<p>The version of the request-response that you want Amazon Lex to use to invoke your Lambda function.</p>', ], ], 'CodeHookSpecification' => [ 'base' => '<p>Contains information about code hooks that Amazon Lex calls during a conversation.</p>', 'refs' => [ 'BotAliasLocaleSettings$codeHookSpecification' => '<p>Specifies the Lambda function that should be used in the locale.</p>', ], ], 'CompositeSlotTypeSetting' => [ 'base' => '<p>A composite slot is a combination of two or more slots that capture multiple pieces of information in a single user input.</p>', 'refs' => [ 'CreateSlotTypeRequest$compositeSlotTypeSetting' => '<p>Specifications for a composite slot type.</p>', 'CreateSlotTypeResponse$compositeSlotTypeSetting' => '<p>Specifications for a composite slot type.</p>', 'DescribeSlotTypeResponse$compositeSlotTypeSetting' => '<p>Specifications for a composite slot type.</p>', 'UpdateSlotTypeRequest$compositeSlotTypeSetting' => '<p>Specifications for a composite slot type.</p>', 'UpdateSlotTypeResponse$compositeSlotTypeSetting' => '<p>Specifications for a composite slot type.</p>', ], ], 'Condition' => [ 'base' => '<p>Provides an expression that evaluates to true or false. </p>', 'refs' => [ 'ConditionalBranch$condition' => '<p>Contains the expression to evaluate. If the condition is true, the branch\'s actions are taken.</p>', ], ], 'ConditionExpression' => [ 'base' => NULL, 'refs' => [ 'Condition$expressionString' => '<p>The expression string that is evaluated. </p>', ], ], 'ConditionKey' => [ 'base' => NULL, 'refs' => [ 'ConditionKeyValueMap$key' => NULL, ], ], 'ConditionKeyValueMap' => [ 'base' => NULL, 'refs' => [ 'ConditionMap$value' => NULL, ], ], 'ConditionMap' => [ 'base' => NULL, 'refs' => [ 'CreateResourcePolicyStatementRequest$condition' => '<p>Specifies a condition when the policy is in effect. If the principal of the policy is a service principal, you must provide two condition blocks, one with a SourceAccount global condition key and one with a SourceArn global condition key.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html">IAM JSON policy elements: Condition </a>.</p>', ], ], 'ConditionOperator' => [ 'base' => NULL, 'refs' => [ 'ConditionMap$key' => NULL, ], ], 'ConditionValue' => [ 'base' => NULL, 'refs' => [ 'ConditionKeyValueMap$value' => NULL, ], ], 'ConditionalBranch' => [ 'base' => '<p>A set of actions that Amazon Lex should run if the condition is matched.</p>', 'refs' => [ 'ConditionalBranches$member' => NULL, ], ], 'ConditionalBranches' => [ 'base' => NULL, 'refs' => [ 'ConditionalSpecification$conditionalBranches' => '<p>A list of conditional branches. A conditional branch is made up of a condition, a response and a next step. The response and next step are executed when the condition is true.</p>', ], ], 'ConditionalSpecification' => [ 'base' => '<p>Provides a list of conditional branches. Branches are evaluated in the order that they are entered in the list. The first branch with a condition that evaluates to true is executed. The last branch in the list is the default branch. The default branch should not have any condition expression. The default branch is executed if no other branch has a matching condition.</p>', 'refs' => [ 'InitialResponseSetting$conditional' => NULL, 'IntentClosingSetting$conditional' => '<p>A list of conditional branches associated with the intent\'s closing response. These branches are executed when the <code>nextStep</code> attribute is set to <code>EvalutateConditional</code>.</p>', 'IntentConfirmationSetting$confirmationConditional' => '<p>A list of conditional branches to evaluate after the intent is closed.</p>', 'IntentConfirmationSetting$declinationConditional' => '<p>A list of conditional branches to evaluate after the intent is declined.</p>', 'IntentConfirmationSetting$failureConditional' => NULL, 'PostDialogCodeHookInvocationSpecification$successConditional' => '<p>A list of conditional branches to evaluate after the dialog code hook finishes successfully.</p>', 'PostDialogCodeHookInvocationSpecification$failureConditional' => '<p>A list of conditional branches to evaluate after the dialog code hook throws an exception or returns with the <code>State</code> field of the <code>Intent</code> object set to <code>Failed</code>.</p>', 'PostDialogCodeHookInvocationSpecification$timeoutConditional' => '<p>A list of conditional branches to evaluate if the code hook times out.</p>', 'PostFulfillmentStatusSpecification$successConditional' => '<p>A list of conditional branches to evaluate after the fulfillment code hook finishes successfully.</p>', 'PostFulfillmentStatusSpecification$failureConditional' => '<p>A list of conditional branches to evaluate after the fulfillment code hook throws an exception or returns with the <code>State</code> field of the <code>Intent</code> object set to <code>Failed</code>.</p>', 'PostFulfillmentStatusSpecification$timeoutConditional' => '<p>A list of conditional branches to evaluate if the fulfillment code hook times out.</p>', 'SlotCaptureSetting$captureConditional' => '<p>A list of conditional branches to evaluate after the slot value is captured.</p>', 'SlotCaptureSetting$failureConditional' => '<p>A list of conditional branches to evaluate when the slot value isn\'t captured.</p>', ], ], 'ConfidenceThreshold' => [ 'base' => NULL, 'refs' => [ 'BotLocaleImportSpecification$nluIntentConfidenceThreshold' => '<p>Determines the threshold where Amazon Lex will insert the <code>AMAZON.FallbackIntent</code>, <code>AMAZON.KendraSearchIntent</code>, or both when returning alternative intents. <code>AMAZON.FallbackIntent</code> and <code>AMAZON.KendraSearchIntent</code> are only inserted if they are configured for the bot. </p> <p>For example, suppose a bot is configured with the confidence threshold of 0.80 and the <code>AMAZON.FallbackIntent</code>. Amazon Lex returns three alternative intents with the following confidence scores: IntentA (0.70), IntentB (0.60), IntentC (0.50). The response from the <code>PostText</code> operation would be:</p> <ul> <li> <p> <code>AMAZON.FallbackIntent</code> </p> </li> <li> <p> <code>IntentA</code> </p> </li> <li> <p> <code>IntentB</code> </p> </li> <li> <p> <code>IntentC</code> </p> </li> </ul>', 'CreateBotLocaleRequest$nluIntentConfidenceThreshold' => '<p>Determines the threshold where Amazon Lex will insert the <code>AMAZON.FallbackIntent</code>, <code>AMAZON.KendraSearchIntent</code>, or both when returning alternative intents. <code>AMAZON.FallbackIntent</code> and <code>AMAZON.KendraSearchIntent</code> are only inserted if they are configured for the bot.</p> <p>For example, suppose a bot is configured with the confidence threshold of 0.80 and the <code>AMAZON.FallbackIntent</code>. Amazon Lex returns three alternative intents with the following confidence scores: IntentA (0.70), IntentB (0.60), IntentC (0.50). The response from the <code>RecognizeText</code> operation would be:</p> <ul> <li> <p>AMAZON.FallbackIntent</p> </li> <li> <p>IntentA</p> </li> <li> <p>IntentB</p> </li> <li> <p>IntentC</p> </li> </ul>', 'CreateBotLocaleResponse$nluIntentConfidenceThreshold' => '<p>The specified confidence threshold for inserting the <code>AMAZON.FallbackIntent</code> and <code>AMAZON.KendraSearchIntent</code> intents.</p>', 'DescribeBotLocaleResponse$nluIntentConfidenceThreshold' => '<p>The confidence threshold where Amazon Lex inserts the <code>AMAZON.FallbackIntent</code> and <code>AMAZON.KendraSearchIntent</code> intents in the list of possible intents for an utterance.</p>', 'UpdateBotLocaleRequest$nluIntentConfidenceThreshold' => '<p>The new confidence threshold where Amazon Lex inserts the <code>AMAZON.FallbackIntent</code> and <code>AMAZON.KendraSearchIntent</code> intents in the list of possible intents for an utterance.</p>', 'UpdateBotLocaleResponse$nluIntentConfidenceThreshold' => '<p>The updated confidence threshold for inserting the <code>AMAZON.FallbackIntent</code> and <code>AMAZON.KendraSearchIntent</code> intents in the list of possible intents for an utterance.</p>', ], ], 'ConflictException' => [ 'base' => '<p>The action that you tried to perform couldn\'t be completed because the resource is in a conflicting state. For example, deleting a bot that is in the CREATING state. Try your request again. </p>', 'refs' => [], ], 'ContextTimeToLiveInSeconds' => [ 'base' => NULL, 'refs' => [ 'OutputContext$timeToLiveInSeconds' => '<p>The amount of time, in seconds, that the output context should remain active. The time is figured from the first time the context is sent to the user.</p>', ], ], 'ContextTurnsToLive' => [ 'base' => NULL, 'refs' => [ 'OutputContext$turnsToLive' => '<p>The number of conversation turns that the output context should remain active. The number of turns is counted from the first time that the context is sent to the user.</p>', ], ], 'ConversationEndState' => [ 'base' => NULL, 'refs' => [ 'SessionSpecification$conversationEndState' => '<p>The final state of the conversation. A conversation is defined as a unique combination of a <code>sessionId</code> and an <code>originatingRequestId</code>.</p>', ], ], 'ConversationLevelIntentClassificationResultItem' => [ 'base' => '<p>The item listing the evaluation of intent level success or failure.</p>', 'refs' => [ 'ConversationLevelIntentClassificationResults$member' => NULL, ], ], 'ConversationLevelIntentClassificationResults' => [ 'base' => NULL, 'refs' => [ 'ConversationLevelTestResultItem$intentClassificationResults' => '<p>The intent classification of the test result evaluation item.</p>', ], ], 'ConversationLevelResultDetail' => [ 'base' => '<p>The conversation level details of the conversation used in the test set.</p>', 'refs' => [ 'UserTurnResult$conversationLevelResult' => '<p>Contains information about the results related to the conversation associated with the user turn.</p>', ], ], 'ConversationLevelSlotResolutionResultItem' => [ 'base' => '<p>The slots used for the slot resolution in the conversation.</p>', 'refs' => [ 'ConversationLevelSlotResolutionResults$member' => NULL, ], ], 'ConversationLevelSlotResolutionResults' => [ 'base' => NULL, 'refs' => [ 'ConversationLevelTestResultItem$slotResolutionResults' => '<p>The slot success or failure of the test result evaluation item.</p>', ], ], 'ConversationLevelTestResultItem' => [ 'base' => '<p>The test result evaluation item at the conversation level.</p>', 'refs' => [ 'ConversationLevelTestResultItemList$member' => NULL, ], ], 'ConversationLevelTestResultItemList' => [ 'base' => NULL, 'refs' => [ 'ConversationLevelTestResults$items' => '<p>The item list in the test set results data at the conversation level.</p>', ], ], 'ConversationLevelTestResults' => [ 'base' => '<p>The test set results data at the conversation level.</p>', 'refs' => [ 'TestExecutionResultItems$conversationLevelTestResults' => '<p>Results related to conversations in the test set, including metrics about success and failure of conversations and intent and slot failures.</p>', ], ], 'ConversationLevelTestResultsFilterBy' => [ 'base' => '<p>The selection to filter the test set results data at the conversation level.</p>', 'refs' => [ 'TestExecutionResultFilterBy$conversationLevelTestResultsFilterBy' => '<p>Contains information about the method for filtering Conversation level test results.</p>', ], ], 'ConversationLogSettings' => [ 'base' => '<p>Configures conversation logging that saves audio, text, and metadata for the conversations with your users.</p>', 'refs' => [ 'CreateBotAliasRequest$conversationLogSettings' => '<p>Specifies whether Amazon Lex logs text and audio for a conversation with the bot. When you enable conversation logs, text logs store text input, transcripts of audio input, and associated metadata in Amazon CloudWatch Logs. Audio logs store audio input in Amazon S3.</p>', 'CreateBotAliasResponse$conversationLogSettings' => '<p>The conversation log settings specified for the alias.</p>', 'DescribeBotAliasResponse$conversationLogSettings' => '<p>Specifics of how Amazon Lex logs text and audio conversations with the bot associated with the alias.</p>', 'UpdateBotAliasRequest$conversationLogSettings' => '<p>The new settings for storing conversation logs in Amazon CloudWatch Logs and Amazon S3 buckets.</p>', 'UpdateBotAliasResponse$conversationLogSettings' => '<p>The updated settings for storing conversation logs in Amazon CloudWatch Logs and Amazon S3 buckets.</p>', ], ], 'ConversationLogsDataSource' => [ 'base' => '<p>The data source that uses conversation logs.</p>', 'refs' => [ 'TestSetGenerationDataSource$conversationLogsDataSource' => '<p>Contains information about the bot from which the conversation logs are sourced.</p>', ], ], 'ConversationLogsDataSourceFilterBy' => [ 'base' => '<p>The selected data source to filter the conversation log.</p>', 'refs' => [ 'ConversationLogsDataSource$filter' => '<p>The filter for the data source of the conversation log.</p>', ], ], 'ConversationLogsInputModeFilter' => [ 'base' => NULL, 'refs' => [ 'ConversationLogsDataSourceFilterBy$inputMode' => '<p>The selection to filter by input mode for the conversation logs. </p>', ], ], 'Count' => [ 'base' => NULL, 'refs' => [ 'DescribeTestSetResponse$numTurns' => '<p>The total number of agent and user turn in the test set.</p>', 'IntentClassificationTestResultItemCounts$totalResultCount' => '<p>The total number of results in the intent classification test.</p>', 'IntentStatistics$discoveredIntentCount' => '<p>The number of recommended intents associated with the bot recommendation.</p>', 'OverallTestResultItem$totalResultCount' => '<p>The total number of overall results in the result of the test execution.</p>', 'SlotResolutionTestResultItemCounts$totalResultCount' => '<p>The total number of results.</p>', 'SlotTypeStatistics$discoveredSlotTypeCount' => '<p>The number of recommended slot types associated with the bot recommendation.</p>', 'TestResultMatchStatusCountMap$value' => NULL, 'TestSetSummary$numTurns' => '<p>The number of turns in the test set.</p>', 'UpdateTestSetResponse$numTurns' => '<p>The number of conversation turns from the updated test set.</p>', ], ], 'CreateBotAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateBotAliasResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateBotLocaleRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateBotLocaleResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateBotReplicaRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateBotReplicaResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateBotRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateBotResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateBotVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateBotVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateCustomVocabularyItemsList' => [ 'base' => NULL, 'refs' => [ 'BatchCreateCustomVocabularyItemRequest$customVocabularyItemList' => '<p>A list of new custom vocabulary items. Each entry must contain a phrase and can optionally contain a displayAs and/or a weight.</p>', ], ], 'CreateExportRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateExportResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateIntentRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateIntentResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateResourcePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateResourcePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateResourcePolicyStatementRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateResourcePolicyStatementResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateSlotRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSlotResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateSlotTypeRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSlotTypeResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateTestSetDiscrepancyReportRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTestSetDiscrepancyReportResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateUploadUrlRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateUploadUrlResponse' => [ 'base' => NULL, 'refs' => [], ], 'CustomPayload' => [ 'base' => '<p>A custom response string that Amazon Lex sends to your application. You define the content and structure the string.</p>', 'refs' => [ 'Message$customPayload' => '<p>A message in a custom format defined by the client application.</p>', ], ], 'CustomPayloadValue' => [ 'base' => NULL, 'refs' => [ 'CustomPayload$value' => '<p>The string that is sent to your application.</p>', ], ], 'CustomVocabularyEntryId' => [ 'base' => '<p>The unique entry identifier for the custom vocabulary items.</p>', 'refs' => [ 'DeleteCustomVocabularyItemsList$member' => NULL, ], ], 'CustomVocabularyExportSpecification' => [ 'base' => '<p>Provides the parameters required for exporting a custom vocabulary.</p>', 'refs' => [ 'ExportResourceSpecification$customVocabularyExportSpecification' => '<p>The parameters required to export a custom vocabulary.</p>', ], ], 'CustomVocabularyImportSpecification' => [ 'base' => '<p>Provides the parameters required for importing a custom vocabulary.</p>', 'refs' => [ 'ImportResourceSpecification$customVocabularyImportSpecification' => NULL, ], ], 'CustomVocabularyItem' => [ 'base' => '<p>The unique custom vocabulary item from the custom vocabulary list.</p>', 'refs' => [ 'CustomVocabularyItems$member' => NULL, 'UpdateCustomVocabularyItemsList$member' => NULL, ], ], 'CustomVocabularyItems' => [ 'base' => NULL, 'refs' => [ 'BatchCreateCustomVocabularyItemResponse$resources' => '<p>A list of custom vocabulary items that were successfully created during the operation.</p>', 'BatchDeleteCustomVocabularyItemResponse$resources' => '<p>A list of custom vocabulary items that were successfully deleted during the operation.</p>', 'BatchUpdateCustomVocabularyItemResponse$resources' => '<p>A list of custom vocabulary items that were successfully updated during the operation.</p>', 'ListCustomVocabularyItemsResponse$customVocabularyItems' => '<p>The custom vocabulary items from the list custom vocabulary response.</p>', ], ], 'CustomVocabularyStatus' => [ 'base' => NULL, 'refs' => [ 'DeleteCustomVocabularyResponse$customVocabularyStatus' => '<p>The status of removing the custom vocabulary.</p>', 'DescribeCustomVocabularyMetadataResponse$customVocabularyStatus' => '<p>The status of the custom vocabulary. If the status is <code>Ready</code> the custom vocabulary is ready to use.</p>', ], ], 'DTMFCharacter' => [ 'base' => NULL, 'refs' => [ 'DTMFSpecification$deletionCharacter' => '<p>The DTMF character that clears the accumulated DTMF digits and immediately ends the input.</p>', 'DTMFSpecification$endCharacter' => '<p>The DTMF character that immediately ends input. If the user does not press this character, the input ends after the end timeout.</p>', ], ], 'DTMFSpecification' => [ 'base' => '<p>Specifies the DTMF input specifications.</p>', 'refs' => [ 'AudioAndDTMFInputSpecification$dtmfSpecification' => '<p>Specifies the settings on DTMF input.</p>', ], ], 'DataPrivacy' => [ 'base' => '<p>By default, data stored by Amazon Lex is encrypted. The <code>DataPrivacy</code> structure provides settings that determine how Amazon Lex handles special cases of securing the data for your bot. </p>', 'refs' => [ 'BotImportSpecification$dataPrivacy' => NULL, 'CreateBotRequest$dataPrivacy' => '<p>Provides information on additional privacy protections Amazon Lex should use with the bot\'s data.</p>', 'CreateBotResponse$dataPrivacy' => '<p>The data privacy settings specified for the bot.</p>', 'DescribeBotResponse$dataPrivacy' => '<p>Settings for managing data privacy of the bot and its conversations with users.</p>', 'DescribeBotVersionResponse$dataPrivacy' => '<p>Data privacy settings for the bot version.</p>', 'UpdateBotRequest$dataPrivacy' => '<p>Provides information on additional privacy protections Amazon Lex should use with the bot\'s data.</p>', 'UpdateBotResponse$dataPrivacy' => '<p>The data privacy settings for the bot after the update.</p>', ], ], 'DataSourceConfiguration' => [ 'base' => '<p>Contains details about the configuration of the knowledge store used for the <code>AMAZON.QnAIntent</code>. You must have already created the knowledge store and indexed the documents within it.</p>', 'refs' => [ 'QnAIntentConfiguration$dataSourceConfiguration' => '<p>Contains details about the configuration of the data source used for the <code>AMAZON.QnAIntent</code>.</p>', ], ], 'DateRangeFilter' => [ 'base' => '<p>The object used for specifying the data range that the customer wants Amazon Lex to read through in the input transcripts.</p>', 'refs' => [ 'LexTranscriptFilter$dateRangeFilter' => '<p>The object that contains a date range filter that will be applied to the transcript. Specify this object if you want Amazon Lex to only read the files that are within the date range.</p>', ], ], 'DefaultConditionalBranch' => [ 'base' => '<p>A set of actions that Amazon Lex should run if none of the other conditions are met.</p>', 'refs' => [ 'ConditionalSpecification$defaultBranch' => '<p>The conditional branch that should be followed when the conditions for other branches are not satisfied. A conditional branch is made up of a condition, a response and a next step.</p>', ], ], 'DeleteBotAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBotAliasResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBotLocaleRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBotLocaleResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBotReplicaRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBotReplicaResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBotRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBotResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBotVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBotVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteCustomVocabularyItemsList' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteCustomVocabularyItemRequest$customVocabularyItemList' => '<p>A list of custom vocabulary items requested to be deleted. Each entry must contain the unique custom vocabulary entry identifier.</p>', ], ], 'DeleteCustomVocabularyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteCustomVocabularyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteExportRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteExportResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteImportRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteImportResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteIntentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResourcePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResourcePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResourcePolicyStatementRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResourcePolicyStatementResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSlotRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSlotTypeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTestSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUtterancesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUtterancesResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeBotAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeBotAliasResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeBotLocaleRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeBotLocaleResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeBotRecommendationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeBotRecommendationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeBotReplicaRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeBotReplicaResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeBotRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeBotResourceGenerationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeBotResourceGenerationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeBotResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeBotVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeBotVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCustomVocabularyMetadataRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCustomVocabularyMetadataResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeExportRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeExportResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeImportRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeImportResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIntentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIntentResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeResourcePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeResourcePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSlotRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSlotResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSlotTypeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSlotTypeResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTestExecutionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTestExecutionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTestSetDiscrepancyReportRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTestSetDiscrepancyReportResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTestSetGenerationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTestSetGenerationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTestSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTestSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'BotAliasSummary$description' => '<p>The description of the bot alias.</p>', 'BotLocaleSummary$description' => '<p>The description of the bot locale.</p>', 'BotSummary$description' => '<p>The description of the bot.</p>', 'BotVersionSummary$description' => '<p>The description of the version.</p>', 'BuiltInIntentSummary$description' => '<p>The description of the intent.</p>', 'BuiltInSlotTypeSummary$description' => '<p>The description of the built-in slot type.</p>', 'CreateBotAliasRequest$description' => '<p>A description of the alias. Use this description to help identify the alias.</p>', 'CreateBotAliasResponse$description' => '<p>The description specified for the bot alias.</p>', 'CreateBotLocaleRequest$description' => '<p>A description of the bot locale. Use this to help identify the bot locale in lists.</p>', 'CreateBotLocaleResponse$description' => '<p>The specified description of the bot locale.</p>', 'CreateBotRequest$description' => '<p>A description of the bot. It appears in lists to help you identify a particular bot.</p>', 'CreateBotResponse$description' => '<p>The description specified for the bot.</p>', 'CreateBotVersionRequest$description' => '<p>A description of the version. Use the description to help identify the version in lists.</p>', 'CreateBotVersionResponse$description' => '<p>The description of the version specified in the request.</p>', 'CreateIntentRequest$description' => '<p>A description of the intent. Use the description to help identify the intent in lists.</p>', 'CreateIntentResponse$description' => '<p>The description specified for the intent.</p>', 'CreateSlotRequest$description' => '<p>A description of the slot. Use this to help identify the slot in lists.</p>', 'CreateSlotResponse$description' => '<p>The description associated with the slot.</p>', 'CreateSlotTypeRequest$description' => '<p>A description of the slot type. Use the description to help identify the slot type in lists.</p>', 'CreateSlotTypeResponse$description' => '<p>The description specified for the slot type.</p>', 'DescribeBotAliasResponse$description' => '<p>The description of the bot alias.</p>', 'DescribeBotLocaleResponse$description' => '<p>The description of the locale.</p>', 'DescribeBotResponse$description' => '<p>The description of the bot. </p>', 'DescribeBotVersionResponse$description' => '<p>The description specified for the bot.</p>', 'DescribeIntentResponse$description' => '<p>The description of the intent.</p>', 'DescribeSlotResponse$description' => '<p>The description specified for the slot.</p>', 'DescribeSlotTypeResponse$description' => '<p>The description specified for the slot type.</p>', 'DescribeTestSetGenerationResponse$description' => '<p>The test set description for the test set generation.</p>', 'DescribeTestSetResponse$description' => '<p>The description of the test set.</p>', 'IntentSummary$description' => '<p>The description of the intent.</p>', 'SlotSummary$description' => '<p>The description of the slot.</p>', 'SlotTypeSummary$description' => '<p>The description of the slot type.</p>', 'StartTestSetGenerationRequest$description' => '<p>The test set description for the test set generation request.</p>', 'StartTestSetGenerationResponse$description' => '<p>The description used for the test set generation.</p>', 'TestSetImportResourceSpecification$description' => '<p>The description of the test set.</p>', 'TestSetSummary$description' => '<p>The description of the test set.</p>', 'UpdateBotAliasRequest$description' => '<p>The new description to assign to the bot alias.</p>', 'UpdateBotAliasResponse$description' => '<p>The updated description of the bot alias.</p>', 'UpdateBotLocaleRequest$description' => '<p>The new description of the locale.</p>', 'UpdateBotLocaleResponse$description' => '<p>The updated description of the locale.</p>', 'UpdateBotRequest$description' => '<p>A description of the bot.</p>', 'UpdateBotResponse$description' => '<p>The description of the bot after the update.</p>', 'UpdateIntentRequest$description' => '<p>The new description of the intent.</p>', 'UpdateIntentResponse$description' => '<p>The updated description of the intent.</p>', 'UpdateSlotRequest$description' => '<p>The new description for the slot.</p>', 'UpdateSlotResponse$description' => '<p>The updated description of the bot.</p>', 'UpdateSlotTypeRequest$description' => '<p>The new description of the slot type.</p>', 'UpdateSlotTypeResponse$description' => '<p>The updated description of the slot type.</p>', 'UpdateTestSetRequest$description' => '<p>The new test set description.</p>', 'UpdateTestSetResponse$description' => '<p>The test set description for the updated test set.</p>', ], ], 'DescriptiveBotBuilderSpecification' => [ 'base' => '<p>Contains specifications for the descriptive bot building feature.</p>', 'refs' => [ 'BuildtimeSettings$descriptiveBotBuilder' => '<p>An object containing specifications for the descriptive bot building feature.</p>', ], ], 'DialogAction' => [ 'base' => '<p>Defines the action that the bot executes at runtime when the conversation reaches this step.</p>', 'refs' => [ 'DialogState$dialogAction' => NULL, ], ], 'DialogActionType' => [ 'base' => NULL, 'refs' => [ 'DialogAction$type' => '<p>The action that the bot should execute. </p>', ], ], 'DialogCodeHookInvocationSetting' => [ 'base' => '<p>Settings that specify the dialog code hook that is called by Amazon Lex at a step of the conversation. </p>', 'refs' => [ 'InitialResponseSetting$codeHook' => NULL, 'IntentConfirmationSetting$codeHook' => '<p>The <code>DialogCodeHookInvocationSetting</code> object associated with intent\'s confirmation step. The dialog code hook is triggered based on these invocation settings when the confirmation next step or declination next step or failure next step is <code>InvokeDialogCodeHook</code>. </p>', 'SlotCaptureSetting$codeHook' => '<p>Code hook called after Amazon Lex successfully captures a slot value.</p>', ], ], 'DialogCodeHookSettings' => [ 'base' => '<p>Settings that determine the Lambda function that Amazon Lex uses for processing user responses.</p>', 'refs' => [ 'CreateIntentRequest$dialogCodeHook' => '<p>Specifies that Amazon Lex invokes the alias Lambda function for each user input. You can invoke this Lambda function to personalize user interaction.</p> <p>For example, suppose that your bot determines that the user\'s name is John. You Lambda function might retrieve John\'s information from a backend database and prepopulate some of the values. For example, if you find that John is gluten intolerant, you might set the corresponding intent slot, <code>glutenIntolerant</code> to <code>true</code>. You might find John\'s phone number and set the corresponding session attribute.</p>', 'CreateIntentResponse$dialogCodeHook' => '<p>The dialog Lambda function specified for the intent.</p>', 'DescribeIntentResponse$dialogCodeHook' => '<p>The Lambda function called during each turn of a conversation with the intent.</p>', 'UpdateIntentRequest$dialogCodeHook' => '<p>The new Lambda function to use between each turn of the conversation with the bot.</p>', 'UpdateIntentResponse$dialogCodeHook' => '<p>The updated Lambda function called during each turn of the conversation with the user.</p>', ], ], 'DialogState' => [ 'base' => '<p>The current state of the conversation with the user.</p>', 'refs' => [ 'ConditionalBranch$nextStep' => '<p>The next step in the conversation.</p>', 'DefaultConditionalBranch$nextStep' => '<p>The next step in the conversation.</p>', 'InitialResponseSetting$nextStep' => '<p>The next step in the conversation.</p>', 'IntentClosingSetting$nextStep' => '<p>Specifies the next step that the bot executes after playing the intent\'s closing response.</p>', 'IntentConfirmationSetting$confirmationNextStep' => '<p>Specifies the next step that the bot executes when the customer confirms the intent.</p>', 'IntentConfirmationSetting$declinationNextStep' => '<p>Specifies the next step that the bot executes when the customer declines the intent.</p>', 'IntentConfirmationSetting$failureNextStep' => '<p>The next step to take in the conversation if the confirmation step fails.</p>', 'PostDialogCodeHookInvocationSpecification$successNextStep' => '<p>Specifics the next step the bot runs after the dialog code hook finishes successfully. </p>', 'PostDialogCodeHookInvocationSpecification$failureNextStep' => '<p>Specifies the next step the bot runs after the dialog code hook throws an exception or returns with the <code>State</code> field of the <code>Intent</code> object set to <code>Failed</code>.</p>', 'PostDialogCodeHookInvocationSpecification$timeoutNextStep' => '<p>Specifies the next step that the bot runs when the code hook times out.</p>', 'PostFulfillmentStatusSpecification$successNextStep' => '<p>Specifies the next step in the conversation that Amazon Lex invokes when the fulfillment code hook completes successfully.</p>', 'PostFulfillmentStatusSpecification$failureNextStep' => '<p>Specifies the next step the bot runs after the fulfillment code hook throws an exception or returns with the <code>State</code> field of the <code>Intent</code> object set to <code>Failed</code>.</p>', 'PostFulfillmentStatusSpecification$timeoutNextStep' => '<p>Specifies the next step that the bot runs when the fulfillment code hook times out.</p>', 'SlotCaptureSetting$captureNextStep' => '<p>Specifies the next step that the bot runs when the slot value is captured before the code hook times out.</p>', 'SlotCaptureSetting$failureNextStep' => '<p>Specifies the next step that the bot runs when the slot value code is not recognized.</p>', ], ], 'DomainEndpoint' => [ 'base' => NULL, 'refs' => [ 'OpensearchConfiguration$domainEndpoint' => '<p>The endpoint of the Amazon OpenSearch Service domain.</p>', ], ], 'DraftBotVersion' => [ 'base' => NULL, 'refs' => [ 'BotLocaleImportSpecification$botVersion' => '<p>The version of the bot to import the locale to. This can only be the <code>DRAFT</code> version of the bot.</p>', 'BuildBotLocaleRequest$botVersion' => '<p>The version of the bot to build. This can only be the draft version of the bot.</p>', 'BuildBotLocaleResponse$botVersion' => '<p>The version of the bot that was built. This is only the draft version of the bot.</p>', 'CreateBotLocaleRequest$botVersion' => '<p>The version of the bot to create the locale for. This can only be the draft version of the bot.</p>', 'CreateBotLocaleResponse$botVersion' => '<p>The specified bot version.</p>', 'CreateIntentRequest$botVersion' => '<p>The version of the bot associated with this intent.</p>', 'CreateIntentResponse$botVersion' => '<p>The version of the bot associated with the intent.</p>', 'CreateSlotRequest$botVersion' => '<p>The version of the bot associated with the slot.</p>', 'CreateSlotResponse$botVersion' => '<p>The version of the bot associated with the slot.</p>', 'CreateSlotTypeRequest$botVersion' => '<p>The identifier of the bot version associated with this slot type.</p>', 'CreateSlotTypeResponse$botVersion' => '<p>The version of the bot associated with the slot type.</p>', 'CustomVocabularyImportSpecification$botVersion' => '<p>The version of the bot to import the custom vocabulary to.</p>', 'DeleteBotLocaleRequest$botVersion' => '<p>The version of the bot that contains the locale. </p>', 'DeleteBotLocaleResponse$botVersion' => '<p>The version of the bot that contained the deleted locale.</p>', 'DeleteCustomVocabularyRequest$botVersion' => '<p>The version of the bot to remove the custom vocabulary from.</p>', 'DeleteCustomVocabularyResponse$botVersion' => '<p>The version of the bot that the custom vocabulary was removed from.</p>', 'DeleteIntentRequest$botVersion' => '<p>The version of the bot associated with the intent.</p>', 'DeleteSlotRequest$botVersion' => '<p>The version of the bot associated with the slot to delete.</p>', 'DeleteSlotTypeRequest$botVersion' => '<p>The version of the bot associated with the slot type.</p>', 'DescribeBotRecommendationRequest$botVersion' => '<p>The version of the bot associated with the bot recommendation.</p>', 'DescribeBotRecommendationResponse$botVersion' => '<p>The version of the bot associated with the bot recommendation.</p>', 'DescribeIntentResponse$botVersion' => '<p>The version of the bot associated with the intent.</p>', 'GenerateBotElementResponse$botVersion' => '<p>The unique bot version for the bot which received the response.</p>', 'ListBotRecommendationsRequest$botVersion' => '<p>The version of the bot that contains the bot recommendation list.</p>', 'ListBotRecommendationsResponse$botVersion' => '<p>The version of the bot that contains the bot recommendation list.</p>', 'ListImportsRequest$botVersion' => '<p>The version of the bot to list imports for.</p>', 'ListImportsResponse$botVersion' => '<p>The version of the bot that was imported. It will always be <code>DRAFT</code>.</p>', 'ListRecommendedIntentsRequest$botVersion' => '<p>The version of the bot that contains the recommended intents.</p>', 'ListRecommendedIntentsResponse$botVersion' => '<p>The version of the bot that contains the intent.</p>', 'StartBotRecommendationRequest$botVersion' => '<p>The version of the bot containing the bot recommendation.</p>', 'StartBotRecommendationResponse$botVersion' => '<p>The version of the bot containing the bot recommendation.</p>', 'StopBotRecommendationRequest$botVersion' => '<p>The version of the bot containing the bot recommendation.</p>', 'StopBotRecommendationResponse$botVersion' => '<p>The version of the bot containing the recommendation that is being stopped.</p>', 'UpdateBotLocaleRequest$botVersion' => '<p>The version of the bot that contains the locale to be updated. The version can only be the <code>DRAFT</code> version.</p>', 'UpdateBotLocaleResponse$botVersion' => '<p>The version of the bot that contains the updated locale.</p>', 'UpdateBotRecommendationRequest$botVersion' => '<p>The version of the bot containing the bot recommendation to be updated.</p>', 'UpdateBotRecommendationResponse$botVersion' => '<p>The version of the bot containing the bot recommendation that has been updated.</p>', 'UpdateIntentRequest$botVersion' => '<p>The version of the bot that contains the intent. Must be <code>DRAFT</code>.</p>', 'UpdateIntentResponse$botVersion' => '<p>The version of the bot that contains the intent. Will always be <code>DRAFT</code>.</p>', 'UpdateSlotRequest$botVersion' => '<p>The version of the bot that contains the slot. Must always be <code>DRAFT</code>.</p>', 'UpdateSlotResponse$botVersion' => '<p>The version of the bot that contains the slot. Will always be <code>DRAFT</code>.</p>', 'UpdateSlotTypeRequest$botVersion' => '<p>The version of the bot that contains the slot type. Must be <code>DRAFT</code>.</p>', 'UpdateSlotTypeResponse$botVersion' => '<p>The version of the bot that contains the slot type. This is always <code>DRAFT</code>.</p>', ], ], 'Effect' => [ 'base' => NULL, 'refs' => [ 'CreateResourcePolicyStatementRequest$effect' => '<p>Determines whether the statement allows or denies access to the resource.</p>', ], ], 'ElicitationCodeHookInvocationSetting' => [ 'base' => '<p>Settings that specify the dialog code hook that is called by Amazon Lex between eliciting slot values.</p>', 'refs' => [ 'IntentConfirmationSetting$elicitationCodeHook' => '<p>The <code>DialogCodeHookInvocationSetting</code> used when the code hook is invoked during confirmation prompt retries.</p>', 'SlotCaptureSetting$elicitationCodeHook' => '<p>Code hook called when Amazon Lex doesn\'t capture a slot value.</p>', ], ], 'Enabled' => [ 'base' => NULL, 'refs' => [ 'SlotResolutionImprovementSpecification$enabled' => '<p>Specifies whether assisted slot resolution is turned on or off.</p>', ], ], 'EncryptionSetting' => [ 'base' => '<p>The object representing the passwords that were used to encrypt the data related to the bot recommendation, as well as the KMS key ARN used to encrypt the associated metadata.</p>', 'refs' => [ 'DescribeBotRecommendationResponse$encryptionSetting' => '<p>The object representing the passwords that were used to encrypt the data related to the bot recommendation results, as well as the KMS key ARN used to encrypt the associated metadata.</p>', 'StartBotRecommendationRequest$encryptionSetting' => '<p>The object representing the passwords that will be used to encrypt the data related to the bot recommendation results, as well as the KMS key ARN used to encrypt the associated metadata.</p>', 'StartBotRecommendationResponse$encryptionSetting' => '<p>The object representing the passwords that were used to encrypt the data related to the bot recommendation results, as well as the KMS key ARN used to encrypt the associated metadata.</p>', 'UpdateBotRecommendationRequest$encryptionSetting' => '<p>The object representing the passwords that will be used to encrypt the data related to the bot recommendation results, as well as the KMS key ARN used to encrypt the associated metadata.</p>', 'UpdateBotRecommendationResponse$encryptionSetting' => '<p>The object representing the passwords that were used to encrypt the data related to the bot recommendation results, as well as the KMS key ARN used to encrypt the associated metadata.</p>', ], ], 'ErrorCode' => [ 'base' => NULL, 'refs' => [ 'FailedCustomVocabularyItem$errorCode' => '<p>The unique error code for the failed custom vocabulary item from the custom vocabulary list.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'FailedCustomVocabularyItem$errorMessage' => '<p>The error message for the failed custom vocabulary item from the custom vocabulary list.</p>', ], ], 'ExactResponseFields' => [ 'base' => '<p>Contains the names of the fields used for an exact response to the user.</p>', 'refs' => [ 'OpensearchConfiguration$exactResponseFields' => '<p>Contains the names of the fields used for an exact response to the user.</p>', ], ], 'ExceptionMessage' => [ 'base' => NULL, 'refs' => [ 'ConflictException$message' => NULL, 'InternalServerException$message' => NULL, 'PreconditionFailedException$message' => NULL, 'ResourceNotFoundException$message' => NULL, 'ServiceQuotaExceededException$message' => NULL, 'ThrottlingException$message' => NULL, 'ValidationException$message' => NULL, ], ], 'ExecutionErrorDetails' => [ 'base' => '<p>Details about an error in an execution of a test set.</p>', 'refs' => [ 'AgentTurnResult$errorDetails' => NULL, 'UserTurnResult$errorDetails' => NULL, ], ], 'ExportFilter' => [ 'base' => '<p>Filters the response form the <a href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListExports.html">ListExports</a> operation</p>', 'refs' => [ 'ExportFilters$member' => NULL, ], ], 'ExportFilterName' => [ 'base' => NULL, 'refs' => [ 'ExportFilter$name' => '<p>The name of the field to use for filtering.</p>', ], ], 'ExportFilterOperator' => [ 'base' => NULL, 'refs' => [ 'ExportFilter$operator' => '<p>The operator to use for the filter. Specify EQ when the <code>ListExports</code> operation should return only resource types that equal the specified value. Specify CO when the <code>ListExports</code> operation should return resource types that contain the specified value.</p>', ], ], 'ExportFilters' => [ 'base' => NULL, 'refs' => [ 'ListExportsRequest$filters' => '<p>Provides the specification of a filter used to limit the exports in the response to only those that match the filter specification. You can only specify one filter and one string to filter on.</p>', ], ], 'ExportResourceSpecification' => [ 'base' => '<p>Provides information about the bot or bot locale that you want to export. You can specify the <code>botExportSpecification</code> or the <code>botLocaleExportSpecification</code>, but not both.</p>', 'refs' => [ 'CreateExportRequest$resourceSpecification' => '<p>Specifies the type of resource to export, either a bot or a bot locale. You can only specify one type of resource to export.</p>', 'CreateExportResponse$resourceSpecification' => '<p>A description of the type of resource that was exported, either a bot or a bot locale.</p>', 'DescribeExportResponse$resourceSpecification' => '<p>The bot, bot ID, and optional locale ID of the exported bot or bot locale.</p>', 'ExportSummary$resourceSpecification' => '<p>Information about the bot or bot locale that was exported.</p>', 'UpdateExportResponse$resourceSpecification' => '<p>A description of the type of resource that was exported, either a bot or a bot locale.</p>', ], ], 'ExportSortAttribute' => [ 'base' => NULL, 'refs' => [ 'ExportSortBy$attribute' => '<p>The export field to use for sorting.</p>', ], ], 'ExportSortBy' => [ 'base' => '<p>Provides information about sorting a list of exports.</p>', 'refs' => [ 'ListExportsRequest$sortBy' => '<p>Determines the field that the list of exports is sorted by. You can sort by the <code>LastUpdatedDateTime</code> field in ascending or descending order.</p>', ], ], 'ExportStatus' => [ 'base' => NULL, 'refs' => [ 'CreateExportResponse$exportStatus' => '<p>The status of the export. When the status is <code>Completed</code>, you can use the <a href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DescribeExport.html">DescribeExport</a> operation to get the pre-signed S3 URL link to your exported bot or bot locale.</p>', 'DeleteExportResponse$exportStatus' => '<p>The current status of the deletion. When the deletion is complete, the export will no longer be returned by the <a href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListExports.html">ListExports</a> operation and calls to the <a href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DescribeExport.html"> DescribeExport</a> operation with the export identifier will fail.</p>', 'DescribeExportResponse$exportStatus' => '<p>The status of the export. When the status is <code>Complete</code> the export archive file is available for download.</p>', 'ExportSummary$exportStatus' => '<p>The status of the export. When the status is <code>Completed</code> the export is ready to download.</p>', 'UpdateExportResponse$exportStatus' => '<p>The status of the export. When the status is <code>Completed</code> the export archive is available for download.</p>', ], ], 'ExportSummary' => [ 'base' => '<p>Provides summary information about an export in an export list. </p>', 'refs' => [ 'ExportSummaryList$member' => NULL, ], ], 'ExportSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListExportsResponse$exportSummaries' => '<p>Summary information for the exports that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter. If there are more exports available, the <code>nextToken</code> field contains a token to get the next page of results.</p>', ], ], 'ExternalSourceSetting' => [ 'base' => '<p>Provides information about the external source of the slot type\'s definition.</p>', 'refs' => [ 'CreateSlotTypeRequest$externalSourceSetting' => '<p>Sets the type of external information used to create the slot type.</p>', 'CreateSlotTypeResponse$externalSourceSetting' => '<p>The type of external information used to create the slot type.</p>', 'DescribeSlotTypeResponse$externalSourceSetting' => NULL, 'UpdateSlotTypeRequest$externalSourceSetting' => NULL, 'UpdateSlotTypeResponse$externalSourceSetting' => NULL, ], ], 'FailedCustomVocabularyItem' => [ 'base' => '<p>The unique failed custom vocabulary item from the custom vocabulary list.</p>', 'refs' => [ 'FailedCustomVocabularyItems$member' => NULL, ], ], 'FailedCustomVocabularyItems' => [ 'base' => NULL, 'refs' => [ 'BatchCreateCustomVocabularyItemResponse$errors' => '<p>A list of custom vocabulary items that failed to create during the operation. The reason for the error is contained within each error object.</p>', 'BatchDeleteCustomVocabularyItemResponse$errors' => '<p>A list of custom vocabulary items that failed to delete during the operation. The reason for the error is contained within each error object.</p>', 'BatchUpdateCustomVocabularyItemResponse$errors' => '<p>A list of custom vocabulary items that failed to update during the operation. The reason for the error is contained within each error object.</p>', ], ], 'FailureReason' => [ 'base' => NULL, 'refs' => [ 'FailureReasons$member' => NULL, ], ], 'FailureReasons' => [ 'base' => NULL, 'refs' => [ 'BotAliasReplicaSummary$failureReasons' => '<p>The reasons for failure for the aliases bot replications.</p>', 'BotReplicaSummary$failureReasons' => '<p>The reasons for the failure for the replicated bot.</p>', 'BotVersionReplicaSummary$failureReasons' => '<p>The reasons for replication failure for all the replicated bots.</p>', 'DescribeBotLocaleResponse$failureReasons' => '<p>if <code>botLocaleStatus</code> is <code>Failed</code>, Amazon Lex explains why it failed to build the bot.</p>', 'DescribeBotRecommendationResponse$failureReasons' => '<p>If botRecommendationStatus is Failed, Amazon Lex explains why.</p>', 'DescribeBotReplicaResponse$failureReasons' => '<p>The failure reasons the bot being monitored failed to replicate.</p>', 'DescribeBotResourceGenerationResponse$failureReasons' => '<p>A list of reasons why the generation of bot resources through natural language description failed.</p>', 'DescribeBotResponse$failureReasons' => '<p>If the <code>botStatus</code> is <code>Failed</code>, this contains a list of reasons that the bot couldn\'t be built.</p>', 'DescribeBotVersionResponse$failureReasons' => '<p>If the <code>botStatus</code> is <code>Failed</code>, this contains a list of reasons that the version couldn\'t be built.</p>', 'DescribeExportResponse$failureReasons' => '<p>If the <code>exportStatus</code> is failed, contains one or more reasons why the export could not be completed.</p>', 'DescribeImportResponse$failureReasons' => '<p>If the <code>importStatus</code> field is <code>Failed</code>, this provides one or more reasons for the failure.</p>', 'DescribeTestExecutionResponse$failureReasons' => '<p>Reasons for the failure of the test set execution.</p>', 'DescribeTestSetDiscrepancyReportResponse$failureReasons' => '<p>The failure report for the test set discrepancy report generation action.</p>', 'DescribeTestSetGenerationResponse$failureReasons' => '<p>The reasons the test set generation failed.</p>', 'UpdateBotLocaleResponse$failureReasons' => '<p>If the <code>botLocaleStatus</code> is <code>Failed</code>, the <code>failureReasons</code> field lists the errors that occurred while building the bot.</p>', ], ], 'FilePassword' => [ 'base' => NULL, 'refs' => [ 'EncryptionSetting$botLocaleExportPassword' => '<p>The password used to encrypt the recommended bot recommendation file.</p>', 'EncryptionSetting$associatedTranscriptsPassword' => '<p>The password used to encrypt the associated transcript file.</p>', ], ], 'FilterValue' => [ 'base' => NULL, 'refs' => [ 'FilterValues$member' => NULL, ], ], 'FilterValues' => [ 'base' => NULL, 'refs' => [ 'AggregatedUtterancesFilter$values' => '<p>The value to use for filtering the list of bots.</p>', 'AssociatedTranscriptFilter$values' => '<p>The values to use to filter the transcript.</p>', 'BotFilter$values' => '<p>The value to use for filtering the list of bots.</p>', 'BotLocaleFilter$values' => '<p>The value to use for filtering the list of bots.</p>', 'ExportFilter$values' => '<p>The values to use to filter the response. The values must be <code>Bot</code>, <code>BotLocale</code>, or <code>CustomVocabulary</code>.</p>', 'ImportFilter$values' => '<p>The values to use to filter the response. The values must be <code>Bot</code>, <code>BotLocale</code>, or <code>CustomVocabulary</code>.</p>', 'IntentFilter$values' => '<p>The value to use for the filter.</p>', 'SlotFilter$values' => '<p>The value to use to filter the response.</p>', 'SlotTypeFilter$values' => '<p>The value to use to filter the response.</p>', ], ], 'FulfillmentCodeHookSettings' => [ 'base' => '<p>Determines if a Lambda function should be invoked for a specific intent.</p>', 'refs' => [ 'CreateIntentRequest$fulfillmentCodeHook' => '<p>Specifies that Amazon Lex invokes the alias Lambda function when the intent is ready for fulfillment. You can invoke this function to complete the bot\'s transaction with the user.</p> <p>For example, in a pizza ordering bot, the Lambda function can look up the closest pizza restaurant to the customer\'s location and then place an order on the customer\'s behalf.</p>', 'CreateIntentResponse$fulfillmentCodeHook' => '<p>The fulfillment Lambda function specified for the intent.</p>', 'DescribeIntentResponse$fulfillmentCodeHook' => '<p>The Lambda function called when the intent is complete and ready for fulfillment.</p>', 'UpdateIntentRequest$fulfillmentCodeHook' => '<p>The new Lambda function to call when all of the intents required slots are provided and the intent is ready for fulfillment.</p>', 'UpdateIntentResponse$fulfillmentCodeHook' => '<p>The updated Lambda function called when the intent is ready for fulfillment.</p>', ], ], 'FulfillmentStartResponseDelay' => [ 'base' => NULL, 'refs' => [ 'FulfillmentStartResponseSpecification$delayInSeconds' => '<p>The delay between when the Lambda fulfillment function starts running and the start message is played. If the Lambda function returns before the delay is over, the start message isn\'t played.</p>', ], ], 'FulfillmentStartResponseSpecification' => [ 'base' => '<p>Provides settings for a message that is sent to the user when a fulfillment Lambda function starts running.</p>', 'refs' => [ 'FulfillmentUpdatesSpecification$startResponse' => '<p>Provides configuration information for the message sent to users when the fulfillment Lambda functions starts running.</p>', ], ], 'FulfillmentTimeout' => [ 'base' => NULL, 'refs' => [ 'FulfillmentUpdatesSpecification$timeoutInSeconds' => '<p>The length of time that the fulfillment Lambda function should run before it times out.</p>', ], ], 'FulfillmentUpdateResponseFrequency' => [ 'base' => NULL, 'refs' => [ 'FulfillmentUpdateResponseSpecification$frequencyInSeconds' => '<p>The frequency that a message is sent to the user. When the period ends, Amazon Lex chooses a message from the message groups and plays it to the user. If the fulfillment Lambda returns before the first period ends, an update message is not played to the user.</p>', ], ], 'FulfillmentUpdateResponseSpecification' => [ 'base' => '<p>Provides settings for a message that is sent periodically to the user while a fulfillment Lambda function is running.</p>', 'refs' => [ 'FulfillmentUpdatesSpecification$updateResponse' => '<p>Provides configuration information for messages sent periodically to the user while the fulfillment Lambda function is running.</p>', ], ], 'FulfillmentUpdatesSpecification' => [ 'base' => '<p>Provides information for updating the user on the progress of fulfilling an intent.</p>', 'refs' => [ 'FulfillmentCodeHookSettings$fulfillmentUpdatesSpecification' => '<p>Provides settings for update messages sent to the user for long-running Lambda fulfillment functions. Fulfillment updates can be used only with streaming conversations.</p>', ], ], 'GenerateBotElementRequest' => [ 'base' => NULL, 'refs' => [], ], 'GenerateBotElementResponse' => [ 'base' => NULL, 'refs' => [], ], 'GenerationInput' => [ 'base' => NULL, 'refs' => [ 'DescribeBotResourceGenerationResponse$generationInputPrompt' => '<p>The prompt used in the generation request.</p>', 'StartBotResourceGenerationRequest$generationInputPrompt' => '<p>The prompt to generate intents and slot types for the bot locale. Your description should be both <i>detailed</i> and <i>precise</i> to help generate appropriate and sufficient intents for your bot. Include a list of actions to improve the intent creation process.</p>', 'StartBotResourceGenerationResponse$generationInputPrompt' => '<p>The prompt that was used generate intents and slot types for the bot locale.</p>', ], ], 'GenerationSortBy' => [ 'base' => '<p>Specifies the attribute and method by which to sort the generation request information.</p>', 'refs' => [ 'ListBotResourceGenerationsRequest$sortBy' => '<p>An object containing information about the attribute and the method by which to sort the results</p>', ], ], 'GenerationSortByAttribute' => [ 'base' => NULL, 'refs' => [ 'GenerationSortBy$attribute' => '<p>The attribute by which to sort the generation request information. You can sort by the following attributes.</p> <ul> <li> <p> <code>creationStartTime</code> – The time at which the generation request was created.</p> </li> <li> <p> <code>lastUpdatedTime</code> – The time at which the generation request was last updated.</p> </li> </ul>', ], ], 'GenerationStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeBotResourceGenerationResponse$generationStatus' => '<p>The status of the generation request.</p>', 'GenerationSummary$generationStatus' => '<p>The status of the generation request.</p>', 'StartBotResourceGenerationResponse$generationStatus' => '<p>The status of the generation request.</p>', ], ], 'GenerationSummary' => [ 'base' => '<p>Contains information about a generation request made for the bot locale.</p>', 'refs' => [ 'GenerationSummaryList$member' => NULL, ], ], 'GenerationSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListBotResourceGenerationsResponse$generationSummaries' => '<p>A list of objects, each containing information about a generation request for the bot locale.</p>', ], ], 'GenerativeAISettings' => [ 'base' => '<p>Contains specifications about the generative AI capabilities from Amazon Bedrock that you can turn on for your bot.</p>', 'refs' => [ 'CreateBotLocaleRequest$generativeAISettings' => NULL, 'CreateBotLocaleResponse$generativeAISettings' => NULL, 'DescribeBotLocaleResponse$generativeAISettings' => '<p>Contains settings for Amazon Bedrock\'s generative AI features for your bot locale.</p>', 'UpdateBotLocaleRequest$generativeAISettings' => '<p>Contains settings for generative AI features powered by Amazon Bedrock for your bot locale. Use this object to turn generative AI features on and off. Pricing may differ if you turn a feature on. For more information, see LINK.</p>', 'UpdateBotLocaleResponse$generativeAISettings' => '<p>Contains settings for generative AI features powered by Amazon Bedrock for your bot locale.</p>', ], ], 'GetTestExecutionArtifactsUrlRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetTestExecutionArtifactsUrlResponse' => [ 'base' => NULL, 'refs' => [], ], 'GrammarSlotTypeSetting' => [ 'base' => '<p>Settings requried for a slot type based on a grammar that you provide.</p>', 'refs' => [ 'ExternalSourceSetting$grammarSlotTypeSetting' => '<p>Settings required for a slot type based on a grammar that you provide.</p>', ], ], 'GrammarSlotTypeSource' => [ 'base' => '<p>Describes the Amazon S3 bucket name and location for the grammar that is the source for the slot type.</p>', 'refs' => [ 'GrammarSlotTypeSetting$source' => '<p>The source of the grammar used to create the slot type.</p>', ], ], 'HitCount' => [ 'base' => NULL, 'refs' => [ 'AggregatedUtterancesSummary$hitCount' => '<p>The number of times that the utterance was detected by Amazon Lex during the time period. When an utterance is detected, it activates an intent or a slot.</p>', ], ], 'Id' => [ 'base' => NULL, 'refs' => [ 'BatchCreateCustomVocabularyItemRequest$botId' => '<p>The identifier of the bot associated with this custom vocabulary.</p>', 'BatchCreateCustomVocabularyItemResponse$botId' => '<p>The identifier of the bot associated with this custom vocabulary.</p>', 'BatchDeleteCustomVocabularyItemRequest$botId' => '<p>The identifier of the bot associated with this custom vocabulary.</p>', 'BatchDeleteCustomVocabularyItemResponse$botId' => '<p>The identifier of the bot associated with this custom vocabulary.</p>', 'BatchUpdateCustomVocabularyItemRequest$botId' => '<p>The identifier of the bot associated with this custom vocabulary</p>', 'BatchUpdateCustomVocabularyItemResponse$botId' => '<p>The identifier of the bot associated with this custom vocabulary.</p>', 'BotAliasTestExecutionTarget$botId' => '<p>The bot Id of the bot alias used in the test set execution.</p>', 'BotExportSpecification$botId' => '<p>The identifier of the bot assigned by Amazon Lex.</p>', 'BotLocaleExportSpecification$botId' => '<p>The identifier of the bot to create the locale for.</p>', 'BotLocaleImportSpecification$botId' => '<p>The identifier of the bot to import the locale to.</p>', 'BotMember$botMemberId' => '<p>The unique ID of a bot that is a member of this network of bots.</p>', 'BotRecommendationSummary$botRecommendationId' => '<p>The unique identifier of the bot recommendation to be updated.</p>', 'BotSummary$botId' => '<p>The unique identifier assigned to the bot. Use this ID to get detailed information about the bot with the <a href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DescribeBot.html">DescribeBot</a> operation.</p>', 'BuildBotLocaleRequest$botId' => '<p>The identifier of the bot to build. The identifier is returned in the response from the <a href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_CreateBot.html">CreateBot</a> operation.</p>', 'BuildBotLocaleResponse$botId' => '<p>The identifier of the specified bot.</p>', 'ConversationLogsDataSource$botId' => '<p>The bot Id from the conversation logs.</p>', 'CreateBotAliasRequest$botId' => '<p>The unique identifier of the bot that the alias applies to.</p>', 'CreateBotAliasResponse$botId' => '<p>The unique identifier of the bot that this alias applies to.</p>', 'CreateBotLocaleRequest$botId' => '<p>The identifier of the bot to create the locale for.</p>', 'CreateBotLocaleResponse$botId' => '<p>The specified bot identifier.</p>', 'CreateBotReplicaRequest$botId' => '<p>The request for the unique bot ID of the source bot to be replicated in the secondary region.</p>', 'CreateBotReplicaResponse$botId' => '<p>The unique bot ID of the replicated bot generated.</p>', 'CreateBotResponse$botId' => '<p>A unique identifier for a particular bot. You use this to identify the bot when you call other Amazon Lex API operations.</p>', 'CreateBotVersionRequest$botId' => '<p>The identifier of the bot to create the version for.</p>', 'CreateBotVersionResponse$botId' => '<p>The bot identifier specified in the request.</p>', 'CreateExportResponse$exportId' => '<p>An identifier for a specific request to create an export.</p>', 'CreateIntentRequest$botId' => '<p>The identifier of the bot associated with this intent.</p>', 'CreateIntentResponse$intentId' => '<p>A unique identifier for the intent.</p>', 'CreateIntentResponse$botId' => '<p>The identifier of the bot associated with the intent.</p>', 'CreateSlotRequest$botId' => '<p>The identifier of the bot associated with the slot.</p>', 'CreateSlotRequest$intentId' => '<p>The identifier of the intent that contains the slot.</p>', 'CreateSlotResponse$slotId' => '<p>The unique identifier associated with the slot. Use this to identify the slot when you update or delete it.</p>', 'CreateSlotResponse$botId' => '<p>The unique identifier of the bot associated with the slot.</p>', 'CreateSlotResponse$intentId' => '<p>The unique identifier of the intent associated with the slot.</p>', 'CreateSlotTypeRequest$botId' => '<p>The identifier of the bot associated with this slot type.</p>', 'CreateSlotTypeResponse$slotTypeId' => '<p>The unique identifier assigned to the slot type. Use this to identify the slot type in the <code>UpdateSlotType</code> and <code>DeleteSlotType</code> operations.</p>', 'CreateSlotTypeResponse$botId' => '<p>The identifier for the bot associated with the slot type.</p>', 'CreateTestSetDiscrepancyReportRequest$testSetId' => '<p>The test set Id for the test set discrepancy report.</p>', 'CreateTestSetDiscrepancyReportResponse$testSetDiscrepancyReportId' => '<p>The unique identifier of the test set discrepancy report to describe.</p>', 'CreateTestSetDiscrepancyReportResponse$testSetId' => '<p>The test set Id for the test set discrepancy report.</p>', 'CreateUploadUrlResponse$importId' => '<p>An identifier for a unique import job. Use it when you call the <a href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_StartImport.html">StartImport</a> operation.</p>', 'CustomVocabularyExportSpecification$botId' => '<p>The identifier of the bot that contains the custom vocabulary to export.</p>', 'CustomVocabularyImportSpecification$botId' => '<p>The identifier of the bot to import the custom vocabulary to.</p>', 'DeleteBotAliasRequest$botId' => '<p>The unique identifier of the bot associated with the alias to delete.</p>', 'DeleteBotAliasResponse$botId' => '<p>The unique identifier of the bot that contains the alias to delete.</p>', 'DeleteBotLocaleRequest$botId' => '<p>The unique identifier of the bot that contains the locale.</p>', 'DeleteBotLocaleResponse$botId' => '<p>The identifier of the bot that contained the deleted locale.</p>', 'DeleteBotReplicaRequest$botId' => '<p>The unique ID of the replicated bot to be deleted from the secondary region</p>', 'DeleteBotReplicaResponse$botId' => '<p>The unique bot ID of the replicated bot generated.</p>', 'DeleteBotRequest$botId' => '<p>The identifier of the bot to delete. </p>', 'DeleteBotResponse$botId' => '<p>The unique identifier of the bot that Amazon Lex is deleting.</p>', 'DeleteBotVersionRequest$botId' => '<p>The identifier of the bot that contains the version.</p>', 'DeleteBotVersionResponse$botId' => '<p>The identifier of the bot that is being deleted.</p>', 'DeleteCustomVocabularyRequest$botId' => '<p>The unique identifier of the bot to remove the custom vocabulary from.</p>', 'DeleteCustomVocabularyResponse$botId' => '<p>The identifier of the bot that the custom vocabulary was removed from.</p>', 'DeleteExportRequest$exportId' => '<p>The unique identifier of the export to delete.</p>', 'DeleteExportResponse$exportId' => '<p>The unique identifier of the deleted export.</p>', 'DeleteImportRequest$importId' => '<p>The unique identifier of the import to delete.</p>', 'DeleteImportResponse$importId' => '<p>The unique identifier of the deleted import.</p>', 'DeleteIntentRequest$intentId' => '<p>The unique identifier of the intent to delete.</p>', 'DeleteIntentRequest$botId' => '<p>The identifier of the bot associated with the intent.</p>', 'DeleteSlotRequest$slotId' => '<p>The identifier of the slot to delete. </p>', 'DeleteSlotRequest$botId' => '<p>The identifier of the bot associated with the slot to delete.</p>', 'DeleteSlotRequest$intentId' => '<p>The identifier of the intent associated with the slot.</p>', 'DeleteSlotTypeRequest$slotTypeId' => '<p>The identifier of the slot type to delete.</p>', 'DeleteSlotTypeRequest$botId' => '<p>The identifier of the bot associated with the slot type.</p>', 'DeleteTestSetRequest$testSetId' => '<p>The test set Id of the test set to be deleted.</p>', 'DeleteUtterancesRequest$botId' => '<p>The unique identifier of the bot that contains the utterances.</p>', 'DescribeBotAliasRequest$botId' => '<p>The identifier of the bot associated with the bot alias to describe.</p>', 'DescribeBotAliasResponse$botId' => '<p>The identifier of the bot associated with the bot alias.</p>', 'DescribeBotLocaleRequest$botId' => '<p>The identifier of the bot associated with the locale.</p>', 'DescribeBotLocaleResponse$botId' => '<p>The identifier of the bot associated with the locale.</p>', 'DescribeBotRecommendationRequest$botId' => '<p>The unique identifier of the bot associated with the bot recommendation.</p>', 'DescribeBotRecommendationRequest$botRecommendationId' => '<p>The identifier of the bot recommendation to describe.</p>', 'DescribeBotRecommendationResponse$botId' => '<p>The identifier of the bot associated with the bot recommendation.</p>', 'DescribeBotRecommendationResponse$botRecommendationId' => '<p>The identifier of the bot recommendation being described.</p>', 'DescribeBotReplicaRequest$botId' => '<p>The request for the unique bot ID of the replicated bot being monitored.</p>', 'DescribeBotReplicaResponse$botId' => '<p>The unique bot ID of the replicated bot being monitored.</p>', 'DescribeBotRequest$botId' => '<p>The unique identifier of the bot to describe.</p>', 'DescribeBotResourceGenerationRequest$botId' => '<p>The unique identifier of the bot for which to return the generation details.</p>', 'DescribeBotResourceGenerationRequest$generationId' => '<p>The unique identifier of the generation request for which to return the generation details.</p>', 'DescribeBotResourceGenerationResponse$botId' => '<p>The unique identifier of the bot for which the generation request was made.</p>', 'DescribeBotResourceGenerationResponse$generationId' => '<p>The generation ID for which to return the generation details.</p>', 'DescribeBotResponse$botId' => '<p>The unique identifier of the bot.</p>', 'DescribeBotVersionRequest$botId' => '<p>The identifier of the bot containing the version to return metadata for.</p>', 'DescribeBotVersionResponse$botId' => '<p>The identifier of the bot that contains the version.</p>', 'DescribeCustomVocabularyMetadataRequest$botId' => '<p>The unique identifier of the bot that contains the custom vocabulary.</p>', 'DescribeCustomVocabularyMetadataResponse$botId' => '<p>The identifier of the bot that contains the custom vocabulary.</p>', 'DescribeExportRequest$exportId' => '<p>The unique identifier of the export to describe.</p>', 'DescribeExportResponse$exportId' => '<p>The unique identifier of the described export.</p>', 'DescribeImportRequest$importId' => '<p>The unique identifier of the import to describe.</p>', 'DescribeImportResponse$importId' => '<p>The unique identifier of the described import.</p>', 'DescribeIntentRequest$intentId' => '<p>The identifier of the intent to describe.</p>', 'DescribeIntentRequest$botId' => '<p>The identifier of the bot associated with the intent.</p>', 'DescribeIntentResponse$intentId' => '<p>The unique identifier assigned to the intent when it was created.</p>', 'DescribeIntentResponse$botId' => '<p>The identifier of the bot associated with the intent.</p>', 'DescribeSlotRequest$slotId' => '<p>The unique identifier for the slot.</p>', 'DescribeSlotRequest$botId' => '<p>The identifier of the bot associated with the slot.</p>', 'DescribeSlotRequest$intentId' => '<p>The identifier of the intent that contains the slot.</p>', 'DescribeSlotResponse$slotId' => '<p>The unique identifier generated for the slot.</p>', 'DescribeSlotResponse$botId' => '<p>The identifier of the bot associated with the slot.</p>', 'DescribeSlotResponse$intentId' => '<p>The identifier of the intent associated with the slot.</p>', 'DescribeSlotTypeRequest$slotTypeId' => '<p>The identifier of the slot type.</p>', 'DescribeSlotTypeRequest$botId' => '<p>The identifier of the bot associated with the slot type.</p>', 'DescribeSlotTypeResponse$slotTypeId' => '<p>The unique identifier for the slot type.</p>', 'DescribeSlotTypeResponse$botId' => '<p>The identifier of the bot associated with the slot type.</p>', 'DescribeTestExecutionRequest$testExecutionId' => '<p>The execution Id of the test set execution.</p>', 'DescribeTestExecutionResponse$testExecutionId' => '<p>The execution Id for the test set execution.</p>', 'DescribeTestExecutionResponse$testSetId' => '<p>The test set Id for the test set execution.</p>', 'DescribeTestSetDiscrepancyReportRequest$testSetDiscrepancyReportId' => '<p>The unique identifier of the test set discrepancy report.</p>', 'DescribeTestSetDiscrepancyReportResponse$testSetDiscrepancyReportId' => '<p>The unique identifier of the test set discrepancy report to describe.</p>', 'DescribeTestSetDiscrepancyReportResponse$testSetId' => '<p>The test set Id for the test set discrepancy report.</p>', 'DescribeTestSetGenerationRequest$testSetGenerationId' => '<p>The unique identifier of the test set generation.</p>', 'DescribeTestSetGenerationResponse$testSetGenerationId' => '<p>The unique identifier of the test set generation.</p>', 'DescribeTestSetGenerationResponse$testSetId' => '<p>The unique identifier for the test set created for the generated test set.</p>', 'DescribeTestSetRequest$testSetId' => '<p>The test set Id for the test set request.</p>', 'DescribeTestSetResponse$testSetId' => '<p>The test set Id for the test set response.</p>', 'ExportSummary$exportId' => '<p>The unique identifier that Amazon Lex assigned to the export.</p>', 'GenerateBotElementRequest$intentId' => '<p>The intent unique Id for the bot request to generate utterances.</p>', 'GenerateBotElementRequest$botId' => '<p>The bot unique Id for the bot request to generate utterances.</p>', 'GenerateBotElementResponse$botId' => '<p>The unique bot Id for the bot which received the response.</p>', 'GenerateBotElementResponse$intentId' => '<p>The unique intent Id for the bot which received the response.</p>', 'GenerationSummary$generationId' => '<p>The unique identifier of the generation request.</p>', 'GetTestExecutionArtifactsUrlRequest$testExecutionId' => '<p>The unique identifier of the completed test execution.</p>', 'GetTestExecutionArtifactsUrlResponse$testExecutionId' => '<p>The unique identifier of the completed test execution.</p>', 'ImportSummary$importId' => '<p>The unique identifier that Amazon Lex assigned to the import.</p>', 'IntentSummary$intentId' => '<p>The unique identifier assigned to the intent. Use this ID to get detailed information about the intent with the <code>DescribeIntent</code> operation.</p>', 'ListAggregatedUtterancesRequest$botId' => '<p>The unique identifier of the bot associated with this request.</p>', 'ListAggregatedUtterancesResponse$botId' => '<p>The identifier of the bot that contains the utterances.</p>', 'ListBotAliasReplicasRequest$botId' => '<p>The request for the unique bot ID of the replicated bot created from the source bot alias.</p>', 'ListBotAliasReplicasResponse$botId' => '<p>The unique bot ID of the replicated bot created from the source bot alias.</p>', 'ListBotAliasesRequest$botId' => '<p>The identifier of the bot to list aliases for.</p>', 'ListBotAliasesResponse$botId' => '<p>The identifier of the bot associated with the aliases.</p>', 'ListBotLocalesRequest$botId' => '<p>The identifier of the bot to list locales for.</p>', 'ListBotLocalesResponse$botId' => '<p>The identifier of the bot to list locales for.</p>', 'ListBotRecommendationsRequest$botId' => '<p>The unique identifier of the bot that contains the bot recommendation list.</p>', 'ListBotRecommendationsResponse$botId' => '<p>The unique identifier of the bot that contains the bot recommendation list.</p>', 'ListBotReplicasRequest$botId' => '<p>The request for the unique bot IDs in the list of replicated bots.</p>', 'ListBotReplicasResponse$botId' => '<p>the unique bot IDs in the list of replicated bots.</p>', 'ListBotResourceGenerationsRequest$botId' => '<p>The unique identifier of the bot whose generation requests you want to view.</p>', 'ListBotResourceGenerationsResponse$botId' => '<p>The unique identifier of the bot for which the generation requests were made.</p>', 'ListBotVersionReplicasRequest$botId' => '<p>The request for the unique ID in the list of replicated bots.</p>', 'ListBotVersionReplicasResponse$botId' => '<p>The unique ID of the bots in the list of replicated bots.</p>', 'ListBotVersionsRequest$botId' => '<p>The identifier of the bot to list versions for.</p>', 'ListBotVersionsResponse$botId' => '<p>The identifier of the bot to list versions for.</p>', 'ListCustomVocabularyItemsRequest$botId' => '<p>The identifier of the version of the bot associated with this custom vocabulary.</p>', 'ListCustomVocabularyItemsResponse$botId' => '<p>The identifier of the bot associated with this custom vocabulary.</p>', 'ListExportsRequest$botId' => '<p>The unique identifier that Amazon Lex assigned to the bot.</p>', 'ListExportsResponse$botId' => '<p>The unique identifier assigned to the bot by Amazon Lex.</p>', 'ListImportsRequest$botId' => '<p>The unique identifier that Amazon Lex assigned to the bot.</p>', 'ListImportsResponse$botId' => '<p>The unique identifier assigned by Amazon Lex to the bot.</p>', 'ListIntentMetricsRequest$botId' => '<p>The identifier for the bot for which you want to retrieve intent metrics.</p>', 'ListIntentMetricsResponse$botId' => '<p>The identifier for the bot for which you retrieved intent metrics.</p>', 'ListIntentPathsRequest$botId' => '<p>The identifier for the bot for which you want to retrieve intent path metrics.</p>', 'ListIntentStageMetricsRequest$botId' => '<p>The identifier for the bot for which you want to retrieve intent stage metrics.</p>', 'ListIntentStageMetricsResponse$botId' => '<p>The identifier for the bot for which you retrieved intent stage metrics.</p>', 'ListIntentsRequest$botId' => '<p>The unique identifier of the bot that contains the intent.</p>', 'ListIntentsResponse$botId' => '<p>The identifier of the bot that contains the intent.</p>', 'ListRecommendedIntentsRequest$botId' => '<p>The unique identifier of the bot associated with the recommended intents.</p>', 'ListRecommendedIntentsRequest$botRecommendationId' => '<p>The identifier of the bot recommendation that contains the recommended intents.</p>', 'ListRecommendedIntentsResponse$botId' => '<p>The unique identifier of the bot associated with the recommended intent.</p>', 'ListRecommendedIntentsResponse$botRecommendationId' => '<p>The identifier of the bot recommendation that contains the recommended intent.</p>', 'ListSessionAnalyticsDataRequest$botId' => '<p>The identifier for the bot for which you want to retrieve session analytics.</p>', 'ListSessionAnalyticsDataResponse$botId' => '<p>The unique identifier of the bot that the sessions belong to.</p>', 'ListSessionMetricsRequest$botId' => '<p>The identifier for the bot for which you want to retrieve session metrics.</p>', 'ListSessionMetricsResponse$botId' => '<p>The identifier for the bot for which you retrieved session metrics.</p>', 'ListSlotTypesRequest$botId' => '<p>The unique identifier of the bot that contains the slot types.</p>', 'ListSlotTypesResponse$botId' => '<p>The identifier of the bot that contains the slot types.</p>', 'ListSlotsRequest$botId' => '<p>The identifier of the bot that contains the slot.</p>', 'ListSlotsRequest$intentId' => '<p>The unique identifier of the intent that contains the slot.</p>', 'ListSlotsResponse$botId' => '<p>The identifier of the bot that contains the slots.</p>', 'ListSlotsResponse$intentId' => '<p>The identifier of the intent that contains the slots.</p>', 'ListTestExecutionResultItemsRequest$testExecutionId' => '<p>The unique identifier of the test execution to list the result items.</p>', 'ListTestSetRecordsRequest$testSetId' => '<p>The identifier of the test set to list its test set records.</p>', 'ListUtteranceAnalyticsDataRequest$botId' => '<p>The identifier for the bot for which you want to retrieve utterance analytics.</p>', 'ListUtteranceAnalyticsDataResponse$botId' => '<p>The unique identifier of the bot that the utterances belong to.</p>', 'ListUtteranceMetricsRequest$botId' => '<p>The identifier for the bot for which you want to retrieve utterance metrics.</p>', 'ListUtteranceMetricsResponse$botId' => '<p>The identifier for the bot for which you retrieved utterance metrics.</p>', 'ParentBotNetwork$botId' => '<p>The identifier of the network of bots assigned by Amazon Lex.</p>', 'RecommendedIntentSummary$intentId' => '<p>The unique identifier of a recommended intent associated with the bot recommendation.</p>', 'SearchAssociatedTranscriptsRequest$botId' => '<p>The unique identifier of the bot associated with the transcripts that you are searching.</p>', 'SearchAssociatedTranscriptsRequest$botRecommendationId' => '<p>The unique identifier of the bot recommendation associated with the transcripts to search.</p>', 'SearchAssociatedTranscriptsResponse$botId' => '<p>The unique identifier of the bot associated with the transcripts that you are searching.</p>', 'SearchAssociatedTranscriptsResponse$botRecommendationId' => '<p> The unique identifier of the bot recommendation associated with the transcripts to search.</p>', 'SlotPriority$slotId' => '<p>The unique identifier of the slot.</p>', 'SlotSummary$slotId' => '<p>The unique identifier of the slot.</p>', 'SlotTypeSummary$slotTypeId' => '<p>The unique identifier assigned to the slot type.</p>', 'StartBotRecommendationRequest$botId' => '<p>The unique identifier of the bot containing the bot recommendation.</p>', 'StartBotRecommendationResponse$botId' => '<p>The unique identifier of the bot containing the bot recommendation.</p>', 'StartBotRecommendationResponse$botRecommendationId' => '<p>The identifier of the bot recommendation that you have created.</p>', 'StartBotResourceGenerationRequest$botId' => '<p>The unique identifier of the bot for which to generate intents and slot types.</p>', 'StartBotResourceGenerationResponse$generationId' => '<p>The unique identifier of the generation request.</p>', 'StartBotResourceGenerationResponse$botId' => '<p>The unique identifier of the bot for which the generation request was made.</p>', 'StartImportRequest$importId' => '<p>The unique identifier for the import. It is included in the response from the <a href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_CreateUploadUrl.html">CreateUploadUrl</a> operation.</p>', 'StartImportResponse$importId' => '<p>A unique identifier for the import.</p>', 'StartTestExecutionRequest$testSetId' => '<p>The test set Id for the test set execution.</p>', 'StartTestExecutionResponse$testExecutionId' => '<p>The unique identifier of the test set execution.</p>', 'StartTestExecutionResponse$testSetId' => '<p>The test set Id for the test set execution.</p>', 'StartTestSetGenerationResponse$testSetGenerationId' => '<p>The unique identifier of the test set generation to describe.</p>', 'StopBotRecommendationRequest$botId' => '<p>The unique identifier of the bot containing the bot recommendation to be stopped.</p>', 'StopBotRecommendationRequest$botRecommendationId' => '<p>The unique identifier of the bot recommendation to be stopped.</p>', 'StopBotRecommendationResponse$botId' => '<p>The unique identifier of the bot containing the bot recommendation that is being stopped.</p>', 'StopBotRecommendationResponse$botRecommendationId' => '<p>The unique identifier of the bot recommendation that is being stopped.</p>', 'TestExecutionSummary$testExecutionId' => '<p>The unique identifier of the test execution.</p>', 'TestExecutionSummary$testSetId' => '<p>The unique identifier of the test set used in the test execution.</p>', 'TestSetDiscrepancyReportBotAliasTarget$botId' => '<p>The unique identifier for the bot alias.</p>', 'TestSetExportSpecification$testSetId' => '<p>The unique identifier of the test set.</p>', 'TestSetSummary$testSetId' => '<p>The unique identifier of the test set.</p>', 'UpdateBotAliasRequest$botId' => '<p>The identifier of the bot with the updated alias.</p>', 'UpdateBotAliasResponse$botId' => '<p>The identifier of the bot with the updated alias.</p>', 'UpdateBotLocaleRequest$botId' => '<p>The unique identifier of the bot that contains the locale.</p>', 'UpdateBotLocaleResponse$botId' => '<p>The identifier of the bot that contains the updated locale.</p>', 'UpdateBotRecommendationRequest$botId' => '<p>The unique identifier of the bot containing the bot recommendation to be updated.</p>', 'UpdateBotRecommendationRequest$botRecommendationId' => '<p>The unique identifier of the bot recommendation to be updated.</p>', 'UpdateBotRecommendationResponse$botId' => '<p>The unique identifier of the bot containing the bot recommendation that has been updated.</p>', 'UpdateBotRecommendationResponse$botRecommendationId' => '<p>The unique identifier of the bot recommendation to be updated.</p>', 'UpdateBotRequest$botId' => '<p>The unique identifier of the bot to update. This identifier is returned by the <a href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_CreateBot.html">CreateBot</a> operation.</p>', 'UpdateBotResponse$botId' => '<p>The unique identifier of the bot that was updated.</p>', 'UpdateExportRequest$exportId' => '<p>The unique identifier Amazon Lex assigned to the export.</p>', 'UpdateExportResponse$exportId' => '<p>The unique identifier Amazon Lex assigned to the export.</p>', 'UpdateIntentRequest$intentId' => '<p>The unique identifier of the intent to update.</p>', 'UpdateIntentRequest$botId' => '<p>The identifier of the bot that contains the intent.</p>', 'UpdateIntentResponse$intentId' => '<p>The identifier of the intent that was updated.</p>', 'UpdateIntentResponse$botId' => '<p>The identifier of the bot that contains the intent.</p>', 'UpdateSlotRequest$slotId' => '<p>The unique identifier for the slot to update.</p>', 'UpdateSlotRequest$botId' => '<p>The unique identifier of the bot that contains the slot.</p>', 'UpdateSlotRequest$intentId' => '<p>The identifier of the intent that contains the slot.</p>', 'UpdateSlotResponse$slotId' => '<p>The unique identifier of the slot that was updated.</p>', 'UpdateSlotResponse$botId' => '<p>The identifier of the bot that contains the slot.</p>', 'UpdateSlotResponse$intentId' => '<p>The intent that contains the slot.</p>', 'UpdateSlotTypeRequest$slotTypeId' => '<p>The unique identifier of the slot type to update.</p>', 'UpdateSlotTypeRequest$botId' => '<p>The identifier of the bot that contains the slot type.</p>', 'UpdateSlotTypeResponse$slotTypeId' => '<p>The unique identifier of the updated slot type.</p>', 'UpdateSlotTypeResponse$botId' => '<p>The identifier of the bot that contains the slot type.</p>', 'UpdateTestSetRequest$testSetId' => '<p>The test set Id for which update test operation to be performed.</p>', 'UpdateTestSetResponse$testSetId' => '<p>The test set Id for which update test operation to be performed.</p>', 'UtteranceSpecification$utteranceRequestId' => '<p>The identifier of the request associated with the utterance.</p>', ], ], 'ImageResponseCard' => [ 'base' => '<p>A card that is shown to the user by a messaging platform. You define the contents of the card, the card is displayed by the platform. </p> <p>When you use a response card, the response from the user is constrained to the text associated with a button on the card.</p>', 'refs' => [ 'Message$imageResponseCard' => '<p>A message that defines a response card that the client application can show to the user.</p>', 'UtteranceBotResponse$imageResponseCard' => NULL, ], ], 'ImportExportFileFormat' => [ 'base' => NULL, 'refs' => [ 'CreateExportRequest$fileFormat' => '<p>The file format of the bot or bot locale definition files.</p>', 'CreateExportResponse$fileFormat' => '<p>The file format used for the bot or bot locale definition files.</p>', 'DescribeExportResponse$fileFormat' => '<p>The file format used in the files that describe the resource. </p>', 'ExportSummary$fileFormat' => '<p>The file format used in the export files.</p>', 'UpdateExportResponse$fileFormat' => '<p>The file format used for the files that define the resource. The <code>TSV</code> format is required to export a custom vocabulary only; otherwise use <code>LexJson</code> format.</p>', ], ], 'ImportExportFilePassword' => [ 'base' => NULL, 'refs' => [ 'CreateExportRequest$filePassword' => '<p>An password to use to encrypt the exported archive. Using a password is optional, but you should encrypt the archive to protect the data in transit between Amazon Lex and your local computer.</p>', 'StartImportRequest$filePassword' => '<p>The password used to encrypt the zip archive that contains the resource definition. You should always encrypt the zip archive to protect it during transit between your site and Amazon Lex.</p>', 'UpdateExportRequest$filePassword' => '<p>The new password to use to encrypt the export zip archive.</p>', ], ], 'ImportFilter' => [ 'base' => '<p>Filters the response from the <a href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListImports.html">ListImports</a> operation.</p>', 'refs' => [ 'ImportFilters$member' => NULL, ], ], 'ImportFilterName' => [ 'base' => NULL, 'refs' => [ 'ImportFilter$name' => '<p>The name of the field to use for filtering.</p>', ], ], 'ImportFilterOperator' => [ 'base' => NULL, 'refs' => [ 'ImportFilter$operator' => '<p>The operator to use for the filter. Specify EQ when the <code>ListImports</code> operation should return only resource types that equal the specified value. Specify CO when the <code>ListImports</code> operation should return resource types that contain the specified value.</p>', ], ], 'ImportFilters' => [ 'base' => NULL, 'refs' => [ 'ListImportsRequest$filters' => '<p>Provides the specification of a filter used to limit the bots in the response to only those that match the filter specification. You can only specify one filter and one string to filter on.</p>', ], ], 'ImportResourceSpecification' => [ 'base' => '<p>Provides information about the bot or bot locale that you want to import. You can specify the <code>botImportSpecification</code> or the <code>botLocaleImportSpecification</code>, but not both.</p>', 'refs' => [ 'DescribeImportResponse$resourceSpecification' => '<p>The specifications of the imported bot, bot locale, or custom vocabulary.</p>', 'StartImportRequest$resourceSpecification' => '<p>Parameters for creating the bot, bot locale or custom vocabulary.</p>', 'StartImportResponse$resourceSpecification' => '<p>The parameters used when importing the resource.</p>', ], ], 'ImportResourceType' => [ 'base' => NULL, 'refs' => [ 'ImportSummary$importedResourceType' => '<p>The type of resource that was imported.</p>', ], ], 'ImportSortAttribute' => [ 'base' => NULL, 'refs' => [ 'ImportSortBy$attribute' => '<p>The export field to use for sorting.</p>', ], ], 'ImportSortBy' => [ 'base' => '<p>Provides information for sorting a list of imports.</p>', 'refs' => [ 'ListImportsRequest$sortBy' => '<p>Determines the field that the list of imports is sorted by. You can sort by the <code>LastUpdatedDateTime</code> field in ascending or descending order.</p>', ], ], 'ImportStatus' => [ 'base' => NULL, 'refs' => [ 'DeleteImportResponse$importStatus' => '<p>The current status of the deletion. When the deletion is complete, the import will no longer be returned by the <a href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListImports.html">ListImports</a> operation and calls to the <a href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DescribeImport.html">DescribeImport</a> operation with the import identifier will fail.</p>', 'DescribeImportResponse$importStatus' => '<p>The status of the import process. When the status is <code>Completed</code> the resource is imported and ready for use.</p>', 'ImportSummary$importStatus' => '<p>The status of the resource. When the status is <code>Completed</code> the resource is ready to build.</p>', 'StartImportResponse$importStatus' => '<p>The current status of the import. When the status is <code>Complete</code> the bot, bot alias, or custom vocabulary is ready to use.</p>', ], ], 'ImportSummary' => [ 'base' => '<p>Provides summary information about an import in an import list.</p>', 'refs' => [ 'ImportSummaryList$member' => NULL, ], ], 'ImportSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListImportsResponse$importSummaries' => '<p>Summary information for the imports that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter. If there are more imports available, the <code>nextToken</code> field contains a token to get the next page of results.</p>', ], ], 'ImportedResourceId' => [ 'base' => NULL, 'refs' => [ 'DescribeImportResponse$importedResourceId' => '<p>The unique identifier that Amazon Lex assigned to the resource created by the import.</p>', 'ImportSummary$importedResourceId' => '<p>The unique identifier that Amazon Lex assigned to the imported resource.</p>', ], ], 'IncludeField' => [ 'base' => NULL, 'refs' => [ 'OSIncludeFields$member' => NULL, ], ], 'InitialResponseSetting' => [ 'base' => '<p>Configuration setting for a response sent to the user before Amazon Lex starts eliciting slots.</p>', 'refs' => [ 'CreateIntentRequest$initialResponseSetting' => '<p>Configuration settings for the response that is sent to the user at the beginning of a conversation, before eliciting slot values.</p>', 'CreateIntentResponse$initialResponseSetting' => '<p>Configuration settings for the response that is sent to the user at the beginning of a conversation, before eliciting slot values.</p>', 'DescribeIntentResponse$initialResponseSetting' => '<p>Configuration setting for a response sent to the user before Amazon Lex starts eliciting slots.</p>', 'UpdateIntentRequest$initialResponseSetting' => '<p>Configuration settings for a response sent to the user before Amazon Lex starts eliciting slots.</p>', 'UpdateIntentResponse$initialResponseSetting' => '<p>Configuration settings for a response sent to the user before Amazon Lex starts eliciting slots.</p>', ], ], 'InputContext' => [ 'base' => '<p>A context that must be active for an intent to be selected by Amazon Lex.</p>', 'refs' => [ 'InputContextsList$member' => NULL, ], ], 'InputContextsList' => [ 'base' => NULL, 'refs' => [ 'CreateIntentRequest$inputContexts' => '<p>A list of contexts that must be active for this intent to be considered by Amazon Lex.</p> <p>When an intent has an input context list, Amazon Lex only considers using the intent in an interaction with the user when the specified contexts are included in the active context list for the session. If the contexts are not active, then Amazon Lex will not use the intent.</p> <p>A context can be automatically activated using the <code>outputContexts</code> property or it can be set at runtime.</p> <p> For example, if there are two intents with different input contexts that respond to the same utterances, only the intent with the active context will respond.</p> <p>An intent may have up to 5 input contexts. If an intent has multiple input contexts, all of the contexts must be active to consider the intent.</p>', 'CreateIntentResponse$inputContexts' => '<p>The list of input contexts specified for the intent.</p>', 'DescribeIntentResponse$inputContexts' => '<p>A list of contexts that must be active for the intent to be considered for sending to the user.</p>', 'IntentSummary$inputContexts' => '<p>The input contexts that must be active for this intent to be considered for recognition.</p>', 'UpdateIntentRequest$inputContexts' => '<p>A new list of contexts that must be active in order for Amazon Lex to consider the intent.</p>', 'UpdateIntentResponse$inputContexts' => '<p>The updated list of contexts that must be active for the intent to be considered by Amazon Lex.</p>', ], ], 'InputSessionStateSpecification' => [ 'base' => '<p>Specifications for the current state of the dialog between the user and the bot in the test set.</p>', 'refs' => [ 'UserTurnInputSpecification$sessionState' => '<p>Contains information about the session state in the input.</p>', ], ], 'IntentClassificationTestResultItem' => [ 'base' => '<p>Information for an intent that is classified by the test workbench.</p>', 'refs' => [ 'IntentClassificationTestResultItemList$member' => NULL, ], ], 'IntentClassificationTestResultItemCounts' => [ 'base' => '<p>The number of items in the intent classification test.</p>', 'refs' => [ 'IntentClassificationTestResultItem$resultCounts' => '<p>The result of the intent classification test.</p>', ], ], 'IntentClassificationTestResultItemList' => [ 'base' => NULL, 'refs' => [ 'IntentClassificationTestResults$items' => '<p>A list of the results for the intent classification test.</p>', ], ], 'IntentClassificationTestResults' => [ 'base' => '<p>Information for the results of the intent classification test. </p>', 'refs' => [ 'TestExecutionResultItems$intentClassificationTestResults' => '<p>Intent recognition results aggregated by intent name. The aggregated results contain success and failure rates of intent recognition, speech transcriptions, and end-to-end conversations.</p>', ], ], 'IntentClosingSetting' => [ 'base' => '<p>Provides a statement the Amazon Lex conveys to the user when the intent is successfully fulfilled.</p>', 'refs' => [ 'CreateIntentRequest$intentClosingSetting' => '<p>Sets the response that Amazon Lex sends to the user when the intent is closed.</p>', 'CreateIntentResponse$intentClosingSetting' => '<p>The closing setting specified for the intent.</p>', 'DescribeIntentResponse$intentClosingSetting' => '<p>The response that Amazon Lex sends to when the intent is closed.</p>', 'UpdateIntentRequest$intentClosingSetting' => '<p>The new response that Amazon Lex sends the user when the intent is closed.</p>', 'UpdateIntentResponse$intentClosingSetting' => '<p>The updated response that Amazon Lex sends the user when the intent is closed.</p>', ], ], 'IntentConfirmationSetting' => [ 'base' => '<p>Provides a prompt for making sure that the user is ready for the intent to be fulfilled.</p>', 'refs' => [ 'CreateIntentRequest$intentConfirmationSetting' => '<p>Provides prompts that Amazon Lex sends to the user to confirm the completion of an intent. If the user answers "no," the settings contain a statement that is sent to the user to end the intent.</p>', 'CreateIntentResponse$intentConfirmationSetting' => '<p>The confirmation setting specified for the intent.</p>', 'DescribeIntentResponse$intentConfirmationSetting' => '<p>Prompts that Amazon Lex sends to the user to confirm completion of an intent.</p>', 'UpdateIntentRequest$intentConfirmationSetting' => '<p>New prompts that Amazon Lex sends to the user to confirm the completion of an intent.</p>', 'UpdateIntentResponse$intentConfirmationSetting' => '<p>The updated prompts that Amazon Lex sends to the user to confirm the completion of an intent.</p>', ], ], 'IntentFilter' => [ 'base' => '<p>Filters the response from the <code>ListIntents</code> operation.</p>', 'refs' => [ 'IntentFilters$member' => NULL, ], ], 'IntentFilterName' => [ 'base' => NULL, 'refs' => [ 'IntentFilter$name' => '<p>The name of the field to use for the filter.</p>', ], ], 'IntentFilterOperator' => [ 'base' => NULL, 'refs' => [ 'IntentFilter$operator' => '<p>The operator to use for the filter. Specify <code>EQ</code> when the <code>ListIntents</code> operation should return only aliases that equal the specified value. Specify <code>CO</code> when the <code>ListIntents</code> operation should return aliases that contain the specified value.</p>', ], ], 'IntentFilters' => [ 'base' => NULL, 'refs' => [ 'ListIntentsRequest$filters' => '<p>Provides the specification of a filter used to limit the intents in the response to only those that match the filter specification. You can only specify one filter and only one string to filter on.</p>', ], ], 'IntentLevelSlotResolutionTestResultItem' => [ 'base' => '<p>Information about intent-level slot resolution in a test result.</p>', 'refs' => [ 'IntentLevelSlotResolutionTestResultItemList$member' => NULL, ], ], 'IntentLevelSlotResolutionTestResultItemList' => [ 'base' => NULL, 'refs' => [ 'IntentLevelSlotResolutionTestResults$items' => '<p>Indicates the items for the slot level resolution for the intents.</p>', ], ], 'IntentLevelSlotResolutionTestResults' => [ 'base' => '<p>Indicates the success or failure of slots at the intent level.</p>', 'refs' => [ 'TestExecutionResultItems$intentLevelSlotResolutionTestResults' => '<p>Slot resolution results aggregated by intent and slot name. The aggregated results contain success and failure rates of slot resolution, speech transcriptions, and end-to-end conversations</p>', ], ], 'IntentOverride' => [ 'base' => '<p>Override settings to configure the intent state.</p>', 'refs' => [ 'DialogState$intent' => NULL, ], ], 'IntentSignature' => [ 'base' => NULL, 'refs' => [ 'BuiltInIntentSummary$intentSignature' => '<p>The signature of the built-in intent. Use this to specify the parent intent of a derived intent.</p>', 'CreateIntentRequest$parentIntentSignature' => '<p>A unique identifier for the built-in intent to base this intent on.</p>', 'CreateIntentResponse$parentIntentSignature' => '<p>The signature of the parent intent specified for the intent.</p>', 'DescribeIntentResponse$parentIntentSignature' => '<p>The identifier of the built-in intent that this intent is derived from, if any.</p>', 'IntentSummary$parentIntentSignature' => '<p>If this intent is derived from a built-in intent, the name of the parent intent.</p>', 'UpdateIntentRequest$parentIntentSignature' => '<p>The signature of the new built-in intent to use as the parent of this intent.</p>', 'UpdateIntentResponse$parentIntentSignature' => '<p>The updated built-in intent that is the parent of this intent.</p>', ], ], 'IntentSortAttribute' => [ 'base' => NULL, 'refs' => [ 'IntentSortBy$attribute' => '<p>The attribute to use to sort the list of intents.</p>', ], ], 'IntentSortBy' => [ 'base' => '<p>Specifies attributes for sorting a list of intents.</p>', 'refs' => [ 'ListIntentsRequest$sortBy' => '<p>Determines the sort order for the response from the <code>ListIntents</code> operation. You can choose to sort by the intent name or last updated date in either ascending or descending order.</p>', ], ], 'IntentState' => [ 'base' => NULL, 'refs' => [ 'UtteranceSpecification$intentState' => '<p>The state of the intent that the utterance is associated to.</p>', ], ], 'IntentStatistics' => [ 'base' => '<p>The object that contains the statistical summary of recommended intents associated with the bot recommendation.</p>', 'refs' => [ 'BotRecommendationResultStatistics$intents' => '<p>Statistical information about about the intents associated with the bot recommendation results.</p>', ], ], 'IntentSummary' => [ 'base' => '<p>Summary information about an intent returned by the <code>ListIntents</code> operation.</p>', 'refs' => [ 'IntentSummaryList$member' => NULL, ], ], 'IntentSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListIntentsResponse$intentSummaries' => '<p>Summary information for the intents that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more intents available, the <code>nextToken</code> field contains a token to get the next page of results.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>The service encountered an unexpected condition. Try your request again.</p>', 'refs' => [], ], 'InvokedIntentSample' => [ 'base' => '<p>An object containing the name of an intent that was invoked.</p>', 'refs' => [ 'InvokedIntentSamples$member' => NULL, ], ], 'InvokedIntentSamples' => [ 'base' => NULL, 'refs' => [ 'SessionSpecification$invokedIntentSamples' => '<p>A list of objects containing the name of an intent that was invoked.</p>', ], ], 'ItemId' => [ 'base' => NULL, 'refs' => [ 'CustomVocabularyEntryId$itemId' => '<p>The unique item identifier for the custom vocabulary items.</p>', 'CustomVocabularyItem$itemId' => '<p>The unique item identifer for the custom vocabulary item from the custom vocabulary list.</p>', 'FailedCustomVocabularyItem$itemId' => '<p>The unique item identifer for the failed custom vocabulary item from the custom vocabulary list.</p>', ], ], 'KendraConfiguration' => [ 'base' => '<p>Provides configuration information for the <code>AMAZON.KendraSearchIntent</code> intent. When you use this intent, Amazon Lex searches the specified Amazon Kendra index and returns documents from the index that match the user\'s utterance.</p>', 'refs' => [ 'CreateIntentRequest$kendraConfiguration' => '<p>Configuration information required to use the <code>AMAZON.KendraSearchIntent</code> intent to connect to an Amazon Kendra index. The <code>AMAZON.KendraSearchIntent</code> intent is called when Amazon Lex can\'t determine another intent to invoke.</p>', 'CreateIntentResponse$kendraConfiguration' => '<p>Configuration for searching a Amazon Kendra index specified for the intent.</p>', 'DescribeIntentResponse$kendraConfiguration' => '<p>Configuration information required to use the <code>AMAZON.KendraSearchIntent</code> intent.</p>', 'UpdateIntentRequest$kendraConfiguration' => '<p>New configuration settings for connecting to an Amazon Kendra index.</p>', 'UpdateIntentResponse$kendraConfiguration' => '<p>The updated configuration for connecting to an Amazon Kendra index with the <code>AMAZON.KendraSearchIntent</code> intent.</p>', ], ], 'KendraIndexArn' => [ 'base' => NULL, 'refs' => [ 'KendraConfiguration$kendraIndex' => '<p>The Amazon Resource Name (ARN) of the Amazon Kendra index that you want the <code>AMAZON.KendraSearchIntent</code> intent to search. The index must be in the same account and Region as the Amazon Lex bot.</p>', 'QnAKendraConfiguration$kendraIndex' => '<p>The ARN of the Amazon Kendra index to use.</p>', ], ], 'KmsKeyArn' => [ 'base' => NULL, 'refs' => [ 'EncryptionSetting$kmsKeyArn' => '<p>The KMS key ARN used to encrypt the metadata associated with the bot recommendation.</p>', 'GrammarSlotTypeSource$kmsKeyArn' => '<p>The KMS key required to decrypt the contents of the grammar, if any.</p>', 'S3BucketLogDestination$kmsKeyArn' => '<p>The Amazon Resource Name (ARN) of an Amazon Web Services Key Management Service (KMS) key for encrypting audio log files stored in an S3 bucket.</p>', 'S3BucketTranscriptSource$kmsKeyArn' => '<p>The ARN of the KMS key that customer use to encrypt their Amazon S3 bucket. Only use this field if your bucket is encrypted using a customer managed KMS key.</p>', 'TestSetStorageLocation$kmsKeyArn' => '<p>The Amazon Resource Name (ARN) of an Amazon Web Services Key Management Service (KMS) key for encrypting the test set.</p>', ], ], 'LambdaARN' => [ 'base' => NULL, 'refs' => [ 'LambdaCodeHook$lambdaARN' => '<p>The Amazon Resource Name (ARN) of the Lambda function.</p>', ], ], 'LambdaCodeHook' => [ 'base' => '<p>Specifies a Lambda function that verifies requests to a bot or fulfills the user\'s request to a bot.</p>', 'refs' => [ 'CodeHookSpecification$lambdaCodeHook' => NULL, ], ], 'LexTranscriptFilter' => [ 'base' => '<p>The object that contains transcript filter details that are associated with a bot recommendation.</p>', 'refs' => [ 'TranscriptFilter$lexTranscriptFilter' => '<p>The object representing the filter that Amazon Lex will use to select the appropriate transcript when the transcript format is the Amazon Lex format.</p>', ], ], 'ListAggregatedUtterancesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAggregatedUtterancesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListBotAliasReplicasRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListBotAliasReplicasResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListBotAliasesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListBotAliasesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListBotLocalesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListBotLocalesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListBotRecommendationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListBotRecommendationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListBotReplicasRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListBotReplicasResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListBotResourceGenerationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListBotResourceGenerationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListBotVersionReplicasRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListBotVersionReplicasResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListBotVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListBotVersionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListBotsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListBotsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListBuiltInIntentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListBuiltInIntentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListBuiltInSlotTypesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListBuiltInSlotTypesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListCustomVocabularyItemsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCustomVocabularyItemsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListExportsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListExportsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListImportsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListImportsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListIntentMetricsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListIntentMetricsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListIntentPathsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListIntentPathsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListIntentStageMetricsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListIntentStageMetricsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListIntentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListIntentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListRecommendedIntentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRecommendedIntentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSessionAnalyticsDataRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSessionAnalyticsDataResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSessionMetricsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSessionMetricsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSlotTypesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSlotTypesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSlotsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSlotsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTestExecutionResultItemsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTestExecutionResultItemsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTestExecutionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTestExecutionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTestSetRecordsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTestSetRecordsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTestSetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTestSetsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListUtteranceAnalyticsDataRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListUtteranceAnalyticsDataResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListUtteranceMetricsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListUtteranceMetricsResponse' => [ 'base' => NULL, 'refs' => [], ], 'LocaleId' => [ 'base' => NULL, 'refs' => [ 'BatchCreateCustomVocabularyItemRequest$localeId' => '<p>The identifier of the language and locale where this custom vocabulary is used. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html"> Supported Languages </a>.</p>', 'BatchCreateCustomVocabularyItemResponse$localeId' => '<p>The identifier of the language and locale where this custom vocabulary is used. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html"> Supported Languages </a>.</p>', 'BatchDeleteCustomVocabularyItemRequest$localeId' => '<p>The identifier of the language and locale where this custom vocabulary is used. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html"> Supported Languages </a>.</p>', 'BatchDeleteCustomVocabularyItemResponse$localeId' => '<p>The identifier of the language and locale where this custom vocabulary is used. The string must match one of the supported locales. For more information, see Supported languages (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).</p>', 'BatchUpdateCustomVocabularyItemRequest$localeId' => '<p>The identifier of the language and locale where this custom vocabulary is used. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html"> Supported Languages </a>.</p>', 'BatchUpdateCustomVocabularyItemResponse$localeId' => '<p>The identifier of the language and locale where this custom vocabulary is used. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html"> Supported Languages </a>.</p>', 'BotAliasLocaleSettingsMap$key' => NULL, 'BotAliasTestExecutionTarget$localeId' => '<p>The locale Id of the bot alias used in the test set execution.</p>', 'BotLocaleExportSpecification$localeId' => '<p>The identifier of the language and locale to export. The string must match one of the locales in the bot.</p>', 'BotLocaleImportSpecification$localeId' => '<p>The identifier of the language and locale that the bot will be used in. The string must match one of the supported locales. All of the intents, slot types, and slots used in the bot must have the same locale. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>', 'BotLocaleSummary$localeId' => '<p>The language and locale of the bot locale.</p>', 'BotVersionLocaleSpecification$key' => NULL, 'BuildBotLocaleRequest$localeId' => '<p>The identifier of the language and locale that the bot will be used in. The string must match one of the supported locales. All of the intents, slot types, and slots used in the bot must have the same locale. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>', 'BuildBotLocaleResponse$localeId' => '<p>The language and locale specified of where the bot can be used.</p>', 'ConversationLogsDataSource$localeId' => '<p>The locale Id of the conversation log.</p>', 'CreateBotLocaleRequest$localeId' => '<p>The identifier of the language and locale that the bot will be used in. The string must match one of the supported locales. All of the intents, slot types, and slots used in the bot must have the same locale. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>', 'CreateBotLocaleResponse$localeId' => '<p>The specified locale identifier.</p>', 'CreateIntentRequest$localeId' => '<p>The identifier of the language and locale where this intent is used. All of the bots, slot types, and slots used by the intent must have the same locale. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>', 'CreateIntentResponse$localeId' => '<p>The locale that the intent is specified to use.</p>', 'CreateSlotRequest$localeId' => '<p>The identifier of the language and locale that the slot will be used in. The string must match one of the supported locales. All of the bots, intents, slot types used by the slot must have the same locale. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>', 'CreateSlotResponse$localeId' => '<p>The language and local specified for the slot.</p>', 'CreateSlotTypeRequest$localeId' => '<p>The identifier of the language and locale that the slot type will be used in. The string must match one of the supported locales. All of the bots, intents, and slots used by the slot type must have the same locale. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>', 'CreateSlotTypeResponse$localeId' => '<p>The specified language and local specified for the slot type.</p>', 'CustomVocabularyExportSpecification$localeId' => '<p>The locale of the bot that contains the custom vocabulary to export.</p>', 'CustomVocabularyImportSpecification$localeId' => '<p>The identifier of the local to import the custom vocabulary to. The value must be <code>en_GB</code>.</p>', 'DeleteBotLocaleRequest$localeId' => '<p>The identifier of the language and locale that will be deleted. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>', 'DeleteBotLocaleResponse$localeId' => '<p>The language and locale of the deleted locale.</p>', 'DeleteCustomVocabularyRequest$localeId' => '<p>The locale identifier for the locale that contains the custom vocabulary to remove.</p>', 'DeleteCustomVocabularyResponse$localeId' => '<p>The locale identifier for the locale that the custom vocabulary was removed from.</p>', 'DeleteIntentRequest$localeId' => '<p>The identifier of the language and locale where the bot will be deleted. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>', 'DeleteSlotRequest$localeId' => '<p>The identifier of the language and locale that the slot will be deleted from. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>', 'DeleteSlotTypeRequest$localeId' => '<p>The identifier of the language and locale that the slot type will be deleted from. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>', 'DeleteUtterancesRequest$localeId' => '<p>The identifier of the language and locale where the utterances were collected. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>', 'DescribeBotLocaleRequest$localeId' => '<p>The unique identifier of the locale to describe. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>. </p>', 'DescribeBotLocaleResponse$localeId' => '<p>The unique identifier of the described locale.</p>', 'DescribeBotRecommendationRequest$localeId' => '<p>The identifier of the language and locale of the bot recommendation to describe. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>', 'DescribeBotRecommendationResponse$localeId' => '<p>The identifier of the language and locale of the bot recommendation to describe.</p>', 'DescribeBotResourceGenerationRequest$localeId' => '<p>The locale of the bot for which to return the generation details.</p>', 'DescribeBotResourceGenerationResponse$localeId' => '<p>The locale of the bot for which the generation request was made.</p>', 'DescribeCustomVocabularyMetadataRequest$localeId' => '<p>The locale to return the custom vocabulary information for. The locale must be <code>en_GB</code>.</p>', 'DescribeCustomVocabularyMetadataResponse$localeId' => '<p>The locale that contains the custom vocabulary to describe.</p>', 'DescribeIntentRequest$localeId' => '<p>The identifier of the language and locale of the intent to describe. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>', 'DescribeIntentResponse$localeId' => '<p>The language and locale specified for the intent.</p>', 'DescribeSlotRequest$localeId' => '<p>The identifier of the language and locale of the slot to describe. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>', 'DescribeSlotResponse$localeId' => '<p>The language and locale specified for the slot.</p>', 'DescribeSlotTypeRequest$localeId' => '<p>The identifier of the language and locale of the slot type to describe. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>', 'DescribeSlotTypeResponse$localeId' => '<p>The language and locale specified for the slot type.</p>', 'GenerateBotElementRequest$localeId' => '<p>The unique locale Id for the bot request to generate utterances.</p>', 'GenerateBotElementResponse$localeId' => '<p>The unique locale Id for the bot which received the response.</p>', 'ListAggregatedUtterancesRequest$localeId' => '<p>The identifier of the language and locale where the utterances were collected. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>', 'ListAggregatedUtterancesResponse$localeId' => '<p>The identifier of the language and locale that the utterances are in.</p>', 'ListBotRecommendationsRequest$localeId' => '<p>The identifier of the language and locale of the bot recommendation list.</p>', 'ListBotRecommendationsResponse$localeId' => '<p>The identifier of the language and locale of the bot recommendation list.</p>', 'ListBotResourceGenerationsRequest$localeId' => '<p>The locale of the bot whose generation requests you want to view.</p>', 'ListBotResourceGenerationsResponse$localeId' => '<p>The locale of the bot for which the generation requests were made.</p>', 'ListBuiltInIntentsRequest$localeId' => '<p>The identifier of the language and locale of the intents to list. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>', 'ListBuiltInIntentsResponse$localeId' => '<p>The language and locale of the intents in the list.</p>', 'ListBuiltInSlotTypesRequest$localeId' => '<p>The identifier of the language and locale of the slot types to list. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>', 'ListBuiltInSlotTypesResponse$localeId' => '<p>The language and locale of the slot types in the list.</p>', 'ListCustomVocabularyItemsRequest$localeId' => '<p>The identifier of the language and locale where this custom vocabulary is used. The string must match one of the supported locales. For more information, see Supported languages (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).</p>', 'ListCustomVocabularyItemsResponse$localeId' => '<p>The identifier of the language and locale where this custom vocabulary is used. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html"> Supported Languages </a>.</p>', 'ListExportsRequest$localeId' => '<p>Specifies the resources that should be exported. If you don\'t specify a resource type in the <code>filters</code> parameter, both bot locales and custom vocabularies are exported.</p>', 'ListExportsResponse$localeId' => '<p>The locale specified in the request.</p>', 'ListImportsRequest$localeId' => '<p>Specifies the locale that should be present in the list. If you don\'t specify a resource type in the <code>filters</code> parameter, the list contains both bot locales and custom vocabularies.</p>', 'ListImportsResponse$localeId' => '<p>The locale specified in the request.</p>', 'ListIntentsRequest$localeId' => '<p>The identifier of the language and locale of the intents to list. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>', 'ListIntentsResponse$localeId' => '<p>The language and locale of the intents in the list.</p>', 'ListRecommendedIntentsRequest$localeId' => '<p>The identifier of the language and locale of the recommended intents.</p>', 'ListRecommendedIntentsResponse$localeId' => '<p>The identifier of the language and locale of the intents to list. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>', 'ListSlotTypesRequest$localeId' => '<p>The identifier of the language and locale of the slot types to list. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>', 'ListSlotTypesResponse$localeId' => '<p>The language and local of the slot types in the list.</p>', 'ListSlotsRequest$localeId' => '<p>The identifier of the language and locale of the slots to list. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>', 'ListSlotsResponse$localeId' => '<p>The language and locale of the slots in the list.</p>', 'SearchAssociatedTranscriptsRequest$localeId' => '<p>The identifier of the language and locale of the transcripts to search. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a> </p>', 'SearchAssociatedTranscriptsResponse$localeId' => '<p>The identifier of the language and locale of the transcripts to search. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a> </p>', 'SessionSpecification$localeId' => '<p>The locale of the bot that the session was held with.</p>', 'StartBotRecommendationRequest$localeId' => '<p>The identifier of the language and locale of the bot recommendation to start. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a> </p>', 'StartBotRecommendationResponse$localeId' => '<p>The identifier of the language and locale of the bot recommendation to start. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a> </p>', 'StartBotResourceGenerationRequest$localeId' => '<p>The locale of the bot for which to generate intents and slot types.</p>', 'StartBotResourceGenerationResponse$localeId' => '<p>The locale of the bot for which the generation request was made.</p>', 'StopBotRecommendationRequest$localeId' => '<p>The identifier of the language and locale of the bot recommendation to stop. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a> </p>', 'StopBotRecommendationResponse$localeId' => '<p>The identifier of the language and locale of the bot response to stop. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a> </p>', 'TestSetDiscrepancyReportBotAliasTarget$localeId' => '<p>The unique identifier of the locale associated with the bot alias.</p>', 'UpdateBotLocaleRequest$localeId' => '<p>The identifier of the language and locale to update. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>', 'UpdateBotLocaleResponse$localeId' => '<p>The language and locale of the updated bot locale.</p>', 'UpdateBotRecommendationRequest$localeId' => '<p>The identifier of the language and locale of the bot recommendation to update. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a> </p>', 'UpdateBotRecommendationResponse$localeId' => '<p>The identifier of the language and locale of the bot recommendation to update. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a> </p>', 'UpdateIntentRequest$localeId' => '<p>The identifier of the language and locale where this intent is used. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>', 'UpdateIntentResponse$localeId' => '<p>The updated language and locale of the intent.</p>', 'UpdateSlotRequest$localeId' => '<p>The identifier of the language and locale that contains the slot. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>', 'UpdateSlotResponse$localeId' => '<p>The locale that contains the slot.</p>', 'UpdateSlotTypeRequest$localeId' => '<p>The identifier of the language and locale that contains the slot type. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>', 'UpdateSlotTypeResponse$localeId' => '<p>The language and locale of the updated slot type.</p>', 'UtteranceSpecification$localeId' => '<p>The locale of the bot that the utterance was made to.</p>', ], ], 'LocaleName' => [ 'base' => NULL, 'refs' => [ 'BotLocaleSummary$localeName' => '<p>The name of the bot locale.</p>', 'CreateBotLocaleResponse$localeName' => '<p>The specified locale name.</p>', 'DescribeBotLocaleResponse$localeName' => '<p>The name of the locale.</p>', 'UpdateBotLocaleResponse$localeName' => '<p>The updated locale name for the locale.</p>', ], ], 'LogPrefix' => [ 'base' => NULL, 'refs' => [ 'CloudWatchLogGroupLogDestination$logPrefix' => '<p>The prefix of the log stream name within the log group that you specified </p>', 'S3BucketLogDestination$logPrefix' => '<p>The S3 prefix to assign to audio log files.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListAggregatedUtterancesRequest$maxResults' => '<p>The maximum number of utterances to return in each page of results. If there are fewer results than the maximum page size, only the actual number of results are returned. If you don\'t specify the <code>maxResults</code> parameter, 1,000 results are returned.</p>', 'ListBotAliasReplicasRequest$maxResults' => '<p>The request for maximum results to list the replicated bots created from the source bot alias.</p>', 'ListBotAliasesRequest$maxResults' => '<p>The maximum number of aliases to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>', 'ListBotLocalesRequest$maxResults' => '<p>The maximum number of aliases to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>', 'ListBotRecommendationsRequest$maxResults' => '<p>The maximum number of bot recommendations to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>', 'ListBotResourceGenerationsRequest$maxResults' => '<p>The maximum number of results to return in the response.</p>', 'ListBotVersionReplicasRequest$maxResults' => '<p>The maximum results given in the list of replicated bots.</p>', 'ListBotVersionsRequest$maxResults' => '<p>The maximum number of versions to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>', 'ListBotsRequest$maxResults' => '<p>The maximum number of bots to return in each page of results. If there are fewer results than the maximum page size, only the actual number of results are returned.</p>', 'ListCustomVocabularyItemsRequest$maxResults' => '<p>The maximum number of items returned by the list operation.</p>', 'ListExportsRequest$maxResults' => '<p>The maximum number of exports to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>', 'ListImportsRequest$maxResults' => '<p>The maximum number of imports to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>', 'ListIntentMetricsRequest$maxResults' => '<p>The maximum number of results to return in each page of results. If there are fewer results than the maximum page size, only the actual number of results are returned.</p>', 'ListIntentStageMetricsRequest$maxResults' => '<p>The maximum number of results to return in each page of results. If there are fewer results than the maximum page size, only the actual number of results are returned.</p>', 'ListIntentsRequest$maxResults' => '<p>The maximum number of intents to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>', 'ListRecommendedIntentsRequest$maxResults' => '<p>The maximum number of bot recommendations to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>', 'ListSessionAnalyticsDataRequest$maxResults' => '<p>The maximum number of results to return in each page of results. If there are fewer results than the maximum page size, only the actual number of results are returned.</p>', 'ListSessionMetricsRequest$maxResults' => '<p>The maximum number of results to return in each page of results. If there are fewer results than the maximum page size, only the actual number of results are returned.</p>', 'ListSlotTypesRequest$maxResults' => '<p>The maximum number of slot types to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>', 'ListSlotsRequest$maxResults' => '<p>The maximum number of slots to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>', 'ListTestExecutionResultItemsRequest$maxResults' => '<p>The maximum number of test execution result items to return in each page. If there are fewer results than the max page size, only the actual number of results are returned.</p>', 'ListTestExecutionsRequest$maxResults' => '<p>The maximum number of test executions to return in each page. If there are fewer results than the max page size, only the actual number of results are returned.</p>', 'ListTestSetRecordsRequest$maxResults' => '<p>The maximum number of test set records to return in each page. If there are fewer records than the max page size, only the actual number of records are returned.</p>', 'ListTestSetsRequest$maxResults' => '<p>The maximum number of test sets to return in each page. If there are fewer results than the max page size, only the actual number of results are returned.</p>', 'ListUtteranceAnalyticsDataRequest$maxResults' => '<p>The maximum number of results to return in each page of results. If there are fewer results than the maximum page size, only the actual number of results are returned.</p>', 'ListUtteranceMetricsRequest$maxResults' => '<p>The maximum number of results to return in each page of results. If there are fewer results than the maximum page size, only the actual number of results are returned.</p>', 'SearchAssociatedTranscriptsRequest$maxResults' => '<p>The maximum number of bot recommendations to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>', 'SearchAssociatedTranscriptsResponse$totalResults' => '<p>The total number of transcripts returned by the search.</p>', ], ], 'MaxUtteranceDigits' => [ 'base' => NULL, 'refs' => [ 'DTMFSpecification$maxLength' => '<p>The maximum number of DTMF digits allowed in an utterance.</p>', ], ], 'MergeStrategy' => [ 'base' => NULL, 'refs' => [ 'DescribeImportResponse$mergeStrategy' => '<p>The strategy used when there was a name conflict between the imported resource and an existing resource. When the merge strategy is <code>FailOnConflict</code> existing resources are not overwritten and the import fails.</p>', 'ImportSummary$mergeStrategy' => '<p>The strategy used to merge existing bot or bot locale definitions with the imported definition.</p>', 'StartImportRequest$mergeStrategy' => '<p>The strategy to use when there is a name conflict between the imported resource and an existing resource. When the merge strategy is <code>FailOnConflict</code> existing resources are not overwritten and the import fails.</p>', 'StartImportResponse$mergeStrategy' => '<p>The strategy used when there was a name conflict between the imported resource and an existing resource. When the merge strategy is <code>FailOnConflict</code> existing resources are not overwritten and the import fails.</p>', ], ], 'Message' => [ 'base' => '<p>The object that provides message text and its type.</p>', 'refs' => [ 'MessageGroup$message' => '<p>The primary message that Amazon Lex should send to the user.</p>', 'MessageVariationsList$member' => NULL, ], ], 'MessageGroup' => [ 'base' => '<p>Provides one or more messages that Amazon Lex should send to the user.</p>', 'refs' => [ 'MessageGroupsList$member' => NULL, ], ], 'MessageGroupsList' => [ 'base' => NULL, 'refs' => [ 'FulfillmentStartResponseSpecification$messageGroups' => '<p>1 - 5 message groups that contain start messages. Amazon Lex chooses one of the messages to play to the user.</p>', 'FulfillmentUpdateResponseSpecification$messageGroups' => '<p>1 - 5 message groups that contain update messages. Amazon Lex chooses one of the messages to play to the user.</p>', 'PromptSpecification$messageGroups' => '<p>A collection of messages that Amazon Lex can send to the user. Amazon Lex chooses the actual message to send at runtime.</p>', 'ResponseSpecification$messageGroups' => '<p>A collection of responses that Amazon Lex can send to the user. Amazon Lex chooses the actual response to send at runtime.</p>', 'StillWaitingResponseSpecification$messageGroups' => '<p>One or more message groups, each containing one or more messages, that define the prompts that Amazon Lex sends to the user.</p>', ], ], 'MessageSelectionStrategy' => [ 'base' => NULL, 'refs' => [ 'PromptSpecification$messageSelectionStrategy' => '<p>Indicates how a message is selected from a message group among retries.</p>', ], ], 'MessageVariationsList' => [ 'base' => NULL, 'refs' => [ 'MessageGroup$variations' => '<p>Message variations to send to the user. When variations are defined, Amazon Lex chooses the primary message or one of the variations to send to the user.</p>', ], ], 'MissedCount' => [ 'base' => NULL, 'refs' => [ 'AggregatedUtterancesSummary$missedCount' => '<p>The number of times that the utterance was missed by Amazon Lex An utterance is missed when it doesn\'t activate an intent or slot.</p>', ], ], 'MultipleValuesSetting' => [ 'base' => '<p>Indicates whether a slot can return multiple values.</p>', 'refs' => [ 'CreateSlotRequest$multipleValuesSetting' => '<p>Indicates whether the slot returns multiple values in one response. Multi-value slots are only available in the <code>en-US</code> locale. If you set this value to <code>true</code> in any other locale, Amazon Lex throws a <code>ValidationException</code>. </p> <p>If the <code>multipleValuesSetting</code> is not set, the default value is <code>false</code>.</p>', 'CreateSlotResponse$multipleValuesSetting' => '<p>Indicates whether the slot returns multiple values in one response.</p>', 'DescribeSlotResponse$multipleValuesSetting' => '<p>Indicates whether the slot accepts multiple values in a single utterance.</p> <p>If the <code>multipleValuesSetting</code> is not set, the default value is <code>false</code>.</p>', 'UpdateSlotRequest$multipleValuesSetting' => '<p>Determines whether the slot accepts multiple values in one response. Multiple value slots are only available in the en-US locale. If you set this value to <code>true</code> in any other locale, Amazon Lex throws a <code>ValidationException</code>.</p> <p>If the <code>multipleValuesSetting</code> is not set, the default value is <code>false</code>.</p>', 'UpdateSlotResponse$multipleValuesSetting' => '<p>Indicates whether the slot accepts multiple values in one response.</p>', ], ], 'Name' => [ 'base' => NULL, 'refs' => [ 'AgentTurnResult$actualIntent' => '<p>The actual intent for the agent turn in a test set execution.</p>', 'AnalyticsIntentNodeSummary$intentName' => '<p>The name of the intent at the end of the requested path.</p>', 'AnalyticsUtteranceAttributeResult$lastUsedIntent' => '<p>The intent that the bot mapped the utterance to.</p>', 'BotAliasSummary$botAliasName' => '<p>The name of the bot alias.</p>', 'BotImportSpecification$botName' => '<p>The name that Amazon Lex should use for the bot.</p>', 'BotMember$botMemberName' => '<p>The unique name of a bot that is a member of this network of bots.</p>', 'BotSummary$botName' => '<p>The name of the bot.</p>', 'BotVersionSummary$botName' => '<p>The name of the bot associated with the version.</p>', 'ConditionalBranch$name' => '<p>The name of the branch. </p>', 'ConversationLevelIntentClassificationResultItem$intentName' => '<p>The intent name used in the evaluation of intent level success or failure.</p>', 'ConversationLevelSlotResolutionResultItem$intentName' => '<p>The intents used in the slots list for the slot resolution details.</p>', 'CreateBotAliasRequest$botAliasName' => '<p>The alias to create. The name must be unique for the bot.</p>', 'CreateBotAliasResponse$botAliasName' => '<p>The name specified for the bot alias.</p>', 'CreateBotRequest$botName' => '<p>The name of the bot. The bot name must be unique in the account that creates the bot.</p>', 'CreateBotResponse$botName' => '<p>The name specified for the bot.</p>', 'CreateIntentRequest$intentName' => '<p>The name of the intent. Intent names must be unique in the locale that contains the intent and cannot match the name of any built-in intent.</p>', 'CreateIntentResponse$intentName' => '<p>The name specified for the intent.</p>', 'CreateResourcePolicyStatementRequest$statementId' => '<p>The name of the statement. The ID is the same as the <code>Sid</code> IAM property. The statement name must be unique within the policy. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html">IAM JSON policy elements: Sid</a>. </p>', 'CreateSlotRequest$slotName' => '<p>The name of the slot. Slot names must be unique within the bot that contains the slot.</p>', 'CreateSlotResponse$slotName' => '<p>The name specified for the slot.</p>', 'CreateSlotTypeRequest$slotTypeName' => '<p>The name for the slot. A slot type name must be unique within the intent.</p>', 'CreateSlotTypeResponse$slotTypeName' => '<p>The name specified for the slot type.</p>', 'DeleteResourcePolicyStatementRequest$statementId' => '<p>The name of the statement (SID) to delete from the policy.</p>', 'DescribeBotAliasResponse$botAliasName' => '<p>The name of the bot alias.</p>', 'DescribeBotResponse$botName' => '<p>The name of the bot.</p>', 'DescribeBotVersionResponse$botName' => '<p>The name of the bot that contains the version.</p>', 'DescribeImportResponse$importedResourceName' => '<p>The name of the imported resource.</p>', 'DescribeIntentResponse$intentName' => '<p>The name specified for the intent.</p>', 'DescribeSlotResponse$slotName' => '<p>The name specified for the slot.</p>', 'DescribeSlotTypeResponse$slotTypeName' => '<p>The name specified for the slot type.</p>', 'DescribeTestExecutionResponse$testSetName' => '<p>The test set name of the test set execution.</p>', 'DescribeTestSetGenerationResponse$testSetName' => '<p>The test set name for the generated test set.</p>', 'DescribeTestSetResponse$testSetName' => '<p>The test set name of the test set.</p>', 'DialogAction$slotToElicit' => '<p>If the dialog action is <code>ElicitSlot</code>, defines the slot to elicit from the user.</p>', 'DialogCodeHookInvocationSetting$invocationLabel' => '<p>A label that indicates the dialog step from which the dialog code hook is happening.</p>', 'ElicitationCodeHookInvocationSetting$invocationLabel' => '<p>A label that indicates the dialog step from which the dialog code hook is happening.</p>', 'ImportSummary$importedResourceName' => '<p>The name that you gave the imported resource.</p>', 'InputContext$name' => '<p>The name of the context.</p>', 'IntentClassificationTestResultItem$intentName' => '<p>The name of the intent.</p>', 'IntentLevelSlotResolutionTestResultItem$intentName' => '<p>The name of the intent that was recognized.</p>', 'IntentOverride$name' => '<p>The name of the intent. Only required when you\'re switching intents.</p>', 'IntentSummary$intentName' => '<p>The name of the intent.</p>', 'InvokedIntentSample$intentName' => '<p>The name of an intent that was invoked.</p>', 'OutputContext$name' => '<p>The name of the output context.</p>', 'RecommendedIntentSummary$intentName' => '<p>The name of a recommended intent associated with the bot recommendation.</p>', 'SlotHintsIntentMap$key' => NULL, 'SlotHintsSlotMap$key' => NULL, 'SlotSummary$slotName' => '<p>The name given to the slot.</p>', 'SlotTypeSummary$slotTypeName' => '<p>The name of the slot type.</p>', 'SlotValueOverrideMap$key' => NULL, 'StartTestSetGenerationRequest$testSetName' => '<p>The test set name for the test set generation request.</p>', 'StartTestSetGenerationResponse$testSetName' => '<p>The test set name used for the test set generation.</p>', 'SubSlotSpecificationMap$key' => NULL, 'SubSlotTypeComposition$name' => '<p>Name of a constituent sub slot inside a composite slot.</p>', 'TestExecutionSummary$testSetName' => '<p>The name of the test set used in the test execution.</p>', 'TestSetImportResourceSpecification$testSetName' => '<p>The name of the test set.</p>', 'TestSetIntentDiscrepancyItem$intentName' => '<p>The name of the intent in the discrepancy report.</p>', 'TestSetSlotDiscrepancyItem$intentName' => '<p>The name of the intent associated with the slot in the discrepancy report.</p>', 'TestSetSlotDiscrepancyItem$slotName' => '<p>The name of the slot in the discrepancy report.</p>', 'TestSetSummary$testSetName' => '<p>The name of the test set.</p>', 'UpdateBotAliasRequest$botAliasName' => '<p>The new name to assign to the bot alias.</p>', 'UpdateBotAliasResponse$botAliasName' => '<p>The updated name of the bot alias.</p>', 'UpdateBotRequest$botName' => '<p>The new name of the bot. The name must be unique in the account that creates the bot.</p>', 'UpdateBotResponse$botName' => '<p>The name of the bot after the update.</p>', 'UpdateIntentRequest$intentName' => '<p>The new name for the intent.</p>', 'UpdateIntentResponse$intentName' => '<p>The updated name of the intent.</p>', 'UpdateSlotRequest$slotName' => '<p>The new name for the slot.</p>', 'UpdateSlotResponse$slotName' => '<p>The updated name of the slot.</p>', 'UpdateSlotTypeRequest$slotTypeName' => '<p>The new name of the slot type.</p>', 'UpdateSlotTypeResponse$slotTypeName' => '<p>The updated name of the slot type.</p>', 'UpdateTestSetRequest$testSetName' => '<p>The new test set name.</p>', 'UpdateTestSetResponse$testSetName' => '<p>The test set name for the updated test set.</p>', 'UserTurnIntentOutput$name' => '<p>The name of the intent.</p>', 'UserTurnSlotOutputMap$key' => NULL, 'UtteranceSpecification$associatedIntentName' => '<p>The name of the intent that the utterance is associated to.</p>', 'UtteranceSpecification$associatedSlotName' => '<p>The name of the slot that the utterance is associated to.</p>', ], ], 'NewCustomVocabularyItem' => [ 'base' => '<p>The new custom vocabulary item from the custom vocabulary list.</p>', 'refs' => [ 'CreateCustomVocabularyItemsList$member' => NULL, ], ], 'NextIndex' => [ 'base' => NULL, 'refs' => [ 'SearchAssociatedTranscriptsRequest$nextIndex' => '<p>If the response from the SearchAssociatedTranscriptsRequest operation contains more results than specified in the maxResults parameter, an index is returned in the response. Use that index in the nextIndex parameter to return the next page of results.</p>', 'SearchAssociatedTranscriptsResponse$nextIndex' => '<p>A index that indicates whether there are more results to return in a response to the SearchAssociatedTranscripts operation. If the nextIndex field is present, you send the contents as the nextIndex parameter of a SearchAssociatedTranscriptsRequest operation to get the next page of results.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListAggregatedUtterancesRequest$nextToken' => '<p>If the response from the <code>ListAggregatedUtterances</code> operation contains more results that specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>', 'ListAggregatedUtterancesResponse$nextToken' => '<p>A token that indicates whether there are more results to return in a response to the <code>ListAggregatedUtterances</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListAggregatedUtterances</code> operation request to get the next page of results.</p>', 'ListBotAliasReplicasRequest$nextToken' => '<p>The request for the next token for the replicated bot created from the source bot alias.</p>', 'ListBotAliasReplicasResponse$nextToken' => '<p>The next token for the replicated bots created from the source bot alias.</p>', 'ListBotAliasesRequest$nextToken' => '<p>If the response from the <code>ListBotAliases</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>', 'ListBotAliasesResponse$nextToken' => '<p>A token that indicates whether there are more results to return in a response to the <code>ListBotAliases</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListBotAliases</code> operation request to get the next page of results.</p>', 'ListBotLocalesRequest$nextToken' => '<p>If the response from the <code>ListBotLocales</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token as the <code>nextToken</code> parameter to return the next page of results. </p>', 'ListBotLocalesResponse$nextToken' => '<p>A token that indicates whether there are more results to return in a response to the <code>ListBotLocales</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListBotLocales</code> operation request to get the next page of results.</p>', 'ListBotRecommendationsRequest$nextToken' => '<p>If the response from the ListBotRecommendation operation contains more results than specified in the maxResults parameter, a token is returned in the response. Use that token in the nextToken parameter to return the next page of results.</p>', 'ListBotRecommendationsResponse$nextToken' => '<p>A token that indicates whether there are more results to return in a response to the ListBotRecommendations operation. If the nextToken field is present, you send the contents as the nextToken parameter of a ListBotRecommendations operation request to get the next page of results. </p>', 'ListBotResourceGenerationsRequest$nextToken' => '<p>If the total number of results is greater than the number specified in the <code>maxResults</code>, the response returns a token in the <code>nextToken</code> field. Use this token when making a request to return the next batch of results.</p>', 'ListBotResourceGenerationsResponse$nextToken' => '<p>If the total number of results is greater than the number specified in the <code>maxResults</code>, the response returns a token in the <code>nextToken</code> field. Use this token when making a request to return the next batch of results.</p>', 'ListBotVersionReplicasRequest$nextToken' => '<p>The next token given in the list of replicated bots.</p>', 'ListBotVersionReplicasResponse$nextToken' => '<p>The next token used for the replicated bots in the list of replicated bots.</p>', 'ListBotVersionsRequest$nextToken' => '<p>If the response to the <code>ListBotVersion</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>', 'ListBotVersionsResponse$nextToken' => '<p>A token that indicates whether there are more results to return in a response to the <code>ListBotVersions</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListBotAliases</code> operation request to get the next page of results.</p>', 'ListBotsRequest$nextToken' => '<p>If the response from the <code>ListBots</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. </p> <p>Use the returned token in the <code>nextToken</code> parameter of a <code>ListBots</code> request to return the next page of results. For a complete set of results, call the <code>ListBots</code> operation until the <code>nextToken</code> returned in the response is null.</p>', 'ListBotsResponse$nextToken' => '<p>A token that indicates whether there are more results to return in a response to the <code>ListBots</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListBots</code> operation request to get the next page of results.</p>', 'ListBuiltInIntentsRequest$nextToken' => '<p>If the response from the <code>ListBuiltInIntents</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>', 'ListBuiltInIntentsResponse$nextToken' => '<p>A token that indicates whether there are more results to return in a response to the <code>ListBuiltInIntents</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListBotAliases</code> operation request to get the next page of results.</p>', 'ListBuiltInSlotTypesRequest$nextToken' => '<p>If the response from the <code>ListBuiltInSlotTypes</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>', 'ListBuiltInSlotTypesResponse$nextToken' => '<p>A token that indicates whether there are more results to return in a response to the <code>ListBuiltInSlotTypes</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>LIstBuiltInSlotTypes</code> operation request to get the next page of results.</p>', 'ListCustomVocabularyItemsRequest$nextToken' => '<p>The nextToken identifier to the list custom vocabulary request.</p>', 'ListCustomVocabularyItemsResponse$nextToken' => '<p>The nextToken identifier to the list custom vocabulary response.</p>', 'ListExportsRequest$nextToken' => '<p>If the response from the <code>ListExports</code> operation contains more results that specified in the <code>maxResults</code> parameter, a token is returned in the response. </p> <p>Use the returned token in the <code>nextToken</code> parameter of a <code>ListExports</code> request to return the next page of results. For a complete set of results, call the <code>ListExports</code> operation until the <code>nextToken</code> returned in the response is null.</p>', 'ListExportsResponse$nextToken' => '<p>A token that indicates whether there are more results to return in a response to the <code>ListExports</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListExports</code> operation request to get the next page of results.</p>', 'ListImportsRequest$nextToken' => '<p>If the response from the <code>ListImports</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response.</p> <p>Use the returned token in the <code>nextToken</code> parameter of a <code>ListImports</code> request to return the next page of results. For a complete set of results, call the <code>ListImports</code> operation until the <code>nextToken</code> returned in the response is null.</p>', 'ListImportsResponse$nextToken' => '<p>A token that indicates whether there are more results to return in a response to the <code>ListImports</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListImports</code> operation request to get the next page of results.</p>', 'ListIntentMetricsRequest$nextToken' => '<p>If the response from the ListIntentMetrics operation contains more results than specified in the maxResults parameter, a token is returned in the response.</p> <p>Use the returned token in the nextToken parameter of a ListIntentMetrics request to return the next page of results. For a complete set of results, call the ListIntentMetrics operation until the nextToken returned in the response is null.</p>', 'ListIntentMetricsResponse$nextToken' => '<p>If the response from the ListIntentMetrics operation contains more results than specified in the maxResults parameter, a token is returned in the response.</p> <p>Use the returned token in the nextToken parameter of a ListIntentMetrics request to return the next page of results. For a complete set of results, call the ListIntentMetrics operation until the nextToken returned in the response is null.</p>', 'ListIntentStageMetricsRequest$nextToken' => '<p>If the response from the ListIntentStageMetrics operation contains more results than specified in the maxResults parameter, a token is returned in the response.</p> <p>Use the returned token in the nextToken parameter of a ListIntentStageMetrics request to return the next page of results. For a complete set of results, call the ListIntentStageMetrics operation until the nextToken returned in the response is null.</p>', 'ListIntentStageMetricsResponse$nextToken' => '<p>If the response from the ListIntentStageMetrics operation contains more results than specified in the maxResults parameter, a token is returned in the response.</p> <p>Use the returned token in the nextToken parameter of a ListIntentStageMetrics request to return the next page of results. For a complete set of results, call the ListIntentStageMetrics operation until the nextToken returned in the response is null.</p>', 'ListIntentsRequest$nextToken' => '<p>If the response from the <code>ListIntents</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response.</p> <p>Use the returned token in the <code>nextToken</code> parameter of a <code>ListIntents</code> request to return the next page of results. For a complete set of results, call the <code>ListIntents</code> operation until the <code>nextToken</code> returned in the response is null.</p>', 'ListIntentsResponse$nextToken' => '<p>A token that indicates whether there are more results to return in a response to the <code>ListIntents</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListIntents</code> operation request to get the next page of results.</p>', 'ListRecommendedIntentsRequest$nextToken' => '<p>If the response from the ListRecommendedIntents operation contains more results than specified in the maxResults parameter, a token is returned in the response. Use that token in the nextToken parameter to return the next page of results.</p>', 'ListRecommendedIntentsResponse$nextToken' => '<p>A token that indicates whether there are more results to return in a response to the ListRecommendedIntents operation. If the nextToken field is present, you send the contents as the nextToken parameter of a ListRecommendedIntents operation request to get the next page of results.</p>', 'ListSessionAnalyticsDataRequest$nextToken' => '<p>If the response from the ListSessionAnalyticsData operation contains more results than specified in the maxResults parameter, a token is returned in the response.</p> <p>Use the returned token in the nextToken parameter of a ListSessionAnalyticsData request to return the next page of results. For a complete set of results, call the ListSessionAnalyticsData operation until the nextToken returned in the response is null.</p>', 'ListSessionAnalyticsDataResponse$nextToken' => '<p>If the response from the ListSessionAnalyticsData operation contains more results than specified in the maxResults parameter, a token is returned in the response.</p> <p>Use the returned token in the nextToken parameter of a ListSessionAnalyticsData request to return the next page of results. For a complete set of results, call the ListSessionAnalyticsData operation until the nextToken returned in the response is null.</p>', 'ListSessionMetricsRequest$nextToken' => '<p>If the response from the ListSessionMetrics operation contains more results than specified in the maxResults parameter, a token is returned in the response.</p> <p>Use the returned token in the nextToken parameter of a ListSessionMetrics request to return the next page of results. For a complete set of results, call the ListSessionMetrics operation until the nextToken returned in the response is null.</p>', 'ListSessionMetricsResponse$nextToken' => '<p>If the response from the ListSessionMetrics operation contains more results than specified in the maxResults parameter, a token is returned in the response.</p> <p>Use the returned token in the nextToken parameter of a ListSessionMetrics request to return the next page of results. For a complete set of results, call the ListSessionMetrics operation until the nextToken returned in the response is null.</p>', 'ListSlotTypesRequest$nextToken' => '<p>If the response from the <code>ListSlotTypes</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>', 'ListSlotTypesResponse$nextToken' => '<p>A token that indicates whether there are more results to return in a response to the <code>ListSlotTypes</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListSlotTypes</code> operation request to get the next page of results.</p>', 'ListSlotsRequest$nextToken' => '<p>If the response from the <code>ListSlots</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>', 'ListSlotsResponse$nextToken' => '<p>A token that indicates whether there are more results to return in a response to the <code>ListSlots</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListSlots</code> operation request to get the next page of results.</p>', 'ListTestExecutionResultItemsRequest$nextToken' => '<p>If the response from the <code>ListTestExecutionResultItems</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>', 'ListTestExecutionResultItemsResponse$nextToken' => '<p>A token that indicates whether there are more results to return in a response to the <code>ListTestExecutionResultItems</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListTestExecutionResultItems</code> operation request to get the next page of results.</p>', 'ListTestExecutionsRequest$nextToken' => '<p>If the response from the ListTestExecutions operation contains more results than specified in the maxResults parameter, a token is returned in the response. Use that token in the nextToken parameter to return the next page of results.</p>', 'ListTestExecutionsResponse$nextToken' => '<p>A token that indicates whether there are more results to return in a response to the ListTestExecutions operation. If the nextToken field is present, you send the contents as the nextToken parameter of a ListTestExecutions operation request to get the next page of results.</p>', 'ListTestSetRecordsRequest$nextToken' => '<p>If the response from the ListTestSetRecords operation contains more results than specified in the maxResults parameter, a token is returned in the response. Use that token in the nextToken parameter to return the next page of results.</p>', 'ListTestSetRecordsResponse$nextToken' => '<p>A token that indicates whether there are more records to return in a response to the ListTestSetRecords operation. If the nextToken field is present, you send the contents as the nextToken parameter of a ListTestSetRecords operation request to get the next page of records.</p>', 'ListTestSetsRequest$nextToken' => '<p>If the response from the ListTestSets operation contains more results than specified in the maxResults parameter, a token is returned in the response. Use that token in the nextToken parameter to return the next page of results.</p>', 'ListTestSetsResponse$nextToken' => '<p>A token that indicates whether there are more results to return in a response to the ListTestSets operation. If the nextToken field is present, you send the contents as the nextToken parameter of a ListTestSets operation request to get the next page of results.</p>', 'ListUtteranceAnalyticsDataRequest$nextToken' => '<p>If the response from the ListUtteranceAnalyticsData operation contains more results than specified in the maxResults parameter, a token is returned in the response.</p> <p>Use the returned token in the nextToken parameter of a ListUtteranceAnalyticsData request to return the next page of results. For a complete set of results, call the ListUtteranceAnalyticsData operation until the nextToken returned in the response is null.</p>', 'ListUtteranceAnalyticsDataResponse$nextToken' => '<p>If the response from the ListUtteranceAnalyticsData operation contains more results than specified in the maxResults parameter, a token is returned in the response.</p> <p>Use the returned token in the nextToken parameter of a ListUtteranceAnalyticsData request to return the next page of results. For a complete set of results, call the ListUtteranceAnalyticsData operation until the nextToken returned in the response is null.</p>', 'ListUtteranceMetricsRequest$nextToken' => '<p>If the response from the ListUtteranceMetrics operation contains more results than specified in the maxResults parameter, a token is returned in the response.</p> <p>Use the returned token in the nextToken parameter of a ListUtteranceMetrics request to return the next page of results. For a complete set of results, call the ListUtteranceMetrics operation until the nextToken returned in the response is null.</p>', 'ListUtteranceMetricsResponse$nextToken' => '<p>If the response from the ListUtteranceMetrics operation contains more results than specified in the maxResults parameter, a token is returned in the response.</p> <p>Use the returned token in the nextToken parameter of a ListUtteranceMetrics request to return the next page of results. For a complete set of results, call the ListUtteranceMetrics operation until the nextToken returned in the response is null.</p>', ], ], 'NonEmptyString' => [ 'base' => NULL, 'refs' => [ 'ExecutionErrorDetails$errorCode' => '<p>The error code for the error.</p>', 'ExecutionErrorDetails$errorMessage' => '<p>The message describing the error.</p>', 'SlotValue$interpretedValue' => '<p>The value that Amazon Lex determines for the slot. The actual value depends on the setting of the value selection strategy for the bot. You can choose to use the value entered by the user, or you can have Amazon Lex choose the first value in the <code>resolvedValues</code> list.</p>', 'StringMap$key' => NULL, 'UserTurnSlotOutput$value' => '<p>The value output by the slot recognition.</p>', ], ], 'NumericalBotVersion' => [ 'base' => NULL, 'refs' => [ 'BotSummary$latestBotVersion' => '<p>The latest numerical version in use for the bot.</p>', 'CreateBotAliasRequest$botVersion' => '<p>The version of the bot that this alias points to. You can use the <a href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_UpdateBotAlias.html">UpdateBotAlias</a> operation to change the bot version associated with the alias.</p>', 'CreateBotAliasResponse$botVersion' => '<p>The version of the bot associated with this alias.</p>', 'CreateBotVersionResponse$botVersion' => '<p>The version number assigned to the version.</p>', 'DeleteBotVersionRequest$botVersion' => '<p>The version of the bot to delete.</p>', 'DeleteBotVersionResponse$botVersion' => '<p>The version of the bot that is being deleted.</p>', 'DescribeBotVersionRequest$botVersion' => '<p>The version of the bot to return metadata for.</p>', 'DescribeBotVersionResponse$botVersion' => '<p>The version of the bot that was described.</p>', 'SessionSpecification$botVersion' => '<p>The version of the bot that the session was held with.</p>', 'UtteranceSpecification$botVersion' => '<p>The version of the bot that the utterance was made to.</p>', ], ], 'OSIncludeFields' => [ 'base' => NULL, 'refs' => [ 'OpensearchConfiguration$includeFields' => '<p>Contains a list of fields from the Amazon OpenSearch Service that the model can use to generate the answer to the query.</p>', ], ], 'OSIndexName' => [ 'base' => NULL, 'refs' => [ 'OpensearchConfiguration$indexName' => '<p>The name of the Amazon OpenSearch Service index.</p>', ], ], 'ObfuscationSetting' => [ 'base' => '<p>Determines whether Amazon Lex obscures slot values in conversation logs. </p>', 'refs' => [ 'CreateSlotRequest$obfuscationSetting' => '<p>Determines how slot values are used in Amazon CloudWatch logs. If the value of the <code>obfuscationSetting</code> parameter is <code>DefaultObfuscation</code>, slot values are obfuscated in the log output. If the value is <code>None</code>, the actual value is present in the log output.</p> <p>The default is to obfuscate values in the CloudWatch logs.</p>', 'CreateSlotResponse$obfuscationSetting' => '<p>Indicates whether the slot is configured to obfuscate values in Amazon CloudWatch logs.</p>', 'DescribeSlotResponse$obfuscationSetting' => '<p>Whether slot values are shown in Amazon CloudWatch logs. If the value is <code>None</code>, the actual value of the slot is shown in logs.</p>', 'UpdateSlotRequest$obfuscationSetting' => '<p>New settings that determine how slot values are formatted in Amazon CloudWatch logs. </p>', 'UpdateSlotResponse$obfuscationSetting' => '<p>The updated setting that determines whether the slot value is obfuscated in the Amazon CloudWatch logs.</p>', ], ], 'ObfuscationSettingType' => [ 'base' => NULL, 'refs' => [ 'ObfuscationSetting$obfuscationSettingType' => '<p>Value that determines whether Amazon Lex obscures slot values in conversation logs. The default is to obscure the values.</p>', ], ], 'ObjectPrefix' => [ 'base' => NULL, 'refs' => [ 'ObjectPrefixes$member' => NULL, ], ], 'ObjectPrefixes' => [ 'base' => NULL, 'refs' => [ 'PathFormat$objectPrefixes' => '<p>A list of Amazon S3 prefixes that points to sub-folders in the Amazon S3 bucket. Specify this list if you only want Lex to read the files under this set of sub-folders.</p>', ], ], 'OpensearchConfiguration' => [ 'base' => '<p>Contains details about the configuration of the Amazon OpenSearch Service database used for the <code>AMAZON.QnAIntent</code>.</p>', 'refs' => [ 'DataSourceConfiguration$opensearchConfiguration' => '<p>Contains details about the configuration of the Amazon OpenSearch Service database used for the <code>AMAZON.QnAIntent</code>. To create a domain, follow the steps at <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html">Creating and managing Amazon OpenSearch Service domains</a>.</p>', ], ], 'Operation' => [ 'base' => NULL, 'refs' => [ 'OperationList$member' => NULL, ], ], 'OperationList' => [ 'base' => NULL, 'refs' => [ 'CreateResourcePolicyStatementRequest$action' => '<p>The Amazon Lex action that this policy either allows or denies. The action must apply to the resource type of the specified ARN. For more information, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlexv2.html"> Actions, resources, and condition keys for Amazon Lex V2</a>.</p>', ], ], 'OutputContext' => [ 'base' => '<p>Describes a session context that is activated when an intent is fulfilled.</p>', 'refs' => [ 'OutputContextsList$member' => NULL, ], ], 'OutputContextsList' => [ 'base' => NULL, 'refs' => [ 'CreateIntentRequest$outputContexts' => '<p>A lists of contexts that the intent activates when it is fulfilled.</p> <p>You can use an output context to indicate the intents that Amazon Lex should consider for the next turn of the conversation with a customer. </p> <p>When you use the <code>outputContextsList</code> property, all of the contexts specified in the list are activated when the intent is fulfilled. You can set up to 10 output contexts. You can also set the number of conversation turns that the context should be active, or the length of time that the context should be active.</p>', 'CreateIntentResponse$outputContexts' => '<p>The list of output contexts specified for the intent.</p>', 'DescribeIntentResponse$outputContexts' => '<p>A list of contexts that are activated when the intent is fulfilled.</p>', 'IntentSummary$outputContexts' => '<p>The output contexts that are activated when this intent is fulfilled.</p>', 'UpdateIntentRequest$outputContexts' => '<p>A new list of contexts that Amazon Lex activates when the intent is fulfilled.</p>', 'UpdateIntentResponse$outputContexts' => '<p>The updated list of contexts that Amazon Lex activates when the intent is fulfilled.</p>', ], ], 'OverallTestResultItem' => [ 'base' => '<p>Information about the overall results for a test execution result.</p>', 'refs' => [ 'OverallTestResultItemList$member' => NULL, ], ], 'OverallTestResultItemList' => [ 'base' => NULL, 'refs' => [ 'OverallTestResults$items' => '<p>A list of the overall test results.</p>', ], ], 'OverallTestResults' => [ 'base' => '<p>Information about the overall test results.</p>', 'refs' => [ 'TestExecutionResultItems$overallTestResults' => '<p>Overall results for the test execution, including the breakdown of conversations and single-input utterances.</p>', ], ], 'ParentBotNetwork' => [ 'base' => '<p>A network of bots.</p>', 'refs' => [ 'ParentBotNetworks$member' => NULL, ], ], 'ParentBotNetworks' => [ 'base' => NULL, 'refs' => [ 'DescribeBotAliasResponse$parentBotNetworks' => '<p>A list of the networks to which the bot alias you described belongs.</p>', 'DescribeBotVersionResponse$parentBotNetworks' => '<p>A list of the networks to which the bot version you described belongs.</p>', ], ], 'PathFormat' => [ 'base' => '<p>The object that contains a path format that will be applied when Amazon Lex reads the transcript file in the bucket you provide. Specify this object if you only want Lex to read a subset of files in your Amazon S3 bucket.</p>', 'refs' => [ 'S3BucketTranscriptSource$pathFormat' => '<p>The object that contains a path format that will be applied when Amazon Lex reads the transcript file in the bucket you provide. Specify this object if you only want Lex to read a subset of files in your Amazon S3 bucket.</p>', ], ], 'Phrase' => [ 'base' => NULL, 'refs' => [ 'CustomVocabularyItem$phrase' => '<p>The unique phrase for the custom vocabulary item from the custom vocabulary list.</p>', 'CustomVocabularyItem$displayAs' => '<p>The DisplayAs value for the custom vocabulary item from the custom vocabulary list.</p>', 'NewCustomVocabularyItem$phrase' => '<p>The unique phrase for the new custom vocabulary item from the custom vocabulary list.</p>', 'NewCustomVocabularyItem$displayAs' => '<p>The display as value assigned to the new custom vocabulary item from the custom vocabulary list.</p>', ], ], 'PlainTextMessage' => [ 'base' => '<p>Defines an ASCII text message to send to the user.</p>', 'refs' => [ 'Message$plainTextMessage' => '<p>A message in plain text format.</p>', ], ], 'PlainTextMessageValue' => [ 'base' => NULL, 'refs' => [ 'PlainTextMessage$value' => '<p>The message to send to the user.</p>', ], ], 'Policy' => [ 'base' => NULL, 'refs' => [ 'CreateResourcePolicyRequest$policy' => '<p>A resource policy to add to the resource. The policy is a JSON structure that contains one or more statements that define the policy. The policy must follow the IAM syntax. For more information about the contents of a JSON policy document, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html"> IAM JSON policy reference </a>. </p> <p>If the policy isn\'t valid, Amazon Lex returns a validation exception.</p>', 'DescribeResourcePolicyResponse$policy' => '<p>The JSON structure that contains the resource policy. For more information about the contents of a JSON policy document, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html"> IAM JSON policy reference </a>.</p>', 'UpdateResourcePolicyRequest$policy' => '<p>A resource policy to add to the resource. The policy is a JSON structure that contains one or more statements that define the policy. The policy must follow the IAM syntax. For more information about the contents of a JSON policy document, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html"> IAM JSON policy reference </a>. </p> <p>If the policy isn\'t valid, Amazon Lex returns a validation exception.</p>', ], ], 'PostDialogCodeHookInvocationSpecification' => [ 'base' => '<p>Specifies next steps to run after the dialog code hook finishes.</p>', 'refs' => [ 'DialogCodeHookInvocationSetting$postCodeHookSpecification' => '<p>Contains the responses and actions that Amazon Lex takes after the Lambda function is complete.</p>', ], ], 'PostFulfillmentStatusSpecification' => [ 'base' => '<p>Provides a setting that determines whether the post-fulfillment response is sent to the user. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/streaming-progress.html#progress-complete">https://docs.aws.amazon.com/lexv2/latest/dg/streaming-progress.html#progress-complete</a> </p>', 'refs' => [ 'FulfillmentCodeHookSettings$postFulfillmentStatusSpecification' => '<p>Provides settings for messages sent to the user for after the Lambda fulfillment function completes. Post-fulfillment messages can be sent for both streaming and non-streaming conversations.</p>', ], ], 'PreconditionFailedException' => [ 'base' => '<p>Your request couldn\'t be completed because one or more request fields aren\'t valid. Check the fields in your request and try again.</p>', 'refs' => [], ], 'PresignedS3Url' => [ 'base' => NULL, 'refs' => [ 'BotRecommendationResults$botLocaleExportUrl' => '<p>The presigned URL link of the recommended bot definition.</p>', 'BotRecommendationResults$associatedTranscriptsUrl' => '<p>The presigned url link of the associated transcript.</p>', 'CreateUploadUrlResponse$uploadUrl' => '<p>A pre-signed S3 write URL. Upload the zip archive file that contains the definition of your bot or bot locale.</p>', 'DescribeBotResourceGenerationResponse$generatedBotLocaleUrl' => '<p>The Amazon S3 location of the generated bot locale configuration.</p>', 'DescribeExportResponse$downloadUrl' => '<p>A pre-signed S3 URL that points to the bot or bot locale archive. The URL is only available for 5 minutes after calling the <code>DescribeExport</code> operation.</p>', 'DescribeTestSetDiscrepancyReportResponse$testSetDiscrepancyRawOutputUrl' => '<p>Pre-signed Amazon S3 URL to download the test set discrepancy report.</p>', 'GetTestExecutionArtifactsUrlResponse$downloadArtifactsUrl' => '<p>The pre-signed Amazon S3 URL to download completed test execution.</p>', ], ], 'Principal' => [ 'base' => '<p>The IAM principal that you allowing or denying access to an Amazon Lex action. You must provide a <code>service</code> or an <code>arn</code>, but not both in the same statement. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html"> AWS JSON policy elements: Principal </a>.</p>', 'refs' => [ 'PrincipalList$member' => NULL, ], ], 'PrincipalArn' => [ 'base' => NULL, 'refs' => [ 'Principal$arn' => '<p>The Amazon Resource Name (ARN) of the principal.</p>', ], ], 'PrincipalList' => [ 'base' => NULL, 'refs' => [ 'CreateResourcePolicyStatementRequest$principal' => '<p>An IAM principal, such as an IAM user, IAM role, or Amazon Web Services services that is allowed or denied access to a resource. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html">Amazon Web Services JSON policy elements: Principal</a>.</p>', ], ], 'PriorityValue' => [ 'base' => NULL, 'refs' => [ 'SlotPriority$priority' => '<p>The priority that Amazon Lex should apply to the slot.</p>', ], ], 'PromptAttempt' => [ 'base' => '<p>The attempt name of attempts of a prompt.</p>', 'refs' => [ 'PromptAttemptsSpecificationMap$key' => NULL, ], ], 'PromptAttemptSpecification' => [ 'base' => '<p>Specifies the settings on a prompt attempt.</p>', 'refs' => [ 'PromptAttemptsSpecificationMap$value' => NULL, ], ], 'PromptAttemptsSpecificationMap' => [ 'base' => NULL, 'refs' => [ 'PromptSpecification$promptAttemptsSpecification' => '<p>Specifies the advanced settings on each attempt of the prompt.</p>', ], ], 'PromptMaxRetries' => [ 'base' => NULL, 'refs' => [ 'PromptSpecification$maxRetries' => '<p>The maximum number of times the bot tries to elicit a response from the user using this prompt.</p>', ], ], 'PromptSpecification' => [ 'base' => '<p>Specifies a list of message groups that Amazon Lex sends to a user to elicit a response.</p>', 'refs' => [ 'IntentConfirmationSetting$promptSpecification' => '<p>Prompts the user to confirm the intent. This question should have a yes or no answer.</p> <p>Amazon Lex uses this prompt to ensure that the user acknowledges that the intent is ready for fulfillment. For example, with the <code>OrderPizza</code> intent, you might want to confirm that the order is correct before placing it. For other intents, such as intents that simply respond to user questions, you might not need to ask the user for confirmation before providing the information. </p>', 'SlotSummary$valueElicitationPromptSpecification' => '<p>Prompts that are sent to the user to elicit a value for the slot.</p>', 'SlotValueElicitationSetting$promptSpecification' => '<p>The prompt that Amazon Lex uses to elicit the slot value from the user.</p>', 'SubSlotValueElicitationSetting$promptSpecification' => NULL, ], ], 'QnAIntentConfiguration' => [ 'base' => '<p>Details about the the configuration of the built-in <code>Amazon.QnAIntent</code>.</p>', 'refs' => [ 'CreateIntentRequest$qnAIntentConfiguration' => '<p>Specifies the configuration of the built-in <code>Amazon.QnAIntent</code>. The <code>AMAZON.QnAIntent</code> intent is called when Amazon Lex can\'t determine another intent to invoke. If you specify this field, you can\'t specify the <code>kendraConfiguration</code> field.</p>', 'CreateIntentResponse$qnAIntentConfiguration' => '<p>Details about the the configuration of the built-in <code>Amazon.QnAIntent</code>.</p>', 'DescribeIntentResponse$qnAIntentConfiguration' => '<p>Details about the configuration of the built-in <code>Amazon.QnAIntent</code>.</p>', 'UpdateIntentRequest$qnAIntentConfiguration' => '<p>Specifies the configuration of the built-in <code>Amazon.QnAIntent</code>. The <code>AMAZON.QnAIntent</code> intent is called when Amazon Lex can\'t determine another intent to invoke. If you specify this field, you can\'t specify the <code>kendraConfiguration</code> field.</p>', 'UpdateIntentResponse$qnAIntentConfiguration' => '<p>Details about the configuration of the built-in <code>Amazon.QnAIntent</code>.</p>', ], ], 'QnAKendraConfiguration' => [ 'base' => '<p>Contains details about the configuration of the Amazon Kendra index used for the <code>AMAZON.QnAIntent</code>.</p>', 'refs' => [ 'DataSourceConfiguration$kendraConfiguration' => '<p>Contains details about the configuration of the Amazon Kendra index used for the <code>AMAZON.QnAIntent</code>. To create a Amazon Kendra index, follow the steps at <a href="https://docs.aws.amazon.com/kendra/latest/dg/create-index.html">Creating an index</a>.</p>', ], ], 'QueryFilterString' => [ 'base' => NULL, 'refs' => [ 'KendraConfiguration$queryFilterString' => '<p>A query filter that Amazon Lex sends to Amazon Kendra to filter the response from a query. The filter is in the format defined by Amazon Kendra. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/filtering.html">Filtering queries</a>.</p>', 'QnAKendraConfiguration$queryFilterString' => '<p>Contains the Amazon Kendra filter string to use if enabled. For more information on the Amazon Kendra search filter JSON format, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/filtering.html#search-filtering">Using document attributes to filter search results</a>.</p>', ], ], 'QuestionField' => [ 'base' => NULL, 'refs' => [ 'ExactResponseFields$questionField' => '<p>The name of the field that contains the query made to the OpenSearch Service database.</p>', ], ], 'RecommendedAction' => [ 'base' => NULL, 'refs' => [ 'RecommendedActions$member' => NULL, ], ], 'RecommendedActions' => [ 'base' => NULL, 'refs' => [ 'DescribeBotLocaleResponse$recommendedActions' => '<p>Recommended actions to take to resolve an error in the <code>failureReasons</code> field.</p>', 'UpdateBotLocaleResponse$recommendedActions' => '<p>Recommended actions to take to resolve an error in the <code>failureReasons</code> field.</p>', ], ], 'RecommendedIntentSummary' => [ 'base' => '<p>An object that contains a summary of a recommended intent.</p>', 'refs' => [ 'RecommendedIntentSummaryList$member' => NULL, ], ], 'RecommendedIntentSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListRecommendedIntentsResponse$summaryList' => '<p>Summary information for the intents that meet the filter criteria specified in the request. The length of the list is specified in the maxResults parameter of the request. If there are more intents available, the nextToken field contains a token to get the next page of results.</p>', ], ], 'RecordNumber' => [ 'base' => NULL, 'refs' => [ 'TestSetTurnRecord$recordNumber' => '<p>The record number associated with the turn.</p>', 'UtteranceLevelTestResultItem$recordNumber' => '<p>The record number of the result.</p>', ], ], 'RegexPattern' => [ 'base' => NULL, 'refs' => [ 'SlotValueRegexFilter$pattern' => '<p>A regular expression used to validate the value of a slot.</p> <p> Use a standard regular expression. Amazon Lex supports the following characters in the regular expression: </p> <ul> <li> <p>A-Z, a-z</p> </li> <li> <p>0-9</p> </li> <li> <p>Unicode characters ("\\⁠u&lt;Unicode&gt;")</p> </li> </ul> <p> Represent Unicode characters with four digits, for example "\\⁠u0041" or "\\⁠u005A". </p> <p> The following regular expression operators are not supported: </p> <ul> <li> <p>Infinite repeaters: *, +, or {x,} with no upper bound.</p> </li> <li> <p>Wild card (.)</p> </li> </ul>', ], ], 'RelativeAggregationDuration' => [ 'base' => '<p>Specifies the time window that utterance statistics are returned for. The time window is always relative to the last time that the that utterances were aggregated. For example, if the <code>ListAggregatedUtterances</code> operation is called at 1600, the time window is set to 1 hour, and the last refresh time was 1530, only utterances made between 1430 and 1530 are returned.</p> <p>You can choose the time window that statistics should be returned for.</p> <ul> <li> <p> <b>Hours</b> - You can request utterance statistics for 1, 3, 6, 12, or 24 hour time windows. Statistics are refreshed every half hour for 1 hour time windows, and hourly for the other time windows.</p> </li> <li> <p> <b>Days</b> - You can request utterance statistics for 3 days. Statistics are refreshed every 6 hours.</p> </li> <li> <p> <b>Weeks</b> - You can see statistics for one or two weeks. Statistics are refreshed every 12 hours for one week time windows, and once per day for two week time windows.</p> </li> </ul>', 'refs' => [ 'UtteranceAggregationDuration$relativeAggregationDuration' => '<p>The desired time window for aggregating utterances. </p>', ], ], 'ReplicaRegion' => [ 'base' => '<p>The region that contains the replicated bots. Minimum value = 2, maximum value = 25.</p>', 'refs' => [ 'BotReplicaSummary$replicaRegion' => '<p>The replica region used in the replication statuses summary.</p>', 'CreateBotReplicaRequest$replicaRegion' => '<p>The request for the secondary region that will be used in the replication of the source bot.</p>', 'CreateBotReplicaResponse$replicaRegion' => '<p>The region of the replicated bot generated.</p>', 'CreateBotReplicaResponse$sourceRegion' => '<p>The source region for the source bot used for the replicated bot generated.</p>', 'DeleteBotReplicaRequest$replicaRegion' => '<p>The secondary region of the replicated bot that will be deleted.</p>', 'DeleteBotReplicaResponse$replicaRegion' => '<p>The region of the replicated bot generated.</p>', 'DescribeBotReplicaRequest$replicaRegion' => '<p>The request for the region of the replicated bot being monitored.</p>', 'DescribeBotReplicaResponse$replicaRegion' => '<p>The region of the replicated bot being monitored.</p>', 'DescribeBotReplicaResponse$sourceRegion' => '<p>The source region of the replicated bot being monitored.</p>', 'ListBotAliasReplicasRequest$replicaRegion' => '<p>The request for the secondary region of the replicated bot created from the source bot alias.</p>', 'ListBotAliasReplicasResponse$sourceRegion' => '<p>The source region of the replicated bot created from the source bot alias.</p>', 'ListBotAliasReplicasResponse$replicaRegion' => '<p>The secondary region of the replicated bot created from the source bot alias.</p>', 'ListBotReplicasResponse$sourceRegion' => '<p>The source region of the source bots in the list of replicated bots.</p>', 'ListBotVersionReplicasRequest$replicaRegion' => '<p>The request for the region used in the list of replicated bots.</p>', 'ListBotVersionReplicasResponse$sourceRegion' => '<p>The source region used for the bots in the list of replicated bots.</p>', 'ListBotVersionReplicasResponse$replicaRegion' => '<p>The region used for the replicated bots in the list of replicated bots.</p>', ], ], 'ResourceCount' => [ 'base' => NULL, 'refs' => [ 'DescribeBotLocaleResponse$intentsCount' => '<p>The number of intents defined for the locale.</p>', 'DescribeBotLocaleResponse$slotTypesCount' => '<p>The number of slot types defined for the locale.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>You asked to describe a resource that doesn\'t exist. Check the resource that you are requesting and try again.</p>', 'refs' => [], ], 'ResponseSpecification' => [ 'base' => '<p>Specifies a list of message groups that Amazon Lex uses to respond the user input.</p>', 'refs' => [ 'ConditionalBranch$response' => NULL, 'DefaultConditionalBranch$response' => NULL, 'InitialResponseSetting$initialResponse' => NULL, 'IntentClosingSetting$closingResponse' => '<p>The response that Amazon Lex sends to the user when the intent is complete.</p>', 'IntentConfirmationSetting$declinationResponse' => '<p>When the user answers "no" to the question defined in <code>promptSpecification</code>, Amazon Lex responds with this response to acknowledge that the intent was canceled. </p>', 'IntentConfirmationSetting$confirmationResponse' => NULL, 'IntentConfirmationSetting$failureResponse' => NULL, 'PostDialogCodeHookInvocationSpecification$successResponse' => NULL, 'PostDialogCodeHookInvocationSpecification$failureResponse' => NULL, 'PostDialogCodeHookInvocationSpecification$timeoutResponse' => NULL, 'PostFulfillmentStatusSpecification$successResponse' => NULL, 'PostFulfillmentStatusSpecification$failureResponse' => NULL, 'PostFulfillmentStatusSpecification$timeoutResponse' => NULL, 'SlotCaptureSetting$captureResponse' => NULL, 'SlotCaptureSetting$failureResponse' => NULL, 'WaitAndContinueSpecification$waitingResponse' => '<p>The response that Amazon Lex sends to indicate that the bot is waiting for the conversation to continue.</p>', 'WaitAndContinueSpecification$continueResponse' => '<p>The response that Amazon Lex sends to indicate that the bot is ready to continue the conversation.</p>', ], ], 'RetryAfterSeconds' => [ 'base' => NULL, 'refs' => [ 'ThrottlingException$retryAfterSeconds' => '<p>The number of seconds after which the user can invoke the API again.</p>', ], ], 'RevisionId' => [ 'base' => NULL, 'refs' => [ 'CreateResourcePolicyResponse$revisionId' => '<p>The current revision of the resource policy. Use the revision ID to make sure that you are updating the most current version of a resource policy when you add a policy statement to a resource, delete a resource, or update a resource.</p>', 'CreateResourcePolicyStatementRequest$expectedRevisionId' => '<p>The identifier of the revision of the policy to edit. If this revision ID doesn\'t match the current revision ID, Amazon Lex throws an exception.</p> <p>If you don\'t specify a revision, Amazon Lex overwrites the contents of the policy with the new values.</p>', 'CreateResourcePolicyStatementResponse$revisionId' => '<p>The current revision of the resource policy. Use the revision ID to make sure that you are updating the most current version of a resource policy when you add a policy statement to a resource, delete a resource, or update a resource.</p>', 'DeleteResourcePolicyRequest$expectedRevisionId' => '<p>The identifier of the revision to edit. If this ID doesn\'t match the current revision number, Amazon Lex returns an exception</p> <p>If you don\'t specify a revision ID, Amazon Lex will delete the current policy.</p>', 'DeleteResourcePolicyResponse$revisionId' => '<p>The current revision of the resource policy. Use the revision ID to make sure that you are updating the most current version of a resource policy when you add a policy statement to a resource, delete a resource, or update a resource.</p>', 'DeleteResourcePolicyStatementRequest$expectedRevisionId' => '<p>The identifier of the revision of the policy to delete the statement from. If this revision ID doesn\'t match the current revision ID, Amazon Lex throws an exception.</p> <p>If you don\'t specify a revision, Amazon Lex removes the current contents of the statement. </p>', 'DeleteResourcePolicyStatementResponse$revisionId' => '<p>The current revision of the resource policy. Use the revision ID to make sure that you are updating the most current version of a resource policy when you add a policy statement to a resource, delete a resource, or update a resource.</p>', 'DescribeResourcePolicyResponse$revisionId' => '<p>The current revision of the resource policy. Use the revision ID to make sure that you are updating the most current version of a resource policy when you add a policy statement to a resource, delete a resource, or update a resource.</p>', 'UpdateResourcePolicyRequest$expectedRevisionId' => '<p>The identifier of the revision of the policy to update. If this revision ID doesn\'t match the current revision ID, Amazon Lex throws an exception.</p> <p>If you don\'t specify a revision, Amazon Lex overwrites the contents of the policy with the new values.</p>', 'UpdateResourcePolicyResponse$revisionId' => '<p>The current revision of the resource policy. Use the revision ID to make sure that you are updating the most current version of a resource policy when you add a policy statement to a resource, delete a resource, or update a resource.</p>', ], ], 'RoleArn' => [ 'base' => NULL, 'refs' => [ 'BotImportSpecification$roleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role used to build and run the bot.</p>', 'CreateBotRequest$roleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role that has permission to access the bot.</p>', 'CreateBotResponse$roleArn' => '<p>The IAM role specified for the bot.</p>', 'DescribeBotResponse$roleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role that has permission to access the bot.</p>', 'DescribeBotVersionResponse$roleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role that has permission to access the bot version.</p>', 'DescribeTestSetGenerationResponse$roleArn' => '<p> The roleARN of the test set used for the test set generation.</p>', 'DescribeTestSetResponse$roleArn' => '<p>The roleARN used for any operation in the test set to access resources in the Amazon Web Services account.</p>', 'StartTestSetGenerationRequest$roleArn' => '<p>The roleARN used for any operation in the test set to access resources in the Amazon Web Services account.</p>', 'StartTestSetGenerationResponse$roleArn' => '<p>The roleARN used for any operation in the test set to access resources in the Amazon Web Services account.</p>', 'TestSetImportResourceSpecification$roleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role that has permission to access the test set.</p>', 'TestSetSummary$roleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role that has permission to access the test set.</p>', 'UpdateBotRequest$roleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role that has permissions to access the bot.</p>', 'UpdateBotResponse$roleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role used by the bot after the update.</p>', 'UpdateTestSetResponse$roleArn' => '<p>The roleARN used for any operation in the test set to access resources in the Amazon Web Services account.</p>', ], ], 'RuntimeHintDetails' => [ 'base' => '<p>Provides an array of phrases that should be given preference when resolving values for a slot.</p>', 'refs' => [ 'SlotHintsSlotMap$value' => NULL, ], ], 'RuntimeHintPhrase' => [ 'base' => NULL, 'refs' => [ 'RuntimeHintValue$phrase' => '<p>The phrase that Amazon Lex should look for in the user\'s input to the bot.</p>', ], ], 'RuntimeHintValue' => [ 'base' => '<p>Provides the phrase that Amazon Lex should look for in the user\'s input to the bot.</p>', 'refs' => [ 'RuntimeHintValuesList$member' => NULL, ], ], 'RuntimeHintValuesList' => [ 'base' => NULL, 'refs' => [ 'RuntimeHintDetails$runtimeHintValues' => '<p>One or more strings that Amazon Lex should look for in the input to the bot. Each phrase is given preference when deciding on slot values.</p>', ], ], 'RuntimeHints' => [ 'base' => '<p>You can provide Amazon Lex with hints to the phrases that a customer is likely to use for a slot. When a slot with hints is resolved, the phrases in the runtime hints are preferred in the resolution. You can provide hints for a maximum of 100 intents. You can provide a maximum of 100 slots.</p> <p>Before you can use runtime hints with an existing bot, you must first rebuild the bot.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/using-hints.html">Using runtime hints to improve recognition of slot values</a>.</p>', 'refs' => [ 'InputSessionStateSpecification$runtimeHints' => '<p>Runtime hints for the session state.</p>', ], ], 'RuntimeSettings' => [ 'base' => '<p>Contains specifications about the Amazon Lex runtime generative AI capabilities from Amazon Bedrock that you can turn on for your bot.</p>', 'refs' => [ 'GenerativeAISettings$runtimeSettings' => NULL, ], ], 'S3BucketArn' => [ 'base' => NULL, 'refs' => [ 'S3BucketLogDestination$s3BucketArn' => '<p>The Amazon Resource Name (ARN) of an Amazon S3 bucket where audio log files are stored.</p>', ], ], 'S3BucketLogDestination' => [ 'base' => '<p>Specifies an Amazon S3 bucket for logging audio conversations</p>', 'refs' => [ 'AudioLogDestination$s3Bucket' => '<p>The Amazon S3 bucket where the audio log files are stored. The IAM role specified in the <code>roleArn</code> parameter of the <a href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_CreateBot.html">CreateBot</a> operation must have permission to write to this bucket.</p>', ], ], 'S3BucketName' => [ 'base' => NULL, 'refs' => [ 'GrammarSlotTypeSource$s3BucketName' => '<p>The name of the Amazon S3 bucket that contains the grammar source.</p>', 'S3BucketTranscriptSource$s3BucketName' => '<p>The name of the bucket containing the transcript and the associated metadata.</p>', 'TestSetImportInputLocation$s3BucketName' => '<p>The name of the Amazon S3 bucket.</p>', 'TestSetStorageLocation$s3BucketName' => '<p>The name of the Amazon S3 bucket in which the test set is stored.</p>', ], ], 'S3BucketTranscriptSource' => [ 'base' => '<p>The object representing the Amazon S3 bucket containing the transcript, as well as the associated metadata.</p>', 'refs' => [ 'TranscriptSourceSetting$s3BucketTranscriptSource' => '<p>Indicates the setting of the Amazon S3 bucket where the transcript is stored.</p>', ], ], 'S3ObjectPath' => [ 'base' => NULL, 'refs' => [ 'GrammarSlotTypeSource$s3ObjectKey' => '<p>The path to the grammar in the Amazon S3 bucket.</p>', 'TestSetImportInputLocation$s3Path' => '<p>The path inside the Amazon S3 bucket pointing to the test-set CSV file.</p>', 'TestSetStorageLocation$s3Path' => '<p>The path inside the Amazon S3 bucket where the test set is stored.</p>', ], ], 'SSMLMessage' => [ 'base' => '<p>Defines a Speech Synthesis Markup Language (SSML) prompt.</p>', 'refs' => [ 'Message$ssmlMessage' => '<p>A message in Speech Synthesis Markup Language (SSML).</p>', ], ], 'SSMLMessageValue' => [ 'base' => NULL, 'refs' => [ 'SSMLMessage$value' => '<p>The SSML text that defines the prompt.</p>', ], ], 'SampleUtterance' => [ 'base' => '<p>A sample utterance that invokes an intent or respond to a slot elicitation prompt.</p>', 'refs' => [ 'SampleUtterancesList$member' => NULL, ], ], 'SampleUtteranceGenerationSpecification' => [ 'base' => '<p>Contains specifications for the sample utterance generation feature.</p>', 'refs' => [ 'BuildtimeSettings$sampleUtteranceGeneration' => '<p>Contains specifications for the sample utterance generation feature.</p>', ], ], 'SampleUtterancesCount' => [ 'base' => NULL, 'refs' => [ 'RecommendedIntentSummary$sampleUtterancesCount' => '<p>The count of sample utterances of a recommended intent that is associated with a bot recommendation.</p>', ], ], 'SampleUtterancesList' => [ 'base' => NULL, 'refs' => [ 'CreateIntentRequest$sampleUtterances' => '<p>An array of strings that a user might say to signal the intent. For example, "I want a pizza", or "I want a {PizzaSize} pizza". </p> <p>In an utterance, slot names are enclosed in curly braces ("{", "}") to indicate where they should be displayed in the utterance shown to the user.. </p>', 'CreateIntentResponse$sampleUtterances' => '<p>The sample utterances specified for the intent.</p>', 'DescribeIntentResponse$sampleUtterances' => '<p>User utterances that trigger this intent.</p>', 'GenerateBotElementResponse$sampleUtterances' => '<p>The sample utterances for the bot which received the response.</p>', 'SlotValueElicitationSetting$sampleUtterances' => '<p>If you know a specific pattern that users might respond to an Amazon Lex request for a slot value, you can provide those utterances to improve accuracy. This is optional. In most cases, Amazon Lex is capable of understanding user utterances.</p>', 'SubSlotValueElicitationSetting$sampleUtterances' => '<p>If you know a specific pattern that users might respond to an Amazon Lex request for a sub slot value, you can provide those utterances to improve accuracy. This is optional. In most cases Amazon Lex is capable of understanding user utterances. This is similar to <code>SampleUtterances</code> for slots.</p>', 'UpdateIntentRequest$sampleUtterances' => '<p>New utterances used to invoke the intent.</p>', 'UpdateIntentResponse$sampleUtterances' => '<p>The updated list of sample utterances for the intent.</p>', ], ], 'SampleValue' => [ 'base' => '<p>Defines one of the values for a slot type.</p>', 'refs' => [ 'SlotTypeValue$sampleValue' => '<p>The value of the slot type entry.</p>', 'SynonymList$member' => NULL, ], ], 'SearchAssociatedTranscriptsRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchAssociatedTranscriptsResponse' => [ 'base' => NULL, 'refs' => [], ], 'SearchOrder' => [ 'base' => NULL, 'refs' => [ 'SearchAssociatedTranscriptsRequest$searchOrder' => '<p>How SearchResults are ordered. Valid values are Ascending or Descending. The default is Descending.</p>', ], ], 'SentimentAnalysisSettings' => [ 'base' => '<p>Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment of user utterances.</p>', 'refs' => [ 'CreateBotAliasRequest$sentimentAnalysisSettings' => NULL, 'CreateBotAliasResponse$sentimentAnalysisSettings' => NULL, 'DescribeBotAliasResponse$sentimentAnalysisSettings' => NULL, 'UpdateBotAliasRequest$sentimentAnalysisSettings' => NULL, 'UpdateBotAliasResponse$sentimentAnalysisSettings' => NULL, ], ], 'ServicePrincipal' => [ 'base' => NULL, 'refs' => [ 'Principal$service' => '<p>The name of the Amazon Web Services service that should allowed or denied access to an Amazon Lex action.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>You have reached a quota for your bot. </p>', 'refs' => [], ], 'SessionDataSortBy' => [ 'base' => '<p>An object specifying the measure and method by which to sort the session analytics data.</p>', 'refs' => [ 'ListSessionAnalyticsDataRequest$sortBy' => '<p>An object specifying the measure and method by which to sort the session analytics data.</p>', ], ], 'SessionId' => [ 'base' => NULL, 'refs' => [ 'DeleteUtterancesRequest$sessionId' => '<p>The unique identifier of the session with the user. The ID is returned in the response from the <a href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_runtime_RecognizeText.html">RecognizeText</a> and <a href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_runtime_RecognizeUtterance.html">RecognizeUtterance</a> operations.</p>', ], ], 'SessionSpecification' => [ 'base' => '<p>An object containing information about a specific session.</p>', 'refs' => [ 'SessionSpecifications$member' => NULL, ], ], 'SessionSpecifications' => [ 'base' => NULL, 'refs' => [ 'ListSessionAnalyticsDataResponse$sessions' => '<p>A list of objects, each of which contains information about a session with the bot.</p>', ], ], 'SessionTTL' => [ 'base' => NULL, 'refs' => [ 'BotImportSpecification$idleSessionTTLInSeconds' => '<p>The time, in seconds, that Amazon Lex should keep information about a user\'s conversation with the bot. </p> <p>A user interaction remains active for the amount of time specified. If no conversation occurs during this time, the session expires and Amazon Lex deletes any data provided before the timeout.</p> <p>You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.</p>', 'CreateBotRequest$idleSessionTTLInSeconds' => '<p>The time, in seconds, that Amazon Lex should keep information about a user\'s conversation with the bot. </p> <p>A user interaction remains active for the amount of time specified. If no conversation occurs during this time, the session expires and Amazon Lex deletes any data provided before the timeout.</p> <p>You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.</p>', 'CreateBotResponse$idleSessionTTLInSeconds' => '<p>The session idle time specified for the bot.</p>', 'DescribeBotResponse$idleSessionTTLInSeconds' => '<p>The maximum time in seconds that Amazon Lex retains the data gathered in a conversation.</p>', 'DescribeBotVersionResponse$idleSessionTTLInSeconds' => '<p>The number of seconds that a session with the bot remains active before it is discarded by Amazon Lex.</p>', 'UpdateBotRequest$idleSessionTTLInSeconds' => '<p>The time, in seconds, that Amazon Lex should keep information about a user\'s conversation with the bot.</p> <p>A user interaction remains active for the amount of time specified. If no conversation occurs during this time, the session expires and Amazon Lex deletes any data provided before the timeout.</p> <p>You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.</p>', 'UpdateBotResponse$idleSessionTTLInSeconds' => '<p>The session timeout, in seconds, for the bot after the update.</p>', ], ], 'SkipResourceInUseCheck' => [ 'base' => NULL, 'refs' => [ 'DeleteBotAliasRequest$skipResourceInUseCheck' => '<p>By default, Amazon Lex checks if any other resource, such as a bot network, is using the bot alias before it is deleted and throws a <code>ResourceInUseException</code> exception if the alias is being used by another resource. Set this parameter to <code>true</code> to skip this check and remove the alias even if it is being used by another resource.</p>', 'DeleteBotRequest$skipResourceInUseCheck' => '<p>By default, Amazon Lex checks if any other resource, such as an alias or bot network, is using the bot version before it is deleted and throws a <code>ResourceInUseException</code> exception if the bot is being used by another resource. Set this parameter to <code>true</code> to skip this check and remove the bot even if it is being used by another resource.</p>', 'DeleteBotVersionRequest$skipResourceInUseCheck' => '<p>By default, Amazon Lex checks if any other resource, such as an alias or bot network, is using the bot version before it is deleted and throws a <code>ResourceInUseException</code> exception if the version is being used by another resource. Set this parameter to <code>true</code> to skip this check and remove the version even if it is being used by another resource.</p>', 'DeleteSlotTypeRequest$skipResourceInUseCheck' => '<p>By default, the <code>DeleteSlotType</code> operations throws a <code>ResourceInUseException</code> exception if you try to delete a slot type used by a slot. Set the <code>skipResourceInUseCheck</code> parameter to <code>true</code> to skip this check and remove the slot type even if a slot uses it.</p>', ], ], 'SlotCaptureSetting' => [ 'base' => '<p>Settings used when Amazon Lex successfully captures a slot value from a user.</p>', 'refs' => [ 'SlotValueElicitationSetting$slotCaptureSetting' => '<p>Specifies the settings that Amazon Lex uses when a slot value is successfully entered by a user.</p>', ], ], 'SlotConstraint' => [ 'base' => NULL, 'refs' => [ 'SlotSummary$slotConstraint' => '<p>Whether the slot is required or optional. An intent is complete when all required slots are filled.</p>', 'SlotValueElicitationSetting$slotConstraint' => '<p>Specifies whether the slot is required or optional.</p>', ], ], 'SlotDefaultValue' => [ 'base' => '<p>Specifies the default value to use when a user doesn\'t provide a value for a slot.</p>', 'refs' => [ 'SlotDefaultValueList$member' => NULL, ], ], 'SlotDefaultValueList' => [ 'base' => NULL, 'refs' => [ 'SlotDefaultValueSpecification$defaultValueList' => '<p>A list of default values. Amazon Lex chooses the default value to use in the order that they are presented in the list.</p>', ], ], 'SlotDefaultValueSpecification' => [ 'base' => '<p>Defines a list of values that Amazon Lex should use as the default value for a slot.</p>', 'refs' => [ 'SlotValueElicitationSetting$defaultValueSpecification' => '<p>A list of default values for a slot. Default values are used when Amazon Lex hasn\'t determined a value for a slot. You can specify default values from context variables, session attributes, and defined values.</p>', 'SubSlotValueElicitationSetting$defaultValueSpecification' => NULL, ], ], 'SlotDefaultValueString' => [ 'base' => NULL, 'refs' => [ 'SlotDefaultValue$defaultValue' => '<p>The default value to use when a user doesn\'t provide a value for a slot.</p>', ], ], 'SlotFilter' => [ 'base' => '<p>Filters the response from the <code>ListSlots</code> operation.</p>', 'refs' => [ 'SlotFilters$member' => NULL, ], ], 'SlotFilterName' => [ 'base' => NULL, 'refs' => [ 'SlotFilter$name' => '<p>The name of the field to use for filtering.</p>', ], ], 'SlotFilterOperator' => [ 'base' => NULL, 'refs' => [ 'SlotFilter$operator' => '<p>The operator to use for the filter. Specify <code>EQ</code> when the <code>ListSlots</code> operation should return only aliases that equal the specified value. Specify <code>CO</code> when the <code>ListSlots</code> operation should return aliases that contain the specified value.</p>', ], ], 'SlotFilters' => [ 'base' => NULL, 'refs' => [ 'ListSlotsRequest$filters' => '<p>Provides the specification of a filter used to limit the slots in the response to only those that match the filter specification. You can only specify one filter and only one string to filter on.</p>', ], ], 'SlotHintsIntentMap' => [ 'base' => NULL, 'refs' => [ 'RuntimeHints$slotHints' => '<p>A list of the slots in the intent that should have runtime hints added, and the phrases that should be added for each slot.</p> <p>The first level of the <code>slotHints</code> map is the name of the intent. The second level is the name of the slot within the intent. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/using-hints.html">Using hints to improve accuracy</a>.</p> <p>The intent name and slot name must exist.</p>', ], ], 'SlotHintsSlotMap' => [ 'base' => NULL, 'refs' => [ 'RuntimeHintDetails$subSlotHints' => '<p>A map of constituent sub slot names inside a composite slot in the intent and the phrases that should be added for each sub slot. Inside each composite slot hints, this structure provides a mechanism to add granular sub slot phrases. Only sub slot hints are supported for composite slots. The intent name, composite slot name and the constituent sub slot names must exist.</p>', 'SlotHintsIntentMap$value' => NULL, ], ], 'SlotPrioritiesList' => [ 'base' => NULL, 'refs' => [ 'DescribeIntentResponse$slotPriorities' => '<p>The list that determines the priority that slots should be elicited from the user.</p>', 'UpdateIntentRequest$slotPriorities' => '<p>A new list of slots and their priorities that are contained by the intent.</p>', 'UpdateIntentResponse$slotPriorities' => '<p>The updated list of slots and their priorities that are elicited from the user for the intent.</p>', ], ], 'SlotPriority' => [ 'base' => '<p>Sets the priority that Amazon Lex should use when eliciting slot values from a user.</p>', 'refs' => [ 'SlotPrioritiesList$member' => NULL, ], ], 'SlotResolutionImprovementSpecification' => [ 'base' => '<p>Contains specifications for the assisted slot resolution feature.</p>', 'refs' => [ 'RuntimeSettings$slotResolutionImprovement' => '<p>An object containing specifications for the assisted slot resolution feature.</p>', ], ], 'SlotResolutionSetting' => [ 'base' => '<p>Contains information about whether assisted slot resolution is turned on for the slot or not.</p>', 'refs' => [ 'SlotValueElicitationSetting$slotResolutionSetting' => '<p>An object containing information about whether assisted slot resolution is turned on for the slot or not.</p>', ], ], 'SlotResolutionStrategy' => [ 'base' => NULL, 'refs' => [ 'SlotResolutionSetting$slotResolutionStrategy' => '<p>Specifies whether assisted slot resolution is turned on for the slot or not. If the value is <code>EnhancedFallback</code>, assisted slot resolution is activated when Amazon Lex defaults to the <code>AMAZON.FallbackIntent</code>. If the value is <code>Default</code>, assisted slot resolution is turned off.</p>', ], ], 'SlotResolutionTestResultItem' => [ 'base' => '<p>Information about the success and failure rate of slot resolution in the results of a test execution.</p>', 'refs' => [ 'SlotResolutionTestResultItems$member' => NULL, ], ], 'SlotResolutionTestResultItemCounts' => [ 'base' => '<p>Information about the counts for a slot resolution in the results of a test execution.</p>', 'refs' => [ 'SlotResolutionTestResultItem$resultCounts' => '<p>A result for slot resolution in the results of a test execution.</p>', ], ], 'SlotResolutionTestResultItems' => [ 'base' => NULL, 'refs' => [ 'IntentLevelSlotResolutionTestResultItem$slotResolutionResults' => '<p>The results for the slot resolution in the test execution result.</p>', ], ], 'SlotShape' => [ 'base' => NULL, 'refs' => [ 'SlotValueOverride$shape' => '<p>When the shape value is <code>List</code>, it indicates that the <code>values</code> field contains a list of slot values. When the value is <code>Scalar</code>, it indicates that the <code>value</code> field contains a single value.</p>', ], ], 'SlotSortAttribute' => [ 'base' => NULL, 'refs' => [ 'SlotSortBy$attribute' => '<p>The attribute to use to sort the list.</p>', ], ], 'SlotSortBy' => [ 'base' => '<p>Specifies attributes for sorting a list of bots.</p>', 'refs' => [ 'ListSlotsRequest$sortBy' => '<p>Determines the sort order for the response from the <code>ListSlots</code> operation. You can choose to sort by the slot name or last updated date in either ascending or descending order.</p>', ], ], 'SlotSummary' => [ 'base' => '<p>Summary information about a slot, a value that the bot elicits from the user.</p>', 'refs' => [ 'SlotSummaryList$member' => NULL, ], ], 'SlotSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListSlotsResponse$slotSummaries' => '<p>Summary information for the slots that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more slots available, the <code>nextToken</code> field contains a token to get the next page of results.</p>', ], ], 'SlotTypeCategory' => [ 'base' => NULL, 'refs' => [ 'SlotTypeSummary$slotTypeCategory' => '<p>Indicates the type of the slot type.</p> <ul> <li> <p> <code>Custom</code> - A slot type that you created using custom values. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/custom-slot-types.html">Creating custom slot types</a>.</p> </li> <li> <p> <code>Extended</code> - A slot type created by extending the <code>AMAZON.AlphaNumeric</code> built-in slot type. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/built-in-slot-alphanumerice.html"> <code>AMAZON.AlphaNumeric</code> </a>.</p> </li> <li> <p> <code>ExternalGrammar</code> - A slot type using a custom GRXML grammar to define values. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/building-grxml.html">Using a custom grammar slot type</a>.</p> </li> </ul>', ], ], 'SlotTypeFilter' => [ 'base' => '<p>Filters the response from the <code>ListSlotTypes</code> operation.</p>', 'refs' => [ 'SlotTypeFilters$member' => NULL, ], ], 'SlotTypeFilterName' => [ 'base' => NULL, 'refs' => [ 'SlotTypeFilter$name' => '<p>The name of the field to use for filtering.</p>', ], ], 'SlotTypeFilterOperator' => [ 'base' => NULL, 'refs' => [ 'SlotTypeFilter$operator' => '<p>The operator to use for the filter. Specify <code>EQ</code> when the <code>ListSlotTypes</code> operation should return only aliases that equal the specified value. Specify <code>CO</code> when the <code>ListSlotTypes</code> operation should return aliases that contain the specified value.</p>', ], ], 'SlotTypeFilters' => [ 'base' => NULL, 'refs' => [ 'ListSlotTypesRequest$filters' => '<p>Provides the specification of a filter used to limit the slot types in the response to only those that match the filter specification. You can only specify one filter and only one string to filter on.</p>', ], ], 'SlotTypeSignature' => [ 'base' => NULL, 'refs' => [ 'BuiltInSlotTypeSummary$slotTypeSignature' => '<p>The signature of the built-in slot type. Use this to specify the parent slot type of a derived slot type.</p>', 'CreateSlotTypeRequest$parentSlotTypeSignature' => '<p>The built-in slot type used as a parent of this slot type. When you define a parent slot type, the new slot type has the configuration of the parent slot type.</p> <p>Only <code>AMAZON.AlphaNumeric</code> is supported.</p>', 'CreateSlotTypeResponse$parentSlotTypeSignature' => '<p>The signature of the base slot type specified for the slot type.</p>', 'DescribeSlotTypeResponse$parentSlotTypeSignature' => '<p>The built in slot type used as a parent to this slot type.</p>', 'SlotTypeSummary$parentSlotTypeSignature' => '<p>If the slot type is derived from a built-on slot type, the name of the parent slot type.</p>', 'UpdateSlotTypeRequest$parentSlotTypeSignature' => '<p>The new built-in slot type that should be used as the parent of this slot type.</p>', 'UpdateSlotTypeResponse$parentSlotTypeSignature' => '<p>The updated signature of the built-in slot type that is the parent of this slot type.</p>', ], ], 'SlotTypeSortAttribute' => [ 'base' => NULL, 'refs' => [ 'SlotTypeSortBy$attribute' => '<p>The attribute to use to sort the list of slot types.</p>', ], ], 'SlotTypeSortBy' => [ 'base' => '<p>Specifies attributes for sorting a list of slot types.</p>', 'refs' => [ 'ListSlotTypesRequest$sortBy' => '<p>Determines the sort order for the response from the <code>ListSlotTypes</code> operation. You can choose to sort by the slot type name or last updated date in either ascending or descending order.</p>', ], ], 'SlotTypeStatistics' => [ 'base' => '<p>The object that contains the statistical summary of the recommended slot type associated with the bot recommendation.</p>', 'refs' => [ 'BotRecommendationResultStatistics$slotTypes' => '<p>Statistical information about the slot types associated with the bot recommendation results.</p>', ], ], 'SlotTypeSummary' => [ 'base' => '<p>Provides summary information about a slot type.</p>', 'refs' => [ 'SlotTypeSummaryList$member' => NULL, ], ], 'SlotTypeSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListSlotTypesResponse$slotTypeSummaries' => '<p>Summary information for the slot types that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more slot types available, the <code>nextToken</code> field contains a token to get the next page of results.</p>', ], ], 'SlotTypeValue' => [ 'base' => '<p>Each slot type can have a set of values. Each <code>SlotTypeValue</code> represents a value that the slot type can take.</p>', 'refs' => [ 'SlotTypeValues$member' => NULL, ], ], 'SlotTypeValues' => [ 'base' => NULL, 'refs' => [ 'CreateSlotTypeRequest$slotTypeValues' => '<p>A list of <code>SlotTypeValue</code> objects that defines the values that the slot type can take. Each value can have a list of synonyms, additional values that help train the machine learning model about the values that it resolves for a slot.</p>', 'CreateSlotTypeResponse$slotTypeValues' => '<p>The list of values that the slot type can assume.</p>', 'DescribeSlotTypeResponse$slotTypeValues' => '<p>The values that the slot type can take. Includes any synonyms for the slot type values.</p>', 'UpdateSlotTypeRequest$slotTypeValues' => '<p>A new list of values and their optional synonyms that define the values that the slot type can take.</p>', 'UpdateSlotTypeResponse$slotTypeValues' => '<p>The updated values that the slot type provides.</p>', ], ], 'SlotValue' => [ 'base' => '<p>The value to set in a slot.</p>', 'refs' => [ 'SlotValueOverride$value' => '<p>The current value of the slot.</p>', ], ], 'SlotValueElicitationSetting' => [ 'base' => '<p>Specifies the elicitation setting details eliciting a slot.</p>', 'refs' => [ 'CreateSlotRequest$valueElicitationSetting' => '<p>Specifies prompts that Amazon Lex sends to the user to elicit a response that provides the value for the slot. </p>', 'CreateSlotResponse$valueElicitationSetting' => '<p>The value elicitation settings specified for the slot.</p>', 'DescribeSlotResponse$valueElicitationSetting' => '<p>Prompts that Amazon Lex uses to elicit a value for the slot.</p>', 'UpdateSlotRequest$valueElicitationSetting' => '<p>A new set of prompts that Amazon Lex sends to the user to elicit a response the provides a value for the slot.</p>', 'UpdateSlotResponse$valueElicitationSetting' => '<p>The updated prompts that Amazon Lex sends to the user to elicit a response that provides a value for the slot.</p>', ], ], 'SlotValueOverride' => [ 'base' => '<p>The slot values that Amazon Lex uses when it sets slot values in a dialog step.</p>', 'refs' => [ 'SlotValueOverrideMap$value' => NULL, 'SlotValues$member' => NULL, ], ], 'SlotValueOverrideMap' => [ 'base' => NULL, 'refs' => [ 'IntentOverride$slots' => '<p>A map of all of the slot value overrides for the intent. The name of the slot maps to the value of the slot. Slots that are not included in the map aren\'t overridden.</p>', ], ], 'SlotValueRegexFilter' => [ 'base' => '<p>Provides a regular expression used to validate the value of a slot.</p>', 'refs' => [ 'SlotValueSelectionSetting$regexFilter' => '<p>A regular expression used to validate the value of a slot.</p>', ], ], 'SlotValueResolutionStrategy' => [ 'base' => NULL, 'refs' => [ 'SlotValueSelectionSetting$resolutionStrategy' => '<p>Determines the slot resolution strategy that Amazon Lex uses to return slot type values. The field can be set to one of the following values:</p> <ul> <li> <p> <code>ORIGINAL_VALUE</code> - Returns the value entered by the user, if the user value is similar to the slot value.</p> </li> <li> <p> <code>TOP_RESOLUTION</code> - If there is a resolution list for the slot, return the first value in the resolution list as the slot type value. If there is no resolution list, null is returned.</p> </li> </ul> <p>If you don\'t specify the <code>valueSelectionStrategy</code>, the default is <code>ORIGINAL_VALUE</code>.</p>', ], ], 'SlotValueSelectionSetting' => [ 'base' => '<p>Contains settings used by Amazon Lex to select a slot value.</p>', 'refs' => [ 'CreateSlotTypeRequest$valueSelectionSetting' => '<p>Determines the strategy that Amazon Lex uses to select a value from the list of possible values. The field can be set to one of the following values:</p> <ul> <li> <p> <code>ORIGINAL_VALUE</code> - Returns the value entered by the user, if the user value is similar to the slot value.</p> </li> <li> <p> <code>TOP_RESOLUTION</code> - If there is a resolution list for the slot, return the first value in the resolution list. If there is no resolution list, return null.</p> </li> </ul> <p>If you don\'t specify the <code>valueSelectionSetting</code> parameter, the default is <code>ORIGINAL_VALUE</code>.</p>', 'CreateSlotTypeResponse$valueSelectionSetting' => '<p>The strategy that Amazon Lex uses to select a value from the list of possible values.</p>', 'DescribeSlotTypeResponse$valueSelectionSetting' => '<p>The strategy that Amazon Lex uses to choose a value from a list of possible values.</p>', 'UpdateSlotTypeRequest$valueSelectionSetting' => '<p>The strategy that Amazon Lex should use when deciding on a value from the list of slot type values.</p>', 'UpdateSlotTypeResponse$valueSelectionSetting' => '<p>The updated strategy that Amazon Lex uses to determine which value to select from the slot type.</p>', ], ], 'SlotValues' => [ 'base' => NULL, 'refs' => [ 'SlotValueOverride$values' => '<p>A list of one or more values that the user provided for the slot. For example, for a slot that elicits pizza toppings, the values might be "pepperoni" and "pineapple."</p>', ], ], 'SortOrder' => [ 'base' => NULL, 'refs' => [ 'AggregatedUtterancesSortBy$order' => '<p>Specifies whether to sort the aggregated utterances in ascending or descending order.</p>', 'BotLocaleSortBy$order' => '<p>Specifies whether to sort the bot locales in ascending or descending order.</p>', 'BotSortBy$order' => '<p>The order to sort the list. You can choose ascending or descending.</p>', 'BotVersionReplicaSortBy$order' => '<p>The order of the sort category for the version replicated bots.</p>', 'BotVersionSortBy$order' => '<p>The order to sort the list. You can specify ascending or descending order.</p>', 'BuiltInIntentSortBy$order' => '<p>The order to sort the list. You can specify ascending or descending order.</p>', 'BuiltInSlotTypeSortBy$order' => '<p>The order to sort the list. You can choose ascending or descending.</p>', 'ExportSortBy$order' => '<p>The order to sort the list.</p>', 'GenerationSortBy$order' => '<p>The order by which to sort the generation request information.</p>', 'ImportSortBy$order' => '<p>The order to sort the list.</p>', 'IntentSortBy$order' => '<p>The order to sort the list. You can choose ascending or descending.</p>', 'SlotSortBy$order' => '<p>The order to sort the list. You can choose ascending or descending.</p>', 'SlotTypeSortBy$order' => '<p>The order to sort the list. You can say ascending or descending.</p>', 'TestExecutionSortBy$order' => '<p>Specifies whether to sort in ascending or descending order.</p>', 'TestSetSortBy$order' => '<p>Specifies whether to sort in ascending or descending order.</p>', ], ], 'Specifications' => [ 'base' => '<p>Subslot specifications.</p>', 'refs' => [ 'SubSlotSpecificationMap$value' => NULL, ], ], 'StartBotRecommendationRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartBotRecommendationResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartBotResourceGenerationRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartBotResourceGenerationResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartImportRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartImportResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartTestExecutionRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartTestExecutionResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartTestSetGenerationRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartTestSetGenerationResponse' => [ 'base' => NULL, 'refs' => [], ], 'StillWaitingResponseFrequency' => [ 'base' => NULL, 'refs' => [ 'StillWaitingResponseSpecification$frequencyInSeconds' => '<p>How often a message should be sent to the user. Minimum of 1 second, maximum of 5 minutes.</p>', ], ], 'StillWaitingResponseSpecification' => [ 'base' => '<p>Defines the messages that Amazon Lex sends to a user to remind them that the bot is waiting for a response.</p>', 'refs' => [ 'WaitAndContinueSpecification$stillWaitingResponse' => '<p>A response that Amazon Lex sends periodically to the user to indicate that the bot is still waiting for input from the user.</p>', ], ], 'StillWaitingResponseTimeout' => [ 'base' => NULL, 'refs' => [ 'StillWaitingResponseSpecification$timeoutInSeconds' => '<p>If Amazon Lex waits longer than this length of time for a response, it will stop sending messages.</p>', ], ], 'StopBotRecommendationRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopBotRecommendationResponse' => [ 'base' => NULL, 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'StringMap$value' => NULL, 'TestSetIntentDiscrepancyItem$errorMessage' => '<p>The error message for a discrepancy for an intent between the test set and the bot.</p>', 'TestSetSlotDiscrepancyItem$errorMessage' => '<p>The error message for a discrepancy for an intent between the test set and the bot.</p>', 'UtteranceBotResponse$content' => '<p>The text of the response to the utterance from the bot.</p>', 'UtteranceSpecification$utterance' => '<p>The text of the utterance.</p>', 'UtteranceSpecification$inputType' => '<p>The input type of the utterance. The possible values are as follows:</p> <ul> <li> <p>PCM format: audio data must be in little-endian byte order.</p> <ul> <li> <p> <code>audio/l16; rate=16000; channels=1</code> </p> </li> <li> <p> <code>audio/x-l16; sample-rate=16000; channel-count=1</code> </p> </li> <li> <p> <code>audio/lpcm; sample-rate=8000; sample-size-bits=16; channel-count=1; is-big-endian=false</code> </p> </li> </ul> </li> <li> <p>Opus format</p> <ul> <li> <p> <code>audio/x-cbr-opus-with-preamble;preamble-size=0;bit-rate=256000;frame-size-milliseconds=4</code> </p> </li> </ul> </li> <li> <p>Text format</p> <ul> <li> <p> <code>text/plain; charset=utf-8</code> </p> </li> </ul> </li> </ul>', 'UtteranceSpecification$outputType' => '<p>The output type of the utterance. The possible values are as follows:</p> <ul> <li> <p> <code>audio/mpeg</code> </p> </li> <li> <p> <code>audio/ogg</code> </p> </li> <li> <p> <code>audio/pcm (16 KHz)</code> </p> </li> <li> <p> <code>audio/</code> (defaults to <code>mpeg</code>)</p> </li> <li> <p> <code>text/plain; charset=utf-8</code> </p> </li> </ul>', 'UtteranceSpecification$dialogActionType' => '<p>The type of dialog action that the utterance is associated to. See the <code>type</code> field in <a href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_runtime_DialogAction.html">DialogAction</a> for more information.</p>', 'UtteranceSpecification$botResponseAudioVoiceId' => '<p>The identifier for the audio of the bot response.</p>', 'UtteranceSpecification$slotsFilledInSession' => '<p>The slots that have been filled in the session by the time of the utterance.</p>', ], ], 'StringMap' => [ 'base' => NULL, 'refs' => [ 'DialogState$sessionAttributes' => '<p>Map of key/value pairs representing session-specific context information. It contains application information passed between Amazon Lex and a client application.</p>', 'InputSessionStateSpecification$sessionAttributes' => '<p>Session attributes for the session state.</p>', 'UserTurnInputSpecification$requestAttributes' => '<p>Request attributes of the user turn.</p>', ], ], 'SubSlotExpression' => [ 'base' => NULL, 'refs' => [ 'SubSlotSetting$expression' => '<p>The expression text for defining the constituent sub slots in the composite slot using logical AND and OR operators.</p>', ], ], 'SubSlotSetting' => [ 'base' => '<p>Specifications for the constituent sub slots and the expression for the composite slot.</p>', 'refs' => [ 'CreateSlotRequest$subSlotSetting' => '<p>Specifications for the constituent sub slots and the expression for the composite slot.</p>', 'CreateSlotResponse$subSlotSetting' => '<p>Specifications for the constituent sub slots and the expression for the composite slot.</p>', 'DescribeSlotResponse$subSlotSetting' => '<p>Specifications for the constituent sub slots and the expression for the composite slot.</p>', 'UpdateSlotRequest$subSlotSetting' => '<p>Specifications for the constituent sub slots and the expression for the composite slot.</p>', 'UpdateSlotResponse$subSlotSetting' => '<p>Specifications for the constituent sub slots and the expression for the composite slot.</p>', ], ], 'SubSlotSpecificationMap' => [ 'base' => NULL, 'refs' => [ 'SubSlotSetting$slotSpecifications' => '<p>Specifications for the constituent sub slots of a composite slot.</p>', ], ], 'SubSlotTypeComposition' => [ 'base' => '<p>Subslot type composition.</p>', 'refs' => [ 'SubSlotTypeList$member' => NULL, ], ], 'SubSlotTypeList' => [ 'base' => NULL, 'refs' => [ 'CompositeSlotTypeSetting$subSlots' => '<p>Subslots in the composite slot.</p>', ], ], 'SubSlotValueElicitationSetting' => [ 'base' => '<p>Subslot elicitation settings.</p> <p> <code>DefaultValueSpecification</code> is a list of default values for a constituent sub slot in a composite slot. Default values are used when Amazon Lex hasn\'t determined a value for a slot. You can specify default values from context variables, session attributes, and defined values. This is similar to <code>DefaultValueSpecification</code> for slots.</p> <p> <code>PromptSpecification</code> is the prompt that Amazon Lex uses to elicit the sub slot value from the user. This is similar to <code>PromptSpecification</code> for slots.</p>', 'refs' => [ 'Specifications$valueElicitationSetting' => '<p>Specifies the elicitation setting details for constituent sub slots of a composite slot.</p>', ], ], 'SynonymList' => [ 'base' => NULL, 'refs' => [ 'SlotTypeValue$synonyms' => '<p>Additional values related to the slot type entry.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'TagMap$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>A list of tag keys to remove from the resource. If a tag key does not exist on the resource, it is ignored.</p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'BotImportSpecification$botTags' => '<p>A list of tags to add to the bot. You can only add tags when you import a bot. You can\'t use the <code>UpdateBot</code> operation to update tags. To update tags, use the <code>TagResource</code> operation.</p>', 'BotImportSpecification$testBotAliasTags' => '<p>A list of tags to add to the test alias for a bot. You can only add tags when you import a bot. You can\'t use the <code>UpdateAlias</code> operation to update tags. To update tags on the test alias, use the <code>TagResource</code> operation.</p>', 'CreateBotAliasRequest$tags' => '<p>A list of tags to add to the bot alias. You can only add tags when you create an alias, you can\'t use the <code>UpdateBotAlias</code> operation to update the tags on a bot alias. To update tags, use the <code>TagResource</code> operation.</p>', 'CreateBotAliasResponse$tags' => '<p>A list of tags associated with the bot alias.</p>', 'CreateBotRequest$botTags' => '<p>A list of tags to add to the bot. You can only add tags when you create a bot. You can\'t use the <code>UpdateBot</code> operation to update tags. To update tags, use the <code>TagResource</code> operation.</p>', 'CreateBotRequest$testBotAliasTags' => '<p>A list of tags to add to the test alias for a bot. You can only add tags when you create a bot. You can\'t use the <code>UpdateAlias</code> operation to update tags. To update tags on the test alias, use the <code>TagResource</code> operation.</p>', 'CreateBotResponse$botTags' => '<p>A list of tags associated with the bot.</p>', 'CreateBotResponse$testBotAliasTags' => '<p>A list of tags associated with the test alias for the bot.</p>', 'ListTagsForResourceResponse$tags' => '<p>The tags associated with a resource.</p>', 'StartTestSetGenerationRequest$testSetTags' => '<p>A list of tags to add to the test set. You can only add tags when you import/generate a new test set. You can\'t use the <code>UpdateTestSet</code> operation to update tags. To update tags, use the <code>TagResource</code> operation.</p>', 'StartTestSetGenerationResponse$testSetTags' => '<p>A list of tags that was used for the test set that is being generated.</p>', 'TagResourceRequest$tags' => '<p>A list of tag keys to add to the resource. If a tag key already exists, the existing value is replaced with the new value.</p>', 'TestSetImportResourceSpecification$testSetTags' => '<p>A list of tags to add to the test set. You can only add tags when you import/generate a new test set. You can\'t use the <code>UpdateTestSet</code> operation to update tags. To update tags, use the <code>TagResource</code> operation.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagMap$value' => NULL, ], ], 'TestExecutionApiMode' => [ 'base' => NULL, 'refs' => [ 'DescribeTestExecutionResponse$apiMode' => '<p>Indicates whether we use streaming or non-streaming APIs are used for the test set execution. For streaming, <code>StartConversation</code> Amazon Lex Runtime API is used. Whereas for non-streaming, <code>RecognizeUtterance</code> and <code>RecognizeText</code> Amazon Lex Runtime API is used.</p>', 'StartTestExecutionRequest$apiMode' => '<p>Indicates whether we use streaming or non-streaming APIs for the test set execution. For streaming, StartConversation Runtime API is used. Whereas, for non-streaming, RecognizeUtterance and RecognizeText Amazon Lex Runtime API are used.</p>', 'StartTestExecutionResponse$apiMode' => '<p>Indicates whether we use streaming or non-streaming APIs for the test set execution. For streaming, StartConversation Amazon Lex Runtime API is used. Whereas for non-streaming, RecognizeUtterance and RecognizeText Amazon Lex Runtime API are used.</p>', 'TestExecutionSummary$apiMode' => '<p>Specifies whether the API mode for the test execution is streaming or non-streaming.</p>', ], ], 'TestExecutionModality' => [ 'base' => NULL, 'refs' => [ 'DescribeTestExecutionResponse$testExecutionModality' => '<p>Indicates whether test set is audio or text.</p>', 'StartTestExecutionRequest$testExecutionModality' => '<p>Indicates whether audio or text is used.</p>', 'StartTestExecutionResponse$testExecutionModality' => '<p>Indicates whether audio or text is used.</p>', 'TestExecutionSummary$testExecutionModality' => '<p>Specifies whether the data used for the test execution is written or spoken.</p>', ], ], 'TestExecutionResultFilterBy' => [ 'base' => '<p>Contains information about the method by which to filter the results of the test execution.</p>', 'refs' => [ 'ListTestExecutionResultItemsRequest$resultFilterBy' => '<p>The filter for the list of results from the test set execution.</p>', ], ], 'TestExecutionResultItems' => [ 'base' => '<p>Contains the results of the test execution, grouped by type of results. See <a href="https://docs.aws.amazon.com/lexv2/latest/dg/test-results-details-test-set.html">Test result details"&gt;Test results details</a> for details about different types of results.</p>', 'refs' => [ 'ListTestExecutionResultItemsResponse$testExecutionResults' => '<p>The list of results from the test execution.</p>', ], ], 'TestExecutionSortAttribute' => [ 'base' => NULL, 'refs' => [ 'TestExecutionSortBy$attribute' => '<p>Specifies whether to sort the test set executions by the date and time at which the test sets were created.</p>', ], ], 'TestExecutionSortBy' => [ 'base' => '<p>Contains information about the method by which to sort the instances of test executions you have carried out.</p>', 'refs' => [ 'ListTestExecutionsRequest$sortBy' => '<p>The sort order of the test set executions.</p>', ], ], 'TestExecutionStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeTestExecutionResponse$testExecutionStatus' => '<p>The test execution status for the test execution.</p>', 'TestExecutionSummary$testExecutionStatus' => '<p>The current status of the test execution.</p>', ], ], 'TestExecutionSummary' => [ 'base' => '<p>Summarizes metadata about the test execution.</p>', 'refs' => [ 'TestExecutionSummaryList$member' => NULL, ], ], 'TestExecutionSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListTestExecutionsResponse$testExecutions' => '<p>The list of test executions.</p>', ], ], 'TestExecutionTarget' => [ 'base' => '<p>Contains information about the bot used for the test execution.</p>', 'refs' => [ 'DescribeTestExecutionResponse$target' => '<p>The target bot for the test set execution details.</p>', 'StartTestExecutionRequest$target' => '<p>The target bot for the test set execution.</p>', 'StartTestExecutionResponse$target' => '<p>The target bot for the test set execution.</p>', 'TestExecutionSummary$target' => '<p>Contains information about the bot used for the test execution..</p>', ], ], 'TestResultMatchStatus' => [ 'base' => NULL, 'refs' => [ 'ConversationLevelIntentClassificationResultItem$matchResult' => '<p>The number of times the specific intent is used in the evaluation of intent level success or failure.</p>', 'ConversationLevelResultDetail$endToEndResult' => '<p>The success or failure of the streaming of the conversation.</p>', 'ConversationLevelResultDetail$speechTranscriptionResult' => '<p>The speech transcription success or failure details of the conversation.</p>', 'ConversationLevelSlotResolutionResultItem$matchResult' => '<p>The number of matching slots used in the slots listings for the slot resolution evaluation.</p>', 'ConversationLevelTestResultItem$endToEndResult' => '<p>The end-to-end success or failure of the test result evaluation item.</p>', 'ConversationLevelTestResultItem$speechTranscriptionResult' => '<p>The speech transcription success or failure of the test result evaluation item.</p>', 'ConversationLevelTestResultsFilterBy$endToEndResult' => '<p>The selection of matched or mismatched end-to-end status to filter test set results data at the conversation level.</p>', 'TestResultMatchStatusCountMap$key' => NULL, 'UserTurnResult$endToEndResult' => '<p>Specifies whether the expected and actual outputs match or not, or if there is an error in execution.</p>', 'UserTurnResult$intentMatchResult' => '<p>Specifies whether the expected and actual intents match or not.</p>', 'UserTurnResult$slotMatchResult' => '<p>Specifies whether the expected and actual slots match or not.</p>', 'UserTurnResult$speechTranscriptionResult' => '<p>Specifies whether the expected and actual speech transcriptions match or not, or if there is an error in execution.</p>', ], ], 'TestResultMatchStatusCountMap' => [ 'base' => NULL, 'refs' => [ 'IntentClassificationTestResultItemCounts$speechTranscriptionResultCounts' => '<p>The number of matched, mismatched, and execution error results for speech transcription for the intent.</p>', 'IntentClassificationTestResultItemCounts$intentMatchResultCounts' => '<p>The number of matched and mismatched results for intent recognition for the intent.</p>', 'OverallTestResultItem$speechTranscriptionResultCounts' => '<p>The number of speech transcription results in the overall test.</p>', 'OverallTestResultItem$endToEndResultCounts' => '<p>The number of results that succeeded.</p>', 'SlotResolutionTestResultItemCounts$speechTranscriptionResultCounts' => '<p>The number of matched, mismatched and execution error results for speech transcription for the slot.</p>', 'SlotResolutionTestResultItemCounts$slotMatchResultCounts' => '<p>The number of matched and mismatched results for slot resolution for the slot.</p>', ], ], 'TestResultSlotName' => [ 'base' => NULL, 'refs' => [ 'AgentTurnResult$actualElicitedSlot' => '<p>The actual elicited slot for the agent turn in a test set execution.</p>', 'ConversationLevelSlotResolutionResultItem$slotName' => '<p>The slot name in the slots list for the slot resolution details.</p>', 'SlotResolutionTestResultItem$slotName' => '<p>The name of the slot.</p>', ], ], 'TestResultTypeFilter' => [ 'base' => NULL, 'refs' => [ 'TestExecutionResultFilterBy$resultTypeFilter' => '<p>Specifies which results to filter. See <a href="https://docs.aws.amazon.com/lexv2/latest/dg/test-results-details-test-set.html">Test result details"&gt;Test results details</a> for details about different types of results.</p>', ], ], 'TestSetAgentPrompt' => [ 'base' => NULL, 'refs' => [ 'AgentTurnResult$expectedAgentPrompt' => '<p>The expected agent prompt for the agent turn in a test set execution.</p>', 'AgentTurnResult$actualAgentPrompt' => '<p>The actual agent prompt for the agent turn in a test set execution.</p>', 'AgentTurnSpecification$agentPrompt' => '<p>The agent prompt for the agent turn in a test set.</p>', ], ], 'TestSetConversationId' => [ 'base' => NULL, 'refs' => [ 'ConversationLevelTestResultItem$conversationId' => '<p>The conversation Id of the test result evaluation item.</p>', 'TestSetTurnRecord$conversationId' => '<p>The unique identifier for the conversation associated with the turn.</p>', 'UtteranceLevelTestResultItem$conversationId' => '<p>The unique identifier for the conversation associated with the result.</p>', ], ], 'TestSetDiscrepancyErrors' => [ 'base' => '<p>Contains details about the errors in the test set discrepancy report</p>', 'refs' => [ 'DescribeTestSetDiscrepancyReportResponse$testSetDiscrepancyTopErrors' => '<p>The top 200 error results from the test set discrepancy report.</p>', ], ], 'TestSetDiscrepancyReportBotAliasTarget' => [ 'base' => '<p>Contains information about the bot alias used for the test set discrepancy report.</p>', 'refs' => [ 'TestSetDiscrepancyReportResourceTarget$botAliasTarget' => '<p>Contains information about the bot alias used as the resource for the test set discrepancy report.</p>', ], ], 'TestSetDiscrepancyReportResourceTarget' => [ 'base' => '<p>Contains information about the resource used for the test set discrepancy report.</p>', 'refs' => [ 'CreateTestSetDiscrepancyReportRequest$target' => '<p>The target bot for the test set discrepancy report.</p>', 'CreateTestSetDiscrepancyReportResponse$target' => '<p>The target bot for the test set discrepancy report.</p>', 'DescribeTestSetDiscrepancyReportResponse$target' => '<p>The target bot location for the test set discrepancy report.</p>', ], ], 'TestSetDiscrepancyReportStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeTestSetDiscrepancyReportResponse$testSetDiscrepancyReportStatus' => '<p>The status for the test set discrepancy report.</p>', ], ], 'TestSetExportSpecification' => [ 'base' => '<p>Contains information about the test set that is exported.</p>', 'refs' => [ 'ExportResourceSpecification$testSetExportSpecification' => '<p>Specifications for the test set that is exported as a resource.</p>', ], ], 'TestSetGenerationDataSource' => [ 'base' => '<p>Contains information about the data source from which the test set is generated.</p>', 'refs' => [ 'DescribeTestSetGenerationResponse$generationDataSource' => '<p>The data source of the test set used for the test set generation.</p>', 'StartTestSetGenerationRequest$generationDataSource' => '<p>The data source for the test set generation.</p>', 'StartTestSetGenerationResponse$generationDataSource' => '<p> The data source for the test set generation.</p>', ], ], 'TestSetGenerationStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeTestSetGenerationResponse$testSetGenerationStatus' => '<p>The status for the test set generation.</p>', 'StartTestSetGenerationResponse$testSetGenerationStatus' => '<p> The status for the test set generation.</p>', ], ], 'TestSetImportInputLocation' => [ 'base' => '<p>Contains information about the Amazon S3 location from which the test set is imported.</p>', 'refs' => [ 'TestSetImportResourceSpecification$importInputLocation' => '<p>Contains information about the input location from where test-set should be imported.</p>', ], ], 'TestSetImportResourceSpecification' => [ 'base' => '<p>Contains information about the test set that is imported.</p>', 'refs' => [ 'ImportResourceSpecification$testSetImportResourceSpecification' => '<p>Specifications for the test set that is imported.</p>', ], ], 'TestSetIntentDiscrepancyItem' => [ 'base' => '<p>Contains information about discrepancy in an intent information between the test set and the bot.</p>', 'refs' => [ 'TestSetIntentDiscrepancyList$member' => NULL, ], ], 'TestSetIntentDiscrepancyList' => [ 'base' => NULL, 'refs' => [ 'TestSetDiscrepancyErrors$intentDiscrepancies' => '<p>Contains information about discrepancies found for intents between the test set and the bot.</p>', ], ], 'TestSetModality' => [ 'base' => NULL, 'refs' => [ 'DescribeTestSetResponse$modality' => '<p>Indicates whether the test set is audio or text data.</p>', 'TestSetImportResourceSpecification$modality' => '<p>Specifies whether the test-set being imported contains written or spoken data.</p>', 'TestSetSummary$modality' => '<p>Specifies whether the test set contains written or spoken data.</p>', 'UpdateTestSetResponse$modality' => '<p>Indicates whether audio or text is used for the updated test set.</p>', ], ], 'TestSetSlotDiscrepancyItem' => [ 'base' => '<p>Contains information about discrepancy in a slot information between the test set and the bot.</p>', 'refs' => [ 'TestSetSlotDiscrepancyList$member' => NULL, ], ], 'TestSetSlotDiscrepancyList' => [ 'base' => NULL, 'refs' => [ 'TestSetDiscrepancyErrors$slotDiscrepancies' => '<p>Contains information about discrepancies found for slots between the test set and the bot.</p>', ], ], 'TestSetSortAttribute' => [ 'base' => NULL, 'refs' => [ 'TestSetSortBy$attribute' => '<p>Specifies whether to sort the test sets by name or by the time they were last updated.</p>', ], ], 'TestSetSortBy' => [ 'base' => '<p>Contains information about the methods by which to sort the test set.</p>', 'refs' => [ 'ListTestSetsRequest$sortBy' => '<p>The sort order for the list of test sets.</p>', ], ], 'TestSetStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeTestSetResponse$status' => '<p>The status of the test set.</p>', 'TestSetSummary$status' => '<p>The status of the test set.</p>', 'UpdateTestSetResponse$status' => '<p>The status for the updated test set.</p>', ], ], 'TestSetStorageLocation' => [ 'base' => '<p>Contains information about the location in which the test set is stored.</p>', 'refs' => [ 'DescribeTestSetGenerationResponse$storageLocation' => '<p>The Amazon S3 storage location for the test set generation.</p>', 'DescribeTestSetResponse$storageLocation' => '<p>The Amazon S3 storage location for the test set data.</p>', 'StartTestSetGenerationRequest$storageLocation' => '<p>The Amazon S3 storage location for the test set generation.</p>', 'StartTestSetGenerationResponse$storageLocation' => '<p>The Amazon S3 storage location for the test set generation.</p>', 'TestSetImportResourceSpecification$storageLocation' => '<p>Contains information about the location that Amazon Lex uses to store the test-set.</p>', 'TestSetSummary$storageLocation' => '<p>Contains information about the location at which the test set is stored.</p>', 'UpdateTestSetResponse$storageLocation' => '<p>The Amazon S3 storage location for the updated test set.</p>', ], ], 'TestSetSummary' => [ 'base' => '<p>Contains summary information about the test set.</p>', 'refs' => [ 'TestSetSummaryList$member' => NULL, ], ], 'TestSetSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListTestSetsResponse$testSets' => '<p>The selected test sets in a list of test sets.</p>', ], ], 'TestSetTurnRecord' => [ 'base' => '<p>Contains information about a turn in a test set.</p>', 'refs' => [ 'TestSetTurnRecordList$member' => NULL, ], ], 'TestSetTurnRecordList' => [ 'base' => NULL, 'refs' => [ 'ListTestSetRecordsResponse$testSetRecords' => '<p>The list of records from the test set.</p>', ], ], 'TestSetTurnResult' => [ 'base' => '<p>Contains information about the results of the analysis of a turn in the test set.</p>', 'refs' => [ 'UtteranceLevelTestResultItem$turnResult' => '<p>Contains information about the turn associated with the result.</p>', ], ], 'TestSetUtteranceText' => [ 'base' => NULL, 'refs' => [ 'UserTurnOutputSpecification$transcript' => '<p>The transcript that is output for the user turn by the test execution.</p>', 'UtteranceInputSpecification$textInput' => '<p>A text input transcription of the utterance. It is only applicable for test-sets containing text data.</p>', ], ], 'TextInputSpecification' => [ 'base' => '<p>Specifies the text input specifications.</p>', 'refs' => [ 'PromptAttemptSpecification$textInputSpecification' => '<p>Specifies the settings on text input.</p>', ], ], 'TextLogDestination' => [ 'base' => '<p>Defines the Amazon CloudWatch Logs destination log group for conversation text logs.</p>', 'refs' => [ 'TextLogSetting$destination' => NULL, ], ], 'TextLogSetting' => [ 'base' => '<p>Defines settings to enable text conversation logs.</p>', 'refs' => [ 'TextLogSettingsList$member' => NULL, ], ], 'TextLogSettingsList' => [ 'base' => NULL, 'refs' => [ 'ConversationLogSettings$textLogSettings' => '<p>The Amazon CloudWatch Logs settings for logging text and metadata.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>Your request rate is too high. Reduce the frequency of requests.</p>', 'refs' => [], ], 'TimeDimension' => [ 'base' => NULL, 'refs' => [ 'RelativeAggregationDuration$timeDimension' => '<p>The type of time period that the <code>timeValue</code> field represents. </p>', ], ], 'TimeInMilliSeconds' => [ 'base' => NULL, 'refs' => [ 'AudioAndDTMFInputSpecification$startTimeoutMs' => '<p>Time for which a bot waits before assuming that the customer isn\'t going to speak or press a key. This timeout is shared between Audio and DTMF inputs.</p>', 'AudioSpecification$maxLengthMs' => '<p>Time for how long Amazon Lex waits before speech input is truncated and the speech is returned to application.</p>', 'AudioSpecification$endTimeoutMs' => '<p>Time for which a bot waits after the customer stops speaking to assume the utterance is finished.</p>', 'DTMFSpecification$endTimeoutMs' => '<p>How long the bot should wait after the last DTMF character input before assuming that the input has concluded.</p>', 'TextInputSpecification$startTimeoutMs' => '<p>Time for which a bot waits before re-prompting a customer for text input.</p>', ], ], 'TimeValue' => [ 'base' => NULL, 'refs' => [ 'RelativeAggregationDuration$timeValue' => '<p>The period of the time window to gather statistics for. The valid value depends on the setting of the <code>timeDimension</code> field.</p> <ul> <li> <p> <code>Hours</code> - 1/3/6/12/24</p> </li> <li> <p> <code>Days</code> - 3</p> </li> <li> <p> <code>Weeks</code> - 1/2</p> </li> </ul>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'AggregatedUtterancesSummary$utteranceFirstRecordedInAggregationDuration' => '<p>The date and time that the utterance was first recorded in the time window for aggregation. An utterance may have been sent to Amazon Lex before that time, but only utterances within the time window are counted.</p>', 'AggregatedUtterancesSummary$utteranceLastRecordedInAggregationDuration' => '<p>The last date and time that an utterance was recorded in the time window for aggregation. An utterance may be sent to Amazon Lex after that time, but only utterances within the time window are counted.</p>', 'BotAliasHistoryEvent$startDate' => '<p>The date and time that the event started.</p>', 'BotAliasHistoryEvent$endDate' => '<p>The date and time that the event ended.</p>', 'BotAliasReplicaSummary$creationDateTime' => '<p>The creation time and date for all the alias bot replications.</p>', 'BotAliasReplicaSummary$lastUpdatedDateTime' => '<p>The last time and date updated for all the alias bot replications.</p>', 'BotAliasSummary$creationDateTime' => '<p>A timestamp of the date and time that the bot alias was created.</p>', 'BotAliasSummary$lastUpdatedDateTime' => '<p>A timestamp of the date and time that the bot alias was last updated.</p>', 'BotLocaleHistoryEvent$eventDate' => '<p>A timestamp of the date and time that the event occurred.</p>', 'BotLocaleSummary$lastUpdatedDateTime' => '<p>A timestamp of the date and time that the bot locale was last updated.</p>', 'BotLocaleSummary$lastBuildSubmittedDateTime' => '<p>A timestamp of the date and time that the bot locale was last built.</p>', 'BotRecommendationSummary$creationDateTime' => '<p>A timestamp of the date and time that the bot recommendation was created.</p>', 'BotRecommendationSummary$lastUpdatedDateTime' => '<p>A timestamp of the date and time that the bot recommendation was last updated.</p>', 'BotReplicaSummary$creationDateTime' => '<p>The creation time and date for the replicated bots.</p>', 'BotSummary$lastUpdatedDateTime' => '<p>The date and time that the bot was last updated.</p>', 'BotVersionReplicaSummary$creationDateTime' => '<p>The creation date and time of the replication status for all the replicated bots.</p>', 'BotVersionSummary$creationDateTime' => '<p>A timestamp of the date and time that the version was created.</p>', 'BuildBotLocaleResponse$lastBuildSubmittedDateTime' => '<p>A timestamp indicating the date and time that the bot was last built for this locale.</p>', 'ConversationLogsDataSourceFilterBy$startTime' => '<p>The start time for the conversation log.</p>', 'ConversationLogsDataSourceFilterBy$endTime' => '<p>The end time for the conversation log.</p>', 'CreateBotAliasResponse$creationDateTime' => '<p>A Unix timestamp indicating the date and time that the bot alias was created.</p>', 'CreateBotLocaleResponse$creationDateTime' => '<p>A timestamp specifying the date and time that the bot locale was created.</p>', 'CreateBotReplicaResponse$creationDateTime' => '<p>The creation date and time of the replicated bot generated.</p>', 'CreateBotResponse$creationDateTime' => '<p>A timestamp indicating the date and time that the bot was created.</p>', 'CreateBotVersionResponse$creationDateTime' => '<p>A timestamp of the date and time that the version was created.</p>', 'CreateExportResponse$creationDateTime' => '<p>The date and time that the request to export a bot was created.</p>', 'CreateIntentResponse$creationDateTime' => '<p>A timestamp of the date and time that the intent was created.</p>', 'CreateSlotResponse$creationDateTime' => '<p>The timestamp of the date and time that the slot was created.</p>', 'CreateSlotTypeResponse$creationDateTime' => '<p>A timestamp of the date and time that the slot type was created.</p>', 'CreateTestSetDiscrepancyReportResponse$creationDateTime' => '<p>The creation date and time for the test set discrepancy report.</p>', 'DateRangeFilter$startDateTime' => '<p>A timestamp indicating the start date for the date range filter.</p>', 'DateRangeFilter$endDateTime' => '<p>A timestamp indicating the end date for the date range filter.</p>', 'DescribeBotAliasResponse$creationDateTime' => '<p>A timestamp of the date and time that the alias was created.</p>', 'DescribeBotAliasResponse$lastUpdatedDateTime' => '<p>A timestamp of the date and time that the alias was last updated.</p>', 'DescribeBotLocaleResponse$creationDateTime' => '<p>The date and time that the locale was created.</p>', 'DescribeBotLocaleResponse$lastUpdatedDateTime' => '<p>The date and time that the locale was last updated.</p>', 'DescribeBotLocaleResponse$lastBuildSubmittedDateTime' => '<p>The date and time that the locale was last submitted for building.</p>', 'DescribeBotRecommendationResponse$creationDateTime' => '<p>The date and time that the bot recommendation was created.</p>', 'DescribeBotRecommendationResponse$lastUpdatedDateTime' => '<p>The date and time that the bot recommendation was last updated.</p>', 'DescribeBotReplicaResponse$creationDateTime' => '<p>The creation date and time of the replicated bot being monitored.</p>', 'DescribeBotResourceGenerationResponse$creationDateTime' => '<p>The date and time at which the item was generated.</p>', 'DescribeBotResourceGenerationResponse$lastUpdatedDateTime' => '<p>The date and time at which the generated item was updated.</p>', 'DescribeBotResponse$creationDateTime' => '<p>A timestamp of the date and time that the bot was created.</p>', 'DescribeBotResponse$lastUpdatedDateTime' => '<p>A timestamp of the date and time that the bot was last updated.</p>', 'DescribeBotVersionResponse$creationDateTime' => '<p>A timestamp of the date and time that the bot version was created.</p>', 'DescribeCustomVocabularyMetadataResponse$creationDateTime' => '<p>The date and time that the custom vocabulary was created.</p>', 'DescribeCustomVocabularyMetadataResponse$lastUpdatedDateTime' => '<p>The date and time that the custom vocabulary was last updated.</p>', 'DescribeExportResponse$creationDateTime' => '<p>The date and time that the export was created.</p>', 'DescribeExportResponse$lastUpdatedDateTime' => '<p>The last date and time that the export was updated.</p>', 'DescribeImportResponse$creationDateTime' => '<p>The date and time that the import was created.</p>', 'DescribeImportResponse$lastUpdatedDateTime' => '<p>The date and time that the import was last updated.</p>', 'DescribeIntentResponse$creationDateTime' => '<p>A timestamp of the date and time that the intent was created.</p>', 'DescribeIntentResponse$lastUpdatedDateTime' => '<p>A timestamp of the date and time that the intent was last updated.</p>', 'DescribeSlotResponse$creationDateTime' => '<p>A timestamp of the date and time that the slot was created.</p>', 'DescribeSlotResponse$lastUpdatedDateTime' => '<p>A timestamp of the date and time that the slot was last updated.</p>', 'DescribeSlotTypeResponse$creationDateTime' => '<p>A timestamp of the date and time that the slot type was created.</p>', 'DescribeSlotTypeResponse$lastUpdatedDateTime' => '<p>A timestamp of the date and time that the slot type was last updated.</p>', 'DescribeTestExecutionResponse$creationDateTime' => '<p>The execution creation date and time for the test set execution.</p>', 'DescribeTestExecutionResponse$lastUpdatedDateTime' => '<p>The date and time of the last update for the execution.</p>', 'DescribeTestSetDiscrepancyReportResponse$creationDateTime' => '<p>The time and date of creation for the test set discrepancy report.</p>', 'DescribeTestSetDiscrepancyReportResponse$lastUpdatedDataTime' => '<p>The date and time of the last update for the test set discrepancy report.</p>', 'DescribeTestSetGenerationResponse$creationDateTime' => '<p>The creation date and time for the test set generation.</p>', 'DescribeTestSetGenerationResponse$lastUpdatedDateTime' => '<p>The date and time of the last update for the test set generation.</p>', 'DescribeTestSetResponse$creationDateTime' => '<p>The creation date and time for the test set data.</p>', 'DescribeTestSetResponse$lastUpdatedDateTime' => '<p>The date and time for the last update of the test set data.</p>', 'ExportSummary$creationDateTime' => '<p>The date and time that the export was created.</p>', 'ExportSummary$lastUpdatedDateTime' => '<p>The date and time that the export was last updated.</p>', 'GenerationSummary$creationDateTime' => '<p>The date and time at which the generation request was made.</p>', 'GenerationSummary$lastUpdatedDateTime' => '<p>The date and time at which the generation request was last updated.</p>', 'ImportSummary$creationDateTime' => '<p>The date and time that the import was created.</p>', 'ImportSummary$lastUpdatedDateTime' => '<p>The date and time that the import was last updated.</p>', 'IntentSummary$lastUpdatedDateTime' => '<p>The timestamp of the date and time that the intent was last updated.</p>', 'ListAggregatedUtterancesResponse$aggregationWindowStartTime' => '<p>The date and time that the aggregation window begins. Only data collected after this time is returned in the results.</p>', 'ListAggregatedUtterancesResponse$aggregationWindowEndTime' => '<p>The date and time that the aggregation window ends. Only data collected between the start time and the end time are returned in the results. </p>', 'ListAggregatedUtterancesResponse$aggregationLastRefreshedDateTime' => '<p>The last date and time that the aggregated data was collected. The time period depends on the length of the aggregation window.</p> <ul> <li> <p> <b>Hours</b> - for 1 hour time window, every half hour; otherwise every hour.</p> </li> <li> <p> <b>Days</b> - every 6 hours</p> </li> <li> <p> <b>Weeks</b> - for a one week time window, every 12 hours; otherwise, every day</p> </li> </ul>', 'ListIntentMetricsRequest$startDateTime' => '<p>The timestamp that marks the beginning of the range of time for which you want to see intent metrics.</p>', 'ListIntentMetricsRequest$endDateTime' => '<p>The date and time that marks the end of the range of time for which you want to see intent metrics.</p>', 'ListIntentPathsRequest$startDateTime' => '<p>The date and time that marks the beginning of the range of time for which you want to see intent path metrics.</p>', 'ListIntentPathsRequest$endDateTime' => '<p>The date and time that marks the end of the range of time for which you want to see intent path metrics.</p>', 'ListIntentStageMetricsRequest$startDateTime' => '<p>The date and time that marks the beginning of the range of time for which you want to see intent stage metrics.</p>', 'ListIntentStageMetricsRequest$endDateTime' => '<p>The date and time that marks the end of the range of time for which you want to see intent stage metrics.</p>', 'ListSessionAnalyticsDataRequest$startDateTime' => '<p>The date and time that marks the beginning of the range of time for which you want to see session analytics.</p>', 'ListSessionAnalyticsDataRequest$endDateTime' => '<p>The date and time that marks the end of the range of time for which you want to see session analytics.</p>', 'ListSessionMetricsRequest$startDateTime' => '<p>The date and time that marks the beginning of the range of time for which you want to see session metrics.</p>', 'ListSessionMetricsRequest$endDateTime' => '<p>The date and time that marks the end of the range of time for which you want to see session metrics.</p>', 'ListUtteranceAnalyticsDataRequest$startDateTime' => '<p>The date and time that marks the beginning of the range of time for which you want to see utterance analytics.</p>', 'ListUtteranceAnalyticsDataRequest$endDateTime' => '<p>The date and time that marks the end of the range of time for which you want to see utterance analytics.</p>', 'ListUtteranceMetricsRequest$startDateTime' => '<p>The date and time that marks the beginning of the range of time for which you want to see utterance metrics.</p>', 'ListUtteranceMetricsRequest$endDateTime' => '<p>The date and time that marks the end of the range of time for which you want to see utterance metrics.</p>', 'SessionSpecification$conversationStartTime' => '<p>The date and time when the conversation began. A conversation is defined as a unique combination of a <code>sessionId</code> and an <code>originatingRequestId</code>.</p>', 'SessionSpecification$conversationEndTime' => '<p>The date and time when the conversation ended. A conversation is defined as a unique combination of a <code>sessionId</code> and an <code>originatingRequestId</code>.</p>', 'SlotSummary$lastUpdatedDateTime' => '<p>The timestamp of the last date and time that the slot was updated.</p>', 'SlotTypeSummary$lastUpdatedDateTime' => '<p>A timestamp of the date and time that the slot type was last updated.</p>', 'StartBotRecommendationResponse$creationDateTime' => '<p>A timestamp of the date and time that the bot recommendation was created.</p>', 'StartBotResourceGenerationResponse$creationDateTime' => '<p>The date and time at which the generation request was made.</p>', 'StartImportResponse$creationDateTime' => '<p>The date and time that the import request was created.</p>', 'StartTestExecutionResponse$creationDateTime' => '<p>The creation date and time for the test set execution.</p>', 'StartTestSetGenerationResponse$creationDateTime' => '<p> The creation date and time for the test set generation.</p>', 'TestExecutionSummary$creationDateTime' => '<p>The date and time at which the test execution was created.</p>', 'TestExecutionSummary$lastUpdatedDateTime' => '<p>The date and time at which the test execution was last updated.</p>', 'TestSetSummary$creationDateTime' => '<p>The date and time at which the test set was created.</p>', 'TestSetSummary$lastUpdatedDateTime' => '<p>The date and time at which the test set was last updated.</p>', 'UpdateBotAliasResponse$creationDateTime' => '<p>A timestamp of the date and time that the bot was created.</p>', 'UpdateBotAliasResponse$lastUpdatedDateTime' => '<p>A timestamp of the date and time that the bot was last updated.</p>', 'UpdateBotLocaleResponse$creationDateTime' => '<p>A timestamp of the date and time that the locale was created.</p>', 'UpdateBotLocaleResponse$lastUpdatedDateTime' => '<p>A timestamp of the date and time that the locale was last updated.</p>', 'UpdateBotRecommendationResponse$creationDateTime' => '<p>A timestamp of the date and time that the bot recommendation was created.</p>', 'UpdateBotRecommendationResponse$lastUpdatedDateTime' => '<p>A timestamp of the date and time that the bot recommendation was last updated.</p>', 'UpdateBotResponse$creationDateTime' => '<p>A timestamp of the date and time that the bot was created.</p>', 'UpdateBotResponse$lastUpdatedDateTime' => '<p>A timestamp of the date and time that the bot was last updated.</p>', 'UpdateExportResponse$creationDateTime' => '<p>The date and time that the export was created.</p>', 'UpdateExportResponse$lastUpdatedDateTime' => '<p>The date and time that the export was last updated.</p>', 'UpdateIntentResponse$creationDateTime' => '<p>A timestamp of when the intent was created.</p>', 'UpdateIntentResponse$lastUpdatedDateTime' => '<p>A timestamp of the last time that the intent was modified.</p>', 'UpdateSlotResponse$creationDateTime' => '<p>The timestamp of the date and time that the slot was created.</p>', 'UpdateSlotResponse$lastUpdatedDateTime' => '<p>The timestamp of the date and time that the slot was last updated.</p>', 'UpdateSlotTypeResponse$creationDateTime' => '<p>The timestamp of the date and time that the slot type was created.</p>', 'UpdateSlotTypeResponse$lastUpdatedDateTime' => '<p>A timestamp of the date and time that the slot type was last updated.</p>', 'UpdateTestSetResponse$creationDateTime' => '<p>The creation date and time for the updated test set.</p>', 'UpdateTestSetResponse$lastUpdatedDateTime' => '<p> The date and time of the last update for the updated test set.</p>', 'UtteranceSpecification$conversationStartTime' => '<p>The date and time when the conversation in which the utterance took place began. A conversation is defined as a unique combination of a <code>sessionId</code> and an <code>originatingRequestId</code>.</p>', 'UtteranceSpecification$conversationEndTime' => '<p>The date and time when the conversation in which the utterance took place ended. A conversation is defined as a unique combination of a <code>sessionId</code> and an <code>originatingRequestId</code>.</p>', 'UtteranceSpecification$utteranceTimestamp' => '<p>The date and time when the utterance took place.</p>', ], ], 'Transcript' => [ 'base' => NULL, 'refs' => [ 'AssociatedTranscript$transcript' => '<p>The content of the transcript that meets the search filter criteria. For the JSON format of the transcript, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/designing-output-format.html">Output transcript format</a>.</p>', ], ], 'TranscriptFilter' => [ 'base' => '<p>The object representing the filter that Amazon Lex will use to select the appropriate transcript.</p>', 'refs' => [ 'S3BucketTranscriptSource$transcriptFilter' => '<p>The object that contains the filter which will be applied when Amazon Lex reads through the Amazon S3 bucket. Specify this object if you want Amazon Lex to read only a subset of the Amazon S3 bucket based on the filter you provide.</p>', ], ], 'TranscriptFormat' => [ 'base' => NULL, 'refs' => [ 'S3BucketTranscriptSource$transcriptFormat' => '<p>The format of the transcript content. Currently, Genie only supports the Amazon Lex transcript format.</p>', ], ], 'TranscriptSourceSetting' => [ 'base' => '<p>Indicates the setting of the location where the transcript is stored.</p>', 'refs' => [ 'DescribeBotRecommendationResponse$transcriptSourceSetting' => '<p>The object representing the Amazon S3 bucket containing the transcript, as well as the associated metadata.</p>', 'StartBotRecommendationRequest$transcriptSourceSetting' => '<p>The object representing the Amazon S3 bucket containing the transcript, as well as the associated metadata.</p>', 'StartBotRecommendationResponse$transcriptSourceSetting' => '<p>The object representing the Amazon S3 bucket containing the transcript, as well as the associated metadata.</p>', 'UpdateBotRecommendationResponse$transcriptSourceSetting' => '<p>The object representing the Amazon S3 bucket containing the transcript, as well as the associated metadata.</p>', ], ], 'TurnNumber' => [ 'base' => NULL, 'refs' => [ 'TestSetTurnRecord$turnNumber' => '<p>The number of turns that has elapsed up to that turn.</p>', ], ], 'TurnSpecification' => [ 'base' => '<p>Contains information about the messages in the turn.</p>', 'refs' => [ 'TestSetTurnRecord$turnSpecification' => '<p>Contains information about the agent or user turn depending upon type of turn.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateBotAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateBotAliasResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateBotLocaleRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateBotLocaleResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateBotRecommendationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateBotRecommendationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateBotRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateBotResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateCustomVocabularyItemsList' => [ 'base' => NULL, 'refs' => [ 'BatchUpdateCustomVocabularyItemRequest$customVocabularyItemList' => '<p>A list of custom vocabulary items with updated fields. Each entry must contain a phrase and can optionally contain a displayAs and/or a weight.</p>', ], ], 'UpdateExportRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateExportResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateIntentRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateIntentResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateResourcePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateResourcePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSlotRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSlotResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSlotTypeRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSlotTypeResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTestSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTestSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'UserTurnInputSpecification' => [ 'base' => '<p>Contains information about the user messages in the turn in the input.</p>', 'refs' => [ 'UserTurnResult$input' => '<p>Contains information about the user messages in the turn in the input.</p>', 'UserTurnSpecification$input' => '<p>Contains information about the user messages in the turn in the input.</p>', ], ], 'UserTurnIntentOutput' => [ 'base' => '<p>Contains information about the intent that is output for the turn by the test execution.</p>', 'refs' => [ 'UserTurnOutputSpecification$intent' => '<p>Contains information about the intent.</p>', ], ], 'UserTurnOutputSpecification' => [ 'base' => '<p>Contains results that are output for the user turn by the test execution.</p>', 'refs' => [ 'UserTurnResult$expectedOutput' => '<p>Contains information about the expected output for the user turn.</p>', 'UserTurnResult$actualOutput' => '<p>Contains information about the actual output for the user turn.</p>', 'UserTurnSpecification$expected' => '<p>Contains results about the expected output for the user turn.</p>', ], ], 'UserTurnResult' => [ 'base' => '<p>Contains the results for the user turn by the test execution.</p>', 'refs' => [ 'TestSetTurnResult$user' => '<p>Contains information about the user messages in the turn.</p>', ], ], 'UserTurnSlotOutput' => [ 'base' => '<p>Contains information about a slot output by the test set execution.</p>', 'refs' => [ 'UserTurnSlotOutputList$member' => NULL, 'UserTurnSlotOutputMap$value' => NULL, ], ], 'UserTurnSlotOutputList' => [ 'base' => NULL, 'refs' => [ 'UserTurnSlotOutput$values' => '<p>Values that are output by the slot recognition.</p>', ], ], 'UserTurnSlotOutputMap' => [ 'base' => NULL, 'refs' => [ 'UserTurnIntentOutput$slots' => '<p>The slots associated with the intent.</p>', 'UserTurnSlotOutput$subSlots' => '<p>A list of items mapping the name of the subslots to information about those subslots.</p>', ], ], 'UserTurnSpecification' => [ 'base' => '<p>Contains information about the expected and input values for the user turn.</p>', 'refs' => [ 'TurnSpecification$userTurn' => '<p>Contains information about the user messages in the turn.</p>', ], ], 'Utterance' => [ 'base' => NULL, 'refs' => [ 'AggregatedUtterancesSummary$utterance' => '<p>The text of the utterance. If the utterance was used with the <code>RecognizeUtterance</code> operation, the text is the transcription of the audio utterance.</p>', 'SampleUtterance$utterance' => '<p>The sample utterance that Amazon Lex uses to build its machine-learning model to recognize intents.</p>', ], ], 'UtteranceAggregationDuration' => [ 'base' => '<p>Provides parameters for setting the time window and duration for aggregating utterance data.</p>', 'refs' => [ 'ListAggregatedUtterancesRequest$aggregationDuration' => '<p>The time window for aggregating the utterance information. You can specify a time between one hour and two weeks.</p>', 'ListAggregatedUtterancesResponse$aggregationDuration' => '<p>The time period used to aggregate the utterance data.</p>', ], ], 'UtteranceAudioInputSpecification' => [ 'base' => '<p>Contains information about the audio for an utterance.</p>', 'refs' => [ 'UtteranceInputSpecification$audioInput' => '<p>Contains information about the audio input for an utterance.</p>', ], ], 'UtteranceBotResponse' => [ 'base' => '<p>An object that contains a response to the utterance from the bot.</p>', 'refs' => [ 'UtteranceBotResponses$member' => NULL, ], ], 'UtteranceBotResponses' => [ 'base' => NULL, 'refs' => [ 'UtteranceSpecification$botResponses' => '<p>A list of objects containing information about the bot response to the utterance.</p>', ], ], 'UtteranceContentType' => [ 'base' => NULL, 'refs' => [ 'UtteranceBotResponse$contentType' => '<p>The type of the response. The following values are possible:</p> <ul> <li> <p> <code>PlainText</code> – A plain text string.</p> </li> <li> <p> <code>CustomPayload</code> – A response string that you can customize to include data or metadata for your application.</p> </li> <li> <p> <code>SSML</code> – A string that includes Speech Synthesis Markup Language to customize the audio response.</p> </li> <li> <p> <code>ImageResponseCard</code> – An image with buttons that the customer can select. See <a href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_runtime_ImageResponseCard.html">ImageResponseCard</a> for more information.</p> </li> </ul>', ], ], 'UtteranceDataSortBy' => [ 'base' => '<p>An object specifying the measure and method by which to sort the utterance data.</p>', 'refs' => [ 'ListUtteranceAnalyticsDataRequest$sortBy' => '<p>An object specifying the measure and method by which to sort the utterance analytics data.</p>', ], ], 'UtteranceInputSpecification' => [ 'base' => '<p>Contains information about input of an utterance.</p>', 'refs' => [ 'UserTurnInputSpecification$utteranceInput' => '<p>The utterance input in the user turn.</p>', ], ], 'UtteranceLevelTestResultItem' => [ 'base' => '<p>Contains information about multiple utterances in the results of a test set execution.</p>', 'refs' => [ 'UtteranceLevelTestResultItemList$member' => NULL, ], ], 'UtteranceLevelTestResultItemList' => [ 'base' => NULL, 'refs' => [ 'UtteranceLevelTestResults$items' => '<p>Contains information about an utterance in the results of the test set execution.</p>', ], ], 'UtteranceLevelTestResults' => [ 'base' => '<p>Contains information about the utterances in the results of the test set execution.</p>', 'refs' => [ 'TestExecutionResultItems$utteranceLevelTestResults' => '<p>Results related to utterances in the test set.</p>', ], ], 'UtteranceSpecification' => [ 'base' => '<p>An object containing information about a specific utterance.</p>', 'refs' => [ 'UtteranceSpecifications$member' => NULL, ], ], 'UtteranceSpecifications' => [ 'base' => NULL, 'refs' => [ 'ListUtteranceAnalyticsDataResponse$utterances' => '<p>A list of objects, each of which contains information about an utterance in a user session with your bot.</p>', ], ], 'UtteranceUnderstood' => [ 'base' => NULL, 'refs' => [ 'UtteranceSpecification$utteranceUnderstood' => '<p>Specifies whether the bot understood the utterance or not.</p>', ], ], 'ValidationException' => [ 'base' => '<p>One of the input parameters in your request isn\'t valid. Check the parameters and try your request again.</p>', 'refs' => [], ], 'Value' => [ 'base' => NULL, 'refs' => [ 'SampleValue$value' => '<p>The value that can be used for a slot type.</p>', ], ], 'VoiceEngine' => [ 'base' => NULL, 'refs' => [ 'VoiceSettings$engine' => '<p>Indicates the type of Amazon Polly voice that Amazon Lex should use for voice interaction with the user. For more information, see the <a href="https://docs.aws.amazon.com/polly/latest/dg/API_SynthesizeSpeech.html#polly-SynthesizeSpeech-request-Engine"> <code>engine</code> parameter of the <code>SynthesizeSpeech</code> operation</a> in the <i>Amazon Polly developer guide</i>.</p> <p>If you do not specify a value, the default is <code>standard</code>.</p>', ], ], 'VoiceId' => [ 'base' => NULL, 'refs' => [ 'VoiceSettings$voiceId' => '<p>The identifier of the Amazon Polly voice to use.</p>', ], ], 'VoiceSettings' => [ 'base' => '<p>Defines settings for using an Amazon Polly voice to communicate with a user.</p>', 'refs' => [ 'BotLocaleImportSpecification$voiceSettings' => NULL, 'CreateBotLocaleRequest$voiceSettings' => '<p>The Amazon Polly voice ID that Amazon Lex uses for voice interaction with the user.</p>', 'CreateBotLocaleResponse$voiceSettings' => '<p>The Amazon Polly voice ID that Amazon Lex uses for voice interaction with the user.</p>', 'DescribeBotLocaleResponse$voiceSettings' => '<p>The Amazon Polly voice Amazon Lex uses for voice interaction with the user.</p>', 'UpdateBotLocaleRequest$voiceSettings' => '<p>The new Amazon Polly voice Amazon Lex should use for voice interaction with the user.</p>', 'UpdateBotLocaleResponse$voiceSettings' => '<p>The updated Amazon Polly voice to use for voice interaction with the user.</p>', ], ], 'WaitAndContinueSpecification' => [ 'base' => '<p>Specifies the prompts that Amazon Lex uses while a bot is waiting for customer input. </p>', 'refs' => [ 'SlotValueElicitationSetting$waitAndContinueSpecification' => NULL, 'SubSlotValueElicitationSetting$waitAndContinueSpecification' => NULL, ], ], 'Weight' => [ 'base' => NULL, 'refs' => [ 'CustomVocabularyItem$weight' => '<p>The weight assigned for the custom vocabulary item from the custom vocabulary list.</p>', 'NewCustomVocabularyItem$weight' => '<p>The weight assigned to the new custom vocabulary item from the custom vocabulary list.</p>', ], ], ],];
