<?php
// This file was auto-generated from sdk-root/src/data/neptunedata/2023-08-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<p><fullname>Neptune Data API</fullname> <p>The Amazon Neptune data API provides SDK support for more than 40 of Neptune\'s data operations, including data loading, query execution, data inquiry, and machine learning. It supports the Gremlin and openCypher query languages, and is available in all SDK languages. It automatically signs API requests and greatly simplifies integrating Neptune into your applications.</p></p>', 'operations' => [ 'CancelGremlinQuery' => '<p>Cancels a Gremlin query. See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/gremlin-api-status-cancel.html">Gremlin query cancellation</a> for more information.</p> <p>When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelquery">neptune-db:CancelQuery</a> IAM action in that cluster.</p>', 'CancelLoaderJob' => '<p>Cancels a specified load job. This is an HTTP <code>DELETE</code> request. See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/load-api-reference-status.htm">Neptune Loader Get-Status API</a> for more information.</p> <p>When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelloaderjob">neptune-db:CancelLoaderJob</a> IAM action in that cluster..</p>', 'CancelMLDataProcessingJob' => '<p>Cancels a Neptune ML data processing job. See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-dataprocessing.html">The <code>dataprocessing</code> command</a>.</p> <p>When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelmldataprocessingjob">neptune-db:CancelMLDataProcessingJob</a> IAM action in that cluster.</p>', 'CancelMLModelTrainingJob' => '<p>Cancels a Neptune ML model training job. See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-modeltraining.html">Model training using the <code>modeltraining</code> command</a>.</p> <p>When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelmlmodeltrainingjob">neptune-db:CancelMLModelTrainingJob</a> IAM action in that cluster.</p>', 'CancelMLModelTransformJob' => '<p>Cancels a specified model transform job. See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-model-transform.html">Use a trained model to generate new model artifacts</a>.</p> <p>When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelmlmodeltransformjob">neptune-db:CancelMLModelTransformJob</a> IAM action in that cluster.</p>', 'CancelOpenCypherQuery' => '<p>Cancels a specified openCypher query. See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-opencypher-status.html">Neptune openCypher status endpoint</a> for more information.</p> <p>When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelquery">neptune-db:CancelQuery</a> IAM action in that cluster.</p>', 'CreateMLEndpoint' => '<p>Creates a new Neptune ML inference endpoint that lets you query one specific model that the model-training process constructed. See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-endpoints.html">Managing inference endpoints using the endpoints command</a>.</p> <p>When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#createmlendpoint">neptune-db:CreateMLEndpoint</a> IAM action in that cluster.</p>', 'DeleteMLEndpoint' => '<p>Cancels the creation of a Neptune ML inference endpoint. See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-endpoints.html">Managing inference endpoints using the endpoints command</a>.</p> <p>When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#deletemlendpoint">neptune-db:DeleteMLEndpoint</a> IAM action in that cluster.</p>', 'DeletePropertygraphStatistics' => '<p>Deletes statistics for Gremlin and openCypher (property graph) data.</p> <p>When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#deletestatistics">neptune-db:DeleteStatistics</a> IAM action in that cluster.</p>', 'DeleteSparqlStatistics' => '<p>Deletes SPARQL statistics</p> <p>When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#deletestatistics">neptune-db:DeleteStatistics</a> IAM action in that cluster.</p>', 'ExecuteFastReset' => '<p>The fast reset REST API lets you reset a Neptune graph quicky and easily, removing all of its data.</p> <p>Neptune fast reset is a two-step process. First you call <code>ExecuteFastReset</code> with <code>action</code> set to <code>initiateDatabaseReset</code>. This returns a UUID token which you then include when calling <code>ExecuteFastReset</code> again with <code>action</code> set to <code>performDatabaseReset</code>. See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/manage-console-fast-reset.html">Empty an Amazon Neptune DB cluster using the fast reset API</a>.</p> <p>When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#resetdatabase">neptune-db:ResetDatabase</a> IAM action in that cluster.</p>', 'ExecuteGremlinExplainQuery' => '<p>Executes a Gremlin Explain query.</p> <p>Amazon Neptune has added a Gremlin feature named <code>explain</code> that provides is a self-service tool for understanding the execution approach being taken by the Neptune engine for the query. You invoke it by adding an <code>explain</code> parameter to an HTTP call that submits a Gremlin query.</p> <p>The explain feature provides information about the logical structure of query execution plans. You can use this information to identify potential evaluation and execution bottlenecks and to tune your query, as explained in <a href="https://docs.aws.amazon.com/neptune/latest/userguide/gremlin-traversal-tuning.html">Tuning Gremlin queries</a>. You can also use query hints to improve query execution plans.</p> <p>When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows one of the following IAM actions in that cluster, depending on the query:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#readdataviaquery">neptune-db:ReadDataViaQuery</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#writedataviaquery">neptune-db:WriteDataViaQuery</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#deletedataviaquery">neptune-db:DeleteDataViaQuery</a> </p> </li> </ul> <p>Note that the <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys">neptune-db:QueryLanguage:Gremlin</a> IAM condition key can be used in the policy document to restrict the use of Gremlin queries (see <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available in Neptune IAM data-access policy statements</a>).</p>', 'ExecuteGremlinProfileQuery' => '<p>Executes a Gremlin Profile query, which runs a specified traversal, collects various metrics about the run, and produces a profile report as output. See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/gremlin-profile-api.html">Gremlin profile API in Neptune</a> for details.</p> <p>When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#readdataviaquery">neptune-db:ReadDataViaQuery</a> IAM action in that cluster.</p> <p>Note that the <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys">neptune-db:QueryLanguage:Gremlin</a> IAM condition key can be used in the policy document to restrict the use of Gremlin queries (see <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available in Neptune IAM data-access policy statements</a>).</p>', 'ExecuteGremlinQuery' => '<p>This commands executes a Gremlin query. Amazon Neptune is compatible with Apache TinkerPop3 and Gremlin, so you can use the Gremlin traversal language to query the graph, as described under <a href="https://tinkerpop.apache.org/docs/current/reference/#graph">The Graph</a> in the Apache TinkerPop3 documentation. More details can also be found in <a href="https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-gremlin.html">Accessing a Neptune graph with Gremlin</a>.</p> <p>When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that enables one of the following IAM actions in that cluster, depending on the query:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#readdataviaquery">neptune-db:ReadDataViaQuery</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#writedataviaquery">neptune-db:WriteDataViaQuery</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#deletedataviaquery">neptune-db:DeleteDataViaQuery</a> </p> </li> </ul> <p>Note that the <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys">neptune-db:QueryLanguage:Gremlin</a> IAM condition key can be used in the policy document to restrict the use of Gremlin queries (see <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available in Neptune IAM data-access policy statements</a>).</p>', 'ExecuteOpenCypherExplainQuery' => '<p>Executes an openCypher <code>explain</code> request. See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-opencypher-explain.html">The openCypher explain feature</a> for more information.</p> <p>When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#readdataviaquery">neptune-db:ReadDataViaQuery</a> IAM action in that cluster.</p> <p>Note that the <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys">neptune-db:QueryLanguage:OpenCypher</a> IAM condition key can be used in the policy document to restrict the use of openCypher queries (see <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available in Neptune IAM data-access policy statements</a>).</p>', 'ExecuteOpenCypherQuery' => '<p>Executes an openCypher query. See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-opencypher.html">Accessing the Neptune Graph with openCypher</a> for more information.</p> <p>Neptune supports building graph applications using openCypher, which is currently one of the most popular query languages among developers working with graph databases. Developers, business analysts, and data scientists like openCypher\'s declarative, SQL-inspired syntax because it provides a familiar structure in which to querying property graphs.</p> <p>The openCypher language was originally developed by Neo4j, then open-sourced in 2015 and contributed to the <a href="https://opencypher.org/">openCypher project</a> under an Apache 2 open-source license.</p> <p>Note that when invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows one of the following IAM actions in that cluster, depending on the query:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#readdataviaquery">neptune-db:ReadDataViaQuery</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#writedataviaquery">neptune-db:WriteDataViaQuery</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#deletedataviaquery">neptune-db:DeleteDataViaQuery</a> </p> </li> </ul> <p>Note also that the <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys">neptune-db:QueryLanguage:OpenCypher</a> IAM condition key can be used in the policy document to restrict the use of openCypher queries (see <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available in Neptune IAM data-access policy statements</a>).</p>', 'GetEngineStatus' => '<p>Retrieves the status of the graph database on the host.</p> <p>When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getenginestatus">neptune-db:GetEngineStatus</a> IAM action in that cluster.</p>', 'GetGremlinQueryStatus' => '<p>Gets the status of a specified Gremlin query.</p> <p>When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getquerystatus">neptune-db:GetQueryStatus</a> IAM action in that cluster.</p> <p>Note that the <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys">neptune-db:QueryLanguage:Gremlin</a> IAM condition key can be used in the policy document to restrict the use of Gremlin queries (see <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available in Neptune IAM data-access policy statements</a>).</p>', 'GetLoaderJobStatus' => '<p>Gets status information about a specified load job. Neptune keeps track of the most recent 1,024 bulk load jobs, and stores the last 10,000 error details per job.</p> <p>See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/load-api-reference-status.htm">Neptune Loader Get-Status API</a> for more information.</p> <p>When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getloaderjobstatus">neptune-db:GetLoaderJobStatus</a> IAM action in that cluster..</p>', 'GetMLDataProcessingJob' => '<p>Retrieves information about a specified data processing job. See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-dataprocessing.html">The <code>dataprocessing</code> command</a>.</p> <p>When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getmldataprocessingjobstatus">neptune-db:neptune-db:GetMLDataProcessingJobStatus</a> IAM action in that cluster.</p>', 'GetMLEndpoint' => '<p>Retrieves details about an inference endpoint. See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-endpoints.html">Managing inference endpoints using the endpoints command</a>.</p> <p>When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getmlendpointstatus">neptune-db:GetMLEndpointStatus</a> IAM action in that cluster.</p>', 'GetMLModelTrainingJob' => '<p>Retrieves information about a Neptune ML model training job. See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-modeltraining.html">Model training using the <code>modeltraining</code> command</a>.</p> <p>When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getmlmodeltrainingjobstatus">neptune-db:GetMLModelTrainingJobStatus</a> IAM action in that cluster.</p>', 'GetMLModelTransformJob' => '<p>Gets information about a specified model transform job. See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-model-transform.html">Use a trained model to generate new model artifacts</a>.</p> <p>When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getmlmodeltransformjobstatus">neptune-db:GetMLModelTransformJobStatus</a> IAM action in that cluster.</p>', 'GetOpenCypherQueryStatus' => '<p>Retrieves the status of a specified openCypher query.</p> <p>When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getquerystatus">neptune-db:GetQueryStatus</a> IAM action in that cluster.</p> <p>Note that the <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys">neptune-db:QueryLanguage:OpenCypher</a> IAM condition key can be used in the policy document to restrict the use of openCypher queries (see <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available in Neptune IAM data-access policy statements</a>).</p>', 'GetPropertygraphStatistics' => '<p>Gets property graph statistics (Gremlin and openCypher).</p> <p>When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getstatisticsstatus">neptune-db:GetStatisticsStatus</a> IAM action in that cluster.</p>', 'GetPropertygraphStream' => '<p>Gets a stream for a property graph.</p> <p>With the Neptune Streams feature, you can generate a complete sequence of change-log entries that record every change made to your graph data as it happens. <code>GetPropertygraphStream</code> lets you collect these change-log entries for a property graph.</p> <p>The Neptune streams feature needs to be enabled on your Neptune DBcluster. To enable streams, set the <a href="https://docs.aws.amazon.com/neptune/latest/userguide/parameters.html#parameters-db-cluster-parameters-neptune_streams">neptune_streams</a> DB cluster parameter to <code>1</code>.</p> <p>See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/streams.html">Capturing graph changes in real time using Neptune streams</a>.</p> <p>When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getstreamrecords">neptune-db:GetStreamRecords</a> IAM action in that cluster.</p> <p>When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that enables one of the following IAM actions, depending on the query:</p> <p>Note that you can restrict property-graph queries using the following IAM context keys:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys">neptune-db:QueryLanguage:Gremlin</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys">neptune-db:QueryLanguage:OpenCypher</a> </p> </li> </ul> <p>See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available in Neptune IAM data-access policy statements</a>).</p>', 'GetPropertygraphSummary' => '<p>Gets a graph summary for a property graph.</p> <p>When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getgraphsummary">neptune-db:GetGraphSummary</a> IAM action in that cluster.</p>', 'GetRDFGraphSummary' => '<p>Gets a graph summary for an RDF graph.</p> <p>When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getgraphsummary">neptune-db:GetGraphSummary</a> IAM action in that cluster.</p>', 'GetSparqlStatistics' => '<p>Gets RDF statistics (SPARQL).</p>', 'GetSparqlStream' => '<p>Gets a stream for an RDF graph.</p> <p>With the Neptune Streams feature, you can generate a complete sequence of change-log entries that record every change made to your graph data as it happens. <code>GetSparqlStream</code> lets you collect these change-log entries for an RDF graph.</p> <p>The Neptune streams feature needs to be enabled on your Neptune DBcluster. To enable streams, set the <a href="https://docs.aws.amazon.com/neptune/latest/userguide/parameters.html#parameters-db-cluster-parameters-neptune_streams">neptune_streams</a> DB cluster parameter to <code>1</code>.</p> <p>See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/streams.html">Capturing graph changes in real time using Neptune streams</a>.</p> <p>When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getstreamrecords">neptune-db:GetStreamRecords</a> IAM action in that cluster.</p> <p>Note that the <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys">neptune-db:QueryLanguage:Sparql</a> IAM condition key can be used in the policy document to restrict the use of SPARQL queries (see <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available in Neptune IAM data-access policy statements</a>).</p>', 'ListGremlinQueries' => '<p>Lists active Gremlin queries. See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/gremlin-api-status.html">Gremlin query status API</a> for details about the output.</p> <p>When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getquerystatus">neptune-db:GetQueryStatus</a> IAM action in that cluster.</p> <p>Note that the <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys">neptune-db:QueryLanguage:Gremlin</a> IAM condition key can be used in the policy document to restrict the use of Gremlin queries (see <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available in Neptune IAM data-access policy statements</a>).</p>', 'ListLoaderJobs' => '<p>Retrieves a list of the <code>loadIds</code> for all active loader jobs.</p> <p>When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#listloaderjobs">neptune-db:ListLoaderJobs</a> IAM action in that cluster..</p>', 'ListMLDataProcessingJobs' => '<p>Returns a list of Neptune ML data processing jobs. See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-dataprocessing.html#machine-learning-api-dataprocessing-list-jobs">Listing active data-processing jobs using the Neptune ML dataprocessing command</a>.</p> <p>When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#listmldataprocessingjobs">neptune-db:ListMLDataProcessingJobs</a> IAM action in that cluster.</p>', 'ListMLEndpoints' => '<p>Lists existing inference endpoints. See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-endpoints.html">Managing inference endpoints using the endpoints command</a>.</p> <p>When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#listmlendpoints">neptune-db:ListMLEndpoints</a> IAM action in that cluster.</p>', 'ListMLModelTrainingJobs' => '<p>Lists Neptune ML model-training jobs. See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-modeltraining.html">Model training using the <code>modeltraining</code> command</a>.</p> <p>When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#neptune-db:listmlmodeltrainingjobs">neptune-db:neptune-db:ListMLModelTrainingJobs</a> IAM action in that cluster.</p>', 'ListMLModelTransformJobs' => '<p>Returns a list of model transform job IDs. See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-model-transform.html">Use a trained model to generate new model artifacts</a>.</p> <p>When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#listmlmodeltransformjobs">neptune-db:ListMLModelTransformJobs</a> IAM action in that cluster.</p>', 'ListOpenCypherQueries' => '<p>Lists active openCypher queries. See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-opencypher-status.html">Neptune openCypher status endpoint</a> for more information.</p> <p>When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getquerystatus">neptune-db:GetQueryStatus</a> IAM action in that cluster.</p> <p>Note that the <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys">neptune-db:QueryLanguage:OpenCypher</a> IAM condition key can be used in the policy document to restrict the use of openCypher queries (see <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available in Neptune IAM data-access policy statements</a>).</p>', 'ManagePropertygraphStatistics' => '<p>Manages the generation and use of property graph statistics.</p> <p>When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#managestatistics">neptune-db:ManageStatistics</a> IAM action in that cluster.</p>', 'ManageSparqlStatistics' => '<p>Manages the generation and use of RDF graph statistics.</p> <p>When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#managestatistics">neptune-db:ManageStatistics</a> IAM action in that cluster.</p>', 'StartLoaderJob' => '<p>Starts a Neptune bulk loader job to load data from an Amazon S3 bucket into a Neptune DB instance. See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load.html">Using the Amazon Neptune Bulk Loader to Ingest Data</a>.</p> <p>When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#startloaderjob">neptune-db:StartLoaderJob</a> IAM action in that cluster.</p>', 'StartMLDataProcessingJob' => '<p>Creates a new Neptune ML data processing job for processing the graph data exported from Neptune for training. See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-dataprocessing.html">The <code>dataprocessing</code> command</a>.</p> <p>When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#startmlmodeldataprocessingjob">neptune-db:StartMLModelDataProcessingJob</a> IAM action in that cluster.</p>', 'StartMLModelTrainingJob' => '<p>Creates a new Neptune ML model training job. See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-modeltraining.html">Model training using the <code>modeltraining</code> command</a>.</p> <p>When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#startmlmodeltrainingjob">neptune-db:StartMLModelTrainingJob</a> IAM action in that cluster.</p>', 'StartMLModelTransformJob' => '<p>Creates a new model transform job. See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-model-transform.html">Use a trained model to generate new model artifacts</a>.</p> <p>When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#startmlmodeltransformjob">neptune-db:StartMLModelTransformJob</a> IAM action in that cluster.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>Raised in case of an authentication or authorization failure.</p>', 'refs' => [], ], 'Action' => [ 'base' => NULL, 'refs' => [ 'ExecuteFastResetInput$action' => '<p>The fast reset action. One of the following values:</p> <ul> <li> <p> <b> <code>initiateDatabaseReset</code> </b>   –   This action generates a unique token needed to actually perform the fast reset.</p> </li> <li> <p> <b> <code>performDatabaseReset</code> </b>   –   This action uses the token generated by the <code>initiateDatabaseReset</code> action to actually perform the fast reset.</p> <p/> </li> </ul>', ], ], 'BadRequestException' => [ 'base' => '<p>Raised when a request is submitted that cannot be processed.</p>', 'refs' => [], ], 'Blob' => [ 'base' => NULL, 'refs' => [ 'ExecuteOpenCypherExplainQueryOutput$results' => '<p>A text blob containing the openCypher <code>explain</code> results.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'CancelMLDataProcessingJobInput$clean' => '<p>If set to <code>TRUE</code>, this flag specifies that all Neptune ML S3 artifacts should be deleted when the job is stopped. The default is <code>FALSE</code>.</p>', 'CancelMLModelTrainingJobInput$clean' => '<p>If set to <code>TRUE</code>, this flag specifies that all Amazon S3 artifacts should be deleted when the job is stopped. The default is <code>FALSE</code>.</p>', 'CancelMLModelTransformJobInput$clean' => '<p>If this flag is set to <code>TRUE</code>, all Neptune ML S3 artifacts should be deleted when the job is stopped. The default is <code>FALSE</code>.</p>', 'CancelOpenCypherQueryInput$silent' => '<p>If set to <code>TRUE</code>, causes the cancelation of the openCypher query to happen silently.</p>', 'CancelOpenCypherQueryOutput$payload' => '<p>The cancelation payload for the openCypher query.</p>', 'CreateMLEndpointInput$update' => '<p>If set to <code>true</code>, <code>update</code> indicates that this is an update request. The default is <code>false</code>. You must supply either the <code>mlModelTrainingJobId</code> or the <code>mlModelTransformJobId</code>.</p>', 'DeleteMLEndpointInput$clean' => '<p>If this flag is set to <code>TRUE</code>, all Neptune ML S3 artifacts should be deleted when the job is stopped. The default is <code>FALSE</code>.</p>', 'DeleteStatisticsValueMap$active' => '<p>The current status of the statistics.</p>', 'ExecuteGremlinProfileQueryInput$results' => '<p>If this flag is set to <code>TRUE</code>, the query results are gathered and displayed as part of the profile report. If <code>FALSE</code>, only the result count is displayed.</p>', 'ExecuteGremlinProfileQueryInput$indexOps' => '<p>If this flag is set to <code>TRUE</code>, the results include a detailed report of all index operations that took place during query execution and serialization.</p>', 'GetLoaderJobStatusInput$details' => '<p>Flag indicating whether or not to include details beyond the overall status (<code>TRUE</code> or <code>FALSE</code>; the default is <code>FALSE</code>).</p>', 'GetLoaderJobStatusInput$errors' => '<p>Flag indicating whether or not to include a list of errors encountered (<code>TRUE</code> or <code>FALSE</code>; the default is <code>FALSE</code>).</p> <p>The list of errors is paged. The <code>page</code> and <code>errorsPerPage</code> parameters allow you to page through all the errors.</p>', 'ListGremlinQueriesInput$includeWaiting' => '<p>If set to <code>TRUE</code>, the list returned includes waiting queries. The default is <code>FALSE</code>;</p>', 'ListLoaderJobsInput$includeQueuedLoads' => '<p>An optional parameter that can be used to exclude the load IDs of queued load requests when requesting a list of load IDs by setting the parameter to <code>FALSE</code>. The default value is <code>TRUE</code>.</p>', 'ListOpenCypherQueriesInput$includeWaiting' => '<p> When set to <code>TRUE</code> and other parameters are not present, causes status information to be returned for waiting queries as well as for running queries.</p>', 'PropertygraphRecord$isLastOp' => '<p>Only present if this operation is the last one in its transaction. If present, it is set to true. It is useful for ensuring that an entire transaction is consumed.</p>', 'QueryEvalStats$cancelled' => '<p>Set to <code>TRUE</code> if the query was cancelled, or FALSE otherwise.</p>', 'SparqlRecord$isLastOp' => '<p>Only present if this operation is the last one in its transaction. If present, it is set to true. It is useful for ensuring that an entire transaction is consumed.</p>', 'StartLoaderJobInput$failOnError' => '<p> <b> <code>failOnError</code> </b>   –   A flag to toggle a complete stop on an error.</p> <p> <i>Allowed values</i>: <code>"TRUE"</code>, <code>"FALSE"</code>.</p> <p> <i>Default value</i>: <code>"TRUE"</code>.</p> <p>When this parameter is set to <code>"FALSE"</code>, the loader tries to load all the data in the location specified, skipping any entries with errors.</p> <p>When this parameter is set to <code>"TRUE"</code>, the loader stops as soon as it encounters an error. Data loaded up to that point persists.</p>', 'StartLoaderJobInput$updateSingleCardinalityProperties' => '<p> <code>updateSingleCardinalityProperties</code> is an optional parameter that controls how the bulk loader treats a new value for single-cardinality vertex or edge properties. This is not supported for loading openCypher data.</p> <p> <i>Allowed values</i>: <code>"TRUE"</code>, <code>"FALSE"</code>.</p> <p> <i>Default value</i>: <code>"FALSE"</code>.</p> <p>By default, or when <code>updateSingleCardinalityProperties</code> is explicitly set to <code>"FALSE"</code>, the loader treats a new value as an error, because it violates single cardinality.</p> <p>When <code>updateSingleCardinalityProperties</code> is set to <code>"TRUE"</code>, on the other hand, the bulk loader replaces the existing value with the new one. If multiple edge or single-cardinality vertex property values are provided in the source file(s) being loaded, the final value at the end of the bulk load could be any one of those new values. The loader only guarantees that the existing value has been replaced by one of the new ones.</p>', 'StartLoaderJobInput$queueRequest' => '<p>This is an optional flag parameter that indicates whether the load request can be queued up or not. </p> <p>You don\'t have to wait for one load job to complete before issuing the next one, because Neptune can queue up as many as 64 jobs at a time, provided that their <code>queueRequest</code> parameters are all set to <code>"TRUE"</code>. The queue order of the jobs will be first-in-first-out (FIFO).</p> <p>If the <code>queueRequest</code> parameter is omitted or set to <code>"FALSE"</code>, the load request will fail if another load job is already running.</p> <p> <i>Allowed values</i>: <code>"TRUE"</code>, <code>"FALSE"</code>.</p> <p> <i>Default value</i>: <code>"FALSE"</code>.</p>', 'StartLoaderJobInput$userProvidedEdgeIds' => '<p>This parameter is required only when loading openCypher data that contains relationship IDs. It must be included and set to <code>True</code> when openCypher relationship IDs are explicitly provided in the load data (recommended).</p> <p>When <code>userProvidedEdgeIds</code> is absent or set to <code>True</code>, an <code>:ID</code> column must be present in every relationship file in the load.</p> <p>When <code>userProvidedEdgeIds</code> is present and set to <code>False</code>, relationship files in the load <b>must not</b> contain an <code>:ID</code> column. Instead, the Neptune loader automatically generates an ID for each relationship.</p> <p>It\'s useful to provide relationship IDs explicitly so that the loader can resume loading after error in the CSV data have been fixed, without having to reload any relationships that have already been loaded. If relationship IDs have not been explicitly assigned, the loader cannot resume a failed load if any relationship file has had to be corrected, and must instead reload all the relationships.</p>', 'StartMLModelTrainingJobInput$enableManagedSpotTraining' => '<p>Optimizes the cost of training machine-learning models by using Amazon Elastic Compute Cloud spot instances. The default is <code>False</code>.</p>', 'Statistics$autoCompute' => '<p>Indicates whether or not automatic statistics generation is enabled.</p>', 'Statistics$active' => '<p>Indicates whether or not DFE statistics generation is enabled at all.</p>', ], ], 'BulkLoadIdNotFoundException' => [ 'base' => '<p>Raised when a specified bulk-load job ID cannot be found.</p>', 'refs' => [], ], 'CancelGremlinQueryInput' => [ 'base' => NULL, 'refs' => [], ], 'CancelGremlinQueryOutput' => [ 'base' => NULL, 'refs' => [], ], 'CancelLoaderJobInput' => [ 'base' => NULL, 'refs' => [], ], 'CancelLoaderJobOutput' => [ 'base' => NULL, 'refs' => [], ], 'CancelMLDataProcessingJobInput' => [ 'base' => NULL, 'refs' => [], ], 'CancelMLDataProcessingJobOutput' => [ 'base' => NULL, 'refs' => [], ], 'CancelMLModelTrainingJobInput' => [ 'base' => NULL, 'refs' => [], ], 'CancelMLModelTrainingJobOutput' => [ 'base' => NULL, 'refs' => [], ], 'CancelMLModelTransformJobInput' => [ 'base' => NULL, 'refs' => [], ], 'CancelMLModelTransformJobOutput' => [ 'base' => NULL, 'refs' => [], ], 'CancelOpenCypherQueryInput' => [ 'base' => NULL, 'refs' => [], ], 'CancelOpenCypherQueryOutput' => [ 'base' => NULL, 'refs' => [], ], 'CancelledByUserException' => [ 'base' => '<p>Raised when a user cancelled a request.</p>', 'refs' => [], ], 'Classes' => [ 'base' => NULL, 'refs' => [ 'RDFGraphSummary$classes' => '<p>A list of the classes in the graph.</p>', ], ], 'ClientTimeoutException' => [ 'base' => '<p>Raised when a request timed out in the client.</p>', 'refs' => [], ], 'ConcurrentModificationException' => [ 'base' => '<p>Raised when a request attempts to modify data that is concurrently being modified by another process.</p>', 'refs' => [], ], 'ConstraintViolationException' => [ 'base' => '<p>Raised when a value in a request field did not satisfy required constraints.</p>', 'refs' => [], ], 'CreateMLEndpointInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateMLEndpointOutput' => [ 'base' => NULL, 'refs' => [], ], 'CustomModelTrainingParameters' => [ 'base' => '<p>Contains custom model training parameters. See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-custom-models.html">Custom models in Neptune ML</a>.</p>', 'refs' => [ 'StartMLModelTrainingJobInput$customModelTrainingParameters' => '<p>The configuration for custom model training. This is a JSON object.</p>', ], ], 'CustomModelTransformParameters' => [ 'base' => '<p>Contains custom model transform parameters. See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-model-transform.html">Use a trained model to generate new model artifacts</a>.</p>', 'refs' => [ 'StartMLModelTransformJobInput$customModelTransformParameters' => '<p>Configuration information for a model transform using a custom model. The <code>customModelTransformParameters</code> object contains the following fields, which must have values compatible with the saved model parameters from the training job:</p>', ], ], 'DeleteMLEndpointInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMLEndpointOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeletePropertygraphStatisticsOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSparqlStatisticsOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStatisticsValueMap' => [ 'base' => '<p>The payload for DeleteStatistics.</p>', 'refs' => [ 'DeletePropertygraphStatisticsOutput$payload' => '<p>The deletion payload.</p>', 'DeleteSparqlStatisticsOutput$payload' => '<p>The deletion payload.</p>', ], ], 'Document' => [ 'base' => NULL, 'refs' => [ 'DocumentValuedMap$value' => NULL, 'ExecuteGremlinQueryOutput$result' => '<p>The Gremlin query output from the server.</p>', 'ExecuteGremlinQueryOutput$meta' => '<p>Metadata about the Gremlin query.</p>', 'ExecuteOpenCypherQueryOutput$results' => '<p>The openCypherquery results.</p>', 'GetLoaderJobStatusOutput$payload' => '<p>Status information about the load job, in a layout that could look like this:</p>', 'GremlinQueryStatusAttributes$attributes' => '<p>Attributes of the Gremlin query status.</p>', 'PropertygraphData$value' => '<p>This is a JSON object that contains a value field for the value itself, and a datatype field for the JSON data type of that value:</p>', 'QueryEvalStats$subqueries' => '<p>The number of subqueries in this query.</p>', ], ], 'DocumentValuedMap' => [ 'base' => NULL, 'refs' => [ 'GetEngineStatusOutput$features' => '<p>Contains status information about the features enabled on your DB cluster.</p>', ], ], 'EdgeLabels' => [ 'base' => NULL, 'refs' => [ 'PropertygraphSummary$edgeLabels' => '<p>A list of the distinct edge labels in the graph.</p>', ], ], 'EdgeProperties' => [ 'base' => NULL, 'refs' => [ 'EdgeStructure$edgeProperties' => '<p>A list of edge properties present in this specific structure.</p>', ], ], 'EdgeStructure' => [ 'base' => '<p>An edge structure.</p>', 'refs' => [ 'EdgeStructures$member' => NULL, ], ], 'EdgeStructures' => [ 'base' => NULL, 'refs' => [ 'PropertygraphSummary$edgeStructures' => '<p>This field is only present when the requested mode is <code>DETAILED</code>. It contains a list of edge structures.</p>', ], ], 'Encoding' => [ 'base' => NULL, 'refs' => [ 'GetPropertygraphStreamInput$encoding' => '<p>If set to TRUE, Neptune compresses the response using gzip encoding.</p>', 'GetSparqlStreamInput$encoding' => '<p>If set to TRUE, Neptune compresses the response using gzip encoding.</p>', ], ], 'ExecuteFastResetInput' => [ 'base' => NULL, 'refs' => [], ], 'ExecuteFastResetOutput' => [ 'base' => NULL, 'refs' => [], ], 'ExecuteGremlinExplainQueryInput' => [ 'base' => NULL, 'refs' => [], ], 'ExecuteGremlinExplainQueryOutput' => [ 'base' => NULL, 'refs' => [], ], 'ExecuteGremlinProfileQueryInput' => [ 'base' => NULL, 'refs' => [], ], 'ExecuteGremlinProfileQueryOutput' => [ 'base' => NULL, 'refs' => [], ], 'ExecuteGremlinQueryInput' => [ 'base' => NULL, 'refs' => [], ], 'ExecuteGremlinQueryOutput' => [ 'base' => NULL, 'refs' => [], ], 'ExecuteOpenCypherExplainQueryInput' => [ 'base' => NULL, 'refs' => [], ], 'ExecuteOpenCypherExplainQueryOutput' => [ 'base' => NULL, 'refs' => [], ], 'ExecuteOpenCypherQueryInput' => [ 'base' => NULL, 'refs' => [], ], 'ExecuteOpenCypherQueryOutput' => [ 'base' => NULL, 'refs' => [], ], 'ExpiredStreamException' => [ 'base' => '<p>Raised when a request attempts to access an stream that has expired.</p>', 'refs' => [], ], 'FailureByQueryException' => [ 'base' => '<p>Raised when a request fails.</p>', 'refs' => [], ], 'FastResetToken' => [ 'base' => '<p>A structure containing the fast reset token used to initiate a fast reset.</p>', 'refs' => [ 'ExecuteFastResetOutput$payload' => '<p>The <code>payload</code> is only returned by the <code>initiateDatabaseReset</code> action, and contains the unique token to use with the <code>performDatabaseReset</code> action to make the reset occur.</p>', ], ], 'Format' => [ 'base' => NULL, 'refs' => [ 'StartLoaderJobInput$format' => '<p>The format of the data. For more information about data formats for the Neptune <code>Loader</code> command, see <a href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format.html">Load Data Formats</a>.</p> <p class="title"> <b>Allowed values</b> </p> <ul> <li> <p> <b> <code>csv</code> </b> for the <a href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-gremlin.html">Gremlin CSV data format</a>.</p> </li> <li> <p> <b> <code>opencypher</code> </b> for the <a href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-opencypher.html">openCypher CSV data format</a>.</p> </li> <li> <p> <b> <code>ntriples</code> </b> for the <a href="https://www.w3.org/TR/n-triples/">N-Triples RDF data format</a>.</p> </li> <li> <p> <b> <code>nquads</code> </b> for the <a href="https://www.w3.org/TR/n-quads/">N-Quads RDF data format</a>.</p> </li> <li> <p> <b> <code>rdfxml</code> </b> for the <a href="https://www.w3.org/TR/rdf-syntax-grammar/">RDF\\XML RDF data format</a>.</p> </li> <li> <p> <b> <code>turtle</code> </b> for the <a href="https://www.w3.org/TR/turtle/">Turtle RDF data format</a>.</p> </li> </ul>', ], ], 'GetEngineStatusOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetGremlinQueryStatusInput' => [ 'base' => NULL, 'refs' => [], ], 'GetGremlinQueryStatusOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetLoaderJobStatusInput' => [ 'base' => NULL, 'refs' => [], ], 'GetLoaderJobStatusOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetMLDataProcessingJobInput' => [ 'base' => NULL, 'refs' => [], ], 'GetMLDataProcessingJobOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetMLEndpointInput' => [ 'base' => NULL, 'refs' => [], ], 'GetMLEndpointOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetMLModelTrainingJobInput' => [ 'base' => NULL, 'refs' => [], ], 'GetMLModelTrainingJobOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetMLModelTransformJobInput' => [ 'base' => NULL, 'refs' => [], ], 'GetMLModelTransformJobOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetOpenCypherQueryStatusInput' => [ 'base' => NULL, 'refs' => [], ], 'GetOpenCypherQueryStatusOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetPropertygraphStatisticsOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetPropertygraphStreamInput' => [ 'base' => NULL, 'refs' => [], ], 'GetPropertygraphStreamInputLimitLong' => [ 'base' => NULL, 'refs' => [ 'GetPropertygraphStreamInput$limit' => '<p>Specifies the maximum number of records to return. There is also a size limit of 10 MB on the response that can\'t be modified and that takes precedence over the number of records specified in the <code>limit</code> parameter. The response does include a threshold-breaching record if the 10 MB limit was reached.</p> <p>The range for <code>limit</code> is 1 to 100,000, with a default of 10.</p>', ], ], 'GetPropertygraphStreamOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetPropertygraphSummaryInput' => [ 'base' => NULL, 'refs' => [], ], 'GetPropertygraphSummaryOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetRDFGraphSummaryInput' => [ 'base' => NULL, 'refs' => [], ], 'GetRDFGraphSummaryOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetSparqlStatisticsOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetSparqlStreamInput' => [ 'base' => NULL, 'refs' => [], ], 'GetSparqlStreamInputLimitLong' => [ 'base' => NULL, 'refs' => [ 'GetSparqlStreamInput$limit' => '<p>Specifies the maximum number of records to return. There is also a size limit of 10 MB on the response that can\'t be modified and that takes precedence over the number of records specified in the <code>limit</code> parameter. The response does include a threshold-breaching record if the 10 MB limit was reached.</p> <p>The range for <code>limit</code> is 1 to 100,000, with a default of 10.</p>', ], ], 'GetSparqlStreamOutput' => [ 'base' => NULL, 'refs' => [], ], 'GraphSummaryType' => [ 'base' => NULL, 'refs' => [ 'GetPropertygraphSummaryInput$mode' => '<p>Mode can take one of two values: <code>BASIC</code> (the default), and <code>DETAILED</code>.</p>', 'GetRDFGraphSummaryInput$mode' => '<p>Mode can take one of two values: <code>BASIC</code> (the default), and <code>DETAILED</code>.</p>', ], ], 'GremlinQueries' => [ 'base' => NULL, 'refs' => [ 'ListGremlinQueriesOutput$queries' => '<p>A list of the current queries.</p>', ], ], 'GremlinQueryStatus' => [ 'base' => '<p>Captures the status of a Gremlin query (see the <a href="https://docs.aws.amazon.com/neptune/latest/userguide/gremlin-api-status.html">Gremlin query status API</a> page).</p>', 'refs' => [ 'GremlinQueries$member' => NULL, 'OpenCypherQueries$member' => NULL, ], ], 'GremlinQueryStatusAttributes' => [ 'base' => '<p>Contains status components of a Gremlin query.</p>', 'refs' => [ 'ExecuteGremlinQueryOutput$status' => '<p>The status of the Gremlin query.</p>', ], ], 'IllegalArgumentException' => [ 'base' => '<p>Raised when an argument in a request is not supported.</p>', 'refs' => [], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'CreateMLEndpointInput$instanceCount' => '<p>The minimum number of Amazon EC2 instances to deploy to an endpoint for prediction. The default is 1</p>', 'DeletePropertygraphStatisticsOutput$statusCode' => '<p>The HTTP response code: 200 if the delete was successful, or 204 if there were no statistics to delete.</p>', 'DeleteSparqlStatisticsOutput$statusCode' => '<p>The HTTP response code: 200 if the delete was successful, or 204 if there were no statistics to delete.</p>', 'ExecuteGremlinProfileQueryInput$chop' => '<p>If non-zero, causes the results string to be truncated at that number of characters. If set to zero, the string contains all the results.</p>', 'GetEngineStatusOutput$rollingBackTrxCount' => '<p>If there are transactions being rolled back, this field is set to the number of such transactions. If there are none, the field doesn\'t appear at all.</p>', 'GetPropertygraphStreamOutput$totalRecords' => '<p>The total number of records in the response.</p>', 'GetPropertygraphSummaryOutput$statusCode' => '<p>The HTTP return code of the request. If the request succeeded, the code is 200.</p>', 'GetRDFGraphSummaryOutput$statusCode' => '<p>The HTTP return code of the request. If the request succeeded, the code is 200.</p>', 'GetSparqlStreamOutput$totalRecords' => '<p>The total number of records in the response.</p>', 'GremlinQueryStatusAttributes$code' => '<p>The HTTP response code returned fro the Gremlin query request..</p>', 'ListGremlinQueriesOutput$acceptedQueryCount' => '<p>The number of queries that have been accepted but not yet completed, including queries in the queue.</p>', 'ListGremlinQueriesOutput$runningQueryCount' => '<p>The number of Gremlin queries currently running.</p>', 'ListOpenCypherQueriesOutput$acceptedQueryCount' => '<p>The number of queries that have been accepted but not yet completed, including queries in the queue.</p>', 'ListOpenCypherQueriesOutput$runningQueryCount' => '<p>The number of currently running openCypher queries.</p>', 'QueryEvalStats$waited' => '<p>Indicates how long the query waited, in milliseconds.</p>', 'QueryEvalStats$elapsed' => '<p>The number of milliseconds the query has been running so far.</p>', 'StartMLDataProcessingJobInput$processingInstanceVolumeSizeInGB' => '<p>The disk volume size of the processing instance. Both input data and processed data are stored on disk, so the volume size must be large enough to hold both data sets. The default is 0. If not specified or 0, Neptune ML chooses the volume size automatically based on the data size.</p>', 'StartMLDataProcessingJobInput$processingTimeOutInSeconds' => '<p>Timeout in seconds for the data processing job. The default is 86,400 (1 day).</p>', 'StartMLModelTrainingJobInput$trainingInstanceVolumeSizeInGB' => '<p>The disk volume size of the training instance. Both input data and the output model are stored on disk, so the volume size must be large enough to hold both data sets. The default is 0. If not specified or 0, Neptune ML selects a disk volume size based on the recommendation generated in the data processing step.</p>', 'StartMLModelTrainingJobInput$trainingTimeOutInSeconds' => '<p>Timeout in seconds for the training job. The default is 86,400 (1 day).</p>', 'StartMLModelTrainingJobInput$maxHPONumberOfTrainingJobs' => '<p>Maximum total number of training jobs to start for the hyperparameter tuning job. The default is 2. Neptune ML automatically tunes the hyperparameters of the machine learning model. To obtain a model that performs well, use at least 10 jobs (in other words, set <code>maxHPONumberOfTrainingJobs</code> to 10). In general, the more tuning runs, the better the results.</p>', 'StartMLModelTrainingJobInput$maxHPOParallelTrainingJobs' => '<p>Maximum number of parallel training jobs to start for the hyperparameter tuning job. The default is 2. The number of parallel jobs you can run is limited by the available resources on your training instance.</p>', 'StartMLModelTransformJobInput$baseProcessingInstanceVolumeSizeInGB' => '<p>The disk volume size of the training instance in gigabytes. The default is 0. Both input data and the output model are stored on disk, so the volume size must be large enough to hold both data sets. If not specified or 0, Neptune ML selects a disk volume size based on the recommendation generated in the data processing step.</p>', 'StatisticsSummary$signatureCount' => '<p>The total number of signatures across all characteristic sets.</p>', 'StatisticsSummary$instanceCount' => '<p>The total number of characteristic-set instances.</p>', 'StatisticsSummary$predicateCount' => '<p>The total number of unique predicates.</p>', ], ], 'InternalFailureException' => [ 'base' => '<p>Raised when the processing of the request failed unexpectedly.</p>', 'refs' => [], ], 'InvalidArgumentException' => [ 'base' => '<p>Raised when an argument in a request has an invalid value.</p>', 'refs' => [], ], 'InvalidNumericDataException' => [ 'base' => '<p>Raised when invalid numerical data is encountered when servicing a request.</p>', 'refs' => [], ], 'InvalidParameterException' => [ 'base' => '<p>Raised when a parameter value is not valid.</p>', 'refs' => [], ], 'IteratorType' => [ 'base' => NULL, 'refs' => [ 'GetPropertygraphStreamInput$iteratorType' => '<p>Can be one of:</p> <ul> <li> <p> <code>AT_SEQUENCE_NUMBER</code>   –   Indicates that reading should start from the event sequence number specified jointly by the <code>commitNum</code> and <code>opNum</code> parameters.</p> </li> <li> <p> <code>AFTER_SEQUENCE_NUMBER</code>   –   Indicates that reading should start right after the event sequence number specified jointly by the <code>commitNum</code> and <code>opNum</code> parameters.</p> </li> <li> <p> <code>TRIM_HORIZON</code>   –   Indicates that reading should start at the last untrimmed record in the system, which is the oldest unexpired (not yet deleted) record in the change-log stream.</p> </li> <li> <p> <code>LATEST</code>   –   Indicates that reading should start at the most recent record in the system, which is the latest unexpired (not yet deleted) record in the change-log stream.</p> </li> </ul>', 'GetSparqlStreamInput$iteratorType' => '<p>Can be one of:</p> <ul> <li> <p> <code>AT_SEQUENCE_NUMBER</code>   –   Indicates that reading should start from the event sequence number specified jointly by the <code>commitNum</code> and <code>opNum</code> parameters.</p> </li> <li> <p> <code>AFTER_SEQUENCE_NUMBER</code>   –   Indicates that reading should start right after the event sequence number specified jointly by the <code>commitNum</code> and <code>opNum</code> parameters.</p> </li> <li> <p> <code>TRIM_HORIZON</code>   –   Indicates that reading should start at the last untrimmed record in the system, which is the oldest unexpired (not yet deleted) record in the change-log stream.</p> </li> <li> <p> <code>LATEST</code>   –   Indicates that reading should start at the most recent record in the system, which is the latest unexpired (not yet deleted) record in the change-log stream.</p> </li> </ul>', ], ], 'ListGremlinQueriesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListGremlinQueriesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListLoaderJobsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListLoaderJobsInputLimitInteger' => [ 'base' => NULL, 'refs' => [ 'ListLoaderJobsInput$limit' => '<p>The number of load IDs to list. Must be a positive integer greater than zero and not more than <code>100</code> (which is the default).</p>', ], ], 'ListLoaderJobsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListMLDataProcessingJobsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListMLDataProcessingJobsInputMaxItemsInteger' => [ 'base' => NULL, 'refs' => [ 'ListMLDataProcessingJobsInput$maxItems' => '<p>The maximum number of items to return (from 1 to 1024; the default is 10).</p>', ], ], 'ListMLDataProcessingJobsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListMLEndpointsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListMLEndpointsInputMaxItemsInteger' => [ 'base' => NULL, 'refs' => [ 'ListMLEndpointsInput$maxItems' => '<p>The maximum number of items to return (from 1 to 1024; the default is 10.</p>', ], ], 'ListMLEndpointsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListMLModelTrainingJobsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListMLModelTrainingJobsInputMaxItemsInteger' => [ 'base' => NULL, 'refs' => [ 'ListMLModelTrainingJobsInput$maxItems' => '<p>The maximum number of items to return (from 1 to 1024; the default is 10).</p>', ], ], 'ListMLModelTrainingJobsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListMLModelTransformJobsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListMLModelTransformJobsInputMaxItemsInteger' => [ 'base' => NULL, 'refs' => [ 'ListMLModelTransformJobsInput$maxItems' => '<p>The maximum number of items to return (from 1 to 1024; the default is 10).</p>', ], ], 'ListMLModelTransformJobsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListOpenCypherQueriesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListOpenCypherQueriesOutput' => [ 'base' => NULL, 'refs' => [], ], 'LoadUrlAccessDeniedException' => [ 'base' => '<p>Raised when access is denied to a specified load URL.</p>', 'refs' => [], ], 'LoaderIdResult' => [ 'base' => '<p>Contains a list of load IDs.</p>', 'refs' => [ 'ListLoaderJobsOutput$payload' => '<p>The requested list of job IDs.</p>', ], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'CreateMLEndpointOutput$creationTimeInMillis' => '<p>The endpoint creation time, in milliseconds.</p>', 'EdgeStructure$count' => '<p>The number of edges that have this specific structure.</p>', 'GetPropertygraphStreamInput$commitNum' => '<p>The commit number of the starting record to read from the change-log stream. This parameter is required when <code>iteratorType</code> is<code>AT_SEQUENCE_NUMBER</code> or <code>AFTER_SEQUENCE_NUMBER</code>, and ignored when <code>iteratorType</code> is <code>TRIM_HORIZON</code> or <code>LATEST</code>.</p>', 'GetPropertygraphStreamInput$opNum' => '<p>The operation sequence number within the specified commit to start reading from in the change-log stream data. The default is <code>1</code>.</p>', 'GetPropertygraphStreamOutput$lastTrxTimestampInMillis' => '<p>The time at which the commit for the transaction was requested, in milliseconds from the Unix epoch.</p>', 'GetSparqlStreamInput$commitNum' => '<p>The commit number of the starting record to read from the change-log stream. This parameter is required when <code>iteratorType</code> is<code>AT_SEQUENCE_NUMBER</code> or <code>AFTER_SEQUENCE_NUMBER</code>, and ignored when <code>iteratorType</code> is <code>TRIM_HORIZON</code> or <code>LATEST</code>.</p>', 'GetSparqlStreamInput$opNum' => '<p>The operation sequence number within the specified commit to start reading from in the change-log stream data. The default is <code>1</code>.</p>', 'GetSparqlStreamOutput$lastTrxTimestampInMillis' => '<p>The time at which the commit for the transaction was requested, in milliseconds from the Unix epoch.</p>', 'LongValuedMap$value' => NULL, 'NodeStructure$count' => '<p>Number of nodes that have this specific structure.</p>', 'PropertygraphRecord$commitTimestampInMillis' => '<p>The time at which the commit for the transaction was requested, in milliseconds from the Unix epoch.</p>', 'PropertygraphSummary$numNodes' => '<p>The number of nodes in the graph.</p>', 'PropertygraphSummary$numEdges' => '<p>The number of edges in the graph.</p>', 'PropertygraphSummary$numNodeLabels' => '<p>The number of distinct node labels in the graph.</p>', 'PropertygraphSummary$numEdgeLabels' => '<p>The number of distinct edge labels in the graph.</p>', 'PropertygraphSummary$numNodeProperties' => '<p>A list of the distinct node properties in the graph, along with the count of nodes where each property is used.</p>', 'PropertygraphSummary$numEdgeProperties' => '<p>The number of distinct edge properties in the graph.</p>', 'PropertygraphSummary$totalNodePropertyValues' => '<p>The total number of usages of all node properties.</p>', 'PropertygraphSummary$totalEdgePropertyValues' => '<p>The total number of usages of all edge properties.</p>', 'RDFGraphSummary$numDistinctSubjects' => '<p>The number of distinct subjects in the graph.</p>', 'RDFGraphSummary$numDistinctPredicates' => '<p>The number of distinct predicates in the graph.</p>', 'RDFGraphSummary$numQuads' => '<p>The number of quads in the graph.</p>', 'RDFGraphSummary$numClasses' => '<p>The number of classes in the graph.</p>', 'SparqlRecord$commitTimestampInMillis' => '<p>The time at which the commit for the transaction was requested, in milliseconds from the Unix epoch.</p>', 'StartMLDataProcessingJobOutput$creationTimeInMillis' => '<p>The time it took to create the new processing job, in milliseconds.</p>', 'StartMLModelTrainingJobOutput$creationTimeInMillis' => '<p>The model training job creation time, in milliseconds.</p>', 'StartMLModelTransformJobOutput$creationTimeInMillis' => '<p>The creation time of the model transform job, in milliseconds.</p>', 'SubjectStructure$count' => '<p>Number of occurrences of this specific structure.</p>', ], ], 'LongValuedMap' => [ 'base' => NULL, 'refs' => [ 'LongValuedMapList$member' => NULL, ], ], 'LongValuedMapList' => [ 'base' => NULL, 'refs' => [ 'PropertygraphSummary$nodeProperties' => '<p>The number of distinct node properties in the graph.</p>', 'PropertygraphSummary$edgeProperties' => '<p>A list of the distinct edge properties in the graph, along with the count of edges where each property is used.</p>', 'RDFGraphSummary$predicates' => '<p>"A list of predicates in the graph, along with the predicate counts.</p>', ], ], 'MLResourceNotFoundException' => [ 'base' => '<p>Raised when a specified machine-learning resource could not be found.</p>', 'refs' => [], ], 'MalformedQueryException' => [ 'base' => '<p>Raised when a query is submitted that is syntactically incorrect or does not pass additional validation.</p>', 'refs' => [], ], 'ManagePropertygraphStatisticsInput' => [ 'base' => NULL, 'refs' => [], ], 'ManagePropertygraphStatisticsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ManageSparqlStatisticsInput' => [ 'base' => NULL, 'refs' => [], ], 'ManageSparqlStatisticsOutput' => [ 'base' => NULL, 'refs' => [], ], 'MemoryLimitExceededException' => [ 'base' => '<p>Raised when a request fails because of insufficient memory resources. The request can be retried.</p>', 'refs' => [], ], 'MethodNotAllowedException' => [ 'base' => '<p>Raised when the HTTP method used by a request is not supported by the endpoint being used.</p>', 'refs' => [], ], 'MissingParameterException' => [ 'base' => '<p>Raised when a required parameter is missing.</p>', 'refs' => [], ], 'MlConfigDefinition' => [ 'base' => '<p>Contains a Neptune ML configuration.</p>', 'refs' => [ 'GetMLEndpointOutput$endpointConfig' => '<p>The endpoint configuration</p>', 'MlModels$member' => NULL, 'Models$member' => NULL, ], ], 'MlModels' => [ 'base' => NULL, 'refs' => [ 'GetMLModelTrainingJobOutput$mlModels' => '<p>A list of the configurations of the ML models being used.</p>', ], ], 'MlResourceDefinition' => [ 'base' => '<p>Defines a Neptune ML resource.</p>', 'refs' => [ 'GetMLDataProcessingJobOutput$processingJob' => '<p>Definition of the data processing job.</p>', 'GetMLEndpointOutput$endpoint' => '<p>The endpoint definition.</p>', 'GetMLModelTrainingJobOutput$processingJob' => '<p>The data processing job.</p>', 'GetMLModelTrainingJobOutput$hpoJob' => '<p>The HPO job.</p>', 'GetMLModelTrainingJobOutput$modelTransformJob' => '<p>The model transform job.</p>', 'GetMLModelTransformJobOutput$baseProcessingJob' => '<p>The base data processing job.</p>', 'GetMLModelTransformJobOutput$remoteModelTransformJob' => '<p>The remote model transform job.</p>', ], ], 'Mode' => [ 'base' => NULL, 'refs' => [ 'StartLoaderJobInput$mode' => '<p>The load job mode.</p> <p> <i>Allowed values</i>: <code>RESUME</code>, <code>NEW</code>, <code>AUTO</code>.</p> <p> <i>Default value</i>: <code>AUTO</code>.</p> <p class="title"> <b/> </p> <ul> <li> <p> <code>RESUME</code>   –   In RESUME mode, the loader looks for a previous load from this source, and if it finds one, resumes that load job. If no previous load job is found, the loader stops.</p> <p>The loader avoids reloading files that were successfully loaded in a previous job. It only tries to process failed files. If you dropped previously loaded data from your Neptune cluster, that data is not reloaded in this mode. If a previous load job loaded all files from the same source successfully, nothing is reloaded, and the loader returns success.</p> </li> <li> <p> <code>NEW</code>   –   In NEW mode, the creates a new load request regardless of any previous loads. You can use this mode to reload all the data from a source after dropping previously loaded data from your Neptune cluster, or to load new data available at the same source.</p> </li> <li> <p> <code>AUTO</code>   –   In AUTO mode, the loader looks for a previous load job from the same source, and if it finds one, resumes that job, just as in <code>RESUME</code> mode.</p> <p>If the loader doesn\'t find a previous load job from the same source, it loads all data from the source, just as in <code>NEW</code> mode.</p> </li> </ul>', ], ], 'Models' => [ 'base' => NULL, 'refs' => [ 'GetMLModelTransformJobOutput$models' => '<p>A list of the configuration information for the models being used.</p>', ], ], 'NodeLabels' => [ 'base' => NULL, 'refs' => [ 'PropertygraphSummary$nodeLabels' => '<p>A list of the distinct node labels in the graph.</p>', ], ], 'NodeProperties' => [ 'base' => NULL, 'refs' => [ 'NodeStructure$nodeProperties' => '<p>A list of the node properties present in this specific structure.</p>', ], ], 'NodeStructure' => [ 'base' => '<p>A node structure.</p>', 'refs' => [ 'NodeStructures$member' => NULL, ], ], 'NodeStructures' => [ 'base' => NULL, 'refs' => [ 'PropertygraphSummary$nodeStructures' => '<p>This field is only present when the requested mode is <code>DETAILED</code>. It contains a list of node structures.</p>', ], ], 'OpenCypherExplainMode' => [ 'base' => NULL, 'refs' => [ 'ExecuteOpenCypherExplainQueryInput$explainMode' => '<p>The openCypher <code>explain</code> mode. Can be one of: <code>static</code>, <code>dynamic</code>, or <code>details</code>.</p>', ], ], 'OpenCypherQueries' => [ 'base' => NULL, 'refs' => [ 'ListOpenCypherQueriesOutput$queries' => '<p>A list of current openCypher queries.</p>', ], ], 'OutgoingEdgeLabels' => [ 'base' => NULL, 'refs' => [ 'NodeStructure$distinctOutgoingEdgeLabels' => '<p>A list of distinct outgoing edge labels present in this specific structure.</p>', ], ], 'Parallelism' => [ 'base' => NULL, 'refs' => [ 'StartLoaderJobInput$parallelism' => '<p>The optional <code>parallelism</code> parameter can be set to reduce the number of threads used by the bulk load process.</p> <p> <i>Allowed values</i>:</p> <ul> <li> <p> <code>LOW</code> –   The number of threads used is the number of available vCPUs divided by 8.</p> </li> <li> <p> <code>MEDIUM</code> –   The number of threads used is the number of available vCPUs divided by 2.</p> </li> <li> <p> <code>HIGH</code> –   The number of threads used is the same as the number of available vCPUs.</p> </li> <li> <p> <code>OVERSUBSCRIBE</code> –   The number of threads used is the number of available vCPUs multiplied by 2. If this value is used, the bulk loader takes up all available resources.</p> <p>This does not mean, however, that the <code>OVERSUBSCRIBE</code> setting results in 100% CPU utilization. Because the load operation is I/O bound, the highest CPU utilization to expect is in the 60% to 70% range.</p> </li> </ul> <p> <i>Default value</i>: <code>HIGH</code> </p> <p>The <code>parallelism</code> setting can sometimes result in a deadlock between threads when loading openCypher data. When this happens, Neptune returns the <code>LOAD_DATA_DEADLOCK</code> error. You can generally fix the issue by setting <code>parallelism</code> to a lower setting and retrying the load command.</p>', ], ], 'ParsingException' => [ 'base' => '<p>Raised when a parsing issue is encountered.</p>', 'refs' => [], ], 'PositiveInteger' => [ 'base' => NULL, 'refs' => [ 'GetLoaderJobStatusInput$page' => '<p>The error page number (a positive integer; the default is <code>1</code>). Only valid when the <code>errors</code> parameter is set to <code>TRUE</code>.</p>', 'GetLoaderJobStatusInput$errorsPerPage' => '<p>The number of errors returned in each page (a positive integer; the default is <code>10</code>). Only valid when the <code>errors</code> parameter set to <code>TRUE</code>.</p>', ], ], 'PreconditionsFailedException' => [ 'base' => '<p>Raised when a precondition for processing a request is not satisfied.</p>', 'refs' => [], ], 'Predicates' => [ 'base' => NULL, 'refs' => [ 'SubjectStructure$predicates' => '<p>A list of predicates present in this specific structure.</p>', ], ], 'PropertygraphData' => [ 'base' => '<p>A Gremlin or openCypher change record.</p>', 'refs' => [ 'PropertygraphRecord$data' => '<p>The serialized Gremlin or openCypher change record.</p>', ], ], 'PropertygraphRecord' => [ 'base' => '<p>Structure of a property graph record.</p>', 'refs' => [ 'PropertygraphRecordsList$member' => NULL, ], ], 'PropertygraphRecordsList' => [ 'base' => NULL, 'refs' => [ 'GetPropertygraphStreamOutput$records' => '<p>An array of serialized change-log stream records included in the response.</p>', ], ], 'PropertygraphSummary' => [ 'base' => '<p>The graph summary API returns a read-only list of node and edge labels and property keys, along with counts of nodes, edges, and properties. See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/neptune-graph-summary.html#neptune-graph-summary-pg-response">Graph summary response for a property graph (PG)</a>.</p>', 'refs' => [ 'PropertygraphSummaryValueMap$graphSummary' => '<p>The graph summary.</p>', ], ], 'PropertygraphSummaryValueMap' => [ 'base' => '<p>Payload for the property graph summary response.</p>', 'refs' => [ 'GetPropertygraphSummaryOutput$payload' => '<p>Payload containing the property graph summary response.</p>', ], ], 'QueryEvalStats' => [ 'base' => '<p>Structure to capture query statistics such as how many queries are running, accepted or waiting and their details.</p>', 'refs' => [ 'GetGremlinQueryStatusOutput$queryEvalStats' => '<p>The evaluation status of the Gremlin query.</p>', 'GetOpenCypherQueryStatusOutput$queryEvalStats' => '<p>The openCypher query evaluation status.</p>', 'GremlinQueryStatus$queryEvalStats' => '<p>The query statistics of the Gremlin query.</p>', ], ], 'QueryLanguageVersion' => [ 'base' => '<p>Structure for expressing the query language version.</p>', 'refs' => [ 'GetEngineStatusOutput$gremlin' => '<p>Contains information about the Gremlin query language available on your cluster. Specifically, it contains a version field that specifies the current TinkerPop version being used by the engine.</p>', 'GetEngineStatusOutput$sparql' => '<p>Contains information about the SPARQL query language available on your cluster. Specifically, it contains a version field that specifies the current SPARQL version being used by the engine.</p>', 'GetEngineStatusOutput$opencypher' => '<p>Contains information about the openCypher query language available on your cluster. Specifically, it contains a version field that specifies the current operCypher version being used by the engine.</p>', ], ], 'QueryLimitExceededException' => [ 'base' => '<p>Raised when the number of active queries exceeds what the server can process. The query in question can be retried when the system is less busy.</p>', 'refs' => [], ], 'QueryLimitException' => [ 'base' => '<p>Raised when the size of a query exceeds the system limit.</p>', 'refs' => [], ], 'QueryTooLargeException' => [ 'base' => '<p>Raised when the body of a query is too large.</p>', 'refs' => [], ], 'RDFGraphSummary' => [ 'base' => '<p>The RDF graph summary API returns a read-only list of classes and predicate keys, along with counts of quads, subjects, and predicates.</p>', 'refs' => [ 'RDFGraphSummaryValueMap$graphSummary' => '<p>The graph summary of an RDF graph. See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/neptune-graph-summary.html#neptune-graph-summary-rdf-response">Graph summary response for an RDF graph</a>.</p>', ], ], 'RDFGraphSummaryValueMap' => [ 'base' => '<p>Payload for an RDF graph summary response.</p>', 'refs' => [ 'GetRDFGraphSummaryOutput$payload' => '<p>Payload for an RDF graph summary response</p>', ], ], 'ReadOnlyViolationException' => [ 'base' => '<p>Raised when a request attempts to write to a read-only resource.</p>', 'refs' => [], ], 'RefreshStatisticsIdMap' => [ 'base' => '<p>Statistics for <code>REFRESH</code> mode.</p>', 'refs' => [ 'ManagePropertygraphStatisticsOutput$payload' => '<p>This is only returned for refresh mode.</p>', 'ManageSparqlStatisticsOutput$payload' => '<p>This is only returned for refresh mode.</p>', ], ], 'ReportAsText' => [ 'base' => NULL, 'refs' => [ 'ExecuteGremlinExplainQueryOutput$output' => '<p>A text blob containing the Gremlin explain result, as described in <a href="https://docs.aws.amazon.com/neptune/latest/userguide/gremlin-traversal-tuning.html">Tuning Gremlin queries</a>.</p>', 'ExecuteGremlinProfileQueryOutput$output' => '<p>A text blob containing the Gremlin Profile result. See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/gremlin-profile-api.html">Gremlin profile API in Neptune</a> for details.</p>', ], ], 'S3BucketRegion' => [ 'base' => NULL, 'refs' => [ 'StartLoaderJobInput$s3BucketRegion' => '<p>The Amazon region of the S3 bucket. This must match the Amazon Region of the DB cluster.</p>', ], ], 'S3Exception' => [ 'base' => '<p>Raised when there is a problem accessing Amazon S3.</p>', 'refs' => [], ], 'ServerShutdownException' => [ 'base' => '<p>Raised when the server shuts down while processing a request.</p>', 'refs' => [], ], 'SparqlData' => [ 'base' => '<p>Neptune logs are converted to SPARQL quads in the graph using the Resource Description Framework (RDF) <a href="https://www.w3.org/TR/n-quads/">N-QUADS</a> language defined in the W3C RDF 1.1 N-Quads specification</p>', 'refs' => [ 'SparqlRecord$data' => '<p>The serialized SPARQL change record. The serialization formats of each record are described in more detail in <a href="https://docs.aws.amazon.com/neptune/latest/userguide/streams-change-formats.html">Serialization Formats in Neptune Streams</a>.</p>', ], ], 'SparqlRecord' => [ 'base' => '<p>A serialized SPARQL stream record capturing a change-log entry for the RDF graph.</p>', 'refs' => [ 'SparqlRecordsList$member' => NULL, ], ], 'SparqlRecordsList' => [ 'base' => NULL, 'refs' => [ 'GetSparqlStreamOutput$records' => '<p>An array of serialized change-log stream records included in the response.</p>', ], ], 'StartLoaderJobInput' => [ 'base' => NULL, 'refs' => [], ], 'StartLoaderJobOutput' => [ 'base' => NULL, 'refs' => [], ], 'StartMLDataProcessingJobInput' => [ 'base' => NULL, 'refs' => [], ], 'StartMLDataProcessingJobOutput' => [ 'base' => NULL, 'refs' => [], ], 'StartMLModelTrainingJobInput' => [ 'base' => NULL, 'refs' => [], ], 'StartMLModelTrainingJobOutput' => [ 'base' => NULL, 'refs' => [], ], 'StartMLModelTransformJobInput' => [ 'base' => NULL, 'refs' => [], ], 'StartMLModelTransformJobOutput' => [ 'base' => NULL, 'refs' => [], ], 'Statistics' => [ 'base' => '<p>Contains statistics information. The DFE engine uses information about the data in your Neptune graph to make effective trade-offs when planning query execution. This information takes the form of statistics that include so-called characteristic sets and predicate statistics that can guide query planning. See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/neptune-dfe-statistics.html">Managing statistics for the Neptune DFE to use</a>.</p>', 'refs' => [ 'GetPropertygraphStatisticsOutput$payload' => '<p>Statistics for property-graph data.</p>', 'GetSparqlStatisticsOutput$payload' => '<p>Statistics for RDF data.</p>', ], ], 'StatisticsAutoGenerationMode' => [ 'base' => NULL, 'refs' => [ 'ManagePropertygraphStatisticsInput$mode' => '<p>The statistics generation mode. One of: <code>DISABLE_AUTOCOMPUTE</code>, <code>ENABLE_AUTOCOMPUTE</code>, or <code>REFRESH</code>, the last of which manually triggers DFE statistics generation.</p>', 'ManageSparqlStatisticsInput$mode' => '<p>The statistics generation mode. One of: <code>DISABLE_AUTOCOMPUTE</code>, <code>ENABLE_AUTOCOMPUTE</code>, or <code>REFRESH</code>, the last of which manually triggers DFE statistics generation.</p>', ], ], 'StatisticsNotAvailableException' => [ 'base' => '<p>Raised when statistics needed to satisfy a request are not available.</p>', 'refs' => [], ], 'StatisticsSummary' => [ 'base' => '<p>Information about the characteristic sets generated in the statistics.</p>', 'refs' => [ 'Statistics$signatureInfo' => '<p>A StatisticsSummary structure that contains:</p> <ul> <li> <p> <code>signatureCount</code> - The total number of signatures across all characteristic sets.</p> </li> <li> <p> <code>instanceCount</code> - The total number of characteristic-set instances.</p> </li> <li> <p> <code>predicateCount</code> - The total number of unique predicates.</p> </li> </ul>', ], ], 'StreamRecordsNotFoundException' => [ 'base' => '<p>Raised when stream records requested by a query cannot be found.</p>', 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$detailedMessage' => '<p>A detailed message describing the problem.</p>', 'AccessDeniedException$requestId' => '<p>The ID of the request in question.</p>', 'AccessDeniedException$code' => '<p>The HTTP status code returned with the exception.</p>', 'BadRequestException$detailedMessage' => '<p>A detailed message describing the problem.</p>', 'BadRequestException$requestId' => '<p>The ID of the bad request.</p>', 'BadRequestException$code' => '<p>The HTTP status code returned with the exception.</p>', 'BulkLoadIdNotFoundException$detailedMessage' => '<p>A detailed message describing the problem.</p>', 'BulkLoadIdNotFoundException$requestId' => '<p>The bulk-load job ID that could not be found.</p>', 'BulkLoadIdNotFoundException$code' => '<p>The HTTP status code returned with the exception.</p>', 'CancelGremlinQueryInput$queryId' => '<p>The unique identifier that identifies the query to be canceled.</p>', 'CancelGremlinQueryOutput$status' => '<p>The status of the cancelation</p>', 'CancelLoaderJobInput$loadId' => '<p>The ID of the load job to be deleted.</p>', 'CancelLoaderJobOutput$status' => '<p>The cancellation status.</p>', 'CancelMLDataProcessingJobInput$id' => '<p>The unique identifier of the data-processing job.</p>', 'CancelMLDataProcessingJobInput$neptuneIamRoleArn' => '<p>The ARN of an IAM role that provides Neptune access to SageMaker and Amazon S3 resources. This must be listed in your DB cluster parameter group or an error will occur.</p>', 'CancelMLDataProcessingJobOutput$status' => '<p>The status of the cancellation request.</p>', 'CancelMLModelTrainingJobInput$id' => '<p>The unique identifier of the model-training job to be canceled.</p>', 'CancelMLModelTrainingJobInput$neptuneIamRoleArn' => '<p>The ARN of an IAM role that provides Neptune access to SageMaker and Amazon S3 resources. This must be listed in your DB cluster parameter group or an error will occur.</p>', 'CancelMLModelTrainingJobOutput$status' => '<p>The status of the cancellation.</p>', 'CancelMLModelTransformJobInput$id' => '<p>The unique ID of the model transform job to be canceled.</p>', 'CancelMLModelTransformJobInput$neptuneIamRoleArn' => '<p>The ARN of an IAM role that provides Neptune access to SageMaker and Amazon S3 resources. This must be listed in your DB cluster parameter group or an error will occur.</p>', 'CancelMLModelTransformJobOutput$status' => '<p>the status of the cancelation.</p>', 'CancelOpenCypherQueryInput$queryId' => '<p>The unique ID of the openCypher query to cancel.</p>', 'CancelOpenCypherQueryOutput$status' => '<p>The cancellation status of the openCypher query.</p>', 'CancelledByUserException$detailedMessage' => '<p>A detailed message describing the problem.</p>', 'CancelledByUserException$requestId' => '<p>The ID of the request in question.</p>', 'CancelledByUserException$code' => '<p>The HTTP status code returned with the exception.</p>', 'Classes$member' => NULL, 'ClientTimeoutException$detailedMessage' => '<p>A detailed message describing the problem.</p>', 'ClientTimeoutException$requestId' => '<p>The ID of the request in question.</p>', 'ClientTimeoutException$code' => '<p>The HTTP status code returned with the exception.</p>', 'ConcurrentModificationException$detailedMessage' => '<p>A detailed message describing the problem.</p>', 'ConcurrentModificationException$requestId' => '<p>The ID of the request in question.</p>', 'ConcurrentModificationException$code' => '<p>The HTTP status code returned with the exception.</p>', 'ConstraintViolationException$detailedMessage' => '<p>A detailed message describing the problem.</p>', 'ConstraintViolationException$requestId' => '<p>The ID of the request in question.</p>', 'ConstraintViolationException$code' => '<p>The HTTP status code returned with the exception.</p>', 'CreateMLEndpointInput$id' => '<p>A unique identifier for the new inference endpoint. The default is an autogenerated timestamped name.</p>', 'CreateMLEndpointInput$mlModelTrainingJobId' => '<p>The job Id of the completed model-training job that has created the model that the inference endpoint will point to. You must supply either the <code>mlModelTrainingJobId</code> or the <code>mlModelTransformJobId</code>.</p>', 'CreateMLEndpointInput$mlModelTransformJobId' => '<p>The job Id of the completed model-transform job. You must supply either the <code>mlModelTrainingJobId</code> or the <code>mlModelTransformJobId</code>.</p>', 'CreateMLEndpointInput$neptuneIamRoleArn' => '<p>The ARN of an IAM role providing Neptune access to SageMaker and Amazon S3 resources. This must be listed in your DB cluster parameter group or an error will be thrown.</p>', 'CreateMLEndpointInput$modelName' => '<p>Model type for training. By default the Neptune ML model is automatically based on the <code>modelType</code> used in data processing, but you can specify a different model type here. The default is <code>rgcn</code> for heterogeneous graphs and <code>kge</code> for knowledge graphs. The only valid value for heterogeneous graphs is <code>rgcn</code>. Valid values for knowledge graphs are: <code>kge</code>, <code>transe</code>, <code>distmult</code>, and <code>rotate</code>.</p>', 'CreateMLEndpointInput$instanceType' => '<p>The type of Neptune ML instance to use for online servicing. The default is <code>ml.m5.xlarge</code>. Choosing the ML instance for an inference endpoint depends on the task type, the graph size, and your budget.</p>', 'CreateMLEndpointInput$volumeEncryptionKMSKey' => '<p>The Amazon Key Management Service (Amazon KMS) key that SageMaker uses to encrypt data on the storage volume attached to the ML compute instances that run the training job. The default is None.</p>', 'CreateMLEndpointOutput$id' => '<p>The unique ID of the new inference endpoint.</p>', 'CreateMLEndpointOutput$arn' => '<p>The ARN for the new inference endpoint.</p>', 'CustomModelTrainingParameters$sourceS3DirectoryPath' => '<p>The path to the Amazon S3 location where the Python module implementing your model is located. This must point to a valid existing Amazon S3 location that contains, at a minimum, a training script, a transform script, and a <code>model-hpo-configuration.json</code> file.</p>', 'CustomModelTrainingParameters$trainingEntryPointScript' => '<p>The name of the entry point in your module of a script that performs model training and takes hyperparameters as command-line arguments, including fixed hyperparameters. The default is <code>training.py</code>.</p>', 'CustomModelTrainingParameters$transformEntryPointScript' => '<p>The name of the entry point in your module of a script that should be run after the best model from the hyperparameter search has been identified, to compute the model artifacts necessary for model deployment. It should be able to run with no command-line arguments.The default is <code>transform.py</code>.</p>', 'CustomModelTransformParameters$sourceS3DirectoryPath' => '<p>The path to the Amazon S3 location where the Python module implementing your model is located. This must point to a valid existing Amazon S3 location that contains, at a minimum, a training script, a transform script, and a <code>model-hpo-configuration.json</code> file.</p>', 'CustomModelTransformParameters$transformEntryPointScript' => '<p>The name of the entry point in your module of a script that should be run after the best model from the hyperparameter search has been identified, to compute the model artifacts necessary for model deployment. It should be able to run with no command-line arguments. The default is <code>transform.py</code>.</p>', 'DeleteMLEndpointInput$id' => '<p>The unique identifier of the inference endpoint.</p>', 'DeleteMLEndpointInput$neptuneIamRoleArn' => '<p>The ARN of an IAM role providing Neptune access to SageMaker and Amazon S3 resources. This must be listed in your DB cluster parameter group or an error will be thrown.</p>', 'DeleteMLEndpointOutput$status' => '<p>The status of the cancellation.</p>', 'DeletePropertygraphStatisticsOutput$status' => '<p>The cancel status.</p>', 'DeleteSparqlStatisticsOutput$status' => '<p>The cancel status.</p>', 'DeleteStatisticsValueMap$statisticsId' => '<p>The ID of the statistics generation run that is currently occurring.</p>', 'DocumentValuedMap$key' => NULL, 'EdgeLabels$member' => NULL, 'EdgeProperties$member' => NULL, 'ExecuteFastResetInput$token' => '<p>The fast-reset token to initiate the reset.</p>', 'ExecuteFastResetOutput$status' => '<p>The <code>status</code> is only returned for the <code>performDatabaseReset</code> action, and indicates whether or not the fast reset rquest is accepted.</p>', 'ExecuteGremlinExplainQueryInput$gremlinQuery' => '<p>The Gremlin explain query string.</p>', 'ExecuteGremlinProfileQueryInput$gremlinQuery' => '<p>The Gremlin query string to profile.</p>', 'ExecuteGremlinProfileQueryInput$serializer' => '<p>If non-null, the gathered results are returned in a serialized response message in the format specified by this parameter. See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/gremlin-profile-api.html">Gremlin profile API in Neptune</a> for more information.</p>', 'ExecuteGremlinQueryInput$gremlinQuery' => '<p>Using this API, you can run Gremlin queries in string format much as you can using the HTTP endpoint. The interface is compatible with whatever Gremlin version your DB cluster is using (see the <a href="https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-gremlin-client.html#best-practices-gremlin-java-latest">Tinkerpop client section</a> to determine which Gremlin releases your engine version supports).</p>', 'ExecuteGremlinQueryInput$serializer' => '<p>If non-null, the query results are returned in a serialized response message in the format specified by this parameter. See the <a href="https://tinkerpop.apache.org/docs/current/reference/#_graphson">GraphSON</a> section in the TinkerPop documentation for a list of the formats that are currently supported.</p>', 'ExecuteGremlinQueryOutput$requestId' => '<p>The unique identifier of the Gremlin query.</p>', 'ExecuteOpenCypherExplainQueryInput$openCypherQuery' => '<p>The openCypher query string.</p>', 'ExecuteOpenCypherExplainQueryInput$parameters' => '<p>The openCypher query parameters.</p>', 'ExecuteOpenCypherQueryInput$openCypherQuery' => '<p>The openCypher query string to be executed.</p>', 'ExecuteOpenCypherQueryInput$parameters' => '<p>The openCypher query parameters for query execution. See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/opencypher-parameterized-queries.html">Examples of openCypher parameterized queries</a> for more information.</p>', 'ExpiredStreamException$detailedMessage' => '<p>A detailed message describing the problem.</p>', 'ExpiredStreamException$requestId' => '<p>The ID of the request in question.</p>', 'ExpiredStreamException$code' => '<p>The HTTP status code returned with the exception.</p>', 'FailureByQueryException$detailedMessage' => '<p>A detailed message describing the problem.</p>', 'FailureByQueryException$requestId' => '<p>The ID of the request in question.</p>', 'FailureByQueryException$code' => '<p>The HTTP status code returned with the exception.</p>', 'FastResetToken$token' => '<p>A UUID generated by the database in the <code>initiateDatabaseReset</code> action, and then consumed by the <code>performDatabaseReset</code> to reset the database.</p>', 'GetEngineStatusOutput$status' => '<p>Set to <code>healthy</code> if the instance is not experiencing problems. If the instance is recovering from a crash or from being rebooted and there are active transactions running from the latest server shutdown, status is set to <code>recovery</code>.</p>', 'GetEngineStatusOutput$startTime' => '<p>Set to the UTC time at which the current server process started.</p>', 'GetEngineStatusOutput$dbEngineVersion' => '<p>Set to the Neptune engine version running on your DB cluster. If this engine version has been manually patched since it was released, the version number is prefixed by <code>Patch-</code>.</p>', 'GetEngineStatusOutput$role' => '<p>Set to <code>reader</code> if the instance is a read-replica, or to <code>writer</code> if the instance is the primary instance.</p>', 'GetEngineStatusOutput$dfeQueryEngine' => '<p>Set to <code>enabled</code> if the DFE engine is fully enabled, or to <code>viaQueryHint</code> (the default) if the DFE engine is only used with queries that have the <code>useDFE</code> query hint set to <code>true</code>.</p>', 'GetEngineStatusOutput$rollingBackTrxEarliestStartTime' => '<p>Set to the start time of the earliest transaction being rolled back. If no transactions are being rolled back, the field doesn\'t appear at all.</p>', 'GetGremlinQueryStatusInput$queryId' => '<p>The unique identifier that identifies the Gremlin query.</p>', 'GetGremlinQueryStatusOutput$queryId' => '<p>The ID of the query for which status is being returned.</p>', 'GetGremlinQueryStatusOutput$queryString' => '<p>The Gremlin query string.</p>', 'GetLoaderJobStatusInput$loadId' => '<p>The load ID of the load job to get the status of.</p>', 'GetLoaderJobStatusOutput$status' => '<p>The HTTP response code for the request.</p>', 'GetMLDataProcessingJobInput$id' => '<p>The unique identifier of the data-processing job to be retrieved.</p>', 'GetMLDataProcessingJobInput$neptuneIamRoleArn' => '<p>The ARN of an IAM role that provides Neptune access to SageMaker and Amazon S3 resources. This must be listed in your DB cluster parameter group or an error will occur.</p>', 'GetMLDataProcessingJobOutput$status' => '<p>Status of the data processing job.</p>', 'GetMLDataProcessingJobOutput$id' => '<p>The unique identifier of this data-processing job.</p>', 'GetMLEndpointInput$id' => '<p>The unique identifier of the inference endpoint.</p>', 'GetMLEndpointInput$neptuneIamRoleArn' => '<p>The ARN of an IAM role that provides Neptune access to SageMaker and Amazon S3 resources. This must be listed in your DB cluster parameter group or an error will occur.</p>', 'GetMLEndpointOutput$status' => '<p>The status of the inference endpoint.</p>', 'GetMLEndpointOutput$id' => '<p>The unique identifier of the inference endpoint.</p>', 'GetMLModelTrainingJobInput$id' => '<p>The unique identifier of the model-training job to retrieve.</p>', 'GetMLModelTrainingJobInput$neptuneIamRoleArn' => '<p>The ARN of an IAM role that provides Neptune access to SageMaker and Amazon S3 resources. This must be listed in your DB cluster parameter group or an error will occur.</p>', 'GetMLModelTrainingJobOutput$status' => '<p>The status of the model training job.</p>', 'GetMLModelTrainingJobOutput$id' => '<p>The unique identifier of this model-training job.</p>', 'GetMLModelTransformJobInput$id' => '<p>The unique identifier of the model-transform job to be reetrieved.</p>', 'GetMLModelTransformJobInput$neptuneIamRoleArn' => '<p>The ARN of an IAM role that provides Neptune access to SageMaker and Amazon S3 resources. This must be listed in your DB cluster parameter group or an error will occur.</p>', 'GetMLModelTransformJobOutput$status' => '<p>The status of the model-transform job.</p>', 'GetMLModelTransformJobOutput$id' => '<p>The unique identifier of the model-transform job to be retrieved.</p>', 'GetOpenCypherQueryStatusInput$queryId' => '<p>The unique ID of the openCypher query for which to retrieve the query status.</p>', 'GetOpenCypherQueryStatusOutput$queryId' => '<p>The unique ID of the query for which status is being returned.</p>', 'GetOpenCypherQueryStatusOutput$queryString' => '<p>The openCypher query string.</p>', 'GetPropertygraphStatisticsOutput$status' => '<p>The HTTP return code of the request. If the request succeeded, the code is 200. See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/neptune-dfe-statistics.html#neptune-dfe-statistics-errors">Common error codes for DFE statistics request</a> for a list of common errors.</p>', 'GetPropertygraphStreamOutput$format' => '<p>Serialization format for the change records being returned. Currently, the only supported value is <code>PG_JSON</code>.</p>', 'GetSparqlStatisticsOutput$status' => '<p>The HTTP return code of the request. If the request succeeded, the code is 200. See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/neptune-dfe-statistics.html#neptune-dfe-statistics-errors">Common error codes for DFE statistics request</a> for a list of common errors.</p> <p>When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role making the request must have a policy attached that allows the <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getstatisticsstatus">neptune-db:GetStatisticsStatus</a> IAM action in that cluster.</p>', 'GetSparqlStreamOutput$format' => '<p>Serialization format for the change records being returned. Currently, the only supported value is <code>NQUADS</code>.</p>', 'GremlinQueryStatus$queryId' => '<p>The ID of the Gremlin query.</p>', 'GremlinQueryStatus$queryString' => '<p>The query string of the Gremlin query.</p>', 'GremlinQueryStatusAttributes$message' => '<p>The status message.</p>', 'IllegalArgumentException$detailedMessage' => '<p>A detailed message describing the problem.</p>', 'IllegalArgumentException$requestId' => '<p>The ID of the request in question.</p>', 'IllegalArgumentException$code' => '<p>The HTTP status code returned with the exception.</p>', 'InternalFailureException$detailedMessage' => '<p>A detailed message describing the problem.</p>', 'InternalFailureException$requestId' => '<p>The ID of the request in question.</p>', 'InternalFailureException$code' => '<p>The HTTP status code returned with the exception.</p>', 'InvalidArgumentException$detailedMessage' => '<p>A detailed message describing the problem.</p>', 'InvalidArgumentException$requestId' => '<p>The ID of the request in question.</p>', 'InvalidArgumentException$code' => '<p>The HTTP status code returned with the exception.</p>', 'InvalidNumericDataException$detailedMessage' => '<p>A detailed message describing the problem.</p>', 'InvalidNumericDataException$requestId' => '<p>The ID of the request in question.</p>', 'InvalidNumericDataException$code' => '<p>The HTTP status code returned with the exception.</p>', 'InvalidParameterException$detailedMessage' => '<p>A detailed message describing the problem.</p>', 'InvalidParameterException$requestId' => '<p>The ID of the request that includes an invalid parameter.</p>', 'InvalidParameterException$code' => '<p>The HTTP status code returned with the exception.</p>', 'ListLoaderJobsOutput$status' => '<p>Returns the status of the job list request.</p>', 'ListMLDataProcessingJobsInput$neptuneIamRoleArn' => '<p>The ARN of an IAM role that provides Neptune access to SageMaker and Amazon S3 resources. This must be listed in your DB cluster parameter group or an error will occur.</p>', 'ListMLEndpointsInput$neptuneIamRoleArn' => '<p>The ARN of an IAM role that provides Neptune access to SageMaker and Amazon S3 resources. This must be listed in your DB cluster parameter group or an error will occur.</p>', 'ListMLModelTrainingJobsInput$neptuneIamRoleArn' => '<p>The ARN of an IAM role that provides Neptune access to SageMaker and Amazon S3 resources. This must be listed in your DB cluster parameter group or an error will occur.</p>', 'ListMLModelTransformJobsInput$neptuneIamRoleArn' => '<p>The ARN of an IAM role that provides Neptune access to SageMaker and Amazon S3 resources. This must be listed in your DB cluster parameter group or an error will occur.</p>', 'LoadUrlAccessDeniedException$detailedMessage' => '<p>A detailed message describing the problem.</p>', 'LoadUrlAccessDeniedException$requestId' => '<p>The ID of the request in question.</p>', 'LoadUrlAccessDeniedException$code' => '<p>The HTTP status code returned with the exception.</p>', 'LongValuedMap$key' => NULL, 'MLResourceNotFoundException$detailedMessage' => '<p>A detailed message describing the problem.</p>', 'MLResourceNotFoundException$requestId' => '<p>The ID of the request in question.</p>', 'MLResourceNotFoundException$code' => '<p>The HTTP status code returned with the exception.</p>', 'MalformedQueryException$detailedMessage' => '<p>A detailed message describing the problem.</p>', 'MalformedQueryException$requestId' => '<p>The ID of the malformed query request.</p>', 'MalformedQueryException$code' => '<p>The HTTP status code returned with the exception.</p>', 'ManagePropertygraphStatisticsOutput$status' => '<p>The HTTP return code of the request. If the request succeeded, the code is 200.</p>', 'ManageSparqlStatisticsOutput$status' => '<p>The HTTP return code of the request. If the request succeeded, the code is 200.</p>', 'MemoryLimitExceededException$detailedMessage' => '<p>A detailed message describing the problem.</p>', 'MemoryLimitExceededException$requestId' => '<p>The ID of the request that failed.</p>', 'MemoryLimitExceededException$code' => '<p>The HTTP status code returned with the exception.</p>', 'MethodNotAllowedException$detailedMessage' => '<p>A detailed message describing the problem.</p>', 'MethodNotAllowedException$requestId' => '<p>The ID of the request in question.</p>', 'MethodNotAllowedException$code' => '<p>The HTTP status code returned with the exception.</p>', 'MissingParameterException$detailedMessage' => '<p>A detailed message describing the problem.</p>', 'MissingParameterException$requestId' => '<p>The ID of the request in which the parameter is missing.</p>', 'MissingParameterException$code' => '<p>The HTTP status code returned with the exception.</p>', 'MlConfigDefinition$name' => '<p>The configuration name.</p>', 'MlConfigDefinition$arn' => '<p>The ARN for the configuration.</p>', 'MlResourceDefinition$name' => '<p>The resource name.</p>', 'MlResourceDefinition$arn' => '<p>The resource ARN.</p>', 'MlResourceDefinition$status' => '<p>The resource status.</p>', 'MlResourceDefinition$outputLocation' => '<p>The output location.</p>', 'MlResourceDefinition$failureReason' => '<p>The failure reason, in case of a failure.</p>', 'MlResourceDefinition$cloudwatchLogUrl' => '<p>The CloudWatch log URL for the resource.</p>', 'NodeLabels$member' => NULL, 'NodeProperties$member' => NULL, 'OutgoingEdgeLabels$member' => NULL, 'ParsingException$detailedMessage' => '<p>A detailed message describing the problem.</p>', 'ParsingException$requestId' => '<p>The ID of the request in question.</p>', 'ParsingException$code' => '<p>The HTTP status code returned with the exception.</p>', 'PreconditionsFailedException$detailedMessage' => '<p>A detailed message describing the problem.</p>', 'PreconditionsFailedException$requestId' => '<p>The ID of the request in question.</p>', 'PreconditionsFailedException$code' => '<p>The HTTP status code returned with the exception.</p>', 'Predicates$member' => NULL, 'PropertygraphData$id' => '<p>The ID of the Gremlin or openCypher element.</p>', 'PropertygraphData$type' => '<p>The type of this Gremlin or openCypher element. Must be one of:</p> <ul> <li> <p> <b> <code>v1</code> </b>   -   Vertex label for Gremlin, or node label for openCypher.</p> </li> <li> <p> <b> <code>vp</code> </b>   -   Vertex properties for Gremlin, or node properties for openCypher.</p> </li> <li> <p> <b> <code>e</code> </b>   -   Edge and edge label for Gremlin, or relationship and relationship type for openCypher.</p> </li> <li> <p> <b> <code>ep</code> </b>   -   Edge properties for Gremlin, or relationship properties for openCypher.</p> </li> </ul>', 'PropertygraphData$key' => '<p>The property name. For element labels, this is <code>label</code>.</p>', 'PropertygraphData$from' => '<p>If this is an edge (type = <code>e</code>), the ID of the corresponding <code>from</code> vertex or source node.</p>', 'PropertygraphData$to' => '<p>If this is an edge (type = <code>e</code>), the ID of the corresponding <code>to</code> vertex or target node.</p>', 'PropertygraphRecord$op' => '<p>The operation that created the change.</p>', 'PropertygraphSummaryValueMap$version' => '<p>The version of this graph summary response.</p>', 'QueryLanguageVersion$version' => '<p>The version of the query language.</p>', 'QueryLimitExceededException$detailedMessage' => '<p>A detailed message describing the problem.</p>', 'QueryLimitExceededException$requestId' => '<p>The ID of the request which exceeded the limit.</p>', 'QueryLimitExceededException$code' => '<p>The HTTP status code returned with the exception.</p>', 'QueryLimitException$detailedMessage' => '<p>A detailed message describing the problem.</p>', 'QueryLimitException$requestId' => '<p>The ID of the request that exceeded the limit.</p>', 'QueryLimitException$code' => '<p>The HTTP status code returned with the exception.</p>', 'QueryTooLargeException$detailedMessage' => '<p>A detailed message describing the problem.</p>', 'QueryTooLargeException$requestId' => '<p>The ID of the request that is too large.</p>', 'QueryTooLargeException$code' => '<p>The HTTP status code returned with the exception.</p>', 'RDFGraphSummaryValueMap$version' => '<p>The version of this graph summary response.</p>', 'ReadOnlyViolationException$detailedMessage' => '<p>A detailed message describing the problem.</p>', 'ReadOnlyViolationException$requestId' => '<p>The ID of the request in which the parameter is missing.</p>', 'ReadOnlyViolationException$code' => '<p>The HTTP status code returned with the exception.</p>', 'RefreshStatisticsIdMap$statisticsId' => '<p>The ID of the statistics generation run that is currently occurring.</p>', 'S3Exception$detailedMessage' => '<p>A detailed message describing the problem.</p>', 'S3Exception$requestId' => '<p>The ID of the request in question.</p>', 'S3Exception$code' => '<p>The HTTP status code returned with the exception.</p>', 'ServerShutdownException$detailedMessage' => '<p>A detailed message describing the problem.</p>', 'ServerShutdownException$requestId' => '<p>The ID of the request in question.</p>', 'ServerShutdownException$code' => '<p>The HTTP status code returned with the exception.</p>', 'SparqlData$stmt' => '<p>Holds an <a href="https://www.w3.org/TR/n-quads/">N-QUADS</a> statement expressing the changed quad.</p>', 'SparqlRecord$op' => '<p>The operation that created the change.</p>', 'StartLoaderJobInput$source' => '<p>The <code>source</code> parameter accepts an S3 URI that identifies a single file, multiple files, a folder, or multiple folders. Neptune loads every data file in any folder that is specified.</p> <p>The URI can be in any of the following formats.</p> <ul> <li> <p> <code>s3://(bucket_name)/(object-key-name)</code> </p> </li> <li> <p> <code>https://s3.amazonaws.com/(bucket_name)/(object-key-name)</code> </p> </li> <li> <p> <code>https://s3.us-east-1.amazonaws.com/(bucket_name)/(object-key-name)</code> </p> </li> </ul> <p>The <code>object-key-name</code> element of the URI is equivalent to the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListObjects.html#API_ListObjects_RequestParameters">prefix</a> parameter in an S3 <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListObjects.html">ListObjects</a> API call. It identifies all the objects in the specified S3 bucket whose names begin with that prefix. That can be a single file or folder, or multiple files and/or folders.</p> <p>The specified folder or folders can contain multiple vertex files and multiple edge files.</p>', 'StartLoaderJobInput$iamRoleArn' => '<p>The Amazon Resource Name (ARN) for an IAM role to be assumed by the Neptune DB instance for access to the S3 bucket. The IAM role ARN provided here should be attached to the DB cluster (see <a href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-IAM-add-role-cluster.html">Adding the IAM Role to an Amazon Neptune Cluster</a>.</p>', 'StartLoaderJobOutput$status' => '<p>The HTTP return code indicating the status of the load job.</p>', 'StartMLDataProcessingJobInput$id' => '<p>A unique identifier for the new job. The default is an autogenerated UUID.</p>', 'StartMLDataProcessingJobInput$previousDataProcessingJobId' => '<p>The job ID of a completed data processing job run on an earlier version of the data.</p>', 'StartMLDataProcessingJobInput$inputDataS3Location' => '<p>The URI of the Amazon S3 location where you want SageMaker to download the data needed to run the data processing job.</p>', 'StartMLDataProcessingJobInput$processedDataS3Location' => '<p>The URI of the Amazon S3 location where you want SageMaker to save the results of a data processing job.</p>', 'StartMLDataProcessingJobInput$sagemakerIamRoleArn' => '<p>The ARN of an IAM role for SageMaker execution. This must be listed in your DB cluster parameter group or an error will occur.</p>', 'StartMLDataProcessingJobInput$neptuneIamRoleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role that SageMaker can assume to perform tasks on your behalf. This must be listed in your DB cluster parameter group or an error will occur.</p>', 'StartMLDataProcessingJobInput$processingInstanceType' => '<p>The type of ML instance used during data processing. Its memory should be large enough to hold the processed dataset. The default is the smallest ml.r5 type whose memory is ten times larger than the size of the exported graph data on disk.</p>', 'StartMLDataProcessingJobInput$modelType' => '<p>One of the two model types that Neptune ML currently supports: heterogeneous graph models (<code>heterogeneous</code>), and knowledge graph (<code>kge</code>). The default is none. If not specified, Neptune ML chooses the model type automatically based on the data.</p>', 'StartMLDataProcessingJobInput$configFileName' => '<p>A data specification file that describes how to load the exported graph data for training. The file is automatically generated by the Neptune export toolkit. The default is <code>training-data-configuration.json</code>.</p>', 'StartMLDataProcessingJobInput$volumeEncryptionKMSKey' => '<p>The Amazon Key Management Service (Amazon KMS) key that SageMaker uses to encrypt data on the storage volume attached to the ML compute instances that run the training job. The default is None.</p>', 'StartMLDataProcessingJobInput$s3OutputEncryptionKMSKey' => '<p>The Amazon Key Management Service (Amazon KMS) key that SageMaker uses to encrypt the output of the processing job. The default is none.</p>', 'StartMLDataProcessingJobOutput$id' => '<p>The unique ID of the new data processing job.</p>', 'StartMLDataProcessingJobOutput$arn' => '<p>The ARN of the data processing job.</p>', 'StartMLModelTrainingJobInput$id' => '<p>A unique identifier for the new job. The default is An autogenerated UUID.</p>', 'StartMLModelTrainingJobInput$previousModelTrainingJobId' => '<p>The job ID of a completed model-training job that you want to update incrementally based on updated data.</p>', 'StartMLModelTrainingJobInput$dataProcessingJobId' => '<p>The job ID of the completed data-processing job that has created the data that the training will work with.</p>', 'StartMLModelTrainingJobInput$trainModelS3Location' => '<p>The location in Amazon S3 where the model artifacts are to be stored.</p>', 'StartMLModelTrainingJobInput$sagemakerIamRoleArn' => '<p>The ARN of an IAM role for SageMaker execution.This must be listed in your DB cluster parameter group or an error will occur.</p>', 'StartMLModelTrainingJobInput$neptuneIamRoleArn' => '<p>The ARN of an IAM role that provides Neptune access to SageMaker and Amazon S3 resources. This must be listed in your DB cluster parameter group or an error will occur.</p>', 'StartMLModelTrainingJobInput$baseProcessingInstanceType' => '<p>The type of ML instance used in preparing and managing training of ML models. This is a CPU instance chosen based on memory requirements for processing the training data and model.</p>', 'StartMLModelTrainingJobInput$trainingInstanceType' => '<p>The type of ML instance used for model training. All Neptune ML models support CPU, GPU, and multiGPU training. The default is <code>ml.p3.2xlarge</code>. Choosing the right instance type for training depends on the task type, graph size, and your budget.</p>', 'StartMLModelTrainingJobInput$volumeEncryptionKMSKey' => '<p>The Amazon Key Management Service (KMS) key that SageMaker uses to encrypt data on the storage volume attached to the ML compute instances that run the training job. The default is None.</p>', 'StartMLModelTrainingJobInput$s3OutputEncryptionKMSKey' => '<p>The Amazon Key Management Service (KMS) key that SageMaker uses to encrypt the output of the processing job. The default is none.</p>', 'StartMLModelTrainingJobOutput$id' => '<p>The unique ID of the new model training job.</p>', 'StartMLModelTrainingJobOutput$arn' => '<p>The ARN of the new model training job.</p>', 'StartMLModelTransformJobInput$id' => '<p>A unique identifier for the new job. The default is an autogenerated UUID.</p>', 'StartMLModelTransformJobInput$dataProcessingJobId' => '<p>The job ID of a completed data-processing job. You must include either <code>dataProcessingJobId</code> and a <code>mlModelTrainingJobId</code>, or a <code>trainingJobName</code>.</p>', 'StartMLModelTransformJobInput$mlModelTrainingJobId' => '<p>The job ID of a completed model-training job. You must include either <code>dataProcessingJobId</code> and a <code>mlModelTrainingJobId</code>, or a <code>trainingJobName</code>.</p>', 'StartMLModelTransformJobInput$trainingJobName' => '<p>The name of a completed SageMaker training job. You must include either <code>dataProcessingJobId</code> and a <code>mlModelTrainingJobId</code>, or a <code>trainingJobName</code>.</p>', 'StartMLModelTransformJobInput$modelTransformOutputS3Location' => '<p>The location in Amazon S3 where the model artifacts are to be stored.</p>', 'StartMLModelTransformJobInput$sagemakerIamRoleArn' => '<p>The ARN of an IAM role for SageMaker execution. This must be listed in your DB cluster parameter group or an error will occur.</p>', 'StartMLModelTransformJobInput$neptuneIamRoleArn' => '<p>The ARN of an IAM role that provides Neptune access to SageMaker and Amazon S3 resources. This must be listed in your DB cluster parameter group or an error will occur.</p>', 'StartMLModelTransformJobInput$baseProcessingInstanceType' => '<p>The type of ML instance used in preparing and managing training of ML models. This is an ML compute instance chosen based on memory requirements for processing the training data and model.</p>', 'StartMLModelTransformJobInput$volumeEncryptionKMSKey' => '<p>The Amazon Key Management Service (KMS) key that SageMaker uses to encrypt data on the storage volume attached to the ML compute instances that run the training job. The default is None.</p>', 'StartMLModelTransformJobInput$s3OutputEncryptionKMSKey' => '<p>The Amazon Key Management Service (KMS) key that SageMaker uses to encrypt the output of the processing job. The default is none.</p>', 'StartMLModelTransformJobOutput$id' => '<p>The unique ID of the new model transform job.</p>', 'StartMLModelTransformJobOutput$arn' => '<p>The ARN of the model transform job.</p>', 'Statistics$statisticsId' => '<p>Reports the ID of the current statistics generation run. A value of -1 indicates that no statistics have been generated.</p>', 'Statistics$note' => '<p>A note about problems in the case where statistics are invalid.</p>', 'StatisticsNotAvailableException$detailedMessage' => '<p>A detailed message describing the problem.</p>', 'StatisticsNotAvailableException$requestId' => '<p>The ID of the request in question.</p>', 'StatisticsNotAvailableException$code' => '<p>The HTTP status code returned with the exception.</p>', 'StreamRecordsNotFoundException$detailedMessage' => '<p>A detailed message describing the problem.</p>', 'StreamRecordsNotFoundException$requestId' => '<p>The ID of the request in question.</p>', 'StreamRecordsNotFoundException$code' => '<p>The HTTP status code returned with the exception.</p>', 'StringList$member' => NULL, 'StringValuedMap$key' => NULL, 'StringValuedMap$value' => NULL, 'ThrottlingException$detailedMessage' => '<p>A detailed message describing the problem.</p>', 'ThrottlingException$requestId' => '<p>The ID of the request that could not be processed for this reason.</p>', 'ThrottlingException$code' => '<p>The HTTP status code returned with the exception.</p>', 'TimeLimitExceededException$detailedMessage' => '<p>A detailed message describing the problem.</p>', 'TimeLimitExceededException$requestId' => '<p>The ID of the request that could not be processed for this reason.</p>', 'TimeLimitExceededException$code' => '<p>The HTTP status code returned with the exception.</p>', 'TooManyRequestsException$detailedMessage' => '<p>A detailed message describing the problem.</p>', 'TooManyRequestsException$requestId' => '<p>The ID of the request that could not be processed for this reason.</p>', 'TooManyRequestsException$code' => '<p>The HTTP status code returned with the exception.</p>', 'UnsupportedOperationException$detailedMessage' => '<p>A detailed message describing the problem.</p>', 'UnsupportedOperationException$requestId' => '<p>The ID of the request in question.</p>', 'UnsupportedOperationException$code' => '<p>The HTTP status code returned with the exception.</p>', ], ], 'StringList' => [ 'base' => NULL, 'refs' => [ 'ListMLDataProcessingJobsOutput$ids' => '<p>A page listing data processing job IDs.</p>', 'ListMLEndpointsOutput$ids' => '<p>A page from the list of inference endpoint IDs.</p>', 'ListMLModelTrainingJobsOutput$ids' => '<p>A page of the list of model training job IDs.</p>', 'ListMLModelTransformJobsOutput$ids' => '<p>A page from the list of model transform IDs.</p>', 'LoaderIdResult$loadIds' => '<p>A list of load IDs.</p>', 'StartLoaderJobInput$dependencies' => '<p>This is an optional parameter that can make a queued load request contingent on the successful completion of one or more previous jobs in the queue.</p> <p>Neptune can queue up as many as 64 load requests at a time, if their <code>queueRequest</code> parameters are set to <code>"TRUE"</code>. The <code>dependencies</code> parameter lets you make execution of such a queued request dependent on the successful completion of one or more specified previous requests in the queue.</p> <p>For example, if load <code>Job-A</code> and <code>Job-B</code> are independent of each other, but load <code>Job-C</code> needs <code>Job-A</code> and <code>Job-B</code> to be finished before it begins, proceed as follows:</p> <ol> <li> <p>Submit <code>load-job-A</code> and <code>load-job-B</code> one after another in any order, and save their load-ids.</p> </li> <li> <p>Submit <code>load-job-C</code> with the load-ids of the two jobs in its <code>dependencies</code> field:</p> </li> </ol> <p>Because of the <code>dependencies</code> parameter, the bulk loader will not start <code>Job-C</code> until <code>Job-A</code> and <code>Job-B</code> have completed successfully. If either one of them fails, Job-C will not be executed, and its status will be set to <code>LOAD_FAILED_BECAUSE_DEPENDENCY_NOT_SATISFIED</code>.</p> <p>You can set up multiple levels of dependency in this way, so that the failure of one job will cause all requests that are directly or indirectly dependent on it to be cancelled.</p>', 'StartMLDataProcessingJobInput$subnets' => '<p>The IDs of the subnets in the Neptune VPC. The default is None.</p>', 'StartMLDataProcessingJobInput$securityGroupIds' => '<p>The VPC security group IDs. The default is None.</p>', 'StartMLModelTrainingJobInput$subnets' => '<p>The IDs of the subnets in the Neptune VPC. The default is None.</p>', 'StartMLModelTrainingJobInput$securityGroupIds' => '<p>The VPC security group IDs. The default is None.</p>', 'StartMLModelTransformJobInput$subnets' => '<p>The IDs of the subnets in the Neptune VPC. The default is None.</p>', 'StartMLModelTransformJobInput$securityGroupIds' => '<p>The VPC security group IDs. The default is None.</p>', ], ], 'StringValuedMap' => [ 'base' => NULL, 'refs' => [ 'GetEngineStatusOutput$labMode' => '<p>Contains Lab Mode settings being used by the engine.</p>', 'GetEngineStatusOutput$settings' => '<p>Contains information about the current settings on your DB cluster. For example, contains the current cluster query timeout setting (<code>clusterQueryTimeoutInMs</code>).</p>', 'GetPropertygraphStreamOutput$lastEventId' => '<p>Sequence identifier of the last change in the stream response.</p> <p>An event ID is composed of two fields: a <code>commitNum</code>, which identifies a transaction that changed the graph, and an <code>opNum</code>, which identifies a specific operation within that transaction:</p>', 'GetSparqlStreamOutput$lastEventId' => '<p>Sequence identifier of the last change in the stream response.</p> <p>An event ID is composed of two fields: a <code>commitNum</code>, which identifies a transaction that changed the graph, and an <code>opNum</code>, which identifies a specific operation within that transaction:</p>', 'PropertygraphRecord$eventId' => '<p>The sequence identifier of the stream change record.</p>', 'SparqlRecord$eventId' => '<p>The sequence identifier of the stream change record.</p>', 'StartLoaderJobInput$parserConfiguration' => '<p> <b> <code>parserConfiguration</code> </b>   –   An optional object with additional parser configuration values. Each of the child parameters is also optional:</p> <p class="title"> <b/> </p> <ul> <li> <p> <b> <code>namedGraphUri</code> </b>   –   The default graph for all RDF formats when no graph is specified (for non-quads formats and NQUAD entries with no graph).</p> <p>The default is <code>https://aws.amazon.com/neptune/vocab/v01/DefaultNamedGraph</code>.</p> </li> <li> <p> <b> <code>baseUri</code> </b>   –   The base URI for RDF/XML and Turtle formats.</p> <p>The default is <code>https://aws.amazon.com/neptune/default</code>.</p> </li> <li> <p> <b> <code>allowEmptyStrings</code> </b>   –   Gremlin users need to be able to pass empty string values("") as node and edge properties when loading CSV data. If <code>allowEmptyStrings</code> is set to <code>false</code> (the default), such empty strings are treated as nulls and are not loaded.</p> <p>If <code>allowEmptyStrings</code> is set to <code>true</code>, the loader treats empty strings as valid property values and loads them accordingly.</p> </li> </ul>', 'StartLoaderJobOutput$payload' => '<p>Contains a <code>loadId</code> name-value pair that provides an identifier for the load operation.</p>', ], ], 'SubjectStructure' => [ 'base' => '<p>A subject structure.</p>', 'refs' => [ 'SubjectStructures$member' => NULL, ], ], 'SubjectStructures' => [ 'base' => NULL, 'refs' => [ 'RDFGraphSummary$subjectStructures' => '<p>This field is only present when the request mode is <code>DETAILED</code>. It contains a list of subject structures.</p>', ], ], 'SyntheticTimestamp_date_time' => [ 'base' => NULL, 'refs' => [ 'PropertygraphSummaryValueMap$lastStatisticsComputationTime' => '<p>The timestamp, in ISO 8601 format, of the time at which Neptune last computed statistics.</p>', 'RDFGraphSummaryValueMap$lastStatisticsComputationTime' => '<p>The timestamp, in ISO 8601 format, of the time at which Neptune last computed statistics.</p>', 'Statistics$date' => '<p>The UTC time at which DFE statistics have most recently been generated.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>Raised when the rate of requests exceeds the maximum throughput. Requests can be retried after encountering this exception.</p>', 'refs' => [], ], 'TimeLimitExceededException' => [ 'base' => '<p>Raised when the an operation exceeds the time limit allowed for it.</p>', 'refs' => [], ], 'TooManyRequestsException' => [ 'base' => '<p>Raised when the number of requests being processed exceeds the limit.</p>', 'refs' => [], ], 'UnsupportedOperationException' => [ 'base' => '<p>Raised when a request attempts to initiate an operation that is not supported.</p>', 'refs' => [], ], ],];
