<?php
// This file was auto-generated from sdk-root/src/data/nimble/2020-08-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Welcome to the Amazon Nimble Studio API reference. This API reference provides methods, schema, resources, parameters, and more to help you get the most out of Nimble Studio.</p> <p>Nimble Studio is a virtual studio that empowers visual effects, animation, and interactive content teams to create content securely within a scalable, private cloud service.</p>', 'operations' => [ 'AcceptEulas' => '<p>Accept EULAs.</p>', 'CreateLaunchProfile' => '<p>Create a launch profile.</p>', 'CreateStreamingImage' => '<p>Creates a streaming image resource in a studio.</p>', 'CreateStreamingSession' => '<p>Creates a streaming session in a studio.</p> <p>After invoking this operation, you must poll GetStreamingSession until the streaming session is in the <code>READY</code> state.</p>', 'CreateStreamingSessionStream' => '<p>Creates a streaming session stream for a streaming session.</p> <p>After invoking this API, invoke GetStreamingSessionStream with the returned streamId to poll the resource until it is in the <code>READY</code> state.</p>', 'CreateStudio' => '<p>Create a new studio.</p> <p>When creating a studio, two IAM roles must be provided: the admin role and the user role. These roles are assumed by your users when they log in to the Nimble Studio portal.</p> <p>The user role must have the <code>AmazonNimbleStudio-StudioUser</code> managed policy attached for the portal to function properly.</p> <p>The admin role must have the <code>AmazonNimbleStudio-StudioAdmin</code> managed policy attached for the portal to function properly.</p> <p>You may optionally specify a KMS key in the <code>StudioEncryptionConfiguration</code>.</p> <p>In Nimble Studio, resource names, descriptions, initialization scripts, and other data you provide are always encrypted at rest using an KMS key. By default, this key is owned by Amazon Web Services and managed on your behalf. You may provide your own KMS key when calling <code>CreateStudio</code> to encrypt this data using a key you own and manage.</p> <p>When providing an KMS key during studio creation, Nimble Studio creates KMS grants in your account to provide your studio user and admin roles access to these KMS keys.</p> <p>If you delete this grant, the studio will no longer be accessible to your portal users.</p> <p>If you delete the studio KMS key, your studio will no longer be accessible.</p>', 'CreateStudioComponent' => '<p>Creates a studio component resource.</p>', 'DeleteLaunchProfile' => '<p>Permanently delete a launch profile.</p>', 'DeleteLaunchProfileMember' => '<p>Delete a user from launch profile membership.</p>', 'DeleteStreamingImage' => '<p>Delete streaming image.</p>', 'DeleteStreamingSession' => '<p>Deletes streaming session resource.</p> <p>After invoking this operation, use GetStreamingSession to poll the resource until it transitions to a <code>DELETED</code> state.</p> <p>A streaming session will count against your streaming session quota until it is marked <code>DELETED</code>.</p>', 'DeleteStudio' => '<p>Delete a studio resource.</p>', 'DeleteStudioComponent' => '<p>Deletes a studio component resource.</p>', 'DeleteStudioMember' => '<p>Delete a user from studio membership.</p>', 'GetEula' => '<p>Get EULA.</p>', 'GetLaunchProfile' => '<p>Get a launch profile.</p>', 'GetLaunchProfileDetails' => '<p>Launch profile details include the launch profile resource and summary information of resources that are used by, or available to, the launch profile. This includes the name and description of all studio components used by the launch profiles, and the name and description of streaming images that can be used with this launch profile.</p>', 'GetLaunchProfileInitialization' => '<p>Get a launch profile initialization.</p>', 'GetLaunchProfileMember' => '<p>Get a user persona in launch profile membership.</p>', 'GetStreamingImage' => '<p>Get streaming image.</p>', 'GetStreamingSession' => '<p>Gets StreamingSession resource.</p> <p>Invoke this operation to poll for a streaming session state while creating or deleting a session.</p>', 'GetStreamingSessionBackup' => '<p>Gets <code>StreamingSessionBackup</code> resource.</p> <p>Invoke this operation to poll for a streaming session backup while stopping a streaming session.</p>', 'GetStreamingSessionStream' => '<p>Gets a StreamingSessionStream for a streaming session.</p> <p>Invoke this operation to poll the resource after invoking <code>CreateStreamingSessionStream</code>.</p> <p>After the <code>StreamingSessionStream</code> changes to the <code>READY</code> state, the url property will contain a stream to be used with the DCV streaming client.</p>', 'GetStudio' => '<p>Get a studio resource.</p>', 'GetStudioComponent' => '<p>Gets a studio component resource.</p>', 'GetStudioMember' => '<p>Get a user\'s membership in a studio.</p>', 'ListEulaAcceptances' => '<p>List EULA acceptances.</p>', 'ListEulas' => '<p>List EULAs.</p>', 'ListLaunchProfileMembers' => '<p>Get all users in a given launch profile membership.</p>', 'ListLaunchProfiles' => '<p>List all the launch profiles a studio.</p>', 'ListStreamingImages' => '<p>List the streaming image resources available to this studio.</p> <p>This list will contain both images provided by Amazon Web Services, as well as streaming images that you have created in your studio.</p>', 'ListStreamingSessionBackups' => '<p>Lists the backups of a streaming session in a studio.</p>', 'ListStreamingSessions' => '<p>Lists the streaming sessions in a studio.</p>', 'ListStudioComponents' => '<p>Lists the <code>StudioComponents</code> in a studio.</p>', 'ListStudioMembers' => '<p>Get all users in a given studio membership.</p> <note> <p> <code>ListStudioMembers</code> only returns admin members.</p> </note>', 'ListStudios' => '<p>List studios in your Amazon Web Services accounts in the requested Amazon Web Services Region.</p>', 'ListTagsForResource' => '<p>Gets the tags for a resource, given its Amazon Resource Names (ARN).</p> <p>This operation supports ARNs for all resource types in Nimble Studio that support tags, including studio, studio component, launch profile, streaming image, and streaming session. All resources that can be tagged will contain an ARN property, so you do not have to create this ARN yourself.</p>', 'PutLaunchProfileMembers' => '<p>Add/update users with given persona to launch profile membership.</p>', 'PutStudioMembers' => '<p>Add/update users with given persona to studio membership.</p>', 'StartStreamingSession' => '<p>Transitions sessions from the <code>STOPPED</code> state into the <code>READY</code> state. The <code>START_IN_PROGRESS</code> state is the intermediate state between the <code>STOPPED</code> and <code>READY</code> states.</p>', 'StartStudioSSOConfigurationRepair' => '<p>Repairs the IAM Identity Center configuration for a given studio.</p> <p>If the studio has a valid IAM Identity Center configuration currently associated with it, this operation will fail with a validation error.</p> <p>If the studio does not have a valid IAM Identity Center configuration currently associated with it, then a new IAM Identity Center application is created for the studio and the studio is changed to the <code>READY</code> state.</p> <p>After the IAM Identity Center application is repaired, you must use the Amazon Nimble Studio console to add administrators and users to your studio.</p>', 'StopStreamingSession' => '<p>Transitions sessions from the <code>READY</code> state into the <code>STOPPED</code> state. The <code>STOP_IN_PROGRESS</code> state is the intermediate state between the <code>READY</code> and <code>STOPPED</code> states.</p>', 'TagResource' => '<p>Creates tags for a resource, given its ARN.</p>', 'UntagResource' => '<p>Deletes the tags for a resource.</p>', 'UpdateLaunchProfile' => '<p>Update a launch profile.</p>', 'UpdateLaunchProfileMember' => '<p>Update a user persona in launch profile membership.</p>', 'UpdateStreamingImage' => '<p>Update streaming image.</p>', 'UpdateStudio' => '<p>Update a Studio resource.</p> <p>Currently, this operation only supports updating the displayName of your studio.</p>', 'UpdateStudioComponent' => '<p>Updates a studio component resource.</p>', ], 'shapes' => [ 'AcceptEulasRequest' => [ 'base' => NULL, 'refs' => [], ], 'AcceptEulasResponse' => [ 'base' => NULL, 'refs' => [], ], 'AccessDeniedException' => [ 'base' => '<p>You are not authorized to perform this operation. Check your IAM policies, and ensure that you are using the correct access keys.</p>', 'refs' => [], ], 'ActiveDirectoryComputerAttribute' => [ 'base' => '<p>An LDAP attribute of an Active Directory computer account, in the form of a name:value pair.</p>', 'refs' => [ 'ActiveDirectoryComputerAttributeList$member' => NULL, ], ], 'ActiveDirectoryComputerAttributeList' => [ 'base' => '<p>A collection of LDAP attributes to apply to Active Directory computer accounts that are created for streaming sessions.</p>', 'refs' => [ 'ActiveDirectoryConfiguration$computerAttributes' => '<p>A collection of custom attributes for an Active Directory computer.</p>', 'LaunchProfileInitializationActiveDirectory$computerAttributes' => '<p>A collection of custom attributes for an Active Directory computer.</p>', ], ], 'ActiveDirectoryComputerAttributeName' => [ 'base' => '<p>The name for the LDAP attribute.</p>', 'refs' => [ 'ActiveDirectoryComputerAttribute$name' => '<p>The name for the LDAP attribute.</p>', ], ], 'ActiveDirectoryComputerAttributeValue' => [ 'base' => '<p>The value for the LDAP attribute.</p>', 'refs' => [ 'ActiveDirectoryComputerAttribute$value' => '<p>The value for the LDAP attribute.</p>', ], ], 'ActiveDirectoryConfiguration' => [ 'base' => '<p>The configuration for a Directory Service for Microsoft Active Directory studio resource.</p>', 'refs' => [ 'StudioComponentConfiguration$activeDirectoryConfiguration' => '<p>The configuration for a Directory Service for Microsoft Active Directory studio resource.</p>', ], ], 'ActiveDirectoryDnsIpAddress' => [ 'base' => NULL, 'refs' => [ 'ActiveDirectoryDnsIpAddressList$member' => NULL, ], ], 'ActiveDirectoryDnsIpAddressList' => [ 'base' => NULL, 'refs' => [ 'LaunchProfileInitializationActiveDirectory$dnsIpAddresses' => '<p>The DNS IP address.</p>', ], ], 'ActiveDirectoryOrganizationalUnitDistinguishedName' => [ 'base' => '<p>The fully-qualified distinguished name of the organizational unit to place the computer account in.</p>', 'refs' => [ 'ActiveDirectoryConfiguration$organizationalUnitDistinguishedName' => '<p>The distinguished name (DN) and organizational unit (OU) of an Active Directory computer.</p>', 'LaunchProfileInitializationActiveDirectory$organizationalUnitDistinguishedName' => '<p>The name for the organizational unit distinguished name.</p>', ], ], 'AutomaticTerminationMode' => [ 'base' => NULL, 'refs' => [ 'StreamConfiguration$automaticTerminationMode' => '<p>Indicates if a streaming session created from this launch profile should be terminated automatically or retained without termination after being in a <code>STOPPED</code> state.</p> <ul> <li> <p>When <code>ACTIVATED</code>, the streaming session is scheduled for termination after being in the <code>STOPPED</code> state for the time specified in <code>maxStoppedSessionLengthInMinutes</code>.</p> </li> <li> <p>When <code>DEACTIVATED</code>, the streaming session can remain in the <code>STOPPED</code> state indefinitely.</p> </li> </ul> <p>This parameter is only allowed when <code>sessionPersistenceMode</code> is <code>ACTIVATED</code>. When allowed, the default value for this parameter is <code>DEACTIVATED</code>.</p>', 'StreamConfigurationCreate$automaticTerminationMode' => '<p>Indicates if a streaming session created from this launch profile should be terminated automatically or retained without termination after being in a <code>STOPPED</code> state.</p> <ul> <li> <p>When <code>ACTIVATED</code>, the streaming session is scheduled for termination after being in the <code>STOPPED</code> state for the time specified in <code>maxStoppedSessionLengthInMinutes</code>.</p> </li> <li> <p>When <code>DEACTIVATED</code>, the streaming session can remain in the <code>STOPPED</code> state indefinitely.</p> </li> </ul> <p>This parameter is only allowed when <code>sessionPersistenceMode</code> is <code>ACTIVATED</code>. When allowed, the default value for this parameter is <code>DEACTIVATED</code>.</p>', 'StreamingSession$automaticTerminationMode' => '<p>Indicates if a streaming session created from this launch profile should be terminated automatically or retained without termination after being in a <code>STOPPED</code> state.</p> <ul> <li> <p>When <code>ACTIVATED</code>, the streaming session is scheduled for termination after being in the <code>STOPPED</code> state for the time specified in <code>maxStoppedSessionLengthInMinutes</code>.</p> </li> <li> <p>When <code>DEACTIVATED</code>, the streaming session can remain in the <code>STOPPED</code> state indefinitely.</p> </li> </ul> <p>This parameter is only allowed when <code>sessionPersistenceMode</code> is <code>ACTIVATED</code>. When allowed, the default value for this parameter is <code>DEACTIVATED</code>.</p>', ], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'AcceptEulasRequest$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the Amazon Web Services SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>', 'CreateLaunchProfileRequest$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the Amazon Web Services SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>', 'CreateStreamingImageRequest$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the Amazon Web Services SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>', 'CreateStreamingSessionRequest$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the Amazon Web Services SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>', 'CreateStreamingSessionStreamRequest$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the Amazon Web Services SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>', 'CreateStudioComponentRequest$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the Amazon Web Services SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>', 'CreateStudioRequest$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the Amazon Web Services SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>', 'DeleteLaunchProfileMemberRequest$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the Amazon Web Services SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>', 'DeleteLaunchProfileRequest$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the Amazon Web Services SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>', 'DeleteStreamingImageRequest$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the Amazon Web Services SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>', 'DeleteStreamingSessionRequest$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the Amazon Web Services SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>', 'DeleteStudioComponentRequest$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the Amazon Web Services SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>', 'DeleteStudioMemberRequest$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the Amazon Web Services SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>', 'DeleteStudioRequest$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the Amazon Web Services SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>', 'PutLaunchProfileMembersRequest$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the Amazon Web Services SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>', 'PutStudioMembersRequest$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the Amazon Web Services SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>', 'StartStreamingSessionRequest$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the Amazon Web Services SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>', 'StartStudioSSOConfigurationRepairRequest$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the Amazon Web Services SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>', 'StopStreamingSessionRequest$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the Amazon Web Services SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>', 'UpdateLaunchProfileMemberRequest$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the Amazon Web Services SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>', 'UpdateLaunchProfileRequest$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the Amazon Web Services SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>', 'UpdateStreamingImageRequest$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the Amazon Web Services SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>', 'UpdateStudioComponentRequest$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the Amazon Web Services SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>', 'UpdateStudioRequest$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the Amazon Web Services SDK automatically generates a client token and uses it for the request to ensure idempotency.</p>', ], ], 'ComputeFarmConfiguration' => [ 'base' => '<p>The configuration for a render farm that is associated with a studio resource.</p>', 'refs' => [ 'StudioComponentConfiguration$computeFarmConfiguration' => '<p>The configuration for a render farm that is associated with a studio resource.</p>', ], ], 'ConflictException' => [ 'base' => '<p>Another operation is in progress. </p>', 'refs' => [], ], 'CreateLaunchProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateLaunchProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateStreamingImageRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateStreamingImageResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateStreamingSessionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateStreamingSessionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateStreamingSessionStreamRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateStreamingSessionStreamResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateStudioComponentRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateStudioComponentResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateStudioRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateStudioResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLaunchProfileMemberRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLaunchProfileMemberResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLaunchProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLaunchProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStreamingImageRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStreamingImageResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStreamingSessionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStreamingSessionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStudioComponentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStudioComponentResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStudioMemberRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStudioMemberResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStudioRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStudioResponse' => [ 'base' => NULL, 'refs' => [], ], 'DirectoryId' => [ 'base' => NULL, 'refs' => [ 'ActiveDirectoryConfiguration$directoryId' => '<p>The directory ID of the Directory Service for Microsoft Active Directory to access using this studio component.</p>', 'LaunchProfileInitializationActiveDirectory$directoryId' => '<p>The directory ID of the Directory Service for Microsoft Active Directory to access using this launch profile.</p>', ], ], 'EC2ImageId' => [ 'base' => NULL, 'refs' => [ 'CreateStreamingImageRequest$ec2ImageId' => '<p>The ID of an EC2 machine image with which to create this streaming image.</p>', 'StreamingImage$ec2ImageId' => '<p>The ID of an EC2 machine image with which to create the streaming image.</p>', ], ], 'EC2SubnetId' => [ 'base' => NULL, 'refs' => [ 'EC2SubnetIdList$member' => NULL, ], ], 'EC2SubnetIdList' => [ 'base' => NULL, 'refs' => [ 'CreateLaunchProfileRequest$ec2SubnetIds' => '<p>Specifies the IDs of the EC2 subnets where streaming sessions will be accessible from. These subnets must support the specified instance types. </p>', 'LaunchProfile$ec2SubnetIds' => '<p>Unique identifiers for a collection of EC2 subnets.</p>', ], ], 'Eula' => [ 'base' => '<p>Represents a EULA resource.</p>', 'refs' => [ 'EulaList$member' => NULL, 'GetEulaResponse$eula' => '<p>The EULA.</p>', ], ], 'EulaAcceptance' => [ 'base' => '<p>The acceptance of a EULA, required to use Amazon-provided streaming images.</p>', 'refs' => [ 'EulaAcceptanceList$member' => NULL, ], ], 'EulaAcceptanceId' => [ 'base' => '<p>The EULA acceptance ID.</p>', 'refs' => [ 'EulaAcceptance$eulaAcceptanceId' => '<p>The EULA acceptance ID.</p>', ], ], 'EulaAcceptanceList' => [ 'base' => NULL, 'refs' => [ 'AcceptEulasResponse$eulaAcceptances' => '<p>A collection of EULA acceptances.</p>', 'ListEulaAcceptancesResponse$eulaAcceptances' => '<p>A collection of EULA acceptances.</p>', ], ], 'EulaId' => [ 'base' => '<p>Represents a EULA resource.</p>', 'refs' => [ 'Eula$eulaId' => '<p>The EULA ID.</p>', 'EulaAcceptance$eulaId' => '<p>The EULA ID.</p>', ], ], 'EulaIdList' => [ 'base' => NULL, 'refs' => [ 'AcceptEulasRequest$eulaIds' => '<p>The EULA ID.</p>', 'StreamingImage$eulaIds' => '<p>The list of EULAs that must be accepted before a Streaming Session can be started using this streaming image.</p>', ], ], 'EulaList' => [ 'base' => NULL, 'refs' => [ 'ListEulasResponse$eulas' => '<p>A collection of EULA resources.</p>', ], ], 'EulaName' => [ 'base' => NULL, 'refs' => [ 'Eula$name' => '<p>The name for the EULA.</p>', ], ], 'ExceptionContext' => [ 'base' => '<p>ExceptionContext is a set of key-value pairs that provide you with more information about the error that occurred. For example, when the service returns a 404 ResourceNotFound error, ExceptionContext will contain the key `resourceId` with the value of resource that was not found.</p> <p> <code>ExceptionContext</code> allows scripts and other programmatic clients to provide better error handling.</p>', 'refs' => [ 'AccessDeniedException$context' => '<p>The exception context.</p>', 'ConflictException$context' => '<p>The exception context.</p>', 'InternalServerErrorException$context' => '<p>The exception context.</p>', 'ResourceNotFoundException$context' => '<p>The exception context.</p>', 'ServiceQuotaExceededException$context' => '<p>The exception context.</p>', 'ThrottlingException$context' => '<p>The exception context.</p>', 'ValidationException$context' => '<p>The exception context.</p>', ], ], 'GetEulaRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetEulaResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetLaunchProfileDetailsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetLaunchProfileDetailsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetLaunchProfileInitializationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetLaunchProfileInitializationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetLaunchProfileMemberRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetLaunchProfileMemberResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetLaunchProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetLaunchProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetStreamingImageRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetStreamingImageResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetStreamingSessionBackupRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetStreamingSessionBackupResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetStreamingSessionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetStreamingSessionResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetStreamingSessionStreamRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetStreamingSessionStreamResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetStudioComponentRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetStudioComponentResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetStudioMemberRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetStudioMemberResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetStudioRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetStudioResponse' => [ 'base' => NULL, 'refs' => [], ], 'InternalServerErrorException' => [ 'base' => '<p>An internal error has occurred. Please retry your request.</p>', 'refs' => [], ], 'LaunchProfile' => [ 'base' => '<p>A launch profile controls your artist workforce’s access to studio components, like compute farms, shared file systems, managed file systems, and license server configurations, as well as instance types and Amazon Machine Images (AMIs). </p> <p>Studio administrators create launch profiles in the Nimble Studio console. Artists can use their launch profiles to launch an instance from the Nimble Studio portal. Each user’s launch profile defines how they can launch a streaming session. By default, studio admins can use all launch profiles.</p>', 'refs' => [ 'CreateLaunchProfileResponse$launchProfile' => '<p>The launch profile.</p>', 'DeleteLaunchProfileResponse$launchProfile' => '<p>The launch profile.</p>', 'GetLaunchProfileDetailsResponse$launchProfile' => '<p>The launch profile.</p>', 'GetLaunchProfileResponse$launchProfile' => '<p>The launch profile.</p>', 'LaunchProfileList$member' => NULL, 'UpdateLaunchProfileResponse$launchProfile' => '<p>The launch profile.</p>', ], ], 'LaunchProfileDescription' => [ 'base' => '<p>A human-readable description of the launch profile.</p>', 'refs' => [ 'CreateLaunchProfileRequest$description' => '<p>The description.</p>', 'LaunchProfile$description' => '<p>A human-readable description of the launch profile.</p>', 'UpdateLaunchProfileRequest$description' => '<p>The description.</p>', ], ], 'LaunchProfileId' => [ 'base' => NULL, 'refs' => [ 'LaunchProfile$launchProfileId' => '<p>The ID of the launch profile used to control access from the streaming session.</p>', 'LaunchProfileInitialization$launchProfileId' => '<p>The ID of the launch profile used to control access from the streaming session.</p>', ], ], 'LaunchProfileInitialization' => [ 'base' => '<p>A launch profile initialization contains information required for a workstation or server to connect to a launch profile.</p> <p>This includes scripts, endpoints, security groups, subnets, and other configuration.</p>', 'refs' => [ 'GetLaunchProfileInitializationResponse$launchProfileInitialization' => '<p>The launch profile initialization.</p>', ], ], 'LaunchProfileInitializationActiveDirectory' => [ 'base' => '<p>The launch profile initialization Active Directory contains information required for the launch profile to connect to the Active Directory.</p>', 'refs' => [ 'LaunchProfileInitialization$activeDirectory' => '<p>A <code>LaunchProfileInitializationActiveDirectory</code> resource.</p>', ], ], 'LaunchProfileInitializationScript' => [ 'base' => '<p>The launch profile initialization script is used when start streaming session runs.</p>', 'refs' => [ 'LaunchProfileInitializationScriptList$member' => NULL, ], ], 'LaunchProfileInitializationScriptList' => [ 'base' => NULL, 'refs' => [ 'LaunchProfileInitialization$systemInitializationScripts' => '<p>The system initializtion scripts.</p>', 'LaunchProfileInitialization$userInitializationScripts' => '<p>The user initializtion scripts.</p>', ], ], 'LaunchProfileList' => [ 'base' => NULL, 'refs' => [ 'ListLaunchProfilesResponse$launchProfiles' => '<p>A collection of launch profiles.</p>', ], ], 'LaunchProfileMembership' => [ 'base' => '<p>Studio admins can use launch profile membership to delegate launch profile access to studio users in the Nimble Studio portal without writing or maintaining complex IAM policies. A launch profile member is a user association from your studio identity source who is granted permissions to a launch profile.</p> <p>A launch profile member (type USER) provides the following permissions to that launch profile:</p> <ul> <li> <p>GetLaunchProfile</p> </li> <li> <p>GetLaunchProfileInitialization</p> </li> <li> <p>GetLaunchProfileMembers</p> </li> <li> <p>GetLaunchProfileMember</p> </li> <li> <p>CreateStreamingSession</p> </li> <li> <p>GetLaunchProfileDetails</p> </li> </ul>', 'refs' => [ 'GetLaunchProfileMemberResponse$member' => '<p>The member.</p>', 'LaunchProfileMembershipList$member' => NULL, 'UpdateLaunchProfileMemberResponse$member' => '<p>The updated member. </p>', ], ], 'LaunchProfileMembershipList' => [ 'base' => NULL, 'refs' => [ 'ListLaunchProfileMembersResponse$members' => '<p>A list of members.</p>', ], ], 'LaunchProfileName' => [ 'base' => NULL, 'refs' => [ 'CreateLaunchProfileRequest$name' => '<p>The name for the launch profile.</p>', 'LaunchProfile$name' => '<p>A friendly name for the launch profile.</p>', 'LaunchProfileInitialization$name' => '<p>The name for the launch profile.</p>', 'UpdateLaunchProfileRequest$name' => '<p>The name for the launch profile.</p>', ], ], 'LaunchProfilePersona' => [ 'base' => NULL, 'refs' => [ 'LaunchProfileMembership$persona' => '<p>The persona.</p>', 'NewLaunchProfileMember$persona' => '<p>The persona.</p>', 'UpdateLaunchProfileMemberRequest$persona' => '<p>The persona.</p>', ], ], 'LaunchProfilePlatform' => [ 'base' => NULL, 'refs' => [ 'LaunchProfileInitialization$platform' => '<p>The platform of the launch platform, either Windows or Linux.</p>', 'StudioComponentInitializationScript$platform' => '<p>The platform of the initialization script, either Windows or Linux.</p>', ], ], 'LaunchProfileProtocolVersion' => [ 'base' => '<p>The version number of the protocol that is used by the launch profile. The only valid version is "2021-03-31".</p>', 'refs' => [ 'LaunchProfileInitialization$launchProfileProtocolVersion' => '<p>The version number of the protocol that is used by the launch profile. The only valid version is "2021-03-31".</p>', 'LaunchProfileProtocolVersionList$member' => NULL, 'StudioComponentInitializationScript$launchProfileProtocolVersion' => '<p>The version number of the protocol that is used by the launch profile. The only valid version is "2021-03-31".</p>', ], ], 'LaunchProfileProtocolVersionList' => [ 'base' => NULL, 'refs' => [ 'CreateLaunchProfileRequest$launchProfileProtocolVersions' => '<p>The version number of the protocol that is used by the launch profile. The only valid version is "2021-03-31".</p>', 'LaunchProfile$launchProfileProtocolVersions' => '<p>The version number of the protocol that is used by the launch profile. The only valid version is "2021-03-31".</p>', 'UpdateLaunchProfileRequest$launchProfileProtocolVersions' => '<p>The version number of the protocol that is used by the launch profile. The only valid version is "2021-03-31".</p>', ], ], 'LaunchProfileSecurityGroupIdList' => [ 'base' => NULL, 'refs' => [ 'LaunchProfileInitialization$ec2SecurityGroupIds' => '<p>The EC2 security groups that control access to the studio component.</p>', ], ], 'LaunchProfileState' => [ 'base' => NULL, 'refs' => [ 'LaunchProfile$state' => '<p>The current state.</p>', 'LaunchProfileStateList$member' => NULL, ], ], 'LaunchProfileStateList' => [ 'base' => NULL, 'refs' => [ 'ListLaunchProfilesRequest$states' => '<p>Filter this request to launch profiles in any of the given states.</p>', ], ], 'LaunchProfileStatusCode' => [ 'base' => NULL, 'refs' => [ 'LaunchProfile$statusCode' => '<p>The status code.</p>', ], ], 'LaunchProfileStudioComponentIdList' => [ 'base' => NULL, 'refs' => [ 'CreateLaunchProfileRequest$studioComponentIds' => '<p>Unique identifiers for a collection of studio components that can be used with this launch profile.</p>', 'LaunchProfile$studioComponentIds' => '<p>Unique identifiers for a collection of studio components that can be used with this launch profile.</p>', 'UpdateLaunchProfileRequest$studioComponentIds' => '<p>Unique identifiers for a collection of studio components that can be used with this launch profile.</p>', ], ], 'LaunchProfileValidationState' => [ 'base' => NULL, 'refs' => [ 'ValidationResult$state' => '<p>The current state.</p>', ], ], 'LaunchProfileValidationStatusCode' => [ 'base' => NULL, 'refs' => [ 'ValidationResult$statusCode' => '<p>The status code. This will contain the failure reason if the state is <code>VALIDATION_FAILED</code>.</p>', ], ], 'LaunchProfileValidationStatusMessage' => [ 'base' => NULL, 'refs' => [ 'ValidationResult$statusMessage' => '<p>The status message for the validation result.</p>', ], ], 'LaunchProfileValidationType' => [ 'base' => NULL, 'refs' => [ 'ValidationResult$type' => '<p>The type of the validation result.</p>', ], ], 'LaunchPurpose' => [ 'base' => '<p>The launch purpose.</p>', 'refs' => [ 'LaunchProfileInitialization$launchPurpose' => '<p>The launch purpose.</p>', ], ], 'LicenseServiceConfiguration' => [ 'base' => '<p>The configuration for a license service that is associated with a studio resource.</p>', 'refs' => [ 'StudioComponentConfiguration$licenseServiceConfiguration' => '<p>The configuration for a license service that is associated with a studio resource.</p>', ], ], 'LinuxMountPoint' => [ 'base' => NULL, 'refs' => [ 'SharedFileSystemConfiguration$linuxMountPoint' => '<p>The mount location for a shared file system on a Linux virtual workstation.</p>', ], ], 'ListEulaAcceptancesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListEulaAcceptancesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListEulasRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListEulasResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListLaunchProfileMembersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListLaunchProfileMembersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListLaunchProfilesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListLaunchProfilesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListStreamingImagesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListStreamingImagesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListStreamingSessionBackupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListStreamingSessionBackupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListStreamingSessionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListStreamingSessionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListStudioComponentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListStudioComponentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListStudioMembersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListStudioMembersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListStudiosRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListStudiosResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListLaunchProfileMembersRequest$maxResults' => '<p>The max number of results to return in the response.</p>', 'ListLaunchProfilesRequest$maxResults' => '<p>The max number of results to return in the response.</p>', 'ListStudioComponentsRequest$maxResults' => '<p>The max number of results to return in the response.</p>', 'ListStudioMembersRequest$maxResults' => '<p>The max number of results to return in the response.</p>', ], ], 'NewLaunchProfileMember' => [ 'base' => '<p>A new member that is added to a launch profile.</p>', 'refs' => [ 'NewLaunchProfileMemberList$member' => NULL, ], ], 'NewLaunchProfileMemberList' => [ 'base' => NULL, 'refs' => [ 'PutLaunchProfileMembersRequest$members' => '<p>A list of members.</p>', ], ], 'NewStudioMember' => [ 'base' => '<p>A new studio user\'s membership.</p>', 'refs' => [ 'NewStudioMemberList$member' => NULL, ], ], 'NewStudioMemberList' => [ 'base' => NULL, 'refs' => [ 'PutStudioMembersRequest$members' => '<p>A list of members.</p>', ], ], 'PutLaunchProfileMembersRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutLaunchProfileMembersResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutStudioMembersRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutStudioMembersResponse' => [ 'base' => NULL, 'refs' => [], ], 'Region' => [ 'base' => NULL, 'refs' => [ 'Studio$homeRegion' => '<p>The Amazon Web Services Region where the studio resource is located.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The specified resource could not be found.</p>', 'refs' => [], ], 'RoleArn' => [ 'base' => NULL, 'refs' => [ 'CreateStudioComponentRequest$runtimeRoleArn' => '<p>An IAM role attached to a Studio Component that gives the studio component access to Amazon Web Services resources at anytime while the instance is running. </p>', 'CreateStudioComponentRequest$secureInitializationRoleArn' => '<p>An IAM role attached to Studio Component when the system initialization script runs which give the studio component access to Amazon Web Services resources when the system initialization script runs.</p>', 'CreateStudioRequest$adminRoleArn' => '<p>The IAM role that studio admins will assume when logging in to the Nimble Studio portal.</p>', 'CreateStudioRequest$userRoleArn' => '<p>The IAM role that studio users will assume when logging in to the Nimble Studio portal.</p>', 'LaunchProfileInitializationScript$runtimeRoleArn' => '<p>An IAM role attached to a Studio Component that gives the studio component access to Amazon Web Services resources at anytime while the instance is running. </p>', 'LaunchProfileInitializationScript$secureInitializationRoleArn' => '<p>An IAM role attached to Studio Component when the system initialization script runs which give the studio component access to Amazon Web Services resources when the system initialization script runs.</p>', 'Studio$adminRoleArn' => '<p>The IAM role that studio admins assume when logging in to the Nimble Studio portal.</p>', 'Studio$userRoleArn' => '<p>The IAM role that studio users assume when logging in to the Nimble Studio portal.</p>', 'StudioComponent$runtimeRoleArn' => '<p>An IAM role attached to a Studio Component that gives the studio component access to Amazon Web Services resources at anytime while the instance is running. </p>', 'StudioComponent$secureInitializationRoleArn' => '<p>An IAM role attached to Studio Component when the system initialization script runs which give the studio component access to Amazon Web Services resources when the system initialization script runs.</p>', 'UpdateStudioComponentRequest$runtimeRoleArn' => '<p>An IAM role attached to a Studio Component that gives the studio component access to Amazon Web Services resources at anytime while the instance is running. </p>', 'UpdateStudioComponentRequest$secureInitializationRoleArn' => '<p>An IAM role attached to Studio Component when the system initialization script runs which give the studio component access to Amazon Web Services resources when the system initialization script runs.</p>', 'UpdateStudioRequest$adminRoleArn' => '<p>The IAM role that Studio Admins will assume when logging in to the Nimble Studio portal.</p>', 'UpdateStudioRequest$userRoleArn' => '<p>The IAM role that Studio Users will assume when logging in to the Nimble Studio portal.</p>', ], ], 'ScriptParameterKey' => [ 'base' => '<p>A script parameter key.</p>', 'refs' => [ 'ScriptParameterKeyValue$key' => '<p>A script parameter key.</p>', ], ], 'ScriptParameterKeyValue' => [ 'base' => '<p>A parameter for a studio component script, in the form of a key-value pair.</p>', 'refs' => [ 'StudioComponentScriptParameterKeyValueList$member' => NULL, ], ], 'ScriptParameterValue' => [ 'base' => '<p>A script parameter value.</p>', 'refs' => [ 'ScriptParameterKeyValue$value' => '<p>A script parameter value.</p>', ], ], 'SecurityGroupId' => [ 'base' => NULL, 'refs' => [ 'LaunchProfileSecurityGroupIdList$member' => NULL, 'StudioComponentSecurityGroupIdList$member' => NULL, ], ], 'SensitiveString' => [ 'base' => NULL, 'refs' => [ 'ComputeFarmConfiguration$endpoint' => '<p>The endpoint of the ComputeFarm that is accessed by the studio component resource.</p>', 'LicenseServiceConfiguration$endpoint' => '<p>The endpoint of the license service that is accessed by the studio component resource.</p>', 'SharedFileSystemConfiguration$endpoint' => '<p>The endpoint of the shared file system that is accessed by the studio component resource.</p>', 'SharedFileSystemConfiguration$shareName' => '<p>The name of the file share.</p>', 'StreamingSessionStream$url' => '<p>The URL to connect to this stream using the DCV client.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>Your current quota does not allow you to perform the request action. You can request increases for some quotas, and other quotas cannot be increased.</p> <p>Please use Amazon Web Services Service Quotas to request an increase. </p>', 'refs' => [], ], 'SessionBackupMode' => [ 'base' => NULL, 'refs' => [ 'StreamConfigurationSessionBackup$mode' => '<p>Specifies how artists sessions are backed up.</p> <p>Configures backups for streaming sessions launched with this launch profile. The default value is <code>DEACTIVATED</code>, which means that backups are deactivated. To allow backups, set this value to <code>AUTOMATIC</code>.</p>', 'StreamingSession$backupMode' => '<p>Shows the current backup setting of the session.</p>', ], ], 'SessionPersistenceMode' => [ 'base' => NULL, 'refs' => [ 'StreamConfiguration$sessionPersistenceMode' => '<p>Determine if a streaming session created from this launch profile can configure persistent storage. This means that <code>volumeConfiguration</code> and <code>automaticTerminationMode</code> are configured.</p>', 'StreamConfigurationCreate$sessionPersistenceMode' => '<p>Determine if a streaming session created from this launch profile can configure persistent storage. This means that <code>volumeConfiguration</code> and <code>automaticTerminationMode</code> are configured.</p>', 'StreamingSession$sessionPersistenceMode' => '<p>Determine if a streaming session created from this launch profile can configure persistent storage. This means that <code>volumeConfiguration</code> and <code>automaticTerminationMode</code> are configured.</p>', ], ], 'SharedFileSystemConfiguration' => [ 'base' => '<p>The configuration for a shared file storage system that is associated with a studio resource.</p>', 'refs' => [ 'StudioComponentConfiguration$sharedFileSystemConfiguration' => '<p>The configuration for a shared file storage system that is associated with a studio resource.</p>', ], ], 'StartStreamingSessionRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartStreamingSessionResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartStudioSSOConfigurationRepairRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartStudioSSOConfigurationRepairResponse' => [ 'base' => NULL, 'refs' => [], ], 'StopStreamingSessionRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopStreamingSessionResponse' => [ 'base' => NULL, 'refs' => [], ], 'StreamConfiguration' => [ 'base' => '<p>A configuration for a streaming session.</p>', 'refs' => [ 'LaunchProfile$streamConfiguration' => '<p>A configuration for a streaming session.</p>', ], ], 'StreamConfigurationCreate' => [ 'base' => '<p>Configuration for streaming workstations created using this launch profile.</p>', 'refs' => [ 'CreateLaunchProfileRequest$streamConfiguration' => '<p>A configuration for a streaming session.</p>', 'UpdateLaunchProfileRequest$streamConfiguration' => '<p>A configuration for a streaming session.</p>', ], ], 'StreamConfigurationMaxBackupsToRetain' => [ 'base' => NULL, 'refs' => [ 'StreamConfigurationSessionBackup$maxBackupsToRetain' => '<p>The maximum number of backups that each streaming session created from this launch profile can have.</p>', 'StreamingSession$maxBackupsToRetain' => '<p>The maximum number of backups of a streaming session that you can have. When the maximum number of backups is reached, the oldest backup is deleted.</p>', ], ], 'StreamConfigurationMaxSessionLengthInMinutes' => [ 'base' => NULL, 'refs' => [ 'StreamConfiguration$maxSessionLengthInMinutes' => '<p>The length of time, in minutes, that a streaming session can be active before it is stopped or terminated. After this point, Nimble Studio automatically terminates or stops the session. The default length of time is 690 minutes, and the maximum length of time is 30 days.</p>', 'StreamConfigurationCreate$maxSessionLengthInMinutes' => '<p>The length of time, in minutes, that a streaming session can be active before it is stopped or terminated. After this point, Nimble Studio automatically terminates or stops the session. The default length of time is 690 minutes, and the maximum length of time is 30 days.</p>', ], ], 'StreamConfigurationMaxStoppedSessionLengthInMinutes' => [ 'base' => NULL, 'refs' => [ 'StreamConfiguration$maxStoppedSessionLengthInMinutes' => '<p>Integer that determines if you can start and stop your sessions and how long a session can stay in the <code>STOPPED</code> state. The default value is 0. The maximum value is 5760.</p> <p>This field is allowed only when <code>sessionPersistenceMode</code> is <code>ACTIVATED</code> and <code>automaticTerminationMode</code> is <code>ACTIVATED</code>.</p> <p>If the value is set to 0, your sessions can’t be <code>STOPPED</code>. If you then call <code>StopStreamingSession</code>, the session fails. If the time that a session stays in the <code>READY</code> state exceeds the <code>maxSessionLengthInMinutes</code> value, the session will automatically be terminated (instead of <code>STOPPED</code>).</p> <p>If the value is set to a positive number, the session can be stopped. You can call <code>StopStreamingSession</code> to stop sessions in the <code>READY</code> state. If the time that a session stays in the <code>READY</code> state exceeds the <code>maxSessionLengthInMinutes</code> value, the session will automatically be stopped (instead of terminated).</p>', 'StreamConfigurationCreate$maxStoppedSessionLengthInMinutes' => '<p>Integer that determines if you can start and stop your sessions and how long a session can stay in the <code>STOPPED</code> state. The default value is 0. The maximum value is 5760.</p> <p>This field is allowed only when <code>sessionPersistenceMode</code> is <code>ACTIVATED</code> and <code>automaticTerminationMode</code> is <code>ACTIVATED</code>.</p> <p>If the value is set to 0, your sessions can’t be <code>STOPPED</code>. If you then call <code>StopStreamingSession</code>, the session fails. If the time that a session stays in the <code>READY</code> state exceeds the <code>maxSessionLengthInMinutes</code> value, the session will automatically be terminated (instead of <code>STOPPED</code>).</p> <p>If the value is set to a positive number, the session can be stopped. You can call <code>StopStreamingSession</code> to stop sessions in the <code>READY</code> state. If the time that a session stays in the <code>READY</code> state exceeds the <code>maxSessionLengthInMinutes</code> value, the session will automatically be stopped (instead of terminated).</p>', ], ], 'StreamConfigurationSessionBackup' => [ 'base' => '<p>Configures how streaming sessions are backed up when launched from this launch profile.</p>', 'refs' => [ 'StreamConfiguration$sessionBackup' => '<p>Information about the streaming session backup.</p>', 'StreamConfigurationCreate$sessionBackup' => '<p>Configures how streaming sessions are backed up when launched from this launch profile.</p>', ], ], 'StreamConfigurationSessionStorage' => [ 'base' => '<p>The configuration for a streaming session’s upload storage.</p>', 'refs' => [ 'StreamConfiguration$sessionStorage' => '<p>The upload storage for a streaming session.</p>', 'StreamConfigurationCreate$sessionStorage' => '<p>The upload storage for a streaming workstation that is created using this launch profile.</p>', ], ], 'StreamingClipboardMode' => [ 'base' => NULL, 'refs' => [ 'StreamConfiguration$clipboardMode' => '<p>Allows or deactivates the use of the system clipboard to copy and paste between the streaming session and streaming client.</p>', 'StreamConfigurationCreate$clipboardMode' => '<p>Allows or deactivates the use of the system clipboard to copy and paste between the streaming session and streaming client.</p>', ], ], 'StreamingImage' => [ 'base' => '<p>Represents a streaming image resource.</p> <p>Streaming images are used by studio users to select which operating system and software they want to use in a Nimble Studio streaming session.</p> <p>Amazon provides a number of streaming images that include popular 3rd-party software.</p> <p>You can create your own streaming images using an Amazon EC2 machine image that you create for this purpose. You can also include software that your users require.</p>', 'refs' => [ 'CreateStreamingImageResponse$streamingImage' => '<p>The streaming image.</p>', 'DeleteStreamingImageResponse$streamingImage' => '<p>The streaming image.</p>', 'GetStreamingImageResponse$streamingImage' => '<p>The streaming image.</p>', 'StreamingImageList$member' => NULL, 'UpdateStreamingImageResponse$streamingImage' => NULL, ], ], 'StreamingImageDescription' => [ 'base' => '<p>The description.</p>', 'refs' => [ 'CreateStreamingImageRequest$description' => '<p>A human-readable description of the streaming image.</p>', 'StreamingImage$description' => '<p>A human-readable description of the streaming image.</p>', 'UpdateStreamingImageRequest$description' => '<p>The description.</p>', ], ], 'StreamingImageEncryptionConfiguration' => [ 'base' => '<p>Specifies how a streaming image is encrypted.</p>', 'refs' => [ 'StreamingImage$encryptionConfiguration' => '<p>The encryption configuration.</p>', ], ], 'StreamingImageEncryptionConfigurationKeyArn' => [ 'base' => NULL, 'refs' => [ 'StreamingImageEncryptionConfiguration$keyArn' => '<p>The ARN for a KMS key that is used to encrypt studio data.</p>', ], ], 'StreamingImageEncryptionConfigurationKeyType' => [ 'base' => NULL, 'refs' => [ 'StreamingImageEncryptionConfiguration$keyType' => '<p>The type of KMS key that is used to encrypt studio data.</p>', ], ], 'StreamingImageId' => [ 'base' => NULL, 'refs' => [ 'CreateStreamingSessionRequest$streamingImageId' => '<p>The ID of the streaming image.</p>', 'StreamingImage$streamingImageId' => '<p>The ID of the streaming image.</p>', 'StreamingImageIdList$member' => NULL, 'StreamingSession$streamingImageId' => '<p>The ID of the streaming image.</p>', ], ], 'StreamingImageIdList' => [ 'base' => '<p>A list of streaming image IDs that users can select from when launching a streaming session with this launch profile.</p>', 'refs' => [ 'StreamConfiguration$streamingImageIds' => '<p>The streaming images that users can select from when launching a streaming session with this launch profile.</p>', 'StreamConfigurationCreate$streamingImageIds' => '<p>The streaming images that users can select from when launching a streaming session with this launch profile.</p>', ], ], 'StreamingImageList' => [ 'base' => NULL, 'refs' => [ 'GetLaunchProfileDetailsResponse$streamingImages' => '<p>A collection of streaming images.</p>', 'ListStreamingImagesResponse$streamingImages' => '<p>A collection of streaming images.</p>', ], ], 'StreamingImageName' => [ 'base' => '<p>A friendly name for a streaming image resource.</p>', 'refs' => [ 'CreateStreamingImageRequest$name' => '<p>A friendly name for a streaming image resource.</p>', 'StreamingImage$name' => '<p>A friendly name for a streaming image resource.</p>', 'UpdateStreamingImageRequest$name' => '<p>The name for the streaming image.</p>', ], ], 'StreamingImageOwner' => [ 'base' => '<p>StreamingImageOwner is the owner of a particular streaming image.</p> <p>This string is either the studioId that contains the streaming image, or the word <code>AMAZON</code> for images provided by Nimble Studio.</p>', 'refs' => [ 'StreamingImage$owner' => '<p>The owner of the streaming image, either the <code>studioId</code> that contains the streaming image, or <code>amazon</code> for images that are provided by Amazon Nimble Studio.</p>', ], ], 'StreamingImagePlatform' => [ 'base' => '<p>The platform of this streaming image, either Windows or Linux.</p>', 'refs' => [ 'StreamingImage$platform' => '<p>The platform of the streaming image, either Windows or Linux.</p>', ], ], 'StreamingImageState' => [ 'base' => NULL, 'refs' => [ 'StreamingImage$state' => '<p>The current state.</p>', ], ], 'StreamingImageStatusCode' => [ 'base' => '<p>The status code.</p>', 'refs' => [ 'StreamingImage$statusCode' => '<p>The status code.</p>', ], ], 'StreamingInstanceType' => [ 'base' => NULL, 'refs' => [ 'CreateStreamingSessionRequest$ec2InstanceType' => '<p>The EC2 Instance type used for the streaming session.</p>', 'StreamingInstanceTypeList$member' => NULL, ], ], 'StreamingInstanceTypeList' => [ 'base' => '<p>The EC2 instance types that users can select from when launching a streaming session with this launch profile.</p>', 'refs' => [ 'StreamConfiguration$ec2InstanceTypes' => '<p>The EC2 instance types that users can select from when launching a streaming session with this launch profile.</p>', 'StreamConfigurationCreate$ec2InstanceTypes' => '<p>The EC2 instance types that users can select from when launching a streaming session with this launch profile.</p>', ], ], 'StreamingSession' => [ 'base' => '<p>A streaming session is a virtual workstation created using a particular launch profile.</p>', 'refs' => [ 'CreateStreamingSessionResponse$session' => '<p>The session.</p>', 'DeleteStreamingSessionResponse$session' => '<p>The session.</p>', 'GetStreamingSessionResponse$session' => '<p>The session.</p>', 'StartStreamingSessionResponse$session' => NULL, 'StopStreamingSessionResponse$session' => NULL, 'StreamingSessionList$member' => NULL, ], ], 'StreamingSessionBackup' => [ 'base' => '<p>Information about the streaming session backup.</p>', 'refs' => [ 'GetStreamingSessionBackupResponse$streamingSessionBackup' => '<p>Information about the streaming session backup.</p>', 'StreamingSessionBackupList$member' => NULL, ], ], 'StreamingSessionBackupList' => [ 'base' => NULL, 'refs' => [ 'ListStreamingSessionBackupsResponse$streamingSessionBackups' => '<p>Information about the streaming session backups.</p>', ], ], 'StreamingSessionId' => [ 'base' => NULL, 'refs' => [ 'StreamingSession$sessionId' => '<p>The session ID.</p>', 'StreamingSessionBackup$sessionId' => '<p>The streaming session ID for the <code>StreamingSessionBackup</code>.</p>', ], ], 'StreamingSessionList' => [ 'base' => NULL, 'refs' => [ 'ListStreamingSessionsResponse$sessions' => '<p>A collection of streaming sessions.</p>', ], ], 'StreamingSessionState' => [ 'base' => '<p>The streaming session state.</p>', 'refs' => [ 'StreamingSession$state' => '<p>The current state.</p>', 'StreamingSessionBackup$state' => NULL, ], ], 'StreamingSessionStatusCode' => [ 'base' => NULL, 'refs' => [ 'StreamingSession$statusCode' => '<p>The status code.</p>', 'StreamingSessionBackup$statusCode' => '<p>The status code.</p>', ], ], 'StreamingSessionStorageMode' => [ 'base' => NULL, 'refs' => [ 'StreamingSessionStorageModeList$member' => NULL, ], ], 'StreamingSessionStorageModeList' => [ 'base' => NULL, 'refs' => [ 'StreamConfigurationSessionStorage$mode' => '<p>Allows artists to upload files to their workstations. The only valid option is <code>UPLOAD</code>.</p>', ], ], 'StreamingSessionStorageRoot' => [ 'base' => '<p>The upload storage root location (folder) on streaming workstations where files are uploaded.</p>', 'refs' => [ 'StreamConfigurationSessionStorage$root' => '<p>The configuration for the upload storage root of the streaming session.</p>', ], ], 'StreamingSessionStorageRootPathLinux' => [ 'base' => NULL, 'refs' => [ 'StreamingSessionStorageRoot$linux' => '<p>The folder path in Linux workstations where files are uploaded.</p>', ], ], 'StreamingSessionStorageRootPathWindows' => [ 'base' => NULL, 'refs' => [ 'StreamingSessionStorageRoot$windows' => '<p>The folder path in Windows workstations where files are uploaded.</p>', ], ], 'StreamingSessionStream' => [ 'base' => '<p>A stream is an active connection to a streaming session, enabling a studio user to control the streaming session using a compatible client. Streaming session streams are compatible with the NICE DCV web client, included in the Nimble Studio portal, or the NICE DCV desktop client.</p>', 'refs' => [ 'CreateStreamingSessionStreamResponse$stream' => '<p>The stream.</p>', 'GetStreamingSessionStreamResponse$stream' => '<p>The stream.</p>', ], ], 'StreamingSessionStreamExpirationInSeconds' => [ 'base' => NULL, 'refs' => [ 'CreateStreamingSessionStreamRequest$expirationInSeconds' => '<p>The expiration time in seconds.</p>', ], ], 'StreamingSessionStreamState' => [ 'base' => NULL, 'refs' => [ 'StreamingSessionStream$state' => '<p>The current state.</p>', ], ], 'StreamingSessionStreamStatusCode' => [ 'base' => NULL, 'refs' => [ 'StreamingSessionStream$statusCode' => '<p>The streaming session stream status code.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AcceptEulasRequest$studioId' => '<p>The studio ID.</p>', 'AccessDeniedException$code' => '<p>A more specific error code.</p>', 'AccessDeniedException$message' => '<p>A human-readable description of the error.</p>', 'ComputeFarmConfiguration$activeDirectoryUser' => '<p>The name of an Active Directory user that is used on ComputeFarm worker instances.</p>', 'ConflictException$code' => '<p>A more specific error code.</p>', 'ConflictException$message' => '<p>A human-readable description of the error.</p>', 'CreateLaunchProfileRequest$studioId' => '<p>The studio ID. </p>', 'CreateStreamingImageRequest$studioId' => '<p>The studio ID. </p>', 'CreateStreamingSessionRequest$launchProfileId' => '<p>The ID of the launch profile used to control access from the streaming session.</p>', 'CreateStreamingSessionRequest$ownedBy' => '<p>The user ID of the user that owns the streaming session. The user that owns the session will be logging into the session and interacting with the virtual workstation.</p>', 'CreateStreamingSessionRequest$studioId' => '<p>The studio ID. </p>', 'CreateStreamingSessionStreamRequest$sessionId' => '<p>The streaming session ID.</p>', 'CreateStreamingSessionStreamRequest$studioId' => '<p>The studio ID. </p>', 'CreateStudioComponentRequest$studioId' => '<p>The studio ID. </p>', 'DeleteLaunchProfileMemberRequest$launchProfileId' => '<p>The ID of the launch profile used to control access from the streaming session.</p>', 'DeleteLaunchProfileMemberRequest$principalId' => '<p>The principal ID. This currently supports a IAM Identity Center UserId. </p>', 'DeleteLaunchProfileMemberRequest$studioId' => '<p>The studio ID. </p>', 'DeleteLaunchProfileRequest$launchProfileId' => '<p>The ID of the launch profile used to control access from the streaming session.</p>', 'DeleteLaunchProfileRequest$studioId' => '<p>The studio ID. </p>', 'DeleteStreamingImageRequest$streamingImageId' => '<p>The streaming image ID.</p>', 'DeleteStreamingImageRequest$studioId' => '<p>The studio ID. </p>', 'DeleteStreamingSessionRequest$sessionId' => '<p>The streaming session ID.</p>', 'DeleteStreamingSessionRequest$studioId' => '<p>The studio ID. </p>', 'DeleteStudioComponentRequest$studioComponentId' => '<p>The studio component ID.</p>', 'DeleteStudioComponentRequest$studioId' => '<p>The studio ID. </p>', 'DeleteStudioMemberRequest$principalId' => '<p>The principal ID. This currently supports a IAM Identity Center UserId. </p>', 'DeleteStudioMemberRequest$studioId' => '<p>The studio ID. </p>', 'DeleteStudioRequest$studioId' => '<p>The studio ID. </p>', 'Eula$content' => '<p>The EULA content.</p>', 'EulaAcceptance$acceptedBy' => '<p>The ID of the person who accepted the EULA.</p>', 'EulaAcceptance$accepteeId' => '<p>The ID of the acceptee.</p>', 'EulaIdList$member' => NULL, 'ExceptionContext$key' => NULL, 'ExceptionContext$value' => NULL, 'GetEulaRequest$eulaId' => '<p>The EULA ID.</p>', 'GetLaunchProfileDetailsRequest$launchProfileId' => '<p>The ID of the launch profile used to control access from the streaming session.</p>', 'GetLaunchProfileDetailsRequest$studioId' => '<p>The studio ID. </p>', 'GetLaunchProfileInitializationRequest$launchProfileId' => '<p>The ID of the launch profile used to control access from the streaming session.</p>', 'GetLaunchProfileInitializationRequest$launchPurpose' => '<p>The launch purpose.</p>', 'GetLaunchProfileInitializationRequest$platform' => '<p>The platform where this Launch Profile will be used, either Windows or Linux.</p>', 'GetLaunchProfileInitializationRequest$studioId' => '<p>The studio ID. </p>', 'GetLaunchProfileMemberRequest$launchProfileId' => '<p>The ID of the launch profile used to control access from the streaming session.</p>', 'GetLaunchProfileMemberRequest$principalId' => '<p>The principal ID. This currently supports a IAM Identity Center UserId. </p>', 'GetLaunchProfileMemberRequest$studioId' => '<p>The studio ID. </p>', 'GetLaunchProfileRequest$launchProfileId' => '<p>The ID of the launch profile used to control access from the streaming session.</p>', 'GetLaunchProfileRequest$studioId' => '<p>The studio ID. </p>', 'GetStreamingImageRequest$streamingImageId' => '<p>The streaming image ID.</p>', 'GetStreamingImageRequest$studioId' => '<p>The studio ID. </p>', 'GetStreamingSessionBackupRequest$backupId' => '<p>The ID of the backup.</p>', 'GetStreamingSessionBackupRequest$studioId' => '<p>The studio ID. </p>', 'GetStreamingSessionRequest$sessionId' => '<p>The streaming session ID.</p>', 'GetStreamingSessionRequest$studioId' => '<p>The studio ID. </p>', 'GetStreamingSessionStreamRequest$sessionId' => '<p>The streaming session ID.</p>', 'GetStreamingSessionStreamRequest$streamId' => '<p>The streaming session stream ID.</p>', 'GetStreamingSessionStreamRequest$studioId' => '<p>The studio ID. </p>', 'GetStudioComponentRequest$studioComponentId' => '<p>The studio component ID.</p>', 'GetStudioComponentRequest$studioId' => '<p>The studio ID. </p>', 'GetStudioMemberRequest$principalId' => '<p>The principal ID. This currently supports a IAM Identity Center UserId. </p>', 'GetStudioMemberRequest$studioId' => '<p>The studio ID. </p>', 'GetStudioRequest$studioId' => '<p>The studio ID. </p>', 'InternalServerErrorException$code' => '<p>A more specific error code.</p>', 'InternalServerErrorException$message' => '<p>A human-readable description of the error.</p>', 'LaunchProfile$arn' => '<p>The Amazon Resource Name (ARN) that is assigned to a studio resource and uniquely identifies it. ARNs are unique across all Regions.</p>', 'LaunchProfile$createdBy' => '<p>The user ID of the user that created the launch profile.</p>', 'LaunchProfile$statusMessage' => '<p>The status message for the launch profile.</p>', 'LaunchProfile$updatedBy' => '<p>The user ID of the user that most recently updated the resource.</p>', 'LaunchProfileInitializationActiveDirectory$directoryName' => '<p>The directory name.</p>', 'LaunchProfileMembership$identityStoreId' => '<p>The ID of the identity store.</p>', 'LaunchProfileMembership$principalId' => '<p>The principal ID.</p>', 'LaunchProfileMembership$sid' => '<p>The Active Directory Security Identifier for this user, if available.</p>', 'LaunchProfileStudioComponentIdList$member' => NULL, 'ListEulaAcceptancesRequest$nextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListEulaAcceptancesRequest$studioId' => '<p>The studio ID. </p>', 'ListEulaAcceptancesResponse$nextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListEulasRequest$nextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListEulasResponse$nextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListLaunchProfileMembersRequest$launchProfileId' => '<p>The ID of the launch profile used to control access from the streaming session.</p>', 'ListLaunchProfileMembersRequest$nextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListLaunchProfileMembersRequest$studioId' => '<p>The studio ID. </p>', 'ListLaunchProfileMembersResponse$nextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListLaunchProfilesRequest$nextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListLaunchProfilesRequest$principalId' => '<p>The principal ID. This currently supports a IAM Identity Center UserId. </p>', 'ListLaunchProfilesRequest$studioId' => '<p>The studio ID. </p>', 'ListLaunchProfilesResponse$nextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListStreamingImagesRequest$nextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListStreamingImagesRequest$owner' => '<p>Filter this request to streaming images with the given owner</p>', 'ListStreamingImagesRequest$studioId' => '<p>The studio ID. </p>', 'ListStreamingImagesResponse$nextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListStreamingSessionBackupsRequest$nextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListStreamingSessionBackupsRequest$ownedBy' => '<p>The user ID of the user that owns the streaming session.</p>', 'ListStreamingSessionBackupsRequest$studioId' => '<p>The studio ID. </p>', 'ListStreamingSessionBackupsResponse$nextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListStreamingSessionsRequest$createdBy' => '<p>Filters the request to streaming sessions created by the given user.</p>', 'ListStreamingSessionsRequest$nextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListStreamingSessionsRequest$ownedBy' => '<p>Filters the request to streaming session owned by the given user</p>', 'ListStreamingSessionsRequest$sessionIds' => '<p>Filters the request to only the provided session IDs.</p>', 'ListStreamingSessionsRequest$studioId' => '<p>The studio ID. </p>', 'ListStreamingSessionsResponse$nextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListStudioComponentsRequest$nextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListStudioComponentsRequest$studioId' => '<p>The studio ID. </p>', 'ListStudioComponentsResponse$nextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListStudioMembersRequest$nextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListStudioMembersRequest$studioId' => '<p>The studio ID. </p>', 'ListStudioMembersResponse$nextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListStudiosRequest$nextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListStudiosResponse$nextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListTagsForResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource for which you want to list tags.</p>', 'NewLaunchProfileMember$principalId' => '<p>The principal ID.</p>', 'NewStudioMember$principalId' => '<p>The principal ID.</p>', 'PutLaunchProfileMembersRequest$identityStoreId' => '<p>The ID of the identity store.</p>', 'PutLaunchProfileMembersRequest$launchProfileId' => '<p>The ID of the launch profile used to control access from the streaming session.</p>', 'PutLaunchProfileMembersRequest$studioId' => '<p>The studio ID. </p>', 'PutStudioMembersRequest$identityStoreId' => '<p>The ID of the identity store.</p>', 'PutStudioMembersRequest$studioId' => '<p>The studio ID. </p>', 'ResourceNotFoundException$code' => '<p>A more specific error code.</p>', 'ResourceNotFoundException$message' => '<p>A human-readable description of the error.</p>', 'ServiceQuotaExceededException$code' => '<p>A more specific error code.</p>', 'ServiceQuotaExceededException$message' => '<p>A human-readable description of the error.</p>', 'SharedFileSystemConfiguration$fileSystemId' => '<p>The unique identifier for a file system.</p>', 'StartStreamingSessionRequest$backupId' => '<p>The ID of the backup.</p>', 'StartStreamingSessionRequest$sessionId' => '<p>The streaming session ID for the <code>StartStreamingSessionRequest</code>.</p>', 'StartStreamingSessionRequest$studioId' => '<p>The studio ID for the StartStreamingSessionRequest.</p>', 'StartStudioSSOConfigurationRepairRequest$studioId' => '<p>The studio ID. </p>', 'StopStreamingSessionRequest$sessionId' => '<p>The streaming session ID for the <code>StopStreamingSessionRequest</code>.</p>', 'StopStreamingSessionRequest$studioId' => '<p>The studioId for the StopStreamingSessionRequest.</p>', 'StreamingImage$arn' => '<p>The Amazon Resource Name (ARN) that is assigned to a studio resource and uniquely identifies it. ARNs are unique across all Regions.</p>', 'StreamingImage$statusMessage' => '<p>The status message for the streaming image.</p>', 'StreamingSession$arn' => '<p>The Amazon Resource Name (ARN) that is assigned to a studio resource and uniquely identifies it. ARNs are unique across all Regions.</p>', 'StreamingSession$createdBy' => '<p>The user ID of the user that created the streaming session.</p>', 'StreamingSession$ec2InstanceType' => '<p>The EC2 Instance type used for the streaming session.</p>', 'StreamingSession$launchProfileId' => '<p>The ID of the launch profile used to control access from the streaming session.</p>', 'StreamingSession$ownedBy' => '<p>The user ID of the user that owns the streaming session. The user that owns the session will be logging into the session and interacting with the virtual workstation.</p>', 'StreamingSession$startedBy' => '<p>The user ID of the user that started the streaming session.</p>', 'StreamingSession$startedFromBackupId' => '<p>The backup ID used to restore a streaming session.</p>', 'StreamingSession$statusMessage' => '<p>The status message for the streaming session.</p>', 'StreamingSession$stoppedBy' => '<p>The user ID of the user that stopped the streaming session.</p>', 'StreamingSession$updatedBy' => '<p>The user ID of the user that most recently updated the resource.</p>', 'StreamingSessionBackup$arn' => '<p>The Amazon Resource Name (ARN) that is assigned to a studio resource and uniquely identifies it. ARNs are unique across all Regions.</p>', 'StreamingSessionBackup$backupId' => '<p>The ID of the backup.</p>', 'StreamingSessionBackup$launchProfileId' => '<p>The ID of the launch profile which allowed the backups for the streaming session.</p>', 'StreamingSessionBackup$ownedBy' => '<p>The user ID of the user that owns the streaming session.</p>', 'StreamingSessionBackup$statusMessage' => '<p>The status message for the streaming session backup.</p>', 'StreamingSessionStream$createdBy' => '<p>The user ID of the user that created the streaming session stream.</p>', 'StreamingSessionStream$ownedBy' => '<p>The user ID of the user that owns the streaming session. The user that owns the session will be logging into the session and interacting with the virtual workstation.</p>', 'StreamingSessionStream$streamId' => '<p>The stream ID.</p>', 'StringList$member' => NULL, 'Studio$arn' => '<p>The Amazon Resource Name (ARN) that is assigned to a studio resource and uniquely identifies it. ARNs are unique across all Regions.</p>', 'Studio$ssoClientId' => '<p>The IAM Identity Center application client ID used to integrate with IAM Identity Center. This ID allows IAM Identity Center users to log in to Nimble Studio portal.</p>', 'Studio$statusMessage' => '<p>Additional detail on the studio state.</p>', 'Studio$studioId' => '<p>The unique identifier for a studio resource. In Nimble Studio, all other resources are contained in a studio resource.</p>', 'Studio$studioUrl' => '<p>The address of the web page for the studio.</p>', 'StudioComponent$arn' => '<p>The Amazon Resource Name (ARN) that is assigned to a studio resource and uniquely identifies it. ARNs are unique across all Regions.</p>', 'StudioComponent$createdBy' => '<p>The user ID of the user that created the studio component.</p>', 'StudioComponent$statusMessage' => '<p>The status message for the studio component.</p>', 'StudioComponent$updatedBy' => '<p>The user ID of the user that most recently updated the resource.</p>', 'StudioComponentSummary$createdBy' => '<p>The user ID of the user that created the studio component.</p>', 'StudioComponentSummary$updatedBy' => '<p>The user ID of the user that most recently updated the resource.</p>', 'StudioMembership$identityStoreId' => '<p>The ID of the identity store.</p>', 'StudioMembership$principalId' => '<p>The principal ID.</p>', 'StudioMembership$sid' => '<p>The Active Directory Security Identifier for this user, if available.</p>', 'TagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource you want to add tags to. </p>', 'Tags$key' => NULL, 'Tags$value' => NULL, 'ThrottlingException$code' => '<p>A more specific error code.</p>', 'ThrottlingException$message' => '<p>A human-readable description of the error.</p>', 'UntagResourceRequest$resourceArn' => '<p>Identifies the Amazon Resource Name(ARN) key from which you are removing tags. </p>', 'UpdateLaunchProfileMemberRequest$launchProfileId' => '<p>The ID of the launch profile used to control access from the streaming session.</p>', 'UpdateLaunchProfileMemberRequest$principalId' => '<p>The principal ID. This currently supports a IAM Identity Center UserId. </p>', 'UpdateLaunchProfileMemberRequest$studioId' => '<p>The studio ID. </p>', 'UpdateLaunchProfileRequest$launchProfileId' => '<p>The ID of the launch profile used to control access from the streaming session.</p>', 'UpdateLaunchProfileRequest$studioId' => '<p>The studio ID. </p>', 'UpdateStreamingImageRequest$streamingImageId' => '<p>The streaming image ID.</p>', 'UpdateStreamingImageRequest$studioId' => '<p>The studio ID. </p>', 'UpdateStudioComponentRequest$studioComponentId' => '<p>The studio component ID.</p>', 'UpdateStudioComponentRequest$studioId' => '<p>The studio ID. </p>', 'UpdateStudioRequest$studioId' => '<p>The studio ID. </p>', 'ValidationException$code' => '<p>A more specific error code.</p>', 'ValidationException$message' => '<p>A human-readable description of the error.</p>', ], ], 'StringList' => [ 'base' => NULL, 'refs' => [ 'GetLaunchProfileInitializationRequest$launchProfileProtocolVersions' => '<p>The launch profile protocol versions supported by the client.</p>', 'ListEulaAcceptancesRequest$eulaIds' => '<p>The list of EULA IDs that have been previously accepted.</p>', 'ListEulasRequest$eulaIds' => '<p>The list of EULA IDs that should be returned</p>', 'UntagResourceRequest$tagKeys' => '<p>One or more tag keys. Specify only the tag keys, not the tag values.</p>', ], ], 'Studio' => [ 'base' => '<p>Represents a studio resource.</p> <p>A studio is the core resource used with Nimble Studio. You must create a studio first, before any other resource type can be created. All other resources you create and manage in Nimble Studio are contained within a studio.</p> <p>When creating a studio, you must provides two IAM roles for use with the Nimble Studio portal. These roles are assumed by your users when they log in to the Nimble Studio portal via IAM Identity Center and your identity source.</p> <p>The user role must have the <code>AmazonNimbleStudio-StudioUser</code> managed policy attached for the portal to function properly.</p> <p>The admin role must have the <code>AmazonNimbleStudio-StudioAdmin</code> managed policy attached for the portal to function properly.</p> <p>Your studio roles must trust the <code>identity.nimble.amazonaws.com</code> service principal to function properly.</p>', 'refs' => [ 'CreateStudioResponse$studio' => '<p>Information about a studio.</p>', 'DeleteStudioResponse$studio' => '<p>Information about a studio.</p>', 'GetStudioResponse$studio' => '<p>Information about a studio.</p>', 'StartStudioSSOConfigurationRepairResponse$studio' => '<p>Information about a studio.</p>', 'StudioList$member' => NULL, 'UpdateStudioResponse$studio' => '<p>Information about a studio.</p>', ], ], 'StudioComponent' => [ 'base' => '<p>A studio component represents a network resource to be used by a studio\'s users and workflows. A typical studio contains studio components for each of the following: render farm, Active Directory, licensing, and file system.</p> <p>Access to a studio component is managed by specifying security groups for the resource, as well as its endpoint.</p> <p>A studio component also has a set of initialization scripts that are returned by <code>GetLaunchProfileInitialization</code>. These initialization scripts run on streaming sessions when they start. They provide users with flexibility in controlling how the studio resources are configured on a streaming session.</p>', 'refs' => [ 'CreateStudioComponentResponse$studioComponent' => '<p>Information about the studio component.</p>', 'DeleteStudioComponentResponse$studioComponent' => '<p>Information about the studio component.</p>', 'GetStudioComponentResponse$studioComponent' => '<p>Information about the studio component.</p>', 'StudioComponentList$member' => NULL, 'UpdateStudioComponentResponse$studioComponent' => '<p>Information about the studio component.</p>', ], ], 'StudioComponentConfiguration' => [ 'base' => '<p>The configuration of the studio component, based on component type.</p>', 'refs' => [ 'CreateStudioComponentRequest$configuration' => '<p>The configuration of the studio component, based on component type.</p>', 'StudioComponent$configuration' => '<p>The configuration of the studio component, based on component type.</p>', 'UpdateStudioComponentRequest$configuration' => '<p>The configuration of the studio component, based on component type.</p>', ], ], 'StudioComponentDescription' => [ 'base' => NULL, 'refs' => [ 'CreateStudioComponentRequest$description' => '<p>The description.</p>', 'StudioComponent$description' => '<p>A human-readable description for the studio component resource.</p>', 'StudioComponentSummary$description' => '<p>The description.</p>', 'UpdateStudioComponentRequest$description' => '<p>The description.</p>', ], ], 'StudioComponentId' => [ 'base' => NULL, 'refs' => [ 'LaunchProfileInitializationActiveDirectory$studioComponentId' => '<p>The unique identifier for a studio component resource.</p>', 'LaunchProfileInitializationScript$studioComponentId' => '<p>The unique identifier for a studio component resource.</p>', 'StudioComponent$studioComponentId' => '<p>The unique identifier for a studio component resource.</p>', 'StudioComponentSummary$studioComponentId' => '<p>The unique identifier for a studio component resource.</p>', ], ], 'StudioComponentInitializationScript' => [ 'base' => '<p>Initialization scripts for studio components.</p>', 'refs' => [ 'StudioComponentInitializationScriptList$member' => NULL, ], ], 'StudioComponentInitializationScriptContent' => [ 'base' => NULL, 'refs' => [ 'LaunchProfileInitializationScript$script' => '<p>The initialization script.</p>', 'StudioComponentInitializationScript$script' => '<p>The initialization script.</p>', ], ], 'StudioComponentInitializationScriptList' => [ 'base' => NULL, 'refs' => [ 'CreateStudioComponentRequest$initializationScripts' => '<p>Initialization scripts for studio components.</p>', 'StudioComponent$initializationScripts' => '<p>Initialization scripts for studio components.</p>', 'UpdateStudioComponentRequest$initializationScripts' => '<p>Initialization scripts for studio components.</p>', ], ], 'StudioComponentInitializationScriptRunContext' => [ 'base' => NULL, 'refs' => [ 'StudioComponentInitializationScript$runContext' => '<p>The method to use when running the initialization script.</p>', ], ], 'StudioComponentList' => [ 'base' => NULL, 'refs' => [ 'ListStudioComponentsResponse$studioComponents' => '<p>A collection of studio components.</p>', ], ], 'StudioComponentName' => [ 'base' => NULL, 'refs' => [ 'CreateStudioComponentRequest$name' => '<p>The name for the studio component.</p>', 'LaunchProfileInitializationActiveDirectory$studioComponentName' => '<p>The name for the studio component.</p>', 'LaunchProfileInitializationScript$studioComponentName' => '<p>The name for the studio component.</p>', 'StudioComponent$name' => '<p>A friendly name for the studio component resource.</p>', 'StudioComponentSummary$name' => '<p>The name for the studio component.</p>', 'UpdateStudioComponentRequest$name' => '<p>The name for the studio component.</p>', ], ], 'StudioComponentScriptParameterKeyValueList' => [ 'base' => NULL, 'refs' => [ 'CreateStudioComponentRequest$scriptParameters' => '<p>Parameters for the studio component scripts.</p>', 'StudioComponent$scriptParameters' => '<p>Parameters for the studio component scripts.</p>', 'UpdateStudioComponentRequest$scriptParameters' => '<p>Parameters for the studio component scripts.</p>', ], ], 'StudioComponentSecurityGroupIdList' => [ 'base' => NULL, 'refs' => [ 'CreateStudioComponentRequest$ec2SecurityGroupIds' => '<p>The EC2 security groups that control access to the studio component.</p>', 'StudioComponent$ec2SecurityGroupIds' => '<p>The EC2 security groups that control access to the studio component.</p>', 'UpdateStudioComponentRequest$ec2SecurityGroupIds' => '<p>The EC2 security groups that control access to the studio component.</p>', ], ], 'StudioComponentState' => [ 'base' => '<p>The current state of the studio component resource.</p> <p>While a studio component is being created, modified, or deleted, its state will be <code>CREATE_IN_PROGRESS</code>, <code>UPDATE_IN_PROGRESS</code>, or <code>DELETE_IN_PROGRESS</code>.</p> <p>These are called <i>transition states</i>.</p> <p>No modifications may be made to the studio component while it is in a transition state.</p> <p>If creation of the resource fails, the state will change to <code>CREATE_FAILED</code>. The resource <code>StatusCode</code> and <code>StatusMessage</code> will provide more information of why creation failed. The resource in this state will automatically be deleted from your account after a period of time.</p> <p>If updating the resource fails, the state will change to <code>UPDATE_FAILED</code>. The resource <code>StatusCode</code> and <code>StatusMessage</code> will provide more information of why the update failed. The resource will be returned to the state it was in when the update request was invoked.</p> <p>If deleting the resource fails, the state will change to <code>DELETE_FAILED</code>. The resource <code>StatusCode</code> and <code>StatusMessage</code> will provide more information of why the update failed. The resource will be returned to the state it was in when the update request was invoked. After the resource is deleted successfully, it will change to the <code>DELETED</code> state. The resource will no longer count against service quotas and cannot be used or acted upon any futher. It will be removed from your account after a period of time.</p>', 'refs' => [ 'StudioComponent$state' => '<p>The current state.</p>', 'StudioComponentStateList$member' => NULL, ], ], 'StudioComponentStateList' => [ 'base' => NULL, 'refs' => [ 'ListStudioComponentsRequest$states' => '<p>Filters the request to studio components that are in one of the given states. </p>', ], ], 'StudioComponentStatusCode' => [ 'base' => '<p>The current status of the studio component resource.</p> <p>When the resource is in the <code>READY</code> state, the status code signals what the last mutation made to the resource was.</p> <p>When the resource is in a <code>CREATE_FAILED</code>, <code>UPDATE_FAILED</code>, or <code>DELETE_FAILED</code> state, the status code signals what went wrong and why the mutation failed.</p>', 'refs' => [ 'StudioComponent$statusCode' => '<p>The status code.</p>', ], ], 'StudioComponentSubtype' => [ 'base' => NULL, 'refs' => [ 'CreateStudioComponentRequest$subtype' => '<p>The specific subtype of a studio component.</p>', 'StudioComponent$subtype' => '<p>The specific subtype of a studio component.</p>', 'StudioComponentSummary$subtype' => '<p>The specific subtype of a studio component.</p>', 'UpdateStudioComponentRequest$subtype' => '<p>The specific subtype of a studio component.</p>', ], ], 'StudioComponentSummary' => [ 'base' => '<p>The studio component\'s summary.</p>', 'refs' => [ 'StudioComponentSummaryList$member' => NULL, ], ], 'StudioComponentSummaryList' => [ 'base' => NULL, 'refs' => [ 'GetLaunchProfileDetailsResponse$studioComponentSummaries' => '<p>A collection of studio component summaries.</p>', ], ], 'StudioComponentType' => [ 'base' => NULL, 'refs' => [ 'CreateStudioComponentRequest$type' => '<p>The type of the studio component.</p>', 'StudioComponent$type' => '<p>The type of the studio component.</p>', 'StudioComponentSummary$type' => '<p>The type of the studio component.</p>', 'StudioComponentTypeList$member' => NULL, 'UpdateStudioComponentRequest$type' => '<p>The type of the studio component.</p>', ], ], 'StudioComponentTypeList' => [ 'base' => NULL, 'refs' => [ 'ListStudioComponentsRequest$types' => '<p>Filters the request to studio components that are of one of the given types.</p>', ], ], 'StudioDisplayName' => [ 'base' => NULL, 'refs' => [ 'CreateStudioRequest$displayName' => '<p>A friendly name for the studio.</p>', 'Studio$displayName' => '<p>A friendly name for the studio.</p>', 'UpdateStudioRequest$displayName' => '<p>A friendly name for the studio.</p>', ], ], 'StudioEncryptionConfiguration' => [ 'base' => '<p>Configuration of the encryption method that is used for the studio.</p>', 'refs' => [ 'CreateStudioRequest$studioEncryptionConfiguration' => '<p>The studio encryption configuration.</p>', 'Studio$studioEncryptionConfiguration' => '<p>Configuration of the encryption method that is used for the studio.</p>', ], ], 'StudioEncryptionConfigurationKeyArn' => [ 'base' => '<p>The Amazon Resource Name (ARN) for a KMS key that is used to encrypt studio data.</p>', 'refs' => [ 'StudioEncryptionConfiguration$keyArn' => '<p>The ARN for a KMS key that is used to encrypt studio data.</p>', ], ], 'StudioEncryptionConfigurationKeyType' => [ 'base' => '<p>The type of KMS key that is used to encrypt studio data.</p>', 'refs' => [ 'StudioEncryptionConfiguration$keyType' => '<p>The type of KMS key that is used to encrypt studio data.</p>', ], ], 'StudioList' => [ 'base' => NULL, 'refs' => [ 'ListStudiosResponse$studios' => '<p>A collection of studios.</p>', ], ], 'StudioMembership' => [ 'base' => '<p>A studio member is an association of a user from your studio identity source to elevated permissions that they are granted in the studio.</p> <p>When you add a user to your studio using the Nimble Studio console, they are given access to the studio\'s IAM Identity Center application and are given access to log in to the Nimble Studio portal. These users have the permissions provided by the studio\'s user IAM role and do not appear in the studio membership collection. Only studio admins appear in studio membership.</p> <p>When you add a user to studio membership with the ADMIN persona, upon logging in to the Nimble Studio portal, they are granted permissions specified by the Studio\'s Admin IAM role.</p>', 'refs' => [ 'GetStudioMemberResponse$member' => '<p>The member.</p>', 'StudioMembershipList$member' => NULL, ], ], 'StudioMembershipList' => [ 'base' => NULL, 'refs' => [ 'ListStudioMembersResponse$members' => '<p>A list of admin members.</p>', ], ], 'StudioName' => [ 'base' => NULL, 'refs' => [ 'CreateStudioRequest$studioName' => '<p>The studio name that is used in the URL of the Nimble Studio portal when accessed by Nimble Studio users.</p>', 'Studio$studioName' => '<p>The name of the studio, as included in the URL when accessing it in the Nimble Studio portal.</p>', ], ], 'StudioPersona' => [ 'base' => NULL, 'refs' => [ 'NewStudioMember$persona' => '<p>The persona.</p>', 'StudioMembership$persona' => '<p>The persona.</p>', ], ], 'StudioState' => [ 'base' => NULL, 'refs' => [ 'Studio$state' => '<p>The current state of the studio resource.</p>', ], ], 'StudioStatusCode' => [ 'base' => '<p>The status code.</p>', 'refs' => [ 'Studio$statusCode' => '<p>Status codes that provide additional detail on the studio state.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'Tags' => [ 'base' => NULL, 'refs' => [ 'CreateLaunchProfileRequest$tags' => '<p>A collection of labels, in the form of key-value pairs, that apply to this resource.</p>', 'CreateStreamingImageRequest$tags' => '<p>A collection of labels, in the form of key-value pairs, that apply to this resource.</p>', 'CreateStreamingSessionRequest$tags' => '<p>A collection of labels, in the form of key-value pairs, that apply to this resource.</p>', 'CreateStudioComponentRequest$tags' => '<p>A collection of labels, in the form of key-value pairs, that apply to this resource.</p>', 'CreateStudioRequest$tags' => '<p>A collection of labels, in the form of key-value pairs, that apply to this resource.</p>', 'LaunchProfile$tags' => '<p>A collection of labels, in the form of key-value pairs, that apply to this resource.</p>', 'ListTagsForResourceResponse$tags' => '<p>A collection of labels, in the form of key-value pairs, that apply to this resource.</p>', 'StreamingImage$tags' => '<p>A collection of labels, in the form of key-value pairs, that apply to this resource.</p>', 'StreamingSession$tags' => '<p>A collection of labels, in the form of key-value pairs, that apply to this resource.</p>', 'StreamingSessionBackup$tags' => '<p>A collection of labels, in the form of key-value pairs, that apply to this resource.</p>', 'Studio$tags' => '<p>A collection of labels, in the form of key-value pairs, that apply to this resource.</p>', 'StudioComponent$tags' => '<p>A collection of labels, in the form of key-value pairs, that apply to this resource.</p>', 'TagResourceRequest$tags' => '<p>A collection of labels, in the form of key-value pairs, that apply to this resource.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The request throughput limit was exceeded.</p>', 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'Eula$createdAt' => '<p>The ISO timestamp in seconds for when the resource was created.</p>', 'Eula$updatedAt' => '<p>The ISO timestamp in seconds for when the resource was updated.</p>', 'EulaAcceptance$acceptedAt' => '<p>The ISO timestamp in seconds for when the EULA was accepted.</p>', 'LaunchProfile$createdAt' => '<p>The ISO timestamp in seconds for when the resource was created.</p>', 'LaunchProfile$updatedAt' => '<p>The ISO timestamp in seconds for when the resource was updated.</p>', 'StreamingSession$createdAt' => '<p>The ISO timestamp in seconds for when the resource was created.</p>', 'StreamingSession$startedAt' => '<p>The time the session entered <code>START_IN_PROGRESS</code> state.</p>', 'StreamingSession$stopAt' => '<p>The time the streaming session will automatically be stopped if the user doesn’t stop the session themselves. </p>', 'StreamingSession$stoppedAt' => '<p>The time the session entered <code>STOP_IN_PROGRESS</code> state.</p>', 'StreamingSession$terminateAt' => '<p>The time the streaming session will automatically terminate if not terminated by the user.</p>', 'StreamingSession$updatedAt' => '<p>The ISO timestamp in seconds for when the resource was updated.</p>', 'StreamingSessionBackup$createdAt' => '<p>The ISO timestamp in for when the resource was created.</p>', 'StreamingSessionStream$createdAt' => '<p>The ISO timestamp in seconds for when the resource was created.</p>', 'StreamingSessionStream$expiresAt' => '<p>The ISO timestamp in seconds for when the resource expires.</p>', 'Studio$createdAt' => '<p>The ISO timestamp in seconds for when the resource was created.</p>', 'Studio$updatedAt' => '<p>The ISO timestamp in seconds for when the resource was updated.</p>', 'StudioComponent$createdAt' => '<p>The ISO timestamp in seconds for when the resource was created.</p>', 'StudioComponent$updatedAt' => '<p>The ISO timestamp in seconds for when the resource was updated.</p>', 'StudioComponentSummary$createdAt' => '<p>The ISO timestamp in seconds for when the resource was created.</p>', 'StudioComponentSummary$updatedAt' => '<p>The ISO timestamp in seconds for when the resource was updated.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateLaunchProfileMemberRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateLaunchProfileMemberResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateLaunchProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateLaunchProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateStreamingImageRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateStreamingImageResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateStudioComponentRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateStudioComponentResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateStudioRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateStudioResponse' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>One of the parameters in the request is invalid.</p>', 'refs' => [], ], 'ValidationResult' => [ 'base' => '<p>The launch profile validation result.</p>', 'refs' => [ 'ValidationResults$member' => NULL, ], ], 'ValidationResults' => [ 'base' => NULL, 'refs' => [ 'LaunchProfile$validationResults' => '<p>The list of the latest validation results.</p>', ], ], 'VolumeConfiguration' => [ 'base' => '<p>Custom volume configuration for the root volumes that are attached to streaming sessions.</p> <p>This parameter is only allowed when <code>sessionPersistenceMode</code> is <code>ACTIVATED</code>.</p>', 'refs' => [ 'StreamConfiguration$volumeConfiguration' => '<p>Custom volume configuration for the root volumes that are attached to streaming sessions.</p> <p>This parameter is only allowed when <code>sessionPersistenceMode</code> is <code>ACTIVATED</code>.</p>', 'StreamConfigurationCreate$volumeConfiguration' => '<p>Custom volume configuration for the root volumes that are attached to streaming sessions.</p> <p>This parameter is only allowed when <code>sessionPersistenceMode</code> is <code>ACTIVATED</code>.</p>', 'StreamingSession$volumeConfiguration' => '<p>Custom volume configuration for the root volumes that are attached to streaming sessions.</p> <p>This parameter is only allowed when <code>sessionPersistenceMode</code> is <code>ACTIVATED</code>.</p>', ], ], 'VolumeIops' => [ 'base' => NULL, 'refs' => [ 'VolumeConfiguration$iops' => '<p>The number of I/O operations per second for the root volume that is attached to streaming session.</p>', ], ], 'VolumeRetentionMode' => [ 'base' => NULL, 'refs' => [ 'StopStreamingSessionRequest$volumeRetentionMode' => '<p>Adds additional instructions to a streaming session stop action to either retain the EBS volumes or delete the EBS volumes.</p>', 'StreamingSession$volumeRetentionMode' => '<p>Determine if an EBS volume created from this streaming session will be backed up.</p>', ], ], 'VolumeSizeInGiB' => [ 'base' => NULL, 'refs' => [ 'VolumeConfiguration$size' => '<p>The size of the root volume that is attached to the streaming session. The root volume size is measured in GiBs.</p>', ], ], 'VolumeThroughputInMiBs' => [ 'base' => NULL, 'refs' => [ 'VolumeConfiguration$throughput' => '<p>The throughput to provision for the root volume that is attached to the streaming session. The throughput is measured in MiB/s.</p>', ], ], 'WindowsMountDrive' => [ 'base' => NULL, 'refs' => [ 'SharedFileSystemConfiguration$windowsMountDrive' => '<p>The mount location for a shared file system on a Windows virtual workstation.</p>', ], ], ],];
