<?php
// This file was auto-generated from sdk-root/src/data/omics/2022-11-28/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>This is the <i>AWS HealthOmics API Reference</i>. For an introduction to the service, see <a href="https://docs.aws.amazon.com/omics/latest/dev/">What is AWS HealthOmics?</a> in the <i>AWS HealthOmics User Guide</i>.</p>', 'operations' => [ 'AbortMultipartReadSetUpload' => '<p>Stops a multipart upload.</p>', 'AcceptShare' => '<p>Accept a resource share request.</p>', 'BatchDeleteReadSet' => '<p>Deletes one or more read sets.</p>', 'CancelAnnotationImportJob' => '<p>Cancels an annotation import job.</p>', 'CancelRun' => '<p>Cancels a run.</p>', 'CancelVariantImportJob' => '<p>Cancels a variant import job.</p>', 'CompleteMultipartReadSetUpload' => '<p>Concludes a multipart upload once you have uploaded all the components.</p>', 'CreateAnnotationStore' => '<p>Creates an annotation store.</p>', 'CreateAnnotationStoreVersion' => '<p> Creates a new version of an annotation store. </p>', 'CreateMultipartReadSetUpload' => '<p>Begins a multipart read set upload.</p>', 'CreateReferenceStore' => '<p>Creates a reference store.</p>', 'CreateRunGroup' => '<p>Creates a run group.</p>', 'CreateSequenceStore' => '<p>Creates a sequence store.</p>', 'CreateShare' => '<p>Creates a cross-account shared resource. The resource owner makes an offer to share the resource with the principal subscriber (an AWS user with a different account than the resource owner).</p> <p>The following resources support cross-account sharing:</p> <ul> <li> <p>Healthomics variant stores</p> </li> <li> <p>Healthomics annotation stores</p> </li> <li> <p>Private workflows</p> </li> </ul>', 'CreateVariantStore' => '<p>Creates a variant store.</p>', 'CreateWorkflow' => '<p>Creates a workflow.</p>', 'DeleteAnnotationStore' => '<p>Deletes an annotation store.</p>', 'DeleteAnnotationStoreVersions' => '<p> Deletes one or multiple versions of an annotation store. </p>', 'DeleteReference' => '<p>Deletes a genome reference.</p>', 'DeleteReferenceStore' => '<p>Deletes a genome reference store.</p>', 'DeleteRun' => '<p>Deletes a workflow run.</p>', 'DeleteRunGroup' => '<p>Deletes a workflow run group.</p>', 'DeleteSequenceStore' => '<p>Deletes a sequence store.</p>', 'DeleteShare' => '<p>Deletes a resource share. If you are the resource owner, the subscriber will no longer have access to the shared resource. If you are the subscriber, this operation deletes your access to the share.</p>', 'DeleteVariantStore' => '<p>Deletes a variant store.</p>', 'DeleteWorkflow' => '<p>Deletes a workflow.</p>', 'GetAnnotationImportJob' => '<p>Gets information about an annotation import job.</p>', 'GetAnnotationStore' => '<p>Gets information about an annotation store.</p>', 'GetAnnotationStoreVersion' => '<p> Retrieves the metadata for an annotation store version. </p>', 'GetReadSet' => '<p>Gets a file from a read set.</p>', 'GetReadSetActivationJob' => '<p>Gets information about a read set activation job.</p>', 'GetReadSetExportJob' => '<p>Gets information about a read set export job.</p>', 'GetReadSetImportJob' => '<p>Gets information about a read set import job.</p>', 'GetReadSetMetadata' => '<p>Gets details about a read set.</p>', 'GetReference' => '<p>Gets a reference file.</p>', 'GetReferenceImportJob' => '<p>Gets information about a reference import job.</p>', 'GetReferenceMetadata' => '<p>Gets information about a genome reference\'s metadata.</p>', 'GetReferenceStore' => '<p>Gets information about a reference store.</p>', 'GetRun' => '<p>Gets information about a workflow run.</p> <p>If a workflow is shared with you, you cannot export information about the run.</p>', 'GetRunGroup' => '<p>Gets information about a workflow run group.</p>', 'GetRunTask' => '<p>Gets information about a workflow run task.</p>', 'GetSequenceStore' => '<p>Gets information about a sequence store.</p>', 'GetShare' => '<p>Retrieves the metadata for the specified resource share.</p>', 'GetVariantImportJob' => '<p>Gets information about a variant import job.</p>', 'GetVariantStore' => '<p>Gets information about a variant store.</p>', 'GetWorkflow' => '<p>Gets information about a workflow.</p> <p>If a workflow is shared with you, you cannot export the workflow.</p>', 'ListAnnotationImportJobs' => '<p>Retrieves a list of annotation import jobs.</p>', 'ListAnnotationStoreVersions' => '<p> Lists the versions of an annotation store. </p>', 'ListAnnotationStores' => '<p>Retrieves a list of annotation stores.</p>', 'ListMultipartReadSetUploads' => '<p>Lists multipart read set uploads and for in progress uploads. Once the upload is completed, a read set is created and the upload will no longer be returned in the response.</p>', 'ListReadSetActivationJobs' => '<p>Retrieves a list of read set activation jobs.</p>', 'ListReadSetExportJobs' => '<p>Retrieves a list of read set export jobs.</p>', 'ListReadSetImportJobs' => '<p>Retrieves a list of read set import jobs.</p>', 'ListReadSetUploadParts' => '<p>This operation will list all parts in a requested multipart upload for a sequence store.</p>', 'ListReadSets' => '<p>Retrieves a list of read sets.</p>', 'ListReferenceImportJobs' => '<p>Retrieves a list of reference import jobs.</p>', 'ListReferenceStores' => '<p>Retrieves a list of reference stores.</p>', 'ListReferences' => '<p>Retrieves a list of references.</p>', 'ListRunGroups' => '<p>Retrieves a list of run groups.</p>', 'ListRunTasks' => '<p>Retrieves a list of tasks for a run.</p>', 'ListRuns' => '<p>Retrieves a list of runs.</p>', 'ListSequenceStores' => '<p>Retrieves a list of sequence stores.</p>', 'ListShares' => '<p>Retrieves the resource shares associated with an account. Use the filter parameter to retrieve a specific subset of the shares.</p>', 'ListTagsForResource' => '<p>Retrieves a list of tags for a resource.</p>', 'ListVariantImportJobs' => '<p>Retrieves a list of variant import jobs.</p>', 'ListVariantStores' => '<p>Retrieves a list of variant stores.</p>', 'ListWorkflows' => '<p>Retrieves a list of workflows.</p>', 'StartAnnotationImportJob' => '<p>Starts an annotation import job.</p>', 'StartReadSetActivationJob' => '<p>Activates an archived read set. To reduce storage charges, Amazon Omics archives unused read sets after 30 days.</p>', 'StartReadSetExportJob' => '<p>Exports a read set to Amazon S3.</p>', 'StartReadSetImportJob' => '<p>Starts a read set import job.</p>', 'StartReferenceImportJob' => '<p>Starts a reference import job.</p>', 'StartRun' => '<p>Starts a workflow run. To duplicate a run, specify the run\'s ID and a role ARN. The remaining parameters are copied from the previous run.</p> <p>StartRun will not support re-run for a workflow that is shared with you.</p> <p>The total number of runs in your account is subject to a quota per Region. To avoid needing to delete runs manually, you can set the retention mode to <code>REMOVE</code>. Runs with this setting are deleted automatically when the run quoata is exceeded.</p> <p>By default, the run uses STATIC storage. For STATIC storage, set the <code>storageCapacity</code> field. You can set the storage type to DYNAMIC. You do not set <code>storageCapacity</code>, because HealthOmics dynamically scales the storage up or down as required. For more information about static and dynamic storage, see <a href="https://docs.aws.amazon.com/omics/latest/dev/Using-workflows.html">Running workflows</a> in the <i>AWS HealthOmics User Guide</i>.</p>', 'StartVariantImportJob' => '<p>Starts a variant import job.</p>', 'TagResource' => '<p>Tags a resource.</p>', 'UntagResource' => '<p>Removes tags from a resource.</p>', 'UpdateAnnotationStore' => '<p>Updates an annotation store.</p>', 'UpdateAnnotationStoreVersion' => '<p> Updates the description of an annotation store version. </p>', 'UpdateRunGroup' => '<p>Updates a run group.</p>', 'UpdateVariantStore' => '<p>Updates a variant store.</p>', 'UpdateWorkflow' => '<p>Updates a workflow.</p>', 'UploadReadSetPart' => '<p>This operation uploads a specific part of a read set. If you upload a new part using a previously used part number, the previously uploaded part will be overwritten.</p>', ], 'shapes' => [ 'AbortMultipartReadSetUploadRequest' => [ 'base' => NULL, 'refs' => [], ], 'AbortMultipartReadSetUploadResponse' => [ 'base' => NULL, 'refs' => [], ], 'Accelerators' => [ 'base' => NULL, 'refs' => [ 'CreateWorkflowRequest$accelerators' => '<p>The computational accelerator specified to run the workflow.</p>', 'GetRunResponse$accelerators' => '<p>The computational accelerator used to run the workflow.</p>', 'GetWorkflowResponse$accelerators' => '<p>The computational accelerator specified to run the workflow. </p>', ], ], 'AcceptShareRequest' => [ 'base' => NULL, 'refs' => [], ], 'AcceptShareResponse' => [ 'base' => NULL, 'refs' => [], ], 'AccessDeniedException' => [ 'base' => '<p>You do not have sufficient access to perform this action.</p>', 'refs' => [], ], 'ActivateReadSetFilter' => [ 'base' => '<p>A read set activation job filter.</p>', 'refs' => [ 'ListReadSetActivationJobsRequest$filter' => '<p>A filter to apply to the list.</p>', ], ], 'ActivateReadSetJobItem' => [ 'base' => '<p>A read set activation job.</p>', 'refs' => [ 'ActivateReadSetJobList$member' => NULL, ], ], 'ActivateReadSetJobList' => [ 'base' => NULL, 'refs' => [ 'ListReadSetActivationJobsResponse$activationJobs' => '<p>A list of jobs.</p>', ], ], 'ActivateReadSetSourceItem' => [ 'base' => '<p>A source for a read set activation job.</p>', 'refs' => [ 'ActivateReadSetSourceList$member' => NULL, ], ], 'ActivateReadSetSourceList' => [ 'base' => NULL, 'refs' => [ 'GetReadSetActivationJobResponse$sources' => '<p>The job\'s source files.</p>', ], ], 'ActivationJobId' => [ 'base' => NULL, 'refs' => [ 'ActivateReadSetJobItem$id' => '<p>The job\'s ID.</p>', 'GetReadSetActivationJobRequest$id' => '<p>The job\'s ID.</p>', 'GetReadSetActivationJobResponse$id' => '<p>The job\'s ID.</p>', 'StartReadSetActivationJobResponse$id' => '<p>The job\'s ID.</p>', ], ], 'AnnotationFieldMap' => [ 'base' => NULL, 'refs' => [ 'AnnotationImportJobItem$annotationFields' => '<p> The annotation schema generated by the parsed annotation data. </p>', 'GetAnnotationImportResponse$annotationFields' => '<p>The annotation schema generated by the parsed annotation data.</p>', 'GetVariantImportResponse$annotationFields' => '<p>The annotation schema generated by the parsed annotation data.</p>', 'StartAnnotationImportRequest$annotationFields' => '<p>The annotation schema generated by the parsed annotation data.</p>', 'StartVariantImportRequest$annotationFields' => '<p>The annotation schema generated by the parsed annotation data.</p>', 'VariantImportJobItem$annotationFields' => '<p> The annotation schema generated by the parsed annotation data. </p>', ], ], 'AnnotationFieldMapKeyString' => [ 'base' => NULL, 'refs' => [ 'AnnotationFieldMap$key' => NULL, ], ], 'AnnotationFieldMapValueString' => [ 'base' => NULL, 'refs' => [ 'AnnotationFieldMap$value' => NULL, ], ], 'AnnotationImportItemDetail' => [ 'base' => '<p>Details about an imported annotation item.</p>', 'refs' => [ 'AnnotationImportItemDetails$member' => NULL, ], ], 'AnnotationImportItemDetails' => [ 'base' => NULL, 'refs' => [ 'GetAnnotationImportResponse$items' => '<p>The job\'s imported items.</p>', ], ], 'AnnotationImportItemSource' => [ 'base' => '<p>A source for an annotation import job.</p>', 'refs' => [ 'AnnotationImportItemSources$member' => NULL, ], ], 'AnnotationImportItemSources' => [ 'base' => NULL, 'refs' => [ 'StartAnnotationImportRequest$items' => '<p>Items to import.</p>', ], ], 'AnnotationImportJobItem' => [ 'base' => '<p>An annotation import job.</p>', 'refs' => [ 'AnnotationImportJobItems$member' => NULL, ], ], 'AnnotationImportJobItems' => [ 'base' => NULL, 'refs' => [ 'ListAnnotationImportJobsResponse$annotationImportJobs' => '<p>A list of jobs.</p>', ], ], 'AnnotationStoreItem' => [ 'base' => '<p>An annotation store.</p>', 'refs' => [ 'AnnotationStoreItems$member' => NULL, ], ], 'AnnotationStoreItems' => [ 'base' => NULL, 'refs' => [ 'ListAnnotationStoresResponse$annotationStores' => '<p>A list of stores.</p>', ], ], 'AnnotationStoreVersionItem' => [ 'base' => '<p> Annotation store versions. </p>', 'refs' => [ 'AnnotationStoreVersionItems$member' => NULL, ], ], 'AnnotationStoreVersionItems' => [ 'base' => NULL, 'refs' => [ 'ListAnnotationStoreVersionsResponse$annotationStoreVersions' => '<p> Lists all versions of an annotation store. </p>', ], ], 'AnnotationType' => [ 'base' => NULL, 'refs' => [ 'TsvStoreOptions$annotationType' => '<p>The store\'s annotation type.</p>', 'TsvVersionOptions$annotationType' => '<p> The store version\'s annotation type. </p>', ], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'AnnotationImportJobItem$roleArn' => '<p>The job\'s service role ARN.</p>', 'AnnotationStoreItem$storeArn' => '<p>The store\'s ARN.</p>', 'AnnotationStoreVersionItem$versionArn' => '<p> The Arn for an annotation store version. </p>', 'GetAnnotationImportResponse$roleArn' => '<p>The job\'s service role ARN.</p>', 'GetAnnotationStoreResponse$storeArn' => '<p>The store\'s ARN.</p>', 'GetAnnotationStoreVersionResponse$versionArn' => '<p> The Arn for the annotation store. </p>', 'GetVariantImportResponse$roleArn' => '<p>The job\'s service role ARN.</p>', 'GetVariantStoreResponse$storeArn' => '<p>The store\'s ARN.</p>', 'StartAnnotationImportRequest$roleArn' => '<p>A service role for the job.</p>', 'StartVariantImportRequest$roleArn' => '<p>A service role for the job.</p>', 'VariantImportJobItem$roleArn' => '<p>The job\'s service role ARN.</p>', 'VariantStoreItem$storeArn' => '<p>The store\'s ARN.</p>', ], ], 'ArnList' => [ 'base' => NULL, 'refs' => [ 'Filter$resourceArns' => '<p>Filter based on the Amazon Resource Number (ARN) of the resource. You can specify up to 10 values.</p>', ], ], 'BatchDeleteReadSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchDeleteReadSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'Blob' => [ 'base' => NULL, 'refs' => [ 'CreateWorkflowRequest$definitionZip' => '<p>A ZIP archive for the workflow.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'VcfOptions$ignoreQualField' => '<p>The file\'s ignore qual field setting.</p>', 'VcfOptions$ignoreFilterField' => '<p>The file\'s ignore filter field setting.</p>', 'WorkflowParameter$optional' => '<p>Whether the parameter is optional.</p>', ], ], 'CancelAnnotationImportRequest' => [ 'base' => NULL, 'refs' => [], ], 'CancelAnnotationImportResponse' => [ 'base' => NULL, 'refs' => [], ], 'CancelRunRequest' => [ 'base' => NULL, 'refs' => [], ], 'CancelVariantImportRequest' => [ 'base' => NULL, 'refs' => [], ], 'CancelVariantImportResponse' => [ 'base' => NULL, 'refs' => [], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'CreateMultipartReadSetUploadRequest$clientToken' => '<p>An idempotency token that can be used to avoid triggering multiple multipart uploads.</p>', 'CreateReferenceStoreRequest$clientToken' => '<p>To ensure that requests don\'t run multiple times, specify a unique token for each request.</p>', 'CreateSequenceStoreRequest$clientToken' => '<p>To ensure that requests don\'t run multiple times, specify a unique token for each request.</p>', 'StartReadSetActivationJobRequest$clientToken' => '<p>To ensure that jobs don\'t run multiple times, specify a unique token for each job.</p>', 'StartReadSetExportJobRequest$clientToken' => '<p>To ensure that jobs don\'t run multiple times, specify a unique token for each job.</p>', 'StartReadSetImportJobRequest$clientToken' => '<p>To ensure that jobs don\'t run multiple times, specify a unique token for each job.</p>', 'StartReferenceImportJobRequest$clientToken' => '<p>To ensure that jobs don\'t run multiple times, specify a unique token for each job.</p>', ], ], 'CommentChar' => [ 'base' => NULL, 'refs' => [ 'ReadOptions$comment' => '<p>The file\'s comment character.</p>', ], ], 'CompleteMultipartReadSetUploadRequest' => [ 'base' => NULL, 'refs' => [], ], 'CompleteMultipartReadSetUploadResponse' => [ 'base' => NULL, 'refs' => [], ], 'CompleteReadSetUploadPartList' => [ 'base' => NULL, 'refs' => [ 'CompleteMultipartReadSetUploadRequest$parts' => '<p>The individual uploads or parts of a multipart upload.</p>', ], ], 'CompleteReadSetUploadPartListItem' => [ 'base' => '<p> Part of the response to the CompleteReadSetUpload API, including metadata. </p>', 'refs' => [ 'CompleteReadSetUploadPartList$member' => NULL, ], ], 'CompleteReadSetUploadPartListItemChecksumString' => [ 'base' => NULL, 'refs' => [ 'CompleteReadSetUploadPartListItem$checksum' => '<p> A unique identifier used to confirm that parts are being added to the correct upload. </p>', ], ], 'CompleteReadSetUploadPartListItemPartNumberInteger' => [ 'base' => NULL, 'refs' => [ 'CompleteReadSetUploadPartListItem$partNumber' => '<p> A number identifying the part in a read set upload. </p>', ], ], 'CompletionTime' => [ 'base' => NULL, 'refs' => [ 'AnnotationImportJobItem$completionTime' => '<p>When the job completed.</p>', 'GetAnnotationImportResponse$completionTime' => '<p>When the job completed.</p>', 'GetVariantImportResponse$completionTime' => '<p>When the job completed.</p>', 'VariantImportJobItem$completionTime' => '<p>When the job completed.</p>', ], ], 'ConflictException' => [ 'base' => '<p>The request cannot be applied to the target resource in its current state.</p>', 'refs' => [], ], 'CreateAnnotationStoreRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAnnotationStoreResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateAnnotationStoreVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAnnotationStoreVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateMultipartReadSetUploadRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateMultipartReadSetUploadResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateReferenceStoreRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateReferenceStoreResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateRunGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateRunGroupRequestMaxCpusInteger' => [ 'base' => NULL, 'refs' => [ 'CreateRunGroupRequest$maxCpus' => '<p>The maximum number of CPUs to use in the group.</p>', ], ], 'CreateRunGroupRequestMaxDurationInteger' => [ 'base' => NULL, 'refs' => [ 'CreateRunGroupRequest$maxDuration' => '<p>A maximum run time for the group in minutes.</p>', ], ], 'CreateRunGroupRequestMaxGpusInteger' => [ 'base' => NULL, 'refs' => [ 'CreateRunGroupRequest$maxGpus' => '<p>The maximum GPUs that can be used by a run group.</p>', ], ], 'CreateRunGroupRequestMaxRunsInteger' => [ 'base' => NULL, 'refs' => [ 'CreateRunGroupRequest$maxRuns' => '<p>The maximum number of concurrent runs for the group.</p>', ], ], 'CreateRunGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateSequenceStoreRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSequenceStoreResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateShareRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateShareResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateVariantStoreRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateVariantStoreResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateWorkflowRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateWorkflowRequestStorageCapacityInteger' => [ 'base' => NULL, 'refs' => [ 'CreateWorkflowRequest$storageCapacity' => '<p>The storage capacity for the workflow in gibibytes.</p>', ], ], 'CreateWorkflowResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreationTime' => [ 'base' => NULL, 'refs' => [ 'AnnotationImportJobItem$creationTime' => '<p>When the job was created.</p>', 'AnnotationStoreItem$creationTime' => '<p>The store\'s creation time.</p>', 'AnnotationStoreVersionItem$creationTime' => '<p> The time stamp for when an annotation store version was created. </p>', 'CreateAnnotationStoreResponse$creationTime' => '<p>When the store was created.</p>', 'CreateAnnotationStoreVersionResponse$creationTime' => '<p> The time stamp for the creation of an annotation store version. </p>', 'CreateVariantStoreResponse$creationTime' => '<p>When the store was created.</p>', 'GetAnnotationImportResponse$creationTime' => '<p>When the job was created.</p>', 'GetAnnotationStoreResponse$creationTime' => '<p>When the store was created.</p>', 'GetAnnotationStoreVersionResponse$creationTime' => '<p> The time stamp for when an annotation store version was created. </p>', 'GetVariantImportResponse$creationTime' => '<p>When the job was created.</p>', 'GetVariantStoreResponse$creationTime' => '<p>When the store was created.</p>', 'ShareDetails$creationTime' => '<p>The timestamp of when the resource share was created.</p>', 'UpdateAnnotationStoreResponse$creationTime' => '<p>When the store was created.</p>', 'UpdateAnnotationStoreVersionResponse$creationTime' => '<p> The time stamp for when an annotation store version was created. </p>', 'UpdateVariantStoreResponse$creationTime' => '<p>When the store was created.</p>', 'VariantImportJobItem$creationTime' => '<p>When the job was created.</p>', 'VariantStoreItem$creationTime' => '<p>When the store was created.</p>', ], ], 'CreationType' => [ 'base' => NULL, 'refs' => [ 'GetReadSetMetadataResponse$creationType' => '<p> The creation type of the read set. </p>', 'ReadSetFilter$creationType' => '<p> The creation type of the read set. </p>', 'ReadSetListItem$creationType' => '<p> The creation type of the read set. </p>', ], ], 'DeleteAnnotationStoreRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAnnotationStoreResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAnnotationStoreVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAnnotationStoreVersionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteReferenceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteReferenceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteReferenceStoreRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteReferenceStoreResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRunGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRunRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSequenceStoreRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSequenceStoreResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteShareRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteShareResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVariantStoreRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVariantStoreResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWorkflowRequest' => [ 'base' => NULL, 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'AnnotationStoreItem$description' => '<p>The store\'s description.</p>', 'AnnotationStoreVersionItem$description' => '<p> The description of an annotation store version. </p>', 'CreateAnnotationStoreRequest$description' => '<p>A description for the store.</p>', 'CreateAnnotationStoreVersionRequest$description' => '<p> The description of an annotation store version. </p>', 'CreateVariantStoreRequest$description' => '<p>A description for the store.</p>', 'GetAnnotationStoreResponse$description' => '<p>The store\'s description.</p>', 'GetAnnotationStoreVersionResponse$description' => '<p> The description for an annotation store version. </p>', 'GetVariantStoreResponse$description' => '<p>The store\'s description.</p>', 'UpdateAnnotationStoreRequest$description' => '<p>A description for the store.</p>', 'UpdateAnnotationStoreResponse$description' => '<p>The store\'s description.</p>', 'UpdateAnnotationStoreVersionRequest$description' => '<p> The description of an annotation store. </p>', 'UpdateAnnotationStoreVersionResponse$description' => '<p> The description of an annotation store version. </p>', 'UpdateVariantStoreRequest$description' => '<p>A description for the store.</p>', 'UpdateVariantStoreResponse$description' => '<p>The store\'s description.</p>', 'VariantStoreItem$description' => '<p>The store\'s description.</p>', ], ], 'ETag' => [ 'base' => '<p>The entity tag (ETag) is a hash of the object representing its semantic content.</p>', 'refs' => [ 'GetReadSetMetadataResponse$etag' => '<p>The entity tag (ETag) is a hash of the object meant to represent its semantic content.</p>', 'ReadSetListItem$etag' => '<p>The entity tag (ETag) is a hash of the object representing its semantic content.</p>', ], ], 'ETagAlgorithm' => [ 'base' => NULL, 'refs' => [ 'ETag$algorithm' => '<p>The algorithm used to calculate the read set’s ETag(s).</p>', ], ], 'ETagAlgorithmFamily' => [ 'base' => NULL, 'refs' => [ 'CreateSequenceStoreRequest$eTagAlgorithmFamily' => '<p>The ETag algorithm family to use for ingested read sets.</p>', 'CreateSequenceStoreResponse$eTagAlgorithmFamily' => '<p>The algorithm family of the ETag.</p>', 'GetSequenceStoreResponse$eTagAlgorithmFamily' => '<p>The algorithm family of the ETag.</p>', 'SequenceStoreDetail$eTagAlgorithmFamily' => '<p>The algorithm family of the ETag.</p>', ], ], 'Encoding' => [ 'base' => NULL, 'refs' => [ 'ReadOptions$encoding' => '<p>The file\'s encoding.</p>', ], ], 'EncryptionType' => [ 'base' => NULL, 'refs' => [ 'SseConfig$type' => '<p>The encryption type.</p>', ], ], 'EngineLogStream' => [ 'base' => NULL, 'refs' => [ 'RunLogLocation$engineLogStream' => '<p>The log stream ARN for the engine log.</p>', ], ], 'EscapeChar' => [ 'base' => NULL, 'refs' => [ 'ReadOptions$escape' => '<p>A character for escaping quotes in the file.</p>', ], ], 'EscapeQuotes' => [ 'base' => NULL, 'refs' => [ 'ReadOptions$escapeQuotes' => '<p>Whether quotes need to be escaped in the file.</p>', ], ], 'ExportJobId' => [ 'base' => NULL, 'refs' => [ 'ExportReadSetJobDetail$id' => '<p>The job\'s ID.</p>', 'GetReadSetExportJobRequest$id' => '<p>The job\'s ID.</p>', 'GetReadSetExportJobResponse$id' => '<p>The job\'s ID.</p>', 'StartReadSetExportJobResponse$id' => '<p>The job\'s ID.</p>', ], ], 'ExportReadSet' => [ 'base' => '<p>A read set.</p>', 'refs' => [ 'StartReadSetExportJobRequestSourcesList$member' => NULL, ], ], 'ExportReadSetDetail' => [ 'base' => '<p>Details about a read set.</p>', 'refs' => [ 'ExportReadSetDetailList$member' => NULL, ], ], 'ExportReadSetDetailList' => [ 'base' => NULL, 'refs' => [ 'GetReadSetExportJobResponse$readSets' => '<p>The job\'s read sets.</p>', ], ], 'ExportReadSetFilter' => [ 'base' => '<p>An read set export job filter.</p>', 'refs' => [ 'ListReadSetExportJobsRequest$filter' => '<p>A filter to apply to the list.</p>', ], ], 'ExportReadSetJobDetail' => [ 'base' => '<p>Details about a read set export job.</p>', 'refs' => [ 'ExportReadSetJobDetailList$member' => NULL, ], ], 'ExportReadSetJobDetailList' => [ 'base' => NULL, 'refs' => [ 'ListReadSetExportJobsResponse$exportJobs' => '<p>A list of jobs.</p>', ], ], 'FileInformation' => [ 'base' => '<p>Details about a file.</p>', 'refs' => [ 'ReadSetFiles$source1' => '<p>The location of the first file in Amazon S3.</p>', 'ReadSetFiles$source2' => '<p>The location of the second file in Amazon S3.</p>', 'ReadSetFiles$index' => '<p>The files\' index.</p>', 'ReferenceFiles$source' => '<p>The source file\'s location in Amazon S3.</p>', 'ReferenceFiles$index' => '<p>The files\' index.</p>', ], ], 'FileInformationContentLengthLong' => [ 'base' => NULL, 'refs' => [ 'FileInformation$contentLength' => '<p>The file\'s content length.</p>', ], ], 'FileInformationPartSizeLong' => [ 'base' => NULL, 'refs' => [ 'FileInformation$partSize' => '<p>The file\'s part size.</p>', ], ], 'FileInformationTotalPartsInteger' => [ 'base' => NULL, 'refs' => [ 'FileInformation$totalParts' => '<p>The file\'s total parts.</p>', ], ], 'FileType' => [ 'base' => NULL, 'refs' => [ 'CreateMultipartReadSetUploadRequest$sourceFileType' => '<p>The type of file being uploaded.</p>', 'CreateMultipartReadSetUploadResponse$sourceFileType' => '<p>The file type of the read set source.</p>', 'GetReadSetMetadataResponse$fileType' => '<p>The read set\'s file type.</p>', 'ImportReadSetSourceItem$sourceFileType' => '<p>The source\'s file type.</p>', 'MultipartReadSetUploadListItem$sourceFileType' => '<p> The type of file the read set originated from. </p>', 'ReadSetListItem$fileType' => '<p>The read set\'s file type.</p>', 'StartReadSetImportJobSourceItem$sourceFileType' => '<p>The source\'s file type.</p>', ], ], 'Filter' => [ 'base' => '<p>Use filters to return a subset of resources. You can define filters for specific parameters, such as the resource status.</p>', 'refs' => [ 'ListSharesRequest$filter' => '<p>Attributes that you use to filter for a specific subset of resource shares.</p>', ], ], 'FormatOptions' => [ 'base' => '<p>Formatting options for a file.</p>', 'refs' => [ 'GetAnnotationImportResponse$formatOptions' => NULL, 'StartAnnotationImportRequest$formatOptions' => '<p>Formatting options for the annotation file.</p>', ], ], 'FormatToHeader' => [ 'base' => NULL, 'refs' => [ 'TsvStoreOptions$formatToHeader' => '<p>The store\'s header key to column name mapping.</p>', 'TsvVersionOptions$formatToHeader' => '<p> The annotation store version\'s header key to column name mapping. </p>', ], ], 'FormatToHeaderKey' => [ 'base' => NULL, 'refs' => [ 'FormatToHeader$key' => NULL, ], ], 'FormatToHeaderValueString' => [ 'base' => NULL, 'refs' => [ 'FormatToHeader$value' => NULL, ], ], 'GeneratedFrom' => [ 'base' => NULL, 'refs' => [ 'CreateMultipartReadSetUploadRequest$generatedFrom' => '<p>Where the source originated.</p>', 'CreateMultipartReadSetUploadResponse$generatedFrom' => '<p>The source of the read set.</p>', 'ImportReadSetSourceItem$generatedFrom' => '<p>Where the source originated.</p>', 'MultipartReadSetUploadListItem$generatedFrom' => '<p> The source of an uploaded part. </p>', 'ReadSetFilter$generatedFrom' => '<p> Where the source originated. </p>', 'SequenceInformation$generatedFrom' => '<p>Where the sequence originated.</p>', 'StartReadSetImportJobSourceItem$generatedFrom' => '<p>Where the source originated.</p>', ], ], 'GetAnnotationImportRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAnnotationImportResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetAnnotationStoreRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAnnotationStoreResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetAnnotationStoreVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAnnotationStoreVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetReadSetActivationJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetReadSetActivationJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetReadSetExportJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetReadSetExportJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetReadSetImportJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetReadSetImportJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetReadSetMetadataRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetReadSetMetadataResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetReadSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetReadSetRequestPartNumberInteger' => [ 'base' => NULL, 'refs' => [ 'GetReadSetRequest$partNumber' => '<p>The part number to retrieve.</p>', ], ], 'GetReadSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetReferenceImportJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetReferenceImportJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetReferenceMetadataRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetReferenceMetadataResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetReferenceRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetReferenceRequestPartNumberInteger' => [ 'base' => NULL, 'refs' => [ 'GetReferenceRequest$partNumber' => '<p>The part number to retrieve.</p>', ], ], 'GetReferenceResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetReferenceStoreRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetReferenceStoreResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetRunGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetRunGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetRunGroupResponseMaxCpusInteger' => [ 'base' => NULL, 'refs' => [ 'GetRunGroupResponse$maxCpus' => '<p>The group\'s maximum number of CPUs to use.</p>', ], ], 'GetRunGroupResponseMaxDurationInteger' => [ 'base' => NULL, 'refs' => [ 'GetRunGroupResponse$maxDuration' => '<p>The group\'s maximum run time in minutes.</p>', ], ], 'GetRunGroupResponseMaxGpusInteger' => [ 'base' => NULL, 'refs' => [ 'GetRunGroupResponse$maxGpus' => '<p>The maximum GPUs that can be used by a run group.</p>', ], ], 'GetRunGroupResponseMaxRunsInteger' => [ 'base' => NULL, 'refs' => [ 'GetRunGroupResponse$maxRuns' => '<p>The maximum number of concurrent runs for the group.</p>', ], ], 'GetRunRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetRunResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetRunResponsePriorityInteger' => [ 'base' => NULL, 'refs' => [ 'GetRunResponse$priority' => '<p>The run\'s priority.</p>', ], ], 'GetRunResponseStorageCapacityInteger' => [ 'base' => NULL, 'refs' => [ 'GetRunResponse$storageCapacity' => '<p>The run\'s storage capacity in gibibytes. For dynamic storage, after the run has completed, this value is the maximum amount of storage used during the run.</p>', ], ], 'GetRunTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetRunTaskResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetRunTaskResponseCpusInteger' => [ 'base' => NULL, 'refs' => [ 'GetRunTaskResponse$cpus' => '<p>The task\'s CPU usage.</p>', ], ], 'GetRunTaskResponseGpusInteger' => [ 'base' => NULL, 'refs' => [ 'GetRunTaskResponse$gpus' => '<p>The number of Graphics Processing Units (GPU) specified in the task.</p>', ], ], 'GetRunTaskResponseMemoryInteger' => [ 'base' => NULL, 'refs' => [ 'GetRunTaskResponse$memory' => '<p>The task\'s memory use in gigabytes.</p>', ], ], 'GetSequenceStoreRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSequenceStoreResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetShareRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetShareResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetVariantImportRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetVariantImportResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetVariantStoreRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetVariantStoreResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetWorkflowRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetWorkflowResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetWorkflowResponseStorageCapacityInteger' => [ 'base' => NULL, 'refs' => [ 'GetWorkflowResponse$storageCapacity' => '<p>The workflow\'s storage capacity in gibibytes.</p>', ], ], 'Header' => [ 'base' => NULL, 'refs' => [ 'ReadOptions$header' => '<p>Whether the file has a header row.</p>', ], ], 'ImportJobId' => [ 'base' => NULL, 'refs' => [ 'GetReadSetImportJobRequest$id' => '<p>The job\'s ID.</p>', 'GetReadSetImportJobResponse$id' => '<p>The job\'s ID.</p>', 'GetReferenceImportJobRequest$id' => '<p>The job\'s ID.</p>', 'GetReferenceImportJobResponse$id' => '<p>The job\'s ID.</p>', 'ImportReadSetJobItem$id' => '<p>The job\'s ID.</p>', 'ImportReferenceJobItem$id' => '<p>The job\'s ID.</p>', 'StartReadSetImportJobResponse$id' => '<p>The job\'s ID.</p>', 'StartReferenceImportJobResponse$id' => '<p>The job\'s ID.</p>', ], ], 'ImportReadSetFilter' => [ 'base' => '<p>A filter for import read set jobs.</p>', 'refs' => [ 'ListReadSetImportJobsRequest$filter' => '<p>A filter to apply to the list.</p>', ], ], 'ImportReadSetJobItem' => [ 'base' => '<p>An import read set job.</p>', 'refs' => [ 'ImportReadSetJobList$member' => NULL, ], ], 'ImportReadSetJobList' => [ 'base' => NULL, 'refs' => [ 'ListReadSetImportJobsResponse$importJobs' => '<p>A list of jobs.</p>', ], ], 'ImportReadSetSourceItem' => [ 'base' => '<p>A source for an import read set job.</p>', 'refs' => [ 'ImportReadSetSourceList$member' => NULL, ], ], 'ImportReadSetSourceList' => [ 'base' => NULL, 'refs' => [ 'GetReadSetImportJobResponse$sources' => '<p>The job\'s source files.</p>', ], ], 'ImportReferenceFilter' => [ 'base' => '<p>A filter for import references.</p>', 'refs' => [ 'ListReferenceImportJobsRequest$filter' => '<p>A filter to apply to the list.</p>', ], ], 'ImportReferenceJobItem' => [ 'base' => '<p>An import reference job.</p>', 'refs' => [ 'ImportReferenceJobList$member' => NULL, ], ], 'ImportReferenceJobList' => [ 'base' => NULL, 'refs' => [ 'ListReferenceImportJobsResponse$importJobs' => '<p>A lis of jobs.</p>', ], ], 'ImportReferenceSourceItem' => [ 'base' => '<p>An genome reference source.</p>', 'refs' => [ 'ImportReferenceSourceList$member' => NULL, ], ], 'ImportReferenceSourceList' => [ 'base' => NULL, 'refs' => [ 'GetReferenceImportJobResponse$sources' => '<p>The job\'s source files.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'GetAnnotationStoreResponse$numVersions' => '<p> An integer indicating how many versions of an annotation store exist. </p>', 'ListSharesRequest$maxResults' => '<p>The maximum number of shares to return in one page of results.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>An unexpected error occurred. Try the request again.</p>', 'refs' => [], ], 'JobStatus' => [ 'base' => NULL, 'refs' => [ 'AnnotationImportItemDetail$jobStatus' => '<p>The item\'s job status.</p>', 'AnnotationImportJobItem$status' => '<p>The job\'s status.</p>', 'GetAnnotationImportResponse$status' => '<p>The job\'s status.</p>', 'GetVariantImportResponse$status' => '<p>The job\'s status.</p>', 'ListAnnotationImportJobsFilter$status' => '<p>A status to filter on.</p>', 'ListVariantImportJobsFilter$status' => '<p>A status to filter on.</p>', 'VariantImportItemDetail$jobStatus' => '<p>The item\'s job status.</p>', 'VariantImportJobItem$status' => '<p>The job\'s status.</p>', ], ], 'JobStatusMessage' => [ 'base' => NULL, 'refs' => [ 'ActivateReadSetSourceItem$statusMessage' => '<p>The source\'s status message.</p>', 'ExportReadSetDetail$statusMessage' => '<p>The set\'s status message.</p>', 'GetReadSetActivationJobResponse$statusMessage' => '<p>The job\'s status message.</p>', 'GetReadSetExportJobResponse$statusMessage' => '<p>The job\'s status message.</p>', 'GetReadSetImportJobResponse$statusMessage' => '<p>The job\'s status message.</p>', 'GetReferenceImportJobResponse$statusMessage' => '<p>The job\'s status message.</p>', 'ImportReadSetSourceItem$statusMessage' => '<p>The source\'s status message.</p>', 'ImportReferenceSourceItem$statusMessage' => '<p>The source\'s status message.</p>', ], ], 'JobStatusMsg' => [ 'base' => NULL, 'refs' => [ 'GetAnnotationImportResponse$statusMessage' => '<p>The job\'s status message.</p>', 'GetVariantImportResponse$statusMessage' => '<p>The job\'s status message.</p>', 'VariantImportItemDetail$statusMessage' => '<p> A message that provides additional context about a job </p>', ], ], 'LineSep' => [ 'base' => NULL, 'refs' => [ 'ReadOptions$lineSep' => '<p>A line separator for the file.</p>', ], ], 'ListAnnotationImportJobsFilter' => [ 'base' => '<p>A filter for annotation import jobs.</p>', 'refs' => [ 'ListAnnotationImportJobsRequest$filter' => '<p>A filter to apply to the list.</p>', ], ], 'ListAnnotationImportJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAnnotationImportJobsRequestIdsList' => [ 'base' => NULL, 'refs' => [ 'ListAnnotationImportJobsRequest$ids' => '<p>IDs of annotation import jobs to retrieve.</p>', ], ], 'ListAnnotationImportJobsRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListAnnotationImportJobsRequest$maxResults' => '<p>The maximum number of jobs to return in one page of results.</p>', ], ], 'ListAnnotationImportJobsRequestNextTokenString' => [ 'base' => NULL, 'refs' => [ 'ListAnnotationImportJobsRequest$nextToken' => '<p>Specifies the pagination token from a previous request to retrieve the next page of results.</p>', ], ], 'ListAnnotationImportJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAnnotationStoreVersionsFilter' => [ 'base' => '<p>Use filters to focus the returned annotation store versions on a specific parameter, such as the status of the annotation store.</p>', 'refs' => [ 'ListAnnotationStoreVersionsRequest$filter' => '<p> A filter to apply to the list of annotation store versions. </p>', ], ], 'ListAnnotationStoreVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAnnotationStoreVersionsRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListAnnotationStoreVersionsRequest$maxResults' => '<p> The maximum number of annotation store versions to return in one page of results. </p>', ], ], 'ListAnnotationStoreVersionsRequestNextTokenString' => [ 'base' => NULL, 'refs' => [ 'ListAnnotationStoreVersionsRequest$nextToken' => '<p> Specifies the pagination token from a previous request to retrieve the next page of results. </p>', ], ], 'ListAnnotationStoreVersionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAnnotationStoresFilter' => [ 'base' => '<p>A filter for annotation stores.</p>', 'refs' => [ 'ListAnnotationStoresRequest$filter' => '<p>A filter to apply to the list.</p>', ], ], 'ListAnnotationStoresRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAnnotationStoresRequestIdsList' => [ 'base' => NULL, 'refs' => [ 'ListAnnotationStoresRequest$ids' => '<p>IDs of stores to list.</p>', ], ], 'ListAnnotationStoresRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListAnnotationStoresRequest$maxResults' => '<p>The maximum number of stores to return in one page of results.</p>', ], ], 'ListAnnotationStoresRequestNextTokenString' => [ 'base' => NULL, 'refs' => [ 'ListAnnotationStoresRequest$nextToken' => '<p>Specify the pagination token from a previous request to retrieve the next page of results.</p>', ], ], 'ListAnnotationStoresResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListMultipartReadSetUploadsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListMultipartReadSetUploadsRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListMultipartReadSetUploadsRequest$maxResults' => '<p>The maximum number of multipart uploads returned in a page.</p>', ], ], 'ListMultipartReadSetUploadsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListReadSetActivationJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListReadSetActivationJobsRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListReadSetActivationJobsRequest$maxResults' => '<p>The maximum number of read set activation jobs to return in one page of results.</p>', ], ], 'ListReadSetActivationJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListReadSetExportJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListReadSetExportJobsRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListReadSetExportJobsRequest$maxResults' => '<p>The maximum number of jobs to return in one page of results.</p>', ], ], 'ListReadSetExportJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListReadSetImportJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListReadSetImportJobsRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListReadSetImportJobsRequest$maxResults' => '<p>The maximum number of jobs to return in one page of results.</p>', ], ], 'ListReadSetImportJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListReadSetUploadPartsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListReadSetUploadPartsRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListReadSetUploadPartsRequest$maxResults' => '<p>The maximum number of read set upload parts returned in a page.</p>', ], ], 'ListReadSetUploadPartsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListReadSetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListReadSetsRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListReadSetsRequest$maxResults' => '<p>The maximum number of read sets to return in one page of results.</p>', ], ], 'ListReadSetsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListReferenceImportJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListReferenceImportJobsRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListReferenceImportJobsRequest$maxResults' => '<p>The maximum number of jobs to return in one page of results.</p>', ], ], 'ListReferenceImportJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListReferenceStoresRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListReferenceStoresRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListReferenceStoresRequest$maxResults' => '<p>The maximum number of stores to return in one page of results.</p>', ], ], 'ListReferenceStoresResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListReferencesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListReferencesRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListReferencesRequest$maxResults' => '<p>The maximum number of references to return in one page of results.</p>', ], ], 'ListReferencesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListRunGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRunGroupsRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListRunGroupsRequest$maxResults' => '<p>The maximum number of run groups to return in one page of results.</p>', ], ], 'ListRunGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListRunTasksRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRunTasksRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListRunTasksRequest$maxResults' => '<p>The maximum number of run tasks to return in one page of results.</p>', ], ], 'ListRunTasksResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListRunsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRunsRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListRunsRequest$maxResults' => '<p>The maximum number of runs to return in one page of results.</p>', ], ], 'ListRunsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSequenceStoresRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSequenceStoresRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListSequenceStoresRequest$maxResults' => '<p>The maximum number of stores to return in one page of results.</p>', ], ], 'ListSequenceStoresResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSharesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSharesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListVariantImportJobsFilter' => [ 'base' => '<p>A filter for variant import jobs.</p>', 'refs' => [ 'ListVariantImportJobsRequest$filter' => '<p>A filter to apply to the list.</p>', ], ], 'ListVariantImportJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListVariantImportJobsRequestIdsList' => [ 'base' => NULL, 'refs' => [ 'ListVariantImportJobsRequest$ids' => '<p>A list of job IDs.</p>', ], ], 'ListVariantImportJobsRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListVariantImportJobsRequest$maxResults' => '<p>The maximum number of import jobs to return in one page of results.</p>', ], ], 'ListVariantImportJobsRequestNextTokenString' => [ 'base' => NULL, 'refs' => [ 'ListVariantImportJobsRequest$nextToken' => '<p>Specify the pagination token from a previous request to retrieve the next page of results.</p>', ], ], 'ListVariantImportJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListVariantStoresFilter' => [ 'base' => '<p>A filter for variant stores.</p>', 'refs' => [ 'ListVariantStoresRequest$filter' => '<p>A filter to apply to the list.</p>', ], ], 'ListVariantStoresRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListVariantStoresRequestIdsList' => [ 'base' => NULL, 'refs' => [ 'ListVariantStoresRequest$ids' => '<p>A list of store IDs.</p>', ], ], 'ListVariantStoresRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListVariantStoresRequest$maxResults' => '<p>The maximum number of stores to return in one page of results.</p>', ], ], 'ListVariantStoresRequestNextTokenString' => [ 'base' => NULL, 'refs' => [ 'ListVariantStoresRequest$nextToken' => '<p>Specify the pagination token from a previous request to retrieve the next page of results.</p>', ], ], 'ListVariantStoresResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkflowsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkflowsRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListWorkflowsRequest$maxResults' => '<p>The maximum number of workflows to return in one page of results.</p>', ], ], 'ListWorkflowsResponse' => [ 'base' => NULL, 'refs' => [], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'AnnotationStoreItem$storeSizeBytes' => '<p>The store\'s size in bytes.</p>', 'AnnotationStoreVersionItem$versionSizeBytes' => '<p> The size of an annotation store version in Bytes. </p>', 'GetAnnotationStoreResponse$storeSizeBytes' => '<p>The store\'s size in bytes.</p>', 'GetAnnotationStoreVersionResponse$versionSizeBytes' => '<p> The size of the annotation store version in Bytes. </p>', 'GetVariantStoreResponse$storeSizeBytes' => '<p>The store\'s size in bytes.</p>', 'SequenceInformation$totalReadCount' => '<p>The sequence\'s total read count.</p>', 'SequenceInformation$totalBaseCount' => '<p>The sequence\'s total base count.</p>', 'VariantStoreItem$storeSizeBytes' => '<p>The store\'s size in bytes.</p>', ], ], 'Md5' => [ 'base' => NULL, 'refs' => [ 'GetReferenceMetadataResponse$md5' => '<p>The reference\'s MD5 checksum.</p>', 'ReferenceFilter$md5' => '<p>An MD5 checksum to filter on.</p>', 'ReferenceListItem$md5' => '<p>The reference\'s MD5 checksum.</p>', ], ], 'MultipartReadSetUploadList' => [ 'base' => NULL, 'refs' => [ 'ListMultipartReadSetUploadsResponse$uploads' => '<p>An array of multipart uploads.</p>', ], ], 'MultipartReadSetUploadListItem' => [ 'base' => '<p> Part of the response to ListMultipartReadSetUploads, excluding completed and aborted multipart uploads. </p>', 'refs' => [ 'MultipartReadSetUploadList$member' => NULL, ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListMultipartReadSetUploadsRequest$nextToken' => '<p>Next token returned in the response of a previous ListMultipartReadSetUploads call. Used to get the next page of results.</p>', 'ListMultipartReadSetUploadsResponse$nextToken' => '<p>Next token returned in the response of a previous ListMultipartReadSetUploads call. Used to get the next page of results.</p>', 'ListReadSetActivationJobsRequest$nextToken' => '<p>Specify the pagination token from a previous request to retrieve the next page of results.</p>', 'ListReadSetActivationJobsResponse$nextToken' => '<p>A pagination token that\'s included if more results are available.</p>', 'ListReadSetExportJobsRequest$nextToken' => '<p>Specify the pagination token from a previous request to retrieve the next page of results.</p>', 'ListReadSetExportJobsResponse$nextToken' => '<p>A pagination token that\'s included if more results are available.</p>', 'ListReadSetImportJobsRequest$nextToken' => '<p>Specify the pagination token from a previous request to retrieve the next page of results.</p>', 'ListReadSetImportJobsResponse$nextToken' => '<p>A pagination token that\'s included if more results are available.</p>', 'ListReadSetUploadPartsRequest$nextToken' => '<p>Next token returned in the response of a previous ListReadSetUploadPartsRequest call. Used to get the next page of results.</p>', 'ListReadSetUploadPartsResponse$nextToken' => '<p>Next token returned in the response of a previous ListReadSetUploadParts call. Used to get the next page of results.</p>', 'ListReadSetsRequest$nextToken' => '<p>Specify the pagination token from a previous request to retrieve the next page of results.</p>', 'ListReadSetsResponse$nextToken' => '<p>A pagination token that\'s included if more results are available.</p>', 'ListReferenceImportJobsRequest$nextToken' => '<p>Specify the pagination token from a previous request to retrieve the next page of results.</p>', 'ListReferenceImportJobsResponse$nextToken' => '<p>A pagination token that\'s included if more results are available.</p>', 'ListReferenceStoresRequest$nextToken' => '<p>Specify the pagination token from a previous request to retrieve the next page of results.</p>', 'ListReferenceStoresResponse$nextToken' => '<p>A pagination token that\'s included if more results are available.</p>', 'ListReferencesRequest$nextToken' => '<p>Specify the pagination token from a previous request to retrieve the next page of results.</p>', 'ListReferencesResponse$nextToken' => '<p>A pagination token that\'s included if more results are available.</p>', 'ListSequenceStoresRequest$nextToken' => '<p>Specify the pagination token from a previous request to retrieve the next page of results.</p>', 'ListSequenceStoresResponse$nextToken' => '<p>A pagination token that\'s included if more results are available.</p>', ], ], 'NotSupportedOperationException' => [ 'base' => '<p> The operation is not supported by Amazon Omics, or the API does not exist. </p>', 'refs' => [], ], 'PrimitiveBoolean' => [ 'base' => NULL, 'refs' => [ 'DeleteAnnotationStoreRequest$force' => '<p>Whether to force deletion.</p>', 'DeleteAnnotationStoreVersionsRequest$force' => '<p> Forces the deletion of an annotation store version when imports are in-progress.. </p>', 'DeleteVariantStoreRequest$force' => '<p>Whether to force deletion.</p>', ], ], 'Quote' => [ 'base' => NULL, 'refs' => [ 'ReadOptions$quote' => '<p>The file\'s quote character.</p>', ], ], 'QuoteAll' => [ 'base' => NULL, 'refs' => [ 'ReadOptions$quoteAll' => '<p>Whether all values need to be quoted, or just those that contain quotes.</p>', ], ], 'Range' => [ 'base' => NULL, 'refs' => [ 'GetReferenceRequest$range' => '<p>The range to retrieve.</p>', ], ], 'RangeNotSatisfiableException' => [ 'base' => '<p>The ranges specified in the request are not valid.</p>', 'refs' => [], ], 'ReadOptions' => [ 'base' => '<p>Read options for an annotation import job.</p>', 'refs' => [ 'TsvOptions$readOptions' => '<p>The file\'s read options.</p>', ], ], 'ReadSetActivationJobItemStatus' => [ 'base' => NULL, 'refs' => [ 'ActivateReadSetSourceItem$status' => '<p>The source\'s status.</p>', ], ], 'ReadSetActivationJobStatus' => [ 'base' => NULL, 'refs' => [ 'ActivateReadSetFilter$status' => '<p>The filter\'s status.</p>', 'ActivateReadSetJobItem$status' => '<p>The job\'s status.</p>', 'GetReadSetActivationJobResponse$status' => '<p>The job\'s status.</p>', 'StartReadSetActivationJobResponse$status' => '<p>The job\'s status.</p>', ], ], 'ReadSetArn' => [ 'base' => NULL, 'refs' => [ 'GetReadSetMetadataResponse$arn' => '<p>The read set\'s ARN.</p>', 'ReadSetListItem$arn' => '<p>The read set\'s ARN.</p>', ], ], 'ReadSetBatchError' => [ 'base' => '<p>An error from a batch read set operation.</p>', 'refs' => [ 'ReadSetBatchErrorList$member' => NULL, ], ], 'ReadSetBatchErrorList' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteReadSetResponse$errors' => '<p>Errors returned by individual delete operations.</p>', ], ], 'ReadSetDescription' => [ 'base' => NULL, 'refs' => [ 'CreateMultipartReadSetUploadRequest$description' => '<p>The description of the read set.</p>', 'CreateMultipartReadSetUploadResponse$description' => '<p>The description of the read set.</p>', 'GetReadSetMetadataResponse$description' => '<p>The read set\'s description.</p>', 'ImportReadSetSourceItem$description' => '<p>The source\'s description.</p>', 'MultipartReadSetUploadListItem$description' => '<p> The description of a read set. </p>', 'ReadSetListItem$description' => '<p>The read set\'s description.</p>', 'StartReadSetImportJobSourceItem$description' => '<p>The source\'s description.</p>', ], ], 'ReadSetExportJobItemStatus' => [ 'base' => NULL, 'refs' => [ 'ExportReadSetDetail$status' => '<p>The set\'s status.</p>', ], ], 'ReadSetExportJobStatus' => [ 'base' => NULL, 'refs' => [ 'ExportReadSetFilter$status' => '<p>A status to filter on.</p>', 'ExportReadSetJobDetail$status' => '<p>The job\'s status.</p>', 'GetReadSetExportJobResponse$status' => '<p>The job\'s status.</p>', 'StartReadSetExportJobResponse$status' => '<p>The job\'s status.</p>', ], ], 'ReadSetFile' => [ 'base' => NULL, 'refs' => [ 'GetReadSetRequest$file' => '<p>The file to retrieve.</p>', ], ], 'ReadSetFiles' => [ 'base' => '<p>Files in a read set.</p>', 'refs' => [ 'GetReadSetMetadataResponse$files' => '<p>The read set\'s files.</p>', ], ], 'ReadSetFilter' => [ 'base' => '<p>A filter for read sets.</p>', 'refs' => [ 'ListReadSetsRequest$filter' => '<p>A filter to apply to the list.</p>', ], ], 'ReadSetId' => [ 'base' => NULL, 'refs' => [ 'ActivateReadSetSourceItem$readSetId' => '<p>The source\'s read set ID.</p>', 'CompleteMultipartReadSetUploadResponse$readSetId' => '<p>The read set ID created for an uploaded read set.</p>', 'ExportReadSet$readSetId' => '<p>The set\'s ID.</p>', 'ExportReadSetDetail$id' => '<p>The set\'s ID.</p>', 'GetReadSetMetadataRequest$id' => '<p>The read set\'s ID.</p>', 'GetReadSetMetadataResponse$id' => '<p>The read set\'s ID.</p>', 'GetReadSetRequest$id' => '<p>The read set\'s ID.</p>', 'ReadSetBatchError$id' => '<p>The error\'s ID.</p>', 'ReadSetIdList$member' => NULL, 'ReadSetListItem$id' => '<p>The read set\'s ID.</p>', 'StartReadSetActivationJobSourceItem$readSetId' => '<p>The source\'s read set ID.</p>', ], ], 'ReadSetIdList' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteReadSetRequest$ids' => '<p>The read sets\' IDs.</p>', ], ], 'ReadSetImportJobItemStatus' => [ 'base' => NULL, 'refs' => [ 'ImportReadSetSourceItem$status' => '<p>The source\'s status.</p>', ], ], 'ReadSetImportJobStatus' => [ 'base' => NULL, 'refs' => [ 'GetReadSetImportJobResponse$status' => '<p>The job\'s status.</p>', 'ImportReadSetFilter$status' => '<p>A status to filter on.</p>', 'ImportReadSetJobItem$status' => '<p>The job\'s status.</p>', 'StartReadSetImportJobResponse$status' => '<p>The job\'s status.</p>', ], ], 'ReadSetList' => [ 'base' => NULL, 'refs' => [ 'ListReadSetsResponse$readSets' => '<p>A list of read sets.</p>', ], ], 'ReadSetListItem' => [ 'base' => '<p>A read set.</p>', 'refs' => [ 'ReadSetList$member' => NULL, ], ], 'ReadSetName' => [ 'base' => NULL, 'refs' => [ 'CreateMultipartReadSetUploadRequest$name' => '<p>The name of the read set.</p>', 'CreateMultipartReadSetUploadResponse$name' => '<p>The name of the read set.</p>', 'GetReadSetMetadataResponse$name' => '<p>The read set\'s name.</p>', 'ImportReadSetSourceItem$name' => '<p>The source\'s name.</p>', 'MultipartReadSetUploadListItem$name' => '<p> The name of a read set. </p>', 'ReadSetFilter$name' => '<p>A name to filter on.</p>', 'ReadSetListItem$name' => '<p>The read set\'s name.</p>', 'StartReadSetImportJobSourceItem$name' => '<p>The source\'s name.</p>', ], ], 'ReadSetPartSource' => [ 'base' => NULL, 'refs' => [ 'CompleteReadSetUploadPartListItem$partSource' => '<p> The source file of the part being uploaded. </p>', 'ListReadSetUploadPartsRequest$partSource' => '<p>The source file for the upload part.</p>', 'ReadSetUploadPartListItem$partSource' => '<p> The origin of the part being direct uploaded. </p>', 'UploadReadSetPartRequest$partSource' => '<p>The source file for an upload part.</p>', ], ], 'ReadSetPartStreamingBlob' => [ 'base' => NULL, 'refs' => [ 'UploadReadSetPartRequest$payload' => '<p>The read set data to upload for a part.</p>', ], ], 'ReadSetS3Access' => [ 'base' => '<p>The S3 URI for each read set file.</p>', 'refs' => [ 'FileInformation$s3Access' => '<p>The S3 URI metadata of a sequence store.</p>', ], ], 'ReadSetStatus' => [ 'base' => NULL, 'refs' => [ 'GetReadSetMetadataResponse$status' => '<p>The read set\'s status.</p>', 'ReadSetFilter$status' => '<p>A status to filter on.</p>', 'ReadSetListItem$status' => '<p>The read set\'s status.</p>', ], ], 'ReadSetStatusMessage' => [ 'base' => NULL, 'refs' => [ 'GetReadSetMetadataResponse$statusMessage' => '<p>The status message for a read set. It provides more detail as to why the read set has a status. </p>', 'ReadSetListItem$statusMessage' => '<p> The status for a read set. It provides more detail as to why the read set has a status. </p>', ], ], 'ReadSetStreamingBlob' => [ 'base' => NULL, 'refs' => [ 'GetReadSetResponse$payload' => '<p>The read set file payload.</p>', ], ], 'ReadSetUploadPartList' => [ 'base' => NULL, 'refs' => [ 'ListReadSetUploadPartsResponse$parts' => '<p>An array of upload parts.</p>', ], ], 'ReadSetUploadPartListFilter' => [ 'base' => '<p> Filter settings that select for read set upload parts of interest. </p>', 'refs' => [ 'ListReadSetUploadPartsRequest$filter' => '<p>Attributes used to filter for a specific subset of read set part uploads.</p>', ], ], 'ReadSetUploadPartListItem' => [ 'base' => '<p> The metadata of a single part of a file that was added to a multipart upload. A list of these parts is returned in the response to the ListReadSetUploadParts API. </p>', 'refs' => [ 'ReadSetUploadPartList$member' => NULL, ], ], 'ReadSetUploadPartListItemPartNumberInteger' => [ 'base' => NULL, 'refs' => [ 'ReadSetUploadPartListItem$partNumber' => '<p> The number identifying the part in an upload. </p>', ], ], 'ReadSetUploadPartListItemPartSizeLong' => [ 'base' => NULL, 'refs' => [ 'ReadSetUploadPartListItem$partSize' => '<p> The size of the the part in an upload. </p>', ], ], 'ReferenceArn' => [ 'base' => NULL, 'refs' => [ 'CreateMultipartReadSetUploadRequest$referenceArn' => '<p>The ARN of the reference.</p>', 'CreateMultipartReadSetUploadResponse$referenceArn' => '<p>The read set source\'s reference ARN.</p>', 'GetReadSetMetadataResponse$referenceArn' => '<p>The read set\'s genome reference ARN.</p>', 'GetReferenceMetadataResponse$arn' => '<p>The reference\'s ARN.</p>', 'ImportReadSetSourceItem$referenceArn' => '<p>The source\'s genome reference ARN.</p>', 'MultipartReadSetUploadListItem$referenceArn' => '<p> The source\'s reference ARN. </p>', 'ReadSetListItem$referenceArn' => '<p>The read set\'s genome reference ARN.</p>', 'ReferenceItem$referenceArn' => '<p>The reference\'s ARN.</p>', 'ReferenceListItem$arn' => '<p>The reference\'s ARN.</p>', 'StartReadSetImportJobSourceItem$referenceArn' => '<p>The source\'s reference ARN.</p>', ], ], 'ReferenceArnFilter' => [ 'base' => NULL, 'refs' => [ 'ReadSetFilter$referenceArn' => '<p>A genome reference ARN to filter on.</p>', ], ], 'ReferenceDescription' => [ 'base' => NULL, 'refs' => [ 'GetReferenceMetadataResponse$description' => '<p>The reference\'s description.</p>', 'ImportReferenceSourceItem$description' => '<p>The source\'s description.</p>', 'ReferenceListItem$description' => '<p>The reference\'s description.</p>', 'StartReferenceImportJobSourceItem$description' => '<p>The source\'s description.</p>', ], ], 'ReferenceFile' => [ 'base' => NULL, 'refs' => [ 'GetReferenceRequest$file' => '<p>The file to retrieve.</p>', ], ], 'ReferenceFiles' => [ 'base' => '<p>A set of genome reference files.</p>', 'refs' => [ 'GetReferenceMetadataResponse$files' => '<p>The reference\'s files.</p>', ], ], 'ReferenceFilter' => [ 'base' => '<p>A filter for references.</p>', 'refs' => [ 'ListReferencesRequest$filter' => '<p>A filter to apply to the list.</p>', ], ], 'ReferenceId' => [ 'base' => NULL, 'refs' => [ 'DeleteReferenceRequest$id' => '<p>The reference\'s ID.</p>', 'GetReferenceMetadataRequest$id' => '<p>The reference\'s ID.</p>', 'GetReferenceMetadataResponse$id' => '<p>The reference\'s ID.</p>', 'GetReferenceRequest$id' => '<p>The reference\'s ID.</p>', 'ReferenceListItem$id' => '<p>The reference\'s ID.</p>', ], ], 'ReferenceImportJobItemStatus' => [ 'base' => NULL, 'refs' => [ 'ImportReferenceSourceItem$status' => '<p>The source\'s status.</p>', ], ], 'ReferenceImportJobStatus' => [ 'base' => NULL, 'refs' => [ 'GetReferenceImportJobResponse$status' => '<p>The job\'s status.</p>', 'ImportReferenceFilter$status' => '<p>A status to filter on.</p>', 'ImportReferenceJobItem$status' => '<p>The job\'s status.</p>', 'StartReferenceImportJobResponse$status' => '<p>The job\'s status.</p>', ], ], 'ReferenceItem' => [ 'base' => '<p>A genome reference.</p>', 'refs' => [ 'AnnotationStoreItem$reference' => '<p>The store\'s genome reference.</p>', 'CreateAnnotationStoreRequest$reference' => '<p>The genome reference for the store\'s annotations.</p>', 'CreateAnnotationStoreResponse$reference' => '<p>The store\'s genome reference. Required for all stores except TSV format with generic annotations.</p>', 'CreateVariantStoreRequest$reference' => '<p>The genome reference for the store\'s variants.</p>', 'CreateVariantStoreResponse$reference' => '<p>The store\'s genome reference.</p>', 'GetAnnotationStoreResponse$reference' => '<p>The store\'s genome reference.</p>', 'GetVariantStoreResponse$reference' => '<p>The store\'s genome reference.</p>', 'UpdateAnnotationStoreResponse$reference' => '<p>The store\'s genome reference.</p>', 'UpdateVariantStoreResponse$reference' => '<p>The store\'s genome reference.</p>', 'VariantStoreItem$reference' => '<p>The store\'s genome reference.</p>', ], ], 'ReferenceList' => [ 'base' => NULL, 'refs' => [ 'ListReferencesResponse$references' => '<p>A list of references.</p>', ], ], 'ReferenceListItem' => [ 'base' => '<p>A genome reference.</p>', 'refs' => [ 'ReferenceList$member' => NULL, ], ], 'ReferenceName' => [ 'base' => NULL, 'refs' => [ 'GetReferenceMetadataResponse$name' => '<p>The reference\'s name.</p>', 'ImportReferenceSourceItem$name' => '<p>The source\'s name.</p>', 'ReferenceFilter$name' => '<p>A name to filter on.</p>', 'ReferenceListItem$name' => '<p>The reference\'s name.</p>', 'StartReferenceImportJobSourceItem$name' => '<p>The source\'s name.</p>', ], ], 'ReferenceStatus' => [ 'base' => NULL, 'refs' => [ 'GetReferenceMetadataResponse$status' => '<p>The reference\'s status.</p>', 'ReferenceListItem$status' => '<p>The reference\'s status.</p>', ], ], 'ReferenceStoreArn' => [ 'base' => NULL, 'refs' => [ 'CreateReferenceStoreResponse$arn' => '<p>The store\'s ARN.</p>', 'GetReferenceStoreResponse$arn' => '<p>The store\'s ARN.</p>', 'ReferenceStoreDetail$arn' => '<p>The store\'s ARN.</p>', ], ], 'ReferenceStoreDescription' => [ 'base' => NULL, 'refs' => [ 'CreateReferenceStoreRequest$description' => '<p>A description for the store.</p>', 'CreateReferenceStoreResponse$description' => '<p>The store\'s description.</p>', 'GetReferenceStoreResponse$description' => '<p>The store\'s description.</p>', 'ReferenceStoreDetail$description' => '<p>The store\'s description.</p>', ], ], 'ReferenceStoreDetail' => [ 'base' => '<p>Details about a reference store.</p>', 'refs' => [ 'ReferenceStoreDetailList$member' => NULL, ], ], 'ReferenceStoreDetailList' => [ 'base' => NULL, 'refs' => [ 'ListReferenceStoresResponse$referenceStores' => '<p>A list of reference stores.</p>', ], ], 'ReferenceStoreFilter' => [ 'base' => '<p>A filter for reference stores.</p>', 'refs' => [ 'ListReferenceStoresRequest$filter' => '<p>A filter to apply to the list.</p>', ], ], 'ReferenceStoreId' => [ 'base' => NULL, 'refs' => [ 'CreateReferenceStoreResponse$id' => '<p>The store\'s ID.</p>', 'DeleteReferenceRequest$referenceStoreId' => '<p>The reference\'s store ID.</p>', 'DeleteReferenceStoreRequest$id' => '<p>The store\'s ID.</p>', 'GetReferenceImportJobRequest$referenceStoreId' => '<p>The job\'s reference store ID.</p>', 'GetReferenceImportJobResponse$referenceStoreId' => '<p>The job\'s reference store ID.</p>', 'GetReferenceMetadataRequest$referenceStoreId' => '<p>The reference\'s reference store ID.</p>', 'GetReferenceMetadataResponse$referenceStoreId' => '<p>The reference\'s reference store ID.</p>', 'GetReferenceRequest$referenceStoreId' => '<p>The reference\'s store ID.</p>', 'GetReferenceStoreRequest$id' => '<p>The store\'s ID.</p>', 'GetReferenceStoreResponse$id' => '<p>The store\'s ID.</p>', 'ImportReferenceJobItem$referenceStoreId' => '<p>The job\'s reference store ID.</p>', 'ListReferenceImportJobsRequest$referenceStoreId' => '<p>The job\'s reference store ID.</p>', 'ListReferencesRequest$referenceStoreId' => '<p>The references\' reference store ID.</p>', 'ReferenceListItem$referenceStoreId' => '<p>The reference\'s store ID.</p>', 'ReferenceStoreDetail$id' => '<p>The store\'s ID.</p>', 'StartReferenceImportJobRequest$referenceStoreId' => '<p>The job\'s reference store ID.</p>', 'StartReferenceImportJobResponse$referenceStoreId' => '<p>The job\'s reference store ID.</p>', ], ], 'ReferenceStoreName' => [ 'base' => NULL, 'refs' => [ 'CreateReferenceStoreRequest$name' => '<p>A name for the store.</p>', 'CreateReferenceStoreResponse$name' => '<p>The store\'s name.</p>', 'GetReferenceStoreResponse$name' => '<p>The store\'s name.</p>', 'ReferenceStoreDetail$name' => '<p>The store\'s name.</p>', 'ReferenceStoreFilter$name' => '<p>The name to filter on.</p>', ], ], 'ReferenceStreamingBlob' => [ 'base' => NULL, 'refs' => [ 'GetReferenceResponse$payload' => '<p>The reference file payload.</p>', ], ], 'RequestTimeoutException' => [ 'base' => '<p>The request timed out.</p>', 'refs' => [], ], 'ResourceId' => [ 'base' => NULL, 'refs' => [ 'AnnotationStoreItem$id' => '<p>The store\'s ID.</p>', 'AnnotationStoreVersionItem$storeId' => '<p> The store ID for an annotation store version. </p>', 'AnnotationStoreVersionItem$id' => '<p> The annotation store version ID. </p>', 'CancelAnnotationImportRequest$jobId' => '<p>The job\'s ID.</p>', 'CancelVariantImportRequest$jobId' => '<p>The job\'s ID.</p>', 'CreateAnnotationStoreResponse$id' => '<p>The store\'s ID.</p>', 'CreateAnnotationStoreVersionResponse$id' => '<p> A generated ID for the annotation store </p>', 'CreateAnnotationStoreVersionResponse$storeId' => '<p> The ID for the annotation store from which new versions are being created. </p>', 'CreateVariantStoreResponse$id' => '<p>The store\'s ID.</p>', 'GetAnnotationImportRequest$jobId' => '<p>The job\'s ID.</p>', 'GetAnnotationImportResponse$id' => '<p>The job\'s ID.</p>', 'GetAnnotationStoreResponse$id' => '<p>The store\'s ID.</p>', 'GetAnnotationStoreVersionResponse$storeId' => '<p> The store ID for annotation store version. </p>', 'GetAnnotationStoreVersionResponse$id' => '<p> The annotation store version ID. </p>', 'GetVariantImportRequest$jobId' => '<p>The job\'s ID.</p>', 'GetVariantImportResponse$id' => '<p>The job\'s ID.</p>', 'GetVariantStoreResponse$id' => '<p>The store\'s ID.</p>', 'StartAnnotationImportResponse$jobId' => '<p>The job\'s ID.</p>', 'StartVariantImportResponse$jobId' => '<p>The job\'s ID.</p>', 'UpdateAnnotationStoreResponse$id' => '<p>The store\'s ID.</p>', 'UpdateAnnotationStoreVersionResponse$storeId' => '<p> The annotation store ID. </p>', 'UpdateAnnotationStoreVersionResponse$id' => '<p> The annotation store version ID. </p>', 'UpdateVariantStoreResponse$id' => '<p>The store\'s ID.</p>', 'VariantStoreItem$id' => '<p>The store\'s ID.</p>', ], ], 'ResourceIdentifier' => [ 'base' => NULL, 'refs' => [ 'ListAnnotationImportJobsRequestIdsList$member' => NULL, 'ListAnnotationStoresRequestIdsList$member' => NULL, 'ListVariantImportJobsRequestIdsList$member' => NULL, 'ListVariantStoresRequestIdsList$member' => NULL, ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The target resource was not found in the current Region.</p>', 'refs' => [], ], 'ResourceOwner' => [ 'base' => NULL, 'refs' => [ 'ListSharesRequest$resourceOwner' => '<p>The account that owns the resource shares.</p>', ], ], 'RoleArn' => [ 'base' => NULL, 'refs' => [ 'GetReadSetImportJobResponse$roleArn' => '<p>The job\'s service role ARN.</p>', 'GetReferenceImportJobResponse$roleArn' => '<p>The job\'s service role ARN.</p>', 'ImportReadSetJobItem$roleArn' => '<p>The job\'s service role ARN.</p>', 'ImportReferenceJobItem$roleArn' => '<p>The job\'s service role ARN.</p>', 'StartReadSetExportJobRequest$roleArn' => '<p>A service role for the job.</p>', 'StartReadSetImportJobRequest$roleArn' => '<p>A service role for the job.</p>', 'StartReadSetImportJobResponse$roleArn' => '<p>The job\'s service role ARN.</p>', 'StartReferenceImportJobRequest$roleArn' => '<p>A service role for the job.</p>', 'StartReferenceImportJobResponse$roleArn' => '<p>The job\'s service role ARN.</p>', ], ], 'RunArn' => [ 'base' => NULL, 'refs' => [ 'GetRunResponse$arn' => '<p>The run\'s ARN.</p>', 'RunListItem$arn' => '<p>The run\'s ARN.</p>', 'StartRunResponse$arn' => '<p>The run\'s ARN.</p>', ], ], 'RunExport' => [ 'base' => NULL, 'refs' => [ 'RunExportList$member' => NULL, ], ], 'RunExportList' => [ 'base' => NULL, 'refs' => [ 'GetRunRequest$export' => '<p>The run\'s export format.</p>', ], ], 'RunFailureReason' => [ 'base' => NULL, 'refs' => [ 'GetRunResponse$failureReason' => '<p>The reason a run has failed.</p>', ], ], 'RunGroupArn' => [ 'base' => NULL, 'refs' => [ 'CreateRunGroupResponse$arn' => '<p>The group\'s ARN.</p>', 'GetRunGroupResponse$arn' => '<p>The group\'s ARN.</p>', 'RunGroupListItem$arn' => '<p>The group\'s ARN.</p>', ], ], 'RunGroupId' => [ 'base' => NULL, 'refs' => [ 'CreateRunGroupResponse$id' => '<p>The group\'s ID.</p>', 'DeleteRunGroupRequest$id' => '<p>The run group\'s ID.</p>', 'GetRunGroupRequest$id' => '<p>The group\'s ID.</p>', 'GetRunGroupResponse$id' => '<p>The group\'s ID.</p>', 'GetRunResponse$runGroupId' => '<p>The run\'s group ID.</p>', 'ListRunsRequest$runGroupId' => '<p>Filter the list by run group ID.</p>', 'RunGroupListItem$id' => '<p>The group\'s ID.</p>', 'StartRunRequest$runGroupId' => '<p>The run\'s group ID.</p>', 'UpdateRunGroupRequest$id' => '<p>The group\'s ID.</p>', ], ], 'RunGroupList' => [ 'base' => NULL, 'refs' => [ 'ListRunGroupsResponse$items' => '<p>A list of groups.</p>', ], ], 'RunGroupListItem' => [ 'base' => '<p>A run group.</p>', 'refs' => [ 'RunGroupList$member' => NULL, ], ], 'RunGroupListItemMaxCpusInteger' => [ 'base' => NULL, 'refs' => [ 'RunGroupListItem$maxCpus' => '<p>The group\'s maximum CPU count setting.</p>', ], ], 'RunGroupListItemMaxDurationInteger' => [ 'base' => NULL, 'refs' => [ 'RunGroupListItem$maxDuration' => '<p>The group\'s maximum duration setting in minutes.</p>', ], ], 'RunGroupListItemMaxGpusInteger' => [ 'base' => NULL, 'refs' => [ 'RunGroupListItem$maxGpus' => '<p> The maximum GPUs that can be used by a run group. </p>', ], ], 'RunGroupListItemMaxRunsInteger' => [ 'base' => NULL, 'refs' => [ 'RunGroupListItem$maxRuns' => '<p>The group\'s maximum concurrent run setting.</p>', ], ], 'RunGroupListToken' => [ 'base' => NULL, 'refs' => [ 'ListRunGroupsRequest$startingToken' => '<p>Specify the pagination token from a previous request to retrieve the next page of results.</p>', 'ListRunGroupsResponse$nextToken' => '<p>A pagination token that\'s included if more results are available.</p>', ], ], 'RunGroupName' => [ 'base' => NULL, 'refs' => [ 'CreateRunGroupRequest$name' => '<p>A name for the group.</p>', 'GetRunGroupResponse$name' => '<p>The group\'s name.</p>', 'ListRunGroupsRequest$name' => '<p>The run groups\' name.</p>', 'RunGroupListItem$name' => '<p>The group\'s name.</p>', 'UpdateRunGroupRequest$name' => '<p>A name for the group.</p>', ], ], 'RunGroupRequestId' => [ 'base' => NULL, 'refs' => [ 'CreateRunGroupRequest$requestId' => '<p>To ensure that requests don\'t run multiple times, specify a unique ID for each request.</p>', ], ], 'RunGroupTimestamp' => [ 'base' => NULL, 'refs' => [ 'GetRunGroupResponse$creationTime' => '<p>When the group was created.</p>', 'RunGroupListItem$creationTime' => '<p>When the group was created.</p>', ], ], 'RunId' => [ 'base' => NULL, 'refs' => [ 'CancelRunRequest$id' => '<p>The run\'s ID.</p>', 'DeleteRunRequest$id' => '<p>The run\'s ID.</p>', 'GetRunRequest$id' => '<p>The run\'s ID.</p>', 'GetRunResponse$id' => '<p>The run\'s ID.</p>', 'GetRunResponse$runId' => '<p>The run\'s ID.</p>', 'GetRunTaskRequest$id' => '<p>The workflow run ID.</p>', 'ListRunTasksRequest$id' => '<p>The run\'s ID.</p>', 'RunListItem$id' => '<p>The run\'s ID.</p>', 'StartRunRequest$runId' => '<p>The ID of a run to duplicate.</p>', 'StartRunResponse$id' => '<p>The run\'s ID.</p>', ], ], 'RunLeftNormalization' => [ 'base' => NULL, 'refs' => [ 'AnnotationImportJobItem$runLeftNormalization' => '<p>The job\'s left normalization setting.</p>', 'GetAnnotationImportResponse$runLeftNormalization' => '<p>The job\'s left normalization setting.</p>', 'GetVariantImportResponse$runLeftNormalization' => '<p>The job\'s left normalization setting.</p>', 'StartAnnotationImportRequest$runLeftNormalization' => '<p>The job\'s left normalization setting.</p>', 'StartVariantImportRequest$runLeftNormalization' => '<p>The job\'s left normalization setting.</p>', 'VariantImportJobItem$runLeftNormalization' => '<p>The job\'s left normalization setting.</p>', ], ], 'RunList' => [ 'base' => NULL, 'refs' => [ 'ListRunsResponse$items' => '<p>A list of runs.</p>', ], ], 'RunListItem' => [ 'base' => '<p>A workflow run.</p>', 'refs' => [ 'RunList$member' => NULL, ], ], 'RunListItemPriorityInteger' => [ 'base' => NULL, 'refs' => [ 'RunListItem$priority' => '<p>The run\'s priority.</p>', ], ], 'RunListItemStorageCapacityInteger' => [ 'base' => NULL, 'refs' => [ 'RunListItem$storageCapacity' => '<p>The run\'s storage capacity in gibibytes. For dynamic storage, after the run has completed, this value is the maximum amount of storage used during the run.</p>', ], ], 'RunListToken' => [ 'base' => NULL, 'refs' => [ 'ListRunsRequest$startingToken' => '<p>Specify the pagination token from a previous request to retrieve the next page of results.</p>', 'ListRunsResponse$nextToken' => '<p>A pagination token that\'s included if more results are available.</p>', ], ], 'RunLogLevel' => [ 'base' => NULL, 'refs' => [ 'GetRunResponse$logLevel' => '<p>The run\'s log level.</p>', 'StartRunRequest$logLevel' => '<p>A log level for the run.</p>', ], ], 'RunLogLocation' => [ 'base' => '<p>The URI for the run log.</p>', 'refs' => [ 'GetRunResponse$logLocation' => '<p>The location of the run log.</p>', ], ], 'RunLogStream' => [ 'base' => NULL, 'refs' => [ 'RunLogLocation$runLogStream' => '<p>The log stream ARN for the run log.</p>', ], ], 'RunName' => [ 'base' => NULL, 'refs' => [ 'GetRunResponse$name' => '<p>The run\'s name.</p>', 'ListRunsRequest$name' => '<p>Filter the list by run name.</p>', 'RunListItem$name' => '<p>The run\'s name.</p>', 'StartRunRequest$name' => '<p>A name for the run.</p>', ], ], 'RunOutputUri' => [ 'base' => NULL, 'refs' => [ 'GetRunResponse$outputUri' => '<p>The run\'s output URI.</p>', 'GetRunResponse$runOutputUri' => '<p>The destination for workflow outputs.</p>', 'StartRunRequest$outputUri' => '<p>An output URI for the run.</p>', 'StartRunResponse$runOutputUri' => '<p>The destination for workflow outputs.</p>', ], ], 'RunParameters' => [ 'base' => NULL, 'refs' => [ 'GetRunResponse$parameters' => '<p>The run\'s parameters.</p>', 'StartRunRequest$parameters' => '<p>Parameters for the run.</p>', ], ], 'RunRequestId' => [ 'base' => NULL, 'refs' => [ 'StartRunRequest$requestId' => '<p>To ensure that requests don\'t run multiple times, specify a unique ID for each request.</p>', ], ], 'RunResourceDigest' => [ 'base' => NULL, 'refs' => [ 'RunResourceDigests$value' => NULL, ], ], 'RunResourceDigestKey' => [ 'base' => NULL, 'refs' => [ 'RunResourceDigests$key' => NULL, ], ], 'RunResourceDigests' => [ 'base' => NULL, 'refs' => [ 'GetRunResponse$resourceDigests' => '<p>The run\'s resource digests.</p>', ], ], 'RunRetentionMode' => [ 'base' => NULL, 'refs' => [ 'GetRunResponse$retentionMode' => '<p>The run\'s retention mode.</p>', 'StartRunRequest$retentionMode' => '<p>The retention mode for the run.</p>', ], ], 'RunRoleArn' => [ 'base' => NULL, 'refs' => [ 'GetRunResponse$roleArn' => '<p>The run\'s service role ARN.</p>', 'StartRunRequest$roleArn' => '<p>A service role for the run.</p>', ], ], 'RunStartedBy' => [ 'base' => NULL, 'refs' => [ 'GetRunResponse$startedBy' => '<p>Who started the run.</p>', ], ], 'RunStatus' => [ 'base' => NULL, 'refs' => [ 'GetRunResponse$status' => '<p>The run\'s status.</p>', 'ListRunsRequest$status' => '<p>The status of a run.</p>', 'RunListItem$status' => '<p>The run\'s status.</p>', 'StartRunResponse$status' => '<p>The run\'s status.</p>', ], ], 'RunStatusMessage' => [ 'base' => NULL, 'refs' => [ 'GetRunResponse$statusMessage' => '<p>The run\'s status message.</p>', ], ], 'RunTimestamp' => [ 'base' => NULL, 'refs' => [ 'GetRunResponse$creationTime' => '<p>When the run was created.</p>', 'GetRunResponse$startTime' => '<p>When the run started.</p>', 'GetRunResponse$stopTime' => '<p>The run\'s stop time.</p>', 'RunListItem$creationTime' => '<p>When the run was created.</p>', 'RunListItem$startTime' => '<p>When the run started.</p>', 'RunListItem$stopTime' => '<p>When the run stopped.</p>', ], ], 'RunUuid' => [ 'base' => NULL, 'refs' => [ 'GetRunResponse$uuid' => '<p>The universally unique identifier for a run.</p>', 'StartRunResponse$uuid' => '<p>The universally unique identifier for a run.</p>', ], ], 'S3AccessPointArn' => [ 'base' => NULL, 'refs' => [ 'SequenceStoreS3Access$s3AccessPointArn' => '<p>This is ARN of the access point associated with the S3 bucket storing read sets.</p>', ], ], 'S3Destination' => [ 'base' => NULL, 'refs' => [ 'CreateSequenceStoreRequest$fallbackLocation' => '<p>An S3 location that is used to store files that have failed a direct upload.</p>', 'CreateSequenceStoreResponse$fallbackLocation' => '<p>An S3 location that is used to store files that have failed a direct upload.</p>', 'ExportReadSetJobDetail$destination' => '<p>The job\'s destination in Amazon S3.</p>', 'GetReadSetExportJobResponse$destination' => '<p>The job\'s destination in Amazon S3.</p>', 'GetSequenceStoreResponse$fallbackLocation' => '<p>An S3 location that is used to store files that have failed a direct upload.</p>', 'SequenceStoreDetail$fallbackLocation' => '<p> An S3 location that is used to store files that have failed a direct upload. </p>', 'StartReadSetExportJobRequest$destination' => '<p>A location for exported files in Amazon S3.</p>', 'StartReadSetExportJobResponse$destination' => '<p>The job\'s output location.</p>', ], ], 'S3Uri' => [ 'base' => NULL, 'refs' => [ 'AnnotationImportItemDetail$source' => '<p>The source file\'s location in Amazon S3.</p>', 'AnnotationImportItemSource$source' => '<p>The source file\'s location in Amazon S3.</p>', 'ImportReferenceSourceItem$sourceFile' => '<p>The source file\'s location in Amazon S3.</p>', 'ReadSetS3Access$s3Uri' => '<p>The S3 URI for each read set file.</p>', 'SequenceStoreS3Access$s3Uri' => '<p>The S3 URI of the sequence store.</p>', 'SourceFiles$source1' => '<p>The location of the first file in Amazon S3.</p>', 'SourceFiles$source2' => '<p>The location of the second file in Amazon S3.</p>', 'StartReferenceImportJobSourceItem$sourceFile' => '<p>The source file\'s location in Amazon S3.</p>', 'VariantImportItemDetail$source' => '<p>The source file\'s location in Amazon S3.</p>', 'VariantImportItemSource$source' => '<p>The source file\'s location in Amazon S3.</p>', ], ], 'SampleId' => [ 'base' => NULL, 'refs' => [ 'CreateMultipartReadSetUploadRequest$sampleId' => '<p>The source\'s sample ID.</p>', 'CreateMultipartReadSetUploadResponse$sampleId' => '<p>The source\'s sample ID.</p>', 'GetReadSetMetadataResponse$sampleId' => '<p>The read set\'s sample ID.</p>', 'ImportReadSetSourceItem$sampleId' => '<p>The source\'s sample ID.</p>', 'MultipartReadSetUploadListItem$sampleId' => '<p> The read set source\'s sample ID. </p>', 'ReadSetFilter$sampleId' => '<p> The read set source\'s sample ID. </p>', 'ReadSetListItem$sampleId' => '<p>The read set\'s sample ID.</p>', 'StartReadSetImportJobSourceItem$sampleId' => '<p>The source\'s sample ID.</p>', ], ], 'SchemaItem' => [ 'base' => NULL, 'refs' => [ 'TsvStoreOptionsSchemaList$member' => NULL, 'TsvVersionOptionsSchemaList$member' => NULL, ], ], 'SchemaItemKeyString' => [ 'base' => NULL, 'refs' => [ 'SchemaItem$key' => NULL, ], ], 'SchemaValueType' => [ 'base' => NULL, 'refs' => [ 'SchemaItem$value' => NULL, ], ], 'Separator' => [ 'base' => NULL, 'refs' => [ 'ReadOptions$sep' => '<p>The file\'s field separator.</p>', ], ], 'SequenceInformation' => [ 'base' => '<p>Details about a sequence.</p>', 'refs' => [ 'GetReadSetMetadataResponse$sequenceInformation' => '<p>The read set\'s sequence information.</p>', 'ReadSetListItem$sequenceInformation' => NULL, ], ], 'SequenceStoreArn' => [ 'base' => NULL, 'refs' => [ 'CreateSequenceStoreResponse$arn' => '<p>The store\'s ARN.</p>', 'GetSequenceStoreResponse$arn' => '<p>The store\'s ARN.</p>', 'SequenceStoreDetail$arn' => '<p>The store\'s ARN.</p>', ], ], 'SequenceStoreDescription' => [ 'base' => NULL, 'refs' => [ 'CreateSequenceStoreRequest$description' => '<p>A description for the store.</p>', 'CreateSequenceStoreResponse$description' => '<p>The store\'s description.</p>', 'GetSequenceStoreResponse$description' => '<p>The store\'s description.</p>', 'SequenceStoreDetail$description' => '<p>The store\'s description.</p>', ], ], 'SequenceStoreDetail' => [ 'base' => '<p>Details about a sequence store.</p>', 'refs' => [ 'SequenceStoreDetailList$member' => NULL, ], ], 'SequenceStoreDetailList' => [ 'base' => NULL, 'refs' => [ 'ListSequenceStoresResponse$sequenceStores' => '<p>A list of sequence stores.</p>', ], ], 'SequenceStoreFilter' => [ 'base' => '<p>A filter for a sequence store.</p>', 'refs' => [ 'ListSequenceStoresRequest$filter' => '<p>A filter to apply to the list.</p>', ], ], 'SequenceStoreId' => [ 'base' => NULL, 'refs' => [ 'AbortMultipartReadSetUploadRequest$sequenceStoreId' => '<p>The sequence store ID for the store involved in the multipart upload.</p>', 'ActivateReadSetJobItem$sequenceStoreId' => '<p>The job\'s sequence store ID.</p>', 'BatchDeleteReadSetRequest$sequenceStoreId' => '<p>The read sets\' sequence store ID.</p>', 'CompleteMultipartReadSetUploadRequest$sequenceStoreId' => '<p>The sequence store ID for the store involved in the multipart upload.</p>', 'CreateMultipartReadSetUploadRequest$sequenceStoreId' => '<p>The sequence store ID for the store that is the destination of the multipart uploads.</p>', 'CreateMultipartReadSetUploadResponse$sequenceStoreId' => '<p>The sequence store ID for the store that the read set will be created in.</p>', 'CreateSequenceStoreResponse$id' => '<p>The store\'s ID.</p>', 'DeleteSequenceStoreRequest$id' => '<p>The sequence store\'s ID.</p>', 'ExportReadSetJobDetail$sequenceStoreId' => '<p>The job\'s sequence store ID.</p>', 'GetReadSetActivationJobRequest$sequenceStoreId' => '<p>The job\'s sequence store ID.</p>', 'GetReadSetActivationJobResponse$sequenceStoreId' => '<p>The job\'s sequence store ID.</p>', 'GetReadSetExportJobRequest$sequenceStoreId' => '<p>The job\'s sequence store ID.</p>', 'GetReadSetExportJobResponse$sequenceStoreId' => '<p>The job\'s sequence store ID.</p>', 'GetReadSetImportJobRequest$sequenceStoreId' => '<p>The job\'s sequence store ID.</p>', 'GetReadSetImportJobResponse$sequenceStoreId' => '<p>The job\'s sequence store ID.</p>', 'GetReadSetMetadataRequest$sequenceStoreId' => '<p>The read set\'s sequence store ID.</p>', 'GetReadSetMetadataResponse$sequenceStoreId' => '<p>The read set\'s sequence store ID.</p>', 'GetReadSetRequest$sequenceStoreId' => '<p>The read set\'s sequence store ID.</p>', 'GetSequenceStoreRequest$id' => '<p>The store\'s ID.</p>', 'GetSequenceStoreResponse$id' => '<p>The store\'s ID.</p>', 'ImportReadSetJobItem$sequenceStoreId' => '<p>The job\'s sequence store ID.</p>', 'ListMultipartReadSetUploadsRequest$sequenceStoreId' => '<p>The Sequence Store ID used for the multipart uploads.</p>', 'ListReadSetActivationJobsRequest$sequenceStoreId' => '<p>The read set\'s sequence store ID.</p>', 'ListReadSetExportJobsRequest$sequenceStoreId' => '<p>The jobs\' sequence store ID.</p>', 'ListReadSetImportJobsRequest$sequenceStoreId' => '<p>The jobs\' sequence store ID.</p>', 'ListReadSetUploadPartsRequest$sequenceStoreId' => '<p>The Sequence Store ID used for the multipart uploads.</p>', 'ListReadSetsRequest$sequenceStoreId' => '<p>The jobs\' sequence store ID.</p>', 'MultipartReadSetUploadListItem$sequenceStoreId' => '<p> The sequence store ID used for the multipart upload. </p>', 'ReadSetListItem$sequenceStoreId' => '<p>The read set\'s sequence store ID.</p>', 'SequenceStoreDetail$id' => '<p>The store\'s ID.</p>', 'StartReadSetActivationJobRequest$sequenceStoreId' => '<p>The read set\'s sequence store ID.</p>', 'StartReadSetActivationJobResponse$sequenceStoreId' => '<p>The read set\'s sequence store ID.</p>', 'StartReadSetExportJobRequest$sequenceStoreId' => '<p>The read set\'s sequence store ID.</p>', 'StartReadSetExportJobResponse$sequenceStoreId' => '<p>The read set\'s sequence store ID.</p>', 'StartReadSetImportJobRequest$sequenceStoreId' => '<p>The read set\'s sequence store ID.</p>', 'StartReadSetImportJobResponse$sequenceStoreId' => '<p>The read set\'s sequence store ID.</p>', 'UploadReadSetPartRequest$sequenceStoreId' => '<p>The Sequence Store ID used for the multipart upload.</p>', ], ], 'SequenceStoreName' => [ 'base' => NULL, 'refs' => [ 'CreateSequenceStoreRequest$name' => '<p>A name for the store.</p>', 'CreateSequenceStoreResponse$name' => '<p>The store\'s name.</p>', 'GetSequenceStoreResponse$name' => '<p>The store\'s name.</p>', 'SequenceStoreDetail$name' => '<p>The store\'s name.</p>', 'SequenceStoreFilter$name' => '<p>A name to filter on.</p>', ], ], 'SequenceStoreS3Access' => [ 'base' => '<p>The S3 access metadata of the sequence store.</p>', 'refs' => [ 'GetSequenceStoreResponse$s3Access' => '<p>The S3 metadata of a sequence store, including the ARN and S3 URI of the S3 bucket.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>The request exceeds a service quota.</p>', 'refs' => [], ], 'ShareDetails' => [ 'base' => '<p>The details of a resource share.</p>', 'refs' => [ 'GetShareResponse$share' => '<p>A resource share details object. The object includes the status, the resourceArn, and ownerId.</p>', 'ShareDetailsList$member' => NULL, ], ], 'ShareDetailsList' => [ 'base' => NULL, 'refs' => [ 'ListSharesResponse$shares' => '<p>The shares available and their metadata details.</p>', ], ], 'ShareName' => [ 'base' => NULL, 'refs' => [ 'CreateShareRequest$shareName' => '<p>A name that the owner defines for the share.</p>', 'CreateShareResponse$shareName' => '<p>The name of the share.</p>', 'ShareDetails$shareName' => '<p>The name of the resource share.</p>', ], ], 'ShareResourceType' => [ 'base' => NULL, 'refs' => [ 'TypeList$member' => NULL, ], ], 'ShareStatus' => [ 'base' => NULL, 'refs' => [ 'AcceptShareResponse$status' => '<p>The status of the resource share.</p>', 'CreateShareResponse$status' => '<p>The status of the share.</p>', 'DeleteShareResponse$status' => '<p>The status of the share being deleted.</p>', 'ShareDetails$status' => '<p>The status of the share.</p>', 'StatusList$member' => NULL, ], ], 'SourceFiles' => [ 'base' => '<p>Source files for a sequence.</p>', 'refs' => [ 'ImportReadSetSourceItem$sourceFiles' => '<p>The source files\' location in Amazon S3.</p>', 'StartReadSetImportJobSourceItem$sourceFiles' => '<p>The source files\' location in Amazon S3.</p>', ], ], 'SseConfig' => [ 'base' => '<p>Server-side encryption (SSE) settings for a store.</p>', 'refs' => [ 'AnnotationStoreItem$sseConfig' => '<p>The store\'s server-side encryption (SSE) settings.</p>', 'CreateAnnotationStoreRequest$sseConfig' => '<p>Server-side encryption (SSE) settings for the store.</p>', 'CreateReferenceStoreRequest$sseConfig' => '<p>Server-side encryption (SSE) settings for the store.</p>', 'CreateReferenceStoreResponse$sseConfig' => '<p>The store\'s SSE settings.</p>', 'CreateSequenceStoreRequest$sseConfig' => '<p>Server-side encryption (SSE) settings for the store.</p>', 'CreateSequenceStoreResponse$sseConfig' => '<p>The store\'s SSE settings.</p>', 'CreateVariantStoreRequest$sseConfig' => '<p>Server-side encryption (SSE) settings for the store.</p>', 'GetAnnotationStoreResponse$sseConfig' => '<p>The store\'s server-side encryption (SSE) settings.</p>', 'GetReferenceStoreResponse$sseConfig' => '<p>The store\'s server-side encryption (SSE) settings.</p>', 'GetSequenceStoreResponse$sseConfig' => '<p>The store\'s server-side encryption (SSE) settings.</p>', 'GetVariantStoreResponse$sseConfig' => '<p>The store\'s server-side encryption (SSE) settings.</p>', 'ReferenceStoreDetail$sseConfig' => '<p>The store\'s server-side encryption (SSE) settings.</p>', 'SequenceStoreDetail$sseConfig' => '<p>The store\'s server-side encryption (SSE) settings.</p>', 'VariantStoreItem$sseConfig' => '<p>The store\'s server-side encryption (SSE) settings.</p>', ], ], 'SseConfigKeyArnString' => [ 'base' => NULL, 'refs' => [ 'SseConfig$keyArn' => '<p>An encryption key ARN.</p>', ], ], 'StartAnnotationImportRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartAnnotationImportResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartReadSetActivationJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartReadSetActivationJobRequestSourcesList' => [ 'base' => NULL, 'refs' => [ 'StartReadSetActivationJobRequest$sources' => '<p>The job\'s source files.</p>', ], ], 'StartReadSetActivationJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartReadSetActivationJobSourceItem' => [ 'base' => '<p>A source for a read set activation job.</p>', 'refs' => [ 'StartReadSetActivationJobRequestSourcesList$member' => NULL, ], ], 'StartReadSetExportJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartReadSetExportJobRequestSourcesList' => [ 'base' => NULL, 'refs' => [ 'StartReadSetExportJobRequest$sources' => '<p>The job\'s source files.</p>', ], ], 'StartReadSetExportJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartReadSetImportJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartReadSetImportJobRequestSourcesList' => [ 'base' => NULL, 'refs' => [ 'StartReadSetImportJobRequest$sources' => '<p>The job\'s source files.</p>', ], ], 'StartReadSetImportJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartReadSetImportJobSourceItem' => [ 'base' => '<p>A source for a read set import job.</p>', 'refs' => [ 'StartReadSetImportJobRequestSourcesList$member' => NULL, ], ], 'StartReferenceImportJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartReferenceImportJobRequestSourcesList' => [ 'base' => NULL, 'refs' => [ 'StartReferenceImportJobRequest$sources' => '<p>The job\'s source files.</p>', ], ], 'StartReferenceImportJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartReferenceImportJobSourceItem' => [ 'base' => '<p>A source for a reference import job.</p>', 'refs' => [ 'StartReferenceImportJobRequestSourcesList$member' => NULL, ], ], 'StartRunRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartRunRequestPriorityInteger' => [ 'base' => NULL, 'refs' => [ 'StartRunRequest$priority' => '<p>A priority for the run.</p>', ], ], 'StartRunRequestStorageCapacityInteger' => [ 'base' => NULL, 'refs' => [ 'StartRunRequest$storageCapacity' => '<p>A storage capacity for the run in gibibytes. This field is not required if the storage type is dynamic (the system ignores any value that you enter).</p>', ], ], 'StartRunResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartVariantImportRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartVariantImportResponse' => [ 'base' => NULL, 'refs' => [], ], 'StatusList' => [ 'base' => NULL, 'refs' => [ 'Filter$status' => '<p>Filter based on the resource status. You can specify up to 10 values.</p>', ], ], 'StatusMessage' => [ 'base' => NULL, 'refs' => [ 'AnnotationStoreItem$statusMessage' => '<p>The store\'s status message.</p>', 'AnnotationStoreVersionItem$statusMessage' => '<p> The status of an annotation store version. </p>', 'GetAnnotationStoreResponse$statusMessage' => '<p>A status message.</p>', 'GetAnnotationStoreVersionResponse$statusMessage' => '<p> The status of an annotation store version. </p>', 'GetVariantStoreResponse$statusMessage' => '<p>The store\'s status message.</p>', 'ShareDetails$statusMessage' => '<p>The status message for a resource share. It provides additional details about the share status.</p>', 'VariantStoreItem$statusMessage' => '<p>The store\'s status message.</p>', ], ], 'StorageType' => [ 'base' => NULL, 'refs' => [ 'GetRunResponse$storageType' => '<p>The run\'s storage type.</p>', 'RunListItem$storageType' => '<p>The run\'s storage type.</p>', 'StartRunRequest$storageType' => '<p>The run\'s storage type. By default, the run uses STATIC storage type, which allocates a fixed amount of storage. If you set the storage type to DYNAMIC, HealthOmics dynamically scales the storage up or down, based on file system utilization.</p>', ], ], 'StoreFormat' => [ 'base' => NULL, 'refs' => [ 'AnnotationStoreItem$storeFormat' => '<p>The store\'s file format.</p>', 'CreateAnnotationStoreRequest$storeFormat' => '<p>The annotation file format of the store.</p>', 'CreateAnnotationStoreResponse$storeFormat' => '<p>The annotation file format of the store.</p>', 'GetAnnotationStoreResponse$storeFormat' => '<p>The store\'s annotation file format.</p>', 'UpdateAnnotationStoreResponse$storeFormat' => '<p>The annotation file format of the store.</p>', ], ], 'StoreName' => [ 'base' => NULL, 'refs' => [ 'AnnotationStoreVersionItem$name' => '<p> A name given to an annotation store version to distinguish it from others. </p>', 'CreateAnnotationStoreRequest$name' => '<p>A name for the store.</p>', 'CreateAnnotationStoreVersionRequest$name' => '<p> The name of an annotation store version from which versions are being created. </p>', 'CreateAnnotationStoreVersionResponse$name' => '<p> The name given to an annotation store version to distinguish it from other versions. </p>', 'CreateVariantStoreRequest$name' => '<p>A name for the store.</p>', 'GetAnnotationImportResponse$destinationName' => '<p>The job\'s destination annotation store.</p>', 'GetAnnotationStoreVersionResponse$name' => '<p> The name of the annotation store. </p>', 'GetVariantImportResponse$destinationName' => '<p>The job\'s destination variant store.</p>', 'StartAnnotationImportRequest$destinationName' => '<p>A destination annotation store for the job.</p>', 'StartVariantImportRequest$destinationName' => '<p>The destination variant store for the job.</p>', 'UpdateAnnotationStoreVersionResponse$name' => '<p> The name of an annotation store. </p>', ], ], 'StoreOptions' => [ 'base' => '<p>Settings for a store.</p>', 'refs' => [ 'CreateAnnotationStoreRequest$storeOptions' => '<p>File parsing options for the annotation store.</p>', 'CreateAnnotationStoreResponse$storeOptions' => '<p>The store\'s file parsing options.</p>', 'GetAnnotationStoreResponse$storeOptions' => '<p>The store\'s parsing options.</p>', 'UpdateAnnotationStoreResponse$storeOptions' => '<p>Parsing options for the store.</p>', ], ], 'StoreStatus' => [ 'base' => NULL, 'refs' => [ 'AnnotationStoreItem$status' => '<p>The store\'s status.</p>', 'CreateAnnotationStoreResponse$status' => '<p>The store\'s status.</p>', 'CreateVariantStoreResponse$status' => '<p>The store\'s status.</p>', 'DeleteAnnotationStoreResponse$status' => '<p>The store\'s status.</p>', 'DeleteVariantStoreResponse$status' => '<p>The store\'s status.</p>', 'GetAnnotationStoreResponse$status' => '<p>The store\'s status.</p>', 'GetVariantStoreResponse$status' => '<p>The store\'s status.</p>', 'ListAnnotationStoresFilter$status' => '<p>A status to filter on.</p>', 'ListVariantStoresFilter$status' => '<p>A status to filter on.</p>', 'UpdateAnnotationStoreResponse$status' => '<p>The store\'s status.</p>', 'UpdateVariantStoreResponse$status' => '<p>The store\'s status.</p>', 'VariantStoreItem$status' => '<p>The store\'s status.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AcceptShareRequest$shareId' => '<p>The ID of the resource share.</p>', 'AccessDeniedException$message' => NULL, 'AnnotationImportJobItem$id' => '<p>The job\'s ID.</p>', 'AnnotationImportJobItem$destinationName' => '<p>The job\'s destination annotation store.</p>', 'AnnotationStoreItem$name' => '<p>The store\'s name.</p>', 'ArnList$member' => NULL, 'ConflictException$message' => NULL, 'CreateAnnotationStoreResponse$name' => '<p>The store\'s name.</p>', 'CreateShareRequest$resourceArn' => '<p>The ARN of the resource to be shared.</p>', 'CreateShareRequest$principalSubscriber' => '<p>The principal subscriber is the account being offered shared access to the resource. </p>', 'CreateShareResponse$shareId' => '<p>The ID that HealthOmics generates for the share.</p>', 'CreateVariantStoreResponse$name' => '<p>The store\'s name.</p>', 'DeleteAnnotationStoreRequest$name' => '<p>The store\'s name.</p>', 'DeleteAnnotationStoreVersionsRequest$name' => '<p> The name of the annotation store from which versions are being deleted. </p>', 'DeleteShareRequest$shareId' => '<p>The ID for the resource share to be deleted.</p>', 'DeleteVariantStoreRequest$name' => '<p>The store\'s name.</p>', 'ETag$source1' => '<p>The ETag hash calculated on Source1 of the read set.</p>', 'ETag$source2' => '<p>The ETag hash calculated on Source2 of the read set.</p>', 'GetAnnotationStoreRequest$name' => '<p>The store\'s name.</p>', 'GetAnnotationStoreResponse$name' => '<p>The store\'s name.</p>', 'GetAnnotationStoreVersionRequest$name' => '<p> The name given to an annotation store version to distinguish it from others. </p>', 'GetAnnotationStoreVersionRequest$versionName' => '<p> The name given to an annotation store version to distinguish it from others. </p>', 'GetShareRequest$shareId' => '<p>The ID of the share.</p>', 'GetVariantStoreRequest$name' => '<p>The store\'s name.</p>', 'GetVariantStoreResponse$name' => '<p>The store\'s name.</p>', 'InternalServerException$message' => NULL, 'ListAnnotationImportJobsFilter$storeName' => '<p>A store name to filter on.</p>', 'ListAnnotationImportJobsResponse$nextToken' => '<p>Specifies the pagination token from a previous request to retrieve the next page of results.</p>', 'ListAnnotationStoreVersionsRequest$name' => '<p> The name of an annotation store. </p>', 'ListAnnotationStoreVersionsResponse$nextToken' => '<p> Specifies the pagination token from a previous request to retrieve the next page of results. </p>', 'ListAnnotationStoresResponse$nextToken' => '<p>A pagination token that\'s included if more results are available.</p>', 'ListSharesRequest$nextToken' => '<p>Next token returned in the response of a previous ListReadSetUploadPartsRequest call. Used to get the next page of results.</p>', 'ListSharesResponse$nextToken' => '<p> Next token returned in the response of a previous ListSharesResponse call. Used to get the next page of results. </p>', 'ListVariantImportJobsFilter$storeName' => '<p>A store name to filter on.</p>', 'ListVariantImportJobsResponse$nextToken' => '<p>A pagination token that\'s included if more results are available.</p>', 'ListVariantStoresResponse$nextToken' => '<p>A pagination token that\'s included if more results are available.</p>', 'NotSupportedOperationException$message' => NULL, 'RangeNotSatisfiableException$message' => NULL, 'ReadSetBatchError$code' => '<p>The error\'s code.</p>', 'ReadSetBatchError$message' => '<p>The error\'s message.</p>', 'ReadSetUploadPartListItem$checksum' => '<p> A unique identifier used to confirm that parts are being added to the correct upload. </p>', 'RequestTimeoutException$message' => NULL, 'ResourceNotFoundException$message' => NULL, 'SequenceInformation$alignment' => '<p>The sequence\'s alignment setting.</p>', 'ServiceQuotaExceededException$message' => NULL, 'ShareDetails$shareId' => '<p>The ID of the resource share.</p>', 'ShareDetails$resourceArn' => '<p>The Arn of the shared resource. </p>', 'ShareDetails$resourceId' => '<p>The ID of the shared resource. </p>', 'ShareDetails$principalSubscriber' => '<p>The principal subscriber is the account that is sharing the resource.</p>', 'ShareDetails$ownerId' => '<p>The account ID for the data owner. The owner creates the resource share.</p>', 'ThrottlingException$message' => NULL, 'UpdateAnnotationStoreRequest$name' => '<p>A name for the store.</p>', 'UpdateAnnotationStoreResponse$name' => '<p>The store\'s name.</p>', 'UpdateAnnotationStoreVersionRequest$name' => '<p> The name of an annotation store. </p>', 'UpdateAnnotationStoreVersionRequest$versionName' => '<p> The name of an annotation store version. </p>', 'UpdateVariantStoreRequest$name' => '<p>A name for the store.</p>', 'UpdateVariantStoreResponse$name' => '<p>The store\'s name.</p>', 'UploadReadSetPartResponse$checksum' => '<p>An identifier used to confirm that parts are being added to the intended upload.</p>', 'ValidationException$message' => NULL, 'VariantImportJobItem$id' => '<p>The job\'s ID.</p>', 'VariantImportJobItem$destinationName' => '<p>The job\'s destination variant store.</p>', 'VariantStoreItem$name' => '<p>The store\'s name.</p>', 'VersionDeleteError$message' => '<p> The message explaining the error in annotation store deletion. </p>', ], ], 'SubjectId' => [ 'base' => NULL, 'refs' => [ 'CreateMultipartReadSetUploadRequest$subjectId' => '<p>The source\'s subject ID.</p>', 'CreateMultipartReadSetUploadResponse$subjectId' => '<p>The source\'s subject ID.</p>', 'GetReadSetMetadataResponse$subjectId' => '<p>The read set\'s subject ID.</p>', 'ImportReadSetSourceItem$subjectId' => '<p>The source\'s subject ID.</p>', 'MultipartReadSetUploadListItem$subjectId' => '<p> The read set source\'s subject ID. </p>', 'ReadSetFilter$subjectId' => '<p> The read set source\'s subject ID. </p>', 'ReadSetListItem$subjectId' => '<p>The read set\'s subject ID.</p>', 'StartReadSetImportJobSourceItem$subjectId' => '<p>The source\'s subject ID.</p>', ], ], 'SyntheticTimestamp_date_time' => [ 'base' => NULL, 'refs' => [ 'ActivateReadSetFilter$createdAfter' => '<p>The filter\'s start date.</p>', 'ActivateReadSetFilter$createdBefore' => '<p>The filter\'s end date.</p>', 'ActivateReadSetJobItem$creationTime' => '<p>When the job was created.</p>', 'ActivateReadSetJobItem$completionTime' => '<p>When the job completed.</p>', 'CreateMultipartReadSetUploadResponse$creationTime' => '<p>The creation time of the multipart upload.</p>', 'CreateReferenceStoreResponse$creationTime' => '<p>When the store was created.</p>', 'CreateSequenceStoreResponse$creationTime' => '<p>When the store was created.</p>', 'ExportReadSetFilter$createdAfter' => '<p>The filter\'s start date.</p>', 'ExportReadSetFilter$createdBefore' => '<p>The filter\'s end date.</p>', 'ExportReadSetJobDetail$creationTime' => '<p>When the job was created.</p>', 'ExportReadSetJobDetail$completionTime' => '<p>When the job completed.</p>', 'GetReadSetActivationJobResponse$creationTime' => '<p>When the job was created.</p>', 'GetReadSetActivationJobResponse$completionTime' => '<p>When the job completed.</p>', 'GetReadSetExportJobResponse$creationTime' => '<p>When the job was created.</p>', 'GetReadSetExportJobResponse$completionTime' => '<p>When the job completed.</p>', 'GetReadSetImportJobResponse$creationTime' => '<p>When the job was created.</p>', 'GetReadSetImportJobResponse$completionTime' => '<p>When the job completed.</p>', 'GetReadSetMetadataResponse$creationTime' => '<p>When the read set was created.</p>', 'GetReferenceImportJobResponse$creationTime' => '<p>When the job was created.</p>', 'GetReferenceImportJobResponse$completionTime' => '<p>When the job completed.</p>', 'GetReferenceMetadataResponse$creationTime' => '<p>When the reference was created.</p>', 'GetReferenceMetadataResponse$updateTime' => '<p>When the reference was updated.</p>', 'GetReferenceStoreResponse$creationTime' => '<p>When the store was created.</p>', 'GetSequenceStoreResponse$creationTime' => '<p>When the store was created.</p>', 'ImportReadSetFilter$createdAfter' => '<p>The filter\'s start date.</p>', 'ImportReadSetFilter$createdBefore' => '<p>The filter\'s end date.</p>', 'ImportReadSetJobItem$creationTime' => '<p>When the job was created.</p>', 'ImportReadSetJobItem$completionTime' => '<p>When the job completed.</p>', 'ImportReferenceFilter$createdAfter' => '<p>The filter\'s start date.</p>', 'ImportReferenceFilter$createdBefore' => '<p>The filter\'s end date.</p>', 'ImportReferenceJobItem$creationTime' => '<p>When the job was created.</p>', 'ImportReferenceJobItem$completionTime' => '<p>When the job completed.</p>', 'MultipartReadSetUploadListItem$creationTime' => '<p> The time stamp for when a direct upload was created. </p>', 'ReadSetFilter$createdAfter' => '<p>The filter\'s start date.</p>', 'ReadSetFilter$createdBefore' => '<p>The filter\'s end date.</p>', 'ReadSetListItem$creationTime' => '<p>When the read set was created.</p>', 'ReadSetUploadPartListFilter$createdAfter' => '<p> Filters for read set uploads after a specified time. </p>', 'ReadSetUploadPartListFilter$createdBefore' => '<p> Filters for read set part uploads before a specified time. </p>', 'ReadSetUploadPartListItem$creationTime' => '<p> The time stamp for when a direct upload was created. </p>', 'ReadSetUploadPartListItem$lastUpdatedTime' => '<p> The time stamp for the most recent update to an uploaded part. </p>', 'ReferenceFilter$createdAfter' => '<p>The filter\'s start date.</p>', 'ReferenceFilter$createdBefore' => '<p>The filter\'s end date.</p>', 'ReferenceListItem$creationTime' => '<p>When the reference was created.</p>', 'ReferenceListItem$updateTime' => '<p>When the reference was updated.</p>', 'ReferenceStoreDetail$creationTime' => '<p>When the store was created.</p>', 'ReferenceStoreFilter$createdAfter' => '<p>The filter\'s start date.</p>', 'ReferenceStoreFilter$createdBefore' => '<p>The filter\'s end date.</p>', 'SequenceStoreDetail$creationTime' => '<p>When the store was created.</p>', 'SequenceStoreFilter$createdAfter' => '<p>The filter\'s start date.</p>', 'SequenceStoreFilter$createdBefore' => '<p>The filter\'s end date.</p>', 'StartReadSetActivationJobResponse$creationTime' => '<p>When the job was created.</p>', 'StartReadSetExportJobResponse$creationTime' => '<p>When the job was created.</p>', 'StartReadSetImportJobResponse$creationTime' => '<p>When the job was created.</p>', 'StartReferenceImportJobResponse$creationTime' => '<p>When the job was created.</p>', ], ], 'TagArn' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$resourceArn' => '<p>The resource\'s ARN.</p>', 'TagResourceRequest$resourceArn' => '<p>The resource\'s ARN.</p>', 'UntagResourceRequest$resourceArn' => '<p>The resource\'s ARN.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'TagMap$key' => NULL, 'TagResourceRequestTagsMap$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>Keys of tags to remove.</p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'CreateAnnotationStoreRequest$tags' => '<p>Tags for the store.</p>', 'CreateAnnotationStoreVersionRequest$tags' => '<p> Any tags added to annotation store version. </p>', 'CreateMultipartReadSetUploadRequest$tags' => '<p>Any tags to add to the read set.</p>', 'CreateMultipartReadSetUploadResponse$tags' => '<p>The tags to add to the read set.</p>', 'CreateReferenceStoreRequest$tags' => '<p>Tags for the store.</p>', 'CreateRunGroupRequest$tags' => '<p>Tags for the group.</p>', 'CreateRunGroupResponse$tags' => '<p>Tags for the run group.</p>', 'CreateSequenceStoreRequest$tags' => '<p>Tags for the store.</p>', 'CreateVariantStoreRequest$tags' => '<p>Tags for the store.</p>', 'CreateWorkflowRequest$tags' => '<p>Tags for the workflow.</p>', 'CreateWorkflowResponse$tags' => '<p>The workflow\'s tags.</p>', 'GetAnnotationStoreResponse$tags' => '<p>The store\'s tags.</p>', 'GetAnnotationStoreVersionResponse$tags' => '<p> Any tags associated with an annotation store version. </p>', 'GetRunGroupResponse$tags' => '<p>The group\'s tags.</p>', 'GetRunResponse$tags' => '<p>The run\'s tags.</p>', 'GetVariantStoreResponse$tags' => '<p>The store\'s tags.</p>', 'GetWorkflowResponse$tags' => '<p>The workflow\'s tags.</p>', 'ImportReadSetSourceItem$tags' => '<p>The source\'s tags.</p>', 'ImportReferenceSourceItem$tags' => '<p>The source\'s tags.</p>', 'ListTagsForResourceResponse$tags' => '<p>A list of tags.</p>', 'MultipartReadSetUploadListItem$tags' => '<p> Any tags you wish to add to a read set. </p>', 'StartReadSetImportJobSourceItem$tags' => '<p>The source\'s tags.</p>', 'StartReferenceImportJobSourceItem$tags' => '<p>The source\'s tags.</p>', 'StartRunRequest$tags' => '<p>Tags for the run.</p>', 'StartRunResponse$tags' => '<p>The run\'s tags.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceRequestTagsMap' => [ 'base' => NULL, 'refs' => [ 'TagResourceRequest$tags' => '<p>Tags for the resource.</p>', ], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagMap$value' => NULL, 'TagResourceRequestTagsMap$value' => NULL, ], ], 'TaskFailureReason' => [ 'base' => NULL, 'refs' => [ 'GetRunTaskResponse$failureReason' => '<p>The reason a task has failed.</p>', ], ], 'TaskId' => [ 'base' => NULL, 'refs' => [ 'GetRunTaskRequest$taskId' => '<p>The task\'s ID.</p>', 'GetRunTaskResponse$taskId' => '<p>The task\'s ID.</p>', 'TaskListItem$taskId' => '<p>The task\'s ID.</p>', ], ], 'TaskInstanceType' => [ 'base' => NULL, 'refs' => [ 'GetRunTaskResponse$instanceType' => '<p>The instance type for a task.</p>', 'TaskListItem$instanceType' => '<p> The instance type for a task.</p>', ], ], 'TaskList' => [ 'base' => NULL, 'refs' => [ 'ListRunTasksResponse$items' => '<p>A list of tasks.</p>', ], ], 'TaskListItem' => [ 'base' => '<p>A workflow run task.</p>', 'refs' => [ 'TaskList$member' => NULL, ], ], 'TaskListItemCpusInteger' => [ 'base' => NULL, 'refs' => [ 'TaskListItem$cpus' => '<p>The task\'s CPU count.</p>', ], ], 'TaskListItemGpusInteger' => [ 'base' => NULL, 'refs' => [ 'TaskListItem$gpus' => '<p> The number of Graphics Processing Units (GPU) specified for the task. </p>', ], ], 'TaskListItemMemoryInteger' => [ 'base' => NULL, 'refs' => [ 'TaskListItem$memory' => '<p>The task\'s memory use in gigabyes.</p>', ], ], 'TaskListToken' => [ 'base' => NULL, 'refs' => [ 'ListRunTasksRequest$startingToken' => '<p>Specify the pagination token from a previous request to retrieve the next page of results.</p>', 'ListRunTasksResponse$nextToken' => '<p>A pagination token that\'s included if more results are available.</p>', ], ], 'TaskLogStream' => [ 'base' => NULL, 'refs' => [ 'GetRunTaskResponse$logStream' => '<p>The task\'s log stream.</p>', ], ], 'TaskName' => [ 'base' => NULL, 'refs' => [ 'GetRunTaskResponse$name' => '<p>The task\'s name.</p>', 'TaskListItem$name' => '<p>The task\'s name.</p>', ], ], 'TaskStatus' => [ 'base' => NULL, 'refs' => [ 'GetRunTaskResponse$status' => '<p>The task\'s status.</p>', 'ListRunTasksRequest$status' => '<p>Filter the list by status.</p>', 'TaskListItem$status' => '<p>The task\'s status.</p>', ], ], 'TaskStatusMessage' => [ 'base' => NULL, 'refs' => [ 'GetRunTaskResponse$statusMessage' => '<p>The task\'s status message.</p>', ], ], 'TaskTimestamp' => [ 'base' => NULL, 'refs' => [ 'GetRunTaskResponse$creationTime' => '<p>When the task was created.</p>', 'GetRunTaskResponse$startTime' => '<p>The task\'s start time.</p>', 'GetRunTaskResponse$stopTime' => '<p>The task\'s stop time.</p>', 'TaskListItem$creationTime' => '<p>When the task was created.</p>', 'TaskListItem$startTime' => '<p>When the task started.</p>', 'TaskListItem$stopTime' => '<p>When the task stopped.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The request was denied due to request throttling.</p>', 'refs' => [], ], 'TsvOptions' => [ 'base' => '<p>Formatting options for a TSV file.</p>', 'refs' => [ 'FormatOptions$tsvOptions' => '<p>Options for a TSV file.</p>', ], ], 'TsvStoreOptions' => [ 'base' => '<p>File settings for a TSV store.</p>', 'refs' => [ 'StoreOptions$tsvStoreOptions' => '<p>File settings for a TSV store.</p>', ], ], 'TsvStoreOptionsSchemaList' => [ 'base' => NULL, 'refs' => [ 'TsvStoreOptions$schema' => '<p>The store\'s schema.</p>', ], ], 'TsvVersionOptions' => [ 'base' => '<p> The options for a TSV file. </p>', 'refs' => [ 'VersionOptions$tsvVersionOptions' => '<p> File settings for a version of a TSV store. </p>', ], ], 'TsvVersionOptionsSchemaList' => [ 'base' => NULL, 'refs' => [ 'TsvVersionOptions$schema' => '<p> The TSV schema for an annotation store version. </p>', ], ], 'TypeList' => [ 'base' => NULL, 'refs' => [ 'Filter$type' => '<p>The type of resources to be filtered. You can specify one or more of the resource types.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAnnotationStoreRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAnnotationStoreResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAnnotationStoreVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAnnotationStoreVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRunGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRunGroupRequestMaxCpusInteger' => [ 'base' => NULL, 'refs' => [ 'UpdateRunGroupRequest$maxCpus' => '<p>The maximum number of CPUs to use.</p>', ], ], 'UpdateRunGroupRequestMaxDurationInteger' => [ 'base' => NULL, 'refs' => [ 'UpdateRunGroupRequest$maxDuration' => '<p>A maximum run time for the group in minutes.</p>', ], ], 'UpdateRunGroupRequestMaxGpusInteger' => [ 'base' => NULL, 'refs' => [ 'UpdateRunGroupRequest$maxGpus' => '<p>The maximum GPUs that can be used by a run group.</p>', ], ], 'UpdateRunGroupRequestMaxRunsInteger' => [ 'base' => NULL, 'refs' => [ 'UpdateRunGroupRequest$maxRuns' => '<p>The maximum number of concurrent runs for the group.</p>', ], ], 'UpdateTime' => [ 'base' => NULL, 'refs' => [ 'AnnotationImportJobItem$updateTime' => '<p>When the job was updated.</p>', 'AnnotationStoreItem$updateTime' => '<p>When the store was updated.</p>', 'AnnotationStoreVersionItem$updateTime' => '<p> The time stamp for when an annotation store version was updated. </p>', 'GetAnnotationImportResponse$updateTime' => '<p>When the job was updated.</p>', 'GetAnnotationStoreResponse$updateTime' => '<p>When the store was updated.</p>', 'GetAnnotationStoreVersionResponse$updateTime' => '<p> The time stamp for when an annotation store version was updated. </p>', 'GetVariantImportResponse$updateTime' => '<p>When the job was updated.</p>', 'GetVariantStoreResponse$updateTime' => '<p>When the store was updated.</p>', 'ShareDetails$updateTime' => '<p>The timestamp of the resource share update.</p>', 'UpdateAnnotationStoreResponse$updateTime' => '<p>When the store was updated.</p>', 'UpdateAnnotationStoreVersionResponse$updateTime' => '<p> The time stamp for when an annotation store version was updated. </p>', 'UpdateVariantStoreResponse$updateTime' => '<p>When the store was updated.</p>', 'VariantImportJobItem$updateTime' => '<p>When the job was updated.</p>', 'VariantStoreItem$updateTime' => '<p>When the store was updated.</p>', ], ], 'UpdateVariantStoreRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateVariantStoreResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateWorkflowRequest' => [ 'base' => NULL, 'refs' => [], ], 'UploadId' => [ 'base' => NULL, 'refs' => [ 'AbortMultipartReadSetUploadRequest$uploadId' => '<p>The ID for the multipart upload.</p>', 'CompleteMultipartReadSetUploadRequest$uploadId' => '<p>The ID for the multipart upload.</p>', 'CreateMultipartReadSetUploadResponse$uploadId' => '<p>The ID for the initiated multipart upload.</p>', 'ListReadSetUploadPartsRequest$uploadId' => '<p>The ID for the initiated multipart upload.</p>', 'MultipartReadSetUploadListItem$uploadId' => '<p> The ID for the initiated multipart upload. </p>', 'UploadReadSetPartRequest$uploadId' => '<p>The ID for the initiated multipart upload.</p>', ], ], 'UploadReadSetPartRequest' => [ 'base' => NULL, 'refs' => [], ], 'UploadReadSetPartRequestPartNumberInteger' => [ 'base' => NULL, 'refs' => [ 'UploadReadSetPartRequest$partNumber' => '<p>The number of the part being uploaded.</p>', ], ], 'UploadReadSetPartResponse' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>The input fails to satisfy the constraints specified by an AWS service.</p>', 'refs' => [], ], 'VariantImportItemDetail' => [ 'base' => '<p>Details about an imported variant item.</p>', 'refs' => [ 'VariantImportItemDetails$member' => NULL, ], ], 'VariantImportItemDetails' => [ 'base' => NULL, 'refs' => [ 'GetVariantImportResponse$items' => '<p>The job\'s items.</p>', ], ], 'VariantImportItemSource' => [ 'base' => '<p>A imported variant item\'s source.</p>', 'refs' => [ 'VariantImportItemSources$member' => NULL, ], ], 'VariantImportItemSources' => [ 'base' => NULL, 'refs' => [ 'StartVariantImportRequest$items' => '<p>Items to import.</p>', ], ], 'VariantImportJobItem' => [ 'base' => '<p>A variant import job.</p>', 'refs' => [ 'VariantImportJobItems$member' => NULL, ], ], 'VariantImportJobItems' => [ 'base' => NULL, 'refs' => [ 'ListVariantImportJobsResponse$variantImportJobs' => '<p>A list of jobs.</p>', ], ], 'VariantStoreItem' => [ 'base' => '<p>A variant store.</p>', 'refs' => [ 'VariantStoreItems$member' => NULL, ], ], 'VariantStoreItems' => [ 'base' => NULL, 'refs' => [ 'ListVariantStoresResponse$variantStores' => '<p>A list of variant stores.</p>', ], ], 'VcfOptions' => [ 'base' => '<p>Formatting options for a VCF file.</p>', 'refs' => [ 'FormatOptions$vcfOptions' => '<p>Options for a VCF file.</p>', ], ], 'VersionDeleteError' => [ 'base' => '<p> The error preventing deletion of the annotation store version. </p>', 'refs' => [ 'VersionDeleteErrorList$member' => NULL, ], ], 'VersionDeleteErrorList' => [ 'base' => NULL, 'refs' => [ 'DeleteAnnotationStoreVersionsResponse$errors' => '<p> Any errors that occur when attempting to delete an annotation store version. </p>', ], ], 'VersionList' => [ 'base' => NULL, 'refs' => [ 'DeleteAnnotationStoreVersionsRequest$versions' => '<p> The versions of an annotation store to be deleted. </p>', ], ], 'VersionName' => [ 'base' => NULL, 'refs' => [ 'AnnotationImportJobItem$versionName' => '<p> The name of the annotation store version. </p>', 'AnnotationStoreVersionItem$versionName' => '<p> The name of an annotation store version. </p>', 'CreateAnnotationStoreRequest$versionName' => '<p> The name given to an annotation store version to distinguish it from other versions. </p>', 'CreateAnnotationStoreResponse$versionName' => '<p> The name given to an annotation store version to distinguish it from other versions. </p>', 'CreateAnnotationStoreVersionRequest$versionName' => '<p> The name given to an annotation store version to distinguish it from other versions. </p>', 'CreateAnnotationStoreVersionResponse$versionName' => '<p> The name given to an annotation store version to distinguish it from other versions. </p>', 'GetAnnotationImportResponse$versionName' => '<p> The name of the annotation store version. </p>', 'GetAnnotationStoreVersionResponse$versionName' => '<p> The name given to an annotation store version to distinguish it from others. </p>', 'StartAnnotationImportRequest$versionName' => '<p> The name of the annotation store version. </p>', 'UpdateAnnotationStoreVersionResponse$versionName' => '<p> The name of an annotation store version. </p>', 'VersionDeleteError$versionName' => '<p> The name given to an annotation store version. </p>', 'VersionList$member' => NULL, ], ], 'VersionOptions' => [ 'base' => '<p> The options for an annotation store version. </p>', 'refs' => [ 'CreateAnnotationStoreVersionRequest$versionOptions' => '<p> The options for an annotation store version. </p>', 'CreateAnnotationStoreVersionResponse$versionOptions' => '<p> The options for an annotation store version. </p>', 'GetAnnotationStoreVersionResponse$versionOptions' => '<p> The options for an annotation store version. </p>', ], ], 'VersionStatus' => [ 'base' => NULL, 'refs' => [ 'AnnotationStoreVersionItem$status' => '<p> The status of an annotation store version. </p>', 'CreateAnnotationStoreVersionResponse$status' => '<p> The status of a annotation store version. </p>', 'GetAnnotationStoreVersionResponse$status' => '<p> The status of an annotation store version. </p>', 'ListAnnotationStoreVersionsFilter$status' => '<p>The status of an annotation store version.</p>', 'UpdateAnnotationStoreVersionResponse$status' => '<p> The status of an annotation store version. </p>', ], ], 'WorkflowArn' => [ 'base' => NULL, 'refs' => [ 'CreateWorkflowResponse$arn' => '<p>The workflow\'s ARN.</p>', 'GetWorkflowResponse$arn' => '<p>The workflow\'s ARN.</p>', 'WorkflowListItem$arn' => '<p>The workflow\'s ARN.</p>', ], ], 'WorkflowDefinition' => [ 'base' => NULL, 'refs' => [ 'CreateWorkflowRequest$definitionUri' => '<p>The URI of a definition for the workflow.</p>', 'GetRunResponse$definition' => '<p>The run\'s definition.</p>', 'GetWorkflowResponse$definition' => '<p>The workflow\'s definition.</p>', ], ], 'WorkflowDescription' => [ 'base' => NULL, 'refs' => [ 'CreateWorkflowRequest$description' => '<p>A description for the workflow.</p>', 'GetWorkflowResponse$description' => '<p>The workflow\'s description.</p>', 'UpdateWorkflowRequest$description' => '<p>A description for the workflow.</p>', ], ], 'WorkflowDigest' => [ 'base' => NULL, 'refs' => [ 'GetRunResponse$digest' => '<p>The run\'s digest.</p>', 'GetWorkflowResponse$digest' => '<p>The workflow\'s digest.</p>', 'WorkflowListItem$digest' => '<p>The workflow\'s digest.</p>', ], ], 'WorkflowEngine' => [ 'base' => NULL, 'refs' => [ 'CreateWorkflowRequest$engine' => '<p>An engine for the workflow.</p>', 'GetWorkflowResponse$engine' => '<p>The workflow\'s engine.</p>', ], ], 'WorkflowExport' => [ 'base' => NULL, 'refs' => [ 'WorkflowExportList$member' => NULL, ], ], 'WorkflowExportList' => [ 'base' => NULL, 'refs' => [ 'GetWorkflowRequest$export' => '<p>The export format for the workflow.</p>', ], ], 'WorkflowId' => [ 'base' => NULL, 'refs' => [ 'CreateWorkflowResponse$id' => '<p>The workflow\'s ID.</p>', 'DeleteWorkflowRequest$id' => '<p>The workflow\'s ID.</p>', 'GetRunResponse$workflowId' => '<p>The run\'s workflow ID.</p>', 'GetWorkflowRequest$id' => '<p>The workflow\'s ID.</p>', 'GetWorkflowResponse$id' => '<p>The workflow\'s ID.</p>', 'RunListItem$workflowId' => '<p>The run\'s workflow ID.</p>', 'StartRunRequest$workflowId' => '<p>The run\'s workflow ID.</p>', 'UpdateWorkflowRequest$id' => '<p>The workflow\'s ID.</p>', 'WorkflowListItem$id' => '<p>The workflow\'s ID.</p>', ], ], 'WorkflowList' => [ 'base' => NULL, 'refs' => [ 'ListWorkflowsResponse$items' => '<p>A list of workflow items.</p>', ], ], 'WorkflowListItem' => [ 'base' => '<p>A workflow.</p>', 'refs' => [ 'WorkflowList$member' => NULL, ], ], 'WorkflowListToken' => [ 'base' => NULL, 'refs' => [ 'ListWorkflowsRequest$startingToken' => '<p>Specify the pagination token from a previous request to retrieve the next page of results.</p>', 'ListWorkflowsResponse$nextToken' => '<p>A pagination token that\'s included if more results are available.</p>', ], ], 'WorkflowMain' => [ 'base' => NULL, 'refs' => [ 'CreateWorkflowRequest$main' => '<p>The path of the main definition file for the workflow.</p>', 'GetWorkflowResponse$main' => '<p>The path of the main definition file for the workflow.</p>', ], ], 'WorkflowMetadata' => [ 'base' => NULL, 'refs' => [ 'GetWorkflowResponse$metadata' => '<p>Gets metadata for workflow.</p>', 'WorkflowListItem$metadata' => '<p> Any metadata available for workflow. The information listed may vary depending on the workflow, and there may also be no metadata to return. </p>', ], ], 'WorkflowMetadataKey' => [ 'base' => NULL, 'refs' => [ 'WorkflowMetadata$key' => NULL, ], ], 'WorkflowMetadataValue' => [ 'base' => NULL, 'refs' => [ 'WorkflowMetadata$value' => NULL, ], ], 'WorkflowName' => [ 'base' => NULL, 'refs' => [ 'CreateWorkflowRequest$name' => '<p>A name for the workflow.</p>', 'GetWorkflowResponse$name' => '<p>The workflow\'s name.</p>', 'ListWorkflowsRequest$name' => '<p>Filter the list by workflow name.</p>', 'UpdateWorkflowRequest$name' => '<p>A name for the workflow.</p>', 'WorkflowListItem$name' => '<p>The workflow\'s name.</p>', ], ], 'WorkflowOwnerId' => [ 'base' => NULL, 'refs' => [ 'GetRunResponse$workflowOwnerId' => '<p>The ID of the workflow owner.</p>', 'GetWorkflowRequest$workflowOwnerId' => '<p>The ID of the workflow owner.</p>', 'StartRunRequest$workflowOwnerId' => '<p>The ID of the workflow owner. </p>', ], ], 'WorkflowParameter' => [ 'base' => '<p>A workflow parameter.</p>', 'refs' => [ 'WorkflowParameterTemplate$value' => NULL, ], ], 'WorkflowParameterDescription' => [ 'base' => NULL, 'refs' => [ 'WorkflowParameter$description' => '<p>The parameter\'s description.</p>', ], ], 'WorkflowParameterName' => [ 'base' => NULL, 'refs' => [ 'WorkflowParameterTemplate$key' => NULL, ], ], 'WorkflowParameterTemplate' => [ 'base' => NULL, 'refs' => [ 'CreateWorkflowRequest$parameterTemplate' => '<p>A parameter template for the workflow.</p>', 'GetWorkflowResponse$parameterTemplate' => '<p>The workflow\'s parameter template.</p>', ], ], 'WorkflowRequestId' => [ 'base' => NULL, 'refs' => [ 'CreateWorkflowRequest$requestId' => '<p>To ensure that requests don\'t run multiple times, specify a unique ID for each request.</p>', ], ], 'WorkflowStatus' => [ 'base' => NULL, 'refs' => [ 'CreateWorkflowResponse$status' => '<p>The workflow\'s status.</p>', 'GetWorkflowResponse$status' => '<p>The workflow\'s status.</p>', 'WorkflowListItem$status' => '<p>The workflow\'s status.</p>', ], ], 'WorkflowStatusMessage' => [ 'base' => NULL, 'refs' => [ 'GetWorkflowResponse$statusMessage' => '<p>The workflow\'s status message.</p>', ], ], 'WorkflowTimestamp' => [ 'base' => NULL, 'refs' => [ 'GetWorkflowResponse$creationTime' => '<p>When the workflow was created.</p>', 'WorkflowListItem$creationTime' => '<p>When the workflow was created.</p>', ], ], 'WorkflowType' => [ 'base' => NULL, 'refs' => [ 'GetRunResponse$workflowType' => '<p>The run\'s workflow type.</p>', 'GetWorkflowRequest$type' => '<p>The workflow\'s type.</p>', 'GetWorkflowResponse$type' => '<p>The workflow\'s type.</p>', 'ListWorkflowsRequest$type' => '<p>Filter the list by workflow type.</p>', 'StartRunRequest$workflowType' => '<p>The run\'s workflow type.</p>', 'WorkflowListItem$type' => '<p>The workflow\'s type.</p>', ], ], ],];
