<?php
// This file was auto-generated from sdk-root/src/data/outposts/2019-12-03/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Amazon Web Services Outposts is a fully managed service that extends Amazon Web Services infrastructure, APIs, and tools to customer premises. By providing local access to Amazon Web Services managed infrastructure, Amazon Web Services Outposts enables customers to build and run applications on premises using the same programming interfaces as in Amazon Web Services Regions, while using local compute and storage resources for lower latency and local data processing needs.</p>', 'operations' => [ 'CancelCapacityTask' => '<p>Cancels the capacity task.</p>', 'CancelOrder' => '<p>Cancels the specified order for an Outpost.</p>', 'CreateOrder' => '<p>Creates an order for an Outpost.</p>', 'CreateOutpost' => '<p>Creates an Outpost.</p> <p>You can specify either an Availability one or an AZ ID.</p>', 'CreateSite' => '<p> Creates a site for an Outpost. </p>', 'DeleteOutpost' => '<p>Deletes the specified Outpost.</p>', 'DeleteSite' => '<p>Deletes the specified site.</p>', 'GetCapacityTask' => '<p>Gets details of the specified capacity task.</p>', 'GetCatalogItem' => '<p>Gets information about the specified catalog item.</p>', 'GetConnection' => '<note> <p> Amazon Web Services uses this action to install Outpost servers.</p> </note> <p> Gets information about the specified connection. </p> <p> Use CloudTrail to monitor this action or Amazon Web Services managed policy for Amazon Web Services Outposts to secure it. For more information, see <a href="https://docs.aws.amazon.com/outposts/latest/userguide/security-iam-awsmanpol.html"> Amazon Web Services managed policies for Amazon Web Services Outposts</a> and <a href="https://docs.aws.amazon.com/outposts/latest/userguide/logging-using-cloudtrail.html"> Logging Amazon Web Services Outposts API calls with Amazon Web Services CloudTrail</a> in the <i>Amazon Web Services Outposts User Guide</i>. </p>', 'GetOrder' => '<p>Gets information about the specified order.</p>', 'GetOutpost' => '<p>Gets information about the specified Outpost.</p>', 'GetOutpostInstanceTypes' => '<p>Gets the instance types for the specified Outpost.</p>', 'GetOutpostSupportedInstanceTypes' => '<p>Gets the instance types that an Outpost can support in <code>InstanceTypeCapacity</code>. This will generally include instance types that are not currently configured and therefore cannot be launched with the current Outpost capacity configuration.</p>', 'GetSite' => '<p>Gets information about the specified Outpost site.</p>', 'GetSiteAddress' => '<p> Gets the site address of the specified site. </p>', 'ListAssets' => '<p>Lists the hardware assets for the specified Outpost.</p> <p>Use filters to return specific results. If you specify multiple filters, the results include only the resources that match all of the specified filters. For a filter where you can specify multiple values, the results include items that match any of the values that you specify for the filter.</p>', 'ListCapacityTasks' => '<p>Lists the capacity tasks for your Amazon Web Services account.</p> <p>Use filters to return specific results. If you specify multiple filters, the results include only the resources that match all of the specified filters. For a filter where you can specify multiple values, the results include items that match any of the values that you specify for the filter.</p>', 'ListCatalogItems' => '<p>Lists the items in the catalog.</p> <p>Use filters to return specific results. If you specify multiple filters, the results include only the resources that match all of the specified filters. For a filter where you can specify multiple values, the results include items that match any of the values that you specify for the filter.</p>', 'ListOrders' => '<p>Lists the Outpost orders for your Amazon Web Services account.</p>', 'ListOutposts' => '<p>Lists the Outposts for your Amazon Web Services account.</p> <p>Use filters to return specific results. If you specify multiple filters, the results include only the resources that match all of the specified filters. For a filter where you can specify multiple values, the results include items that match any of the values that you specify for the filter.</p>', 'ListSites' => '<p>Lists the Outpost sites for your Amazon Web Services account. Use filters to return specific results.</p> <p>Use filters to return specific results. If you specify multiple filters, the results include only the resources that match all of the specified filters. For a filter where you can specify multiple values, the results include items that match any of the values that you specify for the filter.</p>', 'ListTagsForResource' => '<p>Lists the tags for the specified resource.</p>', 'StartCapacityTask' => '<p>Starts the specified capacity task. You can have one active capacity task for an order.</p>', 'StartConnection' => '<note> <p> Amazon Web Services uses this action to install Outpost servers.</p> </note> <p> Starts the connection required for Outpost server installation. </p> <p> Use CloudTrail to monitor this action or Amazon Web Services managed policy for Amazon Web Services Outposts to secure it. For more information, see <a href="https://docs.aws.amazon.com/outposts/latest/userguide/security-iam-awsmanpol.html"> Amazon Web Services managed policies for Amazon Web Services Outposts</a> and <a href="https://docs.aws.amazon.com/outposts/latest/userguide/logging-using-cloudtrail.html"> Logging Amazon Web Services Outposts API calls with Amazon Web Services CloudTrail</a> in the <i>Amazon Web Services Outposts User Guide</i>. </p>', 'TagResource' => '<p>Adds tags to the specified resource.</p>', 'UntagResource' => '<p>Removes tags from the specified resource.</p>', 'UpdateOutpost' => '<p> Updates an Outpost. </p>', 'UpdateSite' => '<p>Updates the specified site.</p>', 'UpdateSiteAddress' => '<p>Updates the address of the specified site.</p> <p>You can\'t update a site address if there is an order in progress. You must wait for the order to complete or cancel the order.</p> <p>You can update the operating address before you place an order at the site, or after all Outposts that belong to the site have been deactivated.</p>', 'UpdateSiteRackPhysicalProperties' => '<p>Update the physical and logistical details for a rack at a site. For more information about hardware requirements for racks, see <a href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#checklist">Network readiness checklist</a> in the Amazon Web Services Outposts User Guide. </p> <p>To update a rack at a site with an order of <code>IN_PROGRESS</code>, you must wait for the order to complete or cancel the order.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You do not have permission to perform this operation.</p>', 'refs' => [], ], 'AccountId' => [ 'base' => '<p>The ID of the Amazon Web Services account.</p>', 'refs' => [ 'Site$AccountId' => NULL, ], ], 'Address' => [ 'base' => '<p> Information about an address. </p>', 'refs' => [ 'CreateSiteInput$OperatingAddress' => '<p> The location to install and power on the hardware. This address might be different from the shipping address. </p>', 'CreateSiteInput$ShippingAddress' => '<p> The location to ship the hardware. This address might be different from the operating address. </p>', 'GetSiteAddressOutput$Address' => '<p> Information about the address. </p>', 'UpdateSiteAddressInput$Address' => '<p> The address for the site. </p>', 'UpdateSiteAddressOutput$Address' => '<p> Information about an address. </p>', ], ], 'AddressLine1' => [ 'base' => NULL, 'refs' => [ 'Address$AddressLine1' => '<p>The first line of the address.</p>', ], ], 'AddressLine2' => [ 'base' => NULL, 'refs' => [ 'Address$AddressLine2' => '<p>The second line of the address.</p>', ], ], 'AddressLine3' => [ 'base' => NULL, 'refs' => [ 'Address$AddressLine3' => '<p>The third line of the address.</p>', ], ], 'AddressType' => [ 'base' => NULL, 'refs' => [ 'GetSiteAddressInput$AddressType' => '<p>The type of the address you request. </p>', 'GetSiteAddressOutput$AddressType' => '<p>The type of the address you receive. </p>', 'UpdateSiteAddressInput$AddressType' => '<p> The type of the address. </p>', 'UpdateSiteAddressOutput$AddressType' => '<p> The type of the address. </p>', ], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'TagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'UntagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', ], ], 'AssetId' => [ 'base' => NULL, 'refs' => [ 'AssetInfo$AssetId' => '<p> The ID of the asset. </p>', 'LineItemAssetInformation$AssetId' => '<p> The ID of the asset. </p>', 'StartConnectionRequest$AssetId' => '<p> The ID of the Outpost server. </p>', ], ], 'AssetInfo' => [ 'base' => '<p> Information about hardware assets. </p>', 'refs' => [ 'AssetListDefinition$member' => NULL, ], ], 'AssetListDefinition' => [ 'base' => NULL, 'refs' => [ 'ListAssetsOutput$Assets' => '<p>Information about the hardware assets.</p>', ], ], 'AssetLocation' => [ 'base' => '<p> Information about the position of the asset in a rack. </p>', 'refs' => [ 'AssetInfo$AssetLocation' => '<p> The position of an asset in a rack. </p>', ], ], 'AssetState' => [ 'base' => NULL, 'refs' => [ 'StatusList$member' => NULL, ], ], 'AssetType' => [ 'base' => NULL, 'refs' => [ 'AssetInfo$AssetType' => '<p> The type of the asset. </p>', ], ], 'AvailabilityZone' => [ 'base' => '<p>The Availability Zone.</p>', 'refs' => [ 'AvailabilityZoneList$member' => NULL, 'CreateOutpostInput$AvailabilityZone' => NULL, 'Outpost$AvailabilityZone' => NULL, ], ], 'AvailabilityZoneId' => [ 'base' => '<p>The ID of the Availability Zone.</p>', 'refs' => [ 'AvailabilityZoneIdList$member' => NULL, 'CreateOutpostInput$AvailabilityZoneId' => NULL, 'Outpost$AvailabilityZoneId' => NULL, ], ], 'AvailabilityZoneIdList' => [ 'base' => NULL, 'refs' => [ 'ListOutpostsInput$AvailabilityZoneIdFilter' => '<p>Filters the results by AZ ID (for example, <code>use1-az1</code>).</p>', ], ], 'AvailabilityZoneList' => [ 'base' => NULL, 'refs' => [ 'ListOutpostsInput$AvailabilityZoneFilter' => '<p>Filters the results by Availability Zone (for example, <code>us-east-1a</code>).</p>', ], ], 'CIDR' => [ 'base' => NULL, 'refs' => [ 'CIDRList$member' => NULL, 'ConnectionDetails$ClientTunnelAddress' => '<p> The client tunnel address. </p>', 'ConnectionDetails$ServerTunnelAddress' => '<p> The server tunnel address. </p>', ], ], 'CIDRList' => [ 'base' => NULL, 'refs' => [ 'ConnectionDetails$AllowedIps' => '<p> The allowed IP addresses. </p>', ], ], 'CancelCapacityTaskInput' => [ 'base' => NULL, 'refs' => [], ], 'CancelCapacityTaskOutput' => [ 'base' => NULL, 'refs' => [], ], 'CancelOrderInput' => [ 'base' => NULL, 'refs' => [], ], 'CancelOrderOutput' => [ 'base' => NULL, 'refs' => [], ], 'CapacityTaskFailure' => [ 'base' => '<p>The capacity tasks that failed.</p>', 'refs' => [ 'GetCapacityTaskOutput$Failed' => '<p>Reason why the capacity task failed.</p>', 'StartCapacityTaskOutput$Failed' => '<p>Reason that the specified capacity task failed.</p>', ], ], 'CapacityTaskFailureType' => [ 'base' => NULL, 'refs' => [ 'CapacityTaskFailure$Type' => '<p>The type of failure.</p>', ], ], 'CapacityTaskId' => [ 'base' => NULL, 'refs' => [ 'CancelCapacityTaskInput$CapacityTaskId' => '<p>ID of the capacity task that you want to cancel.</p>', 'CapacityTaskSummary$CapacityTaskId' => '<p>The ID of the specified capacity task.</p>', 'GetCapacityTaskInput$CapacityTaskId' => '<p>ID of the capacity task.</p>', 'GetCapacityTaskOutput$CapacityTaskId' => '<p>ID of the capacity task.</p>', 'StartCapacityTaskOutput$CapacityTaskId' => '<p>ID of the capacity task that you want to start.</p>', ], ], 'CapacityTaskList' => [ 'base' => NULL, 'refs' => [ 'ListCapacityTasksOutput$CapacityTasks' => '<p>Lists all the capacity tasks.</p>', ], ], 'CapacityTaskStatus' => [ 'base' => NULL, 'refs' => [ 'CapacityTaskStatusList$member' => NULL, 'CapacityTaskSummary$CapacityTaskStatus' => '<p>The status of the capacity task.</p>', 'GetCapacityTaskOutput$CapacityTaskStatus' => '<p>Status of the capacity task.</p> <p>A capacity task can have one of the following statuses:</p> <ul> <li> <p> <code>REQUESTED</code> - The capacity task was created and is awaiting the next step by Amazon Web Services Outposts.</p> </li> <li> <p> <code>IN_PROGRESS</code> - The capacity task is running and cannot be cancelled.</p> </li> <li> <p> <code>WAITING_FOR_EVACUATION</code> - The capacity task requires capacity to run. You must stop the recommended EC2 running instances to free up capacity for the task to run.</p> </li> </ul>', 'StartCapacityTaskOutput$CapacityTaskStatus' => '<p>Status of the specified capacity task.</p>', ], ], 'CapacityTaskStatusList' => [ 'base' => NULL, 'refs' => [ 'ListCapacityTasksInput$CapacityTaskStatusFilter' => '<p>A list of statuses. For example, <code>REQUESTED</code> or <code>WAITING_FOR_EVACUATION</code>.</p>', ], ], 'CapacityTaskStatusReason' => [ 'base' => NULL, 'refs' => [ 'CapacityTaskFailure$Reason' => '<p>The reason that the specified capacity task failed.</p>', ], ], 'CapacityTaskSummary' => [ 'base' => '<p>The summary of the capacity task.</p>', 'refs' => [ 'CapacityTaskList$member' => NULL, ], ], 'CatalogItem' => [ 'base' => '<p> Information about a catalog item. </p>', 'refs' => [ 'CatalogItemListDefinition$member' => NULL, 'GetCatalogItemOutput$CatalogItem' => '<p>Information about this catalog item.</p>', ], ], 'CatalogItemClass' => [ 'base' => NULL, 'refs' => [ 'CatalogItemClassList$member' => NULL, ], ], 'CatalogItemClassList' => [ 'base' => NULL, 'refs' => [ 'ListCatalogItemsInput$ItemClassFilter' => '<p>Filters the results by item class.</p>', ], ], 'CatalogItemListDefinition' => [ 'base' => NULL, 'refs' => [ 'ListCatalogItemsOutput$CatalogItems' => '<p>Information about the catalog items.</p>', ], ], 'CatalogItemPowerKva' => [ 'base' => NULL, 'refs' => [ 'CatalogItem$PowerKva' => '<p> Information about the power draw of an item. </p>', ], ], 'CatalogItemStatus' => [ 'base' => NULL, 'refs' => [ 'CatalogItem$ItemStatus' => '<p> The status of a catalog item. </p>', ], ], 'CatalogItemWeightLbs' => [ 'base' => NULL, 'refs' => [ 'CatalogItem$WeightLbs' => '<p> The weight of the item in pounds. </p>', ], ], 'City' => [ 'base' => NULL, 'refs' => [ 'Address$City' => '<p>The city for the address.</p>', 'CityList$member' => NULL, 'Site$OperatingAddressCity' => '<p> City where the hardware is installed and powered on. </p>', ], ], 'CityList' => [ 'base' => NULL, 'refs' => [ 'ListSitesInput$OperatingAddressCityFilter' => '<p>Filters the results by city.</p>', ], ], 'ComputeAssetState' => [ 'base' => NULL, 'refs' => [ 'ComputeAttributes$State' => '<p>The state.</p> <ul> <li> <p>ACTIVE - The asset is available and can provide capacity for new compute resources.</p> </li> <li> <p>ISOLATED - The asset is undergoing maintenance and can\'t provide capacity for new compute resources. Existing compute resources on the asset are not affected.</p> </li> <li> <p>RETIRING - The underlying hardware for the asset is degraded. Capacity for new compute resources is reduced. Amazon Web Services sends notifications for resources that must be stopped before the asset can be replaced.</p> </li> </ul>', ], ], 'ComputeAttributes' => [ 'base' => '<p> Information about compute hardware assets. </p>', 'refs' => [ 'AssetInfo$ComputeAttributes' => '<p> Information about compute hardware assets. </p>', ], ], 'ConflictException' => [ 'base' => '<p>Updating or deleting this resource can cause an inconsistent state.</p>', 'refs' => [], ], 'ConnectionDetails' => [ 'base' => '<p> Information about a connection. </p>', 'refs' => [ 'GetConnectionResponse$ConnectionDetails' => '<p> Information about the connection. </p>', ], ], 'ConnectionId' => [ 'base' => NULL, 'refs' => [ 'GetConnectionRequest$ConnectionId' => '<p> The ID of the connection. </p>', 'GetConnectionResponse$ConnectionId' => '<p> The ID of the connection. </p>', 'StartConnectionResponse$ConnectionId' => '<p> The ID of the connection. </p>', ], ], 'ContactName' => [ 'base' => NULL, 'refs' => [ 'Address$ContactName' => '<p>The name of the contact.</p>', ], ], 'ContactPhoneNumber' => [ 'base' => NULL, 'refs' => [ 'Address$ContactPhoneNumber' => '<p>The phone number of the contact.</p>', ], ], 'CountryCode' => [ 'base' => NULL, 'refs' => [ 'Address$CountryCode' => '<p>The ISO-3166 two-letter country code for the address.</p>', 'CountryCodeList$member' => NULL, 'Site$OperatingAddressCountryCode' => '<p> The ISO-3166 two-letter country code where the hardware is installed and powered on. </p>', ], ], 'CountryCodeList' => [ 'base' => NULL, 'refs' => [ 'ListSitesInput$OperatingAddressCountryCodeFilter' => '<p>Filters the results by country code.</p>', ], ], 'CreateOrderInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateOrderOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateOutpostInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateOutpostOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateSiteInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateSiteOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteOutpostInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteOutpostOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSiteInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSiteOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeviceSerialNumber' => [ 'base' => NULL, 'refs' => [ 'StartConnectionRequest$DeviceSerialNumber' => '<p> The serial number of the dongle. </p>', ], ], 'DistrictOrCounty' => [ 'base' => NULL, 'refs' => [ 'Address$DistrictOrCounty' => '<p>The district or county for the address.</p>', ], ], 'DryRun' => [ 'base' => NULL, 'refs' => [ 'GetCapacityTaskOutput$DryRun' => '<p>Performs a dry run to determine if you are above or below instance capacity.</p>', 'StartCapacityTaskInput$DryRun' => '<p>You can request a dry run to determine if the instance type and instance size changes is above or below available instance capacity. Requesting a dry run does not make any changes to your plan.</p>', 'StartCapacityTaskOutput$DryRun' => '<p>Results of the dry run showing if the specified capacity task is above or below the available instance capacity.</p>', ], ], 'EC2Capacity' => [ 'base' => '<p> Information about EC2 capacity. </p>', 'refs' => [ 'EC2CapacityListDefinition$member' => NULL, ], ], 'EC2CapacityListDefinition' => [ 'base' => NULL, 'refs' => [ 'CatalogItem$EC2Capacities' => '<p> Information about the EC2 capacity of an item. </p>', ], ], 'EC2FamilyList' => [ 'base' => NULL, 'refs' => [ 'ListCatalogItemsInput$EC2FamilyFilter' => '<p>Filters the results by EC2 family (for example, M5).</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => NULL, 'ConflictException$Message' => NULL, 'InternalServerException$Message' => NULL, 'NotFoundException$Message' => NULL, 'ServiceQuotaExceededException$Message' => NULL, 'ValidationException$Message' => NULL, ], ], 'Family' => [ 'base' => NULL, 'refs' => [ 'EC2Capacity$Family' => '<p> The family of the EC2 capacity. </p>', 'EC2FamilyList$member' => NULL, ], ], 'FiberOpticCableType' => [ 'base' => NULL, 'refs' => [ 'RackPhysicalProperties$FiberOpticCableType' => '<p>The type of fiber used to attach the Outpost to the network. </p>', 'UpdateSiteRackPhysicalPropertiesInput$FiberOpticCableType' => '<p>The type of fiber that you will use to attach the Outpost to your network. </p>', ], ], 'GetCapacityTaskInput' => [ 'base' => NULL, 'refs' => [], ], 'GetCapacityTaskOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetCatalogItemInput' => [ 'base' => NULL, 'refs' => [], ], 'GetCatalogItemOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetConnectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetConnectionResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetOrderInput' => [ 'base' => NULL, 'refs' => [], ], 'GetOrderOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetOutpostInput' => [ 'base' => NULL, 'refs' => [], ], 'GetOutpostInstanceTypesInput' => [ 'base' => NULL, 'refs' => [], ], 'GetOutpostInstanceTypesOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetOutpostOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetOutpostSupportedInstanceTypesInput' => [ 'base' => NULL, 'refs' => [], ], 'GetOutpostSupportedInstanceTypesOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetSiteAddressInput' => [ 'base' => NULL, 'refs' => [], ], 'GetSiteAddressOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetSiteInput' => [ 'base' => NULL, 'refs' => [], ], 'GetSiteOutput' => [ 'base' => NULL, 'refs' => [], ], 'HostId' => [ 'base' => NULL, 'refs' => [ 'ComputeAttributes$HostId' => '<p> The host ID of the Dedicated Host on the asset. </p>', 'HostIdList$member' => NULL, ], ], 'HostIdList' => [ 'base' => NULL, 'refs' => [ 'ListAssetsInput$HostIdFilter' => '<p>Filters the results by the host ID of a Dedicated Host.</p>', ], ], 'ISO8601Timestamp' => [ 'base' => NULL, 'refs' => [ 'CapacityTaskSummary$CreationDate' => '<p>The date that the specified capacity task was created.</p>', 'CapacityTaskSummary$CompletionDate' => '<p>The date that the specified capacity task successfully ran.</p>', 'CapacityTaskSummary$LastModifiedDate' => '<p>The date that the specified capacity was last modified.</p>', 'GetCapacityTaskOutput$CreationDate' => '<p>The date the capacity task was created.</p>', 'GetCapacityTaskOutput$CompletionDate' => '<p>The date the capacity task ran successfully.</p>', 'GetCapacityTaskOutput$LastModifiedDate' => '<p>The date the capacity task was last modified.</p>', 'Order$OrderSubmissionDate' => '<p>The submission date for the order.</p>', 'Order$OrderFulfilledDate' => '<p>The fulfillment date of the order.</p>', 'OrderSummary$OrderSubmissionDate' => '<p> The submission date for the order. </p>', 'OrderSummary$OrderFulfilledDate' => '<p> The fulfilment date for the order. </p>', 'StartCapacityTaskOutput$CreationDate' => '<p>Date that the specified capacity task was created.</p>', 'StartCapacityTaskOutput$CompletionDate' => '<p>Date that the specified capacity task ran successfully.</p>', 'StartCapacityTaskOutput$LastModifiedDate' => '<p>Date that the specified capacity task was last modified.</p>', ], ], 'InstanceFamilies' => [ 'base' => NULL, 'refs' => [ 'ComputeAttributes$InstanceFamilies' => '<p>A list of the names of instance families that are currently associated with a given asset.</p>', ], ], 'InstanceFamilyName' => [ 'base' => NULL, 'refs' => [ 'InstanceFamilies$member' => NULL, ], ], 'InstanceType' => [ 'base' => '<p>The instance type.</p>', 'refs' => [ 'InstanceTypeItem$InstanceType' => NULL, ], ], 'InstanceTypeCapacity' => [ 'base' => '<p>The instance type that you specify determines the combination of CPU, memory, storage, and networking capacity.</p>', 'refs' => [ 'RequestedInstancePools$member' => NULL, ], ], 'InstanceTypeCount' => [ 'base' => NULL, 'refs' => [ 'InstanceTypeCapacity$Count' => '<p>The number of instances for the specified instance type.</p>', ], ], 'InstanceTypeItem' => [ 'base' => '<p>Information about an instance type.</p>', 'refs' => [ 'InstanceTypeListDefinition$member' => NULL, ], ], 'InstanceTypeListDefinition' => [ 'base' => '<p>Information about the instance types.</p>', 'refs' => [ 'GetOutpostInstanceTypesOutput$InstanceTypes' => NULL, 'GetOutpostSupportedInstanceTypesOutput$InstanceTypes' => NULL, ], ], 'InstanceTypeName' => [ 'base' => NULL, 'refs' => [ 'InstanceTypeCapacity$InstanceType' => '<p>The instance type of the hosts.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>An internal error has occurred.</p>', 'refs' => [], ], 'LifeCycleStatus' => [ 'base' => '<p>The life cycle status.</p>', 'refs' => [ 'LifeCycleStatusList$member' => NULL, 'Outpost$LifeCycleStatus' => NULL, ], ], 'LifeCycleStatusList' => [ 'base' => NULL, 'refs' => [ 'ListOutpostsInput$LifeCycleStatusFilter' => '<p>Filters the results by the lifecycle status.</p>', ], ], 'LineItem' => [ 'base' => '<p>Information about a line item.</p>', 'refs' => [ 'LineItemListDefinition$member' => NULL, ], ], 'LineItemAssetInformation' => [ 'base' => '<p> Information about a line item asset. </p>', 'refs' => [ 'LineItemAssetInformationList$member' => NULL, ], ], 'LineItemAssetInformationList' => [ 'base' => NULL, 'refs' => [ 'LineItem$AssetInformationList' => '<p> Information about assets. </p>', ], ], 'LineItemId' => [ 'base' => NULL, 'refs' => [ 'LineItem$LineItemId' => '<p>The ID of the line item.</p>', 'LineItem$PreviousLineItemId' => '<p>The ID of the previous line item.</p>', ], ], 'LineItemListDefinition' => [ 'base' => NULL, 'refs' => [ 'Order$LineItems' => '<p>The line items for the order</p>', ], ], 'LineItemQuantity' => [ 'base' => NULL, 'refs' => [ 'LineItem$Quantity' => '<p>The quantity of the line item.</p>', 'LineItemRequest$Quantity' => '<p>The quantity of a line item request.</p>', 'LineItemStatusCounts$value' => NULL, ], ], 'LineItemRequest' => [ 'base' => '<p>Information about a line item request.</p>', 'refs' => [ 'LineItemRequestListDefinition$member' => NULL, ], ], 'LineItemRequestListDefinition' => [ 'base' => NULL, 'refs' => [ 'CreateOrderInput$LineItems' => '<p>The line items that make up the order.</p>', ], ], 'LineItemStatus' => [ 'base' => NULL, 'refs' => [ 'LineItem$Status' => '<p>The status of the line item.</p>', 'LineItemStatusCounts$key' => NULL, ], ], 'LineItemStatusCounts' => [ 'base' => NULL, 'refs' => [ 'OrderSummary$LineItemCountsByStatus' => '<p> The status of all line items in the order. </p>', ], ], 'ListAssetsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListAssetsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListCapacityTasksInput' => [ 'base' => NULL, 'refs' => [], ], 'ListCapacityTasksOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListCatalogItemsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListCatalogItemsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListOrdersInput' => [ 'base' => NULL, 'refs' => [], ], 'ListOrdersOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListOutpostsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListOutpostsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListSitesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListSitesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'MacAddress' => [ 'base' => NULL, 'refs' => [ 'MacAddressList$member' => NULL, ], ], 'MacAddressList' => [ 'base' => NULL, 'refs' => [ 'LineItemAssetInformation$MacAddressList' => '<p> The MAC addresses of the asset. </p>', ], ], 'MaxResults1000' => [ 'base' => '<p>The maximum page size.</p>', 'refs' => [ 'GetOutpostInstanceTypesInput$MaxResults' => NULL, 'GetOutpostSupportedInstanceTypesInput$MaxResults' => NULL, 'ListAssetsInput$MaxResults' => NULL, 'ListCapacityTasksInput$MaxResults' => NULL, 'ListCatalogItemsInput$MaxResults' => NULL, 'ListOrdersInput$MaxResults' => NULL, 'ListOutpostsInput$MaxResults' => NULL, 'ListSitesInput$MaxResults' => NULL, ], ], 'MaxSize' => [ 'base' => NULL, 'refs' => [ 'EC2Capacity$MaxSize' => '<p> The maximum size of the EC2 capacity. </p>', ], ], 'MaximumSupportedWeightLbs' => [ 'base' => NULL, 'refs' => [ 'RackPhysicalProperties$MaximumSupportedWeightLbs' => '<p>The maximum rack weight that this site can support. <code>NO_LIMIT</code> is over 2000 lbs (907 kg). </p>', 'UpdateSiteRackPhysicalPropertiesInput$MaximumSupportedWeightLbs' => '<p>The maximum rack weight that this site can support. <code>NO_LIMIT</code> is over 2000lbs. </p>', ], ], 'Municipality' => [ 'base' => NULL, 'refs' => [ 'Address$Municipality' => '<p>The municipality for the address.</p>', ], ], 'NetworkInterfaceDeviceIndex' => [ 'base' => NULL, 'refs' => [ 'StartConnectionRequest$NetworkInterfaceDeviceIndex' => '<p> The device index of the network interface on the Outpost server. </p>', ], ], 'NotFoundException' => [ 'base' => '<p>The specified request is not valid.</p>', 'refs' => [], ], 'OpticalStandard' => [ 'base' => NULL, 'refs' => [ 'RackPhysicalProperties$OpticalStandard' => '<p>The type of optical standard used to attach the Outpost to the network. This field is dependent on uplink speed, fiber type, and distance to the upstream device. For more information about networking requirements for racks, see <a href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#facility-networking">Network</a> in the Amazon Web Services Outposts User Guide. </p>', 'UpdateSiteRackPhysicalPropertiesInput$OpticalStandard' => '<p>The type of optical standard that you will use to attach the Outpost to your network. This field is dependent on uplink speed, fiber type, and distance to the upstream device. For more information about networking requirements for racks, see <a href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#facility-networking">Network</a> in the Amazon Web Services Outposts User Guide. </p> <ul> <li> <p> <code>OPTIC_10GBASE_SR</code>: 10GBASE-SR</p> </li> <li> <p> <code>OPTIC_10GBASE_IR</code>: 10GBASE-IR</p> </li> <li> <p> <code>OPTIC_10GBASE_LR</code>: 10GBASE-LR</p> </li> <li> <p> <code>OPTIC_40GBASE_SR</code>: 40GBASE-SR</p> </li> <li> <p> <code>OPTIC_40GBASE_ESR</code>: 40GBASE-ESR</p> </li> <li> <p> <code>OPTIC_40GBASE_IR4_LR4L</code>: 40GBASE-IR (LR4L)</p> </li> <li> <p> <code>OPTIC_40GBASE_LR4</code>: 40GBASE-LR4</p> </li> <li> <p> <code>OPTIC_100GBASE_SR4</code>: 100GBASE-SR4</p> </li> <li> <p> <code>OPTIC_100GBASE_CWDM4</code>: 100GBASE-CWDM4</p> </li> <li> <p> <code>OPTIC_100GBASE_LR4</code>: 100GBASE-LR4</p> </li> <li> <p> <code>OPTIC_100G_PSM4_MSA</code>: 100G PSM4 MSA</p> </li> <li> <p> <code>OPTIC_1000BASE_LX</code>: 1000Base-LX</p> </li> <li> <p> <code>OPTIC_1000BASE_SX</code> : 1000Base-SX</p> </li> </ul>', ], ], 'Order' => [ 'base' => '<p>Information about an order.</p>', 'refs' => [ 'CreateOrderOutput$Order' => '<p>Information about this order.</p>', 'GetOrderOutput$Order' => NULL, ], ], 'OrderId' => [ 'base' => NULL, 'refs' => [ 'CancelOrderInput$OrderId' => '<p> The ID of the order. </p>', 'CapacityTaskSummary$OrderId' => '<p>The ID of the Amazon Web Services Outposts order of the host associated with the capacity task.</p>', 'GetCapacityTaskOutput$OrderId' => '<p>ID of the Amazon Web Services Outposts order associated with the specified capacity task.</p>', 'GetOrderInput$OrderId' => '<p>The ID of the order.</p>', 'GetOutpostSupportedInstanceTypesInput$OrderId' => '<p>The ID for the Amazon Web Services Outposts order.</p>', 'LineItem$PreviousOrderId' => '<p>The ID of the previous order.</p>', 'Order$OrderId' => '<p>The ID of the order.</p>', 'OrderSummary$OrderId' => '<p> The ID of the order. </p>', 'StartCapacityTaskInput$OrderId' => '<p>The ID of the Amazon Web Services Outposts order associated with the specified capacity task.</p>', 'StartCapacityTaskOutput$OrderId' => '<p>ID of the Amazon Web Services Outposts order of the host associated with the capacity task.</p>', ], ], 'OrderStatus' => [ 'base' => NULL, 'refs' => [ 'Order$Status' => '<p>The status of the order.</p> <ul> <li> <p> <code>PREPARING</code> - Order is received and being prepared.</p> </li> <li> <p> <code>IN_PROGRESS</code> - Order is either being built, shipped, or installed. To get more details, see the line item status.</p> </li> <li> <p> <code>COMPLETED</code> - Order is complete.</p> </li> <li> <p> <code>CANCELLED</code> - Order is cancelled.</p> </li> <li> <p> <code>ERROR</code> - Customer should contact support.</p> </li> </ul> <note> <p>The following status are deprecated: <code>RECEIVED</code>, <code>PENDING</code>, <code>PROCESSING</code>, <code>INSTALLING</code>, and <code>FULFILLED</code>. </p> </note>', 'OrderSummary$Status' => '<p>The status of the order.</p> <ul> <li> <p> <code>PREPARING</code> - Order is received and is being prepared.</p> </li> <li> <p> <code>IN_PROGRESS</code> - Order is either being built, shipped, or installed. For more information, see the <code>LineItem</code> status.</p> </li> <li> <p> <code>COMPLETED</code> - Order is complete.</p> </li> <li> <p> <code>CANCELLED</code> - Order is cancelled.</p> </li> <li> <p> <code>ERROR</code> - Customer should contact support.</p> </li> </ul> <note> <p>The following statuses are deprecated: <code>RECEIVED</code>, <code>PENDING</code>, <code>PROCESSING</code>, <code>INSTALLING</code>, and <code>FULFILLED</code>. </p> </note>', ], ], 'OrderSummary' => [ 'base' => '<p> A summary of line items in your order. </p>', 'refs' => [ 'OrderSummaryListDefinition$member' => NULL, ], ], 'OrderSummaryListDefinition' => [ 'base' => NULL, 'refs' => [ 'ListOrdersOutput$Orders' => '<p> Information about the orders. </p>', ], ], 'OrderType' => [ 'base' => NULL, 'refs' => [ 'Order$OrderType' => '<p>The type of order.</p>', 'OrderSummary$OrderType' => '<p>The type of order.</p>', ], ], 'Outpost' => [ 'base' => '<p>Information about an Outpost.</p>', 'refs' => [ 'CreateOutpostOutput$Outpost' => NULL, 'GetOutpostOutput$Outpost' => NULL, 'UpdateOutpostOutput$Outpost' => NULL, 'outpostListDefinition$member' => NULL, ], ], 'OutpostArn' => [ 'base' => '<p>The Amazon Resource Name (ARN) of the Outpost.</p>', 'refs' => [ 'GetOutpostInstanceTypesOutput$OutpostArn' => NULL, 'Outpost$OutpostArn' => NULL, ], ], 'OutpostDescription' => [ 'base' => '<p>The description of the Outpost.</p>', 'refs' => [ 'CreateOutpostInput$Description' => NULL, 'Outpost$Description' => NULL, 'UpdateOutpostInput$Description' => NULL, ], ], 'OutpostId' => [ 'base' => NULL, 'refs' => [ 'CapacityTaskSummary$OutpostId' => '<p>The ID of the Outpost associated with the specified capacity task.</p>', 'DeleteOutpostInput$OutpostId' => '<p> The ID or ARN of the Outpost. </p>', 'GetCapacityTaskOutput$OutpostId' => '<p>ID of the Outpost associated with the specified capacity task.</p>', 'GetOutpostInput$OutpostId' => '<p> The ID or ARN of the Outpost. </p>', 'GetOutpostInstanceTypesInput$OutpostId' => '<p> The ID or ARN of the Outpost. </p>', 'GetOutpostInstanceTypesOutput$OutpostId' => '<p> The ID of the Outpost. </p>', 'Outpost$OutpostId' => '<p> The ID of the Outpost. </p>', 'StartCapacityTaskOutput$OutpostId' => '<p>ID of the Outpost associated with the capacity task.</p>', 'UpdateOutpostInput$OutpostId' => '<p> The ID or ARN of the Outpost. </p>', ], ], 'OutpostIdOnly' => [ 'base' => NULL, 'refs' => [ 'Order$OutpostId' => '<p> The ID of the Outpost in the order. </p>', 'OrderSummary$OutpostId' => '<p> The ID of the Outpost. </p>', ], ], 'OutpostIdentifier' => [ 'base' => NULL, 'refs' => [ 'CancelCapacityTaskInput$OutpostIdentifier' => '<p>ID or ARN of the Outpost associated with the capacity task that you want to cancel.</p>', 'CreateOrderInput$OutpostIdentifier' => '<p> The ID or the Amazon Resource Name (ARN) of the Outpost. </p>', 'GetCapacityTaskInput$OutpostIdentifier' => '<p>ID or ARN of the Outpost associated with the specified capacity task.</p>', 'GetOutpostSupportedInstanceTypesInput$OutpostIdentifier' => '<p>The ID or ARN of the Outpost.</p>', 'ListAssetsInput$OutpostIdentifier' => '<p> The ID or the Amazon Resource Name (ARN) of the Outpost. </p>', 'ListCapacityTasksInput$OutpostIdentifierFilter' => '<p>Filters the results by an Outpost ID or an Outpost ARN.</p>', 'ListOrdersInput$OutpostIdentifierFilter' => '<p> The ID or the Amazon Resource Name (ARN) of the Outpost. </p>', 'StartCapacityTaskInput$OutpostIdentifier' => '<p>The ID or ARN of the Outposts associated with the specified capacity task.</p>', ], ], 'OutpostName' => [ 'base' => '<p>The name of the Outpost.</p>', 'refs' => [ 'CreateOutpostInput$Name' => NULL, 'Outpost$Name' => NULL, 'UpdateOutpostInput$Name' => NULL, ], ], 'OwnerId' => [ 'base' => '<p>The Amazon Web Services account ID of the Outpost owner.</p>', 'refs' => [ 'Outpost$OwnerId' => NULL, ], ], 'PaymentOption' => [ 'base' => NULL, 'refs' => [ 'CreateOrderInput$PaymentOption' => '<p>The payment option.</p>', 'Order$PaymentOption' => '<p>The payment option for the order.</p>', ], ], 'PaymentTerm' => [ 'base' => NULL, 'refs' => [ 'CreateOrderInput$PaymentTerm' => '<p>The payment terms.</p>', 'Order$PaymentTerm' => '<p>The payment term.</p>', ], ], 'PostalCode' => [ 'base' => NULL, 'refs' => [ 'Address$PostalCode' => '<p>The postal code for the address.</p>', ], ], 'PowerConnector' => [ 'base' => NULL, 'refs' => [ 'RackPhysicalProperties$PowerConnector' => '<p>The power connector for the hardware. </p>', 'UpdateSiteRackPhysicalPropertiesInput$PowerConnector' => '<p>The power connector that Amazon Web Services should plan to provide for connections to the hardware. Note the correlation between <code>PowerPhase</code> and <code>PowerConnector</code>. </p> <ul> <li> <p>Single-phase AC feed</p> <ul> <li> <p> <b>L6-30P</b> – (common in US); 30A; single phase</p> </li> <li> <p> <b>IEC309 (blue)</b> – P+N+E, 6hr; 32 A; single phase</p> </li> </ul> </li> <li> <p>Three-phase AC feed</p> <ul> <li> <p> <b>AH530P7W (red)</b> – 3P+N+E, 7hr; 30A; three phase</p> </li> <li> <p> <b>AH532P6W (red)</b> – 3P+N+E, 6hr; 32A; three phase</p> </li> </ul> </li> </ul>', ], ], 'PowerDrawKva' => [ 'base' => NULL, 'refs' => [ 'RackPhysicalProperties$PowerDrawKva' => '<p>The power draw available at the hardware placement position for the rack. </p>', 'UpdateSiteRackPhysicalPropertiesInput$PowerDrawKva' => '<p>The power draw, in kVA, available at the hardware placement position for the rack.</p>', ], ], 'PowerFeedDrop' => [ 'base' => NULL, 'refs' => [ 'RackPhysicalProperties$PowerFeedDrop' => '<p>The position of the power feed.</p>', 'UpdateSiteRackPhysicalPropertiesInput$PowerFeedDrop' => '<p>Indicates whether the power feed comes above or below the rack. </p>', ], ], 'PowerPhase' => [ 'base' => NULL, 'refs' => [ 'RackPhysicalProperties$PowerPhase' => '<p>The power option that you can provide for hardware.</p>', 'UpdateSiteRackPhysicalPropertiesInput$PowerPhase' => '<p>The power option that you can provide for hardware. </p> <ul> <li> <p>Single-phase AC feed: 200 V to 277 V, 50 Hz or 60 Hz</p> </li> <li> <p>Three-phase AC feed: 346 V to 480 V, 50 Hz or 60 Hz</p> </li> </ul>', ], ], 'Quantity' => [ 'base' => NULL, 'refs' => [ 'EC2Capacity$Quantity' => '<p> The quantity of the EC2 capacity. </p>', ], ], 'RackElevation' => [ 'base' => NULL, 'refs' => [ 'AssetLocation$RackElevation' => '<p> The position of an asset in a rack measured in rack units. </p>', ], ], 'RackId' => [ 'base' => NULL, 'refs' => [ 'AssetInfo$RackId' => '<p> The rack ID of the asset. </p>', ], ], 'RackPhysicalProperties' => [ 'base' => '<p> Information about the physical and logistical details for racks at sites. For more information about hardware requirements for racks, see <a href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#checklist">Network readiness checklist</a> in the Amazon Web Services Outposts User Guide. </p>', 'refs' => [ 'CreateSiteInput$RackPhysicalProperties' => '<p> Information about the physical and logistical details for the rack at this site. For more information about hardware requirements for racks, see <a href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#checklist">Network readiness checklist</a> in the Amazon Web Services Outposts User Guide. </p>', 'Site$RackPhysicalProperties' => '<p> Information about the physical and logistical details for a rack at the site. </p>', ], ], 'RequestedInstancePools' => [ 'base' => NULL, 'refs' => [ 'GetCapacityTaskOutput$RequestedInstancePools' => '<p>List of instance pools requested in the capacity task.</p>', 'StartCapacityTaskInput$InstancePools' => '<p>The instance pools specified in the capacity task.</p>', 'StartCapacityTaskOutput$RequestedInstancePools' => '<p>List of the instance pools requested in the specified capacity task.</p>', ], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'ConflictException$ResourceType' => '<p>The type of the resource causing the conflict.</p>', ], ], 'ServerEndpoint' => [ 'base' => NULL, 'refs' => [ 'ConnectionDetails$ServerEndpoint' => '<p> The endpoint for the server. </p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>You have exceeded a service quota.</p>', 'refs' => [], ], 'ShipmentCarrier' => [ 'base' => NULL, 'refs' => [ 'ShipmentInformation$ShipmentCarrier' => '<p> The carrier of the shipment. </p>', ], ], 'ShipmentInformation' => [ 'base' => '<p> Information about a line item shipment. </p>', 'refs' => [ 'LineItem$ShipmentInformation' => '<p> Information about a line item shipment. </p>', ], ], 'Site' => [ 'base' => '<p>Information about a site.</p>', 'refs' => [ 'CreateSiteOutput$Site' => NULL, 'GetSiteOutput$Site' => NULL, 'UpdateSiteOutput$Site' => NULL, 'UpdateSiteRackPhysicalPropertiesOutput$Site' => NULL, 'siteListDefinition$member' => NULL, ], ], 'SiteArn' => [ 'base' => '<p>The Amazon Resource Name (ARN) of the site.</p>', 'refs' => [ 'Outpost$SiteArn' => NULL, 'Site$SiteArn' => NULL, ], ], 'SiteDescription' => [ 'base' => '<p>The description of the site.</p>', 'refs' => [ 'CreateSiteInput$Description' => NULL, 'Site$Description' => NULL, 'UpdateSiteInput$Description' => NULL, ], ], 'SiteId' => [ 'base' => '<p>The ID of the site.</p>', 'refs' => [ 'CreateOutpostInput$SiteId' => '<p> The ID or the Amazon Resource Name (ARN) of the site. </p>', 'DeleteSiteInput$SiteId' => '<p> The ID or the Amazon Resource Name (ARN) of the site. </p>', 'GetSiteAddressInput$SiteId' => '<p> The ID or the Amazon Resource Name (ARN) of the site. </p>', 'GetSiteAddressOutput$SiteId' => NULL, 'GetSiteInput$SiteId' => '<p> The ID or the Amazon Resource Name (ARN) of the site. </p>', 'Outpost$SiteId' => NULL, 'Site$SiteId' => NULL, 'UpdateSiteAddressInput$SiteId' => '<p> The ID or the Amazon Resource Name (ARN) of the site. </p>', 'UpdateSiteInput$SiteId' => '<p> The ID or the Amazon Resource Name (ARN) of the site. </p>', 'UpdateSiteRackPhysicalPropertiesInput$SiteId' => '<p> The ID or the Amazon Resource Name (ARN) of the site. </p>', ], ], 'SiteName' => [ 'base' => '<p>The name of the site.</p>', 'refs' => [ 'CreateSiteInput$Name' => NULL, 'Site$Name' => NULL, 'UpdateSiteInput$Name' => NULL, ], ], 'SiteNotes' => [ 'base' => NULL, 'refs' => [ 'CreateSiteInput$Notes' => '<p>Additional information that you provide about site access requirements, electrician scheduling, personal protective equipment, or regulation of equipment materials that could affect your installation process. </p>', 'Site$Notes' => '<p> Notes about a site. </p>', 'UpdateSiteInput$Notes' => '<p>Notes about a site.</p>', ], ], 'SkuCode' => [ 'base' => NULL, 'refs' => [ 'CatalogItem$CatalogItemId' => '<p> The ID of the catalog item. </p>', 'GetCatalogItemInput$CatalogItemId' => '<p>The ID of the catalog item.</p>', 'LineItem$CatalogItemId' => '<p> The ID of the catalog item.</p>', 'LineItemRequest$CatalogItemId' => '<p>The ID of the catalog item.</p>', ], ], 'StartCapacityTaskInput' => [ 'base' => NULL, 'refs' => [], ], 'StartCapacityTaskOutput' => [ 'base' => NULL, 'refs' => [], ], 'StartConnectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartConnectionResponse' => [ 'base' => NULL, 'refs' => [], ], 'StateOrRegion' => [ 'base' => NULL, 'refs' => [ 'Address$StateOrRegion' => '<p>The state for the address.</p>', 'Site$OperatingAddressStateOrRegion' => '<p> State or region where the hardware is installed and powered on. </p>', 'StateOrRegionList$member' => NULL, ], ], 'StateOrRegionList' => [ 'base' => NULL, 'refs' => [ 'ListSitesInput$OperatingAddressStateOrRegionFilter' => '<p>Filters the results by state or region.</p>', ], ], 'StatusList' => [ 'base' => NULL, 'refs' => [ 'ListAssetsInput$StatusFilter' => '<p>Filters the results by state.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'ConflictException$ResourceId' => '<p>The ID of the resource causing the conflict.</p>', ], ], 'SupportedHardwareType' => [ 'base' => NULL, 'refs' => [ 'CreateOutpostInput$SupportedHardwareType' => '<p> The type of hardware for this Outpost. </p>', 'Outpost$SupportedHardwareType' => '<p> The hardware type. </p>', 'UpdateOutpostInput$SupportedHardwareType' => '<p> The type of hardware for this Outpost. </p>', ], ], 'SupportedStorageEnum' => [ 'base' => NULL, 'refs' => [ 'SupportedStorageList$member' => NULL, ], ], 'SupportedStorageList' => [ 'base' => NULL, 'refs' => [ 'CatalogItem$SupportedStorage' => '<p> The supported storage options for the catalog item. </p>', 'ListCatalogItemsInput$SupportedStorageFilter' => '<p>Filters the results by storage option.</p>', ], ], 'SupportedUplinkGbps' => [ 'base' => NULL, 'refs' => [ 'SupportedUplinkGbpsListDefinition$member' => NULL, ], ], 'SupportedUplinkGbpsListDefinition' => [ 'base' => NULL, 'refs' => [ 'CatalogItem$SupportedUplinkGbps' => '<p> The uplink speed this catalog item requires for the connection to the Region. </p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'TagMap$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>The tag keys.</p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'CreateOutpostInput$Tags' => '<p>The tags to apply to the Outpost.</p>', 'CreateSiteInput$Tags' => '<p> The tags to apply to a site. </p>', 'ListTagsForResourceResponse$Tags' => '<p>The resource tags.</p>', 'Outpost$Tags' => '<p>The Outpost tags.</p>', 'Site$Tags' => '<p>The site tags.</p>', 'TagResourceRequest$Tags' => '<p>The tags to add to the resource.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagMap$value' => NULL, ], ], 'Token' => [ 'base' => '<p>The pagination token.</p>', 'refs' => [ 'GetOutpostInstanceTypesInput$NextToken' => NULL, 'GetOutpostInstanceTypesOutput$NextToken' => NULL, 'GetOutpostSupportedInstanceTypesInput$NextToken' => NULL, 'GetOutpostSupportedInstanceTypesOutput$NextToken' => NULL, 'ListAssetsInput$NextToken' => NULL, 'ListAssetsOutput$NextToken' => NULL, 'ListCapacityTasksInput$NextToken' => NULL, 'ListCapacityTasksOutput$NextToken' => NULL, 'ListCatalogItemsInput$NextToken' => NULL, 'ListCatalogItemsOutput$NextToken' => NULL, 'ListOrdersInput$NextToken' => NULL, 'ListOrdersOutput$NextToken' => NULL, 'ListOutpostsInput$NextToken' => NULL, 'ListOutpostsOutput$NextToken' => NULL, 'ListSitesInput$NextToken' => NULL, 'ListSitesOutput$NextToken' => NULL, ], ], 'TrackingId' => [ 'base' => NULL, 'refs' => [ 'ShipmentInformation$ShipmentTrackingNumber' => '<p> The tracking number of the shipment. </p>', ], ], 'UnderlayIpAddress' => [ 'base' => NULL, 'refs' => [ 'StartConnectionResponse$UnderlayIpAddress' => '<p> The underlay IP address. </p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateOutpostInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateOutpostOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSiteAddressInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSiteAddressOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSiteInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSiteOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSiteRackPhysicalPropertiesInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSiteRackPhysicalPropertiesOutput' => [ 'base' => NULL, 'refs' => [], ], 'UplinkCount' => [ 'base' => NULL, 'refs' => [ 'RackPhysicalProperties$UplinkCount' => '<p>The number of uplinks each Outpost network device.</p>', 'UpdateSiteRackPhysicalPropertiesInput$UplinkCount' => '<p>Racks come with two Outpost network devices. Depending on the supported uplink speed at the site, the Outpost network devices provide a variable number of uplinks. Specify the number of uplinks for each Outpost network device that you intend to use to connect the rack to your network. Note the correlation between <code>UplinkGbps</code> and <code>UplinkCount</code>. </p> <ul> <li> <p>1Gbps - Uplinks available: 1, 2, 4, 6, 8</p> </li> <li> <p>10Gbps - Uplinks available: 1, 2, 4, 8, 12, 16</p> </li> <li> <p>40 and 100 Gbps- Uplinks available: 1, 2, 4</p> </li> </ul>', ], ], 'UplinkGbps' => [ 'base' => NULL, 'refs' => [ 'RackPhysicalProperties$UplinkGbps' => '<p>The uplink speed the rack supports for the connection to the Region. </p>', 'UpdateSiteRackPhysicalPropertiesInput$UplinkGbps' => '<p>The uplink speed the rack should support for the connection to the Region. </p>', ], ], 'ValidationException' => [ 'base' => '<p>A parameter is not valid.</p>', 'refs' => [], ], 'WireGuardPublicKey' => [ 'base' => NULL, 'refs' => [ 'ConnectionDetails$ClientPublicKey' => '<p> The public key of the client. </p>', 'ConnectionDetails$ServerPublicKey' => '<p> The public key of the server. </p>', 'StartConnectionRequest$ClientPublicKey' => '<p> The public key of the client. </p>', ], ], 'outpostListDefinition' => [ 'base' => '<p>Information about the Outposts.</p>', 'refs' => [ 'ListOutpostsOutput$Outposts' => NULL, ], ], 'siteListDefinition' => [ 'base' => '<p>Information about the sites.</p>', 'refs' => [ 'ListSitesOutput$Sites' => NULL, ], ], ],];
