<?php
// This file was auto-generated from sdk-root/src/data/payment-cryptography-data/2022-02-03/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>You use the Amazon Web Services Payment Cryptography Data Plane to manage how encryption keys are used for payment-related transaction processing and associated cryptographic operations. You can encrypt, decrypt, generate, verify, and translate payment-related cryptographic operations in Amazon Web Services Payment Cryptography. For more information, see <a href="https://docs.aws.amazon.com/payment-cryptography/latest/userguide/data-operations.html">Data operations</a> in the <i>Amazon Web Services Payment Cryptography User Guide</i>.</p> <p>To manage your encryption keys, you use the <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/Welcome.html">Amazon Web Services Payment Cryptography Control Plane</a>. You can create, import, export, share, manage, and delete keys. You can also manage Identity and Access Management (IAM) policies for keys. </p>', 'operations' => [ 'DecryptData' => '<p>Decrypts ciphertext data to plaintext using a symmetric (TDES, AES), asymmetric (RSA), or derived (DUKPT or EMV) encryption key scheme. For more information, see <a href="https://docs.aws.amazon.com/payment-cryptography/latest/userguide/decrypt-data.html">Decrypt data</a> in the <i>Amazon Web Services Payment Cryptography User Guide</i>.</p> <p>You can use an encryption key generated within Amazon Web Services Payment Cryptography, or you can import your own encryption key by calling <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ImportKey.html">ImportKey</a>. For this operation, the key must have <code>KeyModesOfUse</code> set to <code>Decrypt</code>. In asymmetric decryption, Amazon Web Services Payment Cryptography decrypts the ciphertext using the private component of the asymmetric encryption key pair. For data encryption outside of Amazon Web Services Payment Cryptography, you can export the public component of the asymmetric key pair by calling <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_GetPublicKeyCertificate.html">GetPublicCertificate</a>.</p> <p>For symmetric and DUKPT decryption, Amazon Web Services Payment Cryptography supports <code>TDES</code> and <code>AES</code> algorithms. For EMV decryption, Amazon Web Services Payment Cryptography supports <code>TDES</code> algorithms. For asymmetric decryption, Amazon Web Services Payment Cryptography supports <code>RSA</code>. </p> <p>When you use TDES or TDES DUKPT, the ciphertext data length must be a multiple of 8 bytes. For AES or AES DUKPT, the ciphertext data length must be a multiple of 16 bytes. For RSA, it sould be equal to the key size unless padding is enabled.</p> <p>For information about valid keys for this operation, see <a href="https://docs.aws.amazon.com/payment-cryptography/latest/userguide/keys-validattributes.html">Understanding key attributes</a> and <a href="https://docs.aws.amazon.com/payment-cryptography/latest/userguide/crypto-ops-validkeys-ops.html">Key types for specific data operations</a> in the <i>Amazon Web Services Payment Cryptography User Guide</i>. </p> <p> <b>Cross-account use</b>: This operation can\'t be used across different Amazon Web Services accounts.</p> <p> <b>Related operations:</b> </p> <ul> <li> <p> <a>EncryptData</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_GetPublicKeyCertificate.html">GetPublicCertificate</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ImportKey.html">ImportKey</a> </p> </li> </ul>', 'EncryptData' => '<p>Encrypts plaintext data to ciphertext using a symmetric (TDES, AES), asymmetric (RSA), or derived (DUKPT or EMV) encryption key scheme. For more information, see <a href="https://docs.aws.amazon.com/payment-cryptography/latest/userguide/encrypt-data.html">Encrypt data</a> in the <i>Amazon Web Services Payment Cryptography User Guide</i>.</p> <p>You can generate an encryption key within Amazon Web Services Payment Cryptography by calling <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_CreateKey.html">CreateKey</a>. You can import your own encryption key by calling <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ImportKey.html">ImportKey</a>. For this operation, the key must have <code>KeyModesOfUse</code> set to <code>Encrypt</code>. In asymmetric encryption, plaintext is encrypted using public component. You can import the public component of an asymmetric key pair created outside Amazon Web Services Payment Cryptography by calling <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ImportKey.html">ImportKey</a>. </p> <p>For symmetric and DUKPT encryption, Amazon Web Services Payment Cryptography supports <code>TDES</code> and <code>AES</code> algorithms. For EMV encryption, Amazon Web Services Payment Cryptography supports <code>TDES</code> algorithms.For asymmetric encryption, Amazon Web Services Payment Cryptography supports <code>RSA</code>. </p> <p>When you use TDES or TDES DUKPT, the plaintext data length must be a multiple of 8 bytes. For AES or AES DUKPT, the plaintext data length must be a multiple of 16 bytes. For RSA, it sould be equal to the key size unless padding is enabled.</p> <p>To encrypt using DUKPT, you must already have a BDK (Base Derivation Key) key in your account with <code>KeyModesOfUse</code> set to <code>DeriveKey</code>, or you can generate a new DUKPT key by calling <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_CreateKey.html">CreateKey</a>. To encrypt using EMV, you must already have an IMK (Issuer Master Key) key in your account with <code>KeyModesOfUse</code> set to <code>DeriveKey</code>.</p> <p>For information about valid keys for this operation, see <a href="https://docs.aws.amazon.com/payment-cryptography/latest/userguide/keys-validattributes.html">Understanding key attributes</a> and <a href="https://docs.aws.amazon.com/payment-cryptography/latest/userguide/crypto-ops-validkeys-ops.html">Key types for specific data operations</a> in the <i>Amazon Web Services Payment Cryptography User Guide</i>.</p> <p> <b>Cross-account use</b>: This operation can\'t be used across different Amazon Web Services accounts.</p> <p> <b>Related operations:</b> </p> <ul> <li> <p> <a>DecryptData</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_GetPublicKeyCertificate.html">GetPublicCertificate</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ImportKey.html">ImportKey</a> </p> </li> <li> <p> <a>ReEncryptData</a> </p> </li> </ul>', 'GenerateCardValidationData' => '<p>Generates card-related validation data using algorithms such as Card Verification Values (CVV/CVV2), Dynamic Card Verification Values (dCVV/dCVV2), or Card Security Codes (CSC). For more information, see <a href="https://docs.aws.amazon.com/payment-cryptography/latest/userguide/generate-card-data.html">Generate card data</a> in the <i>Amazon Web Services Payment Cryptography User Guide</i>.</p> <p>This operation generates a CVV or CSC value that is printed on a payment credit or debit card during card production. The CVV or CSC, PAN (Primary Account Number) and expiration date of the card are required to check its validity during transaction processing. To begin this operation, a CVK (Card Verification Key) encryption key is required. You can use <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_CreateKey.html">CreateKey</a> or <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ImportKey.html">ImportKey</a> to establish a CVK within Amazon Web Services Payment Cryptography. The <code>KeyModesOfUse</code> should be set to <code>Generate</code> and <code>Verify</code> for a CVK encryption key. </p> <p>For information about valid keys for this operation, see <a href="https://docs.aws.amazon.com/payment-cryptography/latest/userguide/keys-validattributes.html">Understanding key attributes</a> and <a href="https://docs.aws.amazon.com/payment-cryptography/latest/userguide/crypto-ops-validkeys-ops.html">Key types for specific data operations</a> in the <i>Amazon Web Services Payment Cryptography User Guide</i>. </p> <p> <b>Cross-account use</b>: This operation can\'t be used across different Amazon Web Services accounts.</p> <p> <b>Related operations:</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ImportKey.html">ImportKey</a> </p> </li> <li> <p> <a>VerifyCardValidationData</a> </p> </li> </ul>', 'GenerateMac' => '<p>Generates a Message Authentication Code (MAC) cryptogram within Amazon Web Services Payment Cryptography. </p> <p>You can use this operation to authenticate card-related data by using known data values to generate MAC for data validation between the sending and receiving parties. This operation uses message data, a secret encryption key and MAC algorithm to generate a unique MAC value for transmission. The receiving party of the MAC must use the same message data, secret encryption key and MAC algorithm to reproduce another MAC value for comparision.</p> <p>You can use this operation to generate a DUPKT, CMAC, HMAC or EMV MAC by setting generation attributes and algorithm to the associated values. The MAC generation encryption key must have valid values for <code>KeyUsage</code> such as <code>TR31_M7_HMAC_KEY</code> for HMAC generation, and they key must have <code>KeyModesOfUse</code> set to <code>Generate</code> and <code>Verify</code>.</p> <p>For information about valid keys for this operation, see <a href="https://docs.aws.amazon.com/payment-cryptography/latest/userguide/keys-validattributes.html">Understanding key attributes</a> and <a href="https://docs.aws.amazon.com/payment-cryptography/latest/userguide/crypto-ops-validkeys-ops.html">Key types for specific data operations</a> in the <i>Amazon Web Services Payment Cryptography User Guide</i>. </p> <p> <b>Cross-account use</b>: This operation can\'t be used across different Amazon Web Services accounts.</p> <p> <b>Related operations:</b> </p> <ul> <li> <p> <a>VerifyMac</a> </p> </li> </ul>', 'GeneratePinData' => '<p>Generates pin-related data such as PIN, PIN Verification Value (PVV), PIN Block, and PIN Offset during new card issuance or reissuance. For more information, see <a href="https://docs.aws.amazon.com/payment-cryptography/latest/userguide/generate-pin-data.html">Generate PIN data</a> in the <i>Amazon Web Services Payment Cryptography User Guide</i>.</p> <p>PIN data is never transmitted in clear to or from Amazon Web Services Payment Cryptography. This operation generates PIN, PVV, or PIN Offset and then encrypts it using Pin Encryption Key (PEK) to create an <code>EncryptedPinBlock</code> for transmission from Amazon Web Services Payment Cryptography. This operation uses a separate Pin Verification Key (PVK) for VISA PVV generation. </p> <p>For information about valid keys for this operation, see <a href="https://docs.aws.amazon.com/payment-cryptography/latest/userguide/keys-validattributes.html">Understanding key attributes</a> and <a href="https://docs.aws.amazon.com/payment-cryptography/latest/userguide/crypto-ops-validkeys-ops.html">Key types for specific data operations</a> in the <i>Amazon Web Services Payment Cryptography User Guide</i>.</p> <p> <b>Cross-account use</b>: This operation can\'t be used across different Amazon Web Services accounts.</p> <p> <b>Related operations:</b> </p> <ul> <li> <p> <a>GenerateCardValidationData</a> </p> </li> <li> <p> <a>TranslatePinData</a> </p> </li> <li> <p> <a>VerifyPinData</a> </p> </li> </ul>', 'ReEncryptData' => '<p>Re-encrypt ciphertext using DUKPT or Symmetric data encryption keys. </p> <p>You can either generate an encryption key within Amazon Web Services Payment Cryptography by calling <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_CreateKey.html">CreateKey</a> or import your own encryption key by calling <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ImportKey.html">ImportKey</a>. The <code>KeyArn</code> for use with this operation must be in a compatible key state with <code>KeyModesOfUse</code> set to <code>Encrypt</code>. </p> <p>For symmetric and DUKPT encryption, Amazon Web Services Payment Cryptography supports <code>TDES</code> and <code>AES</code> algorithms. To encrypt using DUKPT, a DUKPT key must already exist within your account with <code>KeyModesOfUse</code> set to <code>DeriveKey</code> or a new DUKPT can be generated by calling <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_CreateKey.html">CreateKey</a>.</p> <p>For information about valid keys for this operation, see <a href="https://docs.aws.amazon.com/payment-cryptography/latest/userguide/keys-validattributes.html">Understanding key attributes</a> and <a href="https://docs.aws.amazon.com/payment-cryptography/latest/userguide/crypto-ops-validkeys-ops.html">Key types for specific data operations</a> in the <i>Amazon Web Services Payment Cryptography User Guide</i>. </p> <p> <b>Cross-account use</b>: This operation can\'t be used across different Amazon Web Services accounts.</p> <p> <b>Related operations:</b> </p> <ul> <li> <p> <a>DecryptData</a> </p> </li> <li> <p> <a>EncryptData</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_GetPublicKeyCertificate.html">GetPublicCertificate</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ImportKey.html">ImportKey</a> </p> </li> </ul>', 'TranslatePinData' => '<p>Translates encrypted PIN block from and to ISO 9564 formats 0,1,3,4. For more information, see <a href="https://docs.aws.amazon.com/payment-cryptography/latest/userguide/translate-pin-data.html">Translate PIN data</a> in the <i>Amazon Web Services Payment Cryptography User Guide</i>.</p> <p>PIN block translation involves changing the encrytion of PIN block from one encryption key to another encryption key and changing PIN block format from one to another without PIN block data leaving Amazon Web Services Payment Cryptography. The encryption key transformation can be from PEK (Pin Encryption Key) to BDK (Base Derivation Key) for DUKPT or from BDK for DUKPT to PEK. Amazon Web Services Payment Cryptography supports <code>TDES</code> and <code>AES</code> key derivation type for DUKPT translations. </p> <p>The allowed combinations of PIN block format translations are guided by PCI. It is important to note that not all encrypted PIN block formats (example, format 1) require PAN (Primary Account Number) as input. And as such, PIN block format that requires PAN (example, formats 0,3,4) cannot be translated to a format (format 1) that does not require a PAN for generation. </p> <p>For information about valid keys for this operation, see <a href="https://docs.aws.amazon.com/payment-cryptography/latest/userguide/keys-validattributes.html">Understanding key attributes</a> and <a href="https://docs.aws.amazon.com/payment-cryptography/latest/userguide/crypto-ops-validkeys-ops.html">Key types for specific data operations</a> in the <i>Amazon Web Services Payment Cryptography User Guide</i>.</p> <note> <p>Amazon Web Services Payment Cryptography currently supports ISO PIN block 4 translation for PIN block built using legacy PAN length. That is, PAN is the right most 12 digits excluding the check digits.</p> </note> <p> <b>Cross-account use</b>: This operation can\'t be used across different Amazon Web Services accounts.</p> <p> <b>Related operations:</b> </p> <ul> <li> <p> <a>GeneratePinData</a> </p> </li> <li> <p> <a>VerifyPinData</a> </p> </li> </ul>', 'VerifyAuthRequestCryptogram' => '<p>Verifies Authorization Request Cryptogram (ARQC) for a EMV chip payment card authorization. For more information, see <a href="https://docs.aws.amazon.com/payment-cryptography/latest/userguide/data-operations.verifyauthrequestcryptogram.html">Verify auth request cryptogram</a> in the <i>Amazon Web Services Payment Cryptography User Guide</i>.</p> <p>ARQC generation is done outside of Amazon Web Services Payment Cryptography and is typically generated on a point of sale terminal for an EMV chip card to obtain payment authorization during transaction time. For ARQC verification, you must first import the ARQC generated outside of Amazon Web Services Payment Cryptography by calling <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ImportKey.html">ImportKey</a>. This operation uses the imported ARQC and an major encryption key (DUKPT) created by calling <a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_CreateKey.html">CreateKey</a> to either provide a boolean ARQC verification result or provide an APRC (Authorization Response Cryptogram) response using Method 1 or Method 2. The <code>ARPC_METHOD_1</code> uses <code>AuthResponseCode</code> to generate ARPC and <code>ARPC_METHOD_2</code> uses <code>CardStatusUpdate</code> to generate ARPC. </p> <p>For information about valid keys for this operation, see <a href="https://docs.aws.amazon.com/payment-cryptography/latest/userguide/keys-validattributes.html">Understanding key attributes</a> and <a href="https://docs.aws.amazon.com/payment-cryptography/latest/userguide/crypto-ops-validkeys-ops.html">Key types for specific data operations</a> in the <i>Amazon Web Services Payment Cryptography User Guide</i>.</p> <p> <b>Cross-account use</b>: This operation can\'t be used across different Amazon Web Services accounts.</p> <p> <b>Related operations:</b> </p> <ul> <li> <p> <a>VerifyCardValidationData</a> </p> </li> <li> <p> <a>VerifyPinData</a> </p> </li> </ul>', 'VerifyCardValidationData' => '<p>Verifies card-related validation data using algorithms such as Card Verification Values (CVV/CVV2), Dynamic Card Verification Values (dCVV/dCVV2) and Card Security Codes (CSC). For more information, see <a href="https://docs.aws.amazon.com/payment-cryptography/latest/userguide/verify-card-data.html">Verify card data</a> in the <i>Amazon Web Services Payment Cryptography User Guide</i>.</p> <p>This operation validates the CVV or CSC codes that is printed on a payment credit or debit card during card payment transaction. The input values are typically provided as part of an inbound transaction to an issuer or supporting platform partner. Amazon Web Services Payment Cryptography uses CVV or CSC, PAN (Primary Account Number) and expiration date of the card to check its validity during transaction processing. In this operation, the CVK (Card Verification Key) encryption key for use with card data verification is same as the one in used for <a>GenerateCardValidationData</a>. </p> <p>For information about valid keys for this operation, see <a href="https://docs.aws.amazon.com/payment-cryptography/latest/userguide/keys-validattributes.html">Understanding key attributes</a> and <a href="https://docs.aws.amazon.com/payment-cryptography/latest/userguide/crypto-ops-validkeys-ops.html">Key types for specific data operations</a> in the <i>Amazon Web Services Payment Cryptography User Guide</i>. </p> <p> <b>Cross-account use</b>: This operation can\'t be used across different Amazon Web Services accounts.</p> <p> <b>Related operations:</b> </p> <ul> <li> <p> <a>GenerateCardValidationData</a> </p> </li> <li> <p> <a>VerifyAuthRequestCryptogram</a> </p> </li> <li> <p> <a>VerifyPinData</a> </p> </li> </ul>', 'VerifyMac' => '<p>Verifies a Message Authentication Code (MAC). </p> <p>You can use this operation to verify MAC for message data authentication such as . In this operation, you must use the same message data, secret encryption key and MAC algorithm that was used to generate MAC. You can use this operation to verify a DUPKT, CMAC, HMAC or EMV MAC by setting generation attributes and algorithm to the associated values. </p> <p>For information about valid keys for this operation, see <a href="https://docs.aws.amazon.com/payment-cryptography/latest/userguide/keys-validattributes.html">Understanding key attributes</a> and <a href="https://docs.aws.amazon.com/payment-cryptography/latest/userguide/crypto-ops-validkeys-ops.html">Key types for specific data operations</a> in the <i>Amazon Web Services Payment Cryptography User Guide</i>. </p> <p> <b>Cross-account use</b>: This operation can\'t be used across different Amazon Web Services accounts.</p> <p> <b>Related operations:</b> </p> <ul> <li> <p> <a>GenerateMac</a> </p> </li> </ul>', 'VerifyPinData' => '<p>Verifies pin-related data such as PIN and PIN Offset using algorithms including VISA PVV and IBM3624. For more information, see <a href="https://docs.aws.amazon.com/payment-cryptography/latest/userguide/verify-pin-data.html">Verify PIN data</a> in the <i>Amazon Web Services Payment Cryptography User Guide</i>.</p> <p>This operation verifies PIN data for user payment card. A card holder PIN data is never transmitted in clear to or from Amazon Web Services Payment Cryptography. This operation uses PIN Verification Key (PVK) for PIN or PIN Offset generation and then encrypts it using PIN Encryption Key (PEK) to create an <code>EncryptedPinBlock</code> for transmission from Amazon Web Services Payment Cryptography. </p> <p>For information about valid keys for this operation, see <a href="https://docs.aws.amazon.com/payment-cryptography/latest/userguide/keys-validattributes.html">Understanding key attributes</a> and <a href="https://docs.aws.amazon.com/payment-cryptography/latest/userguide/crypto-ops-validkeys-ops.html">Key types for specific data operations</a> in the <i>Amazon Web Services Payment Cryptography User Guide</i>. </p> <p> <b>Cross-account use</b>: This operation can\'t be used across different Amazon Web Services accounts.</p> <p> <b>Related operations:</b> </p> <ul> <li> <p> <a>GeneratePinData</a> </p> </li> <li> <p> <a>TranslatePinData</a> </p> </li> </ul>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You do not have sufficient access to perform this action.</p>', 'refs' => [], ], 'AmexCardSecurityCodeVersion1' => [ 'base' => '<p>Card data parameters that are required to generate a Card Security Code (CSC2) for an AMEX payment card.</p>', 'refs' => [ 'CardGenerationAttributes$AmexCardSecurityCodeVersion1' => NULL, 'CardVerificationAttributes$AmexCardSecurityCodeVersion1' => NULL, ], ], 'AmexCardSecurityCodeVersion2' => [ 'base' => '<p>Card data parameters that are required to generate a Card Security Code (CSC2) for an AMEX payment card.</p>', 'refs' => [ 'CardGenerationAttributes$AmexCardSecurityCodeVersion2' => '<p>Card data parameters that are required to generate a Card Security Code (CSC2) for an AMEX payment card.</p>', 'CardVerificationAttributes$AmexCardSecurityCodeVersion2' => '<p>Card data parameters that are required to verify a Card Security Code (CSC2) for an AMEX payment card.</p>', ], ], 'ApplicationCryptogramType' => [ 'base' => NULL, 'refs' => [ 'SessionKeyDerivationValue$ApplicationCryptogram' => '<p>The cryptogram provided by the terminal during transaction processing.</p>', ], ], 'AsymmetricEncryptionAttributes' => [ 'base' => '<p>Parameters for plaintext encryption using asymmetric keys.</p>', 'refs' => [ 'EncryptionDecryptionAttributes$Asymmetric' => NULL, ], ], 'AuthRequestCryptogramType' => [ 'base' => NULL, 'refs' => [ 'VerifyAuthRequestCryptogramInput$AuthRequestCryptogram' => '<p>The auth request cryptogram imported into Amazon Web Services Payment Cryptography for ARQC verification using a major encryption key and transaction data.</p>', ], ], 'AuthResponseValueType' => [ 'base' => NULL, 'refs' => [ 'VerifyAuthRequestCryptogramOutput$AuthResponseValue' => '<p>The result for ARQC verification or ARPC generation within Amazon Web Services Payment Cryptography.</p>', ], ], 'CardExpiryDateType' => [ 'base' => NULL, 'refs' => [ 'AmexCardSecurityCodeVersion1$CardExpiryDate' => '<p>The expiry date of a payment card.</p>', 'AmexCardSecurityCodeVersion2$CardExpiryDate' => '<p>The expiry date of a payment card.</p>', 'CardVerificationValue1$CardExpiryDate' => '<p>The expiry date of a payment card.</p>', 'CardVerificationValue2$CardExpiryDate' => '<p>The expiry date of a payment card.</p>', 'DiscoverDynamicCardVerificationCode$CardExpiryDate' => '<p>The expiry date of a payment card.</p>', 'DynamicCardVerificationValue$CardExpiryDate' => '<p>The expiry date of a payment card.</p>', ], ], 'CardGenerationAttributes' => [ 'base' => '<p>Card data parameters that are required to generate Card Verification Values (CVV/CVV2), Dynamic Card Verification Values (dCVV/dCVV2), or Card Security Codes (CSC).</p>', 'refs' => [ 'GenerateCardValidationDataInput$GenerationAttributes' => '<p>The algorithm for generating CVV or CSC values for the card within Amazon Web Services Payment Cryptography.</p>', ], ], 'CardHolderVerificationValue' => [ 'base' => '<p>Card data parameters that are required to generate a cardholder verification value for the payment card.</p>', 'refs' => [ 'CardGenerationAttributes$CardHolderVerificationValue' => '<p>Card data parameters that are required to generate a cardholder verification value for the payment card.</p>', 'CardVerificationAttributes$CardHolderVerificationValue' => '<p>Card data parameters that are required to verify a cardholder verification value for the payment card.</p>', ], ], 'CardVerificationAttributes' => [ 'base' => '<p>Card data parameters that are requried to verify Card Verification Values (CVV/CVV2), Dynamic Card Verification Values (dCVV/dCVV2), or Card Security Codes (CSC).</p>', 'refs' => [ 'VerifyCardValidationDataInput$VerificationAttributes' => '<p>The algorithm to use for verification of card data within Amazon Web Services Payment Cryptography.</p>', ], ], 'CardVerificationValue1' => [ 'base' => '<p>Card data parameters that are required to verify CVV (Card Verification Value) for the payment card.</p>', 'refs' => [ 'CardGenerationAttributes$CardVerificationValue1' => '<p>Card data parameters that are required to generate Card Verification Value (CVV) for the payment card.</p>', 'CardVerificationAttributes$CardVerificationValue1' => '<p>Card data parameters that are required to verify Card Verification Value (CVV) for the payment card.</p>', ], ], 'CardVerificationValue2' => [ 'base' => '<p>Card data parameters that are required to verify Card Verification Value (CVV2) for the payment card.</p>', 'refs' => [ 'CardGenerationAttributes$CardVerificationValue2' => '<p>Card data parameters that are required to generate Card Verification Value (CVV2) for the payment card.</p>', 'CardVerificationAttributes$CardVerificationValue2' => '<p>Card data parameters that are required to verify Card Verification Value (CVV2) for the payment card.</p>', ], ], 'CipherTextType' => [ 'base' => NULL, 'refs' => [ 'DecryptDataInput$CipherText' => '<p>The ciphertext to decrypt.</p>', 'EncryptDataOutput$CipherText' => '<p>The encrypted ciphertext.</p>', 'ReEncryptDataInput$CipherText' => '<p>Ciphertext to be encrypted. The minimum allowed length is 16 bytes and maximum allowed length is 4096 bytes.</p>', 'ReEncryptDataOutput$CipherText' => '<p>The encrypted ciphertext.</p>', ], ], 'CryptogramAuthResponse' => [ 'base' => '<p>Parameters that are required for Authorization Response Cryptogram (ARPC) generation after Authorization Request Cryptogram (ARQC) verification is successful.</p>', 'refs' => [ 'VerifyAuthRequestCryptogramInput$AuthResponseAttributes' => '<p>The attributes and values for auth request cryptogram verification. These parameters are required in case using ARPC Method 1 or Method 2 for ARQC verification.</p>', ], ], 'CryptogramVerificationArpcMethod1' => [ 'base' => '<p>Parameters that are required for ARPC response generation using method1 after ARQC verification is successful.</p>', 'refs' => [ 'CryptogramAuthResponse$ArpcMethod1' => '<p>Parameters that are required for ARPC response generation using method1 after ARQC verification is successful.</p>', ], ], 'CryptogramVerificationArpcMethod2' => [ 'base' => '<p>Parameters that are required for ARPC response generation using method2 after ARQC verification is successful.</p>', 'refs' => [ 'CryptogramAuthResponse$ArpcMethod2' => '<p>Parameters that are required for ARPC response generation using method2 after ARQC verification is successful.</p>', ], ], 'DecimalizationTableType' => [ 'base' => NULL, 'refs' => [ 'Ibm3624NaturalPin$DecimalizationTable' => '<p>The decimalization table to use for IBM 3624 PIN algorithm. The table is used to convert the algorithm intermediate result from hexadecimal characters to decimal.</p>', 'Ibm3624PinFromOffset$DecimalizationTable' => '<p>The decimalization table to use for IBM 3624 PIN algorithm. The table is used to convert the algorithm intermediate result from hexadecimal characters to decimal.</p>', 'Ibm3624PinOffset$DecimalizationTable' => '<p>The decimalization table to use for IBM 3624 PIN algorithm. The table is used to convert the algorithm intermediate result from hexadecimal characters to decimal.</p>', 'Ibm3624PinVerification$DecimalizationTable' => '<p>The decimalization table to use for IBM 3624 PIN algorithm. The table is used to convert the algorithm intermediate result from hexadecimal characters to decimal.</p>', 'Ibm3624RandomPin$DecimalizationTable' => '<p>The decimalization table to use for IBM 3624 PIN algorithm. The table is used to convert the algorithm intermediate result from hexadecimal characters to decimal.</p>', ], ], 'DecryptDataInput' => [ 'base' => NULL, 'refs' => [], ], 'DecryptDataOutput' => [ 'base' => NULL, 'refs' => [], ], 'DiscoverDynamicCardVerificationCode' => [ 'base' => '<p>Parameters that are required to generate or verify dCVC (Dynamic Card Verification Code).</p>', 'refs' => [ 'CardVerificationAttributes$DiscoverDynamicCardVerificationCode' => '<p>Card data parameters that are required to verify CDynamic Card Verification Code (dCVC) for the payment card.</p>', ], ], 'DukptAttributes' => [ 'base' => '<p>Parameters that are used for Derived Unique Key Per Transaction (DUKPT) derivation algorithm.</p>', 'refs' => [ 'VerifyPinDataInput$DukptAttributes' => '<p>The attributes and values for the DUKPT encrypted PIN block data.</p>', ], ], 'DukptDerivationAttributes' => [ 'base' => '<p>Parameters required for encryption or decryption of data using DUKPT.</p>', 'refs' => [ 'TranslatePinDataInput$IncomingDukptAttributes' => '<p>The attributes and values to use for incoming DUKPT encryption key for PIN block translation.</p>', 'TranslatePinDataInput$OutgoingDukptAttributes' => '<p>The attributes and values to use for outgoing DUKPT encryption key after PIN block translation.</p>', ], ], 'DukptDerivationType' => [ 'base' => NULL, 'refs' => [ 'DukptAttributes$DukptDerivationType' => '<p>The key type derived using DUKPT from a Base Derivation Key (BDK) and Key Serial Number (KSN). This must be less than or equal to the strength of the BDK. For example, you can\'t use <code>AES_128</code> as a derivation type for a BDK of <code>AES_128</code> or <code>TDES_2KEY</code>.</p>', 'DukptDerivationAttributes$DukptKeyDerivationType' => '<p>The key type derived using DUKPT from a Base Derivation Key (BDK) and Key Serial Number (KSN). This must be less than or equal to the strength of the BDK. For example, you can\'t use <code>AES_128</code> as a derivation type for a BDK of <code>AES_128</code> or <code>TDES_2KEY</code> </p>', 'DukptEncryptionAttributes$DukptKeyDerivationType' => '<p>The key type encrypted using DUKPT from a Base Derivation Key (BDK) and Key Serial Number (KSN). This must be less than or equal to the strength of the BDK. For example, you can\'t use <code>AES_128</code> as a derivation type for a BDK of <code>AES_128</code> or <code>TDES_2KEY</code> </p>', 'MacAlgorithmDukpt$DukptDerivationType' => '<p>The key type derived using DUKPT from a Base Derivation Key (BDK) and Key Serial Number (KSN). This must be less than or equal to the strength of the BDK. For example, you can\'t use <code>AES_128</code> as a derivation type for a BDK of <code>AES_128</code> or <code>TDES_2KEY</code>.</p>', ], ], 'DukptEncryptionAttributes' => [ 'base' => '<p>Parameters that are required to encrypt plaintext data using DUKPT.</p>', 'refs' => [ 'EncryptionDecryptionAttributes$Dukpt' => NULL, 'ReEncryptionAttributes$Dukpt' => NULL, ], ], 'DukptEncryptionMode' => [ 'base' => NULL, 'refs' => [ 'DukptEncryptionAttributes$Mode' => '<p>The block cipher method to use for encryption.</p> <p>The default is CBC.</p>', ], ], 'DukptKeyVariant' => [ 'base' => NULL, 'refs' => [ 'DukptDerivationAttributes$DukptKeyVariant' => '<p>The type of use of DUKPT, which can be for incoming data decryption, outgoing data encryption, or both.</p>', 'DukptEncryptionAttributes$DukptKeyVariant' => '<p>The type of use of DUKPT, which can be incoming data decryption, outgoing data encryption, or both.</p>', 'MacAlgorithmDukpt$DukptKeyVariant' => '<p>The type of use of DUKPT, which can be MAC generation, MAC verification, or both.</p>', ], ], 'DynamicCardVerificationCode' => [ 'base' => '<p>Parameters that are required to generate or verify Dynamic Card Verification Value (dCVV).</p>', 'refs' => [ 'CardGenerationAttributes$DynamicCardVerificationCode' => '<p>Card data parameters that are required to generate CDynamic Card Verification Code (dCVC) for the payment card.</p>', 'CardVerificationAttributes$DynamicCardVerificationCode' => '<p>Card data parameters that are required to verify CDynamic Card Verification Code (dCVC) for the payment card.</p>', ], ], 'DynamicCardVerificationValue' => [ 'base' => '<p>Parameters that are required to generate or verify Dynamic Card Verification Value (dCVV).</p>', 'refs' => [ 'CardGenerationAttributes$DynamicCardVerificationValue' => '<p>Card data parameters that are required to generate CDynamic Card Verification Value (dCVV) for the payment card.</p>', 'CardVerificationAttributes$DynamicCardVerificationValue' => '<p>Card data parameters that are required to verify CDynamic Card Verification Value (dCVV) for the payment card.</p>', ], ], 'EmvEncryptionAttributes' => [ 'base' => '<p>Parameters for plaintext encryption using EMV keys.</p>', 'refs' => [ 'EncryptionDecryptionAttributes$Emv' => '<p>Parameters for plaintext encryption using EMV keys.</p>', ], ], 'EmvEncryptionMode' => [ 'base' => NULL, 'refs' => [ 'EmvEncryptionAttributes$Mode' => '<p>The block cipher method to use for encryption.</p>', ], ], 'EmvMajorKeyDerivationMode' => [ 'base' => NULL, 'refs' => [ 'EmvEncryptionAttributes$MajorKeyDerivationMode' => '<p>The EMV derivation mode to use for ICC master key derivation as per EMV version 4.3 book 2.</p>', ], ], 'EncryptDataInput' => [ 'base' => NULL, 'refs' => [], ], 'EncryptDataOutput' => [ 'base' => NULL, 'refs' => [], ], 'EncryptedPinBlockType' => [ 'base' => NULL, 'refs' => [ 'GeneratePinDataOutput$EncryptedPinBlock' => '<p>The PIN block encrypted under PEK from Amazon Web Services Payment Cryptography. The encrypted PIN block is a composite of PAN (Primary Account Number) and PIN (Personal Identification Number), generated in accordance with ISO 9564 standard.</p>', 'Ibm3624PinOffset$EncryptedPinBlock' => '<p>The encrypted PIN block data. According to ISO 9564 standard, a PIN Block is an encoded representation of a payment card Personal Account Number (PAN) and the cardholder Personal Identification Number (PIN).</p>', 'TranslatePinDataOutput$PinBlock' => '<p>The outgoing encrypted PIN block data after translation.</p>', 'VerifyPinDataInput$EncryptedPinBlock' => '<p>The encrypted PIN block data that Amazon Web Services Payment Cryptography verifies.</p>', 'VisaPinVerificationValue$EncryptedPinBlock' => '<p>The encrypted PIN block data to verify.</p>', ], ], 'EncryptionDecryptionAttributes' => [ 'base' => '<p>Parameters that are required to perform encryption and decryption operations.</p>', 'refs' => [ 'DecryptDataInput$DecryptionAttributes' => '<p>The encryption key type and attributes for ciphertext decryption.</p>', 'EncryptDataInput$EncryptionAttributes' => '<p>The encryption key type and attributes for plaintext encryption.</p>', ], ], 'EncryptionMode' => [ 'base' => NULL, 'refs' => [ 'SymmetricEncryptionAttributes$Mode' => '<p>The block cipher method to use for encryption.</p>', ], ], 'GenerateCardValidationDataInput' => [ 'base' => NULL, 'refs' => [], ], 'GenerateCardValidationDataOutput' => [ 'base' => NULL, 'refs' => [], ], 'GenerateMacInput' => [ 'base' => NULL, 'refs' => [], ], 'GenerateMacOutput' => [ 'base' => NULL, 'refs' => [], ], 'GeneratePinDataInput' => [ 'base' => NULL, 'refs' => [], ], 'GeneratePinDataOutput' => [ 'base' => NULL, 'refs' => [], ], 'HexEvenLengthBetween16And32' => [ 'base' => NULL, 'refs' => [ 'TranslatePinDataInput$EncryptedPinBlock' => '<p>The encrypted PIN block data that Amazon Web Services Payment Cryptography translates.</p>', ], ], 'HexLengthBetween10And24' => [ 'base' => NULL, 'refs' => [ 'DukptAttributes$KeySerialNumber' => '<p>The unique identifier known as Key Serial Number (KSN) that comes from an encrypting device using DUKPT encryption method. The KSN is derived from the encrypting device unique identifier and an internal transaction counter.</p>', 'DukptDerivationAttributes$KeySerialNumber' => '<p>The unique identifier known as Key Serial Number (KSN) that comes from an encrypting device using DUKPT encryption method. The KSN is derived from the encrypting device unique identifier and an internal transaction counter.</p>', 'DukptEncryptionAttributes$KeySerialNumber' => '<p>The unique identifier known as Key Serial Number (KSN) that comes from an encrypting device using DUKPT encryption method. The KSN is derived from the encrypting device unique identifier and an internal transaction counter.</p>', 'MacAlgorithmDukpt$KeySerialNumber' => '<p>The unique identifier known as Key Serial Number (KSN) that comes from an encrypting device using DUKPT encryption method. The KSN is derived from the encrypting device unique identifier and an internal transaction counter.</p>', ], ], 'HexLengthBetween2And4' => [ 'base' => NULL, 'refs' => [ 'CardHolderVerificationValue$ApplicationTransactionCounter' => '<p>The transaction counter value that comes from a point of sale terminal.</p>', 'DiscoverDynamicCardVerificationCode$ApplicationTransactionCounter' => '<p>The transaction counter value that comes from the terminal.</p>', 'DynamicCardVerificationCode$ApplicationTransactionCounter' => '<p>The transaction counter value that comes from the terminal.</p>', 'DynamicCardVerificationValue$ApplicationTransactionCounter' => '<p>The transaction counter value that comes from the terminal.</p>', 'SessionKeyDerivationValue$ApplicationTransactionCounter' => '<p>The transaction counter that is provided by the terminal during transaction processing.</p>', 'SessionKeyEmv2000$ApplicationTransactionCounter' => '<p>The transaction counter that is provided by the terminal during transaction processing.</p>', 'SessionKeyEmvCommon$ApplicationTransactionCounter' => '<p>The transaction counter that is provided by the terminal during transaction processing.</p>', 'SessionKeyMastercard$ApplicationTransactionCounter' => '<p>The transaction counter that is provided by the terminal during transaction processing.</p>', ], ], 'HexLengthBetween2And8' => [ 'base' => NULL, 'refs' => [ 'CardHolderVerificationValue$UnpredictableNumber' => '<p>A random number generated by the issuer.</p>', 'DiscoverDynamicCardVerificationCode$UnpredictableNumber' => '<p>A random number that is generated by the issuer.</p>', 'DynamicCardVerificationCode$UnpredictableNumber' => '<p>A random number generated by the issuer.</p>', 'SessionKeyMastercard$UnpredictableNumber' => '<p>A random number generated by the issuer.</p>', ], ], 'HexLengthEquals1' => [ 'base' => NULL, 'refs' => [ 'Ibm3624NaturalPin$PinValidationDataPadCharacter' => '<p>The padding character for validation data.</p>', 'Ibm3624PinFromOffset$PinValidationDataPadCharacter' => '<p>The padding character for validation data.</p>', 'Ibm3624PinOffset$PinValidationDataPadCharacter' => '<p>The padding character for validation data.</p>', 'Ibm3624PinVerification$PinValidationDataPadCharacter' => '<p>The padding character for validation data.</p>', 'Ibm3624RandomPin$PinValidationDataPadCharacter' => '<p>The padding character for validation data.</p>', ], ], 'HexLengthEquals4' => [ 'base' => NULL, 'refs' => [ 'CryptogramVerificationArpcMethod1$AuthResponseCode' => '<p>The auth code used to calculate APRC after ARQC verification is successful. This is the same auth code used for ARQC generation outside of Amazon Web Services Payment Cryptography.</p>', ], ], 'HexLengthEquals8' => [ 'base' => NULL, 'refs' => [ 'CryptogramVerificationArpcMethod2$CardStatusUpdate' => '<p>The data indicating whether the issuer approves or declines an online transaction using an EMV chip card.</p>', ], ], 'Ibm3624NaturalPin' => [ 'base' => '<p>Parameters that are required to generate or verify Ibm3624 natural PIN.</p>', 'refs' => [ 'PinGenerationAttributes$Ibm3624NaturalPin' => '<p>Parameters that are required to generate or verify Ibm3624 natural PIN.</p>', ], ], 'Ibm3624PinFromOffset' => [ 'base' => '<p>Parameters that are required to generate or verify Ibm3624 PIN from offset PIN.</p>', 'refs' => [ 'PinGenerationAttributes$Ibm3624PinFromOffset' => '<p>Parameters that are required to generate or verify Ibm3624 PIN from offset PIN.</p>', ], ], 'Ibm3624PinOffset' => [ 'base' => '<p>Pparameters that are required to generate or verify Ibm3624 PIN offset PIN.</p>', 'refs' => [ 'PinGenerationAttributes$Ibm3624PinOffset' => '<p>Parameters that are required to generate or verify Ibm3624 PIN offset PIN.</p>', ], ], 'Ibm3624PinVerification' => [ 'base' => '<p>Parameters that are required to generate or verify Ibm3624 PIN verification PIN.</p>', 'refs' => [ 'PinVerificationAttributes$Ibm3624Pin' => '<p>Parameters that are required to generate or verify Ibm3624 PIN.</p>', ], ], 'Ibm3624RandomPin' => [ 'base' => '<p>Parameters that are required to generate or verify Ibm3624 random PIN.</p>', 'refs' => [ 'PinGenerationAttributes$Ibm3624RandomPin' => '<p>Parameters that are required to generate or verify Ibm3624 random PIN.</p>', ], ], 'InitializationVectorType' => [ 'base' => NULL, 'refs' => [ 'DukptEncryptionAttributes$InitializationVector' => '<p>An input used to provide the intial state. If no value is provided, Amazon Web Services Payment Cryptography defaults it to zero.</p>', 'EmvEncryptionAttributes$InitializationVector' => '<p>An input used to provide the intial state. If no value is provided, Amazon Web Services Payment Cryptography defaults it to zero.</p>', 'SymmetricEncryptionAttributes$InitializationVector' => '<p>An input used to provide the intial state. If no value is provided, Amazon Web Services Payment Cryptography defaults it to zero.</p>', ], ], 'IntegerRangeBetween0And6' => [ 'base' => NULL, 'refs' => [ 'VisaPin$PinVerificationKeyIndex' => '<p>The value for PIN verification index. It is used in the Visa PIN algorithm to calculate the PVV (PIN Verification Value).</p>', 'VisaPinVerification$PinVerificationKeyIndex' => '<p>The value for PIN verification index. It is used in the Visa PIN algorithm to calculate the PVV (PIN Verification Value).</p>', 'VisaPinVerificationValue$PinVerificationKeyIndex' => '<p>The value for PIN verification index. It is used in the Visa PIN algorithm to calculate the PVV (PIN Verification Value).</p>', ], ], 'IntegerRangeBetween3And5Type' => [ 'base' => NULL, 'refs' => [ 'GenerateCardValidationDataInput$ValidationDataLength' => '<p>The length of the CVV or CSC to be generated. The default value is 3.</p>', ], ], 'IntegerRangeBetween4And12' => [ 'base' => NULL, 'refs' => [ 'GeneratePinDataInput$PinDataLength' => '<p>The length of PIN under generation.</p>', 'VerifyPinDataInput$PinDataLength' => '<p>The length of PIN being verified.</p>', ], ], 'IntegerRangeBetween4And16' => [ 'base' => NULL, 'refs' => [ 'GenerateMacInput$MacLength' => '<p>The length of a MAC under generation.</p>', 'VerifyMacInput$MacLength' => '<p>The length of the MAC.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>The request processing has failed because of an unknown error, exception, or failure.</p>', 'refs' => [], ], 'KeyArn' => [ 'base' => NULL, 'refs' => [ 'DecryptDataOutput$KeyArn' => '<p>The <code>keyARN</code> of the encryption key that Amazon Web Services Payment Cryptography uses for ciphertext decryption.</p>', 'EncryptDataOutput$KeyArn' => '<p>The <code>keyARN</code> of the encryption key that Amazon Web Services Payment Cryptography uses for plaintext encryption.</p>', 'GenerateCardValidationDataOutput$KeyArn' => '<p>The <code>keyARN</code> of the CVK encryption key that Amazon Web Services Payment Cryptography uses to generate CVV or CSC.</p>', 'GenerateMacOutput$KeyArn' => '<p>The <code>keyARN</code> of the encryption key that Amazon Web Services Payment Cryptography uses for MAC generation.</p>', 'GeneratePinDataOutput$GenerationKeyArn' => '<p>The <code>keyARN</code> of the pin data generation key that Amazon Web Services Payment Cryptography uses for PIN, PVV or PIN Offset generation.</p>', 'GeneratePinDataOutput$EncryptionKeyArn' => '<p>The <code>keyARN</code> of the PEK that Amazon Web Services Payment Cryptography uses for encrypted pin block generation.</p>', 'ReEncryptDataOutput$KeyArn' => '<p>The keyARN (Amazon Resource Name) of the encryption key that Amazon Web Services Payment Cryptography uses for plaintext encryption.</p>', 'TranslatePinDataOutput$KeyArn' => '<p>The <code>keyARN</code> of the encryption key that Amazon Web Services Payment Cryptography uses to encrypt outgoing PIN block data after translation.</p>', 'VerifyAuthRequestCryptogramOutput$KeyArn' => '<p>The <code>keyARN</code> of the major encryption key that Amazon Web Services Payment Cryptography uses for ARQC verification.</p>', 'VerifyCardValidationDataOutput$KeyArn' => '<p>The <code>keyARN</code> of the CVK encryption key that Amazon Web Services Payment Cryptography uses to verify CVV or CSC.</p>', 'VerifyMacOutput$KeyArn' => '<p>The <code>keyARN</code> of the encryption key that Amazon Web Services Payment Cryptography uses for MAC verification.</p>', 'VerifyPinDataOutput$VerificationKeyArn' => '<p>The <code>keyARN</code> of the PIN encryption key that Amazon Web Services Payment Cryptography uses for PIN or PIN Offset verification.</p>', 'VerifyPinDataOutput$EncryptionKeyArn' => '<p>The <code>keyARN</code> of the PEK that Amazon Web Services Payment Cryptography uses for encrypted pin block generation.</p>', ], ], 'KeyArnOrKeyAliasType' => [ 'base' => NULL, 'refs' => [ 'DecryptDataInput$KeyIdentifier' => '<p>The <code>keyARN</code> of the encryption key that Amazon Web Services Payment Cryptography uses for ciphertext decryption.</p> <p>When a WrappedKeyBlock is provided, this value will be the identifier to the key wrapping key. Otherwise, it is the key identifier used to perform the operation.</p>', 'EncryptDataInput$KeyIdentifier' => '<p>The <code>keyARN</code> of the encryption key that Amazon Web Services Payment Cryptography uses for plaintext encryption.</p> <p>When a WrappedKeyBlock is provided, this value will be the identifier to the key wrapping key. Otherwise, it is the key identifier used to perform the operation.</p>', 'GenerateCardValidationDataInput$KeyIdentifier' => '<p>The <code>keyARN</code> of the CVK encryption key that Amazon Web Services Payment Cryptography uses to generate card data.</p>', 'GenerateMacInput$KeyIdentifier' => '<p>The <code>keyARN</code> of the MAC generation encryption key.</p>', 'GeneratePinDataInput$GenerationKeyIdentifier' => '<p>The <code>keyARN</code> of the PEK that Amazon Web Services Payment Cryptography uses for pin data generation.</p>', 'GeneratePinDataInput$EncryptionKeyIdentifier' => '<p>The <code>keyARN</code> of the PEK that Amazon Web Services Payment Cryptography uses to encrypt the PIN Block.</p>', 'ReEncryptDataInput$IncomingKeyIdentifier' => '<p>The <code>keyARN</code> of the encryption key of incoming ciphertext data.</p> <p>When a WrappedKeyBlock is provided, this value will be the identifier to the key wrapping key. Otherwise, it is the key identifier used to perform the operation.</p>', 'ReEncryptDataInput$OutgoingKeyIdentifier' => '<p>The <code>keyARN</code> of the encryption key of outgoing ciphertext data after encryption by Amazon Web Services Payment Cryptography.</p>', 'TranslatePinDataInput$IncomingKeyIdentifier' => '<p>The <code>keyARN</code> of the encryption key under which incoming PIN block data is encrypted. This key type can be PEK or BDK.</p> <p>When a WrappedKeyBlock is provided, this value will be the identifier to the key wrapping key for PIN block. Otherwise, it is the key identifier used to perform the operation.</p>', 'TranslatePinDataInput$OutgoingKeyIdentifier' => '<p>The <code>keyARN</code> of the encryption key for encrypting outgoing PIN block data. This key type can be PEK or BDK.</p>', 'VerifyAuthRequestCryptogramInput$KeyIdentifier' => '<p>The <code>keyARN</code> of the major encryption key that Amazon Web Services Payment Cryptography uses for ARQC verification.</p>', 'VerifyCardValidationDataInput$KeyIdentifier' => '<p>The <code>keyARN</code> of the CVK encryption key that Amazon Web Services Payment Cryptography uses to verify card data.</p>', 'VerifyMacInput$KeyIdentifier' => '<p>The <code>keyARN</code> of the encryption key that Amazon Web Services Payment Cryptography uses to verify MAC data.</p>', 'VerifyPinDataInput$VerificationKeyIdentifier' => '<p>The <code>keyARN</code> of the PIN verification key.</p>', 'VerifyPinDataInput$EncryptionKeyIdentifier' => '<p>The <code>keyARN</code> of the encryption key under which the PIN block data is encrypted. This key type can be PEK or BDK.</p>', ], ], 'KeyCheckValue' => [ 'base' => NULL, 'refs' => [ 'DecryptDataOutput$KeyCheckValue' => '<p>The key check value (KCV) of the encryption key. The KCV is used to check if all parties holding a given key have the same key or to detect that a key has changed.</p> <p>Amazon Web Services Payment Cryptography computes the KCV according to the CMAC specification.</p>', 'EncryptDataOutput$KeyCheckValue' => '<p>The key check value (KCV) of the encryption key. The KCV is used to check if all parties holding a given key have the same key or to detect that a key has changed.</p> <p>Amazon Web Services Payment Cryptography computes the KCV according to the CMAC specification.</p>', 'GenerateCardValidationDataOutput$KeyCheckValue' => '<p>The key check value (KCV) of the encryption key. The KCV is used to check if all parties holding a given key have the same key or to detect that a key has changed.</p> <p>Amazon Web Services Payment Cryptography computes the KCV according to the CMAC specification.</p>', 'GenerateMacOutput$KeyCheckValue' => '<p>The key check value (KCV) of the encryption key. The KCV is used to check if all parties holding a given key have the same key or to detect that a key has changed.</p> <p>Amazon Web Services Payment Cryptography computes the KCV according to the CMAC specification.</p>', 'GeneratePinDataOutput$GenerationKeyCheckValue' => '<p>The key check value (KCV) of the encryption key. The KCV is used to check if all parties holding a given key have the same key or to detect that a key has changed.</p> <p>Amazon Web Services Payment Cryptography computes the KCV according to the CMAC specification.</p>', 'GeneratePinDataOutput$EncryptionKeyCheckValue' => '<p>The key check value (KCV) of the encryption key. The KCV is used to check if all parties holding a given key have the same key or to detect that a key has changed.</p> <p>Amazon Web Services Payment Cryptography computes the KCV according to the CMAC specification.</p>', 'ReEncryptDataOutput$KeyCheckValue' => '<p>The key check value (KCV) of the encryption key. The KCV is used to check if all parties holding a given key have the same key or to detect that a key has changed.</p> <p>Amazon Web Services Payment Cryptography computes the KCV according to the CMAC specification.</p>', 'TranslatePinDataOutput$KeyCheckValue' => '<p>The key check value (KCV) of the encryption key. The KCV is used to check if all parties holding a given key have the same key or to detect that a key has changed.</p> <p>Amazon Web Services Payment Cryptography computes the KCV according to the CMAC specification.</p>', 'VerifyAuthRequestCryptogramOutput$KeyCheckValue' => '<p>The key check value (KCV) of the encryption key. The KCV is used to check if all parties holding a given key have the same key or to detect that a key has changed.</p> <p>Amazon Web Services Payment Cryptography computes the KCV according to the CMAC specification.</p>', 'VerifyCardValidationDataOutput$KeyCheckValue' => '<p>The key check value (KCV) of the encryption key. The KCV is used to check if all parties holding a given key have the same key or to detect that a key has changed.</p> <p>Amazon Web Services Payment Cryptography computes the KCV according to the CMAC specification.</p>', 'VerifyMacOutput$KeyCheckValue' => '<p>The key check value (KCV) of the encryption key. The KCV is used to check if all parties holding a given key have the same key or to detect that a key has changed.</p> <p>Amazon Web Services Payment Cryptography computes the KCV according to the CMAC specification.</p>', 'VerifyPinDataOutput$VerificationKeyCheckValue' => '<p>The key check value (KCV) of the encryption key. The KCV is used to check if all parties holding a given key have the same key or to detect that a key has changed.</p> <p>Amazon Web Services Payment Cryptography computes the KCV according to the CMAC specification.</p>', 'VerifyPinDataOutput$EncryptionKeyCheckValue' => '<p>The key check value (KCV) of the encryption key. The KCV is used to check if all parties holding a given key have the same key or to detect that a key has changed.</p> <p>Amazon Web Services Payment Cryptography computes the KCV according to the CMAC specification.</p>', ], ], 'KeyCheckValueAlgorithm' => [ 'base' => NULL, 'refs' => [ 'WrappedKey$KeyCheckValueAlgorithm' => '<p>The algorithm that Amazon Web Services Payment Cryptography uses to calculate the key check value (KCV). It is used to validate the key integrity.</p> <p>For TDES keys, the KCV is computed by encrypting 8 bytes, each with value of zero, with the key to be checked and retaining the 3 highest order bytes of the encrypted result. For AES keys, the KCV is computed using a CMAC algorithm where the input data is 16 bytes of zero and retaining the 3 highest order bytes of the encrypted result.</p>', ], ], 'MacAlgorithm' => [ 'base' => NULL, 'refs' => [ 'MacAttributes$Algorithm' => '<p>The encryption algorithm for MAC generation or verification.</p>', ], ], 'MacAlgorithmDukpt' => [ 'base' => '<p>Parameters required for DUKPT MAC generation and verification.</p>', 'refs' => [ 'MacAttributes$DukptIso9797Algorithm1' => '<p>Parameters that are required for MAC generation or verification using DUKPT ISO 9797 algorithm1.</p>', 'MacAttributes$DukptIso9797Algorithm3' => '<p>Parameters that are required for MAC generation or verification using DUKPT ISO 9797 algorithm3.</p>', 'MacAttributes$DukptCmac' => '<p>Parameters that are required for MAC generation or verification using DUKPT CMAC algorithm.</p>', ], ], 'MacAlgorithmEmv' => [ 'base' => '<p>Parameters that are required for EMV MAC generation and verification.</p>', 'refs' => [ 'MacAttributes$EmvMac' => '<p>Parameters that are required for MAC generation or verification using EMV MAC algorithm.</p>', ], ], 'MacAttributes' => [ 'base' => '<p>Parameters that are required for DUKPT, HMAC, or EMV MAC generation or verification.</p>', 'refs' => [ 'GenerateMacInput$GenerationAttributes' => '<p>The attributes and data values to use for MAC generation within Amazon Web Services Payment Cryptography.</p>', 'VerifyMacInput$VerificationAttributes' => '<p>The attributes and data values to use for MAC verification within Amazon Web Services Payment Cryptography.</p>', ], ], 'MacOutputType' => [ 'base' => NULL, 'refs' => [ 'GenerateMacOutput$Mac' => '<p>The MAC cryptogram generated within Amazon Web Services Payment Cryptography.</p>', ], ], 'MacType' => [ 'base' => NULL, 'refs' => [ 'VerifyMacInput$Mac' => '<p>The MAC being verified.</p>', ], ], 'MajorKeyDerivationMode' => [ 'base' => NULL, 'refs' => [ 'MacAlgorithmEmv$MajorKeyDerivationMode' => '<p>The method to use when deriving the master key for EMV MAC generation or verification.</p>', 'VerifyAuthRequestCryptogramInput$MajorKeyDerivationMode' => '<p>The method to use when deriving the major encryption key for ARQC verification within Amazon Web Services Payment Cryptography. The same key derivation mode was used for ARQC generation outside of Amazon Web Services Payment Cryptography.</p>', ], ], 'MessageDataType' => [ 'base' => NULL, 'refs' => [ 'GenerateMacInput$MessageData' => '<p>The data for which a MAC is under generation. This value must be hexBinary.</p>', 'VerifyMacInput$MessageData' => '<p>The data on for which MAC is under verification. This value must be hexBinary.</p>', ], ], 'NumberLengthEquals2' => [ 'base' => NULL, 'refs' => [ 'CardHolderVerificationValue$PanSequenceNumber' => '<p>A number that identifies and differentiates payment cards with the same Primary Account Number (PAN).</p>', 'DynamicCardVerificationCode$PanSequenceNumber' => '<p>A number that identifies and differentiates payment cards with the same Primary Account Number (PAN).</p>', 'DynamicCardVerificationValue$PanSequenceNumber' => '<p>A number that identifies and differentiates payment cards with the same Primary Account Number (PAN).</p>', 'EmvEncryptionAttributes$PanSequenceNumber' => '<p>A number that identifies and differentiates payment cards with the same Primary Account Number (PAN).</p>', 'MacAlgorithmEmv$PanSequenceNumber' => '<p>A number that identifies and differentiates payment cards with the same Primary Account Number (PAN).</p>', 'SessionKeyAmex$PanSequenceNumber' => '<p>A number that identifies and differentiates payment cards with the same Primary Account Number (PAN).</p>', 'SessionKeyEmv2000$PanSequenceNumber' => '<p>A number that identifies and differentiates payment cards with the same Primary Account Number (PAN).</p>', 'SessionKeyEmvCommon$PanSequenceNumber' => '<p>A number that identifies and differentiates payment cards with the same Primary Account Number (PAN).</p>', 'SessionKeyMastercard$PanSequenceNumber' => '<p>A number that identifies and differentiates payment cards with the same Primary Account Number (PAN).</p>', 'SessionKeyVisa$PanSequenceNumber' => '<p>A number that identifies and differentiates payment cards with the same Primary Account Number (PAN).</p>', ], ], 'PaddingType' => [ 'base' => NULL, 'refs' => [ 'AsymmetricEncryptionAttributes$PaddingType' => '<p>The padding to be included with the data.</p>', 'SymmetricEncryptionAttributes$PaddingType' => '<p>The padding to be included with the data.</p>', ], ], 'PinBlockFormatForPinData' => [ 'base' => NULL, 'refs' => [ 'GeneratePinDataInput$PinBlockFormat' => '<p>The PIN encoding format for pin data generation as specified in ISO 9564. Amazon Web Services Payment Cryptography supports <code>ISO_Format_0</code> and <code>ISO_Format_3</code>.</p> <p>The <code>ISO_Format_0</code> PIN block format is equivalent to the ANSI X9.8, VISA-1, and ECI-1 PIN block formats. It is similar to a VISA-4 PIN block format. It supports a PIN from 4 to 12 digits in length.</p> <p>The <code>ISO_Format_3</code> PIN block format is the same as <code>ISO_Format_0</code> except that the fill digits are random values from 10 to 15.</p>', 'VerifyPinDataInput$PinBlockFormat' => '<p>The PIN encoding format for pin data generation as specified in ISO 9564. Amazon Web Services Payment Cryptography supports <code>ISO_Format_0</code> and <code>ISO_Format_3</code>.</p> <p>The <code>ISO_Format_0</code> PIN block format is equivalent to the ANSI X9.8, VISA-1, and ECI-1 PIN block formats. It is similar to a VISA-4 PIN block format. It supports a PIN from 4 to 12 digits in length.</p> <p>The <code>ISO_Format_3</code> PIN block format is the same as <code>ISO_Format_0</code> except that the fill digits are random values from 10 to 15.</p>', ], ], 'PinData' => [ 'base' => '<p>Parameters that are required to generate, translate, or verify PIN data.</p>', 'refs' => [ 'GeneratePinDataOutput$PinData' => '<p>The attributes and values Amazon Web Services Payment Cryptography uses for pin data generation.</p>', ], ], 'PinGenerationAttributes' => [ 'base' => '<p>Parameters that are required for PIN data generation.</p>', 'refs' => [ 'GeneratePinDataInput$GenerationAttributes' => '<p>The attributes and values to use for PIN, PVV, or PIN Offset generation.</p>', ], ], 'PinOffsetType' => [ 'base' => NULL, 'refs' => [ 'Ibm3624PinFromOffset$PinOffset' => '<p>The PIN offset value.</p>', 'Ibm3624PinVerification$PinOffset' => '<p>The PIN offset value.</p>', 'PinData$PinOffset' => '<p>The PIN offset value.</p>', ], ], 'PinValidationDataType' => [ 'base' => NULL, 'refs' => [ 'Ibm3624NaturalPin$PinValidationData' => '<p>The unique data for cardholder identification.</p>', 'Ibm3624PinFromOffset$PinValidationData' => '<p>The unique data for cardholder identification.</p>', 'Ibm3624PinOffset$PinValidationData' => '<p>The unique data for cardholder identification.</p>', 'Ibm3624PinVerification$PinValidationData' => '<p>The unique data for cardholder identification.</p>', 'Ibm3624RandomPin$PinValidationData' => '<p>The unique data for cardholder identification.</p>', ], ], 'PinVerificationAttributes' => [ 'base' => '<p>Parameters that are required for PIN data verification.</p>', 'refs' => [ 'VerifyPinDataInput$VerificationAttributes' => '<p>The attributes and values for PIN data verification.</p>', ], ], 'PlainTextOutputType' => [ 'base' => NULL, 'refs' => [ 'DecryptDataOutput$PlainText' => '<p>The decrypted plaintext data in hexBinary format.</p>', ], ], 'PlainTextType' => [ 'base' => NULL, 'refs' => [ 'EncryptDataInput$PlainText' => '<p>The plaintext to be encrypted.</p> <note> <p>For encryption using asymmetric keys, plaintext data length is constrained by encryption key strength that you define in <code>KeyAlgorithm</code> and padding type that you define in <code>AsymmetricEncryptionAttributes</code>. For more information, see <a href="https://docs.aws.amazon.com/payment-cryptography/latest/userguide/encrypt-data.html">Encrypt data</a> in the <i>Amazon Web Services Payment Cryptography User Guide</i>.</p> </note>', ], ], 'PrimaryAccountNumberType' => [ 'base' => NULL, 'refs' => [ 'EmvEncryptionAttributes$PrimaryAccountNumber' => '<p>The Primary Account Number (PAN), a unique identifier for a payment credit or debit card and associates the card to a specific account holder.</p>', 'GenerateCardValidationDataInput$PrimaryAccountNumber' => '<p>The Primary Account Number (PAN), a unique identifier for a payment credit or debit card that associates the card with a specific account holder.</p>', 'GeneratePinDataInput$PrimaryAccountNumber' => '<p>The Primary Account Number (PAN), a unique identifier for a payment credit or debit card that associates the card with a specific account holder.</p>', 'MacAlgorithmEmv$PrimaryAccountNumber' => '<p>The Primary Account Number (PAN), a unique identifier for a payment credit or debit card and associates the card to a specific account holder.</p>', 'SessionKeyAmex$PrimaryAccountNumber' => '<p>The Primary Account Number (PAN) of the cardholder. A PAN is a unique identifier for a payment credit or debit card and associates the card to a specific account holder.</p>', 'SessionKeyEmv2000$PrimaryAccountNumber' => '<p>The Primary Account Number (PAN) of the cardholder. A PAN is a unique identifier for a payment credit or debit card and associates the card to a specific account holder.</p>', 'SessionKeyEmvCommon$PrimaryAccountNumber' => '<p>The Primary Account Number (PAN) of the cardholder. A PAN is a unique identifier for a payment credit or debit card and associates the card to a specific account holder.</p>', 'SessionKeyMastercard$PrimaryAccountNumber' => '<p>The Primary Account Number (PAN) of the cardholder. A PAN is a unique identifier for a payment credit or debit card and associates the card to a specific account holder.</p>', 'SessionKeyVisa$PrimaryAccountNumber' => '<p>The Primary Account Number (PAN) of the cardholder. A PAN is a unique identifier for a payment credit or debit card and associates the card to a specific account holder.</p>', 'TranslationPinDataIsoFormat034$PrimaryAccountNumber' => '<p>The Primary Account Number (PAN) of the cardholder. A PAN is a unique identifier for a payment credit or debit card and associates the card to a specific account holder.</p>', 'VerifyCardValidationDataInput$PrimaryAccountNumber' => '<p>The Primary Account Number (PAN), a unique identifier for a payment credit or debit card that associates the card with a specific account holder.</p>', 'VerifyPinDataInput$PrimaryAccountNumber' => '<p>The Primary Account Number (PAN), a unique identifier for a payment credit or debit card that associates the card with a specific account holder.</p>', ], ], 'ProprietaryAuthenticationDataType' => [ 'base' => NULL, 'refs' => [ 'CryptogramVerificationArpcMethod2$ProprietaryAuthenticationData' => '<p>The proprietary authentication data used by issuer for communication during online transaction using an EMV chip card.</p>', ], ], 'ReEncryptDataInput' => [ 'base' => NULL, 'refs' => [], ], 'ReEncryptDataOutput' => [ 'base' => NULL, 'refs' => [], ], 'ReEncryptionAttributes' => [ 'base' => '<p>Parameters that are required to perform reencryption operation.</p>', 'refs' => [ 'ReEncryptDataInput$IncomingEncryptionAttributes' => '<p>The attributes and values for incoming ciphertext.</p>', 'ReEncryptDataInput$OutgoingEncryptionAttributes' => '<p>The attributes and values for outgoing ciphertext data after encryption by Amazon Web Services Payment Cryptography.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The request was denied due to an invalid resource error.</p>', 'refs' => [], ], 'ServiceCodeType' => [ 'base' => NULL, 'refs' => [ 'AmexCardSecurityCodeVersion2$ServiceCode' => '<p>The service code of the AMEX payment card. This is different from the Card Security Code (CSC).</p>', 'CardVerificationValue1$ServiceCode' => '<p>The service code of the payment card. This is different from Card Security Code (CSC).</p>', 'DynamicCardVerificationValue$ServiceCode' => '<p>The service code of the payment card. This is different from Card Security Code (CSC).</p>', ], ], 'SessionDerivationDataType' => [ 'base' => NULL, 'refs' => [ 'EmvEncryptionAttributes$SessionDerivationData' => '<p>The derivation value used to derive the ICC session key. It is typically the application transaction counter value padded with zeros or previous ARQC value padded with zeros as per EMV version 4.3 book 2.</p>', ], ], 'SessionKeyAmex' => [ 'base' => '<p>Parameters to derive session key for an Amex payment card.</p>', 'refs' => [ 'SessionKeyDerivation$Amex' => '<p>Parameters to derive session key for an Amex payment card for ARQC verification.</p>', ], ], 'SessionKeyDerivation' => [ 'base' => '<p>Parameters to derive a session key for Authorization Response Cryptogram (ARQC) verification.</p>', 'refs' => [ 'VerifyAuthRequestCryptogramInput$SessionKeyDerivationAttributes' => '<p>The attributes and values to use for deriving a session key for ARQC verification within Amazon Web Services Payment Cryptography. The same attributes were used for ARQC generation outside of Amazon Web Services Payment Cryptography.</p>', ], ], 'SessionKeyDerivationMode' => [ 'base' => NULL, 'refs' => [ 'MacAlgorithmEmv$SessionKeyDerivationMode' => '<p>The method of deriving a session key for EMV MAC generation or verification.</p>', ], ], 'SessionKeyDerivationValue' => [ 'base' => '<p>Parameters to derive session key value using a MAC EMV algorithm.</p>', 'refs' => [ 'MacAlgorithmEmv$SessionKeyDerivationValue' => '<p>Parameters that are required to generate session key for EMV generation and verification.</p>', ], ], 'SessionKeyEmv2000' => [ 'base' => '<p>Parameters to derive session key for an Emv2000 payment card for ARQC verification.</p>', 'refs' => [ 'SessionKeyDerivation$Emv2000' => '<p>Parameters to derive session key for an Emv2000 payment card for ARQC verification.</p>', ], ], 'SessionKeyEmvCommon' => [ 'base' => '<p>Parameters to derive session key for an Emv common payment card for ARQC verification.</p>', 'refs' => [ 'SessionKeyDerivation$EmvCommon' => '<p>Parameters to derive session key for an Emv common payment card for ARQC verification.</p>', ], ], 'SessionKeyMastercard' => [ 'base' => '<p>Parameters to derive session key for Mastercard payment card for ARQC verification.</p>', 'refs' => [ 'SessionKeyDerivation$Mastercard' => '<p>Parameters to derive session key for a Mastercard payment card for ARQC verification.</p>', ], ], 'SessionKeyVisa' => [ 'base' => '<p>Parameters to derive session key for Visa payment card for ARQC verification.</p>', 'refs' => [ 'SessionKeyDerivation$Visa' => '<p>Parameters to derive session key for a Visa payment cardfor ARQC verification.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => NULL, 'InternalServerException$Message' => NULL, 'ResourceNotFoundException$ResourceId' => '<p>The resource that is missing.</p>', 'ThrottlingException$Message' => NULL, 'ValidationException$message' => NULL, 'ValidationExceptionField$path' => '<p>The request was denied due to an invalid request error.</p>', 'ValidationExceptionField$message' => '<p>The request was denied due to an invalid request error.</p>', 'VerificationFailedException$Message' => NULL, ], ], 'SymmetricEncryptionAttributes' => [ 'base' => '<p>Parameters requried to encrypt plaintext data using symmetric keys.</p>', 'refs' => [ 'EncryptionDecryptionAttributes$Symmetric' => '<p>Parameters that are required to perform encryption and decryption using symmetric keys.</p>', 'ReEncryptionAttributes$Symmetric' => '<p>Parameters that are required to encrypt data using symmetric keys.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The request was denied due to request throttling.</p>', 'refs' => [], ], 'Tr31WrappedKeyBlock' => [ 'base' => NULL, 'refs' => [ 'WrappedKeyMaterial$Tr31KeyBlock' => '<p>The TR-31 wrapped key block.</p>', ], ], 'TrackDataType' => [ 'base' => NULL, 'refs' => [ 'DynamicCardVerificationCode$TrackData' => '<p>The data on the two tracks of magnetic cards used for financial transactions. This includes the cardholder name, PAN, expiration date, bank ID (BIN) and several other numbers the issuing bank uses to validate the data received.</p>', ], ], 'TransactionDataType' => [ 'base' => NULL, 'refs' => [ 'VerifyAuthRequestCryptogramInput$TransactionData' => '<p>The transaction data that Amazon Web Services Payment Cryptography uses for ARQC verification. The same transaction is used for ARQC generation outside of Amazon Web Services Payment Cryptography.</p>', ], ], 'TranslatePinDataInput' => [ 'base' => NULL, 'refs' => [], ], 'TranslatePinDataOutput' => [ 'base' => NULL, 'refs' => [], ], 'TranslationIsoFormats' => [ 'base' => '<p>Parameters that are required for translation between ISO9564 PIN block formats 0,1,3,4.</p>', 'refs' => [ 'TranslatePinDataInput$IncomingTranslationAttributes' => '<p>The format of the incoming PIN block data for translation within Amazon Web Services Payment Cryptography.</p>', 'TranslatePinDataInput$OutgoingTranslationAttributes' => '<p>The format of the outgoing PIN block data after translation by Amazon Web Services Payment Cryptography.</p>', ], ], 'TranslationPinDataIsoFormat034' => [ 'base' => '<p>Parameters that are required for tranlation between ISO9564 PIN format 0,3,4 tranlation.</p>', 'refs' => [ 'TranslationIsoFormats$IsoFormat0' => '<p>Parameters that are required for ISO9564 PIN format 0 tranlation.</p>', 'TranslationIsoFormats$IsoFormat3' => '<p>Parameters that are required for ISO9564 PIN format 3 tranlation.</p>', 'TranslationIsoFormats$IsoFormat4' => '<p>Parameters that are required for ISO9564 PIN format 4 tranlation.</p>', ], ], 'TranslationPinDataIsoFormat1' => [ 'base' => '<p>Parameters that are required for ISO9564 PIN format 1 tranlation.</p>', 'refs' => [ 'TranslationIsoFormats$IsoFormat1' => '<p>Parameters that are required for ISO9564 PIN format 1 tranlation.</p>', ], ], 'ValidationDataType' => [ 'base' => NULL, 'refs' => [ 'GenerateCardValidationDataOutput$ValidationData' => '<p>The CVV or CSC value that Amazon Web Services Payment Cryptography generates for the card.</p>', 'VerifyCardValidationDataInput$ValidationData' => '<p>The CVV or CSC value for use for card data verification within Amazon Web Services Payment Cryptography.</p>', ], ], 'ValidationException' => [ 'base' => '<p>The request was denied due to an invalid request error.</p>', 'refs' => [], ], 'ValidationExceptionField' => [ 'base' => '<p>The request was denied due to an invalid request error.</p>', 'refs' => [ 'ValidationExceptionFieldList$member' => NULL, ], ], 'ValidationExceptionFieldList' => [ 'base' => NULL, 'refs' => [ 'ValidationException$fieldList' => '<p>The request was denied due to an invalid request error.</p>', ], ], 'VerificationFailedException' => [ 'base' => '<p>This request failed verification.</p>', 'refs' => [], ], 'VerificationFailedReason' => [ 'base' => NULL, 'refs' => [ 'VerificationFailedException$Reason' => '<p>The reason for the exception.</p>', ], ], 'VerificationValueType' => [ 'base' => NULL, 'refs' => [ 'PinData$VerificationValue' => '<p>The unique data to identify a cardholder. In most cases, this is the same as cardholder\'s Primary Account Number (PAN). If a value is not provided, it defaults to PAN.</p>', 'VisaPinVerification$VerificationValue' => '<p>Parameters that are required to generate or verify Visa PVV (PIN Verification Value).</p>', ], ], 'VerifyAuthRequestCryptogramInput' => [ 'base' => NULL, 'refs' => [], ], 'VerifyAuthRequestCryptogramOutput' => [ 'base' => NULL, 'refs' => [], ], 'VerifyCardValidationDataInput' => [ 'base' => NULL, 'refs' => [], ], 'VerifyCardValidationDataOutput' => [ 'base' => NULL, 'refs' => [], ], 'VerifyMacInput' => [ 'base' => NULL, 'refs' => [], ], 'VerifyMacOutput' => [ 'base' => NULL, 'refs' => [], ], 'VerifyPinDataInput' => [ 'base' => NULL, 'refs' => [], ], 'VerifyPinDataOutput' => [ 'base' => NULL, 'refs' => [], ], 'VisaPin' => [ 'base' => '<p>Parameters that are required to generate or verify Visa PIN.</p>', 'refs' => [ 'PinGenerationAttributes$VisaPin' => '<p>Parameters that are required to generate or verify Visa PIN.</p>', ], ], 'VisaPinVerification' => [ 'base' => '<p>Parameters that are required to generate or verify Visa PIN.</p>', 'refs' => [ 'PinVerificationAttributes$VisaPin' => '<p>Parameters that are required to generate or verify Visa PIN.</p>', ], ], 'VisaPinVerificationValue' => [ 'base' => '<p>Parameters that are required to generate or verify Visa PVV (PIN Verification Value).</p>', 'refs' => [ 'PinGenerationAttributes$VisaPinVerificationValue' => '<p>Parameters that are required to generate or verify Visa PIN Verification Value (PVV).</p>', ], ], 'WrappedKey' => [ 'base' => '<p>Parameter information of a WrappedKeyBlock for encryption key exchange.</p>', 'refs' => [ 'DecryptDataInput$WrappedKey' => '<p>The WrappedKeyBlock containing the encryption key for ciphertext decryption.</p>', 'EncryptDataInput$WrappedKey' => '<p>The WrappedKeyBlock containing the encryption key for plaintext encryption.</p>', 'ReEncryptDataInput$IncomingWrappedKey' => '<p>The WrappedKeyBlock containing the encryption key of incoming ciphertext data.</p>', 'ReEncryptDataInput$OutgoingWrappedKey' => '<p>The WrappedKeyBlock containing the encryption key of outgoing ciphertext data after encryption by Amazon Web Services Payment Cryptography.</p>', 'TranslatePinDataInput$IncomingWrappedKey' => '<p>The WrappedKeyBlock containing the encryption key under which incoming PIN block data is encrypted.</p>', 'TranslatePinDataInput$OutgoingWrappedKey' => '<p>The WrappedKeyBlock containing the encryption key for encrypting outgoing PIN block data.</p>', ], ], 'WrappedKeyMaterial' => [ 'base' => '<p>Parameter information of a WrappedKeyBlock for encryption key exchange.</p>', 'refs' => [ 'WrappedKey$WrappedKeyMaterial' => '<p>Parameter information of a WrappedKeyBlock for encryption key exchange.</p>', ], ], ],];
