<?php
// This file was auto-generated from sdk-root/src/data/personalize-runtime/2018-05-22/docs-2.json
return [ 'version' => '2.0', 'service' => '<p/>', 'operations' => [ 'GetActionRecommendations' => '<p>Returns a list of recommended actions in sorted in descending order by prediction score. Use the <code>GetActionRecommendations</code> API if you have a custom campaign that deploys a solution version trained with a PERSONALIZED_ACTIONS recipe. </p> <p>For more information about PERSONALIZED_ACTIONS recipes, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/nexts-best-action-recipes.html">PERSONALIZED_ACTIONS recipes</a>. For more information about getting action recommendations, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/get-action-recommendations.html">Getting action recommendations</a>.</p>', 'GetPersonalizedRanking' => '<p>Re-ranks a list of recommended items for the given user. The first item in the list is deemed the most likely item to be of interest to the user.</p> <note> <p>The solution backing the campaign must have been created using a recipe of type PERSONALIZED_RANKING.</p> </note>', 'GetRecommendations' => '<p>Returns a list of recommended items. For campaigns, the campaign\'s Amazon Resource Name (ARN) is required and the required user and item input depends on the recipe type used to create the solution backing the campaign as follows:</p> <ul> <li> <p>USER_PERSONALIZATION - <code>userId</code> required, <code>itemId</code> not used</p> </li> <li> <p>RELATED_ITEMS - <code>itemId</code> required, <code>userId</code> not used</p> </li> </ul> <note> <p>Campaigns that are backed by a solution created using a recipe of type PERSONALIZED_RANKING use the API.</p> </note> <p> For recommenders, the recommender\'s ARN is required and the required item and user input depends on the use case (domain-based recipe) backing the recommender. For information on use case requirements see <a href="https://docs.aws.amazon.com/personalize/latest/dg/domain-use-cases.html">Choosing recommender use cases</a>. </p>', ], 'shapes' => [ 'ActionID' => [ 'base' => NULL, 'refs' => [ 'PredictedAction$actionId' => '<p>The ID of the recommended action.</p>', ], ], 'ActionList' => [ 'base' => NULL, 'refs' => [ 'GetActionRecommendationsResponse$actionList' => '<p>A list of action recommendations sorted in descending order by prediction score. There can be a maximum of 100 actions in the list. For information about action scores, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/how-action-recommendation-scoring-works.html">How action recommendation scoring works</a>.</p>', ], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'GetActionRecommendationsRequest$campaignArn' => '<p>The Amazon Resource Name (ARN) of the campaign to use for getting action recommendations. This campaign must deploy a solution version trained with a PERSONALIZED_ACTIONS recipe.</p>', 'GetActionRecommendationsRequest$filterArn' => '<p>The ARN of the filter to apply to the returned recommendations. For more information, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/filter.html">Filtering Recommendations</a>.</p> <p>When using this parameter, be sure the filter resource is <code>ACTIVE</code>.</p>', 'GetPersonalizedRankingRequest$campaignArn' => '<p>The Amazon Resource Name (ARN) of the campaign to use for generating the personalized ranking.</p>', 'GetPersonalizedRankingRequest$filterArn' => '<p>The Amazon Resource Name (ARN) of a filter you created to include items or exclude items from recommendations for a given user. For more information, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/filter.html">Filtering Recommendations</a>.</p>', 'GetRecommendationsRequest$campaignArn' => '<p>The Amazon Resource Name (ARN) of the campaign to use for getting recommendations.</p>', 'GetRecommendationsRequest$filterArn' => '<p>The ARN of the filter to apply to the returned recommendations. For more information, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/filter.html">Filtering Recommendations</a>.</p> <p>When using this parameter, be sure the filter resource is <code>ACTIVE</code>.</p>', 'GetRecommendationsRequest$recommenderArn' => '<p>The Amazon Resource Name (ARN) of the recommender to use to get recommendations. Provide a recommender ARN if you created a Domain dataset group with a recommender for a domain use case.</p>', 'Promotion$filterArn' => '<p>The Amazon Resource Name (ARN) of the filter used by the promotion. This filter defines the criteria for promoted items. For more information, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/promoting-items.html#promotion-filters">Promotion filters</a>.</p>', ], ], 'AttributeName' => [ 'base' => NULL, 'refs' => [ 'Context$key' => NULL, ], ], 'AttributeValue' => [ 'base' => NULL, 'refs' => [ 'Context$value' => NULL, ], ], 'ColumnName' => [ 'base' => NULL, 'refs' => [ 'ColumnNamesList$member' => NULL, 'Metadata$key' => NULL, ], ], 'ColumnNamesList' => [ 'base' => NULL, 'refs' => [ 'MetadataColumns$value' => NULL, ], ], 'ColumnValue' => [ 'base' => NULL, 'refs' => [ 'Metadata$value' => NULL, ], ], 'Context' => [ 'base' => NULL, 'refs' => [ 'GetPersonalizedRankingRequest$context' => '<p>The contextual metadata to use when getting recommendations. Contextual metadata includes any interaction information that might be relevant when getting a user\'s recommendations, such as the user\'s current location or device type.</p>', 'GetRecommendationsRequest$context' => '<p>The contextual metadata to use when getting recommendations. Contextual metadata includes any interaction information that might be relevant when getting a user\'s recommendations, such as the user\'s current location or device type.</p>', ], ], 'DatasetType' => [ 'base' => NULL, 'refs' => [ 'MetadataColumns$key' => NULL, ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'InvalidInputException$message' => NULL, 'ResourceNotFoundException$message' => NULL, ], ], 'FilterAttributeName' => [ 'base' => NULL, 'refs' => [ 'FilterValues$key' => NULL, ], ], 'FilterAttributeValue' => [ 'base' => NULL, 'refs' => [ 'FilterValues$value' => NULL, ], ], 'FilterValues' => [ 'base' => NULL, 'refs' => [ 'GetActionRecommendationsRequest$filterValues' => '<p>The values to use when filtering recommendations. For each placeholder parameter in your filter expression, provide the parameter name (in matching case) as a key and the filter value(s) as the corresponding value. Separate multiple values for one parameter with a comma. </p> <p>For filter expressions that use an <code>INCLUDE</code> element to include actions, you must provide values for all parameters that are defined in the expression. For filters with expressions that use an <code>EXCLUDE</code> element to exclude actions, you can omit the <code>filter-values</code>. In this case, Amazon Personalize doesn\'t use that portion of the expression to filter recommendations.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/filter.html">Filtering recommendations and user segments</a>.</p>', 'GetPersonalizedRankingRequest$filterValues' => '<p>The values to use when filtering recommendations. For each placeholder parameter in your filter expression, provide the parameter name (in matching case) as a key and the filter value(s) as the corresponding value. Separate multiple values for one parameter with a comma. </p> <p>For filter expressions that use an <code>INCLUDE</code> element to include items, you must provide values for all parameters that are defined in the expression. For filters with expressions that use an <code>EXCLUDE</code> element to exclude items, you can omit the <code>filter-values</code>.In this case, Amazon Personalize doesn\'t use that portion of the expression to filter recommendations.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/filter.html">Filtering Recommendations</a>.</p>', 'GetRecommendationsRequest$filterValues' => '<p>The values to use when filtering recommendations. For each placeholder parameter in your filter expression, provide the parameter name (in matching case) as a key and the filter value(s) as the corresponding value. Separate multiple values for one parameter with a comma. </p> <p>For filter expressions that use an <code>INCLUDE</code> element to include items, you must provide values for all parameters that are defined in the expression. For filters with expressions that use an <code>EXCLUDE</code> element to exclude items, you can omit the <code>filter-values</code>.In this case, Amazon Personalize doesn\'t use that portion of the expression to filter recommendations.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/filter.html">Filtering recommendations and user segments</a>.</p>', 'Promotion$filterValues' => '<p>The values to use when promoting items. For each placeholder parameter in your promotion\'s filter expression, provide the parameter name (in matching case) as a key and the filter value(s) as the corresponding value. Separate multiple values for one parameter with a comma. </p> <p>For filter expressions that use an <code>INCLUDE</code> element to include items, you must provide values for all parameters that are defined in the expression. For filters with expressions that use an <code>EXCLUDE</code> element to exclude items, you can omit the <code>filter-values</code>. In this case, Amazon Personalize doesn\'t use that portion of the expression to filter recommendations.</p> <p>For more information on creating filters, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/filter.html">Filtering recommendations and user segments</a>.</p>', ], ], 'GetActionRecommendationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetActionRecommendationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetPersonalizedRankingRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetPersonalizedRankingResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetRecommendationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetRecommendationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'InputList' => [ 'base' => NULL, 'refs' => [ 'GetPersonalizedRankingRequest$inputList' => '<p>A list of items (by <code>itemId</code>) to rank. If an item was not included in the training dataset, the item is appended to the end of the reranked list. If you are including metadata in recommendations, the maximum is 50. Otherwise, the maximum is 500.</p>', ], ], 'InvalidInputException' => [ 'base' => '<p>Provide a valid value for the field or parameter.</p>', 'refs' => [], ], 'ItemID' => [ 'base' => NULL, 'refs' => [ 'GetRecommendationsRequest$itemId' => '<p>The item ID to provide recommendations for.</p> <p>Required for <code>RELATED_ITEMS</code> recipe type.</p>', 'InputList$member' => NULL, 'PredictedItem$itemId' => '<p>The recommended item ID.</p>', ], ], 'ItemList' => [ 'base' => NULL, 'refs' => [ 'GetPersonalizedRankingResponse$personalizedRanking' => '<p>A list of items in order of most likely interest to the user. The maximum is 500.</p>', 'GetRecommendationsResponse$itemList' => '<p>A list of recommendations sorted in descending order by prediction score. There can be a maximum of 500 items in the list.</p>', ], ], 'Metadata' => [ 'base' => NULL, 'refs' => [ 'PredictedItem$metadata' => '<p>Metadata about the item from your Items dataset.</p>', ], ], 'MetadataColumns' => [ 'base' => NULL, 'refs' => [ 'GetPersonalizedRankingRequest$metadataColumns' => '<p>If you enabled metadata in recommendations when you created or updated the campaign, specify metadata columns from your Items dataset to include in the personalized ranking. The map key is <code>ITEMS</code> and the value is a list of column names from your Items dataset. The maximum number of columns you can provide is 10.</p> <p> For information about enabling metadata for a campaign, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/campaigns.html#create-campaign-return-metadata">Enabling metadata in recommendations for a campaign</a>. </p>', 'GetRecommendationsRequest$metadataColumns' => '<p>If you enabled metadata in recommendations when you created or updated the campaign or recommender, specify the metadata columns from your Items dataset to include in item recommendations. The map key is <code>ITEMS</code> and the value is a list of column names from your Items dataset. The maximum number of columns you can provide is 10.</p> <p> For information about enabling metadata for a campaign, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/campaigns.html#create-campaign-return-metadata">Enabling metadata in recommendations for a campaign</a>. For information about enabling metadata for a recommender, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/creating-recommenders.html#create-recommender-return-metadata">Enabling metadata in recommendations for a recommender</a>. </p>', ], ], 'Name' => [ 'base' => NULL, 'refs' => [ 'PredictedItem$promotionName' => '<p>The name of the promotion that included the predicted item.</p>', 'Promotion$name' => '<p>The name of the promotion.</p>', ], ], 'NumResults' => [ 'base' => NULL, 'refs' => [ 'GetActionRecommendationsRequest$numResults' => '<p>The number of results to return. The default is 5. The maximum is 100.</p>', 'GetRecommendationsRequest$numResults' => '<p>The number of results to return. The default is 25. If you are including metadata in recommendations, the maximum is 50. Otherwise, the maximum is 500.</p>', ], ], 'PercentPromotedItems' => [ 'base' => NULL, 'refs' => [ 'Promotion$percentPromotedItems' => '<p>The percentage of recommended items to apply the promotion to.</p>', ], ], 'PredictedAction' => [ 'base' => '<p>An object that identifies an action.</p> <p>The API returns a list of <code>PredictedAction</code>s.</p>', 'refs' => [ 'ActionList$member' => NULL, ], ], 'PredictedItem' => [ 'base' => '<p>An object that identifies an item.</p> <p>The and APIs return a list of <code>PredictedItem</code>s.</p>', 'refs' => [ 'ItemList$member' => NULL, ], ], 'Promotion' => [ 'base' => '<p>Contains information on a promotion. A promotion defines additional business rules that apply to a configurable subset of recommended items.</p>', 'refs' => [ 'PromotionList$member' => NULL, ], ], 'PromotionList' => [ 'base' => NULL, 'refs' => [ 'GetRecommendationsRequest$promotions' => '<p>The promotions to apply to the recommendation request. A promotion defines additional business rules that apply to a configurable subset of recommended items.</p>', ], ], 'Reason' => [ 'base' => NULL, 'refs' => [ 'ReasonList$member' => NULL, ], ], 'ReasonList' => [ 'base' => NULL, 'refs' => [ 'PredictedItem$reason' => '<p>If you use User-Personalization-v2, a list of reasons for why the item was included in recommendations. Possible reasons include the following:</p> <ul> <li> <p>Promoted item - Indicates the item was included as part of a promotion that you applied in your recommendation request.</p> </li> <li> <p>Exploration - Indicates the item was included with exploration. With exploration, recommendations include items with less interactions data or relevance for the user. For more information about exploration, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/use-case-recipe-features.html#about-exploration">Exploration</a>.</p> </li> <li> <p> Popular item - Indicates the item was included as a placeholder popular item. If you use a filter, depending on how many recommendations the filter removes, Amazon Personalize might add placeholder items to meet the <code>numResults</code> for your recommendation request. These items are popular items, based on interactions data, that satisfy your filter criteria. They don\'t have a relevance score for the user. </p> </li> </ul>', ], ], 'RecommendationID' => [ 'base' => NULL, 'refs' => [ 'GetActionRecommendationsResponse$recommendationId' => '<p>The ID of the recommendation.</p>', 'GetPersonalizedRankingResponse$recommendationId' => '<p>The ID of the recommendation.</p>', 'GetRecommendationsResponse$recommendationId' => '<p>The ID of the recommendation.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The specified resource does not exist.</p>', 'refs' => [], ], 'Score' => [ 'base' => NULL, 'refs' => [ 'PredictedAction$score' => '<p>The score of the recommended action. For information about action scores, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/how-action-recommendation-scoring-works.html">How action recommendation scoring works</a>.</p>', 'PredictedItem$score' => '<p>A numeric representation of the model\'s certainty that the item will be the next user selection. For more information on scoring logic, see <a>how-scores-work</a>.</p>', ], ], 'UserID' => [ 'base' => NULL, 'refs' => [ 'GetActionRecommendationsRequest$userId' => '<p>The user ID of the user to provide action recommendations for.</p>', 'GetPersonalizedRankingRequest$userId' => '<p>The user for which you want the campaign to provide a personalized ranking.</p>', 'GetRecommendationsRequest$userId' => '<p>The user ID to provide recommendations for.</p> <p>Required for <code>USER_PERSONALIZATION</code> recipe type.</p>', ], ], ],];
