<?php
// This file was auto-generated from sdk-root/src/data/rds/2014-10-31/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Amazon Relational Database Service</fullname> <p/> <p>Amazon Relational Database Service (Amazon RDS) is a web service that makes it easier to set up, operate, and scale a relational database in the cloud. It provides cost-efficient, resizeable capacity for an industry-standard relational database and manages common database administration tasks, freeing up developers to focus on what makes their applications and businesses unique.</p> <p>Amazon RDS gives you access to the capabilities of a MySQL, MariaDB, PostgreSQL, Microsoft SQL Server, Oracle, Db2, or Amazon Aurora database server. These capabilities mean that the code, applications, and tools you already use today with your existing databases work with Amazon RDS without modification. Amazon RDS automatically backs up your database and maintains the database software that powers your DB instance. Amazon RDS is flexible: you can scale your DB instance\'s compute resources and storage capacity to meet your application\'s demand. As with all Amazon Web Services, there are no up-front investments, and you pay only for the resources you use.</p> <p>This interface reference for Amazon RDS contains documentation for a programming or command line interface you can use to manage Amazon RDS. Amazon RDS is asynchronous, which means that some interfaces might require techniques such as polling or callback functions to determine when a command has been applied. In this reference, the parameter descriptions indicate whether a command is applied immediately, on the next instance reboot, or during the maintenance window. The reference structure is as follows, and we list following some related topics from the user guide.</p> <p> <b>Amazon RDS API Reference</b> </p> <ul> <li> <p>For the alphabetical list of API actions, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_Operations.html">API Actions</a>.</p> </li> <li> <p>For the alphabetical list of data types, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_Types.html">Data Types</a>.</p> </li> <li> <p>For a list of common query parameters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/CommonParameters.html">Common Parameters</a>.</p> </li> <li> <p>For descriptions of the error codes, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/CommonErrors.html">Common Errors</a>.</p> </li> </ul> <p> <b>Amazon RDS User Guide</b> </p> <ul> <li> <p>For a summary of the Amazon RDS interfaces, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Welcome.html#Welcome.Interfaces">Available RDS Interfaces</a>.</p> </li> <li> <p>For more information about how to use the Query API, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Using_the_Query_API.html">Using the Query API</a>.</p> </li> </ul>', 'operations' => [ 'AddRoleToDBCluster' => '<p>Associates an Identity and Access Management (IAM) role with a DB cluster.</p>', 'AddRoleToDBInstance' => '<p>Associates an Amazon Web Services Identity and Access Management (IAM) role with a DB instance.</p> <note> <p>To add a role to a DB instance, the status of the DB instance must be <code>available</code>.</p> </note> <p>This command doesn\'t apply to RDS Custom.</p>', 'AddSourceIdentifierToSubscription' => '<p>Adds a source identifier to an existing RDS event notification subscription.</p>', 'AddTagsToResource' => '<p>Adds metadata tags to an Amazon RDS resource. These tags can also be used with cost allocation reporting to track cost associated with Amazon RDS resources, or used in a Condition statement in an IAM policy for Amazon RDS.</p> <p>For an overview on tagging your relational database resources, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> or <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Tagging.html">Tagging Amazon Aurora and Amazon RDS Resources</a>. </p>', 'ApplyPendingMaintenanceAction' => '<p>Applies a pending maintenance action to a resource (for example, to a DB instance).</p>', 'AuthorizeDBSecurityGroupIngress' => '<p>Enables ingress to a DBSecurityGroup using one of two forms of authorization. First, EC2 or VPC security groups can be added to the DBSecurityGroup if the application using the database is running on EC2 or VPC instances. Second, IP ranges are available if the application accessing your database is running on the internet. Required parameters for this API are one of CIDR range, EC2SecurityGroupId for VPC, or (EC2SecurityGroupOwnerId and either EC2SecurityGroupName or EC2SecurityGroupId for non-VPC).</p> <p>You can\'t authorize ingress from an EC2 security group in one Amazon Web Services Region to an Amazon RDS DB instance in another. You can\'t authorize ingress from a VPC security group in one VPC to an Amazon RDS DB instance in another.</p> <p>For an overview of CIDR ranges, go to the <a href="http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Wikipedia Tutorial</a>.</p> <note> <p>EC2-Classic was retired on August 15, 2022. If you haven\'t migrated from EC2-Classic to a VPC, we recommend that you migrate as soon as possible. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-migrate.html">Migrate from EC2-Classic to a VPC</a> in the <i>Amazon EC2 User Guide</i>, the blog <a href="http://aws.amazon.com/blogs/aws/ec2-classic-is-retiring-heres-how-to-prepare/">EC2-Classic Networking is Retiring – Here’s How to Prepare</a>, and <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.Non-VPC2VPC.html">Moving a DB instance not in a VPC into a VPC</a> in the <i>Amazon RDS User Guide</i>.</p> </note>', 'BacktrackDBCluster' => '<p>Backtracks a DB cluster to a specific time, without creating a new DB cluster.</p> <p>For more information on backtracking, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Managing.Backtrack.html"> Backtracking an Aurora DB Cluster</a> in the <i>Amazon Aurora User Guide</i>.</p> <note> <p>This action applies only to Aurora MySQL DB clusters.</p> </note>', 'CancelExportTask' => '<p>Cancels an export task in progress that is exporting a snapshot or cluster to Amazon S3. Any data that has already been written to the S3 bucket isn\'t removed.</p>', 'CopyDBClusterParameterGroup' => '<p>Copies the specified DB cluster parameter group.</p> <note> <p>You can\'t copy a default DB cluster parameter group. Instead, create a new custom DB cluster parameter group, which copies the default parameters and values for the specified DB cluster parameter group family.</p> </note>', 'CopyDBClusterSnapshot' => '<p>Copies a snapshot of a DB cluster.</p> <p>To copy a DB cluster snapshot from a shared manual DB cluster snapshot, <code>SourceDBClusterSnapshotIdentifier</code> must be the Amazon Resource Name (ARN) of the shared DB cluster snapshot.</p> <p>You can copy an encrypted DB cluster snapshot from another Amazon Web Services Region. In that case, the Amazon Web Services Region where you call the <code>CopyDBClusterSnapshot</code> operation is the destination Amazon Web Services Region for the encrypted DB cluster snapshot to be copied to. To copy an encrypted DB cluster snapshot from another Amazon Web Services Region, you must provide the following values:</p> <ul> <li> <p> <code>KmsKeyId</code> - The Amazon Web Services Key Management System (Amazon Web Services KMS) key identifier for the key to use to encrypt the copy of the DB cluster snapshot in the destination Amazon Web Services Region.</p> </li> <li> <p> <code>TargetDBClusterSnapshotIdentifier</code> - The identifier for the new copy of the DB cluster snapshot in the destination Amazon Web Services Region.</p> </li> <li> <p> <code>SourceDBClusterSnapshotIdentifier</code> - The DB cluster snapshot identifier for the encrypted DB cluster snapshot to be copied. This identifier must be in the ARN format for the source Amazon Web Services Region and is the same value as the <code>SourceDBClusterSnapshotIdentifier</code> in the presigned URL.</p> </li> </ul> <p>To cancel the copy operation once it is in progress, delete the target DB cluster snapshot identified by <code>TargetDBClusterSnapshotIdentifier</code> while that DB cluster snapshot is in "copying" status.</p> <p>For more information on copying encrypted Amazon Aurora DB cluster snapshots from one Amazon Web Services Region to another, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_CopySnapshot.html"> Copying a Snapshot</a> in the <i>Amazon Aurora User Guide</i>.</p> <p>For more information on Amazon Aurora DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon Aurora?</a> in the <i>Amazon Aurora User Guide</i>.</p> <p>For more information on Multi-AZ DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB cluster deployments</a> in the <i>Amazon RDS User Guide</i>.</p>', 'CopyDBParameterGroup' => '<p>Copies the specified DB parameter group.</p> <note> <p>You can\'t copy a default DB parameter group. Instead, create a new custom DB parameter group, which copies the default parameters and values for the specified DB parameter group family.</p> </note>', 'CopyDBSnapshot' => '<p>Copies the specified DB snapshot. The source DB snapshot must be in the <code>available</code> state.</p> <p>You can copy a snapshot from one Amazon Web Services Region to another. In that case, the Amazon Web Services Region where you call the <code>CopyDBSnapshot</code> operation is the destination Amazon Web Services Region for the DB snapshot copy.</p> <p>This command doesn\'t apply to RDS Custom.</p> <p>For more information about copying snapshots, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CopySnapshot.html#USER_CopyDBSnapshot">Copying a DB Snapshot</a> in the <i>Amazon RDS User Guide</i>.</p>', 'CopyOptionGroup' => '<p>Copies the specified option group.</p>', 'CreateBlueGreenDeployment' => '<p>Creates a blue/green deployment.</p> <p>A blue/green deployment creates a staging environment that copies the production environment. In a blue/green deployment, the blue environment is the current production environment. The green environment is the staging environment. The staging environment stays in sync with the current production environment using logical replication.</p> <p>You can make changes to the databases in the green environment without affecting production workloads. For example, you can upgrade the major or minor DB engine version, change database parameters, or make schema changes in the staging environment. You can thoroughly test changes in the green environment. When ready, you can switch over the environments to promote the green environment to be the new production environment. The switchover typically takes under a minute.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/blue-green-deployments.html">Using Amazon RDS Blue/Green Deployments for database updates</a> in the <i>Amazon RDS User Guide</i> and <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/blue-green-deployments.html"> Using Amazon RDS Blue/Green Deployments for database updates</a> in the <i>Amazon Aurora User Guide</i>.</p>', 'CreateCustomDBEngineVersion' => '<p>Creates a custom DB engine version (CEV).</p>', 'CreateDBCluster' => '<p>Creates a new Amazon Aurora DB cluster or Multi-AZ DB cluster.</p> <p>If you create an Aurora DB cluster, the request creates an empty cluster. You must explicitly create the writer instance for your DB cluster using the <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html">CreateDBInstance</a> operation. If you create a Multi-AZ DB cluster, the request creates a writer and two reader DB instances for you, each in a different Availability Zone.</p> <p>You can use the <code>ReplicationSourceIdentifier</code> parameter to create an Amazon Aurora DB cluster as a read replica of another DB cluster or Amazon RDS for MySQL or PostgreSQL DB instance. For more information about Amazon Aurora, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">What is Amazon Aurora?</a> in the <i>Amazon Aurora User Guide</i>.</p> <p>You can also use the <code>ReplicationSourceIdentifier</code> parameter to create a Multi-AZ DB cluster read replica with an RDS for MySQL or PostgreSQL DB instance as the source. For more information about Multi-AZ DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html">Multi-AZ DB cluster deployments</a> in the <i>Amazon RDS User Guide</i>.</p>', 'CreateDBClusterEndpoint' => '<p>Creates a new custom endpoint and associates it with an Amazon Aurora DB cluster.</p> <note> <p>This action applies only to Aurora DB clusters.</p> </note>', 'CreateDBClusterParameterGroup' => '<p>Creates a new DB cluster parameter group.</p> <p>Parameters in a DB cluster parameter group apply to all of the instances in a DB cluster.</p> <p>A DB cluster parameter group is initially created with the default parameters for the database engine used by instances in the DB cluster. To provide custom values for any of the parameters, you must modify the group after creating it using <code>ModifyDBClusterParameterGroup</code>. Once you\'ve created a DB cluster parameter group, you need to associate it with your DB cluster using <code>ModifyDBCluster</code>.</p> <p>When you associate a new DB cluster parameter group with a running Aurora DB cluster, reboot the DB instances in the DB cluster without failover for the new DB cluster parameter group and associated settings to take effect.</p> <p>When you associate a new DB cluster parameter group with a running Multi-AZ DB cluster, reboot the DB cluster without failover for the new DB cluster parameter group and associated settings to take effect.</p> <important> <p>After you create a DB cluster parameter group, you should wait at least 5 minutes before creating your first DB cluster that uses that DB cluster parameter group as the default parameter group. This allows Amazon RDS to fully complete the create action before the DB cluster parameter group is used as the default for a new DB cluster. This is especially important for parameters that are critical when creating the default database for a DB cluster, such as the character set for the default database defined by the <code>character_set_database</code> parameter. You can use the <i>Parameter Groups</i> option of the <a href="https://console.aws.amazon.com/rds/">Amazon RDS console</a> or the <code>DescribeDBClusterParameters</code> operation to verify that your DB cluster parameter group has been created or modified.</p> </important> <p>For more information on Amazon Aurora, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon Aurora?</a> in the <i>Amazon Aurora User Guide</i>.</p> <p>For more information on Multi-AZ DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB cluster deployments</a> in the <i>Amazon RDS User Guide</i>.</p>', 'CreateDBClusterSnapshot' => '<p>Creates a snapshot of a DB cluster.</p> <p>For more information on Amazon Aurora, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon Aurora?</a> in the <i>Amazon Aurora User Guide</i>.</p> <p>For more information on Multi-AZ DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB cluster deployments</a> in the <i>Amazon RDS User Guide</i>.</p>', 'CreateDBInstance' => '<p>Creates a new DB instance.</p> <p>The new DB instance can be an RDS DB instance, or it can be a DB instance in an Aurora DB cluster. For an Aurora DB cluster, you can call this operation multiple times to add more than one DB instance to the cluster.</p> <p>For more information about creating an RDS DB instance, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CreateDBInstance.html"> Creating an Amazon RDS DB instance</a> in the <i>Amazon RDS User Guide</i>.</p> <p>For more information about creating a DB instance in an Aurora DB cluster, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.CreateInstance.html"> Creating an Amazon Aurora DB cluster</a> in the <i>Amazon Aurora User Guide</i>.</p>', 'CreateDBInstanceReadReplica' => '<p>Creates a new DB instance that acts as a read replica for an existing source DB instance or Multi-AZ DB cluster. You can create a read replica for a DB instance running Db2, MariaDB, MySQL, Oracle, PostgreSQL, or SQL Server. You can create a read replica for a Multi-AZ DB cluster running MySQL or PostgreSQL. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_ReadRepl.html">Working with read replicas</a> and <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html#multi-az-db-clusters-migrating-to-instance-with-read-replica">Migrating from a Multi-AZ DB cluster to a DB instance using a read replica</a> in the <i>Amazon RDS User Guide</i>.</p> <p>Amazon Aurora doesn\'t support this operation. To create a DB instance for an Aurora DB cluster, use the <code>CreateDBInstance</code> operation.</p> <p>All read replica DB instances are created with backups disabled. All other attributes (including DB security groups and DB parameter groups) are inherited from the source DB instance or cluster, except as specified.</p> <important> <p>Your source DB instance or cluster must have backup retention enabled.</p> </important>', 'CreateDBParameterGroup' => '<p>Creates a new DB parameter group.</p> <p>A DB parameter group is initially created with the default parameters for the database engine used by the DB instance. To provide custom values for any of the parameters, you must modify the group after creating it using <code>ModifyDBParameterGroup</code>. Once you\'ve created a DB parameter group, you need to associate it with your DB instance using <code>ModifyDBInstance</code>. When you associate a new DB parameter group with a running DB instance, you need to reboot the DB instance without failover for the new DB parameter group and associated settings to take effect.</p> <p>This command doesn\'t apply to RDS Custom.</p> <important> <p>After you create a DB parameter group, you should wait at least 5 minutes before creating your first DB instance that uses that DB parameter group as the default parameter group. This allows Amazon RDS to fully complete the create action before the parameter group is used as the default for a new DB instance. This is especially important for parameters that are critical when creating the default database for a DB instance, such as the character set for the default database defined by the <code>character_set_database</code> parameter. You can use the <i>Parameter Groups</i> option of the <a href="https://console.aws.amazon.com/rds/">Amazon RDS console</a> or the <i>DescribeDBParameters</i> command to verify that your DB parameter group has been created or modified.</p> </important>', 'CreateDBProxy' => '<p>Creates a new DB proxy.</p>', 'CreateDBProxyEndpoint' => '<p>Creates a <code>DBProxyEndpoint</code>. Only applies to proxies that are associated with Aurora DB clusters. You can use DB proxy endpoints to specify read/write or read-only access to the DB cluster. You can also use DB proxy endpoints to access a DB proxy through a different VPC than the proxy\'s default VPC.</p>', 'CreateDBSecurityGroup' => '<p>Creates a new DB security group. DB security groups control access to a DB instance.</p> <p>A DB security group controls access to EC2-Classic DB instances that are not in a VPC.</p> <note> <p>EC2-Classic was retired on August 15, 2022. If you haven\'t migrated from EC2-Classic to a VPC, we recommend that you migrate as soon as possible. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-migrate.html">Migrate from EC2-Classic to a VPC</a> in the <i>Amazon EC2 User Guide</i>, the blog <a href="http://aws.amazon.com/blogs/aws/ec2-classic-is-retiring-heres-how-to-prepare/">EC2-Classic Networking is Retiring – Here’s How to Prepare</a>, and <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.Non-VPC2VPC.html">Moving a DB instance not in a VPC into a VPC</a> in the <i>Amazon RDS User Guide</i>.</p> </note>', 'CreateDBShardGroup' => '<p>Creates a new DB shard group for Aurora Limitless Database. You must enable Aurora Limitless Database to create a DB shard group.</p> <p>Valid for: Aurora DB clusters only</p>', 'CreateDBSnapshot' => '<p>Creates a snapshot of a DB instance. The source DB instance must be in the <code>available</code> or <code>storage-optimization</code> state.</p>', 'CreateDBSubnetGroup' => '<p>Creates a new DB subnet group. DB subnet groups must contain at least one subnet in at least two AZs in the Amazon Web Services Region.</p>', 'CreateEventSubscription' => '<p>Creates an RDS event notification subscription. This operation requires a topic Amazon Resource Name (ARN) created by either the RDS console, the SNS console, or the SNS API. To obtain an ARN with SNS, you must create a topic in Amazon SNS and subscribe to the topic. The ARN is displayed in the SNS console.</p> <p>You can specify the type of source (<code>SourceType</code>) that you want to be notified of and provide a list of RDS sources (<code>SourceIds</code>) that triggers the events. You can also provide a list of event categories (<code>EventCategories</code>) for events that you want to be notified of. For example, you can specify <code>SourceType</code> = <code>db-instance</code>, <code>SourceIds</code> = <code>mydbinstance1</code>, <code>mydbinstance2</code> and <code>EventCategories</code> = <code>Availability</code>, <code>Backup</code>.</p> <p>If you specify both the <code>SourceType</code> and <code>SourceIds</code>, such as <code>SourceType</code> = <code>db-instance</code> and <code>SourceIds</code> = <code>myDBInstance1</code>, you are notified of all the <code>db-instance</code> events for the specified source. If you specify a <code>SourceType</code> but do not specify <code>SourceIds</code>, you receive notice of the events for that source type for all your RDS sources. If you don\'t specify either the SourceType or the <code>SourceIds</code>, you are notified of events generated from all RDS sources belonging to your customer account.</p> <p>For more information about subscribing to an event for RDS DB engines, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.Subscribing.html"> Subscribing to Amazon RDS event notification</a> in the <i>Amazon RDS User Guide</i>.</p> <p>For more information about subscribing to an event for Aurora DB engines, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Events.Subscribing.html"> Subscribing to Amazon RDS event notification</a> in the <i>Amazon Aurora User Guide</i>.</p>', 'CreateGlobalCluster' => '<p>Creates an Aurora global database spread across multiple Amazon Web Services Regions. The global database contains a single primary cluster with read-write capability, and a read-only secondary cluster that receives data from the primary cluster through high-speed replication performed by the Aurora storage subsystem.</p> <p>You can create a global database that is initially empty, and then create the primary and secondary DB clusters in the global database. Or you can specify an existing Aurora cluster during the create operation, and this cluster becomes the primary cluster of the global database.</p> <note> <p>This operation applies only to Aurora DB clusters.</p> </note>', 'CreateIntegration' => '<p>Creates a zero-ETL integration with Amazon Redshift.</p>', 'CreateOptionGroup' => '<p>Creates a new option group. You can create up to 20 option groups.</p> <p>This command doesn\'t apply to RDS Custom.</p>', 'CreateTenantDatabase' => '<p>Creates a tenant database in a DB instance that uses the multi-tenant configuration. Only RDS for Oracle container database (CDB) instances are supported.</p>', 'DeleteBlueGreenDeployment' => '<p>Deletes a blue/green deployment.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/blue-green-deployments.html">Using Amazon RDS Blue/Green Deployments for database updates</a> in the <i>Amazon RDS User Guide</i> and <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/blue-green-deployments.html">Using Amazon RDS Blue/Green Deployments for database updates</a> in the <i>Amazon Aurora User Guide</i>.</p>', 'DeleteCustomDBEngineVersion' => '<p>Deletes a custom engine version. To run this command, make sure you meet the following prerequisites:</p> <ul> <li> <p>The CEV must not be the default for RDS Custom. If it is, change the default before running this command.</p> </li> <li> <p>The CEV must not be associated with an RDS Custom DB instance, RDS Custom instance snapshot, or automated backup of your RDS Custom instance.</p> </li> </ul> <p>Typically, deletion takes a few minutes.</p> <note> <p>The MediaImport service that imports files from Amazon S3 to create CEVs isn\'t integrated with Amazon Web Services CloudTrail. If you turn on data logging for Amazon RDS in CloudTrail, calls to the <code>DeleteCustomDbEngineVersion</code> event aren\'t logged. However, you might see calls from the API gateway that accesses your Amazon S3 bucket. These calls originate from the MediaImport service for the <code>DeleteCustomDbEngineVersion</code> event.</p> </note> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-cev.html#custom-cev.delete">Deleting a CEV</a> in the <i>Amazon RDS User Guide</i>.</p>', 'DeleteDBCluster' => '<p>The DeleteDBCluster action deletes a previously provisioned DB cluster. When you delete a DB cluster, all automated backups for that DB cluster are deleted and can\'t be recovered. Manual DB cluster snapshots of the specified DB cluster are not deleted.</p> <p>If you\'re deleting a Multi-AZ DB cluster with read replicas, all cluster members are terminated and read replicas are promoted to standalone instances.</p> <p>For more information on Amazon Aurora, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon Aurora?</a> in the <i>Amazon Aurora User Guide</i>.</p> <p>For more information on Multi-AZ DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB cluster deployments</a> in the <i>Amazon RDS User Guide</i>.</p>', 'DeleteDBClusterAutomatedBackup' => '<p>Deletes automated backups using the <code>DbClusterResourceId</code> value of the source DB cluster or the Amazon Resource Name (ARN) of the automated backups.</p>', 'DeleteDBClusterEndpoint' => '<p>Deletes a custom endpoint and removes it from an Amazon Aurora DB cluster.</p> <note> <p>This action only applies to Aurora DB clusters.</p> </note>', 'DeleteDBClusterParameterGroup' => '<p>Deletes a specified DB cluster parameter group. The DB cluster parameter group to be deleted can\'t be associated with any DB clusters.</p> <p>For more information on Amazon Aurora, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon Aurora?</a> in the <i>Amazon Aurora User Guide</i>.</p> <p>For more information on Multi-AZ DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB cluster deployments</a> in the <i>Amazon RDS User Guide</i>.</p>', 'DeleteDBClusterSnapshot' => '<p>Deletes a DB cluster snapshot. If the snapshot is being copied, the copy operation is terminated.</p> <note> <p>The DB cluster snapshot must be in the <code>available</code> state to be deleted.</p> </note> <p>For more information on Amazon Aurora, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon Aurora?</a> in the <i>Amazon Aurora User Guide</i>.</p> <p>For more information on Multi-AZ DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB cluster deployments</a> in the <i>Amazon RDS User Guide</i>.</p>', 'DeleteDBInstance' => '<p>Deletes a previously provisioned DB instance. When you delete a DB instance, all automated backups for that instance are deleted and can\'t be recovered. However, manual DB snapshots of the DB instance aren\'t deleted.</p> <p>If you request a final DB snapshot, the status of the Amazon RDS DB instance is <code>deleting</code> until the DB snapshot is created. This operation can\'t be canceled or reverted after it begins. To monitor the status of this operation, use <code>DescribeDBInstance</code>.</p> <p>When a DB instance is in a failure state and has a status of <code>failed</code>, <code>incompatible-restore</code>, or <code>incompatible-network</code>, you can only delete it when you skip creation of the final snapshot with the <code>SkipFinalSnapshot</code> parameter.</p> <p>If the specified DB instance is part of an Amazon Aurora DB cluster, you can\'t delete the DB instance if both of the following conditions are true:</p> <ul> <li> <p>The DB cluster is a read replica of another Amazon Aurora DB cluster.</p> </li> <li> <p>The DB instance is the only instance in the DB cluster.</p> </li> </ul> <p>To delete a DB instance in this case, first use the <code>PromoteReadReplicaDBCluster</code> operation to promote the DB cluster so that it\'s no longer a read replica. After the promotion completes, use the <code>DeleteDBInstance</code> operation to delete the final instance in the DB cluster.</p> <important> <p>For RDS Custom DB instances, deleting the DB instance permanently deletes the EC2 instance and the associated EBS volumes. Make sure that you don\'t terminate or delete these resources before you delete the DB instance. Otherwise, deleting the DB instance and creation of the final snapshot might fail.</p> </important>', 'DeleteDBInstanceAutomatedBackup' => '<p>Deletes automated backups using the <code>DbiResourceId</code> value of the source DB instance or the Amazon Resource Name (ARN) of the automated backups.</p>', 'DeleteDBParameterGroup' => '<p>Deletes a specified DB parameter group. The DB parameter group to be deleted can\'t be associated with any DB instances.</p>', 'DeleteDBProxy' => '<p>Deletes an existing DB proxy.</p>', 'DeleteDBProxyEndpoint' => '<p>Deletes a <code>DBProxyEndpoint</code>. Doing so removes the ability to access the DB proxy using the endpoint that you defined. The endpoint that you delete might have provided capabilities such as read/write or read-only operations, or using a different VPC than the DB proxy\'s default VPC.</p>', 'DeleteDBSecurityGroup' => '<p>Deletes a DB security group.</p> <p>The specified DB security group must not be associated with any DB instances.</p> <note> <p>EC2-Classic was retired on August 15, 2022. If you haven\'t migrated from EC2-Classic to a VPC, we recommend that you migrate as soon as possible. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-migrate.html">Migrate from EC2-Classic to a VPC</a> in the <i>Amazon EC2 User Guide</i>, the blog <a href="http://aws.amazon.com/blogs/aws/ec2-classic-is-retiring-heres-how-to-prepare/">EC2-Classic Networking is Retiring – Here’s How to Prepare</a>, and <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.Non-VPC2VPC.html">Moving a DB instance not in a VPC into a VPC</a> in the <i>Amazon RDS User Guide</i>.</p> </note>', 'DeleteDBShardGroup' => '<p>Deletes an Aurora Limitless Database DB shard group.</p>', 'DeleteDBSnapshot' => '<p>Deletes a DB snapshot. If the snapshot is being copied, the copy operation is terminated.</p> <note> <p>The DB snapshot must be in the <code>available</code> state to be deleted.</p> </note>', 'DeleteDBSubnetGroup' => '<p>Deletes a DB subnet group.</p> <note> <p>The specified database subnet group must not be associated with any DB instances.</p> </note>', 'DeleteEventSubscription' => '<p>Deletes an RDS event notification subscription.</p>', 'DeleteGlobalCluster' => '<p>Deletes a global database cluster. The primary and secondary clusters must already be detached or destroyed first.</p> <note> <p>This action only applies to Aurora DB clusters.</p> </note>', 'DeleteIntegration' => '<p>Deletes a zero-ETL integration with Amazon Redshift.</p>', 'DeleteOptionGroup' => '<p>Deletes an existing option group.</p>', 'DeleteTenantDatabase' => '<p>Deletes a tenant database from your DB instance. This command only applies to RDS for Oracle container database (CDB) instances.</p> <p>You can\'t delete a tenant database when it is the only tenant in the DB instance.</p>', 'DeregisterDBProxyTargets' => '<p>Remove the association between one or more <code>DBProxyTarget</code> data structures and a <code>DBProxyTargetGroup</code>.</p>', 'DescribeAccountAttributes' => '<p>Lists all of the attributes for a customer account. The attributes include Amazon RDS quotas for the account, such as the number of DB instances allowed. The description for a quota includes the quota name, current usage toward that quota, and the quota\'s maximum value.</p> <p>This command doesn\'t take any parameters.</p>', 'DescribeBlueGreenDeployments' => '<p>Describes one or more blue/green deployments.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/blue-green-deployments.html">Using Amazon RDS Blue/Green Deployments for database updates</a> in the <i>Amazon RDS User Guide</i> and <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/blue-green-deployments.html"> Using Amazon RDS Blue/Green Deployments for database updates</a> in the <i>Amazon Aurora User Guide</i>.</p>', 'DescribeCertificates' => '<p>Lists the set of certificate authority (CA) certificates provided by Amazon RDS for this Amazon Web Services account.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html">Using SSL/TLS to encrypt a connection to a DB instance</a> in the <i>Amazon RDS User Guide</i> and <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html"> Using SSL/TLS to encrypt a connection to a DB cluster</a> in the <i>Amazon Aurora User Guide</i>.</p>', 'DescribeDBClusterAutomatedBackups' => '<p>Displays backups for both current and deleted DB clusters. For example, use this operation to find details about automated backups for previously deleted clusters. Current clusters are returned for both the <code>DescribeDBClusterAutomatedBackups</code> and <code>DescribeDBClusters</code> operations.</p> <p>All parameters are optional.</p>', 'DescribeDBClusterBacktracks' => '<p>Returns information about backtracks for a DB cluster.</p> <p>For more information on Amazon Aurora, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon Aurora?</a> in the <i>Amazon Aurora User Guide</i>.</p> <note> <p>This action only applies to Aurora MySQL DB clusters.</p> </note>', 'DescribeDBClusterEndpoints' => '<p>Returns information about endpoints for an Amazon Aurora DB cluster.</p> <note> <p>This action only applies to Aurora DB clusters.</p> </note>', 'DescribeDBClusterParameterGroups' => '<p>Returns a list of <code>DBClusterParameterGroup</code> descriptions. If a <code>DBClusterParameterGroupName</code> parameter is specified, the list will contain only the description of the specified DB cluster parameter group.</p> <p>For more information on Amazon Aurora, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon Aurora?</a> in the <i>Amazon Aurora User Guide</i>.</p> <p>For more information on Multi-AZ DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB cluster deployments</a> in the <i>Amazon RDS User Guide</i>.</p>', 'DescribeDBClusterParameters' => '<p>Returns the detailed parameter list for a particular DB cluster parameter group.</p> <p>For more information on Amazon Aurora, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon Aurora?</a> in the <i>Amazon Aurora User Guide</i>.</p> <p>For more information on Multi-AZ DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB cluster deployments</a> in the <i>Amazon RDS User Guide</i>.</p>', 'DescribeDBClusterSnapshotAttributes' => '<p>Returns a list of DB cluster snapshot attribute names and values for a manual DB cluster snapshot.</p> <p>When sharing snapshots with other Amazon Web Services accounts, <code>DescribeDBClusterSnapshotAttributes</code> returns the <code>restore</code> attribute and a list of IDs for the Amazon Web Services accounts that are authorized to copy or restore the manual DB cluster snapshot. If <code>all</code> is included in the list of values for the <code>restore</code> attribute, then the manual DB cluster snapshot is public and can be copied or restored by all Amazon Web Services accounts.</p> <p>To add or remove access for an Amazon Web Services account to copy or restore a manual DB cluster snapshot, or to make the manual DB cluster snapshot public or private, use the <code>ModifyDBClusterSnapshotAttribute</code> API action.</p>', 'DescribeDBClusterSnapshots' => '<p>Returns information about DB cluster snapshots. This API action supports pagination.</p> <p>For more information on Amazon Aurora DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon Aurora?</a> in the <i>Amazon Aurora User Guide</i>.</p> <p>For more information on Multi-AZ DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB cluster deployments</a> in the <i>Amazon RDS User Guide</i>.</p>', 'DescribeDBClusters' => '<p>Describes existing Amazon Aurora DB clusters and Multi-AZ DB clusters. This API supports pagination.</p> <p>For more information on Amazon Aurora DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon Aurora?</a> in the <i>Amazon Aurora User Guide</i>.</p> <p>For more information on Multi-AZ DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB cluster deployments</a> in the <i>Amazon RDS User Guide</i>.</p> <p>This operation can also return information for Amazon Neptune DB instances and Amazon DocumentDB instances.</p>', 'DescribeDBEngineVersions' => '<p>Describes the properties of specific versions of DB engines.</p>', 'DescribeDBInstanceAutomatedBackups' => '<p>Displays backups for both current and deleted instances. For example, use this operation to find details about automated backups for previously deleted instances. Current instances with retention periods greater than zero (0) are returned for both the <code>DescribeDBInstanceAutomatedBackups</code> and <code>DescribeDBInstances</code> operations.</p> <p>All parameters are optional.</p>', 'DescribeDBInstances' => '<p>Describes provisioned RDS instances. This API supports pagination.</p> <note> <p>This operation can also return information for Amazon Neptune DB instances and Amazon DocumentDB instances.</p> </note>', 'DescribeDBLogFiles' => '<p>Returns a list of DB log files for the DB instance.</p> <p>This command doesn\'t apply to RDS Custom.</p>', 'DescribeDBParameterGroups' => '<p>Returns a list of <code>DBParameterGroup</code> descriptions. If a <code>DBParameterGroupName</code> is specified, the list will contain only the description of the specified DB parameter group.</p>', 'DescribeDBParameters' => '<p>Returns the detailed parameter list for a particular DB parameter group.</p>', 'DescribeDBProxies' => '<p>Returns information about DB proxies.</p>', 'DescribeDBProxyEndpoints' => '<p>Returns information about DB proxy endpoints.</p>', 'DescribeDBProxyTargetGroups' => '<p>Returns information about DB proxy target groups, represented by <code>DBProxyTargetGroup</code> data structures.</p>', 'DescribeDBProxyTargets' => '<p>Returns information about <code>DBProxyTarget</code> objects. This API supports pagination.</p>', 'DescribeDBRecommendations' => '<p>Describes the recommendations to resolve the issues for your DB instances, DB clusters, and DB parameter groups.</p>', 'DescribeDBSecurityGroups' => '<p>Returns a list of <code>DBSecurityGroup</code> descriptions. If a <code>DBSecurityGroupName</code> is specified, the list will contain only the descriptions of the specified DB security group.</p> <note> <p>EC2-Classic was retired on August 15, 2022. If you haven\'t migrated from EC2-Classic to a VPC, we recommend that you migrate as soon as possible. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-migrate.html">Migrate from EC2-Classic to a VPC</a> in the <i>Amazon EC2 User Guide</i>, the blog <a href="http://aws.amazon.com/blogs/aws/ec2-classic-is-retiring-heres-how-to-prepare/">EC2-Classic Networking is Retiring – Here’s How to Prepare</a>, and <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.Non-VPC2VPC.html">Moving a DB instance not in a VPC into a VPC</a> in the <i>Amazon RDS User Guide</i>.</p> </note>', 'DescribeDBShardGroups' => '<p>Describes existing Aurora Limitless Database DB shard groups.</p>', 'DescribeDBSnapshotAttributes' => '<p>Returns a list of DB snapshot attribute names and values for a manual DB snapshot.</p> <p>When sharing snapshots with other Amazon Web Services accounts, <code>DescribeDBSnapshotAttributes</code> returns the <code>restore</code> attribute and a list of IDs for the Amazon Web Services accounts that are authorized to copy or restore the manual DB snapshot. If <code>all</code> is included in the list of values for the <code>restore</code> attribute, then the manual DB snapshot is public and can be copied or restored by all Amazon Web Services accounts.</p> <p>To add or remove access for an Amazon Web Services account to copy or restore a manual DB snapshot, or to make the manual DB snapshot public or private, use the <code>ModifyDBSnapshotAttribute</code> API action.</p>', 'DescribeDBSnapshotTenantDatabases' => '<p>Describes the tenant databases that exist in a DB snapshot. This command only applies to RDS for Oracle DB instances in the multi-tenant configuration.</p> <p>You can use this command to inspect the tenant databases within a snapshot before restoring it. You can\'t directly interact with the tenant databases in a DB snapshot. If you restore a snapshot that was taken from DB instance using the multi-tenant configuration, you restore all its tenant databases.</p>', 'DescribeDBSnapshots' => '<p>Returns information about DB snapshots. This API action supports pagination.</p>', 'DescribeDBSubnetGroups' => '<p>Returns a list of DBSubnetGroup descriptions. If a DBSubnetGroupName is specified, the list will contain only the descriptions of the specified DBSubnetGroup.</p> <p>For an overview of CIDR ranges, go to the <a href="http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Wikipedia Tutorial</a>.</p>', 'DescribeEngineDefaultClusterParameters' => '<p>Returns the default engine and system parameter information for the cluster database engine.</p> <p>For more information on Amazon Aurora, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon Aurora?</a> in the <i>Amazon Aurora User Guide</i>.</p>', 'DescribeEngineDefaultParameters' => '<p>Returns the default engine and system parameter information for the specified database engine.</p>', 'DescribeEventCategories' => '<p>Displays a list of categories for all event source types, or, if specified, for a specified source type. You can also see this list in the "Amazon RDS event categories and event messages" section of the <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.Messages.html"> <i>Amazon RDS User Guide</i> </a> or the <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Events.Messages.html"> <i>Amazon Aurora User Guide</i> </a>.</p>', 'DescribeEventSubscriptions' => '<p>Lists all the subscription descriptions for a customer account. The description for a subscription includes <code>SubscriptionName</code>, <code>SNSTopicARN</code>, <code>CustomerID</code>, <code>SourceType</code>, <code>SourceID</code>, <code>CreationTime</code>, and <code>Status</code>.</p> <p>If you specify a <code>SubscriptionName</code>, lists the description for that subscription.</p>', 'DescribeEvents' => '<p>Returns events related to DB instances, DB clusters, DB parameter groups, DB security groups, DB snapshots, DB cluster snapshots, and RDS Proxies for the past 14 days. Events specific to a particular DB instance, DB cluster, DB parameter group, DB security group, DB snapshot, DB cluster snapshot group, or RDS Proxy can be obtained by providing the name as a parameter.</p> <p>For more information on working with events, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/working-with-events.html">Monitoring Amazon RDS events</a> in the <i>Amazon RDS User Guide</i> and <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/working-with-events.html">Monitoring Amazon Aurora events</a> in the <i>Amazon Aurora User Guide</i>.</p> <note> <p>By default, RDS returns events that were generated in the past hour.</p> </note>', 'DescribeExportTasks' => '<p>Returns information about a snapshot or cluster export to Amazon S3. This API operation supports pagination.</p>', 'DescribeGlobalClusters' => '<p>Returns information about Aurora global database clusters. This API supports pagination.</p> <p>For more information on Amazon Aurora, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon Aurora?</a> in the <i>Amazon Aurora User Guide</i>.</p> <note> <p>This action only applies to Aurora DB clusters.</p> </note>', 'DescribeIntegrations' => '<p>Describe one or more zero-ETL integrations with Amazon Redshift.</p>', 'DescribeOptionGroupOptions' => '<p>Describes all available options for the specified engine.</p>', 'DescribeOptionGroups' => '<p>Describes the available option groups.</p>', 'DescribeOrderableDBInstanceOptions' => '<p>Describes the orderable DB instance options for a specified DB engine.</p>', 'DescribePendingMaintenanceActions' => '<p>Returns a list of resources (for example, DB instances) that have at least one pending maintenance action.</p>', 'DescribeReservedDBInstances' => '<p>Returns information about reserved DB instances for this account, or about a specified reserved DB instance.</p>', 'DescribeReservedDBInstancesOfferings' => '<p>Lists available reserved DB instance offerings.</p>', 'DescribeSourceRegions' => '<p>Returns a list of the source Amazon Web Services Regions where the current Amazon Web Services Region can create a read replica, copy a DB snapshot from, or replicate automated backups from.</p> <p>Use this operation to determine whether cross-Region features are supported between other Regions and your current Region. This operation supports pagination.</p> <p>To return information about the Regions that are enabled for your account, or all Regions, use the EC2 operation <code>DescribeRegions</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeRegions.html"> DescribeRegions</a> in the <i>Amazon EC2 API Reference</i>.</p>', 'DescribeTenantDatabases' => '<p>Describes the tenant databases in a DB instance that uses the multi-tenant configuration. Only RDS for Oracle CDB instances are supported.</p>', 'DescribeValidDBInstanceModifications' => '<p>You can call <code>DescribeValidDBInstanceModifications</code> to learn what modifications you can make to your DB instance. You can use this information when you call <code>ModifyDBInstance</code>.</p> <p>This command doesn\'t apply to RDS Custom.</p>', 'DisableHttpEndpoint' => '<p>Disables the HTTP endpoint for the specified DB cluster. Disabling this endpoint disables RDS Data API.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using RDS Data API</a> in the <i>Amazon Aurora User Guide</i>.</p> <note> <p>This operation applies only to Aurora PostgreSQL Serverless v2 and provisioned DB clusters. To disable the HTTP endpoint for Aurora Serverless v1 DB clusters, use the <code>EnableHttpEndpoint</code> parameter of the <code>ModifyDBCluster</code> operation.</p> </note>', 'DownloadDBLogFilePortion' => '<p>Downloads all or a portion of the specified log file, up to 1 MB in size.</p> <p>This command doesn\'t apply to RDS Custom.</p>', 'EnableHttpEndpoint' => '<p>Enables the HTTP endpoint for the DB cluster. By default, the HTTP endpoint isn\'t enabled.</p> <p>When enabled, this endpoint provides a connectionless web service API (RDS Data API) for running SQL queries on the Aurora DB cluster. You can also query your database from inside the RDS console with the RDS query editor.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using RDS Data API</a> in the <i>Amazon Aurora User Guide</i>.</p> <note> <p>This operation applies only to Aurora PostgreSQL Serverless v2 and provisioned DB clusters. To enable the HTTP endpoint for Aurora Serverless v1 DB clusters, use the <code>EnableHttpEndpoint</code> parameter of the <code>ModifyDBCluster</code> operation.</p> </note>', 'FailoverDBCluster' => '<p>Forces a failover for a DB cluster.</p> <p>For an Aurora DB cluster, failover for a DB cluster promotes one of the Aurora Replicas (read-only instances) in the DB cluster to be the primary DB instance (the cluster writer).</p> <p>For a Multi-AZ DB cluster, after RDS terminates the primary DB instance, the internal monitoring system detects that the primary DB instance is unhealthy and promotes a readable standby (read-only instances) in the DB cluster to be the primary DB instance (the cluster writer). Failover times are typically less than 35 seconds.</p> <p>An Amazon Aurora DB cluster automatically fails over to an Aurora Replica, if one exists, when the primary DB instance fails. A Multi-AZ DB cluster automatically fails over to a readable standby DB instance when the primary DB instance fails.</p> <p>To simulate a failure of a primary instance for testing, you can force a failover. Because each instance in a DB cluster has its own endpoint address, make sure to clean up and re-establish any existing connections that use those endpoint addresses when the failover is complete.</p> <p>For more information on Amazon Aurora DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon Aurora?</a> in the <i>Amazon Aurora User Guide</i>.</p> <p>For more information on Multi-AZ DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB cluster deployments</a> in the <i>Amazon RDS User Guide</i>.</p>', 'FailoverGlobalCluster' => '<p>Promotes the specified secondary DB cluster to be the primary DB cluster in the global database cluster to fail over or switch over a global database. Switchover operations were previously called "managed planned failovers."</p> <note> <p>Although this operation can be used either to fail over or to switch over a global database cluster, its intended use is for global database failover. To switch over a global database cluster, we recommend that you use the <a>SwitchoverGlobalCluster</a> operation instead.</p> </note> <p>How you use this operation depends on whether you are failing over or switching over your global database cluster:</p> <ul> <li> <p>Failing over - Specify the <code>AllowDataLoss</code> parameter and don\'t specify the <code>Switchover</code> parameter.</p> </li> <li> <p>Switching over - Specify the <code>Switchover</code> parameter or omit it, but don\'t specify the <code>AllowDataLoss</code> parameter.</p> </li> </ul> <p> <b>About failing over and switching over</b> </p> <p>While failing over and switching over a global database cluster both change the primary DB cluster, you use these operations for different reasons:</p> <ul> <li> <p> <i>Failing over</i> - Use this operation to respond to an unplanned event, such as a Regional disaster in the primary Region. Failing over can result in a loss of write transaction data that wasn\'t replicated to the chosen secondary before the failover event occurred. However, the recovery process that promotes a DB instance on the chosen seconday DB cluster to be the primary writer DB instance guarantees that the data is in a transactionally consistent state.</p> <p>For more information about failing over an Amazon Aurora global database, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database-disaster-recovery.html#aurora-global-database-failover.managed-unplanned">Performing managed failovers for Aurora global databases</a> in the <i>Amazon Aurora User Guide</i>.</p> </li> <li> <p> <i>Switching over</i> - Use this operation on a healthy global database cluster for planned events, such as Regional rotation or to fail back to the original primary DB cluster after a failover operation. With this operation, there is no data loss.</p> <p>For more information about switching over an Amazon Aurora global database, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database-disaster-recovery.html#aurora-global-database-disaster-recovery.managed-failover">Performing switchovers for Aurora global databases</a> in the <i>Amazon Aurora User Guide</i>.</p> </li> </ul>', 'ListTagsForResource' => '<p>Lists all tags on an Amazon RDS resource.</p> <p>For an overview on tagging an Amazon RDS resource, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide</i>.</p>', 'ModifyActivityStream' => '<p>Changes the audit policy state of a database activity stream to either locked (default) or unlocked. A locked policy is read-only, whereas an unlocked policy is read/write. If your activity stream is started and locked, you can unlock it, customize your audit policy, and then lock your activity stream. Restarting the activity stream isn\'t required. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/DBActivityStreams.Modifying.html"> Modifying a database activity stream</a> in the <i>Amazon RDS User Guide</i>. </p> <p>This operation is supported for RDS for Oracle and Microsoft SQL Server.</p>', 'ModifyCertificates' => '<p>Override the system-default Secure Sockets Layer/Transport Layer Security (SSL/TLS) certificate for Amazon RDS for new DB instances, or remove the override.</p> <p>By using this operation, you can specify an RDS-approved SSL/TLS certificate for new DB instances that is different from the default certificate provided by RDS. You can also use this operation to remove the override, so that new DB instances use the default certificate provided by RDS.</p> <p>You might need to override the default certificate in the following situations:</p> <ul> <li> <p>You already migrated your applications to support the latest certificate authority (CA) certificate, but the new CA certificate is not yet the RDS default CA certificate for the specified Amazon Web Services Region.</p> </li> <li> <p>RDS has already moved to a new default CA certificate for the specified Amazon Web Services Region, but you are still in the process of supporting the new CA certificate. In this case, you temporarily need additional time to finish your application changes.</p> </li> </ul> <p>For more information about rotating your SSL/TLS certificate for RDS DB engines, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL-certificate-rotation.html"> Rotating Your SSL/TLS Certificate</a> in the <i>Amazon RDS User Guide</i>.</p> <p>For more information about rotating your SSL/TLS certificate for Aurora DB engines, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL-certificate-rotation.html"> Rotating Your SSL/TLS Certificate</a> in the <i>Amazon Aurora User Guide</i>.</p>', 'ModifyCurrentDBClusterCapacity' => '<p>Set the capacity of an Aurora Serverless v1 DB cluster to a specific value.</p> <p>Aurora Serverless v1 scales seamlessly based on the workload on the DB cluster. In some cases, the capacity might not scale fast enough to meet a sudden change in workload, such as a large number of new transactions. Call <code>ModifyCurrentDBClusterCapacity</code> to set the capacity explicitly.</p> <p>After this call sets the DB cluster capacity, Aurora Serverless v1 can automatically scale the DB cluster based on the cooldown period for scaling up and the cooldown period for scaling down.</p> <p>For more information about Aurora Serverless v1, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html">Using Amazon Aurora Serverless v1</a> in the <i>Amazon Aurora User Guide</i>.</p> <important> <p>If you call <code>ModifyCurrentDBClusterCapacity</code> with the default <code>TimeoutAction</code>, connections that prevent Aurora Serverless v1 from finding a scaling point might be dropped. For more information about scaling points, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.how-it-works.html#aurora-serverless.how-it-works.auto-scaling"> Autoscaling for Aurora Serverless v1</a> in the <i>Amazon Aurora User Guide</i>.</p> </important> <note> <p>This operation only applies to Aurora Serverless v1 DB clusters.</p> </note>', 'ModifyCustomDBEngineVersion' => '<p>Modifies the status of a custom engine version (CEV). You can find CEVs to modify by calling <code>DescribeDBEngineVersions</code>.</p> <note> <p>The MediaImport service that imports files from Amazon S3 to create CEVs isn\'t integrated with Amazon Web Services CloudTrail. If you turn on data logging for Amazon RDS in CloudTrail, calls to the <code>ModifyCustomDbEngineVersion</code> event aren\'t logged. However, you might see calls from the API gateway that accesses your Amazon S3 bucket. These calls originate from the MediaImport service for the <code>ModifyCustomDbEngineVersion</code> event.</p> </note> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-cev.html#custom-cev.modify">Modifying CEV status</a> in the <i>Amazon RDS User Guide</i>.</p>', 'ModifyDBCluster' => '<p>Modifies the settings of an Amazon Aurora DB cluster or a Multi-AZ DB cluster. You can change one or more settings by specifying these parameters and the new values in the request.</p> <p>For more information on Amazon Aurora DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon Aurora?</a> in the <i>Amazon Aurora User Guide</i>.</p> <p>For more information on Multi-AZ DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB cluster deployments</a> in the <i>Amazon RDS User Guide</i>.</p>', 'ModifyDBClusterEndpoint' => '<p>Modifies the properties of an endpoint in an Amazon Aurora DB cluster.</p> <note> <p>This operation only applies to Aurora DB clusters.</p> </note>', 'ModifyDBClusterParameterGroup' => '<p>Modifies the parameters of a DB cluster parameter group. To modify more than one parameter, submit a list of the following: <code>ParameterName</code>, <code>ParameterValue</code>, and <code>ApplyMethod</code>. A maximum of 20 parameters can be modified in a single request.</p> <important> <p>After you create a DB cluster parameter group, you should wait at least 5 minutes before creating your first DB cluster that uses that DB cluster parameter group as the default parameter group. This allows Amazon RDS to fully complete the create operation before the parameter group is used as the default for a new DB cluster. This is especially important for parameters that are critical when creating the default database for a DB cluster, such as the character set for the default database defined by the <code>character_set_database</code> parameter. You can use the <i>Parameter Groups</i> option of the <a href="https://console.aws.amazon.com/rds/">Amazon RDS console</a> or the <code>DescribeDBClusterParameters</code> operation to verify that your DB cluster parameter group has been created or modified.</p> <p>If the modified DB cluster parameter group is used by an Aurora Serverless v1 cluster, Aurora applies the update immediately. The cluster restart might interrupt your workload. In that case, your application must reopen any connections and retry any transactions that were active when the parameter changes took effect.</p> </important> <p>For more information on Amazon Aurora DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon Aurora?</a> in the <i>Amazon Aurora User Guide</i>.</p> <p>For more information on Multi-AZ DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB cluster deployments</a> in the <i>Amazon RDS User Guide.</i> </p>', 'ModifyDBClusterSnapshotAttribute' => '<p>Adds an attribute and values to, or removes an attribute and values from, a manual DB cluster snapshot.</p> <p>To share a manual DB cluster snapshot with other Amazon Web Services accounts, specify <code>restore</code> as the <code>AttributeName</code> and use the <code>ValuesToAdd</code> parameter to add a list of IDs of the Amazon Web Services accounts that are authorized to restore the manual DB cluster snapshot. Use the value <code>all</code> to make the manual DB cluster snapshot public, which means that it can be copied or restored by all Amazon Web Services accounts.</p> <note> <p>Don\'t add the <code>all</code> value for any manual DB cluster snapshots that contain private information that you don\'t want available to all Amazon Web Services accounts.</p> </note> <p>If a manual DB cluster snapshot is encrypted, it can be shared, but only by specifying a list of authorized Amazon Web Services account IDs for the <code>ValuesToAdd</code> parameter. You can\'t use <code>all</code> as a value for that parameter in this case.</p> <p>To view which Amazon Web Services accounts have access to copy or restore a manual DB cluster snapshot, or whether a manual DB cluster snapshot is public or private, use the <a>DescribeDBClusterSnapshotAttributes</a> API operation. The accounts are returned as values for the <code>restore</code> attribute.</p>', 'ModifyDBInstance' => '<p>Modifies settings for a DB instance. You can change one or more database configuration parameters by specifying these parameters and the new values in the request. To learn what modifications you can make to your DB instance, call <code>DescribeValidDBInstanceModifications</code> before you call <code>ModifyDBInstance</code>.</p>', 'ModifyDBParameterGroup' => '<p>Modifies the parameters of a DB parameter group. To modify more than one parameter, submit a list of the following: <code>ParameterName</code>, <code>ParameterValue</code>, and <code>ApplyMethod</code>. A maximum of 20 parameters can be modified in a single request.</p> <important> <p>After you modify a DB parameter group, you should wait at least 5 minutes before creating your first DB instance that uses that DB parameter group as the default parameter group. This allows Amazon RDS to fully complete the modify operation before the parameter group is used as the default for a new DB instance. This is especially important for parameters that are critical when creating the default database for a DB instance, such as the character set for the default database defined by the <code>character_set_database</code> parameter. You can use the <i>Parameter Groups</i> option of the <a href="https://console.aws.amazon.com/rds/">Amazon RDS console</a> or the <i>DescribeDBParameters</i> command to verify that your DB parameter group has been created or modified.</p> </important>', 'ModifyDBProxy' => '<p>Changes the settings for an existing DB proxy.</p>', 'ModifyDBProxyEndpoint' => '<p>Changes the settings for an existing DB proxy endpoint.</p>', 'ModifyDBProxyTargetGroup' => '<p>Modifies the properties of a <code>DBProxyTargetGroup</code>.</p>', 'ModifyDBRecommendation' => '<p>Updates the recommendation status and recommended action status for the specified recommendation.</p>', 'ModifyDBShardGroup' => '<p>Modifies the settings of an Aurora Limitless Database DB shard group. You can change one or more settings by specifying these parameters and the new values in the request.</p>', 'ModifyDBSnapshot' => '<p>Updates a manual DB snapshot with a new engine version. The snapshot can be encrypted or unencrypted, but not shared or public. </p> <p>Amazon RDS supports upgrading DB snapshots for MySQL, PostgreSQL, and Oracle. This operation doesn\'t apply to RDS Custom or RDS for Db2.</p>', 'ModifyDBSnapshotAttribute' => '<p>Adds an attribute and values to, or removes an attribute and values from, a manual DB snapshot.</p> <p>To share a manual DB snapshot with other Amazon Web Services accounts, specify <code>restore</code> as the <code>AttributeName</code> and use the <code>ValuesToAdd</code> parameter to add a list of IDs of the Amazon Web Services accounts that are authorized to restore the manual DB snapshot. Uses the value <code>all</code> to make the manual DB snapshot public, which means it can be copied or restored by all Amazon Web Services accounts.</p> <note> <p>Don\'t add the <code>all</code> value for any manual DB snapshots that contain private information that you don\'t want available to all Amazon Web Services accounts.</p> </note> <p>If the manual DB snapshot is encrypted, it can be shared, but only by specifying a list of authorized Amazon Web Services account IDs for the <code>ValuesToAdd</code> parameter. You can\'t use <code>all</code> as a value for that parameter in this case.</p> <p>To view which Amazon Web Services accounts have access to copy or restore a manual DB snapshot, or whether a manual DB snapshot public or private, use the <a>DescribeDBSnapshotAttributes</a> API operation. The accounts are returned as values for the <code>restore</code> attribute.</p>', 'ModifyDBSubnetGroup' => '<p>Modifies an existing DB subnet group. DB subnet groups must contain at least one subnet in at least two AZs in the Amazon Web Services Region.</p>', 'ModifyEventSubscription' => '<p>Modifies an existing RDS event notification subscription. You can\'t modify the source identifiers using this call. To change source identifiers for a subscription, use the <code>AddSourceIdentifierToSubscription</code> and <code>RemoveSourceIdentifierFromSubscription</code> calls.</p> <p>You can see a list of the event categories for a given source type (<code>SourceType</code>) in <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html">Events</a> in the <i>Amazon RDS User Guide</i> or by using the <code>DescribeEventCategories</code> operation.</p>', 'ModifyGlobalCluster' => '<p>Modifies a setting for an Amazon Aurora global database cluster. You can change one or more database configuration parameters by specifying these parameters and the new values in the request. For more information on Amazon Aurora, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon Aurora?</a> in the <i>Amazon Aurora User Guide</i>.</p> <note> <p>This operation only applies to Aurora global database clusters.</p> </note>', 'ModifyIntegration' => '<p>Modifies a zero-ETL integration with Amazon Redshift.</p> <note> <p>Currently, you can only modify integrations that have Aurora MySQL source DB clusters. Integrations with Aurora PostgreSQL and RDS sources currently don\'t support modifying the integration.</p> </note>', 'ModifyOptionGroup' => '<p>Modifies an existing option group.</p>', 'ModifyTenantDatabase' => '<p>Modifies an existing tenant database in a DB instance. You can change the tenant database name or the master user password. This operation is supported only for RDS for Oracle CDB instances using the multi-tenant configuration.</p>', 'PromoteReadReplica' => '<p>Promotes a read replica DB instance to a standalone DB instance.</p> <note> <ul> <li> <p>Backup duration is a function of the amount of changes to the database since the previous backup. If you plan to promote a read replica to a standalone instance, we recommend that you enable backups and complete at least one backup prior to promotion. In addition, a read replica cannot be promoted to a standalone instance when it is in the <code>backing-up</code> status. If you have enabled backups on your read replica, configure the automated backup window so that daily backups do not interfere with read replica promotion.</p> </li> <li> <p>This command doesn\'t apply to Aurora MySQL, Aurora PostgreSQL, or RDS Custom.</p> </li> </ul> </note>', 'PromoteReadReplicaDBCluster' => '<p>Promotes a read replica DB cluster to a standalone DB cluster.</p>', 'PurchaseReservedDBInstancesOffering' => '<p>Purchases a reserved DB instance offering.</p>', 'RebootDBCluster' => '<p>You might need to reboot your DB cluster, usually for maintenance reasons. For example, if you make certain modifications, or if you change the DB cluster parameter group associated with the DB cluster, reboot the DB cluster for the changes to take effect.</p> <p>Rebooting a DB cluster restarts the database engine service. Rebooting a DB cluster results in a momentary outage, during which the DB cluster status is set to rebooting.</p> <p>Use this operation only for a non-Aurora Multi-AZ DB cluster.</p> <p>For more information on Multi-AZ DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB cluster deployments</a> in the <i>Amazon RDS User Guide.</i> </p>', 'RebootDBInstance' => '<p>You might need to reboot your DB instance, usually for maintenance reasons. For example, if you make certain modifications, or if you change the DB parameter group associated with the DB instance, you must reboot the instance for the changes to take effect.</p> <p>Rebooting a DB instance restarts the database engine service. Rebooting a DB instance results in a momentary outage, during which the DB instance status is set to rebooting.</p> <p>For more information about rebooting, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_RebootInstance.html">Rebooting a DB Instance</a> in the <i>Amazon RDS User Guide.</i> </p> <p>This command doesn\'t apply to RDS Custom.</p> <p>If your DB instance is part of a Multi-AZ DB cluster, you can reboot the DB cluster with the <code>RebootDBCluster</code> operation.</p>', 'RebootDBShardGroup' => '<p>You might need to reboot your DB shard group, usually for maintenance reasons. For example, if you make certain modifications, reboot the DB shard group for the changes to take effect.</p> <p>This operation applies only to Aurora Limitless Database DBb shard groups.</p>', 'RegisterDBProxyTargets' => '<p>Associate one or more <code>DBProxyTarget</code> data structures with a <code>DBProxyTargetGroup</code>.</p>', 'RemoveFromGlobalCluster' => '<p>Detaches an Aurora secondary cluster from an Aurora global database cluster. The cluster becomes a standalone cluster with read-write capability instead of being read-only and receiving data from a primary cluster in a different Region.</p> <note> <p>This operation only applies to Aurora DB clusters.</p> </note>', 'RemoveRoleFromDBCluster' => '<p>Removes the asssociation of an Amazon Web Services Identity and Access Management (IAM) role from a DB cluster.</p> <p>For more information on Amazon Aurora DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon Aurora?</a> in the <i>Amazon Aurora User Guide</i>.</p> <p>For more information on Multi-AZ DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB cluster deployments</a> in the <i>Amazon RDS User Guide.</i> </p>', 'RemoveRoleFromDBInstance' => '<p>Disassociates an Amazon Web Services Identity and Access Management (IAM) role from a DB instance.</p>', 'RemoveSourceIdentifierFromSubscription' => '<p>Removes a source identifier from an existing RDS event notification subscription.</p>', 'RemoveTagsFromResource' => '<p>Removes metadata tags from an Amazon RDS resource.</p> <p>For an overview on tagging an Amazon RDS resource, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>', 'ResetDBClusterParameterGroup' => '<p>Modifies the parameters of a DB cluster parameter group to the default value. To reset specific parameters submit a list of the following: <code>ParameterName</code> and <code>ApplyMethod</code>. To reset the entire DB cluster parameter group, specify the <code>DBClusterParameterGroupName</code> and <code>ResetAllParameters</code> parameters.</p> <p>When resetting the entire group, dynamic parameters are updated immediately and static parameters are set to <code>pending-reboot</code> to take effect on the next DB instance restart or <code>RebootDBInstance</code> request. You must call <code>RebootDBInstance</code> for every DB instance in your DB cluster that you want the updated static parameter to apply to.</p> <p>For more information on Amazon Aurora DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon Aurora?</a> in the <i>Amazon Aurora User Guide</i>.</p> <p>For more information on Multi-AZ DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB cluster deployments</a> in the <i>Amazon RDS User Guide.</i> </p>', 'ResetDBParameterGroup' => '<p>Modifies the parameters of a DB parameter group to the engine/system default value. To reset specific parameters, provide a list of the following: <code>ParameterName</code> and <code>ApplyMethod</code>. To reset the entire DB parameter group, specify the <code>DBParameterGroup</code> name and <code>ResetAllParameters</code> parameters. When resetting the entire group, dynamic parameters are updated immediately and static parameters are set to <code>pending-reboot</code> to take effect on the next DB instance restart or <code>RebootDBInstance</code> request.</p>', 'RestoreDBClusterFromS3' => '<p>Creates an Amazon Aurora DB cluster from MySQL data stored in an Amazon S3 bucket. Amazon RDS must be authorized to access the Amazon S3 bucket and the data must be created using the Percona XtraBackup utility as described in <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Migrating.ExtMySQL.html#AuroraMySQL.Migrating.ExtMySQL.S3"> Migrating Data from MySQL by Using an Amazon S3 Bucket</a> in the <i>Amazon Aurora User Guide</i>.</p> <note> <p>This operation only restores the DB cluster, not the DB instances for that DB cluster. You must invoke the <code>CreateDBInstance</code> operation to create DB instances for the restored DB cluster, specifying the identifier of the restored DB cluster in <code>DBClusterIdentifier</code>. You can create DB instances only after the <code>RestoreDBClusterFromS3</code> operation has completed and the DB cluster is available.</p> </note> <p>For more information on Amazon Aurora, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon Aurora?</a> in the <i>Amazon Aurora User Guide</i>.</p> <note> <p>This operation only applies to Aurora DB clusters. The source DB engine must be MySQL.</p> </note>', 'RestoreDBClusterFromSnapshot' => '<p>Creates a new DB cluster from a DB snapshot or DB cluster snapshot.</p> <p>The target DB cluster is created from the source snapshot with a default configuration. If you don\'t specify a security group, the new DB cluster is associated with the default security group.</p> <note> <p>This operation only restores the DB cluster, not the DB instances for that DB cluster. You must invoke the <code>CreateDBInstance</code> operation to create DB instances for the restored DB cluster, specifying the identifier of the restored DB cluster in <code>DBClusterIdentifier</code>. You can create DB instances only after the <code>RestoreDBClusterFromSnapshot</code> operation has completed and the DB cluster is available.</p> </note> <p>For more information on Amazon Aurora DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon Aurora?</a> in the <i>Amazon Aurora User Guide</i>.</p> <p>For more information on Multi-AZ DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB cluster deployments</a> in the <i>Amazon RDS User Guide.</i> </p>', 'RestoreDBClusterToPointInTime' => '<p>Restores a DB cluster to an arbitrary point in time. Users can restore to any point in time before <code>LatestRestorableTime</code> for up to <code>BackupRetentionPeriod</code> days. The target DB cluster is created from the source DB cluster with the same configuration as the original DB cluster, except that the new DB cluster is created with the default DB security group.</p> <note> <p>For Aurora, this operation only restores the DB cluster, not the DB instances for that DB cluster. You must invoke the <code>CreateDBInstance</code> operation to create DB instances for the restored DB cluster, specifying the identifier of the restored DB cluster in <code>DBClusterIdentifier</code>. You can create DB instances only after the <code>RestoreDBClusterToPointInTime</code> operation has completed and the DB cluster is available.</p> </note> <p>For more information on Amazon Aurora DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon Aurora?</a> in the <i>Amazon Aurora User Guide</i>.</p> <p>For more information on Multi-AZ DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB cluster deployments</a> in the <i>Amazon RDS User Guide.</i> </p>', 'RestoreDBInstanceFromDBSnapshot' => '<p>Creates a new DB instance from a DB snapshot. The target database is created from the source database restore point with most of the source\'s original configuration, including the default security group and DB parameter group. By default, the new DB instance is created as a Single-AZ deployment, except when the instance is a SQL Server instance that has an option group associated with mirroring. In this case, the instance becomes a Multi-AZ deployment, not a Single-AZ deployment.</p> <p>If you want to replace your original DB instance with the new, restored DB instance, then rename your original DB instance before you call the <code>RestoreDBInstanceFromDBSnapshot</code> operation. RDS doesn\'t allow two DB instances with the same name. After you have renamed your original DB instance with a different identifier, then you can pass the original name of the DB instance as the <code>DBInstanceIdentifier</code> in the call to the <code>RestoreDBInstanceFromDBSnapshot</code> operation. The result is that you replace the original DB instance with the DB instance created from the snapshot.</p> <p>If you are restoring from a shared manual DB snapshot, the <code>DBSnapshotIdentifier</code> must be the ARN of the shared DB snapshot.</p> <note> <p>This command doesn\'t apply to Aurora MySQL and Aurora PostgreSQL. For Aurora, use <code>RestoreDBClusterFromSnapshot</code>.</p> </note>', 'RestoreDBInstanceFromS3' => '<p>Amazon Relational Database Service (Amazon RDS) supports importing MySQL databases by using backup files. You can create a backup of your on-premises database, store it on Amazon Simple Storage Service (Amazon S3), and then restore the backup file onto a new Amazon RDS DB instance running MySQL. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/MySQL.Procedural.Importing.html">Importing Data into an Amazon RDS MySQL DB Instance</a> in the <i>Amazon RDS User Guide.</i> </p> <p>This operation doesn\'t apply to RDS Custom.</p>', 'RestoreDBInstanceToPointInTime' => '<p>Restores a DB instance to an arbitrary point in time. You can restore to any point in time before the time identified by the <code>LatestRestorableTime</code> property. You can restore to a point up to the number of days specified by the <code>BackupRetentionPeriod</code> property.</p> <p>The target database is created with most of the original configuration, but in a system-selected Availability Zone, with the default security group, the default subnet group, and the default DB parameter group. By default, the new DB instance is created as a single-AZ deployment except when the instance is a SQL Server instance that has an option group that is associated with mirroring; in this case, the instance becomes a mirrored deployment and not a single-AZ deployment.</p> <note> <p>This operation doesn\'t apply to Aurora MySQL and Aurora PostgreSQL. For Aurora, use <code>RestoreDBClusterToPointInTime</code>.</p> </note>', 'RevokeDBSecurityGroupIngress' => '<p>Revokes ingress from a DBSecurityGroup for previously authorized IP ranges or EC2 or VPC security groups. Required parameters for this API are one of CIDRIP, EC2SecurityGroupId for VPC, or (EC2SecurityGroupOwnerId and either EC2SecurityGroupName or EC2SecurityGroupId).</p> <note> <p>EC2-Classic was retired on August 15, 2022. If you haven\'t migrated from EC2-Classic to a VPC, we recommend that you migrate as soon as possible. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-migrate.html">Migrate from EC2-Classic to a VPC</a> in the <i>Amazon EC2 User Guide</i>, the blog <a href="http://aws.amazon.com/blogs/aws/ec2-classic-is-retiring-heres-how-to-prepare/">EC2-Classic Networking is Retiring – Here’s How to Prepare</a>, and <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.Non-VPC2VPC.html">Moving a DB instance not in a VPC into a VPC</a> in the <i>Amazon RDS User Guide</i>.</p> </note>', 'StartActivityStream' => '<p>Starts a database activity stream to monitor activity on the database. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/DBActivityStreams.html"> Monitoring Amazon Aurora with Database Activity Streams</a> in the <i>Amazon Aurora User Guide</i> or <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/DBActivityStreams.html"> Monitoring Amazon RDS with Database Activity Streams</a> in the <i>Amazon RDS User Guide</i>.</p>', 'StartDBCluster' => '<p>Starts an Amazon Aurora DB cluster that was stopped using the Amazon Web Services console, the stop-db-cluster CLI command, or the <code>StopDBCluster</code> operation.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-cluster-stop-start.html"> Stopping and Starting an Aurora Cluster</a> in the <i>Amazon Aurora User Guide</i>.</p> <note> <p>This operation only applies to Aurora DB clusters.</p> </note>', 'StartDBInstance' => '<p>Starts an Amazon RDS DB instance that was stopped using the Amazon Web Services console, the stop-db-instance CLI command, or the <code>StopDBInstance</code> operation.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_StartInstance.html"> Starting an Amazon RDS DB instance That Was Previously Stopped</a> in the <i>Amazon RDS User Guide.</i> </p> <note> <p>This command doesn\'t apply to RDS Custom, Aurora MySQL, and Aurora PostgreSQL. For Aurora DB clusters, use <code>StartDBCluster</code> instead.</p> </note>', 'StartDBInstanceAutomatedBackupsReplication' => '<p>Enables replication of automated backups to a different Amazon Web Services Region.</p> <p>This command doesn\'t apply to RDS Custom.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_ReplicateBackups.html"> Replicating Automated Backups to Another Amazon Web Services Region</a> in the <i>Amazon RDS User Guide.</i> </p>', 'StartExportTask' => '<p>Starts an export of DB snapshot or DB cluster data to Amazon S3. The provided IAM role must have access to the S3 bucket.</p> <p>You can\'t export snapshot data from Db2 or RDS Custom DB instances.</p> <p>For more information on exporting DB snapshot data, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_ExportSnapshot.html">Exporting DB snapshot data to Amazon S3</a> in the <i>Amazon RDS User Guide</i> or <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-export-snapshot.html">Exporting DB cluster snapshot data to Amazon S3</a> in the <i>Amazon Aurora User Guide</i>.</p> <p>For more information on exporting DB cluster data, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/export-cluster-data.html">Exporting DB cluster data to Amazon S3</a> in the <i>Amazon Aurora User Guide</i>.</p>', 'StopActivityStream' => '<p>Stops a database activity stream that was started using the Amazon Web Services console, the <code>start-activity-stream</code> CLI command, or the <code>StartActivityStream</code> operation.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/DBActivityStreams.html"> Monitoring Amazon Aurora with Database Activity Streams</a> in the <i>Amazon Aurora User Guide</i> or <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/DBActivityStreams.html"> Monitoring Amazon RDS with Database Activity Streams</a> in the <i>Amazon RDS User Guide</i>.</p>', 'StopDBCluster' => '<p>Stops an Amazon Aurora DB cluster. When you stop a DB cluster, Aurora retains the DB cluster\'s metadata, including its endpoints and DB parameter groups. Aurora also retains the transaction logs so you can do a point-in-time restore if necessary.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-cluster-stop-start.html"> Stopping and Starting an Aurora Cluster</a> in the <i>Amazon Aurora User Guide</i>.</p> <note> <p>This operation only applies to Aurora DB clusters.</p> </note>', 'StopDBInstance' => '<p>Stops an Amazon RDS DB instance. When you stop a DB instance, Amazon RDS retains the DB instance\'s metadata, including its endpoint, DB parameter group, and option group membership. Amazon RDS also retains the transaction logs so you can do a point-in-time restore if necessary.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_StopInstance.html"> Stopping an Amazon RDS DB Instance Temporarily</a> in the <i>Amazon RDS User Guide.</i> </p> <note> <p>This command doesn\'t apply to RDS Custom, Aurora MySQL, and Aurora PostgreSQL. For Aurora clusters, use <code>StopDBCluster</code> instead.</p> </note>', 'StopDBInstanceAutomatedBackupsReplication' => '<p>Stops automated backup replication for a DB instance.</p> <p>This command doesn\'t apply to RDS Custom, Aurora MySQL, and Aurora PostgreSQL.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_ReplicateBackups.html"> Replicating Automated Backups to Another Amazon Web Services Region</a> in the <i>Amazon RDS User Guide.</i> </p>', 'SwitchoverBlueGreenDeployment' => '<p>Switches over a blue/green deployment.</p> <p>Before you switch over, production traffic is routed to the databases in the blue environment. After you switch over, production traffic is routed to the databases in the green environment.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/blue-green-deployments.html">Using Amazon RDS Blue/Green Deployments for database updates</a> in the <i>Amazon RDS User Guide</i> and <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/blue-green-deployments.html">Using Amazon RDS Blue/Green Deployments for database updates</a> in the <i>Amazon Aurora User Guide</i>.</p>', 'SwitchoverGlobalCluster' => '<p>Switches over the specified secondary DB cluster to be the new primary DB cluster in the global database cluster. Switchover operations were previously called "managed planned failovers."</p> <p>Aurora promotes the specified secondary cluster to assume full read/write capabilities and demotes the current primary cluster to a secondary (read-only) cluster, maintaining the orginal replication topology. All secondary clusters are synchronized with the primary at the beginning of the process so the new primary continues operations for the Aurora global database without losing any data. Your database is unavailable for a short time while the primary and selected secondary clusters are assuming their new roles. For more information about switching over an Aurora global database, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database-disaster-recovery.html#aurora-global-database-disaster-recovery.managed-failover">Performing switchovers for Amazon Aurora global databases</a> in the <i>Amazon Aurora User Guide</i>.</p> <note> <p>This operation is intended for controlled environments, for operations such as "regional rotation" or to fall back to the original primary after a global database failover.</p> </note>', 'SwitchoverReadReplica' => '<p>Switches over an Oracle standby database in an Oracle Data Guard environment, making it the new primary database. Issue this command in the Region that hosts the current standby database.</p>', ], 'shapes' => [ 'AccountAttributesMessage' => [ 'base' => '<p>Data returned by the <b>DescribeAccountAttributes</b> action.</p>', 'refs' => [], ], 'AccountQuota' => [ 'base' => '<p>Describes a quota for an Amazon Web Services account.</p> <p>The following are account quotas:</p> <ul> <li> <p> <code>AllocatedStorage</code> - The total allocated storage per account, in GiB. The used value is the total allocated storage in the account, in GiB.</p> </li> <li> <p> <code>AuthorizationsPerDBSecurityGroup</code> - The number of ingress rules per DB security group. The used value is the highest number of ingress rules in a DB security group in the account. Other DB security groups in the account might have a lower number of ingress rules.</p> </li> <li> <p> <code>CustomEndpointsPerDBCluster</code> - The number of custom endpoints per DB cluster. The used value is the highest number of custom endpoints in a DB clusters in the account. Other DB clusters in the account might have a lower number of custom endpoints.</p> </li> <li> <p> <code>DBClusterParameterGroups</code> - The number of DB cluster parameter groups per account, excluding default parameter groups. The used value is the count of nondefault DB cluster parameter groups in the account.</p> </li> <li> <p> <code>DBClusterRoles</code> - The number of associated Amazon Web Services Identity and Access Management (IAM) roles per DB cluster. The used value is the highest number of associated IAM roles for a DB cluster in the account. Other DB clusters in the account might have a lower number of associated IAM roles.</p> </li> <li> <p> <code>DBClusters</code> - The number of DB clusters per account. The used value is the count of DB clusters in the account.</p> </li> <li> <p> <code>DBInstanceRoles</code> - The number of associated IAM roles per DB instance. The used value is the highest number of associated IAM roles for a DB instance in the account. Other DB instances in the account might have a lower number of associated IAM roles.</p> </li> <li> <p> <code>DBInstances</code> - The number of DB instances per account. The used value is the count of the DB instances in the account.</p> <p>Amazon RDS DB instances, Amazon Aurora DB instances, Amazon Neptune instances, and Amazon DocumentDB instances apply to this quota.</p> </li> <li> <p> <code>DBParameterGroups</code> - The number of DB parameter groups per account, excluding default parameter groups. The used value is the count of nondefault DB parameter groups in the account.</p> </li> <li> <p> <code>DBSecurityGroups</code> - The number of DB security groups (not VPC security groups) per account, excluding the default security group. The used value is the count of nondefault DB security groups in the account.</p> </li> <li> <p> <code>DBSubnetGroups</code> - The number of DB subnet groups per account. The used value is the count of the DB subnet groups in the account.</p> </li> <li> <p> <code>EventSubscriptions</code> - The number of event subscriptions per account. The used value is the count of the event subscriptions in the account.</p> </li> <li> <p> <code>ManualClusterSnapshots</code> - The number of manual DB cluster snapshots per account. The used value is the count of the manual DB cluster snapshots in the account.</p> </li> <li> <p> <code>ManualSnapshots</code> - The number of manual DB instance snapshots per account. The used value is the count of the manual DB instance snapshots in the account.</p> </li> <li> <p> <code>OptionGroups</code> - The number of DB option groups per account, excluding default option groups. The used value is the count of nondefault DB option groups in the account.</p> </li> <li> <p> <code>ReadReplicasPerMaster</code> - The number of read replicas per DB instance. The used value is the highest number of read replicas for a DB instance in the account. Other DB instances in the account might have a lower number of read replicas.</p> </li> <li> <p> <code>ReservedDBInstances</code> - The number of reserved DB instances per account. The used value is the count of the active reserved DB instances in the account.</p> </li> <li> <p> <code>SubnetsPerDBSubnetGroup</code> - The number of subnets per DB subnet group. The used value is highest number of subnets for a DB subnet group in the account. Other DB subnet groups in the account might have a lower number of subnets.</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Limits.html">Quotas for Amazon RDS</a> in the <i>Amazon RDS User Guide</i> and <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_Limits.html">Quotas for Amazon Aurora</a> in the <i>Amazon Aurora User Guide</i>.</p>', 'refs' => [ 'AccountQuotaList$member' => NULL, ], ], 'AccountQuotaList' => [ 'base' => NULL, 'refs' => [ 'AccountAttributesMessage$AccountQuotas' => '<p>A list of <code>AccountQuota</code> objects. Within this list, each quota has a name, a count of usage toward the quota maximum, and a maximum value for the quota.</p>', ], ], 'ActivityStreamMode' => [ 'base' => NULL, 'refs' => [ 'DBCluster$ActivityStreamMode' => '<p>The mode of the database activity stream. Database events such as a change or access generate an activity stream event. The database session can handle these events either synchronously or asynchronously.</p>', 'DBInstance$ActivityStreamMode' => '<p>The mode of the database activity stream. Database events such as a change or access generate an activity stream event. RDS for Oracle always handles these events asynchronously.</p>', 'ModifyActivityStreamResponse$Mode' => '<p>The mode of the database activity stream.</p>', 'StartActivityStreamRequest$Mode' => '<p>Specifies the mode of the database activity stream. Database events such as a change or access generate an activity stream event. The database session can handle these events either synchronously or asynchronously.</p>', 'StartActivityStreamResponse$Mode' => '<p>The mode of the database activity stream.</p>', ], ], 'ActivityStreamModeList' => [ 'base' => NULL, 'refs' => [ 'OrderableDBInstanceOption$SupportedActivityStreamModes' => '<p>The list of supported modes for Database Activity Streams. Aurora PostgreSQL returns the value <code>[sync, async]</code>. Aurora MySQL and RDS for Oracle return <code>[async]</code> only. If Database Activity Streams isn\'t supported, the return value is an empty list.</p>', ], ], 'ActivityStreamPolicyStatus' => [ 'base' => NULL, 'refs' => [ 'DBInstance$ActivityStreamPolicyStatus' => '<p>The status of the policy state of the activity stream.</p>', 'ModifyActivityStreamResponse$PolicyStatus' => '<p>The status of the modification to the policy state of the database activity stream.</p>', ], ], 'ActivityStreamStatus' => [ 'base' => NULL, 'refs' => [ 'DBCluster$ActivityStreamStatus' => '<p>The status of the database activity stream.</p>', 'DBInstance$ActivityStreamStatus' => '<p>The status of the database activity stream.</p>', 'ModifyActivityStreamResponse$Status' => '<p>The status of the modification to the database activity stream.</p>', 'StartActivityStreamResponse$Status' => '<p>The status of the database activity stream.</p>', 'StopActivityStreamResponse$Status' => '<p>The status of the database activity stream.</p>', ], ], 'AddRoleToDBClusterMessage' => [ 'base' => NULL, 'refs' => [], ], 'AddRoleToDBInstanceMessage' => [ 'base' => NULL, 'refs' => [], ], 'AddSourceIdentifierToSubscriptionMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'AddSourceIdentifierToSubscriptionResult' => [ 'base' => NULL, 'refs' => [], ], 'AddTagsToResourceMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'ApplyMethod' => [ 'base' => NULL, 'refs' => [ 'Parameter$ApplyMethod' => '<p>Indicates when to apply parameter updates.</p>', ], ], 'ApplyPendingMaintenanceActionMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'ApplyPendingMaintenanceActionResult' => [ 'base' => NULL, 'refs' => [], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'CreateIntegrationMessage$TargetArn' => '<p>The ARN of the Redshift data warehouse to use as the target for replication.</p>', 'Integration$TargetArn' => '<p>The ARN of the Redshift data warehouse used as the target for replication.</p>', ], ], 'AttributeValueList' => [ 'base' => NULL, 'refs' => [ 'DBClusterSnapshotAttribute$AttributeValues' => '<p>The value(s) for the manual DB cluster snapshot attribute.</p> <p>If the <code>AttributeName</code> field is set to <code>restore</code>, then this element returns a list of IDs of the Amazon Web Services accounts that are authorized to copy or restore the manual DB cluster snapshot. If a value of <code>all</code> is in the list, then the manual DB cluster snapshot is public and available for any Amazon Web Services account to copy or restore.</p>', 'DBSnapshotAttribute$AttributeValues' => '<p>The value or values for the manual DB snapshot attribute.</p> <p>If the <code>AttributeName</code> field is set to <code>restore</code>, then this element returns a list of IDs of the Amazon Web Services accounts that are authorized to copy or restore the manual DB snapshot. If a value of <code>all</code> is in the list, then the manual DB snapshot is public and available for any Amazon Web Services account to copy or restore.</p>', 'ModifyDBClusterSnapshotAttributeMessage$ValuesToAdd' => '<p>A list of DB cluster snapshot attributes to add to the attribute specified by <code>AttributeName</code>.</p> <p>To authorize other Amazon Web Services accounts to copy or restore a manual DB cluster snapshot, set this list to include one or more Amazon Web Services account IDs, or <code>all</code> to make the manual DB cluster snapshot restorable by any Amazon Web Services account. Do not add the <code>all</code> value for any manual DB cluster snapshots that contain private information that you don\'t want available to all Amazon Web Services accounts.</p>', 'ModifyDBClusterSnapshotAttributeMessage$ValuesToRemove' => '<p>A list of DB cluster snapshot attributes to remove from the attribute specified by <code>AttributeName</code>.</p> <p>To remove authorization for other Amazon Web Services accounts to copy or restore a manual DB cluster snapshot, set this list to include one or more Amazon Web Services account identifiers, or <code>all</code> to remove authorization for any Amazon Web Services account to copy or restore the DB cluster snapshot. If you specify <code>all</code>, an Amazon Web Services account whose account ID is explicitly added to the <code>restore</code> attribute can still copy or restore a manual DB cluster snapshot.</p>', 'ModifyDBSnapshotAttributeMessage$ValuesToAdd' => '<p>A list of DB snapshot attributes to add to the attribute specified by <code>AttributeName</code>.</p> <p>To authorize other Amazon Web Services accounts to copy or restore a manual snapshot, set this list to include one or more Amazon Web Services account IDs, or <code>all</code> to make the manual DB snapshot restorable by any Amazon Web Services account. Do not add the <code>all</code> value for any manual DB snapshots that contain private information that you don\'t want available to all Amazon Web Services accounts.</p>', 'ModifyDBSnapshotAttributeMessage$ValuesToRemove' => '<p>A list of DB snapshot attributes to remove from the attribute specified by <code>AttributeName</code>.</p> <p>To remove authorization for other Amazon Web Services accounts to copy or restore a manual snapshot, set this list to include one or more Amazon Web Services account identifiers, or <code>all</code> to remove authorization for any Amazon Web Services account to copy or restore the DB snapshot. If you specify <code>all</code>, an Amazon Web Services account whose account ID is explicitly added to the <code>restore</code> attribute can still copy or restore the manual DB snapshot.</p>', ], ], 'AuditPolicyState' => [ 'base' => NULL, 'refs' => [ 'ModifyActivityStreamRequest$AuditPolicyState' => '<p>The audit policy state. When a policy is unlocked, it is read/write. When it is locked, it is read-only. You can edit your audit policy only when the activity stream is unlocked or stopped.</p>', ], ], 'AuthScheme' => [ 'base' => NULL, 'refs' => [ 'UserAuthConfig$AuthScheme' => '<p>The type of authentication that the proxy uses for connections from the proxy to the underlying database.</p>', 'UserAuthConfigInfo$AuthScheme' => '<p>The type of authentication that the proxy uses for connections from the proxy to the underlying database.</p>', ], ], 'AuthorizationAlreadyExistsFault' => [ 'base' => '<p>The specified CIDR IP range or Amazon EC2 security group is already authorized for the specified DB security group.</p>', 'refs' => [], ], 'AuthorizationNotFoundFault' => [ 'base' => '<p>The specified CIDR IP range or Amazon EC2 security group might not be authorized for the specified DB security group.</p> <p>Or, RDS might not be authorized to perform necessary actions using IAM on your behalf.</p>', 'refs' => [], ], 'AuthorizationQuotaExceededFault' => [ 'base' => '<p>The DB security group authorization quota has been reached.</p>', 'refs' => [], ], 'AuthorizeDBSecurityGroupIngressMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'AuthorizeDBSecurityGroupIngressResult' => [ 'base' => NULL, 'refs' => [], ], 'AutomationMode' => [ 'base' => NULL, 'refs' => [ 'DBInstance$AutomationMode' => '<p>The automation mode of the RDS Custom DB instance: <code>full</code> or <code>all paused</code>. If <code>full</code>, the DB instance automates monitoring and instance recovery. If <code>all paused</code>, the instance pauses automation for the duration set by <code>--resume-full-automation-mode-minutes</code>.</p>', 'ModifyDBInstanceMessage$AutomationMode' => '<p>The automation mode of the RDS Custom DB instance. If <code>full</code>, the DB instance automates monitoring and instance recovery. If <code>all paused</code>, the instance pauses automation for the duration set by <code>ResumeFullAutomationModeMinutes</code>.</p>', 'PendingModifiedValues$AutomationMode' => '<p>The automation mode of the RDS Custom DB instance: <code>full</code> or <code>all-paused</code>. If <code>full</code>, the DB instance automates monitoring and instance recovery. If <code>all-paused</code>, the instance pauses automation for the duration set by <code>--resume-full-automation-mode-minutes</code>.</p>', ], ], 'AvailabilityZone' => [ 'base' => '<p>Contains Availability Zone information.</p> <p>This data type is used as an element in the <code>OrderableDBInstanceOption</code> data type.</p>', 'refs' => [ 'AvailabilityZoneList$member' => NULL, 'Subnet$SubnetAvailabilityZone' => NULL, ], ], 'AvailabilityZoneList' => [ 'base' => NULL, 'refs' => [ 'OrderableDBInstanceOption$AvailabilityZones' => '<p>A list of Availability Zones for a DB instance.</p>', ], ], 'AvailabilityZones' => [ 'base' => NULL, 'refs' => [ 'CreateDBClusterMessage$AvailabilityZones' => '<p>A list of Availability Zones (AZs) where you specifically want to create DB instances in the DB cluster.</p> <p>For information on AZs, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.RegionsAndAvailabilityZones.html#Concepts.RegionsAndAvailabilityZones.AvailabilityZones">Availability Zones</a> in the <i>Amazon Aurora User Guide</i>.</p> <p>Valid for Cluster Type: Aurora DB clusters only</p> <p>Constraints:</p> <ul> <li> <p>Can\'t specify more than three AZs.</p> </li> </ul>', 'DBCluster$AvailabilityZones' => '<p>The list of Availability Zones (AZs) where instances in the DB cluster can be created.</p>', 'DBClusterAutomatedBackup$AvailabilityZones' => '<p>The Availability Zones where instances in the DB cluster can be created. For information on Amazon Web Services Regions and Availability Zones, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.RegionsAndAvailabilityZones.html">Regions and Availability Zones</a>.</p>', 'DBClusterSnapshot$AvailabilityZones' => '<p>The list of Availability Zones (AZs) where instances in the DB cluster snapshot can be restored.</p>', 'RestoreDBClusterFromS3Message$AvailabilityZones' => '<p>A list of Availability Zones (AZs) where instances in the restored DB cluster can be created.</p>', 'RestoreDBClusterFromSnapshotMessage$AvailabilityZones' => '<p>Provides the list of Availability Zones (AZs) where instances in the restored DB cluster can be created.</p> <p>Valid for: Aurora DB clusters only</p>', ], ], 'AvailableProcessorFeature' => [ 'base' => '<p>Contains the available processor feature information for the DB instance class of a DB instance.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html#USER_ConfigureProcessor">Configuring the Processor of the DB Instance Class</a> in the <i>Amazon RDS User Guide. </i> </p>', 'refs' => [ 'AvailableProcessorFeatureList$member' => NULL, ], ], 'AvailableProcessorFeatureList' => [ 'base' => NULL, 'refs' => [ 'OrderableDBInstanceOption$AvailableProcessorFeatures' => '<p>A list of the available processor features for the DB instance class of a DB instance.</p>', 'ValidDBInstanceModificationsMessage$ValidProcessorFeatures' => '<p>Valid processor features for your DB instance.</p>', ], ], 'AwsBackupRecoveryPointArn' => [ 'base' => NULL, 'refs' => [ 'ModifyDBClusterMessage$AwsBackupRecoveryPointArn' => '<p>The Amazon Resource Name (ARN) of the recovery point in Amazon Web Services Backup.</p>', 'ModifyDBInstanceMessage$AwsBackupRecoveryPointArn' => '<p>The Amazon Resource Name (ARN) of the recovery point in Amazon Web Services Backup.</p> <p>This setting doesn\'t apply to RDS Custom DB instances.</p>', ], ], 'BacktrackDBClusterMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'BackupPolicyNotFoundFault' => [ 'base' => NULL, 'refs' => [], ], 'BlueGreenDeployment' => [ 'base' => '<p>Details about a blue/green deployment.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/blue-green-deployments.html">Using Amazon RDS Blue/Green Deployments for database updates</a> in the <i>Amazon RDS User Guide</i> and <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/blue-green-deployments.html">Using Amazon RDS Blue/Green Deployments for database updates</a> in the <i>Amazon Aurora User Guide</i>.</p>', 'refs' => [ 'BlueGreenDeploymentList$member' => NULL, 'CreateBlueGreenDeploymentResponse$BlueGreenDeployment' => NULL, 'DeleteBlueGreenDeploymentResponse$BlueGreenDeployment' => NULL, 'SwitchoverBlueGreenDeploymentResponse$BlueGreenDeployment' => NULL, ], ], 'BlueGreenDeploymentAlreadyExistsFault' => [ 'base' => '<p>A blue/green deployment with the specified name already exists.</p>', 'refs' => [], ], 'BlueGreenDeploymentIdentifier' => [ 'base' => NULL, 'refs' => [ 'BlueGreenDeployment$BlueGreenDeploymentIdentifier' => '<p>The unique identifier of the blue/green deployment.</p>', 'DeleteBlueGreenDeploymentRequest$BlueGreenDeploymentIdentifier' => '<p>The unique identifier of the blue/green deployment to delete. This parameter isn\'t case-sensitive.</p> <p>Constraints: </p> <ul> <li> <p>Must match an existing blue/green deployment identifier.</p> </li> </ul>', 'DescribeBlueGreenDeploymentsRequest$BlueGreenDeploymentIdentifier' => '<p>The blue/green deployment identifier. If you specify this parameter, the response only includes information about the specific blue/green deployment. This parameter isn\'t case-sensitive.</p> <p>Constraints:</p> <ul> <li> <p>Must match an existing blue/green deployment identifier.</p> </li> </ul>', 'SwitchoverBlueGreenDeploymentRequest$BlueGreenDeploymentIdentifier' => '<p>The unique identifier of the blue/green deployment.</p> <p>Constraints:</p> <ul> <li> <p>Must match an existing blue/green deployment identifier.</p> </li> </ul>', ], ], 'BlueGreenDeploymentList' => [ 'base' => NULL, 'refs' => [ 'DescribeBlueGreenDeploymentsResponse$BlueGreenDeployments' => '<p>A list of blue/green deployments in the current account and Amazon Web Services Region.</p>', ], ], 'BlueGreenDeploymentName' => [ 'base' => NULL, 'refs' => [ 'BlueGreenDeployment$BlueGreenDeploymentName' => '<p>The user-supplied name of the blue/green deployment.</p>', 'CreateBlueGreenDeploymentRequest$BlueGreenDeploymentName' => '<p>The name of the blue/green deployment.</p> <p>Constraints:</p> <ul> <li> <p>Can\'t be the same as an existing blue/green deployment name in the same account and Amazon Web Services Region.</p> </li> </ul>', ], ], 'BlueGreenDeploymentNotFoundFault' => [ 'base' => '<p> <code>BlueGreenDeploymentIdentifier</code> doesn\'t refer to an existing blue/green deployment.</p>', 'refs' => [], ], 'BlueGreenDeploymentStatus' => [ 'base' => NULL, 'refs' => [ 'BlueGreenDeployment$Status' => '<p>The status of the blue/green deployment.</p> <p>Valid Values:</p> <ul> <li> <p> <code>PROVISIONING</code> - Resources are being created in the green environment.</p> </li> <li> <p> <code>AVAILABLE</code> - Resources are available in the green environment.</p> </li> <li> <p> <code>SWITCHOVER_IN_PROGRESS</code> - The deployment is being switched from the blue environment to the green environment.</p> </li> <li> <p> <code>SWITCHOVER_COMPLETED</code> - Switchover from the blue environment to the green environment is complete.</p> </li> <li> <p> <code>INVALID_CONFIGURATION</code> - Resources in the green environment are invalid, so switchover isn\'t possible.</p> </li> <li> <p> <code>SWITCHOVER_FAILED</code> - Switchover was attempted but failed.</p> </li> <li> <p> <code>DELETING</code> - The blue/green deployment is being deleted.</p> </li> </ul>', ], ], 'BlueGreenDeploymentStatusDetails' => [ 'base' => NULL, 'refs' => [ 'BlueGreenDeployment$StatusDetails' => '<p>Additional information about the status of the blue/green deployment.</p>', ], ], 'BlueGreenDeploymentTask' => [ 'base' => '<p>Details about a task for a blue/green deployment.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/blue-green-deployments.html">Using Amazon RDS Blue/Green Deployments for database updates</a> in the <i>Amazon RDS User Guide</i> and <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/blue-green-deployments.html">Using Amazon RDS Blue/Green Deployments for database updates</a> in the <i>Amazon Aurora User Guide</i>.</p>', 'refs' => [ 'BlueGreenDeploymentTaskList$member' => NULL, ], ], 'BlueGreenDeploymentTaskList' => [ 'base' => NULL, 'refs' => [ 'BlueGreenDeployment$Tasks' => '<p>Either tasks to be performed or tasks that have been completed on the target database before switchover.</p>', ], ], 'BlueGreenDeploymentTaskName' => [ 'base' => NULL, 'refs' => [ 'BlueGreenDeploymentTask$Name' => '<p>The name of the blue/green deployment task.</p>', ], ], 'BlueGreenDeploymentTaskStatus' => [ 'base' => NULL, 'refs' => [ 'BlueGreenDeploymentTask$Status' => '<p>The status of the blue/green deployment task.</p> <p>Valid Values:</p> <ul> <li> <p> <code>PENDING</code> - The resource is being prepared for deployment.</p> </li> <li> <p> <code>IN_PROGRESS</code> - The resource is being deployed.</p> </li> <li> <p> <code>COMPLETED</code> - The resource has been deployed.</p> </li> <li> <p> <code>FAILED</code> - Deployment of the resource failed.</p> </li> </ul>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'CreateDBProxyRequest$RequireTLS' => '<p>Specifies whether Transport Layer Security (TLS) encryption is required for connections to the proxy. By enabling this setting, you can enforce encrypted TLS connections to the proxy.</p>', 'CreateDBProxyRequest$DebugLogging' => '<p>Specifies whether the proxy includes detailed information about SQL statements in its logs. This information helps you to debug issues involving SQL behavior or the performance and scalability of the proxy connections. The debug information includes the text of SQL statements that you submit through the proxy. Thus, only enable this setting when needed for debugging, and only when you have security measures in place to safeguard any sensitive information that appears in the logs.</p>', 'DBCluster$StorageEncrypted' => '<p>Indicates whether the DB cluster is encrypted.</p>', 'DBCluster$AutoMinorVersionUpgrade' => '<p>Indicates whether minor version patches are applied automatically.</p> <p>This setting is only for non-Aurora Multi-AZ DB clusters.</p>', 'DBClusterAutomatedBackup$IAMDatabaseAuthenticationEnabled' => '<p>Indicates whether mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is enabled.</p>', 'DBClusterAutomatedBackup$StorageEncrypted' => '<p>Indicates whether the source DB cluster is encrypted.</p>', 'DBClusterMember$IsClusterWriter' => '<p>Indicates whether the cluster member is the primary DB instance for the DB cluster.</p>', 'DBClusterSnapshot$StorageEncrypted' => '<p>Indicates whether the DB cluster snapshot is encrypted.</p>', 'DBClusterSnapshot$IAMDatabaseAuthenticationEnabled' => '<p>Indicates whether mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is enabled.</p>', 'DBClusterStatusInfo$Normal' => '<p>Reserved for future use.</p>', 'DBEngineVersion$SupportsLogExportsToCloudwatchLogs' => '<p>Indicates whether the engine version supports exporting the log types specified by ExportableLogTypes to CloudWatch Logs.</p>', 'DBEngineVersion$SupportsReadReplica' => '<p>Indicates whether the database engine version supports read replicas.</p>', 'DBEngineVersion$SupportsParallelQuery' => '<p>Indicates whether you can use Aurora parallel query with a specific DB engine version.</p>', 'DBEngineVersion$SupportsGlobalDatabases' => '<p>Indicates whether you can use Aurora global databases with a specific DB engine version.</p>', 'DBEngineVersion$SupportsBabelfish' => '<p>Indicates whether the engine version supports Babelfish for Aurora PostgreSQL.</p>', 'DBEngineVersion$SupportsLimitlessDatabase' => '<p>Indicates whether the DB engine version supports Aurora Limitless Database.</p>', 'DBEngineVersion$SupportsIntegrations' => '<p>Indicates whether the DB engine version supports zero-ETL integrations with Amazon Redshift.</p>', 'DBInstance$MultiAZ' => '<p>Indicates whether the DB instance is a Multi-AZ deployment. This setting doesn\'t apply to RDS Custom DB instances.</p>', 'DBInstance$AutoMinorVersionUpgrade' => '<p>Indicates whether minor version patches are applied automatically.</p>', 'DBInstance$PubliclyAccessible' => '<p>Indicates whether the DB instance is publicly accessible.</p> <p>When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB cluster\'s virtual private cloud (VPC). It resolves to the public IP address from outside of the DB cluster\'s VPC. Access to the DB cluster is ultimately controlled by the security group it uses. That public access isn\'t permitted if the security group assigned to the DB cluster doesn\'t permit it.</p> <p>When the DB instance isn\'t publicly accessible, it is an internal DB instance with a DNS name that resolves to a private IP address.</p> <p>For more information, see <a>CreateDBInstance</a>.</p>', 'DBInstance$StorageEncrypted' => '<p>Indicates whether the DB instance is encrypted.</p>', 'DBInstance$CopyTagsToSnapshot' => '<p>Indicates whether tags are copied from the DB instance to snapshots of the DB instance.</p> <p>This setting doesn\'t apply to Amazon Aurora DB instances. Copying tags to snapshots is managed by the DB cluster. Setting this value for an Aurora DB instance has no effect on the DB cluster setting. For more information, see <code>DBCluster</code>.</p>', 'DBInstance$IAMDatabaseAuthenticationEnabled' => '<p>Indicates whether mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is enabled for the DB instance.</p> <p>For a list of engine versions that support IAM database authentication, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RDS_Fea_Regions_DB-eng.Feature.IamDatabaseAuthentication.html">IAM database authentication</a> in the <i>Amazon RDS User Guide</i> and <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.Aurora_Fea_Regions_DB-eng.Feature.IAMdbauth.html">IAM database authentication in Aurora</a> in the <i>Amazon Aurora User Guide</i>.</p>', 'DBInstance$DeletionProtection' => '<p>Indicates whether the DB instance has deletion protection enabled. The database can\'t be deleted when deletion protection is enabled. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html"> Deleting a DB Instance</a>.</p>', 'DBInstance$DedicatedLogVolume' => '<p>Indicates whether the DB instance has a dedicated log volume (DLV) enabled.</p>', 'DBInstanceAutomatedBackup$Encrypted' => '<p>Indicates whether the automated backup is encrypted.</p>', 'DBInstanceAutomatedBackup$IAMDatabaseAuthenticationEnabled' => '<p>True if mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is enabled, and otherwise false.</p>', 'DBInstanceStatusInfo$Normal' => '<p>Indicates whether the instance is operating normally (TRUE) or is in an error state (FALSE).</p>', 'DBProxy$RequireTLS' => '<p>Indicates whether Transport Layer Security (TLS) encryption is required for connections to the proxy.</p>', 'DBProxy$DebugLogging' => '<p>Indicates whether the proxy includes detailed information about SQL statements in its logs. This information helps you to debug issues involving SQL behavior or the performance and scalability of the proxy connections. The debug information includes the text of SQL statements that you submit through the proxy. Thus, only enable this setting when needed for debugging, and only when you have security measures in place to safeguard any sensitive information that appears in the logs.</p>', 'DBProxyEndpoint$IsDefault' => '<p>Indicates whether this endpoint is the default endpoint for the associated DB proxy. Default DB proxy endpoints always have read/write capability. Other endpoints that you associate with the DB proxy can be either read/write or read-only.</p>', 'DBProxyTargetGroup$IsDefault' => '<p>Indicates whether this target group is the first one used for connection requests by the associated proxy. Because each proxy is currently associated with a single target group, currently this setting is always <code>true</code>.</p>', 'DBSnapshot$Encrypted' => '<p>Indicates whether the DB snapshot is encrypted.</p>', 'DBSnapshot$IAMDatabaseAuthenticationEnabled' => '<p>Indicates whether mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is enabled.</p>', 'DBSnapshot$DedicatedLogVolume' => '<p>Indicates whether the DB instance has a dedicated log volume (DLV) enabled.</p>', 'DeleteDBClusterMessage$SkipFinalSnapshot' => '<p>Specifies whether to skip the creation of a final DB cluster snapshot before the DB cluster is deleted. If skip is specified, no DB cluster snapshot is created. If skip isn\'t specified, a DB cluster snapshot is created before the DB cluster is deleted. By default, skip isn\'t specified, and the DB cluster snapshot is created. By default, this parameter is disabled.</p> <note> <p>You must specify a <code>FinalDBSnapshotIdentifier</code> parameter if <code>SkipFinalSnapshot</code> is disabled.</p> </note>', 'DeleteDBInstanceMessage$SkipFinalSnapshot' => '<p>Specifies whether to skip the creation of a final DB snapshot before deleting the instance. If you enable this parameter, RDS doesn\'t create a DB snapshot. If you don\'t enable this parameter, RDS creates a DB snapshot before the DB instance is deleted. By default, skip isn\'t enabled, and the DB snapshot is created.</p> <note> <p>If you don\'t enable this parameter, you must specify the <code>FinalDBSnapshotIdentifier</code> parameter.</p> </note> <p>When a DB instance is in a failure state and has a status of <code>failed</code>, <code>incompatible-restore</code>, or <code>incompatible-network</code>, RDS can delete the instance only if you enable this parameter.</p> <p>If you delete a read replica or an RDS Custom instance, you must enable this setting.</p> <p>This setting is required for RDS Custom.</p>', 'DeleteTenantDatabaseMessage$SkipFinalSnapshot' => '<p>Specifies whether to skip the creation of a final DB snapshot before removing the tenant database from your DB instance. If you enable this parameter, RDS doesn\'t create a DB snapshot. If you don\'t enable this parameter, RDS creates a DB snapshot before it deletes the tenant database. By default, RDS doesn\'t skip the final snapshot. If you don\'t enable this parameter, you must specify the <code>FinalDBSnapshotIdentifier</code> parameter.</p>', 'DescribeDBClusterSnapshotsMessage$IncludeShared' => '<p>Specifies whether to include shared manual DB cluster snapshots from other Amazon Web Services accounts that this Amazon Web Services account has been given permission to copy or restore. By default, these snapshots are not included.</p> <p>You can give an Amazon Web Services account permission to restore a manual DB cluster snapshot from another Amazon Web Services account by the <code>ModifyDBClusterSnapshotAttribute</code> API action.</p>', 'DescribeDBClusterSnapshotsMessage$IncludePublic' => '<p>Specifies whether to include manual DB cluster snapshots that are public and can be copied or restored by any Amazon Web Services account. By default, the public snapshots are not included.</p> <p>You can share a manual DB cluster snapshot as public by using the <a>ModifyDBClusterSnapshotAttribute</a> API action.</p>', 'DescribeDBClustersMessage$IncludeShared' => '<p>Specifies whether the output includes information about clusters shared from other Amazon Web Services accounts.</p>', 'DescribeDBEngineVersionsMessage$DefaultOnly' => '<p>Specifies whether to return only the default version of the specified engine or the engine and major version combination.</p>', 'DescribeDBSnapshotsMessage$IncludeShared' => '<p>Specifies whether to include shared manual DB cluster snapshots from other Amazon Web Services accounts that this Amazon Web Services account has been given permission to copy or restore. By default, these snapshots are not included.</p> <p>You can give an Amazon Web Services account permission to restore a manual DB snapshot from another Amazon Web Services account by using the <code>ModifyDBSnapshotAttribute</code> API action.</p> <p>This setting doesn\'t apply to RDS Custom.</p>', 'DescribeDBSnapshotsMessage$IncludePublic' => '<p>Specifies whether to include manual DB cluster snapshots that are public and can be copied or restored by any Amazon Web Services account. By default, the public snapshots are not included.</p> <p>You can share a manual DB snapshot as public by using the <a>ModifyDBSnapshotAttribute</a> API.</p> <p>This setting doesn\'t apply to RDS Custom.</p>', 'DisableHttpEndpointResponse$HttpEndpointEnabled' => '<p>Indicates whether the HTTP endpoint is enabled or disabled for the DB cluster.</p>', 'DownloadDBLogFilePortionDetails$AdditionalDataPending' => '<p>A Boolean value that, if true, indicates there is more data to be downloaded.</p>', 'EnableHttpEndpointResponse$HttpEndpointEnabled' => '<p>Indicates whether the HTTP endpoint is enabled or disabled for the DB cluster.</p>', 'EventSubscription$Enabled' => '<p>Specifies whether the subscription is enabled. True indicates the subscription is enabled.</p>', 'FailoverState$IsDataLossAllowed' => '<p>Indicates whether the operation is a global switchover or a global failover. If data loss is allowed, then the operation is a global failover. Otherwise, it\'s a switchover.</p>', 'GlobalClusterMember$IsWriter' => '<p>Indicates whether the Aurora DB cluster is the primary cluster (that is, has read-write capability) for the global cluster with which it is associated.</p>', 'ModifyDBClusterMessage$ApplyImmediately' => '<p>Specifies whether the modifications in this request and any pending modifications are asynchronously applied as soon as possible, regardless of the <code>PreferredMaintenanceWindow</code> setting for the DB cluster. If this parameter is disabled, changes to the DB cluster are applied during the next maintenance window.</p> <p>Most modifications can be applied immediately or during the next scheduled maintenance window. Some modifications, such as turning on deletion protection and changing the master password, are applied immediately—regardless of when you choose to apply them.</p> <p>By default, this parameter is disabled.</p> <p>Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters</p>', 'ModifyDBClusterMessage$AllowMajorVersionUpgrade' => '<p>Specifies whether major version upgrades are allowed.</p> <p>Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters</p> <p>Constraints:</p> <ul> <li> <p>You must allow major version upgrades when specifying a value for the <code>EngineVersion</code> parameter that is a different major version than the DB cluster\'s current version.</p> </li> </ul>', 'ModifyDBClusterMessage$AllowEngineModeChange' => '<p>Specifies whether engine mode changes from <code>serverless</code> to <code>provisioned</code> are allowed.</p> <p>Valid for Cluster Type: Aurora Serverless v1 DB clusters only</p> <p>Constraints:</p> <ul> <li> <p>You must allow engine mode changes when specifying a different value for the <code>EngineMode</code> parameter from the DB cluster\'s current engine mode.</p> </li> </ul>', 'ModifyDBInstanceMessage$ApplyImmediately' => '<p>Specifies whether the modifications in this request and any pending modifications are asynchronously applied as soon as possible, regardless of the <code>PreferredMaintenanceWindow</code> setting for the DB instance. By default, this parameter is disabled.</p> <p>If this parameter is disabled, changes to the DB instance are applied during the next maintenance window. Some parameter changes can cause an outage and are applied on the next call to <a>RebootDBInstance</a>, or the next failure reboot. Review the table of parameters in <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.DBInstance.Modifying.html">Modifying a DB Instance</a> in the <i>Amazon RDS User Guide</i> to see the impact of enabling or disabling <code>ApplyImmediately</code> for each modified parameter and to determine when the changes are applied.</p>', 'ModifyDBInstanceMessage$AllowMajorVersionUpgrade' => '<p>Specifies whether major version upgrades are allowed. Changing this parameter doesn\'t result in an outage and the change is asynchronously applied as soon as possible.</p> <p>This setting doesn\'t apply to RDS Custom DB instances.</p> <p>Constraints:</p> <ul> <li> <p>Major version upgrades must be allowed when specifying a value for the <code>EngineVersion</code> parameter that\'s a different major version than the DB instance\'s current version.</p> </li> </ul>', 'ModifyOptionGroupMessage$ApplyImmediately' => '<p>Specifies whether to apply the change immediately or during the next maintenance window for each instance associated with the option group.</p>', 'Option$Persistent' => '<p>Indicates whether this option is persistent.</p>', 'Option$Permanent' => '<p>Indicates whether this option is permanent.</p>', 'OptionGroup$AllowsVpcAndNonVpcInstanceMemberships' => '<p>Indicates whether this option group can be applied to both VPC and non-VPC instances. The value <code>true</code> indicates the option group can be applied to both VPC and non-VPC instances.</p>', 'OptionGroupOption$PortRequired' => '<p>Indicates whether the option requires a port.</p>', 'OptionGroupOption$Persistent' => '<p>Persistent options can\'t be removed from an option group while DB instances are associated with the option group. If you disassociate all DB instances from the option group, your can remove the persistent option from the option group.</p>', 'OptionGroupOption$Permanent' => '<p>Permanent options can never be removed from an option group. An option group containing a permanent option can\'t be removed from a DB instance.</p>', 'OptionGroupOption$RequiresAutoMinorEngineVersionUpgrade' => '<p>If true, you must enable the Auto Minor Version Upgrade setting for your DB instance before you can use this option. You can enable Auto Minor Version Upgrade when you first create your DB instance, or by modifying your DB instance later.</p>', 'OptionGroupOption$VpcOnly' => '<p>If true, you can only use this option with a DB instance that is in a VPC.</p>', 'OptionGroupOptionSetting$IsModifiable' => '<p>Indicates whether this option group option can be changed from the default value.</p>', 'OptionGroupOptionSetting$IsRequired' => '<p>Indicates whether a value must be specified for this option setting of the option group option.</p>', 'OptionSetting$IsModifiable' => '<p>Indicates whether the option setting can be modified from the default.</p>', 'OptionSetting$IsCollection' => '<p>Indicates whether the option setting is part of a collection.</p>', 'OptionVersion$IsDefault' => '<p>Indicates whether the version is the default version of the option.</p>', 'OrderableDBInstanceOption$MultiAZCapable' => '<p>Indicates whether a DB instance is Multi-AZ capable.</p>', 'OrderableDBInstanceOption$ReadReplicaCapable' => '<p>Indicates whether a DB instance can have a read replica.</p>', 'OrderableDBInstanceOption$Vpc' => '<p>Indicates whether a DB instance is in a VPC.</p>', 'OrderableDBInstanceOption$SupportsStorageEncryption' => '<p>Indicates whether a DB instance supports encrypted storage.</p>', 'OrderableDBInstanceOption$SupportsIops' => '<p>Indicates whether a DB instance supports provisioned IOPS.</p>', 'OrderableDBInstanceOption$SupportsEnhancedMonitoring' => '<p>Indicates whether a DB instance supports Enhanced Monitoring at intervals from 1 to 60 seconds.</p>', 'OrderableDBInstanceOption$SupportsIAMDatabaseAuthentication' => '<p>Indicates whether a DB instance supports IAM database authentication.</p>', 'OrderableDBInstanceOption$SupportsPerformanceInsights' => '<p>Indicates whether a DB instance supports Performance Insights.</p>', 'OrderableDBInstanceOption$OutpostCapable' => '<p>Indicates whether a DB instance supports RDS on Outposts.</p> <p>For more information about RDS on Outposts, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Amazon RDS on Amazon Web Services Outposts</a> in the <i>Amazon RDS User Guide.</i> </p>', 'OrderableDBInstanceOption$SupportsGlobalDatabases' => '<p>Indicates whether you can use Aurora global databases with a specific combination of other DB engine attributes.</p>', 'OrderableDBInstanceOption$SupportsClusters' => '<p>Indicates whether DB instances can be configured as a Multi-AZ DB cluster.</p> <p>For more information on Multi-AZ DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ deployments with two readable standby DB instances</a> in the <i>Amazon RDS User Guide.</i> </p>', 'OrderableDBInstanceOption$SupportsStorageThroughput' => '<p>Indicates whether a DB instance supports storage throughput.</p>', 'OrderableDBInstanceOption$SupportsDedicatedLogVolume' => '<p>Indicates whether a DB instance supports using a dedicated log volume (DLV).</p>', 'Parameter$IsModifiable' => '<p>Indicates whether (<code>true</code>) or not (<code>false</code>) the parameter can be modified. Some parameters have security or operational implications that prevent them from being changed.</p>', 'ReservedDBInstance$MultiAZ' => '<p>Indicates whether the reservation applies to Multi-AZ deployments.</p>', 'ReservedDBInstancesOffering$MultiAZ' => '<p>Indicates whether the offering applies to Multi-AZ deployments.</p>', 'ResetDBClusterParameterGroupMessage$ResetAllParameters' => '<p>Specifies whether to reset all parameters in the DB cluster parameter group to their default values. You can\'t use this parameter if there is a list of parameter names specified for the <code>Parameters</code> parameter.</p>', 'ResetDBParameterGroupMessage$ResetAllParameters' => '<p>Specifies whether to reset all parameters in the DB parameter group to default values. By default, all parameters in the DB parameter group are reset to default values.</p>', 'RestoreDBClusterToPointInTimeMessage$UseLatestRestorableTime' => '<p>Specifies whether to restore the DB cluster to the latest restorable backup time. By default, the DB cluster isn\'t restored to the latest restorable backup time.</p> <p>Constraints: Can\'t be specified if <code>RestoreToTime</code> parameter is provided.</p> <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>', 'RestoreDBInstanceToPointInTimeMessage$UseLatestRestorableTime' => '<p>Specifies whether the DB instance is restored from the latest backup time. By default, the DB instance isn\'t restored from the latest backup time.</p> <p>Constraints:</p> <ul> <li> <p>Can\'t be specified if the <code>RestoreTime</code> parameter is provided.</p> </li> </ul>', 'SourceRegion$SupportsDBInstanceAutomatedBackupsReplication' => '<p>Indicates whether the source Amazon Web Services Region supports replicating automated backups to the current Amazon Web Services Region.</p>', 'StartActivityStreamResponse$ApplyImmediately' => '<p>Indicates whether or not the database activity stream will start as soon as possible, regardless of the maintenance window for the database.</p>', 'TenantDatabase$DeletionProtection' => '<p>Specifies whether deletion protection is enabled for the DB instance.</p>', 'UpgradeTarget$AutoUpgrade' => '<p>Indicates whether the target version is applied to any source DB instances that have <code>AutoMinorVersionUpgrade</code> set to true.</p> <p>This parameter is dynamic, and is set by RDS.</p>', 'UpgradeTarget$IsMajorVersionUpgrade' => '<p>Indicates whether upgrading to the target version requires upgrading the major version of the database engine.</p>', 'ValidDBInstanceModificationsMessage$SupportsDedicatedLogVolume' => '<p>Indicates whether a DB instance supports using a dedicated log volume (DLV).</p>', 'ValidStorageOptions$SupportsStorageAutoscaling' => '<p>Indicates whether or not Amazon RDS can automatically scale storage for DB instances that use the new instance class.</p>', ], ], 'BooleanOptional' => [ 'base' => NULL, 'refs' => [ 'BacktrackDBClusterMessage$Force' => '<p>Specifies whether to force the DB cluster to backtrack when binary logging is enabled. Otherwise, an error occurs when binary logging is enabled.</p>', 'BacktrackDBClusterMessage$UseEarliestTimeOnPointInTimeUnavailable' => '<p>Specifies whether to backtrack the DB cluster to the earliest possible backtrack time when <i>BacktrackTo</i> is set to a timestamp earlier than the earliest backtrack time. When this parameter is disabled and <i>BacktrackTo</i> is set to a timestamp earlier than the earliest backtrack time, an error occurs.</p>', 'Certificate$CustomerOverride' => '<p>Indicates whether there is an override for the default certificate identifier.</p>', 'ClusterPendingModifiedValues$IAMDatabaseAuthenticationEnabled' => '<p>Indicates whether mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is enabled.</p>', 'CopyDBClusterSnapshotMessage$CopyTags' => '<p>Specifies whether to copy all tags from the source DB cluster snapshot to the target DB cluster snapshot. By default, tags are not copied.</p>', 'CopyDBSnapshotMessage$CopyTags' => '<p>Specifies whether to copy all tags from the source DB snapshot to the target DB snapshot. By default, tags aren\'t copied.</p>', 'CopyDBSnapshotMessage$CopyOptionGroup' => '<p>Specifies whether to copy the DB option group associated with the source DB snapshot to the target Amazon Web Services account and associate with the target DB snapshot. The associated option group can be copied only with cross-account snapshot copy calls.</p>', 'CreateBlueGreenDeploymentRequest$UpgradeTargetStorageConfig' => '<p>Whether to upgrade the storage file system configuration on the green database. This option migrates the green DB instance from the older 32-bit file system to the preferred configuration. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.UpgradeFileSystem">Upgrading the storage file system for a DB instance</a>.</p>', 'CreateCustomDBEngineVersionMessage$UseAwsProvidedLatestImage' => '<p>Specifies whether to use the latest service-provided Amazon Machine Image (AMI) for the CEV. If you specify <code>UseAwsProvidedLatestImage</code>, you can\'t also specify <code>ImageId</code>.</p>', 'CreateDBClusterMessage$StorageEncrypted' => '<p>Specifies whether the DB cluster is encrypted.</p> <p>Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters</p>', 'CreateDBClusterMessage$EnableIAMDatabaseAuthentication' => '<p>Specifies whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping isn\'t enabled.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database Authentication</a> in the <i>Amazon Aurora User Guide</i>.</p> <p>Valid for Cluster Type: Aurora DB clusters only</p>', 'CreateDBClusterMessage$DeletionProtection' => '<p>Specifies whether the DB cluster has deletion protection enabled. The database can\'t be deleted when deletion protection is enabled. By default, deletion protection isn\'t enabled.</p> <p>Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters</p>', 'CreateDBClusterMessage$EnableHttpEndpoint' => '<p>Specifies whether to enable the HTTP endpoint for the DB cluster. By default, the HTTP endpoint isn\'t enabled.</p> <p>When enabled, the HTTP endpoint provides a connectionless web service API (RDS Data API) for running SQL queries on the DB cluster. You can also query your database from inside the RDS console with the RDS query editor.</p> <p>RDS Data API is supported with the following DB clusters:</p> <ul> <li> <p>Aurora PostgreSQL Serverless v2 and provisioned</p> </li> <li> <p>Aurora PostgreSQL and Aurora MySQL Serverless v1</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using RDS Data API</a> in the <i>Amazon Aurora User Guide</i>.</p> <p>Valid for Cluster Type: Aurora DB clusters only</p>', 'CreateDBClusterMessage$CopyTagsToSnapshot' => '<p>Specifies whether to copy all tags from the DB cluster to snapshots of the DB cluster. The default is not to copy them.</p> <p>Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters</p>', 'CreateDBClusterMessage$EnableGlobalWriteForwarding' => '<p>Specifies whether to enable this DB cluster to forward write operations to the primary cluster of a global cluster (Aurora global database). By default, write operations are not allowed on Aurora DB clusters that are secondary clusters in an Aurora global database.</p> <p>You can set this value only on Aurora DB clusters that are members of an Aurora global database. With this parameter enabled, a secondary cluster can forward writes to the current primary cluster, and the resulting changes are replicated back to this cluster. For the primary DB cluster of an Aurora global database, this value is used immediately if the primary is demoted by a global cluster API operation, but it does nothing until then.</p> <p>Valid for Cluster Type: Aurora DB clusters only</p>', 'CreateDBClusterMessage$PubliclyAccessible' => '<p>Specifies whether the DB cluster is publicly accessible.</p> <p>When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB cluster\'s virtual private cloud (VPC). It resolves to the public IP address from outside of the DB cluster\'s VPC. Access to the DB cluster is ultimately controlled by the security group it uses. That public access isn\'t permitted if the security group assigned to the DB cluster doesn\'t permit it.</p> <p>When the DB cluster isn\'t publicly accessible, it is an internal DB cluster with a DNS name that resolves to a private IP address.</p> <p>Valid for Cluster Type: Multi-AZ DB clusters only</p> <p>Default: The default behavior varies depending on whether <code>DBSubnetGroupName</code> is specified.</p> <p>If <code>DBSubnetGroupName</code> isn\'t specified, and <code>PubliclyAccessible</code> isn\'t specified, the following applies:</p> <ul> <li> <p>If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB cluster is private.</p> </li> <li> <p>If the default VPC in the target Region has an internet gateway attached to it, the DB cluster is public.</p> </li> </ul> <p>If <code>DBSubnetGroupName</code> is specified, and <code>PubliclyAccessible</code> isn\'t specified, the following applies:</p> <ul> <li> <p>If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB cluster is private.</p> </li> <li> <p>If the subnets are part of a VPC that has an internet gateway attached to it, the DB cluster is public.</p> </li> </ul>', 'CreateDBClusterMessage$AutoMinorVersionUpgrade' => '<p>Specifies whether minor engine upgrades are applied automatically to the DB cluster during the maintenance window. By default, minor engine upgrades are applied automatically.</p> <p>Valid for Cluster Type: Multi-AZ DB clusters only</p>', 'CreateDBClusterMessage$EnablePerformanceInsights' => '<p>Specifies whether to turn on Performance Insights for the DB cluster.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html"> Using Amazon Performance Insights</a> in the <i>Amazon RDS User Guide</i>.</p> <p>Valid for Cluster Type: Multi-AZ DB clusters only</p>', 'CreateDBClusterMessage$EnableLimitlessDatabase' => '<p>Specifies whether to enable Aurora Limitless Database. You must enable Aurora Limitless Database to create a DB shard group.</p> <p>Valid for: Aurora DB clusters only</p>', 'CreateDBClusterMessage$ManageMasterUserPassword' => '<p>Specifies whether to manage the master user password with Amazon Web Services Secrets Manager.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html">Password management with Amazon Web Services Secrets Manager</a> in the <i>Amazon RDS User Guide</i> and <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html">Password management with Amazon Web Services Secrets Manager</a> in the <i>Amazon Aurora User Guide.</i> </p> <p>Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters</p> <p>Constraints:</p> <ul> <li> <p>Can\'t manage the master user password with Amazon Web Services Secrets Manager if <code>MasterUserPassword</code> is specified.</p> </li> </ul>', 'CreateDBClusterMessage$EnableLocalWriteForwarding' => '<p>Specifies whether read replicas can forward write operations to the writer DB instance in the DB cluster. By default, write operations aren\'t allowed on reader DB instances.</p> <p>Valid for: Aurora DB clusters only</p>', 'CreateDBInstanceMessage$MultiAZ' => '<p>Specifies whether the DB instance is a Multi-AZ deployment. You can\'t set the <code>AvailabilityZone</code> parameter if the DB instance is a Multi-AZ deployment.</p> <p>This setting doesn\'t apply to the following DB instances:</p> <ul> <li> <p>Amazon Aurora (DB instance Availability Zones (AZs) are managed by the DB cluster.)</p> </li> <li> <p>RDS Custom</p> </li> </ul>', 'CreateDBInstanceMessage$AutoMinorVersionUpgrade' => '<p>Specifies whether minor engine upgrades are applied automatically to the DB instance during the maintenance window. By default, minor engine upgrades are applied automatically.</p> <p>If you create an RDS Custom DB instance, you must set <code>AutoMinorVersionUpgrade</code> to <code>false</code>.</p>', 'CreateDBInstanceMessage$PubliclyAccessible' => '<p>Specifies whether the DB instance is publicly accessible.</p> <p>When the DB instance is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB instance\'s virtual private cloud (VPC). It resolves to the public IP address from outside of the DB instance\'s VPC. Access to the DB instance is ultimately controlled by the security group it uses. That public access is not permitted if the security group assigned to the DB instance doesn\'t permit it.</p> <p>When the DB instance isn\'t publicly accessible, it is an internal DB instance with a DNS name that resolves to a private IP address.</p> <p>Default: The default behavior varies depending on whether <code>DBSubnetGroupName</code> is specified.</p> <p>If <code>DBSubnetGroupName</code> isn\'t specified, and <code>PubliclyAccessible</code> isn\'t specified, the following applies:</p> <ul> <li> <p>If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB instance is private.</p> </li> <li> <p>If the default VPC in the target Region has an internet gateway attached to it, the DB instance is public.</p> </li> </ul> <p>If <code>DBSubnetGroupName</code> is specified, and <code>PubliclyAccessible</code> isn\'t specified, the following applies:</p> <ul> <li> <p>If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB instance is private.</p> </li> <li> <p>If the subnets are part of a VPC that has an internet gateway attached to it, the DB instance is public.</p> </li> </ul>', 'CreateDBInstanceMessage$StorageEncrypted' => '<p>Specifes whether the DB instance is encrypted. By default, it isn\'t encrypted.</p> <p>For RDS Custom DB instances, either enable this setting or leave it unset. Otherwise, Amazon RDS reports an error.</p> <p>This setting doesn\'t apply to Amazon Aurora DB instances. The encryption for DB instances is managed by the DB cluster.</p>', 'CreateDBInstanceMessage$CopyTagsToSnapshot' => '<p>Specifies whether to copy tags from the DB instance to snapshots of the DB instance. By default, tags are not copied.</p> <p>This setting doesn\'t apply to Amazon Aurora DB instances. Copying tags to snapshots is managed by the DB cluster. Setting this value for an Aurora DB instance has no effect on the DB cluster setting.</p>', 'CreateDBInstanceMessage$EnableIAMDatabaseAuthentication' => '<p>Specifies whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping isn\'t enabled.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database Authentication for MySQL and PostgreSQL</a> in the <i>Amazon RDS User Guide</i>.</p> <p>This setting doesn\'t apply to the following DB instances:</p> <ul> <li> <p>Amazon Aurora (Mapping Amazon Web Services IAM accounts to database accounts is managed by the DB cluster.)</p> </li> <li> <p>RDS Custom</p> </li> </ul>', 'CreateDBInstanceMessage$EnablePerformanceInsights' => '<p>Specifies whether to enable Performance Insights for the DB instance. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using Amazon Performance Insights</a> in the <i>Amazon RDS User Guide</i>.</p> <p>This setting doesn\'t apply to RDS Custom DB instances.</p>', 'CreateDBInstanceMessage$DeletionProtection' => '<p>Specifies whether the DB instance has deletion protection enabled. The database can\'t be deleted when deletion protection is enabled. By default, deletion protection isn\'t enabled. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html"> Deleting a DB Instance</a>.</p> <p>This setting doesn\'t apply to Amazon Aurora DB instances. You can enable or disable deletion protection for the DB cluster. For more information, see <code>CreateDBCluster</code>. DB instances in a DB cluster can be deleted even when deletion protection is enabled for the DB cluster.</p>', 'CreateDBInstanceMessage$EnableCustomerOwnedIp' => '<p>Specifies whether to enable a customer-owned IP address (CoIP) for an RDS on Outposts DB instance.</p> <p>A <i>CoIP</i> provides local or external connectivity to resources in your Outpost subnets through your on-premises network. For some use cases, a CoIP can provide lower latency for connections to the DB instance from outside of its virtual private cloud (VPC) on your local network.</p> <p>For more information about RDS on Outposts, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Working with Amazon RDS on Amazon Web Services Outposts</a> in the <i>Amazon RDS User Guide</i>.</p> <p>For more information about CoIPs, see <a href="https://docs.aws.amazon.com/outposts/latest/userguide/routing.html#ip-addressing">Customer-owned IP addresses</a> in the <i>Amazon Web Services Outposts User Guide</i>.</p>', 'CreateDBInstanceMessage$ManageMasterUserPassword' => '<p>Specifies whether to manage the master user password with Amazon Web Services Secrets Manager.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html">Password management with Amazon Web Services Secrets Manager</a> in the <i>Amazon RDS User Guide.</i> </p> <p>Constraints:</p> <ul> <li> <p>Can\'t manage the master user password with Amazon Web Services Secrets Manager if <code>MasterUserPassword</code> is specified.</p> </li> </ul>', 'CreateDBInstanceMessage$DedicatedLogVolume' => '<p>Indicates whether the DB instance has a dedicated log volume (DLV) enabled.</p>', 'CreateDBInstanceMessage$MultiTenant' => '<p>Specifies whether to use the multi-tenant configuration or the single-tenant configuration (default). This parameter only applies to RDS for Oracle container database (CDB) engines.</p> <p>Note the following restrictions: </p> <ul> <li> <p>The DB engine that you specify in the request must support the multi-tenant configuration. If you attempt to enable the multi-tenant configuration on a DB engine that doesn\'t support it, the request fails.</p> </li> <li> <p>If you specify the multi-tenant configuration when you create your DB instance, you can\'t later modify this DB instance to use the single-tenant configuration.</p> </li> </ul>', 'CreateDBInstanceReadReplicaMessage$MultiAZ' => '<p>Specifies whether the read replica is in a Multi-AZ deployment.</p> <p>You can create a read replica as a Multi-AZ DB instance. RDS creates a standby of your replica in another Availability Zone for failover support for the replica. Creating your read replica as a Multi-AZ DB instance is independent of whether the source is a Multi-AZ DB instance or a Multi-AZ DB cluster.</p> <p>This setting doesn\'t apply to RDS Custom DB instances.</p>', 'CreateDBInstanceReadReplicaMessage$AutoMinorVersionUpgrade' => '<p>Specifies whether to automatically apply minor engine upgrades to the read replica during the maintenance window.</p> <p>This setting doesn\'t apply to RDS Custom DB instances.</p> <p>Default: Inherits the value from the source DB instance.</p>', 'CreateDBInstanceReadReplicaMessage$PubliclyAccessible' => '<p>Specifies whether the DB instance is publicly accessible.</p> <p>When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB cluster\'s virtual private cloud (VPC). It resolves to the public IP address from outside of the DB cluster\'s VPC. Access to the DB cluster is ultimately controlled by the security group it uses. That public access isn\'t permitted if the security group assigned to the DB cluster doesn\'t permit it.</p> <p>When the DB instance isn\'t publicly accessible, it is an internal DB instance with a DNS name that resolves to a private IP address.</p> <p>For more information, see <a>CreateDBInstance</a>.</p>', 'CreateDBInstanceReadReplicaMessage$CopyTagsToSnapshot' => '<p>Specifies whether to copy all tags from the read replica to snapshots of the read replica. By default, tags aren\'t copied.</p>', 'CreateDBInstanceReadReplicaMessage$EnableIAMDatabaseAuthentication' => '<p>Specifies whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping isn\'t enabled.</p> <p>For more information about IAM database authentication, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database Authentication for MySQL and PostgreSQL</a> in the <i>Amazon RDS User Guide</i>.</p> <p>This setting doesn\'t apply to RDS Custom DB instances.</p>', 'CreateDBInstanceReadReplicaMessage$EnablePerformanceInsights' => '<p>Specifies whether to enable Performance Insights for the read replica.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using Amazon Performance Insights</a> in the <i>Amazon RDS User Guide</i>.</p> <p>This setting doesn\'t apply to RDS Custom DB instances.</p>', 'CreateDBInstanceReadReplicaMessage$UseDefaultProcessorFeatures' => '<p>Specifies whether the DB instance class of the DB instance uses its default processor features.</p> <p>This setting doesn\'t apply to RDS Custom DB instances.</p>', 'CreateDBInstanceReadReplicaMessage$DeletionProtection' => '<p>Specifies whether to enable deletion protection for the DB instance. The database can\'t be deleted when deletion protection is enabled. By default, deletion protection isn\'t enabled. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html"> Deleting a DB Instance</a>.</p>', 'CreateDBInstanceReadReplicaMessage$EnableCustomerOwnedIp' => '<p>Specifies whether to enable a customer-owned IP address (CoIP) for an RDS on Outposts read replica.</p> <p>A <i>CoIP</i> provides local or external connectivity to resources in your Outpost subnets through your on-premises network. For some use cases, a CoIP can provide lower latency for connections to the read replica from outside of its virtual private cloud (VPC) on your local network.</p> <p>For more information about RDS on Outposts, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Working with Amazon RDS on Amazon Web Services Outposts</a> in the <i>Amazon RDS User Guide</i>.</p> <p>For more information about CoIPs, see <a href="https://docs.aws.amazon.com/outposts/latest/userguide/routing.html#ip-addressing">Customer-owned IP addresses</a> in the <i>Amazon Web Services Outposts User Guide</i>.</p>', 'CreateDBInstanceReadReplicaMessage$DedicatedLogVolume' => '<p>Indicates whether the DB instance has a dedicated log volume (DLV) enabled.</p>', 'CreateDBInstanceReadReplicaMessage$UpgradeStorageConfig' => '<p>Whether to upgrade the storage file system configuration on the read replica. This option migrates the read replica from the old storage file system layout to the preferred layout.</p>', 'CreateDBShardGroupMessage$PubliclyAccessible' => '<p>Specifies whether the DB shard group is publicly accessible.</p> <p>When the DB shard group is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB shard group\'s virtual private cloud (VPC). It resolves to the public IP address from outside of the DB shard group\'s VPC. Access to the DB shard group is ultimately controlled by the security group it uses. That public access is not permitted if the security group assigned to the DB shard group doesn\'t permit it.</p> <p>When the DB shard group isn\'t publicly accessible, it is an internal DB shard group with a DNS name that resolves to a private IP address.</p> <p>Default: The default behavior varies depending on whether <code>DBSubnetGroupName</code> is specified.</p> <p>If <code>DBSubnetGroupName</code> isn\'t specified, and <code>PubliclyAccessible</code> isn\'t specified, the following applies:</p> <ul> <li> <p>If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB shard group is private.</p> </li> <li> <p>If the default VPC in the target Region has an internet gateway attached to it, the DB shard group is public.</p> </li> </ul> <p>If <code>DBSubnetGroupName</code> is specified, and <code>PubliclyAccessible</code> isn\'t specified, the following applies:</p> <ul> <li> <p>If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB shard group is private.</p> </li> <li> <p>If the subnets are part of a VPC that has an internet gateway attached to it, the DB shard group is public.</p> </li> </ul>', 'CreateEventSubscriptionMessage$Enabled' => '<p>Specifies whether to activate the subscription. If the event notification subscription isn\'t activated, the subscription is created but not active.</p>', 'CreateGlobalClusterMessage$DeletionProtection' => '<p>Specifies whether to enable deletion protection for the new global database cluster. The global database can\'t be deleted when deletion protection is enabled.</p>', 'CreateGlobalClusterMessage$StorageEncrypted' => '<p>Specifies whether to enable storage encryption for the new global database cluster.</p> <p>Constraints:</p> <ul> <li> <p>Can\'t be specified if <code>SourceDBClusterIdentifier</code> is specified. In this case, Amazon Aurora uses the setting from the source DB cluster.</p> </li> </ul>', 'DBCluster$MultiAZ' => '<p>Indicates whether the DB cluster has instances in multiple Availability Zones.</p>', 'DBCluster$IAMDatabaseAuthenticationEnabled' => '<p>Indicates whether the mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is enabled.</p>', 'DBCluster$DeletionProtection' => '<p>Indicates whether the DB cluster has deletion protection enabled. The database can\'t be deleted when deletion protection is enabled.</p>', 'DBCluster$HttpEndpointEnabled' => '<p>Indicates whether the HTTP endpoint is enabled for an Aurora DB cluster.</p> <p>When enabled, the HTTP endpoint provides a connectionless web service API (RDS Data API) for running SQL queries on the DB cluster. You can also query your database from inside the RDS console with the RDS query editor.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using RDS Data API</a> in the <i>Amazon Aurora User Guide</i>.</p>', 'DBCluster$CopyTagsToSnapshot' => '<p>Indicates whether tags are copied from the DB cluster to snapshots of the DB cluster.</p>', 'DBCluster$CrossAccountClone' => '<p>Indicates whether the DB cluster is a clone of a DB cluster owned by a different Amazon Web Services account.</p>', 'DBCluster$GlobalWriteForwardingRequested' => '<p>Indicates whether write forwarding is enabled for a secondary cluster in an Aurora global database. Because write forwarding takes time to enable, check the value of <code>GlobalWriteForwardingStatus</code> to confirm that the request has completed before using the write forwarding feature for this cluster.</p>', 'DBCluster$PubliclyAccessible' => '<p>Indicates whether the DB cluster is publicly accessible.</p> <p>When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB cluster\'s virtual private cloud (VPC). It resolves to the public IP address from outside of the DB cluster\'s VPC. Access to the DB cluster is ultimately controlled by the security group it uses. That public access isn\'t permitted if the security group assigned to the DB cluster doesn\'t permit it.</p> <p>When the DB cluster isn\'t publicly accessible, it is an internal DB cluster with a DNS name that resolves to a private IP address.</p> <p>For more information, see <a>CreateDBCluster</a>.</p> <p>This setting is only for non-Aurora Multi-AZ DB clusters.</p>', 'DBCluster$PerformanceInsightsEnabled' => '<p>Indicates whether Performance Insights is enabled for the DB cluster.</p> <p>This setting is only for non-Aurora Multi-AZ DB clusters.</p>', 'DBEngineVersion$SupportsCertificateRotationWithoutRestart' => '<p>Indicates whether the engine version supports rotating the server certificate without rebooting the DB instance.</p>', 'DBEngineVersion$SupportsLocalWriteForwarding' => '<p>Indicates whether the DB engine version supports forwarding write operations from reader DB instances to the writer DB instance in the DB cluster. By default, write operations aren\'t allowed on reader DB instances.</p> <p>Valid for: Aurora DB clusters only</p>', 'DBInstance$PerformanceInsightsEnabled' => '<p>Indicates whether Performance Insights is enabled for the DB instance.</p>', 'DBInstance$CustomerOwnedIpEnabled' => '<p>Indicates whether a customer-owned IP address (CoIP) is enabled for an RDS on Outposts DB instance.</p> <p>A <i>CoIP </i>provides local or external connectivity to resources in your Outpost subnets through your on-premises network. For some use cases, a CoIP can provide lower latency for connections to the DB instance from outside of its virtual private cloud (VPC) on your local network.</p> <p>For more information about RDS on Outposts, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Working with Amazon RDS on Amazon Web Services Outposts</a> in the <i>Amazon RDS User Guide</i>.</p> <p>For more information about CoIPs, see <a href="https://docs.aws.amazon.com/outposts/latest/userguide/routing.html#ip-addressing">Customer-owned IP addresses</a> in the <i>Amazon Web Services Outposts User Guide</i>.</p>', 'DBInstance$ActivityStreamEngineNativeAuditFieldsIncluded' => '<p>Indicates whether engine-native audit fields are included in the database activity stream.</p>', 'DBInstance$IsStorageConfigUpgradeAvailable' => '<p>Indicates whether an upgrade is recommended for the storage file system configuration on the DB instance. To migrate to the preferred configuration, you can either create a blue/green deployment, or create a read replica from the DB instance. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.UpgradeFileSystem">Upgrading the storage file system for a DB instance</a>.</p>', 'DBInstance$MultiTenant' => '<p>Specifies whether the DB instance is in the multi-tenant configuration (TRUE) or the single-tenant configuration (FALSE).</p>', 'DBInstanceAutomatedBackup$DedicatedLogVolume' => '<p>Indicates whether the DB instance has a dedicated log volume (DLV) enabled.</p>', 'DBInstanceAutomatedBackup$MultiTenant' => '<p>Specifies whether the automatic backup is for a DB instance in the multi-tenant configuration (TRUE) or the single-tenant configuration (FALSE). </p>', 'DBShardGroup$PubliclyAccessible' => '<p>Indicates whether the DB shard group is publicly accessible.</p> <p>When the DB shard group is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB shard group\'s virtual private cloud (VPC). It resolves to the public IP address from outside of the DB shard group\'s VPC. Access to the DB shard group is ultimately controlled by the security group it uses. That public access isn\'t permitted if the security group assigned to the DB shard group doesn\'t permit it.</p> <p>When the DB shard group isn\'t publicly accessible, it is an internal DB shard group with a DNS name that resolves to a private IP address.</p> <p>For more information, see <a>CreateDBShardGroup</a>.</p> <p>This setting is only for Aurora Limitless Database.</p>', 'DBSnapshot$MultiTenant' => '<p>Indicates whether the snapshot is of a DB instance using the multi-tenant configuration (TRUE) or the single-tenant configuration (FALSE).</p>', 'DeleteBlueGreenDeploymentRequest$DeleteTarget' => '<p>Specifies whether to delete the resources in the green environment. You can\'t specify this option if the blue/green deployment <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_BlueGreenDeployment.html">status</a> is <code>SWITCHOVER_COMPLETED</code>.</p>', 'DeleteDBClusterMessage$DeleteAutomatedBackups' => '<p>Specifies whether to remove automated backups immediately after the DB cluster is deleted. This parameter isn\'t case-sensitive. The default is to remove automated backups immediately after the DB cluster is deleted.</p>', 'DeleteDBInstanceMessage$DeleteAutomatedBackups' => '<p>Specifies whether to remove automated backups immediately after the DB instance is deleted. This parameter isn\'t case-sensitive. The default is to remove automated backups immediately after the DB instance is deleted.</p>', 'DescribeDBEngineVersionsMessage$ListSupportedCharacterSets' => '<p>Specifies whether to list the supported character sets for each engine version.</p> <p>If this parameter is enabled and the requested engine supports the <code>CharacterSetName</code> parameter for <code>CreateDBInstance</code>, the response includes a list of supported character sets for each engine version.</p> <p>For RDS Custom, the default is not to list supported character sets. If you enable this parameter, RDS Custom returns no results.</p>', 'DescribeDBEngineVersionsMessage$ListSupportedTimezones' => '<p>Specifies whether to list the supported time zones for each engine version.</p> <p>If this parameter is enabled and the requested engine supports the <code>TimeZone</code> parameter for <code>CreateDBInstance</code>, the response includes a list of supported time zones for each engine version.</p> <p>For RDS Custom, the default is not to list supported time zones. If you enable this parameter, RDS Custom returns no results.</p>', 'DescribeDBEngineVersionsMessage$IncludeAll' => '<p>Specifies whether to also list the engine versions that aren\'t available. The default is to list only available engine versions.</p>', 'DescribeOrderableDBInstanceOptionsMessage$Vpc' => '<p>Specifies whether to show only VPC or non-VPC offerings. RDS Custom supports only VPC offerings.</p> <p>RDS Custom supports only VPC offerings. If you describe non-VPC offerings for RDS Custom, the output shows VPC offerings.</p>', 'DescribeReservedDBInstancesMessage$MultiAZ' => '<p>Specifies whether to show only those reservations that support Multi-AZ.</p>', 'DescribeReservedDBInstancesOfferingsMessage$MultiAZ' => '<p>Specifies whether to show only those reservations that support Multi-AZ.</p>', 'FailoverGlobalClusterMessage$AllowDataLoss' => '<p>Specifies whether to allow data loss for this global database cluster operation. Allowing data loss triggers a global failover operation.</p> <p>If you don\'t specify <code>AllowDataLoss</code>, the global database cluster operation defaults to a switchover.</p> <p>Constraints:</p> <ul> <li> <p>Can\'t be specified together with the <code>Switchover</code> parameter.</p> </li> </ul>', 'FailoverGlobalClusterMessage$Switchover' => '<p>Specifies whether to switch over this global database cluster.</p> <p>Constraints:</p> <ul> <li> <p>Can\'t be specified together with the <code>AllowDataLoss</code> parameter.</p> </li> </ul>', 'GlobalCluster$StorageEncrypted' => '<p>The storage encryption setting for the global database cluster.</p>', 'GlobalCluster$DeletionProtection' => '<p>The deletion protection setting for the new global database cluster.</p>', 'ModifyActivityStreamResponse$EngineNativeAuditFieldsIncluded' => '<p>Indicates whether engine-native audit fields are included in the database activity stream.</p>', 'ModifyCertificatesMessage$RemoveCustomerOverride' => '<p>Specifies whether to remove the override for the default certificate. If the override is removed, the default certificate is the system default.</p>', 'ModifyDBClusterMessage$EnableIAMDatabaseAuthentication' => '<p>Specifies whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping isn\'t enabled.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database Authentication</a> in the <i>Amazon Aurora User Guide</i>.</p> <p>Valid for Cluster Type: Aurora DB clusters only</p>', 'ModifyDBClusterMessage$DeletionProtection' => '<p>Specifies whether the DB cluster has deletion protection enabled. The database can\'t be deleted when deletion protection is enabled. By default, deletion protection isn\'t enabled.</p> <p>Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters</p>', 'ModifyDBClusterMessage$EnableHttpEndpoint' => '<p>Specifies whether to enable the HTTP endpoint for an Aurora Serverless v1 DB cluster. By default, the HTTP endpoint isn\'t enabled.</p> <p>When enabled, the HTTP endpoint provides a connectionless web service API (RDS Data API) for running SQL queries on the Aurora Serverless v1 DB cluster. You can also query your database from inside the RDS console with the RDS query editor.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using RDS Data API</a> in the <i>Amazon Aurora User Guide</i>.</p> <note> <p>This parameter applies only to Aurora Serverless v1 DB clusters. To enable or disable the HTTP endpoint for an Aurora PostgreSQL Serverless v2 or provisioned DB cluster, use the <code>EnableHttpEndpoint</code> and <code>DisableHttpEndpoint</code> operations.</p> </note> <p>Valid for Cluster Type: Aurora DB clusters only</p>', 'ModifyDBClusterMessage$CopyTagsToSnapshot' => '<p>Specifies whether to copy all tags from the DB cluster to snapshots of the DB cluster. The default is not to copy them.</p> <p>Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters</p>', 'ModifyDBClusterMessage$EnableGlobalWriteForwarding' => '<p>Specifies whether to enable this DB cluster to forward write operations to the primary cluster of a global cluster (Aurora global database). By default, write operations are not allowed on Aurora DB clusters that are secondary clusters in an Aurora global database.</p> <p>You can set this value only on Aurora DB clusters that are members of an Aurora global database. With this parameter enabled, a secondary cluster can forward writes to the current primary cluster, and the resulting changes are replicated back to this cluster. For the primary DB cluster of an Aurora global database, this value is used immediately if the primary is demoted by a global cluster API operation, but it does nothing until then.</p> <p>Valid for Cluster Type: Aurora DB clusters only</p>', 'ModifyDBClusterMessage$AutoMinorVersionUpgrade' => '<p>Specifies whether minor engine upgrades are applied automatically to the DB cluster during the maintenance window. By default, minor engine upgrades are applied automatically.</p> <p>Valid for Cluster Type: Multi-AZ DB clusters only</p>', 'ModifyDBClusterMessage$EnablePerformanceInsights' => '<p>Specifies whether to turn on Performance Insights for the DB cluster.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html"> Using Amazon Performance Insights</a> in the <i>Amazon RDS User Guide</i>.</p> <p>Valid for Cluster Type: Multi-AZ DB clusters only</p>', 'ModifyDBClusterMessage$ManageMasterUserPassword' => '<p>Specifies whether to manage the master user password with Amazon Web Services Secrets Manager.</p> <p>If the DB cluster doesn\'t manage the master user password with Amazon Web Services Secrets Manager, you can turn on this management. In this case, you can\'t specify <code>MasterUserPassword</code>.</p> <p>If the DB cluster already manages the master user password with Amazon Web Services Secrets Manager, and you specify that the master user password is not managed with Amazon Web Services Secrets Manager, then you must specify <code>MasterUserPassword</code>. In this case, RDS deletes the secret and uses the new password for the master user specified by <code>MasterUserPassword</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html">Password management with Amazon Web Services Secrets Manager</a> in the <i>Amazon RDS User Guide</i> and <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html">Password management with Amazon Web Services Secrets Manager</a> in the <i>Amazon Aurora User Guide.</i> </p> <p>Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters</p>', 'ModifyDBClusterMessage$RotateMasterUserPassword' => '<p>Specifies whether to rotate the secret managed by Amazon Web Services Secrets Manager for the master user password.</p> <p>This setting is valid only if the master user password is managed by RDS in Amazon Web Services Secrets Manager for the DB cluster. The secret value contains the updated password.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html">Password management with Amazon Web Services Secrets Manager</a> in the <i>Amazon RDS User Guide</i> and <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html">Password management with Amazon Web Services Secrets Manager</a> in the <i>Amazon Aurora User Guide.</i> </p> <p>Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters</p> <p>Constraints:</p> <ul> <li> <p>You must apply the change immediately when rotating the master user password.</p> </li> </ul>', 'ModifyDBClusterMessage$EnableLocalWriteForwarding' => '<p>Specifies whether read replicas can forward write operations to the writer DB instance in the DB cluster. By default, write operations aren\'t allowed on reader DB instances.</p> <p>Valid for: Aurora DB clusters only</p>', 'ModifyDBClusterMessage$EnableLimitlessDatabase' => '<p>Specifies whether to enable Aurora Limitless Database. You must enable Aurora Limitless Database to create a DB shard group.</p> <p>Valid for: Aurora DB clusters only</p>', 'ModifyDBInstanceMessage$MultiAZ' => '<p>Specifies whether the DB instance is a Multi-AZ deployment. Changing this parameter doesn\'t result in an outage. The change is applied during the next maintenance window unless the <code>ApplyImmediately</code> parameter is enabled for this request.</p> <p>This setting doesn\'t apply to RDS Custom DB instances.</p>', 'ModifyDBInstanceMessage$AutoMinorVersionUpgrade' => '<p>Specifies whether minor version upgrades are applied automatically to the DB instance during the maintenance window. An outage occurs when all the following conditions are met:</p> <ul> <li> <p>The automatic upgrade is enabled for the maintenance window.</p> </li> <li> <p>A newer minor version is available.</p> </li> <li> <p>RDS has enabled automatic patching for the engine version.</p> </li> </ul> <p>If any of the preceding conditions isn\'t met, Amazon RDS applies the change as soon as possible and doesn\'t cause an outage.</p> <p>For an RDS Custom DB instance, don\'t enable this setting. Otherwise, the operation returns an error.</p>', 'ModifyDBInstanceMessage$CopyTagsToSnapshot' => '<p>Specifies whether to copy all tags from the DB instance to snapshots of the DB instance. By default, tags aren\'t copied.</p> <p>This setting doesn\'t apply to Amazon Aurora DB instances. Copying tags to snapshots is managed by the DB cluster. Setting this value for an Aurora DB instance has no effect on the DB cluster setting. For more information, see <code>ModifyDBCluster</code>.</p>', 'ModifyDBInstanceMessage$PubliclyAccessible' => '<p>Specifies whether the DB instance is publicly accessible.</p> <p>When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB cluster\'s virtual private cloud (VPC). It resolves to the public IP address from outside of the DB cluster\'s VPC. Access to the DB cluster is ultimately controlled by the security group it uses. That public access isn\'t permitted if the security group assigned to the DB cluster doesn\'t permit it.</p> <p>When the DB instance isn\'t publicly accessible, it is an internal DB instance with a DNS name that resolves to a private IP address.</p> <p> <code>PubliclyAccessible</code> only applies to DB instances in a VPC. The DB instance must be part of a public subnet and <code>PubliclyAccessible</code> must be enabled for it to be publicly accessible.</p> <p>Changes to the <code>PubliclyAccessible</code> parameter are applied immediately regardless of the value of the <code>ApplyImmediately</code> parameter.</p>', 'ModifyDBInstanceMessage$DisableDomain' => '<p>Specifies whether to remove the DB instance from the Active Directory domain.</p>', 'ModifyDBInstanceMessage$EnableIAMDatabaseAuthentication' => '<p>Specifies whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping isn\'t enabled.</p> <p>This setting doesn\'t apply to Amazon Aurora. Mapping Amazon Web Services IAM accounts to database accounts is managed by the DB cluster.</p> <p>For more information about IAM database authentication, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database Authentication for MySQL and PostgreSQL</a> in the <i>Amazon RDS User Guide.</i> </p> <p>This setting doesn\'t apply to RDS Custom DB instances.</p>', 'ModifyDBInstanceMessage$EnablePerformanceInsights' => '<p>Specifies whether to enable Performance Insights for the DB instance.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using Amazon Performance Insights</a> in the <i>Amazon RDS User Guide</i>.</p> <p>This setting doesn\'t apply to RDS Custom DB instances.</p>', 'ModifyDBInstanceMessage$UseDefaultProcessorFeatures' => '<p>Specifies whether the DB instance class of the DB instance uses its default processor features.</p> <p>This setting doesn\'t apply to RDS Custom DB instances.</p>', 'ModifyDBInstanceMessage$DeletionProtection' => '<p>Specifies whether the DB instance has deletion protection enabled. The database can\'t be deleted when deletion protection is enabled. By default, deletion protection isn\'t enabled. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html"> Deleting a DB Instance</a>.</p> <p>This setting doesn\'t apply to Amazon Aurora DB instances. You can enable or disable deletion protection for the DB cluster. For more information, see <code>ModifyDBCluster</code>. DB instances in a DB cluster can be deleted even when deletion protection is enabled for the DB cluster.</p>', 'ModifyDBInstanceMessage$CertificateRotationRestart' => '<p>Specifies whether the DB instance is restarted when you rotate your SSL/TLS certificate.</p> <p>By default, the DB instance is restarted when you rotate your SSL/TLS certificate. The certificate is not updated until the DB instance is restarted.</p> <important> <p>Set this parameter only if you are <i>not</i> using SSL/TLS to connect to the DB instance.</p> </important> <p>If you are using SSL/TLS to connect to the DB instance, follow the appropriate instructions for your DB engine to rotate your SSL/TLS certificate:</p> <ul> <li> <p>For more information about rotating your SSL/TLS certificate for RDS DB engines, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL-certificate-rotation.html"> Rotating Your SSL/TLS Certificate.</a> in the <i>Amazon RDS User Guide.</i> </p> </li> <li> <p>For more information about rotating your SSL/TLS certificate for Aurora DB engines, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL-certificate-rotation.html"> Rotating Your SSL/TLS Certificate</a> in the <i>Amazon Aurora User Guide</i>.</p> </li> </ul> <p>This setting doesn\'t apply to RDS Custom DB instances.</p>', 'ModifyDBInstanceMessage$EnableCustomerOwnedIp' => '<p>Specifies whether to enable a customer-owned IP address (CoIP) for an RDS on Outposts DB instance.</p> <p>A <i>CoIP</i> provides local or external connectivity to resources in your Outpost subnets through your on-premises network. For some use cases, a CoIP can provide lower latency for connections to the DB instance from outside of its virtual private cloud (VPC) on your local network.</p> <p>For more information about RDS on Outposts, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Working with Amazon RDS on Amazon Web Services Outposts</a> in the <i>Amazon RDS User Guide</i>.</p> <p>For more information about CoIPs, see <a href="https://docs.aws.amazon.com/outposts/latest/userguide/routing.html#ip-addressing">Customer-owned IP addresses</a> in the <i>Amazon Web Services Outposts User Guide</i>.</p>', 'ModifyDBInstanceMessage$ManageMasterUserPassword' => '<p>Specifies whether to manage the master user password with Amazon Web Services Secrets Manager.</p> <p>If the DB instance doesn\'t manage the master user password with Amazon Web Services Secrets Manager, you can turn on this management. In this case, you can\'t specify <code>MasterUserPassword</code>.</p> <p>If the DB instance already manages the master user password with Amazon Web Services Secrets Manager, and you specify that the master user password is not managed with Amazon Web Services Secrets Manager, then you must specify <code>MasterUserPassword</code>. In this case, Amazon RDS deletes the secret and uses the new password for the master user specified by <code>MasterUserPassword</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html">Password management with Amazon Web Services Secrets Manager</a> in the <i>Amazon RDS User Guide.</i> </p> <p>Constraints:</p> <ul> <li> <p>Can\'t manage the master user password with Amazon Web Services Secrets Manager if <code>MasterUserPassword</code> is specified.</p> </li> </ul>', 'ModifyDBInstanceMessage$RotateMasterUserPassword' => '<p>Specifies whether to rotate the secret managed by Amazon Web Services Secrets Manager for the master user password.</p> <p>This setting is valid only if the master user password is managed by RDS in Amazon Web Services Secrets Manager for the DB cluster. The secret value contains the updated password.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html">Password management with Amazon Web Services Secrets Manager</a> in the <i>Amazon RDS User Guide.</i> </p> <p>Constraints:</p> <ul> <li> <p>You must apply the change immediately when rotating the master user password.</p> </li> </ul>', 'ModifyDBInstanceMessage$DedicatedLogVolume' => '<p>Indicates whether the DB instance has a dedicated log volume (DLV) enabled.</p>', 'ModifyDBInstanceMessage$MultiTenant' => '<p>Specifies whether the to convert your DB instance from the single-tenant conﬁguration to the multi-tenant conﬁguration. This parameter is supported only for RDS for Oracle CDB instances.</p> <p>During the conversion, RDS creates an initial tenant database and associates the DB name, master user name, character set, and national character set metadata with this database. The tags associated with the instance also propagate to the initial tenant database. You can add more tenant databases to your DB instance by using the <code>CreateTenantDatabase</code> operation.</p> <important> <p>The conversion to the multi-tenant configuration is permanent and irreversible, so you can\'t later convert back to the single-tenant configuration. When you specify this parameter, you must also specify <code>ApplyImmediately</code>.</p> </important>', 'ModifyDBProxyRequest$RequireTLS' => '<p>Whether Transport Layer Security (TLS) encryption is required for connections to the proxy. By enabling this setting, you can enforce encrypted TLS connections to the proxy, even if the associated database doesn\'t use TLS.</p>', 'ModifyDBProxyRequest$DebugLogging' => '<p>Whether the proxy includes detailed information about SQL statements in its logs. This information helps you to debug issues involving SQL behavior or the performance and scalability of the proxy connections. The debug information includes the text of SQL statements that you submit through the proxy. Thus, only enable this setting when needed for debugging, and only when you have security measures in place to safeguard any sensitive information that appears in the logs.</p>', 'ModifyEventSubscriptionMessage$Enabled' => '<p>Specifies whether to activate the subscription.</p>', 'ModifyGlobalClusterMessage$DeletionProtection' => '<p>Specifies whether to enable deletion protection for the global database cluster. The global database cluster can\'t be deleted when deletion protection is enabled.</p>', 'ModifyGlobalClusterMessage$AllowMajorVersionUpgrade' => '<p>Specifies whether to allow major version upgrades.</p> <p>Constraints: Must be enabled if you specify a value for the <code>EngineVersion</code> parameter that\'s a different major version than the global cluster\'s current version.</p> <p>If you upgrade the major version of a global database, the cluster and DB instance parameter groups are set to the default parameter groups for the new version. Apply any custom parameter groups after completing the upgrade.</p>', 'OptionGroupOption$SupportsOptionVersionDowngrade' => '<p>If true, you can change the option to an earlier version of the option. This only applies to options that have different versions available.</p>', 'OptionGroupOption$CopyableCrossAccount' => '<p>Indicates whether the option can be copied across Amazon Web Services accounts.</p>', 'OrderableDBInstanceOption$SupportsStorageAutoscaling' => '<p>Indicates whether Amazon RDS can automatically scale storage for DB instances that use the specified DB instance class.</p>', 'OrderableDBInstanceOption$SupportsKerberosAuthentication' => '<p>Indicates whether a DB instance supports Kerberos Authentication.</p>', 'PendingModifiedValues$MultiAZ' => '<p>Indicates whether the Single-AZ DB instance will change to a Multi-AZ deployment.</p>', 'PendingModifiedValues$IAMDatabaseAuthenticationEnabled' => '<p>Indicates whether mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is enabled.</p>', 'PendingModifiedValues$DedicatedLogVolume' => '<p>Indicates whether the DB instance has a dedicated log volume (DLV) enabled.&gt;</p>', 'PendingModifiedValues$MultiTenant' => '<p>Indicates whether the DB instance will change to the multi-tenant configuration (TRUE) or the single-tenant configuration (FALSE). </p>', 'RebootDBInstanceMessage$ForceFailover' => '<p>Specifies whether the reboot is conducted through a Multi-AZ failover.</p> <p>Constraint: You can\'t enable force failover if the instance isn\'t configured for Multi-AZ.</p>', 'RestoreDBClusterFromS3Message$StorageEncrypted' => '<p>Specifies whether the restored DB cluster is encrypted.</p>', 'RestoreDBClusterFromS3Message$EnableIAMDatabaseAuthentication' => '<p>Specifies whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping isn\'t enabled.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database Authentication</a> in the <i>Amazon Aurora User Guide</i>.</p>', 'RestoreDBClusterFromS3Message$DeletionProtection' => '<p>Specifies whether to enable deletion protection for the DB cluster. The database can\'t be deleted when deletion protection is enabled. By default, deletion protection isn\'t enabled.</p>', 'RestoreDBClusterFromS3Message$CopyTagsToSnapshot' => '<p>Specifies whether to copy all tags from the restored DB cluster to snapshots of the restored DB cluster. The default is not to copy them.</p>', 'RestoreDBClusterFromS3Message$ManageMasterUserPassword' => '<p>Specifies whether to manage the master user password with Amazon Web Services Secrets Manager.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html">Password management with Amazon Web Services Secrets Manager</a> in the <i>Amazon RDS User Guide</i> and <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html">Password management with Amazon Web Services Secrets Manager</a> in the <i>Amazon Aurora User Guide.</i> </p> <p>Constraints:</p> <ul> <li> <p>Can\'t manage the master user password with Amazon Web Services Secrets Manager if <code>MasterUserPassword</code> is specified.</p> </li> </ul>', 'RestoreDBClusterFromSnapshotMessage$EnableIAMDatabaseAuthentication' => '<p>Specifies whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping isn\'t enabled.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database Authentication</a> in the <i>Amazon Aurora User Guide</i>.</p> <p>Valid for: Aurora DB clusters only</p>', 'RestoreDBClusterFromSnapshotMessage$DeletionProtection' => '<p>Specifies whether to enable deletion protection for the DB cluster. The database can\'t be deleted when deletion protection is enabled. By default, deletion protection isn\'t enabled.</p> <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>', 'RestoreDBClusterFromSnapshotMessage$CopyTagsToSnapshot' => '<p>Specifies whether to copy all tags from the restored DB cluster to snapshots of the restored DB cluster. The default is not to copy them.</p> <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>', 'RestoreDBClusterFromSnapshotMessage$PubliclyAccessible' => '<p>Specifies whether the DB cluster is publicly accessible.</p> <p>When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB cluster\'s virtual private cloud (VPC). It resolves to the public IP address from outside of the DB cluster\'s VPC. Access to the DB cluster is ultimately controlled by the security group it uses. That public access is not permitted if the security group assigned to the DB cluster doesn\'t permit it.</p> <p>When the DB cluster isn\'t publicly accessible, it is an internal DB cluster with a DNS name that resolves to a private IP address.</p> <p>Default: The default behavior varies depending on whether <code>DBSubnetGroupName</code> is specified.</p> <p>If <code>DBSubnetGroupName</code> isn\'t specified, and <code>PubliclyAccessible</code> isn\'t specified, the following applies:</p> <ul> <li> <p>If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB cluster is private.</p> </li> <li> <p>If the default VPC in the target Region has an internet gateway attached to it, the DB cluster is public.</p> </li> </ul> <p>If <code>DBSubnetGroupName</code> is specified, and <code>PubliclyAccessible</code> isn\'t specified, the following applies:</p> <ul> <li> <p>If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB cluster is private.</p> </li> <li> <p>If the subnets are part of a VPC that has an internet gateway attached to it, the DB cluster is public.</p> </li> </ul> <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>', 'RestoreDBClusterToPointInTimeMessage$EnableIAMDatabaseAuthentication' => '<p>Specifies whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping isn\'t enabled.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database Authentication</a> in the <i>Amazon Aurora User Guide</i>.</p> <p>Valid for: Aurora DB clusters only</p>', 'RestoreDBClusterToPointInTimeMessage$DeletionProtection' => '<p>Specifies whether to enable deletion protection for the DB cluster. The database can\'t be deleted when deletion protection is enabled. By default, deletion protection isn\'t enabled.</p> <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>', 'RestoreDBClusterToPointInTimeMessage$CopyTagsToSnapshot' => '<p>Specifies whether to copy all tags from the restored DB cluster to snapshots of the restored DB cluster. The default is not to copy them.</p> <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>', 'RestoreDBClusterToPointInTimeMessage$PubliclyAccessible' => '<p>Specifies whether the DB cluster is publicly accessible.</p> <p>When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB cluster\'s virtual private cloud (VPC). It resolves to the public IP address from outside of the DB cluster\'s VPC. Access to the DB cluster is ultimately controlled by the security group it uses. That public access is not permitted if the security group assigned to the DB cluster doesn\'t permit it.</p> <p>When the DB cluster isn\'t publicly accessible, it is an internal DB cluster with a DNS name that resolves to a private IP address.</p> <p>Default: The default behavior varies depending on whether <code>DBSubnetGroupName</code> is specified.</p> <p>If <code>DBSubnetGroupName</code> isn\'t specified, and <code>PubliclyAccessible</code> isn\'t specified, the following applies:</p> <ul> <li> <p>If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB cluster is private.</p> </li> <li> <p>If the default VPC in the target Region has an internet gateway attached to it, the DB cluster is public.</p> </li> </ul> <p>If <code>DBSubnetGroupName</code> is specified, and <code>PubliclyAccessible</code> isn\'t specified, the following applies:</p> <ul> <li> <p>If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB cluster is private.</p> </li> <li> <p>If the subnets are part of a VPC that has an internet gateway attached to it, the DB cluster is public.</p> </li> </ul> <p>Valid for: Multi-AZ DB clusters only</p>', 'RestoreDBInstanceFromDBSnapshotMessage$MultiAZ' => '<p>Specifies whether the DB instance is a Multi-AZ deployment.</p> <p>This setting doesn\'t apply to RDS Custom.</p> <p>Constraint: You can\'t specify the <code>AvailabilityZone</code> parameter if the DB instance is a Multi-AZ deployment.</p>', 'RestoreDBInstanceFromDBSnapshotMessage$PubliclyAccessible' => '<p>Specifies whether the DB instance is publicly accessible.</p> <p>When the DB instance is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB instance\'s virtual private cloud (VPC). It resolves to the public IP address from outside of the DB instance\'s VPC. Access to the DB instance is ultimately controlled by the security group it uses. That public access is not permitted if the security group assigned to the DB instance doesn\'t permit it.</p> <p>When the DB instance isn\'t publicly accessible, it is an internal DB instance with a DNS name that resolves to a private IP address.</p> <p>For more information, see <a>CreateDBInstance</a>.</p>', 'RestoreDBInstanceFromDBSnapshotMessage$AutoMinorVersionUpgrade' => '<p>Specifies whether to automatically apply minor version upgrades to the DB instance during the maintenance window.</p> <p>If you restore an RDS Custom DB instance, you must disable this parameter.</p>', 'RestoreDBInstanceFromDBSnapshotMessage$CopyTagsToSnapshot' => '<p>Specifies whether to copy all tags from the restored DB instance to snapshots of the DB instance.</p> <p>In most cases, tags aren\'t copied by default. However, when you restore a DB instance from a DB snapshot, RDS checks whether you specify new tags. If yes, the new tags are added to the restored DB instance. If there are no new tags, RDS looks for the tags from the source DB instance for the DB snapshot, and then adds those tags to the restored DB instance.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html#USER_Tagging.CopyTags"> Copying tags to DB instance snapshots</a> in the <i>Amazon RDS User Guide</i>.</p>', 'RestoreDBInstanceFromDBSnapshotMessage$EnableIAMDatabaseAuthentication' => '<p>Specifies whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping is disabled.</p> <p>For more information about IAM database authentication, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database Authentication for MySQL and PostgreSQL</a> in the <i>Amazon RDS User Guide.</i> </p> <p>This setting doesn\'t apply to RDS Custom.</p>', 'RestoreDBInstanceFromDBSnapshotMessage$UseDefaultProcessorFeatures' => '<p>Specifies whether the DB instance class of the DB instance uses its default processor features.</p> <p>This setting doesn\'t apply to RDS Custom.</p>', 'RestoreDBInstanceFromDBSnapshotMessage$DeletionProtection' => '<p>Specifies whether to enable deletion protection for the DB instance. The database can\'t be deleted when deletion protection is enabled. By default, deletion protection isn\'t enabled. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html"> Deleting a DB Instance</a>.</p>', 'RestoreDBInstanceFromDBSnapshotMessage$EnableCustomerOwnedIp' => '<p>Specifies whether to enable a customer-owned IP address (CoIP) for an RDS on Outposts DB instance.</p> <p>A <i>CoIP</i> provides local or external connectivity to resources in your Outpost subnets through your on-premises network. For some use cases, a CoIP can provide lower latency for connections to the DB instance from outside of its virtual private cloud (VPC) on your local network.</p> <p>This setting doesn\'t apply to RDS Custom.</p> <p>For more information about RDS on Outposts, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Working with Amazon RDS on Amazon Web Services Outposts</a> in the <i>Amazon RDS User Guide</i>.</p> <p>For more information about CoIPs, see <a href="https://docs.aws.amazon.com/outposts/latest/userguide/routing.html#ip-addressing">Customer-owned IP addresses</a> in the <i>Amazon Web Services Outposts User Guide</i>.</p>', 'RestoreDBInstanceFromDBSnapshotMessage$DedicatedLogVolume' => '<p>Specifies whether to enable a dedicated log volume (DLV) for the DB instance.</p>', 'RestoreDBInstanceFromS3Message$MultiAZ' => '<p>Specifies whether the DB instance is a Multi-AZ deployment. If the DB instance is a Multi-AZ deployment, you can\'t set the <code>AvailabilityZone</code> parameter.</p>', 'RestoreDBInstanceFromS3Message$AutoMinorVersionUpgrade' => '<p>Specifies whether to automatically apply minor engine upgrades to the DB instance during the maintenance window. By default, minor engine upgrades are not applied automatically.</p>', 'RestoreDBInstanceFromS3Message$PubliclyAccessible' => '<p>Specifies whether the DB instance is publicly accessible.</p> <p>When the DB instance is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB instance\'s virtual private cloud (VPC). It resolves to the public IP address from outside of the DB instance\'s VPC. Access to the DB instance is ultimately controlled by the security group it uses. That public access is not permitted if the security group assigned to the DB instance doesn\'t permit it.</p> <p>When the DB instance isn\'t publicly accessible, it is an internal DB instance with a DNS name that resolves to a private IP address.</p> <p>For more information, see <a>CreateDBInstance</a>.</p>', 'RestoreDBInstanceFromS3Message$StorageEncrypted' => '<p>Specifies whether the new DB instance is encrypted or not.</p>', 'RestoreDBInstanceFromS3Message$CopyTagsToSnapshot' => '<p>Specifies whether to copy all tags from the DB instance to snapshots of the DB instance. By default, tags are not copied.</p>', 'RestoreDBInstanceFromS3Message$EnableIAMDatabaseAuthentication' => '<p>Specifies whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping isn\'t enabled.</p> <p>For more information about IAM database authentication, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database Authentication for MySQL and PostgreSQL</a> in the <i>Amazon RDS User Guide.</i> </p>', 'RestoreDBInstanceFromS3Message$EnablePerformanceInsights' => '<p>Specifies whether to enable Performance Insights for the DB instance.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using Amazon Performance Insights</a> in the <i>Amazon RDS User Guide</i>.</p>', 'RestoreDBInstanceFromS3Message$UseDefaultProcessorFeatures' => '<p>Specifies whether the DB instance class of the DB instance uses its default processor features.</p>', 'RestoreDBInstanceFromS3Message$DeletionProtection' => '<p>Specifies whether to enable deletion protection for the DB instance. The database can\'t be deleted when deletion protection is enabled. By default, deletion protection isn\'t enabled. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html"> Deleting a DB Instance</a>.</p>', 'RestoreDBInstanceFromS3Message$ManageMasterUserPassword' => '<p>Specifies whether to manage the master user password with Amazon Web Services Secrets Manager.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html">Password management with Amazon Web Services Secrets Manager</a> in the <i>Amazon RDS User Guide.</i> </p> <p>Constraints:</p> <ul> <li> <p>Can\'t manage the master user password with Amazon Web Services Secrets Manager if <code>MasterUserPassword</code> is specified.</p> </li> </ul>', 'RestoreDBInstanceFromS3Message$DedicatedLogVolume' => '<p>Specifies whether to enable a dedicated log volume (DLV) for the DB instance.</p>', 'RestoreDBInstanceToPointInTimeMessage$MultiAZ' => '<p>Secifies whether the DB instance is a Multi-AZ deployment.</p> <p>This setting doesn\'t apply to RDS Custom.</p> <p>Constraints:</p> <ul> <li> <p>You can\'t specify the <code>AvailabilityZone</code> parameter if the DB instance is a Multi-AZ deployment.</p> </li> </ul>', 'RestoreDBInstanceToPointInTimeMessage$PubliclyAccessible' => '<p>Specifies whether the DB instance is publicly accessible.</p> <p>When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB cluster\'s virtual private cloud (VPC). It resolves to the public IP address from outside of the DB cluster\'s VPC. Access to the DB cluster is ultimately controlled by the security group it uses. That public access isn\'t permitted if the security group assigned to the DB cluster doesn\'t permit it.</p> <p>When the DB instance isn\'t publicly accessible, it is an internal DB instance with a DNS name that resolves to a private IP address.</p> <p>For more information, see <a>CreateDBInstance</a>.</p>', 'RestoreDBInstanceToPointInTimeMessage$AutoMinorVersionUpgrade' => '<p>Specifies whether minor version upgrades are applied automatically to the DB instance during the maintenance window.</p> <p>This setting doesn\'t apply to RDS Custom.</p>', 'RestoreDBInstanceToPointInTimeMessage$CopyTagsToSnapshot' => '<p>Specifies whether to copy all tags from the restored DB instance to snapshots of the DB instance. By default, tags are not copied.</p>', 'RestoreDBInstanceToPointInTimeMessage$EnableIAMDatabaseAuthentication' => '<p>Specifies whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping isn\'t enabled.</p> <p>This setting doesn\'t apply to RDS Custom.</p> <p>For more information about IAM database authentication, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database Authentication for MySQL and PostgreSQL</a> in the <i>Amazon RDS User Guide.</i> </p>', 'RestoreDBInstanceToPointInTimeMessage$UseDefaultProcessorFeatures' => '<p>Specifies whether the DB instance class of the DB instance uses its default processor features.</p> <p>This setting doesn\'t apply to RDS Custom.</p>', 'RestoreDBInstanceToPointInTimeMessage$DeletionProtection' => '<p>Specifies whether the DB instance has deletion protection enabled. The database can\'t be deleted when deletion protection is enabled. By default, deletion protection isn\'t enabled. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html"> Deleting a DB Instance</a>.</p>', 'RestoreDBInstanceToPointInTimeMessage$EnableCustomerOwnedIp' => '<p>Specifies whether to enable a customer-owned IP address (CoIP) for an RDS on Outposts DB instance.</p> <p>A <i>CoIP</i> provides local or external connectivity to resources in your Outpost subnets through your on-premises network. For some use cases, a CoIP can provide lower latency for connections to the DB instance from outside of its virtual private cloud (VPC) on your local network.</p> <p>This setting doesn\'t apply to RDS Custom.</p> <p>For more information about RDS on Outposts, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Working with Amazon RDS on Amazon Web Services Outposts</a> in the <i>Amazon RDS User Guide</i>.</p> <p>For more information about CoIPs, see <a href="https://docs.aws.amazon.com/outposts/latest/userguide/routing.html#ip-addressing">Customer-owned IP addresses</a> in the <i>Amazon Web Services Outposts User Guide</i>.</p>', 'RestoreDBInstanceToPointInTimeMessage$DedicatedLogVolume' => '<p>Specifies whether to enable a dedicated log volume (DLV) for the DB instance.</p>', 'ScalingConfiguration$AutoPause' => '<p>Indicates whether to allow or disallow automatic pause for an Aurora DB cluster in <code>serverless</code> DB engine mode. A DB cluster can be paused only when it\'s idle (it has no connections).</p> <note> <p>If a DB cluster is paused for more than seven days, the DB cluster might be backed up with a snapshot. In this case, the DB cluster is restored when there is a request to connect to it.</p> </note>', 'ScalingConfigurationInfo$AutoPause' => '<p>Indicates whether automatic pause is allowed for the Aurora DB cluster in <code>serverless</code> DB engine mode.</p> <p>When the value is set to false for an Aurora Serverless v1 DB cluster, the DB cluster automatically resumes.</p>', 'StartActivityStreamRequest$ApplyImmediately' => '<p>Specifies whether or not the database activity stream is to start as soon as possible, regardless of the maintenance window for the database.</p>', 'StartActivityStreamRequest$EngineNativeAuditFieldsIncluded' => '<p>Specifies whether the database activity stream includes engine-native audit fields. This option applies to an Oracle or Microsoft SQL Server DB instance. By default, no engine-native audit fields are included.</p>', 'StartActivityStreamResponse$EngineNativeAuditFieldsIncluded' => '<p>Indicates whether engine-native audit fields are included in the database activity stream.</p>', 'StopActivityStreamRequest$ApplyImmediately' => '<p>Specifies whether or not the database activity stream is to stop as soon as possible, regardless of the maintenance window for the database.</p>', 'UpgradeTarget$SupportsParallelQuery' => '<p>Indicates whether you can use Aurora parallel query with the target engine version.</p>', 'UpgradeTarget$SupportsGlobalDatabases' => '<p>Indicates whether you can use Aurora global databases with the target engine version.</p>', 'UpgradeTarget$SupportsBabelfish' => '<p>Indicates whether you can use Babelfish for Aurora PostgreSQL with the target engine version.</p>', 'UpgradeTarget$SupportsLimitlessDatabase' => '<p>Indicates whether the DB engine version supports Aurora Limitless Database.</p>', 'UpgradeTarget$SupportsLocalWriteForwarding' => '<p>Indicates whether the target engine version supports forwarding write operations from reader DB instances to the writer DB instance in the DB cluster. By default, write operations aren\'t allowed on reader DB instances.</p> <p>Valid for: Aurora DB clusters only</p>', 'UpgradeTarget$SupportsIntegrations' => '<p>Indicates whether the DB engine version supports zero-ETL integrations with Amazon Redshift.</p>', ], ], 'BucketName' => [ 'base' => NULL, 'refs' => [ 'CreateCustomDBEngineVersionMessage$DatabaseInstallationFilesS3BucketName' => '<p>The name of an Amazon S3 bucket that contains database installation files for your CEV. For example, a valid bucket name is <code>my-custom-installation-files</code>.</p>', ], ], 'CACertificateIdentifiersList' => [ 'base' => NULL, 'refs' => [ 'DBEngineVersion$SupportedCACertificateIdentifiers' => '<p>A list of the supported CA certificate identifiers.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html">Using SSL/TLS to encrypt a connection to a DB instance</a> in the <i>Amazon RDS User Guide</i> and <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html"> Using SSL/TLS to encrypt a connection to a DB cluster</a> in the <i>Amazon Aurora User Guide</i>.</p>', ], ], 'CancelExportTaskMessage' => [ 'base' => NULL, 'refs' => [], ], 'Certificate' => [ 'base' => '<p>A CA certificate for an Amazon Web Services account.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html">Using SSL/TLS to encrypt a connection to a DB instance</a> in the <i>Amazon RDS User Guide</i> and <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html"> Using SSL/TLS to encrypt a connection to a DB cluster</a> in the <i>Amazon Aurora User Guide</i>.</p>', 'refs' => [ 'CertificateList$member' => NULL, 'ModifyCertificatesResult$Certificate' => NULL, ], ], 'CertificateDetails' => [ 'base' => '<p>The details of the DB instance’s server certificate.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html">Using SSL/TLS to encrypt a connection to a DB instance</a> in the <i>Amazon RDS User Guide</i> and <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html"> Using SSL/TLS to encrypt a connection to a DB cluster</a> in the <i>Amazon Aurora User Guide</i>.</p>', 'refs' => [ 'ClusterPendingModifiedValues$CertificateDetails' => NULL, 'DBCluster$CertificateDetails' => NULL, 'DBInstance$CertificateDetails' => '<p>The details of the DB instance\'s server certificate.</p>', ], ], 'CertificateList' => [ 'base' => NULL, 'refs' => [ 'CertificateMessage$Certificates' => '<p>The list of <code>Certificate</code> objects for the Amazon Web Services account.</p>', ], ], 'CertificateMessage' => [ 'base' => '<p>Data returned by the <b>DescribeCertificates</b> action.</p>', 'refs' => [], ], 'CertificateNotFoundFault' => [ 'base' => '<p> <code>CertificateIdentifier</code> doesn\'t refer to an existing certificate.</p>', 'refs' => [], ], 'CharacterSet' => [ 'base' => '<p>This data type is used as a response element in the action <code>DescribeDBEngineVersions</code>.</p>', 'refs' => [ 'DBEngineVersion$DefaultCharacterSet' => '<p>The default character set for new instances of this engine version, if the <code>CharacterSetName</code> parameter of the CreateDBInstance API isn\'t specified.</p>', 'SupportedCharacterSetsList$member' => NULL, ], ], 'ClientPasswordAuthType' => [ 'base' => NULL, 'refs' => [ 'UserAuthConfig$ClientPasswordAuthType' => '<p>The type of authentication the proxy uses for connections from clients.</p>', 'UserAuthConfigInfo$ClientPasswordAuthType' => '<p>The type of authentication the proxy uses for connections from clients.</p>', ], ], 'CloudwatchLogsExportConfiguration' => [ 'base' => '<p>The configuration setting for the log types to be enabled for export to CloudWatch Logs for a specific DB instance or DB cluster.</p> <p>The <code>EnableLogTypes</code> and <code>DisableLogTypes</code> arrays determine which logs will be exported (or not exported) to CloudWatch Logs. The values within these arrays depend on the DB engine being used.</p> <p>For more information about exporting CloudWatch Logs for Amazon RDS DB instances, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs </a> in the <i>Amazon RDS User Guide</i>.</p> <p>For more information about exporting CloudWatch Logs for Amazon Aurora DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon Aurora User Guide</i>.</p>', 'refs' => [ 'ModifyDBClusterMessage$CloudwatchLogsExportConfiguration' => '<p>The configuration setting for the log types to be enabled for export to CloudWatch Logs for a specific DB cluster.</p> <p>Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters</p> <p>The following values are valid for each DB engine:</p> <ul> <li> <p>Aurora MySQL - <code>audit | error | general | slowquery</code> </p> </li> <li> <p>Aurora PostgreSQL - <code>postgresql</code> </p> </li> <li> <p>RDS for MySQL - <code>error | general | slowquery</code> </p> </li> <li> <p>RDS for PostgreSQL - <code>postgresql | upgrade</code> </p> </li> </ul> <p>For more information about exporting CloudWatch Logs for Amazon RDS, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"> Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon RDS User Guide</i>.</p> <p>For more information about exporting CloudWatch Logs for Amazon Aurora, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon Aurora User Guide</i>.</p>', 'ModifyDBInstanceMessage$CloudwatchLogsExportConfiguration' => '<p>The log types to be enabled for export to CloudWatch Logs for a specific DB instance.</p> <p>A change to the <code>CloudwatchLogsExportConfiguration</code> parameter is always applied to the DB instance immediately. Therefore, the <code>ApplyImmediately</code> parameter has no effect.</p> <p>This setting doesn\'t apply to RDS Custom DB instances.</p>', ], ], 'ClusterPendingModifiedValues' => [ 'base' => '<p>This data type is used as a response element in the <code>ModifyDBCluster</code> operation and contains changes that will be applied during the next maintenance window.</p>', 'refs' => [ 'DBCluster$PendingModifiedValues' => '<p>Information about pending changes to the DB cluster. This information is returned only when there are pending changes. Specific changes are identified by subelements.</p>', ], ], 'ConnectionPoolConfiguration' => [ 'base' => '<p>Specifies the settings that control the size and behavior of the connection pool associated with a <code>DBProxyTargetGroup</code>.</p>', 'refs' => [ 'ModifyDBProxyTargetGroupRequest$ConnectionPoolConfig' => '<p>The settings that determine the size and behavior of the connection pool for the target group.</p>', ], ], 'ConnectionPoolConfigurationInfo' => [ 'base' => '<p>Displays the settings that control the size and behavior of the connection pool associated with a <code>DBProxyTarget</code>.</p>', 'refs' => [ 'DBProxyTargetGroup$ConnectionPoolConfig' => '<p>The settings that determine the size and behavior of the connection pool for the target group.</p>', ], ], 'ContextAttribute' => [ 'base' => '<p>The additional attributes of <code>RecommendedAction</code> data type.</p>', 'refs' => [ 'ContextAttributeList$member' => NULL, ], ], 'ContextAttributeList' => [ 'base' => NULL, 'refs' => [ 'RecommendedAction$ContextAttributes' => '<p>The supporting attributes to explain the recommended action.</p>', ], ], 'CopyDBClusterParameterGroupMessage' => [ 'base' => NULL, 'refs' => [], ], 'CopyDBClusterParameterGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'CopyDBClusterSnapshotMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'CopyDBClusterSnapshotResult' => [ 'base' => NULL, 'refs' => [], ], 'CopyDBParameterGroupMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'CopyDBParameterGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'CopyDBSnapshotMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'CopyDBSnapshotResult' => [ 'base' => NULL, 'refs' => [], ], 'CopyOptionGroupMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'CopyOptionGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateBlueGreenDeploymentRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateBlueGreenDeploymentResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateCustomDBEngineVersionFault' => [ 'base' => '<p>An error occurred while trying to create the CEV.</p>', 'refs' => [], ], 'CreateCustomDBEngineVersionMessage' => [ 'base' => NULL, 'refs' => [], ], 'CreateDBClusterEndpointMessage' => [ 'base' => NULL, 'refs' => [], ], 'CreateDBClusterMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'CreateDBClusterParameterGroupMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'CreateDBClusterParameterGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateDBClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateDBClusterSnapshotMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'CreateDBClusterSnapshotResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateDBInstanceMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'CreateDBInstanceReadReplicaMessage' => [ 'base' => NULL, 'refs' => [], ], 'CreateDBInstanceReadReplicaResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateDBInstanceResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateDBParameterGroupMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'CreateDBParameterGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateDBProxyEndpointRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDBProxyEndpointResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateDBProxyRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDBProxyResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateDBSecurityGroupMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'CreateDBSecurityGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateDBShardGroupMessage' => [ 'base' => NULL, 'refs' => [], ], 'CreateDBSnapshotMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'CreateDBSnapshotResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateDBSubnetGroupMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'CreateDBSubnetGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateEventSubscriptionMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'CreateEventSubscriptionResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateGlobalClusterMessage' => [ 'base' => NULL, 'refs' => [], ], 'CreateGlobalClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateIntegrationMessage' => [ 'base' => NULL, 'refs' => [], ], 'CreateOptionGroupMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'CreateOptionGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateTenantDatabaseMessage' => [ 'base' => NULL, 'refs' => [], ], 'CreateTenantDatabaseResult' => [ 'base' => NULL, 'refs' => [], ], 'CustomAvailabilityZoneNotFoundFault' => [ 'base' => '<p> <code>CustomAvailabilityZoneId</code> doesn\'t refer to an existing custom Availability Zone identifier.</p>', 'refs' => [], ], 'CustomDBEngineVersionAMI' => [ 'base' => '<p>A value that indicates the AMI information.</p>', 'refs' => [ 'DBEngineVersion$Image' => '<p>The EC2 image</p>', ], ], 'CustomDBEngineVersionAlreadyExistsFault' => [ 'base' => '<p>A CEV with the specified name already exists.</p>', 'refs' => [], ], 'CustomDBEngineVersionManifest' => [ 'base' => NULL, 'refs' => [ 'CreateCustomDBEngineVersionMessage$Manifest' => '<p>The CEV manifest, which is a JSON document that describes the installation .zip files stored in Amazon S3. Specify the name/value pairs in a file or a quoted string. RDS Custom applies the patches in the order in which they are listed.</p> <p>The following JSON fields are valid:</p> <dl> <dt>MediaImportTemplateVersion</dt> <dd> <p>Version of the CEV manifest. The date is in the format <code>YYYY-MM-DD</code>.</p> </dd> <dt>databaseInstallationFileNames</dt> <dd> <p>Ordered list of installation files for the CEV.</p> </dd> <dt>opatchFileNames</dt> <dd> <p>Ordered list of OPatch installers used for the Oracle DB engine.</p> </dd> <dt>psuRuPatchFileNames</dt> <dd> <p>The PSU and RU patches for this CEV.</p> </dd> <dt>OtherPatchFileNames</dt> <dd> <p>The patches that are not in the list of PSU and RU patches. Amazon RDS applies these patches after applying the PSU and RU patches.</p> </dd> </dl> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-cev.html#custom-cev.preparing.manifest"> Creating the CEV manifest</a> in the <i>Amazon RDS User Guide</i>.</p>', 'DBEngineVersion$CustomDBEngineVersionManifest' => '<p>JSON string that lists the installation files and parameters that RDS Custom uses to create a custom engine version (CEV). RDS Custom applies the patches in the order in which they\'re listed in the manifest. You can set the Oracle home, Oracle base, and UNIX/Linux user and group using the installation parameters. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-cev.preparing.html#custom-cev.preparing.manifest.fields">JSON fields in the CEV manifest</a> in the <i>Amazon RDS User Guide</i>. </p>', ], ], 'CustomDBEngineVersionNotFoundFault' => [ 'base' => '<p>The specified CEV was not found.</p>', 'refs' => [], ], 'CustomDBEngineVersionQuotaExceededFault' => [ 'base' => '<p>You have exceeded your CEV quota.</p>', 'refs' => [], ], 'CustomEngineName' => [ 'base' => NULL, 'refs' => [ 'CreateCustomDBEngineVersionMessage$Engine' => '<p>The database engine. RDS Custom for Oracle supports the following values:</p> <ul> <li> <p> <code>custom-oracle-ee</code> </p> </li> <li> <p> <code>custom-oracle-ee-cdb</code> </p> </li> <li> <p> <code>custom-oracle-se2</code> </p> </li> <li> <p> <code>custom-oracle-se2-cdb</code> </p> </li> </ul>', 'DeleteCustomDBEngineVersionMessage$Engine' => '<p>The database engine. RDS Custom for Oracle supports the following values:</p> <ul> <li> <p> <code>custom-oracle-ee</code> </p> </li> <li> <p> <code>custom-oracle-ee-cdb</code> </p> </li> <li> <p> <code>custom-oracle-se2</code> </p> </li> <li> <p> <code>custom-oracle-se2-cdb</code> </p> </li> </ul>', 'ModifyCustomDBEngineVersionMessage$Engine' => '<p>The database engine. RDS Custom for Oracle supports the following values:</p> <ul> <li> <p> <code>custom-oracle-ee</code> </p> </li> <li> <p> <code>custom-oracle-ee-cdb</code> </p> </li> <li> <p> <code>custom-oracle-se2</code> </p> </li> <li> <p> <code>custom-oracle-se2-cdb</code> </p> </li> </ul>', ], ], 'CustomEngineVersion' => [ 'base' => NULL, 'refs' => [ 'CreateCustomDBEngineVersionMessage$EngineVersion' => '<p>The name of your CEV. The name format is 19.<i>customized_string</i>. For example, a valid CEV name is <code>19.my_cev1</code>. This setting is required for RDS Custom for Oracle, but optional for Amazon RDS. The combination of <code>Engine</code> and <code>EngineVersion</code> is unique per customer per Region.</p>', 'DeleteCustomDBEngineVersionMessage$EngineVersion' => '<p>The custom engine version (CEV) for your DB instance. This option is required for RDS Custom, but optional for Amazon RDS. The combination of <code>Engine</code> and <code>EngineVersion</code> is unique per customer per Amazon Web Services Region.</p>', 'ModifyCustomDBEngineVersionMessage$EngineVersion' => '<p>The custom engine version (CEV) that you want to modify. This option is required for RDS Custom for Oracle, but optional for Amazon RDS. The combination of <code>Engine</code> and <code>EngineVersion</code> is unique per customer per Amazon Web Services Region.</p>', ], ], 'CustomEngineVersionStatus' => [ 'base' => NULL, 'refs' => [ 'ModifyCustomDBEngineVersionMessage$Status' => '<p>The availability status to be assigned to the CEV. Valid values are as follows:</p> <dl> <dt>available</dt> <dd> <p>You can use this CEV to create a new RDS Custom DB instance.</p> </dd> <dt>inactive</dt> <dd> <p>You can create a new RDS Custom instance by restoring a DB snapshot with this CEV. You can\'t patch or create new instances with this CEV.</p> </dd> </dl> <p>You can change any status to any status. A typical reason to change status is to prevent the accidental use of a CEV, or to make a deprecated CEV eligible for use again. For example, you might change the status of your CEV from <code>available</code> to <code>inactive</code>, and from <code>inactive</code> back to <code>available</code>. To change the availability status of the CEV, it must not currently be in use by an RDS Custom instance, snapshot, or automated backup.</p>', ], ], 'DBCluster' => [ 'base' => '<p>Contains the details of an Amazon Aurora DB cluster or Multi-AZ DB cluster.</p> <p>For an Amazon Aurora DB cluster, this data type is used as a response element in the operations <code>CreateDBCluster</code>, <code>DeleteDBCluster</code>, <code>DescribeDBClusters</code>, <code>FailoverDBCluster</code>, <code>ModifyDBCluster</code>, <code>PromoteReadReplicaDBCluster</code>, <code>RestoreDBClusterFromS3</code>, <code>RestoreDBClusterFromSnapshot</code>, <code>RestoreDBClusterToPointInTime</code>, <code>StartDBCluster</code>, and <code>StopDBCluster</code>.</p> <p>For a Multi-AZ DB cluster, this data type is used as a response element in the operations <code>CreateDBCluster</code>, <code>DeleteDBCluster</code>, <code>DescribeDBClusters</code>, <code>FailoverDBCluster</code>, <code>ModifyDBCluster</code>, <code>RebootDBCluster</code>, <code>RestoreDBClusterFromSnapshot</code>, and <code>RestoreDBClusterToPointInTime</code>.</p> <p>For more information on Amazon Aurora DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon Aurora?</a> in the <i>Amazon Aurora User Guide.</i> </p> <p>For more information on Multi-AZ DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ deployments with two readable standby DB instances</a> in the <i>Amazon RDS User Guide.</i> </p>', 'refs' => [ 'CreateDBClusterResult$DBCluster' => NULL, 'DBClusterList$member' => NULL, 'DeleteDBClusterResult$DBCluster' => NULL, 'FailoverDBClusterResult$DBCluster' => NULL, 'ModifyDBClusterResult$DBCluster' => NULL, 'PromoteReadReplicaDBClusterResult$DBCluster' => NULL, 'RebootDBClusterResult$DBCluster' => NULL, 'RestoreDBClusterFromS3Result$DBCluster' => NULL, 'RestoreDBClusterFromSnapshotResult$DBCluster' => NULL, 'RestoreDBClusterToPointInTimeResult$DBCluster' => NULL, 'StartDBClusterResult$DBCluster' => NULL, 'StopDBClusterResult$DBCluster' => NULL, ], ], 'DBClusterAlreadyExistsFault' => [ 'base' => '<p>The user already has a DB cluster with the given identifier.</p>', 'refs' => [], ], 'DBClusterAutomatedBackup' => [ 'base' => '<p>An automated backup of a DB cluster. It consists of system backups, transaction logs, and the database cluster properties that existed at the time you deleted the source cluster.</p>', 'refs' => [ 'DBClusterAutomatedBackupList$member' => NULL, 'DeleteDBClusterAutomatedBackupResult$DBClusterAutomatedBackup' => NULL, ], ], 'DBClusterAutomatedBackupList' => [ 'base' => NULL, 'refs' => [ 'DBClusterAutomatedBackupMessage$DBClusterAutomatedBackups' => '<p>A list of <code>DBClusterAutomatedBackup</code> backups.</p>', ], ], 'DBClusterAutomatedBackupMessage' => [ 'base' => NULL, 'refs' => [], ], 'DBClusterAutomatedBackupNotFoundFault' => [ 'base' => '<p>No automated backup for this DB cluster was found.</p>', 'refs' => [], ], 'DBClusterAutomatedBackupQuotaExceededFault' => [ 'base' => '<p>The quota for retained automated backups was exceeded. This prevents you from retaining any additional automated backups. The retained automated backups quota is the same as your DB cluster quota.</p>', 'refs' => [], ], 'DBClusterBacktrack' => [ 'base' => '<p>This data type is used as a response element in the <code>DescribeDBClusterBacktracks</code> action.</p>', 'refs' => [ 'DBClusterBacktrackList$member' => NULL, ], ], 'DBClusterBacktrackList' => [ 'base' => NULL, 'refs' => [ 'DBClusterBacktrackMessage$DBClusterBacktracks' => '<p>Contains a list of backtracks for the user.</p>', ], ], 'DBClusterBacktrackMessage' => [ 'base' => '<p>Contains the result of a successful invocation of the <code>DescribeDBClusterBacktracks</code> action.</p>', 'refs' => [], ], 'DBClusterBacktrackNotFoundFault' => [ 'base' => '<p> <code>BacktrackIdentifier</code> doesn\'t refer to an existing backtrack.</p>', 'refs' => [], ], 'DBClusterCapacityInfo' => [ 'base' => NULL, 'refs' => [], ], 'DBClusterEndpoint' => [ 'base' => '<p>This data type represents the information you need to connect to an Amazon Aurora DB cluster. This data type is used as a response element in the following actions:</p> <ul> <li> <p> <code>CreateDBClusterEndpoint</code> </p> </li> <li> <p> <code>DescribeDBClusterEndpoints</code> </p> </li> <li> <p> <code>ModifyDBClusterEndpoint</code> </p> </li> <li> <p> <code>DeleteDBClusterEndpoint</code> </p> </li> </ul> <p>For the data structure that represents Amazon RDS DB instance endpoints, see <code>Endpoint</code>.</p>', 'refs' => [ 'DBClusterEndpointList$member' => NULL, ], ], 'DBClusterEndpointAlreadyExistsFault' => [ 'base' => '<p>The specified custom endpoint can\'t be created because it already exists.</p>', 'refs' => [], ], 'DBClusterEndpointList' => [ 'base' => NULL, 'refs' => [ 'DBClusterEndpointMessage$DBClusterEndpoints' => '<p>Contains the details of the endpoints associated with the cluster and matching any filter conditions.</p>', ], ], 'DBClusterEndpointMessage' => [ 'base' => NULL, 'refs' => [], ], 'DBClusterEndpointNotFoundFault' => [ 'base' => '<p>The specified custom endpoint doesn\'t exist.</p>', 'refs' => [], ], 'DBClusterEndpointQuotaExceededFault' => [ 'base' => '<p>The cluster already has the maximum number of custom endpoints.</p>', 'refs' => [], ], 'DBClusterIdentifier' => [ 'base' => NULL, 'refs' => [ 'FailoverGlobalClusterMessage$TargetDbClusterIdentifier' => '<p>The identifier of the secondary Aurora DB cluster that you want to promote to the primary for the global database cluster. Use the Amazon Resource Name (ARN) for the identifier so that Aurora can locate the cluster in its Amazon Web Services Region.</p>', 'SwitchoverGlobalClusterMessage$TargetDbClusterIdentifier' => '<p>The identifier of the secondary Aurora DB cluster to promote to the new primary for the global database cluster. Use the Amazon Resource Name (ARN) for the identifier so that Aurora can locate the cluster in its Amazon Web Services Region.</p>', ], ], 'DBClusterList' => [ 'base' => NULL, 'refs' => [ 'DBClusterMessage$DBClusters' => '<p>Contains a list of DB clusters for the user.</p>', ], ], 'DBClusterMember' => [ 'base' => '<p>Contains information about an instance that is part of a DB cluster.</p>', 'refs' => [ 'DBClusterMemberList$member' => NULL, ], ], 'DBClusterMemberList' => [ 'base' => NULL, 'refs' => [ 'DBCluster$DBClusterMembers' => '<p>The list of DB instances that make up the DB cluster.</p>', ], ], 'DBClusterMessage' => [ 'base' => '<p>Contains the result of a successful invocation of the <code>DescribeDBClusters</code> action.</p>', 'refs' => [], ], 'DBClusterNotFoundFault' => [ 'base' => '<p> <code>DBClusterIdentifier</code> doesn\'t refer to an existing DB cluster.</p>', 'refs' => [], ], 'DBClusterOptionGroupMemberships' => [ 'base' => NULL, 'refs' => [ 'DBCluster$DBClusterOptionGroupMemberships' => '<p>The list of option group memberships for this DB cluster.</p>', ], ], 'DBClusterOptionGroupStatus' => [ 'base' => '<p>Contains status information for a DB cluster option group.</p>', 'refs' => [ 'DBClusterOptionGroupMemberships$member' => NULL, ], ], 'DBClusterParameterGroup' => [ 'base' => '<p>Contains the details of an Amazon RDS DB cluster parameter group.</p> <p>This data type is used as a response element in the <code>DescribeDBClusterParameterGroups</code> action.</p>', 'refs' => [ 'CopyDBClusterParameterGroupResult$DBClusterParameterGroup' => NULL, 'CreateDBClusterParameterGroupResult$DBClusterParameterGroup' => NULL, 'DBClusterParameterGroupList$member' => NULL, ], ], 'DBClusterParameterGroupDetails' => [ 'base' => '<p>Provides details about a DB cluster parameter group including the parameters in the DB cluster parameter group.</p>', 'refs' => [], ], 'DBClusterParameterGroupList' => [ 'base' => NULL, 'refs' => [ 'DBClusterParameterGroupsMessage$DBClusterParameterGroups' => '<p>A list of DB cluster parameter groups.</p>', ], ], 'DBClusterParameterGroupNameMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DBClusterParameterGroupNotFoundFault' => [ 'base' => '<p> <code>DBClusterParameterGroupName</code> doesn\'t refer to an existing DB cluster parameter group.</p>', 'refs' => [], ], 'DBClusterParameterGroupsMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DBClusterQuotaExceededFault' => [ 'base' => '<p>The user attempted to create a new DB cluster and the user has already reached the maximum allowed DB cluster quota.</p>', 'refs' => [], ], 'DBClusterRole' => [ 'base' => '<p>Describes an Amazon Web Services Identity and Access Management (IAM) role that is associated with a DB cluster.</p>', 'refs' => [ 'DBClusterRoles$member' => NULL, ], ], 'DBClusterRoleAlreadyExistsFault' => [ 'base' => '<p>The specified IAM role Amazon Resource Name (ARN) is already associated with the specified DB cluster.</p>', 'refs' => [], ], 'DBClusterRoleNotFoundFault' => [ 'base' => '<p>The specified IAM role Amazon Resource Name (ARN) isn\'t associated with the specified DB cluster.</p>', 'refs' => [], ], 'DBClusterRoleQuotaExceededFault' => [ 'base' => '<p>You have exceeded the maximum number of IAM roles that can be associated with the specified DB cluster.</p>', 'refs' => [], ], 'DBClusterRoles' => [ 'base' => NULL, 'refs' => [ 'DBCluster$AssociatedRoles' => '<p>A list of the Amazon Web Services Identity and Access Management (IAM) roles that are associated with the DB cluster. IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other Amazon Web Services on your behalf.</p>', ], ], 'DBClusterSnapshot' => [ 'base' => '<p>Contains the details for an Amazon RDS DB cluster snapshot</p> <p>This data type is used as a response element in the <code>DescribeDBClusterSnapshots</code> action.</p>', 'refs' => [ 'CopyDBClusterSnapshotResult$DBClusterSnapshot' => NULL, 'CreateDBClusterSnapshotResult$DBClusterSnapshot' => NULL, 'DBClusterSnapshotList$member' => NULL, 'DeleteDBClusterSnapshotResult$DBClusterSnapshot' => NULL, ], ], 'DBClusterSnapshotAlreadyExistsFault' => [ 'base' => '<p>The user already has a DB cluster snapshot with the given identifier.</p>', 'refs' => [], ], 'DBClusterSnapshotAttribute' => [ 'base' => '<p>Contains the name and values of a manual DB cluster snapshot attribute.</p> <p>Manual DB cluster snapshot attributes are used to authorize other Amazon Web Services accounts to restore a manual DB cluster snapshot. For more information, see the <code>ModifyDBClusterSnapshotAttribute</code> API action.</p>', 'refs' => [ 'DBClusterSnapshotAttributeList$member' => NULL, ], ], 'DBClusterSnapshotAttributeList' => [ 'base' => NULL, 'refs' => [ 'DBClusterSnapshotAttributesResult$DBClusterSnapshotAttributes' => '<p>The list of attributes and values for the manual DB cluster snapshot.</p>', ], ], 'DBClusterSnapshotAttributesResult' => [ 'base' => '<p>Contains the results of a successful call to the <code>DescribeDBClusterSnapshotAttributes</code> API action.</p> <p>Manual DB cluster snapshot attributes are used to authorize other Amazon Web Services accounts to copy or restore a manual DB cluster snapshot. For more information, see the <code>ModifyDBClusterSnapshotAttribute</code> API action.</p>', 'refs' => [ 'DescribeDBClusterSnapshotAttributesResult$DBClusterSnapshotAttributesResult' => NULL, 'ModifyDBClusterSnapshotAttributeResult$DBClusterSnapshotAttributesResult' => NULL, ], ], 'DBClusterSnapshotList' => [ 'base' => NULL, 'refs' => [ 'DBClusterSnapshotMessage$DBClusterSnapshots' => '<p>Provides a list of DB cluster snapshots for the user.</p>', ], ], 'DBClusterSnapshotMessage' => [ 'base' => '<p>Provides a list of DB cluster snapshots for the user as the result of a call to the <code>DescribeDBClusterSnapshots</code> action.</p>', 'refs' => [], ], 'DBClusterSnapshotNotFoundFault' => [ 'base' => '<p> <code>DBClusterSnapshotIdentifier</code> doesn\'t refer to an existing DB cluster snapshot.</p>', 'refs' => [], ], 'DBClusterStatusInfo' => [ 'base' => '<p>Reserved for future use.</p>', 'refs' => [ 'DBClusterStatusInfoList$member' => NULL, ], ], 'DBClusterStatusInfoList' => [ 'base' => NULL, 'refs' => [ 'DBCluster$StatusInfos' => '<p>Reserved for future use.</p>', ], ], 'DBEngineVersion' => [ 'base' => '<p>This data type is used as a response element in the action <code>DescribeDBEngineVersions</code>.</p>', 'refs' => [ 'DBEngineVersionList$member' => NULL, ], ], 'DBEngineVersionList' => [ 'base' => NULL, 'refs' => [ 'DBEngineVersionMessage$DBEngineVersions' => '<p>A list of <code>DBEngineVersion</code> elements.</p>', ], ], 'DBEngineVersionMessage' => [ 'base' => '<p>Contains the result of a successful invocation of the <code>DescribeDBEngineVersions</code> action.</p>', 'refs' => [], ], 'DBInstance' => [ 'base' => '<p>Contains the details of an Amazon RDS DB instance.</p> <p>This data type is used as a response element in the operations <code>CreateDBInstance</code>, <code>CreateDBInstanceReadReplica</code>, <code>DeleteDBInstance</code>, <code>DescribeDBInstances</code>, <code>ModifyDBInstance</code>, <code>PromoteReadReplica</code>, <code>RebootDBInstance</code>, <code>RestoreDBInstanceFromDBSnapshot</code>, <code>RestoreDBInstanceFromS3</code>, <code>RestoreDBInstanceToPointInTime</code>, <code>StartDBInstance</code>, and <code>StopDBInstance</code>.</p>', 'refs' => [ 'CreateDBInstanceReadReplicaResult$DBInstance' => NULL, 'CreateDBInstanceResult$DBInstance' => NULL, 'DBInstanceList$member' => NULL, 'DeleteDBInstanceResult$DBInstance' => NULL, 'ModifyDBInstanceResult$DBInstance' => NULL, 'PromoteReadReplicaResult$DBInstance' => NULL, 'RebootDBInstanceResult$DBInstance' => NULL, 'RestoreDBInstanceFromDBSnapshotResult$DBInstance' => NULL, 'RestoreDBInstanceFromS3Result$DBInstance' => NULL, 'RestoreDBInstanceToPointInTimeResult$DBInstance' => NULL, 'StartDBInstanceResult$DBInstance' => NULL, 'StopDBInstanceResult$DBInstance' => NULL, 'SwitchoverReadReplicaResult$DBInstance' => NULL, ], ], 'DBInstanceAlreadyExistsFault' => [ 'base' => '<p>The user already has a DB instance with the given identifier.</p>', 'refs' => [], ], 'DBInstanceAutomatedBackup' => [ 'base' => '<p>An automated backup of a DB instance. It consists of system backups, transaction logs, and the database instance properties that existed at the time you deleted the source instance.</p>', 'refs' => [ 'DBInstanceAutomatedBackupList$member' => NULL, 'DeleteDBInstanceAutomatedBackupResult$DBInstanceAutomatedBackup' => NULL, 'StartDBInstanceAutomatedBackupsReplicationResult$DBInstanceAutomatedBackup' => NULL, 'StopDBInstanceAutomatedBackupsReplicationResult$DBInstanceAutomatedBackup' => NULL, ], ], 'DBInstanceAutomatedBackupList' => [ 'base' => NULL, 'refs' => [ 'DBInstanceAutomatedBackupMessage$DBInstanceAutomatedBackups' => '<p>A list of <code>DBInstanceAutomatedBackup</code> instances.</p>', ], ], 'DBInstanceAutomatedBackupMessage' => [ 'base' => '<p>Contains the result of a successful invocation of the <code>DescribeDBInstanceAutomatedBackups</code> action.</p>', 'refs' => [], ], 'DBInstanceAutomatedBackupNotFoundFault' => [ 'base' => '<p>No automated backup for this DB instance was found.</p>', 'refs' => [], ], 'DBInstanceAutomatedBackupQuotaExceededFault' => [ 'base' => '<p>The quota for retained automated backups was exceeded. This prevents you from retaining any additional automated backups. The retained automated backups quota is the same as your DB instance quota.</p>', 'refs' => [], ], 'DBInstanceAutomatedBackupsReplication' => [ 'base' => '<p>Automated backups of a DB instance replicated to another Amazon Web Services Region. They consist of system backups, transaction logs, and database instance properties.</p>', 'refs' => [ 'DBInstanceAutomatedBackupsReplicationList$member' => NULL, ], ], 'DBInstanceAutomatedBackupsReplicationList' => [ 'base' => NULL, 'refs' => [ 'DBInstance$DBInstanceAutomatedBackupsReplications' => '<p>The list of replicated automated backups associated with the DB instance.</p>', 'DBInstanceAutomatedBackup$DBInstanceAutomatedBackupsReplications' => '<p>The list of replications to different Amazon Web Services Regions associated with the automated backup.</p>', ], ], 'DBInstanceList' => [ 'base' => NULL, 'refs' => [ 'DBInstanceMessage$DBInstances' => '<p>A list of <code>DBInstance</code> instances.</p>', ], ], 'DBInstanceMessage' => [ 'base' => '<p>Contains the result of a successful invocation of the <code>DescribeDBInstances</code> action.</p>', 'refs' => [], ], 'DBInstanceNotFoundFault' => [ 'base' => '<p> <code>DBInstanceIdentifier</code> doesn\'t refer to an existing DB instance.</p>', 'refs' => [], ], 'DBInstanceRole' => [ 'base' => '<p>Information about an Amazon Web Services Identity and Access Management (IAM) role that is associated with a DB instance.</p>', 'refs' => [ 'DBInstanceRoles$member' => NULL, ], ], 'DBInstanceRoleAlreadyExistsFault' => [ 'base' => '<p>The specified <code>RoleArn</code> or <code>FeatureName</code> value is already associated with the DB instance.</p>', 'refs' => [], ], 'DBInstanceRoleNotFoundFault' => [ 'base' => '<p>The specified <code>RoleArn</code> value doesn\'t match the specified feature for the DB instance.</p>', 'refs' => [], ], 'DBInstanceRoleQuotaExceededFault' => [ 'base' => '<p>You can\'t associate any more Amazon Web Services Identity and Access Management (IAM) roles with the DB instance because the quota has been reached.</p>', 'refs' => [], ], 'DBInstanceRoles' => [ 'base' => NULL, 'refs' => [ 'DBInstance$AssociatedRoles' => '<p>The Amazon Web Services Identity and Access Management (IAM) roles associated with the DB instance.</p>', ], ], 'DBInstanceStatusInfo' => [ 'base' => '<p>Provides a list of status information for a DB instance.</p>', 'refs' => [ 'DBInstanceStatusInfoList$member' => NULL, ], ], 'DBInstanceStatusInfoList' => [ 'base' => NULL, 'refs' => [ 'DBInstance$StatusInfos' => '<p>The status of a read replica. If the DB instance isn\'t a read replica, the value is blank.</p>', ], ], 'DBLogFileNotFoundFault' => [ 'base' => '<p> <code>LogFileName</code> doesn\'t refer to an existing DB log file.</p>', 'refs' => [], ], 'DBParameterGroup' => [ 'base' => '<p>Contains the details of an Amazon RDS DB parameter group.</p> <p>This data type is used as a response element in the <code>DescribeDBParameterGroups</code> action.</p>', 'refs' => [ 'CopyDBParameterGroupResult$DBParameterGroup' => NULL, 'CreateDBParameterGroupResult$DBParameterGroup' => NULL, 'DBParameterGroupList$member' => NULL, ], ], 'DBParameterGroupAlreadyExistsFault' => [ 'base' => '<p>A DB parameter group with the same name exists.</p>', 'refs' => [], ], 'DBParameterGroupDetails' => [ 'base' => '<p>Contains the result of a successful invocation of the <code>DescribeDBParameters</code> action.</p>', 'refs' => [], ], 'DBParameterGroupList' => [ 'base' => NULL, 'refs' => [ 'DBParameterGroupsMessage$DBParameterGroups' => '<p>A list of <code>DBParameterGroup</code> instances.</p>', ], ], 'DBParameterGroupNameMessage' => [ 'base' => '<p>Contains the result of a successful invocation of the <code>ModifyDBParameterGroup</code> or <code>ResetDBParameterGroup</code> operation.</p>', 'refs' => [], ], 'DBParameterGroupNotFoundFault' => [ 'base' => '<p> <code>DBParameterGroupName</code> doesn\'t refer to an existing DB parameter group.</p>', 'refs' => [], ], 'DBParameterGroupQuotaExceededFault' => [ 'base' => '<p>The request would result in the user exceeding the allowed number of DB parameter groups.</p>', 'refs' => [], ], 'DBParameterGroupStatus' => [ 'base' => '<p>The status of the DB parameter group.</p> <p>This data type is used as a response element in the following actions:</p> <ul> <li> <p> <code>CreateDBInstance</code> </p> </li> <li> <p> <code>CreateDBInstanceReadReplica</code> </p> </li> <li> <p> <code>DeleteDBInstance</code> </p> </li> <li> <p> <code>ModifyDBInstance</code> </p> </li> <li> <p> <code>RebootDBInstance</code> </p> </li> <li> <p> <code>RestoreDBInstanceFromDBSnapshot</code> </p> </li> </ul>', 'refs' => [ 'DBParameterGroupStatusList$member' => NULL, ], ], 'DBParameterGroupStatusList' => [ 'base' => NULL, 'refs' => [ 'DBInstance$DBParameterGroups' => '<p>The list of DB parameter groups applied to this DB instance.</p>', ], ], 'DBParameterGroupsMessage' => [ 'base' => '<p>Contains the result of a successful invocation of the <code>DescribeDBParameterGroups</code> action.</p>', 'refs' => [], ], 'DBProxy' => [ 'base' => '<p>The data structure representing a proxy managed by the RDS Proxy.</p> <p>This data type is used as a response element in the <code>DescribeDBProxies</code> action.</p>', 'refs' => [ 'CreateDBProxyResponse$DBProxy' => '<p>The <code>DBProxy</code> structure corresponding to the new proxy.</p>', 'DBProxyList$member' => NULL, 'DeleteDBProxyResponse$DBProxy' => '<p>The data structure representing the details of the DB proxy that you delete.</p>', 'ModifyDBProxyResponse$DBProxy' => '<p>The <code>DBProxy</code> object representing the new settings for the proxy.</p>', ], ], 'DBProxyAlreadyExistsFault' => [ 'base' => '<p>The specified proxy name must be unique for all proxies owned by your Amazon Web Services account in the specified Amazon Web Services Region.</p>', 'refs' => [], ], 'DBProxyEndpoint' => [ 'base' => '<p>The data structure representing an endpoint associated with a DB proxy. RDS automatically creates one endpoint for each DB proxy. For Aurora DB clusters, you can associate additional endpoints with the same DB proxy. These endpoints can be read/write or read-only. They can also reside in different VPCs than the associated DB proxy.</p> <p>This data type is used as a response element in the <code>DescribeDBProxyEndpoints</code> operation.</p>', 'refs' => [ 'CreateDBProxyEndpointResponse$DBProxyEndpoint' => '<p>The <code>DBProxyEndpoint</code> object that is created by the API operation. The DB proxy endpoint that you create might provide capabilities such as read/write or read-only operations, or using a different VPC than the proxy\'s default VPC.</p>', 'DBProxyEndpointList$member' => NULL, 'DeleteDBProxyEndpointResponse$DBProxyEndpoint' => '<p>The data structure representing the details of the DB proxy endpoint that you delete.</p>', 'ModifyDBProxyEndpointResponse$DBProxyEndpoint' => '<p>The <code>DBProxyEndpoint</code> object representing the new settings for the DB proxy endpoint.</p>', ], ], 'DBProxyEndpointAlreadyExistsFault' => [ 'base' => '<p>The specified DB proxy endpoint name must be unique for all DB proxy endpoints owned by your Amazon Web Services account in the specified Amazon Web Services Region.</p>', 'refs' => [], ], 'DBProxyEndpointList' => [ 'base' => NULL, 'refs' => [ 'DescribeDBProxyEndpointsResponse$DBProxyEndpoints' => '<p>The list of <code>ProxyEndpoint</code> objects returned by the API operation.</p>', ], ], 'DBProxyEndpointName' => [ 'base' => NULL, 'refs' => [ 'CreateDBProxyEndpointRequest$DBProxyEndpointName' => '<p>The name of the DB proxy endpoint to create.</p>', 'DeleteDBProxyEndpointRequest$DBProxyEndpointName' => '<p>The name of the DB proxy endpoint to delete.</p>', 'DescribeDBProxyEndpointsRequest$DBProxyEndpointName' => '<p>The name of a DB proxy endpoint to describe. If you omit this parameter, the output includes information about all DB proxy endpoints associated with the specified proxy.</p>', 'ModifyDBProxyEndpointRequest$DBProxyEndpointName' => '<p>The name of the DB proxy sociated with the DB proxy endpoint that you want to modify.</p>', 'ModifyDBProxyEndpointRequest$NewDBProxyEndpointName' => '<p>The new identifier for the <code>DBProxyEndpoint</code>. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can\'t end with a hyphen or contain two consecutive hyphens.</p>', ], ], 'DBProxyEndpointNotFoundFault' => [ 'base' => '<p>The DB proxy endpoint doesn\'t exist.</p>', 'refs' => [], ], 'DBProxyEndpointQuotaExceededFault' => [ 'base' => '<p>The DB proxy already has the maximum number of endpoints.</p>', 'refs' => [], ], 'DBProxyEndpointStatus' => [ 'base' => NULL, 'refs' => [ 'DBProxyEndpoint$Status' => '<p>The current status of this DB proxy endpoint. A status of <code>available</code> means the endpoint is ready to handle requests. Other values indicate that you must wait for the endpoint to be ready, or take some action to resolve an issue.</p>', ], ], 'DBProxyEndpointTargetRole' => [ 'base' => NULL, 'refs' => [ 'CreateDBProxyEndpointRequest$TargetRole' => '<p>The role of the DB proxy endpoint. The role determines whether the endpoint can be used for read/write or only read operations. The default is <code>READ_WRITE</code>. The only role that proxies for RDS for Microsoft SQL Server support is <code>READ_WRITE</code>.</p>', 'DBProxyEndpoint$TargetRole' => '<p>A value that indicates whether the DB proxy endpoint can be used for read/write or read-only operations.</p>', ], ], 'DBProxyList' => [ 'base' => NULL, 'refs' => [ 'DescribeDBProxiesResponse$DBProxies' => '<p>A return value representing an arbitrary number of <code>DBProxy</code> data structures.</p>', ], ], 'DBProxyName' => [ 'base' => NULL, 'refs' => [ 'CreateDBProxyEndpointRequest$DBProxyName' => '<p>The name of the DB proxy associated with the DB proxy endpoint that you create.</p>', 'DescribeDBProxyEndpointsRequest$DBProxyName' => '<p>The name of the DB proxy whose endpoints you want to describe. If you omit this parameter, the output includes information about all DB proxy endpoints associated with all your DB proxies.</p>', ], ], 'DBProxyNotFoundFault' => [ 'base' => '<p>The specified proxy name doesn\'t correspond to a proxy owned by your Amazon Web Services account in the specified Amazon Web Services Region.</p>', 'refs' => [], ], 'DBProxyQuotaExceededFault' => [ 'base' => '<p>Your Amazon Web Services account already has the maximum number of proxies in the specified Amazon Web Services Region.</p>', 'refs' => [], ], 'DBProxyStatus' => [ 'base' => NULL, 'refs' => [ 'DBProxy$Status' => '<p>The current status of this proxy. A status of <code>available</code> means the proxy is ready to handle requests. Other values indicate that you must wait for the proxy to be ready, or take some action to resolve an issue.</p>', ], ], 'DBProxyTarget' => [ 'base' => '<p>Contains the details for an RDS Proxy target. It represents an RDS DB instance or Aurora DB cluster that the proxy can connect to. One or more targets are associated with an RDS Proxy target group.</p> <p>This data type is used as a response element in the <code>DescribeDBProxyTargets</code> action.</p>', 'refs' => [ 'TargetList$member' => NULL, ], ], 'DBProxyTargetAlreadyRegisteredFault' => [ 'base' => '<p>The proxy is already associated with the specified RDS DB instance or Aurora DB cluster.</p>', 'refs' => [], ], 'DBProxyTargetGroup' => [ 'base' => '<p>Represents a set of RDS DB instances, Aurora DB clusters, or both that a proxy can connect to. Currently, each target group is associated with exactly one RDS DB instance or Aurora DB cluster.</p> <p>This data type is used as a response element in the <code>DescribeDBProxyTargetGroups</code> action.</p>', 'refs' => [ 'ModifyDBProxyTargetGroupResponse$DBProxyTargetGroup' => '<p>The settings of the modified <code>DBProxyTarget</code>.</p>', 'TargetGroupList$member' => NULL, ], ], 'DBProxyTargetGroupNotFoundFault' => [ 'base' => '<p>The specified target group isn\'t available for a proxy owned by your Amazon Web Services account in the specified Amazon Web Services Region.</p>', 'refs' => [], ], 'DBProxyTargetNotFoundFault' => [ 'base' => '<p>The specified RDS DB instance or Aurora DB cluster isn\'t available for a proxy owned by your Amazon Web Services account in the specified Amazon Web Services Region.</p>', 'refs' => [], ], 'DBRecommendation' => [ 'base' => '<p>The recommendation for your DB instances, DB clusters, and DB parameter groups.</p>', 'refs' => [ 'DBRecommendationList$member' => NULL, 'DBRecommendationMessage$DBRecommendation' => NULL, ], ], 'DBRecommendationList' => [ 'base' => NULL, 'refs' => [ 'DBRecommendationsMessage$DBRecommendations' => '<p>A list of recommendations which is returned from <code>DescribeDBRecommendations</code> API request.</p>', ], ], 'DBRecommendationMessage' => [ 'base' => NULL, 'refs' => [], ], 'DBRecommendationsMessage' => [ 'base' => NULL, 'refs' => [], ], 'DBSecurityGroup' => [ 'base' => '<p>Contains the details for an Amazon RDS DB security group.</p> <p>This data type is used as a response element in the <code>DescribeDBSecurityGroups</code> action.</p>', 'refs' => [ 'AuthorizeDBSecurityGroupIngressResult$DBSecurityGroup' => NULL, 'CreateDBSecurityGroupResult$DBSecurityGroup' => NULL, 'DBSecurityGroups$member' => NULL, 'RevokeDBSecurityGroupIngressResult$DBSecurityGroup' => NULL, ], ], 'DBSecurityGroupAlreadyExistsFault' => [ 'base' => '<p>A DB security group with the name specified in <code>DBSecurityGroupName</code> already exists.</p>', 'refs' => [], ], 'DBSecurityGroupMembership' => [ 'base' => '<p>This data type is used as a response element in the following actions:</p> <ul> <li> <p> <code>ModifyDBInstance</code> </p> </li> <li> <p> <code>RebootDBInstance</code> </p> </li> <li> <p> <code>RestoreDBInstanceFromDBSnapshot</code> </p> </li> <li> <p> <code>RestoreDBInstanceToPointInTime</code> </p> </li> </ul>', 'refs' => [ 'DBSecurityGroupMembershipList$member' => NULL, ], ], 'DBSecurityGroupMembershipList' => [ 'base' => NULL, 'refs' => [ 'DBInstance$DBSecurityGroups' => '<p>A list of DB security group elements containing <code>DBSecurityGroup.Name</code> and <code>DBSecurityGroup.Status</code> subelements.</p>', 'Option$DBSecurityGroupMemberships' => '<p>If the option requires access to a port, then this DB security group allows access to the port.</p>', ], ], 'DBSecurityGroupMessage' => [ 'base' => '<p>Contains the result of a successful invocation of the <code>DescribeDBSecurityGroups</code> action.</p>', 'refs' => [], ], 'DBSecurityGroupNameList' => [ 'base' => NULL, 'refs' => [ 'CreateDBInstanceMessage$DBSecurityGroups' => '<p>A list of DB security groups to associate with this DB instance.</p> <p>This setting applies to the legacy EC2-Classic platform, which is no longer used to create new DB instances. Use the <code>VpcSecurityGroupIds</code> setting instead.</p>', 'ModifyDBInstanceMessage$DBSecurityGroups' => '<p>A list of DB security groups to authorize on this DB instance. Changing this setting doesn\'t result in an outage and the change is asynchronously applied as soon as possible.</p> <p>This setting doesn\'t apply to RDS Custom DB instances.</p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match existing DB security groups.</p> </li> </ul>', 'OptionConfiguration$DBSecurityGroupMemberships' => '<p>A list of DBSecurityGroupMembership name strings used for this option.</p>', 'RestoreDBInstanceFromS3Message$DBSecurityGroups' => '<p>A list of DB security groups to associate with this DB instance.</p> <p>Default: The default DB security group for the database engine.</p>', ], ], 'DBSecurityGroupNotFoundFault' => [ 'base' => '<p> <code>DBSecurityGroupName</code> doesn\'t refer to an existing DB security group.</p>', 'refs' => [], ], 'DBSecurityGroupNotSupportedFault' => [ 'base' => '<p>A DB security group isn\'t allowed for this action.</p>', 'refs' => [], ], 'DBSecurityGroupQuotaExceededFault' => [ 'base' => '<p>The request would result in the user exceeding the allowed number of DB security groups.</p>', 'refs' => [], ], 'DBSecurityGroups' => [ 'base' => NULL, 'refs' => [ 'DBSecurityGroupMessage$DBSecurityGroups' => '<p>A list of <code>DBSecurityGroup</code> instances.</p>', ], ], 'DBShardGroup' => [ 'base' => NULL, 'refs' => [ 'DBShardGroupsList$member' => NULL, ], ], 'DBShardGroupAlreadyExistsFault' => [ 'base' => '<p>The specified DB shard group name must be unique in your Amazon Web Services account in the specified Amazon Web Services Region.</p>', 'refs' => [], ], 'DBShardGroupIdentifier' => [ 'base' => NULL, 'refs' => [ 'DBShardGroup$DBShardGroupIdentifier' => '<p>The name of the DB shard group.</p>', 'DeleteDBShardGroupMessage$DBShardGroupIdentifier' => '<p>Teh name of the DB shard group to delete.</p>', 'DescribeDBShardGroupsMessage$DBShardGroupIdentifier' => '<p>The user-supplied DB shard group identifier or the Amazon Resource Name (ARN) of the DB shard group. If this parameter is specified, information for only the specific DB shard group is returned. This parameter isn\'t case-sensitive.</p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match an existing DB shard group identifier.</p> </li> </ul>', 'ModifyDBShardGroupMessage$DBShardGroupIdentifier' => '<p>The name of the DB shard group to modify.</p>', 'RebootDBShardGroupMessage$DBShardGroupIdentifier' => '<p>The name of the DB shard group to reboot.</p>', ], ], 'DBShardGroupNotFoundFault' => [ 'base' => '<p>The specified DB shard group name wasn\'t found.</p>', 'refs' => [], ], 'DBShardGroupsList' => [ 'base' => NULL, 'refs' => [ 'DescribeDBShardGroupsResponse$DBShardGroups' => '<p>Contains a list of DB shard groups for the user.</p>', ], ], 'DBSnapshot' => [ 'base' => '<p>Contains the details of an Amazon RDS DB snapshot.</p> <p>This data type is used as a response element in the <code>DescribeDBSnapshots</code> action.</p>', 'refs' => [ 'CopyDBSnapshotResult$DBSnapshot' => NULL, 'CreateDBSnapshotResult$DBSnapshot' => NULL, 'DBSnapshotList$member' => NULL, 'DeleteDBSnapshotResult$DBSnapshot' => NULL, 'ModifyDBSnapshotResult$DBSnapshot' => NULL, ], ], 'DBSnapshotAlreadyExistsFault' => [ 'base' => '<p> <code>DBSnapshotIdentifier</code> is already used by an existing snapshot.</p>', 'refs' => [], ], 'DBSnapshotAttribute' => [ 'base' => '<p>Contains the name and values of a manual DB snapshot attribute</p> <p>Manual DB snapshot attributes are used to authorize other Amazon Web Services accounts to restore a manual DB snapshot. For more information, see the <code>ModifyDBSnapshotAttribute</code> API.</p>', 'refs' => [ 'DBSnapshotAttributeList$member' => NULL, ], ], 'DBSnapshotAttributeList' => [ 'base' => NULL, 'refs' => [ 'DBSnapshotAttributesResult$DBSnapshotAttributes' => '<p>The list of attributes and values for the manual DB snapshot.</p>', ], ], 'DBSnapshotAttributesResult' => [ 'base' => '<p>Contains the results of a successful call to the <code>DescribeDBSnapshotAttributes</code> API action.</p> <p>Manual DB snapshot attributes are used to authorize other Amazon Web Services accounts to copy or restore a manual DB snapshot. For more information, see the <code>ModifyDBSnapshotAttribute</code> API action.</p>', 'refs' => [ 'DescribeDBSnapshotAttributesResult$DBSnapshotAttributesResult' => NULL, 'ModifyDBSnapshotAttributeResult$DBSnapshotAttributesResult' => NULL, ], ], 'DBSnapshotList' => [ 'base' => NULL, 'refs' => [ 'DBSnapshotMessage$DBSnapshots' => '<p>A list of <code>DBSnapshot</code> instances.</p>', ], ], 'DBSnapshotMessage' => [ 'base' => '<p>Contains the result of a successful invocation of the <code>DescribeDBSnapshots</code> action.</p>', 'refs' => [], ], 'DBSnapshotNotFoundFault' => [ 'base' => '<p> <code>DBSnapshotIdentifier</code> doesn\'t refer to an existing DB snapshot.</p>', 'refs' => [], ], 'DBSnapshotTenantDatabase' => [ 'base' => '<p>Contains the details of a tenant database in a snapshot of a DB instance.</p>', 'refs' => [ 'DBSnapshotTenantDatabasesList$member' => NULL, ], ], 'DBSnapshotTenantDatabaseNotFoundFault' => [ 'base' => '<p>The specified snapshot tenant database wasn\'t found.</p>', 'refs' => [], ], 'DBSnapshotTenantDatabasesList' => [ 'base' => NULL, 'refs' => [ 'DBSnapshotTenantDatabasesMessage$DBSnapshotTenantDatabases' => '<p>A list of DB snapshot tenant databases.</p>', ], ], 'DBSnapshotTenantDatabasesMessage' => [ 'base' => NULL, 'refs' => [], ], 'DBSubnetGroup' => [ 'base' => '<p>Contains the details of an Amazon RDS DB subnet group.</p> <p>This data type is used as a response element in the <code>DescribeDBSubnetGroups</code> action.</p>', 'refs' => [ 'CreateDBSubnetGroupResult$DBSubnetGroup' => NULL, 'DBInstance$DBSubnetGroup' => '<p>Information about the subnet group associated with the DB instance, including the name, description, and subnets in the subnet group.</p>', 'DBSubnetGroups$member' => NULL, 'ModifyDBSubnetGroupResult$DBSubnetGroup' => NULL, ], ], 'DBSubnetGroupAlreadyExistsFault' => [ 'base' => '<p> <code>DBSubnetGroupName</code> is already used by an existing DB subnet group.</p>', 'refs' => [], ], 'DBSubnetGroupDoesNotCoverEnoughAZs' => [ 'base' => '<p>Subnets in the DB subnet group should cover at least two Availability Zones unless there is only one Availability Zone.</p>', 'refs' => [], ], 'DBSubnetGroupMessage' => [ 'base' => '<p>Contains the result of a successful invocation of the <code>DescribeDBSubnetGroups</code> action.</p>', 'refs' => [], ], 'DBSubnetGroupNotAllowedFault' => [ 'base' => '<p>The DBSubnetGroup shouldn\'t be specified while creating read replicas that lie in the same region as the source instance.</p>', 'refs' => [], ], 'DBSubnetGroupNotFoundFault' => [ 'base' => '<p> <code>DBSubnetGroupName</code> doesn\'t refer to an existing DB subnet group.</p>', 'refs' => [], ], 'DBSubnetGroupQuotaExceededFault' => [ 'base' => '<p>The request would result in the user exceeding the allowed number of DB subnet groups.</p>', 'refs' => [], ], 'DBSubnetGroups' => [ 'base' => NULL, 'refs' => [ 'DBSubnetGroupMessage$DBSubnetGroups' => '<p>A list of <code>DBSubnetGroup</code> instances.</p>', ], ], 'DBSubnetQuotaExceededFault' => [ 'base' => '<p>The request would result in the user exceeding the allowed number of subnets in a DB subnet groups.</p>', 'refs' => [], ], 'DBUpgradeDependencyFailureFault' => [ 'base' => '<p>The DB upgrade failed because a resource the DB depends on can\'t be modified.</p>', 'refs' => [], ], 'DataFilter' => [ 'base' => NULL, 'refs' => [ 'CreateIntegrationMessage$DataFilter' => '<p>Data filtering options for the integration. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/zero-etl.filtering.html">Data filtering for Aurora zero-ETL integrations with Amazon Redshift</a>. </p> <p>Valid for: Integrations with Aurora MySQL source DB clusters only</p>', 'Integration$DataFilter' => '<p>Data filters for the integration. These filters determine which tables from the source database are sent to the target Amazon Redshift data warehouse. </p>', 'ModifyIntegrationMessage$DataFilter' => '<p>A new data filter for the integration. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Zero_ETL_Filtering.html">Data filtering for Aurora zero-ETL integrations with Amazon Redshift</a>.</p>', ], ], 'DatabaseArn' => [ 'base' => NULL, 'refs' => [ 'BlueGreenDeployment$Source' => '<p>The source database for the blue/green deployment.</p> <p>Before switchover, the source database is the production database in the blue environment.</p>', 'BlueGreenDeployment$Target' => '<p>The target database for the blue/green deployment.</p> <p>Before switchover, the target database is the clone database in the green environment.</p>', 'CreateBlueGreenDeploymentRequest$Source' => '<p>The Amazon Resource Name (ARN) of the source production database.</p> <p>Specify the database that you want to clone. The blue/green deployment creates this database in the green environment. You can make updates to the database in the green environment, such as an engine version upgrade. When you are ready, you can switch the database in the green environment to be the production database.</p>', 'SwitchoverDetail$SourceMember' => '<p>The Amazon Resource Name (ARN) of a resource in the blue environment.</p>', 'SwitchoverDetail$TargetMember' => '<p>The Amazon Resource Name (ARN) of a resource in the green environment.</p>', ], ], 'DeleteBlueGreenDeploymentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBlueGreenDeploymentResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteCustomDBEngineVersionMessage' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDBClusterAutomatedBackupMessage' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDBClusterAutomatedBackupResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDBClusterEndpointMessage' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDBClusterMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DeleteDBClusterParameterGroupMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DeleteDBClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDBClusterSnapshotMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DeleteDBClusterSnapshotResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDBInstanceAutomatedBackupMessage' => [ 'base' => '<p>Parameter input for the <code>DeleteDBInstanceAutomatedBackup</code> operation.</p>', 'refs' => [], ], 'DeleteDBInstanceAutomatedBackupResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDBInstanceMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DeleteDBInstanceResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDBParameterGroupMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DeleteDBProxyEndpointRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDBProxyEndpointResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDBProxyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDBProxyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDBSecurityGroupMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DeleteDBShardGroupMessage' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDBSnapshotMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DeleteDBSnapshotResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDBSubnetGroupMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DeleteEventSubscriptionMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DeleteEventSubscriptionResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteGlobalClusterMessage' => [ 'base' => NULL, 'refs' => [], ], 'DeleteGlobalClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteIntegrationMessage' => [ 'base' => NULL, 'refs' => [], ], 'DeleteOptionGroupMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DeleteTenantDatabaseMessage' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTenantDatabaseResult' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterDBProxyTargetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterDBProxyTargetsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccountAttributesMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeBlueGreenDeploymentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeBlueGreenDeploymentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCertificatesMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeDBClusterAutomatedBackupsMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDBClusterBacktracksMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeDBClusterEndpointsMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDBClusterParameterGroupsMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeDBClusterParametersMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeDBClusterSnapshotAttributesMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeDBClusterSnapshotAttributesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDBClusterSnapshotsMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeDBClustersMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeDBEngineVersionsMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDBInstanceAutomatedBackupsMessage' => [ 'base' => '<p>Parameter input for DescribeDBInstanceAutomatedBackups.</p>', 'refs' => [], ], 'DescribeDBInstancesMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeDBLogFilesDetails' => [ 'base' => '<p>This data type is used as a response element to <code>DescribeDBLogFiles</code>.</p>', 'refs' => [ 'DescribeDBLogFilesList$member' => NULL, ], ], 'DescribeDBLogFilesList' => [ 'base' => NULL, 'refs' => [ 'DescribeDBLogFilesResponse$DescribeDBLogFiles' => '<p>The DB log files returned.</p>', ], ], 'DescribeDBLogFilesMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeDBLogFilesResponse' => [ 'base' => '<p>The response from a call to <code>DescribeDBLogFiles</code>.</p>', 'refs' => [], ], 'DescribeDBParameterGroupsMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeDBParametersMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDBProxiesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDBProxiesResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDBProxyEndpointsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDBProxyEndpointsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDBProxyTargetGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDBProxyTargetGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDBProxyTargetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDBProxyTargetsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDBRecommendationsMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDBSecurityGroupsMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeDBShardGroupsMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDBShardGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDBSnapshotAttributesMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeDBSnapshotAttributesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDBSnapshotTenantDatabasesMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDBSnapshotsMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeDBSubnetGroupsMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeEngineDefaultClusterParametersMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeEngineDefaultClusterParametersResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEngineDefaultParametersMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeEngineDefaultParametersResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEventCategoriesMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeEventSubscriptionsMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeEventsMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeExportTasksMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribeGlobalClustersMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIntegrationsMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIntegrationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeOptionGroupOptionsMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeOptionGroupsMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeOrderableDBInstanceOptionsMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribePendingMaintenanceActionsMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeReservedDBInstancesMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeReservedDBInstancesOfferingsMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeSourceRegionsMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeTenantDatabasesMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribeValidDBInstanceModificationsMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeValidDBInstanceModificationsResult' => [ 'base' => NULL, 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'CreateCustomDBEngineVersionMessage$Description' => '<p>An optional description of your CEV.</p>', 'ModifyCustomDBEngineVersionMessage$Description' => '<p>An optional description of your CEV.</p>', ], ], 'DisableHttpEndpointRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisableHttpEndpointResponse' => [ 'base' => NULL, 'refs' => [], ], 'DocLink' => [ 'base' => '<p>A link to documentation that provides additional information for a recommendation.</p>', 'refs' => [ 'DocLinkList$member' => NULL, ], ], 'DocLinkList' => [ 'base' => NULL, 'refs' => [ 'DBRecommendation$Links' => '<p>A link to documentation that provides additional information about the recommendation.</p>', ], ], 'DomainMembership' => [ 'base' => '<p>An Active Directory Domain membership record associated with the DB instance or cluster.</p>', 'refs' => [ 'DomainMembershipList$member' => NULL, ], ], 'DomainMembershipList' => [ 'base' => NULL, 'refs' => [ 'DBCluster$DomainMemberships' => '<p>The Active Directory Domain membership records associated with the DB cluster.</p>', 'DBInstance$DomainMemberships' => '<p>The Active Directory Domain membership records associated with the DB instance.</p>', ], ], 'DomainNotFoundFault' => [ 'base' => '<p> <code>Domain</code> doesn\'t refer to an existing Active Directory domain.</p>', 'refs' => [], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'DoubleRange$From' => '<p>The minimum value in the range.</p>', 'DoubleRange$To' => '<p>The maximum value in the range.</p>', 'RecurringCharge$RecurringChargeAmount' => '<p>The amount of the recurring charge.</p>', 'ReservedDBInstance$FixedPrice' => '<p>The fixed price charged for this reserved DB instance.</p>', 'ReservedDBInstance$UsagePrice' => '<p>The hourly price charged for this reserved DB instance.</p>', 'ReservedDBInstancesOffering$FixedPrice' => '<p>The fixed price charged for this offering.</p>', 'ReservedDBInstancesOffering$UsagePrice' => '<p>The hourly price charged for this offering.</p>', 'ScalarReferenceDetails$Value' => '<p>The value of a scalar reference.</p>', ], ], 'DoubleOptional' => [ 'base' => NULL, 'refs' => [ 'CreateDBShardGroupMessage$MaxACU' => '<p>The maximum capacity of the DB shard group in Aurora capacity units (ACUs).</p>', 'DBShardGroup$MaxACU' => '<p>The maximum capacity of the DB shard group in Aurora capacity units (ACUs).</p>', 'LimitlessDatabase$MinRequiredACU' => '<p>The minimum required capacity for Aurora Limitless Database in Aurora capacity units (ACUs).</p>', 'ModifyDBShardGroupMessage$MaxACU' => '<p>The maximum capacity of the DB shard group in Aurora capacity units (ACUs).</p>', 'OrderableDBInstanceOption$MinIopsPerGib' => '<p>Minimum provisioned IOPS per GiB for a DB instance.</p>', 'OrderableDBInstanceOption$MaxIopsPerGib' => '<p>Maximum provisioned IOPS per GiB for a DB instance.</p>', 'OrderableDBInstanceOption$MinStorageThroughputPerIops' => '<p>Minimum storage throughput to provisioned IOPS ratio for a DB instance.</p>', 'OrderableDBInstanceOption$MaxStorageThroughputPerIops' => '<p>Maximum storage throughput to provisioned IOPS ratio for a DB instance.</p>', 'ServerlessV2ScalingConfiguration$MinCapacity' => '<p>The minimum number of Aurora capacity units (ACUs) for a DB instance in an Aurora Serverless v2 cluster. You can specify ACU values in half-step increments, such as 8, 8.5, 9, and so on. The smallest value that you can use is 0.5.</p>', 'ServerlessV2ScalingConfiguration$MaxCapacity' => '<p>The maximum number of Aurora capacity units (ACUs) for a DB instance in an Aurora Serverless v2 cluster. You can specify ACU values in half-step increments, such as 40, 40.5, 41, and so on. The largest value that you can use is 128.</p>', 'ServerlessV2ScalingConfigurationInfo$MinCapacity' => '<p>The minimum number of Aurora capacity units (ACUs) for a DB instance in an Aurora Serverless v2 cluster. You can specify ACU values in half-step increments, such as 8, 8.5, 9, and so on. The smallest value that you can use is 0.5.</p>', 'ServerlessV2ScalingConfigurationInfo$MaxCapacity' => '<p>The maximum number of Aurora capacity units (ACUs) for a DB instance in an Aurora Serverless v2 cluster. You can specify ACU values in half-step increments, such as 40, 40.5, 41, and so on. The largest value that you can use is 128.</p>', ], ], 'DoubleRange' => [ 'base' => '<p>A range of double values.</p>', 'refs' => [ 'DoubleRangeList$member' => NULL, ], ], 'DoubleRangeList' => [ 'base' => NULL, 'refs' => [ 'ValidStorageOptions$IopsToStorageRatio' => '<p>The valid range of Provisioned IOPS to gibibytes of storage multiplier. For example, 3-10, which means that provisioned IOPS can be between 3 and 10 times storage.</p>', 'ValidStorageOptions$StorageThroughputToIopsRatio' => '<p>The valid range of storage throughput to provisioned IOPS ratios. For example, 0-0.25.</p>', ], ], 'DownloadDBLogFilePortionDetails' => [ 'base' => '<p>This data type is used as a response element to <code>DownloadDBLogFilePortion</code>.</p>', 'refs' => [], ], 'DownloadDBLogFilePortionMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'EC2SecurityGroup' => [ 'base' => '<p>This data type is used as a response element in the following actions:</p> <ul> <li> <p> <code>AuthorizeDBSecurityGroupIngress</code> </p> </li> <li> <p> <code>DescribeDBSecurityGroups</code> </p> </li> <li> <p> <code>RevokeDBSecurityGroupIngress</code> </p> </li> </ul>', 'refs' => [ 'EC2SecurityGroupList$member' => NULL, ], ], 'EC2SecurityGroupList' => [ 'base' => NULL, 'refs' => [ 'DBSecurityGroup$EC2SecurityGroups' => '<p>Contains a list of <code>EC2SecurityGroup</code> elements.</p>', ], ], 'Ec2ImagePropertiesNotSupportedFault' => [ 'base' => '<p>The AMI configuration prerequisite has not been met.</p>', 'refs' => [], ], 'EnableHttpEndpointRequest' => [ 'base' => NULL, 'refs' => [], ], 'EnableHttpEndpointResponse' => [ 'base' => NULL, 'refs' => [], ], 'EncryptionContextMap' => [ 'base' => NULL, 'refs' => [ 'CreateIntegrationMessage$AdditionalEncryptionContext' => '<p>An optional set of non-secret key–value pairs that contains additional contextual information about the data. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context">Encryption context</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.</p> <p>You can only include this parameter if you specify the <code>KMSKeyId</code> parameter.</p>', 'Integration$AdditionalEncryptionContext' => '<p>The encryption context for the integration. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context">Encryption context</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.</p>', ], ], 'Endpoint' => [ 'base' => '<p>This data type represents the information you need to connect to an Amazon RDS DB instance. This data type is used as a response element in the following actions:</p> <ul> <li> <p> <code>CreateDBInstance</code> </p> </li> <li> <p> <code>DescribeDBInstances</code> </p> </li> <li> <p> <code>DeleteDBInstance</code> </p> </li> </ul> <p>For the data structure that represents Amazon Aurora DB cluster endpoints, see <code>DBClusterEndpoint</code>.</p>', 'refs' => [ 'DBInstance$Endpoint' => '<p>The connection endpoint for the DB instance.</p> <note> <p>The endpoint might not be shown for instances with the status of <code>creating</code>.</p> </note>', 'DBInstance$ListenerEndpoint' => '<p>The listener connection endpoint for SQL Server Always On.</p>', ], ], 'EngineDefaults' => [ 'base' => '<p>Contains the result of a successful invocation of the <code>DescribeEngineDefaultParameters</code> action.</p>', 'refs' => [ 'DescribeEngineDefaultClusterParametersResult$EngineDefaults' => NULL, 'DescribeEngineDefaultParametersResult$EngineDefaults' => NULL, ], ], 'EngineFamily' => [ 'base' => NULL, 'refs' => [ 'CreateDBProxyRequest$EngineFamily' => '<p>The kinds of databases that the proxy can connect to. This value determines which database network protocol the proxy recognizes when it interprets network traffic to and from the database. For Aurora MySQL, RDS for MariaDB, and RDS for MySQL databases, specify <code>MYSQL</code>. For Aurora PostgreSQL and RDS for PostgreSQL databases, specify <code>POSTGRESQL</code>. For RDS for Microsoft SQL Server, specify <code>SQLSERVER</code>.</p>', ], ], 'EngineModeList' => [ 'base' => NULL, 'refs' => [ 'DBEngineVersion$SupportedEngineModes' => '<p>A list of the supported DB engine modes.</p>', 'OrderableDBInstanceOption$SupportedEngineModes' => '<p>A list of the supported DB engine modes.</p>', 'Parameter$SupportedEngineModes' => '<p>The valid DB engine modes.</p>', 'UpgradeTarget$SupportedEngineModes' => '<p>A list of the supported DB engine modes for the target engine version.</p>', ], ], 'Event' => [ 'base' => '<p>This data type is used as a response element in the <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeEvents.html">DescribeEvents</a> action.</p>', 'refs' => [ 'EventList$member' => NULL, ], ], 'EventCategoriesList' => [ 'base' => NULL, 'refs' => [ 'CreateEventSubscriptionMessage$EventCategories' => '<p>A list of event categories for a particular source type (<code>SourceType</code>) that you want to subscribe to. You can see a list of the categories for a given source type in the "Amazon RDS event categories and event messages" section of the <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.Messages.html"> <i>Amazon RDS User Guide</i> </a> or the <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Events.Messages.html"> <i>Amazon Aurora User Guide</i> </a>. You can also see this list by using the <code>DescribeEventCategories</code> operation.</p>', 'DescribeEventsMessage$EventCategories' => '<p>A list of event categories that trigger notifications for a event notification subscription.</p>', 'Event$EventCategories' => '<p>Specifies the category for the event.</p>', 'EventCategoriesMap$EventCategories' => '<p>The event categories for the specified source type</p>', 'EventSubscription$EventCategoriesList' => '<p>A list of event categories for the RDS event notification subscription.</p>', 'ModifyEventSubscriptionMessage$EventCategories' => '<p>A list of event categories for a source type (<code>SourceType</code>) that you want to subscribe to. You can see a list of the categories for a given source type in <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html">Events</a> in the <i>Amazon RDS User Guide</i> or by using the <code>DescribeEventCategories</code> operation.</p>', ], ], 'EventCategoriesMap' => [ 'base' => '<p>Contains the results of a successful invocation of the <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeEventCategories.html">DescribeEventCategories</a> operation.</p>', 'refs' => [ 'EventCategoriesMapList$member' => NULL, ], ], 'EventCategoriesMapList' => [ 'base' => NULL, 'refs' => [ 'EventCategoriesMessage$EventCategoriesMapList' => '<p>A list of <code>EventCategoriesMap</code> data types.</p>', ], ], 'EventCategoriesMessage' => [ 'base' => '<p>Data returned from the <code>DescribeEventCategories</code> operation.</p>', 'refs' => [], ], 'EventList' => [ 'base' => NULL, 'refs' => [ 'EventsMessage$Events' => '<p>A list of <code>Event</code> instances.</p>', ], ], 'EventSubscription' => [ 'base' => '<p>Contains the results of a successful invocation of the <code>DescribeEventSubscriptions</code> action.</p>', 'refs' => [ 'AddSourceIdentifierToSubscriptionResult$EventSubscription' => NULL, 'CreateEventSubscriptionResult$EventSubscription' => NULL, 'DeleteEventSubscriptionResult$EventSubscription' => NULL, 'EventSubscriptionsList$member' => NULL, 'ModifyEventSubscriptionResult$EventSubscription' => NULL, 'RemoveSourceIdentifierFromSubscriptionResult$EventSubscription' => NULL, ], ], 'EventSubscriptionQuotaExceededFault' => [ 'base' => '<p>You have reached the maximum number of event subscriptions.</p>', 'refs' => [], ], 'EventSubscriptionsList' => [ 'base' => NULL, 'refs' => [ 'EventSubscriptionsMessage$EventSubscriptionsList' => '<p>A list of EventSubscriptions data types.</p>', ], ], 'EventSubscriptionsMessage' => [ 'base' => '<p>Data returned by the <b>DescribeEventSubscriptions</b> action.</p>', 'refs' => [], ], 'EventsMessage' => [ 'base' => '<p>Contains the result of a successful invocation of the <code>DescribeEvents</code> action.</p>', 'refs' => [], ], 'ExportSourceType' => [ 'base' => NULL, 'refs' => [ 'DescribeExportTasksMessage$SourceType' => '<p>The type of source for the export.</p>', 'ExportTask$SourceType' => '<p>The type of source for the export.</p>', ], ], 'ExportTask' => [ 'base' => '<p>Contains the details of a snapshot or cluster export to Amazon S3.</p> <p>This data type is used as a response element in the <code>DescribeExportTasks</code> operation.</p>', 'refs' => [ 'ExportTasksList$member' => NULL, ], ], 'ExportTaskAlreadyExistsFault' => [ 'base' => '<p>You can\'t start an export task that\'s already running.</p>', 'refs' => [], ], 'ExportTaskNotFoundFault' => [ 'base' => '<p>The export task doesn\'t exist.</p>', 'refs' => [], ], 'ExportTasksList' => [ 'base' => NULL, 'refs' => [ 'ExportTasksMessage$ExportTasks' => '<p>Information about an export of a snapshot or cluster to Amazon S3.</p>', ], ], 'ExportTasksMessage' => [ 'base' => NULL, 'refs' => [], ], 'FailoverDBClusterMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'FailoverDBClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'FailoverGlobalClusterMessage' => [ 'base' => NULL, 'refs' => [], ], 'FailoverGlobalClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'FailoverState' => [ 'base' => '<p>Contains the state of scheduled or in-process operations on a global cluster (Aurora global database). This data type is empty unless a switchover or failover operation is scheduled or is in progress on the Aurora global database.</p>', 'refs' => [ 'GlobalCluster$FailoverState' => '<p>A data object containing all properties for the current state of an in-process or pending switchover or failover process for this global cluster (Aurora global database). This object is empty unless the <code>SwitchoverGlobalCluster</code> or <code>FailoverGlobalCluster</code> operation was called on this global cluster.</p>', ], ], 'FailoverStatus' => [ 'base' => NULL, 'refs' => [ 'FailoverState$Status' => '<p>The current status of the global cluster. Possible values are as follows:</p> <ul> <li> <p>pending &#x96; The service received a request to switch over or fail over the global cluster. The global cluster\'s primary DB cluster and the specified secondary DB cluster are being verified before the operation starts.</p> </li> <li> <p>failing-over &#x96; Aurora is promoting the chosen secondary Aurora DB cluster to become the new primary DB cluster to fail over the global cluster.</p> </li> <li> <p>cancelling &#x96; The request to switch over or fail over the global cluster was cancelled and the primary Aurora DB cluster and the selected secondary Aurora DB cluster are returning to their previous states.</p> </li> <li> <p>switching-over &#x96; This status covers the range of Aurora internal operations that take place during the switchover process, such as demoting the primary Aurora DB cluster, promoting the secondary Aurora DB cluster, and synchronizing replicas.</p> </li> </ul>', ], ], 'FeatureNameList' => [ 'base' => NULL, 'refs' => [ 'DBEngineVersion$SupportedFeatureNames' => '<p>A list of features supported by the DB engine.</p> <p>The supported features vary by DB engine and DB engine version.</p> <p>To determine the supported features for a specific DB engine and DB engine version using the CLI, use the following command:</p> <p> <code>aws rds describe-db-engine-versions --engine &lt;engine_name&gt; --engine-version &lt;engine_version&gt;</code> </p> <p>For example, to determine the supported features for RDS for PostgreSQL version 13.3 using the CLI, use the following command:</p> <p> <code>aws rds describe-db-engine-versions --engine postgres --engine-version 13.3</code> </p> <p>The supported features are listed under <code>SupportedFeatureNames</code> in the output.</p>', ], ], 'Filter' => [ 'base' => '<p>A filter name and value pair that is used to return a more specific list of results from a describe operation. Filters can be used to match a set of resources by specific criteria, such as IDs. The filters supported by a describe operation are documented with the describe operation.</p> <note> <p>Currently, wildcards are not supported in filters.</p> </note> <p>The following actions can be filtered:</p> <ul> <li> <p> <code>DescribeDBClusterBacktracks</code> </p> </li> <li> <p> <code>DescribeDBClusterEndpoints</code> </p> </li> <li> <p> <code>DescribeDBClusters</code> </p> </li> <li> <p> <code>DescribeDBInstances</code> </p> </li> <li> <p> <code>DescribeDBRecommendations</code> </p> </li> <li> <p> <code>DescribeDBShardGroups</code> </p> </li> <li> <p> <code>DescribePendingMaintenanceActions</code> </p> </li> </ul>', 'refs' => [ 'FilterList$member' => NULL, ], ], 'FilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeBlueGreenDeploymentsRequest$Filters' => '<p>A filter that specifies one or more blue/green deployments to describe.</p> <p>Valid Values:</p> <ul> <li> <p> <code>blue-green-deployment-identifier</code> - Accepts system-generated identifiers for blue/green deployments. The results list only includes information about the blue/green deployments with the specified identifiers.</p> </li> <li> <p> <code>blue-green-deployment-name</code> - Accepts user-supplied names for blue/green deployments. The results list only includes information about the blue/green deployments with the specified names.</p> </li> <li> <p> <code>source</code> - Accepts source databases for a blue/green deployment. The results list only includes information about the blue/green deployments with the specified source databases.</p> </li> <li> <p> <code>target</code> - Accepts target databases for a blue/green deployment. The results list only includes information about the blue/green deployments with the specified target databases.</p> </li> </ul>', 'DescribeCertificatesMessage$Filters' => '<p>This parameter isn\'t currently supported.</p>', 'DescribeDBClusterAutomatedBackupsMessage$Filters' => '<p>A filter that specifies which resources to return based on status.</p> <p>Supported filters are the following:</p> <ul> <li> <p> <code>status</code> </p> <ul> <li> <p> <code>retained</code> - Automated backups for deleted clusters and after backup replication is stopped.</p> </li> </ul> </li> <li> <p> <code>db-cluster-id</code> - Accepts DB cluster identifiers and Amazon Resource Names (ARNs). The results list includes only information about the DB cluster automated backups identified by these ARNs.</p> </li> <li> <p> <code>db-cluster-resource-id</code> - Accepts DB resource identifiers and Amazon Resource Names (ARNs). The results list includes only information about the DB cluster resources identified by these ARNs.</p> </li> </ul> <p>Returns all resources by default. The status for each resource is specified in the response.</p>', 'DescribeDBClusterBacktracksMessage$Filters' => '<p>A filter that specifies one or more DB clusters to describe. Supported filters include the following:</p> <ul> <li> <p> <code>db-cluster-backtrack-id</code> - Accepts backtrack identifiers. The results list includes information about only the backtracks identified by these identifiers.</p> </li> <li> <p> <code>db-cluster-backtrack-status</code> - Accepts any of the following backtrack status values:</p> <ul> <li> <p> <code>applying</code> </p> </li> <li> <p> <code>completed</code> </p> </li> <li> <p> <code>failed</code> </p> </li> <li> <p> <code>pending</code> </p> </li> </ul> <p>The results list includes information about only the backtracks identified by these values.</p> </li> </ul>', 'DescribeDBClusterEndpointsMessage$Filters' => '<p>A set of name-value pairs that define which endpoints to include in the output. The filters are specified as name-value pairs, in the format <code>Name=<i>endpoint_type</i>,Values=<i>endpoint_type1</i>,<i>endpoint_type2</i>,...</code>. <code>Name</code> can be one of: <code>db-cluster-endpoint-type</code>, <code>db-cluster-endpoint-custom-type</code>, <code>db-cluster-endpoint-id</code>, <code>db-cluster-endpoint-status</code>. <code>Values</code> for the <code> db-cluster-endpoint-type</code> filter can be one or more of: <code>reader</code>, <code>writer</code>, <code>custom</code>. <code>Values</code> for the <code>db-cluster-endpoint-custom-type</code> filter can be one or more of: <code>reader</code>, <code>any</code>. <code>Values</code> for the <code>db-cluster-endpoint-status</code> filter can be one or more of: <code>available</code>, <code>creating</code>, <code>deleting</code>, <code>inactive</code>, <code>modifying</code>.</p>', 'DescribeDBClusterParameterGroupsMessage$Filters' => '<p>This parameter isn\'t currently supported.</p>', 'DescribeDBClusterParametersMessage$Filters' => '<p>This parameter isn\'t currently supported.</p>', 'DescribeDBClusterSnapshotsMessage$Filters' => '<p>A filter that specifies one or more DB cluster snapshots to describe.</p> <p>Supported filters:</p> <ul> <li> <p> <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB cluster Amazon Resource Names (ARNs).</p> </li> <li> <p> <code>db-cluster-snapshot-id</code> - Accepts DB cluster snapshot identifiers.</p> </li> <li> <p> <code>snapshot-type</code> - Accepts types of DB cluster snapshots.</p> </li> <li> <p> <code>engine</code> - Accepts names of database engines.</p> </li> </ul>', 'DescribeDBClustersMessage$Filters' => '<p>A filter that specifies one or more DB clusters to describe.</p> <p>Supported Filters:</p> <ul> <li> <p> <code>clone-group-id</code> - Accepts clone group identifiers. The results list only includes information about the DB clusters associated with these clone groups.</p> </li> <li> <p> <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB cluster Amazon Resource Names (ARNs). The results list only includes information about the DB clusters identified by these ARNs.</p> </li> <li> <p> <code>db-cluster-resource-id</code> - Accepts DB cluster resource identifiers. The results list will only include information about the DB clusters identified by these DB cluster resource identifiers.</p> </li> <li> <p> <code>domain</code> - Accepts Active Directory directory IDs. The results list only includes information about the DB clusters associated with these domains.</p> </li> <li> <p> <code>engine</code> - Accepts engine names. The results list only includes information about the DB clusters for these engines.</p> </li> </ul>', 'DescribeDBEngineVersionsMessage$Filters' => '<p>A filter that specifies one or more DB engine versions to describe.</p> <p>Supported filters:</p> <ul> <li> <p> <code>db-parameter-group-family</code> - Accepts parameter groups family names. The results list only includes information about the DB engine versions for these parameter group families.</p> </li> <li> <p> <code>engine</code> - Accepts engine names. The results list only includes information about the DB engine versions for these engines.</p> </li> <li> <p> <code>engine-mode</code> - Accepts DB engine modes. The results list only includes information about the DB engine versions for these engine modes. Valid DB engine modes are the following:</p> <ul> <li> <p> <code>global</code> </p> </li> <li> <p> <code>multimaster</code> </p> </li> <li> <p> <code>parallelquery</code> </p> </li> <li> <p> <code>provisioned</code> </p> </li> <li> <p> <code>serverless</code> </p> </li> </ul> </li> <li> <p> <code>engine-version</code> - Accepts engine versions. The results list only includes information about the DB engine versions for these engine versions.</p> </li> <li> <p> <code>status</code> - Accepts engine version statuses. The results list only includes information about the DB engine versions for these statuses. Valid statuses are the following:</p> <ul> <li> <p> <code>available</code> </p> </li> <li> <p> <code>deprecated</code> </p> </li> </ul> </li> </ul>', 'DescribeDBInstanceAutomatedBackupsMessage$Filters' => '<p>A filter that specifies which resources to return based on status.</p> <p>Supported filters are the following:</p> <ul> <li> <p> <code>status</code> </p> <ul> <li> <p> <code>active</code> - Automated backups for current instances.</p> </li> <li> <p> <code>creating</code> - Automated backups that are waiting for the first automated snapshot to be available.</p> </li> <li> <p> <code>retained</code> - Automated backups for deleted instances and after backup replication is stopped.</p> </li> </ul> </li> <li> <p> <code>db-instance-id</code> - Accepts DB instance identifiers and Amazon Resource Names (ARNs). The results list includes only information about the DB instance automated backups identified by these ARNs.</p> </li> <li> <p> <code>dbi-resource-id</code> - Accepts DB resource identifiers and Amazon Resource Names (ARNs). The results list includes only information about the DB instance resources identified by these ARNs.</p> </li> </ul> <p>Returns all resources by default. The status for each resource is specified in the response.</p>', 'DescribeDBInstancesMessage$Filters' => '<p>A filter that specifies one or more DB instances to describe.</p> <p>Supported Filters:</p> <ul> <li> <p> <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB cluster Amazon Resource Names (ARNs). The results list only includes information about the DB instances associated with the DB clusters identified by these ARNs.</p> </li> <li> <p> <code>db-instance-id</code> - Accepts DB instance identifiers and DB instance Amazon Resource Names (ARNs). The results list only includes information about the DB instances identified by these ARNs.</p> </li> <li> <p> <code>dbi-resource-id</code> - Accepts DB instance resource identifiers. The results list only includes information about the DB instances identified by these DB instance resource identifiers.</p> </li> <li> <p> <code>domain</code> - Accepts Active Directory directory IDs. The results list only includes information about the DB instances associated with these domains.</p> </li> <li> <p> <code>engine</code> - Accepts engine names. The results list only includes information about the DB instances for these engines.</p> </li> </ul>', 'DescribeDBLogFilesMessage$Filters' => '<p>This parameter isn\'t currently supported.</p>', 'DescribeDBParameterGroupsMessage$Filters' => '<p>This parameter isn\'t currently supported.</p>', 'DescribeDBParametersMessage$Filters' => '<p>This parameter isn\'t currently supported.</p>', 'DescribeDBProxiesRequest$Filters' => '<p>This parameter is not currently supported.</p>', 'DescribeDBProxyEndpointsRequest$Filters' => '<p>This parameter is not currently supported.</p>', 'DescribeDBProxyTargetGroupsRequest$Filters' => '<p>This parameter is not currently supported.</p>', 'DescribeDBProxyTargetsRequest$Filters' => '<p>This parameter is not currently supported.</p>', 'DescribeDBRecommendationsMessage$Filters' => '<p>A filter that specifies one or more recommendations to describe.</p> <p>Supported Filters:</p> <ul> <li> <p> <code>recommendation-id</code> - Accepts a list of recommendation identifiers. The results list only includes the recommendations whose identifier is one of the specified filter values.</p> </li> <li> <p> <code>status</code> - Accepts a list of recommendation statuses.</p> <p>Valid values:</p> <ul> <li> <p> <code>active</code> - The recommendations which are ready for you to apply.</p> </li> <li> <p> <code>pending</code> - The applied or scheduled recommendations which are in progress.</p> </li> <li> <p> <code>resolved</code> - The recommendations which are completed.</p> </li> <li> <p> <code>dismissed</code> - The recommendations that you dismissed.</p> </li> </ul> <p>The results list only includes the recommendations whose status is one of the specified filter values.</p> </li> <li> <p> <code>severity</code> - Accepts a list of recommendation severities. The results list only includes the recommendations whose severity is one of the specified filter values.</p> <p>Valid values:</p> <ul> <li> <p> <code>high</code> </p> </li> <li> <p> <code>medium</code> </p> </li> <li> <p> <code>low</code> </p> </li> <li> <p> <code>informational</code> </p> </li> </ul> </li> <li> <p> <code>type-id</code> - Accepts a list of recommendation type identifiers. The results list only includes the recommendations whose type is one of the specified filter values.</p> </li> <li> <p> <code>dbi-resource-id</code> - Accepts a list of database resource identifiers. The results list only includes the recommendations that generated for the specified databases.</p> </li> <li> <p> <code>cluster-resource-id</code> - Accepts a list of cluster resource identifiers. The results list only includes the recommendations that generated for the specified clusters.</p> </li> <li> <p> <code>pg-arn</code> - Accepts a list of parameter group ARNs. The results list only includes the recommendations that generated for the specified parameter groups.</p> </li> <li> <p> <code>cluster-pg-arn</code> - Accepts a list of cluster parameter group ARNs. The results list only includes the recommendations that generated for the specified cluster parameter groups.</p> </li> </ul>', 'DescribeDBSecurityGroupsMessage$Filters' => '<p>This parameter isn\'t currently supported.</p>', 'DescribeDBShardGroupsMessage$Filters' => '<p>A filter that specifies one or more DB shard groups to describe.</p>', 'DescribeDBSnapshotTenantDatabasesMessage$Filters' => '<p>A filter that specifies one or more tenant databases to describe.</p> <p>Supported filters:</p> <ul> <li> <p> <code>tenant-db-name</code> - Tenant database names. The results list only includes information about the tenant databases that match these tenant DB names.</p> </li> <li> <p> <code>tenant-database-resource-id</code> - Tenant database resource identifiers. The results list only includes information about the tenant databases contained within the DB snapshots.</p> </li> <li> <p> <code>dbi-resource-id</code> - DB instance resource identifiers. The results list only includes information about snapshots containing tenant databases contained within the DB instances identified by these resource identifiers.</p> </li> <li> <p> <code>db-instance-id</code> - Accepts DB instance identifiers and DB instance Amazon Resource Names (ARNs).</p> </li> <li> <p> <code>db-snapshot-id</code> - Accepts DB snapshot identifiers.</p> </li> <li> <p> <code>snapshot-type</code> - Accepts types of DB snapshots.</p> </li> </ul>', 'DescribeDBSnapshotsMessage$Filters' => '<p>A filter that specifies one or more DB snapshots to describe.</p> <p>Supported filters:</p> <ul> <li> <p> <code>db-instance-id</code> - Accepts DB instance identifiers and DB instance Amazon Resource Names (ARNs).</p> </li> <li> <p> <code>db-snapshot-id</code> - Accepts DB snapshot identifiers.</p> </li> <li> <p> <code>dbi-resource-id</code> - Accepts identifiers of source DB instances.</p> </li> <li> <p> <code>snapshot-type</code> - Accepts types of DB snapshots.</p> </li> <li> <p> <code>engine</code> - Accepts names of database engines.</p> </li> </ul>', 'DescribeDBSubnetGroupsMessage$Filters' => '<p>This parameter isn\'t currently supported.</p>', 'DescribeEngineDefaultClusterParametersMessage$Filters' => '<p>This parameter isn\'t currently supported.</p>', 'DescribeEngineDefaultParametersMessage$Filters' => '<p>This parameter isn\'t currently supported.</p>', 'DescribeEventCategoriesMessage$Filters' => '<p>This parameter isn\'t currently supported.</p>', 'DescribeEventSubscriptionsMessage$Filters' => '<p>This parameter isn\'t currently supported.</p>', 'DescribeEventsMessage$Filters' => '<p>This parameter isn\'t currently supported.</p>', 'DescribeExportTasksMessage$Filters' => '<p>Filters specify one or more snapshot or cluster exports to describe. The filters are specified as name-value pairs that define what to include in the output. Filter names and values are case-sensitive.</p> <p>Supported filters include the following:</p> <ul> <li> <p> <code>export-task-identifier</code> - An identifier for the snapshot or cluster export task.</p> </li> <li> <p> <code>s3-bucket</code> - The Amazon S3 bucket the data is exported to.</p> </li> <li> <p> <code>source-arn</code> - The Amazon Resource Name (ARN) of the snapshot or cluster exported to Amazon S3.</p> </li> <li> <p> <code>status</code> - The status of the export task. Must be lowercase. Valid statuses are the following:</p> <ul> <li> <p> <code>canceled</code> </p> </li> <li> <p> <code>canceling</code> </p> </li> <li> <p> <code>complete</code> </p> </li> <li> <p> <code>failed</code> </p> </li> <li> <p> <code>in_progress</code> </p> </li> <li> <p> <code>starting</code> </p> </li> </ul> </li> </ul>', 'DescribeGlobalClustersMessage$Filters' => '<p>A filter that specifies one or more global database clusters to describe. This parameter is case-sensitive.</p> <p>Currently, the only supported filter is <code>region</code>.</p> <p>If used, the request returns information about any global cluster with at least one member (primary or secondary) in the specified Amazon Web Services Regions.</p>', 'DescribeIntegrationsMessage$Filters' => '<p>A filter that specifies one or more resources to return.</p>', 'DescribeOptionGroupOptionsMessage$Filters' => '<p>This parameter isn\'t currently supported.</p>', 'DescribeOptionGroupsMessage$Filters' => '<p>This parameter isn\'t currently supported.</p>', 'DescribeOrderableDBInstanceOptionsMessage$Filters' => '<p>This parameter isn\'t currently supported.</p>', 'DescribePendingMaintenanceActionsMessage$Filters' => '<p>A filter that specifies one or more resources to return pending maintenance actions for.</p> <p>Supported filters:</p> <ul> <li> <p> <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB cluster Amazon Resource Names (ARNs). The results list only includes pending maintenance actions for the DB clusters identified by these ARNs.</p> </li> <li> <p> <code>db-instance-id</code> - Accepts DB instance identifiers and DB instance ARNs. The results list only includes pending maintenance actions for the DB instances identified by these ARNs.</p> </li> </ul>', 'DescribeReservedDBInstancesMessage$Filters' => '<p>This parameter isn\'t currently supported.</p>', 'DescribeReservedDBInstancesOfferingsMessage$Filters' => '<p>This parameter isn\'t currently supported.</p>', 'DescribeSourceRegionsMessage$Filters' => '<p>This parameter isn\'t currently supported.</p>', 'DescribeTenantDatabasesMessage$Filters' => '<p>A filter that specifies one or more database tenants to describe.</p> <p>Supported filters:</p> <ul> <li> <p> <code>tenant-db-name</code> - Tenant database names. The results list only includes information about the tenant databases that match these tenant DB names.</p> </li> <li> <p> <code>tenant-database-resource-id</code> - Tenant database resource identifiers.</p> </li> <li> <p> <code>dbi-resource-id</code> - DB instance resource identifiers. The results list only includes information about the tenants contained within the DB instances identified by these resource identifiers.</p> </li> </ul>', 'ListTagsForResourceMessage$Filters' => '<p>This parameter isn\'t currently supported.</p>', ], ], 'FilterValueList' => [ 'base' => NULL, 'refs' => [ 'Filter$Values' => '<p>One or more filter values. Filter values are case-sensitive.</p>', ], ], 'GlobalCluster' => [ 'base' => '<p>A data type representing an Aurora global database.</p>', 'refs' => [ 'CreateGlobalClusterResult$GlobalCluster' => NULL, 'DeleteGlobalClusterResult$GlobalCluster' => NULL, 'FailoverGlobalClusterResult$GlobalCluster' => NULL, 'GlobalClusterList$member' => NULL, 'ModifyGlobalClusterResult$GlobalCluster' => NULL, 'RemoveFromGlobalClusterResult$GlobalCluster' => NULL, 'SwitchoverGlobalClusterResult$GlobalCluster' => NULL, ], ], 'GlobalClusterAlreadyExistsFault' => [ 'base' => '<p>The <code>GlobalClusterIdentifier</code> already exists. Choose a new global database identifier (unique name) to create a new global database cluster.</p>', 'refs' => [], ], 'GlobalClusterIdentifier' => [ 'base' => NULL, 'refs' => [ 'FailoverGlobalClusterMessage$GlobalClusterIdentifier' => '<p>The identifier of the global database cluster (Aurora global database) this operation should apply to. The identifier is the unique key assigned by the user when the Aurora global database is created. In other words, it\'s the name of the Aurora global database.</p> <p>Constraints:</p> <ul> <li> <p>Must match the identifier of an existing global database cluster.</p> </li> </ul>', 'SwitchoverGlobalClusterMessage$GlobalClusterIdentifier' => '<p>The identifier of the global database cluster to switch over. This parameter isn\'t case-sensitive.</p> <p>Constraints:</p> <ul> <li> <p>Must match the identifier of an existing global database cluster (Aurora global database).</p> </li> </ul>', ], ], 'GlobalClusterList' => [ 'base' => NULL, 'refs' => [ 'GlobalClustersMessage$GlobalClusters' => '<p>The list of global clusters returned by this request.</p>', ], ], 'GlobalClusterMember' => [ 'base' => '<p>A data structure with information about any primary and secondary clusters associated with a global cluster (Aurora global database).</p>', 'refs' => [ 'GlobalClusterMemberList$member' => NULL, ], ], 'GlobalClusterMemberList' => [ 'base' => NULL, 'refs' => [ 'GlobalCluster$GlobalClusterMembers' => '<p>The list of primary and secondary clusters within the global database cluster.</p>', ], ], 'GlobalClusterMemberSynchronizationStatus' => [ 'base' => NULL, 'refs' => [ 'GlobalClusterMember$SynchronizationStatus' => '<p>The status of synchronization of each Aurora DB cluster in the global cluster.</p>', ], ], 'GlobalClusterNotFoundFault' => [ 'base' => '<p>The <code>GlobalClusterIdentifier</code> doesn\'t refer to an existing global database cluster.</p>', 'refs' => [], ], 'GlobalClusterQuotaExceededFault' => [ 'base' => '<p>The number of global database clusters for this account is already at the maximum allowed.</p>', 'refs' => [], ], 'GlobalClustersMessage' => [ 'base' => NULL, 'refs' => [], ], 'IAMAuthMode' => [ 'base' => NULL, 'refs' => [ 'UserAuthConfig$IAMAuth' => '<p>A value that indicates whether to require or disallow Amazon Web Services Identity and Access Management (IAM) authentication for connections to the proxy. The <code>ENABLED</code> value is valid only for proxies with RDS for Microsoft SQL Server.</p>', 'UserAuthConfigInfo$IAMAuth' => '<p>Whether to require or disallow Amazon Web Services Identity and Access Management (IAM) authentication for connections to the proxy. The <code>ENABLED</code> value is valid only for proxies with RDS for Microsoft SQL Server.</p>', ], ], 'IPRange' => [ 'base' => '<p>This data type is used as a response element in the <code>DescribeDBSecurityGroups</code> action.</p>', 'refs' => [ 'IPRangeList$member' => NULL, ], ], 'IPRangeList' => [ 'base' => NULL, 'refs' => [ 'DBSecurityGroup$IPRanges' => '<p>Contains a list of <code>IPRange</code> elements.</p>', ], ], 'IamRoleMissingPermissionsFault' => [ 'base' => '<p>The IAM role requires additional permissions to export to an Amazon S3 bucket.</p>', 'refs' => [], ], 'IamRoleNotFoundFault' => [ 'base' => '<p>The IAM role is missing for exporting to an Amazon S3 bucket.</p>', 'refs' => [], ], 'InstanceQuotaExceededFault' => [ 'base' => '<p>The request would result in the user exceeding the allowed number of DB instances.</p>', 'refs' => [], ], 'InsufficientAvailableIPsInSubnetFault' => [ 'base' => '<p>The requested operation can\'t be performed because there aren\'t enough available IP addresses in the proxy\'s subnets. Add more CIDR blocks to the VPC or remove IP address that aren\'t required from the subnets.</p>', 'refs' => [], ], 'InsufficientDBClusterCapacityFault' => [ 'base' => '<p>The DB cluster doesn\'t have enough capacity for the current operation.</p>', 'refs' => [], ], 'InsufficientDBInstanceCapacityFault' => [ 'base' => '<p>The specified DB instance class isn\'t available in the specified Availability Zone.</p>', 'refs' => [], ], 'InsufficientStorageClusterCapacityFault' => [ 'base' => '<p>There is insufficient storage available for the current action. You might be able to resolve this error by updating your subnet group to use different Availability Zones that have more storage available.</p>', 'refs' => [], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'ConnectionPoolConfigurationInfo$MaxConnectionsPercent' => '<p>The maximum size of the connection pool for each target in a target group. The value is expressed as a percentage of the <code>max_connections</code> setting for the RDS DB instance or Aurora DB cluster used by the target group.</p>', 'ConnectionPoolConfigurationInfo$MaxIdleConnectionsPercent' => '<p>Controls how actively the proxy closes idle database connections in the connection pool. The value is expressed as a percentage of the <code>max_connections</code> setting for the RDS DB instance or Aurora DB cluster used by the target group. With a high value, the proxy leaves a high percentage of idle database connections open. A low value causes the proxy to close more idle connections and return them to the database.</p>', 'ConnectionPoolConfigurationInfo$ConnectionBorrowTimeout' => '<p>The number of seconds for a proxy to wait for a connection to become available in the connection pool. Only applies when the proxy has opened its maximum number of connections and all connections are busy with client sessions.</p>', 'DBClusterAutomatedBackup$AllocatedStorage' => '<p>For all database engines except Amazon Aurora, <code>AllocatedStorage</code> specifies the allocated storage size in gibibytes (GiB). For Aurora, <code>AllocatedStorage</code> always returns 1, because Aurora DB cluster storage size isn\'t fixed, but instead automatically adjusts as needed.</p>', 'DBClusterAutomatedBackup$Port' => '<p>The port number that the automated backup used for connections.</p> <p>Default: Inherits from the source DB cluster</p> <p>Valid Values: <code>1150-65535</code> </p>', 'DBClusterSnapshot$AllocatedStorage' => '<p>The allocated storage size of the DB cluster snapshot in gibibytes (GiB).</p>', 'DBClusterSnapshot$Port' => '<p>The port that the DB cluster was listening on at the time of the snapshot.</p>', 'DBClusterSnapshot$PercentProgress' => '<p>The percentage of the estimated data that has been transferred.</p>', 'DBInstance$AllocatedStorage' => '<p>The amount of storage in gibibytes (GiB) allocated for the DB instance.</p>', 'DBInstance$BackupRetentionPeriod' => '<p>The number of days for which automatic DB snapshots are retained.</p>', 'DBInstance$DbInstancePort' => '<p>The port that the DB instance listens on. If the DB instance is part of a DB cluster, this can be a different port than the DB cluster port.</p>', 'DBInstanceAutomatedBackup$AllocatedStorage' => '<p>The allocated storage size for the the automated backup in gibibytes (GiB).</p>', 'DBInstanceAutomatedBackup$Port' => '<p>The port number that the automated backup used for connections.</p> <p>Default: Inherits from the source DB instance</p> <p>Valid Values: <code>1150-65535</code> </p>', 'DBProxy$IdleClientTimeout' => '<p>The number of seconds a connection to the proxy can have no activity before the proxy drops the client connection. The proxy keeps the underlying database connection open and puts it back into the connection pool for reuse by later connection requests.</p> <p>Default: 1800 (30 minutes)</p> <p>Constraints: 1 to 28,800</p>', 'DBProxyTarget$Port' => '<p>The port that the RDS Proxy uses to connect to the target RDS DB instance or Aurora DB cluster.</p>', 'DBSnapshot$AllocatedStorage' => '<p>Specifies the allocated storage size in gibibytes (GiB).</p>', 'DBSnapshot$Port' => '<p>Specifies the port that the database engine was listening on at the time of the snapshot.</p>', 'DBSnapshot$PercentProgress' => '<p>The percentage of the estimated data that has been transferred.</p>', 'DownloadDBLogFilePortionMessage$NumberOfLines' => '<p>The number of lines to download. If the number of lines specified results in a file over 1 MB in size, the file is truncated at 1 MB in size.</p> <p>If the NumberOfLines parameter is specified, then the block of lines returned can be from the beginning or the end of the log file, depending on the value of the Marker parameter.</p> <ul> <li> <p>If neither Marker or NumberOfLines are specified, the entire log file is returned up to a maximum of 10000 lines, starting with the most recent log entries first.</p> </li> <li> <p>If NumberOfLines is specified and Marker isn\'t specified, then the most recent lines from the end of the log file are returned.</p> </li> <li> <p>If Marker is specified as "0", then the specified number of lines from the beginning of the log file are returned.</p> </li> <li> <p>You can download the log file in blocks of lines by specifying the size of the block using the NumberOfLines parameter, and by specifying a value of "0" for the Marker parameter in your first request. Include the Marker value returned in the response as the Marker value for the next request, continuing until the AdditionalDataPending response element returns false.</p> </li> </ul>', 'Endpoint$Port' => '<p>Specifies the port that the database engine is listening on.</p>', 'ExportTask$PercentProgress' => '<p>The progress of the snapshot or cluster export task as a percentage.</p>', 'ExportTask$TotalExtractedDataInGB' => '<p>The total amount of data exported, in gigabytes.</p>', 'PerformanceInsightsMetricDimensionGroup$Limit' => '<p>The maximum number of items to fetch for this dimension group.</p>', 'Range$From' => '<p>The minimum value in the range.</p>', 'Range$To' => '<p>The maximum value in the range.</p>', 'ReservedDBInstance$Duration' => '<p>The duration of the reservation in seconds.</p>', 'ReservedDBInstance$DBInstanceCount' => '<p>The number of reserved DB instances.</p>', 'ReservedDBInstancesOffering$Duration' => '<p>The duration of the offering in seconds.</p>', ], ], 'IntegerOptional' => [ 'base' => NULL, 'refs' => [ 'ClusterPendingModifiedValues$BackupRetentionPeriod' => '<p>The number of days for which automatic DB snapshots are retained.</p>', 'ClusterPendingModifiedValues$AllocatedStorage' => '<p>The allocated storage size in gibibytes (GiB) for all database engines except Amazon Aurora. For Aurora, <code>AllocatedStorage</code> always returns 1, because Aurora DB cluster storage size isn\'t fixed, but instead automatically adjusts as needed.</p>', 'ClusterPendingModifiedValues$Iops' => '<p>The Provisioned IOPS (I/O operations per second) value. This setting is only for non-Aurora Multi-AZ DB clusters.</p>', 'ConnectionPoolConfiguration$MaxConnectionsPercent' => '<p>The maximum size of the connection pool for each target in a target group. The value is expressed as a percentage of the <code>max_connections</code> setting for the RDS DB instance or Aurora DB cluster used by the target group.</p> <p>If you specify <code>MaxIdleConnectionsPercent</code>, then you must also include a value for this parameter.</p> <p>Default: <code>10</code> for RDS for Microsoft SQL Server, and <code>100</code> for all other engines</p> <p>Constraints:</p> <ul> <li> <p>Must be between 1 and 100.</p> </li> </ul>', 'ConnectionPoolConfiguration$MaxIdleConnectionsPercent' => '<p>A value that controls how actively the proxy closes idle database connections in the connection pool. The value is expressed as a percentage of the <code>max_connections</code> setting for the RDS DB instance or Aurora DB cluster used by the target group. With a high value, the proxy leaves a high percentage of idle database connections open. A low value causes the proxy to close more idle connections and return them to the database.</p> <p>If you specify this parameter, then you must also include a value for <code>MaxConnectionsPercent</code>.</p> <p>Default: The default value is half of the value of <code>MaxConnectionsPercent</code>. For example, if <code>MaxConnectionsPercent</code> is 80, then the default value of <code>MaxIdleConnectionsPercent</code> is 40. If the value of <code>MaxConnectionsPercent</code> isn\'t specified, then for SQL Server, <code>MaxIdleConnectionsPercent</code> is <code>5</code>, and for all other engines, the default is <code>50</code>.</p> <p>Constraints:</p> <ul> <li> <p>Must be between 0 and the value of <code>MaxConnectionsPercent</code>.</p> </li> </ul>', 'ConnectionPoolConfiguration$ConnectionBorrowTimeout' => '<p>The number of seconds for a proxy to wait for a connection to become available in the connection pool. This setting only applies when the proxy has opened its maximum number of connections and all connections are busy with client sessions. For an unlimited wait time, specify <code>0</code>.</p> <p>Default: <code>120</code> </p> <p>Constraints:</p> <ul> <li> <p>Must be between 0 and 3600.</p> </li> </ul>', 'CreateDBClusterMessage$BackupRetentionPeriod' => '<p>The number of days for which automated backups are retained.</p> <p>Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters</p> <p>Default: <code>1</code> </p> <p>Constraints:</p> <ul> <li> <p>Must be a value from 1 to 35.</p> </li> </ul>', 'CreateDBClusterMessage$Port' => '<p>The port number on which the instances in the DB cluster accept connections.</p> <p>Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters</p> <p>Valid Values: <code>1150-65535</code> </p> <p>Default:</p> <ul> <li> <p>RDS for MySQL and Aurora MySQL - <code>3306</code> </p> </li> <li> <p>RDS for PostgreSQL and Aurora PostgreSQL - <code>5432</code> </p> </li> </ul>', 'CreateDBClusterMessage$AllocatedStorage' => '<p>The amount of storage in gibibytes (GiB) to allocate to each DB instance in the Multi-AZ DB cluster.</p> <p>Valid for Cluster Type: Multi-AZ DB clusters only</p> <p>This setting is required to create a Multi-AZ DB cluster.</p>', 'CreateDBClusterMessage$Iops' => '<p>The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for each DB instance in the Multi-AZ DB cluster.</p> <p>For information about valid IOPS values, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS">Provisioned IOPS storage</a> in the <i>Amazon RDS User Guide</i>.</p> <p>This setting is required to create a Multi-AZ DB cluster.</p> <p>Valid for Cluster Type: Multi-AZ DB clusters only</p> <p>Constraints:</p> <ul> <li> <p>Must be a multiple between .5 and 50 of the storage amount for the DB cluster.</p> </li> </ul>', 'CreateDBClusterMessage$MonitoringInterval' => '<p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB cluster. To turn off collecting Enhanced Monitoring metrics, specify <code>0</code>.</p> <p>If <code>MonitoringRoleArn</code> is specified, also set <code>MonitoringInterval</code> to a value other than <code>0</code>.</p> <p>Valid for Cluster Type: Multi-AZ DB clusters only</p> <p>Valid Values: <code>0 | 1 | 5 | 10 | 15 | 30 | 60</code> </p> <p>Default: <code>0</code> </p>', 'CreateDBClusterMessage$PerformanceInsightsRetentionPeriod' => '<p>The number of days to retain Performance Insights data.</p> <p>Valid for Cluster Type: Multi-AZ DB clusters only</p> <p>Valid Values:</p> <ul> <li> <p> <code>7</code> </p> </li> <li> <p> <i>month</i> * 31, where <i>month</i> is a number of months from 1-23. Examples: <code>93</code> (3 months * 31), <code>341</code> (11 months * 31), <code>589</code> (19 months * 31)</p> </li> <li> <p> <code>731</code> </p> </li> </ul> <p>Default: <code>7</code> days</p> <p>If you specify a retention period that isn\'t valid, such as <code>94</code>, Amazon RDS issues an error.</p>', 'CreateDBInstanceMessage$AllocatedStorage' => '<p>The amount of storage in gibibytes (GiB) to allocate for the DB instance.</p> <p>This setting doesn\'t apply to Amazon Aurora DB instances. Aurora cluster volumes automatically grow as the amount of data in your database increases, though you are only charged for the space that you use in an Aurora cluster volume.</p> <dl> <dt>Amazon RDS Custom</dt> <dd> <p>Constraints to the amount of storage for each storage type are the following:</p> <ul> <li> <p>General Purpose (SSD) storage (gp2, gp3): Must be an integer from 40 to 65536 for RDS Custom for Oracle, 16384 for RDS Custom for SQL Server.</p> </li> <li> <p>Provisioned IOPS storage (io1, io2): Must be an integer from 40 to 65536 for RDS Custom for Oracle, 16384 for RDS Custom for SQL Server.</p> </li> </ul> </dd> <dt>RDS for Db2</dt> <dd> <p>Constraints to the amount of storage for each storage type are the following:</p> <ul> <li> <p>General Purpose (SSD) storage (gp3): Must be an integer from 20 to 65536.</p> </li> <li> <p>Provisioned IOPS storage (io1, io2): Must be an integer from 100 to 65536.</p> </li> </ul> </dd> <dt>RDS for MariaDB</dt> <dd> <p>Constraints to the amount of storage for each storage type are the following:</p> <ul> <li> <p>General Purpose (SSD) storage (gp2, gp3): Must be an integer from 20 to 65536.</p> </li> <li> <p>Provisioned IOPS storage (io1, io2): Must be an integer from 100 to 65536.</p> </li> <li> <p>Magnetic storage (standard): Must be an integer from 5 to 3072.</p> </li> </ul> </dd> <dt>RDS for MySQL</dt> <dd> <p>Constraints to the amount of storage for each storage type are the following:</p> <ul> <li> <p>General Purpose (SSD) storage (gp2, gp3): Must be an integer from 20 to 65536.</p> </li> <li> <p>Provisioned IOPS storage (io1, io2): Must be an integer from 100 to 65536.</p> </li> <li> <p>Magnetic storage (standard): Must be an integer from 5 to 3072.</p> </li> </ul> </dd> <dt>RDS for Oracle</dt> <dd> <p>Constraints to the amount of storage for each storage type are the following:</p> <ul> <li> <p>General Purpose (SSD) storage (gp2, gp3): Must be an integer from 20 to 65536.</p> </li> <li> <p>Provisioned IOPS storage (io1, io2): Must be an integer from 100 to 65536.</p> </li> <li> <p>Magnetic storage (standard): Must be an integer from 10 to 3072.</p> </li> </ul> </dd> <dt>RDS for PostgreSQL</dt> <dd> <p>Constraints to the amount of storage for each storage type are the following:</p> <ul> <li> <p>General Purpose (SSD) storage (gp2, gp3): Must be an integer from 20 to 65536.</p> </li> <li> <p>Provisioned IOPS storage (io1, io2): Must be an integer from 100 to 65536.</p> </li> <li> <p>Magnetic storage (standard): Must be an integer from 5 to 3072.</p> </li> </ul> </dd> <dt>RDS for SQL Server</dt> <dd> <p>Constraints to the amount of storage for each storage type are the following:</p> <ul> <li> <p>General Purpose (SSD) storage (gp2, gp3):</p> <ul> <li> <p>Enterprise and Standard editions: Must be an integer from 20 to 16384.</p> </li> <li> <p>Web and Express editions: Must be an integer from 20 to 16384.</p> </li> </ul> </li> <li> <p>Provisioned IOPS storage (io1, io2):</p> <ul> <li> <p>Enterprise and Standard editions: Must be an integer from 100 to 16384.</p> </li> <li> <p>Web and Express editions: Must be an integer from 100 to 16384.</p> </li> </ul> </li> <li> <p>Magnetic storage (standard):</p> <ul> <li> <p>Enterprise and Standard editions: Must be an integer from 20 to 1024.</p> </li> <li> <p>Web and Express editions: Must be an integer from 20 to 1024.</p> </li> </ul> </li> </ul> </dd> </dl>', 'CreateDBInstanceMessage$BackupRetentionPeriod' => '<p>The number of days for which automated backups are retained. Setting this parameter to a positive number enables backups. Setting this parameter to <code>0</code> disables automated backups.</p> <p>This setting doesn\'t apply to Amazon Aurora DB instances. The retention period for automated backups is managed by the DB cluster.</p> <p>Default: <code>1</code> </p> <p>Constraints:</p> <ul> <li> <p>Must be a value from 0 to 35.</p> </li> <li> <p>Can\'t be set to 0 if the DB instance is a source to read replicas.</p> </li> <li> <p>Can\'t be set to 0 for an RDS Custom for Oracle DB instance.</p> </li> </ul>', 'CreateDBInstanceMessage$Port' => '<p>The port number on which the database accepts connections.</p> <p>This setting doesn\'t apply to Aurora DB instances. The port number is managed by the cluster.</p> <p>Valid Values: <code>1150-65535</code> </p> <p>Default:</p> <ul> <li> <p>RDS for Db2 - <code>50000</code> </p> </li> <li> <p>RDS for MariaDB - <code>3306</code> </p> </li> <li> <p>RDS for Microsoft SQL Server - <code>1433</code> </p> </li> <li> <p>RDS for MySQL - <code>3306</code> </p> </li> <li> <p>RDS for Oracle - <code>1521</code> </p> </li> <li> <p>RDS for PostgreSQL - <code>5432</code> </p> </li> </ul> <p>Constraints:</p> <ul> <li> <p>For RDS for Microsoft SQL Server, the value can\'t be <code>1234</code>, <code>1434</code>, <code>3260</code>, <code>3343</code>, <code>3389</code>, <code>47001</code>, or <code>49152-49156</code>.</p> </li> </ul>', 'CreateDBInstanceMessage$Iops' => '<p>The amount of Provisioned IOPS (input/output operations per second) to initially allocate for the DB instance. For information about valid IOPS values, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html">Amazon RDS DB instance storage</a> in the <i>Amazon RDS User Guide</i>.</p> <p>This setting doesn\'t apply to Amazon Aurora DB instances. Storage is managed by the DB cluster.</p> <p>Constraints:</p> <ul> <li> <p>For RDS for Db2, MariaDB, MySQL, Oracle, and PostgreSQL - Must be a multiple between .5 and 50 of the storage amount for the DB instance.</p> </li> <li> <p>For RDS for SQL Server - Must be a multiple between 1 and 50 of the storage amount for the DB instance.</p> </li> </ul>', 'CreateDBInstanceMessage$MonitoringInterval' => '<p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance. To disable collection of Enhanced Monitoring metrics, specify <code>0</code>.</p> <p>If <code>MonitoringRoleArn</code> is specified, then you must set <code>MonitoringInterval</code> to a value other than <code>0</code>.</p> <p>This setting doesn\'t apply to RDS Custom DB instances.</p> <p>Valid Values: <code>0 | 1 | 5 | 10 | 15 | 30 | 60</code> </p> <p>Default: <code>0</code> </p>', 'CreateDBInstanceMessage$PromotionTier' => '<p>The order of priority in which an Aurora Replica is promoted to the primary instance after a failure of the existing primary instance. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.AuroraHighAvailability.html#Aurora.Managing.FaultTolerance"> Fault Tolerance for an Aurora DB Cluster</a> in the <i>Amazon Aurora User Guide</i>.</p> <p>This setting doesn\'t apply to RDS Custom DB instances.</p> <p>Default: <code>1</code> </p> <p>Valid Values: <code>0 - 15</code> </p>', 'CreateDBInstanceMessage$PerformanceInsightsRetentionPeriod' => '<p>The number of days to retain Performance Insights data.</p> <p>This setting doesn\'t apply to RDS Custom DB instances.</p> <p>Valid Values:</p> <ul> <li> <p> <code>7</code> </p> </li> <li> <p> <i>month</i> * 31, where <i>month</i> is a number of months from 1-23. Examples: <code>93</code> (3 months * 31), <code>341</code> (11 months * 31), <code>589</code> (19 months * 31)</p> </li> <li> <p> <code>731</code> </p> </li> </ul> <p>Default: <code>7</code> days</p> <p>If you specify a retention period that isn\'t valid, such as <code>94</code>, Amazon RDS returns an error.</p>', 'CreateDBInstanceMessage$MaxAllocatedStorage' => '<p>The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB instance.</p> <p>For more information about this setting, including limitations that apply to it, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling"> Managing capacity automatically with Amazon RDS storage autoscaling</a> in the <i>Amazon RDS User Guide</i>.</p> <p>This setting doesn\'t apply to the following DB instances:</p> <ul> <li> <p>Amazon Aurora (Storage is managed by the DB cluster.)</p> </li> <li> <p>RDS Custom</p> </li> </ul>', 'CreateDBInstanceMessage$StorageThroughput' => '<p>The storage throughput value for the DB instance.</p> <p>This setting applies only to the <code>gp3</code> storage type.</p> <p>This setting doesn\'t apply to Amazon Aurora or RDS Custom DB instances.</p>', 'CreateDBInstanceReadReplicaMessage$Port' => '<p>The port number that the DB instance uses for connections.</p> <p>Valid Values: <code>1150-65535</code> </p> <p>Default: Inherits the value from the source DB instance.</p>', 'CreateDBInstanceReadReplicaMessage$Iops' => '<p>The amount of Provisioned IOPS (input/output operations per second) to initially allocate for the DB instance.</p>', 'CreateDBInstanceReadReplicaMessage$MonitoringInterval' => '<p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the read replica. To disable collection of Enhanced Monitoring metrics, specify <code>0</code>. The default is <code>0</code>.</p> <p>If <code>MonitoringRoleArn</code> is specified, then you must set <code>MonitoringInterval</code> to a value other than <code>0</code>.</p> <p>This setting doesn\'t apply to RDS Custom DB instances.</p> <p>Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code> </p> <p>Default: <code>0</code> </p>', 'CreateDBInstanceReadReplicaMessage$PerformanceInsightsRetentionPeriod' => '<p>The number of days to retain Performance Insights data.</p> <p>This setting doesn\'t apply to RDS Custom DB instances.</p> <p>Valid Values:</p> <ul> <li> <p> <code>7</code> </p> </li> <li> <p> <i>month</i> * 31, where <i>month</i> is a number of months from 1-23. Examples: <code>93</code> (3 months * 31), <code>341</code> (11 months * 31), <code>589</code> (19 months * 31)</p> </li> <li> <p> <code>731</code> </p> </li> </ul> <p>Default: <code>7</code> days</p> <p>If you specify a retention period that isn\'t valid, such as <code>94</code>, Amazon RDS returns an error.</p>', 'CreateDBInstanceReadReplicaMessage$MaxAllocatedStorage' => '<p>The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB instance.</p> <p>For more information about this setting, including limitations that apply to it, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling"> Managing capacity automatically with Amazon RDS storage autoscaling</a> in the <i>Amazon RDS User Guide</i>.</p>', 'CreateDBInstanceReadReplicaMessage$StorageThroughput' => '<p>Specifies the storage throughput value for the read replica.</p> <p>This setting doesn\'t apply to RDS Custom or Amazon Aurora DB instances.</p>', 'CreateDBInstanceReadReplicaMessage$AllocatedStorage' => '<p>The amount of storage (in gibibytes) to allocate initially for the read replica. Follow the allocation rules specified in <code>CreateDBInstance</code>.</p> <note> <p>Be sure to allocate enough storage for your read replica so that the create operation can succeed. You can also allocate additional storage for future growth.</p> </note>', 'CreateDBProxyRequest$IdleClientTimeout' => '<p>The number of seconds that a connection to the proxy can be inactive before the proxy disconnects it. You can set this value higher or lower than the connection timeout limit for the associated database.</p>', 'CreateDBShardGroupMessage$ComputeRedundancy' => '<p>Specifies whether to create standby instances for the DB shard group. Valid values are the following:</p> <ul> <li> <p>0 - Creates a single, primary DB instance for each physical shard. This is the default value, and the only one supported for the preview.</p> </li> <li> <p>1 - Creates a primary DB instance and a standby instance in a different Availability Zone (AZ) for each physical shard.</p> </li> <li> <p>2 - Creates a primary DB instance and two standby instances in different AZs for each physical shard.</p> </li> </ul>', 'DBCluster$AllocatedStorage' => '<p>For all database engines except Amazon Aurora, <code>AllocatedStorage</code> specifies the allocated storage size in gibibytes (GiB). For Aurora, <code>AllocatedStorage</code> always returns 1, because Aurora DB cluster storage size isn\'t fixed, but instead automatically adjusts as needed.</p>', 'DBCluster$BackupRetentionPeriod' => '<p>The number of days for which automatic DB snapshots are retained.</p>', 'DBCluster$Port' => '<p>The port that the database engine is listening on.</p>', 'DBCluster$Capacity' => '<p>The current capacity of an Aurora Serverless v1 DB cluster. The capacity is <code>0</code> (zero) when the cluster is paused.</p> <p>For more information about Aurora Serverless v1, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html">Using Amazon Aurora Serverless v1</a> in the <i>Amazon Aurora User Guide</i>.</p>', 'DBCluster$Iops' => '<p>The Provisioned IOPS (I/O operations per second) value.</p> <p>This setting is only for non-Aurora Multi-AZ DB clusters.</p>', 'DBCluster$MonitoringInterval' => '<p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB cluster.</p> <p>This setting is only for non-Aurora Multi-AZ DB clusters.</p>', 'DBCluster$PerformanceInsightsRetentionPeriod' => '<p>The number of days to retain Performance Insights data.</p> <p>This setting is only for non-Aurora Multi-AZ DB clusters.</p> <p>Valid Values:</p> <ul> <li> <p> <code>7</code> </p> </li> <li> <p> <i>month</i> * 31, where <i>month</i> is a number of months from 1-23. Examples: <code>93</code> (3 months * 31), <code>341</code> (11 months * 31), <code>589</code> (19 months * 31)</p> </li> <li> <p> <code>731</code> </p> </li> </ul> <p>Default: <code>7</code> days</p>', 'DBCluster$StorageThroughput' => '<p>The storage throughput for the DB cluster. The throughput is automatically set based on the IOPS that you provision, and is not configurable.</p> <p>This setting is only for non-Aurora Multi-AZ DB clusters.</p>', 'DBClusterAutomatedBackup$BackupRetentionPeriod' => '<p>The retention period for the automated backups.</p>', 'DBClusterAutomatedBackup$Iops' => '<p>The IOPS (I/O operations per second) value for the automated backup.</p> <p>This setting is only for non-Aurora Multi-AZ DB clusters.</p>', 'DBClusterAutomatedBackup$StorageThroughput' => '<p>The storage throughput for the automated backup. The throughput is automatically set based on the IOPS that you provision, and is not configurable.</p> <p>This setting is only for non-Aurora Multi-AZ DB clusters.</p>', 'DBClusterCapacityInfo$PendingCapacity' => '<p>A value that specifies the capacity that the DB cluster scales to next.</p>', 'DBClusterCapacityInfo$CurrentCapacity' => '<p>The current capacity of the DB cluster.</p>', 'DBClusterCapacityInfo$SecondsBeforeTimeout' => '<p>The number of seconds before a call to <code>ModifyCurrentDBClusterCapacity</code> times out.</p>', 'DBClusterMember$PromotionTier' => '<p>A value that specifies the order in which an Aurora Replica is promoted to the primary instance after a failure of the existing primary instance. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.FaultTolerance"> Fault Tolerance for an Aurora DB Cluster</a> in the <i>Amazon Aurora User Guide</i>.</p>', 'DBClusterSnapshot$StorageThroughput' => '<p>The storage throughput for the DB cluster snapshot. The throughput is automatically set based on the IOPS that you provision, and is not configurable.</p> <p>This setting is only for non-Aurora Multi-AZ DB clusters.</p>', 'DBInstance$Iops' => '<p>The Provisioned IOPS (I/O operations per second) value for the DB instance.</p>', 'DBInstance$MonitoringInterval' => '<p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance.</p>', 'DBInstance$PromotionTier' => '<p>The order of priority in which an Aurora Replica is promoted to the primary instance after a failure of the existing primary instance. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.AuroraHighAvailability.html#Aurora.Managing.FaultTolerance"> Fault Tolerance for an Aurora DB Cluster</a> in the <i>Amazon Aurora User Guide</i>.</p>', 'DBInstance$PerformanceInsightsRetentionPeriod' => '<p>The number of days to retain Performance Insights data.</p> <p>Valid Values:</p> <ul> <li> <p> <code>7</code> </p> </li> <li> <p> <i>month</i> * 31, where <i>month</i> is a number of months from 1-23. Examples: <code>93</code> (3 months * 31), <code>341</code> (11 months * 31), <code>589</code> (19 months * 31)</p> </li> <li> <p> <code>731</code> </p> </li> </ul> <p>Default: <code>7</code> days</p>', 'DBInstance$MaxAllocatedStorage' => '<p>The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB instance.</p>', 'DBInstance$StorageThroughput' => '<p>The storage throughput for the DB instance.</p> <p>This setting applies only to the <code>gp3</code> storage type.</p>', 'DBInstanceAutomatedBackup$Iops' => '<p>The IOPS (I/O operations per second) value for the automated backup.</p>', 'DBInstanceAutomatedBackup$BackupRetentionPeriod' => '<p>The retention period for the automated backups.</p>', 'DBInstanceAutomatedBackup$StorageThroughput' => '<p>The storage throughput for the automated backup.</p>', 'DBShardGroup$ComputeRedundancy' => '<p>Specifies whether to create standby instances for the DB shard group. Valid values are the following:</p> <ul> <li> <p>0 - Creates a single, primary DB instance for each physical shard. This is the default value, and the only one supported for the preview.</p> </li> <li> <p>1 - Creates a primary DB instance and a standby instance in a different Availability Zone (AZ) for each physical shard.</p> </li> <li> <p>2 - Creates a primary DB instance and two standby instances in different AZs for each physical shard.</p> </li> </ul>', 'DBSnapshot$Iops' => '<p>Specifies the Provisioned IOPS (I/O operations per second) value of the DB instance at the time of the snapshot.</p>', 'DBSnapshot$StorageThroughput' => '<p>Specifies the storage throughput for the DB snapshot.</p>', 'DescribeCertificatesMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so you can retrieve the remaining results.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeDBClusterAutomatedBackupsMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.</p>', 'DescribeDBClusterBacktracksMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so you can retrieve the remaining results.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeDBClusterEndpointsMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so you can retrieve the remaining results.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeDBClusterParameterGroupsMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so you can retrieve the remaining results.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeDBClusterParametersMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so you can retrieve the remaining results.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeDBClusterSnapshotsMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so you can retrieve the remaining results.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeDBClustersMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so you can retrieve the remaining results.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100</p>', 'DescribeDBEngineVersionsMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more than the <code>MaxRecords</code> value is available, a pagination token called a marker is included in the response so you can retrieve the remaining results.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeDBInstanceAutomatedBackupsMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.</p>', 'DescribeDBInstancesMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeDBLogFilesMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a pagination token called a marker is included in the response so you can retrieve the remaining results.</p>', 'DescribeDBParameterGroupsMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeDBParametersMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeDBRecommendationsMessage$MaxRecords' => '<p>The maximum number of recommendations to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.</p>', 'DescribeDBSecurityGroupsMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeDBSnapshotTenantDatabasesMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.</p>', 'DescribeDBSnapshotsMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeDBSubnetGroupsMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeEngineDefaultClusterParametersMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so you can retrieve the remaining results.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeEngineDefaultParametersMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so you can retrieve the remaining results.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeEventSubscriptionsMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeEventsMessage$Duration' => '<p>The number of minutes to retrieve events for.</p> <p>Default: 60</p>', 'DescribeEventsMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeGlobalClustersMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeIntegrationsMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeOptionGroupOptionsMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeOptionGroupsMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeOrderableDBInstanceOptionsMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 1000.</p>', 'DescribePendingMaintenanceActionsMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeReservedDBInstancesMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more than the <code>MaxRecords</code> value is available, a pagination token called a marker is included in the response so you can retrieve the remaining results.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeReservedDBInstancesOfferingsMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more than the <code>MaxRecords</code> value is available, a pagination token called a marker is included in the response so you can retrieve the remaining results.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeSourceRegionsMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so you can retrieve the remaining results.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeTenantDatabasesMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.</p>', 'ModifyCurrentDBClusterCapacityMessage$Capacity' => '<p>The DB cluster capacity.</p> <p>When you change the capacity of a paused Aurora Serverless v1 DB cluster, it automatically resumes.</p> <p>Constraints:</p> <ul> <li> <p>For Aurora MySQL, valid capacity values are <code>1</code>, <code>2</code>, <code>4</code>, <code>8</code>, <code>16</code>, <code>32</code>, <code>64</code>, <code>128</code>, and <code>256</code>.</p> </li> <li> <p>For Aurora PostgreSQL, valid capacity values are <code>2</code>, <code>4</code>, <code>8</code>, <code>16</code>, <code>32</code>, <code>64</code>, <code>192</code>, and <code>384</code>.</p> </li> </ul>', 'ModifyCurrentDBClusterCapacityMessage$SecondsBeforeTimeout' => '<p>The amount of time, in seconds, that Aurora Serverless v1 tries to find a scaling point to perform seamless scaling before enforcing the timeout action. The default is 300.</p> <p>Specify a value between 10 and 600 seconds.</p>', 'ModifyDBClusterMessage$BackupRetentionPeriod' => '<p>The number of days for which automated backups are retained. Specify a minimum value of <code>1</code>.</p> <p>Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters</p> <p>Default: <code>1</code> </p> <p>Constraints:</p> <ul> <li> <p>Must be a value from 1 to 35.</p> </li> </ul>', 'ModifyDBClusterMessage$Port' => '<p>The port number on which the DB cluster accepts connections.</p> <p>Valid for Cluster Type: Aurora DB clusters only</p> <p>Valid Values: <code>1150-65535</code> </p> <p>Default: The same port as the original DB cluster.</p>', 'ModifyDBClusterMessage$AllocatedStorage' => '<p>The amount of storage in gibibytes (GiB) to allocate to each DB instance in the Multi-AZ DB cluster.</p> <p>Valid for Cluster Type: Multi-AZ DB clusters only</p>', 'ModifyDBClusterMessage$Iops' => '<p>The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for each DB instance in the Multi-AZ DB cluster.</p> <p>For information about valid IOPS values, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS">Amazon RDS Provisioned IOPS storage</a> in the <i>Amazon RDS User Guide</i>.</p> <p>Valid for Cluster Type: Multi-AZ DB clusters only</p> <p>Constraints:</p> <ul> <li> <p>Must be a multiple between .5 and 50 of the storage amount for the DB cluster.</p> </li> </ul>', 'ModifyDBClusterMessage$MonitoringInterval' => '<p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB cluster. To turn off collecting Enhanced Monitoring metrics, specify <code>0</code>.</p> <p>If <code>MonitoringRoleArn</code> is specified, also set <code>MonitoringInterval</code> to a value other than <code>0</code>.</p> <p>Valid for Cluster Type: Multi-AZ DB clusters only</p> <p>Valid Values: <code>0 | 1 | 5 | 10 | 15 | 30 | 60</code> </p> <p>Default: <code>0</code> </p>', 'ModifyDBClusterMessage$PerformanceInsightsRetentionPeriod' => '<p>The number of days to retain Performance Insights data.</p> <p>Valid for Cluster Type: Multi-AZ DB clusters only</p> <p>Valid Values:</p> <ul> <li> <p> <code>7</code> </p> </li> <li> <p> <i>month</i> * 31, where <i>month</i> is a number of months from 1-23. Examples: <code>93</code> (3 months * 31), <code>341</code> (11 months * 31), <code>589</code> (19 months * 31)</p> </li> <li> <p> <code>731</code> </p> </li> </ul> <p>Default: <code>7</code> days</p> <p>If you specify a retention period that isn\'t valid, such as <code>94</code>, Amazon RDS issues an error.</p>', 'ModifyDBInstanceMessage$AllocatedStorage' => '<p>The new amount of storage in gibibytes (GiB) to allocate for the DB instance.</p> <p>For RDS for Db2, MariaDB, RDS for MySQL, RDS for Oracle, and RDS for PostgreSQL, the value supplied must be at least 10% greater than the current value. Values that are not at least 10% greater than the existing value are rounded up so that they are 10% greater than the current value.</p> <p>For the valid values for allocated storage for each engine, see <code>CreateDBInstance</code>.</p> <p>Constraints:</p> <ul> <li> <p>When you increase the allocated storage for a DB instance that uses Provisioned IOPS (<code>gp3</code>, <code>io1</code>, or <code>io2</code> storage type), you must also specify the <code>Iops</code> parameter. You can use the current value for <code>Iops</code>.</p> </li> </ul>', 'ModifyDBInstanceMessage$BackupRetentionPeriod' => '<p>The number of days to retain automated backups. Setting this parameter to a positive number enables backups. Setting this parameter to 0 disables automated backups.</p> <note> <p>Enabling and disabling backups can result in a brief I/O suspension that lasts from a few seconds to a few minutes, depending on the size and class of your DB instance.</p> </note> <p>These changes are applied during the next maintenance window unless the <code>ApplyImmediately</code> parameter is enabled for this request. If you change the parameter from one non-zero value to another non-zero value, the change is asynchronously applied as soon as possible.</p> <p>This setting doesn\'t apply to Amazon Aurora DB instances. The retention period for automated backups is managed by the DB cluster. For more information, see <code>ModifyDBCluster</code>.</p> <p>Default: Uses existing setting</p> <p>Constraints:</p> <ul> <li> <p>Must be a value from 0 to 35.</p> </li> <li> <p>Can\'t be set to 0 if the DB instance is a source to read replicas.</p> </li> <li> <p>Can\'t be set to 0 for an RDS Custom for Oracle DB instance.</p> </li> </ul>', 'ModifyDBInstanceMessage$Iops' => '<p>The new Provisioned IOPS (I/O operations per second) value for the RDS instance.</p> <p>Changing this setting doesn\'t result in an outage and the change is applied during the next maintenance window unless the <code>ApplyImmediately</code> parameter is enabled for this request. If you are migrating from Provisioned IOPS to standard storage, set this value to 0. The DB instance will require a reboot for the change in storage type to take effect.</p> <p>If you choose to migrate your DB instance from using standard storage to using Provisioned IOPS, or from using Provisioned IOPS to using standard storage, the process can take time. The duration of the migration depends on several factors such as database load, storage size, storage type (standard or Provisioned IOPS), amount of IOPS provisioned (if any), and the number of prior scale storage operations. Typical migration times are under 24 hours, but the process can take up to several days in some cases. During the migration, the DB instance is available for use, but might experience performance degradation. While the migration takes place, nightly backups for the instance are suspended. No other Amazon RDS operations can take place for the instance, including modifying the instance, rebooting the instance, deleting the instance, creating a read replica for the instance, and creating a DB snapshot of the instance.</p> <p>Constraints:</p> <ul> <li> <p>For RDS for MariaDB, RDS for MySQL, RDS for Oracle, and RDS for PostgreSQL - The value supplied must be at least 10% greater than the current value. Values that are not at least 10% greater than the existing value are rounded up so that they are 10% greater than the current value.</p> </li> <li> <p>When you increase the Provisioned IOPS, you must also specify the <code>AllocatedStorage</code> parameter. You can use the current value for <code>AllocatedStorage</code>.</p> </li> </ul> <p>Default: Uses existing setting</p>', 'ModifyDBInstanceMessage$MonitoringInterval' => '<p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance. To disable collection of Enhanced Monitoring metrics, specify <code>0</code>.</p> <p>If <code>MonitoringRoleArn</code> is specified, set <code>MonitoringInterval</code> to a value other than <code>0</code>.</p> <p>This setting doesn\'t apply to RDS Custom DB instances.</p> <p>Valid Values: <code>0 | 1 | 5 | 10 | 15 | 30 | 60</code> </p> <p>Default: <code>0</code> </p>', 'ModifyDBInstanceMessage$DBPortNumber' => '<p>The port number on which the database accepts connections.</p> <p>The value of the <code>DBPortNumber</code> parameter must not match any of the port values specified for options in the option group for the DB instance.</p> <p>If you change the <code>DBPortNumber</code> value, your database restarts regardless of the value of the <code>ApplyImmediately</code> parameter.</p> <p>This setting doesn\'t apply to RDS Custom DB instances.</p> <p>Valid Values: <code>1150-65535</code> </p> <p>Default:</p> <ul> <li> <p>Amazon Aurora - <code>3306</code> </p> </li> <li> <p>RDS for Db2 - <code>50000</code> </p> </li> <li> <p>RDS for MariaDB - <code>3306</code> </p> </li> <li> <p>RDS for Microsoft SQL Server - <code>1433</code> </p> </li> <li> <p>RDS for MySQL - <code>3306</code> </p> </li> <li> <p>RDS for Oracle - <code>1521</code> </p> </li> <li> <p>RDS for PostgreSQL - <code>5432</code> </p> </li> </ul> <p>Constraints:</p> <ul> <li> <p>For RDS for Microsoft SQL Server, the value can\'t be <code>1234</code>, <code>1434</code>, <code>3260</code>, <code>3343</code>, <code>3389</code>, <code>47001</code>, or <code>49152-49156</code>.</p> </li> </ul>', 'ModifyDBInstanceMessage$PromotionTier' => '<p>The order of priority in which an Aurora Replica is promoted to the primary instance after a failure of the existing primary instance. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.AuroraHighAvailability.html#Aurora.Managing.FaultTolerance"> Fault Tolerance for an Aurora DB Cluster</a> in the <i>Amazon Aurora User Guide</i>.</p> <p>This setting doesn\'t apply to RDS Custom DB instances.</p> <p>Default: <code>1</code> </p> <p>Valid Values: <code>0 - 15</code> </p>', 'ModifyDBInstanceMessage$PerformanceInsightsRetentionPeriod' => '<p>The number of days to retain Performance Insights data.</p> <p>This setting doesn\'t apply to RDS Custom DB instances.</p> <p>Valid Values:</p> <ul> <li> <p> <code>7</code> </p> </li> <li> <p> <i>month</i> * 31, where <i>month</i> is a number of months from 1-23. Examples: <code>93</code> (3 months * 31), <code>341</code> (11 months * 31), <code>589</code> (19 months * 31)</p> </li> <li> <p> <code>731</code> </p> </li> </ul> <p>Default: <code>7</code> days</p> <p>If you specify a retention period that isn\'t valid, such as <code>94</code>, Amazon RDS returns an error.</p>', 'ModifyDBInstanceMessage$MaxAllocatedStorage' => '<p>The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB instance.</p> <p>For more information about this setting, including limitations that apply to it, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling"> Managing capacity automatically with Amazon RDS storage autoscaling</a> in the <i>Amazon RDS User Guide</i>.</p> <p>This setting doesn\'t apply to RDS Custom DB instances.</p>', 'ModifyDBInstanceMessage$ResumeFullAutomationModeMinutes' => '<p>The number of minutes to pause the automation. When the time period ends, RDS Custom resumes full automation.</p> <p>Default: <code>60</code> </p> <p>Constraints:</p> <ul> <li> <p>Must be at least 60.</p> </li> <li> <p>Must be no more than 1,440.</p> </li> </ul>', 'ModifyDBInstanceMessage$StorageThroughput' => '<p>The storage throughput value for the DB instance.</p> <p>This setting applies only to the <code>gp3</code> storage type.</p> <p>This setting doesn\'t apply to Amazon Aurora or RDS Custom DB instances.</p>', 'ModifyDBProxyRequest$IdleClientTimeout' => '<p>The number of seconds that a connection to the proxy can be inactive before the proxy disconnects it. You can set this value higher or lower than the connection timeout limit for the associated database.</p>', 'Option$Port' => '<p>If required, the port configured for this option to use.</p>', 'OptionConfiguration$Port' => '<p>The optional port for the option.</p>', 'OptionGroupOption$DefaultPort' => '<p>If the option requires a port, specifies the default port for the option.</p>', 'OrderableDBInstanceOption$MinStorageSize' => '<p>Minimum storage size for a DB instance.</p>', 'OrderableDBInstanceOption$MaxStorageSize' => '<p>Maximum storage size for a DB instance.</p>', 'OrderableDBInstanceOption$MinIopsPerDbInstance' => '<p>Minimum total provisioned IOPS for a DB instance.</p>', 'OrderableDBInstanceOption$MaxIopsPerDbInstance' => '<p>Maximum total provisioned IOPS for a DB instance.</p>', 'OrderableDBInstanceOption$MinStorageThroughputPerDbInstance' => '<p>Minimum storage throughput for a DB instance.</p>', 'OrderableDBInstanceOption$MaxStorageThroughputPerDbInstance' => '<p>Maximum storage throughput for a DB instance.</p>', 'PendingModifiedValues$AllocatedStorage' => '<p>The allocated storage size for the DB instance specified in gibibytes (GiB).</p>', 'PendingModifiedValues$Port' => '<p>The port for the DB instance.</p>', 'PendingModifiedValues$BackupRetentionPeriod' => '<p>The number of days for which automated backups are retained.</p>', 'PendingModifiedValues$Iops' => '<p>The Provisioned IOPS value for the DB instance.</p>', 'PendingModifiedValues$StorageThroughput' => '<p>The storage throughput of the DB instance.</p>', 'PromoteReadReplicaMessage$BackupRetentionPeriod' => '<p>The number of days for which automated backups are retained. Setting this parameter to a positive number enables backups. Setting this parameter to 0 disables automated backups.</p> <p>Default: 1</p> <p>Constraints:</p> <ul> <li> <p>Must be a value from 0 to 35.</p> </li> <li> <p>Can\'t be set to 0 if the DB instance is a source to read replicas.</p> </li> </ul>', 'PurchaseReservedDBInstancesOfferingMessage$DBInstanceCount' => '<p>The number of instances to reserve.</p> <p>Default: <code>1</code> </p>', 'Range$Step' => '<p>The step value for the range. For example, if you have a range of 5,000 to 10,000, with a step value of 1,000, the valid values start at 5,000 and step up by 1,000. Even though 7,500 is within the range, it isn\'t a valid value for the range. The valid values are 5,000, 6,000, 7,000, 8,000...</p>', 'RestoreDBClusterFromS3Message$BackupRetentionPeriod' => '<p>The number of days for which automated backups of the restored DB cluster are retained. You must specify a minimum value of 1.</p> <p>Default: 1</p> <p>Constraints:</p> <ul> <li> <p>Must be a value from 1 to 35</p> </li> </ul>', 'RestoreDBClusterFromS3Message$Port' => '<p>The port number on which the instances in the restored DB cluster accept connections.</p> <p>Default: <code>3306</code> </p>', 'RestoreDBClusterFromSnapshotMessage$Port' => '<p>The port number on which the new DB cluster accepts connections.</p> <p>Constraints: This value must be <code>1150-65535</code> </p> <p>Default: The same port as the original DB cluster.</p> <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>', 'RestoreDBClusterFromSnapshotMessage$Iops' => '<p>The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for each DB instance in the Multi-AZ DB cluster.</p> <p>For information about valid IOPS values, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS">Amazon RDS Provisioned IOPS storage</a> in the <i>Amazon RDS User Guide</i>.</p> <p>Constraints: Must be a multiple between .5 and 50 of the storage amount for the DB instance.</p> <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>', 'RestoreDBClusterToPointInTimeMessage$Port' => '<p>The port number on which the new DB cluster accepts connections.</p> <p>Constraints: A value from <code>1150-65535</code>.</p> <p>Default: The default port for the engine.</p> <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>', 'RestoreDBClusterToPointInTimeMessage$Iops' => '<p>The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for each DB instance in the Multi-AZ DB cluster.</p> <p>For information about valid IOPS values, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS">Amazon RDS Provisioned IOPS storage</a> in the <i>Amazon RDS User Guide</i>.</p> <p>Constraints: Must be a multiple between .5 and 50 of the storage amount for the DB instance.</p> <p>Valid for: Multi-AZ DB clusters only</p>', 'RestoreDBInstanceFromDBSnapshotMessage$Port' => '<p>The port number on which the database accepts connections.</p> <p>Default: The same port as the original DB instance</p> <p>Constraints: Value must be <code>1150-65535</code> </p>', 'RestoreDBInstanceFromDBSnapshotMessage$Iops' => '<p>Specifies the amount of provisioned IOPS for the DB instance, expressed in I/O operations per second. If this parameter isn\'t specified, the IOPS value is taken from the backup. If this parameter is set to 0, the new instance is converted to a non-PIOPS instance. The conversion takes additional time, though your DB instance is available for connections before the conversion starts.</p> <p>The provisioned IOPS value must follow the requirements for your database engine. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS">Amazon RDS Provisioned IOPS storage</a> in the <i>Amazon RDS User Guide.</i> </p> <p>Constraints: Must be an integer greater than 1000.</p>', 'RestoreDBInstanceFromDBSnapshotMessage$StorageThroughput' => '<p>Specifies the storage throughput value for the DB instance.</p> <p>This setting doesn\'t apply to RDS Custom or Amazon Aurora.</p>', 'RestoreDBInstanceFromDBSnapshotMessage$AllocatedStorage' => '<p>The amount of storage (in gibibytes) to allocate initially for the DB instance. Follow the allocation rules specified in CreateDBInstance.</p> <note> <p>Be sure to allocate enough storage for your new DB instance so that the restore operation can succeed. You can also allocate additional storage for future growth.</p> </note>', 'RestoreDBInstanceFromS3Message$AllocatedStorage' => '<p>The amount of storage (in gibibytes) to allocate initially for the DB instance. Follow the allocation rules specified in <code>CreateDBInstance</code>.</p> <note> <p>Be sure to allocate enough storage for your new DB instance so that the restore operation can succeed. You can also allocate additional storage for future growth.</p> </note>', 'RestoreDBInstanceFromS3Message$BackupRetentionPeriod' => '<p>The number of days for which automated backups are retained. Setting this parameter to a positive number enables backups. For more information, see <code>CreateDBInstance</code>.</p>', 'RestoreDBInstanceFromS3Message$Port' => '<p>The port number on which the database accepts connections.</p> <p>Type: Integer</p> <p>Valid Values: <code>1150</code>-<code>65535</code> </p> <p>Default: <code>3306</code> </p>', 'RestoreDBInstanceFromS3Message$Iops' => '<p>The amount of Provisioned IOPS (input/output operations per second) to allocate initially for the DB instance. For information about valid IOPS values, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS">Amazon RDS Provisioned IOPS storage</a> in the <i>Amazon RDS User Guide.</i> </p>', 'RestoreDBInstanceFromS3Message$MonitoringInterval' => '<p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance. To disable collecting Enhanced Monitoring metrics, specify 0.</p> <p>If <code>MonitoringRoleArn</code> is specified, then you must also set <code>MonitoringInterval</code> to a value other than 0.</p> <p>Valid Values: 0, 1, 5, 10, 15, 30, 60</p> <p>Default: <code>0</code> </p>', 'RestoreDBInstanceFromS3Message$PerformanceInsightsRetentionPeriod' => '<p>The number of days to retain Performance Insights data. The default is 7 days. The following values are valid:</p> <ul> <li> <p>7</p> </li> <li> <p> <i>month</i> * 31, where <i>month</i> is a number of months from 1-23</p> </li> <li> <p>731</p> </li> </ul> <p>For example, the following values are valid:</p> <ul> <li> <p>93 (3 months * 31)</p> </li> <li> <p>341 (11 months * 31)</p> </li> <li> <p>589 (19 months * 31)</p> </li> <li> <p>731</p> </li> </ul> <p>If you specify a retention period such as 94, which isn\'t a valid value, RDS issues an error.</p>', 'RestoreDBInstanceFromS3Message$MaxAllocatedStorage' => '<p>The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB instance.</p> <p>For more information about this setting, including limitations that apply to it, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling"> Managing capacity automatically with Amazon RDS storage autoscaling</a> in the <i>Amazon RDS User Guide</i>.</p>', 'RestoreDBInstanceFromS3Message$StorageThroughput' => '<p>Specifies the storage throughput value for the DB instance.</p> <p>This setting doesn\'t apply to RDS Custom or Amazon Aurora.</p>', 'RestoreDBInstanceToPointInTimeMessage$Port' => '<p>The port number on which the database accepts connections.</p> <p>Default: The same port as the original DB instance.</p> <p>Constraints:</p> <ul> <li> <p>The value must be <code>1150-65535</code>.</p> </li> </ul>', 'RestoreDBInstanceToPointInTimeMessage$Iops' => '<p>The amount of Provisioned IOPS (input/output operations per second) to initially allocate for the DB instance.</p> <p>This setting doesn\'t apply to SQL Server.</p> <p>Constraints:</p> <ul> <li> <p>Must be an integer greater than 1000.</p> </li> </ul>', 'RestoreDBInstanceToPointInTimeMessage$MaxAllocatedStorage' => '<p>The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB instance.</p> <p>For more information about this setting, including limitations that apply to it, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling"> Managing capacity automatically with Amazon RDS storage autoscaling</a> in the <i>Amazon RDS User Guide</i>.</p> <p>This setting doesn\'t apply to RDS Custom.</p>', 'RestoreDBInstanceToPointInTimeMessage$StorageThroughput' => '<p>The storage throughput value for the DB instance.</p> <p>This setting doesn\'t apply to RDS Custom or Amazon Aurora.</p>', 'RestoreDBInstanceToPointInTimeMessage$AllocatedStorage' => '<p>The amount of storage (in gibibytes) to allocate initially for the DB instance. Follow the allocation rules specified in <code>CreateDBInstance</code>.</p> <note> <p>Be sure to allocate enough storage for your new DB instance so that the restore operation can succeed. You can also allocate additional storage for future growth.</p> </note>', 'ScalingConfiguration$MinCapacity' => '<p>The minimum capacity for an Aurora DB cluster in <code>serverless</code> DB engine mode.</p> <p>For Aurora MySQL, valid capacity values are <code>1</code>, <code>2</code>, <code>4</code>, <code>8</code>, <code>16</code>, <code>32</code>, <code>64</code>, <code>128</code>, and <code>256</code>.</p> <p>For Aurora PostgreSQL, valid capacity values are <code>2</code>, <code>4</code>, <code>8</code>, <code>16</code>, <code>32</code>, <code>64</code>, <code>192</code>, and <code>384</code>.</p> <p>The minimum capacity must be less than or equal to the maximum capacity.</p>', 'ScalingConfiguration$MaxCapacity' => '<p>The maximum capacity for an Aurora DB cluster in <code>serverless</code> DB engine mode.</p> <p>For Aurora MySQL, valid capacity values are <code>1</code>, <code>2</code>, <code>4</code>, <code>8</code>, <code>16</code>, <code>32</code>, <code>64</code>, <code>128</code>, and <code>256</code>.</p> <p>For Aurora PostgreSQL, valid capacity values are <code>2</code>, <code>4</code>, <code>8</code>, <code>16</code>, <code>32</code>, <code>64</code>, <code>192</code>, and <code>384</code>.</p> <p>The maximum capacity must be greater than or equal to the minimum capacity.</p>', 'ScalingConfiguration$SecondsUntilAutoPause' => '<p>The time, in seconds, before an Aurora DB cluster in <code>serverless</code> mode is paused.</p> <p>Specify a value between 300 and 86,400 seconds.</p>', 'ScalingConfiguration$SecondsBeforeTimeout' => '<p>The amount of time, in seconds, that Aurora Serverless v1 tries to find a scaling point to perform seamless scaling before enforcing the timeout action. The default is 300.</p> <p>Specify a value between 60 and 600 seconds.</p>', 'ScalingConfigurationInfo$MinCapacity' => '<p>The minimum capacity for an Aurora DB cluster in <code>serverless</code> DB engine mode.</p>', 'ScalingConfigurationInfo$MaxCapacity' => '<p>The maximum capacity for an Aurora DB cluster in <code>serverless</code> DB engine mode.</p>', 'ScalingConfigurationInfo$SecondsUntilAutoPause' => '<p>The remaining amount of time, in seconds, before the Aurora DB cluster in <code>serverless</code> mode is paused. A DB cluster can be paused only when it\'s idle (it has no connections).</p>', 'ScalingConfigurationInfo$SecondsBeforeTimeout' => '<p>The number of seconds before scaling times out. What happens when an attempted scaling action times out is determined by the <code>TimeoutAction</code> setting.</p>', 'StartDBInstanceAutomatedBackupsReplicationMessage$BackupRetentionPeriod' => '<p>The retention period for the replicated automated backups.</p>', ], ], 'Integration' => [ 'base' => '<p>A zero-ETL integration with Amazon Redshift.</p>', 'refs' => [ 'IntegrationList$member' => NULL, ], ], 'IntegrationAlreadyExistsFault' => [ 'base' => '<p>The integration you are trying to create already exists.</p>', 'refs' => [], ], 'IntegrationArn' => [ 'base' => NULL, 'refs' => [ 'Integration$IntegrationArn' => '<p>The ARN of the integration.</p>', ], ], 'IntegrationConflictOperationFault' => [ 'base' => '<p>A conflicting conditional operation is currently in progress against this resource. Typically occurs when there are multiple requests being made to the same resource at the same time, and these requests conflict with each other.</p>', 'refs' => [], ], 'IntegrationDescription' => [ 'base' => NULL, 'refs' => [ 'CreateIntegrationMessage$Description' => '<p>A description of the integration.</p>', 'Integration$Description' => '<p>A description of the integration.</p>', 'ModifyIntegrationMessage$Description' => '<p>A new description for the integration.</p>', ], ], 'IntegrationError' => [ 'base' => '<p>An error associated with a zero-ETL integration with Amazon Redshift.</p>', 'refs' => [ 'IntegrationErrorList$member' => NULL, ], ], 'IntegrationErrorList' => [ 'base' => NULL, 'refs' => [ 'Integration$Errors' => '<p>Any errors associated with the integration.</p>', ], ], 'IntegrationIdentifier' => [ 'base' => NULL, 'refs' => [ 'DeleteIntegrationMessage$IntegrationIdentifier' => '<p>The unique identifier of the integration.</p>', 'DescribeIntegrationsMessage$IntegrationIdentifier' => '<p>The unique identifier of the integration.</p>', 'ModifyIntegrationMessage$IntegrationIdentifier' => '<p>The unique identifier of the integration to modify.</p>', ], ], 'IntegrationList' => [ 'base' => NULL, 'refs' => [ 'DescribeIntegrationsResponse$Integrations' => '<p>A list of integrations.</p>', ], ], 'IntegrationName' => [ 'base' => NULL, 'refs' => [ 'CreateIntegrationMessage$IntegrationName' => '<p>The name of the integration.</p>', 'Integration$IntegrationName' => '<p>The name of the integration.</p>', 'ModifyIntegrationMessage$IntegrationName' => '<p>A new name for the integration.</p>', ], ], 'IntegrationNotFoundFault' => [ 'base' => '<p>The specified integration could not be found.</p>', 'refs' => [], ], 'IntegrationQuotaExceededFault' => [ 'base' => '<p>You can\'t crate any more zero-ETL integrations because the quota has been reached.</p>', 'refs' => [], ], 'IntegrationStatus' => [ 'base' => NULL, 'refs' => [ 'Integration$Status' => '<p>The current status of the integration.</p>', ], ], 'InvalidBlueGreenDeploymentStateFault' => [ 'base' => '<p>The blue/green deployment can\'t be switched over or deleted because there is an invalid configuration in the green environment.</p>', 'refs' => [], ], 'InvalidCustomDBEngineVersionStateFault' => [ 'base' => '<p>You can\'t delete the CEV.</p>', 'refs' => [], ], 'InvalidDBClusterAutomatedBackupStateFault' => [ 'base' => '<p>The automated backup is in an invalid state. For example, this automated backup is associated with an active cluster.</p>', 'refs' => [], ], 'InvalidDBClusterCapacityFault' => [ 'base' => '<p> <code>Capacity</code> isn\'t a valid Aurora Serverless DB cluster capacity. Valid capacity values are <code>2</code>, <code>4</code>, <code>8</code>, <code>16</code>, <code>32</code>, <code>64</code>, <code>128</code>, and <code>256</code>.</p>', 'refs' => [], ], 'InvalidDBClusterEndpointStateFault' => [ 'base' => '<p>The requested operation can\'t be performed on the endpoint while the endpoint is in this state.</p>', 'refs' => [], ], 'InvalidDBClusterSnapshotStateFault' => [ 'base' => '<p>The supplied value isn\'t a valid DB cluster snapshot state.</p>', 'refs' => [], ], 'InvalidDBClusterStateFault' => [ 'base' => '<p>The requested operation can\'t be performed while the cluster is in this state.</p>', 'refs' => [], ], 'InvalidDBInstanceAutomatedBackupStateFault' => [ 'base' => '<p>The automated backup is in an invalid state. For example, this automated backup is associated with an active instance.</p>', 'refs' => [], ], 'InvalidDBInstanceStateFault' => [ 'base' => '<p>The DB instance isn\'t in a valid state.</p>', 'refs' => [], ], 'InvalidDBParameterGroupStateFault' => [ 'base' => '<p>The DB parameter group is in use or is in an invalid state. If you are attempting to delete the parameter group, you can\'t delete it when the parameter group is in this state.</p>', 'refs' => [], ], 'InvalidDBProxyEndpointStateFault' => [ 'base' => '<p>You can\'t perform this operation while the DB proxy endpoint is in a particular state.</p>', 'refs' => [], ], 'InvalidDBProxyStateFault' => [ 'base' => '<p>The requested operation can\'t be performed while the proxy is in this state.</p>', 'refs' => [], ], 'InvalidDBSecurityGroupStateFault' => [ 'base' => '<p>The state of the DB security group doesn\'t allow deletion.</p>', 'refs' => [], ], 'InvalidDBShardGroupStateFault' => [ 'base' => '<p>The DB shard group must be in the available state.</p>', 'refs' => [], ], 'InvalidDBSnapshotStateFault' => [ 'base' => '<p>The state of the DB snapshot doesn\'t allow deletion.</p>', 'refs' => [], ], 'InvalidDBSubnetGroupFault' => [ 'base' => '<p>The DBSubnetGroup doesn\'t belong to the same VPC as that of an existing cross-region read replica of the same source instance.</p>', 'refs' => [], ], 'InvalidDBSubnetGroupStateFault' => [ 'base' => '<p>The DB subnet group cannot be deleted because it\'s in use.</p>', 'refs' => [], ], 'InvalidDBSubnetStateFault' => [ 'base' => '<p>The DB subnet isn\'t in the <i>available</i> state.</p>', 'refs' => [], ], 'InvalidEventSubscriptionStateFault' => [ 'base' => '<p>This error can occur if someone else is modifying a subscription. You should retry the action.</p>', 'refs' => [], ], 'InvalidExportOnlyFault' => [ 'base' => '<p>The export is invalid for exporting to an Amazon S3 bucket.</p>', 'refs' => [], ], 'InvalidExportSourceStateFault' => [ 'base' => '<p>The state of the export snapshot is invalid for exporting to an Amazon S3 bucket.</p>', 'refs' => [], ], 'InvalidExportTaskStateFault' => [ 'base' => '<p>You can\'t cancel an export task that has completed.</p>', 'refs' => [], ], 'InvalidGlobalClusterStateFault' => [ 'base' => '<p>The global cluster is in an invalid state and can\'t perform the requested operation.</p>', 'refs' => [], ], 'InvalidIntegrationStateFault' => [ 'base' => '<p>The integration is in an invalid state and can\'t perform the requested operation.</p>', 'refs' => [], ], 'InvalidMaxAcuFault' => [ 'base' => '<p>The maximum capacity of the DB shard group must be 48-7168 Aurora capacity units (ACUs).</p>', 'refs' => [], ], 'InvalidOptionGroupStateFault' => [ 'base' => '<p>The option group isn\'t in the <i>available</i> state.</p>', 'refs' => [], ], 'InvalidResourceStateFault' => [ 'base' => '<p>The operation can\'t be performed because another operation is in progress.</p>', 'refs' => [], ], 'InvalidRestoreFault' => [ 'base' => '<p>Cannot restore from VPC backup to non-VPC DB instance.</p>', 'refs' => [], ], 'InvalidS3BucketFault' => [ 'base' => '<p>The specified Amazon S3 bucket name can\'t be found or Amazon RDS isn\'t authorized to access the specified Amazon S3 bucket. Verify the <b>SourceS3BucketName</b> and <b>S3IngestionRoleArn</b> values and try again.</p>', 'refs' => [], ], 'InvalidSubnet' => [ 'base' => '<p>The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.</p>', 'refs' => [], ], 'InvalidVPCNetworkStateFault' => [ 'base' => '<p>The DB subnet group doesn\'t cover all Availability Zones after it\'s created because of users\' change.</p>', 'refs' => [], ], 'IssueDetails' => [ 'base' => '<p>The details of an issue with your DB instances, DB clusters, and DB parameter groups.</p>', 'refs' => [ 'DBRecommendation$IssueDetails' => '<p>Details of the issue that caused the recommendation.</p>', 'RecommendedAction$IssueDetails' => '<p>The details of the issue.</p>', ], ], 'KMSKeyNotAccessibleFault' => [ 'base' => '<p>An error occurred accessing an Amazon Web Services KMS key.</p>', 'refs' => [], ], 'KeyList' => [ 'base' => NULL, 'refs' => [ 'RemoveTagsFromResourceMessage$TagKeys' => '<p>The tag key (name) of the tag to be removed.</p>', ], ], 'KmsKeyIdOrArn' => [ 'base' => NULL, 'refs' => [ 'CreateCustomDBEngineVersionMessage$KMSKeyId' => '<p>The Amazon Web Services KMS key identifier for an encrypted CEV. A symmetric encryption KMS key is required for RDS Custom, but optional for Amazon RDS.</p> <p>If you have an existing symmetric encryption KMS key in your account, you can use it with RDS Custom. No further action is necessary. If you don\'t already have a symmetric encryption KMS key in your account, follow the instructions in <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html#create-symmetric-cmk"> Creating a symmetric encryption KMS key</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.</p> <p>You can choose the same symmetric encryption key when you create a CEV and a DB instance, or choose different keys.</p>', ], ], 'LimitlessDatabase' => [ 'base' => '<p>Contains details for Aurora Limitless Database.</p>', 'refs' => [ 'DBCluster$LimitlessDatabase' => '<p>The details for Aurora Limitless Database.</p>', ], ], 'LimitlessDatabaseStatus' => [ 'base' => NULL, 'refs' => [ 'LimitlessDatabase$Status' => '<p>The status of Aurora Limitless Database.</p>', ], ], 'ListTagsForResourceMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'LocalWriteForwardingStatus' => [ 'base' => NULL, 'refs' => [ 'DBCluster$LocalWriteForwardingStatus' => '<p>Indicates whether an Aurora DB cluster has in-cluster write forwarding enabled, not enabled, requested, or is in the process of enabling it.</p>', ], ], 'LogTypeList' => [ 'base' => NULL, 'refs' => [ 'CloudwatchLogsExportConfiguration$EnableLogTypes' => '<p>The list of log types to enable.</p>', 'CloudwatchLogsExportConfiguration$DisableLogTypes' => '<p>The list of log types to disable.</p>', 'CreateDBClusterMessage$EnableCloudwatchLogsExports' => '<p>The list of log types that need to be enabled for exporting to CloudWatch Logs.</p> <p>Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters</p> <p>The following values are valid for each DB engine:</p> <ul> <li> <p>Aurora MySQL - <code>audit | error | general | slowquery</code> </p> </li> <li> <p>Aurora PostgreSQL - <code>postgresql</code> </p> </li> <li> <p>RDS for MySQL - <code>error | general | slowquery</code> </p> </li> <li> <p>RDS for PostgreSQL - <code>postgresql | upgrade</code> </p> </li> </ul> <p>For more information about exporting CloudWatch Logs for Amazon RDS, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon RDS User Guide</i>.</p> <p>For more information about exporting CloudWatch Logs for Amazon Aurora, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon Aurora User Guide</i>.</p>', 'CreateDBInstanceMessage$EnableCloudwatchLogsExports' => '<p>The list of log types to enable for exporting to CloudWatch Logs. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"> Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon RDS User Guide</i>.</p> <p>This setting doesn\'t apply to the following DB instances:</p> <ul> <li> <p>Amazon Aurora (CloudWatch Logs exports are managed by the DB cluster.)</p> </li> <li> <p>RDS Custom</p> </li> </ul> <p>The following values are valid for each DB engine:</p> <ul> <li> <p>RDS for Db2 - <code>diag.log | notify.log</code> </p> </li> <li> <p>RDS for MariaDB - <code>audit | error | general | slowquery</code> </p> </li> <li> <p>RDS for Microsoft SQL Server - <code>agent | error</code> </p> </li> <li> <p>RDS for MySQL - <code>audit | error | general | slowquery</code> </p> </li> <li> <p>RDS for Oracle - <code>alert | audit | listener | trace | oemagent</code> </p> </li> <li> <p>RDS for PostgreSQL - <code>postgresql | upgrade</code> </p> </li> </ul>', 'CreateDBInstanceReadReplicaMessage$EnableCloudwatchLogsExports' => '<p>The list of logs that the new DB instance is to export to CloudWatch Logs. The values in the list depend on the DB engine being used. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs </a> in the <i>Amazon RDS User Guide</i>.</p> <p>This setting doesn\'t apply to RDS Custom DB instances.</p>', 'DBCluster$EnabledCloudwatchLogsExports' => '<p>A list of log types that this DB cluster is configured to export to CloudWatch Logs.</p> <p>Log types vary by DB engine. For information about the log types for each DB engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html">Amazon RDS Database Log Files</a> in the <i>Amazon Aurora User Guide.</i> </p>', 'DBEngineVersion$ExportableLogTypes' => '<p>The types of logs that the database engine has available for export to CloudWatch Logs.</p>', 'DBInstance$EnabledCloudwatchLogsExports' => '<p>A list of log types that this DB instance is configured to export to CloudWatch Logs.</p> <p>Log types vary by DB engine. For information about the log types for each DB engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html">Monitoring Amazon RDS log files</a> in the <i>Amazon RDS User Guide.</i> </p>', 'PendingCloudwatchLogsExports$LogTypesToEnable' => '<p>Log types that are in the process of being deactivated. After they are deactivated, these log types aren\'t exported to CloudWatch Logs.</p>', 'PendingCloudwatchLogsExports$LogTypesToDisable' => '<p>Log types that are in the process of being enabled. After they are enabled, these log types are exported to CloudWatch Logs.</p>', 'RestoreDBClusterFromS3Message$EnableCloudwatchLogsExports' => '<p>The list of logs that the restored DB cluster is to export to CloudWatch Logs. The values in the list depend on the DB engine being used.</p> <p> <b>Aurora MySQL</b> </p> <p>Possible values are <code>audit</code>, <code>error</code>, <code>general</code>, and <code>slowquery</code>.</p> <p>For more information about exporting CloudWatch Logs for Amazon Aurora, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon Aurora User Guide</i>.</p>', 'RestoreDBClusterFromSnapshotMessage$EnableCloudwatchLogsExports' => '<p>The list of logs that the restored DB cluster is to export to Amazon CloudWatch Logs. The values in the list depend on the DB engine being used.</p> <p> <b>RDS for MySQL</b> </p> <p>Possible values are <code>error</code>, <code>general</code>, and <code>slowquery</code>.</p> <p> <b>RDS for PostgreSQL</b> </p> <p>Possible values are <code>postgresql</code> and <code>upgrade</code>.</p> <p> <b>Aurora MySQL</b> </p> <p>Possible values are <code>audit</code>, <code>error</code>, <code>general</code>, and <code>slowquery</code>.</p> <p> <b>Aurora PostgreSQL</b> </p> <p>Possible value is <code>postgresql</code>.</p> <p>For more information about exporting CloudWatch Logs for Amazon RDS, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon RDS User Guide</i>.</p> <p>For more information about exporting CloudWatch Logs for Amazon Aurora, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon Aurora User Guide</i>.</p> <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>', 'RestoreDBClusterToPointInTimeMessage$EnableCloudwatchLogsExports' => '<p>The list of logs that the restored DB cluster is to export to CloudWatch Logs. The values in the list depend on the DB engine being used.</p> <p> <b>RDS for MySQL</b> </p> <p>Possible values are <code>error</code>, <code>general</code>, and <code>slowquery</code>.</p> <p> <b>RDS for PostgreSQL</b> </p> <p>Possible values are <code>postgresql</code> and <code>upgrade</code>.</p> <p> <b>Aurora MySQL</b> </p> <p>Possible values are <code>audit</code>, <code>error</code>, <code>general</code>, and <code>slowquery</code>.</p> <p> <b>Aurora PostgreSQL</b> </p> <p>Possible value is <code>postgresql</code>.</p> <p>For more information about exporting CloudWatch Logs for Amazon RDS, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon RDS User Guide</i>.</p> <p>For more information about exporting CloudWatch Logs for Amazon Aurora, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon Aurora User Guide</i>.</p> <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>', 'RestoreDBInstanceFromDBSnapshotMessage$EnableCloudwatchLogsExports' => '<p>The list of logs for the restored DB instance to export to CloudWatch Logs. The values in the list depend on the DB engine. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon RDS User Guide</i>.</p> <p>This setting doesn\'t apply to RDS Custom.</p>', 'RestoreDBInstanceFromS3Message$EnableCloudwatchLogsExports' => '<p>The list of logs that the restored DB instance is to export to CloudWatch Logs. The values in the list depend on the DB engine being used. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon RDS User Guide</i>.</p>', 'RestoreDBInstanceToPointInTimeMessage$EnableCloudwatchLogsExports' => '<p>The list of logs that the restored DB instance is to export to CloudWatch Logs. The values in the list depend on the DB engine being used. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon RDS User Guide</i>.</p> <p>This setting doesn\'t apply to RDS Custom.</p>', ], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'AccountQuota$Used' => '<p>The amount currently used toward the quota maximum.</p>', 'AccountQuota$Max' => '<p>The maximum allowed value for the quota.</p>', 'DescribeDBLogFilesDetails$LastWritten' => '<p>A POSIX timestamp when the last log entry was written.</p>', 'DescribeDBLogFilesDetails$Size' => '<p>The size, in bytes, of the log file for the specified DB instance.</p>', 'DescribeDBLogFilesMessage$FileLastWritten' => '<p>Filters the available log files for files written since the specified date, in POSIX timestamp format with milliseconds.</p>', 'DescribeDBLogFilesMessage$FileSize' => '<p>Filters the available log files for files larger than the specified size.</p>', ], ], 'LongOptional' => [ 'base' => NULL, 'refs' => [ 'CreateDBClusterMessage$BacktrackWindow' => '<p>The target backtrack window, in seconds. To disable backtracking, set this value to <code>0</code>.</p> <p>Valid for Cluster Type: Aurora MySQL DB clusters only</p> <p>Default: <code>0</code> </p> <p>Constraints:</p> <ul> <li> <p>If specified, this value must be set to a number from 0 to 259,200 (72 hours).</p> </li> </ul>', 'DBCluster$BacktrackWindow' => '<p>The target backtrack window, in seconds. If this value is set to <code>0</code>, backtracking is disabled for the DB cluster. Otherwise, backtracking is enabled.</p>', 'DBCluster$BacktrackConsumedChangeRecords' => '<p>The number of change records stored for Backtrack.</p>', 'ModifyDBClusterMessage$BacktrackWindow' => '<p>The target backtrack window, in seconds. To disable backtracking, set this value to <code>0</code>.</p> <p>Valid for Cluster Type: Aurora MySQL DB clusters only</p> <p>Default: <code>0</code> </p> <p>Constraints:</p> <ul> <li> <p>If specified, this value must be set to a number from 0 to 259,200 (72 hours).</p> </li> </ul>', 'RestoreDBClusterFromS3Message$BacktrackWindow' => '<p>The target backtrack window, in seconds. To disable backtracking, set this value to 0.</p> <note> <p>Currently, Backtrack is only supported for Aurora MySQL DB clusters.</p> </note> <p>Default: 0</p> <p>Constraints:</p> <ul> <li> <p>If specified, this value must be set to a number from 0 to 259,200 (72 hours).</p> </li> </ul>', 'RestoreDBClusterFromSnapshotMessage$BacktrackWindow' => '<p>The target backtrack window, in seconds. To disable backtracking, set this value to 0.</p> <note> <p>Currently, Backtrack is only supported for Aurora MySQL DB clusters.</p> </note> <p>Default: 0</p> <p>Constraints:</p> <ul> <li> <p>If specified, this value must be set to a number from 0 to 259,200 (72 hours).</p> </li> </ul> <p>Valid for: Aurora DB clusters only</p>', 'RestoreDBClusterToPointInTimeMessage$BacktrackWindow' => '<p>The target backtrack window, in seconds. To disable backtracking, set this value to 0.</p> <p>Default: 0</p> <p>Constraints:</p> <ul> <li> <p>If specified, this value must be set to a number from 0 to 259,200 (72 hours).</p> </li> </ul> <p>Valid for: Aurora MySQL DB clusters only</p>', ], ], 'Marker' => [ 'base' => NULL, 'refs' => [ 'DescribeIntegrationsMessage$Marker' => '<p>An optional pagination token provided by a previous <code>DescribeIntegrations</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeIntegrationsResponse$Marker' => '<p>A pagination token that can be used in a later <code>DescribeIntegrations</code> request.</p>', ], ], 'MasterUserSecret' => [ 'base' => '<p>Contains the secret managed by RDS in Amazon Web Services Secrets Manager for the master user password.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html">Password management with Amazon Web Services Secrets Manager</a> in the <i>Amazon RDS User Guide</i> and <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html">Password management with Amazon Web Services Secrets Manager</a> in the <i>Amazon Aurora User Guide.</i> </p>', 'refs' => [ 'DBCluster$MasterUserSecret' => '<p>The secret managed by RDS in Amazon Web Services Secrets Manager for the master user password.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html">Password management with Amazon Web Services Secrets Manager</a> in the <i>Amazon RDS User Guide</i> and <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html">Password management with Amazon Web Services Secrets Manager</a> in the <i>Amazon Aurora User Guide.</i> </p>', 'DBInstance$MasterUserSecret' => '<p>The secret managed by RDS in Amazon Web Services Secrets Manager for the master user password.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html">Password management with Amazon Web Services Secrets Manager</a> in the <i>Amazon RDS User Guide.</i> </p>', ], ], 'MaxDBShardGroupLimitReached' => [ 'base' => '<p>The maximum number of DB shard groups for your Amazon Web Services account in the specified Amazon Web Services Region has been reached.</p>', 'refs' => [], ], 'MaxRecords' => [ 'base' => NULL, 'refs' => [ 'DescribeBlueGreenDeploymentsRequest$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so you can retrieve the remaining results.</p> <p>Default: 100</p> <p>Constraints:</p> <ul> <li> <p>Must be a minimum of 20.</p> </li> <li> <p>Can\'t exceed 100.</p> </li> </ul>', 'DescribeDBProxiesRequest$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeDBProxyEndpointsRequest$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeDBProxyTargetGroupsRequest$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeDBProxyTargetsRequest$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeDBShardGroupsMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so you can retrieve the remaining results.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100</p>', 'DescribeExportTasksMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified value, a pagination token called a marker is included in the response. You can use the marker in a later <code>DescribeExportTasks</code> request to retrieve the remaining results.</p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', ], ], 'Metric' => [ 'base' => '<p>The representation of a metric.</p>', 'refs' => [ 'MetricList$member' => NULL, ], ], 'MetricList' => [ 'base' => NULL, 'refs' => [ 'PerformanceIssueDetails$Metrics' => '<p>The metrics that are relevant to the performance issue.</p>', ], ], 'MetricQuery' => [ 'base' => '<p>The query to retrieve metric data points.</p>', 'refs' => [ 'Metric$MetricQuery' => '<p>The query to retrieve metric data points.</p>', ], ], 'MetricReference' => [ 'base' => '<p>The reference (threshold) for a metric.</p>', 'refs' => [ 'MetricReferenceList$member' => NULL, ], ], 'MetricReferenceList' => [ 'base' => NULL, 'refs' => [ 'Metric$References' => '<p>A list of metric references (thresholds).</p>', ], ], 'MinimumEngineVersionPerAllowedValue' => [ 'base' => '<p>The minimum DB engine version required for each corresponding allowed value for an option setting.</p>', 'refs' => [ 'MinimumEngineVersionPerAllowedValueList$member' => NULL, ], ], 'MinimumEngineVersionPerAllowedValueList' => [ 'base' => NULL, 'refs' => [ 'OptionGroupOptionSetting$MinimumEngineVersionPerAllowedValue' => '<p>The minimum DB engine version required for the corresponding allowed value for this option setting.</p>', ], ], 'ModifyActivityStreamRequest' => [ 'base' => NULL, 'refs' => [], ], 'ModifyActivityStreamResponse' => [ 'base' => NULL, 'refs' => [], ], 'ModifyCertificatesMessage' => [ 'base' => NULL, 'refs' => [], ], 'ModifyCertificatesResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyCurrentDBClusterCapacityMessage' => [ 'base' => NULL, 'refs' => [], ], 'ModifyCustomDBEngineVersionMessage' => [ 'base' => NULL, 'refs' => [], ], 'ModifyDBClusterEndpointMessage' => [ 'base' => NULL, 'refs' => [], ], 'ModifyDBClusterMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'ModifyDBClusterParameterGroupMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'ModifyDBClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyDBClusterSnapshotAttributeMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'ModifyDBClusterSnapshotAttributeResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyDBInstanceMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'ModifyDBInstanceResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyDBParameterGroupMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'ModifyDBProxyEndpointRequest' => [ 'base' => NULL, 'refs' => [], ], 'ModifyDBProxyEndpointResponse' => [ 'base' => NULL, 'refs' => [], ], 'ModifyDBProxyRequest' => [ 'base' => NULL, 'refs' => [], ], 'ModifyDBProxyResponse' => [ 'base' => NULL, 'refs' => [], ], 'ModifyDBProxyTargetGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'ModifyDBProxyTargetGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'ModifyDBRecommendationMessage' => [ 'base' => NULL, 'refs' => [], ], 'ModifyDBShardGroupMessage' => [ 'base' => NULL, 'refs' => [], ], 'ModifyDBSnapshotAttributeMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'ModifyDBSnapshotAttributeResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyDBSnapshotMessage' => [ 'base' => NULL, 'refs' => [], ], 'ModifyDBSnapshotResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyDBSubnetGroupMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'ModifyDBSubnetGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyEventSubscriptionMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'ModifyEventSubscriptionResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyGlobalClusterMessage' => [ 'base' => NULL, 'refs' => [], ], 'ModifyGlobalClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyIntegrationMessage' => [ 'base' => NULL, 'refs' => [], ], 'ModifyOptionGroupMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'ModifyOptionGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyTenantDatabaseMessage' => [ 'base' => NULL, 'refs' => [], ], 'ModifyTenantDatabaseResult' => [ 'base' => NULL, 'refs' => [], ], 'NetworkTypeNotSupported' => [ 'base' => '<p>The network type is invalid for the DB instance. Valid nework type values are <code>IPV4</code> and <code>DUAL</code>.</p>', 'refs' => [], ], 'Option' => [ 'base' => '<p>The details of an option.</p>', 'refs' => [ 'OptionsList$member' => NULL, ], ], 'OptionConfiguration' => [ 'base' => '<p>A list of all available options</p>', 'refs' => [ 'OptionConfigurationList$member' => NULL, ], ], 'OptionConfigurationList' => [ 'base' => NULL, 'refs' => [ 'ModifyOptionGroupMessage$OptionsToInclude' => '<p>Options in this list are added to the option group or, if already present, the specified configuration is used to update the existing configuration.</p>', ], ], 'OptionGroup' => [ 'base' => '<p/>', 'refs' => [ 'CopyOptionGroupResult$OptionGroup' => NULL, 'CreateOptionGroupResult$OptionGroup' => NULL, 'ModifyOptionGroupResult$OptionGroup' => NULL, 'OptionGroupsList$member' => NULL, ], ], 'OptionGroupAlreadyExistsFault' => [ 'base' => '<p>The option group you are trying to create already exists.</p>', 'refs' => [], ], 'OptionGroupMembership' => [ 'base' => '<p>Provides information on the option groups the DB instance is a member of.</p>', 'refs' => [ 'OptionGroupMembershipList$member' => NULL, ], ], 'OptionGroupMembershipList' => [ 'base' => NULL, 'refs' => [ 'DBInstance$OptionGroupMemberships' => '<p>The list of option group memberships for this DB instance.</p>', ], ], 'OptionGroupNotFoundFault' => [ 'base' => '<p>The specified option group could not be found.</p>', 'refs' => [], ], 'OptionGroupOption' => [ 'base' => '<p>Available option.</p>', 'refs' => [ 'OptionGroupOptionsList$member' => NULL, ], ], 'OptionGroupOptionSetting' => [ 'base' => '<p>Option group option settings are used to display settings available for each option with their default values and other information. These values are used with the DescribeOptionGroupOptions action.</p>', 'refs' => [ 'OptionGroupOptionSettingsList$member' => NULL, ], ], 'OptionGroupOptionSettingsList' => [ 'base' => NULL, 'refs' => [ 'OptionGroupOption$OptionGroupOptionSettings' => '<p>The option settings that are available (and the default value) for each option in an option group.</p>', ], ], 'OptionGroupOptionVersionsList' => [ 'base' => NULL, 'refs' => [ 'OptionGroupOption$OptionGroupOptionVersions' => '<p>The versions that are available for the option.</p>', ], ], 'OptionGroupOptionsList' => [ 'base' => '<p>List of available option group options.</p>', 'refs' => [ 'OptionGroupOptionsMessage$OptionGroupOptions' => NULL, ], ], 'OptionGroupOptionsMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'OptionGroupQuotaExceededFault' => [ 'base' => '<p>The quota of 20 option groups was exceeded for this Amazon Web Services account.</p>', 'refs' => [], ], 'OptionGroups' => [ 'base' => '<p>List of option groups.</p>', 'refs' => [], ], 'OptionGroupsList' => [ 'base' => NULL, 'refs' => [ 'OptionGroups$OptionGroupsList' => '<p>List of option groups.</p>', ], ], 'OptionNamesList' => [ 'base' => NULL, 'refs' => [ 'ModifyOptionGroupMessage$OptionsToRemove' => '<p>Options in this list are removed from the option group.</p>', ], ], 'OptionSetting' => [ 'base' => '<p>Option settings are the actual settings being applied or configured for that option. It is used when you modify an option group or describe option groups. For example, the NATIVE_NETWORK_ENCRYPTION option has a setting called SQLNET.ENCRYPTION_SERVER that can have several different values.</p>', 'refs' => [ 'OptionSettingConfigurationList$member' => NULL, 'OptionSettingsList$member' => NULL, ], ], 'OptionSettingConfigurationList' => [ 'base' => NULL, 'refs' => [ 'Option$OptionSettings' => '<p>The option settings for this option.</p>', ], ], 'OptionSettingsList' => [ 'base' => NULL, 'refs' => [ 'OptionConfiguration$OptionSettings' => '<p>The option settings to include in an option group.</p>', ], ], 'OptionVersion' => [ 'base' => '<p>The version for an option. Option group option versions are returned by the <code>DescribeOptionGroupOptions</code> action.</p>', 'refs' => [ 'OptionGroupOptionVersionsList$member' => NULL, ], ], 'OptionsConflictsWith' => [ 'base' => NULL, 'refs' => [ 'OptionGroupOption$OptionsConflictsWith' => '<p>The options that conflict with this option.</p>', ], ], 'OptionsDependedOn' => [ 'base' => NULL, 'refs' => [ 'OptionGroupOption$OptionsDependedOn' => '<p>The options that are prerequisites for this option.</p>', ], ], 'OptionsList' => [ 'base' => NULL, 'refs' => [ 'OptionGroup$Options' => '<p>Indicates what options are available in the option group.</p>', ], ], 'OrderableDBInstanceOption' => [ 'base' => '<p>Contains a list of available options for a DB instance.</p> <p>This data type is used as a response element in the <code>DescribeOrderableDBInstanceOptions</code> action.</p>', 'refs' => [ 'OrderableDBInstanceOptionsList$member' => NULL, ], ], 'OrderableDBInstanceOptionsList' => [ 'base' => NULL, 'refs' => [ 'OrderableDBInstanceOptionsMessage$OrderableDBInstanceOptions' => '<p>An <code>OrderableDBInstanceOption</code> structure containing information about orderable options for the DB instance.</p>', ], ], 'OrderableDBInstanceOptionsMessage' => [ 'base' => '<p>Contains the result of a successful invocation of the <code>DescribeOrderableDBInstanceOptions</code> action.</p>', 'refs' => [], ], 'Outpost' => [ 'base' => '<p>A data type that represents an Outpost.</p> <p>For more information about RDS on Outposts, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Amazon RDS on Amazon Web Services Outposts</a> in the <i>Amazon RDS User Guide.</i> </p>', 'refs' => [ 'Subnet$SubnetOutpost' => '<p>If the subnet is associated with an Outpost, this value specifies the Outpost.</p> <p>For more information about RDS on Outposts, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Amazon RDS on Amazon Web Services Outposts</a> in the <i>Amazon RDS User Guide.</i> </p>', ], ], 'Parameter' => [ 'base' => '<p>This data type is used as a request parameter in the <code>ModifyDBParameterGroup</code> and <code>ResetDBParameterGroup</code> actions.</p> <p>This data type is used as a response element in the <code>DescribeEngineDefaultParameters</code> and <code>DescribeDBParameters</code> actions.</p>', 'refs' => [ 'ParametersList$member' => NULL, ], ], 'ParametersList' => [ 'base' => NULL, 'refs' => [ 'DBClusterParameterGroupDetails$Parameters' => '<p>Provides a list of parameters for the DB cluster parameter group.</p>', 'DBParameterGroupDetails$Parameters' => '<p>A list of <code>Parameter</code> values.</p>', 'EngineDefaults$Parameters' => '<p>Contains a list of engine default parameters.</p>', 'ModifyDBClusterParameterGroupMessage$Parameters' => '<p>A list of parameters in the DB cluster parameter group to modify.</p> <p>Valid Values (for the application method): <code>immediate | pending-reboot</code> </p> <note> <p>You can use the <code>immediate</code> value with dynamic parameters only. You can use the <code>pending-reboot</code> value for both dynamic and static parameters.</p> <p>When the application method is <code>immediate</code>, changes to dynamic parameters are applied immediately to the DB clusters associated with the parameter group. When the application method is <code>pending-reboot</code>, changes to dynamic and static parameters are applied after a reboot without failover to the DB clusters associated with the parameter group.</p> </note>', 'ModifyDBParameterGroupMessage$Parameters' => '<p>An array of parameter names, values, and the application methods for the parameter update. At least one parameter name, value, and application method must be supplied; later arguments are optional. A maximum of 20 parameters can be modified in a single request.</p> <p>Valid Values (for the application method): <code>immediate | pending-reboot</code> </p> <p>You can use the <code>immediate</code> value with dynamic parameters only. You can use the <code>pending-reboot</code> value for both dynamic and static parameters.</p> <p>When the application method is <code>immediate</code>, changes to dynamic parameters are applied immediately to the DB instances associated with the parameter group.</p> <p>When the application method is <code>pending-reboot</code>, changes to dynamic and static parameters are applied after a reboot without failover to the DB instances associated with the parameter group.</p> <note> <p>You can\'t use <code>pending-reboot</code> with dynamic parameters on RDS for SQL Server DB instances. Use <code>immediate</code>.</p> </note> <p>For more information on modifying DB parameters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithParamGroups.html">Working with DB parameter groups</a> in the <i>Amazon RDS User Guide</i>.</p>', 'ResetDBClusterParameterGroupMessage$Parameters' => '<p>A list of parameter names in the DB cluster parameter group to reset to the default values. You can\'t use this parameter if the <code>ResetAllParameters</code> parameter is enabled.</p>', 'ResetDBParameterGroupMessage$Parameters' => '<p>To reset the entire DB parameter group, specify the <code>DBParameterGroup</code> name and <code>ResetAllParameters</code> parameters. To reset specific parameters, provide a list of the following: <code>ParameterName</code> and <code>ApplyMethod</code>. A maximum of 20 parameters can be modified in a single request.</p> <p> <b>MySQL</b> </p> <p>Valid Values (for Apply method): <code>immediate</code> | <code>pending-reboot</code> </p> <p>You can use the immediate value with dynamic parameters only. You can use the <code>pending-reboot</code> value for both dynamic and static parameters, and changes are applied when DB instance reboots.</p> <p> <b>MariaDB</b> </p> <p>Valid Values (for Apply method): <code>immediate</code> | <code>pending-reboot</code> </p> <p>You can use the immediate value with dynamic parameters only. You can use the <code>pending-reboot</code> value for both dynamic and static parameters, and changes are applied when DB instance reboots.</p> <p> <b>Oracle</b> </p> <p>Valid Values (for Apply method): <code>pending-reboot</code> </p>', ], ], 'PendingCloudwatchLogsExports' => [ 'base' => '<p>A list of the log types whose configuration is still pending. In other words, these log types are in the process of being activated or deactivated.</p>', 'refs' => [ 'ClusterPendingModifiedValues$PendingCloudwatchLogsExports' => NULL, 'PendingModifiedValues$PendingCloudwatchLogsExports' => NULL, ], ], 'PendingMaintenanceAction' => [ 'base' => '<p>Provides information about a pending maintenance action for a resource.</p>', 'refs' => [ 'PendingMaintenanceActionDetails$member' => NULL, ], ], 'PendingMaintenanceActionDetails' => [ 'base' => NULL, 'refs' => [ 'ResourcePendingMaintenanceActions$PendingMaintenanceActionDetails' => '<p>A list that provides details about the pending maintenance actions for the resource.</p>', ], ], 'PendingMaintenanceActions' => [ 'base' => NULL, 'refs' => [ 'PendingMaintenanceActionsMessage$PendingMaintenanceActions' => '<p>A list of the pending maintenance actions for the resource.</p>', ], ], 'PendingMaintenanceActionsMessage' => [ 'base' => '<p>Data returned from the <b>DescribePendingMaintenanceActions</b> action.</p>', 'refs' => [], ], 'PendingModifiedValues' => [ 'base' => '<p>This data type is used as a response element in the <code>ModifyDBInstance</code> operation and contains changes that will be applied during the next maintenance window.</p>', 'refs' => [ 'DBInstance$PendingModifiedValues' => '<p>Information about pending changes to the DB instance. This information is returned only when there are pending changes. Specific changes are identified by subelements.</p>', ], ], 'PerformanceInsightsMetricDimensionGroup' => [ 'base' => '<p>A logical grouping of Performance Insights metrics for a related subject area. For example, the <code>db.sql</code> dimension group consists of the following dimensions: </p> <ul> <li> <p> <code>db.sql.id</code> - The hash of a running SQL statement, generated by Performance Insights.</p> </li> <li> <p> <code>db.sql.db_id</code> - Either the SQL ID generated by the database engine, or a value generated by Performance Insights that begins with <code>pi-</code>.</p> </li> <li> <p> <code>db.sql.statement</code> - The full text of the SQL statement that is running, for example, <code>SELECT * FROM employees</code>.</p> </li> <li> <p> <code>db.sql_tokenized.id</code> - The hash of the SQL digest generated by Performance Insights.</p> </li> </ul> <note> <p>Each response element returns a maximum of 500 bytes. For larger elements, such as SQL statements, only the first 500 bytes are returned.</p> </note>', 'refs' => [ 'PerformanceInsightsMetricQuery$GroupBy' => '<p>A specification for how to aggregate the data points from a query result. You must specify a valid dimension group. Performance Insights will return all of the dimensions within that group, unless you provide the names of specific dimensions within that group. You can also request that Performance Insights return a limited number of values for a dimension.</p>', ], ], 'PerformanceInsightsMetricQuery' => [ 'base' => '<p>A single Performance Insights metric query to process. You must provide the metric to the query. If other parameters aren\'t specified, Performance Insights returns all data points for the specified metric. Optionally, you can request the data points to be aggregated by dimension group (<code>GroupBy</code>) and return only those data points that match your criteria (<code>Filter</code>).</p> <p>Constraints:</p> <ul> <li> <p>Must be a valid Performance Insights query.</p> </li> </ul>', 'refs' => [ 'MetricQuery$PerformanceInsightsMetricQuery' => '<p>The Performance Insights query that you can use to retrieve Performance Insights metric data points.</p>', ], ], 'PerformanceIssueDetails' => [ 'base' => '<p>Details of the performance issue.</p>', 'refs' => [ 'IssueDetails$PerformanceIssueDetails' => '<p>A detailed description of the issue when the recommendation category is <code>performance</code>.</p>', ], ], 'PointInTimeRestoreNotEnabledFault' => [ 'base' => '<p> <code>SourceDBInstanceIdentifier</code> refers to a DB instance with <code>BackupRetentionPeriod</code> equal to 0.</p>', 'refs' => [], ], 'ProcessorFeature' => [ 'base' => '<p>Contains the processor features of a DB instance class.</p> <p>To specify the number of CPU cores, use the <code>coreCount</code> feature name for the <code>Name</code> parameter. To specify the number of threads per core, use the <code>threadsPerCore</code> feature name for the <code>Name</code> parameter.</p> <p>You can set the processor features of the DB instance class for a DB instance when you call one of the following actions:</p> <ul> <li> <p> <code>CreateDBInstance</code> </p> </li> <li> <p> <code>ModifyDBInstance</code> </p> </li> <li> <p> <code>RestoreDBInstanceFromDBSnapshot</code> </p> </li> <li> <p> <code>RestoreDBInstanceFromS3</code> </p> </li> <li> <p> <code>RestoreDBInstanceToPointInTime</code> </p> </li> </ul> <p>You can view the valid processor values for a particular instance class by calling the <code>DescribeOrderableDBInstanceOptions</code> action and specifying the instance class for the <code>DBInstanceClass</code> parameter.</p> <p>In addition, you can use the following actions for DB instance class processor information:</p> <ul> <li> <p> <code>DescribeDBInstances</code> </p> </li> <li> <p> <code>DescribeDBSnapshots</code> </p> </li> <li> <p> <code>DescribeValidDBInstanceModifications</code> </p> </li> </ul> <p>If you call <code>DescribeDBInstances</code>, <code>ProcessorFeature</code> returns non-null values only if the following conditions are met:</p> <ul> <li> <p>You are accessing an Oracle DB instance.</p> </li> <li> <p>Your Oracle DB instance class supports configuring the number of CPU cores and threads per core.</p> </li> <li> <p>The current number CPU cores and threads is set to a non-default value.</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html#USER_ConfigureProcessor"> Configuring the processor for a DB instance class in RDS for Oracle</a> in the <i>Amazon RDS User Guide. </i> </p>', 'refs' => [ 'ProcessorFeatureList$member' => NULL, ], ], 'ProcessorFeatureList' => [ 'base' => NULL, 'refs' => [ 'CreateDBInstanceMessage$ProcessorFeatures' => '<p>The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.</p> <p>This setting doesn\'t apply to Amazon Aurora or RDS Custom DB instances.</p>', 'CreateDBInstanceReadReplicaMessage$ProcessorFeatures' => '<p>The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.</p> <p>This setting doesn\'t apply to RDS Custom DB instances.</p>', 'DBInstance$ProcessorFeatures' => '<p>The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.</p>', 'DBSnapshot$ProcessorFeatures' => '<p>The number of CPU cores and the number of threads per core for the DB instance class of the DB instance when the DB snapshot was created.</p>', 'ModifyDBInstanceMessage$ProcessorFeatures' => '<p>The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.</p> <p>This setting doesn\'t apply to RDS Custom DB instances.</p>', 'PendingModifiedValues$ProcessorFeatures' => '<p>The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.</p>', 'RestoreDBInstanceFromDBSnapshotMessage$ProcessorFeatures' => '<p>The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.</p> <p>This setting doesn\'t apply to RDS Custom.</p>', 'RestoreDBInstanceFromS3Message$ProcessorFeatures' => '<p>The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.</p>', 'RestoreDBInstanceToPointInTimeMessage$ProcessorFeatures' => '<p>The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.</p> <p>This setting doesn\'t apply to RDS Custom.</p>', ], ], 'PromoteReadReplicaDBClusterMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'PromoteReadReplicaDBClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'PromoteReadReplicaMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'PromoteReadReplicaResult' => [ 'base' => NULL, 'refs' => [], ], 'ProvisionedIopsNotAvailableInAZFault' => [ 'base' => '<p>Provisioned IOPS not available in the specified Availability Zone.</p>', 'refs' => [], ], 'PurchaseReservedDBInstancesOfferingMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'PurchaseReservedDBInstancesOfferingResult' => [ 'base' => NULL, 'refs' => [], ], 'Range' => [ 'base' => '<p>A range of integer values.</p>', 'refs' => [ 'RangeList$member' => NULL, ], ], 'RangeList' => [ 'base' => NULL, 'refs' => [ 'ValidStorageOptions$StorageSize' => '<p>The valid range of storage in gibibytes (GiB). For example, 100 to 16,384.</p>', 'ValidStorageOptions$ProvisionedIops' => '<p>The valid range of provisioned IOPS. For example, 1000-256,000.</p>', 'ValidStorageOptions$ProvisionedStorageThroughput' => '<p>The valid range of provisioned storage throughput. For example, 500-4,000 mebibytes per second (MiBps).</p>', ], ], 'RdsCustomClusterConfiguration' => [ 'base' => '<p>Reserved for future use.</p>', 'refs' => [ 'ClusterPendingModifiedValues$RdsCustomClusterConfiguration' => '<p>Reserved for future use.</p>', 'CreateDBClusterMessage$RdsCustomClusterConfiguration' => '<p>Reserved for future use.</p>', 'DBCluster$RdsCustomClusterConfiguration' => '<p>Reserved for future use.</p>', 'RestoreDBClusterFromSnapshotMessage$RdsCustomClusterConfiguration' => '<p>Reserved for future use.</p>', 'RestoreDBClusterToPointInTimeMessage$RdsCustomClusterConfiguration' => '<p>Reserved for future use.</p>', ], ], 'ReadReplicaDBClusterIdentifierList' => [ 'base' => NULL, 'refs' => [ 'DBInstance$ReadReplicaDBClusterIdentifiers' => '<p>The identifiers of Aurora DB clusters to which the RDS DB instance is replicated as a read replica. For example, when you create an Aurora read replica of an RDS for MySQL DB instance, the Aurora MySQL DB cluster for the Aurora read replica is shown. This output doesn\'t contain information about cross-Region Aurora read replicas.</p> <note> <p>Currently, each RDS DB instance can have only one Aurora read replica.</p> </note>', ], ], 'ReadReplicaDBInstanceIdentifierList' => [ 'base' => NULL, 'refs' => [ 'DBInstance$ReadReplicaDBInstanceIdentifiers' => '<p>The identifiers of the read replicas associated with this DB instance.</p>', ], ], 'ReadReplicaIdentifierList' => [ 'base' => NULL, 'refs' => [ 'DBCluster$ReadReplicaIdentifiers' => '<p>Contains one or more identifiers of the read replicas associated with this DB cluster.</p>', ], ], 'ReadersArnList' => [ 'base' => NULL, 'refs' => [ 'GlobalClusterMember$Readers' => '<p>The Amazon Resource Name (ARN) for each read-only secondary cluster associated with the global cluster.</p>', ], ], 'RebootDBClusterMessage' => [ 'base' => NULL, 'refs' => [], ], 'RebootDBClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'RebootDBInstanceMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'RebootDBInstanceResult' => [ 'base' => NULL, 'refs' => [], ], 'RebootDBShardGroupMessage' => [ 'base' => NULL, 'refs' => [], ], 'RecommendedAction' => [ 'base' => '<p>The recommended actions to apply to resolve the issues associated with your DB instances, DB clusters, and DB parameter groups.</p>', 'refs' => [ 'RecommendedActionList$member' => NULL, ], ], 'RecommendedActionList' => [ 'base' => NULL, 'refs' => [ 'DBRecommendation$RecommendedActions' => '<p>A list of recommended actions.</p>', ], ], 'RecommendedActionParameter' => [ 'base' => '<p>A single parameter to use with the <code>RecommendedAction</code> API operation to apply the action.</p>', 'refs' => [ 'RecommendedActionParameterList$member' => NULL, ], ], 'RecommendedActionParameterList' => [ 'base' => NULL, 'refs' => [ 'RecommendedAction$Parameters' => '<p>The parameters for the API operation.</p>', ], ], 'RecommendedActionUpdate' => [ 'base' => '<p>The recommended status to update for the specified recommendation action ID.</p>', 'refs' => [ 'RecommendedActionUpdateList$member' => NULL, ], ], 'RecommendedActionUpdateList' => [ 'base' => NULL, 'refs' => [ 'ModifyDBRecommendationMessage$RecommendedActionUpdates' => '<p>The list of recommended action status to update. You can update multiple recommended actions at one time.</p>', ], ], 'RecurringCharge' => [ 'base' => '<p>This data type is used as a response element in the <code>DescribeReservedDBInstances</code> and <code>DescribeReservedDBInstancesOfferings</code> actions.</p>', 'refs' => [ 'RecurringChargeList$member' => NULL, ], ], 'RecurringChargeList' => [ 'base' => NULL, 'refs' => [ 'ReservedDBInstance$RecurringCharges' => '<p>The recurring price charged to run this reserved DB instance.</p>', 'ReservedDBInstancesOffering$RecurringCharges' => '<p>The recurring price charged to run this reserved DB instance.</p>', ], ], 'ReferenceDetails' => [ 'base' => '<p>The reference details of a metric.</p>', 'refs' => [ 'MetricReference$ReferenceDetails' => '<p>The details of a performance issue.</p>', ], ], 'RegisterDBProxyTargetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'RegisterDBProxyTargetsResponse' => [ 'base' => NULL, 'refs' => [], ], 'RemoveFromGlobalClusterMessage' => [ 'base' => NULL, 'refs' => [], ], 'RemoveFromGlobalClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'RemoveRoleFromDBClusterMessage' => [ 'base' => NULL, 'refs' => [], ], 'RemoveRoleFromDBInstanceMessage' => [ 'base' => NULL, 'refs' => [], ], 'RemoveSourceIdentifierFromSubscriptionMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'RemoveSourceIdentifierFromSubscriptionResult' => [ 'base' => NULL, 'refs' => [], ], 'RemoveTagsFromResourceMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'ReplicaMode' => [ 'base' => NULL, 'refs' => [ 'CreateDBInstanceReadReplicaMessage$ReplicaMode' => '<p>The open mode of the replica database: mounted or read-only.</p> <note> <p>This parameter is only supported for Oracle DB instances.</p> </note> <p>Mounted DB replicas are included in Oracle Database Enterprise Edition. The main use case for mounted replicas is cross-Region disaster recovery. The primary database doesn\'t use Active Data Guard to transmit information to the mounted replica. Because it doesn\'t accept user connections, a mounted replica can\'t serve a read-only workload.</p> <p>You can create a combination of mounted and read-only DB replicas for the same primary DB instance. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html">Working with Oracle Read Replicas for Amazon RDS</a> in the <i>Amazon RDS User Guide</i>.</p> <p>For RDS Custom, you must specify this parameter and set it to <code>mounted</code>. The value won\'t be set by default. After replica creation, you can manage the open mode manually.</p>', 'DBInstance$ReplicaMode' => '<p>The open mode of an Oracle read replica. The default is <code>open-read-only</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html">Working with Oracle Read Replicas for Amazon RDS</a> in the <i>Amazon RDS User Guide</i>.</p> <note> <p>This attribute is only supported in RDS for Oracle.</p> </note>', 'ModifyDBInstanceMessage$ReplicaMode' => '<p>A value that sets the open mode of a replica database to either mounted or read-only.</p> <note> <p>Currently, this parameter is only supported for Oracle DB instances.</p> </note> <p>Mounted DB replicas are included in Oracle Enterprise Edition. The main use case for mounted replicas is cross-Region disaster recovery. The primary database doesn\'t use Active Data Guard to transmit information to the mounted replica. Because it doesn\'t accept user connections, a mounted replica can\'t serve a read-only workload. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html">Working with Oracle Read Replicas for Amazon RDS</a> in the <i>Amazon RDS User Guide</i>.</p> <p>This setting doesn\'t apply to RDS Custom DB instances.</p>', 'RdsCustomClusterConfiguration$ReplicaMode' => '<p>Reserved for future use.</p>', ], ], 'ReservedDBInstance' => [ 'base' => '<p>This data type is used as a response element in the <code>DescribeReservedDBInstances</code> and <code>PurchaseReservedDBInstancesOffering</code> actions.</p>', 'refs' => [ 'PurchaseReservedDBInstancesOfferingResult$ReservedDBInstance' => NULL, 'ReservedDBInstanceList$member' => NULL, ], ], 'ReservedDBInstanceAlreadyExistsFault' => [ 'base' => '<p>User already has a reservation with the given identifier.</p>', 'refs' => [], ], 'ReservedDBInstanceList' => [ 'base' => NULL, 'refs' => [ 'ReservedDBInstanceMessage$ReservedDBInstances' => '<p>A list of reserved DB instances.</p>', ], ], 'ReservedDBInstanceMessage' => [ 'base' => '<p>Contains the result of a successful invocation of the <code>DescribeReservedDBInstances</code> action.</p>', 'refs' => [], ], 'ReservedDBInstanceNotFoundFault' => [ 'base' => '<p>The specified reserved DB Instance not found.</p>', 'refs' => [], ], 'ReservedDBInstanceQuotaExceededFault' => [ 'base' => '<p>Request would exceed the user\'s DB Instance quota.</p>', 'refs' => [], ], 'ReservedDBInstancesOffering' => [ 'base' => '<p>This data type is used as a response element in the <code>DescribeReservedDBInstancesOfferings</code> action.</p>', 'refs' => [ 'ReservedDBInstancesOfferingList$member' => NULL, ], ], 'ReservedDBInstancesOfferingList' => [ 'base' => NULL, 'refs' => [ 'ReservedDBInstancesOfferingMessage$ReservedDBInstancesOfferings' => '<p>A list of reserved DB instance offerings.</p>', ], ], 'ReservedDBInstancesOfferingMessage' => [ 'base' => '<p>Contains the result of a successful invocation of the <code>DescribeReservedDBInstancesOfferings</code> action.</p>', 'refs' => [], ], 'ReservedDBInstancesOfferingNotFoundFault' => [ 'base' => '<p>Specified offering does not exist.</p>', 'refs' => [], ], 'ResetDBClusterParameterGroupMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'ResetDBParameterGroupMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'ResourceNotFoundFault' => [ 'base' => '<p>The specified resource ID was not found.</p>', 'refs' => [], ], 'ResourcePendingMaintenanceActions' => [ 'base' => '<p>Describes the pending maintenance actions for a resource.</p>', 'refs' => [ 'ApplyPendingMaintenanceActionResult$ResourcePendingMaintenanceActions' => NULL, 'PendingMaintenanceActions$member' => NULL, ], ], 'RestoreDBClusterFromS3Message' => [ 'base' => NULL, 'refs' => [], ], 'RestoreDBClusterFromS3Result' => [ 'base' => NULL, 'refs' => [], ], 'RestoreDBClusterFromSnapshotMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'RestoreDBClusterFromSnapshotResult' => [ 'base' => NULL, 'refs' => [], ], 'RestoreDBClusterToPointInTimeMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'RestoreDBClusterToPointInTimeResult' => [ 'base' => NULL, 'refs' => [], ], 'RestoreDBInstanceFromDBSnapshotMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'RestoreDBInstanceFromDBSnapshotResult' => [ 'base' => NULL, 'refs' => [], ], 'RestoreDBInstanceFromS3Message' => [ 'base' => NULL, 'refs' => [], ], 'RestoreDBInstanceFromS3Result' => [ 'base' => NULL, 'refs' => [], ], 'RestoreDBInstanceToPointInTimeMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'RestoreDBInstanceToPointInTimeResult' => [ 'base' => NULL, 'refs' => [], ], 'RestoreWindow' => [ 'base' => '<p>Earliest and latest time an instance can be restored to:</p>', 'refs' => [ 'DBClusterAutomatedBackup$RestoreWindow' => NULL, 'DBInstanceAutomatedBackup$RestoreWindow' => '<p>The earliest and latest time a DB instance can be restored to.</p>', ], ], 'RevokeDBSecurityGroupIngressMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'RevokeDBSecurityGroupIngressResult' => [ 'base' => NULL, 'refs' => [], ], 'SNSInvalidTopicFault' => [ 'base' => '<p>SNS has responded that there is a problem with the SNS topic specified.</p>', 'refs' => [], ], 'SNSNoAuthorizationFault' => [ 'base' => '<p>You do not have permission to publish to the SNS topic ARN.</p>', 'refs' => [], ], 'SNSTopicArnNotFoundFault' => [ 'base' => '<p>The SNS topic ARN does not exist.</p>', 'refs' => [], ], 'ScalarReferenceDetails' => [ 'base' => '<p>The metric reference details when the reference is a scalar.</p>', 'refs' => [ 'ReferenceDetails$ScalarReferenceDetails' => '<p>The metric reference details when the reference is a scalar.</p>', ], ], 'ScalingConfiguration' => [ 'base' => '<p>Contains the scaling configuration of an Aurora Serverless v1 DB cluster.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html">Using Amazon Aurora Serverless v1</a> in the <i>Amazon Aurora User Guide</i>.</p>', 'refs' => [ 'CreateDBClusterMessage$ScalingConfiguration' => '<p>For DB clusters in <code>serverless</code> DB engine mode, the scaling properties of the DB cluster.</p> <p>Valid for Cluster Type: Aurora DB clusters only</p>', 'ModifyDBClusterMessage$ScalingConfiguration' => '<p>The scaling properties of the DB cluster. You can only modify scaling properties for DB clusters in <code>serverless</code> DB engine mode.</p> <p>Valid for Cluster Type: Aurora DB clusters only</p>', 'RestoreDBClusterFromSnapshotMessage$ScalingConfiguration' => '<p>For DB clusters in <code>serverless</code> DB engine mode, the scaling properties of the DB cluster.</p> <p>Valid for: Aurora DB clusters only</p>', 'RestoreDBClusterToPointInTimeMessage$ScalingConfiguration' => '<p>For DB clusters in <code>serverless</code> DB engine mode, the scaling properties of the DB cluster.</p> <p>Valid for: Aurora DB clusters only</p>', ], ], 'ScalingConfigurationInfo' => [ 'base' => '<p>The scaling configuration for an Aurora DB cluster in <code>serverless</code> DB engine mode.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html">Using Amazon Aurora Serverless v1</a> in the <i>Amazon Aurora User Guide</i>.</p>', 'refs' => [ 'DBCluster$ScalingConfigurationInfo' => NULL, ], ], 'SensitiveString' => [ 'base' => NULL, 'refs' => [ 'CreateTenantDatabaseMessage$MasterUserPassword' => '<p>The password for the master user in your tenant database.</p> <p>Constraints:</p> <ul> <li> <p>Must be 8 to 30 characters.</p> </li> <li> <p>Can include any printable ASCII character except forward slash (<code>/</code>), double quote (<code>"</code>), at symbol (<code>@</code>), ampersand (<code>&amp;</code>), or single quote (<code>\'</code>).</p> </li> </ul>', 'ModifyTenantDatabaseMessage$MasterUserPassword' => '<p>The new password for the master user of the specified tenant database in your DB instance.</p> <note> <p>Amazon RDS operations never return the password, so this action provides a way to regain access to a tenant database user if the password is lost. This includes restoring privileges that might have been accidentally revoked.</p> </note> <p>Constraints:</p> <ul> <li> <p>Can include any printable ASCII character except <code>/</code>, <code>"</code> (double quote), <code>@</code>, <code>&amp;</code> (ampersand), and <code>\'</code> (single quote).</p> </li> </ul> <p>Length constraints:</p> <ul> <li> <p>Must contain between 8 and 30 characters. </p> </li> </ul>', 'TenantDatabasePendingModifiedValues$MasterUserPassword' => '<p>The master password for the tenant database.</p>', ], ], 'ServerlessV2ScalingConfiguration' => [ 'base' => '<p>Contains the scaling configuration of an Aurora Serverless v2 DB cluster.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.html">Using Amazon Aurora Serverless v2</a> in the <i>Amazon Aurora User Guide</i>.</p>', 'refs' => [ 'CreateDBClusterMessage$ServerlessV2ScalingConfiguration' => NULL, 'ModifyDBClusterMessage$ServerlessV2ScalingConfiguration' => NULL, 'RestoreDBClusterFromS3Message$ServerlessV2ScalingConfiguration' => NULL, 'RestoreDBClusterFromSnapshotMessage$ServerlessV2ScalingConfiguration' => NULL, 'RestoreDBClusterToPointInTimeMessage$ServerlessV2ScalingConfiguration' => NULL, ], ], 'ServerlessV2ScalingConfigurationInfo' => [ 'base' => '<p>The scaling configuration for an Aurora Serverless v2 DB cluster.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.html">Using Amazon Aurora Serverless v2</a> in the <i>Amazon Aurora User Guide</i>.</p>', 'refs' => [ 'DBCluster$ServerlessV2ScalingConfiguration' => NULL, ], ], 'SharedSnapshotQuotaExceededFault' => [ 'base' => '<p>You have exceeded the maximum number of accounts that you can share a manual DB snapshot with.</p>', 'refs' => [], ], 'SnapshotQuotaExceededFault' => [ 'base' => '<p>The request would result in the user exceeding the allowed number of DB snapshots.</p>', 'refs' => [], ], 'SourceArn' => [ 'base' => NULL, 'refs' => [ 'CreateIntegrationMessage$SourceArn' => '<p>The Amazon Resource Name (ARN) of the database to use as the source for replication.</p>', 'Integration$SourceArn' => '<p>The Amazon Resource Name (ARN) of the database used as the source for replication.</p>', ], ], 'SourceClusterNotSupportedFault' => [ 'base' => '<p>The source DB cluster isn\'t supported for a blue/green deployment.</p>', 'refs' => [], ], 'SourceDatabaseNotSupportedFault' => [ 'base' => '<p>The source DB instance isn\'t supported for a blue/green deployment.</p>', 'refs' => [], ], 'SourceIdsList' => [ 'base' => NULL, 'refs' => [ 'CreateEventSubscriptionMessage$SourceIds' => '<p>The list of identifiers of the event sources for which events are returned. If not specified, then all sources are included in the response. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens. It can\'t end with a hyphen or contain two consecutive hyphens.</p> <p>Constraints:</p> <ul> <li> <p>If <code>SourceIds</code> are supplied, <code>SourceType</code> must also be provided.</p> </li> <li> <p>If the source type is a DB instance, a <code>DBInstanceIdentifier</code> value must be supplied.</p> </li> <li> <p>If the source type is a DB cluster, a <code>DBClusterIdentifier</code> value must be supplied.</p> </li> <li> <p>If the source type is a DB parameter group, a <code>DBParameterGroupName</code> value must be supplied.</p> </li> <li> <p>If the source type is a DB security group, a <code>DBSecurityGroupName</code> value must be supplied.</p> </li> <li> <p>If the source type is a DB snapshot, a <code>DBSnapshotIdentifier</code> value must be supplied.</p> </li> <li> <p>If the source type is a DB cluster snapshot, a <code>DBClusterSnapshotIdentifier</code> value must be supplied.</p> </li> <li> <p>If the source type is an RDS Proxy, a <code>DBProxyName</code> value must be supplied.</p> </li> </ul>', 'EventSubscription$SourceIdsList' => '<p>A list of source IDs for the RDS event notification subscription.</p>', ], ], 'SourceNotFoundFault' => [ 'base' => '<p>The requested source could not be found.</p>', 'refs' => [], ], 'SourceRegion' => [ 'base' => '<p>Contains an Amazon Web Services Region name as the result of a successful call to the <code>DescribeSourceRegions</code> action.</p>', 'refs' => [ 'SourceRegionList$member' => NULL, ], ], 'SourceRegionList' => [ 'base' => NULL, 'refs' => [ 'SourceRegionMessage$SourceRegions' => '<p>A list of <code>SourceRegion</code> instances that contains each source Amazon Web Services Region that the current Amazon Web Services Region can get a read replica or a DB snapshot from.</p>', ], ], 'SourceRegionMessage' => [ 'base' => '<p>Contains the result of a successful invocation of the <code>DescribeSourceRegions</code> action.</p>', 'refs' => [], ], 'SourceType' => [ 'base' => NULL, 'refs' => [ 'DescribeEventsMessage$SourceType' => '<p>The event source to retrieve events for. If no value is specified, all events are returned.</p>', 'Event$SourceType' => '<p>Specifies the source type for this event.</p>', ], ], 'StartActivityStreamRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartActivityStreamResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartDBClusterMessage' => [ 'base' => NULL, 'refs' => [], ], 'StartDBClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'StartDBInstanceAutomatedBackupsReplicationMessage' => [ 'base' => NULL, 'refs' => [], ], 'StartDBInstanceAutomatedBackupsReplicationResult' => [ 'base' => NULL, 'refs' => [], ], 'StartDBInstanceMessage' => [ 'base' => NULL, 'refs' => [], ], 'StartDBInstanceResult' => [ 'base' => NULL, 'refs' => [], ], 'StartExportTaskMessage' => [ 'base' => NULL, 'refs' => [], ], 'StopActivityStreamRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopActivityStreamResponse' => [ 'base' => NULL, 'refs' => [], ], 'StopDBClusterMessage' => [ 'base' => NULL, 'refs' => [], ], 'StopDBClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'StopDBInstanceAutomatedBackupsReplicationMessage' => [ 'base' => NULL, 'refs' => [], ], 'StopDBInstanceAutomatedBackupsReplicationResult' => [ 'base' => NULL, 'refs' => [], ], 'StopDBInstanceMessage' => [ 'base' => NULL, 'refs' => [], ], 'StopDBInstanceResult' => [ 'base' => NULL, 'refs' => [], ], 'StorageQuotaExceededFault' => [ 'base' => '<p>The request would result in the user exceeding the allowed amount of storage available across all DB instances.</p>', 'refs' => [], ], 'StorageTypeNotAvailableFault' => [ 'base' => '<p>The <code>aurora-iopt1</code> storage type isn\'t available, because you modified the DB cluster to use this storage type less than one month ago.</p>', 'refs' => [], ], 'StorageTypeNotSupportedFault' => [ 'base' => '<p>The specified <code>StorageType</code> can\'t be associated with the DB instance.</p>', 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccountQuota$AccountQuotaName' => '<p>The name of the Amazon RDS quota for this Amazon Web Services account.</p>', 'ActivityStreamModeList$member' => NULL, 'AddRoleToDBClusterMessage$DBClusterIdentifier' => '<p>The name of the DB cluster to associate the IAM role with.</p>', 'AddRoleToDBClusterMessage$RoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role to associate with the Aurora DB cluster, for example <code>arn:aws:iam::123456789012:role/AuroraAccessRole</code>.</p>', 'AddRoleToDBClusterMessage$FeatureName' => '<p>The name of the feature for the DB cluster that the IAM role is to be associated with. For information about supported feature names, see <a>DBEngineVersion</a>.</p>', 'AddRoleToDBInstanceMessage$DBInstanceIdentifier' => '<p>The name of the DB instance to associate the IAM role with.</p>', 'AddRoleToDBInstanceMessage$RoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role to associate with the DB instance, for example <code>arn:aws:iam::123456789012:role/AccessRole</code>.</p>', 'AddRoleToDBInstanceMessage$FeatureName' => '<p>The name of the feature for the DB instance that the IAM role is to be associated with. For information about supported feature names, see <a>DBEngineVersion</a>.</p>', 'AddSourceIdentifierToSubscriptionMessage$SubscriptionName' => '<p>The name of the RDS event notification subscription you want to add a source identifier to.</p>', 'AddSourceIdentifierToSubscriptionMessage$SourceIdentifier' => '<p>The identifier of the event source to be added.</p> <p>Constraints:</p> <ul> <li> <p>If the source type is a DB instance, a <code>DBInstanceIdentifier</code> value must be supplied.</p> </li> <li> <p>If the source type is a DB cluster, a <code>DBClusterIdentifier</code> value must be supplied.</p> </li> <li> <p>If the source type is a DB parameter group, a <code>DBParameterGroupName</code> value must be supplied.</p> </li> <li> <p>If the source type is a DB security group, a <code>DBSecurityGroupName</code> value must be supplied.</p> </li> <li> <p>If the source type is a DB snapshot, a <code>DBSnapshotIdentifier</code> value must be supplied.</p> </li> <li> <p>If the source type is a DB cluster snapshot, a <code>DBClusterSnapshotIdentifier</code> value must be supplied.</p> </li> <li> <p>If the source type is an RDS Proxy, a <code>DBProxyName</code> value must be supplied.</p> </li> </ul>', 'AddTagsToResourceMessage$ResourceName' => '<p>The Amazon RDS resource that the tags are added to. This value is an Amazon Resource Name (ARN). For information about creating an ARN, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing"> Constructing an RDS Amazon Resource Name (ARN)</a>.</p>', 'ApplyPendingMaintenanceActionMessage$ResourceIdentifier' => '<p>The RDS Amazon Resource Name (ARN) of the resource that the pending maintenance action applies to. For information about creating an ARN, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing"> Constructing an RDS Amazon Resource Name (ARN)</a>.</p>', 'ApplyPendingMaintenanceActionMessage$ApplyAction' => '<p>The pending maintenance action to apply to this resource.</p> <p>Valid Values: <code>system-update</code>, <code>db-upgrade</code>, <code>hardware-maintenance</code>, <code>ca-certificate-rotation</code> </p>', 'ApplyPendingMaintenanceActionMessage$OptInType' => '<p>A value that specifies the type of opt-in request, or undoes an opt-in request. An opt-in request of type <code>immediate</code> can\'t be undone.</p> <p>Valid Values:</p> <ul> <li> <p> <code>immediate</code> - Apply the maintenance action immediately.</p> </li> <li> <p> <code>next-maintenance</code> - Apply the maintenance action during the next maintenance window for the resource.</p> </li> <li> <p> <code>undo-opt-in</code> - Cancel any existing <code>next-maintenance</code> opt-in requests.</p> </li> </ul>', 'AttributeValueList$member' => NULL, 'AuthorizeDBSecurityGroupIngressMessage$DBSecurityGroupName' => '<p>The name of the DB security group to add authorization to.</p>', 'AuthorizeDBSecurityGroupIngressMessage$CIDRIP' => '<p>The IP range to authorize.</p>', 'AuthorizeDBSecurityGroupIngressMessage$EC2SecurityGroupName' => '<p>Name of the EC2 security group to authorize. For VPC DB security groups, <code>EC2SecurityGroupId</code> must be provided. Otherwise, <code>EC2SecurityGroupOwnerId</code> and either <code>EC2SecurityGroupName</code> or <code>EC2SecurityGroupId</code> must be provided.</p>', 'AuthorizeDBSecurityGroupIngressMessage$EC2SecurityGroupId' => '<p>Id of the EC2 security group to authorize. For VPC DB security groups, <code>EC2SecurityGroupId</code> must be provided. Otherwise, <code>EC2SecurityGroupOwnerId</code> and either <code>EC2SecurityGroupName</code> or <code>EC2SecurityGroupId</code> must be provided.</p>', 'AuthorizeDBSecurityGroupIngressMessage$EC2SecurityGroupOwnerId' => '<p>Amazon Web Services account number of the owner of the EC2 security group specified in the <code>EC2SecurityGroupName</code> parameter. The Amazon Web Services access key ID isn\'t an acceptable value. For VPC DB security groups, <code>EC2SecurityGroupId</code> must be provided. Otherwise, <code>EC2SecurityGroupOwnerId</code> and either <code>EC2SecurityGroupName</code> or <code>EC2SecurityGroupId</code> must be provided.</p>', 'AvailabilityZone$Name' => '<p>The name of the Availability Zone.</p>', 'AvailabilityZones$member' => NULL, 'AvailableProcessorFeature$Name' => '<p>The name of the processor feature. Valid names are <code>coreCount</code> and <code>threadsPerCore</code>.</p>', 'AvailableProcessorFeature$DefaultValue' => '<p>The default value for the processor feature of the DB instance class.</p>', 'AvailableProcessorFeature$AllowedValues' => '<p>The allowed values for the processor feature of the DB instance class.</p>', 'BacktrackDBClusterMessage$DBClusterIdentifier' => '<p>The DB cluster identifier of the DB cluster to be backtracked. This parameter is stored as a lowercase string.</p> <p>Constraints:</p> <ul> <li> <p>Must contain from 1 to 63 alphanumeric characters or hyphens.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Can\'t end with a hyphen or contain two consecutive hyphens.</p> </li> </ul> <p>Example: <code>my-cluster1</code> </p>', 'CACertificateIdentifiersList$member' => NULL, 'CancelExportTaskMessage$ExportTaskIdentifier' => '<p>The identifier of the snapshot or cluster export task to cancel.</p>', 'Certificate$CertificateIdentifier' => '<p>The unique key that identifies a certificate.</p>', 'Certificate$CertificateType' => '<p>The type of the certificate.</p>', 'Certificate$Thumbprint' => '<p>The thumbprint of the certificate.</p>', 'Certificate$CertificateArn' => '<p>The Amazon Resource Name (ARN) for the certificate.</p>', 'CertificateDetails$CAIdentifier' => '<p>The CA identifier of the CA certificate used for the DB instance\'s server certificate.</p>', 'CertificateMessage$DefaultCertificateForNewLaunches' => '<p>The default root CA for new databases created by your Amazon Web Services account. This is either the root CA override set on your Amazon Web Services account or the system default CA for the Region if no override exists. To override the default CA, use the <code>ModifyCertificates</code> operation.</p>', 'CertificateMessage$Marker' => '<p>An optional pagination token provided by a previous <code>DescribeCertificates</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> .</p>', 'CharacterSet$CharacterSetName' => '<p>The name of the character set.</p>', 'CharacterSet$CharacterSetDescription' => '<p>The description of the character set.</p>', 'ClusterPendingModifiedValues$DBClusterIdentifier' => '<p>The DBClusterIdentifier value for the DB cluster.</p>', 'ClusterPendingModifiedValues$MasterUserPassword' => '<p>The master credentials for the DB cluster.</p>', 'ClusterPendingModifiedValues$EngineVersion' => '<p>The database engine version.</p>', 'ClusterPendingModifiedValues$StorageType' => '<p>The storage type for the DB cluster.</p>', 'ConnectionPoolConfiguration$InitQuery' => '<p>One or more SQL statements for the proxy to run when opening each new database connection. Typically used with <code>SET</code> statements to make sure that each connection has identical settings such as time zone and character set. For multiple statements, use semicolons as the separator. You can also include multiple variables in a single <code>SET</code> statement, such as <code>SET x=1, y=2</code>.</p> <p>Default: no initialization query</p>', 'ConnectionPoolConfigurationInfo$InitQuery' => '<p>One or more SQL statements for the proxy to run when opening each new database connection. Typically used with <code>SET</code> statements to make sure that each connection has identical settings such as time zone and character set. This setting is empty by default. For multiple statements, use semicolons as the separator. You can also include multiple variables in a single <code>SET</code> statement, such as <code>SET x=1, y=2</code>.</p>', 'ContextAttribute$Key' => '<p>The key of <code>ContextAttribute</code>.</p>', 'ContextAttribute$Value' => '<p>The value of <code>ContextAttribute</code>.</p>', 'CopyDBClusterParameterGroupMessage$SourceDBClusterParameterGroupIdentifier' => '<p>The identifier or Amazon Resource Name (ARN) for the source DB cluster parameter group. For information about creating an ARN, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing"> Constructing an ARN for Amazon RDS</a> in the <i>Amazon Aurora User Guide</i>.</p> <p>Constraints:</p> <ul> <li> <p>Must specify a valid DB cluster parameter group.</p> </li> </ul>', 'CopyDBClusterParameterGroupMessage$TargetDBClusterParameterGroupIdentifier' => '<p>The identifier for the copied DB cluster parameter group.</p> <p>Constraints:</p> <ul> <li> <p>Can\'t be null, empty, or blank</p> </li> <li> <p>Must contain from 1 to 255 letters, numbers, or hyphens</p> </li> <li> <p>First character must be a letter</p> </li> <li> <p>Can\'t end with a hyphen or contain two consecutive hyphens</p> </li> </ul> <p>Example: <code>my-cluster-param-group1</code> </p>', 'CopyDBClusterParameterGroupMessage$TargetDBClusterParameterGroupDescription' => '<p>A description for the copied DB cluster parameter group.</p>', 'CopyDBClusterSnapshotMessage$SourceDBClusterSnapshotIdentifier' => '<p>The identifier of the DB cluster snapshot to copy. This parameter isn\'t case-sensitive.</p> <p>You can\'t copy an encrypted, shared DB cluster snapshot from one Amazon Web Services Region to another.</p> <p>Constraints:</p> <ul> <li> <p>Must specify a valid system snapshot in the "available" state.</p> </li> <li> <p>If the source snapshot is in the same Amazon Web Services Region as the copy, specify a valid DB snapshot identifier.</p> </li> <li> <p>If the source snapshot is in a different Amazon Web Services Region than the copy, specify a valid DB cluster snapshot ARN. For more information, go to <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_CopySnapshot.html#USER_CopySnapshot.AcrossRegions"> Copying Snapshots Across Amazon Web Services Regions</a> in the <i>Amazon Aurora User Guide</i>.</p> </li> </ul> <p>Example: <code>my-cluster-snapshot1</code> </p>', 'CopyDBClusterSnapshotMessage$TargetDBClusterSnapshotIdentifier' => '<p>The identifier of the new DB cluster snapshot to create from the source DB cluster snapshot. This parameter isn\'t case-sensitive.</p> <p>Constraints:</p> <ul> <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Can\'t end with a hyphen or contain two consecutive hyphens.</p> </li> </ul> <p>Example: <code>my-cluster-snapshot2</code> </p>', 'CopyDBClusterSnapshotMessage$KmsKeyId' => '<p>The Amazon Web Services KMS key identifier for an encrypted DB cluster snapshot. The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the Amazon Web Services KMS key.</p> <p>If you copy an encrypted DB cluster snapshot from your Amazon Web Services account, you can specify a value for <code>KmsKeyId</code> to encrypt the copy with a new KMS key. If you don\'t specify a value for <code>KmsKeyId</code>, then the copy of the DB cluster snapshot is encrypted with the same KMS key as the source DB cluster snapshot.</p> <p>If you copy an encrypted DB cluster snapshot that is shared from another Amazon Web Services account, then you must specify a value for <code>KmsKeyId</code>.</p> <p>To copy an encrypted DB cluster snapshot to another Amazon Web Services Region, you must set <code>KmsKeyId</code> to the Amazon Web Services KMS key identifier you want to use to encrypt the copy of the DB cluster snapshot in the destination Amazon Web Services Region. KMS keys are specific to the Amazon Web Services Region that they are created in, and you can\'t use KMS keys from one Amazon Web Services Region in another Amazon Web Services Region.</p> <p>If you copy an unencrypted DB cluster snapshot and specify a value for the <code>KmsKeyId</code> parameter, an error is returned.</p>', 'CopyDBClusterSnapshotMessage$PreSignedUrl' => '<p>When you are copying a DB cluster snapshot from one Amazon Web Services GovCloud (US) Region to another, the URL that contains a Signature Version 4 signed request for the <code>CopyDBClusterSnapshot</code> API operation in the Amazon Web Services Region that contains the source DB cluster snapshot to copy. Use the <code>PreSignedUrl</code> parameter when copying an encrypted DB cluster snapshot from another Amazon Web Services Region. Don\'t specify <code>PreSignedUrl</code> when copying an encrypted DB cluster snapshot in the same Amazon Web Services Region.</p> <p>This setting applies only to Amazon Web Services GovCloud (US) Regions. It\'s ignored in other Amazon Web Services Regions.</p> <p>The presigned URL must be a valid request for the <code>CopyDBClusterSnapshot</code> API operation that can run in the source Amazon Web Services Region that contains the encrypted DB cluster snapshot to copy. The presigned URL request must contain the following parameter values:</p> <ul> <li> <p> <code>KmsKeyId</code> - The KMS key identifier for the KMS key to use to encrypt the copy of the DB cluster snapshot in the destination Amazon Web Services Region. This is the same identifier for both the <code>CopyDBClusterSnapshot</code> operation that is called in the destination Amazon Web Services Region, and the operation contained in the presigned URL.</p> </li> <li> <p> <code>DestinationRegion</code> - The name of the Amazon Web Services Region that the DB cluster snapshot is to be created in.</p> </li> <li> <p> <code>SourceDBClusterSnapshotIdentifier</code> - The DB cluster snapshot identifier for the encrypted DB cluster snapshot to be copied. This identifier must be in the Amazon Resource Name (ARN) format for the source Amazon Web Services Region. For example, if you are copying an encrypted DB cluster snapshot from the us-west-2 Amazon Web Services Region, then your <code>SourceDBClusterSnapshotIdentifier</code> looks like the following example: <code>arn:aws:rds:us-west-2:123456789012:cluster-snapshot:aurora-cluster1-snapshot-20161115</code>.</p> </li> </ul> <p>To learn how to generate a Signature Version 4 signed request, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html"> Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4)</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html"> Signature Version 4 Signing Process</a>.</p> <note> <p>If you are using an Amazon Web Services SDK tool or the CLI, you can specify <code>SourceRegion</code> (or <code>--source-region</code> for the CLI) instead of specifying <code>PreSignedUrl</code> manually. Specifying <code>SourceRegion</code> autogenerates a presigned URL that is a valid request for the operation that can run in the source Amazon Web Services Region.</p> </note>', 'CopyDBParameterGroupMessage$SourceDBParameterGroupIdentifier' => '<p>The identifier or ARN for the source DB parameter group. For information about creating an ARN, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing"> Constructing an ARN for Amazon RDS</a> in the <i>Amazon RDS User Guide</i>.</p> <p>Constraints:</p> <ul> <li> <p>Must specify a valid DB parameter group.</p> </li> </ul>', 'CopyDBParameterGroupMessage$TargetDBParameterGroupIdentifier' => '<p>The identifier for the copied DB parameter group.</p> <p>Constraints:</p> <ul> <li> <p>Can\'t be null, empty, or blank</p> </li> <li> <p>Must contain from 1 to 255 letters, numbers, or hyphens</p> </li> <li> <p>First character must be a letter</p> </li> <li> <p>Can\'t end with a hyphen or contain two consecutive hyphens</p> </li> </ul> <p>Example: <code>my-db-parameter-group</code> </p>', 'CopyDBParameterGroupMessage$TargetDBParameterGroupDescription' => '<p>A description for the copied DB parameter group.</p>', 'CopyDBSnapshotMessage$SourceDBSnapshotIdentifier' => '<p>The identifier for the source DB snapshot.</p> <p>If the source snapshot is in the same Amazon Web Services Region as the copy, specify a valid DB snapshot identifier. For example, you might specify <code>rds:mysql-instance1-snapshot-20130805</code>.</p> <p>If the source snapshot is in a different Amazon Web Services Region than the copy, specify a valid DB snapshot ARN. For example, you might specify <code>arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20130805</code>.</p> <p>If you are copying from a shared manual DB snapshot, this parameter must be the Amazon Resource Name (ARN) of the shared DB snapshot.</p> <p>If you are copying an encrypted snapshot this parameter must be in the ARN format for the source Amazon Web Services Region.</p> <p>Constraints:</p> <ul> <li> <p>Must specify a valid system snapshot in the "available" state.</p> </li> </ul> <p>Example: <code>rds:mydb-2012-04-02-00-01</code> </p> <p>Example: <code>arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20130805</code> </p>', 'CopyDBSnapshotMessage$TargetDBSnapshotIdentifier' => '<p>The identifier for the copy of the snapshot.</p> <p>Constraints:</p> <ul> <li> <p>Can\'t be null, empty, or blank</p> </li> <li> <p>Must contain from 1 to 255 letters, numbers, or hyphens</p> </li> <li> <p>First character must be a letter</p> </li> <li> <p>Can\'t end with a hyphen or contain two consecutive hyphens</p> </li> </ul> <p>Example: <code>my-db-snapshot</code> </p>', 'CopyDBSnapshotMessage$KmsKeyId' => '<p>The Amazon Web Services KMS key identifier for an encrypted DB snapshot. The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p> <p>If you copy an encrypted DB snapshot from your Amazon Web Services account, you can specify a value for this parameter to encrypt the copy with a new KMS key. If you don\'t specify a value for this parameter, then the copy of the DB snapshot is encrypted with the same Amazon Web Services KMS key as the source DB snapshot.</p> <p>If you copy an encrypted DB snapshot that is shared from another Amazon Web Services account, then you must specify a value for this parameter.</p> <p>If you specify this parameter when you copy an unencrypted snapshot, the copy is encrypted.</p> <p>If you copy an encrypted snapshot to a different Amazon Web Services Region, then you must specify an Amazon Web Services KMS key identifier for the destination Amazon Web Services Region. KMS keys are specific to the Amazon Web Services Region that they are created in, and you can\'t use KMS keys from one Amazon Web Services Region in another Amazon Web Services Region.</p>', 'CopyDBSnapshotMessage$PreSignedUrl' => '<p>When you are copying a snapshot from one Amazon Web Services GovCloud (US) Region to another, the URL that contains a Signature Version 4 signed request for the <code>CopyDBSnapshot</code> API operation in the source Amazon Web Services Region that contains the source DB snapshot to copy.</p> <p>This setting applies only to Amazon Web Services GovCloud (US) Regions. It\'s ignored in other Amazon Web Services Regions.</p> <p>You must specify this parameter when you copy an encrypted DB snapshot from another Amazon Web Services Region by using the Amazon RDS API. Don\'t specify <code>PreSignedUrl</code> when you are copying an encrypted DB snapshot in the same Amazon Web Services Region.</p> <p>The presigned URL must be a valid request for the <code>CopyDBClusterSnapshot</code> API operation that can run in the source Amazon Web Services Region that contains the encrypted DB cluster snapshot to copy. The presigned URL request must contain the following parameter values:</p> <ul> <li> <p> <code>DestinationRegion</code> - The Amazon Web Services Region that the encrypted DB snapshot is copied to. This Amazon Web Services Region is the same one where the <code>CopyDBSnapshot</code> operation is called that contains this presigned URL.</p> <p>For example, if you copy an encrypted DB snapshot from the us-west-2 Amazon Web Services Region to the us-east-1 Amazon Web Services Region, then you call the <code>CopyDBSnapshot</code> operation in the us-east-1 Amazon Web Services Region and provide a presigned URL that contains a call to the <code>CopyDBSnapshot</code> operation in the us-west-2 Amazon Web Services Region. For this example, the <code>DestinationRegion</code> in the presigned URL must be set to the us-east-1 Amazon Web Services Region.</p> </li> <li> <p> <code>KmsKeyId</code> - The KMS key identifier for the KMS key to use to encrypt the copy of the DB snapshot in the destination Amazon Web Services Region. This is the same identifier for both the <code>CopyDBSnapshot</code> operation that is called in the destination Amazon Web Services Region, and the operation contained in the presigned URL.</p> </li> <li> <p> <code>SourceDBSnapshotIdentifier</code> - The DB snapshot identifier for the encrypted snapshot to be copied. This identifier must be in the Amazon Resource Name (ARN) format for the source Amazon Web Services Region. For example, if you are copying an encrypted DB snapshot from the us-west-2 Amazon Web Services Region, then your <code>SourceDBSnapshotIdentifier</code> looks like the following example: <code>arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20161115</code>.</p> </li> </ul> <p>To learn how to generate a Signature Version 4 signed request, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html">Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4)</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4 Signing Process</a>.</p> <note> <p>If you are using an Amazon Web Services SDK tool or the CLI, you can specify <code>SourceRegion</code> (or <code>--source-region</code> for the CLI) instead of specifying <code>PreSignedUrl</code> manually. Specifying <code>SourceRegion</code> autogenerates a presigned URL that is a valid request for the operation that can run in the source Amazon Web Services Region.</p> </note>', 'CopyDBSnapshotMessage$OptionGroupName' => '<p>The name of an option group to associate with the copy of the snapshot.</p> <p>Specify this option if you are copying a snapshot from one Amazon Web Services Region to another, and your DB instance uses a nondefault option group. If your source DB instance uses Transparent Data Encryption for Oracle or Microsoft SQL Server, you must specify this option when copying across Amazon Web Services Regions. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CopySnapshot.html#USER_CopySnapshot.Options">Option group considerations</a> in the <i>Amazon RDS User Guide</i>.</p>', 'CopyDBSnapshotMessage$TargetCustomAvailabilityZone' => '<p>The external custom Availability Zone (CAZ) identifier for the target CAZ.</p> <p>Example: <code>rds-caz-aiqhTgQv</code>.</p>', 'CopyOptionGroupMessage$SourceOptionGroupIdentifier' => '<p>The identifier for the source option group.</p> <p>Constraints:</p> <ul> <li> <p>Must specify a valid option group.</p> </li> </ul>', 'CopyOptionGroupMessage$TargetOptionGroupIdentifier' => '<p>The identifier for the copied option group.</p> <p>Constraints:</p> <ul> <li> <p>Can\'t be null, empty, or blank</p> </li> <li> <p>Must contain from 1 to 255 letters, numbers, or hyphens</p> </li> <li> <p>First character must be a letter</p> </li> <li> <p>Can\'t end with a hyphen or contain two consecutive hyphens</p> </li> </ul> <p>Example: <code>my-option-group</code> </p>', 'CopyOptionGroupMessage$TargetOptionGroupDescription' => '<p>The description for the copied option group.</p>', 'CreateDBClusterEndpointMessage$DBClusterIdentifier' => '<p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is stored as a lowercase string.</p>', 'CreateDBClusterEndpointMessage$DBClusterEndpointIdentifier' => '<p>The identifier to use for the new endpoint. This parameter is stored as a lowercase string.</p>', 'CreateDBClusterEndpointMessage$EndpointType' => '<p>The type of the endpoint, one of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.</p>', 'CreateDBClusterMessage$CharacterSetName' => '<p>The name of the character set (<code>CharacterSet</code>) to associate the DB cluster with.</p> <p>Valid for Cluster Type: Aurora DB clusters only</p>', 'CreateDBClusterMessage$DatabaseName' => '<p>The name for your database of up to 64 alphanumeric characters. A database named <code>postgres</code> is always created. If this parameter is specified, an additional database with this name is created.</p> <p>Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters</p>', 'CreateDBClusterMessage$DBClusterIdentifier' => '<p>The identifier for this DB cluster. This parameter is stored as a lowercase string.</p> <p>Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters</p> <p>Constraints:</p> <ul> <li> <p>Must contain from 1 to 63 (for Aurora DB clusters) or 1 to 52 (for Multi-AZ DB clusters) letters, numbers, or hyphens.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Can\'t end with a hyphen or contain two consecutive hyphens.</p> </li> </ul> <p>Example: <code>my-cluster1</code> </p>', 'CreateDBClusterMessage$DBClusterParameterGroupName' => '<p>The name of the DB cluster parameter group to associate with this DB cluster. If you don\'t specify a value, then the default DB cluster parameter group for the specified DB engine and version is used.</p> <p>Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters</p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match the name of an existing DB cluster parameter group.</p> </li> </ul>', 'CreateDBClusterMessage$DBSubnetGroupName' => '<p>A DB subnet group to associate with this DB cluster.</p> <p>This setting is required to create a Multi-AZ DB cluster.</p> <p>Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters</p> <p>Constraints:</p> <ul> <li> <p>Must match the name of an existing DB subnet group.</p> </li> </ul> <p>Example: <code>mydbsubnetgroup</code> </p>', 'CreateDBClusterMessage$Engine' => '<p>The database engine to use for this DB cluster.</p> <p>Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters</p> <p>Valid Values:</p> <ul> <li> <p> <code>aurora-mysql</code> </p> </li> <li> <p> <code>aurora-postgresql</code> </p> </li> <li> <p> <code>mysql</code> </p> </li> <li> <p> <code>postgres</code> </p> </li> <li> <p> <code>neptune</code> - For information about using Amazon Neptune, see the <a href="https://docs.aws.amazon.com/neptune/latest/userguide/intro.html"> <i>Amazon Neptune User Guide</i> </a>.</p> </li> </ul>', 'CreateDBClusterMessage$EngineVersion' => '<p>The version number of the database engine to use.</p> <p>To list all of the available engine versions for Aurora MySQL version 2 (5.7-compatible) and version 3 (MySQL 8.0-compatible), use the following command:</p> <p> <code>aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"</code> </p> <p>You can supply either <code>5.7</code> or <code>8.0</code> to use the default engine version for Aurora MySQL version 2 or version 3, respectively.</p> <p>To list all of the available engine versions for Aurora PostgreSQL, use the following command:</p> <p> <code>aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"</code> </p> <p>To list all of the available engine versions for RDS for MySQL, use the following command:</p> <p> <code>aws rds describe-db-engine-versions --engine mysql --query "DBEngineVersions[].EngineVersion"</code> </p> <p>To list all of the available engine versions for RDS for PostgreSQL, use the following command:</p> <p> <code>aws rds describe-db-engine-versions --engine postgres --query "DBEngineVersions[].EngineVersion"</code> </p> <p>For information about a specific engine, see the following topics:</p> <ul> <li> <p>Aurora MySQL - see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Updates.html">Database engine updates for Amazon Aurora MySQL</a> in the <i>Amazon Aurora User Guide</i>.</p> </li> <li> <p>Aurora PostgreSQL - see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraPostgreSQL.Updates.20180305.html">Amazon Aurora PostgreSQL releases and engine versions</a> in the <i>Amazon Aurora User Guide</i>.</p> </li> <li> <p>RDS for MySQL - see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt">Amazon RDS for MySQL</a> in the <i>Amazon RDS User Guide</i>.</p> </li> <li> <p>RDS for PostgreSQL - see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts">Amazon RDS for PostgreSQL</a> in the <i>Amazon RDS User Guide</i>.</p> </li> </ul> <p>Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters</p>', 'CreateDBClusterMessage$MasterUsername' => '<p>The name of the master user for the DB cluster.</p> <p>Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters</p> <p>Constraints:</p> <ul> <li> <p>Must be 1 to 16 letters or numbers.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Can\'t be a reserved word for the chosen database engine.</p> </li> </ul>', 'CreateDBClusterMessage$MasterUserPassword' => '<p>The password for the master database user.</p> <p>Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters</p> <p>Constraints:</p> <ul> <li> <p>Must contain from 8 to 41 characters.</p> </li> <li> <p>Can contain any printable ASCII character except "/", """, or "@".</p> </li> <li> <p>Can\'t be specified if <code>ManageMasterUserPassword</code> is turned on.</p> </li> </ul>', 'CreateDBClusterMessage$OptionGroupName' => '<p>The option group to associate the DB cluster with.</p> <p>DB clusters are associated with a default option group that can\'t be modified.</p>', 'CreateDBClusterMessage$PreferredBackupWindow' => '<p>The daily time range during which automated backups are created if automated backups are enabled using the <code>BackupRetentionPeriod</code> parameter.</p> <p>Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters</p> <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region. To view the time blocks available, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.Backups.BackupWindow"> Backup window</a> in the <i>Amazon Aurora User Guide</i>.</p> <p>Constraints:</p> <ul> <li> <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p> </li> <li> <p>Must be in Universal Coordinated Time (UTC).</p> </li> <li> <p>Must not conflict with the preferred maintenance window.</p> </li> <li> <p>Must be at least 30 minutes.</p> </li> </ul>', 'CreateDBClusterMessage$PreferredMaintenanceWindow' => '<p>The weekly time range during which system maintenance can occur.</p> <p>Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters</p> <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region, occurring on a random day of the week. To see the time blocks available, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora"> Adjusting the Preferred DB Cluster Maintenance Window</a> in the <i>Amazon Aurora User Guide</i>.</p> <p>Constraints:</p> <ul> <li> <p>Must be in the format <code>ddd:hh24:mi-ddd:hh24:mi</code>.</p> </li> <li> <p>Days must be one of <code>Mon | Tue | Wed | Thu | Fri | Sat | Sun</code>.</p> </li> <li> <p>Must be in Universal Coordinated Time (UTC).</p> </li> <li> <p>Must be at least 30 minutes.</p> </li> </ul>', 'CreateDBClusterMessage$ReplicationSourceIdentifier' => '<p>The Amazon Resource Name (ARN) of the source DB instance or DB cluster if this DB cluster is created as a read replica.</p> <p>Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters</p>', 'CreateDBClusterMessage$KmsKeyId' => '<p>The Amazon Web Services KMS key identifier for an encrypted DB cluster.</p> <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.</p> <p>When a KMS key isn\'t specified in <code>KmsKeyId</code>:</p> <ul> <li> <p>If <code>ReplicationSourceIdentifier</code> identifies an encrypted source, then Amazon RDS uses the KMS key used to encrypt the source. Otherwise, Amazon RDS uses your default KMS key.</p> </li> <li> <p>If the <code>StorageEncrypted</code> parameter is enabled and <code>ReplicationSourceIdentifier</code> isn\'t specified, then Amazon RDS uses your default KMS key.</p> </li> </ul> <p>There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.</p> <p>If you create a read replica of an encrypted DB cluster in another Amazon Web Services Region, make sure to set <code>KmsKeyId</code> to a KMS key identifier that is valid in the destination Amazon Web Services Region. This KMS key is used to encrypt the read replica in that Amazon Web Services Region.</p> <p>Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters</p>', 'CreateDBClusterMessage$PreSignedUrl' => '<p>When you are replicating a DB cluster from one Amazon Web Services GovCloud (US) Region to another, an URL that contains a Signature Version 4 signed request for the <code>CreateDBCluster</code> operation to be called in the source Amazon Web Services Region where the DB cluster is replicated from. Specify <code>PreSignedUrl</code> only when you are performing cross-Region replication from an encrypted DB cluster.</p> <p>The presigned URL must be a valid request for the <code>CreateDBCluster</code> API operation that can run in the source Amazon Web Services Region that contains the encrypted DB cluster to copy.</p> <p>The presigned URL request must contain the following parameter values:</p> <ul> <li> <p> <code>KmsKeyId</code> - The KMS key identifier for the KMS key to use to encrypt the copy of the DB cluster in the destination Amazon Web Services Region. This should refer to the same KMS key for both the <code>CreateDBCluster</code> operation that is called in the destination Amazon Web Services Region, and the operation contained in the presigned URL.</p> </li> <li> <p> <code>DestinationRegion</code> - The name of the Amazon Web Services Region that Aurora read replica will be created in.</p> </li> <li> <p> <code>ReplicationSourceIdentifier</code> - The DB cluster identifier for the encrypted DB cluster to be copied. This identifier must be in the Amazon Resource Name (ARN) format for the source Amazon Web Services Region. For example, if you are copying an encrypted DB cluster from the us-west-2 Amazon Web Services Region, then your <code>ReplicationSourceIdentifier</code> would look like Example: <code>arn:aws:rds:us-west-2:123456789012:cluster:aurora-cluster1</code>.</p> </li> </ul> <p>To learn how to generate a Signature Version 4 signed request, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html"> Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4)</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html"> Signature Version 4 Signing Process</a>.</p> <note> <p>If you are using an Amazon Web Services SDK tool or the CLI, you can specify <code>SourceRegion</code> (or <code>--source-region</code> for the CLI) instead of specifying <code>PreSignedUrl</code> manually. Specifying <code>SourceRegion</code> autogenerates a presigned URL that is a valid request for the operation that can run in the source Amazon Web Services Region.</p> </note> <p>Valid for Cluster Type: Aurora DB clusters only</p>', 'CreateDBClusterMessage$EngineMode' => '<p>The DB engine mode of the DB cluster, either <code>provisioned</code> or <code>serverless</code>.</p> <p>The <code>serverless</code> engine mode only applies for Aurora Serverless v1 DB clusters. Aurora Serverless v2 DB clusters use the <code>provisioned</code> engine mode.</p> <p>For information about limitations and requirements for Serverless DB clusters, see the following sections in the <i>Amazon Aurora User Guide</i>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html#aurora-serverless.limitations">Limitations of Aurora Serverless v1</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.requirements.html">Requirements for Aurora Serverless v2</a> </p> </li> </ul> <p>Valid for Cluster Type: Aurora DB clusters only</p>', 'CreateDBClusterMessage$GlobalClusterIdentifier' => '<p>The global cluster ID of an Aurora cluster that becomes the primary cluster in the new global database cluster.</p> <p>Valid for Cluster Type: Aurora DB clusters only</p>', 'CreateDBClusterMessage$Domain' => '<p>The Active Directory directory ID to create the DB cluster in.</p> <p>For Amazon Aurora DB clusters, Amazon RDS can use Kerberos authentication to authenticate users that connect to the DB cluster.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/kerberos-authentication.html">Kerberos authentication</a> in the <i>Amazon Aurora User Guide</i>.</p> <p>Valid for Cluster Type: Aurora DB clusters only</p>', 'CreateDBClusterMessage$DomainIAMRoleName' => '<p>The name of the IAM role to use when making API calls to the Directory Service.</p> <p>Valid for Cluster Type: Aurora DB clusters only</p>', 'CreateDBClusterMessage$DBClusterInstanceClass' => '<p>The compute and memory capacity of each DB instance in the Multi-AZ DB cluster, for example <code>db.m6gd.xlarge</code>. Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines.</p> <p>For the full list of DB instance classes and availability for your engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB instance class</a> in the <i>Amazon RDS User Guide</i>.</p> <p>This setting is required to create a Multi-AZ DB cluster.</p> <p>Valid for Cluster Type: Multi-AZ DB clusters only</p>', 'CreateDBClusterMessage$StorageType' => '<p>The storage type to associate with the DB cluster.</p> <p>For information on storage types for Aurora DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Overview.StorageReliability.html#aurora-storage-type">Storage configurations for Amazon Aurora DB clusters</a>. For information on storage types for Multi-AZ DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/create-multi-az-db-cluster.html#create-multi-az-db-cluster-settings">Settings for creating Multi-AZ DB clusters</a>.</p> <p>This setting is required to create a Multi-AZ DB cluster.</p> <p>When specified for a Multi-AZ DB cluster, a value for the <code>Iops</code> parameter is required.</p> <p>Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters</p> <p>Valid Values:</p> <ul> <li> <p>Aurora DB clusters - <code>aurora | aurora-iopt1</code> </p> </li> <li> <p>Multi-AZ DB clusters - <code>io1 | io2 | gp3</code> </p> </li> </ul> <p>Default:</p> <ul> <li> <p>Aurora DB clusters - <code>aurora</code> </p> </li> <li> <p>Multi-AZ DB clusters - <code>io1</code> </p> </li> </ul> <note> <p>When you create an Aurora DB cluster with the storage type set to <code>aurora-iopt1</code>, the storage type is returned in the response. The storage type isn\'t returned when you set it to <code>aurora</code>.</p> </note>', 'CreateDBClusterMessage$MonitoringRoleArn' => '<p>The Amazon Resource Name (ARN) for the IAM role that permits RDS to send Enhanced Monitoring metrics to Amazon CloudWatch Logs. An example is <code>arn:aws:iam:123456789012:role/emaccess</code>. For information on creating a monitoring role, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling">Setting up and enabling Enhanced Monitoring</a> in the <i>Amazon RDS User Guide</i>.</p> <p>If <code>MonitoringInterval</code> is set to a value other than <code>0</code>, supply a <code>MonitoringRoleArn</code> value.</p> <p>Valid for Cluster Type: Multi-AZ DB clusters only</p>', 'CreateDBClusterMessage$PerformanceInsightsKMSKeyId' => '<p>The Amazon Web Services KMS key identifier for encryption of Performance Insights data.</p> <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p> <p>If you don\'t specify a value for <code>PerformanceInsightsKMSKeyId</code>, then Amazon RDS uses your default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.</p> <p>Valid for Cluster Type: Multi-AZ DB clusters only</p>', 'CreateDBClusterMessage$NetworkType' => '<p>The network type of the DB cluster.</p> <p>The network type is determined by the <code>DBSubnetGroup</code> specified for the DB cluster. A <code>DBSubnetGroup</code> can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (<code>DUAL</code>).</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html"> Working with a DB instance in a VPC</a> in the <i>Amazon Aurora User Guide.</i> </p> <p>Valid for Cluster Type: Aurora DB clusters only</p> <p>Valid Values: <code>IPV4 | DUAL</code> </p>', 'CreateDBClusterMessage$DBSystemId' => '<p>Reserved for future use.</p>', 'CreateDBClusterMessage$MasterUserSecretKmsKeyId' => '<p>The Amazon Web Services KMS key identifier to encrypt a secret that is automatically generated and managed in Amazon Web Services Secrets Manager.</p> <p>This setting is valid only if the master user password is managed by RDS in Amazon Web Services Secrets Manager for the DB cluster.</p> <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.</p> <p>If you don\'t specify <code>MasterUserSecretKmsKeyId</code>, then the <code>aws/secretsmanager</code> KMS key is used to encrypt the secret. If the secret is in a different Amazon Web Services account, then you can\'t use the <code>aws/secretsmanager</code> KMS key to encrypt the secret, and you must use a customer managed KMS key.</p> <p>There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.</p> <p>Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters</p>', 'CreateDBClusterMessage$CACertificateIdentifier' => '<p>The CA certificate identifier to use for the DB cluster\'s server certificate.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html">Using SSL/TLS to encrypt a connection to a DB instance</a> in the <i>Amazon RDS User Guide</i>.</p> <p>Valid for Cluster Type: Multi-AZ DB clusters</p>', 'CreateDBClusterMessage$EngineLifecycleSupport' => '<p>The life cycle type for this DB cluster.</p> <note> <p>By default, this value is set to <code>open-source-rds-extended-support</code>, which enrolls your DB cluster into Amazon RDS Extended Support. At the end of standard support, you can avoid charges for Extended Support by setting the value to <code>open-source-rds-extended-support-disabled</code>. In this case, creating the DB cluster will fail if the DB major version is past its end of standard support date.</p> </note> <p>You can use this setting to enroll your DB cluster into Amazon RDS Extended Support. With RDS Extended Support, you can run the selected major engine version on your DB cluster past the end of standard support for that engine version. For more information, see the following sections:</p> <ul> <li> <p>Amazon Aurora (PostgreSQL only) - <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/extended-support.html">Using Amazon RDS Extended Support</a> in the <i>Amazon Aurora User Guide</i> </p> </li> <li> <p>Amazon RDS - <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html">Using Amazon RDS Extended Support</a> in the <i>Amazon RDS User Guide</i> </p> </li> </ul> <p>Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters</p> <p>Valid Values: <code>open-source-rds-extended-support | open-source-rds-extended-support-disabled</code> </p> <p>Default: <code>open-source-rds-extended-support</code> </p>', 'CreateDBClusterParameterGroupMessage$DBClusterParameterGroupName' => '<p>The name of the DB cluster parameter group.</p> <p>Constraints:</p> <ul> <li> <p>Must not match the name of an existing DB cluster parameter group.</p> </li> </ul> <note> <p>This value is stored as a lowercase string.</p> </note>', 'CreateDBClusterParameterGroupMessage$DBParameterGroupFamily' => '<p>The DB cluster parameter group family name. A DB cluster parameter group can be associated with one and only one DB cluster parameter group family, and can be applied only to a DB cluster running a database engine and engine version compatible with that DB cluster parameter group family.</p> <p> <b>Aurora MySQL</b> </p> <p>Example: <code>aurora-mysql5.7</code>, <code>aurora-mysql8.0</code> </p> <p> <b>Aurora PostgreSQL</b> </p> <p>Example: <code>aurora-postgresql14</code> </p> <p> <b>RDS for MySQL</b> </p> <p>Example: <code>mysql8.0</code> </p> <p> <b>RDS for PostgreSQL</b> </p> <p>Example: <code>postgres13</code> </p> <p>To list all of the available parameter group families for a DB engine, use the following command:</p> <p> <code>aws rds describe-db-engine-versions --query "DBEngineVersions[].DBParameterGroupFamily" --engine &lt;engine&gt;</code> </p> <p>For example, to list all of the available parameter group families for the Aurora PostgreSQL DB engine, use the following command:</p> <p> <code>aws rds describe-db-engine-versions --query "DBEngineVersions[].DBParameterGroupFamily" --engine aurora-postgresql</code> </p> <note> <p>The output contains duplicates.</p> </note> <p>The following are the valid DB engine values:</p> <ul> <li> <p> <code>aurora-mysql</code> </p> </li> <li> <p> <code>aurora-postgresql</code> </p> </li> <li> <p> <code>mysql</code> </p> </li> <li> <p> <code>postgres</code> </p> </li> </ul>', 'CreateDBClusterParameterGroupMessage$Description' => '<p>The description for the DB cluster parameter group.</p>', 'CreateDBClusterSnapshotMessage$DBClusterSnapshotIdentifier' => '<p>The identifier of the DB cluster snapshot. This parameter is stored as a lowercase string.</p> <p>Constraints:</p> <ul> <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Can\'t end with a hyphen or contain two consecutive hyphens.</p> </li> </ul> <p>Example: <code>my-cluster1-snapshot1</code> </p>', 'CreateDBClusterSnapshotMessage$DBClusterIdentifier' => '<p>The identifier of the DB cluster to create a snapshot for. This parameter isn\'t case-sensitive.</p> <p>Constraints:</p> <ul> <li> <p>Must match the identifier of an existing DBCluster.</p> </li> </ul> <p>Example: <code>my-cluster1</code> </p>', 'CreateDBInstanceMessage$DBName' => '<p>The meaning of this parameter differs according to the database engine you use.</p> <dl> <dt>Amazon Aurora MySQL</dt> <dd> <p>The name of the database to create when the primary DB instance of the Aurora MySQL DB cluster is created. If this parameter isn\'t specified for an Aurora MySQL DB cluster, no database is created in the DB cluster.</p> <p>Constraints:</p> <ul> <li> <p>Must contain 1 to 64 alphanumeric characters.</p> </li> <li> <p>Can\'t be a word reserved by the database engine.</p> </li> </ul> </dd> <dt>Amazon Aurora PostgreSQL</dt> <dd> <p>The name of the database to create when the primary DB instance of the Aurora PostgreSQL DB cluster is created. A database named <code>postgres</code> is always created. If this parameter is specified, an additional database with this name is created.</p> <p>Constraints:</p> <ul> <li> <p>It must contain 1 to 63 alphanumeric characters.</p> </li> <li> <p>Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0 to 9).</p> </li> <li> <p>Can\'t be a word reserved by the database engine.</p> </li> </ul> </dd> <dt>Amazon RDS Custom for Oracle</dt> <dd> <p>The Oracle System ID (SID) of the created RDS Custom DB instance. If you don\'t specify a value, the default value is <code>ORCL</code> for non-CDBs and <code>RDSCDB</code> for CDBs.</p> <p>Default: <code>ORCL</code> </p> <p>Constraints:</p> <ul> <li> <p>Must contain 1 to 8 alphanumeric characters.</p> </li> <li> <p>Must contain a letter.</p> </li> <li> <p>Can\'t be a word reserved by the database engine.</p> </li> </ul> </dd> <dt>Amazon RDS Custom for SQL Server</dt> <dd> <p>Not applicable. Must be null.</p> </dd> <dt>RDS for Db2</dt> <dd> <p>The name of the database to create when the DB instance is created. If this parameter isn\'t specified, no database is created in the DB instance. In some cases, we recommend that you don\'t add a database name. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/db2-db-instance-prereqs.html#db2-prereqs-additional-considerations">Additional considerations</a> in the <i>Amazon RDS User Guide</i>.</p> <p>Constraints:</p> <ul> <li> <p>Must contain 1 to 64 letters or numbers.</p> </li> <li> <p>Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).</p> </li> <li> <p>Can\'t be a word reserved by the specified database engine.</p> </li> </ul> </dd> <dt>RDS for MariaDB</dt> <dd> <p>The name of the database to create when the DB instance is created. If this parameter isn\'t specified, no database is created in the DB instance.</p> <p>Constraints:</p> <ul> <li> <p>Must contain 1 to 64 letters or numbers.</p> </li> <li> <p>Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).</p> </li> <li> <p>Can\'t be a word reserved by the specified database engine.</p> </li> </ul> </dd> <dt>RDS for MySQL</dt> <dd> <p>The name of the database to create when the DB instance is created. If this parameter isn\'t specified, no database is created in the DB instance.</p> <p>Constraints:</p> <ul> <li> <p>Must contain 1 to 64 letters or numbers.</p> </li> <li> <p>Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).</p> </li> <li> <p>Can\'t be a word reserved by the specified database engine.</p> </li> </ul> </dd> <dt>RDS for Oracle</dt> <dd> <p>The Oracle System ID (SID) of the created DB instance. If you don\'t specify a value, the default value is <code>ORCL</code>. You can\'t specify the string <code>null</code>, or any other reserved word, for <code>DBName</code>.</p> <p>Default: <code>ORCL</code> </p> <p>Constraints:</p> <ul> <li> <p>Can\'t be longer than 8 characters.</p> </li> </ul> </dd> <dt>RDS for PostgreSQL</dt> <dd> <p>The name of the database to create when the DB instance is created. A database named <code>postgres</code> is always created. If this parameter is specified, an additional database with this name is created.</p> <p>Constraints:</p> <ul> <li> <p>Must contain 1 to 63 letters, numbers, or underscores.</p> </li> <li> <p>Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).</p> </li> <li> <p>Can\'t be a word reserved by the specified database engine.</p> </li> </ul> </dd> <dt>RDS for SQL Server</dt> <dd> <p>Not applicable. Must be null.</p> </dd> </dl>', 'CreateDBInstanceMessage$DBInstanceIdentifier' => '<p>The identifier for this DB instance. This parameter is stored as a lowercase string.</p> <p>Constraints:</p> <ul> <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Can\'t end with a hyphen or contain two consecutive hyphens.</p> </li> </ul> <p>Example: <code>mydbinstance</code> </p>', 'CreateDBInstanceMessage$DBInstanceClass' => '<p>The compute and memory capacity of the DB instance, for example <code>db.m5.large</code>. Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines. For the full list of DB instance classes, and availability for your engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB instance classes</a> in the <i>Amazon RDS User Guide</i> or <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.DBInstanceClass.html">Aurora DB instance classes</a> in the <i>Amazon Aurora User Guide</i>.</p>', 'CreateDBInstanceMessage$Engine' => '<p>The database engine to use for this DB instance.</p> <p>Not every database engine is available in every Amazon Web Services Region.</p> <p>Valid Values:</p> <ul> <li> <p> <code>aurora-mysql</code> (for Aurora MySQL DB instances)</p> </li> <li> <p> <code>aurora-postgresql</code> (for Aurora PostgreSQL DB instances)</p> </li> <li> <p> <code>custom-oracle-ee</code> (for RDS Custom for Oracle DB instances)</p> </li> <li> <p> <code>custom-oracle-ee-cdb</code> (for RDS Custom for Oracle DB instances)</p> </li> <li> <p> <code>custom-oracle-se2</code> (for RDS Custom for Oracle DB instances)</p> </li> <li> <p> <code>custom-oracle-se2-cdb</code> (for RDS Custom for Oracle DB instances)</p> </li> <li> <p> <code>custom-sqlserver-ee</code> (for RDS Custom for SQL Server DB instances)</p> </li> <li> <p> <code>custom-sqlserver-se</code> (for RDS Custom for SQL Server DB instances)</p> </li> <li> <p> <code>custom-sqlserver-web</code> (for RDS Custom for SQL Server DB instances)</p> </li> <li> <p> <code>db2-ae</code> </p> </li> <li> <p> <code>db2-se</code> </p> </li> <li> <p> <code>mariadb</code> </p> </li> <li> <p> <code>mysql</code> </p> </li> <li> <p> <code>oracle-ee</code> </p> </li> <li> <p> <code>oracle-ee-cdb</code> </p> </li> <li> <p> <code>oracle-se2</code> </p> </li> <li> <p> <code>oracle-se2-cdb</code> </p> </li> <li> <p> <code>postgres</code> </p> </li> <li> <p> <code>sqlserver-ee</code> </p> </li> <li> <p> <code>sqlserver-se</code> </p> </li> <li> <p> <code>sqlserver-ex</code> </p> </li> <li> <p> <code>sqlserver-web</code> </p> </li> </ul>', 'CreateDBInstanceMessage$MasterUsername' => '<p>The name for the master user.</p> <p>This setting doesn\'t apply to Amazon Aurora DB instances. The name for the master user is managed by the DB cluster.</p> <p>This setting is required for RDS DB instances.</p> <p>Constraints:</p> <ul> <li> <p>Must be 1 to 16 letters, numbers, or underscores.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Can\'t be a reserved word for the chosen database engine.</p> </li> </ul>', 'CreateDBInstanceMessage$MasterUserPassword' => '<p>The password for the master user.</p> <p>This setting doesn\'t apply to Amazon Aurora DB instances. The password for the master user is managed by the DB cluster.</p> <p>Constraints:</p> <ul> <li> <p>Can\'t be specified if <code>ManageMasterUserPassword</code> is turned on.</p> </li> <li> <p>Can include any printable ASCII character except "/", """, or "@". For RDS for Oracle, can\'t include the "&amp;" (ampersand) or the "\'" (single quotes) character.</p> </li> </ul> <p>Length Constraints:</p> <ul> <li> <p>RDS for Db2 - Must contain from 8 to 255 characters.</p> </li> <li> <p>RDS for MariaDB - Must contain from 8 to 41 characters.</p> </li> <li> <p>RDS for Microsoft SQL Server - Must contain from 8 to 128 characters.</p> </li> <li> <p>RDS for MySQL - Must contain from 8 to 41 characters.</p> </li> <li> <p>RDS for Oracle - Must contain from 8 to 30 characters.</p> </li> <li> <p>RDS for PostgreSQL - Must contain from 8 to 128 characters.</p> </li> </ul>', 'CreateDBInstanceMessage$AvailabilityZone' => '<p>The Availability Zone (AZ) where the database will be created. For information on Amazon Web Services Regions and Availability Zones, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html">Regions and Availability Zones</a>.</p> <p>For Amazon Aurora, each Aurora DB cluster hosts copies of its storage in three separate Availability Zones. Specify one of these Availability Zones. Aurora automatically chooses an appropriate Availability Zone if you don\'t specify one.</p> <p>Default: A random, system-chosen Availability Zone in the endpoint\'s Amazon Web Services Region.</p> <p>Constraints:</p> <ul> <li> <p>The <code>AvailabilityZone</code> parameter can\'t be specified if the DB instance is a Multi-AZ deployment.</p> </li> <li> <p>The specified Availability Zone must be in the same Amazon Web Services Region as the current endpoint.</p> </li> </ul> <p>Example: <code>us-east-1d</code> </p>', 'CreateDBInstanceMessage$DBSubnetGroupName' => '<p>A DB subnet group to associate with this DB instance.</p> <p>Constraints:</p> <ul> <li> <p>Must match the name of an existing DB subnet group.</p> </li> <li> <p>Must not be <code>default</code>.</p> </li> </ul> <p>Example: <code>mydbsubnetgroup</code> </p>', 'CreateDBInstanceMessage$PreferredMaintenanceWindow' => '<p>The time range each week during which system maintenance can occur. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance">Amazon RDS Maintenance Window</a> in the <i>Amazon RDS User Guide.</i> </p> <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region, occurring on a random day of the week.</p> <p>Constraints:</p> <ul> <li> <p>Must be in the format <code>ddd:hh24:mi-ddd:hh24:mi</code>.</p> </li> <li> <p>The day values must be <code>mon | tue | wed | thu | fri | sat | sun</code>. </p> </li> <li> <p>Must be in Universal Coordinated Time (UTC).</p> </li> <li> <p>Must not conflict with the preferred backup window.</p> </li> <li> <p>Must be at least 30 minutes.</p> </li> </ul>', 'CreateDBInstanceMessage$DBParameterGroupName' => '<p>The name of the DB parameter group to associate with this DB instance. If you don\'t specify a value, then Amazon RDS uses the default DB parameter group for the specified DB engine and version.</p> <p>This setting doesn\'t apply to RDS Custom DB instances.</p> <p>Constraints:</p> <ul> <li> <p>Must be 1 to 255 letters, numbers, or hyphens.</p> </li> <li> <p>The first character must be a letter.</p> </li> <li> <p>Can\'t end with a hyphen or contain two consecutive hyphens.</p> </li> </ul>', 'CreateDBInstanceMessage$PreferredBackupWindow' => '<p>The daily time range during which automated backups are created if automated backups are enabled, using the <code>BackupRetentionPeriod</code> parameter. The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow">Backup window</a> in the <i>Amazon RDS User Guide</i>.</p> <p>This setting doesn\'t apply to Amazon Aurora DB instances. The daily time range for creating automated backups is managed by the DB cluster.</p> <p>Constraints:</p> <ul> <li> <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p> </li> <li> <p>Must be in Universal Coordinated Time (UTC).</p> </li> <li> <p>Must not conflict with the preferred maintenance window.</p> </li> <li> <p>Must be at least 30 minutes.</p> </li> </ul>', 'CreateDBInstanceMessage$EngineVersion' => '<p>The version number of the database engine to use.</p> <p>This setting doesn\'t apply to Amazon Aurora DB instances. The version number of the database engine the DB instance uses is managed by the DB cluster.</p> <p>For a list of valid engine versions, use the <code>DescribeDBEngineVersions</code> operation.</p> <p>The following are the database engines and links to information about the major and minor versions that are available with Amazon RDS. Not every database engine is available for every Amazon Web Services Region.</p> <dl> <dt>Amazon RDS Custom for Oracle</dt> <dd> <p>A custom engine version (CEV) that you have previously created. This setting is required for RDS Custom for Oracle. The CEV name has the following format: 19.<i>customized_string</i>. A valid CEV name is <code>19.my_cev1</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-creating.html#custom-creating.create"> Creating an RDS Custom for Oracle DB instance</a> in the <i>Amazon RDS User Guide</i>.</p> </dd> <dt>Amazon RDS Custom for SQL Server</dt> <dd> <p>See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-reqs-limits-MS.html">RDS Custom for SQL Server general requirements</a> in the <i>Amazon RDS User Guide</i>.</p> </dd> <dt>RDS for Db2</dt> <dd> <p>For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Db2.html#Db2.Concepts.VersionMgmt">Db2 on Amazon RDS versions</a> in the <i>Amazon RDS User Guide</i>.</p> </dd> <dt>RDS for MariaDB</dt> <dd> <p>For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MariaDB.html#MariaDB.Concepts.VersionMgmt">MariaDB on Amazon RDS versions</a> in the <i>Amazon RDS User Guide</i>.</p> </dd> <dt>RDS for Microsoft SQL Server</dt> <dd> <p>For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.VersionSupport">Microsoft SQL Server versions on Amazon RDS</a> in the <i>Amazon RDS User Guide</i>.</p> </dd> <dt>RDS for MySQL</dt> <dd> <p>For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt">MySQL on Amazon RDS versions</a> in the <i>Amazon RDS User Guide</i>.</p> </dd> <dt>RDS for Oracle</dt> <dd> <p>For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.Oracle.PatchComposition.html">Oracle Database Engine release notes</a> in the <i>Amazon RDS User Guide</i>.</p> </dd> <dt>RDS for PostgreSQL</dt> <dd> <p>For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts">Amazon RDS for PostgreSQL versions and extensions</a> in the <i>Amazon RDS User Guide</i>.</p> </dd> </dl>', 'CreateDBInstanceMessage$LicenseModel' => '<p>The license model information for this DB instance.</p> <note> <p>License models for RDS for Db2 require additional configuration. The Bring Your Own License (BYOL) model requires a custom parameter group. The Db2 license through Amazon Web Services Marketplace model requires an Amazon Web Services Marketplace subscription. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/db2-licensing.html">RDS for Db2 licensing options</a> in the <i>Amazon RDS User Guide</i>.</p> <p>The default for RDS for Db2 is <code>bring-your-own-license</code>.</p> </note> <p>This setting doesn\'t apply to Amazon Aurora or RDS Custom DB instances.</p> <p>Valid Values:</p> <ul> <li> <p>RDS for Db2 - <code>bring-your-own-license | marketplace-license</code> </p> </li> <li> <p>RDS for MariaDB - <code>general-public-license</code> </p> </li> <li> <p>RDS for Microsoft SQL Server - <code>license-included</code> </p> </li> <li> <p>RDS for MySQL - <code>general-public-license</code> </p> </li> <li> <p>RDS for Oracle - <code>bring-your-own-license | license-included</code> </p> </li> <li> <p>RDS for PostgreSQL - <code>postgresql-license</code> </p> </li> </ul>', 'CreateDBInstanceMessage$OptionGroupName' => '<p>The option group to associate the DB instance with.</p> <p>Permanent options, such as the TDE option for Oracle Advanced Security TDE, can\'t be removed from an option group. Also, that option group can\'t be removed from a DB instance after it is associated with a DB instance.</p> <p>This setting doesn\'t apply to Amazon Aurora or RDS Custom DB instances.</p>', 'CreateDBInstanceMessage$CharacterSetName' => '<p>For supported engines, the character set (<code>CharacterSet</code>) to associate the DB instance with.</p> <p>This setting doesn\'t apply to the following DB instances:</p> <ul> <li> <p>Amazon Aurora - The character set is managed by the DB cluster. For more information, see <code>CreateDBCluster</code>.</p> </li> <li> <p>RDS Custom - However, if you need to change the character set, you can change it on the database itself.</p> </li> </ul>', 'CreateDBInstanceMessage$NcharCharacterSetName' => '<p>The name of the NCHAR character set for the Oracle DB instance.</p> <p>This setting doesn\'t apply to RDS Custom DB instances.</p>', 'CreateDBInstanceMessage$DBClusterIdentifier' => '<p>The identifier of the DB cluster that this DB instance will belong to.</p> <p>This setting doesn\'t apply to RDS Custom DB instances.</p>', 'CreateDBInstanceMessage$StorageType' => '<p>The storage type to associate with the DB instance.</p> <p>If you specify <code>io1</code>, <code>io2</code>, or <code>gp3</code>, you must also include a value for the <code>Iops</code> parameter.</p> <p>This setting doesn\'t apply to Amazon Aurora DB instances. Storage is managed by the DB cluster.</p> <p>Valid Values: <code>gp2 | gp3 | io1 | io2 | standard</code> </p> <p>Default: <code>io1</code>, if the <code>Iops</code> parameter is specified. Otherwise, <code>gp2</code>.</p>', 'CreateDBInstanceMessage$TdeCredentialArn' => '<p>The ARN from the key store with which to associate the instance for TDE encryption.</p> <p>This setting doesn\'t apply to Amazon Aurora or RDS Custom DB instances.</p>', 'CreateDBInstanceMessage$TdeCredentialPassword' => '<p>The password for the given ARN from the key store in order to access the device.</p> <p>This setting doesn\'t apply to RDS Custom DB instances.</p>', 'CreateDBInstanceMessage$KmsKeyId' => '<p>The Amazon Web Services KMS key identifier for an encrypted DB instance.</p> <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.</p> <p>This setting doesn\'t apply to Amazon Aurora DB instances. The Amazon Web Services KMS key identifier is managed by the DB cluster. For more information, see <code>CreateDBCluster</code>.</p> <p>If <code>StorageEncrypted</code> is enabled, and you do not specify a value for the <code>KmsKeyId</code> parameter, then Amazon RDS uses your default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.</p> <p>For Amazon RDS Custom, a KMS key is required for DB instances. For most RDS engines, if you leave this parameter empty while enabling <code>StorageEncrypted</code>, the engine uses the default KMS key. However, RDS Custom doesn\'t use the default key when this parameter is empty. You must explicitly specify a key.</p>', 'CreateDBInstanceMessage$Domain' => '<p>The Active Directory directory ID to create the DB instance in. Currently, you can create only Db2, MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB instances in an Active Directory Domain.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html"> Kerberos Authentication</a> in the <i>Amazon RDS User Guide</i>.</p> <p>This setting doesn\'t apply to the following DB instances:</p> <ul> <li> <p>Amazon Aurora (The domain is managed by the DB cluster.)</p> </li> <li> <p>RDS Custom</p> </li> </ul>', 'CreateDBInstanceMessage$DomainFqdn' => '<p>The fully qualified domain name (FQDN) of an Active Directory domain.</p> <p>Constraints:</p> <ul> <li> <p>Can\'t be longer than 64 characters.</p> </li> </ul> <p>Example: <code>mymanagedADtest.mymanagedAD.mydomain</code> </p>', 'CreateDBInstanceMessage$DomainOu' => '<p>The Active Directory organizational unit for your DB instance to join.</p> <p>Constraints:</p> <ul> <li> <p>Must be in the distinguished name format.</p> </li> <li> <p>Can\'t be longer than 64 characters.</p> </li> </ul> <p>Example: <code>OU=mymanagedADtestOU,DC=mymanagedADtest,DC=mymanagedAD,DC=mydomain</code> </p>', 'CreateDBInstanceMessage$DomainAuthSecretArn' => '<p>The ARN for the Secrets Manager secret with the credentials for the user joining the domain.</p> <p>Example: <code>arn:aws:secretsmanager:region:account-number:secret:myselfmanagedADtestsecret-123456</code> </p>', 'CreateDBInstanceMessage$MonitoringRoleArn' => '<p>The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs. For example, <code>arn:aws:iam:123456789012:role/emaccess</code>. For information on creating a monitoring role, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling">Setting Up and Enabling Enhanced Monitoring</a> in the <i>Amazon RDS User Guide</i>.</p> <p>If <code>MonitoringInterval</code> is set to a value other than <code>0</code>, then you must supply a <code>MonitoringRoleArn</code> value.</p> <p>This setting doesn\'t apply to RDS Custom DB instances.</p>', 'CreateDBInstanceMessage$DomainIAMRoleName' => '<p>The name of the IAM role to use when making API calls to the Directory Service.</p> <p>This setting doesn\'t apply to the following DB instances:</p> <ul> <li> <p>Amazon Aurora (The domain is managed by the DB cluster.)</p> </li> <li> <p>RDS Custom</p> </li> </ul>', 'CreateDBInstanceMessage$Timezone' => '<p>The time zone of the DB instance. The time zone parameter is currently supported only by <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/db2-time-zone">RDS for Db2</a> and <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.TimeZone">RDS for SQL Server</a>.</p>', 'CreateDBInstanceMessage$PerformanceInsightsKMSKeyId' => '<p>The Amazon Web Services KMS key identifier for encryption of Performance Insights data.</p> <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p> <p>If you don\'t specify a value for <code>PerformanceInsightsKMSKeyId</code>, then Amazon RDS uses your default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.</p> <p>This setting doesn\'t apply to RDS Custom DB instances.</p>', 'CreateDBInstanceMessage$CustomIamInstanceProfile' => '<p>The instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance.</p> <p>This setting is required for RDS Custom.</p> <p>Constraints:</p> <ul> <li> <p>The profile must exist in your account.</p> </li> <li> <p>The profile must have an IAM role that Amazon EC2 has permissions to assume.</p> </li> <li> <p>The instance profile name and the associated IAM role name must start with the prefix <code>AWSRDSCustom</code>.</p> </li> </ul> <p>For the list of permissions required for the IAM role, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-setup-orcl.html#custom-setup-orcl.iam-vpc"> Configure IAM and your VPC</a> in the <i>Amazon RDS User Guide</i>.</p>', 'CreateDBInstanceMessage$BackupTarget' => '<p>The location for storing automated backups and manual snapshots.</p> <p>Valid Values:</p> <ul> <li> <p> <code>outposts</code> (Amazon Web Services Outposts)</p> </li> <li> <p> <code>region</code> (Amazon Web Services Region)</p> </li> </ul> <p>Default: <code>region</code> </p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Working with Amazon RDS on Amazon Web Services Outposts</a> in the <i>Amazon RDS User Guide</i>.</p>', 'CreateDBInstanceMessage$NetworkType' => '<p>The network type of the DB instance.</p> <p>The network type is determined by the <code>DBSubnetGroup</code> specified for the DB instance. A <code>DBSubnetGroup</code> can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (<code>DUAL</code>).</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html"> Working with a DB instance in a VPC</a> in the <i>Amazon RDS User Guide.</i> </p> <p>Valid Values: <code>IPV4 | DUAL</code> </p>', 'CreateDBInstanceMessage$MasterUserSecretKmsKeyId' => '<p>The Amazon Web Services KMS key identifier to encrypt a secret that is automatically generated and managed in Amazon Web Services Secrets Manager.</p> <p>This setting is valid only if the master user password is managed by RDS in Amazon Web Services Secrets Manager for the DB instance.</p> <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.</p> <p>If you don\'t specify <code>MasterUserSecretKmsKeyId</code>, then the <code>aws/secretsmanager</code> KMS key is used to encrypt the secret. If the secret is in a different Amazon Web Services account, then you can\'t use the <code>aws/secretsmanager</code> KMS key to encrypt the secret, and you must use a customer managed KMS key.</p> <p>There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.</p>', 'CreateDBInstanceMessage$CACertificateIdentifier' => '<p>The CA certificate identifier to use for the DB instance\'s server certificate.</p> <p>This setting doesn\'t apply to RDS Custom DB instances.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html">Using SSL/TLS to encrypt a connection to a DB instance</a> in the <i>Amazon RDS User Guide</i> and <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html"> Using SSL/TLS to encrypt a connection to a DB cluster</a> in the <i>Amazon Aurora User Guide</i>.</p>', 'CreateDBInstanceMessage$DBSystemId' => '<p>The Oracle system identifier (SID), which is the name of the Oracle database instance that manages your database files. In this context, the term "Oracle database instance" refers exclusively to the system global area (SGA) and Oracle background processes. If you don\'t specify a SID, the value defaults to <code>RDSCDB</code>. The Oracle SID is also the name of your CDB.</p>', 'CreateDBInstanceMessage$EngineLifecycleSupport' => '<p>The life cycle type for this DB instance.</p> <note> <p>By default, this value is set to <code>open-source-rds-extended-support</code>, which enrolls your DB instance into Amazon RDS Extended Support. At the end of standard support, you can avoid charges for Extended Support by setting the value to <code>open-source-rds-extended-support-disabled</code>. In this case, creating the DB instance will fail if the DB major version is past its end of standard support date.</p> </note> <p>This setting applies only to RDS for MySQL and RDS for PostgreSQL. For Amazon Aurora DB instances, the life cycle type is managed by the DB cluster.</p> <p>You can use this setting to enroll your DB instance into Amazon RDS Extended Support. With RDS Extended Support, you can run the selected major engine version on your DB instance past the end of standard support for that engine version. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html">Using Amazon RDS Extended Support</a> in the <i>Amazon RDS User Guide</i>.</p> <p>Valid Values: <code>open-source-rds-extended-support | open-source-rds-extended-support-disabled</code> </p> <p>Default: <code>open-source-rds-extended-support</code> </p>', 'CreateDBInstanceReadReplicaMessage$DBInstanceIdentifier' => '<p>The DB instance identifier of the read replica. This identifier is the unique key that identifies a DB instance. This parameter is stored as a lowercase string.</p>', 'CreateDBInstanceReadReplicaMessage$SourceDBInstanceIdentifier' => '<p>The identifier of the DB instance that will act as the source for the read replica. Each DB instance can have up to 15 read replicas, with the exception of Oracle and SQL Server, which can have up to five.</p> <p>Constraints:</p> <ul> <li> <p>Must be the identifier of an existing Db2, MariaDB, MySQL, Oracle, PostgreSQL, or SQL Server DB instance.</p> </li> <li> <p>Can\'t be specified if the <code>SourceDBClusterIdentifier</code> parameter is also specified.</p> </li> <li> <p>For the limitations of Oracle read replicas, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.limitations.html#oracle-read-replicas.limitations.versions-and-licenses">Version and licensing considerations for RDS for Oracle replicas</a> in the <i>Amazon RDS User Guide</i>.</p> </li> <li> <p>For the limitations of SQL Server read replicas, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/SQLServer.ReadReplicas.html#SQLServer.ReadReplicas.Limitations">Read replica limitations with SQL Server</a> in the <i>Amazon RDS User Guide</i>.</p> </li> <li> <p>The specified DB instance must have automatic backups enabled, that is, its backup retention period must be greater than 0.</p> </li> <li> <p>If the source DB instance is in the same Amazon Web Services Region as the read replica, specify a valid DB instance identifier.</p> </li> <li> <p>If the source DB instance is in a different Amazon Web Services Region from the read replica, specify a valid DB instance ARN. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing">Constructing an ARN for Amazon RDS</a> in the <i>Amazon RDS User Guide</i>. This doesn\'t apply to SQL Server or RDS Custom, which don\'t support cross-Region replicas.</p> </li> </ul>', 'CreateDBInstanceReadReplicaMessage$DBInstanceClass' => '<p>The compute and memory capacity of the read replica, for example db.m4.large. Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines. For the full list of DB instance classes, and availability for your engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB Instance Class</a> in the <i>Amazon RDS User Guide</i>.</p> <p>Default: Inherits the value from the source DB instance.</p>', 'CreateDBInstanceReadReplicaMessage$AvailabilityZone' => '<p>The Availability Zone (AZ) where the read replica will be created.</p> <p>Default: A random, system-chosen Availability Zone in the endpoint\'s Amazon Web Services Region.</p> <p>Example: <code>us-east-1d</code> </p>', 'CreateDBInstanceReadReplicaMessage$OptionGroupName' => '<p>The option group to associate the DB instance with. If not specified, RDS uses the option group associated with the source DB instance or cluster.</p> <note> <p>For SQL Server, you must use the option group associated with the source.</p> </note> <p>This setting doesn\'t apply to RDS Custom DB instances.</p>', 'CreateDBInstanceReadReplicaMessage$DBParameterGroupName' => '<p>The name of the DB parameter group to associate with this DB instance.</p> <p>If you don\'t specify a value for <code>DBParameterGroupName</code>, then Amazon RDS uses the <code>DBParameterGroup</code> of the source DB instance for a same Region read replica, or the default <code>DBParameterGroup</code> for the specified DB engine for a cross-Region read replica.</p> <p>Specifying a parameter group for this operation is only supported for MySQL DB instances for cross-Region read replicas and for Oracle DB instances. It isn\'t supported for MySQL DB instances for same Region read replicas or for RDS Custom.</p> <p>Constraints:</p> <ul> <li> <p>Must be 1 to 255 letters, numbers, or hyphens.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Can\'t end with a hyphen or contain two consecutive hyphens.</p> </li> </ul>', 'CreateDBInstanceReadReplicaMessage$DBSubnetGroupName' => '<p>A DB subnet group for the DB instance. The new DB instance is created in the VPC associated with the DB subnet group. If no DB subnet group is specified, then the new DB instance isn\'t created in a VPC.</p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match the name of an existing DB subnet group.</p> </li> <li> <p>The specified DB subnet group must be in the same Amazon Web Services Region in which the operation is running.</p> </li> <li> <p>All read replicas in one Amazon Web Services Region that are created from the same source DB instance must either:</p> <ul> <li> <p>Specify DB subnet groups from the same VPC. All these read replicas are created in the same VPC.</p> </li> <li> <p>Not specify a DB subnet group. All these read replicas are created outside of any VPC.</p> </li> </ul> </li> </ul> <p>Example: <code>mydbsubnetgroup</code> </p>', 'CreateDBInstanceReadReplicaMessage$StorageType' => '<p>The storage type to associate with the read replica.</p> <p>If you specify <code>io1</code>, <code>io2</code>, or <code>gp3</code>, you must also include a value for the <code>Iops</code> parameter.</p> <p>Valid Values: <code>gp2 | gp3 | io1 | io2 | standard</code> </p> <p>Default: <code>io1</code> if the <code>Iops</code> parameter is specified. Otherwise, <code>gp2</code>.</p>', 'CreateDBInstanceReadReplicaMessage$MonitoringRoleArn' => '<p>The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs. For example, <code>arn:aws:iam:123456789012:role/emaccess</code>. For information on creating a monitoring role, go to <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html#USER_Monitoring.OS.IAMRole">To create an IAM role for Amazon RDS Enhanced Monitoring</a> in the <i>Amazon RDS User Guide</i>.</p> <p>If <code>MonitoringInterval</code> is set to a value other than 0, then you must supply a <code>MonitoringRoleArn</code> value.</p> <p>This setting doesn\'t apply to RDS Custom DB instances.</p>', 'CreateDBInstanceReadReplicaMessage$KmsKeyId' => '<p>The Amazon Web Services KMS key identifier for an encrypted read replica.</p> <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p> <p>If you create an encrypted read replica in the same Amazon Web Services Region as the source DB instance or Multi-AZ DB cluster, don\'t specify a value for this parameter. A read replica in the same Amazon Web Services Region is always encrypted with the same KMS key as the source DB instance or cluster.</p> <p>If you create an encrypted read replica in a different Amazon Web Services Region, then you must specify a KMS key identifier for the destination Amazon Web Services Region. KMS keys are specific to the Amazon Web Services Region that they are created in, and you can\'t use KMS keys from one Amazon Web Services Region in another Amazon Web Services Region.</p> <p>You can\'t create an encrypted read replica from an unencrypted DB instance or Multi-AZ DB cluster.</p> <p>This setting doesn\'t apply to RDS Custom, which uses the same KMS key as the primary replica.</p>', 'CreateDBInstanceReadReplicaMessage$PreSignedUrl' => '<p>When you are creating a read replica from one Amazon Web Services GovCloud (US) Region to another or from one China Amazon Web Services Region to another, the URL that contains a Signature Version 4 signed request for the <code>CreateDBInstanceReadReplica</code> API operation in the source Amazon Web Services Region that contains the source DB instance.</p> <p>This setting applies only to Amazon Web Services GovCloud (US) Regions and China Amazon Web Services Regions. It\'s ignored in other Amazon Web Services Regions.</p> <p>This setting applies only when replicating from a source DB <i>instance</i>. Source DB clusters aren\'t supported in Amazon Web Services GovCloud (US) Regions and China Amazon Web Services Regions.</p> <p>You must specify this parameter when you create an encrypted read replica from another Amazon Web Services Region by using the Amazon RDS API. Don\'t specify <code>PreSignedUrl</code> when you are creating an encrypted read replica in the same Amazon Web Services Region.</p> <p>The presigned URL must be a valid request for the <code>CreateDBInstanceReadReplica</code> API operation that can run in the source Amazon Web Services Region that contains the encrypted source DB instance. The presigned URL request must contain the following parameter values:</p> <ul> <li> <p> <code>DestinationRegion</code> - The Amazon Web Services Region that the encrypted read replica is created in. This Amazon Web Services Region is the same one where the <code>CreateDBInstanceReadReplica</code> operation is called that contains this presigned URL.</p> <p>For example, if you create an encrypted DB instance in the us-west-1 Amazon Web Services Region, from a source DB instance in the us-east-2 Amazon Web Services Region, then you call the <code>CreateDBInstanceReadReplica</code> operation in the us-east-1 Amazon Web Services Region and provide a presigned URL that contains a call to the <code>CreateDBInstanceReadReplica</code> operation in the us-west-2 Amazon Web Services Region. For this example, the <code>DestinationRegion</code> in the presigned URL must be set to the us-east-1 Amazon Web Services Region.</p> </li> <li> <p> <code>KmsKeyId</code> - The KMS key identifier for the key to use to encrypt the read replica in the destination Amazon Web Services Region. This is the same identifier for both the <code>CreateDBInstanceReadReplica</code> operation that is called in the destination Amazon Web Services Region, and the operation contained in the presigned URL.</p> </li> <li> <p> <code>SourceDBInstanceIdentifier</code> - The DB instance identifier for the encrypted DB instance to be replicated. This identifier must be in the Amazon Resource Name (ARN) format for the source Amazon Web Services Region. For example, if you are creating an encrypted read replica from a DB instance in the us-west-2 Amazon Web Services Region, then your <code>SourceDBInstanceIdentifier</code> looks like the following example: <code>arn:aws:rds:us-west-2:123456789012:instance:mysql-instance1-20161115</code>.</p> </li> </ul> <p>To learn how to generate a Signature Version 4 signed request, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html">Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4)</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4 Signing Process</a>.</p> <note> <p>If you are using an Amazon Web Services SDK tool or the CLI, you can specify <code>SourceRegion</code> (or <code>--source-region</code> for the CLI) instead of specifying <code>PreSignedUrl</code> manually. Specifying <code>SourceRegion</code> autogenerates a presigned URL that is a valid request for the operation that can run in the source Amazon Web Services Region.</p> <p> <code>SourceRegion</code> isn\'t supported for SQL Server, because Amazon RDS for SQL Server doesn\'t support cross-Region read replicas.</p> </note> <p>This setting doesn\'t apply to RDS Custom DB instances.</p>', 'CreateDBInstanceReadReplicaMessage$PerformanceInsightsKMSKeyId' => '<p>The Amazon Web Services KMS key identifier for encryption of Performance Insights data.</p> <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p> <p>If you do not specify a value for <code>PerformanceInsightsKMSKeyId</code>, then Amazon RDS uses your default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.</p> <p>This setting doesn\'t apply to RDS Custom DB instances.</p>', 'CreateDBInstanceReadReplicaMessage$Domain' => '<p>The Active Directory directory ID to create the DB instance in. Currently, only MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB instances can be created in an Active Directory Domain.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html"> Kerberos Authentication</a> in the <i>Amazon RDS User Guide</i>.</p> <p>This setting doesn\'t apply to RDS Custom DB instances.</p>', 'CreateDBInstanceReadReplicaMessage$DomainIAMRoleName' => '<p>The name of the IAM role to use when making API calls to the Directory Service.</p> <p>This setting doesn\'t apply to RDS Custom DB instances.</p>', 'CreateDBInstanceReadReplicaMessage$DomainFqdn' => '<p>The fully qualified domain name (FQDN) of an Active Directory domain.</p> <p>Constraints:</p> <ul> <li> <p>Can\'t be longer than 64 characters.</p> </li> </ul> <p>Example: <code>mymanagedADtest.mymanagedAD.mydomain</code> </p>', 'CreateDBInstanceReadReplicaMessage$DomainOu' => '<p>The Active Directory organizational unit for your DB instance to join.</p> <p>Constraints:</p> <ul> <li> <p>Must be in the distinguished name format.</p> </li> <li> <p>Can\'t be longer than 64 characters.</p> </li> </ul> <p>Example: <code>OU=mymanagedADtestOU,DC=mymanagedADtest,DC=mymanagedAD,DC=mydomain</code> </p>', 'CreateDBInstanceReadReplicaMessage$DomainAuthSecretArn' => '<p>The ARN for the Secrets Manager secret with the credentials for the user joining the domain.</p> <p>Example: <code>arn:aws:secretsmanager:region:account-number:secret:myselfmanagedADtestsecret-123456</code> </p>', 'CreateDBInstanceReadReplicaMessage$CustomIamInstanceProfile' => '<p>The instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance. The instance profile must meet the following requirements:</p> <ul> <li> <p>The profile must exist in your account.</p> </li> <li> <p>The profile must have an IAM role that Amazon EC2 has permissions to assume.</p> </li> <li> <p>The instance profile name and the associated IAM role name must start with the prefix <code>AWSRDSCustom</code>.</p> </li> </ul> <p>For the list of permissions required for the IAM role, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-setup-orcl.html#custom-setup-orcl.iam-vpc"> Configure IAM and your VPC</a> in the <i>Amazon RDS User Guide</i>.</p> <p>This setting is required for RDS Custom DB instances.</p>', 'CreateDBInstanceReadReplicaMessage$NetworkType' => '<p>The network type of the DB instance.</p> <p>Valid Values:</p> <ul> <li> <p> <code>IPV4</code> </p> </li> <li> <p> <code>DUAL</code> </p> </li> </ul> <p>The network type is determined by the <code>DBSubnetGroup</code> specified for read replica. A <code>DBSubnetGroup</code> can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (<code>DUAL</code>).</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html"> Working with a DB instance in a VPC</a> in the <i>Amazon RDS User Guide.</i> </p>', 'CreateDBInstanceReadReplicaMessage$SourceDBClusterIdentifier' => '<p>The identifier of the Multi-AZ DB cluster that will act as the source for the read replica. Each DB cluster can have up to 15 read replicas.</p> <p>Constraints:</p> <ul> <li> <p>Must be the identifier of an existing Multi-AZ DB cluster.</p> </li> <li> <p>Can\'t be specified if the <code>SourceDBInstanceIdentifier</code> parameter is also specified.</p> </li> <li> <p>The specified DB cluster must have automatic backups enabled, that is, its backup retention period must be greater than 0.</p> </li> <li> <p>The source DB cluster must be in the same Amazon Web Services Region as the read replica. Cross-Region replication isn\'t supported.</p> </li> </ul>', 'CreateDBInstanceReadReplicaMessage$CACertificateIdentifier' => '<p>The CA certificate identifier to use for the read replica\'s server certificate.</p> <p>This setting doesn\'t apply to RDS Custom DB instances.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html">Using SSL/TLS to encrypt a connection to a DB instance</a> in the <i>Amazon RDS User Guide</i> and <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html"> Using SSL/TLS to encrypt a connection to a DB cluster</a> in the <i>Amazon Aurora User Guide</i>.</p>', 'CreateDBParameterGroupMessage$DBParameterGroupName' => '<p>The name of the DB parameter group.</p> <p>Constraints:</p> <ul> <li> <p>Must be 1 to 255 letters, numbers, or hyphens.</p> </li> <li> <p>First character must be a letter</p> </li> <li> <p>Can\'t end with a hyphen or contain two consecutive hyphens</p> </li> </ul> <note> <p>This value is stored as a lowercase string.</p> </note>', 'CreateDBParameterGroupMessage$DBParameterGroupFamily' => '<p>The DB parameter group family name. A DB parameter group can be associated with one and only one DB parameter group family, and can be applied only to a DB instance running a database engine and engine version compatible with that DB parameter group family.</p> <p>To list all of the available parameter group families for a DB engine, use the following command:</p> <p> <code>aws rds describe-db-engine-versions --query "DBEngineVersions[].DBParameterGroupFamily" --engine &lt;engine&gt;</code> </p> <p>For example, to list all of the available parameter group families for the MySQL DB engine, use the following command:</p> <p> <code>aws rds describe-db-engine-versions --query "DBEngineVersions[].DBParameterGroupFamily" --engine mysql</code> </p> <note> <p>The output contains duplicates.</p> </note> <p>The following are the valid DB engine values:</p> <ul> <li> <p> <code>aurora-mysql</code> </p> </li> <li> <p> <code>aurora-postgresql</code> </p> </li> <li> <p> <code>db2-ae</code> </p> </li> <li> <p> <code>db2-se</code> </p> </li> <li> <p> <code>mysql</code> </p> </li> <li> <p> <code>oracle-ee</code> </p> </li> <li> <p> <code>oracle-ee-cdb</code> </p> </li> <li> <p> <code>oracle-se2</code> </p> </li> <li> <p> <code>oracle-se2-cdb</code> </p> </li> <li> <p> <code>postgres</code> </p> </li> <li> <p> <code>sqlserver-ee</code> </p> </li> <li> <p> <code>sqlserver-se</code> </p> </li> <li> <p> <code>sqlserver-ex</code> </p> </li> <li> <p> <code>sqlserver-web</code> </p> </li> </ul>', 'CreateDBParameterGroupMessage$Description' => '<p>The description for the DB parameter group.</p>', 'CreateDBProxyRequest$DBProxyName' => '<p>The identifier for the proxy. This name must be unique for all proxies owned by your Amazon Web Services account in the specified Amazon Web Services Region. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can\'t end with a hyphen or contain two consecutive hyphens.</p>', 'CreateDBProxyRequest$RoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that the proxy uses to access secrets in Amazon Web Services Secrets Manager.</p>', 'CreateDBSecurityGroupMessage$DBSecurityGroupName' => '<p>The name for the DB security group. This value is stored as a lowercase string.</p> <p>Constraints:</p> <ul> <li> <p>Must be 1 to 255 letters, numbers, or hyphens.</p> </li> <li> <p>First character must be a letter</p> </li> <li> <p>Can\'t end with a hyphen or contain two consecutive hyphens</p> </li> <li> <p>Must not be "Default"</p> </li> </ul> <p>Example: <code>mysecuritygroup</code> </p>', 'CreateDBSecurityGroupMessage$DBSecurityGroupDescription' => '<p>The description for the DB security group.</p>', 'CreateDBShardGroupMessage$DBShardGroupIdentifier' => '<p>The name of the DB shard group.</p>', 'CreateDBShardGroupMessage$DBClusterIdentifier' => '<p>The name of the primary DB cluster for the DB shard group.</p>', 'CreateDBSnapshotMessage$DBSnapshotIdentifier' => '<p>The identifier for the DB snapshot.</p> <p>Constraints:</p> <ul> <li> <p>Can\'t be null, empty, or blank</p> </li> <li> <p>Must contain from 1 to 255 letters, numbers, or hyphens</p> </li> <li> <p>First character must be a letter</p> </li> <li> <p>Can\'t end with a hyphen or contain two consecutive hyphens</p> </li> </ul> <p>Example: <code>my-snapshot-id</code> </p>', 'CreateDBSnapshotMessage$DBInstanceIdentifier' => '<p>The identifier of the DB instance that you want to create the snapshot of.</p> <p>Constraints:</p> <ul> <li> <p>Must match the identifier of an existing DBInstance.</p> </li> </ul>', 'CreateDBSubnetGroupMessage$DBSubnetGroupName' => '<p>The name for the DB subnet group. This value is stored as a lowercase string.</p> <p>Constraints:</p> <ul> <li> <p>Must contain no more than 255 letters, numbers, periods, underscores, spaces, or hyphens.</p> </li> <li> <p>Must not be default.</p> </li> <li> <p>First character must be a letter.</p> </li> </ul> <p>Example: <code>mydbsubnetgroup</code> </p>', 'CreateDBSubnetGroupMessage$DBSubnetGroupDescription' => '<p>The description for the DB subnet group.</p>', 'CreateEventSubscriptionMessage$SubscriptionName' => '<p>The name of the subscription.</p> <p>Constraints: The name must be less than 255 characters.</p>', 'CreateEventSubscriptionMessage$SnsTopicArn' => '<p>The Amazon Resource Name (ARN) of the SNS topic created for event notification. SNS automatically creates the ARN when you create a topic and subscribe to it.</p> <note> <p>RDS doesn\'t support FIFO (first in, first out) topics. For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-fifo-topics.html">Message ordering and deduplication (FIFO topics)</a> in the <i>Amazon Simple Notification Service Developer Guide</i>.</p> </note>', 'CreateEventSubscriptionMessage$SourceType' => '<p>The type of source that is generating the events. For example, if you want to be notified of events generated by a DB instance, you set this parameter to <code>db-instance</code>. For RDS Proxy events, specify <code>db-proxy</code>. If this value isn\'t specified, all events are returned.</p> <p>Valid Values:<code> db-instance | db-cluster | db-parameter-group | db-security-group | db-snapshot | db-cluster-snapshot | db-proxy | zero-etl | custom-engine-version | blue-green-deployment </code> </p>', 'CreateGlobalClusterMessage$GlobalClusterIdentifier' => '<p>The cluster identifier for this global database cluster. This parameter is stored as a lowercase string.</p>', 'CreateGlobalClusterMessage$SourceDBClusterIdentifier' => '<p>The Amazon Resource Name (ARN) to use as the primary cluster of the global database.</p> <p>If you provide a value for this parameter, don\'t specify values for the following settings because Amazon Aurora uses the values from the specified source DB cluster:</p> <ul> <li> <p> <code>DatabaseName</code> </p> </li> <li> <p> <code>Engine</code> </p> </li> <li> <p> <code>EngineVersion</code> </p> </li> <li> <p> <code>StorageEncrypted</code> </p> </li> </ul>', 'CreateGlobalClusterMessage$Engine' => '<p>The database engine to use for this global database cluster.</p> <p>Valid Values: <code>aurora-mysql | aurora-postgresql</code> </p> <p>Constraints:</p> <ul> <li> <p>Can\'t be specified if <code>SourceDBClusterIdentifier</code> is specified. In this case, Amazon Aurora uses the engine of the source DB cluster.</p> </li> </ul>', 'CreateGlobalClusterMessage$EngineVersion' => '<p>The engine version to use for this global database cluster.</p> <p>Constraints:</p> <ul> <li> <p>Can\'t be specified if <code>SourceDBClusterIdentifier</code> is specified. In this case, Amazon Aurora uses the engine version of the source DB cluster.</p> </li> </ul>', 'CreateGlobalClusterMessage$EngineLifecycleSupport' => '<p>The life cycle type for this global database cluster.</p> <note> <p>By default, this value is set to <code>open-source-rds-extended-support</code>, which enrolls your global cluster into Amazon RDS Extended Support. At the end of standard support, you can avoid charges for Extended Support by setting the value to <code>open-source-rds-extended-support-disabled</code>. In this case, creating the global cluster will fail if the DB major version is past its end of standard support date.</p> </note> <p>This setting only applies to Aurora PostgreSQL-based global databases.</p> <p>You can use this setting to enroll your global cluster into Amazon RDS Extended Support. With RDS Extended Support, you can run the selected major engine version on your global cluster past the end of standard support for that engine version. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/extended-support.html">Using Amazon RDS Extended Support</a> in the <i>Amazon Aurora User Guide</i>.</p> <p>Valid Values: <code>open-source-rds-extended-support | open-source-rds-extended-support-disabled</code> </p> <p>Default: <code>open-source-rds-extended-support</code> </p>', 'CreateGlobalClusterMessage$DatabaseName' => '<p>The name for your database of up to 64 alphanumeric characters. If you don\'t specify a name, Amazon Aurora doesn\'t create a database in the global database cluster.</p> <p>Constraints:</p> <ul> <li> <p>Can\'t be specified if <code>SourceDBClusterIdentifier</code> is specified. In this case, Amazon Aurora uses the database name from the source DB cluster.</p> </li> </ul>', 'CreateIntegrationMessage$KMSKeyId' => '<p>The Amazon Web Services Key Management System (Amazon Web Services KMS) key identifier for the key to use to encrypt the integration. If you don\'t specify an encryption key, RDS uses a default Amazon Web Services owned key. </p>', 'CreateOptionGroupMessage$OptionGroupName' => '<p>Specifies the name of the option group to be created.</p> <p>Constraints:</p> <ul> <li> <p>Must be 1 to 255 letters, numbers, or hyphens</p> </li> <li> <p>First character must be a letter</p> </li> <li> <p>Can\'t end with a hyphen or contain two consecutive hyphens</p> </li> </ul> <p>Example: <code>myoptiongroup</code> </p>', 'CreateOptionGroupMessage$EngineName' => '<p>The name of the engine to associate this option group with.</p> <p>Valid Values:</p> <ul> <li> <p> <code>db2-ae</code> </p> </li> <li> <p> <code>db2-se</code> </p> </li> <li> <p> <code>mariadb</code> </p> </li> <li> <p> <code>mysql</code> </p> </li> <li> <p> <code>oracle-ee</code> </p> </li> <li> <p> <code>oracle-ee-cdb</code> </p> </li> <li> <p> <code>oracle-se2</code> </p> </li> <li> <p> <code>oracle-se2-cdb</code> </p> </li> <li> <p> <code>postgres</code> </p> </li> <li> <p> <code>sqlserver-ee</code> </p> </li> <li> <p> <code>sqlserver-se</code> </p> </li> <li> <p> <code>sqlserver-ex</code> </p> </li> <li> <p> <code>sqlserver-web</code> </p> </li> </ul>', 'CreateOptionGroupMessage$MajorEngineVersion' => '<p>Specifies the major version of the engine that this option group should be associated with.</p>', 'CreateOptionGroupMessage$OptionGroupDescription' => '<p>The description of the option group.</p>', 'CreateTenantDatabaseMessage$DBInstanceIdentifier' => '<p>The user-supplied DB instance identifier. RDS creates your tenant database in this DB instance. This parameter isn\'t case-sensitive.</p>', 'CreateTenantDatabaseMessage$TenantDBName' => '<p>The user-supplied name of the tenant database that you want to create in your DB instance. This parameter has the same constraints as <code>DBName</code> in <code>CreateDBInstance</code>.</p>', 'CreateTenantDatabaseMessage$MasterUsername' => '<p>The name for the master user account in your tenant database. RDS creates this user account in the tenant database and grants privileges to the master user. This parameter is case-sensitive.</p> <p>Constraints:</p> <ul> <li> <p>Must be 1 to 16 letters, numbers, or underscores.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Can\'t be a reserved word for the chosen database engine.</p> </li> </ul>', 'CreateTenantDatabaseMessage$CharacterSetName' => '<p>The character set for your tenant database. If you don\'t specify a value, the character set name defaults to <code>AL32UTF8</code>.</p>', 'CreateTenantDatabaseMessage$NcharCharacterSetName' => '<p>The <code>NCHAR</code> value for the tenant database.</p>', 'CustomDBEngineVersionAMI$ImageId' => '<p>A value that indicates the ID of the AMI.</p>', 'CustomDBEngineVersionAMI$Status' => '<p>A value that indicates the status of a custom engine version (CEV).</p>', 'DBCluster$CharacterSetName' => '<p>If present, specifies the name of the character set that this cluster is associated with.</p>', 'DBCluster$DatabaseName' => '<p>The name of the initial database that was specified for the DB cluster when it was created, if one was provided. This same name is returned for the life of the DB cluster.</p>', 'DBCluster$DBClusterIdentifier' => '<p>The user-supplied identifier for the DB cluster. This identifier is the unique key that identifies a DB cluster.</p>', 'DBCluster$DBClusterParameterGroup' => '<p>The name of the DB cluster parameter group for the DB cluster.</p>', 'DBCluster$DBSubnetGroup' => '<p>Information about the subnet group associated with the DB cluster, including the name, description, and subnets in the subnet group.</p>', 'DBCluster$Status' => '<p>The current state of this DB cluster.</p>', 'DBCluster$PercentProgress' => '<p>The progress of the operation as a percentage.</p>', 'DBCluster$Endpoint' => '<p>The connection endpoint for the primary instance of the DB cluster.</p>', 'DBCluster$ReaderEndpoint' => '<p>The reader endpoint for the DB cluster. The reader endpoint for a DB cluster load-balances connections across the Aurora Replicas that are available in a DB cluster. As clients request new connections to the reader endpoint, Aurora distributes the connection requests among the Aurora Replicas in the DB cluster. This functionality can help balance your read workload across multiple Aurora Replicas in your DB cluster.</p> <p>If a failover occurs, and the Aurora Replica that you are connected to is promoted to be the primary instance, your connection is dropped. To continue sending your read workload to other Aurora Replicas in the cluster, you can then reconnect to the reader endpoint.</p>', 'DBCluster$Engine' => '<p>The database engine used for this DB cluster.</p>', 'DBCluster$EngineVersion' => '<p>The version of the database engine.</p>', 'DBCluster$MasterUsername' => '<p>The master username for the DB cluster.</p>', 'DBCluster$PreferredBackupWindow' => '<p>The daily time range during which automated backups are created if automated backups are enabled, as determined by the <code>BackupRetentionPeriod</code>.</p>', 'DBCluster$PreferredMaintenanceWindow' => '<p>The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).</p>', 'DBCluster$ReplicationSourceIdentifier' => '<p>The identifier of the source DB cluster if this DB cluster is a read replica.</p>', 'DBCluster$HostedZoneId' => '<p>The ID that Amazon Route 53 assigns when you create a hosted zone.</p>', 'DBCluster$KmsKeyId' => '<p>If <code>StorageEncrypted</code> is enabled, the Amazon Web Services KMS key identifier for the encrypted DB cluster.</p> <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>', 'DBCluster$DbClusterResourceId' => '<p>The Amazon Web Services Region-unique, immutable identifier for the DB cluster. This identifier is found in Amazon Web Services CloudTrail log entries whenever the KMS key for the DB cluster is accessed.</p>', 'DBCluster$DBClusterArn' => '<p>The Amazon Resource Name (ARN) for the DB cluster.</p>', 'DBCluster$CloneGroupId' => '<p>The ID of the clone group with which the DB cluster is associated.</p>', 'DBCluster$EngineMode' => '<p>The DB engine mode of the DB cluster, either <code>provisioned</code> or <code>serverless</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBCluster.html"> CreateDBCluster</a>.</p>', 'DBCluster$ActivityStreamKmsKeyId' => '<p>The Amazon Web Services KMS key identifier used for encrypting messages in the database activity stream.</p> <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>', 'DBCluster$ActivityStreamKinesisStreamName' => '<p>The name of the Amazon Kinesis data stream used for the database activity stream.</p>', 'DBCluster$DBClusterInstanceClass' => '<p>The name of the compute and memory capacity class of the DB instance.</p> <p>This setting is only for non-Aurora Multi-AZ DB clusters.</p>', 'DBCluster$StorageType' => '<p>The storage type associated with the DB cluster.</p>', 'DBCluster$MonitoringRoleArn' => '<p>The ARN for the IAM role that permits RDS to send Enhanced Monitoring metrics to Amazon CloudWatch Logs.</p> <p>This setting is only for non-Aurora Multi-AZ DB clusters.</p>', 'DBCluster$PerformanceInsightsKMSKeyId' => '<p>The Amazon Web Services KMS key identifier for encryption of Performance Insights data.</p> <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p> <p>This setting is only for non-Aurora Multi-AZ DB clusters.</p>', 'DBCluster$NetworkType' => '<p>The network type of the DB instance.</p> <p>The network type is determined by the <code>DBSubnetGroup</code> specified for the DB cluster. A <code>DBSubnetGroup</code> can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (<code>DUAL</code>).</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html"> Working with a DB instance in a VPC</a> in the <i>Amazon Aurora User Guide.</i> </p> <p>This setting is only for Aurora DB clusters.</p> <p>Valid Values: <code>IPV4 | DUAL</code> </p>', 'DBCluster$DBSystemId' => '<p>Reserved for future use.</p>', 'DBCluster$AwsBackupRecoveryPointArn' => '<p>The Amazon Resource Name (ARN) of the recovery point in Amazon Web Services Backup.</p>', 'DBCluster$EngineLifecycleSupport' => '<p>The life cycle type for the DB cluster.</p> <p>For more information, see CreateDBCluster.</p>', 'DBClusterAutomatedBackup$Engine' => '<p>The name of the database engine for this automated backup.</p>', 'DBClusterAutomatedBackup$VpcId' => '<p>The VPC ID associated with the DB cluster.</p>', 'DBClusterAutomatedBackup$DBClusterAutomatedBackupsArn' => '<p>The Amazon Resource Name (ARN) for the automated backups.</p>', 'DBClusterAutomatedBackup$DBClusterIdentifier' => '<p>The identifier for the source DB cluster, which can\'t be changed and which is unique to an Amazon Web Services Region.</p>', 'DBClusterAutomatedBackup$MasterUsername' => '<p>The master user name of the automated backup.</p>', 'DBClusterAutomatedBackup$DbClusterResourceId' => '<p>The resource ID for the source DB cluster, which can\'t be changed and which is unique to an Amazon Web Services Region.</p>', 'DBClusterAutomatedBackup$Region' => '<p>The Amazon Web Services Region associated with the automated backup.</p>', 'DBClusterAutomatedBackup$LicenseModel' => '<p>The license model information for this DB cluster automated backup.</p>', 'DBClusterAutomatedBackup$Status' => '<p>A list of status information for an automated backup:</p> <ul> <li> <p> <code>retained</code> - Automated backups for deleted clusters.</p> </li> </ul>', 'DBClusterAutomatedBackup$EngineVersion' => '<p>The version of the database engine for the automated backup.</p>', 'DBClusterAutomatedBackup$DBClusterArn' => '<p>The Amazon Resource Name (ARN) for the source DB cluster.</p>', 'DBClusterAutomatedBackup$EngineMode' => '<p>The engine mode of the database engine for the automated backup.</p>', 'DBClusterAutomatedBackup$KmsKeyId' => '<p>The Amazon Web Services KMS key ID for an automated backup.</p> <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>', 'DBClusterAutomatedBackup$StorageType' => '<p>The storage type associated with the DB cluster.</p> <p>This setting is only for non-Aurora Multi-AZ DB clusters.</p>', 'DBClusterAutomatedBackup$AwsBackupRecoveryPointArn' => '<p>The Amazon Resource Name (ARN) of the recovery point in Amazon Web Services Backup.</p>', 'DBClusterAutomatedBackupMessage$Marker' => '<p>The pagination token provided in the previous request. If this parameter is specified the response includes only records beyond the marker, up to <code>MaxRecords</code>.</p>', 'DBClusterBacktrack$DBClusterIdentifier' => '<p>Contains a user-supplied DB cluster identifier. This identifier is the unique key that identifies a DB cluster.</p>', 'DBClusterBacktrack$BacktrackIdentifier' => '<p>Contains the backtrack identifier.</p>', 'DBClusterBacktrack$Status' => '<p>The status of the backtrack. This property returns one of the following values:</p> <ul> <li> <p> <code>applying</code> - The backtrack is currently being applied to or rolled back from the DB cluster.</p> </li> <li> <p> <code>completed</code> - The backtrack has successfully been applied to or rolled back from the DB cluster.</p> </li> <li> <p> <code>failed</code> - An error occurred while the backtrack was applied to or rolled back from the DB cluster.</p> </li> <li> <p> <code>pending</code> - The backtrack is currently pending application to or rollback from the DB cluster.</p> </li> </ul>', 'DBClusterBacktrackMessage$Marker' => '<p>A pagination token that can be used in a later <code>DescribeDBClusterBacktracks</code> request.</p>', 'DBClusterCapacityInfo$DBClusterIdentifier' => '<p>A user-supplied DB cluster identifier. This identifier is the unique key that identifies a DB cluster.</p>', 'DBClusterCapacityInfo$TimeoutAction' => '<p>The timeout action of a call to <code>ModifyCurrentDBClusterCapacity</code>, either <code>ForceApplyCapacityChange</code> or <code>RollbackCapacityChange</code>.</p>', 'DBClusterEndpoint$DBClusterEndpointIdentifier' => '<p>The identifier associated with the endpoint. This parameter is stored as a lowercase string.</p>', 'DBClusterEndpoint$DBClusterIdentifier' => '<p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is stored as a lowercase string.</p>', 'DBClusterEndpoint$DBClusterEndpointResourceIdentifier' => '<p>A unique system-generated identifier for an endpoint. It remains the same for the whole life of the endpoint.</p>', 'DBClusterEndpoint$Endpoint' => '<p>The DNS address of the endpoint.</p>', 'DBClusterEndpoint$Status' => '<p>The current status of the endpoint. One of: <code>creating</code>, <code>available</code>, <code>deleting</code>, <code>inactive</code>, <code>modifying</code>. The <code>inactive</code> state applies to an endpoint that can\'t be used for a certain kind of cluster, such as a <code>writer</code> endpoint for a read-only secondary cluster in a global database.</p>', 'DBClusterEndpoint$EndpointType' => '<p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>CUSTOM</code>.</p>', 'DBClusterEndpoint$CustomEndpointType' => '<p>The type associated with a custom endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.</p>', 'DBClusterEndpoint$DBClusterEndpointArn' => '<p>The Amazon Resource Name (ARN) for the endpoint.</p>', 'DBClusterEndpointMessage$Marker' => '<p>An optional pagination token provided by a previous <code>DescribeDBClusterEndpoints</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DBClusterMember$DBInstanceIdentifier' => '<p>Specifies the instance identifier for this member of the DB cluster.</p>', 'DBClusterMember$DBClusterParameterGroupStatus' => '<p>Specifies the status of the DB cluster parameter group for this member of the DB cluster.</p>', 'DBClusterMessage$Marker' => '<p>A pagination token that can be used in a later <code>DescribeDBClusters</code> request.</p>', 'DBClusterOptionGroupStatus$DBClusterOptionGroupName' => '<p>Specifies the name of the DB cluster option group.</p>', 'DBClusterOptionGroupStatus$Status' => '<p>Specifies the status of the DB cluster option group.</p>', 'DBClusterParameterGroup$DBClusterParameterGroupName' => '<p>The name of the DB cluster parameter group.</p>', 'DBClusterParameterGroup$DBParameterGroupFamily' => '<p>The name of the DB parameter group family that this DB cluster parameter group is compatible with.</p>', 'DBClusterParameterGroup$Description' => '<p>Provides the customer-specified description for this DB cluster parameter group.</p>', 'DBClusterParameterGroup$DBClusterParameterGroupArn' => '<p>The Amazon Resource Name (ARN) for the DB cluster parameter group.</p>', 'DBClusterParameterGroupDetails$Marker' => '<p>An optional pagination token provided by a previous <code>DescribeDBClusterParameters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DBClusterParameterGroupNameMessage$DBClusterParameterGroupName' => '<p>The name of the DB cluster parameter group.</p> <p>Constraints:</p> <ul> <li> <p>Must be 1 to 255 letters or numbers.</p> </li> <li> <p>First character must be a letter</p> </li> <li> <p>Can\'t end with a hyphen or contain two consecutive hyphens</p> </li> </ul> <note> <p>This value is stored as a lowercase string.</p> </note>', 'DBClusterParameterGroupsMessage$Marker' => '<p>An optional pagination token provided by a previous <code>DescribeDBClusterParameterGroups</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DBClusterRole$RoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that is associated with the DB cluster.</p>', 'DBClusterRole$Status' => '<p>Describes the state of association between the IAM role and the DB cluster. The Status property returns one of the following values:</p> <ul> <li> <p> <code>ACTIVE</code> - the IAM role ARN is associated with the DB cluster and can be used to access other Amazon Web Services on your behalf.</p> </li> <li> <p> <code>PENDING</code> - the IAM role ARN is being associated with the DB cluster.</p> </li> <li> <p> <code>INVALID</code> - the IAM role ARN is associated with the DB cluster, but the DB cluster is unable to assume the IAM role in order to access other Amazon Web Services on your behalf.</p> </li> </ul>', 'DBClusterRole$FeatureName' => '<p>The name of the feature associated with the Amazon Web Services Identity and Access Management (IAM) role. For information about supported feature names, see <a>DBEngineVersion</a>.</p>', 'DBClusterSnapshot$DBClusterSnapshotIdentifier' => '<p>The identifier for the DB cluster snapshot.</p>', 'DBClusterSnapshot$DBClusterIdentifier' => '<p>The DB cluster identifier of the DB cluster that this DB cluster snapshot was created from.</p>', 'DBClusterSnapshot$Engine' => '<p>The name of the database engine for this DB cluster snapshot.</p>', 'DBClusterSnapshot$EngineMode' => '<p>The engine mode of the database engine for this DB cluster snapshot.</p>', 'DBClusterSnapshot$Status' => '<p>The status of this DB cluster snapshot. Valid statuses are the following:</p> <ul> <li> <p> <code>available</code> </p> </li> <li> <p> <code>copying</code> </p> </li> <li> <p> <code>creating</code> </p> </li> </ul>', 'DBClusterSnapshot$VpcId' => '<p>The VPC ID associated with the DB cluster snapshot.</p>', 'DBClusterSnapshot$MasterUsername' => '<p>The master username for this DB cluster snapshot.</p>', 'DBClusterSnapshot$EngineVersion' => '<p>The version of the database engine for this DB cluster snapshot.</p>', 'DBClusterSnapshot$LicenseModel' => '<p>The license model information for this DB cluster snapshot.</p>', 'DBClusterSnapshot$SnapshotType' => '<p>The type of the DB cluster snapshot.</p>', 'DBClusterSnapshot$KmsKeyId' => '<p>If <code>StorageEncrypted</code> is true, the Amazon Web Services KMS key identifier for the encrypted DB cluster snapshot.</p> <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>', 'DBClusterSnapshot$DBClusterSnapshotArn' => '<p>The Amazon Resource Name (ARN) for the DB cluster snapshot.</p>', 'DBClusterSnapshot$SourceDBClusterSnapshotArn' => '<p>If the DB cluster snapshot was copied from a source DB cluster snapshot, the Amazon Resource Name (ARN) for the source DB cluster snapshot, otherwise, a null value.</p>', 'DBClusterSnapshot$DBSystemId' => '<p>Reserved for future use.</p>', 'DBClusterSnapshot$StorageType' => '<p>The storage type associated with the DB cluster snapshot.</p> <p>This setting is only for Aurora DB clusters.</p>', 'DBClusterSnapshot$DbClusterResourceId' => '<p>The resource ID of the DB cluster that this DB cluster snapshot was created from.</p>', 'DBClusterSnapshotAttribute$AttributeName' => '<p>The name of the manual DB cluster snapshot attribute.</p> <p>The attribute named <code>restore</code> refers to the list of Amazon Web Services accounts that have permission to copy or restore the manual DB cluster snapshot. For more information, see the <code>ModifyDBClusterSnapshotAttribute</code> API action.</p>', 'DBClusterSnapshotAttributesResult$DBClusterSnapshotIdentifier' => '<p>The identifier of the manual DB cluster snapshot that the attributes apply to.</p>', 'DBClusterSnapshotMessage$Marker' => '<p>An optional pagination token provided by a previous <code>DescribeDBClusterSnapshots</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DBClusterStatusInfo$StatusType' => '<p>Reserved for future use.</p>', 'DBClusterStatusInfo$Status' => '<p>Reserved for future use.</p>', 'DBClusterStatusInfo$Message' => '<p>Reserved for future use.</p>', 'DBEngineVersion$Engine' => '<p>The name of the database engine.</p>', 'DBEngineVersion$EngineVersion' => '<p>The version number of the database engine.</p>', 'DBEngineVersion$DBParameterGroupFamily' => '<p>The name of the DB parameter group family for the database engine.</p>', 'DBEngineVersion$DBEngineDescription' => '<p>The description of the database engine.</p>', 'DBEngineVersion$DBEngineVersionDescription' => '<p>The description of the database engine version.</p>', 'DBEngineVersion$DBEngineMediaType' => '<p>A value that indicates the source media provider of the AMI based on the usage operation. Applicable for RDS Custom for SQL Server.</p>', 'DBEngineVersion$Status' => '<p>The status of the DB engine version, either <code>available</code> or <code>deprecated</code>.</p>', 'DBEngineVersion$MajorEngineVersion' => '<p>The major engine version of the CEV.</p>', 'DBEngineVersion$DatabaseInstallationFilesS3BucketName' => '<p>The name of the Amazon S3 bucket that contains your database installation files.</p>', 'DBEngineVersion$DatabaseInstallationFilesS3Prefix' => '<p>The Amazon S3 directory that contains the database installation files. If not specified, then no prefix is assumed.</p>', 'DBEngineVersion$DBEngineVersionArn' => '<p>The ARN of the custom engine version.</p>', 'DBEngineVersion$KMSKeyId' => '<p>The Amazon Web Services KMS key identifier for an encrypted CEV. This parameter is required for RDS Custom, but optional for Amazon RDS.</p>', 'DBEngineVersionMessage$Marker' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DBInstance$DBInstanceIdentifier' => '<p>The user-supplied database identifier. This identifier is the unique key that identifies a DB instance.</p>', 'DBInstance$DBInstanceClass' => '<p>The name of the compute and memory capacity class of the DB instance.</p>', 'DBInstance$Engine' => '<p>The database engine used for this DB instance.</p>', 'DBInstance$DBInstanceStatus' => '<p>The current state of this database.</p> <p>For information about DB instance statuses, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/accessing-monitoring.html#Overview.DBInstance.Status">Viewing DB instance status</a> in the <i>Amazon RDS User Guide.</i> </p>', 'DBInstance$MasterUsername' => '<p>The master username for the DB instance.</p>', 'DBInstance$DBName' => '<p>The initial database name that you provided (if required) when you created the DB instance. This name is returned for the life of your DB instance. For an RDS for Oracle CDB instance, the name identifies the PDB rather than the CDB.</p>', 'DBInstance$PreferredBackupWindow' => '<p>The daily time range during which automated backups are created if automated backups are enabled, as determined by the <code>BackupRetentionPeriod</code>.</p>', 'DBInstance$AvailabilityZone' => '<p>The name of the Availability Zone where the DB instance is located.</p>', 'DBInstance$PreferredMaintenanceWindow' => '<p>The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).</p>', 'DBInstance$EngineVersion' => '<p>The version of the database engine.</p>', 'DBInstance$ReadReplicaSourceDBInstanceIdentifier' => '<p>The identifier of the source DB instance if this DB instance is a read replica.</p>', 'DBInstance$LicenseModel' => '<p>The license model information for this DB instance. This setting doesn\'t apply to Amazon Aurora or RDS Custom DB instances.</p>', 'DBInstance$CharacterSetName' => '<p>If present, specifies the name of the character set that this instance is associated with.</p>', 'DBInstance$NcharCharacterSetName' => '<p>The name of the NCHAR character set for the Oracle DB instance. This character set specifies the Unicode encoding for data stored in table columns of type NCHAR, NCLOB, or NVARCHAR2.</p>', 'DBInstance$SecondaryAvailabilityZone' => '<p>If present, specifies the name of the secondary Availability Zone for a DB instance with multi-AZ support.</p>', 'DBInstance$StorageType' => '<p>The storage type associated with the DB instance.</p>', 'DBInstance$TdeCredentialArn' => '<p>The ARN from the key store with which the instance is associated for TDE encryption.</p>', 'DBInstance$DBClusterIdentifier' => '<p>If the DB instance is a member of a DB cluster, indicates the name of the DB cluster that the DB instance is a member of.</p>', 'DBInstance$KmsKeyId' => '<p>If <code>StorageEncrypted</code> is enabled, the Amazon Web Services KMS key identifier for the encrypted DB instance.</p> <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>', 'DBInstance$DbiResourceId' => '<p>The Amazon Web Services Region-unique, immutable identifier for the DB instance. This identifier is found in Amazon Web Services CloudTrail log entries whenever the Amazon Web Services KMS key for the DB instance is accessed.</p>', 'DBInstance$CACertificateIdentifier' => '<p>The identifier of the CA certificate for this DB instance.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html">Using SSL/TLS to encrypt a connection to a DB instance</a> in the <i>Amazon RDS User Guide</i> and <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html"> Using SSL/TLS to encrypt a connection to a DB cluster</a> in the <i>Amazon Aurora User Guide</i>.</p>', 'DBInstance$EnhancedMonitoringResourceArn' => '<p>The Amazon Resource Name (ARN) of the Amazon CloudWatch Logs log stream that receives the Enhanced Monitoring metrics data for the DB instance.</p>', 'DBInstance$MonitoringRoleArn' => '<p>The ARN for the IAM role that permits RDS to send Enhanced Monitoring metrics to Amazon CloudWatch Logs.</p>', 'DBInstance$DBInstanceArn' => '<p>The Amazon Resource Name (ARN) for the DB instance.</p>', 'DBInstance$Timezone' => '<p>The time zone of the DB instance. In most cases, the <code>Timezone</code> element is empty. <code>Timezone</code> content appears only for RDS for Db2 and RDS for SQL Server DB instances that were created with a time zone specified.</p>', 'DBInstance$PerformanceInsightsKMSKeyId' => '<p>The Amazon Web Services KMS key identifier for encryption of Performance Insights data.</p> <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>', 'DBInstance$AwsBackupRecoveryPointArn' => '<p>The Amazon Resource Name (ARN) of the recovery point in Amazon Web Services Backup.</p>', 'DBInstance$ActivityStreamKmsKeyId' => '<p>The Amazon Web Services KMS key identifier used for encrypting messages in the database activity stream. The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>', 'DBInstance$ActivityStreamKinesisStreamName' => '<p>The name of the Amazon Kinesis data stream used for the database activity stream.</p>', 'DBInstance$CustomIamInstanceProfile' => '<p>The instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance. The instance profile must meet the following requirements:</p> <ul> <li> <p>The profile must exist in your account.</p> </li> <li> <p>The profile must have an IAM role that Amazon EC2 has permissions to assume.</p> </li> <li> <p>The instance profile name and the associated IAM role name must start with the prefix <code>AWSRDSCustom</code>.</p> </li> </ul> <p>For the list of permissions required for the IAM role, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-setup-orcl.html#custom-setup-orcl.iam-vpc"> Configure IAM and your VPC</a> in the <i>Amazon RDS User Guide</i>.</p>', 'DBInstance$BackupTarget' => '<p>The location where automated backups and manual snapshots are stored: Amazon Web Services Outposts or the Amazon Web Services Region.</p>', 'DBInstance$NetworkType' => '<p>The network type of the DB instance.</p> <p>The network type is determined by the <code>DBSubnetGroup</code> specified for the DB instance. A <code>DBSubnetGroup</code> can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (<code>DUAL</code>).</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html"> Working with a DB instance in a VPC</a> in the <i>Amazon RDS User Guide</i> and <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html"> Working with a DB instance in a VPC</a> in the <i>Amazon Aurora User Guide.</i> </p> <p>Valid Values: <code>IPV4 | DUAL</code> </p>', 'DBInstance$DBSystemId' => '<p>The Oracle system ID (Oracle SID) for a container database (CDB). The Oracle SID is also the name of the CDB. This setting is only valid for RDS Custom DB instances.</p>', 'DBInstance$ReadReplicaSourceDBClusterIdentifier' => '<p>The identifier of the source DB cluster if this DB instance is a read replica.</p>', 'DBInstance$PercentProgress' => '<p>The progress of the storage optimization operation as a percentage.</p>', 'DBInstance$EngineLifecycleSupport' => '<p>The life cycle type for the DB instance.</p> <p>For more information, see CreateDBInstance.</p>', 'DBInstanceAutomatedBackup$DBInstanceArn' => '<p>The Amazon Resource Name (ARN) for the automated backups.</p>', 'DBInstanceAutomatedBackup$DbiResourceId' => '<p>The resource ID for the source DB instance, which can\'t be changed and which is unique to an Amazon Web Services Region.</p>', 'DBInstanceAutomatedBackup$Region' => '<p>The Amazon Web Services Region associated with the automated backup.</p>', 'DBInstanceAutomatedBackup$DBInstanceIdentifier' => '<p>The identifier for the source DB instance, which can\'t be changed and which is unique to an Amazon Web Services Region.</p>', 'DBInstanceAutomatedBackup$Status' => '<p>A list of status information for an automated backup:</p> <ul> <li> <p> <code>active</code> - Automated backups for current instances.</p> </li> <li> <p> <code>retained</code> - Automated backups for deleted instances.</p> </li> <li> <p> <code>creating</code> - Automated backups that are waiting for the first automated snapshot to be available.</p> </li> </ul>', 'DBInstanceAutomatedBackup$AvailabilityZone' => '<p>The Availability Zone that the automated backup was created in. For information on Amazon Web Services Regions and Availability Zones, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html">Regions and Availability Zones</a>.</p>', 'DBInstanceAutomatedBackup$VpcId' => '<p>The VPC ID associated with the DB instance.</p>', 'DBInstanceAutomatedBackup$MasterUsername' => '<p>The master user name of an automated backup.</p>', 'DBInstanceAutomatedBackup$Engine' => '<p>The name of the database engine for this automated backup.</p>', 'DBInstanceAutomatedBackup$EngineVersion' => '<p>The version of the database engine for the automated backup.</p>', 'DBInstanceAutomatedBackup$LicenseModel' => '<p>The license model information for the automated backup.</p>', 'DBInstanceAutomatedBackup$OptionGroupName' => '<p>The option group the automated backup is associated with. If omitted, the default option group for the engine specified is used.</p>', 'DBInstanceAutomatedBackup$TdeCredentialArn' => '<p>The ARN from the key store with which the automated backup is associated for TDE encryption.</p>', 'DBInstanceAutomatedBackup$StorageType' => '<p>The storage type associated with the automated backup.</p>', 'DBInstanceAutomatedBackup$KmsKeyId' => '<p>The Amazon Web Services KMS key ID for an automated backup.</p> <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>', 'DBInstanceAutomatedBackup$Timezone' => '<p>The time zone of the automated backup. In most cases, the <code>Timezone</code> element is empty. <code>Timezone</code> content appears only for Microsoft SQL Server DB instances that were created with a time zone specified.</p>', 'DBInstanceAutomatedBackup$DBInstanceAutomatedBackupsArn' => '<p>The Amazon Resource Name (ARN) for the replicated automated backups.</p>', 'DBInstanceAutomatedBackup$BackupTarget' => '<p>The location where automated backups are stored: Amazon Web Services Outposts or the Amazon Web Services Region.</p>', 'DBInstanceAutomatedBackup$AwsBackupRecoveryPointArn' => '<p>The Amazon Resource Name (ARN) of the recovery point in Amazon Web Services Backup.</p>', 'DBInstanceAutomatedBackupMessage$Marker' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DBInstanceAutomatedBackupsReplication$DBInstanceAutomatedBackupsArn' => '<p>The Amazon Resource Name (ARN) of the replicated automated backups.</p>', 'DBInstanceMessage$Marker' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> .</p>', 'DBInstanceRole$RoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that is associated with the DB instance.</p>', 'DBInstanceRole$FeatureName' => '<p>The name of the feature associated with the Amazon Web Services Identity and Access Management (IAM) role. For information about supported feature names, see <code>DBEngineVersion</code>.</p>', 'DBInstanceRole$Status' => '<p>Information about the state of association between the IAM role and the DB instance. The Status property returns one of the following values:</p> <ul> <li> <p> <code>ACTIVE</code> - the IAM role ARN is associated with the DB instance and can be used to access other Amazon Web Services services on your behalf.</p> </li> <li> <p> <code>PENDING</code> - the IAM role ARN is being associated with the DB instance.</p> </li> <li> <p> <code>INVALID</code> - the IAM role ARN is associated with the DB instance, but the DB instance is unable to assume the IAM role in order to access other Amazon Web Services services on your behalf.</p> </li> </ul>', 'DBInstanceStatusInfo$StatusType' => '<p>This value is currently "read replication."</p>', 'DBInstanceStatusInfo$Status' => '<p>The status of the DB instance. For a StatusType of read replica, the values can be replicating, replication stop point set, replication stop point reached, error, stopped, or terminated.</p>', 'DBInstanceStatusInfo$Message' => '<p>Details of the error if there is an error for the instance. If the instance isn\'t in an error state, this value is blank.</p>', 'DBParameterGroup$DBParameterGroupName' => '<p>The name of the DB parameter group.</p>', 'DBParameterGroup$DBParameterGroupFamily' => '<p>The name of the DB parameter group family that this DB parameter group is compatible with.</p>', 'DBParameterGroup$Description' => '<p>Provides the customer-specified description for this DB parameter group.</p>', 'DBParameterGroup$DBParameterGroupArn' => '<p>The Amazon Resource Name (ARN) for the DB parameter group.</p>', 'DBParameterGroupDetails$Marker' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DBParameterGroupNameMessage$DBParameterGroupName' => '<p>The name of the DB parameter group.</p>', 'DBParameterGroupStatus$DBParameterGroupName' => '<p>The name of the DB parameter group.</p>', 'DBParameterGroupStatus$ParameterApplyStatus' => '<p>The status of parameter updates.</p>', 'DBParameterGroupsMessage$Marker' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DBProxy$DBProxyName' => '<p>The identifier for the proxy. This name must be unique for all proxies owned by your Amazon Web Services account in the specified Amazon Web Services Region.</p>', 'DBProxy$DBProxyArn' => '<p>The Amazon Resource Name (ARN) for the proxy.</p>', 'DBProxy$EngineFamily' => '<p>The kinds of databases that the proxy can connect to. This value determines which database network protocol the proxy recognizes when it interprets network traffic to and from the database. <code>MYSQL</code> supports Aurora MySQL, RDS for MariaDB, and RDS for MySQL databases. <code>POSTGRESQL</code> supports Aurora PostgreSQL and RDS for PostgreSQL databases. <code>SQLSERVER</code> supports RDS for Microsoft SQL Server databases.</p>', 'DBProxy$VpcId' => '<p>Provides the VPC ID of the DB proxy.</p>', 'DBProxy$RoleArn' => '<p>The Amazon Resource Name (ARN) for the IAM role that the proxy uses to access Amazon Secrets Manager.</p>', 'DBProxy$Endpoint' => '<p>The endpoint that you can use to connect to the DB proxy. You include the endpoint value in the connection string for a database client application.</p>', 'DBProxyEndpoint$DBProxyEndpointName' => '<p>The name for the DB proxy endpoint. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can\'t end with a hyphen or contain two consecutive hyphens.</p>', 'DBProxyEndpoint$DBProxyEndpointArn' => '<p>The Amazon Resource Name (ARN) for the DB proxy endpoint.</p>', 'DBProxyEndpoint$DBProxyName' => '<p>The identifier for the DB proxy that is associated with this DB proxy endpoint.</p>', 'DBProxyEndpoint$VpcId' => '<p>Provides the VPC ID of the DB proxy endpoint.</p>', 'DBProxyEndpoint$Endpoint' => '<p>The endpoint that you can use to connect to the DB proxy. You include the endpoint value in the connection string for a database client application.</p>', 'DBProxyTarget$TargetArn' => '<p>The Amazon Resource Name (ARN) for the RDS DB instance or Aurora DB cluster.</p>', 'DBProxyTarget$Endpoint' => '<p>The writer endpoint for the RDS DB instance or Aurora DB cluster.</p>', 'DBProxyTarget$TrackedClusterId' => '<p>The DB cluster identifier when the target represents an Aurora DB cluster. This field is blank when the target represents an RDS DB instance.</p>', 'DBProxyTarget$RdsResourceId' => '<p>The identifier representing the target. It can be the instance identifier for an RDS DB instance, or the cluster identifier for an Aurora DB cluster.</p>', 'DBProxyTargetGroup$DBProxyName' => '<p>The identifier for the RDS proxy associated with this target group.</p>', 'DBProxyTargetGroup$TargetGroupName' => '<p>The identifier for the target group. This name must be unique for all target groups owned by your Amazon Web Services account in the specified Amazon Web Services Region.</p>', 'DBProxyTargetGroup$TargetGroupArn' => '<p>The Amazon Resource Name (ARN) representing the target group.</p>', 'DBProxyTargetGroup$Status' => '<p>The current status of this target group. A status of <code>available</code> means the target group is correctly associated with a database. Other values indicate that you must wait for the target group to be ready, or take some action to resolve an issue.</p>', 'DBRecommendation$RecommendationId' => '<p>The unique identifier of the recommendation.</p>', 'DBRecommendation$TypeId' => '<p>A value that indicates the type of recommendation. This value determines how the description is rendered.</p>', 'DBRecommendation$Severity' => '<p>The severity level of the recommendation. The severity level can help you decide the urgency with which to address the recommendation.</p> <p>Valid values:</p> <ul> <li> <p> <code>high</code> </p> </li> <li> <p> <code>medium</code> </p> </li> <li> <p> <code>low</code> </p> </li> <li> <p> <code>informational</code> </p> </li> </ul>', 'DBRecommendation$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the RDS resource associated with the recommendation.</p>', 'DBRecommendation$Status' => '<p>The current status of the recommendation.</p> <p>Valid values:</p> <ul> <li> <p> <code>active</code> - The recommendations which are ready for you to apply.</p> </li> <li> <p> <code>pending</code> - The applied or scheduled recommendations which are in progress.</p> </li> <li> <p> <code>resolved</code> - The recommendations which are completed.</p> </li> <li> <p> <code>dismissed</code> - The recommendations that you dismissed.</p> </li> </ul>', 'DBRecommendation$Detection' => '<p>A short description of the issue identified for this recommendation. The description might contain markdown.</p>', 'DBRecommendation$Recommendation' => '<p>A short description of the recommendation to resolve an issue. The description might contain markdown.</p>', 'DBRecommendation$Description' => '<p>A detailed description of the recommendation. The description might contain markdown.</p>', 'DBRecommendation$Reason' => '<p>The reason why this recommendation was created. The information might contain markdown.</p>', 'DBRecommendation$Category' => '<p>The category of the recommendation.</p> <p>Valid values:</p> <ul> <li> <p> <code>performance efficiency</code> </p> </li> <li> <p> <code>security</code> </p> </li> <li> <p> <code>reliability</code> </p> </li> <li> <p> <code>cost optimization</code> </p> </li> <li> <p> <code>operational excellence</code> </p> </li> <li> <p> <code>sustainability</code> </p> </li> </ul>', 'DBRecommendation$Source' => '<p>The Amazon Web Services service that generated the recommendations.</p>', 'DBRecommendation$TypeDetection' => '<p>A short description of the recommendation type. The description might contain markdown.</p>', 'DBRecommendation$TypeRecommendation' => '<p>A short description that summarizes the recommendation to fix all the issues of the recommendation type. The description might contain markdown.</p>', 'DBRecommendation$Impact' => '<p>A short description that explains the possible impact of an issue.</p>', 'DBRecommendation$AdditionalInfo' => '<p>Additional information about the recommendation. The information might contain markdown.</p>', 'DBRecommendationsMessage$Marker' => '<p>An optional pagination token provided by a previous <code>DBRecommendationsMessage</code> request. This token can be used later in a <code>DescribeDBRecomendations</code> request. </p>', 'DBSecurityGroup$OwnerId' => '<p>Provides the Amazon Web Services ID of the owner of a specific DB security group.</p>', 'DBSecurityGroup$DBSecurityGroupName' => '<p>Specifies the name of the DB security group.</p>', 'DBSecurityGroup$DBSecurityGroupDescription' => '<p>Provides the description of the DB security group.</p>', 'DBSecurityGroup$VpcId' => '<p>Provides the VpcId of the DB security group.</p>', 'DBSecurityGroup$DBSecurityGroupArn' => '<p>The Amazon Resource Name (ARN) for the DB security group.</p>', 'DBSecurityGroupMembership$DBSecurityGroupName' => '<p>The name of the DB security group.</p>', 'DBSecurityGroupMembership$Status' => '<p>The status of the DB security group.</p>', 'DBSecurityGroupMessage$Marker' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DBSecurityGroupNameList$member' => NULL, 'DBShardGroup$DBShardGroupResourceId' => '<p>The Amazon Web Services Region-unique, immutable identifier for the DB shard group.</p>', 'DBShardGroup$DBClusterIdentifier' => '<p>The name of the primary DB cluster for the DB shard group.</p>', 'DBShardGroup$Status' => '<p>The status of the DB shard group.</p>', 'DBShardGroup$Endpoint' => '<p>The connection endpoint for the DB shard group.</p>', 'DBSnapshot$DBSnapshotIdentifier' => '<p>Specifies the identifier for the DB snapshot.</p>', 'DBSnapshot$DBInstanceIdentifier' => '<p>Specifies the DB instance identifier of the DB instance this DB snapshot was created from.</p>', 'DBSnapshot$Engine' => '<p>Specifies the name of the database engine.</p>', 'DBSnapshot$Status' => '<p>Specifies the status of this DB snapshot.</p>', 'DBSnapshot$AvailabilityZone' => '<p>Specifies the name of the Availability Zone the DB instance was located in at the time of the DB snapshot.</p>', 'DBSnapshot$VpcId' => '<p>Provides the VPC ID associated with the DB snapshot.</p>', 'DBSnapshot$MasterUsername' => '<p>Provides the master username for the DB snapshot.</p>', 'DBSnapshot$EngineVersion' => '<p>Specifies the version of the database engine.</p>', 'DBSnapshot$LicenseModel' => '<p>License model information for the restored DB instance.</p>', 'DBSnapshot$SnapshotType' => '<p>Provides the type of the DB snapshot.</p>', 'DBSnapshot$OptionGroupName' => '<p>Provides the option group name for the DB snapshot.</p>', 'DBSnapshot$SourceRegion' => '<p>The Amazon Web Services Region that the DB snapshot was created in or copied from.</p>', 'DBSnapshot$SourceDBSnapshotIdentifier' => '<p>The DB snapshot Amazon Resource Name (ARN) that the DB snapshot was copied from. It only has a value in the case of a cross-account or cross-Region copy.</p>', 'DBSnapshot$StorageType' => '<p>Specifies the storage type associated with DB snapshot.</p>', 'DBSnapshot$TdeCredentialArn' => '<p>The ARN from the key store with which to associate the instance for TDE encryption.</p>', 'DBSnapshot$KmsKeyId' => '<p>If <code>Encrypted</code> is true, the Amazon Web Services KMS key identifier for the encrypted DB snapshot.</p> <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>', 'DBSnapshot$DBSnapshotArn' => '<p>The Amazon Resource Name (ARN) for the DB snapshot.</p>', 'DBSnapshot$Timezone' => '<p>The time zone of the DB snapshot. In most cases, the <code>Timezone</code> element is empty. <code>Timezone</code> content appears only for snapshots taken from Microsoft SQL Server DB instances that were created with a time zone specified.</p>', 'DBSnapshot$DbiResourceId' => '<p>The identifier for the source DB instance, which can\'t be changed and which is unique to an Amazon Web Services Region.</p>', 'DBSnapshot$SnapshotTarget' => '<p>Specifies where manual snapshots are stored: Amazon Web Services Outposts or the Amazon Web Services Region.</p>', 'DBSnapshot$DBSystemId' => '<p>The Oracle system identifier (SID), which is the name of the Oracle database instance that manages your database files. The Oracle SID is also the name of your CDB.</p>', 'DBSnapshotAttribute$AttributeName' => '<p>The name of the manual DB snapshot attribute.</p> <p>The attribute named <code>restore</code> refers to the list of Amazon Web Services accounts that have permission to copy or restore the manual DB cluster snapshot. For more information, see the <code>ModifyDBSnapshotAttribute</code> API action.</p>', 'DBSnapshotAttributesResult$DBSnapshotIdentifier' => '<p>The identifier of the manual DB snapshot that the attributes apply to.</p>', 'DBSnapshotMessage$Marker' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DBSnapshotTenantDatabase$DBSnapshotIdentifier' => '<p>The identifier for the snapshot of the DB instance.</p>', 'DBSnapshotTenantDatabase$DBInstanceIdentifier' => '<p>The ID for the DB instance that contains the tenant databases.</p>', 'DBSnapshotTenantDatabase$DbiResourceId' => '<p>The resource identifier of the source CDB instance. This identifier can\'t be changed and is unique to an Amazon Web Services Region.</p>', 'DBSnapshotTenantDatabase$EngineName' => '<p>The name of the database engine.</p>', 'DBSnapshotTenantDatabase$SnapshotType' => '<p>The type of DB snapshot.</p>', 'DBSnapshotTenantDatabase$TenantDBName' => '<p>The name of the tenant database.</p>', 'DBSnapshotTenantDatabase$MasterUsername' => '<p>The master username of the tenant database.</p>', 'DBSnapshotTenantDatabase$TenantDatabaseResourceId' => '<p>The resource ID of the tenant database.</p>', 'DBSnapshotTenantDatabase$CharacterSetName' => '<p>The name of the character set of a tenant database.</p>', 'DBSnapshotTenantDatabase$DBSnapshotTenantDatabaseARN' => '<p>The Amazon Resource Name (ARN) for the snapshot tenant database.</p>', 'DBSnapshotTenantDatabase$NcharCharacterSetName' => '<p>The <code>NCHAR</code> character set name of the tenant database.</p>', 'DBSnapshotTenantDatabasesMessage$Marker' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DBSubnetGroup$DBSubnetGroupName' => '<p>The name of the DB subnet group.</p>', 'DBSubnetGroup$DBSubnetGroupDescription' => '<p>Provides the description of the DB subnet group.</p>', 'DBSubnetGroup$VpcId' => '<p>Provides the VpcId of the DB subnet group.</p>', 'DBSubnetGroup$SubnetGroupStatus' => '<p>Provides the status of the DB subnet group.</p>', 'DBSubnetGroup$DBSubnetGroupArn' => '<p>The Amazon Resource Name (ARN) for the DB subnet group.</p>', 'DBSubnetGroupMessage$Marker' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DeleteDBClusterAutomatedBackupMessage$DbClusterResourceId' => '<p>The identifier for the source DB cluster, which can\'t be changed and which is unique to an Amazon Web Services Region.</p>', 'DeleteDBClusterEndpointMessage$DBClusterEndpointIdentifier' => '<p>The identifier associated with the custom endpoint. This parameter is stored as a lowercase string.</p>', 'DeleteDBClusterMessage$DBClusterIdentifier' => '<p>The DB cluster identifier for the DB cluster to be deleted. This parameter isn\'t case-sensitive.</p> <p>Constraints:</p> <ul> <li> <p>Must match an existing DBClusterIdentifier.</p> </li> </ul>', 'DeleteDBClusterMessage$FinalDBSnapshotIdentifier' => '<p>The DB cluster snapshot identifier of the new DB cluster snapshot created when <code>SkipFinalSnapshot</code> is disabled.</p> <note> <p>Specifying this parameter and also skipping the creation of a final DB cluster snapshot with the <code>SkipFinalShapshot</code> parameter results in an error.</p> </note> <p>Constraints:</p> <ul> <li> <p>Must be 1 to 255 letters, numbers, or hyphens.</p> </li> <li> <p>First character must be a letter</p> </li> <li> <p>Can\'t end with a hyphen or contain two consecutive hyphens</p> </li> </ul>', 'DeleteDBClusterParameterGroupMessage$DBClusterParameterGroupName' => '<p>The name of the DB cluster parameter group.</p> <p>Constraints:</p> <ul> <li> <p>Must be the name of an existing DB cluster parameter group.</p> </li> <li> <p>You can\'t delete a default DB cluster parameter group.</p> </li> <li> <p>Can\'t be associated with any DB clusters.</p> </li> </ul>', 'DeleteDBClusterSnapshotMessage$DBClusterSnapshotIdentifier' => '<p>The identifier of the DB cluster snapshot to delete.</p> <p>Constraints: Must be the name of an existing DB cluster snapshot in the <code>available</code> state.</p>', 'DeleteDBInstanceAutomatedBackupMessage$DbiResourceId' => '<p>The identifier for the source DB instance, which can\'t be changed and which is unique to an Amazon Web Services Region.</p>', 'DeleteDBInstanceAutomatedBackupMessage$DBInstanceAutomatedBackupsArn' => '<p>The Amazon Resource Name (ARN) of the automated backups to delete, for example, <code>arn:aws:rds:us-east-1:123456789012:auto-backup:ab-L2IJCEXJP7XQ7HOJ4SIEXAMPLE</code>.</p> <p>This setting doesn\'t apply to RDS Custom.</p>', 'DeleteDBInstanceMessage$DBInstanceIdentifier' => '<p>The DB instance identifier for the DB instance to be deleted. This parameter isn\'t case-sensitive.</p> <p>Constraints:</p> <ul> <li> <p>Must match the name of an existing DB instance.</p> </li> </ul>', 'DeleteDBInstanceMessage$FinalDBSnapshotIdentifier' => '<p>The <code>DBSnapshotIdentifier</code> of the new <code>DBSnapshot</code> created when the <code>SkipFinalSnapshot</code> parameter is disabled.</p> <note> <p>If you enable this parameter and also enable SkipFinalShapshot, the command results in an error.</p> </note> <p>This setting doesn\'t apply to RDS Custom.</p> <p>Constraints:</p> <ul> <li> <p>Must be 1 to 255 letters or numbers.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Can\'t end with a hyphen or contain two consecutive hyphens.</p> </li> <li> <p>Can\'t be specified when deleting a read replica.</p> </li> </ul>', 'DeleteDBParameterGroupMessage$DBParameterGroupName' => '<p>The name of the DB parameter group.</p> <p>Constraints:</p> <ul> <li> <p>Must be the name of an existing DB parameter group</p> </li> <li> <p>You can\'t delete a default DB parameter group</p> </li> <li> <p>Can\'t be associated with any DB instances</p> </li> </ul>', 'DeleteDBProxyRequest$DBProxyName' => '<p>The name of the DB proxy to delete.</p>', 'DeleteDBSecurityGroupMessage$DBSecurityGroupName' => '<p>The name of the DB security group to delete.</p> <note> <p>You can\'t delete the default DB security group.</p> </note> <p>Constraints:</p> <ul> <li> <p>Must be 1 to 255 letters, numbers, or hyphens.</p> </li> <li> <p>First character must be a letter</p> </li> <li> <p>Can\'t end with a hyphen or contain two consecutive hyphens</p> </li> <li> <p>Must not be "Default"</p> </li> </ul>', 'DeleteDBSnapshotMessage$DBSnapshotIdentifier' => '<p>The DB snapshot identifier.</p> <p>Constraints: Must be the name of an existing DB snapshot in the <code>available</code> state.</p>', 'DeleteDBSubnetGroupMessage$DBSubnetGroupName' => '<p>The name of the database subnet group to delete.</p> <note> <p>You can\'t delete the default subnet group.</p> </note> <p>Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.</p> <p>Example: <code>mydbsubnetgroup</code> </p>', 'DeleteEventSubscriptionMessage$SubscriptionName' => '<p>The name of the RDS event notification subscription you want to delete.</p>', 'DeleteGlobalClusterMessage$GlobalClusterIdentifier' => '<p>The cluster identifier of the global database cluster being deleted.</p>', 'DeleteOptionGroupMessage$OptionGroupName' => '<p>The name of the option group to be deleted.</p> <note> <p>You can\'t delete default option groups.</p> </note>', 'DeleteTenantDatabaseMessage$DBInstanceIdentifier' => '<p>The user-supplied identifier for the DB instance that contains the tenant database that you want to delete.</p>', 'DeleteTenantDatabaseMessage$TenantDBName' => '<p>The user-supplied name of the tenant database that you want to remove from your DB instance. Amazon RDS deletes the tenant database with this name. This parameter isn’t case-sensitive.</p>', 'DeleteTenantDatabaseMessage$FinalDBSnapshotIdentifier' => '<p>The <code>DBSnapshotIdentifier</code> of the new <code>DBSnapshot</code> created when the <code>SkipFinalSnapshot</code> parameter is disabled.</p> <note> <p>If you enable this parameter and also enable <code>SkipFinalShapshot</code>, the command results in an error.</p> </note>', 'DeregisterDBProxyTargetsRequest$DBProxyName' => '<p>The identifier of the <code>DBProxy</code> that is associated with the <code>DBProxyTargetGroup</code>.</p>', 'DeregisterDBProxyTargetsRequest$TargetGroupName' => '<p>The identifier of the <code>DBProxyTargetGroup</code>.</p>', 'DescribeBlueGreenDeploymentsRequest$Marker' => '<p>An optional pagination token provided by a previous <code>DescribeBlueGreenDeployments</code> request. If you specify this parameter, the response only includes records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeBlueGreenDeploymentsResponse$Marker' => '<p>A pagination token that can be used in a later <code>DescribeBlueGreenDeployments</code> request.</p>', 'DescribeCertificatesMessage$CertificateIdentifier' => '<p>The user-supplied certificate identifier. If this parameter is specified, information for only the identified certificate is returned. This parameter isn\'t case-sensitive.</p> <p>Constraints:</p> <ul> <li> <p>Must match an existing CertificateIdentifier.</p> </li> </ul>', 'DescribeCertificatesMessage$Marker' => '<p>An optional pagination token provided by a previous <code>DescribeCertificates</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeDBClusterAutomatedBackupsMessage$DbClusterResourceId' => '<p>The resource ID of the DB cluster that is the source of the automated backup. This parameter isn\'t case-sensitive.</p>', 'DescribeDBClusterAutomatedBackupsMessage$DBClusterIdentifier' => '<p>(Optional) The user-supplied DB cluster identifier. If this parameter is specified, it must match the identifier of an existing DB cluster. It returns information from the specific DB cluster\'s automated backup. This parameter isn\'t case-sensitive.</p>', 'DescribeDBClusterAutomatedBackupsMessage$Marker' => '<p>The pagination token provided in the previous request. If this parameter is specified the response includes only records beyond the marker, up to <code>MaxRecords</code>.</p>', 'DescribeDBClusterBacktracksMessage$DBClusterIdentifier' => '<p>The DB cluster identifier of the DB cluster to be described. This parameter is stored as a lowercase string.</p> <p>Constraints:</p> <ul> <li> <p>Must contain from 1 to 63 alphanumeric characters or hyphens.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Can\'t end with a hyphen or contain two consecutive hyphens.</p> </li> </ul> <p>Example: <code>my-cluster1</code> </p>', 'DescribeDBClusterBacktracksMessage$BacktrackIdentifier' => '<p>If specified, this value is the backtrack identifier of the backtrack to be described.</p> <p>Constraints:</p> <ul> <li> <p>Must contain a valid universally unique identifier (UUID). For more information about UUIDs, see <a href="https://en.wikipedia.org/wiki/Universally_unique_identifier">Universally unique identifier</a>.</p> </li> </ul> <p>Example: <code>123e4567-e89b-12d3-a456-426655440000</code> </p>', 'DescribeDBClusterBacktracksMessage$Marker' => '<p>An optional pagination token provided by a previous <code>DescribeDBClusterBacktracks</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeDBClusterEndpointsMessage$DBClusterIdentifier' => '<p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is stored as a lowercase string.</p>', 'DescribeDBClusterEndpointsMessage$DBClusterEndpointIdentifier' => '<p>The identifier of the endpoint to describe. This parameter is stored as a lowercase string.</p>', 'DescribeDBClusterEndpointsMessage$Marker' => '<p>An optional pagination token provided by a previous <code>DescribeDBClusterEndpoints</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeDBClusterParameterGroupsMessage$DBClusterParameterGroupName' => '<p>The name of a specific DB cluster parameter group to return details for.</p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p> </li> </ul>', 'DescribeDBClusterParameterGroupsMessage$Marker' => '<p>An optional pagination token provided by a previous <code>DescribeDBClusterParameterGroups</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeDBClusterParametersMessage$DBClusterParameterGroupName' => '<p>The name of a specific DB cluster parameter group to return parameter details for.</p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p> </li> </ul>', 'DescribeDBClusterParametersMessage$Source' => '<p>A specific source to return parameters for.</p> <p>Valid Values:</p> <ul> <li> <p> <code>customer</code> </p> </li> <li> <p> <code>engine</code> </p> </li> <li> <p> <code>service</code> </p> </li> </ul>', 'DescribeDBClusterParametersMessage$Marker' => '<p>An optional pagination token provided by a previous <code>DescribeDBClusterParameters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeDBClusterSnapshotAttributesMessage$DBClusterSnapshotIdentifier' => '<p>The identifier for the DB cluster snapshot to describe the attributes for.</p>', 'DescribeDBClusterSnapshotsMessage$DBClusterIdentifier' => '<p>The ID of the DB cluster to retrieve the list of DB cluster snapshots for. This parameter can\'t be used in conjunction with the <code>DBClusterSnapshotIdentifier</code> parameter. This parameter isn\'t case-sensitive.</p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match the identifier of an existing DBCluster.</p> </li> </ul>', 'DescribeDBClusterSnapshotsMessage$DBClusterSnapshotIdentifier' => '<p>A specific DB cluster snapshot identifier to describe. This parameter can\'t be used in conjunction with the <code>DBClusterIdentifier</code> parameter. This value is stored as a lowercase string.</p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match the identifier of an existing DBClusterSnapshot.</p> </li> <li> <p>If this identifier is for an automated snapshot, the <code>SnapshotType</code> parameter must also be specified.</p> </li> </ul>', 'DescribeDBClusterSnapshotsMessage$SnapshotType' => '<p>The type of DB cluster snapshots to be returned. You can specify one of the following values:</p> <ul> <li> <p> <code>automated</code> - Return all DB cluster snapshots that have been automatically taken by Amazon RDS for my Amazon Web Services account.</p> </li> <li> <p> <code>manual</code> - Return all DB cluster snapshots that have been taken by my Amazon Web Services account.</p> </li> <li> <p> <code>shared</code> - Return all manual DB cluster snapshots that have been shared to my Amazon Web Services account.</p> </li> <li> <p> <code>public</code> - Return all DB cluster snapshots that have been marked as public.</p> </li> </ul> <p>If you don\'t specify a <code>SnapshotType</code> value, then both automated and manual DB cluster snapshots are returned. You can include shared DB cluster snapshots with these results by enabling the <code>IncludeShared</code> parameter. You can include public DB cluster snapshots with these results by enabling the <code>IncludePublic</code> parameter.</p> <p>The <code>IncludeShared</code> and <code>IncludePublic</code> parameters don\'t apply for <code>SnapshotType</code> values of <code>manual</code> or <code>automated</code>. The <code>IncludePublic</code> parameter doesn\'t apply when <code>SnapshotType</code> is set to <code>shared</code>. The <code>IncludeShared</code> parameter doesn\'t apply when <code>SnapshotType</code> is set to <code>public</code>.</p>', 'DescribeDBClusterSnapshotsMessage$Marker' => '<p>An optional pagination token provided by a previous <code>DescribeDBClusterSnapshots</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeDBClusterSnapshotsMessage$DbClusterResourceId' => '<p>A specific DB cluster resource ID to describe.</p>', 'DescribeDBClustersMessage$DBClusterIdentifier' => '<p>The user-supplied DB cluster identifier or the Amazon Resource Name (ARN) of the DB cluster. If this parameter is specified, information for only the specific DB cluster is returned. This parameter isn\'t case-sensitive.</p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match an existing DB cluster identifier.</p> </li> </ul>', 'DescribeDBClustersMessage$Marker' => '<p>An optional pagination token provided by a previous <code>DescribeDBClusters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeDBEngineVersionsMessage$Engine' => '<p>The database engine to return version details for.</p> <p>Valid Values:</p> <ul> <li> <p> <code>aurora-mysql</code> </p> </li> <li> <p> <code>aurora-postgresql</code> </p> </li> <li> <p> <code>custom-oracle-ee</code> </p> </li> <li> <p> <code>custom-oracle-ee-cdb</code> </p> </li> <li> <p> <code>custom-oracle-se2</code> </p> </li> <li> <p> <code>custom-oracle-se2-cdb</code> </p> </li> <li> <p> <code>db2-ae</code> </p> </li> <li> <p> <code>db2-se</code> </p> </li> <li> <p> <code>mariadb</code> </p> </li> <li> <p> <code>mysql</code> </p> </li> <li> <p> <code>oracle-ee</code> </p> </li> <li> <p> <code>oracle-ee-cdb</code> </p> </li> <li> <p> <code>oracle-se2</code> </p> </li> <li> <p> <code>oracle-se2-cdb</code> </p> </li> <li> <p> <code>postgres</code> </p> </li> <li> <p> <code>sqlserver-ee</code> </p> </li> <li> <p> <code>sqlserver-se</code> </p> </li> <li> <p> <code>sqlserver-ex</code> </p> </li> <li> <p> <code>sqlserver-web</code> </p> </li> </ul>', 'DescribeDBEngineVersionsMessage$EngineVersion' => '<p>A specific database engine version to return details for.</p> <p>Example: <code>5.1.49</code> </p>', 'DescribeDBEngineVersionsMessage$DBParameterGroupFamily' => '<p>The name of a specific DB parameter group family to return details for.</p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match an existing DB parameter group family.</p> </li> </ul>', 'DescribeDBEngineVersionsMessage$Marker' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeDBInstanceAutomatedBackupsMessage$DbiResourceId' => '<p>The resource ID of the DB instance that is the source of the automated backup. This parameter isn\'t case-sensitive.</p>', 'DescribeDBInstanceAutomatedBackupsMessage$DBInstanceIdentifier' => '<p>(Optional) The user-supplied instance identifier. If this parameter is specified, it must match the identifier of an existing DB instance. It returns information from the specific DB instance\'s automated backup. This parameter isn\'t case-sensitive.</p>', 'DescribeDBInstanceAutomatedBackupsMessage$Marker' => '<p>The pagination token provided in the previous request. If this parameter is specified the response includes only records beyond the marker, up to <code>MaxRecords</code>.</p>', 'DescribeDBInstanceAutomatedBackupsMessage$DBInstanceAutomatedBackupsArn' => '<p>The Amazon Resource Name (ARN) of the replicated automated backups, for example, <code>arn:aws:rds:us-east-1:123456789012:auto-backup:ab-L2IJCEXJP7XQ7HOJ4SIEXAMPLE</code>.</p> <p>This setting doesn\'t apply to RDS Custom.</p>', 'DescribeDBInstancesMessage$DBInstanceIdentifier' => '<p>The user-supplied instance identifier or the Amazon Resource Name (ARN) of the DB instance. If this parameter is specified, information from only the specific DB instance is returned. This parameter isn\'t case-sensitive.</p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match the identifier of an existing DB instance.</p> </li> </ul>', 'DescribeDBInstancesMessage$Marker' => '<p>An optional pagination token provided by a previous <code>DescribeDBInstances</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeDBLogFilesDetails$LogFileName' => '<p>The name of the log file for the specified DB instance.</p>', 'DescribeDBLogFilesMessage$DBInstanceIdentifier' => '<p>The customer-assigned name of the DB instance that contains the log files you want to list.</p> <p>Constraints:</p> <ul> <li> <p>Must match the identifier of an existing DBInstance.</p> </li> </ul>', 'DescribeDBLogFilesMessage$FilenameContains' => '<p>Filters the available log files for log file names that contain the specified string.</p>', 'DescribeDBLogFilesMessage$Marker' => '<p>The pagination token provided in the previous request. If this parameter is specified the response includes only records beyond the marker, up to MaxRecords.</p>', 'DescribeDBLogFilesResponse$Marker' => '<p>A pagination token that can be used in a later <code>DescribeDBLogFiles</code> request.</p>', 'DescribeDBParameterGroupsMessage$DBParameterGroupName' => '<p>The name of a specific DB parameter group to return details for.</p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p> </li> </ul>', 'DescribeDBParameterGroupsMessage$Marker' => '<p>An optional pagination token provided by a previous <code>DescribeDBParameterGroups</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeDBParametersMessage$DBParameterGroupName' => '<p>The name of a specific DB parameter group to return details for.</p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match the name of an existing DBParameterGroup.</p> </li> </ul>', 'DescribeDBParametersMessage$Source' => '<p>The parameter types to return.</p> <p>Default: All parameter types returned</p> <p>Valid Values: <code>user | system | engine-default</code> </p>', 'DescribeDBParametersMessage$Marker' => '<p>An optional pagination token provided by a previous <code>DescribeDBParameters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeDBProxiesRequest$DBProxyName' => '<p>The name of the DB proxy. If you omit this parameter, the output includes information about all DB proxies owned by your Amazon Web Services account ID.</p>', 'DescribeDBProxiesRequest$Marker' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeDBProxiesResponse$Marker' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeDBProxyEndpointsRequest$Marker' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeDBProxyEndpointsResponse$Marker' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeDBProxyTargetGroupsRequest$DBProxyName' => '<p>The identifier of the <code>DBProxy</code> associated with the target group.</p>', 'DescribeDBProxyTargetGroupsRequest$TargetGroupName' => '<p>The identifier of the <code>DBProxyTargetGroup</code> to describe.</p>', 'DescribeDBProxyTargetGroupsRequest$Marker' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeDBProxyTargetGroupsResponse$Marker' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeDBProxyTargetsRequest$DBProxyName' => '<p>The identifier of the <code>DBProxyTarget</code> to describe.</p>', 'DescribeDBProxyTargetsRequest$TargetGroupName' => '<p>The identifier of the <code>DBProxyTargetGroup</code> to describe.</p>', 'DescribeDBProxyTargetsRequest$Marker' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeDBProxyTargetsResponse$Marker' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeDBRecommendationsMessage$Locale' => '<p>The language that you choose to return the list of recommendations.</p> <p>Valid values:</p> <ul> <li> <p> <code>en</code> </p> </li> <li> <p> <code>en_UK</code> </p> </li> <li> <p> <code>de</code> </p> </li> <li> <p> <code>es</code> </p> </li> <li> <p> <code>fr</code> </p> </li> <li> <p> <code>id</code> </p> </li> <li> <p> <code>it</code> </p> </li> <li> <p> <code>ja</code> </p> </li> <li> <p> <code>ko</code> </p> </li> <li> <p> <code>pt_BR</code> </p> </li> <li> <p> <code>zh_TW</code> </p> </li> <li> <p> <code>zh_CN</code> </p> </li> </ul>', 'DescribeDBRecommendationsMessage$Marker' => '<p>An optional pagination token provided by a previous <code>DescribeDBRecommendations</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'DescribeDBSecurityGroupsMessage$DBSecurityGroupName' => '<p>The name of the DB security group to return details for.</p>', 'DescribeDBSecurityGroupsMessage$Marker' => '<p>An optional pagination token provided by a previous <code>DescribeDBSecurityGroups</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeDBShardGroupsMessage$Marker' => '<p>An optional pagination token provided by a previous <code>DescribeDBShardGroups</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeDBShardGroupsResponse$Marker' => '<p>A pagination token that can be used in a later <code>DescribeDBClusters</code> request.</p>', 'DescribeDBSnapshotAttributesMessage$DBSnapshotIdentifier' => '<p>The identifier for the DB snapshot to describe the attributes for.</p>', 'DescribeDBSnapshotTenantDatabasesMessage$DBInstanceIdentifier' => '<p>The ID of the DB instance used to create the DB snapshots. This parameter isn\'t case-sensitive.</p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match the identifier of an existing <code>DBInstance</code>.</p> </li> </ul>', 'DescribeDBSnapshotTenantDatabasesMessage$DBSnapshotIdentifier' => '<p>The ID of a DB snapshot that contains the tenant databases to describe. This value is stored as a lowercase string.</p> <p>Constraints:</p> <ul> <li> <p>If you specify this parameter, the value must match the ID of an existing DB snapshot.</p> </li> <li> <p>If you specify an automatic snapshot, you must also specify <code>SnapshotType</code>.</p> </li> </ul>', 'DescribeDBSnapshotTenantDatabasesMessage$SnapshotType' => '<p>The type of DB snapshots to be returned. You can specify one of the following values:</p> <ul> <li> <p> <code>automated</code> – All DB snapshots that have been automatically taken by Amazon RDS for my Amazon Web Services account.</p> </li> <li> <p> <code>manual</code> – All DB snapshots that have been taken by my Amazon Web Services account.</p> </li> <li> <p> <code>shared</code> – All manual DB snapshots that have been shared to my Amazon Web Services account.</p> </li> <li> <p> <code>public</code> – All DB snapshots that have been marked as public.</p> </li> <li> <p> <code>awsbackup</code> – All DB snapshots managed by the Amazon Web Services Backup service.</p> </li> </ul>', 'DescribeDBSnapshotTenantDatabasesMessage$Marker' => '<p>An optional pagination token provided by a previous <code>DescribeDBSnapshotTenantDatabases</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeDBSnapshotTenantDatabasesMessage$DbiResourceId' => '<p>A specific DB resource identifier to describe.</p>', 'DescribeDBSnapshotsMessage$DBInstanceIdentifier' => '<p>The ID of the DB instance to retrieve the list of DB snapshots for. This parameter isn\'t case-sensitive.</p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match the identifier of an existing DBInstance.</p> </li> </ul>', 'DescribeDBSnapshotsMessage$DBSnapshotIdentifier' => '<p>A specific DB snapshot identifier to describe. This value is stored as a lowercase string.</p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match the identifier of an existing DBSnapshot.</p> </li> <li> <p>If this identifier is for an automated snapshot, the <code>SnapshotType</code> parameter must also be specified.</p> </li> </ul>', 'DescribeDBSnapshotsMessage$SnapshotType' => '<p>The type of snapshots to be returned. You can specify one of the following values:</p> <ul> <li> <p> <code>automated</code> - Return all DB snapshots that have been automatically taken by Amazon RDS for my Amazon Web Services account.</p> </li> <li> <p> <code>manual</code> - Return all DB snapshots that have been taken by my Amazon Web Services account.</p> </li> <li> <p> <code>shared</code> - Return all manual DB snapshots that have been shared to my Amazon Web Services account.</p> </li> <li> <p> <code>public</code> - Return all DB snapshots that have been marked as public.</p> </li> <li> <p> <code>awsbackup</code> - Return the DB snapshots managed by the Amazon Web Services Backup service.</p> <p>For information about Amazon Web Services Backup, see the <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html"> <i>Amazon Web Services Backup Developer Guide.</i> </a> </p> <p>The <code>awsbackup</code> type does not apply to Aurora.</p> </li> </ul> <p>If you don\'t specify a <code>SnapshotType</code> value, then both automated and manual snapshots are returned. Shared and public DB snapshots are not included in the returned results by default. You can include shared snapshots with these results by enabling the <code>IncludeShared</code> parameter. You can include public snapshots with these results by enabling the <code>IncludePublic</code> parameter.</p> <p>The <code>IncludeShared</code> and <code>IncludePublic</code> parameters don\'t apply for <code>SnapshotType</code> values of <code>manual</code> or <code>automated</code>. The <code>IncludePublic</code> parameter doesn\'t apply when <code>SnapshotType</code> is set to <code>shared</code>. The <code>IncludeShared</code> parameter doesn\'t apply when <code>SnapshotType</code> is set to <code>public</code>.</p>', 'DescribeDBSnapshotsMessage$Marker' => '<p>An optional pagination token provided by a previous <code>DescribeDBSnapshots</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeDBSnapshotsMessage$DbiResourceId' => '<p>A specific DB resource ID to describe.</p>', 'DescribeDBSubnetGroupsMessage$DBSubnetGroupName' => '<p>The name of the DB subnet group to return details for.</p>', 'DescribeDBSubnetGroupsMessage$Marker' => '<p>An optional pagination token provided by a previous DescribeDBSubnetGroups request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeEngineDefaultClusterParametersMessage$DBParameterGroupFamily' => '<p>The name of the DB cluster parameter group family to return engine parameter information for.</p>', 'DescribeEngineDefaultClusterParametersMessage$Marker' => '<p>An optional pagination token provided by a previous <code>DescribeEngineDefaultClusterParameters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeEngineDefaultParametersMessage$DBParameterGroupFamily' => '<p>The name of the DB parameter group family.</p> <p>Valid Values:</p> <ul> <li> <p> <code>aurora-mysql5.7</code> </p> </li> <li> <p> <code>aurora-mysql8.0</code> </p> </li> <li> <p> <code>aurora-postgresql10</code> </p> </li> <li> <p> <code>aurora-postgresql11</code> </p> </li> <li> <p> <code>aurora-postgresql12</code> </p> </li> <li> <p> <code>aurora-postgresql13</code> </p> </li> <li> <p> <code>aurora-postgresql14</code> </p> </li> <li> <p> <code>custom-oracle-ee-19</code> </p> </li> <li> <p> <code>custom-oracle-ee-cdb-19</code> </p> </li> <li> <p> <code>db2-ae</code> </p> </li> <li> <p> <code>db2-se</code> </p> </li> <li> <p> <code>mariadb10.2</code> </p> </li> <li> <p> <code>mariadb10.3</code> </p> </li> <li> <p> <code>mariadb10.4</code> </p> </li> <li> <p> <code>mariadb10.5</code> </p> </li> <li> <p> <code>mariadb10.6</code> </p> </li> <li> <p> <code>mysql5.7</code> </p> </li> <li> <p> <code>mysql8.0</code> </p> </li> <li> <p> <code>oracle-ee-19</code> </p> </li> <li> <p> <code>oracle-ee-cdb-19</code> </p> </li> <li> <p> <code>oracle-ee-cdb-21</code> </p> </li> <li> <p> <code>oracle-se2-19</code> </p> </li> <li> <p> <code>oracle-se2-cdb-19</code> </p> </li> <li> <p> <code>oracle-se2-cdb-21</code> </p> </li> <li> <p> <code>postgres10</code> </p> </li> <li> <p> <code>postgres11</code> </p> </li> <li> <p> <code>postgres12</code> </p> </li> <li> <p> <code>postgres13</code> </p> </li> <li> <p> <code>postgres14</code> </p> </li> <li> <p> <code>sqlserver-ee-11.0</code> </p> </li> <li> <p> <code>sqlserver-ee-12.0</code> </p> </li> <li> <p> <code>sqlserver-ee-13.0</code> </p> </li> <li> <p> <code>sqlserver-ee-14.0</code> </p> </li> <li> <p> <code>sqlserver-ee-15.0</code> </p> </li> <li> <p> <code>sqlserver-ex-11.0</code> </p> </li> <li> <p> <code>sqlserver-ex-12.0</code> </p> </li> <li> <p> <code>sqlserver-ex-13.0</code> </p> </li> <li> <p> <code>sqlserver-ex-14.0</code> </p> </li> <li> <p> <code>sqlserver-ex-15.0</code> </p> </li> <li> <p> <code>sqlserver-se-11.0</code> </p> </li> <li> <p> <code>sqlserver-se-12.0</code> </p> </li> <li> <p> <code>sqlserver-se-13.0</code> </p> </li> <li> <p> <code>sqlserver-se-14.0</code> </p> </li> <li> <p> <code>sqlserver-se-15.0</code> </p> </li> <li> <p> <code>sqlserver-web-11.0</code> </p> </li> <li> <p> <code>sqlserver-web-12.0</code> </p> </li> <li> <p> <code>sqlserver-web-13.0</code> </p> </li> <li> <p> <code>sqlserver-web-14.0</code> </p> </li> <li> <p> <code>sqlserver-web-15.0</code> </p> </li> </ul>', 'DescribeEngineDefaultParametersMessage$Marker' => '<p>An optional pagination token provided by a previous <code>DescribeEngineDefaultParameters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeEventCategoriesMessage$SourceType' => '<p>The type of source that is generating the events. For RDS Proxy events, specify <code>db-proxy</code>.</p> <p>Valid Values: <code>db-instance</code> | <code>db-cluster</code> | <code>db-parameter-group</code> | <code>db-security-group</code> | <code>db-snapshot</code> | <code>db-cluster-snapshot</code> | <code>db-proxy</code> </p>', 'DescribeEventSubscriptionsMessage$SubscriptionName' => '<p>The name of the RDS event notification subscription you want to describe.</p>', 'DescribeEventSubscriptionsMessage$Marker' => '<p>An optional pagination token provided by a previous DescribeOrderableDBInstanceOptions request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> .</p>', 'DescribeEventsMessage$SourceIdentifier' => '<p>The identifier of the event source for which events are returned. If not specified, then all sources are included in the response.</p> <p>Constraints:</p> <ul> <li> <p>If <code>SourceIdentifier</code> is supplied, <code>SourceType</code> must also be provided.</p> </li> <li> <p>If the source type is a DB instance, a <code>DBInstanceIdentifier</code> value must be supplied.</p> </li> <li> <p>If the source type is a DB cluster, a <code>DBClusterIdentifier</code> value must be supplied.</p> </li> <li> <p>If the source type is a DB parameter group, a <code>DBParameterGroupName</code> value must be supplied.</p> </li> <li> <p>If the source type is a DB security group, a <code>DBSecurityGroupName</code> value must be supplied.</p> </li> <li> <p>If the source type is a DB snapshot, a <code>DBSnapshotIdentifier</code> value must be supplied.</p> </li> <li> <p>If the source type is a DB cluster snapshot, a <code>DBClusterSnapshotIdentifier</code> value must be supplied.</p> </li> <li> <p>If the source type is an RDS Proxy, a <code>DBProxyName</code> value must be supplied.</p> </li> <li> <p>Can\'t end with a hyphen or contain two consecutive hyphens.</p> </li> </ul>', 'DescribeEventsMessage$Marker' => '<p>An optional pagination token provided by a previous DescribeEvents request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeExportTasksMessage$ExportTaskIdentifier' => '<p>The identifier of the snapshot or cluster export task to be described.</p>', 'DescribeExportTasksMessage$SourceArn' => '<p>The Amazon Resource Name (ARN) of the snapshot or cluster exported to Amazon S3.</p>', 'DescribeExportTasksMessage$Marker' => '<p>An optional pagination token provided by a previous <code>DescribeExportTasks</code> request. If you specify this parameter, the response includes only records beyond the marker, up to the value specified by the <code>MaxRecords</code> parameter.</p>', 'DescribeGlobalClustersMessage$GlobalClusterIdentifier' => '<p>The user-supplied DB cluster identifier. If this parameter is specified, information from only the specific DB cluster is returned. This parameter isn\'t case-sensitive.</p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match an existing DBClusterIdentifier.</p> </li> </ul>', 'DescribeGlobalClustersMessage$Marker' => '<p>An optional pagination token provided by a previous <code>DescribeGlobalClusters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeOptionGroupOptionsMessage$EngineName' => '<p>The name of the engine to describe options for.</p> <p>Valid Values:</p> <ul> <li> <p> <code>db2-ae</code> </p> </li> <li> <p> <code>db2-se</code> </p> </li> <li> <p> <code>mariadb</code> </p> </li> <li> <p> <code>mysql</code> </p> </li> <li> <p> <code>oracle-ee</code> </p> </li> <li> <p> <code>oracle-ee-cdb</code> </p> </li> <li> <p> <code>oracle-se2</code> </p> </li> <li> <p> <code>oracle-se2-cdb</code> </p> </li> <li> <p> <code>postgres</code> </p> </li> <li> <p> <code>sqlserver-ee</code> </p> </li> <li> <p> <code>sqlserver-se</code> </p> </li> <li> <p> <code>sqlserver-ex</code> </p> </li> <li> <p> <code>sqlserver-web</code> </p> </li> </ul>', 'DescribeOptionGroupOptionsMessage$MajorEngineVersion' => '<p>If specified, filters the results to include only options for the specified major engine version.</p>', 'DescribeOptionGroupOptionsMessage$Marker' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeOptionGroupsMessage$OptionGroupName' => '<p>The name of the option group to describe. Can\'t be supplied together with EngineName or MajorEngineVersion.</p>', 'DescribeOptionGroupsMessage$Marker' => '<p>An optional pagination token provided by a previous DescribeOptionGroups request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeOptionGroupsMessage$EngineName' => '<p>A filter to only include option groups associated with this database engine.</p> <p>Valid Values:</p> <ul> <li> <p> <code>db2-ae</code> </p> </li> <li> <p> <code>db2-se</code> </p> </li> <li> <p> <code>mariadb</code> </p> </li> <li> <p> <code>mysql</code> </p> </li> <li> <p> <code>oracle-ee</code> </p> </li> <li> <p> <code>oracle-ee-cdb</code> </p> </li> <li> <p> <code>oracle-se2</code> </p> </li> <li> <p> <code>oracle-se2-cdb</code> </p> </li> <li> <p> <code>postgres</code> </p> </li> <li> <p> <code>sqlserver-ee</code> </p> </li> <li> <p> <code>sqlserver-se</code> </p> </li> <li> <p> <code>sqlserver-ex</code> </p> </li> <li> <p> <code>sqlserver-web</code> </p> </li> </ul>', 'DescribeOptionGroupsMessage$MajorEngineVersion' => '<p>Filters the list of option groups to only include groups associated with a specific database engine version. If specified, then EngineName must also be specified.</p>', 'DescribeOrderableDBInstanceOptionsMessage$Engine' => '<p>The name of the database engine to describe DB instance options for.</p> <p>Valid Values:</p> <ul> <li> <p> <code>aurora-mysql</code> </p> </li> <li> <p> <code>aurora-postgresql</code> </p> </li> <li> <p> <code>custom-oracle-ee</code> </p> </li> <li> <p> <code>custom-oracle-ee-cdb</code> </p> </li> <li> <p> <code>custom-oracle-se2</code> </p> </li> <li> <p> <code>custom-oracle-se2-cdb</code> </p> </li> <li> <p> <code>db2-ae</code> </p> </li> <li> <p> <code>db2-se</code> </p> </li> <li> <p> <code>mariadb</code> </p> </li> <li> <p> <code>mysql</code> </p> </li> <li> <p> <code>oracle-ee</code> </p> </li> <li> <p> <code>oracle-ee-cdb</code> </p> </li> <li> <p> <code>oracle-se2</code> </p> </li> <li> <p> <code>oracle-se2-cdb</code> </p> </li> <li> <p> <code>postgres</code> </p> </li> <li> <p> <code>sqlserver-ee</code> </p> </li> <li> <p> <code>sqlserver-se</code> </p> </li> <li> <p> <code>sqlserver-ex</code> </p> </li> <li> <p> <code>sqlserver-web</code> </p> </li> </ul>', 'DescribeOrderableDBInstanceOptionsMessage$EngineVersion' => '<p>A filter to include only the available options for the specified engine version.</p>', 'DescribeOrderableDBInstanceOptionsMessage$DBInstanceClass' => '<p>A filter to include only the available options for the specified DB instance class.</p>', 'DescribeOrderableDBInstanceOptionsMessage$LicenseModel' => '<p>A filter to include only the available options for the specified license model.</p> <p>RDS Custom supports only the BYOL licensing model.</p>', 'DescribeOrderableDBInstanceOptionsMessage$AvailabilityZoneGroup' => '<p>The Availability Zone group associated with a Local Zone. Specify this parameter to retrieve available options for the Local Zones in the group.</p> <p>Omit this parameter to show the available options in the specified Amazon Web Services Region.</p> <p>This setting doesn\'t apply to RDS Custom DB instances.</p>', 'DescribeOrderableDBInstanceOptionsMessage$Marker' => '<p>An optional pagination token provided by a previous DescribeOrderableDBInstanceOptions request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribePendingMaintenanceActionsMessage$ResourceIdentifier' => '<p>The ARN of a resource to return pending maintenance actions for.</p>', 'DescribePendingMaintenanceActionsMessage$Marker' => '<p>An optional pagination token provided by a previous <code>DescribePendingMaintenanceActions</code> request. If this parameter is specified, the response includes only records beyond the marker, up to a number of records specified by <code>MaxRecords</code>.</p>', 'DescribeReservedDBInstancesMessage$ReservedDBInstanceId' => '<p>The reserved DB instance identifier filter value. Specify this parameter to show only the reservation that matches the specified reservation ID.</p>', 'DescribeReservedDBInstancesMessage$ReservedDBInstancesOfferingId' => '<p>The offering identifier filter value. Specify this parameter to show only purchased reservations matching the specified offering identifier.</p>', 'DescribeReservedDBInstancesMessage$DBInstanceClass' => '<p>The DB instance class filter value. Specify this parameter to show only those reservations matching the specified DB instances class.</p>', 'DescribeReservedDBInstancesMessage$Duration' => '<p>The duration filter value, specified in years or seconds. Specify this parameter to show only reservations for this duration.</p> <p>Valid Values: <code>1 | 3 | 31536000 | 94608000</code> </p>', 'DescribeReservedDBInstancesMessage$ProductDescription' => '<p>The product description filter value. Specify this parameter to show only those reservations matching the specified product description.</p>', 'DescribeReservedDBInstancesMessage$OfferingType' => '<p>The offering type filter value. Specify this parameter to show only the available offerings matching the specified offering type.</p> <p>Valid Values: <code>"Partial Upfront" | "All Upfront" | "No Upfront" </code> </p>', 'DescribeReservedDBInstancesMessage$LeaseId' => '<p>The lease identifier filter value. Specify this parameter to show only the reservation that matches the specified lease ID.</p> <note> <p>Amazon Web Services Support might request the lease ID for an issue related to a reserved DB instance.</p> </note>', 'DescribeReservedDBInstancesMessage$Marker' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeReservedDBInstancesOfferingsMessage$ReservedDBInstancesOfferingId' => '<p>The offering identifier filter value. Specify this parameter to show only the available offering that matches the specified reservation identifier.</p> <p>Example: <code>438012d3-4052-4cc7-b2e3-8d3372e0e706</code> </p>', 'DescribeReservedDBInstancesOfferingsMessage$DBInstanceClass' => '<p>The DB instance class filter value. Specify this parameter to show only the available offerings matching the specified DB instance class.</p>', 'DescribeReservedDBInstancesOfferingsMessage$Duration' => '<p>Duration filter value, specified in years or seconds. Specify this parameter to show only reservations for this duration.</p> <p>Valid Values: <code>1 | 3 | 31536000 | 94608000</code> </p>', 'DescribeReservedDBInstancesOfferingsMessage$ProductDescription' => '<p>Product description filter value. Specify this parameter to show only the available offerings that contain the specified product description.</p> <note> <p>The results show offerings that partially match the filter value.</p> </note>', 'DescribeReservedDBInstancesOfferingsMessage$OfferingType' => '<p>The offering type filter value. Specify this parameter to show only the available offerings matching the specified offering type.</p> <p>Valid Values: <code>"Partial Upfront" | "All Upfront" | "No Upfront" </code> </p>', 'DescribeReservedDBInstancesOfferingsMessage$Marker' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeSourceRegionsMessage$RegionName' => '<p>The source Amazon Web Services Region name. For example, <code>us-east-1</code>.</p> <p>Constraints:</p> <ul> <li> <p>Must specify a valid Amazon Web Services Region name.</p> </li> </ul>', 'DescribeSourceRegionsMessage$Marker' => '<p>An optional pagination token provided by a previous <code>DescribeSourceRegions</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeTenantDatabasesMessage$DBInstanceIdentifier' => '<p>The user-supplied DB instance identifier, which must match the identifier of an existing instance owned by the Amazon Web Services account. This parameter isn\'t case-sensitive.</p>', 'DescribeTenantDatabasesMessage$TenantDBName' => '<p>The user-supplied tenant database name, which must match the name of an existing tenant database on the specified DB instance owned by your Amazon Web Services account. This parameter isn’t case-sensitive.</p>', 'DescribeTenantDatabasesMessage$Marker' => '<p>An optional pagination token provided by a previous <code>DescribeTenantDatabases</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeValidDBInstanceModificationsMessage$DBInstanceIdentifier' => '<p>The customer identifier or the ARN of your DB instance.</p>', 'DisableHttpEndpointRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the DB cluster.</p>', 'DisableHttpEndpointResponse$ResourceArn' => '<p>The ARN of the DB cluster.</p>', 'DocLink$Text' => '<p>The text with the link to documentation for the recommendation.</p>', 'DocLink$Url' => '<p>The URL for the documentation for the recommendation.</p>', 'DomainMembership$Domain' => '<p>The identifier of the Active Directory Domain.</p>', 'DomainMembership$Status' => '<p>The status of the Active Directory Domain membership for the DB instance or cluster. Values include <code>joined</code>, <code>pending-join</code>, <code>failed</code>, and so on.</p>', 'DomainMembership$FQDN' => '<p>The fully qualified domain name (FQDN) of the Active Directory Domain.</p>', 'DomainMembership$IAMRoleName' => '<p>The name of the IAM role used when making API calls to the Directory Service.</p>', 'DomainMembership$OU' => '<p>The Active Directory organizational unit for the DB instance or cluster.</p>', 'DomainMembership$AuthSecretArn' => '<p>The ARN for the Secrets Manager secret with the credentials for the user that\'s a member of the domain.</p>', 'DownloadDBLogFilePortionDetails$LogFileData' => '<p>Entries from the specified log file.</p>', 'DownloadDBLogFilePortionDetails$Marker' => '<p>A pagination token that can be used in a later <code>DownloadDBLogFilePortion</code> request.</p>', 'DownloadDBLogFilePortionMessage$DBInstanceIdentifier' => '<p>The customer-assigned name of the DB instance that contains the log files you want to list.</p> <p>Constraints:</p> <ul> <li> <p>Must match the identifier of an existing DBInstance.</p> </li> </ul>', 'DownloadDBLogFilePortionMessage$LogFileName' => '<p>The name of the log file to be downloaded.</p>', 'DownloadDBLogFilePortionMessage$Marker' => '<p>The pagination token provided in the previous request or "0". If the Marker parameter is specified the response includes only records beyond the marker until the end of the file or up to NumberOfLines.</p>', 'EC2SecurityGroup$Status' => '<p>Provides the status of the EC2 security group. Status can be "authorizing", "authorized", "revoking", and "revoked".</p>', 'EC2SecurityGroup$EC2SecurityGroupName' => '<p>Specifies the name of the EC2 security group.</p>', 'EC2SecurityGroup$EC2SecurityGroupId' => '<p>Specifies the id of the EC2 security group.</p>', 'EC2SecurityGroup$EC2SecurityGroupOwnerId' => '<p>Specifies the Amazon Web Services ID of the owner of the EC2 security group specified in the <code>EC2SecurityGroupName</code> field.</p>', 'EnableHttpEndpointRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the DB cluster.</p>', 'EnableHttpEndpointResponse$ResourceArn' => '<p>The ARN of the DB cluster.</p>', 'EncryptionContextMap$key' => NULL, 'EncryptionContextMap$value' => NULL, 'Endpoint$Address' => '<p>Specifies the DNS address of the DB instance.</p>', 'Endpoint$HostedZoneId' => '<p>Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.</p>', 'EngineDefaults$DBParameterGroupFamily' => '<p>Specifies the name of the DB parameter group family that the engine default parameters apply to.</p>', 'EngineDefaults$Marker' => '<p>An optional pagination token provided by a previous EngineDefaults request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> .</p>', 'EngineModeList$member' => NULL, 'Event$SourceIdentifier' => '<p>Provides the identifier for the source of the event.</p>', 'Event$Message' => '<p>Provides the text of this event.</p>', 'Event$SourceArn' => '<p>The Amazon Resource Name (ARN) for the event.</p>', 'EventCategoriesList$member' => NULL, 'EventCategoriesMap$SourceType' => '<p>The source type that the returned categories belong to</p>', 'EventSubscription$CustomerAwsId' => '<p>The Amazon Web Services customer account associated with the RDS event notification subscription.</p>', 'EventSubscription$CustSubscriptionId' => '<p>The RDS event notification subscription Id.</p>', 'EventSubscription$SnsTopicArn' => '<p>The topic ARN of the RDS event notification subscription.</p>', 'EventSubscription$Status' => '<p>The status of the RDS event notification subscription.</p> <p>Constraints:</p> <p>Can be one of the following: creating | modifying | deleting | active | no-permission | topic-not-exist</p> <p>The status "no-permission" indicates that RDS no longer has permission to post to the SNS topic. The status "topic-not-exist" indicates that the topic was deleted after the subscription was created.</p>', 'EventSubscription$SubscriptionCreationTime' => '<p>The time the RDS event notification subscription was created.</p>', 'EventSubscription$SourceType' => '<p>The source type for the RDS event notification subscription.</p>', 'EventSubscription$EventSubscriptionArn' => '<p>The Amazon Resource Name (ARN) for the event subscription.</p>', 'EventSubscriptionsMessage$Marker' => '<p>An optional pagination token provided by a previous DescribeOrderableDBInstanceOptions request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'EventsMessage$Marker' => '<p>An optional pagination token provided by a previous Events request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'ExportTask$ExportTaskIdentifier' => '<p>A unique identifier for the snapshot or cluster export task. This ID isn\'t an identifier for the Amazon S3 bucket where the data is exported.</p>', 'ExportTask$SourceArn' => '<p>The Amazon Resource Name (ARN) of the snapshot or cluster exported to Amazon S3.</p>', 'ExportTask$S3Bucket' => '<p>The Amazon S3 bucket where the snapshot or cluster is exported to.</p>', 'ExportTask$S3Prefix' => '<p>The Amazon S3 bucket prefix that is the file name and path of the exported data.</p>', 'ExportTask$IamRoleArn' => '<p>The name of the IAM role that is used to write to Amazon S3 when exporting a snapshot or cluster.</p>', 'ExportTask$KmsKeyId' => '<p>The key identifier of the Amazon Web Services KMS key that is used to encrypt the data when it\'s exported to Amazon S3. The KMS key identifier is its key ARN, key ID, alias ARN, or alias name. The IAM role used for the export must have encryption and decryption permissions to use this KMS key.</p>', 'ExportTask$Status' => '<p>The progress status of the export task. The status can be one of the following:</p> <ul> <li> <p> <code>CANCELED</code> </p> </li> <li> <p> <code>CANCELING</code> </p> </li> <li> <p> <code>COMPLETE</code> </p> </li> <li> <p> <code>FAILED</code> </p> </li> <li> <p> <code>IN_PROGRESS</code> </p> </li> <li> <p> <code>STARTING</code> </p> </li> </ul>', 'ExportTask$FailureCause' => '<p>The reason the export failed, if it failed.</p>', 'ExportTask$WarningMessage' => '<p>A warning about the snapshot or cluster export task.</p>', 'ExportTasksMessage$Marker' => '<p>A pagination token that can be used in a later <code>DescribeExportTasks</code> request. A marker is used for pagination to identify the location to begin output for the next response of <code>DescribeExportTasks</code>.</p>', 'FailoverDBClusterMessage$DBClusterIdentifier' => '<p>The identifier of the DB cluster to force a failover for. This parameter isn\'t case-sensitive.</p> <p>Constraints:</p> <ul> <li> <p>Must match the identifier of an existing DB cluster.</p> </li> </ul>', 'FailoverDBClusterMessage$TargetDBInstanceIdentifier' => '<p>The name of the DB instance to promote to the primary DB instance.</p> <p>Specify the DB instance identifier for an Aurora Replica or a Multi-AZ readable standby in the DB cluster, for example <code>mydbcluster-replica1</code>.</p> <p>This setting isn\'t supported for RDS for MySQL Multi-AZ DB clusters.</p>', 'FailoverState$FromDbClusterArn' => '<p>The Amazon Resource Name (ARN) of the Aurora DB cluster that is currently being demoted, and which is associated with this state.</p>', 'FailoverState$ToDbClusterArn' => '<p>The Amazon Resource Name (ARN) of the Aurora DB cluster that is currently being promoted, and which is associated with this state.</p>', 'FeatureNameList$member' => NULL, 'Filter$Name' => '<p>The name of the filter. Filter names are case-sensitive.</p>', 'FilterValueList$member' => NULL, 'GlobalCluster$GlobalClusterIdentifier' => '<p>Contains a user-supplied global database cluster identifier. This identifier is the unique key that identifies a global database cluster.</p>', 'GlobalCluster$GlobalClusterResourceId' => '<p>The Amazon Web Services Region-unique, immutable identifier for the global database cluster. This identifier is found in Amazon Web Services CloudTrail log entries whenever the Amazon Web Services KMS key for the DB cluster is accessed.</p>', 'GlobalCluster$GlobalClusterArn' => '<p>The Amazon Resource Name (ARN) for the global database cluster.</p>', 'GlobalCluster$Status' => '<p>Specifies the current state of this global database cluster.</p>', 'GlobalCluster$Engine' => '<p>The Aurora database engine used by the global database cluster.</p>', 'GlobalCluster$EngineVersion' => '<p>Indicates the database engine version.</p>', 'GlobalCluster$EngineLifecycleSupport' => '<p>The life cycle type for the global cluster.</p> <p>For more information, see CreateGlobalCluster.</p>', 'GlobalCluster$DatabaseName' => '<p>The default database name within the new global database cluster.</p>', 'GlobalClusterMember$DBClusterArn' => '<p>The Amazon Resource Name (ARN) for each Aurora DB cluster in the global cluster.</p>', 'GlobalClustersMessage$Marker' => '<p>An optional pagination token provided by a previous <code>DescribeGlobalClusters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'IPRange$Status' => '<p>The status of the IP range. Status can be "authorizing", "authorized", "revoking", and "revoked".</p>', 'IPRange$CIDRIP' => '<p>The IP range.</p>', 'Integration$KMSKeyId' => '<p>The Amazon Web Services Key Management System (Amazon Web Services KMS) key identifier for the key used to to encrypt the integration. </p>', 'IntegrationError$ErrorCode' => '<p>The error code associated with the integration.</p>', 'IntegrationError$ErrorMessage' => '<p>A message explaining the error.</p>', 'KeyList$member' => NULL, 'ListTagsForResourceMessage$ResourceName' => '<p>The Amazon RDS resource with tags to be listed. This value is an Amazon Resource Name (ARN). For information about creating an ARN, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing"> Constructing an ARN for Amazon RDS</a> in the <i>Amazon RDS User Guide</i>.</p>', 'LogTypeList$member' => NULL, 'MasterUserSecret$SecretArn' => '<p>The Amazon Resource Name (ARN) of the secret.</p>', 'MasterUserSecret$SecretStatus' => '<p>The status of the secret.</p> <p>The possible status values include the following:</p> <ul> <li> <p> <code>creating</code> - The secret is being created.</p> </li> <li> <p> <code>active</code> - The secret is available for normal use and rotation.</p> </li> <li> <p> <code>rotating</code> - The secret is being rotated.</p> </li> <li> <p> <code>impaired</code> - The secret can be used to access database credentials, but it can\'t be rotated. A secret might have this status if, for example, permissions are changed so that RDS can no longer access either the secret or the KMS key for the secret.</p> <p>When a secret has this status, you can correct the condition that caused the status. Alternatively, modify the DB instance to turn off automatic management of database credentials, and then modify the DB instance again to turn on automatic management of database credentials.</p> </li> </ul>', 'MasterUserSecret$KmsKeyId' => '<p>The Amazon Web Services KMS key identifier that is used to encrypt the secret.</p>', 'Metric$Name' => '<p>The name of a metric.</p>', 'Metric$StatisticsDetails' => '<p>The details of different statistics for a metric. The description might contain markdown.</p>', 'MetricReference$Name' => '<p>The name of the metric reference.</p>', 'MinimumEngineVersionPerAllowedValue$AllowedValue' => '<p>The allowed value for an option setting.</p>', 'MinimumEngineVersionPerAllowedValue$MinimumEngineVersion' => '<p>The minimum DB engine version required for the allowed value.</p>', 'ModifyActivityStreamRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the RDS for Oracle or Microsoft SQL Server DB instance. For example, <code>arn:aws:rds:us-east-1:12345667890:db:my-orcl-db</code>.</p>', 'ModifyActivityStreamResponse$KmsKeyId' => '<p>The Amazon Web Services KMS key identifier for encryption of messages in the database activity stream.</p>', 'ModifyActivityStreamResponse$KinesisStreamName' => '<p>The name of the Amazon Kinesis data stream to be used for the database activity stream.</p>', 'ModifyCertificatesMessage$CertificateIdentifier' => '<p>The new default certificate identifier to override the current one with.</p> <p>To determine the valid values, use the <code>describe-certificates</code> CLI command or the <code>DescribeCertificates</code> API operation.</p>', 'ModifyCurrentDBClusterCapacityMessage$DBClusterIdentifier' => '<p>The DB cluster identifier for the cluster being modified. This parameter isn\'t case-sensitive.</p> <p>Constraints:</p> <ul> <li> <p>Must match the identifier of an existing DB cluster.</p> </li> </ul>', 'ModifyCurrentDBClusterCapacityMessage$TimeoutAction' => '<p>The action to take when the timeout is reached, either <code>ForceApplyCapacityChange</code> or <code>RollbackCapacityChange</code>.</p> <p> <code>ForceApplyCapacityChange</code>, the default, sets the capacity to the specified value as soon as possible.</p> <p> <code>RollbackCapacityChange</code> ignores the capacity change if a scaling point isn\'t found in the timeout period.</p>', 'ModifyDBClusterEndpointMessage$DBClusterEndpointIdentifier' => '<p>The identifier of the endpoint to modify. This parameter is stored as a lowercase string.</p>', 'ModifyDBClusterEndpointMessage$EndpointType' => '<p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.</p>', 'ModifyDBClusterMessage$DBClusterIdentifier' => '<p>The DB cluster identifier for the cluster being modified. This parameter isn\'t case-sensitive.</p> <p>Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters</p> <p>Constraints:</p> <ul> <li> <p>Must match the identifier of an existing DB cluster.</p> </li> </ul>', 'ModifyDBClusterMessage$NewDBClusterIdentifier' => '<p>The new DB cluster identifier for the DB cluster when renaming a DB cluster. This value is stored as a lowercase string.</p> <p>Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters</p> <p>Constraints:</p> <ul> <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li> <li> <p>The first character must be a letter.</p> </li> <li> <p>Can\'t end with a hyphen or contain two consecutive hyphens.</p> </li> </ul> <p>Example: <code>my-cluster2</code> </p>', 'ModifyDBClusterMessage$DBClusterParameterGroupName' => '<p>The name of the DB cluster parameter group to use for the DB cluster.</p> <p>Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters</p>', 'ModifyDBClusterMessage$MasterUserPassword' => '<p>The new password for the master database user.</p> <p>Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters</p> <p>Constraints:</p> <ul> <li> <p>Must contain from 8 to 41 characters.</p> </li> <li> <p>Can contain any printable ASCII character except "/", """, or "@".</p> </li> <li> <p>Can\'t be specified if <code>ManageMasterUserPassword</code> is turned on.</p> </li> </ul>', 'ModifyDBClusterMessage$OptionGroupName' => '<p>The option group to associate the DB cluster with.</p> <p>DB clusters are associated with a default option group that can\'t be modified.</p>', 'ModifyDBClusterMessage$PreferredBackupWindow' => '<p>The daily time range during which automated backups are created if automated backups are enabled, using the <code>BackupRetentionPeriod</code> parameter.</p> <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region. To view the time blocks available, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.Backups.BackupWindow"> Backup window</a> in the <i>Amazon Aurora User Guide</i>.</p> <p>Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters</p> <p>Constraints:</p> <ul> <li> <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p> </li> <li> <p>Must be in Universal Coordinated Time (UTC).</p> </li> <li> <p>Must not conflict with the preferred maintenance window.</p> </li> <li> <p>Must be at least 30 minutes.</p> </li> </ul>', 'ModifyDBClusterMessage$PreferredMaintenanceWindow' => '<p>The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).</p> <p>Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters</p> <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region, occurring on a random day of the week. To see the time blocks available, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora"> Adjusting the Preferred DB Cluster Maintenance Window</a> in the <i>Amazon Aurora User Guide</i>.</p> <p>Constraints:</p> <ul> <li> <p>Must be in the format <code>ddd:hh24:mi-ddd:hh24:mi</code>.</p> </li> <li> <p>Days must be one of <code>Mon | Tue | Wed | Thu | Fri | Sat | Sun</code>.</p> </li> <li> <p>Must be in Universal Coordinated Time (UTC).</p> </li> <li> <p>Must be at least 30 minutes.</p> </li> </ul>', 'ModifyDBClusterMessage$EngineVersion' => '<p>The version number of the database engine to which you want to upgrade. Changing this parameter results in an outage. The change is applied during the next maintenance window unless <code>ApplyImmediately</code> is enabled.</p> <p>If the cluster that you\'re modifying has one or more read replicas, all replicas must be running an engine version that\'s the same or later than the version you specify.</p> <p>To list all of the available engine versions for Aurora MySQL, use the following command:</p> <p> <code>aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"</code> </p> <p>To list all of the available engine versions for Aurora PostgreSQL, use the following command:</p> <p> <code>aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"</code> </p> <p>To list all of the available engine versions for RDS for MySQL, use the following command:</p> <p> <code>aws rds describe-db-engine-versions --engine mysql --query "DBEngineVersions[].EngineVersion"</code> </p> <p>To list all of the available engine versions for RDS for PostgreSQL, use the following command:</p> <p> <code>aws rds describe-db-engine-versions --engine postgres --query "DBEngineVersions[].EngineVersion"</code> </p> <p>Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters</p>', 'ModifyDBClusterMessage$DBInstanceParameterGroupName' => '<p>The name of the DB parameter group to apply to all instances of the DB cluster.</p> <note> <p>When you apply a parameter group using the <code>DBInstanceParameterGroupName</code> parameter, the DB cluster isn\'t rebooted automatically. Also, parameter changes are applied immediately rather than during the next maintenance window.</p> </note> <p>Valid for Cluster Type: Aurora DB clusters only</p> <p>Default: The existing name setting</p> <p>Constraints:</p> <ul> <li> <p>The DB parameter group must be in the same DB parameter group family as this DB cluster.</p> </li> <li> <p>The <code>DBInstanceParameterGroupName</code> parameter is valid in combination with the <code>AllowMajorVersionUpgrade</code> parameter for a major version upgrade only.</p> </li> </ul>', 'ModifyDBClusterMessage$Domain' => '<p>The Active Directory directory ID to move the DB cluster to. Specify <code>none</code> to remove the cluster from its current domain. The domain must be created prior to this operation.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/kerberos-authentication.html">Kerberos Authentication</a> in the <i>Amazon Aurora User Guide</i>.</p> <p>Valid for Cluster Type: Aurora DB clusters only</p>', 'ModifyDBClusterMessage$DomainIAMRoleName' => '<p>The name of the IAM role to use when making API calls to the Directory Service.</p> <p>Valid for Cluster Type: Aurora DB clusters only</p>', 'ModifyDBClusterMessage$DBClusterInstanceClass' => '<p>The compute and memory capacity of each DB instance in the Multi-AZ DB cluster, for example <code>db.m6gd.xlarge</code>. Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines.</p> <p>For the full list of DB instance classes and availability for your engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html"> DB Instance Class</a> in the <i>Amazon RDS User Guide</i>.</p> <p>Valid for Cluster Type: Multi-AZ DB clusters only</p>', 'ModifyDBClusterMessage$StorageType' => '<p>The storage type to associate with the DB cluster.</p> <p>For information on storage types for Aurora DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Overview.StorageReliability.html#aurora-storage-type">Storage configurations for Amazon Aurora DB clusters</a>. For information on storage types for Multi-AZ DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/create-multi-az-db-cluster.html#create-multi-az-db-cluster-settings">Settings for creating Multi-AZ DB clusters</a>.</p> <p>When specified for a Multi-AZ DB cluster, a value for the <code>Iops</code> parameter is required.</p> <p>Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters</p> <p>Valid Values:</p> <ul> <li> <p>Aurora DB clusters - <code>aurora | aurora-iopt1</code> </p> </li> <li> <p>Multi-AZ DB clusters - <code>io1 | io2 | gp3</code> </p> </li> </ul> <p>Default:</p> <ul> <li> <p>Aurora DB clusters - <code>aurora</code> </p> </li> <li> <p>Multi-AZ DB clusters - <code>io1</code> </p> </li> </ul>', 'ModifyDBClusterMessage$MonitoringRoleArn' => '<p>The Amazon Resource Name (ARN) for the IAM role that permits RDS to send Enhanced Monitoring metrics to Amazon CloudWatch Logs. An example is <code>arn:aws:iam:123456789012:role/emaccess</code>. For information on creating a monitoring role, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html#USER_Monitoring.OS.IAMRole">To create an IAM role for Amazon RDS Enhanced Monitoring</a> in the <i>Amazon RDS User Guide.</i> </p> <p>If <code>MonitoringInterval</code> is set to a value other than <code>0</code>, supply a <code>MonitoringRoleArn</code> value.</p> <p>Valid for Cluster Type: Multi-AZ DB clusters only</p>', 'ModifyDBClusterMessage$PerformanceInsightsKMSKeyId' => '<p>The Amazon Web Services KMS key identifier for encryption of Performance Insights data.</p> <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p> <p>If you don\'t specify a value for <code>PerformanceInsightsKMSKeyId</code>, then Amazon RDS uses your default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.</p> <p>Valid for Cluster Type: Multi-AZ DB clusters only</p>', 'ModifyDBClusterMessage$NetworkType' => '<p>The network type of the DB cluster.</p> <p>The network type is determined by the <code>DBSubnetGroup</code> specified for the DB cluster. A <code>DBSubnetGroup</code> can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (<code>DUAL</code>).</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html"> Working with a DB instance in a VPC</a> in the <i>Amazon Aurora User Guide.</i> </p> <p>Valid for Cluster Type: Aurora DB clusters only</p> <p>Valid Values: <code>IPV4 | DUAL</code> </p>', 'ModifyDBClusterMessage$MasterUserSecretKmsKeyId' => '<p>The Amazon Web Services KMS key identifier to encrypt a secret that is automatically generated and managed in Amazon Web Services Secrets Manager.</p> <p>This setting is valid only if both of the following conditions are met:</p> <ul> <li> <p>The DB cluster doesn\'t manage the master user password in Amazon Web Services Secrets Manager.</p> <p>If the DB cluster already manages the master user password in Amazon Web Services Secrets Manager, you can\'t change the KMS key that is used to encrypt the secret.</p> </li> <li> <p>You are turning on <code>ManageMasterUserPassword</code> to manage the master user password in Amazon Web Services Secrets Manager.</p> <p>If you are turning on <code>ManageMasterUserPassword</code> and don\'t specify <code>MasterUserSecretKmsKeyId</code>, then the <code>aws/secretsmanager</code> KMS key is used to encrypt the secret. If the secret is in a different Amazon Web Services account, then you can\'t use the <code>aws/secretsmanager</code> KMS key to encrypt the secret, and you must use a customer managed KMS key.</p> </li> </ul> <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.</p> <p>There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.</p> <p>Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters</p>', 'ModifyDBClusterMessage$EngineMode' => '<p>The DB engine mode of the DB cluster, either <code>provisioned</code> or <code>serverless</code>.</p> <note> <p>The DB engine mode can be modified only from <code>serverless</code> to <code>provisioned</code>.</p> </note> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBCluster.html"> CreateDBCluster</a>.</p> <p>Valid for Cluster Type: Aurora DB clusters only</p>', 'ModifyDBClusterMessage$CACertificateIdentifier' => '<p>The CA certificate identifier to use for the DB cluster\'s server certificate.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html">Using SSL/TLS to encrypt a connection to a DB instance</a> in the <i>Amazon RDS User Guide</i>.</p> <p>Valid for Cluster Type: Multi-AZ DB clusters</p>', 'ModifyDBClusterParameterGroupMessage$DBClusterParameterGroupName' => '<p>The name of the DB cluster parameter group to modify.</p>', 'ModifyDBClusterSnapshotAttributeMessage$DBClusterSnapshotIdentifier' => '<p>The identifier for the DB cluster snapshot to modify the attributes for.</p>', 'ModifyDBClusterSnapshotAttributeMessage$AttributeName' => '<p>The name of the DB cluster snapshot attribute to modify.</p> <p>To manage authorization for other Amazon Web Services accounts to copy or restore a manual DB cluster snapshot, set this value to <code>restore</code>.</p> <note> <p>To view the list of attributes available to modify, use the <a>DescribeDBClusterSnapshotAttributes</a> API operation.</p> </note>', 'ModifyDBInstanceMessage$DBInstanceIdentifier' => '<p>The identifier of DB instance to modify. This value is stored as a lowercase string.</p> <p>Constraints:</p> <ul> <li> <p>Must match the identifier of an existing DB instance.</p> </li> </ul>', 'ModifyDBInstanceMessage$DBInstanceClass' => '<p>The new compute and memory capacity of the DB instance, for example <code>db.m4.large</code>. Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines. For the full list of DB instance classes, and availability for your engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB Instance Class</a> in the <i>Amazon RDS User Guide</i> or <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.DBInstanceClass.html">Aurora DB instance classes</a> in the <i>Amazon Aurora User Guide</i>. For RDS Custom, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-reqs-limits.html#custom-reqs-limits.instances">DB instance class support for RDS Custom for Oracle</a> and <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-reqs-limits-MS.html#custom-reqs-limits.instancesMS"> DB instance class support for RDS Custom for SQL Server</a>.</p> <p>If you modify the DB instance class, an outage occurs during the change. The change is applied during the next maintenance window, unless you specify <code>ApplyImmediately</code> in your request. </p> <p>Default: Uses existing setting</p> <p>Constraints:</p> <ul> <li> <p>If you are modifying the DB instance class and upgrading the engine version at the same time, the currently running engine version must be supported on the specified DB instance class. Otherwise, the operation returns an error. In this case, first run the operation to upgrade the engine version, and then run it again to modify the DB instance class.</p> </li> </ul>', 'ModifyDBInstanceMessage$DBSubnetGroupName' => '<p>The new DB subnet group for the DB instance. You can use this parameter to move your DB instance to a different VPC. If your DB instance isn\'t in a VPC, you can also use this parameter to move your DB instance into a VPC. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html#USER_VPC.Non-VPC2VPC">Working with a DB instance in a VPC</a> in the <i>Amazon RDS User Guide</i>.</p> <p>Changing the subnet group causes an outage during the change. The change is applied during the next maintenance window, unless you enable <code>ApplyImmediately</code>.</p> <p>This setting doesn\'t apply to RDS Custom DB instances.</p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match existing DB subnet group.</p> </li> </ul> <p>Example: <code>mydbsubnetgroup</code> </p>', 'ModifyDBInstanceMessage$MasterUserPassword' => '<p>The new password for the master user.</p> <p>Changing this parameter doesn\'t result in an outage and the change is asynchronously applied as soon as possible. Between the time of the request and the completion of the request, the <code>MasterUserPassword</code> element exists in the <code>PendingModifiedValues</code> element of the operation response.</p> <note> <p>Amazon RDS API operations never return the password, so this operation provides a way to regain access to a primary instance user if the password is lost. This includes restoring privileges that might have been accidentally revoked.</p> </note> <p>This setting doesn\'t apply to the following DB instances:</p> <ul> <li> <p>Amazon Aurora (The password for the master user is managed by the DB cluster. For more information, see <code>ModifyDBCluster</code>.)</p> </li> <li> <p>RDS Custom</p> </li> </ul> <p>Default: Uses existing setting</p> <p>Constraints:</p> <ul> <li> <p>Can\'t be specified if <code>ManageMasterUserPassword</code> is turned on.</p> </li> <li> <p>Can include any printable ASCII character except "/", """, or "@". For RDS for Oracle, can\'t include the "&amp;" (ampersand) or the "\'" (single quotes) character.</p> </li> </ul> <p>Length Constraints:</p> <ul> <li> <p>RDS for Db2 - Must contain from 8 to 255 characters.</p> </li> <li> <p>RDS for MariaDB - Must contain from 8 to 41 characters.</p> </li> <li> <p>RDS for Microsoft SQL Server - Must contain from 8 to 128 characters.</p> </li> <li> <p>RDS for MySQL - Must contain from 8 to 41 characters.</p> </li> <li> <p>RDS for Oracle - Must contain from 8 to 30 characters.</p> </li> <li> <p>RDS for PostgreSQL - Must contain from 8 to 128 characters.</p> </li> </ul>', 'ModifyDBInstanceMessage$DBParameterGroupName' => '<p>The name of the DB parameter group to apply to the DB instance.</p> <p>Changing this setting doesn\'t result in an outage. The parameter group name itself is changed immediately, but the actual parameter changes are not applied until you reboot the instance without failover. In this case, the DB instance isn\'t rebooted automatically, and the parameter changes aren\'t applied during the next maintenance window. However, if you modify dynamic parameters in the newly associated DB parameter group, these changes are applied immediately without a reboot.</p> <p>This setting doesn\'t apply to RDS Custom DB instances.</p> <p>Default: Uses existing setting</p> <p>Constraints:</p> <ul> <li> <p>Must be in the same DB parameter group family as the DB instance.</p> </li> </ul>', 'ModifyDBInstanceMessage$PreferredBackupWindow' => '<p>The daily time range during which automated backups are created if automated backups are enabled, as determined by the <code>BackupRetentionPeriod</code> parameter. Changing this parameter doesn\'t result in an outage and the change is asynchronously applied as soon as possible. The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow">Backup window</a> in the <i>Amazon RDS User Guide</i>.</p> <p>This setting doesn\'t apply to Amazon Aurora DB instances. The daily time range for creating automated backups is managed by the DB cluster. For more information, see <code>ModifyDBCluster</code>.</p> <p>Constraints:</p> <ul> <li> <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p> </li> <li> <p>Must be in Universal Coordinated Time (UTC).</p> </li> <li> <p>Must not conflict with the preferred maintenance window.</p> </li> <li> <p>Must be at least 30 minutes.</p> </li> </ul>', 'ModifyDBInstanceMessage$PreferredMaintenanceWindow' => '<p>The weekly time range during which system maintenance can occur, which might result in an outage. Changing this parameter doesn\'t result in an outage, except in the following situation, and the change is asynchronously applied as soon as possible. If there are pending actions that cause a reboot, and the maintenance window is changed to include the current time, then changing this parameter causes a reboot of the DB instance. If you change this window to the current time, there must be at least 30 minutes between the current time and end of the window to ensure pending changes are applied.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance">Amazon RDS Maintenance Window</a> in the <i>Amazon RDS User Guide.</i> </p> <p>Default: Uses existing setting</p> <p>Constraints:</p> <ul> <li> <p>Must be in the format <code>ddd:hh24:mi-ddd:hh24:mi</code>.</p> </li> <li> <p>The day values must be <code>mon | tue | wed | thu | fri | sat | sun</code>. </p> </li> <li> <p>Must be in Universal Coordinated Time (UTC).</p> </li> <li> <p>Must not conflict with the preferred backup window.</p> </li> <li> <p>Must be at least 30 minutes.</p> </li> </ul>', 'ModifyDBInstanceMessage$EngineVersion' => '<p>The version number of the database engine to upgrade to. Changing this parameter results in an outage and the change is applied during the next maintenance window unless the <code>ApplyImmediately</code> parameter is enabled for this request.</p> <p>For major version upgrades, if a nondefault DB parameter group is currently in use, a new DB parameter group in the DB parameter group family for the new engine version must be specified. The new DB parameter group can be the default for that DB parameter group family.</p> <p>If you specify only a major version, Amazon RDS updates the DB instance to the default minor version if the current minor version is lower. For information about valid engine versions, see <code>CreateDBInstance</code>, or call <code>DescribeDBEngineVersions</code>.</p> <p>If the instance that you\'re modifying is acting as a read replica, the engine version that you specify must be the same or higher than the version that the source DB instance or cluster is running.</p> <p>In RDS Custom for Oracle, this parameter is supported for read replicas only if they are in the <code>PATCH_DB_FAILURE</code> lifecycle.</p> <p>Constraints:</p> <ul> <li> <p>If you are upgrading the engine version and modifying the DB instance class at the same time, the currently running engine version must be supported on the specified DB instance class. Otherwise, the operation returns an error. In this case, first run the operation to upgrade the engine version, and then run it again to modify the DB instance class.</p> </li> </ul>', 'ModifyDBInstanceMessage$LicenseModel' => '<p>The license model for the DB instance.</p> <p>This setting doesn\'t apply to Amazon Aurora or RDS Custom DB instances.</p> <p>Valid Values:</p> <ul> <li> <p>RDS for Db2 - <code>bring-your-own-license</code> </p> </li> <li> <p>RDS for MariaDB - <code>general-public-license</code> </p> </li> <li> <p>RDS for Microsoft SQL Server - <code>license-included</code> </p> </li> <li> <p>RDS for MySQL - <code>general-public-license</code> </p> </li> <li> <p>RDS for Oracle - <code>bring-your-own-license | license-included</code> </p> </li> <li> <p>RDS for PostgreSQL - <code>postgresql-license</code> </p> </li> </ul>', 'ModifyDBInstanceMessage$OptionGroupName' => '<p>The option group to associate the DB instance with.</p> <p>Changing this parameter doesn\'t result in an outage, with one exception. If the parameter change results in an option group that enables OEM, it can cause a brief period, lasting less than a second, during which new connections are rejected but existing connections aren\'t interrupted.</p> <p>The change is applied during the next maintenance window unless the <code>ApplyImmediately</code> parameter is enabled for this request.</p> <p>Permanent options, such as the TDE option for Oracle Advanced Security TDE, can\'t be removed from an option group, and that option group can\'t be removed from a DB instance after it is associated with a DB instance.</p> <p>This setting doesn\'t apply to RDS Custom DB instances.</p>', 'ModifyDBInstanceMessage$NewDBInstanceIdentifier' => '<p>The new identifier for the DB instance when renaming a DB instance. When you change the DB instance identifier, an instance reboot occurs immediately if you enable <code>ApplyImmediately</code>, or will occur during the next maintenance window if you disable <code>ApplyImmediately</code>. This value is stored as a lowercase string.</p> <p>This setting doesn\'t apply to RDS Custom DB instances.</p> <p>Constraints:</p> <ul> <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li> <li> <p>The first character must be a letter.</p> </li> <li> <p>Can\'t end with a hyphen or contain two consecutive hyphens.</p> </li> </ul> <p>Example: <code>mydbinstance</code> </p>', 'ModifyDBInstanceMessage$StorageType' => '<p>The storage type to associate with the DB instance.</p> <p>If you specify <code>io1</code>, <code>io2</code>, or <code>gp3</code> you must also include a value for the <code>Iops</code> parameter.</p> <p>If you choose to migrate your DB instance from using standard storage to using Provisioned IOPS, or from using Provisioned IOPS to using standard storage, the process can take time. The duration of the migration depends on several factors such as database load, storage size, storage type (standard or Provisioned IOPS), amount of IOPS provisioned (if any), and the number of prior scale storage operations. Typical migration times are under 24 hours, but the process can take up to several days in some cases. During the migration, the DB instance is available for use, but might experience performance degradation. While the migration takes place, nightly backups for the instance are suspended. No other Amazon RDS operations can take place for the instance, including modifying the instance, rebooting the instance, deleting the instance, creating a read replica for the instance, and creating a DB snapshot of the instance.</p> <p>Valid Values: <code>gp2 | gp3 | io1 | io2 | standard</code> </p> <p>Default: <code>io1</code>, if the <code>Iops</code> parameter is specified. Otherwise, <code>gp2</code>.</p>', 'ModifyDBInstanceMessage$TdeCredentialArn' => '<p>The ARN from the key store with which to associate the instance for TDE encryption.</p> <p>This setting doesn\'t apply to RDS Custom DB instances.</p>', 'ModifyDBInstanceMessage$TdeCredentialPassword' => '<p>The password for the given ARN from the key store in order to access the device.</p> <p>This setting doesn\'t apply to RDS Custom DB instances.</p>', 'ModifyDBInstanceMessage$CACertificateIdentifier' => '<p>The CA certificate identifier to use for the DB instance\'s server certificate.</p> <p>This setting doesn\'t apply to RDS Custom DB instances.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html">Using SSL/TLS to encrypt a connection to a DB instance</a> in the <i>Amazon RDS User Guide</i> and <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html"> Using SSL/TLS to encrypt a connection to a DB cluster</a> in the <i>Amazon Aurora User Guide</i>.</p>', 'ModifyDBInstanceMessage$Domain' => '<p>The Active Directory directory ID to move the DB instance to. Specify <code>none</code> to remove the instance from its current domain. You must create the domain before this operation. Currently, you can create only Db2, MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB instances in an Active Directory Domain.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html"> Kerberos Authentication</a> in the <i>Amazon RDS User Guide</i>.</p> <p>This setting doesn\'t apply to RDS Custom DB instances.</p>', 'ModifyDBInstanceMessage$DomainFqdn' => '<p>The fully qualified domain name (FQDN) of an Active Directory domain.</p> <p>Constraints:</p> <ul> <li> <p>Can\'t be longer than 64 characters.</p> </li> </ul> <p>Example: <code>mymanagedADtest.mymanagedAD.mydomain</code> </p>', 'ModifyDBInstanceMessage$DomainOu' => '<p>The Active Directory organizational unit for your DB instance to join.</p> <p>Constraints:</p> <ul> <li> <p>Must be in the distinguished name format.</p> </li> <li> <p>Can\'t be longer than 64 characters.</p> </li> </ul> <p>Example: <code>OU=mymanagedADtestOU,DC=mymanagedADtest,DC=mymanagedAD,DC=mydomain</code> </p>', 'ModifyDBInstanceMessage$DomainAuthSecretArn' => '<p>The ARN for the Secrets Manager secret with the credentials for the user joining the domain.</p> <p>Example: <code>arn:aws:secretsmanager:region:account-number:secret:myselfmanagedADtestsecret-123456</code> </p>', 'ModifyDBInstanceMessage$MonitoringRoleArn' => '<p>The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs. For example, <code>arn:aws:iam:123456789012:role/emaccess</code>. For information on creating a monitoring role, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html#USER_Monitoring.OS.IAMRole">To create an IAM role for Amazon RDS Enhanced Monitoring</a> in the <i>Amazon RDS User Guide.</i> </p> <p>If <code>MonitoringInterval</code> is set to a value other than <code>0</code>, supply a <code>MonitoringRoleArn</code> value.</p> <p>This setting doesn\'t apply to RDS Custom DB instances.</p>', 'ModifyDBInstanceMessage$DomainIAMRoleName' => '<p>The name of the IAM role to use when making API calls to the Directory Service.</p> <p>This setting doesn\'t apply to RDS Custom DB instances.</p>', 'ModifyDBInstanceMessage$PerformanceInsightsKMSKeyId' => '<p>The Amazon Web Services KMS key identifier for encryption of Performance Insights data.</p> <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p> <p>If you don\'t specify a value for <code>PerformanceInsightsKMSKeyId</code>, then Amazon RDS uses your default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.</p> <p>This setting doesn\'t apply to RDS Custom DB instances.</p>', 'ModifyDBInstanceMessage$NetworkType' => '<p>The network type of the DB instance.</p> <p>The network type is determined by the <code>DBSubnetGroup</code> specified for the DB instance. A <code>DBSubnetGroup</code> can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (<code>DUAL</code>).</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html"> Working with a DB instance in a VPC</a> in the <i>Amazon RDS User Guide.</i> </p> <p>Valid Values: <code>IPV4 | DUAL</code> </p>', 'ModifyDBInstanceMessage$MasterUserSecretKmsKeyId' => '<p>The Amazon Web Services KMS key identifier to encrypt a secret that is automatically generated and managed in Amazon Web Services Secrets Manager.</p> <p>This setting is valid only if both of the following conditions are met:</p> <ul> <li> <p>The DB instance doesn\'t manage the master user password in Amazon Web Services Secrets Manager.</p> <p>If the DB instance already manages the master user password in Amazon Web Services Secrets Manager, you can\'t change the KMS key used to encrypt the secret.</p> </li> <li> <p>You are turning on <code>ManageMasterUserPassword</code> to manage the master user password in Amazon Web Services Secrets Manager.</p> <p>If you are turning on <code>ManageMasterUserPassword</code> and don\'t specify <code>MasterUserSecretKmsKeyId</code>, then the <code>aws/secretsmanager</code> KMS key is used to encrypt the secret. If the secret is in a different Amazon Web Services account, then you can\'t use the <code>aws/secretsmanager</code> KMS key to encrypt the secret, and you must use a customer managed KMS key.</p> </li> </ul> <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.</p> <p>There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.</p>', 'ModifyDBInstanceMessage$Engine' => '<p>The target Oracle DB engine when you convert a non-CDB to a CDB. This intermediate step is necessary to upgrade an Oracle Database 19c non-CDB to an Oracle Database 21c CDB.</p> <p>Note the following requirements:</p> <ul> <li> <p>Make sure that you specify <code>oracle-ee-cdb</code> or <code>oracle-se2-cdb</code>.</p> </li> <li> <p>Make sure that your DB engine runs Oracle Database 19c with an April 2021 or later RU.</p> </li> </ul> <p>Note the following limitations:</p> <ul> <li> <p>You can\'t convert a CDB to a non-CDB.</p> </li> <li> <p>You can\'t convert a replica database.</p> </li> <li> <p>You can\'t convert a non-CDB to a CDB and upgrade the engine version in the same command.</p> </li> <li> <p>You can\'t convert the existing custom parameter or option group when it has options or parameters that are permanent or persistent. In this situation, the DB instance reverts to the default option and parameter group. To avoid reverting to the default, specify a new parameter group with <code>--db-parameter-group-name</code> and a new option group with <code>--option-group-name</code>.</p> </li> </ul>', 'ModifyDBParameterGroupMessage$DBParameterGroupName' => '<p>The name of the DB parameter group.</p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match the name of an existing <code>DBParameterGroup</code>.</p> </li> </ul>', 'ModifyDBProxyRequest$DBProxyName' => '<p>The identifier for the <code>DBProxy</code> to modify.</p>', 'ModifyDBProxyRequest$NewDBProxyName' => '<p>The new identifier for the <code>DBProxy</code>. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can\'t end with a hyphen or contain two consecutive hyphens.</p>', 'ModifyDBProxyRequest$RoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that the proxy uses to access secrets in Amazon Web Services Secrets Manager.</p>', 'ModifyDBProxyTargetGroupRequest$TargetGroupName' => '<p>The name of the target group to modify.</p>', 'ModifyDBProxyTargetGroupRequest$DBProxyName' => '<p>The name of the proxy.</p>', 'ModifyDBProxyTargetGroupRequest$NewName' => '<p>The new name for the modified <code>DBProxyTarget</code>. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can\'t end with a hyphen or contain two consecutive hyphens.</p>', 'ModifyDBRecommendationMessage$RecommendationId' => '<p>The identifier of the recommendation to update.</p>', 'ModifyDBRecommendationMessage$Locale' => '<p>The language of the modified recommendation.</p>', 'ModifyDBRecommendationMessage$Status' => '<p>The recommendation status to update.</p> <p>Valid values:</p> <ul> <li> <p>active</p> </li> <li> <p>dismissed</p> </li> </ul>', 'ModifyDBSnapshotAttributeMessage$DBSnapshotIdentifier' => '<p>The identifier for the DB snapshot to modify the attributes for.</p>', 'ModifyDBSnapshotAttributeMessage$AttributeName' => '<p>The name of the DB snapshot attribute to modify.</p> <p>To manage authorization for other Amazon Web Services accounts to copy or restore a manual DB snapshot, set this value to <code>restore</code>.</p> <note> <p>To view the list of attributes available to modify, use the <a>DescribeDBSnapshotAttributes</a> API operation.</p> </note>', 'ModifyDBSnapshotMessage$DBSnapshotIdentifier' => '<p>The identifier of the DB snapshot to modify.</p>', 'ModifyDBSnapshotMessage$EngineVersion' => '<p>The engine version to upgrade the DB snapshot to.</p> <p>The following are the database engines and engine versions that are available when you upgrade a DB snapshot.</p> <p> <b>MySQL</b> </p> <p>For the list of engine versions that are available for upgrading a DB snapshot, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/mysql-upgrade-snapshot.html"> Upgrading a MySQL DB snapshot engine version</a> in the <i>Amazon RDS User Guide.</i> </p> <p> <b>Oracle</b> </p> <ul> <li> <p> <code>19.0.0.0.ru-2022-01.rur-2022-01.r1</code> (supported for 12.2.0.1 DB snapshots)</p> </li> <li> <p> <code>19.0.0.0.ru-2022-07.rur-2022-07.r1</code> (supported for 12.1.0.2 DB snapshots)</p> </li> <li> <p> <code>12.1.0.2.v8</code> (supported for 12.1.0.1 DB snapshots)</p> </li> <li> <p> <code>11.2.0.4.v12</code> (supported for 11.2.0.2 DB snapshots)</p> </li> <li> <p> <code>11.2.0.4.v11</code> (supported for 11.2.0.3 DB snapshots)</p> </li> </ul> <p> <b>PostgreSQL</b> </p> <p>For the list of engine versions that are available for upgrading a DB snapshot, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBSnapshot.PostgreSQL.html"> Upgrading a PostgreSQL DB snapshot engine version</a> in the <i>Amazon RDS User Guide.</i> </p>', 'ModifyDBSnapshotMessage$OptionGroupName' => '<p>The option group to identify with the upgraded DB snapshot.</p> <p>You can specify this parameter when you upgrade an Oracle DB snapshot. The same option group considerations apply when upgrading a DB snapshot as when upgrading a DB instance. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Oracle.html#USER_UpgradeDBInstance.Oracle.OGPG.OG">Option group considerations</a> in the <i>Amazon RDS User Guide.</i> </p>', 'ModifyDBSubnetGroupMessage$DBSubnetGroupName' => '<p>The name for the DB subnet group. This value is stored as a lowercase string. You can\'t modify the default subnet group.</p> <p>Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.</p> <p>Example: <code>mydbsubnetgroup</code> </p>', 'ModifyDBSubnetGroupMessage$DBSubnetGroupDescription' => '<p>The description for the DB subnet group.</p>', 'ModifyEventSubscriptionMessage$SubscriptionName' => '<p>The name of the RDS event notification subscription.</p>', 'ModifyEventSubscriptionMessage$SnsTopicArn' => '<p>The Amazon Resource Name (ARN) of the SNS topic created for event notification. The ARN is created by Amazon SNS when you create a topic and subscribe to it.</p>', 'ModifyEventSubscriptionMessage$SourceType' => '<p>The type of source that is generating the events. For example, if you want to be notified of events generated by a DB instance, you would set this parameter to db-instance. For RDS Proxy events, specify <code>db-proxy</code>. If this value isn\'t specified, all events are returned.</p> <p>Valid Values:<code> db-instance | db-cluster | db-parameter-group | db-security-group | db-snapshot | db-cluster-snapshot | db-proxy | zero-etl | custom-engine-version | blue-green-deployment </code> </p>', 'ModifyGlobalClusterMessage$GlobalClusterIdentifier' => '<p>The cluster identifier for the global cluster to modify. This parameter isn\'t case-sensitive.</p> <p>Constraints:</p> <ul> <li> <p>Must match the identifier of an existing global database cluster.</p> </li> </ul>', 'ModifyGlobalClusterMessage$NewGlobalClusterIdentifier' => '<p>The new cluster identifier for the global database cluster. This value is stored as a lowercase string.</p> <p>Constraints:</p> <ul> <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li> <li> <p>The first character must be a letter.</p> </li> <li> <p>Can\'t end with a hyphen or contain two consecutive hyphens.</p> </li> </ul> <p>Example: <code>my-cluster2</code> </p>', 'ModifyGlobalClusterMessage$EngineVersion' => '<p>The version number of the database engine to which you want to upgrade. </p> <p>To list all of the available engine versions for <code>aurora-mysql</code> (for MySQL-based Aurora global databases), use the following command:</p> <p> <code>aws rds describe-db-engine-versions --engine aurora-mysql --query \'*[]|[?SupportsGlobalDatabases == `true`].[EngineVersion]\'</code> </p> <p>To list all of the available engine versions for <code>aurora-postgresql</code> (for PostgreSQL-based Aurora global databases), use the following command:</p> <p> <code>aws rds describe-db-engine-versions --engine aurora-postgresql --query \'*[]|[?SupportsGlobalDatabases == `true`].[EngineVersion]\'</code> </p>', 'ModifyOptionGroupMessage$OptionGroupName' => '<p>The name of the option group to be modified.</p> <p>Permanent options, such as the TDE option for Oracle Advanced Security TDE, can\'t be removed from an option group, and that option group can\'t be removed from a DB instance once it is associated with a DB instance</p>', 'ModifyTenantDatabaseMessage$DBInstanceIdentifier' => '<p>The identifier of the DB instance that contains the tenant database that you are modifying. This parameter isn\'t case-sensitive.</p> <p>Constraints:</p> <ul> <li> <p>Must match the identifier of an existing DB instance.</p> </li> </ul>', 'ModifyTenantDatabaseMessage$TenantDBName' => '<p>The user-supplied name of the tenant database that you want to modify. This parameter isn’t case-sensitive.</p> <p>Constraints:</p> <ul> <li> <p>Must match the identifier of an existing tenant database.</p> </li> </ul>', 'ModifyTenantDatabaseMessage$NewTenantDBName' => '<p>The new name of the tenant database when renaming a tenant database. This parameter isn’t case-sensitive.</p> <p>Constraints:</p> <ul> <li> <p>Can\'t be the string null or any other reserved word.</p> </li> <li> <p>Can\'t be longer than 8 characters.</p> </li> </ul>', 'Option$OptionName' => '<p>The name of the option.</p>', 'Option$OptionDescription' => '<p>The description of the option.</p>', 'Option$OptionVersion' => '<p>The version of the option.</p>', 'OptionConfiguration$OptionName' => '<p>The configuration of options to include in a group.</p>', 'OptionConfiguration$OptionVersion' => '<p>The version for the option.</p>', 'OptionGroup$OptionGroupName' => '<p>Specifies the name of the option group.</p>', 'OptionGroup$OptionGroupDescription' => '<p>Provides a description of the option group.</p>', 'OptionGroup$EngineName' => '<p>Indicates the name of the engine that this option group can be applied to.</p>', 'OptionGroup$MajorEngineVersion' => '<p>Indicates the major engine version associated with this option group.</p>', 'OptionGroup$VpcId' => '<p>If <b>AllowsVpcAndNonVpcInstanceMemberships</b> is <code>false</code>, this field is blank. If <b>AllowsVpcAndNonVpcInstanceMemberships</b> is <code>true</code> and this field is blank, then this option group can be applied to both VPC and non-VPC instances. If this field contains a value, then this option group can only be applied to instances that are in the VPC indicated by this field.</p>', 'OptionGroup$OptionGroupArn' => '<p>Specifies the Amazon Resource Name (ARN) for the option group.</p>', 'OptionGroup$SourceOptionGroup' => '<p>Specifies the name of the option group from which this option group is copied.</p>', 'OptionGroup$SourceAccountId' => '<p>Specifies the Amazon Web Services account ID for the option group from which this option group is copied.</p>', 'OptionGroupMembership$OptionGroupName' => '<p>The name of the option group that the instance belongs to.</p>', 'OptionGroupMembership$Status' => '<p>The status of the DB instance\'s option group membership. Valid values are: <code>in-sync</code>, <code>pending-apply</code>, <code>pending-removal</code>, <code>pending-maintenance-apply</code>, <code>pending-maintenance-removal</code>, <code>applying</code>, <code>removing</code>, and <code>failed</code>.</p>', 'OptionGroupOption$Name' => '<p>The name of the option.</p>', 'OptionGroupOption$Description' => '<p>The description of the option.</p>', 'OptionGroupOption$EngineName' => '<p>The name of the engine that this option can be applied to.</p>', 'OptionGroupOption$MajorEngineVersion' => '<p>Indicates the major engine version that the option is available for.</p>', 'OptionGroupOption$MinimumRequiredMinorEngineVersion' => '<p>The minimum required engine version for the option to be applied.</p>', 'OptionGroupOptionSetting$SettingName' => '<p>The name of the option group option.</p>', 'OptionGroupOptionSetting$SettingDescription' => '<p>The description of the option group option.</p>', 'OptionGroupOptionSetting$DefaultValue' => '<p>The default value for the option group option.</p>', 'OptionGroupOptionSetting$ApplyType' => '<p>The DB engine specific parameter type for the option group option.</p>', 'OptionGroupOptionSetting$AllowedValues' => '<p>Indicates the acceptable values for the option group option.</p>', 'OptionGroupOptionsMessage$Marker' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'OptionGroups$Marker' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'OptionNamesList$member' => NULL, 'OptionSetting$Name' => '<p>The name of the option that has settings that you can set.</p>', 'OptionSetting$Value' => '<p>The current value of the option setting.</p>', 'OptionSetting$DefaultValue' => '<p>The default value of the option setting.</p>', 'OptionSetting$Description' => '<p>The description of the option setting.</p>', 'OptionSetting$ApplyType' => '<p>The DB engine specific parameter type.</p>', 'OptionSetting$DataType' => '<p>The data type of the option setting.</p>', 'OptionSetting$AllowedValues' => '<p>The allowed values of the option setting.</p>', 'OptionVersion$Version' => '<p>The version of the option.</p>', 'OptionsConflictsWith$member' => NULL, 'OptionsDependedOn$member' => NULL, 'OrderableDBInstanceOption$Engine' => '<p>The engine type of a DB instance.</p>', 'OrderableDBInstanceOption$EngineVersion' => '<p>The engine version of a DB instance.</p>', 'OrderableDBInstanceOption$DBInstanceClass' => '<p>The DB instance class for a DB instance.</p>', 'OrderableDBInstanceOption$LicenseModel' => '<p>The license model for a DB instance.</p>', 'OrderableDBInstanceOption$AvailabilityZoneGroup' => '<p>The Availability Zone group for a DB instance.</p>', 'OrderableDBInstanceOption$StorageType' => '<p>The storage type for a DB instance.</p>', 'OrderableDBInstanceOptionsMessage$Marker' => '<p>An optional pagination token provided by a previous OrderableDBInstanceOptions request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'Outpost$Arn' => '<p>The Amazon Resource Name (ARN) of the Outpost.</p>', 'Parameter$ParameterName' => '<p>The name of the parameter.</p>', 'Parameter$ParameterValue' => '<p>The value of the parameter.</p>', 'Parameter$Description' => '<p>Provides a description of the parameter.</p>', 'Parameter$Source' => '<p>The source of the parameter value.</p>', 'Parameter$ApplyType' => '<p>Specifies the engine specific parameters type.</p>', 'Parameter$DataType' => '<p>Specifies the valid data type for the parameter.</p>', 'Parameter$AllowedValues' => '<p>Specifies the valid range of values for the parameter.</p>', 'Parameter$MinimumEngineVersion' => '<p>The earliest engine version to which the parameter can apply.</p>', 'PendingMaintenanceAction$Action' => '<p>The type of pending maintenance action that is available for the resource. </p> <p>For more information about maintenance actions, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html">Maintaining a DB instance</a>.</p> <p>Valid Values:<code> system-update | db-upgrade | hardware-maintenance | ca-certificate-rotation</code> </p>', 'PendingMaintenanceAction$OptInStatus' => '<p>Indicates the type of opt-in request that has been received for the resource.</p>', 'PendingMaintenanceAction$Description' => '<p>A description providing more detail about the maintenance action.</p>', 'PendingMaintenanceActionsMessage$Marker' => '<p>An optional pagination token provided by a previous <code>DescribePendingMaintenanceActions</code> request. If this parameter is specified, the response includes only records beyond the marker, up to a number of records specified by <code>MaxRecords</code>.</p>', 'PendingModifiedValues$DBInstanceClass' => '<p>The name of the compute and memory capacity class for the DB instance.</p>', 'PendingModifiedValues$MasterUserPassword' => '<p>The master credentials for the DB instance.</p>', 'PendingModifiedValues$EngineVersion' => '<p>The database engine version.</p>', 'PendingModifiedValues$LicenseModel' => '<p>The license model for the DB instance.</p> <p>Valid values: <code>license-included</code> | <code>bring-your-own-license</code> | <code>general-public-license</code> </p>', 'PendingModifiedValues$DBInstanceIdentifier' => '<p>The database identifier for the DB instance.</p>', 'PendingModifiedValues$StorageType' => '<p>The storage type of the DB instance.</p>', 'PendingModifiedValues$CACertificateIdentifier' => '<p>The identifier of the CA certificate for the DB instance.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html">Using SSL/TLS to encrypt a connection to a DB instance</a> in the <i>Amazon RDS User Guide</i> and <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html"> Using SSL/TLS to encrypt a connection to a DB cluster</a> in the <i>Amazon Aurora User Guide</i>.</p>', 'PendingModifiedValues$DBSubnetGroupName' => '<p>The DB subnet group for the DB instance.</p>', 'PendingModifiedValues$Engine' => '<p>The database engine of the DB instance.</p>', 'PerformanceInsightsMetricDimensionGroup$Group' => '<p>The available dimension groups for Performance Insights metric type.</p>', 'PerformanceInsightsMetricQuery$Metric' => '<p>The name of a Performance Insights metric to be measured.</p> <p>Valid Values:</p> <ul> <li> <p> <code>db.load.avg</code> - A scaled representation of the number of active sessions for the database engine.</p> </li> <li> <p> <code>db.sampledload.avg</code> - The raw number of active sessions for the database engine.</p> </li> <li> <p>The counter metrics listed in <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_PerfInsights_Counters.html#USER_PerfInsights_Counters.OS">Performance Insights operating system counters</a> in the <i>Amazon Aurora User Guide</i>.</p> </li> </ul> <p>If the number of active sessions is less than an internal Performance Insights threshold, <code>db.load.avg</code> and <code>db.sampledload.avg</code> are the same value. If the number of active sessions is greater than the internal threshold, Performance Insights samples the active sessions, with <code>db.load.avg</code> showing the scaled values, <code>db.sampledload.avg</code> showing the raw values, and <code>db.sampledload.avg</code> less than <code>db.load.avg</code>. For most use cases, you can query <code>db.load.avg</code> only.</p>', 'PerformanceIssueDetails$Analysis' => '<p>The analysis of the performance issue. The information might contain markdown.</p>', 'ProcessorFeature$Name' => '<p>The name of the processor feature. Valid names are <code>coreCount</code> and <code>threadsPerCore</code>.</p>', 'ProcessorFeature$Value' => '<p>The value of a processor feature.</p>', 'PromoteReadReplicaDBClusterMessage$DBClusterIdentifier' => '<p>The identifier of the DB cluster read replica to promote. This parameter isn\'t case-sensitive.</p> <p>Constraints:</p> <ul> <li> <p>Must match the identifier of an existing DB cluster read replica.</p> </li> </ul> <p>Example: <code>my-cluster-replica1</code> </p>', 'PromoteReadReplicaMessage$DBInstanceIdentifier' => '<p>The DB instance identifier. This value is stored as a lowercase string.</p> <p>Constraints:</p> <ul> <li> <p>Must match the identifier of an existing read replica DB instance.</p> </li> </ul> <p>Example: <code>mydbinstance</code> </p>', 'PromoteReadReplicaMessage$PreferredBackupWindow' => '<p>The daily time range during which automated backups are created if automated backups are enabled, using the <code>BackupRetentionPeriod</code> parameter.</p> <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region. To see the time blocks available, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AdjustingTheMaintenanceWindow.html"> Adjusting the Preferred Maintenance Window</a> in the <i>Amazon RDS User Guide.</i> </p> <p>Constraints:</p> <ul> <li> <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p> </li> <li> <p>Must be in Universal Coordinated Time (UTC).</p> </li> <li> <p>Must not conflict with the preferred maintenance window.</p> </li> <li> <p>Must be at least 30 minutes.</p> </li> </ul>', 'PurchaseReservedDBInstancesOfferingMessage$ReservedDBInstancesOfferingId' => '<p>The ID of the Reserved DB instance offering to purchase.</p> <p>Example: 438012d3-4052-4cc7-b2e3-8d3372e0e706</p>', 'PurchaseReservedDBInstancesOfferingMessage$ReservedDBInstanceId' => '<p>Customer-specified identifier to track this reservation.</p> <p>Example: myreservationID</p>', 'RdsCustomClusterConfiguration$InterconnectSubnetId' => '<p>Reserved for future use.</p>', 'RdsCustomClusterConfiguration$TransitGatewayMulticastDomainId' => '<p>Reserved for future use.</p>', 'ReadReplicaDBClusterIdentifierList$member' => NULL, 'ReadReplicaDBInstanceIdentifierList$member' => NULL, 'ReadReplicaIdentifierList$member' => NULL, 'ReadersArnList$member' => NULL, 'RebootDBClusterMessage$DBClusterIdentifier' => '<p>The DB cluster identifier. This parameter is stored as a lowercase string.</p> <p>Constraints:</p> <ul> <li> <p>Must match the identifier of an existing DBCluster.</p> </li> </ul>', 'RebootDBInstanceMessage$DBInstanceIdentifier' => '<p>The DB instance identifier. This parameter is stored as a lowercase string.</p> <p>Constraints:</p> <ul> <li> <p>Must match the identifier of an existing DBInstance.</p> </li> </ul>', 'RecommendedAction$ActionId' => '<p>The unique identifier of the recommended action.</p>', 'RecommendedAction$Title' => '<p>A short description to summarize the action. The description might contain markdown.</p>', 'RecommendedAction$Description' => '<p>A detailed description of the action. The description might contain markdown.</p>', 'RecommendedAction$Operation' => '<p>An API operation for the action.</p>', 'RecommendedAction$Status' => '<p>The status of the action.</p> <ul> <li> <p> <code>ready</code> </p> </li> <li> <p> <code>applied</code> </p> </li> <li> <p> <code>scheduled</code> </p> </li> <li> <p> <code>resolved</code> </p> </li> </ul>', 'RecommendedActionParameter$Key' => '<p>The key of the parameter to use with the <code>RecommendedAction</code> API operation.</p>', 'RecommendedActionParameter$Value' => '<p>The value of the parameter to use with the <code>RecommendedAction</code> API operation.</p>', 'RecommendedActionUpdate$ActionId' => '<p>A unique identifier of the updated recommendation action.</p>', 'RecommendedActionUpdate$Status' => '<p>The status of the updated recommendation action.</p> <ul> <li> <p> <code>applied</code> </p> </li> <li> <p> <code>scheduled</code> </p> </li> </ul>', 'RecurringCharge$RecurringChargeFrequency' => '<p>The frequency of the recurring charge.</p>', 'RegisterDBProxyTargetsRequest$DBProxyName' => '<p>The identifier of the <code>DBProxy</code> that is associated with the <code>DBProxyTargetGroup</code>.</p>', 'RegisterDBProxyTargetsRequest$TargetGroupName' => '<p>The identifier of the <code>DBProxyTargetGroup</code>.</p>', 'RemoveFromGlobalClusterMessage$GlobalClusterIdentifier' => '<p>The cluster identifier to detach from the Aurora global database cluster.</p>', 'RemoveFromGlobalClusterMessage$DbClusterIdentifier' => '<p>The Amazon Resource Name (ARN) identifying the cluster that was detached from the Aurora global database cluster.</p>', 'RemoveRoleFromDBClusterMessage$DBClusterIdentifier' => '<p>The name of the DB cluster to disassociate the IAM role from.</p>', 'RemoveRoleFromDBClusterMessage$RoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role to disassociate from the Aurora DB cluster, for example <code>arn:aws:iam::123456789012:role/AuroraAccessRole</code>.</p>', 'RemoveRoleFromDBClusterMessage$FeatureName' => '<p>The name of the feature for the DB cluster that the IAM role is to be disassociated from. For information about supported feature names, see <a>DBEngineVersion</a>.</p>', 'RemoveRoleFromDBInstanceMessage$DBInstanceIdentifier' => '<p>The name of the DB instance to disassociate the IAM role from.</p>', 'RemoveRoleFromDBInstanceMessage$RoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role to disassociate from the DB instance, for example, <code>arn:aws:iam::123456789012:role/AccessRole</code>.</p>', 'RemoveRoleFromDBInstanceMessage$FeatureName' => '<p>The name of the feature for the DB instance that the IAM role is to be disassociated from. For information about supported feature names, see <code>DBEngineVersion</code>.</p>', 'RemoveSourceIdentifierFromSubscriptionMessage$SubscriptionName' => '<p>The name of the RDS event notification subscription you want to remove a source identifier from.</p>', 'RemoveSourceIdentifierFromSubscriptionMessage$SourceIdentifier' => '<p>The source identifier to be removed from the subscription, such as the <b>DB instance identifier</b> for a DB instance or the name of a security group.</p>', 'RemoveTagsFromResourceMessage$ResourceName' => '<p>The Amazon RDS resource that the tags are removed from. This value is an Amazon Resource Name (ARN). For information about creating an ARN, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing"> Constructing an ARN for Amazon RDS</a> in the <i>Amazon RDS User Guide.</i> </p>', 'ReservedDBInstance$ReservedDBInstanceId' => '<p>The unique identifier for the reservation.</p>', 'ReservedDBInstance$ReservedDBInstancesOfferingId' => '<p>The offering identifier.</p>', 'ReservedDBInstance$DBInstanceClass' => '<p>The DB instance class for the reserved DB instance.</p>', 'ReservedDBInstance$CurrencyCode' => '<p>The currency code for the reserved DB instance.</p>', 'ReservedDBInstance$ProductDescription' => '<p>The description of the reserved DB instance.</p>', 'ReservedDBInstance$OfferingType' => '<p>The offering type of this reserved DB instance.</p>', 'ReservedDBInstance$State' => '<p>The state of the reserved DB instance.</p>', 'ReservedDBInstance$ReservedDBInstanceArn' => '<p>The Amazon Resource Name (ARN) for the reserved DB instance.</p>', 'ReservedDBInstance$LeaseId' => '<p>The unique identifier for the lease associated with the reserved DB instance.</p> <note> <p>Amazon Web Services Support might request the lease ID for an issue related to a reserved DB instance.</p> </note>', 'ReservedDBInstanceMessage$Marker' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'ReservedDBInstancesOffering$ReservedDBInstancesOfferingId' => '<p>The offering identifier.</p>', 'ReservedDBInstancesOffering$DBInstanceClass' => '<p>The DB instance class for the reserved DB instance.</p>', 'ReservedDBInstancesOffering$CurrencyCode' => '<p>The currency code for the reserved DB instance offering.</p>', 'ReservedDBInstancesOffering$ProductDescription' => '<p>The database engine used by the offering.</p>', 'ReservedDBInstancesOffering$OfferingType' => '<p>The offering type.</p>', 'ReservedDBInstancesOfferingMessage$Marker' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'ResetDBClusterParameterGroupMessage$DBClusterParameterGroupName' => '<p>The name of the DB cluster parameter group to reset.</p>', 'ResetDBParameterGroupMessage$DBParameterGroupName' => '<p>The name of the DB parameter group.</p> <p>Constraints:</p> <ul> <li> <p>Must match the name of an existing <code>DBParameterGroup</code>.</p> </li> </ul>', 'ResourcePendingMaintenanceActions$ResourceIdentifier' => '<p>The ARN of the resource that has pending maintenance actions.</p>', 'RestoreDBClusterFromS3Message$CharacterSetName' => '<p>A value that indicates that the restored DB cluster should be associated with the specified CharacterSet.</p>', 'RestoreDBClusterFromS3Message$DatabaseName' => '<p>The database name for the restored DB cluster.</p>', 'RestoreDBClusterFromS3Message$DBClusterIdentifier' => '<p>The name of the DB cluster to create from the source data in the Amazon S3 bucket. This parameter isn\'t case-sensitive.</p> <p>Constraints:</p> <ul> <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Can\'t end with a hyphen or contain two consecutive hyphens.</p> </li> </ul> <p>Example: <code>my-cluster1</code> </p>', 'RestoreDBClusterFromS3Message$DBClusterParameterGroupName' => '<p>The name of the DB cluster parameter group to associate with the restored DB cluster. If this argument is omitted, the default parameter group for the engine version is used.</p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p> </li> </ul>', 'RestoreDBClusterFromS3Message$DBSubnetGroupName' => '<p>A DB subnet group to associate with the restored DB cluster.</p> <p>Constraints: If supplied, must match the name of an existing DBSubnetGroup.</p> <p>Example: <code>mydbsubnetgroup</code> </p>', 'RestoreDBClusterFromS3Message$Engine' => '<p>The name of the database engine to be used for this DB cluster.</p> <p>Valid Values: <code>aurora-mysql</code> (for Aurora MySQL)</p>', 'RestoreDBClusterFromS3Message$EngineVersion' => '<p>The version number of the database engine to use.</p> <p>To list all of the available engine versions for <code>aurora-mysql</code> (Aurora MySQL), use the following command:</p> <p> <code>aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"</code> </p> <p> <b>Aurora MySQL</b> </p> <p>Examples: <code>5.7.mysql_aurora.2.12.0</code>, <code>8.0.mysql_aurora.3.04.0</code> </p>', 'RestoreDBClusterFromS3Message$MasterUsername' => '<p>The name of the master user for the restored DB cluster.</p> <p>Constraints:</p> <ul> <li> <p>Must be 1 to 16 letters or numbers.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Can\'t be a reserved word for the chosen database engine.</p> </li> </ul>', 'RestoreDBClusterFromS3Message$MasterUserPassword' => '<p>The password for the master database user. This password can contain any printable ASCII character except "/", """, or "@".</p> <p>Constraints:</p> <ul> <li> <p>Must contain from 8 to 41 characters.</p> </li> <li> <p>Can\'t be specified if <code>ManageMasterUserPassword</code> is turned on.</p> </li> </ul>', 'RestoreDBClusterFromS3Message$OptionGroupName' => '<p>A value that indicates that the restored DB cluster should be associated with the specified option group.</p> <p>Permanent options can\'t be removed from an option group. An option group can\'t be removed from a DB cluster once it is associated with a DB cluster.</p>', 'RestoreDBClusterFromS3Message$PreferredBackupWindow' => '<p>The daily time range during which automated backups are created if automated backups are enabled using the <code>BackupRetentionPeriod</code> parameter.</p> <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region. To view the time blocks available, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.Backups.BackupWindow"> Backup window</a> in the <i>Amazon Aurora User Guide</i>.</p> <p>Constraints:</p> <ul> <li> <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p> </li> <li> <p>Must be in Universal Coordinated Time (UTC).</p> </li> <li> <p>Must not conflict with the preferred maintenance window.</p> </li> <li> <p>Must be at least 30 minutes.</p> </li> </ul>', 'RestoreDBClusterFromS3Message$PreferredMaintenanceWindow' => '<p>The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).</p> <p>Format: <code>ddd:hh24:mi-ddd:hh24:mi</code> </p> <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region, occurring on a random day of the week. To see the time blocks available, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora"> Adjusting the Preferred Maintenance Window</a> in the <i>Amazon Aurora User Guide</i>.</p> <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.</p> <p>Constraints: Minimum 30-minute window.</p>', 'RestoreDBClusterFromS3Message$KmsKeyId' => '<p>The Amazon Web Services KMS key identifier for an encrypted DB cluster.</p> <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.</p> <p>If the StorageEncrypted parameter is enabled, and you do not specify a value for the <code>KmsKeyId</code> parameter, then Amazon RDS will use your default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.</p>', 'RestoreDBClusterFromS3Message$SourceEngine' => '<p>The identifier for the database engine that was backed up to create the files stored in the Amazon S3 bucket.</p> <p>Valid Values: <code>mysql</code> </p>', 'RestoreDBClusterFromS3Message$SourceEngineVersion' => '<p>The version of the database that the backup files were created from.</p> <p>MySQL versions 5.7 and 8.0 are supported.</p> <p>Example: <code>5.7.40</code>, <code>8.0.28</code> </p>', 'RestoreDBClusterFromS3Message$S3BucketName' => '<p>The name of the Amazon S3 bucket that contains the data used to create the Amazon Aurora DB cluster.</p>', 'RestoreDBClusterFromS3Message$S3Prefix' => '<p>The prefix for all of the file names that contain the data used to create the Amazon Aurora DB cluster. If you do not specify a <b>SourceS3Prefix</b> value, then the Amazon Aurora DB cluster is created by using all of the files in the Amazon S3 bucket.</p>', 'RestoreDBClusterFromS3Message$S3IngestionRoleArn' => '<p>The Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role that authorizes Amazon RDS to access the Amazon S3 bucket on your behalf.</p>', 'RestoreDBClusterFromS3Message$Domain' => '<p>Specify the Active Directory directory ID to restore the DB cluster in. The domain must be created prior to this operation.</p> <p>For Amazon Aurora DB clusters, Amazon RDS can use Kerberos Authentication to authenticate users that connect to the DB cluster. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/kerberos-authentication.html">Kerberos Authentication</a> in the <i>Amazon Aurora User Guide</i>.</p>', 'RestoreDBClusterFromS3Message$DomainIAMRoleName' => '<p>Specify the name of the IAM role to be used when making API calls to the Directory Service.</p>', 'RestoreDBClusterFromS3Message$NetworkType' => '<p>The network type of the DB cluster.</p> <p>Valid Values:</p> <ul> <li> <p> <code>IPV4</code> </p> </li> <li> <p> <code>DUAL</code> </p> </li> </ul> <p>The network type is determined by the <code>DBSubnetGroup</code> specified for the DB cluster. A <code>DBSubnetGroup</code> can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (<code>DUAL</code>).</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html"> Working with a DB instance in a VPC</a> in the <i>Amazon Aurora User Guide.</i> </p>', 'RestoreDBClusterFromS3Message$MasterUserSecretKmsKeyId' => '<p>The Amazon Web Services KMS key identifier to encrypt a secret that is automatically generated and managed in Amazon Web Services Secrets Manager.</p> <p>This setting is valid only if the master user password is managed by RDS in Amazon Web Services Secrets Manager for the DB cluster.</p> <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.</p> <p>If you don\'t specify <code>MasterUserSecretKmsKeyId</code>, then the <code>aws/secretsmanager</code> KMS key is used to encrypt the secret. If the secret is in a different Amazon Web Services account, then you can\'t use the <code>aws/secretsmanager</code> KMS key to encrypt the secret, and you must use a customer managed KMS key.</p> <p>There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.</p>', 'RestoreDBClusterFromS3Message$StorageType' => '<p>Specifies the storage type to be associated with the DB cluster.</p> <p>Valid Values: <code>aurora</code>, <code>aurora-iopt1</code> </p> <p>Default: <code>aurora</code> </p> <p>Valid for: Aurora DB clusters only</p>', 'RestoreDBClusterFromS3Message$EngineLifecycleSupport' => '<p>The life cycle type for this DB cluster.</p> <note> <p>By default, this value is set to <code>open-source-rds-extended-support</code>, which enrolls your DB cluster into Amazon RDS Extended Support. At the end of standard support, you can avoid charges for Extended Support by setting the value to <code>open-source-rds-extended-support-disabled</code>. In this case, RDS automatically upgrades your restored DB cluster to a higher engine version, if the major engine version is past its end of standard support date.</p> </note> <p>You can use this setting to enroll your DB cluster into Amazon RDS Extended Support. With RDS Extended Support, you can run the selected major engine version on your DB cluster past the end of standard support for that engine version. For more information, see the following sections:</p> <ul> <li> <p>Amazon Aurora (PostgreSQL only) - <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/extended-support.html">Using Amazon RDS Extended Support</a> in the <i>Amazon Aurora User Guide</i> </p> </li> <li> <p>Amazon RDS - <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html">Using Amazon RDS Extended Support</a> in the <i>Amazon RDS User Guide</i> </p> </li> </ul> <p>Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters</p> <p>Valid Values: <code>open-source-rds-extended-support | open-source-rds-extended-support-disabled</code> </p> <p>Default: <code>open-source-rds-extended-support</code> </p>', 'RestoreDBClusterFromSnapshotMessage$DBClusterIdentifier' => '<p>The name of the DB cluster to create from the DB snapshot or DB cluster snapshot. This parameter isn\'t case-sensitive.</p> <p>Constraints:</p> <ul> <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens</p> </li> <li> <p>First character must be a letter</p> </li> <li> <p>Can\'t end with a hyphen or contain two consecutive hyphens</p> </li> </ul> <p>Example: <code>my-snapshot-id</code> </p> <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>', 'RestoreDBClusterFromSnapshotMessage$SnapshotIdentifier' => '<p>The identifier for the DB snapshot or DB cluster snapshot to restore from.</p> <p>You can use either the name or the Amazon Resource Name (ARN) to specify a DB cluster snapshot. However, you can use only the ARN to specify a DB snapshot.</p> <p>Constraints:</p> <ul> <li> <p>Must match the identifier of an existing Snapshot.</p> </li> </ul> <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>', 'RestoreDBClusterFromSnapshotMessage$Engine' => '<p>The database engine to use for the new DB cluster.</p> <p>Default: The same as source</p> <p>Constraint: Must be compatible with the engine of the source</p> <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>', 'RestoreDBClusterFromSnapshotMessage$EngineVersion' => '<p>The version of the database engine to use for the new DB cluster. If you don\'t specify an engine version, the default version for the database engine in the Amazon Web Services Region is used.</p> <p>To list all of the available engine versions for Aurora MySQL, use the following command:</p> <p> <code>aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"</code> </p> <p>To list all of the available engine versions for Aurora PostgreSQL, use the following command:</p> <p> <code>aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"</code> </p> <p>To list all of the available engine versions for RDS for MySQL, use the following command:</p> <p> <code>aws rds describe-db-engine-versions --engine mysql --query "DBEngineVersions[].EngineVersion"</code> </p> <p>To list all of the available engine versions for RDS for PostgreSQL, use the following command:</p> <p> <code>aws rds describe-db-engine-versions --engine postgres --query "DBEngineVersions[].EngineVersion"</code> </p> <p> <b>Aurora MySQL</b> </p> <p>See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Updates.html">Database engine updates for Amazon Aurora MySQL</a> in the <i>Amazon Aurora User Guide</i>.</p> <p> <b>Aurora PostgreSQL</b> </p> <p>See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraPostgreSQL.Updates.20180305.html">Amazon Aurora PostgreSQL releases and engine versions</a> in the <i>Amazon Aurora User Guide</i>.</p> <p> <b>MySQL</b> </p> <p>See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt">Amazon RDS for MySQL</a> in the <i>Amazon RDS User Guide.</i> </p> <p> <b>PostgreSQL</b> </p> <p>See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts">Amazon RDS for PostgreSQL versions and extensions</a> in the <i>Amazon RDS User Guide.</i> </p> <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>', 'RestoreDBClusterFromSnapshotMessage$DBSubnetGroupName' => '<p>The name of the DB subnet group to use for the new DB cluster.</p> <p>Constraints: If supplied, must match the name of an existing DB subnet group.</p> <p>Example: <code>mydbsubnetgroup</code> </p> <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>', 'RestoreDBClusterFromSnapshotMessage$DatabaseName' => '<p>The database name for the restored DB cluster.</p> <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>', 'RestoreDBClusterFromSnapshotMessage$OptionGroupName' => '<p>The name of the option group to use for the restored DB cluster.</p> <p>DB clusters are associated with a default option group that can\'t be modified.</p>', 'RestoreDBClusterFromSnapshotMessage$KmsKeyId' => '<p>The Amazon Web Services KMS key identifier to use when restoring an encrypted DB cluster from a DB snapshot or DB cluster snapshot.</p> <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.</p> <p>When you don\'t specify a value for the <code>KmsKeyId</code> parameter, then the following occurs:</p> <ul> <li> <p>If the DB snapshot or DB cluster snapshot in <code>SnapshotIdentifier</code> is encrypted, then the restored DB cluster is encrypted using the KMS key that was used to encrypt the DB snapshot or DB cluster snapshot.</p> </li> <li> <p>If the DB snapshot or DB cluster snapshot in <code>SnapshotIdentifier</code> isn\'t encrypted, then the restored DB cluster isn\'t encrypted.</p> </li> </ul> <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>', 'RestoreDBClusterFromSnapshotMessage$EngineMode' => '<p>The DB engine mode of the DB cluster, either <code>provisioned</code> or <code>serverless</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBCluster.html"> CreateDBCluster</a>.</p> <p>Valid for: Aurora DB clusters only</p>', 'RestoreDBClusterFromSnapshotMessage$DBClusterParameterGroupName' => '<p>The name of the DB cluster parameter group to associate with this DB cluster. If this argument is omitted, the default DB cluster parameter group for the specified engine is used.</p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match the name of an existing default DB cluster parameter group.</p> </li> <li> <p>Must be 1 to 255 letters, numbers, or hyphens.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Can\'t end with a hyphen or contain two consecutive hyphens.</p> </li> </ul> <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>', 'RestoreDBClusterFromSnapshotMessage$Domain' => '<p>The Active Directory directory ID to restore the DB cluster in. The domain must be created prior to this operation. Currently, only MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB instances can be created in an Active Directory Domain.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html"> Kerberos Authentication</a> in the <i>Amazon RDS User Guide</i>.</p> <p>Valid for: Aurora DB clusters only</p>', 'RestoreDBClusterFromSnapshotMessage$DomainIAMRoleName' => '<p>The name of the IAM role to be used when making API calls to the Directory Service.</p> <p>Valid for: Aurora DB clusters only</p>', 'RestoreDBClusterFromSnapshotMessage$DBClusterInstanceClass' => '<p>The compute and memory capacity of the each DB instance in the Multi-AZ DB cluster, for example db.m6gd.xlarge. Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines.</p> <p>For the full list of DB instance classes, and availability for your engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB Instance Class</a> in the <i>Amazon RDS User Guide.</i> </p> <p>Valid for: Multi-AZ DB clusters only</p>', 'RestoreDBClusterFromSnapshotMessage$StorageType' => '<p>Specifies the storage type to be associated with the DB cluster.</p> <p>When specified for a Multi-AZ DB cluster, a value for the <code>Iops</code> parameter is required.</p> <p>Valid Values: <code>aurora</code>, <code>aurora-iopt1</code> (Aurora DB clusters); <code>io1</code> (Multi-AZ DB clusters)</p> <p>Default: <code>aurora</code> (Aurora DB clusters); <code>io1</code> (Multi-AZ DB clusters)</p> <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>', 'RestoreDBClusterFromSnapshotMessage$NetworkType' => '<p>The network type of the DB cluster.</p> <p>Valid Values:</p> <ul> <li> <p> <code>IPV4</code> </p> </li> <li> <p> <code>DUAL</code> </p> </li> </ul> <p>The network type is determined by the <code>DBSubnetGroup</code> specified for the DB cluster. A <code>DBSubnetGroup</code> can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (<code>DUAL</code>).</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html"> Working with a DB instance in a VPC</a> in the <i>Amazon Aurora User Guide.</i> </p> <p>Valid for: Aurora DB clusters only</p>', 'RestoreDBClusterFromSnapshotMessage$EngineLifecycleSupport' => '<p>The life cycle type for this DB cluster.</p> <note> <p>By default, this value is set to <code>open-source-rds-extended-support</code>, which enrolls your DB cluster into Amazon RDS Extended Support. At the end of standard support, you can avoid charges for Extended Support by setting the value to <code>open-source-rds-extended-support-disabled</code>. In this case, RDS automatically upgrades your restored DB cluster to a higher engine version, if the major engine version is past its end of standard support date.</p> </note> <p>You can use this setting to enroll your DB cluster into Amazon RDS Extended Support. With RDS Extended Support, you can run the selected major engine version on your DB cluster past the end of standard support for that engine version. For more information, see the following sections:</p> <ul> <li> <p>Amazon Aurora (PostgreSQL only) - <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/extended-support.html">Using Amazon RDS Extended Support</a> in the <i>Amazon Aurora User Guide</i> </p> </li> <li> <p>Amazon RDS - <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html">Using Amazon RDS Extended Support</a> in the <i>Amazon RDS User Guide</i> </p> </li> </ul> <p>Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters</p> <p>Valid Values: <code>open-source-rds-extended-support | open-source-rds-extended-support-disabled</code> </p> <p>Default: <code>open-source-rds-extended-support</code> </p>', 'RestoreDBClusterToPointInTimeMessage$DBClusterIdentifier' => '<p>The name of the new DB cluster to be created.</p> <p>Constraints:</p> <ul> <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens</p> </li> <li> <p>First character must be a letter</p> </li> <li> <p>Can\'t end with a hyphen or contain two consecutive hyphens</p> </li> </ul> <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>', 'RestoreDBClusterToPointInTimeMessage$RestoreType' => '<p>The type of restore to be performed. You can specify one of the following values:</p> <ul> <li> <p> <code>full-copy</code> - The new DB cluster is restored as a full copy of the source DB cluster.</p> </li> <li> <p> <code>copy-on-write</code> - The new DB cluster is restored as a clone of the source DB cluster.</p> </li> </ul> <p>If you don\'t specify a <code>RestoreType</code> value, then the new DB cluster is restored as a full copy of the source DB cluster.</p> <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>', 'RestoreDBClusterToPointInTimeMessage$SourceDBClusterIdentifier' => '<p>The identifier of the source DB cluster from which to restore.</p> <p>Constraints:</p> <ul> <li> <p>Must match the identifier of an existing DBCluster.</p> </li> </ul> <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>', 'RestoreDBClusterToPointInTimeMessage$DBSubnetGroupName' => '<p>The DB subnet group name to use for the new DB cluster.</p> <p>Constraints: If supplied, must match the name of an existing DBSubnetGroup.</p> <p>Example: <code>mydbsubnetgroup</code> </p> <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>', 'RestoreDBClusterToPointInTimeMessage$OptionGroupName' => '<p>The name of the option group for the new DB cluster.</p> <p>DB clusters are associated with a default option group that can\'t be modified.</p>', 'RestoreDBClusterToPointInTimeMessage$KmsKeyId' => '<p>The Amazon Web Services KMS key identifier to use when restoring an encrypted DB cluster from an encrypted DB cluster.</p> <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.</p> <p>You can restore to a new DB cluster and encrypt the new DB cluster with a KMS key that is different from the KMS key used to encrypt the source DB cluster. The new DB cluster is encrypted with the KMS key identified by the <code>KmsKeyId</code> parameter.</p> <p>If you don\'t specify a value for the <code>KmsKeyId</code> parameter, then the following occurs:</p> <ul> <li> <p>If the DB cluster is encrypted, then the restored DB cluster is encrypted using the KMS key that was used to encrypt the source DB cluster.</p> </li> <li> <p>If the DB cluster isn\'t encrypted, then the restored DB cluster isn\'t encrypted.</p> </li> </ul> <p>If <code>DBClusterIdentifier</code> refers to a DB cluster that isn\'t encrypted, then the restore request is rejected.</p> <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>', 'RestoreDBClusterToPointInTimeMessage$DBClusterParameterGroupName' => '<p>The name of the custom DB cluster parameter group to associate with this DB cluster.</p> <p>If the <code>DBClusterParameterGroupName</code> parameter is omitted, the default DB cluster parameter group for the specified engine is used.</p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match the name of an existing DB cluster parameter group.</p> </li> <li> <p>Must be 1 to 255 letters, numbers, or hyphens.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Can\'t end with a hyphen or contain two consecutive hyphens.</p> </li> </ul> <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>', 'RestoreDBClusterToPointInTimeMessage$Domain' => '<p>The Active Directory directory ID to restore the DB cluster in. The domain must be created prior to this operation.</p> <p>For Amazon Aurora DB clusters, Amazon RDS can use Kerberos Authentication to authenticate users that connect to the DB cluster. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/kerberos-authentication.html">Kerberos Authentication</a> in the <i>Amazon Aurora User Guide</i>.</p> <p>Valid for: Aurora DB clusters only</p>', 'RestoreDBClusterToPointInTimeMessage$DomainIAMRoleName' => '<p>The name of the IAM role to be used when making API calls to the Directory Service.</p> <p>Valid for: Aurora DB clusters only</p>', 'RestoreDBClusterToPointInTimeMessage$EngineMode' => '<p>The engine mode of the new cluster. Specify <code>provisioned</code> or <code>serverless</code>, depending on the type of the cluster you are creating. You can create an Aurora Serverless v1 clone from a provisioned cluster, or a provisioned clone from an Aurora Serverless v1 cluster. To create a clone that is an Aurora Serverless v1 cluster, the original cluster must be an Aurora Serverless v1 cluster or an encrypted provisioned cluster.</p> <p>Valid for: Aurora DB clusters only</p>', 'RestoreDBClusterToPointInTimeMessage$DBClusterInstanceClass' => '<p>The compute and memory capacity of the each DB instance in the Multi-AZ DB cluster, for example db.m6gd.xlarge. Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines.</p> <p>For the full list of DB instance classes, and availability for your engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB instance class</a> in the <i>Amazon RDS User Guide</i>.</p> <p>Valid for: Multi-AZ DB clusters only</p>', 'RestoreDBClusterToPointInTimeMessage$StorageType' => '<p>Specifies the storage type to be associated with the DB cluster.</p> <p>When specified for a Multi-AZ DB cluster, a value for the <code>Iops</code> parameter is required.</p> <p>Valid Values: <code>aurora</code>, <code>aurora-iopt1</code> (Aurora DB clusters); <code>io1</code> (Multi-AZ DB clusters)</p> <p>Default: <code>aurora</code> (Aurora DB clusters); <code>io1</code> (Multi-AZ DB clusters)</p> <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>', 'RestoreDBClusterToPointInTimeMessage$NetworkType' => '<p>The network type of the DB cluster.</p> <p>Valid Values:</p> <ul> <li> <p> <code>IPV4</code> </p> </li> <li> <p> <code>DUAL</code> </p> </li> </ul> <p>The network type is determined by the <code>DBSubnetGroup</code> specified for the DB cluster. A <code>DBSubnetGroup</code> can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (<code>DUAL</code>).</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html"> Working with a DB instance in a VPC</a> in the <i>Amazon Aurora User Guide.</i> </p> <p>Valid for: Aurora DB clusters only</p>', 'RestoreDBClusterToPointInTimeMessage$SourceDbClusterResourceId' => '<p>The resource ID of the source DB cluster from which to restore.</p>', 'RestoreDBClusterToPointInTimeMessage$EngineLifecycleSupport' => '<p>The life cycle type for this DB cluster.</p> <note> <p>By default, this value is set to <code>open-source-rds-extended-support</code>, which enrolls your DB cluster into Amazon RDS Extended Support. At the end of standard support, you can avoid charges for Extended Support by setting the value to <code>open-source-rds-extended-support-disabled</code>. In this case, RDS automatically upgrades your restored DB cluster to a higher engine version, if the major engine version is past its end of standard support date.</p> </note> <p>You can use this setting to enroll your DB cluster into Amazon RDS Extended Support. With RDS Extended Support, you can run the selected major engine version on your DB cluster past the end of standard support for that engine version. For more information, see the following sections:</p> <ul> <li> <p>Amazon Aurora (PostgreSQL only) - <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/extended-support.html">Using Amazon RDS Extended Support</a> in the <i>Amazon Aurora User Guide</i> </p> </li> <li> <p>Amazon RDS - <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html">Using Amazon RDS Extended Support</a> in the <i>Amazon RDS User Guide</i> </p> </li> </ul> <p>Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters</p> <p>Valid Values: <code>open-source-rds-extended-support | open-source-rds-extended-support-disabled</code> </p> <p>Default: <code>open-source-rds-extended-support</code> </p>', 'RestoreDBInstanceFromDBSnapshotMessage$DBInstanceIdentifier' => '<p>The name of the DB instance to create from the DB snapshot. This parameter isn\'t case-sensitive.</p> <p>Constraints:</p> <ul> <li> <p>Must contain from 1 to 63 numbers, letters, or hyphens.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Can\'t end with a hyphen or contain two consecutive hyphens.</p> </li> </ul> <p>Example: <code>my-snapshot-id</code> </p>', 'RestoreDBInstanceFromDBSnapshotMessage$DBSnapshotIdentifier' => '<p>The identifier for the DB snapshot to restore from.</p> <p>Constraints:</p> <ul> <li> <p>Must match the identifier of an existing DB snapshot.</p> </li> <li> <p>Can\'t be specified when <code>DBClusterSnapshotIdentifier</code> is specified.</p> </li> <li> <p>Must be specified when <code>DBClusterSnapshotIdentifier</code> isn\'t specified.</p> </li> <li> <p>If you are restoring from a shared manual DB snapshot, the <code>DBSnapshotIdentifier</code> must be the ARN of the shared DB snapshot.</p> </li> </ul>', 'RestoreDBInstanceFromDBSnapshotMessage$DBInstanceClass' => '<p>The compute and memory capacity of the Amazon RDS DB instance, for example db.m4.large. Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines. For the full list of DB instance classes, and availability for your engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB Instance Class</a> in the <i>Amazon RDS User Guide.</i> </p> <p>Default: The same DBInstanceClass as the original DB instance.</p>', 'RestoreDBInstanceFromDBSnapshotMessage$AvailabilityZone' => '<p>The Availability Zone (AZ) where the DB instance will be created.</p> <p>Default: A random, system-chosen Availability Zone.</p> <p>Constraint: You can\'t specify the <code>AvailabilityZone</code> parameter if the DB instance is a Multi-AZ deployment.</p> <p>Example: <code>us-east-1a</code> </p>', 'RestoreDBInstanceFromDBSnapshotMessage$DBSubnetGroupName' => '<p>The name of the DB subnet group to use for the new instance.</p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match the name of an existing DB subnet group.</p> </li> </ul> <p>Example: <code>mydbsubnetgroup</code> </p>', 'RestoreDBInstanceFromDBSnapshotMessage$LicenseModel' => '<p>License model information for the restored DB instance.</p> <note> <p>License models for RDS for Db2 require additional configuration. The Bring Your Own License (BYOL) model requires a custom parameter group. The Db2 license through Amazon Web Services Marketplace model requires an Amazon Web Services Marketplace subscription. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/db2-licensing.html">RDS for Db2 licensing options</a> in the <i>Amazon RDS User Guide</i>.</p> </note> <p>This setting doesn\'t apply to Amazon Aurora or RDS Custom DB instances.</p> <p>Valid Values:</p> <ul> <li> <p>RDS for Db2 - <code>bring-your-own-license | marketplace-license</code> </p> </li> <li> <p>RDS for MariaDB - <code>general-public-license</code> </p> </li> <li> <p>RDS for Microsoft SQL Server - <code>license-included</code> </p> </li> <li> <p>RDS for MySQL - <code>general-public-license</code> </p> </li> <li> <p>RDS for Oracle - <code>bring-your-own-license | license-included</code> </p> </li> <li> <p>RDS for PostgreSQL - <code>postgresql-license</code> </p> </li> </ul> <p>Default: Same as the source.</p>', 'RestoreDBInstanceFromDBSnapshotMessage$DBName' => '<p>The name of the database for the restored DB instance.</p> <p>This parameter only applies to RDS for Oracle and RDS for SQL Server DB instances. It doesn\'t apply to the other engines or to RDS Custom DB instances.</p>', 'RestoreDBInstanceFromDBSnapshotMessage$Engine' => '<p>The database engine to use for the new instance.</p> <p>This setting doesn\'t apply to RDS Custom.</p> <p>Default: The same as source</p> <p>Constraint: Must be compatible with the engine of the source. For example, you can restore a MariaDB 10.1 DB instance from a MySQL 5.6 snapshot.</p> <p>Valid Values:</p> <ul> <li> <p> <code>db2-ae</code> </p> </li> <li> <p> <code>db2-se</code> </p> </li> <li> <p> <code>mariadb</code> </p> </li> <li> <p> <code>mysql</code> </p> </li> <li> <p> <code>oracle-ee</code> </p> </li> <li> <p> <code>oracle-ee-cdb</code> </p> </li> <li> <p> <code>oracle-se2</code> </p> </li> <li> <p> <code>oracle-se2-cdb</code> </p> </li> <li> <p> <code>postgres</code> </p> </li> <li> <p> <code>sqlserver-ee</code> </p> </li> <li> <p> <code>sqlserver-se</code> </p> </li> <li> <p> <code>sqlserver-ex</code> </p> </li> <li> <p> <code>sqlserver-web</code> </p> </li> </ul>', 'RestoreDBInstanceFromDBSnapshotMessage$OptionGroupName' => '<p>The name of the option group to be used for the restored DB instance.</p> <p>Permanent options, such as the TDE option for Oracle Advanced Security TDE, can\'t be removed from an option group, and that option group can\'t be removed from a DB instance after it is associated with a DB instance.</p> <p>This setting doesn\'t apply to RDS Custom.</p>', 'RestoreDBInstanceFromDBSnapshotMessage$StorageType' => '<p>Specifies the storage type to be associated with the DB instance.</p> <p>Valid Values: <code>gp2 | gp3 | io1 | io2 | standard</code> </p> <p>If you specify <code>io1</code>, <code>io2</code>, or <code>gp3</code>, you must also include a value for the <code>Iops</code> parameter.</p> <p>Default: <code>io1</code> if the <code>Iops</code> parameter is specified, otherwise <code>gp2</code> </p>', 'RestoreDBInstanceFromDBSnapshotMessage$TdeCredentialArn' => '<p>The ARN from the key store with which to associate the instance for TDE encryption.</p> <p>This setting doesn\'t apply to RDS Custom.</p>', 'RestoreDBInstanceFromDBSnapshotMessage$TdeCredentialPassword' => '<p>The password for the given ARN from the key store in order to access the device.</p> <p>This setting doesn\'t apply to RDS Custom.</p>', 'RestoreDBInstanceFromDBSnapshotMessage$Domain' => '<p>The Active Directory directory ID to restore the DB instance in. The domain/ must be created prior to this operation. Currently, you can create only Db2, MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB instances in an Active Directory Domain.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html"> Kerberos Authentication</a> in the <i>Amazon RDS User Guide</i>.</p> <p>This setting doesn\'t apply to RDS Custom.</p>', 'RestoreDBInstanceFromDBSnapshotMessage$DomainFqdn' => '<p>The fully qualified domain name (FQDN) of an Active Directory domain.</p> <p>Constraints:</p> <ul> <li> <p>Can\'t be longer than 64 characters.</p> </li> </ul> <p>Example: <code>mymanagedADtest.mymanagedAD.mydomain</code> </p>', 'RestoreDBInstanceFromDBSnapshotMessage$DomainOu' => '<p>The Active Directory organizational unit for your DB instance to join.</p> <p>Constraints:</p> <ul> <li> <p>Must be in the distinguished name format.</p> </li> <li> <p>Can\'t be longer than 64 characters.</p> </li> </ul> <p>Example: <code>OU=mymanagedADtestOU,DC=mymanagedADtest,DC=mymanagedAD,DC=mydomain</code> </p>', 'RestoreDBInstanceFromDBSnapshotMessage$DomainAuthSecretArn' => '<p>The ARN for the Secrets Manager secret with the credentials for the user joining the domain.</p> <p>Constraints:</p> <ul> <li> <p>Can\'t be longer than 64 characters.</p> </li> </ul> <p>Example: <code>arn:aws:secretsmanager:region:account-number:secret:myselfmanagedADtestsecret-123456</code> </p>', 'RestoreDBInstanceFromDBSnapshotMessage$DomainIAMRoleName' => '<p>The name of the IAM role to use when making API calls to the Directory Service.</p> <p>This setting doesn\'t apply to RDS Custom DB instances.</p>', 'RestoreDBInstanceFromDBSnapshotMessage$DBParameterGroupName' => '<p>The name of the DB parameter group to associate with this DB instance.</p> <p>If you don\'t specify a value for <code>DBParameterGroupName</code>, then RDS uses the default <code>DBParameterGroup</code> for the specified DB engine.</p> <p>This setting doesn\'t apply to RDS Custom.</p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match the name of an existing DB parameter group.</p> </li> <li> <p>Must be 1 to 255 letters, numbers, or hyphens.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Can\'t end with a hyphen or contain two consecutive hyphens.</p> </li> </ul>', 'RestoreDBInstanceFromDBSnapshotMessage$CustomIamInstanceProfile' => '<p>The instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance. The instance profile must meet the following requirements:</p> <ul> <li> <p>The profile must exist in your account.</p> </li> <li> <p>The profile must have an IAM role that Amazon EC2 has permissions to assume.</p> </li> <li> <p>The instance profile name and the associated IAM role name must start with the prefix <code>AWSRDSCustom</code>.</p> </li> </ul> <p>For the list of permissions required for the IAM role, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-setup-orcl.html#custom-setup-orcl.iam-vpc"> Configure IAM and your VPC</a> in the <i>Amazon RDS User Guide</i>.</p> <p>This setting is required for RDS Custom.</p>', 'RestoreDBInstanceFromDBSnapshotMessage$BackupTarget' => '<p>Specifies where automated backups and manual snapshots are stored for the restored DB instance.</p> <p>Possible values are <code>outposts</code> (Amazon Web Services Outposts) and <code>region</code> (Amazon Web Services Region). The default is <code>region</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Working with Amazon RDS on Amazon Web Services Outposts</a> in the <i>Amazon RDS User Guide</i>.</p>', 'RestoreDBInstanceFromDBSnapshotMessage$NetworkType' => '<p>The network type of the DB instance.</p> <p>Valid Values:</p> <ul> <li> <p> <code>IPV4</code> </p> </li> <li> <p> <code>DUAL</code> </p> </li> </ul> <p>The network type is determined by the <code>DBSubnetGroup</code> specified for the DB instance. A <code>DBSubnetGroup</code> can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (<code>DUAL</code>).</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html"> Working with a DB instance in a VPC</a> in the <i>Amazon RDS User Guide.</i> </p>', 'RestoreDBInstanceFromDBSnapshotMessage$DBClusterSnapshotIdentifier' => '<p>The identifier for the Multi-AZ DB cluster snapshot to restore from.</p> <p>For more information on Multi-AZ DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB cluster deployments</a> in the <i>Amazon RDS User Guide</i>.</p> <p>Constraints:</p> <ul> <li> <p>Must match the identifier of an existing Multi-AZ DB cluster snapshot.</p> </li> <li> <p>Can\'t be specified when <code>DBSnapshotIdentifier</code> is specified.</p> </li> <li> <p>Must be specified when <code>DBSnapshotIdentifier</code> isn\'t specified.</p> </li> <li> <p>If you are restoring from a shared manual Multi-AZ DB cluster snapshot, the <code>DBClusterSnapshotIdentifier</code> must be the ARN of the shared snapshot.</p> </li> <li> <p>Can\'t be the identifier of an Aurora DB cluster snapshot.</p> </li> </ul>', 'RestoreDBInstanceFromDBSnapshotMessage$CACertificateIdentifier' => '<p>The CA certificate identifier to use for the DB instance\'s server certificate.</p> <p>This setting doesn\'t apply to RDS Custom DB instances.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html">Using SSL/TLS to encrypt a connection to a DB instance</a> in the <i>Amazon RDS User Guide</i> and <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html"> Using SSL/TLS to encrypt a connection to a DB cluster</a> in the <i>Amazon Aurora User Guide</i>.</p>', 'RestoreDBInstanceFromDBSnapshotMessage$EngineLifecycleSupport' => '<p>The life cycle type for this DB instance.</p> <note> <p>By default, this value is set to <code>open-source-rds-extended-support</code>, which enrolls your DB instance into Amazon RDS Extended Support. At the end of standard support, you can avoid charges for Extended Support by setting the value to <code>open-source-rds-extended-support-disabled</code>. In this case, RDS automatically upgrades your restored DB instance to a higher engine version, if the major engine version is past its end of standard support date.</p> </note> <p>You can use this setting to enroll your DB instance into Amazon RDS Extended Support. With RDS Extended Support, you can run the selected major engine version on your DB instance past the end of standard support for that engine version. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html">Using Amazon RDS Extended Support</a> in the <i>Amazon RDS User Guide</i>.</p> <p>This setting applies only to RDS for MySQL and RDS for PostgreSQL. For Amazon Aurora DB instances, the life cycle type is managed by the DB cluster.</p> <p>Valid Values: <code>open-source-rds-extended-support | open-source-rds-extended-support-disabled</code> </p> <p>Default: <code>open-source-rds-extended-support</code> </p>', 'RestoreDBInstanceFromS3Message$DBName' => '<p>The name of the database to create when the DB instance is created. Follow the naming rules specified in <code>CreateDBInstance</code>.</p>', 'RestoreDBInstanceFromS3Message$DBInstanceIdentifier' => '<p>The DB instance identifier. This parameter is stored as a lowercase string.</p> <p>Constraints:</p> <ul> <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Can\'t end with a hyphen or contain two consecutive hyphens.</p> </li> </ul> <p>Example: <code>mydbinstance</code> </p>', 'RestoreDBInstanceFromS3Message$DBInstanceClass' => '<p>The compute and memory capacity of the DB instance, for example db.m4.large. Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines. For the full list of DB instance classes, and availability for your engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB Instance Class</a> in the <i>Amazon RDS User Guide.</i> </p> <p>Importing from Amazon S3 isn\'t supported on the db.t2.micro DB instance class.</p>', 'RestoreDBInstanceFromS3Message$Engine' => '<p>The name of the database engine to be used for this instance.</p> <p>Valid Values: <code>mysql</code> </p>', 'RestoreDBInstanceFromS3Message$MasterUsername' => '<p>The name for the master user.</p> <p>Constraints:</p> <ul> <li> <p>Must be 1 to 16 letters or numbers.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Can\'t be a reserved word for the chosen database engine.</p> </li> </ul>', 'RestoreDBInstanceFromS3Message$MasterUserPassword' => '<p>The password for the master user.</p> <p>Constraints:</p> <ul> <li> <p>Can\'t be specified if <code>ManageMasterUserPassword</code> is turned on.</p> </li> <li> <p>Can include any printable ASCII character except "/", """, or "@". For RDS for Oracle, can\'t include the "&amp;" (ampersand) or the "\'" (single quotes) character.</p> </li> </ul> <p>Length Constraints:</p> <ul> <li> <p>RDS for Db2 - Must contain from 8 to 128 characters.</p> </li> <li> <p>RDS for MariaDB - Must contain from 8 to 41 characters.</p> </li> <li> <p>RDS for Microsoft SQL Server - Must contain from 8 to 128 characters.</p> </li> <li> <p>RDS for MySQL - Must contain from 8 to 41 characters.</p> </li> <li> <p>RDS for Oracle - Must contain from 8 to 30 characters.</p> </li> <li> <p>RDS for PostgreSQL - Must contain from 8 to 128 characters.</p> </li> </ul>', 'RestoreDBInstanceFromS3Message$AvailabilityZone' => '<p>The Availability Zone that the DB instance is created in. For information about Amazon Web Services Regions and Availability Zones, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html">Regions and Availability Zones</a> in the <i>Amazon RDS User Guide.</i> </p> <p>Default: A random, system-chosen Availability Zone in the endpoint\'s Amazon Web Services Region.</p> <p>Example: <code>us-east-1d</code> </p> <p>Constraint: The <code>AvailabilityZone</code> parameter can\'t be specified if the DB instance is a Multi-AZ deployment. The specified Availability Zone must be in the same Amazon Web Services Region as the current endpoint.</p>', 'RestoreDBInstanceFromS3Message$DBSubnetGroupName' => '<p>A DB subnet group to associate with this DB instance.</p> <p>Constraints: If supplied, must match the name of an existing DBSubnetGroup.</p> <p>Example: <code>mydbsubnetgroup</code> </p>', 'RestoreDBInstanceFromS3Message$PreferredMaintenanceWindow' => '<p>The time range each week during which system maintenance can occur, in Universal Coordinated Time (UTC). For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance">Amazon RDS Maintenance Window</a> in the <i>Amazon RDS User Guide.</i> </p> <p>Constraints:</p> <ul> <li> <p>Must be in the format <code>ddd:hh24:mi-ddd:hh24:mi</code>.</p> </li> <li> <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.</p> </li> <li> <p>Must be in Universal Coordinated Time (UTC).</p> </li> <li> <p>Must not conflict with the preferred backup window.</p> </li> <li> <p>Must be at least 30 minutes.</p> </li> </ul>', 'RestoreDBInstanceFromS3Message$DBParameterGroupName' => '<p>The name of the DB parameter group to associate with this DB instance.</p> <p>If you do not specify a value for <code>DBParameterGroupName</code>, then the default <code>DBParameterGroup</code> for the specified DB engine is used.</p>', 'RestoreDBInstanceFromS3Message$PreferredBackupWindow' => '<p>The time range each day during which automated backups are created if automated backups are enabled. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow">Backup window</a> in the <i>Amazon RDS User Guide.</i> </p> <p>Constraints:</p> <ul> <li> <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p> </li> <li> <p>Must be in Universal Coordinated Time (UTC).</p> </li> <li> <p>Must not conflict with the preferred maintenance window.</p> </li> <li> <p>Must be at least 30 minutes.</p> </li> </ul>', 'RestoreDBInstanceFromS3Message$EngineVersion' => '<p>The version number of the database engine to use. Choose the latest minor version of your database engine. For information about engine versions, see <code>CreateDBInstance</code>, or call <code>DescribeDBEngineVersions</code>.</p>', 'RestoreDBInstanceFromS3Message$LicenseModel' => '<p>The license model for this DB instance. Use <code>general-public-license</code>.</p>', 'RestoreDBInstanceFromS3Message$OptionGroupName' => '<p>The name of the option group to associate with this DB instance. If this argument is omitted, the default option group for the specified engine is used.</p>', 'RestoreDBInstanceFromS3Message$StorageType' => '<p>Specifies the storage type to be associated with the DB instance.</p> <p>Valid Values: <code>gp2 | gp3 | io1 | io2 | standard</code> </p> <p>If you specify <code>io1</code>, <code>io2</code>, or <code>gp3</code>, you must also include a value for the <code>Iops</code> parameter.</p> <p>Default: <code>io1</code> if the <code>Iops</code> parameter is specified; otherwise <code>gp2</code> </p>', 'RestoreDBInstanceFromS3Message$KmsKeyId' => '<p>The Amazon Web Services KMS key identifier for an encrypted DB instance.</p> <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.</p> <p>If the <code>StorageEncrypted</code> parameter is enabled, and you do not specify a value for the <code>KmsKeyId</code> parameter, then Amazon RDS will use your default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.</p>', 'RestoreDBInstanceFromS3Message$MonitoringRoleArn' => '<p>The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs. For example, <code>arn:aws:iam:123456789012:role/emaccess</code>. For information on creating a monitoring role, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling">Setting Up and Enabling Enhanced Monitoring</a> in the <i>Amazon RDS User Guide.</i> </p> <p>If <code>MonitoringInterval</code> is set to a value other than 0, then you must supply a <code>MonitoringRoleArn</code> value.</p>', 'RestoreDBInstanceFromS3Message$SourceEngine' => '<p>The name of the engine of your source database.</p> <p>Valid Values: <code>mysql</code> </p>', 'RestoreDBInstanceFromS3Message$SourceEngineVersion' => '<p>The version of the database that the backup files were created from.</p> <p>MySQL versions 5.6 and 5.7 are supported.</p> <p>Example: <code>5.6.40</code> </p>', 'RestoreDBInstanceFromS3Message$S3BucketName' => '<p>The name of your Amazon S3 bucket that contains your database backup file.</p>', 'RestoreDBInstanceFromS3Message$S3Prefix' => '<p>The prefix of your Amazon S3 bucket.</p>', 'RestoreDBInstanceFromS3Message$S3IngestionRoleArn' => '<p>An Amazon Web Services Identity and Access Management (IAM) role with a trust policy and a permissions policy that allows Amazon RDS to access your Amazon S3 bucket. For information about this role, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/MySQL.Procedural.Importing.html#MySQL.Procedural.Importing.Enabling.IAM"> Creating an IAM role manually</a> in the <i>Amazon RDS User Guide.</i> </p>', 'RestoreDBInstanceFromS3Message$PerformanceInsightsKMSKeyId' => '<p>The Amazon Web Services KMS key identifier for encryption of Performance Insights data.</p> <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p> <p>If you do not specify a value for <code>PerformanceInsightsKMSKeyId</code>, then Amazon RDS uses your default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.</p>', 'RestoreDBInstanceFromS3Message$NetworkType' => '<p>The network type of the DB instance.</p> <p>Valid Values:</p> <ul> <li> <p> <code>IPV4</code> </p> </li> <li> <p> <code>DUAL</code> </p> </li> </ul> <p>The network type is determined by the <code>DBSubnetGroup</code> specified for the DB instance. A <code>DBSubnetGroup</code> can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (<code>DUAL</code>).</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html"> Working with a DB instance in a VPC</a> in the <i>Amazon RDS User Guide.</i> </p>', 'RestoreDBInstanceFromS3Message$MasterUserSecretKmsKeyId' => '<p>The Amazon Web Services KMS key identifier to encrypt a secret that is automatically generated and managed in Amazon Web Services Secrets Manager.</p> <p>This setting is valid only if the master user password is managed by RDS in Amazon Web Services Secrets Manager for the DB instance.</p> <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.</p> <p>If you don\'t specify <code>MasterUserSecretKmsKeyId</code>, then the <code>aws/secretsmanager</code> KMS key is used to encrypt the secret. If the secret is in a different Amazon Web Services account, then you can\'t use the <code>aws/secretsmanager</code> KMS key to encrypt the secret, and you must use a customer managed KMS key.</p> <p>There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.</p>', 'RestoreDBInstanceFromS3Message$CACertificateIdentifier' => '<p>The CA certificate identifier to use for the DB instance\'s server certificate.</p> <p>This setting doesn\'t apply to RDS Custom DB instances.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html">Using SSL/TLS to encrypt a connection to a DB instance</a> in the <i>Amazon RDS User Guide</i> and <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html"> Using SSL/TLS to encrypt a connection to a DB cluster</a> in the <i>Amazon Aurora User Guide</i>.</p>', 'RestoreDBInstanceFromS3Message$EngineLifecycleSupport' => '<p>The life cycle type for this DB instance.</p> <note> <p>By default, this value is set to <code>open-source-rds-extended-support</code>, which enrolls your DB instance into Amazon RDS Extended Support. At the end of standard support, you can avoid charges for Extended Support by setting the value to <code>open-source-rds-extended-support-disabled</code>. In this case, RDS automatically upgrades your restored DB instance to a higher engine version, if the major engine version is past its end of standard support date.</p> </note> <p>You can use this setting to enroll your DB instance into Amazon RDS Extended Support. With RDS Extended Support, you can run the selected major engine version on your DB instance past the end of standard support for that engine version. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html">Using Amazon RDS Extended Support</a> in the <i>Amazon RDS User Guide</i>.</p> <p>This setting applies only to RDS for MySQL and RDS for PostgreSQL. For Amazon Aurora DB instances, the life cycle type is managed by the DB cluster.</p> <p>Valid Values: <code>open-source-rds-extended-support | open-source-rds-extended-support-disabled</code> </p> <p>Default: <code>open-source-rds-extended-support</code> </p>', 'RestoreDBInstanceToPointInTimeMessage$SourceDBInstanceIdentifier' => '<p>The identifier of the source DB instance from which to restore.</p> <p>Constraints:</p> <ul> <li> <p>Must match the identifier of an existing DB instance.</p> </li> </ul>', 'RestoreDBInstanceToPointInTimeMessage$TargetDBInstanceIdentifier' => '<p>The name of the new DB instance to create.</p> <p>Constraints:</p> <ul> <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Can\'t end with a hyphen or contain two consecutive hyphens.</p> </li> </ul>', 'RestoreDBInstanceToPointInTimeMessage$DBInstanceClass' => '<p>The compute and memory capacity of the Amazon RDS DB instance, for example db.m4.large. Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines. For the full list of DB instance classes, and availability for your engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB Instance Class</a> in the <i>Amazon RDS User Guide</i>.</p> <p>Default: The same DB instance class as the original DB instance.</p>', 'RestoreDBInstanceToPointInTimeMessage$AvailabilityZone' => '<p>The Availability Zone (AZ) where the DB instance will be created.</p> <p>Default: A random, system-chosen Availability Zone.</p> <p>Constraints:</p> <ul> <li> <p>You can\'t specify the <code>AvailabilityZone</code> parameter if the DB instance is a Multi-AZ deployment.</p> </li> </ul> <p>Example: <code>us-east-1a</code> </p>', 'RestoreDBInstanceToPointInTimeMessage$DBSubnetGroupName' => '<p>The DB subnet group name to use for the new instance.</p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match the name of an existing DB subnet group.</p> </li> </ul> <p>Example: <code>mydbsubnetgroup</code> </p>', 'RestoreDBInstanceToPointInTimeMessage$LicenseModel' => '<p>The license model information for the restored DB instance.</p> <note> <p>License models for RDS for Db2 require additional configuration. The Bring Your Own License (BYOL) model requires a custom parameter group. The Db2 license through Amazon Web Services Marketplace model requires an Amazon Web Services Marketplace subscription. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/db2-licensing.html">RDS for Db2 licensing options</a> in the <i>Amazon RDS User Guide</i>.</p> </note> <p>This setting doesn\'t apply to Amazon Aurora or RDS Custom DB instances.</p> <p>Valid Values:</p> <ul> <li> <p>RDS for Db2 - <code>bring-your-own-license | marketplace-license</code> </p> </li> <li> <p>RDS for MariaDB - <code>general-public-license</code> </p> </li> <li> <p>RDS for Microsoft SQL Server - <code>license-included</code> </p> </li> <li> <p>RDS for MySQL - <code>general-public-license</code> </p> </li> <li> <p>RDS for Oracle - <code>bring-your-own-license | license-included</code> </p> </li> <li> <p>RDS for PostgreSQL - <code>postgresql-license</code> </p> </li> </ul> <p>Default: Same as the source.</p>', 'RestoreDBInstanceToPointInTimeMessage$DBName' => '<p>The database name for the restored DB instance.</p> <p>This parameter doesn\'t apply to the following DB instances:</p> <ul> <li> <p>RDS Custom</p> </li> <li> <p>RDS for Db2</p> </li> <li> <p>RDS for MariaDB</p> </li> <li> <p>RDS for MySQL</p> </li> </ul>', 'RestoreDBInstanceToPointInTimeMessage$Engine' => '<p>The database engine to use for the new instance.</p> <p>This setting doesn\'t apply to RDS Custom.</p> <p>Valid Values:</p> <ul> <li> <p> <code>db2-ae</code> </p> </li> <li> <p> <code>db2-se</code> </p> </li> <li> <p> <code>mariadb</code> </p> </li> <li> <p> <code>mysql</code> </p> </li> <li> <p> <code>oracle-ee</code> </p> </li> <li> <p> <code>oracle-ee-cdb</code> </p> </li> <li> <p> <code>oracle-se2</code> </p> </li> <li> <p> <code>oracle-se2-cdb</code> </p> </li> <li> <p> <code>postgres</code> </p> </li> <li> <p> <code>sqlserver-ee</code> </p> </li> <li> <p> <code>sqlserver-se</code> </p> </li> <li> <p> <code>sqlserver-ex</code> </p> </li> <li> <p> <code>sqlserver-web</code> </p> </li> </ul> <p>Default: The same as source</p> <p>Constraints:</p> <ul> <li> <p>Must be compatible with the engine of the source.</p> </li> </ul>', 'RestoreDBInstanceToPointInTimeMessage$OptionGroupName' => '<p>The name of the option group to use for the restored DB instance.</p> <p>Permanent options, such as the TDE option for Oracle Advanced Security TDE, can\'t be removed from an option group, and that option group can\'t be removed from a DB instance after it is associated with a DB instance</p> <p>This setting doesn\'t apply to RDS Custom.</p>', 'RestoreDBInstanceToPointInTimeMessage$StorageType' => '<p>The storage type to associate with the DB instance.</p> <p>Valid Values: <code>gp2 | gp3 | io1 | io2 | standard</code> </p> <p>Default: <code>io1</code>, if the <code>Iops</code> parameter is specified. Otherwise, <code>gp2</code>.</p> <p>Constraints:</p> <ul> <li> <p>If you specify <code>io1</code>, <code>io2</code>, or <code>gp3</code>, you must also include a value for the <code>Iops</code> parameter.</p> </li> </ul>', 'RestoreDBInstanceToPointInTimeMessage$TdeCredentialArn' => '<p>The ARN from the key store with which to associate the instance for TDE encryption.</p> <p>This setting doesn\'t apply to RDS Custom.</p>', 'RestoreDBInstanceToPointInTimeMessage$TdeCredentialPassword' => '<p>The password for the given ARN from the key store in order to access the device.</p> <p>This setting doesn\'t apply to RDS Custom.</p>', 'RestoreDBInstanceToPointInTimeMessage$Domain' => '<p>The Active Directory directory ID to restore the DB instance in. Create the domain before running this command. Currently, you can create only the MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB instances in an Active Directory Domain.</p> <p>This setting doesn\'t apply to RDS Custom.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html"> Kerberos Authentication</a> in the <i>Amazon RDS User Guide</i>.</p>', 'RestoreDBInstanceToPointInTimeMessage$DomainIAMRoleName' => '<p>The name of the IAM role to use when making API calls to the Directory Service.</p> <p>This setting doesn\'t apply to RDS Custom DB instances.</p>', 'RestoreDBInstanceToPointInTimeMessage$DomainFqdn' => '<p>The fully qualified domain name (FQDN) of an Active Directory domain.</p> <p>Constraints:</p> <ul> <li> <p>Can\'t be longer than 64 characters.</p> </li> </ul> <p>Example: <code>mymanagedADtest.mymanagedAD.mydomain</code> </p>', 'RestoreDBInstanceToPointInTimeMessage$DomainOu' => '<p>The Active Directory organizational unit for your DB instance to join.</p> <p>Constraints:</p> <ul> <li> <p>Must be in the distinguished name format.</p> </li> <li> <p>Can\'t be longer than 64 characters.</p> </li> </ul> <p>Example: <code>OU=mymanagedADtestOU,DC=mymanagedADtest,DC=mymanagedAD,DC=mydomain</code> </p>', 'RestoreDBInstanceToPointInTimeMessage$DomainAuthSecretArn' => '<p>The ARN for the Secrets Manager secret with the credentials for the user joining the domain.</p> <p>Constraints:</p> <ul> <li> <p>Can\'t be longer than 64 characters.</p> </li> </ul> <p>Example: <code>arn:aws:secretsmanager:region:account-number:secret:myselfmanagedADtestsecret-123456</code> </p>', 'RestoreDBInstanceToPointInTimeMessage$DBParameterGroupName' => '<p>The name of the DB parameter group to associate with this DB instance.</p> <p>If you do not specify a value for <code>DBParameterGroupName</code>, then the default <code>DBParameterGroup</code> for the specified DB engine is used.</p> <p>This setting doesn\'t apply to RDS Custom.</p> <p>Constraints:</p> <ul> <li> <p>If supplied, must match the name of an existing DB parameter group.</p> </li> <li> <p>Must be 1 to 255 letters, numbers, or hyphens.</p> </li> <li> <p>First character must be a letter.</p> </li> <li> <p>Can\'t end with a hyphen or contain two consecutive hyphens.</p> </li> </ul>', 'RestoreDBInstanceToPointInTimeMessage$SourceDbiResourceId' => '<p>The resource ID of the source DB instance from which to restore.</p>', 'RestoreDBInstanceToPointInTimeMessage$SourceDBInstanceAutomatedBackupsArn' => '<p>The Amazon Resource Name (ARN) of the replicated automated backups from which to restore, for example, <code>arn:aws:rds:us-east-1:123456789012:auto-backup:ab-L2IJCEXJP7XQ7HOJ4SIEXAMPLE</code>.</p> <p>This setting doesn\'t apply to RDS Custom.</p>', 'RestoreDBInstanceToPointInTimeMessage$CustomIamInstanceProfile' => '<p>The instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance. The instance profile must meet the following requirements:</p> <ul> <li> <p>The profile must exist in your account.</p> </li> <li> <p>The profile must have an IAM role that Amazon EC2 has permissions to assume.</p> </li> <li> <p>The instance profile name and the associated IAM role name must start with the prefix <code>AWSRDSCustom</code>.</p> </li> </ul> <p>For the list of permissions required for the IAM role, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-setup-orcl.html#custom-setup-orcl.iam-vpc"> Configure IAM and your VPC</a> in the <i>Amazon RDS User Guide</i>.</p> <p>This setting is required for RDS Custom.</p>', 'RestoreDBInstanceToPointInTimeMessage$BackupTarget' => '<p>The location for storing automated backups and manual snapshots for the restored DB instance.</p> <p>Valid Values:</p> <ul> <li> <p> <code>outposts</code> (Amazon Web Services Outposts)</p> </li> <li> <p> <code>region</code> (Amazon Web Services Region)</p> </li> </ul> <p>Default: <code>region</code> </p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Working with Amazon RDS on Amazon Web Services Outposts</a> in the <i>Amazon RDS User Guide</i>.</p>', 'RestoreDBInstanceToPointInTimeMessage$NetworkType' => '<p>The network type of the DB instance.</p> <p>The network type is determined by the <code>DBSubnetGroup</code> specified for the DB instance. A <code>DBSubnetGroup</code> can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (<code>DUAL</code>).</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html"> Working with a DB instance in a VPC</a> in the <i>Amazon RDS User Guide.</i> </p> <p>Valid Values:</p> <ul> <li> <p> <code>IPV4</code> </p> </li> <li> <p> <code>DUAL</code> </p> </li> </ul>', 'RestoreDBInstanceToPointInTimeMessage$CACertificateIdentifier' => '<p>The CA certificate identifier to use for the DB instance\'s server certificate.</p> <p>This setting doesn\'t apply to RDS Custom DB instances.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html">Using SSL/TLS to encrypt a connection to a DB instance</a> in the <i>Amazon RDS User Guide</i> and <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html"> Using SSL/TLS to encrypt a connection to a DB cluster</a> in the <i>Amazon Aurora User Guide</i>.</p>', 'RestoreDBInstanceToPointInTimeMessage$EngineLifecycleSupport' => '<p>The life cycle type for this DB instance.</p> <note> <p>By default, this value is set to <code>open-source-rds-extended-support</code>, which enrolls your DB instance into Amazon RDS Extended Support. At the end of standard support, you can avoid charges for Extended Support by setting the value to <code>open-source-rds-extended-support-disabled</code>. In this case, RDS automatically upgrades your restored DB instance to a higher engine version, if the major engine version is past its end of standard support date.</p> </note> <p>You can use this setting to enroll your DB instance into Amazon RDS Extended Support. With RDS Extended Support, you can run the selected major engine version on your DB instance past the end of standard support for that engine version. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html">Using Amazon RDS Extended Support</a> in the <i>Amazon RDS User Guide</i>.</p> <p>This setting applies only to RDS for MySQL and RDS for PostgreSQL. For Amazon Aurora DB instances, the life cycle type is managed by the DB cluster.</p> <p>Valid Values: <code>open-source-rds-extended-support | open-source-rds-extended-support-disabled</code> </p> <p>Default: <code>open-source-rds-extended-support</code> </p>', 'RevokeDBSecurityGroupIngressMessage$DBSecurityGroupName' => '<p>The name of the DB security group to revoke ingress from.</p>', 'RevokeDBSecurityGroupIngressMessage$CIDRIP' => '<p>The IP range to revoke access from. Must be a valid CIDR range. If <code>CIDRIP</code> is specified, <code>EC2SecurityGroupName</code>, <code>EC2SecurityGroupId</code> and <code>EC2SecurityGroupOwnerId</code> can\'t be provided.</p>', 'RevokeDBSecurityGroupIngressMessage$EC2SecurityGroupName' => '<p>The name of the EC2 security group to revoke access from. For VPC DB security groups, <code>EC2SecurityGroupId</code> must be provided. Otherwise, EC2SecurityGroupOwnerId and either <code>EC2SecurityGroupName</code> or <code>EC2SecurityGroupId</code> must be provided.</p>', 'RevokeDBSecurityGroupIngressMessage$EC2SecurityGroupId' => '<p>The id of the EC2 security group to revoke access from. For VPC DB security groups, <code>EC2SecurityGroupId</code> must be provided. Otherwise, EC2SecurityGroupOwnerId and either <code>EC2SecurityGroupName</code> or <code>EC2SecurityGroupId</code> must be provided.</p>', 'RevokeDBSecurityGroupIngressMessage$EC2SecurityGroupOwnerId' => '<p>The Amazon Web Services account number of the owner of the EC2 security group specified in the <code>EC2SecurityGroupName</code> parameter. The Amazon Web Services access key ID isn\'t an acceptable value. For VPC DB security groups, <code>EC2SecurityGroupId</code> must be provided. Otherwise, EC2SecurityGroupOwnerId and either <code>EC2SecurityGroupName</code> or <code>EC2SecurityGroupId</code> must be provided.</p>', 'ScalingConfiguration$TimeoutAction' => '<p>The action to take when the timeout is reached, either <code>ForceApplyCapacityChange</code> or <code>RollbackCapacityChange</code>.</p> <p> <code>ForceApplyCapacityChange</code> sets the capacity to the specified value as soon as possible.</p> <p> <code>RollbackCapacityChange</code>, the default, ignores the capacity change if a scaling point isn\'t found in the timeout period.</p> <important> <p>If you specify <code>ForceApplyCapacityChange</code>, connections that prevent Aurora Serverless v1 from finding a scaling point might be dropped.</p> </important> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.how-it-works.html#aurora-serverless.how-it-works.auto-scaling"> Autoscaling for Aurora Serverless v1</a> in the <i>Amazon Aurora User Guide</i>.</p>', 'ScalingConfigurationInfo$TimeoutAction' => '<p>The action that occurs when Aurora times out while attempting to change the capacity of an Aurora Serverless v1 cluster. The value is either <code>ForceApplyCapacityChange</code> or <code>RollbackCapacityChange</code>.</p> <p> <code>ForceApplyCapacityChange</code>, the default, sets the capacity to the specified value as soon as possible.</p> <p> <code>RollbackCapacityChange</code> ignores the capacity change if a scaling point isn\'t found in the timeout period.</p>', 'SourceIdsList$member' => NULL, 'SourceRegion$RegionName' => '<p>The name of the source Amazon Web Services Region.</p>', 'SourceRegion$Endpoint' => '<p>The endpoint for the source Amazon Web Services Region endpoint.</p>', 'SourceRegion$Status' => '<p>The status of the source Amazon Web Services Region.</p>', 'SourceRegionMessage$Marker' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'StartActivityStreamRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the DB cluster, for example, <code>arn:aws:rds:us-east-1:12345667890:cluster:das-cluster</code>.</p>', 'StartActivityStreamRequest$KmsKeyId' => '<p>The Amazon Web Services KMS key identifier for encrypting messages in the database activity stream. The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>', 'StartActivityStreamResponse$KmsKeyId' => '<p>The Amazon Web Services KMS key identifier for encryption of messages in the database activity stream.</p>', 'StartActivityStreamResponse$KinesisStreamName' => '<p>The name of the Amazon Kinesis data stream to be used for the database activity stream.</p>', 'StartDBClusterMessage$DBClusterIdentifier' => '<p>The DB cluster identifier of the Amazon Aurora DB cluster to be started. This parameter is stored as a lowercase string.</p>', 'StartDBInstanceAutomatedBackupsReplicationMessage$SourceDBInstanceArn' => '<p>The Amazon Resource Name (ARN) of the source DB instance for the replicated automated backups, for example, <code>arn:aws:rds:us-west-2:123456789012:db:mydatabase</code>.</p>', 'StartDBInstanceAutomatedBackupsReplicationMessage$KmsKeyId' => '<p>The Amazon Web Services KMS key identifier for encryption of the replicated automated backups. The KMS key ID is the Amazon Resource Name (ARN) for the KMS encryption key in the destination Amazon Web Services Region, for example, <code>arn:aws:kms:us-east-1:123456789012:key/AKIAIOSFODNN7EXAMPLE</code>.</p>', 'StartDBInstanceAutomatedBackupsReplicationMessage$PreSignedUrl' => '<p>In an Amazon Web Services GovCloud (US) Region, an URL that contains a Signature Version 4 signed request for the <code>StartDBInstanceAutomatedBackupsReplication</code> operation to call in the Amazon Web Services Region of the source DB instance. The presigned URL must be a valid request for the <code>StartDBInstanceAutomatedBackupsReplication</code> API operation that can run in the Amazon Web Services Region that contains the source DB instance.</p> <p>This setting applies only to Amazon Web Services GovCloud (US) Regions. It\'s ignored in other Amazon Web Services Regions.</p> <p>To learn how to generate a Signature Version 4 signed request, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html"> Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4)</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html"> Signature Version 4 Signing Process</a>.</p> <note> <p>If you are using an Amazon Web Services SDK tool or the CLI, you can specify <code>SourceRegion</code> (or <code>--source-region</code> for the CLI) instead of specifying <code>PreSignedUrl</code> manually. Specifying <code>SourceRegion</code> autogenerates a presigned URL that is a valid request for the operation that can run in the source Amazon Web Services Region.</p> </note>', 'StartDBInstanceMessage$DBInstanceIdentifier' => '<p>The user-supplied instance identifier.</p>', 'StartExportTaskMessage$ExportTaskIdentifier' => '<p>A unique identifier for the export task. This ID isn\'t an identifier for the Amazon S3 bucket where the data is to be exported.</p>', 'StartExportTaskMessage$SourceArn' => '<p>The Amazon Resource Name (ARN) of the snapshot or cluster to export to Amazon S3.</p>', 'StartExportTaskMessage$S3BucketName' => '<p>The name of the Amazon S3 bucket to export the snapshot or cluster data to.</p>', 'StartExportTaskMessage$IamRoleArn' => '<p>The name of the IAM role to use for writing to the Amazon S3 bucket when exporting a snapshot or cluster.</p> <p>In the IAM policy attached to your IAM role, include the following required actions to allow the transfer of files from Amazon RDS or Amazon Aurora to an S3 bucket:</p> <ul> <li> <p>s3:PutObject*</p> </li> <li> <p>s3:GetObject*</p> </li> <li> <p>s3:ListBucket</p> </li> <li> <p>s3:DeleteObject*</p> </li> <li> <p>s3:GetBucketLocation </p> </li> </ul> <p>In the policy, include the resources to identify the S3 bucket and objects in the bucket. The following list of resources shows the Amazon Resource Name (ARN) format for accessing S3:</p> <ul> <li> <p> <code>arn:aws:s3:::<i>your-s3-bucket</i> </code> </p> </li> <li> <p> <code>arn:aws:s3:::<i>your-s3-bucket</i>/*</code> </p> </li> </ul>', 'StartExportTaskMessage$KmsKeyId' => '<p>The ID of the Amazon Web Services KMS key to use to encrypt the data exported to Amazon S3. The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. The caller of this operation must be authorized to run the following operations. These can be set in the Amazon Web Services KMS key policy:</p> <ul> <li> <p>kms:Encrypt</p> </li> <li> <p>kms:Decrypt</p> </li> <li> <p>kms:GenerateDataKey</p> </li> <li> <p>kms:GenerateDataKeyWithoutPlaintext</p> </li> <li> <p>kms:ReEncryptFrom</p> </li> <li> <p>kms:ReEncryptTo</p> </li> <li> <p>kms:CreateGrant</p> </li> <li> <p>kms:DescribeKey</p> </li> <li> <p>kms:RetireGrant</p> </li> </ul>', 'StartExportTaskMessage$S3Prefix' => '<p>The Amazon S3 bucket prefix to use as the file name and path of the exported data.</p>', 'StopActivityStreamRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the DB cluster for the database activity stream. For example, <code>arn:aws:rds:us-east-1:12345667890:cluster:das-cluster</code>.</p>', 'StopActivityStreamResponse$KmsKeyId' => '<p>The Amazon Web Services KMS key identifier used for encrypting messages in the database activity stream.</p> <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>', 'StopActivityStreamResponse$KinesisStreamName' => '<p>The name of the Amazon Kinesis data stream used for the database activity stream.</p>', 'StopDBClusterMessage$DBClusterIdentifier' => '<p>The DB cluster identifier of the Amazon Aurora DB cluster to be stopped. This parameter is stored as a lowercase string.</p>', 'StopDBInstanceAutomatedBackupsReplicationMessage$SourceDBInstanceArn' => '<p>The Amazon Resource Name (ARN) of the source DB instance for which to stop replicating automate backups, for example, <code>arn:aws:rds:us-west-2:123456789012:db:mydatabase</code>.</p>', 'StopDBInstanceMessage$DBInstanceIdentifier' => '<p>The user-supplied instance identifier.</p>', 'StopDBInstanceMessage$DBSnapshotIdentifier' => '<p>The user-supplied instance identifier of the DB Snapshot created immediately before the DB instance is stopped.</p>', 'StringList$member' => NULL, 'Subnet$SubnetIdentifier' => '<p>The identifier of the subnet.</p>', 'Subnet$SubnetStatus' => '<p>The status of the subnet.</p>', 'SubnetIdentifierList$member' => NULL, 'SwitchoverReadReplicaMessage$DBInstanceIdentifier' => '<p>The DB instance identifier of the current standby database. This value is stored as a lowercase string.</p> <p>Constraints:</p> <ul> <li> <p>Must match the identiﬁer of an existing Oracle read replica DB instance.</p> </li> </ul>', 'Tag$Key' => '<p>A key is the required name of the tag. The string value can be from 1 to 128 Unicode characters in length and can\'t be prefixed with <code>aws:</code> or <code>rds:</code>. The string can only contain only the set of Unicode letters, digits, white-space, \'_\', \'.\', \':\', \'/\', \'=\', \'+\', \'-\', \'@\' (Java regex: "^([\\\\p{L}\\\\p{Z}\\\\p{N}_.:/=+\\\\-@]*)$").</p>', 'Tag$Value' => '<p>A value is the optional value of the tag. The string value can be from 1 to 256 Unicode characters in length and can\'t be prefixed with <code>aws:</code> or <code>rds:</code>. The string can only contain only the set of Unicode letters, digits, white-space, \'_\', \'.\', \':\', \'/\', \'=\', \'+\', \'-\', \'@\' (Java regex: "^([\\\\p{L}\\\\p{Z}\\\\p{N}_.:/=+\\\\-@]*)$").</p>', 'TargetHealth$Description' => '<p>A description of the health of the RDS Proxy target. If the <code>State</code> is <code>AVAILABLE</code>, a description is not included.</p>', 'TenantDatabase$DBInstanceIdentifier' => '<p>The ID of the DB instance that contains the tenant database.</p>', 'TenantDatabase$TenantDBName' => '<p>The database name of the tenant database.</p>', 'TenantDatabase$Status' => '<p>The status of the tenant database.</p>', 'TenantDatabase$MasterUsername' => '<p>The master username of the tenant database.</p>', 'TenantDatabase$DbiResourceId' => '<p>The Amazon Web Services Region-unique, immutable identifier for the DB instance.</p>', 'TenantDatabase$TenantDatabaseResourceId' => '<p>The Amazon Web Services Region-unique, immutable identifier for the tenant database.</p>', 'TenantDatabase$TenantDatabaseARN' => '<p>The Amazon Resource Name (ARN) for the tenant database.</p>', 'TenantDatabase$CharacterSetName' => '<p>The character set of the tenant database.</p>', 'TenantDatabase$NcharCharacterSetName' => '<p>The <code>NCHAR</code> character set name of the tenant database.</p>', 'TenantDatabasePendingModifiedValues$TenantDBName' => '<p>The name of the tenant database.</p>', 'TenantDatabasesMessage$Marker' => '<p>An optional pagination token provided by a previous <code>DescribeTenantDatabases</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'Timezone$TimezoneName' => '<p>The name of the time zone.</p>', 'UpgradeTarget$Engine' => '<p>The name of the upgrade target database engine.</p>', 'UpgradeTarget$EngineVersion' => '<p>The version number of the upgrade target database engine.</p>', 'UpgradeTarget$Description' => '<p>The version of the database engine that a DB instance can be upgraded to.</p>', 'UserAuthConfig$Description' => '<p>A user-specified description about the authentication used by a proxy to log in as a specific database user.</p>', 'UserAuthConfig$UserName' => '<p>The name of the database user to which the proxy connects.</p>', 'UserAuthConfig$SecretArn' => '<p>The Amazon Resource Name (ARN) representing the secret that the proxy uses to authenticate to the RDS DB instance or Aurora DB cluster. These secrets are stored within Amazon Secrets Manager.</p>', 'UserAuthConfigInfo$Description' => '<p>A user-specified description about the authentication used by a proxy to log in as a specific database user.</p>', 'UserAuthConfigInfo$UserName' => '<p>The name of the database user to which the proxy connects.</p>', 'UserAuthConfigInfo$SecretArn' => '<p>The Amazon Resource Name (ARN) representing the secret that the proxy uses to authenticate to the RDS DB instance or Aurora DB cluster. These secrets are stored within Amazon Secrets Manager.</p>', 'ValidStorageOptions$StorageType' => '<p>The valid storage types for your DB instance. For example: gp2, gp3, io1, io2.</p>', 'VpcSecurityGroupIdList$member' => NULL, 'VpcSecurityGroupMembership$VpcSecurityGroupId' => '<p>The name of the VPC security group.</p>', 'VpcSecurityGroupMembership$Status' => '<p>The membership status of the VPC security group.</p> <p>Currently, the only valid status is <code>active</code>.</p>', ], ], 'String255' => [ 'base' => NULL, 'refs' => [ 'CreateCustomDBEngineVersionMessage$DatabaseInstallationFilesS3Prefix' => '<p>The Amazon S3 directory that contains the database installation files for your CEV. For example, a valid bucket name is <code>123456789012/cev1</code>. If this setting isn\'t specified, no prefix is assumed.</p>', 'CreateCustomDBEngineVersionMessage$ImageId' => '<p>The ID of the Amazon Machine Image (AMI). For RDS Custom for SQL Server, an AMI ID is required to create a CEV. For RDS Custom for Oracle, the default is the most recent AMI available, but you can specify an AMI ID that was used in a different Oracle CEV. Find the AMIs used by your CEVs by calling the <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBEngineVersions.html">DescribeDBEngineVersions</a> operation.</p>', 'CreateCustomDBEngineVersionMessage$SourceCustomDbEngineVersionIdentifier' => '<p>The ARN of a CEV to use as a source for creating a new CEV. You can specify a different Amazon Machine Imagine (AMI) by using either <code>Source</code> or <code>UseAwsProvidedLatestImage</code>. You can\'t specify a different JSON manifest when you specify <code>SourceCustomDbEngineVersionIdentifier</code>.</p>', ], ], 'StringList' => [ 'base' => NULL, 'refs' => [ 'ConnectionPoolConfiguration$SessionPinningFilters' => '<p>Each item in the list represents a class of SQL operations that normally cause all later statements in a session using a proxy to be pinned to the same underlying database connection. Including an item in the list exempts that class of SQL operations from the pinning behavior.</p> <p>Default: no session pinning filters</p>', 'ConnectionPoolConfigurationInfo$SessionPinningFilters' => '<p>Each item in the list represents a class of SQL operations that normally cause all later statements in a session using a proxy to be pinned to the same underlying database connection. Including an item in the list exempts that class of SQL operations from the pinning behavior. This setting is only supported for MySQL engine family databases. Currently, the only allowed value is <code>EXCLUDE_VARIABLE_SETS</code>.</p>', 'CreateDBClusterEndpointMessage$StaticMembers' => '<p>List of DB instance identifiers that are part of the custom endpoint group.</p>', 'CreateDBClusterEndpointMessage$ExcludedMembers' => '<p>List of DB instance identifiers that aren\'t part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. This parameter is relevant only if the list of static members is empty.</p>', 'CreateDBInstanceMessage$DomainDnsIps' => '<p>The IPv4 DNS IP addresses of your primary and secondary Active Directory domain controllers.</p> <p>Constraints:</p> <ul> <li> <p>Two IP addresses must be provided. If there isn\'t a secondary domain controller, use the IP address of the primary domain controller for both entries in the list.</p> </li> </ul> <p>Example: <code>123.124.125.126,234.235.236.237</code> </p>', 'CreateDBInstanceReadReplicaMessage$DomainDnsIps' => '<p>The IPv4 DNS IP addresses of your primary and secondary Active Directory domain controllers.</p> <p>Constraints:</p> <ul> <li> <p>Two IP addresses must be provided. If there isn\'t a secondary domain controller, use the IP address of the primary domain controller for both entries in the list.</p> </li> </ul> <p>Example: <code>123.124.125.126,234.235.236.237</code> </p>', 'CreateDBProxyEndpointRequest$VpcSubnetIds' => '<p>The VPC subnet IDs for the DB proxy endpoint that you create. You can specify a different set of subnet IDs than for the original DB proxy.</p>', 'CreateDBProxyEndpointRequest$VpcSecurityGroupIds' => '<p>The VPC security group IDs for the DB proxy endpoint that you create. You can specify a different set of security group IDs than for the original DB proxy. The default is the default security group for the VPC.</p>', 'CreateDBProxyRequest$VpcSubnetIds' => '<p>One or more VPC subnet IDs to associate with the new proxy.</p>', 'CreateDBProxyRequest$VpcSecurityGroupIds' => '<p>One or more VPC security group IDs to associate with the new proxy.</p>', 'DBCluster$CustomEndpoints' => '<p>The custom endpoints associated with the DB cluster.</p>', 'DBClusterEndpoint$StaticMembers' => '<p>List of DB instance identifiers that are part of the custom endpoint group.</p>', 'DBClusterEndpoint$ExcludedMembers' => '<p>List of DB instance identifiers that aren\'t part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty.</p>', 'DBProxy$VpcSecurityGroupIds' => '<p>Provides a list of VPC security groups that the proxy belongs to.</p>', 'DBProxy$VpcSubnetIds' => '<p>The EC2 subnet IDs for the proxy.</p>', 'DBProxyEndpoint$VpcSecurityGroupIds' => '<p>Provides a list of VPC security groups that the DB proxy endpoint belongs to.</p>', 'DBProxyEndpoint$VpcSubnetIds' => '<p>The EC2 subnet IDs for the DB proxy endpoint.</p>', 'DBSubnetGroup$SupportedNetworkTypes' => '<p>The network type of the DB subnet group.</p> <p>Valid values:</p> <ul> <li> <p> <code>IPV4</code> </p> </li> <li> <p> <code>DUAL</code> </p> </li> </ul> <p>A <code>DBSubnetGroup</code> can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (<code>DUAL</code>).</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html"> Working with a DB instance in a VPC</a> in the <i>Amazon RDS User Guide.</i> </p>', 'DeregisterDBProxyTargetsRequest$DBInstanceIdentifiers' => '<p>One or more DB instance identifiers.</p>', 'DeregisterDBProxyTargetsRequest$DBClusterIdentifiers' => '<p>One or more DB cluster identifiers.</p>', 'DomainMembership$DnsIps' => '<p>The IPv4 DNS IP addresses of the primary and secondary Active Directory domain controllers.</p>', 'ExportTask$ExportOnly' => '<p>The data exported from the snapshot or cluster.</p> <p>Valid Values:</p> <ul> <li> <p> <code>database</code> - Export all the data from a specified database.</p> </li> <li> <p> <code>database.table</code> <i>table-name</i> - Export a table of the snapshot or cluster. This format is valid only for RDS for MySQL, RDS for MariaDB, and Aurora MySQL.</p> </li> <li> <p> <code>database.schema</code> <i>schema-name</i> - Export a database schema of the snapshot or cluster. This format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.</p> </li> <li> <p> <code>database.schema.table</code> <i>table-name</i> - Export a table of the database schema. This format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.</p> </li> </ul>', 'ModifyDBClusterEndpointMessage$StaticMembers' => '<p>List of DB instance identifiers that are part of the custom endpoint group.</p>', 'ModifyDBClusterEndpointMessage$ExcludedMembers' => '<p>List of DB instance identifiers that aren\'t part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty.</p>', 'ModifyDBInstanceMessage$DomainDnsIps' => '<p>The IPv4 DNS IP addresses of your primary and secondary Active Directory domain controllers.</p> <p>Constraints:</p> <ul> <li> <p>Two IP addresses must be provided. If there isn\'t a secondary domain controller, use the IP address of the primary domain controller for both entries in the list.</p> </li> </ul> <p>Example: <code>123.124.125.126,234.235.236.237</code> </p>', 'ModifyDBProxyEndpointRequest$VpcSecurityGroupIds' => '<p>The VPC security group IDs for the DB proxy endpoint. When the DB proxy endpoint uses a different VPC than the original proxy, you also specify a different set of security group IDs than for the original proxy.</p>', 'ModifyDBProxyRequest$SecurityGroups' => '<p>The new list of security groups for the <code>DBProxy</code>.</p>', 'OrderableDBInstanceOption$SupportedNetworkTypes' => '<p>The network types supported by the DB instance (<code>IPV4</code> or <code>DUAL</code>).</p> <p>A DB instance can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (<code>DUAL</code>).</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html"> Working with a DB instance in a VPC</a> in the <i>Amazon RDS User Guide.</i> </p>', 'PerformanceInsightsMetricDimensionGroup$Dimensions' => '<p>A list of specific dimensions from a dimension group. If this list isn\'t included, then all of the dimensions in the group were requested, or are present in the response.</p>', 'RecommendedAction$ApplyModes' => '<p>The methods to apply the recommended action.</p> <p>Valid values:</p> <ul> <li> <p> <code>manual</code> - The action requires you to resolve the recommendation manually.</p> </li> <li> <p> <code>immediately</code> - The action is applied immediately.</p> </li> <li> <p> <code>next-maintainance-window</code> - The action is applied during the next scheduled maintainance.</p> </li> </ul>', 'RegisterDBProxyTargetsRequest$DBInstanceIdentifiers' => '<p>One or more DB instance identifiers.</p>', 'RegisterDBProxyTargetsRequest$DBClusterIdentifiers' => '<p>One or more DB cluster identifiers.</p>', 'RestoreDBInstanceFromDBSnapshotMessage$DomainDnsIps' => '<p>The IPv4 DNS IP addresses of your primary and secondary Active Directory domain controllers.</p> <p>Constraints:</p> <ul> <li> <p>Two IP addresses must be provided. If there isn\'t a secondary domain controller, use the IP address of the primary domain controller for both entries in the list.</p> </li> </ul> <p>Example: <code>123.124.125.126,234.235.236.237</code> </p>', 'RestoreDBInstanceToPointInTimeMessage$DomainDnsIps' => '<p>The IPv4 DNS IP addresses of your primary and secondary Active Directory domain controllers.</p> <p>Constraints:</p> <ul> <li> <p>Two IP addresses must be provided. If there isn\'t a secondary domain controller, use the IP address of the primary domain controller for both entries in the list.</p> </li> </ul> <p>Example: <code>123.124.125.126,234.235.236.237</code> </p>', 'StartExportTaskMessage$ExportOnly' => '<p>The data to be exported from the snapshot or cluster. If this parameter isn\'t provided, all of the data is exported.</p> <p>Valid Values:</p> <ul> <li> <p> <code>database</code> - Export all the data from a specified database.</p> </li> <li> <p> <code>database.table</code> <i>table-name</i> - Export a table of the snapshot or cluster. This format is valid only for RDS for MySQL, RDS for MariaDB, and Aurora MySQL.</p> </li> <li> <p> <code>database.schema</code> <i>schema-name</i> - Export a database schema of the snapshot or cluster. This format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.</p> </li> <li> <p> <code>database.schema.table</code> <i>table-name</i> - Export a table of the database schema. This format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.</p> </li> </ul>', ], ], 'Subnet' => [ 'base' => '<p>This data type is used as a response element for the <code>DescribeDBSubnetGroups</code> operation.</p>', 'refs' => [ 'SubnetList$member' => NULL, ], ], 'SubnetAlreadyInUse' => [ 'base' => '<p>The DB subnet is already in use in the Availability Zone.</p>', 'refs' => [], ], 'SubnetIdentifierList' => [ 'base' => NULL, 'refs' => [ 'CreateDBSubnetGroupMessage$SubnetIds' => '<p>The EC2 Subnet IDs for the DB subnet group.</p>', 'ModifyDBSubnetGroupMessage$SubnetIds' => '<p>The EC2 subnet IDs for the DB subnet group.</p>', ], ], 'SubnetList' => [ 'base' => NULL, 'refs' => [ 'DBSubnetGroup$Subnets' => '<p>Contains a list of <code>Subnet</code> elements.</p>', ], ], 'SubscriptionAlreadyExistFault' => [ 'base' => '<p>The supplied subscription name already exists.</p>', 'refs' => [], ], 'SubscriptionCategoryNotFoundFault' => [ 'base' => '<p>The supplied category does not exist.</p>', 'refs' => [], ], 'SubscriptionNotFoundFault' => [ 'base' => '<p>The subscription name does not exist.</p>', 'refs' => [], ], 'SupportedCharacterSetsList' => [ 'base' => NULL, 'refs' => [ 'DBEngineVersion$SupportedCharacterSets' => '<p>A list of the character sets supported by this engine for the <code>CharacterSetName</code> parameter of the <code>CreateDBInstance</code> operation.</p>', 'DBEngineVersion$SupportedNcharCharacterSets' => '<p>A list of the character sets supported by the Oracle DB engine for the <code>NcharCharacterSetName</code> parameter of the <code>CreateDBInstance</code> operation.</p>', ], ], 'SupportedTimezonesList' => [ 'base' => NULL, 'refs' => [ 'DBEngineVersion$SupportedTimezones' => '<p>A list of the time zones supported by this engine for the <code>Timezone</code> parameter of the <code>CreateDBInstance</code> action.</p>', ], ], 'SwitchoverBlueGreenDeploymentRequest' => [ 'base' => NULL, 'refs' => [], ], 'SwitchoverBlueGreenDeploymentResponse' => [ 'base' => NULL, 'refs' => [], ], 'SwitchoverDetail' => [ 'base' => '<p>Contains the details about a blue/green deployment.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/blue-green-deployments.html">Using Amazon RDS Blue/Green Deployments for database updates</a> in the <i>Amazon RDS User Guide</i> and <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/blue-green-deployments.html">Using Amazon RDS Blue/Green Deployments for database updates</a> in the <i>Amazon Aurora User Guide</i>.</p>', 'refs' => [ 'SwitchoverDetailList$member' => NULL, ], ], 'SwitchoverDetailList' => [ 'base' => NULL, 'refs' => [ 'BlueGreenDeployment$SwitchoverDetails' => '<p>The details about each source and target resource in the blue/green deployment.</p>', ], ], 'SwitchoverDetailStatus' => [ 'base' => NULL, 'refs' => [ 'SwitchoverDetail$Status' => '<p>The switchover status of a resource in a blue/green deployment.</p> <p>Values:</p> <ul> <li> <p> <code>PROVISIONING</code> - The resource is being prepared to switch over.</p> </li> <li> <p> <code>AVAILABLE</code> - The resource is ready to switch over.</p> </li> <li> <p> <code>SWITCHOVER_IN_PROGRESS</code> - The resource is being switched over.</p> </li> <li> <p> <code>SWITCHOVER_COMPLETED</code> - The resource has been switched over.</p> </li> <li> <p> <code>SWITCHOVER_FAILED</code> - The resource attempted to switch over but failed.</p> </li> <li> <p> <code>MISSING_SOURCE</code> - The source resource has been deleted.</p> </li> <li> <p> <code>MISSING_TARGET</code> - The target resource has been deleted.</p> </li> </ul>', ], ], 'SwitchoverGlobalClusterMessage' => [ 'base' => NULL, 'refs' => [], ], 'SwitchoverGlobalClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'SwitchoverReadReplicaMessage' => [ 'base' => NULL, 'refs' => [], ], 'SwitchoverReadReplicaResult' => [ 'base' => NULL, 'refs' => [], ], 'SwitchoverTimeout' => [ 'base' => NULL, 'refs' => [ 'SwitchoverBlueGreenDeploymentRequest$SwitchoverTimeout' => '<p>The amount of time, in seconds, for the switchover to complete.</p> <p>Default: 300</p> <p>If the switchover takes longer than the specified duration, then any changes are rolled back, and no changes are made to the environments.</p>', ], ], 'TStamp' => [ 'base' => NULL, 'refs' => [ 'BacktrackDBClusterMessage$BacktrackTo' => '<p>The timestamp of the time to backtrack the DB cluster to, specified in ISO 8601 format. For more information about ISO 8601, see the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a> </p> <note> <p>If the specified time isn\'t a consistent time for the DB cluster, Aurora automatically chooses the nearest possible consistent time for the DB cluster.</p> </note> <p>Constraints:</p> <ul> <li> <p>Must contain a valid ISO 8601 timestamp.</p> </li> <li> <p>Can\'t contain a timestamp set in the future.</p> </li> </ul> <p>Example: <code>2017-07-08T18:00Z</code> </p>', 'BlueGreenDeployment$CreateTime' => '<p>The time when the blue/green deployment was created, in Universal Coordinated Time (UTC).</p>', 'BlueGreenDeployment$DeleteTime' => '<p>The time when the blue/green deployment was deleted, in Universal Coordinated Time (UTC).</p>', 'Certificate$ValidFrom' => '<p>The starting date from which the certificate is valid.</p>', 'Certificate$ValidTill' => '<p>The final date that the certificate continues to be valid.</p>', 'Certificate$CustomerOverrideValidTill' => '<p>If there is an override for the default certificate identifier, when the override expires.</p>', 'CertificateDetails$ValidTill' => '<p>The expiration date of the DB instance’s server certificate.</p>', 'DBCluster$AutomaticRestartTime' => '<p>The time when a stopped DB cluster is restarted automatically.</p>', 'DBCluster$EarliestRestorableTime' => '<p>The earliest time to which a database can be restored with point-in-time restore.</p>', 'DBCluster$LatestRestorableTime' => '<p>The latest time to which a database can be restored with point-in-time restore.</p>', 'DBCluster$ClusterCreateTime' => '<p>The time when the DB cluster was created, in Universal Coordinated Time (UTC).</p>', 'DBCluster$EarliestBacktrackTime' => '<p>The earliest time to which a DB cluster can be backtracked.</p>', 'DBCluster$IOOptimizedNextAllowedModificationTime' => '<p>The next time you can modify the DB cluster to use the <code>aurora-iopt1</code> storage type.</p> <p>This setting is only for Aurora DB clusters.</p>', 'DBClusterAutomatedBackup$ClusterCreateTime' => '<p>The time when the DB cluster was created, in Universal Coordinated Time (UTC).</p>', 'DBClusterBacktrack$BacktrackTo' => '<p>The timestamp of the time to which the DB cluster was backtracked.</p>', 'DBClusterBacktrack$BacktrackedFrom' => '<p>The timestamp of the time from which the DB cluster was backtracked.</p>', 'DBClusterBacktrack$BacktrackRequestCreationTime' => '<p>The timestamp of the time at which the backtrack was requested.</p>', 'DBClusterSnapshot$SnapshotCreateTime' => '<p>The time when the snapshot was taken, in Universal Coordinated Time (UTC).</p>', 'DBClusterSnapshot$ClusterCreateTime' => '<p>The time when the DB cluster was created, in Universal Coordinated Time (UTC).</p>', 'DBEngineVersion$CreateTime' => '<p>The creation time of the DB engine version.</p>', 'DBInstance$AutomaticRestartTime' => '<p>The time when a stopped DB instance is restarted automatically.</p>', 'DBInstance$InstanceCreateTime' => '<p>The date and time when the DB instance was created.</p>', 'DBInstance$LatestRestorableTime' => '<p>The latest time to which a database in this DB instance can be restored with point-in-time restore.</p>', 'DBInstance$ResumeFullAutomationModeTime' => '<p>The number of minutes to pause the automation. When the time period ends, RDS Custom resumes full automation. The minimum value is 60 (default). The maximum value is 1,440.</p>', 'DBInstanceAutomatedBackup$InstanceCreateTime' => '<p>The date and time when the DB instance was created.</p>', 'DBProxy$CreatedDate' => '<p>The date and time when the proxy was first created.</p>', 'DBProxy$UpdatedDate' => '<p>The date and time when the proxy was last updated.</p>', 'DBProxyEndpoint$CreatedDate' => '<p>The date and time when the DB proxy endpoint was first created.</p>', 'DBProxyTargetGroup$CreatedDate' => '<p>The date and time when the target group was first created.</p>', 'DBProxyTargetGroup$UpdatedDate' => '<p>The date and time when the target group was last updated.</p>', 'DBRecommendation$CreatedTime' => '<p>The time when the recommendation was created. For example, <code>2023-09-28T01:13:53.931000+00:00</code>.</p>', 'DBRecommendation$UpdatedTime' => '<p>The time when the recommendation was last updated.</p>', 'DBSnapshot$SnapshotCreateTime' => '<p>Specifies when the snapshot was taken in Coordinated Universal Time (UTC). Changes for the copy when the snapshot is copied.</p>', 'DBSnapshot$InstanceCreateTime' => '<p>Specifies the time in Coordinated Universal Time (UTC) when the DB instance, from which the snapshot was taken, was created.</p>', 'DBSnapshot$OriginalSnapshotCreateTime' => '<p>Specifies the time of the CreateDBSnapshot operation in Coordinated Universal Time (UTC). Doesn\'t change when the snapshot is copied.</p>', 'DBSnapshot$SnapshotDatabaseTime' => '<p>The timestamp of the most recent transaction applied to the database that you\'re backing up. Thus, if you restore a snapshot, SnapshotDatabaseTime is the most recent transaction in the restored DB instance. In contrast, originalSnapshotCreateTime specifies the system time that the snapshot completed.</p> <p>If you back up a read replica, you can determine the replica lag by comparing SnapshotDatabaseTime with originalSnapshotCreateTime. For example, if originalSnapshotCreateTime is two hours later than SnapshotDatabaseTime, then the replica lag is two hours.</p>', 'DBSnapshotTenantDatabase$TenantDatabaseCreateTime' => '<p>The time the DB snapshot was taken, specified in Coordinated Universal Time (UTC). If you copy the snapshot, the creation time changes.</p>', 'DescribeDBRecommendationsMessage$LastUpdatedAfter' => '<p>A filter to include only the recommendations that were updated after this specified time.</p>', 'DescribeDBRecommendationsMessage$LastUpdatedBefore' => '<p>A filter to include only the recommendations that were updated before this specified time.</p>', 'DescribeEventsMessage$StartTime' => '<p>The beginning of the time interval to retrieve events for, specified in ISO 8601 format. For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a> </p> <p>Example: 2009-07-08T18:00Z</p>', 'DescribeEventsMessage$EndTime' => '<p>The end of the time interval for which to retrieve events, specified in ISO 8601 format. For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a> </p> <p>Example: 2009-07-08T18:00Z</p>', 'Event$Date' => '<p>Specifies the date and time of the event.</p>', 'ExportTask$SnapshotTime' => '<p>The time when the snapshot was created.</p>', 'ExportTask$TaskStartTime' => '<p>The time when the snapshot or cluster export task started.</p>', 'ExportTask$TaskEndTime' => '<p>The time when the snapshot or cluster export task ended.</p>', 'Integration$CreateTime' => '<p>The time when the integration was created, in Universal Coordinated Time (UTC).</p>', 'OptionGroup$CopyTimestamp' => '<p>Indicates when the option group was copied.</p>', 'PendingMaintenanceAction$AutoAppliedAfterDate' => '<p>The date of the maintenance window when the action is applied. The maintenance action is applied to the resource during its first maintenance window after this date.</p>', 'PendingMaintenanceAction$ForcedApplyDate' => '<p>The date when the maintenance action is automatically applied.</p> <p>On this date, the maintenance action is applied to the resource as soon as possible, regardless of the maintenance window for the resource. There might be a delay of one or more days from this date before the maintenance action is applied.</p>', 'PendingMaintenanceAction$CurrentApplyDate' => '<p>The effective date when the pending maintenance action is applied to the resource. This date takes into account opt-in requests received from the <code>ApplyPendingMaintenanceAction</code> API, the <code>AutoAppliedAfterDate</code>, and the <code>ForcedApplyDate</code>. This value is blank if an opt-in request has not been received and nothing has been specified as <code>AutoAppliedAfterDate</code> or <code>ForcedApplyDate</code>.</p>', 'PendingModifiedValues$ResumeFullAutomationModeTime' => '<p>The number of minutes to pause the automation. When the time period ends, RDS Custom resumes full automation. The minimum value is 60 (default). The maximum value is 1,440.</p>', 'PerformanceIssueDetails$StartTime' => '<p>The time when the performance issue started.</p>', 'PerformanceIssueDetails$EndTime' => '<p>The time when the performance issue stopped.</p>', 'ReservedDBInstance$StartTime' => '<p>The time the reservation started.</p>', 'RestoreDBClusterToPointInTimeMessage$RestoreToTime' => '<p>The date and time to restore the DB cluster to.</p> <p>Valid Values: Value must be a time in Universal Coordinated Time (UTC) format</p> <p>Constraints:</p> <ul> <li> <p>Must be before the latest restorable time for the DB instance</p> </li> <li> <p>Must be specified if <code>UseLatestRestorableTime</code> parameter isn\'t provided</p> </li> <li> <p>Can\'t be specified if the <code>UseLatestRestorableTime</code> parameter is enabled</p> </li> <li> <p>Can\'t be specified if the <code>RestoreType</code> parameter is <code>copy-on-write</code> </p> </li> </ul> <p>Example: <code>2015-03-07T23:45:00Z</code> </p> <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>', 'RestoreDBInstanceToPointInTimeMessage$RestoreTime' => '<p>The date and time to restore from.</p> <p>Constraints:</p> <ul> <li> <p>Must be a time in Universal Coordinated Time (UTC) format.</p> </li> <li> <p>Must be before the latest restorable time for the DB instance.</p> </li> <li> <p>Can\'t be specified if the <code>UseLatestRestorableTime</code> parameter is enabled.</p> </li> </ul> <p>Example: <code>2009-09-07T23:45:00Z</code> </p>', 'RestoreWindow$EarliestTime' => '<p>The earliest time you can restore an instance to.</p>', 'RestoreWindow$LatestTime' => '<p>The latest time you can restore an instance to.</p>', 'TenantDatabase$TenantDatabaseCreateTime' => '<p>The creation time of the tenant database.</p>', ], ], 'Tag' => [ 'base' => '<p>Metadata assigned to an Amazon RDS resource consisting of a key-value pair.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide</i> or <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Tagging.html">Tagging Amazon Aurora and Amazon RDS Resources</a> in the <i>Amazon Aurora User Guide</i>. </p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagList' => [ 'base' => '<p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>', 'refs' => [ 'AddTagsToResourceMessage$Tags' => '<p>The tags to be assigned to the Amazon RDS resource.</p>', 'BlueGreenDeployment$TagList' => NULL, 'CopyDBClusterParameterGroupMessage$Tags' => NULL, 'CopyDBClusterSnapshotMessage$Tags' => NULL, 'CopyDBParameterGroupMessage$Tags' => NULL, 'CopyDBSnapshotMessage$Tags' => NULL, 'CopyOptionGroupMessage$Tags' => NULL, 'CreateBlueGreenDeploymentRequest$Tags' => '<p>Tags to assign to the blue/green deployment.</p>', 'CreateCustomDBEngineVersionMessage$Tags' => NULL, 'CreateDBClusterEndpointMessage$Tags' => '<p>The tags to be assigned to the Amazon RDS resource.</p>', 'CreateDBClusterMessage$Tags' => '<p>Tags to assign to the DB cluster.</p> <p>Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters</p>', 'CreateDBClusterParameterGroupMessage$Tags' => '<p>Tags to assign to the DB cluster parameter group.</p>', 'CreateDBClusterSnapshotMessage$Tags' => '<p>The tags to be assigned to the DB cluster snapshot.</p>', 'CreateDBInstanceMessage$Tags' => '<p>Tags to assign to the DB instance.</p>', 'CreateDBInstanceReadReplicaMessage$Tags' => NULL, 'CreateDBParameterGroupMessage$Tags' => '<p>Tags to assign to the DB parameter group.</p>', 'CreateDBProxyEndpointRequest$Tags' => NULL, 'CreateDBProxyRequest$Tags' => '<p>An optional set of key-value pairs to associate arbitrary data of your choosing with the proxy.</p>', 'CreateDBSecurityGroupMessage$Tags' => '<p>Tags to assign to the DB security group.</p>', 'CreateDBSnapshotMessage$Tags' => NULL, 'CreateDBSubnetGroupMessage$Tags' => '<p>Tags to assign to the DB subnet group.</p>', 'CreateEventSubscriptionMessage$Tags' => NULL, 'CreateIntegrationMessage$Tags' => NULL, 'CreateOptionGroupMessage$Tags' => '<p>Tags to assign to the option group.</p>', 'CreateTenantDatabaseMessage$Tags' => NULL, 'DBCluster$TagList' => NULL, 'DBClusterSnapshot$TagList' => NULL, 'DBEngineVersion$TagList' => NULL, 'DBInstance$TagList' => NULL, 'DBSnapshot$TagList' => NULL, 'DBSnapshotTenantDatabase$TagList' => NULL, 'Integration$Tags' => NULL, 'PurchaseReservedDBInstancesOfferingMessage$Tags' => NULL, 'RestoreDBClusterFromS3Message$Tags' => NULL, 'RestoreDBClusterFromSnapshotMessage$Tags' => '<p>The tags to be assigned to the restored DB cluster.</p> <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>', 'RestoreDBClusterToPointInTimeMessage$Tags' => NULL, 'RestoreDBInstanceFromDBSnapshotMessage$Tags' => NULL, 'RestoreDBInstanceFromS3Message$Tags' => '<p>A list of tags to associate with this DB instance. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>', 'RestoreDBInstanceToPointInTimeMessage$Tags' => NULL, 'TagListMessage$TagList' => '<p>List of tags returned by the <code>ListTagsForResource</code> operation.</p>', 'TenantDatabase$TagList' => NULL, ], ], 'TagListMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'TargetDBClusterParameterGroupName' => [ 'base' => NULL, 'refs' => [ 'CreateBlueGreenDeploymentRequest$TargetDBClusterParameterGroupName' => '<p>The DB cluster parameter group associated with the Aurora DB cluster in the green environment.</p> <p>To test parameter changes, specify a DB cluster parameter group that is different from the one associated with the source DB cluster.</p>', ], ], 'TargetDBInstanceClass' => [ 'base' => NULL, 'refs' => [ 'CreateBlueGreenDeploymentRequest$TargetDBInstanceClass' => '<p>Specify the DB instance class for the databases in the green environment.</p> <p>This parameter only applies to RDS DB instances, because DB instances within an Aurora DB cluster can have multiple different instance classes. If you\'re creating a blue/green deployment from an Aurora DB cluster, don\'t specify this parameter. After the green environment is created, you can individually modify the instance classes of the DB instances within the green DB cluster.</p>', ], ], 'TargetDBParameterGroupName' => [ 'base' => NULL, 'refs' => [ 'CreateBlueGreenDeploymentRequest$TargetDBParameterGroupName' => '<p>The DB parameter group associated with the DB instance in the green environment.</p> <p>To test parameter changes, specify a DB parameter group that is different from the one associated with the source DB instance.</p>', ], ], 'TargetEngineVersion' => [ 'base' => NULL, 'refs' => [ 'CreateBlueGreenDeploymentRequest$TargetEngineVersion' => '<p>The engine version of the database in the green environment.</p> <p>Specify the engine version to upgrade to in the green environment.</p>', ], ], 'TargetGroupList' => [ 'base' => NULL, 'refs' => [ 'DescribeDBProxyTargetGroupsResponse$TargetGroups' => '<p>An arbitrary number of <code>DBProxyTargetGroup</code> objects, containing details of the corresponding target groups.</p>', ], ], 'TargetHealth' => [ 'base' => '<p>Information about the connection health of an RDS Proxy target.</p>', 'refs' => [ 'DBProxyTarget$TargetHealth' => '<p>Information about the connection health of the RDS Proxy target.</p>', ], ], 'TargetHealthReason' => [ 'base' => NULL, 'refs' => [ 'TargetHealth$Reason' => '<p>The reason for the current health <code>State</code> of the RDS Proxy target.</p>', ], ], 'TargetList' => [ 'base' => NULL, 'refs' => [ 'DescribeDBProxyTargetsResponse$Targets' => '<p>An arbitrary number of <code>DBProxyTarget</code> objects, containing details of the corresponding targets.</p>', 'RegisterDBProxyTargetsResponse$DBProxyTargets' => '<p>One or more <code>DBProxyTarget</code> objects that are created when you register targets with a target group.</p>', ], ], 'TargetRole' => [ 'base' => NULL, 'refs' => [ 'DBProxyTarget$Role' => '<p>A value that indicates whether the target of the proxy can be used for read/write or read-only operations.</p>', ], ], 'TargetState' => [ 'base' => NULL, 'refs' => [ 'TargetHealth$State' => '<p>The current state of the connection health lifecycle for the RDS Proxy target. The following is a typical lifecycle example for the states of an RDS Proxy target:</p> <p> <code>registering</code> &gt; <code>unavailable</code> &gt; <code>available</code> &gt; <code>unavailable</code> &gt; <code>available</code> </p>', ], ], 'TargetType' => [ 'base' => NULL, 'refs' => [ 'DBProxyTarget$Type' => '<p>Specifies the kind of database, such as an RDS DB instance or an Aurora DB cluster, that the target represents.</p>', ], ], 'TenantDatabase' => [ 'base' => '<p>A tenant database in the DB instance. This data type is an element in the response to the <code>DescribeTenantDatabases</code> action.</p>', 'refs' => [ 'CreateTenantDatabaseResult$TenantDatabase' => NULL, 'DeleteTenantDatabaseResult$TenantDatabase' => NULL, 'ModifyTenantDatabaseResult$TenantDatabase' => NULL, 'TenantDatabasesList$member' => NULL, ], ], 'TenantDatabaseAlreadyExistsFault' => [ 'base' => '<p>You attempted to either create a tenant database that already exists or modify a tenant database to use the name of an existing tenant database.</p>', 'refs' => [], ], 'TenantDatabaseNotFoundFault' => [ 'base' => '<p>The specified tenant database wasn\'t found in the DB instance.</p>', 'refs' => [], ], 'TenantDatabasePendingModifiedValues' => [ 'base' => '<p>A response element in the <code>ModifyTenantDatabase</code> operation that describes changes that will be applied. Specific changes are identified by subelements.</p>', 'refs' => [ 'TenantDatabase$PendingModifiedValues' => '<p>Information about pending changes for a tenant database.</p>', ], ], 'TenantDatabaseQuotaExceededFault' => [ 'base' => '<p>You attempted to create more tenant databases than are permitted in your Amazon Web Services account.</p>', 'refs' => [], ], 'TenantDatabasesList' => [ 'base' => NULL, 'refs' => [ 'TenantDatabasesMessage$TenantDatabases' => '<p>An array of the tenant databases requested by the <code>DescribeTenantDatabases</code> operation.</p>', ], ], 'TenantDatabasesMessage' => [ 'base' => NULL, 'refs' => [], ], 'Timezone' => [ 'base' => '<p>A time zone associated with a <code>DBInstance</code> or a <code>DBSnapshot</code>. This data type is an element in the response to the <code>DescribeDBInstances</code>, the <code>DescribeDBSnapshots</code>, and the <code>DescribeDBEngineVersions</code> actions.</p>', 'refs' => [ 'SupportedTimezonesList$member' => NULL, ], ], 'UnsupportedDBEngineVersionFault' => [ 'base' => '<p>The specified DB engine version isn\'t supported for Aurora Limitless Database.</p>', 'refs' => [], ], 'UpgradeTarget' => [ 'base' => '<p>The version of the database engine that a DB instance can be upgraded to.</p>', 'refs' => [ 'ValidUpgradeTargetList$member' => NULL, ], ], 'UserAuthConfig' => [ 'base' => '<p>Specifies the details of authentication used by a proxy to log in as a specific database user.</p>', 'refs' => [ 'UserAuthConfigList$member' => NULL, ], ], 'UserAuthConfigInfo' => [ 'base' => '<p>Returns the details of authentication used by a proxy to log in as a specific database user.</p>', 'refs' => [ 'UserAuthConfigInfoList$member' => NULL, ], ], 'UserAuthConfigInfoList' => [ 'base' => NULL, 'refs' => [ 'DBProxy$Auth' => '<p>One or more data structures specifying the authorization mechanism to connect to the associated RDS DB instance or Aurora DB cluster.</p>', ], ], 'UserAuthConfigList' => [ 'base' => NULL, 'refs' => [ 'CreateDBProxyRequest$Auth' => '<p>The authorization mechanism that the proxy uses.</p>', 'ModifyDBProxyRequest$Auth' => '<p>The new authentication settings for the <code>DBProxy</code>.</p>', ], ], 'ValidDBInstanceModificationsMessage' => [ 'base' => '<p>Information about valid modifications that you can make to your DB instance. Contains the result of a successful call to the <code>DescribeValidDBInstanceModifications</code> action. You can use this information when you call <code>ModifyDBInstance</code>.</p>', 'refs' => [ 'DescribeValidDBInstanceModificationsResult$ValidDBInstanceModificationsMessage' => NULL, ], ], 'ValidStorageOptions' => [ 'base' => '<p>Information about valid modifications that you can make to your DB instance. Contains the result of a successful call to the <code>DescribeValidDBInstanceModifications</code> action.</p>', 'refs' => [ 'ValidStorageOptionsList$member' => NULL, ], ], 'ValidStorageOptionsList' => [ 'base' => NULL, 'refs' => [ 'ValidDBInstanceModificationsMessage$Storage' => '<p>Valid storage options for your DB instance.</p>', ], ], 'ValidUpgradeTargetList' => [ 'base' => NULL, 'refs' => [ 'DBEngineVersion$ValidUpgradeTarget' => '<p>A list of engine versions that this database engine version can be upgraded to.</p>', ], ], 'VpcSecurityGroupIdList' => [ 'base' => NULL, 'refs' => [ 'CreateDBClusterMessage$VpcSecurityGroupIds' => '<p>A list of EC2 VPC security groups to associate with this DB cluster.</p> <p>Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters</p>', 'CreateDBInstanceMessage$VpcSecurityGroupIds' => '<p>A list of Amazon EC2 VPC security groups to associate with this DB instance.</p> <p>This setting doesn\'t apply to Amazon Aurora DB instances. The associated list of EC2 VPC security groups is managed by the DB cluster.</p> <p>Default: The default EC2 VPC security group for the DB subnet group\'s VPC.</p>', 'CreateDBInstanceReadReplicaMessage$VpcSecurityGroupIds' => '<p>A list of Amazon EC2 VPC security groups to associate with the read replica.</p> <p>This setting doesn\'t apply to RDS Custom DB instances.</p> <p>Default: The default EC2 VPC security group for the DB subnet group\'s VPC.</p>', 'ModifyDBClusterMessage$VpcSecurityGroupIds' => '<p>A list of EC2 VPC security groups to associate with this DB cluster.</p> <p>Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters</p>', 'ModifyDBInstanceMessage$VpcSecurityGroupIds' => '<p>A list of Amazon EC2 VPC security groups to associate with this DB instance. This change is asynchronously applied as soon as possible.</p> <p>This setting doesn\'t apply to the following DB instances:</p> <ul> <li> <p>Amazon Aurora (The associated list of EC2 VPC security groups is managed by the DB cluster. For more information, see <code>ModifyDBCluster</code>.)</p> </li> <li> <p>RDS Custom</p> </li> </ul> <p>Constraints:</p> <ul> <li> <p>If supplied, must match existing VPC security group IDs.</p> </li> </ul>', 'OptionConfiguration$VpcSecurityGroupMemberships' => '<p>A list of VpcSecurityGroupMembership name strings used for this option.</p>', 'RestoreDBClusterFromS3Message$VpcSecurityGroupIds' => '<p>A list of EC2 VPC security groups to associate with the restored DB cluster.</p>', 'RestoreDBClusterFromSnapshotMessage$VpcSecurityGroupIds' => '<p>A list of VPC security groups that the new DB cluster will belong to.</p> <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>', 'RestoreDBClusterToPointInTimeMessage$VpcSecurityGroupIds' => '<p>A list of VPC security groups that the new DB cluster belongs to.</p> <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>', 'RestoreDBInstanceFromDBSnapshotMessage$VpcSecurityGroupIds' => '<p>A list of EC2 VPC security groups to associate with this DB instance.</p> <p>Default: The default EC2 VPC security group for the DB subnet group\'s VPC.</p>', 'RestoreDBInstanceFromS3Message$VpcSecurityGroupIds' => '<p>A list of VPC security groups to associate with this DB instance.</p>', 'RestoreDBInstanceToPointInTimeMessage$VpcSecurityGroupIds' => '<p>A list of EC2 VPC security groups to associate with this DB instance.</p> <p>Default: The default EC2 VPC security group for the DB subnet group\'s VPC.</p>', ], ], 'VpcSecurityGroupMembership' => [ 'base' => '<p>This data type is used as a response element for queries on VPC security group membership.</p>', 'refs' => [ 'VpcSecurityGroupMembershipList$member' => NULL, ], ], 'VpcSecurityGroupMembershipList' => [ 'base' => NULL, 'refs' => [ 'DBCluster$VpcSecurityGroups' => '<p>The list of VPC security groups that the DB cluster belongs to.</p>', 'DBInstance$VpcSecurityGroups' => '<p>The list of Amazon EC2 VPC security groups that the DB instance belongs to.</p>', 'Option$VpcSecurityGroupMemberships' => '<p>If the option requires access to a port, then this VPC security group allows access to the port.</p>', ], ], 'WriteForwardingStatus' => [ 'base' => NULL, 'refs' => [ 'DBCluster$GlobalWriteForwardingStatus' => '<p>The status of write forwarding for a secondary cluster in an Aurora global database.</p>', 'GlobalClusterMember$GlobalWriteForwardingStatus' => '<p>The status of write forwarding for a secondary cluster in the global cluster.</p>', ], ], ],];
