<?php
// This file was auto-generated from sdk-root/src/data/rum/2018-05-10/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>With Amazon CloudWatch RUM, you can perform real-user monitoring to collect client-side data about your web application performance from actual user sessions in real time. The data collected includes page load times, client-side errors, and user behavior. When you view this data, you can see it all aggregated together and also see breakdowns by the browsers and devices that your customers use.</p> <p>You can use the collected data to quickly identify and debug client-side performance issues. CloudWatch RUM helps you visualize anomalies in your application performance and find relevant debugging data such as error messages, stack traces, and user sessions. You can also use RUM to understand the range of end-user impact including the number of users, geolocations, and browsers used.</p>', 'operations' => [ 'BatchCreateRumMetricDefinitions' => '<p>Specifies the extended metrics and custom metrics that you want a CloudWatch RUM app monitor to send to a destination. Valid destinations include CloudWatch and Evidently.</p> <p>By default, RUM app monitors send some metrics to CloudWatch. These default metrics are listed in <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-metrics.html">CloudWatch metrics that you can collect with CloudWatch RUM</a>.</p> <p>In addition to these default metrics, you can choose to send extended metrics, custom metrics, or both.</p> <ul> <li> <p>Extended metrics let you send metrics with additional dimensions that aren\'t included in the default metrics. You can also send extended metrics to both Evidently and CloudWatch. The valid dimension names for the additional dimensions for extended metrics are <code>BrowserName</code>, <code>CountryCode</code>, <code>DeviceType</code>, <code>FileType</code>, <code>OSName</code>, and <code>PageId</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-vended-metrics.html"> Extended metrics that you can send to CloudWatch and CloudWatch Evidently</a>.</p> </li> <li> <p>Custom metrics are metrics that you define. You can send custom metrics to CloudWatch. CloudWatch Evidently, or both. With custom metrics, you can use any metric name and namespace. To derive the metrics, you can use any custom events, built-in events, custom attributes, or default attributes. </p> <p>You can\'t send custom metrics to the <code>AWS/RUM</code> namespace. You must send custom metrics to a custom namespace that you define. The namespace that you use can\'t start with <code>AWS/</code>. CloudWatch RUM prepends <code>RUM/CustomMetrics/</code> to the custom namespace that you define, so the final namespace for your metrics in CloudWatch is <code>RUM/CustomMetrics/<i>your-custom-namespace</i> </code>.</p> </li> </ul> <p>The maximum number of metric definitions that you can specify in one <code>BatchCreateRumMetricDefinitions</code> operation is 200.</p> <p>The maximum number of metric definitions that one destination can contain is 2000.</p> <p>Extended metrics sent to CloudWatch and RUM custom metrics are charged as CloudWatch custom metrics. Each combination of additional dimension name and dimension value counts as a custom metric. For more information, see <a href="https://aws.amazon.com/cloudwatch/pricing/">Amazon CloudWatch Pricing</a>.</p> <p>You must have already created a destination for the metrics before you send them. For more information, see <a href="https://docs.aws.amazon.com/cloudwatchrum/latest/APIReference/API_PutRumMetricsDestination.html">PutRumMetricsDestination</a>.</p> <p>If some metric definitions specified in a <code>BatchCreateRumMetricDefinitions</code> operations are not valid, those metric definitions fail and return errors, but all valid metric definitions in the same operation still succeed.</p>', 'BatchDeleteRumMetricDefinitions' => '<p>Removes the specified metrics from being sent to an extended metrics destination.</p> <p>If some metric definition IDs specified in a <code>BatchDeleteRumMetricDefinitions</code> operations are not valid, those metric definitions fail and return errors, but all valid metric definition IDs in the same operation are still deleted.</p> <p>The maximum number of metric definitions that you can specify in one <code>BatchDeleteRumMetricDefinitions</code> operation is 200.</p>', 'BatchGetRumMetricDefinitions' => '<p>Retrieves the list of metrics and dimensions that a RUM app monitor is sending to a single destination.</p>', 'CreateAppMonitor' => '<p>Creates a Amazon CloudWatch RUM app monitor, which collects telemetry data from your application and sends that data to RUM. The data includes performance and reliability information such as page load time, client-side errors, and user behavior.</p> <p>You use this operation only to create a new app monitor. To update an existing app monitor, use <a href="https://docs.aws.amazon.com/cloudwatchrum/latest/APIReference/API_UpdateAppMonitor.html">UpdateAppMonitor</a> instead.</p> <p>After you create an app monitor, sign in to the CloudWatch RUM console to get the JavaScript code snippet to add to your web application. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-find-code-snippet.html">How do I find a code snippet that I\'ve already generated?</a> </p>', 'DeleteAppMonitor' => '<p>Deletes an existing app monitor. This immediately stops the collection of data.</p>', 'DeleteRumMetricsDestination' => '<p>Deletes a destination for CloudWatch RUM extended metrics, so that the specified app monitor stops sending extended metrics to that destination.</p>', 'GetAppMonitor' => '<p>Retrieves the complete configuration information for one app monitor.</p>', 'GetAppMonitorData' => '<p>Retrieves the raw performance events that RUM has collected from your web application, so that you can do your own processing or analysis of this data.</p>', 'ListAppMonitors' => '<p>Returns a list of the Amazon CloudWatch RUM app monitors in the account.</p>', 'ListRumMetricsDestinations' => '<p>Returns a list of destinations that you have created to receive RUM extended metrics, for the specified app monitor.</p> <p>For more information about extended metrics, see <a href="https://docs.aws.amazon.com/cloudwatchrum/latest/APIReference/API_AddRumMetrcs.html">AddRumMetrics</a>.</p>', 'ListTagsForResource' => '<p>Displays the tags associated with a CloudWatch RUM resource.</p>', 'PutRumEvents' => '<p>Sends telemetry events about your application performance and user behavior to CloudWatch RUM. The code snippet that RUM generates for you to add to your application includes <code>PutRumEvents</code> operations to send this data to RUM.</p> <p>Each <code>PutRumEvents</code> operation can send a batch of events from one user session.</p>', 'PutRumMetricsDestination' => '<p>Creates or updates a destination to receive extended metrics from CloudWatch RUM. You can send extended metrics to CloudWatch or to a CloudWatch Evidently experiment.</p> <p>For more information about extended metrics, see <a href="https://docs.aws.amazon.com/cloudwatchrum/latest/APIReference/API_BatchCreateRumMetricDefinitions.html">BatchCreateRumMetricDefinitions</a>.</p>', 'TagResource' => '<p>Assigns one or more tags (key-value pairs) to the specified CloudWatch RUM resource. Currently, the only resources that can be tagged app monitors.</p> <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.</p> <p>Tags don\'t have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.</p> <p>You can use the <code>TagResource</code> action with a resource that already has tags. If you specify a new tag key for the resource, this tag is appended to the list of tags associated with the alarm. If you specify a tag key that is already associated with the resource, the new tag value that you specify replaces the previous value for that tag.</p> <p>You can associate as many as 50 tags with a resource.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>.</p>', 'UntagResource' => '<p>Removes one or more tags from the specified resource.</p>', 'UpdateAppMonitor' => '<p>Updates the configuration of an existing app monitor. When you use this operation, only the parts of the app monitor configuration that you specify in this operation are changed. For any parameters that you omit, the existing values are kept.</p> <p>You can\'t use this operation to change the tags of an existing app monitor. To change the tags of an existing app monitor, use <a href="https://docs.aws.amazon.com/cloudwatchrum/latest/APIReference/API_TagResource.html">TagResource</a>.</p> <p>To create a new app monitor, use <a href="https://docs.aws.amazon.com/cloudwatchrum/latest/APIReference/API_CreateAppMonitor.html">CreateAppMonitor</a>.</p> <p>After you update an app monitor, sign in to the CloudWatch RUM console to get the updated JavaScript code snippet to add to your web application. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-find-code-snippet.html">How do I find a code snippet that I\'ve already generated?</a> </p>', 'UpdateRumMetricDefinition' => '<p>Modifies one existing metric definition for CloudWatch RUM extended metrics. For more information about extended metrics, see <a href="https://docs.aws.amazon.com/cloudwatchrum/latest/APIReference/API_BatchCreateRumMetricsDefinitions.html">BatchCreateRumMetricsDefinitions</a>.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You don\'t have sufficient permissions to perform this action.</p>', 'refs' => [], ], 'AppMonitor' => [ 'base' => '<p>A RUM app monitor collects telemetry data from your application and sends that data to RUM. The data includes performance and reliability information such as page load time, client-side errors, and user behavior.</p>', 'refs' => [ 'GetAppMonitorResponse$AppMonitor' => '<p>A structure containing all the configuration information for the app monitor.</p>', ], ], 'AppMonitorConfiguration' => [ 'base' => '<p>This structure contains much of the configuration data for the app monitor.</p>', 'refs' => [ 'AppMonitor$AppMonitorConfiguration' => '<p>A structure that contains much of the configuration data for the app monitor.</p>', 'CreateAppMonitorRequest$AppMonitorConfiguration' => '<p>A structure that contains much of the configuration data for the app monitor. If you are using Amazon Cognito for authorization, you must include this structure in your request, and it must include the ID of the Amazon Cognito identity pool to use for authorization. If you don\'t include <code>AppMonitorConfiguration</code>, you must set up your own authorization method. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-get-started-authorization.html">Authorize your application to send data to Amazon Web Services</a>.</p> <p>If you omit this argument, the sample rate used for RUM is set to 10% of the user sessions.</p>', 'UpdateAppMonitorRequest$AppMonitorConfiguration' => '<p>A structure that contains much of the configuration data for the app monitor. If you are using Amazon Cognito for authorization, you must include this structure in your request, and it must include the ID of the Amazon Cognito identity pool to use for authorization. If you don\'t include <code>AppMonitorConfiguration</code>, you must set up your own authorization method. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-get-started-authorization.html">Authorize your application to send data to Amazon Web Services</a>.</p>', ], ], 'AppMonitorDetails' => [ 'base' => '<p>A structure that contains information about the RUM app monitor.</p>', 'refs' => [ 'PutRumEventsRequest$AppMonitorDetails' => '<p>A structure that contains information about the app monitor that collected this telemetry information.</p>', ], ], 'AppMonitorDomain' => [ 'base' => NULL, 'refs' => [ 'AppMonitor$Domain' => '<p>The top-level internet domain name for which your application has administrative authority.</p>', 'CreateAppMonitorRequest$Domain' => '<p>The top-level internet domain name for which your application has administrative authority.</p>', 'UpdateAppMonitorRequest$Domain' => '<p>The top-level internet domain name for which your application has administrative authority.</p>', ], ], 'AppMonitorId' => [ 'base' => NULL, 'refs' => [ 'AppMonitor$Id' => '<p>The unique ID of this app monitor.</p>', 'AppMonitorSummary$Id' => '<p>The unique ID of this app monitor.</p>', 'CreateAppMonitorResponse$Id' => '<p>The unique ID of the new app monitor.</p>', ], ], 'AppMonitorName' => [ 'base' => NULL, 'refs' => [ 'AppMonitor$Name' => '<p>The name of the app monitor.</p>', 'AppMonitorSummary$Name' => '<p>The name of this app monitor.</p>', 'BatchCreateRumMetricDefinitionsRequest$AppMonitorName' => '<p>The name of the CloudWatch RUM app monitor that is to send the metrics.</p>', 'BatchDeleteRumMetricDefinitionsRequest$AppMonitorName' => '<p>The name of the CloudWatch RUM app monitor that is sending these metrics.</p>', 'BatchGetRumMetricDefinitionsRequest$AppMonitorName' => '<p>The name of the CloudWatch RUM app monitor that is sending the metrics.</p>', 'CreateAppMonitorRequest$Name' => '<p>A name for the app monitor.</p>', 'DeleteAppMonitorRequest$Name' => '<p>The name of the app monitor to delete.</p>', 'DeleteRumMetricsDestinationRequest$AppMonitorName' => '<p>The name of the app monitor that is sending metrics to the destination that you want to delete.</p>', 'GetAppMonitorDataRequest$Name' => '<p>The name of the app monitor that collected the data that you want to retrieve.</p>', 'GetAppMonitorRequest$Name' => '<p>The app monitor to retrieve information for.</p>', 'ListRumMetricsDestinationsRequest$AppMonitorName' => '<p>The name of the app monitor associated with the destinations that you want to retrieve.</p>', 'PutRumMetricsDestinationRequest$AppMonitorName' => '<p>The name of the CloudWatch RUM app monitor that will send the metrics.</p>', 'UpdateAppMonitorRequest$Name' => '<p>The name of the app monitor to update.</p>', 'UpdateRumMetricDefinitionRequest$AppMonitorName' => '<p>The name of the CloudWatch RUM app monitor that sends these metrics.</p>', ], ], 'AppMonitorSummary' => [ 'base' => '<p>A structure that includes some data about app monitors and their settings.</p>', 'refs' => [ 'AppMonitorSummaryList$member' => NULL, ], ], 'AppMonitorSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListAppMonitorsResponse$AppMonitorSummaries' => '<p>An array of structures that contain information about the returned app monitors.</p>', ], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'AppMonitorConfiguration$GuestRoleArn' => '<p>The ARN of the guest IAM role that is attached to the Amazon Cognito identity pool that is used to authorize the sending of data to RUM.</p> <note> <p>It is possible that an app monitor does not have a value for <code>GuestRoleArn</code>. For example, this can happen when you use the console to create an app monitor and you allow CloudWatch RUM to create a new identity pool for Authorization. In this case, <code>GuestRoleArn</code> is not present in the <a href="https://docs.aws.amazon.com/cloudwatchrum/latest/APIReference/API_GetAppMonitor.html">GetAppMonitor</a> response because it is not stored by the service.</p> <p>If this issue affects you, you can take one of the following steps:</p> <ul> <li> <p>Use the Cloud Development Kit (CDK) to create an identity pool and the associated IAM role, and use that for your app monitor.</p> </li> <li> <p>Make a separate <a href="https://docs.aws.amazon.com/cognitoidentity/latest/APIReference/API_GetIdentityPoolRoles.html">GetIdentityPoolRoles</a> call to Amazon Cognito to retrieve the <code>GuestRoleArn</code>.</p> </li> </ul> </note>', 'ListTagsForResourceRequest$ResourceArn' => '<p>The ARN of the resource that you want to see the tags of.</p>', 'ListTagsForResourceResponse$ResourceArn' => '<p>The ARN of the resource that you are viewing.</p>', 'TagResourceRequest$ResourceArn' => '<p>The ARN of the CloudWatch RUM resource that you\'re adding tags to.</p>', 'UntagResourceRequest$ResourceArn' => '<p>The ARN of the CloudWatch RUM resource that you\'re removing tags from.</p>', ], ], 'BatchCreateRumMetricDefinitionsError' => [ 'base' => '<p>A structure that defines one error caused by a <a href="https://docs.aws.amazon.com/cloudwatchrum/latest/APIReference/API_BatchCreateRumMetricsDefinitions.html">BatchCreateRumMetricsDefinitions</a> operation.</p>', 'refs' => [ 'BatchCreateRumMetricDefinitionsErrors$member' => NULL, ], ], 'BatchCreateRumMetricDefinitionsErrors' => [ 'base' => NULL, 'refs' => [ 'BatchCreateRumMetricDefinitionsResponse$Errors' => '<p>An array of error objects, if the operation caused any errors.</p>', ], ], 'BatchCreateRumMetricDefinitionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchCreateRumMetricDefinitionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchDeleteRumMetricDefinitionsError' => [ 'base' => '<p>A structure that defines one error caused by a <a href="https://docs.aws.amazon.com/cloudwatchrum/latest/APIReference/API_BatchDeleteRumMetricsDefinitions.html">BatchCreateRumMetricsDefinitions</a> operation.</p>', 'refs' => [ 'BatchDeleteRumMetricDefinitionsErrors$member' => NULL, ], ], 'BatchDeleteRumMetricDefinitionsErrors' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteRumMetricDefinitionsResponse$Errors' => '<p>An array of error objects, if the operation caused any errors.</p>', ], ], 'BatchDeleteRumMetricDefinitionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchDeleteRumMetricDefinitionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetRumMetricDefinitionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetRumMetricDefinitionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'AppMonitorConfiguration$AllowCookies' => '<p>If you set this to <code>true</code>, the RUM web client sets two cookies, a session cookie and a user cookie. The cookies allow the RUM web client to collect data relating to the number of users an application has and the behavior of the application across a sequence of events. Cookies are stored in the top-level domain of the current page.</p>', 'AppMonitorConfiguration$EnableXRay' => '<p>If you set this to <code>true</code>, RUM enables X-Ray tracing for the user sessions that RUM samples. RUM adds an X-Ray trace header to allowed HTTP requests. It also records an X-Ray segment for allowed HTTP requests. You can see traces and segments from these user sessions in the X-Ray console and the CloudWatch ServiceLens console. For more information, see <a href="https://docs.aws.amazon.com/xray/latest/devguide/aws-xray.html">What is X-Ray?</a> </p>', 'CreateAppMonitorRequest$CwLogEnabled' => '<p>Data collected by RUM is kept by RUM for 30 days and then deleted. This parameter specifies whether RUM sends a copy of this telemetry data to Amazon CloudWatch Logs in your account. This enables you to keep the telemetry data for more than 30 days, but it does incur Amazon CloudWatch Logs charges.</p> <p>If you omit this parameter, the default is <code>false</code>.</p>', 'CwLog$CwLogEnabled' => '<p>Indicated whether the app monitor stores copies of the data that RUM collects in CloudWatch Logs.</p>', 'UpdateAppMonitorRequest$CwLogEnabled' => '<p>Data collected by RUM is kept by RUM for 30 days and then deleted. This parameter specifies whether RUM sends a copy of this telemetry data to Amazon CloudWatch Logs in your account. This enables you to keep the telemetry data for more than 30 days, but it does incur Amazon CloudWatch Logs charges.</p>', ], ], 'ConflictException' => [ 'base' => '<p>This operation attempted to create a resource that already exists.</p>', 'refs' => [], ], 'CreateAppMonitorRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAppMonitorResponse' => [ 'base' => NULL, 'refs' => [], ], 'CustomEvents' => [ 'base' => '<p>A structure that contains information about custom events for this app monitor.</p>', 'refs' => [ 'AppMonitor$CustomEvents' => '<p>Specifies whether this app monitor allows the web client to define and send custom events.</p> <p>For more information about custom events, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-custom-events.html">Send custom events</a>.</p>', 'CreateAppMonitorRequest$CustomEvents' => '<p>Specifies whether this app monitor allows the web client to define and send custom events. If you omit this parameter, custom events are <code>DISABLED</code>.</p> <p>For more information about custom events, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-custom-events.html">Send custom events</a>.</p>', 'UpdateAppMonitorRequest$CustomEvents' => '<p>Specifies whether this app monitor allows the web client to define and send custom events. The default is for custom events to be <code>DISABLED</code>.</p> <p>For more information about custom events, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-custom-events.html">Send custom events</a>.</p>', ], ], 'CustomEventsStatus' => [ 'base' => NULL, 'refs' => [ 'CustomEvents$Status' => '<p>Specifies whether this app monitor allows the web client to define and send custom events. The default is for custom events to be <code>DISABLED</code>.</p>', ], ], 'CwLog' => [ 'base' => '<p>A structure that contains the information about whether the app monitor stores copies of the data that RUM collects in CloudWatch Logs. If it does, this structure also contains the name of the log group.</p>', 'refs' => [ 'DataStorage$CwLog' => '<p>A structure that contains the information about whether the app monitor stores copies of the data that RUM collects in CloudWatch Logs. If it does, this structure also contains the name of the log group.</p>', ], ], 'DataStorage' => [ 'base' => '<p>A structure that contains information about whether this app monitor stores a copy of the telemetry data that RUM collects using CloudWatch Logs.</p>', 'refs' => [ 'AppMonitor$DataStorage' => '<p>A structure that contains information about whether this app monitor stores a copy of the telemetry data that RUM collects using CloudWatch Logs.</p>', ], ], 'DeleteAppMonitorRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAppMonitorResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRumMetricsDestinationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRumMetricsDestinationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DestinationArn' => [ 'base' => NULL, 'refs' => [ 'BatchCreateRumMetricDefinitionsRequest$DestinationArn' => '<p>This parameter is required if <code>Destination</code> is <code>Evidently</code>. If <code>Destination</code> is <code>CloudWatch</code>, do not use this parameter.</p> <p>This parameter specifies the ARN of the Evidently experiment that is to receive the metrics. You must have already defined this experiment as a valid destination. For more information, see <a href="https://docs.aws.amazon.com/cloudwatchrum/latest/APIReference/API_PutRumMetricsDestination.html">PutRumMetricsDestination</a>.</p>', 'BatchDeleteRumMetricDefinitionsRequest$DestinationArn' => '<p>This parameter is required if <code>Destination</code> is <code>Evidently</code>. If <code>Destination</code> is <code>CloudWatch</code>, do not use this parameter. </p> <p>This parameter specifies the ARN of the Evidently experiment that was receiving the metrics that are being deleted.</p>', 'BatchGetRumMetricDefinitionsRequest$DestinationArn' => '<p>This parameter is required if <code>Destination</code> is <code>Evidently</code>. If <code>Destination</code> is <code>CloudWatch</code>, do not use this parameter.</p> <p>This parameter specifies the ARN of the Evidently experiment that corresponds to the destination.</p>', 'DeleteRumMetricsDestinationRequest$DestinationArn' => '<p>This parameter is required if <code>Destination</code> is <code>Evidently</code>. If <code>Destination</code> is <code>CloudWatch</code>, do not use this parameter. This parameter specifies the ARN of the Evidently experiment that corresponds to the destination to delete.</p>', 'MetricDestinationSummary$DestinationArn' => '<p>If the destination is <code>Evidently</code>, this specifies the ARN of the Evidently experiment that receives the metrics.</p>', 'PutRumMetricsDestinationRequest$DestinationArn' => '<p>Use this parameter only if <code>Destination</code> is <code>Evidently</code>. This parameter specifies the ARN of the Evidently experiment that will receive the extended metrics.</p>', 'UpdateRumMetricDefinitionRequest$DestinationArn' => '<p>This parameter is required if <code>Destination</code> is <code>Evidently</code>. If <code>Destination</code> is <code>CloudWatch</code>, do not use this parameter.</p> <p>This parameter specifies the ARN of the Evidently experiment that is to receive the metrics. You must have already defined this experiment as a valid destination. For more information, see <a href="https://docs.aws.amazon.com/cloudwatchrum/latest/APIReference/API_PutRumMetricsDestination.html">PutRumMetricsDestination</a>.</p>', ], ], 'DimensionKey' => [ 'base' => NULL, 'refs' => [ 'DimensionKeysMap$key' => NULL, ], ], 'DimensionKeysMap' => [ 'base' => NULL, 'refs' => [ 'MetricDefinition$DimensionKeys' => '<p>This field is a map of field paths to dimension names. It defines the dimensions to associate with this metric in CloudWatch The value of this field is used only if the metric destination is <code>CloudWatch</code>. If the metric destination is <code>Evidently</code>, the value of <code>DimensionKeys</code> is ignored.</p>', 'MetricDefinitionRequest$DimensionKeys' => '<p>Use this field only if you are sending the metric to CloudWatch.</p> <p>This field is a map of field paths to dimension names. It defines the dimensions to associate with this metric in CloudWatch. For extended metrics, valid values for the entries in this field are the following:</p> <ul> <li> <p> <code>"metadata.pageId": "PageId"</code> </p> </li> <li> <p> <code>"metadata.browserName": "BrowserName"</code> </p> </li> <li> <p> <code>"metadata.deviceType": "DeviceType"</code> </p> </li> <li> <p> <code>"metadata.osName": "OSName"</code> </p> </li> <li> <p> <code>"metadata.countryCode": "CountryCode"</code> </p> </li> <li> <p> <code>"event_details.fileType": "FileType"</code> </p> </li> </ul> <p> For both extended metrics and custom metrics, all dimensions listed in this field must also be included in <code>EventPattern</code>.</p>', ], ], 'DimensionName' => [ 'base' => NULL, 'refs' => [ 'DimensionKeysMap$value' => NULL, ], ], 'EventData' => [ 'base' => NULL, 'refs' => [ 'EventDataList$member' => NULL, ], ], 'EventDataList' => [ 'base' => NULL, 'refs' => [ 'GetAppMonitorDataResponse$Events' => '<p>The events that RUM collected that match your request.</p>', ], ], 'EventPattern' => [ 'base' => NULL, 'refs' => [ 'MetricDefinition$EventPattern' => '<p>The pattern that defines the metric. RUM checks events that happen in a user\'s session against the pattern, and events that match the pattern are sent to the metric destination.</p> <p>If the metrics destination is <code>CloudWatch</code> and the event also matches a value in <code>DimensionKeys</code>, then the metric is published with the specified dimensions. </p>', 'MetricDefinitionRequest$EventPattern' => '<p>The pattern that defines the metric, specified as a JSON object. RUM checks events that happen in a user\'s session against the pattern, and events that match the pattern are sent to the metric destination.</p> <p>When you define extended metrics, the metric definition is not valid if <code>EventPattern</code> is omitted.</p> <p>Example event patterns:</p> <ul> <li> <p> <code>\'{ "event_type": ["com.amazon.rum.js_error_event"], "metadata": { "browserName": [ "Chrome", "Safari" ], } }\'</code> </p> </li> <li> <p> <code>\'{ "event_type": ["com.amazon.rum.performance_navigation_event"], "metadata": { "browserName": [ "Chrome", "Firefox" ] }, "event_details": { "duration": [{ "numeric": [ "&lt;", 2000 ] }] } }\'</code> </p> </li> <li> <p> <code>\'{ "event_type": ["com.amazon.rum.performance_navigation_event"], "metadata": { "browserName": [ "Chrome", "Safari" ], "countryCode": [ "US" ] }, "event_details": { "duration": [{ "numeric": [ "&gt;=", 2000, "&lt;", 8000 ] }] } }\'</code> </p> </li> </ul> <p>If the metrics destination is <code>CloudWatch</code> and the event also matches a value in <code>DimensionKeys</code>, then the metric is published with the specified dimensions. </p>', ], ], 'FavoritePages' => [ 'base' => NULL, 'refs' => [ 'AppMonitorConfiguration$FavoritePages' => '<p>A list of pages in your application that are to be displayed with a "favorite" icon in the CloudWatch RUM console.</p>', ], ], 'GetAppMonitorDataRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAppMonitorDataResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetAppMonitorRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAppMonitorResponse' => [ 'base' => NULL, 'refs' => [], ], 'ISOTimestampString' => [ 'base' => NULL, 'refs' => [ 'AppMonitor$Created' => '<p>The date and time that this app monitor was created.</p>', 'AppMonitor$LastModified' => '<p>The date and time of the most recent changes to this app monitor\'s configuration.</p>', 'AppMonitorSummary$Created' => '<p>The date and time that the app monitor was created.</p>', 'AppMonitorSummary$LastModified' => '<p>The date and time of the most recent changes to this app monitor\'s configuration.</p>', ], ], 'IamRoleArn' => [ 'base' => NULL, 'refs' => [ 'MetricDestinationSummary$IamRoleArn' => '<p>This field appears only when the destination is <code>Evidently</code>. It specifies the ARN of the IAM role that is used to write to the Evidently experiment that receives the metrics.</p>', 'PutRumMetricsDestinationRequest$IamRoleArn' => '<p>This parameter is required if <code>Destination</code> is <code>Evidently</code>. If <code>Destination</code> is <code>CloudWatch</code>, don\'t use this parameter.</p> <p>This parameter specifies the ARN of an IAM role that RUM will assume to write to the Evidently experiment that you are sending metrics to. This role must have permission to write to that experiment.</p> <p>If you specify this parameter, you must be signed on to a role that has <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html">PassRole</a> permissions attached to it, to allow the role to be passed. The <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/auth-and-access-control-cw.html#managed-policies-cloudwatch-RUM"> CloudWatchAmazonCloudWatchRUMFullAccess</a> policy doesn\'t include <code>PassRole</code> permissions.</p>', ], ], 'IdentityPoolId' => [ 'base' => NULL, 'refs' => [ 'AppMonitorConfiguration$IdentityPoolId' => '<p>The ID of the Amazon Cognito identity pool that is used to authorize the sending of data to RUM.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'InternalServerException$retryAfterSeconds' => '<p>The value of a parameter in the request caused an error.</p>', 'ThrottlingException$retryAfterSeconds' => '<p>The value of a parameter in the request caused an error.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>Internal service exception.</p>', 'refs' => [], ], 'JsonValue' => [ 'base' => NULL, 'refs' => [ 'RumEvent$details' => '<p>A string containing details about the event.</p>', 'RumEvent$metadata' => '<p>Metadata about this event, which contains a JSON serialization of the identity of the user for this session. The user information comes from information such as the HTTP user-agent request header and document interface.</p>', ], ], 'ListAppMonitorsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAppMonitorsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListRumMetricsDestinationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRumMetricsDestinationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'MaxQueryResults' => [ 'base' => NULL, 'refs' => [ 'GetAppMonitorDataRequest$MaxResults' => '<p>The maximum number of results to return in one operation. </p>', ], ], 'MaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'BatchGetRumMetricDefinitionsRequest$MaxResults' => '<p>The maximum number of results to return in one operation. The default is 50. The maximum that you can specify is 100.</p> <p>To retrieve the remaining results, make another call with the returned <code>NextToken</code> value. </p>', 'ListAppMonitorsRequest$MaxResults' => '<p>The maximum number of results to return in one operation. The default is 50. The maximum that you can specify is 100.</p>', 'ListRumMetricsDestinationsRequest$MaxResults' => '<p>The maximum number of results to return in one operation. The default is 50. The maximum that you can specify is 100.</p> <p>To retrieve the remaining results, make another call with the returned <code>NextToken</code> value. </p>', ], ], 'MetricDefinition' => [ 'base' => '<p>A structure that displays the definition of one extended metric that RUM sends to CloudWatch or CloudWatch Evidently. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-vended-metrics.html"> Additional metrics that you can send to CloudWatch and CloudWatch Evidently</a>.</p>', 'refs' => [ 'MetricDefinitions$member' => NULL, ], ], 'MetricDefinitionId' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteRumMetricDefinitionsError$MetricDefinitionId' => '<p>The ID of the metric definition that caused this error.</p>', 'MetricDefinition$MetricDefinitionId' => '<p>The ID of this metric definition.</p>', 'MetricDefinitionIds$member' => NULL, 'UpdateRumMetricDefinitionRequest$MetricDefinitionId' => '<p>The ID of the metric definition to update.</p>', ], ], 'MetricDefinitionIds' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteRumMetricDefinitionsRequest$MetricDefinitionIds' => '<p>An array of structures which define the metrics that you want to stop sending.</p>', 'BatchDeleteRumMetricDefinitionsResponse$MetricDefinitionIds' => '<p>The IDs of the metric definitions that were deleted.</p>', ], ], 'MetricDefinitionRequest' => [ 'base' => '<p>Use this structure to define one extended metric or custom metric that RUM will send to CloudWatch or CloudWatch Evidently. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-custom-and-extended-metrics.html"> Custom metrics and extended metrics that you can send to CloudWatch and CloudWatch Evidently</a>.</p> <p>This structure is validated differently for extended metrics and custom metrics. For extended metrics that are sent to the <code>AWS/RUM</code> namespace, the following validations apply:</p> <ul> <li> <p>The <code>Namespace</code> parameter must be omitted or set to <code>AWS/RUM</code>.</p> </li> <li> <p>Only certain combinations of values for <code>Name</code>, <code>ValueKey</code>, and <code>EventPattern</code> are valid. In addition to what is displayed in the following list, the <code>EventPattern</code> can also include information used by the <code>DimensionKeys</code> field.</p> <ul> <li> <p>If <code>Name</code> is <code>PerformanceNavigationDuration</code>, then <code>ValueKey</code>must be <code>event_details.duration</code> and the <code>EventPattern</code> must include <code>{"event_type":["com.amazon.rum.performance_navigation_event"]}</code> </p> </li> <li> <p>If <code>Name</code> is <code>PerformanceResourceDuration</code>, then <code>ValueKey</code>must be <code>event_details.duration</code> and the <code>EventPattern</code> must include <code>{"event_type":["com.amazon.rum.performance_resource_event"]}</code> </p> </li> <li> <p>If <code>Name</code> is <code>NavigationSatisfiedTransaction</code>, then <code>ValueKey</code>must be null and the <code>EventPattern</code> must include <code>{ "event_type": ["com.amazon.rum.performance_navigation_event"], "event_details": { "duration": [{ "numeric": ["&gt;",2000] }] } }</code> </p> </li> <li> <p>If <code>Name</code> is <code>NavigationToleratedTransaction</code>, then <code>ValueKey</code>must be null and the <code>EventPattern</code> must include <code>{ "event_type": ["com.amazon.rum.performance_navigation_event"], "event_details": { "duration": [{ "numeric": ["&gt;=",2000,"&lt;"8000] }] } }</code> </p> </li> <li> <p>If <code>Name</code> is <code>NavigationFrustratedTransaction</code>, then <code>ValueKey</code>must be null and the <code>EventPattern</code> must include <code>{ "event_type": ["com.amazon.rum.performance_navigation_event"], "event_details": { "duration": [{ "numeric": ["&gt;=",8000] }] } }</code> </p> </li> <li> <p>If <code>Name</code> is <code>WebVitalsCumulativeLayoutShift</code>, then <code>ValueKey</code>must be <code>event_details.value</code> and the <code>EventPattern</code> must include <code>{"event_type":["com.amazon.rum.cumulative_layout_shift_event"]}</code> </p> </li> <li> <p>If <code>Name</code> is <code>WebVitalsFirstInputDelay</code>, then <code>ValueKey</code>must be <code>event_details.value</code> and the <code>EventPattern</code> must include <code>{"event_type":["com.amazon.rum.first_input_delay_event"]}</code> </p> </li> <li> <p>If <code>Name</code> is <code>WebVitalsLargestContentfulPaint</code>, then <code>ValueKey</code>must be <code>event_details.value</code> and the <code>EventPattern</code> must include <code>{"event_type":["com.amazon.rum.largest_contentful_paint_event"]}</code> </p> </li> <li> <p>If <code>Name</code> is <code>JsErrorCount</code>, then <code>ValueKey</code>must be null and the <code>EventPattern</code> must include <code>{"event_type":["com.amazon.rum.js_error_event"]}</code> </p> </li> <li> <p>If <code>Name</code> is <code>HttpErrorCount</code>, then <code>ValueKey</code>must be null and the <code>EventPattern</code> must include <code>{"event_type":["com.amazon.rum.http_event"]}</code> </p> </li> <li> <p>If <code>Name</code> is <code>SessionCount</code>, then <code>ValueKey</code>must be null and the <code>EventPattern</code> must include <code>{"event_type":["com.amazon.rum.session_start_event"]}</code> </p> </li> <li> <p>If <code>Name</code> is <code>PageViewCount</code>, then <code>ValueKey</code>must be null and the <code>EventPattern</code> must include <code>{"event_type":["com.amazon.rum.page_view_event"]}</code> </p> </li> <li> <p>If <code>Name</code> is <code>Http4xxCount</code>, then <code>ValueKey</code>must be null and the <code>EventPattern</code> must include <code>{"event_type": ["com.amazon.rum.http_event"],"event_details":{"response":{"status":[{"numeric":["&gt;=",400,"&lt;",500]}]}}} }</code> </p> </li> <li> <p>If <code>Name</code> is <code>Http5xxCount</code>, then <code>ValueKey</code>must be null and the <code>EventPattern</code> must include <code>{"event_type": ["com.amazon.rum.http_event"],"event_details":{"response":{"status":[{"numeric":["&gt;=",500,"&lt;=",599]}]}}} }</code> </p> </li> </ul> </li> </ul> <p>For custom metrics, the following validation rules apply:</p> <ul> <li> <p>The namespace can\'t be omitted and can\'t be <code>AWS/RUM</code>. You can use the <code>AWS/RUM</code> namespace only for extended metrics.</p> </li> <li> <p>All dimensions listed in the <code>DimensionKeys</code> field must be present in the value of <code>EventPattern</code>.</p> </li> <li> <p>The values that you specify for <code>ValueKey</code>, <code>EventPattern</code>, and <code>DimensionKeys</code> must be fields in RUM events, so all first-level keys in these fields must be one of the keys in the list later in this section.</p> </li> <li> <p>If you set a value for <code>EventPattern</code>, it must be a JSON object.</p> </li> <li> <p>For every non-empty <code>event_details</code>, there must be a non-empty <code>event_type</code>.</p> </li> <li> <p>If <code>EventPattern</code> contains an <code>event_details</code> field, it must also contain an <code>event_type</code>. For every built-in <code>event_type</code> that you use, you must use a value for <code>event_details</code> that corresponds to that <code>event_type</code>. For information about event details that correspond to event types, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-datacollected.html#CloudWatch-RUM-datacollected-eventDetails"> RUM event details</a>.</p> </li> <li> <p>In <code>EventPattern</code>, any JSON array must contain only one value.</p> </li> </ul> <p>Valid key values for first-level keys in the <code>ValueKey</code>, <code>EventPattern</code>, and <code>DimensionKeys</code> fields:</p> <ul> <li> <p> <code>account_id</code> </p> </li> <li> <p> <code>application_Id</code> </p> </li> <li> <p> <code>application_version</code> </p> </li> <li> <p> <code>application_name</code> </p> </li> <li> <p> <code>batch_id</code> </p> </li> <li> <p> <code>event_details</code> </p> </li> <li> <p> <code>event_id</code> </p> </li> <li> <p> <code>event_interaction</code> </p> </li> <li> <p> <code>event_timestamp</code> </p> </li> <li> <p> <code>event_type</code> </p> </li> <li> <p> <code>event_version</code> </p> </li> <li> <p> <code>log_stream</code> </p> </li> <li> <p> <code>metadata</code> </p> </li> <li> <p> <code>sessionId</code> </p> </li> <li> <p> <code>user_details</code> </p> </li> <li> <p> <code>userId</code> </p> </li> </ul>', 'refs' => [ 'BatchCreateRumMetricDefinitionsError$MetricDefinition' => '<p>The metric definition that caused this error.</p>', 'MetricDefinitionsRequest$member' => NULL, 'UpdateRumMetricDefinitionRequest$MetricDefinition' => '<p>A structure that contains the new definition that you want to use for this metric.</p>', ], ], 'MetricDefinitions' => [ 'base' => NULL, 'refs' => [ 'BatchCreateRumMetricDefinitionsResponse$MetricDefinitions' => '<p>An array of structures that define the extended metrics.</p>', 'BatchGetRumMetricDefinitionsResponse$MetricDefinitions' => '<p>An array of structures that display information about the metrics that are sent by the specified app monitor to the specified destination.</p>', ], ], 'MetricDefinitionsRequest' => [ 'base' => NULL, 'refs' => [ 'BatchCreateRumMetricDefinitionsRequest$MetricDefinitions' => '<p>An array of structures which define the metrics that you want to send.</p>', ], ], 'MetricDestination' => [ 'base' => NULL, 'refs' => [ 'BatchCreateRumMetricDefinitionsRequest$Destination' => '<p>The destination to send the metrics to. Valid values are <code>CloudWatch</code> and <code>Evidently</code>. If you specify <code>Evidently</code>, you must also specify the Amazon Resource Name (ARN) of the CloudWatchEvidently experiment that will receive the metrics and an IAM role that has permission to write to the experiment.</p>', 'BatchDeleteRumMetricDefinitionsRequest$Destination' => '<p>Defines the destination where you want to stop sending the specified metrics. Valid values are <code>CloudWatch</code> and <code>Evidently</code>. If you specify <code>Evidently</code>, you must also specify the ARN of the CloudWatchEvidently experiment that is to be the destination and an IAM role that has permission to write to the experiment.</p>', 'BatchGetRumMetricDefinitionsRequest$Destination' => '<p>The type of destination that you want to view metrics for. Valid values are <code>CloudWatch</code> and <code>Evidently</code>.</p>', 'DeleteRumMetricsDestinationRequest$Destination' => '<p>The type of destination to delete. Valid values are <code>CloudWatch</code> and <code>Evidently</code>.</p>', 'MetricDestinationSummary$Destination' => '<p>Specifies whether the destination is <code>CloudWatch</code> or <code>Evidently</code>.</p>', 'PutRumMetricsDestinationRequest$Destination' => '<p>Defines the destination to send the metrics to. Valid values are <code>CloudWatch</code> and <code>Evidently</code>. If you specify <code>Evidently</code>, you must also specify the ARN of the CloudWatchEvidently experiment that is to be the destination and an IAM role that has permission to write to the experiment.</p>', 'UpdateRumMetricDefinitionRequest$Destination' => '<p>The destination to send the metrics to. Valid values are <code>CloudWatch</code> and <code>Evidently</code>. If you specify <code>Evidently</code>, you must also specify the ARN of the CloudWatchEvidently experiment that will receive the metrics and an IAM role that has permission to write to the experiment.</p>', ], ], 'MetricDestinationSummary' => [ 'base' => '<p>A structure that displays information about one destination that CloudWatch RUM sends extended metrics to.</p>', 'refs' => [ 'MetricDestinationSummaryList$member' => NULL, ], ], 'MetricDestinationSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListRumMetricsDestinationsResponse$Destinations' => '<p>The list of CloudWatch RUM extended metrics destinations associated with the app monitor that you specified.</p>', ], ], 'MetricName' => [ 'base' => NULL, 'refs' => [ 'MetricDefinition$Name' => '<p>The name of the metric that is defined in this structure.</p>', 'MetricDefinitionRequest$Name' => '<p>The name for the metric that is defined in this structure. For custom metrics, you can specify any name that you like. For extended metrics, valid values are the following:</p> <ul> <li> <p> <code>PerformanceNavigationDuration</code> </p> </li> <li> <p> <code>PerformanceResourceDuration </code> </p> </li> <li> <p> <code>NavigationSatisfiedTransaction</code> </p> </li> <li> <p> <code>NavigationToleratedTransaction</code> </p> </li> <li> <p> <code>NavigationFrustratedTransaction</code> </p> </li> <li> <p> <code>WebVitalsCumulativeLayoutShift</code> </p> </li> <li> <p> <code>WebVitalsFirstInputDelay</code> </p> </li> <li> <p> <code>WebVitalsLargestContentfulPaint</code> </p> </li> <li> <p> <code>JsErrorCount</code> </p> </li> <li> <p> <code>HttpErrorCount</code> </p> </li> <li> <p> <code>SessionCount</code> </p> </li> </ul>', ], ], 'Namespace' => [ 'base' => NULL, 'refs' => [ 'MetricDefinition$Namespace' => '<p>If this metric definition is for a custom metric instead of an extended metric, this field displays the metric namespace that the custom metric is published to.</p>', 'MetricDefinitionRequest$Namespace' => '<p>If this structure is for a custom metric instead of an extended metrics, use this parameter to define the metric namespace for that custom metric. Do not specify this parameter if this structure is for an extended metric.</p> <p>You cannot use any string that starts with <code>AWS/</code> for your namespace.</p>', ], ], 'Pages' => [ 'base' => NULL, 'refs' => [ 'AppMonitorConfiguration$ExcludedPages' => '<p>A list of URLs in your website or application to exclude from RUM data collection.</p> <p>You can\'t include both <code>ExcludedPages</code> and <code>IncludedPages</code> in the same operation.</p>', 'AppMonitorConfiguration$IncludedPages' => '<p>If this app monitor is to collect data from only certain pages in your application, this structure lists those pages. </p> <p>You can\'t include both <code>ExcludedPages</code> and <code>IncludedPages</code> in the same operation.</p>', ], ], 'PutRumEventsRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutRumEventsRequestBatchIdString' => [ 'base' => NULL, 'refs' => [ 'PutRumEventsRequest$BatchId' => '<p>A unique identifier for this batch of RUM event data.</p>', ], ], 'PutRumEventsRequestIdString' => [ 'base' => NULL, 'refs' => [ 'PutRumEventsRequest$Id' => '<p>The ID of the app monitor that is sending this data.</p>', ], ], 'PutRumEventsResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutRumMetricsDestinationRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutRumMetricsDestinationResponse' => [ 'base' => NULL, 'refs' => [], ], 'QueryFilter' => [ 'base' => '<p>A structure that defines a key and values that you can use to filter the results. The only performance events that are returned are those that have values matching the ones that you specify in one of your <code>QueryFilter</code> structures.</p> <p>For example, you could specify <code>Browser</code> as the <code>Name</code> and specify <code>Chrome,Firefox</code> as the <code>Values</code> to return events generated only from those browsers.</p> <p>Specifying <code>Invert</code> as the <code>Name</code> works as a "not equal to" filter. For example, specify <code>Invert</code> as the <code>Name</code> and specify <code>Chrome</code> as the value to return all events except events from user sessions with the Chrome browser.</p>', 'refs' => [ 'QueryFilters$member' => NULL, ], ], 'QueryFilterKey' => [ 'base' => NULL, 'refs' => [ 'QueryFilter$Name' => '<p>The name of a key to search for. The filter returns only the events that match the <code>Name</code> and <code>Values</code> that you specify. </p> <p>Valid values for <code>Name</code> are <code>Browser</code> | <code>Device</code> | <code>Country</code> | <code>Page</code> | <code>OS</code> | <code>EventType</code> | <code>Invert</code> </p>', ], ], 'QueryFilterValue' => [ 'base' => NULL, 'refs' => [ 'QueryFilterValueList$member' => NULL, ], ], 'QueryFilterValueList' => [ 'base' => NULL, 'refs' => [ 'QueryFilter$Values' => '<p>The values of the <code>Name</code> that are to be be included in the returned results.</p>', ], ], 'QueryFilters' => [ 'base' => NULL, 'refs' => [ 'GetAppMonitorDataRequest$Filters' => '<p>An array of structures that you can use to filter the results to those that match one or more sets of key-value pairs that you specify.</p>', ], ], 'QueryTimestamp' => [ 'base' => NULL, 'refs' => [ 'TimeRange$After' => '<p>The beginning of the time range to retrieve performance events from.</p>', 'TimeRange$Before' => '<p>The end of the time range to retrieve performance events from. If you omit this, the time range extends to the time that this operation is performed.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>Resource not found.</p>', 'refs' => [], ], 'RumEvent' => [ 'base' => '<p>A structure that contains the information for one performance event that RUM collects from a user session with your application.</p>', 'refs' => [ 'RumEventList$member' => NULL, ], ], 'RumEventIdString' => [ 'base' => NULL, 'refs' => [ 'RumEvent$id' => '<p>A unique ID for this event.</p>', ], ], 'RumEventList' => [ 'base' => NULL, 'refs' => [ 'PutRumEventsRequest$RumEvents' => '<p>An array of structures that contain the telemetry event data.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>This request exceeds a service quota.</p>', 'refs' => [], ], 'SessionSampleRate' => [ 'base' => NULL, 'refs' => [ 'AppMonitorConfiguration$SessionSampleRate' => '<p>Specifies the portion of user sessions to use for RUM data collection. Choosing a higher portion gives you more data but also incurs more costs.</p> <p>The range for this value is 0 to 1 inclusive. Setting this to 1 means that 100% of user sessions are sampled, and setting it to 0.1 means that 10% of user sessions are sampled.</p> <p>If you omit this parameter, the default of 0.1 is used, and 10% of sessions will be sampled.</p>', ], ], 'StateEnum' => [ 'base' => NULL, 'refs' => [ 'AppMonitor$State' => '<p>The current state of the app monitor.</p>', 'AppMonitorSummary$State' => '<p>The current state of this app monitor.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'AppMonitorDetails$id' => '<p>The unique ID of the app monitor.</p>', 'AppMonitorDetails$name' => '<p>The name of the app monitor.</p>', 'AppMonitorDetails$version' => '<p>The version of the app monitor.</p>', 'BatchCreateRumMetricDefinitionsError$ErrorCode' => '<p>The error code.</p>', 'BatchCreateRumMetricDefinitionsError$ErrorMessage' => '<p>The error message for this metric definition.</p>', 'BatchDeleteRumMetricDefinitionsError$ErrorCode' => '<p>The error code.</p>', 'BatchDeleteRumMetricDefinitionsError$ErrorMessage' => '<p>The error message for this metric definition.</p>', 'BatchGetRumMetricDefinitionsRequest$NextToken' => '<p>Use the token returned by the previous operation to request the next page of results.</p>', 'BatchGetRumMetricDefinitionsResponse$NextToken' => '<p>A token that you can use in a subsequent operation to retrieve the next set of results.</p>', 'ConflictException$message' => NULL, 'ConflictException$resourceName' => '<p>The name of the resource that is associated with the error.</p>', 'ConflictException$resourceType' => '<p>The type of the resource that is associated with the error.</p>', 'CwLog$CwLogGroup' => '<p>The name of the log group where the copies are stored.</p>', 'FavoritePages$member' => NULL, 'InternalServerException$message' => NULL, 'ListAppMonitorsRequest$NextToken' => '<p>Use the token returned by the previous operation to request the next page of results.</p>', 'ListAppMonitorsResponse$NextToken' => '<p>A token that you can use in a subsequent operation to retrieve the next set of results.</p>', 'ListRumMetricsDestinationsRequest$NextToken' => '<p>Use the token returned by the previous operation to request the next page of results.</p>', 'ListRumMetricsDestinationsResponse$NextToken' => '<p>A token that you can use in a subsequent operation to retrieve the next set of results.</p>', 'ResourceNotFoundException$message' => NULL, 'ResourceNotFoundException$resourceName' => '<p>The name of the resource that is associated with the error.</p>', 'ResourceNotFoundException$resourceType' => '<p>The type of the resource that is associated with the error.</p>', 'RumEvent$type' => '<p>The JSON schema that denotes the type of event this is, such as a page load or a new session.</p>', 'ServiceQuotaExceededException$message' => NULL, 'ThrottlingException$message' => NULL, 'ThrottlingException$quotaCode' => '<p>The ID of the service quota that was exceeded.</p>', 'ThrottlingException$serviceCode' => '<p>The ID of the service that is associated with the error.</p>', 'ValidationException$message' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'TagMap$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>The list of tag keys to remove from the resource.</p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'AppMonitor$Tags' => '<p>The list of tag keys and values associated with this app monitor.</p>', 'CreateAppMonitorRequest$Tags' => '<p>Assigns one or more tags (key-value pairs) to the app monitor.</p> <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.</p> <p>Tags don\'t have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.</p> <p>You can associate as many as 50 tags with an app monitor.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>.</p>', 'ListTagsForResourceResponse$Tags' => '<p>The list of tag keys and values associated with the resource you specified.</p>', 'TagResourceRequest$Tags' => '<p>The list of key-value pairs to associate with the resource.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagMap$value' => NULL, ], ], 'Telemetries' => [ 'base' => NULL, 'refs' => [ 'AppMonitorConfiguration$Telemetries' => '<p>An array that lists the types of telemetry data that this app monitor is to collect.</p> <ul> <li> <p> <code>errors</code> indicates that RUM collects data about unhandled JavaScript errors raised by your application.</p> </li> <li> <p> <code>performance</code> indicates that RUM collects performance data about how your application and its resources are loaded and rendered. This includes Core Web Vitals.</p> </li> <li> <p> <code>http</code> indicates that RUM collects data about HTTP errors thrown by your application.</p> </li> </ul>', ], ], 'Telemetry' => [ 'base' => NULL, 'refs' => [ 'Telemetries$member' => NULL, ], ], 'ThrottlingException' => [ 'base' => '<p>The request was throttled because of quota limits.</p>', 'refs' => [], ], 'TimeRange' => [ 'base' => '<p>A structure that defines the time range that you want to retrieve results from.</p>', 'refs' => [ 'GetAppMonitorDataRequest$TimeRange' => '<p>A structure that defines the time range that you want to retrieve results from.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'RumEvent$timestamp' => '<p>The exact time that this event occurred.</p>', ], ], 'Token' => [ 'base' => NULL, 'refs' => [ 'GetAppMonitorDataRequest$NextToken' => '<p>Use the token returned by the previous operation to request the next page of results.</p>', 'GetAppMonitorDataResponse$NextToken' => '<p>A token that you can use in a subsequent operation to retrieve the next set of results.</p>', ], ], 'UnitLabel' => [ 'base' => NULL, 'refs' => [ 'MetricDefinition$UnitLabel' => '<p>Use this field only if you are sending this metric to CloudWatch. It defines the CloudWatch metric unit that this metric is measured in. </p>', 'MetricDefinitionRequest$UnitLabel' => '<p>The CloudWatch metric unit to use for this metric. If you omit this field, the metric is recorded with no unit.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAppMonitorRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAppMonitorResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRumMetricDefinitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRumMetricDefinitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'Url' => [ 'base' => NULL, 'refs' => [ 'Pages$member' => NULL, ], ], 'UserDetails' => [ 'base' => '<p>A structure that contains information about the user session that this batch of events was collected from.</p>', 'refs' => [ 'PutRumEventsRequest$UserDetails' => '<p>A structure that contains information about the user session that this batch of events was collected from.</p>', ], ], 'UserDetailsSessionIdString' => [ 'base' => NULL, 'refs' => [ 'UserDetails$sessionId' => '<p>The session ID that the performance events are from.</p>', ], ], 'UserDetailsUserIdString' => [ 'base' => NULL, 'refs' => [ 'UserDetails$userId' => '<p>The ID of the user for this user session. This ID is generated by RUM and does not include any personally identifiable information about the user.</p>', ], ], 'ValidationException' => [ 'base' => '<p>One of the arguments for the request is not valid.</p>', 'refs' => [], ], 'ValueKey' => [ 'base' => NULL, 'refs' => [ 'MetricDefinition$ValueKey' => '<p>The field within the event object that the metric value is sourced from.</p>', 'MetricDefinitionRequest$ValueKey' => '<p>The field within the event object that the metric value is sourced from.</p> <p>If you omit this field, a hardcoded value of 1 is pushed as the metric value. This is useful if you want to count the number of events that the filter catches. </p> <p>If this metric is sent to CloudWatch Evidently, this field will be passed to Evidently raw. Evidently will handle data extraction from the event.</p>', ], ], ],];
