<?php
// This file was auto-generated from sdk-root/src/data/sagemaker/2017-07-24/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Provides APIs for creating and managing SageMaker resources. </p> <p>Other Resources:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/whatis.html#first-time-user">SageMaker Developer Guide</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/augmented-ai/2019-11-07/APIReference/Welcome.html">Amazon Augmented AI Runtime API Reference</a> </p> </li> </ul>', 'operations' => [ 'AddAssociation' => '<p>Creates an <i>association</i> between the source and the destination. A source can be associated with multiple destinations, and a destination can be associated with multiple sources. An association is a lineage tracking entity. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html">Amazon SageMaker ML Lineage Tracking</a>.</p>', 'AddTags' => '<p>Adds or overwrites one or more tags for the specified SageMaker resource. You can add tags to notebook instances, training jobs, hyperparameter tuning jobs, batch transform jobs, models, labeling jobs, work teams, endpoint configurations, and endpoints.</p> <p>Each tag consists of a key and an optional value. Tag keys must be unique per resource. For more information about tags, see For more information, see <a href="https://aws.amazon.com/answers/account-management/aws-tagging-strategies/">Amazon Web Services Tagging Strategies</a>.</p> <note> <p>Tags that you add to a hyperparameter tuning job by calling this API are also added to any training jobs that the hyperparameter tuning job launches after you call this API, but not to training jobs that the hyperparameter tuning job launched before you called this API. To make sure that the tags associated with a hyperparameter tuning job are also added to all training jobs that the hyperparameter tuning job launches, add the tags when you first create the tuning job by specifying them in the <code>Tags</code> parameter of <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateHyperParameterTuningJob.html">CreateHyperParameterTuningJob</a> </p> </note> <note> <p>Tags that you add to a SageMaker Domain or User Profile by calling this API are also added to any Apps that the Domain or User Profile launches after you call this API, but not to Apps that the Domain or User Profile launched before you called this API. To make sure that the tags associated with a Domain or User Profile are also added to all Apps that the Domain or User Profile launches, add the tags when you first create the Domain or User Profile by specifying them in the <code>Tags</code> parameter of <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateDomain.html">CreateDomain</a> or <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateUserProfile.html">CreateUserProfile</a>.</p> </note>', 'AssociateTrialComponent' => '<p>Associates a trial component with a trial. A trial component can be associated with multiple trials. To disassociate a trial component from a trial, call the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DisassociateTrialComponent.html">DisassociateTrialComponent</a> API.</p>', 'BatchDescribeModelPackage' => '<p>This action batch describes a list of versioned model packages</p>', 'CreateAction' => '<p>Creates an <i>action</i>. An action is a lineage tracking entity that represents an action or activity. For example, a model deployment or an HPO job. Generally, an action involves at least one input or output artifact. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html">Amazon SageMaker ML Lineage Tracking</a>.</p>', 'CreateAlgorithm' => '<p>Create a machine learning algorithm that you can use in SageMaker and list in the Amazon Web Services Marketplace.</p>', 'CreateApp' => '<p>Creates a running app for the specified UserProfile. This operation is automatically invoked by Amazon SageMaker upon access to the associated Domain, and when new kernel configurations are selected by the user. A user may have multiple Apps active simultaneously.</p>', 'CreateAppImageConfig' => '<p>Creates a configuration for running a SageMaker image as a KernelGateway app. The configuration specifies the Amazon Elastic File System storage volume on the image, and a list of the kernels in the image.</p>', 'CreateArtifact' => '<p>Creates an <i>artifact</i>. An artifact is a lineage tracking entity that represents a URI addressable object or data. Some examples are the S3 URI of a dataset and the ECR registry path of an image. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html">Amazon SageMaker ML Lineage Tracking</a>.</p>', 'CreateAutoMLJob' => '<p>Creates an Autopilot job also referred to as Autopilot experiment or AutoML job.</p> <note> <p>We recommend using the new versions <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJobV2.html">CreateAutoMLJobV2</a> and <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeAutoMLJobV2.html">DescribeAutoMLJobV2</a>, which offer backward compatibility.</p> <p> <code>CreateAutoMLJobV2</code> can manage tabular problem types identical to those of its previous version <code>CreateAutoMLJob</code>, as well as time-series forecasting, non-tabular problem types such as image or text classification, and text generation (LLMs fine-tuning).</p> <p>Find guidelines about how to migrate a <code>CreateAutoMLJob</code> to <code>CreateAutoMLJobV2</code> in <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development-create-experiment.html#autopilot-create-experiment-api-migrate-v1-v2">Migrate a CreateAutoMLJob to CreateAutoMLJobV2</a>.</p> </note> <p>You can find the best-performing model after you run an AutoML job by calling <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeAutoMLJobV2.html">DescribeAutoMLJobV2</a> (recommended) or <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeAutoMLJob.html">DescribeAutoMLJob</a>.</p>', 'CreateAutoMLJobV2' => '<p>Creates an Autopilot job also referred to as Autopilot experiment or AutoML job V2.</p> <note> <p> <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJobV2.html">CreateAutoMLJobV2</a> and <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeAutoMLJobV2.html">DescribeAutoMLJobV2</a> are new versions of <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJob.html">CreateAutoMLJob</a> and <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeAutoMLJob.html">DescribeAutoMLJob</a> which offer backward compatibility.</p> <p> <code>CreateAutoMLJobV2</code> can manage tabular problem types identical to those of its previous version <code>CreateAutoMLJob</code>, as well as time-series forecasting, non-tabular problem types such as image or text classification, and text generation (LLMs fine-tuning).</p> <p>Find guidelines about how to migrate a <code>CreateAutoMLJob</code> to <code>CreateAutoMLJobV2</code> in <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development-create-experiment.html#autopilot-create-experiment-api-migrate-v1-v2">Migrate a CreateAutoMLJob to CreateAutoMLJobV2</a>.</p> </note> <p>For the list of available problem types supported by <code>CreateAutoMLJobV2</code>, see <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLProblemTypeConfig.html">AutoMLProblemTypeConfig</a>.</p> <p>You can find the best-performing model after you run an AutoML job V2 by calling <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeAutoMLJobV2.html">DescribeAutoMLJobV2</a>.</p>', 'CreateCluster' => '<p>Creates a SageMaker HyperPod cluster. SageMaker HyperPod is a capability of SageMaker for creating and managing persistent clusters for developing large machine learning models, such as large language models (LLMs) and diffusion models. To learn more, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-hyperpod.html">Amazon SageMaker HyperPod</a> in the <i>Amazon SageMaker Developer Guide</i>.</p>', 'CreateCodeRepository' => '<p>Creates a Git repository as a resource in your SageMaker account. You can associate the repository with notebook instances so that you can use Git source control for the notebooks you create. The Git repository is a resource in your SageMaker account, so it can be associated with more than one notebook instance, and it persists independently from the lifecycle of any notebook instances it is associated with.</p> <p>The repository can be hosted either in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services CodeCommit</a> or in any other Git repository.</p>', 'CreateCompilationJob' => '<p>Starts a model compilation job. After the model has been compiled, Amazon SageMaker saves the resulting model artifacts to an Amazon Simple Storage Service (Amazon S3) bucket that you specify. </p> <p>If you choose to host your model using Amazon SageMaker hosting services, you can use the resulting model artifacts as part of the model. You can also use the artifacts with Amazon Web Services IoT Greengrass. In that case, deploy them as an ML resource.</p> <p>In the request body, you provide the following:</p> <ul> <li> <p>A name for the compilation job</p> </li> <li> <p> Information about the input model artifacts </p> </li> <li> <p>The output location for the compiled model and the device (target) that the model runs on </p> </li> <li> <p>The Amazon Resource Name (ARN) of the IAM role that Amazon SageMaker assumes to perform the model compilation job. </p> </li> </ul> <p>You can also provide a <code>Tag</code> to track the model compilation job\'s resource use and costs. The response body contains the <code>CompilationJobArn</code> for the compiled job.</p> <p>To stop a model compilation job, use <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StopCompilationJob.html">StopCompilationJob</a>. To get information about a particular model compilation job, use <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeCompilationJob.html">DescribeCompilationJob</a>. To get information about multiple model compilation jobs, use <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListCompilationJobs.html">ListCompilationJobs</a>.</p>', 'CreateContext' => '<p>Creates a <i>context</i>. A context is a lineage tracking entity that represents a logical grouping of other tracking or experiment entities. Some examples are an endpoint and a model package. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html">Amazon SageMaker ML Lineage Tracking</a>.</p>', 'CreateDataQualityJobDefinition' => '<p>Creates a definition for a job that monitors data quality and drift. For information about model monitor, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html">Amazon SageMaker Model Monitor</a>.</p>', 'CreateDeviceFleet' => '<p>Creates a device fleet.</p>', 'CreateDomain' => '<p>Creates a <code>Domain</code>. A domain consists of an associated Amazon Elastic File System volume, a list of authorized users, and a variety of security, application, policy, and Amazon Virtual Private Cloud (VPC) configurations. Users within a domain can share notebook files and other artifacts with each other.</p> <p> <b>EFS storage</b> </p> <p>When a domain is created, an EFS volume is created for use by all of the users within the domain. Each user receives a private home directory within the EFS volume for notebooks, Git repositories, and data files.</p> <p>SageMaker uses the Amazon Web Services Key Management Service (Amazon Web Services KMS) to encrypt the EFS volume attached to the domain with an Amazon Web Services managed key by default. For more control, you can specify a customer managed key. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/encryption-at-rest.html">Protect Data at Rest Using Encryption</a>.</p> <p> <b>VPC configuration</b> </p> <p>All traffic between the domain and the Amazon EFS volume is through the specified VPC and subnets. For other traffic, you can specify the <code>AppNetworkAccessType</code> parameter. <code>AppNetworkAccessType</code> corresponds to the network access type that you choose when you onboard to the domain. The following options are available:</p> <ul> <li> <p> <code>PublicInternetOnly</code> - Non-EFS traffic goes through a VPC managed by Amazon SageMaker, which allows internet access. This is the default value.</p> </li> <li> <p> <code>VpcOnly</code> - All traffic is through the specified VPC and subnets. Internet access is disabled by default. To allow internet access, you must specify a NAT gateway.</p> <p>When internet access is disabled, you won\'t be able to run a Amazon SageMaker Studio notebook or to train or host models unless your VPC has an interface endpoint to the SageMaker API and runtime or a NAT gateway and your security groups allow outbound connections.</p> </li> </ul> <important> <p>NFS traffic over TCP on port 2049 needs to be allowed in both inbound and outbound rules in order to launch a Amazon SageMaker Studio app successfully.</p> </important> <p>For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/studio-notebooks-and-internet-access.html">Connect Amazon SageMaker Studio Notebooks to Resources in a VPC</a>.</p>', 'CreateEdgeDeploymentPlan' => '<p>Creates an edge deployment plan, consisting of multiple stages. Each stage may have a different deployment configuration and devices.</p>', 'CreateEdgeDeploymentStage' => '<p>Creates a new stage in an existing edge deployment plan.</p>', 'CreateEdgePackagingJob' => '<p>Starts a SageMaker Edge Manager model packaging job. Edge Manager will use the model artifacts from the Amazon Simple Storage Service bucket that you specify. After the model has been packaged, Amazon SageMaker saves the resulting artifacts to an S3 bucket that you specify.</p>', 'CreateEndpoint' => '<p>Creates an endpoint using the endpoint configuration specified in the request. SageMaker uses the endpoint to provision resources and deploy models. You create the endpoint configuration with the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpointConfig.html">CreateEndpointConfig</a> API. </p> <p> Use this API to deploy models using SageMaker hosting services. </p> <note> <p> You must not delete an <code>EndpointConfig</code> that is in use by an endpoint that is live or while the <code>UpdateEndpoint</code> or <code>CreateEndpoint</code> operations are being performed on the endpoint. To update an endpoint, you must create a new <code>EndpointConfig</code>.</p> </note> <p>The endpoint name must be unique within an Amazon Web Services Region in your Amazon Web Services account. </p> <p>When it receives the request, SageMaker creates the endpoint, launches the resources (ML compute instances), and deploys the model(s) on them. </p> <note> <p>When you call <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpoint.html">CreateEndpoint</a>, a load call is made to DynamoDB to verify that your endpoint configuration exists. When you read data from a DynamoDB table supporting <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadConsistency.html"> <code>Eventually Consistent Reads</code> </a>, the response might not reflect the results of a recently completed write operation. The response might include some stale data. If the dependent entities are not yet in DynamoDB, this causes a validation error. If you repeat your read request after a short time, the response should return the latest data. So retry logic is recommended to handle these possible issues. We also recommend that customers call <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeEndpointConfig.html">DescribeEndpointConfig</a> before calling <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpoint.html">CreateEndpoint</a> to minimize the potential impact of a DynamoDB eventually consistent read.</p> </note> <p>When SageMaker receives the request, it sets the endpoint status to <code>Creating</code>. After it creates the endpoint, it sets the status to <code>InService</code>. SageMaker can then process incoming requests for inferences. To check the status of an endpoint, use the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeEndpoint.html">DescribeEndpoint</a> API.</p> <p>If any of the models hosted at this endpoint get model data from an Amazon S3 location, SageMaker uses Amazon Web Services Security Token Service to download model artifacts from the S3 path you provided. Amazon Web Services STS is activated in your Amazon Web Services account by default. If you previously deactivated Amazon Web Services STS for a region, you need to reactivate Amazon Web Services STS for that region. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html">Activating and Deactivating Amazon Web Services STS in an Amazon Web Services Region</a> in the <i>Amazon Web Services Identity and Access Management User Guide</i>.</p> <note> <p> To add the IAM role policies for using this API operation, go to the <a href="https://console.aws.amazon.com/iam/">IAM console</a>, and choose Roles in the left navigation pane. Search the IAM role that you want to grant access to use the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpoint.html">CreateEndpoint</a> and <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpointConfig.html">CreateEndpointConfig</a> API operations, add the following policies to the role. </p> <ul> <li> <p>Option 1: For a full SageMaker access, search and attach the <code>AmazonSageMakerFullAccess</code> policy.</p> </li> <li> <p>Option 2: For granting a limited access to an IAM role, paste the following Action elements manually into the JSON file of the IAM role: </p> <p> <code>"Action": ["sagemaker:CreateEndpoint", "sagemaker:CreateEndpointConfig"]</code> </p> <p> <code>"Resource": [</code> </p> <p> <code>"arn:aws:sagemaker:region:account-id:endpoint/endpointName"</code> </p> <p> <code>"arn:aws:sagemaker:region:account-id:endpoint-config/endpointConfigName"</code> </p> <p> <code>]</code> </p> <p>For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/api-permissions-reference.html">SageMaker API Permissions: Actions, Permissions, and Resources Reference</a>.</p> </li> </ul> </note>', 'CreateEndpointConfig' => '<p>Creates an endpoint configuration that SageMaker hosting services uses to deploy models. In the configuration, you identify one or more models, created using the <code>CreateModel</code> API, to deploy and the resources that you want SageMaker to provision. Then you call the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpoint.html">CreateEndpoint</a> API.</p> <note> <p> Use this API if you want to use SageMaker hosting services to deploy models into production. </p> </note> <p>In the request, you define a <code>ProductionVariant</code>, for each model that you want to deploy. Each <code>ProductionVariant</code> parameter also describes the resources that you want SageMaker to provision. This includes the number and type of ML compute instances to deploy. </p> <p>If you are hosting multiple models, you also assign a <code>VariantWeight</code> to specify how much traffic you want to allocate to each model. For example, suppose that you want to host two models, A and B, and you assign traffic weight 2 for model A and 1 for model B. SageMaker distributes two-thirds of the traffic to Model A, and one-third to model B. </p> <note> <p>When you call <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpoint.html">CreateEndpoint</a>, a load call is made to DynamoDB to verify that your endpoint configuration exists. When you read data from a DynamoDB table supporting <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadConsistency.html"> <code>Eventually Consistent Reads</code> </a>, the response might not reflect the results of a recently completed write operation. The response might include some stale data. If the dependent entities are not yet in DynamoDB, this causes a validation error. If you repeat your read request after a short time, the response should return the latest data. So retry logic is recommended to handle these possible issues. We also recommend that customers call <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeEndpointConfig.html">DescribeEndpointConfig</a> before calling <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpoint.html">CreateEndpoint</a> to minimize the potential impact of a DynamoDB eventually consistent read.</p> </note>', 'CreateExperiment' => '<p>Creates a SageMaker <i>experiment</i>. An experiment is a collection of <i>trials</i> that are observed, compared and evaluated as a group. A trial is a set of steps, called <i>trial components</i>, that produce a machine learning model.</p> <note> <p>In the Studio UI, trials are referred to as <i>run groups</i> and trial components are referred to as <i>runs</i>.</p> </note> <p>The goal of an experiment is to determine the components that produce the best model. Multiple trials are performed, each one isolating and measuring the impact of a change to one or more inputs, while keeping the remaining inputs constant.</p> <p>When you use SageMaker Studio or the SageMaker Python SDK, all experiments, trials, and trial components are automatically tracked, logged, and indexed. When you use the Amazon Web Services SDK for Python (Boto), you must use the logging APIs provided by the SDK.</p> <p>You can add tags to experiments, trials, trial components and then use the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html">Search</a> API to search for the tags.</p> <p>To add a description to an experiment, specify the optional <code>Description</code> parameter. To add a description later, or to change the description, call the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateExperiment.html">UpdateExperiment</a> API.</p> <p>To get a list of all your experiments, call the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListExperiments.html">ListExperiments</a> API. To view an experiment\'s properties, call the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeExperiment.html">DescribeExperiment</a> API. To get a list of all the trials associated with an experiment, call the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListTrials.html">ListTrials</a> API. To create a trial call the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTrial.html">CreateTrial</a> API.</p>', 'CreateFeatureGroup' => '<p>Create a new <code>FeatureGroup</code>. A <code>FeatureGroup</code> is a group of <code>Features</code> defined in the <code>FeatureStore</code> to describe a <code>Record</code>. </p> <p>The <code>FeatureGroup</code> defines the schema and features contained in the <code>FeatureGroup</code>. A <code>FeatureGroup</code> definition is composed of a list of <code>Features</code>, a <code>RecordIdentifierFeatureName</code>, an <code>EventTimeFeatureName</code> and configurations for its <code>OnlineStore</code> and <code>OfflineStore</code>. Check <a href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html">Amazon Web Services service quotas</a> to see the <code>FeatureGroup</code>s quota for your Amazon Web Services account.</p> <p>Note that it can take approximately 10-15 minutes to provision an <code>OnlineStore</code> <code>FeatureGroup</code> with the <code>InMemory</code> <code>StorageType</code>.</p> <important> <p>You must include at least one of <code>OnlineStoreConfig</code> and <code>OfflineStoreConfig</code> to create a <code>FeatureGroup</code>.</p> </important>', 'CreateFlowDefinition' => '<p>Creates a flow definition.</p>', 'CreateHub' => '<p>Create a hub.</p>', 'CreateHubContentReference' => '<p>Create a hub content reference in order to add a model in the JumpStart public hub to a private hub.</p>', 'CreateHumanTaskUi' => '<p>Defines the settings you will use for the human review workflow user interface. Reviewers will see a three-panel interface with an instruction area, the item to review, and an input area.</p>', 'CreateHyperParameterTuningJob' => '<p>Starts a hyperparameter tuning job. A hyperparameter tuning job finds the best version of a model by running many training jobs on your dataset using the algorithm you choose and values for hyperparameters within ranges that you specify. It then chooses the hyperparameter values that result in a model that performs the best, as measured by an objective metric that you choose.</p> <p>A hyperparameter tuning job automatically creates Amazon SageMaker experiments, trials, and trial components for each training job that it runs. You can view these entities in Amazon SageMaker Studio. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/experiments-view-compare.html#experiments-view">View Experiments, Trials, and Trial Components</a>.</p> <important> <p>Do not include any security-sensitive information including account access IDs, secrets or tokens in any hyperparameter field. If the use of security-sensitive credentials are detected, SageMaker will reject your training job request and return an exception error.</p> </important>', 'CreateImage' => '<p>Creates a custom SageMaker image. A SageMaker image is a set of image versions. Each image version represents a container image stored in Amazon ECR. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/studio-byoi.html">Bring your own SageMaker image</a>.</p>', 'CreateImageVersion' => '<p>Creates a version of the SageMaker image specified by <code>ImageName</code>. The version represents the Amazon ECR container image specified by <code>BaseImage</code>.</p>', 'CreateInferenceComponent' => '<p>Creates an inference component, which is a SageMaker hosting object that you can use to deploy a model to an endpoint. In the inference component settings, you specify the model, the endpoint, and how the model utilizes the resources that the endpoint hosts. You can optimize resource utilization by tailoring how the required CPU cores, accelerators, and memory are allocated. You can deploy multiple inference components to an endpoint, where each inference component contains one model and the resource utilization needs for that individual model. After you deploy an inference component, you can directly invoke the associated model when you use the InvokeEndpoint API action.</p>', 'CreateInferenceExperiment' => '<p> Creates an inference experiment using the configurations specified in the request. </p> <p> Use this API to setup and schedule an experiment to compare model variants on a Amazon SageMaker inference endpoint. For more information about inference experiments, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/shadow-tests.html">Shadow tests</a>. </p> <p> Amazon SageMaker begins your experiment at the scheduled time and routes traffic to your endpoint\'s model variants based on your specified configuration. </p> <p> While the experiment is in progress or after it has concluded, you can view metrics that compare your model variants. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/shadow-tests-view-monitor-edit.html">View, monitor, and edit shadow tests</a>. </p>', 'CreateInferenceRecommendationsJob' => '<p>Starts a recommendation job. You can create either an instance recommendation or load test job.</p>', 'CreateLabelingJob' => '<p>Creates a job that uses workers to label the data objects in your input dataset. You can use the labeled data to train machine learning models. </p> <p>You can select your workforce from one of three providers:</p> <ul> <li> <p>A private workforce that you create. It can include employees, contractors, and outside experts. Use a private workforce when want the data to stay within your organization or when a specific set of skills is required.</p> </li> <li> <p>One or more vendors that you select from the Amazon Web Services Marketplace. Vendors provide expertise in specific areas. </p> </li> <li> <p>The Amazon Mechanical Turk workforce. This is the largest workforce, but it should only be used for public data or data that has been stripped of any personally identifiable information.</p> </li> </ul> <p>You can also use <i>automated data labeling</i> to reduce the number of data objects that need to be labeled by a human. Automated data labeling uses <i>active learning</i> to determine if a data object can be labeled by machine or if it needs to be sent to a human worker. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-automated-labeling.html">Using Automated Data Labeling</a>.</p> <p>The data objects to be labeled are contained in an Amazon S3 bucket. You create a <i>manifest file</i> that describes the location of each object. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data.html">Using Input and Output Data</a>.</p> <p>The output can be used as the manifest file for another labeling job or as training data for your machine learning models.</p> <p>You can use this operation to create a static labeling job or a streaming labeling job. A static labeling job stops if all data objects in the input manifest file identified in <code>ManifestS3Uri</code> have been labeled. A streaming labeling job runs perpetually until it is manually stopped, or remains idle for 10 days. You can send new data objects to an active (<code>InProgress</code>) streaming labeling job in real time. To learn how to create a static labeling job, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-create-labeling-job-api.html">Create a Labeling Job (API) </a> in the Amazon SageMaker Developer Guide. To learn how to create a streaming labeling job, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-streaming-create-job.html">Create a Streaming Labeling Job</a>.</p>', 'CreateMlflowTrackingServer' => '<p>Creates an MLflow Tracking Server using a general purpose Amazon S3 bucket as the artifact store. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/mlflow-create-tracking-server.html">Create an MLflow Tracking Server</a>.</p>', 'CreateModel' => '<p>Creates a model in SageMaker. In the request, you name the model and describe a primary container. For the primary container, you specify the Docker image that contains inference code, artifacts (from prior training), and a custom environment map that the inference code uses when you deploy the model for predictions.</p> <p>Use this API to create a model if you want to use SageMaker hosting services or run a batch transform job.</p> <p>To host your model, you create an endpoint configuration with the <code>CreateEndpointConfig</code> API, and then create an endpoint with the <code>CreateEndpoint</code> API. SageMaker then deploys all of the containers that you defined for the model in the hosting environment. </p> <p>To run a batch transform using your model, you start a job with the <code>CreateTransformJob</code> API. SageMaker uses your model and your dataset to get inferences which are then saved to a specified S3 location.</p> <p>In the request, you also provide an IAM role that SageMaker can assume to access model artifacts and docker image for deployment on ML compute hosting instances or for batch transform jobs. In addition, you also use the IAM role to manage permissions the inference code needs. For example, if the inference code access any other Amazon Web Services resources, you grant necessary permissions via this role.</p>', 'CreateModelBiasJobDefinition' => '<p>Creates the definition for a model bias job.</p>', 'CreateModelCard' => '<p>Creates an Amazon SageMaker Model Card.</p> <p>For information about how to use model cards, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-cards.html">Amazon SageMaker Model Card</a>.</p>', 'CreateModelCardExportJob' => '<p>Creates an Amazon SageMaker Model Card export job.</p>', 'CreateModelExplainabilityJobDefinition' => '<p>Creates the definition for a model explainability job.</p>', 'CreateModelPackage' => '<p>Creates a model package that you can use to create SageMaker models or list on Amazon Web Services Marketplace, or a versioned model that is part of a model group. Buyers can subscribe to model packages listed on Amazon Web Services Marketplace to create models in SageMaker.</p> <p>To create a model package by specifying a Docker container that contains your inference code and the Amazon S3 location of your model artifacts, provide values for <code>InferenceSpecification</code>. To create a model from an algorithm resource that you created or subscribed to in Amazon Web Services Marketplace, provide a value for <code>SourceAlgorithmSpecification</code>.</p> <note> <p>There are two types of model packages:</p> <ul> <li> <p>Versioned - a model that is part of a model group in the model registry.</p> </li> <li> <p>Unversioned - a model package that is not part of a model group.</p> </li> </ul> </note>', 'CreateModelPackageGroup' => '<p>Creates a model group. A model group contains a group of model versions.</p>', 'CreateModelQualityJobDefinition' => '<p>Creates a definition for a job that monitors model quality and drift. For information about model monitor, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html">Amazon SageMaker Model Monitor</a>.</p>', 'CreateMonitoringSchedule' => '<p>Creates a schedule that regularly starts Amazon SageMaker Processing Jobs to monitor the data captured for an Amazon SageMaker Endpoint.</p>', 'CreateNotebookInstance' => '<p>Creates an SageMaker notebook instance. A notebook instance is a machine learning (ML) compute instance running on a Jupyter notebook. </p> <p>In a <code>CreateNotebookInstance</code> request, specify the type of ML compute instance that you want to run. SageMaker launches the instance, installs common libraries that you can use to explore datasets for model training, and attaches an ML storage volume to the notebook instance. </p> <p>SageMaker also provides a set of example notebooks. Each notebook demonstrates how to use SageMaker with a specific algorithm or with a machine learning framework. </p> <p>After receiving the request, SageMaker does the following:</p> <ol> <li> <p>Creates a network interface in the SageMaker VPC.</p> </li> <li> <p>(Option) If you specified <code>SubnetId</code>, SageMaker creates a network interface in your own VPC, which is inferred from the subnet ID that you provide in the input. When creating this network interface, SageMaker attaches the security group that you specified in the request to the network interface that it creates in your VPC.</p> </li> <li> <p>Launches an EC2 instance of the type specified in the request in the SageMaker VPC. If you specified <code>SubnetId</code> of your VPC, SageMaker specifies both network interfaces when launching this instance. This enables inbound traffic from your own VPC to the notebook instance, assuming that the security groups allow it.</p> </li> </ol> <p>After creating the notebook instance, SageMaker returns its Amazon Resource Name (ARN). You can\'t change the name of a notebook instance after you create it.</p> <p>After SageMaker creates the notebook instance, you can connect to the Jupyter server and work in Jupyter notebooks. For example, you can write code to explore a dataset that you can use for model training, train a model, host models by creating SageMaker endpoints, and validate hosted models. </p> <p>For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works.html">How It Works</a>. </p>', 'CreateNotebookInstanceLifecycleConfig' => '<p>Creates a lifecycle configuration that you can associate with a notebook instance. A <i>lifecycle configuration</i> is a collection of shell scripts that run when you create or start a notebook instance.</p> <p>Each lifecycle configuration script has a limit of 16384 characters.</p> <p>The value of the <code>$PATH</code> environment variable that is available to both scripts is <code>/sbin:bin:/usr/sbin:/usr/bin</code>.</p> <p>View Amazon CloudWatch Logs for notebook instance lifecycle configurations in log group <code>/aws/sagemaker/NotebookInstances</code> in log stream <code>[notebook-instance-name]/[LifecycleConfigHook]</code>.</p> <p>Lifecycle configuration scripts cannot run for longer than 5 minutes. If a script runs for longer than 5 minutes, it fails and the notebook instance is not created or started.</p> <p>For information about notebook instance lifestyle configurations, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional) Customize a Notebook Instance</a>.</p>', 'CreateOptimizationJob' => '<p>Creates a job that optimizes a model for inference performance. To create the job, you provide the location of a source model, and you provide the settings for the optimization techniques that you want the job to apply. When the job completes successfully, SageMaker uploads the new optimized model to the output destination that you specify.</p> <p>For more information about how to use this action, and about the supported optimization techniques, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-optimize.html">Optimize model inference with Amazon SageMaker</a>.</p>', 'CreatePipeline' => '<p>Creates a pipeline using a JSON pipeline definition.</p>', 'CreatePresignedDomainUrl' => '<p>Creates a URL for a specified UserProfile in a Domain. When accessed in a web browser, the user will be automatically signed in to the domain, and granted access to all of the Apps and files associated with the Domain\'s Amazon Elastic File System volume. This operation can only be called when the authentication mode equals IAM. </p> <p>The IAM role or user passed to this API defines the permissions to access the app. Once the presigned URL is created, no additional permission is required to access this URL. IAM authorization policies for this API are also enforced for every HTTP request and WebSocket frame that attempts to connect to the app.</p> <p>You can restrict access to this API and to the URL that it returns to a list of IP addresses, Amazon VPCs or Amazon VPC Endpoints that you specify. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/studio-interface-endpoint.html">Connect to Amazon SageMaker Studio Through an Interface VPC Endpoint</a> .</p> <note> <p>The URL that you get from a call to <code>CreatePresignedDomainUrl</code> has a default timeout of 5 minutes. You can configure this value using <code>ExpiresInSeconds</code>. If you try to use the URL after the timeout limit expires, you are directed to the Amazon Web Services console sign-in page.</p> </note>', 'CreatePresignedMlflowTrackingServerUrl' => '<p>Returns a presigned URL that you can use to connect to the MLflow UI attached to your tracking server. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/mlflow-launch-ui.html">Launch the MLflow UI using a presigned URL</a>.</p>', 'CreatePresignedNotebookInstanceUrl' => '<p>Returns a URL that you can use to connect to the Jupyter server from a notebook instance. In the SageMaker console, when you choose <code>Open</code> next to a notebook instance, SageMaker opens a new tab showing the Jupyter server home page from the notebook instance. The console uses this API to get the URL and show the page.</p> <p> The IAM role or user used to call this API defines the permissions to access the notebook instance. Once the presigned URL is created, no additional permission is required to access this URL. IAM authorization policies for this API are also enforced for every HTTP request and WebSocket frame that attempts to connect to the notebook instance.</p> <p>You can restrict access to this API and to the URL that it returns to a list of IP addresses that you specify. Use the <code>NotIpAddress</code> condition operator and the <code>aws:SourceIP</code> condition context key to specify the list of IP addresses that you want to have access to the notebook instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/security_iam_id-based-policy-examples.html#nbi-ip-filter">Limit Access to a Notebook Instance by IP Address</a>.</p> <note> <p>The URL that you get from a call to <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreatePresignedNotebookInstanceUrl.html">CreatePresignedNotebookInstanceUrl</a> is valid only for 5 minutes. If you try to use the URL after the 5-minute limit expires, you are directed to the Amazon Web Services console sign-in page.</p> </note>', 'CreateProcessingJob' => '<p>Creates a processing job.</p>', 'CreateProject' => '<p>Creates a machine learning (ML) project that can contain one or more templates that set up an ML pipeline from training to deploying an approved model.</p>', 'CreateSpace' => '<p>Creates a private space or a space used for real time collaboration in a domain.</p>', 'CreateStudioLifecycleConfig' => '<p>Creates a new Amazon SageMaker Studio Lifecycle Configuration.</p>', 'CreateTrainingJob' => '<p>Starts a model training job. After training completes, SageMaker saves the resulting model artifacts to an Amazon S3 location that you specify. </p> <p>If you choose to host your model using SageMaker hosting services, you can use the resulting model artifacts as part of the model. You can also use the artifacts in a machine learning service other than SageMaker, provided that you know how to use them for inference. </p> <p>In the request body, you provide the following: </p> <ul> <li> <p> <code>AlgorithmSpecification</code> - Identifies the training algorithm to use. </p> </li> <li> <p> <code>HyperParameters</code> - Specify these algorithm-specific parameters to enable the estimation of model parameters during training. Hyperparameters can be tuned to optimize this learning process. For a list of hyperparameters for each training algorithm provided by SageMaker, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html">Algorithms</a>. </p> <important> <p>Do not include any security-sensitive information including account access IDs, secrets or tokens in any hyperparameter field. If the use of security-sensitive credentials are detected, SageMaker will reject your training job request and return an exception error.</p> </important> </li> <li> <p> <code>InputDataConfig</code> - Describes the input required by the training job and the Amazon S3, EFS, or FSx location where it is stored.</p> </li> <li> <p> <code>OutputDataConfig</code> - Identifies the Amazon S3 bucket where you want SageMaker to save the results of model training. </p> </li> <li> <p> <code>ResourceConfig</code> - Identifies the resources, ML compute instances, and ML storage volumes to deploy for model training. In distributed training, you specify more than one instance. </p> </li> <li> <p> <code>EnableManagedSpotTraining</code> - Optimize the cost of training machine learning models by up to 80% by using Amazon EC2 Spot instances. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-managed-spot-training.html">Managed Spot Training</a>. </p> </li> <li> <p> <code>RoleArn</code> - The Amazon Resource Name (ARN) that SageMaker assumes to perform tasks on your behalf during model training. You must grant this role the necessary permissions so that SageMaker can successfully complete model training. </p> </li> <li> <p> <code>StoppingCondition</code> - To help cap training costs, use <code>MaxRuntimeInSeconds</code> to set a time limit for training. Use <code>MaxWaitTimeInSeconds</code> to specify how long a managed spot training job has to complete. </p> </li> <li> <p> <code>Environment</code> - The environment variables to set in the Docker container.</p> </li> <li> <p> <code>RetryStrategy</code> - The number of times to retry the job when the job fails due to an <code>InternalServerError</code>.</p> </li> </ul> <p> For more information about SageMaker, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works.html">How It Works</a>. </p>', 'CreateTransformJob' => '<p>Starts a transform job. A transform job uses a trained model to get inferences on a dataset and saves these results to an Amazon S3 location that you specify.</p> <p>To perform batch transformations, you create a transform job and use the data that you have readily available.</p> <p>In the request body, you provide the following:</p> <ul> <li> <p> <code>TransformJobName</code> - Identifies the transform job. The name must be unique within an Amazon Web Services Region in an Amazon Web Services account.</p> </li> <li> <p> <code>ModelName</code> - Identifies the model to use. <code>ModelName</code> must be the name of an existing Amazon SageMaker model in the same Amazon Web Services Region and Amazon Web Services account. For information on creating a model, see <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateModel.html">CreateModel</a>.</p> </li> <li> <p> <code>TransformInput</code> - Describes the dataset to be transformed and the Amazon S3 location where it is stored.</p> </li> <li> <p> <code>TransformOutput</code> - Identifies the Amazon S3 location where you want Amazon SageMaker to save the results from the transform job.</p> </li> <li> <p> <code>TransformResources</code> - Identifies the ML compute instances for the transform job.</p> </li> </ul> <p>For more information about how batch transformation works, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform.html">Batch Transform</a>.</p>', 'CreateTrial' => '<p>Creates an SageMaker <i>trial</i>. A trial is a set of steps called <i>trial components</i> that produce a machine learning model. A trial is part of a single SageMaker <i>experiment</i>.</p> <p>When you use SageMaker Studio or the SageMaker Python SDK, all experiments, trials, and trial components are automatically tracked, logged, and indexed. When you use the Amazon Web Services SDK for Python (Boto), you must use the logging APIs provided by the SDK.</p> <p>You can add tags to a trial and then use the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html">Search</a> API to search for the tags.</p> <p>To get a list of all your trials, call the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListTrials.html">ListTrials</a> API. To view a trial\'s properties, call the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeTrial.html">DescribeTrial</a> API. To create a trial component, call the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTrialComponent.html">CreateTrialComponent</a> API.</p>', 'CreateTrialComponent' => '<p>Creates a <i>trial component</i>, which is a stage of a machine learning <i>trial</i>. A trial is composed of one or more trial components. A trial component can be used in multiple trials.</p> <p>Trial components include pre-processing jobs, training jobs, and batch transform jobs.</p> <p>When you use SageMaker Studio or the SageMaker Python SDK, all experiments, trials, and trial components are automatically tracked, logged, and indexed. When you use the Amazon Web Services SDK for Python (Boto), you must use the logging APIs provided by the SDK.</p> <p>You can add tags to a trial component and then use the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html">Search</a> API to search for the tags.</p>', 'CreateUserProfile' => '<p>Creates a user profile. A user profile represents a single user within a domain, and is the main way to reference a "person" for the purposes of sharing, reporting, and other user-oriented features. This entity is created when a user onboards to a domain. If an administrator invites a person by email or imports them from IAM Identity Center, a user profile is automatically created. A user profile is the primary holder of settings for an individual user and has a reference to the user\'s private Amazon Elastic File System home directory. </p>', 'CreateWorkforce' => '<p>Use this operation to create a workforce. This operation will return an error if a workforce already exists in the Amazon Web Services Region that you specify. You can only create one workforce in each Amazon Web Services Region per Amazon Web Services account.</p> <p>If you want to create a new workforce in an Amazon Web Services Region where a workforce already exists, use the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteWorkforce.html">DeleteWorkforce</a> API operation to delete the existing workforce and then use <code>CreateWorkforce</code> to create a new workforce.</p> <p>To create a private workforce using Amazon Cognito, you must specify a Cognito user pool in <code>CognitoConfig</code>. You can also create an Amazon Cognito workforce using the Amazon SageMaker console. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-create-private.html"> Create a Private Workforce (Amazon Cognito)</a>.</p> <p>To create a private workforce using your own OIDC Identity Provider (IdP), specify your IdP configuration in <code>OidcConfig</code>. Your OIDC IdP must support <i>groups</i> because groups are used by Ground Truth and Amazon A2I to create work teams. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-create-private-oidc.html"> Create a Private Workforce (OIDC IdP)</a>.</p>', 'CreateWorkteam' => '<p>Creates a new work team for labeling your data. A work team is defined by one or more Amazon Cognito user pools. You must first create the user pools before you can create a work team.</p> <p>You cannot create more than 25 work teams in an account and region.</p>', 'DeleteAction' => '<p>Deletes an action.</p>', 'DeleteAlgorithm' => '<p>Removes the specified algorithm from your account.</p>', 'DeleteApp' => '<p>Used to stop and delete an app.</p>', 'DeleteAppImageConfig' => '<p>Deletes an AppImageConfig.</p>', 'DeleteArtifact' => '<p>Deletes an artifact. Either <code>ArtifactArn</code> or <code>Source</code> must be specified.</p>', 'DeleteAssociation' => '<p>Deletes an association.</p>', 'DeleteCluster' => '<p>Delete a SageMaker HyperPod cluster.</p>', 'DeleteCodeRepository' => '<p>Deletes the specified Git repository from your account.</p>', 'DeleteCompilationJob' => '<p>Deletes the specified compilation job. This action deletes only the compilation job resource in Amazon SageMaker. It doesn\'t delete other resources that are related to that job, such as the model artifacts that the job creates, the compilation logs in CloudWatch, the compiled model, or the IAM role.</p> <p>You can delete a compilation job only if its current status is <code>COMPLETED</code>, <code>FAILED</code>, or <code>STOPPED</code>. If the job status is <code>STARTING</code> or <code>INPROGRESS</code>, stop the job, and then delete it after its status becomes <code>STOPPED</code>.</p>', 'DeleteContext' => '<p>Deletes an context.</p>', 'DeleteDataQualityJobDefinition' => '<p>Deletes a data quality monitoring job definition.</p>', 'DeleteDeviceFleet' => '<p>Deletes a fleet.</p>', 'DeleteDomain' => '<p>Used to delete a domain. If you onboarded with IAM mode, you will need to delete your domain to onboard again using IAM Identity Center. Use with caution. All of the members of the domain will lose access to their EFS volume, including data, notebooks, and other artifacts. </p>', 'DeleteEdgeDeploymentPlan' => '<p>Deletes an edge deployment plan if (and only if) all the stages in the plan are inactive or there are no stages in the plan.</p>', 'DeleteEdgeDeploymentStage' => '<p>Delete a stage in an edge deployment plan if (and only if) the stage is inactive.</p>', 'DeleteEndpoint' => '<p>Deletes an endpoint. SageMaker frees up all of the resources that were deployed when the endpoint was created. </p> <p>SageMaker retires any custom KMS key grants associated with the endpoint, meaning you don\'t need to use the <a href="http://docs.aws.amazon.com/kms/latest/APIReference/API_RevokeGrant.html">RevokeGrant</a> API call.</p> <p>When you delete your endpoint, SageMaker asynchronously deletes associated endpoint resources such as KMS key grants. You might still see these resources in your account for a few minutes after deleting your endpoint. Do not delete or revoke the permissions for your <code> <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateModel.html#sagemaker-CreateModel-request-ExecutionRoleArn">ExecutionRoleArn</a> </code>, otherwise SageMaker cannot delete these resources.</p>', 'DeleteEndpointConfig' => '<p>Deletes an endpoint configuration. The <code>DeleteEndpointConfig</code> API deletes only the specified configuration. It does not delete endpoints created using the configuration. </p> <p>You must not delete an <code>EndpointConfig</code> in use by an endpoint that is live or while the <code>UpdateEndpoint</code> or <code>CreateEndpoint</code> operations are being performed on the endpoint. If you delete the <code>EndpointConfig</code> of an endpoint that is active or being created or updated you may lose visibility into the instance type the endpoint is using. The endpoint must be deleted in order to stop incurring charges.</p>', 'DeleteExperiment' => '<p>Deletes an SageMaker experiment. All trials associated with the experiment must be deleted first. Use the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListTrials.html">ListTrials</a> API to get a list of the trials associated with the experiment.</p>', 'DeleteFeatureGroup' => '<p>Delete the <code>FeatureGroup</code> and any data that was written to the <code>OnlineStore</code> of the <code>FeatureGroup</code>. Data cannot be accessed from the <code>OnlineStore</code> immediately after <code>DeleteFeatureGroup</code> is called. </p> <p>Data written into the <code>OfflineStore</code> will not be deleted. The Amazon Web Services Glue database and tables that are automatically created for your <code>OfflineStore</code> are not deleted. </p> <p>Note that it can take approximately 10-15 minutes to delete an <code>OnlineStore</code> <code>FeatureGroup</code> with the <code>InMemory</code> <code>StorageType</code>.</p>', 'DeleteFlowDefinition' => '<p>Deletes the specified flow definition.</p>', 'DeleteHub' => '<p>Delete a hub.</p>', 'DeleteHubContent' => '<p>Delete the contents of a hub.</p>', 'DeleteHubContentReference' => '<p>Delete a hub content reference in order to remove a model from a private hub.</p>', 'DeleteHumanTaskUi' => '<p>Use this operation to delete a human task user interface (worker task template).</p> <p> To see a list of human task user interfaces (work task templates) in your account, use <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListHumanTaskUis.html">ListHumanTaskUis</a>. When you delete a worker task template, it no longer appears when you call <code>ListHumanTaskUis</code>.</p>', 'DeleteHyperParameterTuningJob' => '<p>Deletes a hyperparameter tuning job. The <code>DeleteHyperParameterTuningJob</code> API deletes only the tuning job entry that was created in SageMaker when you called the <code>CreateHyperParameterTuningJob</code> API. It does not delete training jobs, artifacts, or the IAM role that you specified when creating the model.</p>', 'DeleteImage' => '<p>Deletes a SageMaker image and all versions of the image. The container images aren\'t deleted.</p>', 'DeleteImageVersion' => '<p>Deletes a version of a SageMaker image. The container image the version represents isn\'t deleted.</p>', 'DeleteInferenceComponent' => '<p>Deletes an inference component.</p>', 'DeleteInferenceExperiment' => '<p>Deletes an inference experiment.</p> <note> <p> This operation does not delete your endpoint, variants, or any underlying resources. This operation only deletes the metadata of your experiment. </p> </note>', 'DeleteMlflowTrackingServer' => '<p>Deletes an MLflow Tracking Server. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/mlflow-cleanup.html.html">Clean up MLflow resources</a>.</p>', 'DeleteModel' => '<p>Deletes a model. The <code>DeleteModel</code> API deletes only the model entry that was created in SageMaker when you called the <code>CreateModel</code> API. It does not delete model artifacts, inference code, or the IAM role that you specified when creating the model. </p>', 'DeleteModelBiasJobDefinition' => '<p>Deletes an Amazon SageMaker model bias job definition.</p>', 'DeleteModelCard' => '<p>Deletes an Amazon SageMaker Model Card.</p>', 'DeleteModelExplainabilityJobDefinition' => '<p>Deletes an Amazon SageMaker model explainability job definition.</p>', 'DeleteModelPackage' => '<p>Deletes a model package.</p> <p>A model package is used to create SageMaker models or list on Amazon Web Services Marketplace. Buyers can subscribe to model packages listed on Amazon Web Services Marketplace to create models in SageMaker.</p>', 'DeleteModelPackageGroup' => '<p>Deletes the specified model group.</p>', 'DeleteModelPackageGroupPolicy' => '<p>Deletes a model group resource policy.</p>', 'DeleteModelQualityJobDefinition' => '<p>Deletes the secified model quality monitoring job definition.</p>', 'DeleteMonitoringSchedule' => '<p>Deletes a monitoring schedule. Also stops the schedule had not already been stopped. This does not delete the job execution history of the monitoring schedule. </p>', 'DeleteNotebookInstance' => '<p> Deletes an SageMaker notebook instance. Before you can delete a notebook instance, you must call the <code>StopNotebookInstance</code> API. </p> <important> <p>When you delete a notebook instance, you lose all of your data. SageMaker removes the ML compute instance, and deletes the ML storage volume and the network interface associated with the notebook instance. </p> </important>', 'DeleteNotebookInstanceLifecycleConfig' => '<p>Deletes a notebook instance lifecycle configuration.</p>', 'DeleteOptimizationJob' => '<p>Deletes an optimization job.</p>', 'DeletePipeline' => '<p>Deletes a pipeline if there are no running instances of the pipeline. To delete a pipeline, you must stop all running instances of the pipeline using the <code>StopPipelineExecution</code> API. When you delete a pipeline, all instances of the pipeline are deleted.</p>', 'DeleteProject' => '<p>Delete the specified project.</p>', 'DeleteSpace' => '<p>Used to delete a space.</p>', 'DeleteStudioLifecycleConfig' => '<p>Deletes the Amazon SageMaker Studio Lifecycle Configuration. In order to delete the Lifecycle Configuration, there must be no running apps using the Lifecycle Configuration. You must also remove the Lifecycle Configuration from UserSettings in all Domains and UserProfiles.</p>', 'DeleteTags' => '<p>Deletes the specified tags from an SageMaker resource.</p> <p>To list a resource\'s tags, use the <code>ListTags</code> API. </p> <note> <p>When you call this API to delete tags from a hyperparameter tuning job, the deleted tags are not removed from training jobs that the hyperparameter tuning job launched before you called this API.</p> </note> <note> <p>When you call this API to delete tags from a SageMaker Domain or User Profile, the deleted tags are not removed from Apps that the SageMaker Domain or User Profile launched before you called this API.</p> </note>', 'DeleteTrial' => '<p>Deletes the specified trial. All trial components that make up the trial must be deleted first. Use the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeTrialComponent.html">DescribeTrialComponent</a> API to get the list of trial components.</p>', 'DeleteTrialComponent' => '<p>Deletes the specified trial component. A trial component must be disassociated from all trials before the trial component can be deleted. To disassociate a trial component from a trial, call the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DisassociateTrialComponent.html">DisassociateTrialComponent</a> API.</p>', 'DeleteUserProfile' => '<p>Deletes a user profile. When a user profile is deleted, the user loses access to their EFS volume, including data, notebooks, and other artifacts.</p>', 'DeleteWorkforce' => '<p>Use this operation to delete a workforce.</p> <p>If you want to create a new workforce in an Amazon Web Services Region where a workforce already exists, use this operation to delete the existing workforce and then use <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateWorkforce.html">CreateWorkforce</a> to create a new workforce.</p> <important> <p>If a private workforce contains one or more work teams, you must use the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteWorkteam.html">DeleteWorkteam</a> operation to delete all work teams before you delete the workforce. If you try to delete a workforce that contains one or more work teams, you will receive a <code>ResourceInUse</code> error.</p> </important>', 'DeleteWorkteam' => '<p>Deletes an existing work team. This operation can\'t be undone.</p>', 'DeregisterDevices' => '<p>Deregisters the specified devices. After you deregister a device, you will need to re-register the devices.</p>', 'DescribeAction' => '<p>Describes an action.</p>', 'DescribeAlgorithm' => '<p>Returns a description of the specified algorithm that is in your account.</p>', 'DescribeApp' => '<p>Describes the app.</p>', 'DescribeAppImageConfig' => '<p>Describes an AppImageConfig.</p>', 'DescribeArtifact' => '<p>Describes an artifact.</p>', 'DescribeAutoMLJob' => '<p>Returns information about an AutoML job created by calling <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJob.html">CreateAutoMLJob</a>.</p> <note> <p>AutoML jobs created by calling <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJobV2.html">CreateAutoMLJobV2</a> cannot be described by <code>DescribeAutoMLJob</code>.</p> </note>', 'DescribeAutoMLJobV2' => '<p>Returns information about an AutoML job created by calling <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJobV2.html">CreateAutoMLJobV2</a> or <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJob.html">CreateAutoMLJob</a>.</p>', 'DescribeCluster' => '<p>Retrieves information of a SageMaker HyperPod cluster.</p>', 'DescribeClusterNode' => '<p>Retrieves information of a node (also called a <i>instance</i> interchangeably) of a SageMaker HyperPod cluster.</p>', 'DescribeCodeRepository' => '<p>Gets details about the specified Git repository.</p>', 'DescribeCompilationJob' => '<p>Returns information about a model compilation job.</p> <p>To create a model compilation job, use <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateCompilationJob.html">CreateCompilationJob</a>. To get information about multiple model compilation jobs, use <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListCompilationJobs.html">ListCompilationJobs</a>.</p>', 'DescribeContext' => '<p>Describes a context.</p>', 'DescribeDataQualityJobDefinition' => '<p>Gets the details of a data quality monitoring job definition.</p>', 'DescribeDevice' => '<p>Describes the device.</p>', 'DescribeDeviceFleet' => '<p>A description of the fleet the device belongs to.</p>', 'DescribeDomain' => '<p>The description of the domain.</p>', 'DescribeEdgeDeploymentPlan' => '<p>Describes an edge deployment plan with deployment status per stage.</p>', 'DescribeEdgePackagingJob' => '<p>A description of edge packaging jobs.</p>', 'DescribeEndpoint' => '<p>Returns the description of an endpoint.</p>', 'DescribeEndpointConfig' => '<p>Returns the description of an endpoint configuration created using the <code>CreateEndpointConfig</code> API.</p>', 'DescribeExperiment' => '<p>Provides a list of an experiment\'s properties.</p>', 'DescribeFeatureGroup' => '<p>Use this operation to describe a <code>FeatureGroup</code>. The response includes information on the creation time, <code>FeatureGroup</code> name, the unique identifier for each <code>FeatureGroup</code>, and more.</p>', 'DescribeFeatureMetadata' => '<p>Shows the metadata for a feature within a feature group.</p>', 'DescribeFlowDefinition' => '<p>Returns information about the specified flow definition.</p>', 'DescribeHub' => '<p>Describes a hub.</p>', 'DescribeHubContent' => '<p>Describe the content of a hub.</p>', 'DescribeHumanTaskUi' => '<p>Returns information about the requested human task user interface (worker task template).</p>', 'DescribeHyperParameterTuningJob' => '<p>Returns a description of a hyperparameter tuning job, depending on the fields selected. These fields can include the name, Amazon Resource Name (ARN), job status of your tuning job and more.</p>', 'DescribeImage' => '<p>Describes a SageMaker image.</p>', 'DescribeImageVersion' => '<p>Describes a version of a SageMaker image.</p>', 'DescribeInferenceComponent' => '<p>Returns information about an inference component.</p>', 'DescribeInferenceExperiment' => '<p>Returns details about an inference experiment.</p>', 'DescribeInferenceRecommendationsJob' => '<p>Provides the results of the Inference Recommender job. One or more recommendation jobs are returned.</p>', 'DescribeLabelingJob' => '<p>Gets information about a labeling job.</p>', 'DescribeLineageGroup' => '<p>Provides a list of properties for the requested lineage group. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/xaccount-lineage-tracking.html"> Cross-Account Lineage Tracking </a> in the <i>Amazon SageMaker Developer Guide</i>.</p>', 'DescribeMlflowTrackingServer' => '<p>Returns information about an MLflow Tracking Server.</p>', 'DescribeModel' => '<p>Describes a model that you created using the <code>CreateModel</code> API.</p>', 'DescribeModelBiasJobDefinition' => '<p>Returns a description of a model bias job definition.</p>', 'DescribeModelCard' => '<p>Describes the content, creation time, and security configuration of an Amazon SageMaker Model Card.</p>', 'DescribeModelCardExportJob' => '<p>Describes an Amazon SageMaker Model Card export job.</p>', 'DescribeModelExplainabilityJobDefinition' => '<p>Returns a description of a model explainability job definition.</p>', 'DescribeModelPackage' => '<p>Returns a description of the specified model package, which is used to create SageMaker models or list them on Amazon Web Services Marketplace.</p> <important> <p>If you provided a KMS Key ID when you created your model package, you will see the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Decrypt.html">KMS Decrypt</a> API call in your CloudTrail logs when you use this API.</p> </important> <p>To create models in SageMaker, buyers can subscribe to model packages listed on Amazon Web Services Marketplace.</p>', 'DescribeModelPackageGroup' => '<p>Gets a description for the specified model group.</p>', 'DescribeModelQualityJobDefinition' => '<p>Returns a description of a model quality job definition.</p>', 'DescribeMonitoringSchedule' => '<p>Describes the schedule for a monitoring job.</p>', 'DescribeNotebookInstance' => '<p>Returns information about a notebook instance.</p>', 'DescribeNotebookInstanceLifecycleConfig' => '<p>Returns a description of a notebook instance lifecycle configuration.</p> <p>For information about notebook instance lifestyle configurations, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional) Customize a Notebook Instance</a>.</p>', 'DescribeOptimizationJob' => '<p>Provides the properties of the specified optimization job.</p>', 'DescribePipeline' => '<p>Describes the details of a pipeline.</p>', 'DescribePipelineDefinitionForExecution' => '<p>Describes the details of an execution\'s pipeline definition.</p>', 'DescribePipelineExecution' => '<p>Describes the details of a pipeline execution.</p>', 'DescribeProcessingJob' => '<p>Returns a description of a processing job.</p>', 'DescribeProject' => '<p>Describes the details of a project.</p>', 'DescribeSpace' => '<p>Describes the space.</p>', 'DescribeStudioLifecycleConfig' => '<p>Describes the Amazon SageMaker Studio Lifecycle Configuration.</p>', 'DescribeSubscribedWorkteam' => '<p>Gets information about a work team provided by a vendor. It returns details about the subscription with a vendor in the Amazon Web Services Marketplace.</p>', 'DescribeTrainingJob' => '<p>Returns information about a training job. </p> <p>Some of the attributes below only appear if the training job successfully starts. If the training job fails, <code>TrainingJobStatus</code> is <code>Failed</code> and, depending on the <code>FailureReason</code>, attributes like <code>TrainingStartTime</code>, <code>TrainingTimeInSeconds</code>, <code>TrainingEndTime</code>, and <code>BillableTimeInSeconds</code> may not be present in the response.</p>', 'DescribeTransformJob' => '<p>Returns information about a transform job.</p>', 'DescribeTrial' => '<p>Provides a list of a trial\'s properties.</p>', 'DescribeTrialComponent' => '<p>Provides a list of a trials component\'s properties.</p>', 'DescribeUserProfile' => '<p>Describes a user profile. For more information, see <code>CreateUserProfile</code>.</p>', 'DescribeWorkforce' => '<p>Lists private workforce information, including workforce name, Amazon Resource Name (ARN), and, if applicable, allowed IP address ranges (<a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">CIDRs</a>). Allowable IP address ranges are the IP addresses that workers can use to access tasks. </p> <important> <p>This operation applies only to private workforces.</p> </important>', 'DescribeWorkteam' => '<p>Gets information about a specific work team. You can see information such as the creation date, the last updated date, membership information, and the work team\'s Amazon Resource Name (ARN).</p>', 'DisableSagemakerServicecatalogPortfolio' => '<p>Disables using Service Catalog in SageMaker. Service Catalog is used to create SageMaker projects.</p>', 'DisassociateTrialComponent' => '<p>Disassociates a trial component from a trial. This doesn\'t effect other trials the component is associated with. Before you can delete a component, you must disassociate the component from all trials it is associated with. To associate a trial component with a trial, call the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AssociateTrialComponent.html">AssociateTrialComponent</a> API.</p> <p>To get a list of the trials a component is associated with, use the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html">Search</a> API. Specify <code>ExperimentTrialComponent</code> for the <code>Resource</code> parameter. The list appears in the response under <code>Results.TrialComponent.Parents</code>.</p>', 'EnableSagemakerServicecatalogPortfolio' => '<p>Enables using Service Catalog in SageMaker. Service Catalog is used to create SageMaker projects.</p>', 'GetDeviceFleetReport' => '<p>Describes a fleet.</p>', 'GetLineageGroupPolicy' => '<p>The resource policy for the lineage group.</p>', 'GetModelPackageGroupPolicy' => '<p>Gets a resource policy that manages access for a model group. For information about resource policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_identity-vs-resource.html">Identity-based policies and resource-based policies</a> in the <i>Amazon Web Services Identity and Access Management User Guide.</i>.</p>', 'GetSagemakerServicecatalogPortfolioStatus' => '<p>Gets the status of Service Catalog in SageMaker. Service Catalog is used to create SageMaker projects.</p>', 'GetScalingConfigurationRecommendation' => '<p>Starts an Amazon SageMaker Inference Recommender autoscaling recommendation job. Returns recommendations for autoscaling policies that you can apply to your SageMaker endpoint.</p>', 'GetSearchSuggestions' => '<p>An auto-complete API for the search functionality in the SageMaker console. It returns suggestions of possible matches for the property name to use in <code>Search</code> queries. Provides suggestions for <code>HyperParameters</code>, <code>Tags</code>, and <code>Metrics</code>.</p>', 'ImportHubContent' => '<p>Import hub content.</p>', 'ListActions' => '<p>Lists the actions in your account and their properties.</p>', 'ListAlgorithms' => '<p>Lists the machine learning algorithms that have been created.</p>', 'ListAliases' => '<p>Lists the aliases of a specified image or image version.</p>', 'ListAppImageConfigs' => '<p>Lists the AppImageConfigs in your account and their properties. The list can be filtered by creation time or modified time, and whether the AppImageConfig name contains a specified string.</p>', 'ListApps' => '<p>Lists apps.</p>', 'ListArtifacts' => '<p>Lists the artifacts in your account and their properties.</p>', 'ListAssociations' => '<p>Lists the associations in your account and their properties.</p>', 'ListAutoMLJobs' => '<p>Request a list of jobs.</p>', 'ListCandidatesForAutoMLJob' => '<p>List the candidates created for the job.</p>', 'ListClusterNodes' => '<p>Retrieves the list of instances (also called <i>nodes</i> interchangeably) in a SageMaker HyperPod cluster.</p>', 'ListClusters' => '<p>Retrieves the list of SageMaker HyperPod clusters.</p>', 'ListCodeRepositories' => '<p>Gets a list of the Git repositories in your account.</p>', 'ListCompilationJobs' => '<p>Lists model compilation jobs that satisfy various filters.</p> <p>To create a model compilation job, use <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateCompilationJob.html">CreateCompilationJob</a>. To get information about a particular model compilation job you have created, use <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeCompilationJob.html">DescribeCompilationJob</a>.</p>', 'ListContexts' => '<p>Lists the contexts in your account and their properties.</p>', 'ListDataQualityJobDefinitions' => '<p>Lists the data quality job definitions in your account.</p>', 'ListDeviceFleets' => '<p>Returns a list of devices in the fleet.</p>', 'ListDevices' => '<p>A list of devices.</p>', 'ListDomains' => '<p>Lists the domains.</p>', 'ListEdgeDeploymentPlans' => '<p>Lists all edge deployment plans.</p>', 'ListEdgePackagingJobs' => '<p>Returns a list of edge packaging jobs.</p>', 'ListEndpointConfigs' => '<p>Lists endpoint configurations.</p>', 'ListEndpoints' => '<p>Lists endpoints.</p>', 'ListExperiments' => '<p>Lists all the experiments in your account. The list can be filtered to show only experiments that were created in a specific time range. The list can be sorted by experiment name or creation time.</p>', 'ListFeatureGroups' => '<p>List <code>FeatureGroup</code>s based on given filter and order.</p>', 'ListFlowDefinitions' => '<p>Returns information about the flow definitions in your account.</p>', 'ListHubContentVersions' => '<p>List hub content versions.</p>', 'ListHubContents' => '<p>List the contents of a hub.</p>', 'ListHubs' => '<p>List all existing hubs.</p>', 'ListHumanTaskUis' => '<p>Returns information about the human task user interfaces in your account.</p>', 'ListHyperParameterTuningJobs' => '<p>Gets a list of <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTuningJobSummary.html">HyperParameterTuningJobSummary</a> objects that describe the hyperparameter tuning jobs launched in your account.</p>', 'ListImageVersions' => '<p>Lists the versions of a specified image and their properties. The list can be filtered by creation time or modified time.</p>', 'ListImages' => '<p>Lists the images in your account and their properties. The list can be filtered by creation time or modified time, and whether the image name contains a specified string.</p>', 'ListInferenceComponents' => '<p>Lists the inference components in your account and their properties.</p>', 'ListInferenceExperiments' => '<p>Returns the list of all inference experiments.</p>', 'ListInferenceRecommendationsJobSteps' => '<p>Returns a list of the subtasks for an Inference Recommender job.</p> <p>The supported subtasks are benchmarks, which evaluate the performance of your model on different instance types.</p>', 'ListInferenceRecommendationsJobs' => '<p>Lists recommendation jobs that satisfy various filters.</p>', 'ListLabelingJobs' => '<p>Gets a list of labeling jobs.</p>', 'ListLabelingJobsForWorkteam' => '<p>Gets a list of labeling jobs assigned to a specified work team.</p>', 'ListLineageGroups' => '<p>A list of lineage groups shared with your Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/xaccount-lineage-tracking.html"> Cross-Account Lineage Tracking </a> in the <i>Amazon SageMaker Developer Guide</i>.</p>', 'ListMlflowTrackingServers' => '<p>Lists all MLflow Tracking Servers.</p>', 'ListModelBiasJobDefinitions' => '<p>Lists model bias jobs definitions that satisfy various filters.</p>', 'ListModelCardExportJobs' => '<p>List the export jobs for the Amazon SageMaker Model Card.</p>', 'ListModelCardVersions' => '<p>List existing versions of an Amazon SageMaker Model Card.</p>', 'ListModelCards' => '<p>List existing model cards.</p>', 'ListModelExplainabilityJobDefinitions' => '<p>Lists model explainability job definitions that satisfy various filters.</p>', 'ListModelMetadata' => '<p>Lists the domain, framework, task, and model name of standard machine learning models found in common model zoos.</p>', 'ListModelPackageGroups' => '<p>Gets a list of the model groups in your Amazon Web Services account.</p>', 'ListModelPackages' => '<p>Lists the model packages that have been created.</p>', 'ListModelQualityJobDefinitions' => '<p>Gets a list of model quality monitoring job definitions in your account.</p>', 'ListModels' => '<p>Lists models created with the <code>CreateModel</code> API.</p>', 'ListMonitoringAlertHistory' => '<p>Gets a list of past alerts in a model monitoring schedule.</p>', 'ListMonitoringAlerts' => '<p>Gets the alerts for a single monitoring schedule.</p>', 'ListMonitoringExecutions' => '<p>Returns list of all monitoring job executions.</p>', 'ListMonitoringSchedules' => '<p>Returns list of all monitoring schedules.</p>', 'ListNotebookInstanceLifecycleConfigs' => '<p>Lists notebook instance lifestyle configurations created with the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateNotebookInstanceLifecycleConfig.html">CreateNotebookInstanceLifecycleConfig</a> API.</p>', 'ListNotebookInstances' => '<p>Returns a list of the SageMaker notebook instances in the requester\'s account in an Amazon Web Services Region. </p>', 'ListOptimizationJobs' => '<p>Lists the optimization jobs in your account and their properties.</p>', 'ListPipelineExecutionSteps' => '<p>Gets a list of <code>PipeLineExecutionStep</code> objects.</p>', 'ListPipelineExecutions' => '<p>Gets a list of the pipeline executions.</p>', 'ListPipelineParametersForExecution' => '<p>Gets a list of parameters for a pipeline execution.</p>', 'ListPipelines' => '<p>Gets a list of pipelines.</p>', 'ListProcessingJobs' => '<p>Lists processing jobs that satisfy various filters.</p>', 'ListProjects' => '<p>Gets a list of the projects in an Amazon Web Services account.</p>', 'ListResourceCatalogs' => '<p> Lists Amazon SageMaker Catalogs based on given filters and orders. The maximum number of <code>ResourceCatalog</code>s viewable is 1000. </p>', 'ListSpaces' => '<p>Lists spaces.</p>', 'ListStageDevices' => '<p>Lists devices allocated to the stage, containing detailed device information and deployment status.</p>', 'ListStudioLifecycleConfigs' => '<p>Lists the Amazon SageMaker Studio Lifecycle Configurations in your Amazon Web Services Account.</p>', 'ListSubscribedWorkteams' => '<p>Gets a list of the work teams that you are subscribed to in the Amazon Web Services Marketplace. The list may be empty if no work team satisfies the filter specified in the <code>NameContains</code> parameter.</p>', 'ListTags' => '<p>Returns the tags for the specified SageMaker resource.</p>', 'ListTrainingJobs' => '<p>Lists training jobs.</p> <note> <p>When <code>StatusEquals</code> and <code>MaxResults</code> are set at the same time, the <code>MaxResults</code> number of training jobs are first retrieved ignoring the <code>StatusEquals</code> parameter and then they are filtered by the <code>StatusEquals</code> parameter, which is returned as a response.</p> <p>For example, if <code>ListTrainingJobs</code> is invoked with the following parameters:</p> <p> <code>{ ... MaxResults: 100, StatusEquals: InProgress ... }</code> </p> <p>First, 100 trainings jobs with any status, including those other than <code>InProgress</code>, are selected (sorted according to the creation time, from the most current to the oldest). Next, those with a status of <code>InProgress</code> are returned.</p> <p>You can quickly test the API using the following Amazon Web Services CLI code.</p> <p> <code>aws sagemaker list-training-jobs --max-results 100 --status-equals InProgress</code> </p> </note>', 'ListTrainingJobsForHyperParameterTuningJob' => '<p>Gets a list of <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_TrainingJobSummary.html">TrainingJobSummary</a> objects that describe the training jobs that a hyperparameter tuning job launched.</p>', 'ListTransformJobs' => '<p>Lists transform jobs.</p>', 'ListTrialComponents' => '<p>Lists the trial components in your account. You can sort the list by trial component name or creation time. You can filter the list to show only components that were created in a specific time range. You can also filter on one of the following:</p> <ul> <li> <p> <code>ExperimentName</code> </p> </li> <li> <p> <code>SourceArn</code> </p> </li> <li> <p> <code>TrialName</code> </p> </li> </ul>', 'ListTrials' => '<p>Lists the trials in your account. Specify an experiment name to limit the list to the trials that are part of that experiment. Specify a trial component name to limit the list to the trials that associated with that trial component. The list can be filtered to show only trials that were created in a specific time range. The list can be sorted by trial name or creation time.</p>', 'ListUserProfiles' => '<p>Lists user profiles.</p>', 'ListWorkforces' => '<p>Use this operation to list all private and vendor workforces in an Amazon Web Services Region. Note that you can only have one private workforce per Amazon Web Services Region.</p>', 'ListWorkteams' => '<p>Gets a list of private work teams that you have defined in a region. The list may be empty if no work team satisfies the filter specified in the <code>NameContains</code> parameter.</p>', 'PutModelPackageGroupPolicy' => '<p>Adds a resouce policy to control access to a model group. For information about resoure policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_identity-vs-resource.html">Identity-based policies and resource-based policies</a> in the <i>Amazon Web Services Identity and Access Management User Guide.</i>.</p>', 'QueryLineage' => '<p>Use this action to inspect your lineage and discover relationships between entities. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/querying-lineage-entities.html"> Querying Lineage Entities</a> in the <i>Amazon SageMaker Developer Guide</i>.</p>', 'RegisterDevices' => '<p>Register devices.</p>', 'RenderUiTemplate' => '<p>Renders the UI template so that you can preview the worker\'s experience. </p>', 'RetryPipelineExecution' => '<p>Retry the execution of the pipeline.</p>', 'Search' => '<p>Finds SageMaker resources that match a search query. Matching resources are returned as a list of <code>SearchRecord</code> objects in the response. You can sort the search results by any resource property in a ascending or descending order.</p> <p>You can query against the following value types: numeric, text, Boolean, and timestamp.</p> <note> <p>The Search API may provide access to otherwise restricted data. See <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/api-permissions-reference.html">Amazon SageMaker API Permissions: Actions, Permissions, and Resources Reference</a> for more information.</p> </note>', 'SendPipelineExecutionStepFailure' => '<p>Notifies the pipeline that the execution of a callback step failed, along with a message describing why. When a callback step is run, the pipeline generates a callback token and includes the token in a message sent to Amazon Simple Queue Service (Amazon SQS).</p>', 'SendPipelineExecutionStepSuccess' => '<p>Notifies the pipeline that the execution of a callback step succeeded and provides a list of the step\'s output parameters. When a callback step is run, the pipeline generates a callback token and includes the token in a message sent to Amazon Simple Queue Service (Amazon SQS).</p>', 'StartEdgeDeploymentStage' => '<p>Starts a stage in an edge deployment plan.</p>', 'StartInferenceExperiment' => '<p>Starts an inference experiment.</p>', 'StartMlflowTrackingServer' => '<p>Programmatically start an MLflow Tracking Server.</p>', 'StartMonitoringSchedule' => '<p>Starts a previously stopped monitoring schedule.</p> <note> <p>By default, when you successfully create a new schedule, the status of a monitoring schedule is <code>scheduled</code>.</p> </note>', 'StartNotebookInstance' => '<p>Launches an ML compute instance with the latest version of the libraries and attaches your ML storage volume. After configuring the notebook instance, SageMaker sets the notebook instance status to <code>InService</code>. A notebook instance\'s status must be <code>InService</code> before you can connect to your Jupyter notebook. </p>', 'StartPipelineExecution' => '<p>Starts a pipeline execution.</p>', 'StopAutoMLJob' => '<p>A method for forcing a running job to shut down.</p>', 'StopCompilationJob' => '<p>Stops a model compilation job.</p> <p> To stop a job, Amazon SageMaker sends the algorithm the SIGTERM signal. This gracefully shuts the job down. If the job hasn\'t stopped, it sends the SIGKILL signal.</p> <p>When it receives a <code>StopCompilationJob</code> request, Amazon SageMaker changes the <code>CompilationJobStatus</code> of the job to <code>Stopping</code>. After Amazon SageMaker stops the job, it sets the <code>CompilationJobStatus</code> to <code>Stopped</code>. </p>', 'StopEdgeDeploymentStage' => '<p>Stops a stage in an edge deployment plan.</p>', 'StopEdgePackagingJob' => '<p>Request to stop an edge packaging job.</p>', 'StopHyperParameterTuningJob' => '<p>Stops a running hyperparameter tuning job and all running training jobs that the tuning job launched.</p> <p>All model artifacts output from the training jobs are stored in Amazon Simple Storage Service (Amazon S3). All data that the training jobs write to Amazon CloudWatch Logs are still available in CloudWatch. After the tuning job moves to the <code>Stopped</code> state, it releases all reserved resources for the tuning job.</p>', 'StopInferenceExperiment' => '<p>Stops an inference experiment.</p>', 'StopInferenceRecommendationsJob' => '<p>Stops an Inference Recommender job.</p>', 'StopLabelingJob' => '<p>Stops a running labeling job. A job that is stopped cannot be restarted. Any results obtained before the job is stopped are placed in the Amazon S3 output bucket.</p>', 'StopMlflowTrackingServer' => '<p>Programmatically stop an MLflow Tracking Server.</p>', 'StopMonitoringSchedule' => '<p>Stops a previously started monitoring schedule.</p>', 'StopNotebookInstance' => '<p>Terminates the ML compute instance. Before terminating the instance, SageMaker disconnects the ML storage volume from it. SageMaker preserves the ML storage volume. SageMaker stops charging you for the ML compute instance when you call <code>StopNotebookInstance</code>.</p> <p>To access data on the ML storage volume for a notebook instance that has been terminated, call the <code>StartNotebookInstance</code> API. <code>StartNotebookInstance</code> launches another ML compute instance, configures it, and attaches the preserved ML storage volume so you can continue your work. </p>', 'StopOptimizationJob' => '<p>Ends a running inference optimization job.</p>', 'StopPipelineExecution' => '<p>Stops a pipeline execution.</p> <p> <b>Callback Step</b> </p> <p>A pipeline execution won\'t stop while a callback step is running. When you call <code>StopPipelineExecution</code> on a pipeline execution with a running callback step, SageMaker Pipelines sends an additional Amazon SQS message to the specified SQS queue. The body of the SQS message contains a "Status" field which is set to "Stopping".</p> <p>You should add logic to your Amazon SQS message consumer to take any needed action (for example, resource cleanup) upon receipt of the message followed by a call to <code>SendPipelineExecutionStepSuccess</code> or <code>SendPipelineExecutionStepFailure</code>.</p> <p>Only when SageMaker Pipelines receives one of these calls will it stop the pipeline execution.</p> <p> <b>Lambda Step</b> </p> <p>A pipeline execution can\'t be stopped while a lambda step is running because the Lambda function invoked by the lambda step can\'t be stopped. If you attempt to stop the execution while the Lambda function is running, the pipeline waits for the Lambda function to finish or until the timeout is hit, whichever occurs first, and then stops. If the Lambda function finishes, the pipeline execution status is <code>Stopped</code>. If the timeout is hit the pipeline execution status is <code>Failed</code>.</p>', 'StopProcessingJob' => '<p>Stops a processing job.</p>', 'StopTrainingJob' => '<p>Stops a training job. To stop a job, SageMaker sends the algorithm the <code>SIGTERM</code> signal, which delays job termination for 120 seconds. Algorithms might use this 120-second window to save the model artifacts, so the results of the training is not lost. </p> <p>When it receives a <code>StopTrainingJob</code> request, SageMaker changes the status of the job to <code>Stopping</code>. After SageMaker stops the job, it sets the status to <code>Stopped</code>.</p>', 'StopTransformJob' => '<p>Stops a batch transform job.</p> <p>When Amazon SageMaker receives a <code>StopTransformJob</code> request, the status of the job changes to <code>Stopping</code>. After Amazon SageMaker stops the job, the status is set to <code>Stopped</code>. When you stop a batch transform job before it is completed, Amazon SageMaker doesn\'t store the job\'s output in Amazon S3.</p>', 'UpdateAction' => '<p>Updates an action.</p>', 'UpdateAppImageConfig' => '<p>Updates the properties of an AppImageConfig.</p>', 'UpdateArtifact' => '<p>Updates an artifact.</p>', 'UpdateCluster' => '<p>Updates a SageMaker HyperPod cluster.</p>', 'UpdateClusterSoftware' => '<p>Updates the platform software of a SageMaker HyperPod cluster for security patching. To learn how to use this API, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-hyperpod-operate.html#sagemaker-hyperpod-operate-cli-command-update-cluster-software">Update the SageMaker HyperPod platform software of a cluster</a>.</p>', 'UpdateCodeRepository' => '<p>Updates the specified Git repository with the specified values.</p>', 'UpdateContext' => '<p>Updates a context.</p>', 'UpdateDeviceFleet' => '<p>Updates a fleet of devices.</p>', 'UpdateDevices' => '<p>Updates one or more devices in a fleet.</p>', 'UpdateDomain' => '<p>Updates the default settings for new user profiles in the domain.</p>', 'UpdateEndpoint' => '<p>Deploys the <code>EndpointConfig</code> specified in the request to a new fleet of instances. SageMaker shifts endpoint traffic to the new instances with the updated endpoint configuration and then deletes the old instances using the previous <code>EndpointConfig</code> (there is no availability loss). For more information about how to control the update and traffic shifting process, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/deployment-guardrails.html"> Update models in production</a>.</p> <p>When SageMaker receives the request, it sets the endpoint status to <code>Updating</code>. After updating the endpoint, it sets the status to <code>InService</code>. To check the status of an endpoint, use the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeEndpoint.html">DescribeEndpoint</a> API. </p> <note> <p>You must not delete an <code>EndpointConfig</code> in use by an endpoint that is live or while the <code>UpdateEndpoint</code> or <code>CreateEndpoint</code> operations are being performed on the endpoint. To update an endpoint, you must create a new <code>EndpointConfig</code>.</p> <p>If you delete the <code>EndpointConfig</code> of an endpoint that is active or being created or updated you may lose visibility into the instance type the endpoint is using. The endpoint must be deleted in order to stop incurring charges.</p> </note>', 'UpdateEndpointWeightsAndCapacities' => '<p>Updates variant weight of one or more variants associated with an existing endpoint, or capacity of one variant associated with an existing endpoint. When it receives the request, SageMaker sets the endpoint status to <code>Updating</code>. After updating the endpoint, it sets the status to <code>InService</code>. To check the status of an endpoint, use the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeEndpoint.html">DescribeEndpoint</a> API. </p>', 'UpdateExperiment' => '<p>Adds, updates, or removes the description of an experiment. Updates the display name of an experiment.</p>', 'UpdateFeatureGroup' => '<p>Updates the feature group by either adding features or updating the online store configuration. Use one of the following request parameters at a time while using the <code>UpdateFeatureGroup</code> API.</p> <p>You can add features for your feature group using the <code>FeatureAdditions</code> request parameter. Features cannot be removed from a feature group.</p> <p>You can update the online store configuration by using the <code>OnlineStoreConfig</code> request parameter. If a <code>TtlDuration</code> is specified, the default <code>TtlDuration</code> applies for all records added to the feature group <i>after the feature group is updated</i>. If a record level <code>TtlDuration</code> exists from using the <code>PutRecord</code> API, the record level <code>TtlDuration</code> applies to that record instead of the default <code>TtlDuration</code>. To remove the default <code>TtlDuration</code> from an existing feature group, use the <code>UpdateFeatureGroup</code> API and set the <code>TtlDuration</code> <code>Unit</code> and <code>Value</code> to <code>null</code>.</p>', 'UpdateFeatureMetadata' => '<p>Updates the description and parameters of the feature group.</p>', 'UpdateHub' => '<p>Update a hub.</p>', 'UpdateImage' => '<p>Updates the properties of a SageMaker image. To change the image\'s tags, use the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AddTags.html">AddTags</a> and <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteTags.html">DeleteTags</a> APIs.</p>', 'UpdateImageVersion' => '<p>Updates the properties of a SageMaker image version.</p>', 'UpdateInferenceComponent' => '<p>Updates an inference component.</p>', 'UpdateInferenceComponentRuntimeConfig' => '<p>Runtime settings for a model that is deployed with an inference component.</p>', 'UpdateInferenceExperiment' => '<p> Updates an inference experiment that you created. The status of the inference experiment has to be either <code>Created</code>, <code>Running</code>. For more information on the status of an inference experiment, see <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeInferenceExperiment.html">DescribeInferenceExperiment</a>. </p>', 'UpdateMlflowTrackingServer' => '<p>Updates properties of an existing MLflow Tracking Server.</p>', 'UpdateModelCard' => '<p>Update an Amazon SageMaker Model Card.</p> <important> <p>You cannot update both model card content and model card status in a single call.</p> </important>', 'UpdateModelPackage' => '<p>Updates a versioned model.</p>', 'UpdateMonitoringAlert' => '<p>Update the parameters of a model monitor alert.</p>', 'UpdateMonitoringSchedule' => '<p>Updates a previously created schedule.</p>', 'UpdateNotebookInstance' => '<p>Updates a notebook instance. NotebookInstance updates include upgrading or downgrading the ML compute instance used for your notebook instance to accommodate changes in your workload requirements.</p>', 'UpdateNotebookInstanceLifecycleConfig' => '<p>Updates a notebook instance lifecycle configuration created with the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateNotebookInstanceLifecycleConfig.html">CreateNotebookInstanceLifecycleConfig</a> API.</p>', 'UpdatePipeline' => '<p>Updates a pipeline.</p>', 'UpdatePipelineExecution' => '<p>Updates a pipeline execution.</p>', 'UpdateProject' => '<p>Updates a machine learning (ML) project that is created from a template that sets up an ML pipeline from training to deploying an approved model.</p> <note> <p>You must not update a project that is in use. If you update the <code>ServiceCatalogProvisioningUpdateDetails</code> of a project that is active or being created, or updated, you may lose resources already created by the project.</p> </note>', 'UpdateSpace' => '<p>Updates the settings of a space.</p>', 'UpdateTrainingJob' => '<p>Update a model training job to request a new Debugger profiling configuration or to change warm pool retention length.</p>', 'UpdateTrial' => '<p>Updates the display name of a trial.</p>', 'UpdateTrialComponent' => '<p>Updates one or more properties of a trial component.</p>', 'UpdateUserProfile' => '<p>Updates a user profile.</p>', 'UpdateWorkforce' => '<p>Use this operation to update your workforce. You can use this operation to require that workers use specific IP addresses to work on tasks and to update your OpenID Connect (OIDC) Identity Provider (IdP) workforce configuration.</p> <p>The worker portal is now supported in VPC and public internet.</p> <p> Use <code>SourceIpConfig</code> to restrict worker access to tasks to a specific range of IP addresses. You specify allowed IP addresses by creating a list of up to ten <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">CIDRs</a>. By default, a workforce isn\'t restricted to specific IP addresses. If you specify a range of IP addresses, workers who attempt to access tasks using any IP address outside the specified range are denied and get a <code>Not Found</code> error message on the worker portal.</p> <p>To restrict access to all the workers in public internet, add the <code>SourceIpConfig</code> CIDR value as "10.0.0.0/16".</p> <important> <p>Amazon SageMaker does not support Source Ip restriction for worker portals in VPC.</p> </important> <p>Use <code>OidcConfig</code> to update the configuration of a workforce created using your own OIDC IdP. </p> <important> <p>You can only update your OIDC IdP configuration when there are no work teams associated with your workforce. You can delete work teams using the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteWorkteam.html">DeleteWorkteam</a> operation.</p> </important> <p>After restricting access to a range of IP addresses or updating your OIDC IdP configuration with this operation, you can view details about your update workforce using the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeWorkforce.html">DescribeWorkforce</a> operation.</p> <important> <p>This operation only applies to private workforces.</p> </important>', 'UpdateWorkteam' => '<p>Updates an existing work team with new member definitions or description.</p>', ], 'shapes' => [ 'Accept' => [ 'base' => NULL, 'refs' => [ 'TransformOutput$Accept' => '<p>The MIME type used to specify the output data. Amazon SageMaker uses the MIME type with each http call to transfer data from the transform job.</p>', ], ], 'AcceptEula' => [ 'base' => NULL, 'refs' => [ 'ModelAccessConfig$AcceptEula' => '<p>Specifies agreement to the model end-user license agreement (EULA). The <code>AcceptEula</code> value must be explicitly defined as <code>True</code> in order to accept the EULA that this model requires. You are responsible for reviewing and complying with any applicable license terms and making sure they are acceptable for your use case before downloading or using a model.</p>', ], ], 'AccountId' => [ 'base' => NULL, 'refs' => [ 'LabelingJobForWorkteamSummary$WorkRequesterAccountId' => '<p>The Amazon Web Services account ID of the account used to start the labeling job.</p>', 'VpcOnlyTrustedAccounts$member' => NULL, ], ], 'ActionArn' => [ 'base' => NULL, 'refs' => [ 'ActionSummary$ActionArn' => '<p>The Amazon Resource Name (ARN) of the action.</p>', 'CreateActionResponse$ActionArn' => '<p>The Amazon Resource Name (ARN) of the action.</p>', 'DeleteActionResponse$ActionArn' => '<p>The Amazon Resource Name (ARN) of the action.</p>', 'DescribeActionResponse$ActionArn' => '<p>The Amazon Resource Name (ARN) of the action.</p>', 'UpdateActionResponse$ActionArn' => '<p>The Amazon Resource Name (ARN) of the action.</p>', ], ], 'ActionSource' => [ 'base' => '<p>A structure describing the source of an action.</p>', 'refs' => [ 'ActionSummary$Source' => '<p>The source of the action.</p>', 'CreateActionRequest$Source' => '<p>The source type, ID, and URI.</p>', 'DescribeActionResponse$Source' => '<p>The source of the action.</p>', ], ], 'ActionStatus' => [ 'base' => NULL, 'refs' => [ 'ActionSummary$Status' => '<p>The status of the action.</p>', 'CreateActionRequest$Status' => '<p>The status of the action.</p>', 'DescribeActionResponse$Status' => '<p>The status of the action.</p>', 'UpdateActionRequest$Status' => '<p>The new status for the action.</p>', ], ], 'ActionSummaries' => [ 'base' => NULL, 'refs' => [ 'ListActionsResponse$ActionSummaries' => '<p>A list of actions and their properties.</p>', ], ], 'ActionSummary' => [ 'base' => '<p>Lists the properties of an <i>action</i>. An action represents an action or activity. Some examples are a workflow step and a model deployment. Generally, an action involves at least one input artifact or output artifact.</p>', 'refs' => [ 'ActionSummaries$member' => NULL, ], ], 'AddAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'AddAssociationResponse' => [ 'base' => NULL, 'refs' => [], ], 'AddTagsInput' => [ 'base' => NULL, 'refs' => [], ], 'AddTagsOutput' => [ 'base' => NULL, 'refs' => [], ], 'AdditionalCodeRepositoryNamesOrUrls' => [ 'base' => NULL, 'refs' => [ 'CreateNotebookInstanceInput$AdditionalCodeRepositories' => '<p>An array of up to three Git repositories to associate with the notebook instance. These can be either the names of Git repositories stored as resources in your account, or the URL of Git repositories in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services CodeCommit</a> or in any other Git repository. These repositories are cloned at the same level as the default repository of your notebook instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with SageMaker Notebook Instances</a>.</p>', 'DescribeNotebookInstanceOutput$AdditionalCodeRepositories' => '<p>An array of up to three Git repositories associated with the notebook instance. These can be either the names of Git repositories stored as resources in your account, or the URL of Git repositories in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services CodeCommit</a> or in any other Git repository. These repositories are cloned at the same level as the default repository of your notebook instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with SageMaker Notebook Instances</a>.</p>', 'NotebookInstanceSummary$AdditionalCodeRepositories' => '<p>An array of up to three Git repositories associated with the notebook instance. These can be either the names of Git repositories stored as resources in your account, or the URL of Git repositories in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services CodeCommit</a> or in any other Git repository. These repositories are cloned at the same level as the default repository of your notebook instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with SageMaker Notebook Instances</a>.</p>', 'UpdateNotebookInstanceInput$AdditionalCodeRepositories' => '<p>An array of up to three Git repositories to associate with the notebook instance. These can be either the names of Git repositories stored as resources in your account, or the URL of Git repositories in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services CodeCommit</a> or in any other Git repository. These repositories are cloned at the same level as the default repository of your notebook instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with SageMaker Notebook Instances</a>.</p>', ], ], 'AdditionalInferenceSpecificationDefinition' => [ 'base' => '<p>A structure of additional Inference Specification. Additional Inference Specification specifies details about inference jobs that can be run with models based on this model package</p>', 'refs' => [ 'AdditionalInferenceSpecifications$member' => NULL, ], ], 'AdditionalInferenceSpecifications' => [ 'base' => NULL, 'refs' => [ 'CreateModelPackageInput$AdditionalInferenceSpecifications' => '<p>An array of additional Inference Specification objects. Each additional Inference Specification specifies artifacts based on this model package that can be used on inference endpoints. Generally used with SageMaker Neo to store the compiled artifacts. </p>', 'DescribeModelPackageOutput$AdditionalInferenceSpecifications' => '<p>An array of additional Inference Specification objects. Each additional Inference Specification specifies artifacts based on this model package that can be used on inference endpoints. Generally used with SageMaker Neo to store the compiled artifacts.</p>', 'ModelPackage$AdditionalInferenceSpecifications' => '<p>An array of additional Inference Specification objects.</p>', 'UpdateModelPackageInput$AdditionalInferenceSpecificationsToAdd' => '<p>An array of additional Inference Specification objects to be added to the existing array additional Inference Specification. Total number of additional Inference Specifications can not exceed 15. Each additional Inference Specification specifies artifacts based on this model package that can be used on inference endpoints. Generally used with SageMaker Neo to store the compiled artifacts.</p>', ], ], 'AdditionalModelChannelName' => [ 'base' => NULL, 'refs' => [ 'AdditionalModelDataSource$ChannelName' => '<p>A custom name for this <code>AdditionalModelDataSource</code> object.</p>', ], ], 'AdditionalModelDataSource' => [ 'base' => '<p>Data sources that are available to your model in addition to the one that you specify for <code>ModelDataSource</code> when you use the <code>CreateModel</code> action.</p>', 'refs' => [ 'AdditionalModelDataSources$member' => NULL, ], ], 'AdditionalModelDataSources' => [ 'base' => NULL, 'refs' => [ 'ContainerDefinition$AdditionalModelDataSources' => '<p>Data sources that are available to your model in addition to the one that you specify for <code>ModelDataSource</code> when you use the <code>CreateModel</code> action.</p>', ], ], 'AdditionalS3DataSource' => [ 'base' => '<p>A data source used for training or inference that is in addition to the input dataset or model data.</p>', 'refs' => [ 'ModelPackageContainerDefinition$AdditionalS3DataSource' => '<p>The additional data source that is used during inference in the Docker container for your model package.</p>', 'TrainingSpecification$AdditionalS3DataSource' => '<p>The additional data source used during the training job.</p>', ], ], 'AdditionalS3DataSourceDataType' => [ 'base' => NULL, 'refs' => [ 'AdditionalS3DataSource$S3DataType' => '<p>The data type of the additional data source that you specify for use in inference or training. </p>', ], ], 'AgentVersion' => [ 'base' => '<p>Edge Manager agent version.</p>', 'refs' => [ 'AgentVersions$member' => NULL, ], ], 'AgentVersions' => [ 'base' => NULL, 'refs' => [ 'GetDeviceFleetReportResponse$AgentVersions' => '<p>The versions of Edge Manager agent deployed on the fleet.</p>', ], ], 'AggregationTransformationValue' => [ 'base' => NULL, 'refs' => [ 'AggregationTransformations$value' => NULL, ], ], 'AggregationTransformations' => [ 'base' => NULL, 'refs' => [ 'TimeSeriesTransformations$Aggregation' => '<p>A key value pair defining the aggregation method for a column, where the key is the column name and the value is the aggregation method.</p> <p>The supported aggregation methods are <code>sum</code> (default), <code>avg</code>, <code>first</code>, <code>min</code>, <code>max</code>.</p> <note> <p>Aggregation is only supported for the target column.</p> </note>', ], ], 'Alarm' => [ 'base' => '<p>An Amazon CloudWatch alarm configured to monitor metrics on an endpoint.</p>', 'refs' => [ 'AlarmList$member' => NULL, ], ], 'AlarmList' => [ 'base' => NULL, 'refs' => [ 'AutoRollbackConfig$Alarms' => '<p>List of CloudWatch alarms in your account that are configured to monitor metrics on an endpoint. If any alarms are tripped during a deployment, SageMaker rolls back the deployment.</p>', ], ], 'AlarmName' => [ 'base' => NULL, 'refs' => [ 'Alarm$AlarmName' => '<p>The name of a CloudWatch alarm in your account.</p>', ], ], 'AlgorithmArn' => [ 'base' => NULL, 'refs' => [ 'AlgorithmSummary$AlgorithmArn' => '<p>The Amazon Resource Name (ARN) of the algorithm.</p>', 'CreateAlgorithmOutput$AlgorithmArn' => '<p>The Amazon Resource Name (ARN) of the new algorithm.</p>', 'DescribeAlgorithmOutput$AlgorithmArn' => '<p>The Amazon Resource Name (ARN) of the algorithm.</p>', ], ], 'AlgorithmImage' => [ 'base' => NULL, 'refs' => [ 'AlgorithmSpecification$TrainingImage' => '<p>The registry path of the Docker image that contains the training algorithm. For information about docker registry paths for SageMaker built-in algorithms, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-algo-docker-registry-paths.html">Docker Registry Paths and Example Code</a> in the <i>Amazon SageMaker developer guide</i>. SageMaker supports both <code>registry/repository[:tag]</code> and <code>registry/repository[@digest]</code> image path formats. For more information about using your custom training container, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html">Using Your Own Algorithms with Amazon SageMaker</a>.</p> <note> <p>You must specify either the algorithm name to the <code>AlgorithmName</code> parameter or the image URI of the algorithm container to the <code>TrainingImage</code> parameter.</p> <p>For more information, see the note in the <code>AlgorithmName</code> parameter description.</p> </note>', 'DebugRuleConfiguration$RuleEvaluatorImage' => '<p>The Amazon Elastic Container (ECR) Image for the managed rule evaluation.</p>', 'HyperParameterAlgorithmSpecification$TrainingImage' => '<p> The registry path of the Docker image that contains the training algorithm. For information about Docker registry paths for built-in algorithms, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-algo-docker-registry-paths.html">Algorithms Provided by Amazon SageMaker: Common Parameters</a>. SageMaker supports both <code>registry/repository[:tag]</code> and <code>registry/repository[@digest]</code> image path formats. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html">Using Your Own Algorithms with Amazon SageMaker</a>.</p>', 'ProfilerRuleConfiguration$RuleEvaluatorImage' => '<p>The Amazon Elastic Container Registry Image for the managed rule evaluation.</p>', ], ], 'AlgorithmSortBy' => [ 'base' => NULL, 'refs' => [ 'ListAlgorithmsInput$SortBy' => '<p>The parameter by which to sort the results. The default is <code>CreationTime</code>.</p>', ], ], 'AlgorithmSpecification' => [ 'base' => '<p>Specifies the training algorithm to use in a <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTrainingJob.html">CreateTrainingJob</a> request.</p> <p>For more information about algorithms provided by SageMaker, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html">Algorithms</a>. For information about using your own algorithms, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html">Using Your Own Algorithms with Amazon SageMaker</a>. </p>', 'refs' => [ 'CreateTrainingJobRequest$AlgorithmSpecification' => '<p>The registry path of the Docker image that contains the training algorithm and algorithm-specific metadata, including the input mode. For more information about algorithms provided by SageMaker, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html">Algorithms</a>. For information about providing your own algorithms, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html">Using Your Own Algorithms with Amazon SageMaker</a>. </p>', 'DescribeTrainingJobResponse$AlgorithmSpecification' => '<p>Information about the algorithm used for training, and algorithm metadata. </p>', 'TrainingJob$AlgorithmSpecification' => '<p>Information about the algorithm used for training, and algorithm metadata.</p>', ], ], 'AlgorithmStatus' => [ 'base' => NULL, 'refs' => [ 'AlgorithmSummary$AlgorithmStatus' => '<p>The overall status of the algorithm.</p>', 'DescribeAlgorithmOutput$AlgorithmStatus' => '<p>The current status of the algorithm.</p>', ], ], 'AlgorithmStatusDetails' => [ 'base' => '<p>Specifies the validation and image scan statuses of the algorithm.</p>', 'refs' => [ 'DescribeAlgorithmOutput$AlgorithmStatusDetails' => '<p>Details about the current status of the algorithm.</p>', ], ], 'AlgorithmStatusItem' => [ 'base' => '<p>Represents the overall status of an algorithm.</p>', 'refs' => [ 'AlgorithmStatusItemList$member' => NULL, ], ], 'AlgorithmStatusItemList' => [ 'base' => NULL, 'refs' => [ 'AlgorithmStatusDetails$ValidationStatuses' => '<p>The status of algorithm validation.</p>', 'AlgorithmStatusDetails$ImageScanStatuses' => '<p>The status of the scan of the algorithm\'s Docker image container.</p>', ], ], 'AlgorithmSummary' => [ 'base' => '<p>Provides summary information about an algorithm.</p>', 'refs' => [ 'AlgorithmSummaryList$member' => NULL, ], ], 'AlgorithmSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListAlgorithmsOutput$AlgorithmSummaryList' => '<p>&gt;An array of <code>AlgorithmSummary</code> objects, each of which lists an algorithm.</p>', ], ], 'AlgorithmValidationProfile' => [ 'base' => '<p>Defines a training job and a batch transform job that SageMaker runs to validate your algorithm.</p> <p>The data provided in the validation profile is made available to your buyers on Amazon Web Services Marketplace.</p>', 'refs' => [ 'AlgorithmValidationProfiles$member' => NULL, ], ], 'AlgorithmValidationProfiles' => [ 'base' => NULL, 'refs' => [ 'AlgorithmValidationSpecification$ValidationProfiles' => '<p>An array of <code>AlgorithmValidationProfile</code> objects, each of which specifies a training job and batch transform job that SageMaker runs to validate your algorithm.</p>', ], ], 'AlgorithmValidationSpecification' => [ 'base' => '<p>Specifies configurations for one or more training jobs that SageMaker runs to test the algorithm.</p>', 'refs' => [ 'CreateAlgorithmInput$ValidationSpecification' => '<p>Specifies configurations for one or more training jobs and that SageMaker runs to test the algorithm\'s training code and, optionally, one or more batch transform jobs that SageMaker runs to test the algorithm\'s inference code.</p>', 'DescribeAlgorithmOutput$ValidationSpecification' => '<p>Details about configurations for one or more training jobs that SageMaker runs to test the algorithm.</p>', ], ], 'AmazonQSettings' => [ 'base' => '<p>A collection of settings that configure the Amazon Q experience within the domain.</p>', 'refs' => [ 'DomainSettings$AmazonQSettings' => '<p>A collection of settings that configure the Amazon Q experience within the domain. The <code>AuthMode</code> that you use to create the domain must be <code>SSO</code>.</p>', 'DomainSettingsForUpdate$AmazonQSettings' => '<p>A collection of settings that configure the Amazon Q experience within the domain.</p>', ], ], 'AnnotationConsolidationConfig' => [ 'base' => '<p>Configures how labels are consolidated across human workers and processes output data. </p>', 'refs' => [ 'HumanTaskConfig$AnnotationConsolidationConfig' => '<p>Configures how labels are consolidated across human workers.</p>', ], ], 'AppArn' => [ 'base' => NULL, 'refs' => [ 'CreateAppResponse$AppArn' => '<p>The Amazon Resource Name (ARN) of the app.</p>', 'DescribeAppResponse$AppArn' => '<p>The Amazon Resource Name (ARN) of the app.</p>', ], ], 'AppDetails' => [ 'base' => '<p>Details about an Amazon SageMaker app.</p>', 'refs' => [ 'AppList$member' => NULL, ], ], 'AppImageConfigArn' => [ 'base' => NULL, 'refs' => [ 'AppImageConfigDetails$AppImageConfigArn' => '<p>The ARN of the AppImageConfig.</p>', 'CreateAppImageConfigResponse$AppImageConfigArn' => '<p>The ARN of the AppImageConfig.</p>', 'DescribeAppImageConfigResponse$AppImageConfigArn' => '<p>The ARN of the AppImageConfig.</p>', 'UpdateAppImageConfigResponse$AppImageConfigArn' => '<p>The ARN for the AppImageConfig.</p>', ], ], 'AppImageConfigDetails' => [ 'base' => '<p>The configuration for running a SageMaker image as a KernelGateway app.</p>', 'refs' => [ 'AppImageConfigList$member' => NULL, ], ], 'AppImageConfigList' => [ 'base' => NULL, 'refs' => [ 'ListAppImageConfigsResponse$AppImageConfigs' => '<p>A list of AppImageConfigs and their properties.</p>', ], ], 'AppImageConfigName' => [ 'base' => NULL, 'refs' => [ 'AppImageConfigDetails$AppImageConfigName' => '<p>The name of the AppImageConfig. Must be unique to your account.</p>', 'CreateAppImageConfigRequest$AppImageConfigName' => '<p>The name of the AppImageConfig. Must be unique to your account.</p>', 'CustomImage$AppImageConfigName' => '<p>The name of the AppImageConfig.</p>', 'DeleteAppImageConfigRequest$AppImageConfigName' => '<p>The name of the AppImageConfig to delete.</p>', 'DescribeAppImageConfigRequest$AppImageConfigName' => '<p>The name of the AppImageConfig to describe.</p>', 'DescribeAppImageConfigResponse$AppImageConfigName' => '<p>The name of the AppImageConfig.</p>', 'ListAppImageConfigsRequest$NameContains' => '<p>A filter that returns only AppImageConfigs whose name contains the specified string.</p>', 'UpdateAppImageConfigRequest$AppImageConfigName' => '<p>The name of the AppImageConfig to update.</p>', ], ], 'AppImageConfigSortKey' => [ 'base' => NULL, 'refs' => [ 'ListAppImageConfigsRequest$SortBy' => '<p>The property used to sort results. The default value is <code>CreationTime</code>.</p>', ], ], 'AppInstanceType' => [ 'base' => NULL, 'refs' => [ 'ResourceSpec$InstanceType' => '<p>The instance type that the image version runs on.</p> <note> <p> <b>JupyterServer apps</b> only support the <code>system</code> value.</p> <p>For <b>KernelGateway apps</b>, the <code>system</code> value is translated to <code>ml.t3.medium</code>. KernelGateway apps also support all other values for available instance types.</p> </note>', ], ], 'AppList' => [ 'base' => NULL, 'refs' => [ 'ListAppsResponse$Apps' => '<p>The list of apps.</p>', ], ], 'AppManaged' => [ 'base' => NULL, 'refs' => [ 'ProcessingInput$AppManaged' => '<p>When <code>True</code>, input operations such as data download are managed natively by the processing job application. When <code>False</code> (default), input operations are managed by Amazon SageMaker.</p>', 'ProcessingOutput$AppManaged' => '<p>When <code>True</code>, output operations such as data upload are managed natively by the processing job application. When <code>False</code> (default), output operations are managed by Amazon SageMaker.</p>', ], ], 'AppName' => [ 'base' => NULL, 'refs' => [ 'AppDetails$AppName' => '<p>The name of the app.</p>', 'CreateAppRequest$AppName' => '<p>The name of the app.</p>', 'DeleteAppRequest$AppName' => '<p>The name of the app.</p>', 'DescribeAppRequest$AppName' => '<p>The name of the app.</p>', 'DescribeAppResponse$AppName' => '<p>The name of the app.</p>', ], ], 'AppNetworkAccessType' => [ 'base' => NULL, 'refs' => [ 'CreateDomainRequest$AppNetworkAccessType' => '<p>Specifies the VPC used for non-EFS traffic. The default value is <code>PublicInternetOnly</code>.</p> <ul> <li> <p> <code>PublicInternetOnly</code> - Non-EFS traffic is through a VPC managed by Amazon SageMaker, which allows direct internet access</p> </li> <li> <p> <code>VpcOnly</code> - All traffic is through the specified VPC and subnets</p> </li> </ul>', 'DescribeDomainResponse$AppNetworkAccessType' => '<p>Specifies the VPC used for non-EFS traffic. The default value is <code>PublicInternetOnly</code>.</p> <ul> <li> <p> <code>PublicInternetOnly</code> - Non-EFS traffic is through a VPC managed by Amazon SageMaker, which allows direct internet access</p> </li> <li> <p> <code>VpcOnly</code> - All traffic is through the specified VPC and subnets</p> </li> </ul>', 'UpdateDomainRequest$AppNetworkAccessType' => '<p>Specifies the VPC used for non-EFS traffic.</p> <ul> <li> <p> <code>PublicInternetOnly</code> - Non-EFS traffic is through a VPC managed by Amazon SageMaker, which allows direct internet access.</p> </li> <li> <p> <code>VpcOnly</code> - All Studio traffic is through the specified VPC and subnets.</p> </li> </ul> <p>This configuration can only be modified if there are no apps in the <code>InService</code>, <code>Pending</code>, or <code>Deleting</code> state. The configuration cannot be updated if <code>DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn</code> is already set or <code>DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn</code> is provided as part of the same request.</p>', ], ], 'AppSecurityGroupManagement' => [ 'base' => NULL, 'refs' => [ 'CreateDomainRequest$AppSecurityGroupManagement' => '<p>The entity that creates and manages the required security groups for inter-app communication in <code>VPCOnly</code> mode. Required when <code>CreateDomain.AppNetworkAccessType</code> is <code>VPCOnly</code> and <code>DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn</code> is provided. If setting up the domain for use with RStudio, this value must be set to <code>Service</code>.</p>', 'DescribeDomainResponse$AppSecurityGroupManagement' => '<p>The entity that creates and manages the required security groups for inter-app communication in <code>VPCOnly</code> mode. Required when <code>CreateDomain.AppNetworkAccessType</code> is <code>VPCOnly</code> and <code>DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn</code> is provided.</p>', 'UpdateDomainRequest$AppSecurityGroupManagement' => '<p>The entity that creates and manages the required security groups for inter-app communication in <code>VPCOnly</code> mode. Required when <code>CreateDomain.AppNetworkAccessType</code> is <code>VPCOnly</code> and <code>DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn</code> is provided. If setting up the domain for use with RStudio, this value must be set to <code>Service</code>.</p>', ], ], 'AppSortKey' => [ 'base' => NULL, 'refs' => [ 'ListAppsRequest$SortBy' => '<p>The parameter by which to sort the results. The default is CreationTime.</p>', ], ], 'AppSpecification' => [ 'base' => '<p>Configuration to run a processing job in a specified container image.</p>', 'refs' => [ 'CreateProcessingJobRequest$AppSpecification' => '<p>Configures the processing job to run a specified Docker container image.</p>', 'DescribeProcessingJobResponse$AppSpecification' => '<p>Configures the processing job to run a specified container image.</p>', 'ProcessingJob$AppSpecification' => NULL, ], ], 'AppStatus' => [ 'base' => NULL, 'refs' => [ 'AppDetails$Status' => '<p>The status.</p>', 'DescribeAppResponse$Status' => '<p>The status.</p>', ], ], 'AppType' => [ 'base' => NULL, 'refs' => [ 'AppDetails$AppType' => '<p>The type of app.</p>', 'CreateAppRequest$AppType' => '<p>The type of app.</p>', 'DeleteAppRequest$AppType' => '<p>The type of app.</p>', 'DescribeAppRequest$AppType' => '<p>The type of app.</p>', 'DescribeAppResponse$AppType' => '<p>The type of app.</p>', 'HiddenAppTypesList$member' => NULL, 'SpaceSettings$AppType' => '<p>The type of app created within the space.</p>', 'SpaceSettingsSummary$AppType' => '<p>The type of app created within the space.</p>', ], ], 'ApprovalDescription' => [ 'base' => NULL, 'refs' => [ 'DescribeModelPackageOutput$ApprovalDescription' => '<p>A description provided for the model approval.</p>', 'ModelPackage$ApprovalDescription' => '<p>A description provided when the model approval is set.</p>', 'UpdateModelPackageInput$ApprovalDescription' => '<p>A description for the approval status of the model.</p>', ], ], 'ArnOrName' => [ 'base' => NULL, 'refs' => [ 'AlgorithmSpecification$AlgorithmName' => '<p>The name of the algorithm resource to use for the training job. This must be an algorithm resource that you created or subscribe to on Amazon Web Services Marketplace.</p> <note> <p>You must specify either the algorithm name to the <code>AlgorithmName</code> parameter or the image URI of the algorithm container to the <code>TrainingImage</code> parameter.</p> <p>Note that the <code>AlgorithmName</code> parameter is mutually exclusive with the <code>TrainingImage</code> parameter. If you specify a value for the <code>AlgorithmName</code> parameter, you can\'t specify a value for <code>TrainingImage</code>, and vice versa.</p> <p>If you specify values for both parameters, the training job might break; if you don\'t specify any value for both parameters, the training job might raise a <code>null</code> error.</p> </note>', 'CreateModelPackageInput$ModelPackageGroupName' => '<p>The name or Amazon Resource Name (ARN) of the model package group that this model version belongs to.</p> <p>This parameter is required for versioned models, and does not apply to unversioned models.</p>', 'DeleteModelPackageGroupInput$ModelPackageGroupName' => '<p>The name of the model group to delete.</p>', 'DescribeAlgorithmInput$AlgorithmName' => '<p>The name of the algorithm to describe.</p>', 'DescribeModelPackageGroupInput$ModelPackageGroupName' => '<p>The name of the model group to describe.</p>', 'HyperParameterAlgorithmSpecification$AlgorithmName' => '<p>The name of the resource algorithm to use for the hyperparameter tuning job. If you specify a value for this parameter, do not specify a value for <code>TrainingImage</code>.</p>', 'ListModelPackagesInput$ModelPackageGroupName' => '<p>A filter that returns only model versions that belong to the specified model group.</p>', 'SourceAlgorithm$AlgorithmName' => '<p>The name of an algorithm that was used to create the model package. The algorithm must be either an algorithm resource in your SageMaker account or an algorithm in Amazon Web Services Marketplace that you are subscribed to.</p>', ], ], 'ArtifactArn' => [ 'base' => NULL, 'refs' => [ 'ArtifactSummary$ArtifactArn' => '<p>The Amazon Resource Name (ARN) of the artifact.</p>', 'CreateArtifactResponse$ArtifactArn' => '<p>The Amazon Resource Name (ARN) of the artifact.</p>', 'DeleteArtifactRequest$ArtifactArn' => '<p>The Amazon Resource Name (ARN) of the artifact to delete.</p>', 'DeleteArtifactResponse$ArtifactArn' => '<p>The Amazon Resource Name (ARN) of the artifact.</p>', 'DescribeArtifactRequest$ArtifactArn' => '<p>The Amazon Resource Name (ARN) of the artifact to describe.</p>', 'DescribeArtifactResponse$ArtifactArn' => '<p>The Amazon Resource Name (ARN) of the artifact.</p>', 'UpdateArtifactRequest$ArtifactArn' => '<p>The Amazon Resource Name (ARN) of the artifact to update.</p>', 'UpdateArtifactResponse$ArtifactArn' => '<p>The Amazon Resource Name (ARN) of the artifact.</p>', ], ], 'ArtifactDigest' => [ 'base' => NULL, 'refs' => [ 'ModelDigests$ArtifactDigest' => '<p>Provides a hash value that uniquely identifies the stored model artifacts.</p>', ], ], 'ArtifactProperties' => [ 'base' => NULL, 'refs' => [ 'CreateArtifactRequest$Properties' => '<p>A list of properties to add to the artifact.</p>', 'UpdateArtifactRequest$Properties' => '<p>The new list of properties. Overwrites the current property list.</p>', ], ], 'ArtifactPropertyValue' => [ 'base' => NULL, 'refs' => [ 'ArtifactProperties$value' => NULL, ], ], 'ArtifactSource' => [ 'base' => '<p>A structure describing the source of an artifact.</p>', 'refs' => [ 'ArtifactSummary$Source' => '<p>The source of the artifact.</p>', 'CreateArtifactRequest$Source' => '<p>The ID, ID type, and URI of the source.</p>', 'DeleteArtifactRequest$Source' => '<p>The URI of the source.</p>', 'DescribeArtifactResponse$Source' => '<p>The source of the artifact.</p>', ], ], 'ArtifactSourceIdType' => [ 'base' => NULL, 'refs' => [ 'ArtifactSourceType$SourceIdType' => '<p>The type of ID.</p>', ], ], 'ArtifactSourceType' => [ 'base' => '<p>The ID and ID type of an artifact source.</p>', 'refs' => [ 'ArtifactSourceTypes$member' => NULL, ], ], 'ArtifactSourceTypes' => [ 'base' => NULL, 'refs' => [ 'ArtifactSource$SourceTypes' => '<p>A list of source types.</p>', ], ], 'ArtifactSummaries' => [ 'base' => NULL, 'refs' => [ 'ListArtifactsResponse$ArtifactSummaries' => '<p>A list of artifacts and their properties.</p>', ], ], 'ArtifactSummary' => [ 'base' => '<p>Lists a summary of the properties of an artifact. An artifact represents a URI addressable object or data. Some examples are a dataset and a model.</p>', 'refs' => [ 'ArtifactSummaries$member' => NULL, ], ], 'AssemblyType' => [ 'base' => NULL, 'refs' => [ 'TransformOutput$AssembleWith' => '<p>Defines how to assemble the results of the transform job as a single S3 object. Choose a format that is most convenient to you. To concatenate the results in binary format, specify <code>None</code>. To add a newline character at the end of every transformed record, specify <code>Line</code>.</p>', ], ], 'AssociateTrialComponentRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateTrialComponentResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociationEdgeType' => [ 'base' => NULL, 'refs' => [ 'AddAssociationRequest$AssociationType' => '<p>The type of association. The following are suggested uses for each type. Amazon SageMaker places no restrictions on their use.</p> <ul> <li> <p>ContributedTo - The source contributed to the destination or had a part in enabling the destination. For example, the training data contributed to the training job.</p> </li> <li> <p>AssociatedWith - The source is connected to the destination. For example, an approval workflow is associated with a model deployment.</p> </li> <li> <p>DerivedFrom - The destination is a modification of the source. For example, a digest output of a channel input for a processing job is derived from the original inputs.</p> </li> <li> <p>Produced - The source generated the destination. For example, a training job produced a model artifact.</p> </li> </ul>', 'AssociationSummary$AssociationType' => '<p>The type of the association.</p>', 'Edge$AssociationType' => '<p>The type of the Association(Edge) between the source and destination. For example <code>ContributedTo</code>, <code>Produced</code>, or <code>DerivedFrom</code>.</p>', 'ListAssociationsRequest$AssociationType' => '<p>A filter that returns only associations of the specified type.</p>', ], ], 'AssociationEntityArn' => [ 'base' => NULL, 'refs' => [ 'AddAssociationRequest$SourceArn' => '<p>The ARN of the source.</p>', 'AddAssociationRequest$DestinationArn' => '<p>The Amazon Resource Name (ARN) of the destination.</p>', 'AddAssociationResponse$SourceArn' => '<p>The ARN of the source.</p>', 'AddAssociationResponse$DestinationArn' => '<p>The Amazon Resource Name (ARN) of the destination.</p>', 'AssociationSummary$SourceArn' => '<p>The ARN of the source.</p>', 'AssociationSummary$DestinationArn' => '<p>The Amazon Resource Name (ARN) of the destination.</p>', 'DeleteAssociationRequest$SourceArn' => '<p>The ARN of the source.</p>', 'DeleteAssociationRequest$DestinationArn' => '<p>The Amazon Resource Name (ARN) of the destination.</p>', 'DeleteAssociationResponse$SourceArn' => '<p>The ARN of the source.</p>', 'DeleteAssociationResponse$DestinationArn' => '<p>The Amazon Resource Name (ARN) of the destination.</p>', 'Edge$SourceArn' => '<p>The Amazon Resource Name (ARN) of the source lineage entity of the directed edge.</p>', 'Edge$DestinationArn' => '<p>The Amazon Resource Name (ARN) of the destination lineage entity of the directed edge.</p>', 'ListAssociationsRequest$SourceArn' => '<p>A filter that returns only associations with the specified source ARN.</p>', 'ListAssociationsRequest$DestinationArn' => '<p>A filter that returns only associations with the specified destination Amazon Resource Name (ARN).</p>', 'QueryLineageStartArns$member' => NULL, 'Vertex$Arn' => '<p>The Amazon Resource Name (ARN) of the lineage entity resource.</p>', ], ], 'AssociationSummaries' => [ 'base' => NULL, 'refs' => [ 'ListAssociationsResponse$AssociationSummaries' => '<p>A list of associations and their properties.</p>', ], ], 'AssociationSummary' => [ 'base' => '<p>Lists a summary of the properties of an association. An association is an entity that links other lineage or experiment entities. An example would be an association between a training job and a model.</p>', 'refs' => [ 'AssociationSummaries$member' => NULL, ], ], 'AsyncInferenceClientConfig' => [ 'base' => '<p>Configures the behavior of the client used by SageMaker to interact with the model container during asynchronous inference.</p>', 'refs' => [ 'AsyncInferenceConfig$ClientConfig' => '<p>Configures the behavior of the client used by SageMaker to interact with the model container during asynchronous inference.</p>', ], ], 'AsyncInferenceConfig' => [ 'base' => '<p>Specifies configuration for how an endpoint performs asynchronous inference.</p>', 'refs' => [ 'CreateEndpointConfigInput$AsyncInferenceConfig' => '<p>Specifies configuration for how an endpoint performs asynchronous inference. This is a required field in order for your Endpoint to be invoked using <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_runtime_InvokeEndpointAsync.html">InvokeEndpointAsync</a>.</p>', 'DescribeEndpointConfigOutput$AsyncInferenceConfig' => '<p>Returns the description of an endpoint configuration created using the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpointConfig.html"> <code>CreateEndpointConfig</code> </a> API.</p>', 'DescribeEndpointOutput$AsyncInferenceConfig' => '<p>Returns the description of an endpoint configuration created using the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpointConfig.html"> <code>CreateEndpointConfig</code> </a> API.</p>', ], ], 'AsyncInferenceNotificationConfig' => [ 'base' => '<p>Specifies the configuration for notifications of inference results for asynchronous inference.</p>', 'refs' => [ 'AsyncInferenceOutputConfig$NotificationConfig' => '<p>Specifies the configuration for notifications of inference results for asynchronous inference.</p>', ], ], 'AsyncInferenceOutputConfig' => [ 'base' => '<p>Specifies the configuration for asynchronous inference invocation outputs.</p>', 'refs' => [ 'AsyncInferenceConfig$OutputConfig' => '<p>Specifies the configuration for asynchronous inference invocation outputs.</p>', ], ], 'AsyncNotificationTopicTypeList' => [ 'base' => NULL, 'refs' => [ 'AsyncInferenceNotificationConfig$IncludeInferenceResponseIn' => '<p>The Amazon SNS topics where you want the inference response to be included.</p> <note> <p>The inference response is included only if the response size is less than or equal to 128 KB.</p> </note>', ], ], 'AsyncNotificationTopicTypes' => [ 'base' => NULL, 'refs' => [ 'AsyncNotificationTopicTypeList$member' => NULL, ], ], 'AthenaCatalog' => [ 'base' => '<p>The name of the data catalog used in Athena query execution.</p>', 'refs' => [ 'AthenaDatasetDefinition$Catalog' => NULL, ], ], 'AthenaDatabase' => [ 'base' => '<p>The name of the database used in the Athena query execution.</p>', 'refs' => [ 'AthenaDatasetDefinition$Database' => NULL, ], ], 'AthenaDatasetDefinition' => [ 'base' => '<p>Configuration for Athena Dataset Definition input.</p>', 'refs' => [ 'DatasetDefinition$AthenaDatasetDefinition' => NULL, ], ], 'AthenaQueryString' => [ 'base' => '<p>The SQL query statements, to be executed.</p>', 'refs' => [ 'AthenaDatasetDefinition$QueryString' => NULL, ], ], 'AthenaResultCompressionType' => [ 'base' => '<p>The compression used for Athena query results.</p>', 'refs' => [ 'AthenaDatasetDefinition$OutputCompression' => NULL, ], ], 'AthenaResultFormat' => [ 'base' => '<p>The data storage format for Athena query results.</p>', 'refs' => [ 'AthenaDatasetDefinition$OutputFormat' => NULL, ], ], 'AthenaWorkGroup' => [ 'base' => '<p>The name of the workgroup in which the Athena query is being started.</p>', 'refs' => [ 'AthenaDatasetDefinition$WorkGroup' => NULL, ], ], 'AttributeName' => [ 'base' => NULL, 'refs' => [ 'AttributeNames$member' => NULL, ], ], 'AttributeNames' => [ 'base' => NULL, 'refs' => [ 'S3DataSource$AttributeNames' => '<p>A list of one or more attribute names to use that are found in a specified augmented manifest file.</p>', ], ], 'AuthMode' => [ 'base' => NULL, 'refs' => [ 'CreateDomainRequest$AuthMode' => '<p>The mode of authentication that members use to access the domain.</p>', 'DescribeDomainResponse$AuthMode' => '<p>The domain\'s authentication mode.</p>', ], ], 'AuthenticationRequestExtraParams' => [ 'base' => NULL, 'refs' => [ 'OidcConfig$AuthenticationRequestExtraParams' => '<p>A string to string map of identifiers specific to the custom identity provider (IdP) being used.</p>', 'OidcConfigForResponse$AuthenticationRequestExtraParams' => '<p>A string to string map of identifiers specific to the custom identity provider (IdP) being used.</p>', ], ], 'AuthenticationRequestExtraParamsKey' => [ 'base' => NULL, 'refs' => [ 'AuthenticationRequestExtraParams$key' => NULL, ], ], 'AuthenticationRequestExtraParamsValue' => [ 'base' => NULL, 'refs' => [ 'AuthenticationRequestExtraParams$value' => NULL, ], ], 'AutoGenerateEndpointName' => [ 'base' => NULL, 'refs' => [ 'ModelDeployConfig$AutoGenerateEndpointName' => '<p>Set to <code>True</code> to automatically generate an endpoint name for a one-click Autopilot model deployment; set to <code>False</code> otherwise. The default value is <code>False</code>.</p> <note> <p>If you set <code>AutoGenerateEndpointName</code> to <code>True</code>, do not specify the <code>EndpointName</code>; otherwise a 400 error is thrown.</p> </note>', ], ], 'AutoMLAlgorithm' => [ 'base' => NULL, 'refs' => [ 'AutoMLAlgorithms$member' => NULL, ], ], 'AutoMLAlgorithmConfig' => [ 'base' => '<p>The selection of algorithms trained on your dataset to generate the model candidates for an Autopilot job.</p>', 'refs' => [ 'AutoMLAlgorithmsConfig$member' => NULL, ], ], 'AutoMLAlgorithms' => [ 'base' => NULL, 'refs' => [ 'AutoMLAlgorithmConfig$AutoMLAlgorithms' => '<p>The selection of algorithms trained on your dataset to generate the model candidates for an Autopilot job.</p> <ul> <li> <p> <b>For the tabular problem type <code>TabularJobConfig</code>:</b> </p> <note> <p>Selected algorithms must belong to the list corresponding to the training mode set in <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLJobConfig.html#sagemaker-Type-AutoMLJobConfig-Mode">AutoMLJobConfig.Mode</a> (<code>ENSEMBLING</code> or <code>HYPERPARAMETER_TUNING</code>). Choose a minimum of 1 algorithm.</p> </note> <ul> <li> <p>In <code>ENSEMBLING</code> mode:</p> <ul> <li> <p>"catboost"</p> </li> <li> <p>"extra-trees"</p> </li> <li> <p>"fastai"</p> </li> <li> <p>"lightgbm"</p> </li> <li> <p>"linear-learner"</p> </li> <li> <p>"nn-torch"</p> </li> <li> <p>"randomforest"</p> </li> <li> <p>"xgboost"</p> </li> </ul> </li> <li> <p>In <code>HYPERPARAMETER_TUNING</code> mode:</p> <ul> <li> <p>"linear-learner"</p> </li> <li> <p>"mlp"</p> </li> <li> <p>"xgboost"</p> </li> </ul> </li> </ul> </li> <li> <p> <b>For the time-series forecasting problem type <code>TimeSeriesForecastingJobConfig</code>:</b> </p> <ul> <li> <p>Choose your algorithms from this list.</p> <ul> <li> <p>"cnn-qr"</p> </li> <li> <p>"deepar"</p> </li> <li> <p>"prophet"</p> </li> <li> <p>"arima"</p> </li> <li> <p>"npts"</p> </li> <li> <p>"ets"</p> </li> </ul> </li> </ul> </li> </ul>', ], ], 'AutoMLAlgorithmsConfig' => [ 'base' => NULL, 'refs' => [ 'AutoMLCandidateGenerationConfig$AlgorithmsConfig' => '<p>Stores the configuration information for the selection of algorithms trained on tabular data.</p> <p>The list of available algorithms to choose from depends on the training mode set in <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_TabularJobConfig.html"> <code>TabularJobConfig.Mode</code> </a>.</p> <ul> <li> <p> <code>AlgorithmsConfig</code> should not be set if the training mode is set on <code>AUTO</code>.</p> </li> <li> <p>When <code>AlgorithmsConfig</code> is provided, one <code>AutoMLAlgorithms</code> attribute must be set and one only.</p> <p>If the list of algorithms provided as values for <code>AutoMLAlgorithms</code> is empty, <code>CandidateGenerationConfig</code> uses the full set of algorithms for the given training mode.</p> </li> <li> <p>When <code>AlgorithmsConfig</code> is not provided, <code>CandidateGenerationConfig</code> uses the full set of algorithms for the given training mode.</p> </li> </ul> <p>For the list of all algorithms per problem type and training mode, see <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLAlgorithmConfig.html"> AutoMLAlgorithmConfig</a>.</p> <p>For more information on each algorithm, see the <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-model-support-validation.html#autopilot-algorithm-support">Algorithm support</a> section in Autopilot developer guide.</p>', 'CandidateGenerationConfig$AlgorithmsConfig' => '<p>Your Autopilot job trains a default set of algorithms on your dataset. For tabular and time-series data, you can customize the algorithm list by selecting a subset of algorithms for your problem type.</p> <p> <code>AlgorithmsConfig</code> stores the customized selection of algorithms to train on your data.</p> <ul> <li> <p> <b>For the tabular problem type <code>TabularJobConfig</code>,</b> the list of available algorithms to choose from depends on the training mode set in <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLJobConfig.html"> <code>AutoMLJobConfig.Mode</code> </a>.</p> <ul> <li> <p> <code>AlgorithmsConfig</code> should not be set when the training mode <code>AutoMLJobConfig.Mode</code> is set to <code>AUTO</code>.</p> </li> <li> <p>When <code>AlgorithmsConfig</code> is provided, one <code>AutoMLAlgorithms</code> attribute must be set and one only.</p> <p>If the list of algorithms provided as values for <code>AutoMLAlgorithms</code> is empty, <code>CandidateGenerationConfig</code> uses the full set of algorithms for the given training mode.</p> </li> <li> <p>When <code>AlgorithmsConfig</code> is not provided, <code>CandidateGenerationConfig</code> uses the full set of algorithms for the given training mode.</p> </li> </ul> <p>For the list of all algorithms per training mode, see <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLAlgorithmConfig.html"> AlgorithmConfig</a>.</p> <p>For more information on each algorithm, see the <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-model-support-validation.html#autopilot-algorithm-support">Algorithm support</a> section in the Autopilot developer guide.</p> </li> <li> <p> <b>For the time-series forecasting problem type <code>TimeSeriesForecastingJobConfig</code>,</b> choose your algorithms from the list provided in <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLAlgorithmConfig.html"> AlgorithmConfig</a>.</p> <p>For more information on each algorithm, see the <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/timeseries-forecasting-algorithms.html">Algorithms support for time-series forecasting</a> section in the Autopilot developer guide.</p> <ul> <li> <p>When <code>AlgorithmsConfig</code> is provided, one <code>AutoMLAlgorithms</code> attribute must be set and one only.</p> <p>If the list of algorithms provided as values for <code>AutoMLAlgorithms</code> is empty, <code>CandidateGenerationConfig</code> uses the full set of algorithms for time-series forecasting.</p> </li> <li> <p>When <code>AlgorithmsConfig</code> is not provided, <code>CandidateGenerationConfig</code> uses the full set of algorithms for time-series forecasting.</p> </li> </ul> </li> </ul>', ], ], 'AutoMLCandidate' => [ 'base' => '<p>Information about a candidate produced by an AutoML training job, including its status, steps, and other properties.</p>', 'refs' => [ 'AutoMLCandidates$member' => NULL, 'DescribeAutoMLJobResponse$BestCandidate' => '<p>The best model candidate selected by SageMaker Autopilot using both the best objective metric and lowest <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-metrics-validation.html">InferenceLatency</a> for an experiment.</p>', 'DescribeAutoMLJobV2Response$BestCandidate' => '<p>Information about the candidate produced by an AutoML training job V2, including its status, steps, and other properties.</p>', ], ], 'AutoMLCandidateGenerationConfig' => [ 'base' => '<p>Stores the configuration information for how a candidate is generated (optional).</p>', 'refs' => [ 'AutoMLJobConfig$CandidateGenerationConfig' => '<p>The configuration for generating a candidate for an AutoML job (optional). </p>', ], ], 'AutoMLCandidateStep' => [ 'base' => '<p>Information about the steps for a candidate and what step it is working on.</p>', 'refs' => [ 'CandidateSteps$member' => NULL, ], ], 'AutoMLCandidates' => [ 'base' => NULL, 'refs' => [ 'ListCandidatesForAutoMLJobResponse$Candidates' => '<p>Summaries about the <code>AutoMLCandidates</code>.</p>', ], ], 'AutoMLChannel' => [ 'base' => '<p>A channel is a named input source that training algorithms can consume. The validation dataset size is limited to less than 2 GB. The training dataset size must be less than 100 GB. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Channel.html"> Channel</a>.</p> <note> <p>A validation dataset must contain the same headers as the training dataset.</p> </note> <p/>', 'refs' => [ 'AutoMLInputDataConfig$member' => NULL, ], ], 'AutoMLChannelType' => [ 'base' => NULL, 'refs' => [ 'AutoMLChannel$ChannelType' => '<p>The channel type (optional) is an <code>enum</code> string. The default value is <code>training</code>. Channels for training and validation must share the same <code>ContentType</code> and <code>TargetAttributeName</code>. For information on specifying training and validation channel types, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-datasets-problem-types.html#autopilot-data-sources-training-or-validation">How to specify training and validation datasets</a>.</p>', 'AutoMLJobChannel$ChannelType' => '<p>The type of channel. Defines whether the data are used for training or validation. The default value is <code>training</code>. Channels for <code>training</code> and <code>validation</code> must share the same <code>ContentType</code> </p> <note> <p>The type of channel defaults to <code>training</code> for the time-series forecasting problem type.</p> </note>', ], ], 'AutoMLContainerDefinition' => [ 'base' => '<p>A list of container definitions that describe the different containers that make up an AutoML candidate. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ContainerDefinition.html"> ContainerDefinition</a>.</p>', 'refs' => [ 'AutoMLContainerDefinitions$member' => NULL, ], ], 'AutoMLContainerDefinitions' => [ 'base' => NULL, 'refs' => [ 'AutoMLCandidate$InferenceContainers' => '<p>Information about the recommended inference container definitions.</p>', 'AutoMLInferenceContainerDefinitions$value' => '<p>Information about the recommended inference container definitions.</p>', ], ], 'AutoMLDataSource' => [ 'base' => '<p>The data source for the Autopilot job.</p>', 'refs' => [ 'AutoMLChannel$DataSource' => '<p>The data source for an AutoML channel.</p>', 'AutoMLJobChannel$DataSource' => '<p>The data source for an AutoML channel (Required).</p>', ], ], 'AutoMLDataSplitConfig' => [ 'base' => '<p>This structure specifies how to split the data into train and validation datasets.</p> <p>The validation and training datasets must contain the same headers. For jobs created by calling <code>CreateAutoMLJob</code>, the validation dataset must be less than 2 GB in size.</p>', 'refs' => [ 'AutoMLJobConfig$DataSplitConfig' => '<p>The configuration for splitting the input training dataset.</p> <p>Type: AutoMLDataSplitConfig</p>', 'CreateAutoMLJobV2Request$DataSplitConfig' => '<p>This structure specifies how to split the data into train and validation datasets.</p> <p>The validation and training datasets must contain the same headers. For jobs created by calling <code>CreateAutoMLJob</code>, the validation dataset must be less than 2 GB in size.</p> <note> <p>This attribute must not be set for the time-series forecasting problem type, as Autopilot automatically splits the input dataset into training and validation sets.</p> </note>', 'DescribeAutoMLJobV2Response$DataSplitConfig' => '<p>Returns the configuration settings of how the data are split into train and validation datasets.</p>', ], ], 'AutoMLFailureReason' => [ 'base' => NULL, 'refs' => [ 'AutoMLCandidate$FailureReason' => '<p>The failure reason.</p>', 'AutoMLJobSummary$FailureReason' => '<p>The failure reason of an AutoML job.</p>', 'AutoMLPartialFailureReason$PartialFailureMessage' => '<p>The message containing the reason for a partial failure of an AutoML job.</p>', 'DescribeAutoMLJobResponse$FailureReason' => '<p>Returns the failure reason for an AutoML job, when applicable.</p>', 'DescribeAutoMLJobV2Response$FailureReason' => '<p>Returns the reason for the failure of the AutoML job V2, when applicable.</p>', ], ], 'AutoMLInferenceContainerDefinitions' => [ 'base' => '<p>The mapping of all supported processing unit (CPU, GPU, etc...) to inference container definitions for the candidate. This field is populated for the V2 API only (for example, for jobs created by calling <code>CreateAutoMLJobV2</code>).</p>', 'refs' => [ 'AutoMLCandidate$InferenceContainerDefinitions' => '<p>The mapping of all supported processing unit (CPU, GPU, etc...) to inference container definitions for the candidate. This field is populated for the AutoML jobs V2 (for example, for jobs created by calling <code>CreateAutoMLJobV2</code>) related to image or text classification problem types only.</p>', ], ], 'AutoMLInputDataConfig' => [ 'base' => NULL, 'refs' => [ 'CreateAutoMLJobRequest$InputDataConfig' => '<p>An array of channel objects that describes the input data and its location. Each channel is a named input source. Similar to <code>InputDataConfig</code> supported by <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTrainingJobDefinition.html">HyperParameterTrainingJobDefinition</a>. Format(s) supported: CSV, Parquet. A minimum of 500 rows is required for the training dataset. There is not a minimum number of rows required for the validation dataset.</p>', 'DescribeAutoMLJobResponse$InputDataConfig' => '<p>Returns the input data configuration for the AutoML job.</p>', ], ], 'AutoMLJobArn' => [ 'base' => NULL, 'refs' => [ 'AutoMLJobStepMetadata$Arn' => '<p>The Amazon Resource Name (ARN) of the AutoML job.</p>', 'AutoMLJobSummary$AutoMLJobArn' => '<p>The ARN of the AutoML job.</p>', 'CreateAutoMLJobResponse$AutoMLJobArn' => '<p>The unique ARN assigned to the AutoML job when it is created.</p>', 'CreateAutoMLJobV2Response$AutoMLJobArn' => '<p>The unique ARN assigned to the AutoMLJob when it is created.</p>', 'DescribeAutoMLJobResponse$AutoMLJobArn' => '<p>Returns the ARN of the AutoML job.</p>', 'DescribeAutoMLJobV2Response$AutoMLJobArn' => '<p>Returns the Amazon Resource Name (ARN) of the AutoML job V2.</p>', 'DescribeProcessingJobResponse$AutoMLJobArn' => '<p>The ARN of an AutoML job associated with this processing job.</p>', 'DescribeTrainingJobResponse$AutoMLJobArn' => '<p>The Amazon Resource Name (ARN) of an AutoML job.</p>', 'DescribeTransformJobResponse$AutoMLJobArn' => '<p>The Amazon Resource Name (ARN) of the AutoML transform job.</p>', 'ProcessingJob$AutoMLJobArn' => '<p>The Amazon Resource Name (ARN) of the AutoML job associated with this processing job.</p>', 'TrainingJob$AutoMLJobArn' => '<p>The Amazon Resource Name (ARN) of the job.</p>', 'TransformJob$AutoMLJobArn' => '<p>The Amazon Resource Name (ARN) of the AutoML job that created the transform job.</p>', ], ], 'AutoMLJobArtifacts' => [ 'base' => '<p>The artifacts that are generated during an AutoML job.</p>', 'refs' => [ 'DescribeAutoMLJobResponse$AutoMLJobArtifacts' => '<p>Returns information on the job\'s artifacts found in <code>AutoMLJobArtifacts</code>.</p>', 'DescribeAutoMLJobV2Response$AutoMLJobArtifacts' => NULL, ], ], 'AutoMLJobChannel' => [ 'base' => '<p>A channel is a named input source that training algorithms can consume. This channel is used for AutoML jobs V2 (jobs created by calling <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJobV2.html">CreateAutoMLJobV2</a>).</p>', 'refs' => [ 'AutoMLJobInputDataConfig$member' => NULL, ], ], 'AutoMLJobCompletionCriteria' => [ 'base' => '<p>How long a job is allowed to run, or how many candidates a job is allowed to generate.</p>', 'refs' => [ 'AutoMLJobConfig$CompletionCriteria' => '<p>How long an AutoML job is allowed to run, or how many candidates a job is allowed to generate.</p>', 'AutoMLResolvedAttributes$CompletionCriteria' => NULL, 'ImageClassificationJobConfig$CompletionCriteria' => '<p>How long a job is allowed to run, or how many candidates a job is allowed to generate.</p>', 'ResolvedAttributes$CompletionCriteria' => NULL, 'TabularJobConfig$CompletionCriteria' => NULL, 'TextClassificationJobConfig$CompletionCriteria' => '<p>How long a job is allowed to run, or how many candidates a job is allowed to generate.</p>', 'TextGenerationJobConfig$CompletionCriteria' => '<p>How long a fine-tuning job is allowed to run. For <code>TextGenerationJobConfig</code> problem types, the <code>MaxRuntimePerTrainingJobInSeconds</code> attribute of <code>AutoMLJobCompletionCriteria</code> defaults to 72h (259200s).</p>', 'TimeSeriesForecastingJobConfig$CompletionCriteria' => NULL, ], ], 'AutoMLJobConfig' => [ 'base' => '<p>A collection of settings used for an AutoML job.</p>', 'refs' => [ 'CreateAutoMLJobRequest$AutoMLJobConfig' => '<p>A collection of settings used to configure an AutoML job.</p>', 'DescribeAutoMLJobResponse$AutoMLJobConfig' => '<p>Returns the configuration for the AutoML job.</p>', ], ], 'AutoMLJobInputDataConfig' => [ 'base' => NULL, 'refs' => [ 'CreateAutoMLJobV2Request$AutoMLJobInputDataConfig' => '<p>An array of channel objects describing the input data and their location. Each channel is a named input source. Similar to the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJob.html#sagemaker-CreateAutoMLJob-request-InputDataConfig">InputDataConfig</a> attribute in the <code>CreateAutoMLJob</code> input parameters. The supported formats depend on the problem type:</p> <ul> <li> <p>For tabular problem types: <code>S3Prefix</code>, <code>ManifestFile</code>.</p> </li> <li> <p>For image classification: <code>S3Prefix</code>, <code>ManifestFile</code>, <code>AugmentedManifestFile</code>.</p> </li> <li> <p>For text classification: <code>S3Prefix</code>.</p> </li> <li> <p>For time-series forecasting: <code>S3Prefix</code>.</p> </li> <li> <p>For text generation (LLMs fine-tuning): <code>S3Prefix</code>.</p> </li> </ul>', 'DescribeAutoMLJobV2Response$AutoMLJobInputDataConfig' => '<p>Returns an array of channel objects describing the input data and their location.</p>', ], ], 'AutoMLJobName' => [ 'base' => NULL, 'refs' => [ 'AutoMLJobSummary$AutoMLJobName' => '<p>The name of the AutoML job you are requesting.</p>', 'CreateAutoMLJobRequest$AutoMLJobName' => '<p>Identifies an Autopilot job. The name must be unique to your account and is case insensitive.</p>', 'CreateAutoMLJobV2Request$AutoMLJobName' => '<p>Identifies an Autopilot job. The name must be unique to your account and is case insensitive.</p>', 'DescribeAutoMLJobRequest$AutoMLJobName' => '<p>Requests information about an AutoML job using its unique name.</p>', 'DescribeAutoMLJobResponse$AutoMLJobName' => '<p>Returns the name of the AutoML job.</p>', 'DescribeAutoMLJobV2Request$AutoMLJobName' => '<p>Requests information about an AutoML job V2 using its unique name.</p>', 'DescribeAutoMLJobV2Response$AutoMLJobName' => '<p>Returns the name of the AutoML job V2.</p>', 'ListCandidatesForAutoMLJobRequest$AutoMLJobName' => '<p>List the candidates created for the job by providing the job\'s name.</p>', 'StopAutoMLJobRequest$AutoMLJobName' => '<p>The name of the object you are requesting.</p>', ], ], 'AutoMLJobObjective' => [ 'base' => '<p>Specifies a metric to minimize or maximize as the objective of an AutoML job.</p>', 'refs' => [ 'AutoMLResolvedAttributes$AutoMLJobObjective' => NULL, 'CreateAutoMLJobRequest$AutoMLJobObjective' => '<p>Specifies a metric to minimize or maximize as the objective of a job. If not specified, the default objective metric depends on the problem type. See <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLJobObjective.html">AutoMLJobObjective</a> for the default values.</p>', 'CreateAutoMLJobV2Request$AutoMLJobObjective' => '<p>Specifies a metric to minimize or maximize as the objective of a job. If not specified, the default objective metric depends on the problem type. For the list of default values per problem type, see <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLJobObjective.html">AutoMLJobObjective</a>.</p> <note> <ul> <li> <p>For tabular problem types: You must either provide both the <code>AutoMLJobObjective</code> and indicate the type of supervised learning problem in <code>AutoMLProblemTypeConfig</code> (<code>TabularJobConfig.ProblemType</code>), or none at all.</p> </li> <li> <p>For text generation problem types (LLMs fine-tuning): Fine-tuning language models in Autopilot does not require setting the <code>AutoMLJobObjective</code> field. Autopilot fine-tunes LLMs without requiring multiple candidates to be trained and evaluated. Instead, using your dataset, Autopilot directly fine-tunes your target model to enhance a default objective metric, the cross-entropy loss. After fine-tuning a language model, you can evaluate the quality of its generated text using different metrics. For a list of the available metrics, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-llms-finetuning-metrics.html">Metrics for fine-tuning LLMs in Autopilot</a>.</p> </li> </ul> </note>', 'DescribeAutoMLJobResponse$AutoMLJobObjective' => '<p>Returns the job\'s objective.</p>', 'DescribeAutoMLJobV2Response$AutoMLJobObjective' => '<p>Returns the job\'s objective.</p>', 'ResolvedAttributes$AutoMLJobObjective' => NULL, ], ], 'AutoMLJobObjectiveType' => [ 'base' => NULL, 'refs' => [ 'FinalAutoMLJobObjectiveMetric$Type' => '<p>The type of metric with the best result.</p>', ], ], 'AutoMLJobSecondaryStatus' => [ 'base' => NULL, 'refs' => [ 'AutoMLJobSummary$AutoMLJobSecondaryStatus' => '<p>The secondary status of the AutoML job.</p>', 'DescribeAutoMLJobResponse$AutoMLJobSecondaryStatus' => '<p>Returns the secondary status of the AutoML job.</p>', 'DescribeAutoMLJobV2Response$AutoMLJobSecondaryStatus' => '<p>Returns the secondary status of the AutoML job V2.</p>', ], ], 'AutoMLJobStatus' => [ 'base' => NULL, 'refs' => [ 'AutoMLJobSummary$AutoMLJobStatus' => '<p>The status of the AutoML job.</p>', 'DescribeAutoMLJobResponse$AutoMLJobStatus' => '<p>Returns the status of the AutoML job.</p>', 'DescribeAutoMLJobV2Response$AutoMLJobStatus' => '<p>Returns the status of the AutoML job V2.</p>', 'ListAutoMLJobsRequest$StatusEquals' => '<p>Request a list of jobs, using a filter for status.</p>', ], ], 'AutoMLJobStepMetadata' => [ 'base' => '<p>Metadata for an AutoML job step.</p>', 'refs' => [ 'PipelineExecutionStepMetadata$AutoMLJob' => '<p>The Amazon Resource Name (ARN) of the AutoML job that was run by this step.</p>', ], ], 'AutoMLJobSummaries' => [ 'base' => NULL, 'refs' => [ 'ListAutoMLJobsResponse$AutoMLJobSummaries' => '<p>Returns a summary list of jobs.</p>', ], ], 'AutoMLJobSummary' => [ 'base' => '<p>Provides a summary about an AutoML job.</p>', 'refs' => [ 'AutoMLJobSummaries$member' => NULL, ], ], 'AutoMLMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListAutoMLJobsRequest$MaxResults' => '<p>Request a list of jobs up to a specified limit.</p>', ], ], 'AutoMLMaxResultsForTrials' => [ 'base' => NULL, 'refs' => [ 'ListCandidatesForAutoMLJobRequest$MaxResults' => '<p>List the job\'s candidates up to a specified limit.</p>', ], ], 'AutoMLMetricEnum' => [ 'base' => NULL, 'refs' => [ 'AutoMLJobObjective$MetricName' => '<p>The name of the objective metric used to measure the predictive quality of a machine learning system. During training, the model\'s parameters are updated iteratively to optimize its performance based on the feedback provided by the objective metric when evaluating the model on the validation dataset.</p> <p>The list of available metrics supported by Autopilot and the default metric applied when you do not specify a metric name explicitly depend on the problem type.</p> <ul> <li> <p>For tabular problem types:</p> <ul> <li> <p>List of available metrics: </p> <ul> <li> <p> Regression: <code>MAE</code>, <code>MSE</code>, <code>R2</code>, <code>RMSE</code> </p> </li> <li> <p> Binary classification: <code>Accuracy</code>, <code>AUC</code>, <code>BalancedAccuracy</code>, <code>F1</code>, <code>Precision</code>, <code>Recall</code> </p> </li> <li> <p> Multiclass classification: <code>Accuracy</code>, <code>BalancedAccuracy</code>, <code>F1macro</code>, <code>PrecisionMacro</code>, <code>RecallMacro</code> </p> </li> </ul> <p>For a description of each metric, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-metrics-validation.html#autopilot-metrics">Autopilot metrics for classification and regression</a>.</p> </li> <li> <p>Default objective metrics:</p> <ul> <li> <p>Regression: <code>MSE</code>.</p> </li> <li> <p>Binary classification: <code>F1</code>.</p> </li> <li> <p>Multiclass classification: <code>Accuracy</code>.</p> </li> </ul> </li> </ul> </li> <li> <p>For image or text classification problem types:</p> <ul> <li> <p>List of available metrics: <code>Accuracy</code> </p> <p>For a description of each metric, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/text-classification-data-format-and-metric.html">Autopilot metrics for text and image classification</a>.</p> </li> <li> <p>Default objective metrics: <code>Accuracy</code> </p> </li> </ul> </li> <li> <p>For time-series forecasting problem types:</p> <ul> <li> <p>List of available metrics: <code>RMSE</code>, <code>wQL</code>, <code>Average wQL</code>, <code>MASE</code>, <code>MAPE</code>, <code>WAPE</code> </p> <p>For a description of each metric, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/timeseries-objective-metric.html">Autopilot metrics for time-series forecasting</a>.</p> </li> <li> <p>Default objective metrics: <code>AverageWeightedQuantileLoss</code> </p> </li> </ul> </li> <li> <p>For text generation problem types (LLMs fine-tuning): Fine-tuning language models in Autopilot does not require setting the <code>AutoMLJobObjective</code> field. Autopilot fine-tunes LLMs without requiring multiple candidates to be trained and evaluated. Instead, using your dataset, Autopilot directly fine-tunes your target model to enhance a default objective metric, the cross-entropy loss. After fine-tuning a language model, you can evaluate the quality of its generated text using different metrics. For a list of the available metrics, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-llms-finetuning-metrics.html">Metrics for fine-tuning LLMs in Autopilot</a>.</p> </li> </ul>', 'FinalAutoMLJobObjectiveMetric$MetricName' => '<p>The name of the metric with the best result. For a description of the possible objective metrics, see <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLJobObjective.html">AutoMLJobObjective$MetricName</a>.</p>', 'FinalAutoMLJobObjectiveMetric$StandardMetricName' => '<p>The name of the standard metric. For a description of the standard metrics, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-metrics-validation.html#autopilot-metrics">Autopilot candidate metrics</a>.</p>', 'MetricDatum$MetricName' => '<p>The name of the metric.</p>', ], ], 'AutoMLMetricExtendedEnum' => [ 'base' => NULL, 'refs' => [ 'MetricDatum$StandardMetricName' => '<p>The name of the standard metric. </p> <note> <p>For definitions of the standard metrics, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-model-support-validation.html#autopilot-metrics"> <code>Autopilot candidate metrics</code> </a>.</p> </note>', ], ], 'AutoMLMode' => [ 'base' => NULL, 'refs' => [ 'AutoMLJobConfig$Mode' => '<p>The method that Autopilot uses to train the data. You can either specify the mode manually or let Autopilot choose for you based on the dataset size by selecting <code>AUTO</code>. In <code>AUTO</code> mode, Autopilot chooses <code>ENSEMBLING</code> for datasets smaller than 100 MB, and <code>HYPERPARAMETER_TUNING</code> for larger ones.</p> <p>The <code>ENSEMBLING</code> mode uses a multi-stack ensemble model to predict classification and regression tasks directly from your dataset. This machine learning mode combines several base models to produce an optimal predictive model. It then uses a stacking ensemble method to combine predictions from contributing members. A multi-stack ensemble model can provide better performance over a single model by combining the predictive capabilities of multiple models. See <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-model-support-validation.html#autopilot-algorithm-support">Autopilot algorithm support</a> for a list of algorithms supported by <code>ENSEMBLING</code> mode.</p> <p>The <code>HYPERPARAMETER_TUNING</code> (HPO) mode uses the best hyperparameters to train the best version of a model. HPO automatically selects an algorithm for the type of problem you want to solve. Then HPO finds the best hyperparameters according to your objective metric. See <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-model-support-validation.html#autopilot-algorithm-support">Autopilot algorithm support</a> for a list of algorithms supported by <code>HYPERPARAMETER_TUNING</code> mode.</p>', 'TabularJobConfig$Mode' => '<p>The method that Autopilot uses to train the data. You can either specify the mode manually or let Autopilot choose for you based on the dataset size by selecting <code>AUTO</code>. In <code>AUTO</code> mode, Autopilot chooses <code>ENSEMBLING</code> for datasets smaller than 100 MB, and <code>HYPERPARAMETER_TUNING</code> for larger ones.</p> <p>The <code>ENSEMBLING</code> mode uses a multi-stack ensemble model to predict classification and regression tasks directly from your dataset. This machine learning mode combines several base models to produce an optimal predictive model. It then uses a stacking ensemble method to combine predictions from contributing members. A multi-stack ensemble model can provide better performance over a single model by combining the predictive capabilities of multiple models. See <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-model-support-validation.html#autopilot-algorithm-support">Autopilot algorithm support</a> for a list of algorithms supported by <code>ENSEMBLING</code> mode.</p> <p>The <code>HYPERPARAMETER_TUNING</code> (HPO) mode uses the best hyperparameters to train the best version of a model. HPO automatically selects an algorithm for the type of problem you want to solve. Then HPO finds the best hyperparameters according to your objective metric. See <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-model-support-validation.html#autopilot-algorithm-support">Autopilot algorithm support</a> for a list of algorithms supported by <code>HYPERPARAMETER_TUNING</code> mode.</p>', ], ], 'AutoMLNameContains' => [ 'base' => NULL, 'refs' => [ 'ListAutoMLJobsRequest$NameContains' => '<p>Request a list of jobs, using a search filter for name.</p>', ], ], 'AutoMLOutputDataConfig' => [ 'base' => '<p>The output data configuration.</p>', 'refs' => [ 'CreateAutoMLJobRequest$OutputDataConfig' => '<p>Provides information about encryption and the Amazon S3 output path needed to store artifacts from an AutoML job. Format(s) supported: CSV.</p>', 'CreateAutoMLJobV2Request$OutputDataConfig' => '<p>Provides information about encryption and the Amazon S3 output path needed to store artifacts from an AutoML job.</p>', 'DescribeAutoMLJobResponse$OutputDataConfig' => '<p>Returns the job\'s output data config.</p>', 'DescribeAutoMLJobV2Response$OutputDataConfig' => '<p>Returns the job\'s output data config.</p>', ], ], 'AutoMLPartialFailureReason' => [ 'base' => '<p>The reason for a partial failure of an AutoML job.</p>', 'refs' => [ 'AutoMLPartialFailureReasons$member' => NULL, ], ], 'AutoMLPartialFailureReasons' => [ 'base' => NULL, 'refs' => [ 'AutoMLJobSummary$PartialFailureReasons' => '<p>The list of reasons for partial failures within an AutoML job.</p>', 'DescribeAutoMLJobResponse$PartialFailureReasons' => '<p>Returns a list of reasons for partial failures within an AutoML job.</p>', 'DescribeAutoMLJobV2Response$PartialFailureReasons' => '<p>Returns a list of reasons for partial failures within an AutoML job V2.</p>', ], ], 'AutoMLProblemTypeConfig' => [ 'base' => '<p>A collection of settings specific to the problem type used to configure an AutoML job V2. There must be one and only one config of the following type.</p>', 'refs' => [ 'CreateAutoMLJobV2Request$AutoMLProblemTypeConfig' => '<p>Defines the configuration settings of one of the supported problem types.</p>', 'DescribeAutoMLJobV2Response$AutoMLProblemTypeConfig' => '<p>Returns the configuration settings of the problem type set for the AutoML job V2.</p>', ], ], 'AutoMLProblemTypeConfigName' => [ 'base' => NULL, 'refs' => [ 'DescribeAutoMLJobV2Response$AutoMLProblemTypeConfigName' => '<p>Returns the name of the problem type configuration set for the AutoML job V2.</p>', ], ], 'AutoMLProblemTypeResolvedAttributes' => [ 'base' => '<p>Stores resolved attributes specific to the problem type of an AutoML job V2.</p>', 'refs' => [ 'AutoMLResolvedAttributes$AutoMLProblemTypeResolvedAttributes' => '<p>Defines the resolved attributes specific to a problem type.</p>', ], ], 'AutoMLProcessingUnit' => [ 'base' => NULL, 'refs' => [ 'AutoMLInferenceContainerDefinitions$key' => '<p>Processing unit for an inference container. Currently Autopilot only supports <code>CPU</code> or <code>GPU</code>.</p>', ], ], 'AutoMLResolvedAttributes' => [ 'base' => '<p>The resolved attributes used to configure an AutoML job V2.</p>', 'refs' => [ 'DescribeAutoMLJobV2Response$ResolvedAttributes' => '<p>Returns the resolved attributes used by the AutoML job V2.</p>', ], ], 'AutoMLS3DataSource' => [ 'base' => '<p>Describes the Amazon S3 data source.</p>', 'refs' => [ 'AutoMLDataSource$S3DataSource' => '<p>The Amazon S3 location of the input data.</p>', ], ], 'AutoMLS3DataType' => [ 'base' => NULL, 'refs' => [ 'AutoMLS3DataSource$S3DataType' => '<p>The data type. </p> <ul> <li> <p>If you choose <code>S3Prefix</code>, <code>S3Uri</code> identifies a key name prefix. SageMaker uses all objects that match the specified key name prefix for model training.</p> <p>The <code>S3Prefix</code> should have the following format:</p> <p> <code>s3://DOC-EXAMPLE-BUCKET/DOC-EXAMPLE-FOLDER-OR-FILE</code> </p> </li> <li> <p>If you choose <code>ManifestFile</code>, <code>S3Uri</code> identifies an object that is a manifest file containing a list of object keys that you want SageMaker to use for model training.</p> <p>A <code>ManifestFile</code> should have the format shown below:</p> <p> <code>[ {"prefix": "s3://DOC-EXAMPLE-BUCKET/DOC-EXAMPLE-FOLDER/DOC-EXAMPLE-PREFIX/"}, </code> </p> <p> <code>"DOC-EXAMPLE-RELATIVE-PATH/DOC-EXAMPLE-FOLDER/DATA-1",</code> </p> <p> <code>"DOC-EXAMPLE-RELATIVE-PATH/DOC-EXAMPLE-FOLDER/DATA-2",</code> </p> <p> <code>... "DOC-EXAMPLE-RELATIVE-PATH/DOC-EXAMPLE-FOLDER/DATA-N" ]</code> </p> </li> <li> <p>If you choose <code>AugmentedManifestFile</code>, <code>S3Uri</code> identifies an object that is an augmented manifest file in JSON lines format. This file contains the data you want to use for model training. <code>AugmentedManifestFile</code> is available for V2 API jobs only (for example, for jobs created by calling <code>CreateAutoMLJobV2</code>).</p> <p>Here is a minimal, single-record example of an <code>AugmentedManifestFile</code>:</p> <p> <code>{"source-ref": "s3://DOC-EXAMPLE-BUCKET/DOC-EXAMPLE-FOLDER/cats/cat.jpg",</code> </p> <p> <code>"label-metadata": {"class-name": "cat"</code> }</p> <p>For more information on <code>AugmentedManifestFile</code>, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/augmented-manifest.html">Provide Dataset Metadata to Training Jobs with an Augmented Manifest File</a>.</p> </li> </ul>', ], ], 'AutoMLSecurityConfig' => [ 'base' => '<p>Security options.</p>', 'refs' => [ 'AutoMLJobConfig$SecurityConfig' => '<p>The security configuration for traffic encryption or Amazon VPC settings.</p>', 'CreateAutoMLJobV2Request$SecurityConfig' => '<p>The security configuration for traffic encryption or Amazon VPC settings.</p>', 'DescribeAutoMLJobV2Response$SecurityConfig' => '<p>Returns the security configuration for traffic encryption or Amazon VPC settings.</p>', ], ], 'AutoMLSortBy' => [ 'base' => NULL, 'refs' => [ 'ListAutoMLJobsRequest$SortBy' => '<p>The parameter by which to sort the results. The default is <code>Name</code>.</p>', ], ], 'AutoMLSortOrder' => [ 'base' => NULL, 'refs' => [ 'ListAutoMLJobsRequest$SortOrder' => '<p>The sort order for the results. The default is <code>Descending</code>.</p>', 'ListCandidatesForAutoMLJobRequest$SortOrder' => '<p>The sort order for the results. The default is <code>Ascending</code>.</p>', ], ], 'AutoParameter' => [ 'base' => '<p>The name and an example value of the hyperparameter that you want to use in Autotune. If Automatic model tuning (AMT) determines that your hyperparameter is eligible for Autotune, an optimal hyperparameter range is selected for you.</p>', 'refs' => [ 'AutoParameters$member' => NULL, ], ], 'AutoParameters' => [ 'base' => NULL, 'refs' => [ 'ParameterRanges$AutoParameters' => '<p>A list containing hyperparameter names and example values to be used by Autotune to determine optimal ranges for your tuning job.</p>', ], ], 'AutoRollbackConfig' => [ 'base' => '<p>Automatic rollback configuration for handling endpoint deployment failures and recovery.</p>', 'refs' => [ 'DeploymentConfig$AutoRollbackConfiguration' => '<p>Automatic rollback configuration for handling endpoint deployment failures and recovery.</p>', ], ], 'Autotune' => [ 'base' => '<p>A flag to indicate if you want to use Autotune to automatically find optimal values for the following fields:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTuningJobConfig.html#sagemaker-Type-HyperParameterTuningJobConfig-ParameterRanges">ParameterRanges</a>: The names and ranges of parameters that a hyperparameter tuning job can optimize.</p> </li> <li> <p> <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ResourceLimits.html">ResourceLimits</a>: The maximum resources that can be used for a training job. These resources include the maximum number of training jobs, the maximum runtime of a tuning job, and the maximum number of training jobs to run at the same time.</p> </li> <li> <p> <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTuningJobConfig.html#sagemaker-Type-HyperParameterTuningJobConfig-TrainingJobEarlyStoppingType">TrainingJobEarlyStoppingType</a>: A flag that specifies whether or not to use early stopping for training jobs launched by a hyperparameter tuning job.</p> </li> <li> <p> <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTrainingJobDefinition.html#sagemaker-Type-HyperParameterTrainingJobDefinition-RetryStrategy">RetryStrategy</a>: The number of times to retry a training job.</p> </li> <li> <p> <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTuningJobConfig.html">Strategy</a>: Specifies how hyperparameter tuning chooses the combinations of hyperparameter values to use for the training jobs that it launches.</p> </li> <li> <p> <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ConvergenceDetected.html">ConvergenceDetected</a>: A flag to indicate that Automatic model tuning (AMT) has detected model convergence.</p> </li> </ul>', 'refs' => [ 'CreateHyperParameterTuningJobRequest$Autotune' => '<p>Configures SageMaker Automatic model tuning (AMT) to automatically find optimal parameters for the following fields:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTuningJobConfig.html#sagemaker-Type-HyperParameterTuningJobConfig-ParameterRanges">ParameterRanges</a>: The names and ranges of parameters that a hyperparameter tuning job can optimize.</p> </li> <li> <p> <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ResourceLimits.html">ResourceLimits</a>: The maximum resources that can be used for a training job. These resources include the maximum number of training jobs, the maximum runtime of a tuning job, and the maximum number of training jobs to run at the same time.</p> </li> <li> <p> <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTuningJobConfig.html#sagemaker-Type-HyperParameterTuningJobConfig-TrainingJobEarlyStoppingType">TrainingJobEarlyStoppingType</a>: A flag that specifies whether or not to use early stopping for training jobs launched by a hyperparameter tuning job.</p> </li> <li> <p> <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTrainingJobDefinition.html#sagemaker-Type-HyperParameterTrainingJobDefinition-RetryStrategy">RetryStrategy</a>: The number of times to retry a training job.</p> </li> <li> <p> <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTuningJobConfig.html">Strategy</a>: Specifies how hyperparameter tuning chooses the combinations of hyperparameter values to use for the training jobs that it launches.</p> </li> <li> <p> <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ConvergenceDetected.html">ConvergenceDetected</a>: A flag to indicate that Automatic model tuning (AMT) has detected model convergence.</p> </li> </ul>', 'DescribeHyperParameterTuningJobResponse$Autotune' => '<p>A flag to indicate if autotune is enabled for the hyperparameter tuning job.</p>', ], ], 'AutotuneMode' => [ 'base' => NULL, 'refs' => [ 'Autotune$Mode' => '<p>Set <code>Mode</code> to <code>Enabled</code> if you want to use Autotune.</p>', ], ], 'AwsManagedHumanLoopRequestSource' => [ 'base' => NULL, 'refs' => [ 'HumanLoopRequestSource$AwsManagedHumanLoopRequestSource' => '<p>Specifies whether Amazon Rekognition or Amazon Textract are used as the integration source. The default field settings and JSON parsing rules are different based on the integration source. Valid values:</p>', ], ], 'BacktestResultsLocation' => [ 'base' => NULL, 'refs' => [ 'CandidateArtifactLocations$BacktestResults' => '<p>The Amazon S3 prefix to the accuracy metrics and the inference results observed over the testing window. Available only for the time-series forecasting problem type.</p>', ], ], 'BaseModelName' => [ 'base' => NULL, 'refs' => [ 'TextGenerationJobConfig$BaseModelName' => '<p>The name of the base model to fine-tune. Autopilot supports fine-tuning a variety of large language models. For information on the list of supported models, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-llms-finetuning-models.html#autopilot-llms-finetuning-supported-llms">Text generation models supporting fine-tuning in Autopilot</a>. If no <code>BaseModelName</code> is provided, the default model used is <b>Falcon7BInstruct</b>. </p>', 'TextGenerationResolvedAttributes$BaseModelName' => '<p>The name of the base model to fine-tune.</p>', ], ], 'BatchDataCaptureConfig' => [ 'base' => '<p>Configuration to control how SageMaker captures inference data for batch transform jobs.</p>', 'refs' => [ 'CreateTransformJobRequest$DataCaptureConfig' => '<p>Configuration to control how SageMaker captures inference data.</p>', 'DescribeTransformJobResponse$DataCaptureConfig' => '<p>Configuration to control how SageMaker captures inference data.</p>', 'TransformJob$DataCaptureConfig' => NULL, ], ], 'BatchDescribeModelPackageError' => [ 'base' => '<p>The error code and error description associated with the resource.</p>', 'refs' => [ 'BatchDescribeModelPackageErrorMap$value' => NULL, ], ], 'BatchDescribeModelPackageErrorMap' => [ 'base' => NULL, 'refs' => [ 'BatchDescribeModelPackageOutput$BatchDescribeModelPackageErrorMap' => '<p>A map of the resource and BatchDescribeModelPackageError objects reporting the error associated with describing the model package.</p>', ], ], 'BatchDescribeModelPackageInput' => [ 'base' => NULL, 'refs' => [], ], 'BatchDescribeModelPackageOutput' => [ 'base' => NULL, 'refs' => [], ], 'BatchDescribeModelPackageSummary' => [ 'base' => '<p>Provides summary information about the model package.</p>', 'refs' => [ 'ModelPackageSummaries$value' => NULL, ], ], 'BatchStrategy' => [ 'base' => NULL, 'refs' => [ 'CreateTransformJobRequest$BatchStrategy' => '<p>Specifies the number of records to include in a mini-batch for an HTTP inference request. A <i>record</i> <i/> is a single unit of input data that inference can be made on. For example, a single line in a CSV file is a record. </p> <p>To enable the batch strategy, you must set the <code>SplitType</code> property to <code>Line</code>, <code>RecordIO</code>, or <code>TFRecord</code>.</p> <p>To use only one record when making an HTTP invocation request to a container, set <code>BatchStrategy</code> to <code>SingleRecord</code> and <code>SplitType</code> to <code>Line</code>.</p> <p>To fit as many records in a mini-batch as can fit within the <code>MaxPayloadInMB</code> limit, set <code>BatchStrategy</code> to <code>MultiRecord</code> and <code>SplitType</code> to <code>Line</code>.</p>', 'DescribeTransformJobResponse$BatchStrategy' => '<p>Specifies the number of records to include in a mini-batch for an HTTP inference request. A <i>record</i> <i/> is a single unit of input data that inference can be made on. For example, a single line in a CSV file is a record. </p> <p>To enable the batch strategy, you must set <code>SplitType</code> to <code>Line</code>, <code>RecordIO</code>, or <code>TFRecord</code>.</p>', 'TransformJob$BatchStrategy' => '<p>Specifies the number of records to include in a mini-batch for an HTTP inference request. A record is a single unit of input data that inference can be made on. For example, a single line in a CSV file is a record.</p>', 'TransformJobDefinition$BatchStrategy' => '<p>A string that determines the number of records included in a single mini-batch.</p> <p> <code>SingleRecord</code> means only one record is used per mini-batch. <code>MultiRecord</code> means a mini-batch is set to contain as many records that can fit within the <code>MaxPayloadInMB</code> limit.</p>', ], ], 'BatchTransformInput' => [ 'base' => '<p>Input object for the batch transform job.</p>', 'refs' => [ 'DataQualityJobInput$BatchTransformInput' => '<p>Input object for the batch transform job.</p>', 'ModelBiasJobInput$BatchTransformInput' => '<p>Input object for the batch transform job.</p>', 'ModelDashboardMonitoringSchedule$BatchTransformInput' => NULL, 'ModelExplainabilityJobInput$BatchTransformInput' => '<p>Input object for the batch transform job.</p>', 'ModelQualityJobInput$BatchTransformInput' => '<p>Input object for the batch transform job.</p>', 'MonitoringInput$BatchTransformInput' => '<p>Input object for the batch transform job.</p>', ], ], 'BestObjectiveNotImproving' => [ 'base' => '<p>A structure that keeps track of which training jobs launched by your hyperparameter tuning job are not improving model performance as evaluated against an objective function.</p>', 'refs' => [ 'TuningJobCompletionCriteria$BestObjectiveNotImproving' => '<p>A flag to stop your hyperparameter tuning job if model performance fails to improve as evaluated against an objective function.</p>', ], ], 'Bias' => [ 'base' => '<p>Contains bias metrics for a model.</p>', 'refs' => [ 'ModelMetrics$Bias' => '<p>Metrics that measure bias in a model.</p>', ], ], 'BillableTimeInSeconds' => [ 'base' => NULL, 'refs' => [ 'DescribeTrainingJobResponse$BillableTimeInSeconds' => '<p>The billable time in seconds. Billable time refers to the absolute wall-clock time.</p> <p>Multiply <code>BillableTimeInSeconds</code> by the number of instances (<code>InstanceCount</code>) in your training cluster to get the total compute time SageMaker bills you if you run distributed training. The formula is as follows: <code>BillableTimeInSeconds * InstanceCount</code> .</p> <p>You can calculate the savings from using managed spot training using the formula <code>(1 - BillableTimeInSeconds / TrainingTimeInSeconds) * 100</code>. For example, if <code>BillableTimeInSeconds</code> is 100 and <code>TrainingTimeInSeconds</code> is 500, the savings is 80%.</p>', 'TrainingJob$BillableTimeInSeconds' => '<p>The billable time in seconds.</p>', ], ], 'BlockedReason' => [ 'base' => NULL, 'refs' => [ 'OfflineStoreStatus$BlockedReason' => '<p>The justification for why the OfflineStoreStatus is Blocked (if applicable).</p>', ], ], 'BlueGreenUpdatePolicy' => [ 'base' => '<p>Update policy for a blue/green deployment. If this update policy is specified, SageMaker creates a new fleet during the deployment while maintaining the old fleet. SageMaker flips traffic to the new fleet according to the specified traffic routing configuration. Only one update policy should be used in the deployment configuration. If no update policy is specified, SageMaker uses a blue/green deployment strategy with all at once traffic shifting by default.</p>', 'refs' => [ 'DeploymentConfig$BlueGreenUpdatePolicy' => '<p>Update policy for a blue/green deployment. If this update policy is specified, SageMaker creates a new fleet during the deployment while maintaining the old fleet. SageMaker flips traffic to the new fleet according to the specified traffic routing configuration. Only one update policy should be used in the deployment configuration. If no update policy is specified, SageMaker uses a blue/green deployment strategy with all at once traffic shifting by default.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'AlgorithmSpecification$EnableSageMakerMetricsTimeSeries' => '<p>To generate and save time-series metrics during training, set to <code>true</code>. The default is <code>false</code> and time-series metrics aren\'t generated except in the following cases:</p> <ul> <li> <p>You use one of the SageMaker built-in algorithms</p> </li> <li> <p>You use one of the following <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/pre-built-containers-frameworks-deep-learning.html">Prebuilt SageMaker Docker Images</a>:</p> <ul> <li> <p>Tensorflow (version &gt;= 1.15)</p> </li> <li> <p>MXNet (version &gt;= 1.6)</p> </li> <li> <p>PyTorch (version &gt;= 1.3)</p> </li> </ul> </li> <li> <p>You specify at least one <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_MetricDefinition.html">MetricDefinition</a> </p> </li> </ul>', 'AutoMLSecurityConfig$EnableInterContainerTrafficEncryption' => '<p>Whether to use traffic encryption between the container layers.</p>', 'BatchDataCaptureConfig$GenerateInferenceId' => '<p>Flag that indicates whether to append inference id to the output.</p>', 'ChannelSpecification$IsRequired' => '<p>Indicates whether the channel is required by the algorithm.</p>', 'ClarifyCheckStepMetadata$SkipCheck' => '<p>This flag indicates if the drift check against the previous baseline will be skipped or not. If it is set to <code>False</code>, the previous baseline of the configured check type must be available.</p>', 'ClarifyCheckStepMetadata$RegisterNewBaseline' => '<p>This flag indicates if a newly calculated baseline can be accessed through step properties <code>BaselineUsedForDriftCheckConstraints</code> and <code>BaselineUsedForDriftCheckStatistics</code>. If it is set to <code>False</code>, the previous baseline of the configured check type must also be available. These can be accessed through the <code>BaselineUsedForDriftCheckConstraints</code> property. </p>', 'CreateEndpointConfigInput$EnableNetworkIsolation' => '<p>Sets whether all model containers deployed to the endpoint are isolated. If they are, no inbound or outbound network calls can be made to or from the model containers.</p>', 'CreateMlflowTrackingServerRequest$AutomaticModelRegistration' => '<p>Whether to enable or disable automatic registration of new MLflow models to the SageMaker Model Registry. To enable automatic model registration, set this value to <code>True</code>. To disable automatic model registration, set this value to <code>False</code>. If not specified, <code>AutomaticModelRegistration</code> defaults to <code>False</code>.</p>', 'CreateModelInput$EnableNetworkIsolation' => '<p>Isolates the model container. No inbound or outbound network calls can be made to or from the model container.</p>', 'CreateTrainingJobRequest$EnableNetworkIsolation' => '<p>Isolates the training container. No inbound or outbound network calls can be made, except for calls between peers within a training cluster for distributed training. If you enable network isolation for training jobs that are configured to use a VPC, SageMaker downloads and uploads customer data and model artifacts through the specified VPC, but the training container does not have network access.</p>', 'CreateTrainingJobRequest$EnableInterContainerTrafficEncryption' => '<p>To encrypt all communications between ML compute instances in distributed training, choose <code>True</code>. Encryption provides greater security for distributed training, but training might take longer. How long it takes depends on the amount of communication between compute instances, especially if you use a deep learning algorithm in distributed training. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-encrypt.html">Protect Communications Between ML Compute Instances in a Distributed Training Job</a>.</p>', 'CreateTrainingJobRequest$EnableManagedSpotTraining' => '<p>To train models using managed spot training, choose <code>True</code>. Managed spot training provides a fully managed and scalable infrastructure for training machine learning models. this option is useful when training jobs can be interrupted and when there is flexibility when the training job is run. </p> <p>The complete and intermediate results of jobs are stored in an Amazon S3 bucket, and can be used as a starting point to train models incrementally. Amazon SageMaker provides metrics and logs in CloudWatch. They can be used to see when managed spot training jobs are running, interrupted, resumed, or completed. </p>', 'DescribeEndpointConfigOutput$EnableNetworkIsolation' => '<p>Indicates whether all model containers deployed to the endpoint are isolated. If they are, no inbound or outbound network calls can be made to or from the model containers.</p>', 'DescribeMlflowTrackingServerResponse$AutomaticModelRegistration' => '<p>Whether automatic registration of new MLflow models to the SageMaker Model Registry is enabled.</p>', 'DescribeModelOutput$EnableNetworkIsolation' => '<p>If <code>True</code>, no inbound or outbound network calls can be made to or from the model container.</p>', 'DescribeTrainingJobResponse$EnableNetworkIsolation' => '<p>If you want to allow inbound or outbound network calls, except for calls between peers within a training cluster for distributed training, choose <code>True</code>. If you enable network isolation for training jobs that are configured to use a VPC, SageMaker downloads and uploads customer data and model artifacts through the specified VPC, but the training container does not have network access.</p>', 'DescribeTrainingJobResponse$EnableInterContainerTrafficEncryption' => '<p>To encrypt all communications between ML compute instances in distributed training, choose <code>True</code>. Encryption provides greater security for distributed training, but training might take longer. How long it takes depends on the amount of communication between compute instances, especially if you use a deep learning algorithms in distributed training.</p>', 'DescribeTrainingJobResponse$EnableManagedSpotTraining' => '<p>A Boolean indicating whether managed spot training is enabled (<code>True</code>) or not (<code>False</code>).</p>', 'HyperParameterSpecification$IsTunable' => '<p>Indicates whether this hyperparameter is tunable in a hyperparameter tuning job.</p>', 'HyperParameterSpecification$IsRequired' => '<p>Indicates whether this hyperparameter is required.</p>', 'HyperParameterTrainingJobDefinition$EnableNetworkIsolation' => '<p>Isolates the training container. No inbound or outbound network calls can be made, except for calls between peers within a training cluster for distributed training. If network isolation is used for training jobs that are configured to use a VPC, SageMaker downloads and uploads customer data and model artifacts through the specified VPC, but the training container does not have network access.</p>', 'HyperParameterTrainingJobDefinition$EnableInterContainerTrafficEncryption' => '<p>To encrypt all communications between ML compute instances in distributed training, choose <code>True</code>. Encryption provides greater security for distributed training, but training might take longer. How long it takes depends on the amount of communication between compute instances, especially if you use a deep learning algorithm in distributed training.</p>', 'HyperParameterTrainingJobDefinition$EnableManagedSpotTraining' => '<p>A Boolean indicating whether managed spot training is enabled (<code>True</code>) or not (<code>False</code>).</p>', 'ListStageDevicesRequest$ExcludeDevicesDeployedInOtherStage' => '<p>Toggle for excluding devices deployed in other stages.</p>', 'Model$EnableNetworkIsolation' => '<p>Isolates the model container. No inbound or outbound network calls can be made to or from the model container.</p>', 'ModelDashboardIndicatorAction$Enabled' => '<p>Indicates whether the alert action is turned on.</p>', 'MonitoringCsvDatasetFormat$Header' => '<p>Indicates if the CSV data has a header.</p>', 'MonitoringJsonDatasetFormat$Line' => '<p>Indicates if the file should be read as a JSON object per line. </p>', 'MonitoringNetworkConfig$EnableInterContainerTrafficEncryption' => '<p>Whether to encrypt all communications between the instances used for the monitoring jobs. Choose <code>True</code> to encrypt communications. Encryption provides greater security for distributed jobs, but the processing might take longer.</p>', 'MonitoringNetworkConfig$EnableNetworkIsolation' => '<p>Whether to allow inbound and outbound network calls to and from the containers used for the monitoring job.</p>', 'NetworkConfig$EnableInterContainerTrafficEncryption' => '<p>Whether to encrypt all communications between distributed processing jobs. Choose <code>True</code> to encrypt communications. Encryption provides greater security for distributed processing jobs, but the processing might take longer.</p>', 'NetworkConfig$EnableNetworkIsolation' => '<p>Whether to allow inbound and outbound network calls to and from the containers used for the processing job.</p>', 'OfflineStoreConfig$DisableGlueTableCreation' => '<p>Set to <code>True</code> to disable the automatic creation of an Amazon Web Services Glue table when configuring an <code>OfflineStore</code>. If set to <code>False</code>, Feature Store will name the <code>OfflineStore</code> Glue table following <a href="https://docs.aws.amazon.com/athena/latest/ug/tables-databases-columns-names.html">Athena\'s naming recommendations</a>.</p> <p>The default value is <code>False</code>.</p>', 'OnlineStoreConfig$EnableOnlineStore' => '<p>Turn <code>OnlineStore</code> off by specifying <code>False</code> for the <code>EnableOnlineStore</code> flag. Turn <code>OnlineStore</code> on by specifying <code>True</code> for the <code>EnableOnlineStore</code> flag. </p> <p>The default value is <code>False</code>.</p>', 'QualityCheckStepMetadata$SkipCheck' => '<p>This flag indicates if the drift check against the previous baseline will be skipped or not. If it is set to <code>False</code>, the previous baseline of the configured check type must be available.</p>', 'QualityCheckStepMetadata$RegisterNewBaseline' => '<p>This flag indicates if a newly calculated baseline can be accessed through step properties <code>BaselineUsedForDriftCheckConstraints</code> and <code>BaselineUsedForDriftCheckStatistics</code>. If it is set to <code>False</code>, the previous baseline of the configured check type must also be available. These can be accessed through the <code>BaselineUsedForDriftCheckConstraints</code> and <code> BaselineUsedForDriftCheckStatistics</code> properties. </p>', 'QueryLineageRequest$IncludeEdges' => '<p> Setting this value to <code>True</code> retrieves not only the entities of interest but also the <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking-entities.html">Associations</a> and lineage entities on the path. Set to <code>False</code> to only return lineage entities that match your query.</p>', 'TrainingJob$EnableNetworkIsolation' => '<p>If the <code>TrainingJob</code> was created with network isolation, the value is set to <code>true</code>. If network isolation is enabled, nodes can\'t communicate beyond the VPC they run in.</p>', 'TrainingJob$EnableInterContainerTrafficEncryption' => '<p>To encrypt all communications between ML compute instances in distributed training, choose <code>True</code>. Encryption provides greater security for distributed training, but training might take longer. How long it takes depends on the amount of communication between compute instances, especially if you use a deep learning algorithm in distributed training.</p>', 'TrainingJob$EnableManagedSpotTraining' => '<p>When true, enables managed spot training using Amazon EC2 Spot instances to run training jobs instead of on-demand instances. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-managed-spot-training.html">Managed Spot Training</a>.</p>', 'TrainingSpecification$SupportsDistributedTraining' => '<p>Indicates whether the algorithm supports distributed training. If set to false, buyers can\'t request more than one instance during training.</p>', 'UpdateEndpointInput$RetainAllVariantProperties' => '<p>When updating endpoint resources, enables or disables the retention of <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_VariantProperty.html">variant properties</a>, such as the instance count or the variant weight. To retain the variant properties of an endpoint when updating it, set <code>RetainAllVariantProperties</code> to <code>true</code>. To use the variant properties specified in a new <code>EndpointConfig</code> call when updating an endpoint, set <code>RetainAllVariantProperties</code> to <code>false</code>. The default is <code>false</code>.</p>', 'UpdateEndpointInput$RetainDeploymentConfig' => '<p>Specifies whether to reuse the last deployment configuration. The default value is false (the configuration is not reused).</p>', 'UpdateMlflowTrackingServerRequest$AutomaticModelRegistration' => '<p>Whether to enable or disable automatic registration of new MLflow models to the SageMaker Model Registry. To enable automatic model registration, set this value to <code>True</code>. To disable automatic model registration, set this value to <code>False</code>. If not specified, <code>AutomaticModelRegistration</code> defaults to <code>False</code> </p>', ], ], 'BooleanOperator' => [ 'base' => NULL, 'refs' => [ 'SearchExpression$Operator' => '<p>A Boolean operator used to evaluate the search expression. If you want every conditional statement in all lists to be satisfied for the entire search expression to be true, specify <code>And</code>. If only a single conditional statement needs to be true for the entire search expression to be true, specify <code>Or</code>. The default value is <code>And</code>.</p>', ], ], 'Branch' => [ 'base' => NULL, 'refs' => [ 'GitConfig$Branch' => '<p>The default branch for the Git repository.</p>', ], ], 'BucketName' => [ 'base' => NULL, 'refs' => [ 'PipelineDefinitionS3Location$Bucket' => '<p>Name of the S3 bucket.</p>', ], ], 'CacheHitResult' => [ 'base' => '<p>Details on the cache hit of a pipeline execution step.</p>', 'refs' => [ 'PipelineExecutionStep$CacheHitResult' => '<p>If this pipeline execution step was cached, details on the cache hit.</p>', ], ], 'CallbackStepMetadata' => [ 'base' => '<p>Metadata about a callback step.</p>', 'refs' => [ 'PipelineExecutionStepMetadata$Callback' => '<p>The URL of the Amazon SQS queue used by this step execution, the pipeline generated token, and a list of output parameters.</p>', ], ], 'CallbackToken' => [ 'base' => NULL, 'refs' => [ 'CallbackStepMetadata$CallbackToken' => '<p>The pipeline generated token from the Amazon SQS queue.</p>', 'SendPipelineExecutionStepFailureRequest$CallbackToken' => '<p>The pipeline generated token from the Amazon SQS queue.</p>', 'SendPipelineExecutionStepSuccessRequest$CallbackToken' => '<p>The pipeline generated token from the Amazon SQS queue.</p>', ], ], 'CandidateArtifactLocations' => [ 'base' => '<p>The location of artifacts for an AutoML candidate job.</p>', 'refs' => [ 'CandidateProperties$CandidateArtifactLocations' => '<p>The Amazon S3 prefix to the artifacts generated for an AutoML candidate.</p>', ], ], 'CandidateDefinitionNotebookLocation' => [ 'base' => NULL, 'refs' => [ 'AutoMLJobArtifacts$CandidateDefinitionNotebookLocation' => '<p>The URL of the notebook location.</p>', ], ], 'CandidateGenerationConfig' => [ 'base' => '<p>Stores the configuration information for how model candidates are generated using an AutoML job V2.</p>', 'refs' => [ 'TabularJobConfig$CandidateGenerationConfig' => '<p>The configuration information of how model candidates are generated.</p>', 'TimeSeriesForecastingJobConfig$CandidateGenerationConfig' => NULL, ], ], 'CandidateName' => [ 'base' => NULL, 'refs' => [ 'AutoMLCandidate$CandidateName' => '<p>The name of the candidate.</p>', 'ListCandidatesForAutoMLJobRequest$CandidateNameEquals' => '<p>List the candidates for the job and filter by candidate name.</p>', ], ], 'CandidateProperties' => [ 'base' => '<p>The properties of an AutoML candidate job.</p>', 'refs' => [ 'AutoMLCandidate$CandidateProperties' => '<p>The properties of an AutoML candidate job.</p>', ], ], 'CandidateSortBy' => [ 'base' => NULL, 'refs' => [ 'ListCandidatesForAutoMLJobRequest$SortBy' => '<p>The parameter by which to sort the results. The default is <code>Descending</code>.</p>', ], ], 'CandidateStatus' => [ 'base' => NULL, 'refs' => [ 'AutoMLCandidate$CandidateStatus' => '<p>The candidate\'s status.</p>', 'ListCandidatesForAutoMLJobRequest$StatusEquals' => '<p>List the candidates for the job and filter by status.</p>', ], ], 'CandidateStepArn' => [ 'base' => NULL, 'refs' => [ 'AutoMLCandidateStep$CandidateStepArn' => '<p>The ARN for the candidate\'s step.</p>', ], ], 'CandidateStepName' => [ 'base' => NULL, 'refs' => [ 'AutoMLCandidateStep$CandidateStepName' => '<p>The name for the candidate\'s step.</p>', ], ], 'CandidateStepType' => [ 'base' => NULL, 'refs' => [ 'AutoMLCandidateStep$CandidateStepType' => '<p>Whether the candidate is at the transform, training, or processing step.</p>', ], ], 'CandidateSteps' => [ 'base' => NULL, 'refs' => [ 'AutoMLCandidate$CandidateSteps' => '<p>Information about the candidate\'s steps.</p>', ], ], 'CanvasAppSettings' => [ 'base' => '<p>The SageMaker Canvas application settings.</p>', 'refs' => [ 'UserSettings$CanvasAppSettings' => '<p>The Canvas app settings.</p>', ], ], 'CapacitySize' => [ 'base' => '<p>Specifies the type and size of the endpoint capacity to activate for a blue/green deployment, a rolling deployment, or a rollback strategy. You can specify your batches as either instance count or the overall percentage or your fleet.</p> <p>For a rollback strategy, if you don\'t specify the fields in this object, or if you set the <code>Value</code> to 100%, then SageMaker uses a blue/green rollback strategy and rolls all traffic back to the blue fleet.</p>', 'refs' => [ 'RollingUpdatePolicy$MaximumBatchSize' => '<p>Batch size for each rolling step to provision capacity and turn on traffic on the new endpoint fleet, and terminate capacity on the old endpoint fleet. Value must be between 5% to 50% of the variant\'s total instance count.</p>', 'RollingUpdatePolicy$RollbackMaximumBatchSize' => '<p>Batch size for rollback to the old endpoint fleet. Each rolling step to provision capacity and turn on traffic on the old endpoint fleet, and terminate capacity on the new endpoint fleet. If this field is absent, the default value will be set to 100% of total capacity which means to bring up the whole capacity of the old fleet at once during rollback.</p>', 'TrafficRoutingConfig$CanarySize' => '<p>Batch size for the first step to turn on traffic on the new endpoint fleet. <code>Value</code> must be less than or equal to 50% of the variant\'s total instance count.</p>', 'TrafficRoutingConfig$LinearStepSize' => '<p>Batch size for each step to turn on traffic on the new endpoint fleet. <code>Value</code> must be 10-50% of the variant\'s total instance count.</p>', ], ], 'CapacitySizeType' => [ 'base' => NULL, 'refs' => [ 'CapacitySize$Type' => '<p>Specifies the endpoint capacity type.</p> <ul> <li> <p> <code>INSTANCE_COUNT</code>: The endpoint activates based on the number of instances.</p> </li> <li> <p> <code>CAPACITY_PERCENT</code>: The endpoint activates based on the specified percentage of capacity.</p> </li> </ul>', ], ], 'CapacitySizeValue' => [ 'base' => NULL, 'refs' => [ 'CapacitySize$Value' => '<p>Defines the capacity size, either as a number of instances or a capacity percentage.</p>', ], ], 'CapacityUnit' => [ 'base' => NULL, 'refs' => [ 'ThroughputConfig$ProvisionedReadCapacityUnits' => '<p> For provisioned feature groups with online store enabled, this indicates the read throughput you are billed for and can consume without throttling. </p> <p>This field is not applicable for on-demand feature groups. </p>', 'ThroughputConfig$ProvisionedWriteCapacityUnits' => '<p> For provisioned feature groups, this indicates the write throughput you are billed for and can consume without throttling. </p> <p>This field is not applicable for on-demand feature groups. </p>', 'ThroughputConfigDescription$ProvisionedReadCapacityUnits' => '<p> For provisioned feature groups with online store enabled, this indicates the read throughput you are billed for and can consume without throttling. </p> <p>This field is not applicable for on-demand feature groups. </p>', 'ThroughputConfigDescription$ProvisionedWriteCapacityUnits' => '<p> For provisioned feature groups, this indicates the write throughput you are billed for and can consume without throttling. </p> <p>This field is not applicable for on-demand feature groups. </p>', 'ThroughputConfigUpdate$ProvisionedReadCapacityUnits' => '<p>For provisioned feature groups with online store enabled, this indicates the read throughput you are billed for and can consume without throttling. </p>', 'ThroughputConfigUpdate$ProvisionedWriteCapacityUnits' => '<p>For provisioned feature groups, this indicates the write throughput you are billed for and can consume without throttling. </p>', ], ], 'CaptureContentTypeHeader' => [ 'base' => '<p>Configuration specifying how to treat different headers. If no headers are specified Amazon SageMaker will by default base64 encode when capturing the data.</p>', 'refs' => [ 'DataCaptureConfig$CaptureContentTypeHeader' => '<p>Configuration specifying how to treat different headers. If no headers are specified SageMaker will by default base64 encode when capturing the data.</p>', 'InferenceExperimentDataStorageConfig$ContentType' => NULL, ], ], 'CaptureMode' => [ 'base' => NULL, 'refs' => [ 'CaptureOption$CaptureMode' => '<p>Specify the boundary of data to capture.</p>', ], ], 'CaptureOption' => [ 'base' => '<p>Specifies data Model Monitor will capture.</p>', 'refs' => [ 'CaptureOptionList$member' => NULL, ], ], 'CaptureOptionList' => [ 'base' => NULL, 'refs' => [ 'DataCaptureConfig$CaptureOptions' => '<p>Specifies data Model Monitor will capture. You can configure whether to collect only input, only output, or both</p>', ], ], 'CaptureStatus' => [ 'base' => NULL, 'refs' => [ 'DataCaptureConfigSummary$CaptureStatus' => '<p>Whether data capture is currently functional.</p>', ], ], 'Catalog' => [ 'base' => NULL, 'refs' => [ 'DataCatalogConfig$Catalog' => '<p>The name of the Glue table catalog.</p>', ], ], 'CategoricalParameter' => [ 'base' => '<p>Environment parameters you want to benchmark your load test against.</p>', 'refs' => [ 'CategoricalParameters$member' => NULL, ], ], 'CategoricalParameterRange' => [ 'base' => '<p>A list of categorical hyperparameters to tune.</p>', 'refs' => [ 'CategoricalParameterRanges$member' => NULL, ], ], 'CategoricalParameterRangeSpecification' => [ 'base' => '<p>Defines the possible values for a categorical hyperparameter.</p>', 'refs' => [ 'ParameterRange$CategoricalParameterRangeSpecification' => '<p>A <code>CategoricalParameterRangeSpecification</code> object that defines the possible values for a categorical hyperparameter.</p>', ], ], 'CategoricalParameterRangeValues' => [ 'base' => NULL, 'refs' => [ 'CategoricalParameter$Value' => '<p>The list of values you can pass.</p>', ], ], 'CategoricalParameterRanges' => [ 'base' => NULL, 'refs' => [ 'ParameterRanges$CategoricalParameterRanges' => '<p>The array of <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CategoricalParameterRange.html">CategoricalParameterRange</a> objects that specify ranges of categorical hyperparameters that a hyperparameter tuning job searches.</p>', ], ], 'CategoricalParameters' => [ 'base' => NULL, 'refs' => [ 'EnvironmentParameterRanges$CategoricalParameterRanges' => '<p>Specified a list of parameters for each category.</p>', ], ], 'Cents' => [ 'base' => NULL, 'refs' => [ 'USD$Cents' => '<p>The fractional portion, in cents, of the amount. </p>', ], ], 'CertifyForMarketplace' => [ 'base' => NULL, 'refs' => [ 'CreateAlgorithmInput$CertifyForMarketplace' => '<p>Whether to certify the algorithm so that it can be listed in Amazon Web Services Marketplace.</p>', 'CreateModelPackageInput$CertifyForMarketplace' => '<p>Whether to certify the model package for listing on Amazon Web Services Marketplace.</p> <p>This parameter is optional for unversioned models, and does not apply to versioned models.</p>', 'DescribeAlgorithmOutput$CertifyForMarketplace' => '<p>Whether the algorithm is certified to be listed in Amazon Web Services Marketplace.</p>', 'DescribeModelPackageOutput$CertifyForMarketplace' => '<p>Whether the model package is certified for listing on Amazon Web Services Marketplace.</p>', 'ModelPackage$CertifyForMarketplace' => '<p>Whether the model package is to be certified to be listed on Amazon Web Services Marketplace. For information about listing model packages on Amazon Web Services Marketplace, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-mkt-list.html">List Your Algorithm or Model Package on Amazon Web Services Marketplace</a>.</p>', ], ], 'Channel' => [ 'base' => '<p>A channel is a named input source that training algorithms can consume. </p>', 'refs' => [ 'InputDataConfig$member' => NULL, ], ], 'ChannelName' => [ 'base' => NULL, 'refs' => [ 'Channel$ChannelName' => '<p>The name of the channel. </p>', 'ChannelSpecification$Name' => '<p>The name of the channel.</p>', ], ], 'ChannelSpecification' => [ 'base' => '<p>Defines a named input source, called a channel, to be used by an algorithm.</p>', 'refs' => [ 'ChannelSpecifications$member' => NULL, ], ], 'ChannelSpecifications' => [ 'base' => NULL, 'refs' => [ 'TrainingSpecification$TrainingChannels' => '<p>A list of <code>ChannelSpecification</code> objects, which specify the input sources to be used by the algorithm.</p>', ], ], 'CheckpointConfig' => [ 'base' => '<p>Contains information about the output location for managed spot training checkpoint data. </p>', 'refs' => [ 'CreateTrainingJobRequest$CheckpointConfig' => '<p>Contains information about the output location for managed spot training checkpoint data.</p>', 'DescribeTrainingJobResponse$CheckpointConfig' => NULL, 'HyperParameterTrainingJobDefinition$CheckpointConfig' => NULL, 'TrainingJob$CheckpointConfig' => NULL, ], ], 'Cidr' => [ 'base' => NULL, 'refs' => [ 'Cidrs$member' => NULL, ], ], 'Cidrs' => [ 'base' => NULL, 'refs' => [ 'SourceIpConfig$Cidrs' => '<p>A list of one to ten <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">Classless Inter-Domain Routing</a> (CIDR) values.</p> <p>Maximum: Ten CIDR values</p> <note> <p>The following Length Constraints apply to individual CIDR values in the CIDR value list.</p> </note>', ], ], 'ClarifyCheckStepMetadata' => [ 'base' => '<p>The container for the metadata for the ClarifyCheck step. For more information, see the topic on <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/build-and-manage-steps.html#step-type-clarify-check">ClarifyCheck step</a> in the <i>Amazon SageMaker Developer Guide</i>. </p>', 'refs' => [ 'PipelineExecutionStepMetadata$ClarifyCheck' => '<p>Container for the metadata for a Clarify check step. The configurations and outcomes of the check step execution. This includes: </p> <ul> <li> <p>The type of the check conducted,</p> </li> <li> <p>The Amazon S3 URIs of baseline constraints and statistics files to be used for the drift check.</p> </li> <li> <p>The Amazon S3 URIs of newly calculated baseline constraints and statistics.</p> </li> <li> <p>The model package group name provided.</p> </li> <li> <p>The Amazon S3 URI of the violation report if violations detected.</p> </li> <li> <p>The Amazon Resource Name (ARN) of check processing job initiated by the step execution.</p> </li> <li> <p>The boolean flags indicating if the drift check is skipped.</p> </li> <li> <p>If step property <code>BaselineUsedForDriftCheck</code> is set the same as <code>CalculatedBaseline</code>.</p> </li> </ul>', ], ], 'ClarifyContentTemplate' => [ 'base' => NULL, 'refs' => [ 'ClarifyInferenceConfig$ContentTemplate' => '<p>A template string used to format a JSON record into an acceptable model container input. For example, a <code>ContentTemplate</code> string <code>\'{"myfeatures":$features}\'</code> will format a list of features <code>[1,2,3]</code> into the record string <code>\'{"myfeatures":[1,2,3]}\'</code>. Required only when the model container input is in JSON Lines format.</p>', ], ], 'ClarifyEnableExplanations' => [ 'base' => NULL, 'refs' => [ 'ClarifyExplainerConfig$EnableExplanations' => '<p>A JMESPath boolean expression used to filter which records to explain. Explanations are activated by default. See <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-create-endpoint.html#clarify-online-explainability-create-endpoint-enable"> <code>EnableExplanations</code> </a>for additional information.</p>', ], ], 'ClarifyExplainerConfig' => [ 'base' => '<p>The configuration parameters for the SageMaker Clarify explainer.</p>', 'refs' => [ 'ExplainerConfig$ClarifyExplainerConfig' => '<p>A member of <code>ExplainerConfig</code> that contains configuration parameters for the SageMaker Clarify explainer.</p>', ], ], 'ClarifyFeatureHeaders' => [ 'base' => NULL, 'refs' => [ 'ClarifyInferenceConfig$FeatureHeaders' => '<p>The names of the features. If provided, these are included in the endpoint response payload to help readability of the <code>InvokeEndpoint</code> output. See the <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-invoke-endpoint.html#clarify-online-explainability-response">Response</a> section under <b>Invoke the endpoint</b> in the Developer Guide for more information.</p>', ], ], 'ClarifyFeatureType' => [ 'base' => NULL, 'refs' => [ 'ClarifyFeatureTypes$member' => NULL, ], ], 'ClarifyFeatureTypes' => [ 'base' => NULL, 'refs' => [ 'ClarifyInferenceConfig$FeatureTypes' => '<p>A list of data types of the features (optional). Applicable only to NLP explainability. If provided, <code>FeatureTypes</code> must have at least one <code>\'text\'</code> string (for example, <code>[\'text\']</code>). If <code>FeatureTypes</code> is not provided, the explainer infers the feature types based on the baseline data. The feature types are included in the endpoint response payload. For additional information see the <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-invoke-endpoint.html#clarify-online-explainability-response">response</a> section under <b>Invoke the endpoint</b> in the Developer Guide for more information.</p>', ], ], 'ClarifyFeaturesAttribute' => [ 'base' => NULL, 'refs' => [ 'ClarifyInferenceConfig$FeaturesAttribute' => '<p>Provides the JMESPath expression to extract the features from a model container input in JSON Lines format. For example, if <code>FeaturesAttribute</code> is the JMESPath expression <code>\'myfeatures\'</code>, it extracts a list of features <code>[1,2,3]</code> from request data <code>\'{"myfeatures":[1,2,3]}\'</code>.</p>', ], ], 'ClarifyHeader' => [ 'base' => NULL, 'refs' => [ 'ClarifyFeatureHeaders$member' => NULL, 'ClarifyLabelHeaders$member' => NULL, ], ], 'ClarifyInferenceConfig' => [ 'base' => '<p>The inference configuration parameter for the model container.</p>', 'refs' => [ 'ClarifyExplainerConfig$InferenceConfig' => '<p>The inference configuration parameter for the model container.</p>', ], ], 'ClarifyLabelAttribute' => [ 'base' => NULL, 'refs' => [ 'ClarifyInferenceConfig$LabelAttribute' => '<p>A JMESPath expression used to locate the list of label headers in the model container output.</p> <p> <b>Example</b>: If the model container output of a batch request is <code>\'{"labels":["cat","dog","fish"],"probability":[0.6,0.3,0.1]}\'</code>, then set <code>LabelAttribute</code> to <code>\'labels\'</code> to extract the list of label headers <code>["cat","dog","fish"]</code> </p>', ], ], 'ClarifyLabelHeaders' => [ 'base' => NULL, 'refs' => [ 'ClarifyInferenceConfig$LabelHeaders' => '<p>For multiclass classification problems, the label headers are the names of the classes. Otherwise, the label header is the name of the predicted label. These are used to help readability for the output of the <code>InvokeEndpoint</code> API. See the <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-invoke-endpoint.html#clarify-online-explainability-response">response</a> section under <b>Invoke the endpoint</b> in the Developer Guide for more information. If there are no label headers in the model container output, provide them manually using this parameter.</p>', ], ], 'ClarifyLabelIndex' => [ 'base' => NULL, 'refs' => [ 'ClarifyInferenceConfig$LabelIndex' => '<p>A zero-based index used to extract a label header or list of label headers from model container output in CSV format.</p> <p> <b>Example for a multiclass model:</b> If the model container output consists of label headers followed by probabilities: <code>\'"[\\\'cat\\\',\\\'dog\\\',\\\'fish\\\']","[0.1,0.6,0.3]"\'</code>, set <code>LabelIndex</code> to <code>0</code> to select the label headers <code>[\'cat\',\'dog\',\'fish\']</code>.</p>', ], ], 'ClarifyMaxPayloadInMB' => [ 'base' => NULL, 'refs' => [ 'ClarifyInferenceConfig$MaxPayloadInMB' => '<p>The maximum payload size (MB) allowed of a request from the explainer to the model container. Defaults to <code>6</code> MB.</p>', ], ], 'ClarifyMaxRecordCount' => [ 'base' => NULL, 'refs' => [ 'ClarifyInferenceConfig$MaxRecordCount' => '<p>The maximum number of records in a request that the model container can process when querying the model container for the predictions of a <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-create-endpoint.html#clarify-online-explainability-create-endpoint-synthetic">synthetic dataset</a>. A record is a unit of input data that inference can be made on, for example, a single line in CSV data. If <code>MaxRecordCount</code> is <code>1</code>, the model container expects one record per request. A value of 2 or greater means that the model expects batch requests, which can reduce overhead and speed up the inferencing process. If this parameter is not provided, the explainer will tune the record count per request according to the model container\'s capacity at runtime.</p>', ], ], 'ClarifyMimeType' => [ 'base' => NULL, 'refs' => [ 'ClarifyShapBaselineConfig$MimeType' => '<p>The MIME type of the baseline data. Choose from <code>\'text/csv\'</code> or <code>\'application/jsonlines\'</code>. Defaults to <code>\'text/csv\'</code>.</p>', ], ], 'ClarifyProbabilityAttribute' => [ 'base' => NULL, 'refs' => [ 'ClarifyInferenceConfig$ProbabilityAttribute' => '<p>A JMESPath expression used to extract the probability (or score) from the model container output if the model container is in JSON Lines format.</p> <p> <b>Example</b>: If the model container output of a single request is <code>\'{"predicted_label":1,"probability":0.6}\'</code>, then set <code>ProbabilityAttribute</code> to <code>\'probability\'</code>.</p>', ], ], 'ClarifyProbabilityIndex' => [ 'base' => NULL, 'refs' => [ 'ClarifyInferenceConfig$ProbabilityIndex' => '<p>A zero-based index used to extract a probability value (score) or list from model container output in CSV format. If this value is not provided, the entire model container output will be treated as a probability value (score) or list.</p> <p> <b>Example for a single class model:</b> If the model container output consists of a string-formatted prediction label followed by its probability: <code>\'1,0.6\'</code>, set <code>ProbabilityIndex</code> to <code>1</code> to select the probability value <code>0.6</code>.</p> <p> <b>Example for a multiclass model:</b> If the model container output consists of a string-formatted prediction label followed by its probability: <code>\'"[\\\'cat\\\',\\\'dog\\\',\\\'fish\\\']","[0.1,0.6,0.3]"\'</code>, set <code>ProbabilityIndex</code> to <code>1</code> to select the probability values <code>[0.1,0.6,0.3]</code>.</p>', ], ], 'ClarifyShapBaseline' => [ 'base' => NULL, 'refs' => [ 'ClarifyShapBaselineConfig$ShapBaseline' => '<p>The inline SHAP baseline data in string format. <code>ShapBaseline</code> can have one or multiple records to be used as the baseline dataset. The format of the SHAP baseline file should be the same format as the training dataset. For example, if the training dataset is in CSV format and each record contains four features, and all features are numerical, then the format of the baseline data should also share these characteristics. For natural language processing (NLP) of text columns, the baseline value should be the value used to replace the unit of text specified by the <code>Granularity</code> of the <code>TextConfig</code> parameter. The size limit for <code>ShapBasline</code> is 4 KB. Use the <code>ShapBaselineUri</code> parameter if you want to provide more than 4 KB of baseline data.</p>', ], ], 'ClarifyShapBaselineConfig' => [ 'base' => '<p>The configuration for the <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-feature-attribute-shap-baselines.html">SHAP baseline</a> (also called the background or reference dataset) of the Kernal SHAP algorithm.</p> <note> <ul> <li> <p>The number of records in the baseline data determines the size of the synthetic dataset, which has an impact on latency of explainability requests. For more information, see the <b>Synthetic data</b> of <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-create-endpoint.html">Configure and create an endpoint</a>.</p> </li> <li> <p> <code>ShapBaseline</code> and <code>ShapBaselineUri</code> are mutually exclusive parameters. One or the either is required to configure a SHAP baseline. </p> </li> </ul> </note>', 'refs' => [ 'ClarifyShapConfig$ShapBaselineConfig' => '<p>The configuration for the SHAP baseline of the Kernal SHAP algorithm.</p>', ], ], 'ClarifyShapConfig' => [ 'base' => '<p>The configuration for SHAP analysis using SageMaker Clarify Explainer.</p>', 'refs' => [ 'ClarifyExplainerConfig$ShapConfig' => '<p>The configuration for SHAP analysis.</p>', ], ], 'ClarifyShapNumberOfSamples' => [ 'base' => NULL, 'refs' => [ 'ClarifyShapConfig$NumberOfSamples' => '<p>The number of samples to be used for analysis by the Kernal SHAP algorithm. </p> <note> <p>The number of samples determines the size of the synthetic dataset, which has an impact on latency of explainability requests. For more information, see the <b>Synthetic data</b> of <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-create-endpoint.html">Configure and create an endpoint</a>.</p> </note>', ], ], 'ClarifyShapSeed' => [ 'base' => NULL, 'refs' => [ 'ClarifyShapConfig$Seed' => '<p>The starting value used to initialize the random number generator in the explainer. Provide a value for this parameter to obtain a deterministic SHAP result.</p>', ], ], 'ClarifyShapUseLogit' => [ 'base' => NULL, 'refs' => [ 'ClarifyShapConfig$UseLogit' => '<p>A Boolean toggle to indicate if you want to use the logit function (true) or log-odds units (false) for model predictions. Defaults to false.</p>', ], ], 'ClarifyTextConfig' => [ 'base' => '<p>A parameter used to configure the SageMaker Clarify explainer to treat text features as text so that explanations are provided for individual units of text. Required only for natural language processing (NLP) explainability. </p>', 'refs' => [ 'ClarifyShapConfig$TextConfig' => '<p>A parameter that indicates if text features are treated as text and explanations are provided for individual units of text. Required for natural language processing (NLP) explainability only.</p>', ], ], 'ClarifyTextGranularity' => [ 'base' => NULL, 'refs' => [ 'ClarifyTextConfig$Granularity' => '<p>The unit of granularity for the analysis of text features. For example, if the unit is <code>\'token\'</code>, then each token (like a word in English) of the text is treated as a feature. SHAP values are computed for each unit/feature.</p>', ], ], 'ClarifyTextLanguage' => [ 'base' => NULL, 'refs' => [ 'ClarifyTextConfig$Language' => '<p>Specifies the language of the text features in <a href=" https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes">ISO 639-1</a> or <a href="https://en.wikipedia.org/wiki/ISO_639-3">ISO 639-3</a> code of a supported language. </p> <note> <p>For a mix of multiple languages, use code <code>\'xx\'</code>.</p> </note>', ], ], 'ClientId' => [ 'base' => NULL, 'refs' => [ 'CognitoConfig$ClientId' => '<p>The client ID for your Amazon Cognito user pool.</p>', 'CognitoMemberDefinition$ClientId' => '<p>An identifier for an application client. You must create the app client ID using Amazon Cognito.</p>', 'OidcConfig$ClientId' => '<p>The OIDC IdP client ID used to configure your private workforce.</p>', 'OidcConfigForResponse$ClientId' => '<p>The OIDC IdP client ID used to configure your private workforce.</p>', ], ], 'ClientSecret' => [ 'base' => NULL, 'refs' => [ 'OidcConfig$ClientSecret' => '<p>The OIDC IdP client secret used to configure your private workforce.</p>', ], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'CreateImageVersionRequest$ClientToken' => '<p>A unique ID. If not specified, the Amazon Web Services CLI and Amazon Web Services SDKs, such as the SDK for Python (Boto3), add a unique value to the call.</p>', 'CreateModelPackageInput$ClientToken' => '<p>A unique token that guarantees that the call to this API is idempotent.</p>', ], ], 'ClusterArn' => [ 'base' => NULL, 'refs' => [ 'ClusterSummary$ClusterArn' => '<p>The Amazon Resource Name (ARN) of the SageMaker HyperPod cluster.</p>', 'CreateClusterResponse$ClusterArn' => '<p>The Amazon Resource Name (ARN) of the cluster.</p>', 'DeleteClusterResponse$ClusterArn' => '<p>The Amazon Resource Name (ARN) of the SageMaker HyperPod cluster to delete.</p>', 'DescribeClusterResponse$ClusterArn' => '<p>The Amazon Resource Name (ARN) of the SageMaker HyperPod cluster.</p>', 'UpdateClusterResponse$ClusterArn' => '<p>The Amazon Resource Name (ARN) of the updated SageMaker HyperPod cluster.</p>', 'UpdateClusterSoftwareResponse$ClusterArn' => '<p>The Amazon Resource Name (ARN) of the SageMaker HyperPod cluster being updated for security patching.</p>', ], ], 'ClusterAvailabilityZone' => [ 'base' => NULL, 'refs' => [ 'ClusterInstancePlacement$AvailabilityZone' => '<p>The Availability Zone where the node in the SageMaker HyperPod cluster is launched.</p>', ], ], 'ClusterAvailabilityZoneId' => [ 'base' => NULL, 'refs' => [ 'ClusterInstancePlacement$AvailabilityZoneId' => '<p>The unique identifier (ID) of the Availability Zone where the node in the SageMaker HyperPod cluster is launched.</p>', ], ], 'ClusterEbsVolumeConfig' => [ 'base' => '<p>Defines the configuration for attaching an additional Amazon Elastic Block Store (EBS) volume to each instance of the SageMaker HyperPod cluster instance group. To learn more, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-hyperpod-release-notes.html#sagemaker-hyperpod-release-notes-20240620">SageMaker HyperPod release notes: June 20, 2024</a>.</p>', 'refs' => [ 'ClusterInstanceStorageConfig$EbsVolumeConfig' => '<p>Defines the configuration for attaching additional Amazon Elastic Block Store (EBS) volumes to the instances in the SageMaker HyperPod cluster instance group. The additional EBS volume is attached to each instance within the SageMaker HyperPod cluster instance group and mounted to <code>/opt/sagemaker</code>.</p>', ], ], 'ClusterEbsVolumeSizeInGB' => [ 'base' => NULL, 'refs' => [ 'ClusterEbsVolumeConfig$VolumeSizeInGB' => '<p>The size in gigabytes (GB) of the additional EBS volume to be attached to the instances in the SageMaker HyperPod cluster instance group. The additional EBS volume is attached to each instance within the SageMaker HyperPod cluster instance group and mounted to <code>/opt/sagemaker</code>.</p>', ], ], 'ClusterInstanceCount' => [ 'base' => NULL, 'refs' => [ 'ClusterInstanceGroupDetails$TargetCount' => '<p>The number of instances you specified to add to the instance group of a SageMaker HyperPod cluster.</p>', 'ClusterInstanceGroupSpecification$InstanceCount' => '<p>Specifies the number of instances to add to the instance group of a SageMaker HyperPod cluster.</p>', ], ], 'ClusterInstanceGroupDetails' => [ 'base' => '<p>Details of an instance group in a SageMaker HyperPod cluster.</p>', 'refs' => [ 'ClusterInstanceGroupDetailsList$member' => NULL, ], ], 'ClusterInstanceGroupDetailsList' => [ 'base' => NULL, 'refs' => [ 'DescribeClusterResponse$InstanceGroups' => '<p>The instance groups of the SageMaker HyperPod cluster.</p>', ], ], 'ClusterInstanceGroupName' => [ 'base' => NULL, 'refs' => [ 'ClusterInstanceGroupDetails$InstanceGroupName' => '<p>The name of the instance group of a SageMaker HyperPod cluster.</p>', 'ClusterInstanceGroupSpecification$InstanceGroupName' => '<p>Specifies the name of the instance group.</p>', 'ClusterNodeDetails$InstanceGroupName' => '<p>The instance group name in which the instance is.</p>', 'ClusterNodeSummary$InstanceGroupName' => '<p>The name of the instance group in which the instance is.</p>', 'ListClusterNodesRequest$InstanceGroupNameContains' => '<p>A filter that returns the instance groups whose name contain a specified string.</p>', ], ], 'ClusterInstanceGroupSpecification' => [ 'base' => '<p>The specifications of an instance group that you need to define.</p>', 'refs' => [ 'ClusterInstanceGroupSpecifications$member' => NULL, ], ], 'ClusterInstanceGroupSpecifications' => [ 'base' => NULL, 'refs' => [ 'CreateClusterRequest$InstanceGroups' => '<p>The instance groups to be created in the SageMaker HyperPod cluster.</p>', 'UpdateClusterRequest$InstanceGroups' => '<p>Specify the instance groups to update.</p>', ], ], 'ClusterInstancePlacement' => [ 'base' => '<p>Specifies the placement details for the node in the SageMaker HyperPod cluster, including the Availability Zone and the unique identifier (ID) of the Availability Zone.</p>', 'refs' => [ 'ClusterNodeDetails$Placement' => '<p>The placement details of the SageMaker HyperPod cluster node.</p>', ], ], 'ClusterInstanceStatus' => [ 'base' => NULL, 'refs' => [ 'ClusterInstanceStatusDetails$Status' => '<p>The status of an instance in a SageMaker HyperPod cluster.</p>', ], ], 'ClusterInstanceStatusDetails' => [ 'base' => '<p>Details of an instance in a SageMaker HyperPod cluster.</p>', 'refs' => [ 'ClusterNodeDetails$InstanceStatus' => '<p>The status of the instance.</p>', 'ClusterNodeSummary$InstanceStatus' => '<p>The status of the instance.</p>', ], ], 'ClusterInstanceStorageConfig' => [ 'base' => '<p>Defines the configuration for attaching additional storage to the instances in the SageMaker HyperPod cluster instance group. To learn more, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-hyperpod-release-notes.html#sagemaker-hyperpod-release-notes-20240620">SageMaker HyperPod release notes: June 20, 2024</a>.</p>', 'refs' => [ 'ClusterInstanceStorageConfigs$member' => NULL, ], ], 'ClusterInstanceStorageConfigs' => [ 'base' => NULL, 'refs' => [ 'ClusterInstanceGroupDetails$InstanceStorageConfigs' => '<p>The additional storage configurations for the instances in the SageMaker HyperPod cluster instance group.</p>', 'ClusterInstanceGroupSpecification$InstanceStorageConfigs' => '<p>Specifies the additional storage configurations for the instances in the SageMaker HyperPod cluster instance group.</p>', 'ClusterNodeDetails$InstanceStorageConfigs' => '<p>The configurations of additional storage specified to the instance group where the instance (node) is launched.</p>', ], ], 'ClusterInstanceType' => [ 'base' => NULL, 'refs' => [ 'ClusterInstanceGroupDetails$InstanceType' => '<p>The instance type of the instance group of a SageMaker HyperPod cluster.</p>', 'ClusterInstanceGroupSpecification$InstanceType' => '<p>Specifies the instance type of the instance group.</p>', 'ClusterNodeDetails$InstanceType' => '<p>The type of the instance.</p>', 'ClusterNodeSummary$InstanceType' => '<p>The type of the instance.</p>', ], ], 'ClusterLifeCycleConfig' => [ 'base' => '<p>The lifecycle configuration for a SageMaker HyperPod cluster.</p>', 'refs' => [ 'ClusterInstanceGroupDetails$LifeCycleConfig' => '<p>Details of LifeCycle configuration for the instance group.</p>', 'ClusterInstanceGroupSpecification$LifeCycleConfig' => '<p>Specifies the LifeCycle configuration for the instance group.</p>', 'ClusterNodeDetails$LifeCycleConfig' => '<p>The LifeCycle configuration applied to the instance.</p>', ], ], 'ClusterLifeCycleConfigFileName' => [ 'base' => NULL, 'refs' => [ 'ClusterLifeCycleConfig$OnCreate' => '<p>The file name of the entrypoint script of lifecycle scripts under <code>SourceS3Uri</code>. This entrypoint script runs during cluster creation.</p>', ], ], 'ClusterName' => [ 'base' => NULL, 'refs' => [ 'ClusterSummary$ClusterName' => '<p>The name of the SageMaker HyperPod cluster.</p>', 'CreateClusterRequest$ClusterName' => '<p>The name for the new SageMaker HyperPod cluster.</p>', 'DescribeClusterResponse$ClusterName' => '<p>The name of the SageMaker HyperPod cluster.</p>', ], ], 'ClusterNameOrArn' => [ 'base' => NULL, 'refs' => [ 'DeleteClusterRequest$ClusterName' => '<p>The string name or the Amazon Resource Name (ARN) of the SageMaker HyperPod cluster to delete.</p>', 'DescribeClusterNodeRequest$ClusterName' => '<p>The string name or the Amazon Resource Name (ARN) of the SageMaker HyperPod cluster in which the node is.</p>', 'DescribeClusterRequest$ClusterName' => '<p>The string name or the Amazon Resource Name (ARN) of the SageMaker HyperPod cluster.</p>', 'ListClusterNodesRequest$ClusterName' => '<p>The string name or the Amazon Resource Name (ARN) of the SageMaker HyperPod cluster in which you want to retrieve the list of nodes.</p>', 'UpdateClusterRequest$ClusterName' => '<p>Specify the name of the SageMaker HyperPod cluster you want to update.</p>', 'UpdateClusterSoftwareRequest$ClusterName' => '<p>Specify the name or the Amazon Resource Name (ARN) of the SageMaker HyperPod cluster you want to update for security patching.</p>', ], ], 'ClusterNodeDetails' => [ 'base' => '<p>Details of an instance (also called a <i>node</i> interchangeably) in a SageMaker HyperPod cluster.</p>', 'refs' => [ 'DescribeClusterNodeResponse$NodeDetails' => '<p>The details of the SageMaker HyperPod cluster node.</p>', ], ], 'ClusterNodeId' => [ 'base' => NULL, 'refs' => [ 'DescribeClusterNodeRequest$NodeId' => '<p>The ID of the SageMaker HyperPod cluster node.</p>', ], ], 'ClusterNodeSummaries' => [ 'base' => NULL, 'refs' => [ 'ListClusterNodesResponse$ClusterNodeSummaries' => '<p>The summaries of listed instances in a SageMaker HyperPod cluster</p>', ], ], 'ClusterNodeSummary' => [ 'base' => '<p>Lists a summary of the properties of an instance (also called a <i>node</i> interchangeably) of a SageMaker HyperPod cluster.</p>', 'refs' => [ 'ClusterNodeSummaries$member' => NULL, ], ], 'ClusterNonNegativeInstanceCount' => [ 'base' => NULL, 'refs' => [ 'ClusterInstanceGroupDetails$CurrentCount' => '<p>The number of instances that are currently in the instance group of a SageMaker HyperPod cluster.</p>', ], ], 'ClusterPrivateDnsHostname' => [ 'base' => NULL, 'refs' => [ 'ClusterNodeDetails$PrivateDnsHostname' => '<p>The private DNS hostname of the SageMaker HyperPod cluster node.</p>', ], ], 'ClusterPrivatePrimaryIp' => [ 'base' => NULL, 'refs' => [ 'ClusterNodeDetails$PrivatePrimaryIp' => '<p>The private primary IP address of the SageMaker HyperPod cluster node.</p>', ], ], 'ClusterSortBy' => [ 'base' => NULL, 'refs' => [ 'ListClusterNodesRequest$SortBy' => '<p>The field by which to sort results. The default value is <code>CREATION_TIME</code>.</p>', 'ListClustersRequest$SortBy' => '<p>The field by which to sort results. The default value is <code>CREATION_TIME</code>.</p>', ], ], 'ClusterStatus' => [ 'base' => NULL, 'refs' => [ 'ClusterSummary$ClusterStatus' => '<p>The status of the SageMaker HyperPod cluster.</p>', 'DescribeClusterResponse$ClusterStatus' => '<p>The status of the SageMaker HyperPod cluster.</p>', ], ], 'ClusterSummaries' => [ 'base' => NULL, 'refs' => [ 'ListClustersResponse$ClusterSummaries' => '<p>The summaries of listed SageMaker HyperPod clusters.</p>', ], ], 'ClusterSummary' => [ 'base' => '<p>Lists a summary of the properties of a SageMaker HyperPod cluster.</p>', 'refs' => [ 'ClusterSummaries$member' => NULL, ], ], 'ClusterThreadsPerCore' => [ 'base' => NULL, 'refs' => [ 'ClusterInstanceGroupDetails$ThreadsPerCore' => '<p>The number you specified to <code>TreadsPerCore</code> in <code>CreateCluster</code> for enabling or disabling multithreading. For instance types that support multithreading, you can specify 1 for disabling multithreading and 2 for enabling multithreading. For more information, see the reference table of <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/cpu-options-supported-instances-values.html">CPU cores and threads per CPU core per instance type</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'ClusterInstanceGroupSpecification$ThreadsPerCore' => '<p>Specifies the value for <b>Threads per core</b>. For instance types that support multithreading, you can specify <code>1</code> for disabling multithreading and <code>2</code> for enabling multithreading. For instance types that doesn\'t support multithreading, specify <code>1</code>. For more information, see the reference table of <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/cpu-options-supported-instances-values.html">CPU cores and threads per CPU core per instance type</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'ClusterNodeDetails$ThreadsPerCore' => '<p>The number of threads per CPU core you specified under <code>CreateCluster</code>.</p>', ], ], 'CodeEditorAppImageConfig' => [ 'base' => '<p>The configuration for the file system and kernels in a SageMaker image running as a Code Editor app. The <code>FileSystemConfig</code> object is not supported.</p>', 'refs' => [ 'AppImageConfigDetails$CodeEditorAppImageConfig' => '<p>The configuration for the file system and the runtime, such as the environment variables and entry point.</p>', 'CreateAppImageConfigRequest$CodeEditorAppImageConfig' => '<p>The <code>CodeEditorAppImageConfig</code>. You can only specify one image kernel in the AppImageConfig API. This kernel is shown to users before the image starts. After the image runs, all kernels are visible in Code Editor.</p>', 'DescribeAppImageConfigResponse$CodeEditorAppImageConfig' => '<p>The configuration of the Code Editor app.</p>', 'UpdateAppImageConfigRequest$CodeEditorAppImageConfig' => '<p>The Code Editor app running on the image.</p>', ], ], 'CodeEditorAppSettings' => [ 'base' => '<p>The Code Editor application settings.</p> <p>For more information about Code Editor, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/code-editor.html">Get started with Code Editor in Amazon SageMaker</a>.</p>', 'refs' => [ 'UserSettings$CodeEditorAppSettings' => '<p>The Code Editor application settings.</p>', ], ], 'CodeRepositories' => [ 'base' => NULL, 'refs' => [ 'JupyterLabAppSettings$CodeRepositories' => '<p>A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterLab application.</p>', 'JupyterServerAppSettings$CodeRepositories' => '<p>A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application.</p>', 'SpaceJupyterLabAppSettings$CodeRepositories' => '<p>A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterLab application.</p>', ], ], 'CodeRepository' => [ 'base' => '<p>A Git repository that SageMaker automatically displays to users for cloning in the JupyterServer application.</p>', 'refs' => [ 'CodeRepositories$member' => NULL, ], ], 'CodeRepositoryArn' => [ 'base' => NULL, 'refs' => [ 'CodeRepositorySummary$CodeRepositoryArn' => '<p>The Amazon Resource Name (ARN) of the Git repository.</p>', 'CreateCodeRepositoryOutput$CodeRepositoryArn' => '<p>The Amazon Resource Name (ARN) of the new repository.</p>', 'DescribeCodeRepositoryOutput$CodeRepositoryArn' => '<p>The Amazon Resource Name (ARN) of the Git repository.</p>', 'UpdateCodeRepositoryOutput$CodeRepositoryArn' => '<p>The ARN of the Git repository.</p>', ], ], 'CodeRepositoryContains' => [ 'base' => NULL, 'refs' => [ 'ListNotebookInstancesInput$DefaultCodeRepositoryContains' => '<p>A string in the name or URL of a Git repository associated with this notebook instance. This filter returns only notebook instances associated with a git repository with a name that contains the specified string.</p>', ], ], 'CodeRepositoryNameContains' => [ 'base' => NULL, 'refs' => [ 'ListCodeRepositoriesInput$NameContains' => '<p>A string in the Git repositories name. This filter returns only repositories whose name contains the specified string.</p>', ], ], 'CodeRepositoryNameOrUrl' => [ 'base' => NULL, 'refs' => [ 'AdditionalCodeRepositoryNamesOrUrls$member' => NULL, 'CreateNotebookInstanceInput$DefaultCodeRepository' => '<p>A Git repository to associate with the notebook instance as its default code repository. This can be either the name of a Git repository stored as a resource in your account, or the URL of a Git repository in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services CodeCommit</a> or in any other Git repository. When you open a notebook instance, it opens in the directory that contains this repository. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with SageMaker Notebook Instances</a>.</p>', 'DescribeNotebookInstanceOutput$DefaultCodeRepository' => '<p>The Git repository associated with the notebook instance as its default code repository. This can be either the name of a Git repository stored as a resource in your account, or the URL of a Git repository in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services CodeCommit</a> or in any other Git repository. When you open a notebook instance, it opens in the directory that contains this repository. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with SageMaker Notebook Instances</a>.</p>', 'ListNotebookInstancesInput$AdditionalCodeRepositoryEquals' => '<p>A filter that returns only notebook instances with associated with the specified git repository.</p>', 'NotebookInstanceSummary$DefaultCodeRepository' => '<p>The Git repository associated with the notebook instance as its default code repository. This can be either the name of a Git repository stored as a resource in your account, or the URL of a Git repository in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services CodeCommit</a> or in any other Git repository. When you open a notebook instance, it opens in the directory that contains this repository. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with SageMaker Notebook Instances</a>.</p>', 'UpdateNotebookInstanceInput$DefaultCodeRepository' => '<p>The Git repository to associate with the notebook instance as its default code repository. This can be either the name of a Git repository stored as a resource in your account, or the URL of a Git repository in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services CodeCommit</a> or in any other Git repository. When you open a notebook instance, it opens in the directory that contains this repository. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with SageMaker Notebook Instances</a>.</p>', ], ], 'CodeRepositorySortBy' => [ 'base' => NULL, 'refs' => [ 'ListCodeRepositoriesInput$SortBy' => '<p>The field to sort results by. The default is <code>Name</code>.</p>', ], ], 'CodeRepositorySortOrder' => [ 'base' => NULL, 'refs' => [ 'ListCodeRepositoriesInput$SortOrder' => '<p>The sort order for results. The default is <code>Ascending</code>.</p>', ], ], 'CodeRepositorySummary' => [ 'base' => '<p>Specifies summary information about a Git repository.</p>', 'refs' => [ 'CodeRepositorySummaryList$member' => NULL, ], ], 'CodeRepositorySummaryList' => [ 'base' => NULL, 'refs' => [ 'ListCodeRepositoriesOutput$CodeRepositorySummaryList' => '<p>Gets a list of summaries of the Git repositories. Each summary specifies the following values for the repository: </p> <ul> <li> <p>Name</p> </li> <li> <p>Amazon Resource Name (ARN)</p> </li> <li> <p>Creation time</p> </li> <li> <p>Last modified time</p> </li> <li> <p>Configuration information, including the URL location of the repository and the ARN of the Amazon Web Services Secrets Manager secret that contains the credentials used to access the repository.</p> </li> </ul>', ], ], 'CognitoConfig' => [ 'base' => '<p>Use this parameter to configure your Amazon Cognito workforce. A single Cognito workforce is created using and corresponds to a single <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html"> Amazon Cognito user pool</a>.</p>', 'refs' => [ 'CreateWorkforceRequest$CognitoConfig' => '<p>Use this parameter to configure an Amazon Cognito private workforce. A single Cognito workforce is created using and corresponds to a single <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html"> Amazon Cognito user pool</a>.</p> <p>Do not use <code>OidcConfig</code> if you specify values for <code>CognitoConfig</code>.</p>', 'Workforce$CognitoConfig' => '<p>The configuration of an Amazon Cognito workforce. A single Cognito workforce is created using and corresponds to a single <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html"> Amazon Cognito user pool</a>.</p>', ], ], 'CognitoMemberDefinition' => [ 'base' => '<p>Identifies a Amazon Cognito user group. A user group can be used in on or more work teams.</p>', 'refs' => [ 'MemberDefinition$CognitoMemberDefinition' => '<p>The Amazon Cognito user group that is part of the work team.</p>', ], ], 'CognitoUserGroup' => [ 'base' => NULL, 'refs' => [ 'CognitoMemberDefinition$UserGroup' => '<p>An identifier for a user group.</p>', ], ], 'CognitoUserPool' => [ 'base' => NULL, 'refs' => [ 'CognitoConfig$UserPool' => '<p>A <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html"> user pool</a> is a user directory in Amazon Cognito. With a user pool, your users can sign in to your web or mobile app through Amazon Cognito. Your users can also sign in through social identity providers like Google, Facebook, Amazon, or Apple, and through SAML identity providers.</p>', 'CognitoMemberDefinition$UserPool' => '<p>An identifier for a user pool. The user pool must be in the same region as the service that you are calling.</p>', ], ], 'CollectionConfig' => [ 'base' => '<p>Configuration for your collection.</p>', 'refs' => [ 'FeatureDefinition$CollectionConfig' => '<p>Configuration for your collection.</p>', ], ], 'CollectionConfiguration' => [ 'base' => '<p>Configuration information for the Amazon SageMaker Debugger output tensor collections.</p>', 'refs' => [ 'CollectionConfigurations$member' => NULL, ], ], 'CollectionConfigurations' => [ 'base' => NULL, 'refs' => [ 'DebugHookConfig$CollectionConfigurations' => '<p>Configuration information for Amazon SageMaker Debugger tensor collections. To learn more about how to configure the <code>CollectionConfiguration</code> parameter, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/debugger-createtrainingjob-api.html">Use the SageMaker and Debugger Configuration API Operations to Create, Update, and Debug Your Training Job</a>. </p>', ], ], 'CollectionName' => [ 'base' => NULL, 'refs' => [ 'CollectionConfiguration$CollectionName' => '<p>The name of the tensor collection. The name must be unique relative to other rule configuration names.</p>', ], ], 'CollectionParameters' => [ 'base' => NULL, 'refs' => [ 'CollectionConfiguration$CollectionParameters' => '<p>Parameter values for the tensor collection. The allowed parameters are <code>"name"</code>, <code>"include_regex"</code>, <code>"reduction_config"</code>, <code>"save_config"</code>, <code>"tensor_names"</code>, and <code>"save_histogram"</code>.</p>', ], ], 'CollectionType' => [ 'base' => NULL, 'refs' => [ 'FeatureDefinition$CollectionType' => '<p>A grouping of elements where each element within the collection must have the same feature type (<code>String</code>, <code>Integral</code>, or <code>Fractional</code>).</p> <ul> <li> <p> <code>List</code>: An ordered collection of elements.</p> </li> <li> <p> <code>Set</code>: An unordered collection of unique elements.</p> </li> <li> <p> <code>Vector</code>: A specialized list that represents a fixed-size array of elements. The vector dimension is determined by you. Must have elements with fractional feature types. </p> </li> </ul>', ], ], 'CompilationJobArn' => [ 'base' => NULL, 'refs' => [ 'CompilationJobSummary$CompilationJobArn' => '<p>The Amazon Resource Name (ARN) of the model compilation job.</p>', 'CreateCompilationJobResponse$CompilationJobArn' => '<p>If the action is successful, the service sends back an HTTP 200 response. Amazon SageMaker returns the following data in JSON format:</p> <ul> <li> <p> <code>CompilationJobArn</code>: The Amazon Resource Name (ARN) of the compiled job.</p> </li> </ul>', 'DescribeCompilationJobResponse$CompilationJobArn' => '<p>The Amazon Resource Name (ARN) of the model compilation job.</p>', ], ], 'CompilationJobStatus' => [ 'base' => NULL, 'refs' => [ 'CompilationJobSummary$CompilationJobStatus' => '<p>The status of the model compilation job.</p>', 'DescribeCompilationJobResponse$CompilationJobStatus' => '<p>The status of the model compilation job.</p>', 'ListCompilationJobsRequest$StatusEquals' => '<p>A filter that retrieves model compilation jobs with a specific <code>CompilationJobStatus</code> status.</p>', ], ], 'CompilationJobSummaries' => [ 'base' => NULL, 'refs' => [ 'ListCompilationJobsResponse$CompilationJobSummaries' => '<p>An array of <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CompilationJobSummary.html">CompilationJobSummary</a> objects, each describing a model compilation job. </p>', ], ], 'CompilationJobSummary' => [ 'base' => '<p>A summary of a model compilation job.</p>', 'refs' => [ 'CompilationJobSummaries$member' => NULL, ], ], 'CompilerOptions' => [ 'base' => NULL, 'refs' => [ 'OutputConfig$CompilerOptions' => '<p>Specifies additional parameters for compiler options in JSON format. The compiler options are <code>TargetPlatform</code> specific. It is required for NVIDIA accelerators and highly recommended for CPU compilations. For any other cases, it is optional to specify <code>CompilerOptions.</code> </p> <ul> <li> <p> <code>DTYPE</code>: Specifies the data type for the input. When compiling for <code>ml_*</code> (except for <code>ml_inf</code>) instances using PyTorch framework, provide the data type (dtype) of the model\'s input. <code>"float32"</code> is used if <code>"DTYPE"</code> is not specified. Options for data type are:</p> <ul> <li> <p>float32: Use either <code>"float"</code> or <code>"float32"</code>.</p> </li> <li> <p>int64: Use either <code>"int64"</code> or <code>"long"</code>.</p> </li> </ul> <p> For example, <code>{"dtype" : "float32"}</code>.</p> </li> <li> <p> <code>CPU</code>: Compilation for CPU supports the following compiler options.</p> <ul> <li> <p> <code>mcpu</code>: CPU micro-architecture. For example, <code>{\'mcpu\': \'skylake-avx512\'}</code> </p> </li> <li> <p> <code>mattr</code>: CPU flags. For example, <code>{\'mattr\': [\'+neon\', \'+vfpv4\']}</code> </p> </li> </ul> </li> <li> <p> <code>ARM</code>: Details of ARM CPU compilations.</p> <ul> <li> <p> <code>NEON</code>: NEON is an implementation of the Advanced SIMD extension used in ARMv7 processors.</p> <p>For example, add <code>{\'mattr\': [\'+neon\']}</code> to the compiler options if compiling for ARM 32-bit platform with the NEON support.</p> </li> </ul> </li> <li> <p> <code>NVIDIA</code>: Compilation for NVIDIA GPU supports the following compiler options.</p> <ul> <li> <p> <code>gpu_code</code>: Specifies the targeted architecture.</p> </li> <li> <p> <code>trt-ver</code>: Specifies the TensorRT versions in x.y.z. format.</p> </li> <li> <p> <code>cuda-ver</code>: Specifies the CUDA version in x.y format.</p> </li> </ul> <p>For example, <code>{\'gpu-code\': \'sm_72\', \'trt-ver\': \'6.0.1\', \'cuda-ver\': \'10.1\'}</code> </p> </li> <li> <p> <code>ANDROID</code>: Compilation for the Android OS supports the following compiler options:</p> <ul> <li> <p> <code>ANDROID_PLATFORM</code>: Specifies the Android API levels. Available levels range from 21 to 29. For example, <code>{\'ANDROID_PLATFORM\': 28}</code>.</p> </li> <li> <p> <code>mattr</code>: Add <code>{\'mattr\': [\'+neon\']}</code> to compiler options if compiling for ARM 32-bit platform with NEON support.</p> </li> </ul> </li> <li> <p> <code>INFERENTIA</code>: Compilation for target ml_inf1 uses compiler options passed in as a JSON string. For example, <code>"CompilerOptions": "\\"--verbose 1 --num-neuroncores 2 -O2\\""</code>. </p> <p>For information about supported compiler options, see <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/compiler/neuronx-cc/api-reference-guide/neuron-compiler-cli-reference-guide.html"> Neuron Compiler CLI Reference Guide</a>. </p> </li> <li> <p> <code>CoreML</code>: Compilation for the CoreML <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_OutputConfig.html">OutputConfig</a> <code>TargetDevice</code> supports the following compiler options:</p> <ul> <li> <p> <code>class_labels</code>: Specifies the classification labels file name inside input tar.gz file. For example, <code>{"class_labels": "imagenet_labels_1000.txt"}</code>. Labels inside the txt file should be separated by newlines.</p> </li> </ul> </li> <li> <p> <code>EIA</code>: Compilation for the Elastic Inference Accelerator supports the following compiler options:</p> <ul> <li> <p> <code>precision_mode</code>: Specifies the precision of compiled artifacts. Supported values are <code>"FP16"</code> and <code>"FP32"</code>. Default is <code>"FP32"</code>.</p> </li> <li> <p> <code>signature_def_key</code>: Specifies the signature to use for models in SavedModel format. Defaults is TensorFlow\'s default signature def key.</p> </li> <li> <p> <code>output_names</code>: Specifies a list of output tensor names for models in FrozenGraph format. Set at most one API field, either: <code>signature_def_key</code> or <code>output_names</code>.</p> </li> </ul> <p>For example: <code>{"precision_mode": "FP32", "output_names": ["output:0"]}</code> </p> </li> </ul>', ], ], 'CompleteOnConvergence' => [ 'base' => NULL, 'refs' => [ 'ConvergenceDetected$CompleteOnConvergence' => '<p>A flag to stop a tuning job once AMT has detected that the job has converged.</p>', ], ], 'CompressionType' => [ 'base' => NULL, 'refs' => [ 'AdditionalS3DataSource$CompressionType' => '<p>The type of compression used for an additional data source used in inference or training. Specify <code>None</code> if your additional data source is not compressed.</p>', 'AutoMLChannel$CompressionType' => '<p>You can use <code>Gzip</code> or <code>None</code>. The default value is <code>None</code>.</p>', 'AutoMLJobChannel$CompressionType' => '<p>The allowed compression types depend on the input format and problem type. We allow the compression type <code>Gzip</code> for <code>S3Prefix</code> inputs on tabular data only. For all other inputs, the compression type should be <code>None</code>. If no compression type is provided, we default to <code>None</code>.</p>', 'Channel$CompressionType' => '<p>If training data is compressed, the compression type. The default value is <code>None</code>. <code>CompressionType</code> is used only in Pipe input mode. In File mode, leave this field unset or set it to None.</p>', 'CompressionTypes$member' => NULL, 'TransformInput$CompressionType' => '<p>If your transform data is compressed, specify the compression type. Amazon SageMaker automatically decompresses the data for the transform job accordingly. The default value is <code>None</code>.</p>', ], ], 'CompressionTypes' => [ 'base' => NULL, 'refs' => [ 'ChannelSpecification$SupportedCompressionTypes' => '<p>The allowed compression types, if data compression is used.</p>', ], ], 'ConditionOutcome' => [ 'base' => NULL, 'refs' => [ 'ConditionStepMetadata$Outcome' => '<p>The outcome of the Condition step evaluation.</p>', ], ], 'ConditionStepMetadata' => [ 'base' => '<p>Metadata for a Condition step.</p>', 'refs' => [ 'PipelineExecutionStepMetadata$Condition' => '<p>The outcome of the condition evaluation that was run by this step execution.</p>', ], ], 'ConfigKey' => [ 'base' => NULL, 'refs' => [ 'CollectionParameters$key' => NULL, 'HookParameters$key' => NULL, 'ProfilingParameters$key' => NULL, 'RuleParameters$key' => NULL, ], ], 'ConfigValue' => [ 'base' => NULL, 'refs' => [ 'CollectionParameters$value' => NULL, 'HookParameters$value' => NULL, 'ProfilingParameters$value' => NULL, 'RuleParameters$value' => NULL, ], ], 'ConflictException' => [ 'base' => '<p>There was a conflict when you attempted to modify a SageMaker entity such as an <code>Experiment</code> or <code>Artifact</code>.</p>', 'refs' => [], ], 'ContainerArgument' => [ 'base' => NULL, 'refs' => [ 'ContainerArguments$member' => NULL, 'MonitoringContainerArguments$member' => NULL, ], ], 'ContainerArguments' => [ 'base' => NULL, 'refs' => [ 'AppSpecification$ContainerArguments' => '<p>The arguments for a container used to run a processing job.</p>', ], ], 'ContainerConfig' => [ 'base' => '<p>The configuration used to run the application image container.</p>', 'refs' => [ 'CodeEditorAppImageConfig$ContainerConfig' => NULL, 'JupyterLabAppImageConfig$ContainerConfig' => NULL, ], ], 'ContainerDefinition' => [ 'base' => '<p>Describes the container, as part of model definition.</p>', 'refs' => [ 'ContainerDefinitionList$member' => NULL, 'CreateModelInput$PrimaryContainer' => '<p>The location of the primary docker image containing inference code, associated artifacts, and custom environment map that the inference code uses when the model is deployed for predictions. </p>', 'DescribeModelOutput$PrimaryContainer' => '<p>The location of the primary inference code, associated artifacts, and custom environment map that the inference code uses when it is deployed in production. </p>', 'Model$PrimaryContainer' => NULL, ], ], 'ContainerDefinitionList' => [ 'base' => NULL, 'refs' => [ 'CreateModelInput$Containers' => '<p>Specifies the containers in the inference pipeline.</p>', 'DescribeModelOutput$Containers' => '<p>The containers in the inference pipeline.</p>', 'Model$Containers' => '<p>The containers in the inference pipeline.</p>', ], ], 'ContainerEntrypoint' => [ 'base' => NULL, 'refs' => [ 'AppSpecification$ContainerEntrypoint' => '<p>The entrypoint for a container used to run a processing job.</p>', 'DataQualityAppSpecification$ContainerEntrypoint' => '<p>The entrypoint for a container used to run a monitoring job.</p>', 'ModelQualityAppSpecification$ContainerEntrypoint' => '<p>Specifies the entrypoint for a container that the monitoring job runs.</p>', 'MonitoringAppSpecification$ContainerEntrypoint' => '<p>Specifies the entrypoint for a container used to run the monitoring job.</p>', ], ], 'ContainerEntrypointString' => [ 'base' => NULL, 'refs' => [ 'ContainerEntrypoint$member' => NULL, ], ], 'ContainerHostname' => [ 'base' => NULL, 'refs' => [ 'ContainerDefinition$ContainerHostname' => '<p>This parameter is ignored for models that contain only a <code>PrimaryContainer</code>.</p> <p>When a <code>ContainerDefinition</code> is part of an inference pipeline, the value of the parameter uniquely identifies the container for the purposes of logging and metrics. For information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/inference-pipeline-logs-metrics.html">Use Logs and Metrics to Monitor an Inference Pipeline</a>. If you don\'t specify a value for this parameter for a <code>ContainerDefinition</code> that is part of an inference pipeline, a unique name is automatically assigned based on the position of the <code>ContainerDefinition</code> in the pipeline. If you specify a value for the <code>ContainerHostName</code> for any <code>ContainerDefinition</code> that is part of an inference pipeline, you must specify a value for the <code>ContainerHostName</code> parameter of every <code>ContainerDefinition</code> in that pipeline.</p>', 'ModelPackageContainerDefinition$ContainerHostname' => '<p>The DNS host name for the Docker container.</p>', ], ], 'ContainerImage' => [ 'base' => NULL, 'refs' => [ 'AutoMLContainerDefinition$Image' => '<p>The Amazon Elastic Container Registry (Amazon ECR) path of the container. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ContainerDefinition.html"> ContainerDefinition</a>.</p>', 'ContainerDefinition$Image' => '<p>The path where inference code is stored. This can be either in Amazon EC2 Container Registry or in a Docker registry that is accessible from the same VPC that you configure for your endpoint. If you are using your own custom algorithm instead of an algorithm provided by SageMaker, the inference code must meet SageMaker requirements. SageMaker supports both <code>registry/repository[:tag]</code> and <code>registry/repository[@digest]</code> image path formats. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html">Using Your Own Algorithms with Amazon SageMaker</a>. </p> <note> <p>The model artifacts in an Amazon S3 bucket and the Docker image for inference container in Amazon EC2 Container Registry must be in the same region as the model or endpoint you are creating.</p> </note>', 'DeployedImage$SpecifiedImage' => '<p>The image path you specified when you created the model.</p>', 'DeployedImage$ResolvedImage' => '<p>The specific digest path of the image hosted in this <code>ProductionVariant</code>.</p>', 'InferenceComponentContainerSpecification$Image' => '<p>The Amazon Elastic Container Registry (Amazon ECR) path where the Docker image for the model is stored.</p>', 'ModelPackageContainerDefinition$Image' => '<p>The Amazon EC2 Container Registry (Amazon ECR) path where inference code is stored.</p> <p>If you are using your own custom algorithm instead of an algorithm provided by SageMaker, the inference code must meet SageMaker requirements. SageMaker supports both <code>registry/repository[:tag]</code> and <code>registry/repository[@digest]</code> image path formats. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html">Using Your Own Algorithms with Amazon SageMaker</a>.</p>', 'TrainingSpecification$TrainingImage' => '<p>The Amazon ECR registry path of the Docker image that contains the training algorithm.</p>', ], ], 'ContainerMode' => [ 'base' => NULL, 'refs' => [ 'ContainerDefinition$Mode' => '<p>Whether the container hosts a single model or multiple models.</p>', ], ], 'ContentClassifier' => [ 'base' => NULL, 'refs' => [ 'ContentClassifiers$member' => NULL, ], ], 'ContentClassifiers' => [ 'base' => NULL, 'refs' => [ 'LabelingJobDataAttributes$ContentClassifiers' => '<p>Declares that your content is free of personally identifiable information or adult content. SageMaker may restrict the Amazon Mechanical Turk workers that can view your task based on this information.</p>', ], ], 'ContentColumn' => [ 'base' => NULL, 'refs' => [ 'TextClassificationJobConfig$ContentColumn' => '<p>The name of the column used to provide the sentences to be classified. It should not be the same as the target column.</p>', ], ], 'ContentDigest' => [ 'base' => NULL, 'refs' => [ 'FileSource$ContentDigest' => '<p>The digest of the file source.</p>', 'MetricsSource$ContentDigest' => '<p>The hash key used for the metrics source.</p>', ], ], 'ContentType' => [ 'base' => NULL, 'refs' => [ 'AutoMLChannel$ContentType' => '<p>The content type of the data from the input source. You can use <code>text/csv;header=present</code> or <code>x-application/vnd.amazon+parquet</code>. The default value is <code>text/csv;header=present</code>.</p>', 'AutoMLJobChannel$ContentType' => '<p>The content type of the data from the input source. The following are the allowed content types for different problems:</p> <ul> <li> <p>For tabular problem types: <code>text/csv;header=present</code> or <code>x-application/vnd.amazon+parquet</code>. The default value is <code>text/csv;header=present</code>.</p> </li> <li> <p>For image classification: <code>image/png</code>, <code>image/jpeg</code>, or <code>image/*</code>. The default value is <code>image/*</code>.</p> </li> <li> <p>For text classification: <code>text/csv;header=present</code> or <code>x-application/vnd.amazon+parquet</code>. The default value is <code>text/csv;header=present</code>.</p> </li> <li> <p>For time-series forecasting: <code>text/csv;header=present</code> or <code>x-application/vnd.amazon+parquet</code>. The default value is <code>text/csv;header=present</code>.</p> </li> <li> <p>For text generation (LLMs fine-tuning): <code>text/csv;header=present</code> or <code>x-application/vnd.amazon+parquet</code>. The default value is <code>text/csv;header=present</code>.</p> </li> </ul>', 'Channel$ContentType' => '<p>The MIME type of the data.</p>', 'ContentTypes$member' => NULL, 'FileSource$ContentType' => '<p>The type of content stored in the file source.</p>', 'MetricsSource$ContentType' => '<p>The metric source content type.</p>', 'TransformInput$ContentType' => '<p>The multipurpose internet mail extension (MIME) type of the data. Amazon SageMaker uses the MIME type with each http call to transfer data to the transform job.</p>', ], ], 'ContentTypes' => [ 'base' => NULL, 'refs' => [ 'AdditionalInferenceSpecificationDefinition$SupportedContentTypes' => '<p>The supported MIME types for the input data.</p>', 'ChannelSpecification$SupportedContentTypes' => '<p>The supported MIME types for the data.</p>', 'InferenceSpecification$SupportedContentTypes' => '<p>The supported MIME types for the input data.</p>', ], ], 'ContextArn' => [ 'base' => NULL, 'refs' => [ 'ContextSummary$ContextArn' => '<p>The Amazon Resource Name (ARN) of the context.</p>', 'CreateContextResponse$ContextArn' => '<p>The Amazon Resource Name (ARN) of the context.</p>', 'DeleteContextResponse$ContextArn' => '<p>The Amazon Resource Name (ARN) of the context.</p>', 'DescribeContextResponse$ContextArn' => '<p>The Amazon Resource Name (ARN) of the context.</p>', 'UpdateContextResponse$ContextArn' => '<p>The Amazon Resource Name (ARN) of the context.</p>', ], ], 'ContextName' => [ 'base' => NULL, 'refs' => [ 'ContextSummary$ContextName' => '<p>The name of the context.</p>', 'CreateContextRequest$ContextName' => '<p>The name of the context. Must be unique to your account in an Amazon Web Services Region.</p>', 'DeleteContextRequest$ContextName' => '<p>The name of the context to delete.</p>', 'DescribeContextResponse$ContextName' => '<p>The name of the context.</p>', 'UpdateContextRequest$ContextName' => '<p>The name of the context to update.</p>', ], ], 'ContextNameOrArn' => [ 'base' => NULL, 'refs' => [ 'DescribeContextRequest$ContextName' => '<p>The name of the context to describe.</p>', ], ], 'ContextSource' => [ 'base' => '<p>A structure describing the source of a context.</p>', 'refs' => [ 'ContextSummary$Source' => '<p>The source of the context.</p>', 'CreateContextRequest$Source' => '<p>The source type, ID, and URI.</p>', 'DescribeContextResponse$Source' => '<p>The source of the context.</p>', ], ], 'ContextSummaries' => [ 'base' => NULL, 'refs' => [ 'ListContextsResponse$ContextSummaries' => '<p>A list of contexts and their properties.</p>', ], ], 'ContextSummary' => [ 'base' => '<p>Lists a summary of the properties of a context. A context provides a logical grouping of other entities.</p>', 'refs' => [ 'ContextSummaries$member' => NULL, ], ], 'ContinuousParameterRange' => [ 'base' => '<p>A list of continuous hyperparameters to tune.</p>', 'refs' => [ 'ContinuousParameterRanges$member' => NULL, ], ], 'ContinuousParameterRangeSpecification' => [ 'base' => '<p>Defines the possible values for a continuous hyperparameter.</p>', 'refs' => [ 'ParameterRange$ContinuousParameterRangeSpecification' => '<p>A <code>ContinuousParameterRangeSpecification</code> object that defines the possible values for a continuous hyperparameter.</p>', ], ], 'ContinuousParameterRanges' => [ 'base' => NULL, 'refs' => [ 'ParameterRanges$ContinuousParameterRanges' => '<p>The array of <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ContinuousParameterRange.html">ContinuousParameterRange</a> objects that specify ranges of continuous hyperparameters that a hyperparameter tuning job searches.</p>', ], ], 'ConvergenceDetected' => [ 'base' => '<p>A flag to indicating that automatic model tuning (AMT) has detected model convergence, defined as a lack of significant improvement (1% or less) against an objective metric.</p>', 'refs' => [ 'TuningJobCompletionCriteria$ConvergenceDetected' => '<p>A flag to top your hyperparameter tuning job if automatic model tuning (AMT) has detected that your model has converged as evaluated against your objective function.</p>', ], ], 'CountryCode' => [ 'base' => NULL, 'refs' => [ 'HolidayConfigAttributes$CountryCode' => '<p>The country code for the holiday calendar.</p> <p>For the list of public holiday calendars supported by AutoML job V2, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-timeseries-forecasting-holiday-calendars.html#holiday-country-codes">Country Codes</a>. Use the country code corresponding to the country of your choice.</p>', ], ], 'CreateActionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateActionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateAlgorithmInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateAlgorithmOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateAppImageConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAppImageConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateAppRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAppResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateArtifactRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateArtifactResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateAutoMLJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAutoMLJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateAutoMLJobV2Request' => [ 'base' => NULL, 'refs' => [], ], 'CreateAutoMLJobV2Response' => [ 'base' => NULL, 'refs' => [], ], 'CreateClusterRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateClusterResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateCodeRepositoryInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateCodeRepositoryOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateCompilationJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateCompilationJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateContextRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateContextResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateDataQualityJobDefinitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDataQualityJobDefinitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateDeviceFleetRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDomainRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDomainResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateEdgeDeploymentPlanRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateEdgeDeploymentPlanResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateEdgeDeploymentStageRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateEdgePackagingJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateEndpointConfigInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateEndpointConfigOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateEndpointInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateEndpointOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateExperimentRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateExperimentResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateFeatureGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateFeatureGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateFlowDefinitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateFlowDefinitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateHubContentReferenceRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateHubContentReferenceResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateHubRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateHubResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateHumanTaskUiRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateHumanTaskUiResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateHyperParameterTuningJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateHyperParameterTuningJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateImageRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateImageResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateImageVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateImageVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateInferenceComponentInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateInferenceComponentOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateInferenceExperimentRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateInferenceExperimentResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateInferenceRecommendationsJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateInferenceRecommendationsJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateLabelingJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateLabelingJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateMlflowTrackingServerRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateMlflowTrackingServerResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateModelBiasJobDefinitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateModelBiasJobDefinitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateModelCardExportJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateModelCardExportJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateModelCardRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateModelCardResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateModelExplainabilityJobDefinitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateModelExplainabilityJobDefinitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateModelInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateModelOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateModelPackageGroupInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateModelPackageGroupOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateModelPackageInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateModelPackageOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateModelQualityJobDefinitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateModelQualityJobDefinitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateMonitoringScheduleRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateMonitoringScheduleResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateNotebookInstanceInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateNotebookInstanceLifecycleConfigInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateNotebookInstanceLifecycleConfigOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateNotebookInstanceOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateOptimizationJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateOptimizationJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreatePipelineRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreatePipelineResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreatePresignedDomainUrlRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreatePresignedDomainUrlResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreatePresignedMlflowTrackingServerUrlRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreatePresignedMlflowTrackingServerUrlResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreatePresignedNotebookInstanceUrlInput' => [ 'base' => NULL, 'refs' => [], ], 'CreatePresignedNotebookInstanceUrlOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateProcessingJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateProcessingJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateProjectInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateProjectOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateSpaceRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSpaceResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateStudioLifecycleConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateStudioLifecycleConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateTrainingJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTrainingJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateTransformJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTransformJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateTrialComponentRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTrialComponentResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateTrialRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTrialResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateUserProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateUserProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateWorkforceRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateWorkforceResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateWorkteamRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateWorkteamResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreationTime' => [ 'base' => NULL, 'refs' => [ 'AlgorithmSummary$CreationTime' => '<p>A timestamp that shows when the algorithm was created.</p>', 'AppDetails$CreationTime' => '<p>The creation time.</p>', 'BatchDescribeModelPackageSummary$CreationTime' => '<p>The creation time of the mortgage package summary.</p>', 'CodeRepositorySummary$CreationTime' => '<p>The date and time that the Git repository was created.</p>', 'CompilationJobSummary$CreationTime' => '<p>The time when the model compilation job was created.</p>', 'DescribeAlgorithmOutput$CreationTime' => '<p>A timestamp specifying when the algorithm was created.</p>', 'DescribeCodeRepositoryOutput$CreationTime' => '<p>The date and time that the repository was created.</p>', 'DescribeCompilationJobResponse$CreationTime' => '<p>The time that the model compilation job was created.</p>', 'DescribeDomainResponse$CreationTime' => '<p>The creation time.</p>', 'DescribeFeatureGroupResponse$CreationTime' => '<p>A timestamp indicating when SageMaker created the <code>FeatureGroup</code>.</p>', 'DescribeFeatureMetadataResponse$CreationTime' => '<p>A timestamp indicating when the feature was created.</p>', 'DescribeInferenceRecommendationsJobResponse$CreationTime' => '<p>A timestamp that shows when the job was created.</p>', 'DescribeModelPackageGroupOutput$CreationTime' => '<p>The time that the model group was created.</p>', 'DescribeModelPackageOutput$CreationTime' => '<p>A timestamp specifying when the model package was created.</p>', 'DescribeNotebookInstanceLifecycleConfigOutput$CreationTime' => '<p>A timestamp that tells when the lifecycle configuration was created.</p>', 'DescribeNotebookInstanceOutput$CreationTime' => '<p>A timestamp. Use this parameter to return the time when the notebook instance was created</p>', 'DescribeOptimizationJobResponse$CreationTime' => '<p>The time when you created the optimization job.</p>', 'DescribeSpaceResponse$CreationTime' => '<p>The creation time.</p>', 'DescribeUserProfileResponse$CreationTime' => '<p>The creation time.</p>', 'DomainDetails$CreationTime' => '<p>The creation time.</p>', 'FeatureGroup$CreationTime' => '<p>The time a <code>FeatureGroup</code> was created.</p>', 'FeatureMetadata$CreationTime' => '<p>A timestamp indicating when the feature was created.</p>', 'InferenceRecommendationsJob$CreationTime' => '<p>A timestamp that shows when the job was created.</p>', 'ListAlgorithmsInput$CreationTimeAfter' => '<p>A filter that returns only algorithms created after the specified time (timestamp).</p>', 'ListAlgorithmsInput$CreationTimeBefore' => '<p>A filter that returns only algorithms created before the specified time (timestamp).</p>', 'ListCodeRepositoriesInput$CreationTimeAfter' => '<p>A filter that returns only Git repositories that were created after the specified time.</p>', 'ListCodeRepositoriesInput$CreationTimeBefore' => '<p>A filter that returns only Git repositories that were created before the specified time.</p>', 'ListCompilationJobsRequest$CreationTimeAfter' => '<p>A filter that returns the model compilation jobs that were created after a specified time. </p>', 'ListCompilationJobsRequest$CreationTimeBefore' => '<p>A filter that returns the model compilation jobs that were created before a specified time.</p>', 'ListFeatureGroupsRequest$CreationTimeAfter' => '<p>Use this parameter to search for <code>FeatureGroups</code>s created after a specific date and time.</p>', 'ListFeatureGroupsRequest$CreationTimeBefore' => '<p>Use this parameter to search for <code>FeatureGroups</code>s created before a specific date and time.</p>', 'ListInferenceRecommendationsJobsRequest$CreationTimeAfter' => '<p>A filter that returns only jobs created after the specified time (timestamp).</p>', 'ListInferenceRecommendationsJobsRequest$CreationTimeBefore' => '<p>A filter that returns only jobs created before the specified time (timestamp).</p>', 'ListModelPackageGroupsInput$CreationTimeAfter' => '<p>A filter that returns only model groups created after the specified time.</p>', 'ListModelPackageGroupsInput$CreationTimeBefore' => '<p>A filter that returns only model groups created before the specified time.</p>', 'ListModelPackagesInput$CreationTimeAfter' => '<p>A filter that returns only model packages created after the specified time (timestamp).</p>', 'ListModelPackagesInput$CreationTimeBefore' => '<p>A filter that returns only model packages created before the specified time (timestamp).</p>', 'ListNotebookInstanceLifecycleConfigsInput$CreationTimeBefore' => '<p>A filter that returns only lifecycle configurations that were created before the specified time (timestamp).</p>', 'ListNotebookInstanceLifecycleConfigsInput$CreationTimeAfter' => '<p>A filter that returns only lifecycle configurations that were created after the specified time (timestamp).</p>', 'ListNotebookInstancesInput$CreationTimeBefore' => '<p>A filter that returns only notebook instances that were created before the specified time (timestamp). </p>', 'ListNotebookInstancesInput$CreationTimeAfter' => '<p>A filter that returns only notebook instances that were created after the specified time (timestamp).</p>', 'ListOptimizationJobsRequest$CreationTimeAfter' => '<p>Filters the results to only those optimization jobs that were created after the specified time.</p>', 'ListOptimizationJobsRequest$CreationTimeBefore' => '<p>Filters the results to only those optimization jobs that were created before the specified time.</p>', 'ModelPackage$CreationTime' => '<p>The time that the model package was created.</p>', 'ModelPackageGroup$CreationTime' => '<p>The time that the model group was created.</p>', 'ModelPackageGroupSummary$CreationTime' => '<p>The time that the model group was created.</p>', 'ModelPackageSummary$CreationTime' => '<p>A timestamp that shows when the model package was created.</p>', 'NotebookInstanceLifecycleConfigSummary$CreationTime' => '<p>A timestamp that tells when the lifecycle configuration was created.</p>', 'NotebookInstanceSummary$CreationTime' => '<p>A timestamp that shows when the notebook instance was created.</p>', 'OptimizationJobSummary$CreationTime' => '<p>The time when you created the optimization job.</p>', 'SpaceDetails$CreationTime' => '<p>The creation time.</p>', 'UserProfileDetails$CreationTime' => '<p>The creation time.</p>', ], ], 'CrossAccountFilterOption' => [ 'base' => NULL, 'refs' => [ 'ListModelPackageGroupsInput$CrossAccountFilterOption' => '<p>A filter that returns either model groups shared with you or model groups in your own account. When the value is <code>CrossAccount</code>, the results show the resources made discoverable to you from other accounts. When the value is <code>SameAccount</code> or <code>null</code>, the results show resources from your account. The default is <code>SameAccount</code>.</p>', 'SearchRequest$CrossAccountFilterOption' => '<p> A cross account filter option. When the value is <code>"CrossAccount"</code> the search results will only include resources made discoverable to you from other accounts. When the value is <code>"SameAccount"</code> or <code>null</code> the search results will only include resources from your account. Default is <code>null</code>. For more information on searching for resources made discoverable to your account, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/feature-store-cross-account-discoverability-use.html"> Search discoverable resources</a> in the SageMaker Developer Guide. The maximum number of <code>ResourceCatalog</code>s viewable is 1000. </p>', ], ], 'CsvContentType' => [ 'base' => NULL, 'refs' => [ 'CsvContentTypes$member' => NULL, ], ], 'CsvContentTypes' => [ 'base' => NULL, 'refs' => [ 'CaptureContentTypeHeader$CsvContentTypes' => '<p>The list of all content type headers that Amazon SageMaker will treat as CSV and capture accordingly.</p>', ], ], 'CustomFileSystem' => [ 'base' => '<p>A file system, created by you, that you assign to a user profile or space for an Amazon SageMaker Domain. Permitted users can access this file system in Amazon SageMaker Studio.</p>', 'refs' => [ 'CustomFileSystems$member' => NULL, ], ], 'CustomFileSystemConfig' => [ 'base' => '<p>The settings for assigning a custom file system to a user profile or space for an Amazon SageMaker Domain. Permitted users can access this file system in Amazon SageMaker Studio.</p>', 'refs' => [ 'CustomFileSystemConfigs$member' => NULL, ], ], 'CustomFileSystemConfigs' => [ 'base' => NULL, 'refs' => [ 'DefaultSpaceSettings$CustomFileSystemConfigs' => '<p>The settings for assigning a custom file system to a domain. Permitted users can access this file system in Amazon SageMaker Studio.</p>', 'UserSettings$CustomFileSystemConfigs' => '<p>The settings for assigning a custom file system to a user profile. Permitted users can access this file system in Amazon SageMaker Studio.</p>', ], ], 'CustomFileSystems' => [ 'base' => NULL, 'refs' => [ 'SpaceSettings$CustomFileSystems' => '<p>A file system, created by you, that you assign to a space for an Amazon SageMaker Domain. Permitted users can access this file system in Amazon SageMaker Studio.</p>', ], ], 'CustomImage' => [ 'base' => '<p>A custom SageMaker image. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/studio-byoi.html">Bring your own SageMaker image</a>.</p>', 'refs' => [ 'CustomImages$member' => NULL, ], ], 'CustomImageContainerArguments' => [ 'base' => NULL, 'refs' => [ 'ContainerConfig$ContainerArguments' => '<p>The arguments for the container when you\'re running the application.</p>', ], ], 'CustomImageContainerEntrypoint' => [ 'base' => NULL, 'refs' => [ 'ContainerConfig$ContainerEntrypoint' => '<p>The entrypoint used to run the application in the container.</p>', ], ], 'CustomImageContainerEnvironmentVariables' => [ 'base' => NULL, 'refs' => [ 'ContainerConfig$ContainerEnvironmentVariables' => '<p>The environment variables to set in the container</p>', ], ], 'CustomImages' => [ 'base' => NULL, 'refs' => [ 'CodeEditorAppSettings$CustomImages' => '<p>A list of custom SageMaker images that are configured to run as a Code Editor app.</p>', 'JupyterLabAppSettings$CustomImages' => '<p>A list of custom SageMaker images that are configured to run as a JupyterLab app.</p>', 'KernelGatewayAppSettings$CustomImages' => '<p>A list of custom SageMaker images that are configured to run as a KernelGateway app.</p>', 'RSessionAppSettings$CustomImages' => '<p>A list of custom SageMaker images that are configured to run as a RSession app.</p>', ], ], 'CustomPosixUserConfig' => [ 'base' => '<p>Details about the POSIX identity that is used for file system operations.</p>', 'refs' => [ 'DefaultSpaceSettings$CustomPosixUserConfig' => NULL, 'UserSettings$CustomPosixUserConfig' => '<p>Details about the POSIX identity that is used for file system operations.</p>', ], ], 'CustomerMetadataKey' => [ 'base' => NULL, 'refs' => [ 'CustomerMetadataKeyList$member' => NULL, 'CustomerMetadataMap$key' => NULL, ], ], 'CustomerMetadataKeyList' => [ 'base' => NULL, 'refs' => [ 'UpdateModelPackageInput$CustomerMetadataPropertiesToRemove' => '<p>The metadata properties associated with the model package versions to remove.</p>', ], ], 'CustomerMetadataMap' => [ 'base' => NULL, 'refs' => [ 'CreateModelPackageInput$CustomerMetadataProperties' => '<p>The metadata properties associated with the model package versions.</p>', 'DescribeModelPackageOutput$CustomerMetadataProperties' => '<p>The metadata properties associated with the model package versions.</p>', 'ModelPackage$CustomerMetadataProperties' => '<p>The metadata properties for the model package. </p>', 'UpdateModelPackageInput$CustomerMetadataProperties' => '<p>The metadata properties associated with the model package versions.</p>', ], ], 'CustomerMetadataValue' => [ 'base' => NULL, 'refs' => [ 'CustomerMetadataMap$value' => NULL, ], ], 'CustomizedMetricSpecification' => [ 'base' => '<p>A customized metric.</p>', 'refs' => [ 'MetricSpecification$Customized' => '<p>Information about a customized metric.</p>', ], ], 'DataCaptureConfig' => [ 'base' => '<p>Configuration to control how SageMaker captures inference data.</p>', 'refs' => [ 'CreateEndpointConfigInput$DataCaptureConfig' => NULL, 'DescribeEndpointConfigOutput$DataCaptureConfig' => NULL, ], ], 'DataCaptureConfigSummary' => [ 'base' => '<p>The currently active data capture configuration used by your Endpoint.</p>', 'refs' => [ 'DescribeEndpointOutput$DataCaptureConfig' => NULL, 'Endpoint$DataCaptureConfig' => NULL, ], ], 'DataCatalogConfig' => [ 'base' => '<p>The meta data of the Glue table which serves as data catalog for the <code>OfflineStore</code>. </p>', 'refs' => [ 'OfflineStoreConfig$DataCatalogConfig' => '<p>The meta data of the Glue table that is autogenerated when an <code>OfflineStore</code> is created. </p>', ], ], 'DataDistributionType' => [ 'base' => NULL, 'refs' => [ 'DatasetDefinition$DataDistributionType' => '<p>Whether the generated dataset is <code>FullyReplicated</code> or <code>ShardedByS3Key</code> (default).</p>', ], ], 'DataExplorationNotebookLocation' => [ 'base' => NULL, 'refs' => [ 'AutoMLJobArtifacts$DataExplorationNotebookLocation' => '<p>The URL of the notebook location.</p>', ], ], 'DataInputConfig' => [ 'base' => NULL, 'refs' => [ 'DerivedInformation$DerivedDataInputConfig' => '<p>The data input configuration that SageMaker Neo automatically derived for the model. When SageMaker Neo derives this information, you don\'t need to specify the data input configuration when you create a compilation job.</p>', 'InputConfig$DataInputConfig' => '<p>Specifies the name and shape of the expected data inputs for your trained model with a JSON dictionary form. The data inputs are <code>Framework</code> specific. </p> <ul> <li> <p> <code>TensorFlow</code>: You must specify the name and shape (NHWC format) of the expected data inputs using a dictionary format for your trained model. The dictionary formats required for the console and CLI are different.</p> <ul> <li> <p>Examples for one input:</p> <ul> <li> <p>If using the console, <code>{"input":[1,1024,1024,3]}</code> </p> </li> <li> <p>If using the CLI, <code>{\\"input\\":[1,1024,1024,3]}</code> </p> </li> </ul> </li> <li> <p>Examples for two inputs:</p> <ul> <li> <p>If using the console, <code>{"data1": [1,28,28,1], "data2":[1,28,28,1]}</code> </p> </li> <li> <p>If using the CLI, <code>{\\"data1\\": [1,28,28,1], \\"data2\\":[1,28,28,1]}</code> </p> </li> </ul> </li> </ul> </li> <li> <p> <code>KERAS</code>: You must specify the name and shape (NCHW format) of expected data inputs using a dictionary format for your trained model. Note that while Keras model artifacts should be uploaded in NHWC (channel-last) format, <code>DataInputConfig</code> should be specified in NCHW (channel-first) format. The dictionary formats required for the console and CLI are different.</p> <ul> <li> <p>Examples for one input:</p> <ul> <li> <p>If using the console, <code>{"input_1":[1,3,224,224]}</code> </p> </li> <li> <p>If using the CLI, <code>{\\"input_1\\":[1,3,224,224]}</code> </p> </li> </ul> </li> <li> <p>Examples for two inputs:</p> <ul> <li> <p>If using the console, <code>{"input_1": [1,3,224,224], "input_2":[1,3,224,224]} </code> </p> </li> <li> <p>If using the CLI, <code>{\\"input_1\\": [1,3,224,224], \\"input_2\\":[1,3,224,224]}</code> </p> </li> </ul> </li> </ul> </li> <li> <p> <code>MXNET/ONNX/DARKNET</code>: You must specify the name and shape (NCHW format) of the expected data inputs in order using a dictionary format for your trained model. The dictionary formats required for the console and CLI are different.</p> <ul> <li> <p>Examples for one input:</p> <ul> <li> <p>If using the console, <code>{"data":[1,3,1024,1024]}</code> </p> </li> <li> <p>If using the CLI, <code>{\\"data\\":[1,3,1024,1024]}</code> </p> </li> </ul> </li> <li> <p>Examples for two inputs:</p> <ul> <li> <p>If using the console, <code>{"var1": [1,1,28,28], "var2":[1,1,28,28]} </code> </p> </li> <li> <p>If using the CLI, <code>{\\"var1\\": [1,1,28,28], \\"var2\\":[1,1,28,28]}</code> </p> </li> </ul> </li> </ul> </li> <li> <p> <code>PyTorch</code>: You can either specify the name and shape (NCHW format) of expected data inputs in order using a dictionary format for your trained model or you can specify the shape only using a list format. The dictionary formats required for the console and CLI are different. The list formats for the console and CLI are the same.</p> <ul> <li> <p>Examples for one input in dictionary format:</p> <ul> <li> <p>If using the console, <code>{"input0":[1,3,224,224]}</code> </p> </li> <li> <p>If using the CLI, <code>{\\"input0\\":[1,3,224,224]}</code> </p> </li> </ul> </li> <li> <p>Example for one input in list format: <code>[[1,3,224,224]]</code> </p> </li> <li> <p>Examples for two inputs in dictionary format:</p> <ul> <li> <p>If using the console, <code>{"input0":[1,3,224,224], "input1":[1,3,224,224]}</code> </p> </li> <li> <p>If using the CLI, <code>{\\"input0\\":[1,3,224,224], \\"input1\\":[1,3,224,224]} </code> </p> </li> </ul> </li> <li> <p>Example for two inputs in list format: <code>[[1,3,224,224], [1,3,224,224]]</code> </p> </li> </ul> </li> <li> <p> <code>XGBOOST</code>: input data name and shape are not needed.</p> </li> </ul> <p> <code>DataInputConfig</code> supports the following parameters for <code>CoreML</code> <code>TargetDevice</code> (ML Model format):</p> <ul> <li> <p> <code>shape</code>: Input shape, for example <code>{"input_1": {"shape": [1,224,224,3]}}</code>. In addition to static input shapes, CoreML converter supports Flexible input shapes:</p> <ul> <li> <p>Range Dimension. You can use the Range Dimension feature if you know the input shape will be within some specific interval in that dimension, for example: <code>{"input_1": {"shape": ["1..10", 224, 224, 3]}}</code> </p> </li> <li> <p>Enumerated shapes. Sometimes, the models are trained to work only on a select set of inputs. You can enumerate all supported input shapes, for example: <code>{"input_1": {"shape": [[1, 224, 224, 3], [1, 160, 160, 3]]}}</code> </p> </li> </ul> </li> <li> <p> <code>default_shape</code>: Default input shape. You can set a default shape during conversion for both Range Dimension and Enumerated Shapes. For example <code>{"input_1": {"shape": ["1..10", 224, 224, 3], "default_shape": [1, 224, 224, 3]}}</code> </p> </li> <li> <p> <code>type</code>: Input type. Allowed values: <code>Image</code> and <code>Tensor</code>. By default, the converter generates an ML Model with inputs of type Tensor (MultiArray). User can set input type to be Image. Image input type requires additional input parameters such as <code>bias</code> and <code>scale</code>.</p> </li> <li> <p> <code>bias</code>: If the input type is an Image, you need to provide the bias vector.</p> </li> <li> <p> <code>scale</code>: If the input type is an Image, you need to provide a scale factor.</p> </li> </ul> <p>CoreML <code>ClassifierConfig</code> parameters can be specified using <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_OutputConfig.html">OutputConfig</a> <code>CompilerOptions</code>. CoreML converter supports Tensorflow and PyTorch models. CoreML conversion examples:</p> <ul> <li> <p>Tensor type input:</p> <ul> <li> <p> <code>"DataInputConfig": {"input_1": {"shape": [[1,224,224,3], [1,160,160,3]], "default_shape": [1,224,224,3]}}</code> </p> </li> </ul> </li> <li> <p>Tensor type input without input name (PyTorch):</p> <ul> <li> <p> <code>"DataInputConfig": [{"shape": [[1,3,224,224], [1,3,160,160]], "default_shape": [1,3,224,224]}]</code> </p> </li> </ul> </li> <li> <p>Image type input:</p> <ul> <li> <p> <code>"DataInputConfig": {"input_1": {"shape": [[1,224,224,3], [1,160,160,3]], "default_shape": [1,224,224,3], "type": "Image", "bias": [-1,-1,-1], "scale": 0.007843137255}}</code> </p> </li> <li> <p> <code>"CompilerOptions": {"class_labels": "imagenet_labels_1000.txt"}</code> </p> </li> </ul> </li> <li> <p>Image type input without input name (PyTorch):</p> <ul> <li> <p> <code>"DataInputConfig": [{"shape": [[1,3,224,224], [1,3,160,160]], "default_shape": [1,3,224,224], "type": "Image", "bias": [-1,-1,-1], "scale": 0.007843137255}]</code> </p> </li> <li> <p> <code>"CompilerOptions": {"class_labels": "imagenet_labels_1000.txt"}</code> </p> </li> </ul> </li> </ul> <p>Depending on the model format, <code>DataInputConfig</code> requires the following parameters for <code>ml_eia2</code> <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_OutputConfig.html#sagemaker-Type-OutputConfig-TargetDevice">OutputConfig:TargetDevice</a>.</p> <ul> <li> <p>For TensorFlow models saved in the SavedModel format, specify the input names from <code>signature_def_key</code> and the input model shapes for <code>DataInputConfig</code>. Specify the <code>signature_def_key</code> in <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_OutputConfig.html#sagemaker-Type-OutputConfig-CompilerOptions"> <code>OutputConfig:CompilerOptions</code> </a> if the model does not use TensorFlow\'s default signature def key. For example:</p> <ul> <li> <p> <code>"DataInputConfig": {"inputs": [1, 224, 224, 3]}</code> </p> </li> <li> <p> <code>"CompilerOptions": {"signature_def_key": "serving_custom"}</code> </p> </li> </ul> </li> <li> <p>For TensorFlow models saved as a frozen graph, specify the input tensor names and shapes in <code>DataInputConfig</code> and the output tensor names for <code>output_names</code> in <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_OutputConfig.html#sagemaker-Type-OutputConfig-CompilerOptions"> <code>OutputConfig:CompilerOptions</code> </a>. For example:</p> <ul> <li> <p> <code>"DataInputConfig": {"input_tensor:0": [1, 224, 224, 3]}</code> </p> </li> <li> <p> <code>"CompilerOptions": {"output_names": ["output_tensor:0"]}</code> </p> </li> </ul> </li> </ul>', 'ModelInput$DataInputConfig' => '<p>The input configuration object for the model.</p>', ], ], 'DataProcessing' => [ 'base' => '<p>The data structure used to specify the data to be used for inference in a batch transform job and to associate the data that is relevant to the prediction results in the output. The input filter provided allows you to exclude input data that is not needed for inference in a batch transform job. The output filter provided allows you to include input data relevant to interpreting the predictions in the output from the job. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html">Associate Prediction Results with their Corresponding Input Records</a>.</p>', 'refs' => [ 'CreateTransformJobRequest$DataProcessing' => '<p>The data structure used to specify the data to be used for inference in a batch transform job and to associate the data that is relevant to the prediction results in the output. The input filter provided allows you to exclude input data that is not needed for inference in a batch transform job. The output filter provided allows you to include input data relevant to interpreting the predictions in the output from the job. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html">Associate Prediction Results with their Corresponding Input Records</a>.</p>', 'DescribeTransformJobResponse$DataProcessing' => NULL, 'TransformJob$DataProcessing' => NULL, ], ], 'DataQualityAppSpecification' => [ 'base' => '<p>Information about the container that a data quality monitoring job runs.</p>', 'refs' => [ 'CreateDataQualityJobDefinitionRequest$DataQualityAppSpecification' => '<p>Specifies the container that runs the monitoring job.</p>', 'DescribeDataQualityJobDefinitionResponse$DataQualityAppSpecification' => '<p>Information about the container that runs the data quality monitoring job.</p>', ], ], 'DataQualityBaselineConfig' => [ 'base' => '<p>Configuration for monitoring constraints and monitoring statistics. These baseline resources are compared against the results of the current job from the series of jobs scheduled to collect data periodically.</p>', 'refs' => [ 'CreateDataQualityJobDefinitionRequest$DataQualityBaselineConfig' => '<p>Configures the constraints and baselines for the monitoring job.</p>', 'DescribeDataQualityJobDefinitionResponse$DataQualityBaselineConfig' => '<p>The constraints and baselines for the data quality monitoring job definition.</p>', ], ], 'DataQualityJobInput' => [ 'base' => '<p>The input for the data quality monitoring job. Currently endpoints are supported for input.</p>', 'refs' => [ 'CreateDataQualityJobDefinitionRequest$DataQualityJobInput' => '<p>A list of inputs for the monitoring job. Currently endpoints are supported as monitoring inputs.</p>', 'DescribeDataQualityJobDefinitionResponse$DataQualityJobInput' => '<p>The list of inputs for the data quality monitoring job. Currently endpoints are supported.</p>', ], ], 'DataSource' => [ 'base' => '<p>Describes the location of the channel data.</p>', 'refs' => [ 'Channel$DataSource' => '<p>The location of the channel data.</p>', ], ], 'DataSourceName' => [ 'base' => NULL, 'refs' => [ 'IdentityProviderOAuthSetting$DataSourceName' => '<p>The name of the data source that you\'re connecting to. Canvas currently supports OAuth for Snowflake and Salesforce Data Cloud.</p>', ], ], 'Database' => [ 'base' => NULL, 'refs' => [ 'DataCatalogConfig$Database' => '<p>The name of the Glue table database.</p>', ], ], 'DatasetDefinition' => [ 'base' => '<p>Configuration for Dataset Definition inputs. The Dataset Definition input must specify exactly one of either <code>AthenaDatasetDefinition</code> or <code>RedshiftDatasetDefinition</code> types.</p>', 'refs' => [ 'ProcessingInput$DatasetDefinition' => '<p>Configuration for a Dataset Definition input. </p>', ], ], 'DebugHookConfig' => [ 'base' => '<p>Configuration information for the Amazon SageMaker Debugger hook parameters, metric and tensor collections, and storage paths. To learn more about how to configure the <code>DebugHookConfig</code> parameter, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/debugger-createtrainingjob-api.html">Use the SageMaker and Debugger Configuration API Operations to Create, Update, and Debug Your Training Job</a>.</p>', 'refs' => [ 'CreateTrainingJobRequest$DebugHookConfig' => NULL, 'DescribeTrainingJobResponse$DebugHookConfig' => NULL, 'TrainingJob$DebugHookConfig' => NULL, ], ], 'DebugRuleConfiguration' => [ 'base' => '<p>Configuration information for SageMaker Debugger rules for debugging. To learn more about how to configure the <code>DebugRuleConfiguration</code> parameter, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/debugger-createtrainingjob-api.html">Use the SageMaker and Debugger Configuration API Operations to Create, Update, and Debug Your Training Job</a>.</p>', 'refs' => [ 'DebugRuleConfigurations$member' => NULL, ], ], 'DebugRuleConfigurations' => [ 'base' => NULL, 'refs' => [ 'CreateTrainingJobRequest$DebugRuleConfigurations' => '<p>Configuration information for Amazon SageMaker Debugger rules for debugging output tensors.</p>', 'DescribeTrainingJobResponse$DebugRuleConfigurations' => '<p>Configuration information for Amazon SageMaker Debugger rules for debugging output tensors.</p>', 'TrainingJob$DebugRuleConfigurations' => '<p>Information about the debug rule configuration.</p>', ], ], 'DebugRuleEvaluationStatus' => [ 'base' => '<p>Information about the status of the rule evaluation.</p>', 'refs' => [ 'DebugRuleEvaluationStatuses$member' => NULL, ], ], 'DebugRuleEvaluationStatuses' => [ 'base' => NULL, 'refs' => [ 'DescribeTrainingJobResponse$DebugRuleEvaluationStatuses' => '<p>Evaluation status of Amazon SageMaker Debugger rules for debugging on a training job.</p>', 'TrainingJob$DebugRuleEvaluationStatuses' => '<p>Information about the evaluation status of the rules for the training job.</p>', ], ], 'DefaultEbsStorageSettings' => [ 'base' => '<p>A collection of default EBS storage settings that apply to spaces created within a domain or user profile.</p>', 'refs' => [ 'DefaultSpaceStorageSettings$DefaultEbsStorageSettings' => '<p>The default EBS storage settings for a space.</p>', ], ], 'DefaultGid' => [ 'base' => NULL, 'refs' => [ 'FileSystemConfig$DefaultGid' => '<p>The default POSIX group ID (GID). If not specified, defaults to <code>100</code>.</p>', ], ], 'DefaultSpaceSettings' => [ 'base' => '<p>A collection of settings that apply to spaces created in the domain.</p>', 'refs' => [ 'CreateDomainRequest$DefaultSpaceSettings' => '<p>The default settings used to create a space.</p>', 'DescribeDomainResponse$DefaultSpaceSettings' => '<p>The default settings used to create a space.</p>', 'UpdateDomainRequest$DefaultSpaceSettings' => '<p>The default settings used to create a space within the domain.</p>', ], ], 'DefaultSpaceStorageSettings' => [ 'base' => '<p>The default storage settings for a space.</p>', 'refs' => [ 'DefaultSpaceSettings$SpaceStorageSettings' => NULL, 'UserSettings$SpaceStorageSettings' => '<p>The storage settings for a space.</p>', ], ], 'DefaultUid' => [ 'base' => NULL, 'refs' => [ 'FileSystemConfig$DefaultUid' => '<p>The default POSIX user ID (UID). If not specified, defaults to <code>1000</code>.</p>', ], ], 'DeleteActionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteActionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAlgorithmInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAppImageConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAppRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteArtifactRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteArtifactResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAssociationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteClusterRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteClusterResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteCodeRepositoryInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteCompilationJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteContextRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteContextResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDataQualityJobDefinitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDeviceFleetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDomainRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEdgeDeploymentPlanRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEdgeDeploymentStageRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEndpointConfigInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEndpointInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteExperimentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteExperimentResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFeatureGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFlowDefinitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFlowDefinitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteHubContentReferenceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteHubContentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteHubRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteHumanTaskUiRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteHumanTaskUiResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteHyperParameterTuningJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteImageRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteImageResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteImageVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteImageVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteInferenceComponentInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteInferenceExperimentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteInferenceExperimentResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMlflowTrackingServerRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMlflowTrackingServerResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteModelBiasJobDefinitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteModelCardRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteModelExplainabilityJobDefinitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteModelInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteModelPackageGroupInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteModelPackageGroupPolicyInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteModelPackageInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteModelQualityJobDefinitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMonitoringScheduleRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteNotebookInstanceInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteNotebookInstanceLifecycleConfigInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteOptimizationJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletePipelineRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletePipelineResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteProjectInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSpaceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStudioLifecycleConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTagsInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTagsOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTrialComponentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTrialComponentResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTrialRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTrialResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUserProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWorkforceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWorkforceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWorkteamRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWorkteamResponse' => [ 'base' => NULL, 'refs' => [], ], 'DependencyCopyPath' => [ 'base' => NULL, 'refs' => [ 'HubContentDependency$DependencyCopyPath' => '<p>The hub content dependency copy path.</p>', ], ], 'DependencyOriginPath' => [ 'base' => NULL, 'refs' => [ 'HubContentDependency$DependencyOriginPath' => '<p>The hub content dependency origin path.</p>', ], ], 'DeployedImage' => [ 'base' => '<p>Gets the Amazon EC2 Container Registry path of the docker image of the model that is hosted in this <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ProductionVariant.html">ProductionVariant</a>.</p> <p>If you used the <code>registry/repository[:tag]</code> form to specify the image path of the primary container when you created the model hosted in this <code>ProductionVariant</code>, the path resolves to a path of the form <code>registry/repository[@digest]</code>. A digest is a hash value that identifies a specific version of an image. For information about Amazon ECR paths, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/docker-pull-ecr-image.html">Pulling an Image</a> in the <i>Amazon ECR User Guide</i>.</p>', 'refs' => [ 'DeployedImages$member' => NULL, 'InferenceComponentContainerSpecificationSummary$DeployedImage' => NULL, ], ], 'DeployedImages' => [ 'base' => NULL, 'refs' => [ 'PendingProductionVariantSummary$DeployedImages' => '<p>An array of <code>DeployedImage</code> objects that specify the Amazon EC2 Container Registry paths of the inference images deployed on instances of this <code>ProductionVariant</code>.</p>', 'ProductionVariantSummary$DeployedImages' => '<p>An array of <code>DeployedImage</code> objects that specify the Amazon EC2 Container Registry paths of the inference images deployed on instances of this <code>ProductionVariant</code>.</p>', ], ], 'DeploymentConfig' => [ 'base' => '<p>The deployment configuration for an endpoint, which contains the desired deployment strategy and rollback configurations.</p>', 'refs' => [ 'CreateEndpointInput$DeploymentConfig' => NULL, 'DescribeEndpointOutput$LastDeploymentConfig' => '<p>The most recent deployment configuration for the endpoint.</p>', 'UpdateEndpointInput$DeploymentConfig' => '<p>The deployment configuration for an endpoint, which contains the desired deployment strategy and rollback configurations.</p>', ], ], 'DeploymentRecommendation' => [ 'base' => '<p>A set of recommended deployment configurations for the model. To get more advanced recommendations, see <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateInferenceRecommendationsJob.html">CreateInferenceRecommendationsJob</a> to create an inference recommendation job.</p>', 'refs' => [ 'DescribeModelOutput$DeploymentRecommendation' => '<p>A set of recommended deployment configurations for the model.</p>', 'Model$DeploymentRecommendation' => '<p>A set of recommended deployment configurations for the model.</p>', ], ], 'DeploymentStage' => [ 'base' => '<p>Contains information about a stage in an edge deployment plan.</p>', 'refs' => [ 'DeploymentStages$member' => NULL, ], ], 'DeploymentStageMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeEdgeDeploymentPlanRequest$MaxResults' => '<p>The maximum number of results to select (50 by default).</p>', ], ], 'DeploymentStageStatusSummaries' => [ 'base' => NULL, 'refs' => [ 'DescribeEdgeDeploymentPlanResponse$Stages' => '<p>List of stages in the edge deployment plan.</p>', ], ], 'DeploymentStageStatusSummary' => [ 'base' => '<p>Contains information summarizing the deployment stage results.</p>', 'refs' => [ 'DeploymentStageStatusSummaries$member' => NULL, ], ], 'DeploymentStages' => [ 'base' => NULL, 'refs' => [ 'CreateEdgeDeploymentPlanRequest$Stages' => '<p>List of stages of the edge deployment plan. The number of stages is limited to 10 per deployment.</p>', 'CreateEdgeDeploymentStageRequest$Stages' => '<p>List of stages to be added to the edge deployment plan.</p>', ], ], 'DeregisterDevicesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DerivedInformation' => [ 'base' => '<p>Information that SageMaker Neo automatically derived about the model.</p>', 'refs' => [ 'DescribeCompilationJobResponse$DerivedInformation' => '<p>Information that SageMaker Neo automatically derived about the model.</p>', ], ], 'DescribeActionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeActionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAlgorithmInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAlgorithmOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAppImageConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAppImageConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAppRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAppResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeArtifactRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeArtifactResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAutoMLJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAutoMLJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAutoMLJobV2Request' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAutoMLJobV2Response' => [ 'base' => NULL, 'refs' => [], ], 'DescribeClusterNodeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeClusterNodeResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeClusterRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeClusterResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCodeRepositoryInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCodeRepositoryOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCompilationJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCompilationJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeContextRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeContextResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDataQualityJobDefinitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDataQualityJobDefinitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDeviceFleetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDeviceFleetResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDeviceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDeviceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDomainRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDomainResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEdgeDeploymentPlanRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEdgeDeploymentPlanResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEdgePackagingJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEdgePackagingJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEndpointConfigInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEndpointConfigOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEndpointInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEndpointOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeExperimentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeExperimentResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFeatureGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFeatureGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFeatureMetadataRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFeatureMetadataResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFlowDefinitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFlowDefinitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeHubContentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeHubContentResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeHubRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeHubResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeHumanTaskUiRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeHumanTaskUiResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeHyperParameterTuningJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeHyperParameterTuningJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeImageRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeImageResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeImageVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeImageVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInferenceComponentInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInferenceComponentOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInferenceExperimentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInferenceExperimentResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInferenceRecommendationsJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInferenceRecommendationsJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLabelingJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLabelingJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLineageGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLineageGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMlflowTrackingServerRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMlflowTrackingServerResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeModelBiasJobDefinitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeModelBiasJobDefinitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeModelCardExportJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeModelCardExportJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeModelCardRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeModelCardResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeModelExplainabilityJobDefinitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeModelExplainabilityJobDefinitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeModelInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeModelOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeModelPackageGroupInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeModelPackageGroupOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeModelPackageInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeModelPackageOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeModelQualityJobDefinitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeModelQualityJobDefinitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMonitoringScheduleRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMonitoringScheduleResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeNotebookInstanceInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeNotebookInstanceLifecycleConfigInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeNotebookInstanceLifecycleConfigOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeNotebookInstanceOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeOptimizationJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeOptimizationJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribePipelineDefinitionForExecutionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribePipelineDefinitionForExecutionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribePipelineExecutionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribePipelineExecutionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribePipelineRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribePipelineResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeProcessingJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeProcessingJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeProjectInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeProjectOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSpaceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSpaceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStudioLifecycleConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStudioLifecycleConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSubscribedWorkteamRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSubscribedWorkteamResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTrainingJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTrainingJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTransformJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTransformJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTrialComponentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTrialComponentResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTrialRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTrialResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUserProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUserProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeWorkforceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeWorkforceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeWorkteamRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeWorkteamResponse' => [ 'base' => NULL, 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'CreateFeatureGroupRequest$Description' => '<p>A free-form description of a <code>FeatureGroup</code>.</p>', 'DescribeFeatureGroupResponse$Description' => '<p>A free form description of the feature group.</p>', 'FeatureGroup$Description' => '<p>A free form description of a <code>FeatureGroup</code>.</p>', ], ], 'DesiredWeightAndCapacity' => [ 'base' => '<p>Specifies weight and capacity values for a production variant.</p>', 'refs' => [ 'DesiredWeightAndCapacityList$member' => NULL, ], ], 'DesiredWeightAndCapacityList' => [ 'base' => NULL, 'refs' => [ 'UpdateEndpointWeightsAndCapacitiesInput$DesiredWeightsAndCapacities' => '<p>An object that provides new capacity and weight values for a variant.</p>', ], ], 'DestinationS3Uri' => [ 'base' => NULL, 'refs' => [ 'AsyncInferenceOutputConfig$S3OutputPath' => '<p>The Amazon S3 location to upload inference responses to.</p>', 'AsyncInferenceOutputConfig$S3FailurePath' => '<p>The Amazon S3 location to upload failure inference responses to.</p>', 'BatchTransformInput$DataCapturedDestinationS3Uri' => '<p>The Amazon S3 location being used to capture the data.</p>', 'DataCaptureConfig$DestinationS3Uri' => '<p>The Amazon S3 location used to capture the data.</p>', 'DataCaptureConfigSummary$DestinationS3Uri' => '<p>The Amazon S3 location being used to capture the data.</p>', 'InferenceExperimentDataStorageConfig$Destination' => '<p>The Amazon S3 bucket where the inference request and response data is stored. </p>', 'ProductionVariantCoreDumpConfig$DestinationS3Uri' => '<p>The Amazon S3 bucket to send the core dump to.</p>', ], ], 'DetailedAlgorithmStatus' => [ 'base' => NULL, 'refs' => [ 'AlgorithmStatusItem$Status' => '<p>The current status.</p>', ], ], 'DetailedModelPackageStatus' => [ 'base' => NULL, 'refs' => [ 'ModelPackageStatusItem$Status' => '<p>The current status.</p>', ], ], 'Device' => [ 'base' => '<p>Information of a particular device.</p>', 'refs' => [ 'Devices$member' => NULL, ], ], 'DeviceArn' => [ 'base' => NULL, 'refs' => [ 'DescribeDeviceResponse$DeviceArn' => '<p>The Amazon Resource Name (ARN) of the device.</p>', 'DeviceDeploymentSummary$DeviceArn' => '<p>The ARN of the device.</p>', 'DeviceSummary$DeviceArn' => '<p>Amazon Resource Name (ARN) of the device.</p>', ], ], 'DeviceDeploymentStatus' => [ 'base' => NULL, 'refs' => [ 'DeviceDeploymentSummary$DeviceDeploymentStatus' => '<p>The deployment status of the device.</p>', ], ], 'DeviceDeploymentSummaries' => [ 'base' => NULL, 'refs' => [ 'ListStageDevicesResponse$DeviceDeploymentSummaries' => '<p>List of summaries of devices allocated to the stage.</p>', ], ], 'DeviceDeploymentSummary' => [ 'base' => '<p>Contains information summarizing device details and deployment status.</p>', 'refs' => [ 'DeviceDeploymentSummaries$member' => NULL, ], ], 'DeviceDescription' => [ 'base' => NULL, 'refs' => [ 'DescribeDeviceResponse$Description' => '<p>A description of the device.</p>', 'Device$Description' => '<p>Description of the device.</p>', 'DeviceDeploymentSummary$Description' => '<p>The description of the device.</p>', 'DeviceSummary$Description' => '<p>A description of the device.</p>', ], ], 'DeviceFleetArn' => [ 'base' => NULL, 'refs' => [ 'DescribeDeviceFleetResponse$DeviceFleetArn' => '<p>The The Amazon Resource Name (ARN) of the fleet.</p>', 'DeviceFleetSummary$DeviceFleetArn' => '<p>Amazon Resource Name (ARN) of the device fleet.</p>', 'GetDeviceFleetReportResponse$DeviceFleetArn' => '<p>The Amazon Resource Name (ARN) of the device.</p>', ], ], 'DeviceFleetDescription' => [ 'base' => NULL, 'refs' => [ 'CreateDeviceFleetRequest$Description' => '<p>A description of the fleet.</p>', 'DescribeDeviceFleetResponse$Description' => '<p>A description of the fleet.</p>', 'GetDeviceFleetReportResponse$Description' => '<p>Description of the fleet.</p>', 'UpdateDeviceFleetRequest$Description' => '<p>Description of the fleet.</p>', ], ], 'DeviceFleetSummaries' => [ 'base' => NULL, 'refs' => [ 'ListDeviceFleetsResponse$DeviceFleetSummaries' => '<p>Summary of the device fleet.</p>', ], ], 'DeviceFleetSummary' => [ 'base' => '<p>Summary of the device fleet.</p>', 'refs' => [ 'DeviceFleetSummaries$member' => NULL, ], ], 'DeviceName' => [ 'base' => NULL, 'refs' => [ 'Device$DeviceName' => '<p>The name of the device.</p>', 'DeviceDeploymentSummary$DeviceName' => '<p>The name of the device.</p>', 'DeviceNames$member' => NULL, 'DeviceSelectionConfig$DeviceNameContains' => '<p>A filter to select devices with names containing this name.</p>', ], ], 'DeviceNames' => [ 'base' => NULL, 'refs' => [ 'DeregisterDevicesRequest$DeviceNames' => '<p>The unique IDs of the devices.</p>', 'DeviceSelectionConfig$DeviceNames' => '<p>List of devices chosen to deploy.</p>', ], ], 'DeviceSelectionConfig' => [ 'base' => '<p>Contains information about the configurations of selected devices.</p>', 'refs' => [ 'DeploymentStage$DeviceSelectionConfig' => '<p>Configuration of the devices in the stage.</p>', 'DeploymentStageStatusSummary$DeviceSelectionConfig' => '<p>Configuration of the devices in the stage.</p>', ], ], 'DeviceStats' => [ 'base' => '<p>Status of devices.</p>', 'refs' => [ 'GetDeviceFleetReportResponse$DeviceStats' => '<p>Status of devices.</p>', ], ], 'DeviceSubsetType' => [ 'base' => NULL, 'refs' => [ 'DeviceSelectionConfig$DeviceSubsetType' => '<p>Type of device subsets to deploy to the current stage.</p>', ], ], 'DeviceSummaries' => [ 'base' => NULL, 'refs' => [ 'ListDevicesResponse$DeviceSummaries' => '<p>Summary of devices.</p>', ], ], 'DeviceSummary' => [ 'base' => '<p>Summary of the device.</p>', 'refs' => [ 'DeviceSummaries$member' => NULL, ], ], 'Devices' => [ 'base' => NULL, 'refs' => [ 'RegisterDevicesRequest$Devices' => '<p>A list of devices to register with SageMaker Edge Manager.</p>', 'UpdateDevicesRequest$Devices' => '<p>List of devices to register with Edge Manager agent.</p>', ], ], 'Dimension' => [ 'base' => NULL, 'refs' => [ 'VectorConfig$Dimension' => '<p>The number of elements in your vector.</p>', ], ], 'DirectDeploySettings' => [ 'base' => '<p>The model deployment settings for the SageMaker Canvas application.</p> <note> <p>In order to enable model deployment for Canvas, the SageMaker Domain\'s or user profile\'s Amazon Web Services IAM execution role must have the <code>AmazonSageMakerCanvasDirectDeployAccess</code> policy attached. You can also turn on model deployment permissions through the SageMaker Domain\'s or user profile\'s settings in the SageMaker console.</p> </note>', 'refs' => [ 'CanvasAppSettings$DirectDeploySettings' => '<p>The model deployment settings for the SageMaker Canvas application.</p>', ], ], 'DirectInternetAccess' => [ 'base' => NULL, 'refs' => [ 'CreateNotebookInstanceInput$DirectInternetAccess' => '<p>Sets whether SageMaker provides internet access to the notebook instance. If you set this to <code>Disabled</code> this notebook instance is able to access resources only in your VPC, and is not be able to connect to SageMaker training and endpoint services unless you configure a NAT Gateway in your VPC.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/appendix-additional-considerations.html#appendix-notebook-and-internet-access">Notebook Instances Are Internet-Enabled by Default</a>. You can set the value of this parameter to <code>Disabled</code> only if you set a value for the <code>SubnetId</code> parameter.</p>', 'DescribeNotebookInstanceOutput$DirectInternetAccess' => '<p>Describes whether SageMaker provides internet access to the notebook instance. If this value is set to <i>Disabled</i>, the notebook instance does not have internet access, and cannot connect to SageMaker training and endpoint services.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/appendix-additional-considerations.html#appendix-notebook-and-internet-access">Notebook Instances Are Internet-Enabled by Default</a>.</p>', ], ], 'Direction' => [ 'base' => NULL, 'refs' => [ 'QueryLineageRequest$Direction' => '<p>Associations between lineage entities have a direction. This parameter determines the direction from the StartArn(s) that the query traverses.</p>', ], ], 'DirectoryPath' => [ 'base' => NULL, 'refs' => [ 'CheckpointConfig$LocalPath' => '<p>(Optional) The local directory where checkpoints are written. The default directory is <code>/opt/ml/checkpoints/</code>. </p>', 'DebugHookConfig$LocalPath' => '<p>Path to local storage location for metrics and tensors. Defaults to <code>/opt/ml/output/tensors/</code>.</p>', 'DebugRuleConfiguration$LocalPath' => '<p>Path to local storage location for output of rules. Defaults to <code>/opt/ml/processing/output/rule/</code>.</p>', 'FileSystemDataSource$DirectoryPath' => '<p>The full path to the directory to associate with the channel.</p>', 'ProfilerRuleConfiguration$LocalPath' => '<p>Path to local storage location for output of rules. Defaults to <code>/opt/ml/processing/output/rule/</code>. </p>', 'TensorBoardOutputConfig$LocalPath' => '<p>Path to local storage location for tensorBoard output. Defaults to <code>/opt/ml/output/tensorboard</code>.</p>', ], ], 'DisableProfiler' => [ 'base' => NULL, 'refs' => [ 'ProfilerConfig$DisableProfiler' => '<p>Configuration to turn off Amazon SageMaker Debugger\'s system monitoring and profiling functionality. To turn it off, set to <code>True</code>.</p>', 'ProfilerConfigForUpdate$DisableProfiler' => '<p>To turn off Amazon SageMaker Debugger monitoring and profiling while a training job is in progress, set to <code>True</code>.</p>', ], ], 'DisableSagemakerServicecatalogPortfolioInput' => [ 'base' => NULL, 'refs' => [], ], 'DisableSagemakerServicecatalogPortfolioOutput' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateAdditionalCodeRepositories' => [ 'base' => NULL, 'refs' => [ 'UpdateNotebookInstanceInput$DisassociateAdditionalCodeRepositories' => '<p>A list of names or URLs of the default Git repositories to remove from this notebook instance. This operation is idempotent. If you specify a Git repository that is not associated with the notebook instance when you call this method, it does not throw an error.</p>', ], ], 'DisassociateDefaultCodeRepository' => [ 'base' => NULL, 'refs' => [ 'UpdateNotebookInstanceInput$DisassociateDefaultCodeRepository' => '<p>The name or URL of the default Git repository to remove from this notebook instance. This operation is idempotent. If you specify a Git repository that is not associated with the notebook instance when you call this method, it does not throw an error.</p>', ], ], 'DisassociateNotebookInstanceAcceleratorTypes' => [ 'base' => NULL, 'refs' => [ 'UpdateNotebookInstanceInput$DisassociateAcceleratorTypes' => '<p>A list of the Elastic Inference (EI) instance types to remove from this notebook instance. This operation is idempotent. If you specify an accelerator type that is not associated with the notebook instance when you call this method, it does not throw an error.</p>', ], ], 'DisassociateNotebookInstanceLifecycleConfig' => [ 'base' => NULL, 'refs' => [ 'UpdateNotebookInstanceInput$DisassociateLifecycleConfig' => '<p>Set to <code>true</code> to remove the notebook instance lifecycle configuration currently associated with the notebook instance. This operation is idempotent. If you specify a lifecycle configuration that is not associated with the notebook instance when you call this method, it does not throw an error.</p>', ], ], 'DisassociateTrialComponentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateTrialComponentResponse' => [ 'base' => NULL, 'refs' => [], ], 'DockerSettings' => [ 'base' => '<p>A collection of settings that configure the domain\'s Docker interaction.</p>', 'refs' => [ 'DomainSettings$DockerSettings' => '<p>A collection of settings that configure the domain\'s Docker interaction.</p>', 'DomainSettingsForUpdate$DockerSettings' => '<p>A collection of settings that configure the domain\'s Docker interaction.</p>', ], ], 'DocumentSchemaVersion' => [ 'base' => NULL, 'refs' => [ 'DescribeHubContentResponse$DocumentSchemaVersion' => '<p>The document schema version for the hub content.</p>', 'HubContentInfo$DocumentSchemaVersion' => '<p>The version of the hub content document schema.</p>', 'ImportHubContentRequest$DocumentSchemaVersion' => '<p>The version of the hub content schema to import.</p>', 'ListHubContentVersionsRequest$MaxSchemaVersion' => '<p>The upper bound of the hub content schema version.</p>', 'ListHubContentsRequest$MaxSchemaVersion' => '<p>The upper bound of the hub content schema verion.</p>', ], ], 'Dollars' => [ 'base' => NULL, 'refs' => [ 'USD$Dollars' => '<p>The whole number of dollars in the amount.</p>', ], ], 'DomainArn' => [ 'base' => NULL, 'refs' => [ 'CreateDomainResponse$DomainArn' => '<p>The Amazon Resource Name (ARN) of the created domain.</p>', 'DescribeDomainResponse$DomainArn' => '<p>The domain\'s Amazon Resource Name (ARN).</p>', 'DomainDetails$DomainArn' => '<p>The domain\'s Amazon Resource Name (ARN).</p>', 'UpdateDomainResponse$DomainArn' => '<p>The Amazon Resource Name (ARN) of the domain.</p>', ], ], 'DomainDetails' => [ 'base' => '<p>The domain\'s details.</p>', 'refs' => [ 'DomainList$member' => NULL, ], ], 'DomainId' => [ 'base' => NULL, 'refs' => [ 'AppDetails$DomainId' => '<p>The domain ID.</p>', 'CreateAppRequest$DomainId' => '<p>The domain ID.</p>', 'CreatePresignedDomainUrlRequest$DomainId' => '<p>The domain ID.</p>', 'CreateSpaceRequest$DomainId' => '<p>The ID of the associated domain.</p>', 'CreateUserProfileRequest$DomainId' => '<p>The ID of the associated Domain.</p>', 'DeleteAppRequest$DomainId' => '<p>The domain ID.</p>', 'DeleteDomainRequest$DomainId' => '<p>The domain ID.</p>', 'DeleteSpaceRequest$DomainId' => '<p>The ID of the associated domain.</p>', 'DeleteUserProfileRequest$DomainId' => '<p>The domain ID.</p>', 'DescribeAppRequest$DomainId' => '<p>The domain ID.</p>', 'DescribeAppResponse$DomainId' => '<p>The domain ID.</p>', 'DescribeDomainRequest$DomainId' => '<p>The domain ID.</p>', 'DescribeDomainResponse$DomainId' => '<p>The domain ID.</p>', 'DescribeSpaceRequest$DomainId' => '<p>The ID of the associated domain.</p>', 'DescribeSpaceResponse$DomainId' => '<p>The ID of the associated domain.</p>', 'DescribeUserProfileRequest$DomainId' => '<p>The domain ID.</p>', 'DescribeUserProfileResponse$DomainId' => '<p>The ID of the domain that contains the profile.</p>', 'DomainDetails$DomainId' => '<p>The domain ID.</p>', 'ListAppsRequest$DomainIdEquals' => '<p>A parameter to search for the domain ID.</p>', 'ListSpacesRequest$DomainIdEquals' => '<p>A parameter to search for the domain ID.</p>', 'ListUserProfilesRequest$DomainIdEquals' => '<p>A parameter by which to filter the results.</p>', 'SpaceDetails$DomainId' => '<p>The ID of the associated domain.</p>', 'UpdateDomainRequest$DomainId' => '<p>The ID of the domain to be updated.</p>', 'UpdateSpaceRequest$DomainId' => '<p>The ID of the associated domain.</p>', 'UpdateUserProfileRequest$DomainId' => '<p>The domain ID.</p>', 'UserProfileDetails$DomainId' => '<p>The domain ID.</p>', ], ], 'DomainList' => [ 'base' => NULL, 'refs' => [ 'ListDomainsResponse$Domains' => '<p>The list of domains.</p>', ], ], 'DomainName' => [ 'base' => NULL, 'refs' => [ 'CreateDomainRequest$DomainName' => '<p>A name for the domain.</p>', 'DescribeDomainResponse$DomainName' => '<p>The domain name.</p>', 'DomainDetails$DomainName' => '<p>The domain name.</p>', ], ], 'DomainSecurityGroupIds' => [ 'base' => NULL, 'refs' => [ 'DomainSettings$SecurityGroupIds' => '<p>The security groups for the Amazon Virtual Private Cloud that the <code>Domain</code> uses for communication between Domain-level apps and user apps.</p>', 'DomainSettingsForUpdate$SecurityGroupIds' => '<p>The security groups for the Amazon Virtual Private Cloud that the <code>Domain</code> uses for communication between Domain-level apps and user apps.</p>', ], ], 'DomainSettings' => [ 'base' => '<p>A collection of settings that apply to the <code>SageMaker Domain</code>. These settings are specified through the <code>CreateDomain</code> API call.</p>', 'refs' => [ 'CreateDomainRequest$DomainSettings' => '<p>A collection of <code>Domain</code> settings.</p>', 'DescribeDomainResponse$DomainSettings' => '<p>A collection of <code>Domain</code> settings.</p>', ], ], 'DomainSettingsForUpdate' => [ 'base' => '<p>A collection of <code>Domain</code> configuration settings to update.</p>', 'refs' => [ 'UpdateDomainRequest$DomainSettingsForUpdate' => '<p>A collection of <code>DomainSettings</code> configuration values to update.</p>', ], ], 'DomainStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeDomainResponse$Status' => '<p>The status.</p>', 'DomainDetails$Status' => '<p>The status.</p>', ], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'TargetTrackingScalingPolicyConfiguration$TargetValue' => '<p>The recommended target value to specify for the metric when creating a scaling policy.</p>', ], ], 'DoubleParameterValue' => [ 'base' => NULL, 'refs' => [ 'TrialComponentParameterValue$NumberValue' => '<p>The numeric value of a numeric hyperparameter. If you specify a value for this parameter, you can\'t specify the <code>StringValue</code> parameter.</p>', ], ], 'DriftCheckBaselines' => [ 'base' => '<p>Represents the drift check baselines that can be used when the model monitor is set using the model package. </p>', 'refs' => [ 'CreateModelPackageInput$DriftCheckBaselines' => '<p>Represents the drift check baselines that can be used when the model monitor is set using the model package. For more information, see the topic on <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/pipelines-quality-clarify-baseline-lifecycle.html#pipelines-quality-clarify-baseline-drift-detection">Drift Detection against Previous Baselines in SageMaker Pipelines</a> in the <i>Amazon SageMaker Developer Guide</i>. </p>', 'DescribeModelPackageOutput$DriftCheckBaselines' => '<p>Represents the drift check baselines that can be used when the model monitor is set using the model package. For more information, see the topic on <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/pipelines-quality-clarify-baseline-lifecycle.html#pipelines-quality-clarify-baseline-drift-detection">Drift Detection against Previous Baselines in SageMaker Pipelines</a> in the <i>Amazon SageMaker Developer Guide</i>. </p>', 'ModelPackage$DriftCheckBaselines' => '<p>Represents the drift check baselines that can be used when the model monitor is set using the model package.</p>', ], ], 'DriftCheckBias' => [ 'base' => '<p>Represents the drift check bias baselines that can be used when the model monitor is set using the model package.</p>', 'refs' => [ 'DriftCheckBaselines$Bias' => '<p>Represents the drift check bias baselines that can be used when the model monitor is set using the model package. </p>', ], ], 'DriftCheckExplainability' => [ 'base' => '<p>Represents the drift check explainability baselines that can be used when the model monitor is set using the model package. </p>', 'refs' => [ 'DriftCheckBaselines$Explainability' => '<p>Represents the drift check explainability baselines that can be used when the model monitor is set using the model package. </p>', ], ], 'DriftCheckModelDataQuality' => [ 'base' => '<p>Represents the drift check data quality baselines that can be used when the model monitor is set using the model package. </p>', 'refs' => [ 'DriftCheckBaselines$ModelDataQuality' => '<p>Represents the drift check model data quality baselines that can be used when the model monitor is set using the model package.</p>', ], ], 'DriftCheckModelQuality' => [ 'base' => '<p>Represents the drift check model quality baselines that can be used when the model monitor is set using the model package. </p>', 'refs' => [ 'DriftCheckBaselines$ModelQuality' => '<p>Represents the drift check model quality baselines that can be used when the model monitor is set using the model package.</p>', ], ], 'DynamicScalingConfiguration' => [ 'base' => '<p>An object with the recommended values for you to specify when creating an autoscaling policy.</p>', 'refs' => [ 'GetScalingConfigurationRecommendationResponse$DynamicScalingConfiguration' => '<p>An object with the recommended values for you to specify when creating an autoscaling policy.</p>', ], ], 'EFSFileSystem' => [ 'base' => '<p>A file system, created by you in Amazon EFS, that you assign to a user profile or space for an Amazon SageMaker Domain. Permitted users can access this file system in Amazon SageMaker Studio.</p>', 'refs' => [ 'CustomFileSystem$EFSFileSystem' => '<p>A custom file system in Amazon EFS.</p>', ], ], 'EFSFileSystemConfig' => [ 'base' => '<p>The settings for assigning a custom Amazon EFS file system to a user profile or space for an Amazon SageMaker Domain.</p>', 'refs' => [ 'CustomFileSystemConfig$EFSFileSystemConfig' => '<p>The settings for a custom Amazon EFS file system.</p>', ], ], 'EMRStepMetadata' => [ 'base' => '<p>The configurations and outcomes of an Amazon EMR step execution.</p>', 'refs' => [ 'PipelineExecutionStepMetadata$EMR' => '<p>The configurations and outcomes of an Amazon EMR step execution.</p>', ], ], 'EbsStorageSettings' => [ 'base' => '<p>A collection of EBS storage settings that apply to both private and shared spaces.</p>', 'refs' => [ 'SpaceStorageSettings$EbsStorageSettings' => '<p>A collection of EBS storage settings for a space.</p>', ], ], 'Edge' => [ 'base' => '<p>A directed edge connecting two lineage entities.</p>', 'refs' => [ 'Edges$member' => NULL, ], ], 'EdgeDeploymentConfig' => [ 'base' => '<p>Contains information about the configuration of a deployment.</p>', 'refs' => [ 'DeploymentStage$DeploymentConfig' => '<p>Configuration of the deployment details.</p>', 'DeploymentStageStatusSummary$DeploymentConfig' => '<p>Configuration of the deployment details.</p>', ], ], 'EdgeDeploymentModelConfig' => [ 'base' => '<p>Contains information about the configuration of a model in a deployment.</p>', 'refs' => [ 'EdgeDeploymentModelConfigs$member' => NULL, ], ], 'EdgeDeploymentModelConfigs' => [ 'base' => NULL, 'refs' => [ 'CreateEdgeDeploymentPlanRequest$ModelConfigs' => '<p>List of models associated with the edge deployment plan.</p>', 'DescribeEdgeDeploymentPlanResponse$ModelConfigs' => '<p>List of models associated with the edge deployment plan.</p>', ], ], 'EdgeDeploymentPlanArn' => [ 'base' => NULL, 'refs' => [ 'CreateEdgeDeploymentPlanResponse$EdgeDeploymentPlanArn' => '<p>The ARN of the edge deployment plan.</p>', 'DescribeEdgeDeploymentPlanResponse$EdgeDeploymentPlanArn' => '<p>The ARN of edge deployment plan.</p>', 'DeviceDeploymentSummary$EdgeDeploymentPlanArn' => '<p>The ARN of the edge deployment plan.</p>', 'EdgeDeploymentPlanSummary$EdgeDeploymentPlanArn' => '<p>The ARN of the edge deployment plan.</p>', ], ], 'EdgeDeploymentPlanSummaries' => [ 'base' => NULL, 'refs' => [ 'ListEdgeDeploymentPlansResponse$EdgeDeploymentPlanSummaries' => '<p>List of summaries of edge deployment plans.</p>', ], ], 'EdgeDeploymentPlanSummary' => [ 'base' => '<p>Contains information summarizing an edge deployment plan.</p>', 'refs' => [ 'EdgeDeploymentPlanSummaries$member' => NULL, ], ], 'EdgeDeploymentStatus' => [ 'base' => '<p>Contains information summarizing the deployment stage results.</p>', 'refs' => [ 'DeploymentStageStatusSummary$DeploymentStatus' => '<p>General status of the current state.</p>', ], ], 'EdgeModel' => [ 'base' => '<p>The model on the edge device.</p>', 'refs' => [ 'EdgeModels$member' => NULL, ], ], 'EdgeModelStat' => [ 'base' => '<p>Status of edge devices with this model.</p>', 'refs' => [ 'EdgeModelStats$member' => NULL, ], ], 'EdgeModelStats' => [ 'base' => NULL, 'refs' => [ 'GetDeviceFleetReportResponse$ModelStats' => '<p>Status of model on device.</p>', ], ], 'EdgeModelSummaries' => [ 'base' => NULL, 'refs' => [ 'DeviceSummary$Models' => '<p>Models on the device.</p>', ], ], 'EdgeModelSummary' => [ 'base' => '<p>Summary of model on edge device.</p>', 'refs' => [ 'EdgeModelSummaries$member' => NULL, ], ], 'EdgeModels' => [ 'base' => NULL, 'refs' => [ 'DescribeDeviceResponse$Models' => '<p>Models on the device.</p>', ], ], 'EdgeOutputConfig' => [ 'base' => '<p>The output configuration.</p>', 'refs' => [ 'CreateDeviceFleetRequest$OutputConfig' => '<p>The output configuration for storing sample data collected by the fleet.</p>', 'CreateEdgePackagingJobRequest$OutputConfig' => '<p>Provides information about the output location for the packaged model.</p>', 'DescribeDeviceFleetResponse$OutputConfig' => '<p>The output configuration for storing sampled data.</p>', 'DescribeEdgePackagingJobResponse$OutputConfig' => '<p>The output configuration for the edge packaging job.</p>', 'GetDeviceFleetReportResponse$OutputConfig' => '<p>The output configuration for storing sample data collected by the fleet.</p>', 'UpdateDeviceFleetRequest$OutputConfig' => '<p>Output configuration for storing sample data collected by the fleet.</p>', ], ], 'EdgePackagingJobArn' => [ 'base' => NULL, 'refs' => [ 'DescribeEdgePackagingJobResponse$EdgePackagingJobArn' => '<p>The Amazon Resource Name (ARN) of the edge packaging job.</p>', 'EdgePackagingJobSummary$EdgePackagingJobArn' => '<p>The Amazon Resource Name (ARN) of the edge packaging job.</p>', ], ], 'EdgePackagingJobStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeEdgePackagingJobResponse$EdgePackagingJobStatus' => '<p>The current status of the packaging job.</p>', 'EdgePackagingJobSummary$EdgePackagingJobStatus' => '<p>The status of the edge packaging job.</p>', 'ListEdgePackagingJobsRequest$StatusEquals' => '<p>The job status to filter for.</p>', ], ], 'EdgePackagingJobSummaries' => [ 'base' => NULL, 'refs' => [ 'ListEdgePackagingJobsResponse$EdgePackagingJobSummaries' => '<p>Summaries of edge packaging jobs.</p>', ], ], 'EdgePackagingJobSummary' => [ 'base' => '<p>Summary of edge packaging job.</p>', 'refs' => [ 'EdgePackagingJobSummaries$member' => NULL, ], ], 'EdgePresetDeploymentArtifact' => [ 'base' => NULL, 'refs' => [ 'EdgePresetDeploymentOutput$Artifact' => '<p>The Amazon Resource Name (ARN) of the generated deployable resource.</p>', ], ], 'EdgePresetDeploymentOutput' => [ 'base' => '<p>The output of a SageMaker Edge Manager deployable resource.</p>', 'refs' => [ 'DescribeEdgePackagingJobResponse$PresetDeploymentOutput' => '<p>The output of a SageMaker Edge Manager deployable resource.</p>', ], ], 'EdgePresetDeploymentStatus' => [ 'base' => NULL, 'refs' => [ 'EdgePresetDeploymentOutput$Status' => '<p>The status of the deployable resource.</p>', ], ], 'EdgePresetDeploymentType' => [ 'base' => NULL, 'refs' => [ 'EdgeOutputConfig$PresetDeploymentType' => '<p>The deployment type SageMaker Edge Manager will create. Currently only supports Amazon Web Services IoT Greengrass Version 2 components.</p>', 'EdgePresetDeploymentOutput$Type' => '<p>The deployment type created by SageMaker Edge Manager. Currently only supports Amazon Web Services IoT Greengrass Version 2 components.</p>', ], ], 'EdgeVersion' => [ 'base' => NULL, 'refs' => [ 'AgentVersion$Version' => '<p>Version of the agent.</p>', 'CreateEdgePackagingJobRequest$ModelVersion' => '<p>The version of the model.</p>', 'DescribeDeviceResponse$AgentVersion' => '<p>Edge Manager agent version.</p>', 'DescribeEdgePackagingJobResponse$ModelVersion' => '<p>The version of the model.</p>', 'DeviceSummary$AgentVersion' => '<p>Edge Manager agent version.</p>', 'EdgeModel$ModelVersion' => '<p>The model version.</p>', 'EdgeModelStat$ModelVersion' => '<p>The model version.</p>', 'EdgeModelSummary$ModelVersion' => '<p>The version model.</p>', 'EdgePackagingJobSummary$ModelVersion' => '<p>The version of the model.</p>', ], ], 'Edges' => [ 'base' => NULL, 'refs' => [ 'QueryLineageResponse$Edges' => '<p>A list of edges that connect vertices in the response.</p>', ], ], 'EfsUid' => [ 'base' => NULL, 'refs' => [ 'DescribeSpaceResponse$HomeEfsFileSystemUid' => '<p>The ID of the space\'s profile in the Amazon EFS volume.</p>', 'DescribeUserProfileResponse$HomeEfsFileSystemUid' => '<p>The ID of the user\'s profile in the Amazon Elastic File System volume.</p>', ], ], 'EnableCapture' => [ 'base' => NULL, 'refs' => [ 'DataCaptureConfig$EnableCapture' => '<p>Whether data capture should be enabled or disabled (defaults to enabled).</p>', 'DataCaptureConfigSummary$EnableCapture' => '<p>Whether data capture is enabled or disabled.</p>', ], ], 'EnableInfraCheck' => [ 'base' => NULL, 'refs' => [ 'InfraCheckConfig$EnableInfraCheck' => '<p>Enables an infrastructure health check.</p>', ], ], 'EnableIotRoleAlias' => [ 'base' => NULL, 'refs' => [ 'CreateDeviceFleetRequest$EnableIotRoleAlias' => '<p>Whether to create an Amazon Web Services IoT Role Alias during device fleet creation. The name of the role alias generated will match this pattern: "SageMakerEdge-{DeviceFleetName}".</p> <p>For example, if your device fleet is called "demo-fleet", the name of the role alias will be "SageMakerEdge-demo-fleet".</p>', 'UpdateDeviceFleetRequest$EnableIotRoleAlias' => '<p>Whether to create an Amazon Web Services IoT Role Alias during device fleet creation. The name of the role alias generated will match this pattern: "SageMakerEdge-{DeviceFleetName}".</p> <p>For example, if your device fleet is called "demo-fleet", the name of the role alias will be "SageMakerEdge-demo-fleet".</p>', ], ], 'EnableRemoteDebug' => [ 'base' => NULL, 'refs' => [ 'RemoteDebugConfig$EnableRemoteDebug' => '<p>If set to True, enables remote debugging.</p>', 'RemoteDebugConfigForUpdate$EnableRemoteDebug' => '<p>If set to True, enables remote debugging.</p>', ], ], 'EnableSagemakerServicecatalogPortfolioInput' => [ 'base' => NULL, 'refs' => [], ], 'EnableSagemakerServicecatalogPortfolioOutput' => [ 'base' => NULL, 'refs' => [], ], 'EnableSessionTagChaining' => [ 'base' => NULL, 'refs' => [ 'SessionChainingConfig$EnableSessionTagChaining' => '<p>Set to <code>True</code> to allow SageMaker to extract session tags from a training job creation role and reuse these tags when assuming the training job execution role.</p>', ], ], 'EnabledOrDisabled' => [ 'base' => NULL, 'refs' => [ 'IamPolicyConstraints$SourceIp' => '<p>When <code>SourceIp</code> is <code>Enabled</code> the worker\'s IP address when a task is rendered in the worker portal is added to the IAM policy as a <code>Condition</code> used to generate the Amazon S3 presigned URL. This IP address is checked by Amazon S3 and must match in order for the Amazon S3 resource to be rendered in the worker portal.</p>', 'IamPolicyConstraints$VpcSourceIp' => '<p>When <code>VpcSourceIp</code> is <code>Enabled</code> the worker\'s IP address when a task is rendered in private worker portal inside the VPC is added to the IAM policy as a <code>Condition</code> used to generate the Amazon S3 presigned URL. To render the task successfully Amazon S3 checks that the presigned URL is being accessed over an Amazon S3 VPC Endpoint, and that the worker\'s IP address matches the IP address in the IAM policy. To learn more about configuring private worker portal, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/samurai-vpc-worker-portal.html">Use Amazon VPC mode from a private worker portal</a>.</p>', ], ], 'Endpoint' => [ 'base' => '<p>A hosted endpoint for real-time inference.</p>', 'refs' => [ 'SearchRecord$Endpoint' => NULL, ], ], 'EndpointArn' => [ 'base' => NULL, 'refs' => [ 'CreateEndpointOutput$EndpointArn' => '<p>The Amazon Resource Name (ARN) of the endpoint.</p>', 'DescribeEndpointOutput$EndpointArn' => '<p>The Amazon Resource Name (ARN) of the endpoint.</p>', 'DescribeInferenceComponentOutput$EndpointArn' => '<p>The Amazon Resource Name (ARN) of the endpoint that hosts the inference component.</p>', 'Endpoint$EndpointArn' => '<p>The Amazon Resource Name (ARN) of the endpoint.</p>', 'EndpointSummary$EndpointArn' => '<p>The Amazon Resource Name (ARN) of the endpoint.</p>', 'InferenceComponentSummary$EndpointArn' => '<p>The Amazon Resource Name (ARN) of the endpoint that hosts the inference component.</p>', 'ModelDashboardEndpoint$EndpointArn' => '<p>The Amazon Resource Name (ARN) of the endpoint.</p>', 'UpdateEndpointOutput$EndpointArn' => '<p>The Amazon Resource Name (ARN) of the endpoint.</p>', 'UpdateEndpointWeightsAndCapacitiesOutput$EndpointArn' => '<p>The Amazon Resource Name (ARN) of the updated endpoint.</p>', ], ], 'EndpointConfigArn' => [ 'base' => NULL, 'refs' => [ 'CreateEndpointConfigOutput$EndpointConfigArn' => '<p>The Amazon Resource Name (ARN) of the endpoint configuration. </p>', 'DescribeEndpointConfigOutput$EndpointConfigArn' => '<p>The Amazon Resource Name (ARN) of the endpoint configuration.</p>', 'EndpointConfigSummary$EndpointConfigArn' => '<p>The Amazon Resource Name (ARN) of the endpoint configuration.</p>', ], ], 'EndpointConfigName' => [ 'base' => NULL, 'refs' => [ 'CreateEndpointConfigInput$EndpointConfigName' => '<p>The name of the endpoint configuration. You specify this name in a <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpoint.html">CreateEndpoint</a> request. </p>', 'CreateEndpointInput$EndpointConfigName' => '<p>The name of an endpoint configuration. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpointConfig.html">CreateEndpointConfig</a>. </p>', 'DeleteEndpointConfigInput$EndpointConfigName' => '<p>The name of the endpoint configuration that you want to delete.</p>', 'DescribeEndpointConfigInput$EndpointConfigName' => '<p>The name of the endpoint configuration.</p>', 'DescribeEndpointConfigOutput$EndpointConfigName' => '<p>Name of the SageMaker endpoint configuration.</p>', 'DescribeEndpointOutput$EndpointConfigName' => '<p>The name of the endpoint configuration associated with this endpoint.</p>', 'Endpoint$EndpointConfigName' => '<p>The endpoint configuration associated with the endpoint.</p>', 'EndpointConfigSummary$EndpointConfigName' => '<p>The name of the endpoint configuration.</p>', 'EndpointMetadata$EndpointConfigName' => '<p>The name of the endpoint configuration.</p>', 'PendingDeploymentSummary$EndpointConfigName' => '<p>The name of the endpoint configuration used in the deployment. </p>', 'UpdateEndpointInput$EndpointConfigName' => '<p>The name of the new endpoint configuration.</p>', ], ], 'EndpointConfigNameContains' => [ 'base' => NULL, 'refs' => [ 'ListEndpointConfigsInput$NameContains' => '<p>A string in the endpoint configuration name. This filter returns only endpoint configurations whose name contains the specified string. </p>', ], ], 'EndpointConfigSortKey' => [ 'base' => NULL, 'refs' => [ 'ListEndpointConfigsInput$SortBy' => '<p>The field to sort results by. The default is <code>CreationTime</code>.</p>', ], ], 'EndpointConfigSummary' => [ 'base' => '<p>Provides summary information for an endpoint configuration.</p>', 'refs' => [ 'EndpointConfigSummaryList$member' => NULL, ], ], 'EndpointConfigSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListEndpointConfigsOutput$EndpointConfigs' => '<p>An array of endpoint configurations.</p>', ], ], 'EndpointInfo' => [ 'base' => '<p>Details about a customer endpoint that was compared in an Inference Recommender job.</p>', 'refs' => [ 'EndpointPerformance$EndpointInfo' => NULL, 'Endpoints$member' => NULL, ], ], 'EndpointInput' => [ 'base' => '<p>Input object for the endpoint</p>', 'refs' => [ 'DataQualityJobInput$EndpointInput' => NULL, 'ModelBiasJobInput$EndpointInput' => NULL, 'ModelExplainabilityJobInput$EndpointInput' => NULL, 'ModelQualityJobInput$EndpointInput' => NULL, 'MonitoringInput$EndpointInput' => '<p>The endpoint for a monitoring job.</p>', ], ], 'EndpointInputConfiguration' => [ 'base' => '<p>The endpoint configuration for the load test.</p>', 'refs' => [ 'EndpointInputConfigurations$member' => NULL, ], ], 'EndpointInputConfigurations' => [ 'base' => NULL, 'refs' => [ 'RecommendationJobInputConfig$EndpointConfigurations' => '<p>Specifies the endpoint configuration to use for a job.</p>', ], ], 'EndpointMetadata' => [ 'base' => '<p>The metadata of the endpoint.</p>', 'refs' => [ 'DescribeInferenceExperimentResponse$EndpointMetadata' => '<p>The metadata of the endpoint on which the inference experiment ran.</p>', ], ], 'EndpointName' => [ 'base' => NULL, 'refs' => [ 'CreateEndpointInput$EndpointName' => '<p>The name of the endpoint.The name must be unique within an Amazon Web Services Region in your Amazon Web Services account. The name is case-insensitive in <code>CreateEndpoint</code>, but the case is preserved and must be matched in <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_runtime_InvokeEndpoint.html">InvokeEndpoint</a>.</p>', 'CreateInferenceComponentInput$EndpointName' => '<p>The name of an existing endpoint where you host the inference component.</p>', 'CreateInferenceExperimentRequest$EndpointName' => '<p> The name of the Amazon SageMaker endpoint on which you want to run the inference experiment. </p>', 'DeleteEndpointInput$EndpointName' => '<p>The name of the endpoint that you want to delete.</p>', 'DescribeEndpointInput$EndpointName' => '<p>The name of the endpoint.</p>', 'DescribeEndpointOutput$EndpointName' => '<p>Name of the endpoint.</p>', 'DescribeInferenceComponentOutput$EndpointName' => '<p>The name of the endpoint that hosts the inference component.</p>', 'DescribeMonitoringScheduleResponse$EndpointName' => '<p> The name of the endpoint for the monitoring job.</p>', 'Endpoint$EndpointName' => '<p>The name of the endpoint.</p>', 'EndpointInfo$EndpointName' => '<p>The name of a customer\'s endpoint.</p>', 'EndpointInput$EndpointName' => '<p>An endpoint in customer\'s account which has enabled <code>DataCaptureConfig</code> enabled.</p>', 'EndpointMetadata$EndpointName' => '<p>The name of the endpoint.</p>', 'EndpointSummary$EndpointName' => '<p>The name of the endpoint.</p>', 'GetScalingConfigurationRecommendationRequest$EndpointName' => '<p>The name of an endpoint benchmarked during a previously completed inference recommendation job. This name should come from one of the recommendations returned by the job specified in the <code>InferenceRecommendationsJobName</code> field.</p> <p>Specify either this field or the <code>RecommendationId</code> field.</p>', 'GetScalingConfigurationRecommendationResponse$EndpointName' => '<p>The name of an endpoint benchmarked during a previously completed Inference Recommender job.</p>', 'InferenceComponentSummary$EndpointName' => '<p>The name of the endpoint that hosts the inference component.</p>', 'ListDataQualityJobDefinitionsRequest$EndpointName' => '<p>A filter that lists the data quality job definitions associated with the specified endpoint.</p>', 'ListInferenceComponentsInput$EndpointNameEquals' => '<p>An endpoint name to filter the listed inference components. The response includes only those inference components that are hosted at the specified endpoint.</p>', 'ListModelBiasJobDefinitionsRequest$EndpointName' => '<p>Name of the endpoint to monitor for model bias.</p>', 'ListModelExplainabilityJobDefinitionsRequest$EndpointName' => '<p>Name of the endpoint to monitor for model explainability.</p>', 'ListModelQualityJobDefinitionsRequest$EndpointName' => '<p>A filter that returns only model quality monitoring job definitions that are associated with the specified endpoint.</p>', 'ListMonitoringExecutionsRequest$EndpointName' => '<p>Name of a specific endpoint to fetch jobs for.</p>', 'ListMonitoringSchedulesRequest$EndpointName' => '<p>Name of a specific endpoint to fetch schedules for.</p>', 'ModelDashboardEndpoint$EndpointName' => '<p>The endpoint name.</p>', 'ModelDashboardMonitoringSchedule$EndpointName' => '<p>The endpoint which is monitored.</p>', 'ModelDeployConfig$EndpointName' => '<p>Specifies the endpoint name to use for a one-click Autopilot model deployment if the endpoint name is not generated automatically.</p> <note> <p>Specify the <code>EndpointName</code> if and only if you set <code>AutoGenerateEndpointName</code> to <code>False</code>; otherwise a 400 error is thrown.</p> </note>', 'ModelDeployResult$EndpointName' => '<p>The name of the endpoint to which the model has been deployed.</p> <note> <p>If model deployment fails, this field is omitted from the response.</p> </note>', 'MonitoringExecutionSummary$EndpointName' => '<p>The name of the endpoint used to run the monitoring job.</p>', 'MonitoringJobDefinitionSummary$EndpointName' => '<p>The name of the endpoint that the job monitors.</p>', 'MonitoringSchedule$EndpointName' => '<p>The endpoint that hosts the model being monitored.</p>', 'MonitoringScheduleSummary$EndpointName' => '<p>The name of the endpoint using the monitoring schedule.</p>', 'UpdateEndpointInput$EndpointName' => '<p>The name of the endpoint whose configuration you want to update.</p>', 'UpdateEndpointWeightsAndCapacitiesInput$EndpointName' => '<p>The name of an existing SageMaker endpoint.</p>', ], ], 'EndpointNameContains' => [ 'base' => NULL, 'refs' => [ 'ListEndpointsInput$NameContains' => '<p>A string in endpoint names. This filter returns only endpoints whose name contains the specified string.</p>', ], ], 'EndpointOutputConfiguration' => [ 'base' => '<p>The endpoint configuration made by Inference Recommender during a recommendation job.</p>', 'refs' => [ 'InferenceRecommendation$EndpointConfiguration' => '<p>Defines the endpoint configuration parameters.</p>', 'RecommendationJobInferenceBenchmark$EndpointConfiguration' => NULL, ], ], 'EndpointPerformance' => [ 'base' => '<p>The performance results from running an Inference Recommender job on an existing endpoint.</p>', 'refs' => [ 'EndpointPerformances$member' => NULL, ], ], 'EndpointPerformances' => [ 'base' => NULL, 'refs' => [ 'DescribeInferenceRecommendationsJobResponse$EndpointPerformances' => '<p>The performance results from running an Inference Recommender job on an existing endpoint.</p>', ], ], 'EndpointSortKey' => [ 'base' => NULL, 'refs' => [ 'ListEndpointsInput$SortBy' => '<p>Sorts the list of results. The default is <code>CreationTime</code>.</p>', ], ], 'EndpointStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeEndpointOutput$EndpointStatus' => '<p>The status of the endpoint.</p> <ul> <li> <p> <code>OutOfService</code>: Endpoint is not available to take incoming requests.</p> </li> <li> <p> <code>Creating</code>: <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpoint.html">CreateEndpoint</a> is executing.</p> </li> <li> <p> <code>Updating</code>: <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateEndpoint.html">UpdateEndpoint</a> or <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateEndpointWeightsAndCapacities.html">UpdateEndpointWeightsAndCapacities</a> is executing.</p> </li> <li> <p> <code>SystemUpdating</code>: Endpoint is undergoing maintenance and cannot be updated or deleted or re-scaled until it has completed. This maintenance operation does not change any customer-specified values such as VPC config, KMS encryption, model, instance type, or instance count.</p> </li> <li> <p> <code>RollingBack</code>: Endpoint fails to scale up or down or change its variant weight and is in the process of rolling back to its previous configuration. Once the rollback completes, endpoint returns to an <code>InService</code> status. This transitional status only applies to an endpoint that has autoscaling enabled and is undergoing variant weight or capacity changes as part of an <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateEndpointWeightsAndCapacities.html">UpdateEndpointWeightsAndCapacities</a> call or when the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateEndpointWeightsAndCapacities.html">UpdateEndpointWeightsAndCapacities</a> operation is called explicitly.</p> </li> <li> <p> <code>InService</code>: Endpoint is available to process incoming requests.</p> </li> <li> <p> <code>Deleting</code>: <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteEndpoint.html">DeleteEndpoint</a> is executing.</p> </li> <li> <p> <code>Failed</code>: Endpoint could not be created, updated, or re-scaled. Use the <code>FailureReason</code> value returned by <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeEndpoint.html">DescribeEndpoint</a> for information about the failure. <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteEndpoint.html">DeleteEndpoint</a> is the only operation that can be performed on a failed endpoint.</p> </li> <li> <p> <code>UpdateRollbackFailed</code>: Both the rolling deployment and auto-rollback failed. Your endpoint is in service with a mix of the old and new endpoint configurations. For information about how to remedy this issue and restore the endpoint\'s status to <code>InService</code>, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/deployment-guardrails-rolling.html">Rolling Deployments</a>.</p> </li> </ul>', 'Endpoint$EndpointStatus' => '<p>The status of the endpoint.</p>', 'EndpointMetadata$EndpointStatus' => '<p> The status of the endpoint. For possible values of the status of an endpoint, see <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_EndpointSummary.html">EndpointSummary</a>. </p>', 'EndpointSummary$EndpointStatus' => '<p>The status of the endpoint.</p> <ul> <li> <p> <code>OutOfService</code>: Endpoint is not available to take incoming requests.</p> </li> <li> <p> <code>Creating</code>: <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpoint.html">CreateEndpoint</a> is executing.</p> </li> <li> <p> <code>Updating</code>: <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateEndpoint.html">UpdateEndpoint</a> or <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateEndpointWeightsAndCapacities.html">UpdateEndpointWeightsAndCapacities</a> is executing.</p> </li> <li> <p> <code>SystemUpdating</code>: Endpoint is undergoing maintenance and cannot be updated or deleted or re-scaled until it has completed. This maintenance operation does not change any customer-specified values such as VPC config, KMS encryption, model, instance type, or instance count.</p> </li> <li> <p> <code>RollingBack</code>: Endpoint fails to scale up or down or change its variant weight and is in the process of rolling back to its previous configuration. Once the rollback completes, endpoint returns to an <code>InService</code> status. This transitional status only applies to an endpoint that has autoscaling enabled and is undergoing variant weight or capacity changes as part of an <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateEndpointWeightsAndCapacities.html">UpdateEndpointWeightsAndCapacities</a> call or when the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateEndpointWeightsAndCapacities.html">UpdateEndpointWeightsAndCapacities</a> operation is called explicitly.</p> </li> <li> <p> <code>InService</code>: Endpoint is available to process incoming requests.</p> </li> <li> <p> <code>Deleting</code>: <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteEndpoint.html">DeleteEndpoint</a> is executing.</p> </li> <li> <p> <code>Failed</code>: Endpoint could not be created, updated, or re-scaled. Use <code>DescribeEndpointOutput$FailureReason</code> for information about the failure. <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteEndpoint.html">DeleteEndpoint</a> is the only operation that can be performed on a failed endpoint.</p> </li> </ul> <p>To get a list of endpoints with a specified status, use the <code>StatusEquals</code> filter with a call to <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListEndpoints.html">ListEndpoints</a>.</p>', 'ListEndpointsInput$StatusEquals' => '<p> A filter that returns only endpoints with the specified status.</p>', 'ModelDashboardEndpoint$EndpointStatus' => '<p>The endpoint status.</p>', ], ], 'EndpointSummary' => [ 'base' => '<p>Provides summary information for an endpoint.</p>', 'refs' => [ 'EndpointSummaryList$member' => NULL, ], ], 'EndpointSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListEndpointsOutput$Endpoints' => '<p> An array or endpoint objects. </p>', ], ], 'Endpoints' => [ 'base' => NULL, 'refs' => [ 'RecommendationJobInputConfig$Endpoints' => '<p>Existing customer endpoints on which to run an Inference Recommender job.</p>', ], ], 'EntityDescription' => [ 'base' => NULL, 'refs' => [ 'AdditionalInferenceSpecificationDefinition$Description' => '<p>A description of the additional Inference specification</p>', 'AlgorithmSummary$AlgorithmDescription' => '<p>A brief description of the algorithm.</p>', 'BatchDescribeModelPackageSummary$ModelPackageDescription' => '<p>The description of the model package.</p>', 'ChannelSpecification$Description' => '<p>A brief description of the channel.</p>', 'CreateAlgorithmInput$AlgorithmDescription' => '<p>A description of the algorithm.</p>', 'CreateModelPackageGroupInput$ModelPackageGroupDescription' => '<p>A description for the model group.</p>', 'CreateModelPackageInput$ModelPackageDescription' => '<p>A description of the model package.</p>', 'CreateProjectInput$ProjectDescription' => '<p>A description for the project.</p>', 'DescribeAlgorithmOutput$AlgorithmDescription' => '<p>A brief summary about the algorithm.</p>', 'DescribeModelPackageGroupOutput$ModelPackageGroupDescription' => '<p>A description of the model group.</p>', 'DescribeModelPackageOutput$ModelPackageDescription' => '<p>A brief summary of the model package.</p>', 'DescribeProjectOutput$ProjectDescription' => '<p>The description of the project.</p>', 'HyperParameterSpecification$Description' => '<p>A brief description of the hyperparameter.</p>', 'ModelPackage$ModelPackageDescription' => '<p>The description of the model package.</p>', 'ModelPackageGroup$ModelPackageGroupDescription' => '<p>The description for the model group.</p>', 'ModelPackageGroupSummary$ModelPackageGroupDescription' => '<p>A description of the model group.</p>', 'ModelPackageSummary$ModelPackageDescription' => '<p>A brief description of the model package.</p>', 'Project$ProjectDescription' => '<p>The description of the project.</p>', 'ProjectSummary$ProjectDescription' => '<p>The description of the project.</p>', 'UpdateProjectInput$ProjectDescription' => '<p>The description for the project.</p>', ], ], 'EntityName' => [ 'base' => NULL, 'refs' => [ 'AdditionalInferenceSpecificationDefinition$Name' => '<p>A unique name to identify the additional inference specification. The name must be unique within the list of your additional inference specifications for a particular model package.</p>', 'AlgorithmStatusItem$Name' => '<p>The name of the algorithm for which the overall status is being reported.</p>', 'AlgorithmSummary$AlgorithmName' => '<p>The name of the algorithm that is described by the summary.</p>', 'AlgorithmValidationProfile$ProfileName' => '<p>The name of the profile for the algorithm. The name must have 1 to 63 characters. Valid characters are a-z, A-Z, 0-9, and - (hyphen).</p>', 'BatchDescribeModelPackageSummary$ModelPackageGroupName' => '<p>The group name for the model package</p>', 'CodeRepositorySummary$CodeRepositoryName' => '<p>The name of the Git repository.</p>', 'CompilationJobSummary$CompilationJobName' => '<p>The name of the model compilation job that you want a summary for.</p>', 'CreateAlgorithmInput$AlgorithmName' => '<p>The name of the algorithm.</p>', 'CreateCodeRepositoryInput$CodeRepositoryName' => '<p>The name of the Git repository. The name must have 1 to 63 characters. Valid characters are a-z, A-Z, 0-9, and - (hyphen).</p>', 'CreateCompilationJobRequest$CompilationJobName' => '<p>A name for the model compilation job. The name must be unique within the Amazon Web Services Region and within your Amazon Web Services account. </p>', 'CreateDeviceFleetRequest$DeviceFleetName' => '<p>The name of the fleet that the device belongs to.</p>', 'CreateEdgeDeploymentPlanRequest$EdgeDeploymentPlanName' => '<p>The name of the edge deployment plan.</p>', 'CreateEdgeDeploymentPlanRequest$DeviceFleetName' => '<p>The device fleet used for this edge deployment plan.</p>', 'CreateEdgeDeploymentStageRequest$EdgeDeploymentPlanName' => '<p>The name of the edge deployment plan.</p>', 'CreateEdgePackagingJobRequest$EdgePackagingJobName' => '<p>The name of the edge packaging job.</p>', 'CreateEdgePackagingJobRequest$CompilationJobName' => '<p>The name of the SageMaker Neo compilation job that will be used to locate model artifacts for packaging.</p>', 'CreateEdgePackagingJobRequest$ModelName' => '<p>The name of the model.</p>', 'CreateModelCardExportJobRequest$ModelCardExportJobName' => '<p>The name of the model card export job.</p>', 'CreateModelCardRequest$ModelCardName' => '<p>The unique name of the model card.</p>', 'CreateModelPackageGroupInput$ModelPackageGroupName' => '<p>The name of the model group.</p>', 'CreateModelPackageInput$ModelPackageName' => '<p>The name of the model package. The name must have 1 to 63 characters. Valid characters are a-z, A-Z, 0-9, and - (hyphen).</p> <p>This parameter is required for unversioned models. It is not applicable to versioned models.</p>', 'CreateOptimizationJobRequest$OptimizationJobName' => '<p>A custom name for the new optimization job.</p>', 'DeleteAlgorithmInput$AlgorithmName' => '<p>The name of the algorithm to delete.</p>', 'DeleteCodeRepositoryInput$CodeRepositoryName' => '<p>The name of the Git repository to delete.</p>', 'DeleteCompilationJobRequest$CompilationJobName' => '<p>The name of the compilation job to delete.</p>', 'DeleteDeviceFleetRequest$DeviceFleetName' => '<p>The name of the fleet to delete.</p>', 'DeleteEdgeDeploymentPlanRequest$EdgeDeploymentPlanName' => '<p>The name of the edge deployment plan to delete.</p>', 'DeleteEdgeDeploymentStageRequest$EdgeDeploymentPlanName' => '<p>The name of the edge deployment plan from which the stage will be deleted.</p>', 'DeleteEdgeDeploymentStageRequest$StageName' => '<p>The name of the stage.</p>', 'DeleteModelCardRequest$ModelCardName' => '<p>The name of the model card to delete.</p>', 'DeleteModelPackageGroupPolicyInput$ModelPackageGroupName' => '<p>The name of the model group for which to delete the policy.</p>', 'DeleteOptimizationJobRequest$OptimizationJobName' => '<p>The name that you assigned to the optimization job.</p>', 'DeploymentStage$StageName' => '<p>The name of the stage.</p>', 'DeploymentStageStatusSummary$StageName' => '<p>The name of the stage.</p>', 'DeregisterDevicesRequest$DeviceFleetName' => '<p>The name of the fleet the devices belong to.</p>', 'DescribeAlgorithmOutput$AlgorithmName' => '<p>The name of the algorithm being described.</p>', 'DescribeCodeRepositoryInput$CodeRepositoryName' => '<p>The name of the Git repository to describe.</p>', 'DescribeCodeRepositoryOutput$CodeRepositoryName' => '<p>The name of the Git repository.</p>', 'DescribeCompilationJobRequest$CompilationJobName' => '<p>The name of the model compilation job that you want information about.</p>', 'DescribeCompilationJobResponse$CompilationJobName' => '<p>The name of the model compilation job.</p>', 'DescribeDeviceFleetRequest$DeviceFleetName' => '<p>The name of the fleet.</p>', 'DescribeDeviceFleetResponse$DeviceFleetName' => '<p>The name of the fleet.</p>', 'DescribeDeviceRequest$DeviceName' => '<p>The unique ID of the device.</p>', 'DescribeDeviceRequest$DeviceFleetName' => '<p>The name of the fleet the devices belong to.</p>', 'DescribeDeviceResponse$DeviceName' => '<p>The unique identifier of the device.</p>', 'DescribeDeviceResponse$DeviceFleetName' => '<p>The name of the fleet the device belongs to.</p>', 'DescribeEdgeDeploymentPlanRequest$EdgeDeploymentPlanName' => '<p>The name of the deployment plan to describe.</p>', 'DescribeEdgeDeploymentPlanResponse$EdgeDeploymentPlanName' => '<p>The name of the edge deployment plan.</p>', 'DescribeEdgeDeploymentPlanResponse$DeviceFleetName' => '<p>The device fleet used for this edge deployment plan.</p>', 'DescribeEdgePackagingJobRequest$EdgePackagingJobName' => '<p>The name of the edge packaging job.</p>', 'DescribeEdgePackagingJobResponse$EdgePackagingJobName' => '<p>The name of the edge packaging job.</p>', 'DescribeEdgePackagingJobResponse$CompilationJobName' => '<p>The name of the SageMaker Neo compilation job that is used to locate model artifacts that are being packaged.</p>', 'DescribeEdgePackagingJobResponse$ModelName' => '<p>The name of the model.</p>', 'DescribeModelCardExportJobResponse$ModelCardExportJobName' => '<p>The name of the model card export job to describe.</p>', 'DescribeModelCardExportJobResponse$ModelCardName' => '<p>The name or Amazon Resource Name (ARN) of the model card that the model export job exports.</p>', 'DescribeModelCardResponse$ModelCardName' => '<p>The name of the model card.</p>', 'DescribeModelPackageGroupOutput$ModelPackageGroupName' => '<p>The name of the model group.</p>', 'DescribeModelPackageOutput$ModelPackageName' => '<p>The name of the model package being described.</p>', 'DescribeModelPackageOutput$ModelPackageGroupName' => '<p>If the model is a versioned model, the name of the model group that the versioned model belongs to.</p>', 'DescribeOptimizationJobRequest$OptimizationJobName' => '<p>The name that you assigned to the optimization job.</p>', 'DescribeOptimizationJobResponse$OptimizationJobName' => '<p>The name that you assigned to the optimization job.</p>', 'DeviceDeploymentSummary$EdgeDeploymentPlanName' => '<p>The name of the edge deployment plan.</p>', 'DeviceDeploymentSummary$StageName' => '<p>The name of the stage in the edge deployment plan.</p>', 'DeviceDeploymentSummary$DeployedStageName' => '<p>The name of the deployed stage.</p>', 'DeviceDeploymentSummary$DeviceFleetName' => '<p>The name of the fleet to which the device belongs to.</p>', 'DeviceFleetSummary$DeviceFleetName' => '<p>Name of the device fleet.</p>', 'DeviceSummary$DeviceName' => '<p>The unique identifier of the device.</p>', 'DeviceSummary$DeviceFleetName' => '<p>The name of the fleet the device belongs to.</p>', 'EdgeDeploymentModelConfig$ModelHandle' => '<p>The name the device application uses to reference this model.</p>', 'EdgeDeploymentModelConfig$EdgePackagingJobName' => '<p>The edge packaging job associated with this deployment.</p>', 'EdgeDeploymentPlanSummary$EdgeDeploymentPlanName' => '<p>The name of the edge deployment plan.</p>', 'EdgeDeploymentPlanSummary$DeviceFleetName' => '<p>The name of the device fleet used for the deployment. </p>', 'EdgeModel$ModelName' => '<p>The name of the model.</p>', 'EdgeModelStat$ModelName' => '<p>The name of the model.</p>', 'EdgeModelSummary$ModelName' => '<p>The name of the model.</p>', 'EdgePackagingJobSummary$EdgePackagingJobName' => '<p>The name of the edge packaging job.</p>', 'EdgePackagingJobSummary$CompilationJobName' => '<p>The name of the SageMaker Neo compilation job.</p>', 'EdgePackagingJobSummary$ModelName' => '<p>The name of the model.</p>', 'GetDeviceFleetReportRequest$DeviceFleetName' => '<p>The name of the fleet.</p>', 'GetDeviceFleetReportResponse$DeviceFleetName' => '<p>The name of the fleet.</p>', 'GetModelPackageGroupPolicyInput$ModelPackageGroupName' => '<p>The name of the model group for which to get the resource policy.</p>', 'ListDevicesRequest$ModelName' => '<p>A filter that searches devices that contains this name in any of their models.</p>', 'ListDevicesRequest$DeviceFleetName' => '<p>Filter for fleets containing this name in their device fleet name.</p>', 'ListModelCardExportJobsRequest$ModelCardName' => '<p>List export jobs for the model card with the specified name.</p>', 'ListModelCardExportJobsRequest$ModelCardExportJobNameContains' => '<p>Only list model card export jobs with names that contain the specified string.</p>', 'ListModelCardsRequest$NameContains' => '<p>Only list model cards with names that contain the specified string.</p>', 'ListStageDevicesRequest$EdgeDeploymentPlanName' => '<p>The name of the edge deployment plan.</p>', 'ListStageDevicesRequest$StageName' => '<p>The name of the stage in the deployment.</p>', 'ModelCard$ModelCardName' => '<p>The unique name of the model card.</p>', 'ModelCardExportJobSummary$ModelCardExportJobName' => '<p>The name of the model card export job.</p>', 'ModelCardExportJobSummary$ModelCardName' => '<p>The name of the model card that the export job exports.</p>', 'ModelCardSummary$ModelCardName' => '<p>The name of the model card.</p>', 'ModelCardVersionSummary$ModelCardName' => '<p>The name of the model card.</p>', 'ModelDashboardModelCard$ModelCardName' => '<p>The name of a model card.</p>', 'ModelPackage$ModelPackageName' => '<p>The name of the model.</p>', 'ModelPackage$ModelPackageGroupName' => '<p>The model group to which the model belongs.</p>', 'ModelPackageGroup$ModelPackageGroupName' => '<p>The name of the model group.</p>', 'ModelPackageGroupSummary$ModelPackageGroupName' => '<p>The name of the model group.</p>', 'ModelPackageStatusItem$Name' => '<p>The name of the model package for which the overall status is being reported.</p>', 'ModelPackageSummary$ModelPackageName' => '<p>The name of the model package.</p>', 'ModelPackageSummary$ModelPackageGroupName' => '<p>If the model package is a versioned model, the model group that the versioned model belongs to.</p>', 'ModelPackageValidationProfile$ProfileName' => '<p>The name of the profile for the model package.</p>', 'OptimizationJobSummary$OptimizationJobName' => '<p>The name that you assigned to the optimization job.</p>', 'PutModelPackageGroupPolicyInput$ModelPackageGroupName' => '<p>The name of the model group to add a resource policy to.</p>', 'RegisterDevicesRequest$DeviceFleetName' => '<p>The name of the fleet.</p>', 'StartEdgeDeploymentStageRequest$EdgeDeploymentPlanName' => '<p>The name of the edge deployment plan to start.</p>', 'StartEdgeDeploymentStageRequest$StageName' => '<p>The name of the stage to start.</p>', 'StopCompilationJobRequest$CompilationJobName' => '<p>The name of the model compilation job to stop.</p>', 'StopEdgeDeploymentStageRequest$EdgeDeploymentPlanName' => '<p>The name of the edge deployment plan to stop.</p>', 'StopEdgeDeploymentStageRequest$StageName' => '<p>The name of the stage to stop.</p>', 'StopEdgePackagingJobRequest$EdgePackagingJobName' => '<p>The name of the edge packaging job.</p>', 'StopOptimizationJobRequest$OptimizationJobName' => '<p>The name that you assigned to the optimization job.</p>', 'UpdateCodeRepositoryInput$CodeRepositoryName' => '<p>The name of the Git repository to update.</p>', 'UpdateDeviceFleetRequest$DeviceFleetName' => '<p>The name of the fleet.</p>', 'UpdateDevicesRequest$DeviceFleetName' => '<p>The name of the fleet the devices belong to.</p>', ], ], 'EnvironmentKey' => [ 'base' => NULL, 'refs' => [ 'EnvironmentMap$key' => NULL, ], ], 'EnvironmentMap' => [ 'base' => NULL, 'refs' => [ 'AutoMLContainerDefinition$Environment' => '<p>The environment variables to set in the container. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ContainerDefinition.html"> ContainerDefinition</a>.</p>', 'ContainerDefinition$Environment' => '<p>The environment variables to set in the Docker container.</p> <p>The maximum length of each key and value in the <code>Environment</code> map is 1024 bytes. The maximum length of all keys and values in the map, combined, is 32 KB. If you pass multiple containers to a <code>CreateModel</code> request, then the maximum length of all of their maps, combined, is also 32 KB.</p>', 'InferenceComponentContainerSpecification$Environment' => '<p>The environment variables to set in the Docker container. Each key and value in the Environment string-to-string map can have length of up to 1024. We support up to 16 entries in the map.</p>', 'InferenceComponentContainerSpecificationSummary$Environment' => '<p>The environment variables to set in the Docker container.</p>', 'ModelPackageContainerDefinition$Environment' => '<p>The environment variables to set in the Docker container. Each key and value in the <code>Environment</code> string to string map can have length of up to 1024. We support up to 16 entries in the map.</p>', 'RealTimeInferenceRecommendation$Environment' => '<p>The recommended environment variables to set in the model container for Real-Time Inference.</p>', ], ], 'EnvironmentParameter' => [ 'base' => '<p>A list of environment parameters suggested by the Amazon SageMaker Inference Recommender.</p>', 'refs' => [ 'EnvironmentParameters$member' => NULL, ], ], 'EnvironmentParameterRanges' => [ 'base' => '<p>Specifies the range of environment parameters</p>', 'refs' => [ 'EndpointInputConfiguration$EnvironmentParameterRanges' => '<p> The parameter you want to benchmark against.</p>', ], ], 'EnvironmentParameters' => [ 'base' => NULL, 'refs' => [ 'ModelConfiguration$EnvironmentParameters' => '<p>Defines the environment parameters that includes key, value types, and values.</p>', ], ], 'EnvironmentValue' => [ 'base' => NULL, 'refs' => [ 'EnvironmentMap$value' => NULL, ], ], 'ExcludeFeaturesAttribute' => [ 'base' => NULL, 'refs' => [ 'BatchTransformInput$ExcludeFeaturesAttribute' => '<p>The attributes of the input data to exclude from the analysis.</p>', 'EndpointInput$ExcludeFeaturesAttribute' => '<p>The attributes of the input data to exclude from the analysis.</p>', ], ], 'ExecutionRoleIdentityConfig' => [ 'base' => NULL, 'refs' => [ 'DomainSettings$ExecutionRoleIdentityConfig' => '<p>The configuration for attaching a SageMaker user profile name to the execution role as a <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_monitor.html">sts:SourceIdentity key</a>.</p>', 'DomainSettingsForUpdate$ExecutionRoleIdentityConfig' => '<p>The configuration for attaching a SageMaker user profile name to the execution role as a <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_monitor.html">sts:SourceIdentity key</a>. This configuration can only be modified if there are no apps in the <code>InService</code> or <code>Pending</code> state.</p>', ], ], 'ExecutionStatus' => [ 'base' => NULL, 'refs' => [ 'ListMonitoringExecutionsRequest$StatusEquals' => '<p>A filter that retrieves only jobs with a specific status.</p>', 'MonitoringExecutionSummary$MonitoringExecutionStatus' => '<p>The status of the monitoring job.</p>', ], ], 'ExitMessage' => [ 'base' => NULL, 'refs' => [ 'DescribeProcessingJobResponse$ExitMessage' => '<p>An optional string, up to one KB in size, that contains metadata from the processing container when the processing job exits.</p>', 'ProcessingJob$ExitMessage' => '<p>A string, up to one KB in size, that contains metadata from the processing container when the processing job exits.</p>', 'ProcessingJobSummary$ExitMessage' => '<p>An optional string, up to one KB in size, that contains metadata from the processing container when the processing job exits.</p>', ], ], 'Experiment' => [ 'base' => '<p>The properties of an experiment as returned by the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html">Search</a> API.</p>', 'refs' => [ 'SearchRecord$Experiment' => '<p>The properties of an experiment.</p>', ], ], 'ExperimentArn' => [ 'base' => NULL, 'refs' => [ 'CreateExperimentResponse$ExperimentArn' => '<p>The Amazon Resource Name (ARN) of the experiment.</p>', 'DeleteExperimentResponse$ExperimentArn' => '<p>The Amazon Resource Name (ARN) of the experiment that is being deleted.</p>', 'DescribeExperimentResponse$ExperimentArn' => '<p>The Amazon Resource Name (ARN) of the experiment.</p>', 'Experiment$ExperimentArn' => '<p>The Amazon Resource Name (ARN) of the experiment.</p>', 'ExperimentSummary$ExperimentArn' => '<p>The Amazon Resource Name (ARN) of the experiment.</p>', 'UpdateExperimentResponse$ExperimentArn' => '<p>The Amazon Resource Name (ARN) of the experiment.</p>', ], ], 'ExperimentConfig' => [ 'base' => '<p>Associates a SageMaker job as a trial component with an experiment and trial. Specified when you call the following APIs:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateProcessingJob.html">CreateProcessingJob</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTrainingJob.html">CreateTrainingJob</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTransformJob.html">CreateTransformJob</a> </p> </li> </ul>', 'refs' => [ 'CreateProcessingJobRequest$ExperimentConfig' => NULL, 'CreateTrainingJobRequest$ExperimentConfig' => NULL, 'CreateTransformJobRequest$ExperimentConfig' => NULL, 'DescribeProcessingJobResponse$ExperimentConfig' => '<p>The configuration information used to create an experiment.</p>', 'DescribeTrainingJobResponse$ExperimentConfig' => NULL, 'DescribeTransformJobResponse$ExperimentConfig' => NULL, 'ProcessingJob$ExperimentConfig' => NULL, 'TrainingJob$ExperimentConfig' => NULL, 'TransformJob$ExperimentConfig' => NULL, ], ], 'ExperimentDescription' => [ 'base' => NULL, 'refs' => [ 'CreateActionRequest$Description' => '<p>The description of the action.</p>', 'CreateContextRequest$Description' => '<p>The description of the context.</p>', 'CreateExperimentRequest$Description' => '<p>The description of the experiment.</p>', 'DescribeActionResponse$Description' => '<p>The description of the action.</p>', 'DescribeContextResponse$Description' => '<p>The description of the context.</p>', 'DescribeExperimentResponse$Description' => '<p>The description of the experiment.</p>', 'DescribeLineageGroupResponse$Description' => '<p>The description of the lineage group.</p>', 'Experiment$Description' => '<p>The description of the experiment.</p>', 'UpdateActionRequest$Description' => '<p>The new description for the action.</p>', 'UpdateContextRequest$Description' => '<p>The new description for the context.</p>', 'UpdateExperimentRequest$Description' => '<p>The description of the experiment.</p>', ], ], 'ExperimentEntityName' => [ 'base' => NULL, 'refs' => [ 'ActionSummary$ActionName' => '<p>The name of the action.</p>', 'ArtifactSummary$ArtifactName' => '<p>The name of the artifact.</p>', 'AssociateTrialComponentRequest$TrialComponentName' => '<p>The name of the component to associated with the trial.</p>', 'AssociateTrialComponentRequest$TrialName' => '<p>The name of the trial to associate with.</p>', 'AssociationSummary$SourceName' => '<p>The name of the source.</p>', 'AssociationSummary$DestinationName' => '<p>The name of the destination.</p>', 'CreateActionRequest$ActionName' => '<p>The name of the action. Must be unique to your account in an Amazon Web Services Region.</p>', 'CreateArtifactRequest$ArtifactName' => '<p>The name of the artifact. Must be unique to your account in an Amazon Web Services Region.</p>', 'CreateExperimentRequest$ExperimentName' => '<p>The name of the experiment. The name must be unique in your Amazon Web Services account and is not case-sensitive.</p>', 'CreateExperimentRequest$DisplayName' => '<p>The name of the experiment as displayed. The name doesn\'t need to be unique. If you don\'t specify <code>DisplayName</code>, the value in <code>ExperimentName</code> is displayed.</p>', 'CreateTrialComponentRequest$TrialComponentName' => '<p>The name of the component. The name must be unique in your Amazon Web Services account and is not case-sensitive.</p>', 'CreateTrialComponentRequest$DisplayName' => '<p>The name of the component as displayed. The name doesn\'t need to be unique. If <code>DisplayName</code> isn\'t specified, <code>TrialComponentName</code> is displayed.</p>', 'CreateTrialRequest$TrialName' => '<p>The name of the trial. The name must be unique in your Amazon Web Services account and is not case-sensitive.</p>', 'CreateTrialRequest$DisplayName' => '<p>The name of the trial as displayed. The name doesn\'t need to be unique. If <code>DisplayName</code> isn\'t specified, <code>TrialName</code> is displayed.</p>', 'CreateTrialRequest$ExperimentName' => '<p>The name of the experiment to associate the trial with.</p>', 'DeleteActionRequest$ActionName' => '<p>The name of the action to delete.</p>', 'DeleteExperimentRequest$ExperimentName' => '<p>The name of the experiment to delete.</p>', 'DeleteTrialComponentRequest$TrialComponentName' => '<p>The name of the component to delete.</p>', 'DeleteTrialRequest$TrialName' => '<p>The name of the trial to delete.</p>', 'DescribeExperimentRequest$ExperimentName' => '<p>The name of the experiment to describe.</p>', 'DescribeExperimentResponse$ExperimentName' => '<p>The name of the experiment.</p>', 'DescribeExperimentResponse$DisplayName' => '<p>The name of the experiment as displayed. If <code>DisplayName</code> isn\'t specified, <code>ExperimentName</code> is displayed.</p>', 'DescribeLineageGroupRequest$LineageGroupName' => '<p>The name of the lineage group.</p>', 'DescribeLineageGroupResponse$LineageGroupName' => '<p>The name of the lineage group.</p>', 'DescribeLineageGroupResponse$DisplayName' => '<p>The display name of the lineage group.</p>', 'DescribeTrialComponentResponse$TrialComponentName' => '<p>The name of the trial component.</p>', 'DescribeTrialComponentResponse$DisplayName' => '<p>The name of the component as displayed. If <code>DisplayName</code> isn\'t specified, <code>TrialComponentName</code> is displayed.</p>', 'DescribeTrialRequest$TrialName' => '<p>The name of the trial to describe.</p>', 'DescribeTrialResponse$TrialName' => '<p>The name of the trial.</p>', 'DescribeTrialResponse$DisplayName' => '<p>The name of the trial as displayed. If <code>DisplayName</code> isn\'t specified, <code>TrialName</code> is displayed.</p>', 'DescribeTrialResponse$ExperimentName' => '<p>The name of the experiment the trial is part of.</p>', 'DisassociateTrialComponentRequest$TrialComponentName' => '<p>The name of the component to disassociate from the trial.</p>', 'DisassociateTrialComponentRequest$TrialName' => '<p>The name of the trial to disassociate from.</p>', 'Experiment$ExperimentName' => '<p>The name of the experiment.</p>', 'Experiment$DisplayName' => '<p>The name of the experiment as displayed. If <code>DisplayName</code> isn\'t specified, <code>ExperimentName</code> is displayed.</p>', 'ExperimentConfig$ExperimentName' => '<p>The name of an existing experiment to associate with the trial component.</p>', 'ExperimentConfig$TrialName' => '<p>The name of an existing trial to associate the trial component with. If not specified, a new trial is created.</p>', 'ExperimentConfig$TrialComponentDisplayName' => '<p>The display name for the trial component. If this key isn\'t specified, the display name is the trial component name.</p>', 'ExperimentConfig$RunName' => '<p>The name of the experiment run to associate with the trial component.</p>', 'ExperimentSummary$ExperimentName' => '<p>The name of the experiment.</p>', 'ExperimentSummary$DisplayName' => '<p>The name of the experiment as displayed. If <code>DisplayName</code> isn\'t specified, <code>ExperimentName</code> is displayed.</p>', 'LineageGroupSummary$LineageGroupName' => '<p>The name or Amazon Resource Name (ARN) of the lineage group.</p>', 'LineageGroupSummary$DisplayName' => '<p>The display name of the lineage group summary.</p>', 'ListTrialComponentsRequest$ExperimentName' => '<p>A filter that returns only components that are part of the specified experiment. If you specify <code>ExperimentName</code>, you can\'t filter by <code>SourceArn</code> or <code>TrialName</code>.</p>', 'ListTrialComponentsRequest$TrialName' => '<p>A filter that returns only components that are part of the specified trial. If you specify <code>TrialName</code>, you can\'t filter by <code>ExperimentName</code> or <code>SourceArn</code>.</p>', 'ListTrialsRequest$ExperimentName' => '<p>A filter that returns only trials that are part of the specified experiment.</p>', 'ListTrialsRequest$TrialComponentName' => '<p>A filter that returns only trials that are associated with the specified trial component.</p>', 'Parent$TrialName' => '<p>The name of the trial.</p>', 'Parent$ExperimentName' => '<p>The name of the experiment.</p>', 'PipelineExperimentConfig$ExperimentName' => '<p>The name of the experiment.</p>', 'PipelineExperimentConfig$TrialName' => '<p>The name of the trial.</p>', 'Trial$TrialName' => '<p>The name of the trial.</p>', 'Trial$DisplayName' => '<p>The name of the trial as displayed. If <code>DisplayName</code> isn\'t specified, <code>TrialName</code> is displayed.</p>', 'Trial$ExperimentName' => '<p>The name of the experiment the trial is part of.</p>', 'TrialComponent$TrialComponentName' => '<p>The name of the trial component.</p>', 'TrialComponent$DisplayName' => '<p>The name of the component as displayed. If <code>DisplayName</code> isn\'t specified, <code>TrialComponentName</code> is displayed.</p>', 'TrialComponent$RunName' => '<p>The name of the experiment run.</p>', 'TrialComponentSimpleSummary$TrialComponentName' => '<p>The name of the trial component.</p>', 'TrialComponentSummary$TrialComponentName' => '<p>The name of the trial component.</p>', 'TrialComponentSummary$DisplayName' => '<p>The name of the component as displayed. If <code>DisplayName</code> isn\'t specified, <code>TrialComponentName</code> is displayed.</p>', 'TrialSummary$TrialName' => '<p>The name of the trial.</p>', 'TrialSummary$DisplayName' => '<p>The name of the trial as displayed. If <code>DisplayName</code> isn\'t specified, <code>TrialName</code> is displayed.</p>', 'UpdateActionRequest$ActionName' => '<p>The name of the action to update.</p>', 'UpdateArtifactRequest$ArtifactName' => '<p>The new name for the artifact.</p>', 'UpdateExperimentRequest$ExperimentName' => '<p>The name of the experiment to update.</p>', 'UpdateExperimentRequest$DisplayName' => '<p>The name of the experiment as displayed. The name doesn\'t need to be unique. If <code>DisplayName</code> isn\'t specified, <code>ExperimentName</code> is displayed.</p>', 'UpdateTrialComponentRequest$TrialComponentName' => '<p>The name of the component to update.</p>', 'UpdateTrialComponentRequest$DisplayName' => '<p>The name of the component as displayed. The name doesn\'t need to be unique. If <code>DisplayName</code> isn\'t specified, <code>TrialComponentName</code> is displayed.</p>', 'UpdateTrialRequest$TrialName' => '<p>The name of the trial to update.</p>', 'UpdateTrialRequest$DisplayName' => '<p>The name of the trial as displayed. The name doesn\'t need to be unique. If <code>DisplayName</code> isn\'t specified, <code>TrialName</code> is displayed.</p>', ], ], 'ExperimentEntityNameOrArn' => [ 'base' => NULL, 'refs' => [ 'DescribeActionRequest$ActionName' => '<p>The name of the action to describe.</p>', 'DescribeActionResponse$ActionName' => '<p>The name of the action.</p>', 'DescribeArtifactResponse$ArtifactName' => '<p>The name of the artifact.</p>', 'DescribeTrialComponentRequest$TrialComponentName' => '<p>The name of the trial component to describe.</p>', ], ], 'ExperimentSource' => [ 'base' => '<p>The source of the experiment.</p>', 'refs' => [ 'DescribeExperimentResponse$Source' => '<p>The Amazon Resource Name (ARN) of the source and, optionally, the type.</p>', 'Experiment$Source' => NULL, 'ExperimentSummary$ExperimentSource' => NULL, ], ], 'ExperimentSourceArn' => [ 'base' => NULL, 'refs' => [ 'ExperimentSource$SourceArn' => '<p>The Amazon Resource Name (ARN) of the source.</p>', ], ], 'ExperimentSummaries' => [ 'base' => NULL, 'refs' => [ 'ListExperimentsResponse$ExperimentSummaries' => '<p>A list of the summaries of your experiments.</p>', ], ], 'ExperimentSummary' => [ 'base' => '<p>A summary of the properties of an experiment. To get the complete set of properties, call the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeExperiment.html">DescribeExperiment</a> API and provide the <code>ExperimentName</code>.</p>', 'refs' => [ 'ExperimentSummaries$member' => NULL, ], ], 'ExpiresInSeconds' => [ 'base' => NULL, 'refs' => [ 'CreatePresignedDomainUrlRequest$ExpiresInSeconds' => '<p>The number of seconds until the pre-signed URL expires. This value defaults to 300.</p>', 'CreatePresignedMlflowTrackingServerUrlRequest$ExpiresInSeconds' => '<p>The duration in seconds that your presigned URL is valid. The presigned URL can be used only once.</p>', ], ], 'Explainability' => [ 'base' => '<p>Contains explainability metrics for a model.</p>', 'refs' => [ 'ModelMetrics$Explainability' => '<p>Metrics that help explain a model.</p>', ], ], 'ExplainabilityLocation' => [ 'base' => NULL, 'refs' => [ 'CandidateArtifactLocations$Explainability' => '<p>The Amazon S3 prefix to the explainability artifacts generated for the AutoML candidate.</p>', ], ], 'ExplainerConfig' => [ 'base' => '<p>A parameter to activate explainers.</p>', 'refs' => [ 'CreateEndpointConfigInput$ExplainerConfig' => '<p>A member of <code>CreateEndpointConfig</code> that enables explainers.</p>', 'DescribeEndpointConfigOutput$ExplainerConfig' => '<p>The configuration parameters for an explainer.</p>', 'DescribeEndpointOutput$ExplainerConfig' => '<p>The configuration parameters for an explainer.</p>', ], ], 'FailStepMetadata' => [ 'base' => '<p>The container for the metadata for Fail step.</p>', 'refs' => [ 'PipelineExecutionStepMetadata$Fail' => '<p>The configurations and outcomes of a Fail step execution.</p>', ], ], 'FailureHandlingPolicy' => [ 'base' => NULL, 'refs' => [ 'EdgeDeploymentConfig$FailureHandlingPolicy' => '<p>Toggle that determines whether to rollback to previous configuration if the current deployment fails. By default this is turned on. You may turn this off if you want to investigate the errors yourself.</p>', ], ], 'FailureReason' => [ 'base' => NULL, 'refs' => [ 'ConflictException$Message' => NULL, 'DescribeAppResponse$FailureReason' => '<p>The failure reason.</p>', 'DescribeCompilationJobResponse$FailureReason' => '<p>If a model compilation job failed, the reason it failed. </p>', 'DescribeDomainResponse$FailureReason' => '<p>The failure reason.</p>', 'DescribeEndpointOutput$FailureReason' => '<p>If the status of the endpoint is <code>Failed</code>, the reason why it failed. </p>', 'DescribeFeatureGroupResponse$FailureReason' => '<p>The reason that the <code>FeatureGroup</code> failed to be replicated in the <code>OfflineStore</code>. This is failure can occur because:</p> <ul> <li> <p>The <code>FeatureGroup</code> could not be created in the <code>OfflineStore</code>.</p> </li> <li> <p>The <code>FeatureGroup</code> could not be deleted from the <code>OfflineStore</code>.</p> </li> </ul>', 'DescribeFlowDefinitionResponse$FailureReason' => '<p>The reason your flow definition failed.</p>', 'DescribeHubContentResponse$FailureReason' => '<p>The failure reason if importing hub content failed.</p>', 'DescribeHubResponse$FailureReason' => '<p>The failure reason if importing hub content failed.</p>', 'DescribeHyperParameterTuningJobResponse$FailureReason' => '<p>If the tuning job failed, the reason it failed.</p>', 'DescribeImageResponse$FailureReason' => '<p>When a create, update, or delete operation fails, the reason for the failure.</p>', 'DescribeImageVersionResponse$FailureReason' => '<p>When a create or delete operation fails, the reason for the failure.</p>', 'DescribeInferenceComponentOutput$FailureReason' => '<p>If the inference component status is <code>Failed</code>, the reason for the failure.</p>', 'DescribeInferenceRecommendationsJobResponse$FailureReason' => '<p>If the job fails, provides information why the job failed.</p>', 'DescribeLabelingJobResponse$FailureReason' => '<p>If the job failed, the reason that it failed. </p>', 'DescribeModelCardExportJobResponse$FailureReason' => '<p>The failure reason if the model export job fails.</p>', 'DescribeMonitoringScheduleResponse$FailureReason' => '<p>A string, up to one KB in size, that contains the reason a monitoring job failed, if it failed.</p>', 'DescribeNotebookInstanceOutput$FailureReason' => '<p>If status is <code>Failed</code>, the reason it failed.</p>', 'DescribeOptimizationJobResponse$FailureReason' => '<p>If the optimization job status is <code>FAILED</code>, the reason for the failure.</p>', 'DescribeProcessingJobResponse$FailureReason' => '<p>A string, up to one KB in size, that contains the reason a processing job failed, if it failed.</p>', 'DescribeSpaceResponse$FailureReason' => '<p>The failure reason.</p>', 'DescribeTrainingJobResponse$FailureReason' => '<p>If the training job failed, the reason it failed. </p>', 'DescribeTransformJobResponse$FailureReason' => '<p>If the transform job failed, <code>FailureReason</code> describes why it failed. A transform job creates a log file, which includes error messages, and stores it as an Amazon S3 object. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/logging-cloudwatch.html">Log Amazon SageMaker Events with Amazon CloudWatch</a>.</p>', 'DescribeUserProfileResponse$FailureReason' => '<p>The failure reason.</p>', 'Endpoint$FailureReason' => '<p>If the endpoint failed, the reason it failed.</p>', 'EndpointMetadata$FailureReason' => '<p> If the status of the endpoint is <code>Failed</code>, or the status is <code>InService</code> but update operation fails, this provides the reason why it failed. </p>', 'FeatureGroup$FailureReason' => '<p>The reason that the <code>FeatureGroup</code> failed to be replicated in the <code>OfflineStore</code>. This is failure may be due to a failure to create a <code>FeatureGroup</code> in or delete a <code>FeatureGroup</code> from the <code>OfflineStore</code>.</p>', 'FlowDefinitionSummary$FailureReason' => '<p>The reason why the flow definition creation failed. A failure reason is returned only when the flow definition status is <code>Failed</code>.</p>', 'HyperParameterTrainingJobSummary$FailureReason' => '<p>The reason that the training job failed. </p>', 'HyperParameterTuningJobSearchEntity$FailureReason' => '<p>The error that was created when a hyperparameter tuning job failed.</p>', 'Image$FailureReason' => '<p>When a create, update, or delete operation fails, the reason for the failure.</p>', 'ImageVersion$FailureReason' => '<p>When a create or delete operation fails, the reason for the failure.</p>', 'InferenceRecommendationsJob$FailureReason' => '<p>If the job fails, provides information why the job failed.</p>', 'LabelingJobSummary$FailureReason' => '<p>If the <code>LabelingJobStatus</code> field is <code>Failed</code>, this field contains a description of the error.</p>', 'LastUpdateStatus$FailureReason' => '<p>If the update wasn\'t successful, indicates the reason why it failed.</p>', 'ModelDashboardMonitoringSchedule$FailureReason' => '<p>If a monitoring job failed, provides the reason.</p>', 'MonitoringExecutionSummary$FailureReason' => '<p>Contains the reason a monitoring job failed, if it failed.</p>', 'MonitoringSchedule$FailureReason' => '<p>If the monitoring schedule failed, the reason it failed.</p>', 'PipelineExecutionStep$FailureReason' => '<p>The reason why the step failed execution. This is only returned if the step failed its execution.</p>', 'ProcessingJob$FailureReason' => '<p>A string, up to one KB in size, that contains the reason a processing job failed, if it failed.</p>', 'ProcessingJobSummary$FailureReason' => '<p>A string, up to one KB in size, that contains the reason a processing job failed, if it failed.</p>', 'ResourceInUse$Message' => NULL, 'ResourceLimitExceeded$Message' => NULL, 'ResourceNotFound$Message' => NULL, 'TrainingJob$FailureReason' => '<p>If the training job failed, the reason it failed.</p>', 'TransformJob$FailureReason' => '<p>If the transform job failed, the reason it failed.</p>', 'TransformJobSummary$FailureReason' => '<p>If the transform job failed, the reason it failed.</p>', ], ], 'FeatureAdditions' => [ 'base' => NULL, 'refs' => [ 'UpdateFeatureGroupRequest$FeatureAdditions' => '<p>Updates the feature group. Updating a feature group is an asynchronous operation. When you get an HTTP 200 response, you\'ve made a valid request. It takes some time after you\'ve made a valid request for Feature Store to update the feature group.</p>', ], ], 'FeatureDefinition' => [ 'base' => '<p>A list of features. You must include <code>FeatureName</code> and <code>FeatureType</code>. Valid feature <code>FeatureType</code>s are <code>Integral</code>, <code>Fractional</code> and <code>String</code>. </p>', 'refs' => [ 'FeatureAdditions$member' => NULL, 'FeatureDefinitions$member' => NULL, ], ], 'FeatureDefinitions' => [ 'base' => NULL, 'refs' => [ 'CreateFeatureGroupRequest$FeatureDefinitions' => '<p>A list of <code>Feature</code> names and types. <code>Name</code> and <code>Type</code> is compulsory per <code>Feature</code>. </p> <p>Valid feature <code>FeatureType</code>s are <code>Integral</code>, <code>Fractional</code> and <code>String</code>.</p> <p> <code>FeatureName</code>s cannot be any of the following: <code>is_deleted</code>, <code>write_time</code>, <code>api_invocation_time</code> </p> <p>You can create up to 2,500 <code>FeatureDefinition</code>s per <code>FeatureGroup</code>.</p>', 'DescribeFeatureGroupResponse$FeatureDefinitions' => '<p>A list of the <code>Features</code> in the <code>FeatureGroup</code>. Each feature is defined by a <code>FeatureName</code> and <code>FeatureType</code>.</p>', 'FeatureGroup$FeatureDefinitions' => '<p>A list of <code>Feature</code>s. Each <code>Feature</code> must include a <code>FeatureName</code> and a <code>FeatureType</code>. </p> <p>Valid <code>FeatureType</code>s are <code>Integral</code>, <code>Fractional</code> and <code>String</code>. </p> <p> <code>FeatureName</code>s cannot be any of the following: <code>is_deleted</code>, <code>write_time</code>, <code>api_invocation_time</code>.</p> <p>You can create up to 2,500 <code>FeatureDefinition</code>s per <code>FeatureGroup</code>.</p>', ], ], 'FeatureDescription' => [ 'base' => NULL, 'refs' => [ 'DescribeFeatureMetadataResponse$Description' => '<p>The description you added to describe the feature.</p>', 'FeatureMetadata$Description' => '<p>An optional description that you specify to better describe the feature.</p>', 'UpdateFeatureMetadataRequest$Description' => '<p>A description that you can write to better describe the feature.</p>', ], ], 'FeatureGroup' => [ 'base' => '<p>Amazon SageMaker Feature Store stores features in a collection called Feature Group. A Feature Group can be visualized as a table which has rows, with a unique identifier for each row where each column in the table is a feature. In principle, a Feature Group is composed of features and values per features.</p>', 'refs' => [ 'SearchRecord$FeatureGroup' => NULL, ], ], 'FeatureGroupArn' => [ 'base' => NULL, 'refs' => [ 'CreateFeatureGroupResponse$FeatureGroupArn' => '<p>The Amazon Resource Name (ARN) of the <code>FeatureGroup</code>. This is a unique identifier for the feature group. </p>', 'DescribeFeatureGroupResponse$FeatureGroupArn' => '<p>The Amazon Resource Name (ARN) of the <code>FeatureGroup</code>. </p>', 'DescribeFeatureMetadataResponse$FeatureGroupArn' => '<p>The Amazon Resource Number (ARN) of the feature group that contains the feature.</p>', 'FeatureGroup$FeatureGroupArn' => '<p>The Amazon Resource Name (ARN) of a <code>FeatureGroup</code>.</p>', 'FeatureGroupSummary$FeatureGroupArn' => '<p>Unique identifier for the <code>FeatureGroup</code>.</p>', 'FeatureMetadata$FeatureGroupArn' => '<p>The Amazon Resource Number (ARN) of the feature group.</p>', 'UpdateFeatureGroupResponse$FeatureGroupArn' => '<p>The Amazon Resource Number (ARN) of the feature group that you\'re updating.</p>', ], ], 'FeatureGroupMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListFeatureGroupsRequest$MaxResults' => '<p>The maximum number of results returned by <code>ListFeatureGroups</code>.</p>', ], ], 'FeatureGroupName' => [ 'base' => NULL, 'refs' => [ 'CreateFeatureGroupRequest$FeatureGroupName' => '<p>The name of the <code>FeatureGroup</code>. The name must be unique within an Amazon Web Services Region in an Amazon Web Services account.</p> <p>The name:</p> <ul> <li> <p>Must start with an alphanumeric character.</p> </li> <li> <p>Can only include alphanumeric characters, underscores, and hyphens. Spaces are not allowed.</p> </li> </ul>', 'DeleteFeatureGroupRequest$FeatureGroupName' => '<p>The name of the <code>FeatureGroup</code> you want to delete. The name must be unique within an Amazon Web Services Region in an Amazon Web Services account. </p>', 'DescribeFeatureGroupResponse$FeatureGroupName' => '<p>he name of the <code>FeatureGroup</code>.</p>', 'DescribeFeatureMetadataResponse$FeatureGroupName' => '<p>The name of the feature group that you\'ve specified.</p>', 'FeatureGroup$FeatureGroupName' => '<p>The name of the <code>FeatureGroup</code>.</p>', 'FeatureGroupSummary$FeatureGroupName' => '<p>The name of <code>FeatureGroup</code>.</p>', 'FeatureMetadata$FeatureGroupName' => '<p>The name of the feature group containing the feature.</p>', 'ProcessingFeatureStoreOutput$FeatureGroupName' => '<p>The name of the Amazon SageMaker FeatureGroup to use as the destination for processing job output. Note that your processing script is responsible for putting records into your Feature Store.</p>', ], ], 'FeatureGroupNameContains' => [ 'base' => NULL, 'refs' => [ 'ListFeatureGroupsRequest$NameContains' => '<p>A string that partially matches one or more <code>FeatureGroup</code>s names. Filters <code>FeatureGroup</code>s by name. </p>', ], ], 'FeatureGroupNameOrArn' => [ 'base' => NULL, 'refs' => [ 'DescribeFeatureGroupRequest$FeatureGroupName' => '<p>The name or Amazon Resource Name (ARN) of the <code>FeatureGroup</code> you want described. </p>', 'DescribeFeatureMetadataRequest$FeatureGroupName' => '<p>The name or Amazon Resource Name (ARN) of the feature group containing the feature.</p>', 'UpdateFeatureGroupRequest$FeatureGroupName' => '<p>The name or Amazon Resource Name (ARN) of the feature group that you\'re updating.</p>', 'UpdateFeatureMetadataRequest$FeatureGroupName' => '<p>The name or Amazon Resource Name (ARN) of the feature group containing the feature that you\'re updating.</p>', ], ], 'FeatureGroupSortBy' => [ 'base' => NULL, 'refs' => [ 'ListFeatureGroupsRequest$SortBy' => '<p>The value on which the feature group list is sorted.</p>', ], ], 'FeatureGroupSortOrder' => [ 'base' => NULL, 'refs' => [ 'ListFeatureGroupsRequest$SortOrder' => '<p>The order in which feature groups are listed.</p>', ], ], 'FeatureGroupStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeFeatureGroupResponse$FeatureGroupStatus' => '<p>The status of the feature group.</p>', 'FeatureGroup$FeatureGroupStatus' => '<p>A <code>FeatureGroup</code> status.</p>', 'FeatureGroupSummary$FeatureGroupStatus' => '<p>The status of a FeatureGroup. The status can be any of the following: <code>Creating</code>, <code>Created</code>, <code>CreateFail</code>, <code>Deleting</code> or <code>DetailFail</code>. </p>', 'ListFeatureGroupsRequest$FeatureGroupStatusEquals' => '<p>A <code>FeatureGroup</code> status. Filters by <code>FeatureGroup</code> status. </p>', ], ], 'FeatureGroupSummaries' => [ 'base' => NULL, 'refs' => [ 'ListFeatureGroupsResponse$FeatureGroupSummaries' => '<p>A summary of feature groups.</p>', ], ], 'FeatureGroupSummary' => [ 'base' => '<p>The name, ARN, <code>CreationTime</code>, <code>FeatureGroup</code> values, <code>LastUpdatedTime</code> and <code>EnableOnlineStorage</code> status of a <code>FeatureGroup</code>.</p>', 'refs' => [ 'FeatureGroupSummaries$member' => NULL, ], ], 'FeatureMetadata' => [ 'base' => '<p>The metadata for a feature. It can either be metadata that you specify, or metadata that is updated automatically.</p>', 'refs' => [ 'SearchRecord$FeatureMetadata' => '<p>The feature metadata used to search through the features.</p>', ], ], 'FeatureName' => [ 'base' => NULL, 'refs' => [ 'CreateFeatureGroupRequest$RecordIdentifierFeatureName' => '<p>The name of the <code>Feature</code> whose value uniquely identifies a <code>Record</code> defined in the <code>FeatureStore</code>. Only the latest record per identifier value will be stored in the <code>OnlineStore</code>. <code>RecordIdentifierFeatureName</code> must be one of feature definitions\' names.</p> <p>You use the <code>RecordIdentifierFeatureName</code> to access data in a <code>FeatureStore</code>.</p> <p>This name:</p> <ul> <li> <p>Must start with an alphanumeric character.</p> </li> <li> <p>Can only contains alphanumeric characters, hyphens, underscores. Spaces are not allowed. </p> </li> </ul>', 'CreateFeatureGroupRequest$EventTimeFeatureName' => '<p>The name of the feature that stores the <code>EventTime</code> of a <code>Record</code> in a <code>FeatureGroup</code>.</p> <p>An <code>EventTime</code> is a point in time when a new event occurs that corresponds to the creation or update of a <code>Record</code> in a <code>FeatureGroup</code>. All <code>Records</code> in the <code>FeatureGroup</code> must have a corresponding <code>EventTime</code>.</p> <p>An <code>EventTime</code> can be a <code>String</code> or <code>Fractional</code>. </p> <ul> <li> <p> <code>Fractional</code>: <code>EventTime</code> feature values must be a Unix timestamp in seconds.</p> </li> <li> <p> <code>String</code>: <code>EventTime</code> feature values must be an ISO-8601 string in the format. The following formats are supported <code>yyyy-MM-dd\'T\'HH:mm:ssZ</code> and <code>yyyy-MM-dd\'T\'HH:mm:ss.SSSZ</code> where <code>yyyy</code>, <code>MM</code>, and <code>dd</code> represent the year, month, and day respectively and <code>HH</code>, <code>mm</code>, <code>ss</code>, and if applicable, <code>SSS</code> represent the hour, month, second and milliseconds respsectively. <code>\'T\'</code> and <code>Z</code> are constants.</p> </li> </ul>', 'DescribeFeatureGroupResponse$RecordIdentifierFeatureName' => '<p>The name of the <code>Feature</code> used for <code>RecordIdentifier</code>, whose value uniquely identifies a record stored in the feature store.</p>', 'DescribeFeatureGroupResponse$EventTimeFeatureName' => '<p>The name of the feature that stores the <code>EventTime</code> of a Record in a <code>FeatureGroup</code>.</p> <p> An <code>EventTime</code> is a point in time when a new event occurs that corresponds to the creation or update of a <code>Record</code> in a <code>FeatureGroup</code>. All <code>Records</code> in the <code>FeatureGroup</code> have a corresponding <code>EventTime</code>.</p>', 'DescribeFeatureMetadataRequest$FeatureName' => '<p>The name of the feature.</p>', 'DescribeFeatureMetadataResponse$FeatureName' => '<p>The name of the feature that you\'ve specified.</p>', 'FeatureDefinition$FeatureName' => '<p>The name of a feature. The type must be a string. <code>FeatureName</code> cannot be any of the following: <code>is_deleted</code>, <code>write_time</code>, <code>api_invocation_time</code>.</p> <p>The name:</p> <ul> <li> <p>Must start with an alphanumeric character.</p> </li> <li> <p>Can only include alphanumeric characters, underscores, and hyphens. Spaces are not allowed.</p> </li> </ul>', 'FeatureGroup$RecordIdentifierFeatureName' => '<p>The name of the <code>Feature</code> whose value uniquely identifies a <code>Record</code> defined in the <code>FeatureGroup</code> <code>FeatureDefinitions</code>.</p>', 'FeatureGroup$EventTimeFeatureName' => '<p>The name of the feature that stores the <code>EventTime</code> of a Record in a <code>FeatureGroup</code>.</p> <p>A <code>EventTime</code> is point in time when a new event occurs that corresponds to the creation or update of a <code>Record</code> in <code>FeatureGroup</code>. All <code>Records</code> in the <code>FeatureGroup</code> must have a corresponding <code>EventTime</code>.</p>', 'FeatureMetadata$FeatureName' => '<p>The name of feature.</p>', 'UpdateFeatureMetadataRequest$FeatureName' => '<p>The name of the feature that you\'re updating.</p>', ], ], 'FeatureParameter' => [ 'base' => '<p>A key-value pair that you specify to describe the feature.</p>', 'refs' => [ 'FeatureParameterAdditions$member' => NULL, 'FeatureParameters$member' => NULL, ], ], 'FeatureParameterAdditions' => [ 'base' => NULL, 'refs' => [ 'UpdateFeatureMetadataRequest$ParameterAdditions' => '<p>A list of key-value pairs that you can add to better describe the feature.</p>', ], ], 'FeatureParameterKey' => [ 'base' => NULL, 'refs' => [ 'FeatureParameter$Key' => '<p>A key that must contain a value to describe the feature.</p>', 'FeatureParameterRemovals$member' => NULL, ], ], 'FeatureParameterRemovals' => [ 'base' => NULL, 'refs' => [ 'UpdateFeatureMetadataRequest$ParameterRemovals' => '<p>A list of parameter keys that you can specify to remove parameters that describe your feature.</p>', ], ], 'FeatureParameterValue' => [ 'base' => NULL, 'refs' => [ 'FeatureParameter$Value' => '<p>The value that belongs to a key.</p>', ], ], 'FeatureParameters' => [ 'base' => NULL, 'refs' => [ 'DescribeFeatureMetadataResponse$Parameters' => '<p>The key-value pairs that you added to describe the feature.</p>', 'FeatureMetadata$Parameters' => '<p>Optional key-value pairs that you specify to better describe the feature.</p>', ], ], 'FeatureStatus' => [ 'base' => NULL, 'refs' => [ 'AmazonQSettings$Status' => '<p>Whether Amazon Q has been enabled within the domain.</p>', 'DirectDeploySettings$Status' => '<p>Describes whether model deployment permissions are enabled or disabled in the Canvas application.</p>', 'DockerSettings$EnableDockerAccess' => '<p>Indicates whether the domain can access Docker.</p>', 'IdentityProviderOAuthSetting$Status' => '<p>Describes whether OAuth for a data source is enabled or disabled in the Canvas application.</p>', 'KendraSettings$Status' => '<p>Describes whether the document querying feature is enabled or disabled in the Canvas application.</p>', 'ModelRegisterSettings$Status' => '<p>Describes whether the integration to the model registry is enabled or disabled in the Canvas application.</p>', 'TimeSeriesForecastingSettings$Status' => '<p>Describes whether time series forecasting is enabled or disabled in the Canvas application.</p>', ], ], 'FeatureType' => [ 'base' => NULL, 'refs' => [ 'DescribeFeatureMetadataResponse$FeatureType' => '<p>The data type of the feature.</p>', 'FeatureDefinition$FeatureType' => '<p>The value type of a feature. Valid values are Integral, Fractional, or String.</p>', 'FeatureMetadata$FeatureType' => '<p>The data type of the feature.</p>', ], ], 'FileSource' => [ 'base' => '<p>Contains details regarding the file source.</p>', 'refs' => [ 'DriftCheckBias$ConfigFile' => '<p>The bias config file for a model.</p>', 'DriftCheckExplainability$ConfigFile' => '<p>The explainability config file for the model.</p>', ], ], 'FileSystemAccessMode' => [ 'base' => NULL, 'refs' => [ 'FileSystemDataSource$FileSystemAccessMode' => '<p>The access mode of the mount of the directory associated with the channel. A directory can be mounted either in <code>ro</code> (read-only) or <code>rw</code> (read-write) mode.</p>', ], ], 'FileSystemConfig' => [ 'base' => '<p>The Amazon Elastic File System storage configuration for a SageMaker image.</p>', 'refs' => [ 'CodeEditorAppImageConfig$FileSystemConfig' => NULL, 'JupyterLabAppImageConfig$FileSystemConfig' => NULL, 'KernelGatewayImageConfig$FileSystemConfig' => '<p>The Amazon Elastic File System storage configuration for a SageMaker image.</p>', ], ], 'FileSystemDataSource' => [ 'base' => '<p>Specifies a file system data source for a channel.</p>', 'refs' => [ 'DataSource$FileSystemDataSource' => '<p>The file system that is associated with a channel.</p>', ], ], 'FileSystemId' => [ 'base' => NULL, 'refs' => [ 'EFSFileSystem$FileSystemId' => '<p>The ID of your Amazon EFS file system.</p>', 'EFSFileSystemConfig$FileSystemId' => '<p>The ID of your Amazon EFS file system.</p>', 'FileSystemDataSource$FileSystemId' => '<p>The file system id.</p>', ], ], 'FileSystemPath' => [ 'base' => NULL, 'refs' => [ 'EFSFileSystemConfig$FileSystemPath' => '<p>The path to the file system directory that is accessible in Amazon SageMaker Studio. Permitted users can access only this directory and below.</p>', ], ], 'FileSystemType' => [ 'base' => NULL, 'refs' => [ 'FileSystemDataSource$FileSystemType' => '<p>The file system type. </p>', ], ], 'FillingTransformationMap' => [ 'base' => NULL, 'refs' => [ 'FillingTransformations$value' => NULL, ], ], 'FillingTransformationValue' => [ 'base' => NULL, 'refs' => [ 'FillingTransformationMap$value' => NULL, ], ], 'FillingTransformations' => [ 'base' => NULL, 'refs' => [ 'TimeSeriesTransformations$Filling' => '<p>A key value pair defining the filling method for a column, where the key is the column name and the value is an object which defines the filling logic. You can specify multiple filling methods for a single column.</p> <p>The supported filling methods and their corresponding options are:</p> <ul> <li> <p> <code>frontfill</code>: <code>none</code> (Supported only for target column)</p> </li> <li> <p> <code>middlefill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>, <code>min</code>, <code>max</code> </p> </li> <li> <p> <code>backfill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>, <code>min</code>, <code>max</code> </p> </li> <li> <p> <code>futurefill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>, <code>min</code>, <code>max</code> </p> </li> </ul> <p>To set a filling method to a specific value, set the fill parameter to the chosen filling method value (for example <code>"backfill" : "value"</code>), and define the filling value in an additional parameter prefixed with "_value". For example, to set <code>backfill</code> to a value of <code>2</code>, you must include two parameters: <code>"backfill": "value"</code> and <code>"backfill_value":"2"</code>.</p>', ], ], 'FillingType' => [ 'base' => NULL, 'refs' => [ 'FillingTransformationMap$key' => NULL, ], ], 'Filter' => [ 'base' => '<p>A conditional statement for a search expression that includes a resource property, a Boolean operator, and a value. Resources that match the statement are returned in the results from the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html">Search</a> API.</p> <p>If you specify a <code>Value</code>, but not an <code>Operator</code>, SageMaker uses the equals operator.</p> <p>In search, there are several property types:</p> <dl> <dt>Metrics</dt> <dd> <p>To define a metric filter, enter a value using the form <code>"Metrics.&lt;name&gt;"</code>, where <code>&lt;name&gt;</code> is a metric name. For example, the following filter searches for training jobs with an <code>"accuracy"</code> metric greater than <code>"0.9"</code>:</p> <p> <code>{</code> </p> <p> <code>"Name": "Metrics.accuracy",</code> </p> <p> <code>"Operator": "GreaterThan",</code> </p> <p> <code>"Value": "0.9"</code> </p> <p> <code>}</code> </p> </dd> <dt>HyperParameters</dt> <dd> <p>To define a hyperparameter filter, enter a value with the form <code>"HyperParameters.&lt;name&gt;"</code>. Decimal hyperparameter values are treated as a decimal in a comparison if the specified <code>Value</code> is also a decimal value. If the specified <code>Value</code> is an integer, the decimal hyperparameter values are treated as integers. For example, the following filter is satisfied by training jobs with a <code>"learning_rate"</code> hyperparameter that is less than <code>"0.5"</code>:</p> <p> <code> {</code> </p> <p> <code> "Name": "HyperParameters.learning_rate",</code> </p> <p> <code> "Operator": "LessThan",</code> </p> <p> <code> "Value": "0.5"</code> </p> <p> <code> }</code> </p> </dd> <dt>Tags</dt> <dd> <p>To define a tag filter, enter a value with the form <code>Tags.&lt;key&gt;</code>.</p> </dd> </dl>', 'refs' => [ 'FilterList$member' => NULL, ], ], 'FilterList' => [ 'base' => NULL, 'refs' => [ 'NestedFilters$Filters' => '<p>A list of filters. Each filter acts on a property. Filters must contain at least one <code>Filters</code> value. For example, a <code>NestedFilters</code> call might include a filter on the <code>PropertyName</code> parameter of the <code>InputDataConfig</code> property: <code>InputDataConfig.DataSource.S3DataSource.S3Uri</code>.</p>', 'SearchExpression$Filters' => '<p>A list of filter objects.</p>', ], ], 'FilterValue' => [ 'base' => NULL, 'refs' => [ 'Filter$Value' => '<p>A value used with <code>Name</code> and <code>Operator</code> to determine which resources satisfy the filter\'s condition. For numerical properties, <code>Value</code> must be an integer or floating-point decimal. For timestamp properties, <code>Value</code> must be an ISO 8601 date-time string of the following format: <code>YYYY-mm-dd\'T\'HH:MM:SS</code>.</p>', ], ], 'FinalAutoMLJobObjectiveMetric' => [ 'base' => '<p>The best candidate result from an AutoML training job.</p>', 'refs' => [ 'AutoMLCandidate$FinalAutoMLJobObjectiveMetric' => NULL, ], ], 'FinalHyperParameterTuningJobObjectiveMetric' => [ 'base' => '<p>Shows the latest objective metric emitted by a training job that was launched by a hyperparameter tuning job. You define the objective metric in the <code>HyperParameterTuningJobObjective</code> parameter of <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTuningJobConfig.html">HyperParameterTuningJobConfig</a>.</p>', 'refs' => [ 'HyperParameterTrainingJobSummary$FinalHyperParameterTuningJobObjectiveMetric' => '<p>The <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_FinalHyperParameterTuningJobObjectiveMetric.html">FinalHyperParameterTuningJobObjectiveMetric</a> object that specifies the value of the objective metric of the tuning job that launched this training job.</p>', ], ], 'FinalMetricDataList' => [ 'base' => NULL, 'refs' => [ 'DescribeTrainingJobResponse$FinalMetricDataList' => '<p>A collection of <code>MetricData</code> objects that specify the names, values, and dates and times that the training algorithm emitted to Amazon CloudWatch.</p>', 'TrainingJob$FinalMetricDataList' => '<p>A list of final metric values that are set when the training job completes. Used only if the training job was configured to use metrics.</p>', ], ], 'FlatInvocations' => [ 'base' => NULL, 'refs' => [ 'RecommendationJobStoppingConditions$FlatInvocations' => '<p>Stops a load test when the number of invocations (TPS) peaks and flattens, which means that the instance has reached capacity. The default value is <code>Stop</code>. If you want the load test to continue after invocations have flattened, set the value to <code>Continue</code>.</p>', ], ], 'Float' => [ 'base' => NULL, 'refs' => [ 'MetricData$Value' => '<p>The value of the metric.</p>', 'MetricDatum$Value' => '<p>The value of the metric.</p>', 'RecommendationMetrics$CostPerHour' => '<p>Defines the cost per hour for the instance. </p>', 'RecommendationMetrics$CostPerInference' => '<p>Defines the cost per inference for the instance .</p>', ], ], 'FlowDefinitionArn' => [ 'base' => NULL, 'refs' => [ 'CreateFlowDefinitionResponse$FlowDefinitionArn' => '<p>The Amazon Resource Name (ARN) of the flow definition you create.</p>', 'DescribeFlowDefinitionResponse$FlowDefinitionArn' => '<p>The Amazon Resource Name (ARN) of the flow defintion.</p>', 'FlowDefinitionSummary$FlowDefinitionArn' => '<p>The Amazon Resource Name (ARN) of the flow definition.</p>', ], ], 'FlowDefinitionName' => [ 'base' => NULL, 'refs' => [ 'CreateFlowDefinitionRequest$FlowDefinitionName' => '<p>The name of your flow definition.</p>', 'DeleteFlowDefinitionRequest$FlowDefinitionName' => '<p>The name of the flow definition you are deleting.</p>', 'DescribeFlowDefinitionRequest$FlowDefinitionName' => '<p>The name of the flow definition.</p>', 'DescribeFlowDefinitionResponse$FlowDefinitionName' => '<p>The Amazon Resource Name (ARN) of the flow definition.</p>', 'FlowDefinitionSummary$FlowDefinitionName' => '<p>The name of the flow definition.</p>', ], ], 'FlowDefinitionOutputConfig' => [ 'base' => '<p>Contains information about where human output will be stored.</p>', 'refs' => [ 'CreateFlowDefinitionRequest$OutputConfig' => '<p>An object containing information about where the human review results will be uploaded.</p>', 'DescribeFlowDefinitionResponse$OutputConfig' => '<p>An object containing information about the output file.</p>', ], ], 'FlowDefinitionStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeFlowDefinitionResponse$FlowDefinitionStatus' => '<p>The status of the flow definition. Valid values are listed below.</p>', 'FlowDefinitionSummary$FlowDefinitionStatus' => '<p>The status of the flow definition. Valid values:</p>', ], ], 'FlowDefinitionSummaries' => [ 'base' => NULL, 'refs' => [ 'ListFlowDefinitionsResponse$FlowDefinitionSummaries' => '<p>An array of objects describing the flow definitions.</p>', ], ], 'FlowDefinitionSummary' => [ 'base' => '<p>Contains summary information about the flow definition.</p>', 'refs' => [ 'FlowDefinitionSummaries$member' => NULL, ], ], 'FlowDefinitionTaskAvailabilityLifetimeInSeconds' => [ 'base' => NULL, 'refs' => [ 'HumanLoopConfig$TaskAvailabilityLifetimeInSeconds' => '<p>The length of time that a task remains available for review by human workers.</p>', ], ], 'FlowDefinitionTaskCount' => [ 'base' => NULL, 'refs' => [ 'HumanLoopConfig$TaskCount' => '<p>The number of distinct workers who will perform the same task on each object. For example, if <code>TaskCount</code> is set to <code>3</code> for an image classification labeling job, three workers will classify each input image. Increasing <code>TaskCount</code> can improve label accuracy.</p>', ], ], 'FlowDefinitionTaskDescription' => [ 'base' => NULL, 'refs' => [ 'HumanLoopConfig$TaskDescription' => '<p>A description for the human worker task.</p>', ], ], 'FlowDefinitionTaskKeyword' => [ 'base' => NULL, 'refs' => [ 'FlowDefinitionTaskKeywords$member' => NULL, ], ], 'FlowDefinitionTaskKeywords' => [ 'base' => NULL, 'refs' => [ 'HumanLoopConfig$TaskKeywords' => '<p>Keywords used to describe the task so that workers can discover the task.</p>', ], ], 'FlowDefinitionTaskTimeLimitInSeconds' => [ 'base' => NULL, 'refs' => [ 'HumanLoopConfig$TaskTimeLimitInSeconds' => '<p>The amount of time that a worker has to complete a task. The default value is 3,600 seconds (1 hour).</p>', ], ], 'FlowDefinitionTaskTitle' => [ 'base' => NULL, 'refs' => [ 'HumanLoopConfig$TaskTitle' => '<p>A title for the human worker task.</p>', ], ], 'ForecastFrequency' => [ 'base' => NULL, 'refs' => [ 'TimeSeriesForecastingJobConfig$ForecastFrequency' => '<p>The frequency of predictions in a forecast.</p> <p>Valid intervals are an integer followed by Y (Year), M (Month), W (Week), D (Day), H (Hour), and min (Minute). For example, <code>1D</code> indicates every day and <code>15min</code> indicates every 15 minutes. The value of a frequency must not overlap with the next larger frequency. For example, you must use a frequency of <code>1H</code> instead of <code>60min</code>.</p> <p>The valid values for each frequency are the following:</p> <ul> <li> <p>Minute - 1-59</p> </li> <li> <p>Hour - 1-23</p> </li> <li> <p>Day - 1-6</p> </li> <li> <p>Week - 1-4</p> </li> <li> <p>Month - 1-11</p> </li> <li> <p>Year - 1</p> </li> </ul>', ], ], 'ForecastHorizon' => [ 'base' => NULL, 'refs' => [ 'TimeSeriesForecastingJobConfig$ForecastHorizon' => '<p>The number of time-steps that the model predicts. The forecast horizon is also called the prediction length. The maximum forecast horizon is the lesser of 500 time-steps or 1/4 of the time-steps in the dataset.</p>', ], ], 'ForecastQuantile' => [ 'base' => NULL, 'refs' => [ 'ForecastQuantiles$member' => NULL, ], ], 'ForecastQuantiles' => [ 'base' => NULL, 'refs' => [ 'TimeSeriesForecastingJobConfig$ForecastQuantiles' => '<p>The quantiles used to train the model for forecasts at a specified quantile. You can specify quantiles from <code>0.01</code> (p1) to <code>0.99</code> (p99), by increments of 0.01 or higher. Up to five forecast quantiles can be specified. When <code>ForecastQuantiles</code> is not provided, the AutoML job uses the quantiles p10, p50, and p90 as default.</p>', ], ], 'Framework' => [ 'base' => NULL, 'refs' => [ 'InputConfig$Framework' => '<p>Identifies the framework in which the model was trained. For example: TENSORFLOW.</p>', ], ], 'FrameworkVersion' => [ 'base' => NULL, 'refs' => [ 'InputConfig$FrameworkVersion' => '<p>Specifies the framework version to use. This API field is only supported for the MXNet, PyTorch, TensorFlow and TensorFlow Lite frameworks.</p> <p>For information about framework versions supported for cloud targets and edge devices, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/neo-supported-cloud.html">Cloud Supported Instance Types and Frameworks</a> and <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/neo-supported-devices-edge-frameworks.html">Edge Supported Frameworks</a>.</p>', ], ], 'GenerateCandidateDefinitionsOnly' => [ 'base' => NULL, 'refs' => [ 'CreateAutoMLJobRequest$GenerateCandidateDefinitionsOnly' => '<p>Generates possible candidates without training the models. A candidate is a combination of data preprocessors, algorithms, and algorithm parameter settings.</p>', 'DescribeAutoMLJobResponse$GenerateCandidateDefinitionsOnly' => '<p>Indicates whether the output for an AutoML job generates candidate definitions only.</p>', 'TabularJobConfig$GenerateCandidateDefinitionsOnly' => '<p>Generates possible candidates without training the models. A model candidate is a combination of data preprocessors, algorithms, and algorithm parameter settings.</p>', ], ], 'GenerativeAiSettings' => [ 'base' => '<p>The generative AI settings for the SageMaker Canvas application.</p> <p>Configure these settings for Canvas users starting chats with generative AI foundation models. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/canvas-fm-chat.html"> Use generative AI with foundation models</a>.</p>', 'refs' => [ 'CanvasAppSettings$GenerativeAiSettings' => '<p>The generative AI settings for the SageMaker Canvas application.</p>', ], ], 'GetDeviceFleetReportRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDeviceFleetReportResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetLineageGroupPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetLineageGroupPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetModelPackageGroupPolicyInput' => [ 'base' => NULL, 'refs' => [], ], 'GetModelPackageGroupPolicyOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetSagemakerServicecatalogPortfolioStatusInput' => [ 'base' => NULL, 'refs' => [], ], 'GetSagemakerServicecatalogPortfolioStatusOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetScalingConfigurationRecommendationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetScalingConfigurationRecommendationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetSearchSuggestionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSearchSuggestionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'Gid' => [ 'base' => NULL, 'refs' => [ 'CustomPosixUserConfig$Gid' => '<p>The POSIX group ID.</p>', ], ], 'GitConfig' => [ 'base' => '<p>Specifies configuration details for a Git repository in your Amazon Web Services account.</p>', 'refs' => [ 'CodeRepositorySummary$GitConfig' => '<p>Configuration details for the Git repository, including the URL where it is located and the ARN of the Amazon Web Services Secrets Manager secret that contains the credentials used to access the repository.</p>', 'CreateCodeRepositoryInput$GitConfig' => '<p>Specifies details about the repository, including the URL where the repository is located, the default branch, and credentials to use to access the repository.</p>', 'DescribeCodeRepositoryOutput$GitConfig' => '<p>Configuration details about the repository, including the URL where the repository is located, the default branch, and the Amazon Resource Name (ARN) of the Amazon Web Services Secrets Manager secret that contains the credentials used to access the repository.</p>', ], ], 'GitConfigForUpdate' => [ 'base' => '<p>Specifies configuration details for a Git repository when the repository is updated.</p>', 'refs' => [ 'UpdateCodeRepositoryInput$GitConfig' => '<p>The configuration of the git repository, including the URL and the Amazon Resource Name (ARN) of the Amazon Web Services Secrets Manager secret that contains the credentials used to access the repository. The secret must have a staging label of <code>AWSCURRENT</code> and must be in the following format:</p> <p> <code>{"username": <i>UserName</i>, "password": <i>Password</i>}</code> </p>', ], ], 'GitConfigUrl' => [ 'base' => NULL, 'refs' => [ 'GitConfig$RepositoryUrl' => '<p>The URL where the Git repository is located.</p>', ], ], 'Group' => [ 'base' => NULL, 'refs' => [ 'Groups$member' => NULL, ], ], 'GroupingAttributeName' => [ 'base' => NULL, 'refs' => [ 'GroupingAttributeNames$member' => NULL, ], ], 'GroupingAttributeNames' => [ 'base' => NULL, 'refs' => [ 'TimeSeriesConfig$GroupingAttributeNames' => '<p>A set of columns names that can be grouped with the item identifier column to create a composite key for which a target value is predicted.</p>', ], ], 'Groups' => [ 'base' => NULL, 'refs' => [ 'OidcMemberDefinition$Groups' => '<p>A list of comma seperated strings that identifies user groups in your OIDC IdP. Each user group is made up of a group of private workers.</p>', ], ], 'HiddenAppTypesList' => [ 'base' => NULL, 'refs' => [ 'StudioWebPortalSettings$HiddenAppTypes' => '<p>The <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/studio-updated-apps.html">Applications supported in Studio</a> that are hidden from the Studio left navigation pane.</p>', ], ], 'HiddenMlToolsList' => [ 'base' => NULL, 'refs' => [ 'StudioWebPortalSettings$HiddenMlTools' => '<p>The machine learning tools that are hidden from the Studio left navigation pane.</p>', ], ], 'HolidayConfig' => [ 'base' => NULL, 'refs' => [ 'TimeSeriesForecastingJobConfig$HolidayConfig' => '<p>The collection of holiday featurization attributes used to incorporate national holiday information into your forecasting model.</p>', ], ], 'HolidayConfigAttributes' => [ 'base' => '<p>Stores the holiday featurization attributes applicable to each item of time-series datasets during the training of a forecasting model. This allows the model to identify patterns associated with specific holidays.</p>', 'refs' => [ 'HolidayConfig$member' => NULL, ], ], 'HookParameters' => [ 'base' => NULL, 'refs' => [ 'DebugHookConfig$HookParameters' => '<p>Configuration information for the Amazon SageMaker Debugger hook parameters.</p>', ], ], 'Horovod' => [ 'base' => NULL, 'refs' => [ 'CreateImageVersionRequest$Horovod' => '<p>Indicates Horovod compatibility.</p>', 'DescribeImageVersionResponse$Horovod' => '<p>Indicates Horovod compatibility.</p>', 'UpdateImageVersionRequest$Horovod' => '<p>Indicates Horovod compatibility.</p>', ], ], 'HubArn' => [ 'base' => NULL, 'refs' => [ 'CreateHubContentReferenceResponse$HubArn' => '<p>The ARN of the hub that the hub content reference was added to.</p>', 'CreateHubResponse$HubArn' => '<p>The Amazon Resource Name (ARN) of the hub.</p>', 'DescribeHubContentResponse$HubArn' => '<p>The Amazon Resource Name (ARN) of the hub that contains the content. </p>', 'DescribeHubResponse$HubArn' => '<p>The Amazon Resource Name (ARN) of the hub.</p>', 'HubInfo$HubArn' => '<p>The Amazon Resource Name (ARN) of the hub.</p>', 'ImportHubContentResponse$HubArn' => '<p>The ARN of the hub that the content was imported into.</p>', 'UpdateHubResponse$HubArn' => '<p>The Amazon Resource Name (ARN) of the updated hub.</p>', ], ], 'HubContentArn' => [ 'base' => NULL, 'refs' => [ 'CreateHubContentReferenceResponse$HubContentArn' => '<p>The ARN of the hub content.</p>', 'DescribeHubContentResponse$HubContentArn' => '<p>The Amazon Resource Name (ARN) of the hub content.</p>', 'HubContentInfo$HubContentArn' => '<p>The Amazon Resource Name (ARN) of the hub content.</p>', 'ImportHubContentResponse$HubContentArn' => '<p>The ARN of the hub content that was imported.</p>', 'InferenceHubAccessConfig$HubContentArn' => '<p>The ARN of the hub content for which deployment access is allowed.</p>', ], ], 'HubContentDependency' => [ 'base' => '<p>Any dependencies related to hub content, such as scripts, model artifacts, datasets, or notebooks.</p>', 'refs' => [ 'HubContentDependencyList$member' => NULL, ], ], 'HubContentDependencyList' => [ 'base' => NULL, 'refs' => [ 'DescribeHubContentResponse$HubContentDependencies' => '<p>The location of any dependencies that the hub content has, such as scripts, model artifacts, datasets, or notebooks.</p>', ], ], 'HubContentDescription' => [ 'base' => NULL, 'refs' => [ 'DescribeHubContentResponse$HubContentDescription' => '<p>A description of the hub content.</p>', 'HubContentInfo$HubContentDescription' => '<p>A description of the hub content.</p>', 'ImportHubContentRequest$HubContentDescription' => '<p>A description of the hub content to import.</p>', ], ], 'HubContentDisplayName' => [ 'base' => NULL, 'refs' => [ 'DescribeHubContentResponse$HubContentDisplayName' => '<p>The display name of the hub content.</p>', 'HubContentInfo$HubContentDisplayName' => '<p>The display name of the hub content.</p>', 'ImportHubContentRequest$HubContentDisplayName' => '<p>The display name of the hub content to import.</p>', ], ], 'HubContentDocument' => [ 'base' => NULL, 'refs' => [ 'DescribeHubContentResponse$HubContentDocument' => '<p>The hub content document that describes information about the hub content such as type, associated containers, scripts, and more.</p>', 'ImportHubContentRequest$HubContentDocument' => '<p>The hub content document that describes information about the hub content such as type, associated containers, scripts, and more.</p>', ], ], 'HubContentInfo' => [ 'base' => '<p>Information about hub content.</p>', 'refs' => [ 'HubContentInfoList$member' => NULL, ], ], 'HubContentInfoList' => [ 'base' => NULL, 'refs' => [ 'ListHubContentVersionsResponse$HubContentSummaries' => '<p>The summaries of the listed hub content versions.</p>', 'ListHubContentsResponse$HubContentSummaries' => '<p>The summaries of the listed hub content.</p>', ], ], 'HubContentMarkdown' => [ 'base' => NULL, 'refs' => [ 'DescribeHubContentResponse$HubContentMarkdown' => '<p>A string that provides a description of the hub content. This string can include links, tables, and standard markdown formating.</p>', 'ImportHubContentRequest$HubContentMarkdown' => '<p>A string that provides a description of the hub content. This string can include links, tables, and standard markdown formating.</p>', ], ], 'HubContentName' => [ 'base' => NULL, 'refs' => [ 'CreateHubContentReferenceRequest$HubContentName' => '<p>The name of the hub content to reference.</p>', 'DeleteHubContentReferenceRequest$HubContentName' => '<p>The name of the hub content to delete.</p>', 'DeleteHubContentRequest$HubContentName' => '<p>The name of the content that you want to delete from a hub.</p>', 'DescribeHubContentRequest$HubContentName' => '<p>The name of the content to describe.</p>', 'DescribeHubContentResponse$HubContentName' => '<p>The name of the hub content.</p>', 'HubContentInfo$HubContentName' => '<p>The name of the hub content.</p>', 'ImportHubContentRequest$HubContentName' => '<p>The name of the hub content to import.</p>', 'ListHubContentVersionsRequest$HubContentName' => '<p>The name of the hub content.</p>', ], ], 'HubContentSearchKeywordList' => [ 'base' => NULL, 'refs' => [ 'DescribeHubContentResponse$HubContentSearchKeywords' => '<p>The searchable keywords for the hub content.</p>', 'HubContentInfo$HubContentSearchKeywords' => '<p>The searchable keywords for the hub content.</p>', 'ImportHubContentRequest$HubContentSearchKeywords' => '<p>The searchable keywords of the hub content.</p>', ], ], 'HubContentSortBy' => [ 'base' => NULL, 'refs' => [ 'ListHubContentVersionsRequest$SortBy' => '<p>Sort hub content versions by either name or creation time.</p>', 'ListHubContentsRequest$SortBy' => '<p>Sort hub content versions by either name or creation time.</p>', ], ], 'HubContentStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeHubContentResponse$HubContentStatus' => '<p>The status of the hub content.</p>', 'HubContentInfo$HubContentStatus' => '<p>The status of the hub content.</p>', ], ], 'HubContentSupportStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeHubContentResponse$SupportStatus' => '<p>The support status of the hub content.</p>', 'HubContentInfo$SupportStatus' => '<p>The support status of the hub content.</p>', ], ], 'HubContentType' => [ 'base' => NULL, 'refs' => [ 'DeleteHubContentReferenceRequest$HubContentType' => '<p>The type of hub content reference to delete. The only supported type of hub content reference to delete is <code>ModelReference</code>.</p>', 'DeleteHubContentRequest$HubContentType' => '<p>The type of content that you want to delete from a hub.</p>', 'DescribeHubContentRequest$HubContentType' => '<p>The type of content in the hub.</p>', 'DescribeHubContentResponse$HubContentType' => '<p>The type of hub content.</p>', 'HubContentInfo$HubContentType' => '<p>The type of hub content.</p>', 'ImportHubContentRequest$HubContentType' => '<p>The type of hub content to import.</p>', 'ListHubContentVersionsRequest$HubContentType' => '<p>The type of hub content to list versions of.</p>', 'ListHubContentsRequest$HubContentType' => '<p>The type of hub content to list.</p>', ], ], 'HubContentVersion' => [ 'base' => NULL, 'refs' => [ 'CreateHubContentReferenceRequest$MinVersion' => '<p>The minimum version of the hub content to reference.</p>', 'DeleteHubContentRequest$HubContentVersion' => '<p>The version of the content that you want to delete from a hub.</p>', 'DescribeHubContentRequest$HubContentVersion' => '<p>The version of the content to describe.</p>', 'DescribeHubContentResponse$HubContentVersion' => '<p>The version of the hub content.</p>', 'HubContentInfo$HubContentVersion' => '<p>The version of the hub content.</p>', 'ImportHubContentRequest$HubContentVersion' => '<p>The version of the hub content to import.</p>', 'ListHubContentVersionsRequest$MinVersion' => '<p>The lower bound of the hub content versions to list.</p>', ], ], 'HubDescription' => [ 'base' => NULL, 'refs' => [ 'CreateHubRequest$HubDescription' => '<p>A description of the hub.</p>', 'DescribeHubResponse$HubDescription' => '<p>A description of the hub.</p>', 'HubInfo$HubDescription' => '<p>A description of the hub.</p>', 'UpdateHubRequest$HubDescription' => '<p>A description of the updated hub.</p>', ], ], 'HubDisplayName' => [ 'base' => NULL, 'refs' => [ 'CreateHubRequest$HubDisplayName' => '<p>The display name of the hub.</p>', 'DescribeHubResponse$HubDisplayName' => '<p>The display name of the hub.</p>', 'HubInfo$HubDisplayName' => '<p>The display name of the hub.</p>', 'UpdateHubRequest$HubDisplayName' => '<p>The display name of the hub.</p>', ], ], 'HubInfo' => [ 'base' => '<p>Information about a hub.</p>', 'refs' => [ 'HubInfoList$member' => NULL, ], ], 'HubInfoList' => [ 'base' => NULL, 'refs' => [ 'ListHubsResponse$HubSummaries' => '<p>The summaries of the listed hubs.</p>', ], ], 'HubName' => [ 'base' => NULL, 'refs' => [ 'CreateHubRequest$HubName' => '<p>The name of the hub to create.</p>', 'DescribeHubContentResponse$HubName' => '<p>The name of the hub that contains the content.</p>', 'DescribeHubResponse$HubName' => '<p>The name of the hub.</p>', 'HubInfo$HubName' => '<p>The name of the hub.</p>', ], ], 'HubNameOrArn' => [ 'base' => NULL, 'refs' => [ 'CreateHubContentReferenceRequest$HubName' => '<p>The name of the hub to add the hub content reference to.</p>', 'DeleteHubContentReferenceRequest$HubName' => '<p>The name of the hub to delete the hub content reference from.</p>', 'DeleteHubContentRequest$HubName' => '<p>The name of the hub that you want to delete content in.</p>', 'DeleteHubRequest$HubName' => '<p>The name of the hub to delete.</p>', 'DescribeHubContentRequest$HubName' => '<p>The name of the hub that contains the content to describe.</p>', 'DescribeHubRequest$HubName' => '<p>The name of the hub to describe.</p>', 'ImportHubContentRequest$HubName' => '<p>The name of the hub to import content into.</p>', 'ListHubContentVersionsRequest$HubName' => '<p>The name of the hub to list the content versions of.</p>', 'ListHubContentsRequest$HubName' => '<p>The name of the hub to list the contents of.</p>', 'UpdateHubRequest$HubName' => '<p>The name of the hub to update.</p>', ], ], 'HubS3StorageConfig' => [ 'base' => '<p>The Amazon S3 storage configuration of a hub.</p>', 'refs' => [ 'CreateHubRequest$S3StorageConfig' => '<p>The Amazon S3 storage configuration for the hub.</p>', 'DescribeHubResponse$S3StorageConfig' => '<p>The Amazon S3 storage configuration for the hub.</p>', ], ], 'HubSearchKeyword' => [ 'base' => NULL, 'refs' => [ 'HubContentSearchKeywordList$member' => NULL, 'HubSearchKeywordList$member' => NULL, ], ], 'HubSearchKeywordList' => [ 'base' => NULL, 'refs' => [ 'CreateHubRequest$HubSearchKeywords' => '<p>The searchable keywords for the hub.</p>', 'DescribeHubResponse$HubSearchKeywords' => '<p>The searchable keywords for the hub.</p>', 'HubInfo$HubSearchKeywords' => '<p>The searchable keywords for the hub.</p>', 'UpdateHubRequest$HubSearchKeywords' => '<p>The searchable keywords for the hub.</p>', ], ], 'HubSortBy' => [ 'base' => NULL, 'refs' => [ 'ListHubsRequest$SortBy' => '<p>Sort hubs by either name or creation time.</p>', ], ], 'HubStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeHubResponse$HubStatus' => '<p>The status of the hub.</p>', 'HubInfo$HubStatus' => '<p>The status of the hub.</p>', ], ], 'HumanLoopActivationConditions' => [ 'base' => NULL, 'refs' => [ 'HumanLoopActivationConditionsConfig$HumanLoopActivationConditions' => '<p>JSON expressing use-case specific conditions declaratively. If any condition is matched, atomic tasks are created against the configured work team. The set of conditions is different for Rekognition and Textract. For more information about how to structure the JSON, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/a2i-human-fallback-conditions-json-schema.html">JSON Schema for Human Loop Activation Conditions in Amazon Augmented AI</a> in the <i>Amazon SageMaker Developer Guide</i>.</p>', ], ], 'HumanLoopActivationConditionsConfig' => [ 'base' => '<p>Defines under what conditions SageMaker creates a human loop. Used within <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateFlowDefinition.html">CreateFlowDefinition</a>. See <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HumanLoopActivationConditionsConfig.html">HumanLoopActivationConditionsConfig</a> for the required format of activation conditions.</p>', 'refs' => [ 'HumanLoopActivationConfig$HumanLoopActivationConditionsConfig' => '<p>Container structure for defining under what conditions SageMaker creates a human loop.</p>', ], ], 'HumanLoopActivationConfig' => [ 'base' => '<p>Provides information about how and under what conditions SageMaker creates a human loop. If <code>HumanLoopActivationConfig</code> is not given, then all requests go to humans.</p>', 'refs' => [ 'CreateFlowDefinitionRequest$HumanLoopActivationConfig' => '<p>An object containing information about the events that trigger a human workflow.</p>', 'DescribeFlowDefinitionResponse$HumanLoopActivationConfig' => '<p>An object containing information about what triggers a human review workflow.</p>', ], ], 'HumanLoopConfig' => [ 'base' => '<p>Describes the work to be performed by human workers.</p>', 'refs' => [ 'CreateFlowDefinitionRequest$HumanLoopConfig' => '<p>An object containing information about the tasks the human reviewers will perform.</p>', 'DescribeFlowDefinitionResponse$HumanLoopConfig' => '<p>An object containing information about who works on the task, the workforce task price, and other task details.</p>', ], ], 'HumanLoopRequestSource' => [ 'base' => '<p>Container for configuring the source of human task requests.</p>', 'refs' => [ 'CreateFlowDefinitionRequest$HumanLoopRequestSource' => '<p>Container for configuring the source of human task requests. Use to specify if Amazon Rekognition or Amazon Textract is used as an integration source.</p>', 'DescribeFlowDefinitionResponse$HumanLoopRequestSource' => '<p>Container for configuring the source of human task requests. Used to specify if Amazon Rekognition or Amazon Textract is used as an integration source.</p>', ], ], 'HumanTaskConfig' => [ 'base' => '<p>Information required for human workers to complete a labeling task.</p>', 'refs' => [ 'CreateLabelingJobRequest$HumanTaskConfig' => '<p>Configures the labeling task and how it is presented to workers; including, but not limited to price, keywords, and batch size (task count).</p>', 'DescribeLabelingJobResponse$HumanTaskConfig' => '<p>Configuration information required for human workers to complete a labeling task.</p>', ], ], 'HumanTaskUiArn' => [ 'base' => NULL, 'refs' => [ 'CreateHumanTaskUiResponse$HumanTaskUiArn' => '<p>The Amazon Resource Name (ARN) of the human review workflow user interface you create.</p>', 'DescribeHumanTaskUiResponse$HumanTaskUiArn' => '<p>The Amazon Resource Name (ARN) of the human task user interface (worker task template).</p>', 'HumanLoopConfig$HumanTaskUiArn' => '<p>The Amazon Resource Name (ARN) of the human task user interface.</p> <p>You can use standard HTML and Crowd HTML Elements to create a custom worker task template. You use this template to create a human task UI.</p> <p>To learn how to create a custom HTML template, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/a2i-custom-templates.html">Create Custom Worker Task Template</a>.</p> <p>To learn how to create a human task UI, which is a worker task template that can be used in a flow definition, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/a2i-worker-template-console.html">Create and Delete a Worker Task Templates</a>.</p>', 'HumanTaskUiSummary$HumanTaskUiArn' => '<p>The Amazon Resource Name (ARN) of the human task user interface.</p>', 'RenderUiTemplateRequest$HumanTaskUiArn' => '<p>The <code>HumanTaskUiArn</code> of the worker UI that you want to render. Do not provide a <code>HumanTaskUiArn</code> if you use the <code>UiTemplate</code> parameter.</p> <p>See a list of available Human Ui Amazon Resource Names (ARNs) in <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UiConfig.html">UiConfig</a>.</p>', 'UiConfig$HumanTaskUiArn' => '<p>The ARN of the worker task template used to render the worker UI and tools for labeling job tasks.</p> <p>Use this parameter when you are creating a labeling job for named entity recognition, 3D point cloud and video frame labeling jobs. Use your labeling job task type to select one of the following ARNs and use it with this parameter when you create a labeling job. Replace <code>aws-region</code> with the Amazon Web Services Region you are creating your labeling job in. For example, replace <code>aws-region</code> with <code>us-west-1</code> if you create a labeling job in US West (N. California).</p> <p> <b>Named Entity Recognition</b> </p> <p>Use the following <code>HumanTaskUiArn</code> for named entity recognition labeling jobs:</p> <p> <code>arn:aws:sagemaker:aws-region:394669845002:human-task-ui/NamedEntityRecognition</code> </p> <p> <b>3D Point Cloud HumanTaskUiArns</b> </p> <p>Use this <code>HumanTaskUiArn</code> for 3D point cloud object detection and 3D point cloud object detection adjustment labeling jobs. </p> <ul> <li> <p> <code>arn:aws:sagemaker:aws-region:394669845002:human-task-ui/PointCloudObjectDetection</code> </p> </li> </ul> <p> Use this <code>HumanTaskUiArn</code> for 3D point cloud object tracking and 3D point cloud object tracking adjustment labeling jobs. </p> <ul> <li> <p> <code>arn:aws:sagemaker:aws-region:394669845002:human-task-ui/PointCloudObjectTracking</code> </p> </li> </ul> <p> Use this <code>HumanTaskUiArn</code> for 3D point cloud semantic segmentation and 3D point cloud semantic segmentation adjustment labeling jobs.</p> <ul> <li> <p> <code>arn:aws:sagemaker:aws-region:394669845002:human-task-ui/PointCloudSemanticSegmentation</code> </p> </li> </ul> <p> <b>Video Frame HumanTaskUiArns</b> </p> <p>Use this <code>HumanTaskUiArn</code> for video frame object detection and video frame object detection adjustment labeling jobs. </p> <ul> <li> <p> <code>arn:aws:sagemaker:region:394669845002:human-task-ui/VideoObjectDetection</code> </p> </li> </ul> <p> Use this <code>HumanTaskUiArn</code> for video frame object tracking and video frame object tracking adjustment labeling jobs. </p> <ul> <li> <p> <code>arn:aws:sagemaker:aws-region:394669845002:human-task-ui/VideoObjectTracking</code> </p> </li> </ul>', ], ], 'HumanTaskUiName' => [ 'base' => NULL, 'refs' => [ 'CreateHumanTaskUiRequest$HumanTaskUiName' => '<p>The name of the user interface you are creating.</p>', 'DeleteHumanTaskUiRequest$HumanTaskUiName' => '<p>The name of the human task user interface (work task template) you want to delete.</p>', 'DescribeHumanTaskUiRequest$HumanTaskUiName' => '<p>The name of the human task user interface (worker task template) you want information about.</p>', 'DescribeHumanTaskUiResponse$HumanTaskUiName' => '<p>The name of the human task user interface (worker task template).</p>', 'HumanTaskUiSummary$HumanTaskUiName' => '<p>The name of the human task user interface.</p>', ], ], 'HumanTaskUiStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeHumanTaskUiResponse$HumanTaskUiStatus' => '<p>The status of the human task user interface (worker task template). Valid values are listed below.</p>', ], ], 'HumanTaskUiSummaries' => [ 'base' => NULL, 'refs' => [ 'ListHumanTaskUisResponse$HumanTaskUiSummaries' => '<p>An array of objects describing the human task user interfaces.</p>', ], ], 'HumanTaskUiSummary' => [ 'base' => '<p>Container for human task user interface information.</p>', 'refs' => [ 'HumanTaskUiSummaries$member' => NULL, ], ], 'HyperParameterAlgorithmSpecification' => [ 'base' => '<p>Specifies which training algorithm to use for training jobs that a hyperparameter tuning job launches and the metrics to monitor.</p>', 'refs' => [ 'HyperParameterTrainingJobDefinition$AlgorithmSpecification' => '<p>The <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterAlgorithmSpecification.html">HyperParameterAlgorithmSpecification</a> object that specifies the resource algorithm to use for the training jobs that the tuning job launches.</p>', ], ], 'HyperParameterKey' => [ 'base' => NULL, 'refs' => [ 'HyperParameters$key' => NULL, ], ], 'HyperParameterScalingType' => [ 'base' => NULL, 'refs' => [ 'ContinuousParameterRange$ScalingType' => '<p>The scale that hyperparameter tuning uses to search the hyperparameter range. For information about choosing a hyperparameter scale, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-ranges.html#scaling-type">Hyperparameter Scaling</a>. One of the following values:</p> <dl> <dt>Auto</dt> <dd> <p>SageMaker hyperparameter tuning chooses the best scale for the hyperparameter.</p> </dd> <dt>Linear</dt> <dd> <p>Hyperparameter tuning searches the values in the hyperparameter range by using a linear scale.</p> </dd> <dt>Logarithmic</dt> <dd> <p>Hyperparameter tuning searches the values in the hyperparameter range by using a logarithmic scale.</p> <p>Logarithmic scaling works only for ranges that have only values greater than 0.</p> </dd> <dt>ReverseLogarithmic</dt> <dd> <p>Hyperparameter tuning searches the values in the hyperparameter range by using a reverse logarithmic scale.</p> <p>Reverse logarithmic scaling works only for ranges that are entirely within the range 0&lt;=x&lt;1.0.</p> </dd> </dl>', 'IntegerParameterRange$ScalingType' => '<p>The scale that hyperparameter tuning uses to search the hyperparameter range. For information about choosing a hyperparameter scale, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-ranges.html#scaling-type">Hyperparameter Scaling</a>. One of the following values:</p> <dl> <dt>Auto</dt> <dd> <p>SageMaker hyperparameter tuning chooses the best scale for the hyperparameter.</p> </dd> <dt>Linear</dt> <dd> <p>Hyperparameter tuning searches the values in the hyperparameter range by using a linear scale.</p> </dd> <dt>Logarithmic</dt> <dd> <p>Hyperparameter tuning searches the values in the hyperparameter range by using a logarithmic scale.</p> <p>Logarithmic scaling works only for ranges that have only values greater than 0.</p> </dd> </dl>', ], ], 'HyperParameterSpecification' => [ 'base' => '<p>Defines a hyperparameter to be used by an algorithm.</p>', 'refs' => [ 'HyperParameterSpecifications$member' => NULL, ], ], 'HyperParameterSpecifications' => [ 'base' => NULL, 'refs' => [ 'TrainingSpecification$SupportedHyperParameters' => '<p>A list of the <code>HyperParameterSpecification</code> objects, that define the supported hyperparameters. This is required if the algorithm supports automatic model tuning.&gt;</p>', ], ], 'HyperParameterTrainingJobDefinition' => [ 'base' => '<p>Defines the training jobs launched by a hyperparameter tuning job.</p>', 'refs' => [ 'CreateHyperParameterTuningJobRequest$TrainingJobDefinition' => '<p>The <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTrainingJobDefinition.html">HyperParameterTrainingJobDefinition</a> object that describes the training jobs that this tuning job launches, including static hyperparameters, input data configuration, output data configuration, resource configuration, and stopping condition.</p>', 'DescribeHyperParameterTuningJobResponse$TrainingJobDefinition' => '<p>The <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTrainingJobDefinition.html">HyperParameterTrainingJobDefinition</a> object that specifies the definition of the training jobs that this tuning job launches.</p>', 'HyperParameterTrainingJobDefinitions$member' => NULL, 'HyperParameterTuningJobSearchEntity$TrainingJobDefinition' => NULL, ], ], 'HyperParameterTrainingJobDefinitionName' => [ 'base' => NULL, 'refs' => [ 'HyperParameterTrainingJobDefinition$DefinitionName' => '<p>The job definition name.</p>', 'HyperParameterTrainingJobSummary$TrainingJobDefinitionName' => '<p>The training job definition name.</p>', ], ], 'HyperParameterTrainingJobDefinitions' => [ 'base' => NULL, 'refs' => [ 'CreateHyperParameterTuningJobRequest$TrainingJobDefinitions' => '<p>A list of the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTrainingJobDefinition.html">HyperParameterTrainingJobDefinition</a> objects launched for this tuning job.</p>', 'DescribeHyperParameterTuningJobResponse$TrainingJobDefinitions' => '<p>A list of the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTrainingJobDefinition.html">HyperParameterTrainingJobDefinition</a> objects launched for this tuning job.</p>', 'HyperParameterTuningJobSearchEntity$TrainingJobDefinitions' => '<p>The job definitions included in a hyperparameter tuning job.</p>', ], ], 'HyperParameterTrainingJobEnvironmentKey' => [ 'base' => NULL, 'refs' => [ 'HyperParameterTrainingJobEnvironmentMap$key' => NULL, ], ], 'HyperParameterTrainingJobEnvironmentMap' => [ 'base' => NULL, 'refs' => [ 'HyperParameterTrainingJobDefinition$Environment' => '<p>An environment variable that you can pass into the SageMaker <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTrainingJob.html">CreateTrainingJob</a> API. You can use an existing <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTrainingJob.html#sagemaker-CreateTrainingJob-request-Environment">environment variable from the training container</a> or use your own. See <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-metrics-variables.html">Define metrics and variables</a> for more information.</p> <note> <p>The maximum number of items specified for <code>Map Entries</code> refers to the maximum number of environment variables for each <code>TrainingJobDefinition</code> and also the maximum for the hyperparameter tuning job itself. That is, the sum of the number of environment variables for all the training job definitions can\'t exceed the maximum number specified.</p> </note>', ], ], 'HyperParameterTrainingJobEnvironmentValue' => [ 'base' => NULL, 'refs' => [ 'HyperParameterTrainingJobEnvironmentMap$value' => NULL, ], ], 'HyperParameterTrainingJobSummaries' => [ 'base' => NULL, 'refs' => [ 'ListTrainingJobsForHyperParameterTuningJobResponse$TrainingJobSummaries' => '<p>A list of <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_TrainingJobSummary.html">TrainingJobSummary</a> objects that describe the training jobs that the <code>ListTrainingJobsForHyperParameterTuningJob</code> request returned.</p>', ], ], 'HyperParameterTrainingJobSummary' => [ 'base' => '<p>The container for the summary information about a training job.</p>', 'refs' => [ 'DescribeHyperParameterTuningJobResponse$BestTrainingJob' => '<p>A <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_TrainingJobSummary.html">TrainingJobSummary</a> object that describes the training job that completed with the best current <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTuningJobObjective.html">HyperParameterTuningJobObjective</a>.</p>', 'DescribeHyperParameterTuningJobResponse$OverallBestTrainingJob' => '<p>If the hyperparameter tuning job is an warm start tuning job with a <code>WarmStartType</code> of <code>IDENTICAL_DATA_AND_ALGORITHM</code>, this is the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_TrainingJobSummary.html">TrainingJobSummary</a> for the training job with the best objective metric value of all training jobs launched by this tuning job and all parent jobs specified for the warm start tuning job.</p>', 'HyperParameterTrainingJobSummaries$member' => NULL, 'HyperParameterTuningJobSearchEntity$BestTrainingJob' => NULL, 'HyperParameterTuningJobSearchEntity$OverallBestTrainingJob' => NULL, ], ], 'HyperParameterTuningAllocationStrategy' => [ 'base' => NULL, 'refs' => [ 'HyperParameterTuningResourceConfig$AllocationStrategy' => '<p>The strategy that determines the order of preference for resources specified in <code>InstanceConfigs</code> used in hyperparameter optimization.</p>', ], ], 'HyperParameterTuningInstanceConfig' => [ 'base' => '<p>The configuration for hyperparameter tuning resources for use in training jobs launched by the tuning job. These resources include compute instances and storage volumes. Specify one or more compute instance configurations and allocation strategies to select resources (optional).</p>', 'refs' => [ 'HyperParameterTuningInstanceConfigs$member' => NULL, ], ], 'HyperParameterTuningInstanceConfigs' => [ 'base' => NULL, 'refs' => [ 'HyperParameterTuningResourceConfig$InstanceConfigs' => '<p>A list containing the configuration(s) for one or more resources for processing hyperparameter jobs. These resources include compute instances and storage volumes to use in model training jobs launched by hyperparameter tuning jobs. The <code>AllocationStrategy</code> controls the order in which multiple configurations provided in <code>InstanceConfigs</code> are used.</p> <note> <p>If you only want to use a single instance configuration inside the <code>HyperParameterTuningResourceConfig</code> API, do not provide a value for <code>InstanceConfigs</code>. Instead, use <code>InstanceType</code>, <code>VolumeSizeInGB</code> and <code>InstanceCount</code>. If you use <code>InstanceConfigs</code>, do not provide values for <code>InstanceType</code>, <code>VolumeSizeInGB</code> or <code>InstanceCount</code>.</p> </note>', ], ], 'HyperParameterTuningJobArn' => [ 'base' => NULL, 'refs' => [ 'CreateHyperParameterTuningJobResponse$HyperParameterTuningJobArn' => '<p>The Amazon Resource Name (ARN) of the tuning job. SageMaker assigns an ARN to a hyperparameter tuning job when you create it.</p>', 'DescribeHyperParameterTuningJobResponse$HyperParameterTuningJobArn' => '<p>The Amazon Resource Name (ARN) of the tuning job.</p>', 'DescribeTrainingJobResponse$TuningJobArn' => '<p>The Amazon Resource Name (ARN) of the associated hyperparameter tuning job if the training job was launched by a hyperparameter tuning job.</p>', 'HyperParameterTuningJobSearchEntity$HyperParameterTuningJobArn' => '<p>The Amazon Resource Name (ARN) of a hyperparameter tuning job.</p>', 'HyperParameterTuningJobSummary$HyperParameterTuningJobArn' => '<p>The Amazon Resource Name (ARN) of the tuning job.</p>', 'TrainingJob$TuningJobArn' => '<p>The Amazon Resource Name (ARN) of the associated hyperparameter tuning job if the training job was launched by a hyperparameter tuning job.</p>', 'TuningJobStepMetaData$Arn' => '<p>The Amazon Resource Name (ARN) of the tuning job that was run by this step execution.</p>', ], ], 'HyperParameterTuningJobCompletionDetails' => [ 'base' => '<p>A structure that contains runtime information about both current and completed hyperparameter tuning jobs.</p>', 'refs' => [ 'DescribeHyperParameterTuningJobResponse$TuningJobCompletionDetails' => '<p>Tuning job completion information returned as the response from a hyperparameter tuning job. This information tells if your tuning job has or has not converged. It also includes the number of training jobs that have not improved model performance as evaluated against the objective function.</p>', 'HyperParameterTuningJobSearchEntity$TuningJobCompletionDetails' => '<p>Information about either a current or completed hyperparameter tuning job.</p>', ], ], 'HyperParameterTuningJobConfig' => [ 'base' => '<p>Configures a hyperparameter tuning job.</p>', 'refs' => [ 'CreateHyperParameterTuningJobRequest$HyperParameterTuningJobConfig' => '<p>The <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTuningJobConfig.html">HyperParameterTuningJobConfig</a> object that describes the tuning job, including the search strategy, the objective metric used to evaluate training jobs, ranges of parameters to search, and resource limits for the tuning job. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-how-it-works.html">How Hyperparameter Tuning Works</a>.</p>', 'DescribeHyperParameterTuningJobResponse$HyperParameterTuningJobConfig' => '<p>The <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTuningJobConfig.html">HyperParameterTuningJobConfig</a> object that specifies the configuration of the tuning job.</p>', 'HyperParameterTuningJobSearchEntity$HyperParameterTuningJobConfig' => NULL, ], ], 'HyperParameterTuningJobConsumedResources' => [ 'base' => '<p>The total resources consumed by your hyperparameter tuning job.</p>', 'refs' => [ 'DescribeHyperParameterTuningJobResponse$ConsumedResources' => NULL, 'HyperParameterTuningJobSearchEntity$ConsumedResources' => '<p>The total amount of resources consumed by a hyperparameter tuning job.</p>', ], ], 'HyperParameterTuningJobName' => [ 'base' => NULL, 'refs' => [ 'CreateHyperParameterTuningJobRequest$HyperParameterTuningJobName' => '<p>The name of the tuning job. This name is the prefix for the names of all training jobs that this tuning job launches. The name must be unique within the same Amazon Web Services account and Amazon Web Services Region. The name must have 1 to 32 characters. Valid characters are a-z, A-Z, 0-9, and : + = @ _ % - (hyphen). The name is not case sensitive.</p>', 'DeleteHyperParameterTuningJobRequest$HyperParameterTuningJobName' => '<p>The name of the hyperparameter tuning job that you want to delete.</p>', 'DescribeHyperParameterTuningJobRequest$HyperParameterTuningJobName' => '<p>The name of the tuning job.</p>', 'DescribeHyperParameterTuningJobResponse$HyperParameterTuningJobName' => '<p>The name of the hyperparameter tuning job.</p>', 'HyperParameterTrainingJobSummary$TuningJobName' => '<p>The HyperParameter tuning job that launched the training job.</p>', 'HyperParameterTuningJobSearchEntity$HyperParameterTuningJobName' => '<p>The name of a hyperparameter tuning job.</p>', 'HyperParameterTuningJobSummary$HyperParameterTuningJobName' => '<p>The name of the tuning job.</p>', 'ListTrainingJobsForHyperParameterTuningJobRequest$HyperParameterTuningJobName' => '<p>The name of the tuning job whose training jobs you want to list.</p>', 'ParentHyperParameterTuningJob$HyperParameterTuningJobName' => '<p>The name of the hyperparameter tuning job to be used as a starting point for a new hyperparameter tuning job.</p>', 'StopHyperParameterTuningJobRequest$HyperParameterTuningJobName' => '<p>The name of the tuning job to stop.</p>', ], ], 'HyperParameterTuningJobObjective' => [ 'base' => '<p>Defines the objective metric for a hyperparameter tuning job. Hyperparameter tuning uses the value of this metric to evaluate the training jobs it launches, and returns the training job that results in either the highest or lowest value for this metric, depending on the value you specify for the <code>Type</code> parameter. If you want to define a custom objective metric, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-metrics-variables.html">Define metrics and environment variables</a>.</p>', 'refs' => [ 'HyperParameterTrainingJobDefinition$TuningObjective' => NULL, 'HyperParameterTuningJobConfig$HyperParameterTuningJobObjective' => '<p>The <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTuningJobObjective.html">HyperParameterTuningJobObjective</a> specifies the objective metric used to evaluate the performance of training jobs launched by this tuning job.</p>', 'HyperParameterTuningJobObjectives$member' => NULL, ], ], 'HyperParameterTuningJobObjectiveType' => [ 'base' => NULL, 'refs' => [ 'FinalHyperParameterTuningJobObjectiveMetric$Type' => '<p>Select if you want to minimize or maximize the objective metric during hyperparameter tuning. </p>', 'HyperParameterTuningJobObjective$Type' => '<p>Whether to minimize or maximize the objective metric.</p>', ], ], 'HyperParameterTuningJobObjectives' => [ 'base' => NULL, 'refs' => [ 'TrainingSpecification$SupportedTuningJobObjectiveMetrics' => '<p>A list of the metrics that the algorithm emits that can be used as the objective metric in a hyperparameter tuning job.</p>', ], ], 'HyperParameterTuningJobSearchEntity' => [ 'base' => '<p>An entity returned by the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_SearchRecord.html">SearchRecord</a> API containing the properties of a hyperparameter tuning job.</p>', 'refs' => [ 'SearchRecord$HyperParameterTuningJob' => '<p>The properties of a hyperparameter tuning job.</p>', ], ], 'HyperParameterTuningJobSortByOptions' => [ 'base' => NULL, 'refs' => [ 'ListHyperParameterTuningJobsRequest$SortBy' => '<p>The field to sort results by. The default is <code>Name</code>.</p>', ], ], 'HyperParameterTuningJobStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeHyperParameterTuningJobResponse$HyperParameterTuningJobStatus' => '<p>The status of the tuning job.</p>', 'HyperParameterTuningJobSearchEntity$HyperParameterTuningJobStatus' => '<p>The status of a hyperparameter tuning job.</p>', 'HyperParameterTuningJobSummary$HyperParameterTuningJobStatus' => '<p>The status of the tuning job.</p>', 'ListHyperParameterTuningJobsRequest$StatusEquals' => '<p>A filter that returns only tuning jobs with the specified status.</p>', ], ], 'HyperParameterTuningJobStrategyConfig' => [ 'base' => '<p>The configuration for a training job launched by a hyperparameter tuning job. Choose <code>Bayesian</code> for Bayesian optimization, and <code>Random</code> for random search optimization. For more advanced use cases, use <code>Hyperband</code>, which evaluates objective metrics for training jobs after every epoch. For more information about strategies, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-how-it-works.html">How Hyperparameter Tuning Works</a>.</p>', 'refs' => [ 'HyperParameterTuningJobConfig$StrategyConfig' => '<p>The configuration for the <code>Hyperband</code> optimization strategy. This parameter should be provided only if <code>Hyperband</code> is selected as the strategy for <code>HyperParameterTuningJobConfig</code>.</p>', ], ], 'HyperParameterTuningJobStrategyType' => [ 'base' => '<p>The strategy hyperparameter tuning uses to find the best combination of hyperparameters for your model. </p>', 'refs' => [ 'HyperParameterTuningJobConfig$Strategy' => '<p>Specifies how hyperparameter tuning chooses the combinations of hyperparameter values to use for the training job it launches. For information about search strategies, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-how-it-works.html">How Hyperparameter Tuning Works</a>.</p>', 'HyperParameterTuningJobSummary$Strategy' => '<p>Specifies the search strategy hyperparameter tuning uses to choose which hyperparameters to evaluate at each iteration.</p>', ], ], 'HyperParameterTuningJobSummaries' => [ 'base' => NULL, 'refs' => [ 'ListHyperParameterTuningJobsResponse$HyperParameterTuningJobSummaries' => '<p>A list of <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTuningJobSummary.html">HyperParameterTuningJobSummary</a> objects that describe the tuning jobs that the <code>ListHyperParameterTuningJobs</code> request returned.</p>', ], ], 'HyperParameterTuningJobSummary' => [ 'base' => '<p>Provides summary information about a hyperparameter tuning job.</p>', 'refs' => [ 'HyperParameterTuningJobSummaries$member' => NULL, ], ], 'HyperParameterTuningJobWarmStartConfig' => [ 'base' => '<p>Specifies the configuration for a hyperparameter tuning job that uses one or more previous hyperparameter tuning jobs as a starting point. The results of previous tuning jobs are used to inform which combinations of hyperparameters to search over in the new tuning job.</p> <p>All training jobs launched by the new hyperparameter tuning job are evaluated by using the objective metric, and the training job that performs the best is compared to the best training jobs from the parent tuning jobs. From these, the training job that performs the best as measured by the objective metric is returned as the overall best training job.</p> <note> <p>All training jobs launched by parent hyperparameter tuning jobs and the new hyperparameter tuning jobs count against the limit of training jobs for the tuning job.</p> </note>', 'refs' => [ 'CreateHyperParameterTuningJobRequest$WarmStartConfig' => '<p>Specifies the configuration for starting the hyperparameter tuning job using one or more previous tuning jobs as a starting point. The results of previous tuning jobs are used to inform which combinations of hyperparameters to search over in the new tuning job.</p> <p>All training jobs launched by the new hyperparameter tuning job are evaluated by using the objective metric. If you specify <code>IDENTICAL_DATA_AND_ALGORITHM</code> as the <code>WarmStartType</code> value for the warm start configuration, the training job that performs the best in the new tuning job is compared to the best training jobs from the parent tuning jobs. From these, the training job that performs the best as measured by the objective metric is returned as the overall best training job.</p> <note> <p>All training jobs launched by parent hyperparameter tuning jobs and the new hyperparameter tuning jobs count against the limit of training jobs for the tuning job.</p> </note>', 'DescribeHyperParameterTuningJobResponse$WarmStartConfig' => '<p>The configuration for starting the hyperparameter parameter tuning job using one or more previous tuning jobs as a starting point. The results of previous tuning jobs are used to inform which combinations of hyperparameters to search over in the new tuning job.</p>', 'HyperParameterTuningJobSearchEntity$WarmStartConfig' => NULL, ], ], 'HyperParameterTuningJobWarmStartType' => [ 'base' => NULL, 'refs' => [ 'HyperParameterTuningJobWarmStartConfig$WarmStartType' => '<p>Specifies one of the following:</p> <dl> <dt>IDENTICAL_DATA_AND_ALGORITHM</dt> <dd> <p>The new hyperparameter tuning job uses the same input data and training image as the parent tuning jobs. You can change the hyperparameter ranges to search and the maximum number of training jobs that the hyperparameter tuning job launches. You cannot use a new version of the training algorithm, unless the changes in the new version do not affect the algorithm itself. For example, changes that improve logging or adding support for a different data format are allowed. You can also change hyperparameters from tunable to static, and from static to tunable, but the total number of static plus tunable hyperparameters must remain the same as it is in all parent jobs. The objective metric for the new tuning job must be the same as for all parent jobs.</p> </dd> <dt>TRANSFER_LEARNING</dt> <dd> <p>The new hyperparameter tuning job can include input data, hyperparameter ranges, maximum number of concurrent training jobs, and maximum number of training jobs that are different than those of its parent hyperparameter tuning jobs. The training image can also be a different version from the version used in the parent hyperparameter tuning job. You can also change hyperparameters from tunable to static, and from static to tunable, but the total number of static plus tunable hyperparameters must remain the same as it is in all parent jobs. The objective metric for the new tuning job must be the same as for all parent jobs.</p> </dd> </dl>', ], ], 'HyperParameterTuningMaxRuntimeInSeconds' => [ 'base' => NULL, 'refs' => [ 'ResourceLimits$MaxRuntimeInSeconds' => '<p>The maximum time in seconds that a hyperparameter tuning job can run.</p>', ], ], 'HyperParameterTuningResourceConfig' => [ 'base' => '<p>The configuration of resources, including compute instances and storage volumes for use in training jobs launched by hyperparameter tuning jobs. <code>HyperParameterTuningResourceConfig</code> is similar to <code>ResourceConfig</code>, but has the additional <code>InstanceConfigs</code> and <code>AllocationStrategy</code> fields to allow for flexible instance management. Specify one or more instance types, count, and the allocation strategy for instance selection.</p> <note> <p> <code>HyperParameterTuningResourceConfig</code> supports the capabilities of <code>ResourceConfig</code> with the exception of <code>KeepAlivePeriodInSeconds</code>. Hyperparameter tuning jobs use warm pools by default, which reuse clusters between training jobs.</p> </note>', 'refs' => [ 'HyperParameterTrainingJobDefinition$HyperParameterTuningResourceConfig' => '<p>The configuration for the hyperparameter tuning resources, including the compute instances and storage volumes, used for training jobs launched by the tuning job. By default, storage volumes hold model artifacts and incremental states. Choose <code>File</code> for <code>TrainingInputMode</code> in the <code>AlgorithmSpecification</code> parameter to additionally store training data in the storage volume (optional).</p>', ], ], 'HyperParameterValue' => [ 'base' => NULL, 'refs' => [ 'HyperParameterSpecification$DefaultValue' => '<p>The default value for this hyperparameter. If a default value is specified, a hyperparameter cannot be required.</p>', 'HyperParameters$value' => NULL, ], ], 'HyperParameters' => [ 'base' => NULL, 'refs' => [ 'CreateTrainingJobRequest$HyperParameters' => '<p>Algorithm-specific parameters that influence the quality of the model. You set hyperparameters before you start the learning process. For a list of hyperparameters for each training algorithm provided by SageMaker, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html">Algorithms</a>. </p> <p>You can specify a maximum of 100 hyperparameters. Each hyperparameter is a key-value pair. Each key and value is limited to 256 characters, as specified by the <code>Length Constraint</code>. </p> <important> <p>Do not include any security-sensitive information including account access IDs, secrets or tokens in any hyperparameter field. If the use of security-sensitive credentials are detected, SageMaker will reject your training job request and return an exception error.</p> </important>', 'DescribeTrainingJobResponse$HyperParameters' => '<p>Algorithm-specific parameters. </p>', 'HyperParameterTrainingJobDefinition$StaticHyperParameters' => '<p>Specifies the values of hyperparameters that do not change for the tuning job.</p>', 'HyperParameterTrainingJobSummary$TunedHyperParameters' => '<p>A list of the hyperparameters for which you specified ranges to search.</p>', 'TrainingJob$HyperParameters' => '<p>Algorithm-specific parameters.</p>', 'TrainingJobDefinition$HyperParameters' => '<p>The hyperparameters used for the training job.</p>', ], ], 'HyperbandStrategyConfig' => [ 'base' => '<p>The configuration for <code>Hyperband</code>, a multi-fidelity based hyperparameter tuning strategy. <code>Hyperband</code> uses the final and intermediate results of a training job to dynamically allocate resources to utilized hyperparameter configurations while automatically stopping under-performing configurations. This parameter should be provided only if <code>Hyperband</code> is selected as the <code>StrategyConfig</code> under the <code>HyperParameterTuningJobConfig</code> API.</p>', 'refs' => [ 'HyperParameterTuningJobStrategyConfig$HyperbandStrategyConfig' => '<p>The configuration for the object that specifies the <code>Hyperband</code> strategy. This parameter is only supported for the <code>Hyperband</code> selection for <code>Strategy</code> within the <code>HyperParameterTuningJobConfig</code> API.</p>', ], ], 'HyperbandStrategyMaxResource' => [ 'base' => NULL, 'refs' => [ 'HyperbandStrategyConfig$MaxResource' => '<p>The maximum number of resources (such as epochs) that can be used by a training job launched by a hyperparameter tuning job. Once a job reaches the <code>MaxResource</code> value, it is stopped. If a value for <code>MaxResource</code> is not provided, and <code>Hyperband</code> is selected as the hyperparameter tuning strategy, <code>HyperbandTraining</code> attempts to infer <code>MaxResource</code> from the following keys (if present) in <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTrainingJobDefinition.html#sagemaker-Type-HyperParameterTrainingJobDefinition-StaticHyperParameters">StaticsHyperParameters</a>:</p> <ul> <li> <p> <code>epochs</code> </p> </li> <li> <p> <code>numepochs</code> </p> </li> <li> <p> <code>n-epochs</code> </p> </li> <li> <p> <code>n_epochs</code> </p> </li> <li> <p> <code>num_epochs</code> </p> </li> </ul> <p>If <code>HyperbandStrategyConfig</code> is unable to infer a value for <code>MaxResource</code>, it generates a validation error. The maximum value is 20,000 epochs. All metrics that correspond to an objective metric are used to derive <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-early-stopping.html">early stopping decisions</a>. For <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/distributed-training.html">distributed</a> training jobs, ensure that duplicate metrics are not printed in the logs across the individual nodes in a training job. If multiple nodes are publishing duplicate or incorrect metrics, training jobs may make an incorrect stopping decision and stop the job prematurely. </p>', ], ], 'HyperbandStrategyMinResource' => [ 'base' => NULL, 'refs' => [ 'HyperbandStrategyConfig$MinResource' => '<p>The minimum number of resources (such as epochs) that can be used by a training job launched by a hyperparameter tuning job. If the value for <code>MinResource</code> has not been reached, the training job is not stopped by <code>Hyperband</code>.</p>', ], ], 'IamIdentity' => [ 'base' => '<p>The IAM Identity details associated with the user. These details are associated with model package groups, model packages and project entities only.</p>', 'refs' => [ 'UserContext$IamIdentity' => '<p>The IAM Identity details associated with the user. These details are associated with model package groups, model packages, and project entities only.</p>', ], ], 'IamPolicyConstraints' => [ 'base' => '<p>Use this parameter to specify a supported global condition key that is added to the IAM policy.</p>', 'refs' => [ 'S3Presign$IamPolicyConstraints' => '<p>Use this parameter to specify the allowed request source. Possible sources are either <code>SourceIp</code> or <code>VpcSourceIp</code>.</p>', ], ], 'IdempotencyToken' => [ 'base' => NULL, 'refs' => [ 'CreatePipelineRequest$ClientRequestToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time.</p>', 'DeletePipelineRequest$ClientRequestToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time.</p>', 'RetryPipelineExecutionRequest$ClientRequestToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than once.</p>', 'SendPipelineExecutionStepFailureRequest$ClientRequestToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time.</p>', 'SendPipelineExecutionStepSuccessRequest$ClientRequestToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time.</p>', 'StartPipelineExecutionRequest$ClientRequestToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than once.</p>', 'StopPipelineExecutionRequest$ClientRequestToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than once.</p>', ], ], 'IdentityProviderOAuthSetting' => [ 'base' => '<p>The Amazon SageMaker Canvas application setting where you configure OAuth for connecting to an external data source, such as Snowflake.</p>', 'refs' => [ 'IdentityProviderOAuthSettings$member' => NULL, ], ], 'IdentityProviderOAuthSettings' => [ 'base' => NULL, 'refs' => [ 'CanvasAppSettings$IdentityProviderOAuthSettings' => '<p>The settings for connecting to an external data source with OAuth.</p>', ], ], 'Image' => [ 'base' => '<p>A SageMaker image. A SageMaker image represents a set of container images that are derived from a common base container image. Each of these container images is represented by a SageMaker <code>ImageVersion</code>.</p>', 'refs' => [ 'Images$member' => NULL, ], ], 'ImageArn' => [ 'base' => NULL, 'refs' => [ 'CreateImageResponse$ImageArn' => '<p>The ARN of the image.</p>', 'DescribeImageResponse$ImageArn' => '<p>The ARN of the image.</p>', 'DescribeImageVersionResponse$ImageArn' => '<p>The ARN of the image the version is based on.</p>', 'Image$ImageArn' => '<p>The ARN of the image.</p>', 'ImageVersion$ImageArn' => '<p>The ARN of the image the version is based on.</p>', 'ResourceSpec$SageMakerImageArn' => '<p>The ARN of the SageMaker image that the image version belongs to.</p>', 'UpdateImageResponse$ImageArn' => '<p>The ARN of the image.</p>', ], ], 'ImageBaseImage' => [ 'base' => NULL, 'refs' => [ 'CreateImageVersionRequest$BaseImage' => '<p>The registry path of the container image to use as the starting point for this version. The path is an Amazon ECR URI in the following format:</p> <p> <code>&lt;acct-id&gt;.dkr.ecr.&lt;region&gt;.amazonaws.com/&lt;repo-name[:tag] or [@digest]&gt;</code> </p>', 'DescribeImageVersionResponse$BaseImage' => '<p>The registry path of the container image on which this image version is based.</p>', ], ], 'ImageClassificationJobConfig' => [ 'base' => '<p>The collection of settings used by an AutoML job V2 for the image classification problem type.</p>', 'refs' => [ 'AutoMLProblemTypeConfig$ImageClassificationJobConfig' => '<p>Settings used to configure an AutoML job V2 for the image classification problem type.</p>', ], ], 'ImageConfig' => [ 'base' => '<p>Specifies whether the model container is in Amazon ECR or a private Docker registry accessible from your Amazon Virtual Private Cloud (VPC).</p>', 'refs' => [ 'ContainerDefinition$ImageConfig' => '<p>Specifies whether the model container is in Amazon ECR or a private Docker registry accessible from your Amazon Virtual Private Cloud (VPC). For information about storing containers in a private Docker registry, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-containers-inference-private.html">Use a Private Docker Registry for Real-Time Inference Containers</a>. </p> <note> <p>The model artifacts in an Amazon S3 bucket and the Docker image for inference container in Amazon EC2 Container Registry must be in the same region as the model or endpoint you are creating.</p> </note>', ], ], 'ImageContainerImage' => [ 'base' => NULL, 'refs' => [ 'DescribeImageVersionResponse$ContainerImage' => '<p>The registry path of the container image that contains this image version.</p>', ], ], 'ImageDeleteProperty' => [ 'base' => NULL, 'refs' => [ 'ImageDeletePropertyList$member' => NULL, ], ], 'ImageDeletePropertyList' => [ 'base' => NULL, 'refs' => [ 'UpdateImageRequest$DeleteProperties' => '<p>A list of properties to delete. Only the <code>Description</code> and <code>DisplayName</code> properties can be deleted.</p>', ], ], 'ImageDescription' => [ 'base' => NULL, 'refs' => [ 'CreateImageRequest$Description' => '<p>The description of the image.</p>', 'DescribeImageResponse$Description' => '<p>The description of the image.</p>', 'Image$Description' => '<p>The description of the image.</p>', 'UpdateImageRequest$Description' => '<p>The new description for the image.</p>', ], ], 'ImageDigest' => [ 'base' => NULL, 'refs' => [ 'ModelPackageContainerDefinition$ImageDigest' => '<p>An MD5 hash of the training algorithm that identifies the Docker image used for training.</p>', 'TrainingSpecification$TrainingImageDigest' => '<p>An MD5 hash of the training algorithm that identifies the Docker image used for training.</p>', ], ], 'ImageDisplayName' => [ 'base' => NULL, 'refs' => [ 'CreateImageRequest$DisplayName' => '<p>The display name of the image. If not provided, <code>ImageName</code> is displayed.</p>', 'DescribeImageResponse$DisplayName' => '<p>The name of the image as displayed.</p>', 'Image$DisplayName' => '<p>The name of the image as displayed.</p>', 'UpdateImageRequest$DisplayName' => '<p>The new display name for the image.</p>', ], ], 'ImageName' => [ 'base' => NULL, 'refs' => [ 'CreateImageRequest$ImageName' => '<p>The name of the image. Must be unique to your account.</p>', 'CreateImageVersionRequest$ImageName' => '<p>The <code>ImageName</code> of the <code>Image</code> to create a version of.</p>', 'CustomImage$ImageName' => '<p>The name of the CustomImage. Must be unique to your account.</p>', 'DeleteImageRequest$ImageName' => '<p>The name of the image to delete.</p>', 'DeleteImageVersionRequest$ImageName' => '<p>The name of the image to delete.</p>', 'DescribeImageRequest$ImageName' => '<p>The name of the image to describe.</p>', 'DescribeImageResponse$ImageName' => '<p>The name of the image.</p>', 'DescribeImageVersionRequest$ImageName' => '<p>The name of the image.</p>', 'Image$ImageName' => '<p>The name of the image.</p>', 'ListAliasesRequest$ImageName' => '<p>The name of the image.</p>', 'ListImageVersionsRequest$ImageName' => '<p>The name of the image to list the versions of.</p>', 'UpdateImageRequest$ImageName' => '<p>The name of the image to update.</p>', 'UpdateImageVersionRequest$ImageName' => '<p>The name of the image.</p>', ], ], 'ImageNameContains' => [ 'base' => NULL, 'refs' => [ 'ListImagesRequest$NameContains' => '<p>A filter that returns only images whose name contains the specified string.</p>', ], ], 'ImageSortBy' => [ 'base' => NULL, 'refs' => [ 'ListImagesRequest$SortBy' => '<p>The property used to sort results. The default value is <code>CREATION_TIME</code>.</p>', ], ], 'ImageSortOrder' => [ 'base' => NULL, 'refs' => [ 'ListImagesRequest$SortOrder' => '<p>The sort order. The default value is <code>DESCENDING</code>.</p>', ], ], 'ImageStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeImageResponse$ImageStatus' => '<p>The status of the image.</p>', 'Image$ImageStatus' => '<p>The status of the image.</p>', ], ], 'ImageUri' => [ 'base' => NULL, 'refs' => [ 'AppSpecification$ImageUri' => '<p>The container image to be run by the processing job.</p>', 'DataQualityAppSpecification$ImageUri' => '<p>The container image that the data quality monitoring job runs.</p>', 'ModelBiasAppSpecification$ImageUri' => '<p>The container image to be run by the model bias job.</p>', 'ModelExplainabilityAppSpecification$ImageUri' => '<p>The container image to be run by the model explainability job.</p>', 'ModelQualityAppSpecification$ImageUri' => '<p>The address of the container image that the monitoring job runs.</p>', 'MonitoringAppSpecification$ImageUri' => '<p>The container image to be run by the monitoring job.</p>', ], ], 'ImageVersion' => [ 'base' => '<p>A version of a SageMaker <code>Image</code>. A version represents an existing container image.</p>', 'refs' => [ 'ImageVersions$member' => NULL, ], ], 'ImageVersionAlias' => [ 'base' => NULL, 'refs' => [ 'ResourceSpec$SageMakerImageVersionAlias' => '<p>The SageMakerImageVersionAlias of the image to launch with. This value is in SemVer 2.0.0 versioning format.</p>', ], ], 'ImageVersionArn' => [ 'base' => NULL, 'refs' => [ 'CreateImageVersionResponse$ImageVersionArn' => '<p>The ARN of the image version.</p>', 'DescribeImageVersionResponse$ImageVersionArn' => '<p>The ARN of the version.</p>', 'ImageVersion$ImageVersionArn' => '<p>The ARN of the version.</p>', 'ResourceSpec$SageMakerImageVersionArn' => '<p>The ARN of the image version created on the instance.</p>', 'UpdateImageVersionResponse$ImageVersionArn' => '<p>The ARN of the image version.</p>', ], ], 'ImageVersionNumber' => [ 'base' => NULL, 'refs' => [ 'CustomImage$ImageVersionNumber' => '<p>The version number of the CustomImage.</p>', 'DeleteImageVersionRequest$Version' => '<p>The version to delete.</p>', 'DescribeImageVersionRequest$Version' => '<p>The version of the image. If not specified, the latest version is described.</p>', 'DescribeImageVersionResponse$Version' => '<p>The version number.</p>', 'ImageVersion$Version' => '<p>The version number.</p>', 'ListAliasesRequest$Version' => '<p>The version of the image. If image version is not specified, the aliases of all versions of the image are listed.</p>', 'UpdateImageVersionRequest$Version' => '<p>The version of the image.</p>', ], ], 'ImageVersionSortBy' => [ 'base' => NULL, 'refs' => [ 'ListImageVersionsRequest$SortBy' => '<p>The property used to sort results. The default value is <code>CREATION_TIME</code>.</p>', ], ], 'ImageVersionSortOrder' => [ 'base' => NULL, 'refs' => [ 'ListImageVersionsRequest$SortOrder' => '<p>The sort order. The default value is <code>DESCENDING</code>.</p>', ], ], 'ImageVersionStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeImageVersionResponse$ImageVersionStatus' => '<p>The status of the version.</p>', 'ImageVersion$ImageVersionStatus' => '<p>The status of the version.</p>', ], ], 'ImageVersions' => [ 'base' => NULL, 'refs' => [ 'ListImageVersionsResponse$ImageVersions' => '<p>A list of versions and their properties.</p>', ], ], 'Images' => [ 'base' => NULL, 'refs' => [ 'ListImagesResponse$Images' => '<p>A list of images and their properties.</p>', ], ], 'ImportHubContentRequest' => [ 'base' => NULL, 'refs' => [], ], 'ImportHubContentResponse' => [ 'base' => NULL, 'refs' => [], ], 'InferenceComponentArn' => [ 'base' => NULL, 'refs' => [ 'CreateInferenceComponentOutput$InferenceComponentArn' => '<p>The Amazon Resource Name (ARN) of the inference component.</p>', 'DescribeInferenceComponentOutput$InferenceComponentArn' => '<p>The Amazon Resource Name (ARN) of the inference component.</p>', 'InferenceComponentSummary$InferenceComponentArn' => '<p>The Amazon Resource Name (ARN) of the inference component.</p>', 'UpdateInferenceComponentOutput$InferenceComponentArn' => '<p>The Amazon Resource Name (ARN) of the inference component.</p>', 'UpdateInferenceComponentRuntimeConfigOutput$InferenceComponentArn' => '<p>The Amazon Resource Name (ARN) of the inference component.</p>', ], ], 'InferenceComponentComputeResourceRequirements' => [ 'base' => '<p>Defines the compute resources to allocate to run a model that you assign to an inference component. These resources include CPU cores, accelerators, and memory.</p>', 'refs' => [ 'InferenceComponentSpecification$ComputeResourceRequirements' => '<p>The compute resources allocated to run the model assigned to the inference component.</p>', 'InferenceComponentSpecificationSummary$ComputeResourceRequirements' => '<p>The compute resources allocated to run the model assigned to the inference component.</p>', ], ], 'InferenceComponentContainerSpecification' => [ 'base' => '<p>Defines a container that provides the runtime environment for a model that you deploy with an inference component.</p>', 'refs' => [ 'InferenceComponentSpecification$Container' => '<p>Defines a container that provides the runtime environment for a model that you deploy with an inference component.</p>', ], ], 'InferenceComponentContainerSpecificationSummary' => [ 'base' => '<p>Details about the resources that are deployed with this inference component.</p>', 'refs' => [ 'InferenceComponentSpecificationSummary$Container' => '<p>Details about the container that provides the runtime environment for the model that is deployed with the inference component.</p>', ], ], 'InferenceComponentCopyCount' => [ 'base' => NULL, 'refs' => [ 'InferenceComponentRuntimeConfig$CopyCount' => '<p>The number of runtime copies of the model container to deploy with the inference component. Each copy can serve inference requests.</p>', 'InferenceComponentRuntimeConfigSummary$DesiredCopyCount' => '<p>The number of runtime copies of the model container that you requested to deploy with the inference component.</p>', 'InferenceComponentRuntimeConfigSummary$CurrentCopyCount' => '<p>The number of runtime copies of the model container that are currently deployed.</p>', ], ], 'InferenceComponentName' => [ 'base' => NULL, 'refs' => [ 'CreateInferenceComponentInput$InferenceComponentName' => '<p>A unique name to assign to the inference component.</p>', 'DeleteInferenceComponentInput$InferenceComponentName' => '<p>The name of the inference component to delete.</p>', 'DescribeInferenceComponentInput$InferenceComponentName' => '<p>The name of the inference component.</p>', 'DescribeInferenceComponentOutput$InferenceComponentName' => '<p>The name of the inference component.</p>', 'InferenceComponentSummary$InferenceComponentName' => '<p>The name of the inference component.</p>', 'UpdateInferenceComponentInput$InferenceComponentName' => '<p>The name of the inference component.</p>', 'UpdateInferenceComponentRuntimeConfigInput$InferenceComponentName' => '<p>The name of the inference component to update.</p>', ], ], 'InferenceComponentNameContains' => [ 'base' => NULL, 'refs' => [ 'ListInferenceComponentsInput$NameContains' => '<p>Filters the results to only those inference components with a name that contains the specified string.</p>', ], ], 'InferenceComponentRuntimeConfig' => [ 'base' => '<p>Runtime settings for a model that is deployed with an inference component.</p>', 'refs' => [ 'CreateInferenceComponentInput$RuntimeConfig' => '<p>Runtime settings for a model that is deployed with an inference component.</p>', 'UpdateInferenceComponentInput$RuntimeConfig' => '<p>Runtime settings for a model that is deployed with an inference component.</p>', 'UpdateInferenceComponentRuntimeConfigInput$DesiredRuntimeConfig' => '<p>Runtime settings for a model that is deployed with an inference component.</p>', ], ], 'InferenceComponentRuntimeConfigSummary' => [ 'base' => '<p>Details about the runtime settings for the model that is deployed with the inference component.</p>', 'refs' => [ 'DescribeInferenceComponentOutput$RuntimeConfig' => '<p>Details about the runtime settings for the model that is deployed with the inference component.</p>', ], ], 'InferenceComponentSortKey' => [ 'base' => NULL, 'refs' => [ 'ListInferenceComponentsInput$SortBy' => '<p>The field by which to sort the inference components in the response. The default is <code>CreationTime</code>.</p>', ], ], 'InferenceComponentSpecification' => [ 'base' => '<p>Details about the resources to deploy with this inference component, including the model, container, and compute resources.</p>', 'refs' => [ 'CreateInferenceComponentInput$Specification' => '<p>Details about the resources to deploy with this inference component, including the model, container, and compute resources.</p>', 'UpdateInferenceComponentInput$Specification' => '<p>Details about the resources to deploy with this inference component, including the model, container, and compute resources.</p>', ], ], 'InferenceComponentSpecificationSummary' => [ 'base' => '<p>Details about the resources that are deployed with this inference component.</p>', 'refs' => [ 'DescribeInferenceComponentOutput$Specification' => '<p>Details about the resources that are deployed with this inference component.</p>', ], ], 'InferenceComponentStartupParameters' => [ 'base' => '<p>Settings that take effect while the model container starts up.</p>', 'refs' => [ 'InferenceComponentSpecification$StartupParameters' => '<p>Settings that take effect while the model container starts up.</p>', 'InferenceComponentSpecificationSummary$StartupParameters' => '<p>Settings that take effect while the model container starts up.</p>', ], ], 'InferenceComponentStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeInferenceComponentOutput$InferenceComponentStatus' => '<p>The status of the inference component.</p>', 'InferenceComponentSummary$InferenceComponentStatus' => '<p>The status of the inference component.</p>', 'ListInferenceComponentsInput$StatusEquals' => '<p>Filters the results to only those inference components with the specified status.</p>', ], ], 'InferenceComponentSummary' => [ 'base' => '<p>A summary of the properties of an inference component.</p>', 'refs' => [ 'InferenceComponentSummaryList$member' => NULL, ], ], 'InferenceComponentSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListInferenceComponentsOutput$InferenceComponents' => '<p>A list of inference components and their properties that matches any of the filters you specified in the request.</p>', ], ], 'InferenceExecutionConfig' => [ 'base' => '<p>Specifies details about how containers in a multi-container endpoint are run.</p>', 'refs' => [ 'CreateModelInput$InferenceExecutionConfig' => '<p>Specifies details of how containers in a multi-container endpoint are called.</p>', 'DescribeModelOutput$InferenceExecutionConfig' => '<p>Specifies details of how containers in a multi-container endpoint are called.</p>', 'Model$InferenceExecutionConfig' => NULL, ], ], 'InferenceExecutionMode' => [ 'base' => NULL, 'refs' => [ 'InferenceExecutionConfig$Mode' => '<p>How containers in a multi-container are run. The following values are valid.</p> <ul> <li> <p> <code>SERIAL</code> - Containers run as a serial pipeline.</p> </li> <li> <p> <code>DIRECT</code> - Only the individual container that you specify is run.</p> </li> </ul>', ], ], 'InferenceExperimentArn' => [ 'base' => NULL, 'refs' => [ 'CreateInferenceExperimentResponse$InferenceExperimentArn' => '<p>The ARN for your inference experiment.</p>', 'DeleteInferenceExperimentResponse$InferenceExperimentArn' => '<p>The ARN of the deleted inference experiment.</p>', 'DescribeInferenceExperimentResponse$Arn' => '<p>The ARN of the inference experiment being described.</p>', 'StartInferenceExperimentResponse$InferenceExperimentArn' => '<p>The ARN of the started inference experiment to start.</p>', 'StopInferenceExperimentResponse$InferenceExperimentArn' => '<p>The ARN of the stopped inference experiment.</p>', 'UpdateInferenceExperimentResponse$InferenceExperimentArn' => '<p>The ARN of the updated inference experiment.</p>', ], ], 'InferenceExperimentDataStorageConfig' => [ 'base' => '<p>The Amazon S3 location and configuration for storing inference request and response data.</p>', 'refs' => [ 'CreateInferenceExperimentRequest$DataStorageConfig' => '<p> The Amazon S3 location and configuration for storing inference request and response data. </p> <p> This is an optional parameter that you can use for data capture. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-data-capture.html">Capture data</a>. </p>', 'DescribeInferenceExperimentResponse$DataStorageConfig' => '<p>The Amazon S3 location and configuration for storing inference request and response data.</p>', 'UpdateInferenceExperimentRequest$DataStorageConfig' => '<p>The Amazon S3 location and configuration for storing inference request and response data.</p>', ], ], 'InferenceExperimentDescription' => [ 'base' => NULL, 'refs' => [ 'CreateInferenceExperimentRequest$Description' => '<p>A description for the inference experiment.</p>', 'DescribeInferenceExperimentResponse$Description' => '<p>The description of the inference experiment.</p>', 'InferenceExperimentSummary$Description' => '<p>The description of the inference experiment.</p>', 'UpdateInferenceExperimentRequest$Description' => '<p>The description of the inference experiment.</p>', ], ], 'InferenceExperimentList' => [ 'base' => NULL, 'refs' => [ 'ListInferenceExperimentsResponse$InferenceExperiments' => '<p>List of inference experiments.</p>', ], ], 'InferenceExperimentName' => [ 'base' => NULL, 'refs' => [ 'CreateInferenceExperimentRequest$Name' => '<p>The name for the inference experiment.</p>', 'DeleteInferenceExperimentRequest$Name' => '<p>The name of the inference experiment you want to delete.</p>', 'DescribeInferenceExperimentRequest$Name' => '<p>The name of the inference experiment to describe.</p>', 'DescribeInferenceExperimentResponse$Name' => '<p>The name of the inference experiment.</p>', 'InferenceExperimentSummary$Name' => '<p>The name of the inference experiment.</p>', 'StartInferenceExperimentRequest$Name' => '<p>The name of the inference experiment to start.</p>', 'StopInferenceExperimentRequest$Name' => '<p>The name of the inference experiment to stop.</p>', 'UpdateInferenceExperimentRequest$Name' => '<p>The name of the inference experiment to be updated.</p>', ], ], 'InferenceExperimentSchedule' => [ 'base' => '<p>The start and end times of an inference experiment.</p> <p>The maximum duration that you can set for an inference experiment is 30 days.</p>', 'refs' => [ 'CreateInferenceExperimentRequest$Schedule' => '<p> The duration for which you want the inference experiment to run. If you don\'t specify this field, the experiment automatically starts immediately upon creation and concludes after 7 days. </p>', 'DescribeInferenceExperimentResponse$Schedule' => '<p>The duration for which the inference experiment ran or will run.</p>', 'InferenceExperimentSummary$Schedule' => '<p>The duration for which the inference experiment ran or will run.</p> <p>The maximum duration that you can set for an inference experiment is 30 days.</p>', 'UpdateInferenceExperimentRequest$Schedule' => '<p> The duration for which the inference experiment will run. If the status of the inference experiment is <code>Created</code>, then you can update both the start and end dates. If the status of the inference experiment is <code>Running</code>, then you can update only the end date. </p>', ], ], 'InferenceExperimentStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeInferenceExperimentResponse$Status' => '<p> The status of the inference experiment. The following are the possible statuses for an inference experiment: </p> <ul> <li> <p> <code>Creating</code> - Amazon SageMaker is creating your experiment. </p> </li> <li> <p> <code>Created</code> - Amazon SageMaker has finished the creation of your experiment and will begin the experiment at the scheduled time. </p> </li> <li> <p> <code>Updating</code> - When you make changes to your experiment, your experiment shows as updating. </p> </li> <li> <p> <code>Starting</code> - Amazon SageMaker is beginning your experiment. </p> </li> <li> <p> <code>Running</code> - Your experiment is in progress. </p> </li> <li> <p> <code>Stopping</code> - Amazon SageMaker is stopping your experiment. </p> </li> <li> <p> <code>Completed</code> - Your experiment has completed. </p> </li> <li> <p> <code>Cancelled</code> - When you conclude your experiment early using the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StopInferenceExperiment.html">StopInferenceExperiment</a> API, or if any operation fails with an unexpected error, it shows as cancelled. </p> </li> </ul>', 'InferenceExperimentSummary$Status' => '<p>The status of the inference experiment.</p>', 'ListInferenceExperimentsRequest$StatusEquals' => '<p> Selects inference experiments which are in this status. For the possible statuses, see <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeInferenceExperiment.html">DescribeInferenceExperiment</a>. </p>', ], ], 'InferenceExperimentStatusReason' => [ 'base' => NULL, 'refs' => [ 'DescribeInferenceExperimentResponse$StatusReason' => '<p> The error message or client-specified <code>Reason</code> from the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StopInferenceExperiment.html">StopInferenceExperiment</a> API, that explains the status of the inference experiment. </p>', 'InferenceExperimentSummary$StatusReason' => '<p>The error message for the inference experiment status result.</p>', 'StopInferenceExperimentRequest$Reason' => '<p>The reason for stopping the experiment.</p>', ], ], 'InferenceExperimentStopDesiredState' => [ 'base' => NULL, 'refs' => [ 'StopInferenceExperimentRequest$DesiredState' => '<p> The desired state of the experiment after stopping. The possible states are the following: </p> <ul> <li> <p> <code>Completed</code>: The experiment completed successfully</p> </li> <li> <p> <code>Cancelled</code>: The experiment was canceled</p> </li> </ul>', ], ], 'InferenceExperimentSummary' => [ 'base' => '<p>Lists a summary of properties of an inference experiment.</p>', 'refs' => [ 'InferenceExperimentList$member' => NULL, ], ], 'InferenceExperimentType' => [ 'base' => NULL, 'refs' => [ 'CreateInferenceExperimentRequest$Type' => '<p> The type of the inference experiment that you want to run. The following types of experiments are possible: </p> <ul> <li> <p> <code>ShadowMode</code>: You can use this type to validate a shadow variant. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/shadow-tests.html">Shadow tests</a>. </p> </li> </ul>', 'DescribeInferenceExperimentResponse$Type' => '<p>The type of the inference experiment.</p>', 'InferenceExperimentSummary$Type' => '<p>The type of the inference experiment.</p>', 'ListInferenceExperimentsRequest$Type' => '<p> Selects inference experiments of this type. For the possible types of inference experiments, see <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateInferenceExperiment.html">CreateInferenceExperiment</a>. </p>', ], ], 'InferenceHubAccessConfig' => [ 'base' => '<p>Configuration information specifying which hub contents have accessible deployment options.</p>', 'refs' => [ 'S3ModelDataSource$HubAccessConfig' => '<p>Configuration information for hub access.</p>', ], ], 'InferenceImage' => [ 'base' => NULL, 'refs' => [ 'DescribeCompilationJobResponse$InferenceImage' => '<p>The inference image to use when compiling a model. Specify an image only if the target device is a cloud instance.</p>', ], ], 'InferenceMetrics' => [ 'base' => '<p>The metrics for an existing endpoint compared in an Inference Recommender job.</p>', 'refs' => [ 'EndpointPerformance$Metrics' => '<p>The metrics for an existing endpoint.</p>', 'RecommendationJobInferenceBenchmark$EndpointMetrics' => NULL, ], ], 'InferenceRecommendation' => [ 'base' => '<p>A list of recommendations made by Amazon SageMaker Inference Recommender.</p>', 'refs' => [ 'InferenceRecommendations$member' => NULL, ], ], 'InferenceRecommendations' => [ 'base' => NULL, 'refs' => [ 'DescribeInferenceRecommendationsJobResponse$InferenceRecommendations' => '<p>The recommendations made by Inference Recommender.</p>', ], ], 'InferenceRecommendationsJob' => [ 'base' => '<p>A structure that contains a list of recommendation jobs.</p>', 'refs' => [ 'InferenceRecommendationsJobs$member' => NULL, ], ], 'InferenceRecommendationsJobStep' => [ 'base' => '<p>A returned array object for the <code>Steps</code> response field in the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListInferenceRecommendationsJobSteps.html">ListInferenceRecommendationsJobSteps</a> API command.</p>', 'refs' => [ 'InferenceRecommendationsJobSteps$member' => NULL, ], ], 'InferenceRecommendationsJobSteps' => [ 'base' => NULL, 'refs' => [ 'ListInferenceRecommendationsJobStepsResponse$Steps' => '<p>A list of all subtask details in Inference Recommender.</p>', ], ], 'InferenceRecommendationsJobs' => [ 'base' => NULL, 'refs' => [ 'ListInferenceRecommendationsJobsResponse$InferenceRecommendationsJobs' => '<p>The recommendations created from the Amazon SageMaker Inference Recommender job.</p>', ], ], 'InferenceSpecification' => [ 'base' => '<p>Defines how to perform inference generation after a training job is run.</p>', 'refs' => [ 'BatchDescribeModelPackageSummary$InferenceSpecification' => NULL, 'CreateAlgorithmInput$InferenceSpecification' => '<p>Specifies details about inference jobs that the algorithm runs, including the following:</p> <ul> <li> <p>The Amazon ECR paths of containers that contain the inference code and model artifacts.</p> </li> <li> <p>The instance types that the algorithm supports for transform jobs and real-time endpoints used for inference.</p> </li> <li> <p>The input and output content formats that the algorithm supports for inference.</p> </li> </ul>', 'CreateModelPackageInput$InferenceSpecification' => '<p>Specifies details about inference jobs that you can run with models based on this model package, including the following information:</p> <ul> <li> <p>The Amazon ECR paths of containers that contain the inference code and model artifacts.</p> </li> <li> <p>The instance types that the model package supports for transform jobs and real-time endpoints used for inference.</p> </li> <li> <p>The input and output content formats that the model package supports for inference.</p> </li> </ul>', 'DescribeAlgorithmOutput$InferenceSpecification' => '<p>Details about inference jobs that the algorithm runs.</p>', 'DescribeModelPackageOutput$InferenceSpecification' => '<p>Details about inference jobs that you can run with models based on this model package.</p>', 'ModelPackage$InferenceSpecification' => '<p>Defines how to perform inference generation after a training job is run.</p>', 'UpdateModelPackageInput$InferenceSpecification' => '<p>Specifies details about inference jobs that you can run with models based on this model package, including the following information:</p> <ul> <li> <p>The Amazon ECR paths of containers that contain the inference code and model artifacts.</p> </li> <li> <p>The instance types that the model package supports for transform jobs and real-time endpoints used for inference.</p> </li> <li> <p>The input and output content formats that the model package supports for inference.</p> </li> </ul>', ], ], 'InferenceSpecificationName' => [ 'base' => NULL, 'refs' => [ 'ContainerDefinition$InferenceSpecificationName' => '<p>The inference specification name in the model package version.</p>', 'EndpointInputConfiguration$InferenceSpecificationName' => '<p>The inference specification name in the model package version.</p>', 'ModelConfiguration$InferenceSpecificationName' => '<p>The inference specification name in the model package version.</p>', ], ], 'InfraCheckConfig' => [ 'base' => '<p>Configuration information for the infrastructure health check of a training job. A SageMaker-provided health check tests the health of instance hardware and cluster network connectivity.</p>', 'refs' => [ 'CreateTrainingJobRequest$InfraCheckConfig' => '<p>Contains information about the infrastructure health check configuration for the training job.</p>', 'DescribeTrainingJobResponse$InfraCheckConfig' => '<p>Contains information about the infrastructure health check configuration for the training job.</p>', ], ], 'InitialInstanceCount' => [ 'base' => NULL, 'refs' => [ 'EndpointOutputConfiguration$InitialInstanceCount' => '<p>The number of instances recommended to launch initially.</p>', ], ], 'InitialNumberOfUsers' => [ 'base' => NULL, 'refs' => [ 'Phase$InitialNumberOfUsers' => '<p>Specifies how many concurrent users to start with. The value should be between 1 and 3.</p>', ], ], 'InitialTaskCount' => [ 'base' => NULL, 'refs' => [ 'ProductionVariant$InitialInstanceCount' => '<p>Number of instances to launch initially.</p>', ], ], 'InputConfig' => [ 'base' => '<p>Contains information about the location of input model artifacts, the name and shape of the expected data inputs, and the framework in which the model was trained.</p>', 'refs' => [ 'CreateCompilationJobRequest$InputConfig' => '<p>Provides information about the location of input model artifacts, the name and shape of the expected data inputs, and the framework in which the model was trained.</p>', 'DescribeCompilationJobResponse$InputConfig' => '<p>Information about the location in Amazon S3 of the input model artifacts, the name and shape of the expected data inputs, and the framework in which the model was trained.</p>', ], ], 'InputDataConfig' => [ 'base' => NULL, 'refs' => [ 'CreateTrainingJobRequest$InputDataConfig' => '<p>An array of <code>Channel</code> objects. Each channel is a named input source. <code>InputDataConfig</code> describes the input data and its location. </p> <p>Algorithms can accept input data from one or more channels. For example, an algorithm might have two channels of input data, <code>training_data</code> and <code>validation_data</code>. The configuration for each channel provides the S3, EFS, or FSx location where the input data is stored. It also provides information about the stored data: the MIME type, compression method, and whether the data is wrapped in RecordIO format. </p> <p>Depending on the input mode that the algorithm supports, SageMaker either copies input data files from an S3 bucket to a local directory in the Docker container, or makes it available as input streams. For example, if you specify an EFS location, input data files are available as input streams. They do not need to be downloaded.</p> <p>Your input must be in the same Amazon Web Services region as your training job.</p>', 'DescribeTrainingJobResponse$InputDataConfig' => '<p>An array of <code>Channel</code> objects that describes each data input channel. </p>', 'HyperParameterTrainingJobDefinition$InputDataConfig' => '<p>An array of <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Channel.html">Channel</a> objects that specify the input for the training jobs that the tuning job launches.</p>', 'TrainingJob$InputDataConfig' => '<p>An array of <code>Channel</code> objects that describes each data input channel.</p> <p>Your input must be in the same Amazon Web Services region as your training job.</p>', 'TrainingJobDefinition$InputDataConfig' => '<p>An array of <code>Channel</code> objects, each of which specifies an input source.</p>', ], ], 'InputMode' => [ 'base' => NULL, 'refs' => [ 'DatasetDefinition$InputMode' => '<p>Whether to use <code>File</code> or <code>Pipe</code> input mode. In <code>File</code> (default) mode, Amazon SageMaker copies the data from the input source onto the local Amazon Elastic Block Store (Amazon EBS) volumes before starting your training algorithm. This is the most commonly used input mode. In <code>Pipe</code> mode, Amazon SageMaker streams input data from the source directly to your algorithm without using the EBS volume.</p>', ], ], 'InputModes' => [ 'base' => NULL, 'refs' => [ 'ChannelSpecification$SupportedInputModes' => '<p>The allowed input mode, either FILE or PIPE.</p> <p>In FILE mode, Amazon SageMaker copies the data from the input source onto the local Amazon Elastic Block Store (Amazon EBS) volumes before starting your training algorithm. This is the most commonly used input mode.</p> <p>In PIPE mode, Amazon SageMaker streams input data from the source directly to your algorithm without using the EBS volume.</p>', ], ], 'InstanceGroup' => [ 'base' => '<p>Defines an instance group for heterogeneous cluster training. When requesting a training job using the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTrainingJob.html">CreateTrainingJob</a> API, you can configure multiple instance groups .</p>', 'refs' => [ 'InstanceGroups$member' => NULL, ], ], 'InstanceGroupName' => [ 'base' => NULL, 'refs' => [ 'InstanceGroup$InstanceGroupName' => '<p>Specifies the name of the instance group.</p>', 'InstanceGroupNames$member' => NULL, ], ], 'InstanceGroupNames' => [ 'base' => NULL, 'refs' => [ 'S3DataSource$InstanceGroupNames' => '<p>A list of names of instance groups that get data from the S3 data source.</p>', ], ], 'InstanceGroups' => [ 'base' => NULL, 'refs' => [ 'ResourceConfig$InstanceGroups' => '<p>The configuration of a heterogeneous cluster in JSON format.</p>', ], ], 'InstanceMetadataServiceConfiguration' => [ 'base' => '<p>Information on the IMDS configuration of the notebook instance</p>', 'refs' => [ 'CreateNotebookInstanceInput$InstanceMetadataServiceConfiguration' => '<p>Information on the IMDS configuration of the notebook instance</p>', 'DescribeNotebookInstanceOutput$InstanceMetadataServiceConfiguration' => '<p>Information on the IMDS configuration of the notebook instance</p>', 'UpdateNotebookInstanceInput$InstanceMetadataServiceConfiguration' => '<p>Information on the IMDS configuration of the notebook instance</p>', ], ], 'InstanceType' => [ 'base' => NULL, 'refs' => [ 'CreateNotebookInstanceInput$InstanceType' => '<p>The type of ML compute instance to launch for the notebook instance.</p>', 'DescribeNotebookInstanceOutput$InstanceType' => '<p>The type of ML compute instance running on the notebook instance.</p>', 'NotebookInstanceSummary$InstanceType' => '<p>The type of ML compute instance that the notebook instance is running on.</p>', 'RealTimeInferenceConfig$InstanceType' => '<p>The instance type the model is deployed to.</p>', 'UpdateNotebookInstanceInput$InstanceType' => '<p>The Amazon ML compute instance type.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'CreateModelCardExportJobRequest$ModelCardVersion' => '<p>The version of the model card to export. If a version is not provided, then the latest version of the model card is exported.</p>', 'DescribeDeviceResponse$MaxModels' => '<p>The maximum number of models.</p>', 'DescribeEdgeDeploymentPlanResponse$EdgeDeploymentSuccess' => '<p>The number of edge devices with the successful deployment.</p>', 'DescribeEdgeDeploymentPlanResponse$EdgeDeploymentPending' => '<p>The number of edge devices yet to pick up deployment, or in progress.</p>', 'DescribeEdgeDeploymentPlanResponse$EdgeDeploymentFailed' => '<p>The number of edge devices that failed the deployment.</p>', 'DescribeModelCardExportJobResponse$ModelCardVersion' => '<p>The version of the model card that the model export job exports.</p>', 'DescribeModelCardRequest$ModelCardVersion' => '<p>The version of the model card to describe. If a version is not provided, then the latest version of the model card is described.</p>', 'DescribeModelCardResponse$ModelCardVersion' => '<p>The version of the model card.</p>', 'DynamicScalingConfiguration$MinCapacity' => '<p>The recommended minimum capacity to specify for your autoscaling policy.</p>', 'DynamicScalingConfiguration$MaxCapacity' => '<p>The recommended maximum capacity to specify for your autoscaling policy.</p>', 'DynamicScalingConfiguration$ScaleInCooldown' => '<p>The recommended scale in cooldown time for your autoscaling policy.</p>', 'DynamicScalingConfiguration$ScaleOutCooldown' => '<p>The recommended scale out cooldown time for your autoscaling policy.</p>', 'EdgeDeploymentPlanSummary$EdgeDeploymentSuccess' => '<p>The number of edge devices with the successful deployment.</p>', 'EdgeDeploymentPlanSummary$EdgeDeploymentPending' => '<p>The number of edge devices yet to pick up the deployment, or in progress.</p>', 'EdgeDeploymentPlanSummary$EdgeDeploymentFailed' => '<p>The number of edge devices that failed the deployment.</p>', 'EdgeDeploymentStatus$EdgeDeploymentSuccessInStage' => '<p>The number of edge devices with the successful deployment in the current stage.</p>', 'EdgeDeploymentStatus$EdgeDeploymentPendingInStage' => '<p>The number of edge devices yet to pick up the deployment in current stage, or in progress.</p>', 'EdgeDeploymentStatus$EdgeDeploymentFailedInStage' => '<p>The number of edge devices that failed the deployment in current stage.</p>', 'HyperParameterTuningJobCompletionDetails$NumberOfTrainingJobsObjectiveNotImproving' => '<p>The number of training jobs launched by a tuning job that are not improving (1% or less) as measured by model performance evaluated against an objective function.</p>', 'HyperParameterTuningJobConsumedResources$RuntimeInSeconds' => '<p>The wall clock runtime in seconds used by your hyperparameter tuning job.</p>', 'InferenceMetrics$MaxInvocations' => '<p>The expected maximum number of requests per minute for the instance.</p>', 'InferenceMetrics$ModelLatency' => '<p>The expected model latency at maximum invocations per minute for the instance.</p>', 'ListModelCardExportJobsRequest$ModelCardVersion' => '<p>List export jobs for the model card with the specified version.</p>', 'ModelCard$ModelCardVersion' => '<p>The version of the model card.</p>', 'ModelCardExportJobSummary$ModelCardVersion' => '<p>The version of the model card that the export job exports.</p>', 'ModelCardVersionSummary$ModelCardVersion' => '<p>A version of the model card.</p>', 'ModelDashboardModelCard$ModelCardVersion' => '<p>The model card version.</p>', 'ModelLatencyThreshold$ValueInMilliseconds' => '<p>The model latency percentile value in milliseconds.</p>', 'PipelineExecutionStep$AttemptCount' => '<p>The current attempt of the execution step. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/pipelines-retry-policy.html">Retry Policy for SageMaker Pipelines steps</a>.</p>', 'RecommendationJobStoppingConditions$MaxInvocations' => '<p>The maximum number of requests per minute expected for the endpoint.</p>', 'RecommendationMetrics$MaxInvocations' => '<p>The expected maximum number of requests per minute for the instance.</p>', 'RecommendationMetrics$ModelLatency' => '<p>The expected model latency at maximum invocation per minute for the instance.</p>', 'ScalingPolicyMetric$InvocationsPerInstance' => '<p>The number of invocations sent to a model, normalized by <code>InstanceCount</code> in each ProductionVariant. <code>1/numberOfInstances</code> is sent as the value on each request, where <code>numberOfInstances</code> is the number of active instances for the ProductionVariant behind the endpoint at the time of the request.</p>', 'ScalingPolicyMetric$ModelLatency' => '<p>The interval of time taken by a model to respond as viewed from SageMaker. This interval includes the local communication times taken to send the request and to fetch the response from the container of a model and the time taken to complete the inference in the container.</p>', 'ScalingPolicyObjective$MinInvocationsPerMinute' => '<p>The minimum number of expected requests to your endpoint per minute.</p>', 'ScalingPolicyObjective$MaxInvocationsPerMinute' => '<p>The maximum number of expected requests to your endpoint per minute.</p>', ], ], 'IntegerParameterRange' => [ 'base' => '<p>For a hyperparameter of the integer type, specifies the range that a hyperparameter tuning job searches.</p>', 'refs' => [ 'IntegerParameterRanges$member' => NULL, ], ], 'IntegerParameterRangeSpecification' => [ 'base' => '<p>Defines the possible values for an integer hyperparameter.</p>', 'refs' => [ 'ParameterRange$IntegerParameterRangeSpecification' => '<p>A <code>IntegerParameterRangeSpecification</code> object that defines the possible values for an integer hyperparameter.</p>', ], ], 'IntegerParameterRanges' => [ 'base' => NULL, 'refs' => [ 'ParameterRanges$IntegerParameterRanges' => '<p>The array of <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_IntegerParameterRange.html">IntegerParameterRange</a> objects that specify ranges of integer hyperparameters that a hyperparameter tuning job searches.</p>', ], ], 'InvocationEndTime' => [ 'base' => NULL, 'refs' => [ 'InferenceRecommendation$InvocationEndTime' => '<p>A timestamp that shows when the benchmark completed.</p>', 'RecommendationJobInferenceBenchmark$InvocationEndTime' => '<p>A timestamp that shows when the benchmark completed.</p>', ], ], 'InvocationStartTime' => [ 'base' => NULL, 'refs' => [ 'InferenceRecommendation$InvocationStartTime' => '<p>A timestamp that shows when the benchmark started.</p>', 'RecommendationJobInferenceBenchmark$InvocationStartTime' => '<p>A timestamp that shows when the benchmark started.</p>', ], ], 'InvocationsMaxRetries' => [ 'base' => NULL, 'refs' => [ 'ModelClientConfig$InvocationsMaxRetries' => '<p>The maximum number of retries when invocation requests are failing. The default value is 3.</p>', ], ], 'InvocationsTimeoutInSeconds' => [ 'base' => NULL, 'refs' => [ 'ModelClientConfig$InvocationsTimeoutInSeconds' => '<p>The timeout value in seconds for an invocation request. The default value is 600.</p>', ], ], 'IotRoleAlias' => [ 'base' => NULL, 'refs' => [ 'DescribeDeviceFleetResponse$IotRoleAlias' => '<p>The Amazon Resource Name (ARN) alias created in Amazon Web Services Internet of Things (IoT).</p>', ], ], 'IsTrackingServerActive' => [ 'base' => NULL, 'refs' => [ 'DescribeMlflowTrackingServerResponse$IsActive' => '<p>Whether the described MLflow Tracking Server is currently active.</p>', 'TrackingServerSummary$IsActive' => '<p>The activity status of a listed tracking server.</p>', ], ], 'ItemIdentifierAttributeName' => [ 'base' => NULL, 'refs' => [ 'TimeSeriesConfig$ItemIdentifierAttributeName' => '<p>The name of the column that represents the set of item identifiers for which you want to predict the target value.</p>', ], ], 'JobDurationInSeconds' => [ 'base' => NULL, 'refs' => [ 'RecommendationJobInputConfig$JobDurationInSeconds' => '<p>Specifies the maximum duration of the job, in seconds. The maximum value is 18,000 seconds.</p>', ], ], 'JobReferenceCode' => [ 'base' => NULL, 'refs' => [ 'DescribeLabelingJobResponse$JobReferenceCode' => '<p>A unique identifier for work done as part of a labeling job.</p>', 'LabelingJobForWorkteamSummary$JobReferenceCode' => '<p>A unique identifier for a labeling job. You can use this to refer to a specific labeling job.</p>', ], ], 'JobReferenceCodeContains' => [ 'base' => NULL, 'refs' => [ 'ListLabelingJobsForWorkteamRequest$JobReferenceCodeContains' => '<p>A filter the limits jobs to only the ones whose job reference code contains the specified string.</p>', ], ], 'JobType' => [ 'base' => NULL, 'refs' => [ 'CreateImageVersionRequest$JobType' => '<p>Indicates SageMaker job type compatibility.</p> <ul> <li> <p> <code>TRAINING</code>: The image version is compatible with SageMaker training jobs.</p> </li> <li> <p> <code>INFERENCE</code>: The image version is compatible with SageMaker inference jobs.</p> </li> <li> <p> <code>NOTEBOOK_KERNEL</code>: The image version is compatible with SageMaker notebook kernels.</p> </li> </ul>', 'DescribeImageVersionResponse$JobType' => '<p>Indicates SageMaker job type compatibility.</p> <ul> <li> <p> <code>TRAINING</code>: The image version is compatible with SageMaker training jobs.</p> </li> <li> <p> <code>INFERENCE</code>: The image version is compatible with SageMaker inference jobs.</p> </li> <li> <p> <code>NOTEBOOK_KERNEL</code>: The image version is compatible with SageMaker notebook kernels.</p> </li> </ul>', 'UpdateImageVersionRequest$JobType' => '<p>Indicates SageMaker job type compatibility.</p> <ul> <li> <p> <code>TRAINING</code>: The image version is compatible with SageMaker training jobs.</p> </li> <li> <p> <code>INFERENCE</code>: The image version is compatible with SageMaker inference jobs.</p> </li> <li> <p> <code>NOTEBOOK_KERNEL</code>: The image version is compatible with SageMaker notebook kernels.</p> </li> </ul>', ], ], 'JoinSource' => [ 'base' => NULL, 'refs' => [ 'DataProcessing$JoinSource' => '<p>Specifies the source of the data to join with the transformed data. The valid values are <code>None</code> and <code>Input</code>. The default value is <code>None</code>, which specifies not to join the input with the transformed data. If you want the batch transform job to join the original input data with the transformed data, set <code>JoinSource</code> to <code>Input</code>. You can specify <code>OutputFilter</code> as an additional filter to select a portion of the joined dataset and store it in the output file.</p> <p>For JSON or JSONLines objects, such as a JSON array, SageMaker adds the transformed data to the input JSON object in an attribute called <code>SageMakerOutput</code>. The joined result for JSON must be a key-value pair object. If the input is not a key-value pair object, SageMaker creates a new JSON file. In the new JSON file, and the input data is stored under the <code>SageMakerInput</code> key and the results are stored in <code>SageMakerOutput</code>.</p> <p>For CSV data, SageMaker takes each row as a JSON array and joins the transformed data with the input by appending each transformed row to the end of the input. The joined data has the original input data followed by the transformed data and the output is a CSV file.</p> <p>For information on how joining in applied, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html#batch-transform-data-processing-workflow">Workflow for Associating Inferences with Input Records</a>.</p>', ], ], 'JsonContentType' => [ 'base' => NULL, 'refs' => [ 'JsonContentTypes$member' => NULL, ], ], 'JsonContentTypes' => [ 'base' => NULL, 'refs' => [ 'CaptureContentTypeHeader$JsonContentTypes' => '<p>The list of all content type headers that SageMaker will treat as JSON and capture accordingly.</p>', ], ], 'JsonPath' => [ 'base' => NULL, 'refs' => [ 'DataProcessing$InputFilter' => '<p>A <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html#data-processing-operators">JSONPath</a> expression used to select a portion of the input data to pass to the algorithm. Use the <code>InputFilter</code> parameter to exclude fields, such as an ID column, from the input. If you want SageMaker to pass the entire input dataset to the algorithm, accept the default value <code>$</code>.</p> <p>Examples: <code>"$"</code>, <code>"$[1:]"</code>, <code>"$.features"</code> </p>', 'DataProcessing$OutputFilter' => '<p>A <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html#data-processing-operators">JSONPath</a> expression used to select a portion of the joined dataset to save in the output file for a batch transform job. If you want SageMaker to store the entire input dataset in the output file, leave the default value, <code>$</code>. If you specify indexes that aren\'t within the dimension size of the joined dataset, you get an error.</p> <p>Examples: <code>"$"</code>, <code>"$[0,5:]"</code>, <code>"$[\'id\',\'SageMakerOutput\']"</code> </p>', ], ], 'JupyterLabAppImageConfig' => [ 'base' => '<p>The configuration for the file system and kernels in a SageMaker image running as a JupyterLab app. The <code>FileSystemConfig</code> object is not supported.</p>', 'refs' => [ 'AppImageConfigDetails$JupyterLabAppImageConfig' => '<p>The configuration for the file system and the runtime, such as the environment variables and entry point.</p>', 'CreateAppImageConfigRequest$JupyterLabAppImageConfig' => '<p>The <code>JupyterLabAppImageConfig</code>. You can only specify one image kernel in the <code>AppImageConfig</code> API. This kernel is shown to users before the image starts. After the image runs, all kernels are visible in JupyterLab.</p>', 'DescribeAppImageConfigResponse$JupyterLabAppImageConfig' => '<p>The configuration of the JupyterLab app.</p>', 'UpdateAppImageConfigRequest$JupyterLabAppImageConfig' => '<p>The JupyterLab app running on the image.</p>', ], ], 'JupyterLabAppSettings' => [ 'base' => '<p>The settings for the JupyterLab application.</p>', 'refs' => [ 'DefaultSpaceSettings$JupyterLabAppSettings' => NULL, 'UserSettings$JupyterLabAppSettings' => '<p>The settings for the JupyterLab application.</p>', ], ], 'JupyterServerAppSettings' => [ 'base' => '<p>The JupyterServer app settings.</p>', 'refs' => [ 'DefaultSpaceSettings$JupyterServerAppSettings' => NULL, 'SpaceSettings$JupyterServerAppSettings' => NULL, 'UserSettings$JupyterServerAppSettings' => '<p>The Jupyter server\'s app settings.</p>', ], ], 'KeepAlivePeriodInSeconds' => [ 'base' => 'Optional. Customer requested period in seconds for which the Training cluster is kept alive after the job is finished.', 'refs' => [ 'ResourceConfig$KeepAlivePeriodInSeconds' => '<p>The duration of time in seconds to retain configured resources in a warm pool for subsequent training jobs.</p>', 'ResourceConfigForUpdate$KeepAlivePeriodInSeconds' => '<p>The <code>KeepAlivePeriodInSeconds</code> value specified in the <code>ResourceConfig</code> to update.</p>', ], ], 'KendraSettings' => [ 'base' => '<p>The Amazon SageMaker Canvas application setting where you configure document querying.</p>', 'refs' => [ 'CanvasAppSettings$KendraSettings' => '<p>The settings for document querying.</p>', ], ], 'KernelDisplayName' => [ 'base' => NULL, 'refs' => [ 'KernelSpec$DisplayName' => '<p>The display name of the kernel.</p>', ], ], 'KernelGatewayAppSettings' => [ 'base' => '<p>The KernelGateway app settings.</p>', 'refs' => [ 'DefaultSpaceSettings$KernelGatewayAppSettings' => NULL, 'SpaceSettings$KernelGatewayAppSettings' => NULL, 'UserSettings$KernelGatewayAppSettings' => '<p>The kernel gateway app settings.</p>', ], ], 'KernelGatewayImageConfig' => [ 'base' => '<p>The configuration for the file system and kernels in a SageMaker image running as a KernelGateway app.</p>', 'refs' => [ 'AppImageConfigDetails$KernelGatewayImageConfig' => '<p>The configuration for the file system and kernels in the SageMaker image.</p>', 'CreateAppImageConfigRequest$KernelGatewayImageConfig' => '<p>The KernelGatewayImageConfig. You can only specify one image kernel in the AppImageConfig API. This kernel will be shown to users before the image starts. Once the image runs, all kernels are visible in JupyterLab.</p>', 'DescribeAppImageConfigResponse$KernelGatewayImageConfig' => '<p>The configuration of a KernelGateway app.</p>', 'UpdateAppImageConfigRequest$KernelGatewayImageConfig' => '<p>The new KernelGateway app to run on the image.</p>', ], ], 'KernelName' => [ 'base' => NULL, 'refs' => [ 'KernelSpec$Name' => '<p>The name of the Jupyter kernel in the image. This value is case sensitive.</p>', ], ], 'KernelSpec' => [ 'base' => '<p>The specification of a Jupyter kernel.</p>', 'refs' => [ 'KernelSpecs$member' => NULL, ], ], 'KernelSpecs' => [ 'base' => NULL, 'refs' => [ 'KernelGatewayImageConfig$KernelSpecs' => '<p>The specification of the Jupyter kernels in the image.</p>', ], ], 'Key' => [ 'base' => NULL, 'refs' => [ 'PipelineDefinitionS3Location$ObjectKey' => '<p>The object key (or key name) uniquely identifies the object in an S3 bucket. </p>', ], ], 'KmsKeyId' => [ 'base' => NULL, 'refs' => [ 'AsyncInferenceOutputConfig$KmsKeyId' => '<p>The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that SageMaker uses to encrypt the asynchronous inference output in Amazon S3.</p> <p/>', 'AthenaDatasetDefinition$KmsKeyId' => '<p>The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt data generated from an Athena query execution.</p>', 'AutoMLOutputDataConfig$KmsKeyId' => '<p>The Key Management Service encryption key ID.</p>', 'AutoMLSecurityConfig$VolumeKmsKeyId' => '<p>The key used to encrypt stored data.</p>', 'BatchDataCaptureConfig$KmsKeyId' => '<p>The Amazon Resource Name (ARN) of a Amazon Web Services Key Management Service key that SageMaker uses to encrypt data on the storage volume attached to the ML compute instance that hosts the batch transform job.</p> <p>The KmsKeyId can be any of the following formats: </p> <ul> <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> <li> <p>Key ARN: <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li> <li> <p>Alias name ARN: <code>arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias</code> </p> </li> </ul>', 'CreateDomainRequest$HomeEfsFileSystemKmsKeyId' => '<p>Use <code>KmsKeyId</code>.</p>', 'CreateDomainRequest$KmsKeyId' => '<p>SageMaker uses Amazon Web Services KMS to encrypt EFS and EBS volumes attached to the domain with an Amazon Web Services managed key by default. For more control, specify a customer managed key.</p>', 'CreateEdgePackagingJobRequest$ResourceKey' => '<p>The Amazon Web Services KMS key to use when encrypting the EBS volume the edge packaging job runs on.</p>', 'CreateEndpointConfigInput$KmsKeyId' => '<p>The Amazon Resource Name (ARN) of a Amazon Web Services Key Management Service key that SageMaker uses to encrypt data on the storage volume attached to the ML compute instance that hosts the endpoint.</p> <p>The KmsKeyId can be any of the following formats: </p> <ul> <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> <li> <p>Key ARN: <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li> <li> <p>Alias name ARN: <code>arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias</code> </p> </li> </ul> <p>The KMS key policy must grant permission to the IAM role that you specify in your <code>CreateEndpoint</code>, <code>UpdateEndpoint</code> requests. For more information, refer to the Amazon Web Services Key Management Service section<a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html"> Using Key Policies in Amazon Web Services KMS </a> </p> <note> <p>Certain Nitro-based instances include local storage, dependent on the instance type. Local storage volumes are encrypted using a hardware module on the instance. You can\'t request a <code>KmsKeyId</code> when using an instance type with local storage. If any of the models that you specify in the <code>ProductionVariants</code> parameter use nitro-based instances with local storage, do not specify a value for the <code>KmsKeyId</code> parameter. If you specify a value for <code>KmsKeyId</code> when using any nitro-based instances with local storage, the call to <code>CreateEndpointConfig</code> fails.</p> <p>For a list of instance types that support local instance storage, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes">Instance Store Volumes</a>.</p> <p>For more information about local instance storage encryption, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html">SSD Instance Store Volumes</a>.</p> </note>', 'CreateInferenceExperimentRequest$KmsKey' => '<p> The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance that hosts the endpoint. The <code>KmsKey</code> can be any of the following formats: </p> <ul> <li> <p>KMS key ID</p> <p> <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> <li> <p>Amazon Resource Name (ARN) of a KMS key</p> <p> <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> <li> <p>KMS key Alias</p> <p> <code>"alias/ExampleAlias"</code> </p> </li> <li> <p>Amazon Resource Name (ARN) of a KMS key Alias</p> <p> <code>"arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias"</code> </p> </li> </ul> <p> If you use a KMS key ID or an alias of your KMS key, the Amazon SageMaker execution role must include permissions to call <code>kms:Encrypt</code>. If you don\'t provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your role\'s account. Amazon SageMaker uses server-side encryption with KMS managed keys for <code>OutputDataConfig</code>. If you use a bucket policy with an <code>s3:PutObject</code> permission that only allows objects with server-side encryption, set the condition key of <code>s3:x-amz-server-side-encryption</code> to <code>"aws:kms"</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html">KMS managed Encryption Keys</a> in the <i>Amazon Simple Storage Service Developer Guide.</i> </p> <p> The KMS key policy must grant permission to the IAM role that you specify in your <code>CreateEndpoint</code> and <code>UpdateEndpoint</code> requests. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html">Using Key Policies in Amazon Web Services KMS</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>. </p>', 'CreateNotebookInstanceInput$KmsKeyId' => '<p>The Amazon Resource Name (ARN) of a Amazon Web Services Key Management Service key that SageMaker uses to encrypt data on the storage volume attached to your notebook instance. The KMS key you provide must be enabled. For information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/enabling-keys.html">Enabling and Disabling Keys</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.</p>', 'DataCaptureConfig$KmsKeyId' => '<p>The Amazon Resource Name (ARN) of an Key Management Service key that SageMaker uses to encrypt the captured data at rest using Amazon S3 server-side encryption.</p> <p>The KmsKeyId can be any of the following formats: </p> <ul> <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> <li> <p>Key ARN: <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li> <li> <p>Alias name ARN: <code>arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias</code> </p> </li> </ul>', 'DataCaptureConfigSummary$KmsKeyId' => '<p>The KMS key being used to encrypt the data in Amazon S3.</p>', 'DescribeDomainResponse$HomeEfsFileSystemKmsKeyId' => '<p>Use <code>KmsKeyId</code>.</p>', 'DescribeDomainResponse$KmsKeyId' => '<p>The Amazon Web Services KMS customer managed key used to encrypt the EFS volume attached to the domain.</p>', 'DescribeEdgePackagingJobResponse$ResourceKey' => '<p>The Amazon Web Services KMS key to use when encrypting the EBS volume the job run on.</p>', 'DescribeEndpointConfigOutput$KmsKeyId' => '<p>Amazon Web Services KMS key ID Amazon SageMaker uses to encrypt data when storing it on the ML storage volume attached to the instance.</p>', 'DescribeInferenceExperimentResponse$KmsKey' => '<p> The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance that hosts the endpoint. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateInferenceExperiment.html">CreateInferenceExperiment</a>. </p>', 'DescribeNotebookInstanceOutput$KmsKeyId' => '<p>The Amazon Web Services KMS key ID SageMaker uses to encrypt data when storing it on the ML storage volume attached to the instance. </p>', 'EdgeOutputConfig$KmsKeyId' => '<p>The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt data on the storage volume after compilation job. If you don\'t provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your role\'s account.</p>', 'FlowDefinitionOutputConfig$KmsKeyId' => '<p>The Amazon Key Management Service (KMS) key ID for server-side encryption.</p>', 'HyperParameterTuningResourceConfig$VolumeKmsKeyId' => '<p>A key used by Amazon Web Services Key Management Service to encrypt data on the storage volume attached to the compute instances used to run the training job. You can use either of the following formats to specify a key.</p> <p>KMS Key ID:</p> <p> <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> <p>Amazon Resource Name (ARN) of a KMS key:</p> <p> <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> <p>Some instances use local storage, which use a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html">hardware module to encrypt</a> storage volumes. If you choose one of these instance types, you cannot request a <code>VolumeKmsKeyId</code>. For a list of instance types that use local storage, see <a href="http://aws.amazon.com/releasenotes/host-instance-storage-volumes-table/">instance store volumes</a>. For more information about Amazon Web Services Key Management Service, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-security-kms-permissions.html">KMS encryption</a> for more information.</p>', 'InferenceExperimentDataStorageConfig$KmsKey' => '<p> The Amazon Web Services Key Management Service key that Amazon SageMaker uses to encrypt captured data at rest using Amazon S3 server-side encryption. </p>', 'LabelingJobOutputConfig$KmsKeyId' => '<p>The Amazon Web Services Key Management Service ID of the key used to encrypt the output data, if any.</p> <p>If you provide your own KMS key ID, you must add the required permissions to your KMS key described in <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-security-permission.html#sms-security-kms-permissions">Encrypt Output Data and Storage Volume with Amazon Web Services KMS</a>.</p> <p>If you don\'t provide a KMS key ID, Amazon SageMaker uses the default Amazon Web Services KMS key for Amazon S3 for your role\'s account to encrypt your output data.</p> <p>If you use a bucket policy with an <code>s3:PutObject</code> permission that only allows objects with server-side encryption, set the condition key of <code>s3:x-amz-server-side-encryption</code> to <code>"aws:kms"</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html">KMS-Managed Encryption Keys</a> in the <i>Amazon Simple Storage Service Developer Guide.</i> </p>', 'LabelingJobResourceConfig$VolumeKmsKeyId' => '<p>The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the training and inference jobs used for automated data labeling. </p> <p>You can only specify a <code>VolumeKmsKeyId</code> when you create a labeling job with automated data labeling enabled using the API operation <code>CreateLabelingJob</code>. You cannot specify an Amazon Web Services KMS key to encrypt the storage volume used for automated data labeling model training and inference when you create a labeling job using the console. To learn more, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-security.html">Output Data and Storage Volume Encryption</a>.</p> <p>The <code>VolumeKmsKeyId</code> can be any of the following formats:</p> <ul> <li> <p>KMS Key ID</p> <p> <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> <li> <p>Amazon Resource Name (ARN) of a KMS Key</p> <p> <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> </ul>', 'ModelCardSecurityConfig$KmsKeyId' => '<p>A Key Management Service <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-id">key ID</a> to use for encrypting a model card.</p>', 'ModelPackageSecurityConfig$KmsKeyId' => '<p>The KMS Key ID (<code>KMSKeyId</code>) used for encryption of model package information.</p>', 'MonitoringClusterConfig$VolumeKmsKeyId' => '<p>The Key Management Service (KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the model monitoring job.</p>', 'MonitoringOutputConfig$KmsKeyId' => '<p>The Key Management Service (KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.</p>', 'OnlineStoreSecurityConfig$KmsKeyId' => '<p>The Amazon Web Services Key Management Service (KMS) key ARN that SageMaker Feature Store uses to encrypt the Amazon S3 objects at rest using Amazon S3 server-side encryption.</p> <p>The caller (either user or IAM role) of <code>CreateFeatureGroup</code> must have below permissions to the <code>OnlineStore</code> <code>KmsKeyId</code>:</p> <ul> <li> <p> <code>"kms:Encrypt"</code> </p> </li> <li> <p> <code>"kms:Decrypt"</code> </p> </li> <li> <p> <code>"kms:DescribeKey"</code> </p> </li> <li> <p> <code>"kms:CreateGrant"</code> </p> </li> <li> <p> <code>"kms:RetireGrant"</code> </p> </li> <li> <p> <code>"kms:ReEncryptFrom"</code> </p> </li> <li> <p> <code>"kms:ReEncryptTo"</code> </p> </li> <li> <p> <code>"kms:GenerateDataKey"</code> </p> </li> <li> <p> <code>"kms:ListAliases"</code> </p> </li> <li> <p> <code>"kms:ListGrants"</code> </p> </li> <li> <p> <code>"kms:RevokeGrant"</code> </p> </li> </ul> <p>The caller (either user or IAM role) to all DataPlane operations (<code>PutRecord</code>, <code>GetRecord</code>, <code>DeleteRecord</code>) must have the following permissions to the <code>KmsKeyId</code>:</p> <ul> <li> <p> <code>"kms:Decrypt"</code> </p> </li> </ul>', 'OptimizationJobOutputConfig$KmsKeyId' => '<p>The Amazon Resource Name (ARN) of a key in Amazon Web Services KMS. SageMaker uses they key to encrypt the artifacts of the optimized model when SageMaker uploads the model to Amazon S3.</p>', 'OutputConfig$KmsKeyId' => '<p>The Amazon Web Services Key Management Service key (Amazon Web Services KMS) that Amazon SageMaker uses to encrypt your output models with Amazon S3 server-side encryption after compilation job. If you don\'t provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your role\'s account. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/UsingKMSEncryption.html">KMS-Managed Encryption Keys</a> in the <i>Amazon Simple Storage Service Developer Guide.</i> </p> <p>The KmsKeyId can be any of the following formats: </p> <ul> <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> <li> <p>Key ARN: <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li> <li> <p>Alias name ARN: <code>arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias</code> </p> </li> </ul>', 'OutputDataConfig$KmsKeyId' => '<p>The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption. The <code>KmsKeyId</code> can be any of the following formats: </p> <ul> <li> <p>// KMS Key ID</p> <p> <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> <li> <p>// Amazon Resource Name (ARN) of a KMS Key</p> <p> <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> <li> <p>// KMS Key Alias</p> <p> <code>"alias/ExampleAlias"</code> </p> </li> <li> <p>// Amazon Resource Name (ARN) of a KMS Key Alias</p> <p> <code>"arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias"</code> </p> </li> </ul> <p>If you use a KMS key ID or an alias of your KMS key, the SageMaker execution role must include permissions to call <code>kms:Encrypt</code>. If you don\'t provide a KMS key ID, SageMaker uses the default KMS key for Amazon S3 for your role\'s account. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/UsingKMSEncryption.html">KMS-Managed Encryption Keys</a> in the <i>Amazon Simple Storage Service Developer Guide</i>. If the output data is stored in Amazon S3 Express One Zone, it is encrypted with server-side encryption with Amazon S3 managed keys (SSE-S3). KMS key is not supported for Amazon S3 Express One Zone</p> <p>The KMS key policy must grant permission to the IAM role that you specify in your <code>CreateTrainingJob</code>, <code>CreateTransformJob</code>, or <code>CreateHyperParameterTuningJob</code> requests. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html">Using Key Policies in Amazon Web Services KMS</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.</p>', 'ProcessingClusterConfig$VolumeKmsKeyId' => '<p>The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the processing job. </p> <note> <p>Certain Nitro-based instances include local storage, dependent on the instance type. Local storage volumes are encrypted using a hardware module on the instance. You can\'t request a <code>VolumeKmsKeyId</code> when using an instance type with local storage.</p> <p>For a list of instance types that support local instance storage, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes">Instance Store Volumes</a>.</p> <p>For more information about local instance storage encryption, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html">SSD Instance Store Volumes</a>.</p> </note>', 'ProcessingOutputConfig$KmsKeyId' => '<p>The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt the processing job output. <code>KmsKeyId</code> can be an ID of a KMS key, ARN of a KMS key, alias of a KMS key, or alias of a KMS key. The <code>KmsKeyId</code> is applied to all outputs.</p>', 'ProductionVariantCoreDumpConfig$KmsKeyId' => '<p>The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that SageMaker uses to encrypt the core dump data at rest using Amazon S3 server-side encryption. The <code>KmsKeyId</code> can be any of the following formats: </p> <ul> <li> <p>// KMS Key ID</p> <p> <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> <li> <p>// Amazon Resource Name (ARN) of a KMS Key</p> <p> <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> <li> <p>// KMS Key Alias</p> <p> <code>"alias/ExampleAlias"</code> </p> </li> <li> <p>// Amazon Resource Name (ARN) of a KMS Key Alias</p> <p> <code>"arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias"</code> </p> </li> </ul> <p>If you use a KMS key ID or an alias of your KMS key, the SageMaker execution role must include permissions to call <code>kms:Encrypt</code>. If you don\'t provide a KMS key ID, SageMaker uses the default KMS key for Amazon S3 for your role\'s account. SageMaker uses server-side encryption with KMS-managed keys for <code>OutputDataConfig</code>. If you use a bucket policy with an <code>s3:PutObject</code> permission that only allows objects with server-side encryption, set the condition key of <code>s3:x-amz-server-side-encryption</code> to <code>"aws:kms"</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html">KMS-Managed Encryption Keys</a> in the <i>Amazon Simple Storage Service Developer Guide.</i> </p> <p>The KMS key policy must grant permission to the IAM role that you specify in your <code>CreateEndpoint</code> and <code>UpdateEndpoint</code> requests. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html">Using Key Policies in Amazon Web Services KMS</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.</p>', 'RecommendationJobInputConfig$VolumeKmsKeyId' => '<p>The Amazon Resource Name (ARN) of a Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance that hosts the endpoint. This key will be passed to SageMaker Hosting for endpoint creation. </p> <p>The SageMaker execution role must have <code>kms:CreateGrant</code> permission in order to encrypt data on the storage volume of the endpoints created for inference recommendation. The inference recommendation job will fail asynchronously during endpoint configuration creation if the role passed does not have <code>kms:CreateGrant</code> permission.</p> <p>The <code>KmsKeyId</code> can be any of the following formats:</p> <ul> <li> <p>// KMS Key ID</p> <p> <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> <li> <p>// Amazon Resource Name (ARN) of a KMS Key</p> <p> <code>"arn:aws:kms:&lt;region&gt;:&lt;account&gt;:key/&lt;key-id-12ab-34cd-56ef-1234567890ab&gt;"</code> </p> </li> <li> <p>// KMS Key Alias</p> <p> <code>"alias/ExampleAlias"</code> </p> </li> <li> <p>// Amazon Resource Name (ARN) of a KMS Key Alias</p> <p> <code>"arn:aws:kms:&lt;region&gt;:&lt;account&gt;:alias/&lt;ExampleAlias&gt;"</code> </p> </li> </ul> <p>For more information about key identifiers, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-id">Key identifiers (KeyID)</a> in the Amazon Web Services Key Management Service (Amazon Web Services KMS) documentation.</p>', 'RecommendationJobOutputConfig$KmsKeyId' => '<p>The Amazon Resource Name (ARN) of a Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt your output artifacts with Amazon S3 server-side encryption. The SageMaker execution role must have <code>kms:GenerateDataKey</code> permission.</p> <p>The <code>KmsKeyId</code> can be any of the following formats:</p> <ul> <li> <p>// KMS Key ID</p> <p> <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> <li> <p>// Amazon Resource Name (ARN) of a KMS Key</p> <p> <code>"arn:aws:kms:&lt;region&gt;:&lt;account&gt;:key/&lt;key-id-12ab-34cd-56ef-1234567890ab&gt;"</code> </p> </li> <li> <p>// KMS Key Alias</p> <p> <code>"alias/ExampleAlias"</code> </p> </li> <li> <p>// Amazon Resource Name (ARN) of a KMS Key Alias</p> <p> <code>"arn:aws:kms:&lt;region&gt;:&lt;account&gt;:alias/&lt;ExampleAlias&gt;"</code> </p> </li> </ul> <p>For more information about key identifiers, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-id">Key identifiers (KeyID)</a> in the Amazon Web Services Key Management Service (Amazon Web Services KMS) documentation.</p>', 'RedshiftDatasetDefinition$KmsKeyId' => '<p>The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt data from a Redshift execution.</p>', 'ResourceConfig$VolumeKmsKeyId' => '<p>The Amazon Web Services KMS key that SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the training job.</p> <note> <p>Certain Nitro-based instances include local storage, dependent on the instance type. Local storage volumes are encrypted using a hardware module on the instance. You can\'t request a <code>VolumeKmsKeyId</code> when using an instance type with local storage.</p> <p>For a list of instance types that support local instance storage, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes">Instance Store Volumes</a>.</p> <p>For more information about local instance storage encryption, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html">SSD Instance Store Volumes</a>.</p> </note> <p>The <code>VolumeKmsKeyId</code> can be in any of the following formats:</p> <ul> <li> <p>// KMS Key ID</p> <p> <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> <li> <p>// Amazon Resource Name (ARN) of a KMS Key</p> <p> <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> </ul>', 'S3StorageConfig$KmsKeyId' => '<p>The Amazon Web Services Key Management Service (KMS) key ARN of the key used to encrypt any objects written into the <code>OfflineStore</code> S3 location.</p> <p>The IAM <code>roleARN</code> that is passed as a parameter to <code>CreateFeatureGroup</code> must have below permissions to the <code>KmsKeyId</code>:</p> <ul> <li> <p> <code>"kms:GenerateDataKey"</code> </p> </li> </ul>', 'SharingSettings$S3KmsKeyId' => '<p>When <code>NotebookOutputOption</code> is <code>Allowed</code>, the Amazon Web Services Key Management Service (KMS) encryption key ID used to encrypt the notebook cell output in the Amazon S3 bucket.</p>', 'TransformOutput$KmsKeyId' => '<p>The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption. The <code>KmsKeyId</code> can be any of the following formats: </p> <ul> <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> <li> <p>Key ARN: <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li> <li> <p>Alias name ARN: <code>arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias</code> </p> </li> </ul> <p>If you don\'t provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your role\'s account. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html">KMS-Managed Encryption Keys</a> in the <i>Amazon Simple Storage Service Developer Guide.</i> </p> <p>The KMS key policy must grant permission to the IAM role that you specify in your <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateModel.html">CreateModel</a> request. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html">Using Key Policies in Amazon Web Services KMS</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.</p>', 'TransformResources$VolumeKmsKeyId' => '<p>The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt model data on the storage volume attached to the ML compute instance(s) that run the batch transform job.</p> <note> <p>Certain Nitro-based instances include local storage, dependent on the instance type. Local storage volumes are encrypted using a hardware module on the instance. You can\'t request a <code>VolumeKmsKeyId</code> when using an instance type with local storage.</p> <p>For a list of instance types that support local instance storage, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes">Instance Store Volumes</a>.</p> <p>For more information about local instance storage encryption, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html">SSD Instance Store Volumes</a>.</p> </note> <p> The <code>VolumeKmsKeyId</code> can be any of the following formats:</p> <ul> <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> <li> <p>Key ARN: <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li> <li> <p>Alias name ARN: <code>arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias</code> </p> </li> </ul>', 'WorkspaceSettings$S3KmsKeyId' => '<p>The Amazon Web Services Key Management Service (KMS) encryption key ID that is used to encrypt artifacts generated by Canvas in the Amazon S3 bucket.</p>', ], ], 'LabelAttributeName' => [ 'base' => NULL, 'refs' => [ 'CreateLabelingJobRequest$LabelAttributeName' => '<p>The attribute name to use for the label in the output manifest file. This is the key for the key/value pair formed with the label that a worker assigns to the object. The <code>LabelAttributeName</code> must meet the following requirements.</p> <ul> <li> <p>The name can\'t end with "-metadata". </p> </li> <li> <p>If you are using one of the following <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html">built-in task types</a>, the attribute name <i>must</i> end with "-ref". If the task type you are using is not listed below, the attribute name <i>must not</i> end with "-ref".</p> <ul> <li> <p>Image semantic segmentation (<code>SemanticSegmentation)</code>, and adjustment (<code>AdjustmentSemanticSegmentation</code>) and verification (<code>VerificationSemanticSegmentation</code>) labeling jobs for this task type.</p> </li> <li> <p>Video frame object detection (<code>VideoObjectDetection</code>), and adjustment and verification (<code>AdjustmentVideoObjectDetection</code>) labeling jobs for this task type.</p> </li> <li> <p>Video frame object tracking (<code>VideoObjectTracking</code>), and adjustment and verification (<code>AdjustmentVideoObjectTracking</code>) labeling jobs for this task type.</p> </li> <li> <p>3D point cloud semantic segmentation (<code>3DPointCloudSemanticSegmentation</code>), and adjustment and verification (<code>Adjustment3DPointCloudSemanticSegmentation</code>) labeling jobs for this task type. </p> </li> <li> <p>3D point cloud object tracking (<code>3DPointCloudObjectTracking</code>), and adjustment and verification (<code>Adjustment3DPointCloudObjectTracking</code>) labeling jobs for this task type. </p> </li> </ul> </li> </ul> <p/> <important> <p>If you are creating an adjustment or verification labeling job, you must use a <i>different</i> <code>LabelAttributeName</code> than the one used in the original labeling job. The original labeling job is the Ground Truth labeling job that produced the labels that you want verified or adjusted. To learn more about adjustment and verification labeling jobs, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-verification-data.html">Verify and Adjust Labels</a>.</p> </important>', 'DescribeLabelingJobResponse$LabelAttributeName' => '<p>The attribute used as the label in the output manifest file.</p>', ], ], 'LabelCounter' => [ 'base' => NULL, 'refs' => [ 'LabelCounters$TotalLabeled' => '<p>The total number of objects labeled.</p>', 'LabelCounters$HumanLabeled' => '<p>The total number of objects labeled by a human worker.</p>', 'LabelCounters$MachineLabeled' => '<p>The total number of objects labeled by automated data labeling.</p>', 'LabelCounters$FailedNonRetryableError' => '<p>The total number of objects that could not be labeled due to an error.</p>', 'LabelCounters$Unlabeled' => '<p>The total number of objects not yet labeled.</p>', 'LabelCountersForWorkteam$HumanLabeled' => '<p>The total number of data objects labeled by a human worker.</p>', 'LabelCountersForWorkteam$PendingHuman' => '<p>The total number of data objects that need to be labeled by a human worker.</p>', 'LabelCountersForWorkteam$Total' => '<p>The total number of tasks in the labeling job.</p>', ], ], 'LabelCounters' => [ 'base' => '<p>Provides a breakdown of the number of objects labeled.</p>', 'refs' => [ 'DescribeLabelingJobResponse$LabelCounters' => '<p>Provides a breakdown of the number of data objects labeled by humans, the number of objects labeled by machine, the number of objects than couldn\'t be labeled, and the total number of objects labeled. </p>', 'LabelingJobSummary$LabelCounters' => '<p>Counts showing the progress of the labeling job.</p>', ], ], 'LabelCountersForWorkteam' => [ 'base' => '<p>Provides counts for human-labeled tasks in the labeling job.</p>', 'refs' => [ 'LabelingJobForWorkteamSummary$LabelCounters' => '<p>Provides information about the progress of a labeling job.</p>', ], ], 'LabelingJobAlgorithmSpecificationArn' => [ 'base' => NULL, 'refs' => [ 'LabelingJobAlgorithmsConfig$LabelingJobAlgorithmSpecificationArn' => '<p>Specifies the Amazon Resource Name (ARN) of the algorithm used for auto-labeling. You must select one of the following ARNs:</p> <ul> <li> <p> <i>Image classification</i> </p> <p> <code>arn:aws:sagemaker:<i>region</i>:027400017018:labeling-job-algorithm-specification/image-classification</code> </p> </li> <li> <p> <i>Text classification</i> </p> <p> <code>arn:aws:sagemaker:<i>region</i>:027400017018:labeling-job-algorithm-specification/text-classification</code> </p> </li> <li> <p> <i>Object detection</i> </p> <p> <code>arn:aws:sagemaker:<i>region</i>:027400017018:labeling-job-algorithm-specification/object-detection</code> </p> </li> <li> <p> <i>Semantic Segmentation</i> </p> <p> <code>arn:aws:sagemaker:<i>region</i>:027400017018:labeling-job-algorithm-specification/semantic-segmentation</code> </p> </li> </ul>', ], ], 'LabelingJobAlgorithmsConfig' => [ 'base' => '<p>Provides configuration information for auto-labeling of your data objects. A <code>LabelingJobAlgorithmsConfig</code> object must be supplied in order to use auto-labeling.</p>', 'refs' => [ 'CreateLabelingJobRequest$LabelingJobAlgorithmsConfig' => '<p>Configures the information required to perform automated data labeling.</p>', 'DescribeLabelingJobResponse$LabelingJobAlgorithmsConfig' => '<p>Configuration information for automated data labeling.</p>', ], ], 'LabelingJobArn' => [ 'base' => NULL, 'refs' => [ 'CreateLabelingJobResponse$LabelingJobArn' => '<p>The Amazon Resource Name (ARN) of the labeling job. You use this ARN to identify the labeling job.</p>', 'DescribeLabelingJobResponse$LabelingJobArn' => '<p>The Amazon Resource Name (ARN) of the labeling job.</p>', 'DescribeTrainingJobResponse$LabelingJobArn' => '<p>The Amazon Resource Name (ARN) of the SageMaker Ground Truth labeling job that created the transform or training job.</p>', 'DescribeTransformJobResponse$LabelingJobArn' => '<p>The Amazon Resource Name (ARN) of the Amazon SageMaker Ground Truth labeling job that created the transform or training job.</p>', 'LabelingJobSummary$LabelingJobArn' => '<p>The Amazon Resource Name (ARN) assigned to the labeling job when it was created.</p>', 'TrainingJob$LabelingJobArn' => '<p>The Amazon Resource Name (ARN) of the labeling job.</p>', 'TransformJob$LabelingJobArn' => '<p>The Amazon Resource Name (ARN) of the labeling job that created the transform job.</p>', ], ], 'LabelingJobDataAttributes' => [ 'base' => '<p>Attributes of the data specified by the customer. Use these to describe the data to be labeled.</p>', 'refs' => [ 'LabelingJobInputConfig$DataAttributes' => '<p>Attributes of the data specified by the customer.</p>', ], ], 'LabelingJobDataSource' => [ 'base' => '<p>Provides information about the location of input data.</p> <p>You must specify at least one of the following: <code>S3DataSource</code> or <code>SnsDataSource</code>.</p> <p>Use <code>SnsDataSource</code> to specify an SNS input topic for a streaming labeling job. If you do not specify and SNS input topic ARN, Ground Truth will create a one-time labeling job.</p> <p>Use <code>S3DataSource</code> to specify an input manifest file for both streaming and one-time labeling jobs. Adding an <code>S3DataSource</code> is optional if you use <code>SnsDataSource</code> to create a streaming labeling job.</p>', 'refs' => [ 'LabelingJobInputConfig$DataSource' => '<p>The location of the input data.</p>', ], ], 'LabelingJobForWorkteamSummary' => [ 'base' => '<p>Provides summary information for a work team.</p>', 'refs' => [ 'LabelingJobForWorkteamSummaryList$member' => NULL, ], ], 'LabelingJobForWorkteamSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListLabelingJobsForWorkteamResponse$LabelingJobSummaryList' => '<p>An array of <code>LabelingJobSummary</code> objects, each describing a labeling job.</p>', ], ], 'LabelingJobInputConfig' => [ 'base' => '<p>Input configuration information for a labeling job.</p>', 'refs' => [ 'CreateLabelingJobRequest$InputConfig' => '<p>Input data for the labeling job, such as the Amazon S3 location of the data objects and the location of the manifest file that describes the data objects.</p> <p>You must specify at least one of the following: <code>S3DataSource</code> or <code>SnsDataSource</code>. </p> <ul> <li> <p>Use <code>SnsDataSource</code> to specify an SNS input topic for a streaming labeling job. If you do not specify and SNS input topic ARN, Ground Truth will create a one-time labeling job that stops after all data objects in the input manifest file have been labeled.</p> </li> <li> <p>Use <code>S3DataSource</code> to specify an input manifest file for both streaming and one-time labeling jobs. Adding an <code>S3DataSource</code> is optional if you use <code>SnsDataSource</code> to create a streaming labeling job.</p> </li> </ul> <p>If you use the Amazon Mechanical Turk workforce, your input data should not include confidential information, personal information or protected health information. Use <code>ContentClassifiers</code> to specify that your data is free of personally identifiable information and adult content.</p>', 'DescribeLabelingJobResponse$InputConfig' => '<p>Input configuration information for the labeling job, such as the Amazon S3 location of the data objects and the location of the manifest file that describes the data objects.</p>', 'LabelingJobSummary$InputConfig' => '<p>Input configuration for the labeling job.</p>', ], ], 'LabelingJobName' => [ 'base' => NULL, 'refs' => [ 'CreateLabelingJobRequest$LabelingJobName' => '<p>The name of the labeling job. This name is used to identify the job in a list of labeling jobs. Labeling job names must be unique within an Amazon Web Services account and region. <code>LabelingJobName</code> is not case sensitive. For example, Example-job and example-job are considered the same labeling job name by Ground Truth.</p>', 'DescribeLabelingJobRequest$LabelingJobName' => '<p>The name of the labeling job to return information for.</p>', 'DescribeLabelingJobResponse$LabelingJobName' => '<p>The name assigned to the labeling job when it was created.</p>', 'LabelingJobForWorkteamSummary$LabelingJobName' => '<p>The name of the labeling job that the work team is assigned to.</p>', 'LabelingJobSummary$LabelingJobName' => '<p>The name of the labeling job.</p>', 'StopLabelingJobRequest$LabelingJobName' => '<p>The name of the labeling job to stop.</p>', ], ], 'LabelingJobOutput' => [ 'base' => '<p>Specifies the location of the output produced by the labeling job. </p>', 'refs' => [ 'DescribeLabelingJobResponse$LabelingJobOutput' => '<p>The location of the output produced by the labeling job.</p>', 'LabelingJobSummary$LabelingJobOutput' => '<p>The location of the output produced by the labeling job.</p>', ], ], 'LabelingJobOutputConfig' => [ 'base' => '<p>Output configuration information for a labeling job.</p>', 'refs' => [ 'CreateLabelingJobRequest$OutputConfig' => '<p>The location of the output data and the Amazon Web Services Key Management Service key ID for the key used to encrypt the output data, if any.</p>', 'DescribeLabelingJobResponse$OutputConfig' => '<p>The location of the job\'s output data and the Amazon Web Services Key Management Service key ID for the key used to encrypt the output data, if any.</p>', ], ], 'LabelingJobResourceConfig' => [ 'base' => '<p>Configure encryption on the storage volume attached to the ML compute instance used to run automated data labeling model training and inference. </p>', 'refs' => [ 'LabelingJobAlgorithmsConfig$LabelingJobResourceConfig' => '<p>Provides configuration information for a labeling job.</p>', ], ], 'LabelingJobS3DataSource' => [ 'base' => '<p>The Amazon S3 location of the input data objects.</p>', 'refs' => [ 'LabelingJobDataSource$S3DataSource' => '<p>The Amazon S3 location of the input data objects.</p>', ], ], 'LabelingJobSnsDataSource' => [ 'base' => '<p>An Amazon SNS data source used for streaming labeling jobs.</p>', 'refs' => [ 'LabelingJobDataSource$SnsDataSource' => '<p>An Amazon SNS data source used for streaming labeling jobs. To learn more, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-streaming-labeling-job.html#sms-streaming-how-it-works-send-data">Send Data to a Streaming Labeling Job</a>. </p>', ], ], 'LabelingJobStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeLabelingJobResponse$LabelingJobStatus' => '<p>The processing status of the labeling job. </p>', 'LabelingJobSummary$LabelingJobStatus' => '<p>The current status of the labeling job. </p>', 'ListLabelingJobsRequest$StatusEquals' => '<p>A filter that retrieves only labeling jobs with a specific status.</p>', ], ], 'LabelingJobStoppingConditions' => [ 'base' => '<p>A set of conditions for stopping a labeling job. If any of the conditions are met, the job is automatically stopped. You can use these conditions to control the cost of data labeling.</p> <note> <p>Labeling jobs fail after 30 days with an appropriate client error message.</p> </note>', 'refs' => [ 'CreateLabelingJobRequest$StoppingConditions' => '<p>A set of conditions for stopping the labeling job. If any of the conditions are met, the job is automatically stopped. You can use these conditions to control the cost of data labeling.</p>', 'DescribeLabelingJobResponse$StoppingConditions' => '<p>A set of conditions for stopping a labeling job. If any of the conditions are met, the job is automatically stopped.</p>', ], ], 'LabelingJobSummary' => [ 'base' => '<p>Provides summary information about a labeling job.</p>', 'refs' => [ 'LabelingJobSummaryList$member' => NULL, ], ], 'LabelingJobSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListLabelingJobsResponse$LabelingJobSummaryList' => '<p>An array of <code>LabelingJobSummary</code> objects, each describing a labeling job.</p>', ], ], 'LambdaFunctionArn' => [ 'base' => NULL, 'refs' => [ 'AnnotationConsolidationConfig$AnnotationConsolidationLambdaArn' => '<p>The Amazon Resource Name (ARN) of a Lambda function implements the logic for <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-annotation-consolidation.html">annotation consolidation</a> and to process output data.</p> <p>This parameter is required for all labeling jobs. For <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html">built-in task types</a>, use one of the following Amazon SageMaker Ground Truth Lambda function ARNs for <code>AnnotationConsolidationLambdaArn</code>. For custom labeling workflows, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-custom-templates-step3.html#sms-custom-templates-step3-postlambda">Post-annotation Lambda</a>. </p> <p> <b>Bounding box</b> - Finds the most similar boxes from different workers based on the Jaccard index of the boxes.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-BoundingBox</code> </p> </li> </ul> <p> <b>Image classification</b> - Uses a variant of the Expectation Maximization approach to estimate the true class of an image based on annotations from individual workers.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-ImageMultiClass</code> </p> </li> </ul> <p> <b>Multi-label image classification</b> - Uses a variant of the Expectation Maximization approach to estimate the true classes of an image based on annotations from individual workers.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-ImageMultiClassMultiLabel</code> </p> </li> </ul> <p> <b>Semantic segmentation</b> - Treats each pixel in an image as a multi-class classification and treats pixel annotations from workers as "votes" for the correct label.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-SemanticSegmentation</code> </p> </li> </ul> <p> <b>Text classification</b> - Uses a variant of the Expectation Maximization approach to estimate the true class of text based on annotations from individual workers.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-TextMultiClass</code> </p> </li> </ul> <p> <b>Multi-label text classification</b> - Uses a variant of the Expectation Maximization approach to estimate the true classes of text based on annotations from individual workers.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-TextMultiClassMultiLabel</code> </p> </li> </ul> <p> <b>Named entity recognition</b> - Groups similar selections and calculates aggregate boundaries, resolving to most-assigned label.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-NamedEntityRecognition</code> </p> </li> </ul> <p> <b>Video Classification</b> - Use this task type when you need workers to classify videos using predefined labels that you specify. Workers are shown videos and are asked to choose one label for each video.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-VideoMultiClass</code> </p> </li> </ul> <p> <b>Video Frame Object Detection</b> - Use this task type to have workers identify and locate objects in a sequence of video frames (images extracted from a video) using bounding boxes. For example, you can use this task to ask workers to identify and localize various objects in a series of video frames, such as cars, bikes, and pedestrians.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-VideoObjectDetection</code> </p> </li> </ul> <p> <b>Video Frame Object Tracking</b> - Use this task type to have workers track the movement of objects in a sequence of video frames (images extracted from a video) using bounding boxes. For example, you can use this task to ask workers to track the movement of objects, such as cars, bikes, and pedestrians. </p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-VideoObjectTracking</code> </p> </li> </ul> <p> <b>3D Point Cloud Object Detection</b> - Use this task type when you want workers to classify objects in a 3D point cloud by drawing 3D cuboids around objects. For example, you can use this task type to ask workers to identify different types of objects in a point cloud, such as cars, bikes, and pedestrians.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-3DPointCloudObjectDetection</code> </p> </li> </ul> <p> <b>3D Point Cloud Object Tracking</b> - Use this task type when you want workers to draw 3D cuboids around objects that appear in a sequence of 3D point cloud frames. For example, you can use this task type to ask workers to track the movement of vehicles across multiple point cloud frames. </p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-3DPointCloudObjectTracking</code> </p> </li> </ul> <p> <b>3D Point Cloud Semantic Segmentation</b> - Use this task type when you want workers to create a point-level semantic segmentation masks by painting objects in a 3D point cloud using different colors where each color is assigned to one of the classes you specify.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-3DPointCloudSemanticSegmentation</code> </p> </li> </ul> <p> <b>Use the following ARNs for Label Verification and Adjustment Jobs</b> </p> <p>Use label verification and adjustment jobs to review and adjust labels. To learn more, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-verification-data.html">Verify and Adjust Labels </a>.</p> <p> <b>Semantic Segmentation Adjustment</b> - Treats each pixel in an image as a multi-class classification and treats pixel adjusted annotations from workers as "votes" for the correct label.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-AdjustmentSemanticSegmentation</code> </p> </li> </ul> <p> <b>Semantic Segmentation Verification</b> - Uses a variant of the Expectation Maximization approach to estimate the true class of verification judgment for semantic segmentation labels based on annotations from individual workers.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-VerificationSemanticSegmentation</code> </p> </li> </ul> <p> <b>Bounding Box Adjustment</b> - Finds the most similar boxes from different workers based on the Jaccard index of the adjusted annotations.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-AdjustmentBoundingBox</code> </p> </li> </ul> <p> <b>Bounding Box Verification</b> - Uses a variant of the Expectation Maximization approach to estimate the true class of verification judgement for bounding box labels based on annotations from individual workers.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-VerificationBoundingBox</code> </p> </li> </ul> <p> <b>Video Frame Object Detection Adjustment</b> - Use this task type when you want workers to adjust bounding boxes that workers have added to video frames to classify and localize objects in a sequence of video frames.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-AdjustmentVideoObjectDetection</code> </p> </li> </ul> <p> <b>Video Frame Object Tracking Adjustment</b> - Use this task type when you want workers to adjust bounding boxes that workers have added to video frames to track object movement across a sequence of video frames.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-AdjustmentVideoObjectTracking</code> </p> </li> </ul> <p> <b>3D Point Cloud Object Detection Adjustment</b> - Use this task type when you want workers to adjust 3D cuboids around objects in a 3D point cloud. </p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-Adjustment3DPointCloudObjectDetection</code> </p> </li> </ul> <p> <b>3D Point Cloud Object Tracking Adjustment</b> - Use this task type when you want workers to adjust 3D cuboids around objects that appear in a sequence of 3D point cloud frames.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-Adjustment3DPointCloudObjectTracking</code> </p> </li> </ul> <p> <b>3D Point Cloud Semantic Segmentation Adjustment</b> - Use this task type when you want workers to adjust a point-level semantic segmentation masks using a paint tool.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> </ul>', 'HumanTaskConfig$PreHumanTaskLambdaArn' => '<p>The Amazon Resource Name (ARN) of a Lambda function that is run before a data object is sent to a human worker. Use this function to provide input to a custom labeling job.</p> <p>For <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html">built-in task types</a>, use one of the following Amazon SageMaker Ground Truth Lambda function ARNs for <code>PreHumanTaskLambdaArn</code>. For custom labeling workflows, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-custom-templates-step3.html#sms-custom-templates-step3-prelambda">Pre-annotation Lambda</a>. </p> <p> <b>Bounding box</b> - Finds the most similar boxes from different workers based on the Jaccard index of the boxes.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-BoundingBox</code> </p> </li> </ul> <p> <b>Image classification</b> - Uses a variant of the Expectation Maximization approach to estimate the true class of an image based on annotations from individual workers.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-ImageMultiClass</code> </p> </li> </ul> <p> <b>Multi-label image classification</b> - Uses a variant of the Expectation Maximization approach to estimate the true classes of an image based on annotations from individual workers.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-ImageMultiClassMultiLabel</code> </p> </li> </ul> <p> <b>Semantic segmentation</b> - Treats each pixel in an image as a multi-class classification and treats pixel annotations from workers as "votes" for the correct label.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-SemanticSegmentation</code> </p> </li> </ul> <p> <b>Text classification</b> - Uses a variant of the Expectation Maximization approach to estimate the true class of text based on annotations from individual workers.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-TextMultiClass</code> </p> </li> </ul> <p> <b>Multi-label text classification</b> - Uses a variant of the Expectation Maximization approach to estimate the true classes of text based on annotations from individual workers.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-TextMultiClassMultiLabel</code> </p> </li> </ul> <p> <b>Named entity recognition</b> - Groups similar selections and calculates aggregate boundaries, resolving to most-assigned label.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-NamedEntityRecognition</code> </p> </li> </ul> <p> <b>Video Classification</b> - Use this task type when you need workers to classify videos using predefined labels that you specify. Workers are shown videos and are asked to choose one label for each video.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-VideoMultiClass</code> </p> </li> </ul> <p> <b>Video Frame Object Detection</b> - Use this task type to have workers identify and locate objects in a sequence of video frames (images extracted from a video) using bounding boxes. For example, you can use this task to ask workers to identify and localize various objects in a series of video frames, such as cars, bikes, and pedestrians.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-VideoObjectDetection</code> </p> </li> </ul> <p> <b>Video Frame Object Tracking</b> - Use this task type to have workers track the movement of objects in a sequence of video frames (images extracted from a video) using bounding boxes. For example, you can use this task to ask workers to track the movement of objects, such as cars, bikes, and pedestrians. </p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-VideoObjectTracking</code> </p> </li> </ul> <p> <b>3D Point Cloud Modalities</b> </p> <p>Use the following pre-annotation lambdas for 3D point cloud labeling modality tasks. See <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-point-cloud-task-types.html">3D Point Cloud Task types </a> to learn more. </p> <p> <b>3D Point Cloud Object Detection</b> - Use this task type when you want workers to classify objects in a 3D point cloud by drawing 3D cuboids around objects. For example, you can use this task type to ask workers to identify different types of objects in a point cloud, such as cars, bikes, and pedestrians.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-3DPointCloudObjectDetection</code> </p> </li> </ul> <p> <b>3D Point Cloud Object Tracking</b> - Use this task type when you want workers to draw 3D cuboids around objects that appear in a sequence of 3D point cloud frames. For example, you can use this task type to ask workers to track the movement of vehicles across multiple point cloud frames. </p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-3DPointCloudObjectTracking</code> </p> </li> </ul> <p> <b>3D Point Cloud Semantic Segmentation</b> - Use this task type when you want workers to create a point-level semantic segmentation masks by painting objects in a 3D point cloud using different colors where each color is assigned to one of the classes you specify.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-3DPointCloudSemanticSegmentation</code> </p> </li> </ul> <p> <b>Use the following ARNs for Label Verification and Adjustment Jobs</b> </p> <p>Use label verification and adjustment jobs to review and adjust labels. To learn more, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-verification-data.html">Verify and Adjust Labels </a>.</p> <p> <b>Bounding box verification</b> - Uses a variant of the Expectation Maximization approach to estimate the true class of verification judgement for bounding box labels based on annotations from individual workers.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-VerificationBoundingBox</code> </p> </li> </ul> <p> <b>Bounding box adjustment</b> - Finds the most similar boxes from different workers based on the Jaccard index of the adjusted annotations.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-AdjustmentBoundingBox</code> </p> </li> </ul> <p> <b>Semantic segmentation verification</b> - Uses a variant of the Expectation Maximization approach to estimate the true class of verification judgment for semantic segmentation labels based on annotations from individual workers.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-VerificationSemanticSegmentation</code> </p> </li> </ul> <p> <b>Semantic segmentation adjustment</b> - Treats each pixel in an image as a multi-class classification and treats pixel adjusted annotations from workers as "votes" for the correct label.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-AdjustmentSemanticSegmentation</code> </p> </li> </ul> <p> <b>Video Frame Object Detection Adjustment</b> - Use this task type when you want workers to adjust bounding boxes that workers have added to video frames to classify and localize objects in a sequence of video frames.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-AdjustmentVideoObjectDetection</code> </p> </li> </ul> <p> <b>Video Frame Object Tracking Adjustment</b> - Use this task type when you want workers to adjust bounding boxes that workers have added to video frames to track object movement across a sequence of video frames.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-AdjustmentVideoObjectTracking</code> </p> </li> </ul> <p> <b>3D point cloud object detection adjustment</b> - Adjust 3D cuboids in a point cloud frame. </p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-Adjustment3DPointCloudObjectDetection</code> </p> </li> </ul> <p> <b>3D point cloud object tracking adjustment</b> - Adjust 3D cuboids across a sequence of point cloud frames. </p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-Adjustment3DPointCloudObjectTracking</code> </p> </li> </ul> <p> <b>3D point cloud semantic segmentation adjustment</b> - Adjust semantic segmentation masks in a 3D point cloud. </p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> </ul>', 'LabelingJobSummary$PreHumanTaskLambdaArn' => '<p>The Amazon Resource Name (ARN) of a Lambda function. The function is run before each data object is sent to a worker.</p>', 'LabelingJobSummary$AnnotationConsolidationLambdaArn' => '<p>The Amazon Resource Name (ARN) of the Lambda function used to consolidate the annotations from individual workers into a label for a data object. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-annotation-consolidation.html">Annotation Consolidation</a>.</p>', ], ], 'LambdaStepMetadata' => [ 'base' => '<p>Metadata for a Lambda step.</p>', 'refs' => [ 'PipelineExecutionStepMetadata$Lambda' => '<p>The Amazon Resource Name (ARN) of the Lambda function that was run by this step execution and a list of output parameters.</p>', ], ], 'LandingUri' => [ 'base' => NULL, 'refs' => [ 'CreatePresignedDomainUrlRequest$LandingUri' => '<p>The landing page that the user is directed to when accessing the presigned URL. Using this value, users can access Studio or Studio Classic, even if it is not the default experience for the domain. The supported values are:</p> <ul> <li> <p> <code>studio::relative/path</code>: Directs users to the relative path in Studio.</p> </li> <li> <p> <code>app:JupyterServer:relative/path</code>: Directs users to the relative path in the Studio Classic application.</p> </li> <li> <p> <code>app:JupyterLab:relative/path</code>: Directs users to the relative path in the JupyterLab application.</p> </li> <li> <p> <code>app:RStudioServerPro:relative/path</code>: Directs users to the relative path in the RStudio application.</p> </li> <li> <p> <code>app:CodeEditor:relative/path</code>: Directs users to the relative path in the Code Editor, based on Code-OSS, Visual Studio Code - Open Source application.</p> </li> <li> <p> <code>app:Canvas:relative/path</code>: Directs users to the relative path in the Canvas application.</p> </li> </ul>', 'UserSettings$DefaultLandingUri' => '<p>The default experience that the user is directed to when accessing the domain. The supported values are:</p> <ul> <li> <p> <code>studio::</code>: Indicates that Studio is the default experience. This value can only be passed if <code>StudioWebPortal</code> is set to <code>ENABLED</code>.</p> </li> <li> <p> <code>app:JupyterServer:</code>: Indicates that Studio Classic is the default experience.</p> </li> </ul>', ], ], 'LastModifiedTime' => [ 'base' => NULL, 'refs' => [ 'CodeRepositorySummary$LastModifiedTime' => '<p>The date and time that the Git repository was last modified.</p>', 'CompilationJobSummary$LastModifiedTime' => '<p>The time when the model compilation job was last modified.</p>', 'DescribeCodeRepositoryOutput$LastModifiedTime' => '<p>The date and time that the repository was last changed.</p>', 'DescribeCompilationJobResponse$LastModifiedTime' => '<p>The time that the status of the model compilation job was last modified.</p>', 'DescribeDomainResponse$LastModifiedTime' => '<p>The last modified time.</p>', 'DescribeFeatureGroupResponse$LastModifiedTime' => '<p>A timestamp indicating when the feature group was last updated.</p>', 'DescribeFeatureMetadataResponse$LastModifiedTime' => '<p>A timestamp indicating when the metadata for the feature group was modified. For example, if you add a parameter describing the feature, the timestamp changes to reflect the last time you </p>', 'DescribeInferenceRecommendationsJobResponse$LastModifiedTime' => '<p>A timestamp that shows when the job was last modified.</p>', 'DescribeNotebookInstanceLifecycleConfigOutput$LastModifiedTime' => '<p>A timestamp that tells when the lifecycle configuration was last modified.</p>', 'DescribeNotebookInstanceOutput$LastModifiedTime' => '<p>A timestamp. Use this parameter to retrieve the time when the notebook instance was last modified. </p>', 'DescribeOptimizationJobResponse$LastModifiedTime' => '<p>The time when the optimization job was last updated.</p>', 'DescribeSpaceResponse$LastModifiedTime' => '<p>The last modified time.</p>', 'DescribeUserProfileResponse$LastModifiedTime' => '<p>The last modified time.</p>', 'DomainDetails$LastModifiedTime' => '<p>The last modified time.</p>', 'FeatureGroup$LastModifiedTime' => '<p>A timestamp indicating the last time you updated the feature group.</p>', 'FeatureMetadata$LastModifiedTime' => '<p>A timestamp indicating when the feature was last modified.</p>', 'InferenceRecommendationsJob$LastModifiedTime' => '<p>A timestamp that shows when the job was last modified.</p>', 'ListCompilationJobsRequest$LastModifiedTimeAfter' => '<p>A filter that returns the model compilation jobs that were modified after a specified time.</p>', 'ListCompilationJobsRequest$LastModifiedTimeBefore' => '<p>A filter that returns the model compilation jobs that were modified before a specified time.</p>', 'ListInferenceRecommendationsJobsRequest$LastModifiedTimeAfter' => '<p>A filter that returns only jobs that were last modified after the specified time (timestamp).</p>', 'ListInferenceRecommendationsJobsRequest$LastModifiedTimeBefore' => '<p>A filter that returns only jobs that were last modified before the specified time (timestamp).</p>', 'ListNotebookInstanceLifecycleConfigsInput$LastModifiedTimeBefore' => '<p>A filter that returns only lifecycle configurations that were modified before the specified time (timestamp).</p>', 'ListNotebookInstanceLifecycleConfigsInput$LastModifiedTimeAfter' => '<p>A filter that returns only lifecycle configurations that were modified after the specified time (timestamp).</p>', 'ListNotebookInstancesInput$LastModifiedTimeBefore' => '<p>A filter that returns only notebook instances that were modified before the specified time (timestamp).</p>', 'ListNotebookInstancesInput$LastModifiedTimeAfter' => '<p>A filter that returns only notebook instances that were modified after the specified time (timestamp).</p>', 'ListOptimizationJobsRequest$LastModifiedTimeAfter' => '<p>Filters the results to only those optimization jobs that were updated after the specified time.</p>', 'ListOptimizationJobsRequest$LastModifiedTimeBefore' => '<p>Filters the results to only those optimization jobs that were updated before the specified time.</p>', 'NotebookInstanceLifecycleConfigSummary$LastModifiedTime' => '<p>A timestamp that tells when the lifecycle configuration was last modified.</p>', 'NotebookInstanceSummary$LastModifiedTime' => '<p>A timestamp that shows when the notebook instance was last modified.</p>', 'OptimizationJobSummary$LastModifiedTime' => '<p>The time when the optimization job was last updated.</p>', 'SpaceDetails$LastModifiedTime' => '<p>The last modified time.</p>', 'UserProfileDetails$LastModifiedTime' => '<p>The last modified time.</p>', ], ], 'LastUpdateStatus' => [ 'base' => '<p>A value that indicates whether the update was successful.</p>', 'refs' => [ 'DescribeFeatureGroupResponse$LastUpdateStatus' => '<p>A value indicating whether the update made to the feature group was successful.</p>', 'FeatureGroup$LastUpdateStatus' => '<p>A value that indicates whether the feature group was updated successfully.</p>', ], ], 'LastUpdateStatusValue' => [ 'base' => NULL, 'refs' => [ 'LastUpdateStatus$Status' => '<p>A value that indicates whether the update was made successful.</p>', ], ], 'LifecycleConfigArns' => [ 'base' => NULL, 'refs' => [ 'CodeEditorAppSettings$LifecycleConfigArns' => '<p>The Amazon Resource Name (ARN) of the Code Editor application lifecycle configuration.</p>', 'JupyterLabAppSettings$LifecycleConfigArns' => '<p>The Amazon Resource Name (ARN) of the lifecycle configurations attached to the user profile or domain. To remove a lifecycle config, you must set <code>LifecycleConfigArns</code> to an empty list.</p>', 'JupyterServerAppSettings$LifecycleConfigArns' => '<p> The Amazon Resource Name (ARN) of the Lifecycle Configurations attached to the JupyterServerApp. If you use this parameter, the <code>DefaultResourceSpec</code> parameter is also required.</p> <note> <p>To remove a Lifecycle Config, you must set <code>LifecycleConfigArns</code> to an empty list.</p> </note>', 'KernelGatewayAppSettings$LifecycleConfigArns' => '<p> The Amazon Resource Name (ARN) of the Lifecycle Configurations attached to the the user profile or domain.</p> <note> <p>To remove a Lifecycle Config, you must set <code>LifecycleConfigArns</code> to an empty list.</p> </note>', ], ], 'LineageEntityParameters' => [ 'base' => NULL, 'refs' => [ 'CreateActionRequest$Properties' => '<p>A list of properties to add to the action.</p>', 'CreateContextRequest$Properties' => '<p>A list of properties to add to the context.</p>', 'DescribeActionResponse$Properties' => '<p>A list of the action\'s properties.</p>', 'DescribeArtifactResponse$Properties' => '<p>A list of the artifact\'s properties.</p>', 'DescribeContextResponse$Properties' => '<p>A list of the context\'s properties.</p>', 'UpdateActionRequest$Properties' => '<p>The new list of properties. Overwrites the current property list.</p>', 'UpdateContextRequest$Properties' => '<p>The new list of properties. Overwrites the current property list.</p>', ], ], 'LineageGroupArn' => [ 'base' => NULL, 'refs' => [ 'DescribeActionResponse$LineageGroupArn' => '<p>The Amazon Resource Name (ARN) of the lineage group.</p>', 'DescribeArtifactResponse$LineageGroupArn' => '<p>The Amazon Resource Name (ARN) of the lineage group.</p>', 'DescribeContextResponse$LineageGroupArn' => '<p>The Amazon Resource Name (ARN) of the lineage group.</p>', 'DescribeLineageGroupResponse$LineageGroupArn' => '<p>The Amazon Resource Name (ARN) of the lineage group.</p>', 'DescribeTrialComponentResponse$LineageGroupArn' => '<p>The Amazon Resource Name (ARN) of the lineage group.</p>', 'GetLineageGroupPolicyResponse$LineageGroupArn' => '<p>The Amazon Resource Name (ARN) of the lineage group.</p>', 'LineageGroupSummary$LineageGroupArn' => '<p>The Amazon Resource Name (ARN) of the lineage group resource.</p>', 'TrialComponent$LineageGroupArn' => '<p>The Amazon Resource Name (ARN) of the lineage group resource.</p>', ], ], 'LineageGroupNameOrArn' => [ 'base' => NULL, 'refs' => [ 'GetLineageGroupPolicyRequest$LineageGroupName' => '<p>The name or Amazon Resource Name (ARN) of the lineage group.</p>', ], ], 'LineageGroupSummaries' => [ 'base' => NULL, 'refs' => [ 'ListLineageGroupsResponse$LineageGroupSummaries' => '<p>A list of lineage groups and their properties.</p>', ], ], 'LineageGroupSummary' => [ 'base' => '<p>Lists a summary of the properties of a lineage group. A lineage group provides a group of shareable lineage entity resources.</p>', 'refs' => [ 'LineageGroupSummaries$member' => NULL, ], ], 'LineageType' => [ 'base' => NULL, 'refs' => [ 'QueryLineageTypes$member' => NULL, 'Vertex$LineageType' => '<p>The type of resource of the lineage entity.</p>', ], ], 'ListActionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListActionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAlgorithmsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListAlgorithmsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListAliasesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAliasesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAppImageConfigsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAppImageConfigsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAppsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAppsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListArtifactsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListArtifactsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAssociationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAssociationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAutoMLJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAutoMLJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListCandidatesForAutoMLJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCandidatesForAutoMLJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListClusterNodesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListClusterNodesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListClustersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListClustersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListCodeRepositoriesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListCodeRepositoriesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListCompilationJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCompilationJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListCompilationJobsSortBy' => [ 'base' => NULL, 'refs' => [ 'ListCompilationJobsRequest$SortBy' => '<p>The field by which to sort results. The default is <code>CreationTime</code>.</p>', ], ], 'ListContextsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListContextsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDataQualityJobDefinitionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDataQualityJobDefinitionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDeviceFleetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDeviceFleetsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDeviceFleetsSortBy' => [ 'base' => NULL, 'refs' => [ 'ListDeviceFleetsRequest$SortBy' => '<p>The column to sort by.</p>', ], ], 'ListDevicesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDevicesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDomainsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDomainsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListEdgeDeploymentPlansRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListEdgeDeploymentPlansResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListEdgeDeploymentPlansSortBy' => [ 'base' => NULL, 'refs' => [ 'ListEdgeDeploymentPlansRequest$SortBy' => '<p>The column by which to sort the edge deployment plans. Can be one of <code>NAME</code>, <code>DEVICEFLEETNAME</code>, <code>CREATIONTIME</code>, <code>LASTMODIFIEDTIME</code>.</p>', ], ], 'ListEdgePackagingJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListEdgePackagingJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListEdgePackagingJobsSortBy' => [ 'base' => NULL, 'refs' => [ 'ListEdgePackagingJobsRequest$SortBy' => '<p>Use to specify what column to sort by.</p>', ], ], 'ListEndpointConfigsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListEndpointConfigsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListEndpointsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListEndpointsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListExperimentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListExperimentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFeatureGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFeatureGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFlowDefinitionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFlowDefinitionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListHubContentVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListHubContentVersionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListHubContentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListHubContentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListHubsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListHubsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListHumanTaskUisRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListHumanTaskUisResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListHyperParameterTuningJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListHyperParameterTuningJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListImageVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListImageVersionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListImagesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListImagesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListInferenceComponentsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListInferenceComponentsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListInferenceExperimentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListInferenceExperimentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListInferenceRecommendationsJobStepsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListInferenceRecommendationsJobStepsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListInferenceRecommendationsJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListInferenceRecommendationsJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListInferenceRecommendationsJobsSortBy' => [ 'base' => NULL, 'refs' => [ 'ListInferenceRecommendationsJobsRequest$SortBy' => '<p>The parameter by which to sort the results.</p>', ], ], 'ListLabelingJobsForWorkteamRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListLabelingJobsForWorkteamResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListLabelingJobsForWorkteamSortByOptions' => [ 'base' => NULL, 'refs' => [ 'ListLabelingJobsForWorkteamRequest$SortBy' => '<p>The field to sort results by. The default is <code>CreationTime</code>.</p>', ], ], 'ListLabelingJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListLabelingJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListLineageEntityParameterKey' => [ 'base' => NULL, 'refs' => [ 'UpdateActionRequest$PropertiesToRemove' => '<p>A list of properties to remove.</p>', 'UpdateArtifactRequest$PropertiesToRemove' => '<p>A list of properties to remove.</p>', 'UpdateContextRequest$PropertiesToRemove' => '<p>A list of properties to remove.</p>', ], ], 'ListLineageGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListLineageGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListDeviceFleetsRequest$MaxResults' => '<p>The maximum number of results to select.</p>', 'ListDevicesRequest$MaxResults' => '<p>Maximum number of results to select.</p>', 'ListEdgeDeploymentPlansRequest$MaxResults' => '<p>The maximum number of results to select (50 by default).</p>', 'ListEdgePackagingJobsRequest$MaxResults' => '<p>Maximum number of results to select.</p>', 'ListStageDevicesRequest$MaxResults' => '<p>The maximum number of requests to select.</p>', ], ], 'ListMlflowTrackingServersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListMlflowTrackingServersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListModelBiasJobDefinitionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListModelBiasJobDefinitionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListModelCardExportJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListModelCardExportJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListModelCardVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListModelCardVersionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListModelCardsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListModelCardsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListModelExplainabilityJobDefinitionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListModelExplainabilityJobDefinitionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListModelMetadataRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListModelMetadataResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListModelPackageGroupsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListModelPackageGroupsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListModelPackagesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListModelPackagesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListModelQualityJobDefinitionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListModelQualityJobDefinitionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListModelsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListModelsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListMonitoringAlertHistoryRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListMonitoringAlertHistoryResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListMonitoringAlertsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListMonitoringAlertsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListMonitoringExecutionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListMonitoringExecutionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListMonitoringSchedulesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListMonitoringSchedulesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListNotebookInstanceLifecycleConfigsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListNotebookInstanceLifecycleConfigsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListNotebookInstancesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListNotebookInstancesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListOptimizationJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListOptimizationJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListOptimizationJobsSortBy' => [ 'base' => NULL, 'refs' => [ 'ListOptimizationJobsRequest$SortBy' => '<p>The field by which to sort the optimization jobs in the response. The default is <code>CreationTime</code> </p>', ], ], 'ListPipelineExecutionStepsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPipelineExecutionStepsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPipelineExecutionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPipelineExecutionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPipelineParametersForExecutionRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPipelineParametersForExecutionResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPipelinesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPipelinesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListProcessingJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListProcessingJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListProjectsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListProjectsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListResourceCatalogsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListResourceCatalogsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSpacesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSpacesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListStageDevicesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListStageDevicesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListStudioLifecycleConfigsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListStudioLifecycleConfigsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSubscribedWorkteamsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSubscribedWorkteamsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListTagsInput$MaxResults' => '<p>Maximum number of tags to return.</p>', ], ], 'ListTagsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListTrainingJobsForHyperParameterTuningJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTrainingJobsForHyperParameterTuningJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTrainingJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTrainingJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTransformJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTransformJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTrialComponentKey256' => [ 'base' => NULL, 'refs' => [ 'UpdateTrialComponentRequest$ParametersToRemove' => '<p>The hyperparameters to remove from the component.</p>', 'UpdateTrialComponentRequest$InputArtifactsToRemove' => '<p>The input artifacts to remove from the component.</p>', 'UpdateTrialComponentRequest$OutputArtifactsToRemove' => '<p>The output artifacts to remove from the component.</p>', ], ], 'ListTrialComponentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTrialComponentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTrialsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTrialsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListUserProfilesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListUserProfilesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkforcesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkforcesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkforcesSortByOptions' => [ 'base' => NULL, 'refs' => [ 'ListWorkforcesRequest$SortBy' => '<p>Sort workforces using the workforce name or creation date.</p>', ], ], 'ListWorkteamsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkteamsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkteamsSortByOptions' => [ 'base' => NULL, 'refs' => [ 'ListWorkteamsRequest$SortBy' => '<p>The field to sort results by. The default is <code>CreationTime</code>.</p>', ], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'AgentVersion$AgentCount' => '<p>The number of Edge Manager agents.</p>', 'DeviceStats$ConnectedDeviceCount' => '<p>The number of devices connected with a heartbeat.</p>', 'DeviceStats$RegisteredDeviceCount' => '<p>The number of registered devices.</p>', 'EdgeModelStat$OfflineDeviceCount' => '<p>The number of devices that have this model version and do not have a heart beat.</p>', 'EdgeModelStat$ConnectedDeviceCount' => '<p>The number of devices that have this model version and have a heart beat. </p>', 'EdgeModelStat$ActiveDeviceCount' => '<p>The number of devices that have this model version, a heart beat, and are currently running.</p>', 'EdgeModelStat$SamplingDeviceCount' => '<p>The number of devices with this model version and are producing sample data.</p>', ], ], 'MLFramework' => [ 'base' => NULL, 'refs' => [ 'CreateImageVersionRequest$MLFramework' => '<p>The machine learning framework vended in the image version.</p>', 'DescribeImageVersionResponse$MLFramework' => '<p>The machine learning framework vended in the image version.</p>', 'UpdateImageVersionRequest$MLFramework' => '<p>The machine learning framework vended in the image version.</p>', ], ], 'ManagedInstanceScalingMaxInstanceCount' => [ 'base' => NULL, 'refs' => [ 'ProductionVariantManagedInstanceScaling$MaxInstanceCount' => '<p>The maximum number of instances that the endpoint can provision when it scales up to accommodate an increase in traffic.</p>', ], ], 'ManagedInstanceScalingMinInstanceCount' => [ 'base' => NULL, 'refs' => [ 'ProductionVariantManagedInstanceScaling$MinInstanceCount' => '<p>The minimum number of instances that the endpoint must retain when it scales down to accommodate a decrease in traffic.</p>', ], ], 'ManagedInstanceScalingStatus' => [ 'base' => NULL, 'refs' => [ 'ProductionVariantManagedInstanceScaling$Status' => '<p>Indicates whether managed instance scaling is enabled.</p>', ], ], 'MaxAutoMLJobRuntimeInSeconds' => [ 'base' => NULL, 'refs' => [ 'AutoMLJobCompletionCriteria$MaxAutoMLJobRuntimeInSeconds' => '<p>The maximum runtime, in seconds, an AutoML job has to complete.</p> <p>If an AutoML job exceeds the maximum runtime, the job is stopped automatically and its processing is ended gracefully. The AutoML job identifies the best model whose training was completed and marks it as the best-performing model. Any unfinished steps of the job, such as automatic one-click Autopilot model deployment, are not completed.</p>', ], ], 'MaxCandidates' => [ 'base' => NULL, 'refs' => [ 'AutoMLJobCompletionCriteria$MaxCandidates' => '<p>The maximum number of times a training job is allowed to run.</p> <p>For text and image classification, time-series forecasting, as well as text generation (LLMs fine-tuning) problem types, the supported value is 1. For tabular problem types, the maximum value is 750.</p>', ], ], 'MaxConcurrentInvocationsPerInstance' => [ 'base' => NULL, 'refs' => [ 'AsyncInferenceClientConfig$MaxConcurrentInvocationsPerInstance' => '<p>The maximum number of concurrent requests sent by the SageMaker client to the model container. If no value is provided, SageMaker chooses an optimal value.</p>', ], ], 'MaxConcurrentTaskCount' => [ 'base' => NULL, 'refs' => [ 'HumanTaskConfig$MaxConcurrentTaskCount' => '<p>Defines the maximum number of data objects that can be labeled by human workers at the same time. Also referred to as batch size. Each object may have more than one worker at one time. The default value is 1000 objects. To increase the maximum value to 5000 objects, contact Amazon Web Services Support.</p>', ], ], 'MaxConcurrentTransforms' => [ 'base' => NULL, 'refs' => [ 'CreateTransformJobRequest$MaxConcurrentTransforms' => '<p>The maximum number of parallel requests that can be sent to each instance in a transform job. If <code>MaxConcurrentTransforms</code> is set to <code>0</code> or left unset, Amazon SageMaker checks the optional execution-parameters to determine the settings for your chosen algorithm. If the execution-parameters endpoint is not enabled, the default value is <code>1</code>. For more information on execution-parameters, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-batch-code.html#your-algorithms-batch-code-how-containe-serves-requests">How Containers Serve Requests</a>. For built-in algorithms, you don\'t need to set a value for <code>MaxConcurrentTransforms</code>.</p>', 'DescribeTransformJobResponse$MaxConcurrentTransforms' => '<p>The maximum number of parallel requests on each instance node that can be launched in a transform job. The default value is 1.</p>', 'TransformJob$MaxConcurrentTransforms' => '<p>The maximum number of parallel requests that can be sent to each instance in a transform job. If <code>MaxConcurrentTransforms</code> is set to 0 or left unset, SageMaker checks the optional execution-parameters to determine the settings for your chosen algorithm. If the execution-parameters endpoint is not enabled, the default value is 1. For built-in algorithms, you don\'t need to set a value for <code>MaxConcurrentTransforms</code>.</p>', 'TransformJobDefinition$MaxConcurrentTransforms' => '<p>The maximum number of parallel requests that can be sent to each instance in a transform job. The default value is 1.</p>', ], ], 'MaxHumanLabeledObjectCount' => [ 'base' => NULL, 'refs' => [ 'LabelingJobStoppingConditions$MaxHumanLabeledObjectCount' => '<p>The maximum number of objects that can be labeled by human workers.</p>', ], ], 'MaxNumberOfTests' => [ 'base' => NULL, 'refs' => [ 'RecommendationJobResourceLimit$MaxNumberOfTests' => '<p>Defines the maximum number of load tests.</p>', ], ], 'MaxNumberOfTrainingJobs' => [ 'base' => NULL, 'refs' => [ 'ResourceLimits$MaxNumberOfTrainingJobs' => '<p>The maximum number of training jobs that a hyperparameter tuning job can launch.</p>', ], ], 'MaxNumberOfTrainingJobsNotImproving' => [ 'base' => NULL, 'refs' => [ 'BestObjectiveNotImproving$MaxNumberOfTrainingJobsNotImproving' => '<p>The number of training jobs that have failed to improve model performance by 1% or greater over prior training jobs as evaluated against an objective function.</p>', ], ], 'MaxParallelExecutionSteps' => [ 'base' => NULL, 'refs' => [ 'ParallelismConfiguration$MaxParallelExecutionSteps' => '<p>The max number of steps that can be executed in parallel. </p>', ], ], 'MaxParallelOfTests' => [ 'base' => NULL, 'refs' => [ 'RecommendationJobResourceLimit$MaxParallelOfTests' => '<p>Defines the maximum number of parallel load tests.</p>', ], ], 'MaxParallelTrainingJobs' => [ 'base' => NULL, 'refs' => [ 'ResourceLimits$MaxParallelTrainingJobs' => '<p>The maximum number of concurrent training jobs that a hyperparameter tuning job can launch.</p>', ], ], 'MaxPayloadInMB' => [ 'base' => NULL, 'refs' => [ 'CreateTransformJobRequest$MaxPayloadInMB' => '<p>The maximum allowed size of the payload, in MB. A <i>payload</i> is the data portion of a record (without metadata). The value in <code>MaxPayloadInMB</code> must be greater than, or equal to, the size of a single record. To estimate the size of a record in MB, divide the size of your dataset by the number of records. To ensure that the records fit within the maximum payload size, we recommend using a slightly larger value. The default value is <code>6</code> MB. </p> <p>The value of <code>MaxPayloadInMB</code> cannot be greater than 100 MB. If you specify the <code>MaxConcurrentTransforms</code> parameter, the value of <code>(MaxConcurrentTransforms * MaxPayloadInMB)</code> also cannot exceed 100 MB.</p> <p>For cases where the payload might be arbitrarily large and is transmitted using HTTP chunked encoding, set the value to <code>0</code>. This feature works only in supported algorithms. Currently, Amazon SageMaker built-in algorithms do not support HTTP chunked encoding.</p>', 'DescribeTransformJobResponse$MaxPayloadInMB' => '<p>The maximum payload size, in MB, used in the transform job.</p>', 'TransformJob$MaxPayloadInMB' => '<p>The maximum allowed size of the payload, in MB. A payload is the data portion of a record (without metadata). The value in <code>MaxPayloadInMB</code> must be greater than, or equal to, the size of a single record. To estimate the size of a record in MB, divide the size of your dataset by the number of records. To ensure that the records fit within the maximum payload size, we recommend using a slightly larger value. The default value is 6 MB. For cases where the payload might be arbitrarily large and is transmitted using HTTP chunked encoding, set the value to 0. This feature works only in supported algorithms. Currently, SageMaker built-in algorithms do not support HTTP chunked encoding.</p>', 'TransformJobDefinition$MaxPayloadInMB' => '<p>The maximum payload size allowed, in MB. A payload is the data portion of a record (without metadata).</p>', ], ], 'MaxPendingTimeInSeconds' => [ 'base' => 'Maximum job scheduler pending time in seconds.', 'refs' => [ 'StoppingCondition$MaxPendingTimeInSeconds' => '<p>The maximum length of time, in seconds, that a training or compilation job can be pending before it is stopped.</p>', ], ], 'MaxPercentageOfInputDatasetLabeled' => [ 'base' => NULL, 'refs' => [ 'LabelingJobStoppingConditions$MaxPercentageOfInputDatasetLabeled' => '<p>The maximum number of input data objects that should be labeled.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListActionsRequest$MaxResults' => '<p>The maximum number of actions to return in the response. The default value is 10.</p>', 'ListAlgorithmsInput$MaxResults' => '<p>The maximum number of algorithms to return in the response.</p>', 'ListAliasesRequest$MaxResults' => '<p>The maximum number of aliases to return.</p>', 'ListAppImageConfigsRequest$MaxResults' => '<p>The total number of items to return in the response. If the total number of items available is more than the value specified, a <code>NextToken</code> is provided in the response. To resume pagination, provide the <code>NextToken</code> value in the as part of a subsequent call. The default value is 10.</p>', 'ListAppsRequest$MaxResults' => '<p>This parameter defines the maximum number of results that can be return in a single response. The <code>MaxResults</code> parameter is an upper bound, not a target. If there are more results available than the value specified, a <code>NextToken</code> is provided in the response. The <code>NextToken</code> indicates that the user should get the next set of results by providing this token as a part of a subsequent call. The default value for <code>MaxResults</code> is 10.</p>', 'ListArtifactsRequest$MaxResults' => '<p>The maximum number of artifacts to return in the response. The default value is 10.</p>', 'ListAssociationsRequest$MaxResults' => '<p>The maximum number of associations to return in the response. The default value is 10.</p>', 'ListClusterNodesRequest$MaxResults' => '<p>The maximum number of nodes to return in the response.</p>', 'ListClustersRequest$MaxResults' => '<p>Set the maximum number of SageMaker HyperPod clusters to list.</p>', 'ListCodeRepositoriesInput$MaxResults' => '<p>The maximum number of Git repositories to return in the response.</p>', 'ListCompilationJobsRequest$MaxResults' => '<p>The maximum number of model compilation jobs to return in the response.</p>', 'ListContextsRequest$MaxResults' => '<p>The maximum number of contexts to return in the response. The default value is 10.</p>', 'ListDataQualityJobDefinitionsRequest$MaxResults' => '<p>The maximum number of data quality monitoring job definitions to return in the response.</p>', 'ListDomainsRequest$MaxResults' => '<p>This parameter defines the maximum number of results that can be return in a single response. The <code>MaxResults</code> parameter is an upper bound, not a target. If there are more results available than the value specified, a <code>NextToken</code> is provided in the response. The <code>NextToken</code> indicates that the user should get the next set of results by providing this token as a part of a subsequent call. The default value for <code>MaxResults</code> is 10.</p>', 'ListEndpointConfigsInput$MaxResults' => '<p>The maximum number of training jobs to return in the response.</p>', 'ListEndpointsInput$MaxResults' => '<p>The maximum number of endpoints to return in the response. This value defaults to 10.</p>', 'ListExperimentsRequest$MaxResults' => '<p>The maximum number of experiments to return in the response. The default value is 10.</p>', 'ListFlowDefinitionsRequest$MaxResults' => '<p>The total number of items to return. If the total number of available items is more than the value specified in <code>MaxResults</code>, then a <code>NextToken</code> will be provided in the output that you can use to resume pagination.</p>', 'ListHubContentVersionsRequest$MaxResults' => '<p>The maximum number of hub content versions to list.</p>', 'ListHubContentsRequest$MaxResults' => '<p>The maximum amount of hub content to list.</p>', 'ListHubsRequest$MaxResults' => '<p>The maximum number of hubs to list.</p>', 'ListHumanTaskUisRequest$MaxResults' => '<p>The total number of items to return. If the total number of available items is more than the value specified in <code>MaxResults</code>, then a <code>NextToken</code> will be provided in the output that you can use to resume pagination.</p>', 'ListHyperParameterTuningJobsRequest$MaxResults' => '<p>The maximum number of tuning jobs to return. The default value is 10.</p>', 'ListImageVersionsRequest$MaxResults' => '<p>The maximum number of versions to return in the response. The default value is 10. </p>', 'ListImagesRequest$MaxResults' => '<p>The maximum number of images to return in the response. The default value is 10. </p>', 'ListInferenceComponentsInput$MaxResults' => '<p>The maximum number of inference components to return in the response. This value defaults to 10.</p>', 'ListInferenceExperimentsRequest$MaxResults' => '<p>The maximum number of results to select.</p>', 'ListInferenceRecommendationsJobStepsRequest$MaxResults' => '<p>The maximum number of results to return.</p>', 'ListInferenceRecommendationsJobsRequest$MaxResults' => '<p>The maximum number of recommendations to return in the response.</p>', 'ListLabelingJobsForWorkteamRequest$MaxResults' => '<p>The maximum number of labeling jobs to return in each page of the response.</p>', 'ListLabelingJobsRequest$MaxResults' => '<p>The maximum number of labeling jobs to return in each page of the response.</p>', 'ListLineageGroupsRequest$MaxResults' => '<p>The maximum number of endpoints to return in the response. This value defaults to 10.</p>', 'ListMlflowTrackingServersRequest$MaxResults' => '<p>The maximum number of tracking servers to list.</p>', 'ListModelBiasJobDefinitionsRequest$MaxResults' => '<p>The maximum number of model bias jobs to return in the response. The default value is 10.</p>', 'ListModelCardExportJobsRequest$MaxResults' => '<p>The maximum number of model card export jobs to list.</p>', 'ListModelCardVersionsRequest$MaxResults' => '<p>The maximum number of model card versions to list.</p>', 'ListModelCardsRequest$MaxResults' => '<p>The maximum number of model cards to list.</p>', 'ListModelExplainabilityJobDefinitionsRequest$MaxResults' => '<p>The maximum number of jobs to return in the response. The default value is 10.</p>', 'ListModelMetadataRequest$MaxResults' => '<p>The maximum number of models to return in the response.</p>', 'ListModelPackageGroupsInput$MaxResults' => '<p>The maximum number of results to return in the response.</p>', 'ListModelPackagesInput$MaxResults' => '<p>The maximum number of model packages to return in the response.</p>', 'ListModelQualityJobDefinitionsRequest$MaxResults' => '<p>The maximum number of results to return in a call to <code>ListModelQualityJobDefinitions</code>.</p>', 'ListModelsInput$MaxResults' => '<p>The maximum number of models to return in the response.</p>', 'ListMonitoringAlertHistoryRequest$MaxResults' => '<p>The maximum number of results to display. The default is 100.</p>', 'ListMonitoringAlertsRequest$MaxResults' => '<p>The maximum number of results to display. The default is 100.</p>', 'ListMonitoringExecutionsRequest$MaxResults' => '<p>The maximum number of jobs to return in the response. The default value is 10.</p>', 'ListMonitoringSchedulesRequest$MaxResults' => '<p>The maximum number of jobs to return in the response. The default value is 10.</p>', 'ListNotebookInstanceLifecycleConfigsInput$MaxResults' => '<p>The maximum number of lifecycle configurations to return in the response.</p>', 'ListNotebookInstancesInput$MaxResults' => '<p>The maximum number of notebook instances to return.</p>', 'ListOptimizationJobsRequest$MaxResults' => '<p>The maximum number of optimization jobs to return in the response. The default is 50.</p>', 'ListPipelineExecutionStepsRequest$MaxResults' => '<p>The maximum number of pipeline execution steps to return in the response.</p>', 'ListPipelineExecutionsRequest$MaxResults' => '<p>The maximum number of pipeline executions to return in the response.</p>', 'ListPipelineParametersForExecutionRequest$MaxResults' => '<p>The maximum number of parameters to return in the response.</p>', 'ListPipelinesRequest$MaxResults' => '<p>The maximum number of pipelines to return in the response.</p>', 'ListProcessingJobsRequest$MaxResults' => '<p>The maximum number of processing jobs to return in the response.</p>', 'ListProjectsInput$MaxResults' => '<p>The maximum number of projects to return in the response.</p>', 'ListResourceCatalogsRequest$MaxResults' => '<p> The maximum number of results returned by <code>ListResourceCatalogs</code>. </p>', 'ListSpacesRequest$MaxResults' => '<p>This parameter defines the maximum number of results that can be return in a single response. The <code>MaxResults</code> parameter is an upper bound, not a target. If there are more results available than the value specified, a <code>NextToken</code> is provided in the response. The <code>NextToken</code> indicates that the user should get the next set of results by providing this token as a part of a subsequent call. The default value for <code>MaxResults</code> is 10.</p>', 'ListStudioLifecycleConfigsRequest$MaxResults' => '<p>The total number of items to return in the response. If the total number of items available is more than the value specified, a <code>NextToken</code> is provided in the response. To resume pagination, provide the <code>NextToken</code> value in the as part of a subsequent call. The default value is 10.</p>', 'ListSubscribedWorkteamsRequest$MaxResults' => '<p>The maximum number of work teams to return in each page of the response.</p>', 'ListTrainingJobsForHyperParameterTuningJobRequest$MaxResults' => '<p>The maximum number of training jobs to return. The default value is 10.</p>', 'ListTrainingJobsRequest$MaxResults' => '<p>The maximum number of training jobs to return in the response.</p>', 'ListTransformJobsRequest$MaxResults' => '<p>The maximum number of transform jobs to return in the response. The default value is <code>10</code>.</p>', 'ListTrialComponentsRequest$MaxResults' => '<p>The maximum number of components to return in the response. The default value is 10.</p>', 'ListTrialsRequest$MaxResults' => '<p>The maximum number of trials to return in the response. The default value is 10.</p>', 'ListUserProfilesRequest$MaxResults' => '<p>This parameter defines the maximum number of results that can be return in a single response. The <code>MaxResults</code> parameter is an upper bound, not a target. If there are more results available than the value specified, a <code>NextToken</code> is provided in the response. The <code>NextToken</code> indicates that the user should get the next set of results by providing this token as a part of a subsequent call. The default value for <code>MaxResults</code> is 10.</p>', 'ListWorkforcesRequest$MaxResults' => '<p>The maximum number of workforces returned in the response.</p>', 'ListWorkteamsRequest$MaxResults' => '<p>The maximum number of work teams to return in each page of the response.</p>', 'SearchRequest$MaxResults' => '<p>The maximum number of results to return.</p>', ], ], 'MaxRuntimeInSeconds' => [ 'base' => NULL, 'refs' => [ 'StoppingCondition$MaxRuntimeInSeconds' => '<p>The maximum length of time, in seconds, that a training or compilation job can run before it is stopped.</p> <p>For compilation jobs, if the job does not complete during this time, a <code>TimeOut</code> error is generated. We recommend starting with 900 seconds and increasing as necessary based on your model.</p> <p>For all other jobs, if the job does not complete during this time, SageMaker ends the job. When <code>RetryStrategy</code> is specified in the job request, <code>MaxRuntimeInSeconds</code> specifies the maximum time for all of the attempts in total, not each individual attempt. The default value is 1 day. The maximum value is 28 days.</p> <p>The maximum time that a <code>TrainingJob</code> can run in total, including any time spent publishing metrics or archiving and uploading models after it has been stopped, is 30 days.</p>', ], ], 'MaxRuntimePerTrainingJobInSeconds' => [ 'base' => NULL, 'refs' => [ 'AutoMLJobCompletionCriteria$MaxRuntimePerTrainingJobInSeconds' => '<p>The maximum time, in seconds, that each training job executed inside hyperparameter tuning is allowed to run as part of a hyperparameter tuning job. For more information, see the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StoppingCondition.html">StoppingCondition</a> used by the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateHyperParameterTuningJob.html">CreateHyperParameterTuningJob</a> action.</p> <p>For job V2s (jobs created by calling <code>CreateAutoMLJobV2</code>), this field controls the runtime of the job candidate.</p> <p>For <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_TextClassificationJobConfig.html">TextGenerationJobConfig</a> problem types, the maximum time defaults to 72 hours (259200 seconds).</p>', ], ], 'MaxWaitTimeInSeconds' => [ 'base' => NULL, 'refs' => [ 'StoppingCondition$MaxWaitTimeInSeconds' => '<p>The maximum length of time, in seconds, that a managed Spot training job has to complete. It is the amount of time spent waiting for Spot capacity plus the amount of time the job can run. It must be equal to or greater than <code>MaxRuntimeInSeconds</code>. If the job does not complete during this time, SageMaker ends the job.</p> <p>When <code>RetryStrategy</code> is specified in the job request, <code>MaxWaitTimeInSeconds</code> specifies the maximum time for all of the attempts in total, not each individual attempt.</p>', ], ], 'MaximumExecutionTimeoutInSeconds' => [ 'base' => NULL, 'refs' => [ 'BlueGreenUpdatePolicy$MaximumExecutionTimeoutInSeconds' => '<p>Maximum execution timeout for the deployment. Note that the timeout value should be larger than the total waiting time specified in <code>TerminationWaitInSeconds</code> and <code>WaitIntervalInSeconds</code>.</p>', 'RollingUpdatePolicy$MaximumExecutionTimeoutInSeconds' => '<p>The time limit for the total deployment. Exceeding this limit causes a timeout.</p>', ], ], 'MaximumRetryAttempts' => [ 'base' => NULL, 'refs' => [ 'RetryStrategy$MaximumRetryAttempts' => '<p>The number of times to retry the job. When the job is retried, it\'s <code>SecondaryStatus</code> is changed to <code>STARTING</code>.</p>', ], ], 'MediaType' => [ 'base' => NULL, 'refs' => [ 'TrialComponentArtifact$MediaType' => '<p>The media type of the artifact, which indicates the type of data in the artifact file. The media type consists of a <i>type</i> and a <i>subtype</i> concatenated with a slash (/) character, for example, text/csv, image/jpeg, and s3/uri. The type specifies the category of the media. The subtype specifies the kind of data.</p>', ], ], 'MemberDefinition' => [ 'base' => '<p>Defines an Amazon Cognito or your own OIDC IdP user group that is part of a work team.</p>', 'refs' => [ 'MemberDefinitions$member' => NULL, ], ], 'MemberDefinitions' => [ 'base' => NULL, 'refs' => [ 'CreateWorkteamRequest$MemberDefinitions' => '<p>A list of <code>MemberDefinition</code> objects that contains objects that identify the workers that make up the work team. </p> <p>Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP). For private workforces created using Amazon Cognito use <code>CognitoMemberDefinition</code>. For workforces created using your own OIDC identity provider (IdP) use <code>OidcMemberDefinition</code>. Do not provide input for both of these parameters in a single request.</p> <p>For workforces created using Amazon Cognito, private work teams correspond to Amazon Cognito <i>user groups</i> within the user pool used to create a workforce. All of the <code>CognitoMemberDefinition</code> objects that make up the member definition must have the same <code>ClientId</code> and <code>UserPool</code> values. To add a Amazon Cognito user group to an existing worker pool, see <a href="">Adding groups to a User Pool</a>. For more information about user pools, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html">Amazon Cognito User Pools</a>.</p> <p>For workforces created using your own OIDC IdP, specify the user groups that you want to include in your private work team in <code>OidcMemberDefinition</code> by listing those groups in <code>Groups</code>.</p>', 'UpdateWorkteamRequest$MemberDefinitions' => '<p>A list of <code>MemberDefinition</code> objects that contains objects that identify the workers that make up the work team. </p> <p>Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP). For private workforces created using Amazon Cognito use <code>CognitoMemberDefinition</code>. For workforces created using your own OIDC identity provider (IdP) use <code>OidcMemberDefinition</code>. You should not provide input for both of these parameters in a single request.</p> <p>For workforces created using Amazon Cognito, private work teams correspond to Amazon Cognito <i>user groups</i> within the user pool used to create a workforce. All of the <code>CognitoMemberDefinition</code> objects that make up the member definition must have the same <code>ClientId</code> and <code>UserPool</code> values. To add a Amazon Cognito user group to an existing worker pool, see <a href="">Adding groups to a User Pool</a>. For more information about user pools, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html">Amazon Cognito User Pools</a>.</p> <p>For workforces created using your own OIDC IdP, specify the user groups that you want to include in your private work team in <code>OidcMemberDefinition</code> by listing those groups in <code>Groups</code>. Be aware that user groups that are already in the work team must also be listed in <code>Groups</code> when you make this request to remain on the work team. If you do not include these user groups, they will no longer be associated with the work team you update. </p>', 'Workteam$MemberDefinitions' => '<p>A list of <code>MemberDefinition</code> objects that contains objects that identify the workers that make up the work team. </p> <p>Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP). For private workforces created using Amazon Cognito use <code>CognitoMemberDefinition</code>. For workforces created using your own OIDC identity provider (IdP) use <code>OidcMemberDefinition</code>.</p>', ], ], 'MemoryInMb' => [ 'base' => NULL, 'refs' => [ 'InferenceComponentComputeResourceRequirements$MinMemoryRequiredInMb' => '<p>The minimum MB of memory to allocate to run a model that you assign to an inference component.</p>', 'InferenceComponentComputeResourceRequirements$MaxMemoryRequiredInMb' => '<p>The maximum MB of memory to allocate to run a model that you assign to an inference component.</p>', ], ], 'MetadataProperties' => [ 'base' => '<p>Metadata properties of the tracking entity, trial, or trial component.</p>', 'refs' => [ 'CreateActionRequest$MetadataProperties' => NULL, 'CreateArtifactRequest$MetadataProperties' => NULL, 'CreateModelPackageInput$MetadataProperties' => NULL, 'CreateTrialComponentRequest$MetadataProperties' => NULL, 'CreateTrialRequest$MetadataProperties' => NULL, 'DescribeActionResponse$MetadataProperties' => NULL, 'DescribeArtifactResponse$MetadataProperties' => NULL, 'DescribeModelPackageOutput$MetadataProperties' => NULL, 'DescribeTrialComponentResponse$MetadataProperties' => NULL, 'DescribeTrialResponse$MetadataProperties' => NULL, 'ModelPackage$MetadataProperties' => '<p>Metadata properties of the tracking entity, trial, or trial component.</p>', 'Trial$MetadataProperties' => NULL, 'TrialComponent$MetadataProperties' => NULL, ], ], 'MetadataPropertyValue' => [ 'base' => NULL, 'refs' => [ 'MetadataProperties$CommitId' => '<p>The commit ID.</p>', 'MetadataProperties$Repository' => '<p>The repository.</p>', 'MetadataProperties$GeneratedBy' => '<p>The entity this entity was generated by.</p>', 'MetadataProperties$ProjectId' => '<p>The project ID.</p>', ], ], 'MetricData' => [ 'base' => '<p>The name, value, and date and time of a metric that was emitted to Amazon CloudWatch.</p>', 'refs' => [ 'FinalMetricDataList$member' => NULL, ], ], 'MetricDataList' => [ 'base' => NULL, 'refs' => [ 'CandidateProperties$CandidateMetrics' => '<p>Information about the candidate metrics for an AutoML job.</p>', ], ], 'MetricDatum' => [ 'base' => '<p>Information about the metric for a candidate produced by an AutoML job.</p>', 'refs' => [ 'MetricDataList$member' => NULL, ], ], 'MetricDefinition' => [ 'base' => '<p>Specifies a metric that the training algorithm writes to <code>stderr</code> or <code>stdout</code>. You can view these logs to understand how your training job performs and check for any errors encountered during training. SageMaker hyperparameter tuning captures all defined metrics. Specify one of the defined metrics to use as an objective metric using the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTrainingJobDefinition.html#sagemaker-Type-HyperParameterTrainingJobDefinition-TuningObjective">TuningObjective</a> parameter in the <code>HyperParameterTrainingJobDefinition</code> API to evaluate job performance during hyperparameter tuning.</p>', 'refs' => [ 'MetricDefinitionList$member' => NULL, ], ], 'MetricDefinitionList' => [ 'base' => NULL, 'refs' => [ 'AlgorithmSpecification$MetricDefinitions' => '<p>A list of metric definition objects. Each object specifies the metric name and regular expressions used to parse algorithm logs. SageMaker publishes each metric to Amazon CloudWatch.</p>', 'HyperParameterAlgorithmSpecification$MetricDefinitions' => '<p>An array of <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_MetricDefinition.html">MetricDefinition</a> objects that specify the metrics that the algorithm emits.</p>', 'TrainingSpecification$MetricDefinitions' => '<p>A list of <code>MetricDefinition</code> objects, which are used for parsing metrics generated by the algorithm.</p>', ], ], 'MetricName' => [ 'base' => NULL, 'refs' => [ 'FinalHyperParameterTuningJobObjectiveMetric$MetricName' => '<p>The name of the objective metric. For SageMaker built-in algorithms, metrics are defined per algorithm. See the <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/xgboost-tuning.html">metrics for XGBoost</a> as an example. You can also use a custom algorithm for training and define your own metrics. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-metrics-variables.html">Define metrics and environment variables</a>.</p>', 'HyperParameterTuningJobObjective$MetricName' => '<p>The name of the metric to use for the objective metric.</p>', 'MetricData$MetricName' => '<p>The name of the metric.</p>', 'MetricDefinition$Name' => '<p>The name of the metric.</p>', 'TrialComponentMetricSummary$MetricName' => '<p>The name of the metric.</p>', ], ], 'MetricRegex' => [ 'base' => NULL, 'refs' => [ 'MetricDefinition$Regex' => '<p>A regular expression that searches the output of a training job and gets the value of the metric. For more information about using regular expressions to define metrics, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-metrics-variables.html">Defining metrics and environment variables</a>.</p>', ], ], 'MetricSetSource' => [ 'base' => NULL, 'refs' => [ 'MetricDatum$Set' => '<p>The dataset split from which the AutoML job produced the metric.</p>', ], ], 'MetricSpecification' => [ 'base' => '<p>An object containing information about a metric.</p>', 'refs' => [ 'TargetTrackingScalingPolicyConfiguration$MetricSpecification' => '<p>An object containing information about a metric.</p>', ], ], 'MetricValue' => [ 'base' => NULL, 'refs' => [ 'FinalAutoMLJobObjectiveMetric$Value' => '<p>The value of the metric with the best result.</p>', 'FinalHyperParameterTuningJobObjectiveMetric$Value' => '<p>The value of the objective metric.</p>', ], ], 'MetricsSource' => [ 'base' => '<p>Details about the metrics source.</p>', 'refs' => [ 'Bias$Report' => '<p>The bias report for a model</p>', 'Bias$PreTrainingReport' => '<p>The pre-training bias report for a model.</p>', 'Bias$PostTrainingReport' => '<p>The post-training bias report for a model.</p>', 'DriftCheckBias$PreTrainingConstraints' => '<p>The pre-training constraints.</p>', 'DriftCheckBias$PostTrainingConstraints' => '<p>The post-training constraints.</p>', 'DriftCheckExplainability$Constraints' => '<p>The drift check explainability constraints.</p>', 'DriftCheckModelDataQuality$Statistics' => '<p>The drift check model data quality statistics.</p>', 'DriftCheckModelDataQuality$Constraints' => '<p>The drift check model data quality constraints.</p>', 'DriftCheckModelQuality$Statistics' => '<p>The drift check model quality statistics.</p>', 'DriftCheckModelQuality$Constraints' => '<p>The drift check model quality constraints.</p>', 'Explainability$Report' => '<p>The explainability report for a model.</p>', 'ModelDataQuality$Statistics' => '<p>Data quality statistics for a model.</p>', 'ModelDataQuality$Constraints' => '<p>Data quality constraints for a model.</p>', 'ModelQuality$Statistics' => '<p>Model quality statistics.</p>', 'ModelQuality$Constraints' => '<p>Model quality constraints.</p>', ], ], 'MinimumInstanceMetadataServiceVersion' => [ 'base' => NULL, 'refs' => [ 'InstanceMetadataServiceConfiguration$MinimumInstanceMetadataServiceVersion' => '<p>Indicates the minimum IMDS version that the notebook instance supports. When passed as part of <code>CreateNotebookInstance</code>, if no value is selected, then it defaults to IMDSv1. This means that both IMDSv1 and IMDSv2 are supported. If passed as part of <code>UpdateNotebookInstance</code>, there is no default.</p>', ], ], 'MlTools' => [ 'base' => NULL, 'refs' => [ 'HiddenMlToolsList$member' => NULL, ], ], 'MlflowVersion' => [ 'base' => NULL, 'refs' => [ 'CreateMlflowTrackingServerRequest$MlflowVersion' => '<p>The version of MLflow that the tracking server uses. To see which MLflow versions are available to use, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/mlflow.html#mlflow-create-tracking-server-how-it-works">How it works</a>.</p>', 'DescribeMlflowTrackingServerResponse$MlflowVersion' => '<p>The MLflow version used for the described tracking server.</p>', 'ListMlflowTrackingServersRequest$MlflowVersion' => '<p>Filter for tracking servers using the specified MLflow version.</p>', 'TrackingServerSummary$MlflowVersion' => '<p>The MLflow version used for a listed tracking server.</p>', ], ], 'Model' => [ 'base' => '<p>The properties of a model as returned by the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html">Search</a> API.</p>', 'refs' => [ 'ModelDashboardModel$Model' => '<p>A model displayed in the Model Dashboard.</p>', ], ], 'ModelAccessConfig' => [ 'base' => '<p>The access configuration file to control access to the ML model. You can explicitly accept the model end-user license agreement (EULA) within the <code>ModelAccessConfig</code>.</p> <ul> <li> <p>If you are a Jumpstart user, see the <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/jumpstart-foundation-models-choose.html#jumpstart-foundation-models-choose-eula">End-user license agreements</a> section for more details on accepting the EULA.</p> </li> <li> <p>If you are an AutoML user, see the <i>Optional Parameters</i> section of <i>Create an AutoML job to fine-tune text generation models using the API</i> for details on <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-create-experiment-finetune-llms.html#autopilot-llms-finetuning-api-optional-params">How to set the EULA acceptance when fine-tuning a model using the AutoML API</a>.</p> </li> </ul>', 'refs' => [ 'S3ModelDataSource$ModelAccessConfig' => '<p>Specifies the access configuration file for the ML model. You can explicitly accept the model end-user license agreement (EULA) within the <code>ModelAccessConfig</code>. You are responsible for reviewing and complying with any applicable license terms and making sure they are acceptable for your use case before downloading or using a model.</p>', 'TextGenerationJobConfig$ModelAccessConfig' => NULL, ], ], 'ModelApprovalStatus' => [ 'base' => NULL, 'refs' => [ 'BatchDescribeModelPackageSummary$ModelApprovalStatus' => '<p>The approval status of the model.</p>', 'CreateModelPackageInput$ModelApprovalStatus' => '<p>Whether the model is approved for deployment.</p> <p>This parameter is optional for versioned models, and does not apply to unversioned models.</p> <p>For versioned models, the value of this parameter must be set to <code>Approved</code> to deploy the model.</p>', 'DescribeModelPackageOutput$ModelApprovalStatus' => '<p>The approval status of the model package.</p>', 'ListModelPackagesInput$ModelApprovalStatus' => '<p>A filter that returns only the model packages with the specified approval status.</p>', 'ModelPackage$ModelApprovalStatus' => '<p>The approval status of the model. This can be one of the following values.</p> <ul> <li> <p> <code>APPROVED</code> - The model is approved</p> </li> <li> <p> <code>REJECTED</code> - The model is rejected.</p> </li> <li> <p> <code>PENDING_MANUAL_APPROVAL</code> - The model is waiting for manual approval.</p> </li> </ul>', 'ModelPackageSummary$ModelApprovalStatus' => '<p>The approval status of the model. This can be one of the following values.</p> <ul> <li> <p> <code>APPROVED</code> - The model is approved</p> </li> <li> <p> <code>REJECTED</code> - The model is rejected.</p> </li> <li> <p> <code>PENDING_MANUAL_APPROVAL</code> - The model is waiting for manual approval.</p> </li> </ul>', 'UpdateModelPackageInput$ModelApprovalStatus' => '<p>The approval status of the model.</p>', ], ], 'ModelArn' => [ 'base' => NULL, 'refs' => [ 'CreateModelOutput$ModelArn' => '<p>The ARN of the model created in SageMaker.</p>', 'DescribeModelOutput$ModelArn' => '<p>The Amazon Resource Name (ARN) of the model.</p>', 'LabelingJobAlgorithmsConfig$InitialActiveLearningModelArn' => '<p>At the end of an auto-label job Ground Truth sends the Amazon Resource Name (ARN) of the final model used for auto-labeling. You can use this model as the starting point for subsequent similar jobs by providing the ARN of the model here. </p>', 'LabelingJobOutput$FinalActiveLearningModelArn' => '<p>The Amazon Resource Name (ARN) for the most recent SageMaker model trained as part of automated data labeling. </p>', 'Model$ModelArn' => '<p>The Amazon Resource Name (ARN) of the model.</p>', 'ModelSummary$ModelArn' => '<p>The Amazon Resource Name (ARN) of the model.</p>', ], ], 'ModelArtifacts' => [ 'base' => '<p>Provides information about the location that is configured for storing model artifacts. </p> <p>Model artifacts are outputs that result from training a model. They typically consist of trained parameters, a model definition that describes how to compute inferences, and other metadata. A SageMaker container stores your trained model artifacts in the <code>/opt/ml/model</code> directory. After training has completed, by default, these artifacts are uploaded to your Amazon S3 bucket as compressed files.</p>', 'refs' => [ 'DescribeCompilationJobResponse$ModelArtifacts' => '<p>Information about the location in Amazon S3 that has been configured for storing the model artifacts used in the compilation job.</p>', 'DescribeTrainingJobResponse$ModelArtifacts' => '<p>Information about the Amazon S3 location that is configured for storing model artifacts. </p>', 'TrainingJob$ModelArtifacts' => '<p>Information about the Amazon S3 location that is configured for storing model artifacts.</p>', ], ], 'ModelBiasAppSpecification' => [ 'base' => '<p>Docker container image configuration object for the model bias job.</p>', 'refs' => [ 'CreateModelBiasJobDefinitionRequest$ModelBiasAppSpecification' => '<p>Configures the model bias job to run a specified Docker container image.</p>', 'DescribeModelBiasJobDefinitionResponse$ModelBiasAppSpecification' => '<p>Configures the model bias job to run a specified Docker container image.</p>', ], ], 'ModelBiasBaselineConfig' => [ 'base' => '<p>The configuration for a baseline model bias job.</p>', 'refs' => [ 'CreateModelBiasJobDefinitionRequest$ModelBiasBaselineConfig' => '<p>The baseline configuration for a model bias job.</p>', 'DescribeModelBiasJobDefinitionResponse$ModelBiasBaselineConfig' => '<p>The baseline configuration for a model bias job.</p>', ], ], 'ModelBiasJobInput' => [ 'base' => '<p>Inputs for the model bias job.</p>', 'refs' => [ 'CreateModelBiasJobDefinitionRequest$ModelBiasJobInput' => '<p>Inputs for the model bias job.</p>', 'DescribeModelBiasJobDefinitionResponse$ModelBiasJobInput' => '<p>Inputs for the model bias job.</p>', ], ], 'ModelCacheSetting' => [ 'base' => NULL, 'refs' => [ 'MultiModelConfig$ModelCacheSetting' => '<p>Whether to cache models for a multi-model endpoint. By default, multi-model endpoints cache models so that a model does not have to be loaded into memory each time it is invoked. Some use cases do not benefit from model caching. For example, if an endpoint hosts a large number of models that are each invoked infrequently, the endpoint might perform better if you disable model caching. To disable model caching, set the value of this parameter to <code>Disabled</code>.</p>', ], ], 'ModelCard' => [ 'base' => '<p>An Amazon SageMaker Model Card.</p>', 'refs' => [ 'SearchRecord$ModelCard' => '<p>An Amazon SageMaker Model Card that documents details about a machine learning model.</p>', ], ], 'ModelCardArn' => [ 'base' => NULL, 'refs' => [ 'CreateModelCardResponse$ModelCardArn' => '<p>The Amazon Resource Name (ARN) of the successfully created model card.</p>', 'DescribeModelCardResponse$ModelCardArn' => '<p>The Amazon Resource Name (ARN) of the model card.</p>', 'ModelCard$ModelCardArn' => '<p>The Amazon Resource Name (ARN) of the model card.</p>', 'ModelCardSummary$ModelCardArn' => '<p>The Amazon Resource Name (ARN) of the model card.</p>', 'ModelCardVersionSummary$ModelCardArn' => '<p>The Amazon Resource Name (ARN) of the model card.</p>', 'ModelDashboardModelCard$ModelCardArn' => '<p>The Amazon Resource Name (ARN) for a model card.</p>', 'UpdateModelCardResponse$ModelCardArn' => '<p>The Amazon Resource Name (ARN) of the updated model card.</p>', ], ], 'ModelCardContent' => [ 'base' => NULL, 'refs' => [ 'CreateModelCardRequest$Content' => '<p>The content of the model card. Content must be in <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-cards.html#model-cards-json-schema">model card JSON schema</a> and provided as a string.</p>', 'DescribeModelCardResponse$Content' => '<p>The content of the model card.</p>', 'ModelCard$Content' => '<p>The content of the model card. Content uses the <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-cards.html#model-cards-json-schema">model card JSON schema</a> and provided as a string.</p>', 'ModelPackageModelCard$ModelCardContent' => '<p>The content of the model card. The content must follow the schema described in <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-registry-details.html#model-card-schema">Model Package Model Card Schema</a>.</p>', 'UpdateModelCardRequest$Content' => '<p>The updated model card content. Content must be in <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-cards.html#model-cards-json-schema">model card JSON schema</a> and provided as a string.</p> <p>When updating model card content, be sure to include the full content and not just updated content.</p>', ], ], 'ModelCardExportArtifacts' => [ 'base' => '<p>The artifacts of the model card export job.</p>', 'refs' => [ 'DescribeModelCardExportJobResponse$ExportArtifacts' => '<p>The exported model card artifacts.</p>', ], ], 'ModelCardExportJobArn' => [ 'base' => NULL, 'refs' => [ 'CreateModelCardExportJobResponse$ModelCardExportJobArn' => '<p>The Amazon Resource Name (ARN) of the model card export job.</p>', 'DescribeModelCardExportJobRequest$ModelCardExportJobArn' => '<p>The Amazon Resource Name (ARN) of the model card export job to describe.</p>', 'DescribeModelCardExportJobResponse$ModelCardExportJobArn' => '<p>The Amazon Resource Name (ARN) of the model card export job.</p>', 'ModelCardExportJobSummary$ModelCardExportJobArn' => '<p>The Amazon Resource Name (ARN) of the model card export job.</p>', ], ], 'ModelCardExportJobSortBy' => [ 'base' => 'Attribute by which to sort returned export jobs.', 'refs' => [ 'ListModelCardExportJobsRequest$SortBy' => '<p>Sort model card export jobs by either name or creation time. Sorts by creation time by default.</p>', ], ], 'ModelCardExportJobSortOrder' => [ 'base' => NULL, 'refs' => [ 'ListModelCardExportJobsRequest$SortOrder' => '<p>Sort model card export jobs by ascending or descending order.</p>', ], ], 'ModelCardExportJobStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeModelCardExportJobResponse$Status' => '<p>The completion status of the model card export job.</p> <ul> <li> <p> <code>InProgress</code>: The model card export job is in progress.</p> </li> <li> <p> <code>Completed</code>: The model card export job is complete.</p> </li> <li> <p> <code>Failed</code>: The model card export job failed. To see the reason for the failure, see the <code>FailureReason</code> field in the response to a <code>DescribeModelCardExportJob</code> call.</p> </li> </ul>', 'ListModelCardExportJobsRequest$StatusEquals' => '<p>Only list model card export jobs with the specified status.</p>', 'ModelCardExportJobSummary$Status' => '<p>The completion status of the model card export job.</p>', ], ], 'ModelCardExportJobSummary' => [ 'base' => '<p>The summary of the Amazon SageMaker Model Card export job.</p>', 'refs' => [ 'ModelCardExportJobSummaryList$member' => NULL, ], ], 'ModelCardExportJobSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListModelCardExportJobsResponse$ModelCardExportJobSummaries' => '<p>The summaries of the listed model card export jobs.</p>', ], ], 'ModelCardExportOutputConfig' => [ 'base' => '<p>Configure the export output details for an Amazon SageMaker Model Card.</p>', 'refs' => [ 'CreateModelCardExportJobRequest$OutputConfig' => '<p>The model card output configuration that specifies the Amazon S3 path for exporting.</p>', 'DescribeModelCardExportJobResponse$OutputConfig' => '<p>The export output details for the model card.</p>', ], ], 'ModelCardNameOrArn' => [ 'base' => NULL, 'refs' => [ 'CreateModelCardExportJobRequest$ModelCardName' => '<p>The name or Amazon Resource Name (ARN) of the model card to export.</p>', 'DescribeModelCardRequest$ModelCardName' => '<p>The name or Amazon Resource Name (ARN) of the model card to describe.</p>', 'ListModelCardVersionsRequest$ModelCardName' => '<p>List model card versions for the model card with the specified name or Amazon Resource Name (ARN).</p>', 'UpdateModelCardRequest$ModelCardName' => '<p>The name or Amazon Resource Name (ARN) of the model card to update.</p>', ], ], 'ModelCardProcessingStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeModelCardResponse$ModelCardProcessingStatus' => '<p>The processing status of model card deletion. The <code>ModelCardProcessingStatus</code> updates throughout the different deletion steps.</p> <ul> <li> <p> <code>DeletePending</code>: Model card deletion request received.</p> </li> <li> <p> <code>DeleteInProgress</code>: Model card deletion is in progress.</p> </li> <li> <p> <code>ContentDeleted</code>: Deleted model card content.</p> </li> <li> <p> <code>ExportJobsDeleted</code>: Deleted all export jobs associated with the model card.</p> </li> <li> <p> <code>DeleteCompleted</code>: Successfully deleted the model card.</p> </li> <li> <p> <code>DeleteFailed</code>: The model card failed to delete.</p> </li> </ul>', ], ], 'ModelCardSecurityConfig' => [ 'base' => '<p>Configure the security settings to protect model card data.</p>', 'refs' => [ 'CreateModelCardRequest$SecurityConfig' => '<p>An optional Key Management Service key to encrypt, decrypt, and re-encrypt model card content for regulated workloads with highly sensitive data.</p>', 'DescribeModelCardResponse$SecurityConfig' => '<p>The security configuration used to protect model card content.</p>', 'ModelCard$SecurityConfig' => '<p>The security configuration used to protect model card data.</p>', 'ModelDashboardModelCard$SecurityConfig' => '<p>The KMS Key ID (<code>KMSKeyId</code>) for encryption of model card information.</p>', ], ], 'ModelCardSortBy' => [ 'base' => NULL, 'refs' => [ 'ListModelCardsRequest$SortBy' => '<p>Sort model cards by either name or creation time. Sorts by creation time by default.</p>', ], ], 'ModelCardSortOrder' => [ 'base' => NULL, 'refs' => [ 'ListModelCardVersionsRequest$SortOrder' => '<p>Sort model card versions by ascending or descending order.</p>', 'ListModelCardsRequest$SortOrder' => '<p>Sort model cards by ascending or descending order.</p>', ], ], 'ModelCardStatus' => [ 'base' => NULL, 'refs' => [ 'CreateModelCardRequest$ModelCardStatus' => '<p>The approval status of the model card within your organization. Different organizations might have different criteria for model card review and approval.</p> <ul> <li> <p> <code>Draft</code>: The model card is a work in progress.</p> </li> <li> <p> <code>PendingReview</code>: The model card is pending review.</p> </li> <li> <p> <code>Approved</code>: The model card is approved.</p> </li> <li> <p> <code>Archived</code>: The model card is archived. No more updates should be made to the model card, but it can still be exported.</p> </li> </ul>', 'DescribeModelCardResponse$ModelCardStatus' => '<p>The approval status of the model card within your organization. Different organizations might have different criteria for model card review and approval.</p> <ul> <li> <p> <code>Draft</code>: The model card is a work in progress.</p> </li> <li> <p> <code>PendingReview</code>: The model card is pending review.</p> </li> <li> <p> <code>Approved</code>: The model card is approved.</p> </li> <li> <p> <code>Archived</code>: The model card is archived. No more updates should be made to the model card, but it can still be exported.</p> </li> </ul>', 'ListModelCardVersionsRequest$ModelCardStatus' => '<p>Only list model card versions with the specified approval status.</p>', 'ListModelCardsRequest$ModelCardStatus' => '<p>Only list model cards with the specified approval status.</p>', 'ModelCard$ModelCardStatus' => '<p>The approval status of the model card within your organization. Different organizations might have different criteria for model card review and approval.</p> <ul> <li> <p> <code>Draft</code>: The model card is a work in progress.</p> </li> <li> <p> <code>PendingReview</code>: The model card is pending review.</p> </li> <li> <p> <code>Approved</code>: The model card is approved.</p> </li> <li> <p> <code>Archived</code>: The model card is archived. No more updates should be made to the model card, but it can still be exported.</p> </li> </ul>', 'ModelCardSummary$ModelCardStatus' => '<p>The approval status of the model card within your organization. Different organizations might have different criteria for model card review and approval.</p> <ul> <li> <p> <code>Draft</code>: The model card is a work in progress.</p> </li> <li> <p> <code>PendingReview</code>: The model card is pending review.</p> </li> <li> <p> <code>Approved</code>: The model card is approved.</p> </li> <li> <p> <code>Archived</code>: The model card is archived. No more updates should be made to the model card, but it can still be exported.</p> </li> </ul>', 'ModelCardVersionSummary$ModelCardStatus' => '<p>The approval status of the model card version within your organization. Different organizations might have different criteria for model card review and approval.</p> <ul> <li> <p> <code>Draft</code>: The model card is a work in progress.</p> </li> <li> <p> <code>PendingReview</code>: The model card is pending review.</p> </li> <li> <p> <code>Approved</code>: The model card is approved.</p> </li> <li> <p> <code>Archived</code>: The model card is archived. No more updates should be made to the model card, but it can still be exported.</p> </li> </ul>', 'ModelDashboardModelCard$ModelCardStatus' => '<p>The model card status.</p>', 'ModelPackageModelCard$ModelCardStatus' => '<p>The approval status of the model card within your organization. Different organizations might have different criteria for model card review and approval.</p> <ul> <li> <p> <code>Draft</code>: The model card is a work in progress.</p> </li> <li> <p> <code>PendingReview</code>: The model card is pending review.</p> </li> <li> <p> <code>Approved</code>: The model card is approved.</p> </li> <li> <p> <code>Archived</code>: The model card is archived. No more updates can be made to the model card content. If you try to update the model card content, you will receive the message <code>Model Card is in Archived state</code>.</p> </li> </ul>', 'UpdateModelCardRequest$ModelCardStatus' => '<p>The approval status of the model card within your organization. Different organizations might have different criteria for model card review and approval.</p> <ul> <li> <p> <code>Draft</code>: The model card is a work in progress.</p> </li> <li> <p> <code>PendingReview</code>: The model card is pending review.</p> </li> <li> <p> <code>Approved</code>: The model card is approved.</p> </li> <li> <p> <code>Archived</code>: The model card is archived. No more updates should be made to the model card, but it can still be exported.</p> </li> </ul>', ], ], 'ModelCardSummary' => [ 'base' => '<p>A summary of the model card.</p>', 'refs' => [ 'ModelCardSummaryList$member' => NULL, ], ], 'ModelCardSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListModelCardsResponse$ModelCardSummaries' => '<p>The summaries of the listed model cards.</p>', ], ], 'ModelCardVersionSortBy' => [ 'base' => NULL, 'refs' => [ 'ListModelCardVersionsRequest$SortBy' => '<p>Sort listed model card versions by version. Sorts by version by default.</p>', ], ], 'ModelCardVersionSummary' => [ 'base' => '<p>A summary of a specific version of the model card.</p>', 'refs' => [ 'ModelCardVersionSummaryList$member' => NULL, ], ], 'ModelCardVersionSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListModelCardVersionsResponse$ModelCardVersionSummaryList' => '<p>The summaries of the listed versions of the model card.</p>', ], ], 'ModelClientConfig' => [ 'base' => '<p>Configures the timeout and maximum number of retries for processing a transform job invocation.</p>', 'refs' => [ 'CreateTransformJobRequest$ModelClientConfig' => '<p>Configures the timeout and maximum number of retries for processing a transform job invocation.</p>', 'DescribeTransformJobResponse$ModelClientConfig' => '<p>The timeout and maximum number of retries for processing a transform job invocation.</p>', 'TransformJob$ModelClientConfig' => NULL, ], ], 'ModelCompilationConfig' => [ 'base' => '<p>Settings for the model compilation technique that\'s applied by a model optimization job.</p>', 'refs' => [ 'OptimizationConfig$ModelCompilationConfig' => '<p>Settings for the model compilation technique that\'s applied by a model optimization job.</p>', ], ], 'ModelCompressionType' => [ 'base' => NULL, 'refs' => [ 'S3ModelDataSource$CompressionType' => '<p>Specifies how the ML model data is prepared.</p> <p>If you choose <code>Gzip</code> and choose <code>S3Object</code> as the value of <code>S3DataType</code>, <code>S3Uri</code> identifies an object that is a gzip-compressed TAR archive. SageMaker will attempt to decompress and untar the object during model deployment.</p> <p>If you choose <code>None</code> and chooose <code>S3Object</code> as the value of <code>S3DataType</code>, <code>S3Uri</code> identifies an object that represents an uncompressed ML model to deploy.</p> <p>If you choose None and choose <code>S3Prefix</code> as the value of <code>S3DataType</code>, <code>S3Uri</code> identifies a key name prefix, under which all objects represents the uncompressed ML model to deploy.</p> <p>If you choose None, then SageMaker will follow rules below when creating model data files under /opt/ml/model directory for use by your inference code:</p> <ul> <li> <p>If you choose <code>S3Object</code> as the value of <code>S3DataType</code>, then SageMaker will split the key of the S3 object referenced by <code>S3Uri</code> by slash (/), and use the last part as the filename of the file holding the content of the S3 object.</p> </li> <li> <p>If you choose <code>S3Prefix</code> as the value of <code>S3DataType</code>, then for each S3 object under the key name pefix referenced by <code>S3Uri</code>, SageMaker will trim its key by the prefix, and use the remainder as the path (relative to <code>/opt/ml/model</code>) of the file holding the content of the S3 object. SageMaker will split the remainder by slash (/), using intermediate parts as directory names and the last part as filename of the file holding the content of the S3 object.</p> </li> <li> <p>Do not use any of the following as file names or directory names:</p> <ul> <li> <p>An empty or blank string</p> </li> <li> <p>A string which contains null bytes</p> </li> <li> <p>A string longer than 255 bytes</p> </li> <li> <p>A single dot (<code>.</code>)</p> </li> <li> <p>A double dot (<code>..</code>)</p> </li> </ul> </li> <li> <p>Ambiguous file names will result in model deployment failure. For example, if your uncompressed ML model consists of two S3 objects <code>s3://mybucket/model/weights</code> and <code>s3://mybucket/model/weights/part1</code> and you specify <code>s3://mybucket/model/</code> as the value of <code>S3Uri</code> and <code>S3Prefix</code> as the value of <code>S3DataType</code>, then it will result in name clash between <code>/opt/ml/model/weights</code> (a regular file) and <code>/opt/ml/model/weights/</code> (a directory).</p> </li> <li> <p>Do not organize the model artifacts in <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-folders.html">S3 console using folders</a>. When you create a folder in S3 console, S3 creates a 0-byte object with a key set to the folder name you provide. They key of the 0-byte object ends with a slash (/) which violates SageMaker restrictions on model artifact file names, leading to model deployment failure. </p> </li> </ul>', ], ], 'ModelConfiguration' => [ 'base' => '<p>Defines the model configuration. Includes the specification name and environment parameters.</p>', 'refs' => [ 'InferenceRecommendation$ModelConfiguration' => '<p>Defines the model configuration.</p>', 'RecommendationJobInferenceBenchmark$ModelConfiguration' => NULL, ], ], 'ModelDashboardEndpoint' => [ 'base' => '<p>An endpoint that hosts a model displayed in the Amazon SageMaker Model Dashboard.</p>', 'refs' => [ 'ModelDashboardEndpoints$member' => NULL, ], ], 'ModelDashboardEndpoints' => [ 'base' => NULL, 'refs' => [ 'ModelDashboardModel$Endpoints' => '<p>The endpoints that host a model.</p>', ], ], 'ModelDashboardIndicatorAction' => [ 'base' => '<p>An alert action taken to light up an icon on the Amazon SageMaker Model Dashboard when an alert goes into <code>InAlert</code> status.</p>', 'refs' => [ 'MonitoringAlertActions$ModelDashboardIndicator' => '<p>An alert action taken to light up an icon on the Model Dashboard when an alert goes into <code>InAlert</code> status.</p>', ], ], 'ModelDashboardModel' => [ 'base' => '<p>A model displayed in the Amazon SageMaker Model Dashboard.</p>', 'refs' => [ 'SearchRecord$Model' => NULL, ], ], 'ModelDashboardModelCard' => [ 'base' => '<p>The model card for a model displayed in the Amazon SageMaker Model Dashboard.</p>', 'refs' => [ 'ModelDashboardModel$ModelCard' => '<p>The model card for a model.</p>', ], ], 'ModelDashboardMonitoringSchedule' => [ 'base' => '<p>A monitoring schedule for a model displayed in the Amazon SageMaker Model Dashboard.</p>', 'refs' => [ 'ModelDashboardMonitoringSchedules$member' => NULL, ], ], 'ModelDashboardMonitoringSchedules' => [ 'base' => NULL, 'refs' => [ 'ModelDashboardModel$MonitoringSchedules' => '<p>The monitoring schedules for a model.</p>', ], ], 'ModelDataQuality' => [ 'base' => '<p>Data quality constraints and statistics for a model.</p>', 'refs' => [ 'ModelMetrics$ModelDataQuality' => '<p>Metrics that measure the quality of the input data for a model.</p>', ], ], 'ModelDataSource' => [ 'base' => '<p>Specifies the location of ML model data to deploy. If specified, you must specify one and only one of the available data sources.</p>', 'refs' => [ 'ContainerDefinition$ModelDataSource' => '<p>Specifies the location of ML model data to deploy.</p> <note> <p>Currently you cannot use <code>ModelDataSource</code> in conjunction with SageMaker batch transform, SageMaker serverless endpoints, SageMaker multi-model endpoints, and SageMaker Marketplace.</p> </note>', 'ModelPackageContainerDefinition$ModelDataSource' => '<p>Specifies the location of ML model data to deploy during endpoint creation.</p>', 'SourceAlgorithm$ModelDataSource' => '<p>Specifies the location of ML model data to deploy during endpoint creation.</p>', ], ], 'ModelDeployConfig' => [ 'base' => '<p>Specifies how to generate the endpoint name for an automatic one-click Autopilot model deployment.</p>', 'refs' => [ 'CreateAutoMLJobRequest$ModelDeployConfig' => '<p>Specifies how to generate the endpoint name for an automatic one-click Autopilot model deployment.</p>', 'CreateAutoMLJobV2Request$ModelDeployConfig' => '<p>Specifies how to generate the endpoint name for an automatic one-click Autopilot model deployment.</p>', 'DescribeAutoMLJobResponse$ModelDeployConfig' => '<p>Indicates whether the model was deployed automatically to an endpoint and the name of that endpoint if deployed automatically.</p>', 'DescribeAutoMLJobV2Response$ModelDeployConfig' => '<p>Indicates whether the model was deployed automatically to an endpoint and the name of that endpoint if deployed automatically.</p>', ], ], 'ModelDeployResult' => [ 'base' => '<p>Provides information about the endpoint of the model deployment.</p>', 'refs' => [ 'DescribeAutoMLJobResponse$ModelDeployResult' => '<p>Provides information about endpoint for the model deployment.</p>', 'DescribeAutoMLJobV2Response$ModelDeployResult' => '<p>Provides information about endpoint for the model deployment.</p>', ], ], 'ModelDigests' => [ 'base' => '<p>Provides information to verify the integrity of stored model artifacts. </p>', 'refs' => [ 'DescribeCompilationJobResponse$ModelDigests' => '<p>Provides a BLAKE2 hash value that identifies the compiled model artifacts in Amazon S3.</p>', ], ], 'ModelExplainabilityAppSpecification' => [ 'base' => '<p>Docker container image configuration object for the model explainability job.</p>', 'refs' => [ 'CreateModelExplainabilityJobDefinitionRequest$ModelExplainabilityAppSpecification' => '<p>Configures the model explainability job to run a specified Docker container image.</p>', 'DescribeModelExplainabilityJobDefinitionResponse$ModelExplainabilityAppSpecification' => '<p>Configures the model explainability job to run a specified Docker container image.</p>', ], ], 'ModelExplainabilityBaselineConfig' => [ 'base' => '<p>The configuration for a baseline model explainability job.</p>', 'refs' => [ 'CreateModelExplainabilityJobDefinitionRequest$ModelExplainabilityBaselineConfig' => '<p>The baseline configuration for a model explainability job.</p>', 'DescribeModelExplainabilityJobDefinitionResponse$ModelExplainabilityBaselineConfig' => '<p>The baseline configuration for a model explainability job.</p>', ], ], 'ModelExplainabilityJobInput' => [ 'base' => '<p>Inputs for the model explainability job.</p>', 'refs' => [ 'CreateModelExplainabilityJobDefinitionRequest$ModelExplainabilityJobInput' => '<p>Inputs for the model explainability job.</p>', 'DescribeModelExplainabilityJobDefinitionResponse$ModelExplainabilityJobInput' => '<p>Inputs for the model explainability job.</p>', ], ], 'ModelInfrastructureConfig' => [ 'base' => '<p>The configuration for the infrastructure that the model will be deployed to.</p>', 'refs' => [ 'ModelVariantConfig$InfrastructureConfig' => '<p>The configuration for the infrastructure that the model will be deployed to.</p>', 'ModelVariantConfigSummary$InfrastructureConfig' => '<p>The configuration of the infrastructure that the model has been deployed to.</p>', ], ], 'ModelInfrastructureType' => [ 'base' => NULL, 'refs' => [ 'ModelInfrastructureConfig$InfrastructureType' => '<p>The inference option to which to deploy your model. Possible values are the following:</p> <ul> <li> <p> <code>RealTime</code>: Deploy to real-time inference.</p> </li> </ul>', ], ], 'ModelInput' => [ 'base' => '<p>Input object for the model.</p>', 'refs' => [ 'ModelPackageContainerDefinition$ModelInput' => '<p>A structure with Model Input details.</p>', ], ], 'ModelInsightsLocation' => [ 'base' => NULL, 'refs' => [ 'CandidateArtifactLocations$ModelInsights' => '<p>The Amazon S3 prefix to the model insight artifacts generated for the AutoML candidate.</p>', ], ], 'ModelLatencyThreshold' => [ 'base' => '<p>The model latency threshold.</p>', 'refs' => [ 'ModelLatencyThresholds$member' => NULL, ], ], 'ModelLatencyThresholds' => [ 'base' => NULL, 'refs' => [ 'RecommendationJobStoppingConditions$ModelLatencyThresholds' => '<p>The interval of time taken by a model to respond as viewed from SageMaker. The interval includes the local communication time taken to send the request and to fetch the response from the container of a model and the time taken to complete the inference in the container.</p>', ], ], 'ModelMetadataFilter' => [ 'base' => '<p>Part of the search expression. You can specify the name and value (domain, task, framework, framework version, task, and model).</p>', 'refs' => [ 'ModelMetadataFilters$member' => NULL, ], ], 'ModelMetadataFilterType' => [ 'base' => NULL, 'refs' => [ 'ModelMetadataFilter$Name' => '<p>The name of the of the model to filter by.</p>', ], ], 'ModelMetadataFilters' => [ 'base' => NULL, 'refs' => [ 'ModelMetadataSearchExpression$Filters' => '<p>A list of filter objects.</p>', ], ], 'ModelMetadataSearchExpression' => [ 'base' => '<p>One or more filters that searches for the specified resource or resources in a search. All resource objects that satisfy the expression\'s condition are included in the search results</p>', 'refs' => [ 'ListModelMetadataRequest$SearchExpression' => '<p>One or more filters that searches for the specified resource or resources in a search. All resource objects that satisfy the expression\'s condition are included in the search results. Specify the Framework, FrameworkVersion, Domain or Task to filter supported. Filter names and values are case-sensitive.</p>', ], ], 'ModelMetadataSummaries' => [ 'base' => NULL, 'refs' => [ 'ListModelMetadataResponse$ModelMetadataSummaries' => '<p>A structure that holds model metadata.</p>', ], ], 'ModelMetadataSummary' => [ 'base' => '<p>A summary of the model metadata.</p>', 'refs' => [ 'ModelMetadataSummaries$member' => NULL, ], ], 'ModelMetrics' => [ 'base' => '<p>Contains metrics captured from a model.</p>', 'refs' => [ 'CreateModelPackageInput$ModelMetrics' => '<p>A structure that contains model metrics reports.</p>', 'DescribeModelPackageOutput$ModelMetrics' => '<p>Metrics for the model.</p>', 'ModelPackage$ModelMetrics' => '<p>Metrics for the model.</p>', ], ], 'ModelName' => [ 'base' => NULL, 'refs' => [ 'CreateModelInput$ModelName' => '<p>The name of the new model.</p>', 'CreateTransformJobRequest$ModelName' => '<p>The name of the model that you want to use for the transform job. <code>ModelName</code> must be the name of an existing Amazon SageMaker model within an Amazon Web Services Region in an Amazon Web Services account.</p>', 'DeleteModelInput$ModelName' => '<p>The name of the model to delete.</p>', 'DescribeModelInput$ModelName' => '<p>The name of the model.</p>', 'DescribeModelOutput$ModelName' => '<p>Name of the SageMaker model.</p>', 'DescribeTransformJobResponse$ModelName' => '<p>The name of the model used in the transform job.</p>', 'InferenceComponentSpecification$ModelName' => '<p>The name of an existing SageMaker model object in your account that you want to deploy with the inference component.</p>', 'InferenceComponentSpecificationSummary$ModelName' => '<p>The name of the SageMaker model object that is deployed with the inference component.</p>', 'InferenceRecommendationsJob$ModelName' => '<p>The name of the created model.</p>', 'ListInferenceRecommendationsJobsRequest$ModelNameEquals' => '<p>A filter that returns only jobs that were created for this model.</p>', 'Model$ModelName' => '<p>The name of the model.</p>', 'ModelSummary$ModelName' => '<p>The name of the model that you want a summary for.</p>', 'ModelVariantConfig$ModelName' => '<p>The name of the Amazon SageMaker Model entity.</p>', 'ModelVariantConfigSummary$ModelName' => '<p>The name of the Amazon SageMaker Model entity.</p>', 'ProductionVariant$ModelName' => '<p>The name of the model that you want to host. This is the name that you specified when creating the model.</p>', 'RecommendationJobInputConfig$ModelName' => '<p>The name of the created model.</p>', 'TransformJob$ModelName' => '<p>The name of the model associated with the transform job.</p>', ], ], 'ModelNameContains' => [ 'base' => NULL, 'refs' => [ 'ListModelsInput$NameContains' => '<p>A string in the model name. This filter returns only models whose name contains the specified string.</p>', ], ], 'ModelPackage' => [ 'base' => '<p>A versioned model that can be deployed for SageMaker inference.</p>', 'refs' => [ 'SearchRecord$ModelPackage' => NULL, ], ], 'ModelPackageArn' => [ 'base' => NULL, 'refs' => [ 'BatchDescribeModelPackageErrorMap$key' => NULL, 'BatchDescribeModelPackageSummary$ModelPackageArn' => '<p>The Amazon Resource Name (ARN) of the model package.</p>', 'CreateCompilationJobRequest$ModelPackageVersionArn' => '<p>The Amazon Resource Name (ARN) of a versioned model package. Provide either a <code>ModelPackageVersionArn</code> or an <code>InputConfig</code> object in the request syntax. The presence of both objects in the <code>CreateCompilationJob</code> request will return an exception.</p>', 'CreateModelPackageOutput$ModelPackageArn' => '<p>The Amazon Resource Name (ARN) of the new model package.</p>', 'DescribeCompilationJobResponse$ModelPackageVersionArn' => '<p>The Amazon Resource Name (ARN) of the versioned model package that was provided to SageMaker Neo when you initiated a compilation job.</p>', 'DescribeModelPackageOutput$ModelPackageArn' => '<p>The Amazon Resource Name (ARN) of the model package.</p>', 'InferenceRecommendationsJob$ModelPackageVersionArn' => '<p>The Amazon Resource Name (ARN) of a versioned model package.</p>', 'ListInferenceRecommendationsJobsRequest$ModelPackageVersionArnEquals' => '<p>A filter that returns only jobs that were created for this versioned model package.</p>', 'ModelPackage$ModelPackageArn' => '<p>The Amazon Resource Name (ARN) of the model package.</p>', 'ModelPackageArnList$member' => NULL, 'ModelPackageSummaries$key' => NULL, 'ModelPackageSummary$ModelPackageArn' => '<p>The Amazon Resource Name (ARN) of the model package.</p>', 'RecommendationJobInputConfig$ModelPackageVersionArn' => '<p>The Amazon Resource Name (ARN) of a versioned model package.</p>', 'UpdateModelPackageInput$ModelPackageArn' => '<p>The Amazon Resource Name (ARN) of the model package.</p>', 'UpdateModelPackageOutput$ModelPackageArn' => '<p>The Amazon Resource Name (ARN) of the model.</p>', ], ], 'ModelPackageArnList' => [ 'base' => NULL, 'refs' => [ 'BatchDescribeModelPackageInput$ModelPackageArnList' => '<p>The list of Amazon Resource Name (ARN) of the model package groups.</p>', ], ], 'ModelPackageContainerDefinition' => [ 'base' => '<p>Describes the Docker container for the model package.</p>', 'refs' => [ 'ModelPackageContainerDefinitionList$member' => NULL, ], ], 'ModelPackageContainerDefinitionList' => [ 'base' => NULL, 'refs' => [ 'AdditionalInferenceSpecificationDefinition$Containers' => '<p>The Amazon ECR registry path of the Docker image that contains the inference code.</p>', 'InferenceSpecification$Containers' => '<p>The Amazon ECR registry path of the Docker image that contains the inference code.</p>', ], ], 'ModelPackageFrameworkVersion' => [ 'base' => NULL, 'refs' => [ 'ModelPackageContainerDefinition$FrameworkVersion' => '<p>The framework version of the Model Package Container Image.</p>', ], ], 'ModelPackageGroup' => [ 'base' => '<p>A group of versioned models in the model registry.</p>', 'refs' => [ 'SearchRecord$ModelPackageGroup' => NULL, ], ], 'ModelPackageGroupArn' => [ 'base' => NULL, 'refs' => [ 'CreateModelPackageGroupOutput$ModelPackageGroupArn' => '<p>The Amazon Resource Name (ARN) of the model group.</p>', 'DescribeModelPackageGroupOutput$ModelPackageGroupArn' => '<p>The Amazon Resource Name (ARN) of the model group.</p>', 'ModelPackageGroup$ModelPackageGroupArn' => '<p>The Amazon Resource Name (ARN) of the model group.</p>', 'ModelPackageGroupSummary$ModelPackageGroupArn' => '<p>The Amazon Resource Name (ARN) of the model group.</p>', 'PutModelPackageGroupPolicyOutput$ModelPackageGroupArn' => '<p>The Amazon Resource Name (ARN) of the model package group.</p>', ], ], 'ModelPackageGroupSortBy' => [ 'base' => NULL, 'refs' => [ 'ListModelPackageGroupsInput$SortBy' => '<p>The field to sort results by. The default is <code>CreationTime</code>.</p>', ], ], 'ModelPackageGroupStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeModelPackageGroupOutput$ModelPackageGroupStatus' => '<p>The status of the model group.</p>', 'ModelPackageGroup$ModelPackageGroupStatus' => '<p>The status of the model group. This can be one of the following values.</p> <ul> <li> <p> <code>PENDING</code> - The model group is pending being created.</p> </li> <li> <p> <code>IN_PROGRESS</code> - The model group is in the process of being created.</p> </li> <li> <p> <code>COMPLETED</code> - The model group was successfully created.</p> </li> <li> <p> <code>FAILED</code> - The model group failed.</p> </li> <li> <p> <code>DELETING</code> - The model group is in the process of being deleted.</p> </li> <li> <p> <code>DELETE_FAILED</code> - SageMaker failed to delete the model group.</p> </li> </ul>', 'ModelPackageGroupSummary$ModelPackageGroupStatus' => '<p>The status of the model group.</p>', ], ], 'ModelPackageGroupSummary' => [ 'base' => '<p>Summary information about a model group.</p>', 'refs' => [ 'ModelPackageGroupSummaryList$member' => NULL, ], ], 'ModelPackageGroupSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListModelPackageGroupsOutput$ModelPackageGroupSummaryList' => '<p>A list of summaries of the model groups in your Amazon Web Services account.</p>', ], ], 'ModelPackageModelCard' => [ 'base' => '<p>The model card associated with the model package. Since <code>ModelPackageModelCard</code> is tied to a model package, it is a specific usage of a model card and its schema is simplified compared to the schema of <code>ModelCard</code>. The <code>ModelPackageModelCard</code> schema does not include <code>model_package_details</code>, and <code>model_overview</code> is composed of the <code>model_creator</code> and <code>model_artifact</code> properties. For more information about the model package model card schema, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-registry-details.html#model-card-schema">Model package model card schema</a>. For more information about the model card associated with the model package, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-registry-details.html">View the Details of a Model Version</a>.</p>', 'refs' => [ 'CreateModelPackageInput$ModelCard' => '<p>The model card associated with the model package. Since <code>ModelPackageModelCard</code> is tied to a model package, it is a specific usage of a model card and its schema is simplified compared to the schema of <code>ModelCard</code>. The <code>ModelPackageModelCard</code> schema does not include <code>model_package_details</code>, and <code>model_overview</code> is composed of the <code>model_creator</code> and <code>model_artifact</code> properties. For more information about the model package model card schema, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-registry-details.html#model-card-schema">Model package model card schema</a>. For more information about the model card associated with the model package, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-registry-details.html">View the Details of a Model Version</a>.</p>', 'DescribeModelPackageOutput$ModelCard' => '<p>The model card associated with the model package. Since <code>ModelPackageModelCard</code> is tied to a model package, it is a specific usage of a model card and its schema is simplified compared to the schema of <code>ModelCard</code>. The <code>ModelPackageModelCard</code> schema does not include <code>model_package_details</code>, and <code>model_overview</code> is composed of the <code>model_creator</code> and <code>model_artifact</code> properties. For more information about the model package model card schema, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-registry-details.html#model-card-schema">Model package model card schema</a>. For more information about the model card associated with the model package, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-registry-details.html">View the Details of a Model Version</a>.</p>', 'ModelPackage$ModelCard' => NULL, 'UpdateModelPackageInput$ModelCard' => '<p>The model card associated with the model package. Since <code>ModelPackageModelCard</code> is tied to a model package, it is a specific usage of a model card and its schema is simplified compared to the schema of <code>ModelCard</code>. The <code>ModelPackageModelCard</code> schema does not include <code>model_package_details</code>, and <code>model_overview</code> is composed of the <code>model_creator</code> and <code>model_artifact</code> properties. For more information about the model package model card schema, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-registry-details.html#model-card-schema">Model package model card schema</a>. For more information about the model card associated with the model package, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-registry-details.html">View the Details of a Model Version</a>.</p>', ], ], 'ModelPackageSecurityConfig' => [ 'base' => '<p>An optional Key Management Service key to encrypt, decrypt, and re-encrypt model package information for regulated workloads with highly sensitive data.</p>', 'refs' => [ 'CreateModelPackageInput$SecurityConfig' => '<p>The KMS Key ID (<code>KMSKeyId</code>) used for encryption of model package information.</p>', 'DescribeModelPackageOutput$SecurityConfig' => '<p>The KMS Key ID (<code>KMSKeyId</code>) used for encryption of model package information.</p>', 'ModelPackage$SecurityConfig' => NULL, ], ], 'ModelPackageSortBy' => [ 'base' => NULL, 'refs' => [ 'ListModelPackagesInput$SortBy' => '<p>The parameter by which to sort the results. The default is <code>CreationTime</code>.</p>', ], ], 'ModelPackageSourceUri' => [ 'base' => NULL, 'refs' => [ 'CreateModelPackageInput$SourceUri' => '<p>The URI of the source for the model package. If you want to clone a model package, set it to the model package Amazon Resource Name (ARN). If you want to register a model, set it to the model ARN.</p>', 'DescribeModelPackageOutput$SourceUri' => '<p>The URI of the source for the model package.</p>', 'ModelPackage$SourceUri' => '<p>The URI of the source for the model package.</p>', 'UpdateModelPackageInput$SourceUri' => '<p>The URI of the source for the model package.</p>', ], ], 'ModelPackageStatus' => [ 'base' => NULL, 'refs' => [ 'BatchDescribeModelPackageSummary$ModelPackageStatus' => '<p>The status of the mortgage package.</p>', 'DescribeModelPackageOutput$ModelPackageStatus' => '<p>The current status of the model package.</p>', 'ModelPackage$ModelPackageStatus' => '<p>The status of the model package. This can be one of the following values.</p> <ul> <li> <p> <code>PENDING</code> - The model package is pending being created.</p> </li> <li> <p> <code>IN_PROGRESS</code> - The model package is in the process of being created.</p> </li> <li> <p> <code>COMPLETED</code> - The model package was successfully created.</p> </li> <li> <p> <code>FAILED</code> - The model package failed.</p> </li> <li> <p> <code>DELETING</code> - The model package is in the process of being deleted.</p> </li> </ul>', 'ModelPackageSummary$ModelPackageStatus' => '<p>The overall status of the model package.</p>', ], ], 'ModelPackageStatusDetails' => [ 'base' => '<p>Specifies the validation and image scan statuses of the model package.</p>', 'refs' => [ 'DescribeModelPackageOutput$ModelPackageStatusDetails' => '<p>Details about the current status of the model package.</p>', 'ModelPackage$ModelPackageStatusDetails' => '<p>Specifies the validation and image scan statuses of the model package.</p>', ], ], 'ModelPackageStatusItem' => [ 'base' => '<p>Represents the overall status of a model package.</p>', 'refs' => [ 'ModelPackageStatusItemList$member' => NULL, ], ], 'ModelPackageStatusItemList' => [ 'base' => NULL, 'refs' => [ 'ModelPackageStatusDetails$ValidationStatuses' => '<p>The validation status of the model package.</p>', 'ModelPackageStatusDetails$ImageScanStatuses' => '<p>The status of the scan of the Docker image container for the model package.</p>', ], ], 'ModelPackageSummaries' => [ 'base' => NULL, 'refs' => [ 'BatchDescribeModelPackageOutput$ModelPackageSummaries' => '<p>The summaries for the model package versions</p>', ], ], 'ModelPackageSummary' => [ 'base' => '<p>Provides summary information about a model package.</p>', 'refs' => [ 'ModelPackageSummaryList$member' => NULL, ], ], 'ModelPackageSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListModelPackagesOutput$ModelPackageSummaryList' => '<p>An array of <code>ModelPackageSummary</code> objects, each of which lists a model package.</p>', ], ], 'ModelPackageType' => [ 'base' => NULL, 'refs' => [ 'ListModelPackagesInput$ModelPackageType' => '<p>A filter that returns only the model packages of the specified type. This can be one of the following values.</p> <ul> <li> <p> <code>UNVERSIONED</code> - List only unversioined models. This is the default value if no <code>ModelPackageType</code> is specified.</p> </li> <li> <p> <code>VERSIONED</code> - List only versioned models.</p> </li> <li> <p> <code>BOTH</code> - List both versioned and unversioned models.</p> </li> </ul>', ], ], 'ModelPackageValidationProfile' => [ 'base' => '<p>Contains data, such as the inputs and targeted instance types that are used in the process of validating the model package.</p> <p>The data provided in the validation profile is made available to your buyers on Amazon Web Services Marketplace.</p>', 'refs' => [ 'ModelPackageValidationProfiles$member' => NULL, ], ], 'ModelPackageValidationProfiles' => [ 'base' => NULL, 'refs' => [ 'ModelPackageValidationSpecification$ValidationProfiles' => '<p>An array of <code>ModelPackageValidationProfile</code> objects, each of which specifies a batch transform job that SageMaker runs to validate your model package.</p>', ], ], 'ModelPackageValidationSpecification' => [ 'base' => '<p>Specifies batch transform jobs that SageMaker runs to validate your model package.</p>', 'refs' => [ 'CreateModelPackageInput$ValidationSpecification' => '<p>Specifies configurations for one or more transform jobs that SageMaker runs to test the model package.</p>', 'DescribeModelPackageOutput$ValidationSpecification' => '<p>Configurations for one or more transform jobs that SageMaker runs to test the model package.</p>', 'ModelPackage$ValidationSpecification' => '<p>Specifies batch transform jobs that SageMaker runs to validate your model package.</p>', ], ], 'ModelPackageVersion' => [ 'base' => NULL, 'refs' => [ 'BatchDescribeModelPackageSummary$ModelPackageVersion' => '<p>The version number of a versioned model.</p>', 'DescribeModelPackageOutput$ModelPackageVersion' => '<p>The version of the model package.</p>', 'ModelPackage$ModelPackageVersion' => '<p>The version number of a versioned model.</p>', 'ModelPackageSummary$ModelPackageVersion' => '<p>If the model package is a versioned model, the version of the model.</p>', ], ], 'ModelQuality' => [ 'base' => '<p>Model quality statistics and constraints.</p>', 'refs' => [ 'ModelMetrics$ModelQuality' => '<p>Metrics that measure the quality of a model.</p>', ], ], 'ModelQualityAppSpecification' => [ 'base' => '<p>Container image configuration object for the monitoring job.</p>', 'refs' => [ 'CreateModelQualityJobDefinitionRequest$ModelQualityAppSpecification' => '<p>The container that runs the monitoring job.</p>', 'DescribeModelQualityJobDefinitionResponse$ModelQualityAppSpecification' => '<p>Configures the model quality job to run a specified Docker container image.</p>', ], ], 'ModelQualityBaselineConfig' => [ 'base' => '<p>Configuration for monitoring constraints and monitoring statistics. These baseline resources are compared against the results of the current job from the series of jobs scheduled to collect data periodically.</p>', 'refs' => [ 'CreateModelQualityJobDefinitionRequest$ModelQualityBaselineConfig' => '<p>Specifies the constraints and baselines for the monitoring job.</p>', 'DescribeModelQualityJobDefinitionResponse$ModelQualityBaselineConfig' => '<p>The baseline configuration for a model quality job.</p>', ], ], 'ModelQualityJobInput' => [ 'base' => '<p>The input for the model quality monitoring job. Currently endpoints are supported for input for model quality monitoring jobs.</p>', 'refs' => [ 'CreateModelQualityJobDefinitionRequest$ModelQualityJobInput' => '<p>A list of the inputs that are monitored. Currently endpoints are supported.</p>', 'DescribeModelQualityJobDefinitionResponse$ModelQualityJobInput' => '<p>Inputs for the model quality job.</p>', ], ], 'ModelQuantizationConfig' => [ 'base' => '<p>Settings for the model quantization technique that\'s applied by a model optimization job.</p>', 'refs' => [ 'OptimizationConfig$ModelQuantizationConfig' => '<p>Settings for the model quantization technique that\'s applied by a model optimization job.</p>', ], ], 'ModelRegisterSettings' => [ 'base' => '<p>The model registry settings for the SageMaker Canvas application.</p>', 'refs' => [ 'CanvasAppSettings$ModelRegisterSettings' => '<p>The model registry settings for the SageMaker Canvas application.</p>', ], ], 'ModelSetupTime' => [ 'base' => NULL, 'refs' => [ 'RecommendationMetrics$ModelSetupTime' => '<p>The time it takes to launch new compute resources for a serverless endpoint. The time can vary depending on the model size, how long it takes to download the model, and the start-up time of the container.</p> <p> <code>NaN</code> indicates that the value is not available.</p>', ], ], 'ModelSortKey' => [ 'base' => NULL, 'refs' => [ 'ListModelsInput$SortBy' => '<p>Sorts the list of results. The default is <code>CreationTime</code>.</p>', ], ], 'ModelStepMetadata' => [ 'base' => '<p>Metadata for Model steps.</p>', 'refs' => [ 'PipelineExecutionStepMetadata$Model' => '<p>The Amazon Resource Name (ARN) of the model that was created by this step execution.</p>', ], ], 'ModelSummary' => [ 'base' => '<p>Provides summary information about a model.</p>', 'refs' => [ 'ModelSummaryList$member' => NULL, ], ], 'ModelSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListModelsOutput$Models' => '<p>An array of <code>ModelSummary</code> objects, each of which lists a model.</p>', ], ], 'ModelVariantAction' => [ 'base' => NULL, 'refs' => [ 'ModelVariantActionMap$value' => NULL, ], ], 'ModelVariantActionMap' => [ 'base' => NULL, 'refs' => [ 'StopInferenceExperimentRequest$ModelVariantActions' => '<p> Array of key-value pairs, with names of variants mapped to actions. The possible actions are the following: </p> <ul> <li> <p> <code>Promote</code> - Promote the shadow variant to a production variant</p> </li> <li> <p> <code>Remove</code> - Delete the variant</p> </li> <li> <p> <code>Retain</code> - Keep the variant as it is</p> </li> </ul>', ], ], 'ModelVariantConfig' => [ 'base' => '<p>Contains information about the deployment options of a model.</p>', 'refs' => [ 'ModelVariantConfigList$member' => NULL, ], ], 'ModelVariantConfigList' => [ 'base' => NULL, 'refs' => [ 'CreateInferenceExperimentRequest$ModelVariants' => '<p> An array of <code>ModelVariantConfig</code> objects. There is one for each variant in the inference experiment. Each <code>ModelVariantConfig</code> object in the array describes the infrastructure configuration for the corresponding variant. </p>', 'StopInferenceExperimentRequest$DesiredModelVariants' => '<p> An array of <code>ModelVariantConfig</code> objects. There is one for each variant that you want to deploy after the inference experiment stops. Each <code>ModelVariantConfig</code> describes the infrastructure configuration for deploying the corresponding variant. </p>', 'UpdateInferenceExperimentRequest$ModelVariants' => '<p> An array of <code>ModelVariantConfig</code> objects. There is one for each variant, whose infrastructure configuration you want to update. </p>', ], ], 'ModelVariantConfigSummary' => [ 'base' => '<p>Summary of the deployment configuration of a model.</p>', 'refs' => [ 'ModelVariantConfigSummaryList$member' => NULL, ], ], 'ModelVariantConfigSummaryList' => [ 'base' => NULL, 'refs' => [ 'DescribeInferenceExperimentResponse$ModelVariants' => '<p> An array of <code>ModelVariantConfigSummary</code> objects. There is one for each variant in the inference experiment. Each <code>ModelVariantConfigSummary</code> object in the array describes the infrastructure configuration for deploying the corresponding variant. </p>', ], ], 'ModelVariantName' => [ 'base' => NULL, 'refs' => [ 'ModelVariantActionMap$key' => NULL, 'ModelVariantConfig$VariantName' => '<p>The name of the variant.</p>', 'ModelVariantConfigSummary$VariantName' => '<p>The name of the variant.</p>', 'ShadowModeConfig$SourceModelVariantName' => '<p> The name of the production variant, which takes all the inference requests. </p>', 'ShadowModelVariantConfig$ShadowModelVariantName' => '<p>The name of the shadow variant.</p>', ], ], 'ModelVariantStatus' => [ 'base' => NULL, 'refs' => [ 'ModelVariantConfigSummary$Status' => '<p>The status of deployment for the model variant on the hosted inference endpoint.</p> <ul> <li> <p> <code>Creating</code> - Amazon SageMaker is preparing the model variant on the hosted inference endpoint. </p> </li> <li> <p> <code>InService</code> - The model variant is running on the hosted inference endpoint. </p> </li> <li> <p> <code>Updating</code> - Amazon SageMaker is updating the model variant on the hosted inference endpoint. </p> </li> <li> <p> <code>Deleting</code> - Amazon SageMaker is deleting the model variant on the hosted inference endpoint. </p> </li> <li> <p> <code>Deleted</code> - The model variant has been deleted on the hosted inference endpoint. This can only happen after stopping the experiment. </p> </li> </ul>', ], ], 'MonitoringAlertActions' => [ 'base' => '<p>A list of alert actions taken in response to an alert going into <code>InAlert</code> status.</p>', 'refs' => [ 'MonitoringAlertSummary$Actions' => '<p>A list of alert actions taken in response to an alert going into <code>InAlert</code> status.</p>', ], ], 'MonitoringAlertHistoryList' => [ 'base' => NULL, 'refs' => [ 'ListMonitoringAlertHistoryResponse$MonitoringAlertHistory' => '<p>An alert history for a model monitoring schedule.</p>', ], ], 'MonitoringAlertHistorySortKey' => [ 'base' => NULL, 'refs' => [ 'ListMonitoringAlertHistoryRequest$SortBy' => '<p>The field used to sort results. The default is <code>CreationTime</code>.</p>', ], ], 'MonitoringAlertHistorySummary' => [ 'base' => '<p>Provides summary information of an alert\'s history.</p>', 'refs' => [ 'MonitoringAlertHistoryList$member' => NULL, ], ], 'MonitoringAlertName' => [ 'base' => NULL, 'refs' => [ 'ListMonitoringAlertHistoryRequest$MonitoringAlertName' => '<p>The name of a monitoring alert.</p>', 'MonitoringAlertHistorySummary$MonitoringAlertName' => '<p>The name of a monitoring alert.</p>', 'MonitoringAlertSummary$MonitoringAlertName' => '<p>The name of a monitoring alert.</p>', 'UpdateMonitoringAlertRequest$MonitoringAlertName' => '<p>The name of a monitoring alert.</p>', 'UpdateMonitoringAlertResponse$MonitoringAlertName' => '<p>The name of a monitoring alert.</p>', ], ], 'MonitoringAlertStatus' => [ 'base' => NULL, 'refs' => [ 'ListMonitoringAlertHistoryRequest$StatusEquals' => '<p>A filter that retrieves only alerts with a specific status.</p>', 'MonitoringAlertHistorySummary$AlertStatus' => '<p>The current alert status of an alert.</p>', 'MonitoringAlertSummary$AlertStatus' => '<p>The current status of an alert.</p>', ], ], 'MonitoringAlertSummary' => [ 'base' => '<p>Provides summary information about a monitor alert.</p>', 'refs' => [ 'MonitoringAlertSummaryList$member' => NULL, ], ], 'MonitoringAlertSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListMonitoringAlertsResponse$MonitoringAlertSummaries' => '<p>A JSON array where each element is a summary for a monitoring alert.</p>', 'ModelDashboardMonitoringSchedule$MonitoringAlertSummaries' => '<p>A JSON array where each element is a summary for a monitoring alert.</p>', ], ], 'MonitoringAppSpecification' => [ 'base' => '<p>Container image configuration object for the monitoring job.</p>', 'refs' => [ 'MonitoringJobDefinition$MonitoringAppSpecification' => '<p>Configures the monitoring job to run a specified Docker container image.</p>', ], ], 'MonitoringBaselineConfig' => [ 'base' => '<p>Configuration for monitoring constraints and monitoring statistics. These baseline resources are compared against the results of the current job from the series of jobs scheduled to collect data periodically.</p>', 'refs' => [ 'MonitoringJobDefinition$BaselineConfig' => '<p>Baseline configuration used to validate that the data conforms to the specified constraints and statistics</p>', ], ], 'MonitoringClusterConfig' => [ 'base' => '<p>Configuration for the cluster used to run model monitoring jobs.</p>', 'refs' => [ 'MonitoringResources$ClusterConfig' => '<p>The configuration for the cluster resources used to run the processing job.</p>', ], ], 'MonitoringConstraintsResource' => [ 'base' => '<p>The constraints resource for a monitoring job.</p>', 'refs' => [ 'DataQualityBaselineConfig$ConstraintsResource' => NULL, 'ModelBiasBaselineConfig$ConstraintsResource' => NULL, 'ModelExplainabilityBaselineConfig$ConstraintsResource' => NULL, 'ModelQualityBaselineConfig$ConstraintsResource' => NULL, 'MonitoringBaselineConfig$ConstraintsResource' => '<p>The baseline constraint file in Amazon S3 that the current monitoring job should validated against.</p>', ], ], 'MonitoringContainerArguments' => [ 'base' => NULL, 'refs' => [ 'DataQualityAppSpecification$ContainerArguments' => '<p>The arguments to send to the container that the monitoring job runs.</p>', 'ModelQualityAppSpecification$ContainerArguments' => '<p>An array of arguments for the container used to run the monitoring job.</p>', 'MonitoringAppSpecification$ContainerArguments' => '<p>An array of arguments for the container used to run the monitoring job.</p>', ], ], 'MonitoringCsvDatasetFormat' => [ 'base' => '<p>Represents the CSV dataset format used when running a monitoring job.</p>', 'refs' => [ 'MonitoringDatasetFormat$Csv' => '<p>The CSV dataset used in the monitoring job.</p>', ], ], 'MonitoringDatapointsToAlert' => [ 'base' => NULL, 'refs' => [ 'MonitoringAlertSummary$DatapointsToAlert' => '<p>Within <code>EvaluationPeriod</code>, how many execution failures will raise an alert.</p>', 'UpdateMonitoringAlertRequest$DatapointsToAlert' => '<p>Within <code>EvaluationPeriod</code>, how many execution failures will raise an alert.</p>', ], ], 'MonitoringDatasetFormat' => [ 'base' => '<p>Represents the dataset format used when running a monitoring job.</p>', 'refs' => [ 'BatchTransformInput$DatasetFormat' => '<p>The dataset format for your batch transform job.</p>', ], ], 'MonitoringEnvironmentMap' => [ 'base' => NULL, 'refs' => [ 'DataQualityAppSpecification$Environment' => '<p>Sets the environment variables in the container that the monitoring job runs.</p>', 'ModelBiasAppSpecification$Environment' => '<p>Sets the environment variables in the Docker container.</p>', 'ModelExplainabilityAppSpecification$Environment' => '<p>Sets the environment variables in the Docker container.</p>', 'ModelQualityAppSpecification$Environment' => '<p>Sets the environment variables in the container that the monitoring job runs.</p>', 'MonitoringJobDefinition$Environment' => '<p>Sets the environment variables in the Docker container.</p>', ], ], 'MonitoringEvaluationPeriod' => [ 'base' => NULL, 'refs' => [ 'MonitoringAlertSummary$EvaluationPeriod' => '<p>The number of most recent monitoring executions to consider when evaluating alert status.</p>', 'UpdateMonitoringAlertRequest$EvaluationPeriod' => '<p>The number of most recent monitoring executions to consider when evaluating alert status.</p>', ], ], 'MonitoringExecutionSortKey' => [ 'base' => NULL, 'refs' => [ 'ListMonitoringExecutionsRequest$SortBy' => '<p>Whether to sort the results by the <code>Status</code>, <code>CreationTime</code>, or <code>ScheduledTime</code> field. The default is <code>CreationTime</code>.</p>', ], ], 'MonitoringExecutionSummary' => [ 'base' => '<p>Summary of information about the last monitoring job to run.</p>', 'refs' => [ 'DescribeMonitoringScheduleResponse$LastMonitoringExecutionSummary' => '<p>Describes metadata on the last execution to run, if there was one.</p>', 'ModelDashboardMonitoringSchedule$LastMonitoringExecutionSummary' => NULL, 'MonitoringExecutionSummaryList$member' => NULL, 'MonitoringSchedule$LastMonitoringExecutionSummary' => NULL, ], ], 'MonitoringExecutionSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListMonitoringExecutionsResponse$MonitoringExecutionSummaries' => '<p>A JSON array in which each element is a summary for a monitoring execution.</p>', ], ], 'MonitoringGroundTruthS3Input' => [ 'base' => '<p>The ground truth labels for the dataset used for the monitoring job.</p>', 'refs' => [ 'ModelBiasJobInput$GroundTruthS3Input' => '<p>Location of ground truth labels to use in model bias job.</p>', 'ModelQualityJobInput$GroundTruthS3Input' => '<p>The ground truth label provided for the model.</p>', ], ], 'MonitoringInput' => [ 'base' => '<p>The inputs for a monitoring job.</p>', 'refs' => [ 'MonitoringInputs$member' => NULL, ], ], 'MonitoringInputs' => [ 'base' => NULL, 'refs' => [ 'MonitoringJobDefinition$MonitoringInputs' => '<p>The array of inputs for the monitoring job. Currently we support monitoring an Amazon SageMaker Endpoint.</p>', ], ], 'MonitoringJobDefinition' => [ 'base' => '<p>Defines the monitoring job.</p>', 'refs' => [ 'MonitoringScheduleConfig$MonitoringJobDefinition' => '<p>Defines the monitoring job.</p>', ], ], 'MonitoringJobDefinitionArn' => [ 'base' => NULL, 'refs' => [ 'CreateDataQualityJobDefinitionResponse$JobDefinitionArn' => '<p>The Amazon Resource Name (ARN) of the job definition.</p>', 'CreateModelBiasJobDefinitionResponse$JobDefinitionArn' => '<p>The Amazon Resource Name (ARN) of the model bias job.</p>', 'CreateModelExplainabilityJobDefinitionResponse$JobDefinitionArn' => '<p>The Amazon Resource Name (ARN) of the model explainability job.</p>', 'CreateModelQualityJobDefinitionResponse$JobDefinitionArn' => '<p>The Amazon Resource Name (ARN) of the model quality monitoring job.</p>', 'DescribeDataQualityJobDefinitionResponse$JobDefinitionArn' => '<p>The Amazon Resource Name (ARN) of the data quality monitoring job definition.</p>', 'DescribeModelBiasJobDefinitionResponse$JobDefinitionArn' => '<p>The Amazon Resource Name (ARN) of the model bias job.</p>', 'DescribeModelExplainabilityJobDefinitionResponse$JobDefinitionArn' => '<p>The Amazon Resource Name (ARN) of the model explainability job.</p>', 'DescribeModelQualityJobDefinitionResponse$JobDefinitionArn' => '<p>The Amazon Resource Name (ARN) of the model quality job.</p>', 'MonitoringJobDefinitionSummary$MonitoringJobDefinitionArn' => '<p>The Amazon Resource Name (ARN) of the monitoring job.</p>', ], ], 'MonitoringJobDefinitionName' => [ 'base' => NULL, 'refs' => [ 'CreateDataQualityJobDefinitionRequest$JobDefinitionName' => '<p>The name for the monitoring job definition.</p>', 'CreateModelBiasJobDefinitionRequest$JobDefinitionName' => '<p>The name of the bias job definition. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>', 'CreateModelExplainabilityJobDefinitionRequest$JobDefinitionName' => '<p> The name of the model explainability job definition. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>', 'CreateModelQualityJobDefinitionRequest$JobDefinitionName' => '<p>The name of the monitoring job definition.</p>', 'DeleteDataQualityJobDefinitionRequest$JobDefinitionName' => '<p>The name of the data quality monitoring job definition to delete.</p>', 'DeleteModelBiasJobDefinitionRequest$JobDefinitionName' => '<p>The name of the model bias job definition to delete.</p>', 'DeleteModelExplainabilityJobDefinitionRequest$JobDefinitionName' => '<p>The name of the model explainability job definition to delete.</p>', 'DeleteModelQualityJobDefinitionRequest$JobDefinitionName' => '<p>The name of the model quality monitoring job definition to delete.</p>', 'DescribeDataQualityJobDefinitionRequest$JobDefinitionName' => '<p>The name of the data quality monitoring job definition to describe.</p>', 'DescribeDataQualityJobDefinitionResponse$JobDefinitionName' => '<p>The name of the data quality monitoring job definition.</p>', 'DescribeModelBiasJobDefinitionRequest$JobDefinitionName' => '<p>The name of the model bias job definition. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>', 'DescribeModelBiasJobDefinitionResponse$JobDefinitionName' => '<p>The name of the bias job definition. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>', 'DescribeModelExplainabilityJobDefinitionRequest$JobDefinitionName' => '<p>The name of the model explainability job definition. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>', 'DescribeModelExplainabilityJobDefinitionResponse$JobDefinitionName' => '<p>The name of the explainability job definition. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>', 'DescribeModelQualityJobDefinitionRequest$JobDefinitionName' => '<p>The name of the model quality job. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>', 'DescribeModelQualityJobDefinitionResponse$JobDefinitionName' => '<p>The name of the quality job definition. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>', 'ListMonitoringExecutionsRequest$MonitoringJobDefinitionName' => '<p>Gets a list of the monitoring job runs of the specified monitoring job definitions.</p>', 'ListMonitoringSchedulesRequest$MonitoringJobDefinitionName' => '<p>Gets a list of the monitoring schedules for the specified monitoring job definition.</p>', 'MonitoringExecutionSummary$MonitoringJobDefinitionName' => '<p>The name of the monitoring job.</p>', 'MonitoringJobDefinitionSummary$MonitoringJobDefinitionName' => '<p>The name of the monitoring job.</p>', 'MonitoringScheduleConfig$MonitoringJobDefinitionName' => '<p>The name of the monitoring job definition to schedule.</p>', 'MonitoringScheduleSummary$MonitoringJobDefinitionName' => '<p>The name of the monitoring job definition that the schedule is for.</p>', ], ], 'MonitoringJobDefinitionSortKey' => [ 'base' => NULL, 'refs' => [ 'ListDataQualityJobDefinitionsRequest$SortBy' => '<p>The field to sort results by. The default is <code>CreationTime</code>.</p>', 'ListModelBiasJobDefinitionsRequest$SortBy' => '<p>Whether to sort results by the <code>Name</code> or <code>CreationTime</code> field. The default is <code>CreationTime</code>.</p>', 'ListModelExplainabilityJobDefinitionsRequest$SortBy' => '<p>Whether to sort results by the <code>Name</code> or <code>CreationTime</code> field. The default is <code>CreationTime</code>.</p>', 'ListModelQualityJobDefinitionsRequest$SortBy' => '<p>The field to sort results by. The default is <code>CreationTime</code>.</p>', ], ], 'MonitoringJobDefinitionSummary' => [ 'base' => '<p>Summary information about a monitoring job.</p>', 'refs' => [ 'MonitoringJobDefinitionSummaryList$member' => NULL, ], ], 'MonitoringJobDefinitionSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListDataQualityJobDefinitionsResponse$JobDefinitionSummaries' => '<p>A list of data quality monitoring job definitions.</p>', 'ListModelBiasJobDefinitionsResponse$JobDefinitionSummaries' => '<p>A JSON array in which each element is a summary for a model bias jobs.</p>', 'ListModelExplainabilityJobDefinitionsResponse$JobDefinitionSummaries' => '<p>A JSON array in which each element is a summary for a explainability bias jobs.</p>', 'ListModelQualityJobDefinitionsResponse$JobDefinitionSummaries' => '<p>A list of summaries of model quality monitoring job definitions.</p>', ], ], 'MonitoringJsonDatasetFormat' => [ 'base' => '<p>Represents the JSON dataset format used when running a monitoring job.</p>', 'refs' => [ 'MonitoringDatasetFormat$Json' => '<p>The JSON dataset used in the monitoring job</p>', ], ], 'MonitoringMaxRuntimeInSeconds' => [ 'base' => NULL, 'refs' => [ 'MonitoringStoppingCondition$MaxRuntimeInSeconds' => '<p>The maximum runtime allowed in seconds.</p> <note> <p>The <code>MaxRuntimeInSeconds</code> cannot exceed the frequency of the job. For data quality and model explainability, this can be up to 3600 seconds for an hourly schedule. For model bias and model quality hourly schedules, this can be up to 1800 seconds.</p> </note>', ], ], 'MonitoringNetworkConfig' => [ 'base' => '<p>The networking configuration for the monitoring job.</p>', 'refs' => [ 'CreateDataQualityJobDefinitionRequest$NetworkConfig' => '<p>Specifies networking configuration for the monitoring job.</p>', 'CreateModelBiasJobDefinitionRequest$NetworkConfig' => '<p>Networking options for a model bias job.</p>', 'CreateModelExplainabilityJobDefinitionRequest$NetworkConfig' => '<p>Networking options for a model explainability job.</p>', 'CreateModelQualityJobDefinitionRequest$NetworkConfig' => '<p>Specifies the network configuration for the monitoring job.</p>', 'DescribeDataQualityJobDefinitionResponse$NetworkConfig' => '<p>The networking configuration for the data quality monitoring job.</p>', 'DescribeModelBiasJobDefinitionResponse$NetworkConfig' => '<p>Networking options for a model bias job.</p>', 'DescribeModelExplainabilityJobDefinitionResponse$NetworkConfig' => '<p>Networking options for a model explainability job.</p>', 'DescribeModelQualityJobDefinitionResponse$NetworkConfig' => '<p>Networking options for a model quality job.</p>', ], ], 'MonitoringOutput' => [ 'base' => '<p>The output object for a monitoring job.</p>', 'refs' => [ 'MonitoringOutputs$member' => NULL, ], ], 'MonitoringOutputConfig' => [ 'base' => '<p>The output configuration for monitoring jobs.</p>', 'refs' => [ 'CreateDataQualityJobDefinitionRequest$DataQualityJobOutputConfig' => NULL, 'CreateModelBiasJobDefinitionRequest$ModelBiasJobOutputConfig' => NULL, 'CreateModelExplainabilityJobDefinitionRequest$ModelExplainabilityJobOutputConfig' => NULL, 'CreateModelQualityJobDefinitionRequest$ModelQualityJobOutputConfig' => NULL, 'DescribeDataQualityJobDefinitionResponse$DataQualityJobOutputConfig' => NULL, 'DescribeModelBiasJobDefinitionResponse$ModelBiasJobOutputConfig' => NULL, 'DescribeModelExplainabilityJobDefinitionResponse$ModelExplainabilityJobOutputConfig' => NULL, 'DescribeModelQualityJobDefinitionResponse$ModelQualityJobOutputConfig' => NULL, 'MonitoringJobDefinition$MonitoringOutputConfig' => '<p>The array of outputs from the monitoring job to be uploaded to Amazon S3.</p>', ], ], 'MonitoringOutputs' => [ 'base' => NULL, 'refs' => [ 'MonitoringOutputConfig$MonitoringOutputs' => '<p>Monitoring outputs for monitoring jobs. This is where the output of the periodic monitoring jobs is uploaded.</p>', ], ], 'MonitoringParquetDatasetFormat' => [ 'base' => '<p>Represents the Parquet dataset format used when running a monitoring job.</p>', 'refs' => [ 'MonitoringDatasetFormat$Parquet' => '<p>The Parquet dataset used in the monitoring job</p>', ], ], 'MonitoringProblemType' => [ 'base' => NULL, 'refs' => [ 'ModelQualityAppSpecification$ProblemType' => '<p>The machine learning problem type of the model that the monitoring job monitors.</p>', ], ], 'MonitoringResources' => [ 'base' => '<p>Identifies the resources to deploy for a monitoring job.</p>', 'refs' => [ 'CreateDataQualityJobDefinitionRequest$JobResources' => NULL, 'CreateModelBiasJobDefinitionRequest$JobResources' => NULL, 'CreateModelExplainabilityJobDefinitionRequest$JobResources' => NULL, 'CreateModelQualityJobDefinitionRequest$JobResources' => NULL, 'DescribeDataQualityJobDefinitionResponse$JobResources' => NULL, 'DescribeModelBiasJobDefinitionResponse$JobResources' => NULL, 'DescribeModelExplainabilityJobDefinitionResponse$JobResources' => NULL, 'DescribeModelQualityJobDefinitionResponse$JobResources' => NULL, 'MonitoringJobDefinition$MonitoringResources' => '<p>Identifies the resources, ML compute instances, and ML storage volumes to deploy for a monitoring job. In distributed processing, you specify more than one instance.</p>', ], ], 'MonitoringS3Output' => [ 'base' => '<p>Information about where and how you want to store the results of a monitoring job.</p>', 'refs' => [ 'MonitoringOutput$S3Output' => '<p>The Amazon S3 storage location where the results of a monitoring job are saved.</p>', ], ], 'MonitoringS3Uri' => [ 'base' => NULL, 'refs' => [ 'MonitoringGroundTruthS3Input$S3Uri' => '<p>The address of the Amazon S3 location of the ground truth labels.</p>', 'MonitoringS3Output$S3Uri' => '<p>A URI that identifies the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job.</p>', ], ], 'MonitoringSchedule' => [ 'base' => '<p>A schedule for a model monitoring job. For information about model monitor, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html">Amazon SageMaker Model Monitor</a>.</p>', 'refs' => [ 'MonitoringScheduleList$member' => NULL, ], ], 'MonitoringScheduleArn' => [ 'base' => NULL, 'refs' => [ 'CreateMonitoringScheduleResponse$MonitoringScheduleArn' => '<p>The Amazon Resource Name (ARN) of the monitoring schedule.</p>', 'DescribeMonitoringScheduleResponse$MonitoringScheduleArn' => '<p>The Amazon Resource Name (ARN) of the monitoring schedule.</p>', 'DescribeProcessingJobResponse$MonitoringScheduleArn' => '<p>The ARN of a monitoring schedule for an endpoint associated with this processing job.</p>', 'ModelDashboardMonitoringSchedule$MonitoringScheduleArn' => '<p>The Amazon Resource Name (ARN) of a monitoring schedule.</p>', 'MonitoringSchedule$MonitoringScheduleArn' => '<p>The Amazon Resource Name (ARN) of the monitoring schedule.</p>', 'MonitoringScheduleSummary$MonitoringScheduleArn' => '<p>The Amazon Resource Name (ARN) of the monitoring schedule.</p>', 'ProcessingJob$MonitoringScheduleArn' => '<p>The ARN of a monitoring schedule for an endpoint associated with this processing job.</p>', 'UpdateMonitoringAlertResponse$MonitoringScheduleArn' => '<p>The Amazon Resource Name (ARN) of the monitoring schedule.</p>', 'UpdateMonitoringScheduleResponse$MonitoringScheduleArn' => '<p>The Amazon Resource Name (ARN) of the monitoring schedule.</p>', ], ], 'MonitoringScheduleConfig' => [ 'base' => '<p>Configures the monitoring schedule and defines the monitoring job.</p>', 'refs' => [ 'CreateMonitoringScheduleRequest$MonitoringScheduleConfig' => '<p>The configuration object that specifies the monitoring schedule and defines the monitoring job.</p>', 'DescribeMonitoringScheduleResponse$MonitoringScheduleConfig' => '<p>The configuration object that specifies the monitoring schedule and defines the monitoring job.</p>', 'ModelDashboardMonitoringSchedule$MonitoringScheduleConfig' => NULL, 'MonitoringSchedule$MonitoringScheduleConfig' => NULL, 'UpdateMonitoringScheduleRequest$MonitoringScheduleConfig' => '<p>The configuration object that specifies the monitoring schedule and defines the monitoring job.</p>', ], ], 'MonitoringScheduleList' => [ 'base' => NULL, 'refs' => [ 'Endpoint$MonitoringSchedules' => '<p>A list of monitoring schedules for the endpoint. For information about model monitoring, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html">Amazon SageMaker Model Monitor</a>.</p>', ], ], 'MonitoringScheduleName' => [ 'base' => NULL, 'refs' => [ 'CreateMonitoringScheduleRequest$MonitoringScheduleName' => '<p>The name of the monitoring schedule. The name must be unique within an Amazon Web Services Region within an Amazon Web Services account.</p>', 'DeleteMonitoringScheduleRequest$MonitoringScheduleName' => '<p>The name of the monitoring schedule to delete.</p>', 'DescribeMonitoringScheduleRequest$MonitoringScheduleName' => '<p>Name of a previously created monitoring schedule.</p>', 'DescribeMonitoringScheduleResponse$MonitoringScheduleName' => '<p>Name of the monitoring schedule.</p>', 'ListMonitoringAlertHistoryRequest$MonitoringScheduleName' => '<p>The name of a monitoring schedule.</p>', 'ListMonitoringAlertsRequest$MonitoringScheduleName' => '<p>The name of a monitoring schedule.</p>', 'ListMonitoringExecutionsRequest$MonitoringScheduleName' => '<p>Name of a specific schedule to fetch jobs for.</p>', 'ModelDashboardMonitoringSchedule$MonitoringScheduleName' => '<p>The name of a monitoring schedule.</p>', 'MonitoringAlertHistorySummary$MonitoringScheduleName' => '<p>The name of a monitoring schedule.</p>', 'MonitoringExecutionSummary$MonitoringScheduleName' => '<p>The name of the monitoring schedule.</p>', 'MonitoringSchedule$MonitoringScheduleName' => '<p>The name of the monitoring schedule.</p>', 'MonitoringScheduleSummary$MonitoringScheduleName' => '<p>The name of the monitoring schedule.</p>', 'StartMonitoringScheduleRequest$MonitoringScheduleName' => '<p>The name of the schedule to start.</p>', 'StopMonitoringScheduleRequest$MonitoringScheduleName' => '<p>The name of the schedule to stop.</p>', 'UpdateMonitoringAlertRequest$MonitoringScheduleName' => '<p>The name of a monitoring schedule.</p>', 'UpdateMonitoringScheduleRequest$MonitoringScheduleName' => '<p>The name of the monitoring schedule. The name must be unique within an Amazon Web Services Region within an Amazon Web Services account.</p>', ], ], 'MonitoringScheduleSortKey' => [ 'base' => NULL, 'refs' => [ 'ListMonitoringSchedulesRequest$SortBy' => '<p>Whether to sort the results by the <code>Status</code>, <code>CreationTime</code>, or <code>ScheduledTime</code> field. The default is <code>CreationTime</code>.</p>', ], ], 'MonitoringScheduleSummary' => [ 'base' => '<p>Summarizes the monitoring schedule.</p>', 'refs' => [ 'MonitoringScheduleSummaryList$member' => NULL, ], ], 'MonitoringScheduleSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListMonitoringSchedulesResponse$MonitoringScheduleSummaries' => '<p>A JSON array in which each element is a summary for a monitoring schedule.</p>', ], ], 'MonitoringStatisticsResource' => [ 'base' => '<p>The statistics resource for a monitoring job.</p>', 'refs' => [ 'DataQualityBaselineConfig$StatisticsResource' => NULL, 'MonitoringBaselineConfig$StatisticsResource' => '<p>The baseline statistics file in Amazon S3 that the current monitoring job should be validated against.</p>', ], ], 'MonitoringStoppingCondition' => [ 'base' => '<p>A time limit for how long the monitoring job is allowed to run before stopping.</p>', 'refs' => [ 'CreateDataQualityJobDefinitionRequest$StoppingCondition' => NULL, 'CreateModelBiasJobDefinitionRequest$StoppingCondition' => NULL, 'CreateModelExplainabilityJobDefinitionRequest$StoppingCondition' => NULL, 'CreateModelQualityJobDefinitionRequest$StoppingCondition' => NULL, 'DescribeDataQualityJobDefinitionResponse$StoppingCondition' => NULL, 'DescribeModelBiasJobDefinitionResponse$StoppingCondition' => NULL, 'DescribeModelExplainabilityJobDefinitionResponse$StoppingCondition' => NULL, 'DescribeModelQualityJobDefinitionResponse$StoppingCondition' => NULL, 'MonitoringJobDefinition$StoppingCondition' => '<p>Specifies a time limit for how long the monitoring job is allowed to run.</p>', ], ], 'MonitoringTimeOffsetString' => [ 'base' => NULL, 'refs' => [ 'BatchTransformInput$StartTimeOffset' => '<p>If specified, monitoring jobs substract this time from the start time. For information about using offsets for scheduling monitoring jobs, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-model-quality-schedule.html">Schedule Model Quality Monitoring Jobs</a>.</p>', 'BatchTransformInput$EndTimeOffset' => '<p>If specified, monitoring jobs subtract this time from the end time. For information about using offsets for scheduling monitoring jobs, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-model-quality-schedule.html">Schedule Model Quality Monitoring Jobs</a>.</p>', 'EndpointInput$StartTimeOffset' => '<p>If specified, monitoring jobs substract this time from the start time. For information about using offsets for scheduling monitoring jobs, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-model-quality-schedule.html">Schedule Model Quality Monitoring Jobs</a>.</p>', 'EndpointInput$EndTimeOffset' => '<p>If specified, monitoring jobs substract this time from the end time. For information about using offsets for scheduling monitoring jobs, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-model-quality-schedule.html">Schedule Model Quality Monitoring Jobs</a>.</p>', ], ], 'MonitoringType' => [ 'base' => NULL, 'refs' => [ 'DescribeMonitoringScheduleResponse$MonitoringType' => '<p>The type of the monitoring job that this schedule runs. This is one of the following values.</p> <ul> <li> <p> <code>DATA_QUALITY</code> - The schedule is for a data quality monitoring job.</p> </li> <li> <p> <code>MODEL_QUALITY</code> - The schedule is for a model quality monitoring job.</p> </li> <li> <p> <code>MODEL_BIAS</code> - The schedule is for a bias monitoring job.</p> </li> <li> <p> <code>MODEL_EXPLAINABILITY</code> - The schedule is for an explainability monitoring job.</p> </li> </ul>', 'ListMonitoringExecutionsRequest$MonitoringTypeEquals' => '<p>A filter that returns only the monitoring job runs of the specified monitoring type.</p>', 'ListMonitoringSchedulesRequest$MonitoringTypeEquals' => '<p>A filter that returns only the monitoring schedules for the specified monitoring type.</p>', 'ModelDashboardMonitoringSchedule$MonitoringType' => '<p>The monitor type of a model monitor.</p>', 'MonitoringExecutionSummary$MonitoringType' => '<p>The type of the monitoring job.</p>', 'MonitoringSchedule$MonitoringType' => '<p>The type of the monitoring job definition to schedule.</p>', 'MonitoringScheduleConfig$MonitoringType' => '<p>The type of the monitoring job definition to schedule.</p>', 'MonitoringScheduleSummary$MonitoringType' => '<p>The type of the monitoring job definition that the schedule is for.</p>', ], ], 'MountPath' => [ 'base' => NULL, 'refs' => [ 'FileSystemConfig$MountPath' => '<p>The path within the image to mount the user\'s EFS home directory. The directory should be empty. If not specified, defaults to <i>/home/sagemaker-user</i>.</p>', ], ], 'MultiModelConfig' => [ 'base' => '<p>Specifies additional configuration for hosting multi-model endpoints.</p>', 'refs' => [ 'ContainerDefinition$MultiModelConfig' => '<p>Specifies additional configuration for multi-model endpoints.</p>', ], ], 'NameContains' => [ 'base' => NULL, 'refs' => [ 'ListAlgorithmsInput$NameContains' => '<p>A string in the algorithm name. This filter returns only algorithms whose name contains the specified string.</p>', 'ListClustersRequest$NameContains' => '<p>Set the maximum number of instances to print in the list.</p>', 'ListCompilationJobsRequest$NameContains' => '<p>A filter that returns the model compilation jobs whose name contains a specified string.</p>', 'ListDataQualityJobDefinitionsRequest$NameContains' => '<p>A string in the data quality monitoring job definition name. This filter returns only data quality monitoring job definitions whose name contains the specified string.</p>', 'ListDeviceFleetsRequest$NameContains' => '<p>Filter for fleets containing this name in their fleet device name.</p>', 'ListEdgeDeploymentPlansRequest$NameContains' => '<p>Selects edge deployment plans with names containing this name.</p>', 'ListEdgeDeploymentPlansRequest$DeviceFleetNameContains' => '<p>Selects edge deployment plans with a device fleet name containing this name.</p>', 'ListEdgePackagingJobsRequest$NameContains' => '<p>Filter for jobs containing this name in their packaging job name.</p>', 'ListEdgePackagingJobsRequest$ModelNameContains' => '<p>Filter for jobs where the model name contains this string.</p>', 'ListHubContentsRequest$NameContains' => '<p>Only list hub content if the name contains the specified string.</p>', 'ListHubsRequest$NameContains' => '<p>Only list hubs with names that contain the specified string.</p>', 'ListHyperParameterTuningJobsRequest$NameContains' => '<p>A string in the tuning job name. This filter returns only tuning jobs whose name contains the specified string.</p>', 'ListInferenceExperimentsRequest$NameContains' => '<p>Selects inference experiments whose names contain this name.</p>', 'ListInferenceRecommendationsJobsRequest$NameContains' => '<p>A string in the job name. This filter returns only recommendations whose name contains the specified string.</p>', 'ListLabelingJobsRequest$NameContains' => '<p>A string in the labeling job name. This filter returns only labeling jobs whose name contains the specified string.</p>', 'ListModelBiasJobDefinitionsRequest$NameContains' => '<p>Filter for model bias jobs whose name contains a specified string.</p>', 'ListModelExplainabilityJobDefinitionsRequest$NameContains' => '<p>Filter for model explainability jobs whose name contains a specified string.</p>', 'ListModelPackageGroupsInput$NameContains' => '<p>A string in the model group name. This filter returns only model groups whose name contains the specified string.</p>', 'ListModelPackagesInput$NameContains' => '<p>A string in the model package name. This filter returns only model packages whose name contains the specified string.</p>', 'ListModelQualityJobDefinitionsRequest$NameContains' => '<p>A string in the transform job name. This filter returns only model quality monitoring job definitions whose name contains the specified string.</p>', 'ListMonitoringSchedulesRequest$NameContains' => '<p>Filter for monitoring schedules whose name contains a specified string.</p>', 'ListOptimizationJobsRequest$OptimizationContains' => '<p>Filters the results to only those optimization jobs that apply the specified optimization techniques. You can specify either <code>Quantization</code> or <code>Compilation</code>.</p>', 'ListOptimizationJobsRequest$NameContains' => '<p>Filters the results to only those optimization jobs with a name that contains the specified string.</p>', 'ListTrainingJobsRequest$NameContains' => '<p>A string in the training job name. This filter returns only training jobs whose name contains the specified string.</p>', 'ListTransformJobsRequest$NameContains' => '<p>A string in the transform job name. This filter returns only transform jobs whose name contains the specified string.</p>', ], ], 'NeoVpcConfig' => [ 'base' => '<p>The <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_VpcConfig.html">VpcConfig</a> configuration object that specifies the VPC that you want the compilation jobs to connect to. For more information on controlling access to your Amazon S3 buckets used for compilation job, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/neo-vpc.html">Give Amazon SageMaker Compilation Jobs Access to Resources in Your Amazon VPC</a>.</p>', 'refs' => [ 'CreateCompilationJobRequest$VpcConfig' => '<p>A <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_VpcConfig.html">VpcConfig</a> object that specifies the VPC that you want your compilation job to connect to. Control access to your models by configuring the VPC. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/neo-vpc.html">Protect Compilation Jobs by Using an Amazon Virtual Private Cloud</a>.</p>', 'DescribeCompilationJobResponse$VpcConfig' => '<p>A <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_VpcConfig.html">VpcConfig</a> object that specifies the VPC that you want your compilation job to connect to. Control access to your models by configuring the VPC. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/neo-vpc.html">Protect Compilation Jobs by Using an Amazon Virtual Private Cloud</a>.</p>', ], ], 'NeoVpcSecurityGroupId' => [ 'base' => NULL, 'refs' => [ 'NeoVpcSecurityGroupIds$member' => NULL, ], ], 'NeoVpcSecurityGroupIds' => [ 'base' => NULL, 'refs' => [ 'NeoVpcConfig$SecurityGroupIds' => '<p>The VPC security group IDs. IDs have the form of <code>sg-xxxxxxxx</code>. Specify the security groups for the VPC that is specified in the <code>Subnets</code> field.</p>', ], ], 'NeoVpcSubnetId' => [ 'base' => NULL, 'refs' => [ 'NeoVpcSubnets$member' => NULL, ], ], 'NeoVpcSubnets' => [ 'base' => NULL, 'refs' => [ 'NeoVpcConfig$Subnets' => '<p>The ID of the subnets in the VPC that you want to connect the compilation job to for accessing the model in Amazon S3.</p>', ], ], 'NestedFilters' => [ 'base' => '<p>A list of nested <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Filter.html">Filter</a> objects. A resource must satisfy the conditions of all filters to be included in the results returned from the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html">Search</a> API.</p> <p>For example, to filter on a training job\'s <code>InputDataConfig</code> property with a specific channel name and <code>S3Uri</code> prefix, define the following filters:</p> <ul> <li> <p> <code>\'{Name:"InputDataConfig.ChannelName", "Operator":"Equals", "Value":"train"}\',</code> </p> </li> <li> <p> <code>\'{Name:"InputDataConfig.DataSource.S3DataSource.S3Uri", "Operator":"Contains", "Value":"mybucket/catdata"}\'</code> </p> </li> </ul>', 'refs' => [ 'NestedFiltersList$member' => NULL, ], ], 'NestedFiltersList' => [ 'base' => NULL, 'refs' => [ 'SearchExpression$NestedFilters' => '<p>A list of nested filter objects.</p>', ], ], 'NetworkConfig' => [ 'base' => '<p>Networking options for a job, such as network traffic encryption between containers, whether to allow inbound and outbound network calls to and from containers, and the VPC subnets and security groups to use for VPC-enabled jobs.</p>', 'refs' => [ 'CreateProcessingJobRequest$NetworkConfig' => '<p>Networking options for a processing job, such as whether to allow inbound and outbound network calls to and from processing containers, and the VPC subnets and security groups to use for VPC-enabled processing jobs.</p>', 'DescribeProcessingJobResponse$NetworkConfig' => '<p>Networking options for a processing job.</p>', 'MonitoringJobDefinition$NetworkConfig' => '<p>Specifies networking options for an monitoring job.</p>', 'ProcessingJob$NetworkConfig' => NULL, ], ], 'NetworkInterfaceId' => [ 'base' => NULL, 'refs' => [ 'DescribeNotebookInstanceOutput$NetworkInterfaceId' => '<p>The network interface IDs that SageMaker created at the time of creating the instance. </p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'DescribeDeviceRequest$NextToken' => '<p>Next token of device description.</p>', 'DescribeDeviceResponse$NextToken' => '<p>The response from the last list when returning a list large enough to need tokening.</p>', 'DescribeEdgeDeploymentPlanRequest$NextToken' => '<p>If the edge deployment plan has enough stages to require tokening, then this is the response from the last list of stages returned.</p>', 'DescribeEdgeDeploymentPlanResponse$NextToken' => '<p>Token to use when calling the next set of stages in the edge deployment plan.</p>', 'DescribeFeatureGroupRequest$NextToken' => '<p>A token to resume pagination of the list of <code>Features</code> (<code>FeatureDefinitions</code>). 2,500 <code>Features</code> are returned by default.</p>', 'DescribeFeatureGroupResponse$NextToken' => '<p>A token to resume pagination of the list of <code>Features</code> (<code>FeatureDefinitions</code>).</p>', 'ListActionsRequest$NextToken' => '<p>If the previous call to <code>ListActions</code> didn\'t return the full set of actions, the call returns a token for getting the next set of actions.</p>', 'ListActionsResponse$NextToken' => '<p>A token for getting the next set of actions, if there are any.</p>', 'ListAlgorithmsInput$NextToken' => '<p>If the response to a previous <code>ListAlgorithms</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of algorithms, use the token in the next request.</p>', 'ListAlgorithmsOutput$NextToken' => '<p>If the response is truncated, SageMaker returns this token. To retrieve the next set of algorithms, use it in the subsequent request.</p>', 'ListAliasesRequest$NextToken' => '<p>If the previous call to <code>ListAliases</code> didn\'t return the full set of aliases, the call returns a token for retrieving the next set of aliases.</p>', 'ListAliasesResponse$NextToken' => '<p>A token for getting the next set of aliases, if more aliases exist.</p>', 'ListAppImageConfigsRequest$NextToken' => '<p>If the previous call to <code>ListImages</code> didn\'t return the full set of AppImageConfigs, the call returns a token for getting the next set of AppImageConfigs.</p>', 'ListAppImageConfigsResponse$NextToken' => '<p>A token for getting the next set of AppImageConfigs, if there are any.</p>', 'ListAppsRequest$NextToken' => '<p>If the previous response was truncated, you will receive this token. Use it in your next request to receive the next set of results.</p>', 'ListAppsResponse$NextToken' => '<p>If the previous response was truncated, you will receive this token. Use it in your next request to receive the next set of results.</p>', 'ListArtifactsRequest$NextToken' => '<p>If the previous call to <code>ListArtifacts</code> didn\'t return the full set of artifacts, the call returns a token for getting the next set of artifacts.</p>', 'ListArtifactsResponse$NextToken' => '<p>A token for getting the next set of artifacts, if there are any.</p>', 'ListAssociationsRequest$NextToken' => '<p>If the previous call to <code>ListAssociations</code> didn\'t return the full set of associations, the call returns a token for getting the next set of associations.</p>', 'ListAssociationsResponse$NextToken' => '<p>A token for getting the next set of associations, if there are any.</p>', 'ListAutoMLJobsRequest$NextToken' => '<p>If the previous response was truncated, you receive this token. Use it in your next request to receive the next set of results.</p>', 'ListAutoMLJobsResponse$NextToken' => '<p>If the previous response was truncated, you receive this token. Use it in your next request to receive the next set of results.</p>', 'ListCandidatesForAutoMLJobRequest$NextToken' => '<p>If the previous response was truncated, you receive this token. Use it in your next request to receive the next set of results.</p>', 'ListCandidatesForAutoMLJobResponse$NextToken' => '<p>If the previous response was truncated, you receive this token. Use it in your next request to receive the next set of results.</p>', 'ListClusterNodesRequest$NextToken' => '<p>If the result of the previous <code>ListClusterNodes</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of cluster nodes, use the token in the next request.</p>', 'ListClusterNodesResponse$NextToken' => '<p>The next token specified for listing instances in a SageMaker HyperPod cluster.</p>', 'ListClustersRequest$NextToken' => '<p>Set the next token to retrieve the list of SageMaker HyperPod clusters.</p>', 'ListClustersResponse$NextToken' => '<p>If the result of the previous <code>ListClusters</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of clusters, use the token in the next request.</p>', 'ListCodeRepositoriesInput$NextToken' => '<p>If the result of a <code>ListCodeRepositoriesOutput</code> request was truncated, the response includes a <code>NextToken</code>. To get the next set of Git repositories, use the token in the next request.</p>', 'ListCodeRepositoriesOutput$NextToken' => '<p>If the result of a <code>ListCodeRepositoriesOutput</code> request was truncated, the response includes a <code>NextToken</code>. To get the next set of Git repositories, use the token in the next request.</p>', 'ListCompilationJobsRequest$NextToken' => '<p>If the result of the previous <code>ListCompilationJobs</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of model compilation jobs, use the token in the next request.</p>', 'ListCompilationJobsResponse$NextToken' => '<p>If the response is truncated, Amazon SageMaker returns this <code>NextToken</code>. To retrieve the next set of model compilation jobs, use this token in the next request.</p>', 'ListContextsRequest$NextToken' => '<p>If the previous call to <code>ListContexts</code> didn\'t return the full set of contexts, the call returns a token for getting the next set of contexts.</p>', 'ListContextsResponse$NextToken' => '<p>A token for getting the next set of contexts, if there are any.</p>', 'ListDataQualityJobDefinitionsRequest$NextToken' => '<p>If the result of the previous <code>ListDataQualityJobDefinitions</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of transform jobs, use the token in the next request.&gt;</p>', 'ListDataQualityJobDefinitionsResponse$NextToken' => '<p>If the result of the previous <code>ListDataQualityJobDefinitions</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of data quality monitoring job definitions, use the token in the next request.</p>', 'ListDeviceFleetsRequest$NextToken' => '<p>The response from the last list when returning a list large enough to need tokening.</p>', 'ListDeviceFleetsResponse$NextToken' => '<p>The response from the last list when returning a list large enough to need tokening.</p>', 'ListDevicesRequest$NextToken' => '<p>The response from the last list when returning a list large enough to need tokening.</p>', 'ListDevicesResponse$NextToken' => '<p>The response from the last list when returning a list large enough to need tokening.</p>', 'ListDomainsRequest$NextToken' => '<p>If the previous response was truncated, you will receive this token. Use it in your next request to receive the next set of results.</p>', 'ListDomainsResponse$NextToken' => '<p>If the previous response was truncated, you will receive this token. Use it in your next request to receive the next set of results.</p>', 'ListEdgeDeploymentPlansRequest$NextToken' => '<p>The response from the last list when returning a list large enough to need tokening.</p>', 'ListEdgeDeploymentPlansResponse$NextToken' => '<p>The token to use when calling the next page of results.</p>', 'ListEdgePackagingJobsRequest$NextToken' => '<p>The response from the last list when returning a list large enough to need tokening.</p>', 'ListEdgePackagingJobsResponse$NextToken' => '<p>Token to use when calling the next page of results.</p>', 'ListExperimentsRequest$NextToken' => '<p>If the previous call to <code>ListExperiments</code> didn\'t return the full set of experiments, the call returns a token for getting the next set of experiments.</p>', 'ListExperimentsResponse$NextToken' => '<p>A token for getting the next set of experiments, if there are any.</p>', 'ListFeatureGroupsRequest$NextToken' => '<p>A token to resume pagination of <code>ListFeatureGroups</code> results.</p>', 'ListFeatureGroupsResponse$NextToken' => '<p>A token to resume pagination of <code>ListFeatureGroups</code> results.</p>', 'ListFlowDefinitionsRequest$NextToken' => '<p>A token to resume pagination.</p>', 'ListFlowDefinitionsResponse$NextToken' => '<p>A token to resume pagination.</p>', 'ListHubContentVersionsRequest$NextToken' => '<p>If the response to a previous <code>ListHubContentVersions</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of hub content versions, use the token in the next request.</p>', 'ListHubContentVersionsResponse$NextToken' => '<p>If the response is truncated, SageMaker returns this token. To retrieve the next set of hub content versions, use it in the subsequent request.</p>', 'ListHubContentsRequest$NextToken' => '<p>If the response to a previous <code>ListHubContents</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of hub content, use the token in the next request.</p>', 'ListHubContentsResponse$NextToken' => '<p>If the response is truncated, SageMaker returns this token. To retrieve the next set of hub content, use it in the subsequent request.</p>', 'ListHubsRequest$NextToken' => '<p>If the response to a previous <code>ListHubs</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of hubs, use the token in the next request.</p>', 'ListHubsResponse$NextToken' => '<p>If the response is truncated, SageMaker returns this token. To retrieve the next set of hubs, use it in the subsequent request.</p>', 'ListHumanTaskUisRequest$NextToken' => '<p>A token to resume pagination.</p>', 'ListHumanTaskUisResponse$NextToken' => '<p>A token to resume pagination.</p>', 'ListHyperParameterTuningJobsRequest$NextToken' => '<p>If the result of the previous <code>ListHyperParameterTuningJobs</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of tuning jobs, use the token in the next request.</p>', 'ListHyperParameterTuningJobsResponse$NextToken' => '<p>If the result of this <code>ListHyperParameterTuningJobs</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of tuning jobs, use the token in the next request.</p>', 'ListImageVersionsRequest$NextToken' => '<p>If the previous call to <code>ListImageVersions</code> didn\'t return the full set of versions, the call returns a token for getting the next set of versions.</p>', 'ListImageVersionsResponse$NextToken' => '<p>A token for getting the next set of versions, if there are any.</p>', 'ListImagesRequest$NextToken' => '<p>If the previous call to <code>ListImages</code> didn\'t return the full set of images, the call returns a token for getting the next set of images.</p>', 'ListImagesResponse$NextToken' => '<p>A token for getting the next set of images, if there are any.</p>', 'ListInferenceExperimentsRequest$NextToken' => '<p> The response from the last list when returning a list large enough to need tokening. </p>', 'ListInferenceExperimentsResponse$NextToken' => '<p>The token to use when calling the next page of results.</p>', 'ListInferenceRecommendationsJobStepsRequest$NextToken' => '<p>A token that you can specify to return more results from the list. Specify this field if you have a token that was returned from a previous request.</p>', 'ListInferenceRecommendationsJobStepsResponse$NextToken' => '<p>A token that you can specify in your next request to return more results from the list.</p>', 'ListInferenceRecommendationsJobsRequest$NextToken' => '<p>If the response to a previous <code>ListInferenceRecommendationsJobsRequest</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of recommendations, use the token in the next request.</p>', 'ListInferenceRecommendationsJobsResponse$NextToken' => '<p>A token for getting the next set of recommendations, if there are any.</p>', 'ListLabelingJobsForWorkteamRequest$NextToken' => '<p>If the result of the previous <code>ListLabelingJobsForWorkteam</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of labeling jobs, use the token in the next request.</p>', 'ListLabelingJobsForWorkteamResponse$NextToken' => '<p>If the response is truncated, SageMaker returns this token. To retrieve the next set of labeling jobs, use it in the subsequent request.</p>', 'ListLabelingJobsRequest$NextToken' => '<p>If the result of the previous <code>ListLabelingJobs</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of labeling jobs, use the token in the next request.</p>', 'ListLabelingJobsResponse$NextToken' => '<p>If the response is truncated, SageMaker returns this token. To retrieve the next set of labeling jobs, use it in the subsequent request.</p>', 'ListLineageGroupsRequest$NextToken' => '<p>If the response is truncated, SageMaker returns this token. To retrieve the next set of algorithms, use it in the subsequent request.</p>', 'ListLineageGroupsResponse$NextToken' => '<p>If the response is truncated, SageMaker returns this token. To retrieve the next set of algorithms, use it in the subsequent request.</p>', 'ListMlflowTrackingServersRequest$NextToken' => '<p>If the previous response was truncated, you will receive this token. Use it in your next request to receive the next set of results.</p>', 'ListMlflowTrackingServersResponse$NextToken' => '<p>If the previous response was truncated, you will receive this token. Use it in your next request to receive the next set of results.</p>', 'ListModelBiasJobDefinitionsRequest$NextToken' => '<p>The token returned if the response is truncated. To retrieve the next set of job executions, use it in the next request.</p>', 'ListModelBiasJobDefinitionsResponse$NextToken' => '<p>The token returned if the response is truncated. To retrieve the next set of job executions, use it in the next request.</p>', 'ListModelCardExportJobsRequest$NextToken' => '<p>If the response to a previous <code>ListModelCardExportJobs</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of model card export jobs, use the token in the next request.</p>', 'ListModelCardExportJobsResponse$NextToken' => '<p>If the response is truncated, SageMaker returns this token. To retrieve the next set of model card export jobs, use it in the subsequent request.</p>', 'ListModelCardVersionsRequest$NextToken' => '<p>If the response to a previous <code>ListModelCardVersions</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of model card versions, use the token in the next request.</p>', 'ListModelCardVersionsResponse$NextToken' => '<p>If the response is truncated, SageMaker returns this token. To retrieve the next set of model card versions, use it in the subsequent request.</p>', 'ListModelCardsRequest$NextToken' => '<p>If the response to a previous <code>ListModelCards</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of model cards, use the token in the next request.</p>', 'ListModelCardsResponse$NextToken' => '<p>If the response is truncated, SageMaker returns this token. To retrieve the next set of model cards, use it in the subsequent request.</p>', 'ListModelExplainabilityJobDefinitionsRequest$NextToken' => '<p>The token returned if the response is truncated. To retrieve the next set of job executions, use it in the next request.</p>', 'ListModelExplainabilityJobDefinitionsResponse$NextToken' => '<p>The token returned if the response is truncated. To retrieve the next set of job executions, use it in the next request.</p>', 'ListModelMetadataRequest$NextToken' => '<p>If the response to a previous <code>ListModelMetadataResponse</code> request was truncated, the response includes a NextToken. To retrieve the next set of model metadata, use the token in the next request.</p>', 'ListModelMetadataResponse$NextToken' => '<p>A token for getting the next set of recommendations, if there are any.</p>', 'ListModelPackageGroupsInput$NextToken' => '<p>If the result of the previous <code>ListModelPackageGroups</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of model groups, use the token in the next request.</p>', 'ListModelPackageGroupsOutput$NextToken' => '<p>If the response is truncated, SageMaker returns this token. To retrieve the next set of model groups, use it in the subsequent request.</p>', 'ListModelPackagesInput$NextToken' => '<p>If the response to a previous <code>ListModelPackages</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of model packages, use the token in the next request.</p>', 'ListModelPackagesOutput$NextToken' => '<p>If the response is truncated, SageMaker returns this token. To retrieve the next set of model packages, use it in the subsequent request.</p>', 'ListModelQualityJobDefinitionsRequest$NextToken' => '<p>If the result of the previous <code>ListModelQualityJobDefinitions</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of model quality monitoring job definitions, use the token in the next request.</p>', 'ListModelQualityJobDefinitionsResponse$NextToken' => '<p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of model quality monitoring job definitions, use it in the next request.</p>', 'ListMonitoringAlertHistoryRequest$NextToken' => '<p>If the result of the previous <code>ListMonitoringAlertHistory</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of alerts in the history, use the token in the next request.</p>', 'ListMonitoringAlertHistoryResponse$NextToken' => '<p>If the response is truncated, SageMaker returns this token. To retrieve the next set of alerts, use it in the subsequent request.</p>', 'ListMonitoringAlertsRequest$NextToken' => '<p>If the result of the previous <code>ListMonitoringAlerts</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of alerts in the history, use the token in the next request.</p>', 'ListMonitoringAlertsResponse$NextToken' => '<p>If the response is truncated, SageMaker returns this token. To retrieve the next set of alerts, use it in the subsequent request.</p>', 'ListMonitoringExecutionsRequest$NextToken' => '<p>The token returned if the response is truncated. To retrieve the next set of job executions, use it in the next request.</p>', 'ListMonitoringExecutionsResponse$NextToken' => '<p>The token returned if the response is truncated. To retrieve the next set of job executions, use it in the next request.</p>', 'ListMonitoringSchedulesRequest$NextToken' => '<p>The token returned if the response is truncated. To retrieve the next set of job executions, use it in the next request.</p>', 'ListMonitoringSchedulesResponse$NextToken' => '<p>The token returned if the response is truncated. To retrieve the next set of job executions, use it in the next request.</p>', 'ListNotebookInstanceLifecycleConfigsInput$NextToken' => '<p>If the result of a <code>ListNotebookInstanceLifecycleConfigs</code> request was truncated, the response includes a <code>NextToken</code>. To get the next set of lifecycle configurations, use the token in the next request.</p>', 'ListNotebookInstanceLifecycleConfigsOutput$NextToken' => '<p>If the response is truncated, SageMaker returns this token. To get the next set of lifecycle configurations, use it in the next request. </p>', 'ListNotebookInstancesInput$NextToken' => '<p> If the previous call to the <code>ListNotebookInstances</code> is truncated, the response includes a <code>NextToken</code>. You can use this token in your subsequent <code>ListNotebookInstances</code> request to fetch the next set of notebook instances. </p> <note> <p>You might specify a filter or a sort order in your request. When response is truncated, you must use the same values for the filer and sort order in the next request. </p> </note>', 'ListNotebookInstancesOutput$NextToken' => '<p>If the response to the previous <code>ListNotebookInstances</code> request was truncated, SageMaker returns this token. To retrieve the next set of notebook instances, use the token in the next request.</p>', 'ListOptimizationJobsRequest$NextToken' => '<p>A token that you use to get the next set of results following a truncated response. If the response to the previous request was truncated, that response provides the value for this token.</p>', 'ListOptimizationJobsResponse$NextToken' => '<p>The token to use in a subsequent request to get the next set of results following a truncated response.</p>', 'ListPipelineExecutionStepsRequest$NextToken' => '<p>If the result of the previous <code>ListPipelineExecutionSteps</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of pipeline execution steps, use the token in the next request.</p>', 'ListPipelineExecutionStepsResponse$NextToken' => '<p>If the result of the previous <code>ListPipelineExecutionSteps</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of pipeline execution steps, use the token in the next request.</p>', 'ListPipelineExecutionsRequest$NextToken' => '<p>If the result of the previous <code>ListPipelineExecutions</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of pipeline executions, use the token in the next request.</p>', 'ListPipelineExecutionsResponse$NextToken' => '<p>If the result of the previous <code>ListPipelineExecutions</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of pipeline executions, use the token in the next request.</p>', 'ListPipelineParametersForExecutionRequest$NextToken' => '<p>If the result of the previous <code>ListPipelineParametersForExecution</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of parameters, use the token in the next request.</p>', 'ListPipelineParametersForExecutionResponse$NextToken' => '<p>If the result of the previous <code>ListPipelineParametersForExecution</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of parameters, use the token in the next request.</p>', 'ListPipelinesRequest$NextToken' => '<p>If the result of the previous <code>ListPipelines</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of pipelines, use the token in the next request.</p>', 'ListPipelinesResponse$NextToken' => '<p>If the result of the previous <code>ListPipelines</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of pipelines, use the token in the next request.</p>', 'ListProcessingJobsRequest$NextToken' => '<p>If the result of the previous <code>ListProcessingJobs</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of processing jobs, use the token in the next request.</p>', 'ListProcessingJobsResponse$NextToken' => '<p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of processing jobs, use it in the subsequent request.</p>', 'ListProjectsInput$NextToken' => '<p>If the result of the previous <code>ListProjects</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of projects, use the token in the next request.</p>', 'ListProjectsOutput$NextToken' => '<p>If the result of the previous <code>ListCompilationJobs</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of model compilation jobs, use the token in the next request.</p>', 'ListResourceCatalogsRequest$NextToken' => '<p> A token to resume pagination of <code>ListResourceCatalogs</code> results. </p>', 'ListResourceCatalogsResponse$NextToken' => '<p> A token to resume pagination of <code>ListResourceCatalogs</code> results. </p>', 'ListSpacesRequest$NextToken' => '<p>If the previous response was truncated, you will receive this token. Use it in your next request to receive the next set of results.</p>', 'ListSpacesResponse$NextToken' => '<p>If the previous response was truncated, you will receive this token. Use it in your next request to receive the next set of results.</p>', 'ListStageDevicesRequest$NextToken' => '<p>The response from the last list when returning a list large enough to neeed tokening.</p>', 'ListStageDevicesResponse$NextToken' => '<p>The token to use when calling the next page of results.</p>', 'ListStudioLifecycleConfigsRequest$NextToken' => '<p>If the previous call to ListStudioLifecycleConfigs didn\'t return the full set of Lifecycle Configurations, the call returns a token for getting the next set of Lifecycle Configurations.</p>', 'ListStudioLifecycleConfigsResponse$NextToken' => '<p>If the previous response was truncated, you will receive this token. Use it in your next request to receive the next set of results.</p>', 'ListSubscribedWorkteamsRequest$NextToken' => '<p>If the result of the previous <code>ListSubscribedWorkteams</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of labeling jobs, use the token in the next request.</p>', 'ListSubscribedWorkteamsResponse$NextToken' => '<p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of work teams, use it in the subsequent request.</p>', 'ListTagsInput$NextToken' => '<p> If the response to the previous <code>ListTags</code> request is truncated, SageMaker returns this token. To retrieve the next set of tags, use it in the subsequent request. </p>', 'ListTagsOutput$NextToken' => '<p> If response is truncated, SageMaker includes a token in the response. You can use this token in your subsequent request to fetch next set of tokens. </p>', 'ListTrainingJobsForHyperParameterTuningJobRequest$NextToken' => '<p>If the result of the previous <code>ListTrainingJobsForHyperParameterTuningJob</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of training jobs, use the token in the next request.</p>', 'ListTrainingJobsForHyperParameterTuningJobResponse$NextToken' => '<p>If the result of this <code>ListTrainingJobsForHyperParameterTuningJob</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of training jobs, use the token in the next request.</p>', 'ListTrainingJobsRequest$NextToken' => '<p>If the result of the previous <code>ListTrainingJobs</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of training jobs, use the token in the next request. </p>', 'ListTrainingJobsResponse$NextToken' => '<p>If the response is truncated, SageMaker returns this token. To retrieve the next set of training jobs, use it in the subsequent request.</p>', 'ListTransformJobsRequest$NextToken' => '<p>If the result of the previous <code>ListTransformJobs</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of transform jobs, use the token in the next request.</p>', 'ListTransformJobsResponse$NextToken' => '<p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of transform jobs, use it in the next request.</p>', 'ListTrialComponentsRequest$NextToken' => '<p>If the previous call to <code>ListTrialComponents</code> didn\'t return the full set of components, the call returns a token for getting the next set of components.</p>', 'ListTrialComponentsResponse$NextToken' => '<p>A token for getting the next set of components, if there are any.</p>', 'ListTrialsRequest$NextToken' => '<p>If the previous call to <code>ListTrials</code> didn\'t return the full set of trials, the call returns a token for getting the next set of trials.</p>', 'ListTrialsResponse$NextToken' => '<p>A token for getting the next set of trials, if there are any.</p>', 'ListUserProfilesRequest$NextToken' => '<p>If the previous response was truncated, you will receive this token. Use it in your next request to receive the next set of results.</p>', 'ListUserProfilesResponse$NextToken' => '<p>If the previous response was truncated, you will receive this token. Use it in your next request to receive the next set of results.</p>', 'ListWorkforcesRequest$NextToken' => '<p>A token to resume pagination.</p>', 'ListWorkforcesResponse$NextToken' => '<p>A token to resume pagination.</p>', 'ListWorkteamsRequest$NextToken' => '<p>If the result of the previous <code>ListWorkteams</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of labeling jobs, use the token in the next request.</p>', 'ListWorkteamsResponse$NextToken' => '<p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of work teams, use it in the subsequent request.</p>', 'SearchRequest$NextToken' => '<p>If more than <code>MaxResults</code> resources match the specified <code>SearchExpression</code>, the response includes a <code>NextToken</code>. The <code>NextToken</code> can be passed to the next <code>SearchRequest</code> to continue retrieving results.</p>', 'SearchResponse$NextToken' => '<p>If the result of the previous <code>Search</code> request was truncated, the response includes a NextToken. To retrieve the next set of results, use the token in the next request.</p>', ], ], 'NonEmptyString256' => [ 'base' => NULL, 'refs' => [ 'CustomImageContainerEntrypoint$member' => NULL, 'CustomImageContainerEnvironmentVariables$key' => NULL, 'OptimizationJobEnvironmentVariables$key' => NULL, ], ], 'NonEmptyString64' => [ 'base' => NULL, 'refs' => [ 'CreateSpaceRequest$SpaceDisplayName' => '<p>The name of the space that appears in the SageMaker Studio UI.</p>', 'CustomImageContainerArguments$member' => NULL, 'DescribeSpaceResponse$SpaceDisplayName' => '<p>The name of the space that appears in the Amazon SageMaker Studio UI.</p>', 'SpaceDetails$SpaceDisplayName' => '<p>The name of the space that appears in the Studio UI.</p>', 'UpdateSpaceRequest$SpaceDisplayName' => '<p>The name of the space that appears in the Amazon SageMaker Studio UI.</p>', ], ], 'NotebookInstanceAcceleratorType' => [ 'base' => NULL, 'refs' => [ 'NotebookInstanceAcceleratorTypes$member' => NULL, ], ], 'NotebookInstanceAcceleratorTypes' => [ 'base' => NULL, 'refs' => [ 'CreateNotebookInstanceInput$AcceleratorTypes' => '<p>A list of Elastic Inference (EI) instance types to associate with this notebook instance. Currently, only one instance type can be associated with a notebook instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon SageMaker</a>.</p>', 'DescribeNotebookInstanceOutput$AcceleratorTypes' => '<p>A list of the Elastic Inference (EI) instance types associated with this notebook instance. Currently only one EI instance type can be associated with a notebook instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon SageMaker</a>.</p>', 'UpdateNotebookInstanceInput$AcceleratorTypes' => '<p>A list of the Elastic Inference (EI) instance types to associate with this notebook instance. Currently only one EI instance type can be associated with a notebook instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon SageMaker</a>.</p>', ], ], 'NotebookInstanceArn' => [ 'base' => NULL, 'refs' => [ 'CreateNotebookInstanceOutput$NotebookInstanceArn' => '<p>The Amazon Resource Name (ARN) of the notebook instance. </p>', 'DescribeNotebookInstanceOutput$NotebookInstanceArn' => '<p>The Amazon Resource Name (ARN) of the notebook instance.</p>', 'NotebookInstanceSummary$NotebookInstanceArn' => '<p>The Amazon Resource Name (ARN) of the notebook instance.</p>', ], ], 'NotebookInstanceLifecycleConfigArn' => [ 'base' => NULL, 'refs' => [ 'CreateNotebookInstanceLifecycleConfigOutput$NotebookInstanceLifecycleConfigArn' => '<p>The Amazon Resource Name (ARN) of the lifecycle configuration.</p>', 'DescribeNotebookInstanceLifecycleConfigOutput$NotebookInstanceLifecycleConfigArn' => '<p>The Amazon Resource Name (ARN) of the lifecycle configuration.</p>', 'NotebookInstanceLifecycleConfigSummary$NotebookInstanceLifecycleConfigArn' => '<p>The Amazon Resource Name (ARN) of the lifecycle configuration.</p>', ], ], 'NotebookInstanceLifecycleConfigContent' => [ 'base' => NULL, 'refs' => [ 'NotebookInstanceLifecycleHook$Content' => '<p>A base64-encoded string that contains a shell script for a notebook instance lifecycle configuration.</p>', ], ], 'NotebookInstanceLifecycleConfigList' => [ 'base' => NULL, 'refs' => [ 'CreateNotebookInstanceLifecycleConfigInput$OnCreate' => '<p>A shell script that runs only once, when you create a notebook instance. The shell script must be a base64-encoded string.</p>', 'CreateNotebookInstanceLifecycleConfigInput$OnStart' => '<p>A shell script that runs every time you start a notebook instance, including when you create the notebook instance. The shell script must be a base64-encoded string.</p>', 'DescribeNotebookInstanceLifecycleConfigOutput$OnCreate' => '<p>The shell script that runs only once, when you create a notebook instance.</p>', 'DescribeNotebookInstanceLifecycleConfigOutput$OnStart' => '<p>The shell script that runs every time you start a notebook instance, including when you create the notebook instance.</p>', 'UpdateNotebookInstanceLifecycleConfigInput$OnCreate' => '<p>The shell script that runs only once, when you create a notebook instance. The shell script must be a base64-encoded string.</p>', 'UpdateNotebookInstanceLifecycleConfigInput$OnStart' => '<p>The shell script that runs every time you start a notebook instance, including when you create the notebook instance. The shell script must be a base64-encoded string.</p>', ], ], 'NotebookInstanceLifecycleConfigName' => [ 'base' => NULL, 'refs' => [ 'CreateNotebookInstanceInput$LifecycleConfigName' => '<p>The name of a lifecycle configuration to associate with the notebook instance. For information about lifestyle configurations, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional) Customize a Notebook Instance</a>.</p>', 'CreateNotebookInstanceLifecycleConfigInput$NotebookInstanceLifecycleConfigName' => '<p>The name of the lifecycle configuration.</p>', 'DeleteNotebookInstanceLifecycleConfigInput$NotebookInstanceLifecycleConfigName' => '<p>The name of the lifecycle configuration to delete.</p>', 'DescribeNotebookInstanceLifecycleConfigInput$NotebookInstanceLifecycleConfigName' => '<p>The name of the lifecycle configuration to describe.</p>', 'DescribeNotebookInstanceLifecycleConfigOutput$NotebookInstanceLifecycleConfigName' => '<p>The name of the lifecycle configuration.</p>', 'DescribeNotebookInstanceOutput$NotebookInstanceLifecycleConfigName' => '<p>Returns the name of a notebook instance lifecycle configuration.</p> <p>For information about notebook instance lifestyle configurations, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional) Customize a Notebook Instance</a> </p>', 'ListNotebookInstancesInput$NotebookInstanceLifecycleConfigNameContains' => '<p>A string in the name of a notebook instances lifecycle configuration associated with this notebook instance. This filter returns only notebook instances associated with a lifecycle configuration with a name that contains the specified string.</p>', 'NotebookInstanceLifecycleConfigSummary$NotebookInstanceLifecycleConfigName' => '<p>The name of the lifecycle configuration.</p>', 'NotebookInstanceSummary$NotebookInstanceLifecycleConfigName' => '<p>The name of a notebook instance lifecycle configuration associated with this notebook instance.</p> <p>For information about notebook instance lifestyle configurations, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional) Customize a Notebook Instance</a>.</p>', 'UpdateNotebookInstanceInput$LifecycleConfigName' => '<p>The name of a lifecycle configuration to associate with the notebook instance. For information about lifestyle configurations, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional) Customize a Notebook Instance</a>.</p>', 'UpdateNotebookInstanceLifecycleConfigInput$NotebookInstanceLifecycleConfigName' => '<p>The name of the lifecycle configuration.</p>', ], ], 'NotebookInstanceLifecycleConfigNameContains' => [ 'base' => NULL, 'refs' => [ 'ListNotebookInstanceLifecycleConfigsInput$NameContains' => '<p>A string in the lifecycle configuration name. This filter returns only lifecycle configurations whose name contains the specified string.</p>', ], ], 'NotebookInstanceLifecycleConfigSortKey' => [ 'base' => NULL, 'refs' => [ 'ListNotebookInstanceLifecycleConfigsInput$SortBy' => '<p>Sorts the list of results. The default is <code>CreationTime</code>.</p>', ], ], 'NotebookInstanceLifecycleConfigSortOrder' => [ 'base' => NULL, 'refs' => [ 'ListNotebookInstanceLifecycleConfigsInput$SortOrder' => '<p>The sort order for results.</p>', ], ], 'NotebookInstanceLifecycleConfigSummary' => [ 'base' => '<p>Provides a summary of a notebook instance lifecycle configuration.</p>', 'refs' => [ 'NotebookInstanceLifecycleConfigSummaryList$member' => NULL, ], ], 'NotebookInstanceLifecycleConfigSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListNotebookInstanceLifecycleConfigsOutput$NotebookInstanceLifecycleConfigs' => '<p>An array of <code>NotebookInstanceLifecycleConfiguration</code> objects, each listing a lifecycle configuration.</p>', ], ], 'NotebookInstanceLifecycleHook' => [ 'base' => '<p>Contains the notebook instance lifecycle configuration script.</p> <p>Each lifecycle configuration script has a limit of 16384 characters.</p> <p>The value of the <code>$PATH</code> environment variable that is available to both scripts is <code>/sbin:bin:/usr/sbin:/usr/bin</code>.</p> <p>View Amazon CloudWatch Logs for notebook instance lifecycle configurations in log group <code>/aws/sagemaker/NotebookInstances</code> in log stream <code>[notebook-instance-name]/[LifecycleConfigHook]</code>.</p> <p>Lifecycle configuration scripts cannot run for longer than 5 minutes. If a script runs for longer than 5 minutes, it fails and the notebook instance is not created or started.</p> <p>For information about notebook instance lifestyle configurations, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional) Customize a Notebook Instance</a>.</p>', 'refs' => [ 'NotebookInstanceLifecycleConfigList$member' => NULL, ], ], 'NotebookInstanceName' => [ 'base' => NULL, 'refs' => [ 'CreateNotebookInstanceInput$NotebookInstanceName' => '<p>The name of the new notebook instance.</p>', 'CreatePresignedNotebookInstanceUrlInput$NotebookInstanceName' => '<p>The name of the notebook instance.</p>', 'DeleteNotebookInstanceInput$NotebookInstanceName' => '<p>The name of the SageMaker notebook instance to delete.</p>', 'DescribeNotebookInstanceInput$NotebookInstanceName' => '<p>The name of the notebook instance that you want information about.</p>', 'DescribeNotebookInstanceOutput$NotebookInstanceName' => '<p>The name of the SageMaker notebook instance. </p>', 'NotebookInstanceSummary$NotebookInstanceName' => '<p>The name of the notebook instance that you want a summary for.</p>', 'StartNotebookInstanceInput$NotebookInstanceName' => '<p>The name of the notebook instance to start.</p>', 'StopNotebookInstanceInput$NotebookInstanceName' => '<p>The name of the notebook instance to terminate.</p>', 'UpdateNotebookInstanceInput$NotebookInstanceName' => '<p>The name of the notebook instance to update.</p>', ], ], 'NotebookInstanceNameContains' => [ 'base' => NULL, 'refs' => [ 'ListNotebookInstancesInput$NameContains' => '<p>A string in the notebook instances\' name. This filter returns only notebook instances whose name contains the specified string.</p>', ], ], 'NotebookInstanceSortKey' => [ 'base' => NULL, 'refs' => [ 'ListNotebookInstancesInput$SortBy' => '<p>The field to sort results by. The default is <code>Name</code>.</p>', ], ], 'NotebookInstanceSortOrder' => [ 'base' => NULL, 'refs' => [ 'ListNotebookInstancesInput$SortOrder' => '<p>The sort order for results. </p>', ], ], 'NotebookInstanceStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeNotebookInstanceOutput$NotebookInstanceStatus' => '<p>The status of the notebook instance.</p>', 'ListNotebookInstancesInput$StatusEquals' => '<p>A filter that returns only notebook instances with the specified status.</p>', 'NotebookInstanceSummary$NotebookInstanceStatus' => '<p>The status of the notebook instance.</p>', ], ], 'NotebookInstanceSummary' => [ 'base' => '<p>Provides summary information for an SageMaker notebook instance.</p>', 'refs' => [ 'NotebookInstanceSummaryList$member' => NULL, ], ], 'NotebookInstanceSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListNotebookInstancesOutput$NotebookInstances' => '<p>An array of <code>NotebookInstanceSummary</code> objects, one for each notebook instance.</p>', ], ], 'NotebookInstanceUrl' => [ 'base' => NULL, 'refs' => [ 'CreatePresignedNotebookInstanceUrlOutput$AuthorizedUrl' => '<p>A JSON object that contains the URL string. </p>', 'DescribeNotebookInstanceOutput$Url' => '<p>The URL that you use to connect to the Jupyter notebook that is running in your notebook instance. </p>', 'NotebookInstanceSummary$Url' => '<p>The URL that you use to connect to the Jupyter notebook running in your notebook instance. </p>', ], ], 'NotebookInstanceVolumeSizeInGB' => [ 'base' => NULL, 'refs' => [ 'CreateNotebookInstanceInput$VolumeSizeInGB' => '<p>The size, in GB, of the ML storage volume to attach to the notebook instance. The default value is 5 GB.</p>', 'DescribeNotebookInstanceOutput$VolumeSizeInGB' => '<p>The size, in GB, of the ML storage volume attached to the notebook instance.</p>', 'UpdateNotebookInstanceInput$VolumeSizeInGB' => '<p>The size, in GB, of the ML storage volume to attach to the notebook instance. The default value is 5 GB. ML storage volumes are encrypted, so SageMaker can\'t determine the amount of available free space on the volume. Because of this, you can increase the volume size when you update a notebook instance, but you can\'t decrease the volume size. If you want to decrease the size of the ML storage volume in use, create a new notebook instance with the desired size.</p>', ], ], 'NotebookOutputOption' => [ 'base' => NULL, 'refs' => [ 'SharingSettings$NotebookOutputOption' => '<p>Whether to include the notebook cell output when sharing the notebook. The default is <code>Disabled</code>.</p>', ], ], 'NotificationConfiguration' => [ 'base' => '<p>Configures Amazon SNS notifications of available or expiring work items for work teams.</p>', 'refs' => [ 'CreateWorkteamRequest$NotificationConfiguration' => '<p>Configures notification of workers regarding available or expiring work items.</p>', 'UpdateWorkteamRequest$NotificationConfiguration' => '<p>Configures SNS topic notifications for available or expiring work items</p>', 'Workteam$NotificationConfiguration' => '<p>Configures SNS notifications of available or expiring work items for work teams.</p>', ], ], 'NotificationTopicArn' => [ 'base' => NULL, 'refs' => [ 'NotificationConfiguration$NotificationTopicArn' => '<p>The ARN for the Amazon SNS topic to which notifications should be published.</p>', ], ], 'NumberOfAcceleratorDevices' => [ 'base' => NULL, 'refs' => [ 'InferenceComponentComputeResourceRequirements$NumberOfAcceleratorDevicesRequired' => '<p>The number of accelerators to allocate to run a model that you assign to an inference component. Accelerators include GPUs and Amazon Web Services Inferentia.</p>', ], ], 'NumberOfCpuCores' => [ 'base' => NULL, 'refs' => [ 'InferenceComponentComputeResourceRequirements$NumberOfCpuCoresRequired' => '<p>The number of CPU cores to allocate to run a model that you assign to an inference component.</p>', ], ], 'NumberOfHumanWorkersPerDataObject' => [ 'base' => NULL, 'refs' => [ 'HumanTaskConfig$NumberOfHumanWorkersPerDataObject' => '<p>The number of human workers that will label an object. </p>', 'LabelingJobForWorkteamSummary$NumberOfHumanWorkersPerDataObject' => '<p>The configured number of workers per data object.</p>', ], ], 'NumberOfSteps' => [ 'base' => NULL, 'refs' => [ 'Stairs$NumberOfSteps' => '<p>Specifies how many steps to perform during traffic.</p>', ], ], 'ObjectiveStatus' => [ 'base' => NULL, 'refs' => [ 'AutoMLCandidate$ObjectiveStatus' => '<p>The objective\'s status.</p>', 'HyperParameterTrainingJobSummary$ObjectiveStatus' => '<p>The status of the objective metric for the training job:</p> <ul> <li> <p>Succeeded: The final objective metric for the training job was evaluated by the hyperparameter tuning job and used in the hyperparameter tuning process.</p> </li> </ul> <ul> <li> <p>Pending: The training job is in progress and evaluation of its final objective metric is pending.</p> </li> </ul> <ul> <li> <p>Failed: The final objective metric for the training job was not evaluated, and was not used in the hyperparameter tuning process. This typically occurs when the training job failed or did not emit an objective metric.</p> </li> </ul>', ], ], 'ObjectiveStatusCounter' => [ 'base' => NULL, 'refs' => [ 'ObjectiveStatusCounters$Succeeded' => '<p>The number of training jobs whose final objective metric was evaluated by the hyperparameter tuning job and used in the hyperparameter tuning process.</p>', 'ObjectiveStatusCounters$Pending' => '<p>The number of training jobs that are in progress and pending evaluation of their final objective metric.</p>', 'ObjectiveStatusCounters$Failed' => '<p>The number of training jobs whose final objective metric was not evaluated and used in the hyperparameter tuning process. This typically occurs when the training job failed or did not emit an objective metric.</p>', ], ], 'ObjectiveStatusCounters' => [ 'base' => '<p>Specifies the number of training jobs that this hyperparameter tuning job launched, categorized by the status of their objective metric. The objective metric status shows whether the final objective metric for the training job has been evaluated by the tuning job and used in the hyperparameter tuning process.</p>', 'refs' => [ 'DescribeHyperParameterTuningJobResponse$ObjectiveStatusCounters' => '<p>The <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ObjectiveStatusCounters.html">ObjectiveStatusCounters</a> object that specifies the number of training jobs, categorized by the status of their final objective metric, that this tuning job launched.</p>', 'HyperParameterTuningJobSearchEntity$ObjectiveStatusCounters' => NULL, 'HyperParameterTuningJobSummary$ObjectiveStatusCounters' => '<p>The <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ObjectiveStatusCounters.html">ObjectiveStatusCounters</a> object that specifies the numbers of training jobs, categorized by objective metric status, that this tuning job launched.</p>', ], ], 'OfflineStoreConfig' => [ 'base' => '<p>The configuration of an <code>OfflineStore</code>.</p> <p>Provide an <code>OfflineStoreConfig</code> in a request to <code>CreateFeatureGroup</code> to create an <code>OfflineStore</code>.</p> <p>To encrypt an <code>OfflineStore</code> using at rest data encryption, specify Amazon Web Services Key Management Service (KMS) key ID, or <code>KMSKeyId</code>, in <code>S3StorageConfig</code>.</p>', 'refs' => [ 'CreateFeatureGroupRequest$OfflineStoreConfig' => '<p>Use this to configure an <code>OfflineFeatureStore</code>. This parameter allows you to specify:</p> <ul> <li> <p>The Amazon Simple Storage Service (Amazon S3) location of an <code>OfflineStore</code>.</p> </li> <li> <p>A configuration for an Amazon Web Services Glue or Amazon Web Services Hive data catalog. </p> </li> <li> <p>An KMS encryption key to encrypt the Amazon S3 location used for <code>OfflineStore</code>. If KMS encryption key is not specified, by default we encrypt all data at rest using Amazon Web Services KMS key. By defining your <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucket-key.html">bucket-level key</a> for SSE, you can reduce Amazon Web Services KMS requests costs by up to 99 percent.</p> </li> <li> <p>Format for the offline store table. Supported formats are Glue (Default) and <a href="https://iceberg.apache.org/">Apache Iceberg</a>.</p> </li> </ul> <p>To learn more about this parameter, see <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_OfflineStoreConfig.html">OfflineStoreConfig</a>.</p>', 'DescribeFeatureGroupResponse$OfflineStoreConfig' => '<p>The configuration of the offline store. It includes the following configurations:</p> <ul> <li> <p>Amazon S3 location of the offline store.</p> </li> <li> <p>Configuration of the Glue data catalog.</p> </li> <li> <p>Table format of the offline store.</p> </li> <li> <p>Option to disable the automatic creation of a Glue table for the offline store.</p> </li> <li> <p>Encryption configuration.</p> </li> </ul>', 'FeatureGroup$OfflineStoreConfig' => NULL, ], ], 'OfflineStoreStatus' => [ 'base' => '<p>The status of <code>OfflineStore</code>.</p>', 'refs' => [ 'DescribeFeatureGroupResponse$OfflineStoreStatus' => '<p>The status of the <code>OfflineStore</code>. Notifies you if replicating data into the <code>OfflineStore</code> has failed. Returns either: <code>Active</code> or <code>Blocked</code> </p>', 'FeatureGroup$OfflineStoreStatus' => NULL, 'FeatureGroupSummary$OfflineStoreStatus' => '<p>Notifies you if replicating data into the <code>OfflineStore</code> has failed. Returns either: <code>Active</code> or <code>Blocked</code>.</p>', ], ], 'OfflineStoreStatusValue' => [ 'base' => NULL, 'refs' => [ 'ListFeatureGroupsRequest$OfflineStoreStatusEquals' => '<p>An <code>OfflineStore</code> status. Filters by <code>OfflineStore</code> status. </p>', 'OfflineStoreStatus$Status' => '<p>An <code>OfflineStore</code> status.</p>', ], ], 'OidcConfig' => [ 'base' => '<p>Use this parameter to configure your OIDC Identity Provider (IdP).</p>', 'refs' => [ 'CreateWorkforceRequest$OidcConfig' => '<p>Use this parameter to configure a private workforce using your own OIDC Identity Provider.</p> <p>Do not use <code>CognitoConfig</code> if you specify values for <code>OidcConfig</code>.</p>', 'UpdateWorkforceRequest$OidcConfig' => '<p>Use this parameter to update your OIDC Identity Provider (IdP) configuration for a workforce made using your own IdP.</p>', ], ], 'OidcConfigForResponse' => [ 'base' => '<p>Your OIDC IdP workforce configuration.</p>', 'refs' => [ 'Workforce$OidcConfig' => '<p>The configuration of an OIDC Identity Provider (IdP) private workforce.</p>', ], ], 'OidcEndpoint' => [ 'base' => NULL, 'refs' => [ 'OidcConfig$Issuer' => '<p>The OIDC IdP issuer used to configure your private workforce.</p>', 'OidcConfig$AuthorizationEndpoint' => '<p>The OIDC IdP authorization endpoint used to configure your private workforce.</p>', 'OidcConfig$TokenEndpoint' => '<p>The OIDC IdP token endpoint used to configure your private workforce.</p>', 'OidcConfig$UserInfoEndpoint' => '<p>The OIDC IdP user information endpoint used to configure your private workforce.</p>', 'OidcConfig$LogoutEndpoint' => '<p>The OIDC IdP logout endpoint used to configure your private workforce.</p>', 'OidcConfig$JwksUri' => '<p>The OIDC IdP JSON Web Key Set (Jwks) URI used to configure your private workforce.</p>', 'OidcConfigForResponse$Issuer' => '<p>The OIDC IdP issuer used to configure your private workforce.</p>', 'OidcConfigForResponse$AuthorizationEndpoint' => '<p>The OIDC IdP authorization endpoint used to configure your private workforce.</p>', 'OidcConfigForResponse$TokenEndpoint' => '<p>The OIDC IdP token endpoint used to configure your private workforce.</p>', 'OidcConfigForResponse$UserInfoEndpoint' => '<p>The OIDC IdP user information endpoint used to configure your private workforce.</p>', 'OidcConfigForResponse$LogoutEndpoint' => '<p>The OIDC IdP logout endpoint used to configure your private workforce.</p>', 'OidcConfigForResponse$JwksUri' => '<p>The OIDC IdP JSON Web Key Set (Jwks) URI used to configure your private workforce.</p>', ], ], 'OidcMemberDefinition' => [ 'base' => '<p>A list of user groups that exist in your OIDC Identity Provider (IdP). One to ten groups can be used to create a single private work team. When you add a user group to the list of <code>Groups</code>, you can add that user group to one or more private work teams. If you add a user group to a private work team, all workers in that user group are added to the work team.</p>', 'refs' => [ 'MemberDefinition$OidcMemberDefinition' => '<p>A list user groups that exist in your OIDC Identity Provider (IdP). One to ten groups can be used to create a single private work team. When you add a user group to the list of <code>Groups</code>, you can add that user group to one or more private work teams. If you add a user group to a private work team, all workers in that user group are added to the work team.</p>', ], ], 'OnlineStoreConfig' => [ 'base' => '<p>Use this to specify the Amazon Web Services Key Management Service (KMS) Key ID, or <code>KMSKeyId</code>, for at rest data encryption. You can turn <code>OnlineStore</code> on or off by specifying the <code>EnableOnlineStore</code> flag at General Assembly.</p> <p>The default value is <code>False</code>.</p>', 'refs' => [ 'CreateFeatureGroupRequest$OnlineStoreConfig' => '<p>You can turn the <code>OnlineStore</code> on or off by specifying <code>True</code> for the <code>EnableOnlineStore</code> flag in <code>OnlineStoreConfig</code>.</p> <p>You can also include an Amazon Web Services KMS key ID (<code>KMSKeyId</code>) for at-rest encryption of the <code>OnlineStore</code>.</p> <p>The default value is <code>False</code>.</p>', 'DescribeFeatureGroupResponse$OnlineStoreConfig' => '<p>The configuration for the <code>OnlineStore</code>.</p>', 'FeatureGroup$OnlineStoreConfig' => NULL, ], ], 'OnlineStoreConfigUpdate' => [ 'base' => '<p>Updates the feature group online store configuration.</p>', 'refs' => [ 'UpdateFeatureGroupRequest$OnlineStoreConfig' => '<p>Updates the feature group online store configuration.</p>', ], ], 'OnlineStoreSecurityConfig' => [ 'base' => '<p>The security configuration for <code>OnlineStore</code>.</p>', 'refs' => [ 'OnlineStoreConfig$SecurityConfig' => '<p>Use to specify KMS Key ID (<code>KMSKeyId</code>) for at-rest encryption of your <code>OnlineStore</code>.</p>', ], ], 'OnlineStoreTotalSizeBytes' => [ 'base' => NULL, 'refs' => [ 'DescribeFeatureGroupResponse$OnlineStoreTotalSizeBytes' => '<p>The size of the <code>OnlineStore</code> in bytes.</p>', ], ], 'Operator' => [ 'base' => NULL, 'refs' => [ 'Filter$Operator' => '<p>A Boolean binary operator that is used to evaluate the filter. The operator field contains one of the following values:</p> <dl> <dt>Equals</dt> <dd> <p>The value of <code>Name</code> equals <code>Value</code>.</p> </dd> <dt>NotEquals</dt> <dd> <p>The value of <code>Name</code> doesn\'t equal <code>Value</code>.</p> </dd> <dt>Exists</dt> <dd> <p>The <code>Name</code> property exists.</p> </dd> <dt>NotExists</dt> <dd> <p>The <code>Name</code> property does not exist.</p> </dd> <dt>GreaterThan</dt> <dd> <p>The value of <code>Name</code> is greater than <code>Value</code>. Not supported for text properties.</p> </dd> <dt>GreaterThanOrEqualTo</dt> <dd> <p>The value of <code>Name</code> is greater than or equal to <code>Value</code>. Not supported for text properties.</p> </dd> <dt>LessThan</dt> <dd> <p>The value of <code>Name</code> is less than <code>Value</code>. Not supported for text properties.</p> </dd> <dt>LessThanOrEqualTo</dt> <dd> <p>The value of <code>Name</code> is less than or equal to <code>Value</code>. Not supported for text properties.</p> </dd> <dt>In</dt> <dd> <p>The value of <code>Name</code> is one of the comma delimited strings in <code>Value</code>. Only supported for text properties.</p> </dd> <dt>Contains</dt> <dd> <p>The value of <code>Name</code> contains the string <code>Value</code>. Only supported for text properties.</p> <p>A <code>SearchExpression</code> can include the <code>Contains</code> operator multiple times when the value of <code>Name</code> is one of the following:</p> <ul> <li> <p> <code>Experiment.DisplayName</code> </p> </li> <li> <p> <code>Experiment.ExperimentName</code> </p> </li> <li> <p> <code>Experiment.Tags</code> </p> </li> <li> <p> <code>Trial.DisplayName</code> </p> </li> <li> <p> <code>Trial.TrialName</code> </p> </li> <li> <p> <code>Trial.Tags</code> </p> </li> <li> <p> <code>TrialComponent.DisplayName</code> </p> </li> <li> <p> <code>TrialComponent.TrialComponentName</code> </p> </li> <li> <p> <code>TrialComponent.Tags</code> </p> </li> <li> <p> <code>TrialComponent.InputArtifacts</code> </p> </li> <li> <p> <code>TrialComponent.OutputArtifacts</code> </p> </li> </ul> <p>A <code>SearchExpression</code> can include only one <code>Contains</code> operator for all other values of <code>Name</code>. In these cases, if you include multiple <code>Contains</code> operators in the <code>SearchExpression</code>, the result is the following error message: "<code>\'CONTAINS\' operator usage limit of 1 exceeded.</code>"</p> </dd> </dl>', ], ], 'OptimizationConfig' => [ 'base' => '<p>Settings for an optimization technique that you apply with a model optimization job.</p>', 'refs' => [ 'OptimizationConfigs$member' => NULL, ], ], 'OptimizationConfigs' => [ 'base' => NULL, 'refs' => [ 'CreateOptimizationJobRequest$OptimizationConfigs' => '<p>Settings for each of the optimization techniques that the job applies.</p>', 'DescribeOptimizationJobResponse$OptimizationConfigs' => '<p>Settings for each of the optimization techniques that the job applies.</p>', ], ], 'OptimizationContainerImage' => [ 'base' => NULL, 'refs' => [ 'ModelCompilationConfig$Image' => '<p>The URI of an LMI DLC in Amazon ECR. SageMaker uses this image to run the optimization.</p>', 'ModelQuantizationConfig$Image' => '<p>The URI of an LMI DLC in Amazon ECR. SageMaker uses this image to run the optimization.</p>', 'OptimizationOutput$RecommendedInferenceImage' => '<p>The image that SageMaker recommends that you use to host the optimized model that you created with an optimization job.</p>', ], ], 'OptimizationJobArn' => [ 'base' => NULL, 'refs' => [ 'CreateOptimizationJobResponse$OptimizationJobArn' => '<p>The Amazon Resource Name (ARN) of the optimization job.</p>', 'DescribeOptimizationJobResponse$OptimizationJobArn' => '<p>The Amazon Resource Name (ARN) of the optimization job.</p>', 'OptimizationJobSummary$OptimizationJobArn' => '<p>The Amazon Resource Name (ARN) of the optimization job.</p>', ], ], 'OptimizationJobDeploymentInstanceType' => [ 'base' => NULL, 'refs' => [ 'CreateOptimizationJobRequest$DeploymentInstanceType' => '<p>The type of instance that hosts the optimized model that you create with the optimization job.</p>', 'DescribeOptimizationJobResponse$DeploymentInstanceType' => '<p>The type of instance that hosts the optimized model that you create with the optimization job.</p>', 'OptimizationJobSummary$DeploymentInstanceType' => '<p>The type of instance that hosts the optimized model that you create with the optimization job.</p>', ], ], 'OptimizationJobEnvironmentVariables' => [ 'base' => NULL, 'refs' => [ 'CreateOptimizationJobRequest$OptimizationEnvironment' => '<p>The environment variables to set in the model container.</p>', 'DescribeOptimizationJobResponse$OptimizationEnvironment' => '<p>The environment variables to set in the model container.</p>', 'ModelCompilationConfig$OverrideEnvironment' => '<p>Environment variables that override the default ones in the model container.</p>', 'ModelQuantizationConfig$OverrideEnvironment' => '<p>Environment variables that override the default ones in the model container.</p>', ], ], 'OptimizationJobModelSource' => [ 'base' => '<p>The location of the source model to optimize with an optimization job.</p>', 'refs' => [ 'CreateOptimizationJobRequest$ModelSource' => '<p>The location of the source model to optimize with an optimization job.</p>', 'DescribeOptimizationJobResponse$ModelSource' => '<p>The location of the source model to optimize with an optimization job.</p>', ], ], 'OptimizationJobModelSourceS3' => [ 'base' => '<p>The Amazon S3 location of a source model to optimize with an optimization job.</p>', 'refs' => [ 'OptimizationJobModelSource$S3' => '<p>The Amazon S3 location of a source model to optimize with an optimization job.</p>', ], ], 'OptimizationJobOutputConfig' => [ 'base' => '<p>Details for where to store the optimized model that you create with the optimization job.</p>', 'refs' => [ 'CreateOptimizationJobRequest$OutputConfig' => '<p>Details for where to store the optimized model that you create with the optimization job.</p>', 'DescribeOptimizationJobResponse$OutputConfig' => '<p>Details for where to store the optimized model that you create with the optimization job.</p>', ], ], 'OptimizationJobStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeOptimizationJobResponse$OptimizationJobStatus' => '<p>The current status of the optimization job.</p>', 'ListOptimizationJobsRequest$StatusEquals' => '<p>Filters the results to only those optimization jobs with the specified status.</p>', 'OptimizationJobSummary$OptimizationJobStatus' => '<p>The current status of the optimization job.</p>', ], ], 'OptimizationJobSummaries' => [ 'base' => NULL, 'refs' => [ 'ListOptimizationJobsResponse$OptimizationJobSummaries' => '<p>A list of optimization jobs and their properties that matches any of the filters you specified in the request.</p>', ], ], 'OptimizationJobSummary' => [ 'base' => '<p>Summarizes an optimization job by providing some of its key properties.</p>', 'refs' => [ 'OptimizationJobSummaries$member' => NULL, ], ], 'OptimizationModelAcceptEula' => [ 'base' => NULL, 'refs' => [ 'OptimizationModelAccessConfig$AcceptEula' => '<p>Specifies agreement to the model end-user license agreement (EULA). The <code>AcceptEula</code> value must be explicitly defined as <code>True</code> in order to accept the EULA that this model requires. You are responsible for reviewing and complying with any applicable license terms and making sure they are acceptable for your use case before downloading or using a model.</p>', ], ], 'OptimizationModelAccessConfig' => [ 'base' => '<p>The access configuration settings for the source ML model for an optimization job, where you can accept the model end-user license agreement (EULA).</p>', 'refs' => [ 'OptimizationJobModelSourceS3$ModelAccessConfig' => '<p>The access configuration settings for the source ML model for an optimization job, where you can accept the model end-user license agreement (EULA).</p>', ], ], 'OptimizationOutput' => [ 'base' => '<p>Output values produced by an optimization job.</p>', 'refs' => [ 'DescribeOptimizationJobResponse$OptimizationOutput' => '<p>Output values produced by an optimization job.</p>', ], ], 'OptimizationType' => [ 'base' => NULL, 'refs' => [ 'OptimizationTypes$member' => NULL, ], ], 'OptimizationTypes' => [ 'base' => NULL, 'refs' => [ 'OptimizationJobSummary$OptimizationTypes' => '<p>The optimization techniques that are applied by the optimization job.</p>', ], ], 'OptimizationVpcConfig' => [ 'base' => '<p>A VPC in Amazon VPC that\'s accessible to an optimized that you create with an optimization job. You can control access to and from your resources by configuring a VPC. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/infrastructure-give-access.html">Give SageMaker Access to Resources in your Amazon VPC</a>. </p>', 'refs' => [ 'CreateOptimizationJobRequest$VpcConfig' => '<p>A VPC in Amazon VPC that your optimized model has access to.</p>', 'DescribeOptimizationJobResponse$VpcConfig' => '<p>A VPC in Amazon VPC that your optimized model has access to.</p>', ], ], 'OptimizationVpcSecurityGroupId' => [ 'base' => NULL, 'refs' => [ 'OptimizationVpcSecurityGroupIds$member' => NULL, ], ], 'OptimizationVpcSecurityGroupIds' => [ 'base' => NULL, 'refs' => [ 'OptimizationVpcConfig$SecurityGroupIds' => '<p>The VPC security group IDs, in the form <code>sg-xxxxxxxx</code>. Specify the security groups for the VPC that is specified in the <code>Subnets</code> field.</p>', ], ], 'OptimizationVpcSubnetId' => [ 'base' => NULL, 'refs' => [ 'OptimizationVpcSubnets$member' => NULL, ], ], 'OptimizationVpcSubnets' => [ 'base' => NULL, 'refs' => [ 'OptimizationVpcConfig$Subnets' => '<p>The ID of the subnets in the VPC to which you want to connect your optimized model.</p>', ], ], 'OptionalDouble' => [ 'base' => NULL, 'refs' => [ 'TrialComponentMetricSummary$Max' => '<p>The maximum value of the metric.</p>', 'TrialComponentMetricSummary$Min' => '<p>The minimum value of the metric.</p>', 'TrialComponentMetricSummary$Last' => '<p>The most recent value of the metric.</p>', 'TrialComponentMetricSummary$Avg' => '<p>The average value of the metric.</p>', 'TrialComponentMetricSummary$StdDev' => '<p>The standard deviation of the metric.</p>', ], ], 'OptionalInteger' => [ 'base' => NULL, 'refs' => [ 'TrialComponentMetricSummary$Count' => '<p>The number of samples used to generate the metric.</p>', ], ], 'OptionalVolumeSizeInGB' => [ 'base' => NULL, 'refs' => [ 'DebugRuleConfiguration$VolumeSizeInGB' => '<p>The size, in GB, of the ML storage volume attached to the processing instance.</p>', 'HyperParameterTuningResourceConfig$VolumeSizeInGB' => '<p>The volume size in GB for the storage volume to be used in processing hyperparameter optimization jobs (optional). These volumes store model artifacts, incremental states and optionally, scratch space for training algorithms. Do not provide a value for this parameter if a value for <code>InstanceConfigs</code> is also specified.</p> <p>Some instance types have a fixed total local storage size. If you select one of these instances for training, <code>VolumeSizeInGB</code> cannot be greater than this total size. For a list of instance types with local instance storage and their sizes, see <a href="http://aws.amazon.com/releasenotes/host-instance-storage-volumes-table/">instance store volumes</a>.</p> <note> <p>SageMaker supports only the <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-volume-types.html">General Purpose SSD (gp2)</a> storage volume type.</p> </note>', 'ProfilerRuleConfiguration$VolumeSizeInGB' => '<p>The size, in GB, of the ML storage volume attached to the processing instance.</p>', ], ], 'OrderKey' => [ 'base' => NULL, 'refs' => [ 'ListEndpointConfigsInput$SortOrder' => '<p>The sort order for results. The default is <code>Descending</code>.</p>', 'ListEndpointsInput$SortOrder' => '<p>The sort order for results. The default is <code>Descending</code>.</p>', 'ListInferenceComponentsInput$SortOrder' => '<p>The sort order for results. The default is <code>Descending</code>.</p>', 'ListModelsInput$SortOrder' => '<p>The sort order for results. The default is <code>Descending</code>.</p>', ], ], 'OutputCompressionType' => [ 'base' => NULL, 'refs' => [ 'OutputDataConfig$CompressionType' => '<p>The model output compression type. Select <code>None</code> to output an uncompressed model, recommended for large model outputs. Defaults to gzip.</p>', ], ], 'OutputConfig' => [ 'base' => '<p>Contains information about the output location for the compiled model and the target device that the model runs on. <code>TargetDevice</code> and <code>TargetPlatform</code> are mutually exclusive, so you need to choose one between the two to specify your target device or platform. If you cannot find your device you want to use from the <code>TargetDevice</code> list, use <code>TargetPlatform</code> to describe the platform of your edge device and <code>CompilerOptions</code> if there are specific settings that are required or recommended to use for particular TargetPlatform.</p>', 'refs' => [ 'CreateCompilationJobRequest$OutputConfig' => '<p>Provides information about the output location for the compiled model and the target device the model runs on.</p>', 'DescribeCompilationJobResponse$OutputConfig' => '<p>Information about the output location for the compiled model and the target device that the model runs on.</p>', ], ], 'OutputDataConfig' => [ 'base' => '<p>Provides information about how to store model training results (model artifacts).</p>', 'refs' => [ 'CreateTrainingJobRequest$OutputDataConfig' => '<p>Specifies the path to the S3 location where you want to store model artifacts. SageMaker creates subfolders for the artifacts. </p>', 'DescribeTrainingJobResponse$OutputDataConfig' => '<p>The S3 path where model artifacts that you configured when creating the job are stored. SageMaker creates subfolders for model artifacts. </p>', 'HyperParameterTrainingJobDefinition$OutputDataConfig' => '<p>Specifies the path to the Amazon S3 bucket where you store model artifacts from the training jobs that the tuning job launches.</p>', 'TrainingJob$OutputDataConfig' => '<p>The S3 path where model artifacts that you configured when creating the job are stored. SageMaker creates subfolders for model artifacts.</p>', 'TrainingJobDefinition$OutputDataConfig' => '<p>the path to the S3 bucket where you want to store model artifacts. SageMaker creates subfolders for the artifacts.</p>', ], ], 'OutputParameter' => [ 'base' => '<p>An output parameter of a pipeline step.</p>', 'refs' => [ 'OutputParameterList$member' => NULL, ], ], 'OutputParameterList' => [ 'base' => NULL, 'refs' => [ 'CallbackStepMetadata$OutputParameters' => '<p>A list of the output parameters of the callback step.</p>', 'LambdaStepMetadata$OutputParameters' => '<p>A list of the output parameters of the Lambda step.</p>', 'SendPipelineExecutionStepSuccessRequest$OutputParameters' => '<p>A list of the output parameters of the callback step.</p>', ], ], 'OwnershipSettings' => [ 'base' => '<p>The collection of ownership settings for a space.</p>', 'refs' => [ 'CreateSpaceRequest$OwnershipSettings' => '<p>A collection of ownership settings.</p>', 'DescribeSpaceResponse$OwnershipSettings' => '<p>The collection of ownership settings for a space.</p>', ], ], 'OwnershipSettingsSummary' => [ 'base' => '<p>Specifies summary information about the ownership settings.</p>', 'refs' => [ 'SpaceDetails$OwnershipSettingsSummary' => '<p>Specifies summary information about the ownership settings.</p>', ], ], 'PaginationToken' => [ 'base' => NULL, 'refs' => [ 'ListEndpointConfigsInput$NextToken' => '<p>If the result of the previous <code>ListEndpointConfig</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of endpoint configurations, use the token in the next request. </p>', 'ListEndpointConfigsOutput$NextToken' => '<p> If the response is truncated, SageMaker returns this token. To retrieve the next set of endpoint configurations, use it in the subsequent request </p>', 'ListEndpointsInput$NextToken' => '<p>If the result of a <code>ListEndpoints</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of endpoints, use the token in the next request.</p>', 'ListEndpointsOutput$NextToken' => '<p> If the response is truncated, SageMaker returns this token. To retrieve the next set of training jobs, use it in the subsequent request. </p>', 'ListInferenceComponentsInput$NextToken' => '<p>A token that you use to get the next set of results following a truncated response. If the response to the previous request was truncated, that response provides the value for this token.</p>', 'ListInferenceComponentsOutput$NextToken' => '<p>The token to use in a subsequent request to get the next set of results following a truncated response.</p>', 'ListModelsInput$NextToken' => '<p>If the response to a previous <code>ListModels</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of models, use the token in the next request.</p>', 'ListModelsOutput$NextToken' => '<p> If the response is truncated, SageMaker returns this token. To retrieve the next set of models, use it in the subsequent request. </p>', ], ], 'ParallelismConfiguration' => [ 'base' => '<p>Configuration that controls the parallelism of the pipeline. By default, the parallelism configuration specified applies to all executions of the pipeline unless overridden.</p>', 'refs' => [ 'CreatePipelineRequest$ParallelismConfiguration' => '<p>This is the configuration that controls the parallelism of the pipeline. If specified, it applies to all runs of this pipeline by default.</p>', 'DescribePipelineExecutionResponse$ParallelismConfiguration' => '<p>The parallelism configuration applied to the pipeline.</p>', 'DescribePipelineResponse$ParallelismConfiguration' => '<p>Lists the parallelism configuration applied to the pipeline.</p>', 'Pipeline$ParallelismConfiguration' => '<p>The parallelism configuration applied to the pipeline.</p>', 'PipelineExecution$ParallelismConfiguration' => '<p>The parallelism configuration applied to the pipeline execution.</p>', 'RetryPipelineExecutionRequest$ParallelismConfiguration' => '<p>This configuration, if specified, overrides the parallelism configuration of the parent pipeline.</p>', 'StartPipelineExecutionRequest$ParallelismConfiguration' => '<p>This configuration, if specified, overrides the parallelism configuration of the parent pipeline for this specific run.</p>', 'UpdatePipelineExecutionRequest$ParallelismConfiguration' => '<p>This configuration, if specified, overrides the parallelism configuration of the parent pipeline for this specific run.</p>', 'UpdatePipelineRequest$ParallelismConfiguration' => '<p>If specified, it applies to all executions of this pipeline by default.</p>', ], ], 'Parameter' => [ 'base' => '<p>Assigns a value to a named Pipeline parameter.</p>', 'refs' => [ 'ParameterList$member' => NULL, ], ], 'ParameterKey' => [ 'base' => NULL, 'refs' => [ 'AutoParameter$Name' => '<p>The name of the hyperparameter to optimize using Autotune.</p>', 'CategoricalParameterRange$Name' => '<p>The name of the categorical hyperparameter to tune.</p>', 'ContinuousParameterRange$Name' => '<p>The name of the continuous hyperparameter to tune.</p>', 'IntegerParameterRange$Name' => '<p>The name of the hyperparameter to search.</p>', ], ], 'ParameterList' => [ 'base' => NULL, 'refs' => [ 'ListPipelineParametersForExecutionResponse$PipelineParameters' => '<p>Contains a list of pipeline parameters. This list can be empty. </p>', 'PipelineExecution$PipelineParameters' => '<p>Contains a list of pipeline parameters. This list can be empty. </p>', 'StartPipelineExecutionRequest$PipelineParameters' => '<p>Contains a list of pipeline parameters. This list can be empty. </p>', ], ], 'ParameterName' => [ 'base' => NULL, 'refs' => [ 'HyperParameterSpecification$Name' => '<p>The name of this hyperparameter. The name must be unique.</p>', ], ], 'ParameterRange' => [ 'base' => '<p>Defines the possible values for categorical, continuous, and integer hyperparameters to be used by an algorithm.</p>', 'refs' => [ 'HyperParameterSpecification$Range' => '<p>The allowed range for this hyperparameter.</p>', ], ], 'ParameterRanges' => [ 'base' => '<p>Specifies ranges of integer, continuous, and categorical hyperparameters that a hyperparameter tuning job searches. The hyperparameter tuning job launches training jobs with hyperparameter values within these ranges to find the combination of values that result in the training job with the best performance as measured by the objective metric of the hyperparameter tuning job.</p> <note> <p>The maximum number of items specified for <code>Array Members</code> refers to the maximum number of hyperparameters for each range and also the maximum for the hyperparameter tuning job itself. That is, the sum of the number of hyperparameters for all the ranges can\'t exceed the maximum number specified.</p> </note>', 'refs' => [ 'HyperParameterTrainingJobDefinition$HyperParameterRanges' => NULL, 'HyperParameterTuningJobConfig$ParameterRanges' => '<p>The <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ParameterRanges.html">ParameterRanges</a> object that specifies the ranges of hyperparameters that this tuning job searches over to find the optimal configuration for the highest model performance against your chosen objective metric. </p>', ], ], 'ParameterType' => [ 'base' => NULL, 'refs' => [ 'HyperParameterSpecification$Type' => '<p>The type of this hyperparameter. The valid types are <code>Integer</code>, <code>Continuous</code>, <code>Categorical</code>, and <code>FreeText</code>.</p>', ], ], 'ParameterValue' => [ 'base' => NULL, 'refs' => [ 'AutoParameter$ValueHint' => '<p>An example value of the hyperparameter to optimize using Autotune.</p>', 'ContinuousParameterRange$MinValue' => '<p>The minimum value for the hyperparameter. The tuning job uses floating-point values between this value and <code>MaxValue</code>for tuning.</p>', 'ContinuousParameterRange$MaxValue' => '<p>The maximum value for the hyperparameter. The tuning job uses floating-point values between <code>MinValue</code> value and this value for tuning.</p>', 'ContinuousParameterRangeSpecification$MinValue' => '<p>The minimum floating-point value allowed.</p>', 'ContinuousParameterRangeSpecification$MaxValue' => '<p>The maximum floating-point value allowed.</p>', 'IntegerParameterRange$MinValue' => '<p>The minimum value of the hyperparameter to search.</p>', 'IntegerParameterRange$MaxValue' => '<p>The maximum value of the hyperparameter to search.</p>', 'IntegerParameterRangeSpecification$MinValue' => '<p>The minimum integer value allowed.</p>', 'IntegerParameterRangeSpecification$MaxValue' => '<p>The maximum integer value allowed.</p>', 'ParameterValues$member' => NULL, ], ], 'ParameterValues' => [ 'base' => NULL, 'refs' => [ 'CategoricalParameterRange$Values' => '<p>A list of the categories for the hyperparameter.</p>', 'CategoricalParameterRangeSpecification$Values' => '<p>The allowed categories for the hyperparameter.</p>', ], ], 'Parent' => [ 'base' => '<p>The trial that a trial component is associated with and the experiment the trial is part of. A component might not be associated with a trial. A component can be associated with multiple trials.</p>', 'refs' => [ 'Parents$member' => NULL, ], ], 'ParentHyperParameterTuningJob' => [ 'base' => '<p>A previously completed or stopped hyperparameter tuning job to be used as a starting point for a new hyperparameter tuning job.</p>', 'refs' => [ 'ParentHyperParameterTuningJobs$member' => NULL, ], ], 'ParentHyperParameterTuningJobs' => [ 'base' => NULL, 'refs' => [ 'HyperParameterTuningJobWarmStartConfig$ParentHyperParameterTuningJobs' => '<p>An array of hyperparameter tuning jobs that are used as the starting point for the new hyperparameter tuning job. For more information about warm starting a hyperparameter tuning job, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-warm-start.html">Using a Previous Hyperparameter Tuning Job as a Starting Point</a>.</p> <p>Hyperparameter tuning jobs created before October 1, 2018 cannot be used as parent jobs for warm start tuning jobs.</p>', ], ], 'Parents' => [ 'base' => NULL, 'refs' => [ 'TrialComponent$Parents' => '<p>An array of the parents of the component. A parent is a trial the component is associated with and the experiment the trial is part of. A component might not have any parents.</p>', ], ], 'PendingDeploymentSummary' => [ 'base' => '<p>The summary of an in-progress deployment when an endpoint is creating or updating with a new endpoint configuration.</p>', 'refs' => [ 'DescribeEndpointOutput$PendingDeploymentSummary' => '<p>Returns the summary of an in-progress deployment. This field is only returned when the endpoint is creating or updating with a new endpoint configuration.</p>', ], ], 'PendingProductionVariantSummary' => [ 'base' => '<p>The production variant summary for a deployment when an endpoint is creating or updating with the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpoint.html">CreateEndpoint</a> or <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateEndpoint.html">UpdateEndpoint</a> operations. Describes the <code>VariantStatus </code>, weight and capacity for a production variant associated with an endpoint. </p>', 'refs' => [ 'PendingProductionVariantSummaryList$member' => NULL, ], ], 'PendingProductionVariantSummaryList' => [ 'base' => NULL, 'refs' => [ 'PendingDeploymentSummary$ProductionVariants' => '<p>An array of <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_PendingProductionVariantSummary.html">PendingProductionVariantSummary</a> objects, one for each model hosted behind this endpoint for the in-progress deployment.</p>', 'PendingDeploymentSummary$ShadowProductionVariants' => '<p>An array of <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_PendingProductionVariantSummary.html">PendingProductionVariantSummary</a> objects, one for each model hosted behind this endpoint in shadow mode with production traffic replicated from the model specified on <code>ProductionVariants</code> for the in-progress deployment.</p>', ], ], 'Percentage' => [ 'base' => NULL, 'refs' => [ 'DeviceSelectionConfig$Percentage' => '<p>Percentage of devices in the fleet to deploy to the current stage.</p>', 'ShadowModelVariantConfig$SamplingPercentage' => '<p> The percentage of inference requests that Amazon SageMaker replicates from the production variant to the shadow variant. </p>', ], ], 'Phase' => [ 'base' => '<p>Defines the traffic pattern.</p>', 'refs' => [ 'Phases$member' => NULL, ], ], 'Phases' => [ 'base' => NULL, 'refs' => [ 'TrafficPattern$Phases' => '<p>Defines the phases traffic specification.</p>', ], ], 'Pipeline' => [ 'base' => '<p>A SageMaker Model Building Pipeline instance.</p>', 'refs' => [ 'SearchRecord$Pipeline' => NULL, ], ], 'PipelineArn' => [ 'base' => NULL, 'refs' => [ 'CreatePipelineResponse$PipelineArn' => '<p>The Amazon Resource Name (ARN) of the created pipeline.</p>', 'DeletePipelineResponse$PipelineArn' => '<p>The Amazon Resource Name (ARN) of the pipeline to delete.</p>', 'DescribePipelineExecutionResponse$PipelineArn' => '<p>The Amazon Resource Name (ARN) of the pipeline.</p>', 'DescribePipelineResponse$PipelineArn' => '<p>The Amazon Resource Name (ARN) of the pipeline.</p>', 'Pipeline$PipelineArn' => '<p>The Amazon Resource Name (ARN) of the pipeline.</p>', 'PipelineExecution$PipelineArn' => '<p>The Amazon Resource Name (ARN) of the pipeline that was executed.</p>', 'PipelineSummary$PipelineArn' => '<p> The Amazon Resource Name (ARN) of the pipeline.</p>', 'UpdatePipelineResponse$PipelineArn' => '<p>The Amazon Resource Name (ARN) of the updated pipeline.</p>', ], ], 'PipelineDefinition' => [ 'base' => NULL, 'refs' => [ 'CreatePipelineRequest$PipelineDefinition' => '<p>The <a href="https://aws-sagemaker-mlops.github.io/sagemaker-model-building-pipeline-definition-JSON-schema/">JSON pipeline definition</a> of the pipeline.</p>', 'DescribePipelineDefinitionForExecutionResponse$PipelineDefinition' => '<p>The JSON pipeline definition.</p>', 'DescribePipelineResponse$PipelineDefinition' => '<p>The JSON pipeline definition.</p>', 'UpdatePipelineRequest$PipelineDefinition' => '<p>The JSON pipeline definition.</p>', ], ], 'PipelineDefinitionS3Location' => [ 'base' => '<p>The location of the pipeline definition stored in Amazon S3.</p>', 'refs' => [ 'CreatePipelineRequest$PipelineDefinitionS3Location' => '<p>The location of the pipeline definition stored in Amazon S3. If specified, SageMaker will retrieve the pipeline definition from this location.</p>', 'UpdatePipelineRequest$PipelineDefinitionS3Location' => '<p>The location of the pipeline definition stored in Amazon S3. If specified, SageMaker will retrieve the pipeline definition from this location.</p>', ], ], 'PipelineDescription' => [ 'base' => NULL, 'refs' => [ 'CreatePipelineRequest$PipelineDescription' => '<p>A description of the pipeline.</p>', 'DescribePipelineResponse$PipelineDescription' => '<p>The description of the pipeline.</p>', 'Pipeline$PipelineDescription' => '<p>The description of the pipeline.</p>', 'PipelineSummary$PipelineDescription' => '<p>The description of the pipeline.</p>', 'UpdatePipelineRequest$PipelineDescription' => '<p>The description of the pipeline.</p>', ], ], 'PipelineExecution' => [ 'base' => '<p>An execution of a pipeline.</p>', 'refs' => [ 'SearchRecord$PipelineExecution' => NULL, ], ], 'PipelineExecutionArn' => [ 'base' => NULL, 'refs' => [ 'CacheHitResult$SourcePipelineExecutionArn' => '<p>The Amazon Resource Name (ARN) of the pipeline execution.</p>', 'DescribePipelineDefinitionForExecutionRequest$PipelineExecutionArn' => '<p>The Amazon Resource Name (ARN) of the pipeline execution.</p>', 'DescribePipelineExecutionRequest$PipelineExecutionArn' => '<p>The Amazon Resource Name (ARN) of the pipeline execution.</p>', 'DescribePipelineExecutionResponse$PipelineExecutionArn' => '<p>The Amazon Resource Name (ARN) of the pipeline execution.</p>', 'ListPipelineExecutionStepsRequest$PipelineExecutionArn' => '<p>The Amazon Resource Name (ARN) of the pipeline execution.</p>', 'ListPipelineParametersForExecutionRequest$PipelineExecutionArn' => '<p>The Amazon Resource Name (ARN) of the pipeline execution.</p>', 'PipelineExecution$PipelineExecutionArn' => '<p>The Amazon Resource Name (ARN) of the pipeline execution.</p>', 'PipelineExecutionSummary$PipelineExecutionArn' => '<p>The Amazon Resource Name (ARN) of the pipeline execution.</p>', 'RetryPipelineExecutionRequest$PipelineExecutionArn' => '<p>The Amazon Resource Name (ARN) of the pipeline execution.</p>', 'RetryPipelineExecutionResponse$PipelineExecutionArn' => '<p>The Amazon Resource Name (ARN) of the pipeline execution.</p>', 'SelectiveExecutionConfig$SourcePipelineExecutionArn' => '<p>The ARN from a reference execution of the current pipeline. Used to copy input collaterals needed for the selected steps to run. The execution status of the pipeline can be either <code>Failed</code> or <code>Success</code>.</p> <p>This field is required if the steps you specify for <code>SelectedSteps</code> depend on output collaterals from any non-specified pipeline steps. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/pipelines-selective-ex.html">Selective Execution for Pipeline Steps</a>.</p>', 'SelectiveExecutionResult$SourcePipelineExecutionArn' => '<p>The ARN from an execution of the current pipeline.</p>', 'SendPipelineExecutionStepFailureResponse$PipelineExecutionArn' => '<p>The Amazon Resource Name (ARN) of the pipeline execution.</p>', 'SendPipelineExecutionStepSuccessResponse$PipelineExecutionArn' => '<p>The Amazon Resource Name (ARN) of the pipeline execution.</p>', 'StartPipelineExecutionResponse$PipelineExecutionArn' => '<p>The Amazon Resource Name (ARN) of the pipeline execution.</p>', 'StopPipelineExecutionRequest$PipelineExecutionArn' => '<p>The Amazon Resource Name (ARN) of the pipeline execution.</p>', 'StopPipelineExecutionResponse$PipelineExecutionArn' => '<p>The Amazon Resource Name (ARN) of the pipeline execution.</p>', 'UpdatePipelineExecutionRequest$PipelineExecutionArn' => '<p>The Amazon Resource Name (ARN) of the pipeline execution.</p>', 'UpdatePipelineExecutionResponse$PipelineExecutionArn' => '<p>The Amazon Resource Name (ARN) of the updated pipeline execution.</p>', ], ], 'PipelineExecutionDescription' => [ 'base' => NULL, 'refs' => [ 'DescribePipelineExecutionResponse$PipelineExecutionDescription' => '<p>The description of the pipeline execution.</p>', 'PipelineExecution$PipelineExecutionDescription' => '<p>The description of the pipeline execution.</p>', 'PipelineExecutionSummary$PipelineExecutionDescription' => '<p>The description of the pipeline execution.</p>', 'StartPipelineExecutionRequest$PipelineExecutionDescription' => '<p>The description of the pipeline execution.</p>', 'UpdatePipelineExecutionRequest$PipelineExecutionDescription' => '<p>The description of the pipeline execution.</p>', ], ], 'PipelineExecutionFailureReason' => [ 'base' => NULL, 'refs' => [ 'DescribePipelineExecutionResponse$FailureReason' => '<p>If the execution failed, a message describing why.</p>', 'PipelineExecution$FailureReason' => '<p>If the execution failed, a message describing why.</p>', ], ], 'PipelineExecutionName' => [ 'base' => NULL, 'refs' => [ 'DescribePipelineExecutionResponse$PipelineExecutionDisplayName' => '<p>The display name of the pipeline execution.</p>', 'PipelineExecution$PipelineExecutionDisplayName' => '<p>The display name of the pipeline execution.</p>', 'PipelineExecutionSummary$PipelineExecutionDisplayName' => '<p>The display name of the pipeline execution.</p>', 'StartPipelineExecutionRequest$PipelineExecutionDisplayName' => '<p>The display name of the pipeline execution.</p>', 'UpdatePipelineExecutionRequest$PipelineExecutionDisplayName' => '<p>The display name of the pipeline execution.</p>', ], ], 'PipelineExecutionStatus' => [ 'base' => NULL, 'refs' => [ 'DescribePipelineExecutionResponse$PipelineExecutionStatus' => '<p>The status of the pipeline execution.</p>', 'PipelineExecution$PipelineExecutionStatus' => '<p>The status of the pipeline status.</p>', 'PipelineExecutionSummary$PipelineExecutionStatus' => '<p>The status of the pipeline execution.</p>', ], ], 'PipelineExecutionStep' => [ 'base' => '<p>An execution of a step in a pipeline.</p>', 'refs' => [ 'PipelineExecutionStepList$member' => NULL, ], ], 'PipelineExecutionStepList' => [ 'base' => NULL, 'refs' => [ 'ListPipelineExecutionStepsResponse$PipelineExecutionSteps' => '<p>A list of <code>PipeLineExecutionStep</code> objects. Each <code>PipeLineExecutionStep</code> consists of StepName, StartTime, EndTime, StepStatus, and Metadata. Metadata is an object with properties for each job that contains relevant information about the job created by the step.</p>', ], ], 'PipelineExecutionStepMetadata' => [ 'base' => '<p>Metadata for a step execution.</p>', 'refs' => [ 'PipelineExecutionStep$Metadata' => '<p>Metadata to run the pipeline step.</p>', ], ], 'PipelineExecutionSummary' => [ 'base' => '<p>A pipeline execution summary.</p>', 'refs' => [ 'PipelineExecutionSummaryList$member' => NULL, ], ], 'PipelineExecutionSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListPipelineExecutionsResponse$PipelineExecutionSummaries' => '<p>Contains a sorted list of pipeline execution summary objects matching the specified filters. Each run summary includes the Amazon Resource Name (ARN) of the pipeline execution, the run date, and the status. This list can be empty. </p>', ], ], 'PipelineExperimentConfig' => [ 'base' => '<p>Specifies the names of the experiment and trial created by a pipeline.</p>', 'refs' => [ 'DescribePipelineExecutionResponse$PipelineExperimentConfig' => NULL, 'PipelineExecution$PipelineExperimentConfig' => NULL, ], ], 'PipelineName' => [ 'base' => NULL, 'refs' => [ 'CreatePipelineRequest$PipelineName' => '<p>The name of the pipeline.</p>', 'CreatePipelineRequest$PipelineDisplayName' => '<p>The display name of the pipeline.</p>', 'DeletePipelineRequest$PipelineName' => '<p>The name of the pipeline to delete.</p>', 'DescribePipelineResponse$PipelineName' => '<p>The name of the pipeline.</p>', 'DescribePipelineResponse$PipelineDisplayName' => '<p>The display name of the pipeline.</p>', 'ListPipelinesRequest$PipelineNamePrefix' => '<p>The prefix of the pipeline name.</p>', 'Pipeline$PipelineName' => '<p>The name of the pipeline.</p>', 'Pipeline$PipelineDisplayName' => '<p>The display name of the pipeline.</p>', 'PipelineSummary$PipelineName' => '<p>The name of the pipeline.</p>', 'PipelineSummary$PipelineDisplayName' => '<p>The display name of the pipeline.</p>', 'UpdatePipelineRequest$PipelineName' => '<p>The name of the pipeline to update.</p>', 'UpdatePipelineRequest$PipelineDisplayName' => '<p>The display name of the pipeline.</p>', ], ], 'PipelineNameOrArn' => [ 'base' => NULL, 'refs' => [ 'DescribePipelineRequest$PipelineName' => '<p>The name or Amazon Resource Name (ARN) of the pipeline to describe.</p>', 'ListPipelineExecutionsRequest$PipelineName' => '<p>The name or Amazon Resource Name (ARN) of the pipeline.</p>', 'StartPipelineExecutionRequest$PipelineName' => '<p>The name or Amazon Resource Name (ARN) of the pipeline.</p>', ], ], 'PipelineParameterName' => [ 'base' => NULL, 'refs' => [ 'Parameter$Name' => '<p>The name of the parameter to assign a value to. This parameter name must match a named parameter in the pipeline definition.</p>', ], ], 'PipelineStatus' => [ 'base' => NULL, 'refs' => [ 'DescribePipelineResponse$PipelineStatus' => '<p>The status of the pipeline execution.</p>', 'Pipeline$PipelineStatus' => '<p>The status of the pipeline.</p>', ], ], 'PipelineSummary' => [ 'base' => '<p>A summary of a pipeline.</p>', 'refs' => [ 'PipelineSummaryList$member' => NULL, ], ], 'PipelineSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListPipelinesResponse$PipelineSummaries' => '<p>Contains a sorted list of <code>PipelineSummary</code> objects matching the specified filters. Each <code>PipelineSummary</code> consists of PipelineArn, PipelineName, ExperimentName, PipelineDescription, CreationTime, LastModifiedTime, LastRunTime, and RoleArn. This list can be empty. </p>', ], ], 'PlatformIdentifier' => [ 'base' => NULL, 'refs' => [ 'CreateNotebookInstanceInput$PlatformIdentifier' => '<p>The platform identifier of the notebook instance runtime environment.</p>', 'DescribeNotebookInstanceOutput$PlatformIdentifier' => '<p>The platform identifier of the notebook instance runtime environment.</p>', ], ], 'PolicyString' => [ 'base' => NULL, 'refs' => [ 'GetModelPackageGroupPolicyOutput$ResourcePolicy' => '<p>The resource policy for the model group.</p>', 'PutModelPackageGroupPolicyInput$ResourcePolicy' => '<p>The resource policy for the model group.</p>', ], ], 'PredefinedMetricSpecification' => [ 'base' => '<p>A specification for a predefined metric.</p>', 'refs' => [ 'MetricSpecification$Predefined' => '<p>Information about a predefined metric.</p>', ], ], 'PresignedDomainUrl' => [ 'base' => NULL, 'refs' => [ 'CreatePresignedDomainUrlResponse$AuthorizedUrl' => '<p>The presigned URL.</p>', ], ], 'ProbabilityThresholdAttribute' => [ 'base' => NULL, 'refs' => [ 'BatchTransformInput$ProbabilityThresholdAttribute' => '<p>The threshold for the class probability to be evaluated as a positive result.</p>', 'EndpointInput$ProbabilityThresholdAttribute' => '<p>The threshold for the class probability to be evaluated as a positive result.</p>', ], ], 'ProblemType' => [ 'base' => NULL, 'refs' => [ 'CreateAutoMLJobRequest$ProblemType' => '<p>Defines the type of supervised learning problem available for the candidates. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-datasets-problem-types.html#autopilot-problem-types"> SageMaker Autopilot problem types</a>.</p>', 'DescribeAutoMLJobResponse$ProblemType' => '<p>Returns the job\'s problem type.</p>', 'ResolvedAttributes$ProblemType' => '<p>The problem type.</p>', 'TabularJobConfig$ProblemType' => '<p>The type of supervised learning problem available for the model candidates of the AutoML job V2. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-datasets-problem-types.html#autopilot-problem-types"> SageMaker Autopilot problem types</a>.</p> <note> <p>You must either specify the type of supervised learning problem in <code>ProblemType</code> and provide the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJobV2.html#sagemaker-CreateAutoMLJobV2-request-AutoMLJobObjective">AutoMLJobObjective</a> metric, or none at all.</p> </note>', 'TabularResolvedAttributes$ProblemType' => '<p>The type of supervised learning problem available for the model candidates of the AutoML job V2 (Binary Classification, Multiclass Classification, Regression). For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-datasets-problem-types.html#autopilot-problem-types"> SageMaker Autopilot problem types</a>.</p>', ], ], 'ProcessingClusterConfig' => [ 'base' => '<p>Configuration for the cluster used to run a processing job.</p>', 'refs' => [ 'ProcessingResources$ClusterConfig' => '<p>The configuration for the resources in a cluster used to run the processing job.</p>', ], ], 'ProcessingEnvironmentKey' => [ 'base' => NULL, 'refs' => [ 'MonitoringEnvironmentMap$key' => NULL, 'ProcessingEnvironmentMap$key' => NULL, ], ], 'ProcessingEnvironmentMap' => [ 'base' => NULL, 'refs' => [ 'CreateProcessingJobRequest$Environment' => '<p>The environment variables to set in the Docker container. Up to 100 key and values entries in the map are supported.</p>', 'DescribeProcessingJobResponse$Environment' => '<p>The environment variables set in the Docker container.</p>', 'ProcessingJob$Environment' => '<p>Sets the environment variables in the Docker container.</p>', ], ], 'ProcessingEnvironmentValue' => [ 'base' => NULL, 'refs' => [ 'MonitoringEnvironmentMap$value' => NULL, 'ProcessingEnvironmentMap$value' => NULL, ], ], 'ProcessingFeatureStoreOutput' => [ 'base' => '<p>Configuration for processing job outputs in Amazon SageMaker Feature Store.</p>', 'refs' => [ 'ProcessingOutput$FeatureStoreOutput' => '<p>Configuration for processing job outputs in Amazon SageMaker Feature Store. This processing output type is only supported when <code>AppManaged</code> is specified. </p>', ], ], 'ProcessingInput' => [ 'base' => '<p>The inputs for a processing job. The processing input must specify exactly one of either <code>S3Input</code> or <code>DatasetDefinition</code> types.</p>', 'refs' => [ 'ProcessingInputs$member' => NULL, ], ], 'ProcessingInputs' => [ 'base' => NULL, 'refs' => [ 'CreateProcessingJobRequest$ProcessingInputs' => '<p>An array of inputs configuring the data to download into the processing container.</p>', 'DescribeProcessingJobResponse$ProcessingInputs' => '<p>The inputs for a processing job.</p>', 'ProcessingJob$ProcessingInputs' => '<p>List of input configurations for the processing job.</p>', ], ], 'ProcessingInstanceCount' => [ 'base' => NULL, 'refs' => [ 'MonitoringClusterConfig$InstanceCount' => '<p>The number of ML compute instances to use in the model monitoring job. For distributed processing jobs, specify a value greater than 1. The default value is 1.</p>', 'ProcessingClusterConfig$InstanceCount' => '<p>The number of ML compute instances to use in the processing job. For distributed processing jobs, specify a value greater than 1. The default value is 1.</p>', ], ], 'ProcessingInstanceType' => [ 'base' => NULL, 'refs' => [ 'DebugRuleConfiguration$InstanceType' => '<p>The instance type to deploy a custom rule for debugging a training job.</p>', 'MonitoringClusterConfig$InstanceType' => '<p>The ML compute instance type for the processing job.</p>', 'ProcessingClusterConfig$InstanceType' => '<p>The ML compute instance type for the processing job.</p>', 'ProfilerRuleConfiguration$InstanceType' => '<p>The instance type to deploy a custom rule for profiling a training job.</p>', ], ], 'ProcessingJob' => [ 'base' => '<p>An Amazon SageMaker processing job that is used to analyze data and evaluate models. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/processing-job.html">Process Data and Evaluate Models</a>.</p>', 'refs' => [ 'TrialComponentSourceDetail$ProcessingJob' => '<p>Information about a processing job that\'s the source of a trial component.</p>', ], ], 'ProcessingJobArn' => [ 'base' => NULL, 'refs' => [ 'CreateProcessingJobResponse$ProcessingJobArn' => '<p>The Amazon Resource Name (ARN) of the processing job.</p>', 'DebugRuleEvaluationStatus$RuleEvaluationJobArn' => '<p>The Amazon Resource Name (ARN) of the rule evaluation job.</p>', 'DescribeProcessingJobResponse$ProcessingJobArn' => '<p>The Amazon Resource Name (ARN) of the processing job.</p>', 'MonitoringExecutionSummary$ProcessingJobArn' => '<p>The Amazon Resource Name (ARN) of the monitoring job.</p>', 'ProcessingJob$ProcessingJobArn' => '<p>The ARN of the processing job.</p>', 'ProcessingJobStepMetadata$Arn' => '<p>The Amazon Resource Name (ARN) of the processing job.</p>', 'ProcessingJobSummary$ProcessingJobArn' => '<p>The Amazon Resource Name (ARN) of the processing job..</p>', 'ProfilerRuleEvaluationStatus$RuleEvaluationJobArn' => '<p>The Amazon Resource Name (ARN) of the rule evaluation job.</p>', ], ], 'ProcessingJobName' => [ 'base' => NULL, 'refs' => [ 'CreateProcessingJobRequest$ProcessingJobName' => '<p> The name of the processing job. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>', 'DataQualityBaselineConfig$BaseliningJobName' => '<p>The name of the job that performs baselining for the data quality monitoring job.</p>', 'DescribeProcessingJobRequest$ProcessingJobName' => '<p>The name of the processing job. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>', 'DescribeProcessingJobResponse$ProcessingJobName' => '<p>The name of the processing job. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>', 'ModelBiasBaselineConfig$BaseliningJobName' => '<p>The name of the baseline model bias job.</p>', 'ModelExplainabilityBaselineConfig$BaseliningJobName' => '<p>The name of the baseline model explainability job.</p>', 'ModelQualityBaselineConfig$BaseliningJobName' => '<p>The name of the job that performs baselining for the monitoring job.</p>', 'MonitoringBaselineConfig$BaseliningJobName' => '<p>The name of the job that performs baselining for the monitoring job.</p>', 'ProcessingJob$ProcessingJobName' => '<p>The name of the processing job.</p>', 'ProcessingJobSummary$ProcessingJobName' => '<p>The name of the processing job.</p>', 'StopProcessingJobRequest$ProcessingJobName' => '<p>The name of the processing job to stop.</p>', ], ], 'ProcessingJobStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeProcessingJobResponse$ProcessingJobStatus' => '<p>Provides the status of a processing job.</p>', 'ListProcessingJobsRequest$StatusEquals' => '<p>A filter that retrieves only processing jobs with a specific status.</p>', 'ProcessingJob$ProcessingJobStatus' => '<p>The status of the processing job.</p>', 'ProcessingJobSummary$ProcessingJobStatus' => '<p>The status of the processing job.</p>', ], ], 'ProcessingJobStepMetadata' => [ 'base' => '<p>Metadata for a processing job step.</p>', 'refs' => [ 'PipelineExecutionStepMetadata$ProcessingJob' => '<p>The Amazon Resource Name (ARN) of the processing job that was run by this step execution.</p>', ], ], 'ProcessingJobSummaries' => [ 'base' => NULL, 'refs' => [ 'ListProcessingJobsResponse$ProcessingJobSummaries' => '<p>An array of <code>ProcessingJobSummary</code> objects, each listing a processing job.</p>', ], ], 'ProcessingJobSummary' => [ 'base' => '<p>Summary of information about a processing job.</p>', 'refs' => [ 'ProcessingJobSummaries$member' => NULL, ], ], 'ProcessingLocalPath' => [ 'base' => NULL, 'refs' => [ 'BatchTransformInput$LocalPath' => '<p>Path to the filesystem where the batch transform data is available to the container.</p>', 'DatasetDefinition$LocalPath' => '<p>The local path where you want Amazon SageMaker to download the Dataset Definition inputs to run a processing job. <code>LocalPath</code> is an absolute path to the input data. This is a required parameter when <code>AppManaged</code> is <code>False</code> (default).</p>', 'EndpointInput$LocalPath' => '<p>Path to the filesystem where the endpoint data is available to the container.</p>', 'MonitoringS3Output$LocalPath' => '<p>The local path to the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job. LocalPath is an absolute path for the output data.</p>', 'ProcessingS3Input$LocalPath' => '<p>The local path in your container where you want Amazon SageMaker to write input data to. <code>LocalPath</code> is an absolute path to the input data and must begin with <code>/opt/ml/processing/</code>. <code>LocalPath</code> is a required parameter when <code>AppManaged</code> is <code>False</code> (default).</p>', 'ProcessingS3Output$LocalPath' => '<p>The local path of a directory where you want Amazon SageMaker to upload its contents to Amazon S3. <code>LocalPath</code> is an absolute path to a directory containing output files. This directory will be created by the platform and exist when your container\'s entrypoint is invoked.</p>', ], ], 'ProcessingMaxRuntimeInSeconds' => [ 'base' => NULL, 'refs' => [ 'ProcessingStoppingCondition$MaxRuntimeInSeconds' => '<p>Specifies the maximum runtime in seconds.</p>', ], ], 'ProcessingOutput' => [ 'base' => '<p>Describes the results of a processing job. The processing output must specify exactly one of either <code>S3Output</code> or <code>FeatureStoreOutput</code> types.</p>', 'refs' => [ 'ProcessingOutputs$member' => NULL, ], ], 'ProcessingOutputConfig' => [ 'base' => '<p>Configuration for uploading output from the processing container.</p>', 'refs' => [ 'CreateProcessingJobRequest$ProcessingOutputConfig' => '<p>Output configuration for the processing job.</p>', 'DescribeProcessingJobResponse$ProcessingOutputConfig' => '<p>Output configuration for the processing job.</p>', 'ProcessingJob$ProcessingOutputConfig' => NULL, ], ], 'ProcessingOutputs' => [ 'base' => NULL, 'refs' => [ 'ProcessingOutputConfig$Outputs' => '<p>An array of outputs configuring the data to upload from the processing container.</p>', ], ], 'ProcessingResources' => [ 'base' => '<p>Identifies the resources, ML compute instances, and ML storage volumes to deploy for a processing job. In distributed training, you specify more than one instance.</p>', 'refs' => [ 'CreateProcessingJobRequest$ProcessingResources' => '<p>Identifies the resources, ML compute instances, and ML storage volumes to deploy for a processing job. In distributed training, you specify more than one instance.</p>', 'DescribeProcessingJobResponse$ProcessingResources' => '<p>Identifies the resources, ML compute instances, and ML storage volumes to deploy for a processing job. In distributed training, you specify more than one instance.</p>', 'ProcessingJob$ProcessingResources' => NULL, ], ], 'ProcessingS3CompressionType' => [ 'base' => NULL, 'refs' => [ 'ProcessingS3Input$S3CompressionType' => '<p>Whether to GZIP-decompress the data in Amazon S3 as it is streamed into the processing container. <code>Gzip</code> can only be used when <code>Pipe</code> mode is specified as the <code>S3InputMode</code>. In <code>Pipe</code> mode, Amazon SageMaker streams input data from the source directly to your container without using the EBS volume.</p>', ], ], 'ProcessingS3DataDistributionType' => [ 'base' => NULL, 'refs' => [ 'BatchTransformInput$S3DataDistributionType' => '<p>Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defaults to <code>FullyReplicated</code> </p>', 'EndpointInput$S3DataDistributionType' => '<p>Whether input data distributed in Amazon S3 is fully replicated or sharded by an Amazon S3 key. Defaults to <code>FullyReplicated</code> </p>', 'ProcessingS3Input$S3DataDistributionType' => '<p>Whether to distribute the data from Amazon S3 to all processing instances with <code>FullyReplicated</code>, or whether the data from Amazon S3 is shared by Amazon S3 key, downloading one shard of data to each processing instance.</p>', ], ], 'ProcessingS3DataType' => [ 'base' => NULL, 'refs' => [ 'ProcessingS3Input$S3DataType' => '<p>Whether you use an <code>S3Prefix</code> or a <code>ManifestFile</code> for the data type. If you choose <code>S3Prefix</code>, <code>S3Uri</code> identifies a key name prefix. Amazon SageMaker uses all objects with the specified key name prefix for the processing job. If you choose <code>ManifestFile</code>, <code>S3Uri</code> identifies an object that is a manifest file containing a list of object keys that you want Amazon SageMaker to use for the processing job.</p>', ], ], 'ProcessingS3Input' => [ 'base' => '<p>Configuration for downloading input data from Amazon S3 into the processing container.</p>', 'refs' => [ 'ProcessingInput$S3Input' => '<p>Configuration for downloading input data from Amazon S3 into the processing container.</p>', ], ], 'ProcessingS3InputMode' => [ 'base' => NULL, 'refs' => [ 'BatchTransformInput$S3InputMode' => '<p>Whether the <code>Pipe</code> or <code>File</code> is used as the input mode for transferring data for the monitoring job. <code>Pipe</code> mode is recommended for large datasets. <code>File</code> mode is useful for small files that fit in memory. Defaults to <code>File</code>.</p>', 'EndpointInput$S3InputMode' => '<p>Whether the <code>Pipe</code> or <code>File</code> is used as the input mode for transferring data for the monitoring job. <code>Pipe</code> mode is recommended for large datasets. <code>File</code> mode is useful for small files that fit in memory. Defaults to <code>File</code>.</p>', 'ProcessingS3Input$S3InputMode' => '<p>Whether to use <code>File</code> or <code>Pipe</code> input mode. In File mode, Amazon SageMaker copies the data from the input source onto the local ML storage volume before starting your processing container. This is the most commonly used input mode. In <code>Pipe</code> mode, Amazon SageMaker streams input data from the source directly to your processing container into named pipes without using the ML storage volume.</p>', ], ], 'ProcessingS3Output' => [ 'base' => '<p>Configuration for uploading output data to Amazon S3 from the processing container.</p>', 'refs' => [ 'ProcessingOutput$S3Output' => '<p>Configuration for processing job outputs in Amazon S3.</p>', ], ], 'ProcessingS3UploadMode' => [ 'base' => NULL, 'refs' => [ 'MonitoringS3Output$S3UploadMode' => '<p>Whether to upload the results of the monitoring job continuously or after the job completes.</p>', 'ProcessingS3Output$S3UploadMode' => '<p>Whether to upload the results of the processing job continuously or after the job completes.</p>', ], ], 'ProcessingStoppingCondition' => [ 'base' => '<p>Configures conditions under which the processing job should be stopped, such as how long the processing job has been running. After the condition is met, the processing job is stopped.</p>', 'refs' => [ 'CreateProcessingJobRequest$StoppingCondition' => '<p>The time limit for how long the processing job is allowed to run.</p>', 'DescribeProcessingJobResponse$StoppingCondition' => '<p>The time limit for how long the processing job is allowed to run.</p>', 'ProcessingJob$StoppingCondition' => NULL, ], ], 'ProcessingVolumeSizeInGB' => [ 'base' => NULL, 'refs' => [ 'MonitoringClusterConfig$VolumeSizeInGB' => '<p>The size of the ML storage volume, in gigabytes, that you want to provision. You must specify sufficient ML storage for your scenario.</p>', 'ProcessingClusterConfig$VolumeSizeInGB' => '<p>The size of the ML storage volume in gigabytes that you want to provision. You must specify sufficient ML storage for your scenario.</p> <note> <p>Certain Nitro-based instances include local storage with a fixed total size, dependent on the instance type. When using these instances for processing, Amazon SageMaker mounts the local instance storage instead of Amazon EBS gp2 storage. You can\'t request a <code>VolumeSizeInGB</code> greater than the total size of the local instance storage.</p> <p>For a list of instance types that support local instance storage, including the total size per instance type, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes">Instance Store Volumes</a>.</p> </note>', ], ], 'Processor' => [ 'base' => NULL, 'refs' => [ 'CreateImageVersionRequest$Processor' => '<p>Indicates CPU or GPU compatibility.</p> <ul> <li> <p> <code>CPU</code>: The image version is compatible with CPU.</p> </li> <li> <p> <code>GPU</code>: The image version is compatible with GPU.</p> </li> </ul>', 'DescribeImageVersionResponse$Processor' => '<p>Indicates CPU or GPU compatibility.</p> <ul> <li> <p> <code>CPU</code>: The image version is compatible with CPU.</p> </li> <li> <p> <code>GPU</code>: The image version is compatible with GPU.</p> </li> </ul>', 'UpdateImageVersionRequest$Processor' => '<p>Indicates CPU or GPU compatibility.</p> <ul> <li> <p> <code>CPU</code>: The image version is compatible with CPU.</p> </li> <li> <p> <code>GPU</code>: The image version is compatible with GPU.</p> </li> </ul>', ], ], 'ProductId' => [ 'base' => NULL, 'refs' => [ 'DescribeAlgorithmOutput$ProductId' => '<p>The product identifier of the algorithm.</p>', 'ModelPackageContainerDefinition$ProductId' => '<p>The Amazon Web Services Marketplace product ID of the model package.</p>', ], ], 'ProductListings' => [ 'base' => NULL, 'refs' => [ 'Workteam$ProductListingIds' => '<p>The Amazon Marketplace identifier for a vendor\'s work team.</p>', ], ], 'ProductionVariant' => [ 'base' => '<p> Identifies a model that you want to host and the resources chosen to deploy for hosting it. If you are deploying multiple models, tell SageMaker how to distribute traffic among the models by specifying variant weights. For more information on production variants, check <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-ab-testing.html"> Production variants</a>. </p>', 'refs' => [ 'ProductionVariantList$member' => NULL, ], ], 'ProductionVariantAcceleratorType' => [ 'base' => NULL, 'refs' => [ 'PendingProductionVariantSummary$AcceleratorType' => '<p>The size of the Elastic Inference (EI) instance to use for the production variant. EI instances provide on-demand GPU computing for inference. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon SageMaker</a>.</p>', 'ProductionVariant$AcceleratorType' => '<p>The size of the Elastic Inference (EI) instance to use for the production variant. EI instances provide on-demand GPU computing for inference. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon SageMaker</a>.</p>', ], ], 'ProductionVariantContainerStartupHealthCheckTimeoutInSeconds' => [ 'base' => NULL, 'refs' => [ 'InferenceComponentStartupParameters$ContainerStartupHealthCheckTimeoutInSeconds' => '<p>The timeout value, in seconds, for your inference container to pass health check by Amazon S3 Hosting. For more information about health check, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-inference-code.html#your-algorithms-inference-algo-ping-requests">How Your Container Should Respond to Health Check (Ping) Requests</a>.</p>', 'ProductionVariant$ContainerStartupHealthCheckTimeoutInSeconds' => '<p>The timeout value, in seconds, for your inference container to pass health check by SageMaker Hosting. For more information about health check, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-inference-code.html#your-algorithms-inference-algo-ping-requests">How Your Container Should Respond to Health Check (Ping) Requests</a>.</p>', ], ], 'ProductionVariantCoreDumpConfig' => [ 'base' => '<p>Specifies configuration for a core dump from the model container when the process crashes.</p>', 'refs' => [ 'ProductionVariant$CoreDumpConfig' => '<p>Specifies configuration for a core dump from the model container when the process crashes.</p>', ], ], 'ProductionVariantInferenceAmiVersion' => [ 'base' => NULL, 'refs' => [ 'ProductionVariant$InferenceAmiVersion' => '<p>Specifies an option from a collection of preconfigured Amazon Machine Image (AMI) images. Each image is configured by Amazon Web Services with a set of software and driver versions. Amazon Web Services optimizes these configurations for different machine learning workloads.</p> <p>By selecting an AMI version, you can ensure that your inference environment is compatible with specific software requirements, such as CUDA driver versions, Linux kernel versions, or Amazon Web Services Neuron driver versions.</p>', ], ], 'ProductionVariantInstanceType' => [ 'base' => NULL, 'refs' => [ 'EndpointInputConfiguration$InstanceType' => '<p>The instance types to use for the load test.</p>', 'EndpointOutputConfiguration$InstanceType' => '<p>The instance type recommended by Amazon SageMaker Inference Recommender.</p>', 'PendingProductionVariantSummary$InstanceType' => '<p>The type of instances associated with the variant.</p>', 'ProductionVariant$InstanceType' => '<p>The ML compute instance type.</p>', 'RealTimeInferenceRecommendation$InstanceType' => '<p>The recommended instance type for Real-Time Inference.</p>', 'RealtimeInferenceInstanceTypes$member' => NULL, ], ], 'ProductionVariantList' => [ 'base' => NULL, 'refs' => [ 'CreateEndpointConfigInput$ProductionVariants' => '<p>An array of <code>ProductionVariant</code> objects, one for each model that you want to host at this endpoint.</p>', 'CreateEndpointConfigInput$ShadowProductionVariants' => '<p>An array of <code>ProductionVariant</code> objects, one for each model that you want to host at this endpoint in shadow mode with production traffic replicated from the model specified on <code>ProductionVariants</code>. If you use this field, you can only specify one variant for <code>ProductionVariants</code> and one variant for <code>ShadowProductionVariants</code>.</p>', 'DescribeEndpointConfigOutput$ProductionVariants' => '<p>An array of <code>ProductionVariant</code> objects, one for each model that you want to host at this endpoint.</p>', 'DescribeEndpointConfigOutput$ShadowProductionVariants' => '<p>An array of <code>ProductionVariant</code> objects, one for each model that you want to host at this endpoint in shadow mode with production traffic replicated from the model specified on <code>ProductionVariants</code>.</p>', ], ], 'ProductionVariantManagedInstanceScaling' => [ 'base' => '<p>Settings that control the range in the number of instances that the endpoint provisions as it scales up or down to accommodate traffic. </p>', 'refs' => [ 'PendingProductionVariantSummary$ManagedInstanceScaling' => '<p>Settings that control the range in the number of instances that the endpoint provisions as it scales up or down to accommodate traffic. </p>', 'ProductionVariant$ManagedInstanceScaling' => '<p>Settings that control the range in the number of instances that the endpoint provisions as it scales up or down to accommodate traffic. </p>', 'ProductionVariantSummary$ManagedInstanceScaling' => '<p>Settings that control the range in the number of instances that the endpoint provisions as it scales up or down to accommodate traffic. </p>', ], ], 'ProductionVariantModelDataDownloadTimeoutInSeconds' => [ 'base' => NULL, 'refs' => [ 'InferenceComponentStartupParameters$ModelDataDownloadTimeoutInSeconds' => '<p>The timeout value, in seconds, to download and extract the model that you want to host from Amazon S3 to the individual inference instance associated with this inference component.</p>', 'ProductionVariant$ModelDataDownloadTimeoutInSeconds' => '<p>The timeout value, in seconds, to download and extract the model that you want to host from Amazon S3 to the individual inference instance associated with this production variant.</p>', ], ], 'ProductionVariantRoutingConfig' => [ 'base' => '<p>Settings that control how the endpoint routes incoming traffic to the instances that the endpoint hosts.</p>', 'refs' => [ 'PendingProductionVariantSummary$RoutingConfig' => '<p>Settings that control how the endpoint routes incoming traffic to the instances that the endpoint hosts.</p>', 'ProductionVariant$RoutingConfig' => '<p>Settings that control how the endpoint routes incoming traffic to the instances that the endpoint hosts.</p>', 'ProductionVariantSummary$RoutingConfig' => '<p>Settings that control how the endpoint routes incoming traffic to the instances that the endpoint hosts.</p>', ], ], 'ProductionVariantSSMAccess' => [ 'base' => NULL, 'refs' => [ 'ProductionVariant$EnableSSMAccess' => '<p> You can use this parameter to turn on native Amazon Web Services Systems Manager (SSM) access for a production variant behind an endpoint. By default, SSM access is disabled for all production variants behind an endpoint. You can turn on or turn off SSM access for a production variant behind an existing endpoint by creating a new endpoint configuration and calling <code>UpdateEndpoint</code>. </p>', ], ], 'ProductionVariantServerlessConfig' => [ 'base' => '<p>Specifies the serverless configuration for an endpoint variant.</p>', 'refs' => [ 'EndpointInputConfiguration$ServerlessConfig' => NULL, 'EndpointOutputConfiguration$ServerlessConfig' => NULL, 'PendingProductionVariantSummary$CurrentServerlessConfig' => '<p>The serverless configuration for the endpoint.</p>', 'PendingProductionVariantSummary$DesiredServerlessConfig' => '<p>The serverless configuration requested for this deployment, as specified in the endpoint configuration for the endpoint.</p>', 'ProductionVariant$ServerlessConfig' => '<p>The serverless configuration for an endpoint. Specifies a serverless endpoint configuration instead of an instance-based endpoint configuration.</p>', 'ProductionVariantSummary$CurrentServerlessConfig' => '<p>The serverless configuration for the endpoint.</p>', 'ProductionVariantSummary$DesiredServerlessConfig' => '<p>The serverless configuration requested for the endpoint update.</p>', ], ], 'ProductionVariantServerlessUpdateConfig' => [ 'base' => '<p>Specifies the serverless update concurrency configuration for an endpoint variant.</p>', 'refs' => [ 'DesiredWeightAndCapacity$ServerlessUpdateConfig' => '<p>Specifies the serverless update concurrency configuration for an endpoint variant.</p>', ], ], 'ProductionVariantStatus' => [ 'base' => '<p>Describes the status of the production variant.</p>', 'refs' => [ 'ProductionVariantStatusList$member' => NULL, ], ], 'ProductionVariantStatusList' => [ 'base' => NULL, 'refs' => [ 'PendingProductionVariantSummary$VariantStatus' => '<p>The endpoint variant status which describes the current deployment stage status or operational status.</p>', 'ProductionVariantSummary$VariantStatus' => '<p>The endpoint variant status which describes the current deployment stage status or operational status.</p>', ], ], 'ProductionVariantSummary' => [ 'base' => '<p>Describes weight and capacities for a production variant associated with an endpoint. If you sent a request to the <code>UpdateEndpointWeightsAndCapacities</code> API and the endpoint status is <code>Updating</code>, you get different desired and current values. </p>', 'refs' => [ 'ProductionVariantSummaryList$member' => NULL, ], ], 'ProductionVariantSummaryList' => [ 'base' => NULL, 'refs' => [ 'DescribeEndpointOutput$ProductionVariants' => '<p>An array of <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ProductionVariantSummary.html">ProductionVariantSummary</a> objects, one for each model hosted behind this endpoint.</p>', 'DescribeEndpointOutput$ShadowProductionVariants' => '<p>An array of <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ProductionVariantSummary.html">ProductionVariantSummary</a> objects, one for each model that you want to host at this endpoint in shadow mode with production traffic replicated from the model specified on <code>ProductionVariants</code>.</p>', 'Endpoint$ProductionVariants' => '<p>A list of the production variants hosted on the endpoint. Each production variant is a model.</p>', 'Endpoint$ShadowProductionVariants' => '<p>A list of the shadow variants hosted on the endpoint. Each shadow variant is a model in shadow mode with production traffic replicated from the production variant.</p>', ], ], 'ProductionVariantVolumeSizeInGB' => [ 'base' => NULL, 'refs' => [ 'ProductionVariant$VolumeSizeInGB' => '<p>The size, in GB, of the ML storage volume attached to individual inference instance associated with the production variant. Currently only Amazon EBS gp2 storage volumes are supported.</p>', ], ], 'ProfilerConfig' => [ 'base' => '<p>Configuration information for Amazon SageMaker Debugger system monitoring, framework profiling, and storage paths.</p>', 'refs' => [ 'CreateTrainingJobRequest$ProfilerConfig' => NULL, 'DescribeTrainingJobResponse$ProfilerConfig' => NULL, 'TrainingJob$ProfilerConfig' => NULL, ], ], 'ProfilerConfigForUpdate' => [ 'base' => '<p>Configuration information for updating the Amazon SageMaker Debugger profile parameters, system and framework metrics configurations, and storage paths.</p>', 'refs' => [ 'UpdateTrainingJobRequest$ProfilerConfig' => '<p>Configuration information for Amazon SageMaker Debugger system monitoring, framework profiling, and storage paths.</p>', ], ], 'ProfilerRuleConfiguration' => [ 'base' => '<p>Configuration information for profiling rules.</p>', 'refs' => [ 'ProfilerRuleConfigurations$member' => NULL, ], ], 'ProfilerRuleConfigurations' => [ 'base' => NULL, 'refs' => [ 'CreateTrainingJobRequest$ProfilerRuleConfigurations' => '<p>Configuration information for Amazon SageMaker Debugger rules for profiling system and framework metrics.</p>', 'DescribeTrainingJobResponse$ProfilerRuleConfigurations' => '<p>Configuration information for Amazon SageMaker Debugger rules for profiling system and framework metrics.</p>', 'UpdateTrainingJobRequest$ProfilerRuleConfigurations' => '<p>Configuration information for Amazon SageMaker Debugger rules for profiling system and framework metrics.</p>', ], ], 'ProfilerRuleEvaluationStatus' => [ 'base' => '<p>Information about the status of the rule evaluation.</p>', 'refs' => [ 'ProfilerRuleEvaluationStatuses$member' => NULL, ], ], 'ProfilerRuleEvaluationStatuses' => [ 'base' => NULL, 'refs' => [ 'DescribeTrainingJobResponse$ProfilerRuleEvaluationStatuses' => '<p>Evaluation status of Amazon SageMaker Debugger rules for profiling on a training job.</p>', ], ], 'ProfilingIntervalInMilliseconds' => [ 'base' => NULL, 'refs' => [ 'ProfilerConfig$ProfilingIntervalInMilliseconds' => '<p>A time interval for capturing system metrics in milliseconds. Available values are 100, 200, 500, 1000 (1 second), 5000 (5 seconds), and 60000 (1 minute) milliseconds. The default value is 500 milliseconds.</p>', 'ProfilerConfigForUpdate$ProfilingIntervalInMilliseconds' => '<p>A time interval for capturing system metrics in milliseconds. Available values are 100, 200, 500, 1000 (1 second), 5000 (5 seconds), and 60000 (1 minute) milliseconds. The default value is 500 milliseconds.</p>', ], ], 'ProfilingParameters' => [ 'base' => NULL, 'refs' => [ 'ProfilerConfig$ProfilingParameters' => '<p>Configuration information for capturing framework metrics. Available key strings for different profiling options are <code>DetailedProfilingConfig</code>, <code>PythonProfilingConfig</code>, and <code>DataLoaderProfilingConfig</code>. The following codes are configuration structures for the <code>ProfilingParameters</code> parameter. To learn more about how to configure the <code>ProfilingParameters</code> parameter, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/debugger-createtrainingjob-api.html">Use the SageMaker and Debugger Configuration API Operations to Create, Update, and Debug Your Training Job</a>. </p>', 'ProfilerConfigForUpdate$ProfilingParameters' => '<p>Configuration information for capturing framework metrics. Available key strings for different profiling options are <code>DetailedProfilingConfig</code>, <code>PythonProfilingConfig</code>, and <code>DataLoaderProfilingConfig</code>. The following codes are configuration structures for the <code>ProfilingParameters</code> parameter. To learn more about how to configure the <code>ProfilingParameters</code> parameter, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/debugger-createtrainingjob-api.html">Use the SageMaker and Debugger Configuration API Operations to Create, Update, and Debug Your Training Job</a>. </p>', ], ], 'ProfilingStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeTrainingJobResponse$ProfilingStatus' => '<p>Profiling status of a training job.</p>', ], ], 'ProgrammingLang' => [ 'base' => NULL, 'refs' => [ 'CreateImageVersionRequest$ProgrammingLang' => '<p>The supported programming language and its version.</p>', 'DescribeImageVersionResponse$ProgrammingLang' => '<p>The supported programming language and its version.</p>', 'UpdateImageVersionRequest$ProgrammingLang' => '<p>The supported programming language and its version.</p>', ], ], 'Project' => [ 'base' => '<p>The properties of a project as returned by the Search API.</p>', 'refs' => [ 'SearchRecord$Project' => '<p>The properties of a project.</p>', ], ], 'ProjectArn' => [ 'base' => NULL, 'refs' => [ 'CreateProjectOutput$ProjectArn' => '<p>The Amazon Resource Name (ARN) of the project.</p>', 'DescribeProjectOutput$ProjectArn' => '<p>The Amazon Resource Name (ARN) of the project.</p>', 'Project$ProjectArn' => '<p>The Amazon Resource Name (ARN) of the project.</p>', 'ProjectSummary$ProjectArn' => '<p>The Amazon Resource Name (ARN) of the project.</p>', 'UpdateProjectOutput$ProjectArn' => '<p>The Amazon Resource Name (ARN) of the project.</p>', ], ], 'ProjectEntityName' => [ 'base' => NULL, 'refs' => [ 'CreateProjectInput$ProjectName' => '<p>The name of the project.</p>', 'DeleteProjectInput$ProjectName' => '<p>The name of the project to delete.</p>', 'DescribeProjectInput$ProjectName' => '<p>The name of the project to describe.</p>', 'DescribeProjectOutput$ProjectName' => '<p>The name of the project.</p>', 'ListProjectsInput$NameContains' => '<p>A filter that returns the projects whose name contains a specified string.</p>', 'Project$ProjectName' => '<p>The name of the project.</p>', 'ProjectSummary$ProjectName' => '<p>The name of the project.</p>', 'UpdateProjectInput$ProjectName' => '<p>The name of the project.</p>', ], ], 'ProjectId' => [ 'base' => NULL, 'refs' => [ 'CreateProjectOutput$ProjectId' => '<p>The ID of the new project.</p>', 'DescribeProjectOutput$ProjectId' => '<p>The ID of the project.</p>', 'Project$ProjectId' => '<p>The ID of the project.</p>', 'ProjectSummary$ProjectId' => '<p>The ID of the project.</p>', ], ], 'ProjectSortBy' => [ 'base' => NULL, 'refs' => [ 'ListProjectsInput$SortBy' => '<p>The field by which to sort results. The default is <code>CreationTime</code>.</p>', ], ], 'ProjectSortOrder' => [ 'base' => NULL, 'refs' => [ 'ListProjectsInput$SortOrder' => '<p>The sort order for results. The default is <code>Ascending</code>.</p>', ], ], 'ProjectStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeProjectOutput$ProjectStatus' => '<p>The status of the project.</p>', 'Project$ProjectStatus' => '<p>The status of the project.</p>', 'ProjectSummary$ProjectStatus' => '<p>The status of the project.</p>', ], ], 'ProjectSummary' => [ 'base' => '<p>Information about a project.</p>', 'refs' => [ 'ProjectSummaryList$member' => NULL, ], ], 'ProjectSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListProjectsOutput$ProjectSummaryList' => '<p>A list of summaries of projects.</p>', ], ], 'PropertyNameHint' => [ 'base' => NULL, 'refs' => [ 'PropertyNameQuery$PropertyNameHint' => '<p>Text that begins a property\'s name.</p>', ], ], 'PropertyNameQuery' => [ 'base' => '<p>Part of the <code>SuggestionQuery</code> type. Specifies a hint for retrieving property names that begin with the specified text.</p>', 'refs' => [ 'SuggestionQuery$PropertyNameQuery' => '<p>Defines a property name hint. Only property names that begin with the specified hint are included in the response.</p>', ], ], 'PropertyNameSuggestion' => [ 'base' => '<p>A property name returned from a <code>GetSearchSuggestions</code> call that specifies a value in the <code>PropertyNameQuery</code> field.</p>', 'refs' => [ 'PropertyNameSuggestionList$member' => NULL, ], ], 'PropertyNameSuggestionList' => [ 'base' => NULL, 'refs' => [ 'GetSearchSuggestionsResponse$PropertyNameSuggestions' => '<p>A list of property names for a <code>Resource</code> that match a <code>SuggestionQuery</code>.</p>', ], ], 'ProvisionedProductStatusMessage' => [ 'base' => NULL, 'refs' => [ 'ServiceCatalogProvisionedProductDetails$ProvisionedProductStatusMessage' => '<p>The current status of the product.</p> <ul> <li> <p> <code>AVAILABLE</code> - Stable state, ready to perform any operation. The most recent operation succeeded and completed.</p> </li> <li> <p> <code>UNDER_CHANGE</code> - Transitive state. Operations performed might not have valid results. Wait for an AVAILABLE status before performing operations.</p> </li> <li> <p> <code>TAINTED</code> - Stable state, ready to perform any operation. The stack has completed the requested operation but is not exactly what was requested. For example, a request to update to a new version failed and the stack rolled back to the current version.</p> </li> <li> <p> <code>ERROR</code> - An unexpected error occurred. The provisioned product exists but the stack is not running. For example, CloudFormation received a parameter value that was not valid and could not launch the stack.</p> </li> <li> <p> <code>PLAN_IN_PROGRESS</code> - Transitive state. The plan operations were performed to provision a new product, but resources have not yet been created. After reviewing the list of resources to be created, execute the plan. Wait for an AVAILABLE status before performing operations.</p> </li> </ul>', ], ], 'ProvisioningParameter' => [ 'base' => '<p>A key value pair used when you provision a project as a service catalog product. For information, see <a href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html">What is Amazon Web Services Service Catalog</a>.</p>', 'refs' => [ 'ProvisioningParameters$member' => NULL, ], ], 'ProvisioningParameterKey' => [ 'base' => NULL, 'refs' => [ 'ProvisioningParameter$Key' => '<p>The key that identifies a provisioning parameter.</p>', ], ], 'ProvisioningParameterValue' => [ 'base' => NULL, 'refs' => [ 'ProvisioningParameter$Value' => '<p>The value of the provisioning parameter.</p>', ], ], 'ProvisioningParameters' => [ 'base' => NULL, 'refs' => [ 'ServiceCatalogProvisioningDetails$ProvisioningParameters' => '<p>A list of key value pairs that you specify when you provision a product.</p>', 'ServiceCatalogProvisioningUpdateDetails$ProvisioningParameters' => '<p>A list of key value pairs that you specify when you provision a product.</p>', ], ], 'PublicWorkforceTaskPrice' => [ 'base' => '<p>Defines the amount of money paid to an Amazon Mechanical Turk worker for each task performed. </p> <p>Use one of the following prices for bounding box tasks. Prices are in US dollars and should be based on the complexity of the task; the longer it takes in your initial testing, the more you should offer.</p> <ul> <li> <p>0.036</p> </li> <li> <p>0.048</p> </li> <li> <p>0.060</p> </li> <li> <p>0.072</p> </li> <li> <p>0.120</p> </li> <li> <p>0.240</p> </li> <li> <p>0.360</p> </li> <li> <p>0.480</p> </li> <li> <p>0.600</p> </li> <li> <p>0.720</p> </li> <li> <p>0.840</p> </li> <li> <p>0.960</p> </li> <li> <p>1.080</p> </li> <li> <p>1.200</p> </li> </ul> <p>Use one of the following prices for image classification, text classification, and custom tasks. Prices are in US dollars.</p> <ul> <li> <p>0.012</p> </li> <li> <p>0.024</p> </li> <li> <p>0.036</p> </li> <li> <p>0.048</p> </li> <li> <p>0.060</p> </li> <li> <p>0.072</p> </li> <li> <p>0.120</p> </li> <li> <p>0.240</p> </li> <li> <p>0.360</p> </li> <li> <p>0.480</p> </li> <li> <p>0.600</p> </li> <li> <p>0.720</p> </li> <li> <p>0.840</p> </li> <li> <p>0.960</p> </li> <li> <p>1.080</p> </li> <li> <p>1.200</p> </li> </ul> <p>Use one of the following prices for semantic segmentation tasks. Prices are in US dollars.</p> <ul> <li> <p>0.840</p> </li> <li> <p>0.960</p> </li> <li> <p>1.080</p> </li> <li> <p>1.200</p> </li> </ul> <p>Use one of the following prices for Textract AnalyzeDocument Important Form Key Amazon Augmented AI review tasks. Prices are in US dollars.</p> <ul> <li> <p>2.400 </p> </li> <li> <p>2.280 </p> </li> <li> <p>2.160 </p> </li> <li> <p>2.040 </p> </li> <li> <p>1.920 </p> </li> <li> <p>1.800 </p> </li> <li> <p>1.680 </p> </li> <li> <p>1.560 </p> </li> <li> <p>1.440 </p> </li> <li> <p>1.320 </p> </li> <li> <p>1.200 </p> </li> <li> <p>1.080 </p> </li> <li> <p>0.960 </p> </li> <li> <p>0.840 </p> </li> <li> <p>0.720 </p> </li> <li> <p>0.600 </p> </li> <li> <p>0.480 </p> </li> <li> <p>0.360 </p> </li> <li> <p>0.240 </p> </li> <li> <p>0.120 </p> </li> <li> <p>0.072 </p> </li> <li> <p>0.060 </p> </li> <li> <p>0.048 </p> </li> <li> <p>0.036 </p> </li> <li> <p>0.024 </p> </li> <li> <p>0.012 </p> </li> </ul> <p>Use one of the following prices for Rekognition DetectModerationLabels Amazon Augmented AI review tasks. Prices are in US dollars.</p> <ul> <li> <p>1.200 </p> </li> <li> <p>1.080 </p> </li> <li> <p>0.960 </p> </li> <li> <p>0.840 </p> </li> <li> <p>0.720 </p> </li> <li> <p>0.600 </p> </li> <li> <p>0.480 </p> </li> <li> <p>0.360 </p> </li> <li> <p>0.240 </p> </li> <li> <p>0.120 </p> </li> <li> <p>0.072 </p> </li> <li> <p>0.060 </p> </li> <li> <p>0.048 </p> </li> <li> <p>0.036 </p> </li> <li> <p>0.024 </p> </li> <li> <p>0.012 </p> </li> </ul> <p>Use one of the following prices for Amazon Augmented AI custom human review tasks. Prices are in US dollars.</p> <ul> <li> <p>1.200 </p> </li> <li> <p>1.080 </p> </li> <li> <p>0.960 </p> </li> <li> <p>0.840 </p> </li> <li> <p>0.720 </p> </li> <li> <p>0.600 </p> </li> <li> <p>0.480 </p> </li> <li> <p>0.360 </p> </li> <li> <p>0.240 </p> </li> <li> <p>0.120 </p> </li> <li> <p>0.072 </p> </li> <li> <p>0.060 </p> </li> <li> <p>0.048 </p> </li> <li> <p>0.036 </p> </li> <li> <p>0.024 </p> </li> <li> <p>0.012 </p> </li> </ul>', 'refs' => [ 'HumanLoopConfig$PublicWorkforceTaskPrice' => NULL, 'HumanTaskConfig$PublicWorkforceTaskPrice' => '<p>The price that you pay for each task performed by an Amazon Mechanical Turk worker.</p>', ], ], 'PutModelPackageGroupPolicyInput' => [ 'base' => NULL, 'refs' => [], ], 'PutModelPackageGroupPolicyOutput' => [ 'base' => NULL, 'refs' => [], ], 'QProfileArn' => [ 'base' => NULL, 'refs' => [ 'AmazonQSettings$QProfileArn' => '<p>The ARN of the Amazon Q profile used within the domain.</p>', ], ], 'QualityCheckStepMetadata' => [ 'base' => '<p>Container for the metadata for a Quality check step. For more information, see the topic on <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/build-and-manage-steps.html#step-type-quality-check">QualityCheck step</a> in the <i>Amazon SageMaker Developer Guide</i>. </p>', 'refs' => [ 'PipelineExecutionStepMetadata$QualityCheck' => '<p>The configurations and outcomes of the check step execution. This includes: </p> <ul> <li> <p>The type of the check conducted.</p> </li> <li> <p>The Amazon S3 URIs of baseline constraints and statistics files to be used for the drift check.</p> </li> <li> <p>The Amazon S3 URIs of newly calculated baseline constraints and statistics.</p> </li> <li> <p>The model package group name provided.</p> </li> <li> <p>The Amazon S3 URI of the violation report if violations detected.</p> </li> <li> <p>The Amazon Resource Name (ARN) of check processing job initiated by the step execution.</p> </li> <li> <p>The Boolean flags indicating if the drift check is skipped.</p> </li> <li> <p>If step property <code>BaselineUsedForDriftCheck</code> is set the same as <code>CalculatedBaseline</code>.</p> </li> </ul>', ], ], 'QueryFilters' => [ 'base' => '<p>A set of filters to narrow the set of lineage entities connected to the <code>StartArn</code>(s) returned by the <code>QueryLineage</code> API action.</p>', 'refs' => [ 'QueryLineageRequest$Filters' => '<p>A set of filtering parameters that allow you to specify which entities should be returned.</p> <ul> <li> <p>Properties - Key-value pairs to match on the lineage entities\' properties.</p> </li> <li> <p>LineageTypes - A set of lineage entity types to match on. For example: <code>TrialComponent</code>, <code>Artifact</code>, or <code>Context</code>.</p> </li> <li> <p>CreatedBefore - Filter entities created before this date.</p> </li> <li> <p>ModifiedBefore - Filter entities modified before this date.</p> </li> <li> <p>ModifiedAfter - Filter entities modified after this date.</p> </li> </ul>', ], ], 'QueryLineageMaxDepth' => [ 'base' => NULL, 'refs' => [ 'QueryLineageRequest$MaxDepth' => '<p>The maximum depth in lineage relationships from the <code>StartArns</code> that are traversed. Depth is a measure of the number of <code>Associations</code> from the <code>StartArn</code> entity to the matched results.</p>', ], ], 'QueryLineageMaxResults' => [ 'base' => NULL, 'refs' => [ 'QueryLineageRequest$MaxResults' => '<p>Limits the number of vertices in the results. Use the <code>NextToken</code> in a response to to retrieve the next page of results.</p>', ], ], 'QueryLineageRequest' => [ 'base' => NULL, 'refs' => [], ], 'QueryLineageResponse' => [ 'base' => NULL, 'refs' => [], ], 'QueryLineageStartArns' => [ 'base' => NULL, 'refs' => [ 'QueryLineageRequest$StartArns' => '<p>A list of resource Amazon Resource Name (ARN) that represent the starting point for your lineage query.</p>', ], ], 'QueryLineageTypes' => [ 'base' => NULL, 'refs' => [ 'QueryFilters$LineageTypes' => '<p>Filter the lineage entities connected to the <code>StartArn</code>(s) by the type of the lineage entity.</p>', ], ], 'QueryProperties' => [ 'base' => NULL, 'refs' => [ 'QueryFilters$Properties' => '<p>Filter the lineage entities connected to the <code>StartArn</code>(s) by a set if property key value pairs. If multiple pairs are provided, an entity is included in the results if it matches any of the provided pairs.</p>', ], ], 'QueryTypes' => [ 'base' => NULL, 'refs' => [ 'QueryFilters$Types' => '<p>Filter the lineage entities connected to the <code>StartArn</code> by type. For example: <code>DataSet</code>, <code>Model</code>, <code>Endpoint</code>, or <code>ModelDeployment</code>.</p>', ], ], 'RSessionAppSettings' => [ 'base' => '<p>A collection of settings that apply to an <code>RSessionGateway</code> app.</p>', 'refs' => [ 'UserSettings$RSessionAppSettings' => '<p>A collection of settings that configure the <code>RSessionGateway</code> app.</p>', ], ], 'RStudioServerProAccessStatus' => [ 'base' => NULL, 'refs' => [ 'RStudioServerProAppSettings$AccessStatus' => '<p>Indicates whether the current user has access to the <code>RStudioServerPro</code> app.</p>', ], ], 'RStudioServerProAppSettings' => [ 'base' => '<p>A collection of settings that configure user interaction with the <code>RStudioServerPro</code> app.</p>', 'refs' => [ 'UserSettings$RStudioServerProAppSettings' => '<p>A collection of settings that configure user interaction with the <code>RStudioServerPro</code> app.</p>', ], ], 'RStudioServerProDomainSettings' => [ 'base' => '<p>A collection of settings that configure the <code>RStudioServerPro</code> Domain-level app.</p>', 'refs' => [ 'DomainSettings$RStudioServerProDomainSettings' => '<p>A collection of settings that configure the <code>RStudioServerPro</code> Domain-level app.</p>', ], ], 'RStudioServerProDomainSettingsForUpdate' => [ 'base' => '<p>A collection of settings that update the current configuration for the <code>RStudioServerPro</code> Domain-level app.</p>', 'refs' => [ 'DomainSettingsForUpdate$RStudioServerProDomainSettingsForUpdate' => '<p>A collection of <code>RStudioServerPro</code> Domain-level app settings to update. A single <code>RStudioServerPro</code> application is created for a domain.</p>', ], ], 'RStudioServerProUserGroup' => [ 'base' => NULL, 'refs' => [ 'RStudioServerProAppSettings$UserGroup' => '<p>The level of permissions that the user has within the <code>RStudioServerPro</code> app. This value defaults to `User`. The `Admin` value allows the user access to the RStudio Administrative Dashboard.</p>', ], ], 'RandomSeed' => [ 'base' => NULL, 'refs' => [ 'HyperParameterTuningJobConfig$RandomSeed' => '<p>A value used to initialize a pseudo-random number generator. Setting a random seed and using the same seed later for the same tuning job will allow hyperparameter optimization to find more a consistent hyperparameter configuration between the two runs.</p>', ], ], 'RealTimeInferenceConfig' => [ 'base' => '<p>The infrastructure configuration for deploying the model to a real-time inference endpoint.</p>', 'refs' => [ 'ModelInfrastructureConfig$RealTimeInferenceConfig' => '<p>The infrastructure configuration for deploying the model to real-time inference.</p>', ], ], 'RealTimeInferenceRecommendation' => [ 'base' => '<p>The recommended configuration to use for Real-Time Inference.</p>', 'refs' => [ 'RealTimeInferenceRecommendations$member' => NULL, ], ], 'RealTimeInferenceRecommendations' => [ 'base' => NULL, 'refs' => [ 'DeploymentRecommendation$RealTimeInferenceRecommendations' => '<p>A list of <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_RealTimeInferenceRecommendation.html">RealTimeInferenceRecommendation</a> items.</p>', ], ], 'RealtimeInferenceInstanceTypes' => [ 'base' => NULL, 'refs' => [ 'AdditionalInferenceSpecificationDefinition$SupportedRealtimeInferenceInstanceTypes' => '<p>A list of the instance types that are used to generate inferences in real-time.</p>', 'InferenceSpecification$SupportedRealtimeInferenceInstanceTypes' => '<p>A list of the instance types that are used to generate inferences in real-time.</p> <p>This parameter is required for unversioned models, and optional for versioned models.</p>', ], ], 'RecommendationFailureReason' => [ 'base' => NULL, 'refs' => [ 'RecommendationJobInferenceBenchmark$FailureReason' => '<p>The reason why a benchmark failed.</p>', ], ], 'RecommendationJobArn' => [ 'base' => NULL, 'refs' => [ 'CreateInferenceRecommendationsJobResponse$JobArn' => '<p>The Amazon Resource Name (ARN) of the recommendation job.</p>', 'DescribeInferenceRecommendationsJobResponse$JobArn' => '<p>The Amazon Resource Name (ARN) of the job.</p>', 'InferenceRecommendationsJob$JobArn' => '<p>The Amazon Resource Name (ARN) of the recommendation job.</p>', ], ], 'RecommendationJobCompilationJobName' => [ 'base' => NULL, 'refs' => [ 'ModelConfiguration$CompilationJobName' => '<p>The name of the compilation job used to create the recommended model artifacts.</p>', ], ], 'RecommendationJobCompiledOutputConfig' => [ 'base' => '<p>Provides information about the output configuration for the compiled model.</p>', 'refs' => [ 'RecommendationJobOutputConfig$CompiledOutputConfig' => '<p>Provides information about the output configuration for the compiled model.</p>', ], ], 'RecommendationJobContainerConfig' => [ 'base' => '<p>Specifies mandatory fields for running an Inference Recommender job directly in the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateInferenceRecommendationsJob.html">CreateInferenceRecommendationsJob</a> API. The fields specified in <code>ContainerConfig</code> override the corresponding fields in the model package. Use <code>ContainerConfig</code> if you want to specify these fields for the recommendation job but don\'t want to edit them in your model package.</p>', 'refs' => [ 'RecommendationJobInputConfig$ContainerConfig' => '<p>Specifies mandatory fields for running an Inference Recommender job. The fields specified in <code>ContainerConfig</code> override the corresponding fields in the model package.</p>', ], ], 'RecommendationJobDataInputConfig' => [ 'base' => NULL, 'refs' => [ 'RecommendationJobContainerConfig$DataInputConfig' => '<p>Specifies the name and shape of the expected data inputs for your trained model with a JSON dictionary form. This field is used for optimizing your model using SageMaker Neo. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_InputConfig.html#sagemaker-Type-InputConfig-DataInputConfig">DataInputConfig</a>.</p>', ], ], 'RecommendationJobDescription' => [ 'base' => NULL, 'refs' => [ 'CreateInferenceRecommendationsJobRequest$JobDescription' => '<p>Description of the recommendation job.</p>', 'DescribeInferenceRecommendationsJobResponse$JobDescription' => '<p>The job description that you provided when you initiated the job.</p>', 'InferenceRecommendationsJob$JobDescription' => '<p>The job description.</p>', ], ], 'RecommendationJobFrameworkVersion' => [ 'base' => NULL, 'refs' => [ 'RecommendationJobContainerConfig$FrameworkVersion' => '<p>The framework version of the container image.</p>', ], ], 'RecommendationJobInferenceBenchmark' => [ 'base' => '<p>The details for a specific benchmark from an Inference Recommender job.</p>', 'refs' => [ 'InferenceRecommendationsJobStep$InferenceBenchmark' => '<p>The details for a specific benchmark.</p>', ], ], 'RecommendationJobInputConfig' => [ 'base' => '<p>The input configuration of the recommendation job.</p>', 'refs' => [ 'CreateInferenceRecommendationsJobRequest$InputConfig' => '<p>Provides information about the versioned model package Amazon Resource Name (ARN), the traffic pattern, and endpoint configurations.</p>', 'DescribeInferenceRecommendationsJobResponse$InputConfig' => '<p>Returns information about the versioned model package Amazon Resource Name (ARN), the traffic pattern, and endpoint configurations you provided when you initiated the job.</p>', ], ], 'RecommendationJobName' => [ 'base' => NULL, 'refs' => [ 'CreateInferenceRecommendationsJobRequest$JobName' => '<p>A name for the recommendation job. The name must be unique within the Amazon Web Services Region and within your Amazon Web Services account. The job name is passed down to the resources created by the recommendation job. The names of resources (such as the model, endpoint configuration, endpoint, and compilation) that are prefixed with the job name are truncated at 40 characters.</p>', 'DescribeInferenceRecommendationsJobRequest$JobName' => '<p>The name of the job. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>', 'DescribeInferenceRecommendationsJobResponse$JobName' => '<p>The name of the job. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>', 'GetScalingConfigurationRecommendationRequest$InferenceRecommendationsJobName' => '<p>The name of a previously completed Inference Recommender job.</p>', 'GetScalingConfigurationRecommendationResponse$InferenceRecommendationsJobName' => '<p>The name of a previously completed Inference Recommender job.</p>', 'InferenceRecommendationsJob$JobName' => '<p>The name of the job.</p>', 'InferenceRecommendationsJobStep$JobName' => '<p>The name of the Inference Recommender job.</p>', 'ListInferenceRecommendationsJobStepsRequest$JobName' => '<p>The name for the Inference Recommender job.</p>', 'StopInferenceRecommendationsJobRequest$JobName' => '<p>The name of the job you want to stop.</p>', ], ], 'RecommendationJobOutputConfig' => [ 'base' => '<p>Provides information about the output configuration for the compiled model.</p>', 'refs' => [ 'CreateInferenceRecommendationsJobRequest$OutputConfig' => '<p>Provides information about the output artifacts and the KMS key to use for Amazon S3 server-side encryption.</p>', ], ], 'RecommendationJobPayloadConfig' => [ 'base' => '<p>The configuration for the payload for a recommendation job.</p>', 'refs' => [ 'RecommendationJobContainerConfig$PayloadConfig' => '<p>Specifies the <code>SamplePayloadUrl</code> and all other sample payload-related fields.</p>', ], ], 'RecommendationJobResourceLimit' => [ 'base' => '<p>Specifies the maximum number of jobs that can run in parallel and the maximum number of jobs that can run.</p>', 'refs' => [ 'RecommendationJobInputConfig$ResourceLimit' => '<p>Defines the resource limit of the job.</p>', ], ], 'RecommendationJobStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeInferenceRecommendationsJobResponse$Status' => '<p>The status of the job.</p>', 'InferenceRecommendationsJob$Status' => '<p>The status of the job.</p>', 'InferenceRecommendationsJobStep$Status' => '<p>The current status of the benchmark.</p>', 'ListInferenceRecommendationsJobStepsRequest$Status' => '<p>A filter to return benchmarks of a specified status. If this field is left empty, then all benchmarks are returned.</p>', 'ListInferenceRecommendationsJobsRequest$StatusEquals' => '<p>A filter that retrieves only inference recommendations jobs with a specific status.</p>', ], ], 'RecommendationJobStoppingConditions' => [ 'base' => '<p>Specifies conditions for stopping a job. When a job reaches a stopping condition limit, SageMaker ends the job.</p>', 'refs' => [ 'CreateInferenceRecommendationsJobRequest$StoppingConditions' => '<p>A set of conditions for stopping a recommendation job. If any of the conditions are met, the job is automatically stopped.</p>', 'DescribeInferenceRecommendationsJobResponse$StoppingConditions' => '<p>The stopping conditions that you provided when you initiated the job.</p>', ], ], 'RecommendationJobSupportedContentType' => [ 'base' => NULL, 'refs' => [ 'RecommendationJobSupportedContentTypes$member' => NULL, ], ], 'RecommendationJobSupportedContentTypes' => [ 'base' => NULL, 'refs' => [ 'RecommendationJobPayloadConfig$SupportedContentTypes' => '<p>The supported MIME types for the input data.</p>', ], ], 'RecommendationJobSupportedEndpointType' => [ 'base' => NULL, 'refs' => [ 'RecommendationJobContainerConfig$SupportedEndpointType' => '<p>The endpoint type to receive recommendations for. By default this is null, and the results of the inference recommendation job return a combined list of both real-time and serverless benchmarks. By specifying a value for this field, you can receive a longer list of benchmarks for the desired endpoint type.</p>', ], ], 'RecommendationJobSupportedInstanceTypes' => [ 'base' => NULL, 'refs' => [ 'RecommendationJobContainerConfig$SupportedInstanceTypes' => '<p>A list of the instance types that are used to generate inferences in real-time.</p>', ], ], 'RecommendationJobSupportedResponseMIMEType' => [ 'base' => NULL, 'refs' => [ 'RecommendationJobSupportedResponseMIMETypes$member' => NULL, ], ], 'RecommendationJobSupportedResponseMIMETypes' => [ 'base' => NULL, 'refs' => [ 'RecommendationJobContainerConfig$SupportedResponseMIMETypes' => '<p>The supported MIME types for the output data.</p>', ], ], 'RecommendationJobType' => [ 'base' => NULL, 'refs' => [ 'CreateInferenceRecommendationsJobRequest$JobType' => '<p>Defines the type of recommendation job. Specify <code>Default</code> to initiate an instance recommendation and <code>Advanced</code> to initiate a load test. If left unspecified, Amazon SageMaker Inference Recommender will run an instance recommendation (<code>DEFAULT</code>) job.</p>', 'DescribeInferenceRecommendationsJobResponse$JobType' => '<p>The job type that you provided when you initiated the job.</p>', 'InferenceRecommendationsJob$JobType' => '<p>The recommendation job type.</p>', ], ], 'RecommendationJobVpcConfig' => [ 'base' => '<p>Inference Recommender provisions SageMaker endpoints with access to VPC in the inference recommendation job.</p>', 'refs' => [ 'RecommendationJobInputConfig$VpcConfig' => '<p>Inference Recommender provisions SageMaker endpoints with access to VPC in the inference recommendation job.</p>', ], ], 'RecommendationJobVpcSecurityGroupId' => [ 'base' => NULL, 'refs' => [ 'RecommendationJobVpcSecurityGroupIds$member' => NULL, ], ], 'RecommendationJobVpcSecurityGroupIds' => [ 'base' => NULL, 'refs' => [ 'RecommendationJobVpcConfig$SecurityGroupIds' => '<p>The VPC security group IDs. IDs have the form of <code>sg-xxxxxxxx</code>. Specify the security groups for the VPC that is specified in the <code>Subnets</code> field.</p>', ], ], 'RecommendationJobVpcSubnetId' => [ 'base' => NULL, 'refs' => [ 'RecommendationJobVpcSubnets$member' => NULL, ], ], 'RecommendationJobVpcSubnets' => [ 'base' => NULL, 'refs' => [ 'RecommendationJobVpcConfig$Subnets' => '<p>The ID of the subnets in the VPC to which you want to connect your model.</p>', ], ], 'RecommendationMetrics' => [ 'base' => '<p>The metrics of recommendations.</p>', 'refs' => [ 'InferenceRecommendation$Metrics' => '<p>The metrics used to decide what recommendation to make.</p>', 'RecommendationJobInferenceBenchmark$Metrics' => NULL, ], ], 'RecommendationStatus' => [ 'base' => NULL, 'refs' => [ 'DeploymentRecommendation$RecommendationStatus' => '<p>Status of the deployment recommendation. The status <code>NOT_APPLICABLE</code> means that SageMaker is unable to provide a default recommendation for the model using the information provided. If the deployment status is <code>IN_PROGRESS</code>, retry your API call after a few seconds to get a <code>COMPLETED</code> deployment recommendation.</p>', ], ], 'RecommendationStepType' => [ 'base' => NULL, 'refs' => [ 'InferenceRecommendationsJobStep$StepType' => '<p>The type of the subtask.</p> <p> <code>BENCHMARK</code>: Evaluate the performance of your model on different instance types.</p>', 'ListInferenceRecommendationsJobStepsRequest$StepType' => '<p>A filter to return details about the specified type of subtask.</p> <p> <code>BENCHMARK</code>: Evaluate the performance of your model on different instance types.</p>', ], ], 'RecordWrapper' => [ 'base' => NULL, 'refs' => [ 'Channel$RecordWrapperType' => '<p/> <p>Specify RecordIO as the value when input data is in raw format but the training algorithm requires the RecordIO format. In this case, SageMaker wraps each individual S3 object in a RecordIO record. If the input data is already in RecordIO format, you don\'t need to set this attribute. For more information, see <a href="https://mxnet.apache.org/api/architecture/note_data_loading#data-format">Create a Dataset Using RecordIO</a>. </p> <p>In File mode, leave this field unset or set it to None.</p>', ], ], 'RedshiftClusterId' => [ 'base' => '<p>The Redshift cluster Identifier.</p>', 'refs' => [ 'RedshiftDatasetDefinition$ClusterId' => NULL, ], ], 'RedshiftDatabase' => [ 'base' => '<p>The name of the Redshift database used in Redshift query execution.</p>', 'refs' => [ 'RedshiftDatasetDefinition$Database' => NULL, ], ], 'RedshiftDatasetDefinition' => [ 'base' => '<p>Configuration for Redshift Dataset Definition input.</p>', 'refs' => [ 'DatasetDefinition$RedshiftDatasetDefinition' => NULL, ], ], 'RedshiftQueryString' => [ 'base' => '<p>The SQL query statements to be executed.</p>', 'refs' => [ 'RedshiftDatasetDefinition$QueryString' => NULL, ], ], 'RedshiftResultCompressionType' => [ 'base' => '<p>The compression used for Redshift query results.</p>', 'refs' => [ 'RedshiftDatasetDefinition$OutputCompression' => NULL, ], ], 'RedshiftResultFormat' => [ 'base' => '<p>The data storage format for Redshift query results.</p>', 'refs' => [ 'RedshiftDatasetDefinition$OutputFormat' => NULL, ], ], 'RedshiftUserName' => [ 'base' => '<p>The database user name used in Redshift query execution.</p>', 'refs' => [ 'RedshiftDatasetDefinition$DbUser' => NULL, ], ], 'ReferenceMinVersion' => [ 'base' => NULL, 'refs' => [ 'DescribeHubContentResponse$ReferenceMinVersion' => '<p>The minimum version of the hub content.</p>', ], ], 'RegisterDevicesRequest' => [ 'base' => NULL, 'refs' => [], ], 'RegisterModelStepMetadata' => [ 'base' => '<p>Metadata for a register model job step.</p>', 'refs' => [ 'PipelineExecutionStepMetadata$RegisterModel' => '<p>The Amazon Resource Name (ARN) of the model package that the model was registered to by this step execution.</p>', ], ], 'ReleaseNotes' => [ 'base' => NULL, 'refs' => [ 'CreateImageVersionRequest$ReleaseNotes' => '<p>The maintainer description of the image version.</p>', 'DescribeImageVersionResponse$ReleaseNotes' => '<p>The maintainer description of the image version.</p>', 'UpdateImageVersionRequest$ReleaseNotes' => '<p>The maintainer description of the image version.</p>', ], ], 'RemoteDebugConfig' => [ 'base' => '<p>Configuration for remote debugging for the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTrainingJob.html">CreateTrainingJob</a> API. To learn more about the remote debugging functionality of SageMaker, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-remote-debugging.html">Access a training container through Amazon Web Services Systems Manager (SSM) for remote debugging</a>.</p>', 'refs' => [ 'CreateTrainingJobRequest$RemoteDebugConfig' => '<p>Configuration for remote debugging. To learn more about the remote debugging functionality of SageMaker, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-remote-debugging.html">Access a training container through Amazon Web Services Systems Manager (SSM) for remote debugging</a>.</p>', 'DescribeTrainingJobResponse$RemoteDebugConfig' => '<p>Configuration for remote debugging. To learn more about the remote debugging functionality of SageMaker, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-remote-debugging.html">Access a training container through Amazon Web Services Systems Manager (SSM) for remote debugging</a>.</p>', ], ], 'RemoteDebugConfigForUpdate' => [ 'base' => '<p>Configuration for remote debugging for the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateTrainingJob.html">UpdateTrainingJob</a> API. To learn more about the remote debugging functionality of SageMaker, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-remote-debugging.html">Access a training container through Amazon Web Services Systems Manager (SSM) for remote debugging</a>.</p>', 'refs' => [ 'UpdateTrainingJobRequest$RemoteDebugConfig' => '<p>Configuration for remote debugging while the training job is running. You can update the remote debugging configuration when the <code>SecondaryStatus</code> of the job is <code>Downloading</code> or <code>Training</code>.To learn more about the remote debugging functionality of SageMaker, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-remote-debugging.html">Access a training container through Amazon Web Services Systems Manager (SSM) for remote debugging</a>.</p>', ], ], 'RenderUiTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'RenderUiTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'RenderableTask' => [ 'base' => '<p>Contains input values for a task.</p>', 'refs' => [ 'RenderUiTemplateRequest$Task' => '<p>A <code>RenderableTask</code> object containing a representative task to render.</p>', ], ], 'RenderingError' => [ 'base' => '<p>A description of an error that occurred while rendering the template.</p>', 'refs' => [ 'RenderingErrorList$member' => NULL, ], ], 'RenderingErrorList' => [ 'base' => NULL, 'refs' => [ 'RenderUiTemplateResponse$Errors' => '<p>A list of one or more <code>RenderingError</code> objects if any were encountered while rendering the template. If there were no errors, the list is empty.</p>', ], ], 'RepositoryAccessMode' => [ 'base' => NULL, 'refs' => [ 'ImageConfig$RepositoryAccessMode' => '<p>Set this to one of the following values:</p> <ul> <li> <p> <code>Platform</code> - The model image is hosted in Amazon ECR.</p> </li> <li> <p> <code>Vpc</code> - The model image is hosted in a private Docker registry in your VPC.</p> </li> </ul>', ], ], 'RepositoryAuthConfig' => [ 'base' => '<p>Specifies an authentication configuration for the private docker registry where your model image is hosted. Specify a value for this property only if you specified <code>Vpc</code> as the value for the <code>RepositoryAccessMode</code> field of the <code>ImageConfig</code> object that you passed to a call to <code>CreateModel</code> and the private Docker registry where the model image is hosted requires authentication.</p>', 'refs' => [ 'ImageConfig$RepositoryAuthConfig' => '<p>(Optional) Specifies an authentication configuration for the private docker registry where your model image is hosted. Specify a value for this property only if you specified <code>Vpc</code> as the value for the <code>RepositoryAccessMode</code> field, and the private Docker registry where the model image is hosted requires authentication.</p>', ], ], 'RepositoryCredentialsProviderArn' => [ 'base' => NULL, 'refs' => [ 'RepositoryAuthConfig$RepositoryCredentialsProviderArn' => '<p>The Amazon Resource Name (ARN) of an Amazon Web Services Lambda function that provides credentials to authenticate to the private Docker registry where your model image is hosted. For information about how to create an Amazon Web Services Lambda function, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/getting-started-create-function.html">Create a Lambda function with the console</a> in the <i>Amazon Web Services Lambda Developer Guide</i>.</p>', ], ], 'RepositoryUrl' => [ 'base' => NULL, 'refs' => [ 'CodeRepository$RepositoryUrl' => '<p>The URL of the Git repository.</p>', ], ], 'ResolvedAttributes' => [ 'base' => '<p>The resolved attributes.</p>', 'refs' => [ 'DescribeAutoMLJobResponse$ResolvedAttributes' => '<p>Contains <code>ProblemType</code>, <code>AutoMLJobObjective</code>, and <code>CompletionCriteria</code>. If you do not provide these values, they are inferred.</p>', ], ], 'ResourceArn' => [ 'base' => NULL, 'refs' => [ 'AddTagsInput$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource that you want to tag.</p>', 'DeleteTagsInput$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource whose tags you want to delete.</p>', 'ListTagsInput$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource whose tags you want to retrieve.</p>', ], ], 'ResourceCatalog' => [ 'base' => '<p> A resource catalog containing all of the resources of a specific resource type within a resource owner account. For an example on sharing the Amazon SageMaker Feature Store <code>DefaultFeatureGroupCatalog</code>, see <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/feature-store-cross-account-discoverability-share-sagemaker-catalog.html">Share Amazon SageMaker Catalog resource type</a> in the Amazon SageMaker Developer Guide. </p>', 'refs' => [ 'ResourceCatalogList$member' => NULL, ], ], 'ResourceCatalogArn' => [ 'base' => NULL, 'refs' => [ 'ResourceCatalog$ResourceCatalogArn' => '<p> The Amazon Resource Name (ARN) of the <code>ResourceCatalog</code>. </p>', ], ], 'ResourceCatalogDescription' => [ 'base' => NULL, 'refs' => [ 'ResourceCatalog$Description' => '<p> A free form description of the <code>ResourceCatalog</code>. </p>', ], ], 'ResourceCatalogList' => [ 'base' => NULL, 'refs' => [ 'ListResourceCatalogsResponse$ResourceCatalogs' => '<p> A list of the requested <code>ResourceCatalog</code>s. </p>', ], ], 'ResourceCatalogName' => [ 'base' => NULL, 'refs' => [ 'ListResourceCatalogsRequest$NameContains' => '<p> A string that partially matches one or more <code>ResourceCatalog</code>s names. Filters <code>ResourceCatalog</code> by name. </p>', 'ResourceCatalog$ResourceCatalogName' => '<p> The name of the <code>ResourceCatalog</code>. </p>', ], ], 'ResourceCatalogSortBy' => [ 'base' => NULL, 'refs' => [ 'ListResourceCatalogsRequest$SortBy' => '<p> The value on which the resource catalog list is sorted. </p>', ], ], 'ResourceCatalogSortOrder' => [ 'base' => NULL, 'refs' => [ 'ListResourceCatalogsRequest$SortOrder' => '<p> The order in which the resource catalogs are listed. </p>', ], ], 'ResourceConfig' => [ 'base' => '<p>Describes the resources, including machine learning (ML) compute instances and ML storage volumes, to use for model training. </p>', 'refs' => [ 'CreateTrainingJobRequest$ResourceConfig' => '<p>The resources, including the ML compute instances and ML storage volumes, to use for model training. </p> <p>ML storage volumes store mod