<?php
// This file was auto-generated from sdk-root/src/data/sns/2010-03-31/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Amazon Simple Notification Service</fullname> <p>Amazon Simple Notification Service (Amazon SNS) is a web service that enables you to build distributed web-enabled applications. Applications can use Amazon SNS to easily push real-time notification messages to interested subscribers over multiple delivery protocols. For more information about this product see the <a href="http://aws.amazon.com/sns/">Amazon SNS product page</a>. For detailed information about Amazon SNS features and their associated API calls, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/">Amazon SNS Developer Guide</a>. </p> <p>For information on the permissions you need to use this API, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-authentication-and-access-control.html">Identity and access management in Amazon SNS</a> in the <i>Amazon SNS Developer Guide.</i> </p> <p>We also provide SDKs that enable you to access Amazon SNS from your preferred programming language. The SDKs contain functionality that automatically takes care of tasks such as: cryptographically signing your service requests, retrying requests, and handling error responses. For a list of available SDKs, go to <a href="http://aws.amazon.com/tools/">Tools for Amazon Web Services</a>. </p>', 'operations' => [ 'AddPermission' => '<p>Adds a statement to a topic\'s access control policy, granting access for the specified Amazon Web Services accounts to the specified actions.</p> <note> <p>To remove the ability to change topic permissions, you must deny permissions to the <code>AddPermission</code>, <code>RemovePermission</code>, and <code>SetTopicAttributes</code> actions in your IAM policy.</p> </note>', 'CheckIfPhoneNumberIsOptedOut' => '<p>Accepts a phone number and indicates whether the phone holder has opted out of receiving SMS messages from your Amazon Web Services account. You cannot send SMS messages to a number that is opted out.</p> <p>To resume sending messages, you can opt in the number by using the <code>OptInPhoneNumber</code> action.</p>', 'ConfirmSubscription' => '<p>Verifies an endpoint owner\'s intent to receive messages by validating the token sent to the endpoint by an earlier <code>Subscribe</code> action. If the token is valid, the action creates a new subscription and returns its Amazon Resource Name (ARN). This call requires an AWS signature only when the <code>AuthenticateOnUnsubscribe</code> flag is set to "true".</p>', 'CreatePlatformApplication' => '<p>Creates a platform application object for one of the supported push notification services, such as APNS and GCM (Firebase Cloud Messaging), to which devices and mobile apps may register. You must specify <code>PlatformPrincipal</code> and <code>PlatformCredential</code> attributes when using the <code>CreatePlatformApplication</code> action.</p> <p> <code>PlatformPrincipal</code> and <code>PlatformCredential</code> are received from the notification service.</p> <ul> <li> <p>For ADM, <code>PlatformPrincipal</code> is <code>client id</code> and <code>PlatformCredential</code> is <code>client secret</code>.</p> </li> <li> <p>For APNS and <code>APNS_SANDBOX</code> using certificate credentials, <code>PlatformPrincipal</code> is <code>SSL certificate</code> and <code>PlatformCredential</code> is <code>private key</code>.</p> </li> <li> <p>For APNS and <code>APNS_SANDBOX</code> using token credentials, <code>PlatformPrincipal</code> is <code>signing key ID</code> and <code>PlatformCredential</code> is <code>signing key</code>.</p> </li> <li> <p>For Baidu, <code>PlatformPrincipal</code> is <code>API key</code> and <code>PlatformCredential</code> is <code>secret key</code>.</p> </li> <li> <p>For GCM (Firebase Cloud Messaging) using key credentials, there is no <code>PlatformPrincipal</code>. The <code>PlatformCredential</code> is <code>API key</code>.</p> </li> <li> <p>For GCM (Firebase Cloud Messaging) using token credentials, there is no <code>PlatformPrincipal</code>. The <code>PlatformCredential</code> is a JSON formatted private key file. When using the Amazon Web Services CLI, the file must be in string format and special characters must be ignored. To format the file correctly, Amazon SNS recommends using the following command: <code>SERVICE_JSON=`jq @json &lt;&lt;&lt; cat service.json`</code>.</p> </li> <li> <p>For MPNS, <code>PlatformPrincipal</code> is <code>TLS certificate</code> and <code>PlatformCredential</code> is <code>private key</code>.</p> </li> <li> <p>For WNS, <code>PlatformPrincipal</code> is <code>Package Security Identifier</code> and <code>PlatformCredential</code> is <code>secret key</code>.</p> </li> </ul> <p>You can use the returned <code>PlatformApplicationArn</code> as an attribute for the <code>CreatePlatformEndpoint</code> action.</p>', 'CreatePlatformEndpoint' => '<p>Creates an endpoint for a device and mobile app on one of the supported push notification services, such as GCM (Firebase Cloud Messaging) and APNS. <code>CreatePlatformEndpoint</code> requires the <code>PlatformApplicationArn</code> that is returned from <code>CreatePlatformApplication</code>. You can use the returned <code>EndpointArn</code> to send a message to a mobile app or by the <code>Subscribe</code> action for subscription to a topic. The <code>CreatePlatformEndpoint</code> action is idempotent, so if the requester already owns an endpoint with the same device token and attributes, that endpoint\'s ARN is returned without creating a new endpoint. For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html">Using Amazon SNS Mobile Push Notifications</a>. </p> <p>When using <code>CreatePlatformEndpoint</code> with Baidu, two attributes must be provided: ChannelId and UserId. The token field must also contain the ChannelId. For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/SNSMobilePushBaiduEndpoint.html">Creating an Amazon SNS Endpoint for Baidu</a>. </p>', 'CreateSMSSandboxPhoneNumber' => '<p>Adds a destination phone number to an Amazon Web Services account in the SMS sandbox and sends a one-time password (OTP) to that phone number.</p> <p>When you start using Amazon SNS to send SMS messages, your Amazon Web Services account is in the <i>SMS sandbox</i>. The SMS sandbox provides a safe environment for you to try Amazon SNS features without risking your reputation as an SMS sender. While your Amazon Web Services account is in the SMS sandbox, you can use all of the features of Amazon SNS. However, you can send SMS messages only to verified destination phone numbers. For more information, including how to move out of the sandbox to send messages without restrictions, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">SMS sandbox</a> in the <i>Amazon SNS Developer Guide</i>.</p>', 'CreateTopic' => '<p>Creates a topic to which notifications can be published. Users can create at most 100,000 standard topics (at most 1,000 FIFO topics). For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-create-topic.html">Creating an Amazon SNS topic</a> in the <i>Amazon SNS Developer Guide</i>. This action is idempotent, so if the requester already owns a topic with the specified name, that topic\'s ARN is returned without creating a new topic.</p>', 'DeleteEndpoint' => '<p>Deletes the endpoint for a device and mobile app from Amazon SNS. This action is idempotent. For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html">Using Amazon SNS Mobile Push Notifications</a>. </p> <p>When you delete an endpoint that is also subscribed to a topic, then you must also unsubscribe the endpoint from the topic.</p>', 'DeletePlatformApplication' => '<p>Deletes a platform application object for one of the supported push notification services, such as APNS and GCM (Firebase Cloud Messaging). For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html">Using Amazon SNS Mobile Push Notifications</a>. </p>', 'DeleteSMSSandboxPhoneNumber' => '<p>Deletes an Amazon Web Services account\'s verified or pending phone number from the SMS sandbox.</p> <p>When you start using Amazon SNS to send SMS messages, your Amazon Web Services account is in the <i>SMS sandbox</i>. The SMS sandbox provides a safe environment for you to try Amazon SNS features without risking your reputation as an SMS sender. While your Amazon Web Services account is in the SMS sandbox, you can use all of the features of Amazon SNS. However, you can send SMS messages only to verified destination phone numbers. For more information, including how to move out of the sandbox to send messages without restrictions, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">SMS sandbox</a> in the <i>Amazon SNS Developer Guide</i>.</p>', 'DeleteTopic' => '<p>Deletes a topic and all its subscriptions. Deleting a topic might prevent some messages previously sent to the topic from being delivered to subscribers. This action is idempotent, so deleting a topic that does not exist does not result in an error.</p>', 'GetDataProtectionPolicy' => '<p>Retrieves the specified inline <code>DataProtectionPolicy</code> document that is stored in the specified Amazon SNS topic. </p>', 'GetEndpointAttributes' => '<p>Retrieves the endpoint attributes for a device on one of the supported push notification services, such as GCM (Firebase Cloud Messaging) and APNS. For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html">Using Amazon SNS Mobile Push Notifications</a>. </p>', 'GetPlatformApplicationAttributes' => '<p>Retrieves the attributes of the platform application object for the supported push notification services, such as APNS and GCM (Firebase Cloud Messaging). For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html">Using Amazon SNS Mobile Push Notifications</a>. </p>', 'GetSMSAttributes' => '<p>Returns the settings for sending SMS messages from your Amazon Web Services account.</p> <p>These settings are set with the <code>SetSMSAttributes</code> action.</p>', 'GetSMSSandboxAccountStatus' => '<p>Retrieves the SMS sandbox status for the calling Amazon Web Services account in the target Amazon Web Services Region.</p> <p>When you start using Amazon SNS to send SMS messages, your Amazon Web Services account is in the <i>SMS sandbox</i>. The SMS sandbox provides a safe environment for you to try Amazon SNS features without risking your reputation as an SMS sender. While your Amazon Web Services account is in the SMS sandbox, you can use all of the features of Amazon SNS. However, you can send SMS messages only to verified destination phone numbers. For more information, including how to move out of the sandbox to send messages without restrictions, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">SMS sandbox</a> in the <i>Amazon SNS Developer Guide</i>.</p>', 'GetSubscriptionAttributes' => '<p>Returns all of the properties of a subscription.</p>', 'GetTopicAttributes' => '<p>Returns all of the properties of a topic. Topic properties returned might differ based on the authorization of the user.</p>', 'ListEndpointsByPlatformApplication' => '<p>Lists the endpoints and endpoint attributes for devices in a supported push notification service, such as GCM (Firebase Cloud Messaging) and APNS. The results for <code>ListEndpointsByPlatformApplication</code> are paginated and return a limited list of endpoints, up to 100. If additional records are available after the first page results, then a NextToken string will be returned. To receive the next page, you call <code>ListEndpointsByPlatformApplication</code> again using the NextToken string received from the previous call. When there are no more records to return, NextToken will be null. For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html">Using Amazon SNS Mobile Push Notifications</a>. </p> <p>This action is throttled at 30 transactions per second (TPS).</p>', 'ListOriginationNumbers' => '<p>Lists the calling Amazon Web Services account\'s dedicated origination numbers and their metadata. For more information about origination numbers, see <a href="https://docs.aws.amazon.com/sns/latest/dg/channels-sms-originating-identities-origination-numbers.html">Origination numbers</a> in the <i>Amazon SNS Developer Guide</i>.</p>', 'ListPhoneNumbersOptedOut' => '<p>Returns a list of phone numbers that are opted out, meaning you cannot send SMS messages to them.</p> <p>The results for <code>ListPhoneNumbersOptedOut</code> are paginated, and each page returns up to 100 phone numbers. If additional phone numbers are available after the first page of results, then a <code>NextToken</code> string will be returned. To receive the next page, you call <code>ListPhoneNumbersOptedOut</code> again using the <code>NextToken</code> string received from the previous call. When there are no more records to return, <code>NextToken</code> will be null.</p>', 'ListPlatformApplications' => '<p>Lists the platform application objects for the supported push notification services, such as APNS and GCM (Firebase Cloud Messaging). The results for <code>ListPlatformApplications</code> are paginated and return a limited list of applications, up to 100. If additional records are available after the first page results, then a NextToken string will be returned. To receive the next page, you call <code>ListPlatformApplications</code> using the NextToken string received from the previous call. When there are no more records to return, <code>NextToken</code> will be null. For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html">Using Amazon SNS Mobile Push Notifications</a>. </p> <p>This action is throttled at 15 transactions per second (TPS).</p>', 'ListSMSSandboxPhoneNumbers' => '<p>Lists the calling Amazon Web Services account\'s current verified and pending destination phone numbers in the SMS sandbox.</p> <p>When you start using Amazon SNS to send SMS messages, your Amazon Web Services account is in the <i>SMS sandbox</i>. The SMS sandbox provides a safe environment for you to try Amazon SNS features without risking your reputation as an SMS sender. While your Amazon Web Services account is in the SMS sandbox, you can use all of the features of Amazon SNS. However, you can send SMS messages only to verified destination phone numbers. For more information, including how to move out of the sandbox to send messages without restrictions, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">SMS sandbox</a> in the <i>Amazon SNS Developer Guide</i>.</p>', 'ListSubscriptions' => '<p>Returns a list of the requester\'s subscriptions. Each call returns a limited list of subscriptions, up to 100. If there are more subscriptions, a <code>NextToken</code> is also returned. Use the <code>NextToken</code> parameter in a new <code>ListSubscriptions</code> call to get further results.</p> <p>This action is throttled at 30 transactions per second (TPS).</p>', 'ListSubscriptionsByTopic' => '<p>Returns a list of the subscriptions to a specific topic. Each call returns a limited list of subscriptions, up to 100. If there are more subscriptions, a <code>NextToken</code> is also returned. Use the <code>NextToken</code> parameter in a new <code>ListSubscriptionsByTopic</code> call to get further results.</p> <p>This action is throttled at 30 transactions per second (TPS).</p>', 'ListTagsForResource' => '<p>List all tags added to the specified Amazon SNS topic. For an overview, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-tags.html">Amazon SNS Tags</a> in the <i>Amazon Simple Notification Service Developer Guide</i>.</p>', 'ListTopics' => '<p>Returns a list of the requester\'s topics. Each call returns a limited list of topics, up to 100. If there are more topics, a <code>NextToken</code> is also returned. Use the <code>NextToken</code> parameter in a new <code>ListTopics</code> call to get further results.</p> <p>This action is throttled at 30 transactions per second (TPS).</p>', 'OptInPhoneNumber' => '<p>Use this request to opt in a phone number that is opted out, which enables you to resume sending SMS messages to the number.</p> <p>You can opt in a phone number only once every 30 days.</p>', 'Publish' => '<p>Sends a message to an Amazon SNS topic, a text message (SMS message) directly to a phone number, or a message to a mobile platform endpoint (when you specify the <code>TargetArn</code>).</p> <p>If you send a message to a topic, Amazon SNS delivers the message to each endpoint that is subscribed to the topic. The format of the message depends on the notification protocol for each subscribed endpoint.</p> <p>When a <code>messageId</code> is returned, the message is saved and Amazon SNS immediately delivers it to subscribers.</p> <p>To use the <code>Publish</code> action for publishing a message to a mobile endpoint, such as an app on a Kindle device or mobile phone, you must specify the EndpointArn for the TargetArn parameter. The EndpointArn is returned when making a call with the <code>CreatePlatformEndpoint</code> action. </p> <p>For more information about formatting messages, see <a href="https://docs.aws.amazon.com/sns/latest/dg/mobile-push-send-custommessage.html">Send Custom Platform-Specific Payloads in Messages to Mobile Devices</a>. </p> <important> <p>You can publish messages only to topics and endpoints in the same Amazon Web Services Region.</p> </important>', 'PublishBatch' => '<p>Publishes up to ten messages to the specified topic. This is a batch version of <code>Publish</code>. For FIFO topics, multiple messages within a single batch are published in the order they are sent, and messages are deduplicated within the batch and across batches for 5 minutes.</p> <p>The result of publishing each message is reported individually in the response. Because the batch request can result in a combination of successful and unsuccessful actions, you should check for batch errors even when the call returns an HTTP status code of <code>200</code>.</p> <p>The maximum allowed individual message size and the maximum total payload size (the sum of the individual lengths of all of the batched messages) are both 256 KB (262,144 bytes). </p> <p>Some actions take lists of parameters. These lists are specified using the <code>param.n</code> notation. Values of <code>n</code> are integers starting from 1. For example, a parameter list with two elements looks like this: </p> <p>&amp;AttributeName.1=first</p> <p>&amp;AttributeName.2=second</p> <p>If you send a batch message to a topic, Amazon SNS publishes the batch message to each endpoint that is subscribed to the topic. The format of the batch message depends on the notification protocol for each subscribed endpoint.</p> <p>When a <code>messageId</code> is returned, the batch message is saved and Amazon SNS immediately delivers the message to subscribers.</p>', 'PutDataProtectionPolicy' => '<p>Adds or updates an inline policy document that is stored in the specified Amazon SNS topic.</p>', 'RemovePermission' => '<p>Removes a statement from a topic\'s access control policy.</p> <note> <p>To remove the ability to change topic permissions, you must deny permissions to the <code>AddPermission</code>, <code>RemovePermission</code>, and <code>SetTopicAttributes</code> actions in your IAM policy.</p> </note>', 'SetEndpointAttributes' => '<p>Sets the attributes for an endpoint for a device on one of the supported push notification services, such as GCM (Firebase Cloud Messaging) and APNS. For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html">Using Amazon SNS Mobile Push Notifications</a>. </p>', 'SetPlatformApplicationAttributes' => '<p>Sets the attributes of the platform application object for the supported push notification services, such as APNS and GCM (Firebase Cloud Messaging). For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html">Using Amazon SNS Mobile Push Notifications</a>. For information on configuring attributes for message delivery status, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-msg-status.html">Using Amazon SNS Application Attributes for Message Delivery Status</a>. </p>', 'SetSMSAttributes' => '<p>Use this request to set the default settings for sending SMS messages and receiving daily SMS usage reports.</p> <p>You can override some of these settings for a single message when you use the <code>Publish</code> action with the <code>MessageAttributes.entry.N</code> parameter. For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sms_publish-to-phone.html">Publishing to a mobile phone</a> in the <i>Amazon SNS Developer Guide</i>.</p> <note> <p>To use this operation, you must grant the Amazon SNS service principal (<code>sns.amazonaws.com</code>) permission to perform the <code>s3:ListBucket</code> action. </p> </note>', 'SetSubscriptionAttributes' => '<p>Allows a subscription owner to set an attribute of the subscription to a new value.</p>', 'SetTopicAttributes' => '<p>Allows a topic owner to set an attribute of the topic to a new value.</p> <note> <p>To remove the ability to change topic permissions, you must deny permissions to the <code>AddPermission</code>, <code>RemovePermission</code>, and <code>SetTopicAttributes</code> actions in your IAM policy.</p> </note>', 'Subscribe' => '<p>Subscribes an endpoint to an Amazon SNS topic. If the endpoint type is HTTP/S or email, or if the endpoint and the topic are not in the same Amazon Web Services account, the endpoint owner must run the <code>ConfirmSubscription</code> action to confirm the subscription.</p> <p>You call the <code>ConfirmSubscription</code> action with the token from the subscription response. Confirmation tokens are valid for two days.</p> <p>This action is throttled at 100 transactions per second (TPS).</p>', 'TagResource' => '<p>Add tags to the specified Amazon SNS topic. For an overview, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-tags.html">Amazon SNS Tags</a> in the <i>Amazon SNS Developer Guide</i>.</p> <p>When you use topic tags, keep the following guidelines in mind:</p> <ul> <li> <p>Adding more than 50 tags to a topic isn\'t recommended.</p> </li> <li> <p>Tags don\'t have any semantic meaning. Amazon SNS interprets tags as character strings.</p> </li> <li> <p>Tags are case-sensitive.</p> </li> <li> <p>A new tag with a key identical to that of an existing tag overwrites the existing tag.</p> </li> <li> <p>Tagging actions are limited to 10 TPS per Amazon Web Services account, per Amazon Web Services Region. If your application requires a higher throughput, file a <a href="https://console.aws.amazon.com/support/home#/case/create?issueType=technical">technical support request</a>.</p> </li> </ul>', 'Unsubscribe' => '<p>Deletes a subscription. If the subscription requires authentication for deletion, only the owner of the subscription or the topic\'s owner can unsubscribe, and an Amazon Web Services signature is required. If the <code>Unsubscribe</code> call does not require authentication and the requester is not the subscription owner, a final cancellation message is delivered to the endpoint, so that the endpoint owner can easily resubscribe to the topic if the <code>Unsubscribe</code> request was unintended.</p> <note> <p>Amazon SQS queue subscriptions require authentication for deletion. Only the owner of the subscription, or the owner of the topic can unsubscribe using the required Amazon Web Services signature.</p> </note> <p>This action is throttled at 100 transactions per second (TPS).</p>', 'UntagResource' => '<p>Remove tags from the specified Amazon SNS topic. For an overview, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-tags.html">Amazon SNS Tags</a> in the <i>Amazon SNS Developer Guide</i>.</p>', 'VerifySMSSandboxPhoneNumber' => '<p>Verifies a destination phone number with a one-time password (OTP) for the calling Amazon Web Services account.</p> <p>When you start using Amazon SNS to send SMS messages, your Amazon Web Services account is in the <i>SMS sandbox</i>. The SMS sandbox provides a safe environment for you to try Amazon SNS features without risking your reputation as an SMS sender. While your Amazon Web Services account is in the SMS sandbox, you can use all of the features of Amazon SNS. However, you can send SMS messages only to verified destination phone numbers. For more information, including how to move out of the sandbox to send messages without restrictions, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">SMS sandbox</a> in the <i>Amazon SNS Developer Guide</i>.</p>', ], 'shapes' => [ 'ActionsList' => [ 'base' => NULL, 'refs' => [ 'AddPermissionInput$ActionName' => '<p>The action you want to allow for the specified principal(s).</p> <p>Valid values: Any Amazon SNS action name, for example <code>Publish</code>.</p>', ], ], 'AddPermissionInput' => [ 'base' => NULL, 'refs' => [], ], 'AmazonResourceName' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$ResourceArn' => '<p>The ARN of the topic for which to list tags.</p>', 'TagResourceRequest$ResourceArn' => '<p>The ARN of the topic to which to add tags.</p>', 'UntagResourceRequest$ResourceArn' => '<p>The ARN of the topic from which to remove tags.</p>', ], ], 'AuthorizationErrorException' => [ 'base' => '<p>Indicates that the user has been denied access to the requested resource.</p>', 'refs' => [], ], 'BatchEntryIdsNotDistinctException' => [ 'base' => '<p>Two or more batch entries in the request have the same <code>Id</code>.</p>', 'refs' => [], ], 'BatchRequestTooLongException' => [ 'base' => '<p>The length of all the batch messages put together is more than the limit.</p>', 'refs' => [], ], 'BatchResultErrorEntry' => [ 'base' => '<p>Gives a detailed description of failed messages in the batch.</p>', 'refs' => [ 'BatchResultErrorEntryList$member' => NULL, ], ], 'BatchResultErrorEntryList' => [ 'base' => NULL, 'refs' => [ 'PublishBatchResponse$Failed' => '<p>A list of failed <code>PublishBatch</code> responses. </p>', ], ], 'Binary' => [ 'base' => NULL, 'refs' => [ 'MessageAttributeValue$BinaryValue' => '<p>Binary type attributes can store any binary data, for example, compressed data, encrypted data, or images.</p>', ], ], 'CheckIfPhoneNumberIsOptedOutInput' => [ 'base' => '<p>The input for the <code>CheckIfPhoneNumberIsOptedOut</code> action.</p>', 'refs' => [], ], 'CheckIfPhoneNumberIsOptedOutResponse' => [ 'base' => '<p>The response from the <code>CheckIfPhoneNumberIsOptedOut</code> action.</p>', 'refs' => [], ], 'ConcurrentAccessException' => [ 'base' => '<p>Can\'t perform multiple operations on a tag simultaneously. Perform the operations sequentially.</p>', 'refs' => [], ], 'ConfirmSubscriptionInput' => [ 'base' => '<p>Input for ConfirmSubscription action.</p>', 'refs' => [], ], 'ConfirmSubscriptionResponse' => [ 'base' => '<p>Response for ConfirmSubscriptions action.</p>', 'refs' => [], ], 'CreateEndpointResponse' => [ 'base' => '<p>Response from CreateEndpoint action.</p>', 'refs' => [], ], 'CreatePlatformApplicationInput' => [ 'base' => '<p>Input for CreatePlatformApplication action.</p>', 'refs' => [], ], 'CreatePlatformApplicationResponse' => [ 'base' => '<p>Response from CreatePlatformApplication action.</p>', 'refs' => [], ], 'CreatePlatformEndpointInput' => [ 'base' => '<p>Input for CreatePlatformEndpoint action.</p>', 'refs' => [], ], 'CreateSMSSandboxPhoneNumberInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateSMSSandboxPhoneNumberResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateTopicInput' => [ 'base' => '<p>Input for CreateTopic action.</p>', 'refs' => [], ], 'CreateTopicResponse' => [ 'base' => '<p>Response from CreateTopic action.</p>', 'refs' => [], ], 'DelegatesList' => [ 'base' => NULL, 'refs' => [ 'AddPermissionInput$AWSAccountId' => '<p>The Amazon Web Services account IDs of the users (principals) who will be given access to the specified actions. The users must have Amazon Web Services account, but do not need to be signed up for this service.</p>', ], ], 'DeleteEndpointInput' => [ 'base' => '<p>Input for <code>DeleteEndpoint</code> action.</p>', 'refs' => [], ], 'DeletePlatformApplicationInput' => [ 'base' => '<p>Input for <code>DeletePlatformApplication</code> action.</p>', 'refs' => [], ], 'DeleteSMSSandboxPhoneNumberInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSMSSandboxPhoneNumberResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTopicInput' => [ 'base' => NULL, 'refs' => [], ], 'EmptyBatchRequestException' => [ 'base' => '<p>The batch request doesn\'t contain any entries.</p>', 'refs' => [], ], 'Endpoint' => [ 'base' => '<p>The endpoint for mobile app and device.</p>', 'refs' => [ 'ListOfEndpoints$member' => NULL, ], ], 'EndpointDisabledException' => [ 'base' => '<p>Exception error indicating endpoint disabled.</p>', 'refs' => [], ], 'FilterPolicyLimitExceededException' => [ 'base' => '<p>Indicates that the number of filter polices in your Amazon Web Services account exceeds the limit. To add more filter polices, submit an Amazon SNS Limit Increase case in the Amazon Web Services Support Center.</p>', 'refs' => [], ], 'GetDataProtectionPolicyInput' => [ 'base' => NULL, 'refs' => [], ], 'GetDataProtectionPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetEndpointAttributesInput' => [ 'base' => '<p>Input for <code>GetEndpointAttributes</code> action.</p>', 'refs' => [], ], 'GetEndpointAttributesResponse' => [ 'base' => '<p>Response from <code>GetEndpointAttributes</code> of the <code>EndpointArn</code>.</p>', 'refs' => [], ], 'GetPlatformApplicationAttributesInput' => [ 'base' => '<p>Input for <code>GetPlatformApplicationAttributes</code> action.</p>', 'refs' => [], ], 'GetPlatformApplicationAttributesResponse' => [ 'base' => '<p>Response for <code>GetPlatformApplicationAttributes</code> action.</p>', 'refs' => [], ], 'GetSMSAttributesInput' => [ 'base' => '<p>The input for the <code>GetSMSAttributes</code> request.</p>', 'refs' => [], ], 'GetSMSAttributesResponse' => [ 'base' => '<p>The response from the <code>GetSMSAttributes</code> request.</p>', 'refs' => [], ], 'GetSMSSandboxAccountStatusInput' => [ 'base' => NULL, 'refs' => [], ], 'GetSMSSandboxAccountStatusResult' => [ 'base' => NULL, 'refs' => [], ], 'GetSubscriptionAttributesInput' => [ 'base' => '<p>Input for GetSubscriptionAttributes.</p>', 'refs' => [], ], 'GetSubscriptionAttributesResponse' => [ 'base' => '<p>Response for GetSubscriptionAttributes action.</p>', 'refs' => [], ], 'GetTopicAttributesInput' => [ 'base' => '<p>Input for GetTopicAttributes action.</p>', 'refs' => [], ], 'GetTopicAttributesResponse' => [ 'base' => '<p>Response for GetTopicAttributes action.</p>', 'refs' => [], ], 'InternalErrorException' => [ 'base' => '<p>Indicates an internal service error.</p>', 'refs' => [], ], 'InvalidBatchEntryIdException' => [ 'base' => '<p>The <code>Id</code> of a batch entry in a batch request doesn\'t abide by the specification. </p>', 'refs' => [], ], 'InvalidParameterException' => [ 'base' => '<p>Indicates that a request parameter does not comply with the associated constraints.</p>', 'refs' => [], ], 'InvalidParameterValueException' => [ 'base' => '<p>Indicates that a request parameter does not comply with the associated constraints.</p>', 'refs' => [], ], 'InvalidSecurityException' => [ 'base' => '<p>The credential signature isn\'t valid. You must use an HTTPS endpoint and sign your request using Signature Version 4.</p>', 'refs' => [], ], 'InvalidStateException' => [ 'base' => '<p>Indicates that the specified state is not a valid state for an event source.</p>', 'refs' => [], ], 'Iso2CountryCode' => [ 'base' => 'The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. For example, GB or US.', 'refs' => [ 'PhoneNumberInformation$Iso2CountryCode' => '<p>The two-character code for the country or region, in ISO 3166-1 alpha-2 format.</p>', ], ], 'KMSAccessDeniedException' => [ 'base' => '<p>The ciphertext references a key that doesn\'t exist or that you don\'t have access to.</p>', 'refs' => [], ], 'KMSDisabledException' => [ 'base' => '<p>The request was rejected because the specified Amazon Web Services KMS key isn\'t enabled.</p>', 'refs' => [], ], 'KMSInvalidStateException' => [ 'base' => '<p>The request was rejected because the state of the specified resource isn\'t valid for this request. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key states of Amazon Web Services KMS keys</a> in the <i>Key Management Service Developer Guide</i>.</p>', 'refs' => [], ], 'KMSNotFoundException' => [ 'base' => '<p>The request was rejected because the specified entity or resource can\'t be found.</p>', 'refs' => [], ], 'KMSOptInRequired' => [ 'base' => '<p>The Amazon Web Services access key ID needs a subscription for the service.</p>', 'refs' => [], ], 'KMSThrottlingException' => [ 'base' => '<p>The request was denied due to request throttling. For more information about throttling, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/limits.html#requests-per-second">Limits</a> in the <i>Key Management Service Developer Guide.</i> </p>', 'refs' => [], ], 'LanguageCodeString' => [ 'base' => 'Supported language code for sending OTP message', 'refs' => [ 'CreateSMSSandboxPhoneNumberInput$LanguageCode' => '<p>The language to use for sending the OTP. The default value is <code>en-US</code>.</p>', ], ], 'ListEndpointsByPlatformApplicationInput' => [ 'base' => '<p>Input for <code>ListEndpointsByPlatformApplication</code> action.</p>', 'refs' => [], ], 'ListEndpointsByPlatformApplicationResponse' => [ 'base' => '<p>Response for <code>ListEndpointsByPlatformApplication</code> action.</p>', 'refs' => [], ], 'ListOfEndpoints' => [ 'base' => NULL, 'refs' => [ 'ListEndpointsByPlatformApplicationResponse$Endpoints' => '<p>Endpoints returned for <code>ListEndpointsByPlatformApplication</code> action.</p>', ], ], 'ListOfPlatformApplications' => [ 'base' => NULL, 'refs' => [ 'ListPlatformApplicationsResponse$PlatformApplications' => '<p>Platform applications returned when calling <code>ListPlatformApplications</code> action.</p>', ], ], 'ListOriginationNumbersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListOriginationNumbersResult' => [ 'base' => NULL, 'refs' => [], ], 'ListPhoneNumbersOptedOutInput' => [ 'base' => '<p>The input for the <code>ListPhoneNumbersOptedOut</code> action.</p>', 'refs' => [], ], 'ListPhoneNumbersOptedOutResponse' => [ 'base' => '<p>The response from the <code>ListPhoneNumbersOptedOut</code> action.</p>', 'refs' => [], ], 'ListPlatformApplicationsInput' => [ 'base' => '<p>Input for <code>ListPlatformApplications</code> action.</p>', 'refs' => [], ], 'ListPlatformApplicationsResponse' => [ 'base' => '<p>Response for <code>ListPlatformApplications</code> action.</p>', 'refs' => [], ], 'ListSMSSandboxPhoneNumbersInput' => [ 'base' => NULL, 'refs' => [], ], 'ListSMSSandboxPhoneNumbersResult' => [ 'base' => NULL, 'refs' => [], ], 'ListString' => [ 'base' => NULL, 'refs' => [ 'GetSMSAttributesInput$attributes' => '<p>A list of the individual attribute names, such as <code>MonthlySpendLimit</code>, for which you want values.</p> <p>For all attribute names, see <a href="https://docs.aws.amazon.com/sns/latest/api/API_SetSMSAttributes.html">SetSMSAttributes</a>.</p> <p>If you don\'t use this parameter, Amazon SNS returns all SMS attributes.</p>', ], ], 'ListSubscriptionsByTopicInput' => [ 'base' => '<p>Input for ListSubscriptionsByTopic action.</p>', 'refs' => [], ], 'ListSubscriptionsByTopicResponse' => [ 'base' => '<p>Response for ListSubscriptionsByTopic action.</p>', 'refs' => [], ], 'ListSubscriptionsInput' => [ 'base' => '<p>Input for ListSubscriptions action.</p>', 'refs' => [], ], 'ListSubscriptionsResponse' => [ 'base' => '<p>Response for ListSubscriptions action</p>', 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTopicsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListTopicsResponse' => [ 'base' => '<p>Response for ListTopics action.</p>', 'refs' => [], ], 'MapStringToString' => [ 'base' => NULL, 'refs' => [ 'CreatePlatformApplicationInput$Attributes' => '<p>For a list of attributes, see <a href="https://docs.aws.amazon.com/sns/latest/api/API_SetPlatformApplicationAttributes.html"> <code>SetPlatformApplicationAttributes</code> </a>.</p>', 'CreatePlatformEndpointInput$Attributes' => '<p>For a list of attributes, see <a href="https://docs.aws.amazon.com/sns/latest/api/API_SetEndpointAttributes.html"> <code>SetEndpointAttributes</code> </a>.</p>', 'Endpoint$Attributes' => '<p>Attributes for endpoint.</p>', 'GetEndpointAttributesResponse$Attributes' => '<p>Attributes include the following:</p> <ul> <li> <p> <code>CustomUserData</code> – arbitrary user data to associate with the endpoint. Amazon SNS does not use this data. The data must be in UTF-8 format and less than 2KB.</p> </li> <li> <p> <code>Enabled</code> – flag that enables/disables delivery to the endpoint. Amazon SNS will set this to false when a notification service indicates to Amazon SNS that the endpoint is invalid. Users can set it back to true, typically after updating Token.</p> </li> <li> <p> <code>Token</code> – device token, also referred to as a registration id, for an app and mobile device. This is returned from the notification service when an app and mobile device are registered with the notification service.</p> <note> <p>The device token for the iOS platform is returned in lowercase.</p> </note> </li> </ul>', 'GetPlatformApplicationAttributesResponse$Attributes' => '<p>Attributes include the following:</p> <ul> <li> <p> <code>AppleCertificateExpiryDate</code> – The expiry date of the SSL certificate used to configure certificate-based authentication.</p> </li> <li> <p> <code>ApplePlatformTeamID</code> – The Apple developer account ID used to configure token-based authentication.</p> </li> <li> <p> <code>ApplePlatformBundleID</code> – The app identifier used to configure token-based authentication.</p> </li> <li> <p> <code>AuthenticationMethod</code> – Returns the credential type used when sending push notifications from application to APNS/APNS_Sandbox, or application to GCM.</p> <ul> <li> <p>APNS – Returns the token or certificate.</p> </li> <li> <p>GCM – Returns the token or key.</p> </li> </ul> </li> <li> <p> <code>EventEndpointCreated</code> – Topic ARN to which EndpointCreated event notifications should be sent.</p> </li> <li> <p> <code>EventEndpointDeleted</code> – Topic ARN to which EndpointDeleted event notifications should be sent.</p> </li> <li> <p> <code>EventEndpointUpdated</code> – Topic ARN to which EndpointUpdate event notifications should be sent.</p> </li> <li> <p> <code>EventDeliveryFailure</code> – Topic ARN to which DeliveryFailure event notifications should be sent upon Direct Publish delivery failure (permanent) to one of the application\'s endpoints.</p> </li> </ul>', 'GetSMSAttributesResponse$attributes' => '<p>The SMS attribute names and their values.</p>', 'PlatformApplication$Attributes' => '<p>Attributes for platform application object.</p>', 'SetEndpointAttributesInput$Attributes' => '<p>A map of the endpoint attributes. Attributes in this map include the following:</p> <ul> <li> <p> <code>CustomUserData</code> – arbitrary user data to associate with the endpoint. Amazon SNS does not use this data. The data must be in UTF-8 format and less than 2KB.</p> </li> <li> <p> <code>Enabled</code> – flag that enables/disables delivery to the endpoint. Amazon SNS will set this to false when a notification service indicates to Amazon SNS that the endpoint is invalid. Users can set it back to true, typically after updating Token.</p> </li> <li> <p> <code>Token</code> – device token, also referred to as a registration id, for an app and mobile device. This is returned from the notification service when an app and mobile device are registered with the notification service.</p> </li> </ul>', 'SetPlatformApplicationAttributesInput$Attributes' => '<p>A map of the platform application attributes. Attributes in this map include the following:</p> <ul> <li> <p> <code>PlatformCredential</code> – The credential received from the notification service.</p> <ul> <li> <p>For ADM, <code>PlatformCredential</code>is client secret.</p> </li> <li> <p>For Apple Services using certificate credentials, <code>PlatformCredential</code> is private key.</p> </li> <li> <p>For Apple Services using token credentials, <code>PlatformCredential</code> is signing key.</p> </li> <li> <p>For GCM (Firebase Cloud Messaging) using key credentials, there is no <code>PlatformPrincipal</code>. The <code>PlatformCredential</code> is <code>API key</code>.</p> </li> <li> <p>For GCM (Firebase Cloud Messaging) using token credentials, there is no <code>PlatformPrincipal</code>. The <code>PlatformCredential</code> is a JSON formatted private key file. When using the Amazon Web Services CLI, the file must be in string format and special characters must be ignored. To format the file correctly, Amazon SNS recommends using the following command: <code>SERVICE_JSON=`jq @json &lt;&lt;&lt; cat service.json`</code>.</p> </li> </ul> </li> </ul> <ul> <li> <p> <code>PlatformPrincipal</code> – The principal received from the notification service.</p> <ul> <li> <p>For ADM, <code>PlatformPrincipal</code>is client id.</p> </li> <li> <p>For Apple Services using certificate credentials, <code>PlatformPrincipal</code> is SSL certificate.</p> </li> <li> <p>For Apple Services using token credentials, <code>PlatformPrincipal</code> is signing key ID.</p> </li> <li> <p>For GCM (Firebase Cloud Messaging), there is no <code>PlatformPrincipal</code>. </p> </li> </ul> </li> </ul> <ul> <li> <p> <code>EventEndpointCreated</code> – Topic ARN to which <code>EndpointCreated</code> event notifications are sent.</p> </li> <li> <p> <code>EventEndpointDeleted</code> – Topic ARN to which <code>EndpointDeleted</code> event notifications are sent.</p> </li> <li> <p> <code>EventEndpointUpdated</code> – Topic ARN to which <code>EndpointUpdate</code> event notifications are sent.</p> </li> <li> <p> <code>EventDeliveryFailure</code> – Topic ARN to which <code>DeliveryFailure</code> event notifications are sent upon Direct Publish delivery failure (permanent) to one of the application\'s endpoints.</p> </li> <li> <p> <code>SuccessFeedbackRoleArn</code> – IAM role ARN used to give Amazon SNS write access to use CloudWatch Logs on your behalf.</p> </li> <li> <p> <code>FailureFeedbackRoleArn</code> – IAM role ARN used to give Amazon SNS write access to use CloudWatch Logs on your behalf.</p> </li> <li> <p> <code>SuccessFeedbackSampleRate</code> – Sample rate percentage (0-100) of successfully delivered messages.</p> </li> </ul> <p>The following attributes only apply to <code>APNs</code> token-based authentication:</p> <ul> <li> <p> <code>ApplePlatformTeamID</code> – The identifier that\'s assigned to your Apple developer account team.</p> </li> <li> <p> <code>ApplePlatformBundleID</code> – The bundle identifier that\'s assigned to your iOS app.</p> </li> </ul>', 'SetSMSAttributesInput$attributes' => '<p>The default settings for sending SMS messages from your Amazon Web Services account. You can set values for the following attribute names:</p> <p> <code>MonthlySpendLimit</code> – The maximum amount in USD that you are willing to spend each month to send SMS messages. When Amazon SNS determines that sending an SMS message would incur a cost that exceeds this limit, it stops sending SMS messages within minutes.</p> <important> <p>Amazon SNS stops sending SMS messages within minutes of the limit being crossed. During that interval, if you continue to send SMS messages, you will incur costs that exceed your limit.</p> </important> <p>By default, the spend limit is set to the maximum allowed by Amazon SNS. If you want to raise the limit, submit an <a href="https://console.aws.amazon.com/support/home#/case/create?issueType=service-limit-increase&amp;limitType=service-code-sns">SNS Limit Increase case</a>. For <b>New limit value</b>, enter your desired monthly spend limit. In the <b>Use Case Description</b> field, explain that you are requesting an SMS monthly spend limit increase.</p> <p> <code>DeliveryStatusIAMRole</code> – The ARN of the IAM role that allows Amazon SNS to write logs about SMS deliveries in CloudWatch Logs. For each SMS message that you send, Amazon SNS writes a log that includes the message price, the success or failure status, the reason for failure (if the message failed), the message dwell time, and other information.</p> <p> <code>DeliveryStatusSuccessSamplingRate</code> – The percentage of successful SMS deliveries for which Amazon SNS will write logs in CloudWatch Logs. The value can be an integer from 0 - 100. For example, to write logs only for failed deliveries, set this value to <code>0</code>. To write logs for 10% of your successful deliveries, set it to <code>10</code>.</p> <p> <code>DefaultSenderID</code> – A string, such as your business brand, that is displayed as the sender on the receiving device. Support for sender IDs varies by country. The sender ID can be 1 - 11 alphanumeric characters, and it must contain at least one letter.</p> <p> <code>DefaultSMSType</code> – The type of SMS message that you will send by default. You can assign the following values:</p> <ul> <li> <p> <code>Promotional</code> – (Default) Noncritical messages, such as marketing messages. Amazon SNS optimizes the message delivery to incur the lowest cost.</p> </li> <li> <p> <code>Transactional</code> – Critical messages that support customer transactions, such as one-time passcodes for multi-factor authentication. Amazon SNS optimizes the message delivery to achieve the highest reliability.</p> </li> </ul> <p> <code>UsageReportS3Bucket</code> – The name of the Amazon S3 bucket to receive daily SMS usage reports from Amazon SNS. Each day, Amazon SNS will deliver a usage report as a CSV file to the bucket. The report includes the following information for each SMS message that was successfully delivered by your Amazon Web Services account:</p> <ul> <li> <p>Time that the message was published (in UTC)</p> </li> <li> <p>Message ID</p> </li> <li> <p>Destination phone number</p> </li> <li> <p>Message type</p> </li> <li> <p>Delivery status</p> </li> <li> <p>Message price (in USD)</p> </li> <li> <p>Part number (a message is split into multiple parts if it is too long for a single message)</p> </li> <li> <p>Total number of parts</p> </li> </ul> <p>To receive the report, the bucket must have a policy that allows the Amazon SNS service principal to perform the <code>s3:PutObject</code> and <code>s3:GetBucketLocation</code> actions.</p> <p>For an example bucket policy and usage report, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sms_stats.html">Monitoring SMS Activity</a> in the <i>Amazon SNS Developer Guide</i>.</p>', ], ], 'MaxItems' => [ 'base' => NULL, 'refs' => [ 'ListSMSSandboxPhoneNumbersInput$MaxResults' => '<p>The maximum number of phone numbers to return.</p>', ], ], 'MaxItemsListOriginationNumbers' => [ 'base' => NULL, 'refs' => [ 'ListOriginationNumbersRequest$MaxResults' => '<p>The maximum number of origination numbers to return.</p>', ], ], 'MessageAttributeMap' => [ 'base' => NULL, 'refs' => [ 'PublishBatchRequestEntry$MessageAttributes' => '<p>Each message attribute consists of a <code>Name</code>, <code>Type</code>, and <code>Value</code>. For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-message-attributes.html">Amazon SNS message attributes</a> in the Amazon SNS Developer Guide.</p>', 'PublishInput$MessageAttributes' => '<p>Message attributes for Publish action.</p>', ], ], 'MessageAttributeValue' => [ 'base' => '<p>The user-specified message attribute value. For string data types, the value attribute has the same restrictions on the content as the message body. For more information, see <a href="https://docs.aws.amazon.com/sns/latest/api/API_Publish.html">Publish</a>.</p> <p>Name, type, and value must not be empty or null. In addition, the message body should not be empty or null. All parts of the message attribute, including name, type, and value, are included in the message size restriction, which is currently 256 KB (262,144 bytes). For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/SNSMessageAttributes.html">Amazon SNS message attributes</a> and <a href="https://docs.aws.amazon.com/sns/latest/dg/sms_publish-to-phone.html">Publishing to a mobile phone</a> in the <i>Amazon SNS Developer Guide.</i> </p>', 'refs' => [ 'MessageAttributeMap$value' => NULL, ], ], 'NotFoundException' => [ 'base' => '<p>Indicates that the requested resource does not exist.</p>', 'refs' => [], ], 'NumberCapability' => [ 'base' => 'Enum listing out all supported number capabilities.', 'refs' => [ 'NumberCapabilityList$member' => NULL, ], ], 'NumberCapabilityList' => [ 'base' => 'List of number capability (SMS,MMS,Voice).', 'refs' => [ 'PhoneNumberInformation$NumberCapabilities' => '<p>The capabilities of each phone number.</p>', ], ], 'OTPCode' => [ 'base' => 'String of Origination/Destination address including phone numbers and email addresses', 'refs' => [ 'VerifySMSSandboxPhoneNumberInput$OneTimePassword' => '<p>The OTP sent to the destination number from the <code>CreateSMSSandBoxPhoneNumber</code> call.</p>', ], ], 'OptInPhoneNumberInput' => [ 'base' => '<p>Input for the OptInPhoneNumber action.</p>', 'refs' => [], ], 'OptInPhoneNumberResponse' => [ 'base' => '<p>The response for the OptInPhoneNumber action.</p>', 'refs' => [], ], 'OptedOutException' => [ 'base' => '<p>Indicates that the specified phone number opted out of receiving SMS messages from your Amazon Web Services account. You can\'t send SMS messages to phone numbers that opt out.</p>', 'refs' => [], ], 'PhoneNumber' => [ 'base' => NULL, 'refs' => [ 'CheckIfPhoneNumberIsOptedOutInput$phoneNumber' => '<p>The phone number for which you want to check the opt out status.</p>', 'OptInPhoneNumberInput$phoneNumber' => '<p>The phone number to opt in. Use E.164 format.</p>', 'PhoneNumberInformation$PhoneNumber' => '<p>The phone number.</p>', 'PhoneNumberList$member' => NULL, 'PublishInput$PhoneNumber' => '<p>The phone number to which you want to deliver an SMS message. Use E.164 format.</p> <p>If you don\'t specify a value for the <code>PhoneNumber</code> parameter, you must specify a value for the <code>TargetArn</code> or <code>TopicArn</code> parameters.</p>', ], ], 'PhoneNumberInformation' => [ 'base' => '<p>A list of phone numbers and their metadata.</p>', 'refs' => [ 'PhoneNumberInformationList$member' => NULL, ], ], 'PhoneNumberInformationList' => [ 'base' => 'List of customer owned phone numbers.', 'refs' => [ 'ListOriginationNumbersResult$PhoneNumbers' => '<p>A list of the calling account\'s verified and pending origination numbers.</p>', ], ], 'PhoneNumberList' => [ 'base' => NULL, 'refs' => [ 'ListPhoneNumbersOptedOutResponse$phoneNumbers' => '<p>A list of phone numbers that are opted out of receiving SMS messages. The list is paginated, and each page can contain up to 100 phone numbers.</p>', ], ], 'PhoneNumberString' => [ 'base' => NULL, 'refs' => [ 'CreateSMSSandboxPhoneNumberInput$PhoneNumber' => '<p>The destination phone number to verify. On verification, Amazon SNS adds this phone number to the list of verified phone numbers that you can send SMS messages to.</p>', 'DeleteSMSSandboxPhoneNumberInput$PhoneNumber' => '<p>The destination phone number to delete.</p>', 'SMSSandboxPhoneNumber$PhoneNumber' => '<p>The destination phone number.</p>', 'VerifySMSSandboxPhoneNumberInput$PhoneNumber' => '<p>The destination phone number to verify.</p>', ], ], 'PlatformApplication' => [ 'base' => '<p>Platform application object.</p>', 'refs' => [ 'ListOfPlatformApplications$member' => NULL, ], ], 'PlatformApplicationDisabledException' => [ 'base' => '<p>Exception error indicating platform application disabled.</p>', 'refs' => [], ], 'PublishBatchInput' => [ 'base' => NULL, 'refs' => [], ], 'PublishBatchRequestEntry' => [ 'base' => '<p>Contains the details of a single Amazon SNS message along with an <code>Id</code> that identifies a message within the batch. </p>', 'refs' => [ 'PublishBatchRequestEntryList$member' => NULL, ], ], 'PublishBatchRequestEntryList' => [ 'base' => NULL, 'refs' => [ 'PublishBatchInput$PublishBatchRequestEntries' => '<p>A list of <code>PublishBatch</code> request entries to be sent to the SNS topic.</p>', ], ], 'PublishBatchResponse' => [ 'base' => NULL, 'refs' => [], ], 'PublishBatchResultEntry' => [ 'base' => '<p>Encloses data related to a successful message in a batch request for topic.</p>', 'refs' => [ 'PublishBatchResultEntryList$member' => NULL, ], ], 'PublishBatchResultEntryList' => [ 'base' => NULL, 'refs' => [ 'PublishBatchResponse$Successful' => '<p>A list of successful <code>PublishBatch</code> responses.</p>', ], ], 'PublishInput' => [ 'base' => '<p>Input for Publish action.</p>', 'refs' => [], ], 'PublishResponse' => [ 'base' => '<p>Response for Publish action.</p>', 'refs' => [], ], 'PutDataProtectionPolicyInput' => [ 'base' => NULL, 'refs' => [], ], 'RemovePermissionInput' => [ 'base' => '<p>Input for RemovePermission action.</p>', 'refs' => [], ], 'ReplayLimitExceededException' => [ 'base' => '<p>Indicates that the request parameter has exceeded the maximum number of concurrent message replays.</p>', 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>Can’t perform the action on the specified resource. Make sure that the resource exists.</p>', 'refs' => [], ], 'RouteType' => [ 'base' => 'Enum listing out all supported route types. The following enum values are supported. 1. Transactional : Non-marketing traffic 2. Promotional : Marketing 3. Premium : Premium routes for OTP delivery to the carriers', 'refs' => [ 'PhoneNumberInformation$RouteType' => '<p>The list of supported routes.</p>', ], ], 'SMSSandboxPhoneNumber' => [ 'base' => '<p>A verified or pending destination phone number in the SMS sandbox.</p> <p>When you start using Amazon SNS to send SMS messages, your Amazon Web Services account is in the <i>SMS sandbox</i>. The SMS sandbox provides a safe environment for you to try Amazon SNS features without risking your reputation as an SMS sender. While your Amazon Web Services account is in the SMS sandbox, you can use all of the features of Amazon SNS. However, you can send SMS messages only to verified destination phone numbers. For more information, including how to move out of the sandbox to send messages without restrictions, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">SMS sandbox</a> in the <i>Amazon SNS Developer Guide</i>.</p>', 'refs' => [ 'SMSSandboxPhoneNumberList$member' => NULL, ], ], 'SMSSandboxPhoneNumberList' => [ 'base' => NULL, 'refs' => [ 'ListSMSSandboxPhoneNumbersResult$PhoneNumbers' => '<p>A list of the calling account\'s pending and verified phone numbers.</p>', ], ], 'SMSSandboxPhoneNumberVerificationStatus' => [ 'base' => 'Enum listing out all supported destination phone number verification statuses. The following enum values are supported. 1. PENDING : The destination phone number is pending verification. 2. VERIFIED : The destination phone number is verified.', 'refs' => [ 'SMSSandboxPhoneNumber$Status' => '<p>The destination phone number\'s verification status.</p>', ], ], 'SetEndpointAttributesInput' => [ 'base' => '<p>Input for <code>SetEndpointAttributes</code> action.</p>', 'refs' => [], ], 'SetPlatformApplicationAttributesInput' => [ 'base' => '<p>Input for <code>SetPlatformApplicationAttributes</code> action.</p>', 'refs' => [], ], 'SetSMSAttributesInput' => [ 'base' => '<p>The input for the SetSMSAttributes action.</p>', 'refs' => [], ], 'SetSMSAttributesResponse' => [ 'base' => '<p>The response for the SetSMSAttributes action.</p>', 'refs' => [], ], 'SetSubscriptionAttributesInput' => [ 'base' => '<p>Input for SetSubscriptionAttributes action.</p>', 'refs' => [], ], 'SetTopicAttributesInput' => [ 'base' => '<p>Input for SetTopicAttributes action.</p>', 'refs' => [], ], 'StaleTagException' => [ 'base' => '<p>A tag has been added to a resource with the same ARN as a deleted resource. Wait a short while and then retry the operation.</p>', 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'BatchResultErrorEntry$Id' => '<p>The <code>Id</code> of an entry in a batch request</p>', 'BatchResultErrorEntry$Code' => '<p>An error code representing why the action failed on this entry.</p>', 'BatchResultErrorEntry$Message' => '<p>A message explaining why the action failed on this entry.</p>', 'CreateEndpointResponse$EndpointArn' => '<p>EndpointArn returned from CreateEndpoint action.</p>', 'CreatePlatformApplicationInput$Name' => '<p>Application names must be made up of only uppercase and lowercase ASCII letters, numbers, underscores, hyphens, and periods, and must be between 1 and 256 characters long.</p>', 'CreatePlatformApplicationInput$Platform' => '<p>The following platforms are supported: ADM (Amazon Device Messaging), APNS (Apple Push Notification Service), APNS_SANDBOX, and GCM (Firebase Cloud Messaging).</p>', 'CreatePlatformApplicationResponse$PlatformApplicationArn' => '<p> <code>PlatformApplicationArn</code> is returned.</p>', 'CreatePlatformEndpointInput$PlatformApplicationArn' => '<p> <code>PlatformApplicationArn</code> returned from CreatePlatformApplication is used to create a an endpoint.</p>', 'CreatePlatformEndpointInput$Token' => '<p>Unique identifier created by the notification service for an app on a device. The specific name for Token will vary, depending on which notification service is being used. For example, when using APNS as the notification service, you need the device token. Alternatively, when using GCM (Firebase Cloud Messaging) or ADM, the device token equivalent is called the registration ID.</p>', 'CreatePlatformEndpointInput$CustomUserData' => '<p>Arbitrary user data to associate with the endpoint. Amazon SNS does not use this data. The data must be in UTF-8 format and less than 2KB.</p>', 'DeleteEndpointInput$EndpointArn' => '<p> <code>EndpointArn</code> of endpoint to delete.</p>', 'DeletePlatformApplicationInput$PlatformApplicationArn' => '<p> <code>PlatformApplicationArn</code> of platform application object to delete.</p>', 'Endpoint$EndpointArn' => '<p>The <code>EndpointArn</code> for mobile app and device.</p>', 'GetEndpointAttributesInput$EndpointArn' => '<p> <code>EndpointArn</code> for <code>GetEndpointAttributes</code> input.</p>', 'GetPlatformApplicationAttributesInput$PlatformApplicationArn' => '<p> <code>PlatformApplicationArn</code> for GetPlatformApplicationAttributesInput.</p>', 'ListEndpointsByPlatformApplicationInput$PlatformApplicationArn' => '<p> <code>PlatformApplicationArn</code> for <code>ListEndpointsByPlatformApplicationInput</code> action.</p>', 'ListEndpointsByPlatformApplicationInput$NextToken' => '<p> <code>NextToken</code> string is used when calling <code>ListEndpointsByPlatformApplication</code> action to retrieve additional records that are available after the first page results.</p>', 'ListEndpointsByPlatformApplicationResponse$NextToken' => '<p> <code>NextToken</code> string is returned when calling <code>ListEndpointsByPlatformApplication</code> action if additional records are available after the first page results.</p>', 'ListPlatformApplicationsInput$NextToken' => '<p> <code>NextToken</code> string is used when calling <code>ListPlatformApplications</code> action to retrieve additional records that are available after the first page results.</p>', 'ListPlatformApplicationsResponse$NextToken' => '<p> <code>NextToken</code> string is returned when calling <code>ListPlatformApplications</code> action if additional records are available after the first page results.</p>', 'ListString$member' => NULL, 'MapStringToString$key' => NULL, 'MapStringToString$value' => NULL, 'MessageAttributeMap$key' => NULL, 'MessageAttributeValue$DataType' => '<p>Amazon SNS supports the following logical data types: String, String.Array, Number, and Binary. For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/SNSMessageAttributes.html#SNSMessageAttributes.DataTypes">Message Attribute Data Types</a>.</p>', 'MessageAttributeValue$StringValue' => '<p>Strings are Unicode with UTF8 binary encoding. For a list of code values, see <a href="https://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters">ASCII Printable Characters</a>.</p>', 'PhoneNumberInformation$Status' => '<p>The status of the phone number.</p>', 'PlatformApplication$PlatformApplicationArn' => '<p>PlatformApplicationArn for platform application object.</p>', 'PublishBatchRequestEntry$Id' => '<p>An identifier for the message in this batch.</p> <note> <p>The <code>Ids</code> of a batch request must be unique within a request. </p> <p>This identifier can have up to 80 characters. The following characters are accepted: alphanumeric characters, hyphens(-), and underscores (_). </p> </note>', 'PublishBatchRequestEntry$MessageDeduplicationId' => '<p>This parameter applies only to FIFO (first-in-first-out) topics.</p> <p>The token used for deduplication of messages within a 5-minute minimum deduplication interval. If a message with a particular <code>MessageDeduplicationId</code> is sent successfully, subsequent messages with the same <code>MessageDeduplicationId</code> are accepted successfully but aren\'t delivered.</p> <ul> <li> <p>Every message must have a unique <code>MessageDeduplicationId</code>.</p> <ul> <li> <p>You may provide a <code>MessageDeduplicationId</code> explicitly.</p> </li> <li> <p>If you aren\'t able to provide a <code>MessageDeduplicationId</code> and you enable <code>ContentBasedDeduplication</code> for your topic, Amazon SNS uses a SHA-256 hash to generate the <code>MessageDeduplicationId</code> using the body of the message (but not the attributes of the message).</p> </li> <li> <p>If you don\'t provide a <code>MessageDeduplicationId</code> and the topic doesn\'t have <code>ContentBasedDeduplication</code> set, the action fails with an error.</p> </li> <li> <p>If the topic has a <code>ContentBasedDeduplication</code> set, your <code>MessageDeduplicationId</code> overrides the generated one. </p> </li> </ul> </li> <li> <p>When <code>ContentBasedDeduplication</code> is in effect, messages with identical content sent within the deduplication interval are treated as duplicates and only one copy of the message is delivered.</p> </li> <li> <p>If you send one message with <code>ContentBasedDeduplication</code> enabled, and then another message with a <code>MessageDeduplicationId</code> that is the same as the one generated for the first <code>MessageDeduplicationId</code>, the two messages are treated as duplicates and only one copy of the message is delivered. </p> </li> </ul> <note> <p>The <code>MessageDeduplicationId</code> is available to the consumer of the message (this can be useful for troubleshooting delivery issues).</p> <p>If a message is sent successfully but the acknowledgement is lost and the message is resent with the same <code>MessageDeduplicationId</code> after the deduplication interval, Amazon SNS can\'t detect duplicate messages. </p> <p>Amazon SNS continues to keep track of the message deduplication ID even after the message is received and deleted. </p> </note> <p>The length of <code>MessageDeduplicationId</code> is 128 characters.</p> <p> <code>MessageDeduplicationId</code> can contain alphanumeric characters <code>(a-z, A-Z, 0-9)</code> and punctuation <code>(!"#$%&amp;\'()*+,-./:;&lt;=&gt;?@[\\]^_`{|}~)</code>.</p>', 'PublishBatchRequestEntry$MessageGroupId' => '<p>This parameter applies only to FIFO (first-in-first-out) topics.</p> <p>The tag that specifies that a message belongs to a specific message group. Messages that belong to the same message group are processed in a FIFO manner (however, messages in different message groups might be processed out of order). To interleave multiple ordered streams within a single topic, use <code>MessageGroupId</code> values (for example, session data for multiple users). In this scenario, multiple consumers can process the topic, but the session data of each user is processed in a FIFO fashion. </p> <p>You must associate a non-empty <code>MessageGroupId</code> with a message. If you don\'t provide a <code>MessageGroupId</code>, the action fails. </p> <p>The length of <code>MessageGroupId</code> is 128 characters.</p> <p> <code>MessageGroupId</code> can contain alphanumeric characters <code>(a-z, A-Z, 0-9)</code> and punctuation <code>(!"#$%&amp;\'()*+,-./:;&lt;=&gt;?@[\\]^_`{|}~)</code>.</p> <important> <p> <code>MessageGroupId</code> is required for FIFO topics. You can\'t use it for standard topics. </p> </important>', 'PublishBatchResultEntry$Id' => '<p>The <code>Id</code> of an entry in a batch request.</p>', 'PublishBatchResultEntry$SequenceNumber' => '<p>This parameter applies only to FIFO (first-in-first-out) topics.</p> <p>The large, non-consecutive number that Amazon SNS assigns to each message.</p> <p>The length of <code>SequenceNumber</code> is 128 bits. <code>SequenceNumber</code> continues to increase for a particular <code>MessageGroupId</code>.</p>', 'PublishInput$TargetArn' => '<p>If you don\'t specify a value for the <code>TargetArn</code> parameter, you must specify a value for the <code>PhoneNumber</code> or <code>TopicArn</code> parameters.</p>', 'PublishInput$MessageDeduplicationId' => '<p>This parameter applies only to FIFO (first-in-first-out) topics. The <code>MessageDeduplicationId</code> can contain up to 128 alphanumeric characters <code>(a-z, A-Z, 0-9)</code> and punctuation <code>(!"#$%&amp;\'()*+,-./:;&lt;=&gt;?@[\\]^_`{|}~)</code>.</p> <p>Every message must have a unique <code>MessageDeduplicationId</code>, which is a token used for deduplication of sent messages. If a message with a particular <code>MessageDeduplicationId</code> is sent successfully, any message sent with the same <code>MessageDeduplicationId</code> during the 5-minute deduplication interval is treated as a duplicate. </p> <p>If the topic has <code>ContentBasedDeduplication</code> set, the system generates a <code>MessageDeduplicationId</code> based on the contents of the message. Your <code>MessageDeduplicationId</code> overrides the generated one.</p>', 'PublishInput$MessageGroupId' => '<p>This parameter applies only to FIFO (first-in-first-out) topics. The <code>MessageGroupId</code> can contain up to 128 alphanumeric characters <code>(a-z, A-Z, 0-9)</code> and punctuation <code>(!"#$%&amp;\'()*+,-./:;&lt;=&gt;?@[\\]^_`{|}~)</code>.</p> <p>The <code>MessageGroupId</code> is a tag that specifies that a message belongs to a specific message group. Messages that belong to the same message group are processed in a FIFO manner (however, messages in different message groups might be processed out of order). Every message must include a <code>MessageGroupId</code>.</p>', 'PublishResponse$SequenceNumber' => '<p>This response element applies only to FIFO (first-in-first-out) topics. </p> <p>The sequence number is a large, non-consecutive number that Amazon SNS assigns to each message. The length of <code>SequenceNumber</code> is 128 bits. <code>SequenceNumber</code> continues to increase for each <code>MessageGroupId</code>.</p>', 'SetEndpointAttributesInput$EndpointArn' => '<p>EndpointArn used for <code>SetEndpointAttributes</code> action.</p>', 'SetPlatformApplicationAttributesInput$PlatformApplicationArn' => '<p> <code>PlatformApplicationArn</code> for <code>SetPlatformApplicationAttributes</code> action.</p>', ], ], 'SubscribeInput' => [ 'base' => '<p>Input for Subscribe action.</p>', 'refs' => [], ], 'SubscribeResponse' => [ 'base' => '<p>Response for Subscribe action.</p>', 'refs' => [], ], 'Subscription' => [ 'base' => '<p>A wrapper type for the attributes of an Amazon SNS subscription.</p>', 'refs' => [ 'SubscriptionsList$member' => NULL, ], ], 'SubscriptionAttributesMap' => [ 'base' => NULL, 'refs' => [ 'GetSubscriptionAttributesResponse$Attributes' => '<p>A map of the subscription\'s attributes. Attributes in this map include the following:</p> <ul> <li> <p> <code>ConfirmationWasAuthenticated</code> – <code>true</code> if the subscription confirmation request was authenticated.</p> </li> <li> <p> <code>DeliveryPolicy</code> – The JSON serialization of the subscription\'s delivery policy.</p> </li> <li> <p> <code>EffectiveDeliveryPolicy</code> – The JSON serialization of the effective delivery policy that takes into account the topic delivery policy and account system defaults.</p> </li> <li> <p> <code>FilterPolicy</code> – The filter policy JSON that is assigned to the subscription. For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-message-filtering.html">Amazon SNS Message Filtering</a> in the <i>Amazon SNS Developer Guide</i>.</p> </li> <li> <p> <code>FilterPolicyScope</code> – This attribute lets you choose the filtering scope by using one of the following string value types:</p> <ul> <li> <p> <code>MessageAttributes</code> (default) – The filter is applied on the message attributes.</p> </li> <li> <p> <code>MessageBody</code> – The filter is applied on the message body.</p> </li> </ul> </li> <li> <p> <code>Owner</code> – The Amazon Web Services account ID of the subscription\'s owner.</p> </li> <li> <p> <code>PendingConfirmation</code> – <code>true</code> if the subscription hasn\'t been confirmed. To confirm a pending subscription, call the <code>ConfirmSubscription</code> action with a confirmation token.</p> </li> <li> <p> <code>RawMessageDelivery</code> – <code>true</code> if raw message delivery is enabled for the subscription. Raw messages are free of JSON formatting and can be sent to HTTP/S and Amazon SQS endpoints.</p> </li> <li> <p> <code>RedrivePolicy</code> – When specified, sends undeliverable messages to the specified Amazon SQS dead-letter queue. Messages that can\'t be delivered due to client errors (for example, when the subscribed endpoint is unreachable) or server errors (for example, when the service that powers the subscribed endpoint becomes unavailable) are held in the dead-letter queue for further analysis or reprocessing.</p> </li> <li> <p> <code>SubscriptionArn</code> – The subscription\'s ARN.</p> </li> <li> <p> <code>TopicArn</code> – The topic ARN that the subscription is associated with.</p> </li> </ul> <p>The following attribute applies only to Amazon Data Firehose delivery stream subscriptions:</p> <ul> <li> <p> <code>SubscriptionRoleArn</code> – The ARN of the IAM role that has the following:</p> <ul> <li> <p>Permission to write to the Firehose delivery stream</p> </li> <li> <p>Amazon SNS listed as a trusted entity</p> </li> </ul> <p>Specifying a valid ARN for this attribute is required for Firehose delivery stream subscriptions. For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-firehose-as-subscriber.html">Fanout to Firehose delivery streams</a> in the <i>Amazon SNS Developer Guide</i>.</p> </li> </ul>', 'SubscribeInput$Attributes' => '<p>A map of attributes with their corresponding values.</p> <p>The following lists the names, descriptions, and values of the special request parameters that the <code>Subscribe</code> action uses:</p> <ul> <li> <p> <code>DeliveryPolicy</code> – The policy that defines how Amazon SNS retries failed deliveries to HTTP/S endpoints.</p> </li> <li> <p> <code>FilterPolicy</code> – The simple JSON object that lets your subscriber receive only a subset of messages, rather than receiving every message published to the topic.</p> </li> <li> <p> <code>FilterPolicyScope</code> – This attribute lets you choose the filtering scope by using one of the following string value types:</p> <ul> <li> <p> <code>MessageAttributes</code> (default) – The filter is applied on the message attributes.</p> </li> <li> <p> <code>MessageBody</code> – The filter is applied on the message body.</p> </li> </ul> </li> <li> <p> <code>RawMessageDelivery</code> – When set to <code>true</code>, enables raw message delivery to Amazon SQS or HTTP/S endpoints. This eliminates the need for the endpoints to process JSON formatting, which is otherwise created for Amazon SNS metadata.</p> </li> <li> <p> <code>RedrivePolicy</code> – When specified, sends undeliverable messages to the specified Amazon SQS dead-letter queue. Messages that can\'t be delivered due to client errors (for example, when the subscribed endpoint is unreachable) or server errors (for example, when the service that powers the subscribed endpoint becomes unavailable) are held in the dead-letter queue for further analysis or reprocessing.</p> </li> </ul> <p>The following attribute applies only to Amazon Data Firehose delivery stream subscriptions:</p> <ul> <li> <p> <code>SubscriptionRoleArn</code> – The ARN of the IAM role that has the following:</p> <ul> <li> <p>Permission to write to the Firehose delivery stream</p> </li> <li> <p>Amazon SNS listed as a trusted entity</p> </li> </ul> <p>Specifying a valid ARN for this attribute is required for Firehose delivery stream subscriptions. For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-firehose-as-subscriber.html">Fanout to Firehose delivery streams</a> in the <i>Amazon SNS Developer Guide</i>.</p> </li> </ul> <p>The following attributes apply only to <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-fifo-topics.html">FIFO topics</a>:</p> <ul> <li> <p> <code>ReplayPolicy</code> – Adds or updates an inline policy document for a subscription to replay messages stored in the specified Amazon SNS topic.</p> </li> <li> <p> <code>ReplayStatus</code> – Retrieves the status of the subscription message replay, which can be one of the following:</p> <ul> <li> <p> <code>Completed</code> – The replay has successfully redelivered all messages, and is now delivering newly published messages. If an ending point was specified in the <code>ReplayPolicy</code> then the subscription will no longer receive newly published messages.</p> </li> <li> <p> <code>In progress</code> – The replay is currently replaying the selected messages.</p> </li> <li> <p> <code>Failed</code> – The replay was unable to complete.</p> </li> <li> <p> <code>Pending</code> – The default state while the replay initiates.</p> </li> </ul> </li> </ul>', ], ], 'SubscriptionLimitExceededException' => [ 'base' => '<p>Indicates that the customer already owns the maximum allowed number of subscriptions.</p>', 'refs' => [], ], 'SubscriptionsList' => [ 'base' => NULL, 'refs' => [ 'ListSubscriptionsByTopicResponse$Subscriptions' => '<p>A list of subscriptions.</p>', 'ListSubscriptionsResponse$Subscriptions' => '<p>A list of subscriptions.</p>', ], ], 'Tag' => [ 'base' => '<p>The list of tags to be added to the specified topic.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>The required key portion of the tag.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>The list of tag keys to remove from the specified topic.</p>', ], ], 'TagLimitExceededException' => [ 'base' => '<p>Can\'t add more than 50 tags to a topic.</p>', 'refs' => [], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateTopicInput$Tags' => '<p>The list of tags to add to a new topic.</p> <note> <p>To be able to tag a topic on creation, you must have the <code>sns:CreateTopic</code> and <code>sns:TagResource</code> permissions.</p> </note>', 'ListTagsForResourceResponse$Tags' => '<p>The tags associated with the specified topic.</p>', 'TagResourceRequest$Tags' => '<p>The tags to be added to the specified topic. A tag consists of a required key and an optional value.</p>', ], ], 'TagPolicyException' => [ 'base' => '<p>The request doesn\'t comply with the IAM tag policy. Correct your request and then retry it.</p>', 'refs' => [], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The optional value portion of the tag.</p>', ], ], 'ThrottledException' => [ 'base' => '<p>Indicates that the rate at which requests have been submitted for this action exceeds the limit for your Amazon Web Services account.</p>', 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'PhoneNumberInformation$CreatedAt' => '<p>The date and time when the phone number was created.</p>', ], ], 'TooManyEntriesInBatchRequestException' => [ 'base' => '<p>The batch request contains more entries than permissible.</p>', 'refs' => [], ], 'Topic' => [ 'base' => '<p>A wrapper type for the topic\'s Amazon Resource Name (ARN). To retrieve a topic\'s attributes, use <code>GetTopicAttributes</code>.</p>', 'refs' => [ 'TopicsList$member' => NULL, ], ], 'TopicAttributesMap' => [ 'base' => NULL, 'refs' => [ 'CreateTopicInput$Attributes' => '<p>A map of attributes with their corresponding values.</p> <p>The following lists names, descriptions, and values of the special request parameters that the <code>CreateTopic</code> action uses:</p> <ul> <li> <p> <code>DeliveryPolicy</code> – The policy that defines how Amazon SNS retries failed deliveries to HTTP/S endpoints.</p> </li> <li> <p> <code>DisplayName</code> – The display name to use for a topic with SMS subscriptions.</p> </li> <li> <p> <code>FifoTopic</code> – Set to true to create a FIFO topic.</p> </li> <li> <p> <code>Policy</code> – The policy that defines who can access your topic. By default, only the topic owner can publish or subscribe to the topic.</p> </li> <li> <p> <code>SignatureVersion</code> – The signature version corresponds to the hashing algorithm used while creating the signature of the notifications, subscription confirmations, or unsubscribe confirmation messages sent by Amazon SNS. By default, <code>SignatureVersion</code> is set to <code>1</code>.</p> </li> <li> <p> <code>TracingConfig</code> – Tracing mode of an Amazon SNS topic. By default <code>TracingConfig</code> is set to <code>PassThrough</code>, and the topic passes through the tracing header it receives from an Amazon SNS publisher to its subscriptions. If set to <code>Active</code>, Amazon SNS will vend X-Ray segment data to topic owner account if the sampled flag in the tracing header is true. This is only supported on standard topics.</p> </li> </ul> <p>The following attribute applies only to <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html">server-side encryption</a>:</p> <ul> <li> <p> <code>KmsMasterKeyId</code> – The ID of an Amazon Web Services managed customer master key (CMK) for Amazon SNS or a custom CMK. For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html#sse-key-terms">Key Terms</a>. For more examples, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters">KeyId</a> in the <i>Key Management Service API Reference</i>. </p> </li> </ul> <p>The following attributes apply only to <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-fifo-topics.html">FIFO topics</a>:</p> <ul> <li> <p> <code>ArchivePolicy</code> – Adds or updates an inline policy document to archive messages stored in the specified Amazon SNS topic.</p> </li> <li> <p> <code>BeginningArchiveTime</code> – The earliest starting point at which a message in the topic’s archive can be replayed from. This point in time is based on the configured message retention period set by the topic’s message archiving policy.</p> </li> <li> <p> <code>ContentBasedDeduplication</code> – Enables content-based deduplication for FIFO topics.</p> <ul> <li> <p>By default, <code>ContentBasedDeduplication</code> is set to <code>false</code>. If you create a FIFO topic and this attribute is <code>false</code>, you must specify a value for the <code>MessageDeduplicationId</code> parameter for the <a href="https://docs.aws.amazon.com/sns/latest/api/API_Publish.html">Publish</a> action. </p> </li> <li> <p>When you set <code>ContentBasedDeduplication</code> to <code>true</code>, Amazon SNS uses a SHA-256 hash to generate the <code>MessageDeduplicationId</code> using the body of the message (but not the attributes of the message).</p> <p>(Optional) To override the generated value, you can specify a value for the <code>MessageDeduplicationId</code> parameter for the <code>Publish</code> action.</p> </li> </ul> </li> </ul>', 'GetTopicAttributesResponse$Attributes' => '<p>A map of the topic\'s attributes. Attributes in this map include the following:</p> <ul> <li> <p> <code>DeliveryPolicy</code> – The JSON serialization of the topic\'s delivery policy.</p> </li> <li> <p> <code>DisplayName</code> – The human-readable name used in the <code>From</code> field for notifications to <code>email</code> and <code>email-json</code> endpoints.</p> </li> <li> <p> <code>EffectiveDeliveryPolicy</code> – The JSON serialization of the effective delivery policy, taking system defaults into account.</p> </li> <li> <p> <code>Owner</code> – The Amazon Web Services account ID of the topic\'s owner.</p> </li> <li> <p> <code>Policy</code> – The JSON serialization of the topic\'s access control policy.</p> </li> <li> <p> <code>SignatureVersion</code> – The signature version corresponds to the hashing algorithm used while creating the signature of the notifications, subscription confirmations, or unsubscribe confirmation messages sent by Amazon SNS.</p> <ul> <li> <p>By default, <code>SignatureVersion</code> is set to <b>1</b>. The signature is a Base64-encoded <b>SHA1withRSA</b> signature.</p> </li> <li> <p>When you set <code>SignatureVersion</code> to <b>2</b>. Amazon SNS uses a Base64-encoded <b>SHA256withRSA</b> signature. </p> <note> <p>If the API response does not include the <code>SignatureVersion</code> attribute, it means that the <code>SignatureVersion</code> for the topic has value <b>1</b>.</p> </note> </li> </ul> </li> <li> <p> <code>SubscriptionsConfirmed</code> – The number of confirmed subscriptions for the topic.</p> </li> <li> <p> <code>SubscriptionsDeleted</code> – The number of deleted subscriptions for the topic.</p> </li> <li> <p> <code>SubscriptionsPending</code> – The number of subscriptions pending confirmation for the topic.</p> </li> <li> <p> <code>TopicArn</code> – The topic\'s ARN.</p> </li> <li> <p> <code>TracingConfig</code> – Tracing mode of an Amazon SNS topic. By default <code>TracingConfig</code> is set to <code>PassThrough</code>, and the topic passes through the tracing header it receives from an Amazon SNS publisher to its subscriptions. If set to <code>Active</code>, Amazon SNS will vend X-Ray segment data to topic owner account if the sampled flag in the tracing header is true. This is only supported on standard topics.</p> </li> </ul> <p>The following attribute applies only to <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html">server-side-encryption</a>:</p> <ul> <li> <p> <code>KmsMasterKeyId</code> - The ID of an Amazon Web Services managed customer master key (CMK) for Amazon SNS or a custom CMK. For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html#sse-key-terms">Key Terms</a>. For more examples, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters">KeyId</a> in the <i>Key Management Service API Reference</i>.</p> </li> </ul> <p>The following attributes apply only to <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-fifo-topics.html">FIFO topics</a>:</p> <ul> <li> <p> <code>FifoTopic</code> – When this is set to <code>true</code>, a FIFO topic is created.</p> </li> <li> <p> <code>ContentBasedDeduplication</code> – Enables content-based deduplication for FIFO topics.</p> <ul> <li> <p>By default, <code>ContentBasedDeduplication</code> is set to <code>false</code>. If you create a FIFO topic and this attribute is <code>false</code>, you must specify a value for the <code>MessageDeduplicationId</code> parameter for the <a href="https://docs.aws.amazon.com/sns/latest/api/API_Publish.html">Publish</a> action. </p> </li> <li> <p>When you set <code>ContentBasedDeduplication</code> to <code>true</code>, Amazon SNS uses a SHA-256 hash to generate the <code>MessageDeduplicationId</code> using the body of the message (but not the attributes of the message).</p> <p>(Optional) To override the generated value, you can specify a value for the <code>MessageDeduplicationId</code> parameter for the <code>Publish</code> action.</p> </li> </ul> </li> </ul>', ], ], 'TopicLimitExceededException' => [ 'base' => '<p>Indicates that the customer already owns the maximum allowed number of topics.</p>', 'refs' => [], ], 'TopicsList' => [ 'base' => NULL, 'refs' => [ 'ListTopicsResponse$Topics' => '<p>A list of topic ARNs.</p>', ], ], 'UnsubscribeInput' => [ 'base' => '<p>Input for Unsubscribe action.</p>', 'refs' => [], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UserErrorException' => [ 'base' => '<p>Indicates that a request parameter does not comply with the associated constraints.</p>', 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>Indicates that a parameter in the request is invalid.</p>', 'refs' => [], ], 'VerificationException' => [ 'base' => '<p>Indicates that the one-time password (OTP) used for verification is invalid.</p>', 'refs' => [], ], 'VerifySMSSandboxPhoneNumberInput' => [ 'base' => NULL, 'refs' => [], ], 'VerifySMSSandboxPhoneNumberResult' => [ 'base' => '<p>The destination phone number\'s verification status.</p>', 'refs' => [], ], 'account' => [ 'base' => NULL, 'refs' => [ 'Subscription$Owner' => '<p>The subscription\'s owner.</p>', ], ], 'action' => [ 'base' => NULL, 'refs' => [ 'ActionsList$member' => NULL, ], ], 'attributeName' => [ 'base' => NULL, 'refs' => [ 'SetSubscriptionAttributesInput$AttributeName' => '<p>A map of attributes with their corresponding values.</p> <p>The following lists the names, descriptions, and values of the special request parameters that this action uses:</p> <ul> <li> <p> <code>DeliveryPolicy</code> – The policy that defines how Amazon SNS retries failed deliveries to HTTP/S endpoints.</p> </li> <li> <p> <code>FilterPolicy</code> – The simple JSON object that lets your subscriber receive only a subset of messages, rather than receiving every message published to the topic.</p> </li> <li> <p> <code>FilterPolicyScope</code> – This attribute lets you choose the filtering scope by using one of the following string value types:</p> <ul> <li> <p> <code>MessageAttributes</code> (default) – The filter is applied on the message attributes.</p> </li> <li> <p> <code>MessageBody</code> – The filter is applied on the message body.</p> </li> </ul> </li> <li> <p> <code>RawMessageDelivery</code> – When set to <code>true</code>, enables raw message delivery to Amazon SQS or HTTP/S endpoints. This eliminates the need for the endpoints to process JSON formatting, which is otherwise created for Amazon SNS metadata.</p> </li> <li> <p> <code>RedrivePolicy</code> – When specified, sends undeliverable messages to the specified Amazon SQS dead-letter queue. Messages that can\'t be delivered due to client errors (for example, when the subscribed endpoint is unreachable) or server errors (for example, when the service that powers the subscribed endpoint becomes unavailable) are held in the dead-letter queue for further analysis or reprocessing.</p> </li> </ul> <p>The following attribute applies only to Amazon Data Firehose delivery stream subscriptions:</p> <ul> <li> <p> <code>SubscriptionRoleArn</code> – The ARN of the IAM role that has the following:</p> <ul> <li> <p>Permission to write to the Firehose delivery stream</p> </li> <li> <p>Amazon SNS listed as a trusted entity</p> </li> </ul> <p>Specifying a valid ARN for this attribute is required for Firehose delivery stream subscriptions. For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-firehose-as-subscriber.html">Fanout to Firehose delivery streams</a> in the <i>Amazon SNS Developer Guide</i>.</p> </li> </ul>', 'SetTopicAttributesInput$AttributeName' => '<p>A map of attributes with their corresponding values.</p> <p>The following lists the names, descriptions, and values of the special request parameters that the <code>SetTopicAttributes</code> action uses:</p> <ul> <li> <p> <code>ApplicationSuccessFeedbackRoleArn</code> – Indicates failed message delivery status for an Amazon SNS topic that is subscribed to a platform application endpoint.</p> </li> <li> <p> <code>DeliveryPolicy</code> – The policy that defines how Amazon SNS retries failed deliveries to HTTP/S endpoints.</p> </li> <li> <p> <code>DisplayName</code> – The display name to use for a topic with SMS subscriptions.</p> </li> <li> <p> <code>Policy</code> – The policy that defines who can access your topic. By default, only the topic owner can publish or subscribe to the topic.</p> </li> <li> <p> <code>TracingConfig</code> – Tracing mode of an Amazon SNS topic. By default <code>TracingConfig</code> is set to <code>PassThrough</code>, and the topic passes through the tracing header it receives from an Amazon SNS publisher to its subscriptions. If set to <code>Active</code>, Amazon SNS will vend X-Ray segment data to topic owner account if the sampled flag in the tracing header is true. This is only supported on standard topics.</p> </li> <li> <p>HTTP</p> <ul> <li> <p> <code>HTTPSuccessFeedbackRoleArn</code> – Indicates successful message delivery status for an Amazon SNS topic that is subscribed to an HTTP endpoint. </p> </li> <li> <p> <code>HTTPSuccessFeedbackSampleRate</code> – Indicates percentage of successful messages to sample for an Amazon SNS topic that is subscribed to an HTTP endpoint.</p> </li> <li> <p> <code>HTTPFailureFeedbackRoleArn</code> – Indicates failed message delivery status for an Amazon SNS topic that is subscribed to an HTTP endpoint.</p> </li> </ul> </li> <li> <p>Amazon Kinesis Data Firehose</p> <ul> <li> <p> <code>FirehoseSuccessFeedbackRoleArn</code> – Indicates successful message delivery status for an Amazon SNS topic that is subscribed to an Amazon Kinesis Data Firehose endpoint.</p> </li> <li> <p> <code>FirehoseSuccessFeedbackSampleRate</code> – Indicates percentage of successful messages to sample for an Amazon SNS topic that is subscribed to an Amazon Kinesis Data Firehose endpoint.</p> </li> <li> <p> <code>FirehoseFailureFeedbackRoleArn</code> – Indicates failed message delivery status for an Amazon SNS topic that is subscribed to an Amazon Kinesis Data Firehose endpoint. </p> </li> </ul> </li> <li> <p>Lambda</p> <ul> <li> <p> <code>LambdaSuccessFeedbackRoleArn</code> – Indicates successful message delivery status for an Amazon SNS topic that is subscribed to an Lambda endpoint.</p> </li> <li> <p> <code>LambdaSuccessFeedbackSampleRate</code> – Indicates percentage of successful messages to sample for an Amazon SNS topic that is subscribed to an Lambda endpoint.</p> </li> <li> <p> <code>LambdaFailureFeedbackRoleArn</code> – Indicates failed message delivery status for an Amazon SNS topic that is subscribed to an Lambda endpoint. </p> </li> </ul> </li> <li> <p>Platform application endpoint</p> <ul> <li> <p> <code>ApplicationSuccessFeedbackRoleArn</code> – Indicates successful message delivery status for an Amazon SNS topic that is subscribed to an Amazon Web Services application endpoint.</p> </li> <li> <p> <code>ApplicationSuccessFeedbackSampleRate</code> – Indicates percentage of successful messages to sample for an Amazon SNS topic that is subscribed to an Amazon Web Services application endpoint.</p> </li> <li> <p> <code>ApplicationFailureFeedbackRoleArn</code> – Indicates failed message delivery status for an Amazon SNS topic that is subscribed to an Amazon Web Services application endpoint.</p> </li> </ul> <note> <p>In addition to being able to configure topic attributes for message delivery status of notification messages sent to Amazon SNS application endpoints, you can also configure application attributes for the delivery status of push notification messages sent to push notification services.</p> <p>For example, For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-msg-status.html">Using Amazon SNS Application Attributes for Message Delivery Status</a>. </p> </note> </li> <li> <p>Amazon SQS</p> <ul> <li> <p> <code>SQSSuccessFeedbackRoleArn</code> – Indicates successful message delivery status for an Amazon SNS topic that is subscribed to an Amazon SQS endpoint. </p> </li> <li> <p> <code>SQSSuccessFeedbackSampleRate</code> – Indicates percentage of successful messages to sample for an Amazon SNS topic that is subscribed to an Amazon SQS endpoint. </p> </li> <li> <p> <code>SQSFailureFeedbackRoleArn</code> – Indicates failed message delivery status for an Amazon SNS topic that is subscribed to an Amazon SQS endpoint. </p> </li> </ul> </li> </ul> <note> <p>The &lt;ENDPOINT&gt;SuccessFeedbackRoleArn and &lt;ENDPOINT&gt;FailureFeedbackRoleArn attributes are used to give Amazon SNS write access to use CloudWatch Logs on your behalf. The &lt;ENDPOINT&gt;SuccessFeedbackSampleRate attribute is for specifying the sample rate percentage (0-100) of successfully delivered messages. After you configure the &lt;ENDPOINT&gt;FailureFeedbackRoleArn attribute, then all failed message deliveries generate CloudWatch Logs. </p> </note> <p>The following attribute applies only to <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html">server-side-encryption</a>:</p> <ul> <li> <p> <code>KmsMasterKeyId</code> – The ID of an Amazon Web Services managed customer master key (CMK) for Amazon SNS or a custom CMK. For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html#sse-key-terms">Key Terms</a>. For more examples, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters">KeyId</a> in the <i>Key Management Service API Reference</i>. </p> </li> <li> <p> <code>SignatureVersion</code> – The signature version corresponds to the hashing algorithm used while creating the signature of the notifications, subscription confirmations, or unsubscribe confirmation messages sent by Amazon SNS. By default, <code>SignatureVersion</code> is set to <code>1</code>.</p> </li> </ul> <p>The following attribute applies only to <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-fifo-topics.html">FIFO topics</a>:</p> <ul> <li> <p> <code>ContentBasedDeduplication</code> – Enables content-based deduplication for FIFO topics.</p> <ul> <li> <p>By default, <code>ContentBasedDeduplication</code> is set to <code>false</code>. If you create a FIFO topic and this attribute is <code>false</code>, you must specify a value for the <code>MessageDeduplicationId</code> parameter for the <a href="https://docs.aws.amazon.com/sns/latest/api/API_Publish.html">Publish</a> action. </p> </li> <li> <p>When you set <code>ContentBasedDeduplication</code> to <code>true</code>, Amazon SNS uses a SHA-256 hash to generate the <code>MessageDeduplicationId</code> using the body of the message (but not the attributes of the message).</p> <p>(Optional) To override the generated value, you can specify a value for the <code>MessageDeduplicationId</code> parameter for the <code>Publish</code> action.</p> </li> </ul> </li> </ul>', 'SubscriptionAttributesMap$key' => NULL, 'TopicAttributesMap$key' => NULL, ], ], 'attributeValue' => [ 'base' => NULL, 'refs' => [ 'CreateTopicInput$DataProtectionPolicy' => '<p>The body of the policy document you want to use for this topic.</p> <p>You can only add one policy per topic.</p> <p>The policy must be in JSON string format.</p> <p>Length Constraints: Maximum length of 30,720.</p>', 'GetDataProtectionPolicyResponse$DataProtectionPolicy' => '<p>Retrieves the <code>DataProtectionPolicy</code> in JSON string format.</p>', 'PutDataProtectionPolicyInput$DataProtectionPolicy' => '<p>The JSON serialization of the topic\'s <code>DataProtectionPolicy</code>.</p> <p>The <code>DataProtectionPolicy</code> must be in JSON string format.</p> <p>Length Constraints: Maximum length of 30,720.</p>', 'SetSubscriptionAttributesInput$AttributeValue' => '<p>The new value for the attribute in JSON format.</p>', 'SetTopicAttributesInput$AttributeValue' => '<p>The new value for the attribute.</p>', 'SubscriptionAttributesMap$value' => NULL, 'TopicAttributesMap$value' => NULL, ], ], 'authenticateOnUnsubscribe' => [ 'base' => NULL, 'refs' => [ 'ConfirmSubscriptionInput$AuthenticateOnUnsubscribe' => '<p>Disallows unauthenticated unsubscribes of the subscription. If the value of this parameter is <code>true</code> and the request has an Amazon Web Services signature, then only the topic owner and the subscription owner can unsubscribe the endpoint. The unsubscribe action requires Amazon Web Services authentication. </p>', ], ], 'boolean' => [ 'base' => NULL, 'refs' => [ 'BatchResultErrorEntry$SenderFault' => '<p>Specifies whether the error happened due to the caller of the batch API action.</p>', 'CheckIfPhoneNumberIsOptedOutResponse$isOptedOut' => '<p>Indicates whether the phone number is opted out:</p> <ul> <li> <p> <code>true</code> – The phone number is opted out, meaning you cannot publish SMS messages to it.</p> </li> <li> <p> <code>false</code> – The phone number is opted in, meaning you can publish SMS messages to it.</p> </li> </ul>', 'GetSMSSandboxAccountStatusResult$IsInSandbox' => '<p>Indicates whether the calling Amazon Web Services account is in the SMS sandbox.</p>', 'SubscribeInput$ReturnSubscriptionArn' => '<p>Sets whether the response from the <code>Subscribe</code> request includes the subscription ARN, even if the subscription is not yet confirmed.</p> <p>If you set this parameter to <code>true</code>, the response includes the ARN in all cases, even if the subscription is not yet confirmed. In addition to the ARN for confirmed subscriptions, the response also includes the <code>pending subscription</code> ARN value for subscriptions that aren\'t yet confirmed. A subscription becomes confirmed when the subscriber calls the <code>ConfirmSubscription</code> action with a confirmation token.</p> <p/> <p>The default value is <code>false</code>.</p>', ], ], 'delegate' => [ 'base' => NULL, 'refs' => [ 'DelegatesList$member' => NULL, ], ], 'endpoint' => [ 'base' => NULL, 'refs' => [ 'SubscribeInput$Endpoint' => '<p>The endpoint that you want to receive notifications. Endpoints vary by protocol:</p> <ul> <li> <p>For the <code>http</code> protocol, the (public) endpoint is a URL beginning with <code>http://</code>.</p> </li> <li> <p>For the <code>https</code> protocol, the (public) endpoint is a URL beginning with <code>https://</code>.</p> </li> <li> <p>For the <code>email</code> protocol, the endpoint is an email address.</p> </li> <li> <p>For the <code>email-json</code> protocol, the endpoint is an email address.</p> </li> <li> <p>For the <code>sms</code> protocol, the endpoint is a phone number of an SMS-enabled device.</p> </li> <li> <p>For the <code>sqs</code> protocol, the endpoint is the ARN of an Amazon SQS queue.</p> </li> <li> <p>For the <code>application</code> protocol, the endpoint is the EndpointArn of a mobile app and device.</p> </li> <li> <p>For the <code>lambda</code> protocol, the endpoint is the ARN of an Lambda function.</p> </li> <li> <p>For the <code>firehose</code> protocol, the endpoint is the ARN of an Amazon Kinesis Data Firehose delivery stream.</p> </li> </ul>', 'Subscription$Endpoint' => '<p>The subscription\'s endpoint (format depends on the protocol).</p>', ], ], 'label' => [ 'base' => NULL, 'refs' => [ 'AddPermissionInput$Label' => '<p>A unique identifier for the new policy statement.</p>', 'RemovePermissionInput$Label' => '<p>The unique label of the statement you want to remove.</p>', ], ], 'message' => [ 'base' => NULL, 'refs' => [ 'PublishBatchRequestEntry$Message' => '<p>The body of the message.</p>', 'PublishInput$Message' => '<p>The message you want to send.</p> <p>If you are publishing to a topic and you want to send the same message to all transport protocols, include the text of the message as a String value. If you want to send different messages for each transport protocol, set the value of the <code>MessageStructure</code> parameter to <code>json</code> and use a JSON object for the <code>Message</code> parameter. </p> <p/> <p>Constraints:</p> <ul> <li> <p>With the exception of SMS, messages must be UTF-8 encoded strings and at most 256 KB in size (262,144 bytes, not 262,144 characters).</p> </li> <li> <p>For SMS, each message can contain up to 140 characters. This character limit depends on the encoding schema. For example, an SMS message can contain 160 GSM characters, 140 ASCII characters, or 70 UCS-2 characters.</p> <p>If you publish a message that exceeds this size limit, Amazon SNS sends the message as multiple messages, each fitting within the size limit. Messages aren\'t truncated mid-word but are cut off at whole-word boundaries.</p> <p>The total size limit for a single SMS <code>Publish</code> action is 1,600 characters.</p> </li> </ul> <p>JSON-specific constraints:</p> <ul> <li> <p>Keys in the JSON object that correspond to supported transport protocols must have simple JSON string values.</p> </li> <li> <p>The values will be parsed (unescaped) before they are used in outgoing messages.</p> </li> <li> <p>Outbound notifications are JSON encoded (meaning that the characters will be reescaped for sending).</p> </li> <li> <p>Values have a minimum length of 0 (the empty string, "", is allowed).</p> </li> <li> <p>Values have a maximum length bounded by the overall message size (so, including multiple protocols may limit message sizes).</p> </li> <li> <p>Non-string values will cause the key to be ignored.</p> </li> <li> <p>Keys that do not correspond to supported transport protocols are ignored.</p> </li> <li> <p>Duplicate keys are not allowed.</p> </li> <li> <p>Failure to parse or validate any key or value in the message will cause the <code>Publish</code> call to return an error (no partial delivery).</p> </li> </ul>', ], ], 'messageId' => [ 'base' => NULL, 'refs' => [ 'PublishBatchResultEntry$MessageId' => '<p>An identifier for the message.</p>', 'PublishResponse$MessageId' => '<p>Unique identifier assigned to the published message.</p> <p>Length Constraint: Maximum 100 characters</p>', ], ], 'messageStructure' => [ 'base' => NULL, 'refs' => [ 'PublishBatchRequestEntry$MessageStructure' => '<p>Set <code>MessageStructure</code> to <code>json</code> if you want to send a different message for each protocol. For example, using one publish action, you can send a short message to your SMS subscribers and a longer message to your email subscribers. If you set <code>MessageStructure</code> to <code>json</code>, the value of the <code>Message</code> parameter must: </p> <ul> <li> <p>be a syntactically valid JSON object; and</p> </li> <li> <p>contain at least a top-level JSON key of "default" with a value that is a string.</p> </li> </ul> <p>You can define other top-level keys that define the message you want to send to a specific transport protocol (e.g. http). </p>', 'PublishInput$MessageStructure' => '<p>Set <code>MessageStructure</code> to <code>json</code> if you want to send a different message for each protocol. For example, using one publish action, you can send a short message to your SMS subscribers and a longer message to your email subscribers. If you set <code>MessageStructure</code> to <code>json</code>, the value of the <code>Message</code> parameter must: </p> <ul> <li> <p>be a syntactically valid JSON object; and</p> </li> <li> <p>contain at least a top-level JSON key of "default" with a value that is a string.</p> </li> </ul> <p>You can define other top-level keys that define the message you want to send to a specific transport protocol (e.g., "http").</p> <p>Valid value: <code>json</code> </p>', ], ], 'nextToken' => [ 'base' => NULL, 'refs' => [ 'ListOriginationNumbersRequest$NextToken' => '<p>Token that the previous <code>ListOriginationNumbers</code> request returns.</p>', 'ListOriginationNumbersResult$NextToken' => '<p>A <code>NextToken</code> string is returned when you call the <code>ListOriginationNumbers</code> operation if additional pages of records are available.</p>', 'ListSMSSandboxPhoneNumbersInput$NextToken' => '<p>Token that the previous <code>ListSMSSandboxPhoneNumbersInput</code> request returns.</p>', 'ListSubscriptionsByTopicInput$NextToken' => '<p>Token returned by the previous <code>ListSubscriptionsByTopic</code> request.</p>', 'ListSubscriptionsByTopicResponse$NextToken' => '<p>Token to pass along to the next <code>ListSubscriptionsByTopic</code> request. This element is returned if there are more subscriptions to retrieve.</p>', 'ListSubscriptionsInput$NextToken' => '<p>Token returned by the previous <code>ListSubscriptions</code> request.</p>', 'ListSubscriptionsResponse$NextToken' => '<p>Token to pass along to the next <code>ListSubscriptions</code> request. This element is returned if there are more subscriptions to retrieve.</p>', 'ListTopicsInput$NextToken' => '<p>Token returned by the previous <code>ListTopics</code> request.</p>', 'ListTopicsResponse$NextToken' => '<p>Token to pass along to the next <code>ListTopics</code> request. This element is returned if there are additional topics to retrieve.</p>', ], ], 'protocol' => [ 'base' => NULL, 'refs' => [ 'SubscribeInput$Protocol' => '<p>The protocol that you want to use. Supported protocols include:</p> <ul> <li> <p> <code>http</code> – delivery of JSON-encoded message via HTTP POST</p> </li> <li> <p> <code>https</code> – delivery of JSON-encoded message via HTTPS POST</p> </li> <li> <p> <code>email</code> – delivery of message via SMTP</p> </li> <li> <p> <code>email-json</code> – delivery of JSON-encoded message via SMTP</p> </li> <li> <p> <code>sms</code> – delivery of message via SMS</p> </li> <li> <p> <code>sqs</code> – delivery of JSON-encoded message to an Amazon SQS queue</p> </li> <li> <p> <code>application</code> – delivery of JSON-encoded message to an EndpointArn for a mobile app and device</p> </li> <li> <p> <code>lambda</code> – delivery of JSON-encoded message to an Lambda function</p> </li> <li> <p> <code>firehose</code> – delivery of JSON-encoded message to an Amazon Kinesis Data Firehose delivery stream.</p> </li> </ul>', 'Subscription$Protocol' => '<p>The subscription\'s protocol.</p>', ], ], 'string' => [ 'base' => NULL, 'refs' => [ 'AuthorizationErrorException$message' => NULL, 'BatchEntryIdsNotDistinctException$message' => NULL, 'BatchRequestTooLongException$message' => NULL, 'ConcurrentAccessException$message' => NULL, 'EmptyBatchRequestException$message' => NULL, 'EndpointDisabledException$message' => '<p>Message for endpoint disabled.</p>', 'FilterPolicyLimitExceededException$message' => NULL, 'InternalErrorException$message' => NULL, 'InvalidBatchEntryIdException$message' => NULL, 'InvalidParameterException$message' => NULL, 'InvalidParameterValueException$message' => '<p>The parameter of an entry in a request doesn\'t abide by the specification. </p>', 'InvalidSecurityException$message' => NULL, 'InvalidStateException$message' => NULL, 'KMSAccessDeniedException$message' => NULL, 'KMSDisabledException$message' => NULL, 'KMSInvalidStateException$message' => NULL, 'KMSNotFoundException$message' => NULL, 'KMSOptInRequired$message' => NULL, 'KMSThrottlingException$message' => NULL, 'ListPhoneNumbersOptedOutInput$nextToken' => '<p>A <code>NextToken</code> string is used when you call the <code>ListPhoneNumbersOptedOut</code> action to retrieve additional records that are available after the first page of results.</p>', 'ListPhoneNumbersOptedOutResponse$nextToken' => '<p>A <code>NextToken</code> string is returned when you call the <code>ListPhoneNumbersOptedOut</code> action if additional records are available after the first page of results.</p>', 'ListSMSSandboxPhoneNumbersResult$NextToken' => '<p>A <code>NextToken</code> string is returned when you call the <code>ListSMSSandboxPhoneNumbersInput</code> operation if additional pages of records are available.</p>', 'NotFoundException$message' => NULL, 'OptedOutException$message' => NULL, 'PlatformApplicationDisabledException$message' => '<p>Message for platform application disabled.</p>', 'ReplayLimitExceededException$message' => NULL, 'ResourceNotFoundException$message' => NULL, 'StaleTagException$message' => NULL, 'SubscriptionLimitExceededException$message' => NULL, 'TagLimitExceededException$message' => NULL, 'TagPolicyException$message' => NULL, 'ThrottledException$message' => '<p>Throttled request.</p>', 'TooManyEntriesInBatchRequestException$message' => NULL, 'TopicLimitExceededException$message' => NULL, 'UserErrorException$message' => NULL, 'ValidationException$Message' => NULL, 'VerificationException$Message' => NULL, 'VerificationException$Status' => '<p>The status of the verification error.</p>', ], ], 'subject' => [ 'base' => NULL, 'refs' => [ 'PublishBatchRequestEntry$Subject' => '<p>The subject of the batch message.</p>', 'PublishInput$Subject' => '<p>Optional parameter to be used as the "Subject" line when the message is delivered to email endpoints. This field will also be included, if present, in the standard JSON messages delivered to other endpoints.</p> <p>Constraints: Subjects must be UTF-8 text with no line breaks or control characters, and less than 100 characters long.</p>', ], ], 'subscriptionARN' => [ 'base' => NULL, 'refs' => [ 'ConfirmSubscriptionResponse$SubscriptionArn' => '<p>The ARN of the created subscription.</p>', 'GetSubscriptionAttributesInput$SubscriptionArn' => '<p>The ARN of the subscription whose properties you want to get.</p>', 'SetSubscriptionAttributesInput$SubscriptionArn' => '<p>The ARN of the subscription to modify.</p>', 'SubscribeResponse$SubscriptionArn' => '<p>The ARN of the subscription if it is confirmed, or the string "pending confirmation" if the subscription requires confirmation. However, if the API request parameter <code>ReturnSubscriptionArn</code> is true, then the value is always the subscription ARN, even if the subscription requires confirmation.</p>', 'Subscription$SubscriptionArn' => '<p>The subscription\'s ARN.</p>', 'UnsubscribeInput$SubscriptionArn' => '<p>The ARN of the subscription to be deleted.</p>', ], ], 'token' => [ 'base' => NULL, 'refs' => [ 'ConfirmSubscriptionInput$Token' => '<p>Short-lived token sent to an endpoint during the <code>Subscribe</code> action.</p>', ], ], 'topicARN' => [ 'base' => NULL, 'refs' => [ 'AddPermissionInput$TopicArn' => '<p>The ARN of the topic whose access control policy you wish to modify.</p>', 'ConfirmSubscriptionInput$TopicArn' => '<p>The ARN of the topic for which you wish to confirm a subscription.</p>', 'CreateTopicResponse$TopicArn' => '<p>The Amazon Resource Name (ARN) assigned to the created topic.</p>', 'DeleteTopicInput$TopicArn' => '<p>The ARN of the topic you want to delete.</p>', 'GetDataProtectionPolicyInput$ResourceArn' => '<p>The ARN of the topic whose <code>DataProtectionPolicy</code> you want to get.</p> <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the Amazon Web Services General Reference.</p>', 'GetTopicAttributesInput$TopicArn' => '<p>The ARN of the topic whose properties you want to get.</p>', 'ListSubscriptionsByTopicInput$TopicArn' => '<p>The ARN of the topic for which you wish to find subscriptions.</p>', 'PublishBatchInput$TopicArn' => '<p>The Amazon resource name (ARN) of the topic you want to batch publish to.</p>', 'PublishInput$TopicArn' => '<p>The topic you want to publish to.</p> <p>If you don\'t specify a value for the <code>TopicArn</code> parameter, you must specify a value for the <code>PhoneNumber</code> or <code>TargetArn</code> parameters.</p>', 'PutDataProtectionPolicyInput$ResourceArn' => '<p>The ARN of the topic whose <code>DataProtectionPolicy</code> you want to add or update.</p> <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the Amazon Web Services General Reference.</p>', 'RemovePermissionInput$TopicArn' => '<p>The ARN of the topic whose access control policy you wish to modify.</p>', 'SetTopicAttributesInput$TopicArn' => '<p>The ARN of the topic to modify.</p>', 'SubscribeInput$TopicArn' => '<p>The ARN of the topic you want to subscribe to.</p>', 'Subscription$TopicArn' => '<p>The ARN of the subscription\'s topic.</p>', 'Topic$TopicArn' => '<p>The topic\'s ARN.</p>', ], ], 'topicName' => [ 'base' => NULL, 'refs' => [ 'CreateTopicInput$Name' => '<p>The name of the topic you want to create.</p> <p>Constraints: Topic names must be made up of only uppercase and lowercase ASCII letters, numbers, underscores, and hyphens, and must be between 1 and 256 characters long.</p> <p>For a FIFO (first-in-first-out) topic, the name must end with the <code>.fifo</code> suffix. </p>', ], ], ],];
