<?php
// This file was auto-generated from sdk-root/src/data/sso-admin/2020-07-20/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>IAM Identity Center (successor to Single Sign-On) helps you securely create, or connect, your workforce identities and manage their access centrally across Amazon Web Services accounts and applications. IAM Identity Center is the recommended approach for workforce authentication and authorization in Amazon Web Services, for organizations of any size and type.</p> <note> <p>IAM Identity Center uses the <code>sso</code> and <code>identitystore</code> API namespaces.</p> </note> <p>This reference guide provides information on single sign-on operations which could be used for access management of Amazon Web Services accounts. For information about IAM Identity Center features, see the <a href="https://docs.aws.amazon.com/singlesignon/latest/userguide/what-is.html">IAM Identity Center User Guide</a>.</p> <p>Many operations in the IAM Identity Center APIs rely on identifiers for users and groups, known as principals. For more information about how to work with principals and principal IDs in IAM Identity Center, see the <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/welcome.html">Identity Store API Reference</a>.</p> <note> <p>Amazon Web Services provides SDKs that consist of libraries and sample code for various programming languages and platforms (Java, Ruby, .Net, iOS, Android, and more). The SDKs provide a convenient way to create programmatic access to IAM Identity Center and other Amazon Web Services services. For more information about the Amazon Web Services SDKs, including how to download and install them, see <a href="http://aws.amazon.com/tools/">Tools for Amazon Web Services</a>.</p> </note>', 'operations' => [ 'AttachCustomerManagedPolicyReferenceToPermissionSet' => '<p>Attaches the specified customer managed policy to the specified <a>PermissionSet</a>.</p>', 'AttachManagedPolicyToPermissionSet' => '<p>Attaches an Amazon Web Services managed policy ARN to a permission set.</p> <note> <p>If the permission set is already referenced by one or more account assignments, you will need to call <code> <a>ProvisionPermissionSet</a> </code> after this operation. Calling <code>ProvisionPermissionSet</code> applies the corresponding IAM policy updates to all assigned accounts.</p> </note>', 'CreateAccountAssignment' => '<p>Assigns access to a principal for a specified Amazon Web Services account using a specified permission set.</p> <note> <p>The term <i>principal</i> here refers to a user or group that is defined in IAM Identity Center.</p> </note> <note> <p>As part of a successful <code>CreateAccountAssignment</code> call, the specified permission set will automatically be provisioned to the account in the form of an IAM policy. That policy is attached to the IAM role created in IAM Identity Center. If the permission set is subsequently updated, the corresponding IAM policies attached to roles in your accounts will not be updated automatically. In this case, you must call <code> <a>ProvisionPermissionSet</a> </code> to make these updates.</p> </note> <note> <p> After a successful response, call <code>DescribeAccountAssignmentCreationStatus</code> to describe the status of an assignment creation request. </p> </note>', 'CreateApplication' => '<p>Creates an application in IAM Identity Center for the given application provider.</p>', 'CreateApplicationAssignment' => '<p>Grant application access to a user or group.</p>', 'CreateInstance' => '<p>Creates an instance of IAM Identity Center for a standalone Amazon Web Services account that is not managed by Organizations or a member Amazon Web Services account in an organization. You can create only one instance per account and across all Amazon Web Services Regions.</p> <p>The CreateInstance request is rejected if the following apply: </p> <ul> <li> <p>The instance is created within the organization management account.</p> </li> <li> <p>An instance already exists in the same account.</p> </li> </ul>', 'CreateInstanceAccessControlAttributeConfiguration' => '<p>Enables the attributes-based access control (ABAC) feature for the specified IAM Identity Center instance. You can also specify new attributes to add to your ABAC configuration during the enabling process. For more information about ABAC, see <a href="/singlesignon/latest/userguide/abac.html">Attribute-Based Access Control</a> in the <i>IAM Identity Center User Guide</i>.</p> <note> <p>After a successful response, call <code>DescribeInstanceAccessControlAttributeConfiguration</code> to validate that <code>InstanceAccessControlAttributeConfiguration</code> was created.</p> </note>', 'CreatePermissionSet' => '<p>Creates a permission set within a specified IAM Identity Center instance.</p> <note> <p>To grant users and groups access to Amazon Web Services account resources, use <code> <a>CreateAccountAssignment</a> </code>.</p> </note>', 'CreateTrustedTokenIssuer' => '<p>Creates a connection to a trusted token issuer in an instance of IAM Identity Center. A trusted token issuer enables trusted identity propagation to be used with applications that authenticate outside of Amazon Web Services.</p> <p>This trusted token issuer describes an external identity provider (IdP) that can generate claims or assertions in the form of access tokens for a user. Applications enabled for IAM Identity Center can use these tokens for authentication. </p>', 'DeleteAccountAssignment' => '<p>Deletes a principal\'s access from a specified Amazon Web Services account using a specified permission set.</p> <note> <p>After a successful response, call <code>DescribeAccountAssignmentDeletionStatus</code> to describe the status of an assignment deletion request.</p> </note>', 'DeleteApplication' => '<p>Deletes the association with the application. The connected service resource still exists.</p>', 'DeleteApplicationAccessScope' => '<p>Deletes an IAM Identity Center access scope from an application.</p>', 'DeleteApplicationAssignment' => '<p>Revoke application access to an application by deleting application assignments for a user or group.</p>', 'DeleteApplicationAuthenticationMethod' => '<p>Deletes an authentication method from an application.</p>', 'DeleteApplicationGrant' => '<p>Deletes a grant from an application.</p>', 'DeleteInlinePolicyFromPermissionSet' => '<p>Deletes the inline policy from a specified permission set.</p>', 'DeleteInstance' => '<p>Deletes the instance of IAM Identity Center. Only the account that owns the instance can call this API. Neither the delegated administrator nor member account can delete the organization instance, but those roles can delete their own instance.</p>', 'DeleteInstanceAccessControlAttributeConfiguration' => '<p>Disables the attributes-based access control (ABAC) feature for the specified IAM Identity Center instance and deletes all of the attribute mappings that have been configured. Once deleted, any attributes that are received from an identity source and any custom attributes you have previously configured will not be passed. For more information about ABAC, see <a href="/singlesignon/latest/userguide/abac.html">Attribute-Based Access Control</a> in the <i>IAM Identity Center User Guide</i>.</p>', 'DeletePermissionSet' => '<p>Deletes the specified permission set.</p>', 'DeletePermissionsBoundaryFromPermissionSet' => '<p>Deletes the permissions boundary from a specified <a>PermissionSet</a>.</p>', 'DeleteTrustedTokenIssuer' => '<p>Deletes a trusted token issuer configuration from an instance of IAM Identity Center.</p> <note> <p>Deleting this trusted token issuer configuration will cause users to lose access to any applications that are configured to use the trusted token issuer.</p> </note>', 'DescribeAccountAssignmentCreationStatus' => '<p>Describes the status of the assignment creation request.</p>', 'DescribeAccountAssignmentDeletionStatus' => '<p>Describes the status of the assignment deletion request.</p>', 'DescribeApplication' => '<p>Retrieves the details of an application associated with an instance of IAM Identity Center.</p>', 'DescribeApplicationAssignment' => '<p>Retrieves a direct assignment of a user or group to an application. If the user doesn’t have a direct assignment to the application, the user may still have access to the application through a group. Therefore, don’t use this API to test access to an application for a user. Instead use <a>ListApplicationAssignmentsForPrincipal</a>.</p>', 'DescribeApplicationProvider' => '<p>Retrieves details about a provider that can be used to connect an Amazon Web Services managed application or customer managed application to IAM Identity Center.</p>', 'DescribeInstance' => '<p>Returns the details of an instance of IAM Identity Center. The status can be one of the following:</p> <ul> <li> <p> <code>CREATE_IN_PROGRESS</code> - The instance is in the process of being created. When the instance is ready for use, DescribeInstance returns the status of <code>ACTIVE</code>. While the instance is in the <code>CREATE_IN_PROGRESS</code> state, you can call only DescribeInstance and DeleteInstance operations.</p> </li> <li> <p> <code>DELETE_IN_PROGRESS</code> - The instance is being deleted. Returns <code>AccessDeniedException</code> after the delete operation completes. </p> </li> <li> <p> <code>ACTIVE</code> - The instance is active.</p> </li> </ul>', 'DescribeInstanceAccessControlAttributeConfiguration' => '<p>Returns the list of IAM Identity Center identity store attributes that have been configured to work with attributes-based access control (ABAC) for the specified IAM Identity Center instance. This will not return attributes configured and sent by an external identity provider. For more information about ABAC, see <a href="/singlesignon/latest/userguide/abac.html">Attribute-Based Access Control</a> in the <i>IAM Identity Center User Guide</i>.</p>', 'DescribePermissionSet' => '<p>Gets the details of the permission set.</p>', 'DescribePermissionSetProvisioningStatus' => '<p>Describes the status for the given permission set provisioning request.</p>', 'DescribeTrustedTokenIssuer' => '<p>Retrieves details about a trusted token issuer configuration stored in an instance of IAM Identity Center. Details include the name of the trusted token issuer, the issuer URL, and the path of the source attribute and the destination attribute for a trusted token issuer configuration. </p>', 'DetachCustomerManagedPolicyReferenceFromPermissionSet' => '<p>Detaches the specified customer managed policy from the specified <a>PermissionSet</a>.</p>', 'DetachManagedPolicyFromPermissionSet' => '<p>Detaches the attached Amazon Web Services managed policy ARN from the specified permission set.</p>', 'GetApplicationAccessScope' => '<p>Retrieves the authorized targets for an IAM Identity Center access scope for an application.</p>', 'GetApplicationAssignmentConfiguration' => '<p>Retrieves the configuration of <a>PutApplicationAssignmentConfiguration</a>.</p>', 'GetApplicationAuthenticationMethod' => '<p>Retrieves details about an authentication method used by an application.</p>', 'GetApplicationGrant' => '<p>Retrieves details about an application grant.</p>', 'GetInlinePolicyForPermissionSet' => '<p>Obtains the inline policy assigned to the permission set.</p>', 'GetPermissionsBoundaryForPermissionSet' => '<p>Obtains the permissions boundary for a specified <a>PermissionSet</a>.</p>', 'ListAccountAssignmentCreationStatus' => '<p>Lists the status of the Amazon Web Services account assignment creation requests for a specified IAM Identity Center instance.</p>', 'ListAccountAssignmentDeletionStatus' => '<p>Lists the status of the Amazon Web Services account assignment deletion requests for a specified IAM Identity Center instance.</p>', 'ListAccountAssignments' => '<p>Lists the assignee of the specified Amazon Web Services account with the specified permission set.</p>', 'ListAccountAssignmentsForPrincipal' => '<p>Retrieves a list of the IAM Identity Center associated Amazon Web Services accounts that the principal has access to.</p>', 'ListAccountsForProvisionedPermissionSet' => '<p>Lists all the Amazon Web Services accounts where the specified permission set is provisioned.</p>', 'ListApplicationAccessScopes' => '<p>Lists the access scopes and authorized targets associated with an application.</p>', 'ListApplicationAssignments' => '<p>Lists Amazon Web Services account users that are assigned to an application.</p>', 'ListApplicationAssignmentsForPrincipal' => '<p>Lists the applications to which a specified principal is assigned.</p>', 'ListApplicationAuthenticationMethods' => '<p>Lists all of the authentication methods supported by the specified application.</p>', 'ListApplicationGrants' => '<p>List the grants associated with an application.</p>', 'ListApplicationProviders' => '<p>Lists the application providers configured in the IAM Identity Center identity store.</p>', 'ListApplications' => '<p>Lists all applications associated with the instance of IAM Identity Center. When listing applications for an instance in the management account, member accounts must use the <code>applicationAccount</code> parameter to filter the list to only applications created from that account.</p>', 'ListCustomerManagedPolicyReferencesInPermissionSet' => '<p>Lists all customer managed policies attached to a specified <a>PermissionSet</a>.</p>', 'ListInstances' => '<p>Lists the details of the organization and account instances of IAM Identity Center that were created in or visible to the account calling this API. </p>', 'ListManagedPoliciesInPermissionSet' => '<p>Lists the Amazon Web Services managed policy that is attached to a specified permission set.</p>', 'ListPermissionSetProvisioningStatus' => '<p>Lists the status of the permission set provisioning requests for a specified IAM Identity Center instance.</p>', 'ListPermissionSets' => '<p>Lists the <a>PermissionSet</a>s in an IAM Identity Center instance.</p>', 'ListPermissionSetsProvisionedToAccount' => '<p>Lists all the permission sets that are provisioned to a specified Amazon Web Services account.</p>', 'ListTagsForResource' => '<p>Lists the tags that are attached to a specified resource.</p>', 'ListTrustedTokenIssuers' => '<p>Lists all the trusted token issuers configured in an instance of IAM Identity Center.</p>', 'ProvisionPermissionSet' => '<p>The process by which a specified permission set is provisioned to the specified target.</p>', 'PutApplicationAccessScope' => '<p>Adds or updates the list of authorized targets for an IAM Identity Center access scope for an application.</p>', 'PutApplicationAssignmentConfiguration' => '<p>Configure how users gain access to an application. If <code>AssignmentsRequired</code> is <code>true</code> (default value), users don’t have access to the application unless an assignment is created using the <a href="https://docs.aws.amazon.com/singlesignon/latest/APIReference/API_CreateApplicationAssignment.html">CreateApplicationAssignment API</a>. If <code>false</code>, all users have access to the application. If an assignment is created using <a href="https://docs.aws.amazon.com/singlesignon/latest/APIReference/API_CreateApplicationAssignment.html">CreateApplicationAssignment</a>., the user retains access if <code>AssignmentsRequired</code> is set to <code>true</code>. </p>', 'PutApplicationAuthenticationMethod' => '<p>Adds or updates an authentication method for an application.</p>', 'PutApplicationGrant' => '<p>Adds a grant to an application.</p>', 'PutInlinePolicyToPermissionSet' => '<p>Attaches an inline policy to a permission set.</p> <note> <p>If the permission set is already referenced by one or more account assignments, you will need to call <code> <a>ProvisionPermissionSet</a> </code> after this action to apply the corresponding IAM policy updates to all assigned accounts.</p> </note>', 'PutPermissionsBoundaryToPermissionSet' => '<p>Attaches an Amazon Web Services managed or customer managed policy to the specified <a>PermissionSet</a> as a permissions boundary.</p>', 'TagResource' => '<p>Associates a set of tags with a specified resource.</p>', 'UntagResource' => '<p>Disassociates a set of tags from a specified resource.</p>', 'UpdateApplication' => '<p>Updates application properties. </p>', 'UpdateInstance' => '<p>Update the details for the instance of IAM Identity Center that is owned by the Amazon Web Services account.</p>', 'UpdateInstanceAccessControlAttributeConfiguration' => '<p>Updates the IAM Identity Center identity store attributes that you can use with the IAM Identity Center instance for attributes-based access control (ABAC). When using an external identity provider as an identity source, you can pass attributes through the SAML assertion as an alternative to configuring attributes from the IAM Identity Center identity store. If a SAML assertion passes any of these attributes, IAM Identity Center replaces the attribute value with the value from the IAM Identity Center identity store. For more information about ABAC, see <a href="/singlesignon/latest/userguide/abac.html">Attribute-Based Access Control</a> in the <i>IAM Identity Center User Guide</i>.</p>', 'UpdatePermissionSet' => '<p>Updates an existing permission set.</p>', 'UpdateTrustedTokenIssuer' => '<p>Updates the name of the trusted token issuer, or the path of a source attribute or destination attribute for a trusted token issuer configuration.</p> <note> <p>Updating this trusted token issuer configuration might cause users to lose access to any applications that are configured to use the trusted token issuer.</p> </note>', ], 'shapes' => [ 'AccessControlAttribute' => [ 'base' => '<p>These are IAM Identity Center identity store attributes that you can configure for use in attributes-based access control (ABAC). You can create permissions policies that determine who can access your Amazon Web Services resources based upon the configured attribute values. When you enable ABAC and specify <code>AccessControlAttributes</code>, IAM Identity Center passes the attribute values of the authenticated user into IAM for use in policy evaluation.</p>', 'refs' => [ 'AccessControlAttributeList$member' => NULL, ], ], 'AccessControlAttributeKey' => [ 'base' => NULL, 'refs' => [ 'AccessControlAttribute$Key' => '<p>The name of the attribute associated with your identities in your identity source. This is used to map a specified attribute in your identity source with an attribute in IAM Identity Center.</p>', ], ], 'AccessControlAttributeList' => [ 'base' => NULL, 'refs' => [ 'InstanceAccessControlAttributeConfiguration$AccessControlAttributes' => '<p>Lists the attributes that are configured for ABAC in the specified IAM Identity Center instance.</p>', ], ], 'AccessControlAttributeValue' => [ 'base' => '<p>The value used for mapping a specified attribute to an identity source. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/userguide/attributemappingsconcept.html">Attribute mappings</a> in the <i>IAM Identity Center User Guide</i>.</p>', 'refs' => [ 'AccessControlAttribute$Value' => '<p>The value used for mapping a specified attribute to an identity source.</p>', ], ], 'AccessControlAttributeValueSource' => [ 'base' => NULL, 'refs' => [ 'AccessControlAttributeValueSourceList$member' => NULL, ], ], 'AccessControlAttributeValueSourceList' => [ 'base' => NULL, 'refs' => [ 'AccessControlAttributeValue$Source' => '<p>The identity source to use when mapping a specified attribute to IAM Identity Center.</p>', ], ], 'AccessDeniedException' => [ 'base' => '<p>You do not have sufficient access to perform this action.</p>', 'refs' => [], ], 'AccessDeniedExceptionMessage' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => NULL, ], ], 'AccountAssignment' => [ 'base' => '<p>The assignment that indicates a principal\'s limited access to a specified Amazon Web Services account with a specified permission set.</p> <note> <p>The term <i>principal</i> here refers to a user or group that is defined in IAM Identity Center.</p> </note>', 'refs' => [ 'AccountAssignmentList$member' => NULL, ], ], 'AccountAssignmentForPrincipal' => [ 'base' => '<p>A structure that describes an assignment of an Amazon Web Services account to a principal and the permissions that principal has in the account.</p>', 'refs' => [ 'AccountAssignmentListForPrincipal$member' => NULL, ], ], 'AccountAssignmentList' => [ 'base' => NULL, 'refs' => [ 'ListAccountAssignmentsResponse$AccountAssignments' => '<p>The list of assignments that match the input Amazon Web Services account and permission set.</p>', ], ], 'AccountAssignmentListForPrincipal' => [ 'base' => NULL, 'refs' => [ 'ListAccountAssignmentsForPrincipalResponse$AccountAssignments' => '<p>An array list of the account assignments for the principal.</p>', ], ], 'AccountAssignmentOperationStatus' => [ 'base' => '<p>The status of the creation or deletion operation of an assignment that a principal needs to access an account.</p>', 'refs' => [ 'CreateAccountAssignmentResponse$AccountAssignmentCreationStatus' => '<p>The status object for the account assignment creation operation.</p>', 'DeleteAccountAssignmentResponse$AccountAssignmentDeletionStatus' => '<p>The status object for the account assignment deletion operation.</p>', 'DescribeAccountAssignmentCreationStatusResponse$AccountAssignmentCreationStatus' => '<p>The status object for the account assignment creation operation.</p>', 'DescribeAccountAssignmentDeletionStatusResponse$AccountAssignmentDeletionStatus' => '<p>The status object for the account assignment deletion operation.</p>', ], ], 'AccountAssignmentOperationStatusList' => [ 'base' => NULL, 'refs' => [ 'ListAccountAssignmentCreationStatusResponse$AccountAssignmentsCreationStatus' => '<p>The status object for the account assignment creation operation.</p>', 'ListAccountAssignmentDeletionStatusResponse$AccountAssignmentsDeletionStatus' => '<p>The status object for the account assignment deletion operation.</p>', ], ], 'AccountAssignmentOperationStatusMetadata' => [ 'base' => '<p>Provides information about the <a>AccountAssignment</a> creation request.</p>', 'refs' => [ 'AccountAssignmentOperationStatusList$member' => NULL, ], ], 'AccountId' => [ 'base' => NULL, 'refs' => [ 'AccountAssignment$AccountId' => '<p>The identifier of the Amazon Web Services account.</p>', 'AccountAssignmentForPrincipal$AccountId' => '<p>The account ID number of the Amazon Web Services account.</p>', 'AccountList$member' => NULL, 'Application$ApplicationAccount' => '<p>The Amazon Web Services account ID number of the application.</p>', 'DescribeApplicationResponse$ApplicationAccount' => '<p>The account ID.</p>', 'DescribeInstanceResponse$OwnerAccountId' => '<p>The identifier of the Amazon Web Services account for which the instance was created.</p>', 'InstanceMetadata$OwnerAccountId' => '<p>The Amazon Web Services account ID number of the owner of the Identity Center instance.</p>', 'ListAccountAssignmentsFilter$AccountId' => '<p>The ID number of an Amazon Web Services account that filters the results in the response.</p>', 'ListApplicationsFilter$ApplicationAccount' => '<p>An Amazon Web Services account ID number that filters the results in the response.</p>', 'ListPermissionSetsProvisionedToAccountRequest$AccountId' => '<p>The identifier of the Amazon Web Services account from which to list the assignments.</p>', 'PermissionSetProvisioningStatus$AccountId' => '<p>The identifier of the Amazon Web Services account from which to list the assignments.</p>', ], ], 'AccountList' => [ 'base' => NULL, 'refs' => [ 'ListAccountsForProvisionedPermissionSetResponse$AccountIds' => '<p>The list of Amazon Web Services <code>AccountIds</code>.</p>', ], ], 'ActorPolicyDocument' => [ 'base' => NULL, 'refs' => [ 'IamAuthenticationMethod$ActorPolicy' => '<p>An IAM policy document in JSON.</p>', ], ], 'Application' => [ 'base' => '<p>A structure that describes an application that uses IAM Identity Center for access management.</p>', 'refs' => [ 'ApplicationList$member' => NULL, ], ], 'ApplicationArn' => [ 'base' => NULL, 'refs' => [ 'Application$ApplicationArn' => '<p>The ARN of the application.</p>', 'ApplicationAssignment$ApplicationArn' => '<p>The ARN of the application that has principals assigned.</p>', 'ApplicationAssignmentForPrincipal$ApplicationArn' => '<p>The ARN of the application to which the specified principal is assigned.</p>', 'CreateApplicationAssignmentRequest$ApplicationArn' => '<p>The ARN of the application provider under which the operation will run.</p>', 'CreateApplicationResponse$ApplicationArn' => '<p>Specifies the ARN of the application.</p>', 'DeleteApplicationAccessScopeRequest$ApplicationArn' => '<p>Specifies the ARN of the application with the access scope to delete.</p>', 'DeleteApplicationAssignmentRequest$ApplicationArn' => '<p>Specifies the ARN of the application.</p>', 'DeleteApplicationAuthenticationMethodRequest$ApplicationArn' => '<p>Specifies the ARN of the application with the authentication method to delete.</p>', 'DeleteApplicationGrantRequest$ApplicationArn' => '<p>Specifies the ARN of the application with the grant to delete.</p>', 'DeleteApplicationRequest$ApplicationArn' => '<p>Specifies the ARN of the application. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>. </p>', 'DescribeApplicationAssignmentRequest$ApplicationArn' => '<p>Specifies the ARN of the application. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'DescribeApplicationAssignmentResponse$ApplicationArn' => '<p>Specifies the ARN of the application. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'DescribeApplicationRequest$ApplicationArn' => '<p>Specifies the ARN of the application. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'DescribeApplicationResponse$ApplicationArn' => '<p>Specifies the ARN of the application.</p>', 'GetApplicationAccessScopeRequest$ApplicationArn' => '<p>Specifies the ARN of the application with the access scope that you want to retrieve.</p>', 'GetApplicationAssignmentConfigurationRequest$ApplicationArn' => '<p>Specifies the ARN of the application. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'GetApplicationAuthenticationMethodRequest$ApplicationArn' => '<p>Specifies the ARN of the application.</p>', 'GetApplicationGrantRequest$ApplicationArn' => '<p>Specifies the ARN of the application that contains the grant.</p>', 'ListApplicationAccessScopesRequest$ApplicationArn' => '<p>Specifies the ARN of the application.</p>', 'ListApplicationAssignmentsFilter$ApplicationArn' => '<p>The ARN of an application.</p>', 'ListApplicationAssignmentsRequest$ApplicationArn' => '<p>Specifies the ARN of the application.</p>', 'ListApplicationAuthenticationMethodsRequest$ApplicationArn' => '<p>Specifies the ARN of the application with the authentication methods you want to list.</p>', 'ListApplicationGrantsRequest$ApplicationArn' => '<p>Specifies the ARN of the application whose grants you want to list.</p>', 'PutApplicationAccessScopeRequest$ApplicationArn' => '<p>Specifies the ARN of the application with the access scope with the targets to add or update.</p>', 'PutApplicationAssignmentConfigurationRequest$ApplicationArn' => '<p>Specifies the ARN of the application. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'PutApplicationAuthenticationMethodRequest$ApplicationArn' => '<p>Specifies the ARN of the application with the authentication method to add or update.</p>', 'PutApplicationGrantRequest$ApplicationArn' => '<p>Specifies the ARN of the application to update.</p>', 'UpdateApplicationRequest$ApplicationArn' => '<p>Specifies the ARN of the application. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', ], ], 'ApplicationAssignment' => [ 'base' => '<p>A structure that describes an assignment of a principal to an application.</p>', 'refs' => [ 'ApplicationAssignmentsList$member' => NULL, ], ], 'ApplicationAssignmentForPrincipal' => [ 'base' => '<p>A structure that describes an application to which a principal is assigned.</p>', 'refs' => [ 'ApplicationAssignmentListForPrincipal$member' => NULL, ], ], 'ApplicationAssignmentListForPrincipal' => [ 'base' => NULL, 'refs' => [ 'ListApplicationAssignmentsForPrincipalResponse$ApplicationAssignments' => '<p>An array list of the application assignments for the specified principal.</p>', ], ], 'ApplicationAssignmentsList' => [ 'base' => NULL, 'refs' => [ 'ListApplicationAssignmentsResponse$ApplicationAssignments' => '<p>The list of users assigned to an application.</p>', ], ], 'ApplicationList' => [ 'base' => NULL, 'refs' => [ 'ListApplicationsResponse$Applications' => '<p>Retrieves all applications associated with the instance.</p>', ], ], 'ApplicationProvider' => [ 'base' => '<p>A structure that describes a provider that can be used to connect an Amazon Web Services managed application or customer managed application to IAM Identity Center.</p>', 'refs' => [ 'ApplicationProviderList$member' => NULL, ], ], 'ApplicationProviderArn' => [ 'base' => NULL, 'refs' => [ 'Application$ApplicationProviderArn' => '<p>The ARN of the application provider for this application.</p>', 'ApplicationProvider$ApplicationProviderArn' => '<p>The ARN of the application provider.</p>', 'CreateApplicationRequest$ApplicationProviderArn' => '<p>The ARN of the application provider under which the operation will run.</p>', 'DescribeApplicationProviderRequest$ApplicationProviderArn' => '<p>Specifies the ARN of the application provider for which you want details.</p>', 'DescribeApplicationProviderResponse$ApplicationProviderArn' => '<p>The ARN of the application provider.</p>', 'DescribeApplicationResponse$ApplicationProviderArn' => '<p>The ARN of the application provider under which the operation will run.</p>', 'ListApplicationsFilter$ApplicationProvider' => '<p>The ARN of an application provider that can filter the results in the response.</p>', ], ], 'ApplicationProviderList' => [ 'base' => NULL, 'refs' => [ 'ListApplicationProvidersResponse$ApplicationProviders' => '<p>An array list of structures that describe application providers.</p>', ], ], 'ApplicationStatus' => [ 'base' => NULL, 'refs' => [ 'Application$Status' => '<p>The current status of the application in this instance of IAM Identity Center.</p>', 'CreateApplicationRequest$Status' => '<p>Specifies whether the application is enabled or disabled.</p>', 'DescribeApplicationResponse$Status' => '<p>Specifies whether the application is enabled or disabled.</p>', 'UpdateApplicationRequest$Status' => '<p>Specifies whether the application is enabled or disabled.</p>', ], ], 'ApplicationUrl' => [ 'base' => NULL, 'refs' => [ 'SignInOptions$ApplicationUrl' => '<p>The URL that accepts authentication requests for an application. This is a required parameter if the <code>Origin</code> parameter is <code>APPLICATION</code>.</p>', ], ], 'ApplicationVisibility' => [ 'base' => NULL, 'refs' => [ 'PortalOptions$Visibility' => '<p>Indicates whether this application is visible in the access portal.</p>', ], ], 'AssignmentRequired' => [ 'base' => NULL, 'refs' => [ 'GetApplicationAssignmentConfigurationResponse$AssignmentRequired' => '<p>If <code>AssignmentsRequired</code> is <code>true</code> (default value), users don’t have access to the application unless an assignment is created using the <a href="https://docs.aws.amazon.com/singlesignon/latest/APIReference/API_CreateApplicationAssignment.html">CreateApplicationAssignment API</a>. If <code>false</code>, all users have access to the application. </p>', 'PutApplicationAssignmentConfigurationRequest$AssignmentRequired' => '<p>If <code>AssignmentsRequired</code> is <code>true</code> (default value), users don’t have access to the application unless an assignment is created using the <a href="https://docs.aws.amazon.com/singlesignon/latest/APIReference/API_CreateApplicationAssignment.html">CreateApplicationAssignment API</a>. If <code>false</code>, all users have access to the application. </p>', ], ], 'AttachCustomerManagedPolicyReferenceToPermissionSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'AttachCustomerManagedPolicyReferenceToPermissionSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'AttachManagedPolicyToPermissionSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'AttachManagedPolicyToPermissionSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'AttachedManagedPolicy' => [ 'base' => '<p>A structure that stores the details of the Amazon Web Services managed policy.</p>', 'refs' => [ 'AttachedManagedPolicyList$member' => NULL, ], ], 'AttachedManagedPolicyList' => [ 'base' => NULL, 'refs' => [ 'ListManagedPoliciesInPermissionSetResponse$AttachedManagedPolicies' => '<p>An array of the <a>AttachedManagedPolicy</a> data type object.</p>', ], ], 'AuthenticationMethod' => [ 'base' => '<p>A structure that describes an authentication method that can be used by an application.</p>', 'refs' => [ 'AuthenticationMethodItem$AuthenticationMethod' => '<p>A structure that describes an authentication method. The contents of this structure is determined by the <code>AuthenticationMethodType</code>.</p>', 'GetApplicationAuthenticationMethodResponse$AuthenticationMethod' => '<p>A structure that contains details about the requested authentication method.</p>', 'PutApplicationAuthenticationMethodRequest$AuthenticationMethod' => '<p>Specifies a structure that describes the authentication method to add or update. The structure type you provide is determined by the <code>AuthenticationMethodType</code> parameter.</p>', ], ], 'AuthenticationMethodItem' => [ 'base' => '<p>A structure that describes an authentication method and its type.</p>', 'refs' => [ 'AuthenticationMethods$member' => NULL, ], ], 'AuthenticationMethodType' => [ 'base' => NULL, 'refs' => [ 'AuthenticationMethodItem$AuthenticationMethodType' => '<p>The type of authentication that is used by this method.</p>', 'DeleteApplicationAuthenticationMethodRequest$AuthenticationMethodType' => '<p>Specifies the authentication method type to delete from the application.</p>', 'GetApplicationAuthenticationMethodRequest$AuthenticationMethodType' => '<p>Specifies the type of authentication method for which you want details.</p>', 'PutApplicationAuthenticationMethodRequest$AuthenticationMethodType' => '<p>Specifies the type of the authentication method that you want to add or update.</p>', ], ], 'AuthenticationMethods' => [ 'base' => NULL, 'refs' => [ 'ListApplicationAuthenticationMethodsResponse$AuthenticationMethods' => '<p>An array list of authentication methods for the specified application.</p>', ], ], 'AuthorizationCodeGrant' => [ 'base' => '<p>A structure that defines configuration settings for an application that supports the OAuth 2.0 Authorization Code Grant.</p>', 'refs' => [ 'Grant$AuthorizationCode' => '<p>Configuration options for the <code>authorization_code</code> grant type.</p>', ], ], 'AuthorizedTokenIssuer' => [ 'base' => '<p>A structure that describes a trusted token issuer and associates it with a set of authorized audiences.</p>', 'refs' => [ 'AuthorizedTokenIssuers$member' => NULL, ], ], 'AuthorizedTokenIssuers' => [ 'base' => NULL, 'refs' => [ 'JwtBearerGrant$AuthorizedTokenIssuers' => '<p>A list of allowed token issuers trusted by the Identity Center instances for this application.</p>', ], ], 'ClaimAttributePath' => [ 'base' => NULL, 'refs' => [ 'OidcJwtConfiguration$ClaimAttributePath' => '<p>The path of the source attribute in the JWT from the trusted token issuer. The attribute mapped by this JMESPath expression is compared against the attribute mapped by <code>IdentityStoreAttributePath</code> when a trusted token issuer token is exchanged for an IAM Identity Center token.</p>', 'OidcJwtUpdateConfiguration$ClaimAttributePath' => '<p>The path of the source attribute in the JWT from the trusted token issuer. The attribute mapped by this JMESPath expression is compared against the attribute mapped by <code>IdentityStoreAttributePath</code> when a trusted token issuer token is exchanged for an IAM Identity Center token.</p>', ], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'CreateApplicationRequest$ClientToken' => '<p>Specifies a unique, case-sensitive ID that you provide to ensure the idempotency of the request. This lets you safely retry the request without accidentally performing the same operation a second time. Passing the same value to a later call to an operation requires that you also pass the same value for all other parameters. We recommend that you use a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value</a>.</p> <p>If you don\'t provide this value, then Amazon Web Services generates a random one for you.</p> <p>If you retry the operation with the same <code>ClientToken</code>, but with different parameters, the retry fails with an <code>IdempotentParameterMismatch</code> error.</p>', 'CreateInstanceRequest$ClientToken' => '<p>Specifies a unique, case-sensitive ID that you provide to ensure the idempotency of the request. This lets you safely retry the request without accidentally performing the same operation a second time. Passing the same value to a later call to an operation requires that you also pass the same value for all other parameters. We recommend that you use a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value</a>.</p> <p>If you don\'t provide this value, then Amazon Web Services generates a random one for you.</p> <p>If you retry the operation with the same <code>ClientToken</code>, but with different parameters, the retry fails with an <code>IdempotentParameterMismatch</code> error.</p>', 'CreateTrustedTokenIssuerRequest$ClientToken' => '<p>Specifies a unique, case-sensitive ID that you provide to ensure the idempotency of the request. This lets you safely retry the request without accidentally performing the same operation a second time. Passing the same value to a later call to an operation requires that you also pass the same value for all other parameters. We recommend that you use a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.</p> <p>If you don\'t provide this value, then Amazon Web Services generates a random one for you.</p> <p>If you retry the operation with the same <code>ClientToken</code>, but with different parameters, the retry fails with an <code>IdempotentParameterMismatch</code> error.</p>', ], ], 'ConflictException' => [ 'base' => '<p>Occurs when a conflict with a previous successful write is detected. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>', 'refs' => [], ], 'ConflictExceptionMessage' => [ 'base' => NULL, 'refs' => [ 'ConflictException$Message' => NULL, ], ], 'CreateAccountAssignmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAccountAssignmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateApplicationAssignmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateApplicationAssignmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateApplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateApplicationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateInstanceAccessControlAttributeConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateInstanceAccessControlAttributeConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateInstanceResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreatePermissionSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreatePermissionSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateTrustedTokenIssuerRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTrustedTokenIssuerResponse' => [ 'base' => NULL, 'refs' => [], ], 'CustomerManagedPolicyReference' => [ 'base' => '<p>Specifies the name and path of a customer managed policy. You must have an IAM policy that matches the name and path in each Amazon Web Services account where you want to deploy your permission set.</p>', 'refs' => [ 'AttachCustomerManagedPolicyReferenceToPermissionSetRequest$CustomerManagedPolicyReference' => '<p>Specifies the name and path of a customer managed policy. You must have an IAM policy that matches the name and path in each Amazon Web Services account where you want to deploy your permission set.</p>', 'CustomerManagedPolicyReferenceList$member' => NULL, 'DetachCustomerManagedPolicyReferenceFromPermissionSetRequest$CustomerManagedPolicyReference' => '<p>Specifies the name and path of a customer managed policy. You must have an IAM policy that matches the name and path in each Amazon Web Services account where you want to deploy your permission set.</p>', 'PermissionsBoundary$CustomerManagedPolicyReference' => '<p>Specifies the name and path of a customer managed policy. You must have an IAM policy that matches the name and path in each Amazon Web Services account where you want to deploy your permission set.</p>', ], ], 'CustomerManagedPolicyReferenceList' => [ 'base' => NULL, 'refs' => [ 'ListCustomerManagedPolicyReferencesInPermissionSetResponse$CustomerManagedPolicyReferences' => '<p>Specifies the names and paths of the customer managed policies that you have attached to your permission set.</p>', ], ], 'Date' => [ 'base' => NULL, 'refs' => [ 'AccountAssignmentOperationStatus$CreatedDate' => '<p>The date that the permission set was created.</p>', 'AccountAssignmentOperationStatusMetadata$CreatedDate' => '<p>The date that the permission set was created.</p>', 'Application$CreatedDate' => '<p>The date and time when the application was originally created.</p>', 'DescribeApplicationResponse$CreatedDate' => '<p>The date the application was created.</p>', 'DescribeInstanceResponse$CreatedDate' => '<p>The date the instance was created.</p>', 'InstanceMetadata$CreatedDate' => '<p>The date and time that the Identity Center instance was created.</p>', 'PermissionSet$CreatedDate' => '<p>The date that the permission set was created.</p>', 'PermissionSetProvisioningStatus$CreatedDate' => '<p>The date that the permission set was created.</p>', 'PermissionSetProvisioningStatusMetadata$CreatedDate' => '<p>The date that the permission set was created.</p>', ], ], 'DeleteAccountAssignmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAccountAssignmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteApplicationAccessScopeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteApplicationAssignmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteApplicationAssignmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteApplicationAuthenticationMethodRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteApplicationGrantRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteApplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteApplicationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteInlinePolicyFromPermissionSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteInlinePolicyFromPermissionSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteInstanceAccessControlAttributeConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteInstanceAccessControlAttributeConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteInstanceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeletePermissionSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletePermissionSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeletePermissionsBoundaryFromPermissionSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletePermissionsBoundaryFromPermissionSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTrustedTokenIssuerRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTrustedTokenIssuerResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccountAssignmentCreationStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccountAssignmentCreationStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccountAssignmentDeletionStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccountAssignmentDeletionStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeApplicationAssignmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeApplicationAssignmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeApplicationProviderRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeApplicationProviderResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeApplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeApplicationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstanceAccessControlAttributeConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstanceAccessControlAttributeConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstanceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribePermissionSetProvisioningStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribePermissionSetProvisioningStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribePermissionSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribePermissionSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTrustedTokenIssuerRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTrustedTokenIssuerResponse' => [ 'base' => NULL, 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'Application$Description' => '<p>The description of the application.</p>', 'CreateApplicationRequest$Description' => '<p>The description of the .</p>', 'DescribeApplicationResponse$Description' => '<p>The description of the .</p>', 'DisplayData$Description' => '<p>The description of the application provider that appears in the portal.</p>', 'ResourceServerScopeDetails$DetailedTitle' => '<p>The title of an access scope for a resource server.</p>', 'ResourceServerScopeDetails$LongDescription' => '<p>The description of an access scope for a resource server.</p>', 'UpdateApplicationRequest$Description' => '<p>The description of the .</p>', ], ], 'DetachCustomerManagedPolicyReferenceFromPermissionSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DetachCustomerManagedPolicyReferenceFromPermissionSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'DetachManagedPolicyFromPermissionSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DetachManagedPolicyFromPermissionSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisplayData' => [ 'base' => '<p>A structure that describes how the portal represents an application provider.</p>', 'refs' => [ 'ApplicationProvider$DisplayData' => '<p>A structure that describes how IAM Identity Center represents the application provider in the portal.</p>', 'DescribeApplicationProviderResponse$DisplayData' => '<p>A structure with details about the display data for the application provider.</p>', ], ], 'Duration' => [ 'base' => NULL, 'refs' => [ 'CreatePermissionSetRequest$SessionDuration' => '<p>The length of time that the application user sessions are valid in the ISO-8601 standard.</p>', 'PermissionSet$SessionDuration' => '<p>The length of time that the application user sessions are valid for in the ISO-8601 standard.</p>', 'UpdatePermissionSetRequest$SessionDuration' => '<p>The length of time that the application user sessions are valid for in the ISO-8601 standard.</p>', ], ], 'FederationProtocol' => [ 'base' => NULL, 'refs' => [ 'ApplicationProvider$FederationProtocol' => '<p>The protocol that the application provider uses to perform federation.</p>', 'DescribeApplicationProviderResponse$FederationProtocol' => '<p>The protocol used to federate to the application provider.</p>', ], ], 'GetApplicationAccessScopeRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetApplicationAccessScopeResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetApplicationAssignmentConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetApplicationAssignmentConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetApplicationAuthenticationMethodRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetApplicationAuthenticationMethodResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetApplicationGrantRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetApplicationGrantResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetInlinePolicyForPermissionSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetInlinePolicyForPermissionSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetPermissionsBoundaryForPermissionSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetPermissionsBoundaryForPermissionSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'Grant' => [ 'base' => '<p>The Grant union represents the set of possible configuration options for the selected grant type. Exactly one member of the union must be specified, and must match the grant type selected.</p>', 'refs' => [ 'GetApplicationGrantResponse$Grant' => '<p>A structure that describes the requested grant.</p>', 'GrantItem$Grant' => '<p>The configuration structure for the selected grant.</p>', 'PutApplicationGrantRequest$Grant' => '<p>Specifies a structure that describes the grant to update.</p>', ], ], 'GrantItem' => [ 'base' => '<p>A structure that defines a single grant and its configuration.</p>', 'refs' => [ 'Grants$member' => NULL, ], ], 'GrantType' => [ 'base' => NULL, 'refs' => [ 'DeleteApplicationGrantRequest$GrantType' => '<p>Specifies the type of grant to delete from the application.</p>', 'GetApplicationGrantRequest$GrantType' => '<p>Specifies the type of grant.</p>', 'GrantItem$GrantType' => '<p>The type of the selected grant.</p>', 'PutApplicationGrantRequest$GrantType' => '<p>Specifies the type of grant to update.</p>', ], ], 'Grants' => [ 'base' => NULL, 'refs' => [ 'ListApplicationGrantsResponse$Grants' => '<p>An array list of structures that describe the requested grants.</p>', ], ], 'IamAuthenticationMethod' => [ 'base' => '<p>A structure that describes details for authentication that uses IAM.</p>', 'refs' => [ 'AuthenticationMethod$Iam' => '<p>A structure that describes details for IAM authentication.</p>', ], ], 'IconUrl' => [ 'base' => NULL, 'refs' => [ 'DisplayData$IconUrl' => '<p>A URL that points to an icon that represents the application provider.</p>', ], ], 'Id' => [ 'base' => NULL, 'refs' => [ 'DescribeInstanceResponse$IdentityStoreId' => '<p>The identifier of the identity store that is connected to the instance of IAM Identity Center.</p>', 'InstanceMetadata$IdentityStoreId' => '<p>The identifier of the identity store that is connected to the Identity Center instance.</p>', ], ], 'InstanceAccessControlAttributeConfiguration' => [ 'base' => '<p>Specifies the attributes to add to your attribute-based access control (ABAC) configuration.</p>', 'refs' => [ 'CreateInstanceAccessControlAttributeConfigurationRequest$InstanceAccessControlAttributeConfiguration' => '<p>Specifies the IAM Identity Center identity store attributes to add to your ABAC configuration. When using an external identity provider as an identity source, you can pass attributes through the SAML assertion. Doing so provides an alternative to configuring attributes from the IAM Identity Center identity store. If a SAML assertion passes any of these attributes, IAM Identity Center will replace the attribute value with the value from the IAM Identity Center identity store.</p>', 'DescribeInstanceAccessControlAttributeConfigurationResponse$InstanceAccessControlAttributeConfiguration' => '<p>Gets the list of IAM Identity Center identity store attributes that have been added to your ABAC configuration.</p>', 'UpdateInstanceAccessControlAttributeConfigurationRequest$InstanceAccessControlAttributeConfiguration' => '<p>Updates the attributes for your ABAC configuration.</p>', ], ], 'InstanceAccessControlAttributeConfigurationStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeInstanceAccessControlAttributeConfigurationResponse$Status' => '<p>The status of the attribute configuration process.</p>', ], ], 'InstanceAccessControlAttributeConfigurationStatusReason' => [ 'base' => NULL, 'refs' => [ 'DescribeInstanceAccessControlAttributeConfigurationResponse$StatusReason' => '<p>Provides more details about the current status of the specified attribute.</p>', ], ], 'InstanceArn' => [ 'base' => NULL, 'refs' => [ 'Application$InstanceArn' => '<p>The ARN of the instance of IAM Identity Center that is configured with this application.</p>', 'AttachCustomerManagedPolicyReferenceToPermissionSetRequest$InstanceArn' => '<p>The ARN of the IAM Identity Center instance under which the operation will be executed. </p>', 'AttachManagedPolicyToPermissionSetRequest$InstanceArn' => '<p>The ARN of the IAM Identity Center instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'CreateAccountAssignmentRequest$InstanceArn' => '<p>The ARN of the IAM Identity Center instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'CreateApplicationRequest$InstanceArn' => '<p>The ARN of the instance of IAM Identity Center under which the operation will run. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'CreateInstanceAccessControlAttributeConfigurationRequest$InstanceArn' => '<p>The ARN of the IAM Identity Center instance under which the operation will be executed.</p>', 'CreateInstanceResponse$InstanceArn' => '<p>The ARN of the instance of IAM Identity Center under which the operation will run. </p> <p>For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'CreatePermissionSetRequest$InstanceArn' => '<p>The ARN of the IAM Identity Center instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'CreateTrustedTokenIssuerRequest$InstanceArn' => '<p>Specifies the ARN of the instance of IAM Identity Center to contain the new trusted token issuer configuration.</p>', 'DeleteAccountAssignmentRequest$InstanceArn' => '<p>The ARN of the IAM Identity Center instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'DeleteInlinePolicyFromPermissionSetRequest$InstanceArn' => '<p>The ARN of the IAM Identity Center instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'DeleteInstanceAccessControlAttributeConfigurationRequest$InstanceArn' => '<p>The ARN of the IAM Identity Center instance under which the operation will be executed.</p>', 'DeleteInstanceRequest$InstanceArn' => '<p>The ARN of the instance of IAM Identity Center under which the operation will run.</p>', 'DeletePermissionSetRequest$InstanceArn' => '<p>The ARN of the IAM Identity Center instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'DeletePermissionsBoundaryFromPermissionSetRequest$InstanceArn' => '<p>The ARN of the IAM Identity Center instance under which the operation will be executed. </p>', 'DescribeAccountAssignmentCreationStatusRequest$InstanceArn' => '<p>The ARN of the IAM Identity Center instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'DescribeAccountAssignmentDeletionStatusRequest$InstanceArn' => '<p>The ARN of the IAM Identity Center instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'DescribeApplicationResponse$InstanceArn' => '<p>The ARN of the IAM Identity Center application under which the operation will run. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'DescribeInstanceAccessControlAttributeConfigurationRequest$InstanceArn' => '<p>The ARN of the IAM Identity Center instance under which the operation will be executed.</p>', 'DescribeInstanceRequest$InstanceArn' => '<p>The ARN of the instance of IAM Identity Center under which the operation will run.</p>', 'DescribeInstanceResponse$InstanceArn' => '<p>The ARN of the instance of IAM Identity Center under which the operation will run. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'DescribePermissionSetProvisioningStatusRequest$InstanceArn' => '<p>The ARN of the IAM Identity Center instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'DescribePermissionSetRequest$InstanceArn' => '<p>The ARN of the IAM Identity Center instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'DetachCustomerManagedPolicyReferenceFromPermissionSetRequest$InstanceArn' => '<p>The ARN of the IAM Identity Center instance under which the operation will be executed. </p>', 'DetachManagedPolicyFromPermissionSetRequest$InstanceArn' => '<p>The ARN of the IAM Identity Center instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'GetInlinePolicyForPermissionSetRequest$InstanceArn' => '<p>The ARN of the IAM Identity Center instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'GetPermissionsBoundaryForPermissionSetRequest$InstanceArn' => '<p>The ARN of the IAM Identity Center instance under which the operation will be executed. </p>', 'InstanceMetadata$InstanceArn' => '<p>The ARN of the Identity Center instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'ListAccountAssignmentCreationStatusRequest$InstanceArn' => '<p>The ARN of the IAM Identity Center instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'ListAccountAssignmentDeletionStatusRequest$InstanceArn' => '<p>The ARN of the IAM Identity Center instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'ListAccountAssignmentsForPrincipalRequest$InstanceArn' => '<p>Specifies the ARN of the instance of IAM Identity Center that contains the principal.</p>', 'ListAccountAssignmentsRequest$InstanceArn' => '<p>The ARN of the IAM Identity Center instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'ListAccountsForProvisionedPermissionSetRequest$InstanceArn' => '<p>The ARN of the IAM Identity Center instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'ListApplicationAssignmentsForPrincipalRequest$InstanceArn' => '<p>Specifies the instance of IAM Identity Center that contains principal and applications.</p>', 'ListApplicationsRequest$InstanceArn' => '<p>The ARN of the IAM Identity Center application under which the operation will run. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'ListCustomerManagedPolicyReferencesInPermissionSetRequest$InstanceArn' => '<p>The ARN of the IAM Identity Center instance under which the operation will be executed. </p>', 'ListManagedPoliciesInPermissionSetRequest$InstanceArn' => '<p>The ARN of the IAM Identity Center instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'ListPermissionSetProvisioningStatusRequest$InstanceArn' => '<p>The ARN of the IAM Identity Center instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'ListPermissionSetsProvisionedToAccountRequest$InstanceArn' => '<p>The ARN of the IAM Identity Center instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'ListPermissionSetsRequest$InstanceArn' => '<p>The ARN of the IAM Identity Center instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'ListTagsForResourceRequest$InstanceArn' => '<p>The ARN of the IAM Identity Center instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'ListTrustedTokenIssuersRequest$InstanceArn' => '<p>Specifies the ARN of the instance of IAM Identity Center with the trusted token issuer configurations that you want to list.</p>', 'ProvisionPermissionSetRequest$InstanceArn' => '<p>The ARN of the IAM Identity Center instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'PutInlinePolicyToPermissionSetRequest$InstanceArn' => '<p>The ARN of the IAM Identity Center instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'PutPermissionsBoundaryToPermissionSetRequest$InstanceArn' => '<p>The ARN of the IAM Identity Center instance under which the operation will be executed. </p>', 'TagResourceRequest$InstanceArn' => '<p>The ARN of the IAM Identity Center instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'UntagResourceRequest$InstanceArn' => '<p>The ARN of the IAM Identity Center instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'UpdateInstanceAccessControlAttributeConfigurationRequest$InstanceArn' => '<p>The ARN of the IAM Identity Center instance under which the operation will be executed.</p>', 'UpdateInstanceRequest$InstanceArn' => '<p>The ARN of the instance of IAM Identity Center under which the operation will run. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'UpdatePermissionSetRequest$InstanceArn' => '<p>The ARN of the IAM Identity Center instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', ], ], 'InstanceList' => [ 'base' => NULL, 'refs' => [ 'ListInstancesResponse$Instances' => '<p>Lists the IAM Identity Center instances that the caller has access to.</p>', ], ], 'InstanceMetadata' => [ 'base' => '<p>Provides information about the IAM Identity Center instance.</p>', 'refs' => [ 'InstanceList$member' => NULL, ], ], 'InstanceStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeInstanceResponse$Status' => '<p>The status of the instance. </p>', 'InstanceMetadata$Status' => '<p>The current status of this Identity Center instance.</p>', ], ], 'InternalFailureMessage' => [ 'base' => NULL, 'refs' => [ 'InternalServerException$Message' => NULL, ], ], 'InternalServerException' => [ 'base' => '<p>The request processing has failed because of an unknown error, exception, or failure with an internal server.</p>', 'refs' => [], ], 'JMESPath' => [ 'base' => NULL, 'refs' => [ 'OidcJwtConfiguration$IdentityStoreAttributePath' => '<p>The path of the destination attribute in a JWT from IAM Identity Center. The attribute mapped by this JMESPath expression is compared against the attribute mapped by <code>ClaimAttributePath</code> when a trusted token issuer token is exchanged for an IAM Identity Center token. </p>', 'OidcJwtUpdateConfiguration$IdentityStoreAttributePath' => '<p>The path of the destination attribute in a JWT from IAM Identity Center. The attribute mapped by this JMESPath expression is compared against the attribute mapped by <code>ClaimAttributePath</code> when a trusted token issuer token is exchanged for an IAM Identity Center token.</p>', ], ], 'JwksRetrievalOption' => [ 'base' => NULL, 'refs' => [ 'OidcJwtConfiguration$JwksRetrievalOption' => '<p>The method that the trusted token issuer can use to retrieve the JSON Web Key Set used to verify a JWT.</p>', 'OidcJwtUpdateConfiguration$JwksRetrievalOption' => '<p>The method that the trusted token issuer can use to retrieve the JSON Web Key Set used to verify a JWT.</p>', ], ], 'JwtBearerGrant' => [ 'base' => '<p>A structure that defines configuration settings for an application that supports the JWT Bearer Token Authorization Grant.</p>', 'refs' => [ 'Grant$JwtBearer' => '<p>Configuration options for the <code>urn:ietf:params:oauth:grant-type:jwt-bearer</code> grant type.</p>', ], ], 'ListAccountAssignmentCreationStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAccountAssignmentCreationStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAccountAssignmentDeletionStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAccountAssignmentDeletionStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAccountAssignmentsFilter' => [ 'base' => '<p>A structure that describes a filter for account assignments.</p>', 'refs' => [ 'ListAccountAssignmentsForPrincipalRequest$Filter' => '<p>Specifies an Amazon Web Services account ID number. Results are filtered to only those that match this ID number.</p>', ], ], 'ListAccountAssignmentsForPrincipalRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAccountAssignmentsForPrincipalResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAccountAssignmentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAccountAssignmentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAccountsForProvisionedPermissionSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAccountsForProvisionedPermissionSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListApplicationAccessScopesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListApplicationAccessScopesRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListApplicationAccessScopesRequest$MaxResults' => '<p>Specifies the total number of results that you want included in each response. If additional items exist beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the next set of results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>', ], ], 'ListApplicationAccessScopesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListApplicationAssignmentsFilter' => [ 'base' => '<p>A structure that describes a filter for application assignments.</p>', 'refs' => [ 'ListApplicationAssignmentsForPrincipalRequest$Filter' => '<p>Filters the output to include only assignments associated with the application that has the specified ARN.</p>', ], ], 'ListApplicationAssignmentsForPrincipalRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListApplicationAssignmentsForPrincipalResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListApplicationAssignmentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListApplicationAssignmentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListApplicationAuthenticationMethodsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListApplicationAuthenticationMethodsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListApplicationGrantsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListApplicationGrantsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListApplicationProvidersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListApplicationProvidersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListApplicationsFilter' => [ 'base' => '<p>A structure that describes a filter for applications.</p>', 'refs' => [ 'ListApplicationsRequest$Filter' => '<p>Filters response results. </p>', ], ], 'ListApplicationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListApplicationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListCustomerManagedPolicyReferencesInPermissionSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCustomerManagedPolicyReferencesInPermissionSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListInstancesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListInstancesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListManagedPoliciesInPermissionSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListManagedPoliciesInPermissionSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPermissionSetProvisioningStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPermissionSetProvisioningStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPermissionSetsProvisionedToAccountRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPermissionSetsProvisionedToAccountResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPermissionSetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPermissionSetsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTrustedTokenIssuersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTrustedTokenIssuersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ManagedPolicyArn' => [ 'base' => NULL, 'refs' => [ 'AttachManagedPolicyToPermissionSetRequest$ManagedPolicyArn' => '<p>The Amazon Web Services managed policy ARN to be attached to a permission set.</p>', 'AttachedManagedPolicy$Arn' => '<p>The ARN of the Amazon Web Services managed policy. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'DetachManagedPolicyFromPermissionSetRequest$ManagedPolicyArn' => '<p>The Amazon Web Services managed policy ARN to be detached from a permission set.</p>', 'PermissionsBoundary$ManagedPolicyArn' => '<p>The Amazon Web Services managed policy ARN that you want to attach to a permission set as a permissions boundary.</p>', ], ], 'ManagedPolicyName' => [ 'base' => NULL, 'refs' => [ 'CustomerManagedPolicyReference$Name' => '<p>The name of the IAM policy that you have configured in each account where you want to deploy your permission set.</p>', ], ], 'ManagedPolicyPath' => [ 'base' => NULL, 'refs' => [ 'CustomerManagedPolicyReference$Path' => '<p>The path to the IAM policy that you have configured in each account where you want to deploy your permission set. The default is <code>/</code>. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-friendly-names">Friendly names and paths</a> in the <i>IAM User Guide</i>.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListAccountAssignmentCreationStatusRequest$MaxResults' => '<p>The maximum number of results to display for the assignment.</p>', 'ListAccountAssignmentDeletionStatusRequest$MaxResults' => '<p>The maximum number of results to display for the assignment.</p>', 'ListAccountAssignmentsForPrincipalRequest$MaxResults' => '<p>Specifies the total number of results that you want included in each response. If additional items exist beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the next set of results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>', 'ListAccountAssignmentsRequest$MaxResults' => '<p>The maximum number of results to display for the assignment.</p>', 'ListAccountsForProvisionedPermissionSetRequest$MaxResults' => '<p>The maximum number of results to display for the <a>PermissionSet</a>.</p>', 'ListApplicationAssignmentsForPrincipalRequest$MaxResults' => '<p>Specifies the total number of results that you want included in each response. If additional items exist beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the next set of results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>', 'ListApplicationAssignmentsRequest$MaxResults' => '<p>Specifies the total number of results that you want included in each response. If additional items exist beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the next set of results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>', 'ListApplicationProvidersRequest$MaxResults' => '<p>Specifies the total number of results that you want included in each response. If additional items exist beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the next set of results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>', 'ListApplicationsRequest$MaxResults' => '<p>Specifies the total number of results that you want included in each response. If additional items exist beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the next set of results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>', 'ListCustomerManagedPolicyReferencesInPermissionSetRequest$MaxResults' => '<p>The maximum number of results to display for the list call.</p>', 'ListInstancesRequest$MaxResults' => '<p>The maximum number of results to display for the instance.</p>', 'ListManagedPoliciesInPermissionSetRequest$MaxResults' => '<p>The maximum number of results to display for the <a>PermissionSet</a>.</p>', 'ListPermissionSetProvisioningStatusRequest$MaxResults' => '<p>The maximum number of results to display for the assignment.</p>', 'ListPermissionSetsProvisionedToAccountRequest$MaxResults' => '<p>The maximum number of results to display for the assignment.</p>', 'ListPermissionSetsRequest$MaxResults' => '<p>The maximum number of results to display for the assignment.</p>', 'ListTrustedTokenIssuersRequest$MaxResults' => '<p>Specifies the total number of results that you want included in each response. If additional items exist beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the next set of results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>', ], ], 'Name' => [ 'base' => NULL, 'refs' => [ 'AttachedManagedPolicy$Name' => '<p>The name of the Amazon Web Services managed policy.</p>', 'DisplayData$DisplayName' => '<p>The name of the application provider that appears in the portal.</p>', ], ], 'NameType' => [ 'base' => NULL, 'refs' => [ 'Application$Name' => '<p>The name of the application.</p>', 'CreateApplicationRequest$Name' => '<p>The name of the .</p>', 'CreateInstanceRequest$Name' => '<p>The name of the instance of IAM Identity Center.</p>', 'DescribeApplicationResponse$Name' => '<p>The application name.</p>', 'DescribeInstanceResponse$Name' => '<p>Specifies the instance name.</p>', 'InstanceMetadata$Name' => '<p>The name of the Identity Center instance.</p>', 'UpdateApplicationRequest$Name' => '<p>Specifies the updated name for the application.</p>', 'UpdateInstanceRequest$Name' => '<p>Updates the instance name.</p>', ], ], 'OidcJwtConfiguration' => [ 'base' => '<p>A structure that describes configuration settings for a trusted token issuer that supports OpenID Connect (OIDC) and JSON Web Tokens (JWTs).</p>', 'refs' => [ 'TrustedTokenIssuerConfiguration$OidcJwtConfiguration' => '<p>A structure that describes the settings for a trusted token issuer that works with OpenID Connect (OIDC) by using JSON Web Tokens (JWT).</p>', ], ], 'OidcJwtUpdateConfiguration' => [ 'base' => '<p>A structure that describes updated configuration settings for a trusted token issuer that supports OpenID Connect (OIDC) and JSON Web Tokens (JWTs).</p>', 'refs' => [ 'TrustedTokenIssuerUpdateConfiguration$OidcJwtConfiguration' => '<p>A structure that describes an updated configuration for a trusted token issuer that uses OpenID Connect (OIDC) with JSON web tokens (JWT).</p>', ], ], 'OperationStatusFilter' => [ 'base' => '<p>Filters the operation status list based on the passed attribute value.</p>', 'refs' => [ 'ListAccountAssignmentCreationStatusRequest$Filter' => '<p>Filters results based on the passed attribute value.</p>', 'ListAccountAssignmentDeletionStatusRequest$Filter' => '<p>Filters results based on the passed attribute value.</p>', 'ListPermissionSetProvisioningStatusRequest$Filter' => '<p>Filters results based on the passed attribute value.</p>', ], ], 'PermissionSet' => [ 'base' => '<p>An entity that contains IAM policies.</p>', 'refs' => [ 'CreatePermissionSetResponse$PermissionSet' => '<p>Defines the level of access on an Amazon Web Services account.</p>', 'DescribePermissionSetResponse$PermissionSet' => '<p>Describes the level of access on an Amazon Web Services account.</p>', ], ], 'PermissionSetArn' => [ 'base' => NULL, 'refs' => [ 'AccountAssignment$PermissionSetArn' => '<p>The ARN of the permission set. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'AccountAssignmentForPrincipal$PermissionSetArn' => '<p>The ARN of the IAM Identity Center permission set assigned to this principal for this Amazon Web Services account.</p>', 'AccountAssignmentOperationStatus$PermissionSetArn' => '<p>The ARN of the permission set. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'AttachCustomerManagedPolicyReferenceToPermissionSetRequest$PermissionSetArn' => '<p>The ARN of the <code>PermissionSet</code>.</p>', 'AttachManagedPolicyToPermissionSetRequest$PermissionSetArn' => '<p>The ARN of the <a>PermissionSet</a> that the managed policy should be attached to.</p>', 'CreateAccountAssignmentRequest$PermissionSetArn' => '<p>The ARN of the permission set that the admin wants to grant the principal access to.</p>', 'DeleteAccountAssignmentRequest$PermissionSetArn' => '<p>The ARN of the permission set that will be used to remove access.</p>', 'DeleteInlinePolicyFromPermissionSetRequest$PermissionSetArn' => '<p>The ARN of the permission set that will be used to remove access.</p>', 'DeletePermissionSetRequest$PermissionSetArn' => '<p>The ARN of the permission set that should be deleted.</p>', 'DeletePermissionsBoundaryFromPermissionSetRequest$PermissionSetArn' => '<p>The ARN of the <code>PermissionSet</code>.</p>', 'DescribePermissionSetRequest$PermissionSetArn' => '<p>The ARN of the permission set. </p>', 'DetachCustomerManagedPolicyReferenceFromPermissionSetRequest$PermissionSetArn' => '<p>The ARN of the <code>PermissionSet</code>.</p>', 'DetachManagedPolicyFromPermissionSetRequest$PermissionSetArn' => '<p>The ARN of the <a>PermissionSet</a> from which the policy should be detached.</p>', 'GetInlinePolicyForPermissionSetRequest$PermissionSetArn' => '<p>The ARN of the permission set.</p>', 'GetPermissionsBoundaryForPermissionSetRequest$PermissionSetArn' => '<p>The ARN of the <code>PermissionSet</code>.</p>', 'ListAccountAssignmentsRequest$PermissionSetArn' => '<p>The ARN of the permission set from which to list assignments.</p>', 'ListAccountsForProvisionedPermissionSetRequest$PermissionSetArn' => '<p>The ARN of the <a>PermissionSet</a> from which the associated Amazon Web Services accounts will be listed.</p>', 'ListCustomerManagedPolicyReferencesInPermissionSetRequest$PermissionSetArn' => '<p>The ARN of the <code>PermissionSet</code>. </p>', 'ListManagedPoliciesInPermissionSetRequest$PermissionSetArn' => '<p>The ARN of the <a>PermissionSet</a> whose managed policies will be listed.</p>', 'PermissionSet$PermissionSetArn' => '<p>The ARN of the permission set. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'PermissionSetList$member' => NULL, 'PermissionSetProvisioningStatus$PermissionSetArn' => '<p>The ARN of the permission set that is being provisioned. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'ProvisionPermissionSetRequest$PermissionSetArn' => '<p>The ARN of the permission set.</p>', 'PutInlinePolicyToPermissionSetRequest$PermissionSetArn' => '<p>The ARN of the permission set.</p>', 'PutPermissionsBoundaryToPermissionSetRequest$PermissionSetArn' => '<p>The ARN of the <code>PermissionSet</code>.</p>', 'UpdatePermissionSetRequest$PermissionSetArn' => '<p>The ARN of the permission set.</p>', ], ], 'PermissionSetDescription' => [ 'base' => NULL, 'refs' => [ 'CreatePermissionSetRequest$Description' => '<p>The description of the <a>PermissionSet</a>.</p>', 'PermissionSet$Description' => '<p>The description of the <a>PermissionSet</a>.</p>', 'UpdatePermissionSetRequest$Description' => '<p>The description of the <a>PermissionSet</a>.</p>', ], ], 'PermissionSetList' => [ 'base' => NULL, 'refs' => [ 'ListPermissionSetsProvisionedToAccountResponse$PermissionSets' => '<p>Defines the level of access that an Amazon Web Services account has.</p>', 'ListPermissionSetsResponse$PermissionSets' => '<p>Defines the level of access on an Amazon Web Services account.</p>', ], ], 'PermissionSetName' => [ 'base' => NULL, 'refs' => [ 'CreatePermissionSetRequest$Name' => '<p>The name of the <a>PermissionSet</a>.</p>', 'PermissionSet$Name' => '<p>The name of the permission set.</p>', ], ], 'PermissionSetPolicyDocument' => [ 'base' => NULL, 'refs' => [ 'GetInlinePolicyForPermissionSetResponse$InlinePolicy' => '<p>The inline policy that is attached to the permission set.</p> <note> <p>For <code>Length Constraints</code>, if a valid ARN is provided for a permission set, it is possible for an empty inline policy to be returned.</p> </note>', 'PutInlinePolicyToPermissionSetRequest$InlinePolicy' => '<p>The inline policy to attach to a <a>PermissionSet</a>.</p>', ], ], 'PermissionSetProvisioningStatus' => [ 'base' => '<p>A structure that is used to provide the status of the provisioning operation for a specified permission set.</p>', 'refs' => [ 'DescribePermissionSetProvisioningStatusResponse$PermissionSetProvisioningStatus' => '<p>The status object for the permission set provisioning operation.</p>', 'ProvisionPermissionSetResponse$PermissionSetProvisioningStatus' => '<p>The status object for the permission set provisioning operation.</p>', ], ], 'PermissionSetProvisioningStatusList' => [ 'base' => NULL, 'refs' => [ 'ListPermissionSetProvisioningStatusResponse$PermissionSetsProvisioningStatus' => '<p>The status object for the permission set provisioning operation.</p>', ], ], 'PermissionSetProvisioningStatusMetadata' => [ 'base' => '<p>Provides information about the permission set provisioning status.</p>', 'refs' => [ 'PermissionSetProvisioningStatusList$member' => NULL, ], ], 'PermissionsBoundary' => [ 'base' => '<p>Specifies the configuration of the Amazon Web Services managed or customer managed policy that you want to set as a permissions boundary. Specify either <code>CustomerManagedPolicyReference</code> to use the name and path of a customer managed policy, or <code>ManagedPolicyArn</code> to use the ARN of an Amazon Web Services managed policy. A permissions boundary represents the maximum permissions that any policy can grant your role. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions boundaries for IAM entities</a> in the <i>IAM User Guide</i>.</p> <important> <p>Policies used as permissions boundaries don\'t provide permissions. You must also attach an IAM policy to the role. To learn how the effective permissions for a role are evaluated, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html">IAM JSON policy evaluation logic</a> in the <i>IAM User Guide</i>.</p> </important>', 'refs' => [ 'GetPermissionsBoundaryForPermissionSetResponse$PermissionsBoundary' => '<p>The permissions boundary attached to the specified permission set.</p>', 'PutPermissionsBoundaryToPermissionSetRequest$PermissionsBoundary' => '<p>The permissions boundary that you want to attach to a <code>PermissionSet</code>.</p>', ], ], 'PortalOptions' => [ 'base' => '<p>A structure that describes the options for the access portal associated with an application.</p>', 'refs' => [ 'Application$PortalOptions' => '<p>A structure that describes the options for the access portal associated with this application.</p>', 'CreateApplicationRequest$PortalOptions' => '<p>A structure that describes the options for the portal associated with an application.</p>', 'DescribeApplicationResponse$PortalOptions' => '<p>A structure that describes the options for the portal associated with an application.</p>', ], ], 'PrincipalId' => [ 'base' => NULL, 'refs' => [ 'AccountAssignment$PrincipalId' => '<p>An identifier for an object in IAM Identity Center, such as a user or group. PrincipalIds are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more information about PrincipalIds in IAM Identity Center, see the <a href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">IAM Identity Center Identity Store API Reference</a>.</p>', 'AccountAssignmentForPrincipal$PrincipalId' => '<p>The ID of the principal.</p>', 'AccountAssignmentOperationStatus$PrincipalId' => '<p>An identifier for an object in IAM Identity Center, such as a user or group. PrincipalIds are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more information about PrincipalIds in IAM Identity Center, see the <a href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">IAM Identity Center Identity Store API Reference</a>.</p>', 'ApplicationAssignment$PrincipalId' => '<p>The unique identifier of the principal assigned to the application.</p>', 'ApplicationAssignmentForPrincipal$PrincipalId' => '<p>The unique identifier of the principal assigned to the application.</p>', 'CreateAccountAssignmentRequest$PrincipalId' => '<p>An identifier for an object in IAM Identity Center, such as a user or group. PrincipalIds are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more information about PrincipalIds in IAM Identity Center, see the <a href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">IAM Identity Center Identity Store API Reference</a>.</p>', 'CreateApplicationAssignmentRequest$PrincipalId' => '<p>An identifier for an object in IAM Identity Center, such as a user or group. PrincipalIds are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more information about PrincipalIds in IAM Identity Center, see the <a href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">IAM Identity Center Identity Store API Reference</a>.</p>', 'DeleteAccountAssignmentRequest$PrincipalId' => '<p>An identifier for an object in IAM Identity Center, such as a user or group. PrincipalIds are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more information about PrincipalIds in IAM Identity Center, see the <a href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">IAM Identity Center Identity Store API Reference</a>.</p>', 'DeleteApplicationAssignmentRequest$PrincipalId' => '<p>An identifier for an object in IAM Identity Center, such as a user or group. PrincipalIds are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more information about PrincipalIds in IAM Identity Center, see the <a href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">IAM Identity Center Identity Store API Reference</a>.</p>', 'DescribeApplicationAssignmentRequest$PrincipalId' => '<p>An identifier for an object in IAM Identity Center, such as a user or group. PrincipalIds are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more information about PrincipalIds in IAM Identity Center, see the <a href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">IAM Identity Center Identity Store API Reference</a>.</p>', 'DescribeApplicationAssignmentResponse$PrincipalId' => '<p>An identifier for an object in IAM Identity Center, such as a user or group. PrincipalIds are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more information about PrincipalIds in IAM Identity Center, see the <a href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">IAM Identity Center Identity Store API Reference</a>.</p>', 'ListAccountAssignmentsForPrincipalRequest$PrincipalId' => '<p>Specifies the principal for which you want to retrieve the list of account assignments.</p>', 'ListApplicationAssignmentsForPrincipalRequest$PrincipalId' => '<p>Specifies the unique identifier of the principal for which you want to retrieve its assignments.</p>', ], ], 'PrincipalType' => [ 'base' => NULL, 'refs' => [ 'AccountAssignment$PrincipalType' => '<p>The entity type for which the assignment will be created.</p>', 'AccountAssignmentForPrincipal$PrincipalType' => '<p>The type of the principal.</p>', 'AccountAssignmentOperationStatus$PrincipalType' => '<p>The entity type for which the assignment will be created.</p>', 'ApplicationAssignment$PrincipalType' => '<p>The type of the principal assigned to the application.</p>', 'ApplicationAssignmentForPrincipal$PrincipalType' => '<p>The type of the principal assigned to the application.</p>', 'CreateAccountAssignmentRequest$PrincipalType' => '<p>The entity type for which the assignment will be created.</p>', 'CreateApplicationAssignmentRequest$PrincipalType' => '<p>The entity type for which the assignment will be created.</p>', 'DeleteAccountAssignmentRequest$PrincipalType' => '<p>The entity type for which the assignment will be deleted.</p>', 'DeleteApplicationAssignmentRequest$PrincipalType' => '<p>The entity type for which the assignment will be deleted.</p>', 'DescribeApplicationAssignmentRequest$PrincipalType' => '<p>The entity type for which the assignment will be created.</p>', 'DescribeApplicationAssignmentResponse$PrincipalType' => '<p>The entity type for which the assignment will be created.</p>', 'ListAccountAssignmentsForPrincipalRequest$PrincipalType' => '<p>Specifies the type of the principal.</p>', 'ListApplicationAssignmentsForPrincipalRequest$PrincipalType' => '<p>Specifies the type of the principal for which you want to retrieve its assignments.</p>', ], ], 'ProvisionPermissionSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'ProvisionPermissionSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'ProvisionTargetType' => [ 'base' => NULL, 'refs' => [ 'ProvisionPermissionSetRequest$TargetType' => '<p>The entity type for which the assignment will be created.</p>', ], ], 'ProvisioningStatus' => [ 'base' => NULL, 'refs' => [ 'ListAccountsForProvisionedPermissionSetRequest$ProvisioningStatus' => '<p>The permission set provisioning status for an Amazon Web Services account.</p>', 'ListPermissionSetsProvisionedToAccountRequest$ProvisioningStatus' => '<p>The status object for the permission set provisioning operation.</p>', ], ], 'PutApplicationAccessScopeRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutApplicationAssignmentConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutApplicationAssignmentConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutApplicationAuthenticationMethodRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutApplicationGrantRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutInlinePolicyToPermissionSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutInlinePolicyToPermissionSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutPermissionsBoundaryToPermissionSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutPermissionsBoundaryToPermissionSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'Reason' => [ 'base' => NULL, 'refs' => [ 'AccountAssignmentOperationStatus$FailureReason' => '<p>The message that contains an error or exception in case of an operation failure.</p>', 'PermissionSetProvisioningStatus$FailureReason' => '<p>The message that contains an error or exception in case of an operation failure.</p>', ], ], 'RedirectUris' => [ 'base' => NULL, 'refs' => [ 'AuthorizationCodeGrant$RedirectUris' => '<p>A list of URIs that are valid locations to redirect a user\'s browser after the user is authorized.</p>', ], ], 'RefreshTokenGrant' => [ 'base' => '<p>A structure that defines configuration settings for an application that supports the OAuth 2.0 Refresh Token Grant.</p>', 'refs' => [ 'Grant$RefreshToken' => '<p>Configuration options for the <code>refresh_token</code> grant type.</p>', ], ], 'RelayState' => [ 'base' => NULL, 'refs' => [ 'CreatePermissionSetRequest$RelayState' => '<p>Used to redirect users within the application during the federation authentication process.</p>', 'PermissionSet$RelayState' => '<p>Used to redirect users within the application during the federation authentication process.</p>', 'UpdatePermissionSetRequest$RelayState' => '<p>Used to redirect users within the application during the federation authentication process.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>Indicates that a requested resource is not found.</p>', 'refs' => [], ], 'ResourceNotFoundMessage' => [ 'base' => NULL, 'refs' => [ 'ResourceNotFoundException$Message' => NULL, ], ], 'ResourceServerConfig' => [ 'base' => '<p>A structure that describes the configuration of a resource server.</p>', 'refs' => [ 'ApplicationProvider$ResourceServerConfig' => '<p>A structure that describes the application provider\'s resource server.</p>', 'DescribeApplicationProviderResponse$ResourceServerConfig' => '<p>A structure with details about the receiving application.</p>', ], ], 'ResourceServerScope' => [ 'base' => NULL, 'refs' => [ 'ResourceServerScopes$key' => NULL, ], ], 'ResourceServerScopeDetails' => [ 'base' => '<p>A structure that describes details for an IAM Identity Center access scope that is associated with a resource server.</p>', 'refs' => [ 'ResourceServerScopes$value' => NULL, ], ], 'ResourceServerScopes' => [ 'base' => NULL, 'refs' => [ 'ResourceServerConfig$Scopes' => '<p>A list of the IAM Identity Center access scopes that are associated with this resource server.</p>', ], ], 'Scope' => [ 'base' => NULL, 'refs' => [ 'DeleteApplicationAccessScopeRequest$Scope' => '<p>Specifies the name of the access scope to remove from the application.</p>', 'GetApplicationAccessScopeRequest$Scope' => '<p>Specifies the name of the access scope for which you want the authorized targets.</p>', 'GetApplicationAccessScopeResponse$Scope' => '<p>The name of the access scope that can be used with the authorized targets.</p>', 'PutApplicationAccessScopeRequest$Scope' => '<p>Specifies the name of the access scope to be associated with the specified targets.</p>', 'ScopeDetails$Scope' => '<p>The name of the access scope.</p>', ], ], 'ScopeDetails' => [ 'base' => '<p>A structure that describes an IAM Identity Center access scope and its authorized targets.</p>', 'refs' => [ 'Scopes$member' => NULL, ], ], 'ScopeTarget' => [ 'base' => NULL, 'refs' => [ 'ScopeTargets$member' => NULL, ], ], 'ScopeTargets' => [ 'base' => NULL, 'refs' => [ 'GetApplicationAccessScopeResponse$AuthorizedTargets' => '<p>An array of authorized targets associated with this access scope.</p>', 'PutApplicationAccessScopeRequest$AuthorizedTargets' => '<p>Specifies an array list of ARNs that represent the authorized targets for this access scope.</p>', 'ScopeDetails$AuthorizedTargets' => '<p>An array list of ARNs of applications.</p>', ], ], 'Scopes' => [ 'base' => NULL, 'refs' => [ 'ListApplicationAccessScopesResponse$Scopes' => '<p>An array list of access scopes and their authorized targets that are associated with the application.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>Indicates that the principal has crossed the permitted number of resources that can be created.</p>', 'refs' => [], ], 'ServiceQuotaExceededMessage' => [ 'base' => NULL, 'refs' => [ 'ServiceQuotaExceededException$Message' => NULL, ], ], 'SignInOptions' => [ 'base' => '<p>A structure that describes the sign-in options for an application portal.</p>', 'refs' => [ 'PortalOptions$SignInOptions' => '<p>A structure that describes the sign-in options for the access portal.</p>', 'UpdateApplicationPortalOptions$SignInOptions' => NULL, ], ], 'SignInOrigin' => [ 'base' => NULL, 'refs' => [ 'SignInOptions$Origin' => '<p>This determines how IAM Identity Center navigates the user to the target application. It can be one of the following values:</p> <ul> <li> <p> <code>APPLICATION</code>: IAM Identity Center redirects the customer to the configured <code>ApplicationUrl</code>.</p> </li> <li> <p> <code>IDENTITY_CENTER</code>: IAM Identity Center uses SAML identity-provider initiated authentication to sign the customer directly into a SAML-based application.</p> </li> </ul>', ], ], 'StatusValues' => [ 'base' => NULL, 'refs' => [ 'AccountAssignmentOperationStatus$Status' => '<p>The status of the permission set provisioning process.</p>', 'AccountAssignmentOperationStatusMetadata$Status' => '<p>The status of the permission set provisioning process.</p>', 'OperationStatusFilter$Status' => '<p>Filters the list operations result based on the status attribute.</p>', 'PermissionSetProvisioningStatus$Status' => '<p>The status of the permission set provisioning process.</p>', 'PermissionSetProvisioningStatusMetadata$Status' => '<p>The status of the permission set provisioning process.</p>', ], ], 'Tag' => [ 'base' => '<p>A set of key-value pairs that are used to manage the resource. Tags can only be applied to permission sets and cannot be applied to corresponding roles that IAM Identity Center creates in Amazon Web Services accounts.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>The key for the tag.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>The keys of tags that are attached to the resource.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateApplicationRequest$Tags' => '<p>Specifies tags to be attached to the application.</p>', 'CreateInstanceRequest$Tags' => '<p>Specifies tags to be attached to the instance of IAM Identity Center.</p>', 'CreatePermissionSetRequest$Tags' => '<p>The tags to attach to the new <a>PermissionSet</a>.</p>', 'CreateTrustedTokenIssuerRequest$Tags' => '<p>Specifies tags to be attached to the new trusted token issuer configuration.</p>', 'ListTagsForResourceResponse$Tags' => '<p>A set of key-value pairs that are used to manage the resource.</p>', 'TagResourceRequest$Tags' => '<p>A set of key-value pairs that are used to manage the resource.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The value of the tag.</p>', ], ], 'TaggableResourceArn' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$ResourceArn' => '<p>The ARN of the resource with the tags to be listed.</p>', 'TagResourceRequest$ResourceArn' => '<p>The ARN of the resource with the tags to be listed.</p>', 'UntagResourceRequest$ResourceArn' => '<p>The ARN of the resource with the tags to be listed.</p>', ], ], 'TargetId' => [ 'base' => NULL, 'refs' => [ 'AccountAssignmentOperationStatus$TargetId' => '<p>TargetID is an Amazon Web Services account identifier, (For example, 123456789012).</p>', 'CreateAccountAssignmentRequest$TargetId' => '<p>TargetID is an Amazon Web Services account identifier, (For example, 123456789012).</p>', 'DeleteAccountAssignmentRequest$TargetId' => '<p>TargetID is an Amazon Web Services account identifier, (For example, 123456789012).</p>', 'ListAccountAssignmentsRequest$AccountId' => '<p>The identifier of the Amazon Web Services account from which to list the assignments.</p>', 'ProvisionPermissionSetRequest$TargetId' => '<p>TargetID is an Amazon Web Services account identifier, (For example, 123456789012).</p>', ], ], 'TargetType' => [ 'base' => NULL, 'refs' => [ 'AccountAssignmentOperationStatus$TargetType' => '<p>The entity type for which the assignment will be created.</p>', 'CreateAccountAssignmentRequest$TargetType' => '<p>The entity type for which the assignment will be created.</p>', 'DeleteAccountAssignmentRequest$TargetType' => '<p>The entity type for which the assignment will be deleted.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>Indicates that the principal has crossed the throttling limits of the API operations.</p>', 'refs' => [], ], 'ThrottlingExceptionMessage' => [ 'base' => NULL, 'refs' => [ 'ThrottlingException$Message' => NULL, ], ], 'Token' => [ 'base' => NULL, 'refs' => [ 'ListAccountAssignmentCreationStatusRequest$NextToken' => '<p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>', 'ListAccountAssignmentCreationStatusResponse$NextToken' => '<p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>', 'ListAccountAssignmentDeletionStatusRequest$NextToken' => '<p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>', 'ListAccountAssignmentDeletionStatusResponse$NextToken' => '<p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>', 'ListAccountAssignmentsForPrincipalRequest$NextToken' => '<p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call\'s <code>NextToken</code> response to request the next page of results.</p>', 'ListAccountAssignmentsForPrincipalResponse$NextToken' => '<p>If present, this value indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>. This indicates that this is the last page of results.</p>', 'ListAccountAssignmentsRequest$NextToken' => '<p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>', 'ListAccountAssignmentsResponse$NextToken' => '<p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>', 'ListAccountsForProvisionedPermissionSetRequest$NextToken' => '<p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>', 'ListAccountsForProvisionedPermissionSetResponse$NextToken' => '<p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>', 'ListApplicationAccessScopesRequest$NextToken' => '<p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call\'s <code>NextToken</code> response to request the next page of results.</p>', 'ListApplicationAccessScopesResponse$NextToken' => '<p>If present, this value indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>. This indicates that this is the last page of results.</p>', 'ListApplicationAssignmentsForPrincipalRequest$NextToken' => '<p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call\'s <code>NextToken</code> response to request the next page of results.</p>', 'ListApplicationAssignmentsForPrincipalResponse$NextToken' => '<p>If present, this value indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>. This indicates that this is the last page of results.</p>', 'ListApplicationAssignmentsRequest$NextToken' => '<p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call\'s <code>NextToken</code> response to request the next page of results.</p>', 'ListApplicationAssignmentsResponse$NextToken' => '<p>If present, this value indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>. This indicates that this is the last page of results.</p>', 'ListApplicationAuthenticationMethodsRequest$NextToken' => '<p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call\'s <code>NextToken</code> response to request the next page of results.</p>', 'ListApplicationAuthenticationMethodsResponse$NextToken' => '<p>If present, this value indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>. This indicates that this is the last page of results.</p>', 'ListApplicationGrantsRequest$NextToken' => '<p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call\'s <code>NextToken</code> response to request the next page of results.</p>', 'ListApplicationGrantsResponse$NextToken' => '<p>If present, this value indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>. This indicates that this is the last page of results.</p>', 'ListApplicationProvidersRequest$NextToken' => '<p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call\'s <code>NextToken</code> response to request the next page of results.</p>', 'ListApplicationProvidersResponse$NextToken' => '<p>If present, this value indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>. This indicates that this is the last page of results.</p>', 'ListApplicationsRequest$NextToken' => '<p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call\'s <code>NextToken</code> response to request the next page of results.</p>', 'ListApplicationsResponse$NextToken' => '<p>If present, this value indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>. This indicates that this is the last page of results.</p>', 'ListCustomerManagedPolicyReferencesInPermissionSetRequest$NextToken' => '<p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>', 'ListCustomerManagedPolicyReferencesInPermissionSetResponse$NextToken' => '<p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>', 'ListInstancesRequest$NextToken' => '<p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>', 'ListInstancesResponse$NextToken' => '<p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>', 'ListManagedPoliciesInPermissionSetRequest$NextToken' => '<p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>', 'ListManagedPoliciesInPermissionSetResponse$NextToken' => '<p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>', 'ListPermissionSetProvisioningStatusRequest$NextToken' => '<p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>', 'ListPermissionSetProvisioningStatusResponse$NextToken' => '<p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>', 'ListPermissionSetsProvisionedToAccountRequest$NextToken' => '<p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>', 'ListPermissionSetsProvisionedToAccountResponse$NextToken' => '<p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>', 'ListPermissionSetsRequest$NextToken' => '<p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>', 'ListPermissionSetsResponse$NextToken' => '<p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>', 'ListTagsForResourceRequest$NextToken' => '<p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>', 'ListTagsForResourceResponse$NextToken' => '<p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>', 'ListTrustedTokenIssuersRequest$NextToken' => '<p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call\'s <code>NextToken</code> response to request the next page of results.</p>', 'ListTrustedTokenIssuersResponse$NextToken' => '<p>If present, this value indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>. This indicates that this is the last page of results.</p>', ], ], 'TokenExchangeGrant' => [ 'base' => '<p>A structure that defines configuration settings for an application that supports the OAuth 2.0 Token Exchange Grant.</p>', 'refs' => [ 'Grant$TokenExchange' => '<p>Configuration options for the <code>urn:ietf:params:oauth:grant-type:token-exchange</code> grant type.</p>', ], ], 'TokenIssuerAudience' => [ 'base' => NULL, 'refs' => [ 'TokenIssuerAudiences$member' => NULL, ], ], 'TokenIssuerAudiences' => [ 'base' => NULL, 'refs' => [ 'AuthorizedTokenIssuer$AuthorizedAudiences' => '<p>An array list of authorized audiences, or applications, that can consume the tokens generated by the associated trusted token issuer.</p>', ], ], 'TrustedTokenIssuerArn' => [ 'base' => NULL, 'refs' => [ 'AuthorizedTokenIssuer$TrustedTokenIssuerArn' => '<p>The ARN of the trusted token issuer.</p>', 'CreateTrustedTokenIssuerResponse$TrustedTokenIssuerArn' => '<p>The ARN of the new trusted token issuer configuration.</p>', 'DeleteTrustedTokenIssuerRequest$TrustedTokenIssuerArn' => '<p>Specifies the ARN of the trusted token issuer configuration to delete.</p>', 'DescribeTrustedTokenIssuerRequest$TrustedTokenIssuerArn' => '<p>Specifies the ARN of the trusted token issuer configuration that you want details about.</p>', 'DescribeTrustedTokenIssuerResponse$TrustedTokenIssuerArn' => '<p>The ARN of the trusted token issuer configuration.</p>', 'TrustedTokenIssuerMetadata$TrustedTokenIssuerArn' => '<p>The ARN of the trusted token issuer configuration in the instance of IAM Identity Center.</p>', 'UpdateTrustedTokenIssuerRequest$TrustedTokenIssuerArn' => '<p>Specifies the ARN of the trusted token issuer configuration that you want to update.</p>', ], ], 'TrustedTokenIssuerConfiguration' => [ 'base' => '<p>A structure that describes the configuration of a trusted token issuer. The structure and available settings are determined by the type of the trusted token issuer.</p>', 'refs' => [ 'CreateTrustedTokenIssuerRequest$TrustedTokenIssuerConfiguration' => '<p>Specifies settings that apply to the new trusted token issuer configuration. The settings that are available depend on what <code>TrustedTokenIssuerType</code> you specify.</p>', 'DescribeTrustedTokenIssuerResponse$TrustedTokenIssuerConfiguration' => '<p>A structure the describes the settings that apply of this trusted token issuer.</p>', ], ], 'TrustedTokenIssuerList' => [ 'base' => NULL, 'refs' => [ 'ListTrustedTokenIssuersResponse$TrustedTokenIssuers' => '<p>An array list of the trusted token issuer configurations.</p>', ], ], 'TrustedTokenIssuerMetadata' => [ 'base' => '<p>A structure that describes a trusted token issuer.</p>', 'refs' => [ 'TrustedTokenIssuerList$member' => NULL, ], ], 'TrustedTokenIssuerName' => [ 'base' => NULL, 'refs' => [ 'CreateTrustedTokenIssuerRequest$Name' => '<p>Specifies the name of the new trusted token issuer configuration.</p>', 'DescribeTrustedTokenIssuerResponse$Name' => '<p>The name of the trusted token issuer configuration.</p>', 'TrustedTokenIssuerMetadata$Name' => '<p>The name of the trusted token issuer configuration in the instance of IAM Identity Center.</p>', 'UpdateTrustedTokenIssuerRequest$Name' => '<p>Specifies the updated name to be applied to the trusted token issuer configuration.</p>', ], ], 'TrustedTokenIssuerType' => [ 'base' => NULL, 'refs' => [ 'CreateTrustedTokenIssuerRequest$TrustedTokenIssuerType' => '<p>Specifies the type of the new trusted token issuer.</p>', 'DescribeTrustedTokenIssuerResponse$TrustedTokenIssuerType' => '<p>The type of the trusted token issuer.</p>', 'TrustedTokenIssuerMetadata$TrustedTokenIssuerType' => '<p>The type of trusted token issuer.</p>', ], ], 'TrustedTokenIssuerUpdateConfiguration' => [ 'base' => '<p>A structure that contains details to be updated for a trusted token issuer configuration. The structure and settings that you can include depend on the type of the trusted token issuer being updated.</p>', 'refs' => [ 'UpdateTrustedTokenIssuerRequest$TrustedTokenIssuerConfiguration' => '<p>Specifies a structure with settings to apply to the specified trusted token issuer. The settings that you can provide are determined by the type of the trusted token issuer that you are updating.</p>', ], ], 'TrustedTokenIssuerUrl' => [ 'base' => NULL, 'refs' => [ 'OidcJwtConfiguration$IssuerUrl' => '<p>The URL that IAM Identity Center uses for OpenID Discovery. OpenID Discovery is used to obtain the information required to verify the tokens that the trusted token issuer generates.</p>', ], ], 'URI' => [ 'base' => NULL, 'refs' => [ 'RedirectUris$member' => NULL, ], ], 'UUId' => [ 'base' => NULL, 'refs' => [ 'AccountAssignmentOperationStatus$RequestId' => '<p>The identifier for tracking the request operation that is generated by the universally unique identifier (UUID) workflow.</p>', 'AccountAssignmentOperationStatusMetadata$RequestId' => '<p>The identifier for tracking the request operation that is generated by the universally unique identifier (UUID) workflow.</p>', 'DescribeAccountAssignmentCreationStatusRequest$AccountAssignmentCreationRequestId' => '<p>The identifier that is used to track the request operation progress.</p>', 'DescribeAccountAssignmentDeletionStatusRequest$AccountAssignmentDeletionRequestId' => '<p>The identifier that is used to track the request operation progress.</p>', 'DescribePermissionSetProvisioningStatusRequest$ProvisionPermissionSetRequestId' => '<p>The identifier that is provided by the <a>ProvisionPermissionSet</a> call to retrieve the current status of the provisioning workflow.</p>', 'PermissionSetProvisioningStatus$RequestId' => '<p>The identifier for tracking the request operation that is generated by the universally unique identifier (UUID) workflow.</p>', 'PermissionSetProvisioningStatusMetadata$RequestId' => '<p>The identifier for tracking the request operation that is generated by the universally unique identifier (UUID) workflow.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateApplicationPortalOptions' => [ 'base' => '<p>A structure that describes the options for the access portal associated with an application that can be updated.</p>', 'refs' => [ 'UpdateApplicationRequest$PortalOptions' => '<p>A structure that describes the options for the portal associated with an application.</p>', ], ], 'UpdateApplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateApplicationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateInstanceAccessControlAttributeConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateInstanceAccessControlAttributeConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateInstanceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePermissionSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePermissionSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTrustedTokenIssuerRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTrustedTokenIssuerResponse' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>The request failed because it contains a syntax error.</p>', 'refs' => [], ], 'ValidationExceptionMessage' => [ 'base' => NULL, 'refs' => [ 'ValidationException$Message' => NULL, ], ], ],];
