<?php
// This file was auto-generated from sdk-root/src/data/states/2016-11-23/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Step Functions</fullname> <p>Step Functions is a service that lets you coordinate the components of distributed applications and microservices using visual workflows.</p> <p>You can use Step Functions to build applications from individual components, each of which performs a discrete function, or <i>task</i>, allowing you to scale and change applications quickly. Step Functions provides a console that helps visualize the components of your application as a series of steps. Step Functions automatically triggers and tracks each step, and retries steps when there are errors, so your application executes predictably and in the right order every time. Step Functions logs the state of each step, so you can quickly diagnose and debug any issues.</p> <p>Step Functions manages operations and underlying infrastructure to ensure your application is available at any scale. You can run tasks on Amazon Web Services, your own servers, or any system that has access to Amazon Web Services. You can access and use Step Functions using the console, the Amazon Web Services SDKs, or an HTTP API. For more information about Step Functions, see the <i> <a href="https://docs.aws.amazon.com/step-functions/latest/dg/welcome.html">Step Functions Developer Guide</a> </i>.</p> <important> <p>If you use the Step Functions API actions using Amazon Web Services SDK integrations, make sure the API actions are in camel case and parameter names are in Pascal case. For example, you could use Step Functions API action <code>startSyncExecution</code> and specify its parameter as <code>StateMachineArn</code>.</p> </important>', 'operations' => [ 'CreateActivity' => '<p>Creates an activity. An activity is a task that you write in any programming language and host on any machine that has access to Step Functions. Activities must poll Step Functions using the <code>GetActivityTask</code> API action and respond using <code>SendTask*</code> API actions. This function lets Step Functions know the existence of your activity and returns an identifier for use in a state machine and when polling from the activity.</p> <note> <p>This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.</p> </note> <note> <p> <code>CreateActivity</code> is an idempotent API. Subsequent requests won’t create a duplicate resource if it was already created. <code>CreateActivity</code>\'s idempotency check is based on the activity <code>name</code>. If a following request has different <code>tags</code> values, Step Functions will ignore these differences and treat it as an idempotent request of the previous. In this case, <code>tags</code> will not be updated, even if they are different.</p> </note>', 'CreateStateMachine' => '<p>Creates a state machine. A state machine consists of a collection of states that can do work (<code>Task</code> states), determine to which states to transition next (<code>Choice</code> states), stop an execution with an error (<code>Fail</code> states), and so on. State machines are specified using a JSON-based, structured language. For more information, see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States Language</a> in the Step Functions User Guide.</p> <p>If you set the <code>publish</code> parameter of this API action to <code>true</code>, it publishes version <code>1</code> as the first revision of the state machine.</p> <note> <p>This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.</p> </note> <note> <p> <code>CreateStateMachine</code> is an idempotent API. Subsequent requests won’t create a duplicate resource if it was already created. <code>CreateStateMachine</code>\'s idempotency check is based on the state machine <code>name</code>, <code>definition</code>, <code>type</code>, <code>LoggingConfiguration</code>, and <code>TracingConfiguration</code>. The check is also based on the <code>publish</code> and <code>versionDescription</code> parameters. If a following request has a different <code>roleArn</code> or <code>tags</code>, Step Functions will ignore these differences and treat it as an idempotent request of the previous. In this case, <code>roleArn</code> and <code>tags</code> will not be updated, even if they are different.</p> </note>', 'CreateStateMachineAlias' => '<p>Creates an <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html">alias</a> for a state machine that points to one or two <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html">versions</a> of the same state machine. You can set your application to call <a>StartExecution</a> with an alias and update the version the alias uses without changing the client\'s code.</p> <p>You can also map an alias to split <a>StartExecution</a> requests between two versions of a state machine. To do this, add a second <code>RoutingConfig</code> object in the <code>routingConfiguration</code> parameter. You must also specify the percentage of execution run requests each version should receive in both <code>RoutingConfig</code> objects. Step Functions randomly chooses which version runs a given execution based on the percentage you specify.</p> <p>To create an alias that points to a single version, specify a single <code>RoutingConfig</code> object with a <code>weight</code> set to 100.</p> <p>You can create up to 100 aliases for each state machine. You must delete unused aliases using the <a>DeleteStateMachineAlias</a> API action.</p> <p> <code>CreateStateMachineAlias</code> is an idempotent API. Step Functions bases the idempotency check on the <code>stateMachineArn</code>, <code>description</code>, <code>name</code>, and <code>routingConfiguration</code> parameters. Requests that contain the same values for these parameters return a successful idempotent response without creating a duplicate resource.</p> <p> <b>Related operations:</b> </p> <ul> <li> <p> <a>DescribeStateMachineAlias</a> </p> </li> <li> <p> <a>ListStateMachineAliases</a> </p> </li> <li> <p> <a>UpdateStateMachineAlias</a> </p> </li> <li> <p> <a>DeleteStateMachineAlias</a> </p> </li> </ul>', 'DeleteActivity' => '<p>Deletes an activity.</p>', 'DeleteStateMachine' => '<p>Deletes a state machine. This is an asynchronous operation. It sets the state machine\'s status to <code>DELETING</code> and begins the deletion process. A state machine is deleted only when all its executions are completed. On the next state transition, the state machine\'s executions are terminated.</p> <p>A qualified state machine ARN can either refer to a <i>Distributed Map state</i> defined within a state machine, a version ARN, or an alias ARN.</p> <p>The following are some examples of qualified and unqualified state machine ARNs:</p> <ul> <li> <p>The following qualified state machine ARN refers to a <i>Distributed Map state</i> with a label <code>mapStateLabel</code> in a state machine named <code>myStateMachine</code>.</p> <p> <code>arn:partition:states:region:account-id:stateMachine:myStateMachine/mapStateLabel</code> </p> <note> <p>If you provide a qualified state machine ARN that refers to a <i>Distributed Map state</i>, the request fails with <code>ValidationException</code>.</p> </note> </li> <li> <p>The following unqualified state machine ARN refers to a state machine named <code>myStateMachine</code>.</p> <p> <code>arn:partition:states:region:account-id:stateMachine:myStateMachine</code> </p> </li> </ul> <p>This API action also deletes all <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html">versions</a> and <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html">aliases</a> associated with a state machine.</p> <note> <p>For <code>EXPRESS</code> state machines, the deletion happens eventually (usually in less than a minute). Running executions may emit logs after <code>DeleteStateMachine</code> API is called.</p> </note>', 'DeleteStateMachineAlias' => '<p>Deletes a state machine <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html">alias</a>.</p> <p>After you delete a state machine alias, you can\'t use it to start executions. When you delete a state machine alias, Step Functions doesn\'t delete the state machine versions that alias references.</p> <p> <b>Related operations:</b> </p> <ul> <li> <p> <a>CreateStateMachineAlias</a> </p> </li> <li> <p> <a>DescribeStateMachineAlias</a> </p> </li> <li> <p> <a>ListStateMachineAliases</a> </p> </li> <li> <p> <a>UpdateStateMachineAlias</a> </p> </li> </ul>', 'DeleteStateMachineVersion' => '<p>Deletes a state machine <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html">version</a>. After you delete a version, you can\'t call <a>StartExecution</a> using that version\'s ARN or use the version with a state machine <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html">alias</a>.</p> <note> <p>Deleting a state machine version won\'t terminate its in-progress executions.</p> </note> <note> <p>You can\'t delete a state machine version currently referenced by one or more aliases. Before you delete a version, you must either delete the aliases or update them to point to another state machine version.</p> </note> <p> <b>Related operations:</b> </p> <ul> <li> <p> <a>PublishStateMachineVersion</a> </p> </li> <li> <p> <a>ListStateMachineVersions</a> </p> </li> </ul>', 'DescribeActivity' => '<p>Describes an activity.</p> <note> <p>This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.</p> </note>', 'DescribeExecution' => '<p>Provides information about a state machine execution, such as the state machine associated with the execution, the execution input and output, and relevant execution metadata. If you\'ve <a href="https://docs.aws.amazon.com/step-functions/latest/dg/redrive-executions.html">redriven</a> an execution, you can use this API action to return information about the redrives of that execution. In addition, you can use this API action to return the Map Run Amazon Resource Name (ARN) if the execution was dispatched by a Map Run.</p> <p>If you specify a version or alias ARN when you call the <a>StartExecution</a> API action, <code>DescribeExecution</code> returns that ARN.</p> <note> <p>This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.</p> </note> <p>Executions of an <code>EXPRESS</code> state machine aren\'t supported by <code>DescribeExecution</code> unless a Map Run dispatched them.</p>', 'DescribeMapRun' => '<p>Provides information about a Map Run\'s configuration, progress, and results. If you\'ve <a href="https://docs.aws.amazon.com/step-functions/latest/dg/redrive-map-run.html">redriven</a> a Map Run, this API action also returns information about the redrives of that Map Run. For more information, see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-examine-map-run.html">Examining Map Run</a> in the <i>Step Functions Developer Guide</i>.</p>', 'DescribeStateMachine' => '<p>Provides information about a state machine\'s definition, its IAM role Amazon Resource Name (ARN), and configuration.</p> <p>A qualified state machine ARN can either refer to a <i>Distributed Map state</i> defined within a state machine, a version ARN, or an alias ARN.</p> <p>The following are some examples of qualified and unqualified state machine ARNs:</p> <ul> <li> <p>The following qualified state machine ARN refers to a <i>Distributed Map state</i> with a label <code>mapStateLabel</code> in a state machine named <code>myStateMachine</code>.</p> <p> <code>arn:partition:states:region:account-id:stateMachine:myStateMachine/mapStateLabel</code> </p> <note> <p>If you provide a qualified state machine ARN that refers to a <i>Distributed Map state</i>, the request fails with <code>ValidationException</code>.</p> </note> </li> <li> <p>The following qualified state machine ARN refers to an alias named <code>PROD</code>.</p> <p> <code>arn:&lt;partition&gt;:states:&lt;region&gt;:&lt;account-id&gt;:stateMachine:&lt;myStateMachine:PROD&gt;</code> </p> <note> <p>If you provide a qualified state machine ARN that refers to a version ARN or an alias ARN, the request starts execution for that version or alias.</p> </note> </li> <li> <p>The following unqualified state machine ARN refers to a state machine named <code>myStateMachine</code>.</p> <p> <code>arn:&lt;partition&gt;:states:&lt;region&gt;:&lt;account-id&gt;:stateMachine:&lt;myStateMachine&gt;</code> </p> </li> </ul> <p>This API action returns the details for a state machine version if the <code>stateMachineArn</code> you specify is a state machine version ARN.</p> <note> <p>This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.</p> </note>', 'DescribeStateMachineAlias' => '<p>Returns details about a state machine <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html">alias</a>.</p> <p> <b>Related operations:</b> </p> <ul> <li> <p> <a>CreateStateMachineAlias</a> </p> </li> <li> <p> <a>ListStateMachineAliases</a> </p> </li> <li> <p> <a>UpdateStateMachineAlias</a> </p> </li> <li> <p> <a>DeleteStateMachineAlias</a> </p> </li> </ul>', 'DescribeStateMachineForExecution' => '<p>Provides information about a state machine\'s definition, its execution role ARN, and configuration. If a Map Run dispatched the execution, this action returns the Map Run Amazon Resource Name (ARN) in the response. The state machine returned is the state machine associated with the Map Run.</p> <note> <p>This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.</p> </note> <p>This API action is not supported by <code>EXPRESS</code> state machines.</p>', 'GetActivityTask' => '<p>Used by workers to retrieve a task (with the specified activity ARN) which has been scheduled for execution by a running state machine. This initiates a long poll, where the service holds the HTTP connection open and responds as soon as a task becomes available (i.e. an execution of a task of this type is needed.) The maximum time the service holds on to the request before responding is 60 seconds. If no task is available within 60 seconds, the poll returns a <code>taskToken</code> with a null string.</p> <note> <p>This API action isn\'t logged in CloudTrail.</p> </note> <important> <p>Workers should set their client side socket timeout to at least 65 seconds (5 seconds higher than the maximum time the service may hold the poll request).</p> <p>Polling with <code>GetActivityTask</code> can cause latency in some implementations. See <a href="https://docs.aws.amazon.com/step-functions/latest/dg/bp-activity-pollers.html">Avoid Latency When Polling for Activity Tasks</a> in the Step Functions Developer Guide.</p> </important>', 'GetExecutionHistory' => '<p>Returns the history of the specified execution as a list of events. By default, the results are returned in ascending order of the <code>timeStamp</code> of the events. Use the <code>reverseOrder</code> parameter to get the latest events first.</p> <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p> <p>This API action is not supported by <code>EXPRESS</code> state machines.</p>', 'ListActivities' => '<p>Lists the existing activities.</p> <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p> <note> <p>This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.</p> </note>', 'ListExecutions' => '<p>Lists all executions of a state machine or a Map Run. You can list all executions related to a state machine by specifying a state machine Amazon Resource Name (ARN), or those related to a Map Run by specifying a Map Run ARN. Using this API action, you can also list all <a href="https://docs.aws.amazon.com/step-functions/latest/dg/redrive-executions.html">redriven</a> executions.</p> <p>You can also provide a state machine <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html">alias</a> ARN or <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html">version</a> ARN to list the executions associated with a specific alias or version.</p> <p>Results are sorted by time, with the most recent execution first.</p> <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p> <note> <p>This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.</p> </note> <p>This API action is not supported by <code>EXPRESS</code> state machines.</p>', 'ListMapRuns' => '<p>Lists all Map Runs that were started by a given state machine execution. Use this API action to obtain Map Run ARNs, and then call <code>DescribeMapRun</code> to obtain more information, if needed.</p>', 'ListStateMachineAliases' => '<p>Lists <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html">aliases</a> for a specified state machine ARN. Results are sorted by time, with the most recently created aliases listed first. </p> <p>To list aliases that reference a state machine <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html">version</a>, you can specify the version ARN in the <code>stateMachineArn</code> parameter.</p> <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p> <p> <b>Related operations:</b> </p> <ul> <li> <p> <a>CreateStateMachineAlias</a> </p> </li> <li> <p> <a>DescribeStateMachineAlias</a> </p> </li> <li> <p> <a>UpdateStateMachineAlias</a> </p> </li> <li> <p> <a>DeleteStateMachineAlias</a> </p> </li> </ul>', 'ListStateMachineVersions' => '<p>Lists <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html">versions</a> for the specified state machine Amazon Resource Name (ARN).</p> <p>The results are sorted in descending order of the version creation time.</p> <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p> <p> <b>Related operations:</b> </p> <ul> <li> <p> <a>PublishStateMachineVersion</a> </p> </li> <li> <p> <a>DeleteStateMachineVersion</a> </p> </li> </ul>', 'ListStateMachines' => '<p>Lists the existing state machines.</p> <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p> <note> <p>This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.</p> </note>', 'ListTagsForResource' => '<p>List tags for a given resource.</p> <p>Tags may only contain Unicode letters, digits, white space, or these symbols: <code>_ . : / = + - @</code>.</p>', 'PublishStateMachineVersion' => '<p>Creates a <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html">version</a> from the current revision of a state machine. Use versions to create immutable snapshots of your state machine. You can start executions from versions either directly or with an alias. To create an alias, use <a>CreateStateMachineAlias</a>.</p> <p>You can publish up to 1000 versions for each state machine. You must manually delete unused versions using the <a>DeleteStateMachineVersion</a> API action.</p> <p> <code>PublishStateMachineVersion</code> is an idempotent API. It doesn\'t create a duplicate state machine version if it already exists for the current revision. Step Functions bases <code>PublishStateMachineVersion</code>\'s idempotency check on the <code>stateMachineArn</code>, <code>name</code>, and <code>revisionId</code> parameters. Requests with the same parameters return a successful idempotent response. If you don\'t specify a <code>revisionId</code>, Step Functions checks for a previously published version of the state machine\'s current revision.</p> <p> <b>Related operations:</b> </p> <ul> <li> <p> <a>DeleteStateMachineVersion</a> </p> </li> <li> <p> <a>ListStateMachineVersions</a> </p> </li> </ul>', 'RedriveExecution' => '<p>Restarts unsuccessful executions of Standard workflows that didn\'t complete successfully in the last 14 days. These include failed, aborted, or timed out executions. When you <a href="https://docs.aws.amazon.com/step-functions/latest/dg/redrive-executions.html">redrive</a> an execution, it continues the failed execution from the unsuccessful step and uses the same input. Step Functions preserves the results and execution history of the successful steps, and doesn\'t rerun these steps when you redrive an execution. Redriven executions use the same state machine definition and execution ARN as the original execution attempt.</p> <p>For workflows that include an <a href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-map-state.html">Inline Map</a> or <a href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-parallel-state.html">Parallel</a> state, <code>RedriveExecution</code> API action reschedules and redrives only the iterations and branches that failed or aborted.</p> <p>To redrive a workflow that includes a Distributed Map state whose Map Run failed, you must redrive the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/use-dist-map-orchestrate-large-scale-parallel-workloads.html#dist-map-orchestrate-parallel-workloads-key-terms">parent workflow</a>. The parent workflow redrives all the unsuccessful states, including a failed Map Run. If a Map Run was not started in the original execution attempt, the redriven parent workflow starts the Map Run.</p> <note> <p>This API action is not supported by <code>EXPRESS</code> state machines.</p> <p>However, you can restart the unsuccessful executions of Express child workflows in a Distributed Map by redriving its Map Run. When you redrive a Map Run, the Express child workflows are rerun using the <a>StartExecution</a> API action. For more information, see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/redrive-map-run.html">Redriving Map Runs</a>.</p> </note> <p>You can redrive executions if your original execution meets the following conditions:</p> <ul> <li> <p>The execution status isn\'t <code>SUCCEEDED</code>.</p> </li> <li> <p>Your workflow execution has not exceeded the redrivable period of 14 days. Redrivable period refers to the time during which you can redrive a given execution. This period starts from the day a state machine completes its execution.</p> </li> <li> <p>The workflow execution has not exceeded the maximum open time of one year. For more information about state machine quotas, see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/limits-overview.html#service-limits-state-machine-executions">Quotas related to state machine executions</a>.</p> </li> <li> <p>The execution event history count is less than 24,999. Redriven executions append their event history to the existing event history. Make sure your workflow execution contains less than 24,999 events to accommodate the <code>ExecutionRedriven</code> history event and at least one other history event.</p> </li> </ul>', 'SendTaskFailure' => '<p>Used by activity workers, Task states using the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token">callback</a> pattern, and optionally Task states using the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-sync">job run</a> pattern to report that the task identified by the <code>taskToken</code> failed.</p>', 'SendTaskHeartbeat' => '<p>Used by activity workers and Task states using the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token">callback</a> pattern, and optionally Task states using the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-sync">job run</a> pattern to report to Step Functions that the task represented by the specified <code>taskToken</code> is still making progress. This action resets the <code>Heartbeat</code> clock. The <code>Heartbeat</code> threshold is specified in the state machine\'s Amazon States Language definition (<code>HeartbeatSeconds</code>). This action does not in itself create an event in the execution history. However, if the task times out, the execution history contains an <code>ActivityTimedOut</code> entry for activities, or a <code>TaskTimedOut</code> entry for tasks using the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-sync">job run</a> or <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token">callback</a> pattern.</p> <note> <p>The <code>Timeout</code> of a task, defined in the state machine\'s Amazon States Language definition, is its maximum allowed duration, regardless of the number of <a>SendTaskHeartbeat</a> requests received. Use <code>HeartbeatSeconds</code> to configure the timeout interval for heartbeats.</p> </note>', 'SendTaskSuccess' => '<p>Used by activity workers, Task states using the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token">callback</a> pattern, and optionally Task states using the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-sync">job run</a> pattern to report that the task identified by the <code>taskToken</code> completed successfully.</p>', 'StartExecution' => '<p>Starts a state machine execution.</p> <p>A qualified state machine ARN can either refer to a <i>Distributed Map state</i> defined within a state machine, a version ARN, or an alias ARN.</p> <p>The following are some examples of qualified and unqualified state machine ARNs:</p> <ul> <li> <p>The following qualified state machine ARN refers to a <i>Distributed Map state</i> with a label <code>mapStateLabel</code> in a state machine named <code>myStateMachine</code>.</p> <p> <code>arn:partition:states:region:account-id:stateMachine:myStateMachine/mapStateLabel</code> </p> <note> <p>If you provide a qualified state machine ARN that refers to a <i>Distributed Map state</i>, the request fails with <code>ValidationException</code>.</p> </note> </li> <li> <p>The following qualified state machine ARN refers to an alias named <code>PROD</code>.</p> <p> <code>arn:&lt;partition&gt;:states:&lt;region&gt;:&lt;account-id&gt;:stateMachine:&lt;myStateMachine:PROD&gt;</code> </p> <note> <p>If you provide a qualified state machine ARN that refers to a version ARN or an alias ARN, the request starts execution for that version or alias.</p> </note> </li> <li> <p>The following unqualified state machine ARN refers to a state machine named <code>myStateMachine</code>.</p> <p> <code>arn:&lt;partition&gt;:states:&lt;region&gt;:&lt;account-id&gt;:stateMachine:&lt;myStateMachine&gt;</code> </p> </li> </ul> <p>If you start an execution with an unqualified state machine ARN, Step Functions uses the latest revision of the state machine for the execution.</p> <p>To start executions of a state machine <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html">version</a>, call <code>StartExecution</code> and provide the version ARN or the ARN of an <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html">alias</a> that points to the version.</p> <note> <p> <code>StartExecution</code> is idempotent for <code>STANDARD</code> workflows. For a <code>STANDARD</code> workflow, if you call <code>StartExecution</code> with the same name and input as a running execution, the call succeeds and return the same response as the original request. If the execution is closed or if the input is different, it returns a <code>400 ExecutionAlreadyExists</code> error. You can reuse names after 90 days. </p> <p> <code>StartExecution</code> isn\'t idempotent for <code>EXPRESS</code> workflows. </p> </note>', 'StartSyncExecution' => '<p>Starts a Synchronous Express state machine execution. <code>StartSyncExecution</code> is not available for <code>STANDARD</code> workflows.</p> <note> <p> <code>StartSyncExecution</code> will return a <code>200 OK</code> response, even if your execution fails, because the status code in the API response doesn\'t reflect function errors. Error codes are reserved for errors that prevent your execution from running, such as permissions errors, limit errors, or issues with your state machine code and configuration. </p> </note> <note> <p>This API action isn\'t logged in CloudTrail.</p> </note>', 'StopExecution' => '<p>Stops an execution.</p> <p>This API action is not supported by <code>EXPRESS</code> state machines.</p>', 'TagResource' => '<p>Add a tag to a Step Functions resource.</p> <p>An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>, and <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html">Controlling Access Using IAM Tags</a>.</p> <p>Tags may only contain Unicode letters, digits, white space, or these symbols: <code>_ . : / = + - @</code>.</p>', 'TestState' => '<p>Accepts the definition of a single state and executes it. You can test a state without creating a state machine or updating an existing state machine. Using this API, you can test the following:</p> <ul> <li> <p>A state\'s <a href="https://docs.aws.amazon.com/step-functions/latest/dg/test-state-isolation.html#test-state-input-output-dataflow">input and output processing</a> data flow</p> </li> <li> <p>An <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-services.html">Amazon Web Services service integration</a> request and response</p> </li> <li> <p>An <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-third-party-apis.html">HTTP Task</a> request and response</p> </li> </ul> <p>You can call this API on only one state at a time. The states that you can test include the following:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-task-state.html#task-types">All Task types</a> except <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-activities.html">Activity</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-pass-state.html">Pass</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-wait-state.html">Wait</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-choice-state.html">Choice</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-succeed-state.html">Succeed</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-fail-state.html">Fail</a> </p> </li> </ul> <p>The <code>TestState</code> API assumes an IAM role which must contain the required IAM permissions for the resources your state is accessing. For information about the permissions a state might need, see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/test-state-isolation.html#test-state-permissions">IAM permissions to test a state</a>.</p> <p>The <code>TestState</code> API can run for up to five minutes. If the execution of a state exceeds this duration, it fails with the <code>States.Timeout</code> error.</p> <p> <code>TestState</code> doesn\'t support <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-activities.html">Activity tasks</a>, <code>.sync</code> or <code>.waitForTaskToken</code> <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html">service integration patterns</a>, <a href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-parallel-state.html">Parallel</a>, or <a href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-map-state.html">Map</a> states.</p>', 'UntagResource' => '<p>Remove a tag from a Step Functions resource</p>', 'UpdateMapRun' => '<p>Updates an in-progress Map Run\'s configuration to include changes to the settings that control maximum concurrency and Map Run failure.</p>', 'UpdateStateMachine' => '<p>Updates an existing state machine by modifying its <code>definition</code>, <code>roleArn</code>, or <code>loggingConfiguration</code>. Running executions will continue to use the previous <code>definition</code> and <code>roleArn</code>. You must include at least one of <code>definition</code> or <code>roleArn</code> or you will receive a <code>MissingRequiredParameter</code> error.</p> <p>A qualified state machine ARN refers to a <i>Distributed Map state</i> defined within a state machine. For example, the qualified state machine ARN <code>arn:partition:states:region:account-id:stateMachine:stateMachineName/mapStateLabel</code> refers to a <i>Distributed Map state</i> with a label <code>mapStateLabel</code> in the state machine named <code>stateMachineName</code>.</p> <p>A qualified state machine ARN can either refer to a <i>Distributed Map state</i> defined within a state machine, a version ARN, or an alias ARN.</p> <p>The following are some examples of qualified and unqualified state machine ARNs:</p> <ul> <li> <p>The following qualified state machine ARN refers to a <i>Distributed Map state</i> with a label <code>mapStateLabel</code> in a state machine named <code>myStateMachine</code>.</p> <p> <code>arn:partition:states:region:account-id:stateMachine:myStateMachine/mapStateLabel</code> </p> <note> <p>If you provide a qualified state machine ARN that refers to a <i>Distributed Map state</i>, the request fails with <code>ValidationException</code>.</p> </note> </li> <li> <p>The following qualified state machine ARN refers to an alias named <code>PROD</code>.</p> <p> <code>arn:&lt;partition&gt;:states:&lt;region&gt;:&lt;account-id&gt;:stateMachine:&lt;myStateMachine:PROD&gt;</code> </p> <note> <p>If you provide a qualified state machine ARN that refers to a version ARN or an alias ARN, the request starts execution for that version or alias.</p> </note> </li> <li> <p>The following unqualified state machine ARN refers to a state machine named <code>myStateMachine</code>.</p> <p> <code>arn:&lt;partition&gt;:states:&lt;region&gt;:&lt;account-id&gt;:stateMachine:&lt;myStateMachine&gt;</code> </p> </li> </ul> <p>After you update your state machine, you can set the <code>publish</code> parameter to <code>true</code> in the same action to publish a new <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html">version</a>. This way, you can opt-in to strict versioning of your state machine.</p> <note> <p>Step Functions assigns monotonically increasing integers for state machine versions, starting at version number 1.</p> </note> <note> <p>All <code>StartExecution</code> calls within a few seconds use the updated <code>definition</code> and <code>roleArn</code>. Executions started immediately after you call <code>UpdateStateMachine</code> may use the previous state machine <code>definition</code> and <code>roleArn</code>. </p> </note>', 'UpdateStateMachineAlias' => '<p>Updates the configuration of an existing state machine <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html">alias</a> by modifying its <code>description</code> or <code>routingConfiguration</code>.</p> <p>You must specify at least one of the <code>description</code> or <code>routingConfiguration</code> parameters to update a state machine alias.</p> <note> <p> <code>UpdateStateMachineAlias</code> is an idempotent API. Step Functions bases the idempotency check on the <code>stateMachineAliasArn</code>, <code>description</code>, and <code>routingConfiguration</code> parameters. Requests with the same parameters return an idempotent response.</p> </note> <note> <p>This operation is eventually consistent. All <a>StartExecution</a> requests made within a few seconds use the latest alias configuration. Executions started immediately after calling <code>UpdateStateMachineAlias</code> may use the previous routing configuration.</p> </note> <p> <b>Related operations:</b> </p> <ul> <li> <p> <a>CreateStateMachineAlias</a> </p> </li> <li> <p> <a>DescribeStateMachineAlias</a> </p> </li> <li> <p> <a>ListStateMachineAliases</a> </p> </li> <li> <p> <a>DeleteStateMachineAlias</a> </p> </li> </ul>', 'ValidateStateMachineDefinition' => '<p>Validates the syntax of a state machine definition.</p> <p>You can validate that a state machine definition is correct without creating a state machine resource. Step Functions will implicitly perform the same syntax check when you invoke <code>CreateStateMachine</code> and <code>UpdateStateMachine</code>. State machine definitions are specified using a JSON-based, structured language. For more information on Amazon States Language see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States Language</a> (ASL). </p> <p>Suggested uses for <code>ValidateStateMachineDefinition</code>:</p> <ul> <li> <p>Integrate automated checks into your code review or Continuous Integration (CI) process to validate state machine definitions before starting deployments.</p> </li> <li> <p>Run the validation from a Git pre-commit hook to check your state machine definitions before committing them to your source repository.</p> </li> </ul> <note> <p>Errors found in the state machine definition will be returned in the response as a list of <b>diagnostic elements</b>, rather than raise an exception.</p> </note>', ], 'shapes' => [ 'ActivityDoesNotExist' => [ 'base' => '<p>The specified activity does not exist.</p>', 'refs' => [], ], 'ActivityFailedEventDetails' => [ 'base' => '<p>Contains details about an activity that failed during an execution.</p>', 'refs' => [ 'HistoryEvent$activityFailedEventDetails' => NULL, ], ], 'ActivityLimitExceeded' => [ 'base' => '<p>The maximum number of activities has been reached. Existing activities must be deleted before a new activity can be created.</p>', 'refs' => [], ], 'ActivityList' => [ 'base' => NULL, 'refs' => [ 'ListActivitiesOutput$activities' => '<p>The list of activities.</p>', ], ], 'ActivityListItem' => [ 'base' => '<p>Contains details about an activity.</p>', 'refs' => [ 'ActivityList$member' => NULL, ], ], 'ActivityScheduleFailedEventDetails' => [ 'base' => '<p>Contains details about an activity schedule failure that occurred during an execution.</p>', 'refs' => [ 'HistoryEvent$activityScheduleFailedEventDetails' => '<p>Contains details about an activity schedule event that failed during an execution.</p>', ], ], 'ActivityScheduledEventDetails' => [ 'base' => '<p>Contains details about an activity scheduled during an execution.</p>', 'refs' => [ 'HistoryEvent$activityScheduledEventDetails' => NULL, ], ], 'ActivityStartedEventDetails' => [ 'base' => '<p>Contains details about the start of an activity during an execution.</p>', 'refs' => [ 'HistoryEvent$activityStartedEventDetails' => NULL, ], ], 'ActivitySucceededEventDetails' => [ 'base' => '<p>Contains details about an activity that successfully terminated during an execution.</p>', 'refs' => [ 'HistoryEvent$activitySucceededEventDetails' => NULL, ], ], 'ActivityTimedOutEventDetails' => [ 'base' => '<p>Contains details about an activity timeout that occurred during an execution.</p>', 'refs' => [ 'HistoryEvent$activityTimedOutEventDetails' => NULL, ], ], 'ActivityWorkerLimitExceeded' => [ 'base' => '<p>The maximum number of workers concurrently polling for activity tasks has been reached.</p>', 'refs' => [], ], 'AliasDescription' => [ 'base' => NULL, 'refs' => [ 'CreateStateMachineAliasInput$description' => '<p>A description for the state machine alias.</p>', 'DescribeStateMachineAliasOutput$description' => '<p>A description of the alias.</p>', 'UpdateStateMachineAliasInput$description' => '<p>A description of the state machine alias.</p>', ], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'ActivityListItem$activityArn' => '<p>The Amazon Resource Name (ARN) that identifies the activity.</p>', 'ActivityScheduledEventDetails$resource' => '<p>The Amazon Resource Name (ARN) of the scheduled activity.</p>', 'CloudWatchLogsLogGroup$logGroupArn' => '<p>The ARN of the the CloudWatch log group to which you want your logs emitted to. The ARN must end with <code>:*</code> </p>', 'CreateActivityOutput$activityArn' => '<p>The Amazon Resource Name (ARN) that identifies the created activity.</p>', 'CreateStateMachineAliasOutput$stateMachineAliasArn' => '<p>The Amazon Resource Name (ARN) that identifies the created state machine alias.</p>', 'CreateStateMachineInput$roleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role to use for this state machine.</p>', 'CreateStateMachineOutput$stateMachineArn' => '<p>The Amazon Resource Name (ARN) that identifies the created state machine.</p>', 'CreateStateMachineOutput$stateMachineVersionArn' => '<p>The Amazon Resource Name (ARN) that identifies the created state machine version. If you do not set the <code>publish</code> parameter to <code>true</code>, this field returns null value.</p>', 'DeleteActivityInput$activityArn' => '<p>The Amazon Resource Name (ARN) of the activity to delete.</p>', 'DeleteStateMachineAliasInput$stateMachineAliasArn' => '<p>The Amazon Resource Name (ARN) of the state machine alias to delete.</p>', 'DeleteStateMachineInput$stateMachineArn' => '<p>The Amazon Resource Name (ARN) of the state machine to delete.</p>', 'DescribeActivityInput$activityArn' => '<p>The Amazon Resource Name (ARN) of the activity to describe.</p>', 'DescribeActivityOutput$activityArn' => '<p>The Amazon Resource Name (ARN) that identifies the activity.</p>', 'DescribeExecutionInput$executionArn' => '<p>The Amazon Resource Name (ARN) of the execution to describe.</p>', 'DescribeExecutionOutput$executionArn' => '<p>The Amazon Resource Name (ARN) that identifies the execution.</p>', 'DescribeExecutionOutput$stateMachineArn' => '<p>The Amazon Resource Name (ARN) of the executed stated machine.</p>', 'DescribeExecutionOutput$stateMachineVersionArn' => '<p>The Amazon Resource Name (ARN) of the state machine version associated with the execution. The version ARN is a combination of state machine ARN and the version number separated by a colon (:). For example, <code>stateMachineARN:1</code>.</p> <p>If you start an execution from a <code>StartExecution</code> request without specifying a state machine version or alias ARN, Step Functions returns a null value.</p>', 'DescribeExecutionOutput$stateMachineAliasArn' => '<p>The Amazon Resource Name (ARN) of the state machine alias associated with the execution. The alias ARN is a combination of state machine ARN and the alias name separated by a colon (:). For example, <code>stateMachineARN:PROD</code>.</p> <p>If you start an execution from a <code>StartExecution</code> request with a state machine version ARN, this field will be null.</p>', 'DescribeMapRunOutput$executionArn' => '<p>The Amazon Resource Name (ARN) that identifies the execution in which the Map Run was started.</p>', 'DescribeStateMachineAliasInput$stateMachineAliasArn' => '<p>The Amazon Resource Name (ARN) of the state machine alias.</p>', 'DescribeStateMachineAliasOutput$stateMachineAliasArn' => '<p>The Amazon Resource Name (ARN) of the state machine alias.</p>', 'DescribeStateMachineForExecutionInput$executionArn' => '<p>The Amazon Resource Name (ARN) of the execution you want state machine information for.</p>', 'DescribeStateMachineForExecutionOutput$stateMachineArn' => '<p>The Amazon Resource Name (ARN) of the state machine associated with the execution.</p>', 'DescribeStateMachineForExecutionOutput$roleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role of the State Machine for the execution. </p>', 'DescribeStateMachineInput$stateMachineArn' => '<p>The Amazon Resource Name (ARN) of the state machine for which you want the information.</p> <p>If you specify a state machine version ARN, this API returns details about that version. The version ARN is a combination of state machine ARN and the version number separated by a colon (:). For example, <code>stateMachineARN:1</code>.</p>', 'DescribeStateMachineOutput$stateMachineArn' => '<p>The Amazon Resource Name (ARN) that identifies the state machine.</p> <p>If you specified a state machine version ARN in your request, the API returns the version ARN. The version ARN is a combination of state machine ARN and the version number separated by a colon (:). For example, <code>stateMachineARN:1</code>.</p>', 'DescribeStateMachineOutput$roleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role used when creating this state machine. (The IAM role maintains security by granting Step Functions access to Amazon Web Services resources.)</p>', 'ExecutionListItem$executionArn' => '<p>The Amazon Resource Name (ARN) that identifies the execution.</p>', 'ExecutionListItem$stateMachineArn' => '<p>The Amazon Resource Name (ARN) of the state machine that ran the execution.</p>', 'ExecutionListItem$stateMachineVersionArn' => '<p>The Amazon Resource Name (ARN) of the state machine version associated with the execution.</p> <p>If the state machine execution was started with an unqualified ARN, it returns null.</p> <p>If the execution was started using a <code>stateMachineAliasArn</code>, both the <code>stateMachineAliasArn</code> and <code>stateMachineVersionArn</code> parameters contain the respective values.</p>', 'ExecutionListItem$stateMachineAliasArn' => '<p>The Amazon Resource Name (ARN) of the state machine alias used to start an execution.</p> <p>If the state machine execution was started with an unqualified ARN or a version ARN, it returns null.</p>', 'ExecutionStartedEventDetails$roleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role used for executing Lambda tasks.</p>', 'ExecutionStartedEventDetails$stateMachineAliasArn' => '<p>The Amazon Resource Name (ARN) that identifies a state machine alias used for starting the state machine execution.</p>', 'ExecutionStartedEventDetails$stateMachineVersionArn' => '<p>The Amazon Resource Name (ARN) that identifies a state machine version used for starting the state machine execution.</p>', 'GetActivityTaskInput$activityArn' => '<p>The Amazon Resource Name (ARN) of the activity to retrieve tasks from (assigned when you create the task using <a>CreateActivity</a>.)</p>', 'GetExecutionHistoryInput$executionArn' => '<p>The Amazon Resource Name (ARN) of the execution.</p>', 'LambdaFunctionScheduledEventDetails$resource' => '<p>The Amazon Resource Name (ARN) of the scheduled Lambda function.</p>', 'ListExecutionsInput$stateMachineArn' => '<p>The Amazon Resource Name (ARN) of the state machine whose executions is listed.</p> <p>You can specify either a <code>mapRunArn</code> or a <code>stateMachineArn</code>, but not both.</p> <p>You can also return a list of executions associated with a specific <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html">alias</a> or <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html">version</a>, by specifying an alias ARN or a version ARN in the <code>stateMachineArn</code> parameter.</p>', 'ListMapRunsInput$executionArn' => '<p>The Amazon Resource Name (ARN) of the execution for which the Map Runs must be listed.</p>', 'ListStateMachineAliasesInput$stateMachineArn' => '<p>The Amazon Resource Name (ARN) of the state machine for which you want to list aliases.</p> <p>If you specify a state machine version ARN, this API returns a list of aliases for that version.</p>', 'ListStateMachineVersionsInput$stateMachineArn' => '<p>The Amazon Resource Name (ARN) of the state machine.</p>', 'ListTagsForResourceInput$resourceArn' => '<p>The Amazon Resource Name (ARN) for the Step Functions state machine or activity.</p>', 'MapRunListItem$executionArn' => '<p>The <code>executionArn</code> of the execution from which the Map Run was started.</p>', 'MapRunListItem$stateMachineArn' => '<p>The Amazon Resource Name (ARN) of the executed state machine.</p>', 'PublishStateMachineVersionInput$stateMachineArn' => '<p>The Amazon Resource Name (ARN) of the state machine.</p>', 'PublishStateMachineVersionOutput$stateMachineVersionArn' => '<p>The Amazon Resource Name (ARN) (ARN) that identifies the state machine version.</p>', 'RedriveExecutionInput$executionArn' => '<p>The Amazon Resource Name (ARN) of the execution to be redriven.</p>', 'ResourceNotFound$resourceName' => NULL, 'RoutingConfigurationListItem$stateMachineVersionArn' => '<p>The Amazon Resource Name (ARN) that identifies one or two state machine versions defined in the routing configuration.</p> <p>If you specify the ARN of a second version, it must belong to the same state machine as the first version.</p>', 'StartExecutionInput$stateMachineArn' => '<p>The Amazon Resource Name (ARN) of the state machine to execute.</p> <p>The <code>stateMachineArn</code> parameter accepts one of the following inputs:</p> <ul> <li> <p> <b>An unqualified state machine ARN</b> – Refers to a state machine ARN that isn\'t qualified with a version or alias ARN. The following is an example of an unqualified state machine ARN.</p> <p> <code>arn:&lt;partition&gt;:states:&lt;region&gt;:&lt;account-id&gt;:stateMachine:&lt;myStateMachine&gt;</code> </p> <p>Step Functions doesn\'t associate state machine executions that you start with an unqualified ARN with a version. This is true even if that version uses the same revision that the execution used.</p> </li> <li> <p> <b>A state machine version ARN</b> – Refers to a version ARN, which is a combination of state machine ARN and the version number separated by a colon (:). The following is an example of the ARN for version 10. </p> <p> <code>arn:&lt;partition&gt;:states:&lt;region&gt;:&lt;account-id&gt;:stateMachine:&lt;myStateMachine&gt;:10</code> </p> <p>Step Functions doesn\'t associate executions that you start with a version ARN with any aliases that point to that version.</p> </li> <li> <p> <b>A state machine alias ARN</b> – Refers to an alias ARN, which is a combination of state machine ARN and the alias name separated by a colon (:). The following is an example of the ARN for an alias named <code>PROD</code>.</p> <p> <code>arn:&lt;partition&gt;:states:&lt;region&gt;:&lt;account-id&gt;:stateMachine:&lt;myStateMachine:PROD&gt;</code> </p> <p>Step Functions associates executions that you start with an alias ARN with that alias and the state machine version used for that execution.</p> </li> </ul>', 'StartExecutionOutput$executionArn' => '<p>The Amazon Resource Name (ARN) that identifies the execution.</p>', 'StartSyncExecutionInput$stateMachineArn' => '<p>The Amazon Resource Name (ARN) of the state machine to execute.</p>', 'StartSyncExecutionOutput$executionArn' => '<p>The Amazon Resource Name (ARN) that identifies the execution.</p>', 'StartSyncExecutionOutput$stateMachineArn' => '<p>The Amazon Resource Name (ARN) that identifies the state machine.</p>', 'StateMachineListItem$stateMachineArn' => '<p>The Amazon Resource Name (ARN) that identifies the state machine.</p>', 'StopExecutionInput$executionArn' => '<p>The Amazon Resource Name (ARN) of the execution to stop.</p>', 'TagResourceInput$resourceArn' => '<p>The Amazon Resource Name (ARN) for the Step Functions state machine or activity.</p>', 'TestStateInput$roleArn' => '<p>The Amazon Resource Name (ARN) of the execution role with the required IAM permissions for the state.</p>', 'TooManyTags$resourceName' => NULL, 'UntagResourceInput$resourceArn' => '<p>The Amazon Resource Name (ARN) for the Step Functions state machine or activity.</p>', 'UpdateStateMachineAliasInput$stateMachineAliasArn' => '<p>The Amazon Resource Name (ARN) of the state machine alias.</p>', 'UpdateStateMachineInput$stateMachineArn' => '<p>The Amazon Resource Name (ARN) of the state machine.</p>', 'UpdateStateMachineInput$roleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role of the state machine.</p>', 'UpdateStateMachineOutput$stateMachineVersionArn' => '<p>The Amazon Resource Name (ARN) of the published state machine version.</p> <p>If the <code>publish</code> parameter isn\'t set to <code>true</code>, this field returns null.</p>', ], ], 'BilledDuration' => [ 'base' => NULL, 'refs' => [ 'BillingDetails$billedDurationInMilliseconds' => '<p>Billed duration of your workflow, in milliseconds.</p>', ], ], 'BilledMemoryUsed' => [ 'base' => NULL, 'refs' => [ 'BillingDetails$billedMemoryUsedInMB' => '<p>Billed memory consumption of your workflow, in MB.</p>', ], ], 'BillingDetails' => [ 'base' => '<p>An object that describes workflow billing details.</p>', 'refs' => [ 'StartSyncExecutionOutput$billingDetails' => '<p>An object that describes workflow billing details, including billed duration and memory use.</p>', ], ], 'CharacterRestrictedName' => [ 'base' => NULL, 'refs' => [ 'CreateStateMachineAliasInput$name' => '<p>The name of the state machine alias.</p> <p>To avoid conflict with version ARNs, don\'t use an integer in the name of the alias.</p>', ], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'RedriveExecutionInput$clientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify a client token, the Amazon Web Services SDK automatically generates a client token and uses it for the request to ensure idempotency. The API will return idempotent responses for the last 10 client tokens used to successfully redrive the execution. These client tokens are valid for up to 15 minutes after they are first used.</p>', ], ], 'CloudWatchEventsExecutionDataDetails' => [ 'base' => '<p>Provides details about execution input or output.</p>', 'refs' => [ 'DescribeExecutionOutput$inputDetails' => NULL, 'DescribeExecutionOutput$outputDetails' => NULL, 'StartSyncExecutionOutput$inputDetails' => NULL, 'StartSyncExecutionOutput$outputDetails' => NULL, ], ], 'CloudWatchLogsLogGroup' => [ 'base' => '<p/>', 'refs' => [ 'LogDestination$cloudWatchLogsLogGroup' => '<p>An object describing a CloudWatch log group. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-loggroup.html">AWS::Logs::LogGroup</a> in the CloudFormation User Guide.</p>', ], ], 'ConflictException' => [ 'base' => '<p>Updating or deleting a resource can cause an inconsistent state. This error occurs when there\'re concurrent requests for <a>DeleteStateMachineVersion</a>, <a>PublishStateMachineVersion</a>, or <a>UpdateStateMachine</a> with the <code>publish</code> parameter set to <code>true</code>.</p> <p>HTTP Status Code: 409</p>', 'refs' => [], ], 'ConnectorParameters' => [ 'base' => NULL, 'refs' => [ 'TaskScheduledEventDetails$parameters' => '<p>The JSON data passed to the resource referenced in a task state. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>', ], ], 'CreateActivityInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateActivityOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateStateMachineAliasInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateStateMachineAliasOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateStateMachineInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateStateMachineOutput' => [ 'base' => NULL, 'refs' => [], ], 'Definition' => [ 'base' => NULL, 'refs' => [ 'CreateStateMachineInput$definition' => '<p>The Amazon States Language definition of the state machine. See <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States Language</a>.</p>', 'DescribeStateMachineForExecutionOutput$definition' => '<p>The Amazon States Language definition of the state machine. See <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States Language</a>.</p>', 'DescribeStateMachineOutput$definition' => '<p>The Amazon States Language definition of the state machine. See <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States Language</a>.</p>', 'TestStateInput$definition' => '<p>The <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States Language</a> (ASL) definition of the state.</p>', 'UpdateStateMachineInput$definition' => '<p>The Amazon States Language definition of the state machine. See <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States Language</a>.</p>', 'ValidateStateMachineDefinitionInput$definition' => '<p>The Amazon States Language definition of the state machine. For more information, see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States Language</a> (ASL).</p>', ], ], 'DeleteActivityInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteActivityOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStateMachineAliasInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStateMachineAliasOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStateMachineInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStateMachineOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStateMachineVersionInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStateMachineVersionOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeActivityInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeActivityOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeExecutionInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeExecutionOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMapRunInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMapRunOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStateMachineAliasInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStateMachineAliasOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStateMachineForExecutionInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStateMachineForExecutionOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStateMachineInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStateMachineOutput' => [ 'base' => NULL, 'refs' => [], ], 'Enabled' => [ 'base' => NULL, 'refs' => [ 'TracingConfiguration$enabled' => '<p>When set to <code>true</code>, X-Ray tracing is enabled.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'ActivityDoesNotExist$message' => NULL, 'ActivityLimitExceeded$message' => NULL, 'ActivityWorkerLimitExceeded$message' => NULL, 'ConflictException$message' => NULL, 'ExecutionAlreadyExists$message' => NULL, 'ExecutionDoesNotExist$message' => NULL, 'ExecutionLimitExceeded$message' => NULL, 'ExecutionNotRedrivable$message' => NULL, 'InvalidArn$message' => NULL, 'InvalidDefinition$message' => NULL, 'InvalidExecutionInput$message' => NULL, 'InvalidLoggingConfiguration$message' => NULL, 'InvalidName$message' => NULL, 'InvalidOutput$message' => NULL, 'InvalidToken$message' => NULL, 'InvalidTracingConfiguration$message' => NULL, 'MissingRequiredParameter$message' => NULL, 'ResourceNotFound$message' => NULL, 'ServiceQuotaExceededException$message' => NULL, 'StateMachineAlreadyExists$message' => NULL, 'StateMachineDeleting$message' => NULL, 'StateMachineDoesNotExist$message' => NULL, 'StateMachineLimitExceeded$message' => NULL, 'StateMachineTypeNotSupported$message' => NULL, 'TaskDoesNotExist$message' => NULL, 'TaskTimedOut$message' => NULL, 'TooManyTags$message' => NULL, 'ValidationException$message' => NULL, ], ], 'EventId' => [ 'base' => NULL, 'refs' => [ 'HistoryEvent$id' => '<p>The id of the event. Events are numbered sequentially, starting at one.</p>', 'HistoryEvent$previousEventId' => '<p>The id of the previous event.</p>', ], ], 'ExecutionAbortedEventDetails' => [ 'base' => '<p>Contains details about an abort of an execution.</p>', 'refs' => [ 'HistoryEvent$executionAbortedEventDetails' => NULL, ], ], 'ExecutionAlreadyExists' => [ 'base' => '<p>The execution has the same <code>name</code> as another execution (but a different <code>input</code>).</p> <note> <p>Executions with the same <code>name</code> and <code>input</code> are considered idempotent.</p> </note>', 'refs' => [], ], 'ExecutionDoesNotExist' => [ 'base' => '<p>The specified execution does not exist.</p>', 'refs' => [], ], 'ExecutionFailedEventDetails' => [ 'base' => '<p>Contains details about an execution failure event.</p>', 'refs' => [ 'HistoryEvent$executionFailedEventDetails' => NULL, ], ], 'ExecutionLimitExceeded' => [ 'base' => '<p>The maximum number of running executions has been reached. Running executions must end or be stopped before a new execution can be started.</p>', 'refs' => [], ], 'ExecutionList' => [ 'base' => NULL, 'refs' => [ 'ListExecutionsOutput$executions' => '<p>The list of matching executions.</p>', ], ], 'ExecutionListItem' => [ 'base' => '<p>Contains details about an execution.</p>', 'refs' => [ 'ExecutionList$member' => NULL, ], ], 'ExecutionNotRedrivable' => [ 'base' => '<p>The execution Amazon Resource Name (ARN) that you specified for <code>executionArn</code> cannot be redriven.</p>', 'refs' => [], ], 'ExecutionRedriveFilter' => [ 'base' => NULL, 'refs' => [ 'ListExecutionsInput$redriveFilter' => '<p>Sets a filter to list executions based on whether or not they have been redriven.</p> <p>For a Distributed Map, <code>redriveFilter</code> sets a filter to list child workflow executions based on whether or not they have been redriven.</p> <p>If you do not provide a <code>redriveFilter</code>, Step Functions returns a list of both redriven and non-redriven executions.</p> <p>If you provide a state machine ARN in <code>redriveFilter</code>, the API returns a validation exception.</p>', ], ], 'ExecutionRedriveStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeExecutionOutput$redriveStatus' => '<p>Indicates whether or not an execution can be redriven at a given point in time.</p> <ul> <li> <p>For executions of type <code>STANDARD</code>, <code>redriveStatus</code> is <code>NOT_REDRIVABLE</code> if calling the <a>RedriveExecution</a> API action would return the <code>ExecutionNotRedrivable</code> error.</p> </li> <li> <p>For a Distributed Map that includes child workflows of type <code>STANDARD</code>, <code>redriveStatus</code> indicates whether or not the Map Run can redrive child workflow executions.</p> </li> <li> <p>For a Distributed Map that includes child workflows of type <code>EXPRESS</code>, <code>redriveStatus</code> indicates whether or not the Map Run can redrive child workflow executions.</p> <p>You can redrive failed or timed out <code>EXPRESS</code> workflows <i>only if</i> they\'re a part of a Map Run. When you <a href="https://docs.aws.amazon.com/step-functions/latest/dg/redrive-map-run.html">redrive</a> the Map Run, these workflows are restarted using the <a>StartExecution</a> API action.</p> </li> </ul>', ], ], 'ExecutionRedrivenEventDetails' => [ 'base' => '<p>Contains details about a redriven execution.</p>', 'refs' => [ 'HistoryEvent$executionRedrivenEventDetails' => '<p>Contains details about the redrive attempt of an execution.</p>', ], ], 'ExecutionStartedEventDetails' => [ 'base' => '<p>Contains details about the start of the execution.</p>', 'refs' => [ 'HistoryEvent$executionStartedEventDetails' => NULL, ], ], 'ExecutionStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeExecutionOutput$status' => '<p>The current status of the execution.</p>', 'ExecutionListItem$status' => '<p>The current status of the execution.</p>', 'ListExecutionsInput$statusFilter' => '<p>If specified, only list the executions whose current execution status matches the given filter.</p>', ], ], 'ExecutionSucceededEventDetails' => [ 'base' => '<p>Contains details about the successful termination of the execution.</p>', 'refs' => [ 'HistoryEvent$executionSucceededEventDetails' => NULL, ], ], 'ExecutionTimedOutEventDetails' => [ 'base' => '<p>Contains details about the execution timeout that occurred during the execution.</p>', 'refs' => [ 'HistoryEvent$executionTimedOutEventDetails' => NULL, ], ], 'GetActivityTaskInput' => [ 'base' => NULL, 'refs' => [], ], 'GetActivityTaskOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetExecutionHistoryInput' => [ 'base' => NULL, 'refs' => [], ], 'GetExecutionHistoryOutput' => [ 'base' => NULL, 'refs' => [], ], 'HTTPBody' => [ 'base' => NULL, 'refs' => [ 'InspectionDataRequest$body' => '<p>The request body for the HTTP request.</p>', 'InspectionDataResponse$body' => '<p>The HTTP response returned.</p>', ], ], 'HTTPHeaders' => [ 'base' => NULL, 'refs' => [ 'InspectionDataRequest$headers' => '<p>The request headers associated with the HTTP request.</p>', 'InspectionDataResponse$headers' => '<p>The response headers associated with the HTTP response.</p>', ], ], 'HTTPMethod' => [ 'base' => NULL, 'refs' => [ 'InspectionDataRequest$method' => '<p>The HTTP method used for the HTTP request.</p>', ], ], 'HTTPProtocol' => [ 'base' => NULL, 'refs' => [ 'InspectionDataRequest$protocol' => '<p>The protocol used to make the HTTP request.</p>', 'InspectionDataResponse$protocol' => '<p>The protocol used to return the HTTP response.</p>', ], ], 'HTTPStatusCode' => [ 'base' => NULL, 'refs' => [ 'InspectionDataResponse$statusCode' => '<p>The HTTP response status code for the HTTP response.</p>', ], ], 'HTTPStatusMessage' => [ 'base' => NULL, 'refs' => [ 'InspectionDataResponse$statusMessage' => '<p>The message associated with the HTTP status code.</p>', ], ], 'HistoryEvent' => [ 'base' => '<p>Contains details about the events of an execution.</p>', 'refs' => [ 'HistoryEventList$member' => NULL, ], ], 'HistoryEventExecutionDataDetails' => [ 'base' => '<p>Provides details about input or output in an execution history event.</p>', 'refs' => [ 'ActivityScheduledEventDetails$inputDetails' => '<p>Contains details about the input for an execution history event.</p>', 'ActivitySucceededEventDetails$outputDetails' => '<p>Contains details about the output of an execution history event.</p>', 'ExecutionStartedEventDetails$inputDetails' => '<p>Contains details about the input for an execution history event.</p>', 'ExecutionSucceededEventDetails$outputDetails' => '<p>Contains details about the output of an execution history event.</p>', 'LambdaFunctionScheduledEventDetails$inputDetails' => '<p>Contains details about input for an execution history event.</p>', 'LambdaFunctionSucceededEventDetails$outputDetails' => '<p>Contains details about the output of an execution history event.</p>', 'StateEnteredEventDetails$inputDetails' => '<p>Contains details about the input for an execution history event.</p>', 'StateExitedEventDetails$outputDetails' => '<p>Contains details about the output of an execution history event.</p>', 'TaskSubmittedEventDetails$outputDetails' => '<p>Contains details about the output of an execution history event.</p>', 'TaskSucceededEventDetails$outputDetails' => '<p>Contains details about the output of an execution history event.</p>', ], ], 'HistoryEventList' => [ 'base' => '<p>Contains details about the events that occurred during an execution.</p>', 'refs' => [ 'GetExecutionHistoryOutput$events' => '<p>The list of events that occurred in the execution.</p>', ], ], 'HistoryEventType' => [ 'base' => NULL, 'refs' => [ 'HistoryEvent$type' => '<p>The type of the event.</p>', ], ], 'Identity' => [ 'base' => NULL, 'refs' => [ 'ActivityStartedEventDetails$workerName' => '<p>The name of the worker that the task is assigned to. These names are provided by the workers when calling <a>GetActivityTask</a>.</p>', ], ], 'IncludeExecutionData' => [ 'base' => NULL, 'refs' => [ 'LoggingConfiguration$includeExecutionData' => '<p>Determines whether execution data is included in your log. When set to <code>false</code>, data is excluded.</p>', ], ], 'IncludeExecutionDataGetExecutionHistory' => [ 'base' => NULL, 'refs' => [ 'GetExecutionHistoryInput$includeExecutionData' => '<p>You can select whether execution data (input or output of a history event) is returned. The default is <code>true</code>.</p>', ], ], 'InspectionData' => [ 'base' => '<p>Contains additional details about the state\'s execution, including its input and output data processing flow, and HTTP request and response information.</p>', 'refs' => [ 'TestStateOutput$inspectionData' => '<p>Returns additional details about the state\'s execution, including its input and output data processing flow, and HTTP request and response information. The <code>inspectionLevel</code> request parameter specifies which details are returned.</p>', ], ], 'InspectionDataRequest' => [ 'base' => '<p>Contains additional details about the state\'s execution, including its input and output data processing flow, and HTTP request information.</p>', 'refs' => [ 'InspectionData$request' => '<p>The raw HTTP request that is sent when you test an HTTP Task.</p>', ], ], 'InspectionDataResponse' => [ 'base' => '<p>Contains additional details about the state\'s execution, including its input and output data processing flow, and HTTP response information. The <code>inspectionLevel</code> request parameter specifies which details are returned.</p>', 'refs' => [ 'InspectionData$response' => '<p>The raw HTTP response that is returned when you test an HTTP Task.</p>', ], ], 'InspectionLevel' => [ 'base' => NULL, 'refs' => [ 'TestStateInput$inspectionLevel' => '<p>Determines the values to return when a state is tested. You can specify one of the following types:</p> <ul> <li> <p> <code>INFO</code>: Shows the final state output. By default, Step Functions sets <code>inspectionLevel</code> to <code>INFO</code> if you don\'t specify a level.</p> </li> <li> <p> <code>DEBUG</code>: Shows the final state output along with the input and output data processing result.</p> </li> <li> <p> <code>TRACE</code>: Shows the HTTP request and response for an HTTP Task. This level also shows the final state output along with the input and output data processing result.</p> </li> </ul> <p>Each of these levels also provide information about the status of the state execution and the next state to transition to.</p>', ], ], 'InvalidArn' => [ 'base' => '<p>The provided Amazon Resource Name (ARN) is not valid.</p>', 'refs' => [], ], 'InvalidDefinition' => [ 'base' => '<p>The provided Amazon States Language definition is not valid.</p>', 'refs' => [], ], 'InvalidExecutionInput' => [ 'base' => '<p>The provided JSON input data is not valid.</p>', 'refs' => [], ], 'InvalidLoggingConfiguration' => [ 'base' => '<p/>', 'refs' => [], ], 'InvalidName' => [ 'base' => '<p>The provided name is not valid.</p>', 'refs' => [], ], 'InvalidOutput' => [ 'base' => '<p>The provided JSON output data is not valid.</p>', 'refs' => [], ], 'InvalidToken' => [ 'base' => '<p>The provided token is not valid.</p>', 'refs' => [], ], 'InvalidTracingConfiguration' => [ 'base' => '<p>Your <code>tracingConfiguration</code> key does not match, or <code>enabled</code> has not been set to <code>true</code> or <code>false</code>.</p>', 'refs' => [], ], 'LambdaFunctionFailedEventDetails' => [ 'base' => '<p>Contains details about a Lambda function that failed during an execution.</p>', 'refs' => [ 'HistoryEvent$lambdaFunctionFailedEventDetails' => NULL, ], ], 'LambdaFunctionScheduleFailedEventDetails' => [ 'base' => '<p>Contains details about a failed Lambda function schedule event that occurred during an execution.</p>', 'refs' => [ 'HistoryEvent$lambdaFunctionScheduleFailedEventDetails' => NULL, ], ], 'LambdaFunctionScheduledEventDetails' => [ 'base' => '<p>Contains details about a Lambda function scheduled during an execution.</p>', 'refs' => [ 'HistoryEvent$lambdaFunctionScheduledEventDetails' => NULL, ], ], 'LambdaFunctionStartFailedEventDetails' => [ 'base' => '<p>Contains details about a lambda function that failed to start during an execution.</p>', 'refs' => [ 'HistoryEvent$lambdaFunctionStartFailedEventDetails' => '<p>Contains details about a lambda function that failed to start during an execution.</p>', ], ], 'LambdaFunctionSucceededEventDetails' => [ 'base' => '<p>Contains details about a Lambda function that successfully terminated during an execution.</p>', 'refs' => [ 'HistoryEvent$lambdaFunctionSucceededEventDetails' => '<p>Contains details about a Lambda function that terminated successfully during an execution.</p>', ], ], 'LambdaFunctionTimedOutEventDetails' => [ 'base' => '<p>Contains details about a Lambda function timeout that occurred during an execution.</p>', 'refs' => [ 'HistoryEvent$lambdaFunctionTimedOutEventDetails' => NULL, ], ], 'ListActivitiesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListActivitiesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListExecutionsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListExecutionsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListExecutionsPageToken' => [ 'base' => NULL, 'refs' => [ 'ListExecutionsInput$nextToken' => '<p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>', 'ListExecutionsOutput$nextToken' => '<p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>', ], ], 'ListMapRunsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListMapRunsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListStateMachineAliasesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListStateMachineAliasesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListStateMachineVersionsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListStateMachineVersionsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListStateMachinesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListStateMachinesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'LogDestination' => [ 'base' => '<p/>', 'refs' => [ 'LogDestinationList$member' => NULL, ], ], 'LogDestinationList' => [ 'base' => NULL, 'refs' => [ 'LoggingConfiguration$destinations' => '<p>An array of objects that describes where your execution history events will be logged. Limited to size 1. Required, if your log level is not set to <code>OFF</code>.</p>', ], ], 'LogLevel' => [ 'base' => NULL, 'refs' => [ 'LoggingConfiguration$level' => '<p>Defines which category of execution history events are logged.</p>', ], ], 'LoggingConfiguration' => [ 'base' => '<p>The <code>LoggingConfiguration</code> data type is used to set CloudWatch Logs options.</p>', 'refs' => [ 'CreateStateMachineInput$loggingConfiguration' => '<p>Defines what execution history events are logged and where they are logged.</p> <note> <p>By default, the <code>level</code> is set to <code>OFF</code>. For more information see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/cloudwatch-log-level.html">Log Levels</a> in the Step Functions User Guide.</p> </note>', 'DescribeStateMachineForExecutionOutput$loggingConfiguration' => NULL, 'DescribeStateMachineOutput$loggingConfiguration' => NULL, 'UpdateStateMachineInput$loggingConfiguration' => '<p>Use the <code>LoggingConfiguration</code> data type to set CloudWatch Logs options.</p>', ], ], 'LongArn' => [ 'base' => NULL, 'refs' => [ 'DeleteStateMachineVersionInput$stateMachineVersionArn' => '<p>The Amazon Resource Name (ARN) of the state machine version to delete.</p>', 'DescribeExecutionOutput$mapRunArn' => '<p>The Amazon Resource Name (ARN) that identifies a Map Run, which dispatched this execution.</p>', 'DescribeMapRunInput$mapRunArn' => '<p>The Amazon Resource Name (ARN) that identifies a Map Run.</p>', 'DescribeMapRunOutput$mapRunArn' => '<p>The Amazon Resource Name (ARN) that identifies a Map Run.</p>', 'DescribeStateMachineForExecutionOutput$mapRunArn' => '<p>The Amazon Resource Name (ARN) of the Map Run that started the child workflow execution. This field is returned only if the <code>executionArn</code> is a child workflow execution that was started by a Distributed Map state.</p>', 'ExecutionListItem$mapRunArn' => '<p>The Amazon Resource Name (ARN) of a Map Run. This field is returned only if <code>mapRunArn</code> was specified in the <code>ListExecutions</code> API action. If <code>stateMachineArn</code> was specified in <code>ListExecutions</code>, the <code>mapRunArn</code> isn\'t returned.</p>', 'ListExecutionsInput$mapRunArn' => '<p>The Amazon Resource Name (ARN) of the Map Run that started the child workflow executions. If the <code>mapRunArn</code> field is specified, a list of all of the child workflow executions started by a Map Run is returned. For more information, see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-examine-map-run.html">Examining Map Run</a> in the <i>Step Functions Developer Guide</i>.</p> <p>You can specify either a <code>mapRunArn</code> or a <code>stateMachineArn</code>, but not both.</p>', 'MapRunListItem$mapRunArn' => '<p>The Amazon Resource Name (ARN) of the Map Run.</p>', 'MapRunRedrivenEventDetails$mapRunArn' => '<p>The Amazon Resource Name (ARN) of a Map Run that was redriven.</p>', 'MapRunStartedEventDetails$mapRunArn' => '<p>The Amazon Resource Name (ARN) of a Map Run that was started.</p>', 'StateMachineAliasListItem$stateMachineAliasArn' => '<p>The Amazon Resource Name (ARN) that identifies a state machine alias. The alias ARN is a combination of state machine ARN and the alias name separated by a colon (:). For example, <code>stateMachineARN:PROD</code>.</p>', 'StateMachineVersionListItem$stateMachineVersionArn' => '<p>The Amazon Resource Name (ARN) that identifies a state machine version. The version ARN is a combination of state machine ARN and the version number separated by a colon (:). For example, <code>stateMachineARN:1</code>.</p>', 'TaskCredentials$roleArn' => '<p>The ARN of an IAM role that Step Functions assumes for the task. The role can allow cross-account access to resources.</p>', 'UpdateMapRunInput$mapRunArn' => '<p>The Amazon Resource Name (ARN) of a Map Run.</p>', ], ], 'LongObject' => [ 'base' => NULL, 'refs' => [ 'MapRunExecutionCounts$failuresNotRedrivable' => '<p>The number of <code>FAILED</code>, <code>ABORTED</code>, or <code>TIMED_OUT</code> child workflow executions that cannot be redriven because their execution status is terminal. For example, child workflows with an execution status of <code>FAILED</code>, <code>ABORTED</code>, or <code>TIMED_OUT</code> and a <code>redriveStatus</code> of <code>NOT_REDRIVABLE</code>.</p>', 'MapRunExecutionCounts$pendingRedrive' => '<p>The number of unsuccessful child workflow executions currently waiting to be redriven. The status of these child workflow executions could be <code>FAILED</code>, <code>ABORTED</code>, or <code>TIMED_OUT</code> in the original execution attempt or a previous redrive attempt.</p>', 'MapRunItemCounts$failuresNotRedrivable' => '<p>The number of <code>FAILED</code>, <code>ABORTED</code>, or <code>TIMED_OUT</code> items in child workflow executions that cannot be redriven because the execution status of those child workflows is terminal. For example, child workflows with an execution status of <code>FAILED</code>, <code>ABORTED</code>, or <code>TIMED_OUT</code> and a <code>redriveStatus</code> of <code>NOT_REDRIVABLE</code>.</p>', 'MapRunItemCounts$pendingRedrive' => '<p>The number of unsuccessful items in child workflow executions currently waiting to be redriven.</p>', ], ], 'MapIterationEventDetails' => [ 'base' => '<p>Contains details about an iteration of a Map state.</p>', 'refs' => [ 'HistoryEvent$mapIterationStartedEventDetails' => '<p>Contains details about an iteration of a Map state that was started.</p>', 'HistoryEvent$mapIterationSucceededEventDetails' => '<p>Contains details about an iteration of a Map state that succeeded.</p>', 'HistoryEvent$mapIterationFailedEventDetails' => '<p>Contains details about an iteration of a Map state that failed.</p>', 'HistoryEvent$mapIterationAbortedEventDetails' => '<p>Contains details about an iteration of a Map state that was aborted.</p>', ], ], 'MapRunExecutionCounts' => [ 'base' => '<p>Contains details about all of the child workflow executions started by a Map Run.</p>', 'refs' => [ 'DescribeMapRunOutput$executionCounts' => '<p>A JSON object that contains information about the total number of child workflow executions for the Map Run, and the count of child workflow executions for each status, such as <code>failed</code> and <code>succeeded</code>.</p>', ], ], 'MapRunFailedEventDetails' => [ 'base' => '<p>Contains details about a Map Run failure event that occurred during a state machine execution.</p>', 'refs' => [ 'HistoryEvent$mapRunFailedEventDetails' => '<p>Contains error and cause details about a Map Run that failed.</p>', ], ], 'MapRunItemCounts' => [ 'base' => '<p>Contains details about items that were processed in all of the child workflow executions that were started by a Map Run.</p>', 'refs' => [ 'DescribeMapRunOutput$itemCounts' => '<p>A JSON object that contains information about the total number of items, and the item count for each processing status, such as <code>pending</code> and <code>failed</code>.</p>', ], ], 'MapRunLabel' => [ 'base' => NULL, 'refs' => [ 'DescribeStateMachineForExecutionOutput$label' => '<p>A user-defined or an auto-generated string that identifies a <code>Map</code> state. This ﬁeld is returned only if the <code>executionArn</code> is a child workflow execution that was started by a Distributed Map state.</p>', 'DescribeStateMachineOutput$label' => '<p>A user-defined or an auto-generated string that identifies a <code>Map</code> state. This parameter is present only if the <code>stateMachineArn</code> specified in input is a qualified state machine ARN.</p>', ], ], 'MapRunList' => [ 'base' => NULL, 'refs' => [ 'ListMapRunsOutput$mapRuns' => '<p>An array that lists information related to a Map Run, such as the Amazon Resource Name (ARN) of the Map Run and the ARN of the state machine that started the Map Run.</p>', ], ], 'MapRunListItem' => [ 'base' => '<p>Contains details about a specific Map Run.</p>', 'refs' => [ 'MapRunList$member' => NULL, ], ], 'MapRunRedrivenEventDetails' => [ 'base' => '<p>Contains details about a Map Run that was redriven.</p>', 'refs' => [ 'HistoryEvent$mapRunRedrivenEventDetails' => '<p>Contains details about the redrive attempt of a Map Run.</p>', ], ], 'MapRunStartedEventDetails' => [ 'base' => '<p>Contains details about a Map Run that was started during a state machine execution.</p>', 'refs' => [ 'HistoryEvent$mapRunStartedEventDetails' => '<p>Contains details, such as <code>mapRunArn</code>, and the start date and time of a Map Run. <code>mapRunArn</code> is the Amazon Resource Name (ARN) of the Map Run that was started.</p>', ], ], 'MapRunStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeMapRunOutput$status' => '<p>The current status of the Map Run.</p>', ], ], 'MapStateStartedEventDetails' => [ 'base' => '<p>Details about a Map state that was started.</p>', 'refs' => [ 'HistoryEvent$mapStateStartedEventDetails' => '<p>Contains details about Map state that was started.</p>', ], ], 'MaxConcurrency' => [ 'base' => NULL, 'refs' => [ 'DescribeMapRunOutput$maxConcurrency' => '<p>The maximum number of child workflow executions configured to run in parallel for the Map Run at the same time.</p>', 'UpdateMapRunInput$maxConcurrency' => '<p>The maximum number of child workflow executions that can be specified to run in parallel for the Map Run at the same time.</p>', ], ], 'MissingRequiredParameter' => [ 'base' => '<p>Request is missing a required parameter. This error occurs if both <code>definition</code> and <code>roleArn</code> are not specified.</p>', 'refs' => [], ], 'Name' => [ 'base' => NULL, 'refs' => [ 'ActivityListItem$name' => '<p>The name of the activity.</p> <p>A name must <i>not</i> contain:</p> <ul> <li> <p>white space</p> </li> <li> <p>brackets <code>&lt; &gt; { } [ ]</code> </p> </li> <li> <p>wildcard characters <code>? *</code> </p> </li> <li> <p>special characters <code>" # % \\ ^ | ~ ` $ &amp; , ; : /</code> </p> </li> <li> <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p> </li> </ul> <p>To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.</p>', 'CreateActivityInput$name' => '<p>The name of the activity to create. This name must be unique for your Amazon Web Services account and region for 90 days. For more information, see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/limits.html#service-limits-state-machine-executions"> Limits Related to State Machine Executions</a> in the <i>Step Functions Developer Guide</i>.</p> <p>A name must <i>not</i> contain:</p> <ul> <li> <p>white space</p> </li> <li> <p>brackets <code>&lt; &gt; { } [ ]</code> </p> </li> <li> <p>wildcard characters <code>? *</code> </p> </li> <li> <p>special characters <code>" # % \\ ^ | ~ ` $ &amp; , ; : /</code> </p> </li> <li> <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p> </li> </ul> <p>To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.</p>', 'CreateStateMachineInput$name' => '<p>The name of the state machine. </p> <p>A name must <i>not</i> contain:</p> <ul> <li> <p>white space</p> </li> <li> <p>brackets <code>&lt; &gt; { } [ ]</code> </p> </li> <li> <p>wildcard characters <code>? *</code> </p> </li> <li> <p>special characters <code>" # % \\ ^ | ~ ` $ &amp; , ; : /</code> </p> </li> <li> <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p> </li> </ul> <p>To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.</p>', 'DescribeActivityOutput$name' => '<p>The name of the activity.</p> <p>A name must <i>not</i> contain:</p> <ul> <li> <p>white space</p> </li> <li> <p>brackets <code>&lt; &gt; { } [ ]</code> </p> </li> <li> <p>wildcard characters <code>? *</code> </p> </li> <li> <p>special characters <code>" # % \\ ^ | ~ ` $ &amp; , ; : /</code> </p> </li> <li> <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p> </li> </ul> <p>To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.</p>', 'DescribeExecutionOutput$name' => '<p>The name of the execution.</p> <p>A name must <i>not</i> contain:</p> <ul> <li> <p>white space</p> </li> <li> <p>brackets <code>&lt; &gt; { } [ ]</code> </p> </li> <li> <p>wildcard characters <code>? *</code> </p> </li> <li> <p>special characters <code>" # % \\ ^ | ~ ` $ &amp; , ; : /</code> </p> </li> <li> <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p> </li> </ul> <p>To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.</p>', 'DescribeStateMachineAliasOutput$name' => '<p>The name of the state machine alias.</p>', 'DescribeStateMachineForExecutionOutput$name' => '<p>The name of the state machine associated with the execution.</p>', 'DescribeStateMachineOutput$name' => '<p>The name of the state machine.</p> <p>A name must <i>not</i> contain:</p> <ul> <li> <p>white space</p> </li> <li> <p>brackets <code>&lt; &gt; { } [ ]</code> </p> </li> <li> <p>wildcard characters <code>? *</code> </p> </li> <li> <p>special characters <code>" # % \\ ^ | ~ ` $ &amp; , ; : /</code> </p> </li> <li> <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p> </li> </ul> <p>To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.</p>', 'ExecutionListItem$name' => '<p>The name of the execution.</p> <p>A name must <i>not</i> contain:</p> <ul> <li> <p>white space</p> </li> <li> <p>brackets <code>&lt; &gt; { } [ ]</code> </p> </li> <li> <p>wildcard characters <code>? *</code> </p> </li> <li> <p>special characters <code>" # % \\ ^ | ~ ` $ &amp; , ; : /</code> </p> </li> <li> <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p> </li> </ul> <p>To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.</p>', 'GetActivityTaskInput$workerName' => '<p>You can provide an arbitrary name in order to identify the worker that the task is assigned to. This name is used when it is logged in the execution history.</p>', 'MapIterationEventDetails$name' => '<p>The name of the iteration’s parent Map state.</p>', 'StartExecutionInput$name' => '<p>Optional name of the execution. This name must be unique for your Amazon Web Services account, Region, and state machine for 90 days. For more information, see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/limits.html#service-limits-state-machine-executions"> Limits Related to State Machine Executions</a> in the <i>Step Functions Developer Guide</i>.</p> <p>If you don\'t provide a name for the execution, Step Functions automatically generates a universally unique identifier (UUID) as the execution name.</p> <p>A name must <i>not</i> contain:</p> <ul> <li> <p>white space</p> </li> <li> <p>brackets <code>&lt; &gt; { } [ ]</code> </p> </li> <li> <p>wildcard characters <code>? *</code> </p> </li> <li> <p>special characters <code>" # % \\ ^ | ~ ` $ &amp; , ; : /</code> </p> </li> <li> <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p> </li> </ul> <p>To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.</p>', 'StartSyncExecutionInput$name' => '<p>The name of the execution.</p>', 'StartSyncExecutionOutput$name' => '<p>The name of the execution.</p>', 'StateEnteredEventDetails$name' => '<p>The name of the state.</p>', 'StateExitedEventDetails$name' => '<p>The name of the state.</p> <p>A name must <i>not</i> contain:</p> <ul> <li> <p>white space</p> </li> <li> <p>brackets <code>&lt; &gt; { } [ ]</code> </p> </li> <li> <p>wildcard characters <code>? *</code> </p> </li> <li> <p>special characters <code>" # % \\ ^ | ~ ` $ &amp; , ; : /</code> </p> </li> <li> <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p> </li> </ul> <p>To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.</p>', 'StateMachineListItem$name' => '<p>The name of the state machine.</p> <p>A name must <i>not</i> contain:</p> <ul> <li> <p>white space</p> </li> <li> <p>brackets <code>&lt; &gt; { } [ ]</code> </p> </li> <li> <p>wildcard characters <code>? *</code> </p> </li> <li> <p>special characters <code>" # % \\ ^ | ~ ` $ &amp; , ; : /</code> </p> </li> <li> <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p> </li> </ul> <p>To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.</p>', 'TaskFailedEventDetails$resourceType' => '<p>The service name of the resource in a task state.</p>', 'TaskFailedEventDetails$resource' => '<p>The action of the resource called by a task state.</p>', 'TaskScheduledEventDetails$resourceType' => '<p>The service name of the resource in a task state.</p>', 'TaskScheduledEventDetails$resource' => '<p>The action of the resource called by a task state.</p>', 'TaskScheduledEventDetails$region' => '<p>The region of the scheduled task</p>', 'TaskStartFailedEventDetails$resourceType' => '<p>The service name of the resource in a task state.</p>', 'TaskStartFailedEventDetails$resource' => '<p>The action of the resource called by a task state.</p>', 'TaskStartedEventDetails$resourceType' => '<p>The service name of the resource in a task state.</p>', 'TaskStartedEventDetails$resource' => '<p>The action of the resource called by a task state.</p>', 'TaskSubmitFailedEventDetails$resourceType' => '<p>The service name of the resource in a task state.</p>', 'TaskSubmitFailedEventDetails$resource' => '<p>The action of the resource called by a task state.</p>', 'TaskSubmittedEventDetails$resourceType' => '<p>The service name of the resource in a task state.</p>', 'TaskSubmittedEventDetails$resource' => '<p>The action of the resource called by a task state.</p>', 'TaskSucceededEventDetails$resourceType' => '<p>The service name of the resource in a task state.</p>', 'TaskSucceededEventDetails$resource' => '<p>The action of the resource called by a task state.</p>', 'TaskTimedOutEventDetails$resourceType' => '<p>The service name of the resource in a task state.</p>', 'TaskTimedOutEventDetails$resource' => '<p>The action of the resource called by a task state.</p>', ], ], 'PageSize' => [ 'base' => NULL, 'refs' => [ 'GetExecutionHistoryInput$maxResults' => '<p>The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain further pages of results. The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default.</p> <p>This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum.</p>', 'ListActivitiesInput$maxResults' => '<p>The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain further pages of results. The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default.</p> <p>This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum.</p>', 'ListExecutionsInput$maxResults' => '<p>The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain further pages of results. The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default.</p> <p>This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum.</p>', 'ListMapRunsInput$maxResults' => '<p>The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain further pages of results. The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default.</p> <p>This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum.</p>', 'ListStateMachineAliasesInput$maxResults' => '<p>The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain further pages of results. The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default.</p> <p>This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum.</p>', 'ListStateMachineVersionsInput$maxResults' => '<p>The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain further pages of results. The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default.</p> <p>This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum.</p>', 'ListStateMachinesInput$maxResults' => '<p>The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain further pages of results. The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default.</p> <p>This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum.</p>', ], ], 'PageToken' => [ 'base' => NULL, 'refs' => [ 'GetExecutionHistoryInput$nextToken' => '<p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>', 'GetExecutionHistoryOutput$nextToken' => '<p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>', 'ListActivitiesInput$nextToken' => '<p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>', 'ListActivitiesOutput$nextToken' => '<p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>', 'ListMapRunsInput$nextToken' => '<p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>', 'ListMapRunsOutput$nextToken' => '<p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>', 'ListStateMachineAliasesInput$nextToken' => '<p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>', 'ListStateMachineAliasesOutput$nextToken' => '<p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>', 'ListStateMachineVersionsInput$nextToken' => '<p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>', 'ListStateMachineVersionsOutput$nextToken' => '<p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>', 'ListStateMachinesInput$nextToken' => '<p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>', 'ListStateMachinesOutput$nextToken' => '<p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>', ], ], 'Publish' => [ 'base' => NULL, 'refs' => [ 'CreateStateMachineInput$publish' => '<p>Set to <code>true</code> to publish the first version of the state machine during creation. The default is <code>false</code>.</p>', 'UpdateStateMachineInput$publish' => '<p>Specifies whether the state machine version is published. The default is <code>false</code>. To publish a version after updating the state machine, set <code>publish</code> to <code>true</code>.</p>', ], ], 'PublishStateMachineVersionInput' => [ 'base' => NULL, 'refs' => [], ], 'PublishStateMachineVersionOutput' => [ 'base' => NULL, 'refs' => [], ], 'RedriveCount' => [ 'base' => NULL, 'refs' => [ 'DescribeExecutionOutput$redriveCount' => '<p>The number of times you\'ve redriven an execution. If you have not yet redriven an execution, the <code>redriveCount</code> is 0. This count is only updated if you successfully redrive an execution.</p>', 'DescribeMapRunOutput$redriveCount' => '<p>The number of times you\'ve redriven a Map Run. If you have not yet redriven a Map Run, the <code>redriveCount</code> is 0. This count is only updated if you successfully redrive a Map Run.</p>', 'ExecutionListItem$redriveCount' => '<p>The number of times you\'ve redriven an execution. If you have not yet redriven an execution, the <code>redriveCount</code> is 0. This count is only updated when you successfully redrive an execution.</p>', 'ExecutionRedrivenEventDetails$redriveCount' => '<p>The number of times you\'ve redriven an execution. If you have not yet redriven an execution, the <code>redriveCount</code> is 0. This count is not updated for redrives that failed to start or are pending to be redriven.</p>', 'MapRunRedrivenEventDetails$redriveCount' => '<p>The number of times the Map Run has been redriven at this point in the execution\'s history including this event. The redrive count for a redriven Map Run is always greater than 0.</p>', ], ], 'RedriveExecutionInput' => [ 'base' => NULL, 'refs' => [], ], 'RedriveExecutionOutput' => [ 'base' => NULL, 'refs' => [], ], 'ResourceNotFound' => [ 'base' => '<p>Could not find the referenced resource.</p>', 'refs' => [], ], 'RevealSecrets' => [ 'base' => NULL, 'refs' => [ 'TestStateInput$revealSecrets' => '<p>Specifies whether or not to include secret information in the test result. For HTTP Tasks, a secret includes the data that an EventBridge connection adds to modify the HTTP request headers, query parameters, and body. Step Functions doesn\'t omit any information included in the state definition or the HTTP response.</p> <p>If you set <code>revealSecrets</code> to <code>true</code>, you must make sure that the IAM user that calls the <code>TestState</code> API has permission for the <code>states:RevealSecrets</code> action. For an example of IAM policy that sets the <code>states:RevealSecrets</code> permission, see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/test-state-isolation.html#test-state-permissions">IAM permissions to test a state</a>. Without this permission, Step Functions throws an access denied error.</p> <p>By default, <code>revealSecrets</code> is set to <code>false</code>.</p>', ], ], 'ReverseOrder' => [ 'base' => NULL, 'refs' => [ 'GetExecutionHistoryInput$reverseOrder' => '<p>Lists events in descending order of their <code>timeStamp</code>.</p>', ], ], 'RevisionId' => [ 'base' => NULL, 'refs' => [ 'DescribeStateMachineForExecutionOutput$revisionId' => '<p>The revision identifier for the state machine. The first revision ID when you create the state machine is null.</p> <p>Use the state machine <code>revisionId</code> parameter to compare the revision of a state machine with the configuration of the state machine used for executions without performing a diff of the properties, such as <code>definition</code> and <code>roleArn</code>.</p>', 'DescribeStateMachineOutput$revisionId' => '<p>The revision identifier for the state machine.</p> <p>Use the <code>revisionId</code> parameter to compare between versions of a state machine configuration used for executions without performing a diff of the properties, such as <code>definition</code> and <code>roleArn</code>.</p>', 'PublishStateMachineVersionInput$revisionId' => '<p>Only publish the state machine version if the current state machine\'s revision ID matches the specified ID.</p> <p>Use this option to avoid publishing a version if the state machine changed since you last updated it. If the specified revision ID doesn\'t match the state machine\'s current revision ID, the API returns <code>ConflictException</code>.</p> <note> <p>To specify an initial revision ID for a state machine with no revision ID assigned, specify the string <code>INITIAL</code> for the <code>revisionId</code> parameter. For example, you can specify a <code>revisionID</code> of <code>INITIAL</code> when you create a state machine using the <a>CreateStateMachine</a> API action.</p> </note>', 'UpdateStateMachineOutput$revisionId' => '<p>The revision identifier for the updated state machine.</p>', ], ], 'RoutingConfigurationList' => [ 'base' => NULL, 'refs' => [ 'CreateStateMachineAliasInput$routingConfiguration' => '<p>The routing configuration of a state machine alias. The routing configuration shifts execution traffic between two state machine versions. <code>routingConfiguration</code> contains an array of <code>RoutingConfig</code> objects that specify up to two state machine versions. Step Functions then randomly choses which version to run an execution with based on the weight assigned to each <code>RoutingConfig</code>.</p>', 'DescribeStateMachineAliasOutput$routingConfiguration' => '<p>The routing configuration of the alias.</p>', 'UpdateStateMachineAliasInput$routingConfiguration' => '<p>The routing configuration of the state machine alias.</p> <p>An array of <code>RoutingConfig</code> objects that specifies up to two state machine versions that the alias starts executions for.</p>', ], ], 'RoutingConfigurationListItem' => [ 'base' => '<p>Contains details about the routing configuration of a state machine alias. In a routing configuration, you define an array of objects that specify up to two state machine versions. You also specify the percentage of traffic to be routed to each version.</p>', 'refs' => [ 'RoutingConfigurationList$member' => NULL, ], ], 'SendTaskFailureInput' => [ 'base' => NULL, 'refs' => [], ], 'SendTaskFailureOutput' => [ 'base' => NULL, 'refs' => [], ], 'SendTaskHeartbeatInput' => [ 'base' => NULL, 'refs' => [], ], 'SendTaskHeartbeatOutput' => [ 'base' => NULL, 'refs' => [], ], 'SendTaskSuccessInput' => [ 'base' => NULL, 'refs' => [], ], 'SendTaskSuccessOutput' => [ 'base' => NULL, 'refs' => [], ], 'SensitiveCause' => [ 'base' => NULL, 'refs' => [ 'ActivityFailedEventDetails$cause' => '<p>A more detailed explanation of the cause of the failure.</p>', 'ActivityScheduleFailedEventDetails$cause' => '<p>A more detailed explanation of the cause of the failure.</p>', 'ActivityTimedOutEventDetails$cause' => '<p>A more detailed explanation of the cause of the timeout.</p>', 'DescribeExecutionOutput$cause' => '<p>The cause string if the state machine execution failed.</p>', 'ExecutionAbortedEventDetails$cause' => '<p>A more detailed explanation of the cause of the failure.</p>', 'ExecutionFailedEventDetails$cause' => '<p>A more detailed explanation of the cause of the failure.</p>', 'ExecutionTimedOutEventDetails$cause' => '<p>A more detailed explanation of the cause of the timeout.</p>', 'LambdaFunctionFailedEventDetails$cause' => '<p>A more detailed explanation of the cause of the failure.</p>', 'LambdaFunctionScheduleFailedEventDetails$cause' => '<p>A more detailed explanation of the cause of the failure.</p>', 'LambdaFunctionStartFailedEventDetails$cause' => '<p>A more detailed explanation of the cause of the failure.</p>', 'LambdaFunctionTimedOutEventDetails$cause' => '<p>A more detailed explanation of the cause of the timeout.</p>', 'MapRunFailedEventDetails$cause' => '<p>A more detailed explanation of the cause of the failure.</p>', 'SendTaskFailureInput$cause' => '<p>A more detailed explanation of the cause of the failure.</p>', 'StartSyncExecutionOutput$cause' => '<p>A more detailed explanation of the cause of the failure.</p>', 'StopExecutionInput$cause' => '<p>A more detailed explanation of the cause of the failure.</p>', 'TaskFailedEventDetails$cause' => '<p>A more detailed explanation of the cause of the failure.</p>', 'TaskStartFailedEventDetails$cause' => '<p>A more detailed explanation of the cause of the failure.</p>', 'TaskSubmitFailedEventDetails$cause' => '<p>A more detailed explanation of the cause of the failure.</p>', 'TaskTimedOutEventDetails$cause' => '<p>A more detailed explanation of the cause of the failure.</p>', 'TestStateOutput$cause' => '<p>A detailed explanation of the cause for the error when the execution of a state fails.</p>', ], ], 'SensitiveData' => [ 'base' => NULL, 'refs' => [ 'ActivityScheduledEventDetails$input' => '<p>The JSON data input to the activity task. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>', 'ActivitySucceededEventDetails$output' => '<p>The JSON data output by the activity task. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>', 'DescribeExecutionOutput$input' => '<p>The string that contains the JSON input data of the execution. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>', 'DescribeExecutionOutput$output' => '<p>The JSON output data of the execution. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p> <note> <p>This field is set only if the execution succeeds. If the execution fails, this field is null.</p> </note>', 'DescribeExecutionOutput$redriveStatusReason' => '<p>When <code>redriveStatus</code> is <code>NOT_REDRIVABLE</code>, <code>redriveStatusReason</code> specifies the reason why an execution cannot be redriven.</p> <ul> <li> <p>For executions of type <code>STANDARD</code>, or for a Distributed Map that includes child workflows of type <code>STANDARD</code>, <code>redriveStatusReason</code> can include one of the following reasons:</p> <ul> <li> <p> <code>State machine is in DELETING status</code>.</p> </li> <li> <p> <code>Execution is RUNNING and cannot be redriven</code>.</p> </li> <li> <p> <code>Execution is SUCCEEDED and cannot be redriven</code>.</p> </li> <li> <p> <code>Execution was started before the launch of RedriveExecution</code>.</p> </li> <li> <p> <code>Execution history event limit exceeded</code>.</p> </li> <li> <p> <code>Execution has exceeded the max execution time</code>.</p> </li> <li> <p> <code>Execution redrivable period exceeded</code>.</p> </li> </ul> </li> <li> <p>For a Distributed Map that includes child workflows of type <code>EXPRESS</code>, <code>redriveStatusReason</code> is only returned if the child workflows are not redrivable. This happens when the child workflow executions have completed successfully.</p> </li> </ul>', 'ExecutionStartedEventDetails$input' => '<p>The JSON data input to the execution. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>', 'ExecutionSucceededEventDetails$output' => '<p>The JSON data output by the execution. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>', 'InspectionData$input' => '<p>The raw state input.</p>', 'InspectionData$afterInputPath' => '<p>The input after Step Functions applies the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-inputpath">InputPath</a> filter.</p>', 'InspectionData$afterParameters' => '<p>The effective input after Step Functions applies the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-parameters">Parameters</a> filter.</p>', 'InspectionData$result' => '<p>The state\'s raw result.</p>', 'InspectionData$afterResultSelector' => '<p>The effective result after Step Functions applies the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-resultselector">ResultSelector</a> filter.</p>', 'InspectionData$afterResultPath' => '<p>The effective result combined with the raw state input after Step Functions applies the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-resultpath.html">ResultPath</a> filter.</p>', 'LambdaFunctionScheduledEventDetails$input' => '<p>The JSON data input to the Lambda function. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>', 'LambdaFunctionSucceededEventDetails$output' => '<p>The JSON data output by the Lambda function. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>', 'SendTaskSuccessInput$output' => '<p>The JSON output of the task. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>', 'StartExecutionInput$input' => '<p>The string that contains the JSON input data for the execution, for example:</p> <p> <code>"input": "{\\"first_name\\" : \\"test\\"}"</code> </p> <note> <p>If you don\'t include any JSON input data, you still must include the two braces, for example: <code>"input": "{}"</code> </p> </note> <p>Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>', 'StartSyncExecutionInput$input' => '<p>The string that contains the JSON input data for the execution, for example:</p> <p> <code>"input": "{\\"first_name\\" : \\"test\\"}"</code> </p> <note> <p>If you don\'t include any JSON input data, you still must include the two braces, for example: <code>"input": "{}"</code> </p> </note> <p>Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>', 'StartSyncExecutionOutput$input' => '<p>The string that contains the JSON input data of the execution. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>', 'StartSyncExecutionOutput$output' => '<p>The JSON output data of the execution. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p> <note> <p>This field is set only if the execution succeeds. If the execution fails, this field is null.</p> </note>', 'StateEnteredEventDetails$input' => '<p>The string that contains the JSON input data for the state. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>', 'StateExitedEventDetails$output' => '<p>The JSON output data of the state. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>', 'TaskSubmittedEventDetails$output' => '<p>The response from a resource when a task has started. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>', 'TaskSucceededEventDetails$output' => '<p>The full JSON response from a resource when a task has succeeded. This response becomes the output of the related task. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>', 'TestStateInput$input' => '<p>A string that contains the JSON input data for the state.</p>', 'TestStateOutput$output' => '<p>The JSON output data of the state. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>', ], ], 'SensitiveDataJobInput' => [ 'base' => NULL, 'refs' => [ 'GetActivityTaskOutput$input' => '<p>The string that contains the JSON input data for the task. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.</p>', ], ], 'SensitiveError' => [ 'base' => NULL, 'refs' => [ 'ActivityFailedEventDetails$error' => '<p>The error code of the failure.</p>', 'ActivityScheduleFailedEventDetails$error' => '<p>The error code of the failure.</p>', 'ActivityTimedOutEventDetails$error' => '<p>The error code of the failure.</p>', 'DescribeExecutionOutput$error' => '<p>The error string if the state machine execution failed.</p>', 'ExecutionAbortedEventDetails$error' => '<p>The error code of the failure.</p>', 'ExecutionFailedEventDetails$error' => '<p>The error code of the failure.</p>', 'ExecutionTimedOutEventDetails$error' => '<p>The error code of the failure.</p>', 'LambdaFunctionFailedEventDetails$error' => '<p>The error code of the failure.</p>', 'LambdaFunctionScheduleFailedEventDetails$error' => '<p>The error code of the failure.</p>', 'LambdaFunctionStartFailedEventDetails$error' => '<p>The error code of the failure.</p>', 'LambdaFunctionTimedOutEventDetails$error' => '<p>The error code of the failure.</p>', 'MapRunFailedEventDetails$error' => '<p>The error code of the Map Run failure.</p>', 'SendTaskFailureInput$error' => '<p>The error code of the failure.</p>', 'StartSyncExecutionOutput$error' => '<p>The error code of the failure.</p>', 'StopExecutionInput$error' => '<p>The error code of the failure.</p>', 'TaskFailedEventDetails$error' => '<p>The error code of the failure.</p>', 'TaskStartFailedEventDetails$error' => '<p>The error code of the failure.</p>', 'TaskSubmitFailedEventDetails$error' => '<p>The error code of the failure.</p>', 'TaskTimedOutEventDetails$error' => '<p>The error code of the failure.</p>', 'TestStateOutput$error' => '<p>The error returned when the execution of a state fails.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>The request would cause a service quota to be exceeded.</p> <p>HTTP Status Code: 402</p>', 'refs' => [], ], 'StartExecutionInput' => [ 'base' => NULL, 'refs' => [], ], 'StartExecutionOutput' => [ 'base' => NULL, 'refs' => [], ], 'StartSyncExecutionInput' => [ 'base' => NULL, 'refs' => [], ], 'StartSyncExecutionOutput' => [ 'base' => NULL, 'refs' => [], ], 'StateEnteredEventDetails' => [ 'base' => '<p>Contains details about a state entered during an execution.</p>', 'refs' => [ 'HistoryEvent$stateEnteredEventDetails' => NULL, ], ], 'StateExitedEventDetails' => [ 'base' => '<p>Contains details about an exit from a state during an execution.</p>', 'refs' => [ 'HistoryEvent$stateExitedEventDetails' => NULL, ], ], 'StateMachineAliasList' => [ 'base' => NULL, 'refs' => [ 'ListStateMachineAliasesOutput$stateMachineAliases' => '<p>Aliases for the state machine.</p>', ], ], 'StateMachineAliasListItem' => [ 'base' => '<p>Contains details about a specific state machine alias.</p>', 'refs' => [ 'StateMachineAliasList$member' => NULL, ], ], 'StateMachineAlreadyExists' => [ 'base' => '<p>A state machine with the same name but a different definition or role ARN already exists.</p>', 'refs' => [], ], 'StateMachineDeleting' => [ 'base' => '<p>The specified state machine is being deleted.</p>', 'refs' => [], ], 'StateMachineDoesNotExist' => [ 'base' => '<p>The specified state machine does not exist.</p>', 'refs' => [], ], 'StateMachineLimitExceeded' => [ 'base' => '<p>The maximum number of state machines has been reached. Existing state machines must be deleted before a new state machine can be created.</p>', 'refs' => [], ], 'StateMachineList' => [ 'base' => NULL, 'refs' => [ 'ListStateMachinesOutput$stateMachines' => NULL, ], ], 'StateMachineListItem' => [ 'base' => '<p>Contains details about the state machine.</p>', 'refs' => [ 'StateMachineList$member' => NULL, ], ], 'StateMachineStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeStateMachineOutput$status' => '<p>The current status of the state machine.</p>', ], ], 'StateMachineType' => [ 'base' => NULL, 'refs' => [ 'CreateStateMachineInput$type' => '<p>Determines whether a Standard or Express state machine is created. The default is <code>STANDARD</code>. You cannot update the <code>type</code> of a state machine once it has been created.</p>', 'DescribeStateMachineOutput$type' => '<p>The <code>type</code> of the state machine (<code>STANDARD</code> or <code>EXPRESS</code>).</p>', 'StateMachineListItem$type' => '<p/>', 'ValidateStateMachineDefinitionInput$type' => '<p>The target type of state machine for this definition. The default is <code>STANDARD</code>.</p>', ], ], 'StateMachineTypeNotSupported' => [ 'base' => '<p/>', 'refs' => [], ], 'StateMachineVersionList' => [ 'base' => NULL, 'refs' => [ 'ListStateMachineVersionsOutput$stateMachineVersions' => '<p>Versions for the state machine.</p>', ], ], 'StateMachineVersionListItem' => [ 'base' => '<p>Contains details about a specific state machine version.</p>', 'refs' => [ 'StateMachineVersionList$member' => NULL, ], ], 'StateName' => [ 'base' => NULL, 'refs' => [ 'TestStateOutput$nextState' => '<p>The name of the next state to transition to. If you haven\'t defined a next state in your definition or if the execution of the state fails, this ﬁeld doesn\'t contain a value.</p>', ], ], 'StopExecutionInput' => [ 'base' => NULL, 'refs' => [], ], 'StopExecutionOutput' => [ 'base' => NULL, 'refs' => [], ], 'SyncExecutionStatus' => [ 'base' => NULL, 'refs' => [ 'StartSyncExecutionOutput$status' => '<p>The current status of the execution.</p>', ], ], 'Tag' => [ 'base' => '<p>Tags are key-value pairs that can be associated with Step Functions state machines and activities.</p> <p>An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>, and <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html">Controlling Access Using IAM Tags</a>.</p> <p>Tags may only contain Unicode letters, digits, white space, or these symbols: <code>_ . : / = + - @</code>.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$key' => '<p>The key of a tag.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceInput$tagKeys' => '<p>The list of tags to remove from the resource.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateActivityInput$tags' => '<p>The list of tags to add to a resource.</p> <p>An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>, and <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html">Controlling Access Using IAM Tags</a>.</p> <p>Tags may only contain Unicode letters, digits, white space, or these symbols: <code>_ . : / = + - @</code>.</p>', 'CreateStateMachineInput$tags' => '<p>Tags to be added when creating a state machine.</p> <p>An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>, and <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html">Controlling Access Using IAM Tags</a>.</p> <p>Tags may only contain Unicode letters, digits, white space, or these symbols: <code>_ . : / = + - @</code>.</p>', 'ListTagsForResourceOutput$tags' => '<p>An array of tags associated with the resource.</p>', 'TagResourceInput$tags' => '<p>The list of tags to add to a resource.</p> <p>Tags may only contain Unicode letters, digits, white space, or these symbols: <code>_ . : / = + - @</code>.</p>', ], ], 'TagResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$value' => '<p>The value of a tag.</p>', ], ], 'TaskCredentials' => [ 'base' => '<p>Contains details about the credentials that Step Functions uses for a task.</p>', 'refs' => [ 'LambdaFunctionScheduledEventDetails$taskCredentials' => '<p>The credentials that Step Functions uses for the task.</p>', 'TaskScheduledEventDetails$taskCredentials' => '<p>The credentials that Step Functions uses for the task.</p>', ], ], 'TaskDoesNotExist' => [ 'base' => '<p>The activity does not exist.</p>', 'refs' => [], ], 'TaskFailedEventDetails' => [ 'base' => '<p>Contains details about a task failure event.</p>', 'refs' => [ 'HistoryEvent$taskFailedEventDetails' => '<p>Contains details about the failure of a task.</p>', ], ], 'TaskScheduledEventDetails' => [ 'base' => '<p>Contains details about a task scheduled during an execution.</p>', 'refs' => [ 'HistoryEvent$taskScheduledEventDetails' => '<p>Contains details about a task that was scheduled.</p>', ], ], 'TaskStartFailedEventDetails' => [ 'base' => '<p>Contains details about a task that failed to start during an execution.</p>', 'refs' => [ 'HistoryEvent$taskStartFailedEventDetails' => '<p>Contains details about a task that failed to start.</p>', ], ], 'TaskStartedEventDetails' => [ 'base' => '<p>Contains details about the start of a task during an execution.</p>', 'refs' => [ 'HistoryEvent$taskStartedEventDetails' => '<p>Contains details about a task that was started.</p>', ], ], 'TaskSubmitFailedEventDetails' => [ 'base' => '<p>Contains details about a task that failed to submit during an execution.</p>', 'refs' => [ 'HistoryEvent$taskSubmitFailedEventDetails' => '<p>Contains details about a task that where the submit failed.</p>', ], ], 'TaskSubmittedEventDetails' => [ 'base' => '<p>Contains details about a task submitted to a resource .</p>', 'refs' => [ 'HistoryEvent$taskSubmittedEventDetails' => '<p>Contains details about a submitted task.</p>', ], ], 'TaskSucceededEventDetails' => [ 'base' => '<p>Contains details about the successful completion of a task state.</p>', 'refs' => [ 'HistoryEvent$taskSucceededEventDetails' => '<p>Contains details about a task that succeeded.</p>', ], ], 'TaskTimedOut' => [ 'base' => '<p>The task token has either expired or the task associated with the token has already been closed.</p>', 'refs' => [], ], 'TaskTimedOutEventDetails' => [ 'base' => '<p>Contains details about a resource timeout that occurred during an execution.</p>', 'refs' => [ 'HistoryEvent$taskTimedOutEventDetails' => '<p>Contains details about a task that timed out.</p>', ], ], 'TaskToken' => [ 'base' => NULL, 'refs' => [ 'GetActivityTaskOutput$taskToken' => '<p>A token that identifies the scheduled task. This token must be copied and included in subsequent calls to <a>SendTaskHeartbeat</a>, <a>SendTaskSuccess</a> or <a>SendTaskFailure</a> in order to report the progress or completion of the task.</p>', 'SendTaskFailureInput$taskToken' => '<p>The token that represents this task. Task tokens are generated by Step Functions when tasks are assigned to a worker, or in the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-contextobject.html">context object</a> when a workflow enters a task state. See <a>GetActivityTaskOutput$taskToken</a>.</p>', 'SendTaskHeartbeatInput$taskToken' => '<p>The token that represents this task. Task tokens are generated by Step Functions when tasks are assigned to a worker, or in the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-contextobject.html">context object</a> when a workflow enters a task state. See <a>GetActivityTaskOutput$taskToken</a>.</p>', 'SendTaskSuccessInput$taskToken' => '<p>The token that represents this task. Task tokens are generated by Step Functions when tasks are assigned to a worker, or in the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-contextobject.html">context object</a> when a workflow enters a task state. See <a>GetActivityTaskOutput$taskToken</a>.</p>', ], ], 'TestExecutionStatus' => [ 'base' => NULL, 'refs' => [ 'TestStateOutput$status' => '<p>The execution status of the state.</p>', ], ], 'TestStateInput' => [ 'base' => NULL, 'refs' => [], ], 'TestStateOutput' => [ 'base' => NULL, 'refs' => [], ], 'TimeoutInSeconds' => [ 'base' => NULL, 'refs' => [ 'ActivityScheduledEventDetails$timeoutInSeconds' => '<p>The maximum allowed duration of the activity task.</p>', 'ActivityScheduledEventDetails$heartbeatInSeconds' => '<p>The maximum allowed duration between two heartbeats for the activity task.</p>', 'LambdaFunctionScheduledEventDetails$timeoutInSeconds' => '<p>The maximum allowed duration of the Lambda function.</p>', 'TaskScheduledEventDetails$timeoutInSeconds' => '<p>The maximum allowed duration of the task.</p>', 'TaskScheduledEventDetails$heartbeatInSeconds' => '<p>The maximum allowed duration between two heartbeats for the task.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'ActivityListItem$creationDate' => '<p>The date the activity is created.</p>', 'CreateActivityOutput$creationDate' => '<p>The date the activity is created.</p>', 'CreateStateMachineAliasOutput$creationDate' => '<p>The date the state machine alias was created.</p>', 'CreateStateMachineOutput$creationDate' => '<p>The date the state machine is created.</p>', 'DescribeActivityOutput$creationDate' => '<p>The date the activity is created.</p>', 'DescribeExecutionOutput$startDate' => '<p>The date the execution is started.</p>', 'DescribeExecutionOutput$stopDate' => '<p>If the execution ended, the date the execution stopped.</p>', 'DescribeExecutionOutput$redriveDate' => '<p>The date the execution was last redriven. If you have not yet redriven an execution, the <code>redriveDate</code> is null.</p> <p>The <code>redriveDate</code> is unavailable if you redrive a Map Run that starts child workflow executions of type <code>EXPRESS</code>.</p>', 'DescribeMapRunOutput$startDate' => '<p>The date when the Map Run was started.</p>', 'DescribeMapRunOutput$stopDate' => '<p>The date when the Map Run was stopped.</p>', 'DescribeMapRunOutput$redriveDate' => '<p>The date a Map Run was last redriven. If you have not yet redriven a Map Run, the <code>redriveDate</code> is null.</p>', 'DescribeStateMachineAliasOutput$creationDate' => '<p>The date the state machine alias was created.</p>', 'DescribeStateMachineAliasOutput$updateDate' => '<p>The date the state machine alias was last updated.</p> <p>For a newly created state machine, this is the same as the creation date.</p>', 'DescribeStateMachineForExecutionOutput$updateDate' => '<p>The date and time the state machine associated with an execution was updated. For a newly created state machine, this is the creation date.</p>', 'DescribeStateMachineOutput$creationDate' => '<p>The date the state machine is created.</p> <p>For a state machine version, <code>creationDate</code> is the date the version was created.</p>', 'ExecutionListItem$startDate' => '<p>The date the execution started.</p>', 'ExecutionListItem$stopDate' => '<p>If the execution already ended, the date the execution stopped.</p>', 'ExecutionListItem$redriveDate' => '<p>The date the execution was last redriven.</p>', 'HistoryEvent$timestamp' => '<p>The date and time the event occurred.</p>', 'MapRunListItem$startDate' => '<p>The date on which the Map Run started.</p>', 'MapRunListItem$stopDate' => '<p>The date on which the Map Run stopped.</p>', 'PublishStateMachineVersionOutput$creationDate' => '<p>The date the version was created.</p>', 'RedriveExecutionOutput$redriveDate' => '<p>The date the execution was last redriven.</p>', 'StartExecutionOutput$startDate' => '<p>The date the execution is started.</p>', 'StartSyncExecutionOutput$startDate' => '<p>The date the execution is started.</p>', 'StartSyncExecutionOutput$stopDate' => '<p>If the execution has already ended, the date the execution stopped.</p>', 'StateMachineAliasListItem$creationDate' => '<p>The creation date of a state machine alias.</p>', 'StateMachineListItem$creationDate' => '<p>The date the state machine is created.</p>', 'StateMachineVersionListItem$creationDate' => '<p>The creation date of a state machine version.</p>', 'StopExecutionOutput$stopDate' => '<p>The date the execution is stopped.</p>', 'UpdateStateMachineAliasOutput$updateDate' => '<p>The date and time the state machine alias was updated.</p>', 'UpdateStateMachineOutput$updateDate' => '<p>The date and time the state machine was updated.</p>', ], ], 'ToleratedFailureCount' => [ 'base' => NULL, 'refs' => [ 'DescribeMapRunOutput$toleratedFailureCount' => '<p>The maximum number of failed child workflow executions before the Map Run fails.</p>', 'UpdateMapRunInput$toleratedFailureCount' => '<p>The maximum number of failed items before the Map Run fails.</p>', ], ], 'ToleratedFailurePercentage' => [ 'base' => NULL, 'refs' => [ 'DescribeMapRunOutput$toleratedFailurePercentage' => '<p>The maximum percentage of failed child workflow executions before the Map Run fails.</p>', 'UpdateMapRunInput$toleratedFailurePercentage' => '<p>The maximum percentage of failed items before the Map Run fails.</p>', ], ], 'TooManyTags' => [ 'base' => '<p>You\'ve exceeded the number of tags allowed for a resource. See the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/limits.html"> Limits Topic</a> in the Step Functions Developer Guide.</p>', 'refs' => [], ], 'TraceHeader' => [ 'base' => NULL, 'refs' => [ 'DescribeExecutionOutput$traceHeader' => '<p>The X-Ray trace header that was passed to the execution.</p>', 'StartExecutionInput$traceHeader' => '<p>Passes the X-Ray trace header. The trace header can also be passed in the request payload.</p>', 'StartSyncExecutionInput$traceHeader' => '<p>Passes the X-Ray trace header. The trace header can also be passed in the request payload.</p>', 'StartSyncExecutionOutput$traceHeader' => '<p>The X-Ray trace header that was passed to the execution.</p>', ], ], 'TracingConfiguration' => [ 'base' => '<p>Selects whether or not the state machine\'s X-Ray tracing is enabled. Default is <code>false</code> </p>', 'refs' => [ 'CreateStateMachineInput$tracingConfiguration' => '<p>Selects whether X-Ray tracing is enabled.</p>', 'DescribeStateMachineForExecutionOutput$tracingConfiguration' => '<p>Selects whether X-Ray tracing is enabled.</p>', 'DescribeStateMachineOutput$tracingConfiguration' => '<p>Selects whether X-Ray tracing is enabled.</p>', 'UpdateStateMachineInput$tracingConfiguration' => '<p>Selects whether X-Ray tracing is enabled.</p>', ], ], 'URL' => [ 'base' => NULL, 'refs' => [ 'InspectionDataRequest$url' => '<p>The API endpoint used for the HTTP request.</p>', ], ], 'UnsignedInteger' => [ 'base' => NULL, 'refs' => [ 'ExecutionListItem$itemCount' => '<p>The total number of items processed in a child workflow execution. This field is returned only if <code>mapRunArn</code> was specified in the <code>ListExecutions</code> API action. If <code>stateMachineArn</code> was specified in <code>ListExecutions</code>, the <code>itemCount</code> field isn\'t returned.</p>', 'MapIterationEventDetails$index' => '<p>The index of the array belonging to the Map state iteration.</p>', 'MapStateStartedEventDetails$length' => '<p>The size of the array for Map state iterations.</p>', ], ], 'UnsignedLong' => [ 'base' => NULL, 'refs' => [ 'MapRunExecutionCounts$pending' => '<p>The total number of child workflow executions that were started by a Map Run, but haven\'t started executing yet. </p>', 'MapRunExecutionCounts$running' => '<p>The total number of child workflow executions that were started by a Map Run and are currently in-progress.</p>', 'MapRunExecutionCounts$succeeded' => '<p>The total number of child workflow executions that were started by a Map Run and have completed successfully.</p>', 'MapRunExecutionCounts$failed' => '<p>The total number of child workflow executions that were started by a Map Run, but have failed.</p>', 'MapRunExecutionCounts$timedOut' => '<p>The total number of child workflow executions that were started by a Map Run and have timed out.</p>', 'MapRunExecutionCounts$aborted' => '<p>The total number of child workflow executions that were started by a Map Run and were running, but were either stopped by the user or by Step Functions because the Map Run failed. </p>', 'MapRunExecutionCounts$total' => '<p>The total number of child workflow executions that were started by a Map Run.</p>', 'MapRunExecutionCounts$resultsWritten' => '<p>Returns the count of child workflow executions whose results were written by <code>ResultWriter</code>. For more information, see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-resultwriter.html">ResultWriter</a> in the <i>Step Functions Developer Guide</i>.</p>', 'MapRunItemCounts$pending' => '<p>The total number of items to process in child workflow executions that haven\'t started running yet.</p>', 'MapRunItemCounts$running' => '<p>The total number of items being processed in child workflow executions that are currently in-progress.</p>', 'MapRunItemCounts$succeeded' => '<p>The total number of items processed in child workflow executions that have completed successfully.</p>', 'MapRunItemCounts$failed' => '<p>The total number of items processed in child workflow executions that have failed.</p>', 'MapRunItemCounts$timedOut' => '<p>The total number of items processed in child workflow executions that have timed out.</p>', 'MapRunItemCounts$aborted' => '<p>The total number of items processed in child workflow executions that were either stopped by the user or by Step Functions, because the Map Run failed.</p>', 'MapRunItemCounts$total' => '<p>The total number of items processed in all the child workflow executions started by a Map Run.</p>', 'MapRunItemCounts$resultsWritten' => '<p>Returns the count of items whose results were written by <code>ResultWriter</code>. For more information, see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-resultwriter.html">ResultWriter</a> in the <i>Step Functions Developer Guide</i>.</p>', ], ], 'UntagResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMapRunInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMapRunOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateStateMachineAliasInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateStateMachineAliasOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateStateMachineInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateStateMachineOutput' => [ 'base' => NULL, 'refs' => [], ], 'ValidateStateMachineDefinitionCode' => [ 'base' => NULL, 'refs' => [ 'ValidateStateMachineDefinitionDiagnostic$code' => '<p>Identifying code for the diagnostic.</p>', ], ], 'ValidateStateMachineDefinitionDiagnostic' => [ 'base' => '<p>Describes an error found during validation. Validation errors found in the definition return in the response as <b>diagnostic elements</b>, rather than raise an exception.</p>', 'refs' => [ 'ValidateStateMachineDefinitionDiagnosticList$member' => NULL, ], ], 'ValidateStateMachineDefinitionDiagnosticList' => [ 'base' => NULL, 'refs' => [ 'ValidateStateMachineDefinitionOutput$diagnostics' => '<p>If the result is <code>OK</code>, this field will be empty. When there are errors, this field will contain an array of <b>Diagnostic</b> objects to help you troubleshoot.</p>', ], ], 'ValidateStateMachineDefinitionInput' => [ 'base' => NULL, 'refs' => [], ], 'ValidateStateMachineDefinitionLocation' => [ 'base' => NULL, 'refs' => [ 'ValidateStateMachineDefinitionDiagnostic$location' => '<p>Location of the issue in the state machine, if available.</p> <p>For errors specific to a field, the location could be in the format: <code>/States/&lt;StateName&gt;/&lt;FieldName&gt;</code>, for example: <code>/States/FailState/ErrorPath</code>.</p>', ], ], 'ValidateStateMachineDefinitionMessage' => [ 'base' => NULL, 'refs' => [ 'ValidateStateMachineDefinitionDiagnostic$message' => '<p>Message describing the diagnostic condition.</p>', ], ], 'ValidateStateMachineDefinitionOutput' => [ 'base' => NULL, 'refs' => [], ], 'ValidateStateMachineDefinitionResultCode' => [ 'base' => NULL, 'refs' => [ 'ValidateStateMachineDefinitionOutput$result' => '<p>The result value will be <code>OK</code> when no syntax errors are found, or <code>FAIL</code> if the workflow definition does not pass verification.</p>', ], ], 'ValidateStateMachineDefinitionSeverity' => [ 'base' => NULL, 'refs' => [ 'ValidateStateMachineDefinitionDiagnostic$severity' => '<p>A value of <code>ERROR</code> means that you cannot create or update a state machine with this definition.</p>', ], ], 'ValidationException' => [ 'base' => '<p>The input does not satisfy the constraints specified by an Amazon Web Services service.</p>', 'refs' => [], ], 'ValidationExceptionReason' => [ 'base' => NULL, 'refs' => [ 'ValidationException$reason' => '<p>The input does not satisfy the constraints specified by an Amazon Web Services service.</p>', ], ], 'VersionDescription' => [ 'base' => NULL, 'refs' => [ 'CreateStateMachineInput$versionDescription' => '<p>Sets description about the state machine version. You can only set the description if the <code>publish</code> parameter is set to <code>true</code>. Otherwise, if you set <code>versionDescription</code>, but <code>publish</code> to <code>false</code>, this API action throws <code>ValidationException</code>.</p>', 'DescribeStateMachineOutput$description' => '<p>The description of the state machine version.</p>', 'PublishStateMachineVersionInput$description' => '<p>An optional description of the state machine version.</p>', 'UpdateStateMachineInput$versionDescription' => '<p>An optional description of the state machine version to publish.</p> <p>You can only specify the <code>versionDescription</code> parameter if you\'ve set <code>publish</code> to <code>true</code>.</p>', ], ], 'VersionWeight' => [ 'base' => NULL, 'refs' => [ 'RoutingConfigurationListItem$weight' => '<p>The percentage of traffic you want to route to a state machine version. The sum of the weights in the routing configuration must be equal to 100.</p>', ], ], 'includedDetails' => [ 'base' => NULL, 'refs' => [ 'CloudWatchEventsExecutionDataDetails$included' => '<p>Indicates whether input or output was included in the response. Always <code>true</code> for API calls. </p>', ], ], 'truncated' => [ 'base' => NULL, 'refs' => [ 'HistoryEventExecutionDataDetails$truncated' => '<p>Indicates whether input or output was truncated in the response. Always <code>false</code> for API calls.</p>', ], ], ],];
