<?php
// This file was auto-generated from sdk-root/src/data/vpc-lattice/2022-11-30/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Amazon VPC Lattice is a fully managed application networking service that you use to connect, secure, and monitor all of your services across multiple accounts and virtual private clouds (VPCs). Amazon VPC Lattice interconnects your microservices and legacy services within a logical boundary, so that you can discover and manage them more efficiently. For more information, see the <a href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/">Amazon VPC Lattice User Guide</a> </p>', 'operations' => [ 'BatchUpdateRule' => '<p>Updates the listener rules in a batch. You can use this operation to change the priority of listener rules. This can be useful when bulk updating or swapping rule priority.</p> <p> <b>Required permissions:</b> <code>vpc-lattice:UpdateRule</code> </p> <p>For more information, see <a href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/security_iam_service-with-iam.html">How Amazon VPC Lattice works with IAM</a> in the <i>Amazon VPC Lattice User Guide</i>.</p>', 'CreateAccessLogSubscription' => '<p>Enables access logs to be sent to Amazon CloudWatch, Amazon S3, and Amazon Kinesis Data Firehose. The service network owner can use the access logs to audit the services in the network. The service network owner can only see access logs from clients and services that are associated with their service network. Access log entries represent traffic originated from VPCs associated with that network. For more information, see <a href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/monitoring-access-logs.html">Access logs</a> in the <i>Amazon VPC Lattice User Guide</i>.</p>', 'CreateListener' => '<p>Creates a listener for a service. Before you start using your Amazon VPC Lattice service, you must add one or more listeners. A listener is a process that checks for connection requests to your services. For more information, see <a href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/listeners.html">Listeners</a> in the <i>Amazon VPC Lattice User Guide</i>.</p>', 'CreateRule' => '<p>Creates a listener rule. Each listener has a default rule for checking connection requests, but you can define additional rules. Each rule consists of a priority, one or more actions, and one or more conditions. For more information, see <a href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/listeners.html#listener-rules">Listener rules</a> in the <i>Amazon VPC Lattice User Guide</i>.</p>', 'CreateService' => '<p>Creates a service. A service is any software application that can run on instances containers, or serverless functions within an account or virtual private cloud (VPC).</p> <p>For more information, see <a href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/services.html">Services</a> in the <i>Amazon VPC Lattice User Guide</i>.</p>', 'CreateServiceNetwork' => '<p>Creates a service network. A service network is a logical boundary for a collection of services. You can associate services and VPCs with a service network.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/service-networks.html">Service networks</a> in the <i>Amazon VPC Lattice User Guide</i>.</p>', 'CreateServiceNetworkServiceAssociation' => '<p>Associates a service with a service network. For more information, see <a href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/service-network-associations.html#service-network-service-associations">Manage service associations</a> in the <i>Amazon VPC Lattice User Guide</i>.</p> <p>You can\'t use this operation if the service and service network are already associated or if there is a disassociation or deletion in progress. If the association fails, you can retry the operation by deleting the association and recreating it.</p> <p>You cannot associate a service and service network that are shared with a caller. The caller must own either the service or the service network.</p> <p>As a result of this operation, the association is created in the service network account and the association owner account.</p>', 'CreateServiceNetworkVpcAssociation' => '<p>Associates a VPC with a service network. When you associate a VPC with the service network, it enables all the resources within that VPC to be clients and communicate with other services in the service network. For more information, see <a href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/service-network-associations.html#service-network-vpc-associations">Manage VPC associations</a> in the <i>Amazon VPC Lattice User Guide</i>.</p> <p>You can\'t use this operation if there is a disassociation in progress. If the association fails, retry by deleting the association and recreating it.</p> <p>As a result of this operation, the association gets created in the service network account and the VPC owner account.</p> <p>If you add a security group to the service network and VPC association, the association must continue to always have at least one security group. You can add or edit security groups at any time. However, to remove all security groups, you must first delete the association and recreate it without security groups.</p>', 'CreateTargetGroup' => '<p>Creates a target group. A target group is a collection of targets, or compute resources, that run your application or service. A target group can only be used by a single service.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/target-groups.html">Target groups</a> in the <i>Amazon VPC Lattice User Guide</i>.</p>', 'DeleteAccessLogSubscription' => '<p>Deletes the specified access log subscription.</p>', 'DeleteAuthPolicy' => '<p>Deletes the specified auth policy. If an auth is set to <code>AWS_IAM</code> and the auth policy is deleted, all requests are denied. If you are trying to remove the auth policy completely, you must set the auth type to <code>NONE</code>. If auth is enabled on the resource, but no auth policy is set, all requests are denied.</p>', 'DeleteListener' => '<p>Deletes the specified listener.</p>', 'DeleteResourcePolicy' => '<p>Deletes the specified resource policy.</p>', 'DeleteRule' => '<p>Deletes a listener rule. Each listener has a default rule for checking connection requests, but you can define additional rules. Each rule consists of a priority, one or more actions, and one or more conditions. You can delete additional listener rules, but you cannot delete the default rule.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/listeners.html#listener-rules">Listener rules</a> in the <i>Amazon VPC Lattice User Guide</i>.</p>', 'DeleteService' => '<p>Deletes a service. A service can\'t be deleted if it\'s associated with a service network. If you delete a service, all resources related to the service, such as the resource policy, auth policy, listeners, listener rules, and access log subscriptions, are also deleted. For more information, see <a href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/services.html#delete-service">Delete a service</a> in the <i>Amazon VPC Lattice User Guide</i>.</p>', 'DeleteServiceNetwork' => '<p>Deletes a service network. You can only delete the service network if there is no service or VPC associated with it. If you delete a service network, all resources related to the service network, such as the resource policy, auth policy, and access log subscriptions, are also deleted. For more information, see <a href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/service-networks.html#delete-service-network">Delete a service network</a> in the <i>Amazon VPC Lattice User Guide</i>.</p>', 'DeleteServiceNetworkServiceAssociation' => '<p>Deletes the association between a specified service and the specific service network. This operation fails if an association is still in progress.</p>', 'DeleteServiceNetworkVpcAssociation' => '<p>Disassociates the VPC from the service network. You can\'t disassociate the VPC if there is a create or update association in progress.</p>', 'DeleteTargetGroup' => '<p>Deletes a target group. You can\'t delete a target group if it is used in a listener rule or if the target group creation is in progress.</p>', 'DeregisterTargets' => '<p>Deregisters the specified targets from the specified target group.</p>', 'GetAccessLogSubscription' => '<p>Retrieves information about the specified access log subscription.</p>', 'GetAuthPolicy' => '<p>Retrieves information about the auth policy for the specified service or service network.</p>', 'GetListener' => '<p>Retrieves information about the specified listener for the specified service.</p>', 'GetResourcePolicy' => '<p>Retrieves information about the resource policy. The resource policy is an IAM policy created on behalf of the resource owner when they share a resource.</p>', 'GetRule' => '<p>Retrieves information about listener rules. You can also retrieve information about the default listener rule. For more information, see <a href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/listeners.html#listener-rules">Listener rules</a> in the <i>Amazon VPC Lattice User Guide</i>.</p>', 'GetService' => '<p>Retrieves information about the specified service.</p>', 'GetServiceNetwork' => '<p>Retrieves information about the specified service network.</p>', 'GetServiceNetworkServiceAssociation' => '<p>Retrieves information about the specified association between a service network and a service.</p>', 'GetServiceNetworkVpcAssociation' => '<p>Retrieves information about the association between a service network and a VPC.</p>', 'GetTargetGroup' => '<p>Retrieves information about the specified target group.</p>', 'ListAccessLogSubscriptions' => '<p>Lists all access log subscriptions for the specified service network or service.</p>', 'ListListeners' => '<p>Lists the listeners for the specified service.</p>', 'ListRules' => '<p>Lists the rules for the listener.</p>', 'ListServiceNetworkServiceAssociations' => '<p>Lists the associations between the service network and the service. You can filter the list either by service or service network. You must provide either the service network identifier or the service identifier.</p> <p>Every association in Amazon VPC Lattice is given a unique Amazon Resource Name (ARN), such as when a service network is associated with a VPC or when a service is associated with a service network. If the association is for a resource that is shared with another account, the association includes the local account ID as the prefix in the ARN for each account the resource is shared with.</p>', 'ListServiceNetworkVpcAssociations' => '<p>Lists the service network and VPC associations. You can filter the list either by VPC or service network. You must provide either the service network identifier or the VPC identifier.</p>', 'ListServiceNetworks' => '<p>Lists the service networks owned by the caller account or shared with the caller account. Also includes the account ID in the ARN to show which account owns the service network.</p>', 'ListServices' => '<p>Lists the services owned by the caller account or shared with the caller account.</p>', 'ListTagsForResource' => '<p>Lists the tags for the specified resource.</p>', 'ListTargetGroups' => '<p>Lists your target groups. You can narrow your search by using the filters below in your request.</p>', 'ListTargets' => '<p>Lists the targets for the target group. By default, all targets are included. You can use this API to check the health status of targets. You can also ﬁlter the results by target.</p>', 'PutAuthPolicy' => '<p>Creates or updates the auth policy. The policy string in JSON must not contain newlines or blank lines.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/auth-policies.html">Auth policies</a> in the <i>Amazon VPC Lattice User Guide</i>.</p>', 'PutResourcePolicy' => '<p>Attaches a resource-based permission policy to a service or service network. The policy must contain the same actions and condition statements as the Amazon Web Services Resource Access Manager permission for sharing services and service networks.</p>', 'RegisterTargets' => '<p>Registers the targets with the target group. If it\'s a Lambda target, you can only have one target in a target group.</p>', 'TagResource' => '<p>Adds the specified tags to the specified resource.</p>', 'UntagResource' => '<p>Removes the specified tags from the specified resource.</p>', 'UpdateAccessLogSubscription' => '<p>Updates the specified access log subscription.</p>', 'UpdateListener' => '<p>Updates the specified listener for the specified service.</p>', 'UpdateRule' => '<p>Updates a rule for the listener. You can\'t modify a default listener rule. To modify a default listener rule, use <code>UpdateListener</code>.</p>', 'UpdateService' => '<p>Updates the specified service.</p>', 'UpdateServiceNetwork' => '<p>Updates the specified service network.</p>', 'UpdateServiceNetworkVpcAssociation' => '<p>Updates the service network and VPC association. If you add a security group to the service network and VPC association, the association must continue to always have at least one security group. You can add or edit security groups at any time. However, to remove all security groups, you must first delete the association and recreate it without security groups.</p>', 'UpdateTargetGroup' => '<p>Updates the specified target group.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>The user does not have sufficient access to perform this action.</p>', 'refs' => [], ], 'AccessLogDestinationArn' => [ 'base' => NULL, 'refs' => [ 'AccessLogSubscriptionSummary$destinationArn' => '<p>The Amazon Resource Name (ARN) of the destination.</p>', 'CreateAccessLogSubscriptionRequest$destinationArn' => '<p>The Amazon Resource Name (ARN) of the destination. The supported destination types are CloudWatch Log groups, Kinesis Data Firehose delivery streams, and Amazon S3 buckets.</p>', 'CreateAccessLogSubscriptionResponse$destinationArn' => '<p>The Amazon Resource Name (ARN) of the log destination.</p>', 'GetAccessLogSubscriptionResponse$destinationArn' => '<p>The Amazon Resource Name (ARN) of the access log destination.</p>', 'UpdateAccessLogSubscriptionRequest$destinationArn' => '<p>The Amazon Resource Name (ARN) of the access log destination.</p>', 'UpdateAccessLogSubscriptionResponse$destinationArn' => '<p>The Amazon Resource Name (ARN) of the access log destination.</p>', ], ], 'AccessLogSubscriptionArn' => [ 'base' => NULL, 'refs' => [ 'AccessLogSubscriptionSummary$arn' => '<p>The Amazon Resource Name (ARN) of the access log subscription</p>', 'CreateAccessLogSubscriptionResponse$arn' => '<p>The Amazon Resource Name (ARN) of the access log subscription.</p>', 'GetAccessLogSubscriptionResponse$arn' => '<p>The Amazon Resource Name (ARN) of the access log subscription.</p>', 'UpdateAccessLogSubscriptionResponse$arn' => '<p>The Amazon Resource Name (ARN) of the access log subscription.</p>', ], ], 'AccessLogSubscriptionId' => [ 'base' => NULL, 'refs' => [ 'AccessLogSubscriptionSummary$id' => '<p>The ID of the access log subscription.</p>', 'CreateAccessLogSubscriptionResponse$id' => '<p>The ID of the access log subscription.</p>', 'GetAccessLogSubscriptionResponse$id' => '<p>The ID of the access log subscription.</p>', 'UpdateAccessLogSubscriptionResponse$id' => '<p>The ID of the access log subscription.</p>', ], ], 'AccessLogSubscriptionIdentifier' => [ 'base' => NULL, 'refs' => [ 'DeleteAccessLogSubscriptionRequest$accessLogSubscriptionIdentifier' => '<p>The ID or Amazon Resource Name (ARN) of the access log subscription.</p>', 'GetAccessLogSubscriptionRequest$accessLogSubscriptionIdentifier' => '<p>The ID or Amazon Resource Name (ARN) of the access log subscription.</p>', 'UpdateAccessLogSubscriptionRequest$accessLogSubscriptionIdentifier' => '<p>The ID or Amazon Resource Name (ARN) of the access log subscription.</p>', ], ], 'AccessLogSubscriptionList' => [ 'base' => NULL, 'refs' => [ 'ListAccessLogSubscriptionsResponse$items' => '<p>Information about the access log subscriptions.</p>', ], ], 'AccessLogSubscriptionSummary' => [ 'base' => '<p>Summary information about an access log subscription.</p>', 'refs' => [ 'AccessLogSubscriptionList$member' => NULL, ], ], 'AccountId' => [ 'base' => NULL, 'refs' => [ 'CreateServiceNetworkServiceAssociationResponse$createdBy' => '<p>The account that created the association.</p>', 'CreateServiceNetworkVpcAssociationResponse$createdBy' => '<p>The account that created the association.</p>', 'GetServiceNetworkServiceAssociationResponse$createdBy' => '<p>The account that created the association.</p>', 'GetServiceNetworkVpcAssociationResponse$createdBy' => '<p>The account that created the association.</p>', 'ServiceNetworkServiceAssociationSummary$createdBy' => '<p>The account that created the association.</p>', 'ServiceNetworkVpcAssociationSummary$createdBy' => '<p>The account that created the association.</p>', 'UpdateServiceNetworkVpcAssociationResponse$createdBy' => '<p>The account that created the association.</p>', ], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'TagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'UntagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', ], ], 'AuthPolicyState' => [ 'base' => NULL, 'refs' => [ 'GetAuthPolicyResponse$state' => '<p>The state of the auth policy. The auth policy is only active when the auth type is set to <code>AWS_IAM</code>. If you provide a policy, then authentication and authorization decisions are made based on this policy and the client\'s IAM policy. If the auth type is <code>NONE</code>, then any auth policy that you provide remains inactive. For more information, see <a href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/service-networks.html#create-service-network">Create a service network</a> in the <i>Amazon VPC Lattice User Guide</i>.</p>', 'PutAuthPolicyResponse$state' => '<p>The state of the auth policy. The auth policy is only active when the auth type is set to <code>AWS_IAM</code>. If you provide a policy, then authentication and authorization decisions are made based on this policy and the client\'s IAM policy. If the Auth type is <code>NONE</code>, then, any auth policy that you provide remains inactive. For more information, see <a href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/service-networks.html#create-service-network">Create a service network</a> in the <i>Amazon VPC Lattice User Guide</i>.</p>', ], ], 'AuthPolicyString' => [ 'base' => NULL, 'refs' => [ 'GetAuthPolicyResponse$policy' => '<p>The auth policy.</p>', 'PutAuthPolicyRequest$policy' => '<p>The auth policy. The policy string in JSON must not contain newlines or blank lines.</p>', 'PutAuthPolicyResponse$policy' => '<p>The auth policy. The policy string in JSON must not contain newlines or blank lines.</p>', ], ], 'AuthType' => [ 'base' => NULL, 'refs' => [ 'CreateServiceNetworkRequest$authType' => '<p>The type of IAM policy.</p> <ul> <li> <p> <code>NONE</code>: The resource does not use an IAM policy. This is the default.</p> </li> <li> <p> <code>AWS_IAM</code>: The resource uses an IAM policy. When this type is used, auth is enabled and an auth policy is required.</p> </li> </ul>', 'CreateServiceNetworkResponse$authType' => '<p>The type of IAM policy.</p>', 'CreateServiceRequest$authType' => '<p>The type of IAM policy.</p> <ul> <li> <p> <code>NONE</code>: The resource does not use an IAM policy. This is the default.</p> </li> <li> <p> <code>AWS_IAM</code>: The resource uses an IAM policy. When this type is used, auth is enabled and an auth policy is required.</p> </li> </ul>', 'CreateServiceResponse$authType' => '<p>The type of IAM policy.</p>', 'GetServiceNetworkResponse$authType' => '<p>The type of IAM policy.</p>', 'GetServiceResponse$authType' => '<p>The type of IAM policy.</p>', 'UpdateServiceNetworkRequest$authType' => '<p>The type of IAM policy.</p> <ul> <li> <p> <code>NONE</code>: The resource does not use an IAM policy. This is the default.</p> </li> <li> <p> <code>AWS_IAM</code>: The resource uses an IAM policy. When this type is used, auth is enabled and an auth policy is required.</p> </li> </ul>', 'UpdateServiceNetworkResponse$authType' => '<p>The type of IAM policy.</p>', 'UpdateServiceRequest$authType' => '<p>The type of IAM policy.</p> <ul> <li> <p> <code>NONE</code>: The resource does not use an IAM policy. This is the default.</p> </li> <li> <p> <code>AWS_IAM</code>: The resource uses an IAM policy. When this type is used, auth is enabled and an auth policy is required.</p> </li> </ul>', 'UpdateServiceResponse$authType' => '<p>The type of IAM policy.</p>', ], ], 'BatchUpdateRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchUpdateRuleResponse' => [ 'base' => NULL, 'refs' => [], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'GetRuleResponse$isDefault' => '<p>Indicates whether this is the default rule.</p>', 'HeaderMatch$caseSensitive' => '<p>Indicates whether the match is case sensitive.</p>', 'HealthCheckConfig$enabled' => '<p>Indicates whether health checking is enabled.</p>', 'PathMatch$caseSensitive' => '<p>Indicates whether the match is case sensitive.</p>', 'RuleSummary$isDefault' => '<p>Indicates whether this is the default listener rule.</p>', 'RuleUpdateSuccess$isDefault' => '<p>Indicates whether this is the default rule.</p>', 'UpdateRuleResponse$isDefault' => '<p>Indicates whether this is the default rule.</p>', ], ], 'CertificateArn' => [ 'base' => NULL, 'refs' => [ 'CreateServiceRequest$certificateArn' => '<p>The Amazon Resource Name (ARN) of the certificate.</p>', 'CreateServiceResponse$certificateArn' => '<p>The Amazon Resource Name (ARN) of the certificate.</p>', 'GetServiceResponse$certificateArn' => '<p>The Amazon Resource Name (ARN) of the certificate.</p>', 'UpdateServiceRequest$certificateArn' => '<p>The Amazon Resource Name (ARN) of the certificate.</p>', 'UpdateServiceResponse$certificateArn' => '<p>The Amazon Resource Name (ARN) of the certificate.</p>', ], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'CreateAccessLogSubscriptionRequest$clientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you retry a request that completed successfully using the same client token and parameters, the retry succeeds without performing any actions. If the parameters aren\'t identical, the retry fails.</p>', 'CreateListenerRequest$clientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you retry a request that completed successfully using the same client token and parameters, the retry succeeds without performing any actions. If the parameters aren\'t identical, the retry fails.</p>', 'CreateRuleRequest$clientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you retry a request that completed successfully using the same client token and parameters, the retry succeeds without performing any actions. If the parameters aren\'t identical, the retry fails.</p>', 'CreateServiceNetworkRequest$clientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you retry a request that completed successfully using the same client token and parameters, the retry succeeds without performing any actions. If the parameters aren\'t identical, the retry fails.</p>', 'CreateServiceNetworkServiceAssociationRequest$clientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you retry a request that completed successfully using the same client token and parameters, the retry succeeds without performing any actions. If the parameters aren\'t identical, the retry fails.</p>', 'CreateServiceNetworkVpcAssociationRequest$clientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you retry a request that completed successfully using the same client token and parameters, the retry succeeds without performing any actions. If the parameters aren\'t identical, the retry fails.</p>', 'CreateServiceRequest$clientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you retry a request that completed successfully using the same client token and parameters, the retry succeeds without performing any actions. If the parameters aren\'t identical, the retry fails.</p>', 'CreateTargetGroupRequest$clientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you retry a request that completed successfully using the same client token and parameters, the retry succeeds without performing any actions. If the parameters aren\'t identical, the retry fails.</p>', ], ], 'ConflictException' => [ 'base' => '<p>The request conflicts with the current state of the resource. Updating or deleting a resource can cause an inconsistent state.</p>', 'refs' => [], ], 'CreateAccessLogSubscriptionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAccessLogSubscriptionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateListenerRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateListenerResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateRuleResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateServiceNetworkRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateServiceNetworkResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateServiceNetworkServiceAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateServiceNetworkServiceAssociationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateServiceNetworkVpcAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateServiceNetworkVpcAssociationRequestSecurityGroupIdsList' => [ 'base' => NULL, 'refs' => [ 'CreateServiceNetworkVpcAssociationRequest$securityGroupIds' => '<p>The IDs of the security groups. Security groups aren\'t added by default. You can add a security group to apply network level controls to control which resources in a VPC are allowed to access the service network and its services. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html">Control traffic to resources using security groups</a> in the <i>Amazon VPC User Guide</i>.</p>', ], ], 'CreateServiceNetworkVpcAssociationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateServiceRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateServiceResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateTargetGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTargetGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAccessLogSubscriptionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAccessLogSubscriptionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAuthPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAuthPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteListenerRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteListenerResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResourcePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResourcePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRuleResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteServiceNetworkRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteServiceNetworkResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteServiceNetworkServiceAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteServiceNetworkServiceAssociationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteServiceNetworkVpcAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteServiceNetworkVpcAssociationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteServiceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteServiceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTargetGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTargetGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterTargetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterTargetsRequestTargetsList' => [ 'base' => NULL, 'refs' => [ 'DeregisterTargetsRequest$targets' => '<p>The targets to deregister.</p>', ], ], 'DeregisterTargetsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DnsEntry' => [ 'base' => '<p>Describes the DNS information of a service.</p>', 'refs' => [ 'CreateServiceNetworkServiceAssociationResponse$dnsEntry' => '<p>The DNS name of the service.</p>', 'CreateServiceResponse$dnsEntry' => '<p>The public DNS name of the service.</p>', 'GetServiceNetworkServiceAssociationResponse$dnsEntry' => '<p>The DNS name of the service.</p>', 'GetServiceResponse$dnsEntry' => '<p>The DNS name of the service.</p>', 'ServiceNetworkServiceAssociationSummary$dnsEntry' => '<p>The DNS information.</p>', 'ServiceSummary$dnsEntry' => '<p>The DNS information.</p>', ], ], 'FailureCode' => [ 'base' => NULL, 'refs' => [ 'GetServiceResponse$failureCode' => '<p>The failure code.</p>', 'RuleUpdateFailure$failureCode' => '<p>The failure code.</p>', ], ], 'FailureMessage' => [ 'base' => NULL, 'refs' => [ 'GetServiceResponse$failureMessage' => '<p>The failure message.</p>', 'RuleUpdateFailure$failureMessage' => '<p>The failure message.</p>', ], ], 'FixedResponseAction' => [ 'base' => '<p>Describes an action that returns a custom HTTP response.</p>', 'refs' => [ 'RuleAction$fixedResponse' => '<p>The fixed response action. The rule returns a custom HTTP response.</p>', ], ], 'ForwardAction' => [ 'base' => '<p>Describes a forward action. You can use forward actions to route requests to one or more target groups. </p>', 'refs' => [ 'RuleAction$forward' => '<p>The forward action. Traffic that matches the rule is forwarded to the specified target groups.</p>', ], ], 'GetAccessLogSubscriptionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAccessLogSubscriptionResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetAuthPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAuthPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetListenerRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetListenerResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetResourcePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetResourcePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetRuleResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetServiceNetworkRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetServiceNetworkResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetServiceNetworkServiceAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetServiceNetworkServiceAssociationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetServiceNetworkVpcAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetServiceNetworkVpcAssociationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetServiceRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetServiceResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetTargetGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetTargetGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'HeaderMatch' => [ 'base' => '<p>Describes the constraints for a header match. Matches incoming requests with rule based on request header value before applying rule action.</p>', 'refs' => [ 'HeaderMatchList$member' => NULL, ], ], 'HeaderMatchContains' => [ 'base' => NULL, 'refs' => [ 'HeaderMatchType$contains' => '<p>A contains type match.</p>', ], ], 'HeaderMatchExact' => [ 'base' => NULL, 'refs' => [ 'HeaderMatchType$exact' => '<p>An exact type match.</p>', ], ], 'HeaderMatchList' => [ 'base' => NULL, 'refs' => [ 'HttpMatch$headerMatches' => '<p>The header matches. Matches incoming requests with rule based on request header value before applying rule action.</p>', ], ], 'HeaderMatchName' => [ 'base' => NULL, 'refs' => [ 'HeaderMatch$name' => '<p>The name of the header.</p>', ], ], 'HeaderMatchPrefix' => [ 'base' => NULL, 'refs' => [ 'HeaderMatchType$prefix' => '<p>A prefix type match. Matches the value with the prefix.</p>', ], ], 'HeaderMatchType' => [ 'base' => '<p>Describes a header match type.</p>', 'refs' => [ 'HeaderMatch$match' => '<p>The header match type.</p>', ], ], 'HealthCheckConfig' => [ 'base' => '<p>Describes the health check configuration of a target group. Health check configurations aren\'t used for target groups of type <code>LAMBDA</code> or <code>ALB</code>.</p>', 'refs' => [ 'TargetGroupConfig$healthCheck' => '<p>The health check configuration. Not supported if the target group type is <code>LAMBDA</code> or <code>ALB</code>.</p>', 'UpdateTargetGroupRequest$healthCheck' => '<p>The health check configuration.</p>', ], ], 'HealthCheckIntervalSeconds' => [ 'base' => NULL, 'refs' => [ 'HealthCheckConfig$healthCheckIntervalSeconds' => '<p>The approximate amount of time, in seconds, between health checks of an individual target. The range is 5–300 seconds. The default is 30 seconds.</p>', ], ], 'HealthCheckPath' => [ 'base' => NULL, 'refs' => [ 'HealthCheckConfig$path' => '<p>The destination for health checks on the targets. If the protocol version is <code>HTTP/1.1</code> or <code>HTTP/2</code>, specify a valid URI (for example, <code>/path?query</code>). The default path is <code>/</code>. Health checks are not supported if the protocol version is <code>gRPC</code>, however, you can choose <code>HTTP/1.1</code> or <code>HTTP/2</code> and specify a valid URI.</p>', ], ], 'HealthCheckPort' => [ 'base' => NULL, 'refs' => [ 'HealthCheckConfig$port' => '<p>The port used when performing health checks on targets. The default setting is the port that a target receives traffic on.</p>', ], ], 'HealthCheckProtocolVersion' => [ 'base' => NULL, 'refs' => [ 'HealthCheckConfig$protocolVersion' => '<p>The protocol version used when performing health checks on targets. The possible protocol versions are <code>HTTP1</code> and <code>HTTP2</code>.</p>', ], ], 'HealthCheckTimeoutSeconds' => [ 'base' => NULL, 'refs' => [ 'HealthCheckConfig$healthCheckTimeoutSeconds' => '<p>The amount of time, in seconds, to wait before reporting a target as unhealthy. The range is 1–120 seconds. The default is 5 seconds.</p>', ], ], 'HealthyThresholdCount' => [ 'base' => NULL, 'refs' => [ 'HealthCheckConfig$healthyThresholdCount' => '<p>The number of consecutive successful health checks required before considering an unhealthy target healthy. The range is 2–10. The default is 5.</p>', ], ], 'HttpCodeMatcher' => [ 'base' => NULL, 'refs' => [ 'Matcher$httpCode' => '<p>The HTTP code to use when checking for a successful response from a target.</p>', ], ], 'HttpMatch' => [ 'base' => '<p>Describes criteria that can be applied to incoming requests.</p>', 'refs' => [ 'RuleMatch$httpMatch' => '<p>The HTTP criteria that a rule must match.</p>', ], ], 'HttpMethod' => [ 'base' => NULL, 'refs' => [ 'HttpMatch$method' => '<p>The HTTP method type.</p>', ], ], 'HttpStatusCode' => [ 'base' => NULL, 'refs' => [ 'FixedResponseAction$statusCode' => '<p>The HTTP response code.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'InternalServerException$retryAfterSeconds' => '<p>The number of seconds to wait before retrying.</p>', 'ThrottlingException$retryAfterSeconds' => '<p>The number of seconds to wait before retrying.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>An unexpected error occurred while processing the request.</p>', 'refs' => [], ], 'IpAddressType' => [ 'base' => NULL, 'refs' => [ 'TargetGroupConfig$ipAddressType' => '<p>The type of IP address used for the target group. Supported only if the target group type is <code>IP</code>. The default is <code>IPV4</code>.</p>', 'TargetGroupSummary$ipAddressType' => '<p>The type of IP address used for the target group. The possible values are <code>IPV4</code> and <code>IPV6</code>. This is an optional parameter. If not specified, the default is <code>IPV4</code>.</p>', ], ], 'LambdaEventStructureVersion' => [ 'base' => NULL, 'refs' => [ 'TargetGroupConfig$lambdaEventStructureVersion' => '<p>The version of the event structure that your Lambda function receives. Supported only if the target group type is <code>LAMBDA</code>. The default is <code>V1</code>.</p>', 'TargetGroupSummary$lambdaEventStructureVersion' => '<p>The version of the event structure that your Lambda function receives. Supported only if the target group type is <code>LAMBDA</code>.</p>', ], ], 'ListAccessLogSubscriptionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAccessLogSubscriptionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListListenersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListListenersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListRulesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRulesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListServiceNetworkServiceAssociationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListServiceNetworkServiceAssociationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListServiceNetworkVpcAssociationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListServiceNetworkVpcAssociationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListServiceNetworksRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListServiceNetworksResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListServicesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListServicesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTargetGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTargetGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTargetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTargetsRequestTargetsList' => [ 'base' => NULL, 'refs' => [ 'ListTargetsRequest$targets' => '<p>The targets.</p>', ], ], 'ListTargetsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListenerArn' => [ 'base' => NULL, 'refs' => [ 'CreateListenerResponse$arn' => '<p>The Amazon Resource Name (ARN) of the listener.</p>', 'GetListenerResponse$arn' => '<p>The Amazon Resource Name (ARN) of the listener.</p>', 'ListenerSummary$arn' => '<p>The Amazon Resource Name (ARN) of the listener.</p>', 'UpdateListenerResponse$arn' => '<p>The Amazon Resource Name (ARN) of the listener.</p>', ], ], 'ListenerId' => [ 'base' => NULL, 'refs' => [ 'CreateListenerResponse$id' => '<p>The ID of the listener.</p>', 'GetListenerResponse$id' => '<p>The ID of the listener.</p>', 'ListenerSummary$id' => '<p>The ID of the listener.</p>', 'UpdateListenerResponse$id' => '<p>The ID of the listener.</p>', ], ], 'ListenerIdentifier' => [ 'base' => NULL, 'refs' => [ 'BatchUpdateRuleRequest$listenerIdentifier' => '<p>The ID or Amazon Resource Name (ARN) of the listener.</p>', 'CreateRuleRequest$listenerIdentifier' => '<p>The ID or Amazon Resource Name (ARN) of the listener.</p>', 'DeleteListenerRequest$listenerIdentifier' => '<p>The ID or Amazon Resource Name (ARN) of the listener.</p>', 'DeleteRuleRequest$listenerIdentifier' => '<p>The ID or Amazon Resource Name (ARN) of the listener.</p>', 'GetListenerRequest$listenerIdentifier' => '<p>The ID or Amazon Resource Name (ARN) of the listener.</p>', 'GetRuleRequest$listenerIdentifier' => '<p>The ID or Amazon Resource Name (ARN) of the listener.</p>', 'ListRulesRequest$listenerIdentifier' => '<p>The ID or Amazon Resource Name (ARN) of the listener.</p>', 'UpdateListenerRequest$listenerIdentifier' => '<p>The ID or Amazon Resource Name (ARN) of the listener.</p>', 'UpdateRuleRequest$listenerIdentifier' => '<p>The ID or Amazon Resource Name (ARN) of the listener.</p>', ], ], 'ListenerName' => [ 'base' => NULL, 'refs' => [ 'CreateListenerRequest$name' => '<p>The name of the listener. A listener name must be unique within a service. The valid characters are a-z, 0-9, and hyphens (-). You can\'t use a hyphen as the first or last character, or immediately after another hyphen.</p>', 'CreateListenerResponse$name' => '<p>The name of the listener.</p>', 'GetListenerResponse$name' => '<p>The name of the listener.</p>', 'ListenerSummary$name' => '<p>The name of the listener.</p>', 'UpdateListenerResponse$name' => '<p>The name of the listener.</p>', ], ], 'ListenerProtocol' => [ 'base' => NULL, 'refs' => [ 'CreateListenerRequest$protocol' => '<p>The listener protocol.</p>', 'CreateListenerResponse$protocol' => '<p>The protocol of the listener.</p>', 'GetListenerResponse$protocol' => '<p>The listener protocol.</p>', 'ListenerSummary$protocol' => '<p>The listener protocol.</p>', 'UpdateListenerResponse$protocol' => '<p>The protocol of the listener.</p>', ], ], 'ListenerSummary' => [ 'base' => '<p>Summary information about a listener.</p>', 'refs' => [ 'ListenerSummaryList$member' => NULL, ], ], 'ListenerSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListListenersResponse$items' => '<p>Information about the listeners.</p>', ], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'GetServiceNetworkResponse$numberOfAssociatedServices' => '<p>The number of services associated with the service network.</p>', 'GetServiceNetworkResponse$numberOfAssociatedVPCs' => '<p>The number of VPCs associated with the service network.</p>', 'ServiceNetworkSummary$numberOfAssociatedServices' => '<p>The number of services associated with the service network.</p>', 'ServiceNetworkSummary$numberOfAssociatedVPCs' => '<p>The number of VPCs associated with the service network.</p>', ], ], 'Matcher' => [ 'base' => '<p>Describes the codes to use when checking for a successful response from a target for health checks.</p>', 'refs' => [ 'HealthCheckConfig$matcher' => '<p>The codes to use when checking for a successful response from a target.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListAccessLogSubscriptionsRequest$maxResults' => '<p>The maximum number of results to return.</p>', 'ListListenersRequest$maxResults' => '<p>The maximum number of results to return.</p>', 'ListRulesRequest$maxResults' => '<p>The maximum number of results to return.</p>', 'ListServiceNetworkServiceAssociationsRequest$maxResults' => '<p>The maximum number of results to return.</p>', 'ListServiceNetworkVpcAssociationsRequest$maxResults' => '<p>The maximum number of results to return.</p>', 'ListServiceNetworksRequest$maxResults' => '<p>The maximum number of results to return.</p>', 'ListServicesRequest$maxResults' => '<p>The maximum number of results to return.</p>', 'ListTargetGroupsRequest$maxResults' => '<p>The maximum number of results to return.</p>', 'ListTargetsRequest$maxResults' => '<p>The maximum number of results to return.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListAccessLogSubscriptionsRequest$nextToken' => '<p>A pagination token for the next page of results.</p>', 'ListAccessLogSubscriptionsResponse$nextToken' => '<p>A pagination token for the next page of results.</p>', 'ListListenersRequest$nextToken' => '<p>A pagination token for the next page of results.</p>', 'ListListenersResponse$nextToken' => '<p>If there are additional results, a pagination token for the next page of results.</p>', 'ListRulesRequest$nextToken' => '<p>A pagination token for the next page of results.</p>', 'ListRulesResponse$nextToken' => '<p>If there are additional results, a pagination token for the next page of results.</p>', 'ListServiceNetworkServiceAssociationsRequest$nextToken' => '<p>A pagination token for the next page of results.</p>', 'ListServiceNetworkServiceAssociationsResponse$nextToken' => '<p>If there are additional results, a pagination token for the next page of results.</p>', 'ListServiceNetworkVpcAssociationsRequest$nextToken' => '<p>A pagination token for the next page of results.</p>', 'ListServiceNetworkVpcAssociationsResponse$nextToken' => '<p>If there are additional results, a pagination token for the next page of results.</p>', 'ListServiceNetworksRequest$nextToken' => '<p>A pagination token for the next page of results.</p>', 'ListServiceNetworksResponse$nextToken' => '<p>If there are additional results, a pagination token for the next page of results.</p>', 'ListServicesRequest$nextToken' => '<p>A pagination token for the next page of results.</p>', 'ListServicesResponse$nextToken' => '<p>If there are additional results, a pagination token for the next page of results.</p>', 'ListTargetGroupsRequest$nextToken' => '<p>A pagination token for the next page of results.</p>', 'ListTargetGroupsResponse$nextToken' => '<p>If there are additional results, a pagination token for the next page of results.</p>', 'ListTargetsRequest$nextToken' => '<p>A pagination token for the next page of results.</p>', 'ListTargetsResponse$nextToken' => '<p>If there are additional results, a pagination token for the next page of results.</p>', ], ], 'PathMatch' => [ 'base' => '<p>Describes the conditions that can be applied when matching a path for incoming requests.</p>', 'refs' => [ 'HttpMatch$pathMatch' => '<p>The path match.</p>', ], ], 'PathMatchExact' => [ 'base' => NULL, 'refs' => [ 'PathMatchType$exact' => '<p>An exact match of the path.</p>', ], ], 'PathMatchPrefix' => [ 'base' => NULL, 'refs' => [ 'PathMatchType$prefix' => '<p>A prefix match of the path.</p>', ], ], 'PathMatchType' => [ 'base' => '<p>Describes a path match type. Each rule can include only one of the following types of paths.</p>', 'refs' => [ 'PathMatch$match' => '<p>The type of path match.</p>', ], ], 'PolicyString' => [ 'base' => NULL, 'refs' => [ 'GetResourcePolicyResponse$policy' => '<p>An IAM policy.</p>', 'PutResourcePolicyRequest$policy' => '<p>An IAM policy. The policy string in JSON must not contain newlines or blank lines.</p>', ], ], 'Port' => [ 'base' => NULL, 'refs' => [ 'CreateListenerRequest$port' => '<p>The listener port. You can specify a value from 1 to 65535. For HTTP, the default is 80. For HTTPS, the default is 443.</p>', 'CreateListenerResponse$port' => '<p>The port number of the listener.</p>', 'GetListenerResponse$port' => '<p>The listener port.</p>', 'ListenerSummary$port' => '<p>The listener port.</p>', 'Target$port' => '<p>The port on which the target is listening. For HTTP, the default is 80. For HTTPS, the default is 443.</p>', 'TargetFailure$port' => '<p>The port on which the target is listening. This parameter doesn\'t apply if the target is a Lambda function.</p>', 'TargetGroupConfig$port' => '<p>The port on which the targets are listening. For HTTP, the default is 80. For HTTPS, the default is 443. Not supported if the target group type is <code>LAMBDA</code>.</p>', 'TargetGroupSummary$port' => '<p>The port of the target group.</p>', 'TargetSummary$port' => '<p>The port on which the target is listening.</p>', 'UpdateListenerResponse$port' => '<p>The listener port.</p>', ], ], 'PutAuthPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutAuthPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutResourcePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutResourcePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'RegisterTargetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'RegisterTargetsRequestTargetsList' => [ 'base' => NULL, 'refs' => [ 'RegisterTargetsRequest$targets' => '<p>The targets.</p>', ], ], 'RegisterTargetsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ResourceArn' => [ 'base' => NULL, 'refs' => [ 'AccessLogSubscriptionSummary$resourceArn' => '<p>The Amazon Resource Name (ARN) of the service or service network.</p>', 'CreateAccessLogSubscriptionResponse$resourceArn' => '<p>The Amazon Resource Name (ARN) of the service network or service.</p>', 'DeleteResourcePolicyRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'GetAccessLogSubscriptionResponse$resourceArn' => '<p>The Amazon Resource Name (ARN) of the service network or service.</p>', 'GetResourcePolicyRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the service network or service.</p>', 'PutResourcePolicyRequest$resourceArn' => '<p>The ID or Amazon Resource Name (ARN) of the service network or service for which the policy is created.</p>', 'UpdateAccessLogSubscriptionResponse$resourceArn' => '<p>The Amazon Resource Name (ARN) of the access log subscription.</p>', ], ], 'ResourceId' => [ 'base' => NULL, 'refs' => [ 'AccessLogSubscriptionSummary$resourceId' => '<p>The ID of the service or service network.</p>', 'CreateAccessLogSubscriptionResponse$resourceId' => '<p>The ID of the service network or service.</p>', 'GetAccessLogSubscriptionResponse$resourceId' => '<p>The ID of the service network or service.</p>', 'UpdateAccessLogSubscriptionResponse$resourceId' => '<p>The ID of the resource.</p>', ], ], 'ResourceIdentifier' => [ 'base' => NULL, 'refs' => [ 'CreateAccessLogSubscriptionRequest$resourceIdentifier' => '<p>The ID or Amazon Resource Name (ARN) of the service network or service.</p>', 'DeleteAuthPolicyRequest$resourceIdentifier' => '<p>The ID or Amazon Resource Name (ARN) of the resource.</p>', 'GetAuthPolicyRequest$resourceIdentifier' => '<p>The ID or Amazon Resource Name (ARN) of the service network or service.</p>', 'ListAccessLogSubscriptionsRequest$resourceIdentifier' => '<p>The ID or Amazon Resource Name (ARN) of the service network or service.</p>', 'PutAuthPolicyRequest$resourceIdentifier' => '<p>The ID or Amazon Resource Name (ARN) of the service network or service for which the policy is created.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The request references a resource that does not exist.</p>', 'refs' => [], ], 'RuleAction' => [ 'base' => '<p>Describes the action for a rule.</p>', 'refs' => [ 'CreateListenerRequest$defaultAction' => '<p>The action for the default rule. Each listener has a default rule. The default rule is used if no other rules match.</p>', 'CreateListenerResponse$defaultAction' => '<p>The action for the default rule.</p>', 'CreateRuleRequest$action' => '<p>The action for the default rule.</p>', 'CreateRuleResponse$action' => '<p>The rule action.</p>', 'GetListenerResponse$defaultAction' => '<p>The actions for the default listener rule.</p>', 'GetRuleResponse$action' => '<p>The action for the default rule.</p>', 'RuleUpdate$action' => '<p>The rule action.</p>', 'RuleUpdateSuccess$action' => '<p>The action for the rule.</p>', 'UpdateListenerRequest$defaultAction' => '<p>The action for the default rule.</p>', 'UpdateListenerResponse$defaultAction' => '<p>The action for the default rule.</p>', 'UpdateRuleRequest$action' => '<p>Information about the action for the specified listener rule.</p>', 'UpdateRuleResponse$action' => '<p>Information about the action for the specified listener rule.</p>', ], ], 'RuleArn' => [ 'base' => NULL, 'refs' => [ 'CreateRuleResponse$arn' => '<p>The Amazon Resource Name (ARN) of the rule.</p>', 'GetRuleResponse$arn' => '<p>The Amazon Resource Name (ARN) of the listener.</p>', 'RuleSummary$arn' => '<p>The Amazon Resource Name (ARN) of the rule.</p>', 'RuleUpdateSuccess$arn' => '<p>The Amazon Resource Name (ARN) of the listener.</p>', 'UpdateRuleResponse$arn' => '<p>The Amazon Resource Name (ARN) of the listener.</p>', ], ], 'RuleId' => [ 'base' => NULL, 'refs' => [ 'CreateRuleResponse$id' => '<p>The ID of the rule.</p>', 'GetRuleResponse$id' => '<p>The ID of the listener.</p>', 'RuleSummary$id' => '<p>The ID of the rule.</p>', 'RuleUpdateSuccess$id' => '<p>The ID of the listener.</p>', 'UpdateRuleResponse$id' => '<p>The ID of the listener.</p>', ], ], 'RuleIdentifier' => [ 'base' => NULL, 'refs' => [ 'DeleteRuleRequest$ruleIdentifier' => '<p>The ID or Amazon Resource Name (ARN) of the rule.</p>', 'GetRuleRequest$ruleIdentifier' => '<p>The ID or Amazon Resource Name (ARN) of the listener rule.</p>', 'RuleUpdate$ruleIdentifier' => '<p>The ID or Amazon Resource Name (ARN) of the rule.</p>', 'RuleUpdateFailure$ruleIdentifier' => '<p>The ID or Amazon Resource Name (ARN) of the rule.</p>', 'UpdateRuleRequest$ruleIdentifier' => '<p>The ID or Amazon Resource Name (ARN) of the rule.</p>', ], ], 'RuleMatch' => [ 'base' => '<p>Describes a rule match.</p>', 'refs' => [ 'CreateRuleRequest$match' => '<p>The rule match.</p>', 'CreateRuleResponse$match' => '<p>The rule match. The <code>RuleMatch</code> must be an <code>HttpMatch</code>. This means that the rule should be an exact match on HTTP constraints which are made up of the HTTP method, path, and header.</p>', 'GetRuleResponse$match' => '<p>The rule match.</p>', 'RuleUpdate$match' => '<p>The rule match.</p>', 'RuleUpdateSuccess$match' => '<p>The rule match.</p>', 'UpdateRuleRequest$match' => '<p>The rule match.</p>', 'UpdateRuleResponse$match' => '<p>The rule match.</p>', ], ], 'RuleName' => [ 'base' => NULL, 'refs' => [ 'CreateRuleRequest$name' => '<p>The name of the rule. The name must be unique within the listener. The valid characters are a-z, 0-9, and hyphens (-). You can\'t use a hyphen as the first or last character, or immediately after another hyphen.</p>', 'CreateRuleResponse$name' => '<p>The name of the rule.</p>', 'GetRuleResponse$name' => '<p>The name of the listener.</p>', 'RuleSummary$name' => '<p>The name of the rule.</p>', 'RuleUpdateSuccess$name' => '<p>The name of the listener.</p>', 'UpdateRuleResponse$name' => '<p>The name of the listener.</p>', ], ], 'RulePriority' => [ 'base' => NULL, 'refs' => [ 'CreateRuleRequest$priority' => '<p>The priority assigned to the rule. Each rule for a specific listener must have a unique priority. The lower the priority number the higher the priority.</p>', 'CreateRuleResponse$priority' => '<p>The priority assigned to the rule. The lower the priority number the higher the priority.</p>', 'GetRuleResponse$priority' => '<p>The priority level for the specified rule.</p>', 'RuleSummary$priority' => '<p>The priority of the rule.</p>', 'RuleUpdate$priority' => '<p>The rule priority. A listener can\'t have multiple rules with the same priority.</p>', 'RuleUpdateSuccess$priority' => '<p>The rule priority.</p>', 'UpdateRuleRequest$priority' => '<p>The rule priority. A listener can\'t have multiple rules with the same priority.</p>', 'UpdateRuleResponse$priority' => '<p>The rule priority.</p>', ], ], 'RuleSummary' => [ 'base' => '<p>Summary information about the listener rule.</p>', 'refs' => [ 'RuleSummaryList$member' => NULL, ], ], 'RuleSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListRulesResponse$items' => '<p>Information about the rules.</p>', ], ], 'RuleUpdate' => [ 'base' => '<p>Describes a rule update.</p>', 'refs' => [ 'RuleUpdateList$member' => NULL, ], ], 'RuleUpdateFailure' => [ 'base' => '<p>Describes a rule update that failed.</p>', 'refs' => [ 'RuleUpdateFailureList$member' => NULL, ], ], 'RuleUpdateFailureList' => [ 'base' => NULL, 'refs' => [ 'BatchUpdateRuleResponse$unsuccessful' => '<p>The rules that the operation couldn\'t update.</p>', ], ], 'RuleUpdateList' => [ 'base' => NULL, 'refs' => [ 'BatchUpdateRuleRequest$rules' => '<p>The rules for the specified listener.</p>', ], ], 'RuleUpdateSuccess' => [ 'base' => '<p>Describes a successful rule update.</p>', 'refs' => [ 'RuleUpdateSuccessList$member' => NULL, ], ], 'RuleUpdateSuccessList' => [ 'base' => NULL, 'refs' => [ 'BatchUpdateRuleResponse$successful' => '<p>The rules that were successfully updated.</p>', ], ], 'SecurityGroupId' => [ 'base' => NULL, 'refs' => [ 'CreateServiceNetworkVpcAssociationRequestSecurityGroupIdsList$member' => NULL, 'SecurityGroupList$member' => NULL, 'UpdateServiceNetworkVpcAssociationRequestSecurityGroupIdsList$member' => NULL, ], ], 'SecurityGroupList' => [ 'base' => NULL, 'refs' => [ 'CreateServiceNetworkVpcAssociationResponse$securityGroupIds' => '<p>The IDs of the security groups.</p>', 'GetServiceNetworkVpcAssociationResponse$securityGroupIds' => '<p>The IDs of the security groups.</p>', 'UpdateServiceNetworkVpcAssociationResponse$securityGroupIds' => '<p>The IDs of the security groups.</p>', ], ], 'ServiceArn' => [ 'base' => NULL, 'refs' => [ 'CreateListenerResponse$serviceArn' => '<p>The Amazon Resource Name (ARN) of the service.</p>', 'CreateServiceResponse$arn' => '<p>The Amazon Resource Name (ARN) of the service.</p>', 'DeleteServiceResponse$arn' => '<p>The Amazon Resource Name (ARN) of the service.</p>', 'GetListenerResponse$serviceArn' => '<p>The Amazon Resource Name (ARN) of the service.</p>', 'GetServiceNetworkServiceAssociationResponse$serviceArn' => '<p>The Amazon Resource Name (ARN) of the service.</p>', 'GetServiceResponse$arn' => '<p>The Amazon Resource Name (ARN) of the service.</p>', 'ServiceArnList$member' => NULL, 'ServiceNetworkServiceAssociationSummary$serviceArn' => '<p>The Amazon Resource Name (ARN) of the service.</p>', 'ServiceSummary$arn' => '<p>The Amazon Resource Name (ARN) of the service.</p>', 'UpdateListenerResponse$serviceArn' => '<p>The Amazon Resource Name (ARN) of the service.</p>', 'UpdateServiceResponse$arn' => '<p>The Amazon Resource Name (ARN) of the service.</p>', ], ], 'ServiceArnList' => [ 'base' => NULL, 'refs' => [ 'GetTargetGroupResponse$serviceArns' => '<p>The Amazon Resource Names (ARNs) of the service.</p>', 'TargetGroupSummary$serviceArns' => '<p>The Amazon Resource Names (ARNs) of the service.</p>', ], ], 'ServiceCustomDomainName' => [ 'base' => NULL, 'refs' => [ 'CreateServiceNetworkServiceAssociationResponse$customDomainName' => '<p>The custom domain name of the service.</p>', 'CreateServiceRequest$customDomainName' => '<p>The custom domain name of the service.</p>', 'CreateServiceResponse$customDomainName' => '<p>The custom domain name of the service.</p>', 'GetServiceNetworkServiceAssociationResponse$customDomainName' => '<p>The custom domain name of the service.</p>', 'GetServiceResponse$customDomainName' => '<p>The custom domain name of the service.</p>', 'ServiceNetworkServiceAssociationSummary$customDomainName' => '<p>The custom domain name of the service.</p>', 'ServiceSummary$customDomainName' => '<p>The custom domain name of the service.</p>', 'UpdateServiceResponse$customDomainName' => '<p>The custom domain name of the service.</p>', ], ], 'ServiceId' => [ 'base' => NULL, 'refs' => [ 'CreateListenerResponse$serviceId' => '<p>The ID of the service.</p>', 'CreateServiceResponse$id' => '<p>The ID of the service.</p>', 'DeleteServiceResponse$id' => '<p>The ID of the service.</p>', 'GetListenerResponse$serviceId' => '<p>The ID of the service.</p>', 'GetServiceNetworkServiceAssociationResponse$serviceId' => '<p>The ID of the service.</p>', 'GetServiceResponse$id' => '<p>The ID of the service.</p>', 'ServiceNetworkServiceAssociationSummary$serviceId' => '<p>The ID of the service.</p>', 'ServiceSummary$id' => '<p>The ID of the service.</p>', 'UpdateListenerResponse$serviceId' => '<p>The ID of the service.</p>', 'UpdateServiceResponse$id' => '<p>The ID of the service.</p>', ], ], 'ServiceIdentifier' => [ 'base' => NULL, 'refs' => [ 'BatchUpdateRuleRequest$serviceIdentifier' => '<p>The ID or Amazon Resource Name (ARN) of the service.</p>', 'CreateListenerRequest$serviceIdentifier' => '<p>The ID or Amazon Resource Name (ARN) of the service.</p>', 'CreateRuleRequest$serviceIdentifier' => '<p>The ID or Amazon Resource Name (ARN) of the service.</p>', 'CreateServiceNetworkServiceAssociationRequest$serviceIdentifier' => '<p>The ID or Amazon Resource Name (ARN) of the service.</p>', 'DeleteListenerRequest$serviceIdentifier' => '<p>The ID or Amazon Resource Name (ARN) of the service.</p>', 'DeleteRuleRequest$serviceIdentifier' => '<p>The ID or Amazon Resource Name (ARN) of the service.</p>', 'DeleteServiceRequest$serviceIdentifier' => '<p>The ID or Amazon Resource Name (ARN) of the service.</p>', 'GetListenerRequest$serviceIdentifier' => '<p>The ID or Amazon Resource Name (ARN) of the service.</p>', 'GetRuleRequest$serviceIdentifier' => '<p>The ID or Amazon Resource Name (ARN) of the service.</p>', 'GetServiceRequest$serviceIdentifier' => '<p>The ID or Amazon Resource Name (ARN) of the service.</p>', 'ListListenersRequest$serviceIdentifier' => '<p>The ID or Amazon Resource Name (ARN) of the service.</p>', 'ListRulesRequest$serviceIdentifier' => '<p>The ID or Amazon Resource Name (ARN) of the service.</p>', 'ListServiceNetworkServiceAssociationsRequest$serviceIdentifier' => '<p>The ID or Amazon Resource Name (ARN) of the service.</p>', 'UpdateListenerRequest$serviceIdentifier' => '<p>The ID or Amazon Resource Name (ARN) of the service.</p>', 'UpdateRuleRequest$serviceIdentifier' => '<p>The ID or Amazon Resource Name (ARN) of the service.</p>', 'UpdateServiceRequest$serviceIdentifier' => '<p>The ID or Amazon Resource Name (ARN) of the service.</p>', ], ], 'ServiceList' => [ 'base' => NULL, 'refs' => [ 'ListServicesResponse$items' => '<p>Information about the services.</p>', ], ], 'ServiceName' => [ 'base' => NULL, 'refs' => [ 'CreateServiceRequest$name' => '<p>The name of the service. The name must be unique within the account. The valid characters are a-z, 0-9, and hyphens (-). You can\'t use a hyphen as the first or last character, or immediately after another hyphen.</p>', 'CreateServiceResponse$name' => '<p>The name of the service.</p>', 'DeleteServiceResponse$name' => '<p>The name of the service.</p>', 'GetServiceNetworkServiceAssociationResponse$serviceName' => '<p>The name of the service.</p>', 'GetServiceResponse$name' => '<p>The name of the service.</p>', 'ServiceNetworkServiceAssociationSummary$serviceName' => '<p>The name of the service.</p>', 'ServiceSummary$name' => '<p>The name of the service.</p>', 'UpdateServiceResponse$name' => '<p>The name of the service.</p>', ], ], 'ServiceNetworkArn' => [ 'base' => NULL, 'refs' => [ 'CreateServiceNetworkResponse$arn' => '<p>The Amazon Resource Name (ARN) of the service network.</p>', 'GetServiceNetworkResponse$arn' => '<p>The Amazon Resource Name (ARN) of the service network.</p>', 'GetServiceNetworkServiceAssociationResponse$serviceNetworkArn' => '<p>The Amazon Resource Name (ARN) of the service network.</p>', 'GetServiceNetworkVpcAssociationResponse$serviceNetworkArn' => '<p>The Amazon Resource Name (ARN) of the service network.</p>', 'ServiceNetworkServiceAssociationSummary$serviceNetworkArn' => '<p>The Amazon Resource Name (ARN) of the service network.</p>', 'ServiceNetworkSummary$arn' => '<p>The Amazon Resource Name (ARN) of the service network.</p>', 'ServiceNetworkVpcAssociationSummary$serviceNetworkArn' => '<p>The Amazon Resource Name (ARN) of the service network.</p>', 'UpdateServiceNetworkResponse$arn' => '<p>The Amazon Resource Name (ARN) of the service network.</p>', ], ], 'ServiceNetworkId' => [ 'base' => NULL, 'refs' => [ 'CreateServiceNetworkResponse$id' => '<p>The ID of the service network.</p>', 'GetServiceNetworkResponse$id' => '<p>The ID of the service network.</p>', 'GetServiceNetworkServiceAssociationResponse$serviceNetworkId' => '<p>The ID of the service network.</p>', 'GetServiceNetworkVpcAssociationResponse$serviceNetworkId' => '<p>The ID of the service network.</p>', 'ServiceNetworkServiceAssociationSummary$serviceNetworkId' => '<p>The ID of the service network.</p>', 'ServiceNetworkSummary$id' => '<p>The ID of the service network.</p>', 'ServiceNetworkVpcAssociationSummary$serviceNetworkId' => '<p>The ID of the service network.</p>', 'UpdateServiceNetworkResponse$id' => '<p>The ID of the service network.</p>', ], ], 'ServiceNetworkIdentifier' => [ 'base' => NULL, 'refs' => [ 'CreateServiceNetworkServiceAssociationRequest$serviceNetworkIdentifier' => '<p>The ID or Amazon Resource Name (ARN) of the service network. You must use the ARN if the resources specified in the operation are in different accounts.</p>', 'CreateServiceNetworkVpcAssociationRequest$serviceNetworkIdentifier' => '<p>The ID or Amazon Resource Name (ARN) of the service network. You must use the ARN when the resources specified in the operation are in different accounts.</p>', 'DeleteServiceNetworkRequest$serviceNetworkIdentifier' => '<p>The Amazon Resource Name (ARN) or ID of the service network.</p>', 'GetServiceNetworkRequest$serviceNetworkIdentifier' => '<p>The ID or Amazon Resource Name (ARN) of the service network.</p>', 'ListServiceNetworkServiceAssociationsRequest$serviceNetworkIdentifier' => '<p>The ID or Amazon Resource Name (ARN) of the service network.</p>', 'ListServiceNetworkVpcAssociationsRequest$serviceNetworkIdentifier' => '<p>The ID or Amazon Resource Name (ARN) of the service network.</p>', 'UpdateServiceNetworkRequest$serviceNetworkIdentifier' => '<p>The ID or Amazon Resource Name (ARN) of the service network.</p>', ], ], 'ServiceNetworkList' => [ 'base' => NULL, 'refs' => [ 'ListServiceNetworksResponse$items' => '<p>Information about the service networks.</p>', ], ], 'ServiceNetworkName' => [ 'base' => NULL, 'refs' => [ 'CreateServiceNetworkRequest$name' => '<p>The name of the service network. The name must be unique to the account. The valid characters are a-z, 0-9, and hyphens (-). You can\'t use a hyphen as the first or last character, or immediately after another hyphen.</p>', 'CreateServiceNetworkResponse$name' => '<p>The name of the service network.</p>', 'GetServiceNetworkResponse$name' => '<p>The name of the service network.</p>', 'GetServiceNetworkServiceAssociationResponse$serviceNetworkName' => '<p>The name of the service network.</p>', 'GetServiceNetworkVpcAssociationResponse$serviceNetworkName' => '<p>The name of the service network.</p>', 'ServiceNetworkServiceAssociationSummary$serviceNetworkName' => '<p>The name of the service network.</p>', 'ServiceNetworkSummary$name' => '<p>The name of the service network.</p>', 'ServiceNetworkVpcAssociationSummary$serviceNetworkName' => '<p>The name of the service network.</p>', 'UpdateServiceNetworkResponse$name' => '<p>The name of the service network.</p>', ], ], 'ServiceNetworkServiceAssociationArn' => [ 'base' => NULL, 'refs' => [ 'CreateServiceNetworkServiceAssociationResponse$arn' => '<p>The Amazon Resource Name (ARN) of the association.</p>', 'DeleteServiceNetworkServiceAssociationResponse$arn' => '<p>The Amazon Resource Name (ARN) of the association.</p>', 'GetServiceNetworkServiceAssociationResponse$arn' => '<p>The Amazon Resource Name (ARN) of the association.</p>', 'ServiceNetworkServiceAssociationSummary$arn' => '<p>The Amazon Resource Name (ARN) of the association.</p>', ], ], 'ServiceNetworkServiceAssociationIdentifier' => [ 'base' => NULL, 'refs' => [ 'CreateServiceNetworkServiceAssociationResponse$id' => '<p>The ID of the association.</p>', 'DeleteServiceNetworkServiceAssociationRequest$serviceNetworkServiceAssociationIdentifier' => '<p>The ID or Amazon Resource Name (ARN) of the association.</p>', 'DeleteServiceNetworkServiceAssociationResponse$id' => '<p>The ID of the association.</p>', 'GetServiceNetworkServiceAssociationRequest$serviceNetworkServiceAssociationIdentifier' => '<p>The ID or Amazon Resource Name (ARN) of the association.</p>', 'GetServiceNetworkServiceAssociationResponse$id' => '<p>The ID of the service network and service association.</p>', 'ServiceNetworkServiceAssociationSummary$id' => '<p>The ID of the association.</p>', ], ], 'ServiceNetworkServiceAssociationList' => [ 'base' => NULL, 'refs' => [ 'ListServiceNetworkServiceAssociationsResponse$items' => '<p>Information about the associations.</p>', ], ], 'ServiceNetworkServiceAssociationStatus' => [ 'base' => NULL, 'refs' => [ 'CreateServiceNetworkServiceAssociationResponse$status' => '<p>The association status.</p>', 'DeleteServiceNetworkServiceAssociationResponse$status' => '<p>The status. You can retry the operation if the status is <code>DELETE_FAILED</code>. However, if you retry it when the status is <code>DELETE_IN_PROGRESS</code>, there is no change in the status.</p>', 'GetServiceNetworkServiceAssociationResponse$status' => '<p>The status of the association.</p>', 'ServiceNetworkServiceAssociationSummary$status' => '<p>The status. If the deletion fails, try to delete again.</p>', ], ], 'ServiceNetworkServiceAssociationSummary' => [ 'base' => '<p>Summary information about the association between a service network and a service.</p>', 'refs' => [ 'ServiceNetworkServiceAssociationList$member' => NULL, ], ], 'ServiceNetworkSummary' => [ 'base' => '<p>Summary information about a service network.</p>', 'refs' => [ 'ServiceNetworkList$member' => NULL, ], ], 'ServiceNetworkVpcAssociationArn' => [ 'base' => NULL, 'refs' => [ 'CreateServiceNetworkVpcAssociationResponse$arn' => '<p>The Amazon Resource Name (ARN) of the association.</p>', 'DeleteServiceNetworkVpcAssociationResponse$arn' => '<p>The Amazon Resource Name (ARN) of the association.</p>', 'GetServiceNetworkVpcAssociationResponse$arn' => '<p>The Amazon Resource Name (ARN) of the association.</p>', 'ServiceNetworkVpcAssociationSummary$arn' => '<p>The Amazon Resource Name (ARN) of the association.</p>', 'UpdateServiceNetworkVpcAssociationResponse$arn' => '<p>The Amazon Resource Name (ARN) of the association.</p>', ], ], 'ServiceNetworkVpcAssociationId' => [ 'base' => NULL, 'refs' => [ 'CreateServiceNetworkVpcAssociationResponse$id' => '<p>The ID of the association.</p>', 'DeleteServiceNetworkVpcAssociationResponse$id' => '<p>The ID of the association.</p>', 'GetServiceNetworkVpcAssociationResponse$id' => '<p>The ID of the specified association between the service network and the VPC.</p>', 'ServiceNetworkVpcAssociationSummary$id' => '<p>The ID of the association.</p>', 'UpdateServiceNetworkVpcAssociationResponse$id' => '<p>The ID of the association.</p>', ], ], 'ServiceNetworkVpcAssociationIdentifier' => [ 'base' => NULL, 'refs' => [ 'DeleteServiceNetworkVpcAssociationRequest$serviceNetworkVpcAssociationIdentifier' => '<p>The ID or Amazon Resource Name (ARN) of the association.</p>', 'GetServiceNetworkVpcAssociationRequest$serviceNetworkVpcAssociationIdentifier' => '<p>The ID or Amazon Resource Name (ARN) of the association.</p>', 'UpdateServiceNetworkVpcAssociationRequest$serviceNetworkVpcAssociationIdentifier' => '<p>The ID or Amazon Resource Name (ARN) of the association.</p>', ], ], 'ServiceNetworkVpcAssociationList' => [ 'base' => NULL, 'refs' => [ 'ListServiceNetworkVpcAssociationsResponse$items' => '<p>Information about the associations.</p>', ], ], 'ServiceNetworkVpcAssociationStatus' => [ 'base' => NULL, 'refs' => [ 'CreateServiceNetworkVpcAssociationResponse$status' => '<p>The association status.</p>', 'DeleteServiceNetworkVpcAssociationResponse$status' => '<p>The status. You can retry the operation if the status is <code>DELETE_FAILED</code>. However, if you retry it while the status is <code>DELETE_IN_PROGRESS</code>, there is no change in the status.</p>', 'GetServiceNetworkVpcAssociationResponse$status' => '<p>The status of the association.</p>', 'ServiceNetworkVpcAssociationSummary$status' => '<p>The status.</p>', 'UpdateServiceNetworkVpcAssociationResponse$status' => '<p>The status. You can retry the operation if the status is <code>DELETE_FAILED</code>. However, if you retry it while the status is <code>DELETE_IN_PROGRESS</code>, there is no change in the status.</p>', ], ], 'ServiceNetworkVpcAssociationSummary' => [ 'base' => '<p>Summary information about an association between a service network and a VPC.</p>', 'refs' => [ 'ServiceNetworkVpcAssociationList$member' => NULL, ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>The request would cause a service quota to be exceeded.</p>', 'refs' => [], ], 'ServiceStatus' => [ 'base' => NULL, 'refs' => [ 'CreateServiceResponse$status' => '<p>The status. If the status is <code>CREATE_FAILED</code>, you must delete and recreate the service.</p>', 'DeleteServiceResponse$status' => '<p>The status. You can retry the operation if the status is <code>DELETE_FAILED</code>. However, if you retry it while the status is <code>DELETE_IN_PROGRESS</code>, the status doesn\'t change.</p>', 'GetServiceResponse$status' => '<p>The status of the service.</p>', 'ServiceSummary$status' => '<p>The status.</p>', ], ], 'ServiceSummary' => [ 'base' => '<p>Summary information about a service.</p>', 'refs' => [ 'ServiceList$member' => NULL, ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'ConflictException$message' => NULL, 'ConflictException$resourceId' => '<p>The resource ID.</p>', 'ConflictException$resourceType' => '<p>The resource type.</p>', 'DnsEntry$domainName' => '<p>The domain name of the service.</p>', 'DnsEntry$hostedZoneId' => '<p>The ID of the hosted zone.</p>', 'GetServiceNetworkServiceAssociationResponse$failureCode' => '<p>The failure code.</p>', 'GetServiceNetworkServiceAssociationResponse$failureMessage' => '<p>The failure message.</p>', 'GetServiceNetworkVpcAssociationResponse$failureCode' => '<p>The failure code.</p>', 'GetServiceNetworkVpcAssociationResponse$failureMessage' => '<p>The failure message.</p>', 'GetTargetGroupResponse$failureCode' => '<p>The failure code.</p>', 'GetTargetGroupResponse$failureMessage' => '<p>The failure message.</p>', 'InternalServerException$message' => NULL, 'ResourceNotFoundException$message' => NULL, 'ResourceNotFoundException$resourceId' => '<p>The resource ID.</p>', 'ResourceNotFoundException$resourceType' => '<p>The resource type.</p>', 'ServiceQuotaExceededException$message' => NULL, 'ServiceQuotaExceededException$quotaCode' => '<p>The ID of the service quota that was exceeded.</p>', 'ServiceQuotaExceededException$resourceId' => '<p>The resource ID.</p>', 'ServiceQuotaExceededException$resourceType' => '<p>The resource type.</p>', 'ServiceQuotaExceededException$serviceCode' => '<p>The service code.</p>', 'TargetFailure$failureCode' => '<p>The failure code.</p>', 'TargetFailure$failureMessage' => '<p>The failure message.</p>', 'TargetFailure$id' => '<p>The ID of the target. If the target group type is <code>INSTANCE</code>, this is an instance ID. If the target group type is <code>IP</code>, this is an IP address. If the target group type is <code>LAMBDA</code>, this is the ARN of a Lambda function. If the target group type is <code>ALB</code>, this is the ARN of an Application Load Balancer.</p>', 'TargetSummary$id' => '<p>The ID of the target. If the target group type is <code>INSTANCE</code>, this is an instance ID. If the target group type is <code>IP</code>, this is an IP address. If the target group type is <code>LAMBDA</code>, this is the ARN of a Lambda function. If the target type is <code>ALB</code>, this is the ARN of an Application Load Balancer.</p>', 'TargetSummary$reasonCode' => '<p>The code for why the target status is what it is.</p>', 'ThrottlingException$message' => NULL, 'ThrottlingException$quotaCode' => '<p>The ID of the service quota that was exceeded.</p>', 'ThrottlingException$serviceCode' => '<p>The service code.</p>', 'ValidationException$message' => NULL, 'ValidationExceptionField$message' => '<p>Additional information about why the validation failed.</p>', 'ValidationExceptionField$name' => '<p>The name of the validation exception.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeys$member' => NULL, 'TagMap$key' => '<p>The key of the tag.</p> <p>Constraints: Tag keys are case-sensitive and accept a maximum of 128 Unicode characters. Valid characters are Unicode letters, digits, white space, and any of the following symbols: _ . : / = + - @ May not begin with <code>aws:</code>.</p>', ], ], 'TagKeys' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>The tag keys of the tags to remove.</p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'CreateAccessLogSubscriptionRequest$tags' => '<p>The tags for the access log subscription.</p>', 'CreateListenerRequest$tags' => '<p>The tags for the listener.</p>', 'CreateRuleRequest$tags' => '<p>The tags for the rule.</p>', 'CreateServiceNetworkRequest$tags' => '<p>The tags for the service network.</p>', 'CreateServiceNetworkServiceAssociationRequest$tags' => '<p>The tags for the association.</p>', 'CreateServiceNetworkVpcAssociationRequest$tags' => '<p>The tags for the association.</p>', 'CreateServiceRequest$tags' => '<p>The tags for the service.</p>', 'CreateTargetGroupRequest$tags' => '<p>The tags for the target group.</p>', 'ListTagsForResourceResponse$tags' => '<p>Information about the tags.</p>', 'TagResourceRequest$tags' => '<p>The tags for the resource.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagMap$value' => '<p>The value of the tag.</p> <p>Constraints: Tag values are case-sensitive and accept a maximum of 256 Unicode characters. Valid characters are Unicode letters, digits, white space, and any of the following symbols: _ . : / = + - @</p>', ], ], 'Target' => [ 'base' => '<p>Describes a target.</p>', 'refs' => [ 'DeregisterTargetsRequestTargetsList$member' => NULL, 'ListTargetsRequestTargetsList$member' => NULL, 'RegisterTargetsRequestTargetsList$member' => NULL, 'TargetList$member' => NULL, ], ], 'TargetFailure' => [ 'base' => '<p>Describes a target failure.</p>', 'refs' => [ 'TargetFailureList$member' => NULL, ], ], 'TargetFailureList' => [ 'base' => NULL, 'refs' => [ 'DeregisterTargetsResponse$unsuccessful' => '<p>The targets that the operation couldn\'t deregister.</p>', 'RegisterTargetsResponse$unsuccessful' => '<p>The targets that were not registered.</p>', ], ], 'TargetGroupArn' => [ 'base' => NULL, 'refs' => [ 'CreateTargetGroupResponse$arn' => '<p>The Amazon Resource Name (ARN) of the target group.</p>', 'DeleteTargetGroupResponse$arn' => '<p>The Amazon Resource Name (ARN) of the target group.</p>', 'GetTargetGroupResponse$arn' => '<p>The Amazon Resource Name (ARN) of the target group.</p>', 'TargetGroupSummary$arn' => '<p>The ARN (Amazon Resource Name) of the target group.</p>', 'UpdateTargetGroupResponse$arn' => '<p>The Amazon Resource Name (ARN) of the target group.</p>', ], ], 'TargetGroupConfig' => [ 'base' => '<p>Describes the configuration of a target group.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/target-groups.html">Target groups</a> in the <i>Amazon VPC Lattice User Guide</i>.</p>', 'refs' => [ 'CreateTargetGroupRequest$config' => '<p>The target group configuration.</p>', 'CreateTargetGroupResponse$config' => '<p>The target group configuration.</p>', 'GetTargetGroupResponse$config' => '<p>The target group configuration.</p>', 'UpdateTargetGroupResponse$config' => '<p>The target group configuration.</p>', ], ], 'TargetGroupId' => [ 'base' => NULL, 'refs' => [ 'CreateTargetGroupResponse$id' => '<p>The ID of the target group.</p>', 'DeleteTargetGroupResponse$id' => '<p>The ID of the target group.</p>', 'GetTargetGroupResponse$id' => '<p>The ID of the target group.</p>', 'TargetGroupSummary$id' => '<p>The ID of the target group.</p>', 'UpdateTargetGroupResponse$id' => '<p>The ID of the target group.</p>', ], ], 'TargetGroupIdentifier' => [ 'base' => NULL, 'refs' => [ 'DeleteTargetGroupRequest$targetGroupIdentifier' => '<p>The ID or Amazon Resource Name (ARN) of the target group.</p>', 'DeregisterTargetsRequest$targetGroupIdentifier' => '<p>The ID or Amazon Resource Name (ARN) of the target group.</p>', 'GetTargetGroupRequest$targetGroupIdentifier' => '<p>The ID or Amazon Resource Name (ARN) of the target group.</p>', 'ListTargetsRequest$targetGroupIdentifier' => '<p>The ID or Amazon Resource Name (ARN) of the target group.</p>', 'RegisterTargetsRequest$targetGroupIdentifier' => '<p>The ID or Amazon Resource Name (ARN) of the target group.</p>', 'UpdateTargetGroupRequest$targetGroupIdentifier' => '<p>The ID or Amazon Resource Name (ARN) of the target group.</p>', 'WeightedTargetGroup$targetGroupIdentifier' => '<p>The ID or Amazon Resource Name (ARN) of the target group.</p>', ], ], 'TargetGroupList' => [ 'base' => NULL, 'refs' => [ 'ListTargetGroupsResponse$items' => '<p>Information about the target groups.</p>', ], ], 'TargetGroupName' => [ 'base' => NULL, 'refs' => [ 'CreateTargetGroupRequest$name' => '<p>The name of the target group. The name must be unique within the account. The valid characters are a-z, 0-9, and hyphens (-). You can\'t use a hyphen as the first or last character, or immediately after another hyphen.</p>', 'CreateTargetGroupResponse$name' => '<p>The name of the target group.</p>', 'GetTargetGroupResponse$name' => '<p>The name of the target group.</p>', 'TargetGroupSummary$name' => '<p>The name of the target group.</p>', 'UpdateTargetGroupResponse$name' => '<p>The name of the target group.</p>', ], ], 'TargetGroupProtocol' => [ 'base' => NULL, 'refs' => [ 'HealthCheckConfig$protocol' => '<p>The protocol used when performing health checks on targets. The possible protocols are <code>HTTP</code> and <code>HTTPS</code>. The default is <code>HTTP</code>.</p>', 'TargetGroupConfig$protocol' => '<p>The protocol to use for routing traffic to the targets. The default is the protocol of the target group. Not supported if the target group type is <code>LAMBDA</code>.</p>', 'TargetGroupSummary$protocol' => '<p>The protocol of the target group.</p>', ], ], 'TargetGroupProtocolVersion' => [ 'base' => NULL, 'refs' => [ 'TargetGroupConfig$protocolVersion' => '<p>The protocol version. The default is <code>HTTP1</code>. Not supported if the target group type is <code>LAMBDA</code>.</p>', ], ], 'TargetGroupStatus' => [ 'base' => NULL, 'refs' => [ 'CreateTargetGroupResponse$status' => '<p>The status. You can retry the operation if the status is <code>CREATE_FAILED</code>. However, if you retry it while the status is <code>CREATE_IN_PROGRESS</code>, there is no change in the status.</p>', 'DeleteTargetGroupResponse$status' => '<p>The status. You can retry the operation if the status is <code>DELETE_FAILED</code>. However, if you retry it while the status is <code>DELETE_IN_PROGRESS</code>, the status doesn\'t change.</p>', 'GetTargetGroupResponse$status' => '<p>The status.</p>', 'TargetGroupSummary$status' => '<p>The status.</p>', 'UpdateTargetGroupResponse$status' => '<p>The status.</p>', ], ], 'TargetGroupSummary' => [ 'base' => '<p>Summary information about a target group.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/target-groups.html">Target groups</a> in the <i>Amazon VPC Lattice User Guide</i>.</p>', 'refs' => [ 'TargetGroupList$member' => NULL, ], ], 'TargetGroupType' => [ 'base' => NULL, 'refs' => [ 'CreateTargetGroupRequest$type' => '<p>The type of target group.</p>', 'CreateTargetGroupResponse$type' => '<p>The type of target group.</p>', 'GetTargetGroupResponse$type' => '<p>The target group type.</p>', 'ListTargetGroupsRequest$targetGroupType' => '<p>The target group type.</p>', 'TargetGroupSummary$type' => '<p>The target group type.</p>', 'UpdateTargetGroupResponse$type' => '<p>The target group type.</p>', ], ], 'TargetGroupWeight' => [ 'base' => NULL, 'refs' => [ 'WeightedTargetGroup$weight' => '<p>Only required if you specify multiple target groups for a forward action. The weight determines how requests are distributed to the target group. For example, if you specify two target groups, each with a weight of 10, each target group receives half the requests. If you specify two target groups, one with a weight of 10 and the other with a weight of 20, the target group with a weight of 20 receives twice as many requests as the other target group. If there\'s only one target group specified, then the default value is 100.</p>', ], ], 'TargetIdString' => [ 'base' => NULL, 'refs' => [ 'Target$id' => '<p>The ID of the target. If the target group type is <code>INSTANCE</code>, this is an instance ID. If the target group type is <code>IP</code>, this is an IP address. If the target group type is <code>LAMBDA</code>, this is the ARN of a Lambda function. If the target group type is <code>ALB</code>, this is the ARN of an Application Load Balancer.</p>', ], ], 'TargetList' => [ 'base' => NULL, 'refs' => [ 'DeregisterTargetsResponse$successful' => '<p>The targets that were successfully deregistered.</p>', 'RegisterTargetsResponse$successful' => '<p>The targets that were successfully registered.</p>', ], ], 'TargetStatus' => [ 'base' => NULL, 'refs' => [ 'TargetSummary$status' => '<p>The status of the target.</p> <ul> <li> <p> <code>DRAINING</code>: The target is being deregistered. No new connections are sent to this target while current connections are being drained. The default draining time is 5 minutes.</p> </li> <li> <p> <code>UNAVAILABLE</code>: Health checks are unavailable for the target group.</p> </li> <li> <p> <code>HEALTHY</code>: The target is healthy.</p> </li> <li> <p> <code>UNHEALTHY</code>: The target is unhealthy.</p> </li> <li> <p> <code>INITIAL</code>: Initial health checks on the target are being performed.</p> </li> <li> <p> <code>UNUSED</code>: Target group is not used in a service.</p> </li> </ul>', ], ], 'TargetSummary' => [ 'base' => '<p>Summary information about a target.</p>', 'refs' => [ 'TargetSummaryList$member' => NULL, ], ], 'TargetSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListTargetsResponse$items' => '<p>Information about the targets.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The limit on the number of requests per second was exceeded.</p>', 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'AccessLogSubscriptionSummary$createdAt' => '<p>The date and time that the access log subscription was created, specified in ISO-8601 format.</p>', 'AccessLogSubscriptionSummary$lastUpdatedAt' => '<p>The date and time that the access log subscription was last updated, specified in ISO-8601 format.</p>', 'GetAccessLogSubscriptionResponse$createdAt' => '<p>The date and time that the access log subscription was created, specified in ISO-8601 format.</p>', 'GetAccessLogSubscriptionResponse$lastUpdatedAt' => '<p>The date and time that the access log subscription was last updated, specified in ISO-8601 format.</p>', 'GetAuthPolicyResponse$createdAt' => '<p>The date and time that the auth policy was created, specified in ISO-8601 format.</p>', 'GetAuthPolicyResponse$lastUpdatedAt' => '<p>The date and time that the auth policy was last updated, specified in ISO-8601 format.</p>', 'GetListenerResponse$createdAt' => '<p>The date and time that the listener was created, specified in ISO-8601 format.</p>', 'GetListenerResponse$lastUpdatedAt' => '<p>The date and time that the listener was last updated, specified in ISO-8601 format.</p>', 'GetRuleResponse$createdAt' => '<p>The date and time that the listener rule was created, specified in ISO-8601 format.</p>', 'GetRuleResponse$lastUpdatedAt' => '<p>The date and time that the listener rule was last updated, specified in ISO-8601 format.</p>', 'GetServiceNetworkResponse$createdAt' => '<p>The date and time that the service network was created, specified in ISO-8601 format.</p>', 'GetServiceNetworkResponse$lastUpdatedAt' => '<p>The date and time of the last update, specified in ISO-8601 format.</p>', 'GetServiceNetworkServiceAssociationResponse$createdAt' => '<p>The date and time that the association was created, specified in ISO-8601 format.</p>', 'GetServiceNetworkVpcAssociationResponse$createdAt' => '<p>The date and time that the association was created, specified in ISO-8601 format.</p>', 'GetServiceNetworkVpcAssociationResponse$lastUpdatedAt' => '<p>The date and time that the association was last updated, specified in ISO-8601 format.</p>', 'GetServiceResponse$createdAt' => '<p>The date and time that the service was created, specified in ISO-8601 format.</p>', 'GetServiceResponse$lastUpdatedAt' => '<p>The date and time that the service was last updated, specified in ISO-8601 format.</p>', 'GetTargetGroupResponse$createdAt' => '<p>The date and time that the target group was created, specified in ISO-8601 format.</p>', 'GetTargetGroupResponse$lastUpdatedAt' => '<p>The date and time that the target group was last updated, specified in ISO-8601 format.</p>', 'ListenerSummary$createdAt' => '<p>The date and time that the listener was created, specified in ISO-8601 format.</p>', 'ListenerSummary$lastUpdatedAt' => '<p>The date and time that the listener was last updated, specified in ISO-8601 format.</p>', 'RuleSummary$createdAt' => '<p>The date and time that the listener rule was created, specified in ISO-8601 format.</p>', 'RuleSummary$lastUpdatedAt' => '<p>The date and time that the listener rule was last updated, specified in ISO-8601 format.</p>', 'ServiceNetworkServiceAssociationSummary$createdAt' => '<p>The date and time that the association was created, specified in ISO-8601 format.</p>', 'ServiceNetworkSummary$createdAt' => '<p>The date and time that the service network was created, specified in ISO-8601 format.</p>', 'ServiceNetworkSummary$lastUpdatedAt' => '<p>The date and time that the service network was last updated, specified in ISO-8601 format.</p>', 'ServiceNetworkVpcAssociationSummary$createdAt' => '<p>The date and time that the association was created, specified in ISO-8601 format.</p>', 'ServiceNetworkVpcAssociationSummary$lastUpdatedAt' => '<p>The date and time that the association was last updated, specified in ISO-8601 format.</p>', 'ServiceSummary$createdAt' => '<p>The date and time that the service was created, specified in ISO-8601 format.</p>', 'ServiceSummary$lastUpdatedAt' => '<p>The date and time that the service was last updated. The format is ISO-8601.</p>', 'TargetGroupSummary$createdAt' => '<p>The date and time that the target group was created, specified in ISO-8601 format.</p>', 'TargetGroupSummary$lastUpdatedAt' => '<p>The date and time that the target group was last updated, specified in ISO-8601 format.</p>', ], ], 'UnhealthyThresholdCount' => [ 'base' => NULL, 'refs' => [ 'HealthCheckConfig$unhealthyThresholdCount' => '<p>The number of consecutive failed health checks required before considering a target unhealthy. The range is 2–10. The default is 2.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAccessLogSubscriptionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAccessLogSubscriptionResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateListenerRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateListenerResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRuleResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateServiceNetworkRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateServiceNetworkResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateServiceNetworkVpcAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateServiceNetworkVpcAssociationRequestSecurityGroupIdsList' => [ 'base' => NULL, 'refs' => [ 'UpdateServiceNetworkVpcAssociationRequest$securityGroupIds' => '<p>The IDs of the security groups.</p>', ], ], 'UpdateServiceNetworkVpcAssociationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateServiceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateServiceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTargetGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTargetGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>The input does not satisfy the constraints specified by an Amazon Web Services service.</p>', 'refs' => [], ], 'ValidationExceptionField' => [ 'base' => '<p>Describes a validation failure.</p>', 'refs' => [ 'ValidationExceptionFieldList$member' => NULL, ], ], 'ValidationExceptionFieldList' => [ 'base' => NULL, 'refs' => [ 'ValidationException$fieldList' => '<p>The fields that failed validation.</p>', ], ], 'ValidationExceptionReason' => [ 'base' => NULL, 'refs' => [ 'ValidationException$reason' => '<p>The reason.</p>', ], ], 'VpcId' => [ 'base' => NULL, 'refs' => [ 'CreateServiceNetworkVpcAssociationRequest$vpcIdentifier' => '<p>The ID of the VPC.</p>', 'GetServiceNetworkVpcAssociationResponse$vpcId' => '<p>The ID of the VPC.</p>', 'ListServiceNetworkVpcAssociationsRequest$vpcIdentifier' => '<p>The ID or Amazon Resource Name (ARN) of the VPC.</p>', 'ListTargetGroupsRequest$vpcIdentifier' => '<p>The ID or Amazon Resource Name (ARN) of the VPC.</p>', 'ServiceNetworkVpcAssociationSummary$vpcId' => '<p>The ID of the VPC.</p>', 'TargetGroupConfig$vpcIdentifier' => '<p>The ID of the VPC. Not supported if the target group type is <code>LAMBDA</code>.</p>', 'TargetGroupSummary$vpcIdentifier' => '<p>The ID of the VPC of the target group.</p>', ], ], 'WeightedTargetGroup' => [ 'base' => '<p>Describes the weight of a target group.</p>', 'refs' => [ 'WeightedTargetGroupList$member' => NULL, ], ], 'WeightedTargetGroupList' => [ 'base' => NULL, 'refs' => [ 'ForwardAction$targetGroups' => '<p>The target groups. Traffic matching the rule is forwarded to the specified target groups. With forward actions, you can assign a weight that controls the prioritization and selection of each target group. This means that requests are distributed to individual target groups based on their weights. For example, if two target groups have the same weight, each target group receives half of the traffic.</p> <p>The default value is 1. This means that if only one target group is provided, there is no need to set the weight; 100% of the traffic goes to that target group.</p>', ], ], ],];
