<?php
// This file was auto-generated from sdk-root/src/data/wisdom/2020-10-19/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Amazon Connect Wisdom delivers agents the information they need to solve customer issues as they\'re actively speaking with customers. Agents can search across connected repositories from within their agent desktop to find answers quickly. Use Amazon Connect Wisdom to create an assistant and a knowledge base, for example, or manage content by uploading custom files.</p>', 'operations' => [ 'CreateAssistant' => '<p>Creates an Amazon Connect Wisdom assistant.</p>', 'CreateAssistantAssociation' => '<p>Creates an association between an Amazon Connect Wisdom assistant and another resource. Currently, the only supported association is with a knowledge base. An assistant can have only a single association.</p>', 'CreateContent' => '<p>Creates Wisdom content. Before to calling this API, use <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_StartContentUpload.html">StartContentUpload</a> to upload an asset.</p>', 'CreateKnowledgeBase' => '<p>Creates a knowledge base.</p> <note> <p>When using this API, you cannot reuse <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/Welcome.html">Amazon AppIntegrations</a> DataIntegrations with external knowledge bases such as Salesforce and ServiceNow. If you do, you\'ll get an <code>InvalidRequestException</code> error. </p> <p>For example, you\'re programmatically managing your external knowledge base, and you want to add or remove one of the fields that is being ingested from Salesforce. Do the following:</p> <ol> <li> <p>Call <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_DeleteKnowledgeBase.html">DeleteKnowledgeBase</a>.</p> </li> <li> <p>Call <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_DeleteDataIntegration.html">DeleteDataIntegration</a>.</p> </li> <li> <p>Call <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html">CreateDataIntegration</a> to recreate the DataIntegration or a create different one.</p> </li> <li> <p>Call CreateKnowledgeBase.</p> </li> </ol> </note>', 'CreateQuickResponse' => '<p>Creates a Wisdom quick response.</p>', 'CreateSession' => '<p>Creates a session. A session is a contextual container used for generating recommendations. Amazon Connect creates a new Wisdom session for each contact on which Wisdom is enabled.</p>', 'DeleteAssistant' => '<p>Deletes an assistant.</p>', 'DeleteAssistantAssociation' => '<p>Deletes an assistant association.</p>', 'DeleteContent' => '<p>Deletes the content.</p>', 'DeleteImportJob' => '<p>Deletes the quick response import job.</p>', 'DeleteKnowledgeBase' => '<p>Deletes the knowledge base.</p> <note> <p>When you use this API to delete an external knowledge base such as Salesforce or ServiceNow, you must also delete the <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/Welcome.html">Amazon AppIntegrations</a> DataIntegration. This is because you can\'t reuse the DataIntegration after it\'s been associated with an external knowledge base. However, you can delete and recreate it. See <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_DeleteDataIntegration.html">DeleteDataIntegration</a> and <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html">CreateDataIntegration</a> in the <i>Amazon AppIntegrations API Reference</i>.</p> </note>', 'DeleteQuickResponse' => '<p>Deletes a quick response.</p>', 'GetAssistant' => '<p>Retrieves information about an assistant.</p>', 'GetAssistantAssociation' => '<p>Retrieves information about an assistant association.</p>', 'GetContent' => '<p>Retrieves content, including a pre-signed URL to download the content.</p>', 'GetContentSummary' => '<p>Retrieves summary information about the content.</p>', 'GetImportJob' => '<p>Retrieves the started import job.</p>', 'GetKnowledgeBase' => '<p>Retrieves information about the knowledge base.</p>', 'GetQuickResponse' => '<p>Retrieves the quick response.</p>', 'GetRecommendations' => '<p>Retrieves recommendations for the specified session. To avoid retrieving the same recommendations in subsequent calls, use <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_NotifyRecommendationsReceived.html">NotifyRecommendationsReceived</a>. This API supports long-polling behavior with the <code>waitTimeSeconds</code> parameter. Short poll is the default behavior and only returns recommendations already available. To perform a manual query against an assistant, use <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_QueryAssistant.html">QueryAssistant</a>.</p>', 'GetSession' => '<p>Retrieves information for a specified session.</p>', 'ListAssistantAssociations' => '<p>Lists information about assistant associations.</p>', 'ListAssistants' => '<p>Lists information about assistants.</p>', 'ListContents' => '<p>Lists the content.</p>', 'ListImportJobs' => '<p>Lists information about import jobs.</p>', 'ListKnowledgeBases' => '<p>Lists the knowledge bases.</p>', 'ListQuickResponses' => '<p>Lists information about quick response.</p>', 'ListTagsForResource' => '<p>Lists the tags for the specified resource.</p>', 'NotifyRecommendationsReceived' => '<p>Removes the specified recommendations from the specified assistant\'s queue of newly available recommendations. You can use this API in conjunction with <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_GetRecommendations.html">GetRecommendations</a> and a <code>waitTimeSeconds</code> input for long-polling behavior and avoiding duplicate recommendations.</p>', 'QueryAssistant' => '<p>Performs a manual search against the specified assistant. To retrieve recommendations for an assistant, use <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_GetRecommendations.html">GetRecommendations</a>. </p>', 'RemoveKnowledgeBaseTemplateUri' => '<p>Removes a URI template from a knowledge base.</p>', 'SearchContent' => '<p>Searches for content in a specified knowledge base. Can be used to get a specific content resource by its name.</p>', 'SearchQuickResponses' => '<p>Searches existing Wisdom quick responses in a Wisdom knowledge base.</p>', 'SearchSessions' => '<p>Searches for sessions.</p>', 'StartContentUpload' => '<p>Get a URL to upload content to a knowledge base. To upload content, first make a PUT request to the returned URL with your file, making sure to include the required headers. Then use <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_CreateContent.html">CreateContent</a> to finalize the content creation process or <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_UpdateContent.html">UpdateContent</a> to modify an existing resource. You can only upload content to a knowledge base of type CUSTOM.</p>', 'StartImportJob' => '<p>Start an asynchronous job to import Wisdom resources from an uploaded source file. Before calling this API, use <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_StartContentUpload.html">StartContentUpload</a> to upload an asset that contains the resource data.</p> <ul> <li> <p>For importing Wisdom quick responses, you need to upload a csv file including the quick responses. For information about how to format the csv file for importing quick responses, see <a href="https://docs.aws.amazon.com/console/connect/quick-responses/add-data">Import quick responses</a>.</p> </li> </ul>', 'TagResource' => '<p>Adds the specified tags to the specified resource.</p>', 'UntagResource' => '<p>Removes the specified tags from the specified resource.</p>', 'UpdateContent' => '<p>Updates information about the content.</p>', 'UpdateKnowledgeBaseTemplateUri' => '<p>Updates the template URI of a knowledge base. This is only supported for knowledge bases of type EXTERNAL. Include a single variable in <code>${variable}</code> format; this interpolated by Wisdom using ingested content. For example, if you ingest a Salesforce article, it has an <code>Id</code> value, and you can set the template URI to <code>https://myInstanceName.lightning.force.com/lightning/r/Knowledge__kav/*${Id}*/view</code>. </p>', 'UpdateQuickResponse' => '<p>Updates an existing Wisdom quick response.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You do not have sufficient access to perform this action.</p>', 'refs' => [], ], 'AppIntegrationsConfiguration' => [ 'base' => '<p>Configuration information for Amazon AppIntegrations to automatically ingest content.</p>', 'refs' => [ 'SourceConfiguration$appIntegrations' => '<p>Configuration information for Amazon AppIntegrations to automatically ingest content.</p>', ], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'AssistantAssociationData$assistantArn' => '<p>The Amazon Resource Name (ARN) of the Wisdom assistant.</p>', 'AssistantAssociationData$assistantAssociationArn' => '<p>The Amazon Resource Name (ARN) of the assistant association.</p>', 'AssistantAssociationSummary$assistantArn' => '<p>The Amazon Resource Name (ARN) of the Wisdom assistant.</p>', 'AssistantAssociationSummary$assistantAssociationArn' => '<p>The Amazon Resource Name (ARN) of the assistant association.</p>', 'AssistantData$assistantArn' => '<p>The Amazon Resource Name (ARN) of the Wisdom assistant.</p>', 'AssistantSummary$assistantArn' => '<p>The Amazon Resource Name (ARN) of the Wisdom assistant.</p>', 'ContentData$contentArn' => '<p>The Amazon Resource Name (ARN) of the content.</p>', 'ContentData$knowledgeBaseArn' => '<p>The Amazon Resource Name (ARN) of the knowledge base.</p>', 'ContentReference$contentArn' => '<p>The Amazon Resource Name (ARN) of the content.</p>', 'ContentReference$knowledgeBaseArn' => '<p>The Amazon Resource Name (ARN) of the knowledge base.</p>', 'ContentSummary$contentArn' => '<p>The Amazon Resource Name (ARN) of the content.</p>', 'ContentSummary$knowledgeBaseArn' => '<p>The Amazon Resource Name (ARN) of the knowledge base.</p>', 'ImportJobData$knowledgeBaseArn' => '<p>The Amazon Resource Name (ARN) of the knowledge base.</p>', 'ImportJobSummary$knowledgeBaseArn' => '<p>The Amazon Resource Name (ARN) of the knowledge base.</p>', 'KnowledgeBaseAssociationData$knowledgeBaseArn' => '<p>The Amazon Resource Name (ARN) of the knowledge base.</p>', 'KnowledgeBaseData$knowledgeBaseArn' => '<p>The Amazon Resource Name (ARN) of the knowledge base.</p>', 'KnowledgeBaseSummary$knowledgeBaseArn' => '<p>The Amazon Resource Name (ARN) of the knowledge base.</p>', 'ListTagsForResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'QuickResponseData$knowledgeBaseArn' => '<p>The Amazon Resource Name (ARN) of the knowledge base.</p>', 'QuickResponseData$quickResponseArn' => '<p>The Amazon Resource Name (ARN) of the quick response.</p>', 'QuickResponseSearchResultData$knowledgeBaseArn' => '<p>The Amazon Resource Name (ARN) of the knowledge base.</p>', 'QuickResponseSearchResultData$quickResponseArn' => '<p>The Amazon Resource Name (ARN) of the quick response.</p>', 'QuickResponseSummary$knowledgeBaseArn' => '<p>The Amazon Resource Name (ARN) of the knowledge base.</p>', 'QuickResponseSummary$quickResponseArn' => '<p>The Amazon Resource Name (ARN) of the quick response.</p>', 'SessionData$sessionArn' => '<p>The Amazon Resource Name (ARN) of the session.</p>', 'SessionSummary$assistantArn' => '<p>The Amazon Resource Name (ARN) of the Wisdom assistant.</p>', 'SessionSummary$sessionArn' => '<p>The Amazon Resource Name (ARN) of the session.</p>', 'TagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'UntagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', ], ], 'AssistantAssociationData' => [ 'base' => '<p>Information about the assistant association.</p>', 'refs' => [ 'CreateAssistantAssociationResponse$assistantAssociation' => '<p>The assistant association.</p>', 'GetAssistantAssociationResponse$assistantAssociation' => '<p>The assistant association.</p>', ], ], 'AssistantAssociationInputData' => [ 'base' => '<p>The data that is input into Wisdom as a result of the assistant association.</p>', 'refs' => [ 'CreateAssistantAssociationRequest$association' => '<p>The identifier of the associated resource.</p>', ], ], 'AssistantAssociationOutputData' => [ 'base' => '<p>The data that is output as a result of the assistant association.</p>', 'refs' => [ 'AssistantAssociationData$associationData' => '<p>A union type that currently has a single argument, the knowledge base ID.</p>', 'AssistantAssociationSummary$associationData' => '<p>The association data.</p>', ], ], 'AssistantAssociationSummary' => [ 'base' => '<p>Summary information about the assistant association.</p>', 'refs' => [ 'AssistantAssociationSummaryList$member' => NULL, ], ], 'AssistantAssociationSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListAssistantAssociationsResponse$assistantAssociationSummaries' => '<p>Summary information about assistant associations.</p>', ], ], 'AssistantData' => [ 'base' => '<p>The assistant data.</p>', 'refs' => [ 'CreateAssistantResponse$assistant' => '<p>Information about the assistant.</p>', 'GetAssistantResponse$assistant' => '<p>Information about the assistant.</p>', ], ], 'AssistantIntegrationConfiguration' => [ 'base' => '<p>The configuration information for the Wisdom assistant integration.</p>', 'refs' => [ 'AssistantData$integrationConfiguration' => '<p>The configuration information for the Wisdom assistant integration.</p>', 'AssistantSummary$integrationConfiguration' => '<p>The configuration information for the Wisdom assistant integration.</p>', ], ], 'AssistantList' => [ 'base' => NULL, 'refs' => [ 'ListAssistantsResponse$assistantSummaries' => '<p>Information about the assistants.</p>', ], ], 'AssistantStatus' => [ 'base' => NULL, 'refs' => [ 'AssistantData$status' => '<p>The status of the assistant.</p>', 'AssistantSummary$status' => '<p>The status of the assistant.</p>', ], ], 'AssistantSummary' => [ 'base' => '<p>Summary information about the assistant.</p>', 'refs' => [ 'AssistantList$member' => NULL, ], ], 'AssistantType' => [ 'base' => NULL, 'refs' => [ 'AssistantData$type' => '<p>The type of assistant.</p>', 'AssistantSummary$type' => '<p>The type of the assistant.</p>', 'CreateAssistantRequest$type' => '<p>The type of assistant.</p>', ], ], 'AssociationType' => [ 'base' => NULL, 'refs' => [ 'AssistantAssociationData$associationType' => '<p>The type of association.</p>', 'AssistantAssociationSummary$associationType' => '<p>The type of association.</p>', 'CreateAssistantAssociationRequest$associationType' => '<p>The type of association.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'CreateQuickResponseRequest$isActive' => '<p>Whether the quick response is active.</p>', 'QuickResponseData$isActive' => '<p>Whether the quick response is active.</p>', 'QuickResponseFilterField$includeNoExistence' => '<p>Whether to treat null value as a match for the attribute field.</p>', 'QuickResponseQueryField$allowFuzziness' => '<p>Whether the query expects only exact matches on the attribute field values. The results of the query will only include exact matches if this parameter is set to false.</p>', 'QuickResponseSearchResultData$isActive' => '<p>Whether the quick response is active.</p>', 'QuickResponseSummary$isActive' => '<p>Whether the quick response is active.</p>', 'UpdateContentRequest$removeOverrideLinkOutUri' => '<p>Unset the existing <code>overrideLinkOutUri</code> if it exists.</p>', 'UpdateQuickResponseRequest$isActive' => '<p>Whether the quick response is active. </p>', 'UpdateQuickResponseRequest$removeDescription' => '<p>Whether to remove the description from the quick response.</p>', 'UpdateQuickResponseRequest$removeGroupingConfiguration' => '<p>Whether to remove the grouping configuration of the quick response.</p>', 'UpdateQuickResponseRequest$removeShortcutKey' => '<p>Whether to remove the shortcut key of the quick response.</p>', ], ], 'Channel' => [ 'base' => NULL, 'refs' => [ 'Channels$member' => NULL, ], ], 'Channels' => [ 'base' => NULL, 'refs' => [ 'CreateQuickResponseRequest$channels' => '<p>The Amazon Connect channels this quick response applies to.</p>', 'QuickResponseData$channels' => '<p>The Amazon Connect contact channels this quick response applies to. The supported contact channel types include <code>Chat</code>.</p>', 'QuickResponseSearchResultData$channels' => '<p>The Amazon Connect contact channels this quick response applies to. The supported contact channel types include <code>Chat</code>.</p>', 'QuickResponseSummary$channels' => '<p>The Amazon Connect contact channels this quick response applies to. The supported contact channel types include <code>Chat</code>.</p>', 'UpdateQuickResponseRequest$channels' => '<p>The Amazon Connect contact channels this quick response applies to. The supported contact channel types include <code>Chat</code>.</p>', ], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'CreateAssistantAssociationRequest$clientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with idempotent APIs</a>.</p>', 'CreateAssistantRequest$clientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with idempotent APIs</a>.</p>', 'CreateSessionRequest$clientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with idempotent APIs</a>.</p>', ], ], 'Configuration' => [ 'base' => '<p>The configuration information of the external data source.</p>', 'refs' => [ 'ExternalSourceConfiguration$configuration' => '<p>The configuration information of the external data source.</p>', ], ], 'ConflictException' => [ 'base' => '<p>The request could not be processed because of conflict in the current state of the resource. For example, if you\'re using a <code>Create</code> API (such as <code>CreateAssistant</code>) that accepts name, a conflicting resource (usually with the same name) is being created or mutated.</p>', 'refs' => [], ], 'ConnectConfiguration' => [ 'base' => '<p>The configuration information of the Amazon Connect data source.</p>', 'refs' => [ 'Configuration$connectConfiguration' => '<p>The configuration information of the Amazon Connect data source.</p>', ], ], 'ContactAttributeKey' => [ 'base' => NULL, 'refs' => [ 'ContactAttributeKeys$member' => NULL, 'ContactAttributes$key' => NULL, ], ], 'ContactAttributeKeys' => [ 'base' => NULL, 'refs' => [ 'QuickResponseSearchResultData$attributesInterpolated' => '<p>The user defined contact attributes that are resolved when the search result is returned.</p>', 'QuickResponseSearchResultData$attributesNotInterpolated' => '<p>The user defined contact attributes that are not resolved when the search result is returned.</p>', ], ], 'ContactAttributeValue' => [ 'base' => NULL, 'refs' => [ 'ContactAttributes$value' => NULL, ], ], 'ContactAttributes' => [ 'base' => NULL, 'refs' => [ 'SearchQuickResponsesRequest$attributes' => '<p>The <a href="https://docs.aws.amazon.com/connect/latest/adminguide/connect-attrib-list.html#user-defined-attributes">user-defined Amazon Connect contact attributes</a> to be resolved when search results are returned.</p>', ], ], 'ContentData' => [ 'base' => '<p>Information about the content.</p>', 'refs' => [ 'CreateContentResponse$content' => '<p>The content.</p>', 'GetContentResponse$content' => '<p>The content.</p>', 'UpdateContentResponse$content' => '<p>The content.</p>', ], ], 'ContentMetadata' => [ 'base' => NULL, 'refs' => [ 'ContentData$metadata' => '<p>A key/value map to store attributes without affecting tagging or recommendations. For example, when synchronizing data between an external system and Wisdom, you can store an external version identifier as metadata to utilize for determining drift.</p>', 'ContentSummary$metadata' => '<p>A key/value map to store attributes without affecting tagging or recommendations. For example, when synchronizing data between an external system and Wisdom, you can store an external version identifier as metadata to utilize for determining drift.</p>', 'CreateContentRequest$metadata' => '<p>A key/value map to store attributes without affecting tagging or recommendations. For example, when synchronizing data between an external system and Wisdom, you can store an external version identifier as metadata to utilize for determining drift.</p>', 'ImportJobData$metadata' => '<p>The metadata fields of the imported Wisdom resources.</p>', 'ImportJobSummary$metadata' => '<p>The metadata fields of the imported Wisdom resources.</p>', 'StartImportJobRequest$metadata' => '<p>The metadata fields of the imported Wisdom resources.</p>', 'UpdateContentRequest$metadata' => '<p>A key/value map to store attributes without affecting tagging or recommendations. For example, when synchronizing data between an external system and Wisdom, you can store an external version identifier as metadata to utilize for determining drift.</p>', ], ], 'ContentReference' => [ 'base' => '<p>Reference information about the content.</p>', 'refs' => [ 'Document$contentReference' => '<p>A reference to the content resource.</p>', ], ], 'ContentStatus' => [ 'base' => NULL, 'refs' => [ 'ContentData$status' => '<p>The status of the content.</p>', 'ContentSummary$status' => '<p>The status of the content.</p>', ], ], 'ContentSummary' => [ 'base' => '<p>Summary information about the content.</p>', 'refs' => [ 'ContentSummaryList$member' => NULL, 'GetContentSummaryResponse$contentSummary' => '<p>The content summary.</p>', ], ], 'ContentSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListContentsResponse$contentSummaries' => '<p>Information about the content.</p>', 'SearchContentResponse$contentSummaries' => '<p>Summary information about the content.</p>', ], ], 'ContentTitle' => [ 'base' => NULL, 'refs' => [ 'ContentData$title' => '<p>The title of the content.</p>', 'ContentSummary$title' => '<p>The title of the content.</p>', 'CreateContentRequest$title' => '<p>The title of the content. If not set, the title is equal to the name.</p>', 'UpdateContentRequest$title' => '<p>The title of the content.</p>', ], ], 'ContentType' => [ 'base' => NULL, 'refs' => [ 'ContentData$contentType' => '<p>The media type of the content.</p>', 'ContentSummary$contentType' => '<p>The media type of the content.</p>', 'StartContentUploadRequest$contentType' => '<p>The type of content to upload.</p>', ], ], 'CreateAssistantAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAssistantAssociationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateAssistantRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAssistantResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateContentRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateContentResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateKnowledgeBaseRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateKnowledgeBaseResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateQuickResponseRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateQuickResponseResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateSessionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSessionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAssistantAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAssistantAssociationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAssistantRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAssistantResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteContentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteContentResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteImportJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteImportJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteKnowledgeBaseRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteKnowledgeBaseResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteQuickResponseRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteQuickResponseResponse' => [ 'base' => NULL, 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'AssistantData$description' => '<p>The description.</p>', 'AssistantSummary$description' => '<p>The description of the assistant.</p>', 'CreateAssistantRequest$description' => '<p>The description of the assistant.</p>', 'CreateKnowledgeBaseRequest$description' => '<p>The description.</p>', 'CreateSessionRequest$description' => '<p>The description.</p>', 'KnowledgeBaseData$description' => '<p>The description.</p>', 'KnowledgeBaseSummary$description' => '<p>The description of the knowledge base.</p>', 'SessionData$description' => '<p>The description of the session.</p>', ], ], 'Document' => [ 'base' => '<p>The document.</p>', 'refs' => [ 'RecommendationData$document' => '<p>The recommended document.</p>', 'ResultData$document' => '<p>The document.</p>', ], ], 'DocumentText' => [ 'base' => '<p>The text of the document.</p>', 'refs' => [ 'Document$excerpt' => '<p>The excerpt from the document.</p>', 'Document$title' => '<p>The title of the document.</p>', ], ], 'ExternalSource' => [ 'base' => NULL, 'refs' => [ 'ExternalSourceConfiguration$source' => '<p>The type of the external data source.</p>', ], ], 'ExternalSourceConfiguration' => [ 'base' => '<p>The configuration information of the external data source.</p>', 'refs' => [ 'ImportJobData$externalSourceConfiguration' => NULL, 'ImportJobSummary$externalSourceConfiguration' => '<p>The configuration information of the external source that the resource data are imported from.</p>', 'StartImportJobRequest$externalSourceConfiguration' => '<p>The configuration information of the external source that the resource data are imported from.</p>', ], ], 'Filter' => [ 'base' => '<p>A search filter.</p>', 'refs' => [ 'FilterList$member' => NULL, ], ], 'FilterField' => [ 'base' => NULL, 'refs' => [ 'Filter$field' => '<p>The field on which to filter.</p>', ], ], 'FilterList' => [ 'base' => NULL, 'refs' => [ 'SearchExpression$filters' => '<p>The search expression filters.</p>', ], ], 'FilterOperator' => [ 'base' => NULL, 'refs' => [ 'Filter$operator' => '<p>The operator to use for comparing the field’s value with the provided value.</p>', ], ], 'GenericArn' => [ 'base' => NULL, 'refs' => [ 'AppIntegrationsConfiguration$appIntegrationArn' => '<p>The Amazon Resource Name (ARN) of the AppIntegrations DataIntegration to use for ingesting content.</p> <ul> <li> <p> For <a href="https://developer.salesforce.com/docs/atlas.en-us.knowledge_dev.meta/knowledge_dev/sforce_api_objects_knowledge__kav.htm"> Salesforce</a>, your AppIntegrations DataIntegration must have an ObjectConfiguration if objectFields is not provided, including at least <code>Id</code>, <code>ArticleNumber</code>, <code>VersionNumber</code>, <code>Title</code>, <code>PublishStatus</code>, and <code>IsDeleted</code> as source fields. </p> </li> <li> <p> For <a href="https://developer.servicenow.com/dev.do#!/reference/api/rome/rest/knowledge-management-api"> ServiceNow</a>, your AppIntegrations DataIntegration must have an ObjectConfiguration if objectFields is not provided, including at least <code>number</code>, <code>short_description</code>, <code>sys_mod_count</code>, <code>workflow_state</code>, and <code>active</code> as source fields. </p> </li> <li> <p> For <a href="https://developer.zendesk.com/api-reference/help_center/help-center-api/articles/"> Zendesk</a>, your AppIntegrations DataIntegration must have an ObjectConfiguration if <code>objectFields</code> is not provided, including at least <code>id</code>, <code>title</code>, <code>updated_at</code>, and <code>draft</code> as source fields. </p> </li> <li> <p> For <a href="https://learn.microsoft.com/en-us/sharepoint/dev/sp-add-ins/sharepoint-net-server-csom-jsom-and-rest-api-index">SharePoint</a>, your AppIntegrations DataIntegration must have a FileConfiguration, including only file extensions that are among <code>docx</code>, <code>pdf</code>, <code>html</code>, <code>htm</code>, and <code>txt</code>. </p> </li> <li> <p> For <a href="https://aws.amazon.com/s3/">Amazon S3</a>, the ObjectConfiguration and FileConfiguration of your AppIntegrations DataIntegration must be null. The <code>SourceURI</code> of your DataIntegration must use the following format: <code>s3://your_s3_bucket_name</code>.</p> <important> <p>The bucket policy of the corresponding S3 bucket must allow the Amazon Web Services principal <code>app-integrations.amazonaws.com</code> to perform <code>s3:ListBucket</code>, <code>s3:GetObject</code>, and <code>s3:GetBucketLocation</code> against the bucket.</p> </important> </li> </ul>', 'AssistantIntegrationConfiguration$topicIntegrationArn' => '<p>The Amazon Resource Name (ARN) of the integrated Amazon SNS topic used for streaming chat messages.</p>', 'QuickResponseData$lastModifiedBy' => '<p>The Amazon Resource Name (ARN) of the user who last updated the quick response data.</p>', 'QuickResponseSearchResultData$lastModifiedBy' => '<p>The Amazon Resource Name (ARN) of the user who last updated the quick response search result data.</p>', 'QuickResponseSummary$lastModifiedBy' => '<p>The Amazon Resource Name (ARN) of the user who last updated the quick response data.</p>', 'SessionIntegrationConfiguration$topicIntegrationArn' => '<p>The Amazon Resource Name (ARN) of the integrated Amazon SNS topic used for streaming chat messages.</p>', ], ], 'GetAssistantAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAssistantAssociationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetAssistantRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAssistantResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetContentRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetContentResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetContentSummaryRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetContentSummaryResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetImportJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetImportJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetKnowledgeBaseRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetKnowledgeBaseResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetQuickResponseRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetQuickResponseResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetRecommendationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetRecommendationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetSessionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSessionResponse' => [ 'base' => NULL, 'refs' => [], ], 'GroupingConfiguration' => [ 'base' => '<p>The configuration information of the grouping of Wisdom users.</p>', 'refs' => [ 'CreateQuickResponseRequest$groupingConfiguration' => '<p>The configuration information of the user groups that the quick response is accessible to.</p>', 'QuickResponseData$groupingConfiguration' => '<p>The configuration information of the user groups that the quick response is accessible to.</p>', 'QuickResponseSearchResultData$groupingConfiguration' => '<p>The configuration information of the user groups that the quick response is accessible to.</p>', 'UpdateQuickResponseRequest$groupingConfiguration' => '<p>The updated grouping configuration of the quick response.</p>', ], ], 'GroupingCriteria' => [ 'base' => NULL, 'refs' => [ 'GroupingConfiguration$criteria' => '<p>The criteria used for grouping Wisdom users.</p> <p>The following is the list of supported criteria values.</p> <ul> <li> <p> <code>RoutingProfileArn</code>: Grouping the users by their <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_RoutingProfile.html">Amazon Connect routing profile ARN</a>. User should have <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_SearchRoutingProfiles.html">SearchRoutingProfile</a> and <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeRoutingProfile.html">DescribeRoutingProfile</a> permissions when setting criteria to this value.</p> </li> </ul>', ], ], 'GroupingValue' => [ 'base' => NULL, 'refs' => [ 'GroupingValues$member' => NULL, ], ], 'GroupingValues' => [ 'base' => NULL, 'refs' => [ 'GroupingConfiguration$values' => '<p>The list of values that define different groups of Wisdom users.</p> <ul> <li> <p>When setting <code>criteria</code> to <code>RoutingProfileArn</code>, you need to provide a list of ARNs of <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_RoutingProfile.html">Amazon Connect routing profiles</a> as values of this parameter.</p> </li> </ul>', ], ], 'Headers' => [ 'base' => NULL, 'refs' => [ 'StartContentUploadResponse$headersToInclude' => '<p>The headers to include in the upload.</p>', ], ], 'Highlight' => [ 'base' => '<p>Offset specification to describe highlighting of document excerpts for rendering search results and recommendations.</p>', 'refs' => [ 'Highlights$member' => NULL, ], ], 'HighlightOffset' => [ 'base' => NULL, 'refs' => [ 'Highlight$beginOffsetInclusive' => '<p>The offset for the start of the highlight.</p>', 'Highlight$endOffsetExclusive' => '<p>The offset for the end of the highlight.</p>', ], ], 'Highlights' => [ 'base' => NULL, 'refs' => [ 'DocumentText$highlights' => '<p>Highlights in the document text.</p>', ], ], 'ImportJobData' => [ 'base' => '<p>Summary information about the import job.</p>', 'refs' => [ 'GetImportJobResponse$importJob' => '<p>The import job.</p>', 'StartImportJobResponse$importJob' => '<p>The import job.</p>', ], ], 'ImportJobList' => [ 'base' => NULL, 'refs' => [ 'ListImportJobsResponse$importJobSummaries' => '<p>Summary information about the import jobs.</p>', ], ], 'ImportJobStatus' => [ 'base' => NULL, 'refs' => [ 'ImportJobData$status' => '<p>The status of the import job.</p>', 'ImportJobSummary$status' => '<p>The status of the import job.</p>', ], ], 'ImportJobSummary' => [ 'base' => '<p>Summary information about the import job.</p>', 'refs' => [ 'ImportJobList$member' => NULL, ], ], 'ImportJobType' => [ 'base' => NULL, 'refs' => [ 'ImportJobData$importJobType' => '<p>The type of the import job.</p>', 'ImportJobSummary$importJobType' => '<p>The type of import job.</p>', 'StartImportJobRequest$importJobType' => '<p>The type of the import job.</p> <ul> <li> <p>For importing quick response resource, set the value to <code>QUICK_RESPONSES</code>.</p> </li> </ul>', ], ], 'KnowledgeBaseAssociationData' => [ 'base' => '<p>Association information about the knowledge base.</p>', 'refs' => [ 'AssistantAssociationOutputData$knowledgeBaseAssociation' => '<p>The knowledge base where output data is sent.</p>', ], ], 'KnowledgeBaseData' => [ 'base' => '<p>Information about the knowledge base.</p>', 'refs' => [ 'CreateKnowledgeBaseResponse$knowledgeBase' => '<p>The knowledge base.</p>', 'GetKnowledgeBaseResponse$knowledgeBase' => '<p>The knowledge base.</p>', 'UpdateKnowledgeBaseTemplateUriResponse$knowledgeBase' => '<p>The knowledge base to update.</p>', ], ], 'KnowledgeBaseList' => [ 'base' => NULL, 'refs' => [ 'ListKnowledgeBasesResponse$knowledgeBaseSummaries' => '<p>Information about the knowledge bases.</p>', ], ], 'KnowledgeBaseStatus' => [ 'base' => NULL, 'refs' => [ 'KnowledgeBaseData$status' => '<p>The status of the knowledge base.</p>', 'KnowledgeBaseSummary$status' => '<p>The status of the knowledge base summary.</p>', ], ], 'KnowledgeBaseSummary' => [ 'base' => '<p>Summary information about the knowledge base.</p>', 'refs' => [ 'KnowledgeBaseList$member' => NULL, ], ], 'KnowledgeBaseType' => [ 'base' => NULL, 'refs' => [ 'CreateKnowledgeBaseRequest$knowledgeBaseType' => '<p>The type of knowledge base. Only CUSTOM knowledge bases allow you to upload your own content. EXTERNAL knowledge bases support integrations with third-party systems whose content is synchronized automatically. </p>', 'KnowledgeBaseData$knowledgeBaseType' => '<p>The type of knowledge base.</p>', 'KnowledgeBaseSummary$knowledgeBaseType' => '<p>The type of knowledge base.</p>', ], ], 'LanguageCode' => [ 'base' => NULL, 'refs' => [ 'CreateQuickResponseRequest$language' => '<p>The language code value for the language in which the quick response is written. The supported language codes include <code>de_DE</code>, <code>en_US</code>, <code>es_ES</code>, <code>fr_FR</code>, <code>id_ID</code>, <code>it_IT</code>, <code>ja_JP</code>, <code>ko_KR</code>, <code>pt_BR</code>, <code>zh_CN</code>, <code>zh_TW</code> </p>', 'QuickResponseData$language' => '<p>The language code value for the language in which the quick response is written.</p>', 'QuickResponseSearchResultData$language' => '<p>The language code value for the language in which the quick response is written.</p>', 'UpdateQuickResponseRequest$language' => '<p>The language code value for the language in which the quick response is written. The supported language codes include <code>de_DE</code>, <code>en_US</code>, <code>es_ES</code>, <code>fr_FR</code>, <code>id_ID</code>, <code>it_IT</code>, <code>ja_JP</code>, <code>ko_KR</code>, <code>pt_BR</code>, <code>zh_CN</code>, <code>zh_TW</code> </p>', ], ], 'ListAssistantAssociationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAssistantAssociationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAssistantsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAssistantsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListContentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListContentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListImportJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListImportJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListKnowledgeBasesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListKnowledgeBasesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListQuickResponsesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListQuickResponsesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'GetRecommendationsRequest$maxResults' => '<p>The maximum number of results to return per page.</p>', 'ListAssistantAssociationsRequest$maxResults' => '<p>The maximum number of results to return per page.</p>', 'ListAssistantsRequest$maxResults' => '<p>The maximum number of results to return per page.</p>', 'ListContentsRequest$maxResults' => '<p>The maximum number of results to return per page.</p>', 'ListImportJobsRequest$maxResults' => '<p>The maximum number of results to return per page.</p>', 'ListKnowledgeBasesRequest$maxResults' => '<p>The maximum number of results to return per page.</p>', 'ListQuickResponsesRequest$maxResults' => '<p>The maximum number of results to return per page.</p>', 'QueryAssistantRequest$maxResults' => '<p>The maximum number of results to return per page.</p>', 'SearchContentRequest$maxResults' => '<p>The maximum number of results to return per page.</p>', 'SearchQuickResponsesRequest$maxResults' => '<p>The maximum number of results to return per page.</p>', 'SearchSessionsRequest$maxResults' => '<p>The maximum number of results to return per page.</p>', ], ], 'Name' => [ 'base' => NULL, 'refs' => [ 'AssistantData$name' => '<p>The name.</p>', 'AssistantSummary$name' => '<p>The name of the assistant.</p>', 'ContentData$name' => '<p>The name of the content.</p>', 'ContentSummary$name' => '<p>The name of the content.</p>', 'CreateAssistantRequest$name' => '<p>The name of the assistant.</p>', 'CreateContentRequest$name' => '<p>The name of the content. Each piece of content in a knowledge base must have a unique name. You can retrieve a piece of content using only its knowledge base and its name with the <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_SearchContent.html">SearchContent</a> API.</p>', 'CreateKnowledgeBaseRequest$name' => '<p>The name of the knowledge base.</p>', 'CreateSessionRequest$name' => '<p>The name of the session.</p>', 'KnowledgeBaseData$name' => '<p>The name of the knowledge base.</p>', 'KnowledgeBaseSummary$name' => '<p>The name of the knowledge base.</p>', 'SessionData$name' => '<p>The name of the session.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListAssistantAssociationsRequest$nextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListAssistantAssociationsResponse$nextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListAssistantsRequest$nextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListAssistantsResponse$nextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListContentsRequest$nextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListContentsResponse$nextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'QueryAssistantRequest$nextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'QueryAssistantResponse$nextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'SearchContentRequest$nextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'SearchContentResponse$nextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'SearchSessionsRequest$nextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'SearchSessionsResponse$nextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', ], ], 'NonEmptyString' => [ 'base' => NULL, 'refs' => [ 'ConnectConfiguration$instanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'ContentData$revisionId' => '<p>The identifier of the content revision.</p>', 'ContentMetadata$key' => NULL, 'ContentMetadata$value' => NULL, 'ContentSummary$revisionId' => '<p>The identifier of the revision of the content.</p>', 'CreateContentRequest$clientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with idempotent APIs</a>.</p>', 'CreateKnowledgeBaseRequest$clientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with idempotent APIs</a>.</p>', 'CreateQuickResponseRequest$clientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with idempotent APIs</a>.</p>', 'Filter$value' => '<p>The desired field value on which to filter.</p>', 'Headers$key' => NULL, 'Headers$value' => NULL, 'ListImportJobsRequest$nextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListImportJobsResponse$nextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListKnowledgeBasesRequest$nextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListKnowledgeBasesResponse$nextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListQuickResponsesRequest$nextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListQuickResponsesResponse$nextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ObjectFieldsList$member' => NULL, 'QuickResponseFilterField$name' => '<p>The name of the attribute field to filter the quick responses by.</p>', 'QuickResponseOrderField$name' => '<p>The name of the attribute to order the quick response query results by.</p>', 'QuickResponseQueryField$name' => '<p>The name of the attribute to query the quick responses by.</p>', 'SearchQuickResponsesRequest$nextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'SearchQuickResponsesResponse$nextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ServerSideEncryptionConfiguration$kmsKeyId' => '<p>The customer managed key used for encryption. For more information about setting up a customer managed key for Wisdom, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/enable-wisdom.html">Enable Amazon Connect Wisdom for your instance</a>. For information about valid ID values, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id">Key identifiers (KeyId)</a>.</p>', 'StartImportJobRequest$clientToken' => '<p>The tags used to organize, track, or control access for this resource.</p>', 'UpdateContentRequest$revisionId' => '<p>The <code>revisionId</code> of the content resource to update, taken from an earlier call to <code>GetContent</code>, <code>GetContentSummary</code>, <code>SearchContent</code>, or <code>ListContents</code>. If included, this argument acts as an optimistic lock to ensure content was not modified since it was last read. If it has been modified, this API throws a <code>PreconditionFailedException</code>.</p>', ], ], 'NotifyRecommendationsReceivedError' => [ 'base' => '<p>An error occurred when creating a recommendation.</p>', 'refs' => [ 'NotifyRecommendationsReceivedErrorList$member' => NULL, ], ], 'NotifyRecommendationsReceivedErrorList' => [ 'base' => NULL, 'refs' => [ 'NotifyRecommendationsReceivedResponse$errors' => '<p>The identifiers of recommendations that are causing errors.</p>', ], ], 'NotifyRecommendationsReceivedErrorMessage' => [ 'base' => NULL, 'refs' => [ 'NotifyRecommendationsReceivedError$message' => '<p>A recommendation is causing an error.</p>', ], ], 'NotifyRecommendationsReceivedRequest' => [ 'base' => NULL, 'refs' => [], ], 'NotifyRecommendationsReceivedResponse' => [ 'base' => NULL, 'refs' => [], ], 'ObjectFieldsList' => [ 'base' => NULL, 'refs' => [ 'AppIntegrationsConfiguration$objectFields' => '<p>The fields from the source that are made available to your agents in Wisdom. Optional if ObjectConfiguration is included in the provided DataIntegration. </p> <ul> <li> <p> For <a href="https://developer.salesforce.com/docs/atlas.en-us.knowledge_dev.meta/knowledge_dev/sforce_api_objects_knowledge__kav.htm"> Salesforce</a>, you must include at least <code>Id</code>, <code>ArticleNumber</code>, <code>VersionNumber</code>, <code>Title</code>, <code>PublishStatus</code>, and <code>IsDeleted</code>. </p> </li> <li> <p>For <a href="https://developer.servicenow.com/dev.do#!/reference/api/rome/rest/knowledge-management-api"> ServiceNow</a>, you must include at least <code>number</code>, <code>short_description</code>, <code>sys_mod_count</code>, <code>workflow_state</code>, and <code>active</code>. </p> </li> <li> <p>For <a href="https://developer.zendesk.com/api-reference/help_center/help-center-api/articles/"> Zendesk</a>, you must include at least <code>id</code>, <code>title</code>, <code>updated_at</code>, and <code>draft</code>. </p> </li> </ul> <p>Make sure to include additional fields. These fields are indexed and used to source recommendations. </p>', ], ], 'Order' => [ 'base' => NULL, 'refs' => [ 'QuickResponseOrderField$order' => '<p>The order at which the quick responses are sorted by.</p>', ], ], 'PreconditionFailedException' => [ 'base' => '<p>The provided <code>revisionId</code> does not match, indicating the content has been modified since it was last read.</p>', 'refs' => [], ], 'Priority' => [ 'base' => NULL, 'refs' => [ 'QuickResponseQueryField$priority' => '<p>The importance of the attribute field when calculating query result relevancy scores. The value set for this parameter affects the ordering of search results.</p>', ], ], 'QueryAssistantRequest' => [ 'base' => NULL, 'refs' => [], ], 'QueryAssistantResponse' => [ 'base' => NULL, 'refs' => [], ], 'QueryRecommendationTriggerData' => [ 'base' => '<p>Data associated with the QUERY RecommendationTriggerType.</p>', 'refs' => [ 'RecommendationTriggerData$query' => '<p>Data associated with the QUERY RecommendationTriggerType.</p>', ], ], 'QueryResultsList' => [ 'base' => NULL, 'refs' => [ 'QueryAssistantResponse$results' => '<p>The results of the query.</p>', ], ], 'QueryText' => [ 'base' => NULL, 'refs' => [ 'QueryAssistantRequest$queryText' => '<p>The text to search for.</p>', 'QueryRecommendationTriggerData$text' => '<p>The text associated with the recommendation trigger.</p>', ], ], 'QuickResponseContent' => [ 'base' => NULL, 'refs' => [ 'QuickResponseContentProvider$content' => '<p>The content of the quick response.</p>', 'QuickResponseDataProvider$content' => '<p>The content of the quick response.</p>', ], ], 'QuickResponseContentProvider' => [ 'base' => '<p>The container quick response content.</p>', 'refs' => [ 'QuickResponseContents$markdown' => NULL, 'QuickResponseContents$plainText' => NULL, ], ], 'QuickResponseContents' => [ 'base' => '<p>The content of the quick response stored in different media types.</p>', 'refs' => [ 'QuickResponseData$contents' => '<p>The contents of the quick response.</p>', 'QuickResponseSearchResultData$contents' => '<p>The contents of the quick response.</p>', ], ], 'QuickResponseData' => [ 'base' => '<p>Information about the quick response.</p>', 'refs' => [ 'CreateQuickResponseResponse$quickResponse' => '<p>The quick response.</p>', 'GetQuickResponseResponse$quickResponse' => '<p>The quick response.</p>', 'UpdateQuickResponseResponse$quickResponse' => '<p>The quick response.</p>', ], ], 'QuickResponseDataProvider' => [ 'base' => '<p>The container of quick response data.</p>', 'refs' => [ 'CreateQuickResponseRequest$content' => '<p>The content of the quick response.</p>', 'UpdateQuickResponseRequest$content' => '<p>The updated content of the quick response.</p>', ], ], 'QuickResponseDescription' => [ 'base' => NULL, 'refs' => [ 'CreateQuickResponseRequest$description' => '<p>The description of the quick response.</p>', 'QuickResponseData$description' => '<p>The description of the quick response.</p>', 'QuickResponseSearchResultData$description' => '<p>The description of the quick response.</p>', 'QuickResponseSummary$description' => '<p>The description of the quick response.</p>', 'UpdateQuickResponseRequest$description' => '<p>The updated description of the quick response.</p>', ], ], 'QuickResponseFilterField' => [ 'base' => '<p>The quick response fields to filter the quick response query results by.</p> <p>The following is the list of supported field names.</p> <ul> <li> <p>name</p> </li> <li> <p>description</p> </li> <li> <p>shortcutKey</p> </li> <li> <p>isActive</p> </li> <li> <p>channels</p> </li> <li> <p>language</p> </li> <li> <p>contentType</p> </li> <li> <p>createdTime</p> </li> <li> <p>lastModifiedTime</p> </li> <li> <p>lastModifiedBy</p> </li> <li> <p>groupingConfiguration.criteria</p> </li> <li> <p>groupingConfiguration.values</p> </li> </ul>', 'refs' => [ 'QuickResponseFilterFieldList$member' => NULL, ], ], 'QuickResponseFilterFieldList' => [ 'base' => NULL, 'refs' => [ 'QuickResponseSearchExpression$filters' => '<p>The configuration of filtering rules applied to quick response query results.</p>', ], ], 'QuickResponseFilterOperator' => [ 'base' => NULL, 'refs' => [ 'QuickResponseFilterField$operator' => '<p>The operator to use for filtering.</p>', ], ], 'QuickResponseFilterValue' => [ 'base' => NULL, 'refs' => [ 'QuickResponseFilterValueList$member' => NULL, ], ], 'QuickResponseFilterValueList' => [ 'base' => NULL, 'refs' => [ 'QuickResponseFilterField$values' => '<p>The values of attribute field to filter the quick response by.</p>', ], ], 'QuickResponseName' => [ 'base' => NULL, 'refs' => [ 'CreateQuickResponseRequest$name' => '<p>The name of the quick response.</p>', 'QuickResponseData$name' => '<p>The name of the quick response.</p>', 'QuickResponseSearchResultData$name' => '<p>The name of the quick response.</p>', 'QuickResponseSummary$name' => '<p>The name of the quick response.</p>', 'UpdateQuickResponseRequest$name' => '<p>The name of the quick response.</p>', ], ], 'QuickResponseOrderField' => [ 'base' => '<p>The quick response fields to order the quick response query results by.</p> <p>The following is the list of supported field names.</p> <ul> <li> <p>name</p> </li> <li> <p>description</p> </li> <li> <p>shortcutKey</p> </li> <li> <p>isActive</p> </li> <li> <p>channels</p> </li> <li> <p>language</p> </li> <li> <p>contentType</p> </li> <li> <p>createdTime</p> </li> <li> <p>lastModifiedTime</p> </li> <li> <p>lastModifiedBy</p> </li> <li> <p>groupingConfiguration.criteria</p> </li> <li> <p>groupingConfiguration.values</p> </li> </ul>', 'refs' => [ 'QuickResponseSearchExpression$orderOnField' => '<p>The quick response attribute fields on which the query results are ordered.</p>', ], ], 'QuickResponseQueryField' => [ 'base' => '<p>The quick response fields to query quick responses by.</p> <p>The following is the list of supported field names.</p> <ul> <li> <p>content</p> </li> <li> <p>name</p> </li> <li> <p>description</p> </li> <li> <p>shortcutKey</p> </li> </ul>', 'refs' => [ 'QuickResponseQueryFieldList$member' => NULL, ], ], 'QuickResponseQueryFieldList' => [ 'base' => NULL, 'refs' => [ 'QuickResponseSearchExpression$queries' => '<p>The quick response query expressions.</p>', ], ], 'QuickResponseQueryOperator' => [ 'base' => NULL, 'refs' => [ 'QuickResponseQueryField$operator' => '<p>The operator to use for matching attribute field values in the query.</p>', ], ], 'QuickResponseQueryValue' => [ 'base' => NULL, 'refs' => [ 'QuickResponseQueryValueList$member' => NULL, ], ], 'QuickResponseQueryValueList' => [ 'base' => NULL, 'refs' => [ 'QuickResponseQueryField$values' => '<p>The values of the attribute to query the quick responses by.</p>', ], ], 'QuickResponseSearchExpression' => [ 'base' => '<p>Information about the import job.</p>', 'refs' => [ 'SearchQuickResponsesRequest$searchExpression' => '<p>The search expression for querying the quick response.</p>', ], ], 'QuickResponseSearchResultData' => [ 'base' => '<p>The result of quick response search.</p>', 'refs' => [ 'QuickResponseSearchResultsList$member' => NULL, ], ], 'QuickResponseSearchResultsList' => [ 'base' => NULL, 'refs' => [ 'SearchQuickResponsesResponse$results' => '<p>The results of the quick response search.</p>', ], ], 'QuickResponseStatus' => [ 'base' => NULL, 'refs' => [ 'QuickResponseData$status' => '<p>The status of the quick response data.</p>', 'QuickResponseSearchResultData$status' => '<p>The resource status of the quick response.</p>', 'QuickResponseSummary$status' => '<p>The resource status of the quick response.</p>', ], ], 'QuickResponseSummary' => [ 'base' => '<p>The summary information about the quick response.</p>', 'refs' => [ 'QuickResponseSummaryList$member' => NULL, ], ], 'QuickResponseSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListQuickResponsesResponse$quickResponseSummaries' => '<p>Summary information about the quick responses.</p>', ], ], 'QuickResponseType' => [ 'base' => NULL, 'refs' => [ 'CreateQuickResponseRequest$contentType' => '<p>The media type of the quick response content.</p> <ul> <li> <p>Use <code>application/x.quickresponse;format=plain</code> for a quick response written in plain text.</p> </li> <li> <p>Use <code>application/x.quickresponse;format=markdown</code> for a quick response written in richtext.</p> </li> </ul>', 'QuickResponseData$contentType' => '<p>The media type of the quick response content.</p> <ul> <li> <p>Use <code>application/x.quickresponse;format=plain</code> for quick response written in plain text.</p> </li> <li> <p>Use <code>application/x.quickresponse;format=markdown</code> for quick response written in richtext.</p> </li> </ul>', 'QuickResponseSearchResultData$contentType' => '<p>The media type of the quick response content.</p> <ul> <li> <p>Use <code>application/x.quickresponse;format=plain</code> for quick response written in plain text.</p> </li> <li> <p>Use <code>application/x.quickresponse;format=markdown</code> for quick response written in richtext.</p> </li> </ul>', 'QuickResponseSummary$contentType' => '<p>The media type of the quick response content.</p> <ul> <li> <p>Use <code>application/x.quickresponse;format=plain</code> for quick response written in plain text.</p> </li> <li> <p>Use <code>application/x.quickresponse;format=markdown</code> for quick response written in richtext.</p> </li> </ul>', 'UpdateQuickResponseRequest$contentType' => '<p>The media type of the quick response content.</p> <ul> <li> <p>Use <code>application/x.quickresponse;format=plain</code> for quick response written in plain text.</p> </li> <li> <p>Use <code>application/x.quickresponse;format=markdown</code> for quick response written in richtext.</p> </li> </ul>', ], ], 'RecommendationData' => [ 'base' => '<p>Information about the recommendation.</p>', 'refs' => [ 'RecommendationList$member' => NULL, ], ], 'RecommendationIdList' => [ 'base' => NULL, 'refs' => [ 'NotifyRecommendationsReceivedRequest$recommendationIds' => '<p>The identifiers of the recommendations.</p>', 'NotifyRecommendationsReceivedResponse$recommendationIds' => '<p>The identifiers of the recommendations.</p>', 'RecommendationTrigger$recommendationIds' => '<p>The identifiers of the recommendations.</p>', ], ], 'RecommendationList' => [ 'base' => NULL, 'refs' => [ 'GetRecommendationsResponse$recommendations' => '<p>The recommendations.</p>', ], ], 'RecommendationSourceType' => [ 'base' => NULL, 'refs' => [ 'RecommendationTrigger$source' => '<p>The source of the recommendation trigger.</p> <ul> <li> <p>ISSUE_DETECTION: The corresponding recommendations were triggered by a Contact Lens issue.</p> </li> <li> <p>RULE_EVALUATION: The corresponding recommendations were triggered by a Contact Lens rule.</p> </li> </ul>', ], ], 'RecommendationTrigger' => [ 'base' => '<p>A recommendation trigger provides context on the event that produced the referenced recommendations. Recommendations are only referenced in <code>recommendationIds</code> by a single RecommendationTrigger.</p>', 'refs' => [ 'RecommendationTriggerList$member' => NULL, ], ], 'RecommendationTriggerData' => [ 'base' => '<p>A union type containing information related to the trigger.</p>', 'refs' => [ 'RecommendationTrigger$data' => '<p>A union type containing information related to the trigger.</p>', ], ], 'RecommendationTriggerList' => [ 'base' => NULL, 'refs' => [ 'GetRecommendationsResponse$triggers' => '<p>The triggers corresponding to recommendations.</p>', ], ], 'RecommendationTriggerType' => [ 'base' => NULL, 'refs' => [ 'RecommendationTrigger$type' => '<p>The type of recommendation trigger.</p>', ], ], 'RecommendationType' => [ 'base' => NULL, 'refs' => [ 'RecommendationData$type' => '<p>The type of recommendation.</p>', ], ], 'RelevanceLevel' => [ 'base' => NULL, 'refs' => [ 'RecommendationData$relevanceLevel' => '<p>The relevance level of the recommendation.</p>', ], ], 'RelevanceScore' => [ 'base' => NULL, 'refs' => [ 'RecommendationData$relevanceScore' => '<p>The relevance score of the recommendation.</p>', 'ResultData$relevanceScore' => '<p>The relevance score of the results.</p>', ], ], 'RemoveKnowledgeBaseTemplateUriRequest' => [ 'base' => NULL, 'refs' => [], ], 'RemoveKnowledgeBaseTemplateUriResponse' => [ 'base' => NULL, 'refs' => [], ], 'RenderingConfiguration' => [ 'base' => '<p>Information about how to render the content.</p>', 'refs' => [ 'CreateKnowledgeBaseRequest$renderingConfiguration' => '<p>Information about how to render the content.</p>', 'KnowledgeBaseData$renderingConfiguration' => '<p>Information about how to render the content.</p>', 'KnowledgeBaseSummary$renderingConfiguration' => '<p>Information about how to render the content.</p>', ], ], 'RequestTimeoutException' => [ 'base' => '<p>The request reached the service more than 15 minutes after the date stamp on the request or more than 15 minutes after the request expiration date (such as for pre-signed URLs), or the date stamp on the request is more than 15 minutes in the future.</p>', 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>The specified resource does not exist.</p>', 'refs' => [], ], 'ResultData' => [ 'base' => '<p>Information about the result.</p>', 'refs' => [ 'QueryResultsList$member' => NULL, ], ], 'SearchContentRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchContentResponse' => [ 'base' => NULL, 'refs' => [], ], 'SearchExpression' => [ 'base' => '<p>The search expression.</p>', 'refs' => [ 'SearchContentRequest$searchExpression' => '<p>The search expression to filter results.</p>', 'SearchSessionsRequest$searchExpression' => '<p>The search expression to filter results.</p>', ], ], 'SearchQuickResponsesRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchQuickResponsesResponse' => [ 'base' => NULL, 'refs' => [], ], 'SearchSessionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchSessionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'SensitiveString' => [ 'base' => NULL, 'refs' => [ 'DocumentText$text' => '<p>Text in the document.</p>', ], ], 'ServerSideEncryptionConfiguration' => [ 'base' => '<p>The configuration information for the customer managed key used for encryption.</p>', 'refs' => [ 'AssistantData$serverSideEncryptionConfiguration' => '<p>The configuration information for the customer managed key used for encryption. </p> <p>This KMS key must have a policy that allows <code>kms:CreateGrant</code>, <code>kms:DescribeKey</code>, and <code>kms:Decrypt/kms:GenerateDataKey</code> permissions to the IAM identity using the key to invoke Wisdom. To use Wisdom with chat, the key policy must also allow <code>kms:Decrypt</code>, <code>kms:GenerateDataKey*</code>, and <code>kms:DescribeKey</code> permissions to the <code>connect.amazonaws.com</code> service principal. </p> <p>For more information about setting up a customer managed key for Wisdom, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/enable-wisdom.html">Enable Amazon Connect Wisdom for your instance</a>.</p>', 'AssistantSummary$serverSideEncryptionConfiguration' => '<p>The configuration information for the customer managed key used for encryption. </p> <p>This KMS key must have a policy that allows <code>kms:CreateGrant</code>, <code>kms:DescribeKey</code>, and <code>kms:Decrypt/kms:GenerateDataKey</code> permissions to the IAM identity using the key to invoke Wisdom. To use Wisdom with chat, the key policy must also allow <code>kms:Decrypt</code>, <code>kms:GenerateDataKey*</code>, and <code>kms:DescribeKey</code> permissions to the <code>connect.amazonaws.com</code> service principal. </p> <p>For more information about setting up a customer managed key for Wisdom, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/enable-wisdom.html">Enable Amazon Connect Wisdom for your instance</a>.</p>', 'CreateAssistantRequest$serverSideEncryptionConfiguration' => '<p>The configuration information for the customer managed key used for encryption. </p> <p>The customer managed key must have a policy that allows <code>kms:CreateGrant</code>, <code> kms:DescribeKey</code>, and <code>kms:Decrypt/kms:GenerateDataKey</code> permissions to the IAM identity using the key to invoke Wisdom. To use Wisdom with chat, the key policy must also allow <code>kms:Decrypt</code>, <code>kms:GenerateDataKey*</code>, and <code>kms:DescribeKey</code> permissions to the <code>connect.amazonaws.com</code> service principal. </p> <p>For more information about setting up a customer managed key for Wisdom, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/enable-wisdom.html">Enable Amazon Connect Wisdom for your instance</a>.</p>', 'CreateKnowledgeBaseRequest$serverSideEncryptionConfiguration' => '<p>The configuration information for the customer managed key used for encryption. </p> <p>This KMS key must have a policy that allows <code>kms:CreateGrant</code>, <code>kms:DescribeKey</code>, and <code>kms:Decrypt/kms:GenerateDataKey</code> permissions to the IAM identity using the key to invoke Wisdom.</p> <p>For more information about setting up a customer managed key for Wisdom, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/enable-wisdom.html">Enable Amazon Connect Wisdom for your instance</a>.</p>', 'KnowledgeBaseData$serverSideEncryptionConfiguration' => '<p>The configuration information for the customer managed key used for encryption. </p> <p>This KMS key must have a policy that allows <code>kms:CreateGrant</code>, <code>kms:DescribeKey</code>, and <code>kms:Decrypt/kms:GenerateDataKey</code> permissions to the IAM identity using the key to invoke Wisdom. </p> <p>For more information about setting up a customer managed key for Wisdom, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/enable-wisdom.html">Enable Amazon Connect Wisdom for your instance</a>.</p>', 'KnowledgeBaseSummary$serverSideEncryptionConfiguration' => '<p>The configuration information for the customer managed key used for encryption. </p> <p>This KMS key must have a policy that allows <code>kms:CreateGrant</code>, <code>kms:DescribeKey</code>, <code>kms:Decrypt/kms:GenerateDataKey</code> permissions to the IAM identity using the key to invoke Wisdom. </p> <p>For more information about setting up a customer managed key for Wisdom, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/enable-wisdom.html">Enable Amazon Connect Wisdom for your instance</a>.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>You\'ve exceeded your service quota. To perform the requested action, remove some of the relevant resources, or use service quotas to request a service quota increase.</p>', 'refs' => [], ], 'SessionData' => [ 'base' => '<p>Information about the session.</p>', 'refs' => [ 'CreateSessionResponse$session' => '<p>The session.</p>', 'GetSessionResponse$session' => '<p>The session.</p>', ], ], 'SessionIntegrationConfiguration' => [ 'base' => '<p>The configuration information for the session integration.</p>', 'refs' => [ 'SessionData$integrationConfiguration' => '<p>The configuration information for the session integration.</p>', ], ], 'SessionSummaries' => [ 'base' => NULL, 'refs' => [ 'SearchSessionsResponse$sessionSummaries' => '<p>Summary information about the sessions.</p>', ], ], 'SessionSummary' => [ 'base' => '<p>Summary information about the session.</p>', 'refs' => [ 'SessionSummaries$member' => NULL, ], ], 'ShortCutKey' => [ 'base' => NULL, 'refs' => [ 'CreateQuickResponseRequest$shortcutKey' => '<p>The shortcut key of the quick response. The value should be unique across the knowledge base. </p>', 'QuickResponseData$shortcutKey' => '<p>The shortcut key of the quick response. The value should be unique across the knowledge base.</p>', 'QuickResponseSearchResultData$shortcutKey' => '<p>The shortcut key of the quick response. The value should be unique across the knowledge base.</p>', 'UpdateQuickResponseRequest$shortcutKey' => '<p>The shortcut key of the quick response. The value should be unique across the knowledge base.</p>', ], ], 'SourceConfiguration' => [ 'base' => '<p>Configuration information about the external data source.</p>', 'refs' => [ 'CreateKnowledgeBaseRequest$sourceConfiguration' => '<p>The source of the knowledge base content. Only set this argument for EXTERNAL knowledge bases.</p>', 'KnowledgeBaseData$sourceConfiguration' => '<p>Source configuration information about the knowledge base.</p>', 'KnowledgeBaseSummary$sourceConfiguration' => '<p>Configuration information about the external data source.</p>', ], ], 'StartContentUploadRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartContentUploadResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartImportJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartImportJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'ConflictException$message' => NULL, 'NotifyRecommendationsReceivedError$recommendationId' => '<p>The identifier of the recommendation that is in error.</p>', 'PreconditionFailedException$message' => NULL, 'RecommendationData$recommendationId' => '<p>The identifier of the recommendation.</p>', 'RecommendationIdList$member' => NULL, 'RequestTimeoutException$message' => NULL, 'ResourceNotFoundException$message' => NULL, 'ResourceNotFoundException$resourceName' => '<p>The specified resource name.</p>', 'ServiceQuotaExceededException$message' => NULL, 'TooManyTagsException$message' => NULL, 'TooManyTagsException$resourceName' => '<p>The specified resource name.</p>', 'ValidationException$message' => NULL, ], ], 'SyntheticTimestamp_epoch_seconds' => [ 'base' => NULL, 'refs' => [ 'ContentData$urlExpiry' => '<p>The expiration time of the URL as an epoch timestamp.</p>', 'ImportJobData$createdTime' => '<p>The timestamp when the import job was created.</p>', 'ImportJobData$lastModifiedTime' => '<p>The timestamp when the import job data was last modified.</p>', 'ImportJobData$urlExpiry' => '<p>The expiration time of the URL as an epoch timestamp.</p>', 'ImportJobSummary$createdTime' => '<p>The timestamp when the import job was created.</p>', 'ImportJobSummary$lastModifiedTime' => '<p>The timestamp when the import job was last modified.</p>', 'KnowledgeBaseData$lastContentModificationTime' => '<p>An epoch timestamp indicating the most recent content modification inside the knowledge base. If no content exists in a knowledge base, this value is unset.</p>', 'QuickResponseData$createdTime' => '<p>The timestamp when the quick response was created.</p>', 'QuickResponseData$lastModifiedTime' => '<p>The timestamp when the quick response data was last modified.</p>', 'QuickResponseSearchResultData$createdTime' => '<p>The timestamp when the quick response was created.</p>', 'QuickResponseSearchResultData$lastModifiedTime' => '<p>The timestamp when the quick response search result data was last modified.</p>', 'QuickResponseSummary$createdTime' => '<p>The timestamp when the quick response was created.</p>', 'QuickResponseSummary$lastModifiedTime' => '<p>The timestamp when the quick response summary was last modified.</p>', 'StartContentUploadResponse$urlExpiry' => '<p>The expiration time of the URL as an epoch timestamp.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'Tags$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>The tag keys.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tags$value' => NULL, ], ], 'Tags' => [ 'base' => NULL, 'refs' => [ 'AssistantAssociationData$tags' => '<p>The tags used to organize, track, or control access for this resource.</p>', 'AssistantAssociationSummary$tags' => '<p>The tags used to organize, track, or control access for this resource.</p>', 'AssistantData$tags' => '<p>The tags used to organize, track, or control access for this resource.</p>', 'AssistantSummary$tags' => '<p>The tags used to organize, track, or control access for this resource.</p>', 'ContentData$tags' => '<p>The tags used to organize, track, or control access for this resource.</p>', 'ContentSummary$tags' => '<p>The tags used to organize, track, or control access for this resource.</p>', 'CreateAssistantAssociationRequest$tags' => '<p>The tags used to organize, track, or control access for this resource.</p>', 'CreateAssistantRequest$tags' => '<p>The tags used to organize, track, or control access for this resource.</p>', 'CreateContentRequest$tags' => '<p>The tags used to organize, track, or control access for this resource.</p>', 'CreateKnowledgeBaseRequest$tags' => '<p>The tags used to organize, track, or control access for this resource.</p>', 'CreateQuickResponseRequest$tags' => '<p>The tags used to organize, track, or control access for this resource.</p>', 'CreateSessionRequest$tags' => '<p>The tags used to organize, track, or control access for this resource.</p>', 'KnowledgeBaseData$tags' => '<p>The tags used to organize, track, or control access for this resource.</p>', 'KnowledgeBaseSummary$tags' => '<p>The tags used to organize, track, or control access for this resource.</p>', 'ListTagsForResourceResponse$tags' => '<p>The tags used to organize, track, or control access for this resource.</p>', 'QuickResponseData$tags' => '<p>The tags used to organize, track, or control access for this resource.</p>', 'QuickResponseSearchResultData$tags' => '<p>The tags used to organize, track, or control access for this resource.</p>', 'QuickResponseSummary$tags' => '<p>The tags used to organize, track, or control access for this resource.</p>', 'SessionData$tags' => '<p>The tags used to organize, track, or control access for this resource.</p>', 'TagResourceRequest$tags' => '<p>The tags used to organize, track, or control access for this resource.</p>', ], ], 'TimeToLive' => [ 'base' => '<p>Expiration time in minutes</p>', 'refs' => [ 'StartContentUploadRequest$presignedUrlTimeToLive' => '<p>The expected expiration time of the generated presigned URL, specified in minutes.</p>', ], ], 'TooManyTagsException' => [ 'base' => '<p>Amazon Connect Wisdom throws this exception if you have too many tags in your tag set.</p>', 'refs' => [], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateContentRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateContentResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateKnowledgeBaseTemplateUriRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateKnowledgeBaseTemplateUriResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateQuickResponseRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateQuickResponseResponse' => [ 'base' => NULL, 'refs' => [], ], 'UploadId' => [ 'base' => NULL, 'refs' => [ 'CreateContentRequest$uploadId' => '<p>A pointer to the uploaded asset. This value is returned by <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_StartContentUpload.html">StartContentUpload</a>.</p>', 'ImportJobData$uploadId' => '<p>A pointer to the uploaded asset. This value is returned by <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_StartContentUpload.html">StartContentUpload</a>.</p>', 'ImportJobSummary$uploadId' => '<p>A pointer to the uploaded asset. This value is returned by <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_StartContentUpload.html">StartContentUpload</a>.</p>', 'StartContentUploadResponse$uploadId' => '<p>The identifier of the upload.</p>', 'StartImportJobRequest$uploadId' => '<p>A pointer to the uploaded asset. This value is returned by <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_StartContentUpload.html">StartContentUpload</a>.</p>', 'UpdateContentRequest$uploadId' => '<p>A pointer to the uploaded asset. This value is returned by <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_StartContentUpload.html">StartContentUpload</a>. </p>', ], ], 'Uri' => [ 'base' => NULL, 'refs' => [ 'ContentData$linkOutUri' => '<p>The URI of the content.</p>', 'CreateContentRequest$overrideLinkOutUri' => '<p>The URI you want to use for the article. If the knowledge base has a templateUri, setting this argument overrides it for this piece of content.</p>', 'RenderingConfiguration$templateUri' => '<p>A URI template containing exactly one variable in <code>${variableName} </code>format. This can only be set for <code>EXTERNAL</code> knowledge bases. For Salesforce, ServiceNow, and Zendesk, the variable must be one of the following:</p> <ul> <li> <p>Salesforce: <code>Id</code>, <code>ArticleNumber</code>, <code>VersionNumber</code>, <code>Title</code>, <code>PublishStatus</code>, or <code>IsDeleted</code> </p> </li> <li> <p>ServiceNow: <code>number</code>, <code>short_description</code>, <code>sys_mod_count</code>, <code>workflow_state</code>, or <code>active</code> </p> </li> <li> <p>Zendesk: <code>id</code>, <code>title</code>, <code>updated_at</code>, or <code>draft</code> </p> </li> </ul> <p>The variable is replaced with the actual value for a piece of content when calling <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_GetContent.html">GetContent</a>. </p>', 'UpdateContentRequest$overrideLinkOutUri' => '<p>The URI for the article. If the knowledge base has a templateUri, setting this argument overrides it for this piece of content. To remove an existing <code>overrideLinkOurUri</code>, exclude this argument and set <code>removeOverrideLinkOutUri</code> to true.</p>', 'UpdateKnowledgeBaseTemplateUriRequest$templateUri' => '<p>The template URI to update.</p>', ], ], 'Url' => [ 'base' => NULL, 'refs' => [ 'ContentData$url' => '<p>The URL of the content.</p>', 'ImportJobData$failedRecordReport' => '<p>The link to donwload the information of resource data that failed to be imported.</p>', 'ImportJobData$url' => '<p>The download link to the resource file that is uploaded to the import job.</p>', 'StartContentUploadResponse$url' => '<p>The URL of the upload.</p>', ], ], 'Uuid' => [ 'base' => NULL, 'refs' => [ 'AssistantAssociationData$assistantAssociationId' => '<p>The identifier of the assistant association.</p>', 'AssistantAssociationData$assistantId' => '<p>The identifier of the Wisdom assistant.</p>', 'AssistantAssociationInputData$knowledgeBaseId' => '<p>The identifier of the knowledge base. This should not be a QUICK_RESPONSES type knowledge base if you\'re storing Wisdom Content resource to it.</p>', 'AssistantAssociationSummary$assistantAssociationId' => '<p>The identifier of the assistant association.</p>', 'AssistantAssociationSummary$assistantId' => '<p>The identifier of the Wisdom assistant.</p>', 'AssistantData$assistantId' => '<p>The identifier of the Wisdom assistant.</p>', 'AssistantSummary$assistantId' => '<p>The identifier of the Wisdom assistant.</p>', 'ContentData$contentId' => '<p>The identifier of the content.</p>', 'ContentData$knowledgeBaseId' => '<p>The identifier of the knowledge base. This should not be a QUICK_RESPONSES type knowledge base if you\'re storing Wisdom Content resource to it.</p>', 'ContentReference$contentId' => '<p>The identifier of the content.</p>', 'ContentReference$knowledgeBaseId' => '<p>The identifier of the knowledge base. This should not be a QUICK_RESPONSES type knowledge base if you\'re storing Wisdom Content resource to it.</p>', 'ContentSummary$contentId' => '<p>The identifier of the content.</p>', 'ContentSummary$knowledgeBaseId' => '<p>The identifier of the knowledge base. This should not be a QUICK_RESPONSES type knowledge base if you\'re storing Wisdom Content resource to it.</p>', 'DeleteImportJobRequest$importJobId' => '<p>The identifier of the import job to be deleted.</p>', 'GetImportJobRequest$importJobId' => '<p>The identifier of the import job to retrieve.</p>', 'ImportJobData$importJobId' => '<p>The identifier of the import job.</p>', 'ImportJobData$knowledgeBaseId' => '<p>The identifier of the knowledge base. This should not be a QUICK_RESPONSES type knowledge base if you\'re storing Wisdom Content resource to it.</p>', 'ImportJobSummary$importJobId' => '<p>The identifier of the import job.</p>', 'ImportJobSummary$knowledgeBaseId' => '<p>The identifier of the knowledge base. This should not be a QUICK_RESPONSES type knowledge base if you\'re storing Wisdom Content resource to it.</p>', 'KnowledgeBaseAssociationData$knowledgeBaseId' => '<p>The identifier of the knowledge base. This should not be a QUICK_RESPONSES type knowledge base if you\'re storing Wisdom Content resource to it.</p>', 'KnowledgeBaseData$knowledgeBaseId' => '<p>The identifier of the knowledge base. This should not be a QUICK_RESPONSES type knowledge base if you\'re storing Wisdom Content resource to it.</p>', 'KnowledgeBaseSummary$knowledgeBaseId' => '<p>The identifier of the knowledge base. This should not be a QUICK_RESPONSES type knowledge base if you\'re storing Wisdom Content resource to it.</p>', 'QuickResponseData$knowledgeBaseId' => '<p>The identifier of the knowledge base. This should not be a QUICK_RESPONSES type knowledge base if you\'re storing Wisdom Content resource to it. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>', 'QuickResponseData$quickResponseId' => '<p>The identifier of the quick response.</p>', 'QuickResponseSearchResultData$knowledgeBaseId' => '<p>The identifier of the knowledge base. This should not be a QUICK_RESPONSES type knowledge base if you\'re storing Wisdom Content resource to it. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>', 'QuickResponseSearchResultData$quickResponseId' => '<p>The identifier of the quick response.</p>', 'QuickResponseSummary$knowledgeBaseId' => '<p>The identifier of the knowledge base. This should not be a QUICK_RESPONSES type knowledge base if you\'re storing Wisdom Content resource to it.</p>', 'QuickResponseSummary$quickResponseId' => '<p>The identifier of the quick response.</p>', 'RecommendationTrigger$id' => '<p>The identifier of the recommendation trigger.</p>', 'ResultData$resultId' => '<p>The identifier of the result data.</p>', 'SessionData$sessionId' => '<p>The identifier of the session.</p>', 'SessionSummary$assistantId' => '<p>The identifier of the Wisdom assistant.</p>', 'SessionSummary$sessionId' => '<p>The identifier of the session.</p>', ], ], 'UuidOrArn' => [ 'base' => NULL, 'refs' => [ 'CreateAssistantAssociationRequest$assistantId' => '<p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>', 'CreateContentRequest$knowledgeBaseId' => '<p>The identifier of the knowledge base. This should not be a QUICK_RESPONSES type knowledge base if you\'re storing Wisdom Content resource to it. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>', 'CreateQuickResponseRequest$knowledgeBaseId' => '<p>The identifier of the knowledge base. This should not be a QUICK_RESPONSES type knowledge base if you\'re storing Wisdom Content resource to it. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>', 'CreateSessionRequest$assistantId' => '<p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>', 'DeleteAssistantAssociationRequest$assistantAssociationId' => '<p>The identifier of the assistant association. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>', 'DeleteAssistantAssociationRequest$assistantId' => '<p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>', 'DeleteAssistantRequest$assistantId' => '<p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>', 'DeleteContentRequest$contentId' => '<p>The identifier of the content. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>', 'DeleteContentRequest$knowledgeBaseId' => '<p>The identifier of the knowledge base. This should not be a QUICK_RESPONSES type knowledge base if you\'re storing Wisdom Content resource to it. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>', 'DeleteImportJobRequest$knowledgeBaseId' => '<p>The identifier of the knowledge base. This should not be a QUICK_RESPONSES type knowledge base if you\'re storing Wisdom Content resource to it.</p>', 'DeleteKnowledgeBaseRequest$knowledgeBaseId' => '<p>The knowledge base to delete content from. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>', 'DeleteQuickResponseRequest$knowledgeBaseId' => '<p>The knowledge base from which the quick response is deleted. The identifier of the knowledge base. This should not be a QUICK_RESPONSES type knowledge base if you\'re storing Wisdom Content resource to it.</p>', 'DeleteQuickResponseRequest$quickResponseId' => '<p>The identifier of the quick response to delete.</p>', 'GetAssistantAssociationRequest$assistantAssociationId' => '<p>The identifier of the assistant association. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>', 'GetAssistantAssociationRequest$assistantId' => '<p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>', 'GetAssistantRequest$assistantId' => '<p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>', 'GetContentRequest$contentId' => '<p>The identifier of the content. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>', 'GetContentRequest$knowledgeBaseId' => '<p>The identifier of the knowledge base. This should not be a QUICK_RESPONSES type knowledge base if you\'re storing Wisdom Content resource to it. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>', 'GetContentSummaryRequest$contentId' => '<p>The identifier of the content. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>', 'GetContentSummaryRequest$knowledgeBaseId' => '<p>The identifier of the knowledge base. This should not be a QUICK_RESPONSES type knowledge base if you\'re storing Wisdom Content resource to it. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>', 'GetImportJobRequest$knowledgeBaseId' => '<p>The identifier of the knowledge base that the import job belongs to.</p>', 'GetKnowledgeBaseRequest$knowledgeBaseId' => '<p>The identifier of the knowledge base. This should not be a QUICK_RESPONSES type knowledge base if you\'re storing Wisdom Content resource to it. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>', 'GetQuickResponseRequest$knowledgeBaseId' => '<p>The identifier of the knowledge base. This should be a QUICK_RESPONSES type knowledge base.</p>', 'GetQuickResponseRequest$quickResponseId' => '<p>The identifier of the quick response.</p>', 'GetRecommendationsRequest$assistantId' => '<p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>', 'GetRecommendationsRequest$sessionId' => '<p>The identifier of the session. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>', 'GetSessionRequest$assistantId' => '<p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>', 'GetSessionRequest$sessionId' => '<p>The identifier of the session. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>', 'ListAssistantAssociationsRequest$assistantId' => '<p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>', 'ListContentsRequest$knowledgeBaseId' => '<p>The identifier of the knowledge base. This should not be a QUICK_RESPONSES type knowledge base if you\'re storing Wisdom Content resource to it. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>', 'ListImportJobsRequest$knowledgeBaseId' => '<p>The identifier of the knowledge base. This should not be a QUICK_RESPONSES type knowledge base if you\'re storing Wisdom Content resource to it. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>', 'ListQuickResponsesRequest$knowledgeBaseId' => '<p>The identifier of the knowledge base. This should not be a QUICK_RESPONSES type knowledge base if you\'re storing Wisdom Content resource to it. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>', 'NotifyRecommendationsReceivedRequest$assistantId' => '<p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>', 'NotifyRecommendationsReceivedRequest$sessionId' => '<p>The identifier of the session. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>', 'QueryAssistantRequest$assistantId' => '<p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>', 'RemoveKnowledgeBaseTemplateUriRequest$knowledgeBaseId' => '<p>The identifier of the knowledge base. This should not be a QUICK_RESPONSES type knowledge base if you\'re storing Wisdom Content resource to it. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>', 'SearchContentRequest$knowledgeBaseId' => '<p>The identifier of the knowledge base. This should not be a QUICK_RESPONSES type knowledge base if you\'re storing Wisdom Content resource to it. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>', 'SearchQuickResponsesRequest$knowledgeBaseId' => '<p>The identifier of the knowledge base. This should be a QUICK_RESPONSES type knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>', 'SearchSessionsRequest$assistantId' => '<p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>', 'StartContentUploadRequest$knowledgeBaseId' => '<p>The identifier of the knowledge base. This should not be a QUICK_RESPONSES type knowledge base if you\'re storing Wisdom Content resource to it. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>', 'StartImportJobRequest$knowledgeBaseId' => '<p>The identifier of the knowledge base. This should not be a QUICK_RESPONSES type knowledge base if you\'re storing Wisdom Content resource to it. Can be either the ID or the ARN. URLs cannot contain the ARN.</p> <ul> <li> <p>For importing Wisdom quick responses, this should be a <code>QUICK_RESPONSES</code> type knowledge base.</p> </li> </ul>', 'UpdateContentRequest$contentId' => '<p>The identifier of the content. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>', 'UpdateContentRequest$knowledgeBaseId' => '<p>The identifier of the knowledge base. This should not be a QUICK_RESPONSES type knowledge base if you\'re storing Wisdom Content resource to it. Can be either the ID or the ARN</p>', 'UpdateKnowledgeBaseTemplateUriRequest$knowledgeBaseId' => '<p>The identifier of the knowledge base. This should not be a QUICK_RESPONSES type knowledge base if you\'re storing Wisdom Content resource to it. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>', 'UpdateQuickResponseRequest$knowledgeBaseId' => '<p>The identifier of the knowledge base. This should not be a QUICK_RESPONSES type knowledge base if you\'re storing Wisdom Content resource to it. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>', 'UpdateQuickResponseRequest$quickResponseId' => '<p>The identifier of the quick response.</p>', ], ], 'ValidationException' => [ 'base' => '<p>The input fails to satisfy the constraints specified by a service.</p>', 'refs' => [], ], 'WaitTimeSeconds' => [ 'base' => NULL, 'refs' => [ 'GetRecommendationsRequest$waitTimeSeconds' => '<p>The duration (in seconds) for which the call waits for a recommendation to be made available before returning. If a recommendation is available, the call returns sooner than <code>WaitTimeSeconds</code>. If no messages are available and the wait time expires, the call returns successfully with an empty list.</p>', ], ], ],];
