<?php
// This file was auto-generated from sdk-root/src/data/workmail/2017-10-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>WorkMail is a secure, managed business email and calendaring service with support for existing desktop and mobile email clients. You can access your email, contacts, and calendars using Microsoft Outlook, your browser, or other native iOS and Android email applications. You can integrate WorkMail with your existing corporate directory and control both the keys that encrypt your data and the location in which your data is stored.</p> <p>The WorkMail API is designed for the following scenarios:</p> <ul> <li> <p>Listing and describing organizations</p> </li> </ul> <ul> <li> <p>Managing users</p> </li> </ul> <ul> <li> <p>Managing groups</p> </li> </ul> <ul> <li> <p>Managing resources</p> </li> </ul> <p>All WorkMail API operations are Amazon-authenticated and certificate-signed. They not only require the use of the AWS SDK, but also allow for the exclusive use of AWS Identity and Access Management users and roles to help facilitate access, trust, and permission policies. By creating a role and allowing an IAM user to access the WorkMail site, the IAM user gains full administrative visibility into the entire WorkMail organization (or as set in the IAM policy). This includes, but is not limited to, the ability to create, update, and delete users, groups, and resources. This allows developers to perform the scenarios listed above, as well as give users the ability to grant access on a selective basis using the IAM model.</p>', 'operations' => [ 'AssociateDelegateToResource' => '<p>Adds a member (user or group) to the resource\'s set of delegates.</p>', 'AssociateMemberToGroup' => '<p>Adds a member (user or group) to the group\'s set.</p>', 'AssumeImpersonationRole' => '<p>Assumes an impersonation role for the given WorkMail organization. This method returns an authentication token you can use to make impersonated calls.</p>', 'CancelMailboxExportJob' => '<p>Cancels a mailbox export job.</p> <note> <p>If the mailbox export job is near completion, it might not be possible to cancel it.</p> </note>', 'CreateAlias' => '<p>Adds an alias to the set of a given member (user or group) of WorkMail.</p>', 'CreateAvailabilityConfiguration' => '<p>Creates an <code>AvailabilityConfiguration</code> for the given WorkMail organization and domain.</p>', 'CreateGroup' => '<p>Creates a group that can be used in WorkMail by calling the <a>RegisterToWorkMail</a> operation.</p>', 'CreateImpersonationRole' => '<p>Creates an impersonation role for the given WorkMail organization.</p> <p> <i>Idempotency</i> ensures that an API request completes no more than one time. With an idempotent request, if the original request completes successfully, any subsequent retries also complete successfully without performing any further actions.</p>', 'CreateMobileDeviceAccessRule' => '<p>Creates a new mobile device access rule for the specified WorkMail organization.</p>', 'CreateOrganization' => '<p>Creates a new WorkMail organization. Optionally, you can choose to associate an existing AWS Directory Service directory with your organization. If an AWS Directory Service directory ID is specified, the organization alias must match the directory alias. If you choose not to associate an existing directory with your organization, then we create a new WorkMail directory for you. For more information, see <a href="https://docs.aws.amazon.com/workmail/latest/adminguide/add_new_organization.html">Adding an organization</a> in the <i>WorkMail Administrator Guide</i>.</p> <p>You can associate multiple email domains with an organization, then choose your default email domain from the WorkMail console. You can also associate a domain that is managed in an Amazon Route 53 public hosted zone. For more information, see <a href="https://docs.aws.amazon.com/workmail/latest/adminguide/add_domain.html">Adding a domain</a> and <a href="https://docs.aws.amazon.com/workmail/latest/adminguide/default_domain.html">Choosing the default domain</a> in the <i>WorkMail Administrator Guide</i>.</p> <p>Optionally, you can use a customer managed key from AWS Key Management Service (AWS KMS) to encrypt email for your organization. If you don\'t associate an AWS KMS key, WorkMail creates a default, AWS managed key for you.</p>', 'CreateResource' => '<p>Creates a new WorkMail resource.</p>', 'CreateUser' => '<p>Creates a user who can be used in WorkMail by calling the <a>RegisterToWorkMail</a> operation.</p>', 'DeleteAccessControlRule' => '<p>Deletes an access control rule for the specified WorkMail organization.</p> <note> <p>Deleting already deleted and non-existing rules does not produce an error. In those cases, the service sends back an HTTP 200 response with an empty HTTP body.</p> </note>', 'DeleteAlias' => '<p>Remove one or more specified aliases from a set of aliases for a given user.</p>', 'DeleteAvailabilityConfiguration' => '<p>Deletes the <code>AvailabilityConfiguration</code> for the given WorkMail organization and domain.</p>', 'DeleteEmailMonitoringConfiguration' => '<p>Deletes the email monitoring configuration for a specified organization.</p>', 'DeleteGroup' => '<p>Deletes a group from WorkMail.</p>', 'DeleteImpersonationRole' => '<p>Deletes an impersonation role for the given WorkMail organization.</p>', 'DeleteMailboxPermissions' => '<p>Deletes permissions granted to a member (user or group).</p>', 'DeleteMobileDeviceAccessOverride' => '<p>Deletes the mobile device access override for the given WorkMail organization, user, and device.</p> <note> <p>Deleting already deleted and non-existing overrides does not produce an error. In those cases, the service sends back an HTTP 200 response with an empty HTTP body.</p> </note>', 'DeleteMobileDeviceAccessRule' => '<p>Deletes a mobile device access rule for the specified WorkMail organization.</p> <note> <p>Deleting already deleted and non-existing rules does not produce an error. In those cases, the service sends back an HTTP 200 response with an empty HTTP body.</p> </note>', 'DeleteOrganization' => '<p>Deletes an WorkMail organization and all underlying AWS resources managed by WorkMail as part of the organization. You can choose whether to delete the associated directory. For more information, see <a href="https://docs.aws.amazon.com/workmail/latest/adminguide/remove_organization.html">Removing an organization</a> in the <i>WorkMail Administrator Guide</i>.</p>', 'DeleteResource' => '<p>Deletes the specified resource.</p>', 'DeleteRetentionPolicy' => '<p>Deletes the specified retention policy from the specified organization.</p>', 'DeleteUser' => '<p>Deletes a user from WorkMail and all subsequent systems. Before you can delete a user, the user state must be <code>DISABLED</code>. Use the <a>DescribeUser</a> action to confirm the user state.</p> <p>Deleting a user is permanent and cannot be undone. WorkMail archives user mailboxes for 30 days before they are permanently removed.</p>', 'DeregisterFromWorkMail' => '<p>Mark a user, group, or resource as no longer used in WorkMail. This action disassociates the mailbox and schedules it for clean-up. WorkMail keeps mailboxes for 30 days before they are permanently removed. The functionality in the console is <i>Disable</i>.</p>', 'DeregisterMailDomain' => '<p>Removes a domain from WorkMail, stops email routing to WorkMail, and removes the authorization allowing WorkMail use. SES keeps the domain because other applications may use it. You must first remove any email address used by WorkMail entities before you remove the domain.</p>', 'DescribeEmailMonitoringConfiguration' => '<p>Describes the current email monitoring configuration for a specified organization.</p>', 'DescribeEntity' => '<p>Returns basic details about an entity in WorkMail. </p>', 'DescribeGroup' => '<p>Returns the data available for the group.</p>', 'DescribeInboundDmarcSettings' => '<p>Lists the settings in a DMARC policy for a specified organization.</p>', 'DescribeMailboxExportJob' => '<p>Describes the current status of a mailbox export job.</p>', 'DescribeOrganization' => '<p>Provides more information regarding a given organization based on its identifier.</p>', 'DescribeResource' => '<p>Returns the data available for the resource.</p>', 'DescribeUser' => '<p>Provides information regarding the user.</p>', 'DisassociateDelegateFromResource' => '<p>Removes a member from the resource\'s set of delegates.</p>', 'DisassociateMemberFromGroup' => '<p>Removes a member from a group.</p>', 'GetAccessControlEffect' => '<p>Gets the effects of an organization\'s access control rules as they apply to a specified IPv4 address, access protocol action, and user ID or impersonation role ID. You must provide either the user ID or impersonation role ID. Impersonation role ID can only be used with Action EWS.</p>', 'GetDefaultRetentionPolicy' => '<p>Gets the default retention policy details for the specified organization.</p>', 'GetImpersonationRole' => '<p>Gets the impersonation role details for the given WorkMail organization.</p>', 'GetImpersonationRoleEffect' => '<p>Tests whether the given impersonation role can impersonate a target user.</p>', 'GetMailDomain' => '<p>Gets details for a mail domain, including domain records required to configure your domain with recommended security.</p>', 'GetMailboxDetails' => '<p>Requests a user\'s mailbox details for a specified organization and user.</p>', 'GetMobileDeviceAccessEffect' => '<p>Simulates the effect of the mobile device access rules for the given attributes of a sample access event. Use this method to test the effects of the current set of mobile device access rules for the WorkMail organization for a particular user\'s attributes.</p>', 'GetMobileDeviceAccessOverride' => '<p>Gets the mobile device access override for the given WorkMail organization, user, and device.</p>', 'ListAccessControlRules' => '<p>Lists the access control rules for the specified organization.</p>', 'ListAliases' => '<p>Creates a paginated call to list the aliases associated with a given entity.</p>', 'ListAvailabilityConfigurations' => '<p>List all the <code>AvailabilityConfiguration</code>\'s for the given WorkMail organization.</p>', 'ListGroupMembers' => '<p>Returns an overview of the members of a group. Users and groups can be members of a group.</p>', 'ListGroups' => '<p>Returns summaries of the organization\'s groups.</p>', 'ListGroupsForEntity' => '<p>Returns all the groups to which an entity belongs.</p>', 'ListImpersonationRoles' => '<p>Lists all the impersonation roles for the given WorkMail organization.</p>', 'ListMailDomains' => '<p>Lists the mail domains in a given WorkMail organization.</p>', 'ListMailboxExportJobs' => '<p>Lists the mailbox export jobs started for the specified organization within the last seven days.</p>', 'ListMailboxPermissions' => '<p>Lists the mailbox permissions associated with a user, group, or resource mailbox.</p>', 'ListMobileDeviceAccessOverrides' => '<p>Lists all the mobile device access overrides for any given combination of WorkMail organization, user, or device.</p>', 'ListMobileDeviceAccessRules' => '<p>Lists the mobile device access rules for the specified WorkMail organization.</p>', 'ListOrganizations' => '<p>Returns summaries of the customer\'s organizations.</p>', 'ListResourceDelegates' => '<p>Lists the delegates associated with a resource. Users and groups can be resource delegates and answer requests on behalf of the resource.</p>', 'ListResources' => '<p>Returns summaries of the organization\'s resources.</p>', 'ListTagsForResource' => '<p>Lists the tags applied to an WorkMail organization resource.</p>', 'ListUsers' => '<p>Returns summaries of the organization\'s users.</p>', 'PutAccessControlRule' => '<p>Adds a new access control rule for the specified organization. The rule allows or denies access to the organization for the specified IPv4 addresses, access protocol actions, user IDs and impersonation IDs. Adding a new rule with the same name as an existing rule replaces the older rule.</p>', 'PutEmailMonitoringConfiguration' => '<p>Creates or updates the email monitoring configuration for a specified organization.</p>', 'PutInboundDmarcSettings' => '<p>Enables or disables a DMARC policy for a given organization.</p>', 'PutMailboxPermissions' => '<p>Sets permissions for a user, group, or resource. This replaces any pre-existing permissions.</p>', 'PutMobileDeviceAccessOverride' => '<p>Creates or updates a mobile device access override for the given WorkMail organization, user, and device.</p>', 'PutRetentionPolicy' => '<p>Puts a retention policy to the specified organization.</p>', 'RegisterMailDomain' => '<p>Registers a new domain in WorkMail and SES, and configures it for use by WorkMail. Emails received by SES for this domain are routed to the specified WorkMail organization, and WorkMail has permanent permission to use the specified domain for sending your users\' emails.</p>', 'RegisterToWorkMail' => '<p>Registers an existing and disabled user, group, or resource for WorkMail use by associating a mailbox and calendaring capabilities. It performs no change if the user, group, or resource is enabled and fails if the user, group, or resource is deleted. This operation results in the accumulation of costs. For more information, see <a href="https://aws.amazon.com/workmail/pricing">Pricing</a>. The equivalent console functionality for this operation is <i>Enable</i>.</p> <p>Users can either be created by calling the <a>CreateUser</a> API operation or they can be synchronized from your directory. For more information, see <a>DeregisterFromWorkMail</a>.</p>', 'ResetPassword' => '<p>Allows the administrator to reset the password for a user.</p>', 'StartMailboxExportJob' => '<p>Starts a mailbox export job to export MIME-format email messages and calendar items from the specified mailbox to the specified Amazon Simple Storage Service (Amazon S3) bucket. For more information, see <a href="https://docs.aws.amazon.com/workmail/latest/adminguide/mail-export.html">Exporting mailbox content</a> in the <i>WorkMail Administrator Guide</i>.</p>', 'TagResource' => '<p>Applies the specified tags to the specified WorkMailorganization resource.</p>', 'TestAvailabilityConfiguration' => '<p>Performs a test on an availability provider to ensure that access is allowed. For EWS, it verifies the provided credentials can be used to successfully log in. For Lambda, it verifies that the Lambda function can be invoked and that the resource access policy was configured to deny anonymous access. An anonymous invocation is one done without providing either a <code>SourceArn</code> or <code>SourceAccount</code> header.</p> <note> <p>The request must contain either one provider definition (<code>EwsProvider</code> or <code>LambdaProvider</code>) or the <code>DomainName</code> parameter. If the <code>DomainName</code> parameter is provided, the configuration stored under the <code>DomainName</code> will be tested.</p> </note>', 'UntagResource' => '<p>Untags the specified tags from the specified WorkMail organization resource.</p>', 'UpdateAvailabilityConfiguration' => '<p>Updates an existing <code>AvailabilityConfiguration</code> for the given WorkMail organization and domain.</p>', 'UpdateDefaultMailDomain' => '<p>Updates the default mail domain for an organization. The default mail domain is used by the WorkMail AWS Console to suggest an email address when enabling a mail user. You can only have one default domain.</p>', 'UpdateGroup' => '<p>Updates attibutes in a group.</p>', 'UpdateImpersonationRole' => '<p>Updates an impersonation role for the given WorkMail organization.</p>', 'UpdateMailboxQuota' => '<p>Updates a user\'s current mailbox quota for a specified organization and user.</p>', 'UpdateMobileDeviceAccessRule' => '<p>Updates a mobile device access rule for the specified WorkMail organization.</p>', 'UpdatePrimaryEmailAddress' => '<p>Updates the primary email for a user, group, or resource. The current email is moved into the list of aliases (or swapped between an existing alias and the current primary email), and the email provided in the input is promoted as the primary.</p>', 'UpdateResource' => '<p>Updates data for the resource. To have the latest information, it must be preceded by a <a>DescribeResource</a> call. The dataset in the request should be the one expected when performing another <code>DescribeResource</code> call.</p>', 'UpdateUser' => '<p>Updates data for the user. To have the latest information, it must be preceded by a <a>DescribeUser</a> call. The dataset in the request should be the one expected when performing another <code>DescribeUser</code> call.</p>', ], 'shapes' => [ 'AccessControlRule' => [ 'base' => '<p>A rule that controls access to an WorkMail organization.</p>', 'refs' => [ 'AccessControlRulesList$member' => NULL, ], ], 'AccessControlRuleAction' => [ 'base' => NULL, 'refs' => [ 'ActionsList$member' => NULL, 'GetAccessControlEffectRequest$Action' => '<p>The access protocol action. Valid values include <code>ActiveSync</code>, <code>AutoDiscover</code>, <code>EWS</code>, <code>IMAP</code>, <code>SMTP</code>, <code>WindowsOutlook</code>, and <code>WebMail</code>.</p>', ], ], 'AccessControlRuleDescription' => [ 'base' => NULL, 'refs' => [ 'AccessControlRule$Description' => '<p>The rule description.</p>', 'PutAccessControlRuleRequest$Description' => '<p>The rule description.</p>', ], ], 'AccessControlRuleEffect' => [ 'base' => NULL, 'refs' => [ 'AccessControlRule$Effect' => '<p>The rule effect.</p>', 'GetAccessControlEffectResponse$Effect' => '<p>The rule effect.</p>', 'PutAccessControlRuleRequest$Effect' => '<p>The rule effect.</p>', ], ], 'AccessControlRuleName' => [ 'base' => NULL, 'refs' => [ 'AccessControlRule$Name' => '<p>The rule name.</p>', 'AccessControlRuleNameList$member' => NULL, 'DeleteAccessControlRuleRequest$Name' => '<p>The name of the access control rule.</p>', 'PutAccessControlRuleRequest$Name' => '<p>The rule name.</p>', ], ], 'AccessControlRuleNameList' => [ 'base' => NULL, 'refs' => [ 'GetAccessControlEffectResponse$MatchedRules' => '<p>The rules that match the given parameters, resulting in an effect.</p>', ], ], 'AccessControlRulesList' => [ 'base' => NULL, 'refs' => [ 'ListAccessControlRulesResponse$Rules' => '<p>The access control rules.</p>', ], ], 'AccessEffect' => [ 'base' => NULL, 'refs' => [ 'GetImpersonationRoleEffectResponse$Effect' => '<p> <code/>Effect of the impersonation role on the target user based on its rules. Available effects are <code>ALLOW</code> or <code>DENY</code>.</p>', 'ImpersonationRule$Effect' => '<p>The effect of the rule when it matches the input. Allowed effect values are <code>ALLOW</code> or <code>DENY</code>.</p>', ], ], 'ActionsList' => [ 'base' => NULL, 'refs' => [ 'AccessControlRule$Actions' => '<p>Access protocol actions to include in the rule. Valid values include <code>ActiveSync</code>, <code>AutoDiscover</code>, <code>EWS</code>, <code>IMAP</code>, <code>SMTP</code>, <code>WindowsOutlook</code>, and <code>WebMail</code>.</p>', 'AccessControlRule$NotActions' => '<p>Access protocol actions to exclude from the rule. Valid values include <code>ActiveSync</code>, <code>AutoDiscover</code>, <code>EWS</code>, <code>IMAP</code>, <code>SMTP</code>, <code>WindowsOutlook</code>, and <code>WebMail</code>.</p>', 'PutAccessControlRuleRequest$Actions' => '<p>Access protocol actions to include in the rule. Valid values include <code>ActiveSync</code>, <code>AutoDiscover</code>, <code>EWS</code>, <code>IMAP</code>, <code>SMTP</code>, <code>WindowsOutlook</code>, and <code>WebMail</code>.</p>', 'PutAccessControlRuleRequest$NotActions' => '<p>Access protocol actions to exclude from the rule. Valid values include <code>ActiveSync</code>, <code>AutoDiscover</code>, <code>EWS</code>, <code>IMAP</code>, <code>SMTP</code>, <code>WindowsOutlook</code>, and <code>WebMail</code>.</p>', ], ], 'Aliases' => [ 'base' => NULL, 'refs' => [ 'ListAliasesResponse$Aliases' => '<p>The entity\'s paginated aliases.</p>', ], ], 'AmazonResourceName' => [ 'base' => NULL, 'refs' => [ 'DescribeOrganizationResponse$ARN' => '<p>The Amazon Resource Name (ARN) of the organization.</p>', 'ListTagsForResourceRequest$ResourceARN' => '<p>The resource ARN.</p>', 'TagResourceRequest$ResourceARN' => '<p>The resource ARN.</p>', 'UntagResourceRequest$ResourceARN' => '<p>The resource ARN.</p>', ], ], 'AssociateDelegateToResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateDelegateToResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociateMemberToGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateMemberToGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssumeImpersonationRoleRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssumeImpersonationRoleResponse' => [ 'base' => NULL, 'refs' => [], ], 'AvailabilityConfiguration' => [ 'base' => '<p>List all the <code>AvailabilityConfiguration</code>\'s for the given WorkMail organization.</p>', 'refs' => [ 'AvailabilityConfigurationList$member' => NULL, ], ], 'AvailabilityConfigurationList' => [ 'base' => NULL, 'refs' => [ 'ListAvailabilityConfigurationsResponse$AvailabilityConfigurations' => '<p>The list of <code>AvailabilityConfiguration</code>\'s that exist for the specified WorkMail organization.</p>', ], ], 'AvailabilityProviderType' => [ 'base' => NULL, 'refs' => [ 'AvailabilityConfiguration$ProviderType' => '<p>Displays the provider type that applies to this domain.</p>', ], ], 'BookingOptions' => [ 'base' => '<p>At least one delegate must be associated to the resource to disable automatic replies from the resource.</p>', 'refs' => [ 'DescribeResourceResponse$BookingOptions' => '<p>The booking options for the described resource.</p>', 'UpdateResourceRequest$BookingOptions' => '<p>The resource\'s booking options to be updated.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'BookingOptions$AutoAcceptRequests' => '<p>The resource\'s ability to automatically reply to requests. If disabled, delegates must be associated to the resource.</p>', 'BookingOptions$AutoDeclineRecurringRequests' => '<p>The resource\'s ability to automatically decline any recurring requests.</p>', 'BookingOptions$AutoDeclineConflictingRequests' => '<p>The resource\'s ability to automatically decline any conflicting requests.</p>', 'CreateGroupRequest$HiddenFromGlobalAddressList' => '<p>If this parameter is enabled, the group will be hidden from the address book.</p>', 'CreateOrganizationRequest$EnableInteroperability' => '<p>When <code>true</code>, allows organization interoperability between WorkMail and Microsoft Exchange. If <code>true</code>, you must include a AD Connector directory ID in the request.</p>', 'CreateResourceRequest$HiddenFromGlobalAddressList' => '<p>If this parameter is enabled, the resource will be hidden from the address book.</p>', 'CreateUserRequest$HiddenFromGlobalAddressList' => '<p>If this parameter is enabled, the user will be hidden from the address book.</p>', 'DeleteOrganizationRequest$DeleteDirectory' => '<p>If true, deletes the AWS Directory Service directory associated with the organization.</p>', 'DeleteOrganizationRequest$ForceDelete' => '<p>Deletes a WorkMail organization even if the organization has enabled users.</p>', 'DescribeGroupResponse$HiddenFromGlobalAddressList' => '<p>If the value is set to <i>true</i>, the group is hidden from the address book.</p>', 'DescribeInboundDmarcSettingsResponse$Enforced' => '<p>Lists the enforcement setting of the applied policy.</p>', 'DescribeOrganizationResponse$InteroperabilityEnabled' => '<p>Indicates if interoperability is enabled for this organization.</p>', 'DescribeResourceResponse$HiddenFromGlobalAddressList' => '<p>If enabled, the resource is hidden from the global address list.</p>', 'DescribeUserResponse$HiddenFromGlobalAddressList' => '<p>If enabled, the user is hidden from the global address list.</p>', 'GetMailDomainResponse$IsTestDomain' => '<p>Specifies whether the domain is a test domain provided by WorkMail, or a custom domain.</p>', 'GetMailDomainResponse$IsDefault' => '<p>Specifies whether the domain is the default domain for your organization.</p>', 'MailDomainSummary$DefaultDomain' => '<p>Whether the domain is default or not.</p>', 'TestAvailabilityConfigurationResponse$TestPassed' => '<p>Boolean indicating whether the test passed or failed.</p>', ], ], 'BooleanObject' => [ 'base' => NULL, 'refs' => [ 'PutInboundDmarcSettingsRequest$Enforced' => '<p>Enforces or suspends a policy after it\'s applied.</p>', 'UpdateGroupRequest$HiddenFromGlobalAddressList' => '<p>If enabled, the group is hidden from the global address list.</p>', 'UpdateResourceRequest$HiddenFromGlobalAddressList' => '<p>If enabled, the resource is hidden from the global address list.</p>', 'UpdateUserRequest$HiddenFromGlobalAddressList' => '<p>If enabled, the user is hidden from the global address list.</p>', ], ], 'CancelMailboxExportJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CancelMailboxExportJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAliasResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateAvailabilityConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAvailabilityConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateImpersonationRoleRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateImpersonationRoleResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateMobileDeviceAccessRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateMobileDeviceAccessRuleResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateOrganizationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateOrganizationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'Delegate' => [ 'base' => '<p>The name of the attribute, which is one of the values defined in the UserAttribute enumeration.</p>', 'refs' => [ 'ResourceDelegates$member' => NULL, ], ], 'DeleteAccessControlRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAccessControlRuleResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAliasResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAvailabilityConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAvailabilityConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEmailMonitoringConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEmailMonitoringConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteImpersonationRoleRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteImpersonationRoleResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMailboxPermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMailboxPermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMobileDeviceAccessOverrideRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMobileDeviceAccessOverrideResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMobileDeviceAccessRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMobileDeviceAccessRuleResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteOrganizationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteOrganizationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRetentionPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRetentionPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterFromWorkMailRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterFromWorkMailResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterMailDomainRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterMailDomainResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEmailMonitoringConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEmailMonitoringConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEntityRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEntityResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInboundDmarcSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInboundDmarcSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMailboxExportJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMailboxExportJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeOrganizationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeOrganizationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'DescribeMailboxExportJobResponse$Description' => '<p>The mailbox export job description.</p>', 'MailboxExportJob$Description' => '<p>The mailbox export job description.</p>', 'StartMailboxExportJobRequest$Description' => '<p>The mailbox export job description.</p>', ], ], 'DeviceId' => [ 'base' => NULL, 'refs' => [ 'DeleteMobileDeviceAccessOverrideRequest$DeviceId' => '<p>The mobile device for which you delete the override. <code>DeviceId</code> is case insensitive.</p>', 'GetMobileDeviceAccessOverrideRequest$DeviceId' => '<p>The mobile device to which the override applies. <code>DeviceId</code> is case insensitive.</p>', 'GetMobileDeviceAccessOverrideResponse$DeviceId' => '<p>The device to which the access override applies.</p>', 'ListMobileDeviceAccessOverridesRequest$DeviceId' => '<p>The mobile device to which the access override applies.</p>', 'MobileDeviceAccessOverride$DeviceId' => '<p>The device to which the override applies.</p>', 'PutMobileDeviceAccessOverrideRequest$DeviceId' => '<p>The mobile device for which you create the override. <code>DeviceId</code> is case insensitive.</p>', ], ], 'DeviceModel' => [ 'base' => NULL, 'refs' => [ 'DeviceModelList$member' => NULL, 'GetMobileDeviceAccessEffectRequest$DeviceModel' => '<p>Device model the simulated user will report.</p>', ], ], 'DeviceModelList' => [ 'base' => NULL, 'refs' => [ 'CreateMobileDeviceAccessRuleRequest$DeviceModels' => '<p>Device models that the rule will match.</p>', 'CreateMobileDeviceAccessRuleRequest$NotDeviceModels' => '<p>Device models that the rule <b>will not</b> match. All other device models will match.</p>', 'MobileDeviceAccessRule$DeviceModels' => '<p>Device models that a rule will match.</p>', 'MobileDeviceAccessRule$NotDeviceModels' => '<p>Device models that a rule <b>will not</b> match. All other device models will match.</p>', 'UpdateMobileDeviceAccessRuleRequest$DeviceModels' => '<p>Device models that the updated rule will match.</p>', 'UpdateMobileDeviceAccessRuleRequest$NotDeviceModels' => '<p>Device models that the updated rule <b>will not</b> match. All other device models will match.</p>', ], ], 'DeviceOperatingSystem' => [ 'base' => NULL, 'refs' => [ 'DeviceOperatingSystemList$member' => NULL, 'GetMobileDeviceAccessEffectRequest$DeviceOperatingSystem' => '<p>Device operating system the simulated user will report.</p>', ], ], 'DeviceOperatingSystemList' => [ 'base' => NULL, 'refs' => [ 'CreateMobileDeviceAccessRuleRequest$DeviceOperatingSystems' => '<p>Device operating systems that the rule will match.</p>', 'CreateMobileDeviceAccessRuleRequest$NotDeviceOperatingSystems' => '<p>Device operating systems that the rule <b>will not</b> match. All other device operating systems will match.</p>', 'MobileDeviceAccessRule$DeviceOperatingSystems' => '<p>Device operating systems that a rule will match.</p>', 'MobileDeviceAccessRule$NotDeviceOperatingSystems' => '<p>Device operating systems that a rule <b>will not</b> match. All other device types will match.</p>', 'UpdateMobileDeviceAccessRuleRequest$DeviceOperatingSystems' => '<p>Device operating systems that the updated rule will match.</p>', 'UpdateMobileDeviceAccessRuleRequest$NotDeviceOperatingSystems' => '<p>Device operating systems that the updated rule <b>will not</b> match. All other device operating systems will match.</p>', ], ], 'DeviceType' => [ 'base' => NULL, 'refs' => [ 'DeviceTypeList$member' => NULL, 'GetMobileDeviceAccessEffectRequest$DeviceType' => '<p>Device type the simulated user will report.</p>', ], ], 'DeviceTypeList' => [ 'base' => NULL, 'refs' => [ 'CreateMobileDeviceAccessRuleRequest$DeviceTypes' => '<p>Device types that the rule will match.</p>', 'CreateMobileDeviceAccessRuleRequest$NotDeviceTypes' => '<p>Device types that the rule <b>will not</b> match. All other device types will match.</p>', 'MobileDeviceAccessRule$DeviceTypes' => '<p>Device types that a rule will match.</p>', 'MobileDeviceAccessRule$NotDeviceTypes' => '<p>Device types that a rule <b>will not</b> match. All other device types will match.</p>', 'UpdateMobileDeviceAccessRuleRequest$DeviceTypes' => '<p>Device types that the updated rule will match.</p>', 'UpdateMobileDeviceAccessRuleRequest$NotDeviceTypes' => '<p>Device types that the updated rule <b>will not</b> match. All other device types will match.</p>', ], ], 'DeviceUserAgent' => [ 'base' => NULL, 'refs' => [ 'DeviceUserAgentList$member' => NULL, 'GetMobileDeviceAccessEffectRequest$DeviceUserAgent' => '<p>Device user agent the simulated user will report.</p>', ], ], 'DeviceUserAgentList' => [ 'base' => NULL, 'refs' => [ 'CreateMobileDeviceAccessRuleRequest$DeviceUserAgents' => '<p>Device user agents that the rule will match.</p>', 'CreateMobileDeviceAccessRuleRequest$NotDeviceUserAgents' => '<p>Device user agents that the rule <b>will not</b> match. All other device user agents will match.</p>', 'MobileDeviceAccessRule$DeviceUserAgents' => '<p>Device user agents that a rule will match.</p>', 'MobileDeviceAccessRule$NotDeviceUserAgents' => '<p>Device user agents that a rule <b>will not</b> match. All other device user agents will match.</p>', 'UpdateMobileDeviceAccessRuleRequest$DeviceUserAgents' => '<p>User agents that the updated rule will match.</p>', 'UpdateMobileDeviceAccessRuleRequest$NotDeviceUserAgents' => '<p>User agents that the updated rule <b>will not</b> match. All other user agents will match.</p>', ], ], 'DirectoryId' => [ 'base' => NULL, 'refs' => [ 'CreateOrganizationRequest$DirectoryId' => '<p>The AWS Directory Service directory ID.</p>', ], ], 'DirectoryInUseException' => [ 'base' => '<p>The directory is already in use by another WorkMail organization in the same account and Region.</p>', 'refs' => [], ], 'DirectoryServiceAuthenticationFailedException' => [ 'base' => '<p>The directory service doesn\'t recognize the credentials supplied by WorkMail.</p>', 'refs' => [], ], 'DirectoryUnavailableException' => [ 'base' => '<p>The directory is unavailable. It might be located in another Region or deleted.</p>', 'refs' => [], ], 'DisassociateDelegateFromResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateDelegateFromResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateMemberFromGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateMemberFromGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DnsRecord' => [ 'base' => '<p>A DNS record uploaded to your DNS provider.</p>', 'refs' => [ 'DnsRecords$member' => NULL, ], ], 'DnsRecordVerificationStatus' => [ 'base' => NULL, 'refs' => [ 'GetMailDomainResponse$OwnershipVerificationStatus' => '<p> Indicates the status of the domain ownership verification.</p>', 'GetMailDomainResponse$DkimVerificationStatus' => '<p>Indicates the status of a DKIM verification.</p>', ], ], 'DnsRecords' => [ 'base' => NULL, 'refs' => [ 'GetMailDomainResponse$Records' => '<p>A list of the DNS records that WorkMail recommends adding in your DNS provider for the best user experience. The records configure your domain with DMARC, SPF, DKIM, and direct incoming email traffic to SES. See admin guide for more details.</p>', ], ], 'Domain' => [ 'base' => '<p>The domain to associate with an WorkMail organization.</p> <p>When you configure a domain hosted in Amazon Route 53 (Route 53), all recommended DNS records are added to the organization when you create it. For more information, see <a href="https://docs.aws.amazon.com/workmail/latest/adminguide/add_domain.html">Adding a domain</a> in the <i>WorkMail Administrator Guide</i>.</p>', 'refs' => [ 'Domains$member' => NULL, ], ], 'DomainName' => [ 'base' => NULL, 'refs' => [ 'AvailabilityConfiguration$DomainName' => '<p>Displays the domain to which the provider applies.</p>', 'CreateAvailabilityConfigurationRequest$DomainName' => '<p>The domain to which the provider applies.</p>', 'DeleteAvailabilityConfigurationRequest$DomainName' => '<p>The domain for which the <code>AvailabilityConfiguration</code> will be deleted.</p>', 'Domain$DomainName' => '<p>The fully qualified domain name.</p>', 'MailDomainSummary$DomainName' => '<p>The domain name.</p>', 'OrganizationSummary$DefaultMailDomain' => '<p>The default email domain associated with the organization.</p>', 'TestAvailabilityConfigurationRequest$DomainName' => '<p>The domain to which the provider applies. If this field is provided, a stored availability provider associated to this domain name will be tested.</p>', 'UpdateAvailabilityConfigurationRequest$DomainName' => '<p>The domain to which the provider applies the availability configuration.</p>', ], ], 'Domains' => [ 'base' => NULL, 'refs' => [ 'CreateOrganizationRequest$Domains' => '<p>The email domains to associate with the organization.</p>', ], ], 'EmailAddress' => [ 'base' => NULL, 'refs' => [ 'Aliases$member' => NULL, 'CreateAliasRequest$Alias' => '<p>The alias to add to the member set.</p>', 'DeleteAliasRequest$Alias' => '<p>The aliases to be removed from the user\'s set of aliases. Duplicate entries in the list are collapsed into single entries (the list is transformed into a set).</p>', 'DescribeEntityRequest$Email' => '<p>The email under which the entity exists.</p>', 'DescribeGroupResponse$Email' => '<p>The email of the described group.</p>', 'DescribeResourceResponse$Email' => '<p>The email of the described resource.</p>', 'DescribeUserResponse$Email' => '<p>The email of the user.</p>', 'Group$Email' => '<p>The email of the group.</p>', 'RegisterToWorkMailRequest$Email' => '<p>The email for the user, group, or resource to be updated.</p>', 'Resource$Email' => '<p>The email of the resource.</p>', 'UpdatePrimaryEmailAddressRequest$Email' => '<p>The value of the email to be updated as primary.</p>', 'User$Email' => '<p>The email of the user.</p>', ], ], 'EmailAddressInUseException' => [ 'base' => '<p>The email address that you\'re trying to assign is already created for a different user, group, or resource.</p>', 'refs' => [], ], 'EntityAlreadyRegisteredException' => [ 'base' => '<p>The user, group, or resource that you\'re trying to register is already registered.</p>', 'refs' => [], ], 'EntityIdentifier' => [ 'base' => NULL, 'refs' => [ 'AssociateDelegateToResourceRequest$ResourceId' => '<p>The resource for which members (users or groups) are associated.</p> <p>The identifier can accept <i>ResourceId</i>, <i>Resourcename</i>, or <i>email</i>. The following identity formats are available:</p> <ul> <li> <p>Resource ID: r-0123456789a0123456789b0123456789</p> </li> <li> <p>Email address: resource@domain.tld</p> </li> <li> <p>Resource name: resource</p> </li> </ul>', 'AssociateDelegateToResourceRequest$EntityId' => '<p>The member (user or group) to associate to the resource.</p> <p>The entity ID can accept <i>UserId or GroupID</i>, <i>Username or Groupname</i>, or <i>email</i>.</p> <ul> <li> <p>Entity: 12345678-1234-1234-1234-123456789012 or S-1-1-12-1234567890-123456789-123456789-1234</p> </li> <li> <p>Email address: entity@domain.tld</p> </li> <li> <p>Entity: entity</p> </li> </ul>', 'AssociateMemberToGroupRequest$GroupId' => '<p>The group to which the member (user or group) is associated.</p> <p>The identifier can accept <i>GroupId</i>, <i>Groupname</i>, or <i>email</i>. The following identity formats are available:</p> <ul> <li> <p>Group ID: 12345678-1234-1234-1234-123456789012 or S-1-1-12-1234567890-123456789-123456789-1234</p> </li> <li> <p>Email address: group@domain.tld</p> </li> <li> <p>Group name: group</p> </li> </ul>', 'AssociateMemberToGroupRequest$MemberId' => '<p>The member (user or group) to associate to the group.</p> <p>The member ID can accept <i>UserID or GroupId</i>, <i>Username or Groupname</i>, or <i>email</i>.</p> <ul> <li> <p>Member: 12345678-1234-1234-1234-123456789012 or S-1-1-12-1234567890-123456789-123456789-1234</p> </li> <li> <p>Email address: member@domain.tld</p> </li> <li> <p>Member name: member</p> </li> </ul>', 'DeleteGroupRequest$GroupId' => '<p>The identifier of the group to be deleted.</p> <p>The identifier can be the <i>GroupId</i>, or <i>Groupname</i>. The following identity formats are available:</p> <ul> <li> <p>Group ID: 12345678-1234-1234-1234-123456789012 or S-1-1-12-1234567890-123456789-123456789-1234</p> </li> <li> <p>Group name: group</p> </li> </ul>', 'DeleteMailboxPermissionsRequest$EntityId' => '<p>The identifier of the entity that owns the mailbox.</p> <p>The identifier can be <i>UserId or Group Id</i>, <i>Username or Groupname</i>, or <i>email</i>.</p> <ul> <li> <p>Entity ID: 12345678-1234-1234-1234-123456789012, r-0123456789a0123456789b0123456789, or S-1-1-12-1234567890-123456789-123456789-1234</p> </li> <li> <p>Email address: entity@domain.tld</p> </li> <li> <p>Entity name: entity</p> </li> </ul>', 'DeleteMailboxPermissionsRequest$GranteeId' => '<p>The identifier of the entity for which to delete granted permissions.</p> <p>The identifier can be <i>UserId, ResourceID, or Group Id</i>, <i>Username or Groupname</i>, or <i>email</i>.</p> <ul> <li> <p>Grantee ID: 12345678-1234-1234-1234-123456789012,r-0123456789a0123456789b0123456789, or S-1-1-12-1234567890-123456789-123456789-1234</p> </li> <li> <p>Email address: grantee@domain.tld</p> </li> <li> <p>Grantee name: grantee</p> </li> </ul>', 'DeleteMobileDeviceAccessOverrideRequest$UserId' => '<p>The WorkMail user for which you want to delete the override. Accepts the following types of user identities:</p> <ul> <li> <p>User ID: <code>12345678-1234-1234-1234-123456789012</code> or <code>S-1-1-12-1234567890-123456789-123456789-1234</code> </p> </li> <li> <p>Email address: <code>user@domain.tld</code> </p> </li> <li> <p>User name: <code>user</code> </p> </li> </ul>', 'DeleteResourceRequest$ResourceId' => '<p>The identifier of the resource to be deleted.</p> <p>The identifier can accept <i>ResourceId</i>, or <i>Resourcename</i>. The following identity formats are available:</p> <ul> <li> <p>Resource ID: r-0123456789a0123456789b0123456789</p> </li> <li> <p>Resource name: resource</p> </li> </ul>', 'DeleteUserRequest$UserId' => '<p>The identifier of the user to be deleted.</p> <p>The identifier can be the <i>UserId</i> or <i>Username</i>. The following identity formats are available:</p> <ul> <li> <p>User ID: 12345678-1234-1234-1234-123456789012 or S-1-1-12-1234567890-123456789-123456789-1234</p> </li> <li> <p>User name: user</p> </li> </ul>', 'DeregisterFromWorkMailRequest$EntityId' => '<p>The identifier for the member to be updated.</p> <p>The identifier can be <i>UserId, ResourceId, or Group Id</i>, <i>Username, Resourcename, or Groupname</i>, or <i>email</i>.</p> <ul> <li> <p>Entity ID: 12345678-1234-1234-1234-123456789012, r-0123456789a0123456789b0123456789, or S-1-1-12-1234567890-123456789-123456789-1234</p> </li> <li> <p>Email address: entity@domain.tld</p> </li> <li> <p>Entity name: entity</p> </li> </ul>', 'DescribeGroupRequest$GroupId' => '<p>The identifier for the group to be described.</p> <p>The identifier can accept <i>GroupId</i>, <i>Groupname</i>, or <i>email</i>. The following identity formats are available:</p> <ul> <li> <p>Group ID: 12345678-1234-1234-1234-123456789012 or S-1-1-12-1234567890-123456789-123456789-1234</p> </li> <li> <p>Email address: group@domain.tld</p> </li> <li> <p>Group name: group</p> </li> </ul>', 'DescribeResourceRequest$ResourceId' => '<p>The identifier of the resource to be described.</p> <p>The identifier can accept <i>ResourceId</i>, <i>Resourcename</i>, or <i>email</i>. The following identity formats are available:</p> <ul> <li> <p>Resource ID: r-0123456789a0123456789b0123456789</p> </li> <li> <p>Email address: resource@domain.tld</p> </li> <li> <p>Resource name: resource</p> </li> </ul>', 'DescribeUserRequest$UserId' => '<p>The identifier for the user to be described.</p> <p>The identifier can be the <i>UserId</i>, <i>Username</i>, or <i>email</i>. The following identity formats are available:</p> <ul> <li> <p>User ID: 12345678-1234-1234-1234-123456789012 or S-1-1-12-1234567890-123456789-123456789-1234</p> </li> <li> <p>Email address: user@domain.tld</p> </li> <li> <p>User name: user</p> </li> </ul> <p/>', 'DisassociateDelegateFromResourceRequest$ResourceId' => '<p>The identifier of the resource from which delegates\' set members are removed. </p> <p>The identifier can accept <i>ResourceId</i>, <i>Resourcename</i>, or <i>email</i>. The following identity formats are available:</p> <ul> <li> <p>Resource ID: r-0123456789a0123456789b0123456789</p> </li> <li> <p>Email address: resource@domain.tld</p> </li> <li> <p>Resource name: resource</p> </li> </ul>', 'DisassociateDelegateFromResourceRequest$EntityId' => '<p>The identifier for the member (user, group) to be removed from the resource\'s delegates.</p> <p>The entity ID can accept <i>UserId or GroupID</i>, <i>Username or Groupname</i>, or <i>email</i>.</p> <ul> <li> <p>Entity: 12345678-1234-1234-1234-123456789012 or S-1-1-12-1234567890-123456789-123456789-1234</p> </li> <li> <p>Email address: entity@domain.tld</p> </li> <li> <p>Entity: entity</p> </li> </ul>', 'DisassociateMemberFromGroupRequest$GroupId' => '<p>The identifier for the group from which members are removed.</p> <p>The identifier can accept <i>GroupId</i>, <i>Groupname</i>, or <i>email</i>. The following identity formats are available:</p> <ul> <li> <p>Group ID: 12345678-1234-1234-1234-123456789012 or S-1-1-12-1234567890-123456789-123456789-1234</p> </li> <li> <p>Email address: group@domain.tld</p> </li> <li> <p>Group name: group</p> </li> </ul>', 'DisassociateMemberFromGroupRequest$MemberId' => '<p>The identifier for the member to be removed from the group.</p> <p>The member ID can accept <i>UserID or GroupId</i>, <i>Username or Groupname</i>, or <i>email</i>.</p> <ul> <li> <p>Member ID: 12345678-1234-1234-1234-123456789012 or S-1-1-12-1234567890-123456789-123456789-1234</p> </li> <li> <p>Email address: member@domain.tld</p> </li> <li> <p>Member name: member</p> </li> </ul>', 'GetImpersonationRoleEffectRequest$TargetUser' => '<p>The WorkMail organization user chosen to test the impersonation role. The following identity formats are available:</p> <ul> <li> <p>User ID: <code>12345678-1234-1234-1234-123456789012</code> or <code>S-1-1-12-1234567890-123456789-123456789-1234</code> </p> </li> <li> <p>Email address: <code>user@domain.tld</code> </p> </li> <li> <p>User name: <code>user</code> </p> </li> </ul>', 'GetMailboxDetailsRequest$UserId' => '<p>The identifier for the user whose mailbox details are being requested.</p> <p>The identifier can be the <i>UserId</i>, <i>Username</i>, or <i>email</i>. The following identity formats are available:</p> <ul> <li> <p>User ID: 12345678-1234-1234-1234-123456789012 or S-1-1-12-1234567890-123456789-123456789-1234</p> </li> <li> <p>Email address: user@domain.tld</p> </li> <li> <p>User name: user</p> </li> </ul>', 'GetMobileDeviceAccessOverrideRequest$UserId' => '<p>Identifies the WorkMail user for the override. Accepts the following types of user identities: </p> <ul> <li> <p>User ID: <code>12345678-1234-1234-1234-123456789012</code> or <code>S-1-1-12-1234567890-123456789-123456789-1234</code> </p> </li> <li> <p>Email address: <code>user@domain.tld</code> </p> </li> <li> <p>User name: <code>user</code> </p> </li> </ul>', 'ListGroupMembersRequest$GroupId' => '<p>The identifier for the group to which the members (users or groups) are associated.</p> <p>The identifier can accept <i>GroupId</i>, <i>Groupname</i>, or <i>email</i>. The following identity formats are available:</p> <ul> <li> <p>Group ID: 12345678-1234-1234-1234-123456789012 or S-1-1-12-1234567890-123456789-123456789-1234</p> </li> <li> <p>Email address: group@domain.tld</p> </li> <li> <p>Group name: group</p> </li> </ul>', 'ListGroupsForEntityRequest$EntityId' => '<p>The identifier for the entity.</p> <p>The entity ID can accept <i>UserId or GroupID</i>, <i>Username or Groupname</i>, or <i>email</i>.</p> <ul> <li> <p>Entity ID: 12345678-1234-1234-1234-123456789012 or S-1-1-12-1234567890-123456789-123456789-1234</p> </li> <li> <p>Email address: entity@domain.tld</p> </li> <li> <p>Entity name: entity</p> </li> </ul>', 'ListMailboxPermissionsRequest$EntityId' => '<p>The identifier of the user, or resource for which to list mailbox permissions.</p> <p>The entity ID can accept <i>UserId or ResourceId</i>, <i>Username or Resourcename</i>, or <i>email</i>.</p> <ul> <li> <p>Entity ID: 12345678-1234-1234-1234-123456789012, or r-0123456789a0123456789b0123456789</p> </li> <li> <p>Email address: entity@domain.tld</p> </li> <li> <p>Entity name: entity</p> </li> </ul>', 'ListMobileDeviceAccessOverridesRequest$UserId' => '<p>The WorkMail user under which you list the mobile device access overrides. Accepts the following types of user identities:</p> <ul> <li> <p>User ID: <code>12345678-1234-1234-1234-123456789012</code> or <code>S-1-1-12-1234567890-123456789-123456789-1234</code> </p> </li> <li> <p>Email address: <code>user@domain.tld</code> </p> </li> <li> <p>User name: <code>user</code> </p> </li> </ul>', 'ListResourceDelegatesRequest$ResourceId' => '<p>The identifier for the resource whose delegates are listed.</p> <p>The identifier can accept <i>ResourceId</i>, <i>Resourcename</i>, or <i>email</i>. The following identity formats are available:</p> <ul> <li> <p>Resource ID: r-0123456789a0123456789b0123456789</p> </li> <li> <p>Email address: resource@domain.tld</p> </li> <li> <p>Resource name: resource</p> </li> </ul>', 'PutMailboxPermissionsRequest$EntityId' => '<p>The identifier of the user or resource for which to update mailbox permissions.</p> <p>The identifier can be <i>UserId, ResourceID, or Group Id</i>, <i>Username, Resourcename, or Groupname</i>, or <i>email</i>.</p> <ul> <li> <p>Entity ID: 12345678-1234-1234-1234-123456789012, r-0123456789a0123456789b0123456789, or S-1-1-12-1234567890-123456789-123456789-1234</p> </li> <li> <p>Email address: entity@domain.tld</p> </li> <li> <p>Entity name: entity</p> </li> </ul>', 'PutMailboxPermissionsRequest$GranteeId' => '<p>The identifier of the user, group, or resource to which to grant the permissions.</p> <p>The identifier can be <i>UserId, ResourceID, or Group Id</i>, <i>Username, Resourcename, or Groupname</i>, or <i>email</i>.</p> <ul> <li> <p>Grantee ID: 12345678-1234-1234-1234-123456789012, r-0123456789a0123456789b0123456789, or S-1-1-12-1234567890-123456789-123456789-1234</p> </li> <li> <p>Email address: grantee@domain.tld</p> </li> <li> <p>Grantee name: grantee</p> </li> </ul>', 'PutMobileDeviceAccessOverrideRequest$UserId' => '<p>The WorkMail user for which you create the override. Accepts the following types of user identities:</p> <ul> <li> <p>User ID: <code>12345678-1234-1234-1234-123456789012</code> or <code>S-1-1-12-1234567890-123456789-123456789-1234</code> </p> </li> <li> <p>Email address: <code>user@domain.tld</code> </p> </li> <li> <p>User name: <code>user</code> </p> </li> </ul>', 'RegisterToWorkMailRequest$EntityId' => '<p>The identifier for the user, group, or resource to be updated.</p> <p>The identifier can accept <i>UserId, ResourceId, or GroupId</i>, or <i>Username, Resourcename, or Groupname</i>. The following identity formats are available:</p> <ul> <li> <p>Entity ID: 12345678-1234-1234-1234-123456789012, r-0123456789a0123456789b0123456789, or S-1-1-12-1234567890-123456789-123456789-1234</p> </li> <li> <p>Entity name: entity</p> </li> </ul>', 'StartMailboxExportJobRequest$EntityId' => '<p>The identifier of the user or resource associated with the mailbox.</p> <p>The identifier can accept <i>UserId or ResourceId</i>, <i>Username or Resourcename</i>, or <i>email</i>. The following identity formats are available:</p> <ul> <li> <p>Entity ID: 12345678-1234-1234-1234-123456789012, r-0123456789a0123456789b0123456789 , or S-1-1-12-1234567890-123456789-123456789-1234</p> </li> <li> <p>Email address: entity@domain.tld</p> </li> <li> <p>Entity name: entity</p> </li> </ul>', 'TargetUsers$member' => NULL, 'UpdateGroupRequest$GroupId' => '<p>The identifier for the group to be updated.</p> <p>The identifier can accept <i>GroupId</i>, <i>Groupname</i>, or <i>email</i>. The following identity formats are available:</p> <ul> <li> <p>Group ID: 12345678-1234-1234-1234-123456789012 or S-1-1-12-1234567890-123456789-123456789-1234</p> </li> <li> <p>Email address: group@domain.tld</p> </li> <li> <p>Group name: group</p> </li> </ul>', 'UpdateMailboxQuotaRequest$UserId' => '<p>The identifer for the user for whom to update the mailbox quota.</p> <p>The identifier can be the <i>UserId</i>, <i>Username</i>, or <i>email</i>. The following identity formats are available:</p> <ul> <li> <p>User ID: 12345678-1234-1234-1234-123456789012 or S-1-1-12-1234567890-123456789-123456789-1234</p> </li> <li> <p>Email address: user@domain.tld</p> </li> <li> <p>User name: user</p> </li> </ul>', 'UpdatePrimaryEmailAddressRequest$EntityId' => '<p>The user, group, or resource to update.</p> <p>The identifier can accept <i>UseriD, ResourceId, or GroupId</i>, <i>Username, Resourcename, or Groupname</i>, or <i>email</i>. The following identity formats are available:</p> <ul> <li> <p>Entity ID: 12345678-1234-1234-1234-123456789012, r-0123456789a0123456789b0123456789, or S-1-1-12-1234567890-123456789-123456789-1234</p> </li> <li> <p>Email address: entity@domain.tld</p> </li> <li> <p>Entity name: entity</p> </li> </ul>', 'UpdateResourceRequest$ResourceId' => '<p>The identifier of the resource to be updated.</p> <p>The identifier can accept <i>ResourceId</i>, <i>Resourcename</i>, or <i>email</i>. The following identity formats are available:</p> <ul> <li> <p>Resource ID: r-0123456789a0123456789b0123456789</p> </li> <li> <p>Email address: resource@domain.tld</p> </li> <li> <p>Resource name: resource</p> </li> </ul>', 'UpdateUserRequest$UserId' => '<p>The identifier for the user to be updated.</p> <p>The identifier can be the <i>UserId</i>, <i>Username</i>, or <i>email</i>. The following identity formats are available:</p> <ul> <li> <p>User ID: 12345678-1234-1234-1234-123456789012 or S-1-1-12-1234567890-123456789-123456789-1234</p> </li> <li> <p>Email address: user@domain.tld</p> </li> <li> <p>User name: user</p> </li> </ul>', ], ], 'EntityNotFoundException' => [ 'base' => '<p>The identifier supplied for the user, group, or resource does not exist in your organization.</p>', 'refs' => [], ], 'EntityState' => [ 'base' => NULL, 'refs' => [ 'DescribeGroupResponse$State' => '<p>The state of the user: enabled (registered to WorkMail) or disabled (deregistered or never registered to WorkMail).</p>', 'DescribeResourceResponse$State' => '<p>The state of the resource: enabled (registered to WorkMail), disabled (deregistered or never registered to WorkMail), or deleted.</p>', 'DescribeUserResponse$State' => '<p>The state of a user: enabled (registered to WorkMail) or disabled (deregistered or never registered to WorkMail).</p>', 'Group$State' => '<p>The state of the group, which can be ENABLED, DISABLED, or DELETED.</p>', 'ListGroupsFilters$State' => '<p>Filters only groups with the provided state.</p>', 'ListResourcesFilters$State' => '<p>Filters only resource with the provided state.</p>', 'ListUsersFilters$State' => '<p>Filters only users with the provided state.</p>', 'Member$State' => '<p>The state of the member, which can be ENABLED, DISABLED, or DELETED.</p>', 'Resource$State' => '<p>The state of the resource, which can be ENABLED, DISABLED, or DELETED.</p>', 'User$State' => '<p>The state of the user, which can be ENABLED, DISABLED, or DELETED.</p>', ], ], 'EntityStateException' => [ 'base' => '<p>You are performing an operation on a user, group, or resource that isn\'t in the expected state, such as trying to delete an active user.</p>', 'refs' => [], ], 'EntityType' => [ 'base' => NULL, 'refs' => [ 'DescribeEntityResponse$Type' => '<p>Entity type.</p>', ], ], 'EwsAvailabilityProvider' => [ 'base' => '<p>Describes an EWS based availability provider. This is only used as input to the service.</p>', 'refs' => [ 'CreateAvailabilityConfigurationRequest$EwsProvider' => '<p>Exchange Web Services (EWS) availability provider definition. The request must contain exactly one provider definition, either <code>EwsProvider</code> or <code>LambdaProvider</code>.</p>', 'TestAvailabilityConfigurationRequest$EwsProvider' => NULL, 'UpdateAvailabilityConfigurationRequest$EwsProvider' => '<p>The EWS availability provider definition. The request must contain exactly one provider definition, either <code>EwsProvider</code> or <code>LambdaProvider</code>. The previously stored provider will be overridden by the one provided.</p>', ], ], 'ExpiresIn' => [ 'base' => NULL, 'refs' => [ 'AssumeImpersonationRoleResponse$ExpiresIn' => '<p>The authentication token\'s validity, in seconds.</p>', ], ], 'ExternalUserName' => [ 'base' => NULL, 'refs' => [ 'EwsAvailabilityProvider$EwsUsername' => '<p>The username used to authenticate the remote EWS server.</p>', 'RedactedEwsAvailabilityProvider$EwsUsername' => '<p>The username used to authenticate the remote EWS server.</p>', ], ], 'FolderConfiguration' => [ 'base' => '<p>The configuration applied to an organization\'s folders by its retention policy.</p>', 'refs' => [ 'FolderConfigurations$member' => NULL, ], ], 'FolderConfigurations' => [ 'base' => NULL, 'refs' => [ 'GetDefaultRetentionPolicyResponse$FolderConfigurations' => '<p>The retention policy folder configurations.</p>', 'PutRetentionPolicyRequest$FolderConfigurations' => '<p>The retention policy folder configurations.</p>', ], ], 'FolderName' => [ 'base' => NULL, 'refs' => [ 'FolderConfiguration$Name' => '<p>The folder name.</p>', ], ], 'GetAccessControlEffectRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAccessControlEffectResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetDefaultRetentionPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDefaultRetentionPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetImpersonationRoleEffectRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetImpersonationRoleEffectResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetImpersonationRoleRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetImpersonationRoleResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetMailDomainRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMailDomainResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetMailboxDetailsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMailboxDetailsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetMobileDeviceAccessEffectRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMobileDeviceAccessEffectResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetMobileDeviceAccessOverrideRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMobileDeviceAccessOverrideResponse' => [ 'base' => NULL, 'refs' => [], ], 'Group' => [ 'base' => '<p>The representation of an WorkMail group.</p>', 'refs' => [ 'Groups$member' => NULL, ], ], 'GroupIdentifier' => [ 'base' => '<p>The identifier that contains the Group ID and name of a group.</p>', 'refs' => [ 'GroupIdentifiers$member' => NULL, ], ], 'GroupIdentifiers' => [ 'base' => NULL, 'refs' => [ 'ListGroupsForEntityResponse$Groups' => '<p>The overview of groups in an organization.</p>', ], ], 'GroupName' => [ 'base' => NULL, 'refs' => [ 'CreateGroupRequest$Name' => '<p>The name of the group.</p>', 'DescribeGroupResponse$Name' => '<p>The name of the described group.</p>', 'Group$Name' => '<p>The name of the group.</p>', 'GroupIdentifier$GroupName' => '<p>Group name that matched the group.</p>', ], ], 'Groups' => [ 'base' => NULL, 'refs' => [ 'ListGroupsResponse$Groups' => '<p>The overview of groups for an organization.</p>', ], ], 'HostedZoneId' => [ 'base' => NULL, 'refs' => [ 'Domain$HostedZoneId' => '<p>The hosted zone ID for a domain hosted in Route 53. Required when configuring a domain hosted in Route 53.</p>', ], ], 'IdempotencyClientToken' => [ 'base' => NULL, 'refs' => [ 'CancelMailboxExportJobRequest$ClientToken' => '<p>The idempotency token for the client request.</p>', 'CreateAvailabilityConfigurationRequest$ClientToken' => '<p>An idempotent token that ensures that an API request is executed only once.</p>', 'CreateImpersonationRoleRequest$ClientToken' => '<p>The idempotency token for the client request.</p>', 'CreateMobileDeviceAccessRuleRequest$ClientToken' => '<p>The idempotency token for the client request.</p>', 'CreateOrganizationRequest$ClientToken' => '<p>The idempotency token associated with the request.</p>', 'DeleteOrganizationRequest$ClientToken' => '<p>The idempotency token associated with the request.</p>', 'RegisterMailDomainRequest$ClientToken' => '<p>Idempotency token used when retrying requests.</p>', 'StartMailboxExportJobRequest$ClientToken' => '<p>The idempotency token for the client request.</p>', ], ], 'ImpersonationMatchedRule' => [ 'base' => '<p>The impersonation rule that matched the input.</p>', 'refs' => [ 'ImpersonationMatchedRuleList$member' => NULL, ], ], 'ImpersonationMatchedRuleList' => [ 'base' => NULL, 'refs' => [ 'GetImpersonationRoleEffectResponse$MatchedRules' => '<p>A list of the rules that match the input and produce the configured effect.</p>', ], ], 'ImpersonationRole' => [ 'base' => '<p>An impersonation role for the given WorkMail organization.</p>', 'refs' => [ 'ImpersonationRoleList$member' => NULL, ], ], 'ImpersonationRoleDescription' => [ 'base' => NULL, 'refs' => [ 'CreateImpersonationRoleRequest$Description' => '<p>The description of the new impersonation role.</p>', 'GetImpersonationRoleResponse$Description' => '<p>The impersonation role description.</p>', 'UpdateImpersonationRoleRequest$Description' => '<p>The updated impersonation role description.</p>', ], ], 'ImpersonationRoleId' => [ 'base' => NULL, 'refs' => [ 'AssumeImpersonationRoleRequest$ImpersonationRoleId' => '<p>The impersonation role ID to assume.</p>', 'CreateImpersonationRoleResponse$ImpersonationRoleId' => '<p>The new impersonation role ID.</p>', 'DeleteImpersonationRoleRequest$ImpersonationRoleId' => '<p>The ID of the impersonation role to delete.</p>', 'GetAccessControlEffectRequest$ImpersonationRoleId' => '<p>The impersonation role ID.</p>', 'GetImpersonationRoleEffectRequest$ImpersonationRoleId' => '<p>The impersonation role ID to test.</p>', 'GetImpersonationRoleRequest$ImpersonationRoleId' => '<p>The impersonation role ID to retrieve.</p>', 'GetImpersonationRoleResponse$ImpersonationRoleId' => '<p>The impersonation role ID.</p>', 'ImpersonationRole$ImpersonationRoleId' => '<p>The identifier of the impersonation role.</p>', 'ImpersonationRoleIdList$member' => NULL, 'UpdateImpersonationRoleRequest$ImpersonationRoleId' => '<p>The ID of the impersonation role to update.</p>', ], ], 'ImpersonationRoleIdList' => [ 'base' => NULL, 'refs' => [ 'AccessControlRule$ImpersonationRoleIds' => '<p>Impersonation role IDs to include in the rule.</p>', 'AccessControlRule$NotImpersonationRoleIds' => '<p>Impersonation role IDs to exclude from the rule.</p>', 'PutAccessControlRuleRequest$ImpersonationRoleIds' => '<p>Impersonation role IDs to include in the rule.</p>', 'PutAccessControlRuleRequest$NotImpersonationRoleIds' => '<p>Impersonation role IDs to exclude from the rule.</p>', ], ], 'ImpersonationRoleList' => [ 'base' => NULL, 'refs' => [ 'ListImpersonationRolesResponse$Roles' => '<p>The list of impersonation roles under the given WorkMail organization.</p>', ], ], 'ImpersonationRoleName' => [ 'base' => NULL, 'refs' => [ 'CreateImpersonationRoleRequest$Name' => '<p>The name of the new impersonation role.</p>', 'GetImpersonationRoleResponse$Name' => '<p>The impersonation role name.</p>', 'ImpersonationRole$Name' => '<p>The impersonation role name.</p>', 'UpdateImpersonationRoleRequest$Name' => '<p>The updated impersonation role name.</p>', ], ], 'ImpersonationRoleType' => [ 'base' => NULL, 'refs' => [ 'CreateImpersonationRoleRequest$Type' => '<p>The impersonation role\'s type. The available impersonation role types are <code>READ_ONLY</code> or <code>FULL_ACCESS</code>.</p>', 'GetImpersonationRoleEffectResponse$Type' => '<p>The impersonation role type.</p>', 'GetImpersonationRoleResponse$Type' => '<p>The impersonation role type.</p>', 'ImpersonationRole$Type' => '<p>The impersonation role type.</p>', 'UpdateImpersonationRoleRequest$Type' => '<p>The updated impersonation role type.</p>', ], ], 'ImpersonationRule' => [ 'base' => '<p>The rules for the given impersonation role.</p>', 'refs' => [ 'ImpersonationRuleList$member' => NULL, ], ], 'ImpersonationRuleDescription' => [ 'base' => NULL, 'refs' => [ 'ImpersonationRule$Description' => '<p>The rule description.</p>', ], ], 'ImpersonationRuleId' => [ 'base' => NULL, 'refs' => [ 'ImpersonationMatchedRule$ImpersonationRuleId' => '<p>The ID of the rule that matched the input</p>', 'ImpersonationRule$ImpersonationRuleId' => '<p>The identifier of the rule.</p>', ], ], 'ImpersonationRuleList' => [ 'base' => NULL, 'refs' => [ 'CreateImpersonationRoleRequest$Rules' => '<p>The list of rules for the impersonation role.</p>', 'GetImpersonationRoleResponse$Rules' => '<p>The list of rules for the given impersonation role.</p>', 'UpdateImpersonationRoleRequest$Rules' => '<p>The updated list of rules.</p>', ], ], 'ImpersonationRuleName' => [ 'base' => NULL, 'refs' => [ 'ImpersonationMatchedRule$Name' => '<p>The name of the rule that matched the input.</p>', 'ImpersonationRule$Name' => '<p>The rule name.</p>', ], ], 'ImpersonationToken' => [ 'base' => NULL, 'refs' => [ 'AssumeImpersonationRoleResponse$Token' => '<p>The authentication token for the impersonation role.</p>', ], ], 'InvalidConfigurationException' => [ 'base' => '<p>The configuration for a resource isn\'t valid. A resource must either be able to auto-respond to requests or have at least one delegate associated that can do so on its behalf.</p>', 'refs' => [], ], 'InvalidCustomSesConfigurationException' => [ 'base' => '<p>You SES configuration has customizations that WorkMail cannot save. The error message lists the invalid setting. For examples of invalid settings, refer to <a href="https://docs.aws.amazon.com/ses/latest/APIReference/API_CreateReceiptRule.html">CreateReceiptRule</a>.</p>', 'refs' => [], ], 'InvalidParameterException' => [ 'base' => '<p>One or more of the input parameters don\'t match the service\'s restrictions.</p>', 'refs' => [], ], 'InvalidPasswordException' => [ 'base' => '<p>The supplied password doesn\'t match the minimum security constraints, such as length or use of special characters.</p>', 'refs' => [], ], 'IpAddress' => [ 'base' => NULL, 'refs' => [ 'GetAccessControlEffectRequest$IpAddress' => '<p>The IPv4 address.</p>', ], ], 'IpRange' => [ 'base' => NULL, 'refs' => [ 'IpRangeList$member' => NULL, ], ], 'IpRangeList' => [ 'base' => NULL, 'refs' => [ 'AccessControlRule$IpRanges' => '<p>IPv4 CIDR ranges to include in the rule.</p>', 'AccessControlRule$NotIpRanges' => '<p>IPv4 CIDR ranges to exclude from the rule.</p>', 'PutAccessControlRuleRequest$IpRanges' => '<p>IPv4 CIDR ranges to include in the rule.</p>', 'PutAccessControlRuleRequest$NotIpRanges' => '<p>IPv4 CIDR ranges to exclude from the rule.</p>', ], ], 'Jobs' => [ 'base' => NULL, 'refs' => [ 'ListMailboxExportJobsResponse$Jobs' => '<p>The mailbox export job details.</p>', ], ], 'KmsKeyArn' => [ 'base' => NULL, 'refs' => [ 'CreateOrganizationRequest$KmsKeyArn' => '<p>The Amazon Resource Name (ARN) of a customer managed key from AWS KMS.</p>', 'DescribeMailboxExportJobResponse$KmsKeyArn' => '<p>The Amazon Resource Name (ARN) of the symmetric AWS Key Management Service (AWS KMS) key that encrypts the exported mailbox content.</p>', 'StartMailboxExportJobRequest$KmsKeyArn' => '<p>The Amazon Resource Name (ARN) of the symmetric AWS Key Management Service (AWS KMS) key that encrypts the exported mailbox content.</p>', ], ], 'LambdaArn' => [ 'base' => NULL, 'refs' => [ 'LambdaAvailabilityProvider$LambdaArn' => '<p>The Amazon Resource Name (ARN) of the Lambda that acts as the availability provider.</p>', ], ], 'LambdaAvailabilityProvider' => [ 'base' => '<p>Describes a Lambda based availability provider.</p>', 'refs' => [ 'AvailabilityConfiguration$LambdaProvider' => '<p>If ProviderType is <code>LAMBDA</code> then this field contains <code>LambdaAvailabilityProvider</code>. Otherwise, it is not required.</p>', 'CreateAvailabilityConfigurationRequest$LambdaProvider' => '<p>Lambda availability provider definition. The request must contain exactly one provider definition, either <code>EwsProvider</code> or <code>LambdaProvider</code>.</p>', 'TestAvailabilityConfigurationRequest$LambdaProvider' => NULL, 'UpdateAvailabilityConfigurationRequest$LambdaProvider' => '<p>The Lambda availability provider definition. The request must contain exactly one provider definition, either <code>EwsProvider</code> or <code>LambdaProvider</code>. The previously stored provider will be overridden by the one provided.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>The request exceeds the limit of the resource.</p>', 'refs' => [], ], 'ListAccessControlRulesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAccessControlRulesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAliasesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAliasesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAvailabilityConfigurationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAvailabilityConfigurationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListGroupMembersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListGroupMembersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListGroupsFilters' => [ 'base' => '<p> Filtering options for <i>ListGroups</i> operation. This is only used as input to Operation.</p>', 'refs' => [ 'ListGroupsRequest$Filters' => '<p>Limit the search results based on the filter criteria. Only one filter per request is supported.</p>', ], ], 'ListGroupsForEntityFilters' => [ 'base' => '<p> Filtering options for <i>ListGroupsForEntity</i> operation. This is only used as input to Operation.</p>', 'refs' => [ 'ListGroupsForEntityRequest$Filters' => '<p>Limit the search results based on the filter criteria.</p>', ], ], 'ListGroupsForEntityRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListGroupsForEntityResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListImpersonationRolesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListImpersonationRolesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListMailDomainsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListMailDomainsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListMailboxExportJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListMailboxExportJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListMailboxPermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListMailboxPermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListMobileDeviceAccessOverridesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListMobileDeviceAccessOverridesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListMobileDeviceAccessRulesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListMobileDeviceAccessRulesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListOrganizationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListOrganizationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListResourceDelegatesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListResourceDelegatesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListResourcesFilters' => [ 'base' => '<p>Filtering options for <i>ListResources</i> operation. This is only used as input to Operation.</p>', 'refs' => [ 'ListResourcesRequest$Filters' => '<p>Limit the resource search results based on the filter criteria. You can only use one filter per request.</p>', ], ], 'ListResourcesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListResourcesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListUsersFilters' => [ 'base' => '<p> Filtering options for <i>ListUsers</i> operation. This is only used as input to Operation.</p>', 'refs' => [ 'ListUsersRequest$Filters' => '<p>Limit the user search results based on the filter criteria. You can only use one filter per request.</p>', ], ], 'ListUsersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListUsersResponse' => [ 'base' => NULL, 'refs' => [], ], 'LogGroupArn' => [ 'base' => NULL, 'refs' => [ 'DescribeEmailMonitoringConfigurationResponse$LogGroupArn' => '<p>The Amazon Resource Name (ARN) of the CloudWatch Log group associated with the email monitoring configuration.</p>', 'PutEmailMonitoringConfigurationRequest$LogGroupArn' => '<p>The Amazon Resource Name (ARN) of the CloudWatch Log group associated with the email monitoring configuration.</p>', ], ], 'MailDomainInUseException' => [ 'base' => '<p>The domain you\'re trying to change is in use by another user or organization in your account. See the error message for details.</p>', 'refs' => [], ], 'MailDomainNotFoundException' => [ 'base' => '<p>The domain specified is not found in your organization.</p>', 'refs' => [], ], 'MailDomainStateException' => [ 'base' => '<p>After a domain has been added to the organization, it must be verified. The domain is not yet verified.</p>', 'refs' => [], ], 'MailDomainSummary' => [ 'base' => '<p>The data for a given domain.</p>', 'refs' => [ 'MailDomains$member' => NULL, ], ], 'MailDomains' => [ 'base' => NULL, 'refs' => [ 'ListMailDomainsResponse$MailDomains' => '<p>The list of mail domain summaries, specifying domains that exist in the specified WorkMail organization, along with the information about whether the domain is or isn\'t the default.</p>', ], ], 'MailboxExportErrorInfo' => [ 'base' => NULL, 'refs' => [ 'DescribeMailboxExportJobResponse$ErrorInfo' => '<p>Error information for failed mailbox export jobs.</p>', ], ], 'MailboxExportJob' => [ 'base' => '<p>The details of a mailbox export job, including the user or resource ID associated with the mailbox and the S3 bucket that the mailbox contents are exported to.</p>', 'refs' => [ 'Jobs$member' => NULL, ], ], 'MailboxExportJobId' => [ 'base' => NULL, 'refs' => [ 'CancelMailboxExportJobRequest$JobId' => '<p>The job ID.</p>', 'DescribeMailboxExportJobRequest$JobId' => '<p>The mailbox export job ID.</p>', 'MailboxExportJob$JobId' => '<p>The identifier of the mailbox export job.</p>', 'StartMailboxExportJobResponse$JobId' => '<p>The job ID.</p>', ], ], 'MailboxExportJobState' => [ 'base' => NULL, 'refs' => [ 'DescribeMailboxExportJobResponse$State' => '<p>The state of the mailbox export job.</p>', 'MailboxExportJob$State' => '<p>The state of the mailbox export job.</p>', ], ], 'MailboxQuota' => [ 'base' => NULL, 'refs' => [ 'GetMailboxDetailsResponse$MailboxQuota' => '<p>The maximum allowed mailbox size, in MB, for the specified user.</p>', 'UpdateMailboxQuotaRequest$MailboxQuota' => '<p>The updated mailbox quota, in MB, for the specified user.</p>', ], ], 'MailboxSize' => [ 'base' => NULL, 'refs' => [ 'GetMailboxDetailsResponse$MailboxSize' => '<p>The current mailbox size, in MB, for the specified user.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListAliasesRequest$MaxResults' => '<p>The maximum number of results to return in a single call.</p>', 'ListAvailabilityConfigurationsRequest$MaxResults' => '<p>The maximum number of results to return in a single call.</p>', 'ListGroupMembersRequest$MaxResults' => '<p>The maximum number of results to return in a single call.</p>', 'ListGroupsForEntityRequest$MaxResults' => '<p>The maximum number of results to return in a single call.</p>', 'ListGroupsRequest$MaxResults' => '<p>The maximum number of results to return in a single call.</p>', 'ListImpersonationRolesRequest$MaxResults' => '<p>The maximum number of results returned in a single call.</p>', 'ListMailDomainsRequest$MaxResults' => '<p>The maximum number of results to return in a single call.</p>', 'ListMailboxExportJobsRequest$MaxResults' => '<p>The maximum number of results to return in a single call.</p>', 'ListMailboxPermissionsRequest$MaxResults' => '<p>The maximum number of results to return in a single call.</p>', 'ListMobileDeviceAccessOverridesRequest$MaxResults' => '<p>The maximum number of results to return in a single call.</p>', 'ListOrganizationsRequest$MaxResults' => '<p>The maximum number of results to return in a single call.</p>', 'ListResourceDelegatesRequest$MaxResults' => '<p>The number of maximum results in a page.</p>', 'ListResourcesRequest$MaxResults' => '<p>The maximum number of results to return in a single call.</p>', 'ListUsersRequest$MaxResults' => '<p>The maximum number of results to return in a single call.</p>', ], ], 'Member' => [ 'base' => '<p>The representation of a user or group.</p>', 'refs' => [ 'Members$member' => NULL, ], ], 'MemberType' => [ 'base' => NULL, 'refs' => [ 'Delegate$Type' => '<p>The type of the delegate: user or group.</p>', 'Member$Type' => '<p>A member can be a user or group.</p>', 'Permission$GranteeType' => '<p>The type of user, group, or resource referred to in GranteeId.</p>', ], ], 'Members' => [ 'base' => NULL, 'refs' => [ 'ListGroupMembersResponse$Members' => '<p>The members associated to the group.</p>', ], ], 'MobileDeviceAccessMatchedRule' => [ 'base' => '<p>The rule that a simulated user matches.</p>', 'refs' => [ 'MobileDeviceAccessMatchedRuleList$member' => NULL, ], ], 'MobileDeviceAccessMatchedRuleList' => [ 'base' => NULL, 'refs' => [ 'GetMobileDeviceAccessEffectResponse$MatchedRules' => '<p>A list of the rules which matched the simulated user input and produced the effect.</p>', ], ], 'MobileDeviceAccessOverride' => [ 'base' => '<p>The override object.</p>', 'refs' => [ 'MobileDeviceAccessOverridesList$member' => NULL, ], ], 'MobileDeviceAccessOverridesList' => [ 'base' => NULL, 'refs' => [ 'ListMobileDeviceAccessOverridesResponse$Overrides' => '<p>The list of mobile device access overrides that exist for the specified WorkMail organization and user.</p>', ], ], 'MobileDeviceAccessRule' => [ 'base' => '<p>A rule that controls access to mobile devices for an WorkMail group.</p>', 'refs' => [ 'MobileDeviceAccessRulesList$member' => NULL, ], ], 'MobileDeviceAccessRuleDescription' => [ 'base' => NULL, 'refs' => [ 'CreateMobileDeviceAccessRuleRequest$Description' => '<p>The rule description.</p>', 'GetMobileDeviceAccessOverrideResponse$Description' => '<p>A description of the override.</p>', 'MobileDeviceAccessOverride$Description' => '<p>A description of the override.</p>', 'MobileDeviceAccessRule$Description' => '<p>The description of a mobile access rule.</p>', 'PutMobileDeviceAccessOverrideRequest$Description' => '<p>A description of the override.</p>', 'UpdateMobileDeviceAccessRuleRequest$Description' => '<p>The updated rule description.</p>', ], ], 'MobileDeviceAccessRuleEffect' => [ 'base' => NULL, 'refs' => [ 'CreateMobileDeviceAccessRuleRequest$Effect' => '<p>The effect of the rule when it matches. Allowed values are <code>ALLOW</code> or <code>DENY</code>.</p>', 'GetMobileDeviceAccessEffectResponse$Effect' => '<p>The effect of the simulated access, <code>ALLOW</code> or <code>DENY</code>, after evaluating mobile device access rules in the WorkMail organization for the simulated user parameters.</p>', 'GetMobileDeviceAccessOverrideResponse$Effect' => '<p>The effect of the override, <code>ALLOW</code> or <code>DENY</code>.</p>', 'MobileDeviceAccessOverride$Effect' => '<p>The effect of the override, <code>ALLOW</code> or <code>DENY</code>.</p>', 'MobileDeviceAccessRule$Effect' => '<p>The effect of the rule when it matches. Allowed values are <code>ALLOW</code> or <code>DENY</code>.</p>', 'PutMobileDeviceAccessOverrideRequest$Effect' => '<p>The effect of the override, <code>ALLOW</code> or <code>DENY</code>.</p>', 'UpdateMobileDeviceAccessRuleRequest$Effect' => '<p>The effect of the rule when it matches. Allowed values are <code>ALLOW</code> or <code>DENY</code>.</p>', ], ], 'MobileDeviceAccessRuleId' => [ 'base' => NULL, 'refs' => [ 'CreateMobileDeviceAccessRuleResponse$MobileDeviceAccessRuleId' => '<p>The identifier for the newly created mobile device access rule.</p>', 'DeleteMobileDeviceAccessRuleRequest$MobileDeviceAccessRuleId' => '<p>The identifier of the rule to be deleted.</p>', 'MobileDeviceAccessMatchedRule$MobileDeviceAccessRuleId' => '<p>Identifier of the rule that a simulated user matches.</p>', 'MobileDeviceAccessRule$MobileDeviceAccessRuleId' => '<p>The ID assigned to a mobile access rule.</p>', 'UpdateMobileDeviceAccessRuleRequest$MobileDeviceAccessRuleId' => '<p>The identifier of the rule to be updated.</p>', ], ], 'MobileDeviceAccessRuleName' => [ 'base' => NULL, 'refs' => [ 'CreateMobileDeviceAccessRuleRequest$Name' => '<p>The rule name.</p>', 'MobileDeviceAccessMatchedRule$Name' => '<p>Name of a rule that a simulated user matches.</p>', 'MobileDeviceAccessRule$Name' => '<p>The name of a mobile access rule.</p>', 'UpdateMobileDeviceAccessRuleRequest$Name' => '<p>The updated rule name.</p>', ], ], 'MobileDeviceAccessRulesList' => [ 'base' => NULL, 'refs' => [ 'ListMobileDeviceAccessRulesResponse$Rules' => '<p>The list of mobile device access rules that exist under the specified WorkMail organization.</p>', ], ], 'NameAvailabilityException' => [ 'base' => '<p>The user, group, or resource name isn\'t unique in WorkMail.</p>', 'refs' => [], ], 'NewResourceDescription' => [ 'base' => NULL, 'refs' => [ 'UpdateResourceRequest$Description' => '<p>Updates the resource description.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListAliasesRequest$NextToken' => '<p>The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>', 'ListAliasesResponse$NextToken' => '<p>The token to use to retrieve the next page of results. The value is "null" when there are no more results to return.</p>', 'ListAvailabilityConfigurationsRequest$NextToken' => '<p>The token to use to retrieve the next page of results. The first call does not require a token.</p>', 'ListAvailabilityConfigurationsResponse$NextToken' => '<p>The token to use to retrieve the next page of results. The value is <code>null</code> when there are no further results to return.</p>', 'ListGroupMembersRequest$NextToken' => '<p> The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>', 'ListGroupMembersResponse$NextToken' => '<p>The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>', 'ListGroupsForEntityRequest$NextToken' => '<p>The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>', 'ListGroupsForEntityResponse$NextToken' => '<p>The token to use to retrieve the next page of results. This value is `null` when there are no more results to return.</p>', 'ListGroupsRequest$NextToken' => '<p>The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>', 'ListGroupsResponse$NextToken' => '<p>The token to use to retrieve the next page of results. The value is "null" when there are no more results to return.</p>', 'ListImpersonationRolesRequest$NextToken' => '<p>The token used to retrieve the next page of results. The first call doesn\'t require a token.</p>', 'ListImpersonationRolesResponse$NextToken' => '<p>The token to retrieve the next page of results. The value is <code>null</code> when there are no results to return.</p>', 'ListMailDomainsRequest$NextToken' => '<p>The token to use to retrieve the next page of results. The first call does not require a token.</p>', 'ListMailDomainsResponse$NextToken' => '<p>The token to use to retrieve the next page of results. The value becomes <code>null</code> when there are no more results to return.</p>', 'ListMailboxExportJobsRequest$NextToken' => '<p>The token to use to retrieve the next page of results.</p>', 'ListMailboxExportJobsResponse$NextToken' => '<p>The token to use to retrieve the next page of results.</p>', 'ListMailboxPermissionsRequest$NextToken' => '<p>The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>', 'ListMailboxPermissionsResponse$NextToken' => '<p>The token to use to retrieve the next page of results. The value is "null" when there are no more results to return.</p>', 'ListMobileDeviceAccessOverridesRequest$NextToken' => '<p>The token to use to retrieve the next page of results. The first call does not require a token.</p>', 'ListMobileDeviceAccessOverridesResponse$NextToken' => '<p>The token to use to retrieve the next page of results. The value is “null” when there are no more results to return.</p>', 'ListOrganizationsRequest$NextToken' => '<p>The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>', 'ListOrganizationsResponse$NextToken' => '<p>The token to use to retrieve the next page of results. The value is "null" when there are no more results to return.</p>', 'ListResourceDelegatesRequest$NextToken' => '<p>The token used to paginate through the delegates associated with a resource.</p>', 'ListResourceDelegatesResponse$NextToken' => '<p>The token used to paginate through the delegates associated with a resource. While results are still available, it has an associated value. When the last page is reached, the token is empty.</p>', 'ListResourcesRequest$NextToken' => '<p>The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>', 'ListResourcesResponse$NextToken' => '<p> The token used to paginate through all the organization\'s resources. While results are still available, it has an associated value. When the last page is reached, the token is empty.</p>', 'ListUsersRequest$NextToken' => '<p>The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>', 'ListUsersResponse$NextToken' => '<p> The token to use to retrieve the next page of results. This value is `null` when there are no more results to return.</p>', ], ], 'OrganizationId' => [ 'base' => NULL, 'refs' => [ 'AssociateDelegateToResourceRequest$OrganizationId' => '<p>The organization under which the resource exists.</p>', 'AssociateMemberToGroupRequest$OrganizationId' => '<p>The organization under which the group exists.</p>', 'AssumeImpersonationRoleRequest$OrganizationId' => '<p>The WorkMail organization under which the impersonation role will be assumed.</p>', 'CancelMailboxExportJobRequest$OrganizationId' => '<p>The organization ID.</p>', 'CreateAliasRequest$OrganizationId' => '<p>The organization under which the member (user or group) exists.</p>', 'CreateAvailabilityConfigurationRequest$OrganizationId' => '<p>The WorkMail organization for which the <code>AvailabilityConfiguration</code> will be created.</p>', 'CreateGroupRequest$OrganizationId' => '<p>The organization under which the group is to be created.</p>', 'CreateImpersonationRoleRequest$OrganizationId' => '<p>The WorkMail organization to create the new impersonation role within.</p>', 'CreateMobileDeviceAccessRuleRequest$OrganizationId' => '<p>The WorkMail organization under which the rule will be created.</p>', 'CreateOrganizationResponse$OrganizationId' => '<p>The organization ID.</p>', 'CreateResourceRequest$OrganizationId' => '<p>The identifier associated with the organization for which the resource is created.</p>', 'CreateUserRequest$OrganizationId' => '<p>The identifier of the organization for which the user is created.</p>', 'DeleteAccessControlRuleRequest$OrganizationId' => '<p>The identifier for the organization.</p>', 'DeleteAliasRequest$OrganizationId' => '<p>The identifier for the organization under which the user exists.</p>', 'DeleteAvailabilityConfigurationRequest$OrganizationId' => '<p>The WorkMail organization for which the <code>AvailabilityConfiguration</code> will be deleted.</p>', 'DeleteEmailMonitoringConfigurationRequest$OrganizationId' => '<p>The ID of the organization from which the email monitoring configuration is deleted.</p>', 'DeleteGroupRequest$OrganizationId' => '<p>The organization that contains the group.</p>', 'DeleteImpersonationRoleRequest$OrganizationId' => '<p>The WorkMail organization from which to delete the impersonation role.</p>', 'DeleteMailboxPermissionsRequest$OrganizationId' => '<p>The identifier of the organization under which the member (user or group) exists.</p>', 'DeleteMobileDeviceAccessOverrideRequest$OrganizationId' => '<p>The WorkMail organization for which the access override will be deleted.</p>', 'DeleteMobileDeviceAccessRuleRequest$OrganizationId' => '<p>The WorkMail organization under which the rule will be deleted.</p>', 'DeleteOrganizationRequest$OrganizationId' => '<p>The organization ID.</p>', 'DeleteOrganizationResponse$OrganizationId' => '<p>The organization ID.</p>', 'DeleteResourceRequest$OrganizationId' => '<p>The identifier associated with the organization from which the resource is deleted.</p>', 'DeleteRetentionPolicyRequest$OrganizationId' => '<p>The organization ID.</p>', 'DeleteUserRequest$OrganizationId' => '<p>The organization that contains the user to be deleted.</p>', 'DeregisterFromWorkMailRequest$OrganizationId' => '<p>The identifier for the organization under which the WorkMail entity exists.</p>', 'DeregisterMailDomainRequest$OrganizationId' => '<p>The WorkMail organization for which the domain will be deregistered.</p>', 'DescribeEmailMonitoringConfigurationRequest$OrganizationId' => '<p>The ID of the organization for which the email monitoring configuration is described.</p>', 'DescribeEntityRequest$OrganizationId' => '<p>The identifier for the organization under which the entity exists.</p>', 'DescribeGroupRequest$OrganizationId' => '<p>The identifier for the organization under which the group exists.</p>', 'DescribeInboundDmarcSettingsRequest$OrganizationId' => '<p>Lists the ID of the given organization.</p>', 'DescribeMailboxExportJobRequest$OrganizationId' => '<p>The organization ID.</p>', 'DescribeOrganizationRequest$OrganizationId' => '<p>The identifier for the organization to be described.</p>', 'DescribeOrganizationResponse$OrganizationId' => '<p>The identifier of an organization.</p>', 'DescribeResourceRequest$OrganizationId' => '<p>The identifier associated with the organization for which the resource is described.</p>', 'DescribeUserRequest$OrganizationId' => '<p>The identifier for the organization under which the user exists.</p>', 'DisassociateDelegateFromResourceRequest$OrganizationId' => '<p>The identifier for the organization under which the resource exists.</p>', 'DisassociateMemberFromGroupRequest$OrganizationId' => '<p>The identifier for the organization under which the group exists.</p>', 'GetAccessControlEffectRequest$OrganizationId' => '<p>The identifier for the organization.</p>', 'GetDefaultRetentionPolicyRequest$OrganizationId' => '<p>The organization ID.</p>', 'GetImpersonationRoleEffectRequest$OrganizationId' => '<p>The WorkMail organization where the impersonation role is defined.</p>', 'GetImpersonationRoleRequest$OrganizationId' => '<p>The WorkMail organization from which to retrieve the impersonation role.</p>', 'GetMailDomainRequest$OrganizationId' => '<p>The WorkMail organization for which the domain is retrieved.</p>', 'GetMailboxDetailsRequest$OrganizationId' => '<p>The identifier for the organization that contains the user whose mailbox details are being requested.</p>', 'GetMobileDeviceAccessEffectRequest$OrganizationId' => '<p>The WorkMail organization to simulate the access effect for.</p>', 'GetMobileDeviceAccessOverrideRequest$OrganizationId' => '<p>The WorkMail organization to which you want to apply the override.</p>', 'ListAccessControlRulesRequest$OrganizationId' => '<p>The identifier for the organization.</p>', 'ListAliasesRequest$OrganizationId' => '<p>The identifier for the organization under which the entity exists.</p>', 'ListAvailabilityConfigurationsRequest$OrganizationId' => '<p>The WorkMail organization for which the <code>AvailabilityConfiguration</code>\'s will be listed.</p>', 'ListGroupMembersRequest$OrganizationId' => '<p>The identifier for the organization under which the group exists.</p>', 'ListGroupsForEntityRequest$OrganizationId' => '<p>The identifier for the organization under which the entity exists.</p>', 'ListGroupsRequest$OrganizationId' => '<p>The identifier for the organization under which the groups exist.</p>', 'ListImpersonationRolesRequest$OrganizationId' => '<p>The WorkMail organization to which the listed impersonation roles belong.</p>', 'ListMailDomainsRequest$OrganizationId' => '<p>The WorkMail organization for which to list domains.</p>', 'ListMailboxExportJobsRequest$OrganizationId' => '<p>The organization ID.</p>', 'ListMailboxPermissionsRequest$OrganizationId' => '<p>The identifier of the organization under which the user, group, or resource exists.</p>', 'ListMobileDeviceAccessOverridesRequest$OrganizationId' => '<p>The WorkMail organization under which to list mobile device access overrides.</p>', 'ListMobileDeviceAccessRulesRequest$OrganizationId' => '<p>The WorkMail organization for which to list the rules.</p>', 'ListResourceDelegatesRequest$OrganizationId' => '<p>The identifier for the organization that contains the resource for which delegates are listed.</p>', 'ListResourcesRequest$OrganizationId' => '<p>The identifier for the organization under which the resources exist.</p>', 'ListUsersRequest$OrganizationId' => '<p>The identifier for the organization under which the users exist.</p>', 'OrganizationSummary$OrganizationId' => '<p>The identifier associated with the organization.</p>', 'PutAccessControlRuleRequest$OrganizationId' => '<p>The identifier of the organization.</p>', 'PutEmailMonitoringConfigurationRequest$OrganizationId' => '<p>The ID of the organization for which the email monitoring configuration is set.</p>', 'PutInboundDmarcSettingsRequest$OrganizationId' => '<p>The ID of the organization that you are applying the DMARC policy to.</p>', 'PutMailboxPermissionsRequest$OrganizationId' => '<p>The identifier of the organization under which the user, group, or resource exists.</p>', 'PutMobileDeviceAccessOverrideRequest$OrganizationId' => '<p>Identifies the WorkMail organization for which you create the override.</p>', 'PutRetentionPolicyRequest$OrganizationId' => '<p>The organization ID.</p>', 'RegisterMailDomainRequest$OrganizationId' => '<p>The WorkMail organization under which you\'re creating the domain.</p>', 'RegisterToWorkMailRequest$OrganizationId' => '<p>The identifier for the organization under which the user, group, or resource exists.</p>', 'ResetPasswordRequest$OrganizationId' => '<p>The identifier of the organization that contains the user for which the password is reset.</p>', 'StartMailboxExportJobRequest$OrganizationId' => '<p>The identifier associated with the organization.</p>', 'TestAvailabilityConfigurationRequest$OrganizationId' => '<p>The WorkMail organization where the availability provider will be tested.</p>', 'UpdateAvailabilityConfigurationRequest$OrganizationId' => '<p>The WorkMail organization for which the <code>AvailabilityConfiguration</code> will be updated.</p>', 'UpdateDefaultMailDomainRequest$OrganizationId' => '<p>The WorkMail organization for which to list domains.</p>', 'UpdateGroupRequest$OrganizationId' => '<p>The identifier for the organization under which the group exists.</p>', 'UpdateImpersonationRoleRequest$OrganizationId' => '<p>The WorkMail organization that contains the impersonation role to update.</p>', 'UpdateMailboxQuotaRequest$OrganizationId' => '<p>The identifier for the organization that contains the user for whom to update the mailbox quota.</p>', 'UpdateMobileDeviceAccessRuleRequest$OrganizationId' => '<p>The WorkMail organization under which the rule will be updated.</p>', 'UpdatePrimaryEmailAddressRequest$OrganizationId' => '<p>The organization that contains the user, group, or resource to update.</p>', 'UpdateResourceRequest$OrganizationId' => '<p>The identifier associated with the organization for which the resource is updated.</p>', 'UpdateUserRequest$OrganizationId' => '<p>The identifier for the organization under which the user exists.</p>', ], ], 'OrganizationName' => [ 'base' => NULL, 'refs' => [ 'CreateOrganizationRequest$Alias' => '<p>The organization alias.</p>', 'DescribeOrganizationResponse$Alias' => '<p>The alias for an organization.</p>', 'OrganizationSummary$Alias' => '<p>The alias associated with the organization.</p>', ], ], 'OrganizationNotFoundException' => [ 'base' => '<p>An operation received a valid organization identifier that either doesn\'t belong or exist in the system.</p>', 'refs' => [], ], 'OrganizationStateException' => [ 'base' => '<p>The organization must have a valid state to perform certain operations on the organization or its members.</p>', 'refs' => [], ], 'OrganizationSummaries' => [ 'base' => NULL, 'refs' => [ 'ListOrganizationsResponse$OrganizationSummaries' => '<p>The overview of owned organizations presented as a list of organization summaries.</p>', ], ], 'OrganizationSummary' => [ 'base' => '<p>The representation of an organization.</p>', 'refs' => [ 'OrganizationSummaries$member' => NULL, ], ], 'Password' => [ 'base' => NULL, 'refs' => [ 'CreateUserRequest$Password' => '<p>The password for the new user.</p>', 'EwsAvailabilityProvider$EwsPassword' => '<p>The password used to authenticate the remote EWS server.</p>', 'ResetPasswordRequest$Password' => '<p>The new password for the user.</p>', ], ], 'Percentage' => [ 'base' => NULL, 'refs' => [ 'DescribeMailboxExportJobResponse$EstimatedProgress' => '<p>The estimated progress of the mailbox export job, in percentage points.</p>', 'MailboxExportJob$EstimatedProgress' => '<p>The estimated progress of the mailbox export job, in percentage points.</p>', ], ], 'Permission' => [ 'base' => '<p>Permission granted to a user, group, or resource to access a certain aspect of another user, group, or resource mailbox.</p>', 'refs' => [ 'Permissions$member' => NULL, ], ], 'PermissionType' => [ 'base' => NULL, 'refs' => [ 'PermissionValues$member' => NULL, ], ], 'PermissionValues' => [ 'base' => NULL, 'refs' => [ 'Permission$PermissionValues' => '<p>The permissions granted to the grantee. SEND_AS allows the grantee to send email as the owner of the mailbox (the grantee is not mentioned on these emails). SEND_ON_BEHALF allows the grantee to send email on behalf of the owner of the mailbox (the grantee is not mentioned as the physical sender of these emails). FULL_ACCESS allows the grantee full access to the mailbox, irrespective of other folder-level permissions set on the mailbox.</p>', 'PutMailboxPermissionsRequest$PermissionValues' => '<p>The permissions granted to the grantee. SEND_AS allows the grantee to send email as the owner of the mailbox (the grantee is not mentioned on these emails). SEND_ON_BEHALF allows the grantee to send email on behalf of the owner of the mailbox (the grantee is not mentioned as the physical sender of these emails). FULL_ACCESS allows the grantee full access to the mailbox, irrespective of other folder-level permissions set on the mailbox.</p>', ], ], 'Permissions' => [ 'base' => NULL, 'refs' => [ 'ListMailboxPermissionsResponse$Permissions' => '<p>One page of the user, group, or resource mailbox permissions.</p>', ], ], 'PolicyDescription' => [ 'base' => NULL, 'refs' => [ 'PutRetentionPolicyRequest$Description' => '<p>The retention policy description.</p>', ], ], 'PutAccessControlRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutAccessControlRuleResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutEmailMonitoringConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutEmailMonitoringConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutInboundDmarcSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutInboundDmarcSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutMailboxPermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutMailboxPermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutMobileDeviceAccessOverrideRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutMobileDeviceAccessOverrideResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutRetentionPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutRetentionPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'RedactedEwsAvailabilityProvider' => [ 'base' => '<p>Describes an EWS based availability provider when returned from the service. It does not contain the password of the endpoint.</p>', 'refs' => [ 'AvailabilityConfiguration$EwsProvider' => '<p>If <code>ProviderType</code> is <code>EWS</code>, then this field contains <code>RedactedEwsAvailabilityProvider</code>. Otherwise, it is not required.</p>', ], ], 'RegisterMailDomainRequest' => [ 'base' => NULL, 'refs' => [], ], 'RegisterMailDomainResponse' => [ 'base' => NULL, 'refs' => [], ], 'RegisterToWorkMailRequest' => [ 'base' => NULL, 'refs' => [], ], 'RegisterToWorkMailResponse' => [ 'base' => NULL, 'refs' => [], ], 'ReservedNameException' => [ 'base' => '<p>This user, group, or resource name is not allowed in WorkMail.</p>', 'refs' => [], ], 'ResetPasswordRequest' => [ 'base' => NULL, 'refs' => [], ], 'ResetPasswordResponse' => [ 'base' => NULL, 'refs' => [], ], 'Resource' => [ 'base' => '<p>The representation of a resource.</p>', 'refs' => [ 'Resources$member' => NULL, ], ], 'ResourceDelegates' => [ 'base' => NULL, 'refs' => [ 'ListResourceDelegatesResponse$Delegates' => '<p>One page of the resource\'s delegates.</p>', ], ], 'ResourceDescription' => [ 'base' => NULL, 'refs' => [ 'CreateResourceRequest$Description' => '<p>Resource description.</p>', 'DescribeResourceResponse$Description' => '<p>Description of the resource.</p>', 'Resource$Description' => '<p>Resource description.</p>', ], ], 'ResourceId' => [ 'base' => NULL, 'refs' => [ 'CreateResourceResponse$ResourceId' => '<p>The identifier of the new resource.</p>', 'DescribeResourceResponse$ResourceId' => '<p>The identifier of the described resource.</p>', ], ], 'ResourceName' => [ 'base' => NULL, 'refs' => [ 'CreateResourceRequest$Name' => '<p>The name of the new resource.</p>', 'DescribeResourceResponse$Name' => '<p>The name of the described resource.</p>', 'Resource$Name' => '<p>The name of the resource.</p>', 'UpdateResourceRequest$Name' => '<p>The name of the resource to be updated.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The resource cannot be found.</p>', 'refs' => [], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'CreateResourceRequest$Type' => '<p>The type of the new resource. The available types are <code>equipment</code> and <code>room</code>.</p>', 'DescribeResourceResponse$Type' => '<p>The type of the described resource.</p>', 'Resource$Type' => '<p>The type of the resource: equipment or room.</p>', 'UpdateResourceRequest$Type' => '<p>Updates the resource type.</p>', ], ], 'Resources' => [ 'base' => NULL, 'refs' => [ 'ListResourcesResponse$Resources' => '<p>One page of the organization\'s resource representation.</p>', ], ], 'RetentionAction' => [ 'base' => NULL, 'refs' => [ 'FolderConfiguration$Action' => '<p>The action to take on the folder contents at the end of the folder configuration period.</p>', ], ], 'RetentionPeriod' => [ 'base' => NULL, 'refs' => [ 'FolderConfiguration$Period' => '<p>The number of days for which the folder-configuration action applies.</p>', ], ], 'RoleArn' => [ 'base' => NULL, 'refs' => [ 'DescribeEmailMonitoringConfigurationResponse$RoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM Role associated with the email monitoring configuration.</p>', 'DescribeMailboxExportJobResponse$RoleArn' => '<p>The ARN of the AWS Identity and Access Management (IAM) role that grants write permission to the Amazon Simple Storage Service (Amazon S3) bucket.</p>', 'PutEmailMonitoringConfigurationRequest$RoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM Role associated with the email monitoring configuration.</p>', 'StartMailboxExportJobRequest$RoleArn' => '<p>The ARN of the AWS Identity and Access Management (IAM) role that grants write permission to the S3 bucket.</p>', ], ], 'S3BucketName' => [ 'base' => NULL, 'refs' => [ 'DescribeMailboxExportJobResponse$S3BucketName' => '<p>The name of the S3 bucket.</p>', 'MailboxExportJob$S3BucketName' => '<p>The name of the S3 bucket.</p>', 'StartMailboxExportJobRequest$S3BucketName' => '<p>The name of the S3 bucket.</p>', ], ], 'S3ObjectKey' => [ 'base' => NULL, 'refs' => [ 'DescribeMailboxExportJobResponse$S3Prefix' => '<p>The S3 bucket prefix.</p>', 'DescribeMailboxExportJobResponse$S3Path' => '<p>The path to the S3 bucket and file that the mailbox export job is exporting to.</p>', 'MailboxExportJob$S3Path' => '<p>The path to the S3 bucket and file that the mailbox export job exports to.</p>', 'StartMailboxExportJobRequest$S3Prefix' => '<p>The S3 bucket prefix.</p>', ], ], 'ShortString' => [ 'base' => NULL, 'refs' => [ 'DeleteRetentionPolicyRequest$Id' => '<p>The retention policy ID.</p>', 'GetDefaultRetentionPolicyResponse$Id' => '<p>The retention policy ID.</p>', 'GetDefaultRetentionPolicyResponse$Name' => '<p>The retention policy name.</p>', 'PutRetentionPolicyRequest$Id' => '<p>The retention policy ID.</p>', 'PutRetentionPolicyRequest$Name' => '<p>The retention policy name.</p>', ], ], 'StartMailboxExportJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartMailboxExportJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'Delegate$Id' => '<p>The identifier for the user or group associated as the resource\'s delegate.</p>', 'DeleteOrganizationResponse$State' => '<p>The state of the organization.</p>', 'DescribeEntityResponse$Name' => '<p>Username, GroupName, or ResourceName based on entity type.</p>', 'DescribeOrganizationResponse$State' => '<p>The state of an organization.</p>', 'DescribeOrganizationResponse$DirectoryId' => '<p>The identifier for the directory associated with an WorkMail organization.</p>', 'DescribeOrganizationResponse$DirectoryType' => '<p>The type of directory associated with the WorkMail organization.</p>', 'DescribeOrganizationResponse$DefaultMailDomain' => '<p>The default mail domain associated with the organization.</p>', 'DescribeOrganizationResponse$ErrorMessage' => '<p>(Optional) The error message indicating if unexpected behavior was encountered with regards to the organization.</p>', 'DirectoryInUseException$Message' => NULL, 'DirectoryServiceAuthenticationFailedException$Message' => NULL, 'DirectoryUnavailableException$Message' => NULL, 'DnsRecord$Type' => '<p>The RFC 1035 record type. Possible values: <code>CNAME</code>, <code>A</code>, <code>MX</code>.</p>', 'DnsRecord$Hostname' => '<p>The DNS hostname.- For example, <code>domain.example.com</code>.</p>', 'DnsRecord$Value' => '<p>The value returned by the DNS for a query to that hostname and record type.</p>', 'EmailAddressInUseException$Message' => NULL, 'EntityAlreadyRegisteredException$Message' => NULL, 'EntityNotFoundException$Message' => NULL, 'EntityStateException$Message' => NULL, 'GetDefaultRetentionPolicyResponse$Description' => '<p>The retention policy description.</p>', 'InvalidConfigurationException$Message' => NULL, 'InvalidCustomSesConfigurationException$Message' => NULL, 'InvalidParameterException$Message' => NULL, 'InvalidPasswordException$Message' => NULL, 'LimitExceededException$Message' => NULL, 'ListGroupsFilters$NamePrefix' => '<p>Filters only groups with the provided name prefix.</p>', 'ListGroupsFilters$PrimaryEmailPrefix' => '<p>Filters only groups with the provided primary email prefix.</p>', 'ListGroupsForEntityFilters$GroupNamePrefix' => '<p>Filters only group names that start with the provided name prefix.</p>', 'ListResourcesFilters$NamePrefix' => '<p>Filters only resource that start with the entered name prefix .</p>', 'ListResourcesFilters$PrimaryEmailPrefix' => '<p>Filters only resource with the provided primary email prefix.</p>', 'ListUsersFilters$UsernamePrefix' => '<p>Filters only users with the provided username prefix.</p>', 'ListUsersFilters$PrimaryEmailPrefix' => '<p>Filters only users with the provided email prefix.</p>', 'MailDomainInUseException$Message' => NULL, 'MailDomainNotFoundException$Message' => NULL, 'MailDomainStateException$Message' => NULL, 'Member$Id' => '<p>The identifier of the member.</p>', 'Member$Name' => '<p>The name of the member.</p>', 'NameAvailabilityException$Message' => NULL, 'OrganizationNotFoundException$Message' => NULL, 'OrganizationStateException$Message' => NULL, 'OrganizationSummary$ErrorMessage' => '<p>The error message associated with the organization. It is only present if unexpected behavior has occurred with regards to the organization. It provides insight or solutions regarding unexpected behavior.</p>', 'OrganizationSummary$State' => '<p>The state associated with the organization.</p>', 'ReservedNameException$Message' => NULL, 'ResourceNotFoundException$Message' => NULL, 'TestAvailabilityConfigurationResponse$FailureReason' => '<p>String containing the reason for a failed test if <code>TestPassed</code> is false.</p>', 'TooManyTagsException$Message' => NULL, 'UnsupportedOperationException$Message' => NULL, 'User$DisplayName' => '<p>The display name of the user.</p>', ], ], 'Tag' => [ 'base' => '<p>Describes a tag applied to a resource.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>The key of the tag.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>The tag keys.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceResponse$Tags' => '<p>A list of tag key-value pairs.</p>', 'TagResourceRequest$Tags' => '<p>The tag key-value pairs.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The value of the tag.</p>', ], ], 'TargetUsers' => [ 'base' => NULL, 'refs' => [ 'ImpersonationRule$TargetUsers' => '<p>A list of user IDs that match the rule.</p>', 'ImpersonationRule$NotTargetUsers' => '<p>A list of user IDs that don\'t match the rule.</p>', ], ], 'TestAvailabilityConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'TestAvailabilityConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'AccessControlRule$DateCreated' => '<p>The date that the rule was created.</p>', 'AccessControlRule$DateModified' => '<p>The date that the rule was modified.</p>', 'AvailabilityConfiguration$DateCreated' => '<p>The date and time at which the availability configuration was created.</p>', 'AvailabilityConfiguration$DateModified' => '<p>The date and time at which the availability configuration was last modified.</p>', 'DescribeGroupResponse$EnabledDate' => '<p>The date and time when a user was registered to WorkMail, in UNIX epoch time format.</p>', 'DescribeGroupResponse$DisabledDate' => '<p>The date and time when a user was deregistered from WorkMail, in UNIX epoch time format.</p>', 'DescribeMailboxExportJobResponse$StartTime' => '<p>The mailbox export job start timestamp.</p>', 'DescribeMailboxExportJobResponse$EndTime' => '<p>The mailbox export job end timestamp.</p>', 'DescribeOrganizationResponse$CompletedDate' => '<p>The date at which the organization became usable in the WorkMail context, in UNIX epoch time format.</p>', 'DescribeResourceResponse$EnabledDate' => '<p>The date and time when a resource was enabled for WorkMail, in UNIX epoch time format.</p>', 'DescribeResourceResponse$DisabledDate' => '<p>The date and time when a resource was disabled from WorkMail, in UNIX epoch time format.</p>', 'DescribeUserResponse$EnabledDate' => '<p>The date and time at which the user was enabled for WorkMailusage, in UNIX epoch time format.</p>', 'DescribeUserResponse$DisabledDate' => '<p>The date and time at which the user was disabled for WorkMail usage, in UNIX epoch time format.</p>', 'DescribeUserResponse$MailboxProvisionedDate' => '<p>The date when the mailbox was created for the user.</p>', 'DescribeUserResponse$MailboxDeprovisionedDate' => '<p>The date when the mailbox was removed for the user.</p>', 'GetImpersonationRoleResponse$DateCreated' => '<p>The date when the impersonation role was created.</p>', 'GetImpersonationRoleResponse$DateModified' => '<p>The date when the impersonation role was last modified.</p>', 'GetMobileDeviceAccessOverrideResponse$DateCreated' => '<p>The date the override was first created.</p>', 'GetMobileDeviceAccessOverrideResponse$DateModified' => '<p>The date the description was last modified.</p>', 'Group$EnabledDate' => '<p>The date indicating when the group was enabled for WorkMail use.</p>', 'Group$DisabledDate' => '<p>The date indicating when the group was disabled from WorkMail use.</p>', 'ImpersonationRole$DateCreated' => '<p>The date when the impersonation role was created.</p>', 'ImpersonationRole$DateModified' => '<p>The date when the impersonation role was last modified.</p>', 'MailboxExportJob$StartTime' => '<p>The mailbox export job start timestamp.</p>', 'MailboxExportJob$EndTime' => '<p>The mailbox export job end timestamp.</p>', 'Member$EnabledDate' => '<p>The date indicating when the member was enabled for WorkMail use.</p>', 'Member$DisabledDate' => '<p>The date indicating when the member was disabled from WorkMail use.</p>', 'MobileDeviceAccessOverride$DateCreated' => '<p>The date the override was first created.</p>', 'MobileDeviceAccessOverride$DateModified' => '<p>The date the override was last modified.</p>', 'MobileDeviceAccessRule$DateCreated' => '<p>The date and time at which an access rule was created.</p>', 'MobileDeviceAccessRule$DateModified' => '<p>The date and time at which an access rule was modified.</p>', 'Resource$EnabledDate' => '<p>The date indicating when the resource was enabled for WorkMail use.</p>', 'Resource$DisabledDate' => '<p>The date indicating when the resource was disabled from WorkMail use.</p>', 'User$EnabledDate' => '<p>The date indicating when the user was enabled for WorkMail use.</p>', 'User$DisabledDate' => '<p>The date indicating when the user was disabled from WorkMail use.</p>', ], ], 'TooManyTagsException' => [ 'base' => '<p>The resource can have up to 50 user-applied tags.</p>', 'refs' => [], ], 'UnsupportedOperationException' => [ 'base' => '<p>You can\'t perform a write operation against a read-only directory.</p>', 'refs' => [], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAvailabilityConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAvailabilityConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDefaultMailDomainRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDefaultMailDomainResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateImpersonationRoleRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateImpersonationRoleResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMailboxQuotaRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMailboxQuotaResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMobileDeviceAccessRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMobileDeviceAccessRuleResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePrimaryEmailAddressRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePrimaryEmailAddressResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'Url' => [ 'base' => NULL, 'refs' => [ 'EwsAvailabilityProvider$EwsEndpoint' => '<p>The endpoint of the remote EWS server.</p>', 'RedactedEwsAvailabilityProvider$EwsEndpoint' => '<p>The endpoint of the remote EWS server.</p>', ], ], 'User' => [ 'base' => '<p>The representation of an WorkMail user.</p>', 'refs' => [ 'Users$member' => NULL, ], ], 'UserAttribute' => [ 'base' => NULL, 'refs' => [ 'CreateUserRequest$DisplayName' => '<p>The display name for the new user.</p>', 'CreateUserRequest$FirstName' => '<p>The first name of the new user.</p>', 'CreateUserRequest$LastName' => '<p>The last name of the new user. </p>', 'DescribeUserResponse$DisplayName' => '<p>The display name of the user.</p>', 'DescribeUserResponse$FirstName' => '<p>First name of the user.</p>', 'DescribeUserResponse$LastName' => '<p>Last name of the user.</p>', 'DescribeUserResponse$Initials' => '<p>Initials of the user.</p>', 'DescribeUserResponse$Telephone' => '<p>User\'s contact number.</p>', 'DescribeUserResponse$Street' => '<p>Street where the user is located.</p>', 'DescribeUserResponse$JobTitle' => '<p>Job title of the user.</p>', 'DescribeUserResponse$City' => '<p>City where the user is located.</p>', 'DescribeUserResponse$Company' => '<p>Company of the user.</p>', 'DescribeUserResponse$ZipCode' => '<p>Zip code of the user.</p>', 'DescribeUserResponse$Department' => '<p>Department of the user.</p>', 'DescribeUserResponse$Country' => '<p>Country where the user is located.</p>', 'DescribeUserResponse$Office' => '<p>Office where the user is located.</p>', 'ListUsersFilters$DisplayNamePrefix' => '<p>Filters only users with the provided display name prefix.</p>', 'UpdateUserRequest$DisplayName' => '<p>Updates the display name of the user.</p>', 'UpdateUserRequest$FirstName' => '<p>Updates the user\'s first name.</p>', 'UpdateUserRequest$LastName' => '<p>Updates the user\'s last name.</p>', 'UpdateUserRequest$Initials' => '<p>Updates the user\'s initials.</p>', 'UpdateUserRequest$Telephone' => '<p>Updates the user\'s contact details.</p>', 'UpdateUserRequest$Street' => '<p>Updates the user\'s street address.</p>', 'UpdateUserRequest$JobTitle' => '<p>Updates the user\'s job title.</p>', 'UpdateUserRequest$City' => '<p>Updates the user\'s city.</p>', 'UpdateUserRequest$Company' => '<p>Updates the user\'s company.</p>', 'UpdateUserRequest$ZipCode' => '<p>Updates the user\'s zipcode.</p>', 'UpdateUserRequest$Department' => '<p>Updates the user\'s department.</p>', 'UpdateUserRequest$Country' => '<p>Updates the user\'s country.</p>', 'UpdateUserRequest$Office' => '<p>Updates the user\'s office.</p>', ], ], 'UserIdList' => [ 'base' => NULL, 'refs' => [ 'AccessControlRule$UserIds' => '<p>User IDs to include in the rule.</p>', 'AccessControlRule$NotUserIds' => '<p>User IDs to exclude from the rule.</p>', 'PutAccessControlRuleRequest$UserIds' => '<p>User IDs to include in the rule.</p>', 'PutAccessControlRuleRequest$NotUserIds' => '<p>User IDs to exclude from the rule.</p>', ], ], 'UserName' => [ 'base' => NULL, 'refs' => [ 'CreateUserRequest$Name' => '<p>The name for the new user. WorkMail directory user names have a maximum length of 64. All others have a maximum length of 20.</p>', 'DescribeUserResponse$Name' => '<p>The name for the user.</p>', 'User$Name' => '<p>The name of the user.</p>', ], ], 'UserRole' => [ 'base' => NULL, 'refs' => [ 'CreateUserRequest$Role' => '<p>The role of the new user.</p> <p>You cannot pass <i>SYSTEM_USER</i> or <i>RESOURCE</i> role in a single request. When a user role is not selected, the default role of <i>USER</i> is selected.</p>', 'DescribeUserResponse$UserRole' => '<p>In certain cases, other entities are modeled as users. If interoperability is enabled, resources are imported into WorkMail as users. Because different WorkMail organizations rely on different directory types, administrators can distinguish between an unregistered user (account is disabled and has a user role) and the directory administrators. The values are USER, RESOURCE, SYSTEM_USER, and REMOTE_USER.</p>', 'UpdateUserRequest$Role' => '<p>Updates the user role.</p> <p>You cannot pass <i>SYSTEM_USER</i> or <i>RESOURCE</i>.</p>', 'User$UserRole' => '<p>The role of the user.</p>', ], ], 'Users' => [ 'base' => NULL, 'refs' => [ 'ListUsersResponse$Users' => '<p>The overview of users for an organization.</p>', ], ], 'WorkMailDomainName' => [ 'base' => NULL, 'refs' => [ 'DeregisterMailDomainRequest$DomainName' => '<p>The domain to deregister in WorkMail and SES.</p>', 'GetMailDomainRequest$DomainName' => '<p>The domain from which you want to retrieve details.</p>', 'RegisterMailDomainRequest$DomainName' => '<p>The name of the mail domain to create in WorkMail and SES.</p>', 'UpdateDefaultMailDomainRequest$DomainName' => '<p>The domain name that will become the default domain.</p>', ], ], 'WorkMailIdentifier' => [ 'base' => NULL, 'refs' => [ 'CreateAliasRequest$EntityId' => '<p>The member (user or group) to which this alias is added.</p>', 'CreateGroupResponse$GroupId' => '<p>The identifier of the group.</p>', 'CreateUserResponse$UserId' => '<p>The identifier for the new user.</p>', 'DeleteAliasRequest$EntityId' => '<p>The identifier for the member (user or group) from which to have the aliases removed.</p>', 'DescribeEntityResponse$EntityId' => '<p>The entity ID under which the entity exists.</p>', 'DescribeGroupResponse$GroupId' => '<p>The identifier of the described group.</p>', 'DescribeMailboxExportJobResponse$EntityId' => '<p>The identifier of the user or resource associated with the mailbox.</p>', 'DescribeOrganizationResponse$MigrationAdmin' => '<p>The user ID of the migration admin if migration is enabled for the organization.</p>', 'DescribeUserResponse$UserId' => '<p>The identifier for the described user.</p>', 'GetAccessControlEffectRequest$UserId' => '<p>The user ID.</p>', 'GetMobileDeviceAccessOverrideResponse$UserId' => '<p>The WorkMail user to which the access override applies.</p>', 'Group$Id' => '<p>The identifier of the group.</p>', 'GroupIdentifier$GroupId' => '<p>Group ID that matched the group.</p>', 'ListAliasesRequest$EntityId' => '<p>The identifier for the entity for which to list the aliases.</p>', 'MailboxExportJob$EntityId' => '<p>The identifier of the user or resource associated with the mailbox.</p>', 'MobileDeviceAccessOverride$UserId' => '<p>The WorkMail user to which the access override applies.</p>', 'Permission$GranteeId' => '<p>The identifier of the user, group, or resource to which the permissions are granted.</p>', 'ResetPasswordRequest$UserId' => '<p>The identifier of the user for whom the password is reset.</p>', 'Resource$Id' => '<p>The identifier of the resource.</p>', 'User$Id' => '<p>The identifier of the user.</p>', 'UserIdList$member' => NULL, ], ], ],];
