<?php
// This file was auto-generated from sdk-root/src/data/workspaces/2015-04-08/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Amazon WorkSpaces Service</fullname> <p>Amazon WorkSpaces enables you to provision virtual, cloud-based Microsoft Windows or Amazon Linux desktops for your users, known as <i>WorkSpaces</i>. WorkSpaces eliminates the need to procure and deploy hardware or install complex software. You can quickly add or remove users as your needs change. Users can access their virtual desktops from multiple devices or web browsers.</p> <p>This API Reference provides detailed information about the actions, data types, parameters, and errors of the WorkSpaces service. For more information about the supported Amazon Web Services Regions, endpoints, and service quotas of the Amazon WorkSpaces service, see <a href="https://docs.aws.amazon.com/general/latest/gr/wsp.html">WorkSpaces endpoints and quotas</a> in the <i>Amazon Web Services General Reference</i>.</p> <p>You can also manage your WorkSpaces resources using the WorkSpaces console, Command Line Interface (CLI), and SDKs. For more information about administering WorkSpaces, see the <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/">Amazon WorkSpaces Administration Guide</a>. For more information about using the Amazon WorkSpaces client application or web browser to access provisioned WorkSpaces, see the <a href="https://docs.aws.amazon.com/workspaces/latest/userguide/">Amazon WorkSpaces User Guide</a>. For more information about using the CLI to manage your WorkSpaces resources, see the <a href="https://docs.aws.amazon.com/cli/latest/reference/workspaces/index.html">WorkSpaces section of the CLI Reference</a>.</p>', 'operations' => [ 'AcceptAccountLinkInvitation' => '<p>Accepts the account link invitation.</p> <important> <p>There\'s currently no unlinking capability after you accept the account linking invitation.</p> </important>', 'AssociateConnectionAlias' => '<p>Associates the specified connection alias with the specified directory to enable cross-Region redirection. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region Redirection for Amazon WorkSpaces</a>.</p> <note> <p>Before performing this operation, call <a href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeConnectionAliases.html"> DescribeConnectionAliases</a> to make sure that the current state of the connection alias is <code>CREATED</code>.</p> </note>', 'AssociateIpGroups' => '<p>Associates the specified IP access control group with the specified directory.</p>', 'AssociateWorkspaceApplication' => '<p>Associates the specified application to the specified WorkSpace.</p>', 'AuthorizeIpRules' => '<p>Adds one or more rules to the specified IP access control group.</p> <p>This action gives users permission to access their WorkSpaces from the CIDR address ranges specified in the rules.</p>', 'CopyWorkspaceImage' => '<p>Copies the specified image from the specified Region to the current Region. For more information about copying images, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/copy-custom-image.html"> Copy a Custom WorkSpaces Image</a>.</p> <p>In the China (Ningxia) Region, you can copy images only within the same Region.</p> <p>In Amazon Web Services GovCloud (US), to copy images to and from other Regions, contact Amazon Web Services Support.</p> <important> <p>Before copying a shared image, be sure to verify that it has been shared from the correct Amazon Web Services account. To determine if an image has been shared and to see the ID of the Amazon Web Services account that owns an image, use the <a href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceImages.html">DescribeWorkSpaceImages</a> and <a href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceImagePermissions.html">DescribeWorkspaceImagePermissions</a> API operations. </p> </important>', 'CreateAccountLinkInvitation' => '<p>Creates the account link invitation.</p>', 'CreateConnectClientAddIn' => '<p>Creates a client-add-in for Amazon Connect within a directory. You can create only one Amazon Connect client add-in within a directory.</p> <p>This client add-in allows WorkSpaces users to seamlessly connect to Amazon Connect.</p>', 'CreateConnectionAlias' => '<p>Creates the specified connection alias for use with cross-Region redirection. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region Redirection for Amazon WorkSpaces</a>.</p>', 'CreateIpGroup' => '<p>Creates an IP access control group.</p> <p>An IP access control group provides you with the ability to control the IP addresses from which users are allowed to access their WorkSpaces. To specify the CIDR address ranges, add rules to your IP access control group and then associate the group with your directory. You can add rules when you create the group or at any time using <a>AuthorizeIpRules</a>.</p> <p>There is a default IP access control group associated with your directory. If you don\'t associate an IP access control group with your directory, the default group is used. The default group includes a default rule that allows users to access their WorkSpaces from anywhere. You cannot modify the default IP access control group for your directory.</p>', 'CreateStandbyWorkspaces' => '<p>Creates a standby WorkSpace in a secondary Region.</p>', 'CreateTags' => '<p>Creates the specified tags for the specified WorkSpaces resource.</p>', 'CreateUpdatedWorkspaceImage' => '<p>Creates a new updated WorkSpace image based on the specified source image. The new updated WorkSpace image has the latest drivers and other updates required by the Amazon WorkSpaces components.</p> <p>To determine which WorkSpace images need to be updated with the latest Amazon WorkSpaces requirements, use <a href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceImages.html"> DescribeWorkspaceImages</a>.</p> <note> <ul> <li> <p>Only Windows 10, Windows Server 2016, and Windows Server 2019 WorkSpace images can be programmatically updated at this time.</p> </li> <li> <p>Microsoft Windows updates and other application updates are not included in the update process.</p> </li> <li> <p>The source WorkSpace image is not deleted. You can delete the source image after you\'ve verified your new updated image and created a new bundle. </p> </li> </ul> </note>', 'CreateWorkspaceBundle' => '<p>Creates the specified WorkSpace bundle. For more information about creating WorkSpace bundles, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/create-custom-bundle.html"> Create a Custom WorkSpaces Image and Bundle</a>.</p>', 'CreateWorkspaceImage' => '<p>Creates a new WorkSpace image from an existing WorkSpace.</p>', 'CreateWorkspaces' => '<p>Creates one or more WorkSpaces.</p> <p>This operation is asynchronous and returns before the WorkSpaces are created.</p> <note> <ul> <li> <p>The <code>MANUAL</code> running mode value is only supported by Amazon WorkSpaces Core. Contact your account team to be allow-listed to use this value. For more information, see <a href="http://aws.amazon.com/workspaces/core/">Amazon WorkSpaces Core</a>.</p> </li> <li> <p>You don\'t need to specify the <code>PCOIP</code> protocol for Linux bundles because <code>WSP</code> is the default protocol for those bundles.</p> </li> <li> <p>User-decoupled WorkSpaces are only supported by Amazon WorkSpaces Core.</p> </li> </ul> </note>', 'CreateWorkspacesPool' => '<p>Creates a pool of WorkSpaces.</p>', 'DeleteAccountLinkInvitation' => '<p>Deletes the account link invitation.</p>', 'DeleteClientBranding' => '<p>Deletes customized client branding. Client branding allows you to customize your WorkSpace\'s client login portal. You can tailor your login portal company logo, the support email address, support link, link to reset password, and a custom message for users trying to sign in.</p> <p>After you delete your customized client branding, your login portal reverts to the default client branding.</p>', 'DeleteConnectClientAddIn' => '<p>Deletes a client-add-in for Amazon Connect that is configured within a directory.</p>', 'DeleteConnectionAlias' => '<p>Deletes the specified connection alias. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region Redirection for Amazon WorkSpaces</a>.</p> <important> <p> <b>If you will no longer be using a fully qualified domain name (FQDN) as the registration code for your WorkSpaces users, you must take certain precautions to prevent potential security issues.</b> For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html#cross-region-redirection-security-considerations"> Security Considerations if You Stop Using Cross-Region Redirection</a>.</p> </important> <note> <p>To delete a connection alias that has been shared, the shared account must first disassociate the connection alias from any directories it has been associated with. Then you must unshare the connection alias from the account it has been shared with. You can delete a connection alias only after it is no longer shared with any accounts or associated with any directories.</p> </note>', 'DeleteIpGroup' => '<p>Deletes the specified IP access control group.</p> <p>You cannot delete an IP access control group that is associated with a directory.</p>', 'DeleteTags' => '<p>Deletes the specified tags from the specified WorkSpaces resource.</p>', 'DeleteWorkspaceBundle' => '<p>Deletes the specified WorkSpace bundle. For more information about deleting WorkSpace bundles, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/delete_bundle.html"> Delete a Custom WorkSpaces Bundle or Image</a>.</p>', 'DeleteWorkspaceImage' => '<p>Deletes the specified image from your account. To delete an image, you must first delete any bundles that are associated with the image and unshare the image if it is shared with other accounts. </p>', 'DeployWorkspaceApplications' => '<p>Deploys associated applications to the specified WorkSpace</p>', 'DeregisterWorkspaceDirectory' => '<p>Deregisters the specified directory. This operation is asynchronous and returns before the WorkSpace directory is deregistered. If any WorkSpaces are registered to this directory, you must remove them before you can deregister the directory.</p> <note> <p>Simple AD and AD Connector are made available to you free of charge to use with WorkSpaces. If there are no WorkSpaces being used with your Simple AD or AD Connector directory for 30 consecutive days, this directory will be automatically deregistered for use with Amazon WorkSpaces, and you will be charged for this directory as per the <a href="http://aws.amazon.com/directoryservice/pricing/">Directory Service pricing terms</a>.</p> <p>To delete empty directories, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/delete-workspaces-directory.html"> Delete the Directory for Your WorkSpaces</a>. If you delete your Simple AD or AD Connector directory, you can always create a new one when you want to start using WorkSpaces again.</p> </note>', 'DescribeAccount' => '<p>Retrieves a list that describes the configuration of Bring Your Own License (BYOL) for the specified account.</p>', 'DescribeAccountModifications' => '<p>Retrieves a list that describes modifications to the configuration of Bring Your Own License (BYOL) for the specified account.</p>', 'DescribeApplicationAssociations' => '<p>Describes the associations between the application and the specified associated resources.</p>', 'DescribeApplications' => '<p>Describes the specified applications by filtering based on their compute types, license availability, operating systems, and owners.</p>', 'DescribeBundleAssociations' => '<p>Describes the associations between the applications and the specified bundle.</p>', 'DescribeClientBranding' => '<p>Describes the specified client branding. Client branding allows you to customize the log in page of various device types for your users. You can add your company logo, the support email address, support link, link to reset password, and a custom message for users trying to sign in.</p> <note> <p>Only device types that have branding information configured will be shown in the response.</p> </note>', 'DescribeClientProperties' => '<p>Retrieves a list that describes one or more specified Amazon WorkSpaces clients.</p>', 'DescribeConnectClientAddIns' => '<p>Retrieves a list of Amazon Connect client add-ins that have been created.</p>', 'DescribeConnectionAliasPermissions' => '<p>Describes the permissions that the owner of a connection alias has granted to another Amazon Web Services account for the specified connection alias. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region Redirection for Amazon WorkSpaces</a>.</p>', 'DescribeConnectionAliases' => '<p>Retrieves a list that describes the connection aliases used for cross-Region redirection. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region Redirection for Amazon WorkSpaces</a>.</p>', 'DescribeImageAssociations' => '<p>Describes the associations between the applications and the specified image.</p>', 'DescribeIpGroups' => '<p>Describes one or more of your IP access control groups.</p>', 'DescribeTags' => '<p>Describes the specified tags for the specified WorkSpaces resource.</p>', 'DescribeWorkspaceAssociations' => '<p>Describes the associations betweens applications and the specified WorkSpace.</p>', 'DescribeWorkspaceBundles' => '<p>Retrieves a list that describes the available WorkSpace bundles.</p> <p>You can filter the results using either bundle ID or owner, but not both.</p>', 'DescribeWorkspaceDirectories' => '<p>Describes the available directories that are registered with Amazon WorkSpaces.</p>', 'DescribeWorkspaceImagePermissions' => '<p>Describes the permissions that the owner of an image has granted to other Amazon Web Services accounts for an image.</p>', 'DescribeWorkspaceImages' => '<p>Retrieves a list that describes one or more specified images, if the image identifiers are provided. Otherwise, all images in the account are described. </p>', 'DescribeWorkspaceSnapshots' => '<p>Describes the snapshots for the specified WorkSpace.</p>', 'DescribeWorkspaces' => '<p>Describes the specified WorkSpaces.</p> <p>You can filter the results by using the bundle identifier, directory identifier, or owner, but you can specify only one filter at a time.</p>', 'DescribeWorkspacesConnectionStatus' => '<p>Describes the connection status of the specified WorkSpaces.</p>', 'DescribeWorkspacesPoolSessions' => '<p>Retrieves a list that describes the streaming sessions for a specified pool.</p>', 'DescribeWorkspacesPools' => '<p>Describes the specified WorkSpaces Pools.</p>', 'DisassociateConnectionAlias' => '<p>Disassociates a connection alias from a directory. Disassociating a connection alias disables cross-Region redirection between two directories in different Regions. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region Redirection for Amazon WorkSpaces</a>.</p> <note> <p>Before performing this operation, call <a href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeConnectionAliases.html"> DescribeConnectionAliases</a> to make sure that the current state of the connection alias is <code>CREATED</code>.</p> </note>', 'DisassociateIpGroups' => '<p>Disassociates the specified IP access control group from the specified directory.</p>', 'DisassociateWorkspaceApplication' => '<p>Disassociates the specified application from a WorkSpace.</p>', 'GetAccountLink' => '<p>Retrieves account link information.</p>', 'ImportClientBranding' => '<p>Imports client branding. Client branding allows you to customize your WorkSpace\'s client login portal. You can tailor your login portal company logo, the support email address, support link, link to reset password, and a custom message for users trying to sign in.</p> <p>After you import client branding, the default branding experience for the specified platform type is replaced with the imported experience</p> <note> <ul> <li> <p>You must specify at least one platform type when importing client branding.</p> </li> <li> <p>You can import up to 6 MB of data with each request. If your request exceeds this limit, you can import client branding for different platform types using separate requests.</p> </li> <li> <p>In each platform type, the <code>SupportEmail</code> and <code>SupportLink</code> parameters are mutually exclusive. You can specify only one parameter for each platform type, but not both.</p> </li> <li> <p>Imported data can take up to a minute to appear in the WorkSpaces client.</p> </li> </ul> </note>', 'ImportWorkspaceImage' => '<p>Imports the specified Windows 10 or 11 Bring Your Own License (BYOL) image into Amazon WorkSpaces. The image must be an already licensed Amazon EC2 image that is in your Amazon Web Services account, and you must own the image. For more information about creating BYOL images, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html"> Bring Your Own Windows Desktop Licenses</a>.</p>', 'ListAccountLinks' => '<p>Lists all account links.</p>', 'ListAvailableManagementCidrRanges' => '<p>Retrieves a list of IP address ranges, specified as IPv4 CIDR blocks, that you can use for the network management interface when you enable Bring Your Own License (BYOL). </p> <p>This operation can be run only by Amazon Web Services accounts that are enabled for BYOL. If your account isn\'t enabled for BYOL, you\'ll receive an <code>AccessDeniedException</code> error.</p> <p>The management network interface is connected to a secure Amazon WorkSpaces management network. It is used for interactive streaming of the WorkSpace desktop to Amazon WorkSpaces clients, and to allow Amazon WorkSpaces to manage the WorkSpace.</p>', 'MigrateWorkspace' => '<p>Migrates a WorkSpace from one operating system or bundle type to another, while retaining the data on the user volume.</p> <p>The migration process recreates the WorkSpace by using a new root volume from the target bundle image and the user volume from the last available snapshot of the original WorkSpace. During migration, the original <code>D:\\Users\\%USERNAME%</code> user profile folder is renamed to <code>D:\\Users\\%USERNAME%MMddyyTHHmmss%.NotMigrated</code>. A new <code>D:\\Users\\%USERNAME%\\</code> folder is generated by the new OS. Certain files in the old user profile are moved to the new user profile.</p> <p>For available migration scenarios, details about what happens during migration, and best practices, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/migrate-workspaces.html">Migrate a WorkSpace</a>.</p>', 'ModifyAccount' => '<p>Modifies the configuration of Bring Your Own License (BYOL) for the specified account.</p>', 'ModifyCertificateBasedAuthProperties' => '<p>Modifies the properties of the certificate-based authentication you want to use with your WorkSpaces.</p>', 'ModifyClientProperties' => '<p>Modifies the properties of the specified Amazon WorkSpaces clients.</p>', 'ModifySamlProperties' => '<p>Modifies multiple properties related to SAML 2.0 authentication, including the enablement status, user access URL, and relay state parameter name that are used for configuring federation with an SAML 2.0 identity provider.</p>', 'ModifySelfservicePermissions' => '<p>Modifies the self-service WorkSpace management capabilities for your users. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/enable-user-self-service-workspace-management.html">Enable Self-Service WorkSpace Management Capabilities for Your Users</a>.</p>', 'ModifyStreamingProperties' => '<p>Modifies the specified streaming properties.</p>', 'ModifyWorkspaceAccessProperties' => '<p>Specifies which devices and operating systems users can use to access their WorkSpaces. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/update-directory-details.html#control-device-access"> Control Device Access</a>.</p>', 'ModifyWorkspaceCreationProperties' => '<p>Modify the default properties used to create WorkSpaces.</p>', 'ModifyWorkspaceProperties' => '<p>Modifies the specified WorkSpace properties. For important information about how to modify the size of the root and user volumes, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/modify-workspaces.html"> Modify a WorkSpace</a>. </p> <note> <p>The <code>MANUAL</code> running mode value is only supported by Amazon WorkSpaces Core. Contact your account team to be allow-listed to use this value. For more information, see <a href="http://aws.amazon.com/workspaces/core/">Amazon WorkSpaces Core</a>.</p> </note>', 'ModifyWorkspaceState' => '<p>Sets the state of the specified WorkSpace.</p> <p>To maintain a WorkSpace without being interrupted, set the WorkSpace state to <code>ADMIN_MAINTENANCE</code>. WorkSpaces in this state do not respond to requests to reboot, stop, start, rebuild, or restore. An AutoStop WorkSpace in this state is not stopped. Users cannot log into a WorkSpace in the <code>ADMIN_MAINTENANCE</code> state.</p>', 'RebootWorkspaces' => '<p>Reboots the specified WorkSpaces.</p> <p>You cannot reboot a WorkSpace unless its state is <code>AVAILABLE</code>, <code>UNHEALTHY</code>, or <code>REBOOTING</code>. Reboot a WorkSpace in the <code>REBOOTING</code> state only if your WorkSpace has been stuck in the <code>REBOOTING</code> state for over 20 minutes.</p> <p>This operation is asynchronous and returns before the WorkSpaces have rebooted.</p>', 'RebuildWorkspaces' => '<p>Rebuilds the specified WorkSpace.</p> <p>You cannot rebuild a WorkSpace unless its state is <code>AVAILABLE</code>, <code>ERROR</code>, <code>UNHEALTHY</code>, <code>STOPPED</code>, or <code>REBOOTING</code>.</p> <p>Rebuilding a WorkSpace is a potentially destructive action that can result in the loss of data. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/reset-workspace.html">Rebuild a WorkSpace</a>.</p> <p>This operation is asynchronous and returns before the WorkSpaces have been completely rebuilt.</p>', 'RegisterWorkspaceDirectory' => '<p>Registers the specified directory. This operation is asynchronous and returns before the WorkSpace directory is registered. If this is the first time you are registering a directory, you will need to create the workspaces_DefaultRole role before you can register a directory. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/workspaces-access-control.html#create-default-role"> Creating the workspaces_DefaultRole Role</a>.</p>', 'RejectAccountLinkInvitation' => '<p>Rejects the account link invitation.</p>', 'RestoreWorkspace' => '<p>Restores the specified WorkSpace to its last known healthy state.</p> <p>You cannot restore a WorkSpace unless its state is <code> AVAILABLE</code>, <code>ERROR</code>, <code>UNHEALTHY</code>, or <code>STOPPED</code>.</p> <p>Restoring a WorkSpace is a potentially destructive action that can result in the loss of data. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/restore-workspace.html">Restore a WorkSpace</a>.</p> <p>This operation is asynchronous and returns before the WorkSpace is completely restored.</p>', 'RevokeIpRules' => '<p>Removes one or more rules from the specified IP access control group.</p>', 'StartWorkspaces' => '<p>Starts the specified WorkSpaces.</p> <p>You cannot start a WorkSpace unless it has a running mode of <code>AutoStop</code> and a state of <code>STOPPED</code>.</p>', 'StartWorkspacesPool' => '<p>Starts the specified pool.</p> <p>You cannot start a pool unless it has a running mode of <code>AutoStop</code> and a state of <code>STOPPED</code>.</p>', 'StopWorkspaces' => '<p> Stops the specified WorkSpaces.</p> <p>You cannot stop a WorkSpace unless it has a running mode of <code>AutoStop</code> and a state of <code>AVAILABLE</code>, <code>IMPAIRED</code>, <code>UNHEALTHY</code>, or <code>ERROR</code>.</p>', 'StopWorkspacesPool' => '<p>Stops the specified pool.</p> <p>You cannot stop a WorkSpace pool unless it has a running mode of <code>AutoStop</code> and a state of <code>AVAILABLE</code>, <code>IMPAIRED</code>, <code>UNHEALTHY</code>, or <code>ERROR</code>.</p>', 'TerminateWorkspaces' => '<p>Terminates the specified WorkSpaces.</p> <important> <p>Terminating a WorkSpace is a permanent action and cannot be undone. The user\'s data is destroyed. If you need to archive any user data, contact Amazon Web Services Support before terminating the WorkSpace.</p> </important> <p>You can terminate a WorkSpace that is in any state except <code>SUSPENDED</code>.</p> <p>This operation is asynchronous and returns before the WorkSpaces have been completely terminated. After a WorkSpace is terminated, the <code>TERMINATED</code> state is returned only briefly before the WorkSpace directory metadata is cleaned up, so this state is rarely returned. To confirm that a WorkSpace is terminated, check for the WorkSpace ID by using <a href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaces.html"> DescribeWorkSpaces</a>. If the WorkSpace ID isn\'t returned, then the WorkSpace has been successfully terminated.</p> <note> <p>Simple AD and AD Connector are made available to you free of charge to use with WorkSpaces. If there are no WorkSpaces being used with your Simple AD or AD Connector directory for 30 consecutive days, this directory will be automatically deregistered for use with Amazon WorkSpaces, and you will be charged for this directory as per the <a href="http://aws.amazon.com/directoryservice/pricing/">Directory Service pricing terms</a>.</p> <p>To delete empty directories, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/delete-workspaces-directory.html"> Delete the Directory for Your WorkSpaces</a>. If you delete your Simple AD or AD Connector directory, you can always create a new one when you want to start using WorkSpaces again.</p> </note>', 'TerminateWorkspacesPool' => '<p>Terminates the specified pool.</p>', 'TerminateWorkspacesPoolSession' => '<p>Terminates the pool session.</p>', 'UpdateConnectClientAddIn' => '<p>Updates a Amazon Connect client add-in. Use this action to update the name and endpoint URL of a Amazon Connect client add-in.</p>', 'UpdateConnectionAliasPermission' => '<p>Shares or unshares a connection alias with one account by specifying whether that account has permission to associate the connection alias with a directory. If the association permission is granted, the connection alias is shared with that account. If the association permission is revoked, the connection alias is unshared with the account. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region Redirection for Amazon WorkSpaces</a>.</p> <note> <ul> <li> <p>Before performing this operation, call <a href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeConnectionAliases.html"> DescribeConnectionAliases</a> to make sure that the current state of the connection alias is <code>CREATED</code>.</p> </li> <li> <p>To delete a connection alias that has been shared, the shared account must first disassociate the connection alias from any directories it has been associated with. Then you must unshare the connection alias from the account it has been shared with. You can delete a connection alias only after it is no longer shared with any accounts or associated with any directories.</p> </li> </ul> </note>', 'UpdateRulesOfIpGroup' => '<p>Replaces the current rules of the specified IP access control group with the specified rules.</p>', 'UpdateWorkspaceBundle' => '<p>Updates a WorkSpace bundle with a new image. For more information about updating WorkSpace bundles, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/update-custom-bundle.html"> Update a Custom WorkSpaces Bundle</a>.</p> <important> <p>Existing WorkSpaces aren\'t automatically updated when you update the bundle that they\'re based on. To update existing WorkSpaces that are based on a bundle that you\'ve updated, you must either rebuild the WorkSpaces or delete and recreate them.</p> </important>', 'UpdateWorkspaceImagePermission' => '<p>Shares or unshares an image with one account in the same Amazon Web Services Region by specifying whether that account has permission to copy the image. If the copy image permission is granted, the image is shared with that account. If the copy image permission is revoked, the image is unshared with the account.</p> <p>After an image has been shared, the recipient account can copy the image to other Regions as needed.</p> <p>In the China (Ningxia) Region, you can copy images only within the same Region.</p> <p>In Amazon Web Services GovCloud (US), to copy images to and from other Regions, contact Amazon Web Services Support.</p> <p>For more information about sharing images, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/share-custom-image.html"> Share or Unshare a Custom WorkSpaces Image</a>.</p> <note> <ul> <li> <p>To delete an image that has been shared, you must unshare the image before you delete it.</p> </li> <li> <p>Sharing Bring Your Own License (BYOL) images across Amazon Web Services accounts isn\'t supported at this time in Amazon Web Services GovCloud (US). To share BYOL images across accounts in Amazon Web Services GovCloud (US), contact Amazon Web Services Support.</p> </li> </ul> </note>', 'UpdateWorkspacesPool' => '<p>Updates the specified pool.</p>', ], 'shapes' => [ 'ARN' => [ 'base' => NULL, 'refs' => [ 'DefaultWorkspaceCreationProperties$InstanceIamRoleArn' => '<p>Indicates the IAM role ARN of the instance.</p>', 'WorkspaceCreationProperties$InstanceIamRoleArn' => '<p>Indicates the IAM role ARN of the instance.</p>', 'WorkspaceDirectory$IamRoleId' => '<p>The identifier of the IAM role. This is the role that allows Amazon WorkSpaces to make calls to other services, such as Amazon EC2, on your behalf.</p>', 'WorkspacesPool$PoolArn' => '<p>The Amazon Resource Name (ARN) for the pool.</p>', ], ], 'AcceptAccountLinkInvitationRequest' => [ 'base' => NULL, 'refs' => [], ], 'AcceptAccountLinkInvitationResult' => [ 'base' => NULL, 'refs' => [], ], 'AccessDeniedException' => [ 'base' => '<p>The user is not authorized to access a resource.</p>', 'refs' => [], ], 'AccessPropertyValue' => [ 'base' => NULL, 'refs' => [ 'WorkspaceAccessProperties$DeviceTypeWindows' => '<p>Indicates whether users can use Windows clients to access their WorkSpaces.</p>', 'WorkspaceAccessProperties$DeviceTypeOsx' => '<p>Indicates whether users can use macOS clients to access their WorkSpaces.</p>', 'WorkspaceAccessProperties$DeviceTypeWeb' => '<p>Indicates whether users can access their WorkSpaces through a web browser.</p>', 'WorkspaceAccessProperties$DeviceTypeIos' => '<p>Indicates whether users can use iOS devices to access their WorkSpaces.</p>', 'WorkspaceAccessProperties$DeviceTypeAndroid' => '<p>Indicates whether users can use Android and Android-compatible Chrome OS devices to access their WorkSpaces.</p>', 'WorkspaceAccessProperties$DeviceTypeChromeOs' => '<p>Indicates whether users can use Chromebooks to access their WorkSpaces.</p>', 'WorkspaceAccessProperties$DeviceTypeZeroClient' => '<p>Indicates whether users can use zero client devices to access their WorkSpaces.</p>', 'WorkspaceAccessProperties$DeviceTypeLinux' => '<p>Indicates whether users can use Linux clients to access their WorkSpaces.</p>', ], ], 'AccountLink' => [ 'base' => '<p>Information about about the account link.</p>', 'refs' => [ 'AcceptAccountLinkInvitationResult$AccountLink' => '<p>Information about the account link.</p>', 'AccountLinkList$member' => NULL, 'CreateAccountLinkInvitationResult$AccountLink' => '<p>Information about the account link.</p>', 'DeleteAccountLinkInvitationResult$AccountLink' => '<p>Information about the account link.</p>', 'GetAccountLinkResult$AccountLink' => '<p>The account link of the account link to retrieve.</p>', 'RejectAccountLinkInvitationResult$AccountLink' => '<p>Information about the account link.</p>', ], ], 'AccountLinkList' => [ 'base' => NULL, 'refs' => [ 'ListAccountLinksResult$AccountLinks' => '<p>Information about the account links.</p>', ], ], 'AccountLinkStatusEnum' => [ 'base' => NULL, 'refs' => [ 'AccountLink$AccountLinkStatus' => '<p>The status of the account link.</p>', 'LinkStatusFilterList$member' => NULL, ], ], 'AccountModification' => [ 'base' => '<p>Describes a modification to the configuration of Bring Your Own License (BYOL) for the specified account. </p>', 'refs' => [ 'AccountModificationList$member' => NULL, ], ], 'AccountModificationList' => [ 'base' => NULL, 'refs' => [ 'DescribeAccountModificationsResult$AccountModifications' => '<p>The list of modifications to the configuration of BYOL.</p>', ], ], 'ActiveDirectoryConfig' => [ 'base' => '<p>Information about the Active Directory config.</p>', 'refs' => [ 'RegisterWorkspaceDirectoryRequest$ActiveDirectoryConfig' => '<p>The active directory config of the directory.</p>', 'WorkspaceDirectory$ActiveDirectoryConfig' => '<p>Information about the Active Directory config.</p>', ], ], 'ActiveUserSessions' => [ 'base' => NULL, 'refs' => [ 'CapacityStatus$ActiveUserSessions' => '<p>The number of user sessions currently being used for pool sessions. This only applies to multi-session pools.</p>', ], ], 'ActualUserSessions' => [ 'base' => NULL, 'refs' => [ 'CapacityStatus$ActualUserSessions' => '<p>The total number of session slots that are available for a pool of WorkSpaces.</p>', ], ], 'AddInName' => [ 'base' => NULL, 'refs' => [ 'ConnectClientAddIn$Name' => '<p>The name of the client add in.</p>', 'CreateConnectClientAddInRequest$Name' => '<p>The name of the client add-in.</p>', 'UpdateConnectClientAddInRequest$Name' => '<p>The name of the client add-in.</p>', ], ], 'AddInUrl' => [ 'base' => NULL, 'refs' => [ 'ConnectClientAddIn$URL' => '<p>The endpoint URL of the client add-in.</p>', 'CreateConnectClientAddInRequest$URL' => '<p>The endpoint URL of the Amazon Connect client add-in.</p>', 'UpdateConnectClientAddInRequest$URL' => '<p>The endpoint URL of the Amazon Connect client add-in.</p>', ], ], 'Alias' => [ 'base' => NULL, 'refs' => [ 'WorkspaceDirectory$Alias' => '<p>The directory alias.</p>', ], ], 'AmazonUuid' => [ 'base' => NULL, 'refs' => [ 'ConnectClientAddIn$AddInId' => '<p>The client add-in identifier.</p>', 'CreateConnectClientAddInResult$AddInId' => '<p>The client add-in identifier.</p>', 'DeleteConnectClientAddInRequest$AddInId' => '<p>The identifier of the client add-in to delete.</p>', 'TerminateWorkspacesPoolSessionRequest$SessionId' => '<p>The identifier of the pool session.</p>', 'UpdateConnectClientAddInRequest$AddInId' => '<p>The identifier of the client add-in to update.</p>', 'WorkspacesPoolSession$SessionId' => '<p>The identifier of the session.</p>', ], ], 'Application' => [ 'base' => NULL, 'refs' => [ 'ApplicationList$member' => NULL, ], ], 'ApplicationAssociatedResourceType' => [ 'base' => NULL, 'refs' => [ 'ApplicationAssociatedResourceTypeList$member' => NULL, 'ApplicationResourceAssociation$AssociatedResourceType' => '<p>The resource type of the associated resource.</p>', ], ], 'ApplicationAssociatedResourceTypeList' => [ 'base' => NULL, 'refs' => [ 'DescribeApplicationAssociationsRequest$AssociatedResourceTypes' => '<p>The resource type of the associated resources.</p>', ], ], 'ApplicationList' => [ 'base' => NULL, 'refs' => [ 'ImportWorkspaceImageRequest$Applications' => '<p>If specified, the version of Microsoft Office to subscribe to. Valid only for Windows 10 and 11 BYOL images. For more information about subscribing to Office for BYOL images, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html"> Bring Your Own Windows Desktop Licenses</a>.</p> <note> <ul> <li> <p>Although this parameter is an array, only one item is allowed at this time.</p> </li> <li> <p>Windows 11 only supports <code>Microsoft_Office_2019</code>.</p> </li> </ul> </note>', ], ], 'ApplicationNotSupportedException' => [ 'base' => '<p>The specified application is not supported.</p>', 'refs' => [], ], 'ApplicationResourceAssociation' => [ 'base' => '<p>Describes the association between an application and an application resource.</p>', 'refs' => [ 'ApplicationResourceAssociationList$member' => NULL, ], ], 'ApplicationResourceAssociationList' => [ 'base' => NULL, 'refs' => [ 'DescribeApplicationAssociationsResult$Associations' => '<p>List of associations and information about them.</p>', ], ], 'ApplicationSettingsRequest' => [ 'base' => '<p>The persistent application settings for WorkSpaces Pools users.</p>', 'refs' => [ 'CreateWorkspacesPoolRequest$ApplicationSettings' => '<p>Indicates the application settings of the pool.</p>', 'UpdateWorkspacesPoolRequest$ApplicationSettings' => '<p>The persistent application settings for users in the pool.</p>', ], ], 'ApplicationSettingsResponse' => [ 'base' => '<p>Describes the persistent application settings for WorkSpaces Pools users.</p>', 'refs' => [ 'WorkspacesPool$ApplicationSettings' => '<p>The persistent application settings for users of the pool.</p>', ], ], 'ApplicationSettingsStatusEnum' => [ 'base' => NULL, 'refs' => [ 'ApplicationSettingsRequest$Status' => '<p>Enables or disables persistent application settings for users during their pool sessions.</p>', 'ApplicationSettingsResponse$Status' => '<p>Specifies whether persistent application settings are enabled for users during their pool sessions.</p>', ], ], 'AssociateConnectionAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateConnectionAliasResult' => [ 'base' => NULL, 'refs' => [], ], 'AssociateIpGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateIpGroupsResult' => [ 'base' => NULL, 'refs' => [], ], 'AssociateWorkspaceApplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateWorkspaceApplicationResult' => [ 'base' => NULL, 'refs' => [], ], 'AssociationErrorCode' => [ 'base' => NULL, 'refs' => [ 'AssociationStateReason$ErrorCode' => '<p>The error code of the association deployment failure.</p>', ], ], 'AssociationState' => [ 'base' => NULL, 'refs' => [ 'ApplicationResourceAssociation$State' => '<p>The status of the application resource association.</p>', 'BundleResourceAssociation$State' => '<p>The status of the bundle resource association.</p>', 'ImageResourceAssociation$State' => '<p>The status of the image resource association.</p>', 'WorkspaceResourceAssociation$State' => '<p>The status of the WorkSpace resource association.</p>', ], ], 'AssociationStateReason' => [ 'base' => '<p>Indicates the reason that the association deployment failed, including the error code and error message.</p>', 'refs' => [ 'ApplicationResourceAssociation$StateReason' => '<p>The reason the association deployment failed.</p>', 'BundleResourceAssociation$StateReason' => '<p>The reason the association deployment failed.</p>', 'ImageResourceAssociation$StateReason' => '<p>The reason the association deployment failed.</p>', 'WorkspaceResourceAssociation$StateReason' => '<p>The reason the association deployment failed.</p>', ], ], 'AssociationStatus' => [ 'base' => NULL, 'refs' => [ 'ConnectionAliasAssociation$AssociationStatus' => '<p>The association status of the connection alias.</p>', ], ], 'AuthenticationType' => [ 'base' => NULL, 'refs' => [ 'WorkspacesPoolSession$AuthenticationType' => '<p>The authentication method. The user is authenticated using a WorkSpaces Pools URL (API) or SAML 2.0 federation (SAML).</p>', ], ], 'AuthorizeIpRulesRequest' => [ 'base' => NULL, 'refs' => [], ], 'AuthorizeIpRulesResult' => [ 'base' => NULL, 'refs' => [], ], 'AvailableUserSessions' => [ 'base' => NULL, 'refs' => [ 'CapacityStatus$AvailableUserSessions' => '<p>The number of user sessions currently being used for pool sessions. This only applies to multi-session pools.</p>', ], ], 'AwsAccount' => [ 'base' => NULL, 'refs' => [ 'AccountLink$SourceAccountId' => '<p>The identifier of the source account.</p>', 'AccountLink$TargetAccountId' => '<p>The identifier of the target account.</p>', 'ConnectionAlias$OwnerAccountId' => '<p>The identifier of the Amazon Web Services account that owns the connection alias.</p>', 'ConnectionAliasAssociation$AssociatedAccountId' => '<p>The identifier of the Amazon Web Services account that associated the connection alias with a directory.</p>', 'ConnectionAliasPermission$SharedAccountId' => '<p>The identifier of the Amazon Web Services account that the connection alias is shared with.</p>', 'CreateAccountLinkInvitationRequest$TargetAccountId' => '<p>The identifier of the target account.</p>', 'CreateWorkspaceImageResult$OwnerAccountId' => '<p>The identifier of the Amazon Web Services account that owns the image.</p>', 'GetAccountLinkRequest$LinkedAccountId' => '<p>The identifier of the account link</p>', 'ImagePermission$SharedAccountId' => '<p>The identifier of the Amazon Web Services account that an image has been shared with.</p>', 'UpdateWorkspaceImagePermissionRequest$SharedAccountId' => '<p>The identifier of the Amazon Web Services account to share or unshare the image with.</p> <important> <p>Before sharing the image, confirm that you are sharing to the correct Amazon Web Services account ID.</p> </important>', 'WorkspaceImage$OwnerAccountId' => '<p>The identifier of the Amazon Web Services account that owns the image.</p>', ], ], 'BooleanObject' => [ 'base' => NULL, 'refs' => [ 'ConnectionAliasPermission$AllowAssociation' => '<p>Indicates whether the specified Amazon Web Services account is allowed to associate the connection alias with a directory.</p>', 'DefaultWorkspaceCreationProperties$EnableWorkDocs' => '<p>Specifies whether the directory is enabled for Amazon WorkDocs.</p>', 'DefaultWorkspaceCreationProperties$EnableInternetAccess' => '<p>Specifies whether to automatically assign an Elastic public IP address to WorkSpaces in this directory by default. If enabled, the Elastic public IP address allows outbound internet access from your WorkSpaces when you’re using an internet gateway in the Amazon VPC in which your WorkSpaces are located. If you\'re using a Network Address Translation (NAT) gateway for outbound internet access from your VPC, or if your WorkSpaces are in public subnets and you manually assign them Elastic IP addresses, you should disable this setting. This setting applies to new WorkSpaces that you launch or to existing WorkSpaces that you rebuild. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/amazon-workspaces-vpc.html"> Configure a VPC for Amazon WorkSpaces</a>.</p>', 'DefaultWorkspaceCreationProperties$UserEnabledAsLocalAdministrator' => '<p>Specifies whether WorkSpace users are local administrators on their WorkSpaces.</p>', 'DefaultWorkspaceCreationProperties$EnableMaintenanceMode' => '<p>Specifies whether maintenance mode is enabled for WorkSpaces. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/workspace-maintenance.html">WorkSpace Maintenance</a>.</p>', 'DeployWorkspaceApplicationsRequest$Force' => '<p>Indicates whether the force flag is applied for the specified WorkSpace. When the force flag is enabled, it allows previously failed deployments to be retried.</p>', 'RegisterWorkspaceDirectoryRequest$EnableWorkDocs' => '<p>Indicates whether Amazon WorkDocs is enabled or disabled. If you have enabled this parameter and WorkDocs is not available in the Region, you will receive an OperationNotSupportedException error. Set <code>EnableWorkDocs</code> to disabled, and try again.</p>', 'RegisterWorkspaceDirectoryRequest$EnableSelfService' => '<p>Indicates whether self-service capabilities are enabled or disabled.</p>', 'UpdateResult$UpdateAvailable' => '<p>Indicates whether updated drivers or other components are available for the specified WorkSpace image.</p>', 'UpdateWorkspaceImagePermissionRequest$AllowCopyImage' => '<p>The permission to copy the image. This permission can be revoked only after an image has been shared.</p>', 'Workspace$UserVolumeEncryptionEnabled' => '<p>Indicates whether the data stored on the user volume is encrypted.</p>', 'Workspace$RootVolumeEncryptionEnabled' => '<p>Indicates whether the data stored on the root volume is encrypted.</p>', 'WorkspaceCreationProperties$EnableWorkDocs' => '<p>Indicates whether Amazon WorkDocs is enabled for your WorkSpaces.</p> <note> <p>If WorkDocs is already enabled for a WorkSpaces directory and you disable it, new WorkSpaces launched in the directory will not have WorkDocs enabled. However, WorkDocs remains enabled for any existing WorkSpaces, unless you either disable users\' access to WorkDocs or you delete the WorkDocs site. To disable users\' access to WorkDocs, see <a href="https://docs.aws.amazon.com/workdocs/latest/adminguide/inactive-user.html">Disabling Users</a> in the <i>Amazon WorkDocs Administration Guide</i>. To delete a WorkDocs site, see <a href="https://docs.aws.amazon.com/workdocs/latest/adminguide/manage-sites.html">Deleting a Site</a> in the <i>Amazon WorkDocs Administration Guide</i>.</p> <p>If you enable WorkDocs on a directory that already has existing WorkSpaces, the existing WorkSpaces and any new WorkSpaces that are launched in the directory will have WorkDocs enabled.</p> </note>', 'WorkspaceCreationProperties$EnableInternetAccess' => '<p>Indicates whether internet access is enabled for your WorkSpaces.</p>', 'WorkspaceCreationProperties$UserEnabledAsLocalAdministrator' => '<p>Indicates whether users are local administrators of their WorkSpaces.</p>', 'WorkspaceCreationProperties$EnableMaintenanceMode' => '<p>Indicates whether maintenance mode is enabled for your WorkSpaces. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/workspace-maintenance.html">WorkSpace Maintenance</a>. </p>', 'WorkspaceRequest$UserVolumeEncryptionEnabled' => '<p>Indicates whether the data stored on the user volume is encrypted.</p>', 'WorkspaceRequest$RootVolumeEncryptionEnabled' => '<p>Indicates whether the data stored on the root volume is encrypted.</p>', ], ], 'BundleAssociatedResourceType' => [ 'base' => NULL, 'refs' => [ 'BundleAssociatedResourceTypeList$member' => NULL, 'BundleResourceAssociation$AssociatedResourceType' => '<p>The resource type of the associated resources.</p>', ], ], 'BundleAssociatedResourceTypeList' => [ 'base' => NULL, 'refs' => [ 'DescribeBundleAssociationsRequest$AssociatedResourceTypes' => '<p>The resource types of the associated resource.</p>', ], ], 'BundleId' => [ 'base' => NULL, 'refs' => [ 'BundleIdList$member' => NULL, 'BundleResourceAssociation$BundleId' => '<p>The identifier of the bundle.</p>', 'CreateWorkspacesPoolRequest$BundleId' => '<p>The identifier of the bundle for the pool.</p>', 'DeleteWorkspaceBundleRequest$BundleId' => '<p>The identifier of the bundle.</p>', 'DescribeBundleAssociationsRequest$BundleId' => '<p>The identifier of the bundle.</p>', 'DescribeWorkspacesRequest$BundleId' => '<p>The identifier of the bundle. All WorkSpaces that are created from this bundle are retrieved. You cannot combine this parameter with any other filter.</p>', 'MigrateWorkspaceRequest$BundleId' => '<p>The identifier of the target bundle type to migrate the WorkSpace to.</p>', 'UpdateWorkspaceBundleRequest$BundleId' => '<p>The identifier of the bundle.</p>', 'UpdateWorkspacesPoolRequest$BundleId' => '<p>The identifier of the bundle.</p>', 'Workspace$BundleId' => '<p>The identifier of the bundle used to create the WorkSpace.</p>', 'WorkspaceBundle$BundleId' => '<p>The identifier of the bundle.</p>', 'WorkspaceRequest$BundleId' => '<p>The identifier of the bundle for the WorkSpace. You can use <a>DescribeWorkspaceBundles</a> to list the available bundles.</p>', 'WorkspacesPool$BundleId' => '<p>The identifier of the bundle used by the pool.</p>', ], ], 'BundleIdList' => [ 'base' => NULL, 'refs' => [ 'DescribeWorkspaceBundlesRequest$BundleIds' => '<p>The identifiers of the bundles. You cannot combine this parameter with any other filter.</p>', ], ], 'BundleList' => [ 'base' => NULL, 'refs' => [ 'DescribeWorkspaceBundlesResult$Bundles' => '<p>Information about the bundles.</p>', ], ], 'BundleOwner' => [ 'base' => NULL, 'refs' => [ 'DescribeWorkspaceBundlesRequest$Owner' => '<p>The owner of the bundles. You cannot combine this parameter with any other filter.</p> <p>To describe the bundles provided by Amazon Web Services, specify <code>AMAZON</code>. To describe the bundles that belong to your account, don\'t specify a value.</p>', 'WorkspaceBundle$Owner' => '<p>The owner of the bundle. This is the account identifier of the owner, or <code>AMAZON</code> if the bundle is provided by Amazon Web Services.</p>', ], ], 'BundleResourceAssociation' => [ 'base' => '<p>Describes the association between an application and a bundle resource.</p>', 'refs' => [ 'BundleResourceAssociationList$member' => NULL, ], ], 'BundleResourceAssociationList' => [ 'base' => NULL, 'refs' => [ 'DescribeBundleAssociationsResult$Associations' => '<p>List of information about the specified associations.</p>', ], ], 'BundleType' => [ 'base' => NULL, 'refs' => [ 'WorkspaceBundle$BundleType' => '<p>The type of WorkSpace bundle.</p>', ], ], 'Capacity' => [ 'base' => '<p>Describes the user capacity for a pool of WorkSpaces.</p>', 'refs' => [ 'CreateWorkspacesPoolRequest$Capacity' => '<p>The user capacity of the pool.</p>', 'UpdateWorkspacesPoolRequest$Capacity' => '<p>The desired capacity for the pool.</p>', ], ], 'CapacityStatus' => [ 'base' => '<p>Describes the capacity status for a pool of WorkSpaces.</p>', 'refs' => [ 'WorkspacesPool$CapacityStatus' => '<p>The capacity status for the pool</p>', ], ], 'CertificateAuthorityArn' => [ 'base' => NULL, 'refs' => [ 'CertificateBasedAuthProperties$CertificateAuthorityArn' => '<p>The Amazon Resource Name (ARN) of the Amazon Web Services Certificate Manager Private CA resource.</p>', ], ], 'CertificateBasedAuthProperties' => [ 'base' => '<p>Describes the properties of the certificate-based authentication you want to use with your WorkSpaces.</p>', 'refs' => [ 'ModifyCertificateBasedAuthPropertiesRequest$CertificateBasedAuthProperties' => '<p>The properties of the certificate-based authentication.</p>', 'WorkspaceDirectory$CertificateBasedAuthProperties' => '<p>The certificate-based authentication properties used to authenticate SAML 2.0 Identity Provider (IdP) user identities to Active Directory for WorkSpaces login.</p>', ], ], 'CertificateBasedAuthStatusEnum' => [ 'base' => NULL, 'refs' => [ 'CertificateBasedAuthProperties$Status' => '<p>The status of the certificate-based authentication properties.</p>', ], ], 'ClientDeviceType' => [ 'base' => NULL, 'refs' => [ 'ClientDeviceTypeList$member' => NULL, ], ], 'ClientDeviceTypeList' => [ 'base' => NULL, 'refs' => [ 'DeleteClientBrandingRequest$Platforms' => '<p>The device type for which you want to delete client branding.</p>', ], ], 'ClientEmail' => [ 'base' => NULL, 'refs' => [ 'DefaultClientBrandingAttributes$SupportEmail' => '<p>The support email. The company\'s customer support email address.</p> <note> <ul> <li> <p>In each platform type, the <code>SupportEmail</code> and <code>SupportLink</code> parameters are mutually exclusive. You can specify one parameter for each platform type, but not both.</p> </li> <li> <p>The default email is <code>workspaces-feedback@amazon.com</code>.</p> </li> </ul> </note>', 'DefaultImportClientBrandingAttributes$SupportEmail' => '<p>The support email. The company\'s customer support email address.</p> <note> <ul> <li> <p>In each platform type, the <code>SupportEmail</code> and <code>SupportLink</code> parameters are mutually exclusive. You can specify one parameter for each platform type, but not both.</p> </li> <li> <p>The default email is <code>workspaces-feedback@amazon.com</code>.</p> </li> </ul> </note>', 'IosClientBrandingAttributes$SupportEmail' => '<p>The support email. The company\'s customer support email address.</p> <note> <ul> <li> <p>In each platform type, the <code>SupportEmail</code> and <code>SupportLink</code> parameters are mutually exclusive. You can specify one parameter for each platform type, but not both.</p> </li> <li> <p>The default email is <code>workspaces-feedback@amazon.com</code>.</p> </li> </ul> </note>', 'IosImportClientBrandingAttributes$SupportEmail' => '<p>The support email. The company\'s customer support email address.</p> <note> <ul> <li> <p>In each platform type, the <code>SupportEmail</code> and <code>SupportLink</code> parameters are mutually exclusive. You can specify one parameter for each platform type, but not both.</p> </li> <li> <p>The default email is <code>workspaces-feedback@amazon.com</code>.</p> </li> </ul> </note>', ], ], 'ClientLocale' => [ 'base' => NULL, 'refs' => [ 'LoginMessage$key' => NULL, ], ], 'ClientLoginMessage' => [ 'base' => NULL, 'refs' => [ 'LoginMessage$value' => NULL, ], ], 'ClientProperties' => [ 'base' => '<p>Describes an Amazon WorkSpaces client.</p>', 'refs' => [ 'ClientPropertiesResult$ClientProperties' => '<p>Information about the Amazon WorkSpaces client.</p>', 'ModifyClientPropertiesRequest$ClientProperties' => '<p>Information about the Amazon WorkSpaces client.</p>', ], ], 'ClientPropertiesList' => [ 'base' => NULL, 'refs' => [ 'DescribeClientPropertiesResult$ClientPropertiesList' => '<p>Information about the specified Amazon WorkSpaces clients.</p>', ], ], 'ClientPropertiesResult' => [ 'base' => '<p>Information about the Amazon WorkSpaces client.</p>', 'refs' => [ 'ClientPropertiesList$member' => NULL, ], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'AcceptAccountLinkInvitationRequest$ClientToken' => '<p>A string of up to 64 ASCII characters that Amazon EFS uses to ensure idempotent creation.</p>', 'CreateAccountLinkInvitationRequest$ClientToken' => '<p>A string of up to 64 ASCII characters that Amazon EFS uses to ensure idempotent creation.</p>', 'DeleteAccountLinkInvitationRequest$ClientToken' => '<p>A string of up to 64 ASCII characters that Amazon EFS uses to ensure idempotent creation.</p>', 'RejectAccountLinkInvitationRequest$ClientToken' => '<p>The client token of the account link invitation to reject.</p>', ], ], 'ClientUrl' => [ 'base' => NULL, 'refs' => [ 'DefaultClientBrandingAttributes$LogoUrl' => '<p>The logo. The only image format accepted is a binary data object that is converted from a <code>.png</code> file.</p>', 'DefaultClientBrandingAttributes$SupportLink' => '<p>The support link. The link for the company\'s customer support page for their WorkSpace.</p> <note> <ul> <li> <p>In each platform type, the <code>SupportEmail</code> and <code>SupportLink</code> parameters are mutually exclusive.You can specify one parameter for each platform type, but not both.</p> </li> <li> <p>The default support link is <code>workspaces-feedback@amazon.com</code>.</p> </li> </ul> </note>', 'DefaultClientBrandingAttributes$ForgotPasswordLink' => '<p>The forgotten password link. This is the web address that users can go to if they forget the password for their WorkSpace.</p>', 'DefaultImportClientBrandingAttributes$SupportLink' => '<p>The support link. The link for the company\'s customer support page for their WorkSpace.</p> <note> <ul> <li> <p>In each platform type, the <code>SupportEmail</code> and <code>SupportLink</code> parameters are mutually exclusive. You can specify one parameter for each platform type, but not both.</p> </li> <li> <p>The default support link is <code>workspaces-feedback@amazon.com</code>.</p> </li> </ul> </note>', 'DefaultImportClientBrandingAttributes$ForgotPasswordLink' => '<p>The forgotten password link. This is the web address that users can go to if they forget the password for their WorkSpace.</p>', 'IosClientBrandingAttributes$LogoUrl' => '<p>The logo. This is the standard-resolution display that has a 1:1 pixel density (or @1x), where one pixel is equal to one point. The only image format accepted is a binary data object that is converted from a <code>.png</code> file.</p>', 'IosClientBrandingAttributes$Logo2xUrl' => '<p>The @2x version of the logo. This is the higher resolution display that offers a scale factor of 2.0 (or @2x). The only image format accepted is a binary data object that is converted from a <code>.png</code> file.</p> <note> <p> For more information about iOS image size and resolution, see <a href="https://developer.apple.com/design/human-interface-guidelines/ios/icons-and-images/image-size-and-resolution/">Image Size and Resolution </a> in the <i>Apple Human Interface Guidelines</i>.</p> </note>', 'IosClientBrandingAttributes$Logo3xUrl' => '<p>The @3x version of the logo. This is the higher resolution display that offers a scale factor of 3.0 (or @3x).The only image format accepted is a binary data object that is converted from a <code>.png</code> file.</p> <note> <p> For more information about iOS image size and resolution, see <a href="https://developer.apple.com/design/human-interface-guidelines/ios/icons-and-images/image-size-and-resolution/">Image Size and Resolution </a> in the <i>Apple Human Interface Guidelines</i>.</p> </note>', 'IosClientBrandingAttributes$SupportLink' => '<p>The support link. The link for the company\'s customer support page for their WorkSpace.</p> <note> <ul> <li> <p>In each platform type, the <code>SupportEmail</code> and <code>SupportLink</code> parameters are mutually exclusive. You can specify one parameter for each platform type, but not both.</p> </li> <li> <p>The default support link is <code>workspaces-feedback@amazon.com</code>.</p> </li> </ul> </note>', 'IosClientBrandingAttributes$ForgotPasswordLink' => '<p>The forgotten password link. This is the web address that users can go to if they forget the password for their WorkSpace.</p>', 'IosImportClientBrandingAttributes$SupportLink' => '<p>The support link. The link for the company\'s customer support page for their WorkSpace.</p> <note> <ul> <li> <p>In each platform type, the <code>SupportEmail</code> and <code>SupportLink</code> parameters are mutually exclusive. You can specify one parameter for each platform type, but not both.</p> </li> <li> <p>The default support link is <code>workspaces-feedback@amazon.com</code>.</p> </li> </ul> </note>', 'IosImportClientBrandingAttributes$ForgotPasswordLink' => '<p>The forgotten password link. This is the web address that users can go to if they forget the password for their WorkSpace.</p>', ], ], 'Compute' => [ 'base' => NULL, 'refs' => [ 'ComputeList$member' => NULL, 'ComputeType$Name' => '<p>The compute type.</p>', 'WorkspaceProperties$ComputeTypeName' => '<p>The compute type. For more information, see <a href="http://aws.amazon.com/workspaces/details/#Amazon_WorkSpaces_Bundles">Amazon WorkSpaces Bundles</a>.</p>', ], ], 'ComputeList' => [ 'base' => NULL, 'refs' => [ 'DescribeApplicationsRequest$ComputeTypeNames' => '<p>The compute types supported by the applications.</p>', 'WorkSpaceApplication$SupportedComputeTypeNames' => '<p>The supported compute types of the WorkSpace application.</p>', ], ], 'ComputeNotCompatibleException' => [ 'base' => '<p>The compute type of the WorkSpace is not compatible with the application.</p>', 'refs' => [], ], 'ComputeType' => [ 'base' => '<p>Describes the compute type of the bundle.</p>', 'refs' => [ 'CreateWorkspaceBundleRequest$ComputeType' => NULL, 'WorkspaceBundle$ComputeType' => '<p>The compute type of the bundle. For more information, see <a href="http://aws.amazon.com/workspaces/details/#Amazon_WorkSpaces_Bundles">Amazon WorkSpaces Bundles</a>.</p>', ], ], 'ComputerName' => [ 'base' => NULL, 'refs' => [ 'Workspace$ComputerName' => '<p>The name of the WorkSpace, as seen by the operating system. The format of this name varies. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/launch-workspaces-tutorials.html"> Launch a WorkSpace</a>. </p>', ], ], 'ConflictException' => [ 'base' => '<p>The <code>TargetAccountId</code> is already linked or invited.</p>', 'refs' => [], ], 'ConnectClientAddIn' => [ 'base' => '<p>Describes an Amazon Connect client add-in.</p>', 'refs' => [ 'ConnectClientAddInList$member' => NULL, ], ], 'ConnectClientAddInList' => [ 'base' => NULL, 'refs' => [ 'DescribeConnectClientAddInsResult$AddIns' => '<p>Information about client add-ins.</p>', ], ], 'ConnectionAlias' => [ 'base' => '<p>Describes a connection alias. Connection aliases are used for cross-Region redirection. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region Redirection for Amazon WorkSpaces</a>.</p>', 'refs' => [ 'ConnectionAliasList$member' => NULL, ], ], 'ConnectionAliasAssociation' => [ 'base' => '<p>Describes a connection alias association that is used for cross-Region redirection. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region Redirection for Amazon WorkSpaces</a>.</p>', 'refs' => [ 'ConnectionAliasAssociationList$member' => NULL, ], ], 'ConnectionAliasAssociationList' => [ 'base' => NULL, 'refs' => [ 'ConnectionAlias$Associations' => '<p>The association status of the connection alias.</p>', ], ], 'ConnectionAliasId' => [ 'base' => NULL, 'refs' => [ 'AssociateConnectionAliasRequest$AliasId' => '<p>The identifier of the connection alias.</p>', 'ConnectionAlias$AliasId' => '<p>The identifier of the connection alias.</p>', 'ConnectionAliasIdList$member' => NULL, 'CreateConnectionAliasResult$AliasId' => '<p>The identifier of the connection alias.</p>', 'DeleteConnectionAliasRequest$AliasId' => '<p>The identifier of the connection alias to delete.</p>', 'DescribeConnectionAliasPermissionsRequest$AliasId' => '<p>The identifier of the connection alias.</p>', 'DescribeConnectionAliasPermissionsResult$AliasId' => '<p>The identifier of the connection alias.</p>', 'DisassociateConnectionAliasRequest$AliasId' => '<p>The identifier of the connection alias to disassociate.</p>', 'UpdateConnectionAliasPermissionRequest$AliasId' => '<p>The identifier of the connection alias that you want to update permissions for.</p>', ], ], 'ConnectionAliasIdList' => [ 'base' => NULL, 'refs' => [ 'DescribeConnectionAliasesRequest$AliasIds' => '<p>The identifiers of the connection aliases to describe.</p>', ], ], 'ConnectionAliasList' => [ 'base' => NULL, 'refs' => [ 'DescribeConnectionAliasesResult$ConnectionAliases' => '<p>Information about the specified connection aliases.</p>', ], ], 'ConnectionAliasPermission' => [ 'base' => '<p>Describes the permissions for a connection alias. Connection aliases are used for cross-Region redirection. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region Redirection for Amazon WorkSpaces</a>.</p>', 'refs' => [ 'ConnectionAliasPermissions$member' => NULL, 'UpdateConnectionAliasPermissionRequest$ConnectionAliasPermission' => '<p>Indicates whether to share or unshare the connection alias with the specified Amazon Web Services account.</p>', ], ], 'ConnectionAliasPermissions' => [ 'base' => NULL, 'refs' => [ 'DescribeConnectionAliasPermissionsResult$ConnectionAliasPermissions' => '<p>The permissions associated with a connection alias.</p>', ], ], 'ConnectionAliasState' => [ 'base' => NULL, 'refs' => [ 'ConnectionAlias$State' => '<p>The current state of the connection alias.</p>', ], ], 'ConnectionIdentifier' => [ 'base' => NULL, 'refs' => [ 'AssociateConnectionAliasResult$ConnectionIdentifier' => '<p>The identifier of the connection alias association. You use the connection identifier in the DNS TXT record when you\'re configuring your DNS routing policies. </p>', 'ConnectionAliasAssociation$ConnectionIdentifier' => '<p>The identifier of the connection alias association. You use the connection identifier in the DNS TXT record when you\'re configuring your DNS routing policies.</p>', ], ], 'ConnectionState' => [ 'base' => NULL, 'refs' => [ 'WorkspaceConnectionStatus$ConnectionState' => '<p>The connection state of the WorkSpace. The connection state is unknown if the WorkSpace is stopped.</p>', ], ], 'ConnectionString' => [ 'base' => NULL, 'refs' => [ 'ConnectionAlias$ConnectionString' => '<p>The connection string specified for the connection alias. The connection string must be in the form of a fully qualified domain name (FQDN), such as <code>www.example.com</code>.</p>', 'CreateConnectionAliasRequest$ConnectionString' => '<p>A connection string in the form of a fully qualified domain name (FQDN), such as <code>www.example.com</code>.</p> <important> <p>After you create a connection string, it is always associated to your Amazon Web Services account. You cannot recreate the same connection string with a different account, even if you delete all instances of it from the original account. The connection string is globally reserved for your account.</p> </important>', ], ], 'CopyWorkspaceImageRequest' => [ 'base' => NULL, 'refs' => [], ], 'CopyWorkspaceImageResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateAccountLinkInvitationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAccountLinkInvitationResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateConnectClientAddInRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateConnectClientAddInResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateConnectionAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateConnectionAliasResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateIpGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateIpGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateStandbyWorkspacesRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateStandbyWorkspacesResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateTagsRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTagsResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateUpdatedWorkspaceImageRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateUpdatedWorkspaceImageResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateWorkspaceBundleRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateWorkspaceBundleResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateWorkspaceImageRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateWorkspaceImageResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateWorkspacesPoolRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateWorkspacesPoolResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateWorkspacesRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateWorkspacesResult' => [ 'base' => NULL, 'refs' => [], ], 'DataReplication' => [ 'base' => NULL, 'refs' => [ 'DataReplicationSettings$DataReplication' => '<p>Indicates whether data replication is enabled, and if enabled, the type of data replication.</p>', 'ModifyWorkspacePropertiesRequest$DataReplication' => '<p>Indicates the data replication status.</p>', 'StandbyWorkspace$DataReplication' => '<p>Indicates whether data replication is enabled, and if enabled, the type of data replication.</p>', 'StandbyWorkspacesProperties$DataReplication' => '<p>Indicates whether data replication is enabled, and if enabled, the type of data replication.</p>', ], ], 'DataReplicationSettings' => [ 'base' => '<p>Describes the data replication settings.</p>', 'refs' => [ 'Workspace$DataReplicationSettings' => '<p>Indicates the settings of the data replication.</p>', ], ], 'DedicatedTenancyAccountType' => [ 'base' => NULL, 'refs' => [ 'DescribeAccountResult$DedicatedTenancyAccountType' => '<p>The type of linked account.</p>', ], ], 'DedicatedTenancyCidrRangeList' => [ 'base' => NULL, 'refs' => [ 'ListAvailableManagementCidrRangesResult$ManagementCidrRanges' => '<p>The list of available IP address ranges, specified as IPv4 CIDR blocks.</p>', ], ], 'DedicatedTenancyManagementCidrRange' => [ 'base' => NULL, 'refs' => [ 'AccountModification$DedicatedTenancyManagementCidrRange' => '<p>The IP address range, specified as an IPv4 CIDR block, for the management network interface used for the account.</p>', 'DedicatedTenancyCidrRangeList$member' => NULL, 'DescribeAccountResult$DedicatedTenancyManagementCidrRange' => '<p>The IP address range, specified as an IPv4 CIDR block, used for the management network interface.</p> <p>The management network interface is connected to a secure Amazon WorkSpaces management network. It is used for interactive streaming of the WorkSpace desktop to Amazon WorkSpaces clients, and to allow Amazon WorkSpaces to manage the WorkSpace.</p>', 'ModifyAccountRequest$DedicatedTenancyManagementCidrRange' => '<p>The IP address range, specified as an IPv4 CIDR block, for the management network interface. Specify an IP address range that is compatible with your network and in CIDR notation (that is, specify the range as an IPv4 CIDR block). The CIDR block size must be /16 (for example, 203.0.113.25/16). It must also be specified as available by the <code>ListAvailableManagementCidrRanges</code> operation.</p>', ], ], 'DedicatedTenancyModificationStateEnum' => [ 'base' => NULL, 'refs' => [ 'AccountModification$ModificationState' => '<p>The state of the modification to the configuration of BYOL.</p>', ], ], 'DedicatedTenancySupportEnum' => [ 'base' => NULL, 'refs' => [ 'ModifyAccountRequest$DedicatedTenancySupport' => '<p>The status of BYOL.</p>', ], ], 'DedicatedTenancySupportResultEnum' => [ 'base' => NULL, 'refs' => [ 'AccountModification$DedicatedTenancySupport' => '<p>The status of BYOL (whether BYOL is being enabled or disabled).</p>', 'DescribeAccountResult$DedicatedTenancySupport' => '<p>The status of BYOL (whether BYOL is enabled or disabled).</p>', ], ], 'DefaultClientBrandingAttributes' => [ 'base' => '<p>Returns default client branding attributes that were imported. These attributes display on the client login screen.</p> <important> <p>Client branding attributes are public facing. Ensure that you don\'t include sensitive information.</p> </important>', 'refs' => [ 'DescribeClientBrandingResult$DeviceTypeWindows' => '<p>The branding information for Windows devices.</p>', 'DescribeClientBrandingResult$DeviceTypeOsx' => '<p>The branding information for macOS devices.</p>', 'DescribeClientBrandingResult$DeviceTypeAndroid' => '<p>The branding information for Android devices.</p>', 'DescribeClientBrandingResult$DeviceTypeLinux' => '<p>The branding information for Linux devices.</p>', 'DescribeClientBrandingResult$DeviceTypeWeb' => '<p>The branding information for Web access.</p>', 'ImportClientBrandingResult$DeviceTypeWindows' => '<p>The branding information configured for Windows devices.</p>', 'ImportClientBrandingResult$DeviceTypeOsx' => '<p>The branding information configured for macOS devices.</p>', 'ImportClientBrandingResult$DeviceTypeAndroid' => '<p>The branding information configured for Android devices.</p>', 'ImportClientBrandingResult$DeviceTypeLinux' => '<p>The branding information configured for Linux devices.</p>', 'ImportClientBrandingResult$DeviceTypeWeb' => '<p>The branding information configured for web access.</p>', ], ], 'DefaultImportClientBrandingAttributes' => [ 'base' => '<p>The default client branding attributes to be imported. These attributes display on the client login screen.</p> <important> <p>Client branding attributes are public facing. Ensure that you do not include sensitive information.</p> </important>', 'refs' => [ 'ImportClientBrandingRequest$DeviceTypeWindows' => '<p>The branding information to import for Windows devices.</p>', 'ImportClientBrandingRequest$DeviceTypeOsx' => '<p>The branding information to import for macOS devices.</p>', 'ImportClientBrandingRequest$DeviceTypeAndroid' => '<p>The branding information to import for Android devices.</p>', 'ImportClientBrandingRequest$DeviceTypeLinux' => '<p>The branding information to import for Linux devices.</p>', 'ImportClientBrandingRequest$DeviceTypeWeb' => '<p>The branding information to import for web access.</p>', ], ], 'DefaultLogo' => [ 'base' => NULL, 'refs' => [ 'DefaultImportClientBrandingAttributes$Logo' => '<p>The logo. The only image format accepted is a binary data object that is converted from a <code>.png</code> file.</p>', ], ], 'DefaultOu' => [ 'base' => NULL, 'refs' => [ 'DefaultWorkspaceCreationProperties$DefaultOu' => '<p>The organizational unit (OU) in the directory for the WorkSpace machine accounts.</p>', 'WorkspaceCreationProperties$DefaultOu' => '<p>The default organizational unit (OU) for your WorkSpaces directories. This string must be the full Lightweight Directory Access Protocol (LDAP) distinguished name for the target domain and OU. It must be in the form <code>"OU=<i>value</i>,DC=<i>value</i>,DC=<i>value</i>"</code>, where <i>value</i> is any string of characters, and the number of domain components (DCs) is two or more. For example, <code>OU=WorkSpaces_machines,DC=machines,DC=example,DC=com</code>. </p> <important> <ul> <li> <p>To avoid errors, certain characters in the distinguished name must be escaped. For more information, see <a href="https://docs.microsoft.com/previous-versions/windows/desktop/ldap/distinguished-names"> Distinguished Names</a> in the Microsoft documentation.</p> </li> <li> <p>The API doesn\'t validate whether the OU exists.</p> </li> </ul> </important>', ], ], 'DefaultWorkspaceCreationProperties' => [ 'base' => '<p>Describes the default values that are used to create WorkSpaces. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/update-directory-details.html">Update Directory Details for Your WorkSpaces</a>.</p>', 'refs' => [ 'WorkspaceDirectory$WorkspaceCreationProperties' => '<p>The default creation properties for all WorkSpaces in the directory.</p>', ], ], 'DeletableCertificateBasedAuthPropertiesList' => [ 'base' => NULL, 'refs' => [ 'ModifyCertificateBasedAuthPropertiesRequest$PropertiesToDelete' => '<p>The properties of the certificate-based authentication you want to delete.</p>', ], ], 'DeletableCertificateBasedAuthProperty' => [ 'base' => NULL, 'refs' => [ 'DeletableCertificateBasedAuthPropertiesList$member' => NULL, ], ], 'DeletableSamlPropertiesList' => [ 'base' => NULL, 'refs' => [ 'ModifySamlPropertiesRequest$PropertiesToDelete' => '<p>The SAML properties to delete as part of your request.</p> <p>Specify one of the following options:</p> <ul> <li> <p> <code>SAML_PROPERTIES_USER_ACCESS_URL</code> to delete the user access URL.</p> </li> <li> <p> <code>SAML_PROPERTIES_RELAY_STATE_PARAMETER_NAME</code> to delete the relay state parameter name.</p> </li> </ul>', ], ], 'DeletableSamlProperty' => [ 'base' => NULL, 'refs' => [ 'DeletableSamlPropertiesList$member' => NULL, ], ], 'DeleteAccountLinkInvitationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAccountLinkInvitationResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteClientBrandingRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteClientBrandingResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteConnectClientAddInRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteConnectClientAddInResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteConnectionAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteConnectionAliasResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteIpGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteIpGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTagsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTagsResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWorkspaceBundleRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWorkspaceBundleResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWorkspaceImageRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWorkspaceImageResult' => [ 'base' => NULL, 'refs' => [], ], 'DeployWorkspaceApplicationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeployWorkspaceApplicationsResult' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterWorkspaceDirectoryRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterWorkspaceDirectoryResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccountModificationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccountModificationsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccountRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccountResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeApplicationAssociationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeApplicationAssociationsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeApplicationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeApplicationsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeBundleAssociationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeBundleAssociationsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeClientBrandingRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeClientBrandingResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeClientPropertiesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeClientPropertiesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeConnectClientAddInsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeConnectClientAddInsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeConnectionAliasPermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeConnectionAliasPermissionsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeConnectionAliasesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeConnectionAliasesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeImageAssociationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeImageAssociationsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIpGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIpGroupsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTagsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTagsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeWorkspaceAssociationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeWorkspaceAssociationsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeWorkspaceBundlesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeWorkspaceBundlesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeWorkspaceDirectoriesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeWorkspaceDirectoriesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeWorkspaceImagePermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeWorkspaceImagePermissionsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeWorkspaceImagesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeWorkspaceImagesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeWorkspaceSnapshotsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeWorkspaceSnapshotsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeWorkspacesConnectionStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeWorkspacesConnectionStatusResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeWorkspacesPoolSessionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeWorkspacesPoolSessionsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeWorkspacesPoolsFilter' => [ 'base' => '<p>Describes the filter conditions for WorkSpaces Pools to return.</p>', 'refs' => [ 'DescribeWorkspacesPoolsFilters$member' => NULL, ], ], 'DescribeWorkspacesPoolsFilterName' => [ 'base' => NULL, 'refs' => [ 'DescribeWorkspacesPoolsFilter$Name' => '<p>The name of the pool to filter.</p>', ], ], 'DescribeWorkspacesPoolsFilterOperator' => [ 'base' => NULL, 'refs' => [ 'DescribeWorkspacesPoolsFilter$Operator' => '<p>The operator values for filtering WorkSpaces Pools.</p>', ], ], 'DescribeWorkspacesPoolsFilterValue' => [ 'base' => NULL, 'refs' => [ 'DescribeWorkspacesPoolsFilterValues$member' => NULL, ], ], 'DescribeWorkspacesPoolsFilterValues' => [ 'base' => NULL, 'refs' => [ 'DescribeWorkspacesPoolsFilter$Values' => '<p>The values for filtering WorkSpaces Pools.</p>', ], ], 'DescribeWorkspacesPoolsFilters' => [ 'base' => NULL, 'refs' => [ 'DescribeWorkspacesPoolsRequest$Filters' => '<p>The filter conditions for the WorkSpaces Pool to return.</p>', ], ], 'DescribeWorkspacesPoolsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeWorkspacesPoolsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeWorkspacesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeWorkspacesResult' => [ 'base' => NULL, 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'AccountModification$ErrorMessage' => '<p>The text of the error message that is returned if the configuration of BYOL cannot be modified.</p>', 'ErrorDetails$ErrorMessage' => '<p>The text of the error message related the error code.</p>', 'FailedCreateStandbyWorkspacesRequest$ErrorMessage' => '<p>The text of the error message that is returned if the standby WorkSpace could not be created.</p>', 'FailedCreateWorkspaceRequest$ErrorMessage' => '<p>The text of the error message that is returned if the WorkSpace cannot be created.</p>', 'FailedWorkspaceChangeRequest$ErrorMessage' => '<p>The text of the error message that is returned if the WorkSpace cannot be rebooted.</p>', 'Workspace$ErrorMessage' => '<p>The text of the error message that is returned if the WorkSpace cannot be created.</p>', 'WorkspaceBundle$Description' => '<p>The description of the bundle.</p>', 'WorkspaceDirectory$ErrorMessage' => '<p>The error message returned.</p>', 'WorkspaceImage$ErrorMessage' => '<p>The text of the error message that is returned for the image.</p>', ], ], 'DesiredUserSessions' => [ 'base' => NULL, 'refs' => [ 'Capacity$DesiredUserSessions' => '<p>The desired number of user sessions for a multi-session pool. This is not allowed for single-session pools.</p>', 'CapacityStatus$DesiredUserSessions' => '<p>The total number of sessions slots that are either running or pending. This represents the total number of concurrent streaming sessions your pool can support in a steady state.</p>', ], ], 'DirectoryId' => [ 'base' => NULL, 'refs' => [ 'AssociateIpGroupsRequest$DirectoryId' => '<p>The identifier of the directory.</p>', 'ConnectClientAddIn$ResourceId' => '<p>The directory identifier for which the client add-in is configured.</p>', 'CreateConnectClientAddInRequest$ResourceId' => '<p>The directory identifier for which to configure the client add-in.</p>', 'CreateWorkspacesPoolRequest$DirectoryId' => '<p>The identifier of the directory for the pool.</p>', 'DeleteClientBrandingRequest$ResourceId' => '<p>The directory identifier of the WorkSpace for which you want to delete client branding.</p>', 'DeleteConnectClientAddInRequest$ResourceId' => '<p>The directory identifier for which the client add-in is configured.</p>', 'DeregisterWorkspaceDirectoryRequest$DirectoryId' => '<p>The identifier of the directory. If any WorkSpaces are registered to this directory, you must remove them before you deregister the directory, or you will receive an OperationNotSupportedException error.</p>', 'DescribeClientBrandingRequest$ResourceId' => '<p>The directory identifier of the WorkSpace for which you want to view client branding information.</p>', 'DescribeConnectClientAddInsRequest$ResourceId' => '<p>The directory identifier for which the client add-in is configured.</p>', 'DescribeWorkspacesRequest$DirectoryId' => '<p>The identifier of the directory. In addition, you can optionally specify a specific directory user (see <code>UserName</code>). You cannot combine this parameter with any other filter.</p>', 'DirectoryIdList$member' => NULL, 'DisassociateIpGroupsRequest$DirectoryId' => '<p>The identifier of the directory.</p>', 'ImportClientBrandingRequest$ResourceId' => '<p>The directory identifier of the WorkSpace for which you want to import client branding.</p>', 'ModifyCertificateBasedAuthPropertiesRequest$ResourceId' => '<p>The resource identifiers, in the form of directory IDs.</p>', 'ModifySamlPropertiesRequest$ResourceId' => '<p>The directory identifier for which you want to configure SAML properties.</p>', 'ModifySelfservicePermissionsRequest$ResourceId' => '<p>The identifier of the directory.</p>', 'ModifyStreamingPropertiesRequest$ResourceId' => '<p>The identifier of the resource.</p>', 'ModifyWorkspaceAccessPropertiesRequest$ResourceId' => '<p>The identifier of the directory.</p>', 'ModifyWorkspaceCreationPropertiesRequest$ResourceId' => '<p>The identifier of the directory.</p>', 'PendingCreateStandbyWorkspacesRequest$DirectoryId' => '<p>The identifier of the directory for the standby WorkSpace.</p>', 'RegisterWorkspaceDirectoryRequest$DirectoryId' => '<p>The identifier of the directory. You cannot register a directory if it does not have a status of Active. If the directory does not have a status of Active, you will receive an InvalidResourceStateException error. If you have already registered the maximum number of directories that you can register with Amazon WorkSpaces, you will receive a ResourceLimitExceededException error. Deregister directories that you are not using for WorkSpaces, and try again.</p>', 'RegisterWorkspaceDirectoryResult$DirectoryId' => '<p>The identifier of the directory.</p>', 'StandbyWorkspace$DirectoryId' => '<p>The identifier of the directory for the standby WorkSpace.</p>', 'UpdateConnectClientAddInRequest$ResourceId' => '<p>The directory identifier for which the client add-in is configured.</p>', 'UpdateWorkspacesPoolRequest$DirectoryId' => '<p>The identifier of the directory.</p>', 'Workspace$DirectoryId' => '<p>The identifier of the Directory Service directory for the WorkSpace.</p>', 'WorkspaceDirectory$DirectoryId' => '<p>The directory identifier.</p>', 'WorkspaceRequest$DirectoryId' => '<p>The identifier of the Directory Service directory for the WorkSpace. You can use <a>DescribeWorkspaceDirectories</a> to list the available directories.</p>', 'WorkspacesPool$DirectoryId' => '<p>The identifier of the directory used by the pool.</p>', ], ], 'DirectoryIdList' => [ 'base' => NULL, 'refs' => [ 'DescribeWorkspaceDirectoriesRequest$DirectoryIds' => '<p>The identifiers of the directories. If the value is null, all directories are retrieved.</p>', ], ], 'DirectoryList' => [ 'base' => NULL, 'refs' => [ 'DescribeWorkspaceDirectoriesResult$Directories' => '<p>Information about the directories.</p>', ], ], 'DirectoryName' => [ 'base' => NULL, 'refs' => [ 'WorkspaceDirectory$DirectoryName' => '<p>The name of the directory.</p>', ], ], 'DisassociateConnectionAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateConnectionAliasResult' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateIpGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateIpGroupsResult' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateWorkspaceApplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateWorkspaceApplicationResult' => [ 'base' => NULL, 'refs' => [], ], 'DisconnectTimeoutInSeconds' => [ 'base' => NULL, 'refs' => [ 'TimeoutSettings$DisconnectTimeoutInSeconds' => '<p>Specifies the amount of time, in seconds, that a streaming session remains active after users disconnect. If users try to reconnect to the streaming session after a disconnection or network interruption within the time set, they are connected to their previous session. Otherwise, they are connected to a new session with a new streaming instance.</p>', ], ], 'DnsIpAddresses' => [ 'base' => NULL, 'refs' => [ 'WorkspaceDirectory$DnsIpAddresses' => '<p>The IP addresses of the DNS servers for the directory.</p>', ], ], 'DomainName' => [ 'base' => NULL, 'refs' => [ 'ActiveDirectoryConfig$DomainName' => '<p>The name of the domain.</p>', ], ], 'Ec2ImageId' => [ 'base' => NULL, 'refs' => [ 'ImportWorkspaceImageRequest$Ec2ImageId' => '<p>The identifier of the EC2 image.</p>', ], ], 'ErrorDetails' => [ 'base' => '<p>Describes in-depth details about the error. These details include the possible causes of the error and troubleshooting information.</p>', 'refs' => [ 'ErrorDetailsList$member' => NULL, ], ], 'ErrorDetailsList' => [ 'base' => NULL, 'refs' => [ 'WorkspaceImage$ErrorDetails' => '<p>Additional details of the error returned for the image, including the possible causes of the errors and troubleshooting information.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'WorkspacesPoolError$ErrorMessage' => '<p>The error message.</p>', ], ], 'ErrorType' => [ 'base' => NULL, 'refs' => [ 'FailedCreateWorkspaceRequest$ErrorCode' => '<p>The error code that is returned if the WorkSpace cannot be created.</p>', 'FailedWorkspaceChangeRequest$ErrorCode' => '<p>The error code that is returned if the WorkSpace cannot be rebooted.</p>', ], ], 'ExceptionErrorCode' => [ 'base' => NULL, 'refs' => [ 'OperationNotSupportedException$reason' => '<p>The exception error reason.</p>', ], ], 'ExceptionMessage' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'ConflictException$message' => NULL, 'InternalServerException$message' => NULL, 'InvalidParameterValuesException$message' => '<p>The exception error message.</p>', 'InvalidResourceStateException$message' => NULL, 'OperationInProgressException$message' => NULL, 'OperationNotSupportedException$message' => '<p>The exception error message.</p>', 'ResourceAlreadyExistsException$message' => NULL, 'ResourceAssociatedException$message' => NULL, 'ResourceCreationFailedException$message' => NULL, 'ResourceInUseException$message' => NULL, 'ResourceLimitExceededException$message' => '<p>The exception error message.</p>', 'ResourceNotFoundException$message' => '<p>The resource could not be found.</p>', 'ResourceUnavailableException$message' => '<p>The exception error message.</p>', 'UnsupportedNetworkConfigurationException$message' => NULL, 'UnsupportedWorkspaceConfigurationException$message' => NULL, 'ValidationException$message' => NULL, 'WorkspacesDefaultRoleNotFoundException$message' => NULL, ], ], 'FailedCreateStandbyWorkspacesRequest' => [ 'base' => '<p>Describes the standby WorkSpace that could not be created.</p>', 'refs' => [ 'FailedCreateStandbyWorkspacesRequestList$member' => NULL, ], ], 'FailedCreateStandbyWorkspacesRequestList' => [ 'base' => NULL, 'refs' => [ 'CreateStandbyWorkspacesResult$FailedStandbyRequests' => '<p>Information about the standby WorkSpace that could not be created. </p>', ], ], 'FailedCreateWorkspaceRequest' => [ 'base' => '<p>Describes a WorkSpace that cannot be created.</p>', 'refs' => [ 'FailedCreateWorkspaceRequests$member' => NULL, ], ], 'FailedCreateWorkspaceRequests' => [ 'base' => NULL, 'refs' => [ 'CreateWorkspacesResult$FailedRequests' => '<p>Information about the WorkSpaces that could not be created.</p>', ], ], 'FailedRebootWorkspaceRequests' => [ 'base' => NULL, 'refs' => [ 'RebootWorkspacesResult$FailedRequests' => '<p>Information about the WorkSpaces that could not be rebooted.</p>', ], ], 'FailedRebuildWorkspaceRequests' => [ 'base' => NULL, 'refs' => [ 'RebuildWorkspacesResult$FailedRequests' => '<p>Information about the WorkSpace that could not be rebuilt.</p>', ], ], 'FailedStartWorkspaceRequests' => [ 'base' => NULL, 'refs' => [ 'StartWorkspacesResult$FailedRequests' => '<p>Information about the WorkSpaces that could not be started.</p>', ], ], 'FailedStopWorkspaceRequests' => [ 'base' => NULL, 'refs' => [ 'StopWorkspacesResult$FailedRequests' => '<p>Information about the WorkSpaces that could not be stopped.</p>', ], ], 'FailedTerminateWorkspaceRequests' => [ 'base' => NULL, 'refs' => [ 'TerminateWorkspacesResult$FailedRequests' => '<p>Information about the WorkSpaces that could not be terminated.</p>', ], ], 'FailedWorkspaceChangeRequest' => [ 'base' => '<p>Describes a WorkSpace that could not be rebooted. (<a>RebootWorkspaces</a>), rebuilt (<a>RebuildWorkspaces</a>), restored (<a>RestoreWorkspace</a>), terminated (<a>TerminateWorkspaces</a>), started (<a>StartWorkspaces</a>), or stopped (<a>StopWorkspaces</a>).</p>', 'refs' => [ 'FailedRebootWorkspaceRequests$member' => NULL, 'FailedRebuildWorkspaceRequests$member' => NULL, 'FailedStartWorkspaceRequests$member' => NULL, 'FailedStopWorkspaceRequests$member' => NULL, 'FailedTerminateWorkspaceRequests$member' => NULL, ], ], 'GetAccountLinkRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAccountLinkResult' => [ 'base' => NULL, 'refs' => [], ], 'IdleDisconnectTimeoutInSeconds' => [ 'base' => NULL, 'refs' => [ 'TimeoutSettings$IdleDisconnectTimeoutInSeconds' => '<p>The amount of time in seconds a connection will stay active while idle.</p>', ], ], 'ImageAssociatedResourceType' => [ 'base' => NULL, 'refs' => [ 'ImageAssociatedResourceTypeList$member' => NULL, 'ImageResourceAssociation$AssociatedResourceType' => '<p>The resource type of the associated resources.</p>', ], ], 'ImageAssociatedResourceTypeList' => [ 'base' => NULL, 'refs' => [ 'DescribeImageAssociationsRequest$AssociatedResourceTypes' => '<p>The resource types of the associated resource.</p>', ], ], 'ImagePermission' => [ 'base' => '<p>Describes the Amazon Web Services accounts that have been granted permission to use a shared image. For more information about sharing images, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/share-custom-image.html"> Share or Unshare a Custom WorkSpaces Image</a>.</p>', 'refs' => [ 'ImagePermissions$member' => NULL, ], ], 'ImagePermissions' => [ 'base' => NULL, 'refs' => [ 'DescribeWorkspaceImagePermissionsResult$ImagePermissions' => '<p>The identifiers of the Amazon Web Services accounts that the image has been shared with.</p>', ], ], 'ImageResourceAssociation' => [ 'base' => '<p>Describes the association between an application and an image resource.</p>', 'refs' => [ 'ImageResourceAssociationList$member' => NULL, ], ], 'ImageResourceAssociationList' => [ 'base' => NULL, 'refs' => [ 'DescribeImageAssociationsResult$Associations' => '<p>List of information about the specified associations.</p>', ], ], 'ImageType' => [ 'base' => NULL, 'refs' => [ 'DescribeWorkspaceImagesRequest$ImageType' => '<p>The type (owned or shared) of the image.</p>', ], ], 'ImportClientBrandingRequest' => [ 'base' => NULL, 'refs' => [], ], 'ImportClientBrandingResult' => [ 'base' => NULL, 'refs' => [], ], 'ImportWorkspaceImageRequest' => [ 'base' => NULL, 'refs' => [], ], 'ImportWorkspaceImageResult' => [ 'base' => NULL, 'refs' => [], ], 'IncompatibleApplicationsException' => [ 'base' => '<p>The specified application is not compatible with the resource.</p>', 'refs' => [], ], 'InternalServerException' => [ 'base' => '<p>Unexpected server error occured.</p>', 'refs' => [], ], 'InvalidParameterValuesException' => [ 'base' => '<p>One or more parameter values are not valid.</p>', 'refs' => [], ], 'InvalidResourceStateException' => [ 'base' => '<p>The state of the resource is not valid for this operation.</p>', 'refs' => [], ], 'Ios2XLogo' => [ 'base' => NULL, 'refs' => [ 'IosImportClientBrandingAttributes$Logo2x' => '<p>The @2x version of the logo. This is the higher resolution display that offers a scale factor of 2.0 (or @2x). The only image format accepted is a binary data object that is converted from a <code>.png</code> file.</p> <note> <p> For more information about iOS image size and resolution, see <a href="https://developer.apple.com/design/human-interface-guidelines/ios/icons-and-images/image-size-and-resolution/">Image Size and Resolution </a> in the <i>Apple Human Interface Guidelines</i>.</p> </note>', ], ], 'Ios3XLogo' => [ 'base' => NULL, 'refs' => [ 'IosImportClientBrandingAttributes$Logo3x' => '<p>The @3x version of the logo. This is the higher resolution display that offers a scale factor of 3.0 (or @3x). The only image format accepted is a binary data object that is converted from a <code>.png</code> file.</p> <note> <p> For more information about iOS image size and resolution, see <a href="https://developer.apple.com/design/human-interface-guidelines/ios/icons-and-images/image-size-and-resolution/">Image Size and Resolution </a> in the <i>Apple Human Interface Guidelines</i>.</p> </note>', ], ], 'IosClientBrandingAttributes' => [ 'base' => '<p>The client branding attributes for iOS device types. These attributes are displayed on the iOS client login screen only.</p> <important> <p>Client branding attributes are public facing. Ensure you do not include sensitive information.</p> </important>', 'refs' => [ 'DescribeClientBrandingResult$DeviceTypeIos' => '<p>The branding information for iOS devices.</p>', 'ImportClientBrandingResult$DeviceTypeIos' => '<p>The branding information configured for iOS devices.</p>', ], ], 'IosImportClientBrandingAttributes' => [ 'base' => '<p>The client branding attributes to import for iOS device types. These attributes are displayed on the iOS client login screen.</p> <important> <p>Client branding attributes are public facing. Ensure you do not include sensitive information.</p> </important>', 'refs' => [ 'ImportClientBrandingRequest$DeviceTypeIos' => '<p>The branding information to import for iOS devices.</p>', ], ], 'IosLogo' => [ 'base' => NULL, 'refs' => [ 'IosImportClientBrandingAttributes$Logo' => '<p>The logo. This is the standard-resolution display that has a 1:1 pixel density (or @1x), where one pixel is equal to one point. The only image format accepted is a binary data object that is converted from a <code>.png</code> file.</p>', ], ], 'IpAddress' => [ 'base' => NULL, 'refs' => [ 'DnsIpAddresses$member' => NULL, 'Workspace$IpAddress' => '<p>The IP address of the WorkSpace.</p>', ], ], 'IpGroupDesc' => [ 'base' => NULL, 'refs' => [ 'CreateIpGroupRequest$GroupDesc' => '<p>The description of the group.</p>', 'WorkspacesIpGroup$groupDesc' => '<p>The description of the group.</p>', ], ], 'IpGroupId' => [ 'base' => NULL, 'refs' => [ 'AuthorizeIpRulesRequest$GroupId' => '<p>The identifier of the group.</p>', 'CreateIpGroupResult$GroupId' => '<p>The identifier of the group.</p>', 'DeleteIpGroupRequest$GroupId' => '<p>The identifier of the IP access control group.</p>', 'IpGroupIdList$member' => NULL, 'RevokeIpRulesRequest$GroupId' => '<p>The identifier of the group.</p>', 'UpdateRulesOfIpGroupRequest$GroupId' => '<p>The identifier of the group.</p>', 'WorkspacesIpGroup$groupId' => '<p>The identifier of the group.</p>', ], ], 'IpGroupIdList' => [ 'base' => NULL, 'refs' => [ 'AssociateIpGroupsRequest$GroupIds' => '<p>The identifiers of one or more IP access control groups.</p>', 'DescribeIpGroupsRequest$GroupIds' => '<p>The identifiers of one or more IP access control groups.</p>', 'DisassociateIpGroupsRequest$GroupIds' => '<p>The identifiers of one or more IP access control groups.</p>', 'WorkspaceDirectory$ipGroupIds' => '<p>The identifiers of the IP access control groups associated with the directory.</p>', ], ], 'IpGroupName' => [ 'base' => NULL, 'refs' => [ 'CreateIpGroupRequest$GroupName' => '<p>The name of the group.</p>', 'WorkspacesIpGroup$groupName' => '<p>The name of the group.</p>', ], ], 'IpRevokedRuleList' => [ 'base' => NULL, 'refs' => [ 'RevokeIpRulesRequest$UserRules' => '<p>The rules to remove from the group.</p>', ], ], 'IpRule' => [ 'base' => NULL, 'refs' => [ 'IpRevokedRuleList$member' => NULL, 'IpRuleItem$ipRule' => '<p>The IP address range, in CIDR notation.</p>', ], ], 'IpRuleDesc' => [ 'base' => NULL, 'refs' => [ 'IpRuleItem$ruleDesc' => '<p>The description.</p>', ], ], 'IpRuleItem' => [ 'base' => '<p>Describes a rule for an IP access control group.</p>', 'refs' => [ 'IpRuleList$member' => NULL, ], ], 'IpRuleList' => [ 'base' => NULL, 'refs' => [ 'AuthorizeIpRulesRequest$UserRules' => '<p>The rules to add to the group.</p>', 'CreateIpGroupRequest$UserRules' => '<p>The rules to add to the group.</p>', 'UpdateRulesOfIpGroupRequest$UserRules' => '<p>One or more rules.</p>', 'WorkspacesIpGroup$userRules' => '<p>The rules.</p>', ], ], 'Limit' => [ 'base' => NULL, 'refs' => [ 'DescribeApplicationAssociationsRequest$MaxResults' => '<p>The maximum number of associations to return.</p>', 'DescribeApplicationsRequest$MaxResults' => '<p>The maximum number of applications to return.</p>', 'DescribeConnectClientAddInsRequest$MaxResults' => '<p>The maximum number of items to return.</p>', 'DescribeConnectionAliasPermissionsRequest$MaxResults' => '<p>The maximum number of results to return.</p>', 'DescribeConnectionAliasesRequest$Limit' => '<p>The maximum number of connection aliases to return.</p>', 'DescribeIpGroupsRequest$MaxResults' => '<p>The maximum number of items to return.</p>', 'DescribeWorkspaceDirectoriesRequest$Limit' => '<p>The maximum number of directories to return.</p>', 'DescribeWorkspaceImagePermissionsRequest$MaxResults' => '<p>The maximum number of items to return.</p>', 'DescribeWorkspaceImagesRequest$MaxResults' => '<p>The maximum number of items to return.</p>', 'DescribeWorkspacesPoolsRequest$Limit' => '<p>The maximum number of items to return.</p>', 'DescribeWorkspacesRequest$Limit' => '<p>The maximum number of items to return.</p>', 'ListAccountLinksRequest$MaxResults' => '<p>The maximum number of accounts to return.</p>', ], ], 'Limit50' => [ 'base' => NULL, 'refs' => [ 'DescribeWorkspacesPoolSessionsRequest$Limit' => '<p>The maximum number of items to return.</p>', ], ], 'LinkId' => [ 'base' => NULL, 'refs' => [ 'AcceptAccountLinkInvitationRequest$LinkId' => '<p>The identifier of the account link.</p>', 'AccountLink$AccountLinkId' => '<p>The identifier of the account link.</p>', 'DeleteAccountLinkInvitationRequest$LinkId' => '<p>The identifier of the account link.</p>', 'GetAccountLinkRequest$LinkId' => '<p>The identifier of the account to link.</p>', 'RejectAccountLinkInvitationRequest$LinkId' => '<p>The identifier of the account link</p>', ], ], 'LinkStatusFilterList' => [ 'base' => NULL, 'refs' => [ 'ListAccountLinksRequest$LinkStatusFilter' => '<p>Filters the account based on their link status.</p>', ], ], 'ListAccountLinksRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAccountLinksResult' => [ 'base' => NULL, 'refs' => [], ], 'ListAvailableManagementCidrRangesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAvailableManagementCidrRangesResult' => [ 'base' => NULL, 'refs' => [], ], 'LogUploadEnum' => [ 'base' => NULL, 'refs' => [ 'ClientProperties$LogUploadEnabled' => '<p>Specifies whether users can upload diagnostic log files of Amazon WorkSpaces client directly to WorkSpaces to troubleshoot issues when using the WorkSpaces client. When enabled, the log files will be sent to WorkSpaces automatically and will be applied to all users in the specified directory.</p>', ], ], 'LoginMessage' => [ 'base' => NULL, 'refs' => [ 'DefaultClientBrandingAttributes$LoginMessage' => '<p>The login message. Specified as a key value pair, in which the key is a locale and the value is the localized message for that locale. The only key supported is <code>en_US</code>. The HTML tags supported include the following: <code>a, b, blockquote, br, cite, code, dd, dl, dt, div, em, i, li, ol, p, pre, q, small, span, strike, strong, sub, sup, u, ul</code>.</p>', 'DefaultImportClientBrandingAttributes$LoginMessage' => '<p>The login message. Specified as a key value pair, in which the key is a locale and the value is the localized message for that locale. The only key supported is <code>en_US</code>. The HTML tags supported include the following: <code>a, b, blockquote, br, cite, code, dd, dl, dt, div, em, i, li, ol, p, pre, q, small, span, strike, strong, sub, sup, u, ul</code>.</p>', 'IosClientBrandingAttributes$LoginMessage' => '<p>The login message. Specified as a key value pair, in which the key is a locale and the value is the localized message for that locale. The only key supported is <code>en_US</code>. The HTML tags supported include the following: <code>a, b, blockquote, br, cite, code, dd, dl, dt, div, em, i, li, ol, p, pre, q, small, span, strike, strong, sub, sup, u, ul</code>.</p>', 'IosImportClientBrandingAttributes$LoginMessage' => '<p>The login message. Specified as a key value pair, in which the key is a locale and the value is the localized message for that locale. The only key supported is <code>en_US</code>. The HTML tags supported include the following: <code>a, b, blockquote, br, cite, code, dd, dl, dt, div, em, i, li, ol, p, pre, q, small, span, strike, strong, sub, sup, u, ul</code>.</p>', ], ], 'ManagementCidrRangeConstraint' => [ 'base' => NULL, 'refs' => [ 'ListAvailableManagementCidrRangesRequest$ManagementCidrRangeConstraint' => '<p>The IP address range to search. Specify an IP address range that is compatible with your network and in CIDR notation (that is, specify the range as an IPv4 CIDR block).</p>', ], ], 'ManagementCidrRangeMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListAvailableManagementCidrRangesRequest$MaxResults' => '<p>The maximum number of items to return.</p>', ], ], 'MaxUserDurationInSeconds' => [ 'base' => NULL, 'refs' => [ 'TimeoutSettings$MaxUserDurationInSeconds' => '<p>Specifies the maximum amount of time, in seconds, that a streaming session can remain active. If users are still connected to a streaming instance five minutes before this limit is reached, they are prompted to save any open documents before being disconnected. After this time elapses, the instance is terminated and replaced by a new instance.</p>', ], ], 'MaximumLength' => [ 'base' => NULL, 'refs' => [ 'UserSetting$MaximumLength' => '<p>Indicates the maximum character length for the specified user setting.</p>', ], ], 'MigrateWorkspaceRequest' => [ 'base' => NULL, 'refs' => [], ], 'MigrateWorkspaceResult' => [ 'base' => NULL, 'refs' => [], ], 'ModificationResourceEnum' => [ 'base' => NULL, 'refs' => [ 'ModificationState$Resource' => '<p>The resource.</p>', ], ], 'ModificationState' => [ 'base' => '<p>Describes a WorkSpace modification.</p>', 'refs' => [ 'ModificationStateList$member' => NULL, ], ], 'ModificationStateEnum' => [ 'base' => NULL, 'refs' => [ 'ModificationState$State' => '<p>The modification state.</p>', ], ], 'ModificationStateList' => [ 'base' => NULL, 'refs' => [ 'Workspace$ModificationStates' => '<p>The modification states of the WorkSpace.</p>', ], ], 'ModifyAccountRequest' => [ 'base' => NULL, 'refs' => [], ], 'ModifyAccountResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyCertificateBasedAuthPropertiesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ModifyCertificateBasedAuthPropertiesResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyClientPropertiesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ModifyClientPropertiesResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifySamlPropertiesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ModifySamlPropertiesResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifySelfservicePermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ModifySelfservicePermissionsResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyStreamingPropertiesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ModifyStreamingPropertiesResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyWorkspaceAccessPropertiesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ModifyWorkspaceAccessPropertiesResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyWorkspaceCreationPropertiesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ModifyWorkspaceCreationPropertiesResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyWorkspacePropertiesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ModifyWorkspacePropertiesResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyWorkspaceStateRequest' => [ 'base' => NULL, 'refs' => [], ], 'ModifyWorkspaceStateResult' => [ 'base' => NULL, 'refs' => [], ], 'NetworkAccessConfiguration' => [ 'base' => '<p>Describes the network details of a WorkSpaces Pool.</p>', 'refs' => [ 'WorkspacesPoolSession$NetworkAccessConfiguration' => '<p>Describes the network details of the pool.</p>', ], ], 'NonEmptyString' => [ 'base' => NULL, 'refs' => [ 'ApplicationResourceAssociation$AssociatedResourceId' => '<p>The identifier of the associated resource.</p>', 'AssociateConnectionAliasRequest$ResourceId' => '<p>The identifier of the directory to associate the connection alias with.</p>', 'BundleResourceAssociation$AssociatedResourceId' => '<p>The identifier of the associated resource.</p>', 'ClientPropertiesResult$ResourceId' => '<p>The resource identifier, in the form of a directory ID.</p>', 'ConnectionAliasAssociation$ResourceId' => '<p>The identifier of the directory associated with a connection alias.</p>', 'CreateTagsRequest$ResourceId' => '<p>The identifier of the WorkSpaces resource. The supported resource types are WorkSpaces, registered directories, images, custom bundles, IP access control groups, and connection aliases.</p>', 'DeleteTagsRequest$ResourceId' => '<p>The identifier of the WorkSpaces resource. The supported resource types are WorkSpaces, registered directories, images, custom bundles, IP access control groups, and connection aliases.</p>', 'DescribeConnectionAliasesRequest$ResourceId' => '<p>The identifier of the directory associated with the connection alias.</p>', 'DescribeTagsRequest$ResourceId' => '<p>The identifier of the WorkSpaces resource. The supported resource types are WorkSpaces, registered directories, images, custom bundles, IP access control groups, and connection aliases.</p>', 'ImageResourceAssociation$AssociatedResourceId' => '<p>The identifier of the associated resource.</p>', 'ModifyClientPropertiesRequest$ResourceId' => '<p>The resource identifiers, in the form of directory IDs.</p>', 'NetworkAccessConfiguration$EniPrivateIpAddress' => '<p>The private IP address of the elastic network interface that is attached to instances in your VPC.</p>', 'NetworkAccessConfiguration$EniId' => '<p>The resource identifier of the elastic network interface that is attached to instances in your VPC. All network interfaces have the eni-xxxxxxxx resource identifier.</p>', 'ResourceIdList$member' => NULL, 'ResourceInUseException$ResourceId' => '<p>The ID of the resource that is in use.</p>', 'ResourceNotFoundException$ResourceId' => '<p>The ID of the resource that could not be found.</p>', 'ResourceUnavailableException$ResourceId' => '<p>The identifier of the resource that is not available.</p>', 'RootStorage$Capacity' => '<p>The size of the root volume.</p>', 'SamlProperties$RelayStateParameterName' => '<p>The relay state parameter name supported by the SAML 2.0 identity provider (IdP). When the end user is redirected to the user access URL from the WorkSpaces client application, this relay state parameter name is appended as a query parameter to the URL along with the relay state endpoint to return the user to the client application session.</p> <p>To use SAML 2.0 authentication with WorkSpaces, the IdP must support IdP-initiated deep linking for the relay state URL. Consult your IdP documentation for more information.</p>', 'TagKeyList$member' => NULL, 'UserStorage$Capacity' => '<p>The size of the user volume.</p>', 'WorkSpaceApplication$Name' => '<p>The name of the WorkSpace application.</p>', 'WorkspaceBundle$Name' => '<p>The name of the bundle.</p>', 'WorkspaceResourceAssociation$AssociatedResourceId' => '<p>The identifier of the associated resource.</p>', ], ], 'OperatingSystem' => [ 'base' => '<p>The operating system that the image is running.</p>', 'refs' => [ 'CreateWorkspaceImageResult$OperatingSystem' => '<p>The operating system that the image is running.</p>', 'WorkspaceImage$OperatingSystem' => '<p>The operating system that the image is running. </p>', ], ], 'OperatingSystemName' => [ 'base' => NULL, 'refs' => [ 'OperatingSystemNameList$member' => NULL, 'WorkspaceProperties$OperatingSystemName' => '<p>The name of the operating system.</p>', ], ], 'OperatingSystemNameList' => [ 'base' => NULL, 'refs' => [ 'DescribeApplicationsRequest$OperatingSystemNames' => '<p>The operating systems supported by the applications.</p>', 'WorkSpaceApplication$SupportedOperatingSystemNames' => '<p>The supported operating systems of the WorkSpace application.</p>', ], ], 'OperatingSystemNotCompatibleException' => [ 'base' => '<p>The operating system of the WorkSpace is not compatible with the application.</p>', 'refs' => [], ], 'OperatingSystemType' => [ 'base' => NULL, 'refs' => [ 'OperatingSystem$Type' => '<p>The operating system.</p>', ], ], 'OperationInProgressException' => [ 'base' => '<p>The properties of this WorkSpace are currently being modified. Try again in a moment.</p>', 'refs' => [], ], 'OperationNotSupportedException' => [ 'base' => '<p>This operation is not supported.</p>', 'refs' => [], ], 'PaginationToken' => [ 'base' => NULL, 'refs' => [ 'DescribeAccountModificationsRequest$NextToken' => '<p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results.</p>', 'DescribeAccountModificationsResult$NextToken' => '<p>The token to use to retrieve the next page of results. This value is null when there are no more results to return. </p>', 'DescribeApplicationAssociationsRequest$NextToken' => '<p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results.</p>', 'DescribeApplicationAssociationsResult$NextToken' => '<p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results.</p>', 'DescribeApplicationsRequest$NextToken' => '<p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results.</p>', 'DescribeApplicationsResult$NextToken' => '<p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results.</p>', 'DescribeConnectClientAddInsRequest$NextToken' => '<p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results.</p>', 'DescribeConnectClientAddInsResult$NextToken' => '<p>The token to use to retrieve the next page of results. This value is null when there are no more results to return. </p>', 'DescribeConnectionAliasPermissionsRequest$NextToken' => '<p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results. </p>', 'DescribeConnectionAliasPermissionsResult$NextToken' => '<p>The token to use to retrieve the next page of results. This value is null when there are no more results to return. </p>', 'DescribeConnectionAliasesRequest$NextToken' => '<p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results. </p>', 'DescribeConnectionAliasesResult$NextToken' => '<p>The token to use to retrieve the next page of results. This value is null when there are no more results to return. </p>', 'DescribeIpGroupsRequest$NextToken' => '<p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results.</p>', 'DescribeIpGroupsResult$NextToken' => '<p>The token to use to retrieve the next page of results. This value is null when there are no more results to return. </p>', 'DescribeWorkspaceBundlesRequest$NextToken' => '<p>The token for the next set of results. (You received this token from a previous call.)</p>', 'DescribeWorkspaceBundlesResult$NextToken' => '<p>The token to use to retrieve the next page of results. This value is null when there are no more results to return. This token is valid for one day and must be used within that time frame.</p>', 'DescribeWorkspaceDirectoriesRequest$NextToken' => '<p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results.</p>', 'DescribeWorkspaceDirectoriesResult$NextToken' => '<p>The token to use to retrieve the next page of results. This value is null when there are no more results to return. </p>', 'DescribeWorkspaceImagePermissionsRequest$NextToken' => '<p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results.</p>', 'DescribeWorkspaceImagePermissionsResult$NextToken' => '<p>The token to use to retrieve the next page of results. This value is null when there are no more results to return. </p>', 'DescribeWorkspaceImagesRequest$NextToken' => '<p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results.</p>', 'DescribeWorkspaceImagesResult$NextToken' => '<p>The token to use to retrieve the next page of results. This value is null when there are no more results to return. </p>', 'DescribeWorkspacesConnectionStatusRequest$NextToken' => '<p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results.</p>', 'DescribeWorkspacesConnectionStatusResult$NextToken' => '<p>The token to use to retrieve the next page of results. This value is null when there are no more results to return. </p>', 'DescribeWorkspacesPoolSessionsRequest$NextToken' => '<p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results.</p>', 'DescribeWorkspacesPoolSessionsResult$NextToken' => '<p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results.</p>', 'DescribeWorkspacesPoolsRequest$NextToken' => '<p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results.</p>', 'DescribeWorkspacesPoolsResult$NextToken' => '<p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results.</p>', 'DescribeWorkspacesRequest$NextToken' => '<p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results.</p>', 'DescribeWorkspacesResult$NextToken' => '<p>The token to use to retrieve the next page of results. This value is null when there are no more results to return. </p>', 'ListAccountLinksRequest$NextToken' => '<p>The token to use to retrieve the next page of results. This value is null when there are no more results to return.</p>', 'ListAccountLinksResult$NextToken' => '<p>The token to use to retrieve the next page of results. This value is null when there are no more results to return.</p>', 'ListAvailableManagementCidrRangesRequest$NextToken' => '<p>If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive the next set of results.</p>', 'ListAvailableManagementCidrRangesResult$NextToken' => '<p>The token to use to retrieve the next page of results. This value is null when there are no more results to return. </p>', ], ], 'PendingCreateStandbyWorkspacesRequest' => [ 'base' => '<p>Information about the standby WorkSpace.</p>', 'refs' => [ 'PendingCreateStandbyWorkspacesRequestList$member' => NULL, ], ], 'PendingCreateStandbyWorkspacesRequestList' => [ 'base' => NULL, 'refs' => [ 'CreateStandbyWorkspacesResult$PendingStandbyRequests' => '<p>Information about the standby WorkSpace that was created.</p>', ], ], 'Protocol' => [ 'base' => NULL, 'refs' => [ 'ProtocolList$member' => NULL, ], ], 'ProtocolList' => [ 'base' => NULL, 'refs' => [ 'WorkspaceProperties$Protocols' => '<p>The protocol. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/amazon-workspaces-protocols.html"> Protocols for Amazon WorkSpaces</a>.</p> <note> <ul> <li> <p>Only available for WorkSpaces created with PCoIP bundles.</p> </li> <li> <p>The <code>Protocols</code> property is case sensitive. Ensure you use <code>PCOIP</code> or <code>WSP</code>.</p> </li> <li> <p>Unavailable for Windows 7 WorkSpaces and WorkSpaces using GPU-based bundles (Graphics, GraphicsPro, Graphics.g4dn, and GraphicsPro.g4dn).</p> </li> </ul> </note>', ], ], 'RebootRequest' => [ 'base' => '<p>Describes the information used to reboot a WorkSpace.</p>', 'refs' => [ 'RebootWorkspaceRequests$member' => NULL, ], ], 'RebootWorkspaceRequests' => [ 'base' => NULL, 'refs' => [ 'RebootWorkspacesRequest$RebootWorkspaceRequests' => '<p>The WorkSpaces to reboot. You can specify up to 25 WorkSpaces.</p>', ], ], 'RebootWorkspacesRequest' => [ 'base' => NULL, 'refs' => [], ], 'RebootWorkspacesResult' => [ 'base' => NULL, 'refs' => [], ], 'RebuildRequest' => [ 'base' => '<p>Describes the information used to rebuild a WorkSpace.</p>', 'refs' => [ 'RebuildWorkspaceRequests$member' => NULL, ], ], 'RebuildWorkspaceRequests' => [ 'base' => NULL, 'refs' => [ 'RebuildWorkspacesRequest$RebuildWorkspaceRequests' => '<p>The WorkSpace to rebuild. You can specify a single WorkSpace.</p>', ], ], 'RebuildWorkspacesRequest' => [ 'base' => NULL, 'refs' => [], ], 'RebuildWorkspacesResult' => [ 'base' => NULL, 'refs' => [], ], 'ReconnectEnum' => [ 'base' => NULL, 'refs' => [ 'ClientProperties$ReconnectEnabled' => '<p>Specifies whether users can cache their credentials on the Amazon WorkSpaces client. When enabled, users can choose to reconnect to their WorkSpaces without re-entering their credentials. </p>', 'SelfservicePermissions$RestartWorkspace' => '<p>Specifies whether users can restart their WorkSpace.</p>', 'SelfservicePermissions$IncreaseVolumeSize' => '<p>Specifies whether users can increase the volume size of the drives on their WorkSpace.</p>', 'SelfservicePermissions$ChangeComputeType' => '<p>Specifies whether users can change the compute type (bundle) for their WorkSpace.</p>', 'SelfservicePermissions$SwitchRunningMode' => '<p>Specifies whether users can switch the running mode of their WorkSpace.</p>', 'SelfservicePermissions$RebuildWorkspace' => '<p>Specifies whether users can rebuild the operating system of a WorkSpace to its original state.</p>', ], ], 'Region' => [ 'base' => NULL, 'refs' => [ 'CopyWorkspaceImageRequest$SourceRegion' => '<p>The identifier of the source Region.</p>', 'CreateStandbyWorkspacesRequest$PrimaryRegion' => '<p>The Region of the primary WorkSpace.</p>', 'RelatedWorkspaceProperties$Region' => '<p>The Region of the related WorkSpace.</p>', ], ], 'RegisterWorkspaceDirectoryRequest' => [ 'base' => NULL, 'refs' => [], ], 'RegisterWorkspaceDirectoryResult' => [ 'base' => NULL, 'refs' => [], ], 'RegistrationCode' => [ 'base' => NULL, 'refs' => [ 'WorkspaceDirectory$RegistrationCode' => '<p>The registration code for the directory. This is the code that users enter in their Amazon WorkSpaces client application to connect to the directory.</p>', ], ], 'RejectAccountLinkInvitationRequest' => [ 'base' => NULL, 'refs' => [], ], 'RejectAccountLinkInvitationResult' => [ 'base' => NULL, 'refs' => [], ], 'RelatedWorkspaceProperties' => [ 'base' => '<p>Describes the related WorkSpace. The related WorkSpace could be a standby WorkSpace or primary WorkSpace related to the specified WorkSpace.</p>', 'refs' => [ 'RelatedWorkspaces$member' => NULL, ], ], 'RelatedWorkspaces' => [ 'base' => NULL, 'refs' => [ 'Workspace$RelatedWorkspaces' => '<p>The standby WorkSpace or primary WorkSpace related to the specified WorkSpace.</p>', ], ], 'ResourceAlreadyExistsException' => [ 'base' => '<p>The specified resource already exists.</p>', 'refs' => [], ], 'ResourceAssociatedException' => [ 'base' => '<p>The resource is associated with a directory.</p>', 'refs' => [], ], 'ResourceCreationFailedException' => [ 'base' => '<p>The resource could not be created.</p>', 'refs' => [], ], 'ResourceIdList' => [ 'base' => NULL, 'refs' => [ 'DescribeClientPropertiesRequest$ResourceIds' => '<p>The resource identifier, in the form of directory IDs.</p>', ], ], 'ResourceInUseException' => [ 'base' => '<p>The specified resource is currently in use.</p>', 'refs' => [], ], 'ResourceLimitExceededException' => [ 'base' => '<p>Your resource limits have been exceeded.</p>', 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>The resource could not be found.</p>', 'refs' => [], ], 'ResourceUnavailableException' => [ 'base' => '<p>The specified resource is not available.</p>', 'refs' => [], ], 'RestoreWorkspaceRequest' => [ 'base' => NULL, 'refs' => [], ], 'RestoreWorkspaceResult' => [ 'base' => NULL, 'refs' => [], ], 'RevokeIpRulesRequest' => [ 'base' => NULL, 'refs' => [], ], 'RevokeIpRulesResult' => [ 'base' => NULL, 'refs' => [], ], 'RootStorage' => [ 'base' => '<p>Describes the root volume for a WorkSpace bundle.</p>', 'refs' => [ 'CreateWorkspaceBundleRequest$RootStorage' => NULL, 'WorkspaceBundle$RootStorage' => '<p>The size of the root volume.</p>', ], ], 'RootVolumeSizeGib' => [ 'base' => NULL, 'refs' => [ 'WorkspaceProperties$RootVolumeSizeGib' => '<p>The size of the root volume. For important information about how to modify the size of the root and user volumes, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/modify-workspaces.html">Modify a WorkSpace</a>.</p>', ], ], 'RunningMode' => [ 'base' => NULL, 'refs' => [ 'WorkspaceProperties$RunningMode' => '<p>The running mode. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/running-mode.html">Manage the WorkSpace Running Mode</a>.</p> <note> <p>The <code>MANUAL</code> value is only supported by Amazon WorkSpaces Core. Contact your account team to be allow-listed to use this value. For more information, see <a href="http://aws.amazon.com/workspaces/core/">Amazon WorkSpaces Core</a>.</p> </note>', ], ], 'RunningModeAutoStopTimeoutInMinutes' => [ 'base' => NULL, 'refs' => [ 'WorkspaceProperties$RunningModeAutoStopTimeoutInMinutes' => '<p>The time after a user logs off when WorkSpaces are automatically stopped. Configured in 60-minute intervals.</p>', ], ], 'S3BucketName' => [ 'base' => NULL, 'refs' => [ 'ApplicationSettingsResponse$S3BucketName' => '<p>The S3 bucket where users’ persistent application settings are stored. When persistent application settings are enabled for the first time for an account in an Amazon Web Services Region, an S3 bucket is created. The bucket is unique to the Amazon Web Services account and the Region.</p>', ], ], 'SamlProperties' => [ 'base' => '<p>Describes the enablement status, user access URL, and relay state parameter name that are used for configuring federation with an SAML 2.0 identity provider.</p>', 'refs' => [ 'ModifySamlPropertiesRequest$SamlProperties' => '<p>The properties for configuring SAML 2.0 authentication.</p>', 'WorkspaceDirectory$SamlProperties' => '<p>Describes the enablement status, user access URL, and relay state parameter name that are used for configuring federation with an SAML 2.0 identity provider.</p>', ], ], 'SamlStatusEnum' => [ 'base' => NULL, 'refs' => [ 'SamlProperties$Status' => '<p>Indicates the status of SAML 2.0 authentication. These statuses include the following.</p> <ul> <li> <p>If the setting is <code>DISABLED</code>, end users will be directed to login with their directory credentials.</p> </li> <li> <p>If the setting is <code>ENABLED</code>, end users will be directed to login via the user access URL. Users attempting to connect to WorkSpaces from a client application that does not support SAML 2.0 authentication will not be able to connect.</p> </li> <li> <p>If the setting is <code>ENABLED_WITH_DIRECTORY_LOGIN_FALLBACK</code>, end users will be directed to login via the user access URL on supported client applications, but will not prevent clients that do not support SAML 2.0 authentication from connecting as if SAML 2.0 authentication was disabled.</p> </li> </ul>', ], ], 'SamlUserAccessUrl' => [ 'base' => NULL, 'refs' => [ 'SamlProperties$UserAccessUrl' => '<p>The SAML 2.0 identity provider (IdP) user access URL is the URL a user would navigate to in their web browser in order to federate from the IdP and directly access the application, without any SAML 2.0 service provider (SP) bindings.</p>', ], ], 'SecretsManagerArn' => [ 'base' => NULL, 'refs' => [ 'ActiveDirectoryConfig$ServiceAccountSecretArn' => '<p>Indicates the secret ARN on the service account.</p>', ], ], 'SecurityGroupId' => [ 'base' => NULL, 'refs' => [ 'DefaultWorkspaceCreationProperties$CustomSecurityGroupId' => '<p>The identifier of the default security group to apply to WorkSpaces when they are created. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/amazon-workspaces-security-groups.html"> Security Groups for Your WorkSpaces</a>.</p>', 'WorkspaceCreationProperties$CustomSecurityGroupId' => '<p>The identifier of your custom security group.</p>', 'WorkspaceDirectory$WorkspaceSecurityGroupId' => '<p>The identifier of the security group that is assigned to new WorkSpaces.</p>', ], ], 'SelfservicePermissions' => [ 'base' => '<p>Describes the self-service permissions for a directory. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/enable-user-self-service-workspace-management.html">Enable Self-Service WorkSpace Management Capabilities for Your Users</a>.</p>', 'refs' => [ 'ModifySelfservicePermissionsRequest$SelfservicePermissions' => '<p>The permissions to enable or disable self-service capabilities.</p>', 'WorkspaceDirectory$SelfservicePermissions' => '<p>The default self-service permissions for WorkSpaces in the directory.</p>', ], ], 'SessionConnectionState' => [ 'base' => NULL, 'refs' => [ 'WorkspacesPoolSession$ConnectionState' => '<p>Specifies whether a user is connected to the pool session.</p>', ], ], 'SessionInstanceId' => [ 'base' => NULL, 'refs' => [ 'WorkspacesPoolSession$InstanceId' => '<p>The identifier for the instance hosting the session.</p>', ], ], 'SettingsGroup' => [ 'base' => NULL, 'refs' => [ 'ApplicationSettingsRequest$SettingsGroup' => '<p>The path prefix for the S3 bucket where users’ persistent application settings are stored. You can allow the same persistent application settings to be used across multiple pools by specifying the same settings group for each pool.</p>', 'ApplicationSettingsResponse$SettingsGroup' => '<p>The path prefix for the S3 bucket where users’ persistent application settings are stored.</p>', ], ], 'Snapshot' => [ 'base' => '<p>Describes a snapshot.</p>', 'refs' => [ 'SnapshotList$member' => NULL, ], ], 'SnapshotList' => [ 'base' => NULL, 'refs' => [ 'DescribeWorkspaceSnapshotsResult$RebuildSnapshots' => '<p>Information about the snapshots that can be used to rebuild a WorkSpace. These snapshots include the user volume.</p>', 'DescribeWorkspaceSnapshotsResult$RestoreSnapshots' => '<p>Information about the snapshots that can be used to restore a WorkSpace. These snapshots include both the root volume and the user volume.</p>', ], ], 'StandbyWorkspace' => [ 'base' => '<p>Describes a standby WorkSpace.</p>', 'refs' => [ 'FailedCreateStandbyWorkspacesRequest$StandbyWorkspaceRequest' => '<p>Information about the standby WorkSpace that could not be created.</p>', 'StandbyWorkspacesList$member' => NULL, ], ], 'StandbyWorkspaceRelationshipType' => [ 'base' => NULL, 'refs' => [ 'RelatedWorkspaceProperties$Type' => '<p>Indicates the type of WorkSpace.</p>', ], ], 'StandbyWorkspacesList' => [ 'base' => NULL, 'refs' => [ 'CreateStandbyWorkspacesRequest$StandbyWorkspaces' => '<p>Information about the standby WorkSpace to be created.</p>', ], ], 'StandbyWorkspacesProperties' => [ 'base' => '<p>Describes the properties of the related standby WorkSpaces. </p>', 'refs' => [ 'StandbyWorkspacesPropertiesList$member' => NULL, ], ], 'StandbyWorkspacesPropertiesList' => [ 'base' => NULL, 'refs' => [ 'Workspace$StandbyWorkspacesProperties' => '<p>The properties of the standby WorkSpace</p>', ], ], 'StartRequest' => [ 'base' => '<p>Information used to start a WorkSpace.</p>', 'refs' => [ 'StartWorkspaceRequests$member' => NULL, ], ], 'StartWorkspaceRequests' => [ 'base' => NULL, 'refs' => [ 'StartWorkspacesRequest$StartWorkspaceRequests' => '<p>The WorkSpaces to start. You can specify up to 25 WorkSpaces.</p>', ], ], 'StartWorkspacesPoolRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartWorkspacesPoolResult' => [ 'base' => NULL, 'refs' => [], ], 'StartWorkspacesRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartWorkspacesResult' => [ 'base' => NULL, 'refs' => [], ], 'StopRequest' => [ 'base' => '<p>Describes the information used to stop a WorkSpace.</p>', 'refs' => [ 'StopWorkspaceRequests$member' => NULL, ], ], 'StopWorkspaceRequests' => [ 'base' => NULL, 'refs' => [ 'StopWorkspacesRequest$StopWorkspaceRequests' => '<p>The WorkSpaces to stop. You can specify up to 25 WorkSpaces.</p>', ], ], 'StopWorkspacesPoolRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopWorkspacesPoolResult' => [ 'base' => NULL, 'refs' => [], ], 'StopWorkspacesRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopWorkspacesResult' => [ 'base' => NULL, 'refs' => [], ], 'StorageConnector' => [ 'base' => '<p>Describes the storage connector.</p>', 'refs' => [ 'StorageConnectors$member' => NULL, ], ], 'StorageConnectorStatusEnum' => [ 'base' => NULL, 'refs' => [ 'StorageConnector$Status' => '<p>Indicates if the storage connetor is enabled or disabled.</p>', ], ], 'StorageConnectorTypeEnum' => [ 'base' => NULL, 'refs' => [ 'StorageConnector$ConnectorType' => '<p>The type of connector used to save user files.</p>', ], ], 'StorageConnectors' => [ 'base' => NULL, 'refs' => [ 'StreamingProperties$StorageConnectors' => '<p>Indicates the storage connector used </p>', ], ], 'StreamingExperiencePreferredProtocolEnum' => [ 'base' => NULL, 'refs' => [ 'StreamingProperties$StreamingExperiencePreferredProtocol' => '<p>Indicates the type of preferred protocol for the streaming experience.</p>', ], ], 'StreamingProperties' => [ 'base' => '<p>Describes the streaming properties.</p>', 'refs' => [ 'ModifyStreamingPropertiesRequest$StreamingProperties' => '<p>The streaming properties to configure.</p>', 'WorkspaceDirectory$StreamingProperties' => '<p>The streaming properties to configure.</p>', ], ], 'String2048' => [ 'base' => NULL, 'refs' => [ 'AssociationStateReason$ErrorMessage' => '<p>The error message of the association deployment failure.</p>', 'WorkSpaceApplication$Description' => '<p>The description of the WorkSpace application.</p>', ], ], 'SubnetId' => [ 'base' => NULL, 'refs' => [ 'SubnetIds$member' => NULL, 'Workspace$SubnetId' => '<p>The identifier of the subnet for the WorkSpace.</p>', ], ], 'SubnetIds' => [ 'base' => NULL, 'refs' => [ 'RegisterWorkspaceDirectoryRequest$SubnetIds' => '<p>The identifiers of the subnets for your virtual private cloud (VPC). Make sure that the subnets are in supported Availability Zones. The subnets must also be in separate Availability Zones. If these conditions are not met, you will receive an OperationNotSupportedException error.</p>', 'WorkspaceDirectory$SubnetIds' => '<p>The identifiers of the subnets used with the directory.</p>', ], ], 'Tag' => [ 'base' => '<p>Describes a tag.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>The key of the tag.</p>', ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'DeleteTagsRequest$TagKeys' => '<p>The tag keys.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CopyWorkspaceImageRequest$Tags' => '<p>The tags for the image.</p>', 'CreateConnectionAliasRequest$Tags' => '<p>The tags to associate with the connection alias.</p>', 'CreateIpGroupRequest$Tags' => '<p>The tags. Each WorkSpaces resource can have a maximum of 50 tags.</p>', 'CreateTagsRequest$Tags' => '<p>The tags. Each WorkSpaces resource can have a maximum of 50 tags.</p>', 'CreateUpdatedWorkspaceImageRequest$Tags' => '<p>The tags that you want to add to the new updated WorkSpace image.</p> <note> <p>To add tags at the same time when you\'re creating the updated image, you must create an IAM policy that grants your IAM user permissions to use <code>workspaces:CreateTags</code>. </p> </note>', 'CreateWorkspaceBundleRequest$Tags' => '<p>The tags associated with the bundle.</p> <note> <p>To add tags at the same time when you\'re creating the bundle, you must create an IAM policy that grants your IAM user permissions to use <code>workspaces:CreateTags</code>. </p> </note>', 'CreateWorkspaceImageRequest$Tags' => '<p>The tags that you want to add to the new WorkSpace image. To add tags when you\'re creating the image, you must create an IAM policy that grants your IAM user permission to use <code>workspaces:CreateTags</code>.</p>', 'CreateWorkspacesPoolRequest$Tags' => '<p>The tags for the pool.</p>', 'DescribeTagsResult$TagList' => '<p>The tags.</p>', 'ImportWorkspaceImageRequest$Tags' => '<p>The tags. Each WorkSpaces resource can have a maximum of 50 tags.</p>', 'RegisterWorkspaceDirectoryRequest$Tags' => '<p>The tags associated with the directory.</p>', 'StandbyWorkspace$Tags' => '<p>The tags associated with the standby WorkSpace.</p>', 'WorkspaceRequest$Tags' => '<p>The tags for the WorkSpace.</p>', ], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The value of the tag.</p>', ], ], 'TargetWorkspaceState' => [ 'base' => NULL, 'refs' => [ 'ModifyWorkspaceStateRequest$WorkspaceState' => '<p>The WorkSpace state.</p>', ], ], 'Tenancy' => [ 'base' => NULL, 'refs' => [ 'RegisterWorkspaceDirectoryRequest$Tenancy' => '<p>Indicates whether your WorkSpace directory is dedicated or shared. To use Bring Your Own License (BYOL) images, this value must be set to <code>DEDICATED</code> and your Amazon Web Services account must be enabled for BYOL. If your account has not been enabled for BYOL, you will receive an InvalidParameterValuesException error. For more information about BYOL images, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html">Bring Your Own Windows Desktop Images</a>.</p>', 'WorkspaceDirectory$Tenancy' => '<p>Specifies whether the directory is dedicated or shared. To use Bring Your Own License (BYOL), this value must be set to <code>DEDICATED</code>. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html">Bring Your Own Windows Desktop Images</a>.</p>', ], ], 'TerminateRequest' => [ 'base' => '<p>Describes the information used to terminate a WorkSpace.</p>', 'refs' => [ 'TerminateWorkspaceRequests$member' => NULL, ], ], 'TerminateWorkspaceRequests' => [ 'base' => NULL, 'refs' => [ 'TerminateWorkspacesRequest$TerminateWorkspaceRequests' => '<p>The WorkSpaces to terminate. You can specify up to 25 WorkSpaces.</p>', ], ], 'TerminateWorkspacesPoolRequest' => [ 'base' => NULL, 'refs' => [], ], 'TerminateWorkspacesPoolResult' => [ 'base' => NULL, 'refs' => [], ], 'TerminateWorkspacesPoolSessionRequest' => [ 'base' => NULL, 'refs' => [], ], 'TerminateWorkspacesPoolSessionResult' => [ 'base' => NULL, 'refs' => [], ], 'TerminateWorkspacesRequest' => [ 'base' => NULL, 'refs' => [], ], 'TerminateWorkspacesResult' => [ 'base' => NULL, 'refs' => [], ], 'TimeoutSettings' => [ 'base' => '<p>Describes the timeout settings for a pool of WorkSpaces.</p>', 'refs' => [ 'CreateWorkspacesPoolRequest$TimeoutSettings' => '<p>Indicates the timeout settings of the pool.</p>', 'UpdateWorkspacesPoolRequest$TimeoutSettings' => '<p>Indicates the timeout settings of the specified pool.</p>', 'WorkspacesPool$TimeoutSettings' => '<p>The amount of time that a pool session remains active after users disconnect. If they try to reconnect to the pool session after a disconnection or network interruption within this time interval, they are connected to their previous session. Otherwise, they are connected to a new session with a new pool instance.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'AccountModification$StartTime' => '<p>The timestamp when the modification of the BYOL configuration was started.</p>', 'ApplicationResourceAssociation$Created' => '<p>The time the association was created.</p>', 'ApplicationResourceAssociation$LastUpdatedTime' => '<p>The time the association status was last updated.</p>', 'BundleResourceAssociation$Created' => '<p>The time the association is created.</p>', 'BundleResourceAssociation$LastUpdatedTime' => '<p>The time the association status was last updated.</p>', 'CreateWorkspaceImageResult$Created' => '<p>The date when the image was created.</p>', 'DataReplicationSettings$RecoverySnapshotTime' => '<p>The date and time at which the last successful snapshot was taken of the primary WorkSpace used for replicating data.</p>', 'ImageResourceAssociation$Created' => '<p>The time the association is created.</p>', 'ImageResourceAssociation$LastUpdatedTime' => '<p>The time the association status was last updated.</p>', 'Snapshot$SnapshotTime' => '<p>The time when the snapshot was created.</p>', 'StandbyWorkspacesProperties$RecoverySnapshotTime' => '<p>The date and time at which the last successful snapshot was taken of the primary WorkSpace used for replicating data.</p>', 'WorkSpaceApplication$Created' => '<p>The time the application is created.</p>', 'WorkspaceBundle$LastUpdatedTime' => '<p>The last time that the bundle was updated.</p>', 'WorkspaceBundle$CreationTime' => '<p>The time when the bundle was created.</p>', 'WorkspaceConnectionStatus$ConnectionStateCheckTimestamp' => '<p>The timestamp of the connection status check.</p>', 'WorkspaceConnectionStatus$LastKnownUserConnectionTimestamp' => '<p>The timestamp of the last known user connection.</p>', 'WorkspaceImage$Created' => '<p>The date when the image was created. If the image has been shared, the Amazon Web Services account that the image has been shared with sees the original creation date of the image.</p>', 'WorkspaceResourceAssociation$Created' => '<p>The time the association is created.</p>', 'WorkspaceResourceAssociation$LastUpdatedTime' => '<p>The time the association status was last updated.</p>', 'WorkspacesPool$CreatedAt' => '<p>The time the pool was created.</p>', 'WorkspacesPoolSession$ExpirationTime' => '<p>The time that the pool session ended.</p>', 'WorkspacesPoolSession$StartTime' => '<p>The time that the pool sission started.</p>', ], ], 'UnsupportedNetworkConfigurationException' => [ 'base' => '<p>The configuration of this network is not supported for this operation, or your network configuration conflicts with the Amazon WorkSpaces management network IP range. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/amazon-workspaces-vpc.html"> Configure a VPC for Amazon WorkSpaces</a>.</p>', 'refs' => [], ], 'UnsupportedWorkspaceConfigurationException' => [ 'base' => '<p>The configuration of this WorkSpace is not supported for this operation. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/required-service-components.html">Required Configuration and Service Components for WorkSpaces </a>.</p>', 'refs' => [], ], 'UpdateConnectClientAddInRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateConnectClientAddInResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateConnectionAliasPermissionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateConnectionAliasPermissionResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDescription' => [ 'base' => NULL, 'refs' => [ 'CreateWorkspacesPoolRequest$Description' => '<p>The pool description.</p>', 'UpdateResult$Description' => '<p>A description of whether updates for the WorkSpace image are pending or available.</p>', 'UpdateWorkspacesPoolRequest$Description' => '<p>Describes the specified pool to update.</p>', 'WorkspacesPool$Description' => '<p>The description of the pool.</p>', ], ], 'UpdateResult' => [ 'base' => '<p>Describes whether a WorkSpace image needs to be updated with the latest drivers and other components required by Amazon WorkSpaces.</p> <note> <p>Only Windows 10 WorkSpace images can be programmatically updated at this time.</p> </note>', 'refs' => [ 'WorkspaceImage$Updates' => '<p>The updates (if any) that are available for the specified image.</p>', ], ], 'UpdateRulesOfIpGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRulesOfIpGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateWorkspaceBundleRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateWorkspaceBundleResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateWorkspaceImagePermissionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateWorkspaceImagePermissionResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateWorkspacesPoolRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateWorkspacesPoolResult' => [ 'base' => NULL, 'refs' => [], ], 'UserIdentityType' => [ 'base' => NULL, 'refs' => [ 'RegisterWorkspaceDirectoryRequest$UserIdentityType' => '<p>The type of identity management the user is using.</p>', 'WorkspaceDirectory$UserIdentityType' => '<p>Indicates the identity type of the specifired user.</p>', ], ], 'UserName' => [ 'base' => NULL, 'refs' => [ 'DescribeWorkspacesRequest$UserName' => '<p>The name of the directory user. You must specify this parameter with <code>DirectoryId</code>.</p>', 'PendingCreateStandbyWorkspacesRequest$UserName' => '<p>Describes the standby WorkSpace that was created.</p> <p>Because this operation is asynchronous, the identifier returned is not immediately available for use with other operations. For example, if you call <a href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaces.html"> DescribeWorkspaces</a> before the WorkSpace is created, the information returned can be incomplete. </p>', 'Workspace$UserName' => '<p>The user for the WorkSpace.</p>', 'WorkspaceDirectory$CustomerUserName' => '<p>The user name for the service account.</p>', 'WorkspaceRequest$UserName' => '<p>The user name of the user for the WorkSpace. This user name must exist in the Directory Service directory for the WorkSpace.</p> <p>The reserved keyword, <code>[UNDEFINED]</code>, is used when creating user-decoupled WorkSpaces.</p>', ], ], 'UserSetting' => [ 'base' => '<p>Information about the user\'s permission settings.</p>', 'refs' => [ 'UserSettings$member' => NULL, ], ], 'UserSettingActionEnum' => [ 'base' => NULL, 'refs' => [ 'UserSetting$Action' => '<p>Indicates the type of action.</p>', ], ], 'UserSettingPermissionEnum' => [ 'base' => NULL, 'refs' => [ 'UserSetting$Permission' => '<p>Indicates if the setting is enabled or disabled.</p>', ], ], 'UserSettings' => [ 'base' => NULL, 'refs' => [ 'StreamingProperties$UserSettings' => '<p>Indicates the permission settings asscoiated with the user.</p>', ], ], 'UserStorage' => [ 'base' => '<p>Describes the user volume for a WorkSpace bundle.</p>', 'refs' => [ 'CreateWorkspaceBundleRequest$UserStorage' => NULL, 'WorkspaceBundle$UserStorage' => '<p>The size of the user volume.</p>', ], ], 'UserVolumeSizeGib' => [ 'base' => NULL, 'refs' => [ 'WorkspaceProperties$UserVolumeSizeGib' => '<p>The size of the user storage. For important information about how to modify the size of the root and user volumes, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/modify-workspaces.html">Modify a WorkSpace</a>.</p>', ], ], 'ValidationException' => [ 'base' => '<p>You either haven\'t provided a <code>TargetAccountId</code> or are using the same value for <code>TargetAccountId</code> and <code>SourceAccountId</code>.</p>', 'refs' => [], ], 'VolumeEncryptionKey' => [ 'base' => NULL, 'refs' => [ 'StandbyWorkspace$VolumeEncryptionKey' => '<p>The volume encryption key of the standby WorkSpace.</p>', 'Workspace$VolumeEncryptionKey' => '<p>The ARN of the symmetric KMS key used to encrypt data stored on your WorkSpace. Amazon WorkSpaces does not support asymmetric KMS keys.</p>', 'WorkspaceRequest$VolumeEncryptionKey' => '<p>The ARN of the symmetric KMS key used to encrypt data stored on your WorkSpace. Amazon WorkSpaces does not support asymmetric KMS keys.</p>', ], ], 'WorkSpaceApplication' => [ 'base' => '<p>Describes the WorkSpace application.</p>', 'refs' => [ 'WorkSpaceApplicationList$member' => NULL, ], ], 'WorkSpaceApplicationDeployment' => [ 'base' => '<p>Describes the WorkSpace application deployment.</p>', 'refs' => [ 'DeployWorkspaceApplicationsResult$Deployment' => '<p>The list of deployed associations and information about them.</p>', ], ], 'WorkSpaceApplicationId' => [ 'base' => NULL, 'refs' => [ 'ApplicationResourceAssociation$ApplicationId' => '<p>The identifier of the application.</p>', 'AssociateWorkspaceApplicationRequest$ApplicationId' => '<p>The identifier of the application.</p>', 'DescribeApplicationAssociationsRequest$ApplicationId' => '<p>The identifier of the specified application.</p>', 'DisassociateWorkspaceApplicationRequest$ApplicationId' => '<p>The identifier of the application.</p>', 'WorkSpaceApplication$ApplicationId' => '<p>The identifier of the application.</p>', 'WorkSpaceApplicationIdList$member' => NULL, ], ], 'WorkSpaceApplicationIdList' => [ 'base' => NULL, 'refs' => [ 'DescribeApplicationsRequest$ApplicationIds' => '<p>The identifiers of one or more applications.</p>', ], ], 'WorkSpaceApplicationLicenseType' => [ 'base' => NULL, 'refs' => [ 'DescribeApplicationsRequest$LicenseType' => '<p>The license availability for the applications.</p>', 'WorkSpaceApplication$LicenseType' => '<p>The license availability for the applications.</p>', ], ], 'WorkSpaceApplicationList' => [ 'base' => NULL, 'refs' => [ 'DescribeApplicationsResult$Applications' => '<p>List of information about the specified applications.</p>', ], ], 'WorkSpaceApplicationOwner' => [ 'base' => NULL, 'refs' => [ 'DescribeApplicationsRequest$Owner' => '<p>The owner of the applications.</p>', 'WorkSpaceApplication$Owner' => '<p>The owner of the WorkSpace application.</p>', ], ], 'WorkSpaceApplicationState' => [ 'base' => NULL, 'refs' => [ 'WorkSpaceApplication$State' => '<p>The status of WorkSpace application.</p>', ], ], 'WorkSpaceAssociatedResourceType' => [ 'base' => NULL, 'refs' => [ 'WorkSpaceAssociatedResourceTypeList$member' => NULL, 'WorkspaceResourceAssociation$AssociatedResourceType' => '<p>The resource types of the associated resource.</p>', ], ], 'WorkSpaceAssociatedResourceTypeList' => [ 'base' => NULL, 'refs' => [ 'DescribeWorkspaceAssociationsRequest$AssociatedResourceTypes' => '<p>The resource types of the associated resources.</p>', ], ], 'Workspace' => [ 'base' => '<p>Describes a WorkSpace.</p>', 'refs' => [ 'WorkspaceList$member' => NULL, ], ], 'WorkspaceAccessProperties' => [ 'base' => '<p>The device types and operating systems that can be used to access a WorkSpace. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/workspaces-network-requirements.html">Amazon WorkSpaces Client Network Requirements</a>.</p>', 'refs' => [ 'ModifyWorkspaceAccessPropertiesRequest$WorkspaceAccessProperties' => '<p>The device types and operating systems to enable or disable for access.</p>', 'WorkspaceDirectory$WorkspaceAccessProperties' => '<p>The devices and operating systems that users can use to access WorkSpaces.</p>', ], ], 'WorkspaceBundle' => [ 'base' => '<p>Describes a WorkSpace bundle.</p>', 'refs' => [ 'BundleList$member' => NULL, 'CreateWorkspaceBundleResult$WorkspaceBundle' => NULL, ], ], 'WorkspaceBundleDescription' => [ 'base' => NULL, 'refs' => [ 'CreateWorkspaceBundleRequest$BundleDescription' => '<p>The description of the bundle.</p>', ], ], 'WorkspaceBundleName' => [ 'base' => NULL, 'refs' => [ 'CreateWorkspaceBundleRequest$BundleName' => '<p>The name of the bundle.</p>', ], ], 'WorkspaceBundleState' => [ 'base' => NULL, 'refs' => [ 'WorkspaceBundle$State' => '<p>The state of the WorkSpace bundle.</p>', ], ], 'WorkspaceConnectionStatus' => [ 'base' => '<p>Describes the connection status of a WorkSpace.</p>', 'refs' => [ 'WorkspaceConnectionStatusList$member' => NULL, ], ], 'WorkspaceConnectionStatusList' => [ 'base' => NULL, 'refs' => [ 'DescribeWorkspacesConnectionStatusResult$WorkspacesConnectionStatus' => '<p>Information about the connection status of the WorkSpace.</p>', ], ], 'WorkspaceCreationProperties' => [ 'base' => '<p>Describes the default properties that are used for creating WorkSpaces. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/update-directory-details.html">Update Directory Details for Your WorkSpaces</a>. </p>', 'refs' => [ 'ModifyWorkspaceCreationPropertiesRequest$WorkspaceCreationProperties' => '<p>The default properties for creating WorkSpaces.</p>', ], ], 'WorkspaceDirectory' => [ 'base' => '<p>Describes a directory that is used with Amazon WorkSpaces.</p>', 'refs' => [ 'DirectoryList$member' => NULL, ], ], 'WorkspaceDirectoryDescription' => [ 'base' => NULL, 'refs' => [ 'RegisterWorkspaceDirectoryRequest$WorkspaceDirectoryDescription' => '<p>Description of the directory to register.</p>', 'WorkspaceDirectory$WorkspaceDirectoryDescription' => '<p>The description of the WorkSpace directory</p>', ], ], 'WorkspaceDirectoryName' => [ 'base' => NULL, 'refs' => [ 'RegisterWorkspaceDirectoryRequest$WorkspaceDirectoryName' => '<p>The name of the directory to register.</p>', 'WorkspaceDirectory$WorkspaceDirectoryName' => '<p>The name fo the WorkSpace directory.</p>', 'WorkspaceDirectoryNameList$member' => NULL, ], ], 'WorkspaceDirectoryNameList' => [ 'base' => NULL, 'refs' => [ 'DescribeWorkspaceDirectoriesRequest$WorkspaceDirectoryNames' => '<p>The names of the WorkSpace directories.</p>', ], ], 'WorkspaceDirectoryState' => [ 'base' => NULL, 'refs' => [ 'RegisterWorkspaceDirectoryResult$State' => '<p>The registration status of the WorkSpace directory.</p>', 'WorkspaceDirectory$State' => '<p>The state of the directory\'s registration with Amazon WorkSpaces. After a directory is deregistered, the <code>DEREGISTERED</code> state is returned very briefly before the directory metadata is cleaned up, so this state is rarely returned. To confirm that a directory is deregistered, check for the directory ID by using <a href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceDirectories.html"> DescribeWorkspaceDirectories</a>. If the directory ID isn\'t returned, then the directory has been successfully deregistered.</p>', ], ], 'WorkspaceDirectoryType' => [ 'base' => NULL, 'refs' => [ 'WorkspaceDirectory$DirectoryType' => '<p>The directory type.</p>', ], ], 'WorkspaceErrorCode' => [ 'base' => NULL, 'refs' => [ 'AccountModification$ErrorCode' => '<p>The error code that is returned if the configuration of BYOL cannot be modified.</p>', 'FailedCreateStandbyWorkspacesRequest$ErrorCode' => '<p>The error code that is returned if the standby WorkSpace could not be created.</p>', 'Workspace$ErrorCode' => '<p>The error code that is returned if the WorkSpace cannot be created.</p>', ], ], 'WorkspaceId' => [ 'base' => NULL, 'refs' => [ 'AssociateWorkspaceApplicationRequest$WorkspaceId' => '<p>The identifier of the WorkSpace.</p>', 'CreateWorkspaceImageRequest$WorkspaceId' => '<p>The identifier of the source WorkSpace</p>', 'DeployWorkspaceApplicationsRequest$WorkspaceId' => '<p>The identifier of the WorkSpace.</p>', 'DescribeWorkspaceAssociationsRequest$WorkspaceId' => '<p>The identifier of the WorkSpace.</p>', 'DescribeWorkspaceSnapshotsRequest$WorkspaceId' => '<p>The identifier of the WorkSpace.</p>', 'DisassociateWorkspaceApplicationRequest$WorkspaceId' => '<p>The identifier of the WorkSpace.</p>', 'FailedWorkspaceChangeRequest$WorkspaceId' => '<p>The identifier of the WorkSpace.</p>', 'MigrateWorkspaceRequest$SourceWorkspaceId' => '<p>The identifier of the WorkSpace to migrate from.</p>', 'MigrateWorkspaceResult$SourceWorkspaceId' => '<p>The original identifier of the WorkSpace that is being migrated.</p>', 'MigrateWorkspaceResult$TargetWorkspaceId' => '<p>The new identifier of the WorkSpace that is being migrated. If the migration does not succeed, the target WorkSpace ID will not be used, and the WorkSpace will still have the original WorkSpace ID.</p>', 'ModifyWorkspacePropertiesRequest$WorkspaceId' => '<p>The identifier of the WorkSpace.</p>', 'ModifyWorkspaceStateRequest$WorkspaceId' => '<p>The identifier of the WorkSpace.</p>', 'PendingCreateStandbyWorkspacesRequest$WorkspaceId' => '<p>The identifier of the standby WorkSpace.</p>', 'RebootRequest$WorkspaceId' => '<p>The identifier of the WorkSpace.</p>', 'RebuildRequest$WorkspaceId' => '<p>The identifier of the WorkSpace.</p>', 'RelatedWorkspaceProperties$WorkspaceId' => '<p>The identifier of the related WorkSpace.</p>', 'RestoreWorkspaceRequest$WorkspaceId' => '<p>The identifier of the WorkSpace.</p>', 'StandbyWorkspace$PrimaryWorkspaceId' => '<p>The identifier of the standby WorkSpace.</p>', 'StandbyWorkspacesProperties$StandbyWorkspaceId' => '<p>The identifier of the standby WorkSpace</p>', 'StartRequest$WorkspaceId' => '<p>The identifier of the WorkSpace.</p>', 'StopRequest$WorkspaceId' => '<p>The identifier of the WorkSpace.</p>', 'TerminateRequest$WorkspaceId' => '<p>The identifier of the WorkSpace.</p>', 'Workspace$WorkspaceId' => '<p>The identifier of the WorkSpace.</p>', 'WorkspaceConnectionStatus$WorkspaceId' => '<p>The identifier of the WorkSpace.</p>', 'WorkspaceIdList$member' => NULL, 'WorkspaceResourceAssociation$WorkspaceId' => '<p>The identifier of the WorkSpace.</p>', ], ], 'WorkspaceIdList' => [ 'base' => NULL, 'refs' => [ 'DescribeWorkspacesConnectionStatusRequest$WorkspaceIds' => '<p>The identifiers of the WorkSpaces. You can specify up to 25 WorkSpaces.</p>', 'DescribeWorkspacesRequest$WorkspaceIds' => '<p>The identifiers of the WorkSpaces. You cannot combine this parameter with any other filter.</p> <p>Because the <a>CreateWorkspaces</a> operation is asynchronous, the identifier it returns is not immediately available. If you immediately call <a>DescribeWorkspaces</a> with this identifier, no information is returned.</p>', ], ], 'WorkspaceImage' => [ 'base' => '<p>Describes a WorkSpace image.</p>', 'refs' => [ 'WorkspaceImageList$member' => NULL, ], ], 'WorkspaceImageDescription' => [ 'base' => NULL, 'refs' => [ 'CopyWorkspaceImageRequest$Description' => '<p>A description of the image.</p>', 'CreateUpdatedWorkspaceImageRequest$Description' => '<p>A description of whether updates for the WorkSpace image are available.</p>', 'CreateWorkspaceImageRequest$Description' => '<p>The description of the new WorkSpace image.</p>', 'CreateWorkspaceImageResult$Description' => '<p>The description of the image.</p>', 'ImportWorkspaceImageRequest$ImageDescription' => '<p>The description of the WorkSpace image.</p>', 'WorkspaceImage$Description' => '<p>The description of the image.</p>', ], ], 'WorkspaceImageErrorCode' => [ 'base' => NULL, 'refs' => [ 'WorkspaceImage$ErrorCode' => '<p>The error code that is returned for the image.</p>', ], ], 'WorkspaceImageErrorDetailCode' => [ 'base' => NULL, 'refs' => [ 'ErrorDetails$ErrorCode' => '<p>Indicates the error code returned.</p>', ], ], 'WorkspaceImageId' => [ 'base' => NULL, 'refs' => [ 'CopyWorkspaceImageRequest$SourceImageId' => '<p>The identifier of the source image.</p>', 'CopyWorkspaceImageResult$ImageId' => '<p>The identifier of the image.</p>', 'CreateUpdatedWorkspaceImageRequest$SourceImageId' => '<p>The identifier of the source WorkSpace image.</p>', 'CreateUpdatedWorkspaceImageResult$ImageId' => '<p>The identifier of the new updated WorkSpace image.</p>', 'CreateWorkspaceBundleRequest$ImageId' => '<p>The identifier of the image that is used to create the bundle.</p>', 'CreateWorkspaceImageResult$ImageId' => '<p>The identifier of the new WorkSpace image.</p>', 'DeleteWorkspaceImageRequest$ImageId' => '<p>The identifier of the image.</p>', 'DescribeImageAssociationsRequest$ImageId' => '<p>The identifier of the image.</p>', 'DescribeWorkspaceImagePermissionsRequest$ImageId' => '<p>The identifier of the image.</p>', 'DescribeWorkspaceImagePermissionsResult$ImageId' => '<p>The identifier of the image.</p>', 'ImageResourceAssociation$ImageId' => '<p>The identifier of the image.</p>', 'ImportWorkspaceImageResult$ImageId' => '<p>The identifier of the WorkSpace image.</p>', 'UpdateWorkspaceBundleRequest$ImageId' => '<p>The identifier of the image.</p>', 'UpdateWorkspaceImagePermissionRequest$ImageId' => '<p>The identifier of the image.</p>', 'WorkspaceBundle$ImageId' => '<p>The identifier of the image that was used to create the bundle.</p>', 'WorkspaceImage$ImageId' => '<p>The identifier of the image.</p>', 'WorkspaceImageIdList$member' => NULL, ], ], 'WorkspaceImageIdList' => [ 'base' => NULL, 'refs' => [ 'DescribeWorkspaceImagesRequest$ImageIds' => '<p>The identifier of the image.</p>', ], ], 'WorkspaceImageIngestionProcess' => [ 'base' => NULL, 'refs' => [ 'ImportWorkspaceImageRequest$IngestionProcess' => '<p>The ingestion process to be used when importing the image, depending on which protocol you want to use for your BYOL Workspace image, either PCoIP, WorkSpaces Streaming Protocol (WSP), or bring your own protocol (BYOP). To use WSP, specify a value that ends in <code>_WSP</code>. To use PCoIP, specify a value that does not end in <code>_WSP</code>. To use BYOP, specify a value that ends in <code>_BYOP</code>.</p> <p>For non-GPU-enabled bundles (bundles other than Graphics or GraphicsPro), specify <code>BYOL_REGULAR</code>, <code>BYOL_REGULAR_WSP</code>, or <code>BYOL_REGULAR_BYOP</code>, depending on the protocol.</p> <note> <p>The <code>BYOL_REGULAR_BYOP</code> and <code>BYOL_GRAPHICS_G4DN_BYOP</code> values are only supported by Amazon WorkSpaces Core. Contact your account team to be allow-listed to use these values. For more information, see <a href="http://aws.amazon.com/workspaces/core/">Amazon WorkSpaces Core</a>.</p> </note>', ], ], 'WorkspaceImageList' => [ 'base' => NULL, 'refs' => [ 'DescribeWorkspaceImagesResult$Images' => '<p>Information about the images.</p>', ], ], 'WorkspaceImageName' => [ 'base' => NULL, 'refs' => [ 'CopyWorkspaceImageRequest$Name' => '<p>The name of the image.</p>', 'CreateUpdatedWorkspaceImageRequest$Name' => '<p>The name of the new updated WorkSpace image.</p>', 'CreateWorkspaceImageRequest$Name' => '<p>The name of the new WorkSpace image.</p>', 'CreateWorkspaceImageResult$Name' => '<p>The name of the image.</p>', 'ImportWorkspaceImageRequest$ImageName' => '<p>The name of the WorkSpace image.</p>', 'WorkspaceImage$Name' => '<p>The name of the image.</p>', ], ], 'WorkspaceImageRequiredTenancy' => [ 'base' => NULL, 'refs' => [ 'CreateWorkspaceImageResult$RequiredTenancy' => '<p>Specifies whether the image is running on dedicated hardware. When Bring Your Own License (BYOL) is enabled, this value is set to DEDICATED. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.htm"> Bring Your Own Windows Desktop Images.</a>.</p>', 'WorkspaceImage$RequiredTenancy' => '<p>Specifies whether the image is running on dedicated hardware. When Bring Your Own License (BYOL) is enabled, this value is set to <code>DEDICATED</code>. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html">Bring Your Own Windows Desktop Images</a>.</p>', ], ], 'WorkspaceImageState' => [ 'base' => NULL, 'refs' => [ 'CreateWorkspaceImageResult$State' => '<p>The availability status of the image.</p>', 'WorkspaceImage$State' => '<p>The status of the image.</p>', ], ], 'WorkspaceList' => [ 'base' => NULL, 'refs' => [ 'CreateWorkspacesResult$PendingRequests' => '<p>Information about the WorkSpaces that were created.</p> <p>Because this operation is asynchronous, the identifier returned is not immediately available for use with other operations. For example, if you call <a>DescribeWorkspaces</a> before the WorkSpace is created, the information returned can be incomplete.</p>', 'DescribeWorkspacesResult$Workspaces' => '<p>Information about the WorkSpaces.</p> <p>Because <a>CreateWorkspaces</a> is an asynchronous operation, some of the returned information could be incomplete.</p>', ], ], 'WorkspaceName' => [ 'base' => NULL, 'refs' => [ 'DescribeWorkspacesRequest$WorkspaceName' => '<p>The name of the user-decoupled WorkSpace.</p>', 'Workspace$WorkspaceName' => '<p>The name of the user-decoupled WorkSpace.</p>', 'WorkspaceRequest$WorkspaceName' => '<p>The name of the user-decoupled WorkSpace.</p>', ], ], 'WorkspaceProperties' => [ 'base' => '<p>Describes a WorkSpace.</p>', 'refs' => [ 'ModifyWorkspacePropertiesRequest$WorkspaceProperties' => '<p>The properties of the WorkSpace.</p>', 'Workspace$WorkspaceProperties' => '<p>The properties of the WorkSpace.</p>', 'WorkspaceRequest$WorkspaceProperties' => '<p>The WorkSpace properties.</p>', ], ], 'WorkspaceRequest' => [ 'base' => '<p>Describes the information used to create a WorkSpace.</p>', 'refs' => [ 'FailedCreateWorkspaceRequest$WorkspaceRequest' => '<p>Information about the WorkSpace.</p>', 'WorkspaceRequestList$member' => NULL, ], ], 'WorkspaceRequestList' => [ 'base' => NULL, 'refs' => [ 'CreateWorkspacesRequest$Workspaces' => '<p>The WorkSpaces to create. You can specify up to 25 WorkSpaces.</p>', ], ], 'WorkspaceResourceAssociation' => [ 'base' => '<p>Describes the association between an application and a WorkSpace resource.</p>', 'refs' => [ 'AssociateWorkspaceApplicationResult$Association' => '<p>Information about the association between the specified WorkSpace and the specified application.</p>', 'DisassociateWorkspaceApplicationResult$Association' => '<p>Information about the targeted association.</p>', 'WorkspaceResourceAssociationList$member' => NULL, ], ], 'WorkspaceResourceAssociationList' => [ 'base' => NULL, 'refs' => [ 'DescribeWorkspaceAssociationsResult$Associations' => '<p>List of information about the specified associations.</p>', 'WorkSpaceApplicationDeployment$Associations' => '<p>The associations between the applications and the associated resources.</p>', ], ], 'WorkspaceState' => [ 'base' => NULL, 'refs' => [ 'PendingCreateStandbyWorkspacesRequest$State' => '<p>The operational state of the standby WorkSpace.</p>', 'RelatedWorkspaceProperties$State' => '<p>Indicates the state of the WorkSpace.</p>', 'Workspace$State' => '<p>The operational state of the WorkSpace.</p> <ul> <li> <p> <code>PENDING</code> – The WorkSpace is in a waiting state (for example, the WorkSpace is being created).</p> </li> <li> <p> <code>AVAILABLE</code> – The WorkSpace is running and has passed the health checks.</p> </li> <li> <p> <code>IMPAIRED</code> – Refer to <code>UNHEALTHY</code> state.</p> </li> <li> <p> <code>UNHEALTHY</code> – The WorkSpace is not responding to health checks.</p> </li> <li> <p> <code>REBOOTING</code> – The WorkSpace is being rebooted (restarted).</p> </li> <li> <p> <code>STARTING</code> – The WorkSpace is starting up and health checks are being run.</p> </li> <li> <p> <code>REBUILDING</code> – The WorkSpace is being rebuilt.</p> </li> <li> <p> <code>RESTORING</code> – The WorkSpace is being restored.</p> </li> <li> <p> <code>MAINTENANCE</code> – The WorkSpace is undergoing scheduled maintenance by Amazon Web Services.</p> </li> <li> <p> <code>ADMIN_MAINTENANCE</code> – The WorkSpace is undergoing maintenance by the WorkSpaces administrator.</p> </li> <li> <p> <code>TERMINATING</code> – The WorkSpace is being deleted.</p> </li> <li> <p> <code>TERMINATED</code> – The WorkSpace has been deleted.</p> </li> <li> <p> <code>SUSPENDED</code> – The WorkSpace has been suspended for image creation.</p> </li> <li> <p> <code>UPDATING</code> – The WorkSpace is undergoing an update.</p> </li> <li> <p> <code>STOPPING</code> – The WorkSpace is being stopped.</p> </li> <li> <p> <code>STOPPED</code> – The WorkSpace has been stopped.</p> </li> <li> <p> <code>ERROR </code> – The WorkSpace is an error state (for example, an error occurred during startup).</p> </li> </ul> <note> <p>After a WorkSpace is terminated, the <code>TERMINATED</code> state is returned only briefly before the WorkSpace directory metadata is cleaned up, so this state is rarely returned. To confirm that a WorkSpace is terminated, check for the WorkSpace ID by using <a href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaces.html"> DescribeWorkSpaces</a>. If the WorkSpace ID isn\'t returned, then the WorkSpace has been successfully terminated.</p> </note>', ], ], 'WorkspaceType' => [ 'base' => NULL, 'refs' => [ 'RegisterWorkspaceDirectoryRequest$WorkspaceType' => '<p>Indicates whether the directory\'s WorkSpace type is personal or pools.</p>', 'WorkspaceDirectory$WorkspaceType' => '<p>Indicates whether the directory\'s WorkSpace type is personal or pools.</p>', ], ], 'WorkspacesDefaultRoleNotFoundException' => [ 'base' => '<p>The workspaces_DefaultRole role could not be found. If this is the first time you are registering a directory, you will need to create the workspaces_DefaultRole role before you can register a directory. For more information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/workspaces-access-control.html#create-default-role">Creating the workspaces_DefaultRole Role</a>.</p>', 'refs' => [], ], 'WorkspacesIpGroup' => [ 'base' => '<p>Describes an IP access control group.</p>', 'refs' => [ 'WorkspacesIpGroupsList$member' => NULL, ], ], 'WorkspacesIpGroupsList' => [ 'base' => NULL, 'refs' => [ 'DescribeIpGroupsResult$Result' => '<p>Information about the IP access control groups.</p>', ], ], 'WorkspacesPool' => [ 'base' => '<p>Describes a pool of WorkSpaces.</p>', 'refs' => [ 'CreateWorkspacesPoolResult$WorkspacesPool' => '<p>Indicates the pool to create.</p>', 'UpdateWorkspacesPoolResult$WorkspacesPool' => '<p>Describes the specified pool.</p>', 'WorkspacesPools$member' => NULL, ], ], 'WorkspacesPoolError' => [ 'base' => '<p>Describes a pool error.</p>', 'refs' => [ 'WorkspacesPoolErrors$member' => NULL, ], ], 'WorkspacesPoolErrorCode' => [ 'base' => NULL, 'refs' => [ 'WorkspacesPoolError$ErrorCode' => '<p>The error code.</p>', ], ], 'WorkspacesPoolErrors' => [ 'base' => NULL, 'refs' => [ 'WorkspacesPool$Errors' => '<p>The pool errors.</p>', ], ], 'WorkspacesPoolId' => [ 'base' => NULL, 'refs' => [ 'DescribeWorkspacesPoolSessionsRequest$PoolId' => '<p>The identifier of the pool.</p>', 'StartWorkspacesPoolRequest$PoolId' => '<p>The identifier of the pool.</p>', 'StopWorkspacesPoolRequest$PoolId' => '<p>The identifier of the pool.</p>', 'TerminateWorkspacesPoolRequest$PoolId' => '<p>The identifier of the pool.</p>', 'UpdateWorkspacesPoolRequest$PoolId' => '<p>The identifier of the specified pool to update.</p>', 'WorkspacesPool$PoolId' => '<p>The identifier of a pool.</p>', 'WorkspacesPoolIds$member' => NULL, 'WorkspacesPoolSession$PoolId' => '<p>The identifier of the pool.</p>', ], ], 'WorkspacesPoolIds' => [ 'base' => NULL, 'refs' => [ 'DescribeWorkspacesPoolsRequest$PoolIds' => '<p>The identifier of the WorkSpaces Pools.</p>', ], ], 'WorkspacesPoolName' => [ 'base' => NULL, 'refs' => [ 'CreateWorkspacesPoolRequest$PoolName' => '<p>The name of the pool.</p>', 'WorkspacesPool$PoolName' => '<p>The name of the pool,</p>', ], ], 'WorkspacesPoolSession' => [ 'base' => '<p>Describes a pool session.</p>', 'refs' => [ 'WorkspacesPoolSessions$member' => NULL, ], ], 'WorkspacesPoolSessions' => [ 'base' => NULL, 'refs' => [ 'DescribeWorkspacesPoolSessionsResult$Sessions' => '<p>Describes the pool sessions.</p>', ], ], 'WorkspacesPoolState' => [ 'base' => NULL, 'refs' => [ 'WorkspacesPool$State' => '<p>The current state of the pool.</p>', ], ], 'WorkspacesPoolUserId' => [ 'base' => NULL, 'refs' => [ 'DescribeWorkspacesPoolSessionsRequest$UserId' => '<p>The identifier of the user.</p>', 'WorkspacesPoolSession$UserId' => '<p>The identifier of the user.</p>', ], ], 'WorkspacesPools' => [ 'base' => NULL, 'refs' => [ 'DescribeWorkspacesPoolsResult$WorkspacesPools' => '<p>Information about the WorkSpaces Pools.</p>', ], ], ],];
